/*
 * Decompiled with CFR 0.152.
 */
package com.mythx.wrapper;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class LauncherSplash
extends JFrame {
    private static final Color BG_DARK = new Color(13, 5, 16);
    private static final Color BG_MEDIUM = new Color(26, 10, 31);
    private static final Color BG_LIGHT = new Color(42, 17, 51);
    private static final Color ACCENT_PRIMARY = new Color(155, 77, 202);
    private static final Color ACCENT_SECONDARY = new Color(100, 29, 155);
    private static final Color TEXT_PRIMARY = new Color(255, 255, 255);
    private static final Color TEXT_SECONDARY = new Color(181, 134, 151);
    private static final Color PROGRESS_BG = new Color(61, 26, 74);
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private JLabel titleLabel;
    private JPanel mainPanel;
    private int mouseX;
    private int mouseY;

    public void start() {
        Dimension size = new Dimension(450, 180);
        this.setDefaultCloseOperation(3);
        this.setUndecorated(true);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setResizable(false);
        this.setBackground(new Color(0, 0, 0, 0));
        this.mainPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(BG_DARK);
                g2.fill(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 20.0, 20.0));
                g2.setColor(BG_LIGHT);
                g2.setStroke(new BasicStroke(2.0f));
                g2.draw(new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 3, this.getHeight() - 3, 18.0, 18.0));
                g2.setColor(ACCENT_PRIMARY);
                g2.fillRoundRect(20, 8, this.getWidth() - 40, 3, 2, 2);
                g2.dispose();
            }
        };
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setOpaque(false);
        this.mainPanel.setBorder(new EmptyBorder(25, 30, 25, 30));
        this.titleLabel = new JLabel("MythX");
        this.titleLabel.setFont(new Font("Segoe UI", 1, 28));
        this.titleLabel.setForeground(ACCENT_PRIMARY);
        this.titleLabel.setAlignmentX(0.5f);
        this.statusLabel = new JLabel("Initializing...");
        this.statusLabel.setFont(new Font("Segoe UI", 0, 14));
        this.statusLabel.setForeground(TEXT_SECONDARY);
        this.statusLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setForeground(ACCENT_PRIMARY);
        this.progressBar.setBackground(PROGRESS_BG);
        this.progressBar.setPreferredSize(new Dimension(380, 12));
        this.progressBar.setMaximumSize(new Dimension(380, 12));
        this.progressBar.setAlignmentX(0.5f);
        this.progressBar.setUI(new BasicProgressBarUI(){

            @Override
            protected void paintDeterminate(Graphics g, JComponent c) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = c.getWidth();
                int height = c.getHeight();
                g2.setColor(PROGRESS_BG);
                g2.fillRoundRect(0, 0, width, height, height, height);
                int progressWidth = (int)((double)width * ((double)this.progressBar.getValue() / 100.0));
                if (progressWidth > 0) {
                    GradientPaint gradient = new GradientPaint(0.0f, 0.0f, ACCENT_PRIMARY, progressWidth, 0.0f, ACCENT_SECONDARY);
                    g2.setPaint(gradient);
                    g2.fillRoundRect(0, 0, progressWidth, height, height, height);
                }
                g2.dispose();
            }
        });
        JPanel topPanel = new JPanel(new FlowLayout(2, 0, 0));
        topPanel.setOpaque(false);
        topPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        final ImageIcon closeIcon = new ImageIcon(this.getClass().getResource("/images/close.png"));
        final ImageIcon closeHoverIcon = new ImageIcon(this.getClass().getResource("/images/close_hover.png"));
        final JLabel closeBtn = new JLabel(closeIcon);
        closeBtn.setCursor(new Cursor(12));
        closeBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                closeBtn.setIcon(closeHoverIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                closeBtn.setIcon(closeIcon);
            }
        });
        topPanel.add(closeBtn);
        this.mainPanel.add(topPanel);
        this.mainPanel.add(Box.createVerticalStrut(5));
        this.mainPanel.add(this.titleLabel);
        this.mainPanel.add(Box.createVerticalStrut(15));
        this.mainPanel.add(this.statusLabel);
        this.mainPanel.add(Box.createVerticalStrut(15));
        this.mainPanel.add(this.progressBar);
        this.setContentPane(this.mainPanel);
        this.mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LauncherSplash.this.mouseX = e.getX();
                LauncherSplash.this.mouseY = e.getY();
            }
        });
        this.mainPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                LauncherSplash.this.setLocation(e.getXOnScreen() - LauncherSplash.this.mouseX, e.getYOnScreen() - LauncherSplash.this.mouseY);
            }
        });
        this.setShape(new RoundRectangle2D.Double(0.0, 0.0, size.width, size.height, 20.0, 20.0));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void setProgress(int progress) {
        if (this.progressBar != null) {
            this.progressBar.setValue(progress);
        }
    }

    public void setProgressText(String text) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(text);
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JLabel getProgressLabel() {
        return this.statusLabel;
    }
}

