/*
 * Decompiled with CFR 0.152.
 */
package com.mythx.wrapper;

import com.mythx.wrapper.config.Config;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesReader {
    private static final Logger log = LoggerFactory.getLogger(PropertiesReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties() {
        Properties properties = new Properties();
        try (InputStream input = PropertiesReader.class.getClassLoader().getResourceAsStream("application.properties");){
            if (input == null) {
                log.info("Sorry, unable to find application.properties");
                Properties properties2 = null;
                return properties2;
            }
            properties.load(input);
            String versionUrl = properties.getProperty("launcher.version.url");
            String gameServer = properties.getProperty("game.default.server");
            Config.get().setLauncherVersionUrl(versionUrl);
            Config.get().setDefaultGameServer(gameServer);
            return properties;
        }
        catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
        }
        return properties;
    }
}

