/*
 * Decompiled with CFR 0.152.
 */
package com.mythx.wrapper.config;

import com.mythx.wrapper.model.Version;
import java.io.File;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static Config instance;
    private static final String BASE_DIR;
    private final String SAVE_DIR = System.getProperty("user.home") + File.separator;
    private String launcherVersionUrl;
    private Version localVersion;
    private Version remoteVersion;
    private String defaultGameServer;
    private boolean betaMode = false;

    private Config() {
    }

    public static Config get() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public void detectBetaMode() {
        try {
            String jarPath = Config.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            String jarName = new File(jarPath).getName().toLowerCase();
            log.info("Wrapper JAR name: {}", (Object)jarName);
            if (jarName.contains("beta")) {
                this.betaMode = true;
                log.info("Beta mode detected from filename - launcher will download beta client");
            }
        }
        catch (URISyntaxException e) {
            log.warn("Could not determine JAR filename, defaulting to production mode", e);
        }
    }

    public String getLauncherVersionUrl() {
        return this.launcherVersionUrl;
    }

    public static String getBaseDir() {
        return BASE_DIR;
    }

    public String getSAVE_DIR() {
        return this.SAVE_DIR;
    }

    public Version getLocalVersion() {
        return this.localVersion;
    }

    public Version getRemoteVersion() {
        return this.remoteVersion;
    }

    public String getDefaultGameServer() {
        return this.defaultGameServer;
    }

    public boolean isBetaMode() {
        return this.betaMode;
    }

    public void setLauncherVersionUrl(String launcherVersionUrl) {
        this.launcherVersionUrl = launcherVersionUrl;
    }

    public void setLocalVersion(Version localVersion) {
        this.localVersion = localVersion;
    }

    public void setRemoteVersion(Version remoteVersion) {
        this.remoteVersion = remoteVersion;
    }

    public void setDefaultGameServer(String defaultGameServer) {
        this.defaultGameServer = defaultGameServer;
    }

    public void setBetaMode(boolean betaMode) {
        this.betaMode = betaMode;
    }

    static {
        BASE_DIR = System.getProperty("user.home") + File.separator + ".mythx" + File.separator;
    }
}

