/*
 * Decompiled with CFR 0.152.
 */
package com.mythx.wrapper.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorController {
    private static final Logger log = LoggerFactory.getLogger(ErrorController.class);
    private static final String BASE_DIR = System.getProperty("user.home") + File.separator + ".mythx" + File.separator;
    private static final String LOGS_DIR = BASE_DIR + "logs" + File.separator + "wrapper" + File.separator;
    private static final String PROJECT_ID = "24";
    private static final String SERVICE_URL_DEFINES_IP = "https://api.ipify.org";
    private static final String ERROR_URL = "https://ecm.legion-ent.com/api/v1/logs/create-client-error-no-auth";
    private static final Path PATH_TO_ERRORS_FILE = Paths.get(LOGS_DIR, "error.log");
    private static final String CLIENT_VERSION = "1";

    public static void sendError(String username) {
        ErrorController.sendError(username, null);
    }

    public static void sendError(String username, Throwable exception) {
        String errorContent;
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            pw.flush();
            pw.close();
            errorContent = sw.toString();
            if (errorContent == null || errorContent.trim().isEmpty()) {
                errorContent = exception.getClass().getName() + ": " + exception.getMessage();
            }
            log.debug("Captured exception content (length={}): {}", (Object)(errorContent != null ? errorContent.length() : 0), (Object)(errorContent != null && errorContent.length() > 200 ? errorContent.substring(0, 200) + "..." : errorContent));
        } else {
            errorContent = ErrorController.readFileToString(PATH_TO_ERRORS_FILE);
            log.debug("Read error content from file (length={})", (Object)(errorContent != null ? errorContent.length() : 0));
        }
        if (errorContent == null || errorContent.trim().isEmpty()) {
            log.info("No errors to send");
            return;
        }
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            HttpPost error = new HttpPost(ERROR_URL);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("project_id", PROJECT_ID));
            params.add(new BasicNameValuePair("ip_address", ErrorController.getIpAddress()));
            params.add(new BasicNameValuePair("server-name", "mythx-wrapper"));
            params.add(new BasicNameValuePair("cache_version", CLIENT_VERSION));
            params.add(new BasicNameValuePair("username", username == null || username.isEmpty() ? "unknown" : username));
            params.add(new BasicNameValuePair("error_body", errorContent));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
            error.setEntity(entity);
            log.info("Sending error to API (content length: {} chars)", (Object)errorContent.length());
            CloseableHttpResponse response = closeableHttpClient.execute(error);
            log.info("Error sent to server. Status: " + response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            log.warn("Couldn't send error to API", e);
        }
    }

    public static void sendErrorAsync(String username, Throwable exception) {
        new Thread(() -> ErrorController.sendError(username, exception)).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getIpAddress() {
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(SERVICE_URL_DEFINES_IP);
            CloseableHttpResponse httpResponse = closeableHttpClient.execute(httpGet);
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            String ip = reader.readLine();
            reader.close();
            String string = ip;
            return string;
        }
        catch (IOException e) {
            log.warn("Couldn't get IP address", e);
            return "unknown";
        }
    }

    private static String readFileToString(Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            log.warn("Couldn't read error file", e);
            return null;
        }
    }
}

