/*
 * Decompiled with CFR 0.152.
 */
package com.mythx.wrapper.service;

import com.mythx.wrapper.config.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunJarService {
    private static final Logger log = LoggerFactory.getLogger(RunJarService.class);
    private static final String BASE_DIR = System.getProperty("user.home") + File.separator + ".mythx" + File.separator;
    private static final String LAUNCHER_DIR = BASE_DIR + "launcher" + File.separator;

    public static void runJar(String jarFileName) {
        log.info("Starting launcher JAR");
        File jarFile = new File(LAUNCHER_DIR + jarFileName);
        if (!jarFile.exists() || !jarFile.isFile()) {
            throw new IllegalArgumentException("JAR file not found: " + jarFile.getAbsolutePath());
        }
        boolean betaMode = Config.get().isBetaMode();
        log.info("Launching with beta mode: {}", (Object)betaMode);
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-jar");
        command.add(jarFile.getAbsolutePath());
        if (betaMode) {
            command.add("--beta");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(jarFile.getParentFile());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> log.info("Wrapper is shutting down after launching the JAR...")));
        try {
            processBuilder.inheritIO().start();
            System.exit(0);
        }
        catch (IOException e) {
            log.warn("Could not start jar", e);
        }
    }
}

