/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import io.flutter.plugin.editing.InputConnectionAdaptor;
import io.flutter.plugin.platform.PlatformViewsController;

public class TextInputPlugin {
    @NonNull
    private final View mView;
    @NonNull
    private final InputMethodManager mImm;
    @NonNull
    private final TextInputChannel textInputChannel;
    @NonNull
    private InputTarget inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
    @Nullable
    private TextInputChannel.Configuration configuration;
    @Nullable
    private Editable mEditable;
    private boolean mRestartInputPending;
    @Nullable
    private InputConnection lastInputConnection;
    @NonNull
    private PlatformViewsController platformViewsController;
    private final boolean restartAlwaysRequired;
    private boolean isInputConnectionLocked;

    public TextInputPlugin(View view, @NonNull DartExecutor dartExecutor, @NonNull PlatformViewsController platformViewsController) {
        this.mView = view;
        this.mImm = (InputMethodManager)view.getContext().getSystemService("input_method");
        this.textInputChannel = new TextInputChannel(dartExecutor);
        this.textInputChannel.setTextInputMethodHandler(new TextInputChannel.TextInputMethodHandler(){

            @Override
            public void show() {
                TextInputPlugin.this.showTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void hide() {
                TextInputPlugin.this.hideTextInput(TextInputPlugin.this.mView);
            }

            @Override
            public void setClient(int textInputClientId, TextInputChannel.Configuration configuration) {
                TextInputPlugin.this.setTextInputClient(textInputClientId, configuration);
            }

            @Override
            public void setPlatformViewClient(int platformViewId) {
                TextInputPlugin.this.setPlatformViewTextInputClient(platformViewId);
            }

            @Override
            public void setEditingState(TextInputChannel.TextEditState editingState) {
                TextInputPlugin.this.setTextInputEditingState(TextInputPlugin.this.mView, editingState);
            }

            @Override
            public void clearClient() {
                TextInputPlugin.this.clearTextInputClient();
            }
        });
        this.textInputChannel.requestExistingInputState();
        this.platformViewsController = platformViewsController;
        this.platformViewsController.attachTextInputPlugin(this);
        this.restartAlwaysRequired = this.isRestartAlwaysRequired();
    }

    @NonNull
    public InputMethodManager getInputMethodManager() {
        return this.mImm;
    }

    @VisibleForTesting
    Editable getEditable() {
        return this.mEditable;
    }

    public void lockPlatformViewInputConnection() {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            this.isInputConnectionLocked = true;
        }
    }

    public void unlockPlatformViewInputConnection() {
        this.isInputConnectionLocked = false;
    }

    public void destroy() {
        this.platformViewsController.detachTextInputPlugin();
    }

    private static int inputTypeFromTextInputType(TextInputChannel.InputType type, boolean obscureText, boolean autocorrect, boolean enableSuggestions, TextInputChannel.TextCapitalization textCapitalization) {
        if (type.type == TextInputChannel.TextInputType.DATETIME) {
            return 4;
        }
        if (type.type == TextInputChannel.TextInputType.NUMBER) {
            int textType = 2;
            if (type.isSigned) {
                textType |= 0x1000;
            }
            if (type.isDecimal) {
                textType |= 0x2000;
            }
            return textType;
        }
        if (type.type == TextInputChannel.TextInputType.PHONE) {
            return 3;
        }
        int textType = 1;
        if (type.type == TextInputChannel.TextInputType.MULTILINE) {
            textType |= 0x20000;
        } else if (type.type == TextInputChannel.TextInputType.EMAIL_ADDRESS) {
            textType |= 0x20;
        } else if (type.type == TextInputChannel.TextInputType.URL) {
            textType |= 0x10;
        } else if (type.type == TextInputChannel.TextInputType.VISIBLE_PASSWORD) {
            textType |= 0x90;
        }
        if (obscureText) {
            textType |= 0x80000;
            textType |= 0x80;
        } else {
            if (autocorrect) {
                textType |= 0x8000;
            }
            if (!enableSuggestions) {
                textType |= 0x80000;
            }
        }
        if (textCapitalization == TextInputChannel.TextCapitalization.CHARACTERS) {
            textType |= 0x1000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.WORDS) {
            textType |= 0x2000;
        } else if (textCapitalization == TextInputChannel.TextCapitalization.SENTENCES) {
            textType |= 0x4000;
        }
        return textType;
    }

    public InputConnection createInputConnection(View view, EditorInfo outAttrs) {
        if (this.inputTarget.type == InputTarget.Type.NO_TARGET) {
            this.lastInputConnection = null;
            return null;
        }
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            if (this.isInputConnectionLocked) {
                return this.lastInputConnection;
            }
            this.lastInputConnection = this.platformViewsController.getPlatformViewById(this.inputTarget.id).onCreateInputConnection(outAttrs);
            return this.lastInputConnection;
        }
        outAttrs.inputType = TextInputPlugin.inputTypeFromTextInputType(this.configuration.inputType, this.configuration.obscureText, this.configuration.autocorrect, this.configuration.enableSuggestions, this.configuration.textCapitalization);
        outAttrs.imeOptions = 0x2000000;
        int enterAction = this.configuration.inputAction == null ? ((0x20000 & outAttrs.inputType) != 0 ? 1 : 6) : this.configuration.inputAction;
        if (this.configuration.actionLabel != null) {
            outAttrs.actionLabel = this.configuration.actionLabel;
            outAttrs.actionId = enterAction;
        }
        outAttrs.imeOptions |= enterAction;
        InputConnectionAdaptor connection = new InputConnectionAdaptor(view, this.inputTarget.id, this.textInputChannel, this.mEditable);
        outAttrs.initialSelStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        outAttrs.initialSelEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        this.lastInputConnection = connection;
        return this.lastInputConnection;
    }

    @Nullable
    public InputConnection getLastInputConnection() {
        return this.lastInputConnection;
    }

    public void clearPlatformViewClient(int platformViewId) {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW && this.inputTarget.id == platformViewId) {
            this.inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
            this.hideTextInput(this.mView);
            this.mImm.restartInput(this.mView);
            this.mRestartInputPending = false;
        }
    }

    private void showTextInput(View view) {
        view.requestFocus();
        this.mImm.showSoftInput(view, 0);
    }

    private void hideTextInput(View view) {
        this.mImm.hideSoftInputFromWindow(view.getApplicationWindowToken(), 0);
    }

    @VisibleForTesting
    void setTextInputClient(int client, TextInputChannel.Configuration configuration) {
        this.inputTarget = new InputTarget(InputTarget.Type.FRAMEWORK_CLIENT, client);
        this.configuration = configuration;
        this.mEditable = Editable.Factory.getInstance().newEditable((CharSequence)"");
        this.mRestartInputPending = true;
        this.unlockPlatformViewInputConnection();
    }

    private void setPlatformViewTextInputClient(int platformViewId) {
        this.mView.requestFocus();
        this.inputTarget = new InputTarget(InputTarget.Type.PLATFORM_VIEW, platformViewId);
        this.mImm.restartInput(this.mView);
        this.mRestartInputPending = false;
    }

    private void applyStateToSelection(TextInputChannel.TextEditState state) {
        int selStart = state.selectionStart;
        int selEnd = state.selectionEnd;
        if (selStart >= 0 && selStart <= this.mEditable.length() && selEnd >= 0 && selEnd <= this.mEditable.length()) {
            Selection.setSelection((Spannable)this.mEditable, (int)selStart, (int)selEnd);
        } else {
            Selection.removeSelection((Spannable)this.mEditable);
        }
    }

    @VisibleForTesting
    void setTextInputEditingState(View view, TextInputChannel.TextEditState state) {
        if (!state.text.equals(this.mEditable.toString())) {
            this.mEditable.replace(0, this.mEditable.length(), (CharSequence)state.text);
        }
        this.applyStateToSelection(state);
        if (!this.restartAlwaysRequired && !this.mRestartInputPending) {
            this.mImm.updateSelection(this.mView, Math.max(Selection.getSelectionStart((CharSequence)this.mEditable), 0), Math.max(Selection.getSelectionEnd((CharSequence)this.mEditable), 0), BaseInputConnection.getComposingSpanStart((Spannable)this.mEditable), BaseInputConnection.getComposingSpanEnd((Spannable)this.mEditable));
        } else {
            this.mImm.restartInput(view);
            this.mRestartInputPending = false;
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean isRestartAlwaysRequired() {
        InputMethodSubtype subtype = this.mImm.getCurrentInputMethodSubtype();
        if (subtype == null || Build.VERSION.SDK_INT < 21 || !Build.MANUFACTURER.equals("samsung")) {
            return false;
        }
        String keyboardName = Settings.Secure.getString((ContentResolver)this.mView.getContext().getContentResolver(), (String)"default_input_method");
        return keyboardName.contains("Samsung");
    }

    private void clearTextInputClient() {
        if (this.inputTarget.type == InputTarget.Type.PLATFORM_VIEW) {
            return;
        }
        this.inputTarget = new InputTarget(InputTarget.Type.NO_TARGET, 0);
        this.unlockPlatformViewInputConnection();
    }

    private static class InputTarget {
        @NonNull
        Type type;
        int id;

        public InputTarget(@NonNull Type type, int id) {
            this.type = type;
            this.id = id;
        }

        static enum Type {
            NO_TARGET,
            FRAMEWORK_CLIENT,
            PLATFORM_VIEW;

        }
    }
}

