// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:front_end/src/fasta/messages.dart';
import 'package:front_end/src/fasta/parser/assert.dart';
import 'package:front_end/src/fasta/parser/declaration_kind.dart';
import 'package:front_end/src/fasta/parser/formal_parameter_kind.dart';
import 'package:front_end/src/fasta/parser/identifier_context.dart';
import 'package:front_end/src/fasta/parser/listener.dart';
import 'package:front_end/src/fasta/parser/member_kind.dart';
import 'package:front_end/src/fasta/scanner/error_token.dart';
import 'package:front_end/src/scanner/token.dart';

// THIS FILE IS AUTO GENERATED BY 'test/parser_test_listener_creator.dart'

class ParserTestListener implements Listener {
  int indent = 0;
  StringBuffer sb = new StringBuffer();

  void doPrint(String s) {
    sb.writeln(("  " * indent) + s);
  }

  Uri get uri => null;

  void logEvent(String name) {
    doPrint('logEvent(' '$name)');
  }

  set suppressParseErrors(bool value) {
    doPrint('suppressParseErrors(' '$value)');
  }

  void beginArguments(Token token) {
    doPrint('beginArguments(' '$token)');
    indent++;
  }

  void endArguments(int count, Token beginToken, Token endToken) {
    indent--;
    doPrint('endArguments(' '$count, ' '$beginToken, ' '$endToken)');
  }

  void handleAsyncModifier(Token asyncToken, Token starToken) {
    doPrint('handleAsyncModifier(' '$asyncToken, ' '$starToken)');
  }

  void beginAwaitExpression(Token token) {
    doPrint('beginAwaitExpression(' '$token)');
    indent++;
  }

  void endAwaitExpression(Token beginToken, Token endToken) {
    indent--;
    doPrint('endAwaitExpression(' '$beginToken, ' '$endToken)');
  }

  void endInvalidAwaitExpression(
      Token beginToken, Token endToken, MessageCode errorCode) {
    indent--;
    doPrint('endInvalidAwaitExpression('
        '$beginToken, '
        '$endToken, '
        '$errorCode)');
  }

  void beginBlock(Token token) {
    doPrint('beginBlock(' '$token)');
    indent++;
  }

  void endBlock(int count, Token beginToken, Token endToken) {
    indent--;
    doPrint('endBlock(' '$count, ' '$beginToken, ' '$endToken)');
  }

  void handleInvalidTopLevelBlock(Token token) {
    doPrint('handleInvalidTopLevelBlock(' '$token)');
  }

  void beginCascade(Token token) {
    doPrint('beginCascade(' '$token)');
    indent++;
  }

  void endCascade() {
    indent--;
    doPrint('endCascade()');
  }

  void beginCaseExpression(Token caseKeyword) {
    doPrint('beginCaseExpression(' '$caseKeyword)');
    indent++;
  }

  void endCaseExpression(Token colon) {
    indent--;
    doPrint('endCaseExpression(' '$colon)');
  }

  void beginClassOrMixinBody(DeclarationKind kind, Token token) {
    doPrint('beginClassOrMixinBody(' '$kind, ' '$token)');
    indent++;
  }

  void endClassOrMixinBody(
      DeclarationKind kind, int memberCount, Token beginToken, Token endToken) {
    indent--;
    doPrint('endClassOrMixinBody('
        '$kind, '
        '$memberCount, '
        '$beginToken, '
        '$endToken)');
  }

  void beginClassOrNamedMixinApplicationPrelude(Token token) {
    doPrint('beginClassOrNamedMixinApplicationPrelude(' '$token)');
    indent++;
  }

  void beginClassDeclaration(Token begin, Token abstractToken, Token name) {
    doPrint('beginClassDeclaration(' '$begin, ' '$abstractToken, ' '$name)');
    indent++;
  }

  void handleClassExtends(Token extendsKeyword) {
    doPrint('handleClassExtends(' '$extendsKeyword)');
  }

  void handleClassOrMixinImplements(
      Token implementsKeyword, int interfacesCount) {
    doPrint('handleClassOrMixinImplements('
        '$implementsKeyword, '
        '$interfacesCount)');
  }

  void handleClassHeader(Token begin, Token classKeyword, Token nativeToken) {
    doPrint('handleClassHeader(' '$begin, ' '$classKeyword, ' '$nativeToken)');
  }

  void handleRecoverClassHeader() {
    doPrint('handleRecoverClassHeader()');
  }

  void endClassDeclaration(Token beginToken, Token endToken) {
    indent--;
    doPrint('endClassDeclaration(' '$beginToken, ' '$endToken)');
  }

  void beginMixinDeclaration(Token mixinKeyword, Token name) {
    doPrint('beginMixinDeclaration(' '$mixinKeyword, ' '$name)');
    indent++;
  }

  void handleMixinOn(Token onKeyword, int typeCount) {
    doPrint('handleMixinOn(' '$onKeyword, ' '$typeCount)');
  }

  void handleMixinHeader(Token mixinKeyword) {
    doPrint('handleMixinHeader(' '$mixinKeyword)');
  }

  void handleRecoverMixinHeader() {
    doPrint('handleRecoverMixinHeader()');
  }

  void endMixinDeclaration(Token mixinKeyword, Token endToken) {
    indent--;
    doPrint('endMixinDeclaration(' '$mixinKeyword, ' '$endToken)');
  }

  void beginExtensionDeclarationPrelude(Token extensionKeyword) {
    doPrint('beginExtensionDeclarationPrelude(' '$extensionKeyword)');
    indent++;
  }

  void beginExtensionDeclaration(Token extensionKeyword, Token name) {
    doPrint('beginExtensionDeclaration(' '$extensionKeyword, ' '$name)');
    indent++;
  }

  void endExtensionDeclaration(
      Token extensionKeyword, Token onKeyword, Token token) {
    indent--;
    doPrint('endExtensionDeclaration('
        '$extensionKeyword, '
        '$onKeyword, '
        '$token)');
  }

  void beginCombinators(Token token) {
    doPrint('beginCombinators(' '$token)');
    indent++;
  }

  void endCombinators(int count) {
    indent--;
    doPrint('endCombinators(' '$count)');
  }

  void beginCompilationUnit(Token token) {
    doPrint('beginCompilationUnit(' '$token)');
    indent++;
  }

  void handleDirectivesOnly() {
    doPrint('handleDirectivesOnly()');
  }

  void endCompilationUnit(int count, Token token) {
    indent--;
    doPrint('endCompilationUnit(' '$count, ' '$token)');
  }

  void beginConstLiteral(Token token) {
    doPrint('beginConstLiteral(' '$token)');
    indent++;
  }

  void endConstLiteral(Token token) {
    indent--;
    doPrint('endConstLiteral(' '$token)');
  }

  void beginConstructorReference(Token start) {
    doPrint('beginConstructorReference(' '$start)');
    indent++;
  }

  void endConstructorReference(
      Token start, Token periodBeforeName, Token endToken) {
    indent--;
    doPrint('endConstructorReference('
        '$start, '
        '$periodBeforeName, '
        '$endToken)');
  }

  void beginDoWhileStatement(Token token) {
    doPrint('beginDoWhileStatement(' '$token)');
    indent++;
  }

  void endDoWhileStatement(
      Token doKeyword, Token whileKeyword, Token endToken) {
    indent--;
    doPrint(
        'endDoWhileStatement(' '$doKeyword, ' '$whileKeyword, ' '$endToken)');
  }

  void beginDoWhileStatementBody(Token token) {
    doPrint('beginDoWhileStatementBody(' '$token)');
    indent++;
  }

  void endDoWhileStatementBody(Token token) {
    indent--;
    doPrint('endDoWhileStatementBody(' '$token)');
  }

  void beginWhileStatementBody(Token token) {
    doPrint('beginWhileStatementBody(' '$token)');
    indent++;
  }

  void endWhileStatementBody(Token token) {
    indent--;
    doPrint('endWhileStatementBody(' '$token)');
  }

  void beginEnum(Token enumKeyword) {
    doPrint('beginEnum(' '$enumKeyword)');
    indent++;
  }

  void endEnum(Token enumKeyword, Token leftBrace, int count) {
    indent--;
    doPrint('endEnum(' '$enumKeyword, ' '$leftBrace, ' '$count)');
  }

  void beginExport(Token token) {
    doPrint('beginExport(' '$token)');
    indent++;
  }

  void endExport(Token exportKeyword, Token semicolon) {
    indent--;
    doPrint('endExport(' '$exportKeyword, ' '$semicolon)');
  }

  void handleExtraneousExpression(Token token, Message message) {
    doPrint('handleExtraneousExpression(' '$token, ' '$message)');
  }

  void handleExpressionStatement(Token token) {
    doPrint('handleExpressionStatement(' '$token)');
  }

  void beginFactoryMethod(
      Token lastConsumed, Token externalToken, Token constToken) {
    doPrint('beginFactoryMethod('
        '$lastConsumed, '
        '$externalToken, '
        '$constToken)');
    indent++;
  }

  void endClassFactoryMethod(
      Token beginToken, Token factoryKeyword, Token endToken) {
    indent--;
    doPrint('endClassFactoryMethod('
        '$beginToken, '
        '$factoryKeyword, '
        '$endToken)');
  }

  void endMixinFactoryMethod(
      Token beginToken, Token factoryKeyword, Token endToken) {
    indent--;
    doPrint('endMixinFactoryMethod('
        '$beginToken, '
        '$factoryKeyword, '
        '$endToken)');
  }

  void endExtensionFactoryMethod(
      Token beginToken, Token factoryKeyword, Token endToken) {
    indent--;
    doPrint('endExtensionFactoryMethod('
        '$beginToken, '
        '$factoryKeyword, '
        '$endToken)');
  }

  void beginFormalParameter(Token token, MemberKind kind, Token requiredToken,
      Token covariantToken, Token varFinalOrConst) {
    doPrint('beginFormalParameter('
        '$token, '
        '$kind, '
        '$requiredToken, '
        '$covariantToken, '
        '$varFinalOrConst)');
    indent++;
  }

  void endFormalParameter(
      Token thisKeyword,
      Token periodAfterThis,
      Token nameToken,
      Token initializerStart,
      Token initializerEnd,
      FormalParameterKind kind,
      MemberKind memberKind) {
    indent--;
    doPrint('endFormalParameter('
        '$thisKeyword, '
        '$periodAfterThis, '
        '$nameToken, '
        '$initializerStart, '
        '$initializerEnd, '
        '$kind, '
        '$memberKind)');
  }

  void handleNoFormalParameters(Token token, MemberKind kind) {
    doPrint('handleNoFormalParameters(' '$token, ' '$kind)');
  }

  void beginFormalParameters(Token token, MemberKind kind) {
    doPrint('beginFormalParameters(' '$token, ' '$kind)');
    indent++;
  }

  void endFormalParameters(
      int count, Token beginToken, Token endToken, MemberKind kind) {
    indent--;
    doPrint('endFormalParameters('
        '$count, '
        '$beginToken, '
        '$endToken, '
        '$kind)');
  }

  void endClassFields(Token staticToken, Token covariantToken, Token lateToken,
      Token varFinalOrConst, int count, Token beginToken, Token endToken) {
    indent--;
    doPrint('endClassFields('
        '$staticToken, '
        '$covariantToken, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$count, '
        '$beginToken, '
        '$endToken)');
  }

  void endMixinFields(Token staticToken, Token covariantToken, Token lateToken,
      Token varFinalOrConst, int count, Token beginToken, Token endToken) {
    indent--;
    doPrint('endMixinFields('
        '$staticToken, '
        '$covariantToken, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$count, '
        '$beginToken, '
        '$endToken)');
  }

  void endExtensionFields(
      Token staticToken,
      Token covariantToken,
      Token lateToken,
      Token varFinalOrConst,
      int count,
      Token beginToken,
      Token endToken) {
    indent--;
    doPrint('endExtensionFields('
        '$staticToken, '
        '$covariantToken, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$count, '
        '$beginToken, '
        '$endToken)');
  }

  void handleForInitializerEmptyStatement(Token token) {
    doPrint('handleForInitializerEmptyStatement(' '$token)');
  }

  void handleForInitializerExpressionStatement(Token token) {
    doPrint('handleForInitializerExpressionStatement(' '$token)');
  }

  void handleForInitializerLocalVariableDeclaration(Token token) {
    doPrint('handleForInitializerLocalVariableDeclaration(' '$token)');
  }

  void beginForStatement(Token token) {
    doPrint('beginForStatement(' '$token)');
    indent++;
  }

  void handleForLoopParts(Token forKeyword, Token leftParen,
      Token leftSeparator, int updateExpressionCount) {
    doPrint('handleForLoopParts('
        '$forKeyword, '
        '$leftParen, '
        '$leftSeparator, '
        '$updateExpressionCount)');
  }

  void endForStatement(Token endToken) {
    indent--;
    doPrint('endForStatement(' '$endToken)');
  }

  void beginForStatementBody(Token token) {
    doPrint('beginForStatementBody(' '$token)');
    indent++;
  }

  void endForStatementBody(Token token) {
    indent--;
    doPrint('endForStatementBody(' '$token)');
  }

  void handleForInLoopParts(Token awaitToken, Token forToken,
      Token leftParenthesis, Token inKeyword) {
    doPrint('handleForInLoopParts('
        '$awaitToken, '
        '$forToken, '
        '$leftParenthesis, '
        '$inKeyword)');
  }

  void endForIn(Token endToken) {
    indent--;
    doPrint('endForIn(' '$endToken)');
  }

  void beginForInExpression(Token token) {
    doPrint('beginForInExpression(' '$token)');
    indent++;
  }

  void endForInExpression(Token token) {
    indent--;
    doPrint('endForInExpression(' '$token)');
  }

  void beginForInBody(Token token) {
    doPrint('beginForInBody(' '$token)');
    indent++;
  }

  void endForInBody(Token token) {
    indent--;
    doPrint('endForInBody(' '$token)');
  }

  void beginNamedFunctionExpression(Token token) {
    doPrint('beginNamedFunctionExpression(' '$token)');
    indent++;
  }

  void endNamedFunctionExpression(Token endToken) {
    indent--;
    doPrint('endNamedFunctionExpression(' '$endToken)');
  }

  void beginLocalFunctionDeclaration(Token token) {
    doPrint('beginLocalFunctionDeclaration(' '$token)');
    indent++;
  }

  void endLocalFunctionDeclaration(Token endToken) {
    indent--;
    doPrint('endLocalFunctionDeclaration(' '$endToken)');
  }

  void beginBlockFunctionBody(Token token) {
    doPrint('beginBlockFunctionBody(' '$token)');
    indent++;
  }

  void endBlockFunctionBody(int count, Token beginToken, Token endToken) {
    indent--;
    doPrint('endBlockFunctionBody(' '$count, ' '$beginToken, ' '$endToken)');
  }

  void handleNoFunctionBody(Token token) {
    doPrint('handleNoFunctionBody(' '$token)');
  }

  void handleFunctionBodySkipped(Token token, bool isExpressionBody) {
    doPrint('handleFunctionBodySkipped(' '$token, ' '$isExpressionBody)');
  }

  void beginFunctionName(Token token) {
    doPrint('beginFunctionName(' '$token)');
    indent++;
  }

  void endFunctionName(Token beginToken, Token token) {
    indent--;
    doPrint('endFunctionName(' '$beginToken, ' '$token)');
  }

  void beginFunctionTypeAlias(Token token) {
    doPrint('beginFunctionTypeAlias(' '$token)');
    indent++;
  }

  void endFunctionTypeAlias(
      Token typedefKeyword, Token equals, Token endToken) {
    indent--;
    doPrint(
        'endFunctionTypeAlias(' '$typedefKeyword, ' '$equals, ' '$endToken)');
  }

  void handleClassWithClause(Token withKeyword) {
    doPrint('handleClassWithClause(' '$withKeyword)');
  }

  void handleClassNoWithClause() {
    doPrint('handleClassNoWithClause()');
  }

  void beginNamedMixinApplication(
      Token begin, Token abstractToken, Token name) {
    doPrint(
        'beginNamedMixinApplication(' '$begin, ' '$abstractToken, ' '$name)');
    indent++;
  }

  void handleNamedMixinApplicationWithClause(Token withKeyword) {
    doPrint('handleNamedMixinApplicationWithClause(' '$withKeyword)');
  }

  void endNamedMixinApplication(Token begin, Token classKeyword, Token equals,
      Token implementsKeyword, Token endToken) {
    indent--;
    doPrint('endNamedMixinApplication('
        '$begin, '
        '$classKeyword, '
        '$equals, '
        '$implementsKeyword, '
        '$endToken)');
  }

  void beginHide(Token hideKeyword) {
    doPrint('beginHide(' '$hideKeyword)');
    indent++;
  }

  void endHide(Token hideKeyword) {
    indent--;
    doPrint('endHide(' '$hideKeyword)');
  }

  void handleIdentifierList(int count) {
    doPrint('handleIdentifierList(' '$count)');
  }

  void beginTypeList(Token token) {
    doPrint('beginTypeList(' '$token)');
    indent++;
  }

  void endTypeList(int count) {
    indent--;
    doPrint('endTypeList(' '$count)');
  }

  void beginIfStatement(Token token) {
    doPrint('beginIfStatement(' '$token)');
    indent++;
  }

  void endIfStatement(Token ifToken, Token elseToken) {
    indent--;
    doPrint('endIfStatement(' '$ifToken, ' '$elseToken)');
  }

  void beginThenStatement(Token token) {
    doPrint('beginThenStatement(' '$token)');
    indent++;
  }

  void endThenStatement(Token token) {
    indent--;
    doPrint('endThenStatement(' '$token)');
  }

  void beginElseStatement(Token token) {
    doPrint('beginElseStatement(' '$token)');
    indent++;
  }

  void endElseStatement(Token token) {
    indent--;
    doPrint('endElseStatement(' '$token)');
  }

  void beginImport(Token importKeyword) {
    doPrint('beginImport(' '$importKeyword)');
    indent++;
  }

  void handleImportPrefix(Token deferredKeyword, Token asKeyword) {
    doPrint('handleImportPrefix(' '$deferredKeyword, ' '$asKeyword)');
  }

  void endImport(Token importKeyword, Token semicolon) {
    indent--;
    doPrint('endImport(' '$importKeyword, ' '$semicolon)');
  }

  void handleRecoverImport(Token semicolon) {
    doPrint('handleRecoverImport(' '$semicolon)');
  }

  void beginConditionalUris(Token token) {
    doPrint('beginConditionalUris(' '$token)');
    indent++;
  }

  void endConditionalUris(int count) {
    indent--;
    doPrint('endConditionalUris(' '$count)');
  }

  void beginConditionalUri(Token ifKeyword) {
    doPrint('beginConditionalUri(' '$ifKeyword)');
    indent++;
  }

  void endConditionalUri(Token ifKeyword, Token leftParen, Token equalSign) {
    indent--;
    doPrint('endConditionalUri(' '$ifKeyword, ' '$leftParen, ' '$equalSign)');
  }

  void handleDottedName(int count, Token firstIdentifier) {
    doPrint('handleDottedName(' '$count, ' '$firstIdentifier)');
  }

  void beginImplicitCreationExpression(Token token) {
    doPrint('beginImplicitCreationExpression(' '$token)');
    indent++;
  }

  void endImplicitCreationExpression(Token token) {
    indent--;
    doPrint('endImplicitCreationExpression(' '$token)');
  }

  void beginInitializedIdentifier(Token token) {
    doPrint('beginInitializedIdentifier(' '$token)');
    indent++;
  }

  void endInitializedIdentifier(Token nameToken) {
    indent--;
    doPrint('endInitializedIdentifier(' '$nameToken)');
  }

  void beginFieldInitializer(Token token) {
    doPrint('beginFieldInitializer(' '$token)');
    indent++;
  }

  void endFieldInitializer(Token assignment, Token token) {
    indent--;
    doPrint('endFieldInitializer(' '$assignment, ' '$token)');
  }

  void handleNoFieldInitializer(Token token) {
    doPrint('handleNoFieldInitializer(' '$token)');
  }

  void beginVariableInitializer(Token token) {
    doPrint('beginVariableInitializer(' '$token)');
    indent++;
  }

  void endVariableInitializer(Token assignmentOperator) {
    indent--;
    doPrint('endVariableInitializer(' '$assignmentOperator)');
  }

  void handleNoVariableInitializer(Token token) {
    doPrint('handleNoVariableInitializer(' '$token)');
  }

  void beginInitializer(Token token) {
    doPrint('beginInitializer(' '$token)');
    indent++;
  }

  void endInitializer(Token token) {
    indent--;
    doPrint('endInitializer(' '$token)');
  }

  void beginInitializers(Token token) {
    doPrint('beginInitializers(' '$token)');
    indent++;
  }

  void endInitializers(int count, Token beginToken, Token endToken) {
    indent--;
    doPrint('endInitializers(' '$count, ' '$beginToken, ' '$endToken)');
  }

  void handleNoInitializers() {
    doPrint('handleNoInitializers()');
  }

  void handleInvalidExpression(Token token) {
    doPrint('handleInvalidExpression(' '$token)');
  }

  void handleInvalidFunctionBody(Token token) {
    doPrint('handleInvalidFunctionBody(' '$token)');
  }

  void handleInvalidTypeReference(Token token) {
    doPrint('handleInvalidTypeReference(' '$token)');
  }

  void handleLabel(Token token) {
    doPrint('handleLabel(' '$token)');
  }

  void beginLabeledStatement(Token token, int labelCount) {
    doPrint('beginLabeledStatement(' '$token, ' '$labelCount)');
    indent++;
  }

  void endLabeledStatement(int labelCount) {
    indent--;
    doPrint('endLabeledStatement(' '$labelCount)');
  }

  void beginLibraryName(Token token) {
    doPrint('beginLibraryName(' '$token)');
    indent++;
  }

  void endLibraryName(Token libraryKeyword, Token semicolon) {
    indent--;
    doPrint('endLibraryName(' '$libraryKeyword, ' '$semicolon)');
  }

  void handleLiteralMapEntry(Token colon, Token endToken) {
    doPrint('handleLiteralMapEntry(' '$colon, ' '$endToken)');
  }

  void beginLiteralString(Token token) {
    doPrint('beginLiteralString(' '$token)');
    indent++;
  }

  void handleInterpolationExpression(Token leftBracket, Token rightBracket) {
    doPrint('handleInterpolationExpression(' '$leftBracket, ' '$rightBracket)');
  }

  void endLiteralString(int interpolationCount, Token endToken) {
    indent--;
    doPrint('endLiteralString(' '$interpolationCount, ' '$endToken)');
  }

  void handleStringJuxtaposition(int literalCount) {
    doPrint('handleStringJuxtaposition(' '$literalCount)');
  }

  void beginMember() {
    doPrint('beginMember()');
    indent++;
  }

  void handleInvalidMember(Token endToken) {
    doPrint('handleInvalidMember(' '$endToken)');
  }

  void endMember() {
    indent--;
    doPrint('endMember()');
  }

  void beginMethod(Token externalToken, Token staticToken, Token covariantToken,
      Token varFinalOrConst, Token getOrSet, Token name) {
    doPrint('beginMethod('
        '$externalToken, '
        '$staticToken, '
        '$covariantToken, '
        '$varFinalOrConst, '
        '$getOrSet, '
        '$name)');
    indent++;
  }

  void endClassMethod(Token getOrSet, Token beginToken, Token beginParam,
      Token beginInitializers, Token endToken) {
    indent--;
    doPrint('endClassMethod('
        '$getOrSet, '
        '$beginToken, '
        '$beginParam, '
        '$beginInitializers, '
        '$endToken)');
  }

  void endMixinMethod(Token getOrSet, Token beginToken, Token beginParam,
      Token beginInitializers, Token endToken) {
    indent--;
    doPrint('endMixinMethod('
        '$getOrSet, '
        '$beginToken, '
        '$beginParam, '
        '$beginInitializers, '
        '$endToken)');
  }

  void endExtensionMethod(Token getOrSet, Token beginToken, Token beginParam,
      Token beginInitializers, Token endToken) {
    indent--;
    doPrint('endExtensionMethod('
        '$getOrSet, '
        '$beginToken, '
        '$beginParam, '
        '$beginInitializers, '
        '$endToken)');
  }

  void endClassConstructor(Token getOrSet, Token beginToken, Token beginParam,
      Token beginInitializers, Token endToken) {
    indent--;
    doPrint('endClassConstructor('
        '$getOrSet, '
        '$beginToken, '
        '$beginParam, '
        '$beginInitializers, '
        '$endToken)');
  }

  void endMixinConstructor(Token getOrSet, Token beginToken, Token beginParam,
      Token beginInitializers, Token endToken) {
    indent--;
    doPrint('endMixinConstructor('
        '$getOrSet, '
        '$beginToken, '
        '$beginParam, '
        '$beginInitializers, '
        '$endToken)');
  }

  void endExtensionConstructor(Token getOrSet, Token beginToken,
      Token beginParam, Token beginInitializers, Token endToken) {
    indent--;
    doPrint('endExtensionConstructor('
        '$getOrSet, '
        '$beginToken, '
        '$beginParam, '
        '$beginInitializers, '
        '$endToken)');
  }

  void beginMetadataStar(Token token) {
    doPrint('beginMetadataStar(' '$token)');
    indent++;
  }

  void endMetadataStar(int count) {
    indent--;
    doPrint('endMetadataStar(' '$count)');
  }

  void beginMetadata(Token token) {
    doPrint('beginMetadata(' '$token)');
    indent++;
  }

  void endMetadata(Token beginToken, Token periodBeforeName, Token endToken) {
    indent--;
    doPrint('endMetadata(' '$beginToken, ' '$periodBeforeName, ' '$endToken)');
  }

  void beginOptionalFormalParameters(Token token) {
    doPrint('beginOptionalFormalParameters(' '$token)');
    indent++;
  }

  void endOptionalFormalParameters(
      int count, Token beginToken, Token endToken) {
    indent--;
    doPrint(
        'endOptionalFormalParameters(' '$count, ' '$beginToken, ' '$endToken)');
  }

  void beginPart(Token token) {
    doPrint('beginPart(' '$token)');
    indent++;
  }

  void endPart(Token partKeyword, Token semicolon) {
    indent--;
    doPrint('endPart(' '$partKeyword, ' '$semicolon)');
  }

  void beginPartOf(Token token) {
    doPrint('beginPartOf(' '$token)');
    indent++;
  }

  void endPartOf(
      Token partKeyword, Token ofKeyword, Token semicolon, bool hasName) {
    indent--;
    doPrint('endPartOf('
        '$partKeyword, '
        '$ofKeyword, '
        '$semicolon, '
        '$hasName)');
  }

  void beginRedirectingFactoryBody(Token token) {
    doPrint('beginRedirectingFactoryBody(' '$token)');
    indent++;
  }

  void endRedirectingFactoryBody(Token beginToken, Token endToken) {
    indent--;
    doPrint('endRedirectingFactoryBody(' '$beginToken, ' '$endToken)');
  }

  void beginReturnStatement(Token token) {
    doPrint('beginReturnStatement(' '$token)');
    indent++;
  }

  void handleNativeFunctionBody(Token nativeToken, Token semicolon) {
    doPrint('handleNativeFunctionBody(' '$nativeToken, ' '$semicolon)');
  }

  void handleNativeFunctionBodyIgnored(Token nativeToken, Token semicolon) {
    doPrint('handleNativeFunctionBodyIgnored(' '$nativeToken, ' '$semicolon)');
  }

  void handleNativeFunctionBodySkipped(Token nativeToken, Token semicolon) {
    doPrint('handleNativeFunctionBodySkipped(' '$nativeToken, ' '$semicolon)');
  }

  void handleEmptyFunctionBody(Token semicolon) {
    doPrint('handleEmptyFunctionBody(' '$semicolon)');
  }

  void handleExpressionFunctionBody(Token arrowToken, Token endToken) {
    doPrint('handleExpressionFunctionBody(' '$arrowToken, ' '$endToken)');
  }

  void endReturnStatement(
      bool hasExpression, Token beginToken, Token endToken) {
    indent--;
    doPrint(
        'endReturnStatement(' '$hasExpression, ' '$beginToken, ' '$endToken)');
  }

  void handleSend(Token beginToken, Token endToken) {
    doPrint('handleSend(' '$beginToken, ' '$endToken)');
  }

  void beginShow(Token showKeyword) {
    doPrint('beginShow(' '$showKeyword)');
    indent++;
  }

  void endShow(Token showKeyword) {
    indent--;
    doPrint('endShow(' '$showKeyword)');
  }

  void beginSwitchStatement(Token token) {
    doPrint('beginSwitchStatement(' '$token)');
    indent++;
  }

  void endSwitchStatement(Token switchKeyword, Token endToken) {
    indent--;
    doPrint('endSwitchStatement(' '$switchKeyword, ' '$endToken)');
  }

  void beginSwitchBlock(Token token) {
    doPrint('beginSwitchBlock(' '$token)');
    indent++;
  }

  void endSwitchBlock(int caseCount, Token beginToken, Token endToken) {
    indent--;
    doPrint('endSwitchBlock(' '$caseCount, ' '$beginToken, ' '$endToken)');
  }

  void beginLiteralSymbol(Token token) {
    doPrint('beginLiteralSymbol(' '$token)');
    indent++;
  }

  void endLiteralSymbol(Token hashToken, int identifierCount) {
    indent--;
    doPrint('endLiteralSymbol(' '$hashToken, ' '$identifierCount)');
  }

  void handleThrowExpression(Token throwToken, Token endToken) {
    doPrint('handleThrowExpression(' '$throwToken, ' '$endToken)');
  }

  void beginRethrowStatement(Token token) {
    doPrint('beginRethrowStatement(' '$token)');
    indent++;
  }

  void endRethrowStatement(Token rethrowToken, Token endToken) {
    indent--;
    doPrint('endRethrowStatement(' '$rethrowToken, ' '$endToken)');
  }

  void endTopLevelDeclaration(Token token) {
    indent--;
    doPrint('endTopLevelDeclaration(' '$token)');
  }

  void handleInvalidTopLevelDeclaration(Token endToken) {
    doPrint('handleInvalidTopLevelDeclaration(' '$endToken)');
  }

  void beginTopLevelMember(Token token) {
    doPrint('beginTopLevelMember(' '$token)');
    indent++;
  }

  void endTopLevelFields(
      Token staticToken,
      Token covariantToken,
      Token lateToken,
      Token varFinalOrConst,
      int count,
      Token beginToken,
      Token endToken) {
    indent--;
    doPrint('endTopLevelFields('
        '$staticToken, '
        '$covariantToken, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$count, '
        '$beginToken, '
        '$endToken)');
  }

  void beginTopLevelMethod(Token lastConsumed, Token externalToken) {
    doPrint('beginTopLevelMethod(' '$lastConsumed, ' '$externalToken)');
    indent++;
  }

  void endTopLevelMethod(Token beginToken, Token getOrSet, Token endToken) {
    indent--;
    doPrint('endTopLevelMethod(' '$beginToken, ' '$getOrSet, ' '$endToken)');
  }

  void beginTryStatement(Token token) {
    doPrint('beginTryStatement(' '$token)');
    indent++;
  }

  void handleCaseMatch(Token caseKeyword, Token colon) {
    doPrint('handleCaseMatch(' '$caseKeyword, ' '$colon)');
  }

  void beginCatchClause(Token token) {
    doPrint('beginCatchClause(' '$token)');
    indent++;
  }

  void endCatchClause(Token token) {
    indent--;
    doPrint('endCatchClause(' '$token)');
  }

  void handleCatchBlock(Token onKeyword, Token catchKeyword, Token comma) {
    doPrint('handleCatchBlock(' '$onKeyword, ' '$catchKeyword, ' '$comma)');
  }

  void handleFinallyBlock(Token finallyKeyword) {
    doPrint('handleFinallyBlock(' '$finallyKeyword)');
  }

  void endTryStatement(int catchCount, Token tryKeyword, Token finallyKeyword) {
    indent--;
    doPrint(
        'endTryStatement(' '$catchCount, ' '$tryKeyword, ' '$finallyKeyword)');
  }

  void handleType(Token beginToken, Token questionMark) {
    doPrint('handleType(' '$beginToken, ' '$questionMark)');
  }

  void handleNonNullAssertExpression(Token bang) {
    doPrint('handleNonNullAssertExpression(' '$bang)');
  }

  void reportErrorIfNullableType(Token questionMark) {
    doPrint('reportErrorIfNullableType(' '$questionMark)');
  }

  void reportNonNullableModifierError(Token modifierToken) {
    doPrint('reportNonNullableModifierError(' '$modifierToken)');
  }

  void reportNonNullAssertExpressionNotEnabled(Token bang) {
    doPrint('reportNonNullAssertExpressionNotEnabled(' '$bang)');
  }

  void handleNoName(Token token) {
    doPrint('handleNoName(' '$token)');
  }

  void beginFunctionType(Token beginToken) {
    doPrint('beginFunctionType(' '$beginToken)');
    indent++;
  }

  void endFunctionType(Token functionToken, Token questionMark) {
    indent--;
    doPrint('endFunctionType(' '$functionToken, ' '$questionMark)');
  }

  void beginTypeArguments(Token token) {
    doPrint('beginTypeArguments(' '$token)');
    indent++;
  }

  void endTypeArguments(int count, Token beginToken, Token endToken) {
    indent--;
    doPrint('endTypeArguments(' '$count, ' '$beginToken, ' '$endToken)');
  }

  void handleInvalidTypeArguments(Token token) {
    doPrint('handleInvalidTypeArguments(' '$token)');
  }

  void handleNoTypeArguments(Token token) {
    doPrint('handleNoTypeArguments(' '$token)');
  }

  void beginTypeVariable(Token token) {
    doPrint('beginTypeVariable(' '$token)');
    indent++;
  }

  void handleTypeVariablesDefined(Token token, int count) {
    doPrint('handleTypeVariablesDefined(' '$token, ' '$count)');
  }

  void endTypeVariable(
      Token token, int index, Token extendsOrSuper, Token variance) {
    indent--;
    doPrint('endTypeVariable('
        '$token, '
        '$index, '
        '$extendsOrSuper, '
        '$variance)');
  }

  void beginTypeVariables(Token token) {
    doPrint('beginTypeVariables(' '$token)');
    indent++;
  }

  void endTypeVariables(Token beginToken, Token endToken) {
    indent--;
    doPrint('endTypeVariables(' '$beginToken, ' '$endToken)');
  }

  void handleVarianceModifier(Token variance) {
    doPrint('handleVarianceModifier(' '$variance)');
  }

  void reportVarianceModifierNotEnabled(Token variance) {
    doPrint('reportVarianceModifierNotEnabled(' '$variance)');
  }

  void beginFunctionExpression(Token token) {
    doPrint('beginFunctionExpression(' '$token)');
    indent++;
  }

  void endFunctionExpression(Token beginToken, Token token) {
    indent--;
    doPrint('endFunctionExpression(' '$beginToken, ' '$token)');
  }

  void beginVariablesDeclaration(
      Token token, Token lateToken, Token varFinalOrConst) {
    doPrint('beginVariablesDeclaration('
        '$token, '
        '$lateToken, '
        '$varFinalOrConst)');
    indent++;
  }

  void endVariablesDeclaration(int count, Token endToken) {
    indent--;
    doPrint('endVariablesDeclaration(' '$count, ' '$endToken)');
  }

  void beginWhileStatement(Token token) {
    doPrint('beginWhileStatement(' '$token)');
    indent++;
  }

  void endWhileStatement(Token whileKeyword, Token endToken) {
    indent--;
    doPrint('endWhileStatement(' '$whileKeyword, ' '$endToken)');
  }

  void handleAsOperator(Token operator) {
    doPrint('handleAsOperator(' '$operator)');
  }

  void handleAssignmentExpression(Token token) {
    doPrint('handleAssignmentExpression(' '$token)');
  }

  void beginBinaryExpression(Token token) {
    doPrint('beginBinaryExpression(' '$token)');
    indent++;
  }

  void endBinaryExpression(Token token) {
    indent--;
    doPrint('endBinaryExpression(' '$token)');
  }

  void beginConditionalExpression(Token question) {
    doPrint('beginConditionalExpression(' '$question)');
    indent++;
  }

  void handleConditionalExpressionColon() {
    doPrint('handleConditionalExpressionColon()');
  }

  void endConditionalExpression(Token question, Token colon) {
    indent--;
    doPrint('endConditionalExpression(' '$question, ' '$colon)');
  }

  void beginConstExpression(Token constKeyword) {
    doPrint('beginConstExpression(' '$constKeyword)');
    indent++;
  }

  void endConstExpression(Token token) {
    indent--;
    doPrint('endConstExpression(' '$token)');
  }

  void beginForControlFlow(Token awaitToken, Token forToken) {
    doPrint('beginForControlFlow(' '$awaitToken, ' '$forToken)');
    indent++;
  }

  void endForControlFlow(Token token) {
    indent--;
    doPrint('endForControlFlow(' '$token)');
  }

  void endForInControlFlow(Token token) {
    indent--;
    doPrint('endForInControlFlow(' '$token)');
  }

  void beginIfControlFlow(Token ifToken) {
    doPrint('beginIfControlFlow(' '$ifToken)');
    indent++;
  }

  void beginThenControlFlow(Token token) {
    doPrint('beginThenControlFlow(' '$token)');
    indent++;
  }

  void handleElseControlFlow(Token elseToken) {
    doPrint('handleElseControlFlow(' '$elseToken)');
  }

  void endIfControlFlow(Token token) {
    indent--;
    doPrint('endIfControlFlow(' '$token)');
  }

  void endIfElseControlFlow(Token token) {
    indent--;
    doPrint('endIfElseControlFlow(' '$token)');
  }

  void handleSpreadExpression(Token spreadToken) {
    doPrint('handleSpreadExpression(' '$spreadToken)');
  }

  void beginFunctionTypedFormalParameter(Token token) {
    doPrint('beginFunctionTypedFormalParameter(' '$token)');
    indent++;
  }

  void endFunctionTypedFormalParameter(Token nameToken, Token question) {
    indent--;
    doPrint('endFunctionTypedFormalParameter(' '$nameToken, ' '$question)');
  }

  void handleIdentifier(Token token, IdentifierContext context) {
    doPrint('handleIdentifier(' '$token, ' '$context)');
  }

  void handleIndexedExpression(
      Token openSquareBracket, Token closeSquareBracket) {
    doPrint('handleIndexedExpression('
        '$openSquareBracket, '
        '$closeSquareBracket)');
  }

  void handleIsOperator(Token isOperator, Token not) {
    doPrint('handleIsOperator(' '$isOperator, ' '$not)');
  }

  void handleLiteralBool(Token token) {
    doPrint('handleLiteralBool(' '$token)');
  }

  void handleBreakStatement(
      bool hasTarget, Token breakKeyword, Token endToken) {
    doPrint(
        'handleBreakStatement(' '$hasTarget, ' '$breakKeyword, ' '$endToken)');
  }

  void handleContinueStatement(
      bool hasTarget, Token continueKeyword, Token endToken) {
    doPrint('handleContinueStatement('
        '$hasTarget, '
        '$continueKeyword, '
        '$endToken)');
  }

  void handleEmptyStatement(Token token) {
    doPrint('handleEmptyStatement(' '$token)');
  }

  void beginAssert(Token assertKeyword, Assert kind) {
    doPrint('beginAssert(' '$assertKeyword, ' '$kind)');
    indent++;
  }

  void endAssert(Token assertKeyword, Assert kind, Token leftParenthesis,
      Token commaToken, Token semicolonToken) {
    indent--;
    doPrint('endAssert('
        '$assertKeyword, '
        '$kind, '
        '$leftParenthesis, '
        '$commaToken, '
        '$semicolonToken)');
  }

  void handleLiteralDouble(Token token) {
    doPrint('handleLiteralDouble(' '$token)');
  }

  void handleLiteralInt(Token token) {
    doPrint('handleLiteralInt(' '$token)');
  }

  void handleLiteralList(
      int count, Token leftBracket, Token constKeyword, Token rightBracket) {
    doPrint('handleLiteralList('
        '$count, '
        '$leftBracket, '
        '$constKeyword, '
        '$rightBracket)');
  }

  void handleLiteralSetOrMap(
    int count,
    Token leftBrace,
    Token constKeyword,
    Token rightBrace,
    bool hasSetEntry,
  ) {
    doPrint('handleLiteralSetOrMap('
        '$count, '
        '$leftBrace, '
        '$constKeyword, '
        '$rightBrace, '
        '$hasSetEntry)');
  }

  void handleLiteralNull(Token token) {
    doPrint('handleLiteralNull(' '$token)');
  }

  void handleNativeClause(Token nativeToken, bool hasName) {
    doPrint('handleNativeClause(' '$nativeToken, ' '$hasName)');
  }

  void handleNamedArgument(Token colon) {
    doPrint('handleNamedArgument(' '$colon)');
  }

  void beginNewExpression(Token token) {
    doPrint('beginNewExpression(' '$token)');
    indent++;
  }

  void endNewExpression(Token token) {
    indent--;
    doPrint('endNewExpression(' '$token)');
  }

  void handleNoArguments(Token token) {
    doPrint('handleNoArguments(' '$token)');
  }

  void handleNoConstructorReferenceContinuationAfterTypeArguments(Token token) {
    doPrint('handleNoConstructorReferenceContinuationAfterTypeArguments('
        '$token)');
  }

  void handleNoType(Token lastConsumed) {
    doPrint('handleNoType(' '$lastConsumed)');
  }

  void handleNoTypeVariables(Token token) {
    doPrint('handleNoTypeVariables(' '$token)');
  }

  void handleOperator(Token token) {
    doPrint('handleOperator(' '$token)');
  }

  void handleSymbolVoid(Token token) {
    doPrint('handleSymbolVoid(' '$token)');
  }

  void handleOperatorName(Token operatorKeyword, Token token) {
    doPrint('handleOperatorName(' '$operatorKeyword, ' '$token)');
  }

  void handleInvalidOperatorName(Token operatorKeyword, Token token) {
    doPrint('handleInvalidOperatorName(' '$operatorKeyword, ' '$token)');
  }

  void handleParenthesizedCondition(Token token) {
    doPrint('handleParenthesizedCondition(' '$token)');
  }

  void handleParenthesizedExpression(Token token) {
    doPrint('handleParenthesizedExpression(' '$token)');
  }

  void handleQualified(Token period) {
    doPrint('handleQualified(' '$period)');
  }

  void handleStringPart(Token token) {
    doPrint('handleStringPart(' '$token)');
  }

  void handleSuperExpression(Token token, IdentifierContext context) {
    doPrint('handleSuperExpression(' '$token, ' '$context)');
  }

  void beginSwitchCase(int labelCount, int expressionCount, Token firstToken) {
    doPrint(
        'beginSwitchCase(' '$labelCount, ' '$expressionCount, ' '$firstToken)');
    indent++;
  }

  void endSwitchCase(
      int labelCount,
      int expressionCount,
      Token defaultKeyword,
      Token colonAfterDefault,
      int statementCount,
      Token firstToken,
      Token endToken) {
    indent--;
    doPrint('endSwitchCase('
        '$labelCount, '
        '$expressionCount, '
        '$defaultKeyword, '
        '$colonAfterDefault, '
        '$statementCount, '
        '$firstToken, '
        '$endToken)');
  }

  void handleThisExpression(Token token, IdentifierContext context) {
    doPrint('handleThisExpression(' '$token, ' '$context)');
  }

  void handleUnaryPostfixAssignmentExpression(Token token) {
    doPrint('handleUnaryPostfixAssignmentExpression(' '$token)');
  }

  void handleUnaryPrefixExpression(Token token) {
    doPrint('handleUnaryPrefixExpression(' '$token)');
  }

  void handleUnaryPrefixAssignmentExpression(Token token) {
    doPrint('handleUnaryPrefixAssignmentExpression(' '$token)');
  }

  void beginFormalParameterDefaultValueExpression() {
    doPrint('beginFormalParameterDefaultValueExpression()');
    indent++;
  }

  void endFormalParameterDefaultValueExpression() {
    indent--;
    doPrint('endFormalParameterDefaultValueExpression()');
  }

  void handleValuedFormalParameter(Token equals, Token token) {
    doPrint('handleValuedFormalParameter(' '$equals, ' '$token)');
  }

  void handleFormalParameterWithoutValue(Token token) {
    doPrint('handleFormalParameterWithoutValue(' '$token)');
  }

  void handleVoidKeyword(Token token) {
    doPrint('handleVoidKeyword(' '$token)');
  }

  void beginYieldStatement(Token token) {
    doPrint('beginYieldStatement(' '$token)');
    indent++;
  }

  void endYieldStatement(Token yieldToken, Token starToken, Token endToken) {
    indent--;
    doPrint('endYieldStatement(' '$yieldToken, ' '$starToken, ' '$endToken)');
  }

  void handleRecoverableError(
      Message message, Token startToken, Token endToken) {
    doPrint(
        'handleRecoverableError(' '$message, ' '$startToken, ' '$endToken)');
  }

  void handleErrorToken(ErrorToken token) {
    doPrint('handleErrorToken(' '$token)');
  }

  void handleUnescapeError(
      Message message, Token location, int stringOffset, int length) {
    doPrint('handleUnescapeError('
        '$message, '
        '$location, '
        '$stringOffset, '
        '$length)');
  }

  void handleInvalidStatement(Token token, Message message) {
    doPrint('handleInvalidStatement(' '$token, ' '$message)');
  }

  void handleScript(Token token) {
    doPrint('handleScript(' '$token)');
  }

  void discardTypeReplacedWithCommentTypeAssign() {
    doPrint('discardTypeReplacedWithCommentTypeAssign()');
  }

  void handleCommentReferenceText(String referenceSource, int referenceOffset) {
    doPrint(
        'handleCommentReferenceText(' '$referenceSource, ' '$referenceOffset)');
  }

  void handleCommentReference(
      Token newKeyword, Token prefix, Token period, Token token) {
    doPrint('handleCommentReference('
        '$newKeyword, '
        '$prefix, '
        '$period, '
        '$token)');
  }

  void handleNoCommentReference() {
    doPrint('handleNoCommentReference()');
  }
}
