// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:front_end/src/fasta/parser/listener.dart' show Listener;
import 'package:front_end/src/fasta/parser/parser.dart' show Parser;
import 'package:front_end/src/scanner/token.dart';
import 'package:front_end/src/fasta/fasta_codes.dart';
import 'package:front_end/src/fasta/scanner.dart';
import 'package:front_end/src/fasta/parser/assert.dart';
import 'package:front_end/src/fasta/parser/declaration_kind.dart';
import 'package:front_end/src/fasta/parser/directive_context.dart';
import 'package:front_end/src/fasta/parser/formal_parameter_kind.dart';
import 'package:front_end/src/fasta/parser/identifier_context.dart';
import 'package:front_end/src/fasta/parser/member_kind.dart';
import 'package:front_end/src/fasta/parser/token_stream_rewriter.dart';
import 'package:front_end/src/fasta/parser/type_info.dart';

// THIS FILE IS AUTO GENERATED BY 'test/parser_test_parser_creator.dart'

class TestParser extends Parser {
  TestParser(Listener listener) : super(listener);

  int indent = 0;
  StringBuffer sb = new StringBuffer();

  void doPrint(String s) {
    sb.writeln(("  " * indent) + s);
  }

  Uri get uri {
    doPrint('uri()');
    indent++;
    var result = super.uri;
    indent--;
    return result;
  }

  TokenStreamRewriter get rewriter {
    doPrint('rewriter()');
    indent++;
    var result = super.rewriter;
    indent--;
    return result;
  }

  bool get inGenerator {
    doPrint('inGenerator()');
    indent++;
    var result = super.inGenerator;
    indent--;
    return result;
  }

  bool get inAsync {
    doPrint('inAsync()');
    indent++;
    var result = super.inAsync;
    indent--;
    return result;
  }

  bool get inPlainSync {
    doPrint('inPlainSync()');
    indent++;
    var result = super.inPlainSync;
    indent--;
    return result;
  }

  bool get isBreakAllowed {
    doPrint('isBreakAllowed()');
    indent++;
    var result = super.isBreakAllowed;
    indent--;
    return result;
  }

  bool get isContinueAllowed {
    doPrint('isContinueAllowed()');
    indent++;
    var result = super.isContinueAllowed;
    indent--;
    return result;
  }

  bool get isContinueWithLabelAllowed {
    doPrint('isContinueWithLabelAllowed()');
    indent++;
    var result = super.isContinueWithLabelAllowed;
    indent--;
    return result;
  }

  Token parseUnit(Token token) {
    doPrint('parseUnit(' '$token)');
    indent++;
    var result = super.parseUnit(token);
    indent--;
    return result;
  }

  Token parseDirectives(Token token) {
    doPrint('parseDirectives(' '$token)');
    indent++;
    var result = super.parseDirectives(token);
    indent--;
    return result;
  }

  Token parseTopLevelDeclaration(Token token) {
    doPrint('parseTopLevelDeclaration(' '$token)');
    indent++;
    var result = super.parseTopLevelDeclaration(token);
    indent--;
    return result;
  }

  Token parseTopLevelDeclarationImpl(
      Token token, DirectiveContext directiveState) {
    doPrint('parseTopLevelDeclarationImpl(' '$token, ' '$directiveState)');
    indent++;
    var result = super.parseTopLevelDeclarationImpl(token, directiveState);
    indent--;
    return result;
  }

  Token parseClassDeclarationModifiers(Token start, Token keyword) {
    doPrint('parseClassDeclarationModifiers(' '$start, ' '$keyword)');
    indent++;
    var result = super.parseClassDeclarationModifiers(start, keyword);
    indent--;
    return result;
  }

  void parseTopLevelKeywordModifiers(Token start, Token keyword) {
    doPrint('parseTopLevelKeywordModifiers(' '$start, ' '$keyword)');
    indent++;
    var result = super.parseTopLevelKeywordModifiers(start, keyword);
    indent--;
    return result;
  }

  void reportTopLevelModifierError(Token modifier, Token afterModifiers) {
    doPrint('reportTopLevelModifierError(' '$modifier, ' '$afterModifiers)');
    indent++;
    var result = super.reportTopLevelModifierError(modifier, afterModifiers);
    indent--;
    return result;
  }

  Token parseTopLevelKeywordDeclaration(
      Token start, Token keyword, DirectiveContext directiveState) {
    doPrint('parseTopLevelKeywordDeclaration('
        '$start, '
        '$keyword, '
        '$directiveState)');
    indent++;
    var result =
        super.parseTopLevelKeywordDeclaration(start, keyword, directiveState);
    indent--;
    return result;
  }

  Token parseLibraryName(Token libraryKeyword) {
    doPrint('parseLibraryName(' '$libraryKeyword)');
    indent++;
    var result = super.parseLibraryName(libraryKeyword);
    indent--;
    return result;
  }

  Token parseImportPrefixOpt(Token token) {
    doPrint('parseImportPrefixOpt(' '$token)');
    indent++;
    var result = super.parseImportPrefixOpt(token);
    indent--;
    return result;
  }

  Token parseImport(Token importKeyword) {
    doPrint('parseImport(' '$importKeyword)');
    indent++;
    var result = super.parseImport(importKeyword);
    indent--;
    return result;
  }

  Token parseImportRecovery(Token token) {
    doPrint('parseImportRecovery(' '$token)');
    indent++;
    var result = super.parseImportRecovery(token);
    indent--;
    return result;
  }

  Token parseConditionalUriStar(Token token) {
    doPrint('parseConditionalUriStar(' '$token)');
    indent++;
    var result = super.parseConditionalUriStar(token);
    indent--;
    return result;
  }

  Token parseConditionalUri(Token token) {
    doPrint('parseConditionalUri(' '$token)');
    indent++;
    var result = super.parseConditionalUri(token);
    indent--;
    return result;
  }

  Token parseDottedName(Token token) {
    doPrint('parseDottedName(' '$token)');
    indent++;
    var result = super.parseDottedName(token);
    indent--;
    return result;
  }

  Token parseExport(Token exportKeyword) {
    doPrint('parseExport(' '$exportKeyword)');
    indent++;
    var result = super.parseExport(exportKeyword);
    indent--;
    return result;
  }

  Token parseCombinatorStar(Token token) {
    doPrint('parseCombinatorStar(' '$token)');
    indent++;
    var result = super.parseCombinatorStar(token);
    indent--;
    return result;
  }

  Token parseHide(Token token) {
    doPrint('parseHide(' '$token)');
    indent++;
    var result = super.parseHide(token);
    indent--;
    return result;
  }

  Token parseShow(Token token) {
    doPrint('parseShow(' '$token)');
    indent++;
    var result = super.parseShow(token);
    indent--;
    return result;
  }

  Token parseIdentifierList(Token token) {
    doPrint('parseIdentifierList(' '$token)');
    indent++;
    var result = super.parseIdentifierList(token);
    indent--;
    return result;
  }

  Token parseTypeList(Token token) {
    doPrint('parseTypeList(' '$token)');
    indent++;
    var result = super.parseTypeList(token);
    indent--;
    return result;
  }

  Token parsePartOrPartOf(Token partKeyword, DirectiveContext directiveState) {
    doPrint('parsePartOrPartOf(' '$partKeyword, ' '$directiveState)');
    indent++;
    var result = super.parsePartOrPartOf(partKeyword, directiveState);
    indent--;
    return result;
  }

  Token parsePart(Token partKeyword) {
    doPrint('parsePart(' '$partKeyword)');
    indent++;
    var result = super.parsePart(partKeyword);
    indent--;
    return result;
  }

  Token parsePartOf(Token partKeyword) {
    doPrint('parsePartOf(' '$partKeyword)');
    indent++;
    var result = super.parsePartOf(partKeyword);
    indent--;
    return result;
  }

  Token parseMetadataStar(Token token) {
    doPrint('parseMetadataStar(' '$token)');
    indent++;
    var result = super.parseMetadataStar(token);
    indent--;
    return result;
  }

  Token parseMetadata(Token token) {
    doPrint('parseMetadata(' '$token)');
    indent++;
    var result = super.parseMetadata(token);
    indent--;
    return result;
  }

  Token parseScript(Token token) {
    doPrint('parseScript(' '$token)');
    indent++;
    var result = super.parseScript(token);
    indent--;
    return result;
  }

  Token parseTypedef(Token typedefKeyword) {
    doPrint('parseTypedef(' '$typedefKeyword)');
    indent++;
    var result = super.parseTypedef(typedefKeyword);
    indent--;
    return result;
  }

  Token parseMixinApplicationRest(Token token) {
    doPrint('parseMixinApplicationRest(' '$token)');
    indent++;
    var result = super.parseMixinApplicationRest(token);
    indent--;
    return result;
  }

  Token parseWithClauseOpt(Token token) {
    doPrint('parseWithClauseOpt(' '$token)');
    indent++;
    var result = super.parseWithClauseOpt(token);
    indent--;
    return result;
  }

  Token parseGetterOrFormalParameters(
      Token token, Token name, bool isGetter, MemberKind kind) {
    doPrint('parseGetterOrFormalParameters('
        '$token, '
        '$name, '
        '$isGetter, '
        '$kind)');
    indent++;
    var result =
        super.parseGetterOrFormalParameters(token, name, isGetter, kind);
    indent--;
    return result;
  }

  Token parseFormalParametersOpt(Token token, MemberKind kind) {
    doPrint('parseFormalParametersOpt(' '$token, ' '$kind)');
    indent++;
    var result = super.parseFormalParametersOpt(token, kind);
    indent--;
    return result;
  }

  Token skipFormalParameters(Token token, MemberKind kind) {
    doPrint('skipFormalParameters(' '$token, ' '$kind)');
    indent++;
    var result = super.skipFormalParameters(token, kind);
    indent--;
    return result;
  }

  Token skipFormalParametersRest(Token token, MemberKind kind) {
    doPrint('skipFormalParametersRest(' '$token, ' '$kind)');
    indent++;
    var result = super.skipFormalParametersRest(token, kind);
    indent--;
    return result;
  }

  Token parseFormalParametersRequiredOpt(Token token, MemberKind kind) {
    doPrint('parseFormalParametersRequiredOpt(' '$token, ' '$kind)');
    indent++;
    var result = super.parseFormalParametersRequiredOpt(token, kind);
    indent--;
    return result;
  }

  Token parseFormalParameters(Token token, MemberKind kind) {
    doPrint('parseFormalParameters(' '$token, ' '$kind)');
    indent++;
    var result = super.parseFormalParameters(token, kind);
    indent--;
    return result;
  }

  Token parseFormalParametersRest(Token token, MemberKind kind) {
    doPrint('parseFormalParametersRest(' '$token, ' '$kind)');
    indent++;
    var result = super.parseFormalParametersRest(token, kind);
    indent--;
    return result;
  }

  Message missingParameterMessage(MemberKind kind) {
    doPrint('missingParameterMessage(' '$kind)');
    indent++;
    var result = super.missingParameterMessage(kind);
    indent--;
    return result;
  }

  Token parseFormalParameter(
      Token token, FormalParameterKind parameterKind, MemberKind memberKind) {
    doPrint(
        'parseFormalParameter(' '$token, ' '$parameterKind, ' '$memberKind)');
    indent++;
    var result = super.parseFormalParameter(token, parameterKind, memberKind);
    indent--;
    return result;
  }

  Token parseOptionalPositionalParameters(Token token, MemberKind kind) {
    doPrint('parseOptionalPositionalParameters(' '$token, ' '$kind)');
    indent++;
    var result = super.parseOptionalPositionalParameters(token, kind);
    indent--;
    return result;
  }

  Token parseOptionalNamedParameters(Token token, MemberKind kind) {
    doPrint('parseOptionalNamedParameters(' '$token, ' '$kind)');
    indent++;
    var result = super.parseOptionalNamedParameters(token, kind);
    indent--;
    return result;
  }

  Token parseQualified(Token token, IdentifierContext context,
      IdentifierContext continuationContext) {
    doPrint('parseQualified(' '$token, ' '$context, ' '$continuationContext)');
    indent++;
    var result = super.parseQualified(token, context, continuationContext);
    indent--;
    return result;
  }

  Token parseQualifiedRestOpt(
      Token token, IdentifierContext continuationContext) {
    doPrint('parseQualifiedRestOpt(' '$token, ' '$continuationContext)');
    indent++;
    var result = super.parseQualifiedRestOpt(token, continuationContext);
    indent--;
    return result;
  }

  Token parseQualifiedRest(Token token, IdentifierContext context) {
    doPrint('parseQualifiedRest(' '$token, ' '$context)');
    indent++;
    var result = super.parseQualifiedRest(token, context);
    indent--;
    return result;
  }

  Token skipBlock(Token token) {
    doPrint('skipBlock(' '$token)');
    indent++;
    var result = super.skipBlock(token);
    indent--;
    return result;
  }

  Token parseEnum(Token enumKeyword) {
    doPrint('parseEnum(' '$enumKeyword)');
    indent++;
    var result = super.parseEnum(enumKeyword);
    indent--;
    return result;
  }

  Token parseClassOrNamedMixinApplication(
      Token abstractToken, Token classKeyword) {
    doPrint('parseClassOrNamedMixinApplication('
        '$abstractToken, '
        '$classKeyword)');
    indent++;
    var result =
        super.parseClassOrNamedMixinApplication(abstractToken, classKeyword);
    indent--;
    return result;
  }

  Token parseNamedMixinApplication(
      Token token, Token begin, Token classKeyword) {
    doPrint(
        'parseNamedMixinApplication(' '$token, ' '$begin, ' '$classKeyword)');
    indent++;
    var result = super.parseNamedMixinApplication(token, begin, classKeyword);
    indent--;
    return result;
  }

  Token parseClass(
      Token token, Token begin, Token classKeyword, String className) {
    doPrint(
        'parseClass(' '$token, ' '$begin, ' '$classKeyword, ' '$className)');
    indent++;
    var result = super.parseClass(token, begin, classKeyword, className);
    indent--;
    return result;
  }

  Token parseClassHeaderOpt(Token token, Token begin, Token classKeyword) {
    doPrint('parseClassHeaderOpt(' '$token, ' '$begin, ' '$classKeyword)');
    indent++;
    var result = super.parseClassHeaderOpt(token, begin, classKeyword);
    indent--;
    return result;
  }

  Token parseClassHeaderRecovery(Token token, Token begin, Token classKeyword) {
    doPrint('parseClassHeaderRecovery(' '$token, ' '$begin, ' '$classKeyword)');
    indent++;
    var result = super.parseClassHeaderRecovery(token, begin, classKeyword);
    indent--;
    return result;
  }

  Token parseClassExtendsOpt(Token token) {
    doPrint('parseClassExtendsOpt(' '$token)');
    indent++;
    var result = super.parseClassExtendsOpt(token);
    indent--;
    return result;
  }

  Token parseClassOrMixinImplementsOpt(Token token) {
    doPrint('parseClassOrMixinImplementsOpt(' '$token)');
    indent++;
    var result = super.parseClassOrMixinImplementsOpt(token);
    indent--;
    return result;
  }

  Token parseMixin(Token mixinKeyword) {
    doPrint('parseMixin(' '$mixinKeyword)');
    indent++;
    var result = super.parseMixin(mixinKeyword);
    indent--;
    return result;
  }

  Token parseMixinHeaderOpt(Token token, Token mixinKeyword) {
    doPrint('parseMixinHeaderOpt(' '$token, ' '$mixinKeyword)');
    indent++;
    var result = super.parseMixinHeaderOpt(token, mixinKeyword);
    indent--;
    return result;
  }

  Token parseMixinHeaderRecovery(
      Token token, Token mixinKeyword, Token headerStart) {
    doPrint('parseMixinHeaderRecovery('
        '$token, '
        '$mixinKeyword, '
        '$headerStart)');
    indent++;
    var result =
        super.parseMixinHeaderRecovery(token, mixinKeyword, headerStart);
    indent--;
    return result;
  }

  Token parseMixinOnOpt(Token token) {
    doPrint('parseMixinOnOpt(' '$token)');
    indent++;
    var result = super.parseMixinOnOpt(token);
    indent--;
    return result;
  }

  Token parseMixinOn(Token token) {
    doPrint('parseMixinOn(' '$token)');
    indent++;
    var result = super.parseMixinOn(token);
    indent--;
    return result;
  }

  Token parseExtension(Token extensionKeyword) {
    doPrint('parseExtension(' '$extensionKeyword)');
    indent++;
    var result = super.parseExtension(extensionKeyword);
    indent--;
    return result;
  }

  Token parseStringPart(Token token) {
    doPrint('parseStringPart(' '$token)');
    indent++;
    var result = super.parseStringPart(token);
    indent--;
    return result;
  }

  Token insertSyntheticIdentifier(Token token, IdentifierContext context,
      {Message message, Token messageOnToken}) {
    doPrint('insertSyntheticIdentifier('
        '$token, '
        '$context, '
        'message: $message, '
        'messageOnToken: $messageOnToken)');
    indent++;
    var result = super.insertSyntheticIdentifier(token, context,
        message: message, messageOnToken: messageOnToken);
    indent--;
    return result;
  }

  Token ensureIdentifier(Token token, IdentifierContext context) {
    doPrint('ensureIdentifier(' '$token, ' '$context)');
    indent++;
    var result = super.ensureIdentifier(token, context);
    indent--;
    return result;
  }

  bool notEofOrValue(String value, Token token) {
    doPrint('notEofOrValue(' '$value, ' '$token)');
    indent++;
    var result = super.notEofOrValue(value, token);
    indent--;
    return result;
  }

  Token parseTypeVariablesOpt(Token token) {
    doPrint('parseTypeVariablesOpt(' '$token)');
    indent++;
    var result = super.parseTypeVariablesOpt(token);
    indent--;
    return result;
  }

  Token parseTopLevelMember(Token token) {
    doPrint('parseTopLevelMember(' '$token)');
    indent++;
    var result = super.parseTopLevelMember(token);
    indent--;
    return result;
  }

  Token parseTopLevelMemberImpl(Token token) {
    doPrint('parseTopLevelMemberImpl(' '$token)');
    indent++;
    var result = super.parseTopLevelMemberImpl(token);
    indent--;
    return result;
  }

  Token parseFields(
      Token beforeStart,
      Token externalToken,
      Token staticToken,
      Token covariantToken,
      Token lateToken,
      Token varFinalOrConst,
      Token beforeType,
      TypeInfo typeInfo,
      Token name,
      DeclarationKind kind) {
    doPrint('parseFields('
        '$beforeStart, '
        '$externalToken, '
        '$staticToken, '
        '$covariantToken, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$beforeType, '
        '$typeInfo, '
        '$name, '
        '$kind)');
    indent++;
    var result = super.parseFields(
        beforeStart,
        externalToken,
        staticToken,
        covariantToken,
        lateToken,
        varFinalOrConst,
        beforeType,
        typeInfo,
        name,
        kind);
    indent--;
    return result;
  }

  Token parseTopLevelMethod(Token beforeStart, Token externalToken,
      Token beforeType, TypeInfo typeInfo, Token getOrSet, Token name) {
    doPrint('parseTopLevelMethod('
        '$beforeStart, '
        '$externalToken, '
        '$beforeType, '
        '$typeInfo, '
        '$getOrSet, '
        '$name)');
    indent++;
    var result = super.parseTopLevelMethod(
        beforeStart, externalToken, beforeType, typeInfo, getOrSet, name);
    indent--;
    return result;
  }

  Token parseMethodTypeVar(Token name) {
    doPrint('parseMethodTypeVar(' '$name)');
    indent++;
    var result = super.parseMethodTypeVar(name);
    indent--;
    return result;
  }

  Token parseFieldInitializerOpt(Token token, Token name, Token lateToken,
      Token varFinalOrConst, DeclarationKind kind) {
    doPrint('parseFieldInitializerOpt('
        '$token, '
        '$name, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$kind)');
    indent++;
    var result = super.parseFieldInitializerOpt(
        token, name, lateToken, varFinalOrConst, kind);
    indent--;
    return result;
  }

  Token parseVariableInitializerOpt(Token token) {
    doPrint('parseVariableInitializerOpt(' '$token)');
    indent++;
    var result = super.parseVariableInitializerOpt(token);
    indent--;
    return result;
  }

  Token parseInitializersOpt(Token token) {
    doPrint('parseInitializersOpt(' '$token)');
    indent++;
    var result = super.parseInitializersOpt(token);
    indent--;
    return result;
  }

  Token parseInitializers(Token token) {
    doPrint('parseInitializers(' '$token)');
    indent++;
    var result = super.parseInitializers(token);
    indent--;
    return result;
  }

  Token parseInitializer(Token token) {
    doPrint('parseInitializer(' '$token)');
    indent++;
    var result = super.parseInitializer(token);
    indent--;
    return result;
  }

  Token parseSuperInitializerExpression(final Token start) {
    doPrint('parseSuperInitializerExpression(' '$start)');
    indent++;
    var result = super.parseSuperInitializerExpression(start);
    indent--;
    return result;
  }

  Token parseInitializerExpressionRest(Token token) {
    doPrint('parseInitializerExpressionRest(' '$token)');
    indent++;
    var result = super.parseInitializerExpressionRest(token);
    indent--;
    return result;
  }

  Token ensureBlock(Token token,
      Template<Message Function(Token token)> template, String blockKind) {
    doPrint('ensureBlock(' '$token, ' '$template, ' '$blockKind)');
    indent++;
    var result = super.ensureBlock(token, template, blockKind);
    indent--;
    return result;
  }

  Token insertBlock(Token token) {
    doPrint('insertBlock(' '$token)');
    indent++;
    var result = super.insertBlock(token);
    indent--;
    return result;
  }

  Token ensureCloseParen(Token token, Token openParen) {
    doPrint('ensureCloseParen(' '$token, ' '$openParen)');
    indent++;
    var result = super.ensureCloseParen(token, openParen);
    indent--;
    return result;
  }

  Token ensureColon(Token token) {
    doPrint('ensureColon(' '$token)');
    indent++;
    var result = super.ensureColon(token);
    indent--;
    return result;
  }

  Token ensureLiteralString(Token token) {
    doPrint('ensureLiteralString(' '$token)');
    indent++;
    var result = super.ensureLiteralString(token);
    indent--;
    return result;
  }

  Token ensureSemicolon(Token token) {
    doPrint('ensureSemicolon(' '$token)');
    indent++;
    var result = super.ensureSemicolon(token);
    indent--;
    return result;
  }

  Token rewriteAndRecover(Token token, Message message, Token newToken) {
    doPrint('rewriteAndRecover(' '$token, ' '$message, ' '$newToken)');
    indent++;
    var result = super.rewriteAndRecover(token, message, newToken);
    indent--;
    return result;
  }

  Token rewriteSquareBrackets(Token token) {
    doPrint('rewriteSquareBrackets(' '$token)');
    indent++;
    var result = super.rewriteSquareBrackets(token);
    indent--;
    return result;
  }

  Token skipUnexpectedTokenOpt(Token token, List<String> expectedNext) {
    doPrint('skipUnexpectedTokenOpt(' '$token, ' '$expectedNext)');
    indent++;
    var result = super.skipUnexpectedTokenOpt(token, expectedNext);
    indent--;
    return result;
  }

  Token parseNativeClause(Token token) {
    doPrint('parseNativeClause(' '$token)');
    indent++;
    var result = super.parseNativeClause(token);
    indent--;
    return result;
  }

  Token skipClassOrMixinOrExtensionBody(Token token) {
    doPrint('skipClassOrMixinOrExtensionBody(' '$token)');
    indent++;
    var result = super.skipClassOrMixinOrExtensionBody(token);
    indent--;
    return result;
  }

  Token parseClassOrMixinOrExtensionBody(
      Token token, DeclarationKind kind, String enclosingDeclarationName) {
    doPrint('parseClassOrMixinOrExtensionBody('
        '$token, '
        '$kind, '
        '$enclosingDeclarationName)');
    indent++;
    var result = super.parseClassOrMixinOrExtensionBody(
        token, kind, enclosingDeclarationName);
    indent--;
    return result;
  }

  bool isUnaryMinus(Token token) {
    doPrint('isUnaryMinus(' '$token)');
    indent++;
    var result = super.isUnaryMinus(token);
    indent--;
    return result;
  }

  Token parseClassMember(Token token, String className) {
    doPrint('parseClassMember(' '$token, ' '$className)');
    indent++;
    var result = super.parseClassMember(token, className);
    indent--;
    return result;
  }

  Token parseMixinMember(Token token, String mixinName) {
    doPrint('parseMixinMember(' '$token, ' '$mixinName)');
    indent++;
    var result = super.parseMixinMember(token, mixinName);
    indent--;
    return result;
  }

  Token parseExtensionMember(Token token, String extensionName) {
    doPrint('parseExtensionMember(' '$token, ' '$extensionName)');
    indent++;
    var result = super.parseExtensionMember(token, extensionName);
    indent--;
    return result;
  }

  Token parseClassOrMixinOrExtensionMemberImpl(
      Token token, DeclarationKind kind, String enclosingDeclarationName) {
    doPrint('parseClassOrMixinOrExtensionMemberImpl('
        '$token, '
        '$kind, '
        '$enclosingDeclarationName)');
    indent++;
    var result = super.parseClassOrMixinOrExtensionMemberImpl(
        token, kind, enclosingDeclarationName);
    indent--;
    return result;
  }

  Token parseMethod(
      Token beforeStart,
      Token externalToken,
      Token staticToken,
      Token covariantToken,
      Token lateToken,
      Token varFinalOrConst,
      Token beforeType,
      TypeInfo typeInfo,
      Token getOrSet,
      Token name,
      DeclarationKind kind,
      String enclosingDeclarationName) {
    doPrint('parseMethod('
        '$beforeStart, '
        '$externalToken, '
        '$staticToken, '
        '$covariantToken, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$beforeType, '
        '$typeInfo, '
        '$getOrSet, '
        '$name, '
        '$kind, '
        '$enclosingDeclarationName)');
    indent++;
    var result = super.parseMethod(
        beforeStart,
        externalToken,
        staticToken,
        covariantToken,
        lateToken,
        varFinalOrConst,
        beforeType,
        typeInfo,
        getOrSet,
        name,
        kind,
        enclosingDeclarationName);
    indent--;
    return result;
  }

  Token parseFactoryMethod(Token token, DeclarationKind kind, Token beforeStart,
      Token externalToken, Token staticOrCovariant, Token varFinalOrConst) {
    doPrint('parseFactoryMethod('
        '$token, '
        '$kind, '
        '$beforeStart, '
        '$externalToken, '
        '$staticOrCovariant, '
        '$varFinalOrConst)');
    indent++;
    var result = super.parseFactoryMethod(token, kind, beforeStart,
        externalToken, staticOrCovariant, varFinalOrConst);
    indent--;
    return result;
  }

  Token parseOperatorName(Token token) {
    doPrint('parseOperatorName(' '$token)');
    indent++;
    var result = super.parseOperatorName(token);
    indent--;
    return result;
  }

  Token parseFunctionExpression(Token token) {
    doPrint('parseFunctionExpression(' '$token)');
    indent++;
    var result = super.parseFunctionExpression(token);
    indent--;
    return result;
  }

  Token parseFunctionLiteral(
      Token start,
      Token beforeName,
      Token name,
      TypeInfo typeInfo,
      TypeParamOrArgInfo typeParam,
      IdentifierContext context) {
    doPrint('parseFunctionLiteral('
        '$start, '
        '$beforeName, '
        '$name, '
        '$typeInfo, '
        '$typeParam, '
        '$context)');
    indent++;
    var result = super.parseFunctionLiteral(
        start, beforeName, name, typeInfo, typeParam, context);
    indent--;
    return result;
  }

  Token parseNamedFunctionRest(
      Token beforeName, Token begin, Token formals, bool isFunctionExpression) {
    doPrint('parseNamedFunctionRest('
        '$beforeName, '
        '$begin, '
        '$formals, '
        '$isFunctionExpression)');
    indent++;
    var result = super.parseNamedFunctionRest(
        beforeName, begin, formals, isFunctionExpression);
    indent--;
    return result;
  }

  Token parseAsyncOptBody(
      Token token, bool ofFunctionExpression, bool allowAbstract) {
    doPrint('parseAsyncOptBody('
        '$token, '
        '$ofFunctionExpression, '
        '$allowAbstract)');
    indent++;
    var result =
        super.parseAsyncOptBody(token, ofFunctionExpression, allowAbstract);
    indent--;
    return result;
  }

  Token parseConstructorReference(Token token, [TypeParamOrArgInfo typeArg]) {
    doPrint('parseConstructorReference(' '$token, ' '$typeArg)');
    indent++;
    var result = super.parseConstructorReference(token, typeArg);
    indent--;
    return result;
  }

  Token parseRedirectingFactoryBody(Token token) {
    doPrint('parseRedirectingFactoryBody(' '$token)');
    indent++;
    var result = super.parseRedirectingFactoryBody(token);
    indent--;
    return result;
  }

  Token skipFunctionBody(Token token, bool isExpression, bool allowAbstract) {
    doPrint('skipFunctionBody(' '$token, ' '$isExpression, ' '$allowAbstract)');
    indent++;
    var result = super.skipFunctionBody(token, isExpression, allowAbstract);
    indent--;
    return result;
  }

  Token parseFunctionBody(
      Token token, bool ofFunctionExpression, bool allowAbstract) {
    doPrint('parseFunctionBody('
        '$token, '
        '$ofFunctionExpression, '
        '$allowAbstract)');
    indent++;
    var result =
        super.parseFunctionBody(token, ofFunctionExpression, allowAbstract);
    indent--;
    return result;
  }

  Token parseExpressionFunctionBody(Token token, bool ofFunctionExpression) {
    doPrint('parseExpressionFunctionBody(' '$token, ' '$ofFunctionExpression)');
    indent++;
    var result = super.parseExpressionFunctionBody(token, ofFunctionExpression);
    indent--;
    return result;
  }

  Token skipAsyncModifier(Token token) {
    doPrint('skipAsyncModifier(' '$token)');
    indent++;
    var result = super.skipAsyncModifier(token);
    indent--;
    return result;
  }

  Token parseAsyncModifierOpt(Token token) {
    doPrint('parseAsyncModifierOpt(' '$token)');
    indent++;
    var result = super.parseAsyncModifierOpt(token);
    indent--;
    return result;
  }

  Token parseStatement(Token token) {
    doPrint('parseStatement(' '$token)');
    indent++;
    var result = super.parseStatement(token);
    indent--;
    return result;
  }

  Token parseStatementX(Token token) {
    doPrint('parseStatementX(' '$token)');
    indent++;
    var result = super.parseStatementX(token);
    indent--;
    return result;
  }

  Token parseYieldStatement(Token token) {
    doPrint('parseYieldStatement(' '$token)');
    indent++;
    var result = super.parseYieldStatement(token);
    indent--;
    return result;
  }

  Token parseReturnStatement(Token token) {
    doPrint('parseReturnStatement(' '$token)');
    indent++;
    var result = super.parseReturnStatement(token);
    indent--;
    return result;
  }

  Token parseLabel(Token token) {
    doPrint('parseLabel(' '$token)');
    indent++;
    var result = super.parseLabel(token);
    indent--;
    return result;
  }

  Token parseLabeledStatement(Token token) {
    doPrint('parseLabeledStatement(' '$token)');
    indent++;
    var result = super.parseLabeledStatement(token);
    indent--;
    return result;
  }

  Token parseExpressionStatement(Token token) {
    doPrint('parseExpressionStatement(' '$token)');
    indent++;
    var result = super.parseExpressionStatement(token);
    indent--;
    return result;
  }

  Token parseExpression(Token token) {
    doPrint('parseExpression(' '$token)');
    indent++;
    var result = super.parseExpression(token);
    indent--;
    return result;
  }

  Token parseExpressionWithoutCascade(Token token) {
    doPrint('parseExpressionWithoutCascade(' '$token)');
    indent++;
    var result = super.parseExpressionWithoutCascade(token);
    indent--;
    return result;
  }

  Token parseConditionalExpressionRest(Token token) {
    doPrint('parseConditionalExpressionRest(' '$token)');
    indent++;
    var result = super.parseConditionalExpressionRest(token);
    indent--;
    return result;
  }

  Token parsePrecedenceExpression(
      Token token, int precedence, bool allowCascades) {
    doPrint('parsePrecedenceExpression('
        '$token, '
        '$precedence, '
        '$allowCascades)');
    indent++;
    var result =
        super.parsePrecedenceExpression(token, precedence, allowCascades);
    indent--;
    return result;
  }

  Token parseCascadeExpression(Token token) {
    doPrint('parseCascadeExpression(' '$token)');
    indent++;
    var result = super.parseCascadeExpression(token);
    indent--;
    return result;
  }

  Token parseUnaryExpression(Token token, bool allowCascades) {
    doPrint('parseUnaryExpression(' '$token, ' '$allowCascades)');
    indent++;
    var result = super.parseUnaryExpression(token, allowCascades);
    indent--;
    return result;
  }

  Token parseArgumentOrIndexStar(Token token, TypeParamOrArgInfo typeArg) {
    doPrint('parseArgumentOrIndexStar(' '$token, ' '$typeArg)');
    indent++;
    var result = super.parseArgumentOrIndexStar(token, typeArg);
    indent--;
    return result;
  }

  Token parsePrimary(Token token, IdentifierContext context) {
    doPrint('parsePrimary(' '$token, ' '$context)');
    indent++;
    var result = super.parsePrimary(token, context);
    indent--;
    return result;
  }

  Token parseParenthesizedExpressionOrFunctionLiteral(Token token) {
    doPrint('parseParenthesizedExpressionOrFunctionLiteral(' '$token)');
    indent++;
    var result = super.parseParenthesizedExpressionOrFunctionLiteral(token);
    indent--;
    return result;
  }

  Token ensureParenthesizedCondition(Token token) {
    doPrint('ensureParenthesizedCondition(' '$token)');
    indent++;
    var result = super.ensureParenthesizedCondition(token);
    indent--;
    return result;
  }

  Token parseParenthesizedExpression(Token token) {
    doPrint('parseParenthesizedExpression(' '$token)');
    indent++;
    var result = super.parseParenthesizedExpression(token);
    indent--;
    return result;
  }

  Token parseExpressionInParenthesis(Token token) {
    doPrint('parseExpressionInParenthesis(' '$token)');
    indent++;
    var result = super.parseExpressionInParenthesis(token);
    indent--;
    return result;
  }

  Token parseExpressionInParenthesisRest(Token token) {
    doPrint('parseExpressionInParenthesisRest(' '$token)');
    indent++;
    var result = super.parseExpressionInParenthesisRest(token);
    indent--;
    return result;
  }

  Token parseThisExpression(Token token, IdentifierContext context) {
    doPrint('parseThisExpression(' '$token, ' '$context)');
    indent++;
    var result = super.parseThisExpression(token, context);
    indent--;
    return result;
  }

  Token parseSuperExpression(Token token, IdentifierContext context) {
    doPrint('parseSuperExpression(' '$token, ' '$context)');
    indent++;
    var result = super.parseSuperExpression(token, context);
    indent--;
    return result;
  }

  Token parseLiteralListSuffix(Token token, Token constKeyword) {
    doPrint('parseLiteralListSuffix(' '$token, ' '$constKeyword)');
    indent++;
    var result = super.parseLiteralListSuffix(token, constKeyword);
    indent--;
    return result;
  }

  Token parseLiteralSetOrMapSuffix(Token token, Token constKeyword) {
    doPrint('parseLiteralSetOrMapSuffix(' '$token, ' '$constKeyword)');
    indent++;
    var result = super.parseLiteralSetOrMapSuffix(token, constKeyword);
    indent--;
    return result;
  }

  Token parseLiteralFunctionSuffix(Token token) {
    doPrint('parseLiteralFunctionSuffix(' '$token)');
    indent++;
    var result = super.parseLiteralFunctionSuffix(token);
    indent--;
    return result;
  }

  Token parseLiteralListSetMapOrFunction(
      final Token start, Token constKeyword) {
    doPrint('parseLiteralListSetMapOrFunction(' '$start, ' '$constKeyword)');
    indent++;
    var result = super.parseLiteralListSetMapOrFunction(start, constKeyword);
    indent--;
    return result;
  }

  Token parseMapLiteralEntry(Token token) {
    doPrint('parseMapLiteralEntry(' '$token)');
    indent++;
    var result = super.parseMapLiteralEntry(token);
    indent--;
    return result;
  }

  Token parseSendOrFunctionLiteral(Token token, IdentifierContext context) {
    doPrint('parseSendOrFunctionLiteral(' '$token, ' '$context)');
    indent++;
    var result = super.parseSendOrFunctionLiteral(token, context);
    indent--;
    return result;
  }

  Token ensureArguments(Token token) {
    doPrint('ensureArguments(' '$token)');
    indent++;
    var result = super.ensureArguments(token);
    indent--;
    return result;
  }

  Token parseConstructorInvocationArguments(Token token) {
    doPrint('parseConstructorInvocationArguments(' '$token)');
    indent++;
    var result = super.parseConstructorInvocationArguments(token);
    indent--;
    return result;
  }

  Token parseNewExpression(Token token) {
    doPrint('parseNewExpression(' '$token)');
    indent++;
    var result = super.parseNewExpression(token);
    indent--;
    return result;
  }

  Token parseImplicitCreationExpression(
      Token token, TypeParamOrArgInfo typeArg) {
    doPrint('parseImplicitCreationExpression(' '$token, ' '$typeArg)');
    indent++;
    var result = super.parseImplicitCreationExpression(token, typeArg);
    indent--;
    return result;
  }

  Token parseConstExpression(Token token) {
    doPrint('parseConstExpression(' '$token)');
    indent++;
    var result = super.parseConstExpression(token);
    indent--;
    return result;
  }

  Token parseLiteralInt(Token token) {
    doPrint('parseLiteralInt(' '$token)');
    indent++;
    var result = super.parseLiteralInt(token);
    indent--;
    return result;
  }

  Token parseLiteralDouble(Token token) {
    doPrint('parseLiteralDouble(' '$token)');
    indent++;
    var result = super.parseLiteralDouble(token);
    indent--;
    return result;
  }

  Token parseLiteralString(Token token) {
    doPrint('parseLiteralString(' '$token)');
    indent++;
    var result = super.parseLiteralString(token);
    indent--;
    return result;
  }

  Token parseLiteralSymbol(Token token) {
    doPrint('parseLiteralSymbol(' '$token)');
    indent++;
    var result = super.parseLiteralSymbol(token);
    indent--;
    return result;
  }

  Token parseSingleLiteralString(Token token) {
    doPrint('parseSingleLiteralString(' '$token)');
    indent++;
    var result = super.parseSingleLiteralString(token);
    indent--;
    return result;
  }

  Token parseIdentifierExpression(Token token) {
    doPrint('parseIdentifierExpression(' '$token)');
    indent++;
    var result = super.parseIdentifierExpression(token);
    indent--;
    return result;
  }

  Token parseLiteralBool(Token token) {
    doPrint('parseLiteralBool(' '$token)');
    indent++;
    var result = super.parseLiteralBool(token);
    indent--;
    return result;
  }

  Token parseLiteralNull(Token token) {
    doPrint('parseLiteralNull(' '$token)');
    indent++;
    var result = super.parseLiteralNull(token);
    indent--;
    return result;
  }

  Token parseSend(Token token, IdentifierContext context) {
    doPrint('parseSend(' '$token, ' '$context)');
    indent++;
    var result = super.parseSend(token, context);
    indent--;
    return result;
  }

  Token skipArgumentsOpt(Token token) {
    doPrint('skipArgumentsOpt(' '$token)');
    indent++;
    var result = super.skipArgumentsOpt(token);
    indent--;
    return result;
  }

  Token parseArgumentsOpt(Token token) {
    doPrint('parseArgumentsOpt(' '$token)');
    indent++;
    var result = super.parseArgumentsOpt(token);
    indent--;
    return result;
  }

  Token parseArguments(Token token) {
    doPrint('parseArguments(' '$token)');
    indent++;
    var result = super.parseArguments(token);
    indent--;
    return result;
  }

  Token parseArgumentsRest(Token token) {
    doPrint('parseArgumentsRest(' '$token)');
    indent++;
    var result = super.parseArgumentsRest(token);
    indent--;
    return result;
  }

  Token parseIsOperatorRest(Token token) {
    doPrint('parseIsOperatorRest(' '$token)');
    indent++;
    var result = super.parseIsOperatorRest(token);
    indent--;
    return result;
  }

  TypeInfo computeTypeAfterIsOrAs(Token token) {
    doPrint('computeTypeAfterIsOrAs(' '$token)');
    indent++;
    var result = super.computeTypeAfterIsOrAs(token);
    indent--;
    return result;
  }

  Token parseAsOperatorRest(Token token) {
    doPrint('parseAsOperatorRest(' '$token)');
    indent++;
    var result = super.parseAsOperatorRest(token);
    indent--;
    return result;
  }

  Token skipChainedAsIsOperators(Token token) {
    doPrint('skipChainedAsIsOperators(' '$token)');
    indent++;
    var result = super.skipChainedAsIsOperators(token);
    indent--;
    return result;
  }

  bool looksLikeLocalFunction(Token token) {
    doPrint('looksLikeLocalFunction(' '$token)');
    indent++;
    var result = super.looksLikeLocalFunction(token);
    indent--;
    return result;
  }

  bool looksLikeFunctionBody(Token token) {
    doPrint('looksLikeFunctionBody(' '$token)');
    indent++;
    var result = super.looksLikeFunctionBody(token);
    indent--;
    return result;
  }

  Token parseExpressionStatementOrConstDeclaration(final Token start) {
    doPrint('parseExpressionStatementOrConstDeclaration(' '$start)');
    indent++;
    var result = super.parseExpressionStatementOrConstDeclaration(start);
    indent--;
    return result;
  }

  Token parseExpressionStatementOrDeclaration(final Token start,
      [bool onlyParseVariableDeclarationStart = false]) {
    doPrint('parseExpressionStatementOrDeclaration('
        '$start, '
        '$onlyParseVariableDeclarationStart)');
    indent++;
    var result = super.parseExpressionStatementOrDeclaration(
        start, onlyParseVariableDeclarationStart);
    indent--;
    return result;
  }

  Token parseExpressionStatementOrDeclarationAfterModifiers(
      final Token beforeType,
      final Token start,
      final Token lateToken,
      Token varFinalOrConst,
      TypeInfo typeInfo,
      bool onlyParseVariableDeclarationStart) {
    doPrint('parseExpressionStatementOrDeclarationAfterModifiers('
        '$beforeType, '
        '$start, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$typeInfo, '
        '$onlyParseVariableDeclarationStart)');
    indent++;
    var result = super.parseExpressionStatementOrDeclarationAfterModifiers(
        beforeType,
        start,
        lateToken,
        varFinalOrConst,
        typeInfo,
        onlyParseVariableDeclarationStart);
    indent--;
    return result;
  }

  Token parseVariablesDeclarationRest(Token token, bool endWithSemicolon) {
    doPrint('parseVariablesDeclarationRest(' '$token, ' '$endWithSemicolon)');
    indent++;
    var result = super.parseVariablesDeclarationRest(token, endWithSemicolon);
    indent--;
    return result;
  }

  Token parseOptionallyInitializedIdentifier(Token token) {
    doPrint('parseOptionallyInitializedIdentifier(' '$token)');
    indent++;
    var result = super.parseOptionallyInitializedIdentifier(token);
    indent--;
    return result;
  }

  Token parseIfStatement(Token token) {
    doPrint('parseIfStatement(' '$token)');
    indent++;
    var result = super.parseIfStatement(token);
    indent--;
    return result;
  }

  Token parseForStatement(Token token, Token awaitToken) {
    doPrint('parseForStatement(' '$token, ' '$awaitToken)');
    indent++;
    var result = super.parseForStatement(token, awaitToken);
    indent--;
    return result;
  }

  Token parseForLoopPartsStart(Token awaitToken, Token forToken) {
    doPrint('parseForLoopPartsStart(' '$awaitToken, ' '$forToken)');
    indent++;
    var result = super.parseForLoopPartsStart(awaitToken, forToken);
    indent--;
    return result;
  }

  Token parseForLoopPartsMid(Token token, Token awaitToken, Token forToken) {
    doPrint('parseForLoopPartsMid(' '$token, ' '$awaitToken, ' '$forToken)');
    indent++;
    var result = super.parseForLoopPartsMid(token, awaitToken, forToken);
    indent--;
    return result;
  }

  Token parseForRest(Token awaitToken, Token token, Token forToken) {
    doPrint('parseForRest(' '$awaitToken, ' '$token, ' '$forToken)');
    indent++;
    var result = super.parseForRest(awaitToken, token, forToken);
    indent--;
    return result;
  }

  Token parseForLoopPartsRest(Token token, Token forToken, Token awaitToken) {
    doPrint('parseForLoopPartsRest(' '$token, ' '$forToken, ' '$awaitToken)');
    indent++;
    var result = super.parseForLoopPartsRest(token, forToken, awaitToken);
    indent--;
    return result;
  }

  Token parseForInRest(
      Token token, Token awaitToken, Token forToken, Token identifier) {
    doPrint('parseForInRest('
        '$token, '
        '$awaitToken, '
        '$forToken, '
        '$identifier)');
    indent++;
    var result = super.parseForInRest(token, awaitToken, forToken, identifier);
    indent--;
    return result;
  }

  Token parseForInLoopPartsRest(
      Token token, Token awaitToken, Token forToken, Token identifier) {
    doPrint('parseForInLoopPartsRest('
        '$token, '
        '$awaitToken, '
        '$forToken, '
        '$identifier)');
    indent++;
    var result =
        super.parseForInLoopPartsRest(token, awaitToken, forToken, identifier);
    indent--;
    return result;
  }

  Token parseWhileStatement(Token token) {
    doPrint('parseWhileStatement(' '$token)');
    indent++;
    var result = super.parseWhileStatement(token);
    indent--;
    return result;
  }

  Token parseDoWhileStatement(Token token) {
    doPrint('parseDoWhileStatement(' '$token)');
    indent++;
    var result = super.parseDoWhileStatement(token);
    indent--;
    return result;
  }

  Token parseBlock(Token token, String blockKind) {
    doPrint('parseBlock(' '$token, ' '$blockKind)');
    indent++;
    var result = super.parseBlock(token, blockKind);
    indent--;
    return result;
  }

  Token parseInvalidBlock(Token token) {
    doPrint('parseInvalidBlock(' '$token)');
    indent++;
    var result = super.parseInvalidBlock(token);
    indent--;
    return result;
  }

  bool looksLikeAwaitExpression(Token token) {
    doPrint('looksLikeAwaitExpression(' '$token)');
    indent++;
    var result = super.looksLikeAwaitExpression(token);
    indent--;
    return result;
  }

  Token parseAwaitExpression(Token token, bool allowCascades) {
    doPrint('parseAwaitExpression(' '$token, ' '$allowCascades)');
    indent++;
    var result = super.parseAwaitExpression(token, allowCascades);
    indent--;
    return result;
  }

  Token parseThrowExpression(Token token, bool allowCascades) {
    doPrint('parseThrowExpression(' '$token, ' '$allowCascades)');
    indent++;
    var result = super.parseThrowExpression(token, allowCascades);
    indent--;
    return result;
  }

  Token parseRethrowStatement(Token token) {
    doPrint('parseRethrowStatement(' '$token)');
    indent++;
    var result = super.parseRethrowStatement(token);
    indent--;
    return result;
  }

  Token parseTryStatement(Token token) {
    doPrint('parseTryStatement(' '$token)');
    indent++;
    var result = super.parseTryStatement(token);
    indent--;
    return result;
  }

  Token parseSwitchStatement(Token token) {
    doPrint('parseSwitchStatement(' '$token)');
    indent++;
    var result = super.parseSwitchStatement(token);
    indent--;
    return result;
  }

  Token parseSwitchBlock(Token token) {
    doPrint('parseSwitchBlock(' '$token)');
    indent++;
    var result = super.parseSwitchBlock(token);
    indent--;
    return result;
  }

  Token peekPastLabels(Token token) {
    doPrint('peekPastLabels(' '$token)');
    indent++;
    var result = super.peekPastLabels(token);
    indent--;
    return result;
  }

  Token parseStatementsInSwitchCase(
      Token token,
      Token peek,
      Token begin,
      int labelCount,
      int expressionCount,
      Token defaultKeyword,
      Token colonAfterDefault) {
    doPrint('parseStatementsInSwitchCase('
        '$token, '
        '$peek, '
        '$begin, '
        '$labelCount, '
        '$expressionCount, '
        '$defaultKeyword, '
        '$colonAfterDefault)');
    indent++;
    var result = super.parseStatementsInSwitchCase(token, peek, begin,
        labelCount, expressionCount, defaultKeyword, colonAfterDefault);
    indent--;
    return result;
  }

  Token parseBreakStatement(Token token) {
    doPrint('parseBreakStatement(' '$token)');
    indent++;
    var result = super.parseBreakStatement(token);
    indent--;
    return result;
  }

  Token parseAssert(Token token, Assert kind) {
    doPrint('parseAssert(' '$token, ' '$kind)');
    indent++;
    var result = super.parseAssert(token, kind);
    indent--;
    return result;
  }

  Token parseAssertStatement(Token token) {
    doPrint('parseAssertStatement(' '$token)');
    indent++;
    var result = super.parseAssertStatement(token);
    indent--;
    return result;
  }

  Token parseContinueStatement(Token token) {
    doPrint('parseContinueStatement(' '$token)');
    indent++;
    var result = super.parseContinueStatement(token);
    indent--;
    return result;
  }

  Token parseEmptyStatement(Token token) {
    doPrint('parseEmptyStatement(' '$token)');
    indent++;
    var result = super.parseEmptyStatement(token);
    indent--;
    return result;
  }

  Token previousToken(Token beforeToken, Token token) {
    doPrint('previousToken(' '$beforeToken, ' '$token)');
    indent++;
    var result = super.previousToken(beforeToken, token);
    indent--;
    return result;
  }

  Token parseInvalidOperatorDeclaration(
      Token beforeStart,
      Token externalToken,
      Token staticToken,
      Token covariantToken,
      Token lateToken,
      Token varFinalOrConst,
      Token beforeType,
      DeclarationKind kind) {
    doPrint('parseInvalidOperatorDeclaration('
        '$beforeStart, '
        '$externalToken, '
        '$staticToken, '
        '$covariantToken, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$beforeType, '
        '$kind)');
    indent++;
    var result = super.parseInvalidOperatorDeclaration(
        beforeStart,
        externalToken,
        staticToken,
        covariantToken,
        lateToken,
        varFinalOrConst,
        beforeType,
        kind);
    indent--;
    return result;
  }

  Token recoverFromInvalidMember(
      Token token,
      Token beforeStart,
      Token externalToken,
      Token staticToken,
      Token covariantToken,
      Token lateToken,
      Token varFinalOrConst,
      Token beforeType,
      TypeInfo typeInfo,
      Token getOrSet,
      DeclarationKind kind,
      String enclosingDeclarationName) {
    doPrint('recoverFromInvalidMember('
        '$token, '
        '$beforeStart, '
        '$externalToken, '
        '$staticToken, '
        '$covariantToken, '
        '$lateToken, '
        '$varFinalOrConst, '
        '$beforeType, '
        '$typeInfo, '
        '$getOrSet, '
        '$kind, '
        '$enclosingDeclarationName)');
    indent++;
    var result = super.recoverFromInvalidMember(
        token,
        beforeStart,
        externalToken,
        staticToken,
        covariantToken,
        lateToken,
        varFinalOrConst,
        beforeType,
        typeInfo,
        getOrSet,
        kind,
        enclosingDeclarationName);
    indent--;
    return result;
  }

  Token recoverFromStackOverflow(Token token) {
    doPrint('recoverFromStackOverflow(' '$token)');
    indent++;
    var result = super.recoverFromStackOverflow(token);
    indent--;
    return result;
  }

  void reportRecoverableError(Token token, Message message) {
    doPrint('reportRecoverableError(' '$token, ' '$message)');
    indent++;
    var result = super.reportRecoverableError(token, message);
    indent--;
    return result;
  }

  void reportRecoverableErrorWithToken(Token token, dynamic template) {
    doPrint('reportRecoverableErrorWithToken(' '$token, ' '$template)');
    indent++;
    var result = super.reportRecoverableErrorWithToken(token, template);
    indent--;
    return result;
  }

  Token reportAllErrorTokens(Token token) {
    doPrint('reportAllErrorTokens(' '$token)');
    indent++;
    var result = super.reportAllErrorTokens(token);
    indent--;
    return result;
  }

  Token skipErrorTokens(Token token) {
    doPrint('skipErrorTokens(' '$token)');
    indent++;
    var result = super.skipErrorTokens(token);
    indent--;
    return result;
  }

  Token parseInvalidTopLevelDeclaration(Token token) {
    doPrint('parseInvalidTopLevelDeclaration(' '$token)');
    indent++;
    var result = super.parseInvalidTopLevelDeclaration(token);
    indent--;
    return result;
  }

  Token reportAndSkipClassInClass(Token token) {
    doPrint('reportAndSkipClassInClass(' '$token)');
    indent++;
    var result = super.reportAndSkipClassInClass(token);
    indent--;
    return result;
  }

  Token reportAndSkipEnumInClass(Token token) {
    doPrint('reportAndSkipEnumInClass(' '$token)');
    indent++;
    var result = super.reportAndSkipEnumInClass(token);
    indent--;
    return result;
  }

  Token reportAndSkipTypedefInClass(Token token) {
    doPrint('reportAndSkipTypedefInClass(' '$token)');
    indent++;
    var result = super.reportAndSkipTypedefInClass(token);
    indent--;
    return result;
  }

  Token link(BeginToken beginToken, Token endToken) {
    doPrint('link(' '$beginToken, ' '$endToken)');
    indent++;
    var result = super.link(beginToken, endToken);
    indent--;
    return result;
  }

  Token syntheticPreviousToken(Token token) {
    doPrint('syntheticPreviousToken(' '$token)');
    indent++;
    var result = super.syntheticPreviousToken(token);
    indent--;
    return result;
  }

  Token findDartDoc(Token token) {
    doPrint('findDartDoc(' '$token)');
    indent++;
    var result = super.findDartDoc(token);
    indent--;
    return result;
  }

  int parseCommentReferences(Token dartdoc) {
    doPrint('parseCommentReferences(' '$dartdoc)');
    indent++;
    var result = super.parseCommentReferences(dartdoc);
    indent--;
    return result;
  }

  int parseReferencesInMultiLineComment(Token multiLineDoc) {
    doPrint('parseReferencesInMultiLineComment(' '$multiLineDoc)');
    indent++;
    var result = super.parseReferencesInMultiLineComment(multiLineDoc);
    indent--;
    return result;
  }

  int parseReferencesInSingleLineComments(Token token) {
    doPrint('parseReferencesInSingleLineComments(' '$token)');
    indent++;
    var result = super.parseReferencesInSingleLineComments(token);
    indent--;
    return result;
  }

  int parseCommentReferencesInText(Token commentToken, int start, int end) {
    doPrint(
        'parseCommentReferencesInText(' '$commentToken, ' '$start, ' '$end)');
    indent++;
    var result = super.parseCommentReferencesInText(commentToken, start, end);
    indent--;
    return result;
  }

  int findReferenceEnd(String comment, int index, int end) {
    doPrint('findReferenceEnd(' '$comment, ' '$index, ' '$end)');
    indent++;
    var result = super.findReferenceEnd(comment, index, end);
    indent--;
    return result;
  }

  bool parseOneCommentReference(Token token, int referenceOffset) {
    doPrint('parseOneCommentReference(' '$token, ' '$referenceOffset)');
    indent++;
    var result = super.parseOneCommentReference(token, referenceOffset);
    indent--;
    return result;
  }

  void parseOneCommentReferenceRest(
      Token begin,
      int referenceOffset,
      Token newKeyword,
      Token prefix,
      Token period,
      Token identifierOrOperator) {
    doPrint('parseOneCommentReferenceRest('
        '$begin, '
        '$referenceOffset, '
        '$newKeyword, '
        '$prefix, '
        '$period, '
        '$identifierOrOperator)');
    indent++;
    var result = super.parseOneCommentReferenceRest(begin, referenceOffset,
        newKeyword, prefix, period, identifierOrOperator);
    indent--;
    return result;
  }

  bool isLinkText(String comment, int rightIndex) {
    doPrint('isLinkText(' '$comment, ' '$rightIndex)');
    indent++;
    var result = super.isLinkText(comment, rightIndex);
    indent--;
    return result;
  }
}
