/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.content.Context;
import android.support.annotation.NonNull;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterEngineAndroidLifecycle;
import io.flutter.embedding.engine.FlutterEnginePluginRegistry;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.plugins.PluginRegistry;
import io.flutter.embedding.engine.plugins.activity.ActivityControlSurface;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverControlSurface;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderControlSurface;
import io.flutter.embedding.engine.plugins.service.ServiceControlSurface;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.AccessibilityChannel;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;
import io.flutter.embedding.engine.systemchannels.LifecycleChannel;
import io.flutter.embedding.engine.systemchannels.LocalizationChannel;
import io.flutter.embedding.engine.systemchannels.NavigationChannel;
import io.flutter.embedding.engine.systemchannels.PlatformChannel;
import io.flutter.embedding.engine.systemchannels.SettingsChannel;
import io.flutter.embedding.engine.systemchannels.SystemChannel;
import io.flutter.embedding.engine.systemchannels.TextInputChannel;
import java.util.HashSet;
import java.util.Set;

public class FlutterEngine
implements LifecycleOwner {
    private static final String TAG = "FlutterEngine";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final FlutterRenderer renderer;
    @NonNull
    private final DartExecutor dartExecutor;
    @NonNull
    private final FlutterEnginePluginRegistry pluginRegistry;
    @NonNull
    private final FlutterEngineAndroidLifecycle androidLifecycle;
    @NonNull
    private final AccessibilityChannel accessibilityChannel;
    @NonNull
    private final KeyEventChannel keyEventChannel;
    @NonNull
    private final LifecycleChannel lifecycleChannel;
    @NonNull
    private final LocalizationChannel localizationChannel;
    @NonNull
    private final NavigationChannel navigationChannel;
    @NonNull
    private final PlatformChannel platformChannel;
    @NonNull
    private final SettingsChannel settingsChannel;
    @NonNull
    private final SystemChannel systemChannel;
    @NonNull
    private final TextInputChannel textInputChannel;
    @NonNull
    private final Set<EngineLifecycleListener> engineLifecycleListeners = new HashSet<EngineLifecycleListener>();
    @NonNull
    private final EngineLifecycleListener engineLifecycleListener = new EngineLifecycleListener(){

        @Override
        public void onPreEngineRestart() {
            Log.v(FlutterEngine.TAG, "onPreEngineRestart()");
            for (EngineLifecycleListener lifecycleListener : FlutterEngine.this.engineLifecycleListeners) {
                lifecycleListener.onPreEngineRestart();
            }
        }
    };

    public FlutterEngine(@NonNull Context context) {
        this.flutterJNI = new FlutterJNI();
        this.flutterJNI.addEngineLifecycleListener(this.engineLifecycleListener);
        this.attachToJni();
        this.dartExecutor = new DartExecutor(this.flutterJNI);
        this.dartExecutor.onAttachedToJNI();
        this.renderer = new FlutterRenderer(this.flutterJNI);
        this.accessibilityChannel = new AccessibilityChannel(this.dartExecutor, this.flutterJNI);
        this.keyEventChannel = new KeyEventChannel(this.dartExecutor);
        this.lifecycleChannel = new LifecycleChannel(this.dartExecutor);
        this.localizationChannel = new LocalizationChannel(this.dartExecutor);
        this.navigationChannel = new NavigationChannel(this.dartExecutor);
        this.platformChannel = new PlatformChannel(this.dartExecutor);
        this.settingsChannel = new SettingsChannel(this.dartExecutor);
        this.systemChannel = new SystemChannel(this.dartExecutor);
        this.textInputChannel = new TextInputChannel(this.dartExecutor);
        this.androidLifecycle = new FlutterEngineAndroidLifecycle(this);
        this.pluginRegistry = new FlutterEnginePluginRegistry(context.getApplicationContext(), this, this.androidLifecycle);
    }

    private void attachToJni() {
        Log.v(TAG, "Attaching to JNI.");
        this.flutterJNI.attachToNative(false);
        if (!this.isAttachedToJni()) {
            throw new RuntimeException("FlutterEngine failed to attach to its native Object reference.");
        }
    }

    private boolean isAttachedToJni() {
        return this.flutterJNI.isAttached();
    }

    public void destroy() {
        Log.d(TAG, "Destroying.");
        this.pluginRegistry.destroy();
        this.dartExecutor.onDetachedFromJNI();
        this.flutterJNI.removeEngineLifecycleListener(this.engineLifecycleListener);
        this.flutterJNI.detachFromNativeAndReleaseResources();
    }

    public void addEngineLifecycleListener(@NonNull EngineLifecycleListener listener) {
        this.engineLifecycleListeners.add(listener);
    }

    public void removeEngineLifecycleListener(@NonNull EngineLifecycleListener listener) {
        this.engineLifecycleListeners.remove(listener);
    }

    @NonNull
    public DartExecutor getDartExecutor() {
        return this.dartExecutor;
    }

    @NonNull
    public FlutterRenderer getRenderer() {
        return this.renderer;
    }

    @NonNull
    public AccessibilityChannel getAccessibilityChannel() {
        return this.accessibilityChannel;
    }

    @NonNull
    public KeyEventChannel getKeyEventChannel() {
        return this.keyEventChannel;
    }

    @NonNull
    public LifecycleChannel getLifecycleChannel() {
        return this.lifecycleChannel;
    }

    @NonNull
    public LocalizationChannel getLocalizationChannel() {
        return this.localizationChannel;
    }

    @NonNull
    public NavigationChannel getNavigationChannel() {
        return this.navigationChannel;
    }

    @NonNull
    public PlatformChannel getPlatformChannel() {
        return this.platformChannel;
    }

    @NonNull
    public SettingsChannel getSettingsChannel() {
        return this.settingsChannel;
    }

    @NonNull
    public SystemChannel getSystemChannel() {
        return this.systemChannel;
    }

    @NonNull
    public TextInputChannel getTextInputChannel() {
        return this.textInputChannel;
    }

    @NonNull
    public PluginRegistry getPlugins() {
        return this.pluginRegistry;
    }

    @NonNull
    public ActivityControlSurface getActivityControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public ServiceControlSurface getServiceControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public BroadcastReceiverControlSurface getBroadcastReceiverControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public ContentProviderControlSurface getContentProviderControlSurface() {
        return this.pluginRegistry;
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.androidLifecycle;
    }

    public static interface EngineLifecycleListener {
        public void onPreEngineRestart();
    }
}

