// Compiles a dart2wasm-generated main module from `source` which can then
// instantiatable via the `instantiate` method.
//
// `source` needs to be a `Response` object (or promise thereof) e.g. created
// via the `fetch()` JS API.
export async function compileStreaming(source) {
  const builtins = {builtins: ['js-string']};
  return new CompiledApp(
      await WebAssembly.compileStreaming(source, builtins), builtins);
}

// Compiles a dart2wasm-generated wasm modules from `bytes` which is then
// instantiatable via the `instantiate` method.
export async function compile(bytes) {
  const builtins = {builtins: ['js-string']};
  return new CompiledApp(await WebAssembly.compile(bytes, builtins), builtins);
}

// DEPRECATED: Please use `compile` or `compileStreaming` to get a compiled app,
// use `instantiate` method to get an instantiated app and then call
// `invokeMain` to invoke the main function.
export async function instantiate(modulePromise, importObjectPromise) {
  var moduleOrCompiledApp = await modulePromise;
  if (!(moduleOrCompiledApp instanceof CompiledApp)) {
    moduleOrCompiledApp = new CompiledApp(moduleOrCompiledApp);
  }
  const instantiatedApp = await moduleOrCompiledApp.instantiate(await importObjectPromise);
  return instantiatedApp.instantiatedModule;
}

// DEPRECATED: Please use `compile` or `compileStreaming` to get a compiled app,
// use `instantiate` method to get an instantiated app and then call
// `invokeMain` to invoke the main function.
export const invoke = (moduleInstance, ...args) => {
  moduleInstance.exports.$invokeMain(args);
}

class CompiledApp {
  constructor(module, builtins) {
    this.module = module;
    this.builtins = builtins;
  }

  // The second argument is an options object containing:
  // `loadDeferredModule` is a JS function that takes a module name matching a
  //   wasm file produced by the dart2wasm compiler and returns the bytes to
  //   load the module. These bytes can be in either a format supported by
  //   `WebAssembly.compile` or `WebAssembly.compileStreaming`.
  // `loadDynamicModule` is a JS function that takes two string names matching,
  //   in order, a wasm file produced by the dart2wasm compiler during dynamic
  //   module compilation and a corresponding js file produced by the same
  //   compilation. It should return a JS Array containing 2 elements. The first
  //   should be the bytes for the wasm module in a format supported by
  //   `WebAssembly.compile` or `WebAssembly.compileStreaming`. The second
  //   should be the result of using the JS 'import' API on the js file path.
  // `loadDeferredId` is a JS function that takes a string corresponding to a load
  //   ID generated by the compiler when 'load-ids' option is passed. Each load
  //   ID maps to one or more WASM modules produced by the compiler. This
  //   function should return an array of byte arrays corresponding to all the
  //   modules specified by that load ID. The arrays should be in a format
  //   supported by `WebAssembly.compile` or `WebAssembly.compileStreaming`.
  async instantiate(additionalImports,
      {loadDeferredModule, loadDynamicModule, loadDeferredId} = {}) {
    let dartInstance;

    // Prints to the console
    function printToConsole(value) {
      if (typeof dartPrint == "function") {
        dartPrint(value);
        return;
      }
      if (typeof console == "object" && typeof console.log != "undefined") {
        console.log(value);
        return;
      }
      if (typeof print == "function") {
        print(value);
        return;
      }

      throw "Unable to print message: " + value;
    }

    // A special symbol attached to functions that wrap Dart functions.
    const jsWrappedDartFunctionSymbol = Symbol("JSWrappedDartFunction");

    function finalizeWrapper(dartFunction, wrapped) {
      wrapped.dartFunction = dartFunction;
      wrapped[jsWrappedDartFunctionSymbol] = true;
      return wrapped;
    }

    // Imports
    const dart2wasm = {
            _1: (decoder, codeUnits) => decoder.decode(codeUnits),
      _2: () => new TextDecoder("utf-8", {fatal: true}),
      _3: () => new TextDecoder("utf-8", {fatal: false}),
      _4: (s) => +s,
      _5: x0 => new Uint8Array(x0),
      _6: (x0,x1,x2) => x0.set(x1,x2),
      _7: (x0,x1) => x0.transferFromImageBitmap(x1),
      _9: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._9(f,arguments.length,x0) }),
      _10: x0 => new window.FinalizationRegistry(x0),
      _11: (x0,x1,x2,x3) => x0.register(x1,x2,x3),
      _12: (x0,x1) => x0.unregister(x1),
      _13: (x0,x1,x2) => x0.slice(x1,x2),
      _14: (x0,x1) => x0.decode(x1),
      _15: (x0,x1) => x0.segment(x1),
      _16: () => new TextDecoder(),
      _18: x0 => x0.buffer,
      _19: x0 => x0.wasmMemory,
      _20: () => globalThis.window._flutter_skwasmInstance,
      _21: x0 => x0.rasterStartMilliseconds,
      _22: x0 => x0.rasterEndMilliseconds,
      _23: x0 => x0.imageBitmaps,
      _129: x0 => x0.stopPropagation(),
      _130: x0 => x0.preventDefault(),
      _132: x0 => x0.remove(),
      _133: (x0,x1) => x0.append(x1),
      _134: (x0,x1,x2,x3) => x0.addEventListener(x1,x2,x3),
      _179: x0 => x0.unlock(),
      _180: x0 => x0.getReader(),
      _181: (x0,x1,x2) => x0.addEventListener(x1,x2),
      _182: (x0,x1,x2) => x0.removeEventListener(x1,x2),
      _183: (x0,x1) => x0.item(x1),
      _184: x0 => x0.next(),
      _185: x0 => x0.now(),
      _186: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._186(f,arguments.length,x0) }),
      _187: (x0,x1) => x0.addListener(x1),
      _188: (x0,x1) => x0.removeListener(x1),
      _189: (x0,x1) => x0.matchMedia(x1),
      _190: (x0,x1) => x0.revokeObjectURL(x1),
      _191: x0 => x0.close(),
      _192: (x0,x1,x2,x3,x4) => ({type: x0,data: x1,premultiplyAlpha: x2,colorSpaceConversion: x3,preferAnimation: x4}),
      _193: x0 => new window.ImageDecoder(x0),
      _194: (x0,x1) => ({frameIndex: x0,completeFramesOnly: x1}),
      _195: (x0,x1) => x0.decode(x1),
      _196: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._196(f,arguments.length,x0) }),
      _197: (x0,x1) => x0.getModifierState(x1),
      _198: (x0,x1) => x0.removeProperty(x1),
      _199: (x0,x1) => x0.prepend(x1),
      _200: x0 => new Intl.Locale(x0),
      _201: (x0,x1) => x0.observe(x1),
      _202: x0 => x0.disconnect(),
      _203: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._203(f,arguments.length,x0) }),
      _204: (x0,x1) => x0.getAttribute(x1),
      _205: (x0,x1) => x0.contains(x1),
      _206: (x0,x1) => x0.querySelector(x1),
      _207: x0 => x0.blur(),
      _208: x0 => x0.hasFocus(),
      _209: (x0,x1) => x0.removeAttribute(x1),
      _210: (x0,x1,x2) => x0.insertBefore(x1,x2),
      _211: (x0,x1) => x0.hasAttribute(x1),
      _212: (x0,x1) => x0.getModifierState(x1),
      _213: (x0,x1) => x0.createTextNode(x1),
      _214: (x0,x1) => x0.appendChild(x1),
      _215: x0 => x0.getBoundingClientRect(),
      _216: (x0,x1) => x0.closest(x1),
      _217: () => new Array(),
      _650: x0 => new Uint8Array(x0),
      _654: () => globalThis.window.flutterConfiguration,
      _656: x0 => x0.assetBase,
      _661: x0 => x0.canvasKitMaximumSurfaces,
      _662: x0 => x0.debugShowSemanticsNodes,
      _663: x0 => x0.hostElement,
      _664: x0 => x0.multiViewEnabled,
      _665: x0 => x0.nonce,
      _667: x0 => x0.fontFallbackBaseUrl,
      _677: x0 => x0.console,
      _678: x0 => x0.devicePixelRatio,
      _679: x0 => x0.document,
      _680: x0 => x0.history,
      _681: x0 => x0.innerHeight,
      _682: x0 => x0.innerWidth,
      _683: x0 => x0.location,
      _684: x0 => x0.navigator,
      _685: x0 => x0.visualViewport,
      _686: x0 => x0.performance,
      _688: x0 => x0.URL,
      _690: (x0,x1) => x0.getComputedStyle(x1),
      _691: x0 => x0.screen,
      _692: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._692(f,arguments.length,x0) }),
      _693: (x0,x1) => x0.requestAnimationFrame(x1),
      _698: (x0,x1) => x0.warn(x1),
      _700: (x0,x1) => x0.debug(x1),
      _701: x0 => globalThis.parseFloat(x0),
      _702: () => globalThis.window,
      _703: () => globalThis.Intl,
      _704: () => globalThis.Symbol,
      _705: (x0,x1,x2,x3,x4) => globalThis.createImageBitmap(x0,x1,x2,x3,x4),
      _707: x0 => x0.clipboard,
      _708: x0 => x0.maxTouchPoints,
      _709: x0 => x0.vendor,
      _710: x0 => x0.language,
      _711: x0 => x0.platform,
      _712: x0 => x0.userAgent,
      _713: (x0,x1) => x0.vibrate(x1),
      _714: x0 => x0.languages,
      _715: x0 => x0.documentElement,
      _716: (x0,x1) => x0.querySelector(x1),
      _719: (x0,x1) => x0.createElement(x1),
      _722: (x0,x1) => x0.createEvent(x1),
      _723: x0 => x0.activeElement,
      _726: x0 => x0.head,
      _727: x0 => x0.body,
      _728: (x0,x1) => { x0.title = x1 },
      _732: x0 => x0.visibilityState,
      _733: () => globalThis.document,
      _734: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._734(f,arguments.length,x0) }),
      _735: (x0,x1) => x0.dispatchEvent(x1),
      _743: x0 => x0.target,
      _745: x0 => x0.timeStamp,
      _746: x0 => x0.type,
      _748: (x0,x1,x2,x3) => x0.initEvent(x1,x2,x3),
      _754: x0 => x0.baseURI,
      _755: x0 => x0.firstChild,
      _759: x0 => x0.parentElement,
      _760: (x0,x1) => { x0.textContent = x1 },
      _762: x0 => x0.parentNode,
      _763: x0 => x0.nextSibling,
      _764: (x0,x1) => x0.removeChild(x1),
      _765: x0 => x0.isConnected,
      _770: x0 => x0.firstElementChild,
      _773: x0 => x0.clientHeight,
      _774: x0 => x0.clientWidth,
      _775: x0 => x0.offsetHeight,
      _776: x0 => x0.offsetWidth,
      _777: x0 => x0.id,
      _778: (x0,x1) => { x0.id = x1 },
      _781: (x0,x1) => { x0.spellcheck = x1 },
      _782: x0 => x0.tagName,
      _783: x0 => x0.style,
      _785: (x0,x1) => x0.querySelectorAll(x1),
      _786: (x0,x1,x2) => x0.setAttribute(x1,x2),
      _787: x0 => x0.tabIndex,
      _788: (x0,x1) => { x0.tabIndex = x1 },
      _789: (x0,x1) => x0.focus(x1),
      _790: x0 => x0.scrollTop,
      _791: (x0,x1) => { x0.scrollTop = x1 },
      _792: x0 => x0.scrollLeft,
      _793: (x0,x1) => { x0.scrollLeft = x1 },
      _794: x0 => x0.classList,
      _796: (x0,x1) => { x0.className = x1 },
      _798: (x0,x1) => x0.getElementsByClassName(x1),
      _799: x0 => x0.click(),
      _800: (x0,x1) => x0.attachShadow(x1),
      _803: x0 => x0.computedStyleMap(),
      _804: (x0,x1) => x0.get(x1),
      _810: (x0,x1) => x0.getPropertyValue(x1),
      _811: (x0,x1,x2,x3) => x0.setProperty(x1,x2,x3),
      _812: x0 => x0.offsetLeft,
      _813: x0 => x0.offsetTop,
      _814: x0 => x0.offsetParent,
      _816: (x0,x1) => { x0.name = x1 },
      _817: x0 => x0.content,
      _818: (x0,x1) => { x0.content = x1 },
      _821: (x0,x1) => { x0.src = x1 },
      _823: x0 => x0.naturalWidth,
      _824: x0 => x0.naturalHeight,
      _828: (x0,x1) => { x0.crossOrigin = x1 },
      _830: (x0,x1) => { x0.decoding = x1 },
      _831: x0 => x0.decode(),
      _836: (x0,x1) => { x0.nonce = x1 },
      _841: (x0,x1) => { x0.width = x1 },
      _843: (x0,x1) => { x0.height = x1 },
      _846: (x0,x1) => x0.getContext(x1),
      _913: x0 => x0.width,
      _914: x0 => x0.height,
      _916: (x0,x1) => x0.fetch(x1),
      _917: x0 => x0.status,
      _919: x0 => x0.body,
      _920: x0 => x0.arrayBuffer(),
      _923: x0 => x0.read(),
      _924: x0 => x0.value,
      _925: x0 => x0.done,
      _932: x0 => x0.name,
      _933: x0 => x0.x,
      _934: x0 => x0.y,
      _937: x0 => x0.top,
      _938: x0 => x0.right,
      _939: x0 => x0.bottom,
      _940: x0 => x0.left,
      _950: x0 => x0.height,
      _951: x0 => x0.width,
      _952: x0 => x0.scale,
      _953: (x0,x1) => { x0.value = x1 },
      _956: (x0,x1) => { x0.placeholder = x1 },
      _957: (x0,x1) => { x0.name = x1 },
      _959: x0 => x0.selectionDirection,
      _960: x0 => x0.selectionStart,
      _961: x0 => x0.selectionEnd,
      _964: x0 => x0.value,
      _966: (x0,x1,x2) => x0.setSelectionRange(x1,x2),
      _967: x0 => x0.readText(),
      _968: (x0,x1) => x0.writeText(x1),
      _970: x0 => x0.altKey,
      _971: x0 => x0.code,
      _972: x0 => x0.ctrlKey,
      _973: x0 => x0.key,
      _974: x0 => x0.keyCode,
      _975: x0 => x0.location,
      _976: x0 => x0.metaKey,
      _977: x0 => x0.repeat,
      _978: x0 => x0.shiftKey,
      _979: x0 => x0.isComposing,
      _981: x0 => x0.state,
      _982: (x0,x1) => x0.go(x1),
      _984: (x0,x1,x2,x3) => x0.pushState(x1,x2,x3),
      _985: (x0,x1,x2,x3) => x0.replaceState(x1,x2,x3),
      _986: x0 => x0.pathname,
      _987: x0 => x0.search,
      _988: x0 => x0.hash,
      _992: x0 => x0.state,
      _995: (x0,x1) => x0.createObjectURL(x1),
      _997: x0 => new Blob(x0),
      _1007: x0 => x0.matches,
      _1008: x0 => x0.matches,
      _1012: x0 => x0.relatedTarget,
      _1014: x0 => x0.clientX,
      _1015: x0 => x0.clientY,
      _1016: x0 => x0.offsetX,
      _1017: x0 => x0.offsetY,
      _1020: x0 => x0.button,
      _1021: x0 => x0.buttons,
      _1022: x0 => x0.ctrlKey,
      _1026: x0 => x0.pointerId,
      _1027: x0 => x0.pointerType,
      _1028: x0 => x0.pressure,
      _1029: x0 => x0.tiltX,
      _1030: x0 => x0.tiltY,
      _1031: x0 => x0.getCoalescedEvents(),
      _1034: x0 => x0.deltaX,
      _1035: x0 => x0.deltaY,
      _1036: x0 => x0.wheelDeltaX,
      _1037: x0 => x0.wheelDeltaY,
      _1038: x0 => x0.deltaMode,
      _1045: x0 => x0.changedTouches,
      _1048: x0 => x0.clientX,
      _1049: x0 => x0.clientY,
      _1052: x0 => x0.data,
      _1054: (x0,x1) => { x0.disabled = x1 },
      _1057: (x0,x1) => { x0.type = x1 },
      _1058: (x0,x1) => { x0.max = x1 },
      _1059: (x0,x1) => { x0.min = x1 },
      _1060: (x0,x1) => { x0.value = x1 },
      _1061: x0 => x0.value,
      _1062: x0 => x0.disabled,
      _1063: (x0,x1) => { x0.disabled = x1 },
      _1065: (x0,x1) => { x0.placeholder = x1 },
      _1067: (x0,x1) => { x0.name = x1 },
      _1069: (x0,x1) => { x0.autocomplete = x1 },
      _1070: x0 => x0.selectionDirection,
      _1071: x0 => x0.selectionStart,
      _1074: x0 => x0.selectionEnd,
      _1076: (x0,x1,x2) => x0.setSelectionRange(x1,x2),
      _1077: (x0,x1) => x0.add(x1),
      _1080: (x0,x1) => { x0.noValidate = x1 },
      _1081: (x0,x1) => { x0.method = x1 },
      _1082: (x0,x1) => { x0.action = x1 },
      _1108: x0 => x0.orientation,
      _1109: x0 => x0.width,
      _1110: x0 => x0.height,
      _1111: (x0,x1) => x0.lock(x1),
      _1130: x0 => new ResizeObserver(x0),
      _1133: (module,f) => finalizeWrapper(f, function(x0,x1) { return module.exports._1133(f,arguments.length,x0,x1) }),
      _1141: x0 => x0.length,
      _1142: x0 => x0.iterator,
      _1143: x0 => x0.Segmenter,
      _1144: x0 => x0.v8BreakIterator,
      _1145: (x0,x1) => new Intl.Segmenter(x0,x1),
      _1148: x0 => x0.language,
      _1149: x0 => x0.script,
      _1150: x0 => x0.region,
      _1168: x0 => x0.done,
      _1169: x0 => x0.value,
      _1170: x0 => x0.index,
      _1174: (x0,x1) => new Intl.v8BreakIterator(x0,x1),
      _1175: (x0,x1) => x0.adoptText(x1),
      _1176: x0 => x0.first(),
      _1177: x0 => x0.next(),
      _1178: x0 => x0.current(),
      _1192: x0 => x0.hostElement,
      _1193: x0 => x0.viewConstraints,
      _1196: x0 => x0.maxHeight,
      _1197: x0 => x0.maxWidth,
      _1198: x0 => x0.minHeight,
      _1199: x0 => x0.minWidth,
      _1200: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1200(f,arguments.length,x0) }),
      _1201: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1201(f,arguments.length,x0) }),
      _1202: (x0,x1) => ({addView: x0,removeView: x1}),
      _1205: x0 => x0.loader,
      _1206: () => globalThis._flutter,
      _1207: (x0,x1) => x0.didCreateEngineInitializer(x1),
      _1208: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1208(f,arguments.length,x0) }),
      _1209: (module,f) => finalizeWrapper(f, function() { return module.exports._1209(f,arguments.length) }),
      _1210: (x0,x1) => ({initializeEngine: x0,autoStart: x1}),
      _1213: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1213(f,arguments.length,x0) }),
      _1214: x0 => ({runApp: x0}),
      _1216: (x0,x1,x2) => x0.call(x1,x2),
      _1217: (module,f) => finalizeWrapper(f, function(x0,x1) { return module.exports._1217(f,arguments.length,x0,x1) }),
      _1218: x0 => new Promise(x0),
      _1219: x0 => x0.length,
      _1220: () => globalThis.window.ImageDecoder,
      _1221: x0 => x0.tracks,
      _1223: x0 => x0.completed,
      _1225: x0 => x0.image,
      _1231: x0 => x0.displayWidth,
      _1232: x0 => x0.displayHeight,
      _1233: x0 => x0.duration,
      _1236: x0 => x0.ready,
      _1237: x0 => x0.selectedTrack,
      _1238: x0 => x0.repetitionCount,
      _1239: x0 => x0.frameCount,
      _1282: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1282(f,arguments.length,x0) }),
      _1283: (x0,x1,x2) => x0.addEventListener(x1,x2),
      _1284: (x0,x1,x2) => x0.postMessage(x1,x2),
      _1285: (x0,x1,x2) => x0.removeEventListener(x1,x2),
      _1286: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1286(f,arguments.length,x0) }),
      _1287: () => globalThis.initializeGA(),
      _1289: (x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33) => ({screen: x0,event_category: x1,event_label: x2,send_to: x3,value: x4,non_interaction: x5,user_app: x6,user_build: x7,user_platform: x8,devtools_platform: x9,devtools_chrome: x10,devtools_version: x11,ide_launched: x12,flutter_client_id: x13,is_external_build: x14,is_embedded: x15,g3_username: x16,ide_launched_feature: x17,is_wasm: x18,ui_duration_micros: x19,raster_duration_micros: x20,shader_compilation_duration_micros: x21,cpu_sample_count: x22,cpu_stack_depth: x23,trace_event_count: x24,heap_diff_objects_before: x25,heap_diff_objects_after: x26,heap_objects_total: x27,root_set_count: x28,row_count: x29,inspector_tree_controller_id: x30,android_app_id: x31,ios_bundle_id: x32,is_v2_inspector: x33}),
      _1290: x0 => x0.screen,
      _1291: x0 => x0.user_app,
      _1292: x0 => x0.user_build,
      _1293: x0 => x0.user_platform,
      _1294: x0 => x0.devtools_platform,
      _1295: x0 => x0.devtools_chrome,
      _1296: x0 => x0.devtools_version,
      _1297: x0 => x0.ide_launched,
      _1299: x0 => x0.is_external_build,
      _1300: x0 => x0.is_embedded,
      _1301: x0 => x0.g3_username,
      _1302: x0 => x0.ide_launched_feature,
      _1303: x0 => x0.is_wasm,
      _1304: x0 => x0.ui_duration_micros,
      _1305: x0 => x0.raster_duration_micros,
      _1306: x0 => x0.shader_compilation_duration_micros,
      _1307: x0 => x0.cpu_sample_count,
      _1308: x0 => x0.cpu_stack_depth,
      _1309: x0 => x0.trace_event_count,
      _1310: x0 => x0.heap_diff_objects_before,
      _1311: x0 => x0.heap_diff_objects_after,
      _1312: x0 => x0.heap_objects_total,
      _1313: x0 => x0.root_set_count,
      _1314: x0 => x0.row_count,
      _1315: x0 => x0.inspector_tree_controller_id,
      _1316: x0 => x0.android_app_id,
      _1317: x0 => x0.ios_bundle_id,
      _1318: x0 => x0.is_v2_inspector,
      _1320: (x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29) => ({description: x0,fatal: x1,user_app: x2,user_build: x3,user_platform: x4,devtools_platform: x5,devtools_chrome: x6,devtools_version: x7,ide_launched: x8,flutter_client_id: x9,is_external_build: x10,is_embedded: x11,g3_username: x12,ide_launched_feature: x13,is_wasm: x14,ui_duration_micros: x15,raster_duration_micros: x16,shader_compilation_duration_micros: x17,cpu_sample_count: x18,cpu_stack_depth: x19,trace_event_count: x20,heap_diff_objects_before: x21,heap_diff_objects_after: x22,heap_objects_total: x23,root_set_count: x24,row_count: x25,inspector_tree_controller_id: x26,android_app_id: x27,ios_bundle_id: x28,is_v2_inspector: x29}),
      _1321: x0 => x0.user_app,
      _1322: x0 => x0.user_build,
      _1323: x0 => x0.user_platform,
      _1324: x0 => x0.devtools_platform,
      _1325: x0 => x0.devtools_chrome,
      _1326: x0 => x0.devtools_version,
      _1327: x0 => x0.ide_launched,
      _1329: x0 => x0.is_external_build,
      _1330: x0 => x0.is_embedded,
      _1331: x0 => x0.g3_username,
      _1332: x0 => x0.ide_launched_feature,
      _1333: x0 => x0.is_wasm,
      _1349: () => globalThis.getDevToolsPropertyID(),
      _1350: () => globalThis.hookupListenerForGA(),
      _1351: (x0,x1,x2) => globalThis.gtag(x0,x1,x2),
      _1353: x0 => x0.event_category,
      _1354: x0 => x0.event_label,
      _1356: x0 => x0.value,
      _1357: x0 => x0.non_interaction,
      _1360: x0 => x0.description,
      _1361: x0 => x0.fatal,
      _1362: (x0,x1) => x0.getItem(x1),
      _1363: (x0,x1,x2) => x0.setItem(x1,x2),
      _1364: (x0,x1) => x0.querySelectorAll(x1),
      _1365: (x0,x1) => x0.removeChild(x1),
      _1366: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1366(f,arguments.length,x0) }),
      _1367: (x0,x1) => x0.forEach(x1),
      _1368: x0 => x0.preventDefault(),
      _1369: (x0,x1) => x0.execCommand(x1),
      _1370: (x0,x1) => x0.item(x1),
      _1371: () => new FileReader(),
      _1372: (x0,x1) => x0.readAsText(x1),
      _1373: (x0,x1) => x0.createElement(x1),
      _1374: x0 => new Blob(x0),
      _1375: x0 => globalThis.URL.createObjectURL(x0),
      _1376: (x0,x1,x2) => x0.setAttribute(x1,x2),
      _1377: (x0,x1) => x0.append(x1),
      _1378: x0 => x0.click(),
      _1379: x0 => x0.remove(),
      _1380: x0 => x0.createRange(),
      _1381: (x0,x1) => x0.selectNode(x1),
      _1382: x0 => x0.getSelection(),
      _1383: x0 => x0.removeAllRanges(),
      _1384: (x0,x1) => x0.addRange(x1),
      _1385: (x0,x1) => x0.createElement(x1),
      _1386: (x0,x1) => x0.append(x1),
      _1387: (x0,x1,x2) => x0.insertRule(x1,x2),
      _1388: (x0,x1) => x0.add(x1),
      _1389: x0 => x0.preventDefault(),
      _1390: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1390(f,arguments.length,x0) }),
      _1391: (x0,x1,x2) => x0.addEventListener(x1,x2),
      _1392: () => globalThis.window.navigator.userAgent,
      _1393: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1393(f,arguments.length,x0) }),
      _1394: (x0,x1,x2,x3) => x0.addEventListener(x1,x2,x3),
      _1395: (x0,x1,x2,x3) => x0.removeEventListener(x1,x2,x3),
      _1400: (x0,x1) => x0.closest(x1),
      _1401: (x0,x1,x2,x3) => x0.open(x1,x2,x3),
      _1402: x0 => x0.decode(),
      _1403: (x0,x1,x2,x3) => x0.open(x1,x2,x3),
      _1404: (x0,x1,x2) => x0.setRequestHeader(x1,x2),
      _1405: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1405(f,arguments.length,x0) }),
      _1406: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1406(f,arguments.length,x0) }),
      _1407: x0 => x0.send(),
      _1408: () => new XMLHttpRequest(),
      _1409: (x0,x1) => x0.querySelector(x1),
      _1410: (x0,x1) => x0.appendChild(x1),
      _1411: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1411(f,arguments.length,x0) }),
      _1412: Date.now,
      _1414: s => new Date(s * 1000).getTimezoneOffset() * 60,
      _1415: s => {
        if (!/^\s*[+-]?(?:Infinity|NaN|(?:\.\d+|\d+(?:\.\d*)?)(?:[eE][+-]?\d+)?)\s*$/.test(s)) {
          return NaN;
        }
        return parseFloat(s);
      },
      _1416: () => new Error().stack,
      _1417: () => typeof dartUseDateNowForTicks !== "undefined",
      _1418: () => 1000 * performance.now(),
      _1419: () => Date.now(),
      _1420: () => {
        // On browsers return `globalThis.location.href`
        if (globalThis.location != null) {
          return globalThis.location.href;
        }
        return null;
      },
      _1421: () => {
        return typeof process != "undefined" &&
               Object.prototype.toString.call(process) == "[object process]" &&
               process.platform == "win32"
      },
      _1422: () => new WeakMap(),
      _1423: (map, o) => map.get(o),
      _1424: (map, o, v) => map.set(o, v),
      _1425: (exn) => exn.toString(),
      _1426: (exn) => exn.stack,
      _1427: (exn) => {
        let stackString = exn.toString();
        let frames = stackString.split('\n');
        let drop = 2;
        if (frames[0] === 'Error') {
            drop += 1;
        }
        return frames.slice(drop).join('\n');
      },
      _1428: x0 => new WeakRef(x0),
      _1429: x0 => x0.deref(),
      _1436: () => globalThis.WeakRef,
      _1440: s => JSON.stringify(s),
      _1441: s => printToConsole(s),
      _1442: (o, p, r) => o.replaceAll(p, () => r),
      _1443: (o, p, r) => o.replace(p, () => r),
      _1444: Function.prototype.call.bind(String.prototype.toLowerCase),
      _1445: s => s.toUpperCase(),
      _1446: s => s.trim(),
      _1447: s => s.trimLeft(),
      _1448: s => s.trimRight(),
      _1449: (string, times) => string.repeat(times),
      _1450: Function.prototype.call.bind(String.prototype.indexOf),
      _1451: (s, p, i) => s.lastIndexOf(p, i),
      _1452: (string, token) => string.split(token),
      _1453: Object.is,
      _1456: (o, t) => typeof o === t,
      _1457: (o, c) => o instanceof c,
      _1458: o => Object.keys(o),
      _1488: x0 => new Array(x0),
      _1490: x0 => x0.length,
      _1492: (x0,x1) => x0[x1],
      _1493: (x0,x1,x2) => { x0[x1] = x2 },
      _1496: (x0,x1,x2) => new DataView(x0,x1,x2),
      _1498: x0 => new Int8Array(x0),
      _1499: (x0,x1,x2) => new Uint8Array(x0,x1,x2),
      _1501: x0 => new Uint8ClampedArray(x0),
      _1503: x0 => new Int16Array(x0),
      _1505: x0 => new Uint16Array(x0),
      _1507: x0 => new Int32Array(x0),
      _1509: x0 => new Uint32Array(x0),
      _1511: x0 => new Float32Array(x0),
      _1513: x0 => new Float64Array(x0),
      _1537: x0 => x0.random(),
      _1540: () => globalThis.Math,
      _1553: (ms, c) =>
      setTimeout(() => dartInstance.exports.$invokeCallback(c),ms),
      _1554: (handle) => clearTimeout(handle),
      _1555: (ms, c) =>
      setInterval(() => dartInstance.exports.$invokeCallback(c), ms),
      _1556: (handle) => clearInterval(handle),
      _1557: (c) =>
      queueMicrotask(() => dartInstance.exports.$invokeCallback(c)),
      _1558: () => Date.now(),
      _1559: (s, m) => {
        try {
          return new RegExp(s, m);
        } catch (e) {
          return String(e);
        }
      },
      _1560: (x0,x1) => x0.exec(x1),
      _1561: (x0,x1) => x0.test(x1),
      _1562: x0 => x0.pop(),
      _1564: o => o === undefined,
      _1566: o => typeof o === 'function' && o[jsWrappedDartFunctionSymbol] === true,
      _1568: o => {
        const proto = Object.getPrototypeOf(o);
        return proto === Object.prototype || proto === null;
      },
      _1569: o => o instanceof RegExp,
      _1570: (l, r) => l === r,
      _1571: o => o,
      _1572: o => o,
      _1573: o => o,
      _1574: b => !!b,
      _1575: o => o.length,
      _1577: (o, i) => o[i],
      _1578: f => f.dartFunction,
      _1579: () => ({}),
      _1580: () => [],
      _1582: () => globalThis,
      _1583: (constructor, args) => {
        const factoryFunction = constructor.bind.apply(
            constructor, [null, ...args]);
        return new factoryFunction();
      },
      _1584: (o, p) => p in o,
      _1585: (o, p) => o[p],
      _1586: (o, p, v) => o[p] = v,
      _1587: (o, m, a) => o[m].apply(o, a),
      _1589: o => String(o),
      _1590: (p, s, f) => p.then(s, (e) => f(e, e === undefined)),
      _1591: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1591(f,arguments.length,x0) }),
      _1592: (module,f) => finalizeWrapper(f, function(x0,x1) { return module.exports._1592(f,arguments.length,x0,x1) }),
      _1593: o => {
        if (o === undefined) return 1;
        var type = typeof o;
        if (type === 'boolean') return 2;
        if (type === 'number') return 3;
        if (type === 'string') return 4;
        if (o instanceof Array) return 5;
        if (ArrayBuffer.isView(o)) {
          if (o instanceof Int8Array) return 6;
          if (o instanceof Uint8Array) return 7;
          if (o instanceof Uint8ClampedArray) return 8;
          if (o instanceof Int16Array) return 9;
          if (o instanceof Uint16Array) return 10;
          if (o instanceof Int32Array) return 11;
          if (o instanceof Uint32Array) return 12;
          if (o instanceof Float32Array) return 13;
          if (o instanceof Float64Array) return 14;
          if (o instanceof DataView) return 15;
        }
        if (o instanceof ArrayBuffer) return 16;
        // Feature check for `SharedArrayBuffer` before doing a type-check.
        if (globalThis.SharedArrayBuffer !== undefined &&
            o instanceof SharedArrayBuffer) {
            return 17;
        }
        if (o instanceof Promise) return 18;
        return 19;
      },
      _1594: o => [o],
      _1595: (o0, o1) => [o0, o1],
      _1596: (o0, o1, o2) => [o0, o1, o2],
      _1597: (o0, o1, o2, o3) => [o0, o1, o2, o3],
      _1598: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const getValue = dartInstance.exports.$wasmI8ArrayGet;
        for (let i = 0; i < length; i++) {
          jsArray[jsArrayOffset + i] = getValue(wasmArray, wasmArrayOffset + i);
        }
      },
      _1599: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const setValue = dartInstance.exports.$wasmI8ArraySet;
        for (let i = 0; i < length; i++) {
          setValue(wasmArray, wasmArrayOffset + i, jsArray[jsArrayOffset + i]);
        }
      },
      _1600: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const getValue = dartInstance.exports.$wasmI16ArrayGet;
        for (let i = 0; i < length; i++) {
          jsArray[jsArrayOffset + i] = getValue(wasmArray, wasmArrayOffset + i);
        }
      },
      _1601: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const setValue = dartInstance.exports.$wasmI16ArraySet;
        for (let i = 0; i < length; i++) {
          setValue(wasmArray, wasmArrayOffset + i, jsArray[jsArrayOffset + i]);
        }
      },
      _1602: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const getValue = dartInstance.exports.$wasmI32ArrayGet;
        for (let i = 0; i < length; i++) {
          jsArray[jsArrayOffset + i] = getValue(wasmArray, wasmArrayOffset + i);
        }
      },
      _1603: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const setValue = dartInstance.exports.$wasmI32ArraySet;
        for (let i = 0; i < length; i++) {
          setValue(wasmArray, wasmArrayOffset + i, jsArray[jsArrayOffset + i]);
        }
      },
      _1604: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const getValue = dartInstance.exports.$wasmF32ArrayGet;
        for (let i = 0; i < length; i++) {
          jsArray[jsArrayOffset + i] = getValue(wasmArray, wasmArrayOffset + i);
        }
      },
      _1605: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const setValue = dartInstance.exports.$wasmF32ArraySet;
        for (let i = 0; i < length; i++) {
          setValue(wasmArray, wasmArrayOffset + i, jsArray[jsArrayOffset + i]);
        }
      },
      _1606: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const getValue = dartInstance.exports.$wasmF64ArrayGet;
        for (let i = 0; i < length; i++) {
          jsArray[jsArrayOffset + i] = getValue(wasmArray, wasmArrayOffset + i);
        }
      },
      _1607: (jsArray, jsArrayOffset, wasmArray, wasmArrayOffset, length) => {
        const setValue = dartInstance.exports.$wasmF64ArraySet;
        for (let i = 0; i < length; i++) {
          setValue(wasmArray, wasmArrayOffset + i, jsArray[jsArrayOffset + i]);
        }
      },
      _1608: x0 => new ArrayBuffer(x0),
      _1609: s => {
        if (/[[\]{}()*+?.\\^$|]/.test(s)) {
            s = s.replace(/[[\]{}()*+?.\\^$|]/g, '\\$&');
        }
        return s;
      },
      _1610: x0 => x0.input,
      _1611: x0 => x0.index,
      _1612: x0 => x0.groups,
      _1613: x0 => x0.flags,
      _1614: x0 => x0.multiline,
      _1615: x0 => x0.ignoreCase,
      _1616: x0 => x0.unicode,
      _1617: x0 => x0.dotAll,
      _1618: (x0,x1) => { x0.lastIndex = x1 },
      _1619: (o, p) => p in o,
      _1620: (o, p) => o[p],
      _1623: () => new XMLHttpRequest(),
      _1624: (x0,x1,x2,x3) => x0.open(x1,x2,x3),
      _1628: x0 => x0.send(),
      _1630: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1630(f,arguments.length,x0) }),
      _1631: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1631(f,arguments.length,x0) }),
      _1636: (x0,x1) => new WebSocket(x0,x1),
      _1637: (x0,x1) => x0.send(x1),
      _1638: (x0,x1,x2) => x0.close(x1,x2),
      _1640: x0 => x0.close(),
      _1644: (x0,x1) => x0.readAsArrayBuffer(x1),
      _1646: x0 => ({body: x0}),
      _1647: (x0,x1) => new Notification(x0,x1),
      _1648: () => globalThis.Notification.requestPermission(),
      _1649: x0 => x0.close(),
      _1650: () => new AbortController(),
      _1651: x0 => x0.abort(),
      _1652: (x0,x1,x2,x3,x4,x5) => ({method: x0,headers: x1,body: x2,credentials: x3,redirect: x4,signal: x5}),
      _1653: (x0,x1) => globalThis.fetch(x0,x1),
      _1654: (x0,x1) => x0.get(x1),
      _1655: (module,f) => finalizeWrapper(f, function(x0,x1,x2) { return module.exports._1655(f,arguments.length,x0,x1,x2) }),
      _1656: (x0,x1) => x0.forEach(x1),
      _1657: x0 => x0.getReader(),
      _1658: x0 => x0.cancel(),
      _1659: x0 => x0.read(),
      _1660: x0 => ({withCredentials: x0}),
      _1661: (x0,x1) => new EventSource(x0,x1),
      _1662: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1662(f,arguments.length,x0) }),
      _1663: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1663(f,arguments.length,x0) }),
      _1664: x0 => x0.close(),
      _1665: (x0,x1,x2) => ({method: x0,body: x1,credentials: x2}),
      _1666: (x0,x1,x2) => x0.fetch(x1,x2),
      _1667: (x0,x1) => x0.groupCollapsed(x1),
      _1668: (x0,x1) => x0.log(x1),
      _1669: x0 => x0.groupEnd(),
      _1670: (x0,x1) => x0.warn(x1),
      _1671: (x0,x1) => x0.error(x1),
      _1672: x0 => x0.measureUserAgentSpecificMemory(),
      _1673: x0 => x0.bytes,
      _1683: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1683(f,arguments.length,x0) }),
      _1684: (module,f) => finalizeWrapper(f, function(x0) { return module.exports._1684(f,arguments.length,x0) }),
      _1685: x0 => x0.blur(),
      _1686: (x0,x1) => x0.replace(x1),
      _1687: x0 => x0.reload(),
      _1688: (x0,x1,x2,x3) => x0.replaceState(x1,x2,x3),
      _1689: o => o instanceof Array,
      _1690: (a, i) => a.push(i),
      _1691: (a, i) => a.splice(i, 1)[0],
      _1693: (a, l) => a.length = l,
      _1694: a => a.pop(),
      _1695: (a, i) => a.splice(i, 1),
      _1696: (a, s) => a.join(s),
      _1697: (a, s, e) => a.slice(s, e),
      _1699: (a, b) => a == b ? 0 : (a > b ? 1 : -1),
      _1700: a => a.length,
      _1701: (a, l) => a.length = l,
      _1702: (a, i) => a[i],
      _1703: (a, i, v) => a[i] = v,
      _1705: o => {
        if (o instanceof ArrayBuffer) return 0;
        if (globalThis.SharedArrayBuffer !== undefined &&
            o instanceof SharedArrayBuffer) {
          return 1;
        }
        return 2;
      },
      _1706: (o, offsetInBytes, lengthInBytes) => {
        var dst = new ArrayBuffer(lengthInBytes);
        new Uint8Array(dst).set(new Uint8Array(o, offsetInBytes, lengthInBytes));
        return new DataView(dst);
      },
      _1708: o => o instanceof Uint8Array,
      _1709: (o, start, length) => new Uint8Array(o.buffer, o.byteOffset + start, length),
      _1710: o => o instanceof Int8Array,
      _1711: (o, start, length) => new Int8Array(o.buffer, o.byteOffset + start, length),
      _1712: o => o instanceof Uint8ClampedArray,
      _1713: (o, start, length) => new Uint8ClampedArray(o.buffer, o.byteOffset + start, length),
      _1714: o => o instanceof Uint16Array,
      _1715: (o, start, length) => new Uint16Array(o.buffer, o.byteOffset + start, length),
      _1716: o => o instanceof Int16Array,
      _1717: (o, start, length) => new Int16Array(o.buffer, o.byteOffset + start, length),
      _1718: o => o instanceof Uint32Array,
      _1719: (o, start, length) => new Uint32Array(o.buffer, o.byteOffset + start, length),
      _1720: o => o instanceof Int32Array,
      _1721: (o, start, length) => new Int32Array(o.buffer, o.byteOffset + start, length),
      _1722: (o, start, length) => new BigUint64Array(o.buffer, o.byteOffset + start, length),
      _1723: (o, start, length) => new BigInt64Array(o.buffer, o.byteOffset + start, length),
      _1724: o => o instanceof Float32Array,
      _1725: (o, start, length) => new Float32Array(o.buffer, o.byteOffset + start, length),
      _1726: o => o instanceof Float64Array,
      _1727: (o, start, length) => new Float64Array(o.buffer, o.byteOffset + start, length),
      _1728: (t, s) => t.set(s),
      _1730: (o) => new DataView(o.buffer, o.byteOffset, o.byteLength),
      _1731: o => o.byteLength,
      _1732: o => o.buffer,
      _1733: o => o.byteOffset,
      _1734: Function.prototype.call.bind(Object.getOwnPropertyDescriptor(DataView.prototype, 'byteLength').get),
      _1735: (b, o) => new DataView(b, o),
      _1736: (b, o, l) => new DataView(b, o, l),
      _1737: Function.prototype.call.bind(DataView.prototype.getUint8),
      _1738: Function.prototype.call.bind(DataView.prototype.setUint8),
      _1739: Function.prototype.call.bind(DataView.prototype.getInt8),
      _1740: Function.prototype.call.bind(DataView.prototype.setInt8),
      _1741: Function.prototype.call.bind(DataView.prototype.getUint16),
      _1742: Function.prototype.call.bind(DataView.prototype.setUint16),
      _1743: Function.prototype.call.bind(DataView.prototype.getInt16),
      _1744: Function.prototype.call.bind(DataView.prototype.setInt16),
      _1745: Function.prototype.call.bind(DataView.prototype.getUint32),
      _1746: Function.prototype.call.bind(DataView.prototype.setUint32),
      _1747: Function.prototype.call.bind(DataView.prototype.getInt32),
      _1748: Function.prototype.call.bind(DataView.prototype.setInt32),
      _1749: Function.prototype.call.bind(DataView.prototype.getBigUint64),
      _1750: Function.prototype.call.bind(DataView.prototype.setBigUint64),
      _1751: Function.prototype.call.bind(DataView.prototype.getBigInt64),
      _1752: Function.prototype.call.bind(DataView.prototype.setBigInt64),
      _1753: Function.prototype.call.bind(DataView.prototype.getFloat32),
      _1754: Function.prototype.call.bind(DataView.prototype.setFloat32),
      _1755: Function.prototype.call.bind(DataView.prototype.getFloat64),
      _1756: Function.prototype.call.bind(DataView.prototype.setFloat64),
      _1757: Function.prototype.call.bind(Number.prototype.toString),
      _1758: Function.prototype.call.bind(BigInt.prototype.toString),
      _1759: Function.prototype.call.bind(Number.prototype.toString),
      _1760: (d, digits) => d.toFixed(digits),
      _1763: (d, precision) => d.toPrecision(precision),
      _1773: () => globalThis.document,
      _1774: () => globalThis.window,
      _1779: (x0,x1) => { x0.height = x1 },
      _1781: (x0,x1) => { x0.width = x1 },
      _1783: (x0,x1) => { x0.pointerEvents = x1 },
      _1786: x0 => x0.head,
      _1787: x0 => x0.classList,
      _1791: (x0,x1) => { x0.innerText = x1 },
      _1792: x0 => x0.style,
      _1794: x0 => x0.sheet,
      _1795: x0 => x0.src,
      _1796: (x0,x1) => { x0.src = x1 },
      _1797: x0 => x0.naturalWidth,
      _1798: x0 => x0.naturalHeight,
      _1805: x0 => x0.offsetX,
      _1806: x0 => x0.offsetY,
      _1807: x0 => x0.button,
      _1814: x0 => x0.status,
      _1815: (x0,x1) => { x0.responseType = x1 },
      _1817: x0 => x0.response,
      _1866: (x0,x1) => { x0.responseType = x1 },
      _1867: x0 => x0.response,
      _1942: x0 => x0.style,
      _2419: (x0,x1) => { x0.src = x1 },
      _2426: (x0,x1) => { x0.allow = x1 },
      _2438: x0 => x0.contentWindow,
      _2871: (x0,x1) => { x0.accept = x1 },
      _2885: x0 => x0.files,
      _2911: (x0,x1) => { x0.multiple = x1 },
      _2929: (x0,x1) => { x0.type = x1 },
      _3627: (x0,x1) => { x0.dropEffect = x1 },
      _3632: x0 => x0.files,
      _3644: x0 => x0.dataTransfer,
      _3648: () => globalThis.window,
      _3690: x0 => x0.location,
      _3691: x0 => x0.history,
      _3707: x0 => x0.parent,
      _3709: x0 => x0.navigator,
      _3964: x0 => x0.isSecureContext,
      _3965: x0 => x0.crossOriginIsolated,
      _3968: x0 => x0.performance,
      _3973: x0 => x0.localStorage,
      _3981: x0 => x0.origin,
      _3990: x0 => x0.pathname,
      _4004: x0 => x0.state,
      _4029: x0 => x0.message,
      _4091: x0 => x0.appVersion,
      _4092: x0 => x0.platform,
      _4095: x0 => x0.userAgent,
      _4096: x0 => x0.vendor,
      _4146: x0 => x0.data,
      _4147: x0 => x0.origin,
      _4519: x0 => x0.readyState,
      _4528: x0 => x0.protocol,
      _4532: (x0,x1) => { x0.binaryType = x1 },
      _4535: x0 => x0.code,
      _4536: x0 => x0.reason,
      _6203: x0 => x0.type,
      _6244: x0 => x0.signal,
      _6302: x0 => x0.parentNode,
      _6316: () => globalThis.document,
      _6398: x0 => x0.body,
      _6441: x0 => x0.activeElement,
      _7075: x0 => x0.offsetX,
      _7076: x0 => x0.offsetY,
      _7161: x0 => x0.key,
      _7162: x0 => x0.code,
      _7163: x0 => x0.location,
      _7164: x0 => x0.ctrlKey,
      _7165: x0 => x0.shiftKey,
      _7166: x0 => x0.altKey,
      _7167: x0 => x0.metaKey,
      _7168: x0 => x0.repeat,
      _7169: x0 => x0.isComposing,
      _7171: x0 => x0.keyCode,
      _8075: x0 => x0.value,
      _8077: x0 => x0.done,
      _8257: x0 => x0.size,
      _8258: x0 => x0.type,
      _8265: x0 => x0.name,
      _8266: x0 => x0.lastModified,
      _8271: x0 => x0.length,
      _8277: x0 => x0.result,
      _8772: x0 => x0.url,
      _8774: x0 => x0.status,
      _8776: x0 => x0.statusText,
      _8777: x0 => x0.headers,
      _8778: x0 => x0.body,
      _10860: (x0,x1) => { x0.backgroundColor = x1 },
      _10906: (x0,x1) => { x0.border = x1 },
      _11184: (x0,x1) => { x0.display = x1 },
      _11348: (x0,x1) => { x0.height = x1 },
      _12038: (x0,x1) => { x0.width = x1 },
      _12406: x0 => x0.name,
      _13125: () => globalThis.console,

    };

    const baseImports = {
      dart2wasm: dart2wasm,
      Math: Math,
      Date: Date,
      Object: Object,
      Array: Array,
      Reflect: Reflect,
      WebAssembly: {
        JSTag: WebAssembly.JSTag,
      },
      "": new Proxy({}, { get(_, prop) { return prop; } }),

    };

    const jsStringPolyfill = {
      "charCodeAt": (s, i) => s.charCodeAt(i),
      "compare": (s1, s2) => {
        if (s1 < s2) return -1;
        if (s1 > s2) return 1;
        return 0;
      },
      "concat": (s1, s2) => s1 + s2,
      "equals": (s1, s2) => s1 === s2,
      "fromCharCode": (i) => String.fromCharCode(i),
      "length": (s) => s.length,
      "substring": (s, a, b) => s.substring(a, b),
      "fromCharCodeArray": (a, start, end) => {
        if (end <= start) return '';

        const read = dartInstance.exports.$wasmI16ArrayGet;
        let result = '';
        let index = start;
        const chunkLength = Math.min(end - index, 500);
        let array = new Array(chunkLength);
        while (index < end) {
          const newChunkLength = Math.min(end - index, 500);
          for (let i = 0; i < newChunkLength; i++) {
            array[i] = read(a, index++);
          }
          if (newChunkLength < chunkLength) {
            array = array.slice(0, newChunkLength);
          }
          result += String.fromCharCode(...array);
        }
        return result;
      },
      "intoCharCodeArray": (s, a, start) => {
        if (s === '') return 0;

        const write = dartInstance.exports.$wasmI16ArraySet;
        for (var i = 0; i < s.length; ++i) {
          write(a, start++, s.charCodeAt(i));
        }
        return s.length;
      },
      "test": (s) => typeof s == "string",
    };


    

    dartInstance = await WebAssembly.instantiate(this.module, {
      ...baseImports,
      ...additionalImports,
      
      "wasm:js-string": jsStringPolyfill,
    });
    dartInstance.exports.$setThisModule(dartInstance);

    return new InstantiatedApp(this, dartInstance);
  }
}

class InstantiatedApp {
  constructor(compiledApp, instantiatedModule) {
    this.compiledApp = compiledApp;
    this.instantiatedModule = instantiatedModule;
  }

  // Call the main function with the given arguments.
  invokeMain(...args) {
    this.instantiatedModule.exports.$invokeMain(args);
  }
}
