// ignore_for_file: camel_case_types
// ignore_for_file: comment_references
// ignore_for_file: deprecated_member_use_from_same_package
// ignore_for_file: lines_longer_than_80_chars
// ignore_for_file: non_constant_identifier_names
// ignore_for_file: prefer_const_declarations
// ignore_for_file: prefer_expression_function_bodies
// ignore_for_file: prefer_final_locals
// ignore_for_file: prefer_interpolation_to_compose_strings
// ignore_for_file: unnecessary_brace_in_string_interps
// ignore_for_file: unnecessary_cast
// ignore_for_file: unnecessary_lambdas
// ignore_for_file: unnecessary_library_directive
// ignore_for_file: unnecessary_string_interpolations
// ignore_for_file: unreachable_from_main
// ignore_for_file: unused_local_variable

import 'dart:async' as async;
import 'dart:convert' as convert;
import 'dart:core' as core;

import 'package:googleapis/compute/v1.dart' as api;
import 'package:http/http.dart' as http;
import 'package:test/test.dart' as unittest;

import '../test_shared.dart';

core.int buildCounterAWSV4Signature = 0;
api.AWSV4Signature buildAWSV4Signature() {
  final o = api.AWSV4Signature();
  buildCounterAWSV4Signature++;
  if (buildCounterAWSV4Signature < 3) {
    o.accessKey = 'foo';
    o.accessKeyId = 'foo';
    o.accessKeyVersion = 'foo';
    o.originRegion = 'foo';
  }
  buildCounterAWSV4Signature--;
  return o;
}

void checkAWSV4Signature(api.AWSV4Signature o) {
  buildCounterAWSV4Signature++;
  if (buildCounterAWSV4Signature < 3) {
    unittest.expect(
      o.accessKey!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.accessKeyId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.accessKeyVersion!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.originRegion!,
      unittest.equals('foo'),
    );
  }
  buildCounterAWSV4Signature--;
}

core.int buildCounterAcceleratorConfig = 0;
api.AcceleratorConfig buildAcceleratorConfig() {
  final o = api.AcceleratorConfig();
  buildCounterAcceleratorConfig++;
  if (buildCounterAcceleratorConfig < 3) {
    o.acceleratorCount = 42;
    o.acceleratorType = 'foo';
  }
  buildCounterAcceleratorConfig--;
  return o;
}

void checkAcceleratorConfig(api.AcceleratorConfig o) {
  buildCounterAcceleratorConfig++;
  if (buildCounterAcceleratorConfig < 3) {
    unittest.expect(
      o.acceleratorCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.acceleratorType!,
      unittest.equals('foo'),
    );
  }
  buildCounterAcceleratorConfig--;
}

core.int buildCounterAcceleratorType = 0;
api.AcceleratorType buildAcceleratorType() {
  final o = api.AcceleratorType();
  buildCounterAcceleratorType++;
  if (buildCounterAcceleratorType < 3) {
    o.creationTimestamp = 'foo';
    o.deprecated = buildDeprecationStatus();
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.maximumCardsPerInstance = 42;
    o.name = 'foo';
    o.selfLink = 'foo';
    o.zone = 'foo';
  }
  buildCounterAcceleratorType--;
  return o;
}

void checkAcceleratorType(api.AcceleratorType o) {
  buildCounterAcceleratorType++;
  if (buildCounterAcceleratorType < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkDeprecationStatus(o.deprecated!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.maximumCardsPerInstance!,
      unittest.equals(42),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterAcceleratorType--;
}

core.Map<core.String, api.AcceleratorTypesScopedList> buildUnnamed0() => {
      'x': buildAcceleratorTypesScopedList(),
      'y': buildAcceleratorTypesScopedList(),
    };

void checkUnnamed0(core.Map<core.String, api.AcceleratorTypesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorTypesScopedList(o['x']!);
  checkAcceleratorTypesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed1() => [
      'foo',
      'foo',
    ];

void checkUnnamed1(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterAcceleratorTypeAggregatedListWarningData = 0;
api.AcceleratorTypeAggregatedListWarningData
    buildAcceleratorTypeAggregatedListWarningData() {
  final o = api.AcceleratorTypeAggregatedListWarningData();
  buildCounterAcceleratorTypeAggregatedListWarningData++;
  if (buildCounterAcceleratorTypeAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAcceleratorTypeAggregatedListWarningData--;
  return o;
}

void checkAcceleratorTypeAggregatedListWarningData(
    api.AcceleratorTypeAggregatedListWarningData o) {
  buildCounterAcceleratorTypeAggregatedListWarningData++;
  if (buildCounterAcceleratorTypeAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAcceleratorTypeAggregatedListWarningData--;
}

core.List<api.AcceleratorTypeAggregatedListWarningData> buildUnnamed2() => [
      buildAcceleratorTypeAggregatedListWarningData(),
      buildAcceleratorTypeAggregatedListWarningData(),
    ];

void checkUnnamed2(core.List<api.AcceleratorTypeAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorTypeAggregatedListWarningData(o[0]);
  checkAcceleratorTypeAggregatedListWarningData(o[1]);
}

core.int buildCounterAcceleratorTypeAggregatedListWarning = 0;
api.AcceleratorTypeAggregatedListWarning
    buildAcceleratorTypeAggregatedListWarning() {
  final o = api.AcceleratorTypeAggregatedListWarning();
  buildCounterAcceleratorTypeAggregatedListWarning++;
  if (buildCounterAcceleratorTypeAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed2();
    o.message = 'foo';
  }
  buildCounterAcceleratorTypeAggregatedListWarning--;
  return o;
}

void checkAcceleratorTypeAggregatedListWarning(
    api.AcceleratorTypeAggregatedListWarning o) {
  buildCounterAcceleratorTypeAggregatedListWarning++;
  if (buildCounterAcceleratorTypeAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed2(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAcceleratorTypeAggregatedListWarning--;
}

core.int buildCounterAcceleratorTypeAggregatedList = 0;
api.AcceleratorTypeAggregatedList buildAcceleratorTypeAggregatedList() {
  final o = api.AcceleratorTypeAggregatedList();
  buildCounterAcceleratorTypeAggregatedList++;
  if (buildCounterAcceleratorTypeAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed0();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed1();
    o.warning = buildAcceleratorTypeAggregatedListWarning();
  }
  buildCounterAcceleratorTypeAggregatedList--;
  return o;
}

void checkAcceleratorTypeAggregatedList(api.AcceleratorTypeAggregatedList o) {
  buildCounterAcceleratorTypeAggregatedList++;
  if (buildCounterAcceleratorTypeAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed0(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed1(o.unreachables!);
    checkAcceleratorTypeAggregatedListWarning(o.warning!);
  }
  buildCounterAcceleratorTypeAggregatedList--;
}

core.List<api.AcceleratorType> buildUnnamed3() => [
      buildAcceleratorType(),
      buildAcceleratorType(),
    ];

void checkUnnamed3(core.List<api.AcceleratorType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorType(o[0]);
  checkAcceleratorType(o[1]);
}

core.int buildCounterAcceleratorTypeListWarningData = 0;
api.AcceleratorTypeListWarningData buildAcceleratorTypeListWarningData() {
  final o = api.AcceleratorTypeListWarningData();
  buildCounterAcceleratorTypeListWarningData++;
  if (buildCounterAcceleratorTypeListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAcceleratorTypeListWarningData--;
  return o;
}

void checkAcceleratorTypeListWarningData(api.AcceleratorTypeListWarningData o) {
  buildCounterAcceleratorTypeListWarningData++;
  if (buildCounterAcceleratorTypeListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAcceleratorTypeListWarningData--;
}

core.List<api.AcceleratorTypeListWarningData> buildUnnamed4() => [
      buildAcceleratorTypeListWarningData(),
      buildAcceleratorTypeListWarningData(),
    ];

void checkUnnamed4(core.List<api.AcceleratorTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorTypeListWarningData(o[0]);
  checkAcceleratorTypeListWarningData(o[1]);
}

core.int buildCounterAcceleratorTypeListWarning = 0;
api.AcceleratorTypeListWarning buildAcceleratorTypeListWarning() {
  final o = api.AcceleratorTypeListWarning();
  buildCounterAcceleratorTypeListWarning++;
  if (buildCounterAcceleratorTypeListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed4();
    o.message = 'foo';
  }
  buildCounterAcceleratorTypeListWarning--;
  return o;
}

void checkAcceleratorTypeListWarning(api.AcceleratorTypeListWarning o) {
  buildCounterAcceleratorTypeListWarning++;
  if (buildCounterAcceleratorTypeListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed4(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAcceleratorTypeListWarning--;
}

core.int buildCounterAcceleratorTypeList = 0;
api.AcceleratorTypeList buildAcceleratorTypeList() {
  final o = api.AcceleratorTypeList();
  buildCounterAcceleratorTypeList++;
  if (buildCounterAcceleratorTypeList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed3();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildAcceleratorTypeListWarning();
  }
  buildCounterAcceleratorTypeList--;
  return o;
}

void checkAcceleratorTypeList(api.AcceleratorTypeList o) {
  buildCounterAcceleratorTypeList++;
  if (buildCounterAcceleratorTypeList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed3(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkAcceleratorTypeListWarning(o.warning!);
  }
  buildCounterAcceleratorTypeList--;
}

core.List<api.AcceleratorType> buildUnnamed5() => [
      buildAcceleratorType(),
      buildAcceleratorType(),
    ];

void checkUnnamed5(core.List<api.AcceleratorType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorType(o[0]);
  checkAcceleratorType(o[1]);
}

core.int buildCounterAcceleratorTypesScopedListWarningData = 0;
api.AcceleratorTypesScopedListWarningData
    buildAcceleratorTypesScopedListWarningData() {
  final o = api.AcceleratorTypesScopedListWarningData();
  buildCounterAcceleratorTypesScopedListWarningData++;
  if (buildCounterAcceleratorTypesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAcceleratorTypesScopedListWarningData--;
  return o;
}

void checkAcceleratorTypesScopedListWarningData(
    api.AcceleratorTypesScopedListWarningData o) {
  buildCounterAcceleratorTypesScopedListWarningData++;
  if (buildCounterAcceleratorTypesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAcceleratorTypesScopedListWarningData--;
}

core.List<api.AcceleratorTypesScopedListWarningData> buildUnnamed6() => [
      buildAcceleratorTypesScopedListWarningData(),
      buildAcceleratorTypesScopedListWarningData(),
    ];

void checkUnnamed6(core.List<api.AcceleratorTypesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorTypesScopedListWarningData(o[0]);
  checkAcceleratorTypesScopedListWarningData(o[1]);
}

core.int buildCounterAcceleratorTypesScopedListWarning = 0;
api.AcceleratorTypesScopedListWarning buildAcceleratorTypesScopedListWarning() {
  final o = api.AcceleratorTypesScopedListWarning();
  buildCounterAcceleratorTypesScopedListWarning++;
  if (buildCounterAcceleratorTypesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed6();
    o.message = 'foo';
  }
  buildCounterAcceleratorTypesScopedListWarning--;
  return o;
}

void checkAcceleratorTypesScopedListWarning(
    api.AcceleratorTypesScopedListWarning o) {
  buildCounterAcceleratorTypesScopedListWarning++;
  if (buildCounterAcceleratorTypesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed6(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAcceleratorTypesScopedListWarning--;
}

core.int buildCounterAcceleratorTypesScopedList = 0;
api.AcceleratorTypesScopedList buildAcceleratorTypesScopedList() {
  final o = api.AcceleratorTypesScopedList();
  buildCounterAcceleratorTypesScopedList++;
  if (buildCounterAcceleratorTypesScopedList < 3) {
    o.acceleratorTypes = buildUnnamed5();
    o.warning = buildAcceleratorTypesScopedListWarning();
  }
  buildCounterAcceleratorTypesScopedList--;
  return o;
}

void checkAcceleratorTypesScopedList(api.AcceleratorTypesScopedList o) {
  buildCounterAcceleratorTypesScopedList++;
  if (buildCounterAcceleratorTypesScopedList < 3) {
    checkUnnamed5(o.acceleratorTypes!);
    checkAcceleratorTypesScopedListWarning(o.warning!);
  }
  buildCounterAcceleratorTypesScopedList--;
}

core.int buildCounterAccessConfig = 0;
api.AccessConfig buildAccessConfig() {
  final o = api.AccessConfig();
  buildCounterAccessConfig++;
  if (buildCounterAccessConfig < 3) {
    o.externalIpv6 = 'foo';
    o.externalIpv6PrefixLength = 42;
    o.kind = 'foo';
    o.name = 'foo';
    o.natIP = 'foo';
    o.networkTier = 'foo';
    o.publicPtrDomainName = 'foo';
    o.securityPolicy = 'foo';
    o.setPublicPtr = true;
    o.type = 'foo';
  }
  buildCounterAccessConfig--;
  return o;
}

void checkAccessConfig(api.AccessConfig o) {
  buildCounterAccessConfig++;
  if (buildCounterAccessConfig < 3) {
    unittest.expect(
      o.externalIpv6!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.externalIpv6PrefixLength!,
      unittest.equals(42),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.natIP!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.networkTier!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.publicPtrDomainName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.securityPolicy!,
      unittest.equals('foo'),
    );
    unittest.expect(o.setPublicPtr!, unittest.isTrue);
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterAccessConfig--;
}

core.Map<core.String, core.String> buildUnnamed7() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed7(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed8() => [
      'foo',
      'foo',
    ];

void checkUnnamed8(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterAddress = 0;
api.Address buildAddress() {
  final o = api.Address();
  buildCounterAddress++;
  if (buildCounterAddress < 3) {
    o.address = 'foo';
    o.addressType = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.id = 'foo';
    o.ipVersion = 'foo';
    o.ipv6EndpointType = 'foo';
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed7();
    o.name = 'foo';
    o.network = 'foo';
    o.networkTier = 'foo';
    o.prefixLength = 42;
    o.purpose = 'foo';
    o.region = 'foo';
    o.selfLink = 'foo';
    o.status = 'foo';
    o.subnetwork = 'foo';
    o.users = buildUnnamed8();
  }
  buildCounterAddress--;
  return o;
}

void checkAddress(api.Address o) {
  buildCounterAddress++;
  if (buildCounterAddress < 3) {
    unittest.expect(
      o.address!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.addressType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipVersion!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipv6EndpointType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed7(o.labels!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.networkTier!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.prefixLength!,
      unittest.equals(42),
    );
    unittest.expect(
      o.purpose!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.subnetwork!,
      unittest.equals('foo'),
    );
    checkUnnamed8(o.users!);
  }
  buildCounterAddress--;
}

core.Map<core.String, api.AddressesScopedList> buildUnnamed9() => {
      'x': buildAddressesScopedList(),
      'y': buildAddressesScopedList(),
    };

void checkUnnamed9(core.Map<core.String, api.AddressesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddressesScopedList(o['x']!);
  checkAddressesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed10() => [
      'foo',
      'foo',
    ];

void checkUnnamed10(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterAddressAggregatedListWarningData = 0;
api.AddressAggregatedListWarningData buildAddressAggregatedListWarningData() {
  final o = api.AddressAggregatedListWarningData();
  buildCounterAddressAggregatedListWarningData++;
  if (buildCounterAddressAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAddressAggregatedListWarningData--;
  return o;
}

void checkAddressAggregatedListWarningData(
    api.AddressAggregatedListWarningData o) {
  buildCounterAddressAggregatedListWarningData++;
  if (buildCounterAddressAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAddressAggregatedListWarningData--;
}

core.List<api.AddressAggregatedListWarningData> buildUnnamed11() => [
      buildAddressAggregatedListWarningData(),
      buildAddressAggregatedListWarningData(),
    ];

void checkUnnamed11(core.List<api.AddressAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddressAggregatedListWarningData(o[0]);
  checkAddressAggregatedListWarningData(o[1]);
}

core.int buildCounterAddressAggregatedListWarning = 0;
api.AddressAggregatedListWarning buildAddressAggregatedListWarning() {
  final o = api.AddressAggregatedListWarning();
  buildCounterAddressAggregatedListWarning++;
  if (buildCounterAddressAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed11();
    o.message = 'foo';
  }
  buildCounterAddressAggregatedListWarning--;
  return o;
}

void checkAddressAggregatedListWarning(api.AddressAggregatedListWarning o) {
  buildCounterAddressAggregatedListWarning++;
  if (buildCounterAddressAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed11(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAddressAggregatedListWarning--;
}

core.int buildCounterAddressAggregatedList = 0;
api.AddressAggregatedList buildAddressAggregatedList() {
  final o = api.AddressAggregatedList();
  buildCounterAddressAggregatedList++;
  if (buildCounterAddressAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed9();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed10();
    o.warning = buildAddressAggregatedListWarning();
  }
  buildCounterAddressAggregatedList--;
  return o;
}

void checkAddressAggregatedList(api.AddressAggregatedList o) {
  buildCounterAddressAggregatedList++;
  if (buildCounterAddressAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed9(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed10(o.unreachables!);
    checkAddressAggregatedListWarning(o.warning!);
  }
  buildCounterAddressAggregatedList--;
}

core.List<api.Address> buildUnnamed12() => [
      buildAddress(),
      buildAddress(),
    ];

void checkUnnamed12(core.List<api.Address> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddress(o[0]);
  checkAddress(o[1]);
}

core.int buildCounterAddressListWarningData = 0;
api.AddressListWarningData buildAddressListWarningData() {
  final o = api.AddressListWarningData();
  buildCounterAddressListWarningData++;
  if (buildCounterAddressListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAddressListWarningData--;
  return o;
}

void checkAddressListWarningData(api.AddressListWarningData o) {
  buildCounterAddressListWarningData++;
  if (buildCounterAddressListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAddressListWarningData--;
}

core.List<api.AddressListWarningData> buildUnnamed13() => [
      buildAddressListWarningData(),
      buildAddressListWarningData(),
    ];

void checkUnnamed13(core.List<api.AddressListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddressListWarningData(o[0]);
  checkAddressListWarningData(o[1]);
}

core.int buildCounterAddressListWarning = 0;
api.AddressListWarning buildAddressListWarning() {
  final o = api.AddressListWarning();
  buildCounterAddressListWarning++;
  if (buildCounterAddressListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed13();
    o.message = 'foo';
  }
  buildCounterAddressListWarning--;
  return o;
}

void checkAddressListWarning(api.AddressListWarning o) {
  buildCounterAddressListWarning++;
  if (buildCounterAddressListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed13(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAddressListWarning--;
}

core.int buildCounterAddressList = 0;
api.AddressList buildAddressList() {
  final o = api.AddressList();
  buildCounterAddressList++;
  if (buildCounterAddressList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed12();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildAddressListWarning();
  }
  buildCounterAddressList--;
  return o;
}

void checkAddressList(api.AddressList o) {
  buildCounterAddressList++;
  if (buildCounterAddressList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed12(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkAddressListWarning(o.warning!);
  }
  buildCounterAddressList--;
}

core.List<api.Address> buildUnnamed14() => [
      buildAddress(),
      buildAddress(),
    ];

void checkUnnamed14(core.List<api.Address> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddress(o[0]);
  checkAddress(o[1]);
}

core.int buildCounterAddressesScopedListWarningData = 0;
api.AddressesScopedListWarningData buildAddressesScopedListWarningData() {
  final o = api.AddressesScopedListWarningData();
  buildCounterAddressesScopedListWarningData++;
  if (buildCounterAddressesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAddressesScopedListWarningData--;
  return o;
}

void checkAddressesScopedListWarningData(api.AddressesScopedListWarningData o) {
  buildCounterAddressesScopedListWarningData++;
  if (buildCounterAddressesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAddressesScopedListWarningData--;
}

core.List<api.AddressesScopedListWarningData> buildUnnamed15() => [
      buildAddressesScopedListWarningData(),
      buildAddressesScopedListWarningData(),
    ];

void checkUnnamed15(core.List<api.AddressesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAddressesScopedListWarningData(o[0]);
  checkAddressesScopedListWarningData(o[1]);
}

core.int buildCounterAddressesScopedListWarning = 0;
api.AddressesScopedListWarning buildAddressesScopedListWarning() {
  final o = api.AddressesScopedListWarning();
  buildCounterAddressesScopedListWarning++;
  if (buildCounterAddressesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed15();
    o.message = 'foo';
  }
  buildCounterAddressesScopedListWarning--;
  return o;
}

void checkAddressesScopedListWarning(api.AddressesScopedListWarning o) {
  buildCounterAddressesScopedListWarning++;
  if (buildCounterAddressesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed15(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAddressesScopedListWarning--;
}

core.int buildCounterAddressesScopedList = 0;
api.AddressesScopedList buildAddressesScopedList() {
  final o = api.AddressesScopedList();
  buildCounterAddressesScopedList++;
  if (buildCounterAddressesScopedList < 3) {
    o.addresses = buildUnnamed14();
    o.warning = buildAddressesScopedListWarning();
  }
  buildCounterAddressesScopedList--;
  return o;
}

void checkAddressesScopedList(api.AddressesScopedList o) {
  buildCounterAddressesScopedList++;
  if (buildCounterAddressesScopedList < 3) {
    checkUnnamed14(o.addresses!);
    checkAddressesScopedListWarning(o.warning!);
  }
  buildCounterAddressesScopedList--;
}

core.int buildCounterAdvancedMachineFeatures = 0;
api.AdvancedMachineFeatures buildAdvancedMachineFeatures() {
  final o = api.AdvancedMachineFeatures();
  buildCounterAdvancedMachineFeatures++;
  if (buildCounterAdvancedMachineFeatures < 3) {
    o.enableNestedVirtualization = true;
    o.enableUefiNetworking = true;
    o.threadsPerCore = 42;
    o.visibleCoreCount = 42;
  }
  buildCounterAdvancedMachineFeatures--;
  return o;
}

void checkAdvancedMachineFeatures(api.AdvancedMachineFeatures o) {
  buildCounterAdvancedMachineFeatures++;
  if (buildCounterAdvancedMachineFeatures < 3) {
    unittest.expect(o.enableNestedVirtualization!, unittest.isTrue);
    unittest.expect(o.enableUefiNetworking!, unittest.isTrue);
    unittest.expect(
      o.threadsPerCore!,
      unittest.equals(42),
    );
    unittest.expect(
      o.visibleCoreCount!,
      unittest.equals(42),
    );
  }
  buildCounterAdvancedMachineFeatures--;
}

core.int buildCounterAliasIpRange = 0;
api.AliasIpRange buildAliasIpRange() {
  final o = api.AliasIpRange();
  buildCounterAliasIpRange++;
  if (buildCounterAliasIpRange < 3) {
    o.ipCidrRange = 'foo';
    o.subnetworkRangeName = 'foo';
  }
  buildCounterAliasIpRange--;
  return o;
}

void checkAliasIpRange(api.AliasIpRange o) {
  buildCounterAliasIpRange++;
  if (buildCounterAliasIpRange < 3) {
    unittest.expect(
      o.ipCidrRange!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.subnetworkRangeName!,
      unittest.equals('foo'),
    );
  }
  buildCounterAliasIpRange--;
}

core.int buildCounterAllocationResourceStatus = 0;
api.AllocationResourceStatus buildAllocationResourceStatus() {
  final o = api.AllocationResourceStatus();
  buildCounterAllocationResourceStatus++;
  if (buildCounterAllocationResourceStatus < 3) {
    o.specificSkuAllocation =
        buildAllocationResourceStatusSpecificSKUAllocation();
  }
  buildCounterAllocationResourceStatus--;
  return o;
}

void checkAllocationResourceStatus(api.AllocationResourceStatus o) {
  buildCounterAllocationResourceStatus++;
  if (buildCounterAllocationResourceStatus < 3) {
    checkAllocationResourceStatusSpecificSKUAllocation(
        o.specificSkuAllocation!);
  }
  buildCounterAllocationResourceStatus--;
}

core.int buildCounterAllocationResourceStatusSpecificSKUAllocation = 0;
api.AllocationResourceStatusSpecificSKUAllocation
    buildAllocationResourceStatusSpecificSKUAllocation() {
  final o = api.AllocationResourceStatusSpecificSKUAllocation();
  buildCounterAllocationResourceStatusSpecificSKUAllocation++;
  if (buildCounterAllocationResourceStatusSpecificSKUAllocation < 3) {
    o.sourceInstanceTemplateId = 'foo';
  }
  buildCounterAllocationResourceStatusSpecificSKUAllocation--;
  return o;
}

void checkAllocationResourceStatusSpecificSKUAllocation(
    api.AllocationResourceStatusSpecificSKUAllocation o) {
  buildCounterAllocationResourceStatusSpecificSKUAllocation++;
  if (buildCounterAllocationResourceStatusSpecificSKUAllocation < 3) {
    unittest.expect(
      o.sourceInstanceTemplateId!,
      unittest.equals('foo'),
    );
  }
  buildCounterAllocationResourceStatusSpecificSKUAllocation--;
}

core.int
    buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk =
    0;
api.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
    buildAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk() {
  final o = api
      .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk();
  buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk++;
  if (buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk <
      3) {
    o.diskSizeGb = 'foo';
    o.interface = 'foo';
  }
  buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk--;
  return o;
}

void checkAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
    api.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
        o) {
  buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk++;
  if (buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk <
      3) {
    unittest.expect(
      o.diskSizeGb!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.interface!,
      unittest.equals('foo'),
    );
  }
  buildCounterAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk--;
}

core.List<api.AcceleratorConfig> buildUnnamed16() => [
      buildAcceleratorConfig(),
      buildAcceleratorConfig(),
    ];

void checkUnnamed16(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

core.List<
        api
        .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>
    buildUnnamed17() => [
          buildAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(),
          buildAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(),
        ];

void checkUnnamed17(
    core.List<
            api
            .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
      o[0]);
  checkAllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
      o[1]);
}

core.int buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties =
    0;
api.AllocationSpecificSKUAllocationReservedInstanceProperties
    buildAllocationSpecificSKUAllocationReservedInstanceProperties() {
  final o = api.AllocationSpecificSKUAllocationReservedInstanceProperties();
  buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties++;
  if (buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties <
      3) {
    o.guestAccelerators = buildUnnamed16();
    o.localSsds = buildUnnamed17();
    o.locationHint = 'foo';
    o.machineType = 'foo';
    o.minCpuPlatform = 'foo';
  }
  buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties--;
  return o;
}

void checkAllocationSpecificSKUAllocationReservedInstanceProperties(
    api.AllocationSpecificSKUAllocationReservedInstanceProperties o) {
  buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties++;
  if (buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties <
      3) {
    checkUnnamed16(o.guestAccelerators!);
    checkUnnamed17(o.localSsds!);
    unittest.expect(
      o.locationHint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.machineType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.minCpuPlatform!,
      unittest.equals('foo'),
    );
  }
  buildCounterAllocationSpecificSKUAllocationReservedInstanceProperties--;
}

core.int buildCounterAllocationSpecificSKUReservation = 0;
api.AllocationSpecificSKUReservation buildAllocationSpecificSKUReservation() {
  final o = api.AllocationSpecificSKUReservation();
  buildCounterAllocationSpecificSKUReservation++;
  if (buildCounterAllocationSpecificSKUReservation < 3) {
    o.assuredCount = 'foo';
    o.count = 'foo';
    o.inUseCount = 'foo';
    o.instanceProperties =
        buildAllocationSpecificSKUAllocationReservedInstanceProperties();
    o.sourceInstanceTemplate = 'foo';
  }
  buildCounterAllocationSpecificSKUReservation--;
  return o;
}

void checkAllocationSpecificSKUReservation(
    api.AllocationSpecificSKUReservation o) {
  buildCounterAllocationSpecificSKUReservation++;
  if (buildCounterAllocationSpecificSKUReservation < 3) {
    unittest.expect(
      o.assuredCount!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.count!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.inUseCount!,
      unittest.equals('foo'),
    );
    checkAllocationSpecificSKUAllocationReservedInstanceProperties(
        o.instanceProperties!);
    unittest.expect(
      o.sourceInstanceTemplate!,
      unittest.equals('foo'),
    );
  }
  buildCounterAllocationSpecificSKUReservation--;
}

core.List<api.GuestOsFeature> buildUnnamed18() => [
      buildGuestOsFeature(),
      buildGuestOsFeature(),
    ];

void checkUnnamed18(core.List<api.GuestOsFeature> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestOsFeature(o[0]);
  checkGuestOsFeature(o[1]);
}

core.List<core.String> buildUnnamed19() => [
      'foo',
      'foo',
    ];

void checkUnnamed19(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterAttachedDisk = 0;
api.AttachedDisk buildAttachedDisk() {
  final o = api.AttachedDisk();
  buildCounterAttachedDisk++;
  if (buildCounterAttachedDisk < 3) {
    o.architecture = 'foo';
    o.autoDelete = true;
    o.boot = true;
    o.deviceName = 'foo';
    o.diskEncryptionKey = buildCustomerEncryptionKey();
    o.diskSizeGb = 'foo';
    o.forceAttach = true;
    o.guestOsFeatures = buildUnnamed18();
    o.index = 42;
    o.initializeParams = buildAttachedDiskInitializeParams();
    o.interface = 'foo';
    o.kind = 'foo';
    o.licenses = buildUnnamed19();
    o.mode = 'foo';
    o.savedState = 'foo';
    o.shieldedInstanceInitialState = buildInitialStateConfig();
    o.source = 'foo';
    o.type = 'foo';
  }
  buildCounterAttachedDisk--;
  return o;
}

void checkAttachedDisk(api.AttachedDisk o) {
  buildCounterAttachedDisk++;
  if (buildCounterAttachedDisk < 3) {
    unittest.expect(
      o.architecture!,
      unittest.equals('foo'),
    );
    unittest.expect(o.autoDelete!, unittest.isTrue);
    unittest.expect(o.boot!, unittest.isTrue);
    unittest.expect(
      o.deviceName!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.diskEncryptionKey!);
    unittest.expect(
      o.diskSizeGb!,
      unittest.equals('foo'),
    );
    unittest.expect(o.forceAttach!, unittest.isTrue);
    checkUnnamed18(o.guestOsFeatures!);
    unittest.expect(
      o.index!,
      unittest.equals(42),
    );
    checkAttachedDiskInitializeParams(o.initializeParams!);
    unittest.expect(
      o.interface!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkUnnamed19(o.licenses!);
    unittest.expect(
      o.mode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.savedState!,
      unittest.equals('foo'),
    );
    checkInitialStateConfig(o.shieldedInstanceInitialState!);
    unittest.expect(
      o.source!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterAttachedDisk--;
}

core.Map<core.String, core.String> buildUnnamed20() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed20(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed21() => [
      'foo',
      'foo',
    ];

void checkUnnamed21(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed22() => [
      'foo',
      'foo',
    ];

void checkUnnamed22(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.Map<core.String, core.String> buildUnnamed23() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed23(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed24() => [
      'foo',
      'foo',
    ];

void checkUnnamed24(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterAttachedDiskInitializeParams = 0;
api.AttachedDiskInitializeParams buildAttachedDiskInitializeParams() {
  final o = api.AttachedDiskInitializeParams();
  buildCounterAttachedDiskInitializeParams++;
  if (buildCounterAttachedDiskInitializeParams < 3) {
    o.architecture = 'foo';
    o.description = 'foo';
    o.diskName = 'foo';
    o.diskSizeGb = 'foo';
    o.diskType = 'foo';
    o.labels = buildUnnamed20();
    o.licenses = buildUnnamed21();
    o.onUpdateAction = 'foo';
    o.provisionedIops = 'foo';
    o.provisionedThroughput = 'foo';
    o.replicaZones = buildUnnamed22();
    o.resourceManagerTags = buildUnnamed23();
    o.resourcePolicies = buildUnnamed24();
    o.sourceImage = 'foo';
    o.sourceImageEncryptionKey = buildCustomerEncryptionKey();
    o.sourceSnapshot = 'foo';
    o.sourceSnapshotEncryptionKey = buildCustomerEncryptionKey();
  }
  buildCounterAttachedDiskInitializeParams--;
  return o;
}

void checkAttachedDiskInitializeParams(api.AttachedDiskInitializeParams o) {
  buildCounterAttachedDiskInitializeParams++;
  if (buildCounterAttachedDiskInitializeParams < 3) {
    unittest.expect(
      o.architecture!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.diskName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.diskSizeGb!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.diskType!,
      unittest.equals('foo'),
    );
    checkUnnamed20(o.labels!);
    checkUnnamed21(o.licenses!);
    unittest.expect(
      o.onUpdateAction!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.provisionedIops!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.provisionedThroughput!,
      unittest.equals('foo'),
    );
    checkUnnamed22(o.replicaZones!);
    checkUnnamed23(o.resourceManagerTags!);
    checkUnnamed24(o.resourcePolicies!);
    unittest.expect(
      o.sourceImage!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.sourceImageEncryptionKey!);
    unittest.expect(
      o.sourceSnapshot!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.sourceSnapshotEncryptionKey!);
  }
  buildCounterAttachedDiskInitializeParams--;
}

core.List<api.AuditLogConfig> buildUnnamed25() => [
      buildAuditLogConfig(),
      buildAuditLogConfig(),
    ];

void checkUnnamed25(core.List<api.AuditLogConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAuditLogConfig(o[0]);
  checkAuditLogConfig(o[1]);
}

core.List<core.String> buildUnnamed26() => [
      'foo',
      'foo',
    ];

void checkUnnamed26(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterAuditConfig = 0;
api.AuditConfig buildAuditConfig() {
  final o = api.AuditConfig();
  buildCounterAuditConfig++;
  if (buildCounterAuditConfig < 3) {
    o.auditLogConfigs = buildUnnamed25();
    o.exemptedMembers = buildUnnamed26();
    o.service = 'foo';
  }
  buildCounterAuditConfig--;
  return o;
}

void checkAuditConfig(api.AuditConfig o) {
  buildCounterAuditConfig++;
  if (buildCounterAuditConfig < 3) {
    checkUnnamed25(o.auditLogConfigs!);
    checkUnnamed26(o.exemptedMembers!);
    unittest.expect(
      o.service!,
      unittest.equals('foo'),
    );
  }
  buildCounterAuditConfig--;
}

core.List<core.String> buildUnnamed27() => [
      'foo',
      'foo',
    ];

void checkUnnamed27(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterAuditLogConfig = 0;
api.AuditLogConfig buildAuditLogConfig() {
  final o = api.AuditLogConfig();
  buildCounterAuditLogConfig++;
  if (buildCounterAuditLogConfig < 3) {
    o.exemptedMembers = buildUnnamed27();
    o.ignoreChildExemptions = true;
    o.logType = 'foo';
  }
  buildCounterAuditLogConfig--;
  return o;
}

void checkAuditLogConfig(api.AuditLogConfig o) {
  buildCounterAuditLogConfig++;
  if (buildCounterAuditLogConfig < 3) {
    checkUnnamed27(o.exemptedMembers!);
    unittest.expect(o.ignoreChildExemptions!, unittest.isTrue);
    unittest.expect(
      o.logType!,
      unittest.equals('foo'),
    );
  }
  buildCounterAuditLogConfig--;
}

core.int buildCounterAuthorizationLoggingOptions = 0;
api.AuthorizationLoggingOptions buildAuthorizationLoggingOptions() {
  final o = api.AuthorizationLoggingOptions();
  buildCounterAuthorizationLoggingOptions++;
  if (buildCounterAuthorizationLoggingOptions < 3) {
    o.permissionType = 'foo';
  }
  buildCounterAuthorizationLoggingOptions--;
  return o;
}

void checkAuthorizationLoggingOptions(api.AuthorizationLoggingOptions o) {
  buildCounterAuthorizationLoggingOptions++;
  if (buildCounterAuthorizationLoggingOptions < 3) {
    unittest.expect(
      o.permissionType!,
      unittest.equals('foo'),
    );
  }
  buildCounterAuthorizationLoggingOptions--;
}

core.Map<core.String, api.ScalingScheduleStatus> buildUnnamed28() => {
      'x': buildScalingScheduleStatus(),
      'y': buildScalingScheduleStatus(),
    };

void checkUnnamed28(core.Map<core.String, api.ScalingScheduleStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkScalingScheduleStatus(o['x']!);
  checkScalingScheduleStatus(o['y']!);
}

core.List<api.AutoscalerStatusDetails> buildUnnamed29() => [
      buildAutoscalerStatusDetails(),
      buildAutoscalerStatusDetails(),
    ];

void checkUnnamed29(core.List<api.AutoscalerStatusDetails> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalerStatusDetails(o[0]);
  checkAutoscalerStatusDetails(o[1]);
}

core.int buildCounterAutoscaler = 0;
api.Autoscaler buildAutoscaler() {
  final o = api.Autoscaler();
  buildCounterAutoscaler++;
  if (buildCounterAutoscaler < 3) {
    o.autoscalingPolicy = buildAutoscalingPolicy();
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.recommendedSize = 42;
    o.region = 'foo';
    o.scalingScheduleStatus = buildUnnamed28();
    o.selfLink = 'foo';
    o.status = 'foo';
    o.statusDetails = buildUnnamed29();
    o.target = 'foo';
    o.zone = 'foo';
  }
  buildCounterAutoscaler--;
  return o;
}

void checkAutoscaler(api.Autoscaler o) {
  buildCounterAutoscaler++;
  if (buildCounterAutoscaler < 3) {
    checkAutoscalingPolicy(o.autoscalingPolicy!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.recommendedSize!,
      unittest.equals(42),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    checkUnnamed28(o.scalingScheduleStatus!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    checkUnnamed29(o.statusDetails!);
    unittest.expect(
      o.target!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscaler--;
}

core.Map<core.String, api.AutoscalersScopedList> buildUnnamed30() => {
      'x': buildAutoscalersScopedList(),
      'y': buildAutoscalersScopedList(),
    };

void checkUnnamed30(core.Map<core.String, api.AutoscalersScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalersScopedList(o['x']!);
  checkAutoscalersScopedList(o['y']!);
}

core.List<core.String> buildUnnamed31() => [
      'foo',
      'foo',
    ];

void checkUnnamed31(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterAutoscalerAggregatedListWarningData = 0;
api.AutoscalerAggregatedListWarningData
    buildAutoscalerAggregatedListWarningData() {
  final o = api.AutoscalerAggregatedListWarningData();
  buildCounterAutoscalerAggregatedListWarningData++;
  if (buildCounterAutoscalerAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAutoscalerAggregatedListWarningData--;
  return o;
}

void checkAutoscalerAggregatedListWarningData(
    api.AutoscalerAggregatedListWarningData o) {
  buildCounterAutoscalerAggregatedListWarningData++;
  if (buildCounterAutoscalerAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalerAggregatedListWarningData--;
}

core.List<api.AutoscalerAggregatedListWarningData> buildUnnamed32() => [
      buildAutoscalerAggregatedListWarningData(),
      buildAutoscalerAggregatedListWarningData(),
    ];

void checkUnnamed32(core.List<api.AutoscalerAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalerAggregatedListWarningData(o[0]);
  checkAutoscalerAggregatedListWarningData(o[1]);
}

core.int buildCounterAutoscalerAggregatedListWarning = 0;
api.AutoscalerAggregatedListWarning buildAutoscalerAggregatedListWarning() {
  final o = api.AutoscalerAggregatedListWarning();
  buildCounterAutoscalerAggregatedListWarning++;
  if (buildCounterAutoscalerAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed32();
    o.message = 'foo';
  }
  buildCounterAutoscalerAggregatedListWarning--;
  return o;
}

void checkAutoscalerAggregatedListWarning(
    api.AutoscalerAggregatedListWarning o) {
  buildCounterAutoscalerAggregatedListWarning++;
  if (buildCounterAutoscalerAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed32(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalerAggregatedListWarning--;
}

core.int buildCounterAutoscalerAggregatedList = 0;
api.AutoscalerAggregatedList buildAutoscalerAggregatedList() {
  final o = api.AutoscalerAggregatedList();
  buildCounterAutoscalerAggregatedList++;
  if (buildCounterAutoscalerAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed30();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed31();
    o.warning = buildAutoscalerAggregatedListWarning();
  }
  buildCounterAutoscalerAggregatedList--;
  return o;
}

void checkAutoscalerAggregatedList(api.AutoscalerAggregatedList o) {
  buildCounterAutoscalerAggregatedList++;
  if (buildCounterAutoscalerAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed30(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed31(o.unreachables!);
    checkAutoscalerAggregatedListWarning(o.warning!);
  }
  buildCounterAutoscalerAggregatedList--;
}

core.List<api.Autoscaler> buildUnnamed33() => [
      buildAutoscaler(),
      buildAutoscaler(),
    ];

void checkUnnamed33(core.List<api.Autoscaler> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscaler(o[0]);
  checkAutoscaler(o[1]);
}

core.int buildCounterAutoscalerListWarningData = 0;
api.AutoscalerListWarningData buildAutoscalerListWarningData() {
  final o = api.AutoscalerListWarningData();
  buildCounterAutoscalerListWarningData++;
  if (buildCounterAutoscalerListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAutoscalerListWarningData--;
  return o;
}

void checkAutoscalerListWarningData(api.AutoscalerListWarningData o) {
  buildCounterAutoscalerListWarningData++;
  if (buildCounterAutoscalerListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalerListWarningData--;
}

core.List<api.AutoscalerListWarningData> buildUnnamed34() => [
      buildAutoscalerListWarningData(),
      buildAutoscalerListWarningData(),
    ];

void checkUnnamed34(core.List<api.AutoscalerListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalerListWarningData(o[0]);
  checkAutoscalerListWarningData(o[1]);
}

core.int buildCounterAutoscalerListWarning = 0;
api.AutoscalerListWarning buildAutoscalerListWarning() {
  final o = api.AutoscalerListWarning();
  buildCounterAutoscalerListWarning++;
  if (buildCounterAutoscalerListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed34();
    o.message = 'foo';
  }
  buildCounterAutoscalerListWarning--;
  return o;
}

void checkAutoscalerListWarning(api.AutoscalerListWarning o) {
  buildCounterAutoscalerListWarning++;
  if (buildCounterAutoscalerListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed34(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalerListWarning--;
}

core.int buildCounterAutoscalerList = 0;
api.AutoscalerList buildAutoscalerList() {
  final o = api.AutoscalerList();
  buildCounterAutoscalerList++;
  if (buildCounterAutoscalerList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed33();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildAutoscalerListWarning();
  }
  buildCounterAutoscalerList--;
  return o;
}

void checkAutoscalerList(api.AutoscalerList o) {
  buildCounterAutoscalerList++;
  if (buildCounterAutoscalerList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed33(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkAutoscalerListWarning(o.warning!);
  }
  buildCounterAutoscalerList--;
}

core.int buildCounterAutoscalerStatusDetails = 0;
api.AutoscalerStatusDetails buildAutoscalerStatusDetails() {
  final o = api.AutoscalerStatusDetails();
  buildCounterAutoscalerStatusDetails++;
  if (buildCounterAutoscalerStatusDetails < 3) {
    o.message = 'foo';
    o.type = 'foo';
  }
  buildCounterAutoscalerStatusDetails--;
  return o;
}

void checkAutoscalerStatusDetails(api.AutoscalerStatusDetails o) {
  buildCounterAutoscalerStatusDetails++;
  if (buildCounterAutoscalerStatusDetails < 3) {
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalerStatusDetails--;
}

core.List<api.Autoscaler> buildUnnamed35() => [
      buildAutoscaler(),
      buildAutoscaler(),
    ];

void checkUnnamed35(core.List<api.Autoscaler> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscaler(o[0]);
  checkAutoscaler(o[1]);
}

core.int buildCounterAutoscalersScopedListWarningData = 0;
api.AutoscalersScopedListWarningData buildAutoscalersScopedListWarningData() {
  final o = api.AutoscalersScopedListWarningData();
  buildCounterAutoscalersScopedListWarningData++;
  if (buildCounterAutoscalersScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterAutoscalersScopedListWarningData--;
  return o;
}

void checkAutoscalersScopedListWarningData(
    api.AutoscalersScopedListWarningData o) {
  buildCounterAutoscalersScopedListWarningData++;
  if (buildCounterAutoscalersScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalersScopedListWarningData--;
}

core.List<api.AutoscalersScopedListWarningData> buildUnnamed36() => [
      buildAutoscalersScopedListWarningData(),
      buildAutoscalersScopedListWarningData(),
    ];

void checkUnnamed36(core.List<api.AutoscalersScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalersScopedListWarningData(o[0]);
  checkAutoscalersScopedListWarningData(o[1]);
}

core.int buildCounterAutoscalersScopedListWarning = 0;
api.AutoscalersScopedListWarning buildAutoscalersScopedListWarning() {
  final o = api.AutoscalersScopedListWarning();
  buildCounterAutoscalersScopedListWarning++;
  if (buildCounterAutoscalersScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed36();
    o.message = 'foo';
  }
  buildCounterAutoscalersScopedListWarning--;
  return o;
}

void checkAutoscalersScopedListWarning(api.AutoscalersScopedListWarning o) {
  buildCounterAutoscalersScopedListWarning++;
  if (buildCounterAutoscalersScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed36(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalersScopedListWarning--;
}

core.int buildCounterAutoscalersScopedList = 0;
api.AutoscalersScopedList buildAutoscalersScopedList() {
  final o = api.AutoscalersScopedList();
  buildCounterAutoscalersScopedList++;
  if (buildCounterAutoscalersScopedList < 3) {
    o.autoscalers = buildUnnamed35();
    o.warning = buildAutoscalersScopedListWarning();
  }
  buildCounterAutoscalersScopedList--;
  return o;
}

void checkAutoscalersScopedList(api.AutoscalersScopedList o) {
  buildCounterAutoscalersScopedList++;
  if (buildCounterAutoscalersScopedList < 3) {
    checkUnnamed35(o.autoscalers!);
    checkAutoscalersScopedListWarning(o.warning!);
  }
  buildCounterAutoscalersScopedList--;
}

core.List<api.AutoscalingPolicyCustomMetricUtilization> buildUnnamed37() => [
      buildAutoscalingPolicyCustomMetricUtilization(),
      buildAutoscalingPolicyCustomMetricUtilization(),
    ];

void checkUnnamed37(core.List<api.AutoscalingPolicyCustomMetricUtilization> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalingPolicyCustomMetricUtilization(o[0]);
  checkAutoscalingPolicyCustomMetricUtilization(o[1]);
}

core.Map<core.String, api.AutoscalingPolicyScalingSchedule> buildUnnamed38() =>
    {
      'x': buildAutoscalingPolicyScalingSchedule(),
      'y': buildAutoscalingPolicyScalingSchedule(),
    };

void checkUnnamed38(
    core.Map<core.String, api.AutoscalingPolicyScalingSchedule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscalingPolicyScalingSchedule(o['x']!);
  checkAutoscalingPolicyScalingSchedule(o['y']!);
}

core.int buildCounterAutoscalingPolicy = 0;
api.AutoscalingPolicy buildAutoscalingPolicy() {
  final o = api.AutoscalingPolicy();
  buildCounterAutoscalingPolicy++;
  if (buildCounterAutoscalingPolicy < 3) {
    o.coolDownPeriodSec = 42;
    o.cpuUtilization = buildAutoscalingPolicyCpuUtilization();
    o.customMetricUtilizations = buildUnnamed37();
    o.loadBalancingUtilization =
        buildAutoscalingPolicyLoadBalancingUtilization();
    o.maxNumReplicas = 42;
    o.minNumReplicas = 42;
    o.mode = 'foo';
    o.scaleInControl = buildAutoscalingPolicyScaleInControl();
    o.scalingSchedules = buildUnnamed38();
  }
  buildCounterAutoscalingPolicy--;
  return o;
}

void checkAutoscalingPolicy(api.AutoscalingPolicy o) {
  buildCounterAutoscalingPolicy++;
  if (buildCounterAutoscalingPolicy < 3) {
    unittest.expect(
      o.coolDownPeriodSec!,
      unittest.equals(42),
    );
    checkAutoscalingPolicyCpuUtilization(o.cpuUtilization!);
    checkUnnamed37(o.customMetricUtilizations!);
    checkAutoscalingPolicyLoadBalancingUtilization(o.loadBalancingUtilization!);
    unittest.expect(
      o.maxNumReplicas!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minNumReplicas!,
      unittest.equals(42),
    );
    unittest.expect(
      o.mode!,
      unittest.equals('foo'),
    );
    checkAutoscalingPolicyScaleInControl(o.scaleInControl!);
    checkUnnamed38(o.scalingSchedules!);
  }
  buildCounterAutoscalingPolicy--;
}

core.int buildCounterAutoscalingPolicyCpuUtilization = 0;
api.AutoscalingPolicyCpuUtilization buildAutoscalingPolicyCpuUtilization() {
  final o = api.AutoscalingPolicyCpuUtilization();
  buildCounterAutoscalingPolicyCpuUtilization++;
  if (buildCounterAutoscalingPolicyCpuUtilization < 3) {
    o.predictiveMethod = 'foo';
    o.utilizationTarget = 42.0;
  }
  buildCounterAutoscalingPolicyCpuUtilization--;
  return o;
}

void checkAutoscalingPolicyCpuUtilization(
    api.AutoscalingPolicyCpuUtilization o) {
  buildCounterAutoscalingPolicyCpuUtilization++;
  if (buildCounterAutoscalingPolicyCpuUtilization < 3) {
    unittest.expect(
      o.predictiveMethod!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.utilizationTarget!,
      unittest.equals(42.0),
    );
  }
  buildCounterAutoscalingPolicyCpuUtilization--;
}

core.int buildCounterAutoscalingPolicyCustomMetricUtilization = 0;
api.AutoscalingPolicyCustomMetricUtilization
    buildAutoscalingPolicyCustomMetricUtilization() {
  final o = api.AutoscalingPolicyCustomMetricUtilization();
  buildCounterAutoscalingPolicyCustomMetricUtilization++;
  if (buildCounterAutoscalingPolicyCustomMetricUtilization < 3) {
    o.filter = 'foo';
    o.metric = 'foo';
    o.singleInstanceAssignment = 42.0;
    o.utilizationTarget = 42.0;
    o.utilizationTargetType = 'foo';
  }
  buildCounterAutoscalingPolicyCustomMetricUtilization--;
  return o;
}

void checkAutoscalingPolicyCustomMetricUtilization(
    api.AutoscalingPolicyCustomMetricUtilization o) {
  buildCounterAutoscalingPolicyCustomMetricUtilization++;
  if (buildCounterAutoscalingPolicyCustomMetricUtilization < 3) {
    unittest.expect(
      o.filter!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.metric!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.singleInstanceAssignment!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.utilizationTarget!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.utilizationTargetType!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalingPolicyCustomMetricUtilization--;
}

core.int buildCounterAutoscalingPolicyLoadBalancingUtilization = 0;
api.AutoscalingPolicyLoadBalancingUtilization
    buildAutoscalingPolicyLoadBalancingUtilization() {
  final o = api.AutoscalingPolicyLoadBalancingUtilization();
  buildCounterAutoscalingPolicyLoadBalancingUtilization++;
  if (buildCounterAutoscalingPolicyLoadBalancingUtilization < 3) {
    o.utilizationTarget = 42.0;
  }
  buildCounterAutoscalingPolicyLoadBalancingUtilization--;
  return o;
}

void checkAutoscalingPolicyLoadBalancingUtilization(
    api.AutoscalingPolicyLoadBalancingUtilization o) {
  buildCounterAutoscalingPolicyLoadBalancingUtilization++;
  if (buildCounterAutoscalingPolicyLoadBalancingUtilization < 3) {
    unittest.expect(
      o.utilizationTarget!,
      unittest.equals(42.0),
    );
  }
  buildCounterAutoscalingPolicyLoadBalancingUtilization--;
}

core.int buildCounterAutoscalingPolicyScaleInControl = 0;
api.AutoscalingPolicyScaleInControl buildAutoscalingPolicyScaleInControl() {
  final o = api.AutoscalingPolicyScaleInControl();
  buildCounterAutoscalingPolicyScaleInControl++;
  if (buildCounterAutoscalingPolicyScaleInControl < 3) {
    o.maxScaledInReplicas = buildFixedOrPercent();
    o.timeWindowSec = 42;
  }
  buildCounterAutoscalingPolicyScaleInControl--;
  return o;
}

void checkAutoscalingPolicyScaleInControl(
    api.AutoscalingPolicyScaleInControl o) {
  buildCounterAutoscalingPolicyScaleInControl++;
  if (buildCounterAutoscalingPolicyScaleInControl < 3) {
    checkFixedOrPercent(o.maxScaledInReplicas!);
    unittest.expect(
      o.timeWindowSec!,
      unittest.equals(42),
    );
  }
  buildCounterAutoscalingPolicyScaleInControl--;
}

core.int buildCounterAutoscalingPolicyScalingSchedule = 0;
api.AutoscalingPolicyScalingSchedule buildAutoscalingPolicyScalingSchedule() {
  final o = api.AutoscalingPolicyScalingSchedule();
  buildCounterAutoscalingPolicyScalingSchedule++;
  if (buildCounterAutoscalingPolicyScalingSchedule < 3) {
    o.description = 'foo';
    o.disabled = true;
    o.durationSec = 42;
    o.minRequiredReplicas = 42;
    o.schedule = 'foo';
    o.timeZone = 'foo';
  }
  buildCounterAutoscalingPolicyScalingSchedule--;
  return o;
}

void checkAutoscalingPolicyScalingSchedule(
    api.AutoscalingPolicyScalingSchedule o) {
  buildCounterAutoscalingPolicyScalingSchedule++;
  if (buildCounterAutoscalingPolicyScalingSchedule < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(o.disabled!, unittest.isTrue);
    unittest.expect(
      o.durationSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minRequiredReplicas!,
      unittest.equals(42),
    );
    unittest.expect(
      o.schedule!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.timeZone!,
      unittest.equals('foo'),
    );
  }
  buildCounterAutoscalingPolicyScalingSchedule--;
}

core.int buildCounterBackend = 0;
api.Backend buildBackend() {
  final o = api.Backend();
  buildCounterBackend++;
  if (buildCounterBackend < 3) {
    o.balancingMode = 'foo';
    o.capacityScaler = 42.0;
    o.description = 'foo';
    o.failover = true;
    o.group = 'foo';
    o.maxConnections = 42;
    o.maxConnectionsPerEndpoint = 42;
    o.maxConnectionsPerInstance = 42;
    o.maxRate = 42;
    o.maxRatePerEndpoint = 42.0;
    o.maxRatePerInstance = 42.0;
    o.maxUtilization = 42.0;
  }
  buildCounterBackend--;
  return o;
}

void checkBackend(api.Backend o) {
  buildCounterBackend++;
  if (buildCounterBackend < 3) {
    unittest.expect(
      o.balancingMode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.capacityScaler!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(o.failover!, unittest.isTrue);
    unittest.expect(
      o.group!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.maxConnections!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxConnectionsPerEndpoint!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxConnectionsPerInstance!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxRate!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxRatePerEndpoint!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.maxRatePerInstance!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.maxUtilization!,
      unittest.equals(42.0),
    );
  }
  buildCounterBackend--;
}

core.List<core.String> buildUnnamed39() => [
      'foo',
      'foo',
    ];

void checkUnnamed39(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterBackendBucket = 0;
api.BackendBucket buildBackendBucket() {
  final o = api.BackendBucket();
  buildCounterBackendBucket++;
  if (buildCounterBackendBucket < 3) {
    o.bucketName = 'foo';
    o.cdnPolicy = buildBackendBucketCdnPolicy();
    o.compressionMode = 'foo';
    o.creationTimestamp = 'foo';
    o.customResponseHeaders = buildUnnamed39();
    o.description = 'foo';
    o.edgeSecurityPolicy = 'foo';
    o.enableCdn = true;
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.selfLink = 'foo';
  }
  buildCounterBackendBucket--;
  return o;
}

void checkBackendBucket(api.BackendBucket o) {
  buildCounterBackendBucket++;
  if (buildCounterBackendBucket < 3) {
    unittest.expect(
      o.bucketName!,
      unittest.equals('foo'),
    );
    checkBackendBucketCdnPolicy(o.cdnPolicy!);
    unittest.expect(
      o.compressionMode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkUnnamed39(o.customResponseHeaders!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.edgeSecurityPolicy!,
      unittest.equals('foo'),
    );
    unittest.expect(o.enableCdn!, unittest.isTrue);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendBucket--;
}

core.List<api.BackendBucketCdnPolicyBypassCacheOnRequestHeader>
    buildUnnamed40() => [
          buildBackendBucketCdnPolicyBypassCacheOnRequestHeader(),
          buildBackendBucketCdnPolicyBypassCacheOnRequestHeader(),
        ];

void checkUnnamed40(
    core.List<api.BackendBucketCdnPolicyBypassCacheOnRequestHeader> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendBucketCdnPolicyBypassCacheOnRequestHeader(o[0]);
  checkBackendBucketCdnPolicyBypassCacheOnRequestHeader(o[1]);
}

core.List<api.BackendBucketCdnPolicyNegativeCachingPolicy> buildUnnamed41() => [
      buildBackendBucketCdnPolicyNegativeCachingPolicy(),
      buildBackendBucketCdnPolicyNegativeCachingPolicy(),
    ];

void checkUnnamed41(
    core.List<api.BackendBucketCdnPolicyNegativeCachingPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendBucketCdnPolicyNegativeCachingPolicy(o[0]);
  checkBackendBucketCdnPolicyNegativeCachingPolicy(o[1]);
}

core.List<core.String> buildUnnamed42() => [
      'foo',
      'foo',
    ];

void checkUnnamed42(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterBackendBucketCdnPolicy = 0;
api.BackendBucketCdnPolicy buildBackendBucketCdnPolicy() {
  final o = api.BackendBucketCdnPolicy();
  buildCounterBackendBucketCdnPolicy++;
  if (buildCounterBackendBucketCdnPolicy < 3) {
    o.bypassCacheOnRequestHeaders = buildUnnamed40();
    o.cacheKeyPolicy = buildBackendBucketCdnPolicyCacheKeyPolicy();
    o.cacheMode = 'foo';
    o.clientTtl = 42;
    o.defaultTtl = 42;
    o.maxTtl = 42;
    o.negativeCaching = true;
    o.negativeCachingPolicy = buildUnnamed41();
    o.requestCoalescing = true;
    o.serveWhileStale = 42;
    o.signedUrlCacheMaxAgeSec = 'foo';
    o.signedUrlKeyNames = buildUnnamed42();
  }
  buildCounterBackendBucketCdnPolicy--;
  return o;
}

void checkBackendBucketCdnPolicy(api.BackendBucketCdnPolicy o) {
  buildCounterBackendBucketCdnPolicy++;
  if (buildCounterBackendBucketCdnPolicy < 3) {
    checkUnnamed40(o.bypassCacheOnRequestHeaders!);
    checkBackendBucketCdnPolicyCacheKeyPolicy(o.cacheKeyPolicy!);
    unittest.expect(
      o.cacheMode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.clientTtl!,
      unittest.equals(42),
    );
    unittest.expect(
      o.defaultTtl!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxTtl!,
      unittest.equals(42),
    );
    unittest.expect(o.negativeCaching!, unittest.isTrue);
    checkUnnamed41(o.negativeCachingPolicy!);
    unittest.expect(o.requestCoalescing!, unittest.isTrue);
    unittest.expect(
      o.serveWhileStale!,
      unittest.equals(42),
    );
    unittest.expect(
      o.signedUrlCacheMaxAgeSec!,
      unittest.equals('foo'),
    );
    checkUnnamed42(o.signedUrlKeyNames!);
  }
  buildCounterBackendBucketCdnPolicy--;
}

core.int buildCounterBackendBucketCdnPolicyBypassCacheOnRequestHeader = 0;
api.BackendBucketCdnPolicyBypassCacheOnRequestHeader
    buildBackendBucketCdnPolicyBypassCacheOnRequestHeader() {
  final o = api.BackendBucketCdnPolicyBypassCacheOnRequestHeader();
  buildCounterBackendBucketCdnPolicyBypassCacheOnRequestHeader++;
  if (buildCounterBackendBucketCdnPolicyBypassCacheOnRequestHeader < 3) {
    o.headerName = 'foo';
  }
  buildCounterBackendBucketCdnPolicyBypassCacheOnRequestHeader--;
  return o;
}

void checkBackendBucketCdnPolicyBypassCacheOnRequestHeader(
    api.BackendBucketCdnPolicyBypassCacheOnRequestHeader o) {
  buildCounterBackendBucketCdnPolicyBypassCacheOnRequestHeader++;
  if (buildCounterBackendBucketCdnPolicyBypassCacheOnRequestHeader < 3) {
    unittest.expect(
      o.headerName!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendBucketCdnPolicyBypassCacheOnRequestHeader--;
}

core.List<core.String> buildUnnamed43() => [
      'foo',
      'foo',
    ];

void checkUnnamed43(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed44() => [
      'foo',
      'foo',
    ];

void checkUnnamed44(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterBackendBucketCdnPolicyCacheKeyPolicy = 0;
api.BackendBucketCdnPolicyCacheKeyPolicy
    buildBackendBucketCdnPolicyCacheKeyPolicy() {
  final o = api.BackendBucketCdnPolicyCacheKeyPolicy();
  buildCounterBackendBucketCdnPolicyCacheKeyPolicy++;
  if (buildCounterBackendBucketCdnPolicyCacheKeyPolicy < 3) {
    o.includeHttpHeaders = buildUnnamed43();
    o.queryStringWhitelist = buildUnnamed44();
  }
  buildCounterBackendBucketCdnPolicyCacheKeyPolicy--;
  return o;
}

void checkBackendBucketCdnPolicyCacheKeyPolicy(
    api.BackendBucketCdnPolicyCacheKeyPolicy o) {
  buildCounterBackendBucketCdnPolicyCacheKeyPolicy++;
  if (buildCounterBackendBucketCdnPolicyCacheKeyPolicy < 3) {
    checkUnnamed43(o.includeHttpHeaders!);
    checkUnnamed44(o.queryStringWhitelist!);
  }
  buildCounterBackendBucketCdnPolicyCacheKeyPolicy--;
}

core.int buildCounterBackendBucketCdnPolicyNegativeCachingPolicy = 0;
api.BackendBucketCdnPolicyNegativeCachingPolicy
    buildBackendBucketCdnPolicyNegativeCachingPolicy() {
  final o = api.BackendBucketCdnPolicyNegativeCachingPolicy();
  buildCounterBackendBucketCdnPolicyNegativeCachingPolicy++;
  if (buildCounterBackendBucketCdnPolicyNegativeCachingPolicy < 3) {
    o.code = 42;
    o.ttl = 42;
  }
  buildCounterBackendBucketCdnPolicyNegativeCachingPolicy--;
  return o;
}

void checkBackendBucketCdnPolicyNegativeCachingPolicy(
    api.BackendBucketCdnPolicyNegativeCachingPolicy o) {
  buildCounterBackendBucketCdnPolicyNegativeCachingPolicy++;
  if (buildCounterBackendBucketCdnPolicyNegativeCachingPolicy < 3) {
    unittest.expect(
      o.code!,
      unittest.equals(42),
    );
    unittest.expect(
      o.ttl!,
      unittest.equals(42),
    );
  }
  buildCounterBackendBucketCdnPolicyNegativeCachingPolicy--;
}

core.List<api.BackendBucket> buildUnnamed45() => [
      buildBackendBucket(),
      buildBackendBucket(),
    ];

void checkUnnamed45(core.List<api.BackendBucket> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendBucket(o[0]);
  checkBackendBucket(o[1]);
}

core.int buildCounterBackendBucketListWarningData = 0;
api.BackendBucketListWarningData buildBackendBucketListWarningData() {
  final o = api.BackendBucketListWarningData();
  buildCounterBackendBucketListWarningData++;
  if (buildCounterBackendBucketListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterBackendBucketListWarningData--;
  return o;
}

void checkBackendBucketListWarningData(api.BackendBucketListWarningData o) {
  buildCounterBackendBucketListWarningData++;
  if (buildCounterBackendBucketListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendBucketListWarningData--;
}

core.List<api.BackendBucketListWarningData> buildUnnamed46() => [
      buildBackendBucketListWarningData(),
      buildBackendBucketListWarningData(),
    ];

void checkUnnamed46(core.List<api.BackendBucketListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendBucketListWarningData(o[0]);
  checkBackendBucketListWarningData(o[1]);
}

core.int buildCounterBackendBucketListWarning = 0;
api.BackendBucketListWarning buildBackendBucketListWarning() {
  final o = api.BackendBucketListWarning();
  buildCounterBackendBucketListWarning++;
  if (buildCounterBackendBucketListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed46();
    o.message = 'foo';
  }
  buildCounterBackendBucketListWarning--;
  return o;
}

void checkBackendBucketListWarning(api.BackendBucketListWarning o) {
  buildCounterBackendBucketListWarning++;
  if (buildCounterBackendBucketListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed46(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendBucketListWarning--;
}

core.int buildCounterBackendBucketList = 0;
api.BackendBucketList buildBackendBucketList() {
  final o = api.BackendBucketList();
  buildCounterBackendBucketList++;
  if (buildCounterBackendBucketList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed45();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildBackendBucketListWarning();
  }
  buildCounterBackendBucketList--;
  return o;
}

void checkBackendBucketList(api.BackendBucketList o) {
  buildCounterBackendBucketList++;
  if (buildCounterBackendBucketList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed45(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkBackendBucketListWarning(o.warning!);
  }
  buildCounterBackendBucketList--;
}

core.List<api.Backend> buildUnnamed47() => [
      buildBackend(),
      buildBackend(),
    ];

void checkUnnamed47(core.List<api.Backend> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackend(o[0]);
  checkBackend(o[1]);
}

core.List<core.String> buildUnnamed48() => [
      'foo',
      'foo',
    ];

void checkUnnamed48(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed49() => [
      'foo',
      'foo',
    ];

void checkUnnamed49(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed50() => [
      'foo',
      'foo',
    ];

void checkUnnamed50(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.BackendServiceLocalityLoadBalancingPolicyConfig>
    buildUnnamed51() => [
          buildBackendServiceLocalityLoadBalancingPolicyConfig(),
          buildBackendServiceLocalityLoadBalancingPolicyConfig(),
        ];

void checkUnnamed51(
    core.List<api.BackendServiceLocalityLoadBalancingPolicyConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceLocalityLoadBalancingPolicyConfig(o[0]);
  checkBackendServiceLocalityLoadBalancingPolicyConfig(o[1]);
}

core.Map<core.String, core.String> buildUnnamed52() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed52(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed53() => [
      'foo',
      'foo',
    ];

void checkUnnamed53(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.BackendServiceUsedBy> buildUnnamed54() => [
      buildBackendServiceUsedBy(),
      buildBackendServiceUsedBy(),
    ];

void checkUnnamed54(core.List<api.BackendServiceUsedBy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceUsedBy(o[0]);
  checkBackendServiceUsedBy(o[1]);
}

core.int buildCounterBackendService = 0;
api.BackendService buildBackendService() {
  final o = api.BackendService();
  buildCounterBackendService++;
  if (buildCounterBackendService < 3) {
    o.affinityCookieTtlSec = 42;
    o.backends = buildUnnamed47();
    o.cdnPolicy = buildBackendServiceCdnPolicy();
    o.circuitBreakers = buildCircuitBreakers();
    o.compressionMode = 'foo';
    o.connectionDraining = buildConnectionDraining();
    o.connectionTrackingPolicy = buildBackendServiceConnectionTrackingPolicy();
    o.consistentHash = buildConsistentHashLoadBalancerSettings();
    o.creationTimestamp = 'foo';
    o.customRequestHeaders = buildUnnamed48();
    o.customResponseHeaders = buildUnnamed49();
    o.description = 'foo';
    o.edgeSecurityPolicy = 'foo';
    o.enableCDN = true;
    o.failoverPolicy = buildBackendServiceFailoverPolicy();
    o.fingerprint = 'foo';
    o.healthChecks = buildUnnamed50();
    o.iap = buildBackendServiceIAP();
    o.id = 'foo';
    o.kind = 'foo';
    o.loadBalancingScheme = 'foo';
    o.localityLbPolicies = buildUnnamed51();
    o.localityLbPolicy = 'foo';
    o.logConfig = buildBackendServiceLogConfig();
    o.maxStreamDuration = buildDuration();
    o.metadatas = buildUnnamed52();
    o.name = 'foo';
    o.network = 'foo';
    o.outlierDetection = buildOutlierDetection();
    o.port = 42;
    o.portName = 'foo';
    o.protocol = 'foo';
    o.region = 'foo';
    o.securityPolicy = 'foo';
    o.securitySettings = buildSecuritySettings();
    o.selfLink = 'foo';
    o.serviceBindings = buildUnnamed53();
    o.sessionAffinity = 'foo';
    o.subsetting = buildSubsetting();
    o.timeoutSec = 42;
    o.usedBy = buildUnnamed54();
  }
  buildCounterBackendService--;
  return o;
}

void checkBackendService(api.BackendService o) {
  buildCounterBackendService++;
  if (buildCounterBackendService < 3) {
    unittest.expect(
      o.affinityCookieTtlSec!,
      unittest.equals(42),
    );
    checkUnnamed47(o.backends!);
    checkBackendServiceCdnPolicy(o.cdnPolicy!);
    checkCircuitBreakers(o.circuitBreakers!);
    unittest.expect(
      o.compressionMode!,
      unittest.equals('foo'),
    );
    checkConnectionDraining(o.connectionDraining!);
    checkBackendServiceConnectionTrackingPolicy(o.connectionTrackingPolicy!);
    checkConsistentHashLoadBalancerSettings(o.consistentHash!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkUnnamed48(o.customRequestHeaders!);
    checkUnnamed49(o.customResponseHeaders!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.edgeSecurityPolicy!,
      unittest.equals('foo'),
    );
    unittest.expect(o.enableCDN!, unittest.isTrue);
    checkBackendServiceFailoverPolicy(o.failoverPolicy!);
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed50(o.healthChecks!);
    checkBackendServiceIAP(o.iap!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.loadBalancingScheme!,
      unittest.equals('foo'),
    );
    checkUnnamed51(o.localityLbPolicies!);
    unittest.expect(
      o.localityLbPolicy!,
      unittest.equals('foo'),
    );
    checkBackendServiceLogConfig(o.logConfig!);
    checkDuration(o.maxStreamDuration!);
    checkUnnamed52(o.metadatas!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    checkOutlierDetection(o.outlierDetection!);
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.portName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.protocol!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.securityPolicy!,
      unittest.equals('foo'),
    );
    checkSecuritySettings(o.securitySettings!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed53(o.serviceBindings!);
    unittest.expect(
      o.sessionAffinity!,
      unittest.equals('foo'),
    );
    checkSubsetting(o.subsetting!);
    unittest.expect(
      o.timeoutSec!,
      unittest.equals(42),
    );
    checkUnnamed54(o.usedBy!);
  }
  buildCounterBackendService--;
}

core.Map<core.String, api.BackendServicesScopedList> buildUnnamed55() => {
      'x': buildBackendServicesScopedList(),
      'y': buildBackendServicesScopedList(),
    };

void checkUnnamed55(core.Map<core.String, api.BackendServicesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServicesScopedList(o['x']!);
  checkBackendServicesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed56() => [
      'foo',
      'foo',
    ];

void checkUnnamed56(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterBackendServiceAggregatedListWarningData = 0;
api.BackendServiceAggregatedListWarningData
    buildBackendServiceAggregatedListWarningData() {
  final o = api.BackendServiceAggregatedListWarningData();
  buildCounterBackendServiceAggregatedListWarningData++;
  if (buildCounterBackendServiceAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterBackendServiceAggregatedListWarningData--;
  return o;
}

void checkBackendServiceAggregatedListWarningData(
    api.BackendServiceAggregatedListWarningData o) {
  buildCounterBackendServiceAggregatedListWarningData++;
  if (buildCounterBackendServiceAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceAggregatedListWarningData--;
}

core.List<api.BackendServiceAggregatedListWarningData> buildUnnamed57() => [
      buildBackendServiceAggregatedListWarningData(),
      buildBackendServiceAggregatedListWarningData(),
    ];

void checkUnnamed57(core.List<api.BackendServiceAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceAggregatedListWarningData(o[0]);
  checkBackendServiceAggregatedListWarningData(o[1]);
}

core.int buildCounterBackendServiceAggregatedListWarning = 0;
api.BackendServiceAggregatedListWarning
    buildBackendServiceAggregatedListWarning() {
  final o = api.BackendServiceAggregatedListWarning();
  buildCounterBackendServiceAggregatedListWarning++;
  if (buildCounterBackendServiceAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed57();
    o.message = 'foo';
  }
  buildCounterBackendServiceAggregatedListWarning--;
  return o;
}

void checkBackendServiceAggregatedListWarning(
    api.BackendServiceAggregatedListWarning o) {
  buildCounterBackendServiceAggregatedListWarning++;
  if (buildCounterBackendServiceAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed57(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceAggregatedListWarning--;
}

core.int buildCounterBackendServiceAggregatedList = 0;
api.BackendServiceAggregatedList buildBackendServiceAggregatedList() {
  final o = api.BackendServiceAggregatedList();
  buildCounterBackendServiceAggregatedList++;
  if (buildCounterBackendServiceAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed55();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed56();
    o.warning = buildBackendServiceAggregatedListWarning();
  }
  buildCounterBackendServiceAggregatedList--;
  return o;
}

void checkBackendServiceAggregatedList(api.BackendServiceAggregatedList o) {
  buildCounterBackendServiceAggregatedList++;
  if (buildCounterBackendServiceAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed55(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed56(o.unreachables!);
    checkBackendServiceAggregatedListWarning(o.warning!);
  }
  buildCounterBackendServiceAggregatedList--;
}

core.List<api.BackendServiceCdnPolicyBypassCacheOnRequestHeader>
    buildUnnamed58() => [
          buildBackendServiceCdnPolicyBypassCacheOnRequestHeader(),
          buildBackendServiceCdnPolicyBypassCacheOnRequestHeader(),
        ];

void checkUnnamed58(
    core.List<api.BackendServiceCdnPolicyBypassCacheOnRequestHeader> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceCdnPolicyBypassCacheOnRequestHeader(o[0]);
  checkBackendServiceCdnPolicyBypassCacheOnRequestHeader(o[1]);
}

core.List<api.BackendServiceCdnPolicyNegativeCachingPolicy> buildUnnamed59() =>
    [
      buildBackendServiceCdnPolicyNegativeCachingPolicy(),
      buildBackendServiceCdnPolicyNegativeCachingPolicy(),
    ];

void checkUnnamed59(
    core.List<api.BackendServiceCdnPolicyNegativeCachingPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceCdnPolicyNegativeCachingPolicy(o[0]);
  checkBackendServiceCdnPolicyNegativeCachingPolicy(o[1]);
}

core.List<core.String> buildUnnamed60() => [
      'foo',
      'foo',
    ];

void checkUnnamed60(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterBackendServiceCdnPolicy = 0;
api.BackendServiceCdnPolicy buildBackendServiceCdnPolicy() {
  final o = api.BackendServiceCdnPolicy();
  buildCounterBackendServiceCdnPolicy++;
  if (buildCounterBackendServiceCdnPolicy < 3) {
    o.bypassCacheOnRequestHeaders = buildUnnamed58();
    o.cacheKeyPolicy = buildCacheKeyPolicy();
    o.cacheMode = 'foo';
    o.clientTtl = 42;
    o.defaultTtl = 42;
    o.maxTtl = 42;
    o.negativeCaching = true;
    o.negativeCachingPolicy = buildUnnamed59();
    o.requestCoalescing = true;
    o.serveWhileStale = 42;
    o.signedUrlCacheMaxAgeSec = 'foo';
    o.signedUrlKeyNames = buildUnnamed60();
  }
  buildCounterBackendServiceCdnPolicy--;
  return o;
}

void checkBackendServiceCdnPolicy(api.BackendServiceCdnPolicy o) {
  buildCounterBackendServiceCdnPolicy++;
  if (buildCounterBackendServiceCdnPolicy < 3) {
    checkUnnamed58(o.bypassCacheOnRequestHeaders!);
    checkCacheKeyPolicy(o.cacheKeyPolicy!);
    unittest.expect(
      o.cacheMode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.clientTtl!,
      unittest.equals(42),
    );
    unittest.expect(
      o.defaultTtl!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxTtl!,
      unittest.equals(42),
    );
    unittest.expect(o.negativeCaching!, unittest.isTrue);
    checkUnnamed59(o.negativeCachingPolicy!);
    unittest.expect(o.requestCoalescing!, unittest.isTrue);
    unittest.expect(
      o.serveWhileStale!,
      unittest.equals(42),
    );
    unittest.expect(
      o.signedUrlCacheMaxAgeSec!,
      unittest.equals('foo'),
    );
    checkUnnamed60(o.signedUrlKeyNames!);
  }
  buildCounterBackendServiceCdnPolicy--;
}

core.int buildCounterBackendServiceCdnPolicyBypassCacheOnRequestHeader = 0;
api.BackendServiceCdnPolicyBypassCacheOnRequestHeader
    buildBackendServiceCdnPolicyBypassCacheOnRequestHeader() {
  final o = api.BackendServiceCdnPolicyBypassCacheOnRequestHeader();
  buildCounterBackendServiceCdnPolicyBypassCacheOnRequestHeader++;
  if (buildCounterBackendServiceCdnPolicyBypassCacheOnRequestHeader < 3) {
    o.headerName = 'foo';
  }
  buildCounterBackendServiceCdnPolicyBypassCacheOnRequestHeader--;
  return o;
}

void checkBackendServiceCdnPolicyBypassCacheOnRequestHeader(
    api.BackendServiceCdnPolicyBypassCacheOnRequestHeader o) {
  buildCounterBackendServiceCdnPolicyBypassCacheOnRequestHeader++;
  if (buildCounterBackendServiceCdnPolicyBypassCacheOnRequestHeader < 3) {
    unittest.expect(
      o.headerName!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceCdnPolicyBypassCacheOnRequestHeader--;
}

core.int buildCounterBackendServiceCdnPolicyNegativeCachingPolicy = 0;
api.BackendServiceCdnPolicyNegativeCachingPolicy
    buildBackendServiceCdnPolicyNegativeCachingPolicy() {
  final o = api.BackendServiceCdnPolicyNegativeCachingPolicy();
  buildCounterBackendServiceCdnPolicyNegativeCachingPolicy++;
  if (buildCounterBackendServiceCdnPolicyNegativeCachingPolicy < 3) {
    o.code = 42;
    o.ttl = 42;
  }
  buildCounterBackendServiceCdnPolicyNegativeCachingPolicy--;
  return o;
}

void checkBackendServiceCdnPolicyNegativeCachingPolicy(
    api.BackendServiceCdnPolicyNegativeCachingPolicy o) {
  buildCounterBackendServiceCdnPolicyNegativeCachingPolicy++;
  if (buildCounterBackendServiceCdnPolicyNegativeCachingPolicy < 3) {
    unittest.expect(
      o.code!,
      unittest.equals(42),
    );
    unittest.expect(
      o.ttl!,
      unittest.equals(42),
    );
  }
  buildCounterBackendServiceCdnPolicyNegativeCachingPolicy--;
}

core.int buildCounterBackendServiceConnectionTrackingPolicy = 0;
api.BackendServiceConnectionTrackingPolicy
    buildBackendServiceConnectionTrackingPolicy() {
  final o = api.BackendServiceConnectionTrackingPolicy();
  buildCounterBackendServiceConnectionTrackingPolicy++;
  if (buildCounterBackendServiceConnectionTrackingPolicy < 3) {
    o.connectionPersistenceOnUnhealthyBackends = 'foo';
    o.enableStrongAffinity = true;
    o.idleTimeoutSec = 42;
    o.trackingMode = 'foo';
  }
  buildCounterBackendServiceConnectionTrackingPolicy--;
  return o;
}

void checkBackendServiceConnectionTrackingPolicy(
    api.BackendServiceConnectionTrackingPolicy o) {
  buildCounterBackendServiceConnectionTrackingPolicy++;
  if (buildCounterBackendServiceConnectionTrackingPolicy < 3) {
    unittest.expect(
      o.connectionPersistenceOnUnhealthyBackends!,
      unittest.equals('foo'),
    );
    unittest.expect(o.enableStrongAffinity!, unittest.isTrue);
    unittest.expect(
      o.idleTimeoutSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.trackingMode!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceConnectionTrackingPolicy--;
}

core.int buildCounterBackendServiceFailoverPolicy = 0;
api.BackendServiceFailoverPolicy buildBackendServiceFailoverPolicy() {
  final o = api.BackendServiceFailoverPolicy();
  buildCounterBackendServiceFailoverPolicy++;
  if (buildCounterBackendServiceFailoverPolicy < 3) {
    o.disableConnectionDrainOnFailover = true;
    o.dropTrafficIfUnhealthy = true;
    o.failoverRatio = 42.0;
  }
  buildCounterBackendServiceFailoverPolicy--;
  return o;
}

void checkBackendServiceFailoverPolicy(api.BackendServiceFailoverPolicy o) {
  buildCounterBackendServiceFailoverPolicy++;
  if (buildCounterBackendServiceFailoverPolicy < 3) {
    unittest.expect(o.disableConnectionDrainOnFailover!, unittest.isTrue);
    unittest.expect(o.dropTrafficIfUnhealthy!, unittest.isTrue);
    unittest.expect(
      o.failoverRatio!,
      unittest.equals(42.0),
    );
  }
  buildCounterBackendServiceFailoverPolicy--;
}

core.Map<core.String, core.String> buildUnnamed61() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed61(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<api.HealthStatus> buildUnnamed62() => [
      buildHealthStatus(),
      buildHealthStatus(),
    ];

void checkUnnamed62(core.List<api.HealthStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthStatus(o[0]);
  checkHealthStatus(o[1]);
}

core.int buildCounterBackendServiceGroupHealth = 0;
api.BackendServiceGroupHealth buildBackendServiceGroupHealth() {
  final o = api.BackendServiceGroupHealth();
  buildCounterBackendServiceGroupHealth++;
  if (buildCounterBackendServiceGroupHealth < 3) {
    o.annotations = buildUnnamed61();
    o.healthStatus = buildUnnamed62();
    o.kind = 'foo';
  }
  buildCounterBackendServiceGroupHealth--;
  return o;
}

void checkBackendServiceGroupHealth(api.BackendServiceGroupHealth o) {
  buildCounterBackendServiceGroupHealth++;
  if (buildCounterBackendServiceGroupHealth < 3) {
    checkUnnamed61(o.annotations!);
    checkUnnamed62(o.healthStatus!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceGroupHealth--;
}

core.int buildCounterBackendServiceIAP = 0;
api.BackendServiceIAP buildBackendServiceIAP() {
  final o = api.BackendServiceIAP();
  buildCounterBackendServiceIAP++;
  if (buildCounterBackendServiceIAP < 3) {
    o.enabled = true;
    o.oauth2ClientId = 'foo';
    o.oauth2ClientSecret = 'foo';
    o.oauth2ClientSecretSha256 = 'foo';
  }
  buildCounterBackendServiceIAP--;
  return o;
}

void checkBackendServiceIAP(api.BackendServiceIAP o) {
  buildCounterBackendServiceIAP++;
  if (buildCounterBackendServiceIAP < 3) {
    unittest.expect(o.enabled!, unittest.isTrue);
    unittest.expect(
      o.oauth2ClientId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.oauth2ClientSecret!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.oauth2ClientSecretSha256!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceIAP--;
}

core.List<api.BackendService> buildUnnamed63() => [
      buildBackendService(),
      buildBackendService(),
    ];

void checkUnnamed63(core.List<api.BackendService> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendService(o[0]);
  checkBackendService(o[1]);
}

core.int buildCounterBackendServiceListWarningData = 0;
api.BackendServiceListWarningData buildBackendServiceListWarningData() {
  final o = api.BackendServiceListWarningData();
  buildCounterBackendServiceListWarningData++;
  if (buildCounterBackendServiceListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterBackendServiceListWarningData--;
  return o;
}

void checkBackendServiceListWarningData(api.BackendServiceListWarningData o) {
  buildCounterBackendServiceListWarningData++;
  if (buildCounterBackendServiceListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceListWarningData--;
}

core.List<api.BackendServiceListWarningData> buildUnnamed64() => [
      buildBackendServiceListWarningData(),
      buildBackendServiceListWarningData(),
    ];

void checkUnnamed64(core.List<api.BackendServiceListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceListWarningData(o[0]);
  checkBackendServiceListWarningData(o[1]);
}

core.int buildCounterBackendServiceListWarning = 0;
api.BackendServiceListWarning buildBackendServiceListWarning() {
  final o = api.BackendServiceListWarning();
  buildCounterBackendServiceListWarning++;
  if (buildCounterBackendServiceListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed64();
    o.message = 'foo';
  }
  buildCounterBackendServiceListWarning--;
  return o;
}

void checkBackendServiceListWarning(api.BackendServiceListWarning o) {
  buildCounterBackendServiceListWarning++;
  if (buildCounterBackendServiceListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed64(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceListWarning--;
}

core.int buildCounterBackendServiceList = 0;
api.BackendServiceList buildBackendServiceList() {
  final o = api.BackendServiceList();
  buildCounterBackendServiceList++;
  if (buildCounterBackendServiceList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed63();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildBackendServiceListWarning();
  }
  buildCounterBackendServiceList--;
  return o;
}

void checkBackendServiceList(api.BackendServiceList o) {
  buildCounterBackendServiceList++;
  if (buildCounterBackendServiceList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed63(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkBackendServiceListWarning(o.warning!);
  }
  buildCounterBackendServiceList--;
}

core.List<api.BackendService> buildUnnamed65() => [
      buildBackendService(),
      buildBackendService(),
    ];

void checkUnnamed65(core.List<api.BackendService> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendService(o[0]);
  checkBackendService(o[1]);
}

core.int buildCounterBackendServiceListUsableWarningData = 0;
api.BackendServiceListUsableWarningData
    buildBackendServiceListUsableWarningData() {
  final o = api.BackendServiceListUsableWarningData();
  buildCounterBackendServiceListUsableWarningData++;
  if (buildCounterBackendServiceListUsableWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterBackendServiceListUsableWarningData--;
  return o;
}

void checkBackendServiceListUsableWarningData(
    api.BackendServiceListUsableWarningData o) {
  buildCounterBackendServiceListUsableWarningData++;
  if (buildCounterBackendServiceListUsableWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceListUsableWarningData--;
}

core.List<api.BackendServiceListUsableWarningData> buildUnnamed66() => [
      buildBackendServiceListUsableWarningData(),
      buildBackendServiceListUsableWarningData(),
    ];

void checkUnnamed66(core.List<api.BackendServiceListUsableWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServiceListUsableWarningData(o[0]);
  checkBackendServiceListUsableWarningData(o[1]);
}

core.int buildCounterBackendServiceListUsableWarning = 0;
api.BackendServiceListUsableWarning buildBackendServiceListUsableWarning() {
  final o = api.BackendServiceListUsableWarning();
  buildCounterBackendServiceListUsableWarning++;
  if (buildCounterBackendServiceListUsableWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed66();
    o.message = 'foo';
  }
  buildCounterBackendServiceListUsableWarning--;
  return o;
}

void checkBackendServiceListUsableWarning(
    api.BackendServiceListUsableWarning o) {
  buildCounterBackendServiceListUsableWarning++;
  if (buildCounterBackendServiceListUsableWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed66(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceListUsableWarning--;
}

core.int buildCounterBackendServiceListUsable = 0;
api.BackendServiceListUsable buildBackendServiceListUsable() {
  final o = api.BackendServiceListUsable();
  buildCounterBackendServiceListUsable++;
  if (buildCounterBackendServiceListUsable < 3) {
    o.id = 'foo';
    o.items = buildUnnamed65();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildBackendServiceListUsableWarning();
  }
  buildCounterBackendServiceListUsable--;
  return o;
}

void checkBackendServiceListUsable(api.BackendServiceListUsable o) {
  buildCounterBackendServiceListUsable++;
  if (buildCounterBackendServiceListUsable < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed65(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkBackendServiceListUsableWarning(o.warning!);
  }
  buildCounterBackendServiceListUsable--;
}

core.int buildCounterBackendServiceLocalityLoadBalancingPolicyConfig = 0;
api.BackendServiceLocalityLoadBalancingPolicyConfig
    buildBackendServiceLocalityLoadBalancingPolicyConfig() {
  final o = api.BackendServiceLocalityLoadBalancingPolicyConfig();
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfig++;
  if (buildCounterBackendServiceLocalityLoadBalancingPolicyConfig < 3) {
    o.customPolicy =
        buildBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy();
    o.policy = buildBackendServiceLocalityLoadBalancingPolicyConfigPolicy();
  }
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfig--;
  return o;
}

void checkBackendServiceLocalityLoadBalancingPolicyConfig(
    api.BackendServiceLocalityLoadBalancingPolicyConfig o) {
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfig++;
  if (buildCounterBackendServiceLocalityLoadBalancingPolicyConfig < 3) {
    checkBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy(
        o.customPolicy!);
    checkBackendServiceLocalityLoadBalancingPolicyConfigPolicy(o.policy!);
  }
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfig--;
}

core.int
    buildCounterBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy = 0;
api.BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy
    buildBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy() {
  final o = api.BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy();
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy++;
  if (buildCounterBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy <
      3) {
    o.data = 'foo';
    o.name = 'foo';
  }
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy--;
  return o;
}

void checkBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy(
    api.BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy o) {
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy++;
  if (buildCounterBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy <
      3) {
    unittest.expect(
      o.data!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy--;
}

core.int buildCounterBackendServiceLocalityLoadBalancingPolicyConfigPolicy = 0;
api.BackendServiceLocalityLoadBalancingPolicyConfigPolicy
    buildBackendServiceLocalityLoadBalancingPolicyConfigPolicy() {
  final o = api.BackendServiceLocalityLoadBalancingPolicyConfigPolicy();
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfigPolicy++;
  if (buildCounterBackendServiceLocalityLoadBalancingPolicyConfigPolicy < 3) {
    o.name = 'foo';
  }
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfigPolicy--;
  return o;
}

void checkBackendServiceLocalityLoadBalancingPolicyConfigPolicy(
    api.BackendServiceLocalityLoadBalancingPolicyConfigPolicy o) {
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfigPolicy++;
  if (buildCounterBackendServiceLocalityLoadBalancingPolicyConfigPolicy < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceLocalityLoadBalancingPolicyConfigPolicy--;
}

core.List<core.String> buildUnnamed67() => [
      'foo',
      'foo',
    ];

void checkUnnamed67(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterBackendServiceLogConfig = 0;
api.BackendServiceLogConfig buildBackendServiceLogConfig() {
  final o = api.BackendServiceLogConfig();
  buildCounterBackendServiceLogConfig++;
  if (buildCounterBackendServiceLogConfig < 3) {
    o.enable = true;
    o.optionalFields = buildUnnamed67();
    o.optionalMode = 'foo';
    o.sampleRate = 42.0;
  }
  buildCounterBackendServiceLogConfig--;
  return o;
}

void checkBackendServiceLogConfig(api.BackendServiceLogConfig o) {
  buildCounterBackendServiceLogConfig++;
  if (buildCounterBackendServiceLogConfig < 3) {
    unittest.expect(o.enable!, unittest.isTrue);
    checkUnnamed67(o.optionalFields!);
    unittest.expect(
      o.optionalMode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sampleRate!,
      unittest.equals(42.0),
    );
  }
  buildCounterBackendServiceLogConfig--;
}

core.int buildCounterBackendServiceReference = 0;
api.BackendServiceReference buildBackendServiceReference() {
  final o = api.BackendServiceReference();
  buildCounterBackendServiceReference++;
  if (buildCounterBackendServiceReference < 3) {
    o.backendService = 'foo';
  }
  buildCounterBackendServiceReference--;
  return o;
}

void checkBackendServiceReference(api.BackendServiceReference o) {
  buildCounterBackendServiceReference++;
  if (buildCounterBackendServiceReference < 3) {
    unittest.expect(
      o.backendService!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceReference--;
}

core.int buildCounterBackendServiceUsedBy = 0;
api.BackendServiceUsedBy buildBackendServiceUsedBy() {
  final o = api.BackendServiceUsedBy();
  buildCounterBackendServiceUsedBy++;
  if (buildCounterBackendServiceUsedBy < 3) {
    o.reference = 'foo';
  }
  buildCounterBackendServiceUsedBy--;
  return o;
}

void checkBackendServiceUsedBy(api.BackendServiceUsedBy o) {
  buildCounterBackendServiceUsedBy++;
  if (buildCounterBackendServiceUsedBy < 3) {
    unittest.expect(
      o.reference!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServiceUsedBy--;
}

core.List<api.BackendService> buildUnnamed68() => [
      buildBackendService(),
      buildBackendService(),
    ];

void checkUnnamed68(core.List<api.BackendService> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendService(o[0]);
  checkBackendService(o[1]);
}

core.int buildCounterBackendServicesScopedListWarningData = 0;
api.BackendServicesScopedListWarningData
    buildBackendServicesScopedListWarningData() {
  final o = api.BackendServicesScopedListWarningData();
  buildCounterBackendServicesScopedListWarningData++;
  if (buildCounterBackendServicesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterBackendServicesScopedListWarningData--;
  return o;
}

void checkBackendServicesScopedListWarningData(
    api.BackendServicesScopedListWarningData o) {
  buildCounterBackendServicesScopedListWarningData++;
  if (buildCounterBackendServicesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServicesScopedListWarningData--;
}

core.List<api.BackendServicesScopedListWarningData> buildUnnamed69() => [
      buildBackendServicesScopedListWarningData(),
      buildBackendServicesScopedListWarningData(),
    ];

void checkUnnamed69(core.List<api.BackendServicesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBackendServicesScopedListWarningData(o[0]);
  checkBackendServicesScopedListWarningData(o[1]);
}

core.int buildCounterBackendServicesScopedListWarning = 0;
api.BackendServicesScopedListWarning buildBackendServicesScopedListWarning() {
  final o = api.BackendServicesScopedListWarning();
  buildCounterBackendServicesScopedListWarning++;
  if (buildCounterBackendServicesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed69();
    o.message = 'foo';
  }
  buildCounterBackendServicesScopedListWarning--;
  return o;
}

void checkBackendServicesScopedListWarning(
    api.BackendServicesScopedListWarning o) {
  buildCounterBackendServicesScopedListWarning++;
  if (buildCounterBackendServicesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed69(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterBackendServicesScopedListWarning--;
}

core.int buildCounterBackendServicesScopedList = 0;
api.BackendServicesScopedList buildBackendServicesScopedList() {
  final o = api.BackendServicesScopedList();
  buildCounterBackendServicesScopedList++;
  if (buildCounterBackendServicesScopedList < 3) {
    o.backendServices = buildUnnamed68();
    o.warning = buildBackendServicesScopedListWarning();
  }
  buildCounterBackendServicesScopedList--;
  return o;
}

void checkBackendServicesScopedList(api.BackendServicesScopedList o) {
  buildCounterBackendServicesScopedList++;
  if (buildCounterBackendServicesScopedList < 3) {
    checkUnnamed68(o.backendServices!);
    checkBackendServicesScopedListWarning(o.warning!);
  }
  buildCounterBackendServicesScopedList--;
}

core.int buildCounterBfdPacket = 0;
api.BfdPacket buildBfdPacket() {
  final o = api.BfdPacket();
  buildCounterBfdPacket++;
  if (buildCounterBfdPacket < 3) {
    o.authenticationPresent = true;
    o.controlPlaneIndependent = true;
    o.demand = true;
    o.diagnostic = 'foo';
    o.final_ = true;
    o.length = 42;
    o.minEchoRxIntervalMs = 42;
    o.minRxIntervalMs = 42;
    o.minTxIntervalMs = 42;
    o.multiplier = 42;
    o.multipoint = true;
    o.myDiscriminator = 42;
    o.poll = true;
    o.state = 'foo';
    o.version = 42;
    o.yourDiscriminator = 42;
  }
  buildCounterBfdPacket--;
  return o;
}

void checkBfdPacket(api.BfdPacket o) {
  buildCounterBfdPacket++;
  if (buildCounterBfdPacket < 3) {
    unittest.expect(o.authenticationPresent!, unittest.isTrue);
    unittest.expect(o.controlPlaneIndependent!, unittest.isTrue);
    unittest.expect(o.demand!, unittest.isTrue);
    unittest.expect(
      o.diagnostic!,
      unittest.equals('foo'),
    );
    unittest.expect(o.final_!, unittest.isTrue);
    unittest.expect(
      o.length!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minEchoRxIntervalMs!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minRxIntervalMs!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minTxIntervalMs!,
      unittest.equals(42),
    );
    unittest.expect(
      o.multiplier!,
      unittest.equals(42),
    );
    unittest.expect(o.multipoint!, unittest.isTrue);
    unittest.expect(
      o.myDiscriminator!,
      unittest.equals(42),
    );
    unittest.expect(o.poll!, unittest.isTrue);
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.version!,
      unittest.equals(42),
    );
    unittest.expect(
      o.yourDiscriminator!,
      unittest.equals(42),
    );
  }
  buildCounterBfdPacket--;
}

core.List<api.PacketIntervals> buildUnnamed70() => [
      buildPacketIntervals(),
      buildPacketIntervals(),
    ];

void checkUnnamed70(core.List<api.PacketIntervals> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketIntervals(o[0]);
  checkPacketIntervals(o[1]);
}

core.int buildCounterBfdStatus = 0;
api.BfdStatus buildBfdStatus() {
  final o = api.BfdStatus();
  buildCounterBfdStatus++;
  if (buildCounterBfdStatus < 3) {
    o.bfdSessionInitializationMode = 'foo';
    o.configUpdateTimestampMicros = 'foo';
    o.controlPacketCounts = buildBfdStatusPacketCounts();
    o.controlPacketIntervals = buildUnnamed70();
    o.localDiagnostic = 'foo';
    o.localState = 'foo';
    o.negotiatedLocalControlTxIntervalMs = 42;
    o.rxPacket = buildBfdPacket();
    o.txPacket = buildBfdPacket();
    o.uptimeMs = 'foo';
  }
  buildCounterBfdStatus--;
  return o;
}

void checkBfdStatus(api.BfdStatus o) {
  buildCounterBfdStatus++;
  if (buildCounterBfdStatus < 3) {
    unittest.expect(
      o.bfdSessionInitializationMode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.configUpdateTimestampMicros!,
      unittest.equals('foo'),
    );
    checkBfdStatusPacketCounts(o.controlPacketCounts!);
    checkUnnamed70(o.controlPacketIntervals!);
    unittest.expect(
      o.localDiagnostic!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.localState!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.negotiatedLocalControlTxIntervalMs!,
      unittest.equals(42),
    );
    checkBfdPacket(o.rxPacket!);
    checkBfdPacket(o.txPacket!);
    unittest.expect(
      o.uptimeMs!,
      unittest.equals('foo'),
    );
  }
  buildCounterBfdStatus--;
}

core.int buildCounterBfdStatusPacketCounts = 0;
api.BfdStatusPacketCounts buildBfdStatusPacketCounts() {
  final o = api.BfdStatusPacketCounts();
  buildCounterBfdStatusPacketCounts++;
  if (buildCounterBfdStatusPacketCounts < 3) {
    o.numRx = 42;
    o.numRxRejected = 42;
    o.numRxSuccessful = 42;
    o.numTx = 42;
  }
  buildCounterBfdStatusPacketCounts--;
  return o;
}

void checkBfdStatusPacketCounts(api.BfdStatusPacketCounts o) {
  buildCounterBfdStatusPacketCounts++;
  if (buildCounterBfdStatusPacketCounts < 3) {
    unittest.expect(
      o.numRx!,
      unittest.equals(42),
    );
    unittest.expect(
      o.numRxRejected!,
      unittest.equals(42),
    );
    unittest.expect(
      o.numRxSuccessful!,
      unittest.equals(42),
    );
    unittest.expect(
      o.numTx!,
      unittest.equals(42),
    );
  }
  buildCounterBfdStatusPacketCounts--;
}

core.List<core.String> buildUnnamed71() => [
      'foo',
      'foo',
    ];

void checkUnnamed71(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterBinding = 0;
api.Binding buildBinding() {
  final o = api.Binding();
  buildCounterBinding++;
  if (buildCounterBinding < 3) {
    o.bindingId = 'foo';
    o.condition = buildExpr();
    o.members = buildUnnamed71();
    o.role = 'foo';
  }
  buildCounterBinding--;
  return o;
}

void checkBinding(api.Binding o) {
  buildCounterBinding++;
  if (buildCounterBinding < 3) {
    unittest.expect(
      o.bindingId!,
      unittest.equals('foo'),
    );
    checkExpr(o.condition!);
    checkUnnamed71(o.members!);
    unittest.expect(
      o.role!,
      unittest.equals('foo'),
    );
  }
  buildCounterBinding--;
}

core.int buildCounterBulkInsertDiskResource = 0;
api.BulkInsertDiskResource buildBulkInsertDiskResource() {
  final o = api.BulkInsertDiskResource();
  buildCounterBulkInsertDiskResource++;
  if (buildCounterBulkInsertDiskResource < 3) {
    o.sourceConsistencyGroupPolicy = 'foo';
  }
  buildCounterBulkInsertDiskResource--;
  return o;
}

void checkBulkInsertDiskResource(api.BulkInsertDiskResource o) {
  buildCounterBulkInsertDiskResource++;
  if (buildCounterBulkInsertDiskResource < 3) {
    unittest.expect(
      o.sourceConsistencyGroupPolicy!,
      unittest.equals('foo'),
    );
  }
  buildCounterBulkInsertDiskResource--;
}

core.Map<core.String, api.BulkInsertInstanceResourcePerInstanceProperties>
    buildUnnamed72() => {
          'x': buildBulkInsertInstanceResourcePerInstanceProperties(),
          'y': buildBulkInsertInstanceResourcePerInstanceProperties(),
        };

void checkUnnamed72(
    core.Map<core.String, api.BulkInsertInstanceResourcePerInstanceProperties>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBulkInsertInstanceResourcePerInstanceProperties(o['x']!);
  checkBulkInsertInstanceResourcePerInstanceProperties(o['y']!);
}

core.int buildCounterBulkInsertInstanceResource = 0;
api.BulkInsertInstanceResource buildBulkInsertInstanceResource() {
  final o = api.BulkInsertInstanceResource();
  buildCounterBulkInsertInstanceResource++;
  if (buildCounterBulkInsertInstanceResource < 3) {
    o.count = 'foo';
    o.instanceProperties = buildInstanceProperties();
    o.locationPolicy = buildLocationPolicy();
    o.minCount = 'foo';
    o.namePattern = 'foo';
    o.perInstanceProperties = buildUnnamed72();
    o.sourceInstanceTemplate = 'foo';
  }
  buildCounterBulkInsertInstanceResource--;
  return o;
}

void checkBulkInsertInstanceResource(api.BulkInsertInstanceResource o) {
  buildCounterBulkInsertInstanceResource++;
  if (buildCounterBulkInsertInstanceResource < 3) {
    unittest.expect(
      o.count!,
      unittest.equals('foo'),
    );
    checkInstanceProperties(o.instanceProperties!);
    checkLocationPolicy(o.locationPolicy!);
    unittest.expect(
      o.minCount!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.namePattern!,
      unittest.equals('foo'),
    );
    checkUnnamed72(o.perInstanceProperties!);
    unittest.expect(
      o.sourceInstanceTemplate!,
      unittest.equals('foo'),
    );
  }
  buildCounterBulkInsertInstanceResource--;
}

core.int buildCounterBulkInsertInstanceResourcePerInstanceProperties = 0;
api.BulkInsertInstanceResourcePerInstanceProperties
    buildBulkInsertInstanceResourcePerInstanceProperties() {
  final o = api.BulkInsertInstanceResourcePerInstanceProperties();
  buildCounterBulkInsertInstanceResourcePerInstanceProperties++;
  if (buildCounterBulkInsertInstanceResourcePerInstanceProperties < 3) {
    o.hostname = 'foo';
    o.name = 'foo';
  }
  buildCounterBulkInsertInstanceResourcePerInstanceProperties--;
  return o;
}

void checkBulkInsertInstanceResourcePerInstanceProperties(
    api.BulkInsertInstanceResourcePerInstanceProperties o) {
  buildCounterBulkInsertInstanceResourcePerInstanceProperties++;
  if (buildCounterBulkInsertInstanceResourcePerInstanceProperties < 3) {
    unittest.expect(
      o.hostname!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
  }
  buildCounterBulkInsertInstanceResourcePerInstanceProperties--;
}

core.int buildCounterBulkInsertOperationStatus = 0;
api.BulkInsertOperationStatus buildBulkInsertOperationStatus() {
  final o = api.BulkInsertOperationStatus();
  buildCounterBulkInsertOperationStatus++;
  if (buildCounterBulkInsertOperationStatus < 3) {
    o.createdVmCount = 42;
    o.deletedVmCount = 42;
    o.failedToCreateVmCount = 42;
    o.status = 'foo';
    o.targetVmCount = 42;
  }
  buildCounterBulkInsertOperationStatus--;
  return o;
}

void checkBulkInsertOperationStatus(api.BulkInsertOperationStatus o) {
  buildCounterBulkInsertOperationStatus++;
  if (buildCounterBulkInsertOperationStatus < 3) {
    unittest.expect(
      o.createdVmCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.deletedVmCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.failedToCreateVmCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.targetVmCount!,
      unittest.equals(42),
    );
  }
  buildCounterBulkInsertOperationStatus--;
}

core.int buildCounterCacheInvalidationRule = 0;
api.CacheInvalidationRule buildCacheInvalidationRule() {
  final o = api.CacheInvalidationRule();
  buildCounterCacheInvalidationRule++;
  if (buildCounterCacheInvalidationRule < 3) {
    o.host = 'foo';
    o.path = 'foo';
  }
  buildCounterCacheInvalidationRule--;
  return o;
}

void checkCacheInvalidationRule(api.CacheInvalidationRule o) {
  buildCounterCacheInvalidationRule++;
  if (buildCounterCacheInvalidationRule < 3) {
    unittest.expect(
      o.host!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.path!,
      unittest.equals('foo'),
    );
  }
  buildCounterCacheInvalidationRule--;
}

core.List<core.String> buildUnnamed73() => [
      'foo',
      'foo',
    ];

void checkUnnamed73(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed74() => [
      'foo',
      'foo',
    ];

void checkUnnamed74(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed75() => [
      'foo',
      'foo',
    ];

void checkUnnamed75(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed76() => [
      'foo',
      'foo',
    ];

void checkUnnamed76(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterCacheKeyPolicy = 0;
api.CacheKeyPolicy buildCacheKeyPolicy() {
  final o = api.CacheKeyPolicy();
  buildCounterCacheKeyPolicy++;
  if (buildCounterCacheKeyPolicy < 3) {
    o.includeHost = true;
    o.includeHttpHeaders = buildUnnamed73();
    o.includeNamedCookies = buildUnnamed74();
    o.includeProtocol = true;
    o.includeQueryString = true;
    o.queryStringBlacklist = buildUnnamed75();
    o.queryStringWhitelist = buildUnnamed76();
  }
  buildCounterCacheKeyPolicy--;
  return o;
}

void checkCacheKeyPolicy(api.CacheKeyPolicy o) {
  buildCounterCacheKeyPolicy++;
  if (buildCounterCacheKeyPolicy < 3) {
    unittest.expect(o.includeHost!, unittest.isTrue);
    checkUnnamed73(o.includeHttpHeaders!);
    checkUnnamed74(o.includeNamedCookies!);
    unittest.expect(o.includeProtocol!, unittest.isTrue);
    unittest.expect(o.includeQueryString!, unittest.isTrue);
    checkUnnamed75(o.queryStringBlacklist!);
    checkUnnamed76(o.queryStringWhitelist!);
  }
  buildCounterCacheKeyPolicy--;
}

core.int buildCounterCircuitBreakers = 0;
api.CircuitBreakers buildCircuitBreakers() {
  final o = api.CircuitBreakers();
  buildCounterCircuitBreakers++;
  if (buildCounterCircuitBreakers < 3) {
    o.maxConnections = 42;
    o.maxPendingRequests = 42;
    o.maxRequests = 42;
    o.maxRequestsPerConnection = 42;
    o.maxRetries = 42;
  }
  buildCounterCircuitBreakers--;
  return o;
}

void checkCircuitBreakers(api.CircuitBreakers o) {
  buildCounterCircuitBreakers++;
  if (buildCounterCircuitBreakers < 3) {
    unittest.expect(
      o.maxConnections!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxPendingRequests!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxRequests!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxRequestsPerConnection!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxRetries!,
      unittest.equals(42),
    );
  }
  buildCounterCircuitBreakers--;
}

core.List<core.String> buildUnnamed77() => [
      'foo',
      'foo',
    ];

void checkUnnamed77(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.Reservation> buildUnnamed78() => [
      buildReservation(),
      buildReservation(),
    ];

void checkUnnamed78(core.List<api.Reservation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservation(o[0]);
  checkReservation(o[1]);
}

core.List<api.ResourceCommitment> buildUnnamed79() => [
      buildResourceCommitment(),
      buildResourceCommitment(),
    ];

void checkUnnamed79(core.List<api.ResourceCommitment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourceCommitment(o[0]);
  checkResourceCommitment(o[1]);
}

core.int buildCounterCommitment = 0;
api.Commitment buildCommitment() {
  final o = api.Commitment();
  buildCounterCommitment++;
  if (buildCounterCommitment < 3) {
    o.autoRenew = true;
    o.category = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.endTimestamp = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.licenseResource = buildLicenseResourceCommitment();
    o.mergeSourceCommitments = buildUnnamed77();
    o.name = 'foo';
    o.plan = 'foo';
    o.region = 'foo';
    o.reservations = buildUnnamed78();
    o.resources = buildUnnamed79();
    o.selfLink = 'foo';
    o.splitSourceCommitment = 'foo';
    o.startTimestamp = 'foo';
    o.status = 'foo';
    o.statusMessage = 'foo';
    o.type = 'foo';
  }
  buildCounterCommitment--;
  return o;
}

void checkCommitment(api.Commitment o) {
  buildCounterCommitment++;
  if (buildCounterCommitment < 3) {
    unittest.expect(o.autoRenew!, unittest.isTrue);
    unittest.expect(
      o.category!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.endTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkLicenseResourceCommitment(o.licenseResource!);
    checkUnnamed77(o.mergeSourceCommitments!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.plan!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    checkUnnamed78(o.reservations!);
    checkUnnamed79(o.resources!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.splitSourceCommitment!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.startTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.statusMessage!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterCommitment--;
}

core.Map<core.String, api.CommitmentsScopedList> buildUnnamed80() => {
      'x': buildCommitmentsScopedList(),
      'y': buildCommitmentsScopedList(),
    };

void checkUnnamed80(core.Map<core.String, api.CommitmentsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitmentsScopedList(o['x']!);
  checkCommitmentsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed81() => [
      'foo',
      'foo',
    ];

void checkUnnamed81(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterCommitmentAggregatedListWarningData = 0;
api.CommitmentAggregatedListWarningData
    buildCommitmentAggregatedListWarningData() {
  final o = api.CommitmentAggregatedListWarningData();
  buildCounterCommitmentAggregatedListWarningData++;
  if (buildCounterCommitmentAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterCommitmentAggregatedListWarningData--;
  return o;
}

void checkCommitmentAggregatedListWarningData(
    api.CommitmentAggregatedListWarningData o) {
  buildCounterCommitmentAggregatedListWarningData++;
  if (buildCounterCommitmentAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterCommitmentAggregatedListWarningData--;
}

core.List<api.CommitmentAggregatedListWarningData> buildUnnamed82() => [
      buildCommitmentAggregatedListWarningData(),
      buildCommitmentAggregatedListWarningData(),
    ];

void checkUnnamed82(core.List<api.CommitmentAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitmentAggregatedListWarningData(o[0]);
  checkCommitmentAggregatedListWarningData(o[1]);
}

core.int buildCounterCommitmentAggregatedListWarning = 0;
api.CommitmentAggregatedListWarning buildCommitmentAggregatedListWarning() {
  final o = api.CommitmentAggregatedListWarning();
  buildCounterCommitmentAggregatedListWarning++;
  if (buildCounterCommitmentAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed82();
    o.message = 'foo';
  }
  buildCounterCommitmentAggregatedListWarning--;
  return o;
}

void checkCommitmentAggregatedListWarning(
    api.CommitmentAggregatedListWarning o) {
  buildCounterCommitmentAggregatedListWarning++;
  if (buildCounterCommitmentAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed82(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterCommitmentAggregatedListWarning--;
}

core.int buildCounterCommitmentAggregatedList = 0;
api.CommitmentAggregatedList buildCommitmentAggregatedList() {
  final o = api.CommitmentAggregatedList();
  buildCounterCommitmentAggregatedList++;
  if (buildCounterCommitmentAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed80();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed81();
    o.warning = buildCommitmentAggregatedListWarning();
  }
  buildCounterCommitmentAggregatedList--;
  return o;
}

void checkCommitmentAggregatedList(api.CommitmentAggregatedList o) {
  buildCounterCommitmentAggregatedList++;
  if (buildCounterCommitmentAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed80(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed81(o.unreachables!);
    checkCommitmentAggregatedListWarning(o.warning!);
  }
  buildCounterCommitmentAggregatedList--;
}

core.List<api.Commitment> buildUnnamed83() => [
      buildCommitment(),
      buildCommitment(),
    ];

void checkUnnamed83(core.List<api.Commitment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitment(o[0]);
  checkCommitment(o[1]);
}

core.int buildCounterCommitmentListWarningData = 0;
api.CommitmentListWarningData buildCommitmentListWarningData() {
  final o = api.CommitmentListWarningData();
  buildCounterCommitmentListWarningData++;
  if (buildCounterCommitmentListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterCommitmentListWarningData--;
  return o;
}

void checkCommitmentListWarningData(api.CommitmentListWarningData o) {
  buildCounterCommitmentListWarningData++;
  if (buildCounterCommitmentListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterCommitmentListWarningData--;
}

core.List<api.CommitmentListWarningData> buildUnnamed84() => [
      buildCommitmentListWarningData(),
      buildCommitmentListWarningData(),
    ];

void checkUnnamed84(core.List<api.CommitmentListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitmentListWarningData(o[0]);
  checkCommitmentListWarningData(o[1]);
}

core.int buildCounterCommitmentListWarning = 0;
api.CommitmentListWarning buildCommitmentListWarning() {
  final o = api.CommitmentListWarning();
  buildCounterCommitmentListWarning++;
  if (buildCounterCommitmentListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed84();
    o.message = 'foo';
  }
  buildCounterCommitmentListWarning--;
  return o;
}

void checkCommitmentListWarning(api.CommitmentListWarning o) {
  buildCounterCommitmentListWarning++;
  if (buildCounterCommitmentListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed84(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterCommitmentListWarning--;
}

core.int buildCounterCommitmentList = 0;
api.CommitmentList buildCommitmentList() {
  final o = api.CommitmentList();
  buildCounterCommitmentList++;
  if (buildCounterCommitmentList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed83();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildCommitmentListWarning();
  }
  buildCounterCommitmentList--;
  return o;
}

void checkCommitmentList(api.CommitmentList o) {
  buildCounterCommitmentList++;
  if (buildCounterCommitmentList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed83(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkCommitmentListWarning(o.warning!);
  }
  buildCounterCommitmentList--;
}

core.List<api.Commitment> buildUnnamed85() => [
      buildCommitment(),
      buildCommitment(),
    ];

void checkUnnamed85(core.List<api.Commitment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitment(o[0]);
  checkCommitment(o[1]);
}

core.int buildCounterCommitmentsScopedListWarningData = 0;
api.CommitmentsScopedListWarningData buildCommitmentsScopedListWarningData() {
  final o = api.CommitmentsScopedListWarningData();
  buildCounterCommitmentsScopedListWarningData++;
  if (buildCounterCommitmentsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterCommitmentsScopedListWarningData--;
  return o;
}

void checkCommitmentsScopedListWarningData(
    api.CommitmentsScopedListWarningData o) {
  buildCounterCommitmentsScopedListWarningData++;
  if (buildCounterCommitmentsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterCommitmentsScopedListWarningData--;
}

core.List<api.CommitmentsScopedListWarningData> buildUnnamed86() => [
      buildCommitmentsScopedListWarningData(),
      buildCommitmentsScopedListWarningData(),
    ];

void checkUnnamed86(core.List<api.CommitmentsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCommitmentsScopedListWarningData(o[0]);
  checkCommitmentsScopedListWarningData(o[1]);
}

core.int buildCounterCommitmentsScopedListWarning = 0;
api.CommitmentsScopedListWarning buildCommitmentsScopedListWarning() {
  final o = api.CommitmentsScopedListWarning();
  buildCounterCommitmentsScopedListWarning++;
  if (buildCounterCommitmentsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed86();
    o.message = 'foo';
  }
  buildCounterCommitmentsScopedListWarning--;
  return o;
}

void checkCommitmentsScopedListWarning(api.CommitmentsScopedListWarning o) {
  buildCounterCommitmentsScopedListWarning++;
  if (buildCounterCommitmentsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed86(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterCommitmentsScopedListWarning--;
}

core.int buildCounterCommitmentsScopedList = 0;
api.CommitmentsScopedList buildCommitmentsScopedList() {
  final o = api.CommitmentsScopedList();
  buildCounterCommitmentsScopedList++;
  if (buildCounterCommitmentsScopedList < 3) {
    o.commitments = buildUnnamed85();
    o.warning = buildCommitmentsScopedListWarning();
  }
  buildCounterCommitmentsScopedList--;
  return o;
}

void checkCommitmentsScopedList(api.CommitmentsScopedList o) {
  buildCounterCommitmentsScopedList++;
  if (buildCounterCommitmentsScopedList < 3) {
    checkUnnamed85(o.commitments!);
    checkCommitmentsScopedListWarning(o.warning!);
  }
  buildCounterCommitmentsScopedList--;
}

core.List<core.String> buildUnnamed87() => [
      'foo',
      'foo',
    ];

void checkUnnamed87(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterCondition = 0;
api.Condition buildCondition() {
  final o = api.Condition();
  buildCounterCondition++;
  if (buildCounterCondition < 3) {
    o.iam = 'foo';
    o.op = 'foo';
    o.svc = 'foo';
    o.sys = 'foo';
    o.values = buildUnnamed87();
  }
  buildCounterCondition--;
  return o;
}

void checkCondition(api.Condition o) {
  buildCounterCondition++;
  if (buildCounterCondition < 3) {
    unittest.expect(
      o.iam!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.op!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.svc!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sys!,
      unittest.equals('foo'),
    );
    checkUnnamed87(o.values!);
  }
  buildCounterCondition--;
}

core.int buildCounterConfidentialInstanceConfig = 0;
api.ConfidentialInstanceConfig buildConfidentialInstanceConfig() {
  final o = api.ConfidentialInstanceConfig();
  buildCounterConfidentialInstanceConfig++;
  if (buildCounterConfidentialInstanceConfig < 3) {
    o.enableConfidentialCompute = true;
  }
  buildCounterConfidentialInstanceConfig--;
  return o;
}

void checkConfidentialInstanceConfig(api.ConfidentialInstanceConfig o) {
  buildCounterConfidentialInstanceConfig++;
  if (buildCounterConfidentialInstanceConfig < 3) {
    unittest.expect(o.enableConfidentialCompute!, unittest.isTrue);
  }
  buildCounterConfidentialInstanceConfig--;
}

core.int buildCounterConnectionDraining = 0;
api.ConnectionDraining buildConnectionDraining() {
  final o = api.ConnectionDraining();
  buildCounterConnectionDraining++;
  if (buildCounterConnectionDraining < 3) {
    o.drainingTimeoutSec = 42;
  }
  buildCounterConnectionDraining--;
  return o;
}

void checkConnectionDraining(api.ConnectionDraining o) {
  buildCounterConnectionDraining++;
  if (buildCounterConnectionDraining < 3) {
    unittest.expect(
      o.drainingTimeoutSec!,
      unittest.equals(42),
    );
  }
  buildCounterConnectionDraining--;
}

core.int buildCounterConsistentHashLoadBalancerSettings = 0;
api.ConsistentHashLoadBalancerSettings
    buildConsistentHashLoadBalancerSettings() {
  final o = api.ConsistentHashLoadBalancerSettings();
  buildCounterConsistentHashLoadBalancerSettings++;
  if (buildCounterConsistentHashLoadBalancerSettings < 3) {
    o.httpCookie = buildConsistentHashLoadBalancerSettingsHttpCookie();
    o.httpHeaderName = 'foo';
    o.minimumRingSize = 'foo';
  }
  buildCounterConsistentHashLoadBalancerSettings--;
  return o;
}

void checkConsistentHashLoadBalancerSettings(
    api.ConsistentHashLoadBalancerSettings o) {
  buildCounterConsistentHashLoadBalancerSettings++;
  if (buildCounterConsistentHashLoadBalancerSettings < 3) {
    checkConsistentHashLoadBalancerSettingsHttpCookie(o.httpCookie!);
    unittest.expect(
      o.httpHeaderName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.minimumRingSize!,
      unittest.equals('foo'),
    );
  }
  buildCounterConsistentHashLoadBalancerSettings--;
}

core.int buildCounterConsistentHashLoadBalancerSettingsHttpCookie = 0;
api.ConsistentHashLoadBalancerSettingsHttpCookie
    buildConsistentHashLoadBalancerSettingsHttpCookie() {
  final o = api.ConsistentHashLoadBalancerSettingsHttpCookie();
  buildCounterConsistentHashLoadBalancerSettingsHttpCookie++;
  if (buildCounterConsistentHashLoadBalancerSettingsHttpCookie < 3) {
    o.name = 'foo';
    o.path = 'foo';
    o.ttl = buildDuration();
  }
  buildCounterConsistentHashLoadBalancerSettingsHttpCookie--;
  return o;
}

void checkConsistentHashLoadBalancerSettingsHttpCookie(
    api.ConsistentHashLoadBalancerSettingsHttpCookie o) {
  buildCounterConsistentHashLoadBalancerSettingsHttpCookie++;
  if (buildCounterConsistentHashLoadBalancerSettingsHttpCookie < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.path!,
      unittest.equals('foo'),
    );
    checkDuration(o.ttl!);
  }
  buildCounterConsistentHashLoadBalancerSettingsHttpCookie--;
}

core.List<core.String> buildUnnamed88() => [
      'foo',
      'foo',
    ];

void checkUnnamed88(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed89() => [
      'foo',
      'foo',
    ];

void checkUnnamed89(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed90() => [
      'foo',
      'foo',
    ];

void checkUnnamed90(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed91() => [
      'foo',
      'foo',
    ];

void checkUnnamed91(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed92() => [
      'foo',
      'foo',
    ];

void checkUnnamed92(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterCorsPolicy = 0;
api.CorsPolicy buildCorsPolicy() {
  final o = api.CorsPolicy();
  buildCounterCorsPolicy++;
  if (buildCounterCorsPolicy < 3) {
    o.allowCredentials = true;
    o.allowHeaders = buildUnnamed88();
    o.allowMethods = buildUnnamed89();
    o.allowOriginRegexes = buildUnnamed90();
    o.allowOrigins = buildUnnamed91();
    o.disabled = true;
    o.exposeHeaders = buildUnnamed92();
    o.maxAge = 42;
  }
  buildCounterCorsPolicy--;
  return o;
}

void checkCorsPolicy(api.CorsPolicy o) {
  buildCounterCorsPolicy++;
  if (buildCounterCorsPolicy < 3) {
    unittest.expect(o.allowCredentials!, unittest.isTrue);
    checkUnnamed88(o.allowHeaders!);
    checkUnnamed89(o.allowMethods!);
    checkUnnamed90(o.allowOriginRegexes!);
    checkUnnamed91(o.allowOrigins!);
    unittest.expect(o.disabled!, unittest.isTrue);
    checkUnnamed92(o.exposeHeaders!);
    unittest.expect(
      o.maxAge!,
      unittest.equals(42),
    );
  }
  buildCounterCorsPolicy--;
}

core.int buildCounterCustomerEncryptionKey = 0;
api.CustomerEncryptionKey buildCustomerEncryptionKey() {
  final o = api.CustomerEncryptionKey();
  buildCounterCustomerEncryptionKey++;
  if (buildCounterCustomerEncryptionKey < 3) {
    o.kmsKeyName = 'foo';
    o.kmsKeyServiceAccount = 'foo';
    o.rawKey = 'foo';
    o.rsaEncryptedKey = 'foo';
    o.sha256 = 'foo';
  }
  buildCounterCustomerEncryptionKey--;
  return o;
}

void checkCustomerEncryptionKey(api.CustomerEncryptionKey o) {
  buildCounterCustomerEncryptionKey++;
  if (buildCounterCustomerEncryptionKey < 3) {
    unittest.expect(
      o.kmsKeyName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kmsKeyServiceAccount!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.rawKey!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.rsaEncryptedKey!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sha256!,
      unittest.equals('foo'),
    );
  }
  buildCounterCustomerEncryptionKey--;
}

core.int buildCounterCustomerEncryptionKeyProtectedDisk = 0;
api.CustomerEncryptionKeyProtectedDisk
    buildCustomerEncryptionKeyProtectedDisk() {
  final o = api.CustomerEncryptionKeyProtectedDisk();
  buildCounterCustomerEncryptionKeyProtectedDisk++;
  if (buildCounterCustomerEncryptionKeyProtectedDisk < 3) {
    o.diskEncryptionKey = buildCustomerEncryptionKey();
    o.source = 'foo';
  }
  buildCounterCustomerEncryptionKeyProtectedDisk--;
  return o;
}

void checkCustomerEncryptionKeyProtectedDisk(
    api.CustomerEncryptionKeyProtectedDisk o) {
  buildCounterCustomerEncryptionKeyProtectedDisk++;
  if (buildCounterCustomerEncryptionKeyProtectedDisk < 3) {
    checkCustomerEncryptionKey(o.diskEncryptionKey!);
    unittest.expect(
      o.source!,
      unittest.equals('foo'),
    );
  }
  buildCounterCustomerEncryptionKeyProtectedDisk--;
}

core.int buildCounterDeprecationStatus = 0;
api.DeprecationStatus buildDeprecationStatus() {
  final o = api.DeprecationStatus();
  buildCounterDeprecationStatus++;
  if (buildCounterDeprecationStatus < 3) {
    o.deleted = 'foo';
    o.deprecated = 'foo';
    o.obsolete = 'foo';
    o.replacement = 'foo';
    o.state = 'foo';
  }
  buildCounterDeprecationStatus--;
  return o;
}

void checkDeprecationStatus(api.DeprecationStatus o) {
  buildCounterDeprecationStatus++;
  if (buildCounterDeprecationStatus < 3) {
    unittest.expect(
      o.deleted!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.deprecated!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.obsolete!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.replacement!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
  }
  buildCounterDeprecationStatus--;
}

core.Map<core.String, api.DiskAsyncReplicationList> buildUnnamed93() => {
      'x': buildDiskAsyncReplicationList(),
      'y': buildDiskAsyncReplicationList(),
    };

void checkUnnamed93(core.Map<core.String, api.DiskAsyncReplicationList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskAsyncReplicationList(o['x']!);
  checkDiskAsyncReplicationList(o['y']!);
}

core.List<api.GuestOsFeature> buildUnnamed94() => [
      buildGuestOsFeature(),
      buildGuestOsFeature(),
    ];

void checkUnnamed94(core.List<api.GuestOsFeature> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestOsFeature(o[0]);
  checkGuestOsFeature(o[1]);
}

core.Map<core.String, core.String> buildUnnamed95() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed95(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed96() => [
      'foo',
      'foo',
    ];

void checkUnnamed96(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed97() => [
      'foo',
      'foo',
    ];

void checkUnnamed97(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed98() => [
      'foo',
      'foo',
    ];

void checkUnnamed98(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed99() => [
      'foo',
      'foo',
    ];

void checkUnnamed99(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed100() => [
      'foo',
      'foo',
    ];

void checkUnnamed100(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterDisk = 0;
api.Disk buildDisk() {
  final o = api.Disk();
  buildCounterDisk++;
  if (buildCounterDisk < 3) {
    o.architecture = 'foo';
    o.asyncPrimaryDisk = buildDiskAsyncReplication();
    o.asyncSecondaryDisks = buildUnnamed93();
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.diskEncryptionKey = buildCustomerEncryptionKey();
    o.guestOsFeatures = buildUnnamed94();
    o.id = 'foo';
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed95();
    o.lastAttachTimestamp = 'foo';
    o.lastDetachTimestamp = 'foo';
    o.licenseCodes = buildUnnamed96();
    o.licenses = buildUnnamed97();
    o.locationHint = 'foo';
    o.name = 'foo';
    o.options = 'foo';
    o.params = buildDiskParams();
    o.physicalBlockSizeBytes = 'foo';
    o.provisionedIops = 'foo';
    o.provisionedThroughput = 'foo';
    o.region = 'foo';
    o.replicaZones = buildUnnamed98();
    o.resourcePolicies = buildUnnamed99();
    o.resourceStatus = buildDiskResourceStatus();
    o.satisfiesPzs = true;
    o.selfLink = 'foo';
    o.sizeGb = 'foo';
    o.sourceConsistencyGroupPolicy = 'foo';
    o.sourceConsistencyGroupPolicyId = 'foo';
    o.sourceDisk = 'foo';
    o.sourceDiskId = 'foo';
    o.sourceImage = 'foo';
    o.sourceImageEncryptionKey = buildCustomerEncryptionKey();
    o.sourceImageId = 'foo';
    o.sourceSnapshot = 'foo';
    o.sourceSnapshotEncryptionKey = buildCustomerEncryptionKey();
    o.sourceSnapshotId = 'foo';
    o.sourceStorageObject = 'foo';
    o.status = 'foo';
    o.type = 'foo';
    o.users = buildUnnamed100();
    o.zone = 'foo';
  }
  buildCounterDisk--;
  return o;
}

void checkDisk(api.Disk o) {
  buildCounterDisk++;
  if (buildCounterDisk < 3) {
    unittest.expect(
      o.architecture!,
      unittest.equals('foo'),
    );
    checkDiskAsyncReplication(o.asyncPrimaryDisk!);
    checkUnnamed93(o.asyncSecondaryDisks!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.diskEncryptionKey!);
    checkUnnamed94(o.guestOsFeatures!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed95(o.labels!);
    unittest.expect(
      o.lastAttachTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.lastDetachTimestamp!,
      unittest.equals('foo'),
    );
    checkUnnamed96(o.licenseCodes!);
    checkUnnamed97(o.licenses!);
    unittest.expect(
      o.locationHint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.options!,
      unittest.equals('foo'),
    );
    checkDiskParams(o.params!);
    unittest.expect(
      o.physicalBlockSizeBytes!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.provisionedIops!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.provisionedThroughput!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    checkUnnamed98(o.replicaZones!);
    checkUnnamed99(o.resourcePolicies!);
    checkDiskResourceStatus(o.resourceStatus!);
    unittest.expect(o.satisfiesPzs!, unittest.isTrue);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sizeGb!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceConsistencyGroupPolicy!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceConsistencyGroupPolicyId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceDisk!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceDiskId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceImage!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.sourceImageEncryptionKey!);
    unittest.expect(
      o.sourceImageId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceSnapshot!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.sourceSnapshotEncryptionKey!);
    unittest.expect(
      o.sourceSnapshotId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceStorageObject!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
    checkUnnamed100(o.users!);
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterDisk--;
}

core.Map<core.String, api.DisksScopedList> buildUnnamed101() => {
      'x': buildDisksScopedList(),
      'y': buildDisksScopedList(),
    };

void checkUnnamed101(core.Map<core.String, api.DisksScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDisksScopedList(o['x']!);
  checkDisksScopedList(o['y']!);
}

core.List<core.String> buildUnnamed102() => [
      'foo',
      'foo',
    ];

void checkUnnamed102(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterDiskAggregatedListWarningData = 0;
api.DiskAggregatedListWarningData buildDiskAggregatedListWarningData() {
  final o = api.DiskAggregatedListWarningData();
  buildCounterDiskAggregatedListWarningData++;
  if (buildCounterDiskAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterDiskAggregatedListWarningData--;
  return o;
}

void checkDiskAggregatedListWarningData(api.DiskAggregatedListWarningData o) {
  buildCounterDiskAggregatedListWarningData++;
  if (buildCounterDiskAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskAggregatedListWarningData--;
}

core.List<api.DiskAggregatedListWarningData> buildUnnamed103() => [
      buildDiskAggregatedListWarningData(),
      buildDiskAggregatedListWarningData(),
    ];

void checkUnnamed103(core.List<api.DiskAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskAggregatedListWarningData(o[0]);
  checkDiskAggregatedListWarningData(o[1]);
}

core.int buildCounterDiskAggregatedListWarning = 0;
api.DiskAggregatedListWarning buildDiskAggregatedListWarning() {
  final o = api.DiskAggregatedListWarning();
  buildCounterDiskAggregatedListWarning++;
  if (buildCounterDiskAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed103();
    o.message = 'foo';
  }
  buildCounterDiskAggregatedListWarning--;
  return o;
}

void checkDiskAggregatedListWarning(api.DiskAggregatedListWarning o) {
  buildCounterDiskAggregatedListWarning++;
  if (buildCounterDiskAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed103(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskAggregatedListWarning--;
}

core.int buildCounterDiskAggregatedList = 0;
api.DiskAggregatedList buildDiskAggregatedList() {
  final o = api.DiskAggregatedList();
  buildCounterDiskAggregatedList++;
  if (buildCounterDiskAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed101();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed102();
    o.warning = buildDiskAggregatedListWarning();
  }
  buildCounterDiskAggregatedList--;
  return o;
}

void checkDiskAggregatedList(api.DiskAggregatedList o) {
  buildCounterDiskAggregatedList++;
  if (buildCounterDiskAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed101(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed102(o.unreachables!);
    checkDiskAggregatedListWarning(o.warning!);
  }
  buildCounterDiskAggregatedList--;
}

core.int buildCounterDiskAsyncReplication = 0;
api.DiskAsyncReplication buildDiskAsyncReplication() {
  final o = api.DiskAsyncReplication();
  buildCounterDiskAsyncReplication++;
  if (buildCounterDiskAsyncReplication < 3) {
    o.consistencyGroupPolicy = 'foo';
    o.consistencyGroupPolicyId = 'foo';
    o.disk = 'foo';
    o.diskId = 'foo';
  }
  buildCounterDiskAsyncReplication--;
  return o;
}

void checkDiskAsyncReplication(api.DiskAsyncReplication o) {
  buildCounterDiskAsyncReplication++;
  if (buildCounterDiskAsyncReplication < 3) {
    unittest.expect(
      o.consistencyGroupPolicy!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.consistencyGroupPolicyId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.disk!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.diskId!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskAsyncReplication--;
}

core.int buildCounterDiskAsyncReplicationList = 0;
api.DiskAsyncReplicationList buildDiskAsyncReplicationList() {
  final o = api.DiskAsyncReplicationList();
  buildCounterDiskAsyncReplicationList++;
  if (buildCounterDiskAsyncReplicationList < 3) {
    o.asyncReplicationDisk = buildDiskAsyncReplication();
  }
  buildCounterDiskAsyncReplicationList--;
  return o;
}

void checkDiskAsyncReplicationList(api.DiskAsyncReplicationList o) {
  buildCounterDiskAsyncReplicationList++;
  if (buildCounterDiskAsyncReplicationList < 3) {
    checkDiskAsyncReplication(o.asyncReplicationDisk!);
  }
  buildCounterDiskAsyncReplicationList--;
}

core.int buildCounterDiskInstantiationConfig = 0;
api.DiskInstantiationConfig buildDiskInstantiationConfig() {
  final o = api.DiskInstantiationConfig();
  buildCounterDiskInstantiationConfig++;
  if (buildCounterDiskInstantiationConfig < 3) {
    o.autoDelete = true;
    o.customImage = 'foo';
    o.deviceName = 'foo';
    o.instantiateFrom = 'foo';
  }
  buildCounterDiskInstantiationConfig--;
  return o;
}

void checkDiskInstantiationConfig(api.DiskInstantiationConfig o) {
  buildCounterDiskInstantiationConfig++;
  if (buildCounterDiskInstantiationConfig < 3) {
    unittest.expect(o.autoDelete!, unittest.isTrue);
    unittest.expect(
      o.customImage!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.deviceName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.instantiateFrom!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskInstantiationConfig--;
}

core.List<api.Disk> buildUnnamed104() => [
      buildDisk(),
      buildDisk(),
    ];

void checkUnnamed104(core.List<api.Disk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDisk(o[0]);
  checkDisk(o[1]);
}

core.int buildCounterDiskListWarningData = 0;
api.DiskListWarningData buildDiskListWarningData() {
  final o = api.DiskListWarningData();
  buildCounterDiskListWarningData++;
  if (buildCounterDiskListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterDiskListWarningData--;
  return o;
}

void checkDiskListWarningData(api.DiskListWarningData o) {
  buildCounterDiskListWarningData++;
  if (buildCounterDiskListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskListWarningData--;
}

core.List<api.DiskListWarningData> buildUnnamed105() => [
      buildDiskListWarningData(),
      buildDiskListWarningData(),
    ];

void checkUnnamed105(core.List<api.DiskListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskListWarningData(o[0]);
  checkDiskListWarningData(o[1]);
}

core.int buildCounterDiskListWarning = 0;
api.DiskListWarning buildDiskListWarning() {
  final o = api.DiskListWarning();
  buildCounterDiskListWarning++;
  if (buildCounterDiskListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed105();
    o.message = 'foo';
  }
  buildCounterDiskListWarning--;
  return o;
}

void checkDiskListWarning(api.DiskListWarning o) {
  buildCounterDiskListWarning++;
  if (buildCounterDiskListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed105(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskListWarning--;
}

core.int buildCounterDiskList = 0;
api.DiskList buildDiskList() {
  final o = api.DiskList();
  buildCounterDiskList++;
  if (buildCounterDiskList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed104();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildDiskListWarning();
  }
  buildCounterDiskList--;
  return o;
}

void checkDiskList(api.DiskList o) {
  buildCounterDiskList++;
  if (buildCounterDiskList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed104(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkDiskListWarning(o.warning!);
  }
  buildCounterDiskList--;
}

core.int buildCounterDiskMoveRequest = 0;
api.DiskMoveRequest buildDiskMoveRequest() {
  final o = api.DiskMoveRequest();
  buildCounterDiskMoveRequest++;
  if (buildCounterDiskMoveRequest < 3) {
    o.destinationZone = 'foo';
    o.targetDisk = 'foo';
  }
  buildCounterDiskMoveRequest--;
  return o;
}

void checkDiskMoveRequest(api.DiskMoveRequest o) {
  buildCounterDiskMoveRequest++;
  if (buildCounterDiskMoveRequest < 3) {
    unittest.expect(
      o.destinationZone!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.targetDisk!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskMoveRequest--;
}

core.Map<core.String, core.String> buildUnnamed106() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed106(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterDiskParams = 0;
api.DiskParams buildDiskParams() {
  final o = api.DiskParams();
  buildCounterDiskParams++;
  if (buildCounterDiskParams < 3) {
    o.resourceManagerTags = buildUnnamed106();
  }
  buildCounterDiskParams--;
  return o;
}

void checkDiskParams(api.DiskParams o) {
  buildCounterDiskParams++;
  if (buildCounterDiskParams < 3) {
    checkUnnamed106(o.resourceManagerTags!);
  }
  buildCounterDiskParams--;
}

core.Map<core.String, api.DiskResourceStatusAsyncReplicationStatus>
    buildUnnamed107() => {
          'x': buildDiskResourceStatusAsyncReplicationStatus(),
          'y': buildDiskResourceStatusAsyncReplicationStatus(),
        };

void checkUnnamed107(
    core.Map<core.String, api.DiskResourceStatusAsyncReplicationStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskResourceStatusAsyncReplicationStatus(o['x']!);
  checkDiskResourceStatusAsyncReplicationStatus(o['y']!);
}

core.int buildCounterDiskResourceStatus = 0;
api.DiskResourceStatus buildDiskResourceStatus() {
  final o = api.DiskResourceStatus();
  buildCounterDiskResourceStatus++;
  if (buildCounterDiskResourceStatus < 3) {
    o.asyncPrimaryDisk = buildDiskResourceStatusAsyncReplicationStatus();
    o.asyncSecondaryDisks = buildUnnamed107();
  }
  buildCounterDiskResourceStatus--;
  return o;
}

void checkDiskResourceStatus(api.DiskResourceStatus o) {
  buildCounterDiskResourceStatus++;
  if (buildCounterDiskResourceStatus < 3) {
    checkDiskResourceStatusAsyncReplicationStatus(o.asyncPrimaryDisk!);
    checkUnnamed107(o.asyncSecondaryDisks!);
  }
  buildCounterDiskResourceStatus--;
}

core.int buildCounterDiskResourceStatusAsyncReplicationStatus = 0;
api.DiskResourceStatusAsyncReplicationStatus
    buildDiskResourceStatusAsyncReplicationStatus() {
  final o = api.DiskResourceStatusAsyncReplicationStatus();
  buildCounterDiskResourceStatusAsyncReplicationStatus++;
  if (buildCounterDiskResourceStatusAsyncReplicationStatus < 3) {
    o.state = 'foo';
  }
  buildCounterDiskResourceStatusAsyncReplicationStatus--;
  return o;
}

void checkDiskResourceStatusAsyncReplicationStatus(
    api.DiskResourceStatusAsyncReplicationStatus o) {
  buildCounterDiskResourceStatusAsyncReplicationStatus++;
  if (buildCounterDiskResourceStatusAsyncReplicationStatus < 3) {
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskResourceStatusAsyncReplicationStatus--;
}

core.int buildCounterDiskType = 0;
api.DiskType buildDiskType() {
  final o = api.DiskType();
  buildCounterDiskType++;
  if (buildCounterDiskType < 3) {
    o.creationTimestamp = 'foo';
    o.defaultDiskSizeGb = 'foo';
    o.deprecated = buildDeprecationStatus();
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.region = 'foo';
    o.selfLink = 'foo';
    o.validDiskSize = 'foo';
    o.zone = 'foo';
  }
  buildCounterDiskType--;
  return o;
}

void checkDiskType(api.DiskType o) {
  buildCounterDiskType++;
  if (buildCounterDiskType < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.defaultDiskSizeGb!,
      unittest.equals('foo'),
    );
    checkDeprecationStatus(o.deprecated!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.validDiskSize!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskType--;
}

core.Map<core.String, api.DiskTypesScopedList> buildUnnamed108() => {
      'x': buildDiskTypesScopedList(),
      'y': buildDiskTypesScopedList(),
    };

void checkUnnamed108(core.Map<core.String, api.DiskTypesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskTypesScopedList(o['x']!);
  checkDiskTypesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed109() => [
      'foo',
      'foo',
    ];

void checkUnnamed109(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterDiskTypeAggregatedListWarningData = 0;
api.DiskTypeAggregatedListWarningData buildDiskTypeAggregatedListWarningData() {
  final o = api.DiskTypeAggregatedListWarningData();
  buildCounterDiskTypeAggregatedListWarningData++;
  if (buildCounterDiskTypeAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterDiskTypeAggregatedListWarningData--;
  return o;
}

void checkDiskTypeAggregatedListWarningData(
    api.DiskTypeAggregatedListWarningData o) {
  buildCounterDiskTypeAggregatedListWarningData++;
  if (buildCounterDiskTypeAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskTypeAggregatedListWarningData--;
}

core.List<api.DiskTypeAggregatedListWarningData> buildUnnamed110() => [
      buildDiskTypeAggregatedListWarningData(),
      buildDiskTypeAggregatedListWarningData(),
    ];

void checkUnnamed110(core.List<api.DiskTypeAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskTypeAggregatedListWarningData(o[0]);
  checkDiskTypeAggregatedListWarningData(o[1]);
}

core.int buildCounterDiskTypeAggregatedListWarning = 0;
api.DiskTypeAggregatedListWarning buildDiskTypeAggregatedListWarning() {
  final o = api.DiskTypeAggregatedListWarning();
  buildCounterDiskTypeAggregatedListWarning++;
  if (buildCounterDiskTypeAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed110();
    o.message = 'foo';
  }
  buildCounterDiskTypeAggregatedListWarning--;
  return o;
}

void checkDiskTypeAggregatedListWarning(api.DiskTypeAggregatedListWarning o) {
  buildCounterDiskTypeAggregatedListWarning++;
  if (buildCounterDiskTypeAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed110(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskTypeAggregatedListWarning--;
}

core.int buildCounterDiskTypeAggregatedList = 0;
api.DiskTypeAggregatedList buildDiskTypeAggregatedList() {
  final o = api.DiskTypeAggregatedList();
  buildCounterDiskTypeAggregatedList++;
  if (buildCounterDiskTypeAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed108();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed109();
    o.warning = buildDiskTypeAggregatedListWarning();
  }
  buildCounterDiskTypeAggregatedList--;
  return o;
}

void checkDiskTypeAggregatedList(api.DiskTypeAggregatedList o) {
  buildCounterDiskTypeAggregatedList++;
  if (buildCounterDiskTypeAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed108(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed109(o.unreachables!);
    checkDiskTypeAggregatedListWarning(o.warning!);
  }
  buildCounterDiskTypeAggregatedList--;
}

core.List<api.DiskType> buildUnnamed111() => [
      buildDiskType(),
      buildDiskType(),
    ];

void checkUnnamed111(core.List<api.DiskType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskType(o[0]);
  checkDiskType(o[1]);
}

core.int buildCounterDiskTypeListWarningData = 0;
api.DiskTypeListWarningData buildDiskTypeListWarningData() {
  final o = api.DiskTypeListWarningData();
  buildCounterDiskTypeListWarningData++;
  if (buildCounterDiskTypeListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterDiskTypeListWarningData--;
  return o;
}

void checkDiskTypeListWarningData(api.DiskTypeListWarningData o) {
  buildCounterDiskTypeListWarningData++;
  if (buildCounterDiskTypeListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskTypeListWarningData--;
}

core.List<api.DiskTypeListWarningData> buildUnnamed112() => [
      buildDiskTypeListWarningData(),
      buildDiskTypeListWarningData(),
    ];

void checkUnnamed112(core.List<api.DiskTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskTypeListWarningData(o[0]);
  checkDiskTypeListWarningData(o[1]);
}

core.int buildCounterDiskTypeListWarning = 0;
api.DiskTypeListWarning buildDiskTypeListWarning() {
  final o = api.DiskTypeListWarning();
  buildCounterDiskTypeListWarning++;
  if (buildCounterDiskTypeListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed112();
    o.message = 'foo';
  }
  buildCounterDiskTypeListWarning--;
  return o;
}

void checkDiskTypeListWarning(api.DiskTypeListWarning o) {
  buildCounterDiskTypeListWarning++;
  if (buildCounterDiskTypeListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed112(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskTypeListWarning--;
}

core.int buildCounterDiskTypeList = 0;
api.DiskTypeList buildDiskTypeList() {
  final o = api.DiskTypeList();
  buildCounterDiskTypeList++;
  if (buildCounterDiskTypeList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed111();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildDiskTypeListWarning();
  }
  buildCounterDiskTypeList--;
  return o;
}

void checkDiskTypeList(api.DiskTypeList o) {
  buildCounterDiskTypeList++;
  if (buildCounterDiskTypeList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed111(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkDiskTypeListWarning(o.warning!);
  }
  buildCounterDiskTypeList--;
}

core.List<api.DiskType> buildUnnamed113() => [
      buildDiskType(),
      buildDiskType(),
    ];

void checkUnnamed113(core.List<api.DiskType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskType(o[0]);
  checkDiskType(o[1]);
}

core.int buildCounterDiskTypesScopedListWarningData = 0;
api.DiskTypesScopedListWarningData buildDiskTypesScopedListWarningData() {
  final o = api.DiskTypesScopedListWarningData();
  buildCounterDiskTypesScopedListWarningData++;
  if (buildCounterDiskTypesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterDiskTypesScopedListWarningData--;
  return o;
}

void checkDiskTypesScopedListWarningData(api.DiskTypesScopedListWarningData o) {
  buildCounterDiskTypesScopedListWarningData++;
  if (buildCounterDiskTypesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskTypesScopedListWarningData--;
}

core.List<api.DiskTypesScopedListWarningData> buildUnnamed114() => [
      buildDiskTypesScopedListWarningData(),
      buildDiskTypesScopedListWarningData(),
    ];

void checkUnnamed114(core.List<api.DiskTypesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskTypesScopedListWarningData(o[0]);
  checkDiskTypesScopedListWarningData(o[1]);
}

core.int buildCounterDiskTypesScopedListWarning = 0;
api.DiskTypesScopedListWarning buildDiskTypesScopedListWarning() {
  final o = api.DiskTypesScopedListWarning();
  buildCounterDiskTypesScopedListWarning++;
  if (buildCounterDiskTypesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed114();
    o.message = 'foo';
  }
  buildCounterDiskTypesScopedListWarning--;
  return o;
}

void checkDiskTypesScopedListWarning(api.DiskTypesScopedListWarning o) {
  buildCounterDiskTypesScopedListWarning++;
  if (buildCounterDiskTypesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed114(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterDiskTypesScopedListWarning--;
}

core.int buildCounterDiskTypesScopedList = 0;
api.DiskTypesScopedList buildDiskTypesScopedList() {
  final o = api.DiskTypesScopedList();
  buildCounterDiskTypesScopedList++;
  if (buildCounterDiskTypesScopedList < 3) {
    o.diskTypes = buildUnnamed113();
    o.warning = buildDiskTypesScopedListWarning();
  }
  buildCounterDiskTypesScopedList--;
  return o;
}

void checkDiskTypesScopedList(api.DiskTypesScopedList o) {
  buildCounterDiskTypesScopedList++;
  if (buildCounterDiskTypesScopedList < 3) {
    checkUnnamed113(o.diskTypes!);
    checkDiskTypesScopedListWarning(o.warning!);
  }
  buildCounterDiskTypesScopedList--;
}

core.List<core.String> buildUnnamed115() => [
      'foo',
      'foo',
    ];

void checkUnnamed115(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterDisksAddResourcePoliciesRequest = 0;
api.DisksAddResourcePoliciesRequest buildDisksAddResourcePoliciesRequest() {
  final o = api.DisksAddResourcePoliciesRequest();
  buildCounterDisksAddResourcePoliciesRequest++;
  if (buildCounterDisksAddResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed115();
  }
  buildCounterDisksAddResourcePoliciesRequest--;
  return o;
}

void checkDisksAddResourcePoliciesRequest(
    api.DisksAddResourcePoliciesRequest o) {
  buildCounterDisksAddResourcePoliciesRequest++;
  if (buildCounterDisksAddResourcePoliciesRequest < 3) {
    checkUnnamed115(o.resourcePolicies!);
  }
  buildCounterDisksAddResourcePoliciesRequest--;
}

core.List<core.String> buildUnnamed116() => [
      'foo',
      'foo',
    ];

void checkUnnamed116(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterDisksRemoveResourcePoliciesRequest = 0;
api.DisksRemoveResourcePoliciesRequest
    buildDisksRemoveResourcePoliciesRequest() {
  final o = api.DisksRemoveResourcePoliciesRequest();
  buildCounterDisksRemoveResourcePoliciesRequest++;
  if (buildCounterDisksRemoveResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed116();
  }
  buildCounterDisksRemoveResourcePoliciesRequest--;
  return o;
}

void checkDisksRemoveResourcePoliciesRequest(
    api.DisksRemoveResourcePoliciesRequest o) {
  buildCounterDisksRemoveResourcePoliciesRequest++;
  if (buildCounterDisksRemoveResourcePoliciesRequest < 3) {
    checkUnnamed116(o.resourcePolicies!);
  }
  buildCounterDisksRemoveResourcePoliciesRequest--;
}

core.int buildCounterDisksResizeRequest = 0;
api.DisksResizeRequest buildDisksResizeRequest() {
  final o = api.DisksResizeRequest();
  buildCounterDisksResizeRequest++;
  if (buildCounterDisksResizeRequest < 3) {
    o.sizeGb = 'foo';
  }
  buildCounterDisksResizeRequest--;
  return o;
}

void checkDisksResizeRequest(api.DisksResizeRequest o) {
  buildCounterDisksResizeRequest++;
  if (buildCounterDisksResizeRequest < 3) {
    unittest.expect(
      o.sizeGb!,
      unittest.equals('foo'),
    );
  }
  buildCounterDisksResizeRequest--;
}

core.List<api.Disk> buildUnnamed117() => [
      buildDisk(),
      buildDisk(),
    ];

void checkUnnamed117(core.List<api.Disk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDisk(o[0]);
  checkDisk(o[1]);
}

core.int buildCounterDisksScopedListWarningData = 0;
api.DisksScopedListWarningData buildDisksScopedListWarningData() {
  final o = api.DisksScopedListWarningData();
  buildCounterDisksScopedListWarningData++;
  if (buildCounterDisksScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterDisksScopedListWarningData--;
  return o;
}

void checkDisksScopedListWarningData(api.DisksScopedListWarningData o) {
  buildCounterDisksScopedListWarningData++;
  if (buildCounterDisksScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterDisksScopedListWarningData--;
}

core.List<api.DisksScopedListWarningData> buildUnnamed118() => [
      buildDisksScopedListWarningData(),
      buildDisksScopedListWarningData(),
    ];

void checkUnnamed118(core.List<api.DisksScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDisksScopedListWarningData(o[0]);
  checkDisksScopedListWarningData(o[1]);
}

core.int buildCounterDisksScopedListWarning = 0;
api.DisksScopedListWarning buildDisksScopedListWarning() {
  final o = api.DisksScopedListWarning();
  buildCounterDisksScopedListWarning++;
  if (buildCounterDisksScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed118();
    o.message = 'foo';
  }
  buildCounterDisksScopedListWarning--;
  return o;
}

void checkDisksScopedListWarning(api.DisksScopedListWarning o) {
  buildCounterDisksScopedListWarning++;
  if (buildCounterDisksScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed118(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterDisksScopedListWarning--;
}

core.int buildCounterDisksScopedList = 0;
api.DisksScopedList buildDisksScopedList() {
  final o = api.DisksScopedList();
  buildCounterDisksScopedList++;
  if (buildCounterDisksScopedList < 3) {
    o.disks = buildUnnamed117();
    o.warning = buildDisksScopedListWarning();
  }
  buildCounterDisksScopedList--;
  return o;
}

void checkDisksScopedList(api.DisksScopedList o) {
  buildCounterDisksScopedList++;
  if (buildCounterDisksScopedList < 3) {
    checkUnnamed117(o.disks!);
    checkDisksScopedListWarning(o.warning!);
  }
  buildCounterDisksScopedList--;
}

core.int buildCounterDisksStartAsyncReplicationRequest = 0;
api.DisksStartAsyncReplicationRequest buildDisksStartAsyncReplicationRequest() {
  final o = api.DisksStartAsyncReplicationRequest();
  buildCounterDisksStartAsyncReplicationRequest++;
  if (buildCounterDisksStartAsyncReplicationRequest < 3) {
    o.asyncSecondaryDisk = 'foo';
  }
  buildCounterDisksStartAsyncReplicationRequest--;
  return o;
}

void checkDisksStartAsyncReplicationRequest(
    api.DisksStartAsyncReplicationRequest o) {
  buildCounterDisksStartAsyncReplicationRequest++;
  if (buildCounterDisksStartAsyncReplicationRequest < 3) {
    unittest.expect(
      o.asyncSecondaryDisk!,
      unittest.equals('foo'),
    );
  }
  buildCounterDisksStartAsyncReplicationRequest--;
}

core.int buildCounterDisksStopGroupAsyncReplicationResource = 0;
api.DisksStopGroupAsyncReplicationResource
    buildDisksStopGroupAsyncReplicationResource() {
  final o = api.DisksStopGroupAsyncReplicationResource();
  buildCounterDisksStopGroupAsyncReplicationResource++;
  if (buildCounterDisksStopGroupAsyncReplicationResource < 3) {
    o.resourcePolicy = 'foo';
  }
  buildCounterDisksStopGroupAsyncReplicationResource--;
  return o;
}

void checkDisksStopGroupAsyncReplicationResource(
    api.DisksStopGroupAsyncReplicationResource o) {
  buildCounterDisksStopGroupAsyncReplicationResource++;
  if (buildCounterDisksStopGroupAsyncReplicationResource < 3) {
    unittest.expect(
      o.resourcePolicy!,
      unittest.equals('foo'),
    );
  }
  buildCounterDisksStopGroupAsyncReplicationResource--;
}

core.int buildCounterDisplayDevice = 0;
api.DisplayDevice buildDisplayDevice() {
  final o = api.DisplayDevice();
  buildCounterDisplayDevice++;
  if (buildCounterDisplayDevice < 3) {
    o.enableDisplay = true;
  }
  buildCounterDisplayDevice--;
  return o;
}

void checkDisplayDevice(api.DisplayDevice o) {
  buildCounterDisplayDevice++;
  if (buildCounterDisplayDevice < 3) {
    unittest.expect(o.enableDisplay!, unittest.isTrue);
  }
  buildCounterDisplayDevice--;
}

core.List<api.DistributionPolicyZoneConfiguration> buildUnnamed119() => [
      buildDistributionPolicyZoneConfiguration(),
      buildDistributionPolicyZoneConfiguration(),
    ];

void checkUnnamed119(core.List<api.DistributionPolicyZoneConfiguration> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDistributionPolicyZoneConfiguration(o[0]);
  checkDistributionPolicyZoneConfiguration(o[1]);
}

core.int buildCounterDistributionPolicy = 0;
api.DistributionPolicy buildDistributionPolicy() {
  final o = api.DistributionPolicy();
  buildCounterDistributionPolicy++;
  if (buildCounterDistributionPolicy < 3) {
    o.targetShape = 'foo';
    o.zones = buildUnnamed119();
  }
  buildCounterDistributionPolicy--;
  return o;
}

void checkDistributionPolicy(api.DistributionPolicy o) {
  buildCounterDistributionPolicy++;
  if (buildCounterDistributionPolicy < 3) {
    unittest.expect(
      o.targetShape!,
      unittest.equals('foo'),
    );
    checkUnnamed119(o.zones!);
  }
  buildCounterDistributionPolicy--;
}

core.int buildCounterDistributionPolicyZoneConfiguration = 0;
api.DistributionPolicyZoneConfiguration
    buildDistributionPolicyZoneConfiguration() {
  final o = api.DistributionPolicyZoneConfiguration();
  buildCounterDistributionPolicyZoneConfiguration++;
  if (buildCounterDistributionPolicyZoneConfiguration < 3) {
    o.zone = 'foo';
  }
  buildCounterDistributionPolicyZoneConfiguration--;
  return o;
}

void checkDistributionPolicyZoneConfiguration(
    api.DistributionPolicyZoneConfiguration o) {
  buildCounterDistributionPolicyZoneConfiguration++;
  if (buildCounterDistributionPolicyZoneConfiguration < 3) {
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterDistributionPolicyZoneConfiguration--;
}

core.int buildCounterDuration = 0;
api.Duration buildDuration() {
  final o = api.Duration();
  buildCounterDuration++;
  if (buildCounterDuration < 3) {
    o.nanos = 42;
    o.seconds = 'foo';
  }
  buildCounterDuration--;
  return o;
}

void checkDuration(api.Duration o) {
  buildCounterDuration++;
  if (buildCounterDuration < 3) {
    unittest.expect(
      o.nanos!,
      unittest.equals(42),
    );
    unittest.expect(
      o.seconds!,
      unittest.equals('foo'),
    );
  }
  buildCounterDuration--;
}

core.Map<core.String, core.String> buildUnnamed120() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed120(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterErrorInfo = 0;
api.ErrorInfo buildErrorInfo() {
  final o = api.ErrorInfo();
  buildCounterErrorInfo++;
  if (buildCounterErrorInfo < 3) {
    o.domain = 'foo';
    o.metadatas = buildUnnamed120();
    o.reason = 'foo';
  }
  buildCounterErrorInfo--;
  return o;
}

void checkErrorInfo(api.ErrorInfo o) {
  buildCounterErrorInfo++;
  if (buildCounterErrorInfo < 3) {
    unittest.expect(
      o.domain!,
      unittest.equals('foo'),
    );
    checkUnnamed120(o.metadatas!);
    unittest.expect(
      o.reason!,
      unittest.equals('foo'),
    );
  }
  buildCounterErrorInfo--;
}

core.int buildCounterExchangedPeeringRoute = 0;
api.ExchangedPeeringRoute buildExchangedPeeringRoute() {
  final o = api.ExchangedPeeringRoute();
  buildCounterExchangedPeeringRoute++;
  if (buildCounterExchangedPeeringRoute < 3) {
    o.destRange = 'foo';
    o.imported = true;
    o.nextHopRegion = 'foo';
    o.priority = 42;
    o.type = 'foo';
  }
  buildCounterExchangedPeeringRoute--;
  return o;
}

void checkExchangedPeeringRoute(api.ExchangedPeeringRoute o) {
  buildCounterExchangedPeeringRoute++;
  if (buildCounterExchangedPeeringRoute < 3) {
    unittest.expect(
      o.destRange!,
      unittest.equals('foo'),
    );
    unittest.expect(o.imported!, unittest.isTrue);
    unittest.expect(
      o.nextHopRegion!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.priority!,
      unittest.equals(42),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterExchangedPeeringRoute--;
}

core.List<api.ExchangedPeeringRoute> buildUnnamed121() => [
      buildExchangedPeeringRoute(),
      buildExchangedPeeringRoute(),
    ];

void checkUnnamed121(core.List<api.ExchangedPeeringRoute> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkExchangedPeeringRoute(o[0]);
  checkExchangedPeeringRoute(o[1]);
}

core.int buildCounterExchangedPeeringRoutesListWarningData = 0;
api.ExchangedPeeringRoutesListWarningData
    buildExchangedPeeringRoutesListWarningData() {
  final o = api.ExchangedPeeringRoutesListWarningData();
  buildCounterExchangedPeeringRoutesListWarningData++;
  if (buildCounterExchangedPeeringRoutesListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterExchangedPeeringRoutesListWarningData--;
  return o;
}

void checkExchangedPeeringRoutesListWarningData(
    api.ExchangedPeeringRoutesListWarningData o) {
  buildCounterExchangedPeeringRoutesListWarningData++;
  if (buildCounterExchangedPeeringRoutesListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterExchangedPeeringRoutesListWarningData--;
}

core.List<api.ExchangedPeeringRoutesListWarningData> buildUnnamed122() => [
      buildExchangedPeeringRoutesListWarningData(),
      buildExchangedPeeringRoutesListWarningData(),
    ];

void checkUnnamed122(core.List<api.ExchangedPeeringRoutesListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkExchangedPeeringRoutesListWarningData(o[0]);
  checkExchangedPeeringRoutesListWarningData(o[1]);
}

core.int buildCounterExchangedPeeringRoutesListWarning = 0;
api.ExchangedPeeringRoutesListWarning buildExchangedPeeringRoutesListWarning() {
  final o = api.ExchangedPeeringRoutesListWarning();
  buildCounterExchangedPeeringRoutesListWarning++;
  if (buildCounterExchangedPeeringRoutesListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed122();
    o.message = 'foo';
  }
  buildCounterExchangedPeeringRoutesListWarning--;
  return o;
}

void checkExchangedPeeringRoutesListWarning(
    api.ExchangedPeeringRoutesListWarning o) {
  buildCounterExchangedPeeringRoutesListWarning++;
  if (buildCounterExchangedPeeringRoutesListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed122(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterExchangedPeeringRoutesListWarning--;
}

core.int buildCounterExchangedPeeringRoutesList = 0;
api.ExchangedPeeringRoutesList buildExchangedPeeringRoutesList() {
  final o = api.ExchangedPeeringRoutesList();
  buildCounterExchangedPeeringRoutesList++;
  if (buildCounterExchangedPeeringRoutesList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed121();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildExchangedPeeringRoutesListWarning();
  }
  buildCounterExchangedPeeringRoutesList--;
  return o;
}

void checkExchangedPeeringRoutesList(api.ExchangedPeeringRoutesList o) {
  buildCounterExchangedPeeringRoutesList++;
  if (buildCounterExchangedPeeringRoutesList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed121(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkExchangedPeeringRoutesListWarning(o.warning!);
  }
  buildCounterExchangedPeeringRoutesList--;
}

core.int buildCounterExpr = 0;
api.Expr buildExpr() {
  final o = api.Expr();
  buildCounterExpr++;
  if (buildCounterExpr < 3) {
    o.description = 'foo';
    o.expression = 'foo';
    o.location = 'foo';
    o.title = 'foo';
  }
  buildCounterExpr--;
  return o;
}

void checkExpr(api.Expr o) {
  buildCounterExpr++;
  if (buildCounterExpr < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.expression!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.location!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.title!,
      unittest.equals('foo'),
    );
  }
  buildCounterExpr--;
}

core.List<api.ExternalVpnGatewayInterface> buildUnnamed123() => [
      buildExternalVpnGatewayInterface(),
      buildExternalVpnGatewayInterface(),
    ];

void checkUnnamed123(core.List<api.ExternalVpnGatewayInterface> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkExternalVpnGatewayInterface(o[0]);
  checkExternalVpnGatewayInterface(o[1]);
}

core.Map<core.String, core.String> buildUnnamed124() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed124(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterExternalVpnGateway = 0;
api.ExternalVpnGateway buildExternalVpnGateway() {
  final o = api.ExternalVpnGateway();
  buildCounterExternalVpnGateway++;
  if (buildCounterExternalVpnGateway < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.id = 'foo';
    o.interfaces = buildUnnamed123();
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed124();
    o.name = 'foo';
    o.redundancyType = 'foo';
    o.selfLink = 'foo';
  }
  buildCounterExternalVpnGateway--;
  return o;
}

void checkExternalVpnGateway(api.ExternalVpnGateway o) {
  buildCounterExternalVpnGateway++;
  if (buildCounterExternalVpnGateway < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed123(o.interfaces!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed124(o.labels!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.redundancyType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
  }
  buildCounterExternalVpnGateway--;
}

core.int buildCounterExternalVpnGatewayInterface = 0;
api.ExternalVpnGatewayInterface buildExternalVpnGatewayInterface() {
  final o = api.ExternalVpnGatewayInterface();
  buildCounterExternalVpnGatewayInterface++;
  if (buildCounterExternalVpnGatewayInterface < 3) {
    o.id = 42;
    o.ipAddress = 'foo';
  }
  buildCounterExternalVpnGatewayInterface--;
  return o;
}

void checkExternalVpnGatewayInterface(api.ExternalVpnGatewayInterface o) {
  buildCounterExternalVpnGatewayInterface++;
  if (buildCounterExternalVpnGatewayInterface < 3) {
    unittest.expect(
      o.id!,
      unittest.equals(42),
    );
    unittest.expect(
      o.ipAddress!,
      unittest.equals('foo'),
    );
  }
  buildCounterExternalVpnGatewayInterface--;
}

core.List<api.ExternalVpnGateway> buildUnnamed125() => [
      buildExternalVpnGateway(),
      buildExternalVpnGateway(),
    ];

void checkUnnamed125(core.List<api.ExternalVpnGateway> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkExternalVpnGateway(o[0]);
  checkExternalVpnGateway(o[1]);
}

core.int buildCounterExternalVpnGatewayListWarningData = 0;
api.ExternalVpnGatewayListWarningData buildExternalVpnGatewayListWarningData() {
  final o = api.ExternalVpnGatewayListWarningData();
  buildCounterExternalVpnGatewayListWarningData++;
  if (buildCounterExternalVpnGatewayListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterExternalVpnGatewayListWarningData--;
  return o;
}

void checkExternalVpnGatewayListWarningData(
    api.ExternalVpnGatewayListWarningData o) {
  buildCounterExternalVpnGatewayListWarningData++;
  if (buildCounterExternalVpnGatewayListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterExternalVpnGatewayListWarningData--;
}

core.List<api.ExternalVpnGatewayListWarningData> buildUnnamed126() => [
      buildExternalVpnGatewayListWarningData(),
      buildExternalVpnGatewayListWarningData(),
    ];

void checkUnnamed126(core.List<api.ExternalVpnGatewayListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkExternalVpnGatewayListWarningData(o[0]);
  checkExternalVpnGatewayListWarningData(o[1]);
}

core.int buildCounterExternalVpnGatewayListWarning = 0;
api.ExternalVpnGatewayListWarning buildExternalVpnGatewayListWarning() {
  final o = api.ExternalVpnGatewayListWarning();
  buildCounterExternalVpnGatewayListWarning++;
  if (buildCounterExternalVpnGatewayListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed126();
    o.message = 'foo';
  }
  buildCounterExternalVpnGatewayListWarning--;
  return o;
}

void checkExternalVpnGatewayListWarning(api.ExternalVpnGatewayListWarning o) {
  buildCounterExternalVpnGatewayListWarning++;
  if (buildCounterExternalVpnGatewayListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed126(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterExternalVpnGatewayListWarning--;
}

core.int buildCounterExternalVpnGatewayList = 0;
api.ExternalVpnGatewayList buildExternalVpnGatewayList() {
  final o = api.ExternalVpnGatewayList();
  buildCounterExternalVpnGatewayList++;
  if (buildCounterExternalVpnGatewayList < 3) {
    o.etag = 'foo';
    o.id = 'foo';
    o.items = buildUnnamed125();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildExternalVpnGatewayListWarning();
  }
  buildCounterExternalVpnGatewayList--;
  return o;
}

void checkExternalVpnGatewayList(api.ExternalVpnGatewayList o) {
  buildCounterExternalVpnGatewayList++;
  if (buildCounterExternalVpnGatewayList < 3) {
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed125(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkExternalVpnGatewayListWarning(o.warning!);
  }
  buildCounterExternalVpnGatewayList--;
}

core.int buildCounterFileContentBuffer = 0;
api.FileContentBuffer buildFileContentBuffer() {
  final o = api.FileContentBuffer();
  buildCounterFileContentBuffer++;
  if (buildCounterFileContentBuffer < 3) {
    o.content = 'foo';
    o.fileType = 'foo';
  }
  buildCounterFileContentBuffer--;
  return o;
}

void checkFileContentBuffer(api.FileContentBuffer o) {
  buildCounterFileContentBuffer++;
  if (buildCounterFileContentBuffer < 3) {
    unittest.expect(
      o.content!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fileType!,
      unittest.equals('foo'),
    );
  }
  buildCounterFileContentBuffer--;
}

core.List<core.String> buildUnnamed127() => [
      'foo',
      'foo',
    ];

void checkUnnamed127(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterFirewallAllowed = 0;
api.FirewallAllowed buildFirewallAllowed() {
  final o = api.FirewallAllowed();
  buildCounterFirewallAllowed++;
  if (buildCounterFirewallAllowed < 3) {
    o.IPProtocol = 'foo';
    o.ports = buildUnnamed127();
  }
  buildCounterFirewallAllowed--;
  return o;
}

void checkFirewallAllowed(api.FirewallAllowed o) {
  buildCounterFirewallAllowed++;
  if (buildCounterFirewallAllowed < 3) {
    unittest.expect(
      o.IPProtocol!,
      unittest.equals('foo'),
    );
    checkUnnamed127(o.ports!);
  }
  buildCounterFirewallAllowed--;
}

core.List<api.FirewallAllowed> buildUnnamed128() => [
      buildFirewallAllowed(),
      buildFirewallAllowed(),
    ];

void checkUnnamed128(core.List<api.FirewallAllowed> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallAllowed(o[0]);
  checkFirewallAllowed(o[1]);
}

core.List<core.String> buildUnnamed129() => [
      'foo',
      'foo',
    ];

void checkUnnamed129(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterFirewallDenied = 0;
api.FirewallDenied buildFirewallDenied() {
  final o = api.FirewallDenied();
  buildCounterFirewallDenied++;
  if (buildCounterFirewallDenied < 3) {
    o.IPProtocol = 'foo';
    o.ports = buildUnnamed129();
  }
  buildCounterFirewallDenied--;
  return o;
}

void checkFirewallDenied(api.FirewallDenied o) {
  buildCounterFirewallDenied++;
  if (buildCounterFirewallDenied < 3) {
    unittest.expect(
      o.IPProtocol!,
      unittest.equals('foo'),
    );
    checkUnnamed129(o.ports!);
  }
  buildCounterFirewallDenied--;
}

core.List<api.FirewallDenied> buildUnnamed130() => [
      buildFirewallDenied(),
      buildFirewallDenied(),
    ];

void checkUnnamed130(core.List<api.FirewallDenied> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallDenied(o[0]);
  checkFirewallDenied(o[1]);
}

core.List<core.String> buildUnnamed131() => [
      'foo',
      'foo',
    ];

void checkUnnamed131(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed132() => [
      'foo',
      'foo',
    ];

void checkUnnamed132(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed133() => [
      'foo',
      'foo',
    ];

void checkUnnamed133(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed134() => [
      'foo',
      'foo',
    ];

void checkUnnamed134(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed135() => [
      'foo',
      'foo',
    ];

void checkUnnamed135(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed136() => [
      'foo',
      'foo',
    ];

void checkUnnamed136(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterFirewall = 0;
api.Firewall buildFirewall() {
  final o = api.Firewall();
  buildCounterFirewall++;
  if (buildCounterFirewall < 3) {
    o.allowed = buildUnnamed128();
    o.creationTimestamp = 'foo';
    o.denied = buildUnnamed130();
    o.description = 'foo';
    o.destinationRanges = buildUnnamed131();
    o.direction = 'foo';
    o.disabled = true;
    o.id = 'foo';
    o.kind = 'foo';
    o.logConfig = buildFirewallLogConfig();
    o.name = 'foo';
    o.network = 'foo';
    o.priority = 42;
    o.selfLink = 'foo';
    o.sourceRanges = buildUnnamed132();
    o.sourceServiceAccounts = buildUnnamed133();
    o.sourceTags = buildUnnamed134();
    o.targetServiceAccounts = buildUnnamed135();
    o.targetTags = buildUnnamed136();
  }
  buildCounterFirewall--;
  return o;
}

void checkFirewall(api.Firewall o) {
  buildCounterFirewall++;
  if (buildCounterFirewall < 3) {
    checkUnnamed128(o.allowed!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkUnnamed130(o.denied!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed131(o.destinationRanges!);
    unittest.expect(
      o.direction!,
      unittest.equals('foo'),
    );
    unittest.expect(o.disabled!, unittest.isTrue);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkFirewallLogConfig(o.logConfig!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.priority!,
      unittest.equals(42),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed132(o.sourceRanges!);
    checkUnnamed133(o.sourceServiceAccounts!);
    checkUnnamed134(o.sourceTags!);
    checkUnnamed135(o.targetServiceAccounts!);
    checkUnnamed136(o.targetTags!);
  }
  buildCounterFirewall--;
}

core.List<api.Firewall> buildUnnamed137() => [
      buildFirewall(),
      buildFirewall(),
    ];

void checkUnnamed137(core.List<api.Firewall> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewall(o[0]);
  checkFirewall(o[1]);
}

core.int buildCounterFirewallListWarningData = 0;
api.FirewallListWarningData buildFirewallListWarningData() {
  final o = api.FirewallListWarningData();
  buildCounterFirewallListWarningData++;
  if (buildCounterFirewallListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterFirewallListWarningData--;
  return o;
}

void checkFirewallListWarningData(api.FirewallListWarningData o) {
  buildCounterFirewallListWarningData++;
  if (buildCounterFirewallListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallListWarningData--;
}

core.List<api.FirewallListWarningData> buildUnnamed138() => [
      buildFirewallListWarningData(),
      buildFirewallListWarningData(),
    ];

void checkUnnamed138(core.List<api.FirewallListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallListWarningData(o[0]);
  checkFirewallListWarningData(o[1]);
}

core.int buildCounterFirewallListWarning = 0;
api.FirewallListWarning buildFirewallListWarning() {
  final o = api.FirewallListWarning();
  buildCounterFirewallListWarning++;
  if (buildCounterFirewallListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed138();
    o.message = 'foo';
  }
  buildCounterFirewallListWarning--;
  return o;
}

void checkFirewallListWarning(api.FirewallListWarning o) {
  buildCounterFirewallListWarning++;
  if (buildCounterFirewallListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed138(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallListWarning--;
}

core.int buildCounterFirewallList = 0;
api.FirewallList buildFirewallList() {
  final o = api.FirewallList();
  buildCounterFirewallList++;
  if (buildCounterFirewallList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed137();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildFirewallListWarning();
  }
  buildCounterFirewallList--;
  return o;
}

void checkFirewallList(api.FirewallList o) {
  buildCounterFirewallList++;
  if (buildCounterFirewallList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed137(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkFirewallListWarning(o.warning!);
  }
  buildCounterFirewallList--;
}

core.int buildCounterFirewallLogConfig = 0;
api.FirewallLogConfig buildFirewallLogConfig() {
  final o = api.FirewallLogConfig();
  buildCounterFirewallLogConfig++;
  if (buildCounterFirewallLogConfig < 3) {
    o.enable = true;
    o.metadata = 'foo';
  }
  buildCounterFirewallLogConfig--;
  return o;
}

void checkFirewallLogConfig(api.FirewallLogConfig o) {
  buildCounterFirewallLogConfig++;
  if (buildCounterFirewallLogConfig < 3) {
    unittest.expect(o.enable!, unittest.isTrue);
    unittest.expect(
      o.metadata!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallLogConfig--;
}

core.List<api.FirewallPolicyAssociation> buildUnnamed139() => [
      buildFirewallPolicyAssociation(),
      buildFirewallPolicyAssociation(),
    ];

void checkUnnamed139(core.List<api.FirewallPolicyAssociation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyAssociation(o[0]);
  checkFirewallPolicyAssociation(o[1]);
}

core.int buildCounterFirewallPoliciesListAssociationsResponse = 0;
api.FirewallPoliciesListAssociationsResponse
    buildFirewallPoliciesListAssociationsResponse() {
  final o = api.FirewallPoliciesListAssociationsResponse();
  buildCounterFirewallPoliciesListAssociationsResponse++;
  if (buildCounterFirewallPoliciesListAssociationsResponse < 3) {
    o.associations = buildUnnamed139();
    o.kind = 'foo';
  }
  buildCounterFirewallPoliciesListAssociationsResponse--;
  return o;
}

void checkFirewallPoliciesListAssociationsResponse(
    api.FirewallPoliciesListAssociationsResponse o) {
  buildCounterFirewallPoliciesListAssociationsResponse++;
  if (buildCounterFirewallPoliciesListAssociationsResponse < 3) {
    checkUnnamed139(o.associations!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallPoliciesListAssociationsResponse--;
}

core.List<api.FirewallPolicyAssociation> buildUnnamed140() => [
      buildFirewallPolicyAssociation(),
      buildFirewallPolicyAssociation(),
    ];

void checkUnnamed140(core.List<api.FirewallPolicyAssociation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyAssociation(o[0]);
  checkFirewallPolicyAssociation(o[1]);
}

core.List<api.FirewallPolicyRule> buildUnnamed141() => [
      buildFirewallPolicyRule(),
      buildFirewallPolicyRule(),
    ];

void checkUnnamed141(core.List<api.FirewallPolicyRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyRule(o[0]);
  checkFirewallPolicyRule(o[1]);
}

core.int buildCounterFirewallPolicy = 0;
api.FirewallPolicy buildFirewallPolicy() {
  final o = api.FirewallPolicy();
  buildCounterFirewallPolicy++;
  if (buildCounterFirewallPolicy < 3) {
    o.associations = buildUnnamed140();
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.displayName = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.parent = 'foo';
    o.region = 'foo';
    o.ruleTupleCount = 42;
    o.rules = buildUnnamed141();
    o.selfLink = 'foo';
    o.selfLinkWithId = 'foo';
    o.shortName = 'foo';
  }
  buildCounterFirewallPolicy--;
  return o;
}

void checkFirewallPolicy(api.FirewallPolicy o) {
  buildCounterFirewallPolicy++;
  if (buildCounterFirewallPolicy < 3) {
    checkUnnamed140(o.associations!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.displayName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.parent!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ruleTupleCount!,
      unittest.equals(42),
    );
    checkUnnamed141(o.rules!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLinkWithId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.shortName!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallPolicy--;
}

core.int buildCounterFirewallPolicyAssociation = 0;
api.FirewallPolicyAssociation buildFirewallPolicyAssociation() {
  final o = api.FirewallPolicyAssociation();
  buildCounterFirewallPolicyAssociation++;
  if (buildCounterFirewallPolicyAssociation < 3) {
    o.attachmentTarget = 'foo';
    o.displayName = 'foo';
    o.firewallPolicyId = 'foo';
    o.name = 'foo';
    o.shortName = 'foo';
  }
  buildCounterFirewallPolicyAssociation--;
  return o;
}

void checkFirewallPolicyAssociation(api.FirewallPolicyAssociation o) {
  buildCounterFirewallPolicyAssociation++;
  if (buildCounterFirewallPolicyAssociation < 3) {
    unittest.expect(
      o.attachmentTarget!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.displayName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.firewallPolicyId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.shortName!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallPolicyAssociation--;
}

core.List<api.FirewallPolicy> buildUnnamed142() => [
      buildFirewallPolicy(),
      buildFirewallPolicy(),
    ];

void checkUnnamed142(core.List<api.FirewallPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicy(o[0]);
  checkFirewallPolicy(o[1]);
}

core.int buildCounterFirewallPolicyListWarningData = 0;
api.FirewallPolicyListWarningData buildFirewallPolicyListWarningData() {
  final o = api.FirewallPolicyListWarningData();
  buildCounterFirewallPolicyListWarningData++;
  if (buildCounterFirewallPolicyListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterFirewallPolicyListWarningData--;
  return o;
}

void checkFirewallPolicyListWarningData(api.FirewallPolicyListWarningData o) {
  buildCounterFirewallPolicyListWarningData++;
  if (buildCounterFirewallPolicyListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallPolicyListWarningData--;
}

core.List<api.FirewallPolicyListWarningData> buildUnnamed143() => [
      buildFirewallPolicyListWarningData(),
      buildFirewallPolicyListWarningData(),
    ];

void checkUnnamed143(core.List<api.FirewallPolicyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyListWarningData(o[0]);
  checkFirewallPolicyListWarningData(o[1]);
}

core.int buildCounterFirewallPolicyListWarning = 0;
api.FirewallPolicyListWarning buildFirewallPolicyListWarning() {
  final o = api.FirewallPolicyListWarning();
  buildCounterFirewallPolicyListWarning++;
  if (buildCounterFirewallPolicyListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed143();
    o.message = 'foo';
  }
  buildCounterFirewallPolicyListWarning--;
  return o;
}

void checkFirewallPolicyListWarning(api.FirewallPolicyListWarning o) {
  buildCounterFirewallPolicyListWarning++;
  if (buildCounterFirewallPolicyListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed143(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallPolicyListWarning--;
}

core.int buildCounterFirewallPolicyList = 0;
api.FirewallPolicyList buildFirewallPolicyList() {
  final o = api.FirewallPolicyList();
  buildCounterFirewallPolicyList++;
  if (buildCounterFirewallPolicyList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed142();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.warning = buildFirewallPolicyListWarning();
  }
  buildCounterFirewallPolicyList--;
  return o;
}

void checkFirewallPolicyList(api.FirewallPolicyList o) {
  buildCounterFirewallPolicyList++;
  if (buildCounterFirewallPolicyList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed142(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    checkFirewallPolicyListWarning(o.warning!);
  }
  buildCounterFirewallPolicyList--;
}

core.List<core.String> buildUnnamed144() => [
      'foo',
      'foo',
    ];

void checkUnnamed144(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.FirewallPolicyRuleSecureTag> buildUnnamed145() => [
      buildFirewallPolicyRuleSecureTag(),
      buildFirewallPolicyRuleSecureTag(),
    ];

void checkUnnamed145(core.List<api.FirewallPolicyRuleSecureTag> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyRuleSecureTag(o[0]);
  checkFirewallPolicyRuleSecureTag(o[1]);
}

core.List<core.String> buildUnnamed146() => [
      'foo',
      'foo',
    ];

void checkUnnamed146(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterFirewallPolicyRule = 0;
api.FirewallPolicyRule buildFirewallPolicyRule() {
  final o = api.FirewallPolicyRule();
  buildCounterFirewallPolicyRule++;
  if (buildCounterFirewallPolicyRule < 3) {
    o.action = 'foo';
    o.description = 'foo';
    o.direction = 'foo';
    o.disabled = true;
    o.enableLogging = true;
    o.kind = 'foo';
    o.match = buildFirewallPolicyRuleMatcher();
    o.priority = 42;
    o.ruleName = 'foo';
    o.ruleTupleCount = 42;
    o.targetResources = buildUnnamed144();
    o.targetSecureTags = buildUnnamed145();
    o.targetServiceAccounts = buildUnnamed146();
  }
  buildCounterFirewallPolicyRule--;
  return o;
}

void checkFirewallPolicyRule(api.FirewallPolicyRule o) {
  buildCounterFirewallPolicyRule++;
  if (buildCounterFirewallPolicyRule < 3) {
    unittest.expect(
      o.action!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.direction!,
      unittest.equals('foo'),
    );
    unittest.expect(o.disabled!, unittest.isTrue);
    unittest.expect(o.enableLogging!, unittest.isTrue);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkFirewallPolicyRuleMatcher(o.match!);
    unittest.expect(
      o.priority!,
      unittest.equals(42),
    );
    unittest.expect(
      o.ruleName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ruleTupleCount!,
      unittest.equals(42),
    );
    checkUnnamed144(o.targetResources!);
    checkUnnamed145(o.targetSecureTags!);
    checkUnnamed146(o.targetServiceAccounts!);
  }
  buildCounterFirewallPolicyRule--;
}

core.List<core.String> buildUnnamed147() => [
      'foo',
      'foo',
    ];

void checkUnnamed147(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed148() => [
      'foo',
      'foo',
    ];

void checkUnnamed148(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed149() => [
      'foo',
      'foo',
    ];

void checkUnnamed149(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed150() => [
      'foo',
      'foo',
    ];

void checkUnnamed150(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed151() => [
      'foo',
      'foo',
    ];

void checkUnnamed151(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.FirewallPolicyRuleMatcherLayer4Config> buildUnnamed152() => [
      buildFirewallPolicyRuleMatcherLayer4Config(),
      buildFirewallPolicyRuleMatcherLayer4Config(),
    ];

void checkUnnamed152(core.List<api.FirewallPolicyRuleMatcherLayer4Config> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyRuleMatcherLayer4Config(o[0]);
  checkFirewallPolicyRuleMatcherLayer4Config(o[1]);
}

core.List<core.String> buildUnnamed153() => [
      'foo',
      'foo',
    ];

void checkUnnamed153(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed154() => [
      'foo',
      'foo',
    ];

void checkUnnamed154(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed155() => [
      'foo',
      'foo',
    ];

void checkUnnamed155(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed156() => [
      'foo',
      'foo',
    ];

void checkUnnamed156(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.FirewallPolicyRuleSecureTag> buildUnnamed157() => [
      buildFirewallPolicyRuleSecureTag(),
      buildFirewallPolicyRuleSecureTag(),
    ];

void checkUnnamed157(core.List<api.FirewallPolicyRuleSecureTag> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyRuleSecureTag(o[0]);
  checkFirewallPolicyRuleSecureTag(o[1]);
}

core.List<core.String> buildUnnamed158() => [
      'foo',
      'foo',
    ];

void checkUnnamed158(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterFirewallPolicyRuleMatcher = 0;
api.FirewallPolicyRuleMatcher buildFirewallPolicyRuleMatcher() {
  final o = api.FirewallPolicyRuleMatcher();
  buildCounterFirewallPolicyRuleMatcher++;
  if (buildCounterFirewallPolicyRuleMatcher < 3) {
    o.destAddressGroups = buildUnnamed147();
    o.destFqdns = buildUnnamed148();
    o.destIpRanges = buildUnnamed149();
    o.destRegionCodes = buildUnnamed150();
    o.destThreatIntelligences = buildUnnamed151();
    o.layer4Configs = buildUnnamed152();
    o.srcAddressGroups = buildUnnamed153();
    o.srcFqdns = buildUnnamed154();
    o.srcIpRanges = buildUnnamed155();
    o.srcRegionCodes = buildUnnamed156();
    o.srcSecureTags = buildUnnamed157();
    o.srcThreatIntelligences = buildUnnamed158();
  }
  buildCounterFirewallPolicyRuleMatcher--;
  return o;
}

void checkFirewallPolicyRuleMatcher(api.FirewallPolicyRuleMatcher o) {
  buildCounterFirewallPolicyRuleMatcher++;
  if (buildCounterFirewallPolicyRuleMatcher < 3) {
    checkUnnamed147(o.destAddressGroups!);
    checkUnnamed148(o.destFqdns!);
    checkUnnamed149(o.destIpRanges!);
    checkUnnamed150(o.destRegionCodes!);
    checkUnnamed151(o.destThreatIntelligences!);
    checkUnnamed152(o.layer4Configs!);
    checkUnnamed153(o.srcAddressGroups!);
    checkUnnamed154(o.srcFqdns!);
    checkUnnamed155(o.srcIpRanges!);
    checkUnnamed156(o.srcRegionCodes!);
    checkUnnamed157(o.srcSecureTags!);
    checkUnnamed158(o.srcThreatIntelligences!);
  }
  buildCounterFirewallPolicyRuleMatcher--;
}

core.List<core.String> buildUnnamed159() => [
      'foo',
      'foo',
    ];

void checkUnnamed159(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterFirewallPolicyRuleMatcherLayer4Config = 0;
api.FirewallPolicyRuleMatcherLayer4Config
    buildFirewallPolicyRuleMatcherLayer4Config() {
  final o = api.FirewallPolicyRuleMatcherLayer4Config();
  buildCounterFirewallPolicyRuleMatcherLayer4Config++;
  if (buildCounterFirewallPolicyRuleMatcherLayer4Config < 3) {
    o.ipProtocol = 'foo';
    o.ports = buildUnnamed159();
  }
  buildCounterFirewallPolicyRuleMatcherLayer4Config--;
  return o;
}

void checkFirewallPolicyRuleMatcherLayer4Config(
    api.FirewallPolicyRuleMatcherLayer4Config o) {
  buildCounterFirewallPolicyRuleMatcherLayer4Config++;
  if (buildCounterFirewallPolicyRuleMatcherLayer4Config < 3) {
    unittest.expect(
      o.ipProtocol!,
      unittest.equals('foo'),
    );
    checkUnnamed159(o.ports!);
  }
  buildCounterFirewallPolicyRuleMatcherLayer4Config--;
}

core.int buildCounterFirewallPolicyRuleSecureTag = 0;
api.FirewallPolicyRuleSecureTag buildFirewallPolicyRuleSecureTag() {
  final o = api.FirewallPolicyRuleSecureTag();
  buildCounterFirewallPolicyRuleSecureTag++;
  if (buildCounterFirewallPolicyRuleSecureTag < 3) {
    o.name = 'foo';
    o.state = 'foo';
  }
  buildCounterFirewallPolicyRuleSecureTag--;
  return o;
}

void checkFirewallPolicyRuleSecureTag(api.FirewallPolicyRuleSecureTag o) {
  buildCounterFirewallPolicyRuleSecureTag++;
  if (buildCounterFirewallPolicyRuleSecureTag < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
  }
  buildCounterFirewallPolicyRuleSecureTag--;
}

core.int buildCounterFixedOrPercent = 0;
api.FixedOrPercent buildFixedOrPercent() {
  final o = api.FixedOrPercent();
  buildCounterFixedOrPercent++;
  if (buildCounterFixedOrPercent < 3) {
    o.calculated = 42;
    o.fixed = 42;
    o.percent = 42;
  }
  buildCounterFixedOrPercent--;
  return o;
}

void checkFixedOrPercent(api.FixedOrPercent o) {
  buildCounterFixedOrPercent++;
  if (buildCounterFixedOrPercent < 3) {
    unittest.expect(
      o.calculated!,
      unittest.equals(42),
    );
    unittest.expect(
      o.fixed!,
      unittest.equals(42),
    );
    unittest.expect(
      o.percent!,
      unittest.equals(42),
    );
  }
  buildCounterFixedOrPercent--;
}

core.Map<core.String, core.String> buildUnnamed160() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed160(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<api.MetadataFilter> buildUnnamed161() => [
      buildMetadataFilter(),
      buildMetadataFilter(),
    ];

void checkUnnamed161(core.List<api.MetadataFilter> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMetadataFilter(o[0]);
  checkMetadataFilter(o[1]);
}

core.List<core.String> buildUnnamed162() => [
      'foo',
      'foo',
    ];

void checkUnnamed162(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.ForwardingRuleServiceDirectoryRegistration> buildUnnamed163() => [
      buildForwardingRuleServiceDirectoryRegistration(),
      buildForwardingRuleServiceDirectoryRegistration(),
    ];

void checkUnnamed163(
    core.List<api.ForwardingRuleServiceDirectoryRegistration> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRuleServiceDirectoryRegistration(o[0]);
  checkForwardingRuleServiceDirectoryRegistration(o[1]);
}

core.List<core.String> buildUnnamed164() => [
      'foo',
      'foo',
    ];

void checkUnnamed164(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterForwardingRule = 0;
api.ForwardingRule buildForwardingRule() {
  final o = api.ForwardingRule();
  buildCounterForwardingRule++;
  if (buildCounterForwardingRule < 3) {
    o.IPAddress = 'foo';
    o.IPProtocol = 'foo';
    o.allPorts = true;
    o.allowGlobalAccess = true;
    o.allowPscGlobalAccess = true;
    o.backendService = 'foo';
    o.baseForwardingRule = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.ipVersion = 'foo';
    o.isMirroringCollector = true;
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed160();
    o.loadBalancingScheme = 'foo';
    o.metadataFilters = buildUnnamed161();
    o.name = 'foo';
    o.network = 'foo';
    o.networkTier = 'foo';
    o.noAutomateDnsZone = true;
    o.portRange = 'foo';
    o.ports = buildUnnamed162();
    o.pscConnectionId = 'foo';
    o.pscConnectionStatus = 'foo';
    o.region = 'foo';
    o.selfLink = 'foo';
    o.serviceDirectoryRegistrations = buildUnnamed163();
    o.serviceLabel = 'foo';
    o.serviceName = 'foo';
    o.sourceIpRanges = buildUnnamed164();
    o.subnetwork = 'foo';
    o.target = 'foo';
  }
  buildCounterForwardingRule--;
  return o;
}

void checkForwardingRule(api.ForwardingRule o) {
  buildCounterForwardingRule++;
  if (buildCounterForwardingRule < 3) {
    unittest.expect(
      o.IPAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.IPProtocol!,
      unittest.equals('foo'),
    );
    unittest.expect(o.allPorts!, unittest.isTrue);
    unittest.expect(o.allowGlobalAccess!, unittest.isTrue);
    unittest.expect(o.allowPscGlobalAccess!, unittest.isTrue);
    unittest.expect(
      o.backendService!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.baseForwardingRule!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipVersion!,
      unittest.equals('foo'),
    );
    unittest.expect(o.isMirroringCollector!, unittest.isTrue);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed160(o.labels!);
    unittest.expect(
      o.loadBalancingScheme!,
      unittest.equals('foo'),
    );
    checkUnnamed161(o.metadataFilters!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.networkTier!,
      unittest.equals('foo'),
    );
    unittest.expect(o.noAutomateDnsZone!, unittest.isTrue);
    unittest.expect(
      o.portRange!,
      unittest.equals('foo'),
    );
    checkUnnamed162(o.ports!);
    unittest.expect(
      o.pscConnectionId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.pscConnectionStatus!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed163(o.serviceDirectoryRegistrations!);
    unittest.expect(
      o.serviceLabel!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.serviceName!,
      unittest.equals('foo'),
    );
    checkUnnamed164(o.sourceIpRanges!);
    unittest.expect(
      o.subnetwork!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.target!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRule--;
}

core.Map<core.String, api.ForwardingRulesScopedList> buildUnnamed165() => {
      'x': buildForwardingRulesScopedList(),
      'y': buildForwardingRulesScopedList(),
    };

void checkUnnamed165(core.Map<core.String, api.ForwardingRulesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRulesScopedList(o['x']!);
  checkForwardingRulesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed166() => [
      'foo',
      'foo',
    ];

void checkUnnamed166(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterForwardingRuleAggregatedListWarningData = 0;
api.ForwardingRuleAggregatedListWarningData
    buildForwardingRuleAggregatedListWarningData() {
  final o = api.ForwardingRuleAggregatedListWarningData();
  buildCounterForwardingRuleAggregatedListWarningData++;
  if (buildCounterForwardingRuleAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterForwardingRuleAggregatedListWarningData--;
  return o;
}

void checkForwardingRuleAggregatedListWarningData(
    api.ForwardingRuleAggregatedListWarningData o) {
  buildCounterForwardingRuleAggregatedListWarningData++;
  if (buildCounterForwardingRuleAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRuleAggregatedListWarningData--;
}

core.List<api.ForwardingRuleAggregatedListWarningData> buildUnnamed167() => [
      buildForwardingRuleAggregatedListWarningData(),
      buildForwardingRuleAggregatedListWarningData(),
    ];

void checkUnnamed167(core.List<api.ForwardingRuleAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRuleAggregatedListWarningData(o[0]);
  checkForwardingRuleAggregatedListWarningData(o[1]);
}

core.int buildCounterForwardingRuleAggregatedListWarning = 0;
api.ForwardingRuleAggregatedListWarning
    buildForwardingRuleAggregatedListWarning() {
  final o = api.ForwardingRuleAggregatedListWarning();
  buildCounterForwardingRuleAggregatedListWarning++;
  if (buildCounterForwardingRuleAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed167();
    o.message = 'foo';
  }
  buildCounterForwardingRuleAggregatedListWarning--;
  return o;
}

void checkForwardingRuleAggregatedListWarning(
    api.ForwardingRuleAggregatedListWarning o) {
  buildCounterForwardingRuleAggregatedListWarning++;
  if (buildCounterForwardingRuleAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed167(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRuleAggregatedListWarning--;
}

core.int buildCounterForwardingRuleAggregatedList = 0;
api.ForwardingRuleAggregatedList buildForwardingRuleAggregatedList() {
  final o = api.ForwardingRuleAggregatedList();
  buildCounterForwardingRuleAggregatedList++;
  if (buildCounterForwardingRuleAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed165();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed166();
    o.warning = buildForwardingRuleAggregatedListWarning();
  }
  buildCounterForwardingRuleAggregatedList--;
  return o;
}

void checkForwardingRuleAggregatedList(api.ForwardingRuleAggregatedList o) {
  buildCounterForwardingRuleAggregatedList++;
  if (buildCounterForwardingRuleAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed165(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed166(o.unreachables!);
    checkForwardingRuleAggregatedListWarning(o.warning!);
  }
  buildCounterForwardingRuleAggregatedList--;
}

core.List<api.ForwardingRule> buildUnnamed168() => [
      buildForwardingRule(),
      buildForwardingRule(),
    ];

void checkUnnamed168(core.List<api.ForwardingRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRule(o[0]);
  checkForwardingRule(o[1]);
}

core.int buildCounterForwardingRuleListWarningData = 0;
api.ForwardingRuleListWarningData buildForwardingRuleListWarningData() {
  final o = api.ForwardingRuleListWarningData();
  buildCounterForwardingRuleListWarningData++;
  if (buildCounterForwardingRuleListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterForwardingRuleListWarningData--;
  return o;
}

void checkForwardingRuleListWarningData(api.ForwardingRuleListWarningData o) {
  buildCounterForwardingRuleListWarningData++;
  if (buildCounterForwardingRuleListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRuleListWarningData--;
}

core.List<api.ForwardingRuleListWarningData> buildUnnamed169() => [
      buildForwardingRuleListWarningData(),
      buildForwardingRuleListWarningData(),
    ];

void checkUnnamed169(core.List<api.ForwardingRuleListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRuleListWarningData(o[0]);
  checkForwardingRuleListWarningData(o[1]);
}

core.int buildCounterForwardingRuleListWarning = 0;
api.ForwardingRuleListWarning buildForwardingRuleListWarning() {
  final o = api.ForwardingRuleListWarning();
  buildCounterForwardingRuleListWarning++;
  if (buildCounterForwardingRuleListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed169();
    o.message = 'foo';
  }
  buildCounterForwardingRuleListWarning--;
  return o;
}

void checkForwardingRuleListWarning(api.ForwardingRuleListWarning o) {
  buildCounterForwardingRuleListWarning++;
  if (buildCounterForwardingRuleListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed169(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRuleListWarning--;
}

core.int buildCounterForwardingRuleList = 0;
api.ForwardingRuleList buildForwardingRuleList() {
  final o = api.ForwardingRuleList();
  buildCounterForwardingRuleList++;
  if (buildCounterForwardingRuleList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed168();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildForwardingRuleListWarning();
  }
  buildCounterForwardingRuleList--;
  return o;
}

void checkForwardingRuleList(api.ForwardingRuleList o) {
  buildCounterForwardingRuleList++;
  if (buildCounterForwardingRuleList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed168(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkForwardingRuleListWarning(o.warning!);
  }
  buildCounterForwardingRuleList--;
}

core.int buildCounterForwardingRuleReference = 0;
api.ForwardingRuleReference buildForwardingRuleReference() {
  final o = api.ForwardingRuleReference();
  buildCounterForwardingRuleReference++;
  if (buildCounterForwardingRuleReference < 3) {
    o.forwardingRule = 'foo';
  }
  buildCounterForwardingRuleReference--;
  return o;
}

void checkForwardingRuleReference(api.ForwardingRuleReference o) {
  buildCounterForwardingRuleReference++;
  if (buildCounterForwardingRuleReference < 3) {
    unittest.expect(
      o.forwardingRule!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRuleReference--;
}

core.int buildCounterForwardingRuleServiceDirectoryRegistration = 0;
api.ForwardingRuleServiceDirectoryRegistration
    buildForwardingRuleServiceDirectoryRegistration() {
  final o = api.ForwardingRuleServiceDirectoryRegistration();
  buildCounterForwardingRuleServiceDirectoryRegistration++;
  if (buildCounterForwardingRuleServiceDirectoryRegistration < 3) {
    o.namespace = 'foo';
    o.service = 'foo';
    o.serviceDirectoryRegion = 'foo';
  }
  buildCounterForwardingRuleServiceDirectoryRegistration--;
  return o;
}

void checkForwardingRuleServiceDirectoryRegistration(
    api.ForwardingRuleServiceDirectoryRegistration o) {
  buildCounterForwardingRuleServiceDirectoryRegistration++;
  if (buildCounterForwardingRuleServiceDirectoryRegistration < 3) {
    unittest.expect(
      o.namespace!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.service!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.serviceDirectoryRegion!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRuleServiceDirectoryRegistration--;
}

core.List<api.ForwardingRule> buildUnnamed170() => [
      buildForwardingRule(),
      buildForwardingRule(),
    ];

void checkUnnamed170(core.List<api.ForwardingRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRule(o[0]);
  checkForwardingRule(o[1]);
}

core.int buildCounterForwardingRulesScopedListWarningData = 0;
api.ForwardingRulesScopedListWarningData
    buildForwardingRulesScopedListWarningData() {
  final o = api.ForwardingRulesScopedListWarningData();
  buildCounterForwardingRulesScopedListWarningData++;
  if (buildCounterForwardingRulesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterForwardingRulesScopedListWarningData--;
  return o;
}

void checkForwardingRulesScopedListWarningData(
    api.ForwardingRulesScopedListWarningData o) {
  buildCounterForwardingRulesScopedListWarningData++;
  if (buildCounterForwardingRulesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRulesScopedListWarningData--;
}

core.List<api.ForwardingRulesScopedListWarningData> buildUnnamed171() => [
      buildForwardingRulesScopedListWarningData(),
      buildForwardingRulesScopedListWarningData(),
    ];

void checkUnnamed171(core.List<api.ForwardingRulesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkForwardingRulesScopedListWarningData(o[0]);
  checkForwardingRulesScopedListWarningData(o[1]);
}

core.int buildCounterForwardingRulesScopedListWarning = 0;
api.ForwardingRulesScopedListWarning buildForwardingRulesScopedListWarning() {
  final o = api.ForwardingRulesScopedListWarning();
  buildCounterForwardingRulesScopedListWarning++;
  if (buildCounterForwardingRulesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed171();
    o.message = 'foo';
  }
  buildCounterForwardingRulesScopedListWarning--;
  return o;
}

void checkForwardingRulesScopedListWarning(
    api.ForwardingRulesScopedListWarning o) {
  buildCounterForwardingRulesScopedListWarning++;
  if (buildCounterForwardingRulesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed171(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterForwardingRulesScopedListWarning--;
}

core.int buildCounterForwardingRulesScopedList = 0;
api.ForwardingRulesScopedList buildForwardingRulesScopedList() {
  final o = api.ForwardingRulesScopedList();
  buildCounterForwardingRulesScopedList++;
  if (buildCounterForwardingRulesScopedList < 3) {
    o.forwardingRules = buildUnnamed170();
    o.warning = buildForwardingRulesScopedListWarning();
  }
  buildCounterForwardingRulesScopedList--;
  return o;
}

void checkForwardingRulesScopedList(api.ForwardingRulesScopedList o) {
  buildCounterForwardingRulesScopedList++;
  if (buildCounterForwardingRulesScopedList < 3) {
    checkUnnamed170(o.forwardingRules!);
    checkForwardingRulesScopedListWarning(o.warning!);
  }
  buildCounterForwardingRulesScopedList--;
}

core.int buildCounterGRPCHealthCheck = 0;
api.GRPCHealthCheck buildGRPCHealthCheck() {
  final o = api.GRPCHealthCheck();
  buildCounterGRPCHealthCheck++;
  if (buildCounterGRPCHealthCheck < 3) {
    o.grpcServiceName = 'foo';
    o.port = 42;
    o.portName = 'foo';
    o.portSpecification = 'foo';
  }
  buildCounterGRPCHealthCheck--;
  return o;
}

void checkGRPCHealthCheck(api.GRPCHealthCheck o) {
  buildCounterGRPCHealthCheck++;
  if (buildCounterGRPCHealthCheck < 3) {
    unittest.expect(
      o.grpcServiceName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.portName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.portSpecification!,
      unittest.equals('foo'),
    );
  }
  buildCounterGRPCHealthCheck--;
}

core.int buildCounterGlobalAddressesMoveRequest = 0;
api.GlobalAddressesMoveRequest buildGlobalAddressesMoveRequest() {
  final o = api.GlobalAddressesMoveRequest();
  buildCounterGlobalAddressesMoveRequest++;
  if (buildCounterGlobalAddressesMoveRequest < 3) {
    o.description = 'foo';
    o.destinationAddress = 'foo';
  }
  buildCounterGlobalAddressesMoveRequest--;
  return o;
}

void checkGlobalAddressesMoveRequest(api.GlobalAddressesMoveRequest o) {
  buildCounterGlobalAddressesMoveRequest++;
  if (buildCounterGlobalAddressesMoveRequest < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.destinationAddress!,
      unittest.equals('foo'),
    );
  }
  buildCounterGlobalAddressesMoveRequest--;
}

core.List<api.NetworkEndpoint> buildUnnamed172() => [
      buildNetworkEndpoint(),
      buildNetworkEndpoint(),
    ];

void checkUnnamed172(core.List<api.NetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpoint(o[0]);
  checkNetworkEndpoint(o[1]);
}

core.int buildCounterGlobalNetworkEndpointGroupsAttachEndpointsRequest = 0;
api.GlobalNetworkEndpointGroupsAttachEndpointsRequest
    buildGlobalNetworkEndpointGroupsAttachEndpointsRequest() {
  final o = api.GlobalNetworkEndpointGroupsAttachEndpointsRequest();
  buildCounterGlobalNetworkEndpointGroupsAttachEndpointsRequest++;
  if (buildCounterGlobalNetworkEndpointGroupsAttachEndpointsRequest < 3) {
    o.networkEndpoints = buildUnnamed172();
  }
  buildCounterGlobalNetworkEndpointGroupsAttachEndpointsRequest--;
  return o;
}

void checkGlobalNetworkEndpointGroupsAttachEndpointsRequest(
    api.GlobalNetworkEndpointGroupsAttachEndpointsRequest o) {
  buildCounterGlobalNetworkEndpointGroupsAttachEndpointsRequest++;
  if (buildCounterGlobalNetworkEndpointGroupsAttachEndpointsRequest < 3) {
    checkUnnamed172(o.networkEndpoints!);
  }
  buildCounterGlobalNetworkEndpointGroupsAttachEndpointsRequest--;
}

core.List<api.NetworkEndpoint> buildUnnamed173() => [
      buildNetworkEndpoint(),
      buildNetworkEndpoint(),
    ];

void checkUnnamed173(core.List<api.NetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpoint(o[0]);
  checkNetworkEndpoint(o[1]);
}

core.int buildCounterGlobalNetworkEndpointGroupsDetachEndpointsRequest = 0;
api.GlobalNetworkEndpointGroupsDetachEndpointsRequest
    buildGlobalNetworkEndpointGroupsDetachEndpointsRequest() {
  final o = api.GlobalNetworkEndpointGroupsDetachEndpointsRequest();
  buildCounterGlobalNetworkEndpointGroupsDetachEndpointsRequest++;
  if (buildCounterGlobalNetworkEndpointGroupsDetachEndpointsRequest < 3) {
    o.networkEndpoints = buildUnnamed173();
  }
  buildCounterGlobalNetworkEndpointGroupsDetachEndpointsRequest--;
  return o;
}

void checkGlobalNetworkEndpointGroupsDetachEndpointsRequest(
    api.GlobalNetworkEndpointGroupsDetachEndpointsRequest o) {
  buildCounterGlobalNetworkEndpointGroupsDetachEndpointsRequest++;
  if (buildCounterGlobalNetworkEndpointGroupsDetachEndpointsRequest < 3) {
    checkUnnamed173(o.networkEndpoints!);
  }
  buildCounterGlobalNetworkEndpointGroupsDetachEndpointsRequest--;
}

core.List<api.Binding> buildUnnamed174() => [
      buildBinding(),
      buildBinding(),
    ];

void checkUnnamed174(core.List<api.Binding> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBinding(o[0]);
  checkBinding(o[1]);
}

core.int buildCounterGlobalOrganizationSetPolicyRequest = 0;
api.GlobalOrganizationSetPolicyRequest
    buildGlobalOrganizationSetPolicyRequest() {
  final o = api.GlobalOrganizationSetPolicyRequest();
  buildCounterGlobalOrganizationSetPolicyRequest++;
  if (buildCounterGlobalOrganizationSetPolicyRequest < 3) {
    o.bindings = buildUnnamed174();
    o.etag = 'foo';
    o.policy = buildPolicy();
  }
  buildCounterGlobalOrganizationSetPolicyRequest--;
  return o;
}

void checkGlobalOrganizationSetPolicyRequest(
    api.GlobalOrganizationSetPolicyRequest o) {
  buildCounterGlobalOrganizationSetPolicyRequest++;
  if (buildCounterGlobalOrganizationSetPolicyRequest < 3) {
    checkUnnamed174(o.bindings!);
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    checkPolicy(o.policy!);
  }
  buildCounterGlobalOrganizationSetPolicyRequest--;
}

core.Map<core.String, core.String> buildUnnamed175() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed175(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterGlobalSetLabelsRequest = 0;
api.GlobalSetLabelsRequest buildGlobalSetLabelsRequest() {
  final o = api.GlobalSetLabelsRequest();
  buildCounterGlobalSetLabelsRequest++;
  if (buildCounterGlobalSetLabelsRequest < 3) {
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed175();
  }
  buildCounterGlobalSetLabelsRequest--;
  return o;
}

void checkGlobalSetLabelsRequest(api.GlobalSetLabelsRequest o) {
  buildCounterGlobalSetLabelsRequest++;
  if (buildCounterGlobalSetLabelsRequest < 3) {
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed175(o.labels!);
  }
  buildCounterGlobalSetLabelsRequest--;
}

core.List<api.Binding> buildUnnamed176() => [
      buildBinding(),
      buildBinding(),
    ];

void checkUnnamed176(core.List<api.Binding> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBinding(o[0]);
  checkBinding(o[1]);
}

core.int buildCounterGlobalSetPolicyRequest = 0;
api.GlobalSetPolicyRequest buildGlobalSetPolicyRequest() {
  final o = api.GlobalSetPolicyRequest();
  buildCounterGlobalSetPolicyRequest++;
  if (buildCounterGlobalSetPolicyRequest < 3) {
    o.bindings = buildUnnamed176();
    o.etag = 'foo';
    o.policy = buildPolicy();
  }
  buildCounterGlobalSetPolicyRequest--;
  return o;
}

void checkGlobalSetPolicyRequest(api.GlobalSetPolicyRequest o) {
  buildCounterGlobalSetPolicyRequest++;
  if (buildCounterGlobalSetPolicyRequest < 3) {
    checkUnnamed176(o.bindings!);
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    checkPolicy(o.policy!);
  }
  buildCounterGlobalSetPolicyRequest--;
}

core.int buildCounterGuestAttributes = 0;
api.GuestAttributes buildGuestAttributes() {
  final o = api.GuestAttributes();
  buildCounterGuestAttributes++;
  if (buildCounterGuestAttributes < 3) {
    o.kind = 'foo';
    o.queryPath = 'foo';
    o.queryValue = buildGuestAttributesValue();
    o.selfLink = 'foo';
    o.variableKey = 'foo';
    o.variableValue = 'foo';
  }
  buildCounterGuestAttributes--;
  return o;
}

void checkGuestAttributes(api.GuestAttributes o) {
  buildCounterGuestAttributes++;
  if (buildCounterGuestAttributes < 3) {
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.queryPath!,
      unittest.equals('foo'),
    );
    checkGuestAttributesValue(o.queryValue!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.variableKey!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.variableValue!,
      unittest.equals('foo'),
    );
  }
  buildCounterGuestAttributes--;
}

core.int buildCounterGuestAttributesEntry = 0;
api.GuestAttributesEntry buildGuestAttributesEntry() {
  final o = api.GuestAttributesEntry();
  buildCounterGuestAttributesEntry++;
  if (buildCounterGuestAttributesEntry < 3) {
    o.key = 'foo';
    o.namespace = 'foo';
    o.value = 'foo';
  }
  buildCounterGuestAttributesEntry--;
  return o;
}

void checkGuestAttributesEntry(api.GuestAttributesEntry o) {
  buildCounterGuestAttributesEntry++;
  if (buildCounterGuestAttributesEntry < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.namespace!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterGuestAttributesEntry--;
}

core.List<api.GuestAttributesEntry> buildUnnamed177() => [
      buildGuestAttributesEntry(),
      buildGuestAttributesEntry(),
    ];

void checkUnnamed177(core.List<api.GuestAttributesEntry> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestAttributesEntry(o[0]);
  checkGuestAttributesEntry(o[1]);
}

core.int buildCounterGuestAttributesValue = 0;
api.GuestAttributesValue buildGuestAttributesValue() {
  final o = api.GuestAttributesValue();
  buildCounterGuestAttributesValue++;
  if (buildCounterGuestAttributesValue < 3) {
    o.items = buildUnnamed177();
  }
  buildCounterGuestAttributesValue--;
  return o;
}

void checkGuestAttributesValue(api.GuestAttributesValue o) {
  buildCounterGuestAttributesValue++;
  if (buildCounterGuestAttributesValue < 3) {
    checkUnnamed177(o.items!);
  }
  buildCounterGuestAttributesValue--;
}

core.int buildCounterGuestOsFeature = 0;
api.GuestOsFeature buildGuestOsFeature() {
  final o = api.GuestOsFeature();
  buildCounterGuestOsFeature++;
  if (buildCounterGuestOsFeature < 3) {
    o.type = 'foo';
  }
  buildCounterGuestOsFeature--;
  return o;
}

void checkGuestOsFeature(api.GuestOsFeature o) {
  buildCounterGuestOsFeature++;
  if (buildCounterGuestOsFeature < 3) {
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterGuestOsFeature--;
}

core.int buildCounterHTTP2HealthCheck = 0;
api.HTTP2HealthCheck buildHTTP2HealthCheck() {
  final o = api.HTTP2HealthCheck();
  buildCounterHTTP2HealthCheck++;
  if (buildCounterHTTP2HealthCheck < 3) {
    o.host = 'foo';
    o.port = 42;
    o.portName = 'foo';
    o.portSpecification = 'foo';
    o.proxyHeader = 'foo';
    o.requestPath = 'foo';
    o.response = 'foo';
  }
  buildCounterHTTP2HealthCheck--;
  return o;
}

void checkHTTP2HealthCheck(api.HTTP2HealthCheck o) {
  buildCounterHTTP2HealthCheck++;
  if (buildCounterHTTP2HealthCheck < 3) {
    unittest.expect(
      o.host!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.portName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.portSpecification!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.proxyHeader!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.requestPath!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.response!,
      unittest.equals('foo'),
    );
  }
  buildCounterHTTP2HealthCheck--;
}

core.int buildCounterHTTPHealthCheck = 0;
api.HTTPHealthCheck buildHTTPHealthCheck() {
  final o = api.HTTPHealthCheck();
  buildCounterHTTPHealthCheck++;
  if (buildCounterHTTPHealthCheck < 3) {
    o.host = 'foo';
    o.port = 42;
    o.portName = 'foo';
    o.portSpecification = 'foo';
    o.proxyHeader = 'foo';
    o.requestPath = 'foo';
    o.response = 'foo';
  }
  buildCounterHTTPHealthCheck--;
  return o;
}

void checkHTTPHealthCheck(api.HTTPHealthCheck o) {
  buildCounterHTTPHealthCheck++;
  if (buildCounterHTTPHealthCheck < 3) {
    unittest.expect(
      o.host!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.portName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.portSpecification!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.proxyHeader!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.requestPath!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.response!,
      unittest.equals('foo'),
    );
  }
  buildCounterHTTPHealthCheck--;
}

core.int buildCounterHTTPSHealthCheck = 0;
api.HTTPSHealthCheck buildHTTPSHealthCheck() {
  final o = api.HTTPSHealthCheck();
  buildCounterHTTPSHealthCheck++;
  if (buildCounterHTTPSHealthCheck < 3) {
    o.host = 'foo';
    o.port = 42;
    o.portName = 'foo';
    o.portSpecification = 'foo';
    o.proxyHeader = 'foo';
    o.requestPath = 'foo';
    o.response = 'foo';
  }
  buildCounterHTTPSHealthCheck--;
  return o;
}

void checkHTTPSHealthCheck(api.HTTPSHealthCheck o) {
  buildCounterHTTPSHealthCheck++;
  if (buildCounterHTTPSHealthCheck < 3) {
    unittest.expect(
      o.host!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.portName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.portSpecification!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.proxyHeader!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.requestPath!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.response!,
      unittest.equals('foo'),
    );
  }
  buildCounterHTTPSHealthCheck--;
}

core.int buildCounterHealthCheck = 0;
api.HealthCheck buildHealthCheck() {
  final o = api.HealthCheck();
  buildCounterHealthCheck++;
  if (buildCounterHealthCheck < 3) {
    o.checkIntervalSec = 42;
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.grpcHealthCheck = buildGRPCHealthCheck();
    o.healthyThreshold = 42;
    o.http2HealthCheck = buildHTTP2HealthCheck();
    o.httpHealthCheck = buildHTTPHealthCheck();
    o.httpsHealthCheck = buildHTTPSHealthCheck();
    o.id = 'foo';
    o.kind = 'foo';
    o.logConfig = buildHealthCheckLogConfig();
    o.name = 'foo';
    o.region = 'foo';
    o.selfLink = 'foo';
    o.sslHealthCheck = buildSSLHealthCheck();
    o.tcpHealthCheck = buildTCPHealthCheck();
    o.timeoutSec = 42;
    o.type = 'foo';
    o.unhealthyThreshold = 42;
  }
  buildCounterHealthCheck--;
  return o;
}

void checkHealthCheck(api.HealthCheck o) {
  buildCounterHealthCheck++;
  if (buildCounterHealthCheck < 3) {
    unittest.expect(
      o.checkIntervalSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkGRPCHealthCheck(o.grpcHealthCheck!);
    unittest.expect(
      o.healthyThreshold!,
      unittest.equals(42),
    );
    checkHTTP2HealthCheck(o.http2HealthCheck!);
    checkHTTPHealthCheck(o.httpHealthCheck!);
    checkHTTPSHealthCheck(o.httpsHealthCheck!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkHealthCheckLogConfig(o.logConfig!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkSSLHealthCheck(o.sslHealthCheck!);
    checkTCPHealthCheck(o.tcpHealthCheck!);
    unittest.expect(
      o.timeoutSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.unhealthyThreshold!,
      unittest.equals(42),
    );
  }
  buildCounterHealthCheck--;
}

core.List<api.HealthCheck> buildUnnamed178() => [
      buildHealthCheck(),
      buildHealthCheck(),
    ];

void checkUnnamed178(core.List<api.HealthCheck> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheck(o[0]);
  checkHealthCheck(o[1]);
}

core.int buildCounterHealthCheckListWarningData = 0;
api.HealthCheckListWarningData buildHealthCheckListWarningData() {
  final o = api.HealthCheckListWarningData();
  buildCounterHealthCheckListWarningData++;
  if (buildCounterHealthCheckListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterHealthCheckListWarningData--;
  return o;
}

void checkHealthCheckListWarningData(api.HealthCheckListWarningData o) {
  buildCounterHealthCheckListWarningData++;
  if (buildCounterHealthCheckListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthCheckListWarningData--;
}

core.List<api.HealthCheckListWarningData> buildUnnamed179() => [
      buildHealthCheckListWarningData(),
      buildHealthCheckListWarningData(),
    ];

void checkUnnamed179(core.List<api.HealthCheckListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheckListWarningData(o[0]);
  checkHealthCheckListWarningData(o[1]);
}

core.int buildCounterHealthCheckListWarning = 0;
api.HealthCheckListWarning buildHealthCheckListWarning() {
  final o = api.HealthCheckListWarning();
  buildCounterHealthCheckListWarning++;
  if (buildCounterHealthCheckListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed179();
    o.message = 'foo';
  }
  buildCounterHealthCheckListWarning--;
  return o;
}

void checkHealthCheckListWarning(api.HealthCheckListWarning o) {
  buildCounterHealthCheckListWarning++;
  if (buildCounterHealthCheckListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed179(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthCheckListWarning--;
}

core.int buildCounterHealthCheckList = 0;
api.HealthCheckList buildHealthCheckList() {
  final o = api.HealthCheckList();
  buildCounterHealthCheckList++;
  if (buildCounterHealthCheckList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed178();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildHealthCheckListWarning();
  }
  buildCounterHealthCheckList--;
  return o;
}

void checkHealthCheckList(api.HealthCheckList o) {
  buildCounterHealthCheckList++;
  if (buildCounterHealthCheckList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed178(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkHealthCheckListWarning(o.warning!);
  }
  buildCounterHealthCheckList--;
}

core.int buildCounterHealthCheckLogConfig = 0;
api.HealthCheckLogConfig buildHealthCheckLogConfig() {
  final o = api.HealthCheckLogConfig();
  buildCounterHealthCheckLogConfig++;
  if (buildCounterHealthCheckLogConfig < 3) {
    o.enable = true;
  }
  buildCounterHealthCheckLogConfig--;
  return o;
}

void checkHealthCheckLogConfig(api.HealthCheckLogConfig o) {
  buildCounterHealthCheckLogConfig++;
  if (buildCounterHealthCheckLogConfig < 3) {
    unittest.expect(o.enable!, unittest.isTrue);
  }
  buildCounterHealthCheckLogConfig--;
}

core.int buildCounterHealthCheckReference = 0;
api.HealthCheckReference buildHealthCheckReference() {
  final o = api.HealthCheckReference();
  buildCounterHealthCheckReference++;
  if (buildCounterHealthCheckReference < 3) {
    o.healthCheck = 'foo';
  }
  buildCounterHealthCheckReference--;
  return o;
}

void checkHealthCheckReference(api.HealthCheckReference o) {
  buildCounterHealthCheckReference++;
  if (buildCounterHealthCheckReference < 3) {
    unittest.expect(
      o.healthCheck!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthCheckReference--;
}

core.List<core.String> buildUnnamed180() => [
      'foo',
      'foo',
    ];

void checkUnnamed180(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed181() => [
      'foo',
      'foo',
    ];

void checkUnnamed181(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed182() => [
      'foo',
      'foo',
    ];

void checkUnnamed182(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterHealthCheckService = 0;
api.HealthCheckService buildHealthCheckService() {
  final o = api.HealthCheckService();
  buildCounterHealthCheckService++;
  if (buildCounterHealthCheckService < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.fingerprint = 'foo';
    o.healthChecks = buildUnnamed180();
    o.healthStatusAggregationPolicy = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.networkEndpointGroups = buildUnnamed181();
    o.notificationEndpoints = buildUnnamed182();
    o.region = 'foo';
    o.selfLink = 'foo';
  }
  buildCounterHealthCheckService--;
  return o;
}

void checkHealthCheckService(api.HealthCheckService o) {
  buildCounterHealthCheckService++;
  if (buildCounterHealthCheckService < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed180(o.healthChecks!);
    unittest.expect(
      o.healthStatusAggregationPolicy!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed181(o.networkEndpointGroups!);
    checkUnnamed182(o.notificationEndpoints!);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthCheckService--;
}

core.int buildCounterHealthCheckServiceReference = 0;
api.HealthCheckServiceReference buildHealthCheckServiceReference() {
  final o = api.HealthCheckServiceReference();
  buildCounterHealthCheckServiceReference++;
  if (buildCounterHealthCheckServiceReference < 3) {
    o.healthCheckService = 'foo';
  }
  buildCounterHealthCheckServiceReference--;
  return o;
}

void checkHealthCheckServiceReference(api.HealthCheckServiceReference o) {
  buildCounterHealthCheckServiceReference++;
  if (buildCounterHealthCheckServiceReference < 3) {
    unittest.expect(
      o.healthCheckService!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthCheckServiceReference--;
}

core.List<api.HealthCheckService> buildUnnamed183() => [
      buildHealthCheckService(),
      buildHealthCheckService(),
    ];

void checkUnnamed183(core.List<api.HealthCheckService> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheckService(o[0]);
  checkHealthCheckService(o[1]);
}

core.int buildCounterHealthCheckServicesListWarningData = 0;
api.HealthCheckServicesListWarningData
    buildHealthCheckServicesListWarningData() {
  final o = api.HealthCheckServicesListWarningData();
  buildCounterHealthCheckServicesListWarningData++;
  if (buildCounterHealthCheckServicesListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterHealthCheckServicesListWarningData--;
  return o;
}

void checkHealthCheckServicesListWarningData(
    api.HealthCheckServicesListWarningData o) {
  buildCounterHealthCheckServicesListWarningData++;
  if (buildCounterHealthCheckServicesListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthCheckServicesListWarningData--;
}

core.List<api.HealthCheckServicesListWarningData> buildUnnamed184() => [
      buildHealthCheckServicesListWarningData(),
      buildHealthCheckServicesListWarningData(),
    ];

void checkUnnamed184(core.List<api.HealthCheckServicesListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheckServicesListWarningData(o[0]);
  checkHealthCheckServicesListWarningData(o[1]);
}

core.int buildCounterHealthCheckServicesListWarning = 0;
api.HealthCheckServicesListWarning buildHealthCheckServicesListWarning() {
  final o = api.HealthCheckServicesListWarning();
  buildCounterHealthCheckServicesListWarning++;
  if (buildCounterHealthCheckServicesListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed184();
    o.message = 'foo';
  }
  buildCounterHealthCheckServicesListWarning--;
  return o;
}

void checkHealthCheckServicesListWarning(api.HealthCheckServicesListWarning o) {
  buildCounterHealthCheckServicesListWarning++;
  if (buildCounterHealthCheckServicesListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed184(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthCheckServicesListWarning--;
}

core.int buildCounterHealthCheckServicesList = 0;
api.HealthCheckServicesList buildHealthCheckServicesList() {
  final o = api.HealthCheckServicesList();
  buildCounterHealthCheckServicesList++;
  if (buildCounterHealthCheckServicesList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed183();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildHealthCheckServicesListWarning();
  }
  buildCounterHealthCheckServicesList--;
  return o;
}

void checkHealthCheckServicesList(api.HealthCheckServicesList o) {
  buildCounterHealthCheckServicesList++;
  if (buildCounterHealthCheckServicesList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed183(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkHealthCheckServicesListWarning(o.warning!);
  }
  buildCounterHealthCheckServicesList--;
}

core.Map<core.String, api.HealthChecksScopedList> buildUnnamed185() => {
      'x': buildHealthChecksScopedList(),
      'y': buildHealthChecksScopedList(),
    };

void checkUnnamed185(core.Map<core.String, api.HealthChecksScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthChecksScopedList(o['x']!);
  checkHealthChecksScopedList(o['y']!);
}

core.List<core.String> buildUnnamed186() => [
      'foo',
      'foo',
    ];

void checkUnnamed186(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterHealthChecksAggregatedListWarningData = 0;
api.HealthChecksAggregatedListWarningData
    buildHealthChecksAggregatedListWarningData() {
  final o = api.HealthChecksAggregatedListWarningData();
  buildCounterHealthChecksAggregatedListWarningData++;
  if (buildCounterHealthChecksAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterHealthChecksAggregatedListWarningData--;
  return o;
}

void checkHealthChecksAggregatedListWarningData(
    api.HealthChecksAggregatedListWarningData o) {
  buildCounterHealthChecksAggregatedListWarningData++;
  if (buildCounterHealthChecksAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthChecksAggregatedListWarningData--;
}

core.List<api.HealthChecksAggregatedListWarningData> buildUnnamed187() => [
      buildHealthChecksAggregatedListWarningData(),
      buildHealthChecksAggregatedListWarningData(),
    ];

void checkUnnamed187(core.List<api.HealthChecksAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthChecksAggregatedListWarningData(o[0]);
  checkHealthChecksAggregatedListWarningData(o[1]);
}

core.int buildCounterHealthChecksAggregatedListWarning = 0;
api.HealthChecksAggregatedListWarning buildHealthChecksAggregatedListWarning() {
  final o = api.HealthChecksAggregatedListWarning();
  buildCounterHealthChecksAggregatedListWarning++;
  if (buildCounterHealthChecksAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed187();
    o.message = 'foo';
  }
  buildCounterHealthChecksAggregatedListWarning--;
  return o;
}

void checkHealthChecksAggregatedListWarning(
    api.HealthChecksAggregatedListWarning o) {
  buildCounterHealthChecksAggregatedListWarning++;
  if (buildCounterHealthChecksAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed187(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthChecksAggregatedListWarning--;
}

core.int buildCounterHealthChecksAggregatedList = 0;
api.HealthChecksAggregatedList buildHealthChecksAggregatedList() {
  final o = api.HealthChecksAggregatedList();
  buildCounterHealthChecksAggregatedList++;
  if (buildCounterHealthChecksAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed185();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed186();
    o.warning = buildHealthChecksAggregatedListWarning();
  }
  buildCounterHealthChecksAggregatedList--;
  return o;
}

void checkHealthChecksAggregatedList(api.HealthChecksAggregatedList o) {
  buildCounterHealthChecksAggregatedList++;
  if (buildCounterHealthChecksAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed185(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed186(o.unreachables!);
    checkHealthChecksAggregatedListWarning(o.warning!);
  }
  buildCounterHealthChecksAggregatedList--;
}

core.List<api.HealthCheck> buildUnnamed188() => [
      buildHealthCheck(),
      buildHealthCheck(),
    ];

void checkUnnamed188(core.List<api.HealthCheck> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthCheck(o[0]);
  checkHealthCheck(o[1]);
}

core.int buildCounterHealthChecksScopedListWarningData = 0;
api.HealthChecksScopedListWarningData buildHealthChecksScopedListWarningData() {
  final o = api.HealthChecksScopedListWarningData();
  buildCounterHealthChecksScopedListWarningData++;
  if (buildCounterHealthChecksScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterHealthChecksScopedListWarningData--;
  return o;
}

void checkHealthChecksScopedListWarningData(
    api.HealthChecksScopedListWarningData o) {
  buildCounterHealthChecksScopedListWarningData++;
  if (buildCounterHealthChecksScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthChecksScopedListWarningData--;
}

core.List<api.HealthChecksScopedListWarningData> buildUnnamed189() => [
      buildHealthChecksScopedListWarningData(),
      buildHealthChecksScopedListWarningData(),
    ];

void checkUnnamed189(core.List<api.HealthChecksScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthChecksScopedListWarningData(o[0]);
  checkHealthChecksScopedListWarningData(o[1]);
}

core.int buildCounterHealthChecksScopedListWarning = 0;
api.HealthChecksScopedListWarning buildHealthChecksScopedListWarning() {
  final o = api.HealthChecksScopedListWarning();
  buildCounterHealthChecksScopedListWarning++;
  if (buildCounterHealthChecksScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed189();
    o.message = 'foo';
  }
  buildCounterHealthChecksScopedListWarning--;
  return o;
}

void checkHealthChecksScopedListWarning(api.HealthChecksScopedListWarning o) {
  buildCounterHealthChecksScopedListWarning++;
  if (buildCounterHealthChecksScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed189(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthChecksScopedListWarning--;
}

core.int buildCounterHealthChecksScopedList = 0;
api.HealthChecksScopedList buildHealthChecksScopedList() {
  final o = api.HealthChecksScopedList();
  buildCounterHealthChecksScopedList++;
  if (buildCounterHealthChecksScopedList < 3) {
    o.healthChecks = buildUnnamed188();
    o.warning = buildHealthChecksScopedListWarning();
  }
  buildCounterHealthChecksScopedList--;
  return o;
}

void checkHealthChecksScopedList(api.HealthChecksScopedList o) {
  buildCounterHealthChecksScopedList++;
  if (buildCounterHealthChecksScopedList < 3) {
    checkUnnamed188(o.healthChecks!);
    checkHealthChecksScopedListWarning(o.warning!);
  }
  buildCounterHealthChecksScopedList--;
}

core.Map<core.String, core.String> buildUnnamed190() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed190(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterHealthStatus = 0;
api.HealthStatus buildHealthStatus() {
  final o = api.HealthStatus();
  buildCounterHealthStatus++;
  if (buildCounterHealthStatus < 3) {
    o.annotations = buildUnnamed190();
    o.forwardingRule = 'foo';
    o.forwardingRuleIp = 'foo';
    o.healthState = 'foo';
    o.instance = 'foo';
    o.ipAddress = 'foo';
    o.port = 42;
    o.weight = 'foo';
    o.weightError = 'foo';
  }
  buildCounterHealthStatus--;
  return o;
}

void checkHealthStatus(api.HealthStatus o) {
  buildCounterHealthStatus++;
  if (buildCounterHealthStatus < 3) {
    checkUnnamed190(o.annotations!);
    unittest.expect(
      o.forwardingRule!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.forwardingRuleIp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.healthState!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.instance!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.weight!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.weightError!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthStatus--;
}

core.int buildCounterHealthStatusForNetworkEndpoint = 0;
api.HealthStatusForNetworkEndpoint buildHealthStatusForNetworkEndpoint() {
  final o = api.HealthStatusForNetworkEndpoint();
  buildCounterHealthStatusForNetworkEndpoint++;
  if (buildCounterHealthStatusForNetworkEndpoint < 3) {
    o.backendService = buildBackendServiceReference();
    o.forwardingRule = buildForwardingRuleReference();
    o.healthCheck = buildHealthCheckReference();
    o.healthCheckService = buildHealthCheckServiceReference();
    o.healthState = 'foo';
  }
  buildCounterHealthStatusForNetworkEndpoint--;
  return o;
}

void checkHealthStatusForNetworkEndpoint(api.HealthStatusForNetworkEndpoint o) {
  buildCounterHealthStatusForNetworkEndpoint++;
  if (buildCounterHealthStatusForNetworkEndpoint < 3) {
    checkBackendServiceReference(o.backendService!);
    checkForwardingRuleReference(o.forwardingRule!);
    checkHealthCheckReference(o.healthCheck!);
    checkHealthCheckServiceReference(o.healthCheckService!);
    unittest.expect(
      o.healthState!,
      unittest.equals('foo'),
    );
  }
  buildCounterHealthStatusForNetworkEndpoint--;
}

core.List<api.HelpLink> buildUnnamed191() => [
      buildHelpLink(),
      buildHelpLink(),
    ];

void checkUnnamed191(core.List<api.HelpLink> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHelpLink(o[0]);
  checkHelpLink(o[1]);
}

core.int buildCounterHelp = 0;
api.Help buildHelp() {
  final o = api.Help();
  buildCounterHelp++;
  if (buildCounterHelp < 3) {
    o.links = buildUnnamed191();
  }
  buildCounterHelp--;
  return o;
}

void checkHelp(api.Help o) {
  buildCounterHelp++;
  if (buildCounterHelp < 3) {
    checkUnnamed191(o.links!);
  }
  buildCounterHelp--;
}

core.int buildCounterHelpLink = 0;
api.HelpLink buildHelpLink() {
  final o = api.HelpLink();
  buildCounterHelpLink++;
  if (buildCounterHelpLink < 3) {
    o.description = 'foo';
    o.url = 'foo';
  }
  buildCounterHelpLink--;
  return o;
}

void checkHelpLink(api.HelpLink o) {
  buildCounterHelpLink++;
  if (buildCounterHelpLink < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.url!,
      unittest.equals('foo'),
    );
  }
  buildCounterHelpLink--;
}

core.List<core.String> buildUnnamed192() => [
      'foo',
      'foo',
    ];

void checkUnnamed192(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterHostRule = 0;
api.HostRule buildHostRule() {
  final o = api.HostRule();
  buildCounterHostRule++;
  if (buildCounterHostRule < 3) {
    o.description = 'foo';
    o.hosts = buildUnnamed192();
    o.pathMatcher = 'foo';
  }
  buildCounterHostRule--;
  return o;
}

void checkHostRule(api.HostRule o) {
  buildCounterHostRule++;
  if (buildCounterHostRule < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed192(o.hosts!);
    unittest.expect(
      o.pathMatcher!,
      unittest.equals('foo'),
    );
  }
  buildCounterHostRule--;
}

core.int buildCounterHttpFaultAbort = 0;
api.HttpFaultAbort buildHttpFaultAbort() {
  final o = api.HttpFaultAbort();
  buildCounterHttpFaultAbort++;
  if (buildCounterHttpFaultAbort < 3) {
    o.httpStatus = 42;
    o.percentage = 42.0;
  }
  buildCounterHttpFaultAbort--;
  return o;
}

void checkHttpFaultAbort(api.HttpFaultAbort o) {
  buildCounterHttpFaultAbort++;
  if (buildCounterHttpFaultAbort < 3) {
    unittest.expect(
      o.httpStatus!,
      unittest.equals(42),
    );
    unittest.expect(
      o.percentage!,
      unittest.equals(42.0),
    );
  }
  buildCounterHttpFaultAbort--;
}

core.int buildCounterHttpFaultDelay = 0;
api.HttpFaultDelay buildHttpFaultDelay() {
  final o = api.HttpFaultDelay();
  buildCounterHttpFaultDelay++;
  if (buildCounterHttpFaultDelay < 3) {
    o.fixedDelay = buildDuration();
    o.percentage = 42.0;
  }
  buildCounterHttpFaultDelay--;
  return o;
}

void checkHttpFaultDelay(api.HttpFaultDelay o) {
  buildCounterHttpFaultDelay++;
  if (buildCounterHttpFaultDelay < 3) {
    checkDuration(o.fixedDelay!);
    unittest.expect(
      o.percentage!,
      unittest.equals(42.0),
    );
  }
  buildCounterHttpFaultDelay--;
}

core.int buildCounterHttpFaultInjection = 0;
api.HttpFaultInjection buildHttpFaultInjection() {
  final o = api.HttpFaultInjection();
  buildCounterHttpFaultInjection++;
  if (buildCounterHttpFaultInjection < 3) {
    o.abort = buildHttpFaultAbort();
    o.delay = buildHttpFaultDelay();
  }
  buildCounterHttpFaultInjection--;
  return o;
}

void checkHttpFaultInjection(api.HttpFaultInjection o) {
  buildCounterHttpFaultInjection++;
  if (buildCounterHttpFaultInjection < 3) {
    checkHttpFaultAbort(o.abort!);
    checkHttpFaultDelay(o.delay!);
  }
  buildCounterHttpFaultInjection--;
}

core.List<api.HttpHeaderOption> buildUnnamed193() => [
      buildHttpHeaderOption(),
      buildHttpHeaderOption(),
    ];

void checkUnnamed193(core.List<api.HttpHeaderOption> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpHeaderOption(o[0]);
  checkHttpHeaderOption(o[1]);
}

core.List<core.String> buildUnnamed194() => [
      'foo',
      'foo',
    ];

void checkUnnamed194(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.HttpHeaderOption> buildUnnamed195() => [
      buildHttpHeaderOption(),
      buildHttpHeaderOption(),
    ];

void checkUnnamed195(core.List<api.HttpHeaderOption> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpHeaderOption(o[0]);
  checkHttpHeaderOption(o[1]);
}

core.List<core.String> buildUnnamed196() => [
      'foo',
      'foo',
    ];

void checkUnnamed196(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterHttpHeaderAction = 0;
api.HttpHeaderAction buildHttpHeaderAction() {
  final o = api.HttpHeaderAction();
  buildCounterHttpHeaderAction++;
  if (buildCounterHttpHeaderAction < 3) {
    o.requestHeadersToAdd = buildUnnamed193();
    o.requestHeadersToRemove = buildUnnamed194();
    o.responseHeadersToAdd = buildUnnamed195();
    o.responseHeadersToRemove = buildUnnamed196();
  }
  buildCounterHttpHeaderAction--;
  return o;
}

void checkHttpHeaderAction(api.HttpHeaderAction o) {
  buildCounterHttpHeaderAction++;
  if (buildCounterHttpHeaderAction < 3) {
    checkUnnamed193(o.requestHeadersToAdd!);
    checkUnnamed194(o.requestHeadersToRemove!);
    checkUnnamed195(o.responseHeadersToAdd!);
    checkUnnamed196(o.responseHeadersToRemove!);
  }
  buildCounterHttpHeaderAction--;
}

core.int buildCounterHttpHeaderMatch = 0;
api.HttpHeaderMatch buildHttpHeaderMatch() {
  final o = api.HttpHeaderMatch();
  buildCounterHttpHeaderMatch++;
  if (buildCounterHttpHeaderMatch < 3) {
    o.exactMatch = 'foo';
    o.headerName = 'foo';
    o.invertMatch = true;
    o.prefixMatch = 'foo';
    o.presentMatch = true;
    o.rangeMatch = buildInt64RangeMatch();
    o.regexMatch = 'foo';
    o.suffixMatch = 'foo';
  }
  buildCounterHttpHeaderMatch--;
  return o;
}

void checkHttpHeaderMatch(api.HttpHeaderMatch o) {
  buildCounterHttpHeaderMatch++;
  if (buildCounterHttpHeaderMatch < 3) {
    unittest.expect(
      o.exactMatch!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.headerName!,
      unittest.equals('foo'),
    );
    unittest.expect(o.invertMatch!, unittest.isTrue);
    unittest.expect(
      o.prefixMatch!,
      unittest.equals('foo'),
    );
    unittest.expect(o.presentMatch!, unittest.isTrue);
    checkInt64RangeMatch(o.rangeMatch!);
    unittest.expect(
      o.regexMatch!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.suffixMatch!,
      unittest.equals('foo'),
    );
  }
  buildCounterHttpHeaderMatch--;
}

core.int buildCounterHttpHeaderOption = 0;
api.HttpHeaderOption buildHttpHeaderOption() {
  final o = api.HttpHeaderOption();
  buildCounterHttpHeaderOption++;
  if (buildCounterHttpHeaderOption < 3) {
    o.headerName = 'foo';
    o.headerValue = 'foo';
    o.replace = true;
  }
  buildCounterHttpHeaderOption--;
  return o;
}

void checkHttpHeaderOption(api.HttpHeaderOption o) {
  buildCounterHttpHeaderOption++;
  if (buildCounterHttpHeaderOption < 3) {
    unittest.expect(
      o.headerName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.headerValue!,
      unittest.equals('foo'),
    );
    unittest.expect(o.replace!, unittest.isTrue);
  }
  buildCounterHttpHeaderOption--;
}

core.int buildCounterHttpHealthCheck = 0;
api.HttpHealthCheck buildHttpHealthCheck() {
  final o = api.HttpHealthCheck();
  buildCounterHttpHealthCheck++;
  if (buildCounterHttpHealthCheck < 3) {
    o.checkIntervalSec = 42;
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.healthyThreshold = 42;
    o.host = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.port = 42;
    o.requestPath = 'foo';
    o.selfLink = 'foo';
    o.timeoutSec = 42;
    o.unhealthyThreshold = 42;
  }
  buildCounterHttpHealthCheck--;
  return o;
}

void checkHttpHealthCheck(api.HttpHealthCheck o) {
  buildCounterHttpHealthCheck++;
  if (buildCounterHttpHealthCheck < 3) {
    unittest.expect(
      o.checkIntervalSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.healthyThreshold!,
      unittest.equals(42),
    );
    unittest.expect(
      o.host!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.requestPath!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.timeoutSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.unhealthyThreshold!,
      unittest.equals(42),
    );
  }
  buildCounterHttpHealthCheck--;
}

core.List<api.HttpHealthCheck> buildUnnamed197() => [
      buildHttpHealthCheck(),
      buildHttpHealthCheck(),
    ];

void checkUnnamed197(core.List<api.HttpHealthCheck> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpHealthCheck(o[0]);
  checkHttpHealthCheck(o[1]);
}

core.int buildCounterHttpHealthCheckListWarningData = 0;
api.HttpHealthCheckListWarningData buildHttpHealthCheckListWarningData() {
  final o = api.HttpHealthCheckListWarningData();
  buildCounterHttpHealthCheckListWarningData++;
  if (buildCounterHttpHealthCheckListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterHttpHealthCheckListWarningData--;
  return o;
}

void checkHttpHealthCheckListWarningData(api.HttpHealthCheckListWarningData o) {
  buildCounterHttpHealthCheckListWarningData++;
  if (buildCounterHttpHealthCheckListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterHttpHealthCheckListWarningData--;
}

core.List<api.HttpHealthCheckListWarningData> buildUnnamed198() => [
      buildHttpHealthCheckListWarningData(),
      buildHttpHealthCheckListWarningData(),
    ];

void checkUnnamed198(core.List<api.HttpHealthCheckListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpHealthCheckListWarningData(o[0]);
  checkHttpHealthCheckListWarningData(o[1]);
}

core.int buildCounterHttpHealthCheckListWarning = 0;
api.HttpHealthCheckListWarning buildHttpHealthCheckListWarning() {
  final o = api.HttpHealthCheckListWarning();
  buildCounterHttpHealthCheckListWarning++;
  if (buildCounterHttpHealthCheckListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed198();
    o.message = 'foo';
  }
  buildCounterHttpHealthCheckListWarning--;
  return o;
}

void checkHttpHealthCheckListWarning(api.HttpHealthCheckListWarning o) {
  buildCounterHttpHealthCheckListWarning++;
  if (buildCounterHttpHealthCheckListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed198(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterHttpHealthCheckListWarning--;
}

core.int buildCounterHttpHealthCheckList = 0;
api.HttpHealthCheckList buildHttpHealthCheckList() {
  final o = api.HttpHealthCheckList();
  buildCounterHttpHealthCheckList++;
  if (buildCounterHttpHealthCheckList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed197();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildHttpHealthCheckListWarning();
  }
  buildCounterHttpHealthCheckList--;
  return o;
}

void checkHttpHealthCheckList(api.HttpHealthCheckList o) {
  buildCounterHttpHealthCheckList++;
  if (buildCounterHttpHealthCheckList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed197(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkHttpHealthCheckListWarning(o.warning!);
  }
  buildCounterHttpHealthCheckList--;
}

core.int buildCounterHttpQueryParameterMatch = 0;
api.HttpQueryParameterMatch buildHttpQueryParameterMatch() {
  final o = api.HttpQueryParameterMatch();
  buildCounterHttpQueryParameterMatch++;
  if (buildCounterHttpQueryParameterMatch < 3) {
    o.exactMatch = 'foo';
    o.name = 'foo';
    o.presentMatch = true;
    o.regexMatch = 'foo';
  }
  buildCounterHttpQueryParameterMatch--;
  return o;
}

void checkHttpQueryParameterMatch(api.HttpQueryParameterMatch o) {
  buildCounterHttpQueryParameterMatch++;
  if (buildCounterHttpQueryParameterMatch < 3) {
    unittest.expect(
      o.exactMatch!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(o.presentMatch!, unittest.isTrue);
    unittest.expect(
      o.regexMatch!,
      unittest.equals('foo'),
    );
  }
  buildCounterHttpQueryParameterMatch--;
}

core.int buildCounterHttpRedirectAction = 0;
api.HttpRedirectAction buildHttpRedirectAction() {
  final o = api.HttpRedirectAction();
  buildCounterHttpRedirectAction++;
  if (buildCounterHttpRedirectAction < 3) {
    o.hostRedirect = 'foo';
    o.httpsRedirect = true;
    o.pathRedirect = 'foo';
    o.prefixRedirect = 'foo';
    o.redirectResponseCode = 'foo';
    o.stripQuery = true;
  }
  buildCounterHttpRedirectAction--;
  return o;
}

void checkHttpRedirectAction(api.HttpRedirectAction o) {
  buildCounterHttpRedirectAction++;
  if (buildCounterHttpRedirectAction < 3) {
    unittest.expect(
      o.hostRedirect!,
      unittest.equals('foo'),
    );
    unittest.expect(o.httpsRedirect!, unittest.isTrue);
    unittest.expect(
      o.pathRedirect!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.prefixRedirect!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.redirectResponseCode!,
      unittest.equals('foo'),
    );
    unittest.expect(o.stripQuery!, unittest.isTrue);
  }
  buildCounterHttpRedirectAction--;
}

core.List<core.String> buildUnnamed199() => [
      'foo',
      'foo',
    ];

void checkUnnamed199(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterHttpRetryPolicy = 0;
api.HttpRetryPolicy buildHttpRetryPolicy() {
  final o = api.HttpRetryPolicy();
  buildCounterHttpRetryPolicy++;
  if (buildCounterHttpRetryPolicy < 3) {
    o.numRetries = 42;
    o.perTryTimeout = buildDuration();
    o.retryConditions = buildUnnamed199();
  }
  buildCounterHttpRetryPolicy--;
  return o;
}

void checkHttpRetryPolicy(api.HttpRetryPolicy o) {
  buildCounterHttpRetryPolicy++;
  if (buildCounterHttpRetryPolicy < 3) {
    unittest.expect(
      o.numRetries!,
      unittest.equals(42),
    );
    checkDuration(o.perTryTimeout!);
    checkUnnamed199(o.retryConditions!);
  }
  buildCounterHttpRetryPolicy--;
}

core.List<api.WeightedBackendService> buildUnnamed200() => [
      buildWeightedBackendService(),
      buildWeightedBackendService(),
    ];

void checkUnnamed200(core.List<api.WeightedBackendService> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkWeightedBackendService(o[0]);
  checkWeightedBackendService(o[1]);
}

core.int buildCounterHttpRouteAction = 0;
api.HttpRouteAction buildHttpRouteAction() {
  final o = api.HttpRouteAction();
  buildCounterHttpRouteAction++;
  if (buildCounterHttpRouteAction < 3) {
    o.corsPolicy = buildCorsPolicy();
    o.faultInjectionPolicy = buildHttpFaultInjection();
    o.maxStreamDuration = buildDuration();
    o.requestMirrorPolicy = buildRequestMirrorPolicy();
    o.retryPolicy = buildHttpRetryPolicy();
    o.timeout = buildDuration();
    o.urlRewrite = buildUrlRewrite();
    o.weightedBackendServices = buildUnnamed200();
  }
  buildCounterHttpRouteAction--;
  return o;
}

void checkHttpRouteAction(api.HttpRouteAction o) {
  buildCounterHttpRouteAction++;
  if (buildCounterHttpRouteAction < 3) {
    checkCorsPolicy(o.corsPolicy!);
    checkHttpFaultInjection(o.faultInjectionPolicy!);
    checkDuration(o.maxStreamDuration!);
    checkRequestMirrorPolicy(o.requestMirrorPolicy!);
    checkHttpRetryPolicy(o.retryPolicy!);
    checkDuration(o.timeout!);
    checkUrlRewrite(o.urlRewrite!);
    checkUnnamed200(o.weightedBackendServices!);
  }
  buildCounterHttpRouteAction--;
}

core.List<api.HttpRouteRuleMatch> buildUnnamed201() => [
      buildHttpRouteRuleMatch(),
      buildHttpRouteRuleMatch(),
    ];

void checkUnnamed201(core.List<api.HttpRouteRuleMatch> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpRouteRuleMatch(o[0]);
  checkHttpRouteRuleMatch(o[1]);
}

core.int buildCounterHttpRouteRule = 0;
api.HttpRouteRule buildHttpRouteRule() {
  final o = api.HttpRouteRule();
  buildCounterHttpRouteRule++;
  if (buildCounterHttpRouteRule < 3) {
    o.description = 'foo';
    o.headerAction = buildHttpHeaderAction();
    o.matchRules = buildUnnamed201();
    o.priority = 42;
    o.routeAction = buildHttpRouteAction();
    o.service = 'foo';
    o.urlRedirect = buildHttpRedirectAction();
  }
  buildCounterHttpRouteRule--;
  return o;
}

void checkHttpRouteRule(api.HttpRouteRule o) {
  buildCounterHttpRouteRule++;
  if (buildCounterHttpRouteRule < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkHttpHeaderAction(o.headerAction!);
    checkUnnamed201(o.matchRules!);
    unittest.expect(
      o.priority!,
      unittest.equals(42),
    );
    checkHttpRouteAction(o.routeAction!);
    unittest.expect(
      o.service!,
      unittest.equals('foo'),
    );
    checkHttpRedirectAction(o.urlRedirect!);
  }
  buildCounterHttpRouteRule--;
}

core.List<api.HttpHeaderMatch> buildUnnamed202() => [
      buildHttpHeaderMatch(),
      buildHttpHeaderMatch(),
    ];

void checkUnnamed202(core.List<api.HttpHeaderMatch> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpHeaderMatch(o[0]);
  checkHttpHeaderMatch(o[1]);
}

core.List<api.MetadataFilter> buildUnnamed203() => [
      buildMetadataFilter(),
      buildMetadataFilter(),
    ];

void checkUnnamed203(core.List<api.MetadataFilter> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMetadataFilter(o[0]);
  checkMetadataFilter(o[1]);
}

core.List<api.HttpQueryParameterMatch> buildUnnamed204() => [
      buildHttpQueryParameterMatch(),
      buildHttpQueryParameterMatch(),
    ];

void checkUnnamed204(core.List<api.HttpQueryParameterMatch> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpQueryParameterMatch(o[0]);
  checkHttpQueryParameterMatch(o[1]);
}

core.int buildCounterHttpRouteRuleMatch = 0;
api.HttpRouteRuleMatch buildHttpRouteRuleMatch() {
  final o = api.HttpRouteRuleMatch();
  buildCounterHttpRouteRuleMatch++;
  if (buildCounterHttpRouteRuleMatch < 3) {
    o.fullPathMatch = 'foo';
    o.headerMatches = buildUnnamed202();
    o.ignoreCase = true;
    o.metadataFilters = buildUnnamed203();
    o.pathTemplateMatch = 'foo';
    o.prefixMatch = 'foo';
    o.queryParameterMatches = buildUnnamed204();
    o.regexMatch = 'foo';
  }
  buildCounterHttpRouteRuleMatch--;
  return o;
}

void checkHttpRouteRuleMatch(api.HttpRouteRuleMatch o) {
  buildCounterHttpRouteRuleMatch++;
  if (buildCounterHttpRouteRuleMatch < 3) {
    unittest.expect(
      o.fullPathMatch!,
      unittest.equals('foo'),
    );
    checkUnnamed202(o.headerMatches!);
    unittest.expect(o.ignoreCase!, unittest.isTrue);
    checkUnnamed203(o.metadataFilters!);
    unittest.expect(
      o.pathTemplateMatch!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.prefixMatch!,
      unittest.equals('foo'),
    );
    checkUnnamed204(o.queryParameterMatches!);
    unittest.expect(
      o.regexMatch!,
      unittest.equals('foo'),
    );
  }
  buildCounterHttpRouteRuleMatch--;
}

core.int buildCounterHttpsHealthCheck = 0;
api.HttpsHealthCheck buildHttpsHealthCheck() {
  final o = api.HttpsHealthCheck();
  buildCounterHttpsHealthCheck++;
  if (buildCounterHttpsHealthCheck < 3) {
    o.checkIntervalSec = 42;
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.healthyThreshold = 42;
    o.host = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.port = 42;
    o.requestPath = 'foo';
    o.selfLink = 'foo';
    o.timeoutSec = 42;
    o.unhealthyThreshold = 42;
  }
  buildCounterHttpsHealthCheck--;
  return o;
}

void checkHttpsHealthCheck(api.HttpsHealthCheck o) {
  buildCounterHttpsHealthCheck++;
  if (buildCounterHttpsHealthCheck < 3) {
    unittest.expect(
      o.checkIntervalSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.healthyThreshold!,
      unittest.equals(42),
    );
    unittest.expect(
      o.host!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.requestPath!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.timeoutSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.unhealthyThreshold!,
      unittest.equals(42),
    );
  }
  buildCounterHttpsHealthCheck--;
}

core.List<api.HttpsHealthCheck> buildUnnamed205() => [
      buildHttpsHealthCheck(),
      buildHttpsHealthCheck(),
    ];

void checkUnnamed205(core.List<api.HttpsHealthCheck> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpsHealthCheck(o[0]);
  checkHttpsHealthCheck(o[1]);
}

core.int buildCounterHttpsHealthCheckListWarningData = 0;
api.HttpsHealthCheckListWarningData buildHttpsHealthCheckListWarningData() {
  final o = api.HttpsHealthCheckListWarningData();
  buildCounterHttpsHealthCheckListWarningData++;
  if (buildCounterHttpsHealthCheckListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterHttpsHealthCheckListWarningData--;
  return o;
}

void checkHttpsHealthCheckListWarningData(
    api.HttpsHealthCheckListWarningData o) {
  buildCounterHttpsHealthCheckListWarningData++;
  if (buildCounterHttpsHealthCheckListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterHttpsHealthCheckListWarningData--;
}

core.List<api.HttpsHealthCheckListWarningData> buildUnnamed206() => [
      buildHttpsHealthCheckListWarningData(),
      buildHttpsHealthCheckListWarningData(),
    ];

void checkUnnamed206(core.List<api.HttpsHealthCheckListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpsHealthCheckListWarningData(o[0]);
  checkHttpsHealthCheckListWarningData(o[1]);
}

core.int buildCounterHttpsHealthCheckListWarning = 0;
api.HttpsHealthCheckListWarning buildHttpsHealthCheckListWarning() {
  final o = api.HttpsHealthCheckListWarning();
  buildCounterHttpsHealthCheckListWarning++;
  if (buildCounterHttpsHealthCheckListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed206();
    o.message = 'foo';
  }
  buildCounterHttpsHealthCheckListWarning--;
  return o;
}

void checkHttpsHealthCheckListWarning(api.HttpsHealthCheckListWarning o) {
  buildCounterHttpsHealthCheckListWarning++;
  if (buildCounterHttpsHealthCheckListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed206(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterHttpsHealthCheckListWarning--;
}

core.int buildCounterHttpsHealthCheckList = 0;
api.HttpsHealthCheckList buildHttpsHealthCheckList() {
  final o = api.HttpsHealthCheckList();
  buildCounterHttpsHealthCheckList++;
  if (buildCounterHttpsHealthCheckList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed205();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildHttpsHealthCheckListWarning();
  }
  buildCounterHttpsHealthCheckList--;
  return o;
}

void checkHttpsHealthCheckList(api.HttpsHealthCheckList o) {
  buildCounterHttpsHealthCheckList++;
  if (buildCounterHttpsHealthCheckList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed205(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkHttpsHealthCheckListWarning(o.warning!);
  }
  buildCounterHttpsHealthCheckList--;
}

core.List<api.GuestOsFeature> buildUnnamed207() => [
      buildGuestOsFeature(),
      buildGuestOsFeature(),
    ];

void checkUnnamed207(core.List<api.GuestOsFeature> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestOsFeature(o[0]);
  checkGuestOsFeature(o[1]);
}

core.Map<core.String, core.String> buildUnnamed208() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed208(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed209() => [
      'foo',
      'foo',
    ];

void checkUnnamed209(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed210() => [
      'foo',
      'foo',
    ];

void checkUnnamed210(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterImageRawDisk = 0;
api.ImageRawDisk buildImageRawDisk() {
  final o = api.ImageRawDisk();
  buildCounterImageRawDisk++;
  if (buildCounterImageRawDisk < 3) {
    o.containerType = 'foo';
    o.sha1Checksum = 'foo';
    o.source = 'foo';
  }
  buildCounterImageRawDisk--;
  return o;
}

void checkImageRawDisk(api.ImageRawDisk o) {
  buildCounterImageRawDisk++;
  if (buildCounterImageRawDisk < 3) {
    unittest.expect(
      o.containerType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sha1Checksum!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.source!,
      unittest.equals('foo'),
    );
  }
  buildCounterImageRawDisk--;
}

core.List<core.String> buildUnnamed211() => [
      'foo',
      'foo',
    ];

void checkUnnamed211(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterImage = 0;
api.Image buildImage() {
  final o = api.Image();
  buildCounterImage++;
  if (buildCounterImage < 3) {
    o.architecture = 'foo';
    o.archiveSizeBytes = 'foo';
    o.creationTimestamp = 'foo';
    o.deprecated = buildDeprecationStatus();
    o.description = 'foo';
    o.diskSizeGb = 'foo';
    o.family = 'foo';
    o.guestOsFeatures = buildUnnamed207();
    o.id = 'foo';
    o.imageEncryptionKey = buildCustomerEncryptionKey();
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed208();
    o.licenseCodes = buildUnnamed209();
    o.licenses = buildUnnamed210();
    o.name = 'foo';
    o.rawDisk = buildImageRawDisk();
    o.satisfiesPzs = true;
    o.selfLink = 'foo';
    o.shieldedInstanceInitialState = buildInitialStateConfig();
    o.sourceDisk = 'foo';
    o.sourceDiskEncryptionKey = buildCustomerEncryptionKey();
    o.sourceDiskId = 'foo';
    o.sourceImage = 'foo';
    o.sourceImageEncryptionKey = buildCustomerEncryptionKey();
    o.sourceImageId = 'foo';
    o.sourceSnapshot = 'foo';
    o.sourceSnapshotEncryptionKey = buildCustomerEncryptionKey();
    o.sourceSnapshotId = 'foo';
    o.sourceType = 'foo';
    o.status = 'foo';
    o.storageLocations = buildUnnamed211();
  }
  buildCounterImage--;
  return o;
}

void checkImage(api.Image o) {
  buildCounterImage++;
  if (buildCounterImage < 3) {
    unittest.expect(
      o.architecture!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.archiveSizeBytes!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkDeprecationStatus(o.deprecated!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.diskSizeGb!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.family!,
      unittest.equals('foo'),
    );
    checkUnnamed207(o.guestOsFeatures!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.imageEncryptionKey!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed208(o.labels!);
    checkUnnamed209(o.licenseCodes!);
    checkUnnamed210(o.licenses!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkImageRawDisk(o.rawDisk!);
    unittest.expect(o.satisfiesPzs!, unittest.isTrue);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInitialStateConfig(o.shieldedInstanceInitialState!);
    unittest.expect(
      o.sourceDisk!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.sourceDiskEncryptionKey!);
    unittest.expect(
      o.sourceDiskId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceImage!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.sourceImageEncryptionKey!);
    unittest.expect(
      o.sourceImageId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceSnapshot!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.sourceSnapshotEncryptionKey!);
    unittest.expect(
      o.sourceSnapshotId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    checkUnnamed211(o.storageLocations!);
  }
  buildCounterImage--;
}

core.int buildCounterImageFamilyView = 0;
api.ImageFamilyView buildImageFamilyView() {
  final o = api.ImageFamilyView();
  buildCounterImageFamilyView++;
  if (buildCounterImageFamilyView < 3) {
    o.image = buildImage();
  }
  buildCounterImageFamilyView--;
  return o;
}

void checkImageFamilyView(api.ImageFamilyView o) {
  buildCounterImageFamilyView++;
  if (buildCounterImageFamilyView < 3) {
    checkImage(o.image!);
  }
  buildCounterImageFamilyView--;
}

core.List<api.Image> buildUnnamed212() => [
      buildImage(),
      buildImage(),
    ];

void checkUnnamed212(core.List<api.Image> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkImage(o[0]);
  checkImage(o[1]);
}

core.int buildCounterImageListWarningData = 0;
api.ImageListWarningData buildImageListWarningData() {
  final o = api.ImageListWarningData();
  buildCounterImageListWarningData++;
  if (buildCounterImageListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterImageListWarningData--;
  return o;
}

void checkImageListWarningData(api.ImageListWarningData o) {
  buildCounterImageListWarningData++;
  if (buildCounterImageListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterImageListWarningData--;
}

core.List<api.ImageListWarningData> buildUnnamed213() => [
      buildImageListWarningData(),
      buildImageListWarningData(),
    ];

void checkUnnamed213(core.List<api.ImageListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkImageListWarningData(o[0]);
  checkImageListWarningData(o[1]);
}

core.int buildCounterImageListWarning = 0;
api.ImageListWarning buildImageListWarning() {
  final o = api.ImageListWarning();
  buildCounterImageListWarning++;
  if (buildCounterImageListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed213();
    o.message = 'foo';
  }
  buildCounterImageListWarning--;
  return o;
}

void checkImageListWarning(api.ImageListWarning o) {
  buildCounterImageListWarning++;
  if (buildCounterImageListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed213(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterImageListWarning--;
}

core.int buildCounterImageList = 0;
api.ImageList buildImageList() {
  final o = api.ImageList();
  buildCounterImageList++;
  if (buildCounterImageList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed212();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildImageListWarning();
  }
  buildCounterImageList--;
  return o;
}

void checkImageList(api.ImageList o) {
  buildCounterImageList++;
  if (buildCounterImageList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed212(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkImageListWarning(o.warning!);
  }
  buildCounterImageList--;
}

core.List<api.FileContentBuffer> buildUnnamed214() => [
      buildFileContentBuffer(),
      buildFileContentBuffer(),
    ];

void checkUnnamed214(core.List<api.FileContentBuffer> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFileContentBuffer(o[0]);
  checkFileContentBuffer(o[1]);
}

core.List<api.FileContentBuffer> buildUnnamed215() => [
      buildFileContentBuffer(),
      buildFileContentBuffer(),
    ];

void checkUnnamed215(core.List<api.FileContentBuffer> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFileContentBuffer(o[0]);
  checkFileContentBuffer(o[1]);
}

core.List<api.FileContentBuffer> buildUnnamed216() => [
      buildFileContentBuffer(),
      buildFileContentBuffer(),
    ];

void checkUnnamed216(core.List<api.FileContentBuffer> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFileContentBuffer(o[0]);
  checkFileContentBuffer(o[1]);
}

core.int buildCounterInitialStateConfig = 0;
api.InitialStateConfig buildInitialStateConfig() {
  final o = api.InitialStateConfig();
  buildCounterInitialStateConfig++;
  if (buildCounterInitialStateConfig < 3) {
    o.dbs = buildUnnamed214();
    o.dbxs = buildUnnamed215();
    o.keks = buildUnnamed216();
    o.pk = buildFileContentBuffer();
  }
  buildCounterInitialStateConfig--;
  return o;
}

void checkInitialStateConfig(api.InitialStateConfig o) {
  buildCounterInitialStateConfig++;
  if (buildCounterInitialStateConfig < 3) {
    checkUnnamed214(o.dbs!);
    checkUnnamed215(o.dbxs!);
    checkUnnamed216(o.keks!);
    checkFileContentBuffer(o.pk!);
  }
  buildCounterInitialStateConfig--;
}

core.List<api.AttachedDisk> buildUnnamed217() => [
      buildAttachedDisk(),
      buildAttachedDisk(),
    ];

void checkUnnamed217(core.List<api.AttachedDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAttachedDisk(o[0]);
  checkAttachedDisk(o[1]);
}

core.List<api.AcceleratorConfig> buildUnnamed218() => [
      buildAcceleratorConfig(),
      buildAcceleratorConfig(),
    ];

void checkUnnamed218(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

core.Map<core.String, core.String> buildUnnamed219() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed219(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<api.NetworkInterface> buildUnnamed220() => [
      buildNetworkInterface(),
      buildNetworkInterface(),
    ];

void checkUnnamed220(core.List<api.NetworkInterface> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkInterface(o[0]);
  checkNetworkInterface(o[1]);
}

core.List<core.String> buildUnnamed221() => [
      'foo',
      'foo',
    ];

void checkUnnamed221(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.ServiceAccount> buildUnnamed222() => [
      buildServiceAccount(),
      buildServiceAccount(),
    ];

void checkUnnamed222(core.List<api.ServiceAccount> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAccount(o[0]);
  checkServiceAccount(o[1]);
}

core.int buildCounterInstance = 0;
api.Instance buildInstance() {
  final o = api.Instance();
  buildCounterInstance++;
  if (buildCounterInstance < 3) {
    o.advancedMachineFeatures = buildAdvancedMachineFeatures();
    o.canIpForward = true;
    o.confidentialInstanceConfig = buildConfidentialInstanceConfig();
    o.cpuPlatform = 'foo';
    o.creationTimestamp = 'foo';
    o.deletionProtection = true;
    o.description = 'foo';
    o.disks = buildUnnamed217();
    o.displayDevice = buildDisplayDevice();
    o.fingerprint = 'foo';
    o.guestAccelerators = buildUnnamed218();
    o.hostname = 'foo';
    o.id = 'foo';
    o.instanceEncryptionKey = buildCustomerEncryptionKey();
    o.keyRevocationActionType = 'foo';
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed219();
    o.lastStartTimestamp = 'foo';
    o.lastStopTimestamp = 'foo';
    o.lastSuspendedTimestamp = 'foo';
    o.machineType = 'foo';
    o.metadata = buildMetadata();
    o.minCpuPlatform = 'foo';
    o.name = 'foo';
    o.networkInterfaces = buildUnnamed220();
    o.networkPerformanceConfig = buildNetworkPerformanceConfig();
    o.params = buildInstanceParams();
    o.privateIpv6GoogleAccess = 'foo';
    o.reservationAffinity = buildReservationAffinity();
    o.resourcePolicies = buildUnnamed221();
    o.resourceStatus = buildResourceStatus();
    o.satisfiesPzs = true;
    o.scheduling = buildScheduling();
    o.selfLink = 'foo';
    o.serviceAccounts = buildUnnamed222();
    o.shieldedInstanceConfig = buildShieldedInstanceConfig();
    o.shieldedInstanceIntegrityPolicy = buildShieldedInstanceIntegrityPolicy();
    o.sourceMachineImage = 'foo';
    o.sourceMachineImageEncryptionKey = buildCustomerEncryptionKey();
    o.startRestricted = true;
    o.status = 'foo';
    o.statusMessage = 'foo';
    o.tags = buildTags();
    o.zone = 'foo';
  }
  buildCounterInstance--;
  return o;
}

void checkInstance(api.Instance o) {
  buildCounterInstance++;
  if (buildCounterInstance < 3) {
    checkAdvancedMachineFeatures(o.advancedMachineFeatures!);
    unittest.expect(o.canIpForward!, unittest.isTrue);
    checkConfidentialInstanceConfig(o.confidentialInstanceConfig!);
    unittest.expect(
      o.cpuPlatform!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(o.deletionProtection!, unittest.isTrue);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed217(o.disks!);
    checkDisplayDevice(o.displayDevice!);
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed218(o.guestAccelerators!);
    unittest.expect(
      o.hostname!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.instanceEncryptionKey!);
    unittest.expect(
      o.keyRevocationActionType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed219(o.labels!);
    unittest.expect(
      o.lastStartTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.lastStopTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.lastSuspendedTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.machineType!,
      unittest.equals('foo'),
    );
    checkMetadata(o.metadata!);
    unittest.expect(
      o.minCpuPlatform!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed220(o.networkInterfaces!);
    checkNetworkPerformanceConfig(o.networkPerformanceConfig!);
    checkInstanceParams(o.params!);
    unittest.expect(
      o.privateIpv6GoogleAccess!,
      unittest.equals('foo'),
    );
    checkReservationAffinity(o.reservationAffinity!);
    checkUnnamed221(o.resourcePolicies!);
    checkResourceStatus(o.resourceStatus!);
    unittest.expect(o.satisfiesPzs!, unittest.isTrue);
    checkScheduling(o.scheduling!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed222(o.serviceAccounts!);
    checkShieldedInstanceConfig(o.shieldedInstanceConfig!);
    checkShieldedInstanceIntegrityPolicy(o.shieldedInstanceIntegrityPolicy!);
    unittest.expect(
      o.sourceMachineImage!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.sourceMachineImageEncryptionKey!);
    unittest.expect(o.startRestricted!, unittest.isTrue);
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.statusMessage!,
      unittest.equals('foo'),
    );
    checkTags(o.tags!);
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstance--;
}

core.Map<core.String, api.InstancesScopedList> buildUnnamed223() => {
      'x': buildInstancesScopedList(),
      'y': buildInstancesScopedList(),
    };

void checkUnnamed223(core.Map<core.String, api.InstancesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstancesScopedList(o['x']!);
  checkInstancesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed224() => [
      'foo',
      'foo',
    ];

void checkUnnamed224(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceAggregatedListWarningData = 0;
api.InstanceAggregatedListWarningData buildInstanceAggregatedListWarningData() {
  final o = api.InstanceAggregatedListWarningData();
  buildCounterInstanceAggregatedListWarningData++;
  if (buildCounterInstanceAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceAggregatedListWarningData--;
  return o;
}

void checkInstanceAggregatedListWarningData(
    api.InstanceAggregatedListWarningData o) {
  buildCounterInstanceAggregatedListWarningData++;
  if (buildCounterInstanceAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceAggregatedListWarningData--;
}

core.List<api.InstanceAggregatedListWarningData> buildUnnamed225() => [
      buildInstanceAggregatedListWarningData(),
      buildInstanceAggregatedListWarningData(),
    ];

void checkUnnamed225(core.List<api.InstanceAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceAggregatedListWarningData(o[0]);
  checkInstanceAggregatedListWarningData(o[1]);
}

core.int buildCounterInstanceAggregatedListWarning = 0;
api.InstanceAggregatedListWarning buildInstanceAggregatedListWarning() {
  final o = api.InstanceAggregatedListWarning();
  buildCounterInstanceAggregatedListWarning++;
  if (buildCounterInstanceAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed225();
    o.message = 'foo';
  }
  buildCounterInstanceAggregatedListWarning--;
  return o;
}

void checkInstanceAggregatedListWarning(api.InstanceAggregatedListWarning o) {
  buildCounterInstanceAggregatedListWarning++;
  if (buildCounterInstanceAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed225(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceAggregatedListWarning--;
}

core.int buildCounterInstanceAggregatedList = 0;
api.InstanceAggregatedList buildInstanceAggregatedList() {
  final o = api.InstanceAggregatedList();
  buildCounterInstanceAggregatedList++;
  if (buildCounterInstanceAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed223();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed224();
    o.warning = buildInstanceAggregatedListWarning();
  }
  buildCounterInstanceAggregatedList--;
  return o;
}

void checkInstanceAggregatedList(api.InstanceAggregatedList o) {
  buildCounterInstanceAggregatedList++;
  if (buildCounterInstanceAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed223(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed224(o.unreachables!);
    checkInstanceAggregatedListWarning(o.warning!);
  }
  buildCounterInstanceAggregatedList--;
}

core.int buildCounterInstanceConsumptionData = 0;
api.InstanceConsumptionData buildInstanceConsumptionData() {
  final o = api.InstanceConsumptionData();
  buildCounterInstanceConsumptionData++;
  if (buildCounterInstanceConsumptionData < 3) {
    o.consumptionInfo = buildInstanceConsumptionInfo();
    o.instance = 'foo';
  }
  buildCounterInstanceConsumptionData--;
  return o;
}

void checkInstanceConsumptionData(api.InstanceConsumptionData o) {
  buildCounterInstanceConsumptionData++;
  if (buildCounterInstanceConsumptionData < 3) {
    checkInstanceConsumptionInfo(o.consumptionInfo!);
    unittest.expect(
      o.instance!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceConsumptionData--;
}

core.int buildCounterInstanceConsumptionInfo = 0;
api.InstanceConsumptionInfo buildInstanceConsumptionInfo() {
  final o = api.InstanceConsumptionInfo();
  buildCounterInstanceConsumptionInfo++;
  if (buildCounterInstanceConsumptionInfo < 3) {
    o.guestCpus = 42;
    o.localSsdGb = 42;
    o.memoryMb = 42;
    o.minNodeCpus = 42;
  }
  buildCounterInstanceConsumptionInfo--;
  return o;
}

void checkInstanceConsumptionInfo(api.InstanceConsumptionInfo o) {
  buildCounterInstanceConsumptionInfo++;
  if (buildCounterInstanceConsumptionInfo < 3) {
    unittest.expect(
      o.guestCpus!,
      unittest.equals(42),
    );
    unittest.expect(
      o.localSsdGb!,
      unittest.equals(42),
    );
    unittest.expect(
      o.memoryMb!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minNodeCpus!,
      unittest.equals(42),
    );
  }
  buildCounterInstanceConsumptionInfo--;
}

core.List<api.NamedPort> buildUnnamed226() => [
      buildNamedPort(),
      buildNamedPort(),
    ];

void checkUnnamed226(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.int buildCounterInstanceGroup = 0;
api.InstanceGroup buildInstanceGroup() {
  final o = api.InstanceGroup();
  buildCounterInstanceGroup++;
  if (buildCounterInstanceGroup < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.namedPorts = buildUnnamed226();
    o.network = 'foo';
    o.region = 'foo';
    o.selfLink = 'foo';
    o.size = 42;
    o.subnetwork = 'foo';
    o.zone = 'foo';
  }
  buildCounterInstanceGroup--;
  return o;
}

void checkInstanceGroup(api.InstanceGroup o) {
  buildCounterInstanceGroup++;
  if (buildCounterInstanceGroup < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed226(o.namedPorts!);
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.size!,
      unittest.equals(42),
    );
    unittest.expect(
      o.subnetwork!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroup--;
}

core.Map<core.String, api.InstanceGroupsScopedList> buildUnnamed227() => {
      'x': buildInstanceGroupsScopedList(),
      'y': buildInstanceGroupsScopedList(),
    };

void checkUnnamed227(core.Map<core.String, api.InstanceGroupsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupsScopedList(o['x']!);
  checkInstanceGroupsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed228() => [
      'foo',
      'foo',
    ];

void checkUnnamed228(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceGroupAggregatedListWarningData = 0;
api.InstanceGroupAggregatedListWarningData
    buildInstanceGroupAggregatedListWarningData() {
  final o = api.InstanceGroupAggregatedListWarningData();
  buildCounterInstanceGroupAggregatedListWarningData++;
  if (buildCounterInstanceGroupAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceGroupAggregatedListWarningData--;
  return o;
}

void checkInstanceGroupAggregatedListWarningData(
    api.InstanceGroupAggregatedListWarningData o) {
  buildCounterInstanceGroupAggregatedListWarningData++;
  if (buildCounterInstanceGroupAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupAggregatedListWarningData--;
}

core.List<api.InstanceGroupAggregatedListWarningData> buildUnnamed229() => [
      buildInstanceGroupAggregatedListWarningData(),
      buildInstanceGroupAggregatedListWarningData(),
    ];

void checkUnnamed229(core.List<api.InstanceGroupAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupAggregatedListWarningData(o[0]);
  checkInstanceGroupAggregatedListWarningData(o[1]);
}

core.int buildCounterInstanceGroupAggregatedListWarning = 0;
api.InstanceGroupAggregatedListWarning
    buildInstanceGroupAggregatedListWarning() {
  final o = api.InstanceGroupAggregatedListWarning();
  buildCounterInstanceGroupAggregatedListWarning++;
  if (buildCounterInstanceGroupAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed229();
    o.message = 'foo';
  }
  buildCounterInstanceGroupAggregatedListWarning--;
  return o;
}

void checkInstanceGroupAggregatedListWarning(
    api.InstanceGroupAggregatedListWarning o) {
  buildCounterInstanceGroupAggregatedListWarning++;
  if (buildCounterInstanceGroupAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed229(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupAggregatedListWarning--;
}

core.int buildCounterInstanceGroupAggregatedList = 0;
api.InstanceGroupAggregatedList buildInstanceGroupAggregatedList() {
  final o = api.InstanceGroupAggregatedList();
  buildCounterInstanceGroupAggregatedList++;
  if (buildCounterInstanceGroupAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed227();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed228();
    o.warning = buildInstanceGroupAggregatedListWarning();
  }
  buildCounterInstanceGroupAggregatedList--;
  return o;
}

void checkInstanceGroupAggregatedList(api.InstanceGroupAggregatedList o) {
  buildCounterInstanceGroupAggregatedList++;
  if (buildCounterInstanceGroupAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed227(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed228(o.unreachables!);
    checkInstanceGroupAggregatedListWarning(o.warning!);
  }
  buildCounterInstanceGroupAggregatedList--;
}

core.List<api.InstanceGroup> buildUnnamed230() => [
      buildInstanceGroup(),
      buildInstanceGroup(),
    ];

void checkUnnamed230(core.List<api.InstanceGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroup(o[0]);
  checkInstanceGroup(o[1]);
}

core.int buildCounterInstanceGroupListWarningData = 0;
api.InstanceGroupListWarningData buildInstanceGroupListWarningData() {
  final o = api.InstanceGroupListWarningData();
  buildCounterInstanceGroupListWarningData++;
  if (buildCounterInstanceGroupListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceGroupListWarningData--;
  return o;
}

void checkInstanceGroupListWarningData(api.InstanceGroupListWarningData o) {
  buildCounterInstanceGroupListWarningData++;
  if (buildCounterInstanceGroupListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupListWarningData--;
}

core.List<api.InstanceGroupListWarningData> buildUnnamed231() => [
      buildInstanceGroupListWarningData(),
      buildInstanceGroupListWarningData(),
    ];

void checkUnnamed231(core.List<api.InstanceGroupListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupListWarningData(o[0]);
  checkInstanceGroupListWarningData(o[1]);
}

core.int buildCounterInstanceGroupListWarning = 0;
api.InstanceGroupListWarning buildInstanceGroupListWarning() {
  final o = api.InstanceGroupListWarning();
  buildCounterInstanceGroupListWarning++;
  if (buildCounterInstanceGroupListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed231();
    o.message = 'foo';
  }
  buildCounterInstanceGroupListWarning--;
  return o;
}

void checkInstanceGroupListWarning(api.InstanceGroupListWarning o) {
  buildCounterInstanceGroupListWarning++;
  if (buildCounterInstanceGroupListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed231(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupListWarning--;
}

core.int buildCounterInstanceGroupList = 0;
api.InstanceGroupList buildInstanceGroupList() {
  final o = api.InstanceGroupList();
  buildCounterInstanceGroupList++;
  if (buildCounterInstanceGroupList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed230();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInstanceGroupListWarning();
  }
  buildCounterInstanceGroupList--;
  return o;
}

void checkInstanceGroupList(api.InstanceGroupList o) {
  buildCounterInstanceGroupList++;
  if (buildCounterInstanceGroupList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed230(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInstanceGroupListWarning(o.warning!);
  }
  buildCounterInstanceGroupList--;
}

core.List<api.InstanceGroupManagerAutoHealingPolicy> buildUnnamed232() => [
      buildInstanceGroupManagerAutoHealingPolicy(),
      buildInstanceGroupManagerAutoHealingPolicy(),
    ];

void checkUnnamed232(core.List<api.InstanceGroupManagerAutoHealingPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagerAutoHealingPolicy(o[0]);
  checkInstanceGroupManagerAutoHealingPolicy(o[1]);
}

core.List<api.NamedPort> buildUnnamed233() => [
      buildNamedPort(),
      buildNamedPort(),
    ];

void checkUnnamed233(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.List<core.String> buildUnnamed234() => [
      'foo',
      'foo',
    ];

void checkUnnamed234(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.InstanceGroupManagerVersion> buildUnnamed235() => [
      buildInstanceGroupManagerVersion(),
      buildInstanceGroupManagerVersion(),
    ];

void checkUnnamed235(core.List<api.InstanceGroupManagerVersion> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagerVersion(o[0]);
  checkInstanceGroupManagerVersion(o[1]);
}

core.int buildCounterInstanceGroupManager = 0;
api.InstanceGroupManager buildInstanceGroupManager() {
  final o = api.InstanceGroupManager();
  buildCounterInstanceGroupManager++;
  if (buildCounterInstanceGroupManager < 3) {
    o.autoHealingPolicies = buildUnnamed232();
    o.baseInstanceName = 'foo';
    o.creationTimestamp = 'foo';
    o.currentActions = buildInstanceGroupManagerActionsSummary();
    o.description = 'foo';
    o.distributionPolicy = buildDistributionPolicy();
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.instanceGroup = 'foo';
    o.instanceLifecyclePolicy =
        buildInstanceGroupManagerInstanceLifecyclePolicy();
    o.instanceTemplate = 'foo';
    o.kind = 'foo';
    o.listManagedInstancesResults = 'foo';
    o.name = 'foo';
    o.namedPorts = buildUnnamed233();
    o.region = 'foo';
    o.selfLink = 'foo';
    o.statefulPolicy = buildStatefulPolicy();
    o.status = buildInstanceGroupManagerStatus();
    o.targetPools = buildUnnamed234();
    o.targetSize = 42;
    o.updatePolicy = buildInstanceGroupManagerUpdatePolicy();
    o.versions = buildUnnamed235();
    o.zone = 'foo';
  }
  buildCounterInstanceGroupManager--;
  return o;
}

void checkInstanceGroupManager(api.InstanceGroupManager o) {
  buildCounterInstanceGroupManager++;
  if (buildCounterInstanceGroupManager < 3) {
    checkUnnamed232(o.autoHealingPolicies!);
    unittest.expect(
      o.baseInstanceName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkInstanceGroupManagerActionsSummary(o.currentActions!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkDistributionPolicy(o.distributionPolicy!);
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.instanceGroup!,
      unittest.equals('foo'),
    );
    checkInstanceGroupManagerInstanceLifecyclePolicy(
        o.instanceLifecyclePolicy!);
    unittest.expect(
      o.instanceTemplate!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.listManagedInstancesResults!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed233(o.namedPorts!);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkStatefulPolicy(o.statefulPolicy!);
    checkInstanceGroupManagerStatus(o.status!);
    checkUnnamed234(o.targetPools!);
    unittest.expect(
      o.targetSize!,
      unittest.equals(42),
    );
    checkInstanceGroupManagerUpdatePolicy(o.updatePolicy!);
    checkUnnamed235(o.versions!);
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManager--;
}

core.int buildCounterInstanceGroupManagerActionsSummary = 0;
api.InstanceGroupManagerActionsSummary
    buildInstanceGroupManagerActionsSummary() {
  final o = api.InstanceGroupManagerActionsSummary();
  buildCounterInstanceGroupManagerActionsSummary++;
  if (buildCounterInstanceGroupManagerActionsSummary < 3) {
    o.abandoning = 42;
    o.creating = 42;
    o.creatingWithoutRetries = 42;
    o.deleting = 42;
    o.none = 42;
    o.recreating = 42;
    o.refreshing = 42;
    o.restarting = 42;
    o.resuming = 42;
    o.starting = 42;
    o.stopping = 42;
    o.suspending = 42;
    o.verifying = 42;
  }
  buildCounterInstanceGroupManagerActionsSummary--;
  return o;
}

void checkInstanceGroupManagerActionsSummary(
    api.InstanceGroupManagerActionsSummary o) {
  buildCounterInstanceGroupManagerActionsSummary++;
  if (buildCounterInstanceGroupManagerActionsSummary < 3) {
    unittest.expect(
      o.abandoning!,
      unittest.equals(42),
    );
    unittest.expect(
      o.creating!,
      unittest.equals(42),
    );
    unittest.expect(
      o.creatingWithoutRetries!,
      unittest.equals(42),
    );
    unittest.expect(
      o.deleting!,
      unittest.equals(42),
    );
    unittest.expect(
      o.none!,
      unittest.equals(42),
    );
    unittest.expect(
      o.recreating!,
      unittest.equals(42),
    );
    unittest.expect(
      o.refreshing!,
      unittest.equals(42),
    );
    unittest.expect(
      o.restarting!,
      unittest.equals(42),
    );
    unittest.expect(
      o.resuming!,
      unittest.equals(42),
    );
    unittest.expect(
      o.starting!,
      unittest.equals(42),
    );
    unittest.expect(
      o.stopping!,
      unittest.equals(42),
    );
    unittest.expect(
      o.suspending!,
      unittest.equals(42),
    );
    unittest.expect(
      o.verifying!,
      unittest.equals(42),
    );
  }
  buildCounterInstanceGroupManagerActionsSummary--;
}

core.Map<core.String, api.InstanceGroupManagersScopedList> buildUnnamed236() =>
    {
      'x': buildInstanceGroupManagersScopedList(),
      'y': buildInstanceGroupManagersScopedList(),
    };

void checkUnnamed236(
    core.Map<core.String, api.InstanceGroupManagersScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagersScopedList(o['x']!);
  checkInstanceGroupManagersScopedList(o['y']!);
}

core.List<core.String> buildUnnamed237() => [
      'foo',
      'foo',
    ];

void checkUnnamed237(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceGroupManagerAggregatedListWarningData = 0;
api.InstanceGroupManagerAggregatedListWarningData
    buildInstanceGroupManagerAggregatedListWarningData() {
  final o = api.InstanceGroupManagerAggregatedListWarningData();
  buildCounterInstanceGroupManagerAggregatedListWarningData++;
  if (buildCounterInstanceGroupManagerAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceGroupManagerAggregatedListWarningData--;
  return o;
}

void checkInstanceGroupManagerAggregatedListWarningData(
    api.InstanceGroupManagerAggregatedListWarningData o) {
  buildCounterInstanceGroupManagerAggregatedListWarningData++;
  if (buildCounterInstanceGroupManagerAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagerAggregatedListWarningData--;
}

core.List<api.InstanceGroupManagerAggregatedListWarningData>
    buildUnnamed238() => [
          buildInstanceGroupManagerAggregatedListWarningData(),
          buildInstanceGroupManagerAggregatedListWarningData(),
        ];

void checkUnnamed238(
    core.List<api.InstanceGroupManagerAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagerAggregatedListWarningData(o[0]);
  checkInstanceGroupManagerAggregatedListWarningData(o[1]);
}

core.int buildCounterInstanceGroupManagerAggregatedListWarning = 0;
api.InstanceGroupManagerAggregatedListWarning
    buildInstanceGroupManagerAggregatedListWarning() {
  final o = api.InstanceGroupManagerAggregatedListWarning();
  buildCounterInstanceGroupManagerAggregatedListWarning++;
  if (buildCounterInstanceGroupManagerAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed238();
    o.message = 'foo';
  }
  buildCounterInstanceGroupManagerAggregatedListWarning--;
  return o;
}

void checkInstanceGroupManagerAggregatedListWarning(
    api.InstanceGroupManagerAggregatedListWarning o) {
  buildCounterInstanceGroupManagerAggregatedListWarning++;
  if (buildCounterInstanceGroupManagerAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed238(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagerAggregatedListWarning--;
}

core.int buildCounterInstanceGroupManagerAggregatedList = 0;
api.InstanceGroupManagerAggregatedList
    buildInstanceGroupManagerAggregatedList() {
  final o = api.InstanceGroupManagerAggregatedList();
  buildCounterInstanceGroupManagerAggregatedList++;
  if (buildCounterInstanceGroupManagerAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed236();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed237();
    o.warning = buildInstanceGroupManagerAggregatedListWarning();
  }
  buildCounterInstanceGroupManagerAggregatedList--;
  return o;
}

void checkInstanceGroupManagerAggregatedList(
    api.InstanceGroupManagerAggregatedList o) {
  buildCounterInstanceGroupManagerAggregatedList++;
  if (buildCounterInstanceGroupManagerAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed236(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed237(o.unreachables!);
    checkInstanceGroupManagerAggregatedListWarning(o.warning!);
  }
  buildCounterInstanceGroupManagerAggregatedList--;
}

core.int buildCounterInstanceGroupManagerAutoHealingPolicy = 0;
api.InstanceGroupManagerAutoHealingPolicy
    buildInstanceGroupManagerAutoHealingPolicy() {
  final o = api.InstanceGroupManagerAutoHealingPolicy();
  buildCounterInstanceGroupManagerAutoHealingPolicy++;
  if (buildCounterInstanceGroupManagerAutoHealingPolicy < 3) {
    o.healthCheck = 'foo';
    o.initialDelaySec = 42;
  }
  buildCounterInstanceGroupManagerAutoHealingPolicy--;
  return o;
}

void checkInstanceGroupManagerAutoHealingPolicy(
    api.InstanceGroupManagerAutoHealingPolicy o) {
  buildCounterInstanceGroupManagerAutoHealingPolicy++;
  if (buildCounterInstanceGroupManagerAutoHealingPolicy < 3) {
    unittest.expect(
      o.healthCheck!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.initialDelaySec!,
      unittest.equals(42),
    );
  }
  buildCounterInstanceGroupManagerAutoHealingPolicy--;
}

core.int buildCounterInstanceGroupManagerInstanceLifecyclePolicy = 0;
api.InstanceGroupManagerInstanceLifecyclePolicy
    buildInstanceGroupManagerInstanceLifecyclePolicy() {
  final o = api.InstanceGroupManagerInstanceLifecyclePolicy();
  buildCounterInstanceGroupManagerInstanceLifecyclePolicy++;
  if (buildCounterInstanceGroupManagerInstanceLifecyclePolicy < 3) {
    o.forceUpdateOnRepair = 'foo';
  }
  buildCounterInstanceGroupManagerInstanceLifecyclePolicy--;
  return o;
}

void checkInstanceGroupManagerInstanceLifecyclePolicy(
    api.InstanceGroupManagerInstanceLifecyclePolicy o) {
  buildCounterInstanceGroupManagerInstanceLifecyclePolicy++;
  if (buildCounterInstanceGroupManagerInstanceLifecyclePolicy < 3) {
    unittest.expect(
      o.forceUpdateOnRepair!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagerInstanceLifecyclePolicy--;
}

core.List<api.InstanceGroupManager> buildUnnamed239() => [
      buildInstanceGroupManager(),
      buildInstanceGroupManager(),
    ];

void checkUnnamed239(core.List<api.InstanceGroupManager> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManager(o[0]);
  checkInstanceGroupManager(o[1]);
}

core.int buildCounterInstanceGroupManagerListWarningData = 0;
api.InstanceGroupManagerListWarningData
    buildInstanceGroupManagerListWarningData() {
  final o = api.InstanceGroupManagerListWarningData();
  buildCounterInstanceGroupManagerListWarningData++;
  if (buildCounterInstanceGroupManagerListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceGroupManagerListWarningData--;
  return o;
}

void checkInstanceGroupManagerListWarningData(
    api.InstanceGroupManagerListWarningData o) {
  buildCounterInstanceGroupManagerListWarningData++;
  if (buildCounterInstanceGroupManagerListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagerListWarningData--;
}

core.List<api.InstanceGroupManagerListWarningData> buildUnnamed240() => [
      buildInstanceGroupManagerListWarningData(),
      buildInstanceGroupManagerListWarningData(),
    ];

void checkUnnamed240(core.List<api.InstanceGroupManagerListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagerListWarningData(o[0]);
  checkInstanceGroupManagerListWarningData(o[1]);
}

core.int buildCounterInstanceGroupManagerListWarning = 0;
api.InstanceGroupManagerListWarning buildInstanceGroupManagerListWarning() {
  final o = api.InstanceGroupManagerListWarning();
  buildCounterInstanceGroupManagerListWarning++;
  if (buildCounterInstanceGroupManagerListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed240();
    o.message = 'foo';
  }
  buildCounterInstanceGroupManagerListWarning--;
  return o;
}

void checkInstanceGroupManagerListWarning(
    api.InstanceGroupManagerListWarning o) {
  buildCounterInstanceGroupManagerListWarning++;
  if (buildCounterInstanceGroupManagerListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed240(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagerListWarning--;
}

core.int buildCounterInstanceGroupManagerList = 0;
api.InstanceGroupManagerList buildInstanceGroupManagerList() {
  final o = api.InstanceGroupManagerList();
  buildCounterInstanceGroupManagerList++;
  if (buildCounterInstanceGroupManagerList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed239();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInstanceGroupManagerListWarning();
  }
  buildCounterInstanceGroupManagerList--;
  return o;
}

void checkInstanceGroupManagerList(api.InstanceGroupManagerList o) {
  buildCounterInstanceGroupManagerList++;
  if (buildCounterInstanceGroupManagerList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed239(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInstanceGroupManagerListWarning(o.warning!);
  }
  buildCounterInstanceGroupManagerList--;
}

core.int buildCounterInstanceGroupManagerStatus = 0;
api.InstanceGroupManagerStatus buildInstanceGroupManagerStatus() {
  final o = api.InstanceGroupManagerStatus();
  buildCounterInstanceGroupManagerStatus++;
  if (buildCounterInstanceGroupManagerStatus < 3) {
    o.autoscaler = 'foo';
    o.isStable = true;
    o.stateful = buildInstanceGroupManagerStatusStateful();
    o.versionTarget = buildInstanceGroupManagerStatusVersionTarget();
  }
  buildCounterInstanceGroupManagerStatus--;
  return o;
}

void checkInstanceGroupManagerStatus(api.InstanceGroupManagerStatus o) {
  buildCounterInstanceGroupManagerStatus++;
  if (buildCounterInstanceGroupManagerStatus < 3) {
    unittest.expect(
      o.autoscaler!,
      unittest.equals('foo'),
    );
    unittest.expect(o.isStable!, unittest.isTrue);
    checkInstanceGroupManagerStatusStateful(o.stateful!);
    checkInstanceGroupManagerStatusVersionTarget(o.versionTarget!);
  }
  buildCounterInstanceGroupManagerStatus--;
}

core.int buildCounterInstanceGroupManagerStatusStateful = 0;
api.InstanceGroupManagerStatusStateful
    buildInstanceGroupManagerStatusStateful() {
  final o = api.InstanceGroupManagerStatusStateful();
  buildCounterInstanceGroupManagerStatusStateful++;
  if (buildCounterInstanceGroupManagerStatusStateful < 3) {
    o.hasStatefulConfig = true;
    o.perInstanceConfigs =
        buildInstanceGroupManagerStatusStatefulPerInstanceConfigs();
  }
  buildCounterInstanceGroupManagerStatusStateful--;
  return o;
}

void checkInstanceGroupManagerStatusStateful(
    api.InstanceGroupManagerStatusStateful o) {
  buildCounterInstanceGroupManagerStatusStateful++;
  if (buildCounterInstanceGroupManagerStatusStateful < 3) {
    unittest.expect(o.hasStatefulConfig!, unittest.isTrue);
    checkInstanceGroupManagerStatusStatefulPerInstanceConfigs(
        o.perInstanceConfigs!);
  }
  buildCounterInstanceGroupManagerStatusStateful--;
}

core.int buildCounterInstanceGroupManagerStatusStatefulPerInstanceConfigs = 0;
api.InstanceGroupManagerStatusStatefulPerInstanceConfigs
    buildInstanceGroupManagerStatusStatefulPerInstanceConfigs() {
  final o = api.InstanceGroupManagerStatusStatefulPerInstanceConfigs();
  buildCounterInstanceGroupManagerStatusStatefulPerInstanceConfigs++;
  if (buildCounterInstanceGroupManagerStatusStatefulPerInstanceConfigs < 3) {
    o.allEffective = true;
  }
  buildCounterInstanceGroupManagerStatusStatefulPerInstanceConfigs--;
  return o;
}

void checkInstanceGroupManagerStatusStatefulPerInstanceConfigs(
    api.InstanceGroupManagerStatusStatefulPerInstanceConfigs o) {
  buildCounterInstanceGroupManagerStatusStatefulPerInstanceConfigs++;
  if (buildCounterInstanceGroupManagerStatusStatefulPerInstanceConfigs < 3) {
    unittest.expect(o.allEffective!, unittest.isTrue);
  }
  buildCounterInstanceGroupManagerStatusStatefulPerInstanceConfigs--;
}

core.int buildCounterInstanceGroupManagerStatusVersionTarget = 0;
api.InstanceGroupManagerStatusVersionTarget
    buildInstanceGroupManagerStatusVersionTarget() {
  final o = api.InstanceGroupManagerStatusVersionTarget();
  buildCounterInstanceGroupManagerStatusVersionTarget++;
  if (buildCounterInstanceGroupManagerStatusVersionTarget < 3) {
    o.isReached = true;
  }
  buildCounterInstanceGroupManagerStatusVersionTarget--;
  return o;
}

void checkInstanceGroupManagerStatusVersionTarget(
    api.InstanceGroupManagerStatusVersionTarget o) {
  buildCounterInstanceGroupManagerStatusVersionTarget++;
  if (buildCounterInstanceGroupManagerStatusVersionTarget < 3) {
    unittest.expect(o.isReached!, unittest.isTrue);
  }
  buildCounterInstanceGroupManagerStatusVersionTarget--;
}

core.int buildCounterInstanceGroupManagerUpdatePolicy = 0;
api.InstanceGroupManagerUpdatePolicy buildInstanceGroupManagerUpdatePolicy() {
  final o = api.InstanceGroupManagerUpdatePolicy();
  buildCounterInstanceGroupManagerUpdatePolicy++;
  if (buildCounterInstanceGroupManagerUpdatePolicy < 3) {
    o.instanceRedistributionType = 'foo';
    o.maxSurge = buildFixedOrPercent();
    o.maxUnavailable = buildFixedOrPercent();
    o.minimalAction = 'foo';
    o.mostDisruptiveAllowedAction = 'foo';
    o.replacementMethod = 'foo';
    o.type = 'foo';
  }
  buildCounterInstanceGroupManagerUpdatePolicy--;
  return o;
}

void checkInstanceGroupManagerUpdatePolicy(
    api.InstanceGroupManagerUpdatePolicy o) {
  buildCounterInstanceGroupManagerUpdatePolicy++;
  if (buildCounterInstanceGroupManagerUpdatePolicy < 3) {
    unittest.expect(
      o.instanceRedistributionType!,
      unittest.equals('foo'),
    );
    checkFixedOrPercent(o.maxSurge!);
    checkFixedOrPercent(o.maxUnavailable!);
    unittest.expect(
      o.minimalAction!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.mostDisruptiveAllowedAction!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.replacementMethod!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagerUpdatePolicy--;
}

core.int buildCounterInstanceGroupManagerVersion = 0;
api.InstanceGroupManagerVersion buildInstanceGroupManagerVersion() {
  final o = api.InstanceGroupManagerVersion();
  buildCounterInstanceGroupManagerVersion++;
  if (buildCounterInstanceGroupManagerVersion < 3) {
    o.instanceTemplate = 'foo';
    o.name = 'foo';
    o.targetSize = buildFixedOrPercent();
  }
  buildCounterInstanceGroupManagerVersion--;
  return o;
}

void checkInstanceGroupManagerVersion(api.InstanceGroupManagerVersion o) {
  buildCounterInstanceGroupManagerVersion++;
  if (buildCounterInstanceGroupManagerVersion < 3) {
    unittest.expect(
      o.instanceTemplate!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkFixedOrPercent(o.targetSize!);
  }
  buildCounterInstanceGroupManagerVersion--;
}

core.List<core.String> buildUnnamed241() => [
      'foo',
      'foo',
    ];

void checkUnnamed241(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceGroupManagersAbandonInstancesRequest = 0;
api.InstanceGroupManagersAbandonInstancesRequest
    buildInstanceGroupManagersAbandonInstancesRequest() {
  final o = api.InstanceGroupManagersAbandonInstancesRequest();
  buildCounterInstanceGroupManagersAbandonInstancesRequest++;
  if (buildCounterInstanceGroupManagersAbandonInstancesRequest < 3) {
    o.instances = buildUnnamed241();
  }
  buildCounterInstanceGroupManagersAbandonInstancesRequest--;
  return o;
}

void checkInstanceGroupManagersAbandonInstancesRequest(
    api.InstanceGroupManagersAbandonInstancesRequest o) {
  buildCounterInstanceGroupManagersAbandonInstancesRequest++;
  if (buildCounterInstanceGroupManagersAbandonInstancesRequest < 3) {
    checkUnnamed241(o.instances!);
  }
  buildCounterInstanceGroupManagersAbandonInstancesRequest--;
}

core.List<core.String> buildUnnamed242() => [
      'foo',
      'foo',
    ];

void checkUnnamed242(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceGroupManagersApplyUpdatesRequest = 0;
api.InstanceGroupManagersApplyUpdatesRequest
    buildInstanceGroupManagersApplyUpdatesRequest() {
  final o = api.InstanceGroupManagersApplyUpdatesRequest();
  buildCounterInstanceGroupManagersApplyUpdatesRequest++;
  if (buildCounterInstanceGroupManagersApplyUpdatesRequest < 3) {
    o.allInstances = true;
    o.instances = buildUnnamed242();
    o.minimalAction = 'foo';
    o.mostDisruptiveAllowedAction = 'foo';
  }
  buildCounterInstanceGroupManagersApplyUpdatesRequest--;
  return o;
}

void checkInstanceGroupManagersApplyUpdatesRequest(
    api.InstanceGroupManagersApplyUpdatesRequest o) {
  buildCounterInstanceGroupManagersApplyUpdatesRequest++;
  if (buildCounterInstanceGroupManagersApplyUpdatesRequest < 3) {
    unittest.expect(o.allInstances!, unittest.isTrue);
    checkUnnamed242(o.instances!);
    unittest.expect(
      o.minimalAction!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.mostDisruptiveAllowedAction!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagersApplyUpdatesRequest--;
}

core.List<api.PerInstanceConfig> buildUnnamed243() => [
      buildPerInstanceConfig(),
      buildPerInstanceConfig(),
    ];

void checkUnnamed243(core.List<api.PerInstanceConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPerInstanceConfig(o[0]);
  checkPerInstanceConfig(o[1]);
}

core.int buildCounterInstanceGroupManagersCreateInstancesRequest = 0;
api.InstanceGroupManagersCreateInstancesRequest
    buildInstanceGroupManagersCreateInstancesRequest() {
  final o = api.InstanceGroupManagersCreateInstancesRequest();
  buildCounterInstanceGroupManagersCreateInstancesRequest++;
  if (buildCounterInstanceGroupManagersCreateInstancesRequest < 3) {
    o.instances = buildUnnamed243();
  }
  buildCounterInstanceGroupManagersCreateInstancesRequest--;
  return o;
}

void checkInstanceGroupManagersCreateInstancesRequest(
    api.InstanceGroupManagersCreateInstancesRequest o) {
  buildCounterInstanceGroupManagersCreateInstancesRequest++;
  if (buildCounterInstanceGroupManagersCreateInstancesRequest < 3) {
    checkUnnamed243(o.instances!);
  }
  buildCounterInstanceGroupManagersCreateInstancesRequest--;
}

core.List<core.String> buildUnnamed244() => [
      'foo',
      'foo',
    ];

void checkUnnamed244(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceGroupManagersDeleteInstancesRequest = 0;
api.InstanceGroupManagersDeleteInstancesRequest
    buildInstanceGroupManagersDeleteInstancesRequest() {
  final o = api.InstanceGroupManagersDeleteInstancesRequest();
  buildCounterInstanceGroupManagersDeleteInstancesRequest++;
  if (buildCounterInstanceGroupManagersDeleteInstancesRequest < 3) {
    o.instances = buildUnnamed244();
    o.skipInstancesOnValidationError = true;
  }
  buildCounterInstanceGroupManagersDeleteInstancesRequest--;
  return o;
}

void checkInstanceGroupManagersDeleteInstancesRequest(
    api.InstanceGroupManagersDeleteInstancesRequest o) {
  buildCounterInstanceGroupManagersDeleteInstancesRequest++;
  if (buildCounterInstanceGroupManagersDeleteInstancesRequest < 3) {
    checkUnnamed244(o.instances!);
    unittest.expect(o.skipInstancesOnValidationError!, unittest.isTrue);
  }
  buildCounterInstanceGroupManagersDeleteInstancesRequest--;
}

core.List<core.String> buildUnnamed245() => [
      'foo',
      'foo',
    ];

void checkUnnamed245(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceGroupManagersDeletePerInstanceConfigsReq = 0;
api.InstanceGroupManagersDeletePerInstanceConfigsReq
    buildInstanceGroupManagersDeletePerInstanceConfigsReq() {
  final o = api.InstanceGroupManagersDeletePerInstanceConfigsReq();
  buildCounterInstanceGroupManagersDeletePerInstanceConfigsReq++;
  if (buildCounterInstanceGroupManagersDeletePerInstanceConfigsReq < 3) {
    o.names = buildUnnamed245();
  }
  buildCounterInstanceGroupManagersDeletePerInstanceConfigsReq--;
  return o;
}

void checkInstanceGroupManagersDeletePerInstanceConfigsReq(
    api.InstanceGroupManagersDeletePerInstanceConfigsReq o) {
  buildCounterInstanceGroupManagersDeletePerInstanceConfigsReq++;
  if (buildCounterInstanceGroupManagersDeletePerInstanceConfigsReq < 3) {
    checkUnnamed245(o.names!);
  }
  buildCounterInstanceGroupManagersDeletePerInstanceConfigsReq--;
}

core.List<api.InstanceManagedByIgmError> buildUnnamed246() => [
      buildInstanceManagedByIgmError(),
      buildInstanceManagedByIgmError(),
    ];

void checkUnnamed246(core.List<api.InstanceManagedByIgmError> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceManagedByIgmError(o[0]);
  checkInstanceManagedByIgmError(o[1]);
}

core.int buildCounterInstanceGroupManagersListErrorsResponse = 0;
api.InstanceGroupManagersListErrorsResponse
    buildInstanceGroupManagersListErrorsResponse() {
  final o = api.InstanceGroupManagersListErrorsResponse();
  buildCounterInstanceGroupManagersListErrorsResponse++;
  if (buildCounterInstanceGroupManagersListErrorsResponse < 3) {
    o.items = buildUnnamed246();
    o.nextPageToken = 'foo';
  }
  buildCounterInstanceGroupManagersListErrorsResponse--;
  return o;
}

void checkInstanceGroupManagersListErrorsResponse(
    api.InstanceGroupManagersListErrorsResponse o) {
  buildCounterInstanceGroupManagersListErrorsResponse++;
  if (buildCounterInstanceGroupManagersListErrorsResponse < 3) {
    checkUnnamed246(o.items!);
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagersListErrorsResponse--;
}

core.List<api.ManagedInstance> buildUnnamed247() => [
      buildManagedInstance(),
      buildManagedInstance(),
    ];

void checkUnnamed247(core.List<api.ManagedInstance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkManagedInstance(o[0]);
  checkManagedInstance(o[1]);
}

core.int buildCounterInstanceGroupManagersListManagedInstancesResponse = 0;
api.InstanceGroupManagersListManagedInstancesResponse
    buildInstanceGroupManagersListManagedInstancesResponse() {
  final o = api.InstanceGroupManagersListManagedInstancesResponse();
  buildCounterInstanceGroupManagersListManagedInstancesResponse++;
  if (buildCounterInstanceGroupManagersListManagedInstancesResponse < 3) {
    o.managedInstances = buildUnnamed247();
    o.nextPageToken = 'foo';
  }
  buildCounterInstanceGroupManagersListManagedInstancesResponse--;
  return o;
}

void checkInstanceGroupManagersListManagedInstancesResponse(
    api.InstanceGroupManagersListManagedInstancesResponse o) {
  buildCounterInstanceGroupManagersListManagedInstancesResponse++;
  if (buildCounterInstanceGroupManagersListManagedInstancesResponse < 3) {
    checkUnnamed247(o.managedInstances!);
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagersListManagedInstancesResponse--;
}

core.List<api.PerInstanceConfig> buildUnnamed248() => [
      buildPerInstanceConfig(),
      buildPerInstanceConfig(),
    ];

void checkUnnamed248(core.List<api.PerInstanceConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPerInstanceConfig(o[0]);
  checkPerInstanceConfig(o[1]);
}

core.int
    buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarningData = 0;
api.InstanceGroupManagersListPerInstanceConfigsRespWarningData
    buildInstanceGroupManagersListPerInstanceConfigsRespWarningData() {
  final o = api.InstanceGroupManagersListPerInstanceConfigsRespWarningData();
  buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarningData++;
  if (buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarningData <
      3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarningData--;
  return o;
}

void checkInstanceGroupManagersListPerInstanceConfigsRespWarningData(
    api.InstanceGroupManagersListPerInstanceConfigsRespWarningData o) {
  buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarningData++;
  if (buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarningData <
      3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarningData--;
}

core.List<api.InstanceGroupManagersListPerInstanceConfigsRespWarningData>
    buildUnnamed249() => [
          buildInstanceGroupManagersListPerInstanceConfigsRespWarningData(),
          buildInstanceGroupManagersListPerInstanceConfigsRespWarningData(),
        ];

void checkUnnamed249(
    core.List<api.InstanceGroupManagersListPerInstanceConfigsRespWarningData>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagersListPerInstanceConfigsRespWarningData(o[0]);
  checkInstanceGroupManagersListPerInstanceConfigsRespWarningData(o[1]);
}

core.int buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarning = 0;
api.InstanceGroupManagersListPerInstanceConfigsRespWarning
    buildInstanceGroupManagersListPerInstanceConfigsRespWarning() {
  final o = api.InstanceGroupManagersListPerInstanceConfigsRespWarning();
  buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarning++;
  if (buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed249();
    o.message = 'foo';
  }
  buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarning--;
  return o;
}

void checkInstanceGroupManagersListPerInstanceConfigsRespWarning(
    api.InstanceGroupManagersListPerInstanceConfigsRespWarning o) {
  buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarning++;
  if (buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed249(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagersListPerInstanceConfigsRespWarning--;
}

core.int buildCounterInstanceGroupManagersListPerInstanceConfigsResp = 0;
api.InstanceGroupManagersListPerInstanceConfigsResp
    buildInstanceGroupManagersListPerInstanceConfigsResp() {
  final o = api.InstanceGroupManagersListPerInstanceConfigsResp();
  buildCounterInstanceGroupManagersListPerInstanceConfigsResp++;
  if (buildCounterInstanceGroupManagersListPerInstanceConfigsResp < 3) {
    o.items = buildUnnamed248();
    o.nextPageToken = 'foo';
    o.warning = buildInstanceGroupManagersListPerInstanceConfigsRespWarning();
  }
  buildCounterInstanceGroupManagersListPerInstanceConfigsResp--;
  return o;
}

void checkInstanceGroupManagersListPerInstanceConfigsResp(
    api.InstanceGroupManagersListPerInstanceConfigsResp o) {
  buildCounterInstanceGroupManagersListPerInstanceConfigsResp++;
  if (buildCounterInstanceGroupManagersListPerInstanceConfigsResp < 3) {
    checkUnnamed248(o.items!);
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    checkInstanceGroupManagersListPerInstanceConfigsRespWarning(o.warning!);
  }
  buildCounterInstanceGroupManagersListPerInstanceConfigsResp--;
}

core.List<api.PerInstanceConfig> buildUnnamed250() => [
      buildPerInstanceConfig(),
      buildPerInstanceConfig(),
    ];

void checkUnnamed250(core.List<api.PerInstanceConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPerInstanceConfig(o[0]);
  checkPerInstanceConfig(o[1]);
}

core.int buildCounterInstanceGroupManagersPatchPerInstanceConfigsReq = 0;
api.InstanceGroupManagersPatchPerInstanceConfigsReq
    buildInstanceGroupManagersPatchPerInstanceConfigsReq() {
  final o = api.InstanceGroupManagersPatchPerInstanceConfigsReq();
  buildCounterInstanceGroupManagersPatchPerInstanceConfigsReq++;
  if (buildCounterInstanceGroupManagersPatchPerInstanceConfigsReq < 3) {
    o.perInstanceConfigs = buildUnnamed250();
  }
  buildCounterInstanceGroupManagersPatchPerInstanceConfigsReq--;
  return o;
}

void checkInstanceGroupManagersPatchPerInstanceConfigsReq(
    api.InstanceGroupManagersPatchPerInstanceConfigsReq o) {
  buildCounterInstanceGroupManagersPatchPerInstanceConfigsReq++;
  if (buildCounterInstanceGroupManagersPatchPerInstanceConfigsReq < 3) {
    checkUnnamed250(o.perInstanceConfigs!);
  }
  buildCounterInstanceGroupManagersPatchPerInstanceConfigsReq--;
}

core.List<core.String> buildUnnamed251() => [
      'foo',
      'foo',
    ];

void checkUnnamed251(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceGroupManagersRecreateInstancesRequest = 0;
api.InstanceGroupManagersRecreateInstancesRequest
    buildInstanceGroupManagersRecreateInstancesRequest() {
  final o = api.InstanceGroupManagersRecreateInstancesRequest();
  buildCounterInstanceGroupManagersRecreateInstancesRequest++;
  if (buildCounterInstanceGroupManagersRecreateInstancesRequest < 3) {
    o.instances = buildUnnamed251();
  }
  buildCounterInstanceGroupManagersRecreateInstancesRequest--;
  return o;
}

void checkInstanceGroupManagersRecreateInstancesRequest(
    api.InstanceGroupManagersRecreateInstancesRequest o) {
  buildCounterInstanceGroupManagersRecreateInstancesRequest++;
  if (buildCounterInstanceGroupManagersRecreateInstancesRequest < 3) {
    checkUnnamed251(o.instances!);
  }
  buildCounterInstanceGroupManagersRecreateInstancesRequest--;
}

core.List<api.InstanceGroupManager> buildUnnamed252() => [
      buildInstanceGroupManager(),
      buildInstanceGroupManager(),
    ];

void checkUnnamed252(core.List<api.InstanceGroupManager> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManager(o[0]);
  checkInstanceGroupManager(o[1]);
}

core.int buildCounterInstanceGroupManagersScopedListWarningData = 0;
api.InstanceGroupManagersScopedListWarningData
    buildInstanceGroupManagersScopedListWarningData() {
  final o = api.InstanceGroupManagersScopedListWarningData();
  buildCounterInstanceGroupManagersScopedListWarningData++;
  if (buildCounterInstanceGroupManagersScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceGroupManagersScopedListWarningData--;
  return o;
}

void checkInstanceGroupManagersScopedListWarningData(
    api.InstanceGroupManagersScopedListWarningData o) {
  buildCounterInstanceGroupManagersScopedListWarningData++;
  if (buildCounterInstanceGroupManagersScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagersScopedListWarningData--;
}

core.List<api.InstanceGroupManagersScopedListWarningData> buildUnnamed253() => [
      buildInstanceGroupManagersScopedListWarningData(),
      buildInstanceGroupManagersScopedListWarningData(),
    ];

void checkUnnamed253(
    core.List<api.InstanceGroupManagersScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManagersScopedListWarningData(o[0]);
  checkInstanceGroupManagersScopedListWarningData(o[1]);
}

core.int buildCounterInstanceGroupManagersScopedListWarning = 0;
api.InstanceGroupManagersScopedListWarning
    buildInstanceGroupManagersScopedListWarning() {
  final o = api.InstanceGroupManagersScopedListWarning();
  buildCounterInstanceGroupManagersScopedListWarning++;
  if (buildCounterInstanceGroupManagersScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed253();
    o.message = 'foo';
  }
  buildCounterInstanceGroupManagersScopedListWarning--;
  return o;
}

void checkInstanceGroupManagersScopedListWarning(
    api.InstanceGroupManagersScopedListWarning o) {
  buildCounterInstanceGroupManagersScopedListWarning++;
  if (buildCounterInstanceGroupManagersScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed253(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagersScopedListWarning--;
}

core.int buildCounterInstanceGroupManagersScopedList = 0;
api.InstanceGroupManagersScopedList buildInstanceGroupManagersScopedList() {
  final o = api.InstanceGroupManagersScopedList();
  buildCounterInstanceGroupManagersScopedList++;
  if (buildCounterInstanceGroupManagersScopedList < 3) {
    o.instanceGroupManagers = buildUnnamed252();
    o.warning = buildInstanceGroupManagersScopedListWarning();
  }
  buildCounterInstanceGroupManagersScopedList--;
  return o;
}

void checkInstanceGroupManagersScopedList(
    api.InstanceGroupManagersScopedList o) {
  buildCounterInstanceGroupManagersScopedList++;
  if (buildCounterInstanceGroupManagersScopedList < 3) {
    checkUnnamed252(o.instanceGroupManagers!);
    checkInstanceGroupManagersScopedListWarning(o.warning!);
  }
  buildCounterInstanceGroupManagersScopedList--;
}

core.int buildCounterInstanceGroupManagersSetInstanceTemplateRequest = 0;
api.InstanceGroupManagersSetInstanceTemplateRequest
    buildInstanceGroupManagersSetInstanceTemplateRequest() {
  final o = api.InstanceGroupManagersSetInstanceTemplateRequest();
  buildCounterInstanceGroupManagersSetInstanceTemplateRequest++;
  if (buildCounterInstanceGroupManagersSetInstanceTemplateRequest < 3) {
    o.instanceTemplate = 'foo';
  }
  buildCounterInstanceGroupManagersSetInstanceTemplateRequest--;
  return o;
}

void checkInstanceGroupManagersSetInstanceTemplateRequest(
    api.InstanceGroupManagersSetInstanceTemplateRequest o) {
  buildCounterInstanceGroupManagersSetInstanceTemplateRequest++;
  if (buildCounterInstanceGroupManagersSetInstanceTemplateRequest < 3) {
    unittest.expect(
      o.instanceTemplate!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupManagersSetInstanceTemplateRequest--;
}

core.List<core.String> buildUnnamed254() => [
      'foo',
      'foo',
    ];

void checkUnnamed254(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceGroupManagersSetTargetPoolsRequest = 0;
api.InstanceGroupManagersSetTargetPoolsRequest
    buildInstanceGroupManagersSetTargetPoolsRequest() {
  final o = api.InstanceGroupManagersSetTargetPoolsRequest();
  buildCounterInstanceGroupManagersSetTargetPoolsRequest++;
  if (buildCounterInstanceGroupManagersSetTargetPoolsRequest < 3) {
    o.fingerprint = 'foo';
    o.targetPools = buildUnnamed254();
  }
  buildCounterInstanceGroupManagersSetTargetPoolsRequest--;
  return o;
}

void checkInstanceGroupManagersSetTargetPoolsRequest(
    api.InstanceGroupManagersSetTargetPoolsRequest o) {
  buildCounterInstanceGroupManagersSetTargetPoolsRequest++;
  if (buildCounterInstanceGroupManagersSetTargetPoolsRequest < 3) {
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed254(o.targetPools!);
  }
  buildCounterInstanceGroupManagersSetTargetPoolsRequest--;
}

core.List<api.PerInstanceConfig> buildUnnamed255() => [
      buildPerInstanceConfig(),
      buildPerInstanceConfig(),
    ];

void checkUnnamed255(core.List<api.PerInstanceConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPerInstanceConfig(o[0]);
  checkPerInstanceConfig(o[1]);
}

core.int buildCounterInstanceGroupManagersUpdatePerInstanceConfigsReq = 0;
api.InstanceGroupManagersUpdatePerInstanceConfigsReq
    buildInstanceGroupManagersUpdatePerInstanceConfigsReq() {
  final o = api.InstanceGroupManagersUpdatePerInstanceConfigsReq();
  buildCounterInstanceGroupManagersUpdatePerInstanceConfigsReq++;
  if (buildCounterInstanceGroupManagersUpdatePerInstanceConfigsReq < 3) {
    o.perInstanceConfigs = buildUnnamed255();
  }
  buildCounterInstanceGroupManagersUpdatePerInstanceConfigsReq--;
  return o;
}

void checkInstanceGroupManagersUpdatePerInstanceConfigsReq(
    api.InstanceGroupManagersUpdatePerInstanceConfigsReq o) {
  buildCounterInstanceGroupManagersUpdatePerInstanceConfigsReq++;
  if (buildCounterInstanceGroupManagersUpdatePerInstanceConfigsReq < 3) {
    checkUnnamed255(o.perInstanceConfigs!);
  }
  buildCounterInstanceGroupManagersUpdatePerInstanceConfigsReq--;
}

core.List<api.InstanceReference> buildUnnamed256() => [
      buildInstanceReference(),
      buildInstanceReference(),
    ];

void checkUnnamed256(core.List<api.InstanceReference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceReference(o[0]);
  checkInstanceReference(o[1]);
}

core.int buildCounterInstanceGroupsAddInstancesRequest = 0;
api.InstanceGroupsAddInstancesRequest buildInstanceGroupsAddInstancesRequest() {
  final o = api.InstanceGroupsAddInstancesRequest();
  buildCounterInstanceGroupsAddInstancesRequest++;
  if (buildCounterInstanceGroupsAddInstancesRequest < 3) {
    o.instances = buildUnnamed256();
  }
  buildCounterInstanceGroupsAddInstancesRequest--;
  return o;
}

void checkInstanceGroupsAddInstancesRequest(
    api.InstanceGroupsAddInstancesRequest o) {
  buildCounterInstanceGroupsAddInstancesRequest++;
  if (buildCounterInstanceGroupsAddInstancesRequest < 3) {
    checkUnnamed256(o.instances!);
  }
  buildCounterInstanceGroupsAddInstancesRequest--;
}

core.List<api.InstanceWithNamedPorts> buildUnnamed257() => [
      buildInstanceWithNamedPorts(),
      buildInstanceWithNamedPorts(),
    ];

void checkUnnamed257(core.List<api.InstanceWithNamedPorts> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceWithNamedPorts(o[0]);
  checkInstanceWithNamedPorts(o[1]);
}

core.int buildCounterInstanceGroupsListInstancesWarningData = 0;
api.InstanceGroupsListInstancesWarningData
    buildInstanceGroupsListInstancesWarningData() {
  final o = api.InstanceGroupsListInstancesWarningData();
  buildCounterInstanceGroupsListInstancesWarningData++;
  if (buildCounterInstanceGroupsListInstancesWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceGroupsListInstancesWarningData--;
  return o;
}

void checkInstanceGroupsListInstancesWarningData(
    api.InstanceGroupsListInstancesWarningData o) {
  buildCounterInstanceGroupsListInstancesWarningData++;
  if (buildCounterInstanceGroupsListInstancesWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupsListInstancesWarningData--;
}

core.List<api.InstanceGroupsListInstancesWarningData> buildUnnamed258() => [
      buildInstanceGroupsListInstancesWarningData(),
      buildInstanceGroupsListInstancesWarningData(),
    ];

void checkUnnamed258(core.List<api.InstanceGroupsListInstancesWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupsListInstancesWarningData(o[0]);
  checkInstanceGroupsListInstancesWarningData(o[1]);
}

core.int buildCounterInstanceGroupsListInstancesWarning = 0;
api.InstanceGroupsListInstancesWarning
    buildInstanceGroupsListInstancesWarning() {
  final o = api.InstanceGroupsListInstancesWarning();
  buildCounterInstanceGroupsListInstancesWarning++;
  if (buildCounterInstanceGroupsListInstancesWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed258();
    o.message = 'foo';
  }
  buildCounterInstanceGroupsListInstancesWarning--;
  return o;
}

void checkInstanceGroupsListInstancesWarning(
    api.InstanceGroupsListInstancesWarning o) {
  buildCounterInstanceGroupsListInstancesWarning++;
  if (buildCounterInstanceGroupsListInstancesWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed258(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupsListInstancesWarning--;
}

core.int buildCounterInstanceGroupsListInstances = 0;
api.InstanceGroupsListInstances buildInstanceGroupsListInstances() {
  final o = api.InstanceGroupsListInstances();
  buildCounterInstanceGroupsListInstances++;
  if (buildCounterInstanceGroupsListInstances < 3) {
    o.id = 'foo';
    o.items = buildUnnamed257();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInstanceGroupsListInstancesWarning();
  }
  buildCounterInstanceGroupsListInstances--;
  return o;
}

void checkInstanceGroupsListInstances(api.InstanceGroupsListInstances o) {
  buildCounterInstanceGroupsListInstances++;
  if (buildCounterInstanceGroupsListInstances < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed257(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInstanceGroupsListInstancesWarning(o.warning!);
  }
  buildCounterInstanceGroupsListInstances--;
}

core.int buildCounterInstanceGroupsListInstancesRequest = 0;
api.InstanceGroupsListInstancesRequest
    buildInstanceGroupsListInstancesRequest() {
  final o = api.InstanceGroupsListInstancesRequest();
  buildCounterInstanceGroupsListInstancesRequest++;
  if (buildCounterInstanceGroupsListInstancesRequest < 3) {
    o.instanceState = 'foo';
  }
  buildCounterInstanceGroupsListInstancesRequest--;
  return o;
}

void checkInstanceGroupsListInstancesRequest(
    api.InstanceGroupsListInstancesRequest o) {
  buildCounterInstanceGroupsListInstancesRequest++;
  if (buildCounterInstanceGroupsListInstancesRequest < 3) {
    unittest.expect(
      o.instanceState!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupsListInstancesRequest--;
}

core.List<api.InstanceReference> buildUnnamed259() => [
      buildInstanceReference(),
      buildInstanceReference(),
    ];

void checkUnnamed259(core.List<api.InstanceReference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceReference(o[0]);
  checkInstanceReference(o[1]);
}

core.int buildCounterInstanceGroupsRemoveInstancesRequest = 0;
api.InstanceGroupsRemoveInstancesRequest
    buildInstanceGroupsRemoveInstancesRequest() {
  final o = api.InstanceGroupsRemoveInstancesRequest();
  buildCounterInstanceGroupsRemoveInstancesRequest++;
  if (buildCounterInstanceGroupsRemoveInstancesRequest < 3) {
    o.instances = buildUnnamed259();
  }
  buildCounterInstanceGroupsRemoveInstancesRequest--;
  return o;
}

void checkInstanceGroupsRemoveInstancesRequest(
    api.InstanceGroupsRemoveInstancesRequest o) {
  buildCounterInstanceGroupsRemoveInstancesRequest++;
  if (buildCounterInstanceGroupsRemoveInstancesRequest < 3) {
    checkUnnamed259(o.instances!);
  }
  buildCounterInstanceGroupsRemoveInstancesRequest--;
}

core.List<api.InstanceGroup> buildUnnamed260() => [
      buildInstanceGroup(),
      buildInstanceGroup(),
    ];

void checkUnnamed260(core.List<api.InstanceGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroup(o[0]);
  checkInstanceGroup(o[1]);
}

core.int buildCounterInstanceGroupsScopedListWarningData = 0;
api.InstanceGroupsScopedListWarningData
    buildInstanceGroupsScopedListWarningData() {
  final o = api.InstanceGroupsScopedListWarningData();
  buildCounterInstanceGroupsScopedListWarningData++;
  if (buildCounterInstanceGroupsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceGroupsScopedListWarningData--;
  return o;
}

void checkInstanceGroupsScopedListWarningData(
    api.InstanceGroupsScopedListWarningData o) {
  buildCounterInstanceGroupsScopedListWarningData++;
  if (buildCounterInstanceGroupsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupsScopedListWarningData--;
}

core.List<api.InstanceGroupsScopedListWarningData> buildUnnamed261() => [
      buildInstanceGroupsScopedListWarningData(),
      buildInstanceGroupsScopedListWarningData(),
    ];

void checkUnnamed261(core.List<api.InstanceGroupsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupsScopedListWarningData(o[0]);
  checkInstanceGroupsScopedListWarningData(o[1]);
}

core.int buildCounterInstanceGroupsScopedListWarning = 0;
api.InstanceGroupsScopedListWarning buildInstanceGroupsScopedListWarning() {
  final o = api.InstanceGroupsScopedListWarning();
  buildCounterInstanceGroupsScopedListWarning++;
  if (buildCounterInstanceGroupsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed261();
    o.message = 'foo';
  }
  buildCounterInstanceGroupsScopedListWarning--;
  return o;
}

void checkInstanceGroupsScopedListWarning(
    api.InstanceGroupsScopedListWarning o) {
  buildCounterInstanceGroupsScopedListWarning++;
  if (buildCounterInstanceGroupsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed261(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceGroupsScopedListWarning--;
}

core.int buildCounterInstanceGroupsScopedList = 0;
api.InstanceGroupsScopedList buildInstanceGroupsScopedList() {
  final o = api.InstanceGroupsScopedList();
  buildCounterInstanceGroupsScopedList++;
  if (buildCounterInstanceGroupsScopedList < 3) {
    o.instanceGroups = buildUnnamed260();
    o.warning = buildInstanceGroupsScopedListWarning();
  }
  buildCounterInstanceGroupsScopedList--;
  return o;
}

void checkInstanceGroupsScopedList(api.InstanceGroupsScopedList o) {
  buildCounterInstanceGroupsScopedList++;
  if (buildCounterInstanceGroupsScopedList < 3) {
    checkUnnamed260(o.instanceGroups!);
    checkInstanceGroupsScopedListWarning(o.warning!);
  }
  buildCounterInstanceGroupsScopedList--;
}

core.List<api.NamedPort> buildUnnamed262() => [
      buildNamedPort(),
      buildNamedPort(),
    ];

void checkUnnamed262(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.int buildCounterInstanceGroupsSetNamedPortsRequest = 0;
api.InstanceGroupsSetNamedPortsRequest
    buildInstanceGroupsSetNamedPortsRequest() {
  final o = api.InstanceGroupsSetNamedPortsRequest();
  buildCounterInstanceGroupsSetNamedPortsRequest++;
  if (buildCounterInstanceGroupsSetNamedPortsRequest < 3) {
    o.fingerprint = 'foo';
    o.namedPorts = buildUnnamed262();
  }
  buildCounterInstanceGroupsSetNamedPortsRequest--;
  return o;
}

void checkInstanceGroupsSetNamedPortsRequest(
    api.InstanceGroupsSetNamedPortsRequest o) {
  buildCounterInstanceGroupsSetNamedPortsRequest++;
  if (buildCounterInstanceGroupsSetNamedPortsRequest < 3) {
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed262(o.namedPorts!);
  }
  buildCounterInstanceGroupsSetNamedPortsRequest--;
}

core.List<api.Instance> buildUnnamed263() => [
      buildInstance(),
      buildInstance(),
    ];

void checkUnnamed263(core.List<api.Instance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstance(o[0]);
  checkInstance(o[1]);
}

core.int buildCounterInstanceListWarningData = 0;
api.InstanceListWarningData buildInstanceListWarningData() {
  final o = api.InstanceListWarningData();
  buildCounterInstanceListWarningData++;
  if (buildCounterInstanceListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceListWarningData--;
  return o;
}

void checkInstanceListWarningData(api.InstanceListWarningData o) {
  buildCounterInstanceListWarningData++;
  if (buildCounterInstanceListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceListWarningData--;
}

core.List<api.InstanceListWarningData> buildUnnamed264() => [
      buildInstanceListWarningData(),
      buildInstanceListWarningData(),
    ];

void checkUnnamed264(core.List<api.InstanceListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceListWarningData(o[0]);
  checkInstanceListWarningData(o[1]);
}

core.int buildCounterInstanceListWarning = 0;
api.InstanceListWarning buildInstanceListWarning() {
  final o = api.InstanceListWarning();
  buildCounterInstanceListWarning++;
  if (buildCounterInstanceListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed264();
    o.message = 'foo';
  }
  buildCounterInstanceListWarning--;
  return o;
}

void checkInstanceListWarning(api.InstanceListWarning o) {
  buildCounterInstanceListWarning++;
  if (buildCounterInstanceListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed264(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceListWarning--;
}

core.int buildCounterInstanceList = 0;
api.InstanceList buildInstanceList() {
  final o = api.InstanceList();
  buildCounterInstanceList++;
  if (buildCounterInstanceList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed263();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInstanceListWarning();
  }
  buildCounterInstanceList--;
  return o;
}

void checkInstanceList(api.InstanceList o) {
  buildCounterInstanceList++;
  if (buildCounterInstanceList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed263(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInstanceListWarning(o.warning!);
  }
  buildCounterInstanceList--;
}

core.List<api.Reference> buildUnnamed265() => [
      buildReference(),
      buildReference(),
    ];

void checkUnnamed265(core.List<api.Reference> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReference(o[0]);
  checkReference(o[1]);
}

core.int buildCounterInstanceListReferrersWarningData = 0;
api.InstanceListReferrersWarningData buildInstanceListReferrersWarningData() {
  final o = api.InstanceListReferrersWarningData();
  buildCounterInstanceListReferrersWarningData++;
  if (buildCounterInstanceListReferrersWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceListReferrersWarningData--;
  return o;
}

void checkInstanceListReferrersWarningData(
    api.InstanceListReferrersWarningData o) {
  buildCounterInstanceListReferrersWarningData++;
  if (buildCounterInstanceListReferrersWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceListReferrersWarningData--;
}

core.List<api.InstanceListReferrersWarningData> buildUnnamed266() => [
      buildInstanceListReferrersWarningData(),
      buildInstanceListReferrersWarningData(),
    ];

void checkUnnamed266(core.List<api.InstanceListReferrersWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceListReferrersWarningData(o[0]);
  checkInstanceListReferrersWarningData(o[1]);
}

core.int buildCounterInstanceListReferrersWarning = 0;
api.InstanceListReferrersWarning buildInstanceListReferrersWarning() {
  final o = api.InstanceListReferrersWarning();
  buildCounterInstanceListReferrersWarning++;
  if (buildCounterInstanceListReferrersWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed266();
    o.message = 'foo';
  }
  buildCounterInstanceListReferrersWarning--;
  return o;
}

void checkInstanceListReferrersWarning(api.InstanceListReferrersWarning o) {
  buildCounterInstanceListReferrersWarning++;
  if (buildCounterInstanceListReferrersWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed266(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceListReferrersWarning--;
}

core.int buildCounterInstanceListReferrers = 0;
api.InstanceListReferrers buildInstanceListReferrers() {
  final o = api.InstanceListReferrers();
  buildCounterInstanceListReferrers++;
  if (buildCounterInstanceListReferrers < 3) {
    o.id = 'foo';
    o.items = buildUnnamed265();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInstanceListReferrersWarning();
  }
  buildCounterInstanceListReferrers--;
  return o;
}

void checkInstanceListReferrers(api.InstanceListReferrers o) {
  buildCounterInstanceListReferrers++;
  if (buildCounterInstanceListReferrers < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed265(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInstanceListReferrersWarning(o.warning!);
  }
  buildCounterInstanceListReferrers--;
}

core.int buildCounterInstanceManagedByIgmError = 0;
api.InstanceManagedByIgmError buildInstanceManagedByIgmError() {
  final o = api.InstanceManagedByIgmError();
  buildCounterInstanceManagedByIgmError++;
  if (buildCounterInstanceManagedByIgmError < 3) {
    o.error = buildInstanceManagedByIgmErrorManagedInstanceError();
    o.instanceActionDetails =
        buildInstanceManagedByIgmErrorInstanceActionDetails();
    o.timestamp = 'foo';
  }
  buildCounterInstanceManagedByIgmError--;
  return o;
}

void checkInstanceManagedByIgmError(api.InstanceManagedByIgmError o) {
  buildCounterInstanceManagedByIgmError++;
  if (buildCounterInstanceManagedByIgmError < 3) {
    checkInstanceManagedByIgmErrorManagedInstanceError(o.error!);
    checkInstanceManagedByIgmErrorInstanceActionDetails(
        o.instanceActionDetails!);
    unittest.expect(
      o.timestamp!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceManagedByIgmError--;
}

core.int buildCounterInstanceManagedByIgmErrorInstanceActionDetails = 0;
api.InstanceManagedByIgmErrorInstanceActionDetails
    buildInstanceManagedByIgmErrorInstanceActionDetails() {
  final o = api.InstanceManagedByIgmErrorInstanceActionDetails();
  buildCounterInstanceManagedByIgmErrorInstanceActionDetails++;
  if (buildCounterInstanceManagedByIgmErrorInstanceActionDetails < 3) {
    o.action = 'foo';
    o.instance = 'foo';
    o.version = buildManagedInstanceVersion();
  }
  buildCounterInstanceManagedByIgmErrorInstanceActionDetails--;
  return o;
}

void checkInstanceManagedByIgmErrorInstanceActionDetails(
    api.InstanceManagedByIgmErrorInstanceActionDetails o) {
  buildCounterInstanceManagedByIgmErrorInstanceActionDetails++;
  if (buildCounterInstanceManagedByIgmErrorInstanceActionDetails < 3) {
    unittest.expect(
      o.action!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.instance!,
      unittest.equals('foo'),
    );
    checkManagedInstanceVersion(o.version!);
  }
  buildCounterInstanceManagedByIgmErrorInstanceActionDetails--;
}

core.int buildCounterInstanceManagedByIgmErrorManagedInstanceError = 0;
api.InstanceManagedByIgmErrorManagedInstanceError
    buildInstanceManagedByIgmErrorManagedInstanceError() {
  final o = api.InstanceManagedByIgmErrorManagedInstanceError();
  buildCounterInstanceManagedByIgmErrorManagedInstanceError++;
  if (buildCounterInstanceManagedByIgmErrorManagedInstanceError < 3) {
    o.code = 'foo';
    o.message = 'foo';
  }
  buildCounterInstanceManagedByIgmErrorManagedInstanceError--;
  return o;
}

void checkInstanceManagedByIgmErrorManagedInstanceError(
    api.InstanceManagedByIgmErrorManagedInstanceError o) {
  buildCounterInstanceManagedByIgmErrorManagedInstanceError++;
  if (buildCounterInstanceManagedByIgmErrorManagedInstanceError < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceManagedByIgmErrorManagedInstanceError--;
}

core.int buildCounterInstanceMoveRequest = 0;
api.InstanceMoveRequest buildInstanceMoveRequest() {
  final o = api.InstanceMoveRequest();
  buildCounterInstanceMoveRequest++;
  if (buildCounterInstanceMoveRequest < 3) {
    o.destinationZone = 'foo';
    o.targetInstance = 'foo';
  }
  buildCounterInstanceMoveRequest--;
  return o;
}

void checkInstanceMoveRequest(api.InstanceMoveRequest o) {
  buildCounterInstanceMoveRequest++;
  if (buildCounterInstanceMoveRequest < 3) {
    unittest.expect(
      o.destinationZone!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.targetInstance!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceMoveRequest--;
}

core.Map<core.String, core.String> buildUnnamed267() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed267(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterInstanceParams = 0;
api.InstanceParams buildInstanceParams() {
  final o = api.InstanceParams();
  buildCounterInstanceParams++;
  if (buildCounterInstanceParams < 3) {
    o.resourceManagerTags = buildUnnamed267();
  }
  buildCounterInstanceParams--;
  return o;
}

void checkInstanceParams(api.InstanceParams o) {
  buildCounterInstanceParams++;
  if (buildCounterInstanceParams < 3) {
    checkUnnamed267(o.resourceManagerTags!);
  }
  buildCounterInstanceParams--;
}

core.List<api.AttachedDisk> buildUnnamed268() => [
      buildAttachedDisk(),
      buildAttachedDisk(),
    ];

void checkUnnamed268(core.List<api.AttachedDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAttachedDisk(o[0]);
  checkAttachedDisk(o[1]);
}

core.List<api.AcceleratorConfig> buildUnnamed269() => [
      buildAcceleratorConfig(),
      buildAcceleratorConfig(),
    ];

void checkUnnamed269(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

core.Map<core.String, core.String> buildUnnamed270() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed270(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<api.NetworkInterface> buildUnnamed271() => [
      buildNetworkInterface(),
      buildNetworkInterface(),
    ];

void checkUnnamed271(core.List<api.NetworkInterface> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkInterface(o[0]);
  checkNetworkInterface(o[1]);
}

core.Map<core.String, core.String> buildUnnamed272() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed272(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed273() => [
      'foo',
      'foo',
    ];

void checkUnnamed273(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.ServiceAccount> buildUnnamed274() => [
      buildServiceAccount(),
      buildServiceAccount(),
    ];

void checkUnnamed274(core.List<api.ServiceAccount> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAccount(o[0]);
  checkServiceAccount(o[1]);
}

core.int buildCounterInstanceProperties = 0;
api.InstanceProperties buildInstanceProperties() {
  final o = api.InstanceProperties();
  buildCounterInstanceProperties++;
  if (buildCounterInstanceProperties < 3) {
    o.advancedMachineFeatures = buildAdvancedMachineFeatures();
    o.canIpForward = true;
    o.confidentialInstanceConfig = buildConfidentialInstanceConfig();
    o.description = 'foo';
    o.disks = buildUnnamed268();
    o.guestAccelerators = buildUnnamed269();
    o.keyRevocationActionType = 'foo';
    o.labels = buildUnnamed270();
    o.machineType = 'foo';
    o.metadata = buildMetadata();
    o.minCpuPlatform = 'foo';
    o.networkInterfaces = buildUnnamed271();
    o.networkPerformanceConfig = buildNetworkPerformanceConfig();
    o.privateIpv6GoogleAccess = 'foo';
    o.reservationAffinity = buildReservationAffinity();
    o.resourceManagerTags = buildUnnamed272();
    o.resourcePolicies = buildUnnamed273();
    o.scheduling = buildScheduling();
    o.serviceAccounts = buildUnnamed274();
    o.shieldedInstanceConfig = buildShieldedInstanceConfig();
    o.tags = buildTags();
  }
  buildCounterInstanceProperties--;
  return o;
}

void checkInstanceProperties(api.InstanceProperties o) {
  buildCounterInstanceProperties++;
  if (buildCounterInstanceProperties < 3) {
    checkAdvancedMachineFeatures(o.advancedMachineFeatures!);
    unittest.expect(o.canIpForward!, unittest.isTrue);
    checkConfidentialInstanceConfig(o.confidentialInstanceConfig!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed268(o.disks!);
    checkUnnamed269(o.guestAccelerators!);
    unittest.expect(
      o.keyRevocationActionType!,
      unittest.equals('foo'),
    );
    checkUnnamed270(o.labels!);
    unittest.expect(
      o.machineType!,
      unittest.equals('foo'),
    );
    checkMetadata(o.metadata!);
    unittest.expect(
      o.minCpuPlatform!,
      unittest.equals('foo'),
    );
    checkUnnamed271(o.networkInterfaces!);
    checkNetworkPerformanceConfig(o.networkPerformanceConfig!);
    unittest.expect(
      o.privateIpv6GoogleAccess!,
      unittest.equals('foo'),
    );
    checkReservationAffinity(o.reservationAffinity!);
    checkUnnamed272(o.resourceManagerTags!);
    checkUnnamed273(o.resourcePolicies!);
    checkScheduling(o.scheduling!);
    checkUnnamed274(o.serviceAccounts!);
    checkShieldedInstanceConfig(o.shieldedInstanceConfig!);
    checkTags(o.tags!);
  }
  buildCounterInstanceProperties--;
}

core.int buildCounterInstanceReference = 0;
api.InstanceReference buildInstanceReference() {
  final o = api.InstanceReference();
  buildCounterInstanceReference++;
  if (buildCounterInstanceReference < 3) {
    o.instance = 'foo';
  }
  buildCounterInstanceReference--;
  return o;
}

void checkInstanceReference(api.InstanceReference o) {
  buildCounterInstanceReference++;
  if (buildCounterInstanceReference < 3) {
    unittest.expect(
      o.instance!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceReference--;
}

core.int buildCounterInstanceTemplate = 0;
api.InstanceTemplate buildInstanceTemplate() {
  final o = api.InstanceTemplate();
  buildCounterInstanceTemplate++;
  if (buildCounterInstanceTemplate < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.properties = buildInstanceProperties();
    o.region = 'foo';
    o.selfLink = 'foo';
    o.sourceInstance = 'foo';
    o.sourceInstanceParams = buildSourceInstanceParams();
  }
  buildCounterInstanceTemplate--;
  return o;
}

void checkInstanceTemplate(api.InstanceTemplate o) {
  buildCounterInstanceTemplate++;
  if (buildCounterInstanceTemplate < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkInstanceProperties(o.properties!);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceInstance!,
      unittest.equals('foo'),
    );
    checkSourceInstanceParams(o.sourceInstanceParams!);
  }
  buildCounterInstanceTemplate--;
}

core.Map<core.String, api.InstanceTemplatesScopedList> buildUnnamed275() => {
      'x': buildInstanceTemplatesScopedList(),
      'y': buildInstanceTemplatesScopedList(),
    };

void checkUnnamed275(core.Map<core.String, api.InstanceTemplatesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceTemplatesScopedList(o['x']!);
  checkInstanceTemplatesScopedList(o['y']!);
}

core.int buildCounterInstanceTemplateAggregatedListWarningData = 0;
api.InstanceTemplateAggregatedListWarningData
    buildInstanceTemplateAggregatedListWarningData() {
  final o = api.InstanceTemplateAggregatedListWarningData();
  buildCounterInstanceTemplateAggregatedListWarningData++;
  if (buildCounterInstanceTemplateAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceTemplateAggregatedListWarningData--;
  return o;
}

void checkInstanceTemplateAggregatedListWarningData(
    api.InstanceTemplateAggregatedListWarningData o) {
  buildCounterInstanceTemplateAggregatedListWarningData++;
  if (buildCounterInstanceTemplateAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceTemplateAggregatedListWarningData--;
}

core.List<api.InstanceTemplateAggregatedListWarningData> buildUnnamed276() => [
      buildInstanceTemplateAggregatedListWarningData(),
      buildInstanceTemplateAggregatedListWarningData(),
    ];

void checkUnnamed276(
    core.List<api.InstanceTemplateAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceTemplateAggregatedListWarningData(o[0]);
  checkInstanceTemplateAggregatedListWarningData(o[1]);
}

core.int buildCounterInstanceTemplateAggregatedListWarning = 0;
api.InstanceTemplateAggregatedListWarning
    buildInstanceTemplateAggregatedListWarning() {
  final o = api.InstanceTemplateAggregatedListWarning();
  buildCounterInstanceTemplateAggregatedListWarning++;
  if (buildCounterInstanceTemplateAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed276();
    o.message = 'foo';
  }
  buildCounterInstanceTemplateAggregatedListWarning--;
  return o;
}

void checkInstanceTemplateAggregatedListWarning(
    api.InstanceTemplateAggregatedListWarning o) {
  buildCounterInstanceTemplateAggregatedListWarning++;
  if (buildCounterInstanceTemplateAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed276(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceTemplateAggregatedListWarning--;
}

core.int buildCounterInstanceTemplateAggregatedList = 0;
api.InstanceTemplateAggregatedList buildInstanceTemplateAggregatedList() {
  final o = api.InstanceTemplateAggregatedList();
  buildCounterInstanceTemplateAggregatedList++;
  if (buildCounterInstanceTemplateAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed275();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInstanceTemplateAggregatedListWarning();
  }
  buildCounterInstanceTemplateAggregatedList--;
  return o;
}

void checkInstanceTemplateAggregatedList(api.InstanceTemplateAggregatedList o) {
  buildCounterInstanceTemplateAggregatedList++;
  if (buildCounterInstanceTemplateAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed275(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInstanceTemplateAggregatedListWarning(o.warning!);
  }
  buildCounterInstanceTemplateAggregatedList--;
}

core.List<api.InstanceTemplate> buildUnnamed277() => [
      buildInstanceTemplate(),
      buildInstanceTemplate(),
    ];

void checkUnnamed277(core.List<api.InstanceTemplate> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceTemplate(o[0]);
  checkInstanceTemplate(o[1]);
}

core.int buildCounterInstanceTemplateListWarningData = 0;
api.InstanceTemplateListWarningData buildInstanceTemplateListWarningData() {
  final o = api.InstanceTemplateListWarningData();
  buildCounterInstanceTemplateListWarningData++;
  if (buildCounterInstanceTemplateListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceTemplateListWarningData--;
  return o;
}

void checkInstanceTemplateListWarningData(
    api.InstanceTemplateListWarningData o) {
  buildCounterInstanceTemplateListWarningData++;
  if (buildCounterInstanceTemplateListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceTemplateListWarningData--;
}

core.List<api.InstanceTemplateListWarningData> buildUnnamed278() => [
      buildInstanceTemplateListWarningData(),
      buildInstanceTemplateListWarningData(),
    ];

void checkUnnamed278(core.List<api.InstanceTemplateListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceTemplateListWarningData(o[0]);
  checkInstanceTemplateListWarningData(o[1]);
}

core.int buildCounterInstanceTemplateListWarning = 0;
api.InstanceTemplateListWarning buildInstanceTemplateListWarning() {
  final o = api.InstanceTemplateListWarning();
  buildCounterInstanceTemplateListWarning++;
  if (buildCounterInstanceTemplateListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed278();
    o.message = 'foo';
  }
  buildCounterInstanceTemplateListWarning--;
  return o;
}

void checkInstanceTemplateListWarning(api.InstanceTemplateListWarning o) {
  buildCounterInstanceTemplateListWarning++;
  if (buildCounterInstanceTemplateListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed278(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceTemplateListWarning--;
}

core.int buildCounterInstanceTemplateList = 0;
api.InstanceTemplateList buildInstanceTemplateList() {
  final o = api.InstanceTemplateList();
  buildCounterInstanceTemplateList++;
  if (buildCounterInstanceTemplateList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed277();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInstanceTemplateListWarning();
  }
  buildCounterInstanceTemplateList--;
  return o;
}

void checkInstanceTemplateList(api.InstanceTemplateList o) {
  buildCounterInstanceTemplateList++;
  if (buildCounterInstanceTemplateList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed277(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInstanceTemplateListWarning(o.warning!);
  }
  buildCounterInstanceTemplateList--;
}

core.List<api.InstanceTemplate> buildUnnamed279() => [
      buildInstanceTemplate(),
      buildInstanceTemplate(),
    ];

void checkUnnamed279(core.List<api.InstanceTemplate> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceTemplate(o[0]);
  checkInstanceTemplate(o[1]);
}

core.int buildCounterInstanceTemplatesScopedListWarningData = 0;
api.InstanceTemplatesScopedListWarningData
    buildInstanceTemplatesScopedListWarningData() {
  final o = api.InstanceTemplatesScopedListWarningData();
  buildCounterInstanceTemplatesScopedListWarningData++;
  if (buildCounterInstanceTemplatesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstanceTemplatesScopedListWarningData--;
  return o;
}

void checkInstanceTemplatesScopedListWarningData(
    api.InstanceTemplatesScopedListWarningData o) {
  buildCounterInstanceTemplatesScopedListWarningData++;
  if (buildCounterInstanceTemplatesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceTemplatesScopedListWarningData--;
}

core.List<api.InstanceTemplatesScopedListWarningData> buildUnnamed280() => [
      buildInstanceTemplatesScopedListWarningData(),
      buildInstanceTemplatesScopedListWarningData(),
    ];

void checkUnnamed280(core.List<api.InstanceTemplatesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceTemplatesScopedListWarningData(o[0]);
  checkInstanceTemplatesScopedListWarningData(o[1]);
}

core.int buildCounterInstanceTemplatesScopedListWarning = 0;
api.InstanceTemplatesScopedListWarning
    buildInstanceTemplatesScopedListWarning() {
  final o = api.InstanceTemplatesScopedListWarning();
  buildCounterInstanceTemplatesScopedListWarning++;
  if (buildCounterInstanceTemplatesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed280();
    o.message = 'foo';
  }
  buildCounterInstanceTemplatesScopedListWarning--;
  return o;
}

void checkInstanceTemplatesScopedListWarning(
    api.InstanceTemplatesScopedListWarning o) {
  buildCounterInstanceTemplatesScopedListWarning++;
  if (buildCounterInstanceTemplatesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed280(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceTemplatesScopedListWarning--;
}

core.int buildCounterInstanceTemplatesScopedList = 0;
api.InstanceTemplatesScopedList buildInstanceTemplatesScopedList() {
  final o = api.InstanceTemplatesScopedList();
  buildCounterInstanceTemplatesScopedList++;
  if (buildCounterInstanceTemplatesScopedList < 3) {
    o.instanceTemplates = buildUnnamed279();
    o.warning = buildInstanceTemplatesScopedListWarning();
  }
  buildCounterInstanceTemplatesScopedList--;
  return o;
}

void checkInstanceTemplatesScopedList(api.InstanceTemplatesScopedList o) {
  buildCounterInstanceTemplatesScopedList++;
  if (buildCounterInstanceTemplatesScopedList < 3) {
    checkUnnamed279(o.instanceTemplates!);
    checkInstanceTemplatesScopedListWarning(o.warning!);
  }
  buildCounterInstanceTemplatesScopedList--;
}

core.List<api.NamedPort> buildUnnamed281() => [
      buildNamedPort(),
      buildNamedPort(),
    ];

void checkUnnamed281(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.int buildCounterInstanceWithNamedPorts = 0;
api.InstanceWithNamedPorts buildInstanceWithNamedPorts() {
  final o = api.InstanceWithNamedPorts();
  buildCounterInstanceWithNamedPorts++;
  if (buildCounterInstanceWithNamedPorts < 3) {
    o.instance = 'foo';
    o.namedPorts = buildUnnamed281();
    o.status = 'foo';
  }
  buildCounterInstanceWithNamedPorts--;
  return o;
}

void checkInstanceWithNamedPorts(api.InstanceWithNamedPorts o) {
  buildCounterInstanceWithNamedPorts++;
  if (buildCounterInstanceWithNamedPorts < 3) {
    unittest.expect(
      o.instance!,
      unittest.equals('foo'),
    );
    checkUnnamed281(o.namedPorts!);
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstanceWithNamedPorts--;
}

core.List<core.String> buildUnnamed282() => [
      'foo',
      'foo',
    ];

void checkUnnamed282(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstancesAddResourcePoliciesRequest = 0;
api.InstancesAddResourcePoliciesRequest
    buildInstancesAddResourcePoliciesRequest() {
  final o = api.InstancesAddResourcePoliciesRequest();
  buildCounterInstancesAddResourcePoliciesRequest++;
  if (buildCounterInstancesAddResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed282();
  }
  buildCounterInstancesAddResourcePoliciesRequest--;
  return o;
}

void checkInstancesAddResourcePoliciesRequest(
    api.InstancesAddResourcePoliciesRequest o) {
  buildCounterInstancesAddResourcePoliciesRequest++;
  if (buildCounterInstancesAddResourcePoliciesRequest < 3) {
    checkUnnamed282(o.resourcePolicies!);
  }
  buildCounterInstancesAddResourcePoliciesRequest--;
}

core.Map<core.String, api.BulkInsertOperationStatus> buildUnnamed283() => {
      'x': buildBulkInsertOperationStatus(),
      'y': buildBulkInsertOperationStatus(),
    };

void checkUnnamed283(core.Map<core.String, api.BulkInsertOperationStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBulkInsertOperationStatus(o['x']!);
  checkBulkInsertOperationStatus(o['y']!);
}

core.int buildCounterInstancesBulkInsertOperationMetadata = 0;
api.InstancesBulkInsertOperationMetadata
    buildInstancesBulkInsertOperationMetadata() {
  final o = api.InstancesBulkInsertOperationMetadata();
  buildCounterInstancesBulkInsertOperationMetadata++;
  if (buildCounterInstancesBulkInsertOperationMetadata < 3) {
    o.perLocationStatus = buildUnnamed283();
  }
  buildCounterInstancesBulkInsertOperationMetadata--;
  return o;
}

void checkInstancesBulkInsertOperationMetadata(
    api.InstancesBulkInsertOperationMetadata o) {
  buildCounterInstancesBulkInsertOperationMetadata++;
  if (buildCounterInstancesBulkInsertOperationMetadata < 3) {
    checkUnnamed283(o.perLocationStatus!);
  }
  buildCounterInstancesBulkInsertOperationMetadata--;
}

core.List<api.InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy>
    buildUnnamed284() => [
          buildInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(),
          buildInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(),
        ];

void checkUnnamed284(
    core.List<api.InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(o[0]);
  checkInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(o[1]);
}

core.List<api.Firewall> buildUnnamed285() => [
      buildFirewall(),
      buildFirewall(),
    ];

void checkUnnamed285(core.List<api.Firewall> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewall(o[0]);
  checkFirewall(o[1]);
}

core.int buildCounterInstancesGetEffectiveFirewallsResponse = 0;
api.InstancesGetEffectiveFirewallsResponse
    buildInstancesGetEffectiveFirewallsResponse() {
  final o = api.InstancesGetEffectiveFirewallsResponse();
  buildCounterInstancesGetEffectiveFirewallsResponse++;
  if (buildCounterInstancesGetEffectiveFirewallsResponse < 3) {
    o.firewallPolicys = buildUnnamed284();
    o.firewalls = buildUnnamed285();
  }
  buildCounterInstancesGetEffectiveFirewallsResponse--;
  return o;
}

void checkInstancesGetEffectiveFirewallsResponse(
    api.InstancesGetEffectiveFirewallsResponse o) {
  buildCounterInstancesGetEffectiveFirewallsResponse++;
  if (buildCounterInstancesGetEffectiveFirewallsResponse < 3) {
    checkUnnamed284(o.firewallPolicys!);
    checkUnnamed285(o.firewalls!);
  }
  buildCounterInstancesGetEffectiveFirewallsResponse--;
}

core.List<api.FirewallPolicyRule> buildUnnamed286() => [
      buildFirewallPolicyRule(),
      buildFirewallPolicyRule(),
    ];

void checkUnnamed286(core.List<api.FirewallPolicyRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyRule(o[0]);
  checkFirewallPolicyRule(o[1]);
}

core.int
    buildCounterInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy =
    0;
api.InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy
    buildInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy() {
  final o = api.InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy();
  buildCounterInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy++;
  if (buildCounterInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy <
      3) {
    o.displayName = 'foo';
    o.name = 'foo';
    o.rules = buildUnnamed286();
    o.shortName = 'foo';
    o.type = 'foo';
  }
  buildCounterInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy--;
  return o;
}

void checkInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(
    api.InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy o) {
  buildCounterInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy++;
  if (buildCounterInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy <
      3) {
    unittest.expect(
      o.displayName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed286(o.rules!);
    unittest.expect(
      o.shortName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy--;
}

core.List<core.String> buildUnnamed287() => [
      'foo',
      'foo',
    ];

void checkUnnamed287(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstancesRemoveResourcePoliciesRequest = 0;
api.InstancesRemoveResourcePoliciesRequest
    buildInstancesRemoveResourcePoliciesRequest() {
  final o = api.InstancesRemoveResourcePoliciesRequest();
  buildCounterInstancesRemoveResourcePoliciesRequest++;
  if (buildCounterInstancesRemoveResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed287();
  }
  buildCounterInstancesRemoveResourcePoliciesRequest--;
  return o;
}

void checkInstancesRemoveResourcePoliciesRequest(
    api.InstancesRemoveResourcePoliciesRequest o) {
  buildCounterInstancesRemoveResourcePoliciesRequest++;
  if (buildCounterInstancesRemoveResourcePoliciesRequest < 3) {
    checkUnnamed287(o.resourcePolicies!);
  }
  buildCounterInstancesRemoveResourcePoliciesRequest--;
}

core.List<api.Instance> buildUnnamed288() => [
      buildInstance(),
      buildInstance(),
    ];

void checkUnnamed288(core.List<api.Instance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstance(o[0]);
  checkInstance(o[1]);
}

core.int buildCounterInstancesScopedListWarningData = 0;
api.InstancesScopedListWarningData buildInstancesScopedListWarningData() {
  final o = api.InstancesScopedListWarningData();
  buildCounterInstancesScopedListWarningData++;
  if (buildCounterInstancesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInstancesScopedListWarningData--;
  return o;
}

void checkInstancesScopedListWarningData(api.InstancesScopedListWarningData o) {
  buildCounterInstancesScopedListWarningData++;
  if (buildCounterInstancesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstancesScopedListWarningData--;
}

core.List<api.InstancesScopedListWarningData> buildUnnamed289() => [
      buildInstancesScopedListWarningData(),
      buildInstancesScopedListWarningData(),
    ];

void checkUnnamed289(core.List<api.InstancesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstancesScopedListWarningData(o[0]);
  checkInstancesScopedListWarningData(o[1]);
}

core.int buildCounterInstancesScopedListWarning = 0;
api.InstancesScopedListWarning buildInstancesScopedListWarning() {
  final o = api.InstancesScopedListWarning();
  buildCounterInstancesScopedListWarning++;
  if (buildCounterInstancesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed289();
    o.message = 'foo';
  }
  buildCounterInstancesScopedListWarning--;
  return o;
}

void checkInstancesScopedListWarning(api.InstancesScopedListWarning o) {
  buildCounterInstancesScopedListWarning++;
  if (buildCounterInstancesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed289(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstancesScopedListWarning--;
}

core.int buildCounterInstancesScopedList = 0;
api.InstancesScopedList buildInstancesScopedList() {
  final o = api.InstancesScopedList();
  buildCounterInstancesScopedList++;
  if (buildCounterInstancesScopedList < 3) {
    o.instances = buildUnnamed288();
    o.warning = buildInstancesScopedListWarning();
  }
  buildCounterInstancesScopedList--;
  return o;
}

void checkInstancesScopedList(api.InstancesScopedList o) {
  buildCounterInstancesScopedList++;
  if (buildCounterInstancesScopedList < 3) {
    checkUnnamed288(o.instances!);
    checkInstancesScopedListWarning(o.warning!);
  }
  buildCounterInstancesScopedList--;
}

core.Map<core.String, core.String> buildUnnamed290() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed290(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterInstancesSetLabelsRequest = 0;
api.InstancesSetLabelsRequest buildInstancesSetLabelsRequest() {
  final o = api.InstancesSetLabelsRequest();
  buildCounterInstancesSetLabelsRequest++;
  if (buildCounterInstancesSetLabelsRequest < 3) {
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed290();
  }
  buildCounterInstancesSetLabelsRequest--;
  return o;
}

void checkInstancesSetLabelsRequest(api.InstancesSetLabelsRequest o) {
  buildCounterInstancesSetLabelsRequest++;
  if (buildCounterInstancesSetLabelsRequest < 3) {
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed290(o.labels!);
  }
  buildCounterInstancesSetLabelsRequest--;
}

core.List<api.AcceleratorConfig> buildUnnamed291() => [
      buildAcceleratorConfig(),
      buildAcceleratorConfig(),
    ];

void checkUnnamed291(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

core.int buildCounterInstancesSetMachineResourcesRequest = 0;
api.InstancesSetMachineResourcesRequest
    buildInstancesSetMachineResourcesRequest() {
  final o = api.InstancesSetMachineResourcesRequest();
  buildCounterInstancesSetMachineResourcesRequest++;
  if (buildCounterInstancesSetMachineResourcesRequest < 3) {
    o.guestAccelerators = buildUnnamed291();
  }
  buildCounterInstancesSetMachineResourcesRequest--;
  return o;
}

void checkInstancesSetMachineResourcesRequest(
    api.InstancesSetMachineResourcesRequest o) {
  buildCounterInstancesSetMachineResourcesRequest++;
  if (buildCounterInstancesSetMachineResourcesRequest < 3) {
    checkUnnamed291(o.guestAccelerators!);
  }
  buildCounterInstancesSetMachineResourcesRequest--;
}

core.int buildCounterInstancesSetMachineTypeRequest = 0;
api.InstancesSetMachineTypeRequest buildInstancesSetMachineTypeRequest() {
  final o = api.InstancesSetMachineTypeRequest();
  buildCounterInstancesSetMachineTypeRequest++;
  if (buildCounterInstancesSetMachineTypeRequest < 3) {
    o.machineType = 'foo';
  }
  buildCounterInstancesSetMachineTypeRequest--;
  return o;
}

void checkInstancesSetMachineTypeRequest(api.InstancesSetMachineTypeRequest o) {
  buildCounterInstancesSetMachineTypeRequest++;
  if (buildCounterInstancesSetMachineTypeRequest < 3) {
    unittest.expect(
      o.machineType!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstancesSetMachineTypeRequest--;
}

core.int buildCounterInstancesSetMinCpuPlatformRequest = 0;
api.InstancesSetMinCpuPlatformRequest buildInstancesSetMinCpuPlatformRequest() {
  final o = api.InstancesSetMinCpuPlatformRequest();
  buildCounterInstancesSetMinCpuPlatformRequest++;
  if (buildCounterInstancesSetMinCpuPlatformRequest < 3) {
    o.minCpuPlatform = 'foo';
  }
  buildCounterInstancesSetMinCpuPlatformRequest--;
  return o;
}

void checkInstancesSetMinCpuPlatformRequest(
    api.InstancesSetMinCpuPlatformRequest o) {
  buildCounterInstancesSetMinCpuPlatformRequest++;
  if (buildCounterInstancesSetMinCpuPlatformRequest < 3) {
    unittest.expect(
      o.minCpuPlatform!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstancesSetMinCpuPlatformRequest--;
}

core.int buildCounterInstancesSetNameRequest = 0;
api.InstancesSetNameRequest buildInstancesSetNameRequest() {
  final o = api.InstancesSetNameRequest();
  buildCounterInstancesSetNameRequest++;
  if (buildCounterInstancesSetNameRequest < 3) {
    o.currentName = 'foo';
    o.name = 'foo';
  }
  buildCounterInstancesSetNameRequest--;
  return o;
}

void checkInstancesSetNameRequest(api.InstancesSetNameRequest o) {
  buildCounterInstancesSetNameRequest++;
  if (buildCounterInstancesSetNameRequest < 3) {
    unittest.expect(
      o.currentName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstancesSetNameRequest--;
}

core.List<core.String> buildUnnamed292() => [
      'foo',
      'foo',
    ];

void checkUnnamed292(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstancesSetSecurityPolicyRequest = 0;
api.InstancesSetSecurityPolicyRequest buildInstancesSetSecurityPolicyRequest() {
  final o = api.InstancesSetSecurityPolicyRequest();
  buildCounterInstancesSetSecurityPolicyRequest++;
  if (buildCounterInstancesSetSecurityPolicyRequest < 3) {
    o.networkInterfaces = buildUnnamed292();
    o.securityPolicy = 'foo';
  }
  buildCounterInstancesSetSecurityPolicyRequest--;
  return o;
}

void checkInstancesSetSecurityPolicyRequest(
    api.InstancesSetSecurityPolicyRequest o) {
  buildCounterInstancesSetSecurityPolicyRequest++;
  if (buildCounterInstancesSetSecurityPolicyRequest < 3) {
    checkUnnamed292(o.networkInterfaces!);
    unittest.expect(
      o.securityPolicy!,
      unittest.equals('foo'),
    );
  }
  buildCounterInstancesSetSecurityPolicyRequest--;
}

core.List<core.String> buildUnnamed293() => [
      'foo',
      'foo',
    ];

void checkUnnamed293(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInstancesSetServiceAccountRequest = 0;
api.InstancesSetServiceAccountRequest buildInstancesSetServiceAccountRequest() {
  final o = api.InstancesSetServiceAccountRequest();
  buildCounterInstancesSetServiceAccountRequest++;
  if (buildCounterInstancesSetServiceAccountRequest < 3) {
    o.email = 'foo';
    o.scopes = buildUnnamed293();
  }
  buildCounterInstancesSetServiceAccountRequest--;
  return o;
}

void checkInstancesSetServiceAccountRequest(
    api.InstancesSetServiceAccountRequest o) {
  buildCounterInstancesSetServiceAccountRequest++;
  if (buildCounterInstancesSetServiceAccountRequest < 3) {
    unittest.expect(
      o.email!,
      unittest.equals('foo'),
    );
    checkUnnamed293(o.scopes!);
  }
  buildCounterInstancesSetServiceAccountRequest--;
}

core.List<api.CustomerEncryptionKeyProtectedDisk> buildUnnamed294() => [
      buildCustomerEncryptionKeyProtectedDisk(),
      buildCustomerEncryptionKeyProtectedDisk(),
    ];

void checkUnnamed294(core.List<api.CustomerEncryptionKeyProtectedDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCustomerEncryptionKeyProtectedDisk(o[0]);
  checkCustomerEncryptionKeyProtectedDisk(o[1]);
}

core.int buildCounterInstancesStartWithEncryptionKeyRequest = 0;
api.InstancesStartWithEncryptionKeyRequest
    buildInstancesStartWithEncryptionKeyRequest() {
  final o = api.InstancesStartWithEncryptionKeyRequest();
  buildCounterInstancesStartWithEncryptionKeyRequest++;
  if (buildCounterInstancesStartWithEncryptionKeyRequest < 3) {
    o.disks = buildUnnamed294();
  }
  buildCounterInstancesStartWithEncryptionKeyRequest--;
  return o;
}

void checkInstancesStartWithEncryptionKeyRequest(
    api.InstancesStartWithEncryptionKeyRequest o) {
  buildCounterInstancesStartWithEncryptionKeyRequest++;
  if (buildCounterInstancesStartWithEncryptionKeyRequest < 3) {
    checkUnnamed294(o.disks!);
  }
  buildCounterInstancesStartWithEncryptionKeyRequest--;
}

core.int buildCounterInt64RangeMatch = 0;
api.Int64RangeMatch buildInt64RangeMatch() {
  final o = api.Int64RangeMatch();
  buildCounterInt64RangeMatch++;
  if (buildCounterInt64RangeMatch < 3) {
    o.rangeEnd = 'foo';
    o.rangeStart = 'foo';
  }
  buildCounterInt64RangeMatch--;
  return o;
}

void checkInt64RangeMatch(api.Int64RangeMatch o) {
  buildCounterInt64RangeMatch++;
  if (buildCounterInt64RangeMatch < 3) {
    unittest.expect(
      o.rangeEnd!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.rangeStart!,
      unittest.equals('foo'),
    );
  }
  buildCounterInt64RangeMatch--;
}

core.List<core.String> buildUnnamed295() => [
      'foo',
      'foo',
    ];

void checkUnnamed295(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.InterconnectCircuitInfo> buildUnnamed296() => [
      buildInterconnectCircuitInfo(),
      buildInterconnectCircuitInfo(),
    ];

void checkUnnamed296(core.List<api.InterconnectCircuitInfo> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectCircuitInfo(o[0]);
  checkInterconnectCircuitInfo(o[1]);
}

core.List<api.InterconnectOutageNotification> buildUnnamed297() => [
      buildInterconnectOutageNotification(),
      buildInterconnectOutageNotification(),
    ];

void checkUnnamed297(core.List<api.InterconnectOutageNotification> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectOutageNotification(o[0]);
  checkInterconnectOutageNotification(o[1]);
}

core.List<core.String> buildUnnamed298() => [
      'foo',
      'foo',
    ];

void checkUnnamed298(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.Map<core.String, core.String> buildUnnamed299() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed299(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed300() => [
      'foo',
      'foo',
    ];

void checkUnnamed300(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInterconnect = 0;
api.Interconnect buildInterconnect() {
  final o = api.Interconnect();
  buildCounterInterconnect++;
  if (buildCounterInterconnect < 3) {
    o.adminEnabled = true;
    o.availableFeatures = buildUnnamed295();
    o.circuitInfos = buildUnnamed296();
    o.creationTimestamp = 'foo';
    o.customerName = 'foo';
    o.description = 'foo';
    o.expectedOutages = buildUnnamed297();
    o.googleIpAddress = 'foo';
    o.googleReferenceId = 'foo';
    o.id = 'foo';
    o.interconnectAttachments = buildUnnamed298();
    o.interconnectType = 'foo';
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed299();
    o.linkType = 'foo';
    o.location = 'foo';
    o.macsec = buildInterconnectMacsec();
    o.macsecEnabled = true;
    o.name = 'foo';
    o.nocContactEmail = 'foo';
    o.operationalStatus = 'foo';
    o.peerIpAddress = 'foo';
    o.provisionedLinkCount = 42;
    o.remoteLocation = 'foo';
    o.requestedFeatures = buildUnnamed300();
    o.requestedLinkCount = 42;
    o.satisfiesPzs = true;
    o.selfLink = 'foo';
    o.state = 'foo';
  }
  buildCounterInterconnect--;
  return o;
}

void checkInterconnect(api.Interconnect o) {
  buildCounterInterconnect++;
  if (buildCounterInterconnect < 3) {
    unittest.expect(o.adminEnabled!, unittest.isTrue);
    checkUnnamed295(o.availableFeatures!);
    checkUnnamed296(o.circuitInfos!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.customerName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed297(o.expectedOutages!);
    unittest.expect(
      o.googleIpAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.googleReferenceId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed298(o.interconnectAttachments!);
    unittest.expect(
      o.interconnectType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed299(o.labels!);
    unittest.expect(
      o.linkType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.location!,
      unittest.equals('foo'),
    );
    checkInterconnectMacsec(o.macsec!);
    unittest.expect(o.macsecEnabled!, unittest.isTrue);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nocContactEmail!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.operationalStatus!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.peerIpAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.provisionedLinkCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.remoteLocation!,
      unittest.equals('foo'),
    );
    checkUnnamed300(o.requestedFeatures!);
    unittest.expect(
      o.requestedLinkCount!,
      unittest.equals(42),
    );
    unittest.expect(o.satisfiesPzs!, unittest.isTrue);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnect--;
}

core.List<core.String> buildUnnamed301() => [
      'foo',
      'foo',
    ];

void checkUnnamed301(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed302() => [
      'foo',
      'foo',
    ];

void checkUnnamed302(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed303() => [
      'foo',
      'foo',
    ];

void checkUnnamed303(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.Map<core.String, core.String> buildUnnamed304() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed304(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterInterconnectAttachment = 0;
api.InterconnectAttachment buildInterconnectAttachment() {
  final o = api.InterconnectAttachment();
  buildCounterInterconnectAttachment++;
  if (buildCounterInterconnectAttachment < 3) {
    o.adminEnabled = true;
    o.bandwidth = 'foo';
    o.candidateIpv6Subnets = buildUnnamed301();
    o.candidateSubnets = buildUnnamed302();
    o.cloudRouterIpAddress = 'foo';
    o.cloudRouterIpv6Address = 'foo';
    o.cloudRouterIpv6InterfaceId = 'foo';
    o.configurationConstraints =
        buildInterconnectAttachmentConfigurationConstraints();
    o.creationTimestamp = 'foo';
    o.customerRouterIpAddress = 'foo';
    o.customerRouterIpv6Address = 'foo';
    o.customerRouterIpv6InterfaceId = 'foo';
    o.dataplaneVersion = 42;
    o.description = 'foo';
    o.edgeAvailabilityDomain = 'foo';
    o.encryption = 'foo';
    o.googleReferenceId = 'foo';
    o.id = 'foo';
    o.interconnect = 'foo';
    o.ipsecInternalAddresses = buildUnnamed303();
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed304();
    o.mtu = 42;
    o.name = 'foo';
    o.operationalStatus = 'foo';
    o.pairingKey = 'foo';
    o.partnerAsn = 'foo';
    o.partnerMetadata = buildInterconnectAttachmentPartnerMetadata();
    o.privateInterconnectInfo = buildInterconnectAttachmentPrivateInfo();
    o.region = 'foo';
    o.remoteService = 'foo';
    o.router = 'foo';
    o.satisfiesPzs = true;
    o.selfLink = 'foo';
    o.stackType = 'foo';
    o.state = 'foo';
    o.subnetLength = 42;
    o.type = 'foo';
    o.vlanTag8021q = 42;
  }
  buildCounterInterconnectAttachment--;
  return o;
}

void checkInterconnectAttachment(api.InterconnectAttachment o) {
  buildCounterInterconnectAttachment++;
  if (buildCounterInterconnectAttachment < 3) {
    unittest.expect(o.adminEnabled!, unittest.isTrue);
    unittest.expect(
      o.bandwidth!,
      unittest.equals('foo'),
    );
    checkUnnamed301(o.candidateIpv6Subnets!);
    checkUnnamed302(o.candidateSubnets!);
    unittest.expect(
      o.cloudRouterIpAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.cloudRouterIpv6Address!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.cloudRouterIpv6InterfaceId!,
      unittest.equals('foo'),
    );
    checkInterconnectAttachmentConfigurationConstraints(
        o.configurationConstraints!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.customerRouterIpAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.customerRouterIpv6Address!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.customerRouterIpv6InterfaceId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.dataplaneVersion!,
      unittest.equals(42),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.edgeAvailabilityDomain!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.encryption!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.googleReferenceId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.interconnect!,
      unittest.equals('foo'),
    );
    checkUnnamed303(o.ipsecInternalAddresses!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed304(o.labels!);
    unittest.expect(
      o.mtu!,
      unittest.equals(42),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.operationalStatus!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.pairingKey!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.partnerAsn!,
      unittest.equals('foo'),
    );
    checkInterconnectAttachmentPartnerMetadata(o.partnerMetadata!);
    checkInterconnectAttachmentPrivateInfo(o.privateInterconnectInfo!);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.remoteService!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.router!,
      unittest.equals('foo'),
    );
    unittest.expect(o.satisfiesPzs!, unittest.isTrue);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.stackType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.subnetLength!,
      unittest.equals(42),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.vlanTag8021q!,
      unittest.equals(42),
    );
  }
  buildCounterInterconnectAttachment--;
}

core.Map<core.String, api.InterconnectAttachmentsScopedList>
    buildUnnamed305() => {
          'x': buildInterconnectAttachmentsScopedList(),
          'y': buildInterconnectAttachmentsScopedList(),
        };

void checkUnnamed305(
    core.Map<core.String, api.InterconnectAttachmentsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentsScopedList(o['x']!);
  checkInterconnectAttachmentsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed306() => [
      'foo',
      'foo',
    ];

void checkUnnamed306(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInterconnectAttachmentAggregatedListWarningData = 0;
api.InterconnectAttachmentAggregatedListWarningData
    buildInterconnectAttachmentAggregatedListWarningData() {
  final o = api.InterconnectAttachmentAggregatedListWarningData();
  buildCounterInterconnectAttachmentAggregatedListWarningData++;
  if (buildCounterInterconnectAttachmentAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInterconnectAttachmentAggregatedListWarningData--;
  return o;
}

void checkInterconnectAttachmentAggregatedListWarningData(
    api.InterconnectAttachmentAggregatedListWarningData o) {
  buildCounterInterconnectAttachmentAggregatedListWarningData++;
  if (buildCounterInterconnectAttachmentAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectAttachmentAggregatedListWarningData--;
}

core.List<api.InterconnectAttachmentAggregatedListWarningData>
    buildUnnamed307() => [
          buildInterconnectAttachmentAggregatedListWarningData(),
          buildInterconnectAttachmentAggregatedListWarningData(),
        ];

void checkUnnamed307(
    core.List<api.InterconnectAttachmentAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentAggregatedListWarningData(o[0]);
  checkInterconnectAttachmentAggregatedListWarningData(o[1]);
}

core.int buildCounterInterconnectAttachmentAggregatedListWarning = 0;
api.InterconnectAttachmentAggregatedListWarning
    buildInterconnectAttachmentAggregatedListWarning() {
  final o = api.InterconnectAttachmentAggregatedListWarning();
  buildCounterInterconnectAttachmentAggregatedListWarning++;
  if (buildCounterInterconnectAttachmentAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed307();
    o.message = 'foo';
  }
  buildCounterInterconnectAttachmentAggregatedListWarning--;
  return o;
}

void checkInterconnectAttachmentAggregatedListWarning(
    api.InterconnectAttachmentAggregatedListWarning o) {
  buildCounterInterconnectAttachmentAggregatedListWarning++;
  if (buildCounterInterconnectAttachmentAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed307(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectAttachmentAggregatedListWarning--;
}

core.int buildCounterInterconnectAttachmentAggregatedList = 0;
api.InterconnectAttachmentAggregatedList
    buildInterconnectAttachmentAggregatedList() {
  final o = api.InterconnectAttachmentAggregatedList();
  buildCounterInterconnectAttachmentAggregatedList++;
  if (buildCounterInterconnectAttachmentAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed305();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed306();
    o.warning = buildInterconnectAttachmentAggregatedListWarning();
  }
  buildCounterInterconnectAttachmentAggregatedList--;
  return o;
}

void checkInterconnectAttachmentAggregatedList(
    api.InterconnectAttachmentAggregatedList o) {
  buildCounterInterconnectAttachmentAggregatedList++;
  if (buildCounterInterconnectAttachmentAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed305(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed306(o.unreachables!);
    checkInterconnectAttachmentAggregatedListWarning(o.warning!);
  }
  buildCounterInterconnectAttachmentAggregatedList--;
}

core.List<api.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange>
    buildUnnamed308() => [
          buildInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange(),
          buildInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange(),
        ];

void checkUnnamed308(
    core.List<api.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange(o[0]);
  checkInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange(o[1]);
}

core.int buildCounterInterconnectAttachmentConfigurationConstraints = 0;
api.InterconnectAttachmentConfigurationConstraints
    buildInterconnectAttachmentConfigurationConstraints() {
  final o = api.InterconnectAttachmentConfigurationConstraints();
  buildCounterInterconnectAttachmentConfigurationConstraints++;
  if (buildCounterInterconnectAttachmentConfigurationConstraints < 3) {
    o.bgpMd5 = 'foo';
    o.bgpPeerAsnRanges = buildUnnamed308();
  }
  buildCounterInterconnectAttachmentConfigurationConstraints--;
  return o;
}

void checkInterconnectAttachmentConfigurationConstraints(
    api.InterconnectAttachmentConfigurationConstraints o) {
  buildCounterInterconnectAttachmentConfigurationConstraints++;
  if (buildCounterInterconnectAttachmentConfigurationConstraints < 3) {
    unittest.expect(
      o.bgpMd5!,
      unittest.equals('foo'),
    );
    checkUnnamed308(o.bgpPeerAsnRanges!);
  }
  buildCounterInterconnectAttachmentConfigurationConstraints--;
}

core.int
    buildCounterInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange =
    0;
api.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange
    buildInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange() {
  final o = api.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange();
  buildCounterInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange++;
  if (buildCounterInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange <
      3) {
    o.max = 42;
    o.min = 42;
  }
  buildCounterInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange--;
  return o;
}

void checkInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange(
    api.InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange o) {
  buildCounterInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange++;
  if (buildCounterInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange <
      3) {
    unittest.expect(
      o.max!,
      unittest.equals(42),
    );
    unittest.expect(
      o.min!,
      unittest.equals(42),
    );
  }
  buildCounterInterconnectAttachmentConfigurationConstraintsBgpPeerASNRange--;
}

core.List<api.InterconnectAttachment> buildUnnamed309() => [
      buildInterconnectAttachment(),
      buildInterconnectAttachment(),
    ];

void checkUnnamed309(core.List<api.InterconnectAttachment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachment(o[0]);
  checkInterconnectAttachment(o[1]);
}

core.int buildCounterInterconnectAttachmentListWarningData = 0;
api.InterconnectAttachmentListWarningData
    buildInterconnectAttachmentListWarningData() {
  final o = api.InterconnectAttachmentListWarningData();
  buildCounterInterconnectAttachmentListWarningData++;
  if (buildCounterInterconnectAttachmentListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInterconnectAttachmentListWarningData--;
  return o;
}

void checkInterconnectAttachmentListWarningData(
    api.InterconnectAttachmentListWarningData o) {
  buildCounterInterconnectAttachmentListWarningData++;
  if (buildCounterInterconnectAttachmentListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectAttachmentListWarningData--;
}

core.List<api.InterconnectAttachmentListWarningData> buildUnnamed310() => [
      buildInterconnectAttachmentListWarningData(),
      buildInterconnectAttachmentListWarningData(),
    ];

void checkUnnamed310(core.List<api.InterconnectAttachmentListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentListWarningData(o[0]);
  checkInterconnectAttachmentListWarningData(o[1]);
}

core.int buildCounterInterconnectAttachmentListWarning = 0;
api.InterconnectAttachmentListWarning buildInterconnectAttachmentListWarning() {
  final o = api.InterconnectAttachmentListWarning();
  buildCounterInterconnectAttachmentListWarning++;
  if (buildCounterInterconnectAttachmentListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed310();
    o.message = 'foo';
  }
  buildCounterInterconnectAttachmentListWarning--;
  return o;
}

void checkInterconnectAttachmentListWarning(
    api.InterconnectAttachmentListWarning o) {
  buildCounterInterconnectAttachmentListWarning++;
  if (buildCounterInterconnectAttachmentListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed310(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectAttachmentListWarning--;
}

core.int buildCounterInterconnectAttachmentList = 0;
api.InterconnectAttachmentList buildInterconnectAttachmentList() {
  final o = api.InterconnectAttachmentList();
  buildCounterInterconnectAttachmentList++;
  if (buildCounterInterconnectAttachmentList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed309();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInterconnectAttachmentListWarning();
  }
  buildCounterInterconnectAttachmentList--;
  return o;
}

void checkInterconnectAttachmentList(api.InterconnectAttachmentList o) {
  buildCounterInterconnectAttachmentList++;
  if (buildCounterInterconnectAttachmentList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed309(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInterconnectAttachmentListWarning(o.warning!);
  }
  buildCounterInterconnectAttachmentList--;
}

core.int buildCounterInterconnectAttachmentPartnerMetadata = 0;
api.InterconnectAttachmentPartnerMetadata
    buildInterconnectAttachmentPartnerMetadata() {
  final o = api.InterconnectAttachmentPartnerMetadata();
  buildCounterInterconnectAttachmentPartnerMetadata++;
  if (buildCounterInterconnectAttachmentPartnerMetadata < 3) {
    o.interconnectName = 'foo';
    o.partnerName = 'foo';
    o.portalUrl = 'foo';
  }
  buildCounterInterconnectAttachmentPartnerMetadata--;
  return o;
}

void checkInterconnectAttachmentPartnerMetadata(
    api.InterconnectAttachmentPartnerMetadata o) {
  buildCounterInterconnectAttachmentPartnerMetadata++;
  if (buildCounterInterconnectAttachmentPartnerMetadata < 3) {
    unittest.expect(
      o.interconnectName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.partnerName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.portalUrl!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectAttachmentPartnerMetadata--;
}

core.int buildCounterInterconnectAttachmentPrivateInfo = 0;
api.InterconnectAttachmentPrivateInfo buildInterconnectAttachmentPrivateInfo() {
  final o = api.InterconnectAttachmentPrivateInfo();
  buildCounterInterconnectAttachmentPrivateInfo++;
  if (buildCounterInterconnectAttachmentPrivateInfo < 3) {
    o.tag8021q = 42;
  }
  buildCounterInterconnectAttachmentPrivateInfo--;
  return o;
}

void checkInterconnectAttachmentPrivateInfo(
    api.InterconnectAttachmentPrivateInfo o) {
  buildCounterInterconnectAttachmentPrivateInfo++;
  if (buildCounterInterconnectAttachmentPrivateInfo < 3) {
    unittest.expect(
      o.tag8021q!,
      unittest.equals(42),
    );
  }
  buildCounterInterconnectAttachmentPrivateInfo--;
}

core.List<api.InterconnectAttachment> buildUnnamed311() => [
      buildInterconnectAttachment(),
      buildInterconnectAttachment(),
    ];

void checkUnnamed311(core.List<api.InterconnectAttachment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachment(o[0]);
  checkInterconnectAttachment(o[1]);
}

core.int buildCounterInterconnectAttachmentsScopedListWarningData = 0;
api.InterconnectAttachmentsScopedListWarningData
    buildInterconnectAttachmentsScopedListWarningData() {
  final o = api.InterconnectAttachmentsScopedListWarningData();
  buildCounterInterconnectAttachmentsScopedListWarningData++;
  if (buildCounterInterconnectAttachmentsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInterconnectAttachmentsScopedListWarningData--;
  return o;
}

void checkInterconnectAttachmentsScopedListWarningData(
    api.InterconnectAttachmentsScopedListWarningData o) {
  buildCounterInterconnectAttachmentsScopedListWarningData++;
  if (buildCounterInterconnectAttachmentsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectAttachmentsScopedListWarningData--;
}

core.List<api.InterconnectAttachmentsScopedListWarningData> buildUnnamed312() =>
    [
      buildInterconnectAttachmentsScopedListWarningData(),
      buildInterconnectAttachmentsScopedListWarningData(),
    ];

void checkUnnamed312(
    core.List<api.InterconnectAttachmentsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectAttachmentsScopedListWarningData(o[0]);
  checkInterconnectAttachmentsScopedListWarningData(o[1]);
}

core.int buildCounterInterconnectAttachmentsScopedListWarning = 0;
api.InterconnectAttachmentsScopedListWarning
    buildInterconnectAttachmentsScopedListWarning() {
  final o = api.InterconnectAttachmentsScopedListWarning();
  buildCounterInterconnectAttachmentsScopedListWarning++;
  if (buildCounterInterconnectAttachmentsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed312();
    o.message = 'foo';
  }
  buildCounterInterconnectAttachmentsScopedListWarning--;
  return o;
}

void checkInterconnectAttachmentsScopedListWarning(
    api.InterconnectAttachmentsScopedListWarning o) {
  buildCounterInterconnectAttachmentsScopedListWarning++;
  if (buildCounterInterconnectAttachmentsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed312(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectAttachmentsScopedListWarning--;
}

core.int buildCounterInterconnectAttachmentsScopedList = 0;
api.InterconnectAttachmentsScopedList buildInterconnectAttachmentsScopedList() {
  final o = api.InterconnectAttachmentsScopedList();
  buildCounterInterconnectAttachmentsScopedList++;
  if (buildCounterInterconnectAttachmentsScopedList < 3) {
    o.interconnectAttachments = buildUnnamed311();
    o.warning = buildInterconnectAttachmentsScopedListWarning();
  }
  buildCounterInterconnectAttachmentsScopedList--;
  return o;
}

void checkInterconnectAttachmentsScopedList(
    api.InterconnectAttachmentsScopedList o) {
  buildCounterInterconnectAttachmentsScopedList++;
  if (buildCounterInterconnectAttachmentsScopedList < 3) {
    checkUnnamed311(o.interconnectAttachments!);
    checkInterconnectAttachmentsScopedListWarning(o.warning!);
  }
  buildCounterInterconnectAttachmentsScopedList--;
}

core.int buildCounterInterconnectCircuitInfo = 0;
api.InterconnectCircuitInfo buildInterconnectCircuitInfo() {
  final o = api.InterconnectCircuitInfo();
  buildCounterInterconnectCircuitInfo++;
  if (buildCounterInterconnectCircuitInfo < 3) {
    o.customerDemarcId = 'foo';
    o.googleCircuitId = 'foo';
    o.googleDemarcId = 'foo';
  }
  buildCounterInterconnectCircuitInfo--;
  return o;
}

void checkInterconnectCircuitInfo(api.InterconnectCircuitInfo o) {
  buildCounterInterconnectCircuitInfo++;
  if (buildCounterInterconnectCircuitInfo < 3) {
    unittest.expect(
      o.customerDemarcId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.googleCircuitId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.googleDemarcId!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectCircuitInfo--;
}

core.List<api.InterconnectDiagnosticsARPEntry> buildUnnamed313() => [
      buildInterconnectDiagnosticsARPEntry(),
      buildInterconnectDiagnosticsARPEntry(),
    ];

void checkUnnamed313(core.List<api.InterconnectDiagnosticsARPEntry> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectDiagnosticsARPEntry(o[0]);
  checkInterconnectDiagnosticsARPEntry(o[1]);
}

core.List<api.InterconnectDiagnosticsLinkStatus> buildUnnamed314() => [
      buildInterconnectDiagnosticsLinkStatus(),
      buildInterconnectDiagnosticsLinkStatus(),
    ];

void checkUnnamed314(core.List<api.InterconnectDiagnosticsLinkStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectDiagnosticsLinkStatus(o[0]);
  checkInterconnectDiagnosticsLinkStatus(o[1]);
}

core.int buildCounterInterconnectDiagnostics = 0;
api.InterconnectDiagnostics buildInterconnectDiagnostics() {
  final o = api.InterconnectDiagnostics();
  buildCounterInterconnectDiagnostics++;
  if (buildCounterInterconnectDiagnostics < 3) {
    o.arpCaches = buildUnnamed313();
    o.bundleAggregationType = 'foo';
    o.bundleOperationalStatus = 'foo';
    o.links = buildUnnamed314();
    o.macAddress = 'foo';
  }
  buildCounterInterconnectDiagnostics--;
  return o;
}

void checkInterconnectDiagnostics(api.InterconnectDiagnostics o) {
  buildCounterInterconnectDiagnostics++;
  if (buildCounterInterconnectDiagnostics < 3) {
    checkUnnamed313(o.arpCaches!);
    unittest.expect(
      o.bundleAggregationType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.bundleOperationalStatus!,
      unittest.equals('foo'),
    );
    checkUnnamed314(o.links!);
    unittest.expect(
      o.macAddress!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectDiagnostics--;
}

core.int buildCounterInterconnectDiagnosticsARPEntry = 0;
api.InterconnectDiagnosticsARPEntry buildInterconnectDiagnosticsARPEntry() {
  final o = api.InterconnectDiagnosticsARPEntry();
  buildCounterInterconnectDiagnosticsARPEntry++;
  if (buildCounterInterconnectDiagnosticsARPEntry < 3) {
    o.ipAddress = 'foo';
    o.macAddress = 'foo';
  }
  buildCounterInterconnectDiagnosticsARPEntry--;
  return o;
}

void checkInterconnectDiagnosticsARPEntry(
    api.InterconnectDiagnosticsARPEntry o) {
  buildCounterInterconnectDiagnosticsARPEntry++;
  if (buildCounterInterconnectDiagnosticsARPEntry < 3) {
    unittest.expect(
      o.ipAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.macAddress!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectDiagnosticsARPEntry--;
}

core.int buildCounterInterconnectDiagnosticsLinkLACPStatus = 0;
api.InterconnectDiagnosticsLinkLACPStatus
    buildInterconnectDiagnosticsLinkLACPStatus() {
  final o = api.InterconnectDiagnosticsLinkLACPStatus();
  buildCounterInterconnectDiagnosticsLinkLACPStatus++;
  if (buildCounterInterconnectDiagnosticsLinkLACPStatus < 3) {
    o.googleSystemId = 'foo';
    o.neighborSystemId = 'foo';
    o.state = 'foo';
  }
  buildCounterInterconnectDiagnosticsLinkLACPStatus--;
  return o;
}

void checkInterconnectDiagnosticsLinkLACPStatus(
    api.InterconnectDiagnosticsLinkLACPStatus o) {
  buildCounterInterconnectDiagnosticsLinkLACPStatus++;
  if (buildCounterInterconnectDiagnosticsLinkLACPStatus < 3) {
    unittest.expect(
      o.googleSystemId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.neighborSystemId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectDiagnosticsLinkLACPStatus--;
}

core.int buildCounterInterconnectDiagnosticsLinkOpticalPower = 0;
api.InterconnectDiagnosticsLinkOpticalPower
    buildInterconnectDiagnosticsLinkOpticalPower() {
  final o = api.InterconnectDiagnosticsLinkOpticalPower();
  buildCounterInterconnectDiagnosticsLinkOpticalPower++;
  if (buildCounterInterconnectDiagnosticsLinkOpticalPower < 3) {
    o.state = 'foo';
    o.value = 42.0;
  }
  buildCounterInterconnectDiagnosticsLinkOpticalPower--;
  return o;
}

void checkInterconnectDiagnosticsLinkOpticalPower(
    api.InterconnectDiagnosticsLinkOpticalPower o) {
  buildCounterInterconnectDiagnosticsLinkOpticalPower++;
  if (buildCounterInterconnectDiagnosticsLinkOpticalPower < 3) {
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals(42.0),
    );
  }
  buildCounterInterconnectDiagnosticsLinkOpticalPower--;
}

core.List<api.InterconnectDiagnosticsARPEntry> buildUnnamed315() => [
      buildInterconnectDiagnosticsARPEntry(),
      buildInterconnectDiagnosticsARPEntry(),
    ];

void checkUnnamed315(core.List<api.InterconnectDiagnosticsARPEntry> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectDiagnosticsARPEntry(o[0]);
  checkInterconnectDiagnosticsARPEntry(o[1]);
}

core.int buildCounterInterconnectDiagnosticsLinkStatus = 0;
api.InterconnectDiagnosticsLinkStatus buildInterconnectDiagnosticsLinkStatus() {
  final o = api.InterconnectDiagnosticsLinkStatus();
  buildCounterInterconnectDiagnosticsLinkStatus++;
  if (buildCounterInterconnectDiagnosticsLinkStatus < 3) {
    o.arpCaches = buildUnnamed315();
    o.circuitId = 'foo';
    o.googleDemarc = 'foo';
    o.lacpStatus = buildInterconnectDiagnosticsLinkLACPStatus();
    o.macsec = buildInterconnectDiagnosticsMacsecStatus();
    o.operationalStatus = 'foo';
    o.receivingOpticalPower = buildInterconnectDiagnosticsLinkOpticalPower();
    o.transmittingOpticalPower = buildInterconnectDiagnosticsLinkOpticalPower();
  }
  buildCounterInterconnectDiagnosticsLinkStatus--;
  return o;
}

void checkInterconnectDiagnosticsLinkStatus(
    api.InterconnectDiagnosticsLinkStatus o) {
  buildCounterInterconnectDiagnosticsLinkStatus++;
  if (buildCounterInterconnectDiagnosticsLinkStatus < 3) {
    checkUnnamed315(o.arpCaches!);
    unittest.expect(
      o.circuitId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.googleDemarc!,
      unittest.equals('foo'),
    );
    checkInterconnectDiagnosticsLinkLACPStatus(o.lacpStatus!);
    checkInterconnectDiagnosticsMacsecStatus(o.macsec!);
    unittest.expect(
      o.operationalStatus!,
      unittest.equals('foo'),
    );
    checkInterconnectDiagnosticsLinkOpticalPower(o.receivingOpticalPower!);
    checkInterconnectDiagnosticsLinkOpticalPower(o.transmittingOpticalPower!);
  }
  buildCounterInterconnectDiagnosticsLinkStatus--;
}

core.int buildCounterInterconnectDiagnosticsMacsecStatus = 0;
api.InterconnectDiagnosticsMacsecStatus
    buildInterconnectDiagnosticsMacsecStatus() {
  final o = api.InterconnectDiagnosticsMacsecStatus();
  buildCounterInterconnectDiagnosticsMacsecStatus++;
  if (buildCounterInterconnectDiagnosticsMacsecStatus < 3) {
    o.ckn = 'foo';
    o.operational = true;
  }
  buildCounterInterconnectDiagnosticsMacsecStatus--;
  return o;
}

void checkInterconnectDiagnosticsMacsecStatus(
    api.InterconnectDiagnosticsMacsecStatus o) {
  buildCounterInterconnectDiagnosticsMacsecStatus++;
  if (buildCounterInterconnectDiagnosticsMacsecStatus < 3) {
    unittest.expect(
      o.ckn!,
      unittest.equals('foo'),
    );
    unittest.expect(o.operational!, unittest.isTrue);
  }
  buildCounterInterconnectDiagnosticsMacsecStatus--;
}

core.List<api.Interconnect> buildUnnamed316() => [
      buildInterconnect(),
      buildInterconnect(),
    ];

void checkUnnamed316(core.List<api.Interconnect> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnect(o[0]);
  checkInterconnect(o[1]);
}

core.int buildCounterInterconnectListWarningData = 0;
api.InterconnectListWarningData buildInterconnectListWarningData() {
  final o = api.InterconnectListWarningData();
  buildCounterInterconnectListWarningData++;
  if (buildCounterInterconnectListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInterconnectListWarningData--;
  return o;
}

void checkInterconnectListWarningData(api.InterconnectListWarningData o) {
  buildCounterInterconnectListWarningData++;
  if (buildCounterInterconnectListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectListWarningData--;
}

core.List<api.InterconnectListWarningData> buildUnnamed317() => [
      buildInterconnectListWarningData(),
      buildInterconnectListWarningData(),
    ];

void checkUnnamed317(core.List<api.InterconnectListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectListWarningData(o[0]);
  checkInterconnectListWarningData(o[1]);
}

core.int buildCounterInterconnectListWarning = 0;
api.InterconnectListWarning buildInterconnectListWarning() {
  final o = api.InterconnectListWarning();
  buildCounterInterconnectListWarning++;
  if (buildCounterInterconnectListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed317();
    o.message = 'foo';
  }
  buildCounterInterconnectListWarning--;
  return o;
}

void checkInterconnectListWarning(api.InterconnectListWarning o) {
  buildCounterInterconnectListWarning++;
  if (buildCounterInterconnectListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed317(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectListWarning--;
}

core.int buildCounterInterconnectList = 0;
api.InterconnectList buildInterconnectList() {
  final o = api.InterconnectList();
  buildCounterInterconnectList++;
  if (buildCounterInterconnectList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed316();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInterconnectListWarning();
  }
  buildCounterInterconnectList--;
  return o;
}

void checkInterconnectList(api.InterconnectList o) {
  buildCounterInterconnectList++;
  if (buildCounterInterconnectList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed316(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInterconnectListWarning(o.warning!);
  }
  buildCounterInterconnectList--;
}

core.List<core.String> buildUnnamed318() => [
      'foo',
      'foo',
    ];

void checkUnnamed318(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed319() => [
      'foo',
      'foo',
    ];

void checkUnnamed319(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.InterconnectLocationRegionInfo> buildUnnamed320() => [
      buildInterconnectLocationRegionInfo(),
      buildInterconnectLocationRegionInfo(),
    ];

void checkUnnamed320(core.List<api.InterconnectLocationRegionInfo> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectLocationRegionInfo(o[0]);
  checkInterconnectLocationRegionInfo(o[1]);
}

core.int buildCounterInterconnectLocation = 0;
api.InterconnectLocation buildInterconnectLocation() {
  final o = api.InterconnectLocation();
  buildCounterInterconnectLocation++;
  if (buildCounterInterconnectLocation < 3) {
    o.address = 'foo';
    o.availabilityZone = 'foo';
    o.availableFeatures = buildUnnamed318();
    o.availableLinkTypes = buildUnnamed319();
    o.city = 'foo';
    o.continent = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.facilityProvider = 'foo';
    o.facilityProviderFacilityId = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.peeringdbFacilityId = 'foo';
    o.regionInfos = buildUnnamed320();
    o.selfLink = 'foo';
    o.status = 'foo';
    o.supportsPzs = true;
  }
  buildCounterInterconnectLocation--;
  return o;
}

void checkInterconnectLocation(api.InterconnectLocation o) {
  buildCounterInterconnectLocation++;
  if (buildCounterInterconnectLocation < 3) {
    unittest.expect(
      o.address!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.availabilityZone!,
      unittest.equals('foo'),
    );
    checkUnnamed318(o.availableFeatures!);
    checkUnnamed319(o.availableLinkTypes!);
    unittest.expect(
      o.city!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.continent!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.facilityProvider!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.facilityProviderFacilityId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.peeringdbFacilityId!,
      unittest.equals('foo'),
    );
    checkUnnamed320(o.regionInfos!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(o.supportsPzs!, unittest.isTrue);
  }
  buildCounterInterconnectLocation--;
}

core.List<api.InterconnectLocation> buildUnnamed321() => [
      buildInterconnectLocation(),
      buildInterconnectLocation(),
    ];

void checkUnnamed321(core.List<api.InterconnectLocation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectLocation(o[0]);
  checkInterconnectLocation(o[1]);
}

core.int buildCounterInterconnectLocationListWarningData = 0;
api.InterconnectLocationListWarningData
    buildInterconnectLocationListWarningData() {
  final o = api.InterconnectLocationListWarningData();
  buildCounterInterconnectLocationListWarningData++;
  if (buildCounterInterconnectLocationListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInterconnectLocationListWarningData--;
  return o;
}

void checkInterconnectLocationListWarningData(
    api.InterconnectLocationListWarningData o) {
  buildCounterInterconnectLocationListWarningData++;
  if (buildCounterInterconnectLocationListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectLocationListWarningData--;
}

core.List<api.InterconnectLocationListWarningData> buildUnnamed322() => [
      buildInterconnectLocationListWarningData(),
      buildInterconnectLocationListWarningData(),
    ];

void checkUnnamed322(core.List<api.InterconnectLocationListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectLocationListWarningData(o[0]);
  checkInterconnectLocationListWarningData(o[1]);
}

core.int buildCounterInterconnectLocationListWarning = 0;
api.InterconnectLocationListWarning buildInterconnectLocationListWarning() {
  final o = api.InterconnectLocationListWarning();
  buildCounterInterconnectLocationListWarning++;
  if (buildCounterInterconnectLocationListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed322();
    o.message = 'foo';
  }
  buildCounterInterconnectLocationListWarning--;
  return o;
}

void checkInterconnectLocationListWarning(
    api.InterconnectLocationListWarning o) {
  buildCounterInterconnectLocationListWarning++;
  if (buildCounterInterconnectLocationListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed322(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectLocationListWarning--;
}

core.int buildCounterInterconnectLocationList = 0;
api.InterconnectLocationList buildInterconnectLocationList() {
  final o = api.InterconnectLocationList();
  buildCounterInterconnectLocationList++;
  if (buildCounterInterconnectLocationList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed321();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInterconnectLocationListWarning();
  }
  buildCounterInterconnectLocationList--;
  return o;
}

void checkInterconnectLocationList(api.InterconnectLocationList o) {
  buildCounterInterconnectLocationList++;
  if (buildCounterInterconnectLocationList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed321(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInterconnectLocationListWarning(o.warning!);
  }
  buildCounterInterconnectLocationList--;
}

core.int buildCounterInterconnectLocationRegionInfo = 0;
api.InterconnectLocationRegionInfo buildInterconnectLocationRegionInfo() {
  final o = api.InterconnectLocationRegionInfo();
  buildCounterInterconnectLocationRegionInfo++;
  if (buildCounterInterconnectLocationRegionInfo < 3) {
    o.expectedRttMs = 'foo';
    o.locationPresence = 'foo';
    o.region = 'foo';
  }
  buildCounterInterconnectLocationRegionInfo--;
  return o;
}

void checkInterconnectLocationRegionInfo(api.InterconnectLocationRegionInfo o) {
  buildCounterInterconnectLocationRegionInfo++;
  if (buildCounterInterconnectLocationRegionInfo < 3) {
    unittest.expect(
      o.expectedRttMs!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.locationPresence!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectLocationRegionInfo--;
}

core.List<api.InterconnectMacsecPreSharedKey> buildUnnamed323() => [
      buildInterconnectMacsecPreSharedKey(),
      buildInterconnectMacsecPreSharedKey(),
    ];

void checkUnnamed323(core.List<api.InterconnectMacsecPreSharedKey> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectMacsecPreSharedKey(o[0]);
  checkInterconnectMacsecPreSharedKey(o[1]);
}

core.int buildCounterInterconnectMacsec = 0;
api.InterconnectMacsec buildInterconnectMacsec() {
  final o = api.InterconnectMacsec();
  buildCounterInterconnectMacsec++;
  if (buildCounterInterconnectMacsec < 3) {
    o.failOpen = true;
    o.preSharedKeys = buildUnnamed323();
  }
  buildCounterInterconnectMacsec--;
  return o;
}

void checkInterconnectMacsec(api.InterconnectMacsec o) {
  buildCounterInterconnectMacsec++;
  if (buildCounterInterconnectMacsec < 3) {
    unittest.expect(o.failOpen!, unittest.isTrue);
    checkUnnamed323(o.preSharedKeys!);
  }
  buildCounterInterconnectMacsec--;
}

core.List<api.InterconnectMacsecConfigPreSharedKey> buildUnnamed324() => [
      buildInterconnectMacsecConfigPreSharedKey(),
      buildInterconnectMacsecConfigPreSharedKey(),
    ];

void checkUnnamed324(core.List<api.InterconnectMacsecConfigPreSharedKey> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectMacsecConfigPreSharedKey(o[0]);
  checkInterconnectMacsecConfigPreSharedKey(o[1]);
}

core.int buildCounterInterconnectMacsecConfig = 0;
api.InterconnectMacsecConfig buildInterconnectMacsecConfig() {
  final o = api.InterconnectMacsecConfig();
  buildCounterInterconnectMacsecConfig++;
  if (buildCounterInterconnectMacsecConfig < 3) {
    o.preSharedKeys = buildUnnamed324();
  }
  buildCounterInterconnectMacsecConfig--;
  return o;
}

void checkInterconnectMacsecConfig(api.InterconnectMacsecConfig o) {
  buildCounterInterconnectMacsecConfig++;
  if (buildCounterInterconnectMacsecConfig < 3) {
    checkUnnamed324(o.preSharedKeys!);
  }
  buildCounterInterconnectMacsecConfig--;
}

core.int buildCounterInterconnectMacsecConfigPreSharedKey = 0;
api.InterconnectMacsecConfigPreSharedKey
    buildInterconnectMacsecConfigPreSharedKey() {
  final o = api.InterconnectMacsecConfigPreSharedKey();
  buildCounterInterconnectMacsecConfigPreSharedKey++;
  if (buildCounterInterconnectMacsecConfigPreSharedKey < 3) {
    o.cak = 'foo';
    o.ckn = 'foo';
    o.name = 'foo';
    o.startTime = 'foo';
  }
  buildCounterInterconnectMacsecConfigPreSharedKey--;
  return o;
}

void checkInterconnectMacsecConfigPreSharedKey(
    api.InterconnectMacsecConfigPreSharedKey o) {
  buildCounterInterconnectMacsecConfigPreSharedKey++;
  if (buildCounterInterconnectMacsecConfigPreSharedKey < 3) {
    unittest.expect(
      o.cak!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ckn!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectMacsecConfigPreSharedKey--;
}

core.int buildCounterInterconnectMacsecPreSharedKey = 0;
api.InterconnectMacsecPreSharedKey buildInterconnectMacsecPreSharedKey() {
  final o = api.InterconnectMacsecPreSharedKey();
  buildCounterInterconnectMacsecPreSharedKey++;
  if (buildCounterInterconnectMacsecPreSharedKey < 3) {
    o.name = 'foo';
    o.startTime = 'foo';
  }
  buildCounterInterconnectMacsecPreSharedKey--;
  return o;
}

void checkInterconnectMacsecPreSharedKey(api.InterconnectMacsecPreSharedKey o) {
  buildCounterInterconnectMacsecPreSharedKey++;
  if (buildCounterInterconnectMacsecPreSharedKey < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectMacsecPreSharedKey--;
}

core.List<core.String> buildUnnamed325() => [
      'foo',
      'foo',
    ];

void checkUnnamed325(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterInterconnectOutageNotification = 0;
api.InterconnectOutageNotification buildInterconnectOutageNotification() {
  final o = api.InterconnectOutageNotification();
  buildCounterInterconnectOutageNotification++;
  if (buildCounterInterconnectOutageNotification < 3) {
    o.affectedCircuits = buildUnnamed325();
    o.description = 'foo';
    o.endTime = 'foo';
    o.issueType = 'foo';
    o.name = 'foo';
    o.source = 'foo';
    o.startTime = 'foo';
    o.state = 'foo';
  }
  buildCounterInterconnectOutageNotification--;
  return o;
}

void checkInterconnectOutageNotification(api.InterconnectOutageNotification o) {
  buildCounterInterconnectOutageNotification++;
  if (buildCounterInterconnectOutageNotification < 3) {
    checkUnnamed325(o.affectedCircuits!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.endTime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.issueType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.source!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectOutageNotification--;
}

core.List<api.InterconnectRemoteLocationPermittedConnections>
    buildUnnamed326() => [
          buildInterconnectRemoteLocationPermittedConnections(),
          buildInterconnectRemoteLocationPermittedConnections(),
        ];

void checkUnnamed326(
    core.List<api.InterconnectRemoteLocationPermittedConnections> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectRemoteLocationPermittedConnections(o[0]);
  checkInterconnectRemoteLocationPermittedConnections(o[1]);
}

core.int buildCounterInterconnectRemoteLocation = 0;
api.InterconnectRemoteLocation buildInterconnectRemoteLocation() {
  final o = api.InterconnectRemoteLocation();
  buildCounterInterconnectRemoteLocation++;
  if (buildCounterInterconnectRemoteLocation < 3) {
    o.address = 'foo';
    o.attachmentConfigurationConstraints =
        buildInterconnectAttachmentConfigurationConstraints();
    o.city = 'foo';
    o.constraints = buildInterconnectRemoteLocationConstraints();
    o.continent = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.facilityProvider = 'foo';
    o.facilityProviderFacilityId = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.lacp = 'foo';
    o.maxLagSize100Gbps = 42;
    o.maxLagSize10Gbps = 42;
    o.name = 'foo';
    o.peeringdbFacilityId = 'foo';
    o.permittedConnections = buildUnnamed326();
    o.remoteService = 'foo';
    o.selfLink = 'foo';
    o.status = 'foo';
  }
  buildCounterInterconnectRemoteLocation--;
  return o;
}

void checkInterconnectRemoteLocation(api.InterconnectRemoteLocation o) {
  buildCounterInterconnectRemoteLocation++;
  if (buildCounterInterconnectRemoteLocation < 3) {
    unittest.expect(
      o.address!,
      unittest.equals('foo'),
    );
    checkInterconnectAttachmentConfigurationConstraints(
        o.attachmentConfigurationConstraints!);
    unittest.expect(
      o.city!,
      unittest.equals('foo'),
    );
    checkInterconnectRemoteLocationConstraints(o.constraints!);
    unittest.expect(
      o.continent!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.facilityProvider!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.facilityProviderFacilityId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.lacp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.maxLagSize100Gbps!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maxLagSize10Gbps!,
      unittest.equals(42),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.peeringdbFacilityId!,
      unittest.equals('foo'),
    );
    checkUnnamed326(o.permittedConnections!);
    unittest.expect(
      o.remoteService!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectRemoteLocation--;
}

core.int buildCounterInterconnectRemoteLocationConstraints = 0;
api.InterconnectRemoteLocationConstraints
    buildInterconnectRemoteLocationConstraints() {
  final o = api.InterconnectRemoteLocationConstraints();
  buildCounterInterconnectRemoteLocationConstraints++;
  if (buildCounterInterconnectRemoteLocationConstraints < 3) {
    o.portPairRemoteLocation = 'foo';
    o.portPairVlan = 'foo';
    o.subnetLengthRange =
        buildInterconnectRemoteLocationConstraintsSubnetLengthRange();
  }
  buildCounterInterconnectRemoteLocationConstraints--;
  return o;
}

void checkInterconnectRemoteLocationConstraints(
    api.InterconnectRemoteLocationConstraints o) {
  buildCounterInterconnectRemoteLocationConstraints++;
  if (buildCounterInterconnectRemoteLocationConstraints < 3) {
    unittest.expect(
      o.portPairRemoteLocation!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.portPairVlan!,
      unittest.equals('foo'),
    );
    checkInterconnectRemoteLocationConstraintsSubnetLengthRange(
        o.subnetLengthRange!);
  }
  buildCounterInterconnectRemoteLocationConstraints--;
}

core.int buildCounterInterconnectRemoteLocationConstraintsSubnetLengthRange = 0;
api.InterconnectRemoteLocationConstraintsSubnetLengthRange
    buildInterconnectRemoteLocationConstraintsSubnetLengthRange() {
  final o = api.InterconnectRemoteLocationConstraintsSubnetLengthRange();
  buildCounterInterconnectRemoteLocationConstraintsSubnetLengthRange++;
  if (buildCounterInterconnectRemoteLocationConstraintsSubnetLengthRange < 3) {
    o.max = 42;
    o.min = 42;
  }
  buildCounterInterconnectRemoteLocationConstraintsSubnetLengthRange--;
  return o;
}

void checkInterconnectRemoteLocationConstraintsSubnetLengthRange(
    api.InterconnectRemoteLocationConstraintsSubnetLengthRange o) {
  buildCounterInterconnectRemoteLocationConstraintsSubnetLengthRange++;
  if (buildCounterInterconnectRemoteLocationConstraintsSubnetLengthRange < 3) {
    unittest.expect(
      o.max!,
      unittest.equals(42),
    );
    unittest.expect(
      o.min!,
      unittest.equals(42),
    );
  }
  buildCounterInterconnectRemoteLocationConstraintsSubnetLengthRange--;
}

core.List<api.InterconnectRemoteLocation> buildUnnamed327() => [
      buildInterconnectRemoteLocation(),
      buildInterconnectRemoteLocation(),
    ];

void checkUnnamed327(core.List<api.InterconnectRemoteLocation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectRemoteLocation(o[0]);
  checkInterconnectRemoteLocation(o[1]);
}

core.int buildCounterInterconnectRemoteLocationListWarningData = 0;
api.InterconnectRemoteLocationListWarningData
    buildInterconnectRemoteLocationListWarningData() {
  final o = api.InterconnectRemoteLocationListWarningData();
  buildCounterInterconnectRemoteLocationListWarningData++;
  if (buildCounterInterconnectRemoteLocationListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterInterconnectRemoteLocationListWarningData--;
  return o;
}

void checkInterconnectRemoteLocationListWarningData(
    api.InterconnectRemoteLocationListWarningData o) {
  buildCounterInterconnectRemoteLocationListWarningData++;
  if (buildCounterInterconnectRemoteLocationListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectRemoteLocationListWarningData--;
}

core.List<api.InterconnectRemoteLocationListWarningData> buildUnnamed328() => [
      buildInterconnectRemoteLocationListWarningData(),
      buildInterconnectRemoteLocationListWarningData(),
    ];

void checkUnnamed328(
    core.List<api.InterconnectRemoteLocationListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInterconnectRemoteLocationListWarningData(o[0]);
  checkInterconnectRemoteLocationListWarningData(o[1]);
}

core.int buildCounterInterconnectRemoteLocationListWarning = 0;
api.InterconnectRemoteLocationListWarning
    buildInterconnectRemoteLocationListWarning() {
  final o = api.InterconnectRemoteLocationListWarning();
  buildCounterInterconnectRemoteLocationListWarning++;
  if (buildCounterInterconnectRemoteLocationListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed328();
    o.message = 'foo';
  }
  buildCounterInterconnectRemoteLocationListWarning--;
  return o;
}

void checkInterconnectRemoteLocationListWarning(
    api.InterconnectRemoteLocationListWarning o) {
  buildCounterInterconnectRemoteLocationListWarning++;
  if (buildCounterInterconnectRemoteLocationListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed328(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectRemoteLocationListWarning--;
}

core.int buildCounterInterconnectRemoteLocationList = 0;
api.InterconnectRemoteLocationList buildInterconnectRemoteLocationList() {
  final o = api.InterconnectRemoteLocationList();
  buildCounterInterconnectRemoteLocationList++;
  if (buildCounterInterconnectRemoteLocationList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed327();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildInterconnectRemoteLocationListWarning();
  }
  buildCounterInterconnectRemoteLocationList--;
  return o;
}

void checkInterconnectRemoteLocationList(api.InterconnectRemoteLocationList o) {
  buildCounterInterconnectRemoteLocationList++;
  if (buildCounterInterconnectRemoteLocationList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed327(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkInterconnectRemoteLocationListWarning(o.warning!);
  }
  buildCounterInterconnectRemoteLocationList--;
}

core.int buildCounterInterconnectRemoteLocationPermittedConnections = 0;
api.InterconnectRemoteLocationPermittedConnections
    buildInterconnectRemoteLocationPermittedConnections() {
  final o = api.InterconnectRemoteLocationPermittedConnections();
  buildCounterInterconnectRemoteLocationPermittedConnections++;
  if (buildCounterInterconnectRemoteLocationPermittedConnections < 3) {
    o.interconnectLocation = 'foo';
  }
  buildCounterInterconnectRemoteLocationPermittedConnections--;
  return o;
}

void checkInterconnectRemoteLocationPermittedConnections(
    api.InterconnectRemoteLocationPermittedConnections o) {
  buildCounterInterconnectRemoteLocationPermittedConnections++;
  if (buildCounterInterconnectRemoteLocationPermittedConnections < 3) {
    unittest.expect(
      o.interconnectLocation!,
      unittest.equals('foo'),
    );
  }
  buildCounterInterconnectRemoteLocationPermittedConnections--;
}

core.int buildCounterInterconnectsGetDiagnosticsResponse = 0;
api.InterconnectsGetDiagnosticsResponse
    buildInterconnectsGetDiagnosticsResponse() {
  final o = api.InterconnectsGetDiagnosticsResponse();
  buildCounterInterconnectsGetDiagnosticsResponse++;
  if (buildCounterInterconnectsGetDiagnosticsResponse < 3) {
    o.result = buildInterconnectDiagnostics();
  }
  buildCounterInterconnectsGetDiagnosticsResponse--;
  return o;
}

void checkInterconnectsGetDiagnosticsResponse(
    api.InterconnectsGetDiagnosticsResponse o) {
  buildCounterInterconnectsGetDiagnosticsResponse++;
  if (buildCounterInterconnectsGetDiagnosticsResponse < 3) {
    checkInterconnectDiagnostics(o.result!);
  }
  buildCounterInterconnectsGetDiagnosticsResponse--;
}

core.int buildCounterInterconnectsGetMacsecConfigResponse = 0;
api.InterconnectsGetMacsecConfigResponse
    buildInterconnectsGetMacsecConfigResponse() {
  final o = api.InterconnectsGetMacsecConfigResponse();
  buildCounterInterconnectsGetMacsecConfigResponse++;
  if (buildCounterInterconnectsGetMacsecConfigResponse < 3) {
    o.etag = 'foo';
    o.result = buildInterconnectMacsecConfig();
  }
  buildCounterInterconnectsGetMacsecConfigResponse--;
  return o;
}

void checkInterconnectsGetMacsecConfigResponse(
    api.InterconnectsGetMacsecConfigResponse o) {
  buildCounterInterconnectsGetMacsecConfigResponse++;
  if (buildCounterInterconnectsGetMacsecConfigResponse < 3) {
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    checkInterconnectMacsecConfig(o.result!);
  }
  buildCounterInterconnectsGetMacsecConfigResponse--;
}

core.int buildCounterLicense = 0;
api.License buildLicense() {
  final o = api.License();
  buildCounterLicense++;
  if (buildCounterLicense < 3) {
    o.chargesUseFee = true;
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.licenseCode = 'foo';
    o.name = 'foo';
    o.resourceRequirements = buildLicenseResourceRequirements();
    o.selfLink = 'foo';
    o.transferable = true;
  }
  buildCounterLicense--;
  return o;
}

void checkLicense(api.License o) {
  buildCounterLicense++;
  if (buildCounterLicense < 3) {
    unittest.expect(o.chargesUseFee!, unittest.isTrue);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.licenseCode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkLicenseResourceRequirements(o.resourceRequirements!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(o.transferable!, unittest.isTrue);
  }
  buildCounterLicense--;
}

core.List<api.LicenseCodeLicenseAlias> buildUnnamed329() => [
      buildLicenseCodeLicenseAlias(),
      buildLicenseCodeLicenseAlias(),
    ];

void checkUnnamed329(core.List<api.LicenseCodeLicenseAlias> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLicenseCodeLicenseAlias(o[0]);
  checkLicenseCodeLicenseAlias(o[1]);
}

core.int buildCounterLicenseCode = 0;
api.LicenseCode buildLicenseCode() {
  final o = api.LicenseCode();
  buildCounterLicenseCode++;
  if (buildCounterLicenseCode < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.licenseAlias = buildUnnamed329();
    o.name = 'foo';
    o.selfLink = 'foo';
    o.state = 'foo';
    o.transferable = true;
  }
  buildCounterLicenseCode--;
  return o;
}

void checkLicenseCode(api.LicenseCode o) {
  buildCounterLicenseCode++;
  if (buildCounterLicenseCode < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkUnnamed329(o.licenseAlias!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
    unittest.expect(o.transferable!, unittest.isTrue);
  }
  buildCounterLicenseCode--;
}

core.int buildCounterLicenseCodeLicenseAlias = 0;
api.LicenseCodeLicenseAlias buildLicenseCodeLicenseAlias() {
  final o = api.LicenseCodeLicenseAlias();
  buildCounterLicenseCodeLicenseAlias++;
  if (buildCounterLicenseCodeLicenseAlias < 3) {
    o.description = 'foo';
    o.selfLink = 'foo';
  }
  buildCounterLicenseCodeLicenseAlias--;
  return o;
}

void checkLicenseCodeLicenseAlias(api.LicenseCodeLicenseAlias o) {
  buildCounterLicenseCodeLicenseAlias++;
  if (buildCounterLicenseCodeLicenseAlias < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
  }
  buildCounterLicenseCodeLicenseAlias--;
}

core.int buildCounterLicenseResourceCommitment = 0;
api.LicenseResourceCommitment buildLicenseResourceCommitment() {
  final o = api.LicenseResourceCommitment();
  buildCounterLicenseResourceCommitment++;
  if (buildCounterLicenseResourceCommitment < 3) {
    o.amount = 'foo';
    o.coresPerLicense = 'foo';
    o.license = 'foo';
  }
  buildCounterLicenseResourceCommitment--;
  return o;
}

void checkLicenseResourceCommitment(api.LicenseResourceCommitment o) {
  buildCounterLicenseResourceCommitment++;
  if (buildCounterLicenseResourceCommitment < 3) {
    unittest.expect(
      o.amount!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.coresPerLicense!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.license!,
      unittest.equals('foo'),
    );
  }
  buildCounterLicenseResourceCommitment--;
}

core.int buildCounterLicenseResourceRequirements = 0;
api.LicenseResourceRequirements buildLicenseResourceRequirements() {
  final o = api.LicenseResourceRequirements();
  buildCounterLicenseResourceRequirements++;
  if (buildCounterLicenseResourceRequirements < 3) {
    o.minGuestCpuCount = 42;
    o.minMemoryMb = 42;
  }
  buildCounterLicenseResourceRequirements--;
  return o;
}

void checkLicenseResourceRequirements(api.LicenseResourceRequirements o) {
  buildCounterLicenseResourceRequirements++;
  if (buildCounterLicenseResourceRequirements < 3) {
    unittest.expect(
      o.minGuestCpuCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minMemoryMb!,
      unittest.equals(42),
    );
  }
  buildCounterLicenseResourceRequirements--;
}

core.List<api.License> buildUnnamed330() => [
      buildLicense(),
      buildLicense(),
    ];

void checkUnnamed330(core.List<api.License> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLicense(o[0]);
  checkLicense(o[1]);
}

core.int buildCounterLicensesListResponseWarningData = 0;
api.LicensesListResponseWarningData buildLicensesListResponseWarningData() {
  final o = api.LicensesListResponseWarningData();
  buildCounterLicensesListResponseWarningData++;
  if (buildCounterLicensesListResponseWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterLicensesListResponseWarningData--;
  return o;
}

void checkLicensesListResponseWarningData(
    api.LicensesListResponseWarningData o) {
  buildCounterLicensesListResponseWarningData++;
  if (buildCounterLicensesListResponseWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterLicensesListResponseWarningData--;
}

core.List<api.LicensesListResponseWarningData> buildUnnamed331() => [
      buildLicensesListResponseWarningData(),
      buildLicensesListResponseWarningData(),
    ];

void checkUnnamed331(core.List<api.LicensesListResponseWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLicensesListResponseWarningData(o[0]);
  checkLicensesListResponseWarningData(o[1]);
}

core.int buildCounterLicensesListResponseWarning = 0;
api.LicensesListResponseWarning buildLicensesListResponseWarning() {
  final o = api.LicensesListResponseWarning();
  buildCounterLicensesListResponseWarning++;
  if (buildCounterLicensesListResponseWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed331();
    o.message = 'foo';
  }
  buildCounterLicensesListResponseWarning--;
  return o;
}

void checkLicensesListResponseWarning(api.LicensesListResponseWarning o) {
  buildCounterLicensesListResponseWarning++;
  if (buildCounterLicensesListResponseWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed331(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterLicensesListResponseWarning--;
}

core.int buildCounterLicensesListResponse = 0;
api.LicensesListResponse buildLicensesListResponse() {
  final o = api.LicensesListResponse();
  buildCounterLicensesListResponse++;
  if (buildCounterLicensesListResponse < 3) {
    o.id = 'foo';
    o.items = buildUnnamed330();
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildLicensesListResponseWarning();
  }
  buildCounterLicensesListResponse--;
  return o;
}

void checkLicensesListResponse(api.LicensesListResponse o) {
  buildCounterLicensesListResponse++;
  if (buildCounterLicensesListResponse < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed330(o.items!);
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkLicensesListResponseWarning(o.warning!);
  }
  buildCounterLicensesListResponse--;
}

core.int buildCounterLocalDisk = 0;
api.LocalDisk buildLocalDisk() {
  final o = api.LocalDisk();
  buildCounterLocalDisk++;
  if (buildCounterLocalDisk < 3) {
    o.diskCount = 42;
    o.diskSizeGb = 42;
    o.diskType = 'foo';
  }
  buildCounterLocalDisk--;
  return o;
}

void checkLocalDisk(api.LocalDisk o) {
  buildCounterLocalDisk++;
  if (buildCounterLocalDisk < 3) {
    unittest.expect(
      o.diskCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.diskSizeGb!,
      unittest.equals(42),
    );
    unittest.expect(
      o.diskType!,
      unittest.equals('foo'),
    );
  }
  buildCounterLocalDisk--;
}

core.int buildCounterLocalizedMessage = 0;
api.LocalizedMessage buildLocalizedMessage() {
  final o = api.LocalizedMessage();
  buildCounterLocalizedMessage++;
  if (buildCounterLocalizedMessage < 3) {
    o.locale = 'foo';
    o.message = 'foo';
  }
  buildCounterLocalizedMessage--;
  return o;
}

void checkLocalizedMessage(api.LocalizedMessage o) {
  buildCounterLocalizedMessage++;
  if (buildCounterLocalizedMessage < 3) {
    unittest.expect(
      o.locale!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterLocalizedMessage--;
}

core.Map<core.String, api.LocationPolicyLocation> buildUnnamed332() => {
      'x': buildLocationPolicyLocation(),
      'y': buildLocationPolicyLocation(),
    };

void checkUnnamed332(core.Map<core.String, api.LocationPolicyLocation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLocationPolicyLocation(o['x']!);
  checkLocationPolicyLocation(o['y']!);
}

core.int buildCounterLocationPolicy = 0;
api.LocationPolicy buildLocationPolicy() {
  final o = api.LocationPolicy();
  buildCounterLocationPolicy++;
  if (buildCounterLocationPolicy < 3) {
    o.locations = buildUnnamed332();
    o.targetShape = 'foo';
  }
  buildCounterLocationPolicy--;
  return o;
}

void checkLocationPolicy(api.LocationPolicy o) {
  buildCounterLocationPolicy++;
  if (buildCounterLocationPolicy < 3) {
    checkUnnamed332(o.locations!);
    unittest.expect(
      o.targetShape!,
      unittest.equals('foo'),
    );
  }
  buildCounterLocationPolicy--;
}

core.int buildCounterLocationPolicyLocation = 0;
api.LocationPolicyLocation buildLocationPolicyLocation() {
  final o = api.LocationPolicyLocation();
  buildCounterLocationPolicyLocation++;
  if (buildCounterLocationPolicyLocation < 3) {
    o.constraints = buildLocationPolicyLocationConstraints();
    o.preference = 'foo';
  }
  buildCounterLocationPolicyLocation--;
  return o;
}

void checkLocationPolicyLocation(api.LocationPolicyLocation o) {
  buildCounterLocationPolicyLocation++;
  if (buildCounterLocationPolicyLocation < 3) {
    checkLocationPolicyLocationConstraints(o.constraints!);
    unittest.expect(
      o.preference!,
      unittest.equals('foo'),
    );
  }
  buildCounterLocationPolicyLocation--;
}

core.int buildCounterLocationPolicyLocationConstraints = 0;
api.LocationPolicyLocationConstraints buildLocationPolicyLocationConstraints() {
  final o = api.LocationPolicyLocationConstraints();
  buildCounterLocationPolicyLocationConstraints++;
  if (buildCounterLocationPolicyLocationConstraints < 3) {
    o.maxCount = 42;
  }
  buildCounterLocationPolicyLocationConstraints--;
  return o;
}

void checkLocationPolicyLocationConstraints(
    api.LocationPolicyLocationConstraints o) {
  buildCounterLocationPolicyLocationConstraints++;
  if (buildCounterLocationPolicyLocationConstraints < 3) {
    unittest.expect(
      o.maxCount!,
      unittest.equals(42),
    );
  }
  buildCounterLocationPolicyLocationConstraints--;
}

core.int buildCounterLogConfig = 0;
api.LogConfig buildLogConfig() {
  final o = api.LogConfig();
  buildCounterLogConfig++;
  if (buildCounterLogConfig < 3) {
    o.cloudAudit = buildLogConfigCloudAuditOptions();
    o.counter = buildLogConfigCounterOptions();
    o.dataAccess = buildLogConfigDataAccessOptions();
  }
  buildCounterLogConfig--;
  return o;
}

void checkLogConfig(api.LogConfig o) {
  buildCounterLogConfig++;
  if (buildCounterLogConfig < 3) {
    checkLogConfigCloudAuditOptions(o.cloudAudit!);
    checkLogConfigCounterOptions(o.counter!);
    checkLogConfigDataAccessOptions(o.dataAccess!);
  }
  buildCounterLogConfig--;
}

core.int buildCounterLogConfigCloudAuditOptions = 0;
api.LogConfigCloudAuditOptions buildLogConfigCloudAuditOptions() {
  final o = api.LogConfigCloudAuditOptions();
  buildCounterLogConfigCloudAuditOptions++;
  if (buildCounterLogConfigCloudAuditOptions < 3) {
    o.authorizationLoggingOptions = buildAuthorizationLoggingOptions();
    o.logName = 'foo';
  }
  buildCounterLogConfigCloudAuditOptions--;
  return o;
}

void checkLogConfigCloudAuditOptions(api.LogConfigCloudAuditOptions o) {
  buildCounterLogConfigCloudAuditOptions++;
  if (buildCounterLogConfigCloudAuditOptions < 3) {
    checkAuthorizationLoggingOptions(o.authorizationLoggingOptions!);
    unittest.expect(
      o.logName!,
      unittest.equals('foo'),
    );
  }
  buildCounterLogConfigCloudAuditOptions--;
}

core.List<api.LogConfigCounterOptionsCustomField> buildUnnamed333() => [
      buildLogConfigCounterOptionsCustomField(),
      buildLogConfigCounterOptionsCustomField(),
    ];

void checkUnnamed333(core.List<api.LogConfigCounterOptionsCustomField> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLogConfigCounterOptionsCustomField(o[0]);
  checkLogConfigCounterOptionsCustomField(o[1]);
}

core.int buildCounterLogConfigCounterOptions = 0;
api.LogConfigCounterOptions buildLogConfigCounterOptions() {
  final o = api.LogConfigCounterOptions();
  buildCounterLogConfigCounterOptions++;
  if (buildCounterLogConfigCounterOptions < 3) {
    o.customFields = buildUnnamed333();
    o.field = 'foo';
    o.metric = 'foo';
  }
  buildCounterLogConfigCounterOptions--;
  return o;
}

void checkLogConfigCounterOptions(api.LogConfigCounterOptions o) {
  buildCounterLogConfigCounterOptions++;
  if (buildCounterLogConfigCounterOptions < 3) {
    checkUnnamed333(o.customFields!);
    unittest.expect(
      o.field!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.metric!,
      unittest.equals('foo'),
    );
  }
  buildCounterLogConfigCounterOptions--;
}

core.int buildCounterLogConfigCounterOptionsCustomField = 0;
api.LogConfigCounterOptionsCustomField
    buildLogConfigCounterOptionsCustomField() {
  final o = api.LogConfigCounterOptionsCustomField();
  buildCounterLogConfigCounterOptionsCustomField++;
  if (buildCounterLogConfigCounterOptionsCustomField < 3) {
    o.name = 'foo';
    o.value = 'foo';
  }
  buildCounterLogConfigCounterOptionsCustomField--;
  return o;
}

void checkLogConfigCounterOptionsCustomField(
    api.LogConfigCounterOptionsCustomField o) {
  buildCounterLogConfigCounterOptionsCustomField++;
  if (buildCounterLogConfigCounterOptionsCustomField < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterLogConfigCounterOptionsCustomField--;
}

core.int buildCounterLogConfigDataAccessOptions = 0;
api.LogConfigDataAccessOptions buildLogConfigDataAccessOptions() {
  final o = api.LogConfigDataAccessOptions();
  buildCounterLogConfigDataAccessOptions++;
  if (buildCounterLogConfigDataAccessOptions < 3) {
    o.logMode = 'foo';
  }
  buildCounterLogConfigDataAccessOptions--;
  return o;
}

void checkLogConfigDataAccessOptions(api.LogConfigDataAccessOptions o) {
  buildCounterLogConfigDataAccessOptions++;
  if (buildCounterLogConfigDataAccessOptions < 3) {
    unittest.expect(
      o.logMode!,
      unittest.equals('foo'),
    );
  }
  buildCounterLogConfigDataAccessOptions--;
}

core.List<api.SavedDisk> buildUnnamed334() => [
      buildSavedDisk(),
      buildSavedDisk(),
    ];

void checkUnnamed334(core.List<api.SavedDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSavedDisk(o[0]);
  checkSavedDisk(o[1]);
}

core.List<api.SourceDiskEncryptionKey> buildUnnamed335() => [
      buildSourceDiskEncryptionKey(),
      buildSourceDiskEncryptionKey(),
    ];

void checkUnnamed335(core.List<api.SourceDiskEncryptionKey> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSourceDiskEncryptionKey(o[0]);
  checkSourceDiskEncryptionKey(o[1]);
}

core.List<core.String> buildUnnamed336() => [
      'foo',
      'foo',
    ];

void checkUnnamed336(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterMachineImage = 0;
api.MachineImage buildMachineImage() {
  final o = api.MachineImage();
  buildCounterMachineImage++;
  if (buildCounterMachineImage < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.guestFlush = true;
    o.id = 'foo';
    o.instanceProperties = buildInstanceProperties();
    o.kind = 'foo';
    o.machineImageEncryptionKey = buildCustomerEncryptionKey();
    o.name = 'foo';
    o.satisfiesPzs = true;
    o.savedDisks = buildUnnamed334();
    o.selfLink = 'foo';
    o.sourceDiskEncryptionKeys = buildUnnamed335();
    o.sourceInstance = 'foo';
    o.sourceInstanceProperties = buildSourceInstanceProperties();
    o.status = 'foo';
    o.storageLocations = buildUnnamed336();
    o.totalStorageBytes = 'foo';
  }
  buildCounterMachineImage--;
  return o;
}

void checkMachineImage(api.MachineImage o) {
  buildCounterMachineImage++;
  if (buildCounterMachineImage < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(o.guestFlush!, unittest.isTrue);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkInstanceProperties(o.instanceProperties!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.machineImageEncryptionKey!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(o.satisfiesPzs!, unittest.isTrue);
    checkUnnamed334(o.savedDisks!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed335(o.sourceDiskEncryptionKeys!);
    unittest.expect(
      o.sourceInstance!,
      unittest.equals('foo'),
    );
    checkSourceInstanceProperties(o.sourceInstanceProperties!);
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    checkUnnamed336(o.storageLocations!);
    unittest.expect(
      o.totalStorageBytes!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineImage--;
}

core.List<api.MachineImage> buildUnnamed337() => [
      buildMachineImage(),
      buildMachineImage(),
    ];

void checkUnnamed337(core.List<api.MachineImage> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineImage(o[0]);
  checkMachineImage(o[1]);
}

core.int buildCounterMachineImageListWarningData = 0;
api.MachineImageListWarningData buildMachineImageListWarningData() {
  final o = api.MachineImageListWarningData();
  buildCounterMachineImageListWarningData++;
  if (buildCounterMachineImageListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterMachineImageListWarningData--;
  return o;
}

void checkMachineImageListWarningData(api.MachineImageListWarningData o) {
  buildCounterMachineImageListWarningData++;
  if (buildCounterMachineImageListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineImageListWarningData--;
}

core.List<api.MachineImageListWarningData> buildUnnamed338() => [
      buildMachineImageListWarningData(),
      buildMachineImageListWarningData(),
    ];

void checkUnnamed338(core.List<api.MachineImageListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineImageListWarningData(o[0]);
  checkMachineImageListWarningData(o[1]);
}

core.int buildCounterMachineImageListWarning = 0;
api.MachineImageListWarning buildMachineImageListWarning() {
  final o = api.MachineImageListWarning();
  buildCounterMachineImageListWarning++;
  if (buildCounterMachineImageListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed338();
    o.message = 'foo';
  }
  buildCounterMachineImageListWarning--;
  return o;
}

void checkMachineImageListWarning(api.MachineImageListWarning o) {
  buildCounterMachineImageListWarning++;
  if (buildCounterMachineImageListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed338(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineImageListWarning--;
}

core.int buildCounterMachineImageList = 0;
api.MachineImageList buildMachineImageList() {
  final o = api.MachineImageList();
  buildCounterMachineImageList++;
  if (buildCounterMachineImageList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed337();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildMachineImageListWarning();
  }
  buildCounterMachineImageList--;
  return o;
}

void checkMachineImageList(api.MachineImageList o) {
  buildCounterMachineImageList++;
  if (buildCounterMachineImageList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed337(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkMachineImageListWarning(o.warning!);
  }
  buildCounterMachineImageList--;
}

core.int buildCounterMachineTypeAccelerators = 0;
api.MachineTypeAccelerators buildMachineTypeAccelerators() {
  final o = api.MachineTypeAccelerators();
  buildCounterMachineTypeAccelerators++;
  if (buildCounterMachineTypeAccelerators < 3) {
    o.guestAcceleratorCount = 42;
    o.guestAcceleratorType = 'foo';
  }
  buildCounterMachineTypeAccelerators--;
  return o;
}

void checkMachineTypeAccelerators(api.MachineTypeAccelerators o) {
  buildCounterMachineTypeAccelerators++;
  if (buildCounterMachineTypeAccelerators < 3) {
    unittest.expect(
      o.guestAcceleratorCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.guestAcceleratorType!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineTypeAccelerators--;
}

core.List<api.MachineTypeAccelerators> buildUnnamed339() => [
      buildMachineTypeAccelerators(),
      buildMachineTypeAccelerators(),
    ];

void checkUnnamed339(core.List<api.MachineTypeAccelerators> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypeAccelerators(o[0]);
  checkMachineTypeAccelerators(o[1]);
}

core.int buildCounterMachineTypeScratchDisks = 0;
api.MachineTypeScratchDisks buildMachineTypeScratchDisks() {
  final o = api.MachineTypeScratchDisks();
  buildCounterMachineTypeScratchDisks++;
  if (buildCounterMachineTypeScratchDisks < 3) {
    o.diskGb = 42;
  }
  buildCounterMachineTypeScratchDisks--;
  return o;
}

void checkMachineTypeScratchDisks(api.MachineTypeScratchDisks o) {
  buildCounterMachineTypeScratchDisks++;
  if (buildCounterMachineTypeScratchDisks < 3) {
    unittest.expect(
      o.diskGb!,
      unittest.equals(42),
    );
  }
  buildCounterMachineTypeScratchDisks--;
}

core.List<api.MachineTypeScratchDisks> buildUnnamed340() => [
      buildMachineTypeScratchDisks(),
      buildMachineTypeScratchDisks(),
    ];

void checkUnnamed340(core.List<api.MachineTypeScratchDisks> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypeScratchDisks(o[0]);
  checkMachineTypeScratchDisks(o[1]);
}

core.int buildCounterMachineType = 0;
api.MachineType buildMachineType() {
  final o = api.MachineType();
  buildCounterMachineType++;
  if (buildCounterMachineType < 3) {
    o.accelerators = buildUnnamed339();
    o.creationTimestamp = 'foo';
    o.deprecated = buildDeprecationStatus();
    o.description = 'foo';
    o.guestCpus = 42;
    o.id = 'foo';
    o.imageSpaceGb = 42;
    o.isSharedCpu = true;
    o.kind = 'foo';
    o.maximumPersistentDisks = 42;
    o.maximumPersistentDisksSizeGb = 'foo';
    o.memoryMb = 42;
    o.name = 'foo';
    o.scratchDisks = buildUnnamed340();
    o.selfLink = 'foo';
    o.zone = 'foo';
  }
  buildCounterMachineType--;
  return o;
}

void checkMachineType(api.MachineType o) {
  buildCounterMachineType++;
  if (buildCounterMachineType < 3) {
    checkUnnamed339(o.accelerators!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkDeprecationStatus(o.deprecated!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.guestCpus!,
      unittest.equals(42),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.imageSpaceGb!,
      unittest.equals(42),
    );
    unittest.expect(o.isSharedCpu!, unittest.isTrue);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.maximumPersistentDisks!,
      unittest.equals(42),
    );
    unittest.expect(
      o.maximumPersistentDisksSizeGb!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.memoryMb!,
      unittest.equals(42),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed340(o.scratchDisks!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineType--;
}

core.Map<core.String, api.MachineTypesScopedList> buildUnnamed341() => {
      'x': buildMachineTypesScopedList(),
      'y': buildMachineTypesScopedList(),
    };

void checkUnnamed341(core.Map<core.String, api.MachineTypesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypesScopedList(o['x']!);
  checkMachineTypesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed342() => [
      'foo',
      'foo',
    ];

void checkUnnamed342(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterMachineTypeAggregatedListWarningData = 0;
api.MachineTypeAggregatedListWarningData
    buildMachineTypeAggregatedListWarningData() {
  final o = api.MachineTypeAggregatedListWarningData();
  buildCounterMachineTypeAggregatedListWarningData++;
  if (buildCounterMachineTypeAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterMachineTypeAggregatedListWarningData--;
  return o;
}

void checkMachineTypeAggregatedListWarningData(
    api.MachineTypeAggregatedListWarningData o) {
  buildCounterMachineTypeAggregatedListWarningData++;
  if (buildCounterMachineTypeAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineTypeAggregatedListWarningData--;
}

core.List<api.MachineTypeAggregatedListWarningData> buildUnnamed343() => [
      buildMachineTypeAggregatedListWarningData(),
      buildMachineTypeAggregatedListWarningData(),
    ];

void checkUnnamed343(core.List<api.MachineTypeAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypeAggregatedListWarningData(o[0]);
  checkMachineTypeAggregatedListWarningData(o[1]);
}

core.int buildCounterMachineTypeAggregatedListWarning = 0;
api.MachineTypeAggregatedListWarning buildMachineTypeAggregatedListWarning() {
  final o = api.MachineTypeAggregatedListWarning();
  buildCounterMachineTypeAggregatedListWarning++;
  if (buildCounterMachineTypeAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed343();
    o.message = 'foo';
  }
  buildCounterMachineTypeAggregatedListWarning--;
  return o;
}

void checkMachineTypeAggregatedListWarning(
    api.MachineTypeAggregatedListWarning o) {
  buildCounterMachineTypeAggregatedListWarning++;
  if (buildCounterMachineTypeAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed343(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineTypeAggregatedListWarning--;
}

core.int buildCounterMachineTypeAggregatedList = 0;
api.MachineTypeAggregatedList buildMachineTypeAggregatedList() {
  final o = api.MachineTypeAggregatedList();
  buildCounterMachineTypeAggregatedList++;
  if (buildCounterMachineTypeAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed341();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed342();
    o.warning = buildMachineTypeAggregatedListWarning();
  }
  buildCounterMachineTypeAggregatedList--;
  return o;
}

void checkMachineTypeAggregatedList(api.MachineTypeAggregatedList o) {
  buildCounterMachineTypeAggregatedList++;
  if (buildCounterMachineTypeAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed341(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed342(o.unreachables!);
    checkMachineTypeAggregatedListWarning(o.warning!);
  }
  buildCounterMachineTypeAggregatedList--;
}

core.List<api.MachineType> buildUnnamed344() => [
      buildMachineType(),
      buildMachineType(),
    ];

void checkUnnamed344(core.List<api.MachineType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineType(o[0]);
  checkMachineType(o[1]);
}

core.int buildCounterMachineTypeListWarningData = 0;
api.MachineTypeListWarningData buildMachineTypeListWarningData() {
  final o = api.MachineTypeListWarningData();
  buildCounterMachineTypeListWarningData++;
  if (buildCounterMachineTypeListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterMachineTypeListWarningData--;
  return o;
}

void checkMachineTypeListWarningData(api.MachineTypeListWarningData o) {
  buildCounterMachineTypeListWarningData++;
  if (buildCounterMachineTypeListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineTypeListWarningData--;
}

core.List<api.MachineTypeListWarningData> buildUnnamed345() => [
      buildMachineTypeListWarningData(),
      buildMachineTypeListWarningData(),
    ];

void checkUnnamed345(core.List<api.MachineTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypeListWarningData(o[0]);
  checkMachineTypeListWarningData(o[1]);
}

core.int buildCounterMachineTypeListWarning = 0;
api.MachineTypeListWarning buildMachineTypeListWarning() {
  final o = api.MachineTypeListWarning();
  buildCounterMachineTypeListWarning++;
  if (buildCounterMachineTypeListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed345();
    o.message = 'foo';
  }
  buildCounterMachineTypeListWarning--;
  return o;
}

void checkMachineTypeListWarning(api.MachineTypeListWarning o) {
  buildCounterMachineTypeListWarning++;
  if (buildCounterMachineTypeListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed345(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineTypeListWarning--;
}

core.int buildCounterMachineTypeList = 0;
api.MachineTypeList buildMachineTypeList() {
  final o = api.MachineTypeList();
  buildCounterMachineTypeList++;
  if (buildCounterMachineTypeList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed344();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildMachineTypeListWarning();
  }
  buildCounterMachineTypeList--;
  return o;
}

void checkMachineTypeList(api.MachineTypeList o) {
  buildCounterMachineTypeList++;
  if (buildCounterMachineTypeList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed344(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkMachineTypeListWarning(o.warning!);
  }
  buildCounterMachineTypeList--;
}

core.List<api.MachineType> buildUnnamed346() => [
      buildMachineType(),
      buildMachineType(),
    ];

void checkUnnamed346(core.List<api.MachineType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineType(o[0]);
  checkMachineType(o[1]);
}

core.int buildCounterMachineTypesScopedListWarningData = 0;
api.MachineTypesScopedListWarningData buildMachineTypesScopedListWarningData() {
  final o = api.MachineTypesScopedListWarningData();
  buildCounterMachineTypesScopedListWarningData++;
  if (buildCounterMachineTypesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterMachineTypesScopedListWarningData--;
  return o;
}

void checkMachineTypesScopedListWarningData(
    api.MachineTypesScopedListWarningData o) {
  buildCounterMachineTypesScopedListWarningData++;
  if (buildCounterMachineTypesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineTypesScopedListWarningData--;
}

core.List<api.MachineTypesScopedListWarningData> buildUnnamed347() => [
      buildMachineTypesScopedListWarningData(),
      buildMachineTypesScopedListWarningData(),
    ];

void checkUnnamed347(core.List<api.MachineTypesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMachineTypesScopedListWarningData(o[0]);
  checkMachineTypesScopedListWarningData(o[1]);
}

core.int buildCounterMachineTypesScopedListWarning = 0;
api.MachineTypesScopedListWarning buildMachineTypesScopedListWarning() {
  final o = api.MachineTypesScopedListWarning();
  buildCounterMachineTypesScopedListWarning++;
  if (buildCounterMachineTypesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed347();
    o.message = 'foo';
  }
  buildCounterMachineTypesScopedListWarning--;
  return o;
}

void checkMachineTypesScopedListWarning(api.MachineTypesScopedListWarning o) {
  buildCounterMachineTypesScopedListWarning++;
  if (buildCounterMachineTypesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed347(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterMachineTypesScopedListWarning--;
}

core.int buildCounterMachineTypesScopedList = 0;
api.MachineTypesScopedList buildMachineTypesScopedList() {
  final o = api.MachineTypesScopedList();
  buildCounterMachineTypesScopedList++;
  if (buildCounterMachineTypesScopedList < 3) {
    o.machineTypes = buildUnnamed346();
    o.warning = buildMachineTypesScopedListWarning();
  }
  buildCounterMachineTypesScopedList--;
  return o;
}

void checkMachineTypesScopedList(api.MachineTypesScopedList o) {
  buildCounterMachineTypesScopedList++;
  if (buildCounterMachineTypesScopedList < 3) {
    checkUnnamed346(o.machineTypes!);
    checkMachineTypesScopedListWarning(o.warning!);
  }
  buildCounterMachineTypesScopedList--;
}

core.List<api.ManagedInstanceInstanceHealth> buildUnnamed348() => [
      buildManagedInstanceInstanceHealth(),
      buildManagedInstanceInstanceHealth(),
    ];

void checkUnnamed348(core.List<api.ManagedInstanceInstanceHealth> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkManagedInstanceInstanceHealth(o[0]);
  checkManagedInstanceInstanceHealth(o[1]);
}

core.int buildCounterManagedInstance = 0;
api.ManagedInstance buildManagedInstance() {
  final o = api.ManagedInstance();
  buildCounterManagedInstance++;
  if (buildCounterManagedInstance < 3) {
    o.currentAction = 'foo';
    o.id = 'foo';
    o.instance = 'foo';
    o.instanceHealth = buildUnnamed348();
    o.instanceStatus = 'foo';
    o.lastAttempt = buildManagedInstanceLastAttempt();
    o.name = 'foo';
    o.preservedStateFromConfig = buildPreservedState();
    o.preservedStateFromPolicy = buildPreservedState();
    o.version = buildManagedInstanceVersion();
  }
  buildCounterManagedInstance--;
  return o;
}

void checkManagedInstance(api.ManagedInstance o) {
  buildCounterManagedInstance++;
  if (buildCounterManagedInstance < 3) {
    unittest.expect(
      o.currentAction!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.instance!,
      unittest.equals('foo'),
    );
    checkUnnamed348(o.instanceHealth!);
    unittest.expect(
      o.instanceStatus!,
      unittest.equals('foo'),
    );
    checkManagedInstanceLastAttempt(o.lastAttempt!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkPreservedState(o.preservedStateFromConfig!);
    checkPreservedState(o.preservedStateFromPolicy!);
    checkManagedInstanceVersion(o.version!);
  }
  buildCounterManagedInstance--;
}

core.int buildCounterManagedInstanceInstanceHealth = 0;
api.ManagedInstanceInstanceHealth buildManagedInstanceInstanceHealth() {
  final o = api.ManagedInstanceInstanceHealth();
  buildCounterManagedInstanceInstanceHealth++;
  if (buildCounterManagedInstanceInstanceHealth < 3) {
    o.detailedHealthState = 'foo';
    o.healthCheck = 'foo';
  }
  buildCounterManagedInstanceInstanceHealth--;
  return o;
}

void checkManagedInstanceInstanceHealth(api.ManagedInstanceInstanceHealth o) {
  buildCounterManagedInstanceInstanceHealth++;
  if (buildCounterManagedInstanceInstanceHealth < 3) {
    unittest.expect(
      o.detailedHealthState!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.healthCheck!,
      unittest.equals('foo'),
    );
  }
  buildCounterManagedInstanceInstanceHealth--;
}

core.int buildCounterManagedInstanceLastAttemptErrorsErrorsErrorDetails = 0;
api.ManagedInstanceLastAttemptErrorsErrorsErrorDetails
    buildManagedInstanceLastAttemptErrorsErrorsErrorDetails() {
  final o = api.ManagedInstanceLastAttemptErrorsErrorsErrorDetails();
  buildCounterManagedInstanceLastAttemptErrorsErrorsErrorDetails++;
  if (buildCounterManagedInstanceLastAttemptErrorsErrorsErrorDetails < 3) {
    o.errorInfo = buildErrorInfo();
    o.help = buildHelp();
    o.localizedMessage = buildLocalizedMessage();
    o.quotaInfo = buildQuotaExceededInfo();
  }
  buildCounterManagedInstanceLastAttemptErrorsErrorsErrorDetails--;
  return o;
}

void checkManagedInstanceLastAttemptErrorsErrorsErrorDetails(
    api.ManagedInstanceLastAttemptErrorsErrorsErrorDetails o) {
  buildCounterManagedInstanceLastAttemptErrorsErrorsErrorDetails++;
  if (buildCounterManagedInstanceLastAttemptErrorsErrorsErrorDetails < 3) {
    checkErrorInfo(o.errorInfo!);
    checkHelp(o.help!);
    checkLocalizedMessage(o.localizedMessage!);
    checkQuotaExceededInfo(o.quotaInfo!);
  }
  buildCounterManagedInstanceLastAttemptErrorsErrorsErrorDetails--;
}

core.List<api.ManagedInstanceLastAttemptErrorsErrorsErrorDetails>
    buildUnnamed349() => [
          buildManagedInstanceLastAttemptErrorsErrorsErrorDetails(),
          buildManagedInstanceLastAttemptErrorsErrorsErrorDetails(),
        ];

void checkUnnamed349(
    core.List<api.ManagedInstanceLastAttemptErrorsErrorsErrorDetails> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkManagedInstanceLastAttemptErrorsErrorsErrorDetails(o[0]);
  checkManagedInstanceLastAttemptErrorsErrorsErrorDetails(o[1]);
}

core.int buildCounterManagedInstanceLastAttemptErrorsErrors = 0;
api.ManagedInstanceLastAttemptErrorsErrors
    buildManagedInstanceLastAttemptErrorsErrors() {
  final o = api.ManagedInstanceLastAttemptErrorsErrors();
  buildCounterManagedInstanceLastAttemptErrorsErrors++;
  if (buildCounterManagedInstanceLastAttemptErrorsErrors < 3) {
    o.code = 'foo';
    o.errorDetails = buildUnnamed349();
    o.location = 'foo';
    o.message = 'foo';
  }
  buildCounterManagedInstanceLastAttemptErrorsErrors--;
  return o;
}

void checkManagedInstanceLastAttemptErrorsErrors(
    api.ManagedInstanceLastAttemptErrorsErrors o) {
  buildCounterManagedInstanceLastAttemptErrorsErrors++;
  if (buildCounterManagedInstanceLastAttemptErrorsErrors < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed349(o.errorDetails!);
    unittest.expect(
      o.location!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterManagedInstanceLastAttemptErrorsErrors--;
}

core.List<api.ManagedInstanceLastAttemptErrorsErrors> buildUnnamed350() => [
      buildManagedInstanceLastAttemptErrorsErrors(),
      buildManagedInstanceLastAttemptErrorsErrors(),
    ];

void checkUnnamed350(core.List<api.ManagedInstanceLastAttemptErrorsErrors> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkManagedInstanceLastAttemptErrorsErrors(o[0]);
  checkManagedInstanceLastAttemptErrorsErrors(o[1]);
}

core.int buildCounterManagedInstanceLastAttemptErrors = 0;
api.ManagedInstanceLastAttemptErrors buildManagedInstanceLastAttemptErrors() {
  final o = api.ManagedInstanceLastAttemptErrors();
  buildCounterManagedInstanceLastAttemptErrors++;
  if (buildCounterManagedInstanceLastAttemptErrors < 3) {
    o.errors = buildUnnamed350();
  }
  buildCounterManagedInstanceLastAttemptErrors--;
  return o;
}

void checkManagedInstanceLastAttemptErrors(
    api.ManagedInstanceLastAttemptErrors o) {
  buildCounterManagedInstanceLastAttemptErrors++;
  if (buildCounterManagedInstanceLastAttemptErrors < 3) {
    checkUnnamed350(o.errors!);
  }
  buildCounterManagedInstanceLastAttemptErrors--;
}

core.int buildCounterManagedInstanceLastAttempt = 0;
api.ManagedInstanceLastAttempt buildManagedInstanceLastAttempt() {
  final o = api.ManagedInstanceLastAttempt();
  buildCounterManagedInstanceLastAttempt++;
  if (buildCounterManagedInstanceLastAttempt < 3) {
    o.errors = buildManagedInstanceLastAttemptErrors();
  }
  buildCounterManagedInstanceLastAttempt--;
  return o;
}

void checkManagedInstanceLastAttempt(api.ManagedInstanceLastAttempt o) {
  buildCounterManagedInstanceLastAttempt++;
  if (buildCounterManagedInstanceLastAttempt < 3) {
    checkManagedInstanceLastAttemptErrors(o.errors!);
  }
  buildCounterManagedInstanceLastAttempt--;
}

core.int buildCounterManagedInstanceVersion = 0;
api.ManagedInstanceVersion buildManagedInstanceVersion() {
  final o = api.ManagedInstanceVersion();
  buildCounterManagedInstanceVersion++;
  if (buildCounterManagedInstanceVersion < 3) {
    o.instanceTemplate = 'foo';
    o.name = 'foo';
  }
  buildCounterManagedInstanceVersion--;
  return o;
}

void checkManagedInstanceVersion(api.ManagedInstanceVersion o) {
  buildCounterManagedInstanceVersion++;
  if (buildCounterManagedInstanceVersion < 3) {
    unittest.expect(
      o.instanceTemplate!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
  }
  buildCounterManagedInstanceVersion--;
}

core.int buildCounterMetadataItems = 0;
api.MetadataItems buildMetadataItems() {
  final o = api.MetadataItems();
  buildCounterMetadataItems++;
  if (buildCounterMetadataItems < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterMetadataItems--;
  return o;
}

void checkMetadataItems(api.MetadataItems o) {
  buildCounterMetadataItems++;
  if (buildCounterMetadataItems < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterMetadataItems--;
}

core.List<api.MetadataItems> buildUnnamed351() => [
      buildMetadataItems(),
      buildMetadataItems(),
    ];

void checkUnnamed351(core.List<api.MetadataItems> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMetadataItems(o[0]);
  checkMetadataItems(o[1]);
}

core.int buildCounterMetadata = 0;
api.Metadata buildMetadata() {
  final o = api.Metadata();
  buildCounterMetadata++;
  if (buildCounterMetadata < 3) {
    o.fingerprint = 'foo';
    o.items = buildUnnamed351();
    o.kind = 'foo';
  }
  buildCounterMetadata--;
  return o;
}

void checkMetadata(api.Metadata o) {
  buildCounterMetadata++;
  if (buildCounterMetadata < 3) {
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed351(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
  }
  buildCounterMetadata--;
}

core.List<api.MetadataFilterLabelMatch> buildUnnamed352() => [
      buildMetadataFilterLabelMatch(),
      buildMetadataFilterLabelMatch(),
    ];

void checkUnnamed352(core.List<api.MetadataFilterLabelMatch> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkMetadataFilterLabelMatch(o[0]);
  checkMetadataFilterLabelMatch(o[1]);
}

core.int buildCounterMetadataFilter = 0;
api.MetadataFilter buildMetadataFilter() {
  final o = api.MetadataFilter();
  buildCounterMetadataFilter++;
  if (buildCounterMetadataFilter < 3) {
    o.filterLabels = buildUnnamed352();
    o.filterMatchCriteria = 'foo';
  }
  buildCounterMetadataFilter--;
  return o;
}

void checkMetadataFilter(api.MetadataFilter o) {
  buildCounterMetadataFilter++;
  if (buildCounterMetadataFilter < 3) {
    checkUnnamed352(o.filterLabels!);
    unittest.expect(
      o.filterMatchCriteria!,
      unittest.equals('foo'),
    );
  }
  buildCounterMetadataFilter--;
}

core.int buildCounterMetadataFilterLabelMatch = 0;
api.MetadataFilterLabelMatch buildMetadataFilterLabelMatch() {
  final o = api.MetadataFilterLabelMatch();
  buildCounterMetadataFilterLabelMatch++;
  if (buildCounterMetadataFilterLabelMatch < 3) {
    o.name = 'foo';
    o.value = 'foo';
  }
  buildCounterMetadataFilterLabelMatch--;
  return o;
}

void checkMetadataFilterLabelMatch(api.MetadataFilterLabelMatch o) {
  buildCounterMetadataFilterLabelMatch++;
  if (buildCounterMetadataFilterLabelMatch < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterMetadataFilterLabelMatch--;
}

core.int buildCounterNamedPort = 0;
api.NamedPort buildNamedPort() {
  final o = api.NamedPort();
  buildCounterNamedPort++;
  if (buildCounterNamedPort < 3) {
    o.name = 'foo';
    o.port = 42;
  }
  buildCounterNamedPort--;
  return o;
}

void checkNamedPort(api.NamedPort o) {
  buildCounterNamedPort++;
  if (buildCounterNamedPort < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
  }
  buildCounterNamedPort--;
}

core.List<api.NatIpInfoNatIpInfoMapping> buildUnnamed353() => [
      buildNatIpInfoNatIpInfoMapping(),
      buildNatIpInfoNatIpInfoMapping(),
    ];

void checkUnnamed353(core.List<api.NatIpInfoNatIpInfoMapping> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNatIpInfoNatIpInfoMapping(o[0]);
  checkNatIpInfoNatIpInfoMapping(o[1]);
}

core.int buildCounterNatIpInfo = 0;
api.NatIpInfo buildNatIpInfo() {
  final o = api.NatIpInfo();
  buildCounterNatIpInfo++;
  if (buildCounterNatIpInfo < 3) {
    o.natIpInfoMappings = buildUnnamed353();
    o.natName = 'foo';
  }
  buildCounterNatIpInfo--;
  return o;
}

void checkNatIpInfo(api.NatIpInfo o) {
  buildCounterNatIpInfo++;
  if (buildCounterNatIpInfo < 3) {
    checkUnnamed353(o.natIpInfoMappings!);
    unittest.expect(
      o.natName!,
      unittest.equals('foo'),
    );
  }
  buildCounterNatIpInfo--;
}

core.int buildCounterNatIpInfoNatIpInfoMapping = 0;
api.NatIpInfoNatIpInfoMapping buildNatIpInfoNatIpInfoMapping() {
  final o = api.NatIpInfoNatIpInfoMapping();
  buildCounterNatIpInfoNatIpInfoMapping++;
  if (buildCounterNatIpInfoNatIpInfoMapping < 3) {
    o.mode = 'foo';
    o.natIp = 'foo';
    o.usage = 'foo';
  }
  buildCounterNatIpInfoNatIpInfoMapping--;
  return o;
}

void checkNatIpInfoNatIpInfoMapping(api.NatIpInfoNatIpInfoMapping o) {
  buildCounterNatIpInfoNatIpInfoMapping++;
  if (buildCounterNatIpInfoNatIpInfoMapping < 3) {
    unittest.expect(
      o.mode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.natIp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.usage!,
      unittest.equals('foo'),
    );
  }
  buildCounterNatIpInfoNatIpInfoMapping--;
}

core.List<api.NatIpInfo> buildUnnamed354() => [
      buildNatIpInfo(),
      buildNatIpInfo(),
    ];

void checkUnnamed354(core.List<api.NatIpInfo> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNatIpInfo(o[0]);
  checkNatIpInfo(o[1]);
}

core.int buildCounterNatIpInfoResponse = 0;
api.NatIpInfoResponse buildNatIpInfoResponse() {
  final o = api.NatIpInfoResponse();
  buildCounterNatIpInfoResponse++;
  if (buildCounterNatIpInfoResponse < 3) {
    o.result = buildUnnamed354();
  }
  buildCounterNatIpInfoResponse--;
  return o;
}

void checkNatIpInfoResponse(api.NatIpInfoResponse o) {
  buildCounterNatIpInfoResponse++;
  if (buildCounterNatIpInfoResponse < 3) {
    checkUnnamed354(o.result!);
  }
  buildCounterNatIpInfoResponse--;
}

core.List<api.NetworkPeering> buildUnnamed355() => [
      buildNetworkPeering(),
      buildNetworkPeering(),
    ];

void checkUnnamed355(core.List<api.NetworkPeering> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkPeering(o[0]);
  checkNetworkPeering(o[1]);
}

core.List<core.String> buildUnnamed356() => [
      'foo',
      'foo',
    ];

void checkUnnamed356(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNetwork = 0;
api.Network buildNetwork() {
  final o = api.Network();
  buildCounterNetwork++;
  if (buildCounterNetwork < 3) {
    o.IPv4Range = 'foo';
    o.autoCreateSubnetworks = true;
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.enableUlaInternalIpv6 = true;
    o.firewallPolicy = 'foo';
    o.gatewayIPv4 = 'foo';
    o.id = 'foo';
    o.internalIpv6Range = 'foo';
    o.kind = 'foo';
    o.mtu = 42;
    o.name = 'foo';
    o.networkFirewallPolicyEnforcementOrder = 'foo';
    o.peerings = buildUnnamed355();
    o.routingConfig = buildNetworkRoutingConfig();
    o.selfLink = 'foo';
    o.selfLinkWithId = 'foo';
    o.subnetworks = buildUnnamed356();
  }
  buildCounterNetwork--;
  return o;
}

void checkNetwork(api.Network o) {
  buildCounterNetwork++;
  if (buildCounterNetwork < 3) {
    unittest.expect(
      o.IPv4Range!,
      unittest.equals('foo'),
    );
    unittest.expect(o.autoCreateSubnetworks!, unittest.isTrue);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(o.enableUlaInternalIpv6!, unittest.isTrue);
    unittest.expect(
      o.firewallPolicy!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.gatewayIPv4!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.internalIpv6Range!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.mtu!,
      unittest.equals(42),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.networkFirewallPolicyEnforcementOrder!,
      unittest.equals('foo'),
    );
    checkUnnamed355(o.peerings!);
    checkNetworkRoutingConfig(o.routingConfig!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLinkWithId!,
      unittest.equals('foo'),
    );
    checkUnnamed356(o.subnetworks!);
  }
  buildCounterNetwork--;
}

core.List<api.NetworkAttachmentConnectedEndpoint> buildUnnamed357() => [
      buildNetworkAttachmentConnectedEndpoint(),
      buildNetworkAttachmentConnectedEndpoint(),
    ];

void checkUnnamed357(core.List<api.NetworkAttachmentConnectedEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkAttachmentConnectedEndpoint(o[0]);
  checkNetworkAttachmentConnectedEndpoint(o[1]);
}

core.List<core.String> buildUnnamed358() => [
      'foo',
      'foo',
    ];

void checkUnnamed358(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed359() => [
      'foo',
      'foo',
    ];

void checkUnnamed359(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed360() => [
      'foo',
      'foo',
    ];

void checkUnnamed360(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNetworkAttachment = 0;
api.NetworkAttachment buildNetworkAttachment() {
  final o = api.NetworkAttachment();
  buildCounterNetworkAttachment++;
  if (buildCounterNetworkAttachment < 3) {
    o.connectionEndpoints = buildUnnamed357();
    o.connectionPreference = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.network = 'foo';
    o.producerAcceptLists = buildUnnamed358();
    o.producerRejectLists = buildUnnamed359();
    o.region = 'foo';
    o.selfLink = 'foo';
    o.selfLinkWithId = 'foo';
    o.subnetworks = buildUnnamed360();
  }
  buildCounterNetworkAttachment--;
  return o;
}

void checkNetworkAttachment(api.NetworkAttachment o) {
  buildCounterNetworkAttachment++;
  if (buildCounterNetworkAttachment < 3) {
    checkUnnamed357(o.connectionEndpoints!);
    unittest.expect(
      o.connectionPreference!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    checkUnnamed358(o.producerAcceptLists!);
    checkUnnamed359(o.producerRejectLists!);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLinkWithId!,
      unittest.equals('foo'),
    );
    checkUnnamed360(o.subnetworks!);
  }
  buildCounterNetworkAttachment--;
}

core.Map<core.String, api.NetworkAttachmentsScopedList> buildUnnamed361() => {
      'x': buildNetworkAttachmentsScopedList(),
      'y': buildNetworkAttachmentsScopedList(),
    };

void checkUnnamed361(
    core.Map<core.String, api.NetworkAttachmentsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkAttachmentsScopedList(o['x']!);
  checkNetworkAttachmentsScopedList(o['y']!);
}

core.int buildCounterNetworkAttachmentAggregatedListWarningData = 0;
api.NetworkAttachmentAggregatedListWarningData
    buildNetworkAttachmentAggregatedListWarningData() {
  final o = api.NetworkAttachmentAggregatedListWarningData();
  buildCounterNetworkAttachmentAggregatedListWarningData++;
  if (buildCounterNetworkAttachmentAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkAttachmentAggregatedListWarningData--;
  return o;
}

void checkNetworkAttachmentAggregatedListWarningData(
    api.NetworkAttachmentAggregatedListWarningData o) {
  buildCounterNetworkAttachmentAggregatedListWarningData++;
  if (buildCounterNetworkAttachmentAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkAttachmentAggregatedListWarningData--;
}

core.List<api.NetworkAttachmentAggregatedListWarningData> buildUnnamed362() => [
      buildNetworkAttachmentAggregatedListWarningData(),
      buildNetworkAttachmentAggregatedListWarningData(),
    ];

void checkUnnamed362(
    core.List<api.NetworkAttachmentAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkAttachmentAggregatedListWarningData(o[0]);
  checkNetworkAttachmentAggregatedListWarningData(o[1]);
}

core.int buildCounterNetworkAttachmentAggregatedListWarning = 0;
api.NetworkAttachmentAggregatedListWarning
    buildNetworkAttachmentAggregatedListWarning() {
  final o = api.NetworkAttachmentAggregatedListWarning();
  buildCounterNetworkAttachmentAggregatedListWarning++;
  if (buildCounterNetworkAttachmentAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed362();
    o.message = 'foo';
  }
  buildCounterNetworkAttachmentAggregatedListWarning--;
  return o;
}

void checkNetworkAttachmentAggregatedListWarning(
    api.NetworkAttachmentAggregatedListWarning o) {
  buildCounterNetworkAttachmentAggregatedListWarning++;
  if (buildCounterNetworkAttachmentAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed362(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkAttachmentAggregatedListWarning--;
}

core.int buildCounterNetworkAttachmentAggregatedList = 0;
api.NetworkAttachmentAggregatedList buildNetworkAttachmentAggregatedList() {
  final o = api.NetworkAttachmentAggregatedList();
  buildCounterNetworkAttachmentAggregatedList++;
  if (buildCounterNetworkAttachmentAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed361();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNetworkAttachmentAggregatedListWarning();
  }
  buildCounterNetworkAttachmentAggregatedList--;
  return o;
}

void checkNetworkAttachmentAggregatedList(
    api.NetworkAttachmentAggregatedList o) {
  buildCounterNetworkAttachmentAggregatedList++;
  if (buildCounterNetworkAttachmentAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed361(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNetworkAttachmentAggregatedListWarning(o.warning!);
  }
  buildCounterNetworkAttachmentAggregatedList--;
}

core.List<core.String> buildUnnamed363() => [
      'foo',
      'foo',
    ];

void checkUnnamed363(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNetworkAttachmentConnectedEndpoint = 0;
api.NetworkAttachmentConnectedEndpoint
    buildNetworkAttachmentConnectedEndpoint() {
  final o = api.NetworkAttachmentConnectedEndpoint();
  buildCounterNetworkAttachmentConnectedEndpoint++;
  if (buildCounterNetworkAttachmentConnectedEndpoint < 3) {
    o.ipAddress = 'foo';
    o.ipv6Address = 'foo';
    o.projectIdOrNum = 'foo';
    o.secondaryIpCidrRanges = buildUnnamed363();
    o.status = 'foo';
    o.subnetwork = 'foo';
    o.subnetworkCidrRange = 'foo';
  }
  buildCounterNetworkAttachmentConnectedEndpoint--;
  return o;
}

void checkNetworkAttachmentConnectedEndpoint(
    api.NetworkAttachmentConnectedEndpoint o) {
  buildCounterNetworkAttachmentConnectedEndpoint++;
  if (buildCounterNetworkAttachmentConnectedEndpoint < 3) {
    unittest.expect(
      o.ipAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipv6Address!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.projectIdOrNum!,
      unittest.equals('foo'),
    );
    checkUnnamed363(o.secondaryIpCidrRanges!);
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.subnetwork!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.subnetworkCidrRange!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkAttachmentConnectedEndpoint--;
}

core.List<api.NetworkAttachment> buildUnnamed364() => [
      buildNetworkAttachment(),
      buildNetworkAttachment(),
    ];

void checkUnnamed364(core.List<api.NetworkAttachment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkAttachment(o[0]);
  checkNetworkAttachment(o[1]);
}

core.int buildCounterNetworkAttachmentListWarningData = 0;
api.NetworkAttachmentListWarningData buildNetworkAttachmentListWarningData() {
  final o = api.NetworkAttachmentListWarningData();
  buildCounterNetworkAttachmentListWarningData++;
  if (buildCounterNetworkAttachmentListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkAttachmentListWarningData--;
  return o;
}

void checkNetworkAttachmentListWarningData(
    api.NetworkAttachmentListWarningData o) {
  buildCounterNetworkAttachmentListWarningData++;
  if (buildCounterNetworkAttachmentListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkAttachmentListWarningData--;
}

core.List<api.NetworkAttachmentListWarningData> buildUnnamed365() => [
      buildNetworkAttachmentListWarningData(),
      buildNetworkAttachmentListWarningData(),
    ];

void checkUnnamed365(core.List<api.NetworkAttachmentListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkAttachmentListWarningData(o[0]);
  checkNetworkAttachmentListWarningData(o[1]);
}

core.int buildCounterNetworkAttachmentListWarning = 0;
api.NetworkAttachmentListWarning buildNetworkAttachmentListWarning() {
  final o = api.NetworkAttachmentListWarning();
  buildCounterNetworkAttachmentListWarning++;
  if (buildCounterNetworkAttachmentListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed365();
    o.message = 'foo';
  }
  buildCounterNetworkAttachmentListWarning--;
  return o;
}

void checkNetworkAttachmentListWarning(api.NetworkAttachmentListWarning o) {
  buildCounterNetworkAttachmentListWarning++;
  if (buildCounterNetworkAttachmentListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed365(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkAttachmentListWarning--;
}

core.int buildCounterNetworkAttachmentList = 0;
api.NetworkAttachmentList buildNetworkAttachmentList() {
  final o = api.NetworkAttachmentList();
  buildCounterNetworkAttachmentList++;
  if (buildCounterNetworkAttachmentList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed364();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNetworkAttachmentListWarning();
  }
  buildCounterNetworkAttachmentList--;
  return o;
}

void checkNetworkAttachmentList(api.NetworkAttachmentList o) {
  buildCounterNetworkAttachmentList++;
  if (buildCounterNetworkAttachmentList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed364(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNetworkAttachmentListWarning(o.warning!);
  }
  buildCounterNetworkAttachmentList--;
}

core.List<api.NetworkAttachment> buildUnnamed366() => [
      buildNetworkAttachment(),
      buildNetworkAttachment(),
    ];

void checkUnnamed366(core.List<api.NetworkAttachment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkAttachment(o[0]);
  checkNetworkAttachment(o[1]);
}

core.int buildCounterNetworkAttachmentsScopedListWarningData = 0;
api.NetworkAttachmentsScopedListWarningData
    buildNetworkAttachmentsScopedListWarningData() {
  final o = api.NetworkAttachmentsScopedListWarningData();
  buildCounterNetworkAttachmentsScopedListWarningData++;
  if (buildCounterNetworkAttachmentsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkAttachmentsScopedListWarningData--;
  return o;
}

void checkNetworkAttachmentsScopedListWarningData(
    api.NetworkAttachmentsScopedListWarningData o) {
  buildCounterNetworkAttachmentsScopedListWarningData++;
  if (buildCounterNetworkAttachmentsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkAttachmentsScopedListWarningData--;
}

core.List<api.NetworkAttachmentsScopedListWarningData> buildUnnamed367() => [
      buildNetworkAttachmentsScopedListWarningData(),
      buildNetworkAttachmentsScopedListWarningData(),
    ];

void checkUnnamed367(core.List<api.NetworkAttachmentsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkAttachmentsScopedListWarningData(o[0]);
  checkNetworkAttachmentsScopedListWarningData(o[1]);
}

core.int buildCounterNetworkAttachmentsScopedListWarning = 0;
api.NetworkAttachmentsScopedListWarning
    buildNetworkAttachmentsScopedListWarning() {
  final o = api.NetworkAttachmentsScopedListWarning();
  buildCounterNetworkAttachmentsScopedListWarning++;
  if (buildCounterNetworkAttachmentsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed367();
    o.message = 'foo';
  }
  buildCounterNetworkAttachmentsScopedListWarning--;
  return o;
}

void checkNetworkAttachmentsScopedListWarning(
    api.NetworkAttachmentsScopedListWarning o) {
  buildCounterNetworkAttachmentsScopedListWarning++;
  if (buildCounterNetworkAttachmentsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed367(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkAttachmentsScopedListWarning--;
}

core.int buildCounterNetworkAttachmentsScopedList = 0;
api.NetworkAttachmentsScopedList buildNetworkAttachmentsScopedList() {
  final o = api.NetworkAttachmentsScopedList();
  buildCounterNetworkAttachmentsScopedList++;
  if (buildCounterNetworkAttachmentsScopedList < 3) {
    o.networkAttachments = buildUnnamed366();
    o.warning = buildNetworkAttachmentsScopedListWarning();
  }
  buildCounterNetworkAttachmentsScopedList--;
  return o;
}

void checkNetworkAttachmentsScopedList(api.NetworkAttachmentsScopedList o) {
  buildCounterNetworkAttachmentsScopedList++;
  if (buildCounterNetworkAttachmentsScopedList < 3) {
    checkUnnamed366(o.networkAttachments!);
    checkNetworkAttachmentsScopedListWarning(o.warning!);
  }
  buildCounterNetworkAttachmentsScopedList--;
}

core.int buildCounterNetworkEdgeSecurityService = 0;
api.NetworkEdgeSecurityService buildNetworkEdgeSecurityService() {
  final o = api.NetworkEdgeSecurityService();
  buildCounterNetworkEdgeSecurityService++;
  if (buildCounterNetworkEdgeSecurityService < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.region = 'foo';
    o.securityPolicy = 'foo';
    o.selfLink = 'foo';
    o.selfLinkWithId = 'foo';
  }
  buildCounterNetworkEdgeSecurityService--;
  return o;
}

void checkNetworkEdgeSecurityService(api.NetworkEdgeSecurityService o) {
  buildCounterNetworkEdgeSecurityService++;
  if (buildCounterNetworkEdgeSecurityService < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.securityPolicy!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLinkWithId!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEdgeSecurityService--;
}

core.Map<core.String, api.NetworkEdgeSecurityServicesScopedList>
    buildUnnamed368() => {
          'x': buildNetworkEdgeSecurityServicesScopedList(),
          'y': buildNetworkEdgeSecurityServicesScopedList(),
        };

void checkUnnamed368(
    core.Map<core.String, api.NetworkEdgeSecurityServicesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEdgeSecurityServicesScopedList(o['x']!);
  checkNetworkEdgeSecurityServicesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed369() => [
      'foo',
      'foo',
    ];

void checkUnnamed369(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNetworkEdgeSecurityServiceAggregatedListWarningData = 0;
api.NetworkEdgeSecurityServiceAggregatedListWarningData
    buildNetworkEdgeSecurityServiceAggregatedListWarningData() {
  final o = api.NetworkEdgeSecurityServiceAggregatedListWarningData();
  buildCounterNetworkEdgeSecurityServiceAggregatedListWarningData++;
  if (buildCounterNetworkEdgeSecurityServiceAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkEdgeSecurityServiceAggregatedListWarningData--;
  return o;
}

void checkNetworkEdgeSecurityServiceAggregatedListWarningData(
    api.NetworkEdgeSecurityServiceAggregatedListWarningData o) {
  buildCounterNetworkEdgeSecurityServiceAggregatedListWarningData++;
  if (buildCounterNetworkEdgeSecurityServiceAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEdgeSecurityServiceAggregatedListWarningData--;
}

core.List<api.NetworkEdgeSecurityServiceAggregatedListWarningData>
    buildUnnamed370() => [
          buildNetworkEdgeSecurityServiceAggregatedListWarningData(),
          buildNetworkEdgeSecurityServiceAggregatedListWarningData(),
        ];

void checkUnnamed370(
    core.List<api.NetworkEdgeSecurityServiceAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEdgeSecurityServiceAggregatedListWarningData(o[0]);
  checkNetworkEdgeSecurityServiceAggregatedListWarningData(o[1]);
}

core.int buildCounterNetworkEdgeSecurityServiceAggregatedListWarning = 0;
api.NetworkEdgeSecurityServiceAggregatedListWarning
    buildNetworkEdgeSecurityServiceAggregatedListWarning() {
  final o = api.NetworkEdgeSecurityServiceAggregatedListWarning();
  buildCounterNetworkEdgeSecurityServiceAggregatedListWarning++;
  if (buildCounterNetworkEdgeSecurityServiceAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed370();
    o.message = 'foo';
  }
  buildCounterNetworkEdgeSecurityServiceAggregatedListWarning--;
  return o;
}

void checkNetworkEdgeSecurityServiceAggregatedListWarning(
    api.NetworkEdgeSecurityServiceAggregatedListWarning o) {
  buildCounterNetworkEdgeSecurityServiceAggregatedListWarning++;
  if (buildCounterNetworkEdgeSecurityServiceAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed370(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEdgeSecurityServiceAggregatedListWarning--;
}

core.int buildCounterNetworkEdgeSecurityServiceAggregatedList = 0;
api.NetworkEdgeSecurityServiceAggregatedList
    buildNetworkEdgeSecurityServiceAggregatedList() {
  final o = api.NetworkEdgeSecurityServiceAggregatedList();
  buildCounterNetworkEdgeSecurityServiceAggregatedList++;
  if (buildCounterNetworkEdgeSecurityServiceAggregatedList < 3) {
    o.etag = 'foo';
    o.id = 'foo';
    o.items = buildUnnamed368();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed369();
    o.warning = buildNetworkEdgeSecurityServiceAggregatedListWarning();
  }
  buildCounterNetworkEdgeSecurityServiceAggregatedList--;
  return o;
}

void checkNetworkEdgeSecurityServiceAggregatedList(
    api.NetworkEdgeSecurityServiceAggregatedList o) {
  buildCounterNetworkEdgeSecurityServiceAggregatedList++;
  if (buildCounterNetworkEdgeSecurityServiceAggregatedList < 3) {
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed368(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed369(o.unreachables!);
    checkNetworkEdgeSecurityServiceAggregatedListWarning(o.warning!);
  }
  buildCounterNetworkEdgeSecurityServiceAggregatedList--;
}

core.List<api.NetworkEdgeSecurityService> buildUnnamed371() => [
      buildNetworkEdgeSecurityService(),
      buildNetworkEdgeSecurityService(),
    ];

void checkUnnamed371(core.List<api.NetworkEdgeSecurityService> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEdgeSecurityService(o[0]);
  checkNetworkEdgeSecurityService(o[1]);
}

core.int buildCounterNetworkEdgeSecurityServicesScopedListWarningData = 0;
api.NetworkEdgeSecurityServicesScopedListWarningData
    buildNetworkEdgeSecurityServicesScopedListWarningData() {
  final o = api.NetworkEdgeSecurityServicesScopedListWarningData();
  buildCounterNetworkEdgeSecurityServicesScopedListWarningData++;
  if (buildCounterNetworkEdgeSecurityServicesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkEdgeSecurityServicesScopedListWarningData--;
  return o;
}

void checkNetworkEdgeSecurityServicesScopedListWarningData(
    api.NetworkEdgeSecurityServicesScopedListWarningData o) {
  buildCounterNetworkEdgeSecurityServicesScopedListWarningData++;
  if (buildCounterNetworkEdgeSecurityServicesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEdgeSecurityServicesScopedListWarningData--;
}

core.List<api.NetworkEdgeSecurityServicesScopedListWarningData>
    buildUnnamed372() => [
          buildNetworkEdgeSecurityServicesScopedListWarningData(),
          buildNetworkEdgeSecurityServicesScopedListWarningData(),
        ];

void checkUnnamed372(
    core.List<api.NetworkEdgeSecurityServicesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEdgeSecurityServicesScopedListWarningData(o[0]);
  checkNetworkEdgeSecurityServicesScopedListWarningData(o[1]);
}

core.int buildCounterNetworkEdgeSecurityServicesScopedListWarning = 0;
api.NetworkEdgeSecurityServicesScopedListWarning
    buildNetworkEdgeSecurityServicesScopedListWarning() {
  final o = api.NetworkEdgeSecurityServicesScopedListWarning();
  buildCounterNetworkEdgeSecurityServicesScopedListWarning++;
  if (buildCounterNetworkEdgeSecurityServicesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed372();
    o.message = 'foo';
  }
  buildCounterNetworkEdgeSecurityServicesScopedListWarning--;
  return o;
}

void checkNetworkEdgeSecurityServicesScopedListWarning(
    api.NetworkEdgeSecurityServicesScopedListWarning o) {
  buildCounterNetworkEdgeSecurityServicesScopedListWarning++;
  if (buildCounterNetworkEdgeSecurityServicesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed372(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEdgeSecurityServicesScopedListWarning--;
}

core.int buildCounterNetworkEdgeSecurityServicesScopedList = 0;
api.NetworkEdgeSecurityServicesScopedList
    buildNetworkEdgeSecurityServicesScopedList() {
  final o = api.NetworkEdgeSecurityServicesScopedList();
  buildCounterNetworkEdgeSecurityServicesScopedList++;
  if (buildCounterNetworkEdgeSecurityServicesScopedList < 3) {
    o.networkEdgeSecurityServices = buildUnnamed371();
    o.warning = buildNetworkEdgeSecurityServicesScopedListWarning();
  }
  buildCounterNetworkEdgeSecurityServicesScopedList--;
  return o;
}

void checkNetworkEdgeSecurityServicesScopedList(
    api.NetworkEdgeSecurityServicesScopedList o) {
  buildCounterNetworkEdgeSecurityServicesScopedList++;
  if (buildCounterNetworkEdgeSecurityServicesScopedList < 3) {
    checkUnnamed371(o.networkEdgeSecurityServices!);
    checkNetworkEdgeSecurityServicesScopedListWarning(o.warning!);
  }
  buildCounterNetworkEdgeSecurityServicesScopedList--;
}

core.Map<core.String, core.String> buildUnnamed373() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed373(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterNetworkEndpoint = 0;
api.NetworkEndpoint buildNetworkEndpoint() {
  final o = api.NetworkEndpoint();
  buildCounterNetworkEndpoint++;
  if (buildCounterNetworkEndpoint < 3) {
    o.annotations = buildUnnamed373();
    o.fqdn = 'foo';
    o.instance = 'foo';
    o.ipAddress = 'foo';
    o.port = 42;
  }
  buildCounterNetworkEndpoint--;
  return o;
}

void checkNetworkEndpoint(api.NetworkEndpoint o) {
  buildCounterNetworkEndpoint++;
  if (buildCounterNetworkEndpoint < 3) {
    checkUnnamed373(o.annotations!);
    unittest.expect(
      o.fqdn!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.instance!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
  }
  buildCounterNetworkEndpoint--;
}

core.Map<core.String, core.String> buildUnnamed374() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed374(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterNetworkEndpointGroup = 0;
api.NetworkEndpointGroup buildNetworkEndpointGroup() {
  final o = api.NetworkEndpointGroup();
  buildCounterNetworkEndpointGroup++;
  if (buildCounterNetworkEndpointGroup < 3) {
    o.annotations = buildUnnamed374();
    o.appEngine = buildNetworkEndpointGroupAppEngine();
    o.cloudFunction = buildNetworkEndpointGroupCloudFunction();
    o.cloudRun = buildNetworkEndpointGroupCloudRun();
    o.creationTimestamp = 'foo';
    o.defaultPort = 42;
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.network = 'foo';
    o.networkEndpointType = 'foo';
    o.pscData = buildNetworkEndpointGroupPscData();
    o.pscTargetService = 'foo';
    o.region = 'foo';
    o.selfLink = 'foo';
    o.size = 42;
    o.subnetwork = 'foo';
    o.zone = 'foo';
  }
  buildCounterNetworkEndpointGroup--;
  return o;
}

void checkNetworkEndpointGroup(api.NetworkEndpointGroup o) {
  buildCounterNetworkEndpointGroup++;
  if (buildCounterNetworkEndpointGroup < 3) {
    checkUnnamed374(o.annotations!);
    checkNetworkEndpointGroupAppEngine(o.appEngine!);
    checkNetworkEndpointGroupCloudFunction(o.cloudFunction!);
    checkNetworkEndpointGroupCloudRun(o.cloudRun!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.defaultPort!,
      unittest.equals(42),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.networkEndpointType!,
      unittest.equals('foo'),
    );
    checkNetworkEndpointGroupPscData(o.pscData!);
    unittest.expect(
      o.pscTargetService!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.size!,
      unittest.equals(42),
    );
    unittest.expect(
      o.subnetwork!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroup--;
}

core.Map<core.String, api.NetworkEndpointGroupsScopedList> buildUnnamed375() =>
    {
      'x': buildNetworkEndpointGroupsScopedList(),
      'y': buildNetworkEndpointGroupsScopedList(),
    };

void checkUnnamed375(
    core.Map<core.String, api.NetworkEndpointGroupsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupsScopedList(o['x']!);
  checkNetworkEndpointGroupsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed376() => [
      'foo',
      'foo',
    ];

void checkUnnamed376(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNetworkEndpointGroupAggregatedListWarningData = 0;
api.NetworkEndpointGroupAggregatedListWarningData
    buildNetworkEndpointGroupAggregatedListWarningData() {
  final o = api.NetworkEndpointGroupAggregatedListWarningData();
  buildCounterNetworkEndpointGroupAggregatedListWarningData++;
  if (buildCounterNetworkEndpointGroupAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkEndpointGroupAggregatedListWarningData--;
  return o;
}

void checkNetworkEndpointGroupAggregatedListWarningData(
    api.NetworkEndpointGroupAggregatedListWarningData o) {
  buildCounterNetworkEndpointGroupAggregatedListWarningData++;
  if (buildCounterNetworkEndpointGroupAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupAggregatedListWarningData--;
}

core.List<api.NetworkEndpointGroupAggregatedListWarningData>
    buildUnnamed377() => [
          buildNetworkEndpointGroupAggregatedListWarningData(),
          buildNetworkEndpointGroupAggregatedListWarningData(),
        ];

void checkUnnamed377(
    core.List<api.NetworkEndpointGroupAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupAggregatedListWarningData(o[0]);
  checkNetworkEndpointGroupAggregatedListWarningData(o[1]);
}

core.int buildCounterNetworkEndpointGroupAggregatedListWarning = 0;
api.NetworkEndpointGroupAggregatedListWarning
    buildNetworkEndpointGroupAggregatedListWarning() {
  final o = api.NetworkEndpointGroupAggregatedListWarning();
  buildCounterNetworkEndpointGroupAggregatedListWarning++;
  if (buildCounterNetworkEndpointGroupAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed377();
    o.message = 'foo';
  }
  buildCounterNetworkEndpointGroupAggregatedListWarning--;
  return o;
}

void checkNetworkEndpointGroupAggregatedListWarning(
    api.NetworkEndpointGroupAggregatedListWarning o) {
  buildCounterNetworkEndpointGroupAggregatedListWarning++;
  if (buildCounterNetworkEndpointGroupAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed377(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupAggregatedListWarning--;
}

core.int buildCounterNetworkEndpointGroupAggregatedList = 0;
api.NetworkEndpointGroupAggregatedList
    buildNetworkEndpointGroupAggregatedList() {
  final o = api.NetworkEndpointGroupAggregatedList();
  buildCounterNetworkEndpointGroupAggregatedList++;
  if (buildCounterNetworkEndpointGroupAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed375();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed376();
    o.warning = buildNetworkEndpointGroupAggregatedListWarning();
  }
  buildCounterNetworkEndpointGroupAggregatedList--;
  return o;
}

void checkNetworkEndpointGroupAggregatedList(
    api.NetworkEndpointGroupAggregatedList o) {
  buildCounterNetworkEndpointGroupAggregatedList++;
  if (buildCounterNetworkEndpointGroupAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed375(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed376(o.unreachables!);
    checkNetworkEndpointGroupAggregatedListWarning(o.warning!);
  }
  buildCounterNetworkEndpointGroupAggregatedList--;
}

core.int buildCounterNetworkEndpointGroupAppEngine = 0;
api.NetworkEndpointGroupAppEngine buildNetworkEndpointGroupAppEngine() {
  final o = api.NetworkEndpointGroupAppEngine();
  buildCounterNetworkEndpointGroupAppEngine++;
  if (buildCounterNetworkEndpointGroupAppEngine < 3) {
    o.service = 'foo';
    o.urlMask = 'foo';
    o.version = 'foo';
  }
  buildCounterNetworkEndpointGroupAppEngine--;
  return o;
}

void checkNetworkEndpointGroupAppEngine(api.NetworkEndpointGroupAppEngine o) {
  buildCounterNetworkEndpointGroupAppEngine++;
  if (buildCounterNetworkEndpointGroupAppEngine < 3) {
    unittest.expect(
      o.service!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.urlMask!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.version!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupAppEngine--;
}

core.int buildCounterNetworkEndpointGroupCloudFunction = 0;
api.NetworkEndpointGroupCloudFunction buildNetworkEndpointGroupCloudFunction() {
  final o = api.NetworkEndpointGroupCloudFunction();
  buildCounterNetworkEndpointGroupCloudFunction++;
  if (buildCounterNetworkEndpointGroupCloudFunction < 3) {
    o.function = 'foo';
    o.urlMask = 'foo';
  }
  buildCounterNetworkEndpointGroupCloudFunction--;
  return o;
}

void checkNetworkEndpointGroupCloudFunction(
    api.NetworkEndpointGroupCloudFunction o) {
  buildCounterNetworkEndpointGroupCloudFunction++;
  if (buildCounterNetworkEndpointGroupCloudFunction < 3) {
    unittest.expect(
      o.function!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.urlMask!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupCloudFunction--;
}

core.int buildCounterNetworkEndpointGroupCloudRun = 0;
api.NetworkEndpointGroupCloudRun buildNetworkEndpointGroupCloudRun() {
  final o = api.NetworkEndpointGroupCloudRun();
  buildCounterNetworkEndpointGroupCloudRun++;
  if (buildCounterNetworkEndpointGroupCloudRun < 3) {
    o.service = 'foo';
    o.tag = 'foo';
    o.urlMask = 'foo';
  }
  buildCounterNetworkEndpointGroupCloudRun--;
  return o;
}

void checkNetworkEndpointGroupCloudRun(api.NetworkEndpointGroupCloudRun o) {
  buildCounterNetworkEndpointGroupCloudRun++;
  if (buildCounterNetworkEndpointGroupCloudRun < 3) {
    unittest.expect(
      o.service!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.tag!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.urlMask!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupCloudRun--;
}

core.List<api.NetworkEndpointGroup> buildUnnamed378() => [
      buildNetworkEndpointGroup(),
      buildNetworkEndpointGroup(),
    ];

void checkUnnamed378(core.List<api.NetworkEndpointGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroup(o[0]);
  checkNetworkEndpointGroup(o[1]);
}

core.int buildCounterNetworkEndpointGroupListWarningData = 0;
api.NetworkEndpointGroupListWarningData
    buildNetworkEndpointGroupListWarningData() {
  final o = api.NetworkEndpointGroupListWarningData();
  buildCounterNetworkEndpointGroupListWarningData++;
  if (buildCounterNetworkEndpointGroupListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkEndpointGroupListWarningData--;
  return o;
}

void checkNetworkEndpointGroupListWarningData(
    api.NetworkEndpointGroupListWarningData o) {
  buildCounterNetworkEndpointGroupListWarningData++;
  if (buildCounterNetworkEndpointGroupListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupListWarningData--;
}

core.List<api.NetworkEndpointGroupListWarningData> buildUnnamed379() => [
      buildNetworkEndpointGroupListWarningData(),
      buildNetworkEndpointGroupListWarningData(),
    ];

void checkUnnamed379(core.List<api.NetworkEndpointGroupListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupListWarningData(o[0]);
  checkNetworkEndpointGroupListWarningData(o[1]);
}

core.int buildCounterNetworkEndpointGroupListWarning = 0;
api.NetworkEndpointGroupListWarning buildNetworkEndpointGroupListWarning() {
  final o = api.NetworkEndpointGroupListWarning();
  buildCounterNetworkEndpointGroupListWarning++;
  if (buildCounterNetworkEndpointGroupListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed379();
    o.message = 'foo';
  }
  buildCounterNetworkEndpointGroupListWarning--;
  return o;
}

void checkNetworkEndpointGroupListWarning(
    api.NetworkEndpointGroupListWarning o) {
  buildCounterNetworkEndpointGroupListWarning++;
  if (buildCounterNetworkEndpointGroupListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed379(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupListWarning--;
}

core.int buildCounterNetworkEndpointGroupList = 0;
api.NetworkEndpointGroupList buildNetworkEndpointGroupList() {
  final o = api.NetworkEndpointGroupList();
  buildCounterNetworkEndpointGroupList++;
  if (buildCounterNetworkEndpointGroupList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed378();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNetworkEndpointGroupListWarning();
  }
  buildCounterNetworkEndpointGroupList--;
  return o;
}

void checkNetworkEndpointGroupList(api.NetworkEndpointGroupList o) {
  buildCounterNetworkEndpointGroupList++;
  if (buildCounterNetworkEndpointGroupList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed378(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNetworkEndpointGroupListWarning(o.warning!);
  }
  buildCounterNetworkEndpointGroupList--;
}

core.int buildCounterNetworkEndpointGroupPscData = 0;
api.NetworkEndpointGroupPscData buildNetworkEndpointGroupPscData() {
  final o = api.NetworkEndpointGroupPscData();
  buildCounterNetworkEndpointGroupPscData++;
  if (buildCounterNetworkEndpointGroupPscData < 3) {
    o.consumerPscAddress = 'foo';
    o.pscConnectionId = 'foo';
    o.pscConnectionStatus = 'foo';
  }
  buildCounterNetworkEndpointGroupPscData--;
  return o;
}

void checkNetworkEndpointGroupPscData(api.NetworkEndpointGroupPscData o) {
  buildCounterNetworkEndpointGroupPscData++;
  if (buildCounterNetworkEndpointGroupPscData < 3) {
    unittest.expect(
      o.consumerPscAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.pscConnectionId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.pscConnectionStatus!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupPscData--;
}

core.List<api.NetworkEndpoint> buildUnnamed380() => [
      buildNetworkEndpoint(),
      buildNetworkEndpoint(),
    ];

void checkUnnamed380(core.List<api.NetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpoint(o[0]);
  checkNetworkEndpoint(o[1]);
}

core.int buildCounterNetworkEndpointGroupsAttachEndpointsRequest = 0;
api.NetworkEndpointGroupsAttachEndpointsRequest
    buildNetworkEndpointGroupsAttachEndpointsRequest() {
  final o = api.NetworkEndpointGroupsAttachEndpointsRequest();
  buildCounterNetworkEndpointGroupsAttachEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsAttachEndpointsRequest < 3) {
    o.networkEndpoints = buildUnnamed380();
  }
  buildCounterNetworkEndpointGroupsAttachEndpointsRequest--;
  return o;
}

void checkNetworkEndpointGroupsAttachEndpointsRequest(
    api.NetworkEndpointGroupsAttachEndpointsRequest o) {
  buildCounterNetworkEndpointGroupsAttachEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsAttachEndpointsRequest < 3) {
    checkUnnamed380(o.networkEndpoints!);
  }
  buildCounterNetworkEndpointGroupsAttachEndpointsRequest--;
}

core.List<api.NetworkEndpoint> buildUnnamed381() => [
      buildNetworkEndpoint(),
      buildNetworkEndpoint(),
    ];

void checkUnnamed381(core.List<api.NetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpoint(o[0]);
  checkNetworkEndpoint(o[1]);
}

core.int buildCounterNetworkEndpointGroupsDetachEndpointsRequest = 0;
api.NetworkEndpointGroupsDetachEndpointsRequest
    buildNetworkEndpointGroupsDetachEndpointsRequest() {
  final o = api.NetworkEndpointGroupsDetachEndpointsRequest();
  buildCounterNetworkEndpointGroupsDetachEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsDetachEndpointsRequest < 3) {
    o.networkEndpoints = buildUnnamed381();
  }
  buildCounterNetworkEndpointGroupsDetachEndpointsRequest--;
  return o;
}

void checkNetworkEndpointGroupsDetachEndpointsRequest(
    api.NetworkEndpointGroupsDetachEndpointsRequest o) {
  buildCounterNetworkEndpointGroupsDetachEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsDetachEndpointsRequest < 3) {
    checkUnnamed381(o.networkEndpoints!);
  }
  buildCounterNetworkEndpointGroupsDetachEndpointsRequest--;
}

core.int buildCounterNetworkEndpointGroupsListEndpointsRequest = 0;
api.NetworkEndpointGroupsListEndpointsRequest
    buildNetworkEndpointGroupsListEndpointsRequest() {
  final o = api.NetworkEndpointGroupsListEndpointsRequest();
  buildCounterNetworkEndpointGroupsListEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsListEndpointsRequest < 3) {
    o.healthStatus = 'foo';
  }
  buildCounterNetworkEndpointGroupsListEndpointsRequest--;
  return o;
}

void checkNetworkEndpointGroupsListEndpointsRequest(
    api.NetworkEndpointGroupsListEndpointsRequest o) {
  buildCounterNetworkEndpointGroupsListEndpointsRequest++;
  if (buildCounterNetworkEndpointGroupsListEndpointsRequest < 3) {
    unittest.expect(
      o.healthStatus!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupsListEndpointsRequest--;
}

core.List<api.NetworkEndpointWithHealthStatus> buildUnnamed382() => [
      buildNetworkEndpointWithHealthStatus(),
      buildNetworkEndpointWithHealthStatus(),
    ];

void checkUnnamed382(core.List<api.NetworkEndpointWithHealthStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointWithHealthStatus(o[0]);
  checkNetworkEndpointWithHealthStatus(o[1]);
}

core.int buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData = 0;
api.NetworkEndpointGroupsListNetworkEndpointsWarningData
    buildNetworkEndpointGroupsListNetworkEndpointsWarningData() {
  final o = api.NetworkEndpointGroupsListNetworkEndpointsWarningData();
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData--;
  return o;
}

void checkNetworkEndpointGroupsListNetworkEndpointsWarningData(
    api.NetworkEndpointGroupsListNetworkEndpointsWarningData o) {
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarningData--;
}

core.List<api.NetworkEndpointGroupsListNetworkEndpointsWarningData>
    buildUnnamed383() => [
          buildNetworkEndpointGroupsListNetworkEndpointsWarningData(),
          buildNetworkEndpointGroupsListNetworkEndpointsWarningData(),
        ];

void checkUnnamed383(
    core.List<api.NetworkEndpointGroupsListNetworkEndpointsWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupsListNetworkEndpointsWarningData(o[0]);
  checkNetworkEndpointGroupsListNetworkEndpointsWarningData(o[1]);
}

core.int buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning = 0;
api.NetworkEndpointGroupsListNetworkEndpointsWarning
    buildNetworkEndpointGroupsListNetworkEndpointsWarning() {
  final o = api.NetworkEndpointGroupsListNetworkEndpointsWarning();
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed383();
    o.message = 'foo';
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning--;
  return o;
}

void checkNetworkEndpointGroupsListNetworkEndpointsWarning(
    api.NetworkEndpointGroupsListNetworkEndpointsWarning o) {
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed383(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpointsWarning--;
}

core.int buildCounterNetworkEndpointGroupsListNetworkEndpoints = 0;
api.NetworkEndpointGroupsListNetworkEndpoints
    buildNetworkEndpointGroupsListNetworkEndpoints() {
  final o = api.NetworkEndpointGroupsListNetworkEndpoints();
  buildCounterNetworkEndpointGroupsListNetworkEndpoints++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpoints < 3) {
    o.id = 'foo';
    o.items = buildUnnamed382();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.warning = buildNetworkEndpointGroupsListNetworkEndpointsWarning();
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpoints--;
  return o;
}

void checkNetworkEndpointGroupsListNetworkEndpoints(
    api.NetworkEndpointGroupsListNetworkEndpoints o) {
  buildCounterNetworkEndpointGroupsListNetworkEndpoints++;
  if (buildCounterNetworkEndpointGroupsListNetworkEndpoints < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed382(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    checkNetworkEndpointGroupsListNetworkEndpointsWarning(o.warning!);
  }
  buildCounterNetworkEndpointGroupsListNetworkEndpoints--;
}

core.List<api.NetworkEndpointGroup> buildUnnamed384() => [
      buildNetworkEndpointGroup(),
      buildNetworkEndpointGroup(),
    ];

void checkUnnamed384(core.List<api.NetworkEndpointGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroup(o[0]);
  checkNetworkEndpointGroup(o[1]);
}

core.int buildCounterNetworkEndpointGroupsScopedListWarningData = 0;
api.NetworkEndpointGroupsScopedListWarningData
    buildNetworkEndpointGroupsScopedListWarningData() {
  final o = api.NetworkEndpointGroupsScopedListWarningData();
  buildCounterNetworkEndpointGroupsScopedListWarningData++;
  if (buildCounterNetworkEndpointGroupsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkEndpointGroupsScopedListWarningData--;
  return o;
}

void checkNetworkEndpointGroupsScopedListWarningData(
    api.NetworkEndpointGroupsScopedListWarningData o) {
  buildCounterNetworkEndpointGroupsScopedListWarningData++;
  if (buildCounterNetworkEndpointGroupsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupsScopedListWarningData--;
}

core.List<api.NetworkEndpointGroupsScopedListWarningData> buildUnnamed385() => [
      buildNetworkEndpointGroupsScopedListWarningData(),
      buildNetworkEndpointGroupsScopedListWarningData(),
    ];

void checkUnnamed385(
    core.List<api.NetworkEndpointGroupsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpointGroupsScopedListWarningData(o[0]);
  checkNetworkEndpointGroupsScopedListWarningData(o[1]);
}

core.int buildCounterNetworkEndpointGroupsScopedListWarning = 0;
api.NetworkEndpointGroupsScopedListWarning
    buildNetworkEndpointGroupsScopedListWarning() {
  final o = api.NetworkEndpointGroupsScopedListWarning();
  buildCounterNetworkEndpointGroupsScopedListWarning++;
  if (buildCounterNetworkEndpointGroupsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed385();
    o.message = 'foo';
  }
  buildCounterNetworkEndpointGroupsScopedListWarning--;
  return o;
}

void checkNetworkEndpointGroupsScopedListWarning(
    api.NetworkEndpointGroupsScopedListWarning o) {
  buildCounterNetworkEndpointGroupsScopedListWarning++;
  if (buildCounterNetworkEndpointGroupsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed385(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkEndpointGroupsScopedListWarning--;
}

core.int buildCounterNetworkEndpointGroupsScopedList = 0;
api.NetworkEndpointGroupsScopedList buildNetworkEndpointGroupsScopedList() {
  final o = api.NetworkEndpointGroupsScopedList();
  buildCounterNetworkEndpointGroupsScopedList++;
  if (buildCounterNetworkEndpointGroupsScopedList < 3) {
    o.networkEndpointGroups = buildUnnamed384();
    o.warning = buildNetworkEndpointGroupsScopedListWarning();
  }
  buildCounterNetworkEndpointGroupsScopedList--;
  return o;
}

void checkNetworkEndpointGroupsScopedList(
    api.NetworkEndpointGroupsScopedList o) {
  buildCounterNetworkEndpointGroupsScopedList++;
  if (buildCounterNetworkEndpointGroupsScopedList < 3) {
    checkUnnamed384(o.networkEndpointGroups!);
    checkNetworkEndpointGroupsScopedListWarning(o.warning!);
  }
  buildCounterNetworkEndpointGroupsScopedList--;
}

core.List<api.HealthStatusForNetworkEndpoint> buildUnnamed386() => [
      buildHealthStatusForNetworkEndpoint(),
      buildHealthStatusForNetworkEndpoint(),
    ];

void checkUnnamed386(core.List<api.HealthStatusForNetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHealthStatusForNetworkEndpoint(o[0]);
  checkHealthStatusForNetworkEndpoint(o[1]);
}

core.int buildCounterNetworkEndpointWithHealthStatus = 0;
api.NetworkEndpointWithHealthStatus buildNetworkEndpointWithHealthStatus() {
  final o = api.NetworkEndpointWithHealthStatus();
  buildCounterNetworkEndpointWithHealthStatus++;
  if (buildCounterNetworkEndpointWithHealthStatus < 3) {
    o.healths = buildUnnamed386();
    o.networkEndpoint = buildNetworkEndpoint();
  }
  buildCounterNetworkEndpointWithHealthStatus--;
  return o;
}

void checkNetworkEndpointWithHealthStatus(
    api.NetworkEndpointWithHealthStatus o) {
  buildCounterNetworkEndpointWithHealthStatus++;
  if (buildCounterNetworkEndpointWithHealthStatus < 3) {
    checkUnnamed386(o.healths!);
    checkNetworkEndpoint(o.networkEndpoint!);
  }
  buildCounterNetworkEndpointWithHealthStatus--;
}

core.List<api.AccessConfig> buildUnnamed387() => [
      buildAccessConfig(),
      buildAccessConfig(),
    ];

void checkUnnamed387(core.List<api.AccessConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAccessConfig(o[0]);
  checkAccessConfig(o[1]);
}

core.List<api.AliasIpRange> buildUnnamed388() => [
      buildAliasIpRange(),
      buildAliasIpRange(),
    ];

void checkUnnamed388(core.List<api.AliasIpRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAliasIpRange(o[0]);
  checkAliasIpRange(o[1]);
}

core.List<api.AccessConfig> buildUnnamed389() => [
      buildAccessConfig(),
      buildAccessConfig(),
    ];

void checkUnnamed389(core.List<api.AccessConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAccessConfig(o[0]);
  checkAccessConfig(o[1]);
}

core.int buildCounterNetworkInterface = 0;
api.NetworkInterface buildNetworkInterface() {
  final o = api.NetworkInterface();
  buildCounterNetworkInterface++;
  if (buildCounterNetworkInterface < 3) {
    o.accessConfigs = buildUnnamed387();
    o.aliasIpRanges = buildUnnamed388();
    o.fingerprint = 'foo';
    o.internalIpv6PrefixLength = 42;
    o.ipv6AccessConfigs = buildUnnamed389();
    o.ipv6AccessType = 'foo';
    o.ipv6Address = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.network = 'foo';
    o.networkAttachment = 'foo';
    o.networkIP = 'foo';
    o.nicType = 'foo';
    o.queueCount = 42;
    o.stackType = 'foo';
    o.subnetwork = 'foo';
  }
  buildCounterNetworkInterface--;
  return o;
}

void checkNetworkInterface(api.NetworkInterface o) {
  buildCounterNetworkInterface++;
  if (buildCounterNetworkInterface < 3) {
    checkUnnamed387(o.accessConfigs!);
    checkUnnamed388(o.aliasIpRanges!);
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.internalIpv6PrefixLength!,
      unittest.equals(42),
    );
    checkUnnamed389(o.ipv6AccessConfigs!);
    unittest.expect(
      o.ipv6AccessType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipv6Address!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.networkAttachment!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.networkIP!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nicType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.queueCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.stackType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.subnetwork!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkInterface--;
}

core.List<api.Network> buildUnnamed390() => [
      buildNetwork(),
      buildNetwork(),
    ];

void checkUnnamed390(core.List<api.Network> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetwork(o[0]);
  checkNetwork(o[1]);
}

core.int buildCounterNetworkListWarningData = 0;
api.NetworkListWarningData buildNetworkListWarningData() {
  final o = api.NetworkListWarningData();
  buildCounterNetworkListWarningData++;
  if (buildCounterNetworkListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNetworkListWarningData--;
  return o;
}

void checkNetworkListWarningData(api.NetworkListWarningData o) {
  buildCounterNetworkListWarningData++;
  if (buildCounterNetworkListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkListWarningData--;
}

core.List<api.NetworkListWarningData> buildUnnamed391() => [
      buildNetworkListWarningData(),
      buildNetworkListWarningData(),
    ];

void checkUnnamed391(core.List<api.NetworkListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkListWarningData(o[0]);
  checkNetworkListWarningData(o[1]);
}

core.int buildCounterNetworkListWarning = 0;
api.NetworkListWarning buildNetworkListWarning() {
  final o = api.NetworkListWarning();
  buildCounterNetworkListWarning++;
  if (buildCounterNetworkListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed391();
    o.message = 'foo';
  }
  buildCounterNetworkListWarning--;
  return o;
}

void checkNetworkListWarning(api.NetworkListWarning o) {
  buildCounterNetworkListWarning++;
  if (buildCounterNetworkListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed391(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkListWarning--;
}

core.int buildCounterNetworkList = 0;
api.NetworkList buildNetworkList() {
  final o = api.NetworkList();
  buildCounterNetworkList++;
  if (buildCounterNetworkList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed390();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNetworkListWarning();
  }
  buildCounterNetworkList--;
  return o;
}

void checkNetworkList(api.NetworkList o) {
  buildCounterNetworkList++;
  if (buildCounterNetworkList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed390(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNetworkListWarning(o.warning!);
  }
  buildCounterNetworkList--;
}

core.int buildCounterNetworkPeering = 0;
api.NetworkPeering buildNetworkPeering() {
  final o = api.NetworkPeering();
  buildCounterNetworkPeering++;
  if (buildCounterNetworkPeering < 3) {
    o.autoCreateRoutes = true;
    o.exchangeSubnetRoutes = true;
    o.exportCustomRoutes = true;
    o.exportSubnetRoutesWithPublicIp = true;
    o.importCustomRoutes = true;
    o.importSubnetRoutesWithPublicIp = true;
    o.name = 'foo';
    o.network = 'foo';
    o.peerMtu = 42;
    o.stackType = 'foo';
    o.state = 'foo';
    o.stateDetails = 'foo';
  }
  buildCounterNetworkPeering--;
  return o;
}

void checkNetworkPeering(api.NetworkPeering o) {
  buildCounterNetworkPeering++;
  if (buildCounterNetworkPeering < 3) {
    unittest.expect(o.autoCreateRoutes!, unittest.isTrue);
    unittest.expect(o.exchangeSubnetRoutes!, unittest.isTrue);
    unittest.expect(o.exportCustomRoutes!, unittest.isTrue);
    unittest.expect(o.exportSubnetRoutesWithPublicIp!, unittest.isTrue);
    unittest.expect(o.importCustomRoutes!, unittest.isTrue);
    unittest.expect(o.importSubnetRoutesWithPublicIp!, unittest.isTrue);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.peerMtu!,
      unittest.equals(42),
    );
    unittest.expect(
      o.stackType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.stateDetails!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkPeering--;
}

core.int buildCounterNetworkPerformanceConfig = 0;
api.NetworkPerformanceConfig buildNetworkPerformanceConfig() {
  final o = api.NetworkPerformanceConfig();
  buildCounterNetworkPerformanceConfig++;
  if (buildCounterNetworkPerformanceConfig < 3) {
    o.totalEgressBandwidthTier = 'foo';
  }
  buildCounterNetworkPerformanceConfig--;
  return o;
}

void checkNetworkPerformanceConfig(api.NetworkPerformanceConfig o) {
  buildCounterNetworkPerformanceConfig++;
  if (buildCounterNetworkPerformanceConfig < 3) {
    unittest.expect(
      o.totalEgressBandwidthTier!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkPerformanceConfig--;
}

core.int buildCounterNetworkRoutingConfig = 0;
api.NetworkRoutingConfig buildNetworkRoutingConfig() {
  final o = api.NetworkRoutingConfig();
  buildCounterNetworkRoutingConfig++;
  if (buildCounterNetworkRoutingConfig < 3) {
    o.routingMode = 'foo';
  }
  buildCounterNetworkRoutingConfig--;
  return o;
}

void checkNetworkRoutingConfig(api.NetworkRoutingConfig o) {
  buildCounterNetworkRoutingConfig++;
  if (buildCounterNetworkRoutingConfig < 3) {
    unittest.expect(
      o.routingMode!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworkRoutingConfig--;
}

core.int buildCounterNetworksAddPeeringRequest = 0;
api.NetworksAddPeeringRequest buildNetworksAddPeeringRequest() {
  final o = api.NetworksAddPeeringRequest();
  buildCounterNetworksAddPeeringRequest++;
  if (buildCounterNetworksAddPeeringRequest < 3) {
    o.autoCreateRoutes = true;
    o.name = 'foo';
    o.networkPeering = buildNetworkPeering();
    o.peerNetwork = 'foo';
  }
  buildCounterNetworksAddPeeringRequest--;
  return o;
}

void checkNetworksAddPeeringRequest(api.NetworksAddPeeringRequest o) {
  buildCounterNetworksAddPeeringRequest++;
  if (buildCounterNetworksAddPeeringRequest < 3) {
    unittest.expect(o.autoCreateRoutes!, unittest.isTrue);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkNetworkPeering(o.networkPeering!);
    unittest.expect(
      o.peerNetwork!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworksAddPeeringRequest--;
}

core.List<api.NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy>
    buildUnnamed392() => [
          buildNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy(),
          buildNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy(),
        ];

void checkUnnamed392(
    core.List<api.NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy(o[0]);
  checkNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy(o[1]);
}

core.List<api.Firewall> buildUnnamed393() => [
      buildFirewall(),
      buildFirewall(),
    ];

void checkUnnamed393(core.List<api.Firewall> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewall(o[0]);
  checkFirewall(o[1]);
}

core.int buildCounterNetworksGetEffectiveFirewallsResponse = 0;
api.NetworksGetEffectiveFirewallsResponse
    buildNetworksGetEffectiveFirewallsResponse() {
  final o = api.NetworksGetEffectiveFirewallsResponse();
  buildCounterNetworksGetEffectiveFirewallsResponse++;
  if (buildCounterNetworksGetEffectiveFirewallsResponse < 3) {
    o.firewallPolicys = buildUnnamed392();
    o.firewalls = buildUnnamed393();
  }
  buildCounterNetworksGetEffectiveFirewallsResponse--;
  return o;
}

void checkNetworksGetEffectiveFirewallsResponse(
    api.NetworksGetEffectiveFirewallsResponse o) {
  buildCounterNetworksGetEffectiveFirewallsResponse++;
  if (buildCounterNetworksGetEffectiveFirewallsResponse < 3) {
    checkUnnamed392(o.firewallPolicys!);
    checkUnnamed393(o.firewalls!);
  }
  buildCounterNetworksGetEffectiveFirewallsResponse--;
}

core.List<api.FirewallPolicyRule> buildUnnamed394() => [
      buildFirewallPolicyRule(),
      buildFirewallPolicyRule(),
    ];

void checkUnnamed394(core.List<api.FirewallPolicyRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyRule(o[0]);
  checkFirewallPolicyRule(o[1]);
}

core.int
    buildCounterNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy =
    0;
api.NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy
    buildNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy() {
  final o = api.NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy();
  buildCounterNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy++;
  if (buildCounterNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy <
      3) {
    o.displayName = 'foo';
    o.name = 'foo';
    o.rules = buildUnnamed394();
    o.shortName = 'foo';
    o.type = 'foo';
  }
  buildCounterNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy--;
  return o;
}

void checkNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy(
    api.NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy o) {
  buildCounterNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy++;
  if (buildCounterNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy <
      3) {
    unittest.expect(
      o.displayName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed394(o.rules!);
    unittest.expect(
      o.shortName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy--;
}

core.int buildCounterNetworksRemovePeeringRequest = 0;
api.NetworksRemovePeeringRequest buildNetworksRemovePeeringRequest() {
  final o = api.NetworksRemovePeeringRequest();
  buildCounterNetworksRemovePeeringRequest++;
  if (buildCounterNetworksRemovePeeringRequest < 3) {
    o.name = 'foo';
  }
  buildCounterNetworksRemovePeeringRequest--;
  return o;
}

void checkNetworksRemovePeeringRequest(api.NetworksRemovePeeringRequest o) {
  buildCounterNetworksRemovePeeringRequest++;
  if (buildCounterNetworksRemovePeeringRequest < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
  }
  buildCounterNetworksRemovePeeringRequest--;
}

core.int buildCounterNetworksUpdatePeeringRequest = 0;
api.NetworksUpdatePeeringRequest buildNetworksUpdatePeeringRequest() {
  final o = api.NetworksUpdatePeeringRequest();
  buildCounterNetworksUpdatePeeringRequest++;
  if (buildCounterNetworksUpdatePeeringRequest < 3) {
    o.networkPeering = buildNetworkPeering();
  }
  buildCounterNetworksUpdatePeeringRequest--;
  return o;
}

void checkNetworksUpdatePeeringRequest(api.NetworksUpdatePeeringRequest o) {
  buildCounterNetworksUpdatePeeringRequest++;
  if (buildCounterNetworksUpdatePeeringRequest < 3) {
    checkNetworkPeering(o.networkPeering!);
  }
  buildCounterNetworksUpdatePeeringRequest--;
}

core.int buildCounterNodeGroup = 0;
api.NodeGroup buildNodeGroup() {
  final o = api.NodeGroup();
  buildCounterNodeGroup++;
  if (buildCounterNodeGroup < 3) {
    o.autoscalingPolicy = buildNodeGroupAutoscalingPolicy();
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.locationHint = 'foo';
    o.maintenancePolicy = 'foo';
    o.maintenanceWindow = buildNodeGroupMaintenanceWindow();
    o.name = 'foo';
    o.nodeTemplate = 'foo';
    o.selfLink = 'foo';
    o.shareSettings = buildShareSettings();
    o.size = 42;
    o.status = 'foo';
    o.zone = 'foo';
  }
  buildCounterNodeGroup--;
  return o;
}

void checkNodeGroup(api.NodeGroup o) {
  buildCounterNodeGroup++;
  if (buildCounterNodeGroup < 3) {
    checkNodeGroupAutoscalingPolicy(o.autoscalingPolicy!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.locationHint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.maintenancePolicy!,
      unittest.equals('foo'),
    );
    checkNodeGroupMaintenanceWindow(o.maintenanceWindow!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nodeTemplate!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkShareSettings(o.shareSettings!);
    unittest.expect(
      o.size!,
      unittest.equals(42),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroup--;
}

core.Map<core.String, api.NodeGroupsScopedList> buildUnnamed395() => {
      'x': buildNodeGroupsScopedList(),
      'y': buildNodeGroupsScopedList(),
    };

void checkUnnamed395(core.Map<core.String, api.NodeGroupsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupsScopedList(o['x']!);
  checkNodeGroupsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed396() => [
      'foo',
      'foo',
    ];

void checkUnnamed396(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNodeGroupAggregatedListWarningData = 0;
api.NodeGroupAggregatedListWarningData
    buildNodeGroupAggregatedListWarningData() {
  final o = api.NodeGroupAggregatedListWarningData();
  buildCounterNodeGroupAggregatedListWarningData++;
  if (buildCounterNodeGroupAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeGroupAggregatedListWarningData--;
  return o;
}

void checkNodeGroupAggregatedListWarningData(
    api.NodeGroupAggregatedListWarningData o) {
  buildCounterNodeGroupAggregatedListWarningData++;
  if (buildCounterNodeGroupAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupAggregatedListWarningData--;
}

core.List<api.NodeGroupAggregatedListWarningData> buildUnnamed397() => [
      buildNodeGroupAggregatedListWarningData(),
      buildNodeGroupAggregatedListWarningData(),
    ];

void checkUnnamed397(core.List<api.NodeGroupAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupAggregatedListWarningData(o[0]);
  checkNodeGroupAggregatedListWarningData(o[1]);
}

core.int buildCounterNodeGroupAggregatedListWarning = 0;
api.NodeGroupAggregatedListWarning buildNodeGroupAggregatedListWarning() {
  final o = api.NodeGroupAggregatedListWarning();
  buildCounterNodeGroupAggregatedListWarning++;
  if (buildCounterNodeGroupAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed397();
    o.message = 'foo';
  }
  buildCounterNodeGroupAggregatedListWarning--;
  return o;
}

void checkNodeGroupAggregatedListWarning(api.NodeGroupAggregatedListWarning o) {
  buildCounterNodeGroupAggregatedListWarning++;
  if (buildCounterNodeGroupAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed397(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupAggregatedListWarning--;
}

core.int buildCounterNodeGroupAggregatedList = 0;
api.NodeGroupAggregatedList buildNodeGroupAggregatedList() {
  final o = api.NodeGroupAggregatedList();
  buildCounterNodeGroupAggregatedList++;
  if (buildCounterNodeGroupAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed395();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed396();
    o.warning = buildNodeGroupAggregatedListWarning();
  }
  buildCounterNodeGroupAggregatedList--;
  return o;
}

void checkNodeGroupAggregatedList(api.NodeGroupAggregatedList o) {
  buildCounterNodeGroupAggregatedList++;
  if (buildCounterNodeGroupAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed395(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed396(o.unreachables!);
    checkNodeGroupAggregatedListWarning(o.warning!);
  }
  buildCounterNodeGroupAggregatedList--;
}

core.int buildCounterNodeGroupAutoscalingPolicy = 0;
api.NodeGroupAutoscalingPolicy buildNodeGroupAutoscalingPolicy() {
  final o = api.NodeGroupAutoscalingPolicy();
  buildCounterNodeGroupAutoscalingPolicy++;
  if (buildCounterNodeGroupAutoscalingPolicy < 3) {
    o.maxNodes = 42;
    o.minNodes = 42;
    o.mode = 'foo';
  }
  buildCounterNodeGroupAutoscalingPolicy--;
  return o;
}

void checkNodeGroupAutoscalingPolicy(api.NodeGroupAutoscalingPolicy o) {
  buildCounterNodeGroupAutoscalingPolicy++;
  if (buildCounterNodeGroupAutoscalingPolicy < 3) {
    unittest.expect(
      o.maxNodes!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minNodes!,
      unittest.equals(42),
    );
    unittest.expect(
      o.mode!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupAutoscalingPolicy--;
}

core.List<api.NodeGroup> buildUnnamed398() => [
      buildNodeGroup(),
      buildNodeGroup(),
    ];

void checkUnnamed398(core.List<api.NodeGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroup(o[0]);
  checkNodeGroup(o[1]);
}

core.int buildCounterNodeGroupListWarningData = 0;
api.NodeGroupListWarningData buildNodeGroupListWarningData() {
  final o = api.NodeGroupListWarningData();
  buildCounterNodeGroupListWarningData++;
  if (buildCounterNodeGroupListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeGroupListWarningData--;
  return o;
}

void checkNodeGroupListWarningData(api.NodeGroupListWarningData o) {
  buildCounterNodeGroupListWarningData++;
  if (buildCounterNodeGroupListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupListWarningData--;
}

core.List<api.NodeGroupListWarningData> buildUnnamed399() => [
      buildNodeGroupListWarningData(),
      buildNodeGroupListWarningData(),
    ];

void checkUnnamed399(core.List<api.NodeGroupListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupListWarningData(o[0]);
  checkNodeGroupListWarningData(o[1]);
}

core.int buildCounterNodeGroupListWarning = 0;
api.NodeGroupListWarning buildNodeGroupListWarning() {
  final o = api.NodeGroupListWarning();
  buildCounterNodeGroupListWarning++;
  if (buildCounterNodeGroupListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed399();
    o.message = 'foo';
  }
  buildCounterNodeGroupListWarning--;
  return o;
}

void checkNodeGroupListWarning(api.NodeGroupListWarning o) {
  buildCounterNodeGroupListWarning++;
  if (buildCounterNodeGroupListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed399(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupListWarning--;
}

core.int buildCounterNodeGroupList = 0;
api.NodeGroupList buildNodeGroupList() {
  final o = api.NodeGroupList();
  buildCounterNodeGroupList++;
  if (buildCounterNodeGroupList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed398();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNodeGroupListWarning();
  }
  buildCounterNodeGroupList--;
  return o;
}

void checkNodeGroupList(api.NodeGroupList o) {
  buildCounterNodeGroupList++;
  if (buildCounterNodeGroupList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed398(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNodeGroupListWarning(o.warning!);
  }
  buildCounterNodeGroupList--;
}

core.int buildCounterNodeGroupMaintenanceWindow = 0;
api.NodeGroupMaintenanceWindow buildNodeGroupMaintenanceWindow() {
  final o = api.NodeGroupMaintenanceWindow();
  buildCounterNodeGroupMaintenanceWindow++;
  if (buildCounterNodeGroupMaintenanceWindow < 3) {
    o.maintenanceDuration = buildDuration();
    o.startTime = 'foo';
  }
  buildCounterNodeGroupMaintenanceWindow--;
  return o;
}

void checkNodeGroupMaintenanceWindow(api.NodeGroupMaintenanceWindow o) {
  buildCounterNodeGroupMaintenanceWindow++;
  if (buildCounterNodeGroupMaintenanceWindow < 3) {
    checkDuration(o.maintenanceDuration!);
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupMaintenanceWindow--;
}

core.List<api.AcceleratorConfig> buildUnnamed400() => [
      buildAcceleratorConfig(),
      buildAcceleratorConfig(),
    ];

void checkUnnamed400(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

core.List<api.LocalDisk> buildUnnamed401() => [
      buildLocalDisk(),
      buildLocalDisk(),
    ];

void checkUnnamed401(core.List<api.LocalDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLocalDisk(o[0]);
  checkLocalDisk(o[1]);
}

core.List<api.InstanceConsumptionData> buildUnnamed402() => [
      buildInstanceConsumptionData(),
      buildInstanceConsumptionData(),
    ];

void checkUnnamed402(core.List<api.InstanceConsumptionData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceConsumptionData(o[0]);
  checkInstanceConsumptionData(o[1]);
}

core.List<core.String> buildUnnamed403() => [
      'foo',
      'foo',
    ];

void checkUnnamed403(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNodeGroupNode = 0;
api.NodeGroupNode buildNodeGroupNode() {
  final o = api.NodeGroupNode();
  buildCounterNodeGroupNode++;
  if (buildCounterNodeGroupNode < 3) {
    o.accelerators = buildUnnamed400();
    o.consumedResources = buildInstanceConsumptionInfo();
    o.cpuOvercommitType = 'foo';
    o.disks = buildUnnamed401();
    o.instanceConsumptionData = buildUnnamed402();
    o.instances = buildUnnamed403();
    o.name = 'foo';
    o.nodeType = 'foo';
    o.satisfiesPzs = true;
    o.serverBinding = buildServerBinding();
    o.serverId = 'foo';
    o.status = 'foo';
    o.totalResources = buildInstanceConsumptionInfo();
  }
  buildCounterNodeGroupNode--;
  return o;
}

void checkNodeGroupNode(api.NodeGroupNode o) {
  buildCounterNodeGroupNode++;
  if (buildCounterNodeGroupNode < 3) {
    checkUnnamed400(o.accelerators!);
    checkInstanceConsumptionInfo(o.consumedResources!);
    unittest.expect(
      o.cpuOvercommitType!,
      unittest.equals('foo'),
    );
    checkUnnamed401(o.disks!);
    checkUnnamed402(o.instanceConsumptionData!);
    checkUnnamed403(o.instances!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nodeType!,
      unittest.equals('foo'),
    );
    unittest.expect(o.satisfiesPzs!, unittest.isTrue);
    checkServerBinding(o.serverBinding!);
    unittest.expect(
      o.serverId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    checkInstanceConsumptionInfo(o.totalResources!);
  }
  buildCounterNodeGroupNode--;
}

core.int buildCounterNodeGroupsAddNodesRequest = 0;
api.NodeGroupsAddNodesRequest buildNodeGroupsAddNodesRequest() {
  final o = api.NodeGroupsAddNodesRequest();
  buildCounterNodeGroupsAddNodesRequest++;
  if (buildCounterNodeGroupsAddNodesRequest < 3) {
    o.additionalNodeCount = 42;
  }
  buildCounterNodeGroupsAddNodesRequest--;
  return o;
}

void checkNodeGroupsAddNodesRequest(api.NodeGroupsAddNodesRequest o) {
  buildCounterNodeGroupsAddNodesRequest++;
  if (buildCounterNodeGroupsAddNodesRequest < 3) {
    unittest.expect(
      o.additionalNodeCount!,
      unittest.equals(42),
    );
  }
  buildCounterNodeGroupsAddNodesRequest--;
}

core.List<core.String> buildUnnamed404() => [
      'foo',
      'foo',
    ];

void checkUnnamed404(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNodeGroupsDeleteNodesRequest = 0;
api.NodeGroupsDeleteNodesRequest buildNodeGroupsDeleteNodesRequest() {
  final o = api.NodeGroupsDeleteNodesRequest();
  buildCounterNodeGroupsDeleteNodesRequest++;
  if (buildCounterNodeGroupsDeleteNodesRequest < 3) {
    o.nodes = buildUnnamed404();
  }
  buildCounterNodeGroupsDeleteNodesRequest--;
  return o;
}

void checkNodeGroupsDeleteNodesRequest(api.NodeGroupsDeleteNodesRequest o) {
  buildCounterNodeGroupsDeleteNodesRequest++;
  if (buildCounterNodeGroupsDeleteNodesRequest < 3) {
    checkUnnamed404(o.nodes!);
  }
  buildCounterNodeGroupsDeleteNodesRequest--;
}

core.List<api.NodeGroupNode> buildUnnamed405() => [
      buildNodeGroupNode(),
      buildNodeGroupNode(),
    ];

void checkUnnamed405(core.List<api.NodeGroupNode> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupNode(o[0]);
  checkNodeGroupNode(o[1]);
}

core.int buildCounterNodeGroupsListNodesWarningData = 0;
api.NodeGroupsListNodesWarningData buildNodeGroupsListNodesWarningData() {
  final o = api.NodeGroupsListNodesWarningData();
  buildCounterNodeGroupsListNodesWarningData++;
  if (buildCounterNodeGroupsListNodesWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeGroupsListNodesWarningData--;
  return o;
}

void checkNodeGroupsListNodesWarningData(api.NodeGroupsListNodesWarningData o) {
  buildCounterNodeGroupsListNodesWarningData++;
  if (buildCounterNodeGroupsListNodesWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupsListNodesWarningData--;
}

core.List<api.NodeGroupsListNodesWarningData> buildUnnamed406() => [
      buildNodeGroupsListNodesWarningData(),
      buildNodeGroupsListNodesWarningData(),
    ];

void checkUnnamed406(core.List<api.NodeGroupsListNodesWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupsListNodesWarningData(o[0]);
  checkNodeGroupsListNodesWarningData(o[1]);
}

core.int buildCounterNodeGroupsListNodesWarning = 0;
api.NodeGroupsListNodesWarning buildNodeGroupsListNodesWarning() {
  final o = api.NodeGroupsListNodesWarning();
  buildCounterNodeGroupsListNodesWarning++;
  if (buildCounterNodeGroupsListNodesWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed406();
    o.message = 'foo';
  }
  buildCounterNodeGroupsListNodesWarning--;
  return o;
}

void checkNodeGroupsListNodesWarning(api.NodeGroupsListNodesWarning o) {
  buildCounterNodeGroupsListNodesWarning++;
  if (buildCounterNodeGroupsListNodesWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed406(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupsListNodesWarning--;
}

core.int buildCounterNodeGroupsListNodes = 0;
api.NodeGroupsListNodes buildNodeGroupsListNodes() {
  final o = api.NodeGroupsListNodes();
  buildCounterNodeGroupsListNodes++;
  if (buildCounterNodeGroupsListNodes < 3) {
    o.id = 'foo';
    o.items = buildUnnamed405();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNodeGroupsListNodesWarning();
  }
  buildCounterNodeGroupsListNodes--;
  return o;
}

void checkNodeGroupsListNodes(api.NodeGroupsListNodes o) {
  buildCounterNodeGroupsListNodes++;
  if (buildCounterNodeGroupsListNodes < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed405(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNodeGroupsListNodesWarning(o.warning!);
  }
  buildCounterNodeGroupsListNodes--;
}

core.List<api.NodeGroup> buildUnnamed407() => [
      buildNodeGroup(),
      buildNodeGroup(),
    ];

void checkUnnamed407(core.List<api.NodeGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroup(o[0]);
  checkNodeGroup(o[1]);
}

core.int buildCounterNodeGroupsScopedListWarningData = 0;
api.NodeGroupsScopedListWarningData buildNodeGroupsScopedListWarningData() {
  final o = api.NodeGroupsScopedListWarningData();
  buildCounterNodeGroupsScopedListWarningData++;
  if (buildCounterNodeGroupsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeGroupsScopedListWarningData--;
  return o;
}

void checkNodeGroupsScopedListWarningData(
    api.NodeGroupsScopedListWarningData o) {
  buildCounterNodeGroupsScopedListWarningData++;
  if (buildCounterNodeGroupsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupsScopedListWarningData--;
}

core.List<api.NodeGroupsScopedListWarningData> buildUnnamed408() => [
      buildNodeGroupsScopedListWarningData(),
      buildNodeGroupsScopedListWarningData(),
    ];

void checkUnnamed408(core.List<api.NodeGroupsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeGroupsScopedListWarningData(o[0]);
  checkNodeGroupsScopedListWarningData(o[1]);
}

core.int buildCounterNodeGroupsScopedListWarning = 0;
api.NodeGroupsScopedListWarning buildNodeGroupsScopedListWarning() {
  final o = api.NodeGroupsScopedListWarning();
  buildCounterNodeGroupsScopedListWarning++;
  if (buildCounterNodeGroupsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed408();
    o.message = 'foo';
  }
  buildCounterNodeGroupsScopedListWarning--;
  return o;
}

void checkNodeGroupsScopedListWarning(api.NodeGroupsScopedListWarning o) {
  buildCounterNodeGroupsScopedListWarning++;
  if (buildCounterNodeGroupsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed408(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupsScopedListWarning--;
}

core.int buildCounterNodeGroupsScopedList = 0;
api.NodeGroupsScopedList buildNodeGroupsScopedList() {
  final o = api.NodeGroupsScopedList();
  buildCounterNodeGroupsScopedList++;
  if (buildCounterNodeGroupsScopedList < 3) {
    o.nodeGroups = buildUnnamed407();
    o.warning = buildNodeGroupsScopedListWarning();
  }
  buildCounterNodeGroupsScopedList--;
  return o;
}

void checkNodeGroupsScopedList(api.NodeGroupsScopedList o) {
  buildCounterNodeGroupsScopedList++;
  if (buildCounterNodeGroupsScopedList < 3) {
    checkUnnamed407(o.nodeGroups!);
    checkNodeGroupsScopedListWarning(o.warning!);
  }
  buildCounterNodeGroupsScopedList--;
}

core.int buildCounterNodeGroupsSetNodeTemplateRequest = 0;
api.NodeGroupsSetNodeTemplateRequest buildNodeGroupsSetNodeTemplateRequest() {
  final o = api.NodeGroupsSetNodeTemplateRequest();
  buildCounterNodeGroupsSetNodeTemplateRequest++;
  if (buildCounterNodeGroupsSetNodeTemplateRequest < 3) {
    o.nodeTemplate = 'foo';
  }
  buildCounterNodeGroupsSetNodeTemplateRequest--;
  return o;
}

void checkNodeGroupsSetNodeTemplateRequest(
    api.NodeGroupsSetNodeTemplateRequest o) {
  buildCounterNodeGroupsSetNodeTemplateRequest++;
  if (buildCounterNodeGroupsSetNodeTemplateRequest < 3) {
    unittest.expect(
      o.nodeTemplate!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeGroupsSetNodeTemplateRequest--;
}

core.List<core.String> buildUnnamed409() => [
      'foo',
      'foo',
    ];

void checkUnnamed409(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNodeGroupsSimulateMaintenanceEventRequest = 0;
api.NodeGroupsSimulateMaintenanceEventRequest
    buildNodeGroupsSimulateMaintenanceEventRequest() {
  final o = api.NodeGroupsSimulateMaintenanceEventRequest();
  buildCounterNodeGroupsSimulateMaintenanceEventRequest++;
  if (buildCounterNodeGroupsSimulateMaintenanceEventRequest < 3) {
    o.nodes = buildUnnamed409();
  }
  buildCounterNodeGroupsSimulateMaintenanceEventRequest--;
  return o;
}

void checkNodeGroupsSimulateMaintenanceEventRequest(
    api.NodeGroupsSimulateMaintenanceEventRequest o) {
  buildCounterNodeGroupsSimulateMaintenanceEventRequest++;
  if (buildCounterNodeGroupsSimulateMaintenanceEventRequest < 3) {
    checkUnnamed409(o.nodes!);
  }
  buildCounterNodeGroupsSimulateMaintenanceEventRequest--;
}

core.List<api.AcceleratorConfig> buildUnnamed410() => [
      buildAcceleratorConfig(),
      buildAcceleratorConfig(),
    ];

void checkUnnamed410(core.List<api.AcceleratorConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAcceleratorConfig(o[0]);
  checkAcceleratorConfig(o[1]);
}

core.List<api.LocalDisk> buildUnnamed411() => [
      buildLocalDisk(),
      buildLocalDisk(),
    ];

void checkUnnamed411(core.List<api.LocalDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLocalDisk(o[0]);
  checkLocalDisk(o[1]);
}

core.Map<core.String, core.String> buildUnnamed412() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed412(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterNodeTemplate = 0;
api.NodeTemplate buildNodeTemplate() {
  final o = api.NodeTemplate();
  buildCounterNodeTemplate++;
  if (buildCounterNodeTemplate < 3) {
    o.accelerators = buildUnnamed410();
    o.cpuOvercommitType = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.disks = buildUnnamed411();
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.nodeAffinityLabels = buildUnnamed412();
    o.nodeType = 'foo';
    o.nodeTypeFlexibility = buildNodeTemplateNodeTypeFlexibility();
    o.region = 'foo';
    o.selfLink = 'foo';
    o.serverBinding = buildServerBinding();
    o.status = 'foo';
    o.statusMessage = 'foo';
  }
  buildCounterNodeTemplate--;
  return o;
}

void checkNodeTemplate(api.NodeTemplate o) {
  buildCounterNodeTemplate++;
  if (buildCounterNodeTemplate < 3) {
    checkUnnamed410(o.accelerators!);
    unittest.expect(
      o.cpuOvercommitType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed411(o.disks!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed412(o.nodeAffinityLabels!);
    unittest.expect(
      o.nodeType!,
      unittest.equals('foo'),
    );
    checkNodeTemplateNodeTypeFlexibility(o.nodeTypeFlexibility!);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkServerBinding(o.serverBinding!);
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.statusMessage!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTemplate--;
}

core.Map<core.String, api.NodeTemplatesScopedList> buildUnnamed413() => {
      'x': buildNodeTemplatesScopedList(),
      'y': buildNodeTemplatesScopedList(),
    };

void checkUnnamed413(core.Map<core.String, api.NodeTemplatesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplatesScopedList(o['x']!);
  checkNodeTemplatesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed414() => [
      'foo',
      'foo',
    ];

void checkUnnamed414(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNodeTemplateAggregatedListWarningData = 0;
api.NodeTemplateAggregatedListWarningData
    buildNodeTemplateAggregatedListWarningData() {
  final o = api.NodeTemplateAggregatedListWarningData();
  buildCounterNodeTemplateAggregatedListWarningData++;
  if (buildCounterNodeTemplateAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeTemplateAggregatedListWarningData--;
  return o;
}

void checkNodeTemplateAggregatedListWarningData(
    api.NodeTemplateAggregatedListWarningData o) {
  buildCounterNodeTemplateAggregatedListWarningData++;
  if (buildCounterNodeTemplateAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTemplateAggregatedListWarningData--;
}

core.List<api.NodeTemplateAggregatedListWarningData> buildUnnamed415() => [
      buildNodeTemplateAggregatedListWarningData(),
      buildNodeTemplateAggregatedListWarningData(),
    ];

void checkUnnamed415(core.List<api.NodeTemplateAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplateAggregatedListWarningData(o[0]);
  checkNodeTemplateAggregatedListWarningData(o[1]);
}

core.int buildCounterNodeTemplateAggregatedListWarning = 0;
api.NodeTemplateAggregatedListWarning buildNodeTemplateAggregatedListWarning() {
  final o = api.NodeTemplateAggregatedListWarning();
  buildCounterNodeTemplateAggregatedListWarning++;
  if (buildCounterNodeTemplateAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed415();
    o.message = 'foo';
  }
  buildCounterNodeTemplateAggregatedListWarning--;
  return o;
}

void checkNodeTemplateAggregatedListWarning(
    api.NodeTemplateAggregatedListWarning o) {
  buildCounterNodeTemplateAggregatedListWarning++;
  if (buildCounterNodeTemplateAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed415(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTemplateAggregatedListWarning--;
}

core.int buildCounterNodeTemplateAggregatedList = 0;
api.NodeTemplateAggregatedList buildNodeTemplateAggregatedList() {
  final o = api.NodeTemplateAggregatedList();
  buildCounterNodeTemplateAggregatedList++;
  if (buildCounterNodeTemplateAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed413();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed414();
    o.warning = buildNodeTemplateAggregatedListWarning();
  }
  buildCounterNodeTemplateAggregatedList--;
  return o;
}

void checkNodeTemplateAggregatedList(api.NodeTemplateAggregatedList o) {
  buildCounterNodeTemplateAggregatedList++;
  if (buildCounterNodeTemplateAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed413(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed414(o.unreachables!);
    checkNodeTemplateAggregatedListWarning(o.warning!);
  }
  buildCounterNodeTemplateAggregatedList--;
}

core.List<api.NodeTemplate> buildUnnamed416() => [
      buildNodeTemplate(),
      buildNodeTemplate(),
    ];

void checkUnnamed416(core.List<api.NodeTemplate> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplate(o[0]);
  checkNodeTemplate(o[1]);
}

core.int buildCounterNodeTemplateListWarningData = 0;
api.NodeTemplateListWarningData buildNodeTemplateListWarningData() {
  final o = api.NodeTemplateListWarningData();
  buildCounterNodeTemplateListWarningData++;
  if (buildCounterNodeTemplateListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeTemplateListWarningData--;
  return o;
}

void checkNodeTemplateListWarningData(api.NodeTemplateListWarningData o) {
  buildCounterNodeTemplateListWarningData++;
  if (buildCounterNodeTemplateListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTemplateListWarningData--;
}

core.List<api.NodeTemplateListWarningData> buildUnnamed417() => [
      buildNodeTemplateListWarningData(),
      buildNodeTemplateListWarningData(),
    ];

void checkUnnamed417(core.List<api.NodeTemplateListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplateListWarningData(o[0]);
  checkNodeTemplateListWarningData(o[1]);
}

core.int buildCounterNodeTemplateListWarning = 0;
api.NodeTemplateListWarning buildNodeTemplateListWarning() {
  final o = api.NodeTemplateListWarning();
  buildCounterNodeTemplateListWarning++;
  if (buildCounterNodeTemplateListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed417();
    o.message = 'foo';
  }
  buildCounterNodeTemplateListWarning--;
  return o;
}

void checkNodeTemplateListWarning(api.NodeTemplateListWarning o) {
  buildCounterNodeTemplateListWarning++;
  if (buildCounterNodeTemplateListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed417(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTemplateListWarning--;
}

core.int buildCounterNodeTemplateList = 0;
api.NodeTemplateList buildNodeTemplateList() {
  final o = api.NodeTemplateList();
  buildCounterNodeTemplateList++;
  if (buildCounterNodeTemplateList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed416();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNodeTemplateListWarning();
  }
  buildCounterNodeTemplateList--;
  return o;
}

void checkNodeTemplateList(api.NodeTemplateList o) {
  buildCounterNodeTemplateList++;
  if (buildCounterNodeTemplateList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed416(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNodeTemplateListWarning(o.warning!);
  }
  buildCounterNodeTemplateList--;
}

core.int buildCounterNodeTemplateNodeTypeFlexibility = 0;
api.NodeTemplateNodeTypeFlexibility buildNodeTemplateNodeTypeFlexibility() {
  final o = api.NodeTemplateNodeTypeFlexibility();
  buildCounterNodeTemplateNodeTypeFlexibility++;
  if (buildCounterNodeTemplateNodeTypeFlexibility < 3) {
    o.cpus = 'foo';
    o.localSsd = 'foo';
    o.memory = 'foo';
  }
  buildCounterNodeTemplateNodeTypeFlexibility--;
  return o;
}

void checkNodeTemplateNodeTypeFlexibility(
    api.NodeTemplateNodeTypeFlexibility o) {
  buildCounterNodeTemplateNodeTypeFlexibility++;
  if (buildCounterNodeTemplateNodeTypeFlexibility < 3) {
    unittest.expect(
      o.cpus!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.localSsd!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.memory!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTemplateNodeTypeFlexibility--;
}

core.List<api.NodeTemplate> buildUnnamed418() => [
      buildNodeTemplate(),
      buildNodeTemplate(),
    ];

void checkUnnamed418(core.List<api.NodeTemplate> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplate(o[0]);
  checkNodeTemplate(o[1]);
}

core.int buildCounterNodeTemplatesScopedListWarningData = 0;
api.NodeTemplatesScopedListWarningData
    buildNodeTemplatesScopedListWarningData() {
  final o = api.NodeTemplatesScopedListWarningData();
  buildCounterNodeTemplatesScopedListWarningData++;
  if (buildCounterNodeTemplatesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeTemplatesScopedListWarningData--;
  return o;
}

void checkNodeTemplatesScopedListWarningData(
    api.NodeTemplatesScopedListWarningData o) {
  buildCounterNodeTemplatesScopedListWarningData++;
  if (buildCounterNodeTemplatesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTemplatesScopedListWarningData--;
}

core.List<api.NodeTemplatesScopedListWarningData> buildUnnamed419() => [
      buildNodeTemplatesScopedListWarningData(),
      buildNodeTemplatesScopedListWarningData(),
    ];

void checkUnnamed419(core.List<api.NodeTemplatesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTemplatesScopedListWarningData(o[0]);
  checkNodeTemplatesScopedListWarningData(o[1]);
}

core.int buildCounterNodeTemplatesScopedListWarning = 0;
api.NodeTemplatesScopedListWarning buildNodeTemplatesScopedListWarning() {
  final o = api.NodeTemplatesScopedListWarning();
  buildCounterNodeTemplatesScopedListWarning++;
  if (buildCounterNodeTemplatesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed419();
    o.message = 'foo';
  }
  buildCounterNodeTemplatesScopedListWarning--;
  return o;
}

void checkNodeTemplatesScopedListWarning(api.NodeTemplatesScopedListWarning o) {
  buildCounterNodeTemplatesScopedListWarning++;
  if (buildCounterNodeTemplatesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed419(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTemplatesScopedListWarning--;
}

core.int buildCounterNodeTemplatesScopedList = 0;
api.NodeTemplatesScopedList buildNodeTemplatesScopedList() {
  final o = api.NodeTemplatesScopedList();
  buildCounterNodeTemplatesScopedList++;
  if (buildCounterNodeTemplatesScopedList < 3) {
    o.nodeTemplates = buildUnnamed418();
    o.warning = buildNodeTemplatesScopedListWarning();
  }
  buildCounterNodeTemplatesScopedList--;
  return o;
}

void checkNodeTemplatesScopedList(api.NodeTemplatesScopedList o) {
  buildCounterNodeTemplatesScopedList++;
  if (buildCounterNodeTemplatesScopedList < 3) {
    checkUnnamed418(o.nodeTemplates!);
    checkNodeTemplatesScopedListWarning(o.warning!);
  }
  buildCounterNodeTemplatesScopedList--;
}

core.int buildCounterNodeType = 0;
api.NodeType buildNodeType() {
  final o = api.NodeType();
  buildCounterNodeType++;
  if (buildCounterNodeType < 3) {
    o.cpuPlatform = 'foo';
    o.creationTimestamp = 'foo';
    o.deprecated = buildDeprecationStatus();
    o.description = 'foo';
    o.guestCpus = 42;
    o.id = 'foo';
    o.kind = 'foo';
    o.localSsdGb = 42;
    o.memoryMb = 42;
    o.name = 'foo';
    o.selfLink = 'foo';
    o.zone = 'foo';
  }
  buildCounterNodeType--;
  return o;
}

void checkNodeType(api.NodeType o) {
  buildCounterNodeType++;
  if (buildCounterNodeType < 3) {
    unittest.expect(
      o.cpuPlatform!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkDeprecationStatus(o.deprecated!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.guestCpus!,
      unittest.equals(42),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.localSsdGb!,
      unittest.equals(42),
    );
    unittest.expect(
      o.memoryMb!,
      unittest.equals(42),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeType--;
}

core.Map<core.String, api.NodeTypesScopedList> buildUnnamed420() => {
      'x': buildNodeTypesScopedList(),
      'y': buildNodeTypesScopedList(),
    };

void checkUnnamed420(core.Map<core.String, api.NodeTypesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTypesScopedList(o['x']!);
  checkNodeTypesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed421() => [
      'foo',
      'foo',
    ];

void checkUnnamed421(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterNodeTypeAggregatedListWarningData = 0;
api.NodeTypeAggregatedListWarningData buildNodeTypeAggregatedListWarningData() {
  final o = api.NodeTypeAggregatedListWarningData();
  buildCounterNodeTypeAggregatedListWarningData++;
  if (buildCounterNodeTypeAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeTypeAggregatedListWarningData--;
  return o;
}

void checkNodeTypeAggregatedListWarningData(
    api.NodeTypeAggregatedListWarningData o) {
  buildCounterNodeTypeAggregatedListWarningData++;
  if (buildCounterNodeTypeAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTypeAggregatedListWarningData--;
}

core.List<api.NodeTypeAggregatedListWarningData> buildUnnamed422() => [
      buildNodeTypeAggregatedListWarningData(),
      buildNodeTypeAggregatedListWarningData(),
    ];

void checkUnnamed422(core.List<api.NodeTypeAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTypeAggregatedListWarningData(o[0]);
  checkNodeTypeAggregatedListWarningData(o[1]);
}

core.int buildCounterNodeTypeAggregatedListWarning = 0;
api.NodeTypeAggregatedListWarning buildNodeTypeAggregatedListWarning() {
  final o = api.NodeTypeAggregatedListWarning();
  buildCounterNodeTypeAggregatedListWarning++;
  if (buildCounterNodeTypeAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed422();
    o.message = 'foo';
  }
  buildCounterNodeTypeAggregatedListWarning--;
  return o;
}

void checkNodeTypeAggregatedListWarning(api.NodeTypeAggregatedListWarning o) {
  buildCounterNodeTypeAggregatedListWarning++;
  if (buildCounterNodeTypeAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed422(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTypeAggregatedListWarning--;
}

core.int buildCounterNodeTypeAggregatedList = 0;
api.NodeTypeAggregatedList buildNodeTypeAggregatedList() {
  final o = api.NodeTypeAggregatedList();
  buildCounterNodeTypeAggregatedList++;
  if (buildCounterNodeTypeAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed420();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed421();
    o.warning = buildNodeTypeAggregatedListWarning();
  }
  buildCounterNodeTypeAggregatedList--;
  return o;
}

void checkNodeTypeAggregatedList(api.NodeTypeAggregatedList o) {
  buildCounterNodeTypeAggregatedList++;
  if (buildCounterNodeTypeAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed420(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed421(o.unreachables!);
    checkNodeTypeAggregatedListWarning(o.warning!);
  }
  buildCounterNodeTypeAggregatedList--;
}

core.List<api.NodeType> buildUnnamed423() => [
      buildNodeType(),
      buildNodeType(),
    ];

void checkUnnamed423(core.List<api.NodeType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeType(o[0]);
  checkNodeType(o[1]);
}

core.int buildCounterNodeTypeListWarningData = 0;
api.NodeTypeListWarningData buildNodeTypeListWarningData() {
  final o = api.NodeTypeListWarningData();
  buildCounterNodeTypeListWarningData++;
  if (buildCounterNodeTypeListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeTypeListWarningData--;
  return o;
}

void checkNodeTypeListWarningData(api.NodeTypeListWarningData o) {
  buildCounterNodeTypeListWarningData++;
  if (buildCounterNodeTypeListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTypeListWarningData--;
}

core.List<api.NodeTypeListWarningData> buildUnnamed424() => [
      buildNodeTypeListWarningData(),
      buildNodeTypeListWarningData(),
    ];

void checkUnnamed424(core.List<api.NodeTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTypeListWarningData(o[0]);
  checkNodeTypeListWarningData(o[1]);
}

core.int buildCounterNodeTypeListWarning = 0;
api.NodeTypeListWarning buildNodeTypeListWarning() {
  final o = api.NodeTypeListWarning();
  buildCounterNodeTypeListWarning++;
  if (buildCounterNodeTypeListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed424();
    o.message = 'foo';
  }
  buildCounterNodeTypeListWarning--;
  return o;
}

void checkNodeTypeListWarning(api.NodeTypeListWarning o) {
  buildCounterNodeTypeListWarning++;
  if (buildCounterNodeTypeListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed424(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTypeListWarning--;
}

core.int buildCounterNodeTypeList = 0;
api.NodeTypeList buildNodeTypeList() {
  final o = api.NodeTypeList();
  buildCounterNodeTypeList++;
  if (buildCounterNodeTypeList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed423();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNodeTypeListWarning();
  }
  buildCounterNodeTypeList--;
  return o;
}

void checkNodeTypeList(api.NodeTypeList o) {
  buildCounterNodeTypeList++;
  if (buildCounterNodeTypeList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed423(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNodeTypeListWarning(o.warning!);
  }
  buildCounterNodeTypeList--;
}

core.List<api.NodeType> buildUnnamed425() => [
      buildNodeType(),
      buildNodeType(),
    ];

void checkUnnamed425(core.List<api.NodeType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeType(o[0]);
  checkNodeType(o[1]);
}

core.int buildCounterNodeTypesScopedListWarningData = 0;
api.NodeTypesScopedListWarningData buildNodeTypesScopedListWarningData() {
  final o = api.NodeTypesScopedListWarningData();
  buildCounterNodeTypesScopedListWarningData++;
  if (buildCounterNodeTypesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNodeTypesScopedListWarningData--;
  return o;
}

void checkNodeTypesScopedListWarningData(api.NodeTypesScopedListWarningData o) {
  buildCounterNodeTypesScopedListWarningData++;
  if (buildCounterNodeTypesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTypesScopedListWarningData--;
}

core.List<api.NodeTypesScopedListWarningData> buildUnnamed426() => [
      buildNodeTypesScopedListWarningData(),
      buildNodeTypesScopedListWarningData(),
    ];

void checkUnnamed426(core.List<api.NodeTypesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNodeTypesScopedListWarningData(o[0]);
  checkNodeTypesScopedListWarningData(o[1]);
}

core.int buildCounterNodeTypesScopedListWarning = 0;
api.NodeTypesScopedListWarning buildNodeTypesScopedListWarning() {
  final o = api.NodeTypesScopedListWarning();
  buildCounterNodeTypesScopedListWarning++;
  if (buildCounterNodeTypesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed426();
    o.message = 'foo';
  }
  buildCounterNodeTypesScopedListWarning--;
  return o;
}

void checkNodeTypesScopedListWarning(api.NodeTypesScopedListWarning o) {
  buildCounterNodeTypesScopedListWarning++;
  if (buildCounterNodeTypesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed426(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNodeTypesScopedListWarning--;
}

core.int buildCounterNodeTypesScopedList = 0;
api.NodeTypesScopedList buildNodeTypesScopedList() {
  final o = api.NodeTypesScopedList();
  buildCounterNodeTypesScopedList++;
  if (buildCounterNodeTypesScopedList < 3) {
    o.nodeTypes = buildUnnamed425();
    o.warning = buildNodeTypesScopedListWarning();
  }
  buildCounterNodeTypesScopedList--;
  return o;
}

void checkNodeTypesScopedList(api.NodeTypesScopedList o) {
  buildCounterNodeTypesScopedList++;
  if (buildCounterNodeTypesScopedList < 3) {
    checkUnnamed425(o.nodeTypes!);
    checkNodeTypesScopedListWarning(o.warning!);
  }
  buildCounterNodeTypesScopedList--;
}

core.int buildCounterNotificationEndpoint = 0;
api.NotificationEndpoint buildNotificationEndpoint() {
  final o = api.NotificationEndpoint();
  buildCounterNotificationEndpoint++;
  if (buildCounterNotificationEndpoint < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.grpcSettings = buildNotificationEndpointGrpcSettings();
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.region = 'foo';
    o.selfLink = 'foo';
  }
  buildCounterNotificationEndpoint--;
  return o;
}

void checkNotificationEndpoint(api.NotificationEndpoint o) {
  buildCounterNotificationEndpoint++;
  if (buildCounterNotificationEndpoint < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkNotificationEndpointGrpcSettings(o.grpcSettings!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
  }
  buildCounterNotificationEndpoint--;
}

core.int buildCounterNotificationEndpointGrpcSettings = 0;
api.NotificationEndpointGrpcSettings buildNotificationEndpointGrpcSettings() {
  final o = api.NotificationEndpointGrpcSettings();
  buildCounterNotificationEndpointGrpcSettings++;
  if (buildCounterNotificationEndpointGrpcSettings < 3) {
    o.authority = 'foo';
    o.endpoint = 'foo';
    o.payloadName = 'foo';
    o.resendInterval = buildDuration();
    o.retryDurationSec = 42;
  }
  buildCounterNotificationEndpointGrpcSettings--;
  return o;
}

void checkNotificationEndpointGrpcSettings(
    api.NotificationEndpointGrpcSettings o) {
  buildCounterNotificationEndpointGrpcSettings++;
  if (buildCounterNotificationEndpointGrpcSettings < 3) {
    unittest.expect(
      o.authority!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.endpoint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.payloadName!,
      unittest.equals('foo'),
    );
    checkDuration(o.resendInterval!);
    unittest.expect(
      o.retryDurationSec!,
      unittest.equals(42),
    );
  }
  buildCounterNotificationEndpointGrpcSettings--;
}

core.List<api.NotificationEndpoint> buildUnnamed427() => [
      buildNotificationEndpoint(),
      buildNotificationEndpoint(),
    ];

void checkUnnamed427(core.List<api.NotificationEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNotificationEndpoint(o[0]);
  checkNotificationEndpoint(o[1]);
}

core.int buildCounterNotificationEndpointListWarningData = 0;
api.NotificationEndpointListWarningData
    buildNotificationEndpointListWarningData() {
  final o = api.NotificationEndpointListWarningData();
  buildCounterNotificationEndpointListWarningData++;
  if (buildCounterNotificationEndpointListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterNotificationEndpointListWarningData--;
  return o;
}

void checkNotificationEndpointListWarningData(
    api.NotificationEndpointListWarningData o) {
  buildCounterNotificationEndpointListWarningData++;
  if (buildCounterNotificationEndpointListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterNotificationEndpointListWarningData--;
}

core.List<api.NotificationEndpointListWarningData> buildUnnamed428() => [
      buildNotificationEndpointListWarningData(),
      buildNotificationEndpointListWarningData(),
    ];

void checkUnnamed428(core.List<api.NotificationEndpointListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNotificationEndpointListWarningData(o[0]);
  checkNotificationEndpointListWarningData(o[1]);
}

core.int buildCounterNotificationEndpointListWarning = 0;
api.NotificationEndpointListWarning buildNotificationEndpointListWarning() {
  final o = api.NotificationEndpointListWarning();
  buildCounterNotificationEndpointListWarning++;
  if (buildCounterNotificationEndpointListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed428();
    o.message = 'foo';
  }
  buildCounterNotificationEndpointListWarning--;
  return o;
}

void checkNotificationEndpointListWarning(
    api.NotificationEndpointListWarning o) {
  buildCounterNotificationEndpointListWarning++;
  if (buildCounterNotificationEndpointListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed428(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterNotificationEndpointListWarning--;
}

core.int buildCounterNotificationEndpointList = 0;
api.NotificationEndpointList buildNotificationEndpointList() {
  final o = api.NotificationEndpointList();
  buildCounterNotificationEndpointList++;
  if (buildCounterNotificationEndpointList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed427();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildNotificationEndpointListWarning();
  }
  buildCounterNotificationEndpointList--;
  return o;
}

void checkNotificationEndpointList(api.NotificationEndpointList o) {
  buildCounterNotificationEndpointList++;
  if (buildCounterNotificationEndpointList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed427(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkNotificationEndpointListWarning(o.warning!);
  }
  buildCounterNotificationEndpointList--;
}

core.int buildCounterOperationErrorErrorsErrorDetails = 0;
api.OperationErrorErrorsErrorDetails buildOperationErrorErrorsErrorDetails() {
  final o = api.OperationErrorErrorsErrorDetails();
  buildCounterOperationErrorErrorsErrorDetails++;
  if (buildCounterOperationErrorErrorsErrorDetails < 3) {
    o.errorInfo = buildErrorInfo();
    o.help = buildHelp();
    o.localizedMessage = buildLocalizedMessage();
    o.quotaInfo = buildQuotaExceededInfo();
  }
  buildCounterOperationErrorErrorsErrorDetails--;
  return o;
}

void checkOperationErrorErrorsErrorDetails(
    api.OperationErrorErrorsErrorDetails o) {
  buildCounterOperationErrorErrorsErrorDetails++;
  if (buildCounterOperationErrorErrorsErrorDetails < 3) {
    checkErrorInfo(o.errorInfo!);
    checkHelp(o.help!);
    checkLocalizedMessage(o.localizedMessage!);
    checkQuotaExceededInfo(o.quotaInfo!);
  }
  buildCounterOperationErrorErrorsErrorDetails--;
}

core.List<api.OperationErrorErrorsErrorDetails> buildUnnamed429() => [
      buildOperationErrorErrorsErrorDetails(),
      buildOperationErrorErrorsErrorDetails(),
    ];

void checkUnnamed429(core.List<api.OperationErrorErrorsErrorDetails> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationErrorErrorsErrorDetails(o[0]);
  checkOperationErrorErrorsErrorDetails(o[1]);
}

core.int buildCounterOperationErrorErrors = 0;
api.OperationErrorErrors buildOperationErrorErrors() {
  final o = api.OperationErrorErrors();
  buildCounterOperationErrorErrors++;
  if (buildCounterOperationErrorErrors < 3) {
    o.code = 'foo';
    o.errorDetails = buildUnnamed429();
    o.location = 'foo';
    o.message = 'foo';
  }
  buildCounterOperationErrorErrors--;
  return o;
}

void checkOperationErrorErrors(api.OperationErrorErrors o) {
  buildCounterOperationErrorErrors++;
  if (buildCounterOperationErrorErrors < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed429(o.errorDetails!);
    unittest.expect(
      o.location!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationErrorErrors--;
}

core.List<api.OperationErrorErrors> buildUnnamed430() => [
      buildOperationErrorErrors(),
      buildOperationErrorErrors(),
    ];

void checkUnnamed430(core.List<api.OperationErrorErrors> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationErrorErrors(o[0]);
  checkOperationErrorErrors(o[1]);
}

core.int buildCounterOperationError = 0;
api.OperationError buildOperationError() {
  final o = api.OperationError();
  buildCounterOperationError++;
  if (buildCounterOperationError < 3) {
    o.errors = buildUnnamed430();
  }
  buildCounterOperationError--;
  return o;
}

void checkOperationError(api.OperationError o) {
  buildCounterOperationError++;
  if (buildCounterOperationError < 3) {
    checkUnnamed430(o.errors!);
  }
  buildCounterOperationError--;
}

core.int buildCounterOperationWarningsData = 0;
api.OperationWarningsData buildOperationWarningsData() {
  final o = api.OperationWarningsData();
  buildCounterOperationWarningsData++;
  if (buildCounterOperationWarningsData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterOperationWarningsData--;
  return o;
}

void checkOperationWarningsData(api.OperationWarningsData o) {
  buildCounterOperationWarningsData++;
  if (buildCounterOperationWarningsData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationWarningsData--;
}

core.List<api.OperationWarningsData> buildUnnamed431() => [
      buildOperationWarningsData(),
      buildOperationWarningsData(),
    ];

void checkUnnamed431(core.List<api.OperationWarningsData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationWarningsData(o[0]);
  checkOperationWarningsData(o[1]);
}

core.int buildCounterOperationWarnings = 0;
api.OperationWarnings buildOperationWarnings() {
  final o = api.OperationWarnings();
  buildCounterOperationWarnings++;
  if (buildCounterOperationWarnings < 3) {
    o.code = 'foo';
    o.data = buildUnnamed431();
    o.message = 'foo';
  }
  buildCounterOperationWarnings--;
  return o;
}

void checkOperationWarnings(api.OperationWarnings o) {
  buildCounterOperationWarnings++;
  if (buildCounterOperationWarnings < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed431(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationWarnings--;
}

core.List<api.OperationWarnings> buildUnnamed432() => [
      buildOperationWarnings(),
      buildOperationWarnings(),
    ];

void checkUnnamed432(core.List<api.OperationWarnings> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationWarnings(o[0]);
  checkOperationWarnings(o[1]);
}

core.int buildCounterOperation = 0;
api.Operation buildOperation() {
  final o = api.Operation();
  buildCounterOperation++;
  if (buildCounterOperation < 3) {
    o.clientOperationId = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.endTime = 'foo';
    o.error = buildOperationError();
    o.httpErrorMessage = 'foo';
    o.httpErrorStatusCode = 42;
    o.id = 'foo';
    o.insertTime = 'foo';
    o.instancesBulkInsertOperationMetadata =
        buildInstancesBulkInsertOperationMetadata();
    o.kind = 'foo';
    o.name = 'foo';
    o.operationGroupId = 'foo';
    o.operationType = 'foo';
    o.progress = 42;
    o.region = 'foo';
    o.selfLink = 'foo';
    o.setCommonInstanceMetadataOperationMetadata =
        buildSetCommonInstanceMetadataOperationMetadata();
    o.startTime = 'foo';
    o.status = 'foo';
    o.statusMessage = 'foo';
    o.targetId = 'foo';
    o.targetLink = 'foo';
    o.user = 'foo';
    o.warnings = buildUnnamed432();
    o.zone = 'foo';
  }
  buildCounterOperation--;
  return o;
}

void checkOperation(api.Operation o) {
  buildCounterOperation++;
  if (buildCounterOperation < 3) {
    unittest.expect(
      o.clientOperationId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.endTime!,
      unittest.equals('foo'),
    );
    checkOperationError(o.error!);
    unittest.expect(
      o.httpErrorMessage!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.httpErrorStatusCode!,
      unittest.equals(42),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.insertTime!,
      unittest.equals('foo'),
    );
    checkInstancesBulkInsertOperationMetadata(
        o.instancesBulkInsertOperationMetadata!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.operationGroupId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.operationType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.progress!,
      unittest.equals(42),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkSetCommonInstanceMetadataOperationMetadata(
        o.setCommonInstanceMetadataOperationMetadata!);
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.statusMessage!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.targetId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.targetLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.user!,
      unittest.equals('foo'),
    );
    checkUnnamed432(o.warnings!);
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperation--;
}

core.Map<core.String, api.OperationsScopedList> buildUnnamed433() => {
      'x': buildOperationsScopedList(),
      'y': buildOperationsScopedList(),
    };

void checkUnnamed433(core.Map<core.String, api.OperationsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationsScopedList(o['x']!);
  checkOperationsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed434() => [
      'foo',
      'foo',
    ];

void checkUnnamed434(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterOperationAggregatedListWarningData = 0;
api.OperationAggregatedListWarningData
    buildOperationAggregatedListWarningData() {
  final o = api.OperationAggregatedListWarningData();
  buildCounterOperationAggregatedListWarningData++;
  if (buildCounterOperationAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterOperationAggregatedListWarningData--;
  return o;
}

void checkOperationAggregatedListWarningData(
    api.OperationAggregatedListWarningData o) {
  buildCounterOperationAggregatedListWarningData++;
  if (buildCounterOperationAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationAggregatedListWarningData--;
}

core.List<api.OperationAggregatedListWarningData> buildUnnamed435() => [
      buildOperationAggregatedListWarningData(),
      buildOperationAggregatedListWarningData(),
    ];

void checkUnnamed435(core.List<api.OperationAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationAggregatedListWarningData(o[0]);
  checkOperationAggregatedListWarningData(o[1]);
}

core.int buildCounterOperationAggregatedListWarning = 0;
api.OperationAggregatedListWarning buildOperationAggregatedListWarning() {
  final o = api.OperationAggregatedListWarning();
  buildCounterOperationAggregatedListWarning++;
  if (buildCounterOperationAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed435();
    o.message = 'foo';
  }
  buildCounterOperationAggregatedListWarning--;
  return o;
}

void checkOperationAggregatedListWarning(api.OperationAggregatedListWarning o) {
  buildCounterOperationAggregatedListWarning++;
  if (buildCounterOperationAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed435(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationAggregatedListWarning--;
}

core.int buildCounterOperationAggregatedList = 0;
api.OperationAggregatedList buildOperationAggregatedList() {
  final o = api.OperationAggregatedList();
  buildCounterOperationAggregatedList++;
  if (buildCounterOperationAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed433();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed434();
    o.warning = buildOperationAggregatedListWarning();
  }
  buildCounterOperationAggregatedList--;
  return o;
}

void checkOperationAggregatedList(api.OperationAggregatedList o) {
  buildCounterOperationAggregatedList++;
  if (buildCounterOperationAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed433(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed434(o.unreachables!);
    checkOperationAggregatedListWarning(o.warning!);
  }
  buildCounterOperationAggregatedList--;
}

core.List<api.Operation> buildUnnamed436() => [
      buildOperation(),
      buildOperation(),
    ];

void checkUnnamed436(core.List<api.Operation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperation(o[0]);
  checkOperation(o[1]);
}

core.int buildCounterOperationListWarningData = 0;
api.OperationListWarningData buildOperationListWarningData() {
  final o = api.OperationListWarningData();
  buildCounterOperationListWarningData++;
  if (buildCounterOperationListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterOperationListWarningData--;
  return o;
}

void checkOperationListWarningData(api.OperationListWarningData o) {
  buildCounterOperationListWarningData++;
  if (buildCounterOperationListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationListWarningData--;
}

core.List<api.OperationListWarningData> buildUnnamed437() => [
      buildOperationListWarningData(),
      buildOperationListWarningData(),
    ];

void checkUnnamed437(core.List<api.OperationListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationListWarningData(o[0]);
  checkOperationListWarningData(o[1]);
}

core.int buildCounterOperationListWarning = 0;
api.OperationListWarning buildOperationListWarning() {
  final o = api.OperationListWarning();
  buildCounterOperationListWarning++;
  if (buildCounterOperationListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed437();
    o.message = 'foo';
  }
  buildCounterOperationListWarning--;
  return o;
}

void checkOperationListWarning(api.OperationListWarning o) {
  buildCounterOperationListWarning++;
  if (buildCounterOperationListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed437(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationListWarning--;
}

core.int buildCounterOperationList = 0;
api.OperationList buildOperationList() {
  final o = api.OperationList();
  buildCounterOperationList++;
  if (buildCounterOperationList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed436();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildOperationListWarning();
  }
  buildCounterOperationList--;
  return o;
}

void checkOperationList(api.OperationList o) {
  buildCounterOperationList++;
  if (buildCounterOperationList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed436(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkOperationListWarning(o.warning!);
  }
  buildCounterOperationList--;
}

core.List<api.Operation> buildUnnamed438() => [
      buildOperation(),
      buildOperation(),
    ];

void checkUnnamed438(core.List<api.Operation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperation(o[0]);
  checkOperation(o[1]);
}

core.int buildCounterOperationsScopedListWarningData = 0;
api.OperationsScopedListWarningData buildOperationsScopedListWarningData() {
  final o = api.OperationsScopedListWarningData();
  buildCounterOperationsScopedListWarningData++;
  if (buildCounterOperationsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterOperationsScopedListWarningData--;
  return o;
}

void checkOperationsScopedListWarningData(
    api.OperationsScopedListWarningData o) {
  buildCounterOperationsScopedListWarningData++;
  if (buildCounterOperationsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationsScopedListWarningData--;
}

core.List<api.OperationsScopedListWarningData> buildUnnamed439() => [
      buildOperationsScopedListWarningData(),
      buildOperationsScopedListWarningData(),
    ];

void checkUnnamed439(core.List<api.OperationsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkOperationsScopedListWarningData(o[0]);
  checkOperationsScopedListWarningData(o[1]);
}

core.int buildCounterOperationsScopedListWarning = 0;
api.OperationsScopedListWarning buildOperationsScopedListWarning() {
  final o = api.OperationsScopedListWarning();
  buildCounterOperationsScopedListWarning++;
  if (buildCounterOperationsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed439();
    o.message = 'foo';
  }
  buildCounterOperationsScopedListWarning--;
  return o;
}

void checkOperationsScopedListWarning(api.OperationsScopedListWarning o) {
  buildCounterOperationsScopedListWarning++;
  if (buildCounterOperationsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed439(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterOperationsScopedListWarning--;
}

core.int buildCounterOperationsScopedList = 0;
api.OperationsScopedList buildOperationsScopedList() {
  final o = api.OperationsScopedList();
  buildCounterOperationsScopedList++;
  if (buildCounterOperationsScopedList < 3) {
    o.operations = buildUnnamed438();
    o.warning = buildOperationsScopedListWarning();
  }
  buildCounterOperationsScopedList--;
  return o;
}

void checkOperationsScopedList(api.OperationsScopedList o) {
  buildCounterOperationsScopedList++;
  if (buildCounterOperationsScopedList < 3) {
    checkUnnamed438(o.operations!);
    checkOperationsScopedListWarning(o.warning!);
  }
  buildCounterOperationsScopedList--;
}

core.int buildCounterOutlierDetection = 0;
api.OutlierDetection buildOutlierDetection() {
  final o = api.OutlierDetection();
  buildCounterOutlierDetection++;
  if (buildCounterOutlierDetection < 3) {
    o.baseEjectionTime = buildDuration();
    o.consecutiveErrors = 42;
    o.consecutiveGatewayFailure = 42;
    o.enforcingConsecutiveErrors = 42;
    o.enforcingConsecutiveGatewayFailure = 42;
    o.enforcingSuccessRate = 42;
    o.interval = buildDuration();
    o.maxEjectionPercent = 42;
    o.successRateMinimumHosts = 42;
    o.successRateRequestVolume = 42;
    o.successRateStdevFactor = 42;
  }
  buildCounterOutlierDetection--;
  return o;
}

void checkOutlierDetection(api.OutlierDetection o) {
  buildCounterOutlierDetection++;
  if (buildCounterOutlierDetection < 3) {
    checkDuration(o.baseEjectionTime!);
    unittest.expect(
      o.consecutiveErrors!,
      unittest.equals(42),
    );
    unittest.expect(
      o.consecutiveGatewayFailure!,
      unittest.equals(42),
    );
    unittest.expect(
      o.enforcingConsecutiveErrors!,
      unittest.equals(42),
    );
    unittest.expect(
      o.enforcingConsecutiveGatewayFailure!,
      unittest.equals(42),
    );
    unittest.expect(
      o.enforcingSuccessRate!,
      unittest.equals(42),
    );
    checkDuration(o.interval!);
    unittest.expect(
      o.maxEjectionPercent!,
      unittest.equals(42),
    );
    unittest.expect(
      o.successRateMinimumHosts!,
      unittest.equals(42),
    );
    unittest.expect(
      o.successRateRequestVolume!,
      unittest.equals(42),
    );
    unittest.expect(
      o.successRateStdevFactor!,
      unittest.equals(42),
    );
  }
  buildCounterOutlierDetection--;
}

core.int buildCounterPacketIntervals = 0;
api.PacketIntervals buildPacketIntervals() {
  final o = api.PacketIntervals();
  buildCounterPacketIntervals++;
  if (buildCounterPacketIntervals < 3) {
    o.avgMs = 'foo';
    o.duration = 'foo';
    o.maxMs = 'foo';
    o.minMs = 'foo';
    o.numIntervals = 'foo';
    o.type = 'foo';
  }
  buildCounterPacketIntervals--;
  return o;
}

void checkPacketIntervals(api.PacketIntervals o) {
  buildCounterPacketIntervals++;
  if (buildCounterPacketIntervals < 3) {
    unittest.expect(
      o.avgMs!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.duration!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.maxMs!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.minMs!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.numIntervals!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketIntervals--;
}

core.int buildCounterPacketMirroring = 0;
api.PacketMirroring buildPacketMirroring() {
  final o = api.PacketMirroring();
  buildCounterPacketMirroring++;
  if (buildCounterPacketMirroring < 3) {
    o.collectorIlb = buildPacketMirroringForwardingRuleInfo();
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.enable = 'foo';
    o.filter = buildPacketMirroringFilter();
    o.id = 'foo';
    o.kind = 'foo';
    o.mirroredResources = buildPacketMirroringMirroredResourceInfo();
    o.name = 'foo';
    o.network = buildPacketMirroringNetworkInfo();
    o.priority = 42;
    o.region = 'foo';
    o.selfLink = 'foo';
  }
  buildCounterPacketMirroring--;
  return o;
}

void checkPacketMirroring(api.PacketMirroring o) {
  buildCounterPacketMirroring++;
  if (buildCounterPacketMirroring < 3) {
    checkPacketMirroringForwardingRuleInfo(o.collectorIlb!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.enable!,
      unittest.equals('foo'),
    );
    checkPacketMirroringFilter(o.filter!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkPacketMirroringMirroredResourceInfo(o.mirroredResources!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkPacketMirroringNetworkInfo(o.network!);
    unittest.expect(
      o.priority!,
      unittest.equals(42),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroring--;
}

core.Map<core.String, api.PacketMirroringsScopedList> buildUnnamed440() => {
      'x': buildPacketMirroringsScopedList(),
      'y': buildPacketMirroringsScopedList(),
    };

void checkUnnamed440(core.Map<core.String, api.PacketMirroringsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketMirroringsScopedList(o['x']!);
  checkPacketMirroringsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed441() => [
      'foo',
      'foo',
    ];

void checkUnnamed441(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterPacketMirroringAggregatedListWarningData = 0;
api.PacketMirroringAggregatedListWarningData
    buildPacketMirroringAggregatedListWarningData() {
  final o = api.PacketMirroringAggregatedListWarningData();
  buildCounterPacketMirroringAggregatedListWarningData++;
  if (buildCounterPacketMirroringAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterPacketMirroringAggregatedListWarningData--;
  return o;
}

void checkPacketMirroringAggregatedListWarningData(
    api.PacketMirroringAggregatedListWarningData o) {
  buildCounterPacketMirroringAggregatedListWarningData++;
  if (buildCounterPacketMirroringAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringAggregatedListWarningData--;
}

core.List<api.PacketMirroringAggregatedListWarningData> buildUnnamed442() => [
      buildPacketMirroringAggregatedListWarningData(),
      buildPacketMirroringAggregatedListWarningData(),
    ];

void checkUnnamed442(
    core.List<api.PacketMirroringAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketMirroringAggregatedListWarningData(o[0]);
  checkPacketMirroringAggregatedListWarningData(o[1]);
}

core.int buildCounterPacketMirroringAggregatedListWarning = 0;
api.PacketMirroringAggregatedListWarning
    buildPacketMirroringAggregatedListWarning() {
  final o = api.PacketMirroringAggregatedListWarning();
  buildCounterPacketMirroringAggregatedListWarning++;
  if (buildCounterPacketMirroringAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed442();
    o.message = 'foo';
  }
  buildCounterPacketMirroringAggregatedListWarning--;
  return o;
}

void checkPacketMirroringAggregatedListWarning(
    api.PacketMirroringAggregatedListWarning o) {
  buildCounterPacketMirroringAggregatedListWarning++;
  if (buildCounterPacketMirroringAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed442(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringAggregatedListWarning--;
}

core.int buildCounterPacketMirroringAggregatedList = 0;
api.PacketMirroringAggregatedList buildPacketMirroringAggregatedList() {
  final o = api.PacketMirroringAggregatedList();
  buildCounterPacketMirroringAggregatedList++;
  if (buildCounterPacketMirroringAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed440();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed441();
    o.warning = buildPacketMirroringAggregatedListWarning();
  }
  buildCounterPacketMirroringAggregatedList--;
  return o;
}

void checkPacketMirroringAggregatedList(api.PacketMirroringAggregatedList o) {
  buildCounterPacketMirroringAggregatedList++;
  if (buildCounterPacketMirroringAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed440(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed441(o.unreachables!);
    checkPacketMirroringAggregatedListWarning(o.warning!);
  }
  buildCounterPacketMirroringAggregatedList--;
}

core.List<core.String> buildUnnamed443() => [
      'foo',
      'foo',
    ];

void checkUnnamed443(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed444() => [
      'foo',
      'foo',
    ];

void checkUnnamed444(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterPacketMirroringFilter = 0;
api.PacketMirroringFilter buildPacketMirroringFilter() {
  final o = api.PacketMirroringFilter();
  buildCounterPacketMirroringFilter++;
  if (buildCounterPacketMirroringFilter < 3) {
    o.IPProtocols = buildUnnamed443();
    o.cidrRanges = buildUnnamed444();
    o.direction = 'foo';
  }
  buildCounterPacketMirroringFilter--;
  return o;
}

void checkPacketMirroringFilter(api.PacketMirroringFilter o) {
  buildCounterPacketMirroringFilter++;
  if (buildCounterPacketMirroringFilter < 3) {
    checkUnnamed443(o.IPProtocols!);
    checkUnnamed444(o.cidrRanges!);
    unittest.expect(
      o.direction!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringFilter--;
}

core.int buildCounterPacketMirroringForwardingRuleInfo = 0;
api.PacketMirroringForwardingRuleInfo buildPacketMirroringForwardingRuleInfo() {
  final o = api.PacketMirroringForwardingRuleInfo();
  buildCounterPacketMirroringForwardingRuleInfo++;
  if (buildCounterPacketMirroringForwardingRuleInfo < 3) {
    o.canonicalUrl = 'foo';
    o.url = 'foo';
  }
  buildCounterPacketMirroringForwardingRuleInfo--;
  return o;
}

void checkPacketMirroringForwardingRuleInfo(
    api.PacketMirroringForwardingRuleInfo o) {
  buildCounterPacketMirroringForwardingRuleInfo++;
  if (buildCounterPacketMirroringForwardingRuleInfo < 3) {
    unittest.expect(
      o.canonicalUrl!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.url!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringForwardingRuleInfo--;
}

core.List<api.PacketMirroring> buildUnnamed445() => [
      buildPacketMirroring(),
      buildPacketMirroring(),
    ];

void checkUnnamed445(core.List<api.PacketMirroring> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketMirroring(o[0]);
  checkPacketMirroring(o[1]);
}

core.int buildCounterPacketMirroringListWarningData = 0;
api.PacketMirroringListWarningData buildPacketMirroringListWarningData() {
  final o = api.PacketMirroringListWarningData();
  buildCounterPacketMirroringListWarningData++;
  if (buildCounterPacketMirroringListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterPacketMirroringListWarningData--;
  return o;
}

void checkPacketMirroringListWarningData(api.PacketMirroringListWarningData o) {
  buildCounterPacketMirroringListWarningData++;
  if (buildCounterPacketMirroringListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringListWarningData--;
}

core.List<api.PacketMirroringListWarningData> buildUnnamed446() => [
      buildPacketMirroringListWarningData(),
      buildPacketMirroringListWarningData(),
    ];

void checkUnnamed446(core.List<api.PacketMirroringListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketMirroringListWarningData(o[0]);
  checkPacketMirroringListWarningData(o[1]);
}

core.int buildCounterPacketMirroringListWarning = 0;
api.PacketMirroringListWarning buildPacketMirroringListWarning() {
  final o = api.PacketMirroringListWarning();
  buildCounterPacketMirroringListWarning++;
  if (buildCounterPacketMirroringListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed446();
    o.message = 'foo';
  }
  buildCounterPacketMirroringListWarning--;
  return o;
}

void checkPacketMirroringListWarning(api.PacketMirroringListWarning o) {
  buildCounterPacketMirroringListWarning++;
  if (buildCounterPacketMirroringListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed446(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringListWarning--;
}

core.int buildCounterPacketMirroringList = 0;
api.PacketMirroringList buildPacketMirroringList() {
  final o = api.PacketMirroringList();
  buildCounterPacketMirroringList++;
  if (buildCounterPacketMirroringList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed445();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildPacketMirroringListWarning();
  }
  buildCounterPacketMirroringList--;
  return o;
}

void checkPacketMirroringList(api.PacketMirroringList o) {
  buildCounterPacketMirroringList++;
  if (buildCounterPacketMirroringList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed445(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkPacketMirroringListWarning(o.warning!);
  }
  buildCounterPacketMirroringList--;
}

core.List<api.PacketMirroringMirroredResourceInfoInstanceInfo>
    buildUnnamed447() => [
          buildPacketMirroringMirroredResourceInfoInstanceInfo(),
          buildPacketMirroringMirroredResourceInfoInstanceInfo(),
        ];

void checkUnnamed447(
    core.List<api.PacketMirroringMirroredResourceInfoInstanceInfo> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketMirroringMirroredResourceInfoInstanceInfo(o[0]);
  checkPacketMirroringMirroredResourceInfoInstanceInfo(o[1]);
}

core.List<api.PacketMirroringMirroredResourceInfoSubnetInfo>
    buildUnnamed448() => [
          buildPacketMirroringMirroredResourceInfoSubnetInfo(),
          buildPacketMirroringMirroredResourceInfoSubnetInfo(),
        ];

void checkUnnamed448(
    core.List<api.PacketMirroringMirroredResourceInfoSubnetInfo> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketMirroringMirroredResourceInfoSubnetInfo(o[0]);
  checkPacketMirroringMirroredResourceInfoSubnetInfo(o[1]);
}

core.List<core.String> buildUnnamed449() => [
      'foo',
      'foo',
    ];

void checkUnnamed449(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterPacketMirroringMirroredResourceInfo = 0;
api.PacketMirroringMirroredResourceInfo
    buildPacketMirroringMirroredResourceInfo() {
  final o = api.PacketMirroringMirroredResourceInfo();
  buildCounterPacketMirroringMirroredResourceInfo++;
  if (buildCounterPacketMirroringMirroredResourceInfo < 3) {
    o.instances = buildUnnamed447();
    o.subnetworks = buildUnnamed448();
    o.tags = buildUnnamed449();
  }
  buildCounterPacketMirroringMirroredResourceInfo--;
  return o;
}

void checkPacketMirroringMirroredResourceInfo(
    api.PacketMirroringMirroredResourceInfo o) {
  buildCounterPacketMirroringMirroredResourceInfo++;
  if (buildCounterPacketMirroringMirroredResourceInfo < 3) {
    checkUnnamed447(o.instances!);
    checkUnnamed448(o.subnetworks!);
    checkUnnamed449(o.tags!);
  }
  buildCounterPacketMirroringMirroredResourceInfo--;
}

core.int buildCounterPacketMirroringMirroredResourceInfoInstanceInfo = 0;
api.PacketMirroringMirroredResourceInfoInstanceInfo
    buildPacketMirroringMirroredResourceInfoInstanceInfo() {
  final o = api.PacketMirroringMirroredResourceInfoInstanceInfo();
  buildCounterPacketMirroringMirroredResourceInfoInstanceInfo++;
  if (buildCounterPacketMirroringMirroredResourceInfoInstanceInfo < 3) {
    o.canonicalUrl = 'foo';
    o.url = 'foo';
  }
  buildCounterPacketMirroringMirroredResourceInfoInstanceInfo--;
  return o;
}

void checkPacketMirroringMirroredResourceInfoInstanceInfo(
    api.PacketMirroringMirroredResourceInfoInstanceInfo o) {
  buildCounterPacketMirroringMirroredResourceInfoInstanceInfo++;
  if (buildCounterPacketMirroringMirroredResourceInfoInstanceInfo < 3) {
    unittest.expect(
      o.canonicalUrl!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.url!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringMirroredResourceInfoInstanceInfo--;
}

core.int buildCounterPacketMirroringMirroredResourceInfoSubnetInfo = 0;
api.PacketMirroringMirroredResourceInfoSubnetInfo
    buildPacketMirroringMirroredResourceInfoSubnetInfo() {
  final o = api.PacketMirroringMirroredResourceInfoSubnetInfo();
  buildCounterPacketMirroringMirroredResourceInfoSubnetInfo++;
  if (buildCounterPacketMirroringMirroredResourceInfoSubnetInfo < 3) {
    o.canonicalUrl = 'foo';
    o.url = 'foo';
  }
  buildCounterPacketMirroringMirroredResourceInfoSubnetInfo--;
  return o;
}

void checkPacketMirroringMirroredResourceInfoSubnetInfo(
    api.PacketMirroringMirroredResourceInfoSubnetInfo o) {
  buildCounterPacketMirroringMirroredResourceInfoSubnetInfo++;
  if (buildCounterPacketMirroringMirroredResourceInfoSubnetInfo < 3) {
    unittest.expect(
      o.canonicalUrl!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.url!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringMirroredResourceInfoSubnetInfo--;
}

core.int buildCounterPacketMirroringNetworkInfo = 0;
api.PacketMirroringNetworkInfo buildPacketMirroringNetworkInfo() {
  final o = api.PacketMirroringNetworkInfo();
  buildCounterPacketMirroringNetworkInfo++;
  if (buildCounterPacketMirroringNetworkInfo < 3) {
    o.canonicalUrl = 'foo';
    o.url = 'foo';
  }
  buildCounterPacketMirroringNetworkInfo--;
  return o;
}

void checkPacketMirroringNetworkInfo(api.PacketMirroringNetworkInfo o) {
  buildCounterPacketMirroringNetworkInfo++;
  if (buildCounterPacketMirroringNetworkInfo < 3) {
    unittest.expect(
      o.canonicalUrl!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.url!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringNetworkInfo--;
}

core.List<api.PacketMirroring> buildUnnamed450() => [
      buildPacketMirroring(),
      buildPacketMirroring(),
    ];

void checkUnnamed450(core.List<api.PacketMirroring> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketMirroring(o[0]);
  checkPacketMirroring(o[1]);
}

core.int buildCounterPacketMirroringsScopedListWarningData = 0;
api.PacketMirroringsScopedListWarningData
    buildPacketMirroringsScopedListWarningData() {
  final o = api.PacketMirroringsScopedListWarningData();
  buildCounterPacketMirroringsScopedListWarningData++;
  if (buildCounterPacketMirroringsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterPacketMirroringsScopedListWarningData--;
  return o;
}

void checkPacketMirroringsScopedListWarningData(
    api.PacketMirroringsScopedListWarningData o) {
  buildCounterPacketMirroringsScopedListWarningData++;
  if (buildCounterPacketMirroringsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringsScopedListWarningData--;
}

core.List<api.PacketMirroringsScopedListWarningData> buildUnnamed451() => [
      buildPacketMirroringsScopedListWarningData(),
      buildPacketMirroringsScopedListWarningData(),
    ];

void checkUnnamed451(core.List<api.PacketMirroringsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPacketMirroringsScopedListWarningData(o[0]);
  checkPacketMirroringsScopedListWarningData(o[1]);
}

core.int buildCounterPacketMirroringsScopedListWarning = 0;
api.PacketMirroringsScopedListWarning buildPacketMirroringsScopedListWarning() {
  final o = api.PacketMirroringsScopedListWarning();
  buildCounterPacketMirroringsScopedListWarning++;
  if (buildCounterPacketMirroringsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed451();
    o.message = 'foo';
  }
  buildCounterPacketMirroringsScopedListWarning--;
  return o;
}

void checkPacketMirroringsScopedListWarning(
    api.PacketMirroringsScopedListWarning o) {
  buildCounterPacketMirroringsScopedListWarning++;
  if (buildCounterPacketMirroringsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed451(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterPacketMirroringsScopedListWarning--;
}

core.int buildCounterPacketMirroringsScopedList = 0;
api.PacketMirroringsScopedList buildPacketMirroringsScopedList() {
  final o = api.PacketMirroringsScopedList();
  buildCounterPacketMirroringsScopedList++;
  if (buildCounterPacketMirroringsScopedList < 3) {
    o.packetMirrorings = buildUnnamed450();
    o.warning = buildPacketMirroringsScopedListWarning();
  }
  buildCounterPacketMirroringsScopedList--;
  return o;
}

void checkPacketMirroringsScopedList(api.PacketMirroringsScopedList o) {
  buildCounterPacketMirroringsScopedList++;
  if (buildCounterPacketMirroringsScopedList < 3) {
    checkUnnamed450(o.packetMirrorings!);
    checkPacketMirroringsScopedListWarning(o.warning!);
  }
  buildCounterPacketMirroringsScopedList--;
}

core.List<api.PathRule> buildUnnamed452() => [
      buildPathRule(),
      buildPathRule(),
    ];

void checkUnnamed452(core.List<api.PathRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPathRule(o[0]);
  checkPathRule(o[1]);
}

core.List<api.HttpRouteRule> buildUnnamed453() => [
      buildHttpRouteRule(),
      buildHttpRouteRule(),
    ];

void checkUnnamed453(core.List<api.HttpRouteRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkHttpRouteRule(o[0]);
  checkHttpRouteRule(o[1]);
}

core.int buildCounterPathMatcher = 0;
api.PathMatcher buildPathMatcher() {
  final o = api.PathMatcher();
  buildCounterPathMatcher++;
  if (buildCounterPathMatcher < 3) {
    o.defaultRouteAction = buildHttpRouteAction();
    o.defaultService = 'foo';
    o.defaultUrlRedirect = buildHttpRedirectAction();
    o.description = 'foo';
    o.headerAction = buildHttpHeaderAction();
    o.name = 'foo';
    o.pathRules = buildUnnamed452();
    o.routeRules = buildUnnamed453();
  }
  buildCounterPathMatcher--;
  return o;
}

void checkPathMatcher(api.PathMatcher o) {
  buildCounterPathMatcher++;
  if (buildCounterPathMatcher < 3) {
    checkHttpRouteAction(o.defaultRouteAction!);
    unittest.expect(
      o.defaultService!,
      unittest.equals('foo'),
    );
    checkHttpRedirectAction(o.defaultUrlRedirect!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkHttpHeaderAction(o.headerAction!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed452(o.pathRules!);
    checkUnnamed453(o.routeRules!);
  }
  buildCounterPathMatcher--;
}

core.List<core.String> buildUnnamed454() => [
      'foo',
      'foo',
    ];

void checkUnnamed454(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterPathRule = 0;
api.PathRule buildPathRule() {
  final o = api.PathRule();
  buildCounterPathRule++;
  if (buildCounterPathRule < 3) {
    o.paths = buildUnnamed454();
    o.routeAction = buildHttpRouteAction();
    o.service = 'foo';
    o.urlRedirect = buildHttpRedirectAction();
  }
  buildCounterPathRule--;
  return o;
}

void checkPathRule(api.PathRule o) {
  buildCounterPathRule++;
  if (buildCounterPathRule < 3) {
    checkUnnamed454(o.paths!);
    checkHttpRouteAction(o.routeAction!);
    unittest.expect(
      o.service!,
      unittest.equals('foo'),
    );
    checkHttpRedirectAction(o.urlRedirect!);
  }
  buildCounterPathRule--;
}

core.int buildCounterPerInstanceConfig = 0;
api.PerInstanceConfig buildPerInstanceConfig() {
  final o = api.PerInstanceConfig();
  buildCounterPerInstanceConfig++;
  if (buildCounterPerInstanceConfig < 3) {
    o.fingerprint = 'foo';
    o.name = 'foo';
    o.preservedState = buildPreservedState();
    o.status = 'foo';
  }
  buildCounterPerInstanceConfig--;
  return o;
}

void checkPerInstanceConfig(api.PerInstanceConfig o) {
  buildCounterPerInstanceConfig++;
  if (buildCounterPerInstanceConfig < 3) {
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkPreservedState(o.preservedState!);
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterPerInstanceConfig--;
}

core.List<api.AuditConfig> buildUnnamed455() => [
      buildAuditConfig(),
      buildAuditConfig(),
    ];

void checkUnnamed455(core.List<api.AuditConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAuditConfig(o[0]);
  checkAuditConfig(o[1]);
}

core.List<api.Binding> buildUnnamed456() => [
      buildBinding(),
      buildBinding(),
    ];

void checkUnnamed456(core.List<api.Binding> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBinding(o[0]);
  checkBinding(o[1]);
}

core.List<api.Rule> buildUnnamed457() => [
      buildRule(),
      buildRule(),
    ];

void checkUnnamed457(core.List<api.Rule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRule(o[0]);
  checkRule(o[1]);
}

core.int buildCounterPolicy = 0;
api.Policy buildPolicy() {
  final o = api.Policy();
  buildCounterPolicy++;
  if (buildCounterPolicy < 3) {
    o.auditConfigs = buildUnnamed455();
    o.bindings = buildUnnamed456();
    o.etag = 'foo';
    o.rules = buildUnnamed457();
    o.version = 42;
  }
  buildCounterPolicy--;
  return o;
}

void checkPolicy(api.Policy o) {
  buildCounterPolicy++;
  if (buildCounterPolicy < 3) {
    checkUnnamed455(o.auditConfigs!);
    checkUnnamed456(o.bindings!);
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    checkUnnamed457(o.rules!);
    unittest.expect(
      o.version!,
      unittest.equals(42),
    );
  }
  buildCounterPolicy--;
}

core.List<api.WafExpressionSet> buildUnnamed458() => [
      buildWafExpressionSet(),
      buildWafExpressionSet(),
    ];

void checkUnnamed458(core.List<api.WafExpressionSet> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkWafExpressionSet(o[0]);
  checkWafExpressionSet(o[1]);
}

core.int buildCounterPreconfiguredWafSet = 0;
api.PreconfiguredWafSet buildPreconfiguredWafSet() {
  final o = api.PreconfiguredWafSet();
  buildCounterPreconfiguredWafSet++;
  if (buildCounterPreconfiguredWafSet < 3) {
    o.expressionSets = buildUnnamed458();
  }
  buildCounterPreconfiguredWafSet--;
  return o;
}

void checkPreconfiguredWafSet(api.PreconfiguredWafSet o) {
  buildCounterPreconfiguredWafSet++;
  if (buildCounterPreconfiguredWafSet < 3) {
    checkUnnamed458(o.expressionSets!);
  }
  buildCounterPreconfiguredWafSet--;
}

core.Map<core.String, api.PreservedStatePreservedDisk> buildUnnamed459() => {
      'x': buildPreservedStatePreservedDisk(),
      'y': buildPreservedStatePreservedDisk(),
    };

void checkUnnamed459(core.Map<core.String, api.PreservedStatePreservedDisk> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPreservedStatePreservedDisk(o['x']!);
  checkPreservedStatePreservedDisk(o['y']!);
}

core.Map<core.String, api.PreservedStatePreservedNetworkIp> buildUnnamed460() =>
    {
      'x': buildPreservedStatePreservedNetworkIp(),
      'y': buildPreservedStatePreservedNetworkIp(),
    };

void checkUnnamed460(
    core.Map<core.String, api.PreservedStatePreservedNetworkIp> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPreservedStatePreservedNetworkIp(o['x']!);
  checkPreservedStatePreservedNetworkIp(o['y']!);
}

core.Map<core.String, api.PreservedStatePreservedNetworkIp> buildUnnamed461() =>
    {
      'x': buildPreservedStatePreservedNetworkIp(),
      'y': buildPreservedStatePreservedNetworkIp(),
    };

void checkUnnamed461(
    core.Map<core.String, api.PreservedStatePreservedNetworkIp> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPreservedStatePreservedNetworkIp(o['x']!);
  checkPreservedStatePreservedNetworkIp(o['y']!);
}

core.Map<core.String, core.String> buildUnnamed462() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed462(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterPreservedState = 0;
api.PreservedState buildPreservedState() {
  final o = api.PreservedState();
  buildCounterPreservedState++;
  if (buildCounterPreservedState < 3) {
    o.disks = buildUnnamed459();
    o.externalIPs = buildUnnamed460();
    o.internalIPs = buildUnnamed461();
    o.metadata = buildUnnamed462();
  }
  buildCounterPreservedState--;
  return o;
}

void checkPreservedState(api.PreservedState o) {
  buildCounterPreservedState++;
  if (buildCounterPreservedState < 3) {
    checkUnnamed459(o.disks!);
    checkUnnamed460(o.externalIPs!);
    checkUnnamed461(o.internalIPs!);
    checkUnnamed462(o.metadata!);
  }
  buildCounterPreservedState--;
}

core.int buildCounterPreservedStatePreservedDisk = 0;
api.PreservedStatePreservedDisk buildPreservedStatePreservedDisk() {
  final o = api.PreservedStatePreservedDisk();
  buildCounterPreservedStatePreservedDisk++;
  if (buildCounterPreservedStatePreservedDisk < 3) {
    o.autoDelete = 'foo';
    o.mode = 'foo';
    o.source = 'foo';
  }
  buildCounterPreservedStatePreservedDisk--;
  return o;
}

void checkPreservedStatePreservedDisk(api.PreservedStatePreservedDisk o) {
  buildCounterPreservedStatePreservedDisk++;
  if (buildCounterPreservedStatePreservedDisk < 3) {
    unittest.expect(
      o.autoDelete!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.mode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.source!,
      unittest.equals('foo'),
    );
  }
  buildCounterPreservedStatePreservedDisk--;
}

core.int buildCounterPreservedStatePreservedNetworkIp = 0;
api.PreservedStatePreservedNetworkIp buildPreservedStatePreservedNetworkIp() {
  final o = api.PreservedStatePreservedNetworkIp();
  buildCounterPreservedStatePreservedNetworkIp++;
  if (buildCounterPreservedStatePreservedNetworkIp < 3) {
    o.autoDelete = 'foo';
    o.ipAddress = buildPreservedStatePreservedNetworkIpIpAddress();
  }
  buildCounterPreservedStatePreservedNetworkIp--;
  return o;
}

void checkPreservedStatePreservedNetworkIp(
    api.PreservedStatePreservedNetworkIp o) {
  buildCounterPreservedStatePreservedNetworkIp++;
  if (buildCounterPreservedStatePreservedNetworkIp < 3) {
    unittest.expect(
      o.autoDelete!,
      unittest.equals('foo'),
    );
    checkPreservedStatePreservedNetworkIpIpAddress(o.ipAddress!);
  }
  buildCounterPreservedStatePreservedNetworkIp--;
}

core.int buildCounterPreservedStatePreservedNetworkIpIpAddress = 0;
api.PreservedStatePreservedNetworkIpIpAddress
    buildPreservedStatePreservedNetworkIpIpAddress() {
  final o = api.PreservedStatePreservedNetworkIpIpAddress();
  buildCounterPreservedStatePreservedNetworkIpIpAddress++;
  if (buildCounterPreservedStatePreservedNetworkIpIpAddress < 3) {
    o.address = 'foo';
    o.literal = 'foo';
  }
  buildCounterPreservedStatePreservedNetworkIpIpAddress--;
  return o;
}

void checkPreservedStatePreservedNetworkIpIpAddress(
    api.PreservedStatePreservedNetworkIpIpAddress o) {
  buildCounterPreservedStatePreservedNetworkIpIpAddress++;
  if (buildCounterPreservedStatePreservedNetworkIpIpAddress < 3) {
    unittest.expect(
      o.address!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.literal!,
      unittest.equals('foo'),
    );
  }
  buildCounterPreservedStatePreservedNetworkIpIpAddress--;
}

core.List<core.String> buildUnnamed463() => [
      'foo',
      'foo',
    ];

void checkUnnamed463(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.Quota> buildUnnamed464() => [
      buildQuota(),
      buildQuota(),
    ];

void checkUnnamed464(core.List<api.Quota> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkQuota(o[0]);
  checkQuota(o[1]);
}

core.int buildCounterProject = 0;
api.Project buildProject() {
  final o = api.Project();
  buildCounterProject++;
  if (buildCounterProject < 3) {
    o.commonInstanceMetadata = buildMetadata();
    o.creationTimestamp = 'foo';
    o.defaultNetworkTier = 'foo';
    o.defaultServiceAccount = 'foo';
    o.description = 'foo';
    o.enabledFeatures = buildUnnamed463();
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.quotas = buildUnnamed464();
    o.selfLink = 'foo';
    o.usageExportLocation = buildUsageExportLocation();
    o.vmDnsSetting = 'foo';
    o.xpnProjectStatus = 'foo';
  }
  buildCounterProject--;
  return o;
}

void checkProject(api.Project o) {
  buildCounterProject++;
  if (buildCounterProject < 3) {
    checkMetadata(o.commonInstanceMetadata!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.defaultNetworkTier!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.defaultServiceAccount!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed463(o.enabledFeatures!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed464(o.quotas!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUsageExportLocation(o.usageExportLocation!);
    unittest.expect(
      o.vmDnsSetting!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.xpnProjectStatus!,
      unittest.equals('foo'),
    );
  }
  buildCounterProject--;
}

core.int buildCounterProjectsDisableXpnResourceRequest = 0;
api.ProjectsDisableXpnResourceRequest buildProjectsDisableXpnResourceRequest() {
  final o = api.ProjectsDisableXpnResourceRequest();
  buildCounterProjectsDisableXpnResourceRequest++;
  if (buildCounterProjectsDisableXpnResourceRequest < 3) {
    o.xpnResource = buildXpnResourceId();
  }
  buildCounterProjectsDisableXpnResourceRequest--;
  return o;
}

void checkProjectsDisableXpnResourceRequest(
    api.ProjectsDisableXpnResourceRequest o) {
  buildCounterProjectsDisableXpnResourceRequest++;
  if (buildCounterProjectsDisableXpnResourceRequest < 3) {
    checkXpnResourceId(o.xpnResource!);
  }
  buildCounterProjectsDisableXpnResourceRequest--;
}

core.int buildCounterProjectsEnableXpnResourceRequest = 0;
api.ProjectsEnableXpnResourceRequest buildProjectsEnableXpnResourceRequest() {
  final o = api.ProjectsEnableXpnResourceRequest();
  buildCounterProjectsEnableXpnResourceRequest++;
  if (buildCounterProjectsEnableXpnResourceRequest < 3) {
    o.xpnResource = buildXpnResourceId();
  }
  buildCounterProjectsEnableXpnResourceRequest--;
  return o;
}

void checkProjectsEnableXpnResourceRequest(
    api.ProjectsEnableXpnResourceRequest o) {
  buildCounterProjectsEnableXpnResourceRequest++;
  if (buildCounterProjectsEnableXpnResourceRequest < 3) {
    checkXpnResourceId(o.xpnResource!);
  }
  buildCounterProjectsEnableXpnResourceRequest--;
}

core.List<api.XpnResourceId> buildUnnamed465() => [
      buildXpnResourceId(),
      buildXpnResourceId(),
    ];

void checkUnnamed465(core.List<api.XpnResourceId> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkXpnResourceId(o[0]);
  checkXpnResourceId(o[1]);
}

core.int buildCounterProjectsGetXpnResources = 0;
api.ProjectsGetXpnResources buildProjectsGetXpnResources() {
  final o = api.ProjectsGetXpnResources();
  buildCounterProjectsGetXpnResources++;
  if (buildCounterProjectsGetXpnResources < 3) {
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.resources = buildUnnamed465();
  }
  buildCounterProjectsGetXpnResources--;
  return o;
}

void checkProjectsGetXpnResources(api.ProjectsGetXpnResources o) {
  buildCounterProjectsGetXpnResources++;
  if (buildCounterProjectsGetXpnResources < 3) {
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    checkUnnamed465(o.resources!);
  }
  buildCounterProjectsGetXpnResources--;
}

core.int buildCounterProjectsListXpnHostsRequest = 0;
api.ProjectsListXpnHostsRequest buildProjectsListXpnHostsRequest() {
  final o = api.ProjectsListXpnHostsRequest();
  buildCounterProjectsListXpnHostsRequest++;
  if (buildCounterProjectsListXpnHostsRequest < 3) {
    o.organization = 'foo';
  }
  buildCounterProjectsListXpnHostsRequest--;
  return o;
}

void checkProjectsListXpnHostsRequest(api.ProjectsListXpnHostsRequest o) {
  buildCounterProjectsListXpnHostsRequest++;
  if (buildCounterProjectsListXpnHostsRequest < 3) {
    unittest.expect(
      o.organization!,
      unittest.equals('foo'),
    );
  }
  buildCounterProjectsListXpnHostsRequest--;
}

core.int buildCounterProjectsSetDefaultNetworkTierRequest = 0;
api.ProjectsSetDefaultNetworkTierRequest
    buildProjectsSetDefaultNetworkTierRequest() {
  final o = api.ProjectsSetDefaultNetworkTierRequest();
  buildCounterProjectsSetDefaultNetworkTierRequest++;
  if (buildCounterProjectsSetDefaultNetworkTierRequest < 3) {
    o.networkTier = 'foo';
  }
  buildCounterProjectsSetDefaultNetworkTierRequest--;
  return o;
}

void checkProjectsSetDefaultNetworkTierRequest(
    api.ProjectsSetDefaultNetworkTierRequest o) {
  buildCounterProjectsSetDefaultNetworkTierRequest++;
  if (buildCounterProjectsSetDefaultNetworkTierRequest < 3) {
    unittest.expect(
      o.networkTier!,
      unittest.equals('foo'),
    );
  }
  buildCounterProjectsSetDefaultNetworkTierRequest--;
}

core.List<api.PublicAdvertisedPrefixPublicDelegatedPrefix> buildUnnamed466() =>
    [
      buildPublicAdvertisedPrefixPublicDelegatedPrefix(),
      buildPublicAdvertisedPrefixPublicDelegatedPrefix(),
    ];

void checkUnnamed466(
    core.List<api.PublicAdvertisedPrefixPublicDelegatedPrefix> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicAdvertisedPrefixPublicDelegatedPrefix(o[0]);
  checkPublicAdvertisedPrefixPublicDelegatedPrefix(o[1]);
}

core.int buildCounterPublicAdvertisedPrefix = 0;
api.PublicAdvertisedPrefix buildPublicAdvertisedPrefix() {
  final o = api.PublicAdvertisedPrefix();
  buildCounterPublicAdvertisedPrefix++;
  if (buildCounterPublicAdvertisedPrefix < 3) {
    o.byoipApiVersion = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.dnsVerificationIp = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.ipCidrRange = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.pdpScope = 'foo';
    o.publicDelegatedPrefixs = buildUnnamed466();
    o.selfLink = 'foo';
    o.sharedSecret = 'foo';
    o.status = 'foo';
  }
  buildCounterPublicAdvertisedPrefix--;
  return o;
}

void checkPublicAdvertisedPrefix(api.PublicAdvertisedPrefix o) {
  buildCounterPublicAdvertisedPrefix++;
  if (buildCounterPublicAdvertisedPrefix < 3) {
    unittest.expect(
      o.byoipApiVersion!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.dnsVerificationIp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipCidrRange!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.pdpScope!,
      unittest.equals('foo'),
    );
    checkUnnamed466(o.publicDelegatedPrefixs!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sharedSecret!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicAdvertisedPrefix--;
}

core.List<api.PublicAdvertisedPrefix> buildUnnamed467() => [
      buildPublicAdvertisedPrefix(),
      buildPublicAdvertisedPrefix(),
    ];

void checkUnnamed467(core.List<api.PublicAdvertisedPrefix> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicAdvertisedPrefix(o[0]);
  checkPublicAdvertisedPrefix(o[1]);
}

core.int buildCounterPublicAdvertisedPrefixListWarningData = 0;
api.PublicAdvertisedPrefixListWarningData
    buildPublicAdvertisedPrefixListWarningData() {
  final o = api.PublicAdvertisedPrefixListWarningData();
  buildCounterPublicAdvertisedPrefixListWarningData++;
  if (buildCounterPublicAdvertisedPrefixListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterPublicAdvertisedPrefixListWarningData--;
  return o;
}

void checkPublicAdvertisedPrefixListWarningData(
    api.PublicAdvertisedPrefixListWarningData o) {
  buildCounterPublicAdvertisedPrefixListWarningData++;
  if (buildCounterPublicAdvertisedPrefixListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicAdvertisedPrefixListWarningData--;
}

core.List<api.PublicAdvertisedPrefixListWarningData> buildUnnamed468() => [
      buildPublicAdvertisedPrefixListWarningData(),
      buildPublicAdvertisedPrefixListWarningData(),
    ];

void checkUnnamed468(core.List<api.PublicAdvertisedPrefixListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicAdvertisedPrefixListWarningData(o[0]);
  checkPublicAdvertisedPrefixListWarningData(o[1]);
}

core.int buildCounterPublicAdvertisedPrefixListWarning = 0;
api.PublicAdvertisedPrefixListWarning buildPublicAdvertisedPrefixListWarning() {
  final o = api.PublicAdvertisedPrefixListWarning();
  buildCounterPublicAdvertisedPrefixListWarning++;
  if (buildCounterPublicAdvertisedPrefixListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed468();
    o.message = 'foo';
  }
  buildCounterPublicAdvertisedPrefixListWarning--;
  return o;
}

void checkPublicAdvertisedPrefixListWarning(
    api.PublicAdvertisedPrefixListWarning o) {
  buildCounterPublicAdvertisedPrefixListWarning++;
  if (buildCounterPublicAdvertisedPrefixListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed468(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicAdvertisedPrefixListWarning--;
}

core.int buildCounterPublicAdvertisedPrefixList = 0;
api.PublicAdvertisedPrefixList buildPublicAdvertisedPrefixList() {
  final o = api.PublicAdvertisedPrefixList();
  buildCounterPublicAdvertisedPrefixList++;
  if (buildCounterPublicAdvertisedPrefixList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed467();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildPublicAdvertisedPrefixListWarning();
  }
  buildCounterPublicAdvertisedPrefixList--;
  return o;
}

void checkPublicAdvertisedPrefixList(api.PublicAdvertisedPrefixList o) {
  buildCounterPublicAdvertisedPrefixList++;
  if (buildCounterPublicAdvertisedPrefixList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed467(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkPublicAdvertisedPrefixListWarning(o.warning!);
  }
  buildCounterPublicAdvertisedPrefixList--;
}

core.int buildCounterPublicAdvertisedPrefixPublicDelegatedPrefix = 0;
api.PublicAdvertisedPrefixPublicDelegatedPrefix
    buildPublicAdvertisedPrefixPublicDelegatedPrefix() {
  final o = api.PublicAdvertisedPrefixPublicDelegatedPrefix();
  buildCounterPublicAdvertisedPrefixPublicDelegatedPrefix++;
  if (buildCounterPublicAdvertisedPrefixPublicDelegatedPrefix < 3) {
    o.ipRange = 'foo';
    o.name = 'foo';
    o.project = 'foo';
    o.region = 'foo';
    o.status = 'foo';
  }
  buildCounterPublicAdvertisedPrefixPublicDelegatedPrefix--;
  return o;
}

void checkPublicAdvertisedPrefixPublicDelegatedPrefix(
    api.PublicAdvertisedPrefixPublicDelegatedPrefix o) {
  buildCounterPublicAdvertisedPrefixPublicDelegatedPrefix++;
  if (buildCounterPublicAdvertisedPrefixPublicDelegatedPrefix < 3) {
    unittest.expect(
      o.ipRange!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.project!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicAdvertisedPrefixPublicDelegatedPrefix--;
}

core.List<api.PublicDelegatedPrefixPublicDelegatedSubPrefix>
    buildUnnamed469() => [
          buildPublicDelegatedPrefixPublicDelegatedSubPrefix(),
          buildPublicDelegatedPrefixPublicDelegatedSubPrefix(),
        ];

void checkUnnamed469(
    core.List<api.PublicDelegatedPrefixPublicDelegatedSubPrefix> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicDelegatedPrefixPublicDelegatedSubPrefix(o[0]);
  checkPublicDelegatedPrefixPublicDelegatedSubPrefix(o[1]);
}

core.int buildCounterPublicDelegatedPrefix = 0;
api.PublicDelegatedPrefix buildPublicDelegatedPrefix() {
  final o = api.PublicDelegatedPrefix();
  buildCounterPublicDelegatedPrefix++;
  if (buildCounterPublicDelegatedPrefix < 3) {
    o.byoipApiVersion = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.ipCidrRange = 'foo';
    o.isLiveMigration = true;
    o.kind = 'foo';
    o.name = 'foo';
    o.parentPrefix = 'foo';
    o.publicDelegatedSubPrefixs = buildUnnamed469();
    o.region = 'foo';
    o.selfLink = 'foo';
    o.status = 'foo';
  }
  buildCounterPublicDelegatedPrefix--;
  return o;
}

void checkPublicDelegatedPrefix(api.PublicDelegatedPrefix o) {
  buildCounterPublicDelegatedPrefix++;
  if (buildCounterPublicDelegatedPrefix < 3) {
    unittest.expect(
      o.byoipApiVersion!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipCidrRange!,
      unittest.equals('foo'),
    );
    unittest.expect(o.isLiveMigration!, unittest.isTrue);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.parentPrefix!,
      unittest.equals('foo'),
    );
    checkUnnamed469(o.publicDelegatedSubPrefixs!);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicDelegatedPrefix--;
}

core.Map<core.String, api.PublicDelegatedPrefixesScopedList>
    buildUnnamed470() => {
          'x': buildPublicDelegatedPrefixesScopedList(),
          'y': buildPublicDelegatedPrefixesScopedList(),
        };

void checkUnnamed470(
    core.Map<core.String, api.PublicDelegatedPrefixesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicDelegatedPrefixesScopedList(o['x']!);
  checkPublicDelegatedPrefixesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed471() => [
      'foo',
      'foo',
    ];

void checkUnnamed471(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterPublicDelegatedPrefixAggregatedListWarningData = 0;
api.PublicDelegatedPrefixAggregatedListWarningData
    buildPublicDelegatedPrefixAggregatedListWarningData() {
  final o = api.PublicDelegatedPrefixAggregatedListWarningData();
  buildCounterPublicDelegatedPrefixAggregatedListWarningData++;
  if (buildCounterPublicDelegatedPrefixAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterPublicDelegatedPrefixAggregatedListWarningData--;
  return o;
}

void checkPublicDelegatedPrefixAggregatedListWarningData(
    api.PublicDelegatedPrefixAggregatedListWarningData o) {
  buildCounterPublicDelegatedPrefixAggregatedListWarningData++;
  if (buildCounterPublicDelegatedPrefixAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicDelegatedPrefixAggregatedListWarningData--;
}

core.List<api.PublicDelegatedPrefixAggregatedListWarningData>
    buildUnnamed472() => [
          buildPublicDelegatedPrefixAggregatedListWarningData(),
          buildPublicDelegatedPrefixAggregatedListWarningData(),
        ];

void checkUnnamed472(
    core.List<api.PublicDelegatedPrefixAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicDelegatedPrefixAggregatedListWarningData(o[0]);
  checkPublicDelegatedPrefixAggregatedListWarningData(o[1]);
}

core.int buildCounterPublicDelegatedPrefixAggregatedListWarning = 0;
api.PublicDelegatedPrefixAggregatedListWarning
    buildPublicDelegatedPrefixAggregatedListWarning() {
  final o = api.PublicDelegatedPrefixAggregatedListWarning();
  buildCounterPublicDelegatedPrefixAggregatedListWarning++;
  if (buildCounterPublicDelegatedPrefixAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed472();
    o.message = 'foo';
  }
  buildCounterPublicDelegatedPrefixAggregatedListWarning--;
  return o;
}

void checkPublicDelegatedPrefixAggregatedListWarning(
    api.PublicDelegatedPrefixAggregatedListWarning o) {
  buildCounterPublicDelegatedPrefixAggregatedListWarning++;
  if (buildCounterPublicDelegatedPrefixAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed472(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicDelegatedPrefixAggregatedListWarning--;
}

core.int buildCounterPublicDelegatedPrefixAggregatedList = 0;
api.PublicDelegatedPrefixAggregatedList
    buildPublicDelegatedPrefixAggregatedList() {
  final o = api.PublicDelegatedPrefixAggregatedList();
  buildCounterPublicDelegatedPrefixAggregatedList++;
  if (buildCounterPublicDelegatedPrefixAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed470();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed471();
    o.warning = buildPublicDelegatedPrefixAggregatedListWarning();
  }
  buildCounterPublicDelegatedPrefixAggregatedList--;
  return o;
}

void checkPublicDelegatedPrefixAggregatedList(
    api.PublicDelegatedPrefixAggregatedList o) {
  buildCounterPublicDelegatedPrefixAggregatedList++;
  if (buildCounterPublicDelegatedPrefixAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed470(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed471(o.unreachables!);
    checkPublicDelegatedPrefixAggregatedListWarning(o.warning!);
  }
  buildCounterPublicDelegatedPrefixAggregatedList--;
}

core.List<api.PublicDelegatedPrefix> buildUnnamed473() => [
      buildPublicDelegatedPrefix(),
      buildPublicDelegatedPrefix(),
    ];

void checkUnnamed473(core.List<api.PublicDelegatedPrefix> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicDelegatedPrefix(o[0]);
  checkPublicDelegatedPrefix(o[1]);
}

core.int buildCounterPublicDelegatedPrefixListWarningData = 0;
api.PublicDelegatedPrefixListWarningData
    buildPublicDelegatedPrefixListWarningData() {
  final o = api.PublicDelegatedPrefixListWarningData();
  buildCounterPublicDelegatedPrefixListWarningData++;
  if (buildCounterPublicDelegatedPrefixListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterPublicDelegatedPrefixListWarningData--;
  return o;
}

void checkPublicDelegatedPrefixListWarningData(
    api.PublicDelegatedPrefixListWarningData o) {
  buildCounterPublicDelegatedPrefixListWarningData++;
  if (buildCounterPublicDelegatedPrefixListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicDelegatedPrefixListWarningData--;
}

core.List<api.PublicDelegatedPrefixListWarningData> buildUnnamed474() => [
      buildPublicDelegatedPrefixListWarningData(),
      buildPublicDelegatedPrefixListWarningData(),
    ];

void checkUnnamed474(core.List<api.PublicDelegatedPrefixListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicDelegatedPrefixListWarningData(o[0]);
  checkPublicDelegatedPrefixListWarningData(o[1]);
}

core.int buildCounterPublicDelegatedPrefixListWarning = 0;
api.PublicDelegatedPrefixListWarning buildPublicDelegatedPrefixListWarning() {
  final o = api.PublicDelegatedPrefixListWarning();
  buildCounterPublicDelegatedPrefixListWarning++;
  if (buildCounterPublicDelegatedPrefixListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed474();
    o.message = 'foo';
  }
  buildCounterPublicDelegatedPrefixListWarning--;
  return o;
}

void checkPublicDelegatedPrefixListWarning(
    api.PublicDelegatedPrefixListWarning o) {
  buildCounterPublicDelegatedPrefixListWarning++;
  if (buildCounterPublicDelegatedPrefixListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed474(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicDelegatedPrefixListWarning--;
}

core.int buildCounterPublicDelegatedPrefixList = 0;
api.PublicDelegatedPrefixList buildPublicDelegatedPrefixList() {
  final o = api.PublicDelegatedPrefixList();
  buildCounterPublicDelegatedPrefixList++;
  if (buildCounterPublicDelegatedPrefixList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed473();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildPublicDelegatedPrefixListWarning();
  }
  buildCounterPublicDelegatedPrefixList--;
  return o;
}

void checkPublicDelegatedPrefixList(api.PublicDelegatedPrefixList o) {
  buildCounterPublicDelegatedPrefixList++;
  if (buildCounterPublicDelegatedPrefixList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed473(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkPublicDelegatedPrefixListWarning(o.warning!);
  }
  buildCounterPublicDelegatedPrefixList--;
}

core.int buildCounterPublicDelegatedPrefixPublicDelegatedSubPrefix = 0;
api.PublicDelegatedPrefixPublicDelegatedSubPrefix
    buildPublicDelegatedPrefixPublicDelegatedSubPrefix() {
  final o = api.PublicDelegatedPrefixPublicDelegatedSubPrefix();
  buildCounterPublicDelegatedPrefixPublicDelegatedSubPrefix++;
  if (buildCounterPublicDelegatedPrefixPublicDelegatedSubPrefix < 3) {
    o.delegateeProject = 'foo';
    o.description = 'foo';
    o.ipCidrRange = 'foo';
    o.isAddress = true;
    o.name = 'foo';
    o.region = 'foo';
    o.status = 'foo';
  }
  buildCounterPublicDelegatedPrefixPublicDelegatedSubPrefix--;
  return o;
}

void checkPublicDelegatedPrefixPublicDelegatedSubPrefix(
    api.PublicDelegatedPrefixPublicDelegatedSubPrefix o) {
  buildCounterPublicDelegatedPrefixPublicDelegatedSubPrefix++;
  if (buildCounterPublicDelegatedPrefixPublicDelegatedSubPrefix < 3) {
    unittest.expect(
      o.delegateeProject!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipCidrRange!,
      unittest.equals('foo'),
    );
    unittest.expect(o.isAddress!, unittest.isTrue);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicDelegatedPrefixPublicDelegatedSubPrefix--;
}

core.List<api.PublicDelegatedPrefix> buildUnnamed475() => [
      buildPublicDelegatedPrefix(),
      buildPublicDelegatedPrefix(),
    ];

void checkUnnamed475(core.List<api.PublicDelegatedPrefix> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicDelegatedPrefix(o[0]);
  checkPublicDelegatedPrefix(o[1]);
}

core.int buildCounterPublicDelegatedPrefixesScopedListWarningData = 0;
api.PublicDelegatedPrefixesScopedListWarningData
    buildPublicDelegatedPrefixesScopedListWarningData() {
  final o = api.PublicDelegatedPrefixesScopedListWarningData();
  buildCounterPublicDelegatedPrefixesScopedListWarningData++;
  if (buildCounterPublicDelegatedPrefixesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterPublicDelegatedPrefixesScopedListWarningData--;
  return o;
}

void checkPublicDelegatedPrefixesScopedListWarningData(
    api.PublicDelegatedPrefixesScopedListWarningData o) {
  buildCounterPublicDelegatedPrefixesScopedListWarningData++;
  if (buildCounterPublicDelegatedPrefixesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicDelegatedPrefixesScopedListWarningData--;
}

core.List<api.PublicDelegatedPrefixesScopedListWarningData> buildUnnamed476() =>
    [
      buildPublicDelegatedPrefixesScopedListWarningData(),
      buildPublicDelegatedPrefixesScopedListWarningData(),
    ];

void checkUnnamed476(
    core.List<api.PublicDelegatedPrefixesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPublicDelegatedPrefixesScopedListWarningData(o[0]);
  checkPublicDelegatedPrefixesScopedListWarningData(o[1]);
}

core.int buildCounterPublicDelegatedPrefixesScopedListWarning = 0;
api.PublicDelegatedPrefixesScopedListWarning
    buildPublicDelegatedPrefixesScopedListWarning() {
  final o = api.PublicDelegatedPrefixesScopedListWarning();
  buildCounterPublicDelegatedPrefixesScopedListWarning++;
  if (buildCounterPublicDelegatedPrefixesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed476();
    o.message = 'foo';
  }
  buildCounterPublicDelegatedPrefixesScopedListWarning--;
  return o;
}

void checkPublicDelegatedPrefixesScopedListWarning(
    api.PublicDelegatedPrefixesScopedListWarning o) {
  buildCounterPublicDelegatedPrefixesScopedListWarning++;
  if (buildCounterPublicDelegatedPrefixesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed476(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterPublicDelegatedPrefixesScopedListWarning--;
}

core.int buildCounterPublicDelegatedPrefixesScopedList = 0;
api.PublicDelegatedPrefixesScopedList buildPublicDelegatedPrefixesScopedList() {
  final o = api.PublicDelegatedPrefixesScopedList();
  buildCounterPublicDelegatedPrefixesScopedList++;
  if (buildCounterPublicDelegatedPrefixesScopedList < 3) {
    o.publicDelegatedPrefixes = buildUnnamed475();
    o.warning = buildPublicDelegatedPrefixesScopedListWarning();
  }
  buildCounterPublicDelegatedPrefixesScopedList--;
  return o;
}

void checkPublicDelegatedPrefixesScopedList(
    api.PublicDelegatedPrefixesScopedList o) {
  buildCounterPublicDelegatedPrefixesScopedList++;
  if (buildCounterPublicDelegatedPrefixesScopedList < 3) {
    checkUnnamed475(o.publicDelegatedPrefixes!);
    checkPublicDelegatedPrefixesScopedListWarning(o.warning!);
  }
  buildCounterPublicDelegatedPrefixesScopedList--;
}

core.int buildCounterQuota = 0;
api.Quota buildQuota() {
  final o = api.Quota();
  buildCounterQuota++;
  if (buildCounterQuota < 3) {
    o.limit = 42.0;
    o.metric = 'foo';
    o.owner = 'foo';
    o.usage = 42.0;
  }
  buildCounterQuota--;
  return o;
}

void checkQuota(api.Quota o) {
  buildCounterQuota++;
  if (buildCounterQuota < 3) {
    unittest.expect(
      o.limit!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.metric!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.owner!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.usage!,
      unittest.equals(42.0),
    );
  }
  buildCounterQuota--;
}

core.Map<core.String, core.String> buildUnnamed477() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed477(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterQuotaExceededInfo = 0;
api.QuotaExceededInfo buildQuotaExceededInfo() {
  final o = api.QuotaExceededInfo();
  buildCounterQuotaExceededInfo++;
  if (buildCounterQuotaExceededInfo < 3) {
    o.dimensions = buildUnnamed477();
    o.futureLimit = 42.0;
    o.limit = 42.0;
    o.limitName = 'foo';
    o.metricName = 'foo';
    o.rolloutStatus = 'foo';
  }
  buildCounterQuotaExceededInfo--;
  return o;
}

void checkQuotaExceededInfo(api.QuotaExceededInfo o) {
  buildCounterQuotaExceededInfo++;
  if (buildCounterQuotaExceededInfo < 3) {
    checkUnnamed477(o.dimensions!);
    unittest.expect(
      o.futureLimit!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.limit!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.limitName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.metricName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.rolloutStatus!,
      unittest.equals('foo'),
    );
  }
  buildCounterQuotaExceededInfo--;
}

core.int buildCounterReference = 0;
api.Reference buildReference() {
  final o = api.Reference();
  buildCounterReference++;
  if (buildCounterReference < 3) {
    o.kind = 'foo';
    o.referenceType = 'foo';
    o.referrer = 'foo';
    o.target = 'foo';
  }
  buildCounterReference--;
  return o;
}

void checkReference(api.Reference o) {
  buildCounterReference++;
  if (buildCounterReference < 3) {
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.referenceType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.referrer!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.target!,
      unittest.equals('foo'),
    );
  }
  buildCounterReference--;
}

core.List<api.Quota> buildUnnamed478() => [
      buildQuota(),
      buildQuota(),
    ];

void checkUnnamed478(core.List<api.Quota> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkQuota(o[0]);
  checkQuota(o[1]);
}

core.List<core.String> buildUnnamed479() => [
      'foo',
      'foo',
    ];

void checkUnnamed479(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegion = 0;
api.Region buildRegion() {
  final o = api.Region();
  buildCounterRegion++;
  if (buildCounterRegion < 3) {
    o.creationTimestamp = 'foo';
    o.deprecated = buildDeprecationStatus();
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.quotas = buildUnnamed478();
    o.selfLink = 'foo';
    o.status = 'foo';
    o.supportsPzs = true;
    o.zones = buildUnnamed479();
  }
  buildCounterRegion--;
  return o;
}

void checkRegion(api.Region o) {
  buildCounterRegion++;
  if (buildCounterRegion < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkDeprecationStatus(o.deprecated!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed478(o.quotas!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(o.supportsPzs!, unittest.isTrue);
    checkUnnamed479(o.zones!);
  }
  buildCounterRegion--;
}

core.int buildCounterRegionAddressesMoveRequest = 0;
api.RegionAddressesMoveRequest buildRegionAddressesMoveRequest() {
  final o = api.RegionAddressesMoveRequest();
  buildCounterRegionAddressesMoveRequest++;
  if (buildCounterRegionAddressesMoveRequest < 3) {
    o.description = 'foo';
    o.destinationAddress = 'foo';
  }
  buildCounterRegionAddressesMoveRequest--;
  return o;
}

void checkRegionAddressesMoveRequest(api.RegionAddressesMoveRequest o) {
  buildCounterRegionAddressesMoveRequest++;
  if (buildCounterRegionAddressesMoveRequest < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.destinationAddress!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionAddressesMoveRequest--;
}

core.List<api.Autoscaler> buildUnnamed480() => [
      buildAutoscaler(),
      buildAutoscaler(),
    ];

void checkUnnamed480(core.List<api.Autoscaler> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkAutoscaler(o[0]);
  checkAutoscaler(o[1]);
}

core.int buildCounterRegionAutoscalerListWarningData = 0;
api.RegionAutoscalerListWarningData buildRegionAutoscalerListWarningData() {
  final o = api.RegionAutoscalerListWarningData();
  buildCounterRegionAutoscalerListWarningData++;
  if (buildCounterRegionAutoscalerListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRegionAutoscalerListWarningData--;
  return o;
}

void checkRegionAutoscalerListWarningData(
    api.RegionAutoscalerListWarningData o) {
  buildCounterRegionAutoscalerListWarningData++;
  if (buildCounterRegionAutoscalerListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionAutoscalerListWarningData--;
}

core.List<api.RegionAutoscalerListWarningData> buildUnnamed481() => [
      buildRegionAutoscalerListWarningData(),
      buildRegionAutoscalerListWarningData(),
    ];

void checkUnnamed481(core.List<api.RegionAutoscalerListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionAutoscalerListWarningData(o[0]);
  checkRegionAutoscalerListWarningData(o[1]);
}

core.int buildCounterRegionAutoscalerListWarning = 0;
api.RegionAutoscalerListWarning buildRegionAutoscalerListWarning() {
  final o = api.RegionAutoscalerListWarning();
  buildCounterRegionAutoscalerListWarning++;
  if (buildCounterRegionAutoscalerListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed481();
    o.message = 'foo';
  }
  buildCounterRegionAutoscalerListWarning--;
  return o;
}

void checkRegionAutoscalerListWarning(api.RegionAutoscalerListWarning o) {
  buildCounterRegionAutoscalerListWarning++;
  if (buildCounterRegionAutoscalerListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed481(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionAutoscalerListWarning--;
}

core.int buildCounterRegionAutoscalerList = 0;
api.RegionAutoscalerList buildRegionAutoscalerList() {
  final o = api.RegionAutoscalerList();
  buildCounterRegionAutoscalerList++;
  if (buildCounterRegionAutoscalerList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed480();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildRegionAutoscalerListWarning();
  }
  buildCounterRegionAutoscalerList--;
  return o;
}

void checkRegionAutoscalerList(api.RegionAutoscalerList o) {
  buildCounterRegionAutoscalerList++;
  if (buildCounterRegionAutoscalerList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed480(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkRegionAutoscalerListWarning(o.warning!);
  }
  buildCounterRegionAutoscalerList--;
}

core.List<api.DiskType> buildUnnamed482() => [
      buildDiskType(),
      buildDiskType(),
    ];

void checkUnnamed482(core.List<api.DiskType> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkDiskType(o[0]);
  checkDiskType(o[1]);
}

core.int buildCounterRegionDiskTypeListWarningData = 0;
api.RegionDiskTypeListWarningData buildRegionDiskTypeListWarningData() {
  final o = api.RegionDiskTypeListWarningData();
  buildCounterRegionDiskTypeListWarningData++;
  if (buildCounterRegionDiskTypeListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRegionDiskTypeListWarningData--;
  return o;
}

void checkRegionDiskTypeListWarningData(api.RegionDiskTypeListWarningData o) {
  buildCounterRegionDiskTypeListWarningData++;
  if (buildCounterRegionDiskTypeListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionDiskTypeListWarningData--;
}

core.List<api.RegionDiskTypeListWarningData> buildUnnamed483() => [
      buildRegionDiskTypeListWarningData(),
      buildRegionDiskTypeListWarningData(),
    ];

void checkUnnamed483(core.List<api.RegionDiskTypeListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionDiskTypeListWarningData(o[0]);
  checkRegionDiskTypeListWarningData(o[1]);
}

core.int buildCounterRegionDiskTypeListWarning = 0;
api.RegionDiskTypeListWarning buildRegionDiskTypeListWarning() {
  final o = api.RegionDiskTypeListWarning();
  buildCounterRegionDiskTypeListWarning++;
  if (buildCounterRegionDiskTypeListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed483();
    o.message = 'foo';
  }
  buildCounterRegionDiskTypeListWarning--;
  return o;
}

void checkRegionDiskTypeListWarning(api.RegionDiskTypeListWarning o) {
  buildCounterRegionDiskTypeListWarning++;
  if (buildCounterRegionDiskTypeListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed483(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionDiskTypeListWarning--;
}

core.int buildCounterRegionDiskTypeList = 0;
api.RegionDiskTypeList buildRegionDiskTypeList() {
  final o = api.RegionDiskTypeList();
  buildCounterRegionDiskTypeList++;
  if (buildCounterRegionDiskTypeList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed482();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildRegionDiskTypeListWarning();
  }
  buildCounterRegionDiskTypeList--;
  return o;
}

void checkRegionDiskTypeList(api.RegionDiskTypeList o) {
  buildCounterRegionDiskTypeList++;
  if (buildCounterRegionDiskTypeList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed482(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkRegionDiskTypeListWarning(o.warning!);
  }
  buildCounterRegionDiskTypeList--;
}

core.List<core.String> buildUnnamed484() => [
      'foo',
      'foo',
    ];

void checkUnnamed484(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionDisksAddResourcePoliciesRequest = 0;
api.RegionDisksAddResourcePoliciesRequest
    buildRegionDisksAddResourcePoliciesRequest() {
  final o = api.RegionDisksAddResourcePoliciesRequest();
  buildCounterRegionDisksAddResourcePoliciesRequest++;
  if (buildCounterRegionDisksAddResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed484();
  }
  buildCounterRegionDisksAddResourcePoliciesRequest--;
  return o;
}

void checkRegionDisksAddResourcePoliciesRequest(
    api.RegionDisksAddResourcePoliciesRequest o) {
  buildCounterRegionDisksAddResourcePoliciesRequest++;
  if (buildCounterRegionDisksAddResourcePoliciesRequest < 3) {
    checkUnnamed484(o.resourcePolicies!);
  }
  buildCounterRegionDisksAddResourcePoliciesRequest--;
}

core.List<core.String> buildUnnamed485() => [
      'foo',
      'foo',
    ];

void checkUnnamed485(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionDisksRemoveResourcePoliciesRequest = 0;
api.RegionDisksRemoveResourcePoliciesRequest
    buildRegionDisksRemoveResourcePoliciesRequest() {
  final o = api.RegionDisksRemoveResourcePoliciesRequest();
  buildCounterRegionDisksRemoveResourcePoliciesRequest++;
  if (buildCounterRegionDisksRemoveResourcePoliciesRequest < 3) {
    o.resourcePolicies = buildUnnamed485();
  }
  buildCounterRegionDisksRemoveResourcePoliciesRequest--;
  return o;
}

void checkRegionDisksRemoveResourcePoliciesRequest(
    api.RegionDisksRemoveResourcePoliciesRequest o) {
  buildCounterRegionDisksRemoveResourcePoliciesRequest++;
  if (buildCounterRegionDisksRemoveResourcePoliciesRequest < 3) {
    checkUnnamed485(o.resourcePolicies!);
  }
  buildCounterRegionDisksRemoveResourcePoliciesRequest--;
}

core.int buildCounterRegionDisksResizeRequest = 0;
api.RegionDisksResizeRequest buildRegionDisksResizeRequest() {
  final o = api.RegionDisksResizeRequest();
  buildCounterRegionDisksResizeRequest++;
  if (buildCounterRegionDisksResizeRequest < 3) {
    o.sizeGb = 'foo';
  }
  buildCounterRegionDisksResizeRequest--;
  return o;
}

void checkRegionDisksResizeRequest(api.RegionDisksResizeRequest o) {
  buildCounterRegionDisksResizeRequest++;
  if (buildCounterRegionDisksResizeRequest < 3) {
    unittest.expect(
      o.sizeGb!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionDisksResizeRequest--;
}

core.int buildCounterRegionDisksStartAsyncReplicationRequest = 0;
api.RegionDisksStartAsyncReplicationRequest
    buildRegionDisksStartAsyncReplicationRequest() {
  final o = api.RegionDisksStartAsyncReplicationRequest();
  buildCounterRegionDisksStartAsyncReplicationRequest++;
  if (buildCounterRegionDisksStartAsyncReplicationRequest < 3) {
    o.asyncSecondaryDisk = 'foo';
  }
  buildCounterRegionDisksStartAsyncReplicationRequest--;
  return o;
}

void checkRegionDisksStartAsyncReplicationRequest(
    api.RegionDisksStartAsyncReplicationRequest o) {
  buildCounterRegionDisksStartAsyncReplicationRequest++;
  if (buildCounterRegionDisksStartAsyncReplicationRequest < 3) {
    unittest.expect(
      o.asyncSecondaryDisk!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionDisksStartAsyncReplicationRequest--;
}

core.List<api.InstanceGroup> buildUnnamed486() => [
      buildInstanceGroup(),
      buildInstanceGroup(),
    ];

void checkUnnamed486(core.List<api.InstanceGroup> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroup(o[0]);
  checkInstanceGroup(o[1]);
}

core.int buildCounterRegionInstanceGroupListWarningData = 0;
api.RegionInstanceGroupListWarningData
    buildRegionInstanceGroupListWarningData() {
  final o = api.RegionInstanceGroupListWarningData();
  buildCounterRegionInstanceGroupListWarningData++;
  if (buildCounterRegionInstanceGroupListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRegionInstanceGroupListWarningData--;
  return o;
}

void checkRegionInstanceGroupListWarningData(
    api.RegionInstanceGroupListWarningData o) {
  buildCounterRegionInstanceGroupListWarningData++;
  if (buildCounterRegionInstanceGroupListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupListWarningData--;
}

core.List<api.RegionInstanceGroupListWarningData> buildUnnamed487() => [
      buildRegionInstanceGroupListWarningData(),
      buildRegionInstanceGroupListWarningData(),
    ];

void checkUnnamed487(core.List<api.RegionInstanceGroupListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionInstanceGroupListWarningData(o[0]);
  checkRegionInstanceGroupListWarningData(o[1]);
}

core.int buildCounterRegionInstanceGroupListWarning = 0;
api.RegionInstanceGroupListWarning buildRegionInstanceGroupListWarning() {
  final o = api.RegionInstanceGroupListWarning();
  buildCounterRegionInstanceGroupListWarning++;
  if (buildCounterRegionInstanceGroupListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed487();
    o.message = 'foo';
  }
  buildCounterRegionInstanceGroupListWarning--;
  return o;
}

void checkRegionInstanceGroupListWarning(api.RegionInstanceGroupListWarning o) {
  buildCounterRegionInstanceGroupListWarning++;
  if (buildCounterRegionInstanceGroupListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed487(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupListWarning--;
}

core.int buildCounterRegionInstanceGroupList = 0;
api.RegionInstanceGroupList buildRegionInstanceGroupList() {
  final o = api.RegionInstanceGroupList();
  buildCounterRegionInstanceGroupList++;
  if (buildCounterRegionInstanceGroupList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed486();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildRegionInstanceGroupListWarning();
  }
  buildCounterRegionInstanceGroupList--;
  return o;
}

void checkRegionInstanceGroupList(api.RegionInstanceGroupList o) {
  buildCounterRegionInstanceGroupList++;
  if (buildCounterRegionInstanceGroupList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed486(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkRegionInstanceGroupListWarning(o.warning!);
  }
  buildCounterRegionInstanceGroupList--;
}

core.List<core.String> buildUnnamed488() => [
      'foo',
      'foo',
    ];

void checkUnnamed488(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionInstanceGroupManagerDeleteInstanceConfigReq = 0;
api.RegionInstanceGroupManagerDeleteInstanceConfigReq
    buildRegionInstanceGroupManagerDeleteInstanceConfigReq() {
  final o = api.RegionInstanceGroupManagerDeleteInstanceConfigReq();
  buildCounterRegionInstanceGroupManagerDeleteInstanceConfigReq++;
  if (buildCounterRegionInstanceGroupManagerDeleteInstanceConfigReq < 3) {
    o.names = buildUnnamed488();
  }
  buildCounterRegionInstanceGroupManagerDeleteInstanceConfigReq--;
  return o;
}

void checkRegionInstanceGroupManagerDeleteInstanceConfigReq(
    api.RegionInstanceGroupManagerDeleteInstanceConfigReq o) {
  buildCounterRegionInstanceGroupManagerDeleteInstanceConfigReq++;
  if (buildCounterRegionInstanceGroupManagerDeleteInstanceConfigReq < 3) {
    checkUnnamed488(o.names!);
  }
  buildCounterRegionInstanceGroupManagerDeleteInstanceConfigReq--;
}

core.List<api.InstanceGroupManager> buildUnnamed489() => [
      buildInstanceGroupManager(),
      buildInstanceGroupManager(),
    ];

void checkUnnamed489(core.List<api.InstanceGroupManager> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceGroupManager(o[0]);
  checkInstanceGroupManager(o[1]);
}

core.int buildCounterRegionInstanceGroupManagerListWarningData = 0;
api.RegionInstanceGroupManagerListWarningData
    buildRegionInstanceGroupManagerListWarningData() {
  final o = api.RegionInstanceGroupManagerListWarningData();
  buildCounterRegionInstanceGroupManagerListWarningData++;
  if (buildCounterRegionInstanceGroupManagerListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRegionInstanceGroupManagerListWarningData--;
  return o;
}

void checkRegionInstanceGroupManagerListWarningData(
    api.RegionInstanceGroupManagerListWarningData o) {
  buildCounterRegionInstanceGroupManagerListWarningData++;
  if (buildCounterRegionInstanceGroupManagerListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupManagerListWarningData--;
}

core.List<api.RegionInstanceGroupManagerListWarningData> buildUnnamed490() => [
      buildRegionInstanceGroupManagerListWarningData(),
      buildRegionInstanceGroupManagerListWarningData(),
    ];

void checkUnnamed490(
    core.List<api.RegionInstanceGroupManagerListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionInstanceGroupManagerListWarningData(o[0]);
  checkRegionInstanceGroupManagerListWarningData(o[1]);
}

core.int buildCounterRegionInstanceGroupManagerListWarning = 0;
api.RegionInstanceGroupManagerListWarning
    buildRegionInstanceGroupManagerListWarning() {
  final o = api.RegionInstanceGroupManagerListWarning();
  buildCounterRegionInstanceGroupManagerListWarning++;
  if (buildCounterRegionInstanceGroupManagerListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed490();
    o.message = 'foo';
  }
  buildCounterRegionInstanceGroupManagerListWarning--;
  return o;
}

void checkRegionInstanceGroupManagerListWarning(
    api.RegionInstanceGroupManagerListWarning o) {
  buildCounterRegionInstanceGroupManagerListWarning++;
  if (buildCounterRegionInstanceGroupManagerListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed490(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupManagerListWarning--;
}

core.int buildCounterRegionInstanceGroupManagerList = 0;
api.RegionInstanceGroupManagerList buildRegionInstanceGroupManagerList() {
  final o = api.RegionInstanceGroupManagerList();
  buildCounterRegionInstanceGroupManagerList++;
  if (buildCounterRegionInstanceGroupManagerList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed489();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildRegionInstanceGroupManagerListWarning();
  }
  buildCounterRegionInstanceGroupManagerList--;
  return o;
}

void checkRegionInstanceGroupManagerList(api.RegionInstanceGroupManagerList o) {
  buildCounterRegionInstanceGroupManagerList++;
  if (buildCounterRegionInstanceGroupManagerList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed489(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkRegionInstanceGroupManagerListWarning(o.warning!);
  }
  buildCounterRegionInstanceGroupManagerList--;
}

core.List<api.PerInstanceConfig> buildUnnamed491() => [
      buildPerInstanceConfig(),
      buildPerInstanceConfig(),
    ];

void checkUnnamed491(core.List<api.PerInstanceConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPerInstanceConfig(o[0]);
  checkPerInstanceConfig(o[1]);
}

core.int buildCounterRegionInstanceGroupManagerPatchInstanceConfigReq = 0;
api.RegionInstanceGroupManagerPatchInstanceConfigReq
    buildRegionInstanceGroupManagerPatchInstanceConfigReq() {
  final o = api.RegionInstanceGroupManagerPatchInstanceConfigReq();
  buildCounterRegionInstanceGroupManagerPatchInstanceConfigReq++;
  if (buildCounterRegionInstanceGroupManagerPatchInstanceConfigReq < 3) {
    o.perInstanceConfigs = buildUnnamed491();
  }
  buildCounterRegionInstanceGroupManagerPatchInstanceConfigReq--;
  return o;
}

void checkRegionInstanceGroupManagerPatchInstanceConfigReq(
    api.RegionInstanceGroupManagerPatchInstanceConfigReq o) {
  buildCounterRegionInstanceGroupManagerPatchInstanceConfigReq++;
  if (buildCounterRegionInstanceGroupManagerPatchInstanceConfigReq < 3) {
    checkUnnamed491(o.perInstanceConfigs!);
  }
  buildCounterRegionInstanceGroupManagerPatchInstanceConfigReq--;
}

core.List<api.PerInstanceConfig> buildUnnamed492() => [
      buildPerInstanceConfig(),
      buildPerInstanceConfig(),
    ];

void checkUnnamed492(core.List<api.PerInstanceConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPerInstanceConfig(o[0]);
  checkPerInstanceConfig(o[1]);
}

core.int buildCounterRegionInstanceGroupManagerUpdateInstanceConfigReq = 0;
api.RegionInstanceGroupManagerUpdateInstanceConfigReq
    buildRegionInstanceGroupManagerUpdateInstanceConfigReq() {
  final o = api.RegionInstanceGroupManagerUpdateInstanceConfigReq();
  buildCounterRegionInstanceGroupManagerUpdateInstanceConfigReq++;
  if (buildCounterRegionInstanceGroupManagerUpdateInstanceConfigReq < 3) {
    o.perInstanceConfigs = buildUnnamed492();
  }
  buildCounterRegionInstanceGroupManagerUpdateInstanceConfigReq--;
  return o;
}

void checkRegionInstanceGroupManagerUpdateInstanceConfigReq(
    api.RegionInstanceGroupManagerUpdateInstanceConfigReq o) {
  buildCounterRegionInstanceGroupManagerUpdateInstanceConfigReq++;
  if (buildCounterRegionInstanceGroupManagerUpdateInstanceConfigReq < 3) {
    checkUnnamed492(o.perInstanceConfigs!);
  }
  buildCounterRegionInstanceGroupManagerUpdateInstanceConfigReq--;
}

core.List<core.String> buildUnnamed493() => [
      'foo',
      'foo',
    ];

void checkUnnamed493(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionInstanceGroupManagersAbandonInstancesRequest = 0;
api.RegionInstanceGroupManagersAbandonInstancesRequest
    buildRegionInstanceGroupManagersAbandonInstancesRequest() {
  final o = api.RegionInstanceGroupManagersAbandonInstancesRequest();
  buildCounterRegionInstanceGroupManagersAbandonInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersAbandonInstancesRequest < 3) {
    o.instances = buildUnnamed493();
  }
  buildCounterRegionInstanceGroupManagersAbandonInstancesRequest--;
  return o;
}

void checkRegionInstanceGroupManagersAbandonInstancesRequest(
    api.RegionInstanceGroupManagersAbandonInstancesRequest o) {
  buildCounterRegionInstanceGroupManagersAbandonInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersAbandonInstancesRequest < 3) {
    checkUnnamed493(o.instances!);
  }
  buildCounterRegionInstanceGroupManagersAbandonInstancesRequest--;
}

core.List<core.String> buildUnnamed494() => [
      'foo',
      'foo',
    ];

void checkUnnamed494(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionInstanceGroupManagersApplyUpdatesRequest = 0;
api.RegionInstanceGroupManagersApplyUpdatesRequest
    buildRegionInstanceGroupManagersApplyUpdatesRequest() {
  final o = api.RegionInstanceGroupManagersApplyUpdatesRequest();
  buildCounterRegionInstanceGroupManagersApplyUpdatesRequest++;
  if (buildCounterRegionInstanceGroupManagersApplyUpdatesRequest < 3) {
    o.allInstances = true;
    o.instances = buildUnnamed494();
    o.minimalAction = 'foo';
    o.mostDisruptiveAllowedAction = 'foo';
  }
  buildCounterRegionInstanceGroupManagersApplyUpdatesRequest--;
  return o;
}

void checkRegionInstanceGroupManagersApplyUpdatesRequest(
    api.RegionInstanceGroupManagersApplyUpdatesRequest o) {
  buildCounterRegionInstanceGroupManagersApplyUpdatesRequest++;
  if (buildCounterRegionInstanceGroupManagersApplyUpdatesRequest < 3) {
    unittest.expect(o.allInstances!, unittest.isTrue);
    checkUnnamed494(o.instances!);
    unittest.expect(
      o.minimalAction!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.mostDisruptiveAllowedAction!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupManagersApplyUpdatesRequest--;
}

core.List<api.PerInstanceConfig> buildUnnamed495() => [
      buildPerInstanceConfig(),
      buildPerInstanceConfig(),
    ];

void checkUnnamed495(core.List<api.PerInstanceConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPerInstanceConfig(o[0]);
  checkPerInstanceConfig(o[1]);
}

core.int buildCounterRegionInstanceGroupManagersCreateInstancesRequest = 0;
api.RegionInstanceGroupManagersCreateInstancesRequest
    buildRegionInstanceGroupManagersCreateInstancesRequest() {
  final o = api.RegionInstanceGroupManagersCreateInstancesRequest();
  buildCounterRegionInstanceGroupManagersCreateInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersCreateInstancesRequest < 3) {
    o.instances = buildUnnamed495();
  }
  buildCounterRegionInstanceGroupManagersCreateInstancesRequest--;
  return o;
}

void checkRegionInstanceGroupManagersCreateInstancesRequest(
    api.RegionInstanceGroupManagersCreateInstancesRequest o) {
  buildCounterRegionInstanceGroupManagersCreateInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersCreateInstancesRequest < 3) {
    checkUnnamed495(o.instances!);
  }
  buildCounterRegionInstanceGroupManagersCreateInstancesRequest--;
}

core.List<core.String> buildUnnamed496() => [
      'foo',
      'foo',
    ];

void checkUnnamed496(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionInstanceGroupManagersDeleteInstancesRequest = 0;
api.RegionInstanceGroupManagersDeleteInstancesRequest
    buildRegionInstanceGroupManagersDeleteInstancesRequest() {
  final o = api.RegionInstanceGroupManagersDeleteInstancesRequest();
  buildCounterRegionInstanceGroupManagersDeleteInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersDeleteInstancesRequest < 3) {
    o.instances = buildUnnamed496();
    o.skipInstancesOnValidationError = true;
  }
  buildCounterRegionInstanceGroupManagersDeleteInstancesRequest--;
  return o;
}

void checkRegionInstanceGroupManagersDeleteInstancesRequest(
    api.RegionInstanceGroupManagersDeleteInstancesRequest o) {
  buildCounterRegionInstanceGroupManagersDeleteInstancesRequest++;
  if (buildCounterRegionInstanceGroupManagersDeleteInstancesRequest < 3) {
    checkUnnamed496(o.instances!);
    unittest.expect(o.skipInstancesOnValidationError!, unittest.isTrue);
  }
  buildCounterRegionInstanceGroupManagersDeleteInstancesRequest--;
}

core.List<api.InstanceManagedByIgmError> buildUnnamed497() => [
      buildInstanceManagedByIgmError(),
      buildInstanceManagedByIgmError(),
    ];

void checkUnnamed497(core.List<api.InstanceManagedByIgmError> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceManagedByIgmError(o[0]);
  checkInstanceManagedByIgmError(o[1]);
}

core.int buildCounterRegionInstanceGroupManagersListErrorsResponse = 0;
api.RegionInstanceGroupManagersListErrorsResponse
    buildRegionInstanceGroupManagersListErrorsResponse() {
  final o = api.RegionInstanceGroupManagersListErrorsResponse();
  buildCounterRegionInstanceGroupManagersListErrorsResponse++;
  if (buildCounterRegionInstanceGroupManagersListErrorsResponse < 3) {
    o.items = buildUnnamed497();
    o.nextPageToken = 'foo';
  }
  buildCounterRegionInstanceGroupManagersListErrorsResponse--;
  return o;
}

void checkRegionInstanceGroupManagersListErrorsResponse(
    api.RegionInstanceGroupManagersListErrorsResponse o) {
  buildCounterRegionInstanceGroupManagersListErrorsResponse++;
  if (buildCounterRegionInstanceGroupManagersListErrorsResponse < 3) {
    checkUnnamed497(o.items!);
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupManagersListErrorsResponse--;
}

core.List<api.PerInstanceConfig> buildUnnamed498() => [
      buildPerInstanceConfig(),
      buildPerInstanceConfig(),
    ];

void checkUnnamed498(core.List<api.PerInstanceConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkPerInstanceConfig(o[0]);
  checkPerInstanceConfig(o[1]);
}

core.int
    buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarningData =
    0;
api.RegionInstanceGroupManagersListInstanceConfigsRespWarningData
    buildRegionInstanceGroupManagersListInstanceConfigsRespWarningData() {
  final o = api.RegionInstanceGroupManagersListInstanceConfigsRespWarningData();
  buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarningData++;
  if (buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarningData <
      3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarningData--;
  return o;
}

void checkRegionInstanceGroupManagersListInstanceConfigsRespWarningData(
    api.RegionInstanceGroupManagersListInstanceConfigsRespWarningData o) {
  buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarningData++;
  if (buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarningData <
      3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarningData--;
}

core.List<api.RegionInstanceGroupManagersListInstanceConfigsRespWarningData>
    buildUnnamed499() => [
          buildRegionInstanceGroupManagersListInstanceConfigsRespWarningData(),
          buildRegionInstanceGroupManagersListInstanceConfigsRespWarningData(),
        ];

void checkUnnamed499(
    core.List<api.RegionInstanceGroupManagersListInstanceConfigsRespWarningData>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionInstanceGroupManagersListInstanceConfigsRespWarningData(o[0]);
  checkRegionInstanceGroupManagersListInstanceConfigsRespWarningData(o[1]);
}

core.int buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarning =
    0;
api.RegionInstanceGroupManagersListInstanceConfigsRespWarning
    buildRegionInstanceGroupManagersListInstanceConfigsRespWarning() {
  final o = api.RegionInstanceGroupManagersListInstanceConfigsRespWarning();
  buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarning++;
  if (buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarning <
      3) {
    o.code = 'foo';
    o.data = buildUnnamed499();
    o.message = 'foo';
  }
  buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarning--;
  return o;
}

void checkRegionInstanceGroupManagersListInstanceConfigsRespWarning(
    api.RegionInstanceGroupManagersListInstanceConfigsRespWarning o) {
  buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarning++;
  if (buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarning <
      3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed499(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupManagersListInstanceConfigsRespWarning--;
}

core.int buildCounterRegionInstanceGroupManagersListInstanceConfigsResp = 0;
api.RegionInstanceGroupManagersListInstanceConfigsResp
    buildRegionInstanceGroupManagersListInstanceConfigsResp() {
  final o = api.RegionInstanceGroupManagersListInstanceConfigsResp();
  buildCounterRegionInstanceGroupManagersListInstanceConfigsResp++;
  if (buildCounterRegionInstanceGroupManagersListInstanceConfigsResp < 3) {
    o.items = buildUnnamed498();
    o.nextPageToken = 'foo';
    o.warning =
        buildRegionInstanceGroupManagersListInstanceConfigsRespWarning();
  }
  buildCounterRegionInstanceGroupManagersListInstanceConfigsResp--;
  return o;
}

void checkRegionInstanceGroupManagersListInstanceConfigsResp(
    api.RegionInstanceGroupManagersListInstanceConfigsResp o) {
  buildCounterRegionInstanceGroupManagersListInstanceConfigsResp++;
  if (buildCounterRegionInstanceGroupManagersListInstanceConfigsResp < 3) {
    checkUnnamed498(o.items!);
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    checkRegionInstanceGroupManagersListInstanceConfigsRespWarning(o.warning!);
  }
  buildCounterRegionInstanceGroupManagersListInstanceConfigsResp--;
}

core.List<api.ManagedInstance> buildUnnamed500() => [
      buildManagedInstance(),
      buildManagedInstance(),
    ];

void checkUnnamed500(core.List<api.ManagedInstance> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkManagedInstance(o[0]);
  checkManagedInstance(o[1]);
}

core.int buildCounterRegionInstanceGroupManagersListInstancesResponse = 0;
api.RegionInstanceGroupManagersListInstancesResponse
    buildRegionInstanceGroupManagersListInstancesResponse() {
  final o = api.RegionInstanceGroupManagersListInstancesResponse();
  buildCounterRegionInstanceGroupManagersListInstancesResponse++;
  if (buildCounterRegionInstanceGroupManagersListInstancesResponse < 3) {
    o.managedInstances = buildUnnamed500();
    o.nextPageToken = 'foo';
  }
  buildCounterRegionInstanceGroupManagersListInstancesResponse--;
  return o;
}

void checkRegionInstanceGroupManagersListInstancesResponse(
    api.RegionInstanceGroupManagersListInstancesResponse o) {
  buildCounterRegionInstanceGroupManagersListInstancesResponse++;
  if (buildCounterRegionInstanceGroupManagersListInstancesResponse < 3) {
    checkUnnamed500(o.managedInstances!);
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupManagersListInstancesResponse--;
}

core.List<core.String> buildUnnamed501() => [
      'foo',
      'foo',
    ];

void checkUnnamed501(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionInstanceGroupManagersRecreateRequest = 0;
api.RegionInstanceGroupManagersRecreateRequest
    buildRegionInstanceGroupManagersRecreateRequest() {
  final o = api.RegionInstanceGroupManagersRecreateRequest();
  buildCounterRegionInstanceGroupManagersRecreateRequest++;
  if (buildCounterRegionInstanceGroupManagersRecreateRequest < 3) {
    o.instances = buildUnnamed501();
  }
  buildCounterRegionInstanceGroupManagersRecreateRequest--;
  return o;
}

void checkRegionInstanceGroupManagersRecreateRequest(
    api.RegionInstanceGroupManagersRecreateRequest o) {
  buildCounterRegionInstanceGroupManagersRecreateRequest++;
  if (buildCounterRegionInstanceGroupManagersRecreateRequest < 3) {
    checkUnnamed501(o.instances!);
  }
  buildCounterRegionInstanceGroupManagersRecreateRequest--;
}

core.List<core.String> buildUnnamed502() => [
      'foo',
      'foo',
    ];

void checkUnnamed502(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest = 0;
api.RegionInstanceGroupManagersSetTargetPoolsRequest
    buildRegionInstanceGroupManagersSetTargetPoolsRequest() {
  final o = api.RegionInstanceGroupManagersSetTargetPoolsRequest();
  buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest++;
  if (buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest < 3) {
    o.fingerprint = 'foo';
    o.targetPools = buildUnnamed502();
  }
  buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest--;
  return o;
}

void checkRegionInstanceGroupManagersSetTargetPoolsRequest(
    api.RegionInstanceGroupManagersSetTargetPoolsRequest o) {
  buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest++;
  if (buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest < 3) {
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed502(o.targetPools!);
  }
  buildCounterRegionInstanceGroupManagersSetTargetPoolsRequest--;
}

core.int buildCounterRegionInstanceGroupManagersSetTemplateRequest = 0;
api.RegionInstanceGroupManagersSetTemplateRequest
    buildRegionInstanceGroupManagersSetTemplateRequest() {
  final o = api.RegionInstanceGroupManagersSetTemplateRequest();
  buildCounterRegionInstanceGroupManagersSetTemplateRequest++;
  if (buildCounterRegionInstanceGroupManagersSetTemplateRequest < 3) {
    o.instanceTemplate = 'foo';
  }
  buildCounterRegionInstanceGroupManagersSetTemplateRequest--;
  return o;
}

void checkRegionInstanceGroupManagersSetTemplateRequest(
    api.RegionInstanceGroupManagersSetTemplateRequest o) {
  buildCounterRegionInstanceGroupManagersSetTemplateRequest++;
  if (buildCounterRegionInstanceGroupManagersSetTemplateRequest < 3) {
    unittest.expect(
      o.instanceTemplate!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupManagersSetTemplateRequest--;
}

core.List<api.InstanceWithNamedPorts> buildUnnamed503() => [
      buildInstanceWithNamedPorts(),
      buildInstanceWithNamedPorts(),
    ];

void checkUnnamed503(core.List<api.InstanceWithNamedPorts> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkInstanceWithNamedPorts(o[0]);
  checkInstanceWithNamedPorts(o[1]);
}

core.int buildCounterRegionInstanceGroupsListInstancesWarningData = 0;
api.RegionInstanceGroupsListInstancesWarningData
    buildRegionInstanceGroupsListInstancesWarningData() {
  final o = api.RegionInstanceGroupsListInstancesWarningData();
  buildCounterRegionInstanceGroupsListInstancesWarningData++;
  if (buildCounterRegionInstanceGroupsListInstancesWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRegionInstanceGroupsListInstancesWarningData--;
  return o;
}

void checkRegionInstanceGroupsListInstancesWarningData(
    api.RegionInstanceGroupsListInstancesWarningData o) {
  buildCounterRegionInstanceGroupsListInstancesWarningData++;
  if (buildCounterRegionInstanceGroupsListInstancesWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupsListInstancesWarningData--;
}

core.List<api.RegionInstanceGroupsListInstancesWarningData> buildUnnamed504() =>
    [
      buildRegionInstanceGroupsListInstancesWarningData(),
      buildRegionInstanceGroupsListInstancesWarningData(),
    ];

void checkUnnamed504(
    core.List<api.RegionInstanceGroupsListInstancesWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionInstanceGroupsListInstancesWarningData(o[0]);
  checkRegionInstanceGroupsListInstancesWarningData(o[1]);
}

core.int buildCounterRegionInstanceGroupsListInstancesWarning = 0;
api.RegionInstanceGroupsListInstancesWarning
    buildRegionInstanceGroupsListInstancesWarning() {
  final o = api.RegionInstanceGroupsListInstancesWarning();
  buildCounterRegionInstanceGroupsListInstancesWarning++;
  if (buildCounterRegionInstanceGroupsListInstancesWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed504();
    o.message = 'foo';
  }
  buildCounterRegionInstanceGroupsListInstancesWarning--;
  return o;
}

void checkRegionInstanceGroupsListInstancesWarning(
    api.RegionInstanceGroupsListInstancesWarning o) {
  buildCounterRegionInstanceGroupsListInstancesWarning++;
  if (buildCounterRegionInstanceGroupsListInstancesWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed504(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupsListInstancesWarning--;
}

core.int buildCounterRegionInstanceGroupsListInstances = 0;
api.RegionInstanceGroupsListInstances buildRegionInstanceGroupsListInstances() {
  final o = api.RegionInstanceGroupsListInstances();
  buildCounterRegionInstanceGroupsListInstances++;
  if (buildCounterRegionInstanceGroupsListInstances < 3) {
    o.id = 'foo';
    o.items = buildUnnamed503();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildRegionInstanceGroupsListInstancesWarning();
  }
  buildCounterRegionInstanceGroupsListInstances--;
  return o;
}

void checkRegionInstanceGroupsListInstances(
    api.RegionInstanceGroupsListInstances o) {
  buildCounterRegionInstanceGroupsListInstances++;
  if (buildCounterRegionInstanceGroupsListInstances < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed503(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkRegionInstanceGroupsListInstancesWarning(o.warning!);
  }
  buildCounterRegionInstanceGroupsListInstances--;
}

core.int buildCounterRegionInstanceGroupsListInstancesRequest = 0;
api.RegionInstanceGroupsListInstancesRequest
    buildRegionInstanceGroupsListInstancesRequest() {
  final o = api.RegionInstanceGroupsListInstancesRequest();
  buildCounterRegionInstanceGroupsListInstancesRequest++;
  if (buildCounterRegionInstanceGroupsListInstancesRequest < 3) {
    o.instanceState = 'foo';
    o.portName = 'foo';
  }
  buildCounterRegionInstanceGroupsListInstancesRequest--;
  return o;
}

void checkRegionInstanceGroupsListInstancesRequest(
    api.RegionInstanceGroupsListInstancesRequest o) {
  buildCounterRegionInstanceGroupsListInstancesRequest++;
  if (buildCounterRegionInstanceGroupsListInstancesRequest < 3) {
    unittest.expect(
      o.instanceState!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.portName!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionInstanceGroupsListInstancesRequest--;
}

core.List<api.NamedPort> buildUnnamed505() => [
      buildNamedPort(),
      buildNamedPort(),
    ];

void checkUnnamed505(core.List<api.NamedPort> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNamedPort(o[0]);
  checkNamedPort(o[1]);
}

core.int buildCounterRegionInstanceGroupsSetNamedPortsRequest = 0;
api.RegionInstanceGroupsSetNamedPortsRequest
    buildRegionInstanceGroupsSetNamedPortsRequest() {
  final o = api.RegionInstanceGroupsSetNamedPortsRequest();
  buildCounterRegionInstanceGroupsSetNamedPortsRequest++;
  if (buildCounterRegionInstanceGroupsSetNamedPortsRequest < 3) {
    o.fingerprint = 'foo';
    o.namedPorts = buildUnnamed505();
  }
  buildCounterRegionInstanceGroupsSetNamedPortsRequest--;
  return o;
}

void checkRegionInstanceGroupsSetNamedPortsRequest(
    api.RegionInstanceGroupsSetNamedPortsRequest o) {
  buildCounterRegionInstanceGroupsSetNamedPortsRequest++;
  if (buildCounterRegionInstanceGroupsSetNamedPortsRequest < 3) {
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed505(o.namedPorts!);
  }
  buildCounterRegionInstanceGroupsSetNamedPortsRequest--;
}

core.List<api.Region> buildUnnamed506() => [
      buildRegion(),
      buildRegion(),
    ];

void checkUnnamed506(core.List<api.Region> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegion(o[0]);
  checkRegion(o[1]);
}

core.int buildCounterRegionListWarningData = 0;
api.RegionListWarningData buildRegionListWarningData() {
  final o = api.RegionListWarningData();
  buildCounterRegionListWarningData++;
  if (buildCounterRegionListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRegionListWarningData--;
  return o;
}

void checkRegionListWarningData(api.RegionListWarningData o) {
  buildCounterRegionListWarningData++;
  if (buildCounterRegionListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionListWarningData--;
}

core.List<api.RegionListWarningData> buildUnnamed507() => [
      buildRegionListWarningData(),
      buildRegionListWarningData(),
    ];

void checkUnnamed507(core.List<api.RegionListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionListWarningData(o[0]);
  checkRegionListWarningData(o[1]);
}

core.int buildCounterRegionListWarning = 0;
api.RegionListWarning buildRegionListWarning() {
  final o = api.RegionListWarning();
  buildCounterRegionListWarning++;
  if (buildCounterRegionListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed507();
    o.message = 'foo';
  }
  buildCounterRegionListWarning--;
  return o;
}

void checkRegionListWarning(api.RegionListWarning o) {
  buildCounterRegionListWarning++;
  if (buildCounterRegionListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed507(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionListWarning--;
}

core.int buildCounterRegionList = 0;
api.RegionList buildRegionList() {
  final o = api.RegionList();
  buildCounterRegionList++;
  if (buildCounterRegionList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed506();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildRegionListWarning();
  }
  buildCounterRegionList--;
  return o;
}

void checkRegionList(api.RegionList o) {
  buildCounterRegionList++;
  if (buildCounterRegionList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed506(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkRegionListWarning(o.warning!);
  }
  buildCounterRegionList--;
}

core.List<api.NetworkEndpoint> buildUnnamed508() => [
      buildNetworkEndpoint(),
      buildNetworkEndpoint(),
    ];

void checkUnnamed508(core.List<api.NetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpoint(o[0]);
  checkNetworkEndpoint(o[1]);
}

core.int buildCounterRegionNetworkEndpointGroupsAttachEndpointsRequest = 0;
api.RegionNetworkEndpointGroupsAttachEndpointsRequest
    buildRegionNetworkEndpointGroupsAttachEndpointsRequest() {
  final o = api.RegionNetworkEndpointGroupsAttachEndpointsRequest();
  buildCounterRegionNetworkEndpointGroupsAttachEndpointsRequest++;
  if (buildCounterRegionNetworkEndpointGroupsAttachEndpointsRequest < 3) {
    o.networkEndpoints = buildUnnamed508();
  }
  buildCounterRegionNetworkEndpointGroupsAttachEndpointsRequest--;
  return o;
}

void checkRegionNetworkEndpointGroupsAttachEndpointsRequest(
    api.RegionNetworkEndpointGroupsAttachEndpointsRequest o) {
  buildCounterRegionNetworkEndpointGroupsAttachEndpointsRequest++;
  if (buildCounterRegionNetworkEndpointGroupsAttachEndpointsRequest < 3) {
    checkUnnamed508(o.networkEndpoints!);
  }
  buildCounterRegionNetworkEndpointGroupsAttachEndpointsRequest--;
}

core.List<api.NetworkEndpoint> buildUnnamed509() => [
      buildNetworkEndpoint(),
      buildNetworkEndpoint(),
    ];

void checkUnnamed509(core.List<api.NetworkEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkNetworkEndpoint(o[0]);
  checkNetworkEndpoint(o[1]);
}

core.int buildCounterRegionNetworkEndpointGroupsDetachEndpointsRequest = 0;
api.RegionNetworkEndpointGroupsDetachEndpointsRequest
    buildRegionNetworkEndpointGroupsDetachEndpointsRequest() {
  final o = api.RegionNetworkEndpointGroupsDetachEndpointsRequest();
  buildCounterRegionNetworkEndpointGroupsDetachEndpointsRequest++;
  if (buildCounterRegionNetworkEndpointGroupsDetachEndpointsRequest < 3) {
    o.networkEndpoints = buildUnnamed509();
  }
  buildCounterRegionNetworkEndpointGroupsDetachEndpointsRequest--;
  return o;
}

void checkRegionNetworkEndpointGroupsDetachEndpointsRequest(
    api.RegionNetworkEndpointGroupsDetachEndpointsRequest o) {
  buildCounterRegionNetworkEndpointGroupsDetachEndpointsRequest++;
  if (buildCounterRegionNetworkEndpointGroupsDetachEndpointsRequest < 3) {
    checkUnnamed509(o.networkEndpoints!);
  }
  buildCounterRegionNetworkEndpointGroupsDetachEndpointsRequest--;
}

core.List<
        api
        .RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy>
    buildUnnamed510() => [
          buildRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(),
          buildRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(),
        ];

void checkUnnamed510(
    core.List<
            api
            .RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(
      o[0]);
  checkRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(
      o[1]);
}

core.List<api.Firewall> buildUnnamed511() => [
      buildFirewall(),
      buildFirewall(),
    ];

void checkUnnamed511(core.List<api.Firewall> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewall(o[0]);
  checkFirewall(o[1]);
}

core.int
    buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse = 0;
api.RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse
    buildRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse() {
  final o = api.RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse();
  buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse++;
  if (buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse <
      3) {
    o.firewallPolicys = buildUnnamed510();
    o.firewalls = buildUnnamed511();
  }
  buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse--;
  return o;
}

void checkRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse(
    api.RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse o) {
  buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse++;
  if (buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse <
      3) {
    checkUnnamed510(o.firewallPolicys!);
    checkUnnamed511(o.firewalls!);
  }
  buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse--;
}

core.List<api.FirewallPolicyRule> buildUnnamed512() => [
      buildFirewallPolicyRule(),
      buildFirewallPolicyRule(),
    ];

void checkUnnamed512(core.List<api.FirewallPolicyRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkFirewallPolicyRule(o[0]);
  checkFirewallPolicyRule(o[1]);
}

core.int
    buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy =
    0;
api.RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy
    buildRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy() {
  final o = api
      .RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy();
  buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy++;
  if (buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy <
      3) {
    o.displayName = 'foo';
    o.name = 'foo';
    o.rules = buildUnnamed512();
    o.type = 'foo';
  }
  buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy--;
  return o;
}

void checkRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(
    api.RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy
        o) {
  buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy++;
  if (buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy <
      3) {
    unittest.expect(
      o.displayName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed512(o.rules!);
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterRegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy--;
}

core.Map<core.String, core.String> buildUnnamed513() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed513(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionSetLabelsRequest = 0;
api.RegionSetLabelsRequest buildRegionSetLabelsRequest() {
  final o = api.RegionSetLabelsRequest();
  buildCounterRegionSetLabelsRequest++;
  if (buildCounterRegionSetLabelsRequest < 3) {
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed513();
  }
  buildCounterRegionSetLabelsRequest--;
  return o;
}

void checkRegionSetLabelsRequest(api.RegionSetLabelsRequest o) {
  buildCounterRegionSetLabelsRequest++;
  if (buildCounterRegionSetLabelsRequest < 3) {
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed513(o.labels!);
  }
  buildCounterRegionSetLabelsRequest--;
}

core.List<api.Binding> buildUnnamed514() => [
      buildBinding(),
      buildBinding(),
    ];

void checkUnnamed514(core.List<api.Binding> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkBinding(o[0]);
  checkBinding(o[1]);
}

core.int buildCounterRegionSetPolicyRequest = 0;
api.RegionSetPolicyRequest buildRegionSetPolicyRequest() {
  final o = api.RegionSetPolicyRequest();
  buildCounterRegionSetPolicyRequest++;
  if (buildCounterRegionSetPolicyRequest < 3) {
    o.bindings = buildUnnamed514();
    o.etag = 'foo';
    o.policy = buildPolicy();
  }
  buildCounterRegionSetPolicyRequest--;
  return o;
}

void checkRegionSetPolicyRequest(api.RegionSetPolicyRequest o) {
  buildCounterRegionSetPolicyRequest++;
  if (buildCounterRegionSetPolicyRequest < 3) {
    checkUnnamed514(o.bindings!);
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    checkPolicy(o.policy!);
  }
  buildCounterRegionSetPolicyRequest--;
}

core.List<core.String> buildUnnamed515() => [
      'foo',
      'foo',
    ];

void checkUnnamed515(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRegionTargetHttpsProxiesSetSslCertificatesRequest = 0;
api.RegionTargetHttpsProxiesSetSslCertificatesRequest
    buildRegionTargetHttpsProxiesSetSslCertificatesRequest() {
  final o = api.RegionTargetHttpsProxiesSetSslCertificatesRequest();
  buildCounterRegionTargetHttpsProxiesSetSslCertificatesRequest++;
  if (buildCounterRegionTargetHttpsProxiesSetSslCertificatesRequest < 3) {
    o.sslCertificates = buildUnnamed515();
  }
  buildCounterRegionTargetHttpsProxiesSetSslCertificatesRequest--;
  return o;
}

void checkRegionTargetHttpsProxiesSetSslCertificatesRequest(
    api.RegionTargetHttpsProxiesSetSslCertificatesRequest o) {
  buildCounterRegionTargetHttpsProxiesSetSslCertificatesRequest++;
  if (buildCounterRegionTargetHttpsProxiesSetSslCertificatesRequest < 3) {
    checkUnnamed515(o.sslCertificates!);
  }
  buildCounterRegionTargetHttpsProxiesSetSslCertificatesRequest--;
}

core.int buildCounterRegionUrlMapsValidateRequest = 0;
api.RegionUrlMapsValidateRequest buildRegionUrlMapsValidateRequest() {
  final o = api.RegionUrlMapsValidateRequest();
  buildCounterRegionUrlMapsValidateRequest++;
  if (buildCounterRegionUrlMapsValidateRequest < 3) {
    o.resource = buildUrlMap();
  }
  buildCounterRegionUrlMapsValidateRequest--;
  return o;
}

void checkRegionUrlMapsValidateRequest(api.RegionUrlMapsValidateRequest o) {
  buildCounterRegionUrlMapsValidateRequest++;
  if (buildCounterRegionUrlMapsValidateRequest < 3) {
    checkUrlMap(o.resource!);
  }
  buildCounterRegionUrlMapsValidateRequest--;
}

core.int buildCounterRequestMirrorPolicy = 0;
api.RequestMirrorPolicy buildRequestMirrorPolicy() {
  final o = api.RequestMirrorPolicy();
  buildCounterRequestMirrorPolicy++;
  if (buildCounterRequestMirrorPolicy < 3) {
    o.backendService = 'foo';
  }
  buildCounterRequestMirrorPolicy--;
  return o;
}

void checkRequestMirrorPolicy(api.RequestMirrorPolicy o) {
  buildCounterRequestMirrorPolicy++;
  if (buildCounterRequestMirrorPolicy < 3) {
    unittest.expect(
      o.backendService!,
      unittest.equals('foo'),
    );
  }
  buildCounterRequestMirrorPolicy--;
}

core.Map<core.String, core.String> buildUnnamed516() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed516(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.int buildCounterReservation = 0;
api.Reservation buildReservation() {
  final o = api.Reservation();
  buildCounterReservation++;
  if (buildCounterReservation < 3) {
    o.commitment = 'foo';
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.resourcePolicies = buildUnnamed516();
    o.resourceStatus = buildAllocationResourceStatus();
    o.satisfiesPzs = true;
    o.selfLink = 'foo';
    o.shareSettings = buildShareSettings();
    o.specificReservation = buildAllocationSpecificSKUReservation();
    o.specificReservationRequired = true;
    o.status = 'foo';
    o.zone = 'foo';
  }
  buildCounterReservation--;
  return o;
}

void checkReservation(api.Reservation o) {
  buildCounterReservation++;
  if (buildCounterReservation < 3) {
    unittest.expect(
      o.commitment!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed516(o.resourcePolicies!);
    checkAllocationResourceStatus(o.resourceStatus!);
    unittest.expect(o.satisfiesPzs!, unittest.isTrue);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkShareSettings(o.shareSettings!);
    checkAllocationSpecificSKUReservation(o.specificReservation!);
    unittest.expect(o.specificReservationRequired!, unittest.isTrue);
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.zone!,
      unittest.equals('foo'),
    );
  }
  buildCounterReservation--;
}

core.List<core.String> buildUnnamed517() => [
      'foo',
      'foo',
    ];

void checkUnnamed517(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterReservationAffinity = 0;
api.ReservationAffinity buildReservationAffinity() {
  final o = api.ReservationAffinity();
  buildCounterReservationAffinity++;
  if (buildCounterReservationAffinity < 3) {
    o.consumeReservationType = 'foo';
    o.key = 'foo';
    o.values = buildUnnamed517();
  }
  buildCounterReservationAffinity--;
  return o;
}

void checkReservationAffinity(api.ReservationAffinity o) {
  buildCounterReservationAffinity++;
  if (buildCounterReservationAffinity < 3) {
    unittest.expect(
      o.consumeReservationType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    checkUnnamed517(o.values!);
  }
  buildCounterReservationAffinity--;
}

core.Map<core.String, api.ReservationsScopedList> buildUnnamed518() => {
      'x': buildReservationsScopedList(),
      'y': buildReservationsScopedList(),
    };

void checkUnnamed518(core.Map<core.String, api.ReservationsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservationsScopedList(o['x']!);
  checkReservationsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed519() => [
      'foo',
      'foo',
    ];

void checkUnnamed519(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterReservationAggregatedListWarningData = 0;
api.ReservationAggregatedListWarningData
    buildReservationAggregatedListWarningData() {
  final o = api.ReservationAggregatedListWarningData();
  buildCounterReservationAggregatedListWarningData++;
  if (buildCounterReservationAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterReservationAggregatedListWarningData--;
  return o;
}

void checkReservationAggregatedListWarningData(
    api.ReservationAggregatedListWarningData o) {
  buildCounterReservationAggregatedListWarningData++;
  if (buildCounterReservationAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterReservationAggregatedListWarningData--;
}

core.List<api.ReservationAggregatedListWarningData> buildUnnamed520() => [
      buildReservationAggregatedListWarningData(),
      buildReservationAggregatedListWarningData(),
    ];

void checkUnnamed520(core.List<api.ReservationAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservationAggregatedListWarningData(o[0]);
  checkReservationAggregatedListWarningData(o[1]);
}

core.int buildCounterReservationAggregatedListWarning = 0;
api.ReservationAggregatedListWarning buildReservationAggregatedListWarning() {
  final o = api.ReservationAggregatedListWarning();
  buildCounterReservationAggregatedListWarning++;
  if (buildCounterReservationAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed520();
    o.message = 'foo';
  }
  buildCounterReservationAggregatedListWarning--;
  return o;
}

void checkReservationAggregatedListWarning(
    api.ReservationAggregatedListWarning o) {
  buildCounterReservationAggregatedListWarning++;
  if (buildCounterReservationAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed520(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterReservationAggregatedListWarning--;
}

core.int buildCounterReservationAggregatedList = 0;
api.ReservationAggregatedList buildReservationAggregatedList() {
  final o = api.ReservationAggregatedList();
  buildCounterReservationAggregatedList++;
  if (buildCounterReservationAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed518();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed519();
    o.warning = buildReservationAggregatedListWarning();
  }
  buildCounterReservationAggregatedList--;
  return o;
}

void checkReservationAggregatedList(api.ReservationAggregatedList o) {
  buildCounterReservationAggregatedList++;
  if (buildCounterReservationAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed518(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed519(o.unreachables!);
    checkReservationAggregatedListWarning(o.warning!);
  }
  buildCounterReservationAggregatedList--;
}

core.List<api.Reservation> buildUnnamed521() => [
      buildReservation(),
      buildReservation(),
    ];

void checkUnnamed521(core.List<api.Reservation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservation(o[0]);
  checkReservation(o[1]);
}

core.int buildCounterReservationListWarningData = 0;
api.ReservationListWarningData buildReservationListWarningData() {
  final o = api.ReservationListWarningData();
  buildCounterReservationListWarningData++;
  if (buildCounterReservationListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterReservationListWarningData--;
  return o;
}

void checkReservationListWarningData(api.ReservationListWarningData o) {
  buildCounterReservationListWarningData++;
  if (buildCounterReservationListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterReservationListWarningData--;
}

core.List<api.ReservationListWarningData> buildUnnamed522() => [
      buildReservationListWarningData(),
      buildReservationListWarningData(),
    ];

void checkUnnamed522(core.List<api.ReservationListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservationListWarningData(o[0]);
  checkReservationListWarningData(o[1]);
}

core.int buildCounterReservationListWarning = 0;
api.ReservationListWarning buildReservationListWarning() {
  final o = api.ReservationListWarning();
  buildCounterReservationListWarning++;
  if (buildCounterReservationListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed522();
    o.message = 'foo';
  }
  buildCounterReservationListWarning--;
  return o;
}

void checkReservationListWarning(api.ReservationListWarning o) {
  buildCounterReservationListWarning++;
  if (buildCounterReservationListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed522(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterReservationListWarning--;
}

core.int buildCounterReservationList = 0;
api.ReservationList buildReservationList() {
  final o = api.ReservationList();
  buildCounterReservationList++;
  if (buildCounterReservationList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed521();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildReservationListWarning();
  }
  buildCounterReservationList--;
  return o;
}

void checkReservationList(api.ReservationList o) {
  buildCounterReservationList++;
  if (buildCounterReservationList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed521(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkReservationListWarning(o.warning!);
  }
  buildCounterReservationList--;
}

core.int buildCounterReservationsResizeRequest = 0;
api.ReservationsResizeRequest buildReservationsResizeRequest() {
  final o = api.ReservationsResizeRequest();
  buildCounterReservationsResizeRequest++;
  if (buildCounterReservationsResizeRequest < 3) {
    o.specificSkuCount = 'foo';
  }
  buildCounterReservationsResizeRequest--;
  return o;
}

void checkReservationsResizeRequest(api.ReservationsResizeRequest o) {
  buildCounterReservationsResizeRequest++;
  if (buildCounterReservationsResizeRequest < 3) {
    unittest.expect(
      o.specificSkuCount!,
      unittest.equals('foo'),
    );
  }
  buildCounterReservationsResizeRequest--;
}

core.List<api.Reservation> buildUnnamed523() => [
      buildReservation(),
      buildReservation(),
    ];

void checkUnnamed523(core.List<api.Reservation> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservation(o[0]);
  checkReservation(o[1]);
}

core.int buildCounterReservationsScopedListWarningData = 0;
api.ReservationsScopedListWarningData buildReservationsScopedListWarningData() {
  final o = api.ReservationsScopedListWarningData();
  buildCounterReservationsScopedListWarningData++;
  if (buildCounterReservationsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterReservationsScopedListWarningData--;
  return o;
}

void checkReservationsScopedListWarningData(
    api.ReservationsScopedListWarningData o) {
  buildCounterReservationsScopedListWarningData++;
  if (buildCounterReservationsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterReservationsScopedListWarningData--;
}

core.List<api.ReservationsScopedListWarningData> buildUnnamed524() => [
      buildReservationsScopedListWarningData(),
      buildReservationsScopedListWarningData(),
    ];

void checkUnnamed524(core.List<api.ReservationsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkReservationsScopedListWarningData(o[0]);
  checkReservationsScopedListWarningData(o[1]);
}

core.int buildCounterReservationsScopedListWarning = 0;
api.ReservationsScopedListWarning buildReservationsScopedListWarning() {
  final o = api.ReservationsScopedListWarning();
  buildCounterReservationsScopedListWarning++;
  if (buildCounterReservationsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed524();
    o.message = 'foo';
  }
  buildCounterReservationsScopedListWarning--;
  return o;
}

void checkReservationsScopedListWarning(api.ReservationsScopedListWarning o) {
  buildCounterReservationsScopedListWarning++;
  if (buildCounterReservationsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed524(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterReservationsScopedListWarning--;
}

core.int buildCounterReservationsScopedList = 0;
api.ReservationsScopedList buildReservationsScopedList() {
  final o = api.ReservationsScopedList();
  buildCounterReservationsScopedList++;
  if (buildCounterReservationsScopedList < 3) {
    o.reservations = buildUnnamed523();
    o.warning = buildReservationsScopedListWarning();
  }
  buildCounterReservationsScopedList--;
  return o;
}

void checkReservationsScopedList(api.ReservationsScopedList o) {
  buildCounterReservationsScopedList++;
  if (buildCounterReservationsScopedList < 3) {
    checkUnnamed523(o.reservations!);
    checkReservationsScopedListWarning(o.warning!);
  }
  buildCounterReservationsScopedList--;
}

core.int buildCounterResourceCommitment = 0;
api.ResourceCommitment buildResourceCommitment() {
  final o = api.ResourceCommitment();
  buildCounterResourceCommitment++;
  if (buildCounterResourceCommitment < 3) {
    o.acceleratorType = 'foo';
    o.amount = 'foo';
    o.type = 'foo';
  }
  buildCounterResourceCommitment--;
  return o;
}

void checkResourceCommitment(api.ResourceCommitment o) {
  buildCounterResourceCommitment++;
  if (buildCounterResourceCommitment < 3) {
    unittest.expect(
      o.acceleratorType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.amount!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourceCommitment--;
}

core.int buildCounterResourceGroupReference = 0;
api.ResourceGroupReference buildResourceGroupReference() {
  final o = api.ResourceGroupReference();
  buildCounterResourceGroupReference++;
  if (buildCounterResourceGroupReference < 3) {
    o.group = 'foo';
  }
  buildCounterResourceGroupReference--;
  return o;
}

void checkResourceGroupReference(api.ResourceGroupReference o) {
  buildCounterResourceGroupReference++;
  if (buildCounterResourceGroupReference < 3) {
    unittest.expect(
      o.group!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourceGroupReference--;
}

core.List<api.ResourcePolicy> buildUnnamed525() => [
      buildResourcePolicy(),
      buildResourcePolicy(),
    ];

void checkUnnamed525(core.List<api.ResourcePolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicy(o[0]);
  checkResourcePolicy(o[1]);
}

core.int buildCounterResourcePoliciesScopedListWarningData = 0;
api.ResourcePoliciesScopedListWarningData
    buildResourcePoliciesScopedListWarningData() {
  final o = api.ResourcePoliciesScopedListWarningData();
  buildCounterResourcePoliciesScopedListWarningData++;
  if (buildCounterResourcePoliciesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterResourcePoliciesScopedListWarningData--;
  return o;
}

void checkResourcePoliciesScopedListWarningData(
    api.ResourcePoliciesScopedListWarningData o) {
  buildCounterResourcePoliciesScopedListWarningData++;
  if (buildCounterResourcePoliciesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePoliciesScopedListWarningData--;
}

core.List<api.ResourcePoliciesScopedListWarningData> buildUnnamed526() => [
      buildResourcePoliciesScopedListWarningData(),
      buildResourcePoliciesScopedListWarningData(),
    ];

void checkUnnamed526(core.List<api.ResourcePoliciesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePoliciesScopedListWarningData(o[0]);
  checkResourcePoliciesScopedListWarningData(o[1]);
}

core.int buildCounterResourcePoliciesScopedListWarning = 0;
api.ResourcePoliciesScopedListWarning buildResourcePoliciesScopedListWarning() {
  final o = api.ResourcePoliciesScopedListWarning();
  buildCounterResourcePoliciesScopedListWarning++;
  if (buildCounterResourcePoliciesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed526();
    o.message = 'foo';
  }
  buildCounterResourcePoliciesScopedListWarning--;
  return o;
}

void checkResourcePoliciesScopedListWarning(
    api.ResourcePoliciesScopedListWarning o) {
  buildCounterResourcePoliciesScopedListWarning++;
  if (buildCounterResourcePoliciesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed526(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePoliciesScopedListWarning--;
}

core.int buildCounterResourcePoliciesScopedList = 0;
api.ResourcePoliciesScopedList buildResourcePoliciesScopedList() {
  final o = api.ResourcePoliciesScopedList();
  buildCounterResourcePoliciesScopedList++;
  if (buildCounterResourcePoliciesScopedList < 3) {
    o.resourcePolicies = buildUnnamed525();
    o.warning = buildResourcePoliciesScopedListWarning();
  }
  buildCounterResourcePoliciesScopedList--;
  return o;
}

void checkResourcePoliciesScopedList(api.ResourcePoliciesScopedList o) {
  buildCounterResourcePoliciesScopedList++;
  if (buildCounterResourcePoliciesScopedList < 3) {
    checkUnnamed525(o.resourcePolicies!);
    checkResourcePoliciesScopedListWarning(o.warning!);
  }
  buildCounterResourcePoliciesScopedList--;
}

core.int buildCounterResourcePolicy = 0;
api.ResourcePolicy buildResourcePolicy() {
  final o = api.ResourcePolicy();
  buildCounterResourcePolicy++;
  if (buildCounterResourcePolicy < 3) {
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.diskConsistencyGroupPolicy =
        buildResourcePolicyDiskConsistencyGroupPolicy();
    o.groupPlacementPolicy = buildResourcePolicyGroupPlacementPolicy();
    o.id = 'foo';
    o.instanceSchedulePolicy = buildResourcePolicyInstanceSchedulePolicy();
    o.kind = 'foo';
    o.name = 'foo';
    o.region = 'foo';
    o.resourceStatus = buildResourcePolicyResourceStatus();
    o.selfLink = 'foo';
    o.snapshotSchedulePolicy = buildResourcePolicySnapshotSchedulePolicy();
    o.status = 'foo';
  }
  buildCounterResourcePolicy--;
  return o;
}

void checkResourcePolicy(api.ResourcePolicy o) {
  buildCounterResourcePolicy++;
  if (buildCounterResourcePolicy < 3) {
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkResourcePolicyDiskConsistencyGroupPolicy(
        o.diskConsistencyGroupPolicy!);
    checkResourcePolicyGroupPlacementPolicy(o.groupPlacementPolicy!);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkResourcePolicyInstanceSchedulePolicy(o.instanceSchedulePolicy!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    checkResourcePolicyResourceStatus(o.resourceStatus!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkResourcePolicySnapshotSchedulePolicy(o.snapshotSchedulePolicy!);
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicy--;
}

core.Map<core.String, api.ResourcePoliciesScopedList> buildUnnamed527() => {
      'x': buildResourcePoliciesScopedList(),
      'y': buildResourcePoliciesScopedList(),
    };

void checkUnnamed527(core.Map<core.String, api.ResourcePoliciesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePoliciesScopedList(o['x']!);
  checkResourcePoliciesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed528() => [
      'foo',
      'foo',
    ];

void checkUnnamed528(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterResourcePolicyAggregatedListWarningData = 0;
api.ResourcePolicyAggregatedListWarningData
    buildResourcePolicyAggregatedListWarningData() {
  final o = api.ResourcePolicyAggregatedListWarningData();
  buildCounterResourcePolicyAggregatedListWarningData++;
  if (buildCounterResourcePolicyAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterResourcePolicyAggregatedListWarningData--;
  return o;
}

void checkResourcePolicyAggregatedListWarningData(
    api.ResourcePolicyAggregatedListWarningData o) {
  buildCounterResourcePolicyAggregatedListWarningData++;
  if (buildCounterResourcePolicyAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyAggregatedListWarningData--;
}

core.List<api.ResourcePolicyAggregatedListWarningData> buildUnnamed529() => [
      buildResourcePolicyAggregatedListWarningData(),
      buildResourcePolicyAggregatedListWarningData(),
    ];

void checkUnnamed529(core.List<api.ResourcePolicyAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicyAggregatedListWarningData(o[0]);
  checkResourcePolicyAggregatedListWarningData(o[1]);
}

core.int buildCounterResourcePolicyAggregatedListWarning = 0;
api.ResourcePolicyAggregatedListWarning
    buildResourcePolicyAggregatedListWarning() {
  final o = api.ResourcePolicyAggregatedListWarning();
  buildCounterResourcePolicyAggregatedListWarning++;
  if (buildCounterResourcePolicyAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed529();
    o.message = 'foo';
  }
  buildCounterResourcePolicyAggregatedListWarning--;
  return o;
}

void checkResourcePolicyAggregatedListWarning(
    api.ResourcePolicyAggregatedListWarning o) {
  buildCounterResourcePolicyAggregatedListWarning++;
  if (buildCounterResourcePolicyAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed529(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyAggregatedListWarning--;
}

core.int buildCounterResourcePolicyAggregatedList = 0;
api.ResourcePolicyAggregatedList buildResourcePolicyAggregatedList() {
  final o = api.ResourcePolicyAggregatedList();
  buildCounterResourcePolicyAggregatedList++;
  if (buildCounterResourcePolicyAggregatedList < 3) {
    o.etag = 'foo';
    o.id = 'foo';
    o.items = buildUnnamed527();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed528();
    o.warning = buildResourcePolicyAggregatedListWarning();
  }
  buildCounterResourcePolicyAggregatedList--;
  return o;
}

void checkResourcePolicyAggregatedList(api.ResourcePolicyAggregatedList o) {
  buildCounterResourcePolicyAggregatedList++;
  if (buildCounterResourcePolicyAggregatedList < 3) {
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed527(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed528(o.unreachables!);
    checkResourcePolicyAggregatedListWarning(o.warning!);
  }
  buildCounterResourcePolicyAggregatedList--;
}

core.int buildCounterResourcePolicyDailyCycle = 0;
api.ResourcePolicyDailyCycle buildResourcePolicyDailyCycle() {
  final o = api.ResourcePolicyDailyCycle();
  buildCounterResourcePolicyDailyCycle++;
  if (buildCounterResourcePolicyDailyCycle < 3) {
    o.daysInCycle = 42;
    o.duration = 'foo';
    o.startTime = 'foo';
  }
  buildCounterResourcePolicyDailyCycle--;
  return o;
}

void checkResourcePolicyDailyCycle(api.ResourcePolicyDailyCycle o) {
  buildCounterResourcePolicyDailyCycle++;
  if (buildCounterResourcePolicyDailyCycle < 3) {
    unittest.expect(
      o.daysInCycle!,
      unittest.equals(42),
    );
    unittest.expect(
      o.duration!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyDailyCycle--;
}

core.int buildCounterResourcePolicyDiskConsistencyGroupPolicy = 0;
api.ResourcePolicyDiskConsistencyGroupPolicy
    buildResourcePolicyDiskConsistencyGroupPolicy() {
  final o = api.ResourcePolicyDiskConsistencyGroupPolicy();
  buildCounterResourcePolicyDiskConsistencyGroupPolicy++;
  if (buildCounterResourcePolicyDiskConsistencyGroupPolicy < 3) {}
  buildCounterResourcePolicyDiskConsistencyGroupPolicy--;
  return o;
}

void checkResourcePolicyDiskConsistencyGroupPolicy(
    api.ResourcePolicyDiskConsistencyGroupPolicy o) {
  buildCounterResourcePolicyDiskConsistencyGroupPolicy++;
  if (buildCounterResourcePolicyDiskConsistencyGroupPolicy < 3) {}
  buildCounterResourcePolicyDiskConsistencyGroupPolicy--;
}

core.int buildCounterResourcePolicyGroupPlacementPolicy = 0;
api.ResourcePolicyGroupPlacementPolicy
    buildResourcePolicyGroupPlacementPolicy() {
  final o = api.ResourcePolicyGroupPlacementPolicy();
  buildCounterResourcePolicyGroupPlacementPolicy++;
  if (buildCounterResourcePolicyGroupPlacementPolicy < 3) {
    o.availabilityDomainCount = 42;
    o.collocation = 'foo';
    o.vmCount = 42;
  }
  buildCounterResourcePolicyGroupPlacementPolicy--;
  return o;
}

void checkResourcePolicyGroupPlacementPolicy(
    api.ResourcePolicyGroupPlacementPolicy o) {
  buildCounterResourcePolicyGroupPlacementPolicy++;
  if (buildCounterResourcePolicyGroupPlacementPolicy < 3) {
    unittest.expect(
      o.availabilityDomainCount!,
      unittest.equals(42),
    );
    unittest.expect(
      o.collocation!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.vmCount!,
      unittest.equals(42),
    );
  }
  buildCounterResourcePolicyGroupPlacementPolicy--;
}

core.int buildCounterResourcePolicyHourlyCycle = 0;
api.ResourcePolicyHourlyCycle buildResourcePolicyHourlyCycle() {
  final o = api.ResourcePolicyHourlyCycle();
  buildCounterResourcePolicyHourlyCycle++;
  if (buildCounterResourcePolicyHourlyCycle < 3) {
    o.duration = 'foo';
    o.hoursInCycle = 42;
    o.startTime = 'foo';
  }
  buildCounterResourcePolicyHourlyCycle--;
  return o;
}

void checkResourcePolicyHourlyCycle(api.ResourcePolicyHourlyCycle o) {
  buildCounterResourcePolicyHourlyCycle++;
  if (buildCounterResourcePolicyHourlyCycle < 3) {
    unittest.expect(
      o.duration!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.hoursInCycle!,
      unittest.equals(42),
    );
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyHourlyCycle--;
}

core.int buildCounterResourcePolicyInstanceSchedulePolicy = 0;
api.ResourcePolicyInstanceSchedulePolicy
    buildResourcePolicyInstanceSchedulePolicy() {
  final o = api.ResourcePolicyInstanceSchedulePolicy();
  buildCounterResourcePolicyInstanceSchedulePolicy++;
  if (buildCounterResourcePolicyInstanceSchedulePolicy < 3) {
    o.expirationTime = 'foo';
    o.startTime = 'foo';
    o.timeZone = 'foo';
    o.vmStartSchedule = buildResourcePolicyInstanceSchedulePolicySchedule();
    o.vmStopSchedule = buildResourcePolicyInstanceSchedulePolicySchedule();
  }
  buildCounterResourcePolicyInstanceSchedulePolicy--;
  return o;
}

void checkResourcePolicyInstanceSchedulePolicy(
    api.ResourcePolicyInstanceSchedulePolicy o) {
  buildCounterResourcePolicyInstanceSchedulePolicy++;
  if (buildCounterResourcePolicyInstanceSchedulePolicy < 3) {
    unittest.expect(
      o.expirationTime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.timeZone!,
      unittest.equals('foo'),
    );
    checkResourcePolicyInstanceSchedulePolicySchedule(o.vmStartSchedule!);
    checkResourcePolicyInstanceSchedulePolicySchedule(o.vmStopSchedule!);
  }
  buildCounterResourcePolicyInstanceSchedulePolicy--;
}

core.int buildCounterResourcePolicyInstanceSchedulePolicySchedule = 0;
api.ResourcePolicyInstanceSchedulePolicySchedule
    buildResourcePolicyInstanceSchedulePolicySchedule() {
  final o = api.ResourcePolicyInstanceSchedulePolicySchedule();
  buildCounterResourcePolicyInstanceSchedulePolicySchedule++;
  if (buildCounterResourcePolicyInstanceSchedulePolicySchedule < 3) {
    o.schedule = 'foo';
  }
  buildCounterResourcePolicyInstanceSchedulePolicySchedule--;
  return o;
}

void checkResourcePolicyInstanceSchedulePolicySchedule(
    api.ResourcePolicyInstanceSchedulePolicySchedule o) {
  buildCounterResourcePolicyInstanceSchedulePolicySchedule++;
  if (buildCounterResourcePolicyInstanceSchedulePolicySchedule < 3) {
    unittest.expect(
      o.schedule!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyInstanceSchedulePolicySchedule--;
}

core.List<api.ResourcePolicy> buildUnnamed530() => [
      buildResourcePolicy(),
      buildResourcePolicy(),
    ];

void checkUnnamed530(core.List<api.ResourcePolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicy(o[0]);
  checkResourcePolicy(o[1]);
}

core.int buildCounterResourcePolicyListWarningData = 0;
api.ResourcePolicyListWarningData buildResourcePolicyListWarningData() {
  final o = api.ResourcePolicyListWarningData();
  buildCounterResourcePolicyListWarningData++;
  if (buildCounterResourcePolicyListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterResourcePolicyListWarningData--;
  return o;
}

void checkResourcePolicyListWarningData(api.ResourcePolicyListWarningData o) {
  buildCounterResourcePolicyListWarningData++;
  if (buildCounterResourcePolicyListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyListWarningData--;
}

core.List<api.ResourcePolicyListWarningData> buildUnnamed531() => [
      buildResourcePolicyListWarningData(),
      buildResourcePolicyListWarningData(),
    ];

void checkUnnamed531(core.List<api.ResourcePolicyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicyListWarningData(o[0]);
  checkResourcePolicyListWarningData(o[1]);
}

core.int buildCounterResourcePolicyListWarning = 0;
api.ResourcePolicyListWarning buildResourcePolicyListWarning() {
  final o = api.ResourcePolicyListWarning();
  buildCounterResourcePolicyListWarning++;
  if (buildCounterResourcePolicyListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed531();
    o.message = 'foo';
  }
  buildCounterResourcePolicyListWarning--;
  return o;
}

void checkResourcePolicyListWarning(api.ResourcePolicyListWarning o) {
  buildCounterResourcePolicyListWarning++;
  if (buildCounterResourcePolicyListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed531(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyListWarning--;
}

core.int buildCounterResourcePolicyList = 0;
api.ResourcePolicyList buildResourcePolicyList() {
  final o = api.ResourcePolicyList();
  buildCounterResourcePolicyList++;
  if (buildCounterResourcePolicyList < 3) {
    o.etag = 'foo';
    o.id = 'foo';
    o.items = buildUnnamed530();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildResourcePolicyListWarning();
  }
  buildCounterResourcePolicyList--;
  return o;
}

void checkResourcePolicyList(api.ResourcePolicyList o) {
  buildCounterResourcePolicyList++;
  if (buildCounterResourcePolicyList < 3) {
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed530(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkResourcePolicyListWarning(o.warning!);
  }
  buildCounterResourcePolicyList--;
}

core.int buildCounterResourcePolicyResourceStatus = 0;
api.ResourcePolicyResourceStatus buildResourcePolicyResourceStatus() {
  final o = api.ResourcePolicyResourceStatus();
  buildCounterResourcePolicyResourceStatus++;
  if (buildCounterResourcePolicyResourceStatus < 3) {
    o.instanceSchedulePolicy =
        buildResourcePolicyResourceStatusInstanceSchedulePolicyStatus();
  }
  buildCounterResourcePolicyResourceStatus--;
  return o;
}

void checkResourcePolicyResourceStatus(api.ResourcePolicyResourceStatus o) {
  buildCounterResourcePolicyResourceStatus++;
  if (buildCounterResourcePolicyResourceStatus < 3) {
    checkResourcePolicyResourceStatusInstanceSchedulePolicyStatus(
        o.instanceSchedulePolicy!);
  }
  buildCounterResourcePolicyResourceStatus--;
}

core.int buildCounterResourcePolicyResourceStatusInstanceSchedulePolicyStatus =
    0;
api.ResourcePolicyResourceStatusInstanceSchedulePolicyStatus
    buildResourcePolicyResourceStatusInstanceSchedulePolicyStatus() {
  final o = api.ResourcePolicyResourceStatusInstanceSchedulePolicyStatus();
  buildCounterResourcePolicyResourceStatusInstanceSchedulePolicyStatus++;
  if (buildCounterResourcePolicyResourceStatusInstanceSchedulePolicyStatus <
      3) {
    o.lastRunStartTime = 'foo';
    o.nextRunStartTime = 'foo';
  }
  buildCounterResourcePolicyResourceStatusInstanceSchedulePolicyStatus--;
  return o;
}

void checkResourcePolicyResourceStatusInstanceSchedulePolicyStatus(
    api.ResourcePolicyResourceStatusInstanceSchedulePolicyStatus o) {
  buildCounterResourcePolicyResourceStatusInstanceSchedulePolicyStatus++;
  if (buildCounterResourcePolicyResourceStatusInstanceSchedulePolicyStatus <
      3) {
    unittest.expect(
      o.lastRunStartTime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextRunStartTime!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyResourceStatusInstanceSchedulePolicyStatus--;
}

core.int buildCounterResourcePolicySnapshotSchedulePolicy = 0;
api.ResourcePolicySnapshotSchedulePolicy
    buildResourcePolicySnapshotSchedulePolicy() {
  final o = api.ResourcePolicySnapshotSchedulePolicy();
  buildCounterResourcePolicySnapshotSchedulePolicy++;
  if (buildCounterResourcePolicySnapshotSchedulePolicy < 3) {
    o.retentionPolicy =
        buildResourcePolicySnapshotSchedulePolicyRetentionPolicy();
    o.schedule = buildResourcePolicySnapshotSchedulePolicySchedule();
    o.snapshotProperties =
        buildResourcePolicySnapshotSchedulePolicySnapshotProperties();
  }
  buildCounterResourcePolicySnapshotSchedulePolicy--;
  return o;
}

void checkResourcePolicySnapshotSchedulePolicy(
    api.ResourcePolicySnapshotSchedulePolicy o) {
  buildCounterResourcePolicySnapshotSchedulePolicy++;
  if (buildCounterResourcePolicySnapshotSchedulePolicy < 3) {
    checkResourcePolicySnapshotSchedulePolicyRetentionPolicy(
        o.retentionPolicy!);
    checkResourcePolicySnapshotSchedulePolicySchedule(o.schedule!);
    checkResourcePolicySnapshotSchedulePolicySnapshotProperties(
        o.snapshotProperties!);
  }
  buildCounterResourcePolicySnapshotSchedulePolicy--;
}

core.int buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy = 0;
api.ResourcePolicySnapshotSchedulePolicyRetentionPolicy
    buildResourcePolicySnapshotSchedulePolicyRetentionPolicy() {
  final o = api.ResourcePolicySnapshotSchedulePolicyRetentionPolicy();
  buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy++;
  if (buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy < 3) {
    o.maxRetentionDays = 42;
    o.onSourceDiskDelete = 'foo';
  }
  buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy--;
  return o;
}

void checkResourcePolicySnapshotSchedulePolicyRetentionPolicy(
    api.ResourcePolicySnapshotSchedulePolicyRetentionPolicy o) {
  buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy++;
  if (buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy < 3) {
    unittest.expect(
      o.maxRetentionDays!,
      unittest.equals(42),
    );
    unittest.expect(
      o.onSourceDiskDelete!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicySnapshotSchedulePolicyRetentionPolicy--;
}

core.int buildCounterResourcePolicySnapshotSchedulePolicySchedule = 0;
api.ResourcePolicySnapshotSchedulePolicySchedule
    buildResourcePolicySnapshotSchedulePolicySchedule() {
  final o = api.ResourcePolicySnapshotSchedulePolicySchedule();
  buildCounterResourcePolicySnapshotSchedulePolicySchedule++;
  if (buildCounterResourcePolicySnapshotSchedulePolicySchedule < 3) {
    o.dailySchedule = buildResourcePolicyDailyCycle();
    o.hourlySchedule = buildResourcePolicyHourlyCycle();
    o.weeklySchedule = buildResourcePolicyWeeklyCycle();
  }
  buildCounterResourcePolicySnapshotSchedulePolicySchedule--;
  return o;
}

void checkResourcePolicySnapshotSchedulePolicySchedule(
    api.ResourcePolicySnapshotSchedulePolicySchedule o) {
  buildCounterResourcePolicySnapshotSchedulePolicySchedule++;
  if (buildCounterResourcePolicySnapshotSchedulePolicySchedule < 3) {
    checkResourcePolicyDailyCycle(o.dailySchedule!);
    checkResourcePolicyHourlyCycle(o.hourlySchedule!);
    checkResourcePolicyWeeklyCycle(o.weeklySchedule!);
  }
  buildCounterResourcePolicySnapshotSchedulePolicySchedule--;
}

core.Map<core.String, core.String> buildUnnamed532() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed532(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed533() => [
      'foo',
      'foo',
    ];

void checkUnnamed533(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties = 0;
api.ResourcePolicySnapshotSchedulePolicySnapshotProperties
    buildResourcePolicySnapshotSchedulePolicySnapshotProperties() {
  final o = api.ResourcePolicySnapshotSchedulePolicySnapshotProperties();
  buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties++;
  if (buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties < 3) {
    o.chainName = 'foo';
    o.guestFlush = true;
    o.labels = buildUnnamed532();
    o.storageLocations = buildUnnamed533();
  }
  buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties--;
  return o;
}

void checkResourcePolicySnapshotSchedulePolicySnapshotProperties(
    api.ResourcePolicySnapshotSchedulePolicySnapshotProperties o) {
  buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties++;
  if (buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties < 3) {
    unittest.expect(
      o.chainName!,
      unittest.equals('foo'),
    );
    unittest.expect(o.guestFlush!, unittest.isTrue);
    checkUnnamed532(o.labels!);
    checkUnnamed533(o.storageLocations!);
  }
  buildCounterResourcePolicySnapshotSchedulePolicySnapshotProperties--;
}

core.List<api.ResourcePolicyWeeklyCycleDayOfWeek> buildUnnamed534() => [
      buildResourcePolicyWeeklyCycleDayOfWeek(),
      buildResourcePolicyWeeklyCycleDayOfWeek(),
    ];

void checkUnnamed534(core.List<api.ResourcePolicyWeeklyCycleDayOfWeek> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkResourcePolicyWeeklyCycleDayOfWeek(o[0]);
  checkResourcePolicyWeeklyCycleDayOfWeek(o[1]);
}

core.int buildCounterResourcePolicyWeeklyCycle = 0;
api.ResourcePolicyWeeklyCycle buildResourcePolicyWeeklyCycle() {
  final o = api.ResourcePolicyWeeklyCycle();
  buildCounterResourcePolicyWeeklyCycle++;
  if (buildCounterResourcePolicyWeeklyCycle < 3) {
    o.dayOfWeeks = buildUnnamed534();
  }
  buildCounterResourcePolicyWeeklyCycle--;
  return o;
}

void checkResourcePolicyWeeklyCycle(api.ResourcePolicyWeeklyCycle o) {
  buildCounterResourcePolicyWeeklyCycle++;
  if (buildCounterResourcePolicyWeeklyCycle < 3) {
    checkUnnamed534(o.dayOfWeeks!);
  }
  buildCounterResourcePolicyWeeklyCycle--;
}

core.int buildCounterResourcePolicyWeeklyCycleDayOfWeek = 0;
api.ResourcePolicyWeeklyCycleDayOfWeek
    buildResourcePolicyWeeklyCycleDayOfWeek() {
  final o = api.ResourcePolicyWeeklyCycleDayOfWeek();
  buildCounterResourcePolicyWeeklyCycleDayOfWeek++;
  if (buildCounterResourcePolicyWeeklyCycleDayOfWeek < 3) {
    o.day = 'foo';
    o.duration = 'foo';
    o.startTime = 'foo';
  }
  buildCounterResourcePolicyWeeklyCycleDayOfWeek--;
  return o;
}

void checkResourcePolicyWeeklyCycleDayOfWeek(
    api.ResourcePolicyWeeklyCycleDayOfWeek o) {
  buildCounterResourcePolicyWeeklyCycleDayOfWeek++;
  if (buildCounterResourcePolicyWeeklyCycleDayOfWeek < 3) {
    unittest.expect(
      o.day!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.duration!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.startTime!,
      unittest.equals('foo'),
    );
  }
  buildCounterResourcePolicyWeeklyCycleDayOfWeek--;
}

core.int buildCounterResourceStatus = 0;
api.ResourceStatus buildResourceStatus() {
  final o = api.ResourceStatus();
  buildCounterResourceStatus++;
  if (buildCounterResourceStatus < 3) {
    o.physicalHost = 'foo';
    o.upcomingMaintenance = buildUpcomingMaintenance();
  }
  buildCounterResourceStatus--;
  return o;
}

void checkResourceStatus(api.ResourceStatus o) {
  buildCounterResourceStatus++;
  if (buildCounterResourceStatus < 3) {
    unittest.expect(
      o.physicalHost!,
      unittest.equals('foo'),
    );
    checkUpcomingMaintenance(o.upcomingMaintenance!);
  }
  buildCounterResourceStatus--;
}

core.List<api.RouteAsPath> buildUnnamed535() => [
      buildRouteAsPath(),
      buildRouteAsPath(),
    ];

void checkUnnamed535(core.List<api.RouteAsPath> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouteAsPath(o[0]);
  checkRouteAsPath(o[1]);
}

core.List<core.String> buildUnnamed536() => [
      'foo',
      'foo',
    ];

void checkUnnamed536(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRouteWarningsData = 0;
api.RouteWarningsData buildRouteWarningsData() {
  final o = api.RouteWarningsData();
  buildCounterRouteWarningsData++;
  if (buildCounterRouteWarningsData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRouteWarningsData--;
  return o;
}

void checkRouteWarningsData(api.RouteWarningsData o) {
  buildCounterRouteWarningsData++;
  if (buildCounterRouteWarningsData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouteWarningsData--;
}

core.List<api.RouteWarningsData> buildUnnamed537() => [
      buildRouteWarningsData(),
      buildRouteWarningsData(),
    ];

void checkUnnamed537(core.List<api.RouteWarningsData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouteWarningsData(o[0]);
  checkRouteWarningsData(o[1]);
}

core.int buildCounterRouteWarnings = 0;
api.RouteWarnings buildRouteWarnings() {
  final o = api.RouteWarnings();
  buildCounterRouteWarnings++;
  if (buildCounterRouteWarnings < 3) {
    o.code = 'foo';
    o.data = buildUnnamed537();
    o.message = 'foo';
  }
  buildCounterRouteWarnings--;
  return o;
}

void checkRouteWarnings(api.RouteWarnings o) {
  buildCounterRouteWarnings++;
  if (buildCounterRouteWarnings < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed537(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouteWarnings--;
}

core.List<api.RouteWarnings> buildUnnamed538() => [
      buildRouteWarnings(),
      buildRouteWarnings(),
    ];

void checkUnnamed538(core.List<api.RouteWarnings> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouteWarnings(o[0]);
  checkRouteWarnings(o[1]);
}

core.int buildCounterRoute = 0;
api.Route buildRoute() {
  final o = api.Route();
  buildCounterRoute++;
  if (buildCounterRoute < 3) {
    o.asPaths = buildUnnamed535();
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.destRange = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.network = 'foo';
    o.nextHopGateway = 'foo';
    o.nextHopHub = 'foo';
    o.nextHopIlb = 'foo';
    o.nextHopInstance = 'foo';
    o.nextHopIp = 'foo';
    o.nextHopNetwork = 'foo';
    o.nextHopPeering = 'foo';
    o.nextHopVpnTunnel = 'foo';
    o.priority = 42;
    o.routeStatus = 'foo';
    o.routeType = 'foo';
    o.selfLink = 'foo';
    o.tags = buildUnnamed536();
    o.warnings = buildUnnamed538();
  }
  buildCounterRoute--;
  return o;
}

void checkRoute(api.Route o) {
  buildCounterRoute++;
  if (buildCounterRoute < 3) {
    checkUnnamed535(o.asPaths!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.destRange!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextHopGateway!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextHopHub!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextHopIlb!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextHopInstance!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextHopIp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextHopNetwork!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextHopPeering!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextHopVpnTunnel!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.priority!,
      unittest.equals(42),
    );
    unittest.expect(
      o.routeStatus!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.routeType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed536(o.tags!);
    checkUnnamed538(o.warnings!);
  }
  buildCounterRoute--;
}

core.List<core.int> buildUnnamed539() => [
      42,
      42,
    ];

void checkUnnamed539(core.List<core.int> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals(42),
  );
  unittest.expect(
    o[1],
    unittest.equals(42),
  );
}

core.int buildCounterRouteAsPath = 0;
api.RouteAsPath buildRouteAsPath() {
  final o = api.RouteAsPath();
  buildCounterRouteAsPath++;
  if (buildCounterRouteAsPath < 3) {
    o.asLists = buildUnnamed539();
    o.pathSegmentType = 'foo';
  }
  buildCounterRouteAsPath--;
  return o;
}

void checkRouteAsPath(api.RouteAsPath o) {
  buildCounterRouteAsPath++;
  if (buildCounterRouteAsPath < 3) {
    checkUnnamed539(o.asLists!);
    unittest.expect(
      o.pathSegmentType!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouteAsPath--;
}

core.List<api.Route> buildUnnamed540() => [
      buildRoute(),
      buildRoute(),
    ];

void checkUnnamed540(core.List<api.Route> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoute(o[0]);
  checkRoute(o[1]);
}

core.int buildCounterRouteListWarningData = 0;
api.RouteListWarningData buildRouteListWarningData() {
  final o = api.RouteListWarningData();
  buildCounterRouteListWarningData++;
  if (buildCounterRouteListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRouteListWarningData--;
  return o;
}

void checkRouteListWarningData(api.RouteListWarningData o) {
  buildCounterRouteListWarningData++;
  if (buildCounterRouteListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouteListWarningData--;
}

core.List<api.RouteListWarningData> buildUnnamed541() => [
      buildRouteListWarningData(),
      buildRouteListWarningData(),
    ];

void checkUnnamed541(core.List<api.RouteListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouteListWarningData(o[0]);
  checkRouteListWarningData(o[1]);
}

core.int buildCounterRouteListWarning = 0;
api.RouteListWarning buildRouteListWarning() {
  final o = api.RouteListWarning();
  buildCounterRouteListWarning++;
  if (buildCounterRouteListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed541();
    o.message = 'foo';
  }
  buildCounterRouteListWarning--;
  return o;
}

void checkRouteListWarning(api.RouteListWarning o) {
  buildCounterRouteListWarning++;
  if (buildCounterRouteListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed541(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouteListWarning--;
}

core.int buildCounterRouteList = 0;
api.RouteList buildRouteList() {
  final o = api.RouteList();
  buildCounterRouteList++;
  if (buildCounterRouteList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed540();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildRouteListWarning();
  }
  buildCounterRouteList--;
  return o;
}

void checkRouteList(api.RouteList o) {
  buildCounterRouteList++;
  if (buildCounterRouteList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed540(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkRouteListWarning(o.warning!);
  }
  buildCounterRouteList--;
}

core.List<api.RouterBgpPeer> buildUnnamed542() => [
      buildRouterBgpPeer(),
      buildRouterBgpPeer(),
    ];

void checkUnnamed542(core.List<api.RouterBgpPeer> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterBgpPeer(o[0]);
  checkRouterBgpPeer(o[1]);
}

core.List<api.RouterInterface> buildUnnamed543() => [
      buildRouterInterface(),
      buildRouterInterface(),
    ];

void checkUnnamed543(core.List<api.RouterInterface> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterInterface(o[0]);
  checkRouterInterface(o[1]);
}

core.List<api.RouterMd5AuthenticationKey> buildUnnamed544() => [
      buildRouterMd5AuthenticationKey(),
      buildRouterMd5AuthenticationKey(),
    ];

void checkUnnamed544(core.List<api.RouterMd5AuthenticationKey> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterMd5AuthenticationKey(o[0]);
  checkRouterMd5AuthenticationKey(o[1]);
}

core.List<api.RouterNat> buildUnnamed545() => [
      buildRouterNat(),
      buildRouterNat(),
    ];

void checkUnnamed545(core.List<api.RouterNat> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterNat(o[0]);
  checkRouterNat(o[1]);
}

core.int buildCounterRouter = 0;
api.Router buildRouter() {
  final o = api.Router();
  buildCounterRouter++;
  if (buildCounterRouter < 3) {
    o.bgp = buildRouterBgp();
    o.bgpPeers = buildUnnamed542();
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.encryptedInterconnectRouter = true;
    o.id = 'foo';
    o.interfaces = buildUnnamed543();
    o.kind = 'foo';
    o.md5AuthenticationKeys = buildUnnamed544();
    o.name = 'foo';
    o.nats = buildUnnamed545();
    o.network = 'foo';
    o.region = 'foo';
    o.selfLink = 'foo';
  }
  buildCounterRouter--;
  return o;
}

void checkRouter(api.Router o) {
  buildCounterRouter++;
  if (buildCounterRouter < 3) {
    checkRouterBgp(o.bgp!);
    checkUnnamed542(o.bgpPeers!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(o.encryptedInterconnectRouter!, unittest.isTrue);
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed543(o.interfaces!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkUnnamed544(o.md5AuthenticationKeys!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed545(o.nats!);
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouter--;
}

core.int buildCounterRouterAdvertisedIpRange = 0;
api.RouterAdvertisedIpRange buildRouterAdvertisedIpRange() {
  final o = api.RouterAdvertisedIpRange();
  buildCounterRouterAdvertisedIpRange++;
  if (buildCounterRouterAdvertisedIpRange < 3) {
    o.description = 'foo';
    o.range = 'foo';
  }
  buildCounterRouterAdvertisedIpRange--;
  return o;
}

void checkRouterAdvertisedIpRange(api.RouterAdvertisedIpRange o) {
  buildCounterRouterAdvertisedIpRange++;
  if (buildCounterRouterAdvertisedIpRange < 3) {
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.range!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterAdvertisedIpRange--;
}

core.Map<core.String, api.RoutersScopedList> buildUnnamed546() => {
      'x': buildRoutersScopedList(),
      'y': buildRoutersScopedList(),
    };

void checkUnnamed546(core.Map<core.String, api.RoutersScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoutersScopedList(o['x']!);
  checkRoutersScopedList(o['y']!);
}

core.List<core.String> buildUnnamed547() => [
      'foo',
      'foo',
    ];

void checkUnnamed547(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRouterAggregatedListWarningData = 0;
api.RouterAggregatedListWarningData buildRouterAggregatedListWarningData() {
  final o = api.RouterAggregatedListWarningData();
  buildCounterRouterAggregatedListWarningData++;
  if (buildCounterRouterAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRouterAggregatedListWarningData--;
  return o;
}

void checkRouterAggregatedListWarningData(
    api.RouterAggregatedListWarningData o) {
  buildCounterRouterAggregatedListWarningData++;
  if (buildCounterRouterAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterAggregatedListWarningData--;
}

core.List<api.RouterAggregatedListWarningData> buildUnnamed548() => [
      buildRouterAggregatedListWarningData(),
      buildRouterAggregatedListWarningData(),
    ];

void checkUnnamed548(core.List<api.RouterAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterAggregatedListWarningData(o[0]);
  checkRouterAggregatedListWarningData(o[1]);
}

core.int buildCounterRouterAggregatedListWarning = 0;
api.RouterAggregatedListWarning buildRouterAggregatedListWarning() {
  final o = api.RouterAggregatedListWarning();
  buildCounterRouterAggregatedListWarning++;
  if (buildCounterRouterAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed548();
    o.message = 'foo';
  }
  buildCounterRouterAggregatedListWarning--;
  return o;
}

void checkRouterAggregatedListWarning(api.RouterAggregatedListWarning o) {
  buildCounterRouterAggregatedListWarning++;
  if (buildCounterRouterAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed548(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterAggregatedListWarning--;
}

core.int buildCounterRouterAggregatedList = 0;
api.RouterAggregatedList buildRouterAggregatedList() {
  final o = api.RouterAggregatedList();
  buildCounterRouterAggregatedList++;
  if (buildCounterRouterAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed546();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed547();
    o.warning = buildRouterAggregatedListWarning();
  }
  buildCounterRouterAggregatedList--;
  return o;
}

void checkRouterAggregatedList(api.RouterAggregatedList o) {
  buildCounterRouterAggregatedList++;
  if (buildCounterRouterAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed546(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed547(o.unreachables!);
    checkRouterAggregatedListWarning(o.warning!);
  }
  buildCounterRouterAggregatedList--;
}

core.List<core.String> buildUnnamed549() => [
      'foo',
      'foo',
    ];

void checkUnnamed549(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.RouterAdvertisedIpRange> buildUnnamed550() => [
      buildRouterAdvertisedIpRange(),
      buildRouterAdvertisedIpRange(),
    ];

void checkUnnamed550(core.List<api.RouterAdvertisedIpRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterAdvertisedIpRange(o[0]);
  checkRouterAdvertisedIpRange(o[1]);
}

core.int buildCounterRouterBgp = 0;
api.RouterBgp buildRouterBgp() {
  final o = api.RouterBgp();
  buildCounterRouterBgp++;
  if (buildCounterRouterBgp < 3) {
    o.advertiseMode = 'foo';
    o.advertisedGroups = buildUnnamed549();
    o.advertisedIpRanges = buildUnnamed550();
    o.asn = 42;
    o.keepaliveInterval = 42;
  }
  buildCounterRouterBgp--;
  return o;
}

void checkRouterBgp(api.RouterBgp o) {
  buildCounterRouterBgp++;
  if (buildCounterRouterBgp < 3) {
    unittest.expect(
      o.advertiseMode!,
      unittest.equals('foo'),
    );
    checkUnnamed549(o.advertisedGroups!);
    checkUnnamed550(o.advertisedIpRanges!);
    unittest.expect(
      o.asn!,
      unittest.equals(42),
    );
    unittest.expect(
      o.keepaliveInterval!,
      unittest.equals(42),
    );
  }
  buildCounterRouterBgp--;
}

core.List<core.String> buildUnnamed551() => [
      'foo',
      'foo',
    ];

void checkUnnamed551(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.RouterAdvertisedIpRange> buildUnnamed552() => [
      buildRouterAdvertisedIpRange(),
      buildRouterAdvertisedIpRange(),
    ];

void checkUnnamed552(core.List<api.RouterAdvertisedIpRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterAdvertisedIpRange(o[0]);
  checkRouterAdvertisedIpRange(o[1]);
}

core.List<api.RouterBgpPeerCustomLearnedIpRange> buildUnnamed553() => [
      buildRouterBgpPeerCustomLearnedIpRange(),
      buildRouterBgpPeerCustomLearnedIpRange(),
    ];

void checkUnnamed553(core.List<api.RouterBgpPeerCustomLearnedIpRange> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterBgpPeerCustomLearnedIpRange(o[0]);
  checkRouterBgpPeerCustomLearnedIpRange(o[1]);
}

core.int buildCounterRouterBgpPeer = 0;
api.RouterBgpPeer buildRouterBgpPeer() {
  final o = api.RouterBgpPeer();
  buildCounterRouterBgpPeer++;
  if (buildCounterRouterBgpPeer < 3) {
    o.advertiseMode = 'foo';
    o.advertisedGroups = buildUnnamed551();
    o.advertisedIpRanges = buildUnnamed552();
    o.advertisedRoutePriority = 42;
    o.bfd = buildRouterBgpPeerBfd();
    o.customLearnedIpRanges = buildUnnamed553();
    o.customLearnedRoutePriority = 42;
    o.enable = 'foo';
    o.enableIpv6 = true;
    o.interfaceName = 'foo';
    o.ipAddress = 'foo';
    o.ipv6NexthopAddress = 'foo';
    o.managementType = 'foo';
    o.md5AuthenticationKeyName = 'foo';
    o.name = 'foo';
    o.peerAsn = 42;
    o.peerIpAddress = 'foo';
    o.peerIpv6NexthopAddress = 'foo';
    o.routerApplianceInstance = 'foo';
  }
  buildCounterRouterBgpPeer--;
  return o;
}

void checkRouterBgpPeer(api.RouterBgpPeer o) {
  buildCounterRouterBgpPeer++;
  if (buildCounterRouterBgpPeer < 3) {
    unittest.expect(
      o.advertiseMode!,
      unittest.equals('foo'),
    );
    checkUnnamed551(o.advertisedGroups!);
    checkUnnamed552(o.advertisedIpRanges!);
    unittest.expect(
      o.advertisedRoutePriority!,
      unittest.equals(42),
    );
    checkRouterBgpPeerBfd(o.bfd!);
    checkUnnamed553(o.customLearnedIpRanges!);
    unittest.expect(
      o.customLearnedRoutePriority!,
      unittest.equals(42),
    );
    unittest.expect(
      o.enable!,
      unittest.equals('foo'),
    );
    unittest.expect(o.enableIpv6!, unittest.isTrue);
    unittest.expect(
      o.interfaceName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipv6NexthopAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.managementType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.md5AuthenticationKeyName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.peerAsn!,
      unittest.equals(42),
    );
    unittest.expect(
      o.peerIpAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.peerIpv6NexthopAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.routerApplianceInstance!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterBgpPeer--;
}

core.int buildCounterRouterBgpPeerBfd = 0;
api.RouterBgpPeerBfd buildRouterBgpPeerBfd() {
  final o = api.RouterBgpPeerBfd();
  buildCounterRouterBgpPeerBfd++;
  if (buildCounterRouterBgpPeerBfd < 3) {
    o.minReceiveInterval = 42;
    o.minTransmitInterval = 42;
    o.multiplier = 42;
    o.sessionInitializationMode = 'foo';
  }
  buildCounterRouterBgpPeerBfd--;
  return o;
}

void checkRouterBgpPeerBfd(api.RouterBgpPeerBfd o) {
  buildCounterRouterBgpPeerBfd++;
  if (buildCounterRouterBgpPeerBfd < 3) {
    unittest.expect(
      o.minReceiveInterval!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minTransmitInterval!,
      unittest.equals(42),
    );
    unittest.expect(
      o.multiplier!,
      unittest.equals(42),
    );
    unittest.expect(
      o.sessionInitializationMode!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterBgpPeerBfd--;
}

core.int buildCounterRouterBgpPeerCustomLearnedIpRange = 0;
api.RouterBgpPeerCustomLearnedIpRange buildRouterBgpPeerCustomLearnedIpRange() {
  final o = api.RouterBgpPeerCustomLearnedIpRange();
  buildCounterRouterBgpPeerCustomLearnedIpRange++;
  if (buildCounterRouterBgpPeerCustomLearnedIpRange < 3) {
    o.range = 'foo';
  }
  buildCounterRouterBgpPeerCustomLearnedIpRange--;
  return o;
}

void checkRouterBgpPeerCustomLearnedIpRange(
    api.RouterBgpPeerCustomLearnedIpRange o) {
  buildCounterRouterBgpPeerCustomLearnedIpRange++;
  if (buildCounterRouterBgpPeerCustomLearnedIpRange < 3) {
    unittest.expect(
      o.range!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterBgpPeerCustomLearnedIpRange--;
}

core.int buildCounterRouterInterface = 0;
api.RouterInterface buildRouterInterface() {
  final o = api.RouterInterface();
  buildCounterRouterInterface++;
  if (buildCounterRouterInterface < 3) {
    o.ipRange = 'foo';
    o.linkedInterconnectAttachment = 'foo';
    o.linkedVpnTunnel = 'foo';
    o.managementType = 'foo';
    o.name = 'foo';
    o.privateIpAddress = 'foo';
    o.redundantInterface = 'foo';
    o.subnetwork = 'foo';
  }
  buildCounterRouterInterface--;
  return o;
}

void checkRouterInterface(api.RouterInterface o) {
  buildCounterRouterInterface++;
  if (buildCounterRouterInterface < 3) {
    unittest.expect(
      o.ipRange!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.linkedInterconnectAttachment!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.linkedVpnTunnel!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.managementType!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.privateIpAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.redundantInterface!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.subnetwork!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterInterface--;
}

core.List<api.Router> buildUnnamed554() => [
      buildRouter(),
      buildRouter(),
    ];

void checkUnnamed554(core.List<api.Router> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouter(o[0]);
  checkRouter(o[1]);
}

core.int buildCounterRouterListWarningData = 0;
api.RouterListWarningData buildRouterListWarningData() {
  final o = api.RouterListWarningData();
  buildCounterRouterListWarningData++;
  if (buildCounterRouterListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRouterListWarningData--;
  return o;
}

void checkRouterListWarningData(api.RouterListWarningData o) {
  buildCounterRouterListWarningData++;
  if (buildCounterRouterListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterListWarningData--;
}

core.List<api.RouterListWarningData> buildUnnamed555() => [
      buildRouterListWarningData(),
      buildRouterListWarningData(),
    ];

void checkUnnamed555(core.List<api.RouterListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterListWarningData(o[0]);
  checkRouterListWarningData(o[1]);
}

core.int buildCounterRouterListWarning = 0;
api.RouterListWarning buildRouterListWarning() {
  final o = api.RouterListWarning();
  buildCounterRouterListWarning++;
  if (buildCounterRouterListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed555();
    o.message = 'foo';
  }
  buildCounterRouterListWarning--;
  return o;
}

void checkRouterListWarning(api.RouterListWarning o) {
  buildCounterRouterListWarning++;
  if (buildCounterRouterListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed555(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterListWarning--;
}

core.int buildCounterRouterList = 0;
api.RouterList buildRouterList() {
  final o = api.RouterList();
  buildCounterRouterList++;
  if (buildCounterRouterList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed554();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildRouterListWarning();
  }
  buildCounterRouterList--;
  return o;
}

void checkRouterList(api.RouterList o) {
  buildCounterRouterList++;
  if (buildCounterRouterList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed554(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkRouterListWarning(o.warning!);
  }
  buildCounterRouterList--;
}

core.int buildCounterRouterMd5AuthenticationKey = 0;
api.RouterMd5AuthenticationKey buildRouterMd5AuthenticationKey() {
  final o = api.RouterMd5AuthenticationKey();
  buildCounterRouterMd5AuthenticationKey++;
  if (buildCounterRouterMd5AuthenticationKey < 3) {
    o.key = 'foo';
    o.name = 'foo';
  }
  buildCounterRouterMd5AuthenticationKey--;
  return o;
}

void checkRouterMd5AuthenticationKey(api.RouterMd5AuthenticationKey o) {
  buildCounterRouterMd5AuthenticationKey++;
  if (buildCounterRouterMd5AuthenticationKey < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterMd5AuthenticationKey--;
}

core.List<core.String> buildUnnamed556() => [
      'foo',
      'foo',
    ];

void checkUnnamed556(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed557() => [
      'foo',
      'foo',
    ];

void checkUnnamed557(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed558() => [
      'foo',
      'foo',
    ];

void checkUnnamed558(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.RouterNatRule> buildUnnamed559() => [
      buildRouterNatRule(),
      buildRouterNatRule(),
    ];

void checkUnnamed559(core.List<api.RouterNatRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterNatRule(o[0]);
  checkRouterNatRule(o[1]);
}

core.List<api.RouterNatSubnetworkToNat> buildUnnamed560() => [
      buildRouterNatSubnetworkToNat(),
      buildRouterNatSubnetworkToNat(),
    ];

void checkUnnamed560(core.List<api.RouterNatSubnetworkToNat> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterNatSubnetworkToNat(o[0]);
  checkRouterNatSubnetworkToNat(o[1]);
}

core.int buildCounterRouterNat = 0;
api.RouterNat buildRouterNat() {
  final o = api.RouterNat();
  buildCounterRouterNat++;
  if (buildCounterRouterNat < 3) {
    o.autoNetworkTier = 'foo';
    o.drainNatIps = buildUnnamed556();
    o.enableDynamicPortAllocation = true;
    o.enableEndpointIndependentMapping = true;
    o.endpointTypes = buildUnnamed557();
    o.icmpIdleTimeoutSec = 42;
    o.logConfig = buildRouterNatLogConfig();
    o.maxPortsPerVm = 42;
    o.minPortsPerVm = 42;
    o.name = 'foo';
    o.natIpAllocateOption = 'foo';
    o.natIps = buildUnnamed558();
    o.rules = buildUnnamed559();
    o.sourceSubnetworkIpRangesToNat = 'foo';
    o.subnetworks = buildUnnamed560();
    o.tcpEstablishedIdleTimeoutSec = 42;
    o.tcpTimeWaitTimeoutSec = 42;
    o.tcpTransitoryIdleTimeoutSec = 42;
    o.type = 'foo';
    o.udpIdleTimeoutSec = 42;
  }
  buildCounterRouterNat--;
  return o;
}

void checkRouterNat(api.RouterNat o) {
  buildCounterRouterNat++;
  if (buildCounterRouterNat < 3) {
    unittest.expect(
      o.autoNetworkTier!,
      unittest.equals('foo'),
    );
    checkUnnamed556(o.drainNatIps!);
    unittest.expect(o.enableDynamicPortAllocation!, unittest.isTrue);
    unittest.expect(o.enableEndpointIndependentMapping!, unittest.isTrue);
    checkUnnamed557(o.endpointTypes!);
    unittest.expect(
      o.icmpIdleTimeoutSec!,
      unittest.equals(42),
    );
    checkRouterNatLogConfig(o.logConfig!);
    unittest.expect(
      o.maxPortsPerVm!,
      unittest.equals(42),
    );
    unittest.expect(
      o.minPortsPerVm!,
      unittest.equals(42),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.natIpAllocateOption!,
      unittest.equals('foo'),
    );
    checkUnnamed558(o.natIps!);
    checkUnnamed559(o.rules!);
    unittest.expect(
      o.sourceSubnetworkIpRangesToNat!,
      unittest.equals('foo'),
    );
    checkUnnamed560(o.subnetworks!);
    unittest.expect(
      o.tcpEstablishedIdleTimeoutSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.tcpTimeWaitTimeoutSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.tcpTransitoryIdleTimeoutSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.udpIdleTimeoutSec!,
      unittest.equals(42),
    );
  }
  buildCounterRouterNat--;
}

core.int buildCounterRouterNatLogConfig = 0;
api.RouterNatLogConfig buildRouterNatLogConfig() {
  final o = api.RouterNatLogConfig();
  buildCounterRouterNatLogConfig++;
  if (buildCounterRouterNatLogConfig < 3) {
    o.enable = true;
    o.filter = 'foo';
  }
  buildCounterRouterNatLogConfig--;
  return o;
}

void checkRouterNatLogConfig(api.RouterNatLogConfig o) {
  buildCounterRouterNatLogConfig++;
  if (buildCounterRouterNatLogConfig < 3) {
    unittest.expect(o.enable!, unittest.isTrue);
    unittest.expect(
      o.filter!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterNatLogConfig--;
}

core.int buildCounterRouterNatRule = 0;
api.RouterNatRule buildRouterNatRule() {
  final o = api.RouterNatRule();
  buildCounterRouterNatRule++;
  if (buildCounterRouterNatRule < 3) {
    o.action = buildRouterNatRuleAction();
    o.description = 'foo';
    o.match = 'foo';
    o.ruleNumber = 42;
  }
  buildCounterRouterNatRule--;
  return o;
}

void checkRouterNatRule(api.RouterNatRule o) {
  buildCounterRouterNatRule++;
  if (buildCounterRouterNatRule < 3) {
    checkRouterNatRuleAction(o.action!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.match!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ruleNumber!,
      unittest.equals(42),
    );
  }
  buildCounterRouterNatRule--;
}

core.List<core.String> buildUnnamed561() => [
      'foo',
      'foo',
    ];

void checkUnnamed561(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed562() => [
      'foo',
      'foo',
    ];

void checkUnnamed562(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed563() => [
      'foo',
      'foo',
    ];

void checkUnnamed563(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed564() => [
      'foo',
      'foo',
    ];

void checkUnnamed564(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRouterNatRuleAction = 0;
api.RouterNatRuleAction buildRouterNatRuleAction() {
  final o = api.RouterNatRuleAction();
  buildCounterRouterNatRuleAction++;
  if (buildCounterRouterNatRuleAction < 3) {
    o.sourceNatActiveIps = buildUnnamed561();
    o.sourceNatActiveRanges = buildUnnamed562();
    o.sourceNatDrainIps = buildUnnamed563();
    o.sourceNatDrainRanges = buildUnnamed564();
  }
  buildCounterRouterNatRuleAction--;
  return o;
}

void checkRouterNatRuleAction(api.RouterNatRuleAction o) {
  buildCounterRouterNatRuleAction++;
  if (buildCounterRouterNatRuleAction < 3) {
    checkUnnamed561(o.sourceNatActiveIps!);
    checkUnnamed562(o.sourceNatActiveRanges!);
    checkUnnamed563(o.sourceNatDrainIps!);
    checkUnnamed564(o.sourceNatDrainRanges!);
  }
  buildCounterRouterNatRuleAction--;
}

core.List<core.String> buildUnnamed565() => [
      'foo',
      'foo',
    ];

void checkUnnamed565(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed566() => [
      'foo',
      'foo',
    ];

void checkUnnamed566(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRouterNatSubnetworkToNat = 0;
api.RouterNatSubnetworkToNat buildRouterNatSubnetworkToNat() {
  final o = api.RouterNatSubnetworkToNat();
  buildCounterRouterNatSubnetworkToNat++;
  if (buildCounterRouterNatSubnetworkToNat < 3) {
    o.name = 'foo';
    o.secondaryIpRangeNames = buildUnnamed565();
    o.sourceIpRangesToNat = buildUnnamed566();
  }
  buildCounterRouterNatSubnetworkToNat--;
  return o;
}

void checkRouterNatSubnetworkToNat(api.RouterNatSubnetworkToNat o) {
  buildCounterRouterNatSubnetworkToNat++;
  if (buildCounterRouterNatSubnetworkToNat < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed565(o.secondaryIpRangeNames!);
    checkUnnamed566(o.sourceIpRangesToNat!);
  }
  buildCounterRouterNatSubnetworkToNat--;
}

core.List<api.Route> buildUnnamed567() => [
      buildRoute(),
      buildRoute(),
    ];

void checkUnnamed567(core.List<api.Route> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoute(o[0]);
  checkRoute(o[1]);
}

core.List<api.Route> buildUnnamed568() => [
      buildRoute(),
      buildRoute(),
    ];

void checkUnnamed568(core.List<api.Route> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoute(o[0]);
  checkRoute(o[1]);
}

core.List<api.RouterStatusBgpPeerStatus> buildUnnamed569() => [
      buildRouterStatusBgpPeerStatus(),
      buildRouterStatusBgpPeerStatus(),
    ];

void checkUnnamed569(core.List<api.RouterStatusBgpPeerStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterStatusBgpPeerStatus(o[0]);
  checkRouterStatusBgpPeerStatus(o[1]);
}

core.List<api.RouterStatusNatStatus> buildUnnamed570() => [
      buildRouterStatusNatStatus(),
      buildRouterStatusNatStatus(),
    ];

void checkUnnamed570(core.List<api.RouterStatusNatStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterStatusNatStatus(o[0]);
  checkRouterStatusNatStatus(o[1]);
}

core.int buildCounterRouterStatus = 0;
api.RouterStatus buildRouterStatus() {
  final o = api.RouterStatus();
  buildCounterRouterStatus++;
  if (buildCounterRouterStatus < 3) {
    o.bestRoutes = buildUnnamed567();
    o.bestRoutesForRouter = buildUnnamed568();
    o.bgpPeerStatus = buildUnnamed569();
    o.natStatus = buildUnnamed570();
    o.network = 'foo';
  }
  buildCounterRouterStatus--;
  return o;
}

void checkRouterStatus(api.RouterStatus o) {
  buildCounterRouterStatus++;
  if (buildCounterRouterStatus < 3) {
    checkUnnamed567(o.bestRoutes!);
    checkUnnamed568(o.bestRoutesForRouter!);
    checkUnnamed569(o.bgpPeerStatus!);
    checkUnnamed570(o.natStatus!);
    unittest.expect(
      o.network!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterStatus--;
}

core.List<api.Route> buildUnnamed571() => [
      buildRoute(),
      buildRoute(),
    ];

void checkUnnamed571(core.List<api.Route> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoute(o[0]);
  checkRoute(o[1]);
}

core.int buildCounterRouterStatusBgpPeerStatus = 0;
api.RouterStatusBgpPeerStatus buildRouterStatusBgpPeerStatus() {
  final o = api.RouterStatusBgpPeerStatus();
  buildCounterRouterStatusBgpPeerStatus++;
  if (buildCounterRouterStatusBgpPeerStatus < 3) {
    o.advertisedRoutes = buildUnnamed571();
    o.bfdStatus = buildBfdStatus();
    o.enableIpv6 = true;
    o.ipAddress = 'foo';
    o.ipv6NexthopAddress = 'foo';
    o.linkedVpnTunnel = 'foo';
    o.md5AuthEnabled = true;
    o.name = 'foo';
    o.numLearnedRoutes = 42;
    o.peerIpAddress = 'foo';
    o.peerIpv6NexthopAddress = 'foo';
    o.routerApplianceInstance = 'foo';
    o.state = 'foo';
    o.status = 'foo';
    o.statusReason = 'foo';
    o.uptime = 'foo';
    o.uptimeSeconds = 'foo';
  }
  buildCounterRouterStatusBgpPeerStatus--;
  return o;
}

void checkRouterStatusBgpPeerStatus(api.RouterStatusBgpPeerStatus o) {
  buildCounterRouterStatusBgpPeerStatus++;
  if (buildCounterRouterStatusBgpPeerStatus < 3) {
    checkUnnamed571(o.advertisedRoutes!);
    checkBfdStatus(o.bfdStatus!);
    unittest.expect(o.enableIpv6!, unittest.isTrue);
    unittest.expect(
      o.ipAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.ipv6NexthopAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.linkedVpnTunnel!,
      unittest.equals('foo'),
    );
    unittest.expect(o.md5AuthEnabled!, unittest.isTrue);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.numLearnedRoutes!,
      unittest.equals(42),
    );
    unittest.expect(
      o.peerIpAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.peerIpv6NexthopAddress!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.routerApplianceInstance!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.statusReason!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.uptime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.uptimeSeconds!,
      unittest.equals('foo'),
    );
  }
  buildCounterRouterStatusBgpPeerStatus--;
}

core.List<core.String> buildUnnamed572() => [
      'foo',
      'foo',
    ];

void checkUnnamed572(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed573() => [
      'foo',
      'foo',
    ];

void checkUnnamed573(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed574() => [
      'foo',
      'foo',
    ];

void checkUnnamed574(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.RouterStatusNatStatusNatRuleStatus> buildUnnamed575() => [
      buildRouterStatusNatStatusNatRuleStatus(),
      buildRouterStatusNatStatusNatRuleStatus(),
    ];

void checkUnnamed575(core.List<api.RouterStatusNatStatusNatRuleStatus> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouterStatusNatStatusNatRuleStatus(o[0]);
  checkRouterStatusNatStatusNatRuleStatus(o[1]);
}

core.List<core.String> buildUnnamed576() => [
      'foo',
      'foo',
    ];

void checkUnnamed576(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed577() => [
      'foo',
      'foo',
    ];

void checkUnnamed577(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRouterStatusNatStatus = 0;
api.RouterStatusNatStatus buildRouterStatusNatStatus() {
  final o = api.RouterStatusNatStatus();
  buildCounterRouterStatusNatStatus++;
  if (buildCounterRouterStatusNatStatus < 3) {
    o.autoAllocatedNatIps = buildUnnamed572();
    o.drainAutoAllocatedNatIps = buildUnnamed573();
    o.drainUserAllocatedNatIps = buildUnnamed574();
    o.minExtraNatIpsNeeded = 42;
    o.name = 'foo';
    o.numVmEndpointsWithNatMappings = 42;
    o.ruleStatus = buildUnnamed575();
    o.userAllocatedNatIpResources = buildUnnamed576();
    o.userAllocatedNatIps = buildUnnamed577();
  }
  buildCounterRouterStatusNatStatus--;
  return o;
}

void checkRouterStatusNatStatus(api.RouterStatusNatStatus o) {
  buildCounterRouterStatusNatStatus++;
  if (buildCounterRouterStatusNatStatus < 3) {
    checkUnnamed572(o.autoAllocatedNatIps!);
    checkUnnamed573(o.drainAutoAllocatedNatIps!);
    checkUnnamed574(o.drainUserAllocatedNatIps!);
    unittest.expect(
      o.minExtraNatIpsNeeded!,
      unittest.equals(42),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.numVmEndpointsWithNatMappings!,
      unittest.equals(42),
    );
    checkUnnamed575(o.ruleStatus!);
    checkUnnamed576(o.userAllocatedNatIpResources!);
    checkUnnamed577(o.userAllocatedNatIps!);
  }
  buildCounterRouterStatusNatStatus--;
}

core.List<core.String> buildUnnamed578() => [
      'foo',
      'foo',
    ];

void checkUnnamed578(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed579() => [
      'foo',
      'foo',
    ];

void checkUnnamed579(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRouterStatusNatStatusNatRuleStatus = 0;
api.RouterStatusNatStatusNatRuleStatus
    buildRouterStatusNatStatusNatRuleStatus() {
  final o = api.RouterStatusNatStatusNatRuleStatus();
  buildCounterRouterStatusNatStatusNatRuleStatus++;
  if (buildCounterRouterStatusNatStatusNatRuleStatus < 3) {
    o.activeNatIps = buildUnnamed578();
    o.drainNatIps = buildUnnamed579();
    o.minExtraIpsNeeded = 42;
    o.numVmEndpointsWithNatMappings = 42;
    o.ruleNumber = 42;
  }
  buildCounterRouterStatusNatStatusNatRuleStatus--;
  return o;
}

void checkRouterStatusNatStatusNatRuleStatus(
    api.RouterStatusNatStatusNatRuleStatus o) {
  buildCounterRouterStatusNatStatusNatRuleStatus++;
  if (buildCounterRouterStatusNatStatusNatRuleStatus < 3) {
    checkUnnamed578(o.activeNatIps!);
    checkUnnamed579(o.drainNatIps!);
    unittest.expect(
      o.minExtraIpsNeeded!,
      unittest.equals(42),
    );
    unittest.expect(
      o.numVmEndpointsWithNatMappings!,
      unittest.equals(42),
    );
    unittest.expect(
      o.ruleNumber!,
      unittest.equals(42),
    );
  }
  buildCounterRouterStatusNatStatusNatRuleStatus--;
}

core.int buildCounterRouterStatusResponse = 0;
api.RouterStatusResponse buildRouterStatusResponse() {
  final o = api.RouterStatusResponse();
  buildCounterRouterStatusResponse++;
  if (buildCounterRouterStatusResponse < 3) {
    o.kind = 'foo';
    o.result = buildRouterStatus();
  }
  buildCounterRouterStatusResponse--;
  return o;
}

void checkRouterStatusResponse(api.RouterStatusResponse o) {
  buildCounterRouterStatusResponse++;
  if (buildCounterRouterStatusResponse < 3) {
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkRouterStatus(o.result!);
  }
  buildCounterRouterStatusResponse--;
}

core.int buildCounterRoutersPreviewResponse = 0;
api.RoutersPreviewResponse buildRoutersPreviewResponse() {
  final o = api.RoutersPreviewResponse();
  buildCounterRoutersPreviewResponse++;
  if (buildCounterRoutersPreviewResponse < 3) {
    o.resource = buildRouter();
  }
  buildCounterRoutersPreviewResponse--;
  return o;
}

void checkRoutersPreviewResponse(api.RoutersPreviewResponse o) {
  buildCounterRoutersPreviewResponse++;
  if (buildCounterRoutersPreviewResponse < 3) {
    checkRouter(o.resource!);
  }
  buildCounterRoutersPreviewResponse--;
}

core.List<api.Router> buildUnnamed580() => [
      buildRouter(),
      buildRouter(),
    ];

void checkUnnamed580(core.List<api.Router> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRouter(o[0]);
  checkRouter(o[1]);
}

core.int buildCounterRoutersScopedListWarningData = 0;
api.RoutersScopedListWarningData buildRoutersScopedListWarningData() {
  final o = api.RoutersScopedListWarningData();
  buildCounterRoutersScopedListWarningData++;
  if (buildCounterRoutersScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterRoutersScopedListWarningData--;
  return o;
}

void checkRoutersScopedListWarningData(api.RoutersScopedListWarningData o) {
  buildCounterRoutersScopedListWarningData++;
  if (buildCounterRoutersScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterRoutersScopedListWarningData--;
}

core.List<api.RoutersScopedListWarningData> buildUnnamed581() => [
      buildRoutersScopedListWarningData(),
      buildRoutersScopedListWarningData(),
    ];

void checkUnnamed581(core.List<api.RoutersScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkRoutersScopedListWarningData(o[0]);
  checkRoutersScopedListWarningData(o[1]);
}

core.int buildCounterRoutersScopedListWarning = 0;
api.RoutersScopedListWarning buildRoutersScopedListWarning() {
  final o = api.RoutersScopedListWarning();
  buildCounterRoutersScopedListWarning++;
  if (buildCounterRoutersScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed581();
    o.message = 'foo';
  }
  buildCounterRoutersScopedListWarning--;
  return o;
}

void checkRoutersScopedListWarning(api.RoutersScopedListWarning o) {
  buildCounterRoutersScopedListWarning++;
  if (buildCounterRoutersScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed581(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterRoutersScopedListWarning--;
}

core.int buildCounterRoutersScopedList = 0;
api.RoutersScopedList buildRoutersScopedList() {
  final o = api.RoutersScopedList();
  buildCounterRoutersScopedList++;
  if (buildCounterRoutersScopedList < 3) {
    o.routers = buildUnnamed580();
    o.warning = buildRoutersScopedListWarning();
  }
  buildCounterRoutersScopedList--;
  return o;
}

void checkRoutersScopedList(api.RoutersScopedList o) {
  buildCounterRoutersScopedList++;
  if (buildCounterRoutersScopedList < 3) {
    checkUnnamed580(o.routers!);
    checkRoutersScopedListWarning(o.warning!);
  }
  buildCounterRoutersScopedList--;
}

core.List<api.Condition> buildUnnamed582() => [
      buildCondition(),
      buildCondition(),
    ];

void checkUnnamed582(core.List<api.Condition> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkCondition(o[0]);
  checkCondition(o[1]);
}

core.List<core.String> buildUnnamed583() => [
      'foo',
      'foo',
    ];

void checkUnnamed583(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.LogConfig> buildUnnamed584() => [
      buildLogConfig(),
      buildLogConfig(),
    ];

void checkUnnamed584(core.List<api.LogConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkLogConfig(o[0]);
  checkLogConfig(o[1]);
}

core.List<core.String> buildUnnamed585() => [
      'foo',
      'foo',
    ];

void checkUnnamed585(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed586() => [
      'foo',
      'foo',
    ];

void checkUnnamed586(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterRule = 0;
api.Rule buildRule() {
  final o = api.Rule();
  buildCounterRule++;
  if (buildCounterRule < 3) {
    o.action = 'foo';
    o.conditions = buildUnnamed582();
    o.description = 'foo';
    o.ins = buildUnnamed583();
    o.logConfigs = buildUnnamed584();
    o.notIns = buildUnnamed585();
    o.permissions = buildUnnamed586();
  }
  buildCounterRule--;
  return o;
}

void checkRule(api.Rule o) {
  buildCounterRule++;
  if (buildCounterRule < 3) {
    unittest.expect(
      o.action!,
      unittest.equals('foo'),
    );
    checkUnnamed582(o.conditions!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed583(o.ins!);
    checkUnnamed584(o.logConfigs!);
    checkUnnamed585(o.notIns!);
    checkUnnamed586(o.permissions!);
  }
  buildCounterRule--;
}

core.int buildCounterSSLHealthCheck = 0;
api.SSLHealthCheck buildSSLHealthCheck() {
  final o = api.SSLHealthCheck();
  buildCounterSSLHealthCheck++;
  if (buildCounterSSLHealthCheck < 3) {
    o.port = 42;
    o.portName = 'foo';
    o.portSpecification = 'foo';
    o.proxyHeader = 'foo';
    o.request = 'foo';
    o.response = 'foo';
  }
  buildCounterSSLHealthCheck--;
  return o;
}

void checkSSLHealthCheck(api.SSLHealthCheck o) {
  buildCounterSSLHealthCheck++;
  if (buildCounterSSLHealthCheck < 3) {
    unittest.expect(
      o.port!,
      unittest.equals(42),
    );
    unittest.expect(
      o.portName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.portSpecification!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.proxyHeader!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.request!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.response!,
      unittest.equals('foo'),
    );
  }
  buildCounterSSLHealthCheck--;
}

core.List<api.GuestOsFeature> buildUnnamed587() => [
      buildGuestOsFeature(),
      buildGuestOsFeature(),
    ];

void checkUnnamed587(core.List<api.GuestOsFeature> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkGuestOsFeature(o[0]);
  checkGuestOsFeature(o[1]);
}

core.List<core.String> buildUnnamed588() => [
      'foo',
      'foo',
    ];

void checkUnnamed588(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSavedAttachedDisk = 0;
api.SavedAttachedDisk buildSavedAttachedDisk() {
  final o = api.SavedAttachedDisk();
  buildCounterSavedAttachedDisk++;
  if (buildCounterSavedAttachedDisk < 3) {
    o.autoDelete = true;
    o.boot = true;
    o.deviceName = 'foo';
    o.diskEncryptionKey = buildCustomerEncryptionKey();
    o.diskSizeGb = 'foo';
    o.diskType = 'foo';
    o.guestOsFeatures = buildUnnamed587();
    o.index = 42;
    o.interface = 'foo';
    o.kind = 'foo';
    o.licenses = buildUnnamed588();
    o.mode = 'foo';
    o.source = 'foo';
    o.storageBytes = 'foo';
    o.storageBytesStatus = 'foo';
    o.type = 'foo';
  }
  buildCounterSavedAttachedDisk--;
  return o;
}

void checkSavedAttachedDisk(api.SavedAttachedDisk o) {
  buildCounterSavedAttachedDisk++;
  if (buildCounterSavedAttachedDisk < 3) {
    unittest.expect(o.autoDelete!, unittest.isTrue);
    unittest.expect(o.boot!, unittest.isTrue);
    unittest.expect(
      o.deviceName!,
      unittest.equals('foo'),
    );
    checkCustomerEncryptionKey(o.diskEncryptionKey!);
    unittest.expect(
      o.diskSizeGb!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.diskType!,
      unittest.equals('foo'),
    );
    checkUnnamed587(o.guestOsFeatures!);
    unittest.expect(
      o.index!,
      unittest.equals(42),
    );
    unittest.expect(
      o.interface!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkUnnamed588(o.licenses!);
    unittest.expect(
      o.mode!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.source!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.storageBytes!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.storageBytesStatus!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterSavedAttachedDisk--;
}

core.int buildCounterSavedDisk = 0;
api.SavedDisk buildSavedDisk() {
  final o = api.SavedDisk();
  buildCounterSavedDisk++;
  if (buildCounterSavedDisk < 3) {
    o.architecture = 'foo';
    o.kind = 'foo';
    o.sourceDisk = 'foo';
    o.storageBytes = 'foo';
    o.storageBytesStatus = 'foo';
  }
  buildCounterSavedDisk--;
  return o;
}

void checkSavedDisk(api.SavedDisk o) {
  buildCounterSavedDisk++;
  if (buildCounterSavedDisk < 3) {
    unittest.expect(
      o.architecture!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.sourceDisk!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.storageBytes!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.storageBytesStatus!,
      unittest.equals('foo'),
    );
  }
  buildCounterSavedDisk--;
}

core.int buildCounterScalingScheduleStatus = 0;
api.ScalingScheduleStatus buildScalingScheduleStatus() {
  final o = api.ScalingScheduleStatus();
  buildCounterScalingScheduleStatus++;
  if (buildCounterScalingScheduleStatus < 3) {
    o.lastStartTime = 'foo';
    o.nextStartTime = 'foo';
    o.state = 'foo';
  }
  buildCounterScalingScheduleStatus--;
  return o;
}

void checkScalingScheduleStatus(api.ScalingScheduleStatus o) {
  buildCounterScalingScheduleStatus++;
  if (buildCounterScalingScheduleStatus < 3) {
    unittest.expect(
      o.lastStartTime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextStartTime!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.state!,
      unittest.equals('foo'),
    );
  }
  buildCounterScalingScheduleStatus--;
}

core.List<api.SchedulingNodeAffinity> buildUnnamed589() => [
      buildSchedulingNodeAffinity(),
      buildSchedulingNodeAffinity(),
    ];

void checkUnnamed589(core.List<api.SchedulingNodeAffinity> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSchedulingNodeAffinity(o[0]);
  checkSchedulingNodeAffinity(o[1]);
}

core.int buildCounterScheduling = 0;
api.Scheduling buildScheduling() {
  final o = api.Scheduling();
  buildCounterScheduling++;
  if (buildCounterScheduling < 3) {
    o.automaticRestart = true;
    o.instanceTerminationAction = 'foo';
    o.localSsdRecoveryTimeout = buildDuration();
    o.locationHint = 'foo';
    o.minNodeCpus = 42;
    o.nodeAffinities = buildUnnamed589();
    o.onHostMaintenance = 'foo';
    o.preemptible = true;
    o.provisioningModel = 'foo';
  }
  buildCounterScheduling--;
  return o;
}

void checkScheduling(api.Scheduling o) {
  buildCounterScheduling++;
  if (buildCounterScheduling < 3) {
    unittest.expect(o.automaticRestart!, unittest.isTrue);
    unittest.expect(
      o.instanceTerminationAction!,
      unittest.equals('foo'),
    );
    checkDuration(o.localSsdRecoveryTimeout!);
    unittest.expect(
      o.locationHint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.minNodeCpus!,
      unittest.equals(42),
    );
    checkUnnamed589(o.nodeAffinities!);
    unittest.expect(
      o.onHostMaintenance!,
      unittest.equals('foo'),
    );
    unittest.expect(o.preemptible!, unittest.isTrue);
    unittest.expect(
      o.provisioningModel!,
      unittest.equals('foo'),
    );
  }
  buildCounterScheduling--;
}

core.List<core.String> buildUnnamed590() => [
      'foo',
      'foo',
    ];

void checkUnnamed590(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSchedulingNodeAffinity = 0;
api.SchedulingNodeAffinity buildSchedulingNodeAffinity() {
  final o = api.SchedulingNodeAffinity();
  buildCounterSchedulingNodeAffinity++;
  if (buildCounterSchedulingNodeAffinity < 3) {
    o.key = 'foo';
    o.operator = 'foo';
    o.values = buildUnnamed590();
  }
  buildCounterSchedulingNodeAffinity--;
  return o;
}

void checkSchedulingNodeAffinity(api.SchedulingNodeAffinity o) {
  buildCounterSchedulingNodeAffinity++;
  if (buildCounterSchedulingNodeAffinity < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.operator!,
      unittest.equals('foo'),
    );
    checkUnnamed590(o.values!);
  }
  buildCounterSchedulingNodeAffinity--;
}

core.int buildCounterScreenshot = 0;
api.Screenshot buildScreenshot() {
  final o = api.Screenshot();
  buildCounterScreenshot++;
  if (buildCounterScreenshot < 3) {
    o.contents = 'foo';
    o.kind = 'foo';
  }
  buildCounterScreenshot--;
  return o;
}

void checkScreenshot(api.Screenshot o) {
  buildCounterScreenshot++;
  if (buildCounterScreenshot < 3) {
    unittest.expect(
      o.contents!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
  }
  buildCounterScreenshot--;
}

core.Map<core.String, api.SecurityPoliciesScopedList> buildUnnamed591() => {
      'x': buildSecurityPoliciesScopedList(),
      'y': buildSecurityPoliciesScopedList(),
    };

void checkUnnamed591(core.Map<core.String, api.SecurityPoliciesScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPoliciesScopedList(o['x']!);
  checkSecurityPoliciesScopedList(o['y']!);
}

core.List<core.String> buildUnnamed592() => [
      'foo',
      'foo',
    ];

void checkUnnamed592(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSecurityPoliciesAggregatedListWarningData = 0;
api.SecurityPoliciesAggregatedListWarningData
    buildSecurityPoliciesAggregatedListWarningData() {
  final o = api.SecurityPoliciesAggregatedListWarningData();
  buildCounterSecurityPoliciesAggregatedListWarningData++;
  if (buildCounterSecurityPoliciesAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterSecurityPoliciesAggregatedListWarningData--;
  return o;
}

void checkSecurityPoliciesAggregatedListWarningData(
    api.SecurityPoliciesAggregatedListWarningData o) {
  buildCounterSecurityPoliciesAggregatedListWarningData++;
  if (buildCounterSecurityPoliciesAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPoliciesAggregatedListWarningData--;
}

core.List<api.SecurityPoliciesAggregatedListWarningData> buildUnnamed593() => [
      buildSecurityPoliciesAggregatedListWarningData(),
      buildSecurityPoliciesAggregatedListWarningData(),
    ];

void checkUnnamed593(
    core.List<api.SecurityPoliciesAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPoliciesAggregatedListWarningData(o[0]);
  checkSecurityPoliciesAggregatedListWarningData(o[1]);
}

core.int buildCounterSecurityPoliciesAggregatedListWarning = 0;
api.SecurityPoliciesAggregatedListWarning
    buildSecurityPoliciesAggregatedListWarning() {
  final o = api.SecurityPoliciesAggregatedListWarning();
  buildCounterSecurityPoliciesAggregatedListWarning++;
  if (buildCounterSecurityPoliciesAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed593();
    o.message = 'foo';
  }
  buildCounterSecurityPoliciesAggregatedListWarning--;
  return o;
}

void checkSecurityPoliciesAggregatedListWarning(
    api.SecurityPoliciesAggregatedListWarning o) {
  buildCounterSecurityPoliciesAggregatedListWarning++;
  if (buildCounterSecurityPoliciesAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed593(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPoliciesAggregatedListWarning--;
}

core.int buildCounterSecurityPoliciesAggregatedList = 0;
api.SecurityPoliciesAggregatedList buildSecurityPoliciesAggregatedList() {
  final o = api.SecurityPoliciesAggregatedList();
  buildCounterSecurityPoliciesAggregatedList++;
  if (buildCounterSecurityPoliciesAggregatedList < 3) {
    o.etag = 'foo';
    o.id = 'foo';
    o.items = buildUnnamed591();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed592();
    o.warning = buildSecurityPoliciesAggregatedListWarning();
  }
  buildCounterSecurityPoliciesAggregatedList--;
  return o;
}

void checkSecurityPoliciesAggregatedList(api.SecurityPoliciesAggregatedList o) {
  buildCounterSecurityPoliciesAggregatedList++;
  if (buildCounterSecurityPoliciesAggregatedList < 3) {
    unittest.expect(
      o.etag!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed591(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed592(o.unreachables!);
    checkSecurityPoliciesAggregatedListWarning(o.warning!);
  }
  buildCounterSecurityPoliciesAggregatedList--;
}

core.int buildCounterSecurityPoliciesListPreconfiguredExpressionSetsResponse =
    0;
api.SecurityPoliciesListPreconfiguredExpressionSetsResponse
    buildSecurityPoliciesListPreconfiguredExpressionSetsResponse() {
  final o = api.SecurityPoliciesListPreconfiguredExpressionSetsResponse();
  buildCounterSecurityPoliciesListPreconfiguredExpressionSetsResponse++;
  if (buildCounterSecurityPoliciesListPreconfiguredExpressionSetsResponse < 3) {
    o.preconfiguredExpressionSets = buildSecurityPoliciesWafConfig();
  }
  buildCounterSecurityPoliciesListPreconfiguredExpressionSetsResponse--;
  return o;
}

void checkSecurityPoliciesListPreconfiguredExpressionSetsResponse(
    api.SecurityPoliciesListPreconfiguredExpressionSetsResponse o) {
  buildCounterSecurityPoliciesListPreconfiguredExpressionSetsResponse++;
  if (buildCounterSecurityPoliciesListPreconfiguredExpressionSetsResponse < 3) {
    checkSecurityPoliciesWafConfig(o.preconfiguredExpressionSets!);
  }
  buildCounterSecurityPoliciesListPreconfiguredExpressionSetsResponse--;
}

core.List<api.SecurityPolicy> buildUnnamed594() => [
      buildSecurityPolicy(),
      buildSecurityPolicy(),
    ];

void checkUnnamed594(core.List<api.SecurityPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicy(o[0]);
  checkSecurityPolicy(o[1]);
}

core.int buildCounterSecurityPoliciesScopedListWarningData = 0;
api.SecurityPoliciesScopedListWarningData
    buildSecurityPoliciesScopedListWarningData() {
  final o = api.SecurityPoliciesScopedListWarningData();
  buildCounterSecurityPoliciesScopedListWarningData++;
  if (buildCounterSecurityPoliciesScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterSecurityPoliciesScopedListWarningData--;
  return o;
}

void checkSecurityPoliciesScopedListWarningData(
    api.SecurityPoliciesScopedListWarningData o) {
  buildCounterSecurityPoliciesScopedListWarningData++;
  if (buildCounterSecurityPoliciesScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPoliciesScopedListWarningData--;
}

core.List<api.SecurityPoliciesScopedListWarningData> buildUnnamed595() => [
      buildSecurityPoliciesScopedListWarningData(),
      buildSecurityPoliciesScopedListWarningData(),
    ];

void checkUnnamed595(core.List<api.SecurityPoliciesScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPoliciesScopedListWarningData(o[0]);
  checkSecurityPoliciesScopedListWarningData(o[1]);
}

core.int buildCounterSecurityPoliciesScopedListWarning = 0;
api.SecurityPoliciesScopedListWarning buildSecurityPoliciesScopedListWarning() {
  final o = api.SecurityPoliciesScopedListWarning();
  buildCounterSecurityPoliciesScopedListWarning++;
  if (buildCounterSecurityPoliciesScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed595();
    o.message = 'foo';
  }
  buildCounterSecurityPoliciesScopedListWarning--;
  return o;
}

void checkSecurityPoliciesScopedListWarning(
    api.SecurityPoliciesScopedListWarning o) {
  buildCounterSecurityPoliciesScopedListWarning++;
  if (buildCounterSecurityPoliciesScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed595(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPoliciesScopedListWarning--;
}

core.int buildCounterSecurityPoliciesScopedList = 0;
api.SecurityPoliciesScopedList buildSecurityPoliciesScopedList() {
  final o = api.SecurityPoliciesScopedList();
  buildCounterSecurityPoliciesScopedList++;
  if (buildCounterSecurityPoliciesScopedList < 3) {
    o.securityPolicies = buildUnnamed594();
    o.warning = buildSecurityPoliciesScopedListWarning();
  }
  buildCounterSecurityPoliciesScopedList--;
  return o;
}

void checkSecurityPoliciesScopedList(api.SecurityPoliciesScopedList o) {
  buildCounterSecurityPoliciesScopedList++;
  if (buildCounterSecurityPoliciesScopedList < 3) {
    checkUnnamed594(o.securityPolicies!);
    checkSecurityPoliciesScopedListWarning(o.warning!);
  }
  buildCounterSecurityPoliciesScopedList--;
}

core.int buildCounterSecurityPoliciesWafConfig = 0;
api.SecurityPoliciesWafConfig buildSecurityPoliciesWafConfig() {
  final o = api.SecurityPoliciesWafConfig();
  buildCounterSecurityPoliciesWafConfig++;
  if (buildCounterSecurityPoliciesWafConfig < 3) {
    o.wafRules = buildPreconfiguredWafSet();
  }
  buildCounterSecurityPoliciesWafConfig--;
  return o;
}

void checkSecurityPoliciesWafConfig(api.SecurityPoliciesWafConfig o) {
  buildCounterSecurityPoliciesWafConfig++;
  if (buildCounterSecurityPoliciesWafConfig < 3) {
    checkPreconfiguredWafSet(o.wafRules!);
  }
  buildCounterSecurityPoliciesWafConfig--;
}

core.Map<core.String, core.String> buildUnnamed596() => {
      'x': 'foo',
      'y': 'foo',
    };

void checkUnnamed596(core.Map<core.String, core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o['x']!,
    unittest.equals('foo'),
  );
  unittest.expect(
    o['y']!,
    unittest.equals('foo'),
  );
}

core.List<api.SecurityPolicyRule> buildUnnamed597() => [
      buildSecurityPolicyRule(),
      buildSecurityPolicyRule(),
    ];

void checkUnnamed597(core.List<api.SecurityPolicyRule> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRule(o[0]);
  checkSecurityPolicyRule(o[1]);
}

core.List<api.SecurityPolicyUserDefinedField> buildUnnamed598() => [
      buildSecurityPolicyUserDefinedField(),
      buildSecurityPolicyUserDefinedField(),
    ];

void checkUnnamed598(core.List<api.SecurityPolicyUserDefinedField> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyUserDefinedField(o[0]);
  checkSecurityPolicyUserDefinedField(o[1]);
}

core.int buildCounterSecurityPolicy = 0;
api.SecurityPolicy buildSecurityPolicy() {
  final o = api.SecurityPolicy();
  buildCounterSecurityPolicy++;
  if (buildCounterSecurityPolicy < 3) {
    o.adaptiveProtectionConfig = buildSecurityPolicyAdaptiveProtectionConfig();
    o.advancedOptionsConfig = buildSecurityPolicyAdvancedOptionsConfig();
    o.creationTimestamp = 'foo';
    o.ddosProtectionConfig = buildSecurityPolicyDdosProtectionConfig();
    o.description = 'foo';
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.labelFingerprint = 'foo';
    o.labels = buildUnnamed596();
    o.name = 'foo';
    o.recaptchaOptionsConfig = buildSecurityPolicyRecaptchaOptionsConfig();
    o.region = 'foo';
    o.rules = buildUnnamed597();
    o.selfLink = 'foo';
    o.type = 'foo';
    o.userDefinedFields = buildUnnamed598();
  }
  buildCounterSecurityPolicy--;
  return o;
}

void checkSecurityPolicy(api.SecurityPolicy o) {
  buildCounterSecurityPolicy++;
  if (buildCounterSecurityPolicy < 3) {
    checkSecurityPolicyAdaptiveProtectionConfig(o.adaptiveProtectionConfig!);
    checkSecurityPolicyAdvancedOptionsConfig(o.advancedOptionsConfig!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    checkSecurityPolicyDdosProtectionConfig(o.ddosProtectionConfig!);
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.labelFingerprint!,
      unittest.equals('foo'),
    );
    checkUnnamed596(o.labels!);
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkSecurityPolicyRecaptchaOptionsConfig(o.recaptchaOptionsConfig!);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    checkUnnamed597(o.rules!);
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
    checkUnnamed598(o.userDefinedFields!);
  }
  buildCounterSecurityPolicy--;
}

core.int buildCounterSecurityPolicyAdaptiveProtectionConfig = 0;
api.SecurityPolicyAdaptiveProtectionConfig
    buildSecurityPolicyAdaptiveProtectionConfig() {
  final o = api.SecurityPolicyAdaptiveProtectionConfig();
  buildCounterSecurityPolicyAdaptiveProtectionConfig++;
  if (buildCounterSecurityPolicyAdaptiveProtectionConfig < 3) {
    o.layer7DdosDefenseConfig =
        buildSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig();
  }
  buildCounterSecurityPolicyAdaptiveProtectionConfig--;
  return o;
}

void checkSecurityPolicyAdaptiveProtectionConfig(
    api.SecurityPolicyAdaptiveProtectionConfig o) {
  buildCounterSecurityPolicyAdaptiveProtectionConfig++;
  if (buildCounterSecurityPolicyAdaptiveProtectionConfig < 3) {
    checkSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig(
        o.layer7DdosDefenseConfig!);
  }
  buildCounterSecurityPolicyAdaptiveProtectionConfig--;
}

core.List<
        api
        .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig>
    buildUnnamed599() => [
          buildSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig(),
          buildSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig(),
        ];

void checkUnnamed599(
    core.List<
            api
            .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig(
      o[0]);
  checkSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig(
      o[1]);
}

core.int
    buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig =
    0;
api.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig
    buildSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig() {
  final o = api.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig();
  buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig++;
  if (buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig <
      3) {
    o.enable = true;
    o.ruleVisibility = 'foo';
    o.thresholdConfigs = buildUnnamed599();
  }
  buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig--;
  return o;
}

void checkSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig(
    api.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig o) {
  buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig++;
  if (buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig <
      3) {
    unittest.expect(o.enable!, unittest.isTrue);
    unittest.expect(
      o.ruleVisibility!,
      unittest.equals('foo'),
    );
    checkUnnamed599(o.thresholdConfigs!);
  }
  buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig--;
}

core.int
    buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig =
    0;
api.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
    buildSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig() {
  final o = api
      .SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig();
  buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig++;
  if (buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig <
      3) {
    o.autoDeployConfidenceThreshold = 42.0;
    o.autoDeployExpirationSec = 42;
    o.autoDeployImpactedBaselineThreshold = 42.0;
    o.autoDeployLoadThreshold = 42.0;
    o.name = 'foo';
  }
  buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig--;
  return o;
}

void checkSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig(
    api.SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig
        o) {
  buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig++;
  if (buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig <
      3) {
    unittest.expect(
      o.autoDeployConfidenceThreshold!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.autoDeployExpirationSec!,
      unittest.equals(42),
    );
    unittest.expect(
      o.autoDeployImpactedBaselineThreshold!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.autoDeployLoadThreshold!,
      unittest.equals(42.0),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig--;
}

core.List<core.String> buildUnnamed600() => [
      'foo',
      'foo',
    ];

void checkUnnamed600(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSecurityPolicyAdvancedOptionsConfig = 0;
api.SecurityPolicyAdvancedOptionsConfig
    buildSecurityPolicyAdvancedOptionsConfig() {
  final o = api.SecurityPolicyAdvancedOptionsConfig();
  buildCounterSecurityPolicyAdvancedOptionsConfig++;
  if (buildCounterSecurityPolicyAdvancedOptionsConfig < 3) {
    o.jsonCustomConfig =
        buildSecurityPolicyAdvancedOptionsConfigJsonCustomConfig();
    o.jsonParsing = 'foo';
    o.logLevel = 'foo';
    o.userIpRequestHeaders = buildUnnamed600();
  }
  buildCounterSecurityPolicyAdvancedOptionsConfig--;
  return o;
}

void checkSecurityPolicyAdvancedOptionsConfig(
    api.SecurityPolicyAdvancedOptionsConfig o) {
  buildCounterSecurityPolicyAdvancedOptionsConfig++;
  if (buildCounterSecurityPolicyAdvancedOptionsConfig < 3) {
    checkSecurityPolicyAdvancedOptionsConfigJsonCustomConfig(
        o.jsonCustomConfig!);
    unittest.expect(
      o.jsonParsing!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.logLevel!,
      unittest.equals('foo'),
    );
    checkUnnamed600(o.userIpRequestHeaders!);
  }
  buildCounterSecurityPolicyAdvancedOptionsConfig--;
}

core.List<core.String> buildUnnamed601() => [
      'foo',
      'foo',
    ];

void checkUnnamed601(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSecurityPolicyAdvancedOptionsConfigJsonCustomConfig = 0;
api.SecurityPolicyAdvancedOptionsConfigJsonCustomConfig
    buildSecurityPolicyAdvancedOptionsConfigJsonCustomConfig() {
  final o = api.SecurityPolicyAdvancedOptionsConfigJsonCustomConfig();
  buildCounterSecurityPolicyAdvancedOptionsConfigJsonCustomConfig++;
  if (buildCounterSecurityPolicyAdvancedOptionsConfigJsonCustomConfig < 3) {
    o.contentTypes = buildUnnamed601();
  }
  buildCounterSecurityPolicyAdvancedOptionsConfigJsonCustomConfig--;
  return o;
}

void checkSecurityPolicyAdvancedOptionsConfigJsonCustomConfig(
    api.SecurityPolicyAdvancedOptionsConfigJsonCustomConfig o) {
  buildCounterSecurityPolicyAdvancedOptionsConfigJsonCustomConfig++;
  if (buildCounterSecurityPolicyAdvancedOptionsConfigJsonCustomConfig < 3) {
    checkUnnamed601(o.contentTypes!);
  }
  buildCounterSecurityPolicyAdvancedOptionsConfigJsonCustomConfig--;
}

core.int buildCounterSecurityPolicyDdosProtectionConfig = 0;
api.SecurityPolicyDdosProtectionConfig
    buildSecurityPolicyDdosProtectionConfig() {
  final o = api.SecurityPolicyDdosProtectionConfig();
  buildCounterSecurityPolicyDdosProtectionConfig++;
  if (buildCounterSecurityPolicyDdosProtectionConfig < 3) {
    o.ddosProtection = 'foo';
  }
  buildCounterSecurityPolicyDdosProtectionConfig--;
  return o;
}

void checkSecurityPolicyDdosProtectionConfig(
    api.SecurityPolicyDdosProtectionConfig o) {
  buildCounterSecurityPolicyDdosProtectionConfig++;
  if (buildCounterSecurityPolicyDdosProtectionConfig < 3) {
    unittest.expect(
      o.ddosProtection!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyDdosProtectionConfig--;
}

core.List<api.SecurityPolicy> buildUnnamed602() => [
      buildSecurityPolicy(),
      buildSecurityPolicy(),
    ];

void checkUnnamed602(core.List<api.SecurityPolicy> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicy(o[0]);
  checkSecurityPolicy(o[1]);
}

core.int buildCounterSecurityPolicyListWarningData = 0;
api.SecurityPolicyListWarningData buildSecurityPolicyListWarningData() {
  final o = api.SecurityPolicyListWarningData();
  buildCounterSecurityPolicyListWarningData++;
  if (buildCounterSecurityPolicyListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterSecurityPolicyListWarningData--;
  return o;
}

void checkSecurityPolicyListWarningData(api.SecurityPolicyListWarningData o) {
  buildCounterSecurityPolicyListWarningData++;
  if (buildCounterSecurityPolicyListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyListWarningData--;
}

core.List<api.SecurityPolicyListWarningData> buildUnnamed603() => [
      buildSecurityPolicyListWarningData(),
      buildSecurityPolicyListWarningData(),
    ];

void checkUnnamed603(core.List<api.SecurityPolicyListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyListWarningData(o[0]);
  checkSecurityPolicyListWarningData(o[1]);
}

core.int buildCounterSecurityPolicyListWarning = 0;
api.SecurityPolicyListWarning buildSecurityPolicyListWarning() {
  final o = api.SecurityPolicyListWarning();
  buildCounterSecurityPolicyListWarning++;
  if (buildCounterSecurityPolicyListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed603();
    o.message = 'foo';
  }
  buildCounterSecurityPolicyListWarning--;
  return o;
}

void checkSecurityPolicyListWarning(api.SecurityPolicyListWarning o) {
  buildCounterSecurityPolicyListWarning++;
  if (buildCounterSecurityPolicyListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed603(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyListWarning--;
}

core.int buildCounterSecurityPolicyList = 0;
api.SecurityPolicyList buildSecurityPolicyList() {
  final o = api.SecurityPolicyList();
  buildCounterSecurityPolicyList++;
  if (buildCounterSecurityPolicyList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed602();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.warning = buildSecurityPolicyListWarning();
  }
  buildCounterSecurityPolicyList--;
  return o;
}

void checkSecurityPolicyList(api.SecurityPolicyList o) {
  buildCounterSecurityPolicyList++;
  if (buildCounterSecurityPolicyList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed602(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    checkSecurityPolicyListWarning(o.warning!);
  }
  buildCounterSecurityPolicyList--;
}

core.int buildCounterSecurityPolicyRecaptchaOptionsConfig = 0;
api.SecurityPolicyRecaptchaOptionsConfig
    buildSecurityPolicyRecaptchaOptionsConfig() {
  final o = api.SecurityPolicyRecaptchaOptionsConfig();
  buildCounterSecurityPolicyRecaptchaOptionsConfig++;
  if (buildCounterSecurityPolicyRecaptchaOptionsConfig < 3) {
    o.redirectSiteKey = 'foo';
  }
  buildCounterSecurityPolicyRecaptchaOptionsConfig--;
  return o;
}

void checkSecurityPolicyRecaptchaOptionsConfig(
    api.SecurityPolicyRecaptchaOptionsConfig o) {
  buildCounterSecurityPolicyRecaptchaOptionsConfig++;
  if (buildCounterSecurityPolicyRecaptchaOptionsConfig < 3) {
    unittest.expect(
      o.redirectSiteKey!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyRecaptchaOptionsConfig--;
}

core.int buildCounterSecurityPolicyReference = 0;
api.SecurityPolicyReference buildSecurityPolicyReference() {
  final o = api.SecurityPolicyReference();
  buildCounterSecurityPolicyReference++;
  if (buildCounterSecurityPolicyReference < 3) {
    o.securityPolicy = 'foo';
  }
  buildCounterSecurityPolicyReference--;
  return o;
}

void checkSecurityPolicyReference(api.SecurityPolicyReference o) {
  buildCounterSecurityPolicyReference++;
  if (buildCounterSecurityPolicyReference < 3) {
    unittest.expect(
      o.securityPolicy!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyReference--;
}

core.int buildCounterSecurityPolicyRule = 0;
api.SecurityPolicyRule buildSecurityPolicyRule() {
  final o = api.SecurityPolicyRule();
  buildCounterSecurityPolicyRule++;
  if (buildCounterSecurityPolicyRule < 3) {
    o.action = 'foo';
    o.description = 'foo';
    o.headerAction = buildSecurityPolicyRuleHttpHeaderAction();
    o.kind = 'foo';
    o.match = buildSecurityPolicyRuleMatcher();
    o.networkMatch = buildSecurityPolicyRuleNetworkMatcher();
    o.preconfiguredWafConfig = buildSecurityPolicyRulePreconfiguredWafConfig();
    o.preview = true;
    o.priority = 42;
    o.rateLimitOptions = buildSecurityPolicyRuleRateLimitOptions();
    o.redirectOptions = buildSecurityPolicyRuleRedirectOptions();
  }
  buildCounterSecurityPolicyRule--;
  return o;
}

void checkSecurityPolicyRule(api.SecurityPolicyRule o) {
  buildCounterSecurityPolicyRule++;
  if (buildCounterSecurityPolicyRule < 3) {
    unittest.expect(
      o.action!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkSecurityPolicyRuleHttpHeaderAction(o.headerAction!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    checkSecurityPolicyRuleMatcher(o.match!);
    checkSecurityPolicyRuleNetworkMatcher(o.networkMatch!);
    checkSecurityPolicyRulePreconfiguredWafConfig(o.preconfiguredWafConfig!);
    unittest.expect(o.preview!, unittest.isTrue);
    unittest.expect(
      o.priority!,
      unittest.equals(42),
    );
    checkSecurityPolicyRuleRateLimitOptions(o.rateLimitOptions!);
    checkSecurityPolicyRuleRedirectOptions(o.redirectOptions!);
  }
  buildCounterSecurityPolicyRule--;
}

core.List<api.SecurityPolicyRuleHttpHeaderActionHttpHeaderOption>
    buildUnnamed604() => [
          buildSecurityPolicyRuleHttpHeaderActionHttpHeaderOption(),
          buildSecurityPolicyRuleHttpHeaderActionHttpHeaderOption(),
        ];

void checkUnnamed604(
    core.List<api.SecurityPolicyRuleHttpHeaderActionHttpHeaderOption> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRuleHttpHeaderActionHttpHeaderOption(o[0]);
  checkSecurityPolicyRuleHttpHeaderActionHttpHeaderOption(o[1]);
}

core.int buildCounterSecurityPolicyRuleHttpHeaderAction = 0;
api.SecurityPolicyRuleHttpHeaderAction
    buildSecurityPolicyRuleHttpHeaderAction() {
  final o = api.SecurityPolicyRuleHttpHeaderAction();
  buildCounterSecurityPolicyRuleHttpHeaderAction++;
  if (buildCounterSecurityPolicyRuleHttpHeaderAction < 3) {
    o.requestHeadersToAdds = buildUnnamed604();
  }
  buildCounterSecurityPolicyRuleHttpHeaderAction--;
  return o;
}

void checkSecurityPolicyRuleHttpHeaderAction(
    api.SecurityPolicyRuleHttpHeaderAction o) {
  buildCounterSecurityPolicyRuleHttpHeaderAction++;
  if (buildCounterSecurityPolicyRuleHttpHeaderAction < 3) {
    checkUnnamed604(o.requestHeadersToAdds!);
  }
  buildCounterSecurityPolicyRuleHttpHeaderAction--;
}

core.int buildCounterSecurityPolicyRuleHttpHeaderActionHttpHeaderOption = 0;
api.SecurityPolicyRuleHttpHeaderActionHttpHeaderOption
    buildSecurityPolicyRuleHttpHeaderActionHttpHeaderOption() {
  final o = api.SecurityPolicyRuleHttpHeaderActionHttpHeaderOption();
  buildCounterSecurityPolicyRuleHttpHeaderActionHttpHeaderOption++;
  if (buildCounterSecurityPolicyRuleHttpHeaderActionHttpHeaderOption < 3) {
    o.headerName = 'foo';
    o.headerValue = 'foo';
  }
  buildCounterSecurityPolicyRuleHttpHeaderActionHttpHeaderOption--;
  return o;
}

void checkSecurityPolicyRuleHttpHeaderActionHttpHeaderOption(
    api.SecurityPolicyRuleHttpHeaderActionHttpHeaderOption o) {
  buildCounterSecurityPolicyRuleHttpHeaderActionHttpHeaderOption++;
  if (buildCounterSecurityPolicyRuleHttpHeaderActionHttpHeaderOption < 3) {
    unittest.expect(
      o.headerName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.headerValue!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyRuleHttpHeaderActionHttpHeaderOption--;
}

core.int buildCounterSecurityPolicyRuleMatcher = 0;
api.SecurityPolicyRuleMatcher buildSecurityPolicyRuleMatcher() {
  final o = api.SecurityPolicyRuleMatcher();
  buildCounterSecurityPolicyRuleMatcher++;
  if (buildCounterSecurityPolicyRuleMatcher < 3) {
    o.config = buildSecurityPolicyRuleMatcherConfig();
    o.expr = buildExpr();
    o.versionedExpr = 'foo';
  }
  buildCounterSecurityPolicyRuleMatcher--;
  return o;
}

void checkSecurityPolicyRuleMatcher(api.SecurityPolicyRuleMatcher o) {
  buildCounterSecurityPolicyRuleMatcher++;
  if (buildCounterSecurityPolicyRuleMatcher < 3) {
    checkSecurityPolicyRuleMatcherConfig(o.config!);
    checkExpr(o.expr!);
    unittest.expect(
      o.versionedExpr!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyRuleMatcher--;
}

core.List<core.String> buildUnnamed605() => [
      'foo',
      'foo',
    ];

void checkUnnamed605(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSecurityPolicyRuleMatcherConfig = 0;
api.SecurityPolicyRuleMatcherConfig buildSecurityPolicyRuleMatcherConfig() {
  final o = api.SecurityPolicyRuleMatcherConfig();
  buildCounterSecurityPolicyRuleMatcherConfig++;
  if (buildCounterSecurityPolicyRuleMatcherConfig < 3) {
    o.srcIpRanges = buildUnnamed605();
  }
  buildCounterSecurityPolicyRuleMatcherConfig--;
  return o;
}

void checkSecurityPolicyRuleMatcherConfig(
    api.SecurityPolicyRuleMatcherConfig o) {
  buildCounterSecurityPolicyRuleMatcherConfig++;
  if (buildCounterSecurityPolicyRuleMatcherConfig < 3) {
    checkUnnamed605(o.srcIpRanges!);
  }
  buildCounterSecurityPolicyRuleMatcherConfig--;
}

core.List<core.String> buildUnnamed606() => [
      'foo',
      'foo',
    ];

void checkUnnamed606(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed607() => [
      'foo',
      'foo',
    ];

void checkUnnamed607(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed608() => [
      'foo',
      'foo',
    ];

void checkUnnamed608(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.int> buildUnnamed609() => [
      42,
      42,
    ];

void checkUnnamed609(core.List<core.int> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals(42),
  );
  unittest.expect(
    o[1],
    unittest.equals(42),
  );
}

core.List<core.String> buildUnnamed610() => [
      'foo',
      'foo',
    ];

void checkUnnamed610(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed611() => [
      'foo',
      'foo',
    ];

void checkUnnamed611(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed612() => [
      'foo',
      'foo',
    ];

void checkUnnamed612(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<api.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch>
    buildUnnamed613() => [
          buildSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch(),
          buildSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch(),
        ];

void checkUnnamed613(
    core.List<api.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch(o[0]);
  checkSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch(o[1]);
}

core.int buildCounterSecurityPolicyRuleNetworkMatcher = 0;
api.SecurityPolicyRuleNetworkMatcher buildSecurityPolicyRuleNetworkMatcher() {
  final o = api.SecurityPolicyRuleNetworkMatcher();
  buildCounterSecurityPolicyRuleNetworkMatcher++;
  if (buildCounterSecurityPolicyRuleNetworkMatcher < 3) {
    o.destIpRanges = buildUnnamed606();
    o.destPorts = buildUnnamed607();
    o.ipProtocols = buildUnnamed608();
    o.srcAsns = buildUnnamed609();
    o.srcIpRanges = buildUnnamed610();
    o.srcPorts = buildUnnamed611();
    o.srcRegionCodes = buildUnnamed612();
    o.userDefinedFields = buildUnnamed613();
  }
  buildCounterSecurityPolicyRuleNetworkMatcher--;
  return o;
}

void checkSecurityPolicyRuleNetworkMatcher(
    api.SecurityPolicyRuleNetworkMatcher o) {
  buildCounterSecurityPolicyRuleNetworkMatcher++;
  if (buildCounterSecurityPolicyRuleNetworkMatcher < 3) {
    checkUnnamed606(o.destIpRanges!);
    checkUnnamed607(o.destPorts!);
    checkUnnamed608(o.ipProtocols!);
    checkUnnamed609(o.srcAsns!);
    checkUnnamed610(o.srcIpRanges!);
    checkUnnamed611(o.srcPorts!);
    checkUnnamed612(o.srcRegionCodes!);
    checkUnnamed613(o.userDefinedFields!);
  }
  buildCounterSecurityPolicyRuleNetworkMatcher--;
}

core.List<core.String> buildUnnamed614() => [
      'foo',
      'foo',
    ];

void checkUnnamed614(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch = 0;
api.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch
    buildSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch() {
  final o = api.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch();
  buildCounterSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch++;
  if (buildCounterSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch < 3) {
    o.name = 'foo';
    o.values = buildUnnamed614();
  }
  buildCounterSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch--;
  return o;
}

void checkSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch(
    api.SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch o) {
  buildCounterSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch++;
  if (buildCounterSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch < 3) {
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed614(o.values!);
  }
  buildCounterSecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch--;
}

core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusion>
    buildUnnamed615() => [
          buildSecurityPolicyRulePreconfiguredWafConfigExclusion(),
          buildSecurityPolicyRulePreconfiguredWafConfigExclusion(),
        ];

void checkUnnamed615(
    core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusion> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRulePreconfiguredWafConfigExclusion(o[0]);
  checkSecurityPolicyRulePreconfiguredWafConfigExclusion(o[1]);
}

core.int buildCounterSecurityPolicyRulePreconfiguredWafConfig = 0;
api.SecurityPolicyRulePreconfiguredWafConfig
    buildSecurityPolicyRulePreconfiguredWafConfig() {
  final o = api.SecurityPolicyRulePreconfiguredWafConfig();
  buildCounterSecurityPolicyRulePreconfiguredWafConfig++;
  if (buildCounterSecurityPolicyRulePreconfiguredWafConfig < 3) {
    o.exclusions = buildUnnamed615();
  }
  buildCounterSecurityPolicyRulePreconfiguredWafConfig--;
  return o;
}

void checkSecurityPolicyRulePreconfiguredWafConfig(
    api.SecurityPolicyRulePreconfiguredWafConfig o) {
  buildCounterSecurityPolicyRulePreconfiguredWafConfig++;
  if (buildCounterSecurityPolicyRulePreconfiguredWafConfig < 3) {
    checkUnnamed615(o.exclusions!);
  }
  buildCounterSecurityPolicyRulePreconfiguredWafConfig--;
}

core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams>
    buildUnnamed616() => [
          buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(),
          buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(),
        ];

void checkUnnamed616(
    core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(o[0]);
  checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(o[1]);
}

core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams>
    buildUnnamed617() => [
          buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(),
          buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(),
        ];

void checkUnnamed617(
    core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(o[0]);
  checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(o[1]);
}

core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams>
    buildUnnamed618() => [
          buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(),
          buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(),
        ];

void checkUnnamed618(
    core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(o[0]);
  checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(o[1]);
}

core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams>
    buildUnnamed619() => [
          buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(),
          buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(),
        ];

void checkUnnamed619(
    core.List<api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(o[0]);
  checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(o[1]);
}

core.List<core.String> buildUnnamed620() => [
      'foo',
      'foo',
    ];

void checkUnnamed620(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusion = 0;
api.SecurityPolicyRulePreconfiguredWafConfigExclusion
    buildSecurityPolicyRulePreconfiguredWafConfigExclusion() {
  final o = api.SecurityPolicyRulePreconfiguredWafConfigExclusion();
  buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusion++;
  if (buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusion < 3) {
    o.requestCookiesToExclude = buildUnnamed616();
    o.requestHeadersToExclude = buildUnnamed617();
    o.requestQueryParamsToExclude = buildUnnamed618();
    o.requestUrisToExclude = buildUnnamed619();
    o.targetRuleIds = buildUnnamed620();
    o.targetRuleSet = 'foo';
  }
  buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusion--;
  return o;
}

void checkSecurityPolicyRulePreconfiguredWafConfigExclusion(
    api.SecurityPolicyRulePreconfiguredWafConfigExclusion o) {
  buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusion++;
  if (buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusion < 3) {
    checkUnnamed616(o.requestCookiesToExclude!);
    checkUnnamed617(o.requestHeadersToExclude!);
    checkUnnamed618(o.requestQueryParamsToExclude!);
    checkUnnamed619(o.requestUrisToExclude!);
    checkUnnamed620(o.targetRuleIds!);
    unittest.expect(
      o.targetRuleSet!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusion--;
}

core.int
    buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams =
    0;
api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams
    buildSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams() {
  final o = api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams();
  buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams++;
  if (buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams <
      3) {
    o.op = 'foo';
    o.val = 'foo';
  }
  buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams--;
  return o;
}

void checkSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams(
    api.SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams o) {
  buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams++;
  if (buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams <
      3) {
    unittest.expect(
      o.op!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.val!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams--;
}

core.List<api.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig>
    buildUnnamed621() => [
          buildSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig(),
          buildSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig(),
        ];

void checkUnnamed621(
    core.List<api.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig(o[0]);
  checkSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig(o[1]);
}

core.int buildCounterSecurityPolicyRuleRateLimitOptions = 0;
api.SecurityPolicyRuleRateLimitOptions
    buildSecurityPolicyRuleRateLimitOptions() {
  final o = api.SecurityPolicyRuleRateLimitOptions();
  buildCounterSecurityPolicyRuleRateLimitOptions++;
  if (buildCounterSecurityPolicyRuleRateLimitOptions < 3) {
    o.banDurationSec = 42;
    o.banThreshold = buildSecurityPolicyRuleRateLimitOptionsThreshold();
    o.conformAction = 'foo';
    o.enforceOnKey = 'foo';
    o.enforceOnKeyConfigs = buildUnnamed621();
    o.enforceOnKeyName = 'foo';
    o.exceedAction = 'foo';
    o.exceedRedirectOptions = buildSecurityPolicyRuleRedirectOptions();
    o.rateLimitThreshold = buildSecurityPolicyRuleRateLimitOptionsThreshold();
  }
  buildCounterSecurityPolicyRuleRateLimitOptions--;
  return o;
}

void checkSecurityPolicyRuleRateLimitOptions(
    api.SecurityPolicyRuleRateLimitOptions o) {
  buildCounterSecurityPolicyRuleRateLimitOptions++;
  if (buildCounterSecurityPolicyRuleRateLimitOptions < 3) {
    unittest.expect(
      o.banDurationSec!,
      unittest.equals(42),
    );
    checkSecurityPolicyRuleRateLimitOptionsThreshold(o.banThreshold!);
    unittest.expect(
      o.conformAction!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.enforceOnKey!,
      unittest.equals('foo'),
    );
    checkUnnamed621(o.enforceOnKeyConfigs!);
    unittest.expect(
      o.enforceOnKeyName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.exceedAction!,
      unittest.equals('foo'),
    );
    checkSecurityPolicyRuleRedirectOptions(o.exceedRedirectOptions!);
    checkSecurityPolicyRuleRateLimitOptionsThreshold(o.rateLimitThreshold!);
  }
  buildCounterSecurityPolicyRuleRateLimitOptions--;
}

core.int buildCounterSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig = 0;
api.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig
    buildSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig() {
  final o = api.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig();
  buildCounterSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig++;
  if (buildCounterSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig < 3) {
    o.enforceOnKeyName = 'foo';
    o.enforceOnKeyType = 'foo';
  }
  buildCounterSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig--;
  return o;
}

void checkSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig(
    api.SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig o) {
  buildCounterSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig++;
  if (buildCounterSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig < 3) {
    unittest.expect(
      o.enforceOnKeyName!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.enforceOnKeyType!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig--;
}

core.int buildCounterSecurityPolicyRuleRateLimitOptionsThreshold = 0;
api.SecurityPolicyRuleRateLimitOptionsThreshold
    buildSecurityPolicyRuleRateLimitOptionsThreshold() {
  final o = api.SecurityPolicyRuleRateLimitOptionsThreshold();
  buildCounterSecurityPolicyRuleRateLimitOptionsThreshold++;
  if (buildCounterSecurityPolicyRuleRateLimitOptionsThreshold < 3) {
    o.count = 42;
    o.intervalSec = 42;
  }
  buildCounterSecurityPolicyRuleRateLimitOptionsThreshold--;
  return o;
}

void checkSecurityPolicyRuleRateLimitOptionsThreshold(
    api.SecurityPolicyRuleRateLimitOptionsThreshold o) {
  buildCounterSecurityPolicyRuleRateLimitOptionsThreshold++;
  if (buildCounterSecurityPolicyRuleRateLimitOptionsThreshold < 3) {
    unittest.expect(
      o.count!,
      unittest.equals(42),
    );
    unittest.expect(
      o.intervalSec!,
      unittest.equals(42),
    );
  }
  buildCounterSecurityPolicyRuleRateLimitOptionsThreshold--;
}

core.int buildCounterSecurityPolicyRuleRedirectOptions = 0;
api.SecurityPolicyRuleRedirectOptions buildSecurityPolicyRuleRedirectOptions() {
  final o = api.SecurityPolicyRuleRedirectOptions();
  buildCounterSecurityPolicyRuleRedirectOptions++;
  if (buildCounterSecurityPolicyRuleRedirectOptions < 3) {
    o.target = 'foo';
    o.type = 'foo';
  }
  buildCounterSecurityPolicyRuleRedirectOptions--;
  return o;
}

void checkSecurityPolicyRuleRedirectOptions(
    api.SecurityPolicyRuleRedirectOptions o) {
  buildCounterSecurityPolicyRuleRedirectOptions++;
  if (buildCounterSecurityPolicyRuleRedirectOptions < 3) {
    unittest.expect(
      o.target!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterSecurityPolicyRuleRedirectOptions--;
}

core.int buildCounterSecurityPolicyUserDefinedField = 0;
api.SecurityPolicyUserDefinedField buildSecurityPolicyUserDefinedField() {
  final o = api.SecurityPolicyUserDefinedField();
  buildCounterSecurityPolicyUserDefinedField++;
  if (buildCounterSecurityPolicyUserDefinedField < 3) {
    o.base = 'foo';
    o.mask = 'foo';
    o.name = 'foo';
    o.offset = 42;
    o.size = 42;
  }
  buildCounterSecurityPolicyUserDefinedField--;
  return o;
}

void checkSecurityPolicyUserDefinedField(api.SecurityPolicyUserDefinedField o) {
  buildCounterSecurityPolicyUserDefinedField++;
  if (buildCounterSecurityPolicyUserDefinedField < 3) {
    unittest.expect(
      o.base!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.mask!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.offset!,
      unittest.equals(42),
    );
    unittest.expect(
      o.size!,
      unittest.equals(42),
    );
  }
  buildCounterSecurityPolicyUserDefinedField--;
}

core.List<core.String> buildUnnamed622() => [
      'foo',
      'foo',
    ];

void checkUnnamed622(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterSecuritySettings = 0;
api.SecuritySettings buildSecuritySettings() {
  final o = api.SecuritySettings();
  buildCounterSecuritySettings++;
  if (buildCounterSecuritySettings < 3) {
    o.awsV4Authentication = buildAWSV4Signature();
    o.clientTlsPolicy = 'foo';
    o.subjectAltNames = buildUnnamed622();
  }
  buildCounterSecuritySettings--;
  return o;
}

void checkSecuritySettings(api.SecuritySettings o) {
  buildCounterSecuritySettings++;
  if (buildCounterSecuritySettings < 3) {
    checkAWSV4Signature(o.awsV4Authentication!);
    unittest.expect(
      o.clientTlsPolicy!,
      unittest.equals('foo'),
    );
    checkUnnamed622(o.subjectAltNames!);
  }
  buildCounterSecuritySettings--;
}

core.int buildCounterSerialPortOutput = 0;
api.SerialPortOutput buildSerialPortOutput() {
  final o = api.SerialPortOutput();
  buildCounterSerialPortOutput++;
  if (buildCounterSerialPortOutput < 3) {
    o.contents = 'foo';
    o.kind = 'foo';
    o.next = 'foo';
    o.selfLink = 'foo';
    o.start = 'foo';
  }
  buildCounterSerialPortOutput--;
  return o;
}

void checkSerialPortOutput(api.SerialPortOutput o) {
  buildCounterSerialPortOutput++;
  if (buildCounterSerialPortOutput < 3) {
    unittest.expect(
      o.contents!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.next!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.start!,
      unittest.equals('foo'),
    );
  }
  buildCounterSerialPortOutput--;
}

core.int buildCounterServerBinding = 0;
api.ServerBinding buildServerBinding() {
  final o = api.ServerBinding();
  buildCounterServerBinding++;
  if (buildCounterServerBinding < 3) {
    o.type = 'foo';
  }
  buildCounterServerBinding--;
  return o;
}

void checkServerBinding(api.ServerBinding o) {
  buildCounterServerBinding++;
  if (buildCounterServerBinding < 3) {
    unittest.expect(
      o.type!,
      unittest.equals('foo'),
    );
  }
  buildCounterServerBinding--;
}

core.List<core.String> buildUnnamed623() => [
      'foo',
      'foo',
    ];

void checkUnnamed623(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterServiceAccount = 0;
api.ServiceAccount buildServiceAccount() {
  final o = api.ServiceAccount();
  buildCounterServiceAccount++;
  if (buildCounterServiceAccount < 3) {
    o.email = 'foo';
    o.scopes = buildUnnamed623();
  }
  buildCounterServiceAccount--;
  return o;
}

void checkServiceAccount(api.ServiceAccount o) {
  buildCounterServiceAccount++;
  if (buildCounterServiceAccount < 3) {
    unittest.expect(
      o.email!,
      unittest.equals('foo'),
    );
    checkUnnamed623(o.scopes!);
  }
  buildCounterServiceAccount--;
}

core.List<api.ServiceAttachmentConnectedEndpoint> buildUnnamed624() => [
      buildServiceAttachmentConnectedEndpoint(),
      buildServiceAttachmentConnectedEndpoint(),
    ];

void checkUnnamed624(core.List<api.ServiceAttachmentConnectedEndpoint> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAttachmentConnectedEndpoint(o[0]);
  checkServiceAttachmentConnectedEndpoint(o[1]);
}

core.List<api.ServiceAttachmentConsumerProjectLimit> buildUnnamed625() => [
      buildServiceAttachmentConsumerProjectLimit(),
      buildServiceAttachmentConsumerProjectLimit(),
    ];

void checkUnnamed625(core.List<api.ServiceAttachmentConsumerProjectLimit> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAttachmentConsumerProjectLimit(o[0]);
  checkServiceAttachmentConsumerProjectLimit(o[1]);
}

core.List<core.String> buildUnnamed626() => [
      'foo',
      'foo',
    ];

void checkUnnamed626(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed627() => [
      'foo',
      'foo',
    ];

void checkUnnamed627(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.List<core.String> buildUnnamed628() => [
      'foo',
      'foo',
    ];

void checkUnnamed628(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterServiceAttachment = 0;
api.ServiceAttachment buildServiceAttachment() {
  final o = api.ServiceAttachment();
  buildCounterServiceAttachment++;
  if (buildCounterServiceAttachment < 3) {
    o.connectedEndpoints = buildUnnamed624();
    o.connectionPreference = 'foo';
    o.consumerAcceptLists = buildUnnamed625();
    o.consumerRejectLists = buildUnnamed626();
    o.creationTimestamp = 'foo';
    o.description = 'foo';
    o.domainNames = buildUnnamed627();
    o.enableProxyProtocol = true;
    o.fingerprint = 'foo';
    o.id = 'foo';
    o.kind = 'foo';
    o.name = 'foo';
    o.natSubnets = buildUnnamed628();
    o.producerForwardingRule = 'foo';
    o.pscServiceAttachmentId = buildUint128();
    o.reconcileConnections = true;
    o.region = 'foo';
    o.selfLink = 'foo';
    o.targetService = 'foo';
  }
  buildCounterServiceAttachment--;
  return o;
}

void checkServiceAttachment(api.ServiceAttachment o) {
  buildCounterServiceAttachment++;
  if (buildCounterServiceAttachment < 3) {
    checkUnnamed624(o.connectedEndpoints!);
    unittest.expect(
      o.connectionPreference!,
      unittest.equals('foo'),
    );
    checkUnnamed625(o.consumerAcceptLists!);
    checkUnnamed626(o.consumerRejectLists!);
    unittest.expect(
      o.creationTimestamp!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.description!,
      unittest.equals('foo'),
    );
    checkUnnamed627(o.domainNames!);
    unittest.expect(o.enableProxyProtocol!, unittest.isTrue);
    unittest.expect(
      o.fingerprint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.name!,
      unittest.equals('foo'),
    );
    checkUnnamed628(o.natSubnets!);
    unittest.expect(
      o.producerForwardingRule!,
      unittest.equals('foo'),
    );
    checkUint128(o.pscServiceAttachmentId!);
    unittest.expect(o.reconcileConnections!, unittest.isTrue);
    unittest.expect(
      o.region!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.targetService!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachment--;
}

core.Map<core.String, api.ServiceAttachmentsScopedList> buildUnnamed629() => {
      'x': buildServiceAttachmentsScopedList(),
      'y': buildServiceAttachmentsScopedList(),
    };

void checkUnnamed629(
    core.Map<core.String, api.ServiceAttachmentsScopedList> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAttachmentsScopedList(o['x']!);
  checkServiceAttachmentsScopedList(o['y']!);
}

core.List<core.String> buildUnnamed630() => [
      'foo',
      'foo',
    ];

void checkUnnamed630(core.List<core.String> o) {
  unittest.expect(o, unittest.hasLength(2));
  unittest.expect(
    o[0],
    unittest.equals('foo'),
  );
  unittest.expect(
    o[1],
    unittest.equals('foo'),
  );
}

core.int buildCounterServiceAttachmentAggregatedListWarningData = 0;
api.ServiceAttachmentAggregatedListWarningData
    buildServiceAttachmentAggregatedListWarningData() {
  final o = api.ServiceAttachmentAggregatedListWarningData();
  buildCounterServiceAttachmentAggregatedListWarningData++;
  if (buildCounterServiceAttachmentAggregatedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterServiceAttachmentAggregatedListWarningData--;
  return o;
}

void checkServiceAttachmentAggregatedListWarningData(
    api.ServiceAttachmentAggregatedListWarningData o) {
  buildCounterServiceAttachmentAggregatedListWarningData++;
  if (buildCounterServiceAttachmentAggregatedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachmentAggregatedListWarningData--;
}

core.List<api.ServiceAttachmentAggregatedListWarningData> buildUnnamed631() => [
      buildServiceAttachmentAggregatedListWarningData(),
      buildServiceAttachmentAggregatedListWarningData(),
    ];

void checkUnnamed631(
    core.List<api.ServiceAttachmentAggregatedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAttachmentAggregatedListWarningData(o[0]);
  checkServiceAttachmentAggregatedListWarningData(o[1]);
}

core.int buildCounterServiceAttachmentAggregatedListWarning = 0;
api.ServiceAttachmentAggregatedListWarning
    buildServiceAttachmentAggregatedListWarning() {
  final o = api.ServiceAttachmentAggregatedListWarning();
  buildCounterServiceAttachmentAggregatedListWarning++;
  if (buildCounterServiceAttachmentAggregatedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed631();
    o.message = 'foo';
  }
  buildCounterServiceAttachmentAggregatedListWarning--;
  return o;
}

void checkServiceAttachmentAggregatedListWarning(
    api.ServiceAttachmentAggregatedListWarning o) {
  buildCounterServiceAttachmentAggregatedListWarning++;
  if (buildCounterServiceAttachmentAggregatedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed631(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachmentAggregatedListWarning--;
}

core.int buildCounterServiceAttachmentAggregatedList = 0;
api.ServiceAttachmentAggregatedList buildServiceAttachmentAggregatedList() {
  final o = api.ServiceAttachmentAggregatedList();
  buildCounterServiceAttachmentAggregatedList++;
  if (buildCounterServiceAttachmentAggregatedList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed629();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.unreachables = buildUnnamed630();
    o.warning = buildServiceAttachmentAggregatedListWarning();
  }
  buildCounterServiceAttachmentAggregatedList--;
  return o;
}

void checkServiceAttachmentAggregatedList(
    api.ServiceAttachmentAggregatedList o) {
  buildCounterServiceAttachmentAggregatedList++;
  if (buildCounterServiceAttachmentAggregatedList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed629(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkUnnamed630(o.unreachables!);
    checkServiceAttachmentAggregatedListWarning(o.warning!);
  }
  buildCounterServiceAttachmentAggregatedList--;
}

core.int buildCounterServiceAttachmentConnectedEndpoint = 0;
api.ServiceAttachmentConnectedEndpoint
    buildServiceAttachmentConnectedEndpoint() {
  final o = api.ServiceAttachmentConnectedEndpoint();
  buildCounterServiceAttachmentConnectedEndpoint++;
  if (buildCounterServiceAttachmentConnectedEndpoint < 3) {
    o.consumerNetwork = 'foo';
    o.endpoint = 'foo';
    o.pscConnectionId = 'foo';
    o.status = 'foo';
  }
  buildCounterServiceAttachmentConnectedEndpoint--;
  return o;
}

void checkServiceAttachmentConnectedEndpoint(
    api.ServiceAttachmentConnectedEndpoint o) {
  buildCounterServiceAttachmentConnectedEndpoint++;
  if (buildCounterServiceAttachmentConnectedEndpoint < 3) {
    unittest.expect(
      o.consumerNetwork!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.endpoint!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.pscConnectionId!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.status!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachmentConnectedEndpoint--;
}

core.int buildCounterServiceAttachmentConsumerProjectLimit = 0;
api.ServiceAttachmentConsumerProjectLimit
    buildServiceAttachmentConsumerProjectLimit() {
  final o = api.ServiceAttachmentConsumerProjectLimit();
  buildCounterServiceAttachmentConsumerProjectLimit++;
  if (buildCounterServiceAttachmentConsumerProjectLimit < 3) {
    o.connectionLimit = 42;
    o.networkUrl = 'foo';
    o.projectIdOrNum = 'foo';
  }
  buildCounterServiceAttachmentConsumerProjectLimit--;
  return o;
}

void checkServiceAttachmentConsumerProjectLimit(
    api.ServiceAttachmentConsumerProjectLimit o) {
  buildCounterServiceAttachmentConsumerProjectLimit++;
  if (buildCounterServiceAttachmentConsumerProjectLimit < 3) {
    unittest.expect(
      o.connectionLimit!,
      unittest.equals(42),
    );
    unittest.expect(
      o.networkUrl!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.projectIdOrNum!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachmentConsumerProjectLimit--;
}

core.List<api.ServiceAttachment> buildUnnamed632() => [
      buildServiceAttachment(),
      buildServiceAttachment(),
    ];

void checkUnnamed632(core.List<api.ServiceAttachment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAttachment(o[0]);
  checkServiceAttachment(o[1]);
}

core.int buildCounterServiceAttachmentListWarningData = 0;
api.ServiceAttachmentListWarningData buildServiceAttachmentListWarningData() {
  final o = api.ServiceAttachmentListWarningData();
  buildCounterServiceAttachmentListWarningData++;
  if (buildCounterServiceAttachmentListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterServiceAttachmentListWarningData--;
  return o;
}

void checkServiceAttachmentListWarningData(
    api.ServiceAttachmentListWarningData o) {
  buildCounterServiceAttachmentListWarningData++;
  if (buildCounterServiceAttachmentListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachmentListWarningData--;
}

core.List<api.ServiceAttachmentListWarningData> buildUnnamed633() => [
      buildServiceAttachmentListWarningData(),
      buildServiceAttachmentListWarningData(),
    ];

void checkUnnamed633(core.List<api.ServiceAttachmentListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAttachmentListWarningData(o[0]);
  checkServiceAttachmentListWarningData(o[1]);
}

core.int buildCounterServiceAttachmentListWarning = 0;
api.ServiceAttachmentListWarning buildServiceAttachmentListWarning() {
  final o = api.ServiceAttachmentListWarning();
  buildCounterServiceAttachmentListWarning++;
  if (buildCounterServiceAttachmentListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed633();
    o.message = 'foo';
  }
  buildCounterServiceAttachmentListWarning--;
  return o;
}

void checkServiceAttachmentListWarning(api.ServiceAttachmentListWarning o) {
  buildCounterServiceAttachmentListWarning++;
  if (buildCounterServiceAttachmentListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed633(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachmentListWarning--;
}

core.int buildCounterServiceAttachmentList = 0;
api.ServiceAttachmentList buildServiceAttachmentList() {
  final o = api.ServiceAttachmentList();
  buildCounterServiceAttachmentList++;
  if (buildCounterServiceAttachmentList < 3) {
    o.id = 'foo';
    o.items = buildUnnamed632();
    o.kind = 'foo';
    o.nextPageToken = 'foo';
    o.selfLink = 'foo';
    o.warning = buildServiceAttachmentListWarning();
  }
  buildCounterServiceAttachmentList--;
  return o;
}

void checkServiceAttachmentList(api.ServiceAttachmentList o) {
  buildCounterServiceAttachmentList++;
  if (buildCounterServiceAttachmentList < 3) {
    unittest.expect(
      o.id!,
      unittest.equals('foo'),
    );
    checkUnnamed632(o.items!);
    unittest.expect(
      o.kind!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.nextPageToken!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.selfLink!,
      unittest.equals('foo'),
    );
    checkServiceAttachmentListWarning(o.warning!);
  }
  buildCounterServiceAttachmentList--;
}

core.List<api.ServiceAttachment> buildUnnamed634() => [
      buildServiceAttachment(),
      buildServiceAttachment(),
    ];

void checkUnnamed634(core.List<api.ServiceAttachment> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAttachment(o[0]);
  checkServiceAttachment(o[1]);
}

core.int buildCounterServiceAttachmentsScopedListWarningData = 0;
api.ServiceAttachmentsScopedListWarningData
    buildServiceAttachmentsScopedListWarningData() {
  final o = api.ServiceAttachmentsScopedListWarningData();
  buildCounterServiceAttachmentsScopedListWarningData++;
  if (buildCounterServiceAttachmentsScopedListWarningData < 3) {
    o.key = 'foo';
    o.value = 'foo';
  }
  buildCounterServiceAttachmentsScopedListWarningData--;
  return o;
}

void checkServiceAttachmentsScopedListWarningData(
    api.ServiceAttachmentsScopedListWarningData o) {
  buildCounterServiceAttachmentsScopedListWarningData++;
  if (buildCounterServiceAttachmentsScopedListWarningData < 3) {
    unittest.expect(
      o.key!,
      unittest.equals('foo'),
    );
    unittest.expect(
      o.value!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachmentsScopedListWarningData--;
}

core.List<api.ServiceAttachmentsScopedListWarningData> buildUnnamed635() => [
      buildServiceAttachmentsScopedListWarningData(),
      buildServiceAttachmentsScopedListWarningData(),
    ];

void checkUnnamed635(core.List<api.ServiceAttachmentsScopedListWarningData> o) {
  unittest.expect(o, unittest.hasLength(2));
  checkServiceAttachmentsScopedListWarningData(o[0]);
  checkServiceAttachmentsScopedListWarningData(o[1]);
}

core.int buildCounterServiceAttachmentsScopedListWarning = 0;
api.ServiceAttachmentsScopedListWarning
    buildServiceAttachmentsScopedListWarning() {
  final o = api.ServiceAttachmentsScopedListWarning();
  buildCounterServiceAttachmentsScopedListWarning++;
  if (buildCounterServiceAttachmentsScopedListWarning < 3) {
    o.code = 'foo';
    o.data = buildUnnamed635();
    o.message = 'foo';
  }
  buildCounterServiceAttachmentsScopedListWarning--;
  return o;
}

void checkServiceAttachmentsScopedListWarning(
    api.ServiceAttachmentsScopedListWarning o) {
  buildCounterServiceAttachmentsScopedListWarning++;
  if (buildCounterServiceAttachmentsScopedListWarning < 3) {
    unittest.expect(
      o.code!,
      unittest.equals('foo'),
    );
    checkUnnamed635(o.data!);
    unittest.expect(
      o.message!,
      unittest.equals('foo'),
    );
  }
  buildCounterServiceAttachmentsScopedListWarning--;
}

core.int buildCounterServiceAttachmentsScopedList = 0;
api.ServiceAttachmentsScopedList buildServiceAttachmentsScopedList() {
  final o = api.ServiceAttachmentsScopedList();
  buildCounterServiceAttachmentsScopedList++;
  if (buildCounterServiceAttachmentsScopedList < 3) {
    o.serviceAttachments = buildUnnamed634();
    o.warning = buildServiceAttachmentsScopedListWarning();
  }
  buildCounterServiceAttachmentsScopedList--;
  return o;
}

void checkServiceAttachmentsScopedList(api.ServiceAttachmentsScopedList o) {
  buildCounterServiceAttachmentsScopedList++;
  if (buildCounterServiceAttachmentsScopedList < 3) {
    checkUnnamed634(o.serviceAttachments!);
    checkServiceAttachmentsScopedListWarning(o.warning!);
  }
  buildCounterServiceAttachmentsScopedList--;
}

core.Map<core.String,
        api.SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo>
    buildUnnamed636() => {
          'x':
              buildSetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo(),
          'y':
              buildSetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo(),
        };

void checkUnnamed636(
    core.Map<
            core.String,
            api
            .SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo>
        o) {
  unittest.expect(o, unittest.hasLength(2));
  checkSetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo(
      o['x']!);
  checkSetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo(
      o['y']!);
}

core.int buildCounterSetCommonInstanceMetadataOperationMetadata = 0;
api.SetCommonInstanceMetadataOperationMetadata
    buildSetCommonInstanceMetadataOperationMetadata() {
  final o = api.SetCommonInstanceMetadataOperationMetadata();
  buildCounterSetCommonInstanceMetadataOperationMetadata++;
  if (buildCounterSetCommonInstanceMetadataOperationMetadata < 3) {
    o.clientOperationId = 'foo';
    o.perLocationOperations = buildUnnamed636();
  }
  buildCounterSetCommonInstanceMetadataOperationMetadata--;
  return o;
}

void checkSetCommonInstanceMetadataOperationMetadata(
    api.SetCommonInstanceMetadataOperationMetadata o) {
  buildCounterSetCommonInstanceMetadataOperationMetadata++;
  if (buildCounterSetCommonInstanceMetadataOperationMetadata < 3) {
    unit