/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.StringCodec;
import java.util.Locale;

public class LifecycleChannel {
    private static final String TAG = "LifecycleChannel";
    private static final String CHANNEL_NAME = "flutter/lifecycle";
    private AppLifecycleState lastAndroidState = null;
    private AppLifecycleState lastFlutterState = null;
    private boolean lastFocus = true;
    @NonNull
    private final BasicMessageChannel<String> channel;

    public LifecycleChannel(@NonNull DartExecutor dartExecutor) {
        this(new BasicMessageChannel<String>(dartExecutor, CHANNEL_NAME, StringCodec.INSTANCE));
    }

    @VisibleForTesting
    public LifecycleChannel(@NonNull BasicMessageChannel<String> channel) {
        this.channel = channel;
    }

    private void sendState(AppLifecycleState state, boolean hasFocus) {
        if (this.lastAndroidState == state && hasFocus == this.lastFocus) {
            return;
        }
        if (state == null && this.lastAndroidState == null) {
            this.lastFocus = hasFocus;
            return;
        }
        AppLifecycleState newState = null;
        switch (state.ordinal()) {
            case 1: {
                newState = hasFocus ? AppLifecycleState.RESUMED : AppLifecycleState.INACTIVE;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                newState = state;
            }
        }
        this.lastAndroidState = state;
        this.lastFocus = hasFocus;
        if (newState == this.lastFlutterState) {
            return;
        }
        String message = "AppLifecycleState." + newState.name().toLowerCase(Locale.ROOT);
        Log.v(TAG, "Sending " + message + " message.");
        this.channel.send(message);
        this.lastFlutterState = newState;
    }

    public void aWindowIsFocused() {
        this.sendState(this.lastAndroidState, true);
    }

    public void noWindowsAreFocused() {
        this.sendState(this.lastAndroidState, false);
    }

    public void appIsResumed() {
        this.sendState(AppLifecycleState.RESUMED, this.lastFocus);
    }

    public void appIsInactive() {
        this.sendState(AppLifecycleState.INACTIVE, this.lastFocus);
    }

    public void appIsPaused() {
        this.sendState(AppLifecycleState.PAUSED, this.lastFocus);
    }

    public void appIsDetached() {
        this.sendState(AppLifecycleState.DETACHED, this.lastFocus);
    }

    private static enum AppLifecycleState {
        DETACHED,
        RESUMED,
        INACTIVE,
        HIDDEN,
        PAUSED;

    }
}

