// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// While it's not (currently) necessary, add some noise here to push down token
// positions in this file compared to the file regress_34841_lib.dart.
// This is to ensure that any possible tokens in that file are just comments
// (i.e. not actual) positions in this file.

import 'dart:developer';

import 'package:test/test.dart';
import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';
import 'regress_34841_lib.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/regress_34841_test.dart
//
const LINE_A = 34;
// AUTOGENERATED END

class Bar extends Object with Foo {}

void testFunction() {
  final bar = Bar();
  print(bar.foo);
  print(bar.baz());
  debugger(); // LINE_A
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  (VmService service, IsolateRef isolateRef) async {
    final isolateId = isolateRef.id!;
    final isolate = await service.getIsolate(isolateId);
    final rootLib = await service.getObject(
      isolateId,
      isolate.rootLib!.id!,
    ) as Library;
    final script = await service.getObject(
      isolateId,
      rootLib.scripts!.first.id!,
    ) as Script;

    final report = await service.getSourceReport(
      isolateId,
      [SourceReportKind.kCoverage],
      scriptId: script.id!,
      forceCompile: true,
    );

    final ranges = report.ranges!;
    final coveragePlaces = <int>[];
    for (final range in ranges) {
      final coverage = range.coverage!;
      for (int i in coverage.hits!) {
        coveragePlaces.add(i);
      }
      for (int i in coverage.misses!) {
        coveragePlaces.add(i);
      }
    }
    expect(ranges, isNotEmpty);

    // Make sure we can translate it all.
    for (int place in coveragePlaces) {
      final int? line = script.getLineNumberFromTokenPos(place);
      final int? column = script.getColumnNumberFromTokenPos(place);
      if (line == null || column == null) {
        throw 'Token $place translated to $line:$column';
      }
    }
  },
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'regress_34841_test.dart',
      testeeConcurrent: testFunction,
    );
