/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.editing;

import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextEditingDelta {
    private CharSequence oldText;
    private CharSequence deltaText;
    private int deltaStart;
    private int deltaEnd;
    private int newSelectionStart;
    private int newSelectionEnd;
    private int newComposingStart;
    private int newComposingEnd;
    private static final String TAG = "TextEditingDelta";

    public TextEditingDelta(CharSequence oldEditable, int replacementDestinationStart, int replacementDestinationEnd, CharSequence replacementSource, int selectionStart, int selectionEnd, int composingStart, int composingEnd) {
        this.newSelectionStart = selectionStart;
        this.newSelectionEnd = selectionEnd;
        this.newComposingStart = composingStart;
        this.newComposingEnd = composingEnd;
        this.setDeltas(oldEditable, replacementSource.toString(), replacementDestinationStart, replacementDestinationEnd);
    }

    public TextEditingDelta(CharSequence oldText, int selectionStart, int selectionEnd, int composingStart, int composingEnd) {
        this.newSelectionStart = selectionStart;
        this.newSelectionEnd = selectionEnd;
        this.newComposingStart = composingStart;
        this.newComposingEnd = composingEnd;
        this.setDeltas(oldText, "", -1, -1);
    }

    @VisibleForTesting
    public CharSequence getOldText() {
        return this.oldText;
    }

    @VisibleForTesting
    public CharSequence getDeltaText() {
        return this.deltaText;
    }

    @VisibleForTesting
    public int getDeltaStart() {
        return this.deltaStart;
    }

    @VisibleForTesting
    public int getDeltaEnd() {
        return this.deltaEnd;
    }

    @VisibleForTesting
    public int getNewSelectionStart() {
        return this.newSelectionStart;
    }

    @VisibleForTesting
    public int getNewSelectionEnd() {
        return this.newSelectionEnd;
    }

    @VisibleForTesting
    public int getNewComposingStart() {
        return this.newComposingStart;
    }

    @VisibleForTesting
    public int getNewComposingEnd() {
        return this.newComposingEnd;
    }

    private void setDeltas(CharSequence oldText, CharSequence newText, int newStart, int newExtent) {
        this.oldText = oldText;
        this.deltaText = newText;
        this.deltaStart = newStart;
        this.deltaEnd = newExtent;
    }

    public JSONObject toJSON() {
        JSONObject delta = new JSONObject();
        try {
            delta.put("oldText", (Object)this.oldText.toString());
            delta.put("deltaText", (Object)this.deltaText.toString());
            delta.put("deltaStart", this.deltaStart);
            delta.put("deltaEnd", this.deltaEnd);
            delta.put("selectionBase", this.newSelectionStart);
            delta.put("selectionExtent", this.newSelectionEnd);
            delta.put("composingBase", this.newComposingStart);
            delta.put("composingExtent", this.newComposingEnd);
        }
        catch (JSONException e) {
            Log.e(TAG, "unable to create JSONObject: " + (Object)((Object)e));
        }
        return delta;
    }
}

