// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import 'src/google_fonts_base.dart';
import 'src/google_fonts_descriptor.dart';
import 'src/google_fonts_variant.dart';

/// A collection of properties used to specify custom behavior of the
/// GoogleFonts library.
class _Config {
  /// Whether or not the GoogleFonts library can make requests to
  /// [fonts.google.com](https://fonts.google.com/) to retrieve font files.
  var allowRuntimeFetching = true;
}

class GoogleFonts {
  /// Configuration for the [GoogleFonts] library.
  ///
  /// Use this to define custom behavior of the GoogleFonts library in your app.
  /// For example, if you do not want the GoogleFonts library to make any http
  /// requests for fonts, add the following snippet to your app's `main` method.
  ///
  /// ```dart
  /// GoogleFonts.config.allowRuntimeFetching = false;
  /// ```
  static final config = _Config();

  /// Get a map of all available fonts.
  ///
  /// Returns a map where the key is the name of the font family and the value
  /// is the corresponding [GoogleFonts] method.
  static Map<
      String,
      TextStyle Function({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  })> asMap() => const {
        'ABeeZee': GoogleFonts.aBeeZee,
        'Abel': GoogleFonts.abel,
        'Abhaya Libre': GoogleFonts.abhayaLibre,
        'Abril Fatface': GoogleFonts.abrilFatface,
        'Aclonica': GoogleFonts.aclonica,
        'Acme': GoogleFonts.acme,
        'Actor': GoogleFonts.actor,
        'Adamina': GoogleFonts.adamina,
        'Advent Pro': GoogleFonts.adventPro,
        'Aguafina Script': GoogleFonts.aguafinaScript,
        'Akronim': GoogleFonts.akronim,
        'Aladin': GoogleFonts.aladin,
        'Alata': GoogleFonts.alata,
        'Alatsi': GoogleFonts.alatsi,
        'Aldrich': GoogleFonts.aldrich,
        'Alef': GoogleFonts.alef,
        'Alegreya': GoogleFonts.alegreya,
        'Alegreya SC': GoogleFonts.alegreyaSc,
        'Alegreya Sans': GoogleFonts.alegreyaSans,
        'Alegreya Sans SC': GoogleFonts.alegreyaSansSc,
        'Aleo': GoogleFonts.aleo,
        'Alex Brush': GoogleFonts.alexBrush,
        'Alfa Slab One': GoogleFonts.alfaSlabOne,
        'Alice': GoogleFonts.alice,
        'Alike': GoogleFonts.alike,
        'Alike Angular': GoogleFonts.alikeAngular,
        'Allan': GoogleFonts.allan,
        'Allerta': GoogleFonts.allerta,
        'Allerta Stencil': GoogleFonts.allertaStencil,
        'Allura': GoogleFonts.allura,
        'Almarai': GoogleFonts.almarai,
        'Almendra': GoogleFonts.almendra,
        'Almendra Display': GoogleFonts.almendraDisplay,
        'Almendra SC': GoogleFonts.almendraSc,
        'Amarante': GoogleFonts.amarante,
        'Amaranth': GoogleFonts.amaranth,
        'Amatic SC': GoogleFonts.amaticSc,
        'Amatica SC': GoogleFonts.amaticaSc,
        'Amethysta': GoogleFonts.amethysta,
        'Amiko': GoogleFonts.amiko,
        'Amiri': GoogleFonts.amiri,
        'Amita': GoogleFonts.amita,
        'Anaheim': GoogleFonts.anaheim,
        'Andada': GoogleFonts.andada,
        'Andika': GoogleFonts.andika,
        'Andika New Basic': GoogleFonts.andikaNewBasic,
        'Annie Use Your Telescope': GoogleFonts.annieUseYourTelescope,
        'Anonymous Pro': GoogleFonts.anonymousPro,
        'Antic': GoogleFonts.antic,
        'Antic Didone': GoogleFonts.anticDidone,
        'Antic Slab': GoogleFonts.anticSlab,
        'Anton': GoogleFonts.anton,
        'Arapey': GoogleFonts.arapey,
        'Arbutus': GoogleFonts.arbutus,
        'Arbutus Slab': GoogleFonts.arbutusSlab,
        'Architects Daughter': GoogleFonts.architectsDaughter,
        'Archivo': GoogleFonts.archivo,
        'Archivo Black': GoogleFonts.archivoBlack,
        'Archivo Narrow': GoogleFonts.archivoNarrow,
        'Aref Ruqaa': GoogleFonts.arefRuqaa,
        'Arima Madurai': GoogleFonts.arimaMadurai,
        'Arimo': GoogleFonts.arimo,
        'Arizonia': GoogleFonts.arizonia,
        'Armata': GoogleFonts.armata,
        'Arsenal': GoogleFonts.arsenal,
        'Artifika': GoogleFonts.artifika,
        'Arvo': GoogleFonts.arvo,
        'Arya': GoogleFonts.arya,
        'Asap': GoogleFonts.asap,
        'Asar': GoogleFonts.asar,
        'Asset': GoogleFonts.asset,
        'Assistant': GoogleFonts.assistant,
        'Astloch': GoogleFonts.astloch,
        'Asul': GoogleFonts.asul,
        'Athiti': GoogleFonts.athiti,
        'Atma': GoogleFonts.atma,
        'Atomic Age': GoogleFonts.atomicAge,
        'Aubrey': GoogleFonts.aubrey,
        'Audiowide': GoogleFonts.audiowide,
        'Autour One': GoogleFonts.autourOne,
        'Average': GoogleFonts.average,
        'Average Sans': GoogleFonts.averageSans,
        'Averia Gruesa Libre': GoogleFonts.averiaGruesaLibre,
        'Averia Libre': GoogleFonts.averiaLibre,
        'Averia Sans Libre': GoogleFonts.averiaSansLibre,
        'Averia Serif Libre': GoogleFonts.averiaSerifLibre,
        'B612': GoogleFonts.b612,
        'B612 Mono': GoogleFonts.b612Mono,
        'Bad Script': GoogleFonts.badScript,
        'Bahiana': GoogleFonts.bahiana,
        'Bahianita': GoogleFonts.bahianita,
        'Bai Jamjuree': GoogleFonts.baiJamjuree,
        'Baloo': GoogleFonts.baloo,
        'Baloo Bhai': GoogleFonts.balooBhai,
        'Baloo Bhaijaan': GoogleFonts.balooBhaijaan,
        'Baloo Bhaina': GoogleFonts.balooBhaina,
        'Baloo Chettan': GoogleFonts.balooChettan,
        'Baloo Da': GoogleFonts.balooDa,
        'Baloo Paaji': GoogleFonts.balooPaaji,
        'Baloo Tamma': GoogleFonts.balooTamma,
        'Baloo Tammudu': GoogleFonts.balooTammudu,
        'Baloo Thambi': GoogleFonts.balooThambi,
        'Balsamiq Sans': GoogleFonts.balsamiqSans,
        'Balthazar': GoogleFonts.balthazar,
        'Bangers': GoogleFonts.bangers,
        'Barlow': GoogleFonts.barlow,
        'Barlow Condensed': GoogleFonts.barlowCondensed,
        'Barlow Semi Condensed': GoogleFonts.barlowSemiCondensed,
        'Barriecito': GoogleFonts.barriecito,
        'Barrio': GoogleFonts.barrio,
        'Basic': GoogleFonts.basic,
        'Baskervville': GoogleFonts.baskervville,
        'Baumans': GoogleFonts.baumans,
        'Be Vietnam': GoogleFonts.beVietnam,
        'Bebas Neue': GoogleFonts.bebasNeue,
        'Belgrano': GoogleFonts.belgrano,
        'Bellefair': GoogleFonts.bellefair,
        'Belleza': GoogleFonts.belleza,
        'Bellota': GoogleFonts.bellota,
        'Bellota Text': GoogleFonts.bellotaText,
        'BenchNine': GoogleFonts.benchNine,
        'Bentham': GoogleFonts.bentham,
        'Berkshire Swash': GoogleFonts.berkshireSwash,
        'Beth Ellen': GoogleFonts.bethEllen,
        'Bevan': GoogleFonts.bevan,
        'Big Shoulders Display': GoogleFonts.bigShouldersDisplay,
        'Big Shoulders Inline Display': GoogleFonts.bigShouldersInlineDisplay,
        'Big Shoulders Inline Text': GoogleFonts.bigShouldersInlineText,
        'Big Shoulders Stencil Display': GoogleFonts.bigShouldersStencilDisplay,
        'Big Shoulders Stencil Text': GoogleFonts.bigShouldersStencilText,
        'Big Shoulders Text': GoogleFonts.bigShouldersText,
        'Bigelow Rules': GoogleFonts.bigelowRules,
        'Bigshot One': GoogleFonts.bigshotOne,
        'Bilbo': GoogleFonts.bilbo,
        'Bilbo Swash Caps': GoogleFonts.bilboSwashCaps,
        'BioRhyme': GoogleFonts.bioRhyme,
        'BioRhyme Expanded': GoogleFonts.bioRhymeExpanded,
        'Biryani': GoogleFonts.biryani,
        'Bitter': GoogleFonts.bitter,
        'Black And White Picture': GoogleFonts.blackAndWhitePicture,
        'Black Han Sans': GoogleFonts.blackHanSans,
        'Black Ops One': GoogleFonts.blackOpsOne,
        'Blinker': GoogleFonts.blinker,
        'Bonbon': GoogleFonts.bonbon,
        'Boogaloo': GoogleFonts.boogaloo,
        'Bowlby One': GoogleFonts.bowlbyOne,
        'Bowlby One SC': GoogleFonts.bowlbyOneSc,
        'Brawler': GoogleFonts.brawler,
        'Bree Serif': GoogleFonts.breeSerif,
        'Bubblegum Sans': GoogleFonts.bubblegumSans,
        'Bubbler One': GoogleFonts.bubblerOne,
        'Buda': GoogleFonts.buda,
        'Buenard': GoogleFonts.buenard,
        'Bungee': GoogleFonts.bungee,
        'Bungee Hairline': GoogleFonts.bungeeHairline,
        'Bungee Inline': GoogleFonts.bungeeInline,
        'Bungee Outline': GoogleFonts.bungeeOutline,
        'Bungee Shade': GoogleFonts.bungeeShade,
        'Butcherman': GoogleFonts.butcherman,
        'Butterfly Kids': GoogleFonts.butterflyKids,
        'Cabin': GoogleFonts.cabin,
        'Cabin Condensed': GoogleFonts.cabinCondensed,
        'Cabin Sketch': GoogleFonts.cabinSketch,
        'Caesar Dressing': GoogleFonts.caesarDressing,
        'Cagliostro': GoogleFonts.cagliostro,
        'Cairo': GoogleFonts.cairo,
        'Caladea': GoogleFonts.caladea,
        'Calistoga': GoogleFonts.calistoga,
        'Calligraffitti': GoogleFonts.calligraffitti,
        'Cambay': GoogleFonts.cambay,
        'Cambo': GoogleFonts.cambo,
        'Candal': GoogleFonts.candal,
        'Cantarell': GoogleFonts.cantarell,
        'Cantata One': GoogleFonts.cantataOne,
        'Cantora One': GoogleFonts.cantoraOne,
        'Capriola': GoogleFonts.capriola,
        'Cardo': GoogleFonts.cardo,
        'Carme': GoogleFonts.carme,
        'Carrois Gothic': GoogleFonts.carroisGothic,
        'Carrois Gothic SC': GoogleFonts.carroisGothicSc,
        'Carter One': GoogleFonts.carterOne,
        'Castoro': GoogleFonts.castoro,
        'Catamaran': GoogleFonts.catamaran,
        'Caudex': GoogleFonts.caudex,
        'Caveat': GoogleFonts.caveat,
        'Caveat Brush': GoogleFonts.caveatBrush,
        'Cedarville Cursive': GoogleFonts.cedarvilleCursive,
        'Ceviche One': GoogleFonts.cevicheOne,
        'Chakra Petch': GoogleFonts.chakraPetch,
        'Changa': GoogleFonts.changa,
        'Changa One': GoogleFonts.changaOne,
        'Chango': GoogleFonts.chango,
        'Charm': GoogleFonts.charm,
        'Charmonman': GoogleFonts.charmonman,
        'Chathura': GoogleFonts.chathura,
        'Chau Philomene One': GoogleFonts.chauPhilomeneOne,
        'Chela One': GoogleFonts.chelaOne,
        'Chelsea Market': GoogleFonts.chelseaMarket,
        'Cherry Cream Soda': GoogleFonts.cherryCreamSoda,
        'Cherry Swash': GoogleFonts.cherrySwash,
        'Chewy': GoogleFonts.chewy,
        'Chicle': GoogleFonts.chicle,
        'Chilanka': GoogleFonts.chilanka,
        'Chivo': GoogleFonts.chivo,
        'Chonburi': GoogleFonts.chonburi,
        'Cinzel': GoogleFonts.cinzel,
        'Cinzel Decorative': GoogleFonts.cinzelDecorative,
        'Clicker Script': GoogleFonts.clickerScript,
        'Coda': GoogleFonts.coda,
        'Coda Caption': GoogleFonts.codaCaption,
        'Codystar': GoogleFonts.codystar,
        'Coiny': GoogleFonts.coiny,
        'Combo': GoogleFonts.combo,
        'Comfortaa': GoogleFonts.comfortaa,
        'Comic Neue': GoogleFonts.comicNeue,
        'Coming Soon': GoogleFonts.comingSoon,
        'Commissioner': GoogleFonts.commissioner,
        'Concert One': GoogleFonts.concertOne,
        'Condiment': GoogleFonts.condiment,
        'Contrail One': GoogleFonts.contrailOne,
        'Convergence': GoogleFonts.convergence,
        'Cookie': GoogleFonts.cookie,
        'Copse': GoogleFonts.copse,
        'Corben': GoogleFonts.corben,
        'Cormorant': GoogleFonts.cormorant,
        'Cormorant Garamond': GoogleFonts.cormorantGaramond,
        'Cormorant Infant': GoogleFonts.cormorantInfant,
        'Cormorant SC': GoogleFonts.cormorantSc,
        'Cormorant Unicase': GoogleFonts.cormorantUnicase,
        'Cormorant Upright': GoogleFonts.cormorantUpright,
        'Courgette': GoogleFonts.courgette,
        'Courier Prime': GoogleFonts.courierPrime,
        'Cousine': GoogleFonts.cousine,
        'Coustard': GoogleFonts.coustard,
        'Covered By Your Grace': GoogleFonts.coveredByYourGrace,
        'Crafty Girls': GoogleFonts.craftyGirls,
        'Creepster': GoogleFonts.creepster,
        'Crete Round': GoogleFonts.creteRound,
        'Crimson Pro': GoogleFonts.crimsonPro,
        'Crimson Text': GoogleFonts.crimsonText,
        'Croissant One': GoogleFonts.croissantOne,
        'Crushed': GoogleFonts.crushed,
        'Cuprum': GoogleFonts.cuprum,
        'Cute Font': GoogleFonts.cuteFont,
        'Cutive': GoogleFonts.cutive,
        'Cutive Mono': GoogleFonts.cutiveMono,
        'DM Mono': GoogleFonts.dmMono,
        'DM Sans': GoogleFonts.dmSans,
        'DM Serif Display': GoogleFonts.dmSerifDisplay,
        'DM Serif Text': GoogleFonts.dmSerifText,
        'Damion': GoogleFonts.damion,
        'Dancing Script': GoogleFonts.dancingScript,
        'Darker Grotesque': GoogleFonts.darkerGrotesque,
        'David Libre': GoogleFonts.davidLibre,
        'Dawning of a New Day': GoogleFonts.dawningOfANewDay,
        'Days One': GoogleFonts.daysOne,
        'Dekko': GoogleFonts.dekko,
        'Delius': GoogleFonts.delius,
        'Delius Swash Caps': GoogleFonts.deliusSwashCaps,
        'Delius Unicase': GoogleFonts.deliusUnicase,
        'Della Respira': GoogleFonts.dellaRespira,
        'Denk One': GoogleFonts.denkOne,
        'Devonshire': GoogleFonts.devonshire,
        'Dhurjati': GoogleFonts.dhurjati,
        'Didact Gothic': GoogleFonts.didactGothic,
        'Diplomata': GoogleFonts.diplomata,
        'Diplomata SC': GoogleFonts.diplomataSc,
        'Do Hyeon': GoogleFonts.doHyeon,
        'Dokdo': GoogleFonts.dokdo,
        'Domine': GoogleFonts.domine,
        'Donegal One': GoogleFonts.donegalOne,
        'Doppio One': GoogleFonts.doppioOne,
        'Dorsa': GoogleFonts.dorsa,
        'Dosis': GoogleFonts.dosis,
        'Dr Sugiyama': GoogleFonts.drSugiyama,
        'Droid Sans': GoogleFonts.droidSans,
        'Droid Sans Mono': GoogleFonts.droidSansMono,
        'Droid Serif': GoogleFonts.droidSerif,
        'Duru Sans': GoogleFonts.duruSans,
        'Dynalight': GoogleFonts.dynalight,
        'EB Garamond': GoogleFonts.ebGaramond,
        'Eagle Lake': GoogleFonts.eagleLake,
        'East Sea Dokdo': GoogleFonts.eastSeaDokdo,
        'Eater': GoogleFonts.eater,
        'Economica': GoogleFonts.economica,
        'Eczar': GoogleFonts.eczar,
        'El Messiri': GoogleFonts.elMessiri,
        'Electrolize': GoogleFonts.electrolize,
        'Elsie': GoogleFonts.elsie,
        'Elsie Swash Caps': GoogleFonts.elsieSwashCaps,
        'Emblema One': GoogleFonts.emblemaOne,
        'Emilys Candy': GoogleFonts.emilysCandy,
        'Encode Sans': GoogleFonts.encodeSans,
        'Encode Sans Condensed': GoogleFonts.encodeSansCondensed,
        'Encode Sans Expanded': GoogleFonts.encodeSansExpanded,
        'Encode Sans Semi Condensed': GoogleFonts.encodeSansSemiCondensed,
        'Encode Sans Semi Expanded': GoogleFonts.encodeSansSemiExpanded,
        'Engagement': GoogleFonts.engagement,
        'Englebert': GoogleFonts.englebert,
        'Enriqueta': GoogleFonts.enriqueta,
        'Epilogue': GoogleFonts.epilogue,
        'Erica One': GoogleFonts.ericaOne,
        'Esteban': GoogleFonts.esteban,
        'Euphoria Script': GoogleFonts.euphoriaScript,
        'Ewert': GoogleFonts.ewert,
        'Exo': GoogleFonts.exo,
        'Exo 2': GoogleFonts.exo2,
        'Expletus Sans': GoogleFonts.expletusSans,
        'Fahkwang': GoogleFonts.fahkwang,
        'Fanwood Text': GoogleFonts.fanwoodText,
        'Farro': GoogleFonts.farro,
        'Farsan': GoogleFonts.farsan,
        'Fascinate': GoogleFonts.fascinate,
        'Fascinate Inline': GoogleFonts.fascinateInline,
        'Faster One': GoogleFonts.fasterOne,
        'Fauna One': GoogleFonts.faunaOne,
        'Faustina': GoogleFonts.faustina,
        'Federant': GoogleFonts.federant,
        'Federo': GoogleFonts.federo,
        'Felipa': GoogleFonts.felipa,
        'Fenix': GoogleFonts.fenix,
        'Finger Paint': GoogleFonts.fingerPaint,
        'Fira Code': GoogleFonts.firaCode,
        'Fira Mono': GoogleFonts.firaMono,
        'Fira Sans': GoogleFonts.firaSans,
        'Fira Sans Condensed': GoogleFonts.firaSansCondensed,
        'Fira Sans Extra Condensed': GoogleFonts.firaSansExtraCondensed,
        'Fjalla One': GoogleFonts.fjallaOne,
        'Fjord One': GoogleFonts.fjordOne,
        'Flamenco': GoogleFonts.flamenco,
        'Flavors': GoogleFonts.flavors,
        'Fondamento': GoogleFonts.fondamento,
        'Fontdiner Swanky': GoogleFonts.fontdinerSwanky,
        'Forum': GoogleFonts.forum,
        'Francois One': GoogleFonts.francoisOne,
        'Frank Ruhl Libre': GoogleFonts.frankRuhlLibre,
        'Fraunces': GoogleFonts.fraunces,
        'Freckle Face': GoogleFonts.freckleFace,
        'Fredericka the Great': GoogleFonts.frederickaTheGreat,
        'Fredoka One': GoogleFonts.fredokaOne,
        'Fresca': GoogleFonts.fresca,
        'Frijole': GoogleFonts.frijole,
        'Fruktur': GoogleFonts.fruktur,
        'Fugaz One': GoogleFonts.fugazOne,
        'GFS Didot': GoogleFonts.gfsDidot,
        'GFS Neohellenic': GoogleFonts.gfsNeohellenic,
        'Gabriela': GoogleFonts.gabriela,
        'Gaegu': GoogleFonts.gaegu,
        'Gafata': GoogleFonts.gafata,
        'Galada': GoogleFonts.galada,
        'Galdeano': GoogleFonts.galdeano,
        'Galindo': GoogleFonts.galindo,
        'Gamja Flower': GoogleFonts.gamjaFlower,
        'Gayathri': GoogleFonts.gayathri,
        'Gelasio': GoogleFonts.gelasio,
        'Gentium Basic': GoogleFonts.gentiumBasic,
        'Gentium Book Basic': GoogleFonts.gentiumBookBasic,
        'Geo': GoogleFonts.geo,
        'Geostar': GoogleFonts.geostar,
        'Geostar Fill': GoogleFonts.geostarFill,
        'Germania One': GoogleFonts.germaniaOne,
        'Gidugu': GoogleFonts.gidugu,
        'Gilda Display': GoogleFonts.gildaDisplay,
        'Girassol': GoogleFonts.girassol,
        'Give You Glory': GoogleFonts.giveYouGlory,
        'Glass Antiqua': GoogleFonts.glassAntiqua,
        'Glegoo': GoogleFonts.glegoo,
        'Gloria Hallelujah': GoogleFonts.gloriaHallelujah,
        'Goblin One': GoogleFonts.goblinOne,
        'Gochi Hand': GoogleFonts.gochiHand,
        'Goldman': GoogleFonts.goldman,
        'Gorditas': GoogleFonts.gorditas,
        'Gothic A1': GoogleFonts.gothicA1,
        'Gotu': GoogleFonts.gotu,
        'Goudy Bookletter 1911': GoogleFonts.goudyBookletter1911,
        'Graduate': GoogleFonts.graduate,
        'Grand Hotel': GoogleFonts.grandHotel,
        'Grandstander': GoogleFonts.grandstander,
        'Gravitas One': GoogleFonts.gravitasOne,
        'Great Vibes': GoogleFonts.greatVibes,
        'Grenze': GoogleFonts.grenze,
        'Grenze Gotisch': GoogleFonts.grenzeGotisch,
        'Griffy': GoogleFonts.griffy,
        'Gruppo': GoogleFonts.gruppo,
        'Gudea': GoogleFonts.gudea,
        'Gugi': GoogleFonts.gugi,
        'Gupter': GoogleFonts.gupter,
        'Gurajada': GoogleFonts.gurajada,
        'Habibi': GoogleFonts.habibi,
        'Hachi Maru Pop': GoogleFonts.hachiMaruPop,
        'Halant': GoogleFonts.halant,
        'Hammersmith One': GoogleFonts.hammersmithOne,
        'Hanalei': GoogleFonts.hanalei,
        'Hanalei Fill': GoogleFonts.hanaleiFill,
        'Handlee': GoogleFonts.handlee,
        'Happy Monkey': GoogleFonts.happyMonkey,
        'Harmattan': GoogleFonts.harmattan,
        'Headland One': GoogleFonts.headlandOne,
        'Heebo': GoogleFonts.heebo,
        'Henny Penny': GoogleFonts.hennyPenny,
        'Hepta Slab': GoogleFonts.heptaSlab,
        'Herr Von Muellerhoff': GoogleFonts.herrVonMuellerhoff,
        'Hi Melody': GoogleFonts.hiMelody,
        'Hind': GoogleFonts.hind,
        'Hind Guntur': GoogleFonts.hindGuntur,
        'Hind Madurai': GoogleFonts.hindMadurai,
        'Hind Siliguri': GoogleFonts.hindSiliguri,
        'Hind Vadodara': GoogleFonts.hindVadodara,
        'Holtwood One SC': GoogleFonts.holtwoodOneSc,
        'Homemade Apple': GoogleFonts.homemadeApple,
        'Homenaje': GoogleFonts.homenaje,
        'IBM Plex Mono': GoogleFonts.ibmPlexMono,
        'IBM Plex Sans': GoogleFonts.ibmPlexSans,
        'IBM Plex Sans Condensed': GoogleFonts.ibmPlexSansCondensed,
        'IBM Plex Serif': GoogleFonts.ibmPlexSerif,
        'IM Fell DW Pica': GoogleFonts.imFellDwPica,
        'IM Fell DW Pica SC': GoogleFonts.imFellDwPicaSc,
        'IM Fell Double Pica': GoogleFonts.imFellDoublePica,
        'IM Fell Double Pica SC': GoogleFonts.imFellDoublePicaSc,
        'IM Fell English': GoogleFonts.imFellEnglish,
        'IM Fell English SC': GoogleFonts.imFellEnglishSc,
        'IM Fell French Canon': GoogleFonts.imFellFrenchCanon,
        'IM Fell French Canon SC': GoogleFonts.imFellFrenchCanonSc,
        'IM Fell Great Primer': GoogleFonts.imFellGreatPrimer,
        'IM Fell Great Primer SC': GoogleFonts.imFellGreatPrimerSc,
        'Ibarra Real Nova': GoogleFonts.ibarraRealNova,
        'Iceberg': GoogleFonts.iceberg,
        'Iceland': GoogleFonts.iceland,
        'Imprima': GoogleFonts.imprima,
        'Inconsolata': GoogleFonts.inconsolata,
        'Inder': GoogleFonts.inder,
        'Indie Flower': GoogleFonts.indieFlower,
        'Inika': GoogleFonts.inika,
        'Inknut Antiqua': GoogleFonts.inknutAntiqua,
        'Inria Sans': GoogleFonts.inriaSans,
        'Inria Serif': GoogleFonts.inriaSerif,
        'Inter': GoogleFonts.inter,
        'Irish Grover': GoogleFonts.irishGrover,
        'Istok Web': GoogleFonts.istokWeb,
        'Italiana': GoogleFonts.italiana,
        'Italianno': GoogleFonts.italianno,
        'Itim': GoogleFonts.itim,
        'Jacques Francois': GoogleFonts.jacquesFrancois,
        'Jacques Francois Shadow': GoogleFonts.jacquesFrancoisShadow,
        'Jaldi': GoogleFonts.jaldi,
        'JetBrains Mono': GoogleFonts.jetBrainsMono,
        'Jim Nightshade': GoogleFonts.jimNightshade,
        'Jockey One': GoogleFonts.jockeyOne,
        'Jolly Lodger': GoogleFonts.jollyLodger,
        'Jomhuria': GoogleFonts.jomhuria,
        'Jomolhari': GoogleFonts.jomolhari,
        'Josefin Sans': GoogleFonts.josefinSans,
        'Josefin Slab': GoogleFonts.josefinSlab,
        'Jost': GoogleFonts.jost,
        'Joti One': GoogleFonts.jotiOne,
        'Jua': GoogleFonts.jua,
        'Judson': GoogleFonts.judson,
        'Julee': GoogleFonts.julee,
        'Julius Sans One': GoogleFonts.juliusSansOne,
        'Junge': GoogleFonts.junge,
        'Jura': GoogleFonts.jura,
        'Just Another Hand': GoogleFonts.justAnotherHand,
        'Just Me Again Down Here': GoogleFonts.justMeAgainDownHere,
        'K2D': GoogleFonts.k2d,
        'Kadwa': GoogleFonts.kadwa,
        'Kalam': GoogleFonts.kalam,
        'Kameron': GoogleFonts.kameron,
        'Kanit': GoogleFonts.kanit,
        'Kantumruy': GoogleFonts.kantumruy,
        'Karla': GoogleFonts.karla,
        'Karma': GoogleFonts.karma,
        'Katibeh': GoogleFonts.katibeh,
        'Kaushan Script': GoogleFonts.kaushanScript,
        'Kavivanar': GoogleFonts.kavivanar,
        'Kavoon': GoogleFonts.kavoon,
        'Kdam Thmor': GoogleFonts.kdamThmor,
        'Keania One': GoogleFonts.keaniaOne,
        'Kelly Slab': GoogleFonts.kellySlab,
        'Kenia': GoogleFonts.kenia,
        'Khand': GoogleFonts.khand,
        'Khula': GoogleFonts.khula,
        'Kirang Haerang': GoogleFonts.kirangHaerang,
        'Kite One': GoogleFonts.kiteOne,
        'Knewave': GoogleFonts.knewave,
        'KoHo': GoogleFonts.koHo,
        'Kodchasan': GoogleFonts.kodchasan,
        'Kosugi': GoogleFonts.kosugi,
        'Kosugi Maru': GoogleFonts.kosugiMaru,
        'Kotta One': GoogleFonts.kottaOne,
        'Kranky': GoogleFonts.kranky,
        'Kreon': GoogleFonts.kreon,
        'Kristi': GoogleFonts.kristi,
        'Krona One': GoogleFonts.kronaOne,
        'Krub': GoogleFonts.krub,
        'Kufam': GoogleFonts.kufam,
        'Kulim Park': GoogleFonts.kulimPark,
        'Kumar One': GoogleFonts.kumarOne,
        'Kumar One Outline': GoogleFonts.kumarOneOutline,
        'Kumbh Sans': GoogleFonts.kumbhSans,
        'Kurale': GoogleFonts.kurale,
        'La Belle Aurore': GoogleFonts.laBelleAurore,
        'Lacquer': GoogleFonts.lacquer,
        'Laila': GoogleFonts.laila,
        'Lakki Reddy': GoogleFonts.lakkiReddy,
        'Lalezar': GoogleFonts.lalezar,
        'Lancelot': GoogleFonts.lancelot,
        'Langar': GoogleFonts.langar,
        'Lateef': GoogleFonts.lateef,
        'Lato': GoogleFonts.lato,
        'League Script': GoogleFonts.leagueScript,
        'Leckerli One': GoogleFonts.leckerliOne,
        'Ledger': GoogleFonts.ledger,
        'Lekton': GoogleFonts.lekton,
        'Lemon': GoogleFonts.lemon,
        'Lemonada': GoogleFonts.lemonada,
        'Lexend Deca': GoogleFonts.lexendDeca,
        'Lexend Exa': GoogleFonts.lexendExa,
        'Lexend Giga': GoogleFonts.lexendGiga,
        'Lexend Mega': GoogleFonts.lexendMega,
        'Lexend Peta': GoogleFonts.lexendPeta,
        'Lexend Tera': GoogleFonts.lexendTera,
        'Lexend Zetta': GoogleFonts.lexendZetta,
        'Libre Barcode 128': GoogleFonts.libreBarcode128,
        'Libre Barcode 128 Text': GoogleFonts.libreBarcode128Text,
        'Libre Barcode 39': GoogleFonts.libreBarcode39,
        'Libre Barcode 39 Extended': GoogleFonts.libreBarcode39Extended,
        'Libre Barcode 39 Extended Text':
            GoogleFonts.libreBarcode39ExtendedText,
        'Libre Barcode 39 Text': GoogleFonts.libreBarcode39Text,
        'Libre Baskerville': GoogleFonts.libreBaskerville,
        'Libre Caslon Display': GoogleFonts.libreCaslonDisplay,
        'Libre Caslon Text': GoogleFonts.libreCaslonText,
        'Libre Franklin': GoogleFonts.libreFranklin,
        'Life Savers': GoogleFonts.lifeSavers,
        'Lilita One': GoogleFonts.lilitaOne,
        'Lily Script One': GoogleFonts.lilyScriptOne,
        'Limelight': GoogleFonts.limelight,
        'Linden Hill': GoogleFonts.lindenHill,
        'Literata': GoogleFonts.literata,
        'Liu Jian Mao Cao': GoogleFonts.liuJianMaoCao,
        'Livvic': GoogleFonts.livvic,
        'Lobster': GoogleFonts.lobster,
        'Lobster Two': GoogleFonts.lobsterTwo,
        'Londrina Outline': GoogleFonts.londrinaOutline,
        'Londrina Shadow': GoogleFonts.londrinaShadow,
        'Londrina Sketch': GoogleFonts.londrinaSketch,
        'Londrina Solid': GoogleFonts.londrinaSolid,
        'Long Cang': GoogleFonts.longCang,
        'Lora': GoogleFonts.lora,
        'Love Ya Like A Sister': GoogleFonts.loveYaLikeASister,
        'Loved by the King': GoogleFonts.lovedByTheKing,
        'Lovers Quarrel': GoogleFonts.loversQuarrel,
        'Luckiest Guy': GoogleFonts.luckiestGuy,
        'Lusitana': GoogleFonts.lusitana,
        'Lustria': GoogleFonts.lustria,
        'M PLUS 1p': GoogleFonts.mPlus1p,
        'M PLUS Rounded 1c': GoogleFonts.mPlusRounded1c,
        'Ma Shan Zheng': GoogleFonts.maShanZheng,
        'Macondo': GoogleFonts.macondo,
        'Macondo Swash Caps': GoogleFonts.macondoSwashCaps,
        'Mada': GoogleFonts.mada,
        'Magra': GoogleFonts.magra,
        'Maiden Orange': GoogleFonts.maidenOrange,
        'Maitree': GoogleFonts.maitree,
        'Major Mono Display': GoogleFonts.majorMonoDisplay,
        'Mako': GoogleFonts.mako,
        'Mali': GoogleFonts.mali,
        'Mallanna': GoogleFonts.mallanna,
        'Mandali': GoogleFonts.mandali,
        'Manjari': GoogleFonts.manjari,
        'Manrope': GoogleFonts.manrope,
        'Mansalva': GoogleFonts.mansalva,
        'Manuale': GoogleFonts.manuale,
        'Marcellus': GoogleFonts.marcellus,
        'Marcellus SC': GoogleFonts.marcellusSc,
        'Marck Script': GoogleFonts.marckScript,
        'Margarine': GoogleFonts.margarine,
        'Markazi Text': GoogleFonts.markaziText,
        'Marko One': GoogleFonts.markoOne,
        'Marmelad': GoogleFonts.marmelad,
        'Martel': GoogleFonts.martel,
        'Martel Sans': GoogleFonts.martelSans,
        'Marvel': GoogleFonts.marvel,
        'Mate': GoogleFonts.mate,
        'Mate SC': GoogleFonts.mateSc,
        'Maven Pro': GoogleFonts.mavenPro,
        'McLaren': GoogleFonts.mcLaren,
        'Meddon': GoogleFonts.meddon,
        'MedievalSharp': GoogleFonts.medievalSharp,
        'Medula One': GoogleFonts.medulaOne,
        'Meera Inimai': GoogleFonts.meeraInimai,
        'Megrim': GoogleFonts.megrim,
        'Meie Script': GoogleFonts.meieScript,
        'Merienda': GoogleFonts.merienda,
        'Merienda One': GoogleFonts.meriendaOne,
        'Merriweather': GoogleFonts.merriweather,
        'Merriweather Sans': GoogleFonts.merriweatherSans,
        'Metal Mania': GoogleFonts.metalMania,
        'Metamorphous': GoogleFonts.metamorphous,
        'Metrophobic': GoogleFonts.metrophobic,
        'Michroma': GoogleFonts.michroma,
        'Milonga': GoogleFonts.milonga,
        'Miltonian': GoogleFonts.miltonian,
        'Miltonian Tattoo': GoogleFonts.miltonianTattoo,
        'Mina': GoogleFonts.mina,
        'Miniver': GoogleFonts.miniver,
        'Miriam Libre': GoogleFonts.miriamLibre,
        'Mirza': GoogleFonts.mirza,
        'Miss Fajardose': GoogleFonts.missFajardose,
        'Mitr': GoogleFonts.mitr,
        'Modak': GoogleFonts.modak,
        'Modern Antiqua': GoogleFonts.modernAntiqua,
        'Mogra': GoogleFonts.mogra,
        'Molengo': GoogleFonts.molengo,
        'Molle': GoogleFonts.molle,
        'Monda': GoogleFonts.monda,
        'Monofett': GoogleFonts.monofett,
        'Monoton': GoogleFonts.monoton,
        'Monsieur La Doulaise': GoogleFonts.monsieurLaDoulaise,
        'Montaga': GoogleFonts.montaga,
        'Montez': GoogleFonts.montez,
        'Montserrat': GoogleFonts.montserrat,
        'Montserrat Alternates': GoogleFonts.montserratAlternates,
        'Montserrat Subrayada': GoogleFonts.montserratSubrayada,
        'Mountains of Christmas': GoogleFonts.mountainsOfChristmas,
        'Mouse Memoirs': GoogleFonts.mouseMemoirs,
        'Mr Bedfort': GoogleFonts.mrBedfort,
        'Mr Dafoe': GoogleFonts.mrDafoe,
        'Mr De Haviland': GoogleFonts.mrDeHaviland,
        'Mrs Saint Delafield': GoogleFonts.mrsSaintDelafield,
        'Mrs Sheppards': GoogleFonts.mrsSheppards,
        'Mukta': GoogleFonts.mukta,
        'Mukta Mahee': GoogleFonts.muktaMahee,
        'Mukta Malar': GoogleFonts.muktaMalar,
        'Mukta Vaani': GoogleFonts.muktaVaani,
        'Mulish': GoogleFonts.mulish,
        'MuseoModerno': GoogleFonts.museoModerno,
        'Mystery Quest': GoogleFonts.mysteryQuest,
        'NTR': GoogleFonts.ntr,
        'Nanum Brush Script': GoogleFonts.nanumBrushScript,
        'Nanum Gothic': GoogleFonts.nanumGothic,
        'Nanum Gothic Coding': GoogleFonts.nanumGothicCoding,
        'Nanum Myeongjo': GoogleFonts.nanumMyeongjo,
        'Nanum Pen Script': GoogleFonts.nanumPenScript,
        'Nerko One': GoogleFonts.nerkoOne,
        'Neucha': GoogleFonts.neucha,
        'Neuton': GoogleFonts.neuton,
        'New Rocker': GoogleFonts.newRocker,
        'News Cycle': GoogleFonts.newsCycle,
        'Niconne': GoogleFonts.niconne,
        'Niramit': GoogleFonts.niramit,
        'Nixie One': GoogleFonts.nixieOne,
        'Nobile': GoogleFonts.nobile,
        'Norican': GoogleFonts.norican,
        'Nosifer': GoogleFonts.nosifer,
        'Notable': GoogleFonts.notable,
        'Nothing You Could Do': GoogleFonts.nothingYouCouldDo,
        'Noticia Text': GoogleFonts.noticiaText,
        'Noto Color Emoji Compat': GoogleFonts.notoColorEmojiCompat,
        'Noto Sans': GoogleFonts.notoSans,
        'Noto Serif': GoogleFonts.notoSerif,
        'Nova Cut': GoogleFonts.novaCut,
        'Nova Flat': GoogleFonts.novaFlat,
        'Nova Mono': GoogleFonts.novaMono,
        'Nova Oval': GoogleFonts.novaOval,
        'Nova Round': GoogleFonts.novaRound,
        'Nova Script': GoogleFonts.novaScript,
        'Nova Slim': GoogleFonts.novaSlim,
        'Nova Square': GoogleFonts.novaSquare,
        'Numans': GoogleFonts.numans,
        'Nunito': GoogleFonts.nunito,
        'Nunito Sans': GoogleFonts.nunitoSans,
        'Odibee Sans': GoogleFonts.odibeeSans,
        'Odor Mean Chey': GoogleFonts.odorMeanChey,
        'Offside': GoogleFonts.offside,
        'Old Standard TT': GoogleFonts.oldStandardTt,
        'Oldenburg': GoogleFonts.oldenburg,
        'Oleo Script': GoogleFonts.oleoScript,
        'Oleo Script Swash Caps': GoogleFonts.oleoScriptSwashCaps,
        'Open Sans': GoogleFonts.openSans,
        'Open Sans Condensed': GoogleFonts.openSansCondensed,
        'Oranienbaum': GoogleFonts.oranienbaum,
        'Orbitron': GoogleFonts.orbitron,
        'Oregano': GoogleFonts.oregano,
        'Orienta': GoogleFonts.orienta,
        'Original Surfer': GoogleFonts.originalSurfer,
        'Oswald': GoogleFonts.oswald,
        'Over the Rainbow': GoogleFonts.overTheRainbow,
        'Overlock': GoogleFonts.overlock,
        'Overlock SC': GoogleFonts.overlockSc,
        'Overpass': GoogleFonts.overpass,
        'Overpass Mono': GoogleFonts.overpassMono,
        'Ovo': GoogleFonts.ovo,
        'Oxanium': GoogleFonts.oxanium,
        'Oxygen': GoogleFonts.oxygen,
        'Oxygen Mono': GoogleFonts.oxygenMono,
        'PT Mono': GoogleFonts.ptMono,
        'PT Sans': GoogleFonts.ptSans,
        'PT Sans Caption': GoogleFonts.ptSansCaption,
        'PT Sans Narrow': GoogleFonts.ptSansNarrow,
        'PT Serif': GoogleFonts.ptSerif,
        'PT Serif Caption': GoogleFonts.ptSerifCaption,
        'Pacifico': GoogleFonts.pacifico,
        'Padauk': GoogleFonts.padauk,
        'Palanquin': GoogleFonts.palanquin,
        'Palanquin Dark': GoogleFonts.palanquinDark,
        'Pangolin': GoogleFonts.pangolin,
        'Paprika': GoogleFonts.paprika,
        'Parisienne': GoogleFonts.parisienne,
        'Passero One': GoogleFonts.passeroOne,
        'Passion One': GoogleFonts.passionOne,
        'Pathway Gothic One': GoogleFonts.pathwayGothicOne,
        'Patrick Hand': GoogleFonts.patrickHand,
        'Patrick Hand SC': GoogleFonts.patrickHandSc,
        'Pattaya': GoogleFonts.pattaya,
        'Patua One': GoogleFonts.patuaOne,
        'Pavanam': GoogleFonts.pavanam,
        'Paytone One': GoogleFonts.paytoneOne,
        'Peddana': GoogleFonts.peddana,
        'Peralta': GoogleFonts.peralta,
        'Permanent Marker': GoogleFonts.permanentMarker,
        'Petit Formal Script': GoogleFonts.petitFormalScript,
        'Petrona': GoogleFonts.petrona,
        'Philosopher': GoogleFonts.philosopher,
        'Piazzolla': GoogleFonts.piazzolla,
        'Piedra': GoogleFonts.piedra,
        'Pinyon Script': GoogleFonts.pinyonScript,
        'Pirata One': GoogleFonts.pirataOne,
        'Plaster': GoogleFonts.plaster,
        'Play': GoogleFonts.play,
        'Playball': GoogleFonts.playball,
        'Playfair Display': GoogleFonts.playfairDisplay,
        'Playfair Display SC': GoogleFonts.playfairDisplaySc,
        'Podkova': GoogleFonts.podkova,
        'Poiret One': GoogleFonts.poiretOne,
        'Poller One': GoogleFonts.pollerOne,
        'Poly': GoogleFonts.poly,
        'Pompiere': GoogleFonts.pompiere,
        'Pontano Sans': GoogleFonts.pontanoSans,
        'Poor Story': GoogleFonts.poorStory,
        'Poppins': GoogleFonts.poppins,
        'Port Lligat Sans': GoogleFonts.portLligatSans,
        'Port Lligat Slab': GoogleFonts.portLligatSlab,
        'Potta One': GoogleFonts.pottaOne,
        'Pragati Narrow': GoogleFonts.pragatiNarrow,
        'Prata': GoogleFonts.prata,
        'Press Start 2P': GoogleFonts.pressStart2p,
        'Pridi': GoogleFonts.pridi,
        'Princess Sofia': GoogleFonts.princessSofia,
        'Prociono': GoogleFonts.prociono,
        'Prompt': GoogleFonts.prompt,
        'Prosto One': GoogleFonts.prostoOne,
        'Proza Libre': GoogleFonts.prozaLibre,
        'Public Sans': GoogleFonts.publicSans,
        'Puritan': GoogleFonts.puritan,
        'Purple Purse': GoogleFonts.purplePurse,
        'Quando': GoogleFonts.quando,
        'Quantico': GoogleFonts.quantico,
        'Quattrocento': GoogleFonts.quattrocento,
        'Quattrocento Sans': GoogleFonts.quattrocentoSans,
        'Questrial': GoogleFonts.questrial,
        'Quicksand': GoogleFonts.quicksand,
        'Quintessential': GoogleFonts.quintessential,
        'Qwigley': GoogleFonts.qwigley,
        'Racing Sans One': GoogleFonts.racingSansOne,
        'Radley': GoogleFonts.radley,
        'Rajdhani': GoogleFonts.rajdhani,
        'Rakkas': GoogleFonts.rakkas,
        'Raleway': GoogleFonts.raleway,
        'Raleway Dots': GoogleFonts.ralewayDots,
        'Ramabhadra': GoogleFonts.ramabhadra,
        'Ramaraja': GoogleFonts.ramaraja,
        'Rambla': GoogleFonts.rambla,
        'Rammetto One': GoogleFonts.rammettoOne,
        'Ranchers': GoogleFonts.ranchers,
        'Rancho': GoogleFonts.rancho,
        'Ranga': GoogleFonts.ranga,
        'Rasa': GoogleFonts.rasa,
        'Rationale': GoogleFonts.rationale,
        'Ravi Prakash': GoogleFonts.raviPrakash,
        'Recursive': GoogleFonts.recursive,
        'Red Hat Display': GoogleFonts.redHatDisplay,
        'Red Hat Text': GoogleFonts.redHatText,
        'Red Rose': GoogleFonts.redRose,
        'Redressed': GoogleFonts.redressed,
        'Reem Kufi': GoogleFonts.reemKufi,
        'Reenie Beanie': GoogleFonts.reenieBeanie,
        'Revalia': GoogleFonts.revalia,
        'Rhodium Libre': GoogleFonts.rhodiumLibre,
        'Ribeye': GoogleFonts.ribeye,
        'Ribeye Marrow': GoogleFonts.ribeyeMarrow,
        'Righteous': GoogleFonts.righteous,
        'Risque': GoogleFonts.risque,
        'Roboto': GoogleFonts.roboto,
        'Roboto Condensed': GoogleFonts.robotoCondensed,
        'Roboto Mono': GoogleFonts.robotoMono,
        'Roboto Slab': GoogleFonts.robotoSlab,
        'Rochester': GoogleFonts.rochester,
        'Rock Salt': GoogleFonts.rockSalt,
        'Rokkitt': GoogleFonts.rokkitt,
        'Romanesco': GoogleFonts.romanesco,
        'Ropa Sans': GoogleFonts.ropaSans,
        'Rosario': GoogleFonts.rosario,
        'Rosarivo': GoogleFonts.rosarivo,
        'Rouge Script': GoogleFonts.rougeScript,
        'Rowdies': GoogleFonts.rowdies,
        'Rozha One': GoogleFonts.rozhaOne,
        'Rubik': GoogleFonts.rubik,
        'Rubik Mono One': GoogleFonts.rubikMonoOne,
        'Ruda': GoogleFonts.ruda,
        'Rufina': GoogleFonts.rufina,
        'Ruge Boogie': GoogleFonts.rugeBoogie,
        'Ruluko': GoogleFonts.ruluko,
        'Rum Raisin': GoogleFonts.rumRaisin,
        'Ruslan Display': GoogleFonts.ruslanDisplay,
        'Russo One': GoogleFonts.russoOne,
        'Ruthie': GoogleFonts.ruthie,
        'Rye': GoogleFonts.rye,
        'Sacramento': GoogleFonts.sacramento,
        'Sahitya': GoogleFonts.sahitya,
        'Sail': GoogleFonts.sail,
        'Saira': GoogleFonts.saira,
        'Saira Condensed': GoogleFonts.sairaCondensed,
        'Saira Extra Condensed': GoogleFonts.sairaExtraCondensed,
        'Saira Semi Condensed': GoogleFonts.sairaSemiCondensed,
        'Saira Stencil One': GoogleFonts.sairaStencilOne,
        'Salsa': GoogleFonts.salsa,
        'Sanchez': GoogleFonts.sanchez,
        'Sancreek': GoogleFonts.sancreek,
        'Sansita': GoogleFonts.sansita,
        'Sansita Swashed': GoogleFonts.sansitaSwashed,
        'Sarabun': GoogleFonts.sarabun,
        'Sarala': GoogleFonts.sarala,
        'Sarina': GoogleFonts.sarina,
        'Sarpanch': GoogleFonts.sarpanch,
        'Satisfy': GoogleFonts.satisfy,
        'Sawarabi Gothic': GoogleFonts.sawarabiGothic,
        'Sawarabi Mincho': GoogleFonts.sawarabiMincho,
        'Scada': GoogleFonts.scada,
        'Scheherazade': GoogleFonts.scheherazade,
        'Schoolbell': GoogleFonts.schoolbell,
        'Scope One': GoogleFonts.scopeOne,
        'Seaweed Script': GoogleFonts.seaweedScript,
        'Secular One': GoogleFonts.secularOne,
        'Sedgwick Ave': GoogleFonts.sedgwickAve,
        'Sedgwick Ave Display': GoogleFonts.sedgwickAveDisplay,
        'Sen': GoogleFonts.sen,
        'Sevillana': GoogleFonts.sevillana,
        'Seymour One': GoogleFonts.seymourOne,
        'Shadows Into Light': GoogleFonts.shadowsIntoLight,
        'Shadows Into Light Two': GoogleFonts.shadowsIntoLightTwo,
        'Shanti': GoogleFonts.shanti,
        'Share': GoogleFonts.share,
        'Share Tech': GoogleFonts.shareTech,
        'Share Tech Mono': GoogleFonts.shareTechMono,
        'Shojumaru': GoogleFonts.shojumaru,
        'Short Stack': GoogleFonts.shortStack,
        'Shrikhand': GoogleFonts.shrikhand,
        'Sigmar One': GoogleFonts.sigmarOne,
        'Signika': GoogleFonts.signika,
        'Signika Negative': GoogleFonts.signikaNegative,
        'Simonetta': GoogleFonts.simonetta,
        'Single Day': GoogleFonts.singleDay,
        'Sintony': GoogleFonts.sintony,
        'Sirin Stencil': GoogleFonts.sirinStencil,
        'Six Caps': GoogleFonts.sixCaps,
        'Skranji': GoogleFonts.skranji,
        'Slabo 13px': GoogleFonts.slabo13px,
        'Slabo 27px': GoogleFonts.slabo27px,
        'Slackey': GoogleFonts.slackey,
        'Smokum': GoogleFonts.smokum,
        'Smythe': GoogleFonts.smythe,
        'Sniglet': GoogleFonts.sniglet,
        'Snippet': GoogleFonts.snippet,
        'Snowburst One': GoogleFonts.snowburstOne,
        'Sofadi One': GoogleFonts.sofadiOne,
        'Sofia': GoogleFonts.sofia,
        'Solway': GoogleFonts.solway,
        'Song Myung': GoogleFonts.songMyung,
        'Sonsie One': GoogleFonts.sonsieOne,
        'Sora': GoogleFonts.sora,
        'Sorts Mill Goudy': GoogleFonts.sortsMillGoudy,
        'Source Code Pro': GoogleFonts.sourceCodePro,
        'Source Sans Pro': GoogleFonts.sourceSansPro,
        'Source Serif Pro': GoogleFonts.sourceSerifPro,
        'Space Grotesk': GoogleFonts.spaceGrotesk,
        'Space Mono': GoogleFonts.spaceMono,
        'Spartan': GoogleFonts.spartan,
        'Special Elite': GoogleFonts.specialElite,
        'Spectral': GoogleFonts.spectral,
        'Spectral SC': GoogleFonts.spectralSc,
        'Spicy Rice': GoogleFonts.spicyRice,
        'Spinnaker': GoogleFonts.spinnaker,
        'Spirax': GoogleFonts.spirax,
        'Squada One': GoogleFonts.squadaOne,
        'Sree Krushnadevaraya': GoogleFonts.sreeKrushnadevaraya,
        'Sriracha': GoogleFonts.sriracha,
        'Srisakdi': GoogleFonts.srisakdi,
        'Staatliches': GoogleFonts.staatliches,
        'Stalemate': GoogleFonts.stalemate,
        'Stalinist One': GoogleFonts.stalinistOne,
        'Stardos Stencil': GoogleFonts.stardosStencil,
        'Stint Ultra Condensed': GoogleFonts.stintUltraCondensed,
        'Stint Ultra Expanded': GoogleFonts.stintUltraExpanded,
        'Stoke': GoogleFonts.stoke,
        'Strait': GoogleFonts.strait,
        'Stylish': GoogleFonts.stylish,
        'Sue Ellen Francisco': GoogleFonts.sueEllenFrancisco,
        'Suez One': GoogleFonts.suezOne,
        'Sulphur Point': GoogleFonts.sulphurPoint,
        'Sumana': GoogleFonts.sumana,
        'Sunflower': GoogleFonts.sunflower,
        'Sunshiney': GoogleFonts.sunshiney,
        'Supermercado One': GoogleFonts.supermercadoOne,
        'Sura': GoogleFonts.sura,
        'Suranna': GoogleFonts.suranna,
        'Suravaram': GoogleFonts.suravaram,
        'Swanky and Moo Moo': GoogleFonts.swankyAndMooMoo,
        'Syncopate': GoogleFonts.syncopate,
        'Syne': GoogleFonts.syne,
        'Syne Mono': GoogleFonts.syneMono,
        'Syne Tactile': GoogleFonts.syneTactile,
        'Tajawal': GoogleFonts.tajawal,
        'Tangerine': GoogleFonts.tangerine,
        'Tauri': GoogleFonts.tauri,
        'Taviraj': GoogleFonts.taviraj,
        'Teko': GoogleFonts.teko,
        'Telex': GoogleFonts.telex,
        'Tenali Ramakrishna': GoogleFonts.tenaliRamakrishna,
        'Tenor Sans': GoogleFonts.tenorSans,
        'Text Me One': GoogleFonts.textMeOne,
        'Thasadith': GoogleFonts.thasadith,
        'The Girl Next Door': GoogleFonts.theGirlNextDoor,
        'Tienne': GoogleFonts.tienne,
        'Tillana': GoogleFonts.tillana,
        'Timmana': GoogleFonts.timmana,
        'Tinos': GoogleFonts.tinos,
        'Titan One': GoogleFonts.titanOne,
        'Titillium Web': GoogleFonts.titilliumWeb,
        'Tomorrow': GoogleFonts.tomorrow,
        'Trade Winds': GoogleFonts.tradeWinds,
        'Trirong': GoogleFonts.trirong,
        'Trispace': GoogleFonts.trispace,
        'Trocchi': GoogleFonts.trocchi,
        'Trochut': GoogleFonts.trochut,
        'Trykker': GoogleFonts.trykker,
        'Tulpen One': GoogleFonts.tulpenOne,
        'Turret Road': GoogleFonts.turretRoad,
        'Ubuntu': GoogleFonts.ubuntu,
        'Ubuntu Condensed': GoogleFonts.ubuntuCondensed,
        'Ubuntu Mono': GoogleFonts.ubuntuMono,
        'Ultra': GoogleFonts.ultra,
        'Uncial Antiqua': GoogleFonts.uncialAntiqua,
        'Underdog': GoogleFonts.underdog,
        'Unica One': GoogleFonts.unicaOne,
        'UnifrakturCook': GoogleFonts.unifrakturCook,
        'UnifrakturMaguntia': GoogleFonts.unifrakturMaguntia,
        'Unkempt': GoogleFonts.unkempt,
        'Unlock': GoogleFonts.unlock,
        'Unna': GoogleFonts.unna,
        'VT323': GoogleFonts.vt323,
        'Vampiro One': GoogleFonts.vampiroOne,
        'Varela': GoogleFonts.varela,
        'Varela Round': GoogleFonts.varelaRound,
        'Varta': GoogleFonts.varta,
        'Vast Shadow': GoogleFonts.vastShadow,
        'Vesper Libre': GoogleFonts.vesperLibre,
        'Viaoda Libre': GoogleFonts.viaodaLibre,
        'Vibes': GoogleFonts.vibes,
        'Vibur': GoogleFonts.vibur,
        'Vidaloka': GoogleFonts.vidaloka,
        'Viga': GoogleFonts.viga,
        'Voces': GoogleFonts.voces,
        'Volkhov': GoogleFonts.volkhov,
        'Vollkorn': GoogleFonts.vollkorn,
        'Vollkorn SC': GoogleFonts.vollkornSc,
        'Voltaire': GoogleFonts.voltaire,
        'Waiting for the Sunrise': GoogleFonts.waitingForTheSunrise,
        'Wallpoet': GoogleFonts.wallpoet,
        'Walter Turncoat': GoogleFonts.walterTurncoat,
        'Warnes': GoogleFonts.warnes,
        'Wellfleet': GoogleFonts.wellfleet,
        'Wendy One': GoogleFonts.wendyOne,
        'Wire One': GoogleFonts.wireOne,
        'Work Sans': GoogleFonts.workSans,
        'Xanh Mono': GoogleFonts.xanhMono,
        'Yanone Kaffeesatz': GoogleFonts.yanoneKaffeesatz,
        'Yantramanav': GoogleFonts.yantramanav,
        'Yatra One': GoogleFonts.yatraOne,
        'Yellowtail': GoogleFonts.yellowtail,
        'Yeon Sung': GoogleFonts.yeonSung,
        'Yeseva One': GoogleFonts.yesevaOne,
        'Yesteryear': GoogleFonts.yesteryear,
        'Yrsa': GoogleFonts.yrsa,
        'Yusei Magic': GoogleFonts.yuseiMagic,
        'ZCOOL KuaiLe': GoogleFonts.zcoolKuaiLe,
        'ZCOOL QingKe HuangYou': GoogleFonts.zcoolQingKeHuangYou,
        'ZCOOL XiaoWei': GoogleFonts.zcoolXiaoWei,
        'Zeyada': GoogleFonts.zeyada,
        'Zhi Mang Xing': GoogleFonts.zhiMangXing,
        'Zilla Slab': GoogleFonts.zillaSlab,
        'Zilla Slab Highlight': GoogleFonts.zillaSlabHighlight,
      };

  /// Get a map of all available fonts and their associated text themes.
  ///
  /// Returns a map where the key is the name of the font family and the value
  /// is the corresponding [GoogleFonts] `TextTheme` method.
  static Map<String, TextTheme Function([TextTheme?])> _asMapOfTextThemes() =>
      const {
        'ABeeZee': GoogleFonts.aBeeZeeTextTheme,
        'Abel': GoogleFonts.abelTextTheme,
        'Abhaya Libre': GoogleFonts.abhayaLibreTextTheme,
        'Abril Fatface': GoogleFonts.abrilFatfaceTextTheme,
        'Aclonica': GoogleFonts.aclonicaTextTheme,
        'Acme': GoogleFonts.acmeTextTheme,
        'Actor': GoogleFonts.actorTextTheme,
        'Adamina': GoogleFonts.adaminaTextTheme,
        'Advent Pro': GoogleFonts.adventProTextTheme,
        'Aguafina Script': GoogleFonts.aguafinaScriptTextTheme,
        'Akronim': GoogleFonts.akronimTextTheme,
        'Aladin': GoogleFonts.aladinTextTheme,
        'Alata': GoogleFonts.alataTextTheme,
        'Alatsi': GoogleFonts.alatsiTextTheme,
        'Aldrich': GoogleFonts.aldrichTextTheme,
        'Alef': GoogleFonts.alefTextTheme,
        'Alegreya': GoogleFonts.alegreyaTextTheme,
        'Alegreya SC': GoogleFonts.alegreyaScTextTheme,
        'Alegreya Sans': GoogleFonts.alegreyaSansTextTheme,
        'Alegreya Sans SC': GoogleFonts.alegreyaSansScTextTheme,
        'Aleo': GoogleFonts.aleoTextTheme,
        'Alex Brush': GoogleFonts.alexBrushTextTheme,
        'Alfa Slab One': GoogleFonts.alfaSlabOneTextTheme,
        'Alice': GoogleFonts.aliceTextTheme,
        'Alike': GoogleFonts.alikeTextTheme,
        'Alike Angular': GoogleFonts.alikeAngularTextTheme,
        'Allan': GoogleFonts.allanTextTheme,
        'Allerta': GoogleFonts.allertaTextTheme,
        'Allerta Stencil': GoogleFonts.allertaStencilTextTheme,
        'Allura': GoogleFonts.alluraTextTheme,
        'Almarai': GoogleFonts.almaraiTextTheme,
        'Almendra': GoogleFonts.almendraTextTheme,
        'Almendra Display': GoogleFonts.almendraDisplayTextTheme,
        'Almendra SC': GoogleFonts.almendraScTextTheme,
        'Amarante': GoogleFonts.amaranteTextTheme,
        'Amaranth': GoogleFonts.amaranthTextTheme,
        'Amatic SC': GoogleFonts.amaticScTextTheme,
        'Amatica SC': GoogleFonts.amaticaScTextTheme,
        'Amethysta': GoogleFonts.amethystaTextTheme,
        'Amiko': GoogleFonts.amikoTextTheme,
        'Amiri': GoogleFonts.amiriTextTheme,
        'Amita': GoogleFonts.amitaTextTheme,
        'Anaheim': GoogleFonts.anaheimTextTheme,
        'Andada': GoogleFonts.andadaTextTheme,
        'Andika': GoogleFonts.andikaTextTheme,
        'Andika New Basic': GoogleFonts.andikaNewBasicTextTheme,
        'Annie Use Your Telescope': GoogleFonts.annieUseYourTelescopeTextTheme,
        'Anonymous Pro': GoogleFonts.anonymousProTextTheme,
        'Antic': GoogleFonts.anticTextTheme,
        'Antic Didone': GoogleFonts.anticDidoneTextTheme,
        'Antic Slab': GoogleFonts.anticSlabTextTheme,
        'Anton': GoogleFonts.antonTextTheme,
        'Arapey': GoogleFonts.arapeyTextTheme,
        'Arbutus': GoogleFonts.arbutusTextTheme,
        'Arbutus Slab': GoogleFonts.arbutusSlabTextTheme,
        'Architects Daughter': GoogleFonts.architectsDaughterTextTheme,
        'Archivo': GoogleFonts.archivoTextTheme,
        'Archivo Black': GoogleFonts.archivoBlackTextTheme,
        'Archivo Narrow': GoogleFonts.archivoNarrowTextTheme,
        'Aref Ruqaa': GoogleFonts.arefRuqaaTextTheme,
        'Arima Madurai': GoogleFonts.arimaMaduraiTextTheme,
        'Arimo': GoogleFonts.arimoTextTheme,
        'Arizonia': GoogleFonts.arizoniaTextTheme,
        'Armata': GoogleFonts.armataTextTheme,
        'Arsenal': GoogleFonts.arsenalTextTheme,
        'Artifika': GoogleFonts.artifikaTextTheme,
        'Arvo': GoogleFonts.arvoTextTheme,
        'Arya': GoogleFonts.aryaTextTheme,
        'Asap': GoogleFonts.asapTextTheme,
        'Asar': GoogleFonts.asarTextTheme,
        'Asset': GoogleFonts.assetTextTheme,
        'Assistant': GoogleFonts.assistantTextTheme,
        'Astloch': GoogleFonts.astlochTextTheme,
        'Asul': GoogleFonts.asulTextTheme,
        'Athiti': GoogleFonts.athitiTextTheme,
        'Atma': GoogleFonts.atmaTextTheme,
        'Atomic Age': GoogleFonts.atomicAgeTextTheme,
        'Aubrey': GoogleFonts.aubreyTextTheme,
        'Audiowide': GoogleFonts.audiowideTextTheme,
        'Autour One': GoogleFonts.autourOneTextTheme,
        'Average': GoogleFonts.averageTextTheme,
        'Average Sans': GoogleFonts.averageSansTextTheme,
        'Averia Gruesa Libre': GoogleFonts.averiaGruesaLibreTextTheme,
        'Averia Libre': GoogleFonts.averiaLibreTextTheme,
        'Averia Sans Libre': GoogleFonts.averiaSansLibreTextTheme,
        'Averia Serif Libre': GoogleFonts.averiaSerifLibreTextTheme,
        'B612': GoogleFonts.b612TextTheme,
        'B612 Mono': GoogleFonts.b612MonoTextTheme,
        'Bad Script': GoogleFonts.badScriptTextTheme,
        'Bahiana': GoogleFonts.bahianaTextTheme,
        'Bahianita': GoogleFonts.bahianitaTextTheme,
        'Bai Jamjuree': GoogleFonts.baiJamjureeTextTheme,
        'Baloo': GoogleFonts.balooTextTheme,
        'Baloo Bhai': GoogleFonts.balooBhaiTextTheme,
        'Baloo Bhaijaan': GoogleFonts.balooBhaijaanTextTheme,
        'Baloo Bhaina': GoogleFonts.balooBhainaTextTheme,
        'Baloo Chettan': GoogleFonts.balooChettanTextTheme,
        'Baloo Da': GoogleFonts.balooDaTextTheme,
        'Baloo Paaji': GoogleFonts.balooPaajiTextTheme,
        'Baloo Tamma': GoogleFonts.balooTammaTextTheme,
        'Baloo Tammudu': GoogleFonts.balooTammuduTextTheme,
        'Baloo Thambi': GoogleFonts.balooThambiTextTheme,
        'Balsamiq Sans': GoogleFonts.balsamiqSansTextTheme,
        'Balthazar': GoogleFonts.balthazarTextTheme,
        'Bangers': GoogleFonts.bangersTextTheme,
        'Barlow': GoogleFonts.barlowTextTheme,
        'Barlow Condensed': GoogleFonts.barlowCondensedTextTheme,
        'Barlow Semi Condensed': GoogleFonts.barlowSemiCondensedTextTheme,
        'Barriecito': GoogleFonts.barriecitoTextTheme,
        'Barrio': GoogleFonts.barrioTextTheme,
        'Basic': GoogleFonts.basicTextTheme,
        'Baskervville': GoogleFonts.baskervvilleTextTheme,
        'Baumans': GoogleFonts.baumansTextTheme,
        'Be Vietnam': GoogleFonts.beVietnamTextTheme,
        'Bebas Neue': GoogleFonts.bebasNeueTextTheme,
        'Belgrano': GoogleFonts.belgranoTextTheme,
        'Bellefair': GoogleFonts.bellefairTextTheme,
        'Belleza': GoogleFonts.bellezaTextTheme,
        'Bellota': GoogleFonts.bellotaTextTheme,
        'Bellota Text': GoogleFonts.bellotaTextTextTheme,
        'BenchNine': GoogleFonts.benchNineTextTheme,
        'Bentham': GoogleFonts.benthamTextTheme,
        'Berkshire Swash': GoogleFonts.berkshireSwashTextTheme,
        'Beth Ellen': GoogleFonts.bethEllenTextTheme,
        'Bevan': GoogleFonts.bevanTextTheme,
        'Big Shoulders Display': GoogleFonts.bigShouldersDisplayTextTheme,
        'Big Shoulders Inline Display':
            GoogleFonts.bigShouldersInlineDisplayTextTheme,
        'Big Shoulders Inline Text':
            GoogleFonts.bigShouldersInlineTextTextTheme,
        'Big Shoulders Stencil Display':
            GoogleFonts.bigShouldersStencilDisplayTextTheme,
        'Big Shoulders Stencil Text':
            GoogleFonts.bigShouldersStencilTextTextTheme,
        'Big Shoulders Text': GoogleFonts.bigShouldersTextTextTheme,
        'Bigelow Rules': GoogleFonts.bigelowRulesTextTheme,
        'Bigshot One': GoogleFonts.bigshotOneTextTheme,
        'Bilbo': GoogleFonts.bilboTextTheme,
        'Bilbo Swash Caps': GoogleFonts.bilboSwashCapsTextTheme,
        'BioRhyme': GoogleFonts.bioRhymeTextTheme,
        'BioRhyme Expanded': GoogleFonts.bioRhymeExpandedTextTheme,
        'Biryani': GoogleFonts.biryaniTextTheme,
        'Bitter': GoogleFonts.bitterTextTheme,
        'Black And White Picture': GoogleFonts.blackAndWhitePictureTextTheme,
        'Black Han Sans': GoogleFonts.blackHanSansTextTheme,
        'Black Ops One': GoogleFonts.blackOpsOneTextTheme,
        'Blinker': GoogleFonts.blinkerTextTheme,
        'Bonbon': GoogleFonts.bonbonTextTheme,
        'Boogaloo': GoogleFonts.boogalooTextTheme,
        'Bowlby One': GoogleFonts.bowlbyOneTextTheme,
        'Bowlby One SC': GoogleFonts.bowlbyOneScTextTheme,
        'Brawler': GoogleFonts.brawlerTextTheme,
        'Bree Serif': GoogleFonts.breeSerifTextTheme,
        'Bubblegum Sans': GoogleFonts.bubblegumSansTextTheme,
        'Bubbler One': GoogleFonts.bubblerOneTextTheme,
        'Buda': GoogleFonts.budaTextTheme,
        'Buenard': GoogleFonts.buenardTextTheme,
        'Bungee': GoogleFonts.bungeeTextTheme,
        'Bungee Hairline': GoogleFonts.bungeeHairlineTextTheme,
        'Bungee Inline': GoogleFonts.bungeeInlineTextTheme,
        'Bungee Outline': GoogleFonts.bungeeOutlineTextTheme,
        'Bungee Shade': GoogleFonts.bungeeShadeTextTheme,
        'Butcherman': GoogleFonts.butchermanTextTheme,
        'Butterfly Kids': GoogleFonts.butterflyKidsTextTheme,
        'Cabin': GoogleFonts.cabinTextTheme,
        'Cabin Condensed': GoogleFonts.cabinCondensedTextTheme,
        'Cabin Sketch': GoogleFonts.cabinSketchTextTheme,
        'Caesar Dressing': GoogleFonts.caesarDressingTextTheme,
        'Cagliostro': GoogleFonts.cagliostroTextTheme,
        'Cairo': GoogleFonts.cairoTextTheme,
        'Caladea': GoogleFonts.caladeaTextTheme,
        'Calistoga': GoogleFonts.calistogaTextTheme,
        'Calligraffitti': GoogleFonts.calligraffittiTextTheme,
        'Cambay': GoogleFonts.cambayTextTheme,
        'Cambo': GoogleFonts.camboTextTheme,
        'Candal': GoogleFonts.candalTextTheme,
        'Cantarell': GoogleFonts.cantarellTextTheme,
        'Cantata One': GoogleFonts.cantataOneTextTheme,
        'Cantora One': GoogleFonts.cantoraOneTextTheme,
        'Capriola': GoogleFonts.capriolaTextTheme,
        'Cardo': GoogleFonts.cardoTextTheme,
        'Carme': GoogleFonts.carmeTextTheme,
        'Carrois Gothic': GoogleFonts.carroisGothicTextTheme,
        'Carrois Gothic SC': GoogleFonts.carroisGothicScTextTheme,
        'Carter One': GoogleFonts.carterOneTextTheme,
        'Castoro': GoogleFonts.castoroTextTheme,
        'Catamaran': GoogleFonts.catamaranTextTheme,
        'Caudex': GoogleFonts.caudexTextTheme,
        'Caveat': GoogleFonts.caveatTextTheme,
        'Caveat Brush': GoogleFonts.caveatBrushTextTheme,
        'Cedarville Cursive': GoogleFonts.cedarvilleCursiveTextTheme,
        'Ceviche One': GoogleFonts.cevicheOneTextTheme,
        'Chakra Petch': GoogleFonts.chakraPetchTextTheme,
        'Changa': GoogleFonts.changaTextTheme,
        'Changa One': GoogleFonts.changaOneTextTheme,
        'Chango': GoogleFonts.changoTextTheme,
        'Charm': GoogleFonts.charmTextTheme,
        'Charmonman': GoogleFonts.charmonmanTextTheme,
        'Chathura': GoogleFonts.chathuraTextTheme,
        'Chau Philomene One': GoogleFonts.chauPhilomeneOneTextTheme,
        'Chela One': GoogleFonts.chelaOneTextTheme,
        'Chelsea Market': GoogleFonts.chelseaMarketTextTheme,
        'Cherry Cream Soda': GoogleFonts.cherryCreamSodaTextTheme,
        'Cherry Swash': GoogleFonts.cherrySwashTextTheme,
        'Chewy': GoogleFonts.chewyTextTheme,
        'Chicle': GoogleFonts.chicleTextTheme,
        'Chilanka': GoogleFonts.chilankaTextTheme,
        'Chivo': GoogleFonts.chivoTextTheme,
        'Chonburi': GoogleFonts.chonburiTextTheme,
        'Cinzel': GoogleFonts.cinzelTextTheme,
        'Cinzel Decorative': GoogleFonts.cinzelDecorativeTextTheme,
        'Clicker Script': GoogleFonts.clickerScriptTextTheme,
        'Coda': GoogleFonts.codaTextTheme,
        'Coda Caption': GoogleFonts.codaCaptionTextTheme,
        'Codystar': GoogleFonts.codystarTextTheme,
        'Coiny': GoogleFonts.coinyTextTheme,
        'Combo': GoogleFonts.comboTextTheme,
        'Comfortaa': GoogleFonts.comfortaaTextTheme,
        'Comic Neue': GoogleFonts.comicNeueTextTheme,
        'Coming Soon': GoogleFonts.comingSoonTextTheme,
        'Commissioner': GoogleFonts.commissionerTextTheme,
        'Concert One': GoogleFonts.concertOneTextTheme,
        'Condiment': GoogleFonts.condimentTextTheme,
        'Contrail One': GoogleFonts.contrailOneTextTheme,
        'Convergence': GoogleFonts.convergenceTextTheme,
        'Cookie': GoogleFonts.cookieTextTheme,
        'Copse': GoogleFonts.copseTextTheme,
        'Corben': GoogleFonts.corbenTextTheme,
        'Cormorant': GoogleFonts.cormorantTextTheme,
        'Cormorant Garamond': GoogleFonts.cormorantGaramondTextTheme,
        'Cormorant Infant': GoogleFonts.cormorantInfantTextTheme,
        'Cormorant SC': GoogleFonts.cormorantScTextTheme,
        'Cormorant Unicase': GoogleFonts.cormorantUnicaseTextTheme,
        'Cormorant Upright': GoogleFonts.cormorantUprightTextTheme,
        'Courgette': GoogleFonts.courgetteTextTheme,
        'Courier Prime': GoogleFonts.courierPrimeTextTheme,
        'Cousine': GoogleFonts.cousineTextTheme,
        'Coustard': GoogleFonts.coustardTextTheme,
        'Covered By Your Grace': GoogleFonts.coveredByYourGraceTextTheme,
        'Crafty Girls': GoogleFonts.craftyGirlsTextTheme,
        'Creepster': GoogleFonts.creepsterTextTheme,
        'Crete Round': GoogleFonts.creteRoundTextTheme,
        'Crimson Pro': GoogleFonts.crimsonProTextTheme,
        'Crimson Text': GoogleFonts.crimsonTextTextTheme,
        'Croissant One': GoogleFonts.croissantOneTextTheme,
        'Crushed': GoogleFonts.crushedTextTheme,
        'Cuprum': GoogleFonts.cuprumTextTheme,
        'Cute Font': GoogleFonts.cuteFontTextTheme,
        'Cutive': GoogleFonts.cutiveTextTheme,
        'Cutive Mono': GoogleFonts.cutiveMonoTextTheme,
        'DM Mono': GoogleFonts.dmMonoTextTheme,
        'DM Sans': GoogleFonts.dmSansTextTheme,
        'DM Serif Display': GoogleFonts.dmSerifDisplayTextTheme,
        'DM Serif Text': GoogleFonts.dmSerifTextTextTheme,
        'Damion': GoogleFonts.damionTextTheme,
        'Dancing Script': GoogleFonts.dancingScriptTextTheme,
        'Darker Grotesque': GoogleFonts.darkerGrotesqueTextTheme,
        'David Libre': GoogleFonts.davidLibreTextTheme,
        'Dawning of a New Day': GoogleFonts.dawningOfANewDayTextTheme,
        'Days One': GoogleFonts.daysOneTextTheme,
        'Dekko': GoogleFonts.dekkoTextTheme,
        'Delius': GoogleFonts.deliusTextTheme,
        'Delius Swash Caps': GoogleFonts.deliusSwashCapsTextTheme,
        'Delius Unicase': GoogleFonts.deliusUnicaseTextTheme,
        'Della Respira': GoogleFonts.dellaRespiraTextTheme,
        'Denk One': GoogleFonts.denkOneTextTheme,
        'Devonshire': GoogleFonts.devonshireTextTheme,
        'Dhurjati': GoogleFonts.dhurjatiTextTheme,
        'Didact Gothic': GoogleFonts.didactGothicTextTheme,
        'Diplomata': GoogleFonts.diplomataTextTheme,
        'Diplomata SC': GoogleFonts.diplomataScTextTheme,
        'Do Hyeon': GoogleFonts.doHyeonTextTheme,
        'Dokdo': GoogleFonts.dokdoTextTheme,
        'Domine': GoogleFonts.domineTextTheme,
        'Donegal One': GoogleFonts.donegalOneTextTheme,
        'Doppio One': GoogleFonts.doppioOneTextTheme,
        'Dorsa': GoogleFonts.dorsaTextTheme,
        'Dosis': GoogleFonts.dosisTextTheme,
        'Dr Sugiyama': GoogleFonts.drSugiyamaTextTheme,
        'Droid Sans': GoogleFonts.droidSansTextTheme,
        'Droid Sans Mono': GoogleFonts.droidSansMonoTextTheme,
        'Droid Serif': GoogleFonts.droidSerifTextTheme,
        'Duru Sans': GoogleFonts.duruSansTextTheme,
        'Dynalight': GoogleFonts.dynalightTextTheme,
        'EB Garamond': GoogleFonts.ebGaramondTextTheme,
        'Eagle Lake': GoogleFonts.eagleLakeTextTheme,
        'East Sea Dokdo': GoogleFonts.eastSeaDokdoTextTheme,
        'Eater': GoogleFonts.eaterTextTheme,
        'Economica': GoogleFonts.economicaTextTheme,
        'Eczar': GoogleFonts.eczarTextTheme,
        'El Messiri': GoogleFonts.elMessiriTextTheme,
        'Electrolize': GoogleFonts.electrolizeTextTheme,
        'Elsie': GoogleFonts.elsieTextTheme,
        'Elsie Swash Caps': GoogleFonts.elsieSwashCapsTextTheme,
        'Emblema One': GoogleFonts.emblemaOneTextTheme,
        'Emilys Candy': GoogleFonts.emilysCandyTextTheme,
        'Encode Sans': GoogleFonts.encodeSansTextTheme,
        'Encode Sans Condensed': GoogleFonts.encodeSansCondensedTextTheme,
        'Encode Sans Expanded': GoogleFonts.encodeSansExpandedTextTheme,
        'Encode Sans Semi Condensed':
            GoogleFonts.encodeSansSemiCondensedTextTheme,
        'Encode Sans Semi Expanded':
            GoogleFonts.encodeSansSemiExpandedTextTheme,
        'Engagement': GoogleFonts.engagementTextTheme,
        'Englebert': GoogleFonts.englebertTextTheme,
        'Enriqueta': GoogleFonts.enriquetaTextTheme,
        'Epilogue': GoogleFonts.epilogueTextTheme,
        'Erica One': GoogleFonts.ericaOneTextTheme,
        'Esteban': GoogleFonts.estebanTextTheme,
        'Euphoria Script': GoogleFonts.euphoriaScriptTextTheme,
        'Ewert': GoogleFonts.ewertTextTheme,
        'Exo': GoogleFonts.exoTextTheme,
        'Exo 2': GoogleFonts.exo2TextTheme,
        'Expletus Sans': GoogleFonts.expletusSansTextTheme,
        'Fahkwang': GoogleFonts.fahkwangTextTheme,
        'Fanwood Text': GoogleFonts.fanwoodTextTextTheme,
        'Farro': GoogleFonts.farroTextTheme,
        'Farsan': GoogleFonts.farsanTextTheme,
        'Fascinate': GoogleFonts.fascinateTextTheme,
        'Fascinate Inline': GoogleFonts.fascinateInlineTextTheme,
        'Faster One': GoogleFonts.fasterOneTextTheme,
        'Fauna One': GoogleFonts.faunaOneTextTheme,
        'Faustina': GoogleFonts.faustinaTextTheme,
        'Federant': GoogleFonts.federantTextTheme,
        'Federo': GoogleFonts.federoTextTheme,
        'Felipa': GoogleFonts.felipaTextTheme,
        'Fenix': GoogleFonts.fenixTextTheme,
        'Finger Paint': GoogleFonts.fingerPaintTextTheme,
        'Fira Code': GoogleFonts.firaCodeTextTheme,
        'Fira Mono': GoogleFonts.firaMonoTextTheme,
        'Fira Sans': GoogleFonts.firaSansTextTheme,
        'Fira Sans Condensed': GoogleFonts.firaSansCondensedTextTheme,
        'Fira Sans Extra Condensed':
            GoogleFonts.firaSansExtraCondensedTextTheme,
        'Fjalla One': GoogleFonts.fjallaOneTextTheme,
        'Fjord One': GoogleFonts.fjordOneTextTheme,
        'Flamenco': GoogleFonts.flamencoTextTheme,
        'Flavors': GoogleFonts.flavorsTextTheme,
        'Fondamento': GoogleFonts.fondamentoTextTheme,
        'Fontdiner Swanky': GoogleFonts.fontdinerSwankyTextTheme,
        'Forum': GoogleFonts.forumTextTheme,
        'Francois One': GoogleFonts.francoisOneTextTheme,
        'Frank Ruhl Libre': GoogleFonts.frankRuhlLibreTextTheme,
        'Fraunces': GoogleFonts.frauncesTextTheme,
        'Freckle Face': GoogleFonts.freckleFaceTextTheme,
        'Fredericka the Great': GoogleFonts.frederickaTheGreatTextTheme,
        'Fredoka One': GoogleFonts.fredokaOneTextTheme,
        'Fresca': GoogleFonts.frescaTextTheme,
        'Frijole': GoogleFonts.frijoleTextTheme,
        'Fruktur': GoogleFonts.frukturTextTheme,
        'Fugaz One': GoogleFonts.fugazOneTextTheme,
        'GFS Didot': GoogleFonts.gfsDidotTextTheme,
        'GFS Neohellenic': GoogleFonts.gfsNeohellenicTextTheme,
        'Gabriela': GoogleFonts.gabrielaTextTheme,
        'Gaegu': GoogleFonts.gaeguTextTheme,
        'Gafata': GoogleFonts.gafataTextTheme,
        'Galada': GoogleFonts.galadaTextTheme,
        'Galdeano': GoogleFonts.galdeanoTextTheme,
        'Galindo': GoogleFonts.galindoTextTheme,
        'Gamja Flower': GoogleFonts.gamjaFlowerTextTheme,
        'Gayathri': GoogleFonts.gayathriTextTheme,
        'Gelasio': GoogleFonts.gelasioTextTheme,
        'Gentium Basic': GoogleFonts.gentiumBasicTextTheme,
        'Gentium Book Basic': GoogleFonts.gentiumBookBasicTextTheme,
        'Geo': GoogleFonts.geoTextTheme,
        'Geostar': GoogleFonts.geostarTextTheme,
        'Geostar Fill': GoogleFonts.geostarFillTextTheme,
        'Germania One': GoogleFonts.germaniaOneTextTheme,
        'Gidugu': GoogleFonts.giduguTextTheme,
        'Gilda Display': GoogleFonts.gildaDisplayTextTheme,
        'Girassol': GoogleFonts.girassolTextTheme,
        'Give You Glory': GoogleFonts.giveYouGloryTextTheme,
        'Glass Antiqua': GoogleFonts.glassAntiquaTextTheme,
        'Glegoo': GoogleFonts.glegooTextTheme,
        'Gloria Hallelujah': GoogleFonts.gloriaHallelujahTextTheme,
        'Goblin One': GoogleFonts.goblinOneTextTheme,
        'Gochi Hand': GoogleFonts.gochiHandTextTheme,
        'Goldman': GoogleFonts.goldmanTextTheme,
        'Gorditas': GoogleFonts.gorditasTextTheme,
        'Gothic A1': GoogleFonts.gothicA1TextTheme,
        'Gotu': GoogleFonts.gotuTextTheme,
        'Goudy Bookletter 1911': GoogleFonts.goudyBookletter1911TextTheme,
        'Graduate': GoogleFonts.graduateTextTheme,
        'Grand Hotel': GoogleFonts.grandHotelTextTheme,
        'Grandstander': GoogleFonts.grandstanderTextTheme,
        'Gravitas One': GoogleFonts.gravitasOneTextTheme,
        'Great Vibes': GoogleFonts.greatVibesTextTheme,
        'Grenze': GoogleFonts.grenzeTextTheme,
        'Grenze Gotisch': GoogleFonts.grenzeGotischTextTheme,
        'Griffy': GoogleFonts.griffyTextTheme,
        'Gruppo': GoogleFonts.gruppoTextTheme,
        'Gudea': GoogleFonts.gudeaTextTheme,
        'Gugi': GoogleFonts.gugiTextTheme,
        'Gupter': GoogleFonts.gupterTextTheme,
        'Gurajada': GoogleFonts.gurajadaTextTheme,
        'Habibi': GoogleFonts.habibiTextTheme,
        'Hachi Maru Pop': GoogleFonts.hachiMaruPopTextTheme,
        'Halant': GoogleFonts.halantTextTheme,
        'Hammersmith One': GoogleFonts.hammersmithOneTextTheme,
        'Hanalei': GoogleFonts.hanaleiTextTheme,
        'Hanalei Fill': GoogleFonts.hanaleiFillTextTheme,
        'Handlee': GoogleFonts.handleeTextTheme,
        'Happy Monkey': GoogleFonts.happyMonkeyTextTheme,
        'Harmattan': GoogleFonts.harmattanTextTheme,
        'Headland One': GoogleFonts.headlandOneTextTheme,
        'Heebo': GoogleFonts.heeboTextTheme,
        'Henny Penny': GoogleFonts.hennyPennyTextTheme,
        'Hepta Slab': GoogleFonts.heptaSlabTextTheme,
        'Herr Von Muellerhoff': GoogleFonts.herrVonMuellerhoffTextTheme,
        'Hi Melody': GoogleFonts.hiMelodyTextTheme,
        'Hind': GoogleFonts.hindTextTheme,
        'Hind Guntur': GoogleFonts.hindGunturTextTheme,
        'Hind Madurai': GoogleFonts.hindMaduraiTextTheme,
        'Hind Siliguri': GoogleFonts.hindSiliguriTextTheme,
        'Hind Vadodara': GoogleFonts.hindVadodaraTextTheme,
        'Holtwood One SC': GoogleFonts.holtwoodOneScTextTheme,
        'Homemade Apple': GoogleFonts.homemadeAppleTextTheme,
        'Homenaje': GoogleFonts.homenajeTextTheme,
        'IBM Plex Mono': GoogleFonts.ibmPlexMonoTextTheme,
        'IBM Plex Sans': GoogleFonts.ibmPlexSansTextTheme,
        'IBM Plex Sans Condensed': GoogleFonts.ibmPlexSansCondensedTextTheme,
        'IBM Plex Serif': GoogleFonts.ibmPlexSerifTextTheme,
        'IM Fell DW Pica': GoogleFonts.imFellDwPicaTextTheme,
        'IM Fell DW Pica SC': GoogleFonts.imFellDwPicaScTextTheme,
        'IM Fell Double Pica': GoogleFonts.imFellDoublePicaTextTheme,
        'IM Fell Double Pica SC': GoogleFonts.imFellDoublePicaScTextTheme,
        'IM Fell English': GoogleFonts.imFellEnglishTextTheme,
        'IM Fell English SC': GoogleFonts.imFellEnglishScTextTheme,
        'IM Fell French Canon': GoogleFonts.imFellFrenchCanonTextTheme,
        'IM Fell French Canon SC': GoogleFonts.imFellFrenchCanonScTextTheme,
        'IM Fell Great Primer': GoogleFonts.imFellGreatPrimerTextTheme,
        'IM Fell Great Primer SC': GoogleFonts.imFellGreatPrimerScTextTheme,
        'Ibarra Real Nova': GoogleFonts.ibarraRealNovaTextTheme,
        'Iceberg': GoogleFonts.icebergTextTheme,
        'Iceland': GoogleFonts.icelandTextTheme,
        'Imprima': GoogleFonts.imprimaTextTheme,
        'Inconsolata': GoogleFonts.inconsolataTextTheme,
        'Inder': GoogleFonts.inderTextTheme,
        'Indie Flower': GoogleFonts.indieFlowerTextTheme,
        'Inika': GoogleFonts.inikaTextTheme,
        'Inknut Antiqua': GoogleFonts.inknutAntiquaTextTheme,
        'Inria Sans': GoogleFonts.inriaSansTextTheme,
        'Inria Serif': GoogleFonts.inriaSerifTextTheme,
        'Inter': GoogleFonts.interTextTheme,
        'Irish Grover': GoogleFonts.irishGroverTextTheme,
        'Istok Web': GoogleFonts.istokWebTextTheme,
        'Italiana': GoogleFonts.italianaTextTheme,
        'Italianno': GoogleFonts.italiannoTextTheme,
        'Itim': GoogleFonts.itimTextTheme,
        'Jacques Francois': GoogleFonts.jacquesFrancoisTextTheme,
        'Jacques Francois Shadow': GoogleFonts.jacquesFrancoisShadowTextTheme,
        'Jaldi': GoogleFonts.jaldiTextTheme,
        'JetBrains Mono': GoogleFonts.jetBrainsMonoTextTheme,
        'Jim Nightshade': GoogleFonts.jimNightshadeTextTheme,
        'Jockey One': GoogleFonts.jockeyOneTextTheme,
        'Jolly Lodger': GoogleFonts.jollyLodgerTextTheme,
        'Jomhuria': GoogleFonts.jomhuriaTextTheme,
        'Jomolhari': GoogleFonts.jomolhariTextTheme,
        'Josefin Sans': GoogleFonts.josefinSansTextTheme,
        'Josefin Slab': GoogleFonts.josefinSlabTextTheme,
        'Jost': GoogleFonts.jostTextTheme,
        'Joti One': GoogleFonts.jotiOneTextTheme,
        'Jua': GoogleFonts.juaTextTheme,
        'Judson': GoogleFonts.judsonTextTheme,
        'Julee': GoogleFonts.juleeTextTheme,
        'Julius Sans One': GoogleFonts.juliusSansOneTextTheme,
        'Junge': GoogleFonts.jungeTextTheme,
        'Jura': GoogleFonts.juraTextTheme,
        'Just Another Hand': GoogleFonts.justAnotherHandTextTheme,
        'Just Me Again Down Here': GoogleFonts.justMeAgainDownHereTextTheme,
        'K2D': GoogleFonts.k2dTextTheme,
        'Kadwa': GoogleFonts.kadwaTextTheme,
        'Kalam': GoogleFonts.kalamTextTheme,
        'Kameron': GoogleFonts.kameronTextTheme,
        'Kanit': GoogleFonts.kanitTextTheme,
        'Kantumruy': GoogleFonts.kantumruyTextTheme,
        'Karla': GoogleFonts.karlaTextTheme,
        'Karma': GoogleFonts.karmaTextTheme,
        'Katibeh': GoogleFonts.katibehTextTheme,
        'Kaushan Script': GoogleFonts.kaushanScriptTextTheme,
        'Kavivanar': GoogleFonts.kavivanarTextTheme,
        'Kavoon': GoogleFonts.kavoonTextTheme,
        'Kdam Thmor': GoogleFonts.kdamThmorTextTheme,
        'Keania One': GoogleFonts.keaniaOneTextTheme,
        'Kelly Slab': GoogleFonts.kellySlabTextTheme,
        'Kenia': GoogleFonts.keniaTextTheme,
        'Khand': GoogleFonts.khandTextTheme,
        'Khula': GoogleFonts.khulaTextTheme,
        'Kirang Haerang': GoogleFonts.kirangHaerangTextTheme,
        'Kite One': GoogleFonts.kiteOneTextTheme,
        'Knewave': GoogleFonts.knewaveTextTheme,
        'KoHo': GoogleFonts.koHoTextTheme,
        'Kodchasan': GoogleFonts.kodchasanTextTheme,
        'Kosugi': GoogleFonts.kosugiTextTheme,
        'Kosugi Maru': GoogleFonts.kosugiMaruTextTheme,
        'Kotta One': GoogleFonts.kottaOneTextTheme,
        'Kranky': GoogleFonts.krankyTextTheme,
        'Kreon': GoogleFonts.kreonTextTheme,
        'Kristi': GoogleFonts.kristiTextTheme,
        'Krona One': GoogleFonts.kronaOneTextTheme,
        'Krub': GoogleFonts.krubTextTheme,
        'Kufam': GoogleFonts.kufamTextTheme,
        'Kulim Park': GoogleFonts.kulimParkTextTheme,
        'Kumar One': GoogleFonts.kumarOneTextTheme,
        'Kumar One Outline': GoogleFonts.kumarOneOutlineTextTheme,
        'Kumbh Sans': GoogleFonts.kumbhSansTextTheme,
        'Kurale': GoogleFonts.kuraleTextTheme,
        'La Belle Aurore': GoogleFonts.laBelleAuroreTextTheme,
        'Lacquer': GoogleFonts.lacquerTextTheme,
        'Laila': GoogleFonts.lailaTextTheme,
        'Lakki Reddy': GoogleFonts.lakkiReddyTextTheme,
        'Lalezar': GoogleFonts.lalezarTextTheme,
        'Lancelot': GoogleFonts.lancelotTextTheme,
        'Langar': GoogleFonts.langarTextTheme,
        'Lateef': GoogleFonts.lateefTextTheme,
        'Lato': GoogleFonts.latoTextTheme,
        'League Script': GoogleFonts.leagueScriptTextTheme,
        'Leckerli One': GoogleFonts.leckerliOneTextTheme,
        'Ledger': GoogleFonts.ledgerTextTheme,
        'Lekton': GoogleFonts.lektonTextTheme,
        'Lemon': GoogleFonts.lemonTextTheme,
        'Lemonada': GoogleFonts.lemonadaTextTheme,
        'Lexend Deca': GoogleFonts.lexendDecaTextTheme,
        'Lexend Exa': GoogleFonts.lexendExaTextTheme,
        'Lexend Giga': GoogleFonts.lexendGigaTextTheme,
        'Lexend Mega': GoogleFonts.lexendMegaTextTheme,
        'Lexend Peta': GoogleFonts.lexendPetaTextTheme,
        'Lexend Tera': GoogleFonts.lexendTeraTextTheme,
        'Lexend Zetta': GoogleFonts.lexendZettaTextTheme,
        'Libre Barcode 128': GoogleFonts.libreBarcode128TextTheme,
        'Libre Barcode 128 Text': GoogleFonts.libreBarcode128TextTextTheme,
        'Libre Barcode 39': GoogleFonts.libreBarcode39TextTheme,
        'Libre Barcode 39 Extended':
            GoogleFonts.libreBarcode39ExtendedTextTheme,
        'Libre Barcode 39 Extended Text':
            GoogleFonts.libreBarcode39ExtendedTextTextTheme,
        'Libre Barcode 39 Text': GoogleFonts.libreBarcode39TextTextTheme,
        'Libre Baskerville': GoogleFonts.libreBaskervilleTextTheme,
        'Libre Caslon Display': GoogleFonts.libreCaslonDisplayTextTheme,
        'Libre Caslon Text': GoogleFonts.libreCaslonTextTextTheme,
        'Libre Franklin': GoogleFonts.libreFranklinTextTheme,
        'Life Savers': GoogleFonts.lifeSaversTextTheme,
        'Lilita One': GoogleFonts.lilitaOneTextTheme,
        'Lily Script One': GoogleFonts.lilyScriptOneTextTheme,
        'Limelight': GoogleFonts.limelightTextTheme,
        'Linden Hill': GoogleFonts.lindenHillTextTheme,
        'Literata': GoogleFonts.literataTextTheme,
        'Liu Jian Mao Cao': GoogleFonts.liuJianMaoCaoTextTheme,
        'Livvic': GoogleFonts.livvicTextTheme,
        'Lobster': GoogleFonts.lobsterTextTheme,
        'Lobster Two': GoogleFonts.lobsterTwoTextTheme,
        'Londrina Outline': GoogleFonts.londrinaOutlineTextTheme,
        'Londrina Shadow': GoogleFonts.londrinaShadowTextTheme,
        'Londrina Sketch': GoogleFonts.londrinaSketchTextTheme,
        'Londrina Solid': GoogleFonts.londrinaSolidTextTheme,
        'Long Cang': GoogleFonts.longCangTextTheme,
        'Lora': GoogleFonts.loraTextTheme,
        'Love Ya Like A Sister': GoogleFonts.loveYaLikeASisterTextTheme,
        'Loved by the King': GoogleFonts.lovedByTheKingTextTheme,
        'Lovers Quarrel': GoogleFonts.loversQuarrelTextTheme,
        'Luckiest Guy': GoogleFonts.luckiestGuyTextTheme,
        'Lusitana': GoogleFonts.lusitanaTextTheme,
        'Lustria': GoogleFonts.lustriaTextTheme,
        'M PLUS 1p': GoogleFonts.mPlus1pTextTheme,
        'M PLUS Rounded 1c': GoogleFonts.mPlusRounded1cTextTheme,
        'Ma Shan Zheng': GoogleFonts.maShanZhengTextTheme,
        'Macondo': GoogleFonts.macondoTextTheme,
        'Macondo Swash Caps': GoogleFonts.macondoSwashCapsTextTheme,
        'Mada': GoogleFonts.madaTextTheme,
        'Magra': GoogleFonts.magraTextTheme,
        'Maiden Orange': GoogleFonts.maidenOrangeTextTheme,
        'Maitree': GoogleFonts.maitreeTextTheme,
        'Major Mono Display': GoogleFonts.majorMonoDisplayTextTheme,
        'Mako': GoogleFonts.makoTextTheme,
        'Mali': GoogleFonts.maliTextTheme,
        'Mallanna': GoogleFonts.mallannaTextTheme,
        'Mandali': GoogleFonts.mandaliTextTheme,
        'Manjari': GoogleFonts.manjariTextTheme,
        'Manrope': GoogleFonts.manropeTextTheme,
        'Mansalva': GoogleFonts.mansalvaTextTheme,
        'Manuale': GoogleFonts.manualeTextTheme,
        'Marcellus': GoogleFonts.marcellusTextTheme,
        'Marcellus SC': GoogleFonts.marcellusScTextTheme,
        'Marck Script': GoogleFonts.marckScriptTextTheme,
        'Margarine': GoogleFonts.margarineTextTheme,
        'Markazi Text': GoogleFonts.markaziTextTextTheme,
        'Marko One': GoogleFonts.markoOneTextTheme,
        'Marmelad': GoogleFonts.marmeladTextTheme,
        'Martel': GoogleFonts.martelTextTheme,
        'Martel Sans': GoogleFonts.martelSansTextTheme,
        'Marvel': GoogleFonts.marvelTextTheme,
        'Mate': GoogleFonts.mateTextTheme,
        'Mate SC': GoogleFonts.mateScTextTheme,
        'Maven Pro': GoogleFonts.mavenProTextTheme,
        'McLaren': GoogleFonts.mcLarenTextTheme,
        'Meddon': GoogleFonts.meddonTextTheme,
        'MedievalSharp': GoogleFonts.medievalSharpTextTheme,
        'Medula One': GoogleFonts.medulaOneTextTheme,
        'Meera Inimai': GoogleFonts.meeraInimaiTextTheme,
        'Megrim': GoogleFonts.megrimTextTheme,
        'Meie Script': GoogleFonts.meieScriptTextTheme,
        'Merienda': GoogleFonts.meriendaTextTheme,
        'Merienda One': GoogleFonts.meriendaOneTextTheme,
        'Merriweather': GoogleFonts.merriweatherTextTheme,
        'Merriweather Sans': GoogleFonts.merriweatherSansTextTheme,
        'Metal Mania': GoogleFonts.metalManiaTextTheme,
        'Metamorphous': GoogleFonts.metamorphousTextTheme,
        'Metrophobic': GoogleFonts.metrophobicTextTheme,
        'Michroma': GoogleFonts.michromaTextTheme,
        'Milonga': GoogleFonts.milongaTextTheme,
        'Miltonian': GoogleFonts.miltonianTextTheme,
        'Miltonian Tattoo': GoogleFonts.miltonianTattooTextTheme,
        'Mina': GoogleFonts.minaTextTheme,
        'Miniver': GoogleFonts.miniverTextTheme,
        'Miriam Libre': GoogleFonts.miriamLibreTextTheme,
        'Mirza': GoogleFonts.mirzaTextTheme,
        'Miss Fajardose': GoogleFonts.missFajardoseTextTheme,
        'Mitr': GoogleFonts.mitrTextTheme,
        'Modak': GoogleFonts.modakTextTheme,
        'Modern Antiqua': GoogleFonts.modernAntiquaTextTheme,
        'Mogra': GoogleFonts.mograTextTheme,
        'Molengo': GoogleFonts.molengoTextTheme,
        'Molle': GoogleFonts.molleTextTheme,
        'Monda': GoogleFonts.mondaTextTheme,
        'Monofett': GoogleFonts.monofettTextTheme,
        'Monoton': GoogleFonts.monotonTextTheme,
        'Monsieur La Doulaise': GoogleFonts.monsieurLaDoulaiseTextTheme,
        'Montaga': GoogleFonts.montagaTextTheme,
        'Montez': GoogleFonts.montezTextTheme,
        'Montserrat': GoogleFonts.montserratTextTheme,
        'Montserrat Alternates': GoogleFonts.montserratAlternatesTextTheme,
        'Montserrat Subrayada': GoogleFonts.montserratSubrayadaTextTheme,
        'Mountains of Christmas': GoogleFonts.mountainsOfChristmasTextTheme,
        'Mouse Memoirs': GoogleFonts.mouseMemoirsTextTheme,
        'Mr Bedfort': GoogleFonts.mrBedfortTextTheme,
        'Mr Dafoe': GoogleFonts.mrDafoeTextTheme,
        'Mr De Haviland': GoogleFonts.mrDeHavilandTextTheme,
        'Mrs Saint Delafield': GoogleFonts.mrsSaintDelafieldTextTheme,
        'Mrs Sheppards': GoogleFonts.mrsSheppardsTextTheme,
        'Mukta': GoogleFonts.muktaTextTheme,
        'Mukta Mahee': GoogleFonts.muktaMaheeTextTheme,
        'Mukta Malar': GoogleFonts.muktaMalarTextTheme,
        'Mukta Vaani': GoogleFonts.muktaVaaniTextTheme,
        'Mulish': GoogleFonts.mulishTextTheme,
        'MuseoModerno': GoogleFonts.museoModernoTextTheme,
        'Mystery Quest': GoogleFonts.mysteryQuestTextTheme,
        'NTR': GoogleFonts.ntrTextTheme,
        'Nanum Brush Script': GoogleFonts.nanumBrushScriptTextTheme,
        'Nanum Gothic': GoogleFonts.nanumGothicTextTheme,
        'Nanum Gothic Coding': GoogleFonts.nanumGothicCodingTextTheme,
        'Nanum Myeongjo': GoogleFonts.nanumMyeongjoTextTheme,
        'Nanum Pen Script': GoogleFonts.nanumPenScriptTextTheme,
        'Nerko One': GoogleFonts.nerkoOneTextTheme,
        'Neucha': GoogleFonts.neuchaTextTheme,
        'Neuton': GoogleFonts.neutonTextTheme,
        'New Rocker': GoogleFonts.newRockerTextTheme,
        'News Cycle': GoogleFonts.newsCycleTextTheme,
        'Niconne': GoogleFonts.niconneTextTheme,
        'Niramit': GoogleFonts.niramitTextTheme,
        'Nixie One': GoogleFonts.nixieOneTextTheme,
        'Nobile': GoogleFonts.nobileTextTheme,
        'Norican': GoogleFonts.noricanTextTheme,
        'Nosifer': GoogleFonts.nosiferTextTheme,
        'Notable': GoogleFonts.notableTextTheme,
        'Nothing You Could Do': GoogleFonts.nothingYouCouldDoTextTheme,
        'Noticia Text': GoogleFonts.noticiaTextTextTheme,
        'Noto Color Emoji Compat': GoogleFonts.notoColorEmojiCompatTextTheme,
        'Noto Sans': GoogleFonts.notoSansTextTheme,
        'Noto Serif': GoogleFonts.notoSerifTextTheme,
        'Nova Cut': GoogleFonts.novaCutTextTheme,
        'Nova Flat': GoogleFonts.novaFlatTextTheme,
        'Nova Mono': GoogleFonts.novaMonoTextTheme,
        'Nova Oval': GoogleFonts.novaOvalTextTheme,
        'Nova Round': GoogleFonts.novaRoundTextTheme,
        'Nova Script': GoogleFonts.novaScriptTextTheme,
        'Nova Slim': GoogleFonts.novaSlimTextTheme,
        'Nova Square': GoogleFonts.novaSquareTextTheme,
        'Numans': GoogleFonts.numansTextTheme,
        'Nunito': GoogleFonts.nunitoTextTheme,
        'Nunito Sans': GoogleFonts.nunitoSansTextTheme,
        'Odibee Sans': GoogleFonts.odibeeSansTextTheme,
        'Odor Mean Chey': GoogleFonts.odorMeanCheyTextTheme,
        'Offside': GoogleFonts.offsideTextTheme,
        'Old Standard TT': GoogleFonts.oldStandardTtTextTheme,
        'Oldenburg': GoogleFonts.oldenburgTextTheme,
        'Oleo Script': GoogleFonts.oleoScriptTextTheme,
        'Oleo Script Swash Caps': GoogleFonts.oleoScriptSwashCapsTextTheme,
        'Open Sans': GoogleFonts.openSansTextTheme,
        'Open Sans Condensed': GoogleFonts.openSansCondensedTextTheme,
        'Oranienbaum': GoogleFonts.oranienbaumTextTheme,
        'Orbitron': GoogleFonts.orbitronTextTheme,
        'Oregano': GoogleFonts.oreganoTextTheme,
        'Orienta': GoogleFonts.orientaTextTheme,
        'Original Surfer': GoogleFonts.originalSurferTextTheme,
        'Oswald': GoogleFonts.oswaldTextTheme,
        'Over the Rainbow': GoogleFonts.overTheRainbowTextTheme,
        'Overlock': GoogleFonts.overlockTextTheme,
        'Overlock SC': GoogleFonts.overlockScTextTheme,
        'Overpass': GoogleFonts.overpassTextTheme,
        'Overpass Mono': GoogleFonts.overpassMonoTextTheme,
        'Ovo': GoogleFonts.ovoTextTheme,
        'Oxanium': GoogleFonts.oxaniumTextTheme,
        'Oxygen': GoogleFonts.oxygenTextTheme,
        'Oxygen Mono': GoogleFonts.oxygenMonoTextTheme,
        'PT Mono': GoogleFonts.ptMonoTextTheme,
        'PT Sans': GoogleFonts.ptSansTextTheme,
        'PT Sans Caption': GoogleFonts.ptSansCaptionTextTheme,
        'PT Sans Narrow': GoogleFonts.ptSansNarrowTextTheme,
        'PT Serif': GoogleFonts.ptSerifTextTheme,
        'PT Serif Caption': GoogleFonts.ptSerifCaptionTextTheme,
        'Pacifico': GoogleFonts.pacificoTextTheme,
        'Padauk': GoogleFonts.padaukTextTheme,
        'Palanquin': GoogleFonts.palanquinTextTheme,
        'Palanquin Dark': GoogleFonts.palanquinDarkTextTheme,
        'Pangolin': GoogleFonts.pangolinTextTheme,
        'Paprika': GoogleFonts.paprikaTextTheme,
        'Parisienne': GoogleFonts.parisienneTextTheme,
        'Passero One': GoogleFonts.passeroOneTextTheme,
        'Passion One': GoogleFonts.passionOneTextTheme,
        'Pathway Gothic One': GoogleFonts.pathwayGothicOneTextTheme,
        'Patrick Hand': GoogleFonts.patrickHandTextTheme,
        'Patrick Hand SC': GoogleFonts.patrickHandScTextTheme,
        'Pattaya': GoogleFonts.pattayaTextTheme,
        'Patua One': GoogleFonts.patuaOneTextTheme,
        'Pavanam': GoogleFonts.pavanamTextTheme,
        'Paytone One': GoogleFonts.paytoneOneTextTheme,
        'Peddana': GoogleFonts.peddanaTextTheme,
        'Peralta': GoogleFonts.peraltaTextTheme,
        'Permanent Marker': GoogleFonts.permanentMarkerTextTheme,
        'Petit Formal Script': GoogleFonts.petitFormalScriptTextTheme,
        'Petrona': GoogleFonts.petronaTextTheme,
        'Philosopher': GoogleFonts.philosopherTextTheme,
        'Piazzolla': GoogleFonts.piazzollaTextTheme,
        'Piedra': GoogleFonts.piedraTextTheme,
        'Pinyon Script': GoogleFonts.pinyonScriptTextTheme,
        'Pirata One': GoogleFonts.pirataOneTextTheme,
        'Plaster': GoogleFonts.plasterTextTheme,
        'Play': GoogleFonts.playTextTheme,
        'Playball': GoogleFonts.playballTextTheme,
        'Playfair Display': GoogleFonts.playfairDisplayTextTheme,
        'Playfair Display SC': GoogleFonts.playfairDisplayScTextTheme,
        'Podkova': GoogleFonts.podkovaTextTheme,
        'Poiret One': GoogleFonts.poiretOneTextTheme,
        'Poller One': GoogleFonts.pollerOneTextTheme,
        'Poly': GoogleFonts.polyTextTheme,
        'Pompiere': GoogleFonts.pompiereTextTheme,
        'Pontano Sans': GoogleFonts.pontanoSansTextTheme,
        'Poor Story': GoogleFonts.poorStoryTextTheme,
        'Poppins': GoogleFonts.poppinsTextTheme,
        'Port Lligat Sans': GoogleFonts.portLligatSansTextTheme,
        'Port Lligat Slab': GoogleFonts.portLligatSlabTextTheme,
        'Potta One': GoogleFonts.pottaOneTextTheme,
        'Pragati Narrow': GoogleFonts.pragatiNarrowTextTheme,
        'Prata': GoogleFonts.prataTextTheme,
        'Press Start 2P': GoogleFonts.pressStart2pTextTheme,
        'Pridi': GoogleFonts.pridiTextTheme,
        'Princess Sofia': GoogleFonts.princessSofiaTextTheme,
        'Prociono': GoogleFonts.procionoTextTheme,
        'Prompt': GoogleFonts.promptTextTheme,
        'Prosto One': GoogleFonts.prostoOneTextTheme,
        'Proza Libre': GoogleFonts.prozaLibreTextTheme,
        'Public Sans': GoogleFonts.publicSansTextTheme,
        'Puritan': GoogleFonts.puritanTextTheme,
        'Purple Purse': GoogleFonts.purplePurseTextTheme,
        'Quando': GoogleFonts.quandoTextTheme,
        'Quantico': GoogleFonts.quanticoTextTheme,
        'Quattrocento': GoogleFonts.quattrocentoTextTheme,
        'Quattrocento Sans': GoogleFonts.quattrocentoSansTextTheme,
        'Questrial': GoogleFonts.questrialTextTheme,
        'Quicksand': GoogleFonts.quicksandTextTheme,
        'Quintessential': GoogleFonts.quintessentialTextTheme,
        'Qwigley': GoogleFonts.qwigleyTextTheme,
        'Racing Sans One': GoogleFonts.racingSansOneTextTheme,
        'Radley': GoogleFonts.radleyTextTheme,
        'Rajdhani': GoogleFonts.rajdhaniTextTheme,
        'Rakkas': GoogleFonts.rakkasTextTheme,
        'Raleway': GoogleFonts.ralewayTextTheme,
        'Raleway Dots': GoogleFonts.ralewayDotsTextTheme,
        'Ramabhadra': GoogleFonts.ramabhadraTextTheme,
        'Ramaraja': GoogleFonts.ramarajaTextTheme,
        'Rambla': GoogleFonts.ramblaTextTheme,
        'Rammetto One': GoogleFonts.rammettoOneTextTheme,
        'Ranchers': GoogleFonts.ranchersTextTheme,
        'Rancho': GoogleFonts.ranchoTextTheme,
        'Ranga': GoogleFonts.rangaTextTheme,
        'Rasa': GoogleFonts.rasaTextTheme,
        'Rationale': GoogleFonts.rationaleTextTheme,
        'Ravi Prakash': GoogleFonts.raviPrakashTextTheme,
        'Recursive': GoogleFonts.recursiveTextTheme,
        'Red Hat Display': GoogleFonts.redHatDisplayTextTheme,
        'Red Hat Text': GoogleFonts.redHatTextTextTheme,
        'Red Rose': GoogleFonts.redRoseTextTheme,
        'Redressed': GoogleFonts.redressedTextTheme,
        'Reem Kufi': GoogleFonts.reemKufiTextTheme,
        'Reenie Beanie': GoogleFonts.reenieBeanieTextTheme,
        'Revalia': GoogleFonts.revaliaTextTheme,
        'Rhodium Libre': GoogleFonts.rhodiumLibreTextTheme,
        'Ribeye': GoogleFonts.ribeyeTextTheme,
        'Ribeye Marrow': GoogleFonts.ribeyeMarrowTextTheme,
        'Righteous': GoogleFonts.righteousTextTheme,
        'Risque': GoogleFonts.risqueTextTheme,
        'Roboto': GoogleFonts.robotoTextTheme,
        'Roboto Condensed': GoogleFonts.robotoCondensedTextTheme,
        'Roboto Mono': GoogleFonts.robotoMonoTextTheme,
        'Roboto Slab': GoogleFonts.robotoSlabTextTheme,
        'Rochester': GoogleFonts.rochesterTextTheme,
        'Rock Salt': GoogleFonts.rockSaltTextTheme,
        'Rokkitt': GoogleFonts.rokkittTextTheme,
        'Romanesco': GoogleFonts.romanescoTextTheme,
        'Ropa Sans': GoogleFonts.ropaSansTextTheme,
        'Rosario': GoogleFonts.rosarioTextTheme,
        'Rosarivo': GoogleFonts.rosarivoTextTheme,
        'Rouge Script': GoogleFonts.rougeScriptTextTheme,
        'Rowdies': GoogleFonts.rowdiesTextTheme,
        'Rozha One': GoogleFonts.rozhaOneTextTheme,
        'Rubik': GoogleFonts.rubikTextTheme,
        'Rubik Mono One': GoogleFonts.rubikMonoOneTextTheme,
        'Ruda': GoogleFonts.rudaTextTheme,
        'Rufina': GoogleFonts.rufinaTextTheme,
        'Ruge Boogie': GoogleFonts.rugeBoogieTextTheme,
        'Ruluko': GoogleFonts.rulukoTextTheme,
        'Rum Raisin': GoogleFonts.rumRaisinTextTheme,
        'Ruslan Display': GoogleFonts.ruslanDisplayTextTheme,
        'Russo One': GoogleFonts.russoOneTextTheme,
        'Ruthie': GoogleFonts.ruthieTextTheme,
        'Rye': GoogleFonts.ryeTextTheme,
        'Sacramento': GoogleFonts.sacramentoTextTheme,
        'Sahitya': GoogleFonts.sahityaTextTheme,
        'Sail': GoogleFonts.sailTextTheme,
        'Saira': GoogleFonts.sairaTextTheme,
        'Saira Condensed': GoogleFonts.sairaCondensedTextTheme,
        'Saira Extra Condensed': GoogleFonts.sairaExtraCondensedTextTheme,
        'Saira Semi Condensed': GoogleFonts.sairaSemiCondensedTextTheme,
        'Saira Stencil One': GoogleFonts.sairaStencilOneTextTheme,
        'Salsa': GoogleFonts.salsaTextTheme,
        'Sanchez': GoogleFonts.sanchezTextTheme,
        'Sancreek': GoogleFonts.sancreekTextTheme,
        'Sansita': GoogleFonts.sansitaTextTheme,
        'Sansita Swashed': GoogleFonts.sansitaSwashedTextTheme,
        'Sarabun': GoogleFonts.sarabunTextTheme,
        'Sarala': GoogleFonts.saralaTextTheme,
        'Sarina': GoogleFonts.sarinaTextTheme,
        'Sarpanch': GoogleFonts.sarpanchTextTheme,
        'Satisfy': GoogleFonts.satisfyTextTheme,
        'Sawarabi Gothic': GoogleFonts.sawarabiGothicTextTheme,
        'Sawarabi Mincho': GoogleFonts.sawarabiMinchoTextTheme,
        'Scada': GoogleFonts.scadaTextTheme,
        'Scheherazade': GoogleFonts.scheherazadeTextTheme,
        'Schoolbell': GoogleFonts.schoolbellTextTheme,
        'Scope One': GoogleFonts.scopeOneTextTheme,
        'Seaweed Script': GoogleFonts.seaweedScriptTextTheme,
        'Secular One': GoogleFonts.secularOneTextTheme,
        'Sedgwick Ave': GoogleFonts.sedgwickAveTextTheme,
        'Sedgwick Ave Display': GoogleFonts.sedgwickAveDisplayTextTheme,
        'Sen': GoogleFonts.senTextTheme,
        'Sevillana': GoogleFonts.sevillanaTextTheme,
        'Seymour One': GoogleFonts.seymourOneTextTheme,
        'Shadows Into Light': GoogleFonts.shadowsIntoLightTextTheme,
        'Shadows Into Light Two': GoogleFonts.shadowsIntoLightTwoTextTheme,
        'Shanti': GoogleFonts.shantiTextTheme,
        'Share': GoogleFonts.shareTextTheme,
        'Share Tech': GoogleFonts.shareTechTextTheme,
        'Share Tech Mono': GoogleFonts.shareTechMonoTextTheme,
        'Shojumaru': GoogleFonts.shojumaruTextTheme,
        'Short Stack': GoogleFonts.shortStackTextTheme,
        'Shrikhand': GoogleFonts.shrikhandTextTheme,
        'Sigmar One': GoogleFonts.sigmarOneTextTheme,
        'Signika': GoogleFonts.signikaTextTheme,
        'Signika Negative': GoogleFonts.signikaNegativeTextTheme,
        'Simonetta': GoogleFonts.simonettaTextTheme,
        'Single Day': GoogleFonts.singleDayTextTheme,
        'Sintony': GoogleFonts.sintonyTextTheme,
        'Sirin Stencil': GoogleFonts.sirinStencilTextTheme,
        'Six Caps': GoogleFonts.sixCapsTextTheme,
        'Skranji': GoogleFonts.skranjiTextTheme,
        'Slabo 13px': GoogleFonts.slabo13pxTextTheme,
        'Slabo 27px': GoogleFonts.slabo27pxTextTheme,
        'Slackey': GoogleFonts.slackeyTextTheme,
        'Smokum': GoogleFonts.smokumTextTheme,
        'Smythe': GoogleFonts.smytheTextTheme,
        'Sniglet': GoogleFonts.snigletTextTheme,
        'Snippet': GoogleFonts.snippetTextTheme,
        'Snowburst One': GoogleFonts.snowburstOneTextTheme,
        'Sofadi One': GoogleFonts.sofadiOneTextTheme,
        'Sofia': GoogleFonts.sofiaTextTheme,
        'Solway': GoogleFonts.solwayTextTheme,
        'Song Myung': GoogleFonts.songMyungTextTheme,
        'Sonsie One': GoogleFonts.sonsieOneTextTheme,
        'Sora': GoogleFonts.soraTextTheme,
        'Sorts Mill Goudy': GoogleFonts.sortsMillGoudyTextTheme,
        'Source Code Pro': GoogleFonts.sourceCodeProTextTheme,
        'Source Sans Pro': GoogleFonts.sourceSansProTextTheme,
        'Source Serif Pro': GoogleFonts.sourceSerifProTextTheme,
        'Space Grotesk': GoogleFonts.spaceGroteskTextTheme,
        'Space Mono': GoogleFonts.spaceMonoTextTheme,
        'Spartan': GoogleFonts.spartanTextTheme,
        'Special Elite': GoogleFonts.specialEliteTextTheme,
        'Spectral': GoogleFonts.spectralTextTheme,
        'Spectral SC': GoogleFonts.spectralScTextTheme,
        'Spicy Rice': GoogleFonts.spicyRiceTextTheme,
        'Spinnaker': GoogleFonts.spinnakerTextTheme,
        'Spirax': GoogleFonts.spiraxTextTheme,
        'Squada One': GoogleFonts.squadaOneTextTheme,
        'Sree Krushnadevaraya': GoogleFonts.sreeKrushnadevarayaTextTheme,
        'Sriracha': GoogleFonts.srirachaTextTheme,
        'Srisakdi': GoogleFonts.srisakdiTextTheme,
        'Staatliches': GoogleFonts.staatlichesTextTheme,
        'Stalemate': GoogleFonts.stalemateTextTheme,
        'Stalinist One': GoogleFonts.stalinistOneTextTheme,
        'Stardos Stencil': GoogleFonts.stardosStencilTextTheme,
        'Stint Ultra Condensed': GoogleFonts.stintUltraCondensedTextTheme,
        'Stint Ultra Expanded': GoogleFonts.stintUltraExpandedTextTheme,
        'Stoke': GoogleFonts.stokeTextTheme,
        'Strait': GoogleFonts.straitTextTheme,
        'Stylish': GoogleFonts.stylishTextTheme,
        'Sue Ellen Francisco': GoogleFonts.sueEllenFranciscoTextTheme,
        'Suez One': GoogleFonts.suezOneTextTheme,
        'Sulphur Point': GoogleFonts.sulphurPointTextTheme,
        'Sumana': GoogleFonts.sumanaTextTheme,
        'Sunflower': GoogleFonts.sunflowerTextTheme,
        'Sunshiney': GoogleFonts.sunshineyTextTheme,
        'Supermercado One': GoogleFonts.supermercadoOneTextTheme,
        'Sura': GoogleFonts.suraTextTheme,
        'Suranna': GoogleFonts.surannaTextTheme,
        'Suravaram': GoogleFonts.suravaramTextTheme,
        'Swanky and Moo Moo': GoogleFonts.swankyAndMooMooTextTheme,
        'Syncopate': GoogleFonts.syncopateTextTheme,
        'Syne': GoogleFonts.syneTextTheme,
        'Syne Mono': GoogleFonts.syneMonoTextTheme,
        'Syne Tactile': GoogleFonts.syneTactileTextTheme,
        'Tajawal': GoogleFonts.tajawalTextTheme,
        'Tangerine': GoogleFonts.tangerineTextTheme,
        'Tauri': GoogleFonts.tauriTextTheme,
        'Taviraj': GoogleFonts.tavirajTextTheme,
        'Teko': GoogleFonts.tekoTextTheme,
        'Telex': GoogleFonts.telexTextTheme,
        'Tenali Ramakrishna': GoogleFonts.tenaliRamakrishnaTextTheme,
        'Tenor Sans': GoogleFonts.tenorSansTextTheme,
        'Text Me One': GoogleFonts.textMeOneTextTheme,
        'Thasadith': GoogleFonts.thasadithTextTheme,
        'The Girl Next Door': GoogleFonts.theGirlNextDoorTextTheme,
        'Tienne': GoogleFonts.tienneTextTheme,
        'Tillana': GoogleFonts.tillanaTextTheme,
        'Timmana': GoogleFonts.timmanaTextTheme,
        'Tinos': GoogleFonts.tinosTextTheme,
        'Titan One': GoogleFonts.titanOneTextTheme,
        'Titillium Web': GoogleFonts.titilliumWebTextTheme,
        'Tomorrow': GoogleFonts.tomorrowTextTheme,
        'Trade Winds': GoogleFonts.tradeWindsTextTheme,
        'Trirong': GoogleFonts.trirongTextTheme,
        'Trispace': GoogleFonts.trispaceTextTheme,
        'Trocchi': GoogleFonts.trocchiTextTheme,
        'Trochut': GoogleFonts.trochutTextTheme,
        'Trykker': GoogleFonts.trykkerTextTheme,
        'Tulpen One': GoogleFonts.tulpenOneTextTheme,
        'Turret Road': GoogleFonts.turretRoadTextTheme,
        'Ubuntu': GoogleFonts.ubuntuTextTheme,
        'Ubuntu Condensed': GoogleFonts.ubuntuCondensedTextTheme,
        'Ubuntu Mono': GoogleFonts.ubuntuMonoTextTheme,
        'Ultra': GoogleFonts.ultraTextTheme,
        'Uncial Antiqua': GoogleFonts.uncialAntiquaTextTheme,
        'Underdog': GoogleFonts.underdogTextTheme,
        'Unica One': GoogleFonts.unicaOneTextTheme,
        'UnifrakturCook': GoogleFonts.unifrakturCookTextTheme,
        'UnifrakturMaguntia': GoogleFonts.unifrakturMaguntiaTextTheme,
        'Unkempt': GoogleFonts.unkemptTextTheme,
        'Unlock': GoogleFonts.unlockTextTheme,
        'Unna': GoogleFonts.unnaTextTheme,
        'VT323': GoogleFonts.vt323TextTheme,
        'Vampiro One': GoogleFonts.vampiroOneTextTheme,
        'Varela': GoogleFonts.varelaTextTheme,
        'Varela Round': GoogleFonts.varelaRoundTextTheme,
        'Varta': GoogleFonts.vartaTextTheme,
        'Vast Shadow': GoogleFonts.vastShadowTextTheme,
        'Vesper Libre': GoogleFonts.vesperLibreTextTheme,
        'Viaoda Libre': GoogleFonts.viaodaLibreTextTheme,
        'Vibes': GoogleFonts.vibesTextTheme,
        'Vibur': GoogleFonts.viburTextTheme,
        'Vidaloka': GoogleFonts.vidalokaTextTheme,
        'Viga': GoogleFonts.vigaTextTheme,
        'Voces': GoogleFonts.vocesTextTheme,
        'Volkhov': GoogleFonts.volkhovTextTheme,
        'Vollkorn': GoogleFonts.vollkornTextTheme,
        'Vollkorn SC': GoogleFonts.vollkornScTextTheme,
        'Voltaire': GoogleFonts.voltaireTextTheme,
        'Waiting for the Sunrise': GoogleFonts.waitingForTheSunriseTextTheme,
        'Wallpoet': GoogleFonts.wallpoetTextTheme,
        'Walter Turncoat': GoogleFonts.walterTurncoatTextTheme,
        'Warnes': GoogleFonts.warnesTextTheme,
        'Wellfleet': GoogleFonts.wellfleetTextTheme,
        'Wendy One': GoogleFonts.wendyOneTextTheme,
        'Wire One': GoogleFonts.wireOneTextTheme,
        'Work Sans': GoogleFonts.workSansTextTheme,
        'Xanh Mono': GoogleFonts.xanhMonoTextTheme,
        'Yanone Kaffeesatz': GoogleFonts.yanoneKaffeesatzTextTheme,
        'Yantramanav': GoogleFonts.yantramanavTextTheme,
        'Yatra One': GoogleFonts.yatraOneTextTheme,
        'Yellowtail': GoogleFonts.yellowtailTextTheme,
        'Yeon Sung': GoogleFonts.yeonSungTextTheme,
        'Yeseva One': GoogleFonts.yesevaOneTextTheme,
        'Yesteryear': GoogleFonts.yesteryearTextTheme,
        'Yrsa': GoogleFonts.yrsaTextTheme,
        'Yusei Magic': GoogleFonts.yuseiMagicTextTheme,
        'ZCOOL KuaiLe': GoogleFonts.zcoolKuaiLeTextTheme,
        'ZCOOL QingKe HuangYou': GoogleFonts.zcoolQingKeHuangYouTextTheme,
        'ZCOOL XiaoWei': GoogleFonts.zcoolXiaoWeiTextTheme,
        'Zeyada': GoogleFonts.zeyadaTextTheme,
        'Zhi Mang Xing': GoogleFonts.zhiMangXingTextTheme,
        'Zilla Slab': GoogleFonts.zillaSlabTextTheme,
        'Zilla Slab Highlight': GoogleFonts.zillaSlabHighlightTextTheme,
      };

  /// Retrieve a font by family name.
  ///
  /// Applies the given font family from Google Fonts to the given [textStyle]
  /// and returns the resulting [TextStyle].
  ///
  /// Note: [fontFamily] is case-sensitive.
  ///
  /// Parameter [fontFamily] must not be `null`. Throws if no font by name
  /// [fontFamily] exists.
  static TextStyle getFont(
    String fontFamily, {
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = GoogleFonts.asMap();
    if (!fonts.containsKey(fontFamily)) {
      throw Exception("No font family by name '$fontFamily' was found.");
    }
    return fonts[fontFamily]!(
      textStyle: textStyle,
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
    );
  }

  /// Retrieve a text theme by its font family name.
  ///
  /// Applies the given font family from Google Fonts to the given [textTheme]
  /// and returns the resulting [textTheme].
  ///
  /// Note: [fontFamily] is case-sensitive.
  ///
  /// Parameter [fontFamily] must not be `null`. Throws if no font by name
  /// [fontFamily] exists.
  static TextTheme getTextTheme(String fontFamily, [TextTheme? textTheme]) {
    final fonts = _asMapOfTextThemes();
    if (!fonts.containsKey(fontFamily)) {
      throw Exception("No font family by name '$fontFamily' was found.");
    }
    return fonts[fontFamily]!(textTheme);
  }

  /// Applies the ABeeZee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ABeeZee
  static TextStyle aBeeZee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ff99dd1bd594806e1b9f7423a75f1c1dfbbbcddb2698b3ab91f5709b1b90caf',
        29632,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8654a417521bf7fa4ffd1a7f7b62648648c5415ff0f7e0d53474e4436d049b7a',
        30984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ABeeZee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the ABeeZee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ABeeZee
  static TextTheme aBeeZeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.aBeeZee(textStyle: textTheme.headline1),
      headline2: GoogleFonts.aBeeZee(textStyle: textTheme.headline2),
      headline3: GoogleFonts.aBeeZee(textStyle: textTheme.headline3),
      headline4: GoogleFonts.aBeeZee(textStyle: textTheme.headline4),
      headline5: GoogleFonts.aBeeZee(textStyle: textTheme.headline5),
      headline6: GoogleFonts.aBeeZee(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.aBeeZee(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.aBeeZee(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.aBeeZee(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.aBeeZee(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.aBeeZee(textStyle: textTheme.caption),
      button: GoogleFonts.aBeeZee(textStyle: textTheme.button),
      overline: GoogleFonts.aBeeZee(textStyle: textTheme.overline),
    );
  }

  /// Applies the Abel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abel
  static TextStyle abel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37a44f872ce09b8a93244abfaf3741aa8e4da7cbf64de118635a7cf1c7bc1d5e',
        34924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Abel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abel
  static TextTheme abelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.abel(textStyle: textTheme.headline1),
      headline2: GoogleFonts.abel(textStyle: textTheme.headline2),
      headline3: GoogleFonts.abel(textStyle: textTheme.headline3),
      headline4: GoogleFonts.abel(textStyle: textTheme.headline4),
      headline5: GoogleFonts.abel(textStyle: textTheme.headline5),
      headline6: GoogleFonts.abel(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.abel(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.abel(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.abel(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.abel(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.abel(textStyle: textTheme.caption),
      button: GoogleFonts.abel(textStyle: textTheme.button),
      overline: GoogleFonts.abel(textStyle: textTheme.overline),
    );
  }

  /// Applies the Abhaya Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abhaya+Libre
  static TextStyle abhayaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8e1a260e8a56f8cdb2e2401be9e3a6903026becbf134336b9c8f6b2e2490cd5',
        282252,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff52a780878fd838b81f8c96e548f49d7bbd4f92cb0a3dc68eb3f852ca3f3fd4',
        282512,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3be63e1c52229673f453da3c6abd79dc0011d02fd57da38489880434556aa77',
        281648,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c7bdb109ab0e98ef91a41ec55825dcb97c2ea2e9274c67dde899104f5b59878',
        281252,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9457be94f81fc73b59af3e850d0dcb91790d60078cbdc252da50881c615173aa',
        280484,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbhayaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abhaya Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abhaya+Libre
  static TextTheme abhayaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.abhayaLibre(textStyle: textTheme.headline1),
      headline2: GoogleFonts.abhayaLibre(textStyle: textTheme.headline2),
      headline3: GoogleFonts.abhayaLibre(textStyle: textTheme.headline3),
      headline4: GoogleFonts.abhayaLibre(textStyle: textTheme.headline4),
      headline5: GoogleFonts.abhayaLibre(textStyle: textTheme.headline5),
      headline6: GoogleFonts.abhayaLibre(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.abhayaLibre(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.abhayaLibre(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.abhayaLibre(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.abhayaLibre(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.abhayaLibre(textStyle: textTheme.caption),
      button: GoogleFonts.abhayaLibre(textStyle: textTheme.button),
      overline: GoogleFonts.abhayaLibre(textStyle: textTheme.overline),
    );
  }

  /// Applies the Abril Fatface font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abril+Fatface
  static TextStyle abrilFatface({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2baf7b134013a2183457312f0d26115640d0171829d024dfb1466616a3ac789a',
        67316,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AbrilFatface',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Abril Fatface font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Abril+Fatface
  static TextTheme abrilFatfaceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.abrilFatface(textStyle: textTheme.headline1),
      headline2: GoogleFonts.abrilFatface(textStyle: textTheme.headline2),
      headline3: GoogleFonts.abrilFatface(textStyle: textTheme.headline3),
      headline4: GoogleFonts.abrilFatface(textStyle: textTheme.headline4),
      headline5: GoogleFonts.abrilFatface(textStyle: textTheme.headline5),
      headline6: GoogleFonts.abrilFatface(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.abrilFatface(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.abrilFatface(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.abrilFatface(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.abrilFatface(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.abrilFatface(textStyle: textTheme.caption),
      button: GoogleFonts.abrilFatface(textStyle: textTheme.button),
      overline: GoogleFonts.abrilFatface(textStyle: textTheme.overline),
    );
  }

  /// Applies the Aclonica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aclonica
  static TextStyle aclonica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e26afc4582406a86fc1e1b81aad6e16a03f9276419fa76e91b98f9e42d868cc8',
        68136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aclonica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aclonica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aclonica
  static TextTheme aclonicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.aclonica(textStyle: textTheme.headline1),
      headline2: GoogleFonts.aclonica(textStyle: textTheme.headline2),
      headline3: GoogleFonts.aclonica(textStyle: textTheme.headline3),
      headline4: GoogleFonts.aclonica(textStyle: textTheme.headline4),
      headline5: GoogleFonts.aclonica(textStyle: textTheme.headline5),
      headline6: GoogleFonts.aclonica(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.aclonica(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.aclonica(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.aclonica(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.aclonica(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.aclonica(textStyle: textTheme.caption),
      button: GoogleFonts.aclonica(textStyle: textTheme.button),
      overline: GoogleFonts.aclonica(textStyle: textTheme.overline),
    );
  }

  /// Applies the Acme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Acme
  static TextStyle acme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7d0b4054bd37012deca722e47899589c1d35302b51b2fd21ea83e7f3410bccd',
        23028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Acme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Acme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Acme
  static TextTheme acmeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.acme(textStyle: textTheme.headline1),
      headline2: GoogleFonts.acme(textStyle: textTheme.headline2),
      headline3: GoogleFonts.acme(textStyle: textTheme.headline3),
      headline4: GoogleFonts.acme(textStyle: textTheme.headline4),
      headline5: GoogleFonts.acme(textStyle: textTheme.headline5),
      headline6: GoogleFonts.acme(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.acme(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.acme(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.acme(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.acme(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.acme(textStyle: textTheme.caption),
      button: GoogleFonts.acme(textStyle: textTheme.button),
      overline: GoogleFonts.acme(textStyle: textTheme.overline),
    );
  }

  /// Applies the Actor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Actor
  static TextStyle actor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '417b785d001974cb097e1f84b068ed6f47fa9c5317bf90801a55709954b59350',
        42356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Actor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Actor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Actor
  static TextTheme actorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.actor(textStyle: textTheme.headline1),
      headline2: GoogleFonts.actor(textStyle: textTheme.headline2),
      headline3: GoogleFonts.actor(textStyle: textTheme.headline3),
      headline4: GoogleFonts.actor(textStyle: textTheme.headline4),
      headline5: GoogleFonts.actor(textStyle: textTheme.headline5),
      headline6: GoogleFonts.actor(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.actor(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.actor(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.actor(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.actor(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.actor(textStyle: textTheme.caption),
      button: GoogleFonts.actor(textStyle: textTheme.button),
      overline: GoogleFonts.actor(textStyle: textTheme.overline),
    );
  }

  /// Applies the Adamina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Adamina
  static TextStyle adamina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c241502ff8869d44e310b4e1782d5ca6f53b2d1844593bb0a360e12af0ddfcb1',
        76672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Adamina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Adamina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Adamina
  static TextTheme adaminaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.adamina(textStyle: textTheme.headline1),
      headline2: GoogleFonts.adamina(textStyle: textTheme.headline2),
      headline3: GoogleFonts.adamina(textStyle: textTheme.headline3),
      headline4: GoogleFonts.adamina(textStyle: textTheme.headline4),
      headline5: GoogleFonts.adamina(textStyle: textTheme.headline5),
      headline6: GoogleFonts.adamina(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.adamina(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.adamina(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.adamina(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.adamina(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.adamina(textStyle: textTheme.caption),
      button: GoogleFonts.adamina(textStyle: textTheme.button),
      overline: GoogleFonts.adamina(textStyle: textTheme.overline),
    );
  }

  /// Applies the Advent Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Advent+Pro
  static TextStyle adventPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4041ce69b488624d0653057137ff69ead9c9496be2059ede6a5056fd48780850',
        46400,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20f54f798dd883fc2fab8294006f8201f1deed59b0abd0ad6c6864bb0062eb47',
        46424,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23462d311ba53dbeac614ad5c99742d75264652538c2aaaea50fa3f9a37c1111',
        46356,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7084224aa15f7d31683e67bc3107aa12f725f4d20a10e9b65bbcec912162191',
        46836,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21feddd6602a8e2daf17501cb32c4b27a26b6a357f3652ad357008c8a90f1646',
        51004,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '908b9b388605933b6e469878f17c52da7e2cd9cd6c4ec72a3e12aa5a9c3b9b79',
        50772,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '962b3ce8591b2ca225b23e65b3914233c576d21700e3f24c6b820230fe8424e0',
        55976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AdventPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Advent Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Advent+Pro
  static TextTheme adventProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.adventPro(textStyle: textTheme.headline1),
      headline2: GoogleFonts.adventPro(textStyle: textTheme.headline2),
      headline3: GoogleFonts.adventPro(textStyle: textTheme.headline3),
      headline4: GoogleFonts.adventPro(textStyle: textTheme.headline4),
      headline5: GoogleFonts.adventPro(textStyle: textTheme.headline5),
      headline6: GoogleFonts.adventPro(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.adventPro(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.adventPro(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.adventPro(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.adventPro(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.adventPro(textStyle: textTheme.caption),
      button: GoogleFonts.adventPro(textStyle: textTheme.button),
      overline: GoogleFonts.adventPro(textStyle: textTheme.overline),
    );
  }

  /// Applies the Aguafina Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aguafina+Script
  static TextStyle aguafinaScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '282b677fa945b70a3a5a57b8ffb8064638a07feb77edc68cf29591225bc7b5ce',
        47180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AguafinaScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aguafina Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aguafina+Script
  static TextTheme aguafinaScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.aguafinaScript(textStyle: textTheme.headline1),
      headline2: GoogleFonts.aguafinaScript(textStyle: textTheme.headline2),
      headline3: GoogleFonts.aguafinaScript(textStyle: textTheme.headline3),
      headline4: GoogleFonts.aguafinaScript(textStyle: textTheme.headline4),
      headline5: GoogleFonts.aguafinaScript(textStyle: textTheme.headline5),
      headline6: GoogleFonts.aguafinaScript(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.aguafinaScript(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.aguafinaScript(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.aguafinaScript(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.aguafinaScript(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.aguafinaScript(textStyle: textTheme.caption),
      button: GoogleFonts.aguafinaScript(textStyle: textTheme.button),
      overline: GoogleFonts.aguafinaScript(textStyle: textTheme.overline),
    );
  }

  /// Applies the Akronim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akronim
  static TextStyle akronim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb077a1601fc7353abf83d6f7e667b5c1ff47a853f2a90f466be1dd738f4e6a1',
        107340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Akronim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Akronim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Akronim
  static TextTheme akronimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.akronim(textStyle: textTheme.headline1),
      headline2: GoogleFonts.akronim(textStyle: textTheme.headline2),
      headline3: GoogleFonts.akronim(textStyle: textTheme.headline3),
      headline4: GoogleFonts.akronim(textStyle: textTheme.headline4),
      headline5: GoogleFonts.akronim(textStyle: textTheme.headline5),
      headline6: GoogleFonts.akronim(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.akronim(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.akronim(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.akronim(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.akronim(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.akronim(textStyle: textTheme.caption),
      button: GoogleFonts.akronim(textStyle: textTheme.button),
      overline: GoogleFonts.akronim(textStyle: textTheme.overline),
    );
  }

  /// Applies the Aladin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aladin
  static TextStyle aladin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47e6aa68e0a6686d85005a8cd4e3c3055dc4828dc3b49d69fdf88f38491c8ae2',
        42112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aladin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aladin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aladin
  static TextTheme aladinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.aladin(textStyle: textTheme.headline1),
      headline2: GoogleFonts.aladin(textStyle: textTheme.headline2),
      headline3: GoogleFonts.aladin(textStyle: textTheme.headline3),
      headline4: GoogleFonts.aladin(textStyle: textTheme.headline4),
      headline5: GoogleFonts.aladin(textStyle: textTheme.headline5),
      headline6: GoogleFonts.aladin(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.aladin(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.aladin(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.aladin(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.aladin(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.aladin(textStyle: textTheme.caption),
      button: GoogleFonts.aladin(textStyle: textTheme.button),
      overline: GoogleFonts.aladin(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alata
  static TextStyle alata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e69926cd849e08f0dfa58fa809a89d58262ec6a29e3dd4e2c59ea279301b12e',
        63264,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alata
  static TextTheme alataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alata(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alata(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alata(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alata(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alata(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alata(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alata(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alata(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alata(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alata(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alata(textStyle: textTheme.caption),
      button: GoogleFonts.alata(textStyle: textTheme.button),
      overline: GoogleFonts.alata(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alatsi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alatsi
  static TextStyle alatsi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fa5a16b3bfdf1423bfccb98349fc2cee90ca48e42252467b9a36f5a3149622e',
        70056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alatsi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alatsi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alatsi
  static TextTheme alatsiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alatsi(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alatsi(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alatsi(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alatsi(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alatsi(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alatsi(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alatsi(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alatsi(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alatsi(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alatsi(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alatsi(textStyle: textTheme.caption),
      button: GoogleFonts.alatsi(textStyle: textTheme.button),
      overline: GoogleFonts.alatsi(textStyle: textTheme.overline),
    );
  }

  /// Applies the Aldrich font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aldrich
  static TextStyle aldrich({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e288c81eacbaee70be6e11a25f4fb3bdaffcc0ea0449f285c94fc558e64335f4',
        27932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aldrich',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aldrich font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aldrich
  static TextTheme aldrichTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.aldrich(textStyle: textTheme.headline1),
      headline2: GoogleFonts.aldrich(textStyle: textTheme.headline2),
      headline3: GoogleFonts.aldrich(textStyle: textTheme.headline3),
      headline4: GoogleFonts.aldrich(textStyle: textTheme.headline4),
      headline5: GoogleFonts.aldrich(textStyle: textTheme.headline5),
      headline6: GoogleFonts.aldrich(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.aldrich(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.aldrich(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.aldrich(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.aldrich(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.aldrich(textStyle: textTheme.caption),
      button: GoogleFonts.aldrich(textStyle: textTheme.button),
      overline: GoogleFonts.aldrich(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alef font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alef
  static TextStyle alef({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a50dedb5215d98f65036893675ded42762d4c7bdae624c71adb1ea584f5a1467',
        58300,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acbe7d381fcdbd3bca38351290cba306a1dde6549d74fbdef431ee9fcb60030d',
        59936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alef',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alef font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alef
  static TextTheme alefTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alef(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alef(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alef(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alef(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alef(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alef(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alef(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alef(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alef(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alef(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alef(textStyle: textTheme.caption),
      button: GoogleFonts.alef(textStyle: textTheme.button),
      overline: GoogleFonts.alef(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alegreya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya
  static TextStyle alegreya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '530d78cba23c5d8e261ae9447b431e1fa550f9dc6563540a0c400be3f7ee88ab',
        63708,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'efba5f9b4495a2e911ec871cc4dfebb5dba60bc72d643c0dd346e8f90513f81a',
        61596,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c00ad52d215d793be827a98a0661e13bbd3276c96c6aa5e6c8d71c9487a3da03',
        67268,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bd912b8f7b092f81fc94ee9f3b769e57ecbb1a2443bfce7d405d2ad0c48c04b4',
        65700,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2d4a4c114f8e7ad762e764046f117bf954b1ba7797bbe6b6d754decc9bdbf99',
        62328,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '01804c5bcb6aedbda393491d82c14328987c7fb66a6ef8c8313aed5d683d3dad',
        60620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alegreya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya
  static TextTheme alegreyaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alegreya(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alegreya(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alegreya(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alegreya(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alegreya(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alegreya(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alegreya(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alegreya(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alegreya(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alegreya(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alegreya(textStyle: textTheme.caption),
      button: GoogleFonts.alegreya(textStyle: textTheme.button),
      overline: GoogleFonts.alegreya(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alegreya SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+SC
  static TextStyle alegreyaSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7449fd0507a0808ae452506eb8fb2fb46b4abe72f8f5d982b25c963ba93bc094',
        72748,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6b36a9c6614f3cea8c2846f74b6823f8d3c5edd8a8b2319eccae142e3bb42738',
        73048,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16e159f79c1929fa884f232e47d45cb0cc16a55a22b127359024868245f4a2d4',
        71836,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6920f9042274d5d0b37753d233b86c7066a47d1cb94015d70ecbb9a76359faa7',
        72428,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd591a36a0d78f0315b16c23983d84d6d8b4bbf8ea5b5879019cad423941d5990',
        70500,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd312d023b86792b3a0f7cd9594498720cdb9feb7bec946d75a3f25f6580c19c7',
        71700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+SC
  static TextTheme alegreyaScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alegreyaSc(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alegreyaSc(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alegreyaSc(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alegreyaSc(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alegreyaSc(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alegreyaSc(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alegreyaSc(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alegreyaSc(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alegreyaSc(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alegreyaSc(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alegreyaSc(textStyle: textTheme.caption),
      button: GoogleFonts.alegreyaSc(textStyle: textTheme.button),
      overline: GoogleFonts.alegreyaSc(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alegreya Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans
  static TextStyle alegreyaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e4fc2370a575c44ada0a88565af306c9e5f6f863cd3e594f68fbecb64d6eb45',
        86800,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dfad029fd95bc8e1e6f4aff5ca9a40f7ee01b7c42436068b1a609af1036de968',
        75952,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f413bb7452d6c3127865026e765917685dde894f8130417ee32c5c22d3332a5a',
        88928,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53c675ca8ca26437bfdef9475e6be6a31d8f390904f2a25dc7f71ecacf749525',
        76244,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5186af372dbc9306a0390c6a53c2b3ed7e398bf7e19390e4115779d9d4dcb9e0',
        90044,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a1cf80b2ffea7f7a74c290c886e0853612aa20f2f2942a11b6221973a8b1125a',
        75740,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b54080b02a55195adec0aed32ecb384095ddfef221504059e15682a59709d9a5',
        90304,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '16b83ef0510db5d9b7adeb15a6bf505975df75012e3f04118c8384165bae4c4f',
        75644,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'baf6cfdcdaeaff8ae1997ba5a87f7c43b4823b8e094097eb354fdaeb531c610e',
        90308,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c3ea4ab25245b87d94c68e797ee68e472bf893023027f57d0dfb6aef204e650d',
        75464,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2313ece3a1be01342c2f2b902904ce864b05c9ecf3a72e96580c84ed124b370c',
        90492,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '296f24dc4713815e4ea5f25a60e938c00c6d94678ba90f140c4c4dcd5d3dae42',
        75552,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1ae94a74aa4998c1ed777107095512b795dd19783a838e9eaffca2382405bf3',
        90324,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '63fa7d406f209d33ac9020dc3209f61bda016b2e851b369e2475f6c77bd65111',
        75748,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans
  static TextTheme alegreyaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alegreyaSans(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alegreyaSans(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alegreyaSans(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alegreyaSans(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alegreyaSans(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alegreyaSans(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alegreyaSans(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alegreyaSans(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alegreyaSans(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alegreyaSans(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alegreyaSans(textStyle: textTheme.caption),
      button: GoogleFonts.alegreyaSans(textStyle: textTheme.button),
      overline: GoogleFonts.alegreyaSans(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alegreya Sans SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans+SC
  static TextStyle alegreyaSansSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f5b4f9e7531121c2163e92598f24222cdef538a04352553731f0c81f69c4227',
        77260,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1a8c6b334dbb0663e1b509d268363d557f9d231f702c2fb6ffe0727c0bb374b5',
        67308,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d94b7e8e30244280988269fbefbf776d08ff9ad0be6df4f620a6a5b7e0362f0',
        79488,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ccd17db40859ba985ad048cea705168d600d36d89c00086787c0e0c4b3d82350',
        67492,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2487f405a054a83c784021b2c8e860860b9243fb34fc64b7a5fd2250d68bf4f9',
        80884,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b427017865c854fea91f74c2c65b73010299f090c4ce77e0854fac9a1de8bc0a',
        67168,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'edb603dab26042252c435e746201e0f2f353dd09865130082f25072fb0969e0b',
        81296,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de77ecc3bedb1b421aebae8d44d23fc290cb7f252c8cd7eea6cc478ee69e13ec',
        67248,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c46b10c450739d774b11b6e3d2f51e421d416b9a8174d249ad85973c5018894c',
        81476,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '16e2233f43d03898a785024de868496150dfcba5754cec33d4e349b92c857453',
        67060,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '356b90a20e5818313f51f03a05985f5c63745944a01aa92b78804caa0b7a4268',
        81900,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '85eb333661be027f374e08a28cc4b0c394fa0052fc64197c5a96409168532e87',
        67216,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41a1bac96732155ce8415a0155d80de58383ab4223de540ad68c383f51b3cb5e',
        81560,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7100fdd6d991e596021a3bc2578fd4eb74fb5bd5d7dfc6c30dcde981e6a27281',
        67304,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlegreyaSansSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alegreya Sans SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alegreya+Sans+SC
  static TextTheme alegreyaSansScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alegreyaSansSc(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alegreyaSansSc(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alegreyaSansSc(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alegreyaSansSc(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alegreyaSansSc(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alegreyaSansSc(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alegreyaSansSc(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alegreyaSansSc(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alegreyaSansSc(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alegreyaSansSc(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alegreyaSansSc(textStyle: textTheme.caption),
      button: GoogleFonts.alegreyaSansSc(textStyle: textTheme.button),
      overline: GoogleFonts.alegreyaSansSc(textStyle: textTheme.overline),
    );
  }

  /// Applies the Aleo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aleo
  static TextStyle aleo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8844034f7614859b836238cb530853c190b011335edbfc9fd9dbb15669134bcb',
        35800,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9d41d1b8e554c18ef31b39cd96576f58048ab1dacd1e03dd349c3f471917ab43',
        45124,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4124c4a19546d618079ccad928418735907b0eff5c68a0faf16b8fd3ec1d5bc2',
        65892,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7662bf685a6bddd2908c8392229aac54817f3666c9915cec596880a13eef66c9',
        68788,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd20df7d3bc69a847115b4c7f6de4db4d8aa878a8ad3ccc70a83b9beb9d29826c',
        60744,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0277e97f9c04c3812b3987b151b56953251d09574f7f649b461074b2439a4026',
        64516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aleo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aleo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aleo
  static TextTheme aleoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.aleo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.aleo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.aleo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.aleo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.aleo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.aleo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.aleo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.aleo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.aleo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.aleo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.aleo(textStyle: textTheme.caption),
      button: GoogleFonts.aleo(textStyle: textTheme.button),
      overline: GoogleFonts.aleo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alex Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alex+Brush
  static TextStyle alexBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb8044f112b9878ec59f0825d91a9f011fc4925ce2272737c02ce2be161c3efd',
        48660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlexBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alex Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alex+Brush
  static TextTheme alexBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alexBrush(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alexBrush(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alexBrush(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alexBrush(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alexBrush(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alexBrush(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alexBrush(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alexBrush(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alexBrush(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alexBrush(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alexBrush(textStyle: textTheme.caption),
      button: GoogleFonts.alexBrush(textStyle: textTheme.button),
      overline: GoogleFonts.alexBrush(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alfa Slab One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alfa+Slab+One
  static TextStyle alfaSlabOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7da478a94cb0f5cdf81dc70a08204fc3d9b097463f65a9108151851580dd9151',
        64824,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlfaSlabOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alfa Slab One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alfa+Slab+One
  static TextTheme alfaSlabOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alfaSlabOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alfaSlabOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alfaSlabOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alfaSlabOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alfaSlabOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alfaSlabOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alfaSlabOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alfaSlabOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alfaSlabOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alfaSlabOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alfaSlabOne(textStyle: textTheme.caption),
      button: GoogleFonts.alfaSlabOne(textStyle: textTheme.button),
      overline: GoogleFonts.alfaSlabOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alice font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alice
  static TextStyle alice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b09d7119f6ceba6b3b798683927d8bd51757498f4af762dc4509d1c76aafc6a3',
        95148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alice font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alice
  static TextTheme aliceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alice(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alice(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alice(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alice(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alice(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alice(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alice(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alice(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alice(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alice(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alice(textStyle: textTheme.caption),
      button: GoogleFonts.alice(textStyle: textTheme.button),
      overline: GoogleFonts.alice(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alike font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike
  static TextStyle alike({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9683edf916072397bd15b9b312ff78533f85b4ac5598b5867733fb5670ed534',
        64584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Alike',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alike font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike
  static TextTheme alikeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alike(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alike(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alike(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alike(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alike(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alike(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alike(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alike(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alike(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alike(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alike(textStyle: textTheme.caption),
      button: GoogleFonts.alike(textStyle: textTheme.button),
      overline: GoogleFonts.alike(textStyle: textTheme.overline),
    );
  }

  /// Applies the Alike Angular font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike+Angular
  static TextStyle alikeAngular({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ae146a31a48840c579bbeefc31597a7c9b385c626ef8387ad461aeea8432452',
        97120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlikeAngular',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Alike Angular font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Alike+Angular
  static TextTheme alikeAngularTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.alikeAngular(textStyle: textTheme.headline1),
      headline2: GoogleFonts.alikeAngular(textStyle: textTheme.headline2),
      headline3: GoogleFonts.alikeAngular(textStyle: textTheme.headline3),
      headline4: GoogleFonts.alikeAngular(textStyle: textTheme.headline4),
      headline5: GoogleFonts.alikeAngular(textStyle: textTheme.headline5),
      headline6: GoogleFonts.alikeAngular(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.alikeAngular(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.alikeAngular(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.alikeAngular(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.alikeAngular(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.alikeAngular(textStyle: textTheme.caption),
      button: GoogleFonts.alikeAngular(textStyle: textTheme.button),
      overline: GoogleFonts.alikeAngular(textStyle: textTheme.overline),
    );
  }

  /// Applies the Allan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allan
  static TextStyle allan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83a268d06857cada4246725e7cc04eb4d7b87d19e6d4f44e745d33be739852fb',
        40992,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b309341937b6f2a1893638c71f9877c70c658e6461e5b18011f9ab7f2782adc9',
        95644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allan
  static TextTheme allanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.allan(textStyle: textTheme.headline1),
      headline2: GoogleFonts.allan(textStyle: textTheme.headline2),
      headline3: GoogleFonts.allan(textStyle: textTheme.headline3),
      headline4: GoogleFonts.allan(textStyle: textTheme.headline4),
      headline5: GoogleFonts.allan(textStyle: textTheme.headline5),
      headline6: GoogleFonts.allan(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.allan(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.allan(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.allan(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.allan(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.allan(textStyle: textTheme.caption),
      button: GoogleFonts.allan(textStyle: textTheme.button),
      overline: GoogleFonts.allan(textStyle: textTheme.overline),
    );
  }

  /// Applies the Allerta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta
  static TextStyle allerta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df4ce73d43a2a1eb976d66944a0555b8ab45b8848b9e9be9355d0f68a9373270',
        18844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allerta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allerta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta
  static TextTheme allertaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.allerta(textStyle: textTheme.headline1),
      headline2: GoogleFonts.allerta(textStyle: textTheme.headline2),
      headline3: GoogleFonts.allerta(textStyle: textTheme.headline3),
      headline4: GoogleFonts.allerta(textStyle: textTheme.headline4),
      headline5: GoogleFonts.allerta(textStyle: textTheme.headline5),
      headline6: GoogleFonts.allerta(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.allerta(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.allerta(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.allerta(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.allerta(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.allerta(textStyle: textTheme.caption),
      button: GoogleFonts.allerta(textStyle: textTheme.button),
      overline: GoogleFonts.allerta(textStyle: textTheme.overline),
    );
  }

  /// Applies the Allerta Stencil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta+Stencil
  static TextStyle allertaStencil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd43b315a156fb147d0bcd2dad6a682e5a23d388f0d12365c29c2d46fbf1e2c96',
        19512,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AllertaStencil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allerta Stencil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allerta+Stencil
  static TextTheme allertaStencilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.allertaStencil(textStyle: textTheme.headline1),
      headline2: GoogleFonts.allertaStencil(textStyle: textTheme.headline2),
      headline3: GoogleFonts.allertaStencil(textStyle: textTheme.headline3),
      headline4: GoogleFonts.allertaStencil(textStyle: textTheme.headline4),
      headline5: GoogleFonts.allertaStencil(textStyle: textTheme.headline5),
      headline6: GoogleFonts.allertaStencil(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.allertaStencil(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.allertaStencil(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.allertaStencil(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.allertaStencil(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.allertaStencil(textStyle: textTheme.caption),
      button: GoogleFonts.allertaStencil(textStyle: textTheme.button),
      overline: GoogleFonts.allertaStencil(textStyle: textTheme.overline),
    );
  }

  /// Applies the Allura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allura
  static TextStyle allura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32adf6de6bc3ee14bedf4674a1020492d2c2e4a939883aa672ff9a31777f63ed',
        88036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Allura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Allura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Allura
  static TextTheme alluraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.allura(textStyle: textTheme.headline1),
      headline2: GoogleFonts.allura(textStyle: textTheme.headline2),
      headline3: GoogleFonts.allura(textStyle: textTheme.headline3),
      headline4: GoogleFonts.allura(textStyle: textTheme.headline4),
      headline5: GoogleFonts.allura(textStyle: textTheme.headline5),
      headline6: GoogleFonts.allura(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.allura(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.allura(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.allura(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.allura(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.allura(textStyle: textTheme.caption),
      button: GoogleFonts.allura(textStyle: textTheme.button),
      overline: GoogleFonts.allura(textStyle: textTheme.overline),
    );
  }

  /// Applies the Almarai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almarai
  static TextStyle almarai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd65c40f0692b45d73302895b80e837f57f1b4e69a5d3255c3f186919eab23780',
        85828,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b22529a81e051312110ae38c450d9b4f5474030f2275dc4574f26c8fcf5318e',
        85912,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6cf3b7ecc9ac853f7071684fc5dfb22dd3a13f41901fee6aeb54cd9cc81d1126',
        85696,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55d68f8e4adef1c44ed2dbc154537092c330112b9ac46a94338e58f08f02bcb6',
        86588,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Almarai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almarai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almarai
  static TextTheme almaraiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.almarai(textStyle: textTheme.headline1),
      headline2: GoogleFonts.almarai(textStyle: textTheme.headline2),
      headline3: GoogleFonts.almarai(textStyle: textTheme.headline3),
      headline4: GoogleFonts.almarai(textStyle: textTheme.headline4),
      headline5: GoogleFonts.almarai(textStyle: textTheme.headline5),
      headline6: GoogleFonts.almarai(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.almarai(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.almarai(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.almarai(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.almarai(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.almarai(textStyle: textTheme.caption),
      button: GoogleFonts.almarai(textStyle: textTheme.button),
      overline: GoogleFonts.almarai(textStyle: textTheme.overline),
    );
  }

  /// Applies the Almendra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra
  static TextStyle almendra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08fa6c15ee1bba267ec0f0f30bd11a5be545d922ebd057f450a702f87aa9aaa8',
        68696,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd40d53b865a76778b1362d4e74f6c6294fbde5ae31f24f0173d9401c3fabcddc',
        35276,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b0792b18907bbbe9c24855a75a53fc8ac926ae12e181ec5bbc70fae19df05bfa',
        36684,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eb34d628f80f6ab95c12f0ef6dd4138d2182b94042d615028af5353e58b9f1ee',
        35448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Almendra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra
  static TextTheme almendraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.almendra(textStyle: textTheme.headline1),
      headline2: GoogleFonts.almendra(textStyle: textTheme.headline2),
      headline3: GoogleFonts.almendra(textStyle: textTheme.headline3),
      headline4: GoogleFonts.almendra(textStyle: textTheme.headline4),
      headline5: GoogleFonts.almendra(textStyle: textTheme.headline5),
      headline6: GoogleFonts.almendra(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.almendra(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.almendra(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.almendra(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.almendra(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.almendra(textStyle: textTheme.caption),
      button: GoogleFonts.almendra(textStyle: textTheme.button),
      overline: GoogleFonts.almendra(textStyle: textTheme.overline),
    );
  }

  /// Applies the Almendra Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+Display
  static TextStyle almendraDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8aa056bca4ab7efab868e9b7a435eea1109abde7b232725b1e1b41cf482191a',
        39284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlmendraDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+Display
  static TextTheme almendraDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.almendraDisplay(textStyle: textTheme.headline1),
      headline2: GoogleFonts.almendraDisplay(textStyle: textTheme.headline2),
      headline3: GoogleFonts.almendraDisplay(textStyle: textTheme.headline3),
      headline4: GoogleFonts.almendraDisplay(textStyle: textTheme.headline4),
      headline5: GoogleFonts.almendraDisplay(textStyle: textTheme.headline5),
      headline6: GoogleFonts.almendraDisplay(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.almendraDisplay(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.almendraDisplay(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.almendraDisplay(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.almendraDisplay(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.almendraDisplay(textStyle: textTheme.caption),
      button: GoogleFonts.almendraDisplay(textStyle: textTheme.button),
      overline: GoogleFonts.almendraDisplay(textStyle: textTheme.overline),
    );
  }

  /// Applies the Almendra SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+SC
  static TextStyle almendraSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12f0d325f41e23a75aa0ddb706236e13487d31b43a77435817a684f239f324bd',
        36008,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AlmendraSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Almendra SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Almendra+SC
  static TextTheme almendraScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.almendraSc(textStyle: textTheme.headline1),
      headline2: GoogleFonts.almendraSc(textStyle: textTheme.headline2),
      headline3: GoogleFonts.almendraSc(textStyle: textTheme.headline3),
      headline4: GoogleFonts.almendraSc(textStyle: textTheme.headline4),
      headline5: GoogleFonts.almendraSc(textStyle: textTheme.headline5),
      headline6: GoogleFonts.almendraSc(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.almendraSc(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.almendraSc(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.almendraSc(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.almendraSc(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.almendraSc(textStyle: textTheme.caption),
      button: GoogleFonts.almendraSc(textStyle: textTheme.button),
      overline: GoogleFonts.almendraSc(textStyle: textTheme.overline),
    );
  }

  /// Applies the Amarante font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amarante
  static TextStyle amarante({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f11a52c1a0f3e94f81dde8d9c60832c688c1d9b01c5bb1098c3ea30daac8ad29',
        74348,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amarante',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amarante font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amarante
  static TextTheme amaranteTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.amarante(textStyle: textTheme.headline1),
      headline2: GoogleFonts.amarante(textStyle: textTheme.headline2),
      headline3: GoogleFonts.amarante(textStyle: textTheme.headline3),
      headline4: GoogleFonts.amarante(textStyle: textTheme.headline4),
      headline5: GoogleFonts.amarante(textStyle: textTheme.headline5),
      headline6: GoogleFonts.amarante(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.amarante(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.amarante(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.amarante(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.amarante(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.amarante(textStyle: textTheme.caption),
      button: GoogleFonts.amarante(textStyle: textTheme.button),
      overline: GoogleFonts.amarante(textStyle: textTheme.overline),
    );
  }

  /// Applies the Amaranth font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amaranth
  static TextStyle amaranth({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b8c69a7d5f0b230b1b010da8da3ad4ccb84f4dff4a1247a14af83392c9ecf64',
        66272,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '359639014bf096771cbebb373f2d347f8e1b44a2ef2b48556e1a21289dbc7eb5',
        74196,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b35625ebc301f471cd70df7575f4fc81597a8ab27dc321418707c40d8a99616',
        65892,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '48c74968a6ddedd92d0c4d4e05959d24a1ae124fce3ab60c793c5a331dddee10',
        74616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amaranth',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amaranth font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amaranth
  static TextTheme amaranthTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.amaranth(textStyle: textTheme.headline1),
      headline2: GoogleFonts.amaranth(textStyle: textTheme.headline2),
      headline3: GoogleFonts.amaranth(textStyle: textTheme.headline3),
      headline4: GoogleFonts.amaranth(textStyle: textTheme.headline4),
      headline5: GoogleFonts.amaranth(textStyle: textTheme.headline5),
      headline6: GoogleFonts.amaranth(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.amaranth(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.amaranth(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.amaranth(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.amaranth(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.amaranth(textStyle: textTheme.caption),
      button: GoogleFonts.amaranth(textStyle: textTheme.button),
      overline: GoogleFonts.amaranth(textStyle: textTheme.overline),
    );
  }

  /// Applies the Amatic SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatic+SC
  static TextStyle amaticSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9da6405b57357f309f00592371cf54bb3c1d57b8e7d9fc40fff6f364d6ca80fe',
        104904,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81f4df2ecbc8d2fcae65290f5075ff98149f4f95ea00bb6bf3a0711e4e1afd75',
        99680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AmaticSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amatic SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatic+SC
  static TextTheme amaticScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.amaticSc(textStyle: textTheme.headline1),
      headline2: GoogleFonts.amaticSc(textStyle: textTheme.headline2),
      headline3: GoogleFonts.amaticSc(textStyle: textTheme.headline3),
      headline4: GoogleFonts.amaticSc(textStyle: textTheme.headline4),
      headline5: GoogleFonts.amaticSc(textStyle: textTheme.headline5),
      headline6: GoogleFonts.amaticSc(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.amaticSc(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.amaticSc(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.amaticSc(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.amaticSc(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.amaticSc(textStyle: textTheme.caption),
      button: GoogleFonts.amaticSc(textStyle: textTheme.button),
      overline: GoogleFonts.amaticSc(textStyle: textTheme.overline),
    );
  }

  /// Applies the Amatica SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatica+SC
  static TextStyle amaticaSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39a7e41edc371bdb0e8356c4e9f69ea62594cfd412fbb1f5c45a32c0a5e75516',
        140932,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ead630d51d6f70a5e14a17fec1bffc04c9a13118b217101fd42eac20be2ae66',
        105524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AmaticaSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amatica SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amatica+SC
  static TextTheme amaticaScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.amaticaSc(textStyle: textTheme.headline1),
      headline2: GoogleFonts.amaticaSc(textStyle: textTheme.headline2),
      headline3: GoogleFonts.amaticaSc(textStyle: textTheme.headline3),
      headline4: GoogleFonts.amaticaSc(textStyle: textTheme.headline4),
      headline5: GoogleFonts.amaticaSc(textStyle: textTheme.headline5),
      headline6: GoogleFonts.amaticaSc(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.amaticaSc(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.amaticaSc(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.amaticaSc(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.amaticaSc(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.amaticaSc(textStyle: textTheme.caption),
      button: GoogleFonts.amaticaSc(textStyle: textTheme.button),
      overline: GoogleFonts.amaticaSc(textStyle: textTheme.overline),
    );
  }

  /// Applies the Amethysta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amethysta
  static TextStyle amethysta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4d26711903ae08c3bd10750f3b713928bdd3ee56d00372e37bd8606a3fe2d7a',
        36864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amethysta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amethysta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amethysta
  static TextTheme amethystaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.amethysta(textStyle: textTheme.headline1),
      headline2: GoogleFonts.amethysta(textStyle: textTheme.headline2),
      headline3: GoogleFonts.amethysta(textStyle: textTheme.headline3),
      headline4: GoogleFonts.amethysta(textStyle: textTheme.headline4),
      headline5: GoogleFonts.amethysta(textStyle: textTheme.headline5),
      headline6: GoogleFonts.amethysta(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.amethysta(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.amethysta(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.amethysta(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.amethysta(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.amethysta(textStyle: textTheme.caption),
      button: GoogleFonts.amethysta(textStyle: textTheme.button),
      overline: GoogleFonts.amethysta(textStyle: textTheme.overline),
    );
  }

  /// Applies the Amiko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiko
  static TextStyle amiko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2e782cc6b503328a87e3b81b3ee6afa1acb6cd66bd04d9da2ba5d3ff4c43e3f',
        143076,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd56799efb6c3d56b106cae38c558a3f2f9da3d0a90d0d1ea64449c693d3cadfc',
        142664,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '037bbdff86b70266d62abc94be043671d3c04188f477dbb0ead70ee89df98ecb',
        142052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amiko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiko
  static TextTheme amikoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.amiko(textStyle: textTheme.headline1),
      headline2: GoogleFonts.amiko(textStyle: textTheme.headline2),
      headline3: GoogleFonts.amiko(textStyle: textTheme.headline3),
      headline4: GoogleFonts.amiko(textStyle: textTheme.headline4),
      headline5: GoogleFonts.amiko(textStyle: textTheme.headline5),
      headline6: GoogleFonts.amiko(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.amiko(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.amiko(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.amiko(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.amiko(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.amiko(textStyle: textTheme.caption),
      button: GoogleFonts.amiko(textStyle: textTheme.button),
      overline: GoogleFonts.amiko(textStyle: textTheme.overline),
    );
  }

  /// Applies the Amiri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri
  static TextStyle amiri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '15af380107efd8a082b372d1ba8027d5fd6d4720ccf7f7ce48345b845cfb83b6',
        370496,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '03496500b8efdd151ca91912b003f23e04fcb45a8d39cee588e4ea47b61fc052',
        357340,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1f6fcfa01fc6084132c66ff5b8da7b655fbf82dae7a9200c4471400281678bb',
        351752,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9d9add54ab339fd5ca1f0b2fbda1117e04758800cefa39fa72d5f1e38b7a2e27',
        355324,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amiri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amiri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amiri
  static TextTheme amiriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.amiri(textStyle: textTheme.headline1),
      headline2: GoogleFonts.amiri(textStyle: textTheme.headline2),
      headline3: GoogleFonts.amiri(textStyle: textTheme.headline3),
      headline4: GoogleFonts.amiri(textStyle: textTheme.headline4),
      headline5: GoogleFonts.amiri(textStyle: textTheme.headline5),
      headline6: GoogleFonts.amiri(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.amiri(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.amiri(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.amiri(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.amiri(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.amiri(textStyle: textTheme.caption),
      button: GoogleFonts.amiri(textStyle: textTheme.button),
      overline: GoogleFonts.amiri(textStyle: textTheme.overline),
    );
  }

  /// Applies the Amita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amita
  static TextStyle amita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8ab328073e1c729f0b4f38521b47bb39c63db396da1602f6b08a2a8775249f4',
        141504,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e421cec126c6014995b96189e28c3c8b119e3e21dbe1c3dea8585ec31afa0679',
        141464,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Amita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Amita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Amita
  static TextTheme amitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.amita(textStyle: textTheme.headline1),
      headline2: GoogleFonts.amita(textStyle: textTheme.headline2),
      headline3: GoogleFonts.amita(textStyle: textTheme.headline3),
      headline4: GoogleFonts.amita(textStyle: textTheme.headline4),
      headline5: GoogleFonts.amita(textStyle: textTheme.headline5),
      headline6: GoogleFonts.amita(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.amita(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.amita(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.amita(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.amita(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.amita(textStyle: textTheme.caption),
      button: GoogleFonts.amita(textStyle: textTheme.button),
      overline: GoogleFonts.amita(textStyle: textTheme.overline),
    );
  }

  /// Applies the Anaheim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anaheim
  static TextStyle anaheim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '738fa7ae0283744abbfcfd999eb71d255210a7ee0fa7e195a47482269b9e381e',
        27848,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anaheim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anaheim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anaheim
  static TextTheme anaheimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.anaheim(textStyle: textTheme.headline1),
      headline2: GoogleFonts.anaheim(textStyle: textTheme.headline2),
      headline3: GoogleFonts.anaheim(textStyle: textTheme.headline3),
      headline4: GoogleFonts.anaheim(textStyle: textTheme.headline4),
      headline5: GoogleFonts.anaheim(textStyle: textTheme.headline5),
      headline6: GoogleFonts.anaheim(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.anaheim(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.anaheim(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.anaheim(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.anaheim(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.anaheim(textStyle: textTheme.caption),
      button: GoogleFonts.anaheim(textStyle: textTheme.button),
      overline: GoogleFonts.anaheim(textStyle: textTheme.overline),
    );
  }

  /// Applies the Andada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada
  static TextStyle andada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c3fda3cdd2dcc60f34129cdd9c0a2f139b2a4bec16bcff6b27521d87d222f1e',
        108572,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Andada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andada
  static TextTheme andadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.andada(textStyle: textTheme.headline1),
      headline2: GoogleFonts.andada(textStyle: textTheme.headline2),
      headline3: GoogleFonts.andada(textStyle: textTheme.headline3),
      headline4: GoogleFonts.andada(textStyle: textTheme.headline4),
      headline5: GoogleFonts.andada(textStyle: textTheme.headline5),
      headline6: GoogleFonts.andada(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.andada(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.andada(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.andada(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.andada(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.andada(textStyle: textTheme.caption),
      button: GoogleFonts.andada(textStyle: textTheme.button),
      overline: GoogleFonts.andada(textStyle: textTheme.overline),
    );
  }

  /// Applies the Andika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika
  static TextStyle andika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c10763224ab91314d3fae862634f6bddf0aae60bd71668d68950102ca77b5d4',
        964524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Andika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika
  static TextTheme andikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.andika(textStyle: textTheme.headline1),
      headline2: GoogleFonts.andika(textStyle: textTheme.headline2),
      headline3: GoogleFonts.andika(textStyle: textTheme.headline3),
      headline4: GoogleFonts.andika(textStyle: textTheme.headline4),
      headline5: GoogleFonts.andika(textStyle: textTheme.headline5),
      headline6: GoogleFonts.andika(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.andika(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.andika(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.andika(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.andika(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.andika(textStyle: textTheme.caption),
      button: GoogleFonts.andika(textStyle: textTheme.button),
      overline: GoogleFonts.andika(textStyle: textTheme.overline),
    );
  }

  /// Applies the Andika New Basic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika+New+Basic
  static TextStyle andikaNewBasic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48b18f488f9907c784ac7924a2d763257e1057f5ac3ee22c804ab0ba194253fb',
        71420,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '65eed85f74c45790107ec98d6a3098e99d4f54a7580b53d536891a35385b16ba',
        75508,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50bbb54d0ec04a720a330e87931ea2be85d5fc406fd2e171ce44ca67855f8a8d',
        72220,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a2a105533f2063ef7f4a489f1d438cf7af064f1c5ed1c3ebc6ba7c1d46c8db40',
        76148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AndikaNewBasic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Andika New Basic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Andika+New+Basic
  static TextTheme andikaNewBasicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.andikaNewBasic(textStyle: textTheme.headline1),
      headline2: GoogleFonts.andikaNewBasic(textStyle: textTheme.headline2),
      headline3: GoogleFonts.andikaNewBasic(textStyle: textTheme.headline3),
      headline4: GoogleFonts.andikaNewBasic(textStyle: textTheme.headline4),
      headline5: GoogleFonts.andikaNewBasic(textStyle: textTheme.headline5),
      headline6: GoogleFonts.andikaNewBasic(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.andikaNewBasic(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.andikaNewBasic(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.andikaNewBasic(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.andikaNewBasic(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.andikaNewBasic(textStyle: textTheme.caption),
      button: GoogleFonts.andikaNewBasic(textStyle: textTheme.button),
      overline: GoogleFonts.andikaNewBasic(textStyle: textTheme.overline),
    );
  }

  /// Applies the Annie Use Your Telescope font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annie+Use+Your+Telescope
  static TextStyle annieUseYourTelescope({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '65c0cd06d1ec2528de45688966f2971cf95fed9f810f246e08b4efd9e717d850',
        50692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnnieUseYourTelescope',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Annie Use Your Telescope font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Annie+Use+Your+Telescope
  static TextTheme annieUseYourTelescopeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headline1),
      headline2:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headline2),
      headline3:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headline3),
      headline4:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headline4),
      headline5:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headline5),
      headline6:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.headline6),
      subtitle1:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.subtitle1),
      subtitle2:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.subtitle2),
      bodyText1:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.bodyText1),
      bodyText2:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.annieUseYourTelescope(textStyle: textTheme.caption),
      button: GoogleFonts.annieUseYourTelescope(textStyle: textTheme.button),
      overline:
          GoogleFonts.annieUseYourTelescope(textStyle: textTheme.overline),
    );
  }

  /// Applies the Anonymous Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anonymous+Pro
  static TextStyle anonymousPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ca7beef0b5eb5c9e72533cd45bc1e4f41c8272dc2335f22d3649e32a795995f',
        106796,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '71ce3ee6476a91f9e89e9f8010d9ea13314306b645af3e8d7b7add697e6f0d3e',
        108996,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd00937283f3b530bee6700e02cfabfbb96b833d42559d48fc5fdfcfde2ff5b39',
        106604,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '60f1f3cae99bbc1323cdcdf9af6a0127d5b4684ef675e6836fa3034a297dc16a',
        108760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnonymousPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anonymous Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anonymous+Pro
  static TextTheme anonymousProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.anonymousPro(textStyle: textTheme.headline1),
      headline2: GoogleFonts.anonymousPro(textStyle: textTheme.headline2),
      headline3: GoogleFonts.anonymousPro(textStyle: textTheme.headline3),
      headline4: GoogleFonts.anonymousPro(textStyle: textTheme.headline4),
      headline5: GoogleFonts.anonymousPro(textStyle: textTheme.headline5),
      headline6: GoogleFonts.anonymousPro(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.anonymousPro(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.anonymousPro(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.anonymousPro(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.anonymousPro(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.anonymousPro(textStyle: textTheme.caption),
      button: GoogleFonts.anonymousPro(textStyle: textTheme.button),
      overline: GoogleFonts.anonymousPro(textStyle: textTheme.overline),
    );
  }

  /// Applies the Antic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic
  static TextStyle antic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6526fff8a94a5503810bc8805b716126e91295380d0e970f089e3e663a4440d5',
        39272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Antic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic
  static TextTheme anticTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.antic(textStyle: textTheme.headline1),
      headline2: GoogleFonts.antic(textStyle: textTheme.headline2),
      headline3: GoogleFonts.antic(textStyle: textTheme.headline3),
      headline4: GoogleFonts.antic(textStyle: textTheme.headline4),
      headline5: GoogleFonts.antic(textStyle: textTheme.headline5),
      headline6: GoogleFonts.antic(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.antic(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.antic(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.antic(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.antic(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.antic(textStyle: textTheme.caption),
      button: GoogleFonts.antic(textStyle: textTheme.button),
      overline: GoogleFonts.antic(textStyle: textTheme.overline),
    );
  }

  /// Applies the Antic Didone font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Didone
  static TextStyle anticDidone({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed8ca32ea2c34cc27f4a10cdf51c0ddb35d0cd580df90b19e68d8096a145ec35',
        39640,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnticDidone',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic Didone font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Didone
  static TextTheme anticDidoneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.anticDidone(textStyle: textTheme.headline1),
      headline2: GoogleFonts.anticDidone(textStyle: textTheme.headline2),
      headline3: GoogleFonts.anticDidone(textStyle: textTheme.headline3),
      headline4: GoogleFonts.anticDidone(textStyle: textTheme.headline4),
      headline5: GoogleFonts.anticDidone(textStyle: textTheme.headline5),
      headline6: GoogleFonts.anticDidone(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.anticDidone(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.anticDidone(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.anticDidone(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.anticDidone(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.anticDidone(textStyle: textTheme.caption),
      button: GoogleFonts.anticDidone(textStyle: textTheme.button),
      overline: GoogleFonts.anticDidone(textStyle: textTheme.overline),
    );
  }

  /// Applies the Antic Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Slab
  static TextStyle anticSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1348202760ad87d67e74d3a921ad2be20b563b2cd2a8d6e99d54da029c7f2aad',
        36924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AnticSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Antic Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Antic+Slab
  static TextTheme anticSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.anticSlab(textStyle: textTheme.headline1),
      headline2: GoogleFonts.anticSlab(textStyle: textTheme.headline2),
      headline3: GoogleFonts.anticSlab(textStyle: textTheme.headline3),
      headline4: GoogleFonts.anticSlab(textStyle: textTheme.headline4),
      headline5: GoogleFonts.anticSlab(textStyle: textTheme.headline5),
      headline6: GoogleFonts.anticSlab(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.anticSlab(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.anticSlab(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.anticSlab(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.anticSlab(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.anticSlab(textStyle: textTheme.caption),
      button: GoogleFonts.anticSlab(textStyle: textTheme.button),
      overline: GoogleFonts.anticSlab(textStyle: textTheme.overline),
    );
  }

  /// Applies the Anton font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anton
  static TextStyle anton({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0d29150a430129b0bfdaabaa46ba1e7967ccabc46440a5789bffe18b7dfcc2d',
        54896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Anton',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Anton font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Anton
  static TextTheme antonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.anton(textStyle: textTheme.headline1),
      headline2: GoogleFonts.anton(textStyle: textTheme.headline2),
      headline3: GoogleFonts.anton(textStyle: textTheme.headline3),
      headline4: GoogleFonts.anton(textStyle: textTheme.headline4),
      headline5: GoogleFonts.anton(textStyle: textTheme.headline5),
      headline6: GoogleFonts.anton(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.anton(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.anton(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.anton(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.anton(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.anton(textStyle: textTheme.caption),
      button: GoogleFonts.anton(textStyle: textTheme.button),
      overline: GoogleFonts.anton(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arapey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arapey
  static TextStyle arapey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d4786e233fac8fe0069ba6efaa828eb2fffef7b1d21a92a6d4f250ae9710415',
        26716,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '10f469eeecd1cca95a1881d5fbd920abff25911a343caf957f7b2a0e3d4de390',
        29520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arapey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arapey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arapey
  static TextTheme arapeyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arapey(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arapey(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arapey(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arapey(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arapey(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arapey(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arapey(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arapey(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arapey(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arapey(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arapey(textStyle: textTheme.caption),
      button: GoogleFonts.arapey(textStyle: textTheme.button),
      overline: GoogleFonts.arapey(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arbutus font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus
  static TextStyle arbutus({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1484fe1dd2948c05f4d1ab7f6acbbc88d4acea2e32880263ec8f991cba4905f',
        81792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arbutus',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arbutus font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus
  static TextTheme arbutusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arbutus(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arbutus(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arbutus(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arbutus(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arbutus(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arbutus(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arbutus(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arbutus(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arbutus(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arbutus(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arbutus(textStyle: textTheme.caption),
      button: GoogleFonts.arbutus(textStyle: textTheme.button),
      overline: GoogleFonts.arbutus(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arbutus Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus+Slab
  static TextStyle arbutusSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7c7bbc09f84fc70a8541195a960de7d282eeaee64c5b146253bd79fd209893d',
        39812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArbutusSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arbutus Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arbutus+Slab
  static TextTheme arbutusSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arbutusSlab(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arbutusSlab(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arbutusSlab(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arbutusSlab(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arbutusSlab(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arbutusSlab(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arbutusSlab(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arbutusSlab(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arbutusSlab(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arbutusSlab(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arbutusSlab(textStyle: textTheme.caption),
      button: GoogleFonts.arbutusSlab(textStyle: textTheme.button),
      overline: GoogleFonts.arbutusSlab(textStyle: textTheme.overline),
    );
  }

  /// Applies the Architects Daughter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Architects+Daughter
  static TextStyle architectsDaughter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4f5860f4b7aca9b95305b6c5a3b14e2f1c951eaddd28b5d1fffd374171ccdba',
        43356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchitectsDaughter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Architects Daughter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Architects+Daughter
  static TextTheme architectsDaughterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.architectsDaughter(textStyle: textTheme.headline1),
      headline2: GoogleFonts.architectsDaughter(textStyle: textTheme.headline2),
      headline3: GoogleFonts.architectsDaughter(textStyle: textTheme.headline3),
      headline4: GoogleFonts.architectsDaughter(textStyle: textTheme.headline4),
      headline5: GoogleFonts.architectsDaughter(textStyle: textTheme.headline5),
      headline6: GoogleFonts.architectsDaughter(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.architectsDaughter(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.architectsDaughter(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.architectsDaughter(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.architectsDaughter(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.architectsDaughter(textStyle: textTheme.caption),
      button: GoogleFonts.architectsDaughter(textStyle: textTheme.button),
      overline: GoogleFonts.architectsDaughter(textStyle: textTheme.overline),
    );
  }

  /// Applies the Archivo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo
  static TextStyle archivo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3992a886b3891c9b073cf3e46b1c578cb31ab065cf9b5e07f6fc2a0200a495f',
        58160,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8af059c64838f116e4c8afda7a5c344815c3fe3c2111749d7281a046087dfb8a',
        60944,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '455a61b80b447af7647cb7bbbef6de06c3c3031d0ecbb2619fa9cffa73871e76',
        59648,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c266aeada4adba34caec3d404c7953743cf0327123506b66cde56cf556ad2ddf',
        62104,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ad030ef4465b1be7229c5326d24955683bea533c9646e4ed2773cd30697d031',
        59960,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '453878357ed380bea09e3661badd4636234be8794956428236bc3a166d84fc92',
        62300,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c37a5634c5b7802983e322dcc187d5b4bc26e238dd61828a71f184592b9032f',
        59436,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '12b65a3c8f63eb390f4acb0a6ade0ac245782113ddc2e397c216c3605fc245f8',
        62036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Archivo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo
  static TextTheme archivoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.archivo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.archivo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.archivo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.archivo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.archivo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.archivo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.archivo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.archivo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.archivo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.archivo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.archivo(textStyle: textTheme.caption),
      button: GoogleFonts.archivo(textStyle: textTheme.button),
      overline: GoogleFonts.archivo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Archivo Black font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Black
  static TextStyle archivoBlack({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdd008fdde6eaf026762810841b23a803c1fd8f7691df010d250df61e584703b',
        59204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchivoBlack',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo Black font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Black
  static TextTheme archivoBlackTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.archivoBlack(textStyle: textTheme.headline1),
      headline2: GoogleFonts.archivoBlack(textStyle: textTheme.headline2),
      headline3: GoogleFonts.archivoBlack(textStyle: textTheme.headline3),
      headline4: GoogleFonts.archivoBlack(textStyle: textTheme.headline4),
      headline5: GoogleFonts.archivoBlack(textStyle: textTheme.headline5),
      headline6: GoogleFonts.archivoBlack(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.archivoBlack(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.archivoBlack(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.archivoBlack(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.archivoBlack(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.archivoBlack(textStyle: textTheme.caption),
      button: GoogleFonts.archivoBlack(textStyle: textTheme.button),
      overline: GoogleFonts.archivoBlack(textStyle: textTheme.overline),
    );
  }

  /// Applies the Archivo Narrow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Narrow
  static TextStyle archivoNarrow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95b4094186b9443c74e987b6a5ad660b55c7dc1e548d66cc53ead05a10bf096f',
        57132,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c5be034d89310f5e551f67507ef7bd0d5093e193d5e556598e1137cff7598ada',
        58796,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '898e57eec4db5685859996bc7c9a87707d53ceca97c917edb0497302b7145fd5',
        55924,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ff034a0073d594043d35a5058bf44df331be4b22576c8a753b210bcc55789e50',
        59204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArchivoNarrow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Archivo Narrow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Archivo+Narrow
  static TextTheme archivoNarrowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.archivoNarrow(textStyle: textTheme.headline1),
      headline2: GoogleFonts.archivoNarrow(textStyle: textTheme.headline2),
      headline3: GoogleFonts.archivoNarrow(textStyle: textTheme.headline3),
      headline4: GoogleFonts.archivoNarrow(textStyle: textTheme.headline4),
      headline5: GoogleFonts.archivoNarrow(textStyle: textTheme.headline5),
      headline6: GoogleFonts.archivoNarrow(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.archivoNarrow(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.archivoNarrow(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.archivoNarrow(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.archivoNarrow(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.archivoNarrow(textStyle: textTheme.caption),
      button: GoogleFonts.archivoNarrow(textStyle: textTheme.button),
      overline: GoogleFonts.archivoNarrow(textStyle: textTheme.overline),
    );
  }

  /// Applies the Aref Ruqaa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa
  static TextStyle arefRuqaa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '483d6ce42473c62a61b38dc4e30c6b1a5d9b02921ab5034c8eec4b8f0496127d',
        112872,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ea198095e22fea5b0b08338b3b524a2ac489bd669154eab1927955f20124358',
        139992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArefRuqaa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aref Ruqaa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aref+Ruqaa
  static TextTheme arefRuqaaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arefRuqaa(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arefRuqaa(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arefRuqaa(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arefRuqaa(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arefRuqaa(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arefRuqaa(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arefRuqaa(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arefRuqaa(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arefRuqaa(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arefRuqaa(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arefRuqaa(textStyle: textTheme.caption),
      button: GoogleFonts.arefRuqaa(textStyle: textTheme.button),
      overline: GoogleFonts.arefRuqaa(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arima Madurai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arima+Madurai
  static TextStyle arimaMadurai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20fe984789a290b9c540b82d788511cf37e7dcb0c94a3f808ed8a9980ce92262',
        92064,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ea122a5616110be9d6b0719ff9a8e5d87a5bb067671e53f60e9e2f34151a054',
        92944,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9bb6dffdcb0e85ac571c284727a1ff484951f065ccff0e42668f232709bcfd0',
        93064,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72a8a5252b9293d6af843e90bdda0f995b86531cb25d7a2489b5b58e7c495575',
        93452,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b608979162b4bce202e22f3cba5768ef3c5f96294c41e1d36229b02393a70cf7',
        93560,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9809fc1ba075315f2526aba738bb8c4bfb8af33451d402a57eae3edbdbe45b6',
        93480,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '030889c403dcab9b3a79394ed59d1d1da7d0dbafae26fc8c6d1b870d7732c997',
        93616,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25561cbe875f9bad0c96c060f2a1f8108ba709366496e68ff510efdf5930429f',
        93604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ArimaMadurai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arima Madurai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arima+Madurai
  static TextTheme arimaMaduraiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arimaMadurai(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arimaMadurai(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arimaMadurai(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arimaMadurai(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arimaMadurai(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arimaMadurai(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arimaMadurai(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arimaMadurai(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arimaMadurai(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arimaMadurai(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arimaMadurai(textStyle: textTheme.caption),
      button: GoogleFonts.arimaMadurai(textStyle: textTheme.button),
      overline: GoogleFonts.arimaMadurai(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arimo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arimo
  static TextStyle arimo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df255da5c656bbf01f4aa3012b4d4ba16f7bd17664a4e1fc011146a4eb95d436',
        242708,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eafe825bf96517b1ff3b8d8710254e225584de1489e4c3deaa6b1cb8549a027d',
        249396,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a4f400fb6090e3938136ea6fd3ec2c02777fb674d13b9582f96d4515044df23',
        240652,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e6b358f015564a1505c76b32db9b3f5c538a8f7d220dd04446697d286c820bf0',
        248528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arimo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arimo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arimo
  static TextTheme arimoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arimo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arimo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arimo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arimo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arimo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arimo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arimo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arimo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arimo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arimo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arimo(textStyle: textTheme.caption),
      button: GoogleFonts.arimo(textStyle: textTheme.button),
      overline: GoogleFonts.arimo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arizonia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arizonia
  static TextStyle arizonia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '603a1ae367969056ace1484bd5db4d882fabfa78008e6843d3ba07c08082c2c7',
        50688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arizonia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arizonia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arizonia
  static TextTheme arizoniaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arizonia(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arizonia(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arizonia(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arizonia(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arizonia(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arizonia(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arizonia(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arizonia(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arizonia(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arizonia(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arizonia(textStyle: textTheme.caption),
      button: GoogleFonts.arizonia(textStyle: textTheme.button),
      overline: GoogleFonts.arizonia(textStyle: textTheme.overline),
    );
  }

  /// Applies the Armata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Armata
  static TextStyle armata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7631b4ae2fae472da8b9d0b46acfec928c9c550e82dbee1685e72f389ab890d9',
        54772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Armata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Armata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Armata
  static TextTheme armataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.armata(textStyle: textTheme.headline1),
      headline2: GoogleFonts.armata(textStyle: textTheme.headline2),
      headline3: GoogleFonts.armata(textStyle: textTheme.headline3),
      headline4: GoogleFonts.armata(textStyle: textTheme.headline4),
      headline5: GoogleFonts.armata(textStyle: textTheme.headline5),
      headline6: GoogleFonts.armata(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.armata(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.armata(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.armata(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.armata(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.armata(textStyle: textTheme.caption),
      button: GoogleFonts.armata(textStyle: textTheme.button),
      overline: GoogleFonts.armata(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arsenal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arsenal
  static TextStyle arsenal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b13a735c3c27289a74f4e934b380f078f89568b2633c5d8386e97a97d46158c',
        140064,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f687cc6b9b17ac45aaf3391fbe649c2e1607804ce3ab85daddf9669f796d0a79',
        138944,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ac62eb1c6ee28d30c2dacea06acdbec9c72bcbfdca1f76a873b8a2c18ac8ae6',
        141180,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '41b9ba2384a037e4ec361896e5868107cfa8535ab8befda2d9666584884aca80',
        139236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arsenal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arsenal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arsenal
  static TextTheme arsenalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arsenal(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arsenal(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arsenal(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arsenal(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arsenal(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arsenal(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arsenal(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arsenal(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arsenal(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arsenal(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arsenal(textStyle: textTheme.caption),
      button: GoogleFonts.arsenal(textStyle: textTheme.button),
      overline: GoogleFonts.arsenal(textStyle: textTheme.overline),
    );
  }

  /// Applies the Artifika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Artifika
  static TextStyle artifika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0d399a0a07f993bcb6bdd075a4e0f6ae155d222d230710b94d48933e8470dbf',
        100216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Artifika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Artifika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Artifika
  static TextTheme artifikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.artifika(textStyle: textTheme.headline1),
      headline2: GoogleFonts.artifika(textStyle: textTheme.headline2),
      headline3: GoogleFonts.artifika(textStyle: textTheme.headline3),
      headline4: GoogleFonts.artifika(textStyle: textTheme.headline4),
      headline5: GoogleFonts.artifika(textStyle: textTheme.headline5),
      headline6: GoogleFonts.artifika(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.artifika(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.artifika(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.artifika(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.artifika(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.artifika(textStyle: textTheme.caption),
      button: GoogleFonts.artifika(textStyle: textTheme.button),
      overline: GoogleFonts.artifika(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arvo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arvo
  static TextStyle arvo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b816c4a4a7813e7daaa88e2f869b5c8acefbf8d52e00205c41d15dda95f1766c',
        22724,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5250cf6a9f89eba5cb07686924135f2bce7a6f8775a569fac7276b5c83b03db7',
        22704,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1126bb2afe7e919632493ca620fc94e998910794a9fd47d82092f6edc26f4368',
        22608,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '43a330e1b8afd2c95f4f6b1c9c67ef7dfab28ed90bfb6a4551efe8480a060222',
        23288,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arvo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arvo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arvo
  static TextTheme arvoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arvo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arvo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arvo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arvo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arvo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arvo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arvo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arvo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arvo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arvo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arvo(textStyle: textTheme.caption),
      button: GoogleFonts.arvo(textStyle: textTheme.button),
      overline: GoogleFonts.arvo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Arya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arya
  static TextStyle arya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98cf640f609db3f8940fc4bc1566dda034961cb11d23f71a277f3ab268c8859a',
        120116,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c168a53b559c7407d20692a42b94301046b15c4838d709b83992c32cab5732c',
        119776,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Arya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Arya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Arya
  static TextTheme aryaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.arya(textStyle: textTheme.headline1),
      headline2: GoogleFonts.arya(textStyle: textTheme.headline2),
      headline3: GoogleFonts.arya(textStyle: textTheme.headline3),
      headline4: GoogleFonts.arya(textStyle: textTheme.headline4),
      headline5: GoogleFonts.arya(textStyle: textTheme.headline5),
      headline6: GoogleFonts.arya(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.arya(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.arya(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.arya(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.arya(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.arya(textStyle: textTheme.caption),
      button: GoogleFonts.arya(textStyle: textTheme.button),
      overline: GoogleFonts.arya(textStyle: textTheme.overline),
    );
  }

  /// Applies the Asap font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap
  static TextStyle asap({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3424989c5e2512f04cbd78fd70665961847d7307eb5d795caadac8db451f74cc',
        67676,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6286c24191501089796508556c20c3086610ae6aeb56d9aadceaaa0b7d825c51',
        69828,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7034a58c9a896f74c127472a7085dbd1d6bfb6fd2cafb4140dfde291f0bc399',
        67936,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13483b794adc9a08424049bbf8e6a03b399069e87c0c4d01777ae17c3328de81',
        69828,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '835a74fedec5a1877e092c739d9f213a3e41860462c70437da2465b5f99ea073',
        67904,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ce966470982f0031860428bc4a47e41d80471ac70ccc857fac1e948d6c964eb7',
        69648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asap',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asap font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asap
  static TextTheme asapTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.asap(textStyle: textTheme.headline1),
      headline2: GoogleFonts.asap(textStyle: textTheme.headline2),
      headline3: GoogleFonts.asap(textStyle: textTheme.headline3),
      headline4: GoogleFonts.asap(textStyle: textTheme.headline4),
      headline5: GoogleFonts.asap(textStyle: textTheme.headline5),
      headline6: GoogleFonts.asap(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.asap(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.asap(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.asap(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.asap(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.asap(textStyle: textTheme.caption),
      button: GoogleFonts.asap(textStyle: textTheme.button),
      overline: GoogleFonts.asap(textStyle: textTheme.overline),
    );
  }

  /// Applies the Asar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asar
  static TextStyle asar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52cdc31a962e99a625bf96be5b06ab8118290c27e17701c4938182d9e56109af',
        410900,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asar
  static TextTheme asarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.asar(textStyle: textTheme.headline1),
      headline2: GoogleFonts.asar(textStyle: textTheme.headline2),
      headline3: GoogleFonts.asar(textStyle: textTheme.headline3),
      headline4: GoogleFonts.asar(textStyle: textTheme.headline4),
      headline5: GoogleFonts.asar(textStyle: textTheme.headline5),
      headline6: GoogleFonts.asar(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.asar(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.asar(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.asar(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.asar(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.asar(textStyle: textTheme.caption),
      button: GoogleFonts.asar(textStyle: textTheme.button),
      overline: GoogleFonts.asar(textStyle: textTheme.overline),
    );
  }

  /// Applies the Asset font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asset
  static TextStyle asset({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6423261d7b23d05ef705ee59a0151076feed8408f637b04693272b767ac6cfd5',
        52004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asset',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asset font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asset
  static TextTheme assetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.asset(textStyle: textTheme.headline1),
      headline2: GoogleFonts.asset(textStyle: textTheme.headline2),
      headline3: GoogleFonts.asset(textStyle: textTheme.headline3),
      headline4: GoogleFonts.asset(textStyle: textTheme.headline4),
      headline5: GoogleFonts.asset(textStyle: textTheme.headline5),
      headline6: GoogleFonts.asset(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.asset(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.asset(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.asset(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.asset(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.asset(textStyle: textTheme.caption),
      button: GoogleFonts.asset(textStyle: textTheme.button),
      overline: GoogleFonts.asset(textStyle: textTheme.overline),
    );
  }

  /// Applies the Assistant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Assistant
  static TextStyle assistant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f4c276bf1e4d52183015128074de4702a86fc31cce04f575a8ebef54a077c78',
        57240,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad7ba792736448061fddf24806abe616e89d7a21a00d169ac4bf95db35ffe9cc',
        57400,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ffb8d00a2bd6ab725bb34dc8eaf61737481f6b285988332e4f6a4b60279dbde',
        57088,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1dc8095e8dddae977007770ce433f8ed1e374d0a83d7330ecea3b335109a4985',
        56812,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81008b85f8a91125a8efe85a353982fe1b825def9ef33eed881b709a6debf250',
        56752,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7370c1c3e5649abcfa6f44475eed601eb070ab934a708081b87627827d5463a',
        56872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Assistant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Assistant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Assistant
  static TextTheme assistantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.assistant(textStyle: textTheme.headline1),
      headline2: GoogleFonts.assistant(textStyle: textTheme.headline2),
      headline3: GoogleFonts.assistant(textStyle: textTheme.headline3),
      headline4: GoogleFonts.assistant(textStyle: textTheme.headline4),
      headline5: GoogleFonts.assistant(textStyle: textTheme.headline5),
      headline6: GoogleFonts.assistant(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.assistant(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.assistant(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.assistant(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.assistant(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.assistant(textStyle: textTheme.caption),
      button: GoogleFonts.assistant(textStyle: textTheme.button),
      overline: GoogleFonts.assistant(textStyle: textTheme.overline),
    );
  }

  /// Applies the Astloch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Astloch
  static TextStyle astloch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b51d807f9b0f818e44f8f40d4fbedacfff7df981efda85e7b722d62f6022a168',
        49860,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b86a5f0e90945d44c5b629fde8c5a667dd7882ab201ccb397f96f482fd7e98bc',
        51544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Astloch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Astloch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Astloch
  static TextTheme astlochTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.astloch(textStyle: textTheme.headline1),
      headline2: GoogleFonts.astloch(textStyle: textTheme.headline2),
      headline3: GoogleFonts.astloch(textStyle: textTheme.headline3),
      headline4: GoogleFonts.astloch(textStyle: textTheme.headline4),
      headline5: GoogleFonts.astloch(textStyle: textTheme.headline5),
      headline6: GoogleFonts.astloch(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.astloch(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.astloch(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.astloch(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.astloch(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.astloch(textStyle: textTheme.caption),
      button: GoogleFonts.astloch(textStyle: textTheme.button),
      overline: GoogleFonts.astloch(textStyle: textTheme.overline),
    );
  }

  /// Applies the Asul font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asul
  static TextStyle asul({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd38e526c102508df44df01ded7aefa955a61c999e42e91cbcb82103aa1269875',
        33468,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1810c0e0a5199932d466db95d83fab54bd1b5f6fd5b91664ca7240078d2dd1f0',
        33500,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Asul',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Asul font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Asul
  static TextTheme asulTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.asul(textStyle: textTheme.headline1),
      headline2: GoogleFonts.asul(textStyle: textTheme.headline2),
      headline3: GoogleFonts.asul(textStyle: textTheme.headline3),
      headline4: GoogleFonts.asul(textStyle: textTheme.headline4),
      headline5: GoogleFonts.asul(textStyle: textTheme.headline5),
      headline6: GoogleFonts.asul(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.asul(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.asul(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.asul(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.asul(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.asul(textStyle: textTheme.caption),
      button: GoogleFonts.asul(textStyle: textTheme.button),
      overline: GoogleFonts.asul(textStyle: textTheme.overline),
    );
  }

  /// Applies the Athiti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Athiti
  static TextStyle athiti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4abe61baf7f8762b4dcb6b88b0610de73f42b112a793e28b92da163ee7e441d7',
        112524,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9c6df08ed329fa184304cf4bc64319e7812c62c2ae136dc89cb10a5d5c35018',
        111332,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4559ae55fe1020c88dc144ae60afba5e282fcd3aa1c5107292df173d42135806',
        112320,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e1f0a1706330d270d93ea13e88b35d9c6f4bf71d927e9468278c03b57986330',
        112508,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '398a37b4c34df12c6ede4a85f215d56eaa5a8b515ea5e0bdad2ef676c2ae858a',
        112080,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63b6ab040d22bd64ce5d5400f352fac3ecefa83827b1862b8a216d5c729ea286',
        112932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Athiti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Athiti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Athiti
  static TextTheme athitiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.athiti(textStyle: textTheme.headline1),
      headline2: GoogleFonts.athiti(textStyle: textTheme.headline2),
      headline3: GoogleFonts.athiti(textStyle: textTheme.headline3),
      headline4: GoogleFonts.athiti(textStyle: textTheme.headline4),
      headline5: GoogleFonts.athiti(textStyle: textTheme.headline5),
      headline6: GoogleFonts.athiti(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.athiti(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.athiti(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.athiti(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.athiti(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.athiti(textStyle: textTheme.caption),
      button: GoogleFonts.athiti(textStyle: textTheme.button),
      overline: GoogleFonts.athiti(textStyle: textTheme.overline),
    );
  }

  /// Applies the Atma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atma
  static TextStyle atma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd691cbd1df6f6a53328f8d9d9514102c915be55e93a8c1f0cb0826a27a60e4f2',
        196364,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '702ceed58c58203ab0c8ad4bbbbda56c77b89a29496d748322180acbed120201',
        198056,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc558572cee6afca8a8d34b8cb8a2397d749e0c22f9d9977f39eb0e84d636967',
        197528,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b569b84d6ee492ead3f4c73af6244137b0e4c604c9e98cc57627162221d498bb',
        196596,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '127f716e96fc47aee7624acf9cebd859693a19f2fc1f7d832f33835e5bd3b834',
        193184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Atma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atma
  static TextTheme atmaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.atma(textStyle: textTheme.headline1),
      headline2: GoogleFonts.atma(textStyle: textTheme.headline2),
      headline3: GoogleFonts.atma(textStyle: textTheme.headline3),
      headline4: GoogleFonts.atma(textStyle: textTheme.headline4),
      headline5: GoogleFonts.atma(textStyle: textTheme.headline5),
      headline6: GoogleFonts.atma(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.atma(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.atma(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.atma(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.atma(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.atma(textStyle: textTheme.caption),
      button: GoogleFonts.atma(textStyle: textTheme.button),
      overline: GoogleFonts.atma(textStyle: textTheme.overline),
    );
  }

  /// Applies the Atomic Age font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atomic+Age
  static TextStyle atomicAge({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fc59a494c6184d973d9d5db8ec698d8acb6283fc807bd1a13c30000b83b832c',
        44272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AtomicAge',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Atomic Age font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Atomic+Age
  static TextTheme atomicAgeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.atomicAge(textStyle: textTheme.headline1),
      headline2: GoogleFonts.atomicAge(textStyle: textTheme.headline2),
      headline3: GoogleFonts.atomicAge(textStyle: textTheme.headline3),
      headline4: GoogleFonts.atomicAge(textStyle: textTheme.headline4),
      headline5: GoogleFonts.atomicAge(textStyle: textTheme.headline5),
      headline6: GoogleFonts.atomicAge(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.atomicAge(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.atomicAge(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.atomicAge(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.atomicAge(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.atomicAge(textStyle: textTheme.caption),
      button: GoogleFonts.atomicAge(textStyle: textTheme.button),
      overline: GoogleFonts.atomicAge(textStyle: textTheme.overline),
    );
  }

  /// Applies the Aubrey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aubrey
  static TextStyle aubrey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1464a409557010421785a4857a333c92eb6c4a28c0dbeeb0b1f8441f5e68ab96',
        96976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Aubrey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Aubrey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Aubrey
  static TextTheme aubreyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.aubrey(textStyle: textTheme.headline1),
      headline2: GoogleFonts.aubrey(textStyle: textTheme.headline2),
      headline3: GoogleFonts.aubrey(textStyle: textTheme.headline3),
      headline4: GoogleFonts.aubrey(textStyle: textTheme.headline4),
      headline5: GoogleFonts.aubrey(textStyle: textTheme.headline5),
      headline6: GoogleFonts.aubrey(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.aubrey(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.aubrey(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.aubrey(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.aubrey(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.aubrey(textStyle: textTheme.caption),
      button: GoogleFonts.aubrey(textStyle: textTheme.button),
      overline: GoogleFonts.aubrey(textStyle: textTheme.overline),
    );
  }

  /// Applies the Audiowide font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Audiowide
  static TextStyle audiowide({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2054b5910bd5457176b1479122e09690d5afe73d3749e5ef89a3686e6f724c29',
        70472,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Audiowide',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Audiowide font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Audiowide
  static TextTheme audiowideTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.audiowide(textStyle: textTheme.headline1),
      headline2: GoogleFonts.audiowide(textStyle: textTheme.headline2),
      headline3: GoogleFonts.audiowide(textStyle: textTheme.headline3),
      headline4: GoogleFonts.audiowide(textStyle: textTheme.headline4),
      headline5: GoogleFonts.audiowide(textStyle: textTheme.headline5),
      headline6: GoogleFonts.audiowide(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.audiowide(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.audiowide(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.audiowide(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.audiowide(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.audiowide(textStyle: textTheme.caption),
      button: GoogleFonts.audiowide(textStyle: textTheme.button),
      overline: GoogleFonts.audiowide(textStyle: textTheme.overline),
    );
  }

  /// Applies the Autour One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Autour+One
  static TextStyle autourOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee63c9c20873c21ac935c1493e94bb24b9dc9782f63d01761b54dfedf4b3972c',
        59552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AutourOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Autour One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Autour+One
  static TextTheme autourOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.autourOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.autourOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.autourOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.autourOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.autourOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.autourOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.autourOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.autourOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.autourOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.autourOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.autourOne(textStyle: textTheme.caption),
      button: GoogleFonts.autourOne(textStyle: textTheme.button),
      overline: GoogleFonts.autourOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Average font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average
  static TextStyle average({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce0697844aa3a978d483dfa380fbebd5bff8e7e6dc0897bf6c2c009fb9ae4ab2',
        37788,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Average',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Average font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average
  static TextTheme averageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.average(textStyle: textTheme.headline1),
      headline2: GoogleFonts.average(textStyle: textTheme.headline2),
      headline3: GoogleFonts.average(textStyle: textTheme.headline3),
      headline4: GoogleFonts.average(textStyle: textTheme.headline4),
      headline5: GoogleFonts.average(textStyle: textTheme.headline5),
      headline6: GoogleFonts.average(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.average(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.average(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.average(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.average(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.average(textStyle: textTheme.caption),
      button: GoogleFonts.average(textStyle: textTheme.button),
      overline: GoogleFonts.average(textStyle: textTheme.overline),
    );
  }

  /// Applies the Average Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average+Sans
  static TextStyle averageSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'defa6f6e46057de37a3b075c74765ba7cd6a46e0ac756e83f454dfb8b1afa95c',
        43964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AverageSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Average Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Average+Sans
  static TextTheme averageSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.averageSans(textStyle: textTheme.headline1),
      headline2: GoogleFonts.averageSans(textStyle: textTheme.headline2),
      headline3: GoogleFonts.averageSans(textStyle: textTheme.headline3),
      headline4: GoogleFonts.averageSans(textStyle: textTheme.headline4),
      headline5: GoogleFonts.averageSans(textStyle: textTheme.headline5),
      headline6: GoogleFonts.averageSans(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.averageSans(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.averageSans(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.averageSans(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.averageSans(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.averageSans(textStyle: textTheme.caption),
      button: GoogleFonts.averageSans(textStyle: textTheme.button),
      overline: GoogleFonts.averageSans(textStyle: textTheme.overline),
    );
  }

  /// Applies the Averia Gruesa Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Gruesa+Libre
  static TextStyle averiaGruesaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c60fda1756722c9f8d80009e0627d49eb2106d9eada7962d132e3ebef09c96a',
        111344,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaGruesaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Gruesa Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Gruesa+Libre
  static TextTheme averiaGruesaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headline1),
      headline2: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headline2),
      headline3: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headline3),
      headline4: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headline4),
      headline5: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headline5),
      headline6: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.caption),
      button: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.button),
      overline: GoogleFonts.averiaGruesaLibre(textStyle: textTheme.overline),
    );
  }

  /// Applies the Averia Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Libre
  static TextStyle averiaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '446105043cce1cc90406cda4c387ef2100b294d9d63b3946d4a395d3f2a9ce07',
        108192,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c8a24e13d7d611dd8a4e15743ac34b163b1e96d1c9a9e82746f0bd9d3a878613',
        133544,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b819eb7a1c11f4de65f3bfe1a8f658ea56fc62b2b7a24b2cf8688e9ced04c96',
        108468,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '793d505e83fbdbef6ceeabd6897693fb515a4890b822623deb545b53e7ec68dd',
        128848,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b157a260e6fd6b7cdd2d54fc4f46e1a72fbb33034b74a6929cbc4d0a7d83e3d',
        112228,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '08c2c28ffffd04d884122fa538e0c615e52983959363269b543084794a60955f',
        135664,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Libre
  static TextTheme averiaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.averiaLibre(textStyle: textTheme.headline1),
      headline2: GoogleFonts.averiaLibre(textStyle: textTheme.headline2),
      headline3: GoogleFonts.averiaLibre(textStyle: textTheme.headline3),
      headline4: GoogleFonts.averiaLibre(textStyle: textTheme.headline4),
      headline5: GoogleFonts.averiaLibre(textStyle: textTheme.headline5),
      headline6: GoogleFonts.averiaLibre(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.averiaLibre(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.averiaLibre(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.averiaLibre(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.averiaLibre(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.averiaLibre(textStyle: textTheme.caption),
      button: GoogleFonts.averiaLibre(textStyle: textTheme.button),
      overline: GoogleFonts.averiaLibre(textStyle: textTheme.overline),
    );
  }

  /// Applies the Averia Sans Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Sans+Libre
  static TextStyle averiaSansLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '452436a08a43ba5da912a2ed71aa4e0c67ae680532317c5affb99278cedc4eb8',
        107752,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '056589edb0d0f068b768b9b9f6361bb5c4a2d53a33006288c9d089b1e6421f66',
        134200,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5f843350837023c845544f24fa59e8c71cbe7bc284c0ea4127aa872c4fcac41',
        108360,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a79e7e7aecba032e6272d99a93c69868328db8d34091d1c70ccfd4a839f70489',
        128896,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8af8ea3669721038ea729e975cadce19a0032e981378e23c8377e2faf979aca',
        113016,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0509fc7d0b873424deb4340ab1bafca704241ecfda08cdafeab623999d12bdfd',
        135852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaSansLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Sans Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Sans+Libre
  static TextTheme averiaSansLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.averiaSansLibre(textStyle: textTheme.headline1),
      headline2: GoogleFonts.averiaSansLibre(textStyle: textTheme.headline2),
      headline3: GoogleFonts.averiaSansLibre(textStyle: textTheme.headline3),
      headline4: GoogleFonts.averiaSansLibre(textStyle: textTheme.headline4),
      headline5: GoogleFonts.averiaSansLibre(textStyle: textTheme.headline5),
      headline6: GoogleFonts.averiaSansLibre(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.averiaSansLibre(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.averiaSansLibre(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.averiaSansLibre(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.averiaSansLibre(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.averiaSansLibre(textStyle: textTheme.caption),
      button: GoogleFonts.averiaSansLibre(textStyle: textTheme.button),
      overline: GoogleFonts.averiaSansLibre(textStyle: textTheme.overline),
    );
  }

  /// Applies the Averia Serif Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Serif+Libre
  static TextStyle averiaSerifLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '605722d0534e8b2a7a4ce36ebc7ecfa14868d5aeae52ba3419e14a19e67c92ba',
        109972,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b675f9e2f2962fb69b7145f35ea9df241cdc9b91744abeac3cdfbf7aca1740b',
        135976,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1939fc59e6192c78872b151f71d328c64c84552c1f8f7548f3278d3db023959f',
        109988,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '383c63d8878e96726e26c44d5a631030fcf28d4abdcb9bdadd86dbb01a623de9',
        130956,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19af7d57b5ea32ff5df3f2405e0d51759fdbab503fa4cfd420a5eb4943805fcc',
        113956,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '164c3a01088756eebd948641705d6759b2fc7dabfd77d6e36490aa39befa0028',
        138208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'AveriaSerifLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Averia Serif Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Averia+Serif+Libre
  static TextTheme averiaSerifLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.averiaSerifLibre(textStyle: textTheme.headline1),
      headline2: GoogleFonts.averiaSerifLibre(textStyle: textTheme.headline2),
      headline3: GoogleFonts.averiaSerifLibre(textStyle: textTheme.headline3),
      headline4: GoogleFonts.averiaSerifLibre(textStyle: textTheme.headline4),
      headline5: GoogleFonts.averiaSerifLibre(textStyle: textTheme.headline5),
      headline6: GoogleFonts.averiaSerifLibre(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.averiaSerifLibre(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.averiaSerifLibre(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.averiaSerifLibre(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.averiaSerifLibre(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.averiaSerifLibre(textStyle: textTheme.caption),
      button: GoogleFonts.averiaSerifLibre(textStyle: textTheme.button),
      overline: GoogleFonts.averiaSerifLibre(textStyle: textTheme.overline),
    );
  }

  /// Applies the B612 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612
  static TextStyle b612({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b11c6d50f8a4ef2abd6df134192e3770a9b392c814caf916bcf0efa87e6743d2',
        89048,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4250a2e42f4ceda476c771828532dfb8cb2e9170ceb541e8aecc34ecea7977b4',
        92732,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3f9b01c62cb7bf3bc87cbc07452bc98a3058af8a40db93b64528fb711a429ea',
        88700,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f930926cd0cbbde94c51659420d91fb464c93fa3109c6bdf553a706985e307e2',
        91740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'B612',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the B612 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612
  static TextTheme b612TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.b612(textStyle: textTheme.headline1),
      headline2: GoogleFonts.b612(textStyle: textTheme.headline2),
      headline3: GoogleFonts.b612(textStyle: textTheme.headline3),
      headline4: GoogleFonts.b612(textStyle: textTheme.headline4),
      headline5: GoogleFonts.b612(textStyle: textTheme.headline5),
      headline6: GoogleFonts.b612(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.b612(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.b612(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.b612(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.b612(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.b612(textStyle: textTheme.caption),
      button: GoogleFonts.b612(textStyle: textTheme.button),
      overline: GoogleFonts.b612(textStyle: textTheme.overline),
    );
  }

  /// Applies the B612 Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612+Mono
  static TextStyle b612Mono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ffa9cacfa6fcd1a7a413d3b87f6f5ac6e2b201649b64695d976e0af5a46d512',
        86196,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '55c1dcdfe00e2848cd4e1946617c601f62a0828e6ba3c73924b8b4f4e705785c',
        88684,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '515c42e5f2790fd973f2ee9685301efa0110bc2dfb33df69b57875318ad1e100',
        85172,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a4a6d28684fe7467e89b15c82070e98ed4c0623a5df5a9a05d347f757cda41e6',
        87488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'B612Mono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the B612 Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/B612+Mono
  static TextTheme b612MonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.b612Mono(textStyle: textTheme.headline1),
      headline2: GoogleFonts.b612Mono(textStyle: textTheme.headline2),
      headline3: GoogleFonts.b612Mono(textStyle: textTheme.headline3),
      headline4: GoogleFonts.b612Mono(textStyle: textTheme.headline4),
      headline5: GoogleFonts.b612Mono(textStyle: textTheme.headline5),
      headline6: GoogleFonts.b612Mono(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.b612Mono(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.b612Mono(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.b612Mono(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.b612Mono(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.b612Mono(textStyle: textTheme.caption),
      button: GoogleFonts.b612Mono(textStyle: textTheme.button),
      overline: GoogleFonts.b612Mono(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bad Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bad+Script
  static TextStyle badScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85388546eb146e3e3bf5803d4a47f053ad2a9491ee3470c23912777bfbfbc111',
        54372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BadScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bad Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bad+Script
  static TextTheme badScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.badScript(textStyle: textTheme.headline1),
      headline2: GoogleFonts.badScript(textStyle: textTheme.headline2),
      headline3: GoogleFonts.badScript(textStyle: textTheme.headline3),
      headline4: GoogleFonts.badScript(textStyle: textTheme.headline4),
      headline5: GoogleFonts.badScript(textStyle: textTheme.headline5),
      headline6: GoogleFonts.badScript(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.badScript(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.badScript(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.badScript(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.badScript(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.badScript(textStyle: textTheme.caption),
      button: GoogleFonts.badScript(textStyle: textTheme.button),
      overline: GoogleFonts.badScript(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bahiana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahiana
  static TextStyle bahiana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1134edff7d2708933a16883c07c5223938a3500e9880b289c754c2602b9181f7',
        51296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bahiana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bahiana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahiana
  static TextTheme bahianaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bahiana(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bahiana(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bahiana(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bahiana(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bahiana(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bahiana(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bahiana(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bahiana(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bahiana(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bahiana(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bahiana(textStyle: textTheme.caption),
      button: GoogleFonts.bahiana(textStyle: textTheme.button),
      overline: GoogleFonts.bahiana(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bahianita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahianita
  static TextStyle bahianita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8eae7d3828ad86d4af376a41fb9bd577433f7b9acf6f561f8c3383bf8f37224b',
        91540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bahianita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bahianita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bahianita
  static TextTheme bahianitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bahianita(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bahianita(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bahianita(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bahianita(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bahianita(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bahianita(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bahianita(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bahianita(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bahianita(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bahianita(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bahianita(textStyle: textTheme.caption),
      button: GoogleFonts.bahianita(textStyle: textTheme.button),
      overline: GoogleFonts.bahianita(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bai Jamjuree font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bai+Jamjuree
  static TextStyle baiJamjuree({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdb9acd5c9a309240a161cc16a0a5e3a1f3bf9258d1f2cf14fdfdf6f79d83c8e',
        78044,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fff587a7a746a3d84947c3982968551180877152f29ac4e6b58a5d060e741ee3',
        83600,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '253ea5a1c8d0d3dacbf5b9f0db496617c2af6b95a5e0680df9c9c62b989b1799',
        78384,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c31f0c72862a5db7605a1625ddf34cc3c20c1c8a756b7d8848bf7f57a2707e0c',
        83780,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1dad5e37560fcacf02277fc359aecaab78b734f4a4839c6cf910296b20101fa',
        78416,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8939d2176c550b12487aed8e2fbc3b25917494c1174787534ed05c61be397f2',
        83856,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f9c01d94ba412108985bed479c74ca19d6b1b8c6982ee1fc113a970d5d323ea',
        78428,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '01569d323f908485836ed8c94772695fc05a4b02812f4f29a62ec257f911b55b',
        83944,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a2ef2b81cbfb6b9a14a4bb8931a87a0887e676e237a098c40aa9e61d601dcbd2',
        78412,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7db95e5673e505c331643e67b6172b4465e72300e3642242b55e75a28d7f5883',
        83776,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e456eaafee629c1aa6ffda2fbc121b9b76b54ab7f4b6dcaac6a4a523263b2237',
        78104,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3445df11af52dc901fce718f3b68b4df5dc14a6c7b2ae6399dcf47c7fa7dd34b',
        83360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BaiJamjuree',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bai Jamjuree font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bai+Jamjuree
  static TextTheme baiJamjureeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.baiJamjuree(textStyle: textTheme.headline1),
      headline2: GoogleFonts.baiJamjuree(textStyle: textTheme.headline2),
      headline3: GoogleFonts.baiJamjuree(textStyle: textTheme.headline3),
      headline4: GoogleFonts.baiJamjuree(textStyle: textTheme.headline4),
      headline5: GoogleFonts.baiJamjuree(textStyle: textTheme.headline5),
      headline6: GoogleFonts.baiJamjuree(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.baiJamjuree(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.baiJamjuree(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.baiJamjuree(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.baiJamjuree(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.baiJamjuree(textStyle: textTheme.caption),
      button: GoogleFonts.baiJamjuree(textStyle: textTheme.button),
      overline: GoogleFonts.baiJamjuree(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo
  static TextStyle baloo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2466b115f1d612b5be7c3c51aa118d952041ad4c9ebc6b790d3659c11ae3681d',
        386736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baloo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo
  static TextTheme balooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.baloo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.baloo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.baloo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.baloo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.baloo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.baloo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.baloo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.baloo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.baloo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.baloo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.baloo(textStyle: textTheme.caption),
      button: GoogleFonts.baloo(textStyle: textTheme.button),
      overline: GoogleFonts.baloo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Bhai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai
  static TextStyle balooBhai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '678bfe33602fe168ee8732abcdc1ea3a454798cd99cb4f81f7e9d16581a7e2ed',
        277392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhai
  static TextTheme balooBhaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooBhai(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooBhai(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooBhai(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooBhai(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooBhai(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooBhai(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooBhai(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooBhai(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooBhai(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooBhai(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooBhai(textStyle: textTheme.caption),
      button: GoogleFonts.balooBhai(textStyle: textTheme.button),
      overline: GoogleFonts.balooBhai(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Bhaijaan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan
  static TextStyle balooBhaijaan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52b00fb70a18a89da089a7492d3d97836ec7bd211288d3ec4ad6a60914db3dd3',
        171132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaijaan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaijaan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaijaan
  static TextTheme balooBhaijaanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooBhaijaan(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooBhaijaan(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooBhaijaan(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooBhaijaan(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooBhaijaan(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooBhaijaan(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooBhaijaan(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooBhaijaan(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooBhaijaan(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooBhaijaan(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooBhaijaan(textStyle: textTheme.caption),
      button: GoogleFonts.balooBhaijaan(textStyle: textTheme.button),
      overline: GoogleFonts.balooBhaijaan(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Bhaina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina
  static TextStyle balooBhaina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86bbf2a9f2b3936c4b1907de7136a4ca0f71efacfe22b7a6fa1b8a8a81f86282',
        262212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooBhaina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Bhaina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Bhaina
  static TextTheme balooBhainaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooBhaina(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooBhaina(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooBhaina(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooBhaina(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooBhaina(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooBhaina(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooBhaina(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooBhaina(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooBhaina(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooBhaina(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooBhaina(textStyle: textTheme.caption),
      button: GoogleFonts.balooBhaina(textStyle: textTheme.button),
      overline: GoogleFonts.balooBhaina(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Chettan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan
  static TextStyle balooChettan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e430d6e47dbe9220996407624585cda368b6ce19a23c3f46844a06db3c0a679',
        217796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooChettan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Chettan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Chettan
  static TextTheme balooChettanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooChettan(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooChettan(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooChettan(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooChettan(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooChettan(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooChettan(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooChettan(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooChettan(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooChettan(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooChettan(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooChettan(textStyle: textTheme.caption),
      button: GoogleFonts.balooChettan(textStyle: textTheme.button),
      overline: GoogleFonts.balooChettan(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Da font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da
  static TextStyle balooDa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88a331b2ae3e4db09605af2b1076b22c3734e2ecfd1b4ef1f4ca57446672e6cf',
        288676,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooDa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Da font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Da
  static TextTheme balooDaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooDa(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooDa(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooDa(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooDa(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooDa(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooDa(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooDa(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooDa(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooDa(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooDa(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooDa(textStyle: textTheme.caption),
      button: GoogleFonts.balooDa(textStyle: textTheme.button),
      overline: GoogleFonts.balooDa(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Paaji font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji
  static TextStyle balooPaaji({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95ba9f62ad854dc07958f311af18c674ca943fa7450fa4f6640d18e8eccdfe3f',
        185064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooPaaji',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Paaji font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Paaji
  static TextTheme balooPaajiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooPaaji(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooPaaji(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooPaaji(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooPaaji(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooPaaji(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooPaaji(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooPaaji(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooPaaji(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooPaaji(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooPaaji(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooPaaji(textStyle: textTheme.caption),
      button: GoogleFonts.balooPaaji(textStyle: textTheme.button),
      overline: GoogleFonts.balooPaaji(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Tamma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma
  static TextStyle balooTamma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8005871563cf3cfadf580fba66361b46649b342e9e1765d65405765af6e92c4',
        389440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTamma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tamma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tamma
  static TextTheme balooTammaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooTamma(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooTamma(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooTamma(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooTamma(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooTamma(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooTamma(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooTamma(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooTamma(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooTamma(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooTamma(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooTamma(textStyle: textTheme.caption),
      button: GoogleFonts.balooTamma(textStyle: textTheme.button),
      overline: GoogleFonts.balooTamma(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Tammudu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu
  static TextStyle balooTammudu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7bc7db26ac47d3561769f8cb3dfb93afd2767965efbd2770a77f8ffb33c5a013',
        406812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooTammudu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Tammudu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Tammudu
  static TextTheme balooTammuduTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooTammudu(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooTammudu(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooTammudu(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooTammudu(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooTammudu(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooTammudu(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooTammudu(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooTammudu(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooTammudu(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooTammudu(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooTammudu(textStyle: textTheme.caption),
      button: GoogleFonts.balooTammudu(textStyle: textTheme.button),
      overline: GoogleFonts.balooTammudu(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baloo Thambi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi
  static TextStyle balooThambi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5eb4d30c776f864b83a43cfbbcf1d05dda4a119a042f5a735adb014fdb4707e3',
        200468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalooThambi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baloo Thambi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baloo+Thambi
  static TextTheme balooThambiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balooThambi(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balooThambi(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balooThambi(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balooThambi(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balooThambi(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balooThambi(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balooThambi(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balooThambi(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balooThambi(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balooThambi(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balooThambi(textStyle: textTheme.caption),
      button: GoogleFonts.balooThambi(textStyle: textTheme.button),
      overline: GoogleFonts.balooThambi(textStyle: textTheme.overline),
    );
  }

  /// Applies the Balsamiq Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balsamiq+Sans
  static TextStyle balsamiqSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e06cc657444119a9850424b46ff940639699d52e1c3031047cb7fc3691a6c33e',
        303084,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '029988fdbc0ec2b09771bb360c222d7c13d7247fd1c37c3e82858febc4f78349',
        283788,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de004fda1323e24a4c16a3f11bb31263cbef6c1ed531a72ff49866f47c488fa1',
        275832,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f7734baad3cbcee8aea5640e4c79b22fe23e57a1a619020095e4e4d2d723f98b',
        257140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BalsamiqSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Balsamiq Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balsamiq+Sans
  static TextTheme balsamiqSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balsamiqSans(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balsamiqSans(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balsamiqSans(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balsamiqSans(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balsamiqSans(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balsamiqSans(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balsamiqSans(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balsamiqSans(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balsamiqSans(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balsamiqSans(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balsamiqSans(textStyle: textTheme.caption),
      button: GoogleFonts.balsamiqSans(textStyle: textTheme.button),
      overline: GoogleFonts.balsamiqSans(textStyle: textTheme.overline),
    );
  }

  /// Applies the Balthazar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balthazar
  static TextStyle balthazar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f532266accd2179da995d74ed36fa8bf3095162e9404d68381594561a335b66',
        28176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Balthazar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Balthazar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Balthazar
  static TextTheme balthazarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.balthazar(textStyle: textTheme.headline1),
      headline2: GoogleFonts.balthazar(textStyle: textTheme.headline2),
      headline3: GoogleFonts.balthazar(textStyle: textTheme.headline3),
      headline4: GoogleFonts.balthazar(textStyle: textTheme.headline4),
      headline5: GoogleFonts.balthazar(textStyle: textTheme.headline5),
      headline6: GoogleFonts.balthazar(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.balthazar(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.balthazar(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.balthazar(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.balthazar(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.balthazar(textStyle: textTheme.caption),
      button: GoogleFonts.balthazar(textStyle: textTheme.button),
      overline: GoogleFonts.balthazar(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bangers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bangers
  static TextStyle bangers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42a6646ed15dc91b9430f7e69e6259203235b48fa12c9cc10b6b72afab348de0',
        75700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bangers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bangers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bangers
  static TextTheme bangersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bangers(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bangers(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bangers(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bangers(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bangers(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bangers(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bangers(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bangers(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bangers(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bangers(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bangers(textStyle: textTheme.caption),
      button: GoogleFonts.bangers(textStyle: textTheme.button),
      overline: GoogleFonts.bangers(textStyle: textTheme.overline),
    );
  }

  /// Applies the Barlow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow
  static TextStyle barlow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbc7c82fdee3fa8b92bb23c3b9a2e8030733dbbc7322cd0c547b7c1889e7ecc0',
        61884,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f69e0bff8f7ab1739bd00636f1efa74a5937c7d34ae95b4ce353b4baad0eae33',
        65692,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6759b2d507f1549918b6b4a394efcca8982958de5ac4134d359b7162e12701ba',
        62392,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f750383a2bd7ca69e5e24c2f3fcf974a67a9e98818703c12d9fd2600d62b49cf',
        66844,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f582c8c58e673f459c2daf36fb9e1d3522dd5a7c50e0b8ee02d5a95089fff221',
        64984,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5ccb6cff74b4b842a4da09f1543e6f2ab54f86a0e75b997b7ef375159d0f9bca',
        68556,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1e3cf893b74f13d898b529820f0e01dd59c5c3f6f69635604600893cc99c914',
        62316,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '512de0e21c7303a0b6718ff5cf57c376345786cc521ce3851053764f55398e53',
        66936,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ed898f9a3aa42d3615c69b731f57305ce7006e87e29042e8467203889f0ff3a',
        64904,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b84f9e4475585d31451021e3e9d27e8336f00eac47c6753193de4033f15ea30d',
        68204,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88497110ef5b50e3903b3c97ee671e01497a9a6d49f64218c9a70fd5042c3b49',
        62368,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53cad3b96c2a07c4af9d7111e1b6eaf07718e6510b0ccf65140b1ee7040da9b3',
        67272,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7513399e0a26a50c0f81fab7a114c8f40337b1d2edd0f28abed3f23ff5232c1',
        62356,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '274e649f86e4323b0b8553520d855c49523b84eb9269b8e0cf9f41d201e76068',
        65900,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6063124468c1350716105b1b52edec1c02bbbea85a0d675477016f425f457c9a',
        64856,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a4cbccba78e5ea3a5c9560b15ff91d04b88b7a8cadb3c81b64ceb9ebd5fc266f',
        68012,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb60a33ebebe512faae572e414c6865041ea47c278458a28cdcadc762958bd4b',
        61268,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cabd84f11a9c742e6116cea169752a0f8c03073eeb60dc0ab4532987bd853878',
        66736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barlow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow
  static TextTheme barlowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.barlow(textStyle: textTheme.headline1),
      headline2: GoogleFonts.barlow(textStyle: textTheme.headline2),
      headline3: GoogleFonts.barlow(textStyle: textTheme.headline3),
      headline4: GoogleFonts.barlow(textStyle: textTheme.headline4),
      headline5: GoogleFonts.barlow(textStyle: textTheme.headline5),
      headline6: GoogleFonts.barlow(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.barlow(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.barlow(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.barlow(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.barlow(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.barlow(textStyle: textTheme.caption),
      button: GoogleFonts.barlow(textStyle: textTheme.button),
      overline: GoogleFonts.barlow(textStyle: textTheme.overline),
    );
  }

  /// Applies the Barlow Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Condensed
  static TextStyle barlowCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6f3686935062113e7b09390ffc3c690c608aa440f3e30db068b64420664ec5d',
        60532,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ea5455d6f97ca5ea27d76f30e87b842dc23d6a9fdd9566ccffb6415a3a56bcb0',
        65992,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '410b2efcf0b449d214182287f404b669840f4cc0a3c2f04940cee2d94b6eed4e',
        60752,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bba549e676526ff4957a986006a9290f70d407fc1fd00d34135a1291ce6138d4',
        65952,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bcf33e336ef2238ede09a908f8b86c6cca1586df6b1fbe0d59e462e3149b8ba',
        60544,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '49c62182eb883aeeab13fa2dbfcde072f2aac31e8bf77a232696bebc3b14e856',
        65664,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e5dff25ad8b2553decdba77625dc57cdcba97555b53612a9c9bfa40f43f953c',
        60524,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '65d8e8aa8d380e24c33fe4d2da62c7f9ec3de8e3429671ef5ff32782d21d649a',
        65840,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8014ab571e1d04db59a24744420219343b4d1806c983ac73e808a9e96c638306',
        60404,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dc26bbeb004e7e2084d0662973c4742fa65fd15b7eda3cb74826a27d686f44b0',
        65284,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36127289f54d9e42dd6bba46b0f52ce7e1839e79ce1b4d8fc5b22a54ee7c30f3',
        63120,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '70e3edc6f039c1a69acb610d298d522d5b46330458810ec9647e08c87b476dbb',
        66768,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec8d231a02a1e88872bef49e1099c712e93f3a723722a3d3ddc0fe2bfbe40962',
        63072,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'edbf575a42819a83bc5539e63b01efa4299d750d2f679579ef7673c972e3211e',
        66532,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e17df55a2cb70a97d869d33d55b38a29d60d31ae75c0bcaf61aca5f1215702cd',
        62876,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '34b5cbd8a9497c32949bcad7e8bd3f63019f7d28e693401b3ac39a69b5cd778d',
        66084,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5db2f838d3b4d86fe437bcaef0fb569cf99cfda6377a230687348897a816eeb5',
        61360,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de353be0369b799b090de4e2e272ebe13c6fd496973ff92b9e391656334ad1f2',
        64724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BarlowCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Condensed
  static TextTheme barlowCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.barlowCondensed(textStyle: textTheme.headline1),
      headline2: GoogleFonts.barlowCondensed(textStyle: textTheme.headline2),
      headline3: GoogleFonts.barlowCondensed(textStyle: textTheme.headline3),
      headline4: GoogleFonts.barlowCondensed(textStyle: textTheme.headline4),
      headline5: GoogleFonts.barlowCondensed(textStyle: textTheme.headline5),
      headline6: GoogleFonts.barlowCondensed(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.barlowCondensed(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.barlowCondensed(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.barlowCondensed(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.barlowCondensed(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.barlowCondensed(textStyle: textTheme.caption),
      button: GoogleFonts.barlowCondensed(textStyle: textTheme.button),
      overline: GoogleFonts.barlowCondensed(textStyle: textTheme.overline),
    );
  }

  /// Applies the Barlow Semi Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Semi+Condensed
  static TextStyle barlowSemiCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '429d1fa72c7702c9b3dcb38d750756505166e563306daaf1b66cb753a68f9e2d',
        62376,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '39a411a6e0b959d02638199381cb91af60eb4da3e34ac231c61bea08043966e1',
        67272,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4d4a161e4199c955202ca92d228838efee2dfa3cf68a0cf388085e19395aa5f',
        62680,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '79508f19bd17b1cdbf0b5b6f486c964d65c4a893a7f8f739a63cb71d206bb157',
        67540,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b2c8175065ed2235c4db66650397fad918d8f97db3f1b3991125f2df604b76c',
        62680,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b1eca79a9e101dd60e1836afb98fee66886d6042c2870f88b7ec822a7b97877b',
        67388,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a9dca109aaa256a5afb98477989b87e0e102269f948949e5573b65b45779d4e',
        62588,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '97fff70c506e46d82a769311aa3efd01c86a10161c92dee921fb6c75da5ba39c',
        67012,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73e602f9d74684f25a9d352cc61a0cfefc4ab505dfecb50b843492b1b5a87c3e',
        62528,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f1b5d4427848534739c734c5af7bdae1967a666e5c68e04156f0c5a60c1a1c78',
        66868,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b98dce5b8a6c1c5c2804cd26be37b203c56aee083840f4bad5d1907c4bf0b295',
        65064,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82e1d9e57f5b1c3fba390bb1e428d9b26538ead3342f04c40e60ded6325cc06e',
        68404,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acfd284673d183fe78a563ebf695ce70f7800151495260debfa9532d93289a55',
        65208,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e07191b9549a6c8c553608c75269487bb83c555c9e2fd9c08cfe704a5416e750',
        68320,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b42194ff2e3637db2ee27a0720eed118d756d564014725a948bcdc8964d25901',
        65240,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '36f4cee581975816949c810a10be068d6131acdc211a99acb3a2ce6c9586174f',
        68236,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2305373351846fd5f75bfb35b24697021e9bd4ea4fac80bb25bfe62c9afcb604',
        63764,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '29476cff7567544f2a04e61c90254033e0eb160089bfae4dea9871e8f6fbe2f9',
        67124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BarlowSemiCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barlow Semi Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barlow+Semi+Condensed
  static TextTheme barlowSemiCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headline1),
      headline2:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headline2),
      headline3:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headline3),
      headline4:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headline4),
      headline5:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headline5),
      headline6:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.headline6),
      subtitle1:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.subtitle1),
      subtitle2:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.subtitle2),
      bodyText1:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.bodyText1),
      bodyText2:
          GoogleFonts.barlowSemiCondensed(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.barlowSemiCondensed(textStyle: textTheme.caption),
      button: GoogleFonts.barlowSemiCondensed(textStyle: textTheme.button),
      overline: GoogleFonts.barlowSemiCondensed(textStyle: textTheme.overline),
    );
  }

  /// Applies the Barriecito font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barriecito
  static TextStyle barriecito({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbd439bbca5ece3347c1497394d9cdfd488742cc10ccd2413cdba4e819f236bb',
        167636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barriecito',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barriecito font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barriecito
  static TextTheme barriecitoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.barriecito(textStyle: textTheme.headline1),
      headline2: GoogleFonts.barriecito(textStyle: textTheme.headline2),
      headline3: GoogleFonts.barriecito(textStyle: textTheme.headline3),
      headline4: GoogleFonts.barriecito(textStyle: textTheme.headline4),
      headline5: GoogleFonts.barriecito(textStyle: textTheme.headline5),
      headline6: GoogleFonts.barriecito(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.barriecito(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.barriecito(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.barriecito(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.barriecito(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.barriecito(textStyle: textTheme.caption),
      button: GoogleFonts.barriecito(textStyle: textTheme.button),
      overline: GoogleFonts.barriecito(textStyle: textTheme.overline),
    );
  }

  /// Applies the Barrio font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barrio
  static TextStyle barrio({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1745250902305ccc432fd4ac10b9b248159dddd57634c31c70b8b4f3e3983f1',
        146692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Barrio',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Barrio font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Barrio
  static TextTheme barrioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.barrio(textStyle: textTheme.headline1),
      headline2: GoogleFonts.barrio(textStyle: textTheme.headline2),
      headline3: GoogleFonts.barrio(textStyle: textTheme.headline3),
      headline4: GoogleFonts.barrio(textStyle: textTheme.headline4),
      headline5: GoogleFonts.barrio(textStyle: textTheme.headline5),
      headline6: GoogleFonts.barrio(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.barrio(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.barrio(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.barrio(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.barrio(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.barrio(textStyle: textTheme.caption),
      button: GoogleFonts.barrio(textStyle: textTheme.button),
      overline: GoogleFonts.barrio(textStyle: textTheme.overline),
    );
  }

  /// Applies the Basic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Basic
  static TextStyle basic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29cf0f576451b712f706b5f33a2e8e1b6e2be41ed145ebce30bcf8828ec37960',
        45400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Basic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Basic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Basic
  static TextTheme basicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.basic(textStyle: textTheme.headline1),
      headline2: GoogleFonts.basic(textStyle: textTheme.headline2),
      headline3: GoogleFonts.basic(textStyle: textTheme.headline3),
      headline4: GoogleFonts.basic(textStyle: textTheme.headline4),
      headline5: GoogleFonts.basic(textStyle: textTheme.headline5),
      headline6: GoogleFonts.basic(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.basic(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.basic(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.basic(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.basic(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.basic(textStyle: textTheme.caption),
      button: GoogleFonts.basic(textStyle: textTheme.button),
      overline: GoogleFonts.basic(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baskervville font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville
  static TextStyle baskervville({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f83292ed3ada742c822e6b55c57b05a68a0d27b136b872ed2cb3edaf2dd778c',
        46788,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fdcacb6cacae51af7ce0b4bc57b4400feedcf38a9e21898b144205607cd15185',
        48936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baskervville',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baskervville font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baskervville
  static TextTheme baskervvilleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.baskervville(textStyle: textTheme.headline1),
      headline2: GoogleFonts.baskervville(textStyle: textTheme.headline2),
      headline3: GoogleFonts.baskervville(textStyle: textTheme.headline3),
      headline4: GoogleFonts.baskervville(textStyle: textTheme.headline4),
      headline5: GoogleFonts.baskervville(textStyle: textTheme.headline5),
      headline6: GoogleFonts.baskervville(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.baskervville(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.baskervville(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.baskervville(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.baskervville(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.baskervville(textStyle: textTheme.caption),
      button: GoogleFonts.baskervville(textStyle: textTheme.button),
      overline: GoogleFonts.baskervville(textStyle: textTheme.overline),
    );
  }

  /// Applies the Baumans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baumans
  static TextStyle baumans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f9e8b94de7e96a118ae0165a927ffde8127bb9105f38bc5c39359622c7c40f4',
        38752,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Baumans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Baumans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Baumans
  static TextTheme baumansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.baumans(textStyle: textTheme.headline1),
      headline2: GoogleFonts.baumans(textStyle: textTheme.headline2),
      headline3: GoogleFonts.baumans(textStyle: textTheme.headline3),
      headline4: GoogleFonts.baumans(textStyle: textTheme.headline4),
      headline5: GoogleFonts.baumans(textStyle: textTheme.headline5),
      headline6: GoogleFonts.baumans(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.baumans(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.baumans(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.baumans(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.baumans(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.baumans(textStyle: textTheme.caption),
      button: GoogleFonts.baumans(textStyle: textTheme.button),
      overline: GoogleFonts.baumans(textStyle: textTheme.overline),
    );
  }

  /// Applies the Be Vietnam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam
  static TextStyle beVietnam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0cc0f5cd392e42154ccdcf1ffc6987159ee0807caf89c6ac0796a273c9c80cd4',
        43452,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '11b1d7f41abb8a24b4ba203416df07809dbaf7de51619a1d167ab9af0361b6b7',
        44588,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03d32b9f1d2ddaa56a41075b22ab477cbc078409bda7fe7f7e030491bf70988a',
        43992,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a46d7c089e1fe8c124bc2de7b2cdf8a7f23fc0e9724766f3029c5c528b88b2cf',
        45400,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79220c67d8f8488a5dc457833419e884bef66e01eae43ec9c9b7e2944c5d88f0',
        43896,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e2928c1924824c824cac4ddaa74885a1fb9f3723429fa145c579cde5e79eeba5',
        45368,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d504a978c86a628884d737bacc817b24a74963f8e36e6cab5e9b81b9977b1f4',
        43948,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a2af11a383bfb3ee1ef8731946b78f349dce66a9151e6724f9428a29af43faac',
        45316,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94efd29230ff40c08cd89d8ae44d0e847ad17d53088280868a4bfbe29bc9afe0',
        43864,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2e18bd0f37b3e15856f513a8bd6b5d019948460f502359bf06716759b5b07664',
        45424,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f6fdb78c7c80b7871c787918369b6f9908cb55d29a6f68602b90d557a0ef839',
        43720,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c54104de856f3762629b69585ceb0eed536f7f7a19d2a2e1cdb44c1b1398e6b8',
        45380,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '920f1f8cbfb2d9b94b66296e1f4ddf430a02ce638be482c79c598832645fda13',
        43640,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2140e6025b6df417db0a543e64c090a9a5aa119d7523fd43a5f806a1550bdb37',
        45296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BeVietnam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Be Vietnam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Be+Vietnam
  static TextTheme beVietnamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.beVietnam(textStyle: textTheme.headline1),
      headline2: GoogleFonts.beVietnam(textStyle: textTheme.headline2),
      headline3: GoogleFonts.beVietnam(textStyle: textTheme.headline3),
      headline4: GoogleFonts.beVietnam(textStyle: textTheme.headline4),
      headline5: GoogleFonts.beVietnam(textStyle: textTheme.headline5),
      headline6: GoogleFonts.beVietnam(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.beVietnam(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.beVietnam(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.beVietnam(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.beVietnam(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.beVietnam(textStyle: textTheme.caption),
      button: GoogleFonts.beVietnam(textStyle: textTheme.button),
      overline: GoogleFonts.beVietnam(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bebas Neue font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bebas+Neue
  static TextStyle bebasNeue({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd16210fc689a14930beb51e89f3890e3167bdb105c0e7618abb62d6c4a2cc5d',
        37392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BebasNeue',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bebas Neue font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bebas+Neue
  static TextTheme bebasNeueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bebasNeue(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bebasNeue(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bebasNeue(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bebasNeue(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bebasNeue(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bebasNeue(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bebasNeue(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bebasNeue(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bebasNeue(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bebasNeue(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bebasNeue(textStyle: textTheme.caption),
      button: GoogleFonts.bebasNeue(textStyle: textTheme.button),
      overline: GoogleFonts.bebasNeue(textStyle: textTheme.overline),
    );
  }

  /// Applies the Belgrano font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belgrano
  static TextStyle belgrano({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b66b889e699bfe12ea9cc04621e48eed308f79ef2955cd4f20d0e7ddbcbaeab',
        29028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belgrano',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belgrano font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belgrano
  static TextTheme belgranoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.belgrano(textStyle: textTheme.headline1),
      headline2: GoogleFonts.belgrano(textStyle: textTheme.headline2),
      headline3: GoogleFonts.belgrano(textStyle: textTheme.headline3),
      headline4: GoogleFonts.belgrano(textStyle: textTheme.headline4),
      headline5: GoogleFonts.belgrano(textStyle: textTheme.headline5),
      headline6: GoogleFonts.belgrano(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.belgrano(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.belgrano(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.belgrano(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.belgrano(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.belgrano(textStyle: textTheme.caption),
      button: GoogleFonts.belgrano(textStyle: textTheme.button),
      overline: GoogleFonts.belgrano(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bellefair font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellefair
  static TextStyle bellefair({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '581fd752c6fe9933425b7868917fe51b6d222b42336b931e58385cea219007a0',
        46492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bellefair',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellefair font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellefair
  static TextTheme bellefairTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bellefair(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bellefair(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bellefair(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bellefair(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bellefair(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bellefair(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bellefair(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bellefair(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bellefair(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bellefair(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bellefair(textStyle: textTheme.caption),
      button: GoogleFonts.bellefair(textStyle: textTheme.button),
      overline: GoogleFonts.bellefair(textStyle: textTheme.overline),
    );
  }

  /// Applies the Belleza font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belleza
  static TextStyle belleza({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '916c38d3ec21ba4e080cbb7c82b60f62b023224acf789357a9338460a610def2',
        27772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Belleza',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Belleza font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Belleza
  static TextTheme bellezaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.belleza(textStyle: textTheme.headline1),
      headline2: GoogleFonts.belleza(textStyle: textTheme.headline2),
      headline3: GoogleFonts.belleza(textStyle: textTheme.headline3),
      headline4: GoogleFonts.belleza(textStyle: textTheme.headline4),
      headline5: GoogleFonts.belleza(textStyle: textTheme.headline5),
      headline6: GoogleFonts.belleza(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.belleza(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.belleza(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.belleza(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.belleza(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.belleza(textStyle: textTheme.caption),
      button: GoogleFonts.belleza(textStyle: textTheme.button),
      overline: GoogleFonts.belleza(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bellota font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota
  static TextStyle bellota({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29b1164370f0eca544e3c2cb64f06324bd098c99c35f5ecdd5527d6642e5a78f',
        87324,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2876a1892bc886d0df661eef1cc4fd3273dc8bce9563d1a7fba2c72987e340c5',
        90184,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ae1ca7fd73a6c369b6bf3b7326788cb2a360b467fa83a298140dac4166b8efa',
        86996,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd628b046cfc942ee35db112226b78f9ac3973ccaf005074bbbe867656201b8ec',
        89836,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac23e7ab6ffb89ee1593424695c867b8150bd97cd85fdbe2a3d7f89bf32a0973',
        87220,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e876bb51e7fba1f8fadcef59f4b68e3020a0909557cef70a98c84253c9e32f2f',
        90052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bellota',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellota font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota
  static TextTheme bellotaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bellota(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bellota(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bellota(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bellota(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bellota(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bellota(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bellota(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bellota(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bellota(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bellota(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bellota(textStyle: textTheme.caption),
      button: GoogleFonts.bellota(textStyle: textTheme.button),
      overline: GoogleFonts.bellota(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bellota Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota+Text
  static TextStyle bellotaText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0643b4ed7b9e5fe0a6023e98e3c731ac5ed3dd6a93688e6d319415902455806',
        85396,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e0b3916debc6fdfc7a7fd3129785215a68039360ca58fff2137a5855ee962138',
        88396,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd71701b5f03e11645c6c76521346bb0658b950d8e568f92dbad4c0f832775eb',
        85276,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cab1408381b8c09a1322d14913d773a9ecd2af835363efced81df2db8aa5107b',
        88112,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c08136cdca5423cf6e4f79255b1d8968b3ce107c396b03445f6c49c286dd349',
        85352,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ec9c1edafbe6c75409ba2200628821ee1f0dbad581d6f79db100aeb366b12ee4',
        88192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BellotaText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bellota Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bellota+Text
  static TextTheme bellotaTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bellotaText(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bellotaText(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bellotaText(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bellotaText(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bellotaText(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bellotaText(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bellotaText(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bellotaText(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bellotaText(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bellotaText(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bellotaText(textStyle: textTheme.caption),
      button: GoogleFonts.bellotaText(textStyle: textTheme.button),
      overline: GoogleFonts.bellotaText(textStyle: textTheme.overline),
    );
  }

  /// Applies the BenchNine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BenchNine
  static TextStyle benchNine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '819e7479fd3310e52e9754666e7a85aae97b6ea92363f425c93d1763341c5720',
        38056,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ff13f62cc4e1011ea688bc0bdad0ec34826a3c14cbc1b9ec0ed2b768a756be1',
        38812,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad7761d772dd04c7cf6c3ea55ea6f5bc9ca1540a2961a12251b37aee5d067022',
        38748,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BenchNine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BenchNine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BenchNine
  static TextTheme benchNineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.benchNine(textStyle: textTheme.headline1),
      headline2: GoogleFonts.benchNine(textStyle: textTheme.headline2),
      headline3: GoogleFonts.benchNine(textStyle: textTheme.headline3),
      headline4: GoogleFonts.benchNine(textStyle: textTheme.headline4),
      headline5: GoogleFonts.benchNine(textStyle: textTheme.headline5),
      headline6: GoogleFonts.benchNine(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.benchNine(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.benchNine(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.benchNine(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.benchNine(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.benchNine(textStyle: textTheme.caption),
      button: GoogleFonts.benchNine(textStyle: textTheme.button),
      overline: GoogleFonts.benchNine(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bentham font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bentham
  static TextStyle bentham({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36b9c399aae73bd09e01d76e51e8697f80e9e34f14e954b929a08d6cfbc5f697',
        40176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bentham',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bentham font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bentham
  static TextTheme benthamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bentham(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bentham(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bentham(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bentham(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bentham(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bentham(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bentham(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bentham(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bentham(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bentham(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bentham(textStyle: textTheme.caption),
      button: GoogleFonts.bentham(textStyle: textTheme.button),
      overline: GoogleFonts.bentham(textStyle: textTheme.overline),
    );
  }

  /// Applies the Berkshire Swash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Berkshire+Swash
  static TextStyle berkshireSwash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e73eb938ce44215938a21b199bc0a7eba8e1805d0d2528c3300ad7a1813d5e0',
        57948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BerkshireSwash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Berkshire Swash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Berkshire+Swash
  static TextTheme berkshireSwashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.berkshireSwash(textStyle: textTheme.headline1),
      headline2: GoogleFonts.berkshireSwash(textStyle: textTheme.headline2),
      headline3: GoogleFonts.berkshireSwash(textStyle: textTheme.headline3),
      headline4: GoogleFonts.berkshireSwash(textStyle: textTheme.headline4),
      headline5: GoogleFonts.berkshireSwash(textStyle: textTheme.headline5),
      headline6: GoogleFonts.berkshireSwash(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.berkshireSwash(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.berkshireSwash(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.berkshireSwash(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.berkshireSwash(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.berkshireSwash(textStyle: textTheme.caption),
      button: GoogleFonts.berkshireSwash(textStyle: textTheme.button),
      overline: GoogleFonts.berkshireSwash(textStyle: textTheme.overline),
    );
  }

  /// Applies the Beth Ellen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beth+Ellen
  static TextStyle bethEllen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33f7d9b097ad741e56ef314b447fa4e0d310aab981ba6aea5db368053b65bc56',
        115600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BethEllen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Beth Ellen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Beth+Ellen
  static TextTheme bethEllenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bethEllen(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bethEllen(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bethEllen(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bethEllen(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bethEllen(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bethEllen(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bethEllen(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bethEllen(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bethEllen(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bethEllen(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bethEllen(textStyle: textTheme.caption),
      button: GoogleFonts.bethEllen(textStyle: textTheme.button),
      overline: GoogleFonts.bethEllen(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bevan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bevan
  static TextStyle bevan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95fb9ca931c31e79c8312fb66d76a2239472f842f9aeed9c261367a55723370f',
        55536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bevan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bevan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bevan
  static TextTheme bevanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bevan(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bevan(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bevan(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bevan(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bevan(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bevan(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bevan(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bevan(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bevan(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bevan(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bevan(textStyle: textTheme.caption),
      button: GoogleFonts.bevan(textStyle: textTheme.button),
      overline: GoogleFonts.bevan(textStyle: textTheme.overline),
    );
  }

  /// Applies the Big Shoulders Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Display
  static TextStyle bigShouldersDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '243bc59e9459b35c35fa0bc5cc49219e1cbf248be840664569ca730a8a7a7e5e',
        60384,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9d601dd24fc0f4bb73ca5a9bc3fb23c2d744597df0f10a2894d566903ba1154',
        64044,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d1c3a1a7aca284022f6d11318ac148fe815d11c400a02d20e25768bbcf17f16',
        63888,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '782f7156f414a376945013c065917553e525e9f55dc801588c0f2f47406a51a3',
        63824,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'abf50d14f1c83beca50dbf4875c46279d06f2120f997bd0b3670236cf24bf1aa',
        63924,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '908c135c2591d12f000c0af1d59e56e72fb77beb39c1ba091505f250575b4ea6',
        63876,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19b8e205eb51647a9245e28993f1aa99df1cdc107cab1e823db05dce048363ca',
        63916,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71c2e1ad1b8e3abbf78e31165b5b054095b45b80cdd32410b9df8abaa45a631f',
        65188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Display
  static TextTheme bigShouldersDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headline1),
      headline2:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headline2),
      headline3:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headline3),
      headline4:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headline4),
      headline5:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headline5),
      headline6:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.headline6),
      subtitle1:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.subtitle1),
      subtitle2:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.subtitle2),
      bodyText1:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.bodyText1),
      bodyText2:
          GoogleFonts.bigShouldersDisplay(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bigShouldersDisplay(textStyle: textTheme.caption),
      button: GoogleFonts.bigShouldersDisplay(textStyle: textTheme.button),
      overline: GoogleFonts.bigShouldersDisplay(textStyle: textTheme.overline),
    );
  }

  /// Applies the Big Shoulders Inline Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Display
  static TextStyle bigShouldersInlineDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cecd28ac71e6d26fe426d809a967ca89fd34ebf00666daf5e72be698043690f8',
        98144,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3710b6162121414170f4ee83003c9a801a07d3a8b78f6abbab39e670edc08a0b',
        99972,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45fd384c9df07fc26138ac660041a108fad83e7e900169cd69ff9e1ff683c79e',
        100792,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4485432c8a8581e0b3f3b507691b848e4673ba5d3606ccc8c51d573b9950d995',
        101060,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8429a118926e0997b6894777f001d3c63d792b7b82f9bbd3ee909b393e049c73',
        101340,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80e5e506aebe63f25614ef4b8b1a69935d750ff148abb1ed248d7c94b23cfb19',
        101752,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1b12519d38230d280f84445cb7e50edb127c715cdd6fb9e7697e29f7f77a0bf',
        102272,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d986bf2e9666f76e4a791c20a4aa9255ec6f92d62eac8c45365f456e9b64bc1',
        102192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersInlineDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Inline Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Display
  static TextTheme bigShouldersInlineDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.headline1),
      headline2:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.headline2),
      headline3:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.headline3),
      headline4:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.headline4),
      headline5:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.headline5),
      headline6:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.headline6),
      subtitle1:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.subtitle1),
      subtitle2:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.subtitle2),
      bodyText1:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.bodyText1),
      bodyText2:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.bodyText2),
      caption:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.caption),
      button:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.button),
      overline:
          GoogleFonts.bigShouldersInlineDisplay(textStyle: textTheme.overline),
    );
  }

  /// Applies the Big Shoulders Inline Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Text
  static TextStyle bigShouldersInlineText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '914a99a3f7a36509645da4d56298db3eaf53f8fe091adc6f511305a5b5415d94',
        98832,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4e1ca3362feca7026abcdc3f6cd27be00d437bdca4963451e70f627fc47285e',
        100608,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8171ef16c4d2ccf81271d6bb77a9a25723b54e3033e75e930b47738e9f8f738c',
        101584,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07dddac8ecdf608d7eecb9031c91626e78dc9e0721d6e3861ce58cd5b205d8a7',
        101584,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3e3a0152deb77bbf594da21360ad2cd1012e94424ef6fb664f876cbeec5ee45',
        101692,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0a7d5ffddfee40b18b44e3f89aac2801f82ed5cabcc11e6707b05525a55d3bb',
        102024,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26b8f325b1bcca1f6b88728184699789e3bf7ec260804d04421b5db694ae4157',
        102752,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0169fdfd36818b76f6f2182152276acbf8129be7a3e4d0ad77755b6d069acb71',
        102380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersInlineText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Inline Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Inline+Text
  static TextTheme bigShouldersInlineTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.headline1),
      headline2:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.headline2),
      headline3:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.headline3),
      headline4:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.headline4),
      headline5:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.headline5),
      headline6:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.headline6),
      subtitle1:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.subtitle1),
      subtitle2:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.subtitle2),
      bodyText1:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.bodyText1),
      bodyText2:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bigShouldersInlineText(textStyle: textTheme.caption),
      button: GoogleFonts.bigShouldersInlineText(textStyle: textTheme.button),
      overline:
          GoogleFonts.bigShouldersInlineText(textStyle: textTheme.overline),
    );
  }

  /// Applies the Big Shoulders Stencil Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Display
  static TextStyle bigShouldersStencilDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e745115111f02d5a11cdf1328f3eecff1bb5f775cb0f2b06b4d8f24b196ac32e',
        57612,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f312a4998a7fdb735ce3e5c2cebb4c88987d6b221039c3ec51117af72a7a92d',
        59556,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b8e0ce085bdd03707db89704d38ea6f6523ee0a6dc14dbe5e41ca65b3266958',
        59596,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d0ca21a6f86141b1d824eecc8a4b221e2f9b0a2d99c35b4b8da6132324a2431',
        59536,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c5b5b3228b0893035ab61f43b1666de4e2ac70346c6b5a0af6212dc881b2895',
        59488,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f18fa1842c04a9bb7b65cd8865d8db3ad6129de5aba757f7dac332de21e2e557',
        59548,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '999379e5037b63a0d57539a9aa7b10a200910a43531557a752265827a074c079',
        59848,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6055fdd83b00cf395678263ba7a8d07c043046f85db67776ca586dfd72ced1a5',
        59592,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersStencilDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Stencil Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Display
  static TextTheme bigShouldersStencilDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headline1),
      headline2: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headline2),
      headline3: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headline3),
      headline4: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headline4),
      headline5: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headline5),
      headline6: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bigShouldersStencilDisplay(
          textStyle: textTheme.bodyText2),
      caption:
          GoogleFonts.bigShouldersStencilDisplay(textStyle: textTheme.caption),
      button:
          GoogleFonts.bigShouldersStencilDisplay(textStyle: textTheme.button),
      overline:
          GoogleFonts.bigShouldersStencilDisplay(textStyle: textTheme.overline),
    );
  }

  /// Applies the Big Shoulders Stencil Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Text
  static TextStyle bigShouldersStencilText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce5239dead961193d7ed14ae8ad117d8ac7c38b3004ce5268f79858cb05dff20',
        58792,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b72cc9791d7c353499dd3cdd8cb057f1b737306474a92e64d32b94e60e63300a',
        60148,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c3218546f3f3c56203170cf14894c6b0f93024f0759022205174bd64fe18b52',
        60140,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b32127d757a06294d75c04041ebf65257d3b861075010b125b52b1872f0164a',
        60000,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f502e0a1bfb3a7c94c8bd1d80fce760f9dbc080b53d928803846e0705859c342',
        59900,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e82a1e08ebbaaabd1a452bd3461bc4174ec94b641c99774dd41a1d552de12a7',
        59980,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '814371b884bf588132731087f41533e3852bfa4953739fca42c71fcba588f073',
        59980,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b6e75385f85cfb30647c3935bf4ed6f0dfad6012a0a38bad71cf46c32d2d9ce',
        59508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersStencilText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Stencil Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Stencil+Text
  static TextTheme bigShouldersStencilTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.headline1),
      headline2:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.headline2),
      headline3:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.headline3),
      headline4:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.headline4),
      headline5:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.headline5),
      headline6:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.headline6),
      subtitle1:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.subtitle1),
      subtitle2:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.subtitle2),
      bodyText1:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.bodyText1),
      bodyText2:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.bodyText2),
      caption:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.caption),
      button: GoogleFonts.bigShouldersStencilText(textStyle: textTheme.button),
      overline:
          GoogleFonts.bigShouldersStencilText(textStyle: textTheme.overline),
    );
  }

  /// Applies the Big Shoulders Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Text
  static TextStyle bigShouldersText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '627d92b7b60e71b44920b0badb4fab35e76dc999346110b16b5503642b274d9c',
        60972,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8aef88ac2024c3940f399eee0642162cf1880de4b3072c385da26169385aaff9',
        64304,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b28c250237404079c092e1f0bbe96a9877935f854758b23d0c596474d2dc0a9',
        64348,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ceadafc7d9e2a44c734bb0219be7688bb6f03e1d0788f1a6fdaff25989c7c821',
        64240,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '891fff63a87492e0329b1ad1261d5d60e1e276099f63a26b28497f66fddb1e58',
        64288,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '089e74d0e80e3f820d20c2dadb61e35e88025df110b9bfdf6878dd0c88300f35',
        64144,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3090bbff39b913daac1ce49ed0afcd52cba93db2e114faba5840a983ff222f0',
        64208,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a6e0bec5c1e7d0a62882e4f6be1b781665211f69d499f61aa439ad6bb097e60',
        65320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigShouldersText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Big Shoulders Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Big+Shoulders+Text
  static TextTheme bigShouldersTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bigShouldersText(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bigShouldersText(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bigShouldersText(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bigShouldersText(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bigShouldersText(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bigShouldersText(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bigShouldersText(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bigShouldersText(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bigShouldersText(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bigShouldersText(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bigShouldersText(textStyle: textTheme.caption),
      button: GoogleFonts.bigShouldersText(textStyle: textTheme.button),
      overline: GoogleFonts.bigShouldersText(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bigelow Rules font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigelow+Rules
  static TextStyle bigelowRules({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b86229b1bc741bc11ef0517467d96769485504f74278c1011120697a17d74d26',
        59028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigelowRules',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bigelow Rules font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigelow+Rules
  static TextTheme bigelowRulesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bigelowRules(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bigelowRules(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bigelowRules(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bigelowRules(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bigelowRules(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bigelowRules(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bigelowRules(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bigelowRules(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bigelowRules(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bigelowRules(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bigelowRules(textStyle: textTheme.caption),
      button: GoogleFonts.bigelowRules(textStyle: textTheme.button),
      overline: GoogleFonts.bigelowRules(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bigshot One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigshot+One
  static TextStyle bigshotOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd6b11ed5794f665b3e412e676ae624b63b086b93992d6c0b00c9afd26180c79',
        36972,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BigshotOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bigshot One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bigshot+One
  static TextTheme bigshotOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bigshotOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bigshotOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bigshotOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bigshotOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bigshotOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bigshotOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bigshotOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bigshotOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bigshotOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bigshotOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bigshotOne(textStyle: textTheme.caption),
      button: GoogleFonts.bigshotOne(textStyle: textTheme.button),
      overline: GoogleFonts.bigshotOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bilbo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo
  static TextStyle bilbo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55d2e6fb7257d5ade5d2419927eebf1f0c78ba65154b64d0cb737b6c8fa6a7df',
        42864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bilbo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bilbo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo
  static TextTheme bilboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bilbo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bilbo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bilbo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bilbo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bilbo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bilbo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bilbo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bilbo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bilbo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bilbo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bilbo(textStyle: textTheme.caption),
      button: GoogleFonts.bilbo(textStyle: textTheme.button),
      overline: GoogleFonts.bilbo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bilbo Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo+Swash+Caps
  static TextStyle bilboSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e55126acc93a6cae98b3736d06e24e1301a26f9aa4ac2173998ab1fa142b1736',
        58124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BilboSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bilbo Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bilbo+Swash+Caps
  static TextTheme bilboSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bilboSwashCaps(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bilboSwashCaps(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bilboSwashCaps(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bilboSwashCaps(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bilboSwashCaps(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bilboSwashCaps(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bilboSwashCaps(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bilboSwashCaps(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bilboSwashCaps(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bilboSwashCaps(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bilboSwashCaps(textStyle: textTheme.caption),
      button: GoogleFonts.bilboSwashCaps(textStyle: textTheme.button),
      overline: GoogleFonts.bilboSwashCaps(textStyle: textTheme.overline),
    );
  }

  /// Applies the BioRhyme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme
  static TextStyle bioRhyme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c7047e02059b7ea10893cf7bcfe3dc06e450dd3fb6000e05171462fedc43f7e',
        69848,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9ee5307ca507a88bed949ef452d4b6c835e503ef09b30cbb1ace6d65030e873',
        72476,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfe90585ffc1c3fc0d661d75c86187e9b6176836b56026b7882465f43a328616',
        71764,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd56fec3e00f732e0ff393a16cd304a5b4818b7b5bc437e4f418142a976284e6',
        71756,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43c38cd7da3c0c61638db3dbfd450b28e4abcacc9a48011176274140cf681c2b',
        68792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BioRhyme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BioRhyme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme
  static TextTheme bioRhymeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bioRhyme(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bioRhyme(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bioRhyme(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bioRhyme(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bioRhyme(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bioRhyme(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bioRhyme(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bioRhyme(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bioRhyme(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bioRhyme(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bioRhyme(textStyle: textTheme.caption),
      button: GoogleFonts.bioRhyme(textStyle: textTheme.button),
      overline: GoogleFonts.bioRhyme(textStyle: textTheme.overline),
    );
  }

  /// Applies the BioRhyme Expanded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme+Expanded
  static TextStyle bioRhymeExpanded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7770459b3448470de7eebc842dd6d1b27857480f955caa6fda9114f30f9c487a',
        69024,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '564af9bc89e9baac8c99c4a2b2bb1262ed16deaec1971840ab3e348ed0dc8e22',
        72648,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1fa6003a77f1c41cfe89fc6db7c98358f0e6fa62b61c965e0e1a04ed960601b9',
        72028,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '89375361cdabf9dbf2e57378fa40cc8c19512e518617d5e8502c9db8aa4ee2a1',
        71960,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '586a8d74b8042767a173971c026734fb6cb75934497b3c9d2ebd80ad9e60c31d',
        71188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BioRhymeExpanded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the BioRhyme Expanded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/BioRhyme+Expanded
  static TextTheme bioRhymeExpandedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.caption),
      button: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.button),
      overline: GoogleFonts.bioRhymeExpanded(textStyle: textTheme.overline),
    );
  }

  /// Applies the Biryani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Biryani
  static TextStyle biryani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f65303a20787e99a61c757c6e4cbc9ee68af544a375dac932049def734163642',
        123500,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '842f2d86cd486de76ca080714383fb99a105dfb85b3bae4360d00e8ac8db8c9f',
        124924,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16e70205340aba8294e2da2cc8581ec3c5fb3f2af846d51a3de360f447d6f254',
        124200,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80169a7f1fadd79859c89b0e9a066fd8dbbc460f13a4e5df8389cd853dc67be9',
        124224,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8834894534eb39412acdbc906f20b8d4addd5339d6777eaf647ee1ecbd44538c',
        123988,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba9bcb5882f72d4ac114689fb32db356c2be660bc64a16c88ac2457bdbefd777',
        124032,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bad25e5e05861d1da7ddd858aefac18d200688fc997bf2760059fcc2c2ad30d',
        123080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Biryani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Biryani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Biryani
  static TextTheme biryaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.biryani(textStyle: textTheme.headline1),
      headline2: GoogleFonts.biryani(textStyle: textTheme.headline2),
      headline3: GoogleFonts.biryani(textStyle: textTheme.headline3),
      headline4: GoogleFonts.biryani(textStyle: textTheme.headline4),
      headline5: GoogleFonts.biryani(textStyle: textTheme.headline5),
      headline6: GoogleFonts.biryani(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.biryani(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.biryani(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.biryani(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.biryani(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.biryani(textStyle: textTheme.caption),
      button: GoogleFonts.biryani(textStyle: textTheme.button),
      overline: GoogleFonts.biryani(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bitter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bitter
  static TextStyle bitter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '937e0cb8bbc92b1b89eafc86f73c06dec677f4e8d2c39de72208ae4fffedc7fa',
        24208,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7a9ae7d2a6428de7df36662a7014e91b880c5d09663ae9c66abb8a928c0ad371',
        39064,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c41cd10ef080e4d415bc6da6d86b29b73fe87ba84afe455423476109ed6addbd',
        25616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bitter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bitter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bitter
  static TextTheme bitterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bitter(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bitter(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bitter(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bitter(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bitter(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bitter(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bitter(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bitter(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bitter(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bitter(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bitter(textStyle: textTheme.caption),
      button: GoogleFonts.bitter(textStyle: textTheme.button),
      overline: GoogleFonts.bitter(textStyle: textTheme.overline),
    );
  }

  /// Applies the Black And White Picture font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+And+White+Picture
  static TextStyle blackAndWhitePicture({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c951e047e8f1e152232363c35791b975f78ae96c97bfa6f14634c7a2551970c',
        9586680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackAndWhitePicture',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black And White Picture font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+And+White+Picture
  static TextTheme blackAndWhitePictureTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headline1),
      headline2:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headline2),
      headline3:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headline3),
      headline4:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headline4),
      headline5:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headline5),
      headline6:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.headline6),
      subtitle1:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.subtitle1),
      subtitle2:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.subtitle2),
      bodyText1:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.bodyText1),
      bodyText2:
          GoogleFonts.blackAndWhitePicture(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.blackAndWhitePicture(textStyle: textTheme.caption),
      button: GoogleFonts.blackAndWhitePicture(textStyle: textTheme.button),
      overline: GoogleFonts.blackAndWhitePicture(textStyle: textTheme.overline),
    );
  }

  /// Applies the Black Han Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Han+Sans
  static TextStyle blackHanSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea3e07623642e89ce9ae84a698b9557dd6361db9bc40b993b7715531404db088',
        382952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackHanSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black Han Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Han+Sans
  static TextTheme blackHanSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.blackHanSans(textStyle: textTheme.headline1),
      headline2: GoogleFonts.blackHanSans(textStyle: textTheme.headline2),
      headline3: GoogleFonts.blackHanSans(textStyle: textTheme.headline3),
      headline4: GoogleFonts.blackHanSans(textStyle: textTheme.headline4),
      headline5: GoogleFonts.blackHanSans(textStyle: textTheme.headline5),
      headline6: GoogleFonts.blackHanSans(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.blackHanSans(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.blackHanSans(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.blackHanSans(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.blackHanSans(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.blackHanSans(textStyle: textTheme.caption),
      button: GoogleFonts.blackHanSans(textStyle: textTheme.button),
      overline: GoogleFonts.blackHanSans(textStyle: textTheme.overline),
    );
  }

  /// Applies the Black Ops One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Ops+One
  static TextStyle blackOpsOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a9eebffdb4d3c168c63bfcd5d0ec80a1571160a66e46ef698786f9c56922256',
        41404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BlackOpsOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Black Ops One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Black+Ops+One
  static TextTheme blackOpsOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.blackOpsOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.blackOpsOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.blackOpsOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.blackOpsOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.blackOpsOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.blackOpsOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.blackOpsOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.blackOpsOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.blackOpsOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.blackOpsOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.blackOpsOne(textStyle: textTheme.caption),
      button: GoogleFonts.blackOpsOne(textStyle: textTheme.button),
      overline: GoogleFonts.blackOpsOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Blinker font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blinker
  static TextStyle blinker({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c240948a3fc8d5d8689c3a63f7f8ebc6306f7c85e807823569843f0f54195f9',
        47168,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a79a8324609cc2b3bcdaec6541902337b886042ed55c471dbb6f257c65b280f',
        48596,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3dd96a764325a06a02dcd84be7a03f3a2f2b6808e40d63328015690bf81f6c96',
        48440,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51b0da89566f911a7458b35be7b50dd97cb0ac23dff1eeb067b4d64a79911f3c',
        47676,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a51856bff19a13b746d4d2d4b3ebb07157b40df14a94c526837c9e5586337f01',
        53416,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6eba9015f99f6f510f713d65f3f324ba543c2e9d3bc5eac9cbdd446b738eda1f',
        48892,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd898f7f6b1fb3ed914d6dfaa20bc29b0f94d293822df46b2a78b5759f2637549',
        53068,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d02003dcc4ca64b3de96560fffcdd9e05125270589caabebc0da78d05d0f61e',
        52352,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Blinker',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Blinker font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Blinker
  static TextTheme blinkerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.blinker(textStyle: textTheme.headline1),
      headline2: GoogleFonts.blinker(textStyle: textTheme.headline2),
      headline3: GoogleFonts.blinker(textStyle: textTheme.headline3),
      headline4: GoogleFonts.blinker(textStyle: textTheme.headline4),
      headline5: GoogleFonts.blinker(textStyle: textTheme.headline5),
      headline6: GoogleFonts.blinker(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.blinker(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.blinker(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.blinker(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.blinker(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.blinker(textStyle: textTheme.caption),
      button: GoogleFonts.blinker(textStyle: textTheme.button),
      overline: GoogleFonts.blinker(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bonbon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonbon
  static TextStyle bonbon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7c2ebdfc96584f15448c9196a29a7983cad1097756e748e6d3d89db0cab6796',
        38740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bonbon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bonbon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bonbon
  static TextTheme bonbonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bonbon(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bonbon(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bonbon(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bonbon(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bonbon(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bonbon(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bonbon(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bonbon(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bonbon(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bonbon(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bonbon(textStyle: textTheme.caption),
      button: GoogleFonts.bonbon(textStyle: textTheme.button),
      overline: GoogleFonts.bonbon(textStyle: textTheme.overline),
    );
  }

  /// Applies the Boogaloo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Boogaloo
  static TextStyle boogaloo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ecd8d89eafeb4669ce51f02cef4e529aa97180ed7c2a9cfcbad4714ed9ede46f',
        33880,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Boogaloo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Boogaloo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Boogaloo
  static TextTheme boogalooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.boogaloo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.boogaloo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.boogaloo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.boogaloo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.boogaloo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.boogaloo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.boogaloo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.boogaloo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.boogaloo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.boogaloo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.boogaloo(textStyle: textTheme.caption),
      button: GoogleFonts.boogaloo(textStyle: textTheme.button),
      overline: GoogleFonts.boogaloo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bowlby One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One
  static TextStyle bowlbyOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d04430262e4d8e8e549ffcc4c97a27cb31ad26f9d2d85b2ba224381697b1a8d',
        61596,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BowlbyOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bowlby One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One
  static TextTheme bowlbyOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bowlbyOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bowlbyOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bowlbyOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bowlbyOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bowlbyOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bowlbyOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bowlbyOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bowlbyOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bowlbyOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bowlbyOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bowlbyOne(textStyle: textTheme.caption),
      button: GoogleFonts.bowlbyOne(textStyle: textTheme.button),
      overline: GoogleFonts.bowlbyOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bowlby One SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One+SC
  static TextStyle bowlbyOneSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2826dfb2cc015f4d1a83c121524eff701bea716ad41719d21b0baaf0462abae',
        45072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BowlbyOneSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bowlby One SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bowlby+One+SC
  static TextTheme bowlbyOneScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bowlbyOneSc(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bowlbyOneSc(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bowlbyOneSc(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bowlbyOneSc(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bowlbyOneSc(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bowlbyOneSc(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bowlbyOneSc(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bowlbyOneSc(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bowlbyOneSc(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bowlbyOneSc(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bowlbyOneSc(textStyle: textTheme.caption),
      button: GoogleFonts.bowlbyOneSc(textStyle: textTheme.button),
      overline: GoogleFonts.bowlbyOneSc(textStyle: textTheme.overline),
    );
  }

  /// Applies the Brawler font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brawler
  static TextStyle brawler({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58683ec3f93abe0d96615faa1fc7fce9f3297205572a4c8c6265d0be27219279',
        64320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Brawler',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Brawler font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Brawler
  static TextTheme brawlerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.brawler(textStyle: textTheme.headline1),
      headline2: GoogleFonts.brawler(textStyle: textTheme.headline2),
      headline3: GoogleFonts.brawler(textStyle: textTheme.headline3),
      headline4: GoogleFonts.brawler(textStyle: textTheme.headline4),
      headline5: GoogleFonts.brawler(textStyle: textTheme.headline5),
      headline6: GoogleFonts.brawler(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.brawler(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.brawler(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.brawler(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.brawler(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.brawler(textStyle: textTheme.caption),
      button: GoogleFonts.brawler(textStyle: textTheme.button),
      overline: GoogleFonts.brawler(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bree Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bree+Serif
  static TextStyle breeSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a7248ed16d47821a8836aa345a8297f6c44d86162fdbc6475497bc799db0e9f',
        46612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BreeSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bree Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bree+Serif
  static TextTheme breeSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.breeSerif(textStyle: textTheme.headline1),
      headline2: GoogleFonts.breeSerif(textStyle: textTheme.headline2),
      headline3: GoogleFonts.breeSerif(textStyle: textTheme.headline3),
      headline4: GoogleFonts.breeSerif(textStyle: textTheme.headline4),
      headline5: GoogleFonts.breeSerif(textStyle: textTheme.headline5),
      headline6: GoogleFonts.breeSerif(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.breeSerif(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.breeSerif(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.breeSerif(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.breeSerif(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.breeSerif(textStyle: textTheme.caption),
      button: GoogleFonts.breeSerif(textStyle: textTheme.button),
      overline: GoogleFonts.breeSerif(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bubblegum Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubblegum+Sans
  static TextStyle bubblegumSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53e2f591d5b22787b4fd506e06145d2652da6014e1707f782a92395533188726',
        38772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BubblegumSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bubblegum Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubblegum+Sans
  static TextTheme bubblegumSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bubblegumSans(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bubblegumSans(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bubblegumSans(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bubblegumSans(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bubblegumSans(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bubblegumSans(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bubblegumSans(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bubblegumSans(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bubblegumSans(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bubblegumSans(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bubblegumSans(textStyle: textTheme.caption),
      button: GoogleFonts.bubblegumSans(textStyle: textTheme.button),
      overline: GoogleFonts.bubblegumSans(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bubbler One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubbler+One
  static TextStyle bubblerOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd7ed8791a88cc19effc14df166be456cef77a85b707501822da21df19386254',
        30944,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BubblerOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bubbler One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bubbler+One
  static TextTheme bubblerOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bubblerOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bubblerOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bubblerOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bubblerOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bubblerOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bubblerOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bubblerOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bubblerOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bubblerOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bubblerOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bubblerOne(textStyle: textTheme.caption),
      button: GoogleFonts.bubblerOne(textStyle: textTheme.button),
      overline: GoogleFonts.bubblerOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Buda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buda
  static TextStyle buda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '385d4247a0218281950ea513488d597434ce1d22bafe1b9e0b0853fce9304338',
        90392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Buda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Buda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buda
  static TextTheme budaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.buda(textStyle: textTheme.headline1),
      headline2: GoogleFonts.buda(textStyle: textTheme.headline2),
      headline3: GoogleFonts.buda(textStyle: textTheme.headline3),
      headline4: GoogleFonts.buda(textStyle: textTheme.headline4),
      headline5: GoogleFonts.buda(textStyle: textTheme.headline5),
      headline6: GoogleFonts.buda(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.buda(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.buda(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.buda(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.buda(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.buda(textStyle: textTheme.caption),
      button: GoogleFonts.buda(textStyle: textTheme.button),
      overline: GoogleFonts.buda(textStyle: textTheme.overline),
    );
  }

  /// Applies the Buenard font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buenard
  static TextStyle buenard({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98e52931f613305f11ff078f1cb569682195e516554178bf3c4127f644df907a',
        59764,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b680cec9af406d125f721b89472951a526fcf17393adea7449be902ffb7f5cd',
        58608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Buenard',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Buenard font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Buenard
  static TextTheme buenardTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.buenard(textStyle: textTheme.headline1),
      headline2: GoogleFonts.buenard(textStyle: textTheme.headline2),
      headline3: GoogleFonts.buenard(textStyle: textTheme.headline3),
      headline4: GoogleFonts.buenard(textStyle: textTheme.headline4),
      headline5: GoogleFonts.buenard(textStyle: textTheme.headline5),
      headline6: GoogleFonts.buenard(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.buenard(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.buenard(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.buenard(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.buenard(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.buenard(textStyle: textTheme.caption),
      button: GoogleFonts.buenard(textStyle: textTheme.button),
      overline: GoogleFonts.buenard(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bungee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee
  static TextStyle bungee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee34fb3fe185999f9942b2b39a37688866c1a4e25eab17c7a67765e7f47f6dbe',
        110116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Bungee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee
  static TextTheme bungeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bungee(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bungee(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bungee(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bungee(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bungee(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bungee(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bungee(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bungee(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bungee(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bungee(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bungee(textStyle: textTheme.caption),
      button: GoogleFonts.bungee(textStyle: textTheme.button),
      overline: GoogleFonts.bungee(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bungee Hairline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Hairline
  static TextStyle bungeeHairline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7082ad6f58a7ae0bdd49f1c56b50fdd5f19c8e5a7a760de15f353ff47bf2c391',
        97300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeHairline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Hairline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Hairline
  static TextTheme bungeeHairlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bungeeHairline(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bungeeHairline(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bungeeHairline(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bungeeHairline(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bungeeHairline(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bungeeHairline(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bungeeHairline(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bungeeHairline(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bungeeHairline(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bungeeHairline(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bungeeHairline(textStyle: textTheme.caption),
      button: GoogleFonts.bungeeHairline(textStyle: textTheme.button),
      overline: GoogleFonts.bungeeHairline(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bungee Inline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Inline
  static TextStyle bungeeInline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c34108c66136e4485dbe7f75f62e6d782066911952901a3b1657b8d37d5bf414',
        147660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeInline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Inline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Inline
  static TextTheme bungeeInlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bungeeInline(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bungeeInline(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bungeeInline(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bungeeInline(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bungeeInline(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bungeeInline(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bungeeInline(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bungeeInline(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bungeeInline(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bungeeInline(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bungeeInline(textStyle: textTheme.caption),
      button: GoogleFonts.bungeeInline(textStyle: textTheme.button),
      overline: GoogleFonts.bungeeInline(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bungee Outline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Outline
  static TextStyle bungeeOutline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53bb5dbad57c06403c9f7c9503b0397f17f001d2a0881305c5bee9de3c610f78',
        200136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeOutline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Outline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Outline
  static TextTheme bungeeOutlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bungeeOutline(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bungeeOutline(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bungeeOutline(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bungeeOutline(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bungeeOutline(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bungeeOutline(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bungeeOutline(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bungeeOutline(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bungeeOutline(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bungeeOutline(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bungeeOutline(textStyle: textTheme.caption),
      button: GoogleFonts.bungeeOutline(textStyle: textTheme.button),
      overline: GoogleFonts.bungeeOutline(textStyle: textTheme.overline),
    );
  }

  /// Applies the Bungee Shade font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Shade
  static TextStyle bungeeShade({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd736a1fd1e9468b036a7df272341d90fa2864fa1a985cfef42c164898cadd99',
        330628,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'BungeeShade',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Bungee Shade font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Bungee+Shade
  static TextTheme bungeeShadeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.bungeeShade(textStyle: textTheme.headline1),
      headline2: GoogleFonts.bungeeShade(textStyle: textTheme.headline2),
      headline3: GoogleFonts.bungeeShade(textStyle: textTheme.headline3),
      headline4: GoogleFonts.bungeeShade(textStyle: textTheme.headline4),
      headline5: GoogleFonts.bungeeShade(textStyle: textTheme.headline5),
      headline6: GoogleFonts.bungeeShade(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.bungeeShade(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.bungeeShade(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.bungeeShade(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.bungeeShade(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.bungeeShade(textStyle: textTheme.caption),
      button: GoogleFonts.bungeeShade(textStyle: textTheme.button),
      overline: GoogleFonts.bungeeShade(textStyle: textTheme.overline),
    );
  }

  /// Applies the Butcherman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butcherman
  static TextStyle butcherman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bcf1ab19e7b312ef6a3f23116fef277d7af2240e6ee5719e5a8688f36f00e23',
        66300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Butcherman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Butcherman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butcherman
  static TextTheme butchermanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.butcherman(textStyle: textTheme.headline1),
      headline2: GoogleFonts.butcherman(textStyle: textTheme.headline2),
      headline3: GoogleFonts.butcherman(textStyle: textTheme.headline3),
      headline4: GoogleFonts.butcherman(textStyle: textTheme.headline4),
      headline5: GoogleFonts.butcherman(textStyle: textTheme.headline5),
      headline6: GoogleFonts.butcherman(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.butcherman(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.butcherman(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.butcherman(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.butcherman(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.butcherman(textStyle: textTheme.caption),
      button: GoogleFonts.butcherman(textStyle: textTheme.button),
      overline: GoogleFonts.butcherman(textStyle: textTheme.overline),
    );
  }

  /// Applies the Butterfly Kids font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butterfly+Kids
  static TextStyle butterflyKids({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e78c92335db0b2820b46df2d4a84c41e8690af1bac099b4a552e36736643b61',
        202408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ButterflyKids',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Butterfly Kids font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Butterfly+Kids
  static TextTheme butterflyKidsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.butterflyKids(textStyle: textTheme.headline1),
      headline2: GoogleFonts.butterflyKids(textStyle: textTheme.headline2),
      headline3: GoogleFonts.butterflyKids(textStyle: textTheme.headline3),
      headline4: GoogleFonts.butterflyKids(textStyle: textTheme.headline4),
      headline5: GoogleFonts.butterflyKids(textStyle: textTheme.headline5),
      headline6: GoogleFonts.butterflyKids(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.butterflyKids(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.butterflyKids(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.butterflyKids(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.butterflyKids(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.butterflyKids(textStyle: textTheme.caption),
      button: GoogleFonts.butterflyKids(textStyle: textTheme.button),
      overline: GoogleFonts.butterflyKids(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cabin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin
  static TextStyle cabin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ff30e9e9a66cf6a4e65d444d6bf8afdea7d574b27589397657972c2f9b2194f',
        81084,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'db35751de9b88dfbea004784c70c96bca9d813b5521cf320e5cb30adfd7384a2',
        80436,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4851465297f9c9aa19d41a969b28272f070f43271c7f279eb6daf3f291a47609',
        81516,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2f1dff32a90462507aca783f85d6b2ed780858dd81a2a13bf217afbbfe5cce77',
        81408,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7e9674a2fca64e9eddd32df2987e72643c1fbadb5cc8158e4a429f8a99ea39a',
        81656,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'da97f68bcdcff651e97b599499a784fc828a6e26feb94f391324076d060e3f7f',
        81548,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9adb3df669ae368a467dbe74951a83ec476b74739063459b95b664e6ea2bf36a',
        78196,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e4a3605f6b618e79e1d2bc2e4890babb2828cca85fee80608cb7d4a810b06eab',
        80320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cabin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin
  static TextTheme cabinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cabin(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cabin(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cabin(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cabin(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cabin(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cabin(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cabin(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cabin(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cabin(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cabin(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cabin(textStyle: textTheme.caption),
      button: GoogleFonts.cabin(textStyle: textTheme.button),
      overline: GoogleFonts.cabin(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cabin Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Condensed
  static TextStyle cabinCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8864cf658e1904654fb267649af1a35b07c0f9e7b2df523910efcfa047857270',
        75132,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19d7c8b72085fd1898042b6adfa002bee67aa85565ea042e3383c6d9718262f3',
        74864,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '204e4e214a76e3cc970598f75636fbe098a6541146bb02dd3d1ec67c8e155e5b',
        74872,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b3d243ed807d45b1666f9a3866bc69260a7d81fe656a1d0fc9335302b4d82fa',
        74732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CabinCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Condensed
  static TextTheme cabinCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cabinCondensed(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cabinCondensed(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cabinCondensed(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cabinCondensed(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cabinCondensed(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cabinCondensed(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cabinCondensed(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cabinCondensed(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cabinCondensed(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cabinCondensed(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cabinCondensed(textStyle: textTheme.caption),
      button: GoogleFonts.cabinCondensed(textStyle: textTheme.button),
      overline: GoogleFonts.cabinCondensed(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cabin Sketch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Sketch
  static TextStyle cabinSketch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c56ec3d2c6227ce0f5959e906b36dda6fbf2ea830ed4edeb9000ee53197c122e',
        155128,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6dab969699fde26ddd2636960d9e77e5178036db4b98b1f3761df0e74e17ca88',
        269912,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CabinSketch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cabin Sketch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cabin+Sketch
  static TextTheme cabinSketchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cabinSketch(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cabinSketch(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cabinSketch(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cabinSketch(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cabinSketch(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cabinSketch(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cabinSketch(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cabinSketch(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cabinSketch(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cabinSketch(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cabinSketch(textStyle: textTheme.caption),
      button: GoogleFonts.cabinSketch(textStyle: textTheme.button),
      overline: GoogleFonts.cabinSketch(textStyle: textTheme.overline),
    );
  }

  /// Applies the Caesar Dressing font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caesar+Dressing
  static TextStyle caesarDressing({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee89ad88164ca8c3eeb747410087b9deecb5d306172af188f53bd267ec033f9c',
        89212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CaesarDressing',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caesar Dressing font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caesar+Dressing
  static TextTheme caesarDressingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.caesarDressing(textStyle: textTheme.headline1),
      headline2: GoogleFonts.caesarDressing(textStyle: textTheme.headline2),
      headline3: GoogleFonts.caesarDressing(textStyle: textTheme.headline3),
      headline4: GoogleFonts.caesarDressing(textStyle: textTheme.headline4),
      headline5: GoogleFonts.caesarDressing(textStyle: textTheme.headline5),
      headline6: GoogleFonts.caesarDressing(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.caesarDressing(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.caesarDressing(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.caesarDressing(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.caesarDressing(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.caesarDressing(textStyle: textTheme.caption),
      button: GoogleFonts.caesarDressing(textStyle: textTheme.button),
      overline: GoogleFonts.caesarDressing(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cagliostro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cagliostro
  static TextStyle cagliostro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f57e12bc813bf3381233056c5544a970ea10f321f64dc63eef3ae1e650b2b93',
        37772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cagliostro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cagliostro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cagliostro
  static TextTheme cagliostroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cagliostro(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cagliostro(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cagliostro(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cagliostro(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cagliostro(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cagliostro(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cagliostro(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cagliostro(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cagliostro(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cagliostro(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cagliostro(textStyle: textTheme.caption),
      button: GoogleFonts.cagliostro(textStyle: textTheme.button),
      overline: GoogleFonts.cagliostro(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cairo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo
  static TextStyle cairo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f4138b4fc3c1369eee1151ad813f76e1b371364feb318c2dfed606c6c7a98dc',
        105268,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22d57a326952ad111119348fad278153f66b456e3f1e1b3eba074a4dc167f96e',
        104816,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1537c4e5a58de46dea37716791ce13157250bce598772e19adbf07abdaa2f5c0',
        103204,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f5b7f284695e2fd50ce750d2a479bcbdc7f701be3c33893f0773866193c8fba',
        104040,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56f0547834a0a361e7216604988268770c085dcbd6f3241778f613b02d6db926',
        98368,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cf0e64d282c925bd689d2224fc9f34075e4586dbbebdbfa585ebab25a42059c',
        105544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cairo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cairo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cairo
  static TextTheme cairoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cairo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cairo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cairo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cairo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cairo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cairo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cairo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cairo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cairo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cairo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cairo(textStyle: textTheme.caption),
      button: GoogleFonts.cairo(textStyle: textTheme.button),
      overline: GoogleFonts.cairo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Caladea font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caladea
  static TextStyle caladea({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60f1d4e3a572497f3530ac2ae1478709e606b3bdaaa56f97fd7efbc48e01de08',
        51516,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a200599eb491ec914c9ce2fe7b2cdda1f14b4d082af53d054932993d3db7e7bb',
        50840,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb25a8c8d05e937b9c5c3a001d1801276ba670641e4332a5f5d83cdc357cc5c3',
        52576,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0d6a8296a9489017c434820f994212d73ffe43b80bc9b3913f0eec7a4b3d4ed5',
        50968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caladea',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caladea font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caladea
  static TextTheme caladeaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.caladea(textStyle: textTheme.headline1),
      headline2: GoogleFonts.caladea(textStyle: textTheme.headline2),
      headline3: GoogleFonts.caladea(textStyle: textTheme.headline3),
      headline4: GoogleFonts.caladea(textStyle: textTheme.headline4),
      headline5: GoogleFonts.caladea(textStyle: textTheme.headline5),
      headline6: GoogleFonts.caladea(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.caladea(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.caladea(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.caladea(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.caladea(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.caladea(textStyle: textTheme.caption),
      button: GoogleFonts.caladea(textStyle: textTheme.button),
      overline: GoogleFonts.caladea(textStyle: textTheme.overline),
    );
  }

  /// Applies the Calistoga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calistoga
  static TextStyle calistoga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bbcc8c6618b098df3f7de4ee7afbe7a4ebe1832e5d8cca3579199c4e73ef5e8f',
        77552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Calistoga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Calistoga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calistoga
  static TextTheme calistogaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.calistoga(textStyle: textTheme.headline1),
      headline2: GoogleFonts.calistoga(textStyle: textTheme.headline2),
      headline3: GoogleFonts.calistoga(textStyle: textTheme.headline3),
      headline4: GoogleFonts.calistoga(textStyle: textTheme.headline4),
      headline5: GoogleFonts.calistoga(textStyle: textTheme.headline5),
      headline6: GoogleFonts.calistoga(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.calistoga(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.calistoga(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.calistoga(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.calistoga(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.calistoga(textStyle: textTheme.caption),
      button: GoogleFonts.calistoga(textStyle: textTheme.button),
      overline: GoogleFonts.calistoga(textStyle: textTheme.overline),
    );
  }

  /// Applies the Calligraffitti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calligraffitti
  static TextStyle calligraffitti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '580e522ce80a61e980096a261015c86696213b70822d677e4de3902787578e63',
        46940,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Calligraffitti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Calligraffitti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Calligraffitti
  static TextTheme calligraffittiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.calligraffitti(textStyle: textTheme.headline1),
      headline2: GoogleFonts.calligraffitti(textStyle: textTheme.headline2),
      headline3: GoogleFonts.calligraffitti(textStyle: textTheme.headline3),
      headline4: GoogleFonts.calligraffitti(textStyle: textTheme.headline4),
      headline5: GoogleFonts.calligraffitti(textStyle: textTheme.headline5),
      headline6: GoogleFonts.calligraffitti(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.calligraffitti(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.calligraffitti(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.calligraffitti(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.calligraffitti(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.calligraffitti(textStyle: textTheme.caption),
      button: GoogleFonts.calligraffitti(textStyle: textTheme.button),
      overline: GoogleFonts.calligraffitti(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cambay font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambay
  static TextStyle cambay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7bad4e2ac4cc5bdeef53e890b4b3d52b065fdae8ebe5f754f263384995f7c73',
        140024,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e821a1eb24db547646223e8b5065d6feeed373e25daf722bd4c3499785d3b6aa',
        155856,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ece04d3d10726b39914e7a3c3ebbef7ccadcf7a26272fc090c83d3bf7690eea4',
        139576,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd17daa8d61f0a8bdd69696d0da7fc566e3a13141eb0ae45e512b48dcafb92565',
        151048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cambay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cambay font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambay
  static TextTheme cambayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cambay(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cambay(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cambay(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cambay(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cambay(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cambay(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cambay(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cambay(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cambay(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cambay(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cambay(textStyle: textTheme.caption),
      button: GoogleFonts.cambay(textStyle: textTheme.button),
      overline: GoogleFonts.cambay(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cambo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambo
  static TextStyle cambo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d8d683131ae5168d1210d9676808b76b985ad2a151d3a7514ec02f7b8a776b9',
        29056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cambo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cambo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cambo
  static TextTheme camboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cambo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cambo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cambo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cambo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cambo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cambo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cambo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cambo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cambo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cambo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cambo(textStyle: textTheme.caption),
      button: GoogleFonts.cambo(textStyle: textTheme.button),
      overline: GoogleFonts.cambo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Candal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Candal
  static TextStyle candal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e16795a5489340834dda623038868a2e7f48f4bc0f154f98c1a1962894a2598',
        32200,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Candal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Candal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Candal
  static TextTheme candalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.candal(textStyle: textTheme.headline1),
      headline2: GoogleFonts.candal(textStyle: textTheme.headline2),
      headline3: GoogleFonts.candal(textStyle: textTheme.headline3),
      headline4: GoogleFonts.candal(textStyle: textTheme.headline4),
      headline5: GoogleFonts.candal(textStyle: textTheme.headline5),
      headline6: GoogleFonts.candal(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.candal(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.candal(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.candal(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.candal(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.candal(textStyle: textTheme.caption),
      button: GoogleFonts.candal(textStyle: textTheme.button),
      overline: GoogleFonts.candal(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cantarell font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantarell
  static TextStyle cantarell({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1e62d82800c92f72ed501733b5d52d7b8a5d88d1c6315bfdaf7f8ce781108c00',
        47436,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6d9559dd0df30daed7da97dc8ef05e7f39b72205fb9bd7a055ddaa5242afd36f',
        50000,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db0c34021061680135f973a2cb5565811527ea91f2fa07d023f4e105eb6f45d3',
        49208,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bb2c0f469972ec2016c3b8b8254ea0077f46207efb249afb3c4d356cf2c5418e',
        52132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cantarell',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantarell font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantarell
  static TextTheme cantarellTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cantarell(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cantarell(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cantarell(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cantarell(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cantarell(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cantarell(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cantarell(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cantarell(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cantarell(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cantarell(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cantarell(textStyle: textTheme.caption),
      button: GoogleFonts.cantarell(textStyle: textTheme.button),
      overline: GoogleFonts.cantarell(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cantata One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantata+One
  static TextStyle cantataOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b58597daf95866fac678391238aefbae4bc3e31e826a3b85a2c749c3844a4dfe',
        57144,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CantataOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantata One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantata+One
  static TextTheme cantataOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cantataOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cantataOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cantataOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cantataOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cantataOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cantataOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cantataOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cantataOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cantataOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cantataOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cantataOne(textStyle: textTheme.caption),
      button: GoogleFonts.cantataOne(textStyle: textTheme.button),
      overline: GoogleFonts.cantataOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cantora One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantora+One
  static TextStyle cantoraOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '242d2167789079107cbe59c3e9ccd0339ca51419245296a4659c6b3ad73cc41c',
        109236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CantoraOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cantora One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cantora+One
  static TextTheme cantoraOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cantoraOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cantoraOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cantoraOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cantoraOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cantoraOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cantoraOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cantoraOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cantoraOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cantoraOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cantoraOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cantoraOne(textStyle: textTheme.caption),
      button: GoogleFonts.cantoraOne(textStyle: textTheme.button),
      overline: GoogleFonts.cantoraOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Capriola font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Capriola
  static TextStyle capriola({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '938d0b1c7f521513ee9bb1114d92827718670e0e5a495ccd564d70b0ddc59594',
        78168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Capriola',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Capriola font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Capriola
  static TextTheme capriolaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.capriola(textStyle: textTheme.headline1),
      headline2: GoogleFonts.capriola(textStyle: textTheme.headline2),
      headline3: GoogleFonts.capriola(textStyle: textTheme.headline3),
      headline4: GoogleFonts.capriola(textStyle: textTheme.headline4),
      headline5: GoogleFonts.capriola(textStyle: textTheme.headline5),
      headline6: GoogleFonts.capriola(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.capriola(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.capriola(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.capriola(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.capriola(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.capriola(textStyle: textTheme.caption),
      button: GoogleFonts.capriola(textStyle: textTheme.button),
      overline: GoogleFonts.capriola(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cardo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cardo
  static TextStyle cardo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '286e6a4bde92ea6087b503978338898808df924a3cdd8144741fa780d11603a2',
        400420,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '43bee56e6bb3d2ad574558a859227592f0b0ac881a70fd8f2cf74b808bb9be00',
        262820,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10c0bab22a674656a3d5e94e05e64f9c6c6ea25acce0d0fc846f964985b142ce',
        348296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cardo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cardo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cardo
  static TextTheme cardoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cardo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cardo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cardo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cardo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cardo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cardo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cardo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cardo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cardo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cardo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cardo(textStyle: textTheme.caption),
      button: GoogleFonts.cardo(textStyle: textTheme.button),
      overline: GoogleFonts.cardo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Carme font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carme
  static TextStyle carme({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79973fb109b078d0e49d90287e9f6527dc8829c6076c878ed07743d78cfb988b',
        60852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Carme',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carme font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carme
  static TextTheme carmeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.carme(textStyle: textTheme.headline1),
      headline2: GoogleFonts.carme(textStyle: textTheme.headline2),
      headline3: GoogleFonts.carme(textStyle: textTheme.headline3),
      headline4: GoogleFonts.carme(textStyle: textTheme.headline4),
      headline5: GoogleFonts.carme(textStyle: textTheme.headline5),
      headline6: GoogleFonts.carme(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.carme(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.carme(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.carme(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.carme(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.carme(textStyle: textTheme.caption),
      button: GoogleFonts.carme(textStyle: textTheme.button),
      overline: GoogleFonts.carme(textStyle: textTheme.overline),
    );
  }

  /// Applies the Carrois Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic
  static TextStyle carroisGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd013d780a3d17a244794f0d2649a6214a1946f102ddf0a02fe366fa7bb8bb6ec',
        26212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarroisGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carrois Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic
  static TextTheme carroisGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.carroisGothic(textStyle: textTheme.headline1),
      headline2: GoogleFonts.carroisGothic(textStyle: textTheme.headline2),
      headline3: GoogleFonts.carroisGothic(textStyle: textTheme.headline3),
      headline4: GoogleFonts.carroisGothic(textStyle: textTheme.headline4),
      headline5: GoogleFonts.carroisGothic(textStyle: textTheme.headline5),
      headline6: GoogleFonts.carroisGothic(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.carroisGothic(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.carroisGothic(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.carroisGothic(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.carroisGothic(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.carroisGothic(textStyle: textTheme.caption),
      button: GoogleFonts.carroisGothic(textStyle: textTheme.button),
      overline: GoogleFonts.carroisGothic(textStyle: textTheme.overline),
    );
  }

  /// Applies the Carrois Gothic SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic+SC
  static TextStyle carroisGothicSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b50b78ae9eb35706d3d9923b420465d6c6245e9469dcbe4a96c30d118338edf',
        26084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarroisGothicSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carrois Gothic SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carrois+Gothic+SC
  static TextTheme carroisGothicScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.carroisGothicSc(textStyle: textTheme.headline1),
      headline2: GoogleFonts.carroisGothicSc(textStyle: textTheme.headline2),
      headline3: GoogleFonts.carroisGothicSc(textStyle: textTheme.headline3),
      headline4: GoogleFonts.carroisGothicSc(textStyle: textTheme.headline4),
      headline5: GoogleFonts.carroisGothicSc(textStyle: textTheme.headline5),
      headline6: GoogleFonts.carroisGothicSc(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.carroisGothicSc(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.carroisGothicSc(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.carroisGothicSc(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.carroisGothicSc(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.carroisGothicSc(textStyle: textTheme.caption),
      button: GoogleFonts.carroisGothicSc(textStyle: textTheme.button),
      overline: GoogleFonts.carroisGothicSc(textStyle: textTheme.overline),
    );
  }

  /// Applies the Carter One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carter+One
  static TextStyle carterOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64cdbf0babf6eb9e23f0a780f283a930636589b4b8d9a5d0cdf24888a7719292',
        63872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CarterOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Carter One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Carter+One
  static TextTheme carterOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.carterOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.carterOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.carterOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.carterOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.carterOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.carterOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.carterOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.carterOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.carterOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.carterOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.carterOne(textStyle: textTheme.caption),
      button: GoogleFonts.carterOne(textStyle: textTheme.button),
      overline: GoogleFonts.carterOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Castoro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Castoro
  static TextStyle castoro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1c0fdc4bf42e6acc4514d8e123a56bfa4101a0bf4d339c2f0a71bfcb0f6d02e',
        70892,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '14b88401404e0d4111e8147bff13b3e811ece5feb299cd9259f3571ceb0de230',
        72080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Castoro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Castoro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Castoro
  static TextTheme castoroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.castoro(textStyle: textTheme.headline1),
      headline2: GoogleFonts.castoro(textStyle: textTheme.headline2),
      headline3: GoogleFonts.castoro(textStyle: textTheme.headline3),
      headline4: GoogleFonts.castoro(textStyle: textTheme.headline4),
      headline5: GoogleFonts.castoro(textStyle: textTheme.headline5),
      headline6: GoogleFonts.castoro(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.castoro(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.castoro(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.castoro(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.castoro(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.castoro(textStyle: textTheme.caption),
      button: GoogleFonts.castoro(textStyle: textTheme.button),
      overline: GoogleFonts.castoro(textStyle: textTheme.overline),
    );
  }

  /// Applies the Catamaran font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Catamaran
  static TextStyle catamaran({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8e9d704be93826d9781f133277934bb6184afd9522b149f005c78f5d89e62ac',
        51516,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f24bc068d63c199fab01e5c0690d6e034f485057c3c19571b656e705a78756b',
        51520,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '853537ef3cef46cebdd3f2ee0f94b33861095d50b2584d6f96a47725f6f4b79d',
        51428,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6af095039ae2cc21b9f8e147b290dc6fae99dd4f45843dd262a9e30557dd4e65',
        51200,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b80fad7d7ef99a42af9235090775e879520d07fb7b3deda4986a64c81be4a96',
        51172,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd77e1072b0d92cfa66cc458ff7e053b1e33cfa9dd663fb52f75062ba9a134122',
        51028,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47d32e32345049db4c0f41c0ffba707afcf0ac18cb7000817fd26ae811255728',
        50828,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '342bd0052b9b81ca6df68a9cdda635ad6f77c796e37045545bfa1d0a071c0bc8',
        50464,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa466db090fa897764fa413a006d0c4f7a975a118db3de634988a14f674446cb',
        50220,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Catamaran',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Catamaran font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Catamaran
  static TextTheme catamaranTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.catamaran(textStyle: textTheme.headline1),
      headline2: GoogleFonts.catamaran(textStyle: textTheme.headline2),
      headline3: GoogleFonts.catamaran(textStyle: textTheme.headline3),
      headline4: GoogleFonts.catamaran(textStyle: textTheme.headline4),
      headline5: GoogleFonts.catamaran(textStyle: textTheme.headline5),
      headline6: GoogleFonts.catamaran(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.catamaran(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.catamaran(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.catamaran(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.catamaran(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.catamaran(textStyle: textTheme.caption),
      button: GoogleFonts.catamaran(textStyle: textTheme.button),
      overline: GoogleFonts.catamaran(textStyle: textTheme.overline),
    );
  }

  /// Applies the Caudex font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caudex
  static TextStyle caudex({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0c195632ea06158f87e86ee898119dd8a7f59788999552ed79be77c33c6a726',
        466276,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53374860983e21bb358d83d1162c824903649ae49f873a963c665b066514bb9d',
        559392,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09a6db433fd45eb3e1423e9947afe5b766008cc358cb482b42103970fc840676',
        471660,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45c118976f77e53a2a5122e22cace7fb846373a14892fbb7e0ff61e1a46de1d4',
        555108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caudex',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caudex font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caudex
  static TextTheme caudexTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.caudex(textStyle: textTheme.headline1),
      headline2: GoogleFonts.caudex(textStyle: textTheme.headline2),
      headline3: GoogleFonts.caudex(textStyle: textTheme.headline3),
      headline4: GoogleFonts.caudex(textStyle: textTheme.headline4),
      headline5: GoogleFonts.caudex(textStyle: textTheme.headline5),
      headline6: GoogleFonts.caudex(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.caudex(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.caudex(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.caudex(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.caudex(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.caudex(textStyle: textTheme.caption),
      button: GoogleFonts.caudex(textStyle: textTheme.button),
      overline: GoogleFonts.caudex(textStyle: textTheme.overline),
    );
  }

  /// Applies the Caveat font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat
  static TextStyle caveat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ffe3acdd9c8d91838d7ba021d1c4e9111151e34a104318a8aafe0efeda5755f',
        165376,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6993da01fa90c359d45a03be9927b46be80d261978de6f5805f43d75ed2d172f',
        166236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Caveat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caveat font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat
  static TextTheme caveatTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.caveat(textStyle: textTheme.headline1),
      headline2: GoogleFonts.caveat(textStyle: textTheme.headline2),
      headline3: GoogleFonts.caveat(textStyle: textTheme.headline3),
      headline4: GoogleFonts.caveat(textStyle: textTheme.headline4),
      headline5: GoogleFonts.caveat(textStyle: textTheme.headline5),
      headline6: GoogleFonts.caveat(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.caveat(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.caveat(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.caveat(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.caveat(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.caveat(textStyle: textTheme.caption),
      button: GoogleFonts.caveat(textStyle: textTheme.button),
      overline: GoogleFonts.caveat(textStyle: textTheme.overline),
    );
  }

  /// Applies the Caveat Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat+Brush
  static TextStyle caveatBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70de81a815f44819880ddba3c93eda87ab6bd1a4b21db15e5ba29c9271cba521',
        232640,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CaveatBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Caveat Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Caveat+Brush
  static TextTheme caveatBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.caveatBrush(textStyle: textTheme.headline1),
      headline2: GoogleFonts.caveatBrush(textStyle: textTheme.headline2),
      headline3: GoogleFonts.caveatBrush(textStyle: textTheme.headline3),
      headline4: GoogleFonts.caveatBrush(textStyle: textTheme.headline4),
      headline5: GoogleFonts.caveatBrush(textStyle: textTheme.headline5),
      headline6: GoogleFonts.caveatBrush(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.caveatBrush(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.caveatBrush(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.caveatBrush(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.caveatBrush(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.caveatBrush(textStyle: textTheme.caption),
      button: GoogleFonts.caveatBrush(textStyle: textTheme.button),
      overline: GoogleFonts.caveatBrush(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cedarville Cursive font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cedarville+Cursive
  static TextStyle cedarvilleCursive({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1296a081a20bf4a1936ace5eac4d05fa6702cdfaab5f94a5088af4c0aa46c3d',
        68704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CedarvilleCursive',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cedarville Cursive font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cedarville+Cursive
  static TextTheme cedarvilleCursiveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cedarvilleCursive(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cedarvilleCursive(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cedarvilleCursive(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cedarvilleCursive(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cedarvilleCursive(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cedarvilleCursive(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cedarvilleCursive(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cedarvilleCursive(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cedarvilleCursive(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cedarvilleCursive(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cedarvilleCursive(textStyle: textTheme.caption),
      button: GoogleFonts.cedarvilleCursive(textStyle: textTheme.button),
      overline: GoogleFonts.cedarvilleCursive(textStyle: textTheme.overline),
    );
  }

  /// Applies the Ceviche One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ceviche+One
  static TextStyle cevicheOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ed3cdc36bf356dbe366b2198c633acbf26815fc96c14ba05a7847b274043909',
        36688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CevicheOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ceviche One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ceviche+One
  static TextTheme cevicheOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cevicheOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cevicheOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cevicheOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cevicheOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cevicheOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cevicheOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cevicheOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cevicheOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cevicheOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cevicheOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cevicheOne(textStyle: textTheme.caption),
      button: GoogleFonts.cevicheOne(textStyle: textTheme.button),
      overline: GoogleFonts.cevicheOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chakra Petch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chakra+Petch
  static TextStyle chakraPetch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ecaf4ae2d67c61e2a3fa8df13a271ccea00d43000ba74107e7bfda439f60b1d2',
        70452,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '020376f9083d9c7e6f32ecb879dee72b6fadef64ea9a3df0bd01d4952a06f1aa',
        72720,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6854c9992a9a1345525235ab8e75582a0f6f3f828c37e4720a78aad1de6c0aa5',
        70160,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '114572d34834d0022111a2a7a0eaf1d6bb7e3b70537f2c52e283219fa86ccd02',
        72412,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '179d4e7774a67d1c01789bcf1bf48e72fbc37fa173f3373470769b54a505ad17',
        70152,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f7172b64774efd15a32d833b00836c9e30c0ee766c096a08de2a427c904f5c2d',
        72504,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6b54f7d68496d966460fe300af5b72cc91ca631822110de9fbc976ceabb2591',
        70164,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a7a04e1ebef703c41253da2ca8a90c83a63649e471590d939c69828a0e0e591f',
        72524,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e409c139ac42c535be29bfb904109788499a4b3971f95c0853dce713da259ea9',
        70068,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '86042cd1693573443cb56c465a3f44172486eb888d707fcc03eb3dc8600008cb',
        72408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChakraPetch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chakra Petch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chakra+Petch
  static TextTheme chakraPetchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chakraPetch(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chakraPetch(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chakraPetch(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chakraPetch(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chakraPetch(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chakraPetch(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chakraPetch(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chakraPetch(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chakraPetch(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chakraPetch(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chakraPetch(textStyle: textTheme.caption),
      button: GoogleFonts.chakraPetch(textStyle: textTheme.button),
      overline: GoogleFonts.chakraPetch(textStyle: textTheme.overline),
    );
  }

  /// Applies the Changa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa
  static TextStyle changa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e248c51b3bc1f8fd1d6b980400670c54bf2cdf89f4c5e075bca29f09ecdb936b',
        81252,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f083dc8e9965f9e9b8c6c977bcfac5a504f4ef820e8c8237f1217d4edf3bdd9a',
        80888,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01d71ec0cc7235bb908cc0c3ae45d1e10a2f87e4a61ad5ef855af157f39e8a80',
        80184,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb1d544301460f01712f06d94a05af7420497d1b5791bdf43b542c0351227242',
        80588,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c22f4b8d7a97aaa32759b9336354bdcf999861dac5d589a4e02e7e5bb9504f98',
        80472,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a274e0c0a7aa46f455bf65caff8b972998ce8fc975bf677ae154d5765ac4c0f',
        79956,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d419cee41ca204d194f089cfd5d8d35ea6bc706a8f606ecaa69132df9854893',
        79556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Changa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Changa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa
  static TextTheme changaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.changa(textStyle: textTheme.headline1),
      headline2: GoogleFonts.changa(textStyle: textTheme.headline2),
      headline3: GoogleFonts.changa(textStyle: textTheme.headline3),
      headline4: GoogleFonts.changa(textStyle: textTheme.headline4),
      headline5: GoogleFonts.changa(textStyle: textTheme.headline5),
      headline6: GoogleFonts.changa(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.changa(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.changa(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.changa(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.changa(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.changa(textStyle: textTheme.caption),
      button: GoogleFonts.changa(textStyle: textTheme.button),
      overline: GoogleFonts.changa(textStyle: textTheme.overline),
    );
  }

  /// Applies the Changa One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa+One
  static TextStyle changaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55a043f0a2eb34269cfb137a6203fdc338019e9bdaabee1e685c6b37495cb962',
        22668,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '241077b802e7b6209a41ea93aae98aa81d9f09e6f78fce924c863af6ca96b529',
        26680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChangaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Changa One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Changa+One
  static TextTheme changaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.changaOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.changaOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.changaOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.changaOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.changaOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.changaOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.changaOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.changaOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.changaOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.changaOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.changaOne(textStyle: textTheme.caption),
      button: GoogleFonts.changaOne(textStyle: textTheme.button),
      overline: GoogleFonts.changaOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chango font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chango
  static TextStyle chango({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66d5dcae03b7a0d59f38640d05bb920cc6d3b4e2a1cdb176628330e20ab9a6ca',
        40684,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chango',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chango font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chango
  static TextTheme changoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chango(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chango(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chango(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chango(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chango(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chango(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chango(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chango(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chango(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chango(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chango(textStyle: textTheme.caption),
      button: GoogleFonts.chango(textStyle: textTheme.button),
      overline: GoogleFonts.chango(textStyle: textTheme.overline),
    );
  }

  /// Applies the Charm font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charm
  static TextStyle charm({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2803aafd875584dcb262e1eddd8dc7542342f4d2d76ac5f9b06c6b5e2bae18f',
        121276,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40f34767fa59a87e641da20236b9966135321cb03c1ed68d88a6234d432d2604',
        122112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Charm',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Charm font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charm
  static TextTheme charmTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.charm(textStyle: textTheme.headline1),
      headline2: GoogleFonts.charm(textStyle: textTheme.headline2),
      headline3: GoogleFonts.charm(textStyle: textTheme.headline3),
      headline4: GoogleFonts.charm(textStyle: textTheme.headline4),
      headline5: GoogleFonts.charm(textStyle: textTheme.headline5),
      headline6: GoogleFonts.charm(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.charm(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.charm(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.charm(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.charm(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.charm(textStyle: textTheme.caption),
      button: GoogleFonts.charm(textStyle: textTheme.button),
      overline: GoogleFonts.charm(textStyle: textTheme.overline),
    );
  }

  /// Applies the Charmonman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charmonman
  static TextStyle charmonman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c4d7f973e9f5d882d38668d863ec90889ddc79cd302e832da538621ac970513',
        100884,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1492915dc59b590610a5b5bcf4d1b9aca380c377b870a0a9de187fc05146908',
        100612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Charmonman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Charmonman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Charmonman
  static TextTheme charmonmanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.charmonman(textStyle: textTheme.headline1),
      headline2: GoogleFonts.charmonman(textStyle: textTheme.headline2),
      headline3: GoogleFonts.charmonman(textStyle: textTheme.headline3),
      headline4: GoogleFonts.charmonman(textStyle: textTheme.headline4),
      headline5: GoogleFonts.charmonman(textStyle: textTheme.headline5),
      headline6: GoogleFonts.charmonman(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.charmonman(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.charmonman(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.charmonman(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.charmonman(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.charmonman(textStyle: textTheme.caption),
      button: GoogleFonts.charmonman(textStyle: textTheme.button),
      overline: GoogleFonts.charmonman(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chathura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chathura
  static TextStyle chathura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '78a5a2532fd10bcf3317ec8440d1e758a309bd152369607ccea764abddbcb168',
        345716,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b8357f2b60bfe270ca77801978a0bd5e729870ffad8b19d54ff69cded800a1f',
        340972,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8abdba026fb7a58e3f5b2cbe302ab4d9e817e69dfd7c6fce0ffbf22fe9600f5',
        330780,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '129573e675c52db3364e6d6ac3d517a6cb8113531a3bc2b54276e1d28d28c11a',
        329608,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6190f40f502b8b950146bbe4ba7b7b02eea38047766ba5b56895059e3b6c655',
        328760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chathura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chathura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chathura
  static TextTheme chathuraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chathura(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chathura(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chathura(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chathura(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chathura(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chathura(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chathura(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chathura(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chathura(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chathura(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chathura(textStyle: textTheme.caption),
      button: GoogleFonts.chathura(textStyle: textTheme.button),
      overline: GoogleFonts.chathura(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chau Philomene One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chau+Philomene+One
  static TextStyle chauPhilomeneOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c44d00d1e4d0cfcf8ae3458b12571cdd000ce9df7849a29afa3dd3aadfdb6224',
        39692,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5be1fbfb8c59a78422d618850745eeabe8bebc7aef35518a599c765168ad124a',
        43992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChauPhilomeneOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chau Philomene One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chau+Philomene+One
  static TextTheme chauPhilomeneOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.caption),
      button: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.button),
      overline: GoogleFonts.chauPhilomeneOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chela One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chela+One
  static TextStyle chelaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3efd79a48f37981dfb1dd9c73243093c103f990459d6cc0e0918ed692c2beef0',
        35492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChelaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chela One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chela+One
  static TextTheme chelaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chelaOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chelaOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chelaOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chelaOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chelaOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chelaOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chelaOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chelaOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chelaOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chelaOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chelaOne(textStyle: textTheme.caption),
      button: GoogleFonts.chelaOne(textStyle: textTheme.button),
      overline: GoogleFonts.chelaOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chelsea Market font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chelsea+Market
  static TextStyle chelseaMarket({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7841b0525f53772efeff1353b0297e9faa176874f84319d11057dfa3d129147b',
        172508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ChelseaMarket',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chelsea Market font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chelsea+Market
  static TextTheme chelseaMarketTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chelseaMarket(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chelseaMarket(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chelseaMarket(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chelseaMarket(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chelseaMarket(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chelseaMarket(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chelseaMarket(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chelseaMarket(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chelseaMarket(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chelseaMarket(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chelseaMarket(textStyle: textTheme.caption),
      button: GoogleFonts.chelseaMarket(textStyle: textTheme.button),
      overline: GoogleFonts.chelseaMarket(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cherry Cream Soda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Cream+Soda
  static TextStyle cherryCreamSoda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47e79c87ca78a16fd9c841454bdf7ea5a7485a08a7f78baddcc83bbc2f510729',
        40208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CherryCreamSoda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherry Cream Soda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Cream+Soda
  static TextTheme cherryCreamSodaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cherryCreamSoda(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cherryCreamSoda(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cherryCreamSoda(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cherryCreamSoda(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cherryCreamSoda(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cherryCreamSoda(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cherryCreamSoda(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cherryCreamSoda(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cherryCreamSoda(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cherryCreamSoda(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cherryCreamSoda(textStyle: textTheme.caption),
      button: GoogleFonts.cherryCreamSoda(textStyle: textTheme.button),
      overline: GoogleFonts.cherryCreamSoda(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cherry Swash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Swash
  static TextStyle cherrySwash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c16f18e4a0ef56672f00dcd810fae50a7468eccc6174968c6890ca1ed1eb4dc0',
        30548,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46fc53776950e3047f5b647b1819e4ec28a5521b733a7e614aa9d97562cb5371',
        29984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CherrySwash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cherry Swash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cherry+Swash
  static TextTheme cherrySwashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cherrySwash(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cherrySwash(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cherrySwash(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cherrySwash(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cherrySwash(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cherrySwash(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cherrySwash(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cherrySwash(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cherrySwash(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cherrySwash(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cherrySwash(textStyle: textTheme.caption),
      button: GoogleFonts.cherrySwash(textStyle: textTheme.button),
      overline: GoogleFonts.cherrySwash(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chewy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chewy
  static TextStyle chewy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd88ead910c7aca7ef7e4aec8e38bc7bd8ea2f85b93181a960e2747192d839469',
        36096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chewy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chewy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chewy
  static TextTheme chewyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chewy(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chewy(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chewy(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chewy(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chewy(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chewy(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chewy(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chewy(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chewy(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chewy(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chewy(textStyle: textTheme.caption),
      button: GoogleFonts.chewy(textStyle: textTheme.button),
      overline: GoogleFonts.chewy(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chicle font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chicle
  static TextStyle chicle({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '463fc42349dcac85fa8e161556aa92b7ae3f8d9cd174ef7b134ac072382d6069',
        40964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chicle',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chicle font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chicle
  static TextTheme chicleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chicle(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chicle(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chicle(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chicle(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chicle(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chicle(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chicle(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chicle(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chicle(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chicle(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chicle(textStyle: textTheme.caption),
      button: GoogleFonts.chicle(textStyle: textTheme.button),
      overline: GoogleFonts.chicle(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chilanka font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chilanka
  static TextStyle chilanka({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0b4dcbe94cf228d02f67f71242fed2881a691a3b3516a791881a3428605d6dc',
        338888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chilanka',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chilanka font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chilanka
  static TextTheme chilankaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chilanka(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chilanka(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chilanka(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chilanka(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chilanka(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chilanka(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chilanka(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chilanka(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chilanka(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chilanka(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chilanka(textStyle: textTheme.caption),
      button: GoogleFonts.chilanka(textStyle: textTheme.button),
      overline: GoogleFonts.chilanka(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chivo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chivo
  static TextStyle chivo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '994635489f0d118a198cb7efcdd1b61cbd4431c9e6426fffad5b731c4d2c1a5c',
        44544,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f512baee58b1fc81a387836a8de41c055d2bebbfde221bd5f6829c1db58d9baa',
        38544,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c45551e766074f40061345617f0e07c5a4a2ecbd70ce90f3c7456284827c3184',
        41264,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1940d6e1383f625468fbb0231dc6d8ea95eda2d8483e23e66e94d6bb05996ca2',
        35312,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '49e634b98df69d1812b9406be76ebe8c76888e0202ae16c267aff5f9897d279f',
        33884,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eea6f18e9fa02d840e18d03dfe74e65437743472807f1f0a93bb11254419cdb4',
        35400,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b16f1d6acd367f8f1dd75d71e56027975f5f4c661b7272c0ae41a0635d55908a',
        34680,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'da92d63af2ecddbae2e8cf92a528caebcba3ed94b7b00e2ab04d228c4622c806',
        36840,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chivo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chivo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chivo
  static TextTheme chivoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chivo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chivo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chivo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chivo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chivo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chivo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chivo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chivo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chivo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chivo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chivo(textStyle: textTheme.caption),
      button: GoogleFonts.chivo(textStyle: textTheme.button),
      overline: GoogleFonts.chivo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Chonburi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chonburi
  static TextStyle chonburi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8e4b1d59bd57981915ee60262422c0d7b7bc237ec938d181c684425e608baca',
        112300,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Chonburi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Chonburi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Chonburi
  static TextTheme chonburiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.chonburi(textStyle: textTheme.headline1),
      headline2: GoogleFonts.chonburi(textStyle: textTheme.headline2),
      headline3: GoogleFonts.chonburi(textStyle: textTheme.headline3),
      headline4: GoogleFonts.chonburi(textStyle: textTheme.headline4),
      headline5: GoogleFonts.chonburi(textStyle: textTheme.headline5),
      headline6: GoogleFonts.chonburi(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.chonburi(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.chonburi(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.chonburi(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.chonburi(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.chonburi(textStyle: textTheme.caption),
      button: GoogleFonts.chonburi(textStyle: textTheme.button),
      overline: GoogleFonts.chonburi(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cinzel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cinzel
  static TextStyle cinzel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a1d67206903b7688f4187df3dd0563dce75a49b26d036c7e88798adcd6c8fab',
        55732,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd385de045feb981ef4256fb3f82d128c1835f686ed5611dd1c5b01e8b615e7bb',
        57244,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbb068fbb60eb4c57957c490b9e8c4b00d9c8cc14bd064d85fca96516f5ae46f',
        58144,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cinzel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cinzel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cinzel
  static TextTheme cinzelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cinzel(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cinzel(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cinzel(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cinzel(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cinzel(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cinzel(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cinzel(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cinzel(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cinzel(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cinzel(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cinzel(textStyle: textTheme.caption),
      button: GoogleFonts.cinzel(textStyle: textTheme.button),
      overline: GoogleFonts.cinzel(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cinzel Decorative font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cinzel+Decorative
  static TextStyle cinzelDecorative({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2559504f7da1fc2410b4eca9cb5ca6fee8c1ead7c3920a0b225ef4f1da9034f',
        60044,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a01d62b7c7d50b908e2fd62beb09363fb5e99ea2f21e0e79f71e5a6c356ceba',
        61900,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9e463550cabc5d5d694e24c136e6d235212011e58c21d523229960a16bc5148',
        62320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CinzelDecorative',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cinzel Decorative font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cinzel+Decorative
  static TextTheme cinzelDecorativeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cinzelDecorative(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cinzelDecorative(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cinzelDecorative(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cinzelDecorative(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cinzelDecorative(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cinzelDecorative(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cinzelDecorative(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cinzelDecorative(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cinzelDecorative(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cinzelDecorative(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cinzelDecorative(textStyle: textTheme.caption),
      button: GoogleFonts.cinzelDecorative(textStyle: textTheme.button),
      overline: GoogleFonts.cinzelDecorative(textStyle: textTheme.overline),
    );
  }

  /// Applies the Clicker Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Clicker+Script
  static TextStyle clickerScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a5d266712bdee3e9dc58039be9fe3d6492b6d9de30e12c387ff7726b7bc43566',
        63596,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ClickerScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Clicker Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Clicker+Script
  static TextTheme clickerScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.clickerScript(textStyle: textTheme.headline1),
      headline2: GoogleFonts.clickerScript(textStyle: textTheme.headline2),
      headline3: GoogleFonts.clickerScript(textStyle: textTheme.headline3),
      headline4: GoogleFonts.clickerScript(textStyle: textTheme.headline4),
      headline5: GoogleFonts.clickerScript(textStyle: textTheme.headline5),
      headline6: GoogleFonts.clickerScript(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.clickerScript(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.clickerScript(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.clickerScript(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.clickerScript(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.clickerScript(textStyle: textTheme.caption),
      button: GoogleFonts.clickerScript(textStyle: textTheme.button),
      overline: GoogleFonts.clickerScript(textStyle: textTheme.overline),
    );
  }

  /// Applies the Coda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coda
  static TextStyle coda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3286b71ee83e8775ab6ae6fef1580c62d0344ad5a8a10ba144104648a36f9749',
        37032,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f385f570ff23725ac544ecfcf2ec8b8cbca733a730d2038266a6eb8b071e4c0',
        31676,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Coda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coda
  static TextTheme codaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.coda(textStyle: textTheme.headline1),
      headline2: GoogleFonts.coda(textStyle: textTheme.headline2),
      headline3: GoogleFonts.coda(textStyle: textTheme.headline3),
      headline4: GoogleFonts.coda(textStyle: textTheme.headline4),
      headline5: GoogleFonts.coda(textStyle: textTheme.headline5),
      headline6: GoogleFonts.coda(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.coda(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.coda(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.coda(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.coda(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.coda(textStyle: textTheme.caption),
      button: GoogleFonts.coda(textStyle: textTheme.button),
      overline: GoogleFonts.coda(textStyle: textTheme.overline),
    );
  }

  /// Applies the Coda Caption font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coda+Caption
  static TextStyle codaCaption({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28b801f8b4a3bbeae1f47a3081d64a60cba59d844b8d9719165a993bbfd5424b',
        59700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CodaCaption',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coda Caption font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coda+Caption
  static TextTheme codaCaptionTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.codaCaption(textStyle: textTheme.headline1),
      headline2: GoogleFonts.codaCaption(textStyle: textTheme.headline2),
      headline3: GoogleFonts.codaCaption(textStyle: textTheme.headline3),
      headline4: GoogleFonts.codaCaption(textStyle: textTheme.headline4),
      headline5: GoogleFonts.codaCaption(textStyle: textTheme.headline5),
      headline6: GoogleFonts.codaCaption(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.codaCaption(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.codaCaption(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.codaCaption(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.codaCaption(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.codaCaption(textStyle: textTheme.caption),
      button: GoogleFonts.codaCaption(textStyle: textTheme.button),
      overline: GoogleFonts.codaCaption(textStyle: textTheme.overline),
    );
  }

  /// Applies the Codystar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Codystar
  static TextStyle codystar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8599cf77d1a295657a62a9be2067a1d7c27dad40e7ae89910c6516e57f1fdb1',
        101120,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d2fb67af692de14dd1f3b942de494168b78c1cef3cc103867d36c4281ac0b00',
        106084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Codystar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Codystar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Codystar
  static TextTheme codystarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.codystar(textStyle: textTheme.headline1),
      headline2: GoogleFonts.codystar(textStyle: textTheme.headline2),
      headline3: GoogleFonts.codystar(textStyle: textTheme.headline3),
      headline4: GoogleFonts.codystar(textStyle: textTheme.headline4),
      headline5: GoogleFonts.codystar(textStyle: textTheme.headline5),
      headline6: GoogleFonts.codystar(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.codystar(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.codystar(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.codystar(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.codystar(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.codystar(textStyle: textTheme.caption),
      button: GoogleFonts.codystar(textStyle: textTheme.button),
      overline: GoogleFonts.codystar(textStyle: textTheme.overline),
    );
  }

  /// Applies the Coiny font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coiny
  static TextStyle coiny({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7c4ad8ba1a68159f3a01ce26a6ae52110298a54077d3aa35b12d216941a3f28',
        88036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Coiny',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coiny font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coiny
  static TextTheme coinyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.coiny(textStyle: textTheme.headline1),
      headline2: GoogleFonts.coiny(textStyle: textTheme.headline2),
      headline3: GoogleFonts.coiny(textStyle: textTheme.headline3),
      headline4: GoogleFonts.coiny(textStyle: textTheme.headline4),
      headline5: GoogleFonts.coiny(textStyle: textTheme.headline5),
      headline6: GoogleFonts.coiny(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.coiny(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.coiny(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.coiny(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.coiny(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.coiny(textStyle: textTheme.caption),
      button: GoogleFonts.coiny(textStyle: textTheme.button),
      overline: GoogleFonts.coiny(textStyle: textTheme.overline),
    );
  }

  /// Applies the Combo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Combo
  static TextStyle combo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb7529647493cbe7db3d0199e9c64a31b084ffe6f9bc8408a5eef9a588daffdd',
        37416,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Combo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Combo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Combo
  static TextTheme comboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.combo(textStyle: textTheme.headline1),
      headline2: GoogleFonts.combo(textStyle: textTheme.headline2),
      headline3: GoogleFonts.combo(textStyle: textTheme.headline3),
      headline4: GoogleFonts.combo(textStyle: textTheme.headline4),
      headline5: GoogleFonts.combo(textStyle: textTheme.headline5),
      headline6: GoogleFonts.combo(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.combo(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.combo(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.combo(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.combo(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.combo(textStyle: textTheme.caption),
      button: GoogleFonts.combo(textStyle: textTheme.button),
      overline: GoogleFonts.combo(textStyle: textTheme.overline),
    );
  }

  /// Applies the Comfortaa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comfortaa
  static TextStyle comfortaa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c42dde162aca0ef35c66a372266676483320b31bd2d1069fd2ec3879d092000',
        106812,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1a86afe9202b2f23f62ea6a901f0f299515c34673aea8cf0d8ab2270b4d7013',
        106948,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30b5d292bb0fe9543a8ae812c3a2ce1ca57f9fd6701afafad31156536db5f08d',
        106956,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Comfortaa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Comfortaa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comfortaa
  static TextTheme comfortaaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.comfortaa(textStyle: textTheme.headline1),
      headline2: GoogleFonts.comfortaa(textStyle: textTheme.headline2),
      headline3: GoogleFonts.comfortaa(textStyle: textTheme.headline3),
      headline4: GoogleFonts.comfortaa(textStyle: textTheme.headline4),
      headline5: GoogleFonts.comfortaa(textStyle: textTheme.headline5),
      headline6: GoogleFonts.comfortaa(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.comfortaa(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.comfortaa(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.comfortaa(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.comfortaa(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.comfortaa(textStyle: textTheme.caption),
      button: GoogleFonts.comfortaa(textStyle: textTheme.button),
      overline: GoogleFonts.comfortaa(textStyle: textTheme.overline),
    );
  }

  /// Applies the Comic Neue font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comic+Neue
  static TextStyle comicNeue({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03e7eb4282b1113db14871908b545b6c90e66c01c71e25eebd86710af1675dc6',
        36488,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e3f90ddc32d7c1de1802b67c219fcaa9a3363ffd6798d5135d4f660a1dda1b26',
        35420,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d7ebe6d4d4dfaab467fe4a423295d991fdfbf4d1989fcaad2f84c5f338ab089',
        36536,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b5fb7946d3c3a90935983acd29701d85ed3c845dbea8a353f82e297d2c3c0fc6',
        35484,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b38da288c36361aa89d7bd2d0cb55585417eef4ae2b1c087d41fa9d3616eb70',
        35256,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '77d1c55b067195ccd5450ef65c41c0bc9adb016fdc56465fa2323318e59a9fef',
        35480,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ComicNeue',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Comic Neue font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Comic+Neue
  static TextTheme comicNeueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.comicNeue(textStyle: textTheme.headline1),
      headline2: GoogleFonts.comicNeue(textStyle: textTheme.headline2),
      headline3: GoogleFonts.comicNeue(textStyle: textTheme.headline3),
      headline4: GoogleFonts.comicNeue(textStyle: textTheme.headline4),
      headline5: GoogleFonts.comicNeue(textStyle: textTheme.headline5),
      headline6: GoogleFonts.comicNeue(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.comicNeue(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.comicNeue(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.comicNeue(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.comicNeue(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.comicNeue(textStyle: textTheme.caption),
      button: GoogleFonts.comicNeue(textStyle: textTheme.button),
      overline: GoogleFonts.comicNeue(textStyle: textTheme.overline),
    );
  }

  /// Applies the Coming Soon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coming+Soon
  static TextStyle comingSoon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '193064f6768240e8165c7b8f6dec7b2dd4cf009b638b76c7b879098469346c5e',
        49836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ComingSoon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coming Soon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coming+Soon
  static TextTheme comingSoonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.comingSoon(textStyle: textTheme.headline1),
      headline2: GoogleFonts.comingSoon(textStyle: textTheme.headline2),
      headline3: GoogleFonts.comingSoon(textStyle: textTheme.headline3),
      headline4: GoogleFonts.comingSoon(textStyle: textTheme.headline4),
      headline5: GoogleFonts.comingSoon(textStyle: textTheme.headline5),
      headline6: GoogleFonts.comingSoon(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.comingSoon(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.comingSoon(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.comingSoon(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.comingSoon(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.comingSoon(textStyle: textTheme.caption),
      button: GoogleFonts.comingSoon(textStyle: textTheme.button),
      overline: GoogleFonts.comingSoon(textStyle: textTheme.overline),
    );
  }

  /// Applies the Commissioner font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Commissioner
  static TextStyle commissioner({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3f150dcb086a17069e52d54fa21cb1f24dc198b7e05359b9b24fa4697da6bd7',
        345392,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1978b19a2dcf7ed0ba2354f75892138d7ae51193a8afe0df8359513bff60c42e',
        352032,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '759373804a16aef0f59d2c1c0ef804972ad9ad65708142d58807d7eac8a311f6',
        356932,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ea57d9c20f9490ea132318ac9b31671cbe5253e441caf88d170d86d5f00d950',
        363648,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e3fadda38391b661f465e8511fce1ae10c4f52b08b3e4879191039f0de43c75',
        364704,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a56720c0fc63f34becc7efc84659cbdacd2bca91b73617065d62ff00f255c2f6',
        367584,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a70994c9420407b957fdc6ed64040600d77318665536587db62dcd33b03e6516',
        368552,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e80c7844535ca64a4b3af21c23f195c9b9bb1f10bd74b7520474fb574b967177',
        367652,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04a4f501c4e3bc2ac11cee31535057bad6c58b0bf9620c3f1acd704c333eb689',
        362176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Commissioner',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Commissioner font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Commissioner
  static TextTheme commissionerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.commissioner(textStyle: textTheme.headline1),
      headline2: GoogleFonts.commissioner(textStyle: textTheme.headline2),
      headline3: GoogleFonts.commissioner(textStyle: textTheme.headline3),
      headline4: GoogleFonts.commissioner(textStyle: textTheme.headline4),
      headline5: GoogleFonts.commissioner(textStyle: textTheme.headline5),
      headline6: GoogleFonts.commissioner(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.commissioner(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.commissioner(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.commissioner(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.commissioner(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.commissioner(textStyle: textTheme.caption),
      button: GoogleFonts.commissioner(textStyle: textTheme.button),
      overline: GoogleFonts.commissioner(textStyle: textTheme.overline),
    );
  }

  /// Applies the Concert One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Concert+One
  static TextStyle concertOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2539111a44381dd36a5a1ab7f50323edd3755088027d0c83419b5ecb88ac14e2',
        44788,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ConcertOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Concert One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Concert+One
  static TextTheme concertOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.concertOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.concertOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.concertOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.concertOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.concertOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.concertOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.concertOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.concertOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.concertOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.concertOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.concertOne(textStyle: textTheme.caption),
      button: GoogleFonts.concertOne(textStyle: textTheme.button),
      overline: GoogleFonts.concertOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Condiment font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Condiment
  static TextStyle condiment({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '404ef1b407aafc9555242dbfc0416b9761054b9bc16abacf2ab328af7b034b66',
        43344,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Condiment',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Condiment font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Condiment
  static TextTheme condimentTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.condiment(textStyle: textTheme.headline1),
      headline2: GoogleFonts.condiment(textStyle: textTheme.headline2),
      headline3: GoogleFonts.condiment(textStyle: textTheme.headline3),
      headline4: GoogleFonts.condiment(textStyle: textTheme.headline4),
      headline5: GoogleFonts.condiment(textStyle: textTheme.headline5),
      headline6: GoogleFonts.condiment(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.condiment(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.condiment(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.condiment(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.condiment(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.condiment(textStyle: textTheme.caption),
      button: GoogleFonts.condiment(textStyle: textTheme.button),
      overline: GoogleFonts.condiment(textStyle: textTheme.overline),
    );
  }

  /// Applies the Contrail One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Contrail+One
  static TextStyle contrailOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51cdbe97cef3cc835b94974aeff5d8805b5d25b1904ad5355836afe27b0cc199',
        31136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ContrailOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Contrail One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Contrail+One
  static TextTheme contrailOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.contrailOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.contrailOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.contrailOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.contrailOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.contrailOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.contrailOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.contrailOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.contrailOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.contrailOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.contrailOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.contrailOne(textStyle: textTheme.caption),
      button: GoogleFonts.contrailOne(textStyle: textTheme.button),
      overline: GoogleFonts.contrailOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Convergence font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Convergence
  static TextStyle convergence({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bee94289e5374af0501d83d8b767d631571ce0a2ab1c16a765bad418a9fbbf22',
        30172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Convergence',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Convergence font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Convergence
  static TextTheme convergenceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.convergence(textStyle: textTheme.headline1),
      headline2: GoogleFonts.convergence(textStyle: textTheme.headline2),
      headline3: GoogleFonts.convergence(textStyle: textTheme.headline3),
      headline4: GoogleFonts.convergence(textStyle: textTheme.headline4),
      headline5: GoogleFonts.convergence(textStyle: textTheme.headline5),
      headline6: GoogleFonts.convergence(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.convergence(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.convergence(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.convergence(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.convergence(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.convergence(textStyle: textTheme.caption),
      button: GoogleFonts.convergence(textStyle: textTheme.button),
      overline: GoogleFonts.convergence(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cookie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cookie
  static TextStyle cookie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d01e7c434faf0f6a1c7c2f49021b8ac01590d10ba4cb8c15683299ed0997536',
        43752,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cookie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cookie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cookie
  static TextTheme cookieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cookie(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cookie(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cookie(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cookie(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cookie(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cookie(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cookie(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cookie(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cookie(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cookie(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cookie(textStyle: textTheme.caption),
      button: GoogleFonts.cookie(textStyle: textTheme.button),
      overline: GoogleFonts.cookie(textStyle: textTheme.overline),
    );
  }

  /// Applies the Copse font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Copse
  static TextStyle copse({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ace02d3cf195f5ddfbe562a9361241356d198ed56d25ec6d8dfb69e08a50133a',
        59116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Copse',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Copse font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Copse
  static TextTheme copseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.copse(textStyle: textTheme.headline1),
      headline2: GoogleFonts.copse(textStyle: textTheme.headline2),
      headline3: GoogleFonts.copse(textStyle: textTheme.headline3),
      headline4: GoogleFonts.copse(textStyle: textTheme.headline4),
      headline5: GoogleFonts.copse(textStyle: textTheme.headline5),
      headline6: GoogleFonts.copse(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.copse(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.copse(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.copse(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.copse(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.copse(textStyle: textTheme.caption),
      button: GoogleFonts.copse(textStyle: textTheme.button),
      overline: GoogleFonts.copse(textStyle: textTheme.overline),
    );
  }

  /// Applies the Corben font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Corben
  static TextStyle corben({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7fa399441299ed2b575ab62e7d0338bebb9b110c569b1ab9661d8df90029b6e',
        35760,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '101e1a5b8d96f12fffab739f046c3a869a5edc6a0a4d2f980c26cef6648331c0',
        113588,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Corben',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Corben font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Corben
  static TextTheme corbenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.corben(textStyle: textTheme.headline1),
      headline2: GoogleFonts.corben(textStyle: textTheme.headline2),
      headline3: GoogleFonts.corben(textStyle: textTheme.headline3),
      headline4: GoogleFonts.corben(textStyle: textTheme.headline4),
      headline5: GoogleFonts.corben(textStyle: textTheme.headline5),
      headline6: GoogleFonts.corben(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.corben(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.corben(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.corben(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.corben(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.corben(textStyle: textTheme.caption),
      button: GoogleFonts.corben(textStyle: textTheme.button),
      overline: GoogleFonts.corben(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cormorant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant
  static TextStyle cormorant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25d9142c8c73577fb3546a40795e753bab11f4e22663e2f1168cbc485cbaa542',
        369920,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd90d995e2a130e04d6e32ee3778e059092e41f5d9c1c812a659c7ffb52951a19',
        241020,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd04cb22306c1c15bb1727fc4b3d2344de940e929b75dbe3faa9b7f43f9e0d6d',
        370052,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1f64218505ec6321eba3b8df95d0806808f61c872f9c081bce39c00a402a4429',
        240392,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20c11bc6844b3f25ad300ce80d94c0c0fc2fb997b51e04cd1959156c6d78309d',
        369256,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47bba53369e3f5bcda0e230d7e6fe60ae86b40b59b80d57c603c50e273d2f17c',
        240280,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1821d5e327189284afba6a7a2a9831a3025677c5afb37910353410a72391791',
        369328,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c02d2b3a07288427fe5cd64e378eebe86d6a308b6d7dfe0e8cc4d1975d32e0d5',
        240048,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a91dc6bed8f499ba7dfc43c8259fa142dc1d0097d84aba2a73c003c35b409845',
        368108,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '01317d3f16a7d1e98e9fcb9e49778326433ab76c291971e501f5e721ac437b0d',
        239228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cormorant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant
  static TextTheme cormorantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cormorant(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cormorant(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cormorant(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cormorant(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cormorant(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cormorant(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cormorant(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cormorant(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cormorant(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cormorant(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cormorant(textStyle: textTheme.caption),
      button: GoogleFonts.cormorant(textStyle: textTheme.button),
      overline: GoogleFonts.cormorant(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cormorant Garamond font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Garamond
  static TextStyle cormorantGaramond({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e5ae2850e0033754375df527e1bb29ed63bd133553ce65b8d9313dd4cc944f8',
        674036,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '86bc19f83cdf358de6e84a3bdbdc0f24e24d47bbdbf7cc2eac80d7bfe24dfdd4',
        426064,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a2dd210ea12467e5697bb32480d20e0ebfbe2c2af1c64b1679567cf3486a8a5',
        673208,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4766c3793328466bbd4f974a3843b2bffb312bd22c98098b0dec8990ba48f5e2',
        424232,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31bc31d93d2a5c505ca03887ae0ad2ad816caf59499f35016d89fe4d5db18ced',
        672392,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e2b5d7b06e08f325bc0513179903b1423183f6533fec2645b64a6e1f24ad699c',
        424904,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25068099ded344cf0919185bae33e11bca97b6c8b1a528dede8ac80325e27c6b',
        671588,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e316fc5e36acd433eb0c3ea1b28d8475a1ff9d0da27bf329fa1bd5d54eb870bf',
        424716,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b273c7be0b4af1389631638e4f056f5d9066fc17d321e665b3a28d43001736af',
        670200,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e1c32c701a4b7594cd169653bc0feceed0160066ce7cedd06999fc884ddd6c02',
        423900,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantGaramond',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant Garamond font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Garamond
  static TextTheme cormorantGaramondTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cormorantGaramond(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cormorantGaramond(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cormorantGaramond(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cormorantGaramond(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cormorantGaramond(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cormorantGaramond(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cormorantGaramond(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cormorantGaramond(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cormorantGaramond(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cormorantGaramond(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cormorantGaramond(textStyle: textTheme.caption),
      button: GoogleFonts.cormorantGaramond(textStyle: textTheme.button),
      overline: GoogleFonts.cormorantGaramond(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cormorant Infant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Infant
  static TextStyle cormorantInfant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9168080bdab2d447729e3f3046722e4d88cfd4cb5a1862dc6d916cba737791c5',
        674136,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e6958c39fabaf907bdde7ba424eb0c17f3fef77c989edbaa01115b1fe5c6e067',
        425328,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47164cf35cfe61e120d0e8c3e775559372e1a738f9e2c57cf85aa05e8c4bc806',
        673248,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '84f78b4a61cce77b8c2c9663434b1c6cf0316b556002a2c9ea9df9265533cf6b',
        423500,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d23820c90080bfb4aa4f9cec1e1ef64424729ef0c9b0e977e27806b21d81304',
        671764,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f8a57af623179b25d7e59c823c1acd0563f9cfb6f1f03da9532e49bf49739dab',
        424168,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6a06c7e0bd73d14e395e0d977119af3b5fae58a9ce153ab18a277182316b424',
        671652,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e1ae8191f481ca057de000de05308f0098090fd60456b76f13b1ffdc82ac1b1d',
        423936,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a03a98979c43146bda66d723dfb38c68b77012ab2433f4eafcbda573433d75b5',
        670304,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ceb4474fec6832dee11e5cc5624186c760e7993898bc39599f3fe8248cbb1b70',
        423176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantInfant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant Infant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Infant
  static TextTheme cormorantInfantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cormorantInfant(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cormorantInfant(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cormorantInfant(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cormorantInfant(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cormorantInfant(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cormorantInfant(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cormorantInfant(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cormorantInfant(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cormorantInfant(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cormorantInfant(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cormorantInfant(textStyle: textTheme.caption),
      button: GoogleFonts.cormorantInfant(textStyle: textTheme.button),
      overline: GoogleFonts.cormorantInfant(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cormorant SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+SC
  static TextStyle cormorantSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '20075e607eb45ea2e8f60f9365f2bf608df1251f443ae12295d751b425dd9b62',
        652740,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8c091c9484c2f6ac490d1613295b59e76d359ad34e1c52fb2f853a8c2ea0aac',
        651888,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85cf334d625e0deec8283f8aa03ec6295e20a52c371096595411dcee4bef2039',
        650624,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a187b0fe3cebc137da0b069c1017ad0c1cfb10ef8992089d21b8261bbc9ad0c',
        650308,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29e53a056b50572310c96ff3a83932d488c6954871aced226c122e7f3ff8b00b',
        648928,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+SC
  static TextTheme cormorantScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cormorantSc(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cormorantSc(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cormorantSc(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cormorantSc(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cormorantSc(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cormorantSc(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cormorantSc(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cormorantSc(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cormorantSc(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cormorantSc(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cormorantSc(textStyle: textTheme.caption),
      button: GoogleFonts.cormorantSc(textStyle: textTheme.button),
      overline: GoogleFonts.cormorantSc(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cormorant Unicase font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Unicase
  static TextStyle cormorantUnicase({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b2f697aa9071850538a594d14122faff09a953f9e6b7897e5284ae9afe2c2b0',
        653392,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a075bd869512a69bf9bfcb4b1987513cf71f5b0f8931adc373783f751c44553a',
        652624,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa07955427124a8c76b2621bceba09805d61cc57efe1c57120f9fd91a46e04ce',
        651372,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34d64ee75c05feffc586b864ce55af03115c3fd6a3c3fabeeef53742fd991848',
        651056,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad4713eaa8a5f3198c0bed735f60707e4cb0c77de5643d8b4df7f61e8a8979a6',
        649664,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantUnicase',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant Unicase font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Unicase
  static TextTheme cormorantUnicaseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cormorantUnicase(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cormorantUnicase(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cormorantUnicase(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cormorantUnicase(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cormorantUnicase(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cormorantUnicase(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cormorantUnicase(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cormorantUnicase(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cormorantUnicase(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cormorantUnicase(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cormorantUnicase(textStyle: textTheme.caption),
      button: GoogleFonts.cormorantUnicase(textStyle: textTheme.button),
      overline: GoogleFonts.cormorantUnicase(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cormorant Upright font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Upright
  static TextStyle cormorantUpright({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29c9067ec4aab7f8532dfad801cd638d35f8738903ec7c40f80069030e231431',
        156128,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7c8d8d44c6591234b85e43c1b61a5f4adc82016e3c7f315b206cf31fda62572',
        155736,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e1c85ea60d180f0a621d975977e7e75c7d398a4d4fcb569d2ccadd85c42adce',
        156096,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d60d4f81c0c154612e2e9b3b5dd56c2ab5e74e4d8e8507d9725ce908a54c914',
        156140,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '441604498e23b982bd6adbe6fe749140f9955eddd7a905329bb88bf4ca9a8f85',
        156320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CormorantUpright',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cormorant Upright font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cormorant+Upright
  static TextTheme cormorantUprightTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cormorantUpright(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cormorantUpright(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cormorantUpright(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cormorantUpright(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cormorantUpright(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cormorantUpright(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cormorantUpright(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cormorantUpright(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cormorantUpright(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cormorantUpright(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cormorantUpright(textStyle: textTheme.caption),
      button: GoogleFonts.cormorantUpright(textStyle: textTheme.button),
      overline: GoogleFonts.cormorantUpright(textStyle: textTheme.overline),
    );
  }

  /// Applies the Courgette font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Courgette
  static TextStyle courgette({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2754f22af579b8f14d78397e6cc4d3879519ad579085e8c047ba2f7719c592a4',
        93820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Courgette',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Courgette font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Courgette
  static TextTheme courgetteTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.courgette(textStyle: textTheme.headline1),
      headline2: GoogleFonts.courgette(textStyle: textTheme.headline2),
      headline3: GoogleFonts.courgette(textStyle: textTheme.headline3),
      headline4: GoogleFonts.courgette(textStyle: textTheme.headline4),
      headline5: GoogleFonts.courgette(textStyle: textTheme.headline5),
      headline6: GoogleFonts.courgette(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.courgette(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.courgette(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.courgette(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.courgette(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.courgette(textStyle: textTheme.caption),
      button: GoogleFonts.courgette(textStyle: textTheme.button),
      overline: GoogleFonts.courgette(textStyle: textTheme.overline),
    );
  }

  /// Applies the Courier Prime font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Courier+Prime
  static TextStyle courierPrime({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ab28865b2644070e548699748855f2d5a34b5bf8adea09607e18d4a7adc8999',
        40588,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7109c63818181b56013b7ced3e5da53d756aab727e6a9786a0c8a58affe4ec23',
        46896,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '385e70d216befbb71f12f5009f1824d235e0f4f2ab653bb0296d5d999afdfd3f',
        42136,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3f61e15019812e414a4dba4f3b4fbdda453e8c4dd18deafacb7c55686cef11a7',
        47340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CourierPrime',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Courier Prime font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Courier+Prime
  static TextTheme courierPrimeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.courierPrime(textStyle: textTheme.headline1),
      headline2: GoogleFonts.courierPrime(textStyle: textTheme.headline2),
      headline3: GoogleFonts.courierPrime(textStyle: textTheme.headline3),
      headline4: GoogleFonts.courierPrime(textStyle: textTheme.headline4),
      headline5: GoogleFonts.courierPrime(textStyle: textTheme.headline5),
      headline6: GoogleFonts.courierPrime(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.courierPrime(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.courierPrime(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.courierPrime(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.courierPrime(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.courierPrime(textStyle: textTheme.caption),
      button: GoogleFonts.courierPrime(textStyle: textTheme.button),
      overline: GoogleFonts.courierPrime(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cousine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cousine
  static TextStyle cousine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '753f2dd34e36271520e1bf057a91850492b226f76d6da301cf6955b4b32177a1',
        191380,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '23ddf22bc3d06b028fce6e266632d38c97fa151a580be71b5ad43ee7d34d13a0',
        200304,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e472053ed3d50c647f75d5654f0d2ff42cbf5221cb14e1b1af3dc25dbbd6ea4',
        191172,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8b14c04baa12f36602157da1c6c26f539163a93e571133c17d0b5acc34345bfa',
        199244,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cousine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cousine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cousine
  static TextTheme cousineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cousine(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cousine(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cousine(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cousine(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cousine(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cousine(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cousine(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cousine(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cousine(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cousine(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cousine(textStyle: textTheme.caption),
      button: GoogleFonts.cousine(textStyle: textTheme.button),
      overline: GoogleFonts.cousine(textStyle: textTheme.overline),
    );
  }

  /// Applies the Coustard font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coustard
  static TextStyle coustard({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '657fe3ebd0e1b0402731533db6ddbe6120271871430adfff3ea617c35120f166',
        39700,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9288e8be500e6cb9ea6f0ae05167d9ee149c0d91fc8a422055f396236b1e413',
        42376,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Coustard',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Coustard font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Coustard
  static TextTheme coustardTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.coustard(textStyle: textTheme.headline1),
      headline2: GoogleFonts.coustard(textStyle: textTheme.headline2),
      headline3: GoogleFonts.coustard(textStyle: textTheme.headline3),
      headline4: GoogleFonts.coustard(textStyle: textTheme.headline4),
      headline5: GoogleFonts.coustard(textStyle: textTheme.headline5),
      headline6: GoogleFonts.coustard(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.coustard(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.coustard(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.coustard(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.coustard(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.coustard(textStyle: textTheme.caption),
      button: GoogleFonts.coustard(textStyle: textTheme.button),
      overline: GoogleFonts.coustard(textStyle: textTheme.overline),
    );
  }

  /// Applies the Covered By Your Grace font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Covered+By+Your+Grace
  static TextStyle coveredByYourGrace({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2e2deb5e6914da1e25b2a2f5161ff4e08d65d6e00d26081708efc7ffacca93a',
        57040,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CoveredByYourGrace',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Covered By Your Grace font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Covered+By+Your+Grace
  static TextTheme coveredByYourGraceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.coveredByYourGrace(textStyle: textTheme.headline1),
      headline2: GoogleFonts.coveredByYourGrace(textStyle: textTheme.headline2),
      headline3: GoogleFonts.coveredByYourGrace(textStyle: textTheme.headline3),
      headline4: GoogleFonts.coveredByYourGrace(textStyle: textTheme.headline4),
      headline5: GoogleFonts.coveredByYourGrace(textStyle: textTheme.headline5),
      headline6: GoogleFonts.coveredByYourGrace(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.coveredByYourGrace(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.coveredByYourGrace(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.coveredByYourGrace(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.coveredByYourGrace(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.coveredByYourGrace(textStyle: textTheme.caption),
      button: GoogleFonts.coveredByYourGrace(textStyle: textTheme.button),
      overline: GoogleFonts.coveredByYourGrace(textStyle: textTheme.overline),
    );
  }

  /// Applies the Crafty Girls font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crafty+Girls
  static TextStyle craftyGirls({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dc184885668047ca66db5a530c0462f1b1ef2f2d6867b7f938c59dbc9d282de2',
        61632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CraftyGirls',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crafty Girls font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crafty+Girls
  static TextTheme craftyGirlsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.craftyGirls(textStyle: textTheme.headline1),
      headline2: GoogleFonts.craftyGirls(textStyle: textTheme.headline2),
      headline3: GoogleFonts.craftyGirls(textStyle: textTheme.headline3),
      headline4: GoogleFonts.craftyGirls(textStyle: textTheme.headline4),
      headline5: GoogleFonts.craftyGirls(textStyle: textTheme.headline5),
      headline6: GoogleFonts.craftyGirls(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.craftyGirls(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.craftyGirls(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.craftyGirls(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.craftyGirls(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.craftyGirls(textStyle: textTheme.caption),
      button: GoogleFonts.craftyGirls(textStyle: textTheme.button),
      overline: GoogleFonts.craftyGirls(textStyle: textTheme.overline),
    );
  }

  /// Applies the Creepster font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Creepster
  static TextStyle creepster({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb14e63f8fb5e6bd8706e47aea59d9e2b6b3da1b2f987d1468a6ba5cda2d1fc1',
        62700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Creepster',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Creepster font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Creepster
  static TextTheme creepsterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.creepster(textStyle: textTheme.headline1),
      headline2: GoogleFonts.creepster(textStyle: textTheme.headline2),
      headline3: GoogleFonts.creepster(textStyle: textTheme.headline3),
      headline4: GoogleFonts.creepster(textStyle: textTheme.headline4),
      headline5: GoogleFonts.creepster(textStyle: textTheme.headline5),
      headline6: GoogleFonts.creepster(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.creepster(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.creepster(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.creepster(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.creepster(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.creepster(textStyle: textTheme.caption),
      button: GoogleFonts.creepster(textStyle: textTheme.button),
      overline: GoogleFonts.creepster(textStyle: textTheme.overline),
    );
  }

  /// Applies the Crete Round font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crete+Round
  static TextStyle creteRound({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62fbd9c68fa6485a1a4fde14a03ed6a5268f26365fff7614e5704531390f0363',
        59264,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c8e915bc50126a1af673b8fbd3181aa9f8eac78545ec1b8d827ac5bac66b5cc5',
        67216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CreteRound',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crete Round font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crete+Round
  static TextTheme creteRoundTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.creteRound(textStyle: textTheme.headline1),
      headline2: GoogleFonts.creteRound(textStyle: textTheme.headline2),
      headline3: GoogleFonts.creteRound(textStyle: textTheme.headline3),
      headline4: GoogleFonts.creteRound(textStyle: textTheme.headline4),
      headline5: GoogleFonts.creteRound(textStyle: textTheme.headline5),
      headline6: GoogleFonts.creteRound(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.creteRound(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.creteRound(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.creteRound(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.creteRound(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.creteRound(textStyle: textTheme.caption),
      button: GoogleFonts.creteRound(textStyle: textTheme.button),
      overline: GoogleFonts.creteRound(textStyle: textTheme.overline),
    );
  }

  /// Applies the Crimson Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crimson+Pro
  static TextStyle crimsonPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b66abfec21e34e91fc61b2ac08084816d4d166259ea2198ed01578a1ac727e5',
        89240,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9abd9060a62aa38f10dc60738f37bada274814485a3b3bef4353cbc2503358cc',
        89212,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '510241ec6793070724a690b137fdfb9f98422a611b8f81c1e6f22d345a0fef65',
        89216,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c758f7367d51b291ba0a17386117e7269f7a438bb2dc40acedc1574b113e43e2',
        89248,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0668cef91f47f8b6609de80f66e247d934bc12467bed847c61ad8397297db31',
        89292,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37a3b4d93b35047eba32401d0e748ed133547287e16a5bacc9e40c85d85b489c',
        89208,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2fff124d10656b451037180b7611d390d0fb4f603400346db8986461325e2503',
        89300,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1e12367e6d503736e81c46a7e8dec43a84b804f31bcd06c8cd2e318cac7888b3',
        89264,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '02069dd1baa583bd54af1c82cd1979f3a078ee4087ddd6f64eb34b23c9370ee1',
        91212,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '96b97a5f9ec116f9f218a3b7de6daa5e95e9c6cb1c49b21f12e2df59d5ff2380',
        91168,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '737b0264b20a8110302dc2f70673ca8320d865b82c59d69c354a1e54b2edde3e',
        91044,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '654dd004b7fefe64e3ef615227b16e1da3abce493c844e6359cebe3bc1e98f18',
        91188,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c98a3ef2ed0a7bc571852f4b28fe383e22c671bf9696106fb88605680abfe9eb',
        91192,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dfc39b2565c337e814711b840e339b33b5f5b223042561963c34a8a4cfcd41c8',
        91052,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a2dfc4edba8a2ecffbdf37c1e7ffc640034bbf2e83449b7e5df15e39cd78be80',
        91200,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a99ef7991d1f3adeaa296d774cdf32d4441511e024a0bf21a52b3cac625c49e9',
        91156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CrimsonPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crimson Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crimson+Pro
  static TextTheme crimsonProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.crimsonPro(textStyle: textTheme.headline1),
      headline2: GoogleFonts.crimsonPro(textStyle: textTheme.headline2),
      headline3: GoogleFonts.crimsonPro(textStyle: textTheme.headline3),
      headline4: GoogleFonts.crimsonPro(textStyle: textTheme.headline4),
      headline5: GoogleFonts.crimsonPro(textStyle: textTheme.headline5),
      headline6: GoogleFonts.crimsonPro(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.crimsonPro(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.crimsonPro(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.crimsonPro(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.crimsonPro(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.crimsonPro(textStyle: textTheme.caption),
      button: GoogleFonts.crimsonPro(textStyle: textTheme.button),
      overline: GoogleFonts.crimsonPro(textStyle: textTheme.overline),
    );
  }

  /// Applies the Crimson Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crimson+Text
  static TextStyle crimsonText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '883d56072155a485051564cd3019bb34a608ddfa0553e2295413e7a59c67bd28',
        186656,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '33025a7588fc7f2ca1b8eb2b599e2420ad23278ee100a8f7e11c881d385af57a',
        98404,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37e75069b54a5c937eec2ba3fd3d193e3825fab2122bef2b86d86bc5ff1caab3',
        76316,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15672e6c5d2b277c8dee2e6dcbffc17d3ba0c9a3018c446e199636f68dd227b1',
        74068,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6bfa338154c86d462eef6a8dc69f2443ecc35740bbdc2f2da06e7599c037cbc',
        92296,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c79dc3f51f37e16300b571c6835d06bff022a018b65d9ea69f1f897137acc238',
        74264,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CrimsonText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crimson Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crimson+Text
  static TextTheme crimsonTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.crimsonText(textStyle: textTheme.headline1),
      headline2: GoogleFonts.crimsonText(textStyle: textTheme.headline2),
      headline3: GoogleFonts.crimsonText(textStyle: textTheme.headline3),
      headline4: GoogleFonts.crimsonText(textStyle: textTheme.headline4),
      headline5: GoogleFonts.crimsonText(textStyle: textTheme.headline5),
      headline6: GoogleFonts.crimsonText(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.crimsonText(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.crimsonText(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.crimsonText(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.crimsonText(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.crimsonText(textStyle: textTheme.caption),
      button: GoogleFonts.crimsonText(textStyle: textTheme.button),
      overline: GoogleFonts.crimsonText(textStyle: textTheme.overline),
    );
  }

  /// Applies the Croissant One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Croissant+One
  static TextStyle croissantOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a51f330afdb3504b94cb09686589076855186483e4e89665623ebe0f655ce6ec',
        54696,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CroissantOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Croissant One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Croissant+One
  static TextTheme croissantOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.croissantOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.croissantOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.croissantOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.croissantOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.croissantOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.croissantOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.croissantOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.croissantOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.croissantOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.croissantOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.croissantOne(textStyle: textTheme.caption),
      button: GoogleFonts.croissantOne(textStyle: textTheme.button),
      overline: GoogleFonts.croissantOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Crushed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crushed
  static TextStyle crushed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8487a87e68819238f02206a3eab5aedf7deae9e72b1010c364816df3934ab08',
        57404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Crushed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Crushed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Crushed
  static TextTheme crushedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.crushed(textStyle: textTheme.headline1),
      headline2: GoogleFonts.crushed(textStyle: textTheme.headline2),
      headline3: GoogleFonts.crushed(textStyle: textTheme.headline3),
      headline4: GoogleFonts.crushed(textStyle: textTheme.headline4),
      headline5: GoogleFonts.crushed(textStyle: textTheme.headline5),
      headline6: GoogleFonts.crushed(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.crushed(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.crushed(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.crushed(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.crushed(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.crushed(textStyle: textTheme.caption),
      button: GoogleFonts.crushed(textStyle: textTheme.button),
      overline: GoogleFonts.crushed(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cuprum font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cuprum
  static TextStyle cuprum({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bddf1f3b7162539ab2c939e699c275d83ee353437fc657257d945347dce5c66d',
        69128,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '27d4e15720e86dcbe0f0f3e93656c40e57203137b143f5a396d8a56e654963c8',
        73796,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a3719a13307973f16e4ebfb3980da3f7d190316e71ada51aa42650b95524c97',
        68608,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9bac99436b2027f87f8c0f692398a62b76be18874fbda4ea2b56aaa99553e6b2',
        73828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cuprum',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cuprum font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cuprum
  static TextTheme cuprumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cuprum(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cuprum(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cuprum(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cuprum(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cuprum(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cuprum(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cuprum(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cuprum(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cuprum(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cuprum(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cuprum(textStyle: textTheme.caption),
      button: GoogleFonts.cuprum(textStyle: textTheme.button),
      overline: GoogleFonts.cuprum(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cute Font font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cute+Font
  static TextStyle cuteFont({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '264e6741d6541397294f9de009ed33b609adf005445eaf7a346c99b03ae75feb',
        598524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CuteFont',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cute Font font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cute+Font
  static TextTheme cuteFontTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cuteFont(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cuteFont(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cuteFont(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cuteFont(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cuteFont(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cuteFont(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cuteFont(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cuteFont(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cuteFont(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cuteFont(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cuteFont(textStyle: textTheme.caption),
      button: GoogleFonts.cuteFont(textStyle: textTheme.button),
      overline: GoogleFonts.cuteFont(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cutive font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cutive
  static TextStyle cutive({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e0849ce3a9bd06c1d093ce26a2727da8b032430d3d39d191cfd79df0983d490',
        41960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Cutive',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cutive font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cutive
  static TextTheme cutiveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cutive(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cutive(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cutive(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cutive(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cutive(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cutive(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cutive(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cutive(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cutive(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cutive(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cutive(textStyle: textTheme.caption),
      button: GoogleFonts.cutive(textStyle: textTheme.button),
      overline: GoogleFonts.cutive(textStyle: textTheme.overline),
    );
  }

  /// Applies the Cutive Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cutive+Mono
  static TextStyle cutiveMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0582d0fd288afe72a3eeebdace411705bd456580eb96ee5ef7214afd771ebfce',
        47056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'CutiveMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Cutive Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Cutive+Mono
  static TextTheme cutiveMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.cutiveMono(textStyle: textTheme.headline1),
      headline2: GoogleFonts.cutiveMono(textStyle: textTheme.headline2),
      headline3: GoogleFonts.cutiveMono(textStyle: textTheme.headline3),
      headline4: GoogleFonts.cutiveMono(textStyle: textTheme.headline4),
      headline5: GoogleFonts.cutiveMono(textStyle: textTheme.headline5),
      headline6: GoogleFonts.cutiveMono(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.cutiveMono(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.cutiveMono(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.cutiveMono(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.cutiveMono(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.cutiveMono(textStyle: textTheme.caption),
      button: GoogleFonts.cutiveMono(textStyle: textTheme.button),
      overline: GoogleFonts.cutiveMono(textStyle: textTheme.overline),
    );
  }

  /// Applies the DM Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Mono
  static TextStyle dmMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67638f30d87fc69f052f1ff91f488200a8696ecf2b7e200036b6ba7134665f02',
        27896,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '531245107d1e3f2c1cd8ddeb9bbf214cc2f7412495cc15ffd4a9a6553b677537',
        29060,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9692116a4d8c7abc9a734c6963264b73434254a7b6997a40c0df383364df2c2',
        27932,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eb74ddafb17f67359ab3426667e45e12054b3f2cd578a90880155a897a551ebf',
        29072,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c46ab9994bad814204dd36ade2daafac04937ed6c8620de135d159ee5a4aaad',
        27776,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fe7c6a70b6d89fc903dcb90540d3cba6a078c080ad52ed9eda41becba14ff343',
        29096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DMMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DM Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Mono
  static TextTheme dmMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dmMono(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dmMono(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dmMono(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dmMono(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dmMono(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dmMono(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dmMono(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dmMono(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dmMono(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dmMono(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dmMono(textStyle: textTheme.caption),
      button: GoogleFonts.dmMono(textStyle: textTheme.button),
      overline: GoogleFonts.dmMono(textStyle: textTheme.overline),
    );
  }

  /// Applies the DM Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Sans
  static TextStyle dmSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e518fdb0a5c0ebe0d1d1b02a9025067837e79d235418ab9dc8366e7ce87fad55',
        43504,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de4a1215c7928ebdd157181021531f87614894038bb9396b05826b7ae9595611',
        44712,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '683cd0ce949642886f9652656cfe66d569a79d1530fcde104214769c266ae121',
        43300,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c3126b61a6d535d42dd4e6e4eb66648863d4d4f9bf639d63da74d20cb3fa1fb4',
        44576,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '940d8601e85100233071b73474474f0ea11612beecddd6da32efb7cd8a3971bd',
        43236,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '579b8c8cd4a4fd71ee7ac563e399eacbcba63f3f8556516c95830d98bb9fbae9',
        44512,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DMSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DM Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Sans
  static TextTheme dmSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dmSans(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dmSans(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dmSans(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dmSans(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dmSans(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dmSans(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dmSans(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dmSans(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dmSans(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dmSans(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dmSans(textStyle: textTheme.caption),
      button: GoogleFonts.dmSans(textStyle: textTheme.button),
      overline: GoogleFonts.dmSans(textStyle: textTheme.overline),
    );
  }

  /// Applies the DM Serif Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Serif+Display
  static TextStyle dmSerifDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1157689ec181ea520aeee52f8f7f8c16e0ced52d30800c402aae31faf50985a',
        56068,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '007cfd580d7b1323a1b43156d2591b8119745361daba6117832dcbfb0146a36a',
        50564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DMSerifDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DM Serif Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Serif+Display
  static TextTheme dmSerifDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dmSerifDisplay(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dmSerifDisplay(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dmSerifDisplay(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dmSerifDisplay(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dmSerifDisplay(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dmSerifDisplay(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dmSerifDisplay(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dmSerifDisplay(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dmSerifDisplay(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dmSerifDisplay(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dmSerifDisplay(textStyle: textTheme.caption),
      button: GoogleFonts.dmSerifDisplay(textStyle: textTheme.button),
      overline: GoogleFonts.dmSerifDisplay(textStyle: textTheme.overline),
    );
  }

  /// Applies the DM Serif Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Serif+Text
  static TextStyle dmSerifText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fe3c6727cf74e86cfd545dfe7e6aa3a1dbdff9563e84e085acd65c07f633744',
        56120,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13b9bbb9c2b065c645eb14efbe2bc8dd2a4e41e635d12f8bc15b532e1d5fc628',
        50372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DMSerifText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DM Serif Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Serif+Text
  static TextTheme dmSerifTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dmSerifText(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dmSerifText(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dmSerifText(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dmSerifText(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dmSerifText(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dmSerifText(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dmSerifText(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dmSerifText(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dmSerifText(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dmSerifText(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dmSerifText(textStyle: textTheme.caption),
      button: GoogleFonts.dmSerifText(textStyle: textTheme.button),
      overline: GoogleFonts.dmSerifText(textStyle: textTheme.overline),
    );
  }

  /// Applies the Damion font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Damion
  static TextStyle damion({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b178966c9329bdd54a10c83e076dc1647443dddd2471c9aa477780c6852294c',
        51972,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Damion',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Damion font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Damion
  static TextTheme damionTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.damion(textStyle: textTheme.headline1),
      headline2: GoogleFonts.damion(textStyle: textTheme.headline2),
      headline3: GoogleFonts.damion(textStyle: textTheme.headline3),
      headline4: GoogleFonts.damion(textStyle: textTheme.headline4),
      headline5: GoogleFonts.damion(textStyle: textTheme.headline5),
      headline6: GoogleFonts.damion(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.damion(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.damion(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.damion(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.damion(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.damion(textStyle: textTheme.caption),
      button: GoogleFonts.damion(textStyle: textTheme.button),
      overline: GoogleFonts.damion(textStyle: textTheme.overline),
    );
  }

  /// Applies the Dancing Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dancing+Script
  static TextStyle dancingScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40f021e25f9f4e2b67f5072ac941218596581a1621931f44173cbf5245b91fd3',
        90100,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a2aa446dc86aad49ec46eb66fb313889bded9ef23f286664bba90a2eb156f87',
        89456,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DancingScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dancing Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dancing+Script
  static TextTheme dancingScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dancingScript(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dancingScript(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dancingScript(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dancingScript(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dancingScript(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dancingScript(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dancingScript(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dancingScript(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dancingScript(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dancingScript(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dancingScript(textStyle: textTheme.caption),
      button: GoogleFonts.dancingScript(textStyle: textTheme.button),
      overline: GoogleFonts.dancingScript(textStyle: textTheme.overline),
    );
  }

  /// Applies the Darker Grotesque font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Darker+Grotesque
  static TextStyle darkerGrotesque({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f789e82ef267fb0b5f0798267ba5e3340b661840b52e1de87f7830b7d87a180e',
        40352,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60303e0b600c0176b00422a680228f744d38795fbd8d35344f494b02400628c1',
        42704,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6e1eb6614b97b3298d1d253f5ed4399556da5b06bb191596cebfc813bdd3505',
        42568,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e516ad3d1d4cec56249227f367cba1e2830faa7cedbcf49abca81e7c202b434',
        42552,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b56136288e57809ada8707a74f6756261c3763b3a2686398738c1fd25f157d9c',
        42600,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf5f4f44b908aeed8723415a103b1ad9c5550388d2c8e139adab630a61a74712',
        42632,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eae6b24bfd325c090ef4a304519707f58942487ea7e118bfe036175f8c4690aa',
        42032,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DarkerGrotesque',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Darker Grotesque font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Darker+Grotesque
  static TextTheme darkerGrotesqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.darkerGrotesque(textStyle: textTheme.headline1),
      headline2: GoogleFonts.darkerGrotesque(textStyle: textTheme.headline2),
      headline3: GoogleFonts.darkerGrotesque(textStyle: textTheme.headline3),
      headline4: GoogleFonts.darkerGrotesque(textStyle: textTheme.headline4),
      headline5: GoogleFonts.darkerGrotesque(textStyle: textTheme.headline5),
      headline6: GoogleFonts.darkerGrotesque(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.darkerGrotesque(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.darkerGrotesque(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.darkerGrotesque(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.darkerGrotesque(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.darkerGrotesque(textStyle: textTheme.caption),
      button: GoogleFonts.darkerGrotesque(textStyle: textTheme.button),
      overline: GoogleFonts.darkerGrotesque(textStyle: textTheme.overline),
    );
  }

  /// Applies the David Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/David+Libre
  static TextStyle davidLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8319053cbaa4074884c0364b74327548dbe246119e76a214a864d9d55a12353d',
        91296,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '288d258f0790230352ec2d9b0eef7f533d14554250a99cd0b5cfc80c349d2b38',
        91348,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd02a7be354414e34512a70b5f00901c7c3c4e7df88c6bab47e8ed2e50c770c71',
        92540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DavidLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the David Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/David+Libre
  static TextTheme davidLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.davidLibre(textStyle: textTheme.headline1),
      headline2: GoogleFonts.davidLibre(textStyle: textTheme.headline2),
      headline3: GoogleFonts.davidLibre(textStyle: textTheme.headline3),
      headline4: GoogleFonts.davidLibre(textStyle: textTheme.headline4),
      headline5: GoogleFonts.davidLibre(textStyle: textTheme.headline5),
      headline6: GoogleFonts.davidLibre(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.davidLibre(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.davidLibre(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.davidLibre(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.davidLibre(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.davidLibre(textStyle: textTheme.caption),
      button: GoogleFonts.davidLibre(textStyle: textTheme.button),
      overline: GoogleFonts.davidLibre(textStyle: textTheme.overline),
    );
  }

  /// Applies the Dawning of a New Day font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dawning+of+a+New+Day
  static TextStyle dawningOfANewDay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8fb2c187b599f0368577f599628c83a2543f4c757231bb2c0843e98624eeb4a',
        65320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DawningofaNewDay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dawning of a New Day font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dawning+of+a+New+Day
  static TextTheme dawningOfANewDayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dawningOfANewDay(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dawningOfANewDay(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dawningOfANewDay(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dawningOfANewDay(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dawningOfANewDay(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dawningOfANewDay(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dawningOfANewDay(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dawningOfANewDay(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dawningOfANewDay(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dawningOfANewDay(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dawningOfANewDay(textStyle: textTheme.caption),
      button: GoogleFonts.dawningOfANewDay(textStyle: textTheme.button),
      overline: GoogleFonts.dawningOfANewDay(textStyle: textTheme.overline),
    );
  }

  /// Applies the Days One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Days+One
  static TextStyle daysOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd74812297ac57cf4ce637c47f01cbcab907136f76e2a4028e2ad1e80bd7b8ab0',
        65556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DaysOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Days One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Days+One
  static TextTheme daysOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.daysOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.daysOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.daysOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.daysOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.daysOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.daysOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.daysOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.daysOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.daysOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.daysOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.daysOne(textStyle: textTheme.caption),
      button: GoogleFonts.daysOne(textStyle: textTheme.button),
      overline: GoogleFonts.daysOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Dekko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dekko
  static TextStyle dekko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71d66d24dfda326e074654507fa7b6be6a766f318cf01f17b000fdc6f870fb4d',
        214656,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dekko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dekko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dekko
  static TextTheme dekkoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dekko(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dekko(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dekko(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dekko(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dekko(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dekko(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dekko(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dekko(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dekko(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dekko(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dekko(textStyle: textTheme.caption),
      button: GoogleFonts.dekko(textStyle: textTheme.button),
      overline: GoogleFonts.dekko(textStyle: textTheme.overline),
    );
  }

  /// Applies the Delius font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius
  static TextStyle delius({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '882839f3551cbef380971b00494ffc16ba5b2f9841166599a0248fa4f6855cae',
        77440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Delius',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Delius font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius
  static TextTheme deliusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.delius(textStyle: textTheme.headline1),
      headline2: GoogleFonts.delius(textStyle: textTheme.headline2),
      headline3: GoogleFonts.delius(textStyle: textTheme.headline3),
      headline4: GoogleFonts.delius(textStyle: textTheme.headline4),
      headline5: GoogleFonts.delius(textStyle: textTheme.headline5),
      headline6: GoogleFonts.delius(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.delius(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.delius(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.delius(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.delius(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.delius(textStyle: textTheme.caption),
      button: GoogleFonts.delius(textStyle: textTheme.button),
      overline: GoogleFonts.delius(textStyle: textTheme.overline),
    );
  }

  /// Applies the Delius Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius+Swash+Caps
  static TextStyle deliusSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8a724c6c792da2cb102b6583bf9f9ed02312ab78bbeeb3c6a6efb9ddb096ae29',
        63004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DeliusSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Delius Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius+Swash+Caps
  static TextTheme deliusSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.deliusSwashCaps(textStyle: textTheme.headline1),
      headline2: GoogleFonts.deliusSwashCaps(textStyle: textTheme.headline2),
      headline3: GoogleFonts.deliusSwashCaps(textStyle: textTheme.headline3),
      headline4: GoogleFonts.deliusSwashCaps(textStyle: textTheme.headline4),
      headline5: GoogleFonts.deliusSwashCaps(textStyle: textTheme.headline5),
      headline6: GoogleFonts.deliusSwashCaps(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.deliusSwashCaps(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.deliusSwashCaps(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.deliusSwashCaps(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.deliusSwashCaps(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.deliusSwashCaps(textStyle: textTheme.caption),
      button: GoogleFonts.deliusSwashCaps(textStyle: textTheme.button),
      overline: GoogleFonts.deliusSwashCaps(textStyle: textTheme.overline),
    );
  }

  /// Applies the Delius Unicase font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius+Unicase
  static TextStyle deliusUnicase({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3bbebd3cb94431156468b1ce457ee032a1f68d964171655b60f5ae2ecf0243cb',
        32856,
      ),
      GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f761b09efebd15e0a91eabc186d565aec75f56f2b04f9cb1ed1f72d91be340ef',
        36072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DeliusUnicase',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Delius Unicase font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius+Unicase
  static TextTheme deliusUnicaseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.deliusUnicase(textStyle: textTheme.headline1),
      headline2: GoogleFonts.deliusUnicase(textStyle: textTheme.headline2),
      headline3: GoogleFonts.deliusUnicase(textStyle: textTheme.headline3),
      headline4: GoogleFonts.deliusUnicase(textStyle: textTheme.headline4),
      headline5: GoogleFonts.deliusUnicase(textStyle: textTheme.headline5),
      headline6: GoogleFonts.deliusUnicase(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.deliusUnicase(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.deliusUnicase(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.deliusUnicase(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.deliusUnicase(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.deliusUnicase(textStyle: textTheme.caption),
      button: GoogleFonts.deliusUnicase(textStyle: textTheme.button),
      overline: GoogleFonts.deliusUnicase(textStyle: textTheme.overline),
    );
  }

  /// Applies the Della Respira font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Della+Respira
  static TextStyle dellaRespira({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62fa46916df65faadfa21dd5608cda99cea245fc2f736046a2118b3a95fa93ff',
        51140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DellaRespira',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Della Respira font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Della+Respira
  static TextTheme dellaRespiraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dellaRespira(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dellaRespira(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dellaRespira(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dellaRespira(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dellaRespira(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dellaRespira(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dellaRespira(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dellaRespira(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dellaRespira(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dellaRespira(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dellaRespira(textStyle: textTheme.caption),
      button: GoogleFonts.dellaRespira(textStyle: textTheme.button),
      overline: GoogleFonts.dellaRespira(textStyle: textTheme.overline),
    );
  }

  /// Applies the Denk One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Denk+One
  static TextStyle denkOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '213821a54136d58fd7013e4aca0f3b0307e9ec564c83ce75d6a9e63bfb6b1714',
        36128,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DenkOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Denk One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Denk+One
  static TextTheme denkOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.denkOne(textStyle: textTheme.headline1),
      headline2: GoogleFonts.denkOne(textStyle: textTheme.headline2),
      headline3: GoogleFonts.denkOne(textStyle: textTheme.headline3),
      headline4: GoogleFonts.denkOne(textStyle: textTheme.headline4),
      headline5: GoogleFonts.denkOne(textStyle: textTheme.headline5),
      headline6: GoogleFonts.denkOne(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.denkOne(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.denkOne(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.denkOne(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.denkOne(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.denkOne(textStyle: textTheme.caption),
      button: GoogleFonts.denkOne(textStyle: textTheme.button),
      overline: GoogleFonts.denkOne(textStyle: textTheme.overline),
    );
  }

  /// Applies the Devonshire font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Devonshire
  static TextStyle devonshire({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c62bc196f0a12683281e3842a99600f4f4755582173bca74502c02f9cf997854',
        67192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Devonshire',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Devonshire font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Devonshire
  static TextTheme devonshireTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.devonshire(textStyle: textTheme.headline1),
      headline2: GoogleFonts.devonshire(textStyle: textTheme.headline2),
      headline3: GoogleFonts.devonshire(textStyle: textTheme.headline3),
      headline4: GoogleFonts.devonshire(textStyle: textTheme.headline4),
      headline5: GoogleFonts.devonshire(textStyle: textTheme.headline5),
      headline6: GoogleFonts.devonshire(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.devonshire(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.devonshire(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.devonshire(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.devonshire(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.devonshire(textStyle: textTheme.caption),
      button: GoogleFonts.devonshire(textStyle: textTheme.button),
      overline: GoogleFonts.devonshire(textStyle: textTheme.overline),
    );
  }

  /// Applies the Dhurjati font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dhurjati
  static TextStyle dhurjati({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee0b382be9acedd63b3e624d49e646e5951cb5e8d54c0724ad01128bd8690012',
        546952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dhurjati',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dhurjati font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dhurjati
  static TextTheme dhurjatiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      headline1: GoogleFonts.dhurjati(textStyle: textTheme.headline1),
      headline2: GoogleFonts.dhurjati(textStyle: textTheme.headline2),
      headline3: GoogleFonts.dhurjati(textStyle: textTheme.headline3),
      headline4: GoogleFonts.dhurjati(textStyle: textTheme.headline4),
      headline5: GoogleFonts.dhurjati(textStyle: textTheme.headline5),
      headline6: GoogleFonts.dhurjati(textStyle: textTheme.headline6),
      subtitle1: GoogleFonts.dhurjati(textStyle: textTheme.subtitle1),
      subtitle2: GoogleFonts.dhurjati(textStyle: textTheme.subtitle2),
      bodyText1: GoogleFonts.dhurjati(textStyle: textTheme.bodyText1),
      bodyText2: GoogleFonts.dhurjati(textStyle: textTheme.bodyText2),
      caption: GoogleFonts.dhurjati(textStyle: textTheme.caption),
      button: GoogleFonts.dhurjati(textStyle: textTheme.button),
      overline: GoogleFonts.dhurjati(textStyle: textTheme.overline),
    );
  }

  /// Applies the Didact Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Didact+Gothic
  static TextStyle didactGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontSt