`source_map_stack_trace` is a package for converting stack traces generated by
dart2js-compiled JavaScript code into readable native Dart stack traces using
source maps. For example:

```dart
import 'package:source_map_stack_trace/source_map_stack_trace.dart';

void main() {
  var jsTrace = // Get a StackTrace generated by dart2js.
  var mapping = // Get a source map mapping the JS to the Dart source.

  // Convert jsTrace to refer to the Dart source instead.
  var dartTrace = mapStackTrace(jsTrace, sourceMap);
  print(dartTrace);
}
```

This can convert the following JavaScript trace:

```
expect_async_test.dart.browser_test.dart.js 2636:15   dart.wrapException
expect_async_test.dart.browser_test.dart.js 14661:15  main__closure16.call$0
expect_async_test.dart.browser_test.dart.js 18237:26  Declarer_test__closure.call$1
expect_async_test.dart.browser_test.dart.js 17905:23  StackZoneSpecification_registerUnaryCallback__closure.call$0
expect_async_test.dart.browser_test.dart.js 17876:16  StackZoneSpecification._stack_zone_specification$_run$2
expect_async_test.dart.browser_test.dart.js 17899:26  StackZoneSpecification_registerUnaryCallback_closure.call$1
expect_async_test.dart.browser_test.dart.js 6115:16   _rootRunUnary
expect_async_test.dart.browser_test.dart.js 8576:39   _CustomZone.runUnary$2
expect_async_test.dart.browser_test.dart.js 7135:57   _Future__propagateToListeners_handleValueCallback.call$0
expect_async_test.dart.browser_test.dart.js 7031:147  dart._Future.static._Future__propagateToListeners
```

to:

```
dart:_internal/compiler/js_lib/js_helper.dart 1210:1          wrapException
test/frontend/expect_async_test.dart 24:5                     main.<fn>.<fn>
package:test/src/backend/declarer.dart 45:48                  Declarer.test.<fn>.<fn>
package:stack_trace/src/stack_zone_specification.dart 134:30  StackZoneSpecification.registerUnaryCallback.<fn>.<fn>
package:stack_trace/src/stack_zone_specification.dart 210:7   StackZoneSpecification._run
package:stack_trace/src/stack_zone_specification.dart 135:5   StackZoneSpecification.registerUnaryCallback.<fn>
dart:async/zone.dart 904:14                                   _rootRunUnary
dart:async/zone.dart 806:3                                    _CustomZone.runUnary
dart:async/future_impl.dart 486:13                            _Future._propagateToListeners.handleValueCallback
dart:async/future_impl.dart 567:32                            _Future._propagateToListeners
```
