// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/step_through_constructor_calls_test.dart
//
const LINE_A = 20;
// AUTOGENERATED END

const file = 'step_through_constructor_calls_test.dart';

void code() {
  final Foo foo1 = Foo(); // LINE_A
  print(foo1.x);
  final Foo foo2 = Foo.named();
  print(foo2.x);
  final Foo foo3 = const Foo();
  print(foo3.x);
  final Foo foo4 = const Foo.named();
  print(foo4.x);
  final Foo foo5 = Foo.named2(1, 2, 3);
  print(foo5.x);
}

class Foo {
  final int x;

  const Foo() : x = 1;

  const Foo.named() : x = 2;

  const Foo.named2(int aaaaaaaa, int bbbbbbbbbb, int ccccccccccccc)
      : x = aaaaaaaa + bbbbbbbbbb + ccccccccccccc;
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:20', // on 'Foo'
  '$file:${LINE_A + 15}:12', // on '(' in 'const Foo() : x = 1;'
  '$file:${LINE_A + 15}:22', // on ';' in same line
  '$file:${LINE_A + 1}:14', // on 'x'
  '$file:${LINE_A + 1}:3', // on print
  '$file:${LINE_A + 2}:24', // on 'named'
  '$file:${LINE_A + 17}:18', // on '(' in 'const Foo.named() : x = 2;'
  '$file:${LINE_A + 17}:28', // on ';' in same line
  '$file:${LINE_A + 3}:14', // on 'x'
  '$file:${LINE_A + 3}:3', // on print
  '$file:${LINE_A + 4}:18', // on '='
  '$file:${LINE_A + 5}:14', // on 'x'
  '$file:${LINE_A + 5}:3', // on print
  '$file:${LINE_A + 6}:18', // on '='
  '$file:${LINE_A + 7}:14', // on 'x'
  '$file:${LINE_A + 7}:3', // on print
  '$file:${LINE_A + 8}:24', // on 'named2'
  '$file:${LINE_A + 19}:54', // on 'ccccccccccccc'
  '$file:${LINE_A + 20}:22', // on first '+'
  '$file:${LINE_A + 20}:35', // on second '+'
  '$file:${LINE_A + 20}:50', // on ';'
  '$file:${LINE_A + 9}:14', // on 'x'
  '$file:${LINE_A + 9}:3', // on print
  '$file:${LINE_A + 10}:1', // on ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepIntoThroughProgramRecordingStops(stops),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_constructor_calls_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
