// GENERATED CODE - DO NOT EDIT

// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'H'.
class PartH {
  /// Applies the Habibi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Habibi
  static TextStyle habibi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ca195eed5fe19c0c1eb401140f8787c17d6a398fce69fa567cfa3e905608a3d',
        32608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Habibi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Habibi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Habibi
  static TextTheme habibiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: habibi(textStyle: textTheme.displayLarge),
      displayMedium: habibi(textStyle: textTheme.displayMedium),
      displaySmall: habibi(textStyle: textTheme.displaySmall),
      headlineLarge: habibi(textStyle: textTheme.headlineLarge),
      headlineMedium: habibi(textStyle: textTheme.headlineMedium),
      headlineSmall: habibi(textStyle: textTheme.headlineSmall),
      titleLarge: habibi(textStyle: textTheme.titleLarge),
      titleMedium: habibi(textStyle: textTheme.titleMedium),
      titleSmall: habibi(textStyle: textTheme.titleSmall),
      bodyLarge: habibi(textStyle: textTheme.bodyLarge),
      bodyMedium: habibi(textStyle: textTheme.bodyMedium),
      bodySmall: habibi(textStyle: textTheme.bodySmall),
      labelLarge: habibi(textStyle: textTheme.labelLarge),
      labelMedium: habibi(textStyle: textTheme.labelMedium),
      labelSmall: habibi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hachi Maru Pop font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hachi+Maru+Pop
  static TextStyle hachiMaruPop({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88bb6ab35c64d4b2c4e4dbff81940660bbfe878d23a0cf06e08904654ea30e4f',
        4374644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HachiMaruPop',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hachi Maru Pop font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hachi+Maru+Pop
  static TextTheme hachiMaruPopTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hachiMaruPop(textStyle: textTheme.displayLarge),
      displayMedium: hachiMaruPop(textStyle: textTheme.displayMedium),
      displaySmall: hachiMaruPop(textStyle: textTheme.displaySmall),
      headlineLarge: hachiMaruPop(textStyle: textTheme.headlineLarge),
      headlineMedium: hachiMaruPop(textStyle: textTheme.headlineMedium),
      headlineSmall: hachiMaruPop(textStyle: textTheme.headlineSmall),
      titleLarge: hachiMaruPop(textStyle: textTheme.titleLarge),
      titleMedium: hachiMaruPop(textStyle: textTheme.titleMedium),
      titleSmall: hachiMaruPop(textStyle: textTheme.titleSmall),
      bodyLarge: hachiMaruPop(textStyle: textTheme.bodyLarge),
      bodyMedium: hachiMaruPop(textStyle: textTheme.bodyMedium),
      bodySmall: hachiMaruPop(textStyle: textTheme.bodySmall),
      labelLarge: hachiMaruPop(textStyle: textTheme.labelLarge),
      labelMedium: hachiMaruPop(textStyle: textTheme.labelMedium),
      labelSmall: hachiMaruPop(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hahmlet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hahmlet
  static TextStyle hahmlet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ded39496e5944f1e9320c24965b4ebc9ae59416c3895c29cfe83c67557e5cde0',
        1467208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3bbfe806f44542aa1688e21cfc7713a304781ef3945bdbdbccfd0051bca3ab19',
        1475716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03803e70296af63f54766b80588d68823af4ab5f7446479aff4d4f6ab49cbc68',
        1479464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bac66078600ad3653a560bf74e8531d417178f7449c7f58f1f1b2974b12d233b',
        1482704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08c43d8a1e79f68afdb0f0b36a1c34a1de2e0cf58dd7ff54eba6fc9997d8dc0f',
        1486344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '752d8f2a1275cf0933e445043e0f94bf6975792c6081bba93fdda4617d7a71ce',
        1487176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63581b852d0cc27df3b95edd4594ef2de18aa5a93f834a1d9d9bab2544885ae9',
        1484424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bdb9f0e62efbf5da556f9f08456e750acbdf37dac8ef9fb1d1673403ad764c68',
        1482276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55d3d3281ea5f9bea317f210784a39deedebc8ccd02af78bb4539479e7e9e71c',
        1478360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Hahmlet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hahmlet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hahmlet
  static TextTheme hahmletTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hahmlet(textStyle: textTheme.displayLarge),
      displayMedium: hahmlet(textStyle: textTheme.displayMedium),
      displaySmall: hahmlet(textStyle: textTheme.displaySmall),
      headlineLarge: hahmlet(textStyle: textTheme.headlineLarge),
      headlineMedium: hahmlet(textStyle: textTheme.headlineMedium),
      headlineSmall: hahmlet(textStyle: textTheme.headlineSmall),
      titleLarge: hahmlet(textStyle: textTheme.titleLarge),
      titleMedium: hahmlet(textStyle: textTheme.titleMedium),
      titleSmall: hahmlet(textStyle: textTheme.titleSmall),
      bodyLarge: hahmlet(textStyle: textTheme.bodyLarge),
      bodyMedium: hahmlet(textStyle: textTheme.bodyMedium),
      bodySmall: hahmlet(textStyle: textTheme.bodySmall),
      labelLarge: hahmlet(textStyle: textTheme.labelLarge),
      labelMedium: hahmlet(textStyle: textTheme.labelMedium),
      labelSmall: hahmlet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Halant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Halant
  static TextStyle halant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0585282b8615ae3fb54b8810763a398c8a09f2d9cfc025f23db5da00f2910aaa',
        158884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83eefa807c0685aef8acd83cd0d7a8330e835779a8b2620b8575d4af6bbd2769',
        158696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0910f22e003b05eb5cb750c3e03e553f0c3e4e9ed2e5673e379d3ab27e25513',
        156496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d21596560886e4a304711974ee214b7bf1541bfd4ba2687b153f33f4a721ee6',
        154528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f665a1d57657cc5c449b943fe73cc1597459a145e912bfff1a10671ac6b6d2f',
        153656,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Halant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Halant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Halant
  static TextTheme halantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: halant(textStyle: textTheme.displayLarge),
      displayMedium: halant(textStyle: textTheme.displayMedium),
      displaySmall: halant(textStyle: textTheme.displaySmall),
      headlineLarge: halant(textStyle: textTheme.headlineLarge),
      headlineMedium: halant(textStyle: textTheme.headlineMedium),
      headlineSmall: halant(textStyle: textTheme.headlineSmall),
      titleLarge: halant(textStyle: textTheme.titleLarge),
      titleMedium: halant(textStyle: textTheme.titleMedium),
      titleSmall: halant(textStyle: textTheme.titleSmall),
      bodyLarge: halant(textStyle: textTheme.bodyLarge),
      bodyMedium: halant(textStyle: textTheme.bodyMedium),
      bodySmall: halant(textStyle: textTheme.bodySmall),
      labelLarge: halant(textStyle: textTheme.labelLarge),
      labelMedium: halant(textStyle: textTheme.labelMedium),
      labelSmall: halant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hammersmith One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hammersmith+One
  static TextStyle hammersmithOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6d3a4ade0759a62ce64c22baba513e7e4e4f53f7db5646a1e01b70d487536bd',
        53680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HammersmithOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hammersmith One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hammersmith+One
  static TextTheme hammersmithOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hammersmithOne(textStyle: textTheme.displayLarge),
      displayMedium: hammersmithOne(textStyle: textTheme.displayMedium),
      displaySmall: hammersmithOne(textStyle: textTheme.displaySmall),
      headlineLarge: hammersmithOne(textStyle: textTheme.headlineLarge),
      headlineMedium: hammersmithOne(textStyle: textTheme.headlineMedium),
      headlineSmall: hammersmithOne(textStyle: textTheme.headlineSmall),
      titleLarge: hammersmithOne(textStyle: textTheme.titleLarge),
      titleMedium: hammersmithOne(textStyle: textTheme.titleMedium),
      titleSmall: hammersmithOne(textStyle: textTheme.titleSmall),
      bodyLarge: hammersmithOne(textStyle: textTheme.bodyLarge),
      bodyMedium: hammersmithOne(textStyle: textTheme.bodyMedium),
      bodySmall: hammersmithOne(textStyle: textTheme.bodySmall),
      labelLarge: hammersmithOne(textStyle: textTheme.labelLarge),
      labelMedium: hammersmithOne(textStyle: textTheme.labelMedium),
      labelSmall: hammersmithOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hanalei font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hanalei
  static TextStyle hanalei({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe5b4ba22786da8107703bf35cbe2320a5a2bbb50001bff3e86651b370772c8b',
        181760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Hanalei',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hanalei font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hanalei
  static TextTheme hanaleiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hanalei(textStyle: textTheme.displayLarge),
      displayMedium: hanalei(textStyle: textTheme.displayMedium),
      displaySmall: hanalei(textStyle: textTheme.displaySmall),
      headlineLarge: hanalei(textStyle: textTheme.headlineLarge),
      headlineMedium: hanalei(textStyle: textTheme.headlineMedium),
      headlineSmall: hanalei(textStyle: textTheme.headlineSmall),
      titleLarge: hanalei(textStyle: textTheme.titleLarge),
      titleMedium: hanalei(textStyle: textTheme.titleMedium),
      titleSmall: hanalei(textStyle: textTheme.titleSmall),
      bodyLarge: hanalei(textStyle: textTheme.bodyLarge),
      bodyMedium: hanalei(textStyle: textTheme.bodyMedium),
      bodySmall: hanalei(textStyle: textTheme.bodySmall),
      labelLarge: hanalei(textStyle: textTheme.labelLarge),
      labelMedium: hanalei(textStyle: textTheme.labelMedium),
      labelSmall: hanalei(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hanalei Fill font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hanalei+Fill
  static TextStyle hanaleiFill({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9599b1f463d94b290dd33d09c7585730cd5964e17ebf3aa8b80034bb1ed7930f',
        89792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HanaleiFill',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hanalei Fill font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hanalei+Fill
  static TextTheme hanaleiFillTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hanaleiFill(textStyle: textTheme.displayLarge),
      displayMedium: hanaleiFill(textStyle: textTheme.displayMedium),
      displaySmall: hanaleiFill(textStyle: textTheme.displaySmall),
      headlineLarge: hanaleiFill(textStyle: textTheme.headlineLarge),
      headlineMedium: hanaleiFill(textStyle: textTheme.headlineMedium),
      headlineSmall: hanaleiFill(textStyle: textTheme.headlineSmall),
      titleLarge: hanaleiFill(textStyle: textTheme.titleLarge),
      titleMedium: hanaleiFill(textStyle: textTheme.titleMedium),
      titleSmall: hanaleiFill(textStyle: textTheme.titleSmall),
      bodyLarge: hanaleiFill(textStyle: textTheme.bodyLarge),
      bodyMedium: hanaleiFill(textStyle: textTheme.bodyMedium),
      bodySmall: hanaleiFill(textStyle: textTheme.bodySmall),
      labelLarge: hanaleiFill(textStyle: textTheme.labelLarge),
      labelMedium: hanaleiFill(textStyle: textTheme.labelMedium),
      labelSmall: hanaleiFill(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Handjet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Handjet
  static TextStyle handjet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac6ec8a5eefe9d8651c8e85dc924e2a765c0d65a845434b8ed86cfb83b099b3c',
        183680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98158733e2b5103202097d44460f5873e9f150c1b75ef8166ffa0977f595cc7c',
        183728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f731c0f438e449e93f25873abb17f338d1ce29ec5cf401a192a127f8ce329c4',
        183688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e4a4ab0b3bf1e77192a5b2a3866ec0750a235629900a13e5680789135a7614e',
        183668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '549f62e380c85b9e13f9628f18069eb683c7f6e4e31db0d5bf743cff22c234fc',
        183696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f4addc945fec0dde0bf54fae19fd20835e49ffca3b964f1a5fdcffde41adad97',
        183744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bf103545efe50872ab315e490a843d5cb562b2da6eedc032e699ebbc16046cc',
        183676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c808b9055ddfd14ae795c8b1f0822478b9efeee185d4823fb356607e645926ff',
        183768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2cfc3787a836cdbb78d1e07f8eafb8ee574441c7a31b446f22a4d6b093cae7b2',
        183736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Handjet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Handjet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Handjet
  static TextTheme handjetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: handjet(textStyle: textTheme.displayLarge),
      displayMedium: handjet(textStyle: textTheme.displayMedium),
      displaySmall: handjet(textStyle: textTheme.displaySmall),
      headlineLarge: handjet(textStyle: textTheme.headlineLarge),
      headlineMedium: handjet(textStyle: textTheme.headlineMedium),
      headlineSmall: handjet(textStyle: textTheme.headlineSmall),
      titleLarge: handjet(textStyle: textTheme.titleLarge),
      titleMedium: handjet(textStyle: textTheme.titleMedium),
      titleSmall: handjet(textStyle: textTheme.titleSmall),
      bodyLarge: handjet(textStyle: textTheme.bodyLarge),
      bodyMedium: handjet(textStyle: textTheme.bodyMedium),
      bodySmall: handjet(textStyle: textTheme.bodySmall),
      labelLarge: handjet(textStyle: textTheme.labelLarge),
      labelMedium: handjet(textStyle: textTheme.labelMedium),
      labelSmall: handjet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Handlee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Handlee
  static TextStyle handlee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e92b00d221f9645dddf0e69149a6981b6a9520417d3a7709a9b1e705b673be86',
        37208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Handlee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Handlee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Handlee
  static TextTheme handleeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: handlee(textStyle: textTheme.displayLarge),
      displayMedium: handlee(textStyle: textTheme.displayMedium),
      displaySmall: handlee(textStyle: textTheme.displaySmall),
      headlineLarge: handlee(textStyle: textTheme.headlineLarge),
      headlineMedium: handlee(textStyle: textTheme.headlineMedium),
      headlineSmall: handlee(textStyle: textTheme.headlineSmall),
      titleLarge: handlee(textStyle: textTheme.titleLarge),
      titleMedium: handlee(textStyle: textTheme.titleMedium),
      titleSmall: handlee(textStyle: textTheme.titleSmall),
      bodyLarge: handlee(textStyle: textTheme.bodyLarge),
      bodyMedium: handlee(textStyle: textTheme.bodyMedium),
      bodySmall: handlee(textStyle: textTheme.bodySmall),
      labelLarge: handlee(textStyle: textTheme.labelLarge),
      labelMedium: handlee(textStyle: textTheme.labelMedium),
      labelSmall: handlee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hanken Grotesk font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hanken+Grotesk
  static TextStyle hankenGrotesk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1fced7321e856c0a34f6286e7a1183791afbf74d51ce2c12b9fb9e47cc5f7b2',
        57172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '919e51fb2c38142a3ce0e78417ee61be928bc28cb684841d2f8fea88440e131d',
        57292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b661d23973453bf569821662082ccf3010adc25cd6117a1ab80754551558c57',
        57196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '956414e58193ccf0e310474863f25057523ad3572d5c9d6ba75ddf77b3babf12',
        57224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6343cd88c58a6c2f1156bbb86882e0c3f04db34be2bc66e7a294ef5c0a55f4f5',
        57216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6dd6e94c87b1cfaac4fb7c3a50827eca02021238e3bb02d7a00bb5a94ea070a2',
        57188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '753c8c35eee400eb1a46e4a46012c1e50a1e3b95fe7668cece45411d7d957b47',
        57120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0be566fab5fdf4b52b257bcb10f7f831e17a74f73df9f420db4592676a5886d3',
        57172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '020dbe20a42686fb0e5029f29045993f33d9f1ca3d8c4c1da5929983e7afc2ef',
        57128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9dfcb470146ac6d2f03562e28d878672bcd60f496c52bf382a6d9d1bee6e3f2b',
        61240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a1f91dc0dd9f5cba2546ba855dbe3fde50b357f02775683cedb4d30f6990eeb8',
        61472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '300061f23ffd318a460a5921ad13f31e8fe0edb7b23bd1dea8146ff035eb9eee',
        61432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '105e474c0919f87433a21b4c787d3b798043fb68b9744a97162d1b3bcf4f3d2d',
        61200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c620056b6ba29eb6e08fff3d0a76700c4daed14a487497dde523f8bf3cc3fee4',
        61432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c1288e51ed612d19a2e91d2873c6041a659323a8cae7e46be1b545dcdce89575',
        61396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '661d98fdeebd42b8ce1d5bbdfbc5f2aec0f15ddc7ea37e0bc4bd40dd024469d9',
        61320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '992f833b45f4209b8dd6f7fcd80c701354c0fc1a021bb0f3876d70f7d12161d1',
        61428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7a2fedbf528321b14b4c5075923c31221b393d115bdd25d943afba434d0ae249',
        61228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HankenGrotesk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hanken Grotesk font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hanken+Grotesk
  static TextTheme hankenGroteskTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hankenGrotesk(textStyle: textTheme.displayLarge),
      displayMedium: hankenGrotesk(textStyle: textTheme.displayMedium),
      displaySmall: hankenGrotesk(textStyle: textTheme.displaySmall),
      headlineLarge: hankenGrotesk(textStyle: textTheme.headlineLarge),
      headlineMedium: hankenGrotesk(textStyle: textTheme.headlineMedium),
      headlineSmall: hankenGrotesk(textStyle: textTheme.headlineSmall),
      titleLarge: hankenGrotesk(textStyle: textTheme.titleLarge),
      titleMedium: hankenGrotesk(textStyle: textTheme.titleMedium),
      titleSmall: hankenGrotesk(textStyle: textTheme.titleSmall),
      bodyLarge: hankenGrotesk(textStyle: textTheme.bodyLarge),
      bodyMedium: hankenGrotesk(textStyle: textTheme.bodyMedium),
      bodySmall: hankenGrotesk(textStyle: textTheme.bodySmall),
      labelLarge: hankenGrotesk(textStyle: textTheme.labelLarge),
      labelMedium: hankenGrotesk(textStyle: textTheme.labelMedium),
      labelSmall: hankenGrotesk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hanuman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hanuman
  static TextStyle hanuman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1327d662a0f22641ef3c007ec379117e4c1d5bf5958fda16b15c5db537f3d92',
        59132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19a238a0980e239b2c588547626be3e429bed2916a55eb2396af6619b52926fc',
        57700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02ce7dd70f68c79bc438d0b9d85dff02274c7107299403423bef3f18a13e3c79',
        63944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a6a6daf0a8e4c2466c8bb9ce44041edc7895ed9756339ea10836e2463bac229',
        57732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2231324f0ef8aa78b5578c12f7550e9cb997eaa4746fea1c312267bd5005edad',
        59124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Hanuman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hanuman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hanuman
  static TextTheme hanumanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hanuman(textStyle: textTheme.displayLarge),
      displayMedium: hanuman(textStyle: textTheme.displayMedium),
      displaySmall: hanuman(textStyle: textTheme.displaySmall),
      headlineLarge: hanuman(textStyle: textTheme.headlineLarge),
      headlineMedium: hanuman(textStyle: textTheme.headlineMedium),
      headlineSmall: hanuman(textStyle: textTheme.headlineSmall),
      titleLarge: hanuman(textStyle: textTheme.titleLarge),
      titleMedium: hanuman(textStyle: textTheme.titleMedium),
      titleSmall: hanuman(textStyle: textTheme.titleSmall),
      bodyLarge: hanuman(textStyle: textTheme.bodyLarge),
      bodyMedium: hanuman(textStyle: textTheme.bodyMedium),
      bodySmall: hanuman(textStyle: textTheme.bodySmall),
      labelLarge: hanuman(textStyle: textTheme.labelLarge),
      labelMedium: hanuman(textStyle: textTheme.labelMedium),
      labelSmall: hanuman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Happy Monkey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Happy+Monkey
  static TextStyle happyMonkey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e44e19c6fb5fc23883e8f89cab56115239b625243ab53cb51b84e7332dbdda7d',
        40080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HappyMonkey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Happy Monkey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Happy+Monkey
  static TextTheme happyMonkeyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: happyMonkey(textStyle: textTheme.displayLarge),
      displayMedium: happyMonkey(textStyle: textTheme.displayMedium),
      displaySmall: happyMonkey(textStyle: textTheme.displaySmall),
      headlineLarge: happyMonkey(textStyle: textTheme.headlineLarge),
      headlineMedium: happyMonkey(textStyle: textTheme.headlineMedium),
      headlineSmall: happyMonkey(textStyle: textTheme.headlineSmall),
      titleLarge: happyMonkey(textStyle: textTheme.titleLarge),
      titleMedium: happyMonkey(textStyle: textTheme.titleMedium),
      titleSmall: happyMonkey(textStyle: textTheme.titleSmall),
      bodyLarge: happyMonkey(textStyle: textTheme.bodyLarge),
      bodyMedium: happyMonkey(textStyle: textTheme.bodyMedium),
      bodySmall: happyMonkey(textStyle: textTheme.bodySmall),
      labelLarge: happyMonkey(textStyle: textTheme.labelLarge),
      labelMedium: happyMonkey(textStyle: textTheme.labelMedium),
      labelSmall: happyMonkey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Harmattan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Harmattan
  static TextStyle harmattan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '584cbaf25726bfc7dc3bb52dfe7dbb9327659ecfc43c811dcf759d22dabdd3bb',
        516984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68ffe6c0fdddd5977843ac524dd798cb170358ba9990de4581dbd070e0d992b8',
        521664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91d4905bb9b0a0466633618f395df782e093cae34860c4702bc716235885a163',
        509416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '99fe5112062deba0435fc6d755f7ec0cea88bdc2c959095bf35f73daca5d520a',
        503324,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Harmattan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Harmattan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Harmattan
  static TextTheme harmattanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: harmattan(textStyle: textTheme.displayLarge),
      displayMedium: harmattan(textStyle: textTheme.displayMedium),
      displaySmall: harmattan(textStyle: textTheme.displaySmall),
      headlineLarge: harmattan(textStyle: textTheme.headlineLarge),
      headlineMedium: harmattan(textStyle: textTheme.headlineMedium),
      headlineSmall: harmattan(textStyle: textTheme.headlineSmall),
      titleLarge: harmattan(textStyle: textTheme.titleLarge),
      titleMedium: harmattan(textStyle: textTheme.titleMedium),
      titleSmall: harmattan(textStyle: textTheme.titleSmall),
      bodyLarge: harmattan(textStyle: textTheme.bodyLarge),
      bodyMedium: harmattan(textStyle: textTheme.bodyMedium),
      bodySmall: harmattan(textStyle: textTheme.bodySmall),
      labelLarge: harmattan(textStyle: textTheme.labelLarge),
      labelMedium: harmattan(textStyle: textTheme.labelMedium),
      labelSmall: harmattan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Headland One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Headland+One
  static TextStyle headlandOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8b9589b5e7dc001f8b63c9485088e6f0d00919103b3e070846121894068ba69',
        69948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HeadlandOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Headland One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Headland+One
  static TextTheme headlandOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: headlandOne(textStyle: textTheme.displayLarge),
      displayMedium: headlandOne(textStyle: textTheme.displayMedium),
      displaySmall: headlandOne(textStyle: textTheme.displaySmall),
      headlineLarge: headlandOne(textStyle: textTheme.headlineLarge),
      headlineMedium: headlandOne(textStyle: textTheme.headlineMedium),
      headlineSmall: headlandOne(textStyle: textTheme.headlineSmall),
      titleLarge: headlandOne(textStyle: textTheme.titleLarge),
      titleMedium: headlandOne(textStyle: textTheme.titleMedium),
      titleSmall: headlandOne(textStyle: textTheme.titleSmall),
      bodyLarge: headlandOne(textStyle: textTheme.bodyLarge),
      bodyMedium: headlandOne(textStyle: textTheme.bodyMedium),
      bodySmall: headlandOne(textStyle: textTheme.bodySmall),
      labelLarge: headlandOne(textStyle: textTheme.labelLarge),
      labelMedium: headlandOne(textStyle: textTheme.labelMedium),
      labelSmall: headlandOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hedvig Letters Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hedvig+Letters+Sans
  static TextStyle hedvigLettersSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9efeea4c480a5b4891e664bbd21779888a6adf5565e2bf998f76d286b5b6c7eb',
        59064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HedvigLettersSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hedvig Letters Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hedvig+Letters+Sans
  static TextTheme hedvigLettersSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hedvigLettersSans(textStyle: textTheme.displayLarge),
      displayMedium: hedvigLettersSans(textStyle: textTheme.displayMedium),
      displaySmall: hedvigLettersSans(textStyle: textTheme.displaySmall),
      headlineLarge: hedvigLettersSans(textStyle: textTheme.headlineLarge),
      headlineMedium: hedvigLettersSans(textStyle: textTheme.headlineMedium),
      headlineSmall: hedvigLettersSans(textStyle: textTheme.headlineSmall),
      titleLarge: hedvigLettersSans(textStyle: textTheme.titleLarge),
      titleMedium: hedvigLettersSans(textStyle: textTheme.titleMedium),
      titleSmall: hedvigLettersSans(textStyle: textTheme.titleSmall),
      bodyLarge: hedvigLettersSans(textStyle: textTheme.bodyLarge),
      bodyMedium: hedvigLettersSans(textStyle: textTheme.bodyMedium),
      bodySmall: hedvigLettersSans(textStyle: textTheme.bodySmall),
      labelLarge: hedvigLettersSans(textStyle: textTheme.labelLarge),
      labelMedium: hedvigLettersSans(textStyle: textTheme.labelMedium),
      labelSmall: hedvigLettersSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hedvig Letters Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hedvig+Letters+Serif
  static TextStyle hedvigLettersSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74f373117ccede21b5a3f943244cebddfa84a015e692c0bf16feed9d045c43db',
        78680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HedvigLettersSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hedvig Letters Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hedvig+Letters+Serif
  static TextTheme hedvigLettersSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hedvigLettersSerif(textStyle: textTheme.displayLarge),
      displayMedium: hedvigLettersSerif(textStyle: textTheme.displayMedium),
      displaySmall: hedvigLettersSerif(textStyle: textTheme.displaySmall),
      headlineLarge: hedvigLettersSerif(textStyle: textTheme.headlineLarge),
      headlineMedium: hedvigLettersSerif(textStyle: textTheme.headlineMedium),
      headlineSmall: hedvigLettersSerif(textStyle: textTheme.headlineSmall),
      titleLarge: hedvigLettersSerif(textStyle: textTheme.titleLarge),
      titleMedium: hedvigLettersSerif(textStyle: textTheme.titleMedium),
      titleSmall: hedvigLettersSerif(textStyle: textTheme.titleSmall),
      bodyLarge: hedvigLettersSerif(textStyle: textTheme.bodyLarge),
      bodyMedium: hedvigLettersSerif(textStyle: textTheme.bodyMedium),
      bodySmall: hedvigLettersSerif(textStyle: textTheme.bodySmall),
      labelLarge: hedvigLettersSerif(textStyle: textTheme.labelLarge),
      labelMedium: hedvigLettersSerif(textStyle: textTheme.labelMedium),
      labelSmall: hedvigLettersSerif(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Heebo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Heebo
  static TextStyle heebo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '850b7aba93ec13be4dc4266bc76eda4061a72a9853e63fcebe5a49eec1a41448',
        43612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e31e3fea8be1e4c94389c8ea67c91649cd94dc07b77e020464042d76871a567',
        43952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fcf359c1cb3ad06ae7e7ce691a0a19a5f88bf2c5f1e904e139de4b28e742dbb1',
        43872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce5bcb350475234d676cdf403a236220232f4bdb091ff8b8108ce825fcb2a989',
        43932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4c93527108bb4bfe8592bf2646937c064e2f7900b0afd7c819541d28dd4c178',
        44120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68259927b6b90a65b49ff56987a6816548d8d22d4ac77c2034ae798907807d15',
        44284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c40dd08dd78a0a124003e6bf7eb25051de5b5a498a48324f578874b827c4dff',
        44280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9d8fefbd49983eb524b23b829f912ce64bc6590f12899a2f598eb3e1029b0a6',
        44504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a814577fdd753451eef45f2554edd33b56c53b2a773f2079b4aba3aadfb5093',
        44604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Heebo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Heebo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Heebo
  static TextTheme heeboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: heebo(textStyle: textTheme.displayLarge),
      displayMedium: heebo(textStyle: textTheme.displayMedium),
      displaySmall: heebo(textStyle: textTheme.displaySmall),
      headlineLarge: heebo(textStyle: textTheme.headlineLarge),
      headlineMedium: heebo(textStyle: textTheme.headlineMedium),
      headlineSmall: heebo(textStyle: textTheme.headlineSmall),
      titleLarge: heebo(textStyle: textTheme.titleLarge),
      titleMedium: heebo(textStyle: textTheme.titleMedium),
      titleSmall: heebo(textStyle: textTheme.titleSmall),
      bodyLarge: heebo(textStyle: textTheme.bodyLarge),
      bodyMedium: heebo(textStyle: textTheme.bodyMedium),
      bodySmall: heebo(textStyle: textTheme.bodySmall),
      labelLarge: heebo(textStyle: textTheme.labelLarge),
      labelMedium: heebo(textStyle: textTheme.labelMedium),
      labelSmall: heebo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Henny Penny font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Henny+Penny
  static TextStyle hennyPenny({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e038f67b77f9975ccafcad8faa7daae1fd472b36b957bd54411e40abcd7f18ee',
        63588,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HennyPenny',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Henny Penny font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Henny+Penny
  static TextTheme hennyPennyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hennyPenny(textStyle: textTheme.displayLarge),
      displayMedium: hennyPenny(textStyle: textTheme.displayMedium),
      displaySmall: hennyPenny(textStyle: textTheme.displaySmall),
      headlineLarge: hennyPenny(textStyle: textTheme.headlineLarge),
      headlineMedium: hennyPenny(textStyle: textTheme.headlineMedium),
      headlineSmall: hennyPenny(textStyle: textTheme.headlineSmall),
      titleLarge: hennyPenny(textStyle: textTheme.titleLarge),
      titleMedium: hennyPenny(textStyle: textTheme.titleMedium),
      titleSmall: hennyPenny(textStyle: textTheme.titleSmall),
      bodyLarge: hennyPenny(textStyle: textTheme.bodyLarge),
      bodyMedium: hennyPenny(textStyle: textTheme.bodyMedium),
      bodySmall: hennyPenny(textStyle: textTheme.bodySmall),
      labelLarge: hennyPenny(textStyle: textTheme.labelLarge),
      labelMedium: hennyPenny(textStyle: textTheme.labelMedium),
      labelSmall: hennyPenny(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hepta Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hepta+Slab
  static TextStyle heptaSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e785c3a2ec8717ca2bfd50ed04198d534e4b9ff0497076a52a05f4e185ce9c33',
        113036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94960ec8f8b8685077e551b9fad2b0e5994ca6f248f11ff9922de4fe5a1e212a',
        113244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd5fe61dc88a071b181824f61086ba0974b258e52963152463409012ec79b5a0e',
        113596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81c5cb0e70a622c6277fc6a128b5ca380844d2180c06055005c3548701e6b495',
        113432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3752f3b19489549ea20c53bf36647ba6fcfdc802e301a5808a22da41d458e987',
        113424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef5db58236d9f3ca0fea3db89c3b5af59e9bcf987ce835ba5f10856707154e2b',
        115288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f767042a401d77d078c279a4e66444b7eb4dc3070a908e237f03d2644d2a5756',
        116320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8e7bd3922f27b4cdc03bab2876b06eae859d5bcd882494c18928f247dd5dafbc',
        116924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a39ea077026e441de319bb67c9176d2f30899873cbc25f8baa1ada6abd936c14',
        116760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HeptaSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hepta Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hepta+Slab
  static TextTheme heptaSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: heptaSlab(textStyle: textTheme.displayLarge),
      displayMedium: heptaSlab(textStyle: textTheme.displayMedium),
      displaySmall: heptaSlab(textStyle: textTheme.displaySmall),
      headlineLarge: heptaSlab(textStyle: textTheme.headlineLarge),
      headlineMedium: heptaSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: heptaSlab(textStyle: textTheme.headlineSmall),
      titleLarge: heptaSlab(textStyle: textTheme.titleLarge),
      titleMedium: heptaSlab(textStyle: textTheme.titleMedium),
      titleSmall: heptaSlab(textStyle: textTheme.titleSmall),
      bodyLarge: heptaSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: heptaSlab(textStyle: textTheme.bodyMedium),
      bodySmall: heptaSlab(textStyle: textTheme.bodySmall),
      labelLarge: heptaSlab(textStyle: textTheme.labelLarge),
      labelMedium: heptaSlab(textStyle: textTheme.labelMedium),
      labelSmall: heptaSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Herr Von Muellerhoff font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Herr+Von+Muellerhoff
  static TextStyle herrVonMuellerhoff({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b20ecd358f5cc5d290c38fee999f95431b137f38566a36b07514113a41c4078a',
        44664,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HerrVonMuellerhoff',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Herr Von Muellerhoff font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Herr+Von+Muellerhoff
  static TextTheme herrVonMuellerhoffTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: herrVonMuellerhoff(textStyle: textTheme.displayLarge),
      displayMedium: herrVonMuellerhoff(textStyle: textTheme.displayMedium),
      displaySmall: herrVonMuellerhoff(textStyle: textTheme.displaySmall),
      headlineLarge: herrVonMuellerhoff(textStyle: textTheme.headlineLarge),
      headlineMedium: herrVonMuellerhoff(textStyle: textTheme.headlineMedium),
      headlineSmall: herrVonMuellerhoff(textStyle: textTheme.headlineSmall),
      titleLarge: herrVonMuellerhoff(textStyle: textTheme.titleLarge),
      titleMedium: herrVonMuellerhoff(textStyle: textTheme.titleMedium),
      titleSmall: herrVonMuellerhoff(textStyle: textTheme.titleSmall),
      bodyLarge: herrVonMuellerhoff(textStyle: textTheme.bodyLarge),
      bodyMedium: herrVonMuellerhoff(textStyle: textTheme.bodyMedium),
      bodySmall: herrVonMuellerhoff(textStyle: textTheme.bodySmall),
      labelLarge: herrVonMuellerhoff(textStyle: textTheme.labelLarge),
      labelMedium: herrVonMuellerhoff(textStyle: textTheme.labelMedium),
      labelSmall: herrVonMuellerhoff(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hi Melody font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hi+Melody
  static TextStyle hiMelody({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6891c347248878bf2dfe4c0b2f35ead9c30c847376ae900796818c6811b57dd8',
        6090828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HiMelody',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hi Melody font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hi+Melody
  static TextTheme hiMelodyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hiMelody(textStyle: textTheme.displayLarge),
      displayMedium: hiMelody(textStyle: textTheme.displayMedium),
      displaySmall: hiMelody(textStyle: textTheme.displaySmall),
      headlineLarge: hiMelody(textStyle: textTheme.headlineLarge),
      headlineMedium: hiMelody(textStyle: textTheme.headlineMedium),
      headlineSmall: hiMelody(textStyle: textTheme.headlineSmall),
      titleLarge: hiMelody(textStyle: textTheme.titleLarge),
      titleMedium: hiMelody(textStyle: textTheme.titleMedium),
      titleSmall: hiMelody(textStyle: textTheme.titleSmall),
      bodyLarge: hiMelody(textStyle: textTheme.bodyLarge),
      bodyMedium: hiMelody(textStyle: textTheme.bodyMedium),
      bodySmall: hiMelody(textStyle: textTheme.bodySmall),
      labelLarge: hiMelody(textStyle: textTheme.labelLarge),
      labelMedium: hiMelody(textStyle: textTheme.labelMedium),
      labelSmall: hiMelody(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hina Mincho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hina+Mincho
  static TextStyle hinaMincho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3cabe7eda9f23f5a7f611bd9cd2f86fc7d49bd4b74da688609142556c889898',
        6420156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HinaMincho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hina Mincho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hina+Mincho
  static TextTheme hinaMinchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hinaMincho(textStyle: textTheme.displayLarge),
      displayMedium: hinaMincho(textStyle: textTheme.displayMedium),
      displaySmall: hinaMincho(textStyle: textTheme.displaySmall),
      headlineLarge: hinaMincho(textStyle: textTheme.headlineLarge),
      headlineMedium: hinaMincho(textStyle: textTheme.headlineMedium),
      headlineSmall: hinaMincho(textStyle: textTheme.headlineSmall),
      titleLarge: hinaMincho(textStyle: textTheme.titleLarge),
      titleMedium: hinaMincho(textStyle: textTheme.titleMedium),
      titleSmall: hinaMincho(textStyle: textTheme.titleSmall),
      bodyLarge: hinaMincho(textStyle: textTheme.bodyLarge),
      bodyMedium: hinaMincho(textStyle: textTheme.bodyMedium),
      bodySmall: hinaMincho(textStyle: textTheme.bodySmall),
      labelLarge: hinaMincho(textStyle: textTheme.labelLarge),
      labelMedium: hinaMincho(textStyle: textTheme.labelMedium),
      labelSmall: hinaMincho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hind font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind
  static TextStyle hind({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad2ef8c5fee0930d2c41b1346b95b1281751dcf213774e1e73eca7adea7e508f',
        147696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5be3910338bc3a5bb056114aadca147194e2957f954a644e8af675b9f05c8784',
        147420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab8ab1f1a4b50e1557807565b876b9d7031c33cf209ab721e2d12ccadf791b20',
        146972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c42820eeeb9de4dc30e714c3ba7812343d39427de4c784c642166cfc08f5e5c',
        146712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9a71515b4079e1e59f1d00f608bc1f26e2b4f184526f302d843c2f590d363a9',
        145036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Hind',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hind font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind
  static TextTheme hindTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hind(textStyle: textTheme.displayLarge),
      displayMedium: hind(textStyle: textTheme.displayMedium),
      displaySmall: hind(textStyle: textTheme.displaySmall),
      headlineLarge: hind(textStyle: textTheme.headlineLarge),
      headlineMedium: hind(textStyle: textTheme.headlineMedium),
      headlineSmall: hind(textStyle: textTheme.headlineSmall),
      titleLarge: hind(textStyle: textTheme.titleLarge),
      titleMedium: hind(textStyle: textTheme.titleMedium),
      titleSmall: hind(textStyle: textTheme.titleSmall),
      bodyLarge: hind(textStyle: textTheme.bodyLarge),
      bodyMedium: hind(textStyle: textTheme.bodyMedium),
      bodySmall: hind(textStyle: textTheme.bodySmall),
      labelLarge: hind(textStyle: textTheme.labelLarge),
      labelMedium: hind(textStyle: textTheme.labelMedium),
      labelSmall: hind(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hind Guntur font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind+Guntur
  static TextStyle hindGuntur({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e95ddac13eeda0894f7986322a4cd3d154c7aa432883ea4aea5756c5b4cdd7c',
        171180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b7c4594d1cc591c3230bb743030afca5f66479f028383a2bbc3d6bc06c80866',
        170304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4eaf264647797ce1d64195b07427771d79bcf0f60d52e9ace39c6826492ebc69',
        169188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e4090306b7d88abdea21e0a2d80a45507039b118291cae21d7c0ab2052c847c',
        167984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00fd79c8530e201d99f14503a199d5831f18dcea3951a09ffe420d956858d027',
        167744,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HindGuntur',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hind Guntur font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind+Guntur
  static TextTheme hindGunturTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hindGuntur(textStyle: textTheme.displayLarge),
      displayMedium: hindGuntur(textStyle: textTheme.displayMedium),
      displaySmall: hindGuntur(textStyle: textTheme.displaySmall),
      headlineLarge: hindGuntur(textStyle: textTheme.headlineLarge),
      headlineMedium: hindGuntur(textStyle: textTheme.headlineMedium),
      headlineSmall: hindGuntur(textStyle: textTheme.headlineSmall),
      titleLarge: hindGuntur(textStyle: textTheme.titleLarge),
      titleMedium: hindGuntur(textStyle: textTheme.titleMedium),
      titleSmall: hindGuntur(textStyle: textTheme.titleSmall),
      bodyLarge: hindGuntur(textStyle: textTheme.bodyLarge),
      bodyMedium: hindGuntur(textStyle: textTheme.bodyMedium),
      bodySmall: hindGuntur(textStyle: textTheme.bodySmall),
      labelLarge: hindGuntur(textStyle: textTheme.labelLarge),
      labelMedium: hindGuntur(textStyle: textTheme.labelMedium),
      labelSmall: hindGuntur(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hind Madurai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind+Madurai
  static TextStyle hindMadurai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e81161f110686c182299db92912c5765d21517c78bb2e4d885f5394815b4b92a',
        66304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f9cd63d39f0472812f1d17ff8f0f486ee1a597dcdbfb734089baea8b71800af',
        65768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '633ba879b3f5ca770ad1afa7b3beb2790c342d75c9ca39b24c257d15660dab2d',
        66032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d1db271dd035c0a36c1f7f9c5c7bbd704c1a4d85042504988eddd3221dd3633',
        66012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14113b561bd4e81e8394ae023786bde3dc67fc8f5486e8845a3b3b6a24aed3ac',
        65076,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HindMadurai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hind Madurai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind+Madurai
  static TextTheme hindMaduraiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hindMadurai(textStyle: textTheme.displayLarge),
      displayMedium: hindMadurai(textStyle: textTheme.displayMedium),
      displaySmall: hindMadurai(textStyle: textTheme.displaySmall),
      headlineLarge: hindMadurai(textStyle: textTheme.headlineLarge),
      headlineMedium: hindMadurai(textStyle: textTheme.headlineMedium),
      headlineSmall: hindMadurai(textStyle: textTheme.headlineSmall),
      titleLarge: hindMadurai(textStyle: textTheme.titleLarge),
      titleMedium: hindMadurai(textStyle: textTheme.titleMedium),
      titleSmall: hindMadurai(textStyle: textTheme.titleSmall),
      bodyLarge: hindMadurai(textStyle: textTheme.bodyLarge),
      bodyMedium: hindMadurai(textStyle: textTheme.bodyMedium),
      bodySmall: hindMadurai(textStyle: textTheme.bodySmall),
      labelLarge: hindMadurai(textStyle: textTheme.labelLarge),
      labelMedium: hindMadurai(textStyle: textTheme.labelMedium),
      labelSmall: hindMadurai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hind Siliguri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind+Siliguri
  static TextStyle hindSiliguri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac2af2fd8e32fd091bc8f2e3cf0113aeea8a72cc54354915f356eb8025507fb2',
        133748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '012db6e7ad96f71aa3a1cdce8a758e3ca62bd3a237f0f760a0b902ddc1a088b2',
        133156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '729addf0cd65de0129d36f3c9edbede23ccee489c418e824670bb3bd03400bf0',
        132748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c4c9930cb4a900a0540d17dd4729fe788ce13bedaf76915a7fba7c5843b5527',
        132772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '835e69d751f326ed78a192441fa6a0ed9a6e1e880339669fbeef36a10f59d974',
        131216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HindSiliguri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hind Siliguri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind+Siliguri
  static TextTheme hindSiliguriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hindSiliguri(textStyle: textTheme.displayLarge),
      displayMedium: hindSiliguri(textStyle: textTheme.displayMedium),
      displaySmall: hindSiliguri(textStyle: textTheme.displaySmall),
      headlineLarge: hindSiliguri(textStyle: textTheme.headlineLarge),
      headlineMedium: hindSiliguri(textStyle: textTheme.headlineMedium),
      headlineSmall: hindSiliguri(textStyle: textTheme.headlineSmall),
      titleLarge: hindSiliguri(textStyle: textTheme.titleLarge),
      titleMedium: hindSiliguri(textStyle: textTheme.titleMedium),
      titleSmall: hindSiliguri(textStyle: textTheme.titleSmall),
      bodyLarge: hindSiliguri(textStyle: textTheme.bodyLarge),
      bodyMedium: hindSiliguri(textStyle: textTheme.bodyMedium),
      bodySmall: hindSiliguri(textStyle: textTheme.bodySmall),
      labelLarge: hindSiliguri(textStyle: textTheme.labelLarge),
      labelMedium: hindSiliguri(textStyle: textTheme.labelMedium),
      labelSmall: hindSiliguri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hind Vadodara font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind+Vadodara
  static TextStyle hindVadodara({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2825236d0b694650c59e4ac7c147575255d93ef4b9678d0949c0f426e1606c7',
        129084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86e9bd456f90de75a16b93451071315f307310819da7a6427596eb1a209efe80',
        128784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03be3a08a80606054f8bfbda8305724f083b35c87b13d0d5d8cfcebfd80e51d6',
        128576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '220cae1c140df26e9d8acb715fef9b92ecf0f0ca7374923bf23760d45b8f4216',
        128044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1155a5dfdcba1dd4f07248479326f6ada40b98314ba9773c07f851aefe7750d2',
        126752,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HindVadodara',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hind Vadodara font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hind+Vadodara
  static TextTheme hindVadodaraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hindVadodara(textStyle: textTheme.displayLarge),
      displayMedium: hindVadodara(textStyle: textTheme.displayMedium),
      displaySmall: hindVadodara(textStyle: textTheme.displaySmall),
      headlineLarge: hindVadodara(textStyle: textTheme.headlineLarge),
      headlineMedium: hindVadodara(textStyle: textTheme.headlineMedium),
      headlineSmall: hindVadodara(textStyle: textTheme.headlineSmall),
      titleLarge: hindVadodara(textStyle: textTheme.titleLarge),
      titleMedium: hindVadodara(textStyle: textTheme.titleMedium),
      titleSmall: hindVadodara(textStyle: textTheme.titleSmall),
      bodyLarge: hindVadodara(textStyle: textTheme.bodyLarge),
      bodyMedium: hindVadodara(textStyle: textTheme.bodyMedium),
      bodySmall: hindVadodara(textStyle: textTheme.bodySmall),
      labelLarge: hindVadodara(textStyle: textTheme.labelLarge),
      labelMedium: hindVadodara(textStyle: textTheme.labelMedium),
      labelSmall: hindVadodara(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Holtwood One SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Holtwood+One+SC
  static TextStyle holtwoodOneSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2ad9261f3908bcd3c5d2e892fbce71fac9ce0ac88f2c2f33e7044ecc93388b1',
        37320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HoltwoodOneSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Holtwood One SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Holtwood+One+SC
  static TextTheme holtwoodOneScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: holtwoodOneSc(textStyle: textTheme.displayLarge),
      displayMedium: holtwoodOneSc(textStyle: textTheme.displayMedium),
      displaySmall: holtwoodOneSc(textStyle: textTheme.displaySmall),
      headlineLarge: holtwoodOneSc(textStyle: textTheme.headlineLarge),
      headlineMedium: holtwoodOneSc(textStyle: textTheme.headlineMedium),
      headlineSmall: holtwoodOneSc(textStyle: textTheme.headlineSmall),
      titleLarge: holtwoodOneSc(textStyle: textTheme.titleLarge),
      titleMedium: holtwoodOneSc(textStyle: textTheme.titleMedium),
      titleSmall: holtwoodOneSc(textStyle: textTheme.titleSmall),
      bodyLarge: holtwoodOneSc(textStyle: textTheme.bodyLarge),
      bodyMedium: holtwoodOneSc(textStyle: textTheme.bodyMedium),
      bodySmall: holtwoodOneSc(textStyle: textTheme.bodySmall),
      labelLarge: holtwoodOneSc(textStyle: textTheme.labelLarge),
      labelMedium: holtwoodOneSc(textStyle: textTheme.labelMedium),
      labelSmall: holtwoodOneSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Homemade Apple font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Homemade+Apple
  static TextStyle homemadeApple({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a2e9b2e6390fd42b70f39e4bddcb2ae8ba3a8ea361821350fc8550ae24c303e',
        108288,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'HomemadeApple',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Homemade Apple font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Homemade+Apple
  static TextTheme homemadeAppleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: homemadeApple(textStyle: textTheme.displayLarge),
      displayMedium: homemadeApple(textStyle: textTheme.displayMedium),
      displaySmall: homemadeApple(textStyle: textTheme.displaySmall),
      headlineLarge: homemadeApple(textStyle: textTheme.headlineLarge),
      headlineMedium: homemadeApple(textStyle: textTheme.headlineMedium),
      headlineSmall: homemadeApple(textStyle: textTheme.headlineSmall),
      titleLarge: homemadeApple(textStyle: textTheme.titleLarge),
      titleMedium: homemadeApple(textStyle: textTheme.titleMedium),
      titleSmall: homemadeApple(textStyle: textTheme.titleSmall),
      bodyLarge: homemadeApple(textStyle: textTheme.bodyLarge),
      bodyMedium: homemadeApple(textStyle: textTheme.bodyMedium),
      bodySmall: homemadeApple(textStyle: textTheme.bodySmall),
      labelLarge: homemadeApple(textStyle: textTheme.labelLarge),
      labelMedium: homemadeApple(textStyle: textTheme.labelMedium),
      labelSmall: homemadeApple(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Homenaje font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Homenaje
  static TextStyle homenaje({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a7433ce6a50e6e031f0078cb4e0600ebc89918875c3c667906335c4c7e5b261',
        19356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Homenaje',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Homenaje font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Homenaje
  static TextTheme homenajeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: homenaje(textStyle: textTheme.displayLarge),
      displayMedium: homenaje(textStyle: textTheme.displayMedium),
      displaySmall: homenaje(textStyle: textTheme.displaySmall),
      headlineLarge: homenaje(textStyle: textTheme.headlineLarge),
      headlineMedium: homenaje(textStyle: textTheme.headlineMedium),
      headlineSmall: homenaje(textStyle: textTheme.headlineSmall),
      titleLarge: homenaje(textStyle: textTheme.titleLarge),
      titleMedium: homenaje(textStyle: textTheme.titleMedium),
      titleSmall: homenaje(textStyle: textTheme.titleSmall),
      bodyLarge: homenaje(textStyle: textTheme.bodyLarge),
      bodyMedium: homenaje(textStyle: textTheme.bodyMedium),
      bodySmall: homenaje(textStyle: textTheme.bodySmall),
      labelLarge: homenaje(textStyle: textTheme.labelLarge),
      labelMedium: homenaje(textStyle: textTheme.labelMedium),
      labelSmall: homenaje(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Honk font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Honk
  static TextStyle honk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7870386f44708c6870cd06494db0cae2c656b18348aaeddfc7737eac1bbc815',
        341532,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Honk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Honk font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Honk
  static TextTheme honkTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: honk(textStyle: textTheme.displayLarge),
      displayMedium: honk(textStyle: textTheme.displayMedium),
      displaySmall: honk(textStyle: textTheme.displaySmall),
      headlineLarge: honk(textStyle: textTheme.headlineLarge),
      headlineMedium: honk(textStyle: textTheme.headlineMedium),
      headlineSmall: honk(textStyle: textTheme.headlineSmall),
      titleLarge: honk(textStyle: textTheme.titleLarge),
      titleMedium: honk(textStyle: textTheme.titleMedium),
      titleSmall: honk(textStyle: textTheme.titleSmall),
      bodyLarge: honk(textStyle: textTheme.bodyLarge),
      bodyMedium: honk(textStyle: textTheme.bodyMedium),
      bodySmall: honk(textStyle: textTheme.bodySmall),
      labelLarge: honk(textStyle: textTheme.labelLarge),
      labelMedium: honk(textStyle: textTheme.labelMedium),
      labelSmall: honk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hubballi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hubballi
  static TextStyle hubballi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a4f2e40aef8273c8a778375127b8979ccf2e6737c06db7c9440b61f93905329',
        133796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Hubballi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hubballi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hubballi
  static TextTheme hubballiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hubballi(textStyle: textTheme.displayLarge),
      displayMedium: hubballi(textStyle: textTheme.displayMedium),
      displaySmall: hubballi(textStyle: textTheme.displaySmall),
      headlineLarge: hubballi(textStyle: textTheme.headlineLarge),
      headlineMedium: hubballi(textStyle: textTheme.headlineMedium),
      headlineSmall: hubballi(textStyle: textTheme.headlineSmall),
      titleLarge: hubballi(textStyle: textTheme.titleLarge),
      titleMedium: hubballi(textStyle: textTheme.titleMedium),
      titleSmall: hubballi(textStyle: textTheme.titleSmall),
      bodyLarge: hubballi(textStyle: textTheme.bodyLarge),
      bodyMedium: hubballi(textStyle: textTheme.bodyMedium),
      bodySmall: hubballi(textStyle: textTheme.bodySmall),
      labelLarge: hubballi(textStyle: textTheme.labelLarge),
      labelMedium: hubballi(textStyle: textTheme.labelMedium),
      labelSmall: hubballi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Hurricane font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hurricane
  static TextStyle hurricane({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e938f4954a5cfaa79d76f337639665467e71fe88b5c351092b12087e3264dfc1',
        123112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Hurricane',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Hurricane font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Hurricane
  static TextTheme hurricaneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: hurricane(textStyle: textTheme.displayLarge),
      displayMedium: hurricane(textStyle: textTheme.displayMedium),
      displaySmall: hurricane(textStyle: textTheme.displaySmall),
      headlineLarge: hurricane(textStyle: textTheme.headlineLarge),
      headlineMedium: hurricane(textStyle: textTheme.headlineMedium),
      headlineSmall: hurricane(textStyle: textTheme.headlineSmall),
      titleLarge: hurricane(textStyle: textTheme.titleLarge),
      titleMedium: hurricane(textStyle: textTheme.titleMedium),
      titleSmall: hurricane(textStyle: textTheme.titleSmall),
      bodyLarge: hurricane(textStyle: textTheme.bodyLarge),
      bodyMedium: hurricane(textStyle: textTheme.bodyMedium),
      bodySmall: hurricane(textStyle: textTheme.bodySmall),
      labelLarge: hurricane(textStyle: textTheme.labelLarge),
      labelMedium: hurricane(textStyle: textTheme.labelMedium),
      labelSmall: hurricane(textStyle: textTheme.labelSmall),
    );
  }
}
