// GENERATED CODE - DO NOT EDIT

// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'T'.
class PartT {
  /// Applies the Tac One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tac+One
  static TextStyle tacOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7aa586ffeaa8475c3d3554a697a8b8bbe7e764ae2523277bb1392bd2ac802bb5',
        102404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TacOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tac One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tac+One
  static TextTheme tacOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tacOne(textStyle: textTheme.displayLarge),
      displayMedium: tacOne(textStyle: textTheme.displayMedium),
      displaySmall: tacOne(textStyle: textTheme.displaySmall),
      headlineLarge: tacOne(textStyle: textTheme.headlineLarge),
      headlineMedium: tacOne(textStyle: textTheme.headlineMedium),
      headlineSmall: tacOne(textStyle: textTheme.headlineSmall),
      titleLarge: tacOne(textStyle: textTheme.titleLarge),
      titleMedium: tacOne(textStyle: textTheme.titleMedium),
      titleSmall: tacOne(textStyle: textTheme.titleSmall),
      bodyLarge: tacOne(textStyle: textTheme.bodyLarge),
      bodyMedium: tacOne(textStyle: textTheme.bodyMedium),
      bodySmall: tacOne(textStyle: textTheme.bodySmall),
      labelLarge: tacOne(textStyle: textTheme.labelLarge),
      labelMedium: tacOne(textStyle: textTheme.labelMedium),
      labelSmall: tacOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tai Heritage Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tai+Heritage+Pro
  static TextStyle taiHeritagePro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c4cb28ee1f62d20533dda12607c7f5eddf2df77696704b2adcad40d7d76e1b95',
        106972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9a0873f28d7f3ff6d3423fe46b929e89a2d736d5fcf5541b594d49680fa9e5a',
        103692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TaiHeritagePro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tai Heritage Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tai+Heritage+Pro
  static TextTheme taiHeritageProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: taiHeritagePro(textStyle: textTheme.displayLarge),
      displayMedium: taiHeritagePro(textStyle: textTheme.displayMedium),
      displaySmall: taiHeritagePro(textStyle: textTheme.displaySmall),
      headlineLarge: taiHeritagePro(textStyle: textTheme.headlineLarge),
      headlineMedium: taiHeritagePro(textStyle: textTheme.headlineMedium),
      headlineSmall: taiHeritagePro(textStyle: textTheme.headlineSmall),
      titleLarge: taiHeritagePro(textStyle: textTheme.titleLarge),
      titleMedium: taiHeritagePro(textStyle: textTheme.titleMedium),
      titleSmall: taiHeritagePro(textStyle: textTheme.titleSmall),
      bodyLarge: taiHeritagePro(textStyle: textTheme.bodyLarge),
      bodyMedium: taiHeritagePro(textStyle: textTheme.bodyMedium),
      bodySmall: taiHeritagePro(textStyle: textTheme.bodySmall),
      labelLarge: taiHeritagePro(textStyle: textTheme.labelLarge),
      labelMedium: taiHeritagePro(textStyle: textTheme.labelMedium),
      labelSmall: taiHeritagePro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tajawal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tajawal
  static TextStyle tajawal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d7f723168513d81f59a1499ecf308578b59e77e6352b416ab5c8bc87c7891bd',
        51368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a696e9a0a4864794db9ebca8d28075143ab4d7a64320f0509683e649edc5bb05',
        56216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eddd8791604c4f2b6d5cf01b9a50e1259fe9bd4f2db37e58f3f197a67de4d08c',
        55044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'decd29a8bbbb3f40ba753413d3c76993f0b74a7e71de4b56991c6556037785dc',
        56256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8ef3bfb6783a3609db9bf5b3da46388819ba20c4f94d08fcbba0aabd74b1179',
        55492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '143897c5ad37d074cd75d336ee13d04e52020e1652d10eabe663ff704a4f1617',
        55216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ba0894d1ad1143701d2ea8b40af86c2da1615804a2820d080b485873a5b8857',
        54644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tajawal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tajawal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tajawal
  static TextTheme tajawalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tajawal(textStyle: textTheme.displayLarge),
      displayMedium: tajawal(textStyle: textTheme.displayMedium),
      displaySmall: tajawal(textStyle: textTheme.displaySmall),
      headlineLarge: tajawal(textStyle: textTheme.headlineLarge),
      headlineMedium: tajawal(textStyle: textTheme.headlineMedium),
      headlineSmall: tajawal(textStyle: textTheme.headlineSmall),
      titleLarge: tajawal(textStyle: textTheme.titleLarge),
      titleMedium: tajawal(textStyle: textTheme.titleMedium),
      titleSmall: tajawal(textStyle: textTheme.titleSmall),
      bodyLarge: tajawal(textStyle: textTheme.bodyLarge),
      bodyMedium: tajawal(textStyle: textTheme.bodyMedium),
      bodySmall: tajawal(textStyle: textTheme.bodySmall),
      labelLarge: tajawal(textStyle: textTheme.labelLarge),
      labelMedium: tajawal(textStyle: textTheme.labelMedium),
      labelSmall: tajawal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tangerine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tangerine
  static TextStyle tangerine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a3626f76f155e7e69250a64efb24a12a43745fd229898a9400f1b23421feb0f',
        38832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93f92f8d2b9ef4f2e186003fbae8ae8682a8a7c5006428de453595e1f0143d93',
        38720,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tangerine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tangerine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tangerine
  static TextTheme tangerineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tangerine(textStyle: textTheme.displayLarge),
      displayMedium: tangerine(textStyle: textTheme.displayMedium),
      displaySmall: tangerine(textStyle: textTheme.displaySmall),
      headlineLarge: tangerine(textStyle: textTheme.headlineLarge),
      headlineMedium: tangerine(textStyle: textTheme.headlineMedium),
      headlineSmall: tangerine(textStyle: textTheme.headlineSmall),
      titleLarge: tangerine(textStyle: textTheme.titleLarge),
      titleMedium: tangerine(textStyle: textTheme.titleMedium),
      titleSmall: tangerine(textStyle: textTheme.titleSmall),
      bodyLarge: tangerine(textStyle: textTheme.bodyLarge),
      bodyMedium: tangerine(textStyle: textTheme.bodyMedium),
      bodySmall: tangerine(textStyle: textTheme.bodySmall),
      labelLarge: tangerine(textStyle: textTheme.labelLarge),
      labelMedium: tangerine(textStyle: textTheme.labelMedium),
      labelSmall: tangerine(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tapestry font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tapestry
  static TextStyle tapestry({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8465d7b946da28547cf9ae0c7fd550ec8cafe1929011e877819426f39c43f5a',
        93304,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tapestry',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tapestry font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tapestry
  static TextTheme tapestryTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tapestry(textStyle: textTheme.displayLarge),
      displayMedium: tapestry(textStyle: textTheme.displayMedium),
      displaySmall: tapestry(textStyle: textTheme.displaySmall),
      headlineLarge: tapestry(textStyle: textTheme.headlineLarge),
      headlineMedium: tapestry(textStyle: textTheme.headlineMedium),
      headlineSmall: tapestry(textStyle: textTheme.headlineSmall),
      titleLarge: tapestry(textStyle: textTheme.titleLarge),
      titleMedium: tapestry(textStyle: textTheme.titleMedium),
      titleSmall: tapestry(textStyle: textTheme.titleSmall),
      bodyLarge: tapestry(textStyle: textTheme.bodyLarge),
      bodyMedium: tapestry(textStyle: textTheme.bodyMedium),
      bodySmall: tapestry(textStyle: textTheme.bodySmall),
      labelLarge: tapestry(textStyle: textTheme.labelLarge),
      labelMedium: tapestry(textStyle: textTheme.labelMedium),
      labelSmall: tapestry(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Taprom font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Taprom
  static TextStyle taprom({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7669af092c80eddc5def893028e28acc2a3b9d110d9b7b4ba7dff16180e09a9b',
        152892,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Taprom',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Taprom font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Taprom
  static TextTheme tapromTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: taprom(textStyle: textTheme.displayLarge),
      displayMedium: taprom(textStyle: textTheme.displayMedium),
      displaySmall: taprom(textStyle: textTheme.displaySmall),
      headlineLarge: taprom(textStyle: textTheme.headlineLarge),
      headlineMedium: taprom(textStyle: textTheme.headlineMedium),
      headlineSmall: taprom(textStyle: textTheme.headlineSmall),
      titleLarge: taprom(textStyle: textTheme.titleLarge),
      titleMedium: taprom(textStyle: textTheme.titleMedium),
      titleSmall: taprom(textStyle: textTheme.titleSmall),
      bodyLarge: taprom(textStyle: textTheme.bodyLarge),
      bodyMedium: taprom(textStyle: textTheme.bodyMedium),
      bodySmall: taprom(textStyle: textTheme.bodySmall),
      labelLarge: taprom(textStyle: textTheme.labelLarge),
      labelMedium: taprom(textStyle: textTheme.labelMedium),
      labelSmall: taprom(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tauri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tauri
  static TextStyle tauri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42e05701e3a401923993286a45bb28e99b6a55b793c677ce846783c96ef4439c',
        22396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tauri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tauri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tauri
  static TextTheme tauriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tauri(textStyle: textTheme.displayLarge),
      displayMedium: tauri(textStyle: textTheme.displayMedium),
      displaySmall: tauri(textStyle: textTheme.displaySmall),
      headlineLarge: tauri(textStyle: textTheme.headlineLarge),
      headlineMedium: tauri(textStyle: textTheme.headlineMedium),
      headlineSmall: tauri(textStyle: textTheme.headlineSmall),
      titleLarge: tauri(textStyle: textTheme.titleLarge),
      titleMedium: tauri(textStyle: textTheme.titleMedium),
      titleSmall: tauri(textStyle: textTheme.titleSmall),
      bodyLarge: tauri(textStyle: textTheme.bodyLarge),
      bodyMedium: tauri(textStyle: textTheme.bodyMedium),
      bodySmall: tauri(textStyle: textTheme.bodySmall),
      labelLarge: tauri(textStyle: textTheme.labelLarge),
      labelMedium: tauri(textStyle: textTheme.labelMedium),
      labelSmall: tauri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Taviraj font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Taviraj
  static TextStyle taviraj({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c235d67df750d2131e1e8765ddbd9356359dcce416462abbde4da09343eff993',
        121120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b4c570ce9ff32521739f61882b0bb0a4cd51581b9438b0dfc60a6af8c685d8ea',
        134768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '15f067a3c5283ab372813485ec3f9bc1f45530b5b4e087990b416be27b31062e',
        121048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ced2d0587b40d00e009b060ad927b4056a6461f383221042fca48db6bc65fc3c',
        135428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a4bc7396e04f6a3c19746f751d18ce0dfb5d0fe2b8de7de61f055fcc1075d22',
        120532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b6b0837c8cc99356ce6036ce9f478a7f736c1590b7b808fe966f523fccab5455',
        135464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3bb2dda0ee2d87686846d380a18214195bbf75f704e6faf028c52a5254cd449',
        121308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '00b884788518d3d68a7600b503638faebabf096ef7c93060552f03e132e8d539',
        135232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68ca517dad8ad3f920c1b7f0708e1546aa39a2710340987e12a916860092de36',
        120460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '717a30b1154af73fd8d926c3b167b4a53eee1494436d15f056b2c128cfbfd981',
        136224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0bed4e1e828576ade6ffca8d0fbb37417c04e5985921f9a9420e23ca8a0c8130',
        120184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0d93dfca6dba86b83ad95bde9250c8650bfd099ee15645a4e0b2413b82458675',
        134776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9de0ae137acaa445e1c1f9a7eba4635e466c4564275610c7549f8472dbfb561',
        119372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '962268bc49c9e7b11b2ff24cdb099e2d95a935d616f42bbaacb31dcb85af937a',
        134564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0bd52df7867ce685eb0b45899a1f51cc088e2d1483ee822929888b3718f837e',
        119284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b0cfb61092f2d17c18522a2cc19cc4c37c3f5f30985c4c270c2639590b01b1c8',
        133664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'adde3df74a51bc10ff0429af154fd90ff393b721f1f67cb7caed54916ac33e0f',
        118736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd1f6043e4b6474d116031080f756667e9c9c8c761b7207faf0703972919f7b56',
        129244,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Taviraj',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Taviraj font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Taviraj
  static TextTheme tavirajTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: taviraj(textStyle: textTheme.displayLarge),
      displayMedium: taviraj(textStyle: textTheme.displayMedium),
      displaySmall: taviraj(textStyle: textTheme.displaySmall),
      headlineLarge: taviraj(textStyle: textTheme.headlineLarge),
      headlineMedium: taviraj(textStyle: textTheme.headlineMedium),
      headlineSmall: taviraj(textStyle: textTheme.headlineSmall),
      titleLarge: taviraj(textStyle: textTheme.titleLarge),
      titleMedium: taviraj(textStyle: textTheme.titleMedium),
      titleSmall: taviraj(textStyle: textTheme.titleSmall),
      bodyLarge: taviraj(textStyle: textTheme.bodyLarge),
      bodyMedium: taviraj(textStyle: textTheme.bodyMedium),
      bodySmall: taviraj(textStyle: textTheme.bodySmall),
      labelLarge: taviraj(textStyle: textTheme.labelLarge),
      labelMedium: taviraj(textStyle: textTheme.labelMedium),
      labelSmall: taviraj(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Teachers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Teachers
  static TextStyle teachers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e36d767907f71b35fb86874c563093f5e3c01d68a2086331bf6083dfaf79b1c1',
        30664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b3b4f878b7c8f5acb13aa4fe6a65e6ad77cda1a81dc98ec2c69ac1af31c1bf4',
        30748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f11e8d08270b82fe70f1ab0fefcbd27fb0a90513dd83407ba81ad58f53ce9fc',
        30732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46b3803504a157d9d46294487fe36e3f84ec29d6dee1e09776ba5f57f1138852',
        30628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11261a77b4297d0bd59e8b058bb47ce51aeaf0236bebec78c537b5cfc00e863c',
        30716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ad0f6ec0b3e9da4676d346185ca12edd5894cacbb1e279709537a9c7d6821e1e',
        31616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab752f683f89b25b55e3d72795df409a4fdbc59d95e1ad53a9113f27b6846b41',
        31740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '08b09edf5c27bd0f0422853de5a25c8a0d5308b3cf6e5cfbf8fd81d06c625f84',
        31728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5f7989a5b279fb164ca9b9a5513c0b458bc3b0b0832411a52b3d8e0a227a01d2',
        31604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dc42993d1ef697641a118f972d55789fe4338eb4aa5e07d328e96a8a92bdb0a9',
        31736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Teachers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Teachers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Teachers
  static TextTheme teachersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: teachers(textStyle: textTheme.displayLarge),
      displayMedium: teachers(textStyle: textTheme.displayMedium),
      displaySmall: teachers(textStyle: textTheme.displaySmall),
      headlineLarge: teachers(textStyle: textTheme.headlineLarge),
      headlineMedium: teachers(textStyle: textTheme.headlineMedium),
      headlineSmall: teachers(textStyle: textTheme.headlineSmall),
      titleLarge: teachers(textStyle: textTheme.titleLarge),
      titleMedium: teachers(textStyle: textTheme.titleMedium),
      titleSmall: teachers(textStyle: textTheme.titleSmall),
      bodyLarge: teachers(textStyle: textTheme.bodyLarge),
      bodyMedium: teachers(textStyle: textTheme.bodyMedium),
      bodySmall: teachers(textStyle: textTheme.bodySmall),
      labelLarge: teachers(textStyle: textTheme.labelLarge),
      labelMedium: teachers(textStyle: textTheme.labelMedium),
      labelSmall: teachers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Teko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Teko
  static TextStyle teko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c1b645531c219dacc4e8e625c089ff140e5d8684db184387effd7579e8c2ad0',
        153112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ed93c83d2ae6c043da5923273d039b800d56b584434a6988e082aff1a610512',
        153748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'baca27d055751eeb38bebc7a7420d116b624e4699632fb1de69315f866a96167',
        153744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e09d7b6882ecdc67d79583e30d6d70c9006df3891a0e064e76b7bcae8b70eaf',
        153952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16caa136e8b47828bfc53ebeb2d2beba1d132fb444e0e2532f3066982b7c19ca',
        153920,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Teko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Teko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Teko
  static TextTheme tekoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: teko(textStyle: textTheme.displayLarge),
      displayMedium: teko(textStyle: textTheme.displayMedium),
      displaySmall: teko(textStyle: textTheme.displaySmall),
      headlineLarge: teko(textStyle: textTheme.headlineLarge),
      headlineMedium: teko(textStyle: textTheme.headlineMedium),
      headlineSmall: teko(textStyle: textTheme.headlineSmall),
      titleLarge: teko(textStyle: textTheme.titleLarge),
      titleMedium: teko(textStyle: textTheme.titleMedium),
      titleSmall: teko(textStyle: textTheme.titleSmall),
      bodyLarge: teko(textStyle: textTheme.bodyLarge),
      bodyMedium: teko(textStyle: textTheme.bodyMedium),
      bodySmall: teko(textStyle: textTheme.bodySmall),
      labelLarge: teko(textStyle: textTheme.labelLarge),
      labelMedium: teko(textStyle: textTheme.labelMedium),
      labelSmall: teko(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tektur font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tektur
  static TextStyle tektur({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19147bfa0a36ef68c8302286c8914f74ff9a174eb6853e6a87c5c883f497daf9',
        67208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2993059576724eabbd0edc7f0bb49ef965e63f10691cf0b6f78367e33e5713b8',
        67772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e73ee713a5c00a1ecbddd3ec120fd08bf6f03154e1148a5e796ed0d35ce65df9',
        67620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a90b5eecb0ffb979c32b3c80083061c1c2767bdcc0810ee8623ad185b79243ee',
        67416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ad10f11687348c8c86db639df9c577ee6b183250757d2e944a72f5ec13794b5',
        67404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19c302ff6d5e939d4de82e0acc80b4f3d930d50e707ca2471435fb43f6061e7a',
        66468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tektur',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tektur font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tektur
  static TextTheme tekturTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tektur(textStyle: textTheme.displayLarge),
      displayMedium: tektur(textStyle: textTheme.displayMedium),
      displaySmall: tektur(textStyle: textTheme.displaySmall),
      headlineLarge: tektur(textStyle: textTheme.headlineLarge),
      headlineMedium: tektur(textStyle: textTheme.headlineMedium),
      headlineSmall: tektur(textStyle: textTheme.headlineSmall),
      titleLarge: tektur(textStyle: textTheme.titleLarge),
      titleMedium: tektur(textStyle: textTheme.titleMedium),
      titleSmall: tektur(textStyle: textTheme.titleSmall),
      bodyLarge: tektur(textStyle: textTheme.bodyLarge),
      bodyMedium: tektur(textStyle: textTheme.bodyMedium),
      bodySmall: tektur(textStyle: textTheme.bodySmall),
      labelLarge: tektur(textStyle: textTheme.labelLarge),
      labelMedium: tektur(textStyle: textTheme.labelMedium),
      labelSmall: tektur(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Telex font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Telex
  static TextStyle telex({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00b4deea7be43b3ce0e29a1561eb6a0e17b1a24de612edb06ba810d2183eaad0',
        22916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Telex',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Telex font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Telex
  static TextTheme telexTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: telex(textStyle: textTheme.displayLarge),
      displayMedium: telex(textStyle: textTheme.displayMedium),
      displaySmall: telex(textStyle: textTheme.displaySmall),
      headlineLarge: telex(textStyle: textTheme.headlineLarge),
      headlineMedium: telex(textStyle: textTheme.headlineMedium),
      headlineSmall: telex(textStyle: textTheme.headlineSmall),
      titleLarge: telex(textStyle: textTheme.titleLarge),
      titleMedium: telex(textStyle: textTheme.titleMedium),
      titleSmall: telex(textStyle: textTheme.titleSmall),
      bodyLarge: telex(textStyle: textTheme.bodyLarge),
      bodyMedium: telex(textStyle: textTheme.bodyMedium),
      bodySmall: telex(textStyle: textTheme.bodySmall),
      labelLarge: telex(textStyle: textTheme.labelLarge),
      labelMedium: telex(textStyle: textTheme.labelMedium),
      labelSmall: telex(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tenali Ramakrishna font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tenali+Ramakrishna
  static TextStyle tenaliRamakrishna({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f5f65a4a935911d6091fa2fed08c184001fe00461d9c2417cb4b55652166b95',
        431736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TenaliRamakrishna',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tenali Ramakrishna font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tenali+Ramakrishna
  static TextTheme tenaliRamakrishnaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tenaliRamakrishna(textStyle: textTheme.displayLarge),
      displayMedium: tenaliRamakrishna(textStyle: textTheme.displayMedium),
      displaySmall: tenaliRamakrishna(textStyle: textTheme.displaySmall),
      headlineLarge: tenaliRamakrishna(textStyle: textTheme.headlineLarge),
      headlineMedium: tenaliRamakrishna(textStyle: textTheme.headlineMedium),
      headlineSmall: tenaliRamakrishna(textStyle: textTheme.headlineSmall),
      titleLarge: tenaliRamakrishna(textStyle: textTheme.titleLarge),
      titleMedium: tenaliRamakrishna(textStyle: textTheme.titleMedium),
      titleSmall: tenaliRamakrishna(textStyle: textTheme.titleSmall),
      bodyLarge: tenaliRamakrishna(textStyle: textTheme.bodyLarge),
      bodyMedium: tenaliRamakrishna(textStyle: textTheme.bodyMedium),
      bodySmall: tenaliRamakrishna(textStyle: textTheme.bodySmall),
      labelLarge: tenaliRamakrishna(textStyle: textTheme.labelLarge),
      labelMedium: tenaliRamakrishna(textStyle: textTheme.labelMedium),
      labelSmall: tenaliRamakrishna(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tenor Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tenor+Sans
  static TextStyle tenorSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '503532a3b2dc8da27144e129a1fdd193cc1a5cb5f5afc8651b4b1b811b72ab0a',
        58944,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TenorSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tenor Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tenor+Sans
  static TextTheme tenorSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tenorSans(textStyle: textTheme.displayLarge),
      displayMedium: tenorSans(textStyle: textTheme.displayMedium),
      displaySmall: tenorSans(textStyle: textTheme.displaySmall),
      headlineLarge: tenorSans(textStyle: textTheme.headlineLarge),
      headlineMedium: tenorSans(textStyle: textTheme.headlineMedium),
      headlineSmall: tenorSans(textStyle: textTheme.headlineSmall),
      titleLarge: tenorSans(textStyle: textTheme.titleLarge),
      titleMedium: tenorSans(textStyle: textTheme.titleMedium),
      titleSmall: tenorSans(textStyle: textTheme.titleSmall),
      bodyLarge: tenorSans(textStyle: textTheme.bodyLarge),
      bodyMedium: tenorSans(textStyle: textTheme.bodyMedium),
      bodySmall: tenorSans(textStyle: textTheme.bodySmall),
      labelLarge: tenorSans(textStyle: textTheme.labelLarge),
      labelMedium: tenorSans(textStyle: textTheme.labelMedium),
      labelSmall: tenorSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Text Me One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Text+Me+One
  static TextStyle textMeOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '959812e0a8f25a959c4520fe3c6870c2c3363b025c019a5f22dd8eff445194a5',
        35128,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TextMeOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Text Me One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Text+Me+One
  static TextTheme textMeOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: textMeOne(textStyle: textTheme.displayLarge),
      displayMedium: textMeOne(textStyle: textTheme.displayMedium),
      displaySmall: textMeOne(textStyle: textTheme.displaySmall),
      headlineLarge: textMeOne(textStyle: textTheme.headlineLarge),
      headlineMedium: textMeOne(textStyle: textTheme.headlineMedium),
      headlineSmall: textMeOne(textStyle: textTheme.headlineSmall),
      titleLarge: textMeOne(textStyle: textTheme.titleLarge),
      titleMedium: textMeOne(textStyle: textTheme.titleMedium),
      titleSmall: textMeOne(textStyle: textTheme.titleSmall),
      bodyLarge: textMeOne(textStyle: textTheme.bodyLarge),
      bodyMedium: textMeOne(textStyle: textTheme.bodyMedium),
      bodySmall: textMeOne(textStyle: textTheme.bodySmall),
      labelLarge: textMeOne(textStyle: textTheme.labelLarge),
      labelMedium: textMeOne(textStyle: textTheme.labelMedium),
      labelSmall: textMeOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Texturina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Texturina
  static TextStyle texturina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61495cc700cfd8a0d524fe0463063f9d8d0b0126092bce85c6de8f1f68297735',
        83628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33854847582666dfbffa8f9ff29b4d173d16519c984c36d778431ccf837f2399',
        83712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85e0991c6e6b79564ec066270e6880c43ced684c5018a91bf1454ee1fedb4bc7',
        83660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '49b1aaee802706f363d0802cb9f886c6f7da857c38abfd9b19f0a4e9ee77a54d',
        83636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b7d12c1f286cd6164c3b21949e9d96f6503bffa56c0b0f7da9112044054ee69',
        83668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea4081035f9ae841fd96cdefe98629c36e296aa0b36822f3cdab6ca1db89c3be',
        83584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e23bfb5580052ee666662ff6fd0cd62080129e4fe2a85f62625c57322f280866',
        83596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '570d7994ba06c962e12e1724d2ca58c3b6b9e69883f14bb96284cc9f3d6564a4',
        83552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6651890efbf8089d027860fe8298dc04ea82ca491fcbf084a0fc90111c5c00ef',
        83532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b10773ac8ade360d6c9fcb70e4da8d96b04ec5447f638579161f063da0c5cb41',
        84192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f4f11274f0be176deef8d3cc33628fde7e4d7cb6ceec21193ddc8d1f2f32e99c',
        84244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '20bff09b893637820029e4890c614ff09a2c53defdc6357b9beddb173d19a7e6',
        84108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3970c8183a32e6ce021aca2baf6d31f4e2bcc9d7a813aef115e8d8e37bafa8b7',
        84020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '65636eaba0f0462cec16bef05f315fab3242e2ad52014b740cdbe0c19c5fa791',
        84128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8734b9097550fe7def85052af4c5b2e74922528bb5baa3f93968505f7b39e86',
        84176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e3e37730146baae9263343217f947dbc5cd74b13fc848f5874b48869a36ab1d3',
        84148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3f6b10840239fb4fd9047a7f5b708cd2364e3ac8952dd4f3438f03617a6935c9',
        84216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '350de765201e27ee27ede82429a5bae18af5a602d959885049dcaa16e26bfe97',
        84244,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Texturina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Texturina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Texturina
  static TextTheme texturinaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: texturina(textStyle: textTheme.displayLarge),
      displayMedium: texturina(textStyle: textTheme.displayMedium),
      displaySmall: texturina(textStyle: textTheme.displaySmall),
      headlineLarge: texturina(textStyle: textTheme.headlineLarge),
      headlineMedium: texturina(textStyle: textTheme.headlineMedium),
      headlineSmall: texturina(textStyle: textTheme.headlineSmall),
      titleLarge: texturina(textStyle: textTheme.titleLarge),
      titleMedium: texturina(textStyle: textTheme.titleMedium),
      titleSmall: texturina(textStyle: textTheme.titleSmall),
      bodyLarge: texturina(textStyle: textTheme.bodyLarge),
      bodyMedium: texturina(textStyle: textTheme.bodyMedium),
      bodySmall: texturina(textStyle: textTheme.bodySmall),
      labelLarge: texturina(textStyle: textTheme.labelLarge),
      labelMedium: texturina(textStyle: textTheme.labelMedium),
      labelSmall: texturina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Thasadith font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Thasadith
  static TextStyle thasadith({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddcc33ef3365032efefa3a90f19caddfe7e7ec246fc980e481172866accb0175',
        86292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd9d461efb5edcd3c9a1f67987c97de38e3c7f38c39fdd4047de2cbe0cfd5ad4e',
        89272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43c1ab5d214070c92fcb663c018afc77a041d234cfa7252093bbfe3a868eb13e',
        86644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0dcfbd35ab6de2b9047e13d3ac60da7186e6f85d62646722108fae18d84c5c1c',
        89652,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Thasadith',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Thasadith font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Thasadith
  static TextTheme thasadithTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: thasadith(textStyle: textTheme.displayLarge),
      displayMedium: thasadith(textStyle: textTheme.displayMedium),
      displaySmall: thasadith(textStyle: textTheme.displaySmall),
      headlineLarge: thasadith(textStyle: textTheme.headlineLarge),
      headlineMedium: thasadith(textStyle: textTheme.headlineMedium),
      headlineSmall: thasadith(textStyle: textTheme.headlineSmall),
      titleLarge: thasadith(textStyle: textTheme.titleLarge),
      titleMedium: thasadith(textStyle: textTheme.titleMedium),
      titleSmall: thasadith(textStyle: textTheme.titleSmall),
      bodyLarge: thasadith(textStyle: textTheme.bodyLarge),
      bodyMedium: thasadith(textStyle: textTheme.bodyMedium),
      bodySmall: thasadith(textStyle: textTheme.bodySmall),
      labelLarge: thasadith(textStyle: textTheme.labelLarge),
      labelMedium: thasadith(textStyle: textTheme.labelMedium),
      labelSmall: thasadith(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the The Girl Next Door font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/The+Girl+Next+Door
  static TextStyle theGirlNextDoor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9aca5d26f2c0bdd184c4c078eba162b127f74cb3f4cef19d2e46948728cbe865',
        42040,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TheGirlNextDoor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the The Girl Next Door font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/The+Girl+Next+Door
  static TextTheme theGirlNextDoorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: theGirlNextDoor(textStyle: textTheme.displayLarge),
      displayMedium: theGirlNextDoor(textStyle: textTheme.displayMedium),
      displaySmall: theGirlNextDoor(textStyle: textTheme.displaySmall),
      headlineLarge: theGirlNextDoor(textStyle: textTheme.headlineLarge),
      headlineMedium: theGirlNextDoor(textStyle: textTheme.headlineMedium),
      headlineSmall: theGirlNextDoor(textStyle: textTheme.headlineSmall),
      titleLarge: theGirlNextDoor(textStyle: textTheme.titleLarge),
      titleMedium: theGirlNextDoor(textStyle: textTheme.titleMedium),
      titleSmall: theGirlNextDoor(textStyle: textTheme.titleSmall),
      bodyLarge: theGirlNextDoor(textStyle: textTheme.bodyLarge),
      bodyMedium: theGirlNextDoor(textStyle: textTheme.bodyMedium),
      bodySmall: theGirlNextDoor(textStyle: textTheme.bodySmall),
      labelLarge: theGirlNextDoor(textStyle: textTheme.labelLarge),
      labelMedium: theGirlNextDoor(textStyle: textTheme.labelMedium),
      labelSmall: theGirlNextDoor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the The Nautigal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/The+Nautigal
  static TextStyle theNautigal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a978060b69585674cbf18f80c270e539f0dfb47a29060764382d9edb7fb9b364',
        108576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa9127018e272334df2a83da6a6adf56562d544d1ddbe5f532bcf411aaa06590',
        108036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TheNautigal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the The Nautigal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/The+Nautigal
  static TextTheme theNautigalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: theNautigal(textStyle: textTheme.displayLarge),
      displayMedium: theNautigal(textStyle: textTheme.displayMedium),
      displaySmall: theNautigal(textStyle: textTheme.displaySmall),
      headlineLarge: theNautigal(textStyle: textTheme.headlineLarge),
      headlineMedium: theNautigal(textStyle: textTheme.headlineMedium),
      headlineSmall: theNautigal(textStyle: textTheme.headlineSmall),
      titleLarge: theNautigal(textStyle: textTheme.titleLarge),
      titleMedium: theNautigal(textStyle: textTheme.titleMedium),
      titleSmall: theNautigal(textStyle: textTheme.titleSmall),
      bodyLarge: theNautigal(textStyle: textTheme.bodyLarge),
      bodyMedium: theNautigal(textStyle: textTheme.bodyMedium),
      bodySmall: theNautigal(textStyle: textTheme.bodySmall),
      labelLarge: theNautigal(textStyle: textTheme.labelLarge),
      labelMedium: theNautigal(textStyle: textTheme.labelMedium),
      labelSmall: theNautigal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tienne font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tienne
  static TextStyle tienne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd464bae8fe9ec18f0b6c2092699eda523f5bd8efd853a074218a87897986267d',
        39320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '127b3ca5d9108ab427bf14c814de07ed3947de3e38cb3fd3bb9ca330dd0af260',
        37372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f3bfee1d66a1d333e8d4d7bc617c8aeb1396048315adfdcb3b3364a81871a95',
        33700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tienne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tienne font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tienne
  static TextTheme tienneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tienne(textStyle: textTheme.displayLarge),
      displayMedium: tienne(textStyle: textTheme.displayMedium),
      displaySmall: tienne(textStyle: textTheme.displaySmall),
      headlineLarge: tienne(textStyle: textTheme.headlineLarge),
      headlineMedium: tienne(textStyle: textTheme.headlineMedium),
      headlineSmall: tienne(textStyle: textTheme.headlineSmall),
      titleLarge: tienne(textStyle: textTheme.titleLarge),
      titleMedium: tienne(textStyle: textTheme.titleMedium),
      titleSmall: tienne(textStyle: textTheme.titleSmall),
      bodyLarge: tienne(textStyle: textTheme.bodyLarge),
      bodyMedium: tienne(textStyle: textTheme.bodyMedium),
      bodySmall: tienne(textStyle: textTheme.bodySmall),
      labelLarge: tienne(textStyle: textTheme.labelLarge),
      labelMedium: tienne(textStyle: textTheme.labelMedium),
      labelSmall: tienne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tillana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tillana
  static TextStyle tillana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd5b2376543d7551015429fac5d8cd14badf67be99d2fedbed742f731e9cb3384',
        216284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2459b6344c675b3cf815145e282683e4ca3b72a70bf66a12f58fb0e39a836ac0',
        220652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88559f4a3f8244821708f9805f933cd600fff453b12a9908dafac3c12bbed83a',
        221392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b52ac2b03b0dd5b896ef4cdcd0e4337b282f5e5a79d6243a82c1bd3a50269196',
        220924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ffb7907b587a4f00479512373bb87e891ba26e080b6473cc1c2f03a6acb7411f',
        221112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tillana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tillana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tillana
  static TextTheme tillanaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tillana(textStyle: textTheme.displayLarge),
      displayMedium: tillana(textStyle: textTheme.displayMedium),
      displaySmall: tillana(textStyle: textTheme.displaySmall),
      headlineLarge: tillana(textStyle: textTheme.headlineLarge),
      headlineMedium: tillana(textStyle: textTheme.headlineMedium),
      headlineSmall: tillana(textStyle: textTheme.headlineSmall),
      titleLarge: tillana(textStyle: textTheme.titleLarge),
      titleMedium: tillana(textStyle: textTheme.titleMedium),
      titleSmall: tillana(textStyle: textTheme.titleSmall),
      bodyLarge: tillana(textStyle: textTheme.bodyLarge),
      bodyMedium: tillana(textStyle: textTheme.bodyMedium),
      bodySmall: tillana(textStyle: textTheme.bodySmall),
      labelLarge: tillana(textStyle: textTheme.labelLarge),
      labelMedium: tillana(textStyle: textTheme.labelMedium),
      labelSmall: tillana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tilt Neon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tilt+Neon
  static TextStyle tiltNeon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bcb605cb7f771b18ceadf974ee0574ee1de6a12d464126637cd7135b053a27f',
        89348,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiltNeon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tilt Neon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tilt+Neon
  static TextTheme tiltNeonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiltNeon(textStyle: textTheme.displayLarge),
      displayMedium: tiltNeon(textStyle: textTheme.displayMedium),
      displaySmall: tiltNeon(textStyle: textTheme.displaySmall),
      headlineLarge: tiltNeon(textStyle: textTheme.headlineLarge),
      headlineMedium: tiltNeon(textStyle: textTheme.headlineMedium),
      headlineSmall: tiltNeon(textStyle: textTheme.headlineSmall),
      titleLarge: tiltNeon(textStyle: textTheme.titleLarge),
      titleMedium: tiltNeon(textStyle: textTheme.titleMedium),
      titleSmall: tiltNeon(textStyle: textTheme.titleSmall),
      bodyLarge: tiltNeon(textStyle: textTheme.bodyLarge),
      bodyMedium: tiltNeon(textStyle: textTheme.bodyMedium),
      bodySmall: tiltNeon(textStyle: textTheme.bodySmall),
      labelLarge: tiltNeon(textStyle: textTheme.labelLarge),
      labelMedium: tiltNeon(textStyle: textTheme.labelMedium),
      labelSmall: tiltNeon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tilt Prism font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tilt+Prism
  static TextStyle tiltPrism({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '816c05603fa0ca374d0d748d0a1c029c7d5b8fa7f3068d858440b0e4755f968a',
        174756,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiltPrism',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tilt Prism font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tilt+Prism
  static TextTheme tiltPrismTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiltPrism(textStyle: textTheme.displayLarge),
      displayMedium: tiltPrism(textStyle: textTheme.displayMedium),
      displaySmall: tiltPrism(textStyle: textTheme.displaySmall),
      headlineLarge: tiltPrism(textStyle: textTheme.headlineLarge),
      headlineMedium: tiltPrism(textStyle: textTheme.headlineMedium),
      headlineSmall: tiltPrism(textStyle: textTheme.headlineSmall),
      titleLarge: tiltPrism(textStyle: textTheme.titleLarge),
      titleMedium: tiltPrism(textStyle: textTheme.titleMedium),
      titleSmall: tiltPrism(textStyle: textTheme.titleSmall),
      bodyLarge: tiltPrism(textStyle: textTheme.bodyLarge),
      bodyMedium: tiltPrism(textStyle: textTheme.bodyMedium),
      bodySmall: tiltPrism(textStyle: textTheme.bodySmall),
      labelLarge: tiltPrism(textStyle: textTheme.labelLarge),
      labelMedium: tiltPrism(textStyle: textTheme.labelMedium),
      labelSmall: tiltPrism(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tilt Warp font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tilt+Warp
  static TextStyle tiltWarp({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ecf1622fb5236d16feb943641f704377337d346f1c19bfab88babe2bc76a618',
        59624,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiltWarp',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tilt Warp font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tilt+Warp
  static TextTheme tiltWarpTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiltWarp(textStyle: textTheme.displayLarge),
      displayMedium: tiltWarp(textStyle: textTheme.displayMedium),
      displaySmall: tiltWarp(textStyle: textTheme.displaySmall),
      headlineLarge: tiltWarp(textStyle: textTheme.headlineLarge),
      headlineMedium: tiltWarp(textStyle: textTheme.headlineMedium),
      headlineSmall: tiltWarp(textStyle: textTheme.headlineSmall),
      titleLarge: tiltWarp(textStyle: textTheme.titleLarge),
      titleMedium: tiltWarp(textStyle: textTheme.titleMedium),
      titleSmall: tiltWarp(textStyle: textTheme.titleSmall),
      bodyLarge: tiltWarp(textStyle: textTheme.bodyLarge),
      bodyMedium: tiltWarp(textStyle: textTheme.bodyMedium),
      bodySmall: tiltWarp(textStyle: textTheme.bodySmall),
      labelLarge: tiltWarp(textStyle: textTheme.labelLarge),
      labelMedium: tiltWarp(textStyle: textTheme.labelMedium),
      labelSmall: tiltWarp(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Timmana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Timmana
  static TextStyle timmana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0123471088f58816de3b9e9331ed8e46a447570e0eb5c817e3927db8124196b2',
        431972,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Timmana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Timmana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Timmana
  static TextTheme timmanaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: timmana(textStyle: textTheme.displayLarge),
      displayMedium: timmana(textStyle: textTheme.displayMedium),
      displaySmall: timmana(textStyle: textTheme.displaySmall),
      headlineLarge: timmana(textStyle: textTheme.headlineLarge),
      headlineMedium: timmana(textStyle: textTheme.headlineMedium),
      headlineSmall: timmana(textStyle: textTheme.headlineSmall),
      titleLarge: timmana(textStyle: textTheme.titleLarge),
      titleMedium: timmana(textStyle: textTheme.titleMedium),
      titleSmall: timmana(textStyle: textTheme.titleSmall),
      bodyLarge: timmana(textStyle: textTheme.bodyLarge),
      bodyMedium: timmana(textStyle: textTheme.bodyMedium),
      bodySmall: timmana(textStyle: textTheme.bodySmall),
      labelLarge: timmana(textStyle: textTheme.labelLarge),
      labelMedium: timmana(textStyle: textTheme.labelMedium),
      labelSmall: timmana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tinos font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tinos
  static TextStyle tinos({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23e68bc98222339eb30959aade856a732c4f3ea04e5c229e00cede6c5378c2ed',
        246568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1751ba26644fb09379dcddda6f5c0065988cf041859f8027ef182b99ba145c22',
        248184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1072711f4d2e7b23ff31277fde58d4b1dfd846d0a31410102b39aa8a95943b84',
        240620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b951c5c411f9fb34b0f43af03345658f01741e07d1f73b23bf1e4b68e278729c',
        246184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tinos',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tinos font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tinos
  static TextTheme tinosTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tinos(textStyle: textTheme.displayLarge),
      displayMedium: tinos(textStyle: textTheme.displayMedium),
      displaySmall: tinos(textStyle: textTheme.displaySmall),
      headlineLarge: tinos(textStyle: textTheme.headlineLarge),
      headlineMedium: tinos(textStyle: textTheme.headlineMedium),
      headlineSmall: tinos(textStyle: textTheme.headlineSmall),
      titleLarge: tinos(textStyle: textTheme.titleLarge),
      titleMedium: tinos(textStyle: textTheme.titleMedium),
      titleSmall: tinos(textStyle: textTheme.titleSmall),
      bodyLarge: tinos(textStyle: textTheme.bodyLarge),
      bodyMedium: tinos(textStyle: textTheme.bodyMedium),
      bodySmall: tinos(textStyle: textTheme.bodySmall),
      labelLarge: tinos(textStyle: textTheme.labelLarge),
      labelMedium: tinos(textStyle: textTheme.labelMedium),
      labelSmall: tinos(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiny5 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiny5
  static TextStyle tiny5({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f04e9245d5909c7bd2b7276fea75dfd4bbfe2ce2d2dd89e8a9495a7d5432dac4',
        74284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tiny5',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiny5 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiny5
  static TextTheme tiny5TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiny5(textStyle: textTheme.displayLarge),
      displayMedium: tiny5(textStyle: textTheme.displayMedium),
      displaySmall: tiny5(textStyle: textTheme.displaySmall),
      headlineLarge: tiny5(textStyle: textTheme.headlineLarge),
      headlineMedium: tiny5(textStyle: textTheme.headlineMedium),
      headlineSmall: tiny5(textStyle: textTheme.headlineSmall),
      titleLarge: tiny5(textStyle: textTheme.titleLarge),
      titleMedium: tiny5(textStyle: textTheme.titleMedium),
      titleSmall: tiny5(textStyle: textTheme.titleSmall),
      bodyLarge: tiny5(textStyle: textTheme.bodyLarge),
      bodyMedium: tiny5(textStyle: textTheme.bodyMedium),
      bodySmall: tiny5(textStyle: textTheme.bodySmall),
      labelLarge: tiny5(textStyle: textTheme.labelLarge),
      labelMedium: tiny5(textStyle: textTheme.labelMedium),
      labelSmall: tiny5(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiro Bangla font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Bangla
  static TextStyle tiroBangla({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6bb112fe0b99f59a55ea20409d2a2139151881033562ccfa9ebb12cc8c09970a',
        193128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '85c804ae6757832bb60c86dddb0ea08524558dc077631a0a60443be724d238f8',
        197520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiroBangla',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiro Bangla font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Bangla
  static TextTheme tiroBanglaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiroBangla(textStyle: textTheme.displayLarge),
      displayMedium: tiroBangla(textStyle: textTheme.displayMedium),
      displaySmall: tiroBangla(textStyle: textTheme.displaySmall),
      headlineLarge: tiroBangla(textStyle: textTheme.headlineLarge),
      headlineMedium: tiroBangla(textStyle: textTheme.headlineMedium),
      headlineSmall: tiroBangla(textStyle: textTheme.headlineSmall),
      titleLarge: tiroBangla(textStyle: textTheme.titleLarge),
      titleMedium: tiroBangla(textStyle: textTheme.titleMedium),
      titleSmall: tiroBangla(textStyle: textTheme.titleSmall),
      bodyLarge: tiroBangla(textStyle: textTheme.bodyLarge),
      bodyMedium: tiroBangla(textStyle: textTheme.bodyMedium),
      bodySmall: tiroBangla(textStyle: textTheme.bodySmall),
      labelLarge: tiroBangla(textStyle: textTheme.labelLarge),
      labelMedium: tiroBangla(textStyle: textTheme.labelMedium),
      labelSmall: tiroBangla(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiro Devanagari Hindi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Devanagari+Hindi
  static TextStyle tiroDevanagariHindi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79f9b78b96c3d89b3f45803facad00dc5cf7a958e433f03aa0b2dc34dfa1846d',
        250692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0504e39af7e5ed18179046973556aa791a247ba24f0851a26da501144dcaf4f0',
        253924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiroDevanagariHindi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiro Devanagari Hindi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Devanagari+Hindi
  static TextTheme tiroDevanagariHindiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiroDevanagariHindi(textStyle: textTheme.displayLarge),
      displayMedium: tiroDevanagariHindi(textStyle: textTheme.displayMedium),
      displaySmall: tiroDevanagariHindi(textStyle: textTheme.displaySmall),
      headlineLarge: tiroDevanagariHindi(textStyle: textTheme.headlineLarge),
      headlineMedium: tiroDevanagariHindi(textStyle: textTheme.headlineMedium),
      headlineSmall: tiroDevanagariHindi(textStyle: textTheme.headlineSmall),
      titleLarge: tiroDevanagariHindi(textStyle: textTheme.titleLarge),
      titleMedium: tiroDevanagariHindi(textStyle: textTheme.titleMedium),
      titleSmall: tiroDevanagariHindi(textStyle: textTheme.titleSmall),
      bodyLarge: tiroDevanagariHindi(textStyle: textTheme.bodyLarge),
      bodyMedium: tiroDevanagariHindi(textStyle: textTheme.bodyMedium),
      bodySmall: tiroDevanagariHindi(textStyle: textTheme.bodySmall),
      labelLarge: tiroDevanagariHindi(textStyle: textTheme.labelLarge),
      labelMedium: tiroDevanagariHindi(textStyle: textTheme.labelMedium),
      labelSmall: tiroDevanagariHindi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiro Devanagari Marathi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Devanagari+Marathi
  static TextStyle tiroDevanagariMarathi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a0c2ac07584ef3e1bd3b08a3f609e89e64a9eec24307e69df956c2024312262',
        249320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e047c3da37621e0d6f74d12aad194f6ae81741ef61c3db9a9a587348c099412a',
        252588,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiroDevanagariMarathi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiro Devanagari Marathi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Devanagari+Marathi
  static TextTheme tiroDevanagariMarathiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiroDevanagariMarathi(textStyle: textTheme.displayLarge),
      displayMedium: tiroDevanagariMarathi(textStyle: textTheme.displayMedium),
      displaySmall: tiroDevanagariMarathi(textStyle: textTheme.displaySmall),
      headlineLarge: tiroDevanagariMarathi(textStyle: textTheme.headlineLarge),
      headlineMedium: tiroDevanagariMarathi(
        textStyle: textTheme.headlineMedium,
      ),
      headlineSmall: tiroDevanagariMarathi(textStyle: textTheme.headlineSmall),
      titleLarge: tiroDevanagariMarathi(textStyle: textTheme.titleLarge),
      titleMedium: tiroDevanagariMarathi(textStyle: textTheme.titleMedium),
      titleSmall: tiroDevanagariMarathi(textStyle: textTheme.titleSmall),
      bodyLarge: tiroDevanagariMarathi(textStyle: textTheme.bodyLarge),
      bodyMedium: tiroDevanagariMarathi(textStyle: textTheme.bodyMedium),
      bodySmall: tiroDevanagariMarathi(textStyle: textTheme.bodySmall),
      labelLarge: tiroDevanagariMarathi(textStyle: textTheme.labelLarge),
      labelMedium: tiroDevanagariMarathi(textStyle: textTheme.labelMedium),
      labelSmall: tiroDevanagariMarathi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiro Devanagari Sanskrit font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Devanagari+Sanskrit
  static TextStyle tiroDevanagariSanskrit({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '052519e5e106e8076839f1f9a188de11e0b651456882c00287124a36fb453327',
        429356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e2f99cde582e8da3ee4d3d868c8c2bda946b80cac43d29bff8d5d6a9790f82f9',
        434360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiroDevanagariSanskrit',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiro Devanagari Sanskrit font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Devanagari+Sanskrit
  static TextTheme tiroDevanagariSanskritTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiroDevanagariSanskrit(textStyle: textTheme.displayLarge),
      displayMedium: tiroDevanagariSanskrit(textStyle: textTheme.displayMedium),
      displaySmall: tiroDevanagariSanskrit(textStyle: textTheme.displaySmall),
      headlineLarge: tiroDevanagariSanskrit(textStyle: textTheme.headlineLarge),
      headlineMedium: tiroDevanagariSanskrit(
        textStyle: textTheme.headlineMedium,
      ),
      headlineSmall: tiroDevanagariSanskrit(textStyle: textTheme.headlineSmall),
      titleLarge: tiroDevanagariSanskrit(textStyle: textTheme.titleLarge),
      titleMedium: tiroDevanagariSanskrit(textStyle: textTheme.titleMedium),
      titleSmall: tiroDevanagariSanskrit(textStyle: textTheme.titleSmall),
      bodyLarge: tiroDevanagariSanskrit(textStyle: textTheme.bodyLarge),
      bodyMedium: tiroDevanagariSanskrit(textStyle: textTheme.bodyMedium),
      bodySmall: tiroDevanagariSanskrit(textStyle: textTheme.bodySmall),
      labelLarge: tiroDevanagariSanskrit(textStyle: textTheme.labelLarge),
      labelMedium: tiroDevanagariSanskrit(textStyle: textTheme.labelMedium),
      labelSmall: tiroDevanagariSanskrit(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiro Gurmukhi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Gurmukhi
  static TextStyle tiroGurmukhi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '530b5e3b59e5e96f1eb00dd80f3c721ec7b7bc86410e84111d6751b2ca49e9f2',
        86168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8921dc96a6f8f39787c4b2fa08c9fa414785e0732f88f7385a4005c85abae73a',
        87292,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiroGurmukhi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiro Gurmukhi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Gurmukhi
  static TextTheme tiroGurmukhiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiroGurmukhi(textStyle: textTheme.displayLarge),
      displayMedium: tiroGurmukhi(textStyle: textTheme.displayMedium),
      displaySmall: tiroGurmukhi(textStyle: textTheme.displaySmall),
      headlineLarge: tiroGurmukhi(textStyle: textTheme.headlineLarge),
      headlineMedium: tiroGurmukhi(textStyle: textTheme.headlineMedium),
      headlineSmall: tiroGurmukhi(textStyle: textTheme.headlineSmall),
      titleLarge: tiroGurmukhi(textStyle: textTheme.titleLarge),
      titleMedium: tiroGurmukhi(textStyle: textTheme.titleMedium),
      titleSmall: tiroGurmukhi(textStyle: textTheme.titleSmall),
      bodyLarge: tiroGurmukhi(textStyle: textTheme.bodyLarge),
      bodyMedium: tiroGurmukhi(textStyle: textTheme.bodyMedium),
      bodySmall: tiroGurmukhi(textStyle: textTheme.bodySmall),
      labelLarge: tiroGurmukhi(textStyle: textTheme.labelLarge),
      labelMedium: tiroGurmukhi(textStyle: textTheme.labelMedium),
      labelSmall: tiroGurmukhi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiro Kannada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Kannada
  static TextStyle tiroKannada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e5b4a800e61db5c515c013e87667fdf5b612fa26efe1d5d3a82a8d92dd0e304e',
        278956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'da7d1a133cb1067623fe388dd7618834d4725ce9b2bc067b556ab48e67fee713',
        281068,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiroKannada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiro Kannada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Kannada
  static TextTheme tiroKannadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiroKannada(textStyle: textTheme.displayLarge),
      displayMedium: tiroKannada(textStyle: textTheme.displayMedium),
      displaySmall: tiroKannada(textStyle: textTheme.displaySmall),
      headlineLarge: tiroKannada(textStyle: textTheme.headlineLarge),
      headlineMedium: tiroKannada(textStyle: textTheme.headlineMedium),
      headlineSmall: tiroKannada(textStyle: textTheme.headlineSmall),
      titleLarge: tiroKannada(textStyle: textTheme.titleLarge),
      titleMedium: tiroKannada(textStyle: textTheme.titleMedium),
      titleSmall: tiroKannada(textStyle: textTheme.titleSmall),
      bodyLarge: tiroKannada(textStyle: textTheme.bodyLarge),
      bodyMedium: tiroKannada(textStyle: textTheme.bodyMedium),
      bodySmall: tiroKannada(textStyle: textTheme.bodySmall),
      labelLarge: tiroKannada(textStyle: textTheme.labelLarge),
      labelMedium: tiroKannada(textStyle: textTheme.labelMedium),
      labelSmall: tiroKannada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiro Tamil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Tamil
  static TextStyle tiroTamil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8c1bd98a0dd7710c57cf37f8982c5d7c93e9b432d42397ae45d3ab30d2ad9c1',
        106120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ecdd0ac7d54528cacf5fdad74de5a1818c5a77931691b816621c935649675169',
        107380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiroTamil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiro Tamil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Tamil
  static TextTheme tiroTamilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiroTamil(textStyle: textTheme.displayLarge),
      displayMedium: tiroTamil(textStyle: textTheme.displayMedium),
      displaySmall: tiroTamil(textStyle: textTheme.displaySmall),
      headlineLarge: tiroTamil(textStyle: textTheme.headlineLarge),
      headlineMedium: tiroTamil(textStyle: textTheme.headlineMedium),
      headlineSmall: tiroTamil(textStyle: textTheme.headlineSmall),
      titleLarge: tiroTamil(textStyle: textTheme.titleLarge),
      titleMedium: tiroTamil(textStyle: textTheme.titleMedium),
      titleSmall: tiroTamil(textStyle: textTheme.titleSmall),
      bodyLarge: tiroTamil(textStyle: textTheme.bodyLarge),
      bodyMedium: tiroTamil(textStyle: textTheme.bodyMedium),
      bodySmall: tiroTamil(textStyle: textTheme.bodySmall),
      labelLarge: tiroTamil(textStyle: textTheme.labelLarge),
      labelMedium: tiroTamil(textStyle: textTheme.labelMedium),
      labelSmall: tiroTamil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tiro Telugu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Telugu
  static TextStyle tiroTelugu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9aeb5fe6b5d101a3f2480e8097d0431b134f1502385bd0f648b3564b4a3ef4c6',
        395380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '70ed1c0fe4f8b128b26bda89ad0c94f13ff87f15180904d5c43505770d88b937',
        392340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TiroTelugu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tiro Telugu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tiro+Telugu
  static TextTheme tiroTeluguTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tiroTelugu(textStyle: textTheme.displayLarge),
      displayMedium: tiroTelugu(textStyle: textTheme.displayMedium),
      displaySmall: tiroTelugu(textStyle: textTheme.displaySmall),
      headlineLarge: tiroTelugu(textStyle: textTheme.headlineLarge),
      headlineMedium: tiroTelugu(textStyle: textTheme.headlineMedium),
      headlineSmall: tiroTelugu(textStyle: textTheme.headlineSmall),
      titleLarge: tiroTelugu(textStyle: textTheme.titleLarge),
      titleMedium: tiroTelugu(textStyle: textTheme.titleMedium),
      titleSmall: tiroTelugu(textStyle: textTheme.titleSmall),
      bodyLarge: tiroTelugu(textStyle: textTheme.bodyLarge),
      bodyMedium: tiroTelugu(textStyle: textTheme.bodyMedium),
      bodySmall: tiroTelugu(textStyle: textTheme.bodySmall),
      labelLarge: tiroTelugu(textStyle: textTheme.labelLarge),
      labelMedium: tiroTelugu(textStyle: textTheme.labelMedium),
      labelSmall: tiroTelugu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Titan One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Titan+One
  static TextStyle titanOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eaa4a405303f96202b92489b5a90f4b2c514f18e0dfe23cf5a8438c61ddc0a28',
        52164,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TitanOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Titan One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Titan+One
  static TextTheme titanOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: titanOne(textStyle: textTheme.displayLarge),
      displayMedium: titanOne(textStyle: textTheme.displayMedium),
      displaySmall: titanOne(textStyle: textTheme.displaySmall),
      headlineLarge: titanOne(textStyle: textTheme.headlineLarge),
      headlineMedium: titanOne(textStyle: textTheme.headlineMedium),
      headlineSmall: titanOne(textStyle: textTheme.headlineSmall),
      titleLarge: titanOne(textStyle: textTheme.titleLarge),
      titleMedium: titanOne(textStyle: textTheme.titleMedium),
      titleSmall: titanOne(textStyle: textTheme.titleSmall),
      bodyLarge: titanOne(textStyle: textTheme.bodyLarge),
      bodyMedium: titanOne(textStyle: textTheme.bodyMedium),
      bodySmall: titanOne(textStyle: textTheme.bodySmall),
      labelLarge: titanOne(textStyle: textTheme.labelLarge),
      labelMedium: titanOne(textStyle: textTheme.labelMedium),
      labelSmall: titanOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Titillium Web font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Titillium+Web
  static TextStyle titilliumWeb({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f5156ef72655bd0bb8342cf72f97b438b909ce0786c89368e161a7a7a5044c4',
        53388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b41863786cea354768a8bcf909bc028ccec3d5a74df4d3ab6d0257779919a3f3',
        57408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b63490b0fdfb1181c49745d5831f4b7cd645c351dc8dbaafffc68e9134faef1c',
        54196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '586a6cfba3fbefe5d8f9ffa237794e5a0358cb85036494872529385c7b88ac39',
        60640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c196e3a2de40c8f653836ef77179ffef571e576c230e6248ffbf412c00cdc5d3',
        53956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '20f3207fa3d400e32bb447e04cdb48313338de297689ecc7c5bf5cff91f97e85',
        61348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '378363163026e95ad98b248e883c8e0e8a97278f4660b2395d96c938fa11d550',
        53224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '58aae33f96dfa11f7820390b1a3401e2437156bb8166f0ab9148acb7d4caf230',
        60880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f6044af66f6f8dacfde724d1661e5d7c1d6b22067e5f5e0936c1b949e20b7c1',
        51392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6108cbde308a768e16ed5cc7f7fa347e258a66ec46e4ec107bfff9bb17a53e6e',
        59216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33f76afabea23790ba345a416e412c3c74a4c05db5d20ac2586533b47a687ebc',
        41708,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TitilliumWeb',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Titillium Web font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Titillium+Web
  static TextTheme titilliumWebTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: titilliumWeb(textStyle: textTheme.displayLarge),
      displayMedium: titilliumWeb(textStyle: textTheme.displayMedium),
      displaySmall: titilliumWeb(textStyle: textTheme.displaySmall),
      headlineLarge: titilliumWeb(textStyle: textTheme.headlineLarge),
      headlineMedium: titilliumWeb(textStyle: textTheme.headlineMedium),
      headlineSmall: titilliumWeb(textStyle: textTheme.headlineSmall),
      titleLarge: titilliumWeb(textStyle: textTheme.titleLarge),
      titleMedium: titilliumWeb(textStyle: textTheme.titleMedium),
      titleSmall: titilliumWeb(textStyle: textTheme.titleSmall),
      bodyLarge: titilliumWeb(textStyle: textTheme.bodyLarge),
      bodyMedium: titilliumWeb(textStyle: textTheme.bodyMedium),
      bodySmall: titilliumWeb(textStyle: textTheme.bodySmall),
      labelLarge: titilliumWeb(textStyle: textTheme.labelLarge),
      labelMedium: titilliumWeb(textStyle: textTheme.labelMedium),
      labelSmall: titilliumWeb(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tomorrow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tomorrow
  static TextStyle tomorrow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd94286b8362ac88860a4a603907c08dfdeafbc87cff6a4989e2e11e28a44944f',
        54872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7ca9ddcfdebe54d8ee90d67999db09e82cf38f9cc1bfbbb106cd4855bf762779',
        58008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0eddea348a21377de5aa3f1ad845606d0299c713410bfb5b01bbd931ed2ad0f6',
        56872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e3febb56ec4d9b712a2500f799f867c2391f00dbf82be024402ee68bd324017a',
        58892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf8107dbc76e0f80a866cacdb2eda10f9c5bc11d497ea4a1186f5f7d4d3273b3',
        56908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8c8ab1559e00cc9ac646d94feb8b789c79fa1fce5251a82cd4c0662b013fee78',
        58928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10adac585bdd25230122215e9e7f3c23a68778d1c877f6ca704930d07e7030e4',
        56716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fa27248044f9d3a94642f1d31f739971ed24de35375b61e8021d2a398ec71166',
        58568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02cbd339877852e985e5632512ffb042bac1804b6be624cc6f61ca300b3fa98e',
        56172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '02f72a223861ad7c0184d03b68e3d36cb525343213856efb54868f7b0b4f7291',
        58112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6507457f6d860844cf41a1f0ebc31407e0136f09ae784368555037ab16faa12c',
        56784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6da621f920fc203b9945c78a110b39e0abc9d9a2ffdd5fc56fd48882347e4f99',
        59016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8ae635abc44fa69fc19535be28dd61b8fb5eca2becd195cabc1b9337ea773e8',
        55956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '93d696363750e9c0297e5c8963a97dce03d4666b4bf9b74b11df5cd07029fc27',
        58964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f9f3ad38a3331fe33fe1f4c92c3fb900900a94a103cb806ca20b38f41ac9a93',
        56584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '357641739a9189feb2d9f86f9742b653e406489e7667ef6d0757f4106c17d673',
        59704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6167bcf6cb970075ad030fe3f7360756ed7d219989464deaece8b32142ec34bc',
        52332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ee0aa43e390403b1895be7365b58fa1d21c981c619df9fe46ac246e91e22ba62',
        55780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tomorrow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tomorrow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tomorrow
  static TextTheme tomorrowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tomorrow(textStyle: textTheme.displayLarge),
      displayMedium: tomorrow(textStyle: textTheme.displayMedium),
      displaySmall: tomorrow(textStyle: textTheme.displaySmall),
      headlineLarge: tomorrow(textStyle: textTheme.headlineLarge),
      headlineMedium: tomorrow(textStyle: textTheme.headlineMedium),
      headlineSmall: tomorrow(textStyle: textTheme.headlineSmall),
      titleLarge: tomorrow(textStyle: textTheme.titleLarge),
      titleMedium: tomorrow(textStyle: textTheme.titleMedium),
      titleSmall: tomorrow(textStyle: textTheme.titleSmall),
      bodyLarge: tomorrow(textStyle: textTheme.bodyLarge),
      bodyMedium: tomorrow(textStyle: textTheme.bodyMedium),
      bodySmall: tomorrow(textStyle: textTheme.bodySmall),
      labelLarge: tomorrow(textStyle: textTheme.labelLarge),
      labelMedium: tomorrow(textStyle: textTheme.labelMedium),
      labelSmall: tomorrow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tourney font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tourney
  static TextStyle tourney({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47b30251344f5f93137bcf964fe20a943ca9634a57e20752f3e18328dc5ed8a7',
        61996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8919f59e39e1c61577612c4997099b41744c302189fd902fd7c4982fb048d78a',
        61996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05c09db091c5d7aed999ab3a7d2fbb9b50b85d615139a41046dd9e7f13d81dae',
        61976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17da8b076f0652f6a10cdc074c79cf2bd45b662e02f46044c1324a0851684c6d',
        61984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43d8defaadf14ceff1fd930e1c64fbf5f633245beb8bdae31273edd39e36d18a',
        62000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '080c1888f1e69a9a81444ee76daa78b61d3e3540720b36d5541990c4f0ea8fa6',
        62020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '743b950df5d95a7418b33b4a8491a621f7afe1eee5f5052d2b451418da2bfe01',
        61972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce933021a3c9a7ddaf1f579b90624413281e1022962ad685b1711d84dca3303d',
        62100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf7a5d75e79bc62013d192a698931a1279065084d6a36be26a8f902380ec8821',
        61640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '26668e8e4ef69533a03b5562c988ae81f0f2d0112e136b373611a69af3925bee',
        64620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f32131f36f3b4501b00a9de3e00e898daaf5d72ca34de17f1fc50c1fff34c2e7',
        64716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0772f043a940f5ab570bdc0f4f29667b153ac0034fb088ddbd91ce1ca2726eb7',
        64652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3fecd81fb1182916acf480c4adf937db1a4acc20836a2c495efeb2621bc9cd7e',
        64576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4edd05b2ac1a6868fed87ba9f10ce33529bd196b3e6c93e0e50342c9189e9d7b',
        64676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd87b6c0b7d67cdd62e5d2e39f05770cd2e743fc229614fe6b58a711e74ecff90',
        64692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47903071b69fab5ce58def6663aa95554b5c94fbb6a6ae7907def0a99d0523b8',
        64620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cef929ad43d71e9e9b11eb725972ea6c207a599d108cdbb81746ed0c6c3b56b9',
        64748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '31dae0e7024e52980c0fa0bc3428fcdf54703f8fe5798e103defa90255de6d91',
        64112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Tourney',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tourney font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tourney
  static TextTheme tourneyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tourney(textStyle: textTheme.displayLarge),
      displayMedium: tourney(textStyle: textTheme.displayMedium),
      displaySmall: tourney(textStyle: textTheme.displaySmall),
      headlineLarge: tourney(textStyle: textTheme.headlineLarge),
      headlineMedium: tourney(textStyle: textTheme.headlineMedium),
      headlineSmall: tourney(textStyle: textTheme.headlineSmall),
      titleLarge: tourney(textStyle: textTheme.titleLarge),
      titleMedium: tourney(textStyle: textTheme.titleMedium),
      titleSmall: tourney(textStyle: textTheme.titleSmall),
      bodyLarge: tourney(textStyle: textTheme.bodyLarge),
      bodyMedium: tourney(textStyle: textTheme.bodyMedium),
      bodySmall: tourney(textStyle: textTheme.bodySmall),
      labelLarge: tourney(textStyle: textTheme.labelLarge),
      labelMedium: tourney(textStyle: textTheme.labelMedium),
      labelSmall: tourney(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Trade Winds font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trade+Winds
  static TextStyle tradeWinds({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '252a872a37c49baa2b7f08491686adcb3d8ffa241e45e9346bb526a69672fccf',
        83508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TradeWinds',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Trade Winds font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trade+Winds
  static TextTheme tradeWindsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tradeWinds(textStyle: textTheme.displayLarge),
      displayMedium: tradeWinds(textStyle: textTheme.displayMedium),
      displaySmall: tradeWinds(textStyle: textTheme.displaySmall),
      headlineLarge: tradeWinds(textStyle: textTheme.headlineLarge),
      headlineMedium: tradeWinds(textStyle: textTheme.headlineMedium),
      headlineSmall: tradeWinds(textStyle: textTheme.headlineSmall),
      titleLarge: tradeWinds(textStyle: textTheme.titleLarge),
      titleMedium: tradeWinds(textStyle: textTheme.titleMedium),
      titleSmall: tradeWinds(textStyle: textTheme.titleSmall),
      bodyLarge: tradeWinds(textStyle: textTheme.bodyLarge),
      bodyMedium: tradeWinds(textStyle: textTheme.bodyMedium),
      bodySmall: tradeWinds(textStyle: textTheme.bodySmall),
      labelLarge: tradeWinds(textStyle: textTheme.labelLarge),
      labelMedium: tradeWinds(textStyle: textTheme.labelMedium),
      labelSmall: tradeWinds(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Train One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Train+One
  static TextStyle trainOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02805e668ac3b32000486d0fb0c5e15a0830eee2a5693ec8cd16a7260f5eac4f',
        1945180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TrainOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Train One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Train+One
  static TextTheme trainOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: trainOne(textStyle: textTheme.displayLarge),
      displayMedium: trainOne(textStyle: textTheme.displayMedium),
      displaySmall: trainOne(textStyle: textTheme.displaySmall),
      headlineLarge: trainOne(textStyle: textTheme.headlineLarge),
      headlineMedium: trainOne(textStyle: textTheme.headlineMedium),
      headlineSmall: trainOne(textStyle: textTheme.headlineSmall),
      titleLarge: trainOne(textStyle: textTheme.titleLarge),
      titleMedium: trainOne(textStyle: textTheme.titleMedium),
      titleSmall: trainOne(textStyle: textTheme.titleSmall),
      bodyLarge: trainOne(textStyle: textTheme.bodyLarge),
      bodyMedium: trainOne(textStyle: textTheme.bodyMedium),
      bodySmall: trainOne(textStyle: textTheme.bodySmall),
      labelLarge: trainOne(textStyle: textTheme.labelLarge),
      labelMedium: trainOne(textStyle: textTheme.labelMedium),
      labelSmall: trainOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Trirong font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trirong
  static TextStyle trirong({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b70c497193f211aeaa449c0f8e88b91389ac33dc5c30d61d961426e2333ccfd6',
        114784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ef4d3745bea259cb738a06d439e2cbb7b44138516dc07470b2731c18b93c26bd',
        129296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5fd71235d4d5cbfaaf9769081f251787193b1f6fcf7cf9a460f82b66eb65bae3',
        114832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '75424f3630a8bbd6276c6868e3de00e80d9d0074c5fe592f7229f8c9ed61b2cb',
        130660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03b8619acb82ad072a0dd64921d3992a2b6be44d1825c06b2c572cf70567b83b',
        115836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b635783e3b733d7928b473e369278d4eede7ebc7e0dcf66a33c1a8878d54276a',
        130640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec0188813e5eb57d4ddfd0fb0f7308a0d2d6ec78cd28129384cf95a378ebd6b9',
        116096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3ab8f99425589bbb96043d4dccbf0cf2f6f6f8545a4bea4525e192148fe0331f',
        132696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddb7f49d41e1e912b0fd25de00887f7fdd91d478fd6f770c4b6bfaca0d36a4fa',
        116388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '37a646c814469f85e077ea3c0b97a81f13d4257350c3bf9173583dce61413703',
        129380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8c07945b6b3a893482cb80fb7af2692708571ee011b2e89c77192181ca110e6',
        116124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8c4404912d4ba11cc99dd7194c2388c0cba32a87e36cfec97b626a827bbcee67',
        129528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '906a2f9bf7f58a4d796d11d69b5665021748b14755bc6fa5139da5125abb6a6b',
        116276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd1bceb1de3d844afa043c58bb97779582398eee6e8a88714ece49a2eb9a69135',
        133164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d76a0f4f823729fc9abc94656338cb285cb8d1f5532f6a0ef867ac78a6fbcfe',
        116140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0f350248e73418bc4ab4705611a3b5cb25415485c42d422ab41609a63172affe',
        132628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50937be8e1637589ed595eaa698f43a1191201adfd8e2707c2ec34214e32d54c',
        116124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '521b80e200a756bae2db43e394c8c394872b995c7a422050999a79fb309d09b9',
        132888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Trirong',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Trirong font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trirong
  static TextTheme trirongTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: trirong(textStyle: textTheme.displayLarge),
      displayMedium: trirong(textStyle: textTheme.displayMedium),
      displaySmall: trirong(textStyle: textTheme.displaySmall),
      headlineLarge: trirong(textStyle: textTheme.headlineLarge),
      headlineMedium: trirong(textStyle: textTheme.headlineMedium),
      headlineSmall: trirong(textStyle: textTheme.headlineSmall),
      titleLarge: trirong(textStyle: textTheme.titleLarge),
      titleMedium: trirong(textStyle: textTheme.titleMedium),
      titleSmall: trirong(textStyle: textTheme.titleSmall),
      bodyLarge: trirong(textStyle: textTheme.bodyLarge),
      bodyMedium: trirong(textStyle: textTheme.bodyMedium),
      bodySmall: trirong(textStyle: textTheme.bodySmall),
      labelLarge: trirong(textStyle: textTheme.labelLarge),
      labelMedium: trirong(textStyle: textTheme.labelMedium),
      labelSmall: trirong(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Trispace font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trispace
  static TextStyle trispace({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '882cfe76eedeb3a81d58595e430a26a176c7f75be826b41c78d6fcccfd69e815',
        59608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45749eb562b5c001b78b92e2b6633a8c114c1d51a51f44a2e906c62842a284c4',
        59764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3745a311ce4a0e34046a84e5aff0666f84eaa1a323655ef5d62d9c2ea77d25c4',
        59764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '368fb4e90257422b15835622d87398f037221575b7701255a9c04c85a36ae05a',
        59728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '678cf96bda4b38db1c9909070d1e7e0d74f0357917d707d5c7497374bf4b5424',
        59808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef3c3a7bcc47544d6af05719c955a534a8c761fbec89a28129e0666c0ff38d79',
        59992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9e2943c697783382293c806cd3188530dc43787a80f13dd85f2ef15c8771171',
        60084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02813fad86496a0371a95d4f334d86e4593f5af31de13b12dc07a82774ff6ea7',
        60344,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Trispace',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Trispace font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trispace
  static TextTheme trispaceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: trispace(textStyle: textTheme.displayLarge),
      displayMedium: trispace(textStyle: textTheme.displayMedium),
      displaySmall: trispace(textStyle: textTheme.displaySmall),
      headlineLarge: trispace(textStyle: textTheme.headlineLarge),
      headlineMedium: trispace(textStyle: textTheme.headlineMedium),
      headlineSmall: trispace(textStyle: textTheme.headlineSmall),
      titleLarge: trispace(textStyle: textTheme.titleLarge),
      titleMedium: trispace(textStyle: textTheme.titleMedium),
      titleSmall: trispace(textStyle: textTheme.titleSmall),
      bodyLarge: trispace(textStyle: textTheme.bodyLarge),
      bodyMedium: trispace(textStyle: textTheme.bodyMedium),
      bodySmall: trispace(textStyle: textTheme.bodySmall),
      labelLarge: trispace(textStyle: textTheme.labelLarge),
      labelMedium: trispace(textStyle: textTheme.labelMedium),
      labelSmall: trispace(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Trocchi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trocchi
  static TextStyle trocchi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c85c761f448064c4c6d75277f0386ec20c593b42ffa8ef471c85009b1f4fadb',
        41408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Trocchi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Trocchi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trocchi
  static TextTheme trocchiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: trocchi(textStyle: textTheme.displayLarge),
      displayMedium: trocchi(textStyle: textTheme.displayMedium),
      displaySmall: trocchi(textStyle: textTheme.displaySmall),
      headlineLarge: trocchi(textStyle: textTheme.headlineLarge),
      headlineMedium: trocchi(textStyle: textTheme.headlineMedium),
      headlineSmall: trocchi(textStyle: textTheme.headlineSmall),
      titleLarge: trocchi(textStyle: textTheme.titleLarge),
      titleMedium: trocchi(textStyle: textTheme.titleMedium),
      titleSmall: trocchi(textStyle: textTheme.titleSmall),
      bodyLarge: trocchi(textStyle: textTheme.bodyLarge),
      bodyMedium: trocchi(textStyle: textTheme.bodyMedium),
      bodySmall: trocchi(textStyle: textTheme.bodySmall),
      labelLarge: trocchi(textStyle: textTheme.labelLarge),
      labelMedium: trocchi(textStyle: textTheme.labelMedium),
      labelSmall: trocchi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Trochut font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trochut
  static TextStyle trochut({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c44ed0f6a6bf8d9d3685dbe5003565259286e390d5d75d618a9d91705e5d8499',
        23156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '59451bbebd50a021e0f8b48428256ae2da59f53edfcda1edb450c54173a73ff5',
        25740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81857a7c6609a2ecaec06ab5143d19a72d96520f07cb8109f2df4cc5082bb2cf',
        23104,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Trochut',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Trochut font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trochut
  static TextTheme trochutTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: trochut(textStyle: textTheme.displayLarge),
      displayMedium: trochut(textStyle: textTheme.displayMedium),
      displaySmall: trochut(textStyle: textTheme.displaySmall),
      headlineLarge: trochut(textStyle: textTheme.headlineLarge),
      headlineMedium: trochut(textStyle: textTheme.headlineMedium),
      headlineSmall: trochut(textStyle: textTheme.headlineSmall),
      titleLarge: trochut(textStyle: textTheme.titleLarge),
      titleMedium: trochut(textStyle: textTheme.titleMedium),
      titleSmall: trochut(textStyle: textTheme.titleSmall),
      bodyLarge: trochut(textStyle: textTheme.bodyLarge),
      bodyMedium: trochut(textStyle: textTheme.bodyMedium),
      bodySmall: trochut(textStyle: textTheme.bodySmall),
      labelLarge: trochut(textStyle: textTheme.labelLarge),
      labelMedium: trochut(textStyle: textTheme.labelMedium),
      labelSmall: trochut(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Truculenta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Truculenta
  static TextStyle truculenta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3e8c98a055dc1f9fbec6d712b405c59af41a28bd7dc68f707d418080dc86d6b',
        126276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ab4a4eb2918fc064f40dd33ad31c0ffb0bb5962a401740122fef4c1c2b02b1d',
        126508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b03b5ce089e7c9d9944d1f8b53cf7d507de00a64ced3c05513669f600022516d',
        126520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e11c1a88d2a596b3c589437b0be73bb1c35fa9542c7ffa596b96f358c368037a',
        126000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7168d884a00b585afc65b705c6ad80ab7684b91d7573376df8e4c79c70bd631c',
        126720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a83600123b802e6cae5a9bfd2ee3af346ec2ed7fca3713e0da5e1643ed53199',
        130444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a84bd388b6f35bcf4ee75f2af151d8c3a2b26eb7873bb64f34c65ad92724aaf8',
        130428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '920f17b546fbf0a49d0593481bfab329a4f7fd55be0516afc0c6ec379e227844',
        130596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82fd9964fb2ecaf5aa2c076bb46a100546a29f21bcedd469aeb58903bc91292c',
        130556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Truculenta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Truculenta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Truculenta
  static TextTheme truculentaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: truculenta(textStyle: textTheme.displayLarge),
      displayMedium: truculenta(textStyle: textTheme.displayMedium),
      displaySmall: truculenta(textStyle: textTheme.displaySmall),
      headlineLarge: truculenta(textStyle: textTheme.headlineLarge),
      headlineMedium: truculenta(textStyle: textTheme.headlineMedium),
      headlineSmall: truculenta(textStyle: textTheme.headlineSmall),
      titleLarge: truculenta(textStyle: textTheme.titleLarge),
      titleMedium: truculenta(textStyle: textTheme.titleMedium),
      titleSmall: truculenta(textStyle: textTheme.titleSmall),
      bodyLarge: truculenta(textStyle: textTheme.bodyLarge),
      bodyMedium: truculenta(textStyle: textTheme.bodyMedium),
      bodySmall: truculenta(textStyle: textTheme.bodySmall),
      labelLarge: truculenta(textStyle: textTheme.labelLarge),
      labelMedium: truculenta(textStyle: textTheme.labelMedium),
      labelSmall: truculenta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Trykker font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trykker
  static TextStyle trykker({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca7a70bd53438d7f42a2d42c02d3f5e43ca3cb69aef552de5383d678537109f6',
        35444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Trykker',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Trykker font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Trykker
  static TextTheme trykkerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: trykker(textStyle: textTheme.displayLarge),
      displayMedium: trykker(textStyle: textTheme.displayMedium),
      displaySmall: trykker(textStyle: textTheme.displaySmall),
      headlineLarge: trykker(textStyle: textTheme.headlineLarge),
      headlineMedium: trykker(textStyle: textTheme.headlineMedium),
      headlineSmall: trykker(textStyle: textTheme.headlineSmall),
      titleLarge: trykker(textStyle: textTheme.titleLarge),
      titleMedium: trykker(textStyle: textTheme.titleMedium),
      titleSmall: trykker(textStyle: textTheme.titleSmall),
      bodyLarge: trykker(textStyle: textTheme.bodyLarge),
      bodyMedium: trykker(textStyle: textTheme.bodyMedium),
      bodySmall: trykker(textStyle: textTheme.bodySmall),
      labelLarge: trykker(textStyle: textTheme.labelLarge),
      labelMedium: trykker(textStyle: textTheme.labelMedium),
      labelSmall: trykker(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tsukimi Rounded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tsukimi+Rounded
  static TextStyle tsukimiRounded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cac0f5b2e5eb425185fce22e6488018cf2cdd1801fd8dbeeed0e49cc1c23a054',
        66628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c49ab0b59cbe4f48a1c8debb4f80928b56e6214e206c2707d5ec645d9228aebd',
        67504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9b7f9ade3228ea3601ecbddd9b1bdc73e7d2675c7bbaf71be9ac67e33336e47',
        67608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47faf724d9bc8297377e871a6163fbd3a195e6dcaff8e0217d8f690ab81e404d',
        67444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cadcdd10455c25ab7214e01425dd61ccaa82e5255e615cb7769762b86a1e8e2e',
        67224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TsukimiRounded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tsukimi Rounded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tsukimi+Rounded
  static TextTheme tsukimiRoundedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tsukimiRounded(textStyle: textTheme.displayLarge),
      displayMedium: tsukimiRounded(textStyle: textTheme.displayMedium),
      displaySmall: tsukimiRounded(textStyle: textTheme.displaySmall),
      headlineLarge: tsukimiRounded(textStyle: textTheme.headlineLarge),
      headlineMedium: tsukimiRounded(textStyle: textTheme.headlineMedium),
      headlineSmall: tsukimiRounded(textStyle: textTheme.headlineSmall),
      titleLarge: tsukimiRounded(textStyle: textTheme.titleLarge),
      titleMedium: tsukimiRounded(textStyle: textTheme.titleMedium),
      titleSmall: tsukimiRounded(textStyle: textTheme.titleSmall),
      bodyLarge: tsukimiRounded(textStyle: textTheme.bodyLarge),
      bodyMedium: tsukimiRounded(textStyle: textTheme.bodyMedium),
      bodySmall: tsukimiRounded(textStyle: textTheme.bodySmall),
      labelLarge: tsukimiRounded(textStyle: textTheme.labelLarge),
      labelMedium: tsukimiRounded(textStyle: textTheme.labelMedium),
      labelSmall: tsukimiRounded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Tulpen One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tulpen+One
  static TextStyle tulpenOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'adbb2508cbe42b21d7ffc85a0d3f6c09c59d024e34a7a452ceb3acfb4e057bc4',
        33392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TulpenOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Tulpen One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Tulpen+One
  static TextTheme tulpenOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: tulpenOne(textStyle: textTheme.displayLarge),
      displayMedium: tulpenOne(textStyle: textTheme.displayMedium),
      displaySmall: tulpenOne(textStyle: textTheme.displaySmall),
      headlineLarge: tulpenOne(textStyle: textTheme.headlineLarge),
      headlineMedium: tulpenOne(textStyle: textTheme.headlineMedium),
      headlineSmall: tulpenOne(textStyle: textTheme.headlineSmall),
      titleLarge: tulpenOne(textStyle: textTheme.titleLarge),
      titleMedium: tulpenOne(textStyle: textTheme.titleMedium),
      titleSmall: tulpenOne(textStyle: textTheme.titleSmall),
      bodyLarge: tulpenOne(textStyle: textTheme.bodyLarge),
      bodyMedium: tulpenOne(textStyle: textTheme.bodyMedium),
      bodySmall: tulpenOne(textStyle: textTheme.bodySmall),
      labelLarge: tulpenOne(textStyle: textTheme.labelLarge),
      labelMedium: tulpenOne(textStyle: textTheme.labelMedium),
      labelSmall: tulpenOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Turret Road font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Turret+Road
  static TextStyle turretRoad({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd41a5fe6261feeee83519ec9441eec70303a4c0c19f292198e1e3b34a5da51e',
        31780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb452fc09e47e992bc96fe1a470ce2460943633bf1d46ac61539f4a40c094010',
        31532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '796291f2de8707d36b1796577d589e8d58680c0d1d013d0b2397f41f5de9fd95',
        31676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69c49148679eddabe0b53127ef09e04967d524d9621e05cd0be6f2437c59094d',
        31584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbce42fa4affa6932b52cf1f920593cbe3201c689b41316383df369e0e27cb0c',
        30892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eabc29f72bb682df39964c73202a3bf3813c825fc2aa889a68841b71d5483e87',
        31544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TurretRoad',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Turret Road font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Turret+Road
  static TextTheme turretRoadTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: turretRoad(textStyle: textTheme.displayLarge),
      displayMedium: turretRoad(textStyle: textTheme.displayMedium),
      displaySmall: turretRoad(textStyle: textTheme.displaySmall),
      headlineLarge: turretRoad(textStyle: textTheme.headlineLarge),
      headlineMedium: turretRoad(textStyle: textTheme.headlineMedium),
      headlineSmall: turretRoad(textStyle: textTheme.headlineSmall),
      titleLarge: turretRoad(textStyle: textTheme.titleLarge),
      titleMedium: turretRoad(textStyle: textTheme.titleMedium),
      titleSmall: turretRoad(textStyle: textTheme.titleSmall),
      bodyLarge: turretRoad(textStyle: textTheme.bodyLarge),
      bodyMedium: turretRoad(textStyle: textTheme.bodyMedium),
      bodySmall: turretRoad(textStyle: textTheme.bodySmall),
      labelLarge: turretRoad(textStyle: textTheme.labelLarge),
      labelMedium: turretRoad(textStyle: textTheme.labelMedium),
      labelSmall: turretRoad(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Twinkle Star font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Twinkle+Star
  static TextStyle twinkleStar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41a58b45078052f8b49c2a5f36c686f64ac9e75407b577aa2f7701b53aaef499',
        120636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'TwinkleStar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Twinkle Star font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Twinkle+Star
  static TextTheme twinkleStarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: twinkleStar(textStyle: textTheme.displayLarge),
      displayMedium: twinkleStar(textStyle: textTheme.displayMedium),
      displaySmall: twinkleStar(textStyle: textTheme.displaySmall),
      headlineLarge: twinkleStar(textStyle: textTheme.headlineLarge),
      headlineMedium: twinkleStar(textStyle: textTheme.headlineMedium),
      headlineSmall: twinkleStar(textStyle: textTheme.headlineSmall),
      titleLarge: twinkleStar(textStyle: textTheme.titleLarge),
      titleMedium: twinkleStar(textStyle: textTheme.titleMedium),
      titleSmall: twinkleStar(textStyle: textTheme.titleSmall),
      bodyLarge: twinkleStar(textStyle: textTheme.bodyLarge),
      bodyMedium: twinkleStar(textStyle: textTheme.bodyMedium),
      bodySmall: twinkleStar(textStyle: textTheme.bodySmall),
      labelLarge: twinkleStar(textStyle: textTheme.labelLarge),
      labelMedium: twinkleStar(textStyle: textTheme.labelMedium),
      labelSmall: twinkleStar(textStyle: textTheme.labelSmall),
    );
  }
}
