/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.systemchannels.PlatformViewCreationRequest;
import io.flutter.embedding.engine.systemchannels.PlatformViewTouch;
import io.flutter.embedding.engine.systemchannels.PlatformViewsChannel;
import io.flutter.plugin.platform.PlatformViewsAccessibilityDelegate;
import io.flutter.plugin.platform.PlatformViewsController;
import io.flutter.plugin.platform.PlatformViewsController2;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.TextureRegistry;

public class PlatformViewsControllerDelegator
implements PlatformViewsAccessibilityDelegate,
PlatformViewsChannel.PlatformViewsHandler {
    PlatformViewsController platformViewsController;
    PlatformViewsController2 platformViewsController2;

    public PlatformViewsControllerDelegator(PlatformViewsController platformViewsController, PlatformViewsController2 platformViewsController2) {
        this.platformViewsController = platformViewsController;
        this.platformViewsController2 = platformViewsController2;
    }

    @Override
    @Nullable
    public View getPlatformViewById(int viewId) {
        return this.platformViewsController2.getPlatformViewById(viewId) != null ? this.platformViewsController2.getPlatformViewById(viewId) : this.platformViewsController.getPlatformViewById(viewId);
    }

    @Override
    public boolean usesVirtualDisplay(int id) {
        return this.platformViewsController2.getPlatformViewById(id) != null ? this.platformViewsController2.usesVirtualDisplay(id) : this.platformViewsController.usesVirtualDisplay(id);
    }

    @Override
    public void attachAccessibilityBridge(@NonNull AccessibilityBridge accessibilityBridge) {
        this.platformViewsController.attachAccessibilityBridge(accessibilityBridge);
        this.platformViewsController2.attachAccessibilityBridge(accessibilityBridge);
    }

    @Override
    public void detachAccessibilityBridge() {
        this.platformViewsController.detachAccessibilityBridge();
        this.platformViewsController2.detachAccessibilityBridge();
    }

    @Override
    public void dispose(int viewId) {
        if (this.platformViewsController2.getPlatformViewById(viewId) != null) {
            this.platformViewsController2.channelHandler.dispose(viewId);
        } else {
            this.platformViewsController.channelHandler.dispose(viewId);
        }
    }

    @Override
    public void resize(@NonNull PlatformViewsChannel.PlatformViewResizeRequest request, @NonNull PlatformViewsChannel.PlatformViewBufferResized onComplete) {
        if (this.platformViewsController2.getPlatformViewById(request.viewId) == null) {
            this.platformViewsController.channelHandler.resize(request, onComplete);
        }
    }

    @Override
    public void offset(int viewId, double top, double left) {
        if (this.platformViewsController2.getPlatformViewById(viewId) == null) {
            this.platformViewsController.channelHandler.offset(viewId, top, left);
        }
    }

    @Override
    public void onTouch(@NonNull PlatformViewTouch touch) {
        if (this.platformViewsController2.getPlatformViewById(touch.viewId) != null) {
            this.platformViewsController2.channelHandler.onTouch(touch);
        } else {
            this.platformViewsController.channelHandler.onTouch(touch);
        }
    }

    @Override
    public void setDirection(int viewId, int direction) {
        if (this.platformViewsController2.getPlatformViewById(viewId) != null) {
            this.platformViewsController2.channelHandler.setDirection(viewId, direction);
        } else {
            this.platformViewsController.channelHandler.setDirection(viewId, direction);
        }
    }

    @Override
    public void clearFocus(int viewId) {
        if (this.platformViewsController2.getPlatformViewById(viewId) != null) {
            this.platformViewsController2.channelHandler.clearFocus(viewId);
        } else {
            this.platformViewsController.channelHandler.clearFocus(viewId);
        }
    }

    @Override
    public void synchronizeToNativeViewHierarchy(boolean yes) {
        this.platformViewsController.channelHandler.synchronizeToNativeViewHierarchy(yes);
    }

    @Override
    public boolean isHcppEnabled() {
        return this.platformViewsController2.isHcppEnabled();
    }

    @Override
    public void createForPlatformViewLayer(@NonNull PlatformViewCreationRequest request) {
        this.platformViewsController.channelHandler.createForPlatformViewLayer(request);
    }

    @Override
    public long createForTextureLayer(@NonNull PlatformViewCreationRequest request) {
        return this.platformViewsController.channelHandler.createForTextureLayer(request);
    }

    @Override
    public void createPlatformViewHcpp(@NonNull PlatformViewCreationRequest request) {
        this.platformViewsController2.channelHandler.createPlatformView(request);
    }

    public void attach(@Nullable Context context, @NonNull TextureRegistry textureRegistry, @NonNull DartExecutor dartExecutor) {
        this.platformViewsController.attach(context, textureRegistry, dartExecutor);
        this.platformViewsController2.attach(context, dartExecutor);
        this.platformViewsController.getPlatformViewsChannel().setPlatformViewsHandler(this);
    }
}

