// Copyright 2014 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/// Cache of https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry.
const languageSubtagRegistry = '''
File-Date: 2020-03-16
%%
Type: language
Subtag: aa
Description: Afar
Added: 2005-10-16
%%
Type: language
Subtag: ab
Description: Abkhazian
Added: 2005-10-16
Suppress-Script: Cyrl
%%
Type: language
Subtag: ae
Description: Avestan
Added: 2005-10-16
%%
Type: language
Subtag: af
Description: Afrikaans
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ak
Description: Akan
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: am
Description: Amharic
Added: 2005-10-16
Suppress-Script: Ethi
%%
Type: language
Subtag: an
Description: Aragonese
Added: 2005-10-16
%%
Type: language
Subtag: ar
Description: Arabic
Added: 2005-10-16
Suppress-Script: Arab
Scope: macrolanguage
%%
Type: language
Subtag: as
Description: Assamese
Added: 2005-10-16
Suppress-Script: Beng
%%
Type: language
Subtag: av
Description: Avaric
Added: 2005-10-16
%%
Type: language
Subtag: ay
Description: Aymara
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: az
Description: Azerbaijani
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: ba
Description: Bashkir
Added: 2005-10-16
%%
Type: language
Subtag: be
Description: Belarusian
Added: 2005-10-16
Suppress-Script: Cyrl
%%
Type: language
Subtag: bg
Description: Bulgarian
Added: 2005-10-16
Suppress-Script: Cyrl
%%
Type: language
Subtag: bh
Description: Bihari languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: bi
Description: Bislama
Added: 2005-10-16
%%
Type: language
Subtag: bm
Description: Bambara
Added: 2005-10-16
%%
Type: language
Subtag: bn
Description: Bengali
Description: Bangla
Added: 2005-10-16
Suppress-Script: Beng
%%
Type: language
Subtag: bo
Description: Tibetan
Added: 2005-10-16
%%
Type: language
Subtag: br
Description: Breton
Added: 2005-10-16
%%
Type: language
Subtag: bs
Description: Bosnian
Added: 2005-10-16
Suppress-Script: Latn
Macrolanguage: sh
%%
Type: language
Subtag: ca
Description: Catalan
Description: Valencian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ce
Description: Chechen
Added: 2005-10-16
%%
Type: language
Subtag: ch
Description: Chamorro
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: co
Description: Corsican
Added: 2005-10-16
%%
Type: language
Subtag: cr
Description: Cree
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: cs
Description: Czech
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: cu
Description: Church Slavic
Description: Church Slavonic
Description: Old Bulgarian
Description: Old Church Slavonic
Description: Old Slavonic
Added: 2005-10-16
%%
Type: language
Subtag: cv
Description: Chuvash
Added: 2005-10-16
%%
Type: language
Subtag: cy
Description: Welsh
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: da
Description: Danish
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: de
Description: German
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: dv
Description: Dhivehi
Description: Divehi
Description: Maldivian
Added: 2005-10-16
Suppress-Script: Thaa
%%
Type: language
Subtag: dz
Description: Dzongkha
Added: 2005-10-16
Suppress-Script: Tibt
%%
Type: language
Subtag: ee
Description: Ewe
Added: 2005-10-16
%%
Type: language
Subtag: el
Description: Modern Greek (1453-)
Added: 2005-10-16
Suppress-Script: Grek
%%
Type: language
Subtag: en
Description: English
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: eo
Description: Esperanto
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: es
Description: Spanish
Description: Castilian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: et
Description: Estonian
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: eu
Description: Basque
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: fa
Description: Persian
Added: 2005-10-16
Suppress-Script: Arab
Scope: macrolanguage
%%
Type: language
Subtag: ff
Description: Fulah
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: fi
Description: Finnish
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: fj
Description: Fijian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: fo
Description: Faroese
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: fr
Description: French
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: fy
Description: Western Frisian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ga
Description: Irish
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: gd
Description: Scottish Gaelic
Description: Gaelic
Added: 2005-10-16
%%
Type: language
Subtag: gl
Description: Galician
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: gn
Description: Guarani
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: gu
Description: Gujarati
Added: 2005-10-16
Suppress-Script: Gujr
%%
Type: language
Subtag: gv
Description: Manx
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ha
Description: Hausa
Added: 2005-10-16
%%
Type: language
Subtag: he
Description: Hebrew
Added: 2005-10-16
Suppress-Script: Hebr
%%
Type: language
Subtag: hi
Description: Hindi
Added: 2005-10-16
Suppress-Script: Deva
%%
Type: language
Subtag: ho
Description: Hiri Motu
Added: 2005-10-16
%%
Type: language
Subtag: hr
Description: Croatian
Added: 2005-10-16
Suppress-Script: Latn
Macrolanguage: sh
%%
Type: language
Subtag: ht
Description: Haitian
Description: Haitian Creole
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: hu
Description: Hungarian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: hy
Description: Armenian
Added: 2005-10-16
Suppress-Script: Armn
Comments: see also hyw
%%
Type: language
Subtag: hz
Description: Herero
Added: 2005-10-16
%%
Type: language
Subtag: ia
Description: Interlingua (International Auxiliary Language
  Association)
Added: 2005-10-16
%%
Type: language
Subtag: id
Description: Indonesian
Added: 2005-10-16
Suppress-Script: Latn
Macrolanguage: ms
%%
Type: language
Subtag: ie
Description: Interlingue
Description: Occidental
Added: 2005-10-16
%%
Type: language
Subtag: ig
Description: Igbo
Added: 2005-10-16
%%
Type: language
Subtag: ii
Description: Sichuan Yi
Description: Nuosu
Added: 2005-10-16
%%
Type: language
Subtag: ik
Description: Inupiaq
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: in
Description: Indonesian
Added: 2005-10-16
Deprecated: 1989-01-01
Preferred-Value: id
Suppress-Script: Latn
Macrolanguage: ms
%%
Type: language
Subtag: io
Description: Ido
Added: 2005-10-16
%%
Type: language
Subtag: is
Description: Icelandic
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: it
Description: Italian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: iu
Description: Inuktitut
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: iw
Description: Hebrew
Added: 2005-10-16
Deprecated: 1989-01-01
Preferred-Value: he
Suppress-Script: Hebr
%%
Type: language
Subtag: ja
Description: Japanese
Added: 2005-10-16
Suppress-Script: Jpan
%%
Type: language
Subtag: ji
Description: Yiddish
Added: 2005-10-16
Deprecated: 1989-01-01
Preferred-Value: yi
%%
Type: language
Subtag: jv
Description: Javanese
Added: 2005-10-16
%%
Type: language
Subtag: jw
Description: Javanese
Added: 2005-10-16
Deprecated: 2001-08-13
Preferred-Value: jv
Comments: published by error in Table 1 of ISO 639:1988
%%
Type: language
Subtag: ka
Description: Georgian
Added: 2005-10-16
Suppress-Script: Geor
%%
Type: language
Subtag: kg
Description: Kongo
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: ki
Description: Kikuyu
Description: Gikuyu
Added: 2005-10-16
%%
Type: language
Subtag: kj
Description: Kuanyama
Description: Kwanyama
Added: 2005-10-16
%%
Type: language
Subtag: kk
Description: Kazakh
Added: 2005-10-16
Suppress-Script: Cyrl
%%
Type: language
Subtag: kl
Description: Kalaallisut
Description: Greenlandic
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: km
Description: Khmer
Description: Central Khmer
Added: 2005-10-16
Suppress-Script: Khmr
%%
Type: language
Subtag: kn
Description: Kannada
Added: 2005-10-16
Suppress-Script: Knda
%%
Type: language
Subtag: ko
Description: Korean
Added: 2005-10-16
Suppress-Script: Kore
%%
Type: language
Subtag: kr
Description: Kanuri
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: ks
Description: Kashmiri
Added: 2005-10-16
%%
Type: language
Subtag: ku
Description: Kurdish
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: kv
Description: Komi
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: kw
Description: Cornish
Added: 2005-10-16
%%
Type: language
Subtag: ky
Description: Kirghiz
Description: Kyrgyz
Added: 2005-10-16
%%
Type: language
Subtag: la
Description: Latin
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: lb
Description: Luxembourgish
Description: Letzeburgesch
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: lg
Description: Ganda
Description: Luganda
Added: 2005-10-16
%%
Type: language
Subtag: li
Description: Limburgan
Description: Limburger
Description: Limburgish
Added: 2005-10-16
%%
Type: language
Subtag: ln
Description: Lingala
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: lo
Description: Lao
Added: 2005-10-16
Suppress-Script: Laoo
%%
Type: language
Subtag: lt
Description: Lithuanian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: lu
Description: Luba-Katanga
Added: 2005-10-16
%%
Type: language
Subtag: lv
Description: Latvian
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: mg
Description: Malagasy
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: mh
Description: Marshallese
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: mi
Description: Maori
Added: 2005-10-16
%%
Type: language
Subtag: mk
Description: Macedonian
Added: 2005-10-16
Suppress-Script: Cyrl
%%
Type: language
Subtag: ml
Description: Malayalam
Added: 2005-10-16
Suppress-Script: Mlym
%%
Type: language
Subtag: mn
Description: Mongolian
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: mo
Description: Moldavian
Description: Moldovan
Added: 2005-10-16
Deprecated: 2008-11-22
Preferred-Value: ro
Suppress-Script: Latn
%%
Type: language
Subtag: mr
Description: Marathi
Added: 2005-10-16
Suppress-Script: Deva
%%
Type: language
Subtag: ms
Description: Malay (macrolanguage)
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: mt
Description: Maltese
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: my
Description: Burmese
Added: 2005-10-16
Suppress-Script: Mymr
%%
Type: language
Subtag: na
Description: Nauru
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: nb
Description: Norwegian Bokmål
Added: 2005-10-16
Suppress-Script: Latn
Macrolanguage: no
%%
Type: language
Subtag: nd
Description: North Ndebele
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ne
Description: Nepali (macrolanguage)
Added: 2005-10-16
Suppress-Script: Deva
Scope: macrolanguage
%%
Type: language
Subtag: ng
Description: Ndonga
Added: 2005-10-16
%%
Type: language
Subtag: nl
Description: Dutch
Description: Flemish
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: nn
Description: Norwegian Nynorsk
Added: 2005-10-16
Suppress-Script: Latn
Macrolanguage: no
%%
Type: language
Subtag: no
Description: Norwegian
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: nr
Description: South Ndebele
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: nv
Description: Navajo
Description: Navaho
Added: 2005-10-16
%%
Type: language
Subtag: ny
Description: Nyanja
Description: Chewa
Description: Chichewa
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: oc
Description: Occitan (post 1500)
Added: 2005-10-16
%%
Type: language
Subtag: oj
Description: Ojibwa
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: om
Description: Oromo
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: or
Description: Oriya (macrolanguage)
Description: Odia (macrolanguage)
Added: 2005-10-16
Suppress-Script: Orya
Scope: macrolanguage
%%
Type: language
Subtag: os
Description: Ossetian
Description: Ossetic
Added: 2005-10-16
%%
Type: language
Subtag: pa
Description: Panjabi
Description: Punjabi
Added: 2005-10-16
Suppress-Script: Guru
%%
Type: language
Subtag: pi
Description: Pali
Added: 2005-10-16
%%
Type: language
Subtag: pl
Description: Polish
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ps
Description: Pushto
Description: Pashto
Added: 2005-10-16
Suppress-Script: Arab
Scope: macrolanguage
%%
Type: language
Subtag: pt
Description: Portuguese
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: qu
Description: Quechua
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: rm
Description: Romansh
Suppress-Script: Latn
Added: 2005-10-16
%%
Type: language
Subtag: rn
Description: Rundi
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ro
Description: Romanian
Description: Moldavian
Description: Moldovan
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ru
Description: Russian
Added: 2005-10-16
Suppress-Script: Cyrl
%%
Type: language
Subtag: rw
Description: Kinyarwanda
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: sa
Description: Sanskrit
Added: 2005-10-16
%%
Type: language
Subtag: sc
Description: Sardinian
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: sd
Description: Sindhi
Added: 2005-10-16
%%
Type: language
Subtag: se
Description: Northern Sami
Added: 2005-10-16
%%
Type: language
Subtag: sg
Description: Sango
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: sh
Description: Serbo-Croatian
Added: 2005-10-16
Scope: macrolanguage
Comments: sr, hr, bs are preferred for most modern uses
%%
Type: language
Subtag: si
Description: Sinhala
Description: Sinhalese
Added: 2005-10-16
Suppress-Script: Sinh
%%
Type: language
Subtag: sk
Description: Slovak
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: sl
Description: Slovenian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: sm
Description: Samoan
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: sn
Description: Shona
Added: 2005-10-16
%%
Type: language
Subtag: so
Description: Somali
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: sq
Description: Albanian
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: sr
Description: Serbian
Added: 2005-10-16
Macrolanguage: sh
Comments: see cnr for Montenegrin
%%
Type: language
Subtag: ss
Description: Swati
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: st
Description: Southern Sotho
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: su
Description: Sundanese
Added: 2005-10-16
%%
Type: language
Subtag: sv
Description: Swedish
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: sw
Description: Swahili (macrolanguage)
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: ta
Description: Tamil
Added: 2005-10-16
Suppress-Script: Taml
%%
Type: language
Subtag: te
Description: Telugu
Added: 2005-10-16
Suppress-Script: Telu
%%
Type: language
Subtag: tg
Description: Tajik
Added: 2005-10-16
%%
Type: language
Subtag: th
Description: Thai
Added: 2005-10-16
Suppress-Script: Thai
%%
Type: language
Subtag: ti
Description: Tigrinya
Added: 2005-10-16
Suppress-Script: Ethi
%%
Type: language
Subtag: tk
Description: Turkmen
Added: 2005-10-16
%%
Type: language
Subtag: tl
Description: Tagalog
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: tn
Description: Tswana
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: to
Description: Tonga (Tonga Islands)
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: tr
Description: Turkish
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ts
Description: Tsonga
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: tt
Description: Tatar
Added: 2005-10-16
%%
Type: language
Subtag: tw
Description: Twi
Added: 2005-10-16
Macrolanguage: ak
%%
Type: language
Subtag: ty
Description: Tahitian
Added: 2005-10-16
%%
Type: language
Subtag: ug
Description: Uighur
Description: Uyghur
Added: 2005-10-16
%%
Type: language
Subtag: uk
Description: Ukrainian
Added: 2005-10-16
Suppress-Script: Cyrl
%%
Type: language
Subtag: ur
Description: Urdu
Added: 2005-10-16
Suppress-Script: Arab
%%
Type: language
Subtag: uz
Description: Uzbek
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: ve
Description: Venda
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: vi
Description: Vietnamese
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: vo
Description: Volapük
Added: 2005-10-16
%%
Type: language
Subtag: wa
Description: Walloon
Added: 2005-10-16
%%
Type: language
Subtag: wo
Description: Wolof
Added: 2005-10-16
%%
Type: language
Subtag: xh
Description: Xhosa
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: yi
Description: Yiddish
Added: 2005-10-16
Suppress-Script: Hebr
Scope: macrolanguage
%%
Type: language
Subtag: yo
Description: Yoruba
Added: 2005-10-16
%%
Type: language
Subtag: za
Description: Zhuang
Description: Chuang
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: zh
Description: Chinese
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: zu
Description: Zulu
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: aaa
Description: Ghotuo
Added: 2009-07-29
%%
Type: language
Subtag: aab
Description: Alumu-Tesu
Added: 2009-07-29
%%
Type: language
Subtag: aac
Description: Ari
Added: 2009-07-29
%%
Type: language
Subtag: aad
Description: Amal
Added: 2009-07-29
%%
Type: language
Subtag: aae
Description: Arbëreshë Albanian
Added: 2009-07-29
Macrolanguage: sq
%%
Type: language
Subtag: aaf
Description: Aranadan
Added: 2009-07-29
%%
Type: language
Subtag: aag
Description: Ambrak
Added: 2009-07-29
%%
Type: language
Subtag: aah
Description: Abu' Arapesh
Added: 2009-07-29
%%
Type: language
Subtag: aai
Description: Arifama-Miniafia
Added: 2009-07-29
%%
Type: language
Subtag: aak
Description: Ankave
Added: 2009-07-29
%%
Type: language
Subtag: aal
Description: Afade
Added: 2009-07-29
%%
Type: language
Subtag: aam
Description: Aramanik
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: aas
%%
Type: language
Subtag: aan
Description: Anambé
Added: 2009-07-29
%%
Type: language
Subtag: aao
Description: Algerian Saharan Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: aap
Description: Pará Arára
Added: 2009-07-29
%%
Type: language
Subtag: aaq
Description: Eastern Abnaki
Added: 2009-07-29
%%
Type: language
Subtag: aas
Description: Aasáx
Added: 2009-07-29
%%
Type: language
Subtag: aat
Description: Arvanitika Albanian
Added: 2009-07-29
Macrolanguage: sq
%%
Type: language
Subtag: aau
Description: Abau
Added: 2009-07-29
%%
Type: language
Subtag: aav
Description: Austro-Asiatic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: aaw
Description: Solong
Added: 2009-07-29
%%
Type: language
Subtag: aax
Description: Mandobo Atas
Added: 2009-07-29
%%
Type: language
Subtag: aaz
Description: Amarasi
Added: 2009-07-29
%%
Type: language
Subtag: aba
Description: Abé
Added: 2009-07-29
%%
Type: language
Subtag: abb
Description: Bankon
Added: 2009-07-29
%%
Type: language
Subtag: abc
Description: Ambala Ayta
Added: 2009-07-29
%%
Type: language
Subtag: abd
Description: Manide
Added: 2009-07-29
%%
Type: language
Subtag: abe
Description: Western Abnaki
Added: 2009-07-29
%%
Type: language
Subtag: abf
Description: Abai Sungai
Added: 2009-07-29
%%
Type: language
Subtag: abg
Description: Abaga
Added: 2009-07-29
%%
Type: language
Subtag: abh
Description: Tajiki Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: abi
Description: Abidji
Added: 2009-07-29
%%
Type: language
Subtag: abj
Description: Aka-Bea
Added: 2009-07-29
%%
Type: language
Subtag: abl
Description: Lampung Nyo
Added: 2009-07-29
%%
Type: language
Subtag: abm
Description: Abanyom
Added: 2009-07-29
%%
Type: language
Subtag: abn
Description: Abua
Added: 2009-07-29
%%
Type: language
Subtag: abo
Description: Abon
Added: 2009-07-29
%%
Type: language
Subtag: abp
Description: Abellen Ayta
Added: 2009-07-29
%%
Type: language
Subtag: abq
Description: Abaza
Added: 2009-07-29
%%
Type: language
Subtag: abr
Description: Abron
Added: 2009-07-29
%%
Type: language
Subtag: abs
Description: Ambonese Malay
Added: 2009-07-29
%%
Type: language
Subtag: abt
Description: Ambulas
Added: 2009-07-29
%%
Type: language
Subtag: abu
Description: Abure
Added: 2009-07-29
%%
Type: language
Subtag: abv
Description: Baharna Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: abw
Description: Pal
Added: 2009-07-29
%%
Type: language
Subtag: abx
Description: Inabaknon
Added: 2009-07-29
%%
Type: language
Subtag: aby
Description: Aneme Wake
Added: 2009-07-29
%%
Type: language
Subtag: abz
Description: Abui
Added: 2009-07-29
%%
Type: language
Subtag: aca
Description: Achagua
Added: 2009-07-29
%%
Type: language
Subtag: acb
Description: Áncá
Added: 2009-07-29
%%
Type: language
Subtag: acd
Description: Gikyode
Added: 2009-07-29
%%
Type: language
Subtag: ace
Description: Achinese
Added: 2005-10-16
%%
Type: language
Subtag: acf
Description: Saint Lucian Creole French
Added: 2009-07-29
%%
Type: language
Subtag: ach
Description: Acoli
Added: 2005-10-16
%%
Type: language
Subtag: aci
Description: Aka-Cari
Added: 2009-07-29
%%
Type: language
Subtag: ack
Description: Aka-Kora
Added: 2009-07-29
%%
Type: language
Subtag: acl
Description: Akar-Bale
Added: 2009-07-29
%%
Type: language
Subtag: acm
Description: Mesopotamian Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: acn
Description: Achang
Added: 2009-07-29
%%
Type: language
Subtag: acp
Description: Eastern Acipa
Added: 2009-07-29
%%
Type: language
Subtag: acq
Description: Ta'izzi-Adeni Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: acr
Description: Achi
Added: 2009-07-29
%%
Type: language
Subtag: acs
Description: Acroá
Added: 2009-07-29
%%
Type: language
Subtag: act
Description: Achterhoeks
Added: 2009-07-29
%%
Type: language
Subtag: acu
Description: Achuar-Shiwiar
Added: 2009-07-29
%%
Type: language
Subtag: acv
Description: Achumawi
Added: 2009-07-29
%%
Type: language
Subtag: acw
Description: Hijazi Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: acx
Description: Omani Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: acy
Description: Cypriot Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: acz
Description: Acheron
Added: 2009-07-29
%%
Type: language
Subtag: ada
Description: Adangme
Added: 2005-10-16
%%
Type: language
Subtag: adb
Description: Adabe
Added: 2009-07-29
%%
Type: language
Subtag: add
Description: Lidzonka
Description: Dzodinka
Added: 2009-07-29
%%
Type: language
Subtag: ade
Description: Adele
Added: 2009-07-29
%%
Type: language
Subtag: adf
Description: Dhofari Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: adg
Description: Andegerebinha
Added: 2009-07-29
%%
Type: language
Subtag: adh
Description: Adhola
Added: 2009-07-29
%%
Type: language
Subtag: adi
Description: Adi
Added: 2009-07-29
%%
Type: language
Subtag: adj
Description: Adioukrou
Added: 2009-07-29
%%
Type: language
Subtag: adl
Description: Galo
Added: 2009-07-29
%%
Type: language
Subtag: adn
Description: Adang
Added: 2009-07-29
%%
Type: language
Subtag: ado
Description: Abu
Added: 2009-07-29
%%
Type: language
Subtag: adp
Description: Adap
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: dz
%%
Type: language
Subtag: adq
Description: Adangbe
Added: 2009-07-29
%%
Type: language
Subtag: adr
Description: Adonara
Added: 2009-07-29
%%
Type: language
Subtag: ads
Description: Adamorobe Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: adt
Description: Adnyamathanha
Added: 2009-07-29
%%
Type: language
Subtag: adu
Description: Aduge
Added: 2009-07-29
%%
Type: language
Subtag: adw
Description: Amundava
Added: 2009-07-29
%%
Type: language
Subtag: adx
Description: Amdo Tibetan
Added: 2009-07-29
%%
Type: language
Subtag: ady
Description: Adyghe
Description: Adygei
Added: 2005-10-16
%%
Type: language
Subtag: adz
Description: Adzera
Added: 2009-07-29
%%
Type: language
Subtag: aea
Description: Areba
Added: 2009-07-29
%%
Type: language
Subtag: aeb
Description: Tunisian Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: aec
Description: Saidi Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: aed
Description: Argentine Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: aee
Description: Northeast Pashai
Description: Northeast Pashayi
Added: 2009-07-29
%%
Type: language
Subtag: aek
Description: Haeke
Added: 2009-07-29
%%
Type: language
Subtag: ael
Description: Ambele
Added: 2009-07-29
%%
Type: language
Subtag: aem
Description: Arem
Added: 2009-07-29
%%
Type: language
Subtag: aen
Description: Armenian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: aeq
Description: Aer
Added: 2009-07-29
%%
Type: language
Subtag: aer
Description: Eastern Arrernte
Added: 2009-07-29
%%
Type: language
Subtag: aes
Description: Alsea
Added: 2009-07-29
%%
Type: language
Subtag: aeu
Description: Akeu
Added: 2009-07-29
%%
Type: language
Subtag: aew
Description: Ambakich
Added: 2009-07-29
%%
Type: language
Subtag: aey
Description: Amele
Added: 2009-07-29
%%
Type: language
Subtag: aez
Description: Aeka
Added: 2009-07-29
%%
Type: language
Subtag: afa
Description: Afro-Asiatic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: afb
Description: Gulf Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: afd
Description: Andai
Added: 2009-07-29
%%
Type: language
Subtag: afe
Description: Putukwam
Added: 2009-07-29
%%
Type: language
Subtag: afg
Description: Afghan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: afh
Description: Afrihili
Added: 2005-10-16
%%
Type: language
Subtag: afi
Description: Akrukay
Description: Chini
Added: 2009-07-29
%%
Type: language
Subtag: afk
Description: Nanubae
Added: 2009-07-29
%%
Type: language
Subtag: afn
Description: Defaka
Added: 2009-07-29
%%
Type: language
Subtag: afo
Description: Eloyi
Added: 2009-07-29
%%
Type: language
Subtag: afp
Description: Tapei
Added: 2009-07-29
%%
Type: language
Subtag: afs
Description: Afro-Seminole Creole
Added: 2009-07-29
%%
Type: language
Subtag: aft
Description: Afitti
Added: 2009-07-29
%%
Type: language
Subtag: afu
Description: Awutu
Added: 2009-07-29
%%
Type: language
Subtag: afz
Description: Obokuitai
Added: 2009-07-29
%%
Type: language
Subtag: aga
Description: Aguano
Added: 2009-07-29
%%
Type: language
Subtag: agb
Description: Legbo
Added: 2009-07-29
%%
Type: language
Subtag: agc
Description: Agatu
Added: 2009-07-29
%%
Type: language
Subtag: agd
Description: Agarabi
Added: 2009-07-29
%%
Type: language
Subtag: age
Description: Angal
Added: 2009-07-29
%%
Type: language
Subtag: agf
Description: Arguni
Added: 2009-07-29
%%
Type: language
Subtag: agg
Description: Angor
Added: 2009-07-29
%%
Type: language
Subtag: agh
Description: Ngelima
Added: 2009-07-29
%%
Type: language
Subtag: agi
Description: Agariya
Added: 2009-07-29
%%
Type: language
Subtag: agj
Description: Argobba
Added: 2009-07-29
%%
Type: language
Subtag: agk
Description: Isarog Agta
Added: 2009-07-29
%%
Type: language
Subtag: agl
Description: Fembe
Added: 2009-07-29
%%
Type: language
Subtag: agm
Description: Angaataha
Added: 2009-07-29
%%
Type: language
Subtag: agn
Description: Agutaynen
Added: 2009-07-29
%%
Type: language
Subtag: ago
Description: Tainae
Added: 2009-07-29
%%
Type: language
Subtag: agp
Description: Paranan
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see apf, prf
%%
Type: language
Subtag: agq
Description: Aghem
Added: 2009-07-29
%%
Type: language
Subtag: agr
Description: Aguaruna
Added: 2009-07-29
%%
Type: language
Subtag: ags
Description: Esimbi
Added: 2009-07-29
%%
Type: language
Subtag: agt
Description: Central Cagayan Agta
Added: 2009-07-29
%%
Type: language
Subtag: agu
Description: Aguacateco
Added: 2009-07-29
%%
Type: language
Subtag: agv
Description: Remontado Dumagat
Added: 2009-07-29
%%
Type: language
Subtag: agw
Description: Kahua
Added: 2009-07-29
%%
Type: language
Subtag: agx
Description: Aghul
Added: 2009-07-29
%%
Type: language
Subtag: agy
Description: Southern Alta
Added: 2009-07-29
%%
Type: language
Subtag: agz
Description: Mt. Iriga Agta
Added: 2009-07-29
%%
Type: language
Subtag: aha
Description: Ahanta
Added: 2009-07-29
%%
Type: language
Subtag: ahb
Description: Axamb
Added: 2009-07-29
%%
Type: language
Subtag: ahg
Description: Qimant
Added: 2009-07-29
%%
Type: language
Subtag: ahh
Description: Aghu
Added: 2009-07-29
%%
Type: language
Subtag: ahi
Description: Tiagbamrin Aizi
Added: 2009-07-29
%%
Type: language
Subtag: ahk
Description: Akha
Added: 2009-07-29
%%
Type: language
Subtag: ahl
Description: Igo
Added: 2009-07-29
%%
Type: language
Subtag: ahm
Description: Mobumrin Aizi
Added: 2009-07-29
%%
Type: language
Subtag: ahn
Description: Àhàn
Added: 2009-07-29
%%
Type: language
Subtag: aho
Description: Ahom
Added: 2009-07-29
%%
Type: language
Subtag: ahp
Description: Aproumu Aizi
Added: 2009-07-29
%%
Type: language
Subtag: ahr
Description: Ahirani
Added: 2009-07-29
%%
Type: language
Subtag: ahs
Description: Ashe
Added: 2009-07-29
%%
Type: language
Subtag: aht
Description: Ahtena
Added: 2009-07-29
%%
Type: language
Subtag: aia
Description: Arosi
Added: 2009-07-29
%%
Type: language
Subtag: aib
Description: Ainu (China)
Added: 2009-07-29
%%
Type: language
Subtag: aic
Description: Ainbai
Added: 2009-07-29
%%
Type: language
Subtag: aid
Description: Alngith
Added: 2009-07-29
%%
Type: language
Subtag: aie
Description: Amara
Added: 2009-07-29
%%
Type: language
Subtag: aif
Description: Agi
Added: 2009-07-29
%%
Type: language
Subtag: aig
Description: Antigua and Barbuda Creole English
Added: 2009-07-29
%%
Type: language
Subtag: aih
Description: Ai-Cham
Added: 2009-07-29
%%
Type: language
Subtag: aii
Description: Assyrian Neo-Aramaic
Added: 2009-07-29
Macrolanguage: syr
%%
Type: language
Subtag: aij
Description: Lishanid Noshan
Added: 2009-07-29
%%
Type: language
Subtag: aik
Description: Ake
Added: 2009-07-29
%%
Type: language
Subtag: ail
Description: Aimele
Added: 2009-07-29
%%
Type: language
Subtag: aim
Description: Aimol
Added: 2009-07-29
%%
Type: language
Subtag: ain
Description: Ainu (Japan)
Added: 2005-10-16
%%
Type: language
Subtag: aio
Description: Aiton
Added: 2009-07-29
%%
Type: language
Subtag: aip
Description: Burumakok
Added: 2009-07-29
%%
Type: language
Subtag: aiq
Description: Aimaq
Added: 2009-07-29
%%
Type: language
Subtag: air
Description: Airoran
Added: 2009-07-29
%%
Type: language
Subtag: ais
Description: Nataoran Amis
Added: 2009-07-29
Deprecated: 2019-04-16
Comments: see ami, szy
%%
Type: language
Subtag: ait
Description: Arikem
Added: 2009-07-29
%%
Type: language
Subtag: aiw
Description: Aari
Added: 2009-07-29
%%
Type: language
Subtag: aix
Description: Aighon
Added: 2009-07-29
%%
Type: language
Subtag: aiy
Description: Ali
Added: 2009-07-29
%%
Type: language
Subtag: aja
Description: Aja (South Sudan)
Added: 2009-07-29
%%
Type: language
Subtag: ajg
Description: Aja (Benin)
Added: 2009-07-29
%%
Type: language
Subtag: aji
Description: Ajië
Added: 2009-07-29
%%
Type: language
Subtag: ajn
Description: Andajin
Added: 2012-08-12
%%
Type: language
Subtag: ajp
Description: South Levantine Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: ajt
Description: Judeo-Tunisian Arabic
Added: 2009-07-29
Macrolanguage: jrb
%%
Type: language
Subtag: aju
Description: Judeo-Moroccan Arabic
Added: 2009-07-29
Macrolanguage: jrb
%%
Type: language
Subtag: ajw
Description: Ajawa
Added: 2009-07-29
%%
Type: language
Subtag: ajz
Description: Amri Karbi
Added: 2009-07-29
%%
Type: language
Subtag: akb
Description: Batak Angkola
Added: 2009-07-29
%%
Type: language
Subtag: akc
Description: Mpur
Added: 2009-07-29
%%
Type: language
Subtag: akd
Description: Ukpet-Ehom
Added: 2009-07-29
%%
Type: language
Subtag: ake
Description: Akawaio
Added: 2009-07-29
%%
Type: language
Subtag: akf
Description: Akpa
Added: 2009-07-29
%%
Type: language
Subtag: akg
Description: Anakalangu
Added: 2009-07-29
%%
Type: language
Subtag: akh
Description: Angal Heneng
Added: 2009-07-29
%%
Type: language
Subtag: aki
Description: Aiome
Added: 2009-07-29
%%
Type: language
Subtag: akj
Description: Aka-Jeru
Added: 2009-07-29
%%
Type: language
Subtag: akk
Description: Akkadian
Added: 2005-10-16
%%
Type: language
Subtag: akl
Description: Aklanon
Added: 2009-07-29
%%
Type: language
Subtag: akm
Description: Aka-Bo
Added: 2009-07-29
%%
Type: language
Subtag: ako
Description: Akurio
Added: 2009-07-29
%%
Type: language
Subtag: akp
Description: Siwu
Added: 2009-07-29
%%
Type: language
Subtag: akq
Description: Ak
Added: 2009-07-29
%%
Type: language
Subtag: akr
Description: Araki
Added: 2009-07-29
%%
Type: language
Subtag: aks
Description: Akaselem
Added: 2009-07-29
%%
Type: language
Subtag: akt
Description: Akolet
Added: 2009-07-29
%%
Type: language
Subtag: aku
Description: Akum
Added: 2009-07-29
%%
Type: language
Subtag: akv
Description: Akhvakh
Added: 2009-07-29
%%
Type: language
Subtag: akw
Description: Akwa
Added: 2009-07-29
%%
Type: language
Subtag: akx
Description: Aka-Kede
Added: 2009-07-29
%%
Type: language
Subtag: aky
Description: Aka-Kol
Added: 2009-07-29
%%
Type: language
Subtag: akz
Description: Alabama
Added: 2009-07-29
%%
Type: language
Subtag: ala
Description: Alago
Added: 2009-07-29
%%
Type: language
Subtag: alc
Description: Qawasqar
Added: 2009-07-29
%%
Type: language
Subtag: ald
Description: Alladian
Added: 2009-07-29
%%
Type: language
Subtag: ale
Description: Aleut
Added: 2005-10-16
%%
Type: language
Subtag: alf
Description: Alege
Added: 2009-07-29
%%
Type: language
Subtag: alg
Description: Algonquian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: alh
Description: Alawa
Added: 2009-07-29
%%
Type: language
Subtag: ali
Description: Amaimon
Added: 2009-07-29
%%
Type: language
Subtag: alj
Description: Alangan
Added: 2009-07-29
%%
Type: language
Subtag: alk
Description: Alak
Added: 2009-07-29
%%
Type: language
Subtag: all
Description: Allar
Added: 2009-07-29
%%
Type: language
Subtag: alm
Description: Amblong
Added: 2009-07-29
%%
Type: language
Subtag: aln
Description: Gheg Albanian
Added: 2009-07-29
Macrolanguage: sq
%%
Type: language
Subtag: alo
Description: Larike-Wakasihu
Added: 2009-07-29
%%
Type: language
Subtag: alp
Description: Alune
Added: 2009-07-29
%%
Type: language
Subtag: alq
Description: Algonquin
Added: 2009-07-29
%%
Type: language
Subtag: alr
Description: Alutor
Added: 2009-07-29
%%
Type: language
Subtag: als
Description: Tosk Albanian
Added: 2009-07-29
Macrolanguage: sq
%%
Type: language
Subtag: alt
Description: Southern Altai
Added: 2005-10-16
%%
Type: language
Subtag: alu
Description: 'Are'are
Added: 2009-07-29
%%
Type: language
Subtag: alv
Description: Atlantic-Congo languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: alw
Description: Alaba-K’abeena
Description: Wanbasana
Added: 2009-07-29
%%
Type: language
Subtag: alx
Description: Amol
Added: 2009-07-29
%%
Type: language
Subtag: aly
Description: Alyawarr
Added: 2009-07-29
%%
Type: language
Subtag: alz
Description: Alur
Added: 2009-07-29
%%
Type: language
Subtag: ama
Description: Amanayé
Added: 2009-07-29
%%
Type: language
Subtag: amb
Description: Ambo
Added: 2009-07-29
%%
Type: language
Subtag: amc
Description: Amahuaca
Added: 2009-07-29
%%
Type: language
Subtag: ame
Description: Yanesha'
Added: 2009-07-29
%%
Type: language
Subtag: amf
Description: Hamer-Banna
Added: 2009-07-29
%%
Type: language
Subtag: amg
Description: Amurdak
Added: 2009-07-29
%%
Type: language
Subtag: ami
Description: Amis
Added: 2009-07-29
%%
Type: language
Subtag: amj
Description: Amdang
Added: 2009-07-29
%%
Type: language
Subtag: amk
Description: Ambai
Added: 2009-07-29
%%
Type: language
Subtag: aml
Description: War-Jaintia
Added: 2009-07-29
%%
Type: language
Subtag: amm
Description: Ama (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: amn
Description: Amanab
Added: 2009-07-29
%%
Type: language
Subtag: amo
Description: Amo
Added: 2009-07-29
%%
Type: language
Subtag: amp
Description: Alamblak
Added: 2009-07-29
%%
Type: language
Subtag: amq
Description: Amahai
Added: 2009-07-29
%%
Type: language
Subtag: amr
Description: Amarakaeri
Added: 2009-07-29
%%
Type: language
Subtag: ams
Description: Southern Amami-Oshima
Added: 2009-07-29
%%
Type: language
Subtag: amt
Description: Amto
Added: 2009-07-29
%%
Type: language
Subtag: amu
Description: Guerrero Amuzgo
Added: 2009-07-29
%%
Type: language
Subtag: amv
Description: Ambelau
Added: 2009-07-29
%%
Type: language
Subtag: amw
Description: Western Neo-Aramaic
Added: 2009-07-29
%%
Type: language
Subtag: amx
Description: Anmatyerre
Added: 2009-07-29
%%
Type: language
Subtag: amy
Description: Ami
Added: 2009-07-29
%%
Type: language
Subtag: amz
Description: Atampaya
Added: 2009-07-29
%%
Type: language
Subtag: ana
Description: Andaqui
Added: 2009-07-29
%%
Type: language
Subtag: anb
Description: Andoa
Added: 2009-07-29
%%
Type: language
Subtag: anc
Description: Ngas
Added: 2009-07-29
%%
Type: language
Subtag: and
Description: Ansus
Added: 2009-07-29
%%
Type: language
Subtag: ane
Description: Xârâcùù
Added: 2009-07-29
%%
Type: language
Subtag: anf
Description: Animere
Added: 2009-07-29
%%
Type: language
Subtag: ang
Description: Old English (ca. 450-1100)
Added: 2005-10-16
%%
Type: language
Subtag: anh
Description: Nend
Added: 2009-07-29
%%
Type: language
Subtag: ani
Description: Andi
Added: 2009-07-29
%%
Type: language
Subtag: anj
Description: Anor
Added: 2009-07-29
%%
Type: language
Subtag: ank
Description: Goemai
Added: 2009-07-29
%%
Type: language
Subtag: anl
Description: Anu-Hkongso Chin
Added: 2009-07-29
%%
Type: language
Subtag: anm
Description: Anal
Added: 2009-07-29
%%
Type: language
Subtag: ann
Description: Obolo
Added: 2009-07-29
%%
Type: language
Subtag: ano
Description: Andoque
Added: 2009-07-29
%%
Type: language
Subtag: anp
Description: Angika
Added: 2006-03-08
%%
Type: language
Subtag: anq
Description: Jarawa (India)
Added: 2009-07-29
%%
Type: language
Subtag: anr
Description: Andh
Added: 2009-07-29
%%
Type: language
Subtag: ans
Description: Anserma
Added: 2009-07-29
%%
Type: language
Subtag: ant
Description: Antakarinya
Description: Antikarinya
Added: 2009-07-29
%%
Type: language
Subtag: anu
Description: Anuak
Added: 2009-07-29
%%
Type: language
Subtag: anv
Description: Denya
Added: 2009-07-29
%%
Type: language
Subtag: anw
Description: Anaang
Added: 2009-07-29
%%
Type: language
Subtag: anx
Description: Andra-Hus
Added: 2009-07-29
%%
Type: language
Subtag: any
Description: Anyin
Added: 2009-07-29
%%
Type: language
Subtag: anz
Description: Anem
Added: 2009-07-29
%%
Type: language
Subtag: aoa
Description: Angolar
Added: 2009-07-29
%%
Type: language
Subtag: aob
Description: Abom
Added: 2009-07-29
%%
Type: language
Subtag: aoc
Description: Pemon
Added: 2009-07-29
%%
Type: language
Subtag: aod
Description: Andarum
Added: 2009-07-29
%%
Type: language
Subtag: aoe
Description: Angal Enen
Added: 2009-07-29
%%
Type: language
Subtag: aof
Description: Bragat
Added: 2009-07-29
%%
Type: language
Subtag: aog
Description: Angoram
Added: 2009-07-29
%%
Type: language
Subtag: aoh
Description: Arma
Added: 2009-07-29
%%
Type: language
Subtag: aoi
Description: Anindilyakwa
Added: 2009-07-29
%%
Type: language
Subtag: aoj
Description: Mufian
Added: 2009-07-29
%%
Type: language
Subtag: aok
Description: Arhö
Added: 2009-07-29
%%
Type: language
Subtag: aol
Description: Alor
Added: 2009-07-29
%%
Type: language
Subtag: aom
Description: Ömie
Added: 2009-07-29
%%
Type: language
Subtag: aon
Description: Bumbita Arapesh
Added: 2009-07-29
%%
Type: language
Subtag: aor
Description: Aore
Added: 2009-07-29
%%
Type: language
Subtag: aos
Description: Taikat
Added: 2009-07-29
%%
Type: language
Subtag: aot
Description: Atong (India)
Description: A'tong
Added: 2009-07-29
%%
Type: language
Subtag: aou
Description: A'ou
Added: 2012-08-12
%%
Type: language
Subtag: aox
Description: Atorada
Added: 2009-07-29
%%
Type: language
Subtag: aoz
Description: Uab Meto
Added: 2009-07-29
%%
Type: language
Subtag: apa
Description: Apache languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: apb
Description: Sa'a
Added: 2009-07-29
%%
Type: language
Subtag: apc
Description: North Levantine Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: apd
Description: Sudanese Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: ape
Description: Bukiyip
Added: 2009-07-29
%%
Type: language
Subtag: apf
Description: Pahanan Agta
Added: 2010-03-11
%%
Type: language
Subtag: apg
Description: Ampanang
Added: 2009-07-29
%%
Type: language
Subtag: aph
Description: Athpariya
Added: 2009-07-29
%%
Type: language
Subtag: api
Description: Apiaká
Added: 2009-07-29
%%
Type: language
Subtag: apj
Description: Jicarilla Apache
Added: 2009-07-29
%%
Type: language
Subtag: apk
Description: Kiowa Apache
Added: 2009-07-29
%%
Type: language
Subtag: apl
Description: Lipan Apache
Added: 2009-07-29
%%
Type: language
Subtag: apm
Description: Mescalero-Chiricahua Apache
Added: 2009-07-29
%%
Type: language
Subtag: apn
Description: Apinayé
Added: 2009-07-29
%%
Type: language
Subtag: apo
Description: Ambul
Added: 2009-07-29
%%
Type: language
Subtag: app
Description: Apma
Added: 2009-07-29
%%
Type: language
Subtag: apq
Description: A-Pucikwar
Added: 2009-07-29
%%
Type: language
Subtag: apr
Description: Arop-Lokep
Added: 2009-07-29
%%
Type: language
Subtag: aps
Description: Arop-Sissano
Added: 2009-07-29
%%
Type: language
Subtag: apt
Description: Apatani
Added: 2009-07-29
%%
Type: language
Subtag: apu
Description: Apurinã
Added: 2009-07-29
%%
Type: language
Subtag: apv
Description: Alapmunte
Added: 2009-07-29
%%
Type: language
Subtag: apw
Description: Western Apache
Added: 2009-07-29
%%
Type: language
Subtag: apx
Description: Aputai
Added: 2009-07-29
%%
Type: language
Subtag: apy
Description: Apalaí
Added: 2009-07-29
%%
Type: language
Subtag: apz
Description: Safeyoka
Added: 2009-07-29
%%
Type: language
Subtag: aqa
Description: Alacalufan languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: aqc
Description: Archi
Added: 2009-07-29
%%
Type: language
Subtag: aqd
Description: Ampari Dogon
Added: 2011-08-16
%%
Type: language
Subtag: aqg
Description: Arigidi
Added: 2009-07-29
%%
Type: language
Subtag: aql
Description: Algic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: aqm
Description: Atohwaim
Added: 2009-07-29
%%
Type: language
Subtag: aqn
Description: Northern Alta
Added: 2009-07-29
%%
Type: language
Subtag: aqp
Description: Atakapa
Added: 2009-07-29
%%
Type: language
Subtag: aqr
Description: Arhâ
Added: 2009-07-29
%%
Type: language
Subtag: aqt
Description: Angaité
Added: 2014-02-28
%%
Type: language
Subtag: aqz
Description: Akuntsu
Added: 2010-03-11
%%
Type: language
Subtag: arb
Description: Standard Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: arc
Description: Official Aramaic (700-300 BCE)
Description: Imperial Aramaic (700-300 BCE)
Added: 2005-10-16
%%
Type: language
Subtag: ard
Description: Arabana
Added: 2009-07-29
%%
Type: language
Subtag: are
Description: Western Arrarnta
Added: 2009-07-29
%%
Type: language
Subtag: arh
Description: Arhuaco
Added: 2009-07-29
%%
Type: language
Subtag: ari
Description: Arikara
Added: 2009-07-29
%%
Type: language
Subtag: arj
Description: Arapaso
Added: 2009-07-29
%%
Type: language
Subtag: ark
Description: Arikapú
Added: 2009-07-29
%%
Type: language
Subtag: arl
Description: Arabela
Added: 2009-07-29
%%
Type: language
Subtag: arn
Description: Mapudungun
Description: Mapuche
Added: 2005-10-16
%%
Type: language
Subtag: aro
Description: Araona
Added: 2009-07-29
%%
Type: language
Subtag: arp
Description: Arapaho
Added: 2005-10-16
%%
Type: language
Subtag: arq
Description: Algerian Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: arr
Description: Karo (Brazil)
Added: 2009-07-29
%%
Type: language
Subtag: ars
Description: Najdi Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: art
Description: Artificial languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: aru
Description: Aruá (Amazonas State)
Description: Arawá
Added: 2009-07-29
%%
Type: language
Subtag: arv
Description: Arbore
Added: 2009-07-29
%%
Type: language
Subtag: arw
Description: Arawak
Added: 2005-10-16
%%
Type: language
Subtag: arx
Description: Aruá (Rodonia State)
Added: 2009-07-29
%%
Type: language
Subtag: ary
Description: Moroccan Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: arz
Description: Egyptian Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: asa
Description: Asu (Tanzania)
Added: 2009-07-29
%%
Type: language
Subtag: asb
Description: Assiniboine
Added: 2009-07-29
%%
Type: language
Subtag: asc
Description: Casuarina Coast Asmat
Added: 2009-07-29
%%
Type: language
Subtag: asd
Description: Asas
Added: 2009-07-29
Deprecated: 2019-04-16
Preferred-Value: snz
%%
Type: language
Subtag: ase
Description: American Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: asf
Description: Auslan
Description: Australian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: asg
Description: Cishingini
Added: 2009-07-29
%%
Type: language
Subtag: ash
Description: Abishira
Added: 2009-07-29
%%
Type: language
Subtag: asi
Description: Buruwai
Added: 2009-07-29
%%
Type: language
Subtag: asj
Description: Sari
Added: 2009-07-29
%%
Type: language
Subtag: ask
Description: Ashkun
Added: 2009-07-29
%%
Type: language
Subtag: asl
Description: Asilulu
Added: 2009-07-29
%%
Type: language
Subtag: asn
Description: Xingú Asuriní
Added: 2009-07-29
%%
Type: language
Subtag: aso
Description: Dano
Added: 2009-07-29
%%
Type: language
Subtag: asp
Description: Algerian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: asq
Description: Austrian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: asr
Description: Asuri
Added: 2009-07-29
%%
Type: language
Subtag: ass
Description: Ipulo
Added: 2009-07-29
%%
Type: language
Subtag: ast
Description: Asturian
Description: Asturleonese
Description: Bable
Description: Leonese
Added: 2005-10-16
%%
Type: language
Subtag: asu
Description: Tocantins Asurini
Added: 2009-07-29
%%
Type: language
Subtag: asv
Description: Asoa
Added: 2009-07-29
%%
Type: language
Subtag: asw
Description: Australian Aborigines Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: asx
Description: Muratayak
Added: 2009-07-29
%%
Type: language
Subtag: asy
Description: Yaosakor Asmat
Added: 2009-07-29
%%
Type: language
Subtag: asz
Description: As
Added: 2009-07-29
%%
Type: language
Subtag: ata
Description: Pele-Ata
Added: 2009-07-29
%%
Type: language
Subtag: atb
Description: Zaiwa
Added: 2009-07-29
%%
Type: language
Subtag: atc
Description: Atsahuaca
Added: 2009-07-29
%%
Type: language
Subtag: atd
Description: Ata Manobo
Added: 2009-07-29
%%
Type: language
Subtag: ate
Description: Atemble
Added: 2009-07-29
%%
Type: language
Subtag: atg
Description: Ivbie North-Okpela-Arhe
Added: 2009-07-29
%%
Type: language
Subtag: ath
Description: Athapascan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: ati
Description: Attié
Added: 2009-07-29
%%
Type: language
Subtag: atj
Description: Atikamekw
Added: 2009-07-29
%%
Type: language
Subtag: atk
Description: Ati
Added: 2009-07-29
%%
Type: language
Subtag: atl
Description: Mt. Iraya Agta
Added: 2009-07-29
%%
Type: language
Subtag: atm
Description: Ata
Added: 2009-07-29
%%
Type: language
Subtag: atn
Description: Ashtiani
Added: 2009-07-29
%%
Type: language
Subtag: ato
Description: Atong (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: atp
Description: Pudtol Atta
Added: 2009-07-29
%%
Type: language
Subtag: atq
Description: Aralle-Tabulahan
Added: 2009-07-29
%%
Type: language
Subtag: atr
Description: Waimiri-Atroari
Added: 2009-07-29
%%
Type: language
Subtag: ats
Description: Gros Ventre
Added: 2009-07-29
%%
Type: language
Subtag: att
Description: Pamplona Atta
Added: 2009-07-29
%%
Type: language
Subtag: atu
Description: Reel
Added: 2009-07-29
%%
Type: language
Subtag: atv
Description: Northern Altai
Added: 2009-07-29
%%
Type: language
Subtag: atw
Description: Atsugewi
Added: 2009-07-29
%%
Type: language
Subtag: atx
Description: Arutani
Added: 2009-07-29
%%
Type: language
Subtag: aty
Description: Aneityum
Added: 2009-07-29
%%
Type: language
Subtag: atz
Description: Arta
Added: 2009-07-29
%%
Type: language
Subtag: aua
Description: Asumboa
Added: 2009-07-29
%%
Type: language
Subtag: aub
Description: Alugu
Added: 2009-07-29
%%
Type: language
Subtag: auc
Description: Waorani
Added: 2009-07-29
%%
Type: language
Subtag: aud
Description: Anuta
Added: 2009-07-29
%%
Type: language
Subtag: aue
Description: ǂKxʼauǁʼein
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: ktz
%%
Type: language
Subtag: auf
Description: Arauan languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: aug
Description: Aguna
Added: 2009-07-29
%%
Type: language
Subtag: auh
Description: Aushi
Added: 2009-07-29
%%
Type: language
Subtag: aui
Description: Anuki
Added: 2009-07-29
%%
Type: language
Subtag: auj
Description: Awjilah
Added: 2009-07-29
%%
Type: language
Subtag: auk
Description: Heyo
Added: 2009-07-29
%%
Type: language
Subtag: aul
Description: Aulua
Added: 2009-07-29
%%
Type: language
Subtag: aum
Description: Asu (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: aun
Description: Molmo One
Added: 2009-07-29
%%
Type: language
Subtag: auo
Description: Auyokawa
Added: 2009-07-29
%%
Type: language
Subtag: aup
Description: Makayam
Added: 2009-07-29
%%
Type: language
Subtag: auq
Description: Anus
Description: Korur
Added: 2009-07-29
%%
Type: language
Subtag: aur
Description: Aruek
Added: 2009-07-29
%%
Type: language
Subtag: aus
Description: Australian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: aut
Description: Austral
Added: 2009-07-29
%%
Type: language
Subtag: auu
Description: Auye
Added: 2009-07-29
%%
Type: language
Subtag: auw
Description: Awyi
Added: 2009-07-29
%%
Type: language
Subtag: aux
Description: Aurá
Added: 2009-07-29
%%
Type: language
Subtag: auy
Description: Awiyaana
Added: 2009-07-29
%%
Type: language
Subtag: auz
Description: Uzbeki Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: avb
Description: Avau
Added: 2009-07-29
%%
Type: language
Subtag: avd
Description: Alviri-Vidari
Added: 2009-07-29
%%
Type: language
Subtag: avi
Description: Avikam
Added: 2009-07-29
%%
Type: language
Subtag: avk
Description: Kotava
Added: 2009-07-29
%%
Type: language
Subtag: avl
Description: Eastern Egyptian Bedawi Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: avm
Description: Angkamuthi
Added: 2012-08-12
%%
Type: language
Subtag: avn
Description: Avatime
Added: 2009-07-29
%%
Type: language
Subtag: avo
Description: Agavotaguerra
Added: 2009-07-29
%%
Type: language
Subtag: avs
Description: Aushiri
Added: 2009-07-29
%%
Type: language
Subtag: avt
Description: Au
Added: 2009-07-29
%%
Type: language
Subtag: avu
Description: Avokaya
Added: 2009-07-29
%%
Type: language
Subtag: avv
Description: Avá-Canoeiro
Added: 2009-07-29
%%
Type: language
Subtag: awa
Description: Awadhi
Added: 2005-10-16
%%
Type: language
Subtag: awb
Description: Awa (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: awc
Description: Cicipu
Added: 2009-07-29
%%
Type: language
Subtag: awd
Description: Arawakan languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: awe
Description: Awetí
Added: 2009-07-29
%%
Type: language
Subtag: awg
Description: Anguthimri
Added: 2012-08-12
%%
Type: language
Subtag: awh
Description: Awbono
Added: 2009-07-29
%%
Type: language
Subtag: awi
Description: Aekyom
Added: 2009-07-29
%%
Type: language
Subtag: awk
Description: Awabakal
Added: 2009-07-29
%%
Type: language
Subtag: awm
Description: Arawum
Added: 2009-07-29
%%
Type: language
Subtag: awn
Description: Awngi
Added: 2009-07-29
%%
Type: language
Subtag: awo
Description: Awak
Added: 2009-07-29
%%
Type: language
Subtag: awr
Description: Awera
Added: 2009-07-29
%%
Type: language
Subtag: aws
Description: South Awyu
Added: 2009-07-29
%%
Type: language
Subtag: awt
Description: Araweté
Added: 2009-07-29
%%
Type: language
Subtag: awu
Description: Central Awyu
Added: 2009-07-29
%%
Type: language
Subtag: awv
Description: Jair Awyu
Added: 2009-07-29
%%
Type: language
Subtag: aww
Description: Awun
Added: 2009-07-29
%%
Type: language
Subtag: awx
Description: Awara
Added: 2009-07-29
%%
Type: language
Subtag: awy
Description: Edera Awyu
Added: 2009-07-29
%%
Type: language
Subtag: axb
Description: Abipon
Added: 2009-07-29
%%
Type: language
Subtag: axe
Description: Ayerrerenge
Added: 2012-08-12
%%
Type: language
Subtag: axg
Description: Mato Grosso Arára
Added: 2009-07-29
%%
Type: language
Subtag: axk
Description: Yaka (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: axl
Description: Lower Southern Aranda
Added: 2013-09-10
%%
Type: language
Subtag: axm
Description: Middle Armenian
Added: 2009-07-29
%%
Type: language
Subtag: axx
Description: Xârâgurè
Added: 2009-07-29
%%
Type: language
Subtag: aya
Description: Awar
Added: 2009-07-29
%%
Type: language
Subtag: ayb
Description: Ayizo Gbe
Added: 2009-07-29
%%
Type: language
Subtag: ayc
Description: Southern Aymara
Added: 2009-07-29
Macrolanguage: ay
%%
Type: language
Subtag: ayd
Description: Ayabadhu
Added: 2009-07-29
%%
Type: language
Subtag: aye
Description: Ayere
Added: 2009-07-29
%%
Type: language
Subtag: ayg
Description: Ginyanga
Added: 2009-07-29
%%
Type: language
Subtag: ayh
Description: Hadrami Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: ayi
Description: Leyigha
Added: 2009-07-29
%%
Type: language
Subtag: ayk
Description: Akuku
Added: 2009-07-29
%%
Type: language
Subtag: ayl
Description: Libyan Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: ayn
Description: Sanaani Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: ayo
Description: Ayoreo
Added: 2009-07-29
%%
Type: language
Subtag: ayp
Description: North Mesopotamian Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: ayq
Description: Ayi (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: ayr
Description: Central Aymara
Added: 2009-07-29
Macrolanguage: ay
%%
Type: language
Subtag: ays
Description: Sorsogon Ayta
Added: 2009-07-29
%%
Type: language
Subtag: ayt
Description: Magbukun Ayta
Added: 2009-07-29
%%
Type: language
Subtag: ayu
Description: Ayu
Added: 2009-07-29
%%
Type: language
Subtag: ayx
Description: Ayi (China)
Added: 2009-07-29
Deprecated: 2011-08-16
Preferred-Value: nun
%%
Type: language
Subtag: ayy
Description: Tayabas Ayta
Added: 2009-07-29
%%
Type: language
Subtag: ayz
Description: Mai Brat
Added: 2009-07-29
%%
Type: language
Subtag: aza
Description: Azha
Added: 2009-07-29
%%
Type: language
Subtag: azb
Description: South Azerbaijani
Added: 2009-07-29
Macrolanguage: az
%%
Type: language
Subtag: azc
Description: Uto-Aztecan languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: azd
Description: Eastern Durango Nahuatl
Added: 2012-08-12
%%
Type: language
Subtag: azg
Description: San Pedro Amuzgos Amuzgo
Added: 2009-07-29
%%
Type: language
Subtag: azj
Description: North Azerbaijani
Added: 2009-07-29
Macrolanguage: az
%%
Type: language
Subtag: azm
Description: Ipalapa Amuzgo
Added: 2009-07-29
%%
Type: language
Subtag: azn
Description: Western Durango Nahuatl
Added: 2012-08-12
%%
Type: language
Subtag: azo
Description: Awing
Added: 2009-07-29
%%
Type: language
Subtag: azt
Description: Faire Atta
Added: 2009-07-29
%%
Type: language
Subtag: azz
Description: Highland Puebla Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: baa
Description: Babatana
Added: 2009-07-29
%%
Type: language
Subtag: bab
Description: Bainouk-Gunyuño
Added: 2009-07-29
%%
Type: language
Subtag: bac
Description: Badui
Added: 2009-07-29
%%
Type: language
Subtag: bad
Description: Banda languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: bae
Description: Baré
Added: 2009-07-29
%%
Type: language
Subtag: baf
Description: Nubaca
Added: 2009-07-29
%%
Type: language
Subtag: bag
Description: Tuki
Added: 2009-07-29
%%
Type: language
Subtag: bah
Description: Bahamas Creole English
Added: 2009-07-29
%%
Type: language
Subtag: bai
Description: Bamileke languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: baj
Description: Barakai
Added: 2009-07-29
%%
Type: language
Subtag: bal
Description: Baluchi
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: ban
Description: Balinese
Added: 2005-10-16
%%
Type: language
Subtag: bao
Description: Waimaha
Added: 2009-07-29
%%
Type: language
Subtag: bap
Description: Bantawa
Added: 2009-07-29
%%
Type: language
Subtag: bar
Description: Bavarian
Added: 2009-07-29
%%
Type: language
Subtag: bas
Description: Basa (Cameroon)
Added: 2005-10-16
%%
Type: language
Subtag: bat
Description: Baltic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: bau
Description: Bada (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: bav
Description: Vengo
Added: 2009-07-29
%%
Type: language
Subtag: baw
Description: Bambili-Bambui
Added: 2009-07-29
%%
Type: language
Subtag: bax
Description: Bamun
Added: 2009-07-29
%%
Type: language
Subtag: bay
Description: Batuley
Added: 2009-07-29
%%
Type: language
Subtag: baz
Description: Tunen
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see nvo, tvu
%%
Type: language
Subtag: bba
Description: Baatonum
Added: 2009-07-29
%%
Type: language
Subtag: bbb
Description: Barai
Added: 2009-07-29
%%
Type: language
Subtag: bbc
Description: Batak Toba
Added: 2009-07-29
%%
Type: language
Subtag: bbd
Description: Bau
Added: 2009-07-29
%%
Type: language
Subtag: bbe
Description: Bangba
Added: 2009-07-29
%%
Type: language
Subtag: bbf
Description: Baibai
Added: 2009-07-29
%%
Type: language
Subtag: bbg
Description: Barama
Added: 2009-07-29
%%
Type: language
Subtag: bbh
Description: Bugan
Added: 2009-07-29
%%
Type: language
Subtag: bbi
Description: Barombi
Added: 2009-07-29
%%
Type: language
Subtag: bbj
Description: Ghomálá'
Added: 2009-07-29
%%
Type: language
Subtag: bbk
Description: Babanki
Added: 2009-07-29
%%
Type: language
Subtag: bbl
Description: Bats
Added: 2009-07-29
%%
Type: language
Subtag: bbm
Description: Babango
Added: 2009-07-29
%%
Type: language
Subtag: bbn
Description: Uneapa
Added: 2009-07-29
%%
Type: language
Subtag: bbo
Description: Northern Bobo Madaré
Description: Konabéré
Added: 2009-07-29
%%
Type: language
Subtag: bbp
Description: West Central Banda
Added: 2009-07-29
%%
Type: language
Subtag: bbq
Description: Bamali
Added: 2009-07-29
%%
Type: language
Subtag: bbr
Description: Girawa
Added: 2009-07-29
%%
Type: language
Subtag: bbs
Description: Bakpinka
Added: 2009-07-29
%%
Type: language
Subtag: bbt
Description: Mburku
Added: 2009-07-29
%%
Type: language
Subtag: bbu
Description: Kulung (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: bbv
Description: Karnai
Added: 2009-07-29
%%
Type: language
Subtag: bbw
Description: Baba
Added: 2009-07-29
%%
Type: language
Subtag: bbx
Description: Bubia
Added: 2009-07-29
%%
Type: language
Subtag: bby
Description: Befang
Added: 2009-07-29
%%
Type: language
Subtag: bbz
Description: Babalia Creole Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: bca
Description: Central Bai
Added: 2009-07-29
%%
Type: language
Subtag: bcb
Description: Bainouk-Samik
Added: 2009-07-29
%%
Type: language
Subtag: bcc
Description: Southern Balochi
Added: 2009-07-29
Macrolanguage: bal
%%
Type: language
Subtag: bcd
Description: North Babar
Added: 2009-07-29
%%
Type: language
Subtag: bce
Description: Bamenyam
Added: 2009-07-29
%%
Type: language
Subtag: bcf
Description: Bamu
Added: 2009-07-29
%%
Type: language
Subtag: bcg
Description: Baga Pokur
Added: 2009-07-29
%%
Type: language
Subtag: bch
Description: Bariai
Added: 2009-07-29
%%
Type: language
Subtag: bci
Description: Baoulé
Added: 2009-07-29
%%
Type: language
Subtag: bcj
Description: Bardi
Added: 2009-07-29
%%
Type: language
Subtag: bck
Description: Bunuba
Added: 2009-07-29
%%
Type: language
Subtag: bcl
Description: Central Bikol
Added: 2009-07-29
Macrolanguage: bik
%%
Type: language
Subtag: bcm
Description: Bannoni
Added: 2009-07-29
%%
Type: language
Subtag: bcn
Description: Bali (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: bco
Description: Kaluli
Added: 2009-07-29
%%
Type: language
Subtag: bcp
Description: Bali (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: bcq
Description: Bench
Added: 2009-07-29
%%
Type: language
Subtag: bcr
Description: Babine
Added: 2009-07-29
%%
Type: language
Subtag: bcs
Description: Kohumono
Added: 2009-07-29
%%
Type: language
Subtag: bct
Description: Bendi
Added: 2009-07-29
%%
Type: language
Subtag: bcu
Description: Awad Bing
Added: 2009-07-29
%%
Type: language
Subtag: bcv
Description: Shoo-Minda-Nye
Added: 2009-07-29
%%
Type: language
Subtag: bcw
Description: Bana
Added: 2009-07-29
%%
Type: language
Subtag: bcy
Description: Bacama
Added: 2009-07-29
%%
Type: language
Subtag: bcz
Description: Bainouk-Gunyaamolo
Added: 2009-07-29
%%
Type: language
Subtag: bda
Description: Bayot
Added: 2009-07-29
%%
Type: language
Subtag: bdb
Description: Basap
Added: 2009-07-29
%%
Type: language
Subtag: bdc
Description: Emberá-Baudó
Added: 2009-07-29
%%
Type: language
Subtag: bdd
Description: Bunama
Added: 2009-07-29
%%
Type: language
Subtag: bde
Description: Bade
Added: 2009-07-29
%%
Type: language
Subtag: bdf
Description: Biage
Added: 2010-03-11
%%
Type: language
Subtag: bdg
Description: Bonggi
Added: 2009-07-29
%%
Type: language
Subtag: bdh
Description: Baka (South Sudan)
Added: 2009-07-29
%%
Type: language
Subtag: bdi
Description: Burun
Added: 2009-07-29
%%
Type: language
Subtag: bdj
Description: Bai (South Sudan)
Description: Bai
Added: 2009-07-29
%%
Type: language
Subtag: bdk
Description: Budukh
Added: 2009-07-29
%%
Type: language
Subtag: bdl
Description: Indonesian Bajau
Added: 2009-07-29
%%
Type: language
Subtag: bdm
Description: Buduma
Added: 2009-07-29
%%
Type: language
Subtag: bdn
Description: Baldemu
Added: 2009-07-29
%%
Type: language
Subtag: bdo
Description: Morom
Added: 2009-07-29
%%
Type: language
Subtag: bdp
Description: Bende
Added: 2009-07-29
%%
Type: language
Subtag: bdq
Description: Bahnar
Added: 2009-07-29
%%
Type: language
Subtag: bdr
Description: West Coast Bajau
Added: 2009-07-29
%%
Type: language
Subtag: bds
Description: Burunge
Added: 2009-07-29
%%
Type: language
Subtag: bdt
Description: Bokoto
Added: 2009-07-29
Macrolanguage: gba
%%
Type: language
Subtag: bdu
Description: Oroko
Added: 2009-07-29
%%
Type: language
Subtag: bdv
Description: Bodo Parja
Added: 2009-07-29
%%
Type: language
Subtag: bdw
Description: Baham
Added: 2009-07-29
%%
Type: language
Subtag: bdx
Description: Budong-Budong
Added: 2009-07-29
%%
Type: language
Subtag: bdy
Description: Bandjalang
Added: 2009-07-29
%%
Type: language
Subtag: bdz
Description: Badeshi
Added: 2009-07-29
%%
Type: language
Subtag: bea
Description: Beaver
Added: 2009-07-29
%%
Type: language
Subtag: beb
Description: Bebele
Added: 2009-07-29
%%
Type: language
Subtag: bec
Description: Iceve-Maci
Added: 2009-07-29
%%
Type: language
Subtag: bed
Description: Bedoanas
Added: 2009-07-29
%%
Type: language
Subtag: bee
Description: Byangsi
Added: 2009-07-29
%%
Type: language
Subtag: bef
Description: Benabena
Added: 2009-07-29
%%
Type: language
Subtag: beg
Description: Belait
Added: 2009-07-29
%%
Type: language
Subtag: beh
Description: Biali
Added: 2009-07-29
%%
Type: language
Subtag: bei
Description: Bekati'
Added: 2009-07-29
%%
Type: language
Subtag: bej
Description: Beja
Description: Bedawiyet
Added: 2005-10-16
%%
Type: language
Subtag: bek
Description: Bebeli
Added: 2009-07-29
%%
Type: language
Subtag: bem
Description: Bemba (Zambia)
Added: 2005-10-16
%%
Type: language
Subtag: beo
Description: Beami
Added: 2009-07-29
%%
Type: language
Subtag: bep
Description: Besoa
Added: 2009-07-29
%%
Type: language
Subtag: beq
Description: Beembe
Added: 2009-07-29
%%
Type: language
Subtag: ber
Description: Berber languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: bes
Description: Besme
Added: 2009-07-29
%%
Type: language
Subtag: bet
Description: Guiberoua Béte
Added: 2009-07-29
%%
Type: language
Subtag: beu
Description: Blagar
Added: 2009-07-29
%%
Type: language
Subtag: bev
Description: Daloa Bété
Added: 2009-07-29
%%
Type: language
Subtag: bew
Description: Betawi
Added: 2009-07-29
%%
Type: language
Subtag: bex
Description: Jur Modo
Added: 2009-07-29
%%
Type: language
Subtag: bey
Description: Beli (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: bez
Description: Bena (Tanzania)
Added: 2009-07-29
%%
Type: language
Subtag: bfa
Description: Bari
Added: 2009-07-29
%%
Type: language
Subtag: bfb
Description: Pauri Bareli
Added: 2009-07-29
%%
Type: language
Subtag: bfc
Description: Panyi Bai
Description: Northern Bai
Added: 2009-07-29
%%
Type: language
Subtag: bfd
Description: Bafut
Added: 2009-07-29
%%
Type: language
Subtag: bfe
Description: Betaf
Description: Tena
Added: 2009-07-29
%%
Type: language
Subtag: bff
Description: Bofi
Added: 2009-07-29
%%
Type: language
Subtag: bfg
Description: Busang Kayan
Added: 2009-07-29
%%
Type: language
Subtag: bfh
Description: Blafe
Added: 2009-07-29
%%
Type: language
Subtag: bfi
Description: British Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: bfj
Description: Bafanji
Added: 2009-07-29
%%
Type: language
Subtag: bfk
Description: Ban Khor Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: bfl
Description: Banda-Ndélé
Added: 2009-07-29
%%
Type: language
Subtag: bfm
Description: Mmen
Added: 2009-07-29
%%
Type: language
Subtag: bfn
Description: Bunak
Added: 2009-07-29
%%
Type: language
Subtag: bfo
Description: Malba Birifor
Added: 2009-07-29
%%
Type: language
Subtag: bfp
Description: Beba
Added: 2009-07-29
%%
Type: language
Subtag: bfq
Description: Badaga
Added: 2009-07-29
%%
Type: language
Subtag: bfr
Description: Bazigar
Added: 2009-07-29
%%
Type: language
Subtag: bfs
Description: Southern Bai
Added: 2009-07-29
%%
Type: language
Subtag: bft
Description: Balti
Added: 2009-07-29
%%
Type: language
Subtag: bfu
Description: Gahri
Added: 2009-07-29
%%
Type: language
Subtag: bfw
Description: Bondo
Added: 2009-07-29
%%
Type: language
Subtag: bfx
Description: Bantayanon
Added: 2010-03-11
%%
Type: language
Subtag: bfy
Description: Bagheli
Added: 2009-07-29
%%
Type: language
Subtag: bfz
Description: Mahasu Pahari
Added: 2009-07-29
%%
Type: language
Subtag: bga
Description: Gwamhi-Wuri
Added: 2009-07-29
%%
Type: language
Subtag: bgb
Description: Bobongko
Added: 2009-07-29
%%
Type: language
Subtag: bgc
Description: Haryanvi
Added: 2009-07-29
%%
Type: language
Subtag: bgd
Description: Rathwi Bareli
Added: 2009-07-29
%%
Type: language
Subtag: bge
Description: Bauria
Added: 2009-07-29
%%
Type: language
Subtag: bgf
Description: Bangandu
Added: 2009-07-29
%%
Type: language
Subtag: bgg
Description: Bugun
Added: 2009-07-29
%%
Type: language
Subtag: bgi
Description: Giangan
Added: 2009-07-29
%%
Type: language
Subtag: bgj
Description: Bangolan
Added: 2009-07-29
%%
Type: language
Subtag: bgk
Description: Bit
Description: Buxinhua
Added: 2009-07-29
%%
Type: language
Subtag: bgl
Description: Bo (Laos)
Added: 2009-07-29
%%
Type: language
Subtag: bgm
Description: Baga Mboteni
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: bcg
%%
Type: language
Subtag: bgn
Description: Western Balochi
Added: 2009-07-29
Macrolanguage: bal
%%
Type: language
Subtag: bgo
Description: Baga Koga
Added: 2009-07-29
%%
Type: language
Subtag: bgp
Description: Eastern Balochi
Added: 2009-07-29
Macrolanguage: bal
%%
Type: language
Subtag: bgq
Description: Bagri
Added: 2009-07-29
Macrolanguage: raj
%%
Type: language
Subtag: bgr
Description: Bawm Chin
Added: 2009-07-29
%%
Type: language
Subtag: bgs
Description: Tagabawa
Added: 2009-07-29
%%
Type: language
Subtag: bgt
Description: Bughotu
Added: 2009-07-29
%%
Type: language
Subtag: bgu
Description: Mbongno
Added: 2009-07-29
%%
Type: language
Subtag: bgv
Description: Warkay-Bipim
Added: 2009-07-29
%%
Type: language
Subtag: bgw
Description: Bhatri
Added: 2009-07-29
%%
Type: language
Subtag: bgx
Description: Balkan Gagauz Turkish
Added: 2009-07-29
%%
Type: language
Subtag: bgy
Description: Benggoi
Added: 2009-07-29
%%
Type: language
Subtag: bgz
Description: Banggai
Added: 2009-07-29
%%
Type: language
Subtag: bha
Description: Bharia
Added: 2009-07-29
%%
Type: language
Subtag: bhb
Description: Bhili
Added: 2009-07-29
%%
Type: language
Subtag: bhc
Description: Biga
Added: 2009-07-29
%%
Type: language
Subtag: bhd
Description: Bhadrawahi
Added: 2009-07-29
%%
Type: language
Subtag: bhe
Description: Bhaya
Added: 2009-07-29
%%
Type: language
Subtag: bhf
Description: Odiai
Added: 2009-07-29
%%
Type: language
Subtag: bhg
Description: Binandere
Added: 2009-07-29
%%
Type: language
Subtag: bhh
Description: Bukharic
Added: 2009-07-29
%%
Type: language
Subtag: bhi
Description: Bhilali
Added: 2009-07-29
%%
Type: language
Subtag: bhj
Description: Bahing
Added: 2009-07-29
%%
Type: language
Subtag: bhk
Description: Albay Bicolano
Added: 2009-07-29
Deprecated: 2010-03-11
Macrolanguage: bik
Comments: see fbl, lbl, rbl, ubl
%%
Type: language
Subtag: bhl
Description: Bimin
Added: 2009-07-29
%%
Type: language
Subtag: bhm
Description: Bathari
Added: 2009-07-29
%%
Type: language
Subtag: bhn
Description: Bohtan Neo-Aramaic
Added: 2009-07-29
%%
Type: language
Subtag: bho
Description: Bhojpuri
Added: 2005-10-16
%%
Type: language
Subtag: bhp
Description: Bima
Added: 2009-07-29
%%
Type: language
Subtag: bhq
Description: Tukang Besi South
Added: 2009-07-29
%%
Type: language
Subtag: bhr
Description: Bara Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: bhs
Description: Buwal
Added: 2009-07-29
%%
Type: language
Subtag: bht
Description: Bhattiyali
Added: 2009-07-29
%%
Type: language
Subtag: bhu
Description: Bhunjia
Added: 2009-07-29
%%
Type: language
Subtag: bhv
Description: Bahau
Added: 2009-07-29
%%
Type: language
Subtag: bhw
Description: Biak
Added: 2009-07-29
%%
Type: language
Subtag: bhx
Description: Bhalay
Added: 2009-07-29
%%
Type: language
Subtag: bhy
Description: Bhele
Added: 2009-07-29
%%
Type: language
Subtag: bhz
Description: Bada (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: bia
Description: Badimaya
Added: 2009-07-29
%%
Type: language
Subtag: bib
Description: Bissa
Description: Bisa
Added: 2009-07-29
%%
Type: language
Subtag: bic
Description: Bikaru
Added: 2009-07-29
%%
Type: language
Subtag: bid
Description: Bidiyo
Added: 2009-07-29
%%
Type: language
Subtag: bie
Description: Bepour
Added: 2009-07-29
%%
Type: language
Subtag: bif
Description: Biafada
Added: 2009-07-29
%%
Type: language
Subtag: big
Description: Biangai
Added: 2009-07-29
%%
Type: language
Subtag: bij
Description: Vaghat-Ya-Bijim-Legeri
Added: 2009-07-29
%%
Type: language
Subtag: bik
Description: Bikol
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: bil
Description: Bile
Added: 2009-07-29
%%
Type: language
Subtag: bim
Description: Bimoba
Added: 2009-07-29
%%
Type: language
Subtag: bin
Description: Bini
Description: Edo
Added: 2005-10-16
%%
Type: language
Subtag: bio
Description: Nai
Added: 2009-07-29
%%
Type: language
Subtag: bip
Description: Bila
Added: 2009-07-29
%%
Type: language
Subtag: biq
Description: Bipi
Added: 2009-07-29
%%
Type: language
Subtag: bir
Description: Bisorio
Added: 2009-07-29
%%
Type: language
Subtag: bit
Description: Berinomo
Added: 2009-07-29
%%
Type: language
Subtag: biu
Description: Biete
Added: 2009-07-29
%%
Type: language
Subtag: biv
Description: Southern Birifor
Added: 2009-07-29
%%
Type: language
Subtag: biw
Description: Kol (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: bix
Description: Bijori
Added: 2009-07-29
%%
Type: language
Subtag: biy
Description: Birhor
Added: 2009-07-29
%%
Type: language
Subtag: biz
Description: Baloi
Added: 2009-07-29
%%
Type: language
Subtag: bja
Description: Budza
Added: 2009-07-29
%%
Type: language
Subtag: bjb
Description: Banggarla
Added: 2009-07-29
%%
Type: language
Subtag: bjc
Description: Bariji
Added: 2009-07-29
%%
Type: language
Subtag: bjd
Description: Bandjigali
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: drl
%%
Type: language
Subtag: bje
Description: Biao-Jiao Mien
Added: 2009-07-29
%%
Type: language
Subtag: bjf
Description: Barzani Jewish Neo-Aramaic
Added: 2009-07-29
%%
Type: language
Subtag: bjg
Description: Bidyogo
Added: 2009-07-29
%%
Type: language
Subtag: bjh
Description: Bahinemo
Added: 2009-07-29
%%
Type: language
Subtag: bji
Description: Burji
Added: 2009-07-29
%%
Type: language
Subtag: bjj
Description: Kanauji
Added: 2009-07-29
%%
Type: language
Subtag: bjk
Description: Barok
Added: 2009-07-29
%%
Type: language
Subtag: bjl
Description: Bulu (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: bjm
Description: Bajelani
Added: 2009-07-29
%%
Type: language
Subtag: bjn
Description: Banjar
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: bjo
Description: Mid-Southern Banda
Added: 2009-07-29
%%
Type: language
Subtag: bjp
Description: Fanamaket
Added: 2013-09-10
%%
Type: language
Subtag: bjq
Description: Southern Betsimisaraka Malagasy
Added: 2009-07-29
Deprecated: 2011-08-16
Macrolanguage: mg
Comments: see bzc, tkg
%%
Type: language
Subtag: bjr
Description: Binumarien
Added: 2009-07-29
%%
Type: language
Subtag: bjs
Description: Bajan
Added: 2009-07-29
%%
Type: language
Subtag: bjt
Description: Balanta-Ganja
Added: 2009-07-29
%%
Type: language
Subtag: bju
Description: Busuu
Added: 2009-07-29
%%
Type: language
Subtag: bjv
Description: Bedjond
Added: 2009-07-29
%%
Type: language
Subtag: bjw
Description: Bakwé
Added: 2009-07-29
%%
Type: language
Subtag: bjx
Description: Banao Itneg
Added: 2009-07-29
%%
Type: language
Subtag: bjy
Description: Bayali
Added: 2009-07-29
%%
Type: language
Subtag: bjz
Description: Baruga
Added: 2009-07-29
%%
Type: language
Subtag: bka
Description: Kyak
Added: 2009-07-29
%%
Type: language
Subtag: bkb
Description: Finallig
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see ebk, obk
%%
Type: language
Subtag: bkc
Description: Baka (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: bkd
Description: Binukid
Description: Talaandig
Added: 2009-07-29
%%
Type: language
Subtag: bkf
Description: Beeke
Added: 2009-07-29
%%
Type: language
Subtag: bkg
Description: Buraka
Added: 2009-07-29
%%
Type: language
Subtag: bkh
Description: Bakoko
Added: 2009-07-29
%%
Type: language
Subtag: bki
Description: Baki
Added: 2009-07-29
%%
Type: language
Subtag: bkj
Description: Pande
Added: 2009-07-29
%%
Type: language
Subtag: bkk
Description: Brokskat
Added: 2009-07-29
%%
Type: language
Subtag: bkl
Description: Berik
Added: 2009-07-29
%%
Type: language
Subtag: bkm
Description: Kom (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: bkn
Description: Bukitan
Added: 2009-07-29
%%
Type: language
Subtag: bko
Description: Kwa'
Added: 2009-07-29
%%
Type: language
Subtag: bkp
Description: Boko (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: bkq
Description: Bakairí
Added: 2009-07-29
%%
Type: language
Subtag: bkr
Description: Bakumpai
Added: 2009-07-29
%%
Type: language
Subtag: bks
Description: Northern Sorsoganon
Added: 2009-07-29
%%
Type: language
Subtag: bkt
Description: Boloki
Added: 2009-07-29
%%
Type: language
Subtag: bku
Description: Buhid
Added: 2009-07-29
%%
Type: language
Subtag: bkv
Description: Bekwarra
Added: 2009-07-29
%%
Type: language
Subtag: bkw
Description: Bekwel
Added: 2009-07-29
%%
Type: language
Subtag: bkx
Description: Baikeno
Added: 2009-07-29
%%
Type: language
Subtag: bky
Description: Bokyi
Added: 2009-07-29
%%
Type: language
Subtag: bkz
Description: Bungku
Added: 2009-07-29
%%
Type: language
Subtag: bla
Description: Siksika
Added: 2005-10-16
%%
Type: language
Subtag: blb
Description: Bilua
Added: 2009-07-29
%%
Type: language
Subtag: blc
Description: Bella Coola
Added: 2009-07-29
%%
Type: language
Subtag: bld
Description: Bolango
Added: 2009-07-29
%%
Type: language
Subtag: ble
Description: Balanta-Kentohe
Added: 2009-07-29
%%
Type: language
Subtag: blf
Description: Buol
Added: 2009-07-29
%%
Type: language
Subtag: blg
Description: Balau
Added: 2009-07-29
%%
Type: language
Subtag: blh
Description: Kuwaa
Added: 2009-07-29
%%
Type: language
Subtag: bli
Description: Bolia
Added: 2009-07-29
%%
Type: language
Subtag: blj
Description: Bolongan
Added: 2009-07-29
%%
Type: language
Subtag: blk
Description: Pa'o Karen
Description: Pa'O
Added: 2009-07-29
%%
Type: language
Subtag: bll
Description: Biloxi
Added: 2009-07-29
%%
Type: language
Subtag: blm
Description: Beli (South Sudan)
Added: 2009-07-29
%%
Type: language
Subtag: bln
Description: Southern Catanduanes Bikol
Added: 2009-07-29
Macrolanguage: bik
%%
Type: language
Subtag: blo
Description: Anii
Added: 2009-07-29
%%
Type: language
Subtag: blp
Description: Blablanga
Added: 2009-07-29
%%
Type: language
Subtag: blq
Description: Baluan-Pam
Added: 2009-07-29
%%
Type: language
Subtag: blr
Description: Blang
Added: 2009-07-29
%%
Type: language
Subtag: bls
Description: Balaesang
Added: 2009-07-29
%%
Type: language
Subtag: blt
Description: Tai Dam
Added: 2009-07-29
%%
Type: language
Subtag: blv
Description: Kibala
Description: Bolo
Added: 2009-07-29
%%
Type: language
Subtag: blw
Description: Balangao
Added: 2009-07-29
%%
Type: language
Subtag: blx
Description: Mag-Indi Ayta
Added: 2009-07-29
%%
Type: language
Subtag: bly
Description: Notre
Added: 2009-07-29
%%
Type: language
Subtag: blz
Description: Balantak
Added: 2009-07-29
%%
Type: language
Subtag: bma
Description: Lame
Added: 2009-07-29
%%
Type: language
Subtag: bmb
Description: Bembe
Added: 2009-07-29
%%
Type: language
Subtag: bmc
Description: Biem
Added: 2009-07-29
%%
Type: language
Subtag: bmd
Description: Baga Manduri
Added: 2009-07-29
%%
Type: language
Subtag: bme
Description: Limassa
Added: 2009-07-29
%%
Type: language
Subtag: bmf
Description: Bom-Kim
Added: 2009-07-29
%%
Type: language
Subtag: bmg
Description: Bamwe
Added: 2009-07-29
%%
Type: language
Subtag: bmh
Description: Kein
Added: 2009-07-29
%%
Type: language
Subtag: bmi
Description: Bagirmi
Added: 2009-07-29
%%
Type: language
Subtag: bmj
Description: Bote-Majhi
Added: 2009-07-29
%%
Type: language
Subtag: bmk
Description: Ghayavi
Added: 2009-07-29
%%
Type: language
Subtag: bml
Description: Bomboli
Added: 2009-07-29
%%
Type: language
Subtag: bmm
Description: Northern Betsimisaraka Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: bmn
Description: Bina (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: bmo
Description: Bambalang
Added: 2009-07-29
%%
Type: language
Subtag: bmp
Description: Bulgebi
Added: 2009-07-29
%%
Type: language
Subtag: bmq
Description: Bomu
Added: 2009-07-29
%%
Type: language
Subtag: bmr
Description: Muinane
Added: 2009-07-29
%%
Type: language
Subtag: bms
Description: Bilma Kanuri
Added: 2009-07-29
%%
Type: language
Subtag: bmt
Description: Biao Mon
Added: 2009-07-29
%%
Type: language
Subtag: bmu
Description: Somba-Siawari
Added: 2009-07-29
%%
Type: language
Subtag: bmv
Description: Bum
Added: 2009-07-29
%%
Type: language
Subtag: bmw
Description: Bomwali
Added: 2009-07-29
%%
Type: language
Subtag: bmx
Description: Baimak
Added: 2009-07-29
%%
Type: language
Subtag: bmy
Description: Bemba (Democratic Republic of Congo)
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: bmz
Description: Baramu
Added: 2009-07-29
%%
Type: language
Subtag: bna
Description: Bonerate
Added: 2009-07-29
%%
Type: language
Subtag: bnb
Description: Bookan
Added: 2009-07-29
%%
Type: language
Subtag: bnc
Description: Bontok
Added: 2009-07-29
Scope: macrolanguage
%%
Type: language
Subtag: bnd
Description: Banda (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: bne
Description: Bintauna
Added: 2009-07-29
%%
Type: language
Subtag: bnf
Description: Masiwang
Added: 2009-07-29
%%
Type: language
Subtag: bng
Description: Benga
Added: 2009-07-29
%%
Type: language
Subtag: bni
Description: Bangi
Added: 2009-07-29
%%
Type: language
Subtag: bnj
Description: Eastern Tawbuid
Added: 2009-07-29
%%
Type: language
Subtag: bnk
Description: Bierebo
Added: 2009-07-29
%%
Type: language
Subtag: bnl
Description: Boon
Added: 2009-07-29
%%
Type: language
Subtag: bnm
Description: Batanga
Added: 2009-07-29
%%
Type: language
Subtag: bnn
Description: Bunun
Added: 2009-07-29
%%
Type: language
Subtag: bno
Description: Bantoanon
Added: 2009-07-29
%%
Type: language
Subtag: bnp
Description: Bola
Added: 2009-07-29
%%
Type: language
Subtag: bnq
Description: Bantik
Added: 2009-07-29
%%
Type: language
Subtag: bnr
Description: Butmas-Tur
Added: 2009-07-29
%%
Type: language
Subtag: bns
Description: Bundeli
Added: 2009-07-29
%%
Type: language
Subtag: bnt
Description: Bantu languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: bnu
Description: Bentong
Added: 2009-07-29
%%
Type: language
Subtag: bnv
Description: Bonerif
Description: Beneraf
Description: Edwas
Added: 2009-07-29
%%
Type: language
Subtag: bnw
Description: Bisis
Added: 2009-07-29
%%
Type: language
Subtag: bnx
Description: Bangubangu
Added: 2009-07-29
%%
Type: language
Subtag: bny
Description: Bintulu
Added: 2009-07-29
%%
Type: language
Subtag: bnz
Description: Beezen
Added: 2009-07-29
%%
Type: language
Subtag: boa
Description: Bora
Added: 2009-07-29
%%
Type: language
Subtag: bob
Description: Aweer
Added: 2009-07-29
%%
Type: language
Subtag: boe
Description: Mundabli
Added: 2009-07-29
%%
Type: language
Subtag: bof
Description: Bolon
Added: 2009-07-29
%%
Type: language
Subtag: bog
Description: Bamako Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: boh
Description: Boma
Added: 2009-07-29
%%
Type: language
Subtag: boi
Description: Barbareño
Added: 2009-07-29
%%
Type: language
Subtag: boj
Description: Anjam
Added: 2009-07-29
%%
Type: language
Subtag: bok
Description: Bonjo
Added: 2009-07-29
%%
Type: language
Subtag: bol
Description: Bole
Added: 2009-07-29
%%
Type: language
Subtag: bom
Description: Berom
Added: 2009-07-29
%%
Type: language
Subtag: bon
Description: Bine
Added: 2009-07-29
%%
Type: language
Subtag: boo
Description: Tiemacèwè Bozo
Added: 2009-07-29
%%
Type: language
Subtag: bop
Description: Bonkiman
Added: 2009-07-29
%%
Type: language
Subtag: boq
Description: Bogaya
Added: 2009-07-29
%%
Type: language
Subtag: bor
Description: Borôro
Added: 2009-07-29
%%
Type: language
Subtag: bot
Description: Bongo
Added: 2009-07-29
%%
Type: language
Subtag: bou
Description: Bondei
Added: 2009-07-29
%%
Type: language
Subtag: bov
Description: Tuwuli
Added: 2009-07-29
%%
Type: language
Subtag: bow
Description: Rema
Added: 2009-07-29
%%
Type: language
Subtag: box
Description: Buamu
Added: 2009-07-29
%%
Type: language
Subtag: boy
Description: Bodo (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: boz
Description: Tiéyaxo Bozo
Added: 2009-07-29
%%
Type: language
Subtag: bpa
Description: Daakaka
Added: 2009-07-29
%%
Type: language
Subtag: bpb
Description: Barbacoas
Added: 2009-07-29
%%
Type: language
Subtag: bpd
Description: Banda-Banda
Added: 2009-07-29
%%
Type: language
Subtag: bpg
Description: Bonggo
Added: 2009-07-29
%%
Type: language
Subtag: bph
Description: Botlikh
Added: 2009-07-29
%%
Type: language
Subtag: bpi
Description: Bagupi
Added: 2009-07-29
%%
Type: language
Subtag: bpj
Description: Binji
Added: 2009-07-29
%%
Type: language
Subtag: bpk
Description: Orowe
Description: 'Ôrôê
Added: 2009-07-29
%%
Type: language
Subtag: bpl
Description: Broome Pearling Lugger Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: bpm
Description: Biyom
Added: 2009-07-29
%%
Type: language
Subtag: bpn
Description: Dzao Min
Added: 2009-07-29
%%
Type: language
Subtag: bpo
Description: Anasi
Added: 2009-07-29
%%
Type: language
Subtag: bpp
Description: Kaure
Added: 2009-07-29
%%
Type: language
Subtag: bpq
Description: Banda Malay
Added: 2009-07-29
%%
Type: language
Subtag: bpr
Description: Koronadal Blaan
Added: 2009-07-29
%%
Type: language
Subtag: bps
Description: Sarangani Blaan
Added: 2009-07-29
%%
Type: language
Subtag: bpt
Description: Barrow Point
Added: 2009-07-29
%%
Type: language
Subtag: bpu
Description: Bongu
Added: 2009-07-29
%%
Type: language
Subtag: bpv
Description: Bian Marind
Added: 2009-07-29
%%
Type: language
Subtag: bpw
Description: Bo (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: bpx
Description: Palya Bareli
Added: 2009-07-29
%%
Type: language
Subtag: bpy
Description: Bishnupriya
Added: 2009-07-29
%%
Type: language
Subtag: bpz
Description: Bilba
Added: 2009-07-29
%%
Type: language
Subtag: bqa
Description: Tchumbuli
Added: 2009-07-29
%%
Type: language
Subtag: bqb
Description: Bagusa
Added: 2009-07-29
%%
Type: language
Subtag: bqc
Description: Boko (Benin)
Description: Boo
Added: 2009-07-29
%%
Type: language
Subtag: bqd
Description: Bung
Added: 2009-07-29
%%
Type: language
Subtag: bqf
Description: Baga Kaloum
Added: 2009-07-29
%%
Type: language
Subtag: bqg
Description: Bago-Kusuntu
Added: 2009-07-29
%%
Type: language
Subtag: bqh
Description: Baima
Added: 2009-07-29
%%
Type: language
Subtag: bqi
Description: Bakhtiari
Added: 2009-07-29
%%
Type: language
Subtag: bqj
Description: Bandial
Added: 2009-07-29
%%
Type: language
Subtag: bqk
Description: Banda-Mbrès
Added: 2009-07-29
%%
Type: language
Subtag: bql
Description: Bilakura
Added: 2009-07-29
%%
Type: language
Subtag: bqm
Description: Wumboko
Added: 2009-07-29
%%
Type: language
Subtag: bqn
Description: Bulgarian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: bqo
Description: Balo
Added: 2009-07-29
%%
Type: language
Subtag: bqp
Description: Busa
Added: 2009-07-29
%%
Type: language
Subtag: bqq
Description: Biritai
Added: 2009-07-29
%%
Type: language
Subtag: bqr
Description: Burusu
Added: 2009-07-29
%%
Type: language
Subtag: bqs
Description: Bosngun
Added: 2009-07-29
%%
Type: language
Subtag: bqt
Description: Bamukumbit
Added: 2009-07-29
%%
Type: language
Subtag: bqu
Description: Boguru
Added: 2009-07-29
%%
Type: language
Subtag: bqv
Description: Koro Wachi
Description: Begbere-Ejar
Added: 2009-07-29
%%
Type: language
Subtag: bqw
Description: Buru (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: bqx
Description: Baangi
Added: 2009-07-29
%%
Type: language
Subtag: bqy
Description: Bengkala Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: bqz
Description: Bakaka
Added: 2009-07-29
%%
Type: language
Subtag: bra
Description: Braj
Added: 2005-10-16
%%
Type: language
Subtag: brb
Description: Lave
Added: 2009-07-29
%%
Type: language
Subtag: brc
Description: Berbice Creole Dutch
Added: 2009-07-29
%%
Type: language
Subtag: brd
Description: Baraamu
Added: 2009-07-29
%%
Type: language
Subtag: brf
Description: Bera
Added: 2009-07-29
%%
Type: language
Subtag: brg
Description: Baure
Added: 2009-07-29
%%
Type: language
Subtag: brh
Description: Brahui
Added: 2009-07-29
%%
Type: language
Subtag: bri
Description: Mokpwe
Added: 2009-07-29
%%
Type: language
Subtag: brj
Description: Bieria
Added: 2009-07-29
%%
Type: language
Subtag: brk
Description: Birked
Added: 2009-07-29
%%
Type: language
Subtag: brl
Description: Birwa
Added: 2009-07-29
%%
Type: language
Subtag: brm
Description: Barambu
Added: 2009-07-29
%%
Type: language
Subtag: brn
Description: Boruca
Added: 2009-07-29
%%
Type: language
Subtag: bro
Description: Brokkat
Added: 2009-07-29
%%
Type: language
Subtag: brp
Description: Barapasi
Added: 2009-07-29
%%
Type: language
Subtag: brq
Description: Breri
Added: 2009-07-29
%%
Type: language
Subtag: brr
Description: Birao
Added: 2009-07-29
%%
Type: language
Subtag: brs
Description: Baras
Added: 2009-07-29
%%
Type: language
Subtag: brt
Description: Bitare
Added: 2009-07-29
%%
Type: language
Subtag: bru
Description: Eastern Bru
Added: 2009-07-29
%%
Type: language
Subtag: brv
Description: Western Bru
Added: 2009-07-29
%%
Type: language
Subtag: brw
Description: Bellari
Added: 2009-07-29
%%
Type: language
Subtag: brx
Description: Bodo (India)
Added: 2009-07-29
%%
Type: language
Subtag: bry
Description: Burui
Added: 2009-07-29
%%
Type: language
Subtag: brz
Description: Bilbil
Added: 2009-07-29
%%
Type: language
Subtag: bsa
Description: Abinomn
Added: 2009-07-29
%%
Type: language
Subtag: bsb
Description: Brunei Bisaya
Added: 2009-07-29
%%
Type: language
Subtag: bsc
Description: Bassari
Description: Oniyan
Added: 2009-07-29
%%
Type: language
Subtag: bse
Description: Wushi
Added: 2009-07-29
%%
Type: language
Subtag: bsf
Description: Bauchi
Added: 2009-07-29
%%
Type: language
Subtag: bsg
Description: Bashkardi
Added: 2009-07-29
%%
Type: language
Subtag: bsh
Description: Kati
Added: 2009-07-29
%%
Type: language
Subtag: bsi
Description: Bassossi
Added: 2009-07-29
%%
Type: language
Subtag: bsj
Description: Bangwinji
Added: 2009-07-29
%%
Type: language
Subtag: bsk
Description: Burushaski
Added: 2009-07-29
%%
Type: language
Subtag: bsl
Description: Basa-Gumna
Added: 2009-07-29
%%
Type: language
Subtag: bsm
Description: Busami
Added: 2009-07-29
%%
Type: language
Subtag: bsn
Description: Barasana-Eduria
Added: 2009-07-29
%%
Type: language
Subtag: bso
Description: Buso
Added: 2009-07-29
%%
Type: language
Subtag: bsp
Description: Baga Sitemu
Added: 2009-07-29
%%
Type: language
Subtag: bsq
Description: Bassa
Added: 2009-07-29
%%
Type: language
Subtag: bsr
Description: Bassa-Kontagora
Added: 2009-07-29
%%
Type: language
Subtag: bss
Description: Akoose
Added: 2009-07-29
%%
Type: language
Subtag: bst
Description: Basketo
Added: 2009-07-29
%%
Type: language
Subtag: bsu
Description: Bahonsuai
Added: 2009-07-29
%%
Type: language
Subtag: bsv
Description: Baga Sobané
Added: 2009-07-29
%%
Type: language
Subtag: bsw
Description: Baiso
Added: 2009-07-29
%%
Type: language
Subtag: bsx
Description: Yangkam
Added: 2009-07-29
%%
Type: language
Subtag: bsy
Description: Sabah Bisaya
Added: 2009-07-29
%%
Type: language
Subtag: bta
Description: Bata
Added: 2009-07-29
%%
Type: language
Subtag: btb
Description: Beti (Cameroon)
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see beb, bum, bxp, eto, ewo, fan, mct
%%
Type: language
Subtag: btc
Description: Bati (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: btd
Description: Batak Dairi
Added: 2009-07-29
%%
Type: language
Subtag: bte
Description: Gamo-Ningi
Added: 2009-07-29
%%
Type: language
Subtag: btf
Description: Birgit
Added: 2009-07-29
%%
Type: language
Subtag: btg
Description: Gagnoa Bété
Added: 2009-07-29
%%
Type: language
Subtag: bth
Description: Biatah Bidayuh
Added: 2009-07-29
%%
Type: language
Subtag: bti
Description: Burate
Added: 2009-07-29
%%
Type: language
Subtag: btj
Description: Bacanese Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: btk
Description: Batak languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: btl
Description: Bhatola
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: btm
Description: Batak Mandailing
Added: 2009-07-29
%%
Type: language
Subtag: btn
Description: Ratagnon
Added: 2009-07-29
%%
Type: language
Subtag: bto
Description: Rinconada Bikol
Added: 2009-07-29
Macrolanguage: bik
%%
Type: language
Subtag: btp
Description: Budibud
Added: 2009-07-29
%%
Type: language
Subtag: btq
Description: Batek
Added: 2009-07-29
%%
Type: language
Subtag: btr
Description: Baetora
Added: 2009-07-29
%%
Type: language
Subtag: bts
Description: Batak Simalungun
Added: 2009-07-29
%%
Type: language
Subtag: btt
Description: Bete-Bendi
Added: 2009-07-29
%%
Type: language
Subtag: btu
Description: Batu
Added: 2009-07-29
%%
Type: language
Subtag: btv
Description: Bateri
Added: 2009-07-29
%%
Type: language
Subtag: btw
Description: Butuanon
Added: 2009-07-29
%%
Type: language
Subtag: btx
Description: Batak Karo
Added: 2009-07-29
%%
Type: language
Subtag: bty
Description: Bobot
Added: 2009-07-29
%%
Type: language
Subtag: btz
Description: Batak Alas-Kluet
Added: 2009-07-29
%%
Type: language
Subtag: bua
Description: Buriat
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: bub
Description: Bua
Added: 2009-07-29
%%
Type: language
Subtag: buc
Description: Bushi
Added: 2009-07-29
%%
Type: language
Subtag: bud
Description: Ntcham
Added: 2009-07-29
%%
Type: language
Subtag: bue
Description: Beothuk
Added: 2009-07-29
%%
Type: language
Subtag: buf
Description: Bushoong
Added: 2009-07-29
%%
Type: language
Subtag: bug
Description: Buginese
Added: 2005-10-16
%%
Type: language
Subtag: buh
Description: Younuo Bunu
Added: 2009-07-29
%%
Type: language
Subtag: bui
Description: Bongili
Added: 2009-07-29
%%
Type: language
Subtag: buj
Description: Basa-Gurmana
Added: 2009-07-29
%%
Type: language
Subtag: buk
Description: Bugawac
Added: 2009-07-29
%%
Type: language
Subtag: bum
Description: Bulu (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: bun
Description: Sherbro
Added: 2009-07-29
%%
Type: language
Subtag: buo
Description: Terei
Added: 2009-07-29
%%
Type: language
Subtag: bup
Description: Busoa
Added: 2009-07-29
%%
Type: language
Subtag: buq
Description: Brem
Added: 2009-07-29
%%
Type: language
Subtag: bus
Description: Bokobaru
Added: 2009-07-29
%%
Type: language
Subtag: but
Description: Bungain
Added: 2009-07-29
%%
Type: language
Subtag: buu
Description: Budu
Added: 2009-07-29
%%
Type: language
Subtag: buv
Description: Bun
Added: 2009-07-29
%%
Type: language
Subtag: buw
Description: Bubi
Added: 2009-07-29
%%
Type: language
Subtag: bux
Description: Boghom
Added: 2009-07-29
%%
Type: language
Subtag: buy
Description: Bullom So
Added: 2009-07-29
%%
Type: language
Subtag: buz
Description: Bukwen
Added: 2009-07-29
%%
Type: language
Subtag: bva
Description: Barein
Added: 2009-07-29
%%
Type: language
Subtag: bvb
Description: Bube
Added: 2009-07-29
%%
Type: language
Subtag: bvc
Description: Baelelea
Added: 2009-07-29
%%
Type: language
Subtag: bvd
Description: Baeggu
Added: 2009-07-29
%%
Type: language
Subtag: bve
Description: Berau Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: bvf
Description: Boor
Added: 2009-07-29
%%
Type: language
Subtag: bvg
Description: Bonkeng
Added: 2009-07-29
%%
Type: language
Subtag: bvh
Description: Bure
Added: 2009-07-29
%%
Type: language
Subtag: bvi
Description: Belanda Viri
Added: 2009-07-29
%%
Type: language
Subtag: bvj
Description: Baan
Added: 2009-07-29
%%
Type: language
Subtag: bvk
Description: Bukat
Added: 2009-07-29
%%
Type: language
Subtag: bvl
Description: Bolivian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: bvm
Description: Bamunka
Added: 2009-07-29
%%
Type: language
Subtag: bvn
Description: Buna
Added: 2009-07-29
%%
Type: language
Subtag: bvo
Description: Bolgo
Added: 2009-07-29
%%
Type: language
Subtag: bvp
Description: Bumang
Added: 2013-09-10
%%
Type: language
Subtag: bvq
Description: Birri
Added: 2009-07-29
%%
Type: language
Subtag: bvr
Description: Burarra
Added: 2009-07-29
%%
Type: language
Subtag: bvt
Description: Bati (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: bvu
Description: Bukit Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: bvv
Description: Baniva
Added: 2009-07-29
%%
Type: language
Subtag: bvw
Description: Boga
Added: 2009-07-29
%%
Type: language
Subtag: bvx
Description: Dibole
Added: 2009-07-29
%%
Type: language
Subtag: bvy
Description: Baybayanon
Added: 2010-03-11
%%
Type: language
Subtag: bvz
Description: Bauzi
Added: 2009-07-29
%%
Type: language
Subtag: bwa
Description: Bwatoo
Added: 2009-07-29
%%
Type: language
Subtag: bwb
Description: Namosi-Naitasiri-Serua
Added: 2009-07-29
%%
Type: language
Subtag: bwc
Description: Bwile
Added: 2009-07-29
%%
Type: language
Subtag: bwd
Description: Bwaidoka
Added: 2009-07-29
%%
Type: language
Subtag: bwe
Description: Bwe Karen
Added: 2009-07-29
%%
Type: language
Subtag: bwf
Description: Boselewa
Added: 2009-07-29
%%
Type: language
Subtag: bwg
Description: Barwe
Added: 2009-07-29
%%
Type: language
Subtag: bwh
Description: Bishuo
Added: 2009-07-29
%%
Type: language
Subtag: bwi
Description: Baniwa
Added: 2009-07-29
%%
Type: language
Subtag: bwj
Description: Láá Láá Bwamu
Added: 2009-07-29
%%
Type: language
Subtag: bwk
Description: Bauwaki
Added: 2009-07-29
%%
Type: language
Subtag: bwl
Description: Bwela
Added: 2009-07-29
%%
Type: language
Subtag: bwm
Description: Biwat
Added: 2009-07-29
%%
Type: language
Subtag: bwn
Description: Wunai Bunu
Added: 2009-07-29
%%
Type: language
Subtag: bwo
Description: Boro (Ethiopia)
Description: Borna (Ethiopia)
Added: 2009-07-29
%%
Type: language
Subtag: bwp
Description: Mandobo Bawah
Added: 2009-07-29
%%
Type: language
Subtag: bwq
Description: Southern Bobo Madaré
Added: 2009-07-29
%%
Type: language
Subtag: bwr
Description: Bura-Pabir
Added: 2009-07-29
%%
Type: language
Subtag: bws
Description: Bomboma
Added: 2009-07-29
%%
Type: language
Subtag: bwt
Description: Bafaw-Balong
Added: 2009-07-29
%%
Type: language
Subtag: bwu
Description: Buli (Ghana)
Added: 2009-07-29
%%
Type: language
Subtag: bww
Description: Bwa
Added: 2009-07-29
%%
Type: language
Subtag: bwx
Description: Bu-Nao Bunu
Added: 2009-07-29
%%
Type: language
Subtag: bwy
Description: Cwi Bwamu
Added: 2009-07-29
%%
Type: language
Subtag: bwz
Description: Bwisi
Added: 2009-07-29
%%
Type: language
Subtag: bxa
Description: Tairaha
Added: 2009-07-29
%%
Type: language
Subtag: bxb
Description: Belanda Bor
Added: 2009-07-29
%%
Type: language
Subtag: bxc
Description: Molengue
Added: 2009-07-29
%%
Type: language
Subtag: bxd
Description: Pela
Added: 2009-07-29
%%
Type: language
Subtag: bxe
Description: Birale
Added: 2009-07-29
%%
Type: language
Subtag: bxf
Description: Bilur
Description: Minigir
Added: 2009-07-29
Comments: see also vmg
%%
Type: language
Subtag: bxg
Description: Bangala
Added: 2009-07-29
%%
Type: language
Subtag: bxh
Description: Buhutu
Added: 2009-07-29
%%
Type: language
Subtag: bxi
Description: Pirlatapa
Added: 2009-07-29
%%
Type: language
Subtag: bxj
Description: Bayungu
Added: 2009-07-29
%%
Type: language
Subtag: bxk
Description: Bukusu
Description: Lubukusu
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: bxl
Description: Jalkunan
Added: 2009-07-29
%%
Type: language
Subtag: bxm
Description: Mongolia Buriat
Added: 2009-07-29
Macrolanguage: bua
%%
Type: language
Subtag: bxn
Description: Burduna
Added: 2009-07-29
%%
Type: language
Subtag: bxo
Description: Barikanchi
Added: 2009-07-29
%%
Type: language
Subtag: bxp
Description: Bebil
Added: 2009-07-29
%%
Type: language
Subtag: bxq
Description: Beele
Added: 2009-07-29
%%
Type: language
Subtag: bxr
Description: Russia Buriat
Added: 2009-07-29
Macrolanguage: bua
%%
Type: language
Subtag: bxs
Description: Busam
Added: 2009-07-29
%%
Type: language
Subtag: bxu
Description: China Buriat
Added: 2009-07-29
Macrolanguage: bua
%%
Type: language
Subtag: bxv
Description: Berakou
Added: 2009-07-29
%%
Type: language
Subtag: bxw
Description: Bankagooma
Added: 2009-07-29
%%
Type: language
Subtag: bxx
Description: Borna (Democratic Republic of Congo)
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: bxz
Description: Binahari
Added: 2009-07-29
%%
Type: language
Subtag: bya
Description: Batak
Added: 2009-07-29
%%
Type: language
Subtag: byb
Description: Bikya
Added: 2009-07-29
%%
Type: language
Subtag: byc
Description: Ubaghara
Added: 2009-07-29
%%
Type: language
Subtag: byd
Description: Benyadu'
Added: 2009-07-29
%%
Type: language
Subtag: bye
Description: Pouye
Added: 2009-07-29
%%
Type: language
Subtag: byf
Description: Bete
Added: 2009-07-29
%%
Type: language
Subtag: byg
Description: Baygo
Added: 2009-07-29
%%
Type: language
Subtag: byh
Description: Bhujel
Added: 2009-07-29
%%
Type: language
Subtag: byi
Description: Buyu
Added: 2009-07-29
%%
Type: language
Subtag: byj
Description: Bina (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: byk
Description: Biao
Added: 2009-07-29
%%
Type: language
Subtag: byl
Description: Bayono
Added: 2009-07-29
%%
Type: language
Subtag: bym
Description: Bidjara
Added: 2009-07-29
%%
Type: language
Subtag: byn
Description: Bilin
Description: Blin
Added: 2005-10-16
%%
Type: language
Subtag: byo
Description: Biyo
Added: 2009-07-29
%%
Type: language
Subtag: byp
Description: Bumaji
Added: 2009-07-29
%%
Type: language
Subtag: byq
Description: Basay
Added: 2009-07-29
%%
Type: language
Subtag: byr
Description: Baruya
Description: Yipma
Added: 2009-07-29
%%
Type: language
Subtag: bys
Description: Burak
Added: 2009-07-29
%%
Type: language
Subtag: byt
Description: Berti
Added: 2009-07-29
%%
Type: language
Subtag: byv
Description: Medumba
Added: 2009-07-29
%%
Type: language
Subtag: byw
Description: Belhariya
Added: 2009-07-29
%%
Type: language
Subtag: byx
Description: Qaqet
Added: 2009-07-29
%%
Type: language
Subtag: byy
Description: Buya
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: byz
Description: Banaro
Added: 2009-07-29
%%
Type: language
Subtag: bza
Description: Bandi
Added: 2009-07-29
%%
Type: language
Subtag: bzb
Description: Andio
Added: 2009-07-29
%%
Type: language
Subtag: bzc
Description: Southern Betsimisaraka Malagasy
Added: 2011-08-16
Macrolanguage: mg
%%
Type: language
Subtag: bzd
Description: Bribri
Added: 2009-07-29
%%
Type: language
Subtag: bze
Description: Jenaama Bozo
Added: 2009-07-29
%%
Type: language
Subtag: bzf
Description: Boikin
Added: 2009-07-29
%%
Type: language
Subtag: bzg
Description: Babuza
Added: 2009-07-29
%%
Type: language
Subtag: bzh
Description: Mapos Buang
Added: 2009-07-29
%%
Type: language
Subtag: bzi
Description: Bisu
Added: 2009-07-29
%%
Type: language
Subtag: bzj
Description: Belize Kriol English
Added: 2009-07-29
%%
Type: language
Subtag: bzk
Description: Nicaragua Creole English
Added: 2009-07-29
%%
Type: language
Subtag: bzl
Description: Boano (Sulawesi)
Added: 2009-07-29
%%
Type: language
Subtag: bzm
Description: Bolondo
Added: 2009-07-29
%%
Type: language
Subtag: bzn
Description: Boano (Maluku)
Added: 2009-07-29
%%
Type: language
Subtag: bzo
Description: Bozaba
Added: 2009-07-29
%%
Type: language
Subtag: bzp
Description: Kemberano
Added: 2009-07-29
%%
Type: language
Subtag: bzq
Description: Buli (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: bzr
Description: Biri
Added: 2009-07-29
%%
Type: language
Subtag: bzs
Description: Brazilian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: bzt
Description: Brithenig
Added: 2009-07-29
%%
Type: language
Subtag: bzu
Description: Burmeso
Added: 2009-07-29
%%
Type: language
Subtag: bzv
Description: Naami
Added: 2009-07-29
%%
Type: language
Subtag: bzw
Description: Basa (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: bzx
Description: Kɛlɛngaxo Bozo
Added: 2009-07-29
%%
Type: language
Subtag: bzy
Description: Obanliku
Added: 2009-07-29
%%
Type: language
Subtag: bzz
Description: Evant
Added: 2009-07-29
%%
Type: language
Subtag: caa
Description: Chortí
Added: 2009-07-29
%%
Type: language
Subtag: cab
Description: Garifuna
Added: 2009-07-29
%%
Type: language
Subtag: cac
Description: Chuj
Added: 2009-07-29
%%
Type: language
Subtag: cad
Description: Caddo
Added: 2005-10-16
%%
Type: language
Subtag: cae
Description: Lehar
Description: Laalaa
Added: 2009-07-29
%%
Type: language
Subtag: caf
Description: Southern Carrier
Added: 2009-07-29
%%
Type: language
Subtag: cag
Description: Nivaclé
Added: 2009-07-29
%%
Type: language
Subtag: cah
Description: Cahuarano
Added: 2009-07-29
%%
Type: language
Subtag: cai
Description: Central American Indian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: caj
Description: Chané
Added: 2009-07-29
%%
Type: language
Subtag: cak
Description: Kaqchikel
Description: Cakchiquel
Added: 2009-07-29
%%
Type: language
Subtag: cal
Description: Carolinian
Added: 2009-07-29
%%
Type: language
Subtag: cam
Description: Cemuhî
Added: 2009-07-29
%%
Type: language
Subtag: can
Description: Chambri
Added: 2009-07-29
%%
Type: language
Subtag: cao
Description: Chácobo
Added: 2009-07-29
%%
Type: language
Subtag: cap
Description: Chipaya
Added: 2009-07-29
%%
Type: language
Subtag: caq
Description: Car Nicobarese
Added: 2009-07-29
%%
Type: language
Subtag: car
Description: Galibi Carib
Added: 2005-10-16
%%
Type: language
Subtag: cas
Description: Tsimané
Added: 2009-07-29
%%
Type: language
Subtag: cau
Description: Caucasian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: cav
Description: Cavineña
Added: 2009-07-29
%%
Type: language
Subtag: caw
Description: Callawalla
Added: 2009-07-29
%%
Type: language
Subtag: cax
Description: Chiquitano
Added: 2009-07-29
%%
Type: language
Subtag: cay
Description: Cayuga
Added: 2009-07-29
%%
Type: language
Subtag: caz
Description: Canichana
Added: 2009-07-29
%%
Type: language
Subtag: cba
Description: Chibchan languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: cbb
Description: Cabiyarí
Added: 2009-07-29
%%
Type: language
Subtag: cbc
Description: Carapana
Added: 2009-07-29
%%
Type: language
Subtag: cbd
Description: Carijona
Added: 2009-07-29
%%
Type: language
Subtag: cbe
Description: Chipiajes
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: cbg
Description: Chimila
Added: 2009-07-29
%%
Type: language
Subtag: cbh
Description: Cagua
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: cbi
Description: Chachi
Added: 2009-07-29
%%
Type: language
Subtag: cbj
Description: Ede Cabe
Added: 2009-07-29
%%
Type: language
Subtag: cbk
Description: Chavacano
Added: 2009-07-29
%%
Type: language
Subtag: cbl
Description: Bualkhaw Chin
Added: 2009-07-29
%%
Type: language
Subtag: cbn
Description: Nyahkur
Added: 2009-07-29
%%
Type: language
Subtag: cbo
Description: Izora
Added: 2009-07-29
%%
Type: language
Subtag: cbq
Description: Tsucuba
Description: Cuba
Added: 2015-02-12
%%
Type: language
Subtag: cbr
Description: Cashibo-Cacataibo
Added: 2009-07-29
%%
Type: language
Subtag: cbs
Description: Cashinahua
Added: 2009-07-29
%%
Type: language
Subtag: cbt
Description: Chayahuita
Added: 2009-07-29
%%
Type: language
Subtag: cbu
Description: Candoshi-Shapra
Added: 2009-07-29
%%
Type: language
Subtag: cbv
Description: Cacua
Added: 2009-07-29
%%
Type: language
Subtag: cbw
Description: Kinabalian
Added: 2010-03-11
%%
Type: language
Subtag: cby
Description: Carabayo
Added: 2009-07-29
%%
Type: language
Subtag: cca
Description: Cauca
Added: 2009-07-29
%%
Type: language
Subtag: ccc
Description: Chamicuro
Added: 2009-07-29
%%
Type: language
Subtag: ccd
Description: Cafundo Creole
Added: 2009-07-29
%%
Type: language
Subtag: cce
Description: Chopi
Added: 2009-07-29
%%
Type: language
Subtag: ccg
Description: Samba Daka
Added: 2009-07-29
%%
Type: language
Subtag: cch
Description: Atsam
Added: 2009-07-29
%%
Type: language
Subtag: ccj
Description: Kasanga
Added: 2009-07-29
%%
Type: language
Subtag: ccl
Description: Cutchi-Swahili
Added: 2009-07-29
%%
Type: language
Subtag: ccm
Description: Malaccan Creole Malay
Added: 2009-07-29
%%
Type: language
Subtag: ccn
Description: North Caucasian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: cco
Description: Comaltepec Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: ccp
Description: Chakma
Added: 2009-07-29
%%
Type: language
Subtag: ccq
Description: Chaungtha
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: rki
%%
Type: language
Subtag: ccr
Description: Cacaopera
Added: 2009-07-29
%%
Type: language
Subtag: ccs
Description: South Caucasian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: cda
Description: Choni
Added: 2009-07-29
%%
Type: language
Subtag: cdc
Description: Chadic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: cdd
Description: Caddoan languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: cde
Description: Chenchu
Added: 2009-07-29
%%
Type: language
Subtag: cdf
Description: Chiru
Added: 2009-07-29
%%
Type: language
Subtag: cdg
Description: Chamari
Added: 2009-07-29
%%
Type: language
Subtag: cdh
Description: Chambeali
Added: 2009-07-29
%%
Type: language
Subtag: cdi
Description: Chodri
Added: 2009-07-29
%%
Type: language
Subtag: cdj
Description: Churahi
Added: 2009-07-29
%%
Type: language
Subtag: cdm
Description: Chepang
Added: 2009-07-29
%%
Type: language
Subtag: cdn
Description: Chaudangsi
Added: 2009-07-29
%%
Type: language
Subtag: cdo
Description: Min Dong Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: cdr
Description: Cinda-Regi-Tiyal
Added: 2009-07-29
%%
Type: language
Subtag: cds
Description: Chadian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: cdy
Description: Chadong
Added: 2009-07-29
%%
Type: language
Subtag: cdz
Description: Koda
Added: 2009-07-29
%%
Type: language
Subtag: cea
Description: Lower Chehalis
Added: 2009-07-29
%%
Type: language
Subtag: ceb
Description: Cebuano
Added: 2005-10-16
%%
Type: language
Subtag: ceg
Description: Chamacoco
Added: 2009-07-29
%%
Type: language
Subtag: cek
Description: Eastern Khumi Chin
Added: 2012-08-12
%%
Type: language
Subtag: cel
Description: Celtic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: cen
Description: Cen
Added: 2009-07-29
%%
Type: language
Subtag: cet
Description: Centúúm
Added: 2009-07-29
%%
Type: language
Subtag: cey
Description: Ekai Chin
Added: 2019-04-16
%%
Type: language
Subtag: cfa
Description: Dijim-Bwilim
Added: 2009-07-29
%%
Type: language
Subtag: cfd
Description: Cara
Added: 2009-07-29
%%
Type: language
Subtag: cfg
Description: Como Karim
Added: 2009-07-29
%%
Type: language
Subtag: cfm
Description: Falam Chin
Added: 2009-07-29
%%
Type: language
Subtag: cga
Description: Changriwa
Added: 2009-07-29
%%
Type: language
Subtag: cgc
Description: Kagayanen
Added: 2009-07-29
%%
Type: language
Subtag: cgg
Description: Chiga
Added: 2009-07-29
%%
Type: language
Subtag: cgk
Description: Chocangacakha
Added: 2009-07-29
%%
Type: language
Subtag: chb
Description: Chibcha
Added: 2005-10-16
%%
Type: language
Subtag: chc
Description: Catawba
Added: 2009-07-29
%%
Type: language
Subtag: chd
Description: Highland Oaxaca Chontal
Added: 2009-07-29
%%
Type: language
Subtag: chf
Description: Tabasco Chontal
Added: 2009-07-29
%%
Type: language
Subtag: chg
Description: Chagatai
Added: 2005-10-16
%%
Type: language
Subtag: chh
Description: Chinook
Added: 2009-07-29
%%
Type: language
Subtag: chj
Description: Ojitlán Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: chk
Description: Chuukese
Added: 2005-10-16
%%
Type: language
Subtag: chl
Description: Cahuilla
Added: 2009-07-29
%%
Type: language
Subtag: chm
Description: Mari (Russia)
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: chn
Description: Chinook jargon
Added: 2005-10-16
%%
Type: language
Subtag: cho
Description: Choctaw
Added: 2005-10-16
%%
Type: language
Subtag: chp
Description: Chipewyan
Description: Dene Suline
Added: 2005-10-16
%%
Type: language
Subtag: chq
Description: Quiotepec Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: chr
Description: Cherokee
Added: 2005-10-16
%%
Type: language
Subtag: cht
Description: Cholón
Added: 2009-07-29
%%
Type: language
Subtag: chw
Description: Chuwabu
Added: 2009-07-29
%%
Type: language
Subtag: chx
Description: Chantyal
Added: 2009-07-29
%%
Type: language
Subtag: chy
Description: Cheyenne
Added: 2005-10-16
%%
Type: language
Subtag: chz
Description: Ozumacín Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: cia
Description: Cia-Cia
Added: 2009-07-29
%%
Type: language
Subtag: cib
Description: Ci Gbe
Added: 2009-07-29
%%
Type: language
Subtag: cic
Description: Chickasaw
Added: 2009-07-29
%%
Type: language
Subtag: cid
Description: Chimariko
Added: 2009-07-29
%%
Type: language
Subtag: cie
Description: Cineni
Added: 2009-07-29
%%
Type: language
Subtag: cih
Description: Chinali
Added: 2009-07-29
%%
Type: language
Subtag: cik
Description: Chitkuli Kinnauri
Added: 2009-07-29
%%
Type: language
Subtag: cim
Description: Cimbrian
Added: 2009-07-29
%%
Type: language
Subtag: cin
Description: Cinta Larga
Added: 2009-07-29
%%
Type: language
Subtag: cip
Description: Chiapanec
Added: 2009-07-29
%%
Type: language
Subtag: cir
Description: Tiri
Description: Haméa
Description: Méa
Added: 2009-07-29
%%
Type: language
Subtag: ciw
Description: Chippewa
Added: 2009-07-29
Macrolanguage: oj
%%
Type: language
Subtag: ciy
Description: Chaima
Added: 2009-07-29
%%
Type: language
Subtag: cja
Description: Western Cham
Added: 2009-07-29
%%
Type: language
Subtag: cje
Description: Chru
Added: 2009-07-29
%%
Type: language
Subtag: cjh
Description: Upper Chehalis
Added: 2009-07-29
%%
Type: language
Subtag: cji
Description: Chamalal
Added: 2009-07-29
%%
Type: language
Subtag: cjk
Description: Chokwe
Added: 2009-07-29
%%
Type: language
Subtag: cjm
Description: Eastern Cham
Added: 2009-07-29
%%
Type: language
Subtag: cjn
Description: Chenapian
Added: 2009-07-29
%%
Type: language
Subtag: cjo
Description: Ashéninka Pajonal
Added: 2009-07-29
%%
Type: language
Subtag: cjp
Description: Cabécar
Added: 2009-07-29
%%
Type: language
Subtag: cjr
Description: Chorotega
Added: 2009-07-29
Deprecated: 2010-03-11
Preferred-Value: mom
%%
Type: language
Subtag: cjs
Description: Shor
Added: 2009-07-29
%%
Type: language
Subtag: cjv
Description: Chuave
Added: 2009-07-29
%%
Type: language
Subtag: cjy
Description: Jinyu Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: cka
Description: Khumi Awa Chin
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: cmr
%%
Type: language
Subtag: ckb
Description: Central Kurdish
Added: 2009-07-29
Macrolanguage: ku
%%
Type: language
Subtag: ckh
Description: Chak
Added: 2009-07-29
%%
Type: language
Subtag: ckl
Description: Cibak
Added: 2009-07-29
%%
Type: language
Subtag: ckn
Description: Kaang Chin
Added: 2013-09-10
%%
Type: language
Subtag: cko
Description: Anufo
Added: 2009-07-29
%%
Type: language
Subtag: ckq
Description: Kajakse
Added: 2009-07-29
%%
Type: language
Subtag: ckr
Description: Kairak
Added: 2009-07-29
%%
Type: language
Subtag: cks
Description: Tayo
Added: 2009-07-29
%%
Type: language
Subtag: ckt
Description: Chukot
Added: 2009-07-29
%%
Type: language
Subtag: cku
Description: Koasati
Added: 2009-07-29
%%
Type: language
Subtag: ckv
Description: Kavalan
Added: 2009-07-29
%%
Type: language
Subtag: ckx
Description: Caka
Added: 2009-07-29
%%
Type: language
Subtag: cky
Description: Cakfem-Mushere
Added: 2009-07-29
%%
Type: language
Subtag: ckz
Description: Cakchiquel-Quiché Mixed Language
Added: 2009-07-29
%%
Type: language
Subtag: cla
Description: Ron
Added: 2009-07-29
%%
Type: language
Subtag: clc
Description: Chilcotin
Added: 2009-07-29
%%
Type: language
Subtag: cld
Description: Chaldean Neo-Aramaic
Added: 2009-07-29
Macrolanguage: syr
%%
Type: language
Subtag: cle
Description: Lealao Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: clh
Description: Chilisso
Added: 2009-07-29
%%
Type: language
Subtag: cli
Description: Chakali
Added: 2009-07-29
%%
Type: language
Subtag: clj
Description: Laitu Chin
Added: 2012-08-12
%%
Type: language
Subtag: clk
Description: Idu-Mishmi
Added: 2009-07-29
%%
Type: language
Subtag: cll
Description: Chala
Added: 2009-07-29
%%
Type: language
Subtag: clm
Description: Clallam
Added: 2009-07-29
%%
Type: language
Subtag: clo
Description: Lowland Oaxaca Chontal
Added: 2009-07-29
%%
Type: language
Subtag: clt
Description: Lautu Chin
Added: 2012-08-12
%%
Type: language
Subtag: clu
Description: Caluyanun
Added: 2009-07-29
%%
Type: language
Subtag: clw
Description: Chulym
Added: 2009-07-29
%%
Type: language
Subtag: cly
Description: Eastern Highland Chatino
Added: 2009-07-29
%%
Type: language
Subtag: cma
Description: Maa
Added: 2009-07-29
%%
Type: language
Subtag: cmc
Description: Chamic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: cme
Description: Cerma
Added: 2009-07-29
%%
Type: language
Subtag: cmg
Description: Classical Mongolian
Added: 2009-07-29
%%
Type: language
Subtag: cmi
Description: Emberá-Chamí
Added: 2009-07-29
%%
Type: language
Subtag: cmk
Description: Chimakum
Added: 2009-07-29
Deprecated: 2010-03-11
Preferred-Value: xch
%%
Type: language
Subtag: cml
Description: Campalagian
Added: 2009-07-29
%%
Type: language
Subtag: cmm
Description: Michigamea
Added: 2009-07-29
%%
Type: language
Subtag: cmn
Description: Mandarin Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: cmo
Description: Central Mnong
Added: 2009-07-29
%%
Type: language
Subtag: cmr
Description: Mro-Khimi Chin
Added: 2009-07-29
%%
Type: language
Subtag: cms
Description: Messapic
Added: 2009-07-29
%%
Type: language
Subtag: cmt
Description: Camtho
Added: 2009-07-29
%%
Type: language
Subtag: cna
Description: Changthang
Added: 2009-07-29
%%
Type: language
Subtag: cnb
Description: Chinbon Chin
Added: 2009-07-29
%%
Type: language
Subtag: cnc
Description: Côông
Added: 2009-07-29
%%
Type: language
Subtag: cng
Description: Northern Qiang
Added: 2009-07-29
%%
Type: language
Subtag: cnh
Description: Hakha Chin
Description: Haka Chin
Added: 2009-07-29
%%
Type: language
Subtag: cni
Description: Asháninka
Added: 2009-07-29
%%
Type: language
Subtag: cnk
Description: Khumi Chin
Added: 2009-07-29
%%
Type: language
Subtag: cnl
Description: Lalana Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: cno
Description: Con
Added: 2009-07-29
%%
Type: language
Subtag: cnr
Description: Montenegrin
Added: 2018-01-23
Macrolanguage: sh
Comments: see sr for Serbian
%%
Type: language
Subtag: cns
Description: Central Asmat
Added: 2009-07-29
%%
Type: language
Subtag: cnt
Description: Tepetotutla Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: cnu
Description: Chenoua
Added: 2009-07-29
%%
Type: language
Subtag: cnw
Description: Ngawn Chin
Added: 2009-07-29
%%
Type: language
Subtag: cnx
Description: Middle Cornish
Added: 2009-07-29
%%
Type: language
Subtag: coa
Description: Cocos Islands Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: cob
Description: Chicomuceltec
Added: 2009-07-29
%%
Type: language
Subtag: coc
Description: Cocopa
Added: 2009-07-29
%%
Type: language
Subtag: cod
Description: Cocama-Cocamilla
Added: 2009-07-29
%%
Type: language
Subtag: coe
Description: Koreguaje
Added: 2009-07-29
%%
Type: language
Subtag: cof
Description: Colorado
Added: 2009-07-29
%%
Type: language
Subtag: cog
Description: Chong
Added: 2009-07-29
%%
Type: language
Subtag: coh
Description: Chonyi-Dzihana-Kauma
Description: Chichonyi-Chidzihana-Chikauma
Added: 2009-07-29
%%
Type: language
Subtag: coj
Description: Cochimi
Added: 2009-07-29
%%
Type: language
Subtag: cok
Description: Santa Teresa Cora
Added: 2009-07-29
%%
Type: language
Subtag: col
Description: Columbia-Wenatchi
Added: 2009-07-29
%%
Type: language
Subtag: com
Description: Comanche
Added: 2009-07-29
%%
Type: language
Subtag: con
Description: Cofán
Added: 2009-07-29
%%
Type: language
Subtag: coo
Description: Comox
Added: 2009-07-29
%%
Type: language
Subtag: cop
Description: Coptic
Added: 2005-10-16
%%
Type: language
Subtag: coq
Description: Coquille
Added: 2009-07-29
%%
Type: language
Subtag: cot
Description: Caquinte
Added: 2009-07-29
%%
Type: language
Subtag: cou
Description: Wamey
Added: 2009-07-29
%%
Type: language
Subtag: cov
Description: Cao Miao
Added: 2009-07-29
%%
Type: language
Subtag: cow
Description: Cowlitz
Added: 2009-07-29
%%
Type: language
Subtag: cox
Description: Nanti
Added: 2009-07-29
%%
Type: language
Subtag: coy
Description: Coyaima
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: pij
%%
Type: language
Subtag: coz
Description: Chochotec
Added: 2009-07-29
%%
Type: language
Subtag: cpa
Description: Palantla Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: cpb
Description: Ucayali-Yurúa Ashéninka
Added: 2009-07-29
%%
Type: language
Subtag: cpc
Description: Ajyíninka Apurucayali
Added: 2009-07-29
%%
Type: language
Subtag: cpe
Description: English-based creoles and pidgins
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: cpf
Description: French-based creoles and pidgins
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: cpg
Description: Cappadocian Greek
Added: 2009-07-29
%%
Type: language
Subtag: cpi
Description: Chinese Pidgin English
Added: 2009-07-29
%%
Type: language
Subtag: cpn
Description: Cherepon
Added: 2009-07-29
%%
Type: language
Subtag: cpo
Description: Kpeego
Added: 2013-09-10
%%
Type: language
Subtag: cpp
Description: Portuguese-based creoles and pidgins
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: cps
Description: Capiznon
Added: 2009-07-29
%%
Type: language
Subtag: cpu
Description: Pichis Ashéninka
Added: 2009-07-29
%%
Type: language
Subtag: cpx
Description: Pu-Xian Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: cpy
Description: South Ucayali Ashéninka
Added: 2009-07-29
%%
Type: language
Subtag: cqd
Description: Chuanqiandian Cluster Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: cqu
Description: Chilean Quechua
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: quh
Macrolanguage: qu
%%
Type: language
Subtag: cra
Description: Chara
Added: 2009-07-29
%%
Type: language
Subtag: crb
Description: Island Carib
Added: 2009-07-29
%%
Type: language
Subtag: crc
Description: Lonwolwol
Added: 2009-07-29
%%
Type: language
Subtag: crd
Description: Coeur d'Alene
Added: 2009-07-29
%%
Type: language
Subtag: crf
Description: Caramanta
Added: 2009-07-29
%%
Type: language
Subtag: crg
Description: Michif
Added: 2009-07-29
%%
Type: language
Subtag: crh
Description: Crimean Tatar
Description: Crimean Turkish
Added: 2005-10-16
%%
Type: language
Subtag: cri
Description: Sãotomense
Added: 2009-07-29
%%
Type: language
Subtag: crj
Description: Southern East Cree
Added: 2009-07-29
Macrolanguage: cr
%%
Type: language
Subtag: crk
Description: Plains Cree
Added: 2009-07-29
Macrolanguage: cr
%%
Type: language
Subtag: crl
Description: Northern East Cree
Added: 2009-07-29
Macrolanguage: cr
%%
Type: language
Subtag: crm
Description: Moose Cree
Added: 2009-07-29
Macrolanguage: cr
%%
Type: language
Subtag: crn
Description: El Nayar Cora
Added: 2009-07-29
%%
Type: language
Subtag: cro
Description: Crow
Added: 2009-07-29
%%
Type: language
Subtag: crp
Description: Creoles and pidgins
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: crq
Description: Iyo'wujwa Chorote
Added: 2009-07-29
%%
Type: language
Subtag: crr
Description: Carolina Algonquian
Added: 2009-07-29
%%
Type: language
Subtag: crs
Description: Seselwa Creole French
Added: 2009-07-29
%%
Type: language
Subtag: crt
Description: Iyojwa'ja Chorote
Added: 2009-07-29
%%
Type: language
Subtag: crv
Description: Chaura
Added: 2009-07-29
%%
Type: language
Subtag: crw
Description: Chrau
Added: 2009-07-29
%%
Type: language
Subtag: crx
Description: Carrier
Added: 2009-07-29
%%
Type: language
Subtag: cry
Description: Cori
Added: 2009-07-29
%%
Type: language
Subtag: crz
Description: Cruzeño
Added: 2009-07-29
%%
Type: language
Subtag: csa
Description: Chiltepec Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: csb
Description: Kashubian
Added: 2005-10-16
%%
Type: language
Subtag: csc
Description: Catalan Sign Language
Description: Lengua de señas catalana
Description: Llengua de Signes Catalana
Added: 2009-07-29
%%
Type: language
Subtag: csd
Description: Chiangmai Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: cse
Description: Czech Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: csf
Description: Cuba Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: csg
Description: Chilean Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: csh
Description: Asho Chin
Added: 2009-07-29
%%
Type: language
Subtag: csi
Description: Coast Miwok
Added: 2009-07-29
%%
Type: language
Subtag: csj
Description: Songlai Chin
Added: 2013-09-10
%%
Type: language
Subtag: csk
Description: Jola-Kasa
Added: 2009-07-29
%%
Type: language
Subtag: csl
Description: Chinese Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: csm
Description: Central Sierra Miwok
Added: 2009-07-29
%%
Type: language
Subtag: csn
Description: Colombian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: cso
Description: Sochiapam Chinantec
Description: Sochiapan Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: csq
Description: Croatia Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: csr
Description: Costa Rican Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: css
Description: Southern Ohlone
Added: 2009-07-29
%%
Type: language
Subtag: cst
Description: Northern Ohlone
Added: 2009-07-29
%%
Type: language
Subtag: csu
Description: Central Sudanic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: csv
Description: Sumtu Chin
Added: 2012-08-12
%%
Type: language
Subtag: csw
Description: Swampy Cree
Added: 2009-07-29
Macrolanguage: cr
%%
Type: language
Subtag: csy
Description: Siyin Chin
Added: 2009-07-29
%%
Type: language
Subtag: csz
Description: Coos
Added: 2009-07-29
%%
Type: language
Subtag: cta
Description: Tataltepec Chatino
Added: 2009-07-29
%%
Type: language
Subtag: ctc
Description: Chetco
Added: 2009-07-29
%%
Type: language
Subtag: ctd
Description: Tedim Chin
Added: 2009-07-29
%%
Type: language
Subtag: cte
Description: Tepinapa Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: ctg
Description: Chittagonian
Added: 2009-07-29
%%
Type: language
Subtag: cth
Description: Thaiphum Chin
Added: 2012-08-12
%%
Type: language
Subtag: ctl
Description: Tlacoatzintepec Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: ctm
Description: Chitimacha
Added: 2009-07-29
%%
Type: language
Subtag: ctn
Description: Chhintange
Added: 2009-07-29
%%
Type: language
Subtag: cto
Description: Emberá-Catío
Added: 2009-07-29
%%
Type: language
Subtag: ctp
Description: Western Highland Chatino
Added: 2009-07-29
%%
Type: language
Subtag: cts
Description: Northern Catanduanes Bikol
Added: 2009-07-29
Macrolanguage: bik
%%
Type: language
Subtag: ctt
Description: Wayanad Chetti
Added: 2009-07-29
%%
Type: language
Subtag: ctu
Description: Chol
Added: 2009-07-29
%%
Type: language
Subtag: ctz
Description: Zacatepec Chatino
Added: 2009-07-29
%%
Type: language
Subtag: cua
Description: Cua
Added: 2009-07-29
%%
Type: language
Subtag: cub
Description: Cubeo
Added: 2009-07-29
%%
Type: language
Subtag: cuc
Description: Usila Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: cug
Description: Chungmboko
Description: Cung
Added: 2009-07-29
%%
Type: language
Subtag: cuh
Description: Chuka
Description: Gichuka
Added: 2009-07-29
%%
Type: language
Subtag: cui
Description: Cuiba
Added: 2009-07-29
%%
Type: language
Subtag: cuj
Description: Mashco Piro
Added: 2009-07-29
%%
Type: language
Subtag: cuk
Description: San Blas Kuna
Added: 2009-07-29
%%
Type: language
Subtag: cul
Description: Culina
Description: Kulina
Added: 2009-07-29
%%
Type: language
Subtag: cum
Description: Cumeral
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: cuo
Description: Cumanagoto
Added: 2009-07-29
%%
Type: language
Subtag: cup
Description: Cupeño
Added: 2009-07-29
%%
Type: language
Subtag: cuq
Description: Cun
Added: 2009-07-29
%%
Type: language
Subtag: cur
Description: Chhulung
Added: 2009-07-29
%%
Type: language
Subtag: cus
Description: Cushitic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: cut
Description: Teutila Cuicatec
Added: 2009-07-29
%%
Type: language
Subtag: cuu
Description: Tai Ya
Added: 2009-07-29
%%
Type: language
Subtag: cuv
Description: Cuvok
Added: 2009-07-29
%%
Type: language
Subtag: cuw
Description: Chukwa
Added: 2009-07-29
%%
Type: language
Subtag: cux
Description: Tepeuxila Cuicatec
Added: 2009-07-29
%%
Type: language
Subtag: cuy
Description: Cuitlatec
Added: 2018-03-08
%%
Type: language
Subtag: cvg
Description: Chug
Added: 2009-07-29
%%
Type: language
Subtag: cvn
Description: Valle Nacional Chinantec
Added: 2009-07-29
%%
Type: language
Subtag: cwa
Description: Kabwa
Added: 2009-07-29
%%
Type: language
Subtag: cwb
Description: Maindo
Added: 2009-07-29
%%
Type: language
Subtag: cwd
Description: Woods Cree
Added: 2009-07-29
Macrolanguage: cr
%%
Type: language
Subtag: cwe
Description: Kwere
Added: 2009-07-29
%%
Type: language
Subtag: cwg
Description: Chewong
Description: Cheq Wong
Added: 2009-07-29
%%
Type: language
Subtag: cwt
Description: Kuwaataay
Added: 2009-07-29
%%
Type: language
Subtag: cya
Description: Nopala Chatino
Added: 2009-07-29
%%
Type: language
Subtag: cyb
Description: Cayubaba
Added: 2009-07-29
%%
Type: language
Subtag: cyo
Description: Cuyonon
Added: 2009-07-29
%%
Type: language
Subtag: czh
Description: Huizhou Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: czk
Description: Knaanic
Added: 2009-07-29
%%
Type: language
Subtag: czn
Description: Zenzontepec Chatino
Added: 2009-07-29
%%
Type: language
Subtag: czo
Description: Min Zhong Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: czt
Description: Zotung Chin
Added: 2009-07-29
%%
Type: language
Subtag: daa
Description: Dangaléat
Added: 2009-07-29
%%
Type: language
Subtag: dac
Description: Dambi
Added: 2009-07-29
%%
Type: language
Subtag: dad
Description: Marik
Added: 2009-07-29
%%
Type: language
Subtag: dae
Description: Duupa
Added: 2009-07-29
%%
Type: language
Subtag: daf
Description: Dan
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see dnj, lda
%%
Type: language
Subtag: dag
Description: Dagbani
Added: 2009-07-29
%%
Type: language
Subtag: dah
Description: Gwahatike
Added: 2009-07-29
%%
Type: language
Subtag: dai
Description: Day
Added: 2009-07-29
%%
Type: language
Subtag: daj
Description: Dar Fur Daju
Added: 2009-07-29
%%
Type: language
Subtag: dak
Description: Dakota
Added: 2005-10-16
%%
Type: language
Subtag: dal
Description: Dahalo
Added: 2009-07-29
%%
Type: language
Subtag: dam
Description: Damakawa
Added: 2009-07-29
%%
Type: language
Subtag: dao
Description: Daai Chin
Added: 2009-07-29
%%
Type: language
Subtag: dap
Description: Nisi (India)
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see njz, tgj
%%
Type: language
Subtag: daq
Description: Dandami Maria
Added: 2009-07-29
%%
Type: language
Subtag: dar
Description: Dargwa
Added: 2005-10-16
%%
Type: language
Subtag: das
Description: Daho-Doo
Added: 2009-07-29
%%
Type: language
Subtag: dau
Description: Dar Sila Daju
Added: 2009-07-29
%%
Type: language
Subtag: dav
Description: Taita
Description: Dawida
Added: 2009-07-29
%%
Type: language
Subtag: daw
Description: Davawenyo
Added: 2009-07-29
%%
Type: language
Subtag: dax
Description: Dayi
Added: 2009-07-29
%%
Type: language
Subtag: day
Description: Land Dayak languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: daz
Description: Dao
Added: 2009-07-29
%%
Type: language
Subtag: dba
Description: Bangime
Added: 2009-07-29
%%
Type: language
Subtag: dbb
Description: Deno
Added: 2009-07-29
%%
Type: language
Subtag: dbd
Description: Dadiya
Added: 2009-07-29
%%
Type: language
Subtag: dbe
Description: Dabe
Added: 2009-07-29
%%
Type: language
Subtag: dbf
Description: Edopi
Added: 2009-07-29
%%
Type: language
Subtag: dbg
Description: Dogul Dom Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dbi
Description: Doka
Added: 2009-07-29
%%
Type: language
Subtag: dbj
Description: Ida'an
Added: 2009-07-29
%%
Type: language
Subtag: dbl
Description: Dyirbal
Added: 2009-07-29
%%
Type: language
Subtag: dbm
Description: Duguri
Added: 2009-07-29
%%
Type: language
Subtag: dbn
Description: Duriankere
Added: 2009-07-29
%%
Type: language
Subtag: dbo
Description: Dulbu
Added: 2009-07-29
%%
Type: language
Subtag: dbp
Description: Duwai
Added: 2009-07-29
%%
Type: language
Subtag: dbq
Description: Daba
Added: 2009-07-29
%%
Type: language
Subtag: dbr
Description: Dabarre
Added: 2009-07-29
%%
Type: language
Subtag: dbt
Description: Ben Tey Dogon
Added: 2012-08-12
%%
Type: language
Subtag: dbu
Description: Bondum Dom Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dbv
Description: Dungu
Added: 2009-07-29
%%
Type: language
Subtag: dbw
Description: Bankan Tey Dogon
Added: 2012-08-12
%%
Type: language
Subtag: dby
Description: Dibiyaso
Added: 2009-07-29
%%
Type: language
Subtag: dcc
Description: Deccan
Added: 2009-07-29
%%
Type: language
Subtag: dcr
Description: Negerhollands
Added: 2009-07-29
%%
Type: language
Subtag: dda
Description: Dadi Dadi
Added: 2012-08-12
%%
Type: language
Subtag: ddd
Description: Dongotono
Added: 2009-07-29
%%
Type: language
Subtag: dde
Description: Doondo
Added: 2009-07-29
%%
Type: language
Subtag: ddg
Description: Fataluku
Added: 2009-07-29
%%
Type: language
Subtag: ddi
Description: West Goodenough
Added: 2009-07-29
%%
Type: language
Subtag: ddj
Description: Jaru
Added: 2009-07-29
%%
Type: language
Subtag: ddn
Description: Dendi (Benin)
Added: 2009-07-29
%%
Type: language
Subtag: ddo
Description: Dido
Added: 2009-07-29
%%
Type: language
Subtag: ddr
Description: Dhudhuroa
Added: 2012-08-12
%%
Type: language
Subtag: dds
Description: Donno So Dogon
Added: 2009-07-29
%%
Type: language
Subtag: ddw
Description: Dawera-Daweloor
Added: 2009-07-29
%%
Type: language
Subtag: dec
Description: Dagik
Added: 2009-07-29
%%
Type: language
Subtag: ded
Description: Dedua
Added: 2009-07-29
%%
Type: language
Subtag: dee
Description: Dewoin
Added: 2009-07-29
%%
Type: language
Subtag: def
Description: Dezfuli
Added: 2009-07-29
%%
Type: language
Subtag: deg
Description: Degema
Added: 2009-07-29
%%
Type: language
Subtag: deh
Description: Dehwari
Added: 2009-07-29
%%
Type: language
Subtag: dei
Description: Demisa
Added: 2009-07-29
%%
Type: language
Subtag: dek
Description: Dek
Added: 2009-07-29
%%
Type: language
Subtag: del
Description: Delaware
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: dem
Description: Dem
Added: 2009-07-29
%%
Type: language
Subtag: den
Description: Slave (Athapascan)
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: dep
Description: Pidgin Delaware
Added: 2009-07-29
%%
Type: language
Subtag: deq
Description: Dendi (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: der
Description: Deori
Added: 2009-07-29
%%
Type: language
Subtag: des
Description: Desano
Added: 2009-07-29
%%
Type: language
Subtag: dev
Description: Domung
Added: 2009-07-29
%%
Type: language
Subtag: dez
Description: Dengese
Added: 2009-07-29
%%
Type: language
Subtag: dga
Description: Southern Dagaare
Added: 2009-07-29
%%
Type: language
Subtag: dgb
Description: Bunoge Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dgc
Description: Casiguran Dumagat Agta
Added: 2009-07-29
%%
Type: language
Subtag: dgd
Description: Dagaari Dioula
Added: 2009-07-29
%%
Type: language
Subtag: dge
Description: Degenan
Added: 2009-07-29
%%
Type: language
Subtag: dgg
Description: Doga
Added: 2009-07-29
%%
Type: language
Subtag: dgh
Description: Dghwede
Added: 2009-07-29
%%
Type: language
Subtag: dgi
Description: Northern Dagara
Added: 2009-07-29
%%
Type: language
Subtag: dgk
Description: Dagba
Added: 2009-07-29
%%
Type: language
Subtag: dgl
Description: Andaandi
Description: Dongolawi
Added: 2012-08-12
%%
Type: language
Subtag: dgn
Description: Dagoman
Added: 2009-07-29
%%
Type: language
Subtag: dgo
Description: Dogri (individual language)
Added: 2009-07-29
Macrolanguage: doi
%%
Type: language
Subtag: dgr
Description: Dogrib
Added: 2005-10-16
%%
Type: language
Subtag: dgs
Description: Dogoso
Added: 2009-07-29
%%
Type: language
Subtag: dgt
Description: Ndra'ngith
Added: 2012-08-12
%%
Type: language
Subtag: dgu
Description: Degaru
Added: 2009-07-29
%%
Type: language
Subtag: dgw
Description: Daungwurrung
Added: 2012-08-12
%%
Type: language
Subtag: dgx
Description: Doghoro
Added: 2009-07-29
%%
Type: language
Subtag: dgz
Description: Daga
Added: 2009-07-29
%%
Type: language
Subtag: dha
Description: Dhanwar (India)
Added: 2009-07-29
Deprecated: 2011-08-16
%%
Type: language
Subtag: dhd
Description: Dhundari
Added: 2009-07-29
Macrolanguage: mwr
%%
Type: language
Subtag: dhg
Description: Dhangu-Djangu
Description: Dhangu
Description: Djangu
Added: 2009-07-29
%%
Type: language
Subtag: dhi
Description: Dhimal
Added: 2009-07-29
%%
Type: language
Subtag: dhl
Description: Dhalandji
Added: 2009-07-29
%%
Type: language
Subtag: dhm
Description: Zemba
Added: 2009-07-29
%%
Type: language
Subtag: dhn
Description: Dhanki
Added: 2009-07-29
%%
Type: language
Subtag: dho
Description: Dhodia
Added: 2009-07-29
%%
Type: language
Subtag: dhr
Description: Dhargari
Added: 2009-07-29
%%
Type: language
Subtag: dhs
Description: Dhaiso
Added: 2009-07-29
%%
Type: language
Subtag: dhu
Description: Dhurga
Added: 2009-07-29
%%
Type: language
Subtag: dhv
Description: Dehu
Description: Drehu
Added: 2009-07-29
%%
Type: language
Subtag: dhw
Description: Dhanwar (Nepal)
Added: 2009-07-29
%%
Type: language
Subtag: dhx
Description: Dhungaloo
Added: 2013-09-10
%%
Type: language
Subtag: dia
Description: Dia
Added: 2009-07-29
%%
Type: language
Subtag: dib
Description: South Central Dinka
Added: 2009-07-29
Macrolanguage: din
%%
Type: language
Subtag: dic
Description: Lakota Dida
Added: 2009-07-29
%%
Type: language
Subtag: did
Description: Didinga
Added: 2009-07-29
%%
Type: language
Subtag: dif
Description: Dieri
Description: Diyari
Added: 2009-07-29
%%
Type: language
Subtag: dig
Description: Digo
Description: Chidigo
Added: 2009-07-29
%%
Type: language
Subtag: dih
Description: Kumiai
Added: 2009-07-29
%%
Type: language
Subtag: dii
Description: Dimbong
Added: 2009-07-29
%%
Type: language
Subtag: dij
Description: Dai
Added: 2009-07-29
%%
Type: language
Subtag: dik
Description: Southwestern Dinka
Added: 2009-07-29
Macrolanguage: din
%%
Type: language
Subtag: dil
Description: Dilling
Added: 2009-07-29
%%
Type: language
Subtag: dim
Description: Dime
Added: 2009-07-29
%%
Type: language
Subtag: din
Description: Dinka
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: dio
Description: Dibo
Added: 2009-07-29
%%
Type: language
Subtag: dip
Description: Northeastern Dinka
Added: 2009-07-29
Macrolanguage: din
%%
Type: language
Subtag: diq
Description: Dimli (individual language)
Added: 2009-07-29
Macrolanguage: zza
%%
Type: language
Subtag: dir
Description: Dirim
Added: 2009-07-29
%%
Type: language
Subtag: dis
Description: Dimasa
Added: 2009-07-29
%%
Type: language
Subtag: dit
Description: Dirari
Added: 2009-07-29
Deprecated: 2019-04-29
Preferred-Value: dif
%%
Type: language
Subtag: diu
Description: Diriku
Added: 2009-07-29
%%
Type: language
Subtag: diw
Description: Northwestern Dinka
Added: 2009-07-29
Macrolanguage: din
%%
Type: language
Subtag: dix
Description: Dixon Reef
Added: 2009-07-29
%%
Type: language
Subtag: diy
Description: Diuwe
Added: 2009-07-29
%%
Type: language
Subtag: diz
Description: Ding
Added: 2009-07-29
%%
Type: language
Subtag: dja
Description: Djadjawurrung
Added: 2012-08-12
%%
Type: language
Subtag: djb
Description: Djinba
Added: 2009-07-29
%%
Type: language
Subtag: djc
Description: Dar Daju Daju
Added: 2009-07-29
%%
Type: language
Subtag: djd
Description: Djamindjung
Description: Ngaliwurru
Added: 2009-07-29
%%
Type: language
Subtag: dje
Description: Zarma
Added: 2009-07-29
%%
Type: language
Subtag: djf
Description: Djangun
Added: 2009-07-29
%%
Type: language
Subtag: dji
Description: Djinang
Added: 2009-07-29
%%
Type: language
Subtag: djj
Description: Djeebbana
Added: 2009-07-29
%%
Type: language
Subtag: djk
Description: Eastern Maroon Creole
Description: Businenge Tongo
Description: Nenge
Added: 2009-07-29
%%
Type: language
Subtag: djl
Description: Djiwarli
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see dze, iin
%%
Type: language
Subtag: djm
Description: Jamsay Dogon
Added: 2009-07-29
%%
Type: language
Subtag: djn
Description: Jawoyn
Description: Djauan
Added: 2009-07-29
%%
Type: language
Subtag: djo
Description: Jangkang
Added: 2009-07-29
%%
Type: language
Subtag: djr
Description: Djambarrpuyngu
Added: 2009-07-29
%%
Type: language
Subtag: dju
Description: Kapriman
Added: 2009-07-29
%%
Type: language
Subtag: djw
Description: Djawi
Added: 2009-07-29
%%
Type: language
Subtag: dka
Description: Dakpakha
Added: 2009-07-29
%%
Type: language
Subtag: dkk
Description: Dakka
Added: 2009-07-29
%%
Type: language
Subtag: dkl
Description: Kolum So Dogon
Added: 2009-07-29
Deprecated: 2011-08-16
Comments: see aqd, dmb
%%
Type: language
Subtag: dkr
Description: Kuijau
Added: 2009-07-29
%%
Type: language
Subtag: dks
Description: Southeastern Dinka
Added: 2009-07-29
Macrolanguage: din
%%
Type: language
Subtag: dkx
Description: Mazagway
Added: 2009-07-29
%%
Type: language
Subtag: dlg
Description: Dolgan
Added: 2009-07-29
%%
Type: language
Subtag: dlk
Description: Dahalik
Added: 2013-09-10
%%
Type: language
Subtag: dlm
Description: Dalmatian
Added: 2009-07-29
%%
Type: language
Subtag: dln
Description: Darlong
Added: 2009-07-29
%%
Type: language
Subtag: dma
Description: Duma
Added: 2009-07-29
%%
Type: language
Subtag: dmb
Description: Mombo Dogon
Added: 2011-08-16
%%
Type: language
Subtag: dmc
Description: Gavak
Added: 2009-07-29
%%
Type: language
Subtag: dmd
Description: Madhi Madhi
Added: 2012-08-12
%%
Type: language
Subtag: dme
Description: Dugwor
Added: 2009-07-29
%%
Type: language
Subtag: dmg
Description: Upper Kinabatangan
Added: 2009-07-29
%%
Type: language
Subtag: dmk
Description: Domaaki
Added: 2009-07-29
%%
Type: language
Subtag: dml
Description: Dameli
Added: 2009-07-29
%%
Type: language
Subtag: dmm
Description: Dama
Added: 2009-07-29
%%
Type: language
Subtag: dmn
Description: Mande languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: dmo
Description: Kemedzung
Added: 2009-07-29
%%
Type: language
Subtag: dmr
Description: East Damar
Added: 2009-07-29
%%
Type: language
Subtag: dms
Description: Dampelas
Added: 2009-07-29
%%
Type: language
Subtag: dmu
Description: Dubu
Description: Tebi
Added: 2009-07-29
%%
Type: language
Subtag: dmv
Description: Dumpas
Added: 2009-07-29
%%
Type: language
Subtag: dmw
Description: Mudburra
Added: 2013-09-10
%%
Type: language
Subtag: dmx
Description: Dema
Added: 2009-07-29
%%
Type: language
Subtag: dmy
Description: Demta
Description: Sowari
Added: 2009-07-29
%%
Type: language
Subtag: dna
Description: Upper Grand Valley Dani
Added: 2009-07-29
%%
Type: language
Subtag: dnd
Description: Daonda
Added: 2009-07-29
%%
Type: language
Subtag: dne
Description: Ndendeule
Added: 2009-07-29
%%
Type: language
Subtag: dng
Description: Dungan
Added: 2009-07-29
%%
Type: language
Subtag: dni
Description: Lower Grand Valley Dani
Added: 2009-07-29
%%
Type: language
Subtag: dnj
Description: Dan
Added: 2013-09-10
%%
Type: language
Subtag: dnk
Description: Dengka
Added: 2009-07-29
%%
Type: language
Subtag: dnn
Description: Dzùùngoo
Added: 2009-07-29
%%
Type: language
Subtag: dno
Description: Ndrulo
Description: Northern Lendu
Added: 2018-10-28
%%
Type: language
Subtag: dnr
Description: Danaru
Added: 2009-07-29
%%
Type: language
Subtag: dnt
Description: Mid Grand Valley Dani
Added: 2009-07-29
%%
Type: language
Subtag: dnu
Description: Danau
Added: 2009-07-29
%%
Type: language
Subtag: dnv
Description: Danu
Added: 2012-08-12
%%
Type: language
Subtag: dnw
Description: Western Dani
Added: 2009-07-29
%%
Type: language
Subtag: dny
Description: Dení
Added: 2009-07-29
%%
Type: language
Subtag: doa
Description: Dom
Added: 2009-07-29
%%
Type: language
Subtag: dob
Description: Dobu
Added: 2009-07-29
%%
Type: language
Subtag: doc
Description: Northern Dong
Added: 2009-07-29
%%
Type: language
Subtag: doe
Description: Doe
Added: 2009-07-29
%%
Type: language
Subtag: dof
Description: Domu
Added: 2009-07-29
%%
Type: language
Subtag: doh
Description: Dong
Added: 2009-07-29
%%
Type: language
Subtag: doi
Description: Dogri (macrolanguage)
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: dok
Description: Dondo
Added: 2009-07-29
%%
Type: language
Subtag: dol
Description: Doso
Added: 2009-07-29
%%
Type: language
Subtag: don
Description: Toura (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: doo
Description: Dongo
Added: 2009-07-29
%%
Type: language
Subtag: dop
Description: Lukpa
Added: 2009-07-29
%%
Type: language
Subtag: doq
Description: Dominican Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: dor
Description: Dori'o
Added: 2009-07-29
%%
Type: language
Subtag: dos
Description: Dogosé
Added: 2009-07-29
%%
Type: language
Subtag: dot
Description: Dass
Added: 2009-07-29
%%
Type: language
Subtag: dov
Description: Dombe
Added: 2009-07-29
%%
Type: language
Subtag: dow
Description: Doyayo
Added: 2009-07-29
%%
Type: language
Subtag: dox
Description: Bussa
Added: 2009-07-29
%%
Type: language
Subtag: doy
Description: Dompo
Added: 2009-07-29
%%
Type: language
Subtag: doz
Description: Dorze
Added: 2009-07-29
%%
Type: language
Subtag: dpp
Description: Papar
Added: 2009-07-29
%%
Type: language
Subtag: dra
Description: Dravidian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: drb
Description: Dair
Added: 2009-07-29
%%
Type: language
Subtag: drc
Description: Minderico
Added: 2011-08-16
%%
Type: language
Subtag: drd
Description: Darmiya
Added: 2009-07-29
%%
Type: language
Subtag: dre
Description: Dolpo
Added: 2009-07-29
%%
Type: language
Subtag: drg
Description: Rungus
Added: 2009-07-29
%%
Type: language
Subtag: drh
Description: Darkhat
Added: 2009-07-29
Deprecated: 2010-03-11
Preferred-Value: khk
%%
Type: language
Subtag: dri
Description: C'Lela
Added: 2009-07-29
%%
Type: language
Subtag: drl
Description: Paakantyi
Added: 2009-07-29
%%
Type: language
Subtag: drn
Description: West Damar
Added: 2009-07-29
%%
Type: language
Subtag: dro
Description: Daro-Matu Melanau
Added: 2009-07-29
%%
Type: language
Subtag: drq
Description: Dura
Added: 2009-07-29
%%
Type: language
Subtag: drr
Description: Dororo
Added: 2009-07-29
%%
Type: language
Subtag: drs
Description: Gedeo
Added: 2009-07-29
%%
Type: language
Subtag: drt
Description: Drents
Added: 2009-07-29
%%
Type: language
Subtag: dru
Description: Rukai
Added: 2009-07-29
%%
Type: language
Subtag: drw
Description: Darwazi
Added: 2009-07-29
Deprecated: 2010-03-11
Preferred-Value: prs
%%
Type: language
Subtag: dry
Description: Darai
Added: 2009-07-29
%%
Type: language
Subtag: dsb
Description: Lower Sorbian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: dse
Description: Dutch Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: dsh
Description: Daasanach
Added: 2009-07-29
%%
Type: language
Subtag: dsi
Description: Disa
Added: 2009-07-29
%%
Type: language
Subtag: dsl
Description: Danish Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: dsn
Description: Dusner
Added: 2009-07-29
%%
Type: language
Subtag: dso
Description: Desiya
Added: 2009-07-29
%%
Type: language
Subtag: dsq
Description: Tadaksahak
Added: 2009-07-29
%%
Type: language
Subtag: dta
Description: Daur
Added: 2009-07-29
%%
Type: language
Subtag: dtb
Description: Labuk-Kinabatangan Kadazan
Added: 2009-07-29
%%
Type: language
Subtag: dtd
Description: Ditidaht
Added: 2011-08-16
%%
Type: language
Subtag: dth
Description: Adithinngithigh
Added: 2012-08-12
%%
Type: language
Subtag: dti
Description: Ana Tinga Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dtk
Description: Tene Kan Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dtm
Description: Tomo Kan Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dtn
Description: Daatsʼíin
Added: 2016-05-30
%%
Type: language
Subtag: dto
Description: Tommo So Dogon
Added: 2012-08-12
%%
Type: language
Subtag: dtp
Description: Kadazan Dusun
Description: Central Dusun
Added: 2009-07-29
%%
Type: language
Subtag: dtr
Description: Lotud
Added: 2009-07-29
%%
Type: language
Subtag: dts
Description: Toro So Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dtt
Description: Toro Tegu Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dtu
Description: Tebul Ure Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dty
Description: Dotyali
Added: 2012-08-12
Macrolanguage: ne
%%
Type: language
Subtag: dua
Description: Duala
Added: 2005-10-16
%%
Type: language
Subtag: dub
Description: Dubli
Added: 2009-07-29
%%
Type: language
Subtag: duc
Description: Duna
Added: 2009-07-29
%%
Type: language
Subtag: dud
Description: Hun-Saare
Added: 2009-07-29
Deprecated: 2019-04-16
Comments: see uth, uss
%%
Type: language
Subtag: due
Description: Umiray Dumaget Agta
Added: 2009-07-29
%%
Type: language
Subtag: duf
Description: Dumbea
Description: Drubea
Added: 2009-07-29
%%
Type: language
Subtag: dug
Description: Duruma
Description: Chiduruma
Added: 2009-07-29
%%
Type: language
Subtag: duh
Description: Dungra Bhil
Added: 2009-07-29
%%
Type: language
Subtag: dui
Description: Dumun
Added: 2009-07-29
%%
Type: language
Subtag: duj
Description: Dhuwal
Added: 2009-07-29
Deprecated: 2016-05-30
Comments: see dwu, dwy
%%
Type: language
Subtag: duk
Description: Uyajitaya
Added: 2009-07-29
%%
Type: language
Subtag: dul
Description: Alabat Island Agta
Added: 2009-07-29
%%
Type: language
Subtag: dum
Description: Middle Dutch (ca. 1050-1350)
Added: 2005-10-16
%%
Type: language
Subtag: dun
Description: Dusun Deyah
Added: 2009-07-29
%%
Type: language
Subtag: duo
Description: Dupaninan Agta
Added: 2009-07-29
%%
Type: language
Subtag: dup
Description: Duano
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: duq
Description: Dusun Malang
Added: 2009-07-29
%%
Type: language
Subtag: dur
Description: Dii
Added: 2009-07-29
%%
Type: language
Subtag: dus
Description: Dumi
Added: 2009-07-29
%%
Type: language
Subtag: duu
Description: Drung
Added: 2009-07-29
%%
Type: language
Subtag: duv
Description: Duvle
Added: 2009-07-29
%%
Type: language
Subtag: duw
Description: Dusun Witu
Added: 2009-07-29
%%
Type: language
Subtag: dux
Description: Duungooma
Added: 2009-07-29
%%
Type: language
Subtag: duy
Description: Dicamay Agta
Added: 2009-07-29
%%
Type: language
Subtag: duz
Description: Duli-Gey
Added: 2009-07-29
%%
Type: language
Subtag: dva
Description: Duau
Added: 2009-07-29
%%
Type: language
Subtag: dwa
Description: Diri
Added: 2009-07-29
%%
Type: language
Subtag: dwl
Description: Walo Kumbe Dogon
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see dbt, dbw
%%
Type: language
Subtag: dwr
Description: Dawro
Added: 2009-07-29
%%
Type: language
Subtag: dws
Description: Dutton World Speedwords
Added: 2009-07-29
%%
Type: language
Subtag: dwu
Description: Dhuwal
Added: 2016-05-30
%%
Type: language
Subtag: dww
Description: Dawawa
Added: 2009-07-29
%%
Type: language
Subtag: dwy
Description: Dhuwaya
Added: 2016-05-30
%%
Type: language
Subtag: dwz
Description: Dewas Rai
Added: 2018-10-28
%%
Type: language
Subtag: dya
Description: Dyan
Added: 2009-07-29
%%
Type: language
Subtag: dyb
Description: Dyaberdyaber
Added: 2009-07-29
%%
Type: language
Subtag: dyd
Description: Dyugun
Added: 2009-07-29
%%
Type: language
Subtag: dyg
Description: Villa Viciosa Agta
Added: 2009-07-29
%%
Type: language
Subtag: dyi
Description: Djimini Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: dym
Description: Yanda Dom Dogon
Added: 2009-07-29
%%
Type: language
Subtag: dyn
Description: Dyangadi
Description: Dhanggatti
Added: 2009-07-29
%%
Type: language
Subtag: dyo
Description: Jola-Fonyi
Added: 2009-07-29
%%
Type: language
Subtag: dyu
Description: Dyula
Added: 2005-10-16
%%
Type: language
Subtag: dyy
Description: Djabugay
Description: Dyaabugay
Added: 2009-07-29
%%
Type: language
Subtag: dza
Description: Tunzu
Added: 2009-07-29
%%
Type: language
Subtag: dzd
Description: Daza
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: dze
Description: Djiwarli
Added: 2013-09-10
%%
Type: language
Subtag: dzg
Description: Dazaga
Added: 2009-07-29
%%
Type: language
Subtag: dzl
Description: Dzalakha
Added: 2009-07-29
%%
Type: language
Subtag: dzn
Description: Dzando
Added: 2009-07-29
%%
Type: language
Subtag: eaa
Description: Karenggapa
Added: 2013-09-10
%%
Type: language
Subtag: ebg
Description: Ebughu
Added: 2009-07-29
%%
Type: language
Subtag: ebk
Description: Eastern Bontok
Added: 2010-03-11
Macrolanguage: bnc
%%
Type: language
Subtag: ebo
Description: Teke-Ebo
Added: 2009-07-29
%%
Type: language
Subtag: ebr
Description: Ebrié
Added: 2009-07-29
%%
Type: language
Subtag: ebu
Description: Embu
Description: Kiembu
Added: 2009-07-29
%%
Type: language
Subtag: ecr
Description: Eteocretan
Added: 2009-07-29
%%
Type: language
Subtag: ecs
Description: Ecuadorian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: ecy
Description: Eteocypriot
Added: 2009-07-29
%%
Type: language
Subtag: eee
Description: E
Added: 2009-07-29
%%
Type: language
Subtag: efa
Description: Efai
Added: 2009-07-29
%%
Type: language
Subtag: efe
Description: Efe
Added: 2009-07-29
%%
Type: language
Subtag: efi
Description: Efik
Added: 2005-10-16
%%
Type: language
Subtag: ega
Description: Ega
Added: 2009-07-29
%%
Type: language
Subtag: egl
Description: Emilian
Added: 2009-07-29
%%
Type: language
Subtag: ego
Description: Eggon
Added: 2009-07-29
%%
Type: language
Subtag: egx
Description: Egyptian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: egy
Description: Egyptian (Ancient)
Added: 2005-10-16
%%
Type: language
Subtag: ehu
Description: Ehueun
Added: 2009-07-29
%%
Type: language
Subtag: eip
Description: Eipomek
Added: 2009-07-29
%%
Type: language
Subtag: eit
Description: Eitiep
Added: 2009-07-29
%%
Type: language
Subtag: eiv
Description: Askopan
Added: 2009-07-29
%%
Type: language
Subtag: eja
Description: Ejamat
Added: 2009-07-29
%%
Type: language
Subtag: eka
Description: Ekajuk
Added: 2005-10-16
%%
Type: language
Subtag: ekc
Description: Eastern Karnic
Added: 2013-09-10
%%
Type: language
Subtag: eke
Description: Ekit
Added: 2009-07-29
%%
Type: language
Subtag: ekg
Description: Ekari
Added: 2009-07-29
%%
Type: language
Subtag: eki
Description: Eki
Added: 2009-07-29
%%
Type: language
Subtag: ekk
Description: Standard Estonian
Added: 2009-07-29
Macrolanguage: et
%%
Type: language
Subtag: ekl
Description: Kol (Bangladesh)
Description: Kol
Added: 2009-07-29
%%
Type: language
Subtag: ekm
Description: Elip
Added: 2009-07-29
%%
Type: language
Subtag: eko
Description: Koti
Added: 2009-07-29
%%
Type: language
Subtag: ekp
Description: Ekpeye
Added: 2009-07-29
%%
Type: language
Subtag: ekr
Description: Yace
Added: 2009-07-29
%%
Type: language
Subtag: eky
Description: Eastern Kayah
Added: 2009-07-29
%%
Type: language
Subtag: ele
Description: Elepi
Added: 2009-07-29
%%
Type: language
Subtag: elh
Description: El Hugeirat
Added: 2009-07-29
%%
Type: language
Subtag: eli
Description: Nding
Added: 2009-07-29
%%
Type: language
Subtag: elk
Description: Elkei
Added: 2009-07-29
%%
Type: language
Subtag: elm
Description: Eleme
Added: 2009-07-29
%%
Type: language
Subtag: elo
Description: El Molo
Added: 2009-07-29
%%
Type: language
Subtag: elp
Description: Elpaputih
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see amq, plh
%%
Type: language
Subtag: elu
Description: Elu
Added: 2009-07-29
%%
Type: language
Subtag: elx
Description: Elamite
Added: 2005-10-16
%%
Type: language
Subtag: ema
Description: Emai-Iuleha-Ora
Added: 2009-07-29
%%
Type: language
Subtag: emb
Description: Embaloh
Added: 2009-07-29
%%
Type: language
Subtag: eme
Description: Emerillon
Added: 2009-07-29
%%
Type: language
Subtag: emg
Description: Eastern Meohang
Added: 2009-07-29
%%
Type: language
Subtag: emi
Description: Mussau-Emira
Added: 2009-07-29
%%
Type: language
Subtag: emk
Description: Eastern Maninkakan
Added: 2009-07-29
Macrolanguage: man
%%
Type: language
Subtag: emm
Description: Mamulique
Added: 2009-07-29
%%
Type: language
Subtag: emn
Description: Eman
Added: 2009-07-29
%%
Type: language
Subtag: emo
Description: Emok
Added: 2009-07-29
Deprecated: 2014-02-28
%%
Type: language
Subtag: emp
Description: Northern Emberá
Added: 2009-07-29
%%
Type: language
Subtag: ems
Description: Pacific Gulf Yupik
Added: 2009-07-29
%%
Type: language
Subtag: emu
Description: Eastern Muria
Added: 2009-07-29
%%
Type: language
Subtag: emw
Description: Emplawas
Added: 2009-07-29
%%
Type: language
Subtag: emx
Description: Erromintxela
Added: 2010-03-11
%%
Type: language
Subtag: emy
Description: Epigraphic Mayan
Added: 2009-07-29
%%
Type: language
Subtag: ena
Description: Apali
Added: 2009-07-29
%%
Type: language
Subtag: enb
Description: Markweeta
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: enc
Description: En
Added: 2009-07-29
%%
Type: language
Subtag: end
Description: Ende
Added: 2009-07-29
%%
Type: language
Subtag: enf
Description: Forest Enets
Added: 2009-07-29
%%
Type: language
Subtag: enh
Description: Tundra Enets
Added: 2009-07-29
%%
Type: language
Subtag: enl
Description: Enlhet
Added: 2014-02-28
%%
Type: language
Subtag: enm
Description: Middle English (1100-1500)
Added: 2005-10-16
%%
Type: language
Subtag: enn
Description: Engenni
Added: 2009-07-29
%%
Type: language
Subtag: eno
Description: Enggano
Added: 2009-07-29
%%
Type: language
Subtag: enq
Description: Enga
Added: 2009-07-29
%%
Type: language
Subtag: enr
Description: Emumu
Description: Emem
Added: 2009-07-29
%%
Type: language
Subtag: enu
Description: Enu
Added: 2009-07-29
%%
Type: language
Subtag: env
Description: Enwan (Edu State)
Added: 2009-07-29
%%
Type: language
Subtag: enw
Description: Enwan (Akwa Ibom State)
Added: 2009-07-29
%%
Type: language
Subtag: enx
Description: Enxet
Added: 2014-02-28
%%
Type: language
Subtag: eot
Description: Beti (Côte d'Ivoire)
Added: 2009-07-29
%%
Type: language
Subtag: epi
Description: Epie
Added: 2009-07-29
%%
Type: language
Subtag: era
Description: Eravallan
Added: 2009-07-29
%%
Type: language
Subtag: erg
Description: Sie
Added: 2009-07-29
%%
Type: language
Subtag: erh
Description: Eruwa
Added: 2009-07-29
%%
Type: language
Subtag: eri
Description: Ogea
Added: 2009-07-29
%%
Type: language
Subtag: erk
Description: South Efate
Added: 2009-07-29
%%
Type: language
Subtag: ero
Description: Horpa
Added: 2009-07-29
%%
Type: language
Subtag: err
Description: Erre
Added: 2009-07-29
%%
Type: language
Subtag: ers
Description: Ersu
Added: 2009-07-29
%%
Type: language
Subtag: ert
Description: Eritai
Added: 2009-07-29
%%
Type: language
Subtag: erw
Description: Erokwanas
Added: 2009-07-29
%%
Type: language
Subtag: ese
Description: Ese Ejja
Added: 2009-07-29
%%
Type: language
Subtag: esg
Description: Aheri Gondi
Added: 2016-05-30
Macrolanguage: gon
%%
Type: language
Subtag: esh
Description: Eshtehardi
Added: 2009-07-29
%%
Type: language
Subtag: esi
Description: North Alaskan Inupiatun
Added: 2009-07-29
Macrolanguage: ik
%%
Type: language
Subtag: esk
Description: Northwest Alaska Inupiatun
Added: 2009-07-29
Macrolanguage: ik
%%
Type: language
Subtag: esl
Description: Egypt Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: esm
Description: Esuma
Added: 2009-07-29
%%
Type: language
Subtag: esn
Description: Salvadoran Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: eso
Description: Estonian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: esq
Description: Esselen
Added: 2009-07-29
%%
Type: language
Subtag: ess
Description: Central Siberian Yupik
Added: 2009-07-29
%%
Type: language
Subtag: esu
Description: Central Yupik
Added: 2009-07-29
%%
Type: language
Subtag: esx
Description: Eskimo-Aleut languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: esy
Description: Eskayan
Added: 2014-04-06
%%
Type: language
Subtag: etb
Description: Etebi
Added: 2009-07-29
%%
Type: language
Subtag: etc
Description: Etchemin
Added: 2009-07-29
%%
Type: language
Subtag: eth
Description: Ethiopian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: etn
Description: Eton (Vanuatu)
Added: 2009-07-29
%%
Type: language
Subtag: eto
Description: Eton (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: etr
Description: Edolo
Added: 2009-07-29
%%
Type: language
Subtag: ets
Description: Yekhee
Added: 2009-07-29
%%
Type: language
Subtag: ett
Description: Etruscan
Added: 2009-07-29
%%
Type: language
Subtag: etu
Description: Ejagham
Added: 2009-07-29
%%
Type: language
Subtag: etx
Description: Eten
Added: 2009-07-29
%%
Type: language
Subtag: etz
Description: Semimi
Added: 2009-07-29
%%
Type: language
Subtag: euq
Description: Basque (family)
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: eve
Description: Even
Added: 2009-07-29
%%
Type: language
Subtag: evh
Description: Uvbie
Added: 2009-07-29
%%
Type: language
Subtag: evn
Description: Evenki
Added: 2009-07-29
%%
Type: language
Subtag: ewo
Description: Ewondo
Added: 2005-10-16
%%
Type: language
Subtag: ext
Description: Extremaduran
Added: 2009-07-29
%%
Type: language
Subtag: eya
Description: Eyak
Added: 2009-07-29
%%
Type: language
Subtag: eyo
Description: Keiyo
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: eza
Description: Ezaa
Added: 2013-09-10
%%
Type: language
Subtag: eze
Description: Uzekwe
Added: 2009-07-29
%%
Type: language
Subtag: faa
Description: Fasu
Added: 2009-07-29
%%
Type: language
Subtag: fab
Description: Fa d'Ambu
Added: 2009-07-29
%%
Type: language
Subtag: fad
Description: Wagi
Added: 2009-07-29
%%
Type: language
Subtag: faf
Description: Fagani
Added: 2009-07-29
%%
Type: language
Subtag: fag
Description: Finongan
Added: 2009-07-29
%%
Type: language
Subtag: fah
Description: Baissa Fali
Added: 2009-07-29
%%
Type: language
Subtag: fai
Description: Faiwol
Added: 2009-07-29
%%
Type: language
Subtag: faj
Description: Faita
Added: 2009-07-29
%%
Type: language
Subtag: fak
Description: Fang (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: fal
Description: South Fali
Added: 2009-07-29
%%
Type: language
Subtag: fam
Description: Fam
Added: 2009-07-29
%%
Type: language
Subtag: fan
Description: Fang (Equatorial Guinea)
Added: 2005-10-16
%%
Type: language
Subtag: fap
Description: Paloor
Added: 2009-07-29
%%
Type: language
Subtag: far
Description: Fataleka
Added: 2009-07-29
%%
Type: language
Subtag: fat
Description: Fanti
Added: 2005-10-16
Macrolanguage: ak
%%
Type: language
Subtag: fau
Description: Fayu
Added: 2009-07-29
%%
Type: language
Subtag: fax
Description: Fala
Added: 2009-07-29
%%
Type: language
Subtag: fay
Description: Southwestern Fars
Added: 2009-07-29
%%
Type: language
Subtag: faz
Description: Northwestern Fars
Added: 2009-07-29
%%
Type: language
Subtag: fbl
Description: West Albay Bikol
Added: 2010-03-11
Macrolanguage: bik
%%
Type: language
Subtag: fcs
Description: Quebec Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: fer
Description: Feroge
Added: 2009-07-29
%%
Type: language
Subtag: ffi
Description: Foia Foia
Added: 2009-07-29
%%
Type: language
Subtag: ffm
Description: Maasina Fulfulde
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fgr
Description: Fongoro
Added: 2009-07-29
%%
Type: language
Subtag: fia
Description: Nobiin
Added: 2009-07-29
%%
Type: language
Subtag: fie
Description: Fyer
Added: 2009-07-29
%%
Type: language
Subtag: fil
Description: Filipino
Description: Pilipino
Added: 2005-10-16
%%
Type: language
Subtag: fip
Description: Fipa
Added: 2009-07-29
%%
Type: language
Subtag: fir
Description: Firan
Added: 2009-07-29
%%
Type: language
Subtag: fit
Description: Tornedalen Finnish
Added: 2009-07-29
%%
Type: language
Subtag: fiu
Description: Finno-Ugrian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: fiw
Description: Fiwaga
Added: 2009-07-29
%%
Type: language
Subtag: fkk
Description: Kirya-Konzəl
Added: 2012-08-12
%%
Type: language
Subtag: fkv
Description: Kven Finnish
Added: 2009-07-29
%%
Type: language
Subtag: fla
Description: Kalispel-Pend d'Oreille
Added: 2009-07-29
%%
Type: language
Subtag: flh
Description: Foau
Added: 2009-07-29
%%
Type: language
Subtag: fli
Description: Fali
Added: 2009-07-29
%%
Type: language
Subtag: fll
Description: North Fali
Added: 2009-07-29
%%
Type: language
Subtag: fln
Description: Flinders Island
Added: 2009-07-29
%%
Type: language
Subtag: flr
Description: Fuliiru
Added: 2009-07-29
%%
Type: language
Subtag: fly
Description: Flaaitaal
Description: Tsotsitaal
Added: 2009-07-29
%%
Type: language
Subtag: fmp
Description: Fe'fe'
Added: 2009-07-29
%%
Type: language
Subtag: fmu
Description: Far Western Muria
Added: 2009-07-29
%%
Type: language
Subtag: fnb
Description: Fanbak
Added: 2016-05-30
%%
Type: language
Subtag: fng
Description: Fanagalo
Added: 2009-07-29
%%
Type: language
Subtag: fni
Description: Fania
Added: 2009-07-29
%%
Type: language
Subtag: fod
Description: Foodo
Added: 2009-07-29
%%
Type: language
Subtag: foi
Description: Foi
Added: 2009-07-29
%%
Type: language
Subtag: fom
Description: Foma
Added: 2009-07-29
%%
Type: language
Subtag: fon
Description: Fon
Added: 2005-10-16
%%
Type: language
Subtag: for
Description: Fore
Added: 2009-07-29
%%
Type: language
Subtag: fos
Description: Siraya
Added: 2009-07-29
%%
Type: language
Subtag: fox
Description: Formosan languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: fpe
Description: Fernando Po Creole English
Added: 2009-07-29
%%
Type: language
Subtag: fqs
Description: Fas
Added: 2009-07-29
%%
Type: language
Subtag: frc
Description: Cajun French
Added: 2009-07-29
%%
Type: language
Subtag: frd
Description: Fordata
Added: 2009-07-29
%%
Type: language
Subtag: frk
Description: Frankish
Added: 2009-07-29
%%
Type: language
Subtag: frm
Description: Middle French (ca. 1400-1600)
Added: 2005-10-16
%%
Type: language
Subtag: fro
Description: Old French (842-ca. 1400)
Added: 2005-10-16
%%
Type: language
Subtag: frp
Description: Arpitan
Description: Francoprovençal
Added: 2009-07-29
%%
Type: language
Subtag: frq
Description: Forak
Added: 2009-07-29
%%
Type: language
Subtag: frr
Description: Northern Frisian
Added: 2006-03-08
Suppress-Script: Latn
%%
Type: language
Subtag: frs
Description: Eastern Frisian
Added: 2006-03-08
Suppress-Script: Latn
%%
Type: language
Subtag: frt
Description: Fortsenal
Added: 2009-07-29
%%
Type: language
Subtag: fse
Description: Finnish Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: fsl
Description: French Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: fss
Description: Finland-Swedish Sign Language
Description: finlandssvenskt teckenspråk
Description: suomenruotsalainen viittomakieli
Added: 2009-07-29
%%
Type: language
Subtag: fub
Description: Adamawa Fulfulde
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fuc
Description: Pulaar
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fud
Description: East Futuna
Added: 2009-07-29
%%
Type: language
Subtag: fue
Description: Borgu Fulfulde
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fuf
Description: Pular
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fuh
Description: Western Niger Fulfulde
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fui
Description: Bagirmi Fulfulde
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fuj
Description: Ko
Added: 2009-07-29
%%
Type: language
Subtag: fum
Description: Fum
Added: 2009-07-29
%%
Type: language
Subtag: fun
Description: Fulniô
Added: 2009-07-29
%%
Type: language
Subtag: fuq
Description: Central-Eastern Niger Fulfulde
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fur
Description: Friulian
Added: 2005-10-16
%%
Type: language
Subtag: fut
Description: Futuna-Aniwa
Added: 2009-07-29
%%
Type: language
Subtag: fuu
Description: Furu
Added: 2009-07-29
%%
Type: language
Subtag: fuv
Description: Nigerian Fulfulde
Added: 2009-07-29
Macrolanguage: ff
%%
Type: language
Subtag: fuy
Description: Fuyug
Added: 2009-07-29
%%
Type: language
Subtag: fvr
Description: Fur
Added: 2009-07-29
%%
Type: language
Subtag: fwa
Description: Fwâi
Added: 2009-07-29
%%
Type: language
Subtag: fwe
Description: Fwe
Added: 2009-07-29
%%
Type: language
Subtag: gaa
Description: Ga
Added: 2005-10-16
%%
Type: language
Subtag: gab
Description: Gabri
Added: 2009-07-29
%%
Type: language
Subtag: gac
Description: Mixed Great Andamanese
Added: 2010-03-11
%%
Type: language
Subtag: gad
Description: Gaddang
Added: 2009-07-29
%%
Type: language
Subtag: gae
Description: Guarequena
Added: 2009-07-29
%%
Type: language
Subtag: gaf
Description: Gende
Added: 2009-07-29
%%
Type: language
Subtag: gag
Description: Gagauz
Added: 2009-07-29
%%
Type: language
Subtag: gah
Description: Alekano
Added: 2009-07-29
%%
Type: language
Subtag: gai
Description: Borei
Added: 2009-07-29
%%
Type: language
Subtag: gaj
Description: Gadsup
Added: 2009-07-29
%%
Type: language
Subtag: gak
Description: Gamkonora
Added: 2009-07-29
%%
Type: language
Subtag: gal
Description: Galolen
Added: 2009-07-29
%%
Type: language
Subtag: gam
Description: Kandawo
Added: 2009-07-29
%%
Type: language
Subtag: gan
Description: Gan Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: gao
Description: Gants
Added: 2009-07-29
%%
Type: language
Subtag: gap
Description: Gal
Added: 2009-07-29
%%
Type: language
Subtag: gaq
Description: Gata'
Added: 2009-07-29
%%
Type: language
Subtag: gar
Description: Galeya
Added: 2009-07-29
%%
Type: language
Subtag: gas
Description: Adiwasi Garasia
Added: 2009-07-29
%%
Type: language
Subtag: gat
Description: Kenati
Added: 2009-07-29
%%
Type: language
Subtag: gau
Description: Mudhili Gadaba
Added: 2009-07-29
%%
Type: language
Subtag: gav
Description: Gabutamon
Added: 2009-07-29
Deprecated: 2010-03-11
Preferred-Value: dev
%%
Type: language
Subtag: gaw
Description: Nobonob
Added: 2009-07-29
%%
Type: language
Subtag: gax
Description: Borana-Arsi-Guji Oromo
Added: 2009-07-29
Macrolanguage: om
%%
Type: language
Subtag: gay
Description: Gayo
Added: 2005-10-16
%%
Type: language
Subtag: gaz
Description: West Central Oromo
Added: 2009-07-29
Macrolanguage: om
%%
Type: language
Subtag: gba
Description: Gbaya (Central African Republic)
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: gbb
Description: Kaytetye
Added: 2009-07-29
%%
Type: language
Subtag: gbc
Description: Garawa
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see wny, wrk
%%
Type: language
Subtag: gbd
Description: Karajarri
Added: 2009-07-29
%%
Type: language
Subtag: gbe
Description: Niksek
Added: 2009-07-29
%%
Type: language
Subtag: gbf
Description: Gaikundi
Added: 2009-07-29
%%
Type: language
Subtag: gbg
Description: Gbanziri
Added: 2009-07-29
%%
Type: language
Subtag: gbh
Description: Defi Gbe
Added: 2009-07-29
%%
Type: language
Subtag: gbi
Description: Galela
Added: 2009-07-29
%%
Type: language
Subtag: gbj
Description: Bodo Gadaba
Added: 2009-07-29
%%
Type: language
Subtag: gbk
Description: Gaddi
Added: 2009-07-29
%%
Type: language
Subtag: gbl
Description: Gamit
Added: 2009-07-29
%%
Type: language
Subtag: gbm
Description: Garhwali
Added: 2009-07-29
%%
Type: language
Subtag: gbn
Description: Mo'da
Added: 2009-07-29
%%
Type: language
Subtag: gbo
Description: Northern Grebo
Added: 2009-07-29
Macrolanguage: grb
%%
Type: language
Subtag: gbp
Description: Gbaya-Bossangoa
Added: 2009-07-29
Macrolanguage: gba
%%
Type: language
Subtag: gbq
Description: Gbaya-Bozoum
Added: 2009-07-29
Macrolanguage: gba
%%
Type: language
Subtag: gbr
Description: Gbagyi
Added: 2009-07-29
%%
Type: language
Subtag: gbs
Description: Gbesi Gbe
Added: 2009-07-29
%%
Type: language
Subtag: gbu
Description: Gagadu
Added: 2009-07-29
%%
Type: language
Subtag: gbv
Description: Gbanu
Added: 2009-07-29
%%
Type: language
Subtag: gbw
Description: Gabi-Gabi
Added: 2013-09-10
%%
Type: language
Subtag: gbx
Description: Eastern Xwla Gbe
Added: 2009-07-29
%%
Type: language
Subtag: gby
Description: Gbari
Added: 2009-07-29
%%
Type: language
Subtag: gbz
Description: Zoroastrian Dari
Added: 2009-07-29
%%
Type: language
Subtag: gcc
Description: Mali
Added: 2009-07-29
%%
Type: language
Subtag: gcd
Description: Ganggalida
Added: 2009-07-29
%%
Type: language
Subtag: gce
Description: Galice
Added: 2009-07-29
%%
Type: language
Subtag: gcf
Description: Guadeloupean Creole French
Added: 2009-07-29
%%
Type: language
Subtag: gcl
Description: Grenadian Creole English
Added: 2009-07-29
%%
Type: language
Subtag: gcn
Description: Gaina
Added: 2009-07-29
%%
Type: language
Subtag: gcr
Description: Guianese Creole French
Added: 2009-07-29
%%
Type: language
Subtag: gct
Description: Colonia Tovar German
Added: 2009-07-29
%%
Type: language
Subtag: gda
Description: Gade Lohar
Added: 2009-07-29
Macrolanguage: raj
%%
Type: language
Subtag: gdb
Description: Pottangi Ollar Gadaba
Added: 2009-07-29
%%
Type: language
Subtag: gdc
Description: Gugu Badhun
Added: 2009-07-29
%%
Type: language
Subtag: gdd
Description: Gedaged
Added: 2009-07-29
%%
Type: language
Subtag: gde
Description: Gude
Added: 2009-07-29
%%
Type: language
Subtag: gdf
Description: Guduf-Gava
Added: 2009-07-29
%%
Type: language
Subtag: gdg
Description: Ga'dang
Added: 2009-07-29
%%
Type: language
Subtag: gdh
Description: Gadjerawang
Added: 2009-07-29
%%
Type: language
Subtag: gdi
Description: Gundi
Added: 2009-07-29
%%
Type: language
Subtag: gdj
Description: Gurdjar
Added: 2009-07-29
%%
Type: language
Subtag: gdk
Description: Gadang
Added: 2009-07-29
%%
Type: language
Subtag: gdl
Description: Dirasha
Added: 2009-07-29
%%
Type: language
Subtag: gdm
Description: Laal
Added: 2009-07-29
%%
Type: language
Subtag: gdn
Description: Umanakaina
Added: 2009-07-29
%%
Type: language
Subtag: gdo
Description: Ghodoberi
Added: 2009-07-29
%%
Type: language
Subtag: gdq
Description: Mehri
Added: 2009-07-29
%%
Type: language
Subtag: gdr
Description: Wipi
Added: 2009-07-29
%%
Type: language
Subtag: gds
Description: Ghandruk Sign Language
Added: 2012-08-12
%%
Type: language
Subtag: gdt
Description: Kungardutyi
Added: 2013-09-10
%%
Type: language
Subtag: gdu
Description: Gudu
Added: 2009-07-29
%%
Type: language
Subtag: gdx
Description: Godwari
Added: 2009-07-29
%%
Type: language
Subtag: gea
Description: Geruma
Added: 2009-07-29
%%
Type: language
Subtag: geb
Description: Kire
Added: 2009-07-29
%%
Type: language
Subtag: gec
Description: Gboloo Grebo
Added: 2009-07-29
Macrolanguage: grb
%%
Type: language
Subtag: ged
Description: Gade
Added: 2009-07-29
%%
Type: language
Subtag: geg
Description: Gengle
Added: 2009-07-29
%%
Type: language
Subtag: geh
Description: Hutterite German
Description: Hutterisch
Added: 2009-07-29
%%
Type: language
Subtag: gei
Description: Gebe
Added: 2009-07-29
%%
Type: language
Subtag: gej
Description: Gen
Added: 2009-07-29
%%
Type: language
Subtag: gek
Description: Ywom
Added: 2009-07-29
%%
Type: language
Subtag: gel
Description: ut-Ma'in
Added: 2009-07-29
%%
Type: language
Subtag: gem
Description: Germanic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: geq
Description: Geme
Added: 2009-07-29
%%
Type: language
Subtag: ges
Description: Geser-Gorom
Added: 2009-07-29
%%
Type: language
Subtag: gev
Description: Eviya
Added: 2014-02-28
%%
Type: language
Subtag: gew
Description: Gera
Added: 2009-07-29
%%
Type: language
Subtag: gex
Description: Garre
Added: 2009-07-29
%%
Type: language
Subtag: gey
Description: Enya
Added: 2009-07-29
%%
Type: language
Subtag: gez
Description: Geez
Added: 2005-10-16
%%
Type: language
Subtag: gfk
Description: Patpatar
Added: 2009-07-29
%%
Type: language
Subtag: gft
Description: Gafat
Added: 2009-07-29
%%
Type: language
Subtag: gfx
Description: Mangetti Dune ǃXung
Added: 2012-08-12
Deprecated: 2015-02-12
Preferred-Value: vaj
%%
Type: language
Subtag: gga
Description: Gao
Added: 2009-07-29
%%
Type: language
Subtag: ggb
Description: Gbii
Added: 2009-07-29
%%
Type: language
Subtag: ggd
Description: Gugadj
Added: 2009-07-29
%%
Type: language
Subtag: gge
Description: Gurr-goni
Added: 2009-07-29
%%
Type: language
Subtag: ggg
Description: Gurgula
Added: 2009-07-29
%%
Type: language
Subtag: ggk
Description: Kungarakany
Added: 2009-07-29
%%
Type: language
Subtag: ggl
Description: Ganglau
Added: 2009-07-29
%%
Type: language
Subtag: ggn
Description: Eastern Gurung
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: gvr
%%
Type: language
Subtag: ggo
Description: Southern Gondi
Added: 2009-07-29
Deprecated: 2016-05-30
Comments: see esg, wsg
%%
Type: language
Subtag: ggr
Description: Aghu Tharnggalu
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see gtu, ikr
%%
Type: language
Subtag: ggt
Description: Gitua
Added: 2009-07-29
%%
Type: language
Subtag: ggu
Description: Gagu
Description: Gban
Added: 2009-07-29
%%
Type: language
Subtag: ggw
Description: Gogodala
Added: 2009-07-29
%%
Type: language
Subtag: gha
Description: Ghadamès
Added: 2009-07-29
%%
Type: language
Subtag: ghc
Description: Hiberno-Scottish Gaelic
Added: 2009-07-29
%%
Type: language
Subtag: ghe
Description: Southern Ghale
Added: 2009-07-29
%%
Type: language
Subtag: ghh
Description: Northern Ghale
Added: 2009-07-29
%%
Type: language
Subtag: ghk
Description: Geko Karen
Added: 2009-07-29
%%
Type: language
Subtag: ghl
Description: Ghulfan
Added: 2009-07-29
%%
Type: language
Subtag: ghn
Description: Ghanongga
Added: 2009-07-29
%%
Type: language
Subtag: gho
Description: Ghomara
Added: 2009-07-29
%%
Type: language
Subtag: ghr
Description: Ghera
Added: 2009-07-29
%%
Type: language
Subtag: ghs
Description: Guhu-Samane
Added: 2009-07-29
%%
Type: language
Subtag: ght
Description: Kuke
Description: Kutang Ghale
Added: 2009-07-29
%%
Type: language
Subtag: gia
Description: Kija
Added: 2009-07-29
%%
Type: language
Subtag: gib
Description: Gibanawa
Added: 2009-07-29
%%
Type: language
Subtag: gic
Description: Gail
Added: 2009-07-29
%%
Type: language
Subtag: gid
Description: Gidar
Added: 2009-07-29
%%
Type: language
Subtag: gie
Description: Gaɓogbo
Description: Guébie
Added: 2017-02-23
%%
Type: language
Subtag: gig
Description: Goaria
Added: 2009-07-29
%%
Type: language
Subtag: gih
Description: Githabul
Added: 2013-09-10
%%
Type: language
Subtag: gil
Description: Gilbertese
Added: 2005-10-16
%%
Type: language
Subtag: gim
Description: Gimi (Eastern Highlands)
Added: 2009-07-29
%%
Type: language
Subtag: gin
Description: Hinukh
Added: 2009-07-29
%%
Type: language
Subtag: gio
Description: Gelao
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see aou, gqu
%%
Type: language
Subtag: gip
Description: Gimi (West New Britain)
Added: 2009-07-29
%%
Type: language
Subtag: giq
Description: Green Gelao
Added: 2009-07-29
%%
Type: language
Subtag: gir
Description: Red Gelao
Added: 2009-07-29
%%
Type: language
Subtag: gis
Description: North Giziga
Added: 2009-07-29
%%
Type: language
Subtag: git
Description: Gitxsan
Added: 2009-07-29
%%
Type: language
Subtag: giu
Description: Mulao
Added: 2012-08-12
%%
Type: language
Subtag: giw
Description: White Gelao
Added: 2009-07-29
%%
Type: language
Subtag: gix
Description: Gilima
Added: 2009-07-29
%%
Type: language
Subtag: giy
Description: Giyug
Added: 2009-07-29
%%
Type: language
Subtag: giz
Description: South Giziga
Added: 2009-07-29
%%
Type: language
Subtag: gji
Description: Geji
Added: 2009-07-29
%%
Type: language
Subtag: gjk
Description: Kachi Koli
Added: 2009-07-29
%%
Type: language
Subtag: gjm
Description: Gunditjmara
Added: 2013-09-10
%%
Type: language
Subtag: gjn
Description: Gonja
Added: 2009-07-29
%%
Type: language
Subtag: gjr
Description: Gurindji Kriol
Added: 2016-05-30
%%
Type: language
Subtag: gju
Description: Gujari
Added: 2009-07-29
Macrolanguage: raj
%%
Type: language
Subtag: gka
Description: Guya
Added: 2009-07-29
%%
Type: language
Subtag: gkd
Description: Magɨ (Madang Province)
Added: 2018-03-08
%%
Type: language
Subtag: gke
Description: Ndai
Added: 2009-07-29
%%
Type: language
Subtag: gkn
Description: Gokana
Added: 2009-07-29
%%
Type: language
Subtag: gko
Description: Kok-Nar
Added: 2012-08-12
%%
Type: language
Subtag: gkp
Description: Guinea Kpelle
Added: 2009-07-29
Macrolanguage: kpe
%%
Type: language
Subtag: gku
Description: ǂUngkue
Added: 2015-02-12
%%
Type: language
Subtag: glc
Description: Bon Gula
Added: 2009-07-29
%%
Type: language
Subtag: gld
Description: Nanai
Added: 2009-07-29
%%
Type: language
Subtag: glh
Description: Northwest Pashai
Description: Northwest Pashayi
Added: 2009-07-29
%%
Type: language
Subtag: gli
Description: Guliguli
Added: 2009-07-29
%%
Type: language
Subtag: glj
Description: Gula Iro
Added: 2009-07-29
%%
Type: language
Subtag: glk
Description: Gilaki
Added: 2009-07-29
%%
Type: language
Subtag: gll
Description: Garlali
Added: 2013-09-10
%%
Type: language
Subtag: glo
Description: Galambu
Added: 2009-07-29
%%
Type: language
Subtag: glr
Description: Glaro-Twabo
Added: 2009-07-29
%%
Type: language
Subtag: glu
Description: Gula (Chad)
Added: 2009-07-29
%%
Type: language
Subtag: glw
Description: Glavda
Added: 2009-07-29
%%
Type: language
Subtag: gly
Description: Gule
Added: 2009-07-29
%%
Type: language
Subtag: gma
Description: Gambera
Added: 2009-07-29
%%
Type: language
Subtag: gmb
Description: Gula'alaa
Added: 2009-07-29
%%
Type: language
Subtag: gmd
Description: Mághdì
Added: 2009-07-29
%%
Type: language
Subtag: gme
Description: East Germanic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: gmg
Description: Magɨyi
Added: 2014-02-28
%%
Type: language
Subtag: gmh
Description: Middle High German (ca. 1050-1500)
Added: 2005-10-16
%%
Type: language
Subtag: gml
Description: Middle Low German
Added: 2009-07-29
%%
Type: language
Subtag: gmm
Description: Gbaya-Mbodomo
Added: 2009-07-29
Macrolanguage: gba
%%
Type: language
Subtag: gmn
Description: Gimnime
Added: 2009-07-29
%%
Type: language
Subtag: gmq
Description: North Germanic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: gmu
Description: Gumalu
Added: 2009-07-29
%%
Type: language
Subtag: gmv
Description: Gamo
Added: 2009-07-29
%%
Type: language
Subtag: gmw
Description: West Germanic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: gmx
Description: Magoma
Added: 2009-07-29
%%
Type: language
Subtag: gmy
Description: Mycenaean Greek
Added: 2009-07-29
%%
Type: language
Subtag: gmz
Description: Mgbolizhia
Added: 2013-09-10
%%
Type: language
Subtag: gna
Description: Kaansa
Added: 2009-07-29
%%
Type: language
Subtag: gnb
Description: Gangte
Added: 2009-07-29
%%
Type: language
Subtag: gnc
Description: Guanche
Added: 2009-07-29
%%
Type: language
Subtag: gnd
Description: Zulgo-Gemzek
Added: 2009-07-29
%%
Type: language
Subtag: gne
Description: Ganang
Added: 2009-07-29
%%
Type: language
Subtag: gng
Description: Ngangam
Added: 2009-07-29
%%
Type: language
Subtag: gnh
Description: Lere
Added: 2009-07-29
%%
Type: language
Subtag: gni
Description: Gooniyandi
Added: 2009-07-29
%%
Type: language
Subtag: gnj
Description: Ngen
Added: 2018-03-08
%%
Type: language
Subtag: gnk
Description: ǁGana
Added: 2009-07-29
%%
Type: language
Subtag: gnl
Description: Gangulu
Added: 2009-07-29
%%
Type: language
Subtag: gnm
Description: Ginuman
Added: 2009-07-29
%%
Type: language
Subtag: gnn
Description: Gumatj
Added: 2009-07-29
%%
Type: language
Subtag: gno
Description: Northern Gondi
Added: 2009-07-29
Macrolanguage: gon
%%
Type: language
Subtag: gnq
Description: Gana
Added: 2009-07-29
%%
Type: language
Subtag: gnr
Description: Gureng Gureng
Added: 2009-07-29
%%
Type: language
Subtag: gnt
Description: Guntai
Added: 2009-07-29
%%
Type: language
Subtag: gnu
Description: Gnau
Added: 2009-07-29
%%
Type: language
Subtag: gnw
Description: Western Bolivian Guaraní
Added: 2009-07-29
Macrolanguage: gn
%%
Type: language
Subtag: gnz
Description: Ganzi
Added: 2009-07-29
%%
Type: language
Subtag: goa
Description: Guro
Added: 2009-07-29
%%
Type: language
Subtag: gob
Description: Playero
Added: 2009-07-29
%%
Type: language
Subtag: goc
Description: Gorakor
Added: 2009-07-29
%%
Type: language
Subtag: god
Description: Godié
Added: 2009-07-29
%%
Type: language
Subtag: goe
Description: Gongduk
Added: 2009-07-29
%%
Type: language
Subtag: gof
Description: Gofa
Added: 2009-07-29
%%
Type: language
Subtag: gog
Description: Gogo
Added: 2009-07-29
%%
Type: language
Subtag: goh
Description: Old High German (ca. 750-1050)
Added: 2005-10-16
%%
Type: language
Subtag: goi
Description: Gobasi
Added: 2009-07-29
%%
Type: language
Subtag: goj
Description: Gowlan
Added: 2009-07-29
%%
Type: language
Subtag: gok
Description: Gowli
Added: 2009-07-29
%%
Type: language
Subtag: gol
Description: Gola
Added: 2009-07-29
%%
Type: language
Subtag: gom
Description: Goan Konkani
Added: 2009-07-29
Macrolanguage: kok
%%
Type: language
Subtag: gon
Description: Gondi
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: goo
Description: Gone Dau
Added: 2009-07-29
%%
Type: language
Subtag: gop
Description: Yeretuar
Added: 2009-07-29
%%
Type: language
Subtag: goq
Description: Gorap
Added: 2009-07-29
%%
Type: language
Subtag: gor
Description: Gorontalo
Added: 2005-10-16
%%
Type: language
Subtag: gos
Description: Gronings
Added: 2009-07-29
%%
Type: language
Subtag: got
Description: Gothic
Added: 2005-10-16
%%
Type: language
Subtag: gou
Description: Gavar
Added: 2009-07-29
%%
Type: language
Subtag: gow
Description: Gorowa
Added: 2009-07-29
%%
Type: language
Subtag: gox
Description: Gobu
Added: 2009-07-29
%%
Type: language
Subtag: goy
Description: Goundo
Added: 2009-07-29
%%
Type: language
Subtag: goz
Description: Gozarkhani
Added: 2009-07-29
%%
Type: language
Subtag: gpa
Description: Gupa-Abawa
Added: 2009-07-29
%%
Type: language
Subtag: gpe
Description: Ghanaian Pidgin English
Added: 2012-08-12
%%
Type: language
Subtag: gpn
Description: Taiap
Added: 2009-07-29
%%
Type: language
Subtag: gqa
Description: Ga'anda
Added: 2009-07-29
%%
Type: language
Subtag: gqi
Description: Guiqiong
Added: 2009-07-29
%%
Type: language
Subtag: gqn
Description: Guana (Brazil)
Added: 2009-07-29
%%
Type: language
Subtag: gqr
Description: Gor
Added: 2009-07-29
%%
Type: language
Subtag: gqu
Description: Qau
Added: 2012-08-12
%%
Type: language
Subtag: gra
Description: Rajput Garasia
Added: 2009-07-29
%%
Type: language
Subtag: grb
Description: Grebo
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: grc
Description: Ancient Greek (to 1453)
Added: 2005-10-16
%%
Type: language
Subtag: grd
Description: Guruntum-Mbaaru
Added: 2009-07-29
%%
Type: language
Subtag: grg
Description: Madi
Added: 2009-07-29
%%
Type: language
Subtag: grh
Description: Gbiri-Niragu
Added: 2009-07-29
%%
Type: language
Subtag: gri
Description: Ghari
Added: 2009-07-29
%%
Type: language
Subtag: grj
Description: Southern Grebo
Added: 2009-07-29
Macrolanguage: grb
%%
Type: language
Subtag: grk
Description: Greek languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: grm
Description: Kota Marudu Talantang
Added: 2009-07-29
%%
Type: language
Subtag: gro
Description: Groma
Added: 2009-07-29
%%
Type: language
Subtag: grq
Description: Gorovu
Added: 2009-07-29
%%
Type: language
Subtag: grr
Description: Taznatit
Added: 2009-07-29
%%
Type: language
Subtag: grs
Description: Gresi
Added: 2009-07-29
%%
Type: language
Subtag: grt
Description: Garo
Added: 2009-07-29
%%
Type: language
Subtag: gru
Description: Kistane
Added: 2009-07-29
%%
Type: language
Subtag: grv
Description: Central Grebo
Added: 2009-07-29
Macrolanguage: grb
%%
Type: language
Subtag: grw
Description: Gweda
Added: 2009-07-29
%%
Type: language
Subtag: grx
Description: Guriaso
Added: 2009-07-29
%%
Type: language
Subtag: gry
Description: Barclayville Grebo
Added: 2009-07-29
Macrolanguage: grb
%%
Type: language
Subtag: grz
Description: Guramalum
Added: 2009-07-29
%%
Type: language
Subtag: gse
Description: Ghanaian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: gsg
Description: German Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: gsl
Description: Gusilay
Added: 2009-07-29
%%
Type: language
Subtag: gsm
Description: Guatemalan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: gsn
Description: Nema
Description: Gusan
Added: 2009-07-29
%%
Type: language
Subtag: gso
Description: Southwest Gbaya
Added: 2009-07-29
Macrolanguage: gba
%%
Type: language
Subtag: gsp
Description: Wasembo
Added: 2009-07-29
%%
Type: language
Subtag: gss
Description: Greek Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: gsw
Description: Swiss German
Description: Alemannic
Description: Alsatian
Added: 2006-03-08
Suppress-Script: Latn
%%
Type: language
Subtag: gta
Description: Guató
Added: 2009-07-29
%%
Type: language
Subtag: gti
Description: Gbati-ri
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: nyc
%%
Type: language
Subtag: gtu
Description: Aghu-Tharnggala
Added: 2013-09-10
%%
Type: language
Subtag: gua
Description: Shiki
Added: 2009-07-29
%%
Type: language
Subtag: gub
Description: Guajajára
Added: 2009-07-29
%%
Type: language
Subtag: guc
Description: Wayuu
Added: 2009-07-29
%%
Type: language
Subtag: gud
Description: Yocoboué Dida
Added: 2009-07-29
%%
Type: language
Subtag: gue
Description: Gurindji
Added: 2009-07-29
%%
Type: language
Subtag: guf
Description: Gupapuyngu
Added: 2009-07-29
%%
Type: language
Subtag: gug
Description: Paraguayan Guaraní
Added: 2009-07-29
Macrolanguage: gn
%%
Type: language
Subtag: guh
Description: Guahibo
Added: 2009-07-29
%%
Type: language
Subtag: gui
Description: Eastern Bolivian Guaraní
Added: 2009-07-29
Macrolanguage: gn
%%
Type: language
Subtag: guk
Description: Gumuz
Added: 2009-07-29
%%
Type: language
Subtag: gul
Description: Sea Island Creole English
Added: 2009-07-29
%%
Type: language
Subtag: gum
Description: Guambiano
Added: 2009-07-29
%%
Type: language
Subtag: gun
Description: Mbyá Guaraní
Added: 2009-07-29
Macrolanguage: gn
%%
Type: language
Subtag: guo
Description: Guayabero
Added: 2009-07-29
%%
Type: language
Subtag: gup
Description: Gunwinggu
Added: 2009-07-29
%%
Type: language
Subtag: guq
Description: Aché
Added: 2009-07-29
%%
Type: language
Subtag: gur
Description: Farefare
Added: 2009-07-29
%%
Type: language
Subtag: gus
Description: Guinean Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: gut
Description: Maléku Jaíka
Added: 2009-07-29
%%
Type: language
Subtag: guu
Description: Yanomamö
Added: 2009-07-29
%%
Type: language
Subtag: guv
Description: Gey
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: duz
%%
Type: language
Subtag: guw
Description: Gun
Added: 2009-07-29
%%
Type: language
Subtag: gux
Description: Gourmanchéma
Added: 2009-07-29
%%
Type: language
Subtag: guz
Description: Gusii
Description: Ekegusii
Added: 2009-07-29
%%
Type: language
Subtag: gva
Description: Guana (Paraguay)
Added: 2009-07-29
%%
Type: language
Subtag: gvc
Description: Guanano
Added: 2009-07-29
%%
Type: language
Subtag: gve
Description: Duwet
Added: 2009-07-29
%%
Type: language
Subtag: gvf
Description: Golin
Added: 2009-07-29
%%
Type: language
Subtag: gvj
Description: Guajá
Added: 2009-07-29
%%
Type: language
Subtag: gvl
Description: Gulay
Added: 2009-07-29
%%
Type: language
Subtag: gvm
Description: Gurmana
Added: 2009-07-29
%%
Type: language
Subtag: gvn
Description: Kuku-Yalanji
Added: 2009-07-29
%%
Type: language
Subtag: gvo
Description: Gavião Do Jiparaná
Added: 2009-07-29
%%
Type: language
Subtag: gvp
Description: Pará Gavião
Added: 2009-07-29
%%
Type: language
Subtag: gvr
Description: Gurung
Added: 2009-07-29
%%
Type: language
Subtag: gvs
Description: Gumawana
Added: 2009-07-29
%%
Type: language
Subtag: gvy
Description: Guyani
Added: 2009-07-29
%%
Type: language
Subtag: gwa
Description: Mbato
Added: 2009-07-29
%%
Type: language
Subtag: gwb
Description: Gwa
Added: 2009-07-29
%%
Type: language
Subtag: gwc
Description: Kalami
Added: 2009-07-29
%%
Type: language
Subtag: gwd
Description: Gawwada
Added: 2009-07-29
%%
Type: language
Subtag: gwe
Description: Gweno
Added: 2009-07-29
%%
Type: language
Subtag: gwf
Description: Gowro
Added: 2009-07-29
%%
Type: language
Subtag: gwg
Description: Moo
Added: 2009-07-29
%%
Type: language
Subtag: gwi
Description: Gwichʼin
Added: 2005-10-16
%%
Type: language
Subtag: gwj
Description: ǀGwi
Added: 2009-07-29
%%
Type: language
Subtag: gwm
Description: Awngthim
Added: 2012-08-12
%%
Type: language
Subtag: gwn
Description: Gwandara
Added: 2009-07-29
%%
Type: language
Subtag: gwr
Description: Gwere
Added: 2009-07-29
%%
Type: language
Subtag: gwt
Description: Gawar-Bati
Added: 2009-07-29
%%
Type: language
Subtag: gwu
Description: Guwamu
Added: 2009-07-29
%%
Type: language
Subtag: gww
Description: Kwini
Added: 2009-07-29
%%
Type: language
Subtag: gwx
Description: Gua
Added: 2009-07-29
%%
Type: language
Subtag: gxx
Description: Wè Southern
Added: 2009-07-29
%%
Type: language
Subtag: gya
Description: Northwest Gbaya
Added: 2009-07-29
Macrolanguage: gba
%%
Type: language
Subtag: gyb
Description: Garus
Added: 2009-07-29
%%
Type: language
Subtag: gyd
Description: Kayardild
Added: 2009-07-29
%%
Type: language
Subtag: gye
Description: Gyem
Added: 2009-07-29
%%
Type: language
Subtag: gyf
Description: Gungabula
Added: 2009-07-29
%%
Type: language
Subtag: gyg
Description: Gbayi
Added: 2009-07-29
%%
Type: language
Subtag: gyi
Description: Gyele
Added: 2009-07-29
%%
Type: language
Subtag: gyl
Description: Gayil
Added: 2009-07-29
%%
Type: language
Subtag: gym
Description: Ngäbere
Added: 2009-07-29
%%
Type: language
Subtag: gyn
Description: Guyanese Creole English
Added: 2009-07-29
%%
Type: language
Subtag: gyo
Description: Gyalsumdo
Added: 2018-03-08
%%
Type: language
Subtag: gyr
Description: Guarayu
Added: 2009-07-29
%%
Type: language
Subtag: gyy
Description: Gunya
Added: 2009-07-29
%%
Type: language
Subtag: gza
Description: Ganza
Added: 2009-07-29
%%
Type: language
Subtag: gzi
Description: Gazi
Added: 2009-07-29
%%
Type: language
Subtag: gzn
Description: Gane
Added: 2009-07-29
%%
Type: language
Subtag: haa
Description: Han
Added: 2009-07-29
%%
Type: language
Subtag: hab
Description: Hanoi Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: hac
Description: Gurani
Added: 2009-07-29
%%
Type: language
Subtag: had
Description: Hatam
Added: 2009-07-29
%%
Type: language
Subtag: hae
Description: Eastern Oromo
Added: 2009-07-29
Macrolanguage: om
%%
Type: language
Subtag: haf
Description: Haiphong Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: hag
Description: Hanga
Added: 2009-07-29
%%
Type: language
Subtag: hah
Description: Hahon
Added: 2009-07-29
%%
Type: language
Subtag: hai
Description: Haida
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: haj
Description: Hajong
Added: 2009-07-29
%%
Type: language
Subtag: hak
Description: Hakka Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: hal
Description: Halang
Added: 2009-07-29
%%
Type: language
Subtag: ham
Description: Hewa
Added: 2009-07-29
%%
Type: language
Subtag: han
Description: Hangaza
Added: 2009-07-29
%%
Type: language
Subtag: hao
Description: Hakö
Added: 2009-07-29
%%
Type: language
Subtag: hap
Description: Hupla
Added: 2009-07-29
%%
Type: language
Subtag: haq
Description: Ha
Added: 2009-07-29
%%
Type: language
Subtag: har
Description: Harari
Added: 2009-07-29
%%
Type: language
Subtag: has
Description: Haisla
Added: 2009-07-29
%%
Type: language
Subtag: hav
Description: Havu
Added: 2009-07-29
%%
Type: language
Subtag: haw
Description: Hawaiian
Added: 2005-10-16
%%
Type: language
Subtag: hax
Description: Southern Haida
Added: 2009-07-29
Macrolanguage: hai
%%
Type: language
Subtag: hay
Description: Haya
Added: 2009-07-29
%%
Type: language
Subtag: haz
Description: Hazaragi
Added: 2009-07-29
%%
Type: language
Subtag: hba
Description: Hamba
Added: 2009-07-29
%%
Type: language
Subtag: hbb
Description: Huba
Added: 2009-07-29
%%
Type: language
Subtag: hbn
Description: Heiban
Added: 2009-07-29
%%
Type: language
Subtag: hbo
Description: Ancient Hebrew
Added: 2009-07-29
%%
Type: language
Subtag: hbu
Description: Habu
Added: 2009-07-29
%%
Type: language
Subtag: hca
Description: Andaman Creole Hindi
Added: 2009-07-29
%%
Type: language
Subtag: hch
Description: Huichol
Added: 2009-07-29
%%
Type: language
Subtag: hdn
Description: Northern Haida
Added: 2009-07-29
Macrolanguage: hai
%%
Type: language
Subtag: hds
Description: Honduras Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: hdy
Description: Hadiyya
Added: 2009-07-29
%%
Type: language
Subtag: hea
Description: Northern Qiandong Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hed
Description: Herdé
Added: 2009-07-29
%%
Type: language
Subtag: heg
Description: Helong
Added: 2009-07-29
%%
Type: language
Subtag: heh
Description: Hehe
Added: 2009-07-29
%%
Type: language
Subtag: hei
Description: Heiltsuk
Added: 2009-07-29
%%
Type: language
Subtag: hem
Description: Hemba
Added: 2009-07-29
%%
Type: language
Subtag: hgm
Description: Haiǁom
Added: 2009-07-29
%%
Type: language
Subtag: hgw
Description: Haigwai
Added: 2009-07-29
%%
Type: language
Subtag: hhi
Description: Hoia Hoia
Added: 2009-07-29
%%
Type: language
Subtag: hhr
Description: Kerak
Added: 2009-07-29
%%
Type: language
Subtag: hhy
Description: Hoyahoya
Added: 2009-07-29
%%
Type: language
Subtag: hia
Description: Lamang
Added: 2009-07-29
%%
Type: language
Subtag: hib
Description: Hibito
Added: 2009-07-29
%%
Type: language
Subtag: hid
Description: Hidatsa
Added: 2009-07-29
%%
Type: language
Subtag: hif
Description: Fiji Hindi
Added: 2009-07-29
%%
Type: language
Subtag: hig
Description: Kamwe
Added: 2009-07-29
%%
Type: language
Subtag: hih
Description: Pamosu
Added: 2009-07-29
%%
Type: language
Subtag: hii
Description: Hinduri
Added: 2009-07-29
%%
Type: language
Subtag: hij
Description: Hijuk
Added: 2009-07-29
%%
Type: language
Subtag: hik
Description: Seit-Kaitetu
Added: 2009-07-29
%%
Type: language
Subtag: hil
Description: Hiligaynon
Added: 2005-10-16
%%
Type: language
Subtag: him
Description: Himachali languages
Description: Western Pahari languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: hio
Description: Tsoa
Added: 2009-07-29
%%
Type: language
Subtag: hir
Description: Himarimã
Added: 2009-07-29
%%
Type: language
Subtag: hit
Description: Hittite
Added: 2005-10-16
%%
Type: language
Subtag: hiw
Description: Hiw
Added: 2009-07-29
%%
Type: language
Subtag: hix
Description: Hixkaryána
Added: 2009-07-29
%%
Type: language
Subtag: hji
Description: Haji
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: hka
Description: Kahe
Added: 2009-07-29
%%
Type: language
Subtag: hke
Description: Hunde
Added: 2009-07-29
%%
Type: language
Subtag: hkk
Description: Hunjara-Kaina Ke
Added: 2009-07-29
%%
Type: language
Subtag: hkn
Description: Mel-Khaonh
Added: 2018-03-08
%%
Type: language
Subtag: hks
Description: Hong Kong Sign Language
Description: Heung Kong Sau Yue
Added: 2009-07-29
%%
Type: language
Subtag: hla
Description: Halia
Added: 2009-07-29
%%
Type: language
Subtag: hlb
Description: Halbi
Added: 2009-07-29
%%
Type: language
Subtag: hld
Description: Halang Doan
Added: 2009-07-29
%%
Type: language
Subtag: hle
Description: Hlersu
Added: 2009-07-29
%%
Type: language
Subtag: hlt
Description: Matu Chin
Added: 2009-07-29
%%
Type: language
Subtag: hlu
Description: Hieroglyphic Luwian
Added: 2009-07-29
%%
Type: language
Subtag: hma
Description: Southern Mashan Hmong
Description: Southern Mashan Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmb
Description: Humburi Senni Songhay
Added: 2009-07-29
%%
Type: language
Subtag: hmc
Description: Central Huishui Hmong
Description: Central Huishui Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmd
Description: Large Flowery Miao
Description: A-hmaos
Description: Da-Hua Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hme
Description: Eastern Huishui Hmong
Description: Eastern Huishui Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmf
Description: Hmong Don
Added: 2009-07-29
%%
Type: language
Subtag: hmg
Description: Southwestern Guiyang Hmong
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmh
Description: Southwestern Huishui Hmong
Description: Southwestern Huishui Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmi
Description: Northern Huishui Hmong
Description: Northern Huishui Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmj
Description: Ge
Description: Gejia
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmk
Description: Maek
Added: 2009-07-29
%%
Type: language
Subtag: hml
Description: Luopohe Hmong
Description: Luopohe Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmm
Description: Central Mashan Hmong
Description: Central Mashan Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmn
Description: Hmong
Description: Mong
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: hmp
Description: Northern Mashan Hmong
Description: Northern Mashan Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmq
Description: Eastern Qiandong Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmr
Description: Hmar
Added: 2009-07-29
%%
Type: language
Subtag: hms
Description: Southern Qiandong Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmt
Description: Hamtai
Added: 2009-07-29
%%
Type: language
Subtag: hmu
Description: Hamap
Added: 2009-07-29
%%
Type: language
Subtag: hmv
Description: Hmong Dô
Added: 2009-07-29
%%
Type: language
Subtag: hmw
Description: Western Mashan Hmong
Description: Western Mashan Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmx
Description: Hmong-Mien languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: hmy
Description: Southern Guiyang Hmong
Description: Southern Guiyang Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hmz
Description: Hmong Shua
Description: Sinicized Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hna
Description: Mina (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: hnd
Description: Southern Hindko
Added: 2009-07-29
Macrolanguage: lah
%%
Type: language
Subtag: hne
Description: Chhattisgarhi
Added: 2009-07-29
%%
Type: language
Subtag: hnh
Description: ǁAni
Added: 2009-07-29
%%
Type: language
Subtag: hni
Description: Hani
Added: 2009-07-29
%%
Type: language
Subtag: hnj
Description: Hmong Njua
Description: Mong Leng
Description: Mong Njua
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hnn
Description: Hanunoo
Added: 2009-07-29
%%
Type: language
Subtag: hno
Description: Northern Hindko
Added: 2009-07-29
Macrolanguage: lah
%%
Type: language
Subtag: hns
Description: Caribbean Hindustani
Added: 2009-07-29
%%
Type: language
Subtag: hnu
Description: Hung
Added: 2009-07-29
%%
Type: language
Subtag: hoa
Description: Hoava
Added: 2009-07-29
%%
Type: language
Subtag: hob
Description: Mari (Madang Province)
Added: 2009-07-29
%%
Type: language
Subtag: hoc
Description: Ho
Added: 2009-07-29
%%
Type: language
Subtag: hod
Description: Holma
Added: 2009-07-29
%%
Type: language
Subtag: hoe
Description: Horom
Added: 2009-07-29
%%
Type: language
Subtag: hoh
Description: Hobyót
Added: 2009-07-29
%%
Type: language
Subtag: hoi
Description: Holikachuk
Added: 2009-07-29
%%
Type: language
Subtag: hoj
Description: Hadothi
Description: Haroti
Added: 2009-07-29
Macrolanguage: raj
%%
Type: language
Subtag: hok
Description: Hokan languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: hol
Description: Holu
Added: 2009-07-29
%%
Type: language
Subtag: hom
Description: Homa
Added: 2009-07-29
%%
Type: language
Subtag: hoo
Description: Holoholo
Added: 2009-07-29
%%
Type: language
Subtag: hop
Description: Hopi
Added: 2009-07-29
%%
Type: language
Subtag: hor
Description: Horo
Added: 2009-07-29
%%
Type: language
Subtag: hos
Description: Ho Chi Minh City Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: hot
Description: Hote
Description: Malê
Added: 2009-07-29
%%
Type: language
Subtag: hov
Description: Hovongan
Added: 2009-07-29
%%
Type: language
Subtag: how
Description: Honi
Added: 2009-07-29
%%
Type: language
Subtag: hoy
Description: Holiya
Added: 2009-07-29
%%
Type: language
Subtag: hoz
Description: Hozo
Added: 2009-07-29
%%
Type: language
Subtag: hpo
Description: Hpon
Added: 2009-07-29
%%
Type: language
Subtag: hps
Description: Hawai'i Sign Language (HSL)
Description: Hawai'i Pidgin Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: hra
Description: Hrangkhol
Added: 2009-07-29
%%
Type: language
Subtag: hrc
Description: Niwer Mil
Added: 2013-09-10
%%
Type: language
Subtag: hre
Description: Hre
Added: 2009-07-29
%%
Type: language
Subtag: hrk
Description: Haruku
Added: 2009-07-29
%%
Type: language
Subtag: hrm
Description: Horned Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: hro
Description: Haroi
Added: 2009-07-29
%%
Type: language
Subtag: hrp
Description: Nhirrpi
Added: 2013-09-10
%%
Type: language
Subtag: hrr
Description: Horuru
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: jal
%%
Type: language
Subtag: hrt
Description: Hértevin
Added: 2009-07-29
%%
Type: language
Subtag: hru
Description: Hruso
Added: 2009-07-29
%%
Type: language
Subtag: hrw
Description: Warwar Feni
Added: 2013-09-10
%%
Type: language
Subtag: hrx
Description: Hunsrik
Added: 2009-07-29
%%
Type: language
Subtag: hrz
Description: Harzani
Added: 2009-07-29
%%
Type: language
Subtag: hsb
Description: Upper Sorbian
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: hsh
Description: Hungarian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: hsl
Description: Hausa Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: hsn
Description: Xiang Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: hss
Description: Harsusi
Added: 2009-07-29
%%
Type: language
Subtag: hti
Description: Hoti
Added: 2009-07-29
%%
Type: language
Subtag: hto
Description: Minica Huitoto
Added: 2009-07-29
%%
Type: language
Subtag: hts
Description: Hadza
Added: 2009-07-29
%%
Type: language
Subtag: htu
Description: Hitu
Added: 2009-07-29
%%
Type: language
Subtag: htx
Description: Middle Hittite
Added: 2009-07-29
%%
Type: language
Subtag: hub
Description: Huambisa
Added: 2009-07-29
%%
Type: language
Subtag: huc
Description: ǂHua
Added: 2009-07-29
%%
Type: language
Subtag: hud
Description: Huaulu
Added: 2009-07-29
%%
Type: language
Subtag: hue
Description: San Francisco Del Mar Huave
Added: 2009-07-29
%%
Type: language
Subtag: huf
Description: Humene
Added: 2009-07-29
%%
Type: language
Subtag: hug
Description: Huachipaeri
Added: 2009-07-29
%%
Type: language
Subtag: huh
Description: Huilliche
Added: 2009-07-29
%%
Type: language
Subtag: hui
Description: Huli
Added: 2009-07-29
%%
Type: language
Subtag: huj
Description: Northern Guiyang Hmong
Description: Northern Guiyang Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: huk
Description: Hulung
Added: 2009-07-29
%%
Type: language
Subtag: hul
Description: Hula
Added: 2009-07-29
%%
Type: language
Subtag: hum
Description: Hungana
Added: 2009-07-29
%%
Type: language
Subtag: huo
Description: Hu
Added: 2009-07-29
%%
Type: language
Subtag: hup
Description: Hupa
Added: 2005-10-16
%%
Type: language
Subtag: huq
Description: Tsat
Added: 2009-07-29
%%
Type: language
Subtag: hur
Description: Halkomelem
Added: 2009-07-29
%%
Type: language
Subtag: hus
Description: Huastec
Added: 2009-07-29
%%
Type: language
Subtag: hut
Description: Humla
Added: 2009-07-29
%%
Type: language
Subtag: huu
Description: Murui Huitoto
Added: 2009-07-29
%%
Type: language
Subtag: huv
Description: San Mateo Del Mar Huave
Added: 2009-07-29
%%
Type: language
Subtag: huw
Description: Hukumina
Added: 2009-07-29
%%
Type: language
Subtag: hux
Description: Nüpode Huitoto
Added: 2009-07-29
%%
Type: language
Subtag: huy
Description: Hulaulá
Added: 2009-07-29
%%
Type: language
Subtag: huz
Description: Hunzib
Added: 2009-07-29
%%
Type: language
Subtag: hvc
Description: Haitian Vodoun Culture Language
Added: 2009-07-29
%%
Type: language
Subtag: hve
Description: San Dionisio Del Mar Huave
Added: 2009-07-29
%%
Type: language
Subtag: hvk
Description: Haveke
Added: 2009-07-29
%%
Type: language
Subtag: hvn
Description: Sabu
Added: 2009-07-29
%%
Type: language
Subtag: hvv
Description: Santa María Del Mar Huave
Added: 2009-07-29
%%
Type: language
Subtag: hwa
Description: Wané
Added: 2009-07-29
%%
Type: language
Subtag: hwc
Description: Hawai'i Creole English
Description: Hawai'i Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: hwo
Description: Hwana
Added: 2009-07-29
%%
Type: language
Subtag: hya
Description: Hya
Added: 2009-07-29
%%
Type: language
Subtag: hyw
Description: Western Armenian
Added: 2018-03-08
Comments: see also hy
%%
Type: language
Subtag: hyx
Description: Armenian (family)
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: iai
Description: Iaai
Added: 2009-07-29
%%
Type: language
Subtag: ian
Description: Iatmul
Added: 2009-07-29
%%
Type: language
Subtag: iap
Description: Iapama
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: iar
Description: Purari
Added: 2009-07-29
%%
Type: language
Subtag: iba
Description: Iban
Added: 2005-10-16
%%
Type: language
Subtag: ibb
Description: Ibibio
Added: 2009-07-29
%%
Type: language
Subtag: ibd
Description: Iwaidja
Added: 2009-07-29
%%
Type: language
Subtag: ibe
Description: Akpes
Added: 2009-07-29
%%
Type: language
Subtag: ibg
Description: Ibanag
Added: 2009-07-29
%%
Type: language
Subtag: ibh
Description: Bih
Added: 2017-02-23
%%
Type: language
Subtag: ibi
Description: Ibilo
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: opa
%%
Type: language
Subtag: ibl
Description: Ibaloi
Added: 2009-07-29
%%
Type: language
Subtag: ibm
Description: Agoi
Added: 2009-07-29
%%
Type: language
Subtag: ibn
Description: Ibino
Added: 2009-07-29
%%
Type: language
Subtag: ibr
Description: Ibuoro
Added: 2009-07-29
%%
Type: language
Subtag: ibu
Description: Ibu
Added: 2009-07-29
%%
Type: language
Subtag: iby
Description: Ibani
Added: 2009-07-29
%%
Type: language
Subtag: ica
Description: Ede Ica
Added: 2009-07-29
%%
Type: language
Subtag: ich
Description: Etkywan
Added: 2009-07-29
%%
Type: language
Subtag: icl
Description: Icelandic Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: icr
Description: Islander Creole English
Added: 2009-07-29
%%
Type: language
Subtag: ida
Description: Idakho-Isukha-Tiriki
Description: Luidakho-Luisukha-Lutirichi
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: idb
Description: Indo-Portuguese
Added: 2009-07-29
%%
Type: language
Subtag: idc
Description: Idon
Description: Ajiya
Added: 2009-07-29
%%
Type: language
Subtag: idd
Description: Ede Idaca
Added: 2009-07-29
%%
Type: language
Subtag: ide
Description: Idere
Added: 2009-07-29
%%
Type: language
Subtag: idi
Description: Idi
Added: 2009-07-29
%%
Type: language
Subtag: idr
Description: Indri
Added: 2009-07-29
%%
Type: language
Subtag: ids
Description: Idesa
Added: 2009-07-29
%%
Type: language
Subtag: idt
Description: Idaté
Added: 2009-07-29
%%
Type: language
Subtag: idu
Description: Idoma
Added: 2009-07-29
%%
Type: language
Subtag: ifa
Description: Amganad Ifugao
Added: 2009-07-29
%%
Type: language
Subtag: ifb
Description: Batad Ifugao
Description: Ayangan Ifugao
Added: 2009-07-29
%%
Type: language
Subtag: ife
Description: Ifè
Added: 2009-07-29
%%
Type: language
Subtag: iff
Description: Ifo
Added: 2009-07-29
%%
Type: language
Subtag: ifk
Description: Tuwali Ifugao
Added: 2009-07-29
%%
Type: language
Subtag: ifm
Description: Teke-Fuumu
Added: 2009-07-29
%%
Type: language
Subtag: ifu
Description: Mayoyao Ifugao
Added: 2009-07-29
%%
Type: language
Subtag: ify
Description: Keley-I Kallahan
Added: 2009-07-29
%%
Type: language
Subtag: igb
Description: Ebira
Added: 2009-07-29
%%
Type: language
Subtag: ige
Description: Igede
Added: 2009-07-29
%%
Type: language
Subtag: igg
Description: Igana
Added: 2009-07-29
%%
Type: language
Subtag: igl
Description: Igala
Added: 2009-07-29
%%
Type: language
Subtag: igm
Description: Kanggape
Added: 2009-07-29
%%
Type: language
Subtag: ign
Description: Ignaciano
Added: 2009-07-29
%%
Type: language
Subtag: igo
Description: Isebe
Added: 2009-07-29
%%
Type: language
Subtag: igs
Description: Interglossa
Added: 2009-07-29
%%
Type: language
Subtag: igw
Description: Igwe
Added: 2009-07-29
%%
Type: language
Subtag: ihb
Description: Iha Based Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: ihi
Description: Ihievbe
Added: 2009-07-29
%%
Type: language
Subtag: ihp
Description: Iha
Added: 2009-07-29
%%
Type: language
Subtag: ihw
Description: Bidhawal
Added: 2012-08-12
%%
Type: language
Subtag: iin
Description: Thiin
Added: 2013-09-10
%%
Type: language
Subtag: iir
Description: Indo-Iranian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: ijc
Description: Izon
Added: 2009-07-29
%%
Type: language
Subtag: ije
Description: Biseni
Added: 2009-07-29
%%
Type: language
Subtag: ijj
Description: Ede Ije
Added: 2009-07-29
%%
Type: language
Subtag: ijn
Description: Kalabari
Added: 2009-07-29
%%
Type: language
Subtag: ijo
Description: Ijo languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: ijs
Description: Southeast Ijo
Added: 2009-07-29
%%
Type: language
Subtag: ike
Description: Eastern Canadian Inuktitut
Added: 2009-07-29
Macrolanguage: iu
%%
Type: language
Subtag: iki
Description: Iko
Added: 2009-07-29
%%
Type: language
Subtag: ikk
Description: Ika
Added: 2009-07-29
%%
Type: language
Subtag: ikl
Description: Ikulu
Added: 2009-07-29
%%
Type: language
Subtag: iko
Description: Olulumo-Ikom
Added: 2009-07-29
%%
Type: language
Subtag: ikp
Description: Ikpeshi
Added: 2009-07-29
%%
Type: language
Subtag: ikr
Description: Ikaranggal
Added: 2013-09-10
%%
Type: language
Subtag: iks
Description: Inuit Sign Language
Added: 2015-02-12
%%
Type: language
Subtag: ikt
Description: Inuinnaqtun
Description: Western Canadian Inuktitut
Added: 2009-07-29
Macrolanguage: iu
%%
Type: language
Subtag: ikv
Description: Iku-Gora-Ankwa
Added: 2009-07-29
%%
Type: language
Subtag: ikw
Description: Ikwere
Added: 2009-07-29
%%
Type: language
Subtag: ikx
Description: Ik
Added: 2009-07-29
%%
Type: language
Subtag: ikz
Description: Ikizu
Added: 2009-07-29
%%
Type: language
Subtag: ila
Description: Ile Ape
Added: 2009-07-29
%%
Type: language
Subtag: ilb
Description: Ila
Added: 2009-07-29
%%
Type: language
Subtag: ilg
Description: Garig-Ilgar
Added: 2009-07-29
%%
Type: language
Subtag: ili
Description: Ili Turki
Added: 2009-07-29
%%
Type: language
Subtag: ilk
Description: Ilongot
Added: 2009-07-29
%%
Type: language
Subtag: ill
Description: Iranun
Added: 2009-07-29
Deprecated: 2016-05-30
Comments: see ilm, ilp
%%
Type: language
Subtag: ilm
Description: Iranun (Malaysia)
Added: 2016-05-30
%%
Type: language
Subtag: ilo
Description: Iloko
Added: 2005-10-16
%%
Type: language
Subtag: ilp
Description: Iranun (Philippines)
Added: 2016-05-30
%%
Type: language
Subtag: ils
Description: International Sign
Added: 2009-07-29
%%
Type: language
Subtag: ilu
Description: Ili'uun
Added: 2009-07-29
%%
Type: language
Subtag: ilv
Description: Ilue
Added: 2009-07-29
%%
Type: language
Subtag: ilw
Description: Talur
Added: 2009-07-29
Deprecated: 2013-09-10
Preferred-Value: gal
%%
Type: language
Subtag: ima
Description: Mala Malasar
Added: 2009-07-29
%%
Type: language
Subtag: ime
Description: Imeraguen
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: imi
Description: Anamgura
Added: 2009-07-29
%%
Type: language
Subtag: iml
Description: Miluk
Added: 2009-07-29
%%
Type: language
Subtag: imn
Description: Imonda
Added: 2009-07-29
%%
Type: language
Subtag: imo
Description: Imbongu
Added: 2009-07-29
%%
Type: language
Subtag: imr
Description: Imroing
Added: 2009-07-29
%%
Type: language
Subtag: ims
Description: Marsian
Added: 2009-07-29
%%
Type: language
Subtag: imy
Description: Milyan
Added: 2009-07-29
%%
Type: language
Subtag: inb
Description: Inga
Added: 2009-07-29
%%
Type: language
Subtag: inc
Description: Indic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: ine
Description: Indo-European languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: ing
Description: Degexit'an
Added: 2009-07-29
%%
Type: language
Subtag: inh
Description: Ingush
Added: 2005-10-16
%%
Type: language
Subtag: inj
Description: Jungle Inga
Added: 2009-07-29
%%
Type: language
Subtag: inl
Description: Indonesian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: inm
Description: Minaean
Added: 2009-07-29
%%
Type: language
Subtag: inn
Description: Isinai
Added: 2009-07-29
%%
Type: language
Subtag: ino
Description: Inoke-Yate
Added: 2009-07-29
%%
Type: language
Subtag: inp
Description: Iñapari
Added: 2009-07-29
%%
Type: language
Subtag: ins
Description: Indian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: int
Description: Intha
Added: 2009-07-29
%%
Type: language
Subtag: inz
Description: Ineseño
Added: 2009-07-29
%%
Type: language
Subtag: ior
Description: Inor
Added: 2009-07-29
%%
Type: language
Subtag: iou
Description: Tuma-Irumu
Added: 2009-07-29
%%
Type: language
Subtag: iow
Description: Iowa-Oto
Added: 2009-07-29
%%
Type: language
Subtag: ipi
Description: Ipili
Added: 2009-07-29
%%
Type: language
Subtag: ipo
Description: Ipiko
Added: 2009-07-29
%%
Type: language
Subtag: iqu
Description: Iquito
Added: 2009-07-29
%%
Type: language
Subtag: iqw
Description: Ikwo
Added: 2013-09-10
%%
Type: language
Subtag: ira
Description: Iranian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: ire
Description: Iresim
Added: 2009-07-29
%%
Type: language
Subtag: irh
Description: Irarutu
Added: 2009-07-29
%%
Type: language
Subtag: iri
Description: Rigwe
Description: Irigwe
Added: 2009-07-29
%%
Type: language
Subtag: irk
Description: Iraqw
Added: 2009-07-29
%%
Type: language
Subtag: irn
Description: Irántxe
Added: 2009-07-29
%%
Type: language
Subtag: iro
Description: Iroquoian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: irr
Description: Ir
Added: 2009-07-29
%%
Type: language
Subtag: iru
Description: Irula
Added: 2009-07-29
%%
Type: language
Subtag: irx
Description: Kamberau
Added: 2009-07-29
%%
Type: language
Subtag: iry
Description: Iraya
Added: 2009-07-29
%%
Type: language
Subtag: isa
Description: Isabi
Added: 2009-07-29
%%
Type: language
Subtag: isc
Description: Isconahua
Added: 2009-07-29
%%
Type: language
Subtag: isd
Description: Isnag
Added: 2009-07-29
%%
Type: language
Subtag: ise
Description: Italian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: isg
Description: Irish Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: ish
Description: Esan
Added: 2009-07-29
%%
Type: language
Subtag: isi
Description: Nkem-Nkum
Added: 2009-07-29
%%
Type: language
Subtag: isk
Description: Ishkashimi
Added: 2010-03-11
%%
Type: language
Subtag: ism
Description: Masimasi
Added: 2009-07-29
%%
Type: language
Subtag: isn
Description: Isanzu
Added: 2009-07-29
%%
Type: language
Subtag: iso
Description: Isoko
Added: 2009-07-29
%%
Type: language
Subtag: isr
Description: Israeli Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: ist
Description: Istriot
Added: 2009-07-29
%%
Type: language
Subtag: isu
Description: Isu (Menchum Division)
Added: 2009-07-29
%%
Type: language
Subtag: itb
Description: Binongan Itneg
Added: 2009-07-29
%%
Type: language
Subtag: itc
Description: Italic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: itd
Description: Southern Tidung
Added: 2016-05-30
%%
Type: language
Subtag: ite
Description: Itene
Added: 2009-07-29
%%
Type: language
Subtag: iti
Description: Inlaod Itneg
Added: 2009-07-29
%%
Type: language
Subtag: itk
Description: Judeo-Italian
Added: 2009-07-29
%%
Type: language
Subtag: itl
Description: Itelmen
Added: 2009-07-29
%%
Type: language
Subtag: itm
Description: Itu Mbon Uzo
Added: 2009-07-29
%%
Type: language
Subtag: ito
Description: Itonama
Added: 2009-07-29
%%
Type: language
Subtag: itr
Description: Iteri
Added: 2009-07-29
%%
Type: language
Subtag: its
Description: Isekiri
Added: 2009-07-29
%%
Type: language
Subtag: itt
Description: Maeng Itneg
Added: 2009-07-29
%%
Type: language
Subtag: itv
Description: Itawit
Added: 2009-07-29
%%
Type: language
Subtag: itw
Description: Ito
Added: 2009-07-29
%%
Type: language
Subtag: itx
Description: Itik
Added: 2009-07-29
%%
Type: language
Subtag: ity
Description: Moyadan Itneg
Added: 2009-07-29
%%
Type: language
Subtag: itz
Description: Itzá
Added: 2009-07-29
%%
Type: language
Subtag: ium
Description: Iu Mien
Added: 2009-07-29
%%
Type: language
Subtag: ivb
Description: Ibatan
Added: 2009-07-29
%%
Type: language
Subtag: ivv
Description: Ivatan
Added: 2009-07-29
%%
Type: language
Subtag: iwk
Description: I-Wak
Added: 2009-07-29
%%
Type: language
Subtag: iwm
Description: Iwam
Added: 2009-07-29
%%
Type: language
Subtag: iwo
Description: Iwur
Added: 2009-07-29
%%
Type: language
Subtag: iws
Description: Sepik Iwam
Added: 2009-07-29
%%
Type: language
Subtag: ixc
Description: Ixcatec
Added: 2009-07-29
%%
Type: language
Subtag: ixl
Description: Ixil
Added: 2009-07-29
%%
Type: language
Subtag: iya
Description: Iyayu
Added: 2009-07-29
%%
Type: language
Subtag: iyo
Description: Mesaka
Added: 2009-07-29
%%
Type: language
Subtag: iyx
Description: Yaka (Congo)
Added: 2009-07-29
%%
Type: language
Subtag: izh
Description: Ingrian
Added: 2009-07-29
%%
Type: language
Subtag: izi
Description: Izi-Ezaa-Ikwo-Mgbo
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see eza, gmz, iqw, izz
%%
Type: language
Subtag: izr
Description: Izere
Added: 2009-07-29
%%
Type: language
Subtag: izz
Description: Izii
Added: 2013-09-10
%%
Type: language
Subtag: jaa
Description: Jamamadí
Added: 2009-07-29
%%
Type: language
Subtag: jab
Description: Hyam
Added: 2009-07-29
%%
Type: language
Subtag: jac
Description: Popti'
Description: Jakalteko
Added: 2009-07-29
%%
Type: language
Subtag: jad
Description: Jahanka
Added: 2009-07-29
%%
Type: language
Subtag: jae
Description: Yabem
Added: 2009-07-29
%%
Type: language
Subtag: jaf
Description: Jara
Added: 2009-07-29
%%
Type: language
Subtag: jah
Description: Jah Hut
Added: 2009-07-29
%%
Type: language
Subtag: jaj
Description: Zazao
Added: 2009-07-29
%%
Type: language
Subtag: jak
Description: Jakun
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: jal
Description: Yalahatan
Added: 2009-07-29
%%
Type: language
Subtag: jam
Description: Jamaican Creole English
Added: 2009-07-29
%%
Type: language
Subtag: jan
Description: Jandai
Added: 2012-08-12
%%
Type: language
Subtag: jao
Description: Yanyuwa
Added: 2009-07-29
%%
Type: language
Subtag: jaq
Description: Yaqay
Added: 2009-07-29
%%
Type: language
Subtag: jar
Description: Jarawa (Nigeria)
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see jgk, jjr
%%
Type: language
Subtag: jas
Description: New Caledonian Javanese
Added: 2009-07-29
%%
Type: language
Subtag: jat
Description: Jakati
Added: 2009-07-29
Macrolanguage: lah
%%
Type: language
Subtag: jau
Description: Yaur
Added: 2009-07-29
%%
Type: language
Subtag: jax
Description: Jambi Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: jay
Description: Yan-nhangu
Description: Nhangu
Added: 2009-07-29
%%
Type: language
Subtag: jaz
Description: Jawe
Added: 2009-07-29
%%
Type: language
Subtag: jbe
Description: Judeo-Berber
Added: 2009-07-29
%%
Type: language
Subtag: jbi
Description: Badjiri
Added: 2013-09-10
%%
Type: language
Subtag: jbj
Description: Arandai
Added: 2009-07-29
%%
Type: language
Subtag: jbk
Description: Barikewa
Added: 2012-08-12
%%
Type: language
Subtag: jbn
Description: Nafusi
Added: 2009-07-29
%%
Type: language
Subtag: jbo
Description: Lojban
Added: 2005-10-16
%%
Type: language
Subtag: jbr
Description: Jofotek-Bromnya
Added: 2009-07-29
%%
Type: language
Subtag: jbt
Description: Jabutí
Added: 2009-07-29
%%
Type: language
Subtag: jbu
Description: Jukun Takum
Added: 2009-07-29
%%
Type: language
Subtag: jbw
Description: Yawijibaya
Added: 2012-08-12
%%
Type: language
Subtag: jcs
Description: Jamaican Country Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: jct
Description: Krymchak
Added: 2009-07-29
%%
Type: language
Subtag: jda
Description: Jad
Added: 2009-07-29
%%
Type: language
Subtag: jdg
Description: Jadgali
Added: 2009-07-29
%%
Type: language
Subtag: jdt
Description: Judeo-Tat
Added: 2009-07-29
%%
Type: language
Subtag: jeb
Description: Jebero
Added: 2009-07-29
%%
Type: language
Subtag: jee
Description: Jerung
Added: 2009-07-29
%%
Type: language
Subtag: jeg
Description: Jeng
Added: 2009-07-29
Deprecated: 2017-02-23
Preferred-Value: oyb
%%
Type: language
Subtag: jeh
Description: Jeh
Added: 2009-07-29
%%
Type: language
Subtag: jei
Description: Yei
Added: 2009-07-29
%%
Type: language
Subtag: jek
Description: Jeri Kuo
Added: 2009-07-29
%%
Type: language
Subtag: jel
Description: Yelmek
Added: 2009-07-29
%%
Type: language
Subtag: jen
Description: Dza
Added: 2009-07-29
%%
Type: language
Subtag: jer
Description: Jere
Added: 2009-07-29
%%
Type: language
Subtag: jet
Description: Manem
Added: 2009-07-29
%%
Type: language
Subtag: jeu
Description: Jonkor Bourmataguil
Added: 2009-07-29
%%
Type: language
Subtag: jgb
Description: Ngbee
Added: 2009-07-29
%%
Type: language
Subtag: jge
Description: Judeo-Georgian
Added: 2009-07-29
%%
Type: language
Subtag: jgk
Description: Gwak
Added: 2012-08-12
%%
Type: language
Subtag: jgo
Description: Ngomba
Added: 2009-07-29
%%
Type: language
Subtag: jhi
Description: Jehai
Added: 2009-07-29
%%
Type: language
Subtag: jhs
Description: Jhankot Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: jia
Description: Jina
Added: 2009-07-29
%%
Type: language
Subtag: jib
Description: Jibu
Added: 2009-07-29
%%
Type: language
Subtag: jic
Description: Tol
Added: 2009-07-29
%%
Type: language
Subtag: jid
Description: Bu
Added: 2009-07-29
%%
Type: language
Subtag: jie
Description: Jilbe
Added: 2009-07-29
%%
Type: language
Subtag: jig
Description: Jingulu
Description: Djingili
Added: 2009-07-29
%%
Type: language
Subtag: jih
Description: sTodsde
Description: Shangzhai
Added: 2009-07-29
%%
Type: language
Subtag: jii
Description: Jiiddu
Added: 2009-07-29
%%
Type: language
Subtag: jil
Description: Jilim
Added: 2009-07-29
%%
Type: language
Subtag: jim
Description: Jimi (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: jio
Description: Jiamao
Added: 2009-07-29
%%
Type: language
Subtag: jiq
Description: Guanyinqiao
Description: Lavrung
Added: 2009-07-29
%%
Type: language
Subtag: jit
Description: Jita
Added: 2009-07-29
%%
Type: language
Subtag: jiu
Description: Youle Jinuo
Added: 2009-07-29
%%
Type: language
Subtag: jiv
Description: Shuar
Added: 2009-07-29
%%
Type: language
Subtag: jiy
Description: Buyuan Jinuo
Added: 2009-07-29
%%
Type: language
Subtag: jje
Description: Jejueo
Added: 2015-02-12
%%
Type: language
Subtag: jjr
Description: Bankal
Added: 2012-08-12
%%
Type: language
Subtag: jka
Description: Kaera
Added: 2016-05-30
%%
Type: language
Subtag: jkm
Description: Mobwa Karen
Added: 2012-08-12
%%
Type: language
Subtag: jko
Description: Kubo
Added: 2009-07-29
%%
Type: language
Subtag: jkp
Description: Paku Karen
Added: 2012-08-12
%%
Type: language
Subtag: jkr
Description: Koro (India)
Added: 2012-08-12
%%
Type: language
Subtag: jku
Description: Labir
Added: 2009-07-29
%%
Type: language
Subtag: jle
Description: Ngile
Added: 2009-07-29
%%
Type: language
Subtag: jls
Description: Jamaican Sign Language
Added: 2010-03-11
%%
Type: language
Subtag: jma
Description: Dima
Added: 2009-07-29
%%
Type: language
Subtag: jmb
Description: Zumbun
Added: 2009-07-29
%%
Type: language
Subtag: jmc
Description: Machame
Added: 2009-07-29
%%
Type: language
Subtag: jmd
Description: Yamdena
Added: 2009-07-29
%%
Type: language
Subtag: jmi
Description: Jimi (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: jml
Description: Jumli
Added: 2009-07-29
%%
Type: language
Subtag: jmn
Description: Makuri Naga
Added: 2009-07-29
%%
Type: language
Subtag: jmr
Description: Kamara
Added: 2009-07-29
%%
Type: language
Subtag: jms
Description: Mashi (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: jmw
Description: Mouwase
Added: 2012-08-12
%%
Type: language
Subtag: jmx
Description: Western Juxtlahuaca Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: jna
Description: Jangshung
Added: 2009-07-29
%%
Type: language
Subtag: jnd
Description: Jandavra
Added: 2009-07-29
%%
Type: language
Subtag: jng
Description: Yangman
Added: 2009-07-29
%%
Type: language
Subtag: jni
Description: Janji
Added: 2009-07-29
%%
Type: language
Subtag: jnj
Description: Yemsa
Added: 2009-07-29
%%
Type: language
Subtag: jnl
Description: Rawat
Added: 2009-07-29
%%
Type: language
Subtag: jns
Description: Jaunsari
Added: 2009-07-29
%%
Type: language
Subtag: job
Description: Joba
Added: 2009-07-29
%%
Type: language
Subtag: jod
Description: Wojenaka
Added: 2009-07-29
%%
Type: language
Subtag: jog
Description: Jogi
Added: 2015-05-27
%%
Type: language
Subtag: jor
Description: Jorá
Added: 2009-07-29
%%
Type: language
Subtag: jos
Description: Jordanian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: jow
Description: Jowulu
Added: 2009-07-29
%%
Type: language
Subtag: jpa
Description: Jewish Palestinian Aramaic
Added: 2009-07-29
%%
Type: language
Subtag: jpr
Description: Judeo-Persian
Added: 2005-10-16
%%
Type: language
Subtag: jpx
Description: Japanese (family)
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: jqr
Description: Jaqaru
Added: 2009-07-29
%%
Type: language
Subtag: jra
Description: Jarai
Added: 2009-07-29
%%
Type: language
Subtag: jrb
Description: Judeo-Arabic
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: jrr
Description: Jiru
Added: 2009-07-29
%%
Type: language
Subtag: jrt
Description: Jorto
Added: 2009-07-29
%%
Type: language
Subtag: jru
Description: Japrería
Added: 2009-07-29
%%
Type: language
Subtag: jsl
Description: Japanese Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: jua
Description: Júma
Added: 2009-07-29
%%
Type: language
Subtag: jub
Description: Wannu
Added: 2009-07-29
%%
Type: language
Subtag: juc
Description: Jurchen
Added: 2009-07-29
%%
Type: language
Subtag: jud
Description: Worodougou
Added: 2009-07-29
%%
Type: language
Subtag: juh
Description: Hõne
Added: 2009-07-29
%%
Type: language
Subtag: jui
Description: Ngadjuri
Added: 2012-08-12
%%
Type: language
Subtag: juk
Description: Wapan
Added: 2009-07-29
%%
Type: language
Subtag: jul
Description: Jirel
Added: 2009-07-29
%%
Type: language
Subtag: jum
Description: Jumjum
Added: 2009-07-29
%%
Type: language
Subtag: jun
Description: Juang
Added: 2009-07-29
%%
Type: language
Subtag: juo
Description: Jiba
Added: 2009-07-29
%%
Type: language
Subtag: jup
Description: Hupdë
Added: 2009-07-29
%%
Type: language
Subtag: jur
Description: Jurúna
Added: 2009-07-29
%%
Type: language
Subtag: jus
Description: Jumla Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: jut
Description: Jutish
Added: 2009-07-29
%%
Type: language
Subtag: juu
Description: Ju
Added: 2009-07-29
%%
Type: language
Subtag: juw
Description: Wãpha
Added: 2009-07-29
%%
Type: language
Subtag: juy
Description: Juray
Added: 2009-07-29
%%
Type: language
Subtag: jvd
Description: Javindo
Added: 2009-07-29
%%
Type: language
Subtag: jvn
Description: Caribbean Javanese
Added: 2009-07-29
%%
Type: language
Subtag: jwi
Description: Jwira-Pepesa
Added: 2009-07-29
%%
Type: language
Subtag: jya
Description: Jiarong
Added: 2009-07-29
%%
Type: language
Subtag: jye
Description: Judeo-Yemeni Arabic
Added: 2009-07-29
Macrolanguage: jrb
%%
Type: language
Subtag: jyy
Description: Jaya
Added: 2009-07-29
%%
Type: language
Subtag: kaa
Description: Kara-Kalpak
Added: 2005-10-16
%%
Type: language
Subtag: kab
Description: Kabyle
Added: 2005-10-16
%%
Type: language
Subtag: kac
Description: Kachin
Description: Jingpho
Added: 2005-10-16
%%
Type: language
Subtag: kad
Description: Adara
Added: 2009-07-29
%%
Type: language
Subtag: kae
Description: Ketangalan
Added: 2009-07-29
%%
Type: language
Subtag: kaf
Description: Katso
Added: 2009-07-29
%%
Type: language
Subtag: kag
Description: Kajaman
Added: 2009-07-29
%%
Type: language
Subtag: kah
Description: Kara (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: kai
Description: Karekare
Added: 2009-07-29
%%
Type: language
Subtag: kaj
Description: Jju
Added: 2009-07-29
%%
Type: language
Subtag: kak
Description: Kalanguya
Description: Kayapa Kallahan
Added: 2009-07-29
%%
Type: language
Subtag: kam
Description: Kamba (Kenya)
Added: 2005-10-16
%%
Type: language
Subtag: kao
Description: Xaasongaxango
Added: 2009-07-29
%%
Type: language
Subtag: kap
Description: Bezhta
Added: 2009-07-29
%%
Type: language
Subtag: kaq
Description: Capanahua
Added: 2009-07-29
%%
Type: language
Subtag: kar
Description: Karen languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: kav
Description: Katukína
Added: 2009-07-29
%%
Type: language
Subtag: kaw
Description: Kawi
Added: 2005-10-16
%%
Type: language
Subtag: kax
Description: Kao
Added: 2009-07-29
%%
Type: language
Subtag: kay
Description: Kamayurá
Added: 2009-07-29
%%
Type: language
Subtag: kba
Description: Kalarko
Added: 2009-07-29
%%
Type: language
Subtag: kbb
Description: Kaxuiâna
Added: 2009-07-29
%%
Type: language
Subtag: kbc
Description: Kadiwéu
Added: 2009-07-29
%%
Type: language
Subtag: kbd
Description: Kabardian
Added: 2005-10-16
%%
Type: language
Subtag: kbe
Description: Kanju
Added: 2009-07-29
%%
Type: language
Subtag: kbf
Description: Kakauhua
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: kbg
Description: Khamba
Added: 2009-07-29
%%
Type: language
Subtag: kbh
Description: Camsá
Added: 2009-07-29
%%
Type: language
Subtag: kbi
Description: Kaptiau
Added: 2009-07-29
%%
Type: language
Subtag: kbj
Description: Kari
Added: 2009-07-29
%%
Type: language
Subtag: kbk
Description: Grass Koiari
Added: 2009-07-29
%%
Type: language
Subtag: kbl
Description: Kanembu
Added: 2009-07-29
%%
Type: language
Subtag: kbm
Description: Iwal
Added: 2009-07-29
%%
Type: language
Subtag: kbn
Description: Kare (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: kbo
Description: Keliko
Added: 2009-07-29
%%
Type: language
Subtag: kbp
Description: Kabiyè
Added: 2009-07-29
%%
Type: language
Subtag: kbq
Description: Kamano
Added: 2009-07-29
%%
Type: language
Subtag: kbr
Description: Kafa
Added: 2009-07-29
%%
Type: language
Subtag: kbs
Description: Kande
Added: 2009-07-29
%%
Type: language
Subtag: kbt
Description: Abadi
Added: 2009-07-29
%%
Type: language
Subtag: kbu
Description: Kabutra
Added: 2009-07-29
%%
Type: language
Subtag: kbv
Description: Dera (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: kbw
Description: Kaiep
Added: 2009-07-29
%%
Type: language
Subtag: kbx
Description: Ap Ma
Added: 2009-07-29
%%
Type: language
Subtag: kby
Description: Manga Kanuri
Added: 2009-07-29
Macrolanguage: kr
%%
Type: language
Subtag: kbz
Description: Duhwa
Added: 2009-07-29
%%
Type: language
Subtag: kca
Description: Khanty
Added: 2009-07-29
%%
Type: language
Subtag: kcb
Description: Kawacha
Added: 2009-07-29
%%
Type: language
Subtag: kcc
Description: Lubila
Added: 2009-07-29
%%
Type: language
Subtag: kcd
Description: Ngkâlmpw Kanum
Added: 2009-07-29
%%
Type: language
Subtag: kce
Description: Kaivi
Added: 2009-07-29
%%
Type: language
Subtag: kcf
Description: Ukaan
Added: 2009-07-29
%%
Type: language
Subtag: kcg
Description: Tyap
Added: 2009-07-29
%%
Type: language
Subtag: kch
Description: Vono
Added: 2009-07-29
%%
Type: language
Subtag: kci
Description: Kamantan
Added: 2009-07-29
%%
Type: language
Subtag: kcj
Description: Kobiana
Added: 2009-07-29
%%
Type: language
Subtag: kck
Description: Kalanga
Added: 2009-07-29
%%
Type: language
Subtag: kcl
Description: Kela (Papua New Guinea)
Description: Kala
Added: 2009-07-29
%%
Type: language
Subtag: kcm
Description: Gula (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: kcn
Description: Nubi
Added: 2009-07-29
%%
Type: language
Subtag: kco
Description: Kinalakna
Added: 2009-07-29
%%
Type: language
Subtag: kcp
Description: Kanga
Added: 2009-07-29
%%
Type: language
Subtag: kcq
Description: Kamo
Added: 2009-07-29
%%
Type: language
Subtag: kcr
Description: Katla
Added: 2009-07-29
%%
Type: language
Subtag: kcs
Description: Koenoem
Added: 2009-07-29
%%
Type: language
Subtag: kct
Description: Kaian
Added: 2009-07-29
%%
Type: language
Subtag: kcu
Description: Kami (Tanzania)
Added: 2009-07-29
%%
Type: language
Subtag: kcv
Description: Kete
Added: 2009-07-29
%%
Type: language
Subtag: kcw
Description: Kabwari
Added: 2009-07-29
%%
Type: language
Subtag: kcx
Description: Kachama-Ganjule
Added: 2009-07-29
%%
Type: language
Subtag: kcy
Description: Korandje
Added: 2009-07-29
%%
Type: language
Subtag: kcz
Description: Konongo
Added: 2009-07-29
%%
Type: language
Subtag: kda
Description: Worimi
Added: 2009-07-29
%%
Type: language
Subtag: kdc
Description: Kutu
Added: 2009-07-29
%%
Type: language
Subtag: kdd
Description: Yankunytjatjara
Added: 2009-07-29
%%
Type: language
Subtag: kde
Description: Makonde
Added: 2009-07-29
%%
Type: language
Subtag: kdf
Description: Mamusi
Added: 2009-07-29
%%
Type: language
Subtag: kdg
Description: Seba
Added: 2009-07-29
%%
Type: language
Subtag: kdh
Description: Tem
Added: 2009-07-29
%%
Type: language
Subtag: kdi
Description: Kumam
Added: 2009-07-29
%%
Type: language
Subtag: kdj
Description: Karamojong
Added: 2009-07-29
%%
Type: language
Subtag: kdk
Description: Numèè
Description: Kwényi
Added: 2009-07-29
%%
Type: language
Subtag: kdl
Description: Tsikimba
Added: 2009-07-29
%%
Type: language
Subtag: kdm
Description: Kagoma
Added: 2009-07-29
%%
Type: language
Subtag: kdn
Description: Kunda
Added: 2009-07-29
%%
Type: language
Subtag: kdo
Description: Kordofanian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: kdp
Description: Kaningdon-Nindem
Added: 2009-07-29
%%
Type: language
Subtag: kdq
Description: Koch
Added: 2009-07-29
%%
Type: language
Subtag: kdr
Description: Karaim
Added: 2009-07-29
%%
Type: language
Subtag: kdt
Description: Kuy
Added: 2009-07-29
%%
Type: language
Subtag: kdu
Description: Kadaru
Added: 2009-07-29
%%
Type: language
Subtag: kdv
Description: Kado
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see zkd, zkn
%%
Type: language
Subtag: kdw
Description: Koneraw
Added: 2009-07-29
%%
Type: language
Subtag: kdx
Description: Kam
Added: 2009-07-29
%%
Type: language
Subtag: kdy
Description: Keder
Description: Keijar
Added: 2009-07-29
%%
Type: language
Subtag: kdz
Description: Kwaja
Added: 2009-07-29
%%
Type: language
Subtag: kea
Description: Kabuverdianu
Added: 2009-07-29
%%
Type: language
Subtag: keb
Description: Kélé
Added: 2009-07-29
%%
Type: language
Subtag: kec
Description: Keiga
Added: 2009-07-29
%%
Type: language
Subtag: ked
Description: Kerewe
Added: 2009-07-29
%%
Type: language
Subtag: kee
Description: Eastern Keres
Added: 2009-07-29
%%
Type: language
Subtag: kef
Description: Kpessi
Added: 2009-07-29
%%
Type: language
Subtag: keg
Description: Tese
Added: 2009-07-29
%%
Type: language
Subtag: keh
Description: Keak
Added: 2009-07-29
%%
Type: language
Subtag: kei
Description: Kei
Added: 2009-07-29
%%
Type: language
Subtag: kej
Description: Kadar
Added: 2009-07-29
%%
Type: language
Subtag: kek
Description: Kekchí
Added: 2009-07-29
%%
Type: language
Subtag: kel
Description: Kela (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: kem
Description: Kemak
Added: 2009-07-29
%%
Type: language
Subtag: ken
Description: Kenyang
Added: 2009-07-29
%%
Type: language
Subtag: keo
Description: Kakwa
Added: 2009-07-29
%%
Type: language
Subtag: kep
Description: Kaikadi
Added: 2009-07-29
%%
Type: language
Subtag: keq
Description: Kamar
Added: 2009-07-29
%%
Type: language
Subtag: ker
Description: Kera
Added: 2009-07-29
%%
Type: language
Subtag: kes
Description: Kugbo
Added: 2009-07-29
%%
Type: language
Subtag: ket
Description: Ket
Added: 2009-07-29
%%
Type: language
Subtag: keu
Description: Akebu
Added: 2009-07-29
%%
Type: language
Subtag: kev
Description: Kanikkaran
Added: 2009-07-29
%%
Type: language
Subtag: kew
Description: West Kewa
Added: 2009-07-29
%%
Type: language
Subtag: kex
Description: Kukna
Added: 2009-07-29
%%
Type: language
Subtag: key
Description: Kupia
Added: 2009-07-29
%%
Type: language
Subtag: kez
Description: Kukele
Added: 2009-07-29
%%
Type: language
Subtag: kfa
Description: Kodava
Added: 2009-07-29
%%
Type: language
Subtag: kfb
Description: Northwestern Kolami
Added: 2009-07-29
%%
Type: language
Subtag: kfc
Description: Konda-Dora
Added: 2009-07-29
%%
Type: language
Subtag: kfd
Description: Korra Koraga
Added: 2009-07-29
%%
Type: language
Subtag: kfe
Description: Kota (India)
Added: 2009-07-29
%%
Type: language
Subtag: kff
Description: Koya
Added: 2009-07-29
%%
Type: language
Subtag: kfg
Description: Kudiya
Added: 2009-07-29
%%
Type: language
Subtag: kfh
Description: Kurichiya
Added: 2009-07-29
%%
Type: language
Subtag: kfi
Description: Kannada Kurumba
Added: 2009-07-29
%%
Type: language
Subtag: kfj
Description: Kemiehua
Added: 2009-07-29
%%
Type: language
Subtag: kfk
Description: Kinnauri
Added: 2009-07-29
%%
Type: language
Subtag: kfl
Description: Kung
Added: 2009-07-29
%%
Type: language
Subtag: kfm
Description: Khunsari
Added: 2009-07-29
%%
Type: language
Subtag: kfn
Description: Kuk
Added: 2009-07-29
%%
Type: language
Subtag: kfo
Description: Koro (Côte d'Ivoire)
Added: 2009-07-29
%%
Type: language
Subtag: kfp
Description: Korwa
Added: 2009-07-29
%%
Type: language
Subtag: kfq
Description: Korku
Added: 2009-07-29
%%
Type: language
Subtag: kfr
Description: Kachhi
Description: Kutchi
Added: 2009-07-29
%%
Type: language
Subtag: kfs
Description: Bilaspuri
Added: 2009-07-29
%%
Type: language
Subtag: kft
Description: Kanjari
Added: 2009-07-29
%%
Type: language
Subtag: kfu
Description: Katkari
Added: 2009-07-29
%%
Type: language
Subtag: kfv
Description: Kurmukar
Added: 2009-07-29
%%
Type: language
Subtag: kfw
Description: Kharam Naga
Added: 2009-07-29
%%
Type: language
Subtag: kfx
Description: Kullu Pahari
Added: 2009-07-29
%%
Type: language
Subtag: kfy
Description: Kumaoni
Added: 2009-07-29
%%
Type: language
Subtag: kfz
Description: Koromfé
Added: 2009-07-29
%%
Type: language
Subtag: kga
Description: Koyaga
Added: 2009-07-29
%%
Type: language
Subtag: kgb
Description: Kawe
Added: 2009-07-29
%%
Type: language
Subtag: kgc
Description: Kasseng
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: tdf
%%
Type: language
Subtag: kgd
Description: Kataang
Added: 2009-07-29
Deprecated: 2017-02-23
Comments: see ncq, sct
%%
Type: language
Subtag: kge
Description: Komering
Added: 2009-07-29
%%
Type: language
Subtag: kgf
Description: Kube
Added: 2009-07-29
%%
Type: language
Subtag: kgg
Description: Kusunda
Added: 2009-07-29
%%
Type: language
Subtag: kgh
Description: Upper Tanudan Kalinga
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: kml
%%
Type: language
Subtag: kgi
Description: Selangor Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: kgj
Description: Gamale Kham
Added: 2009-07-29
%%
Type: language
Subtag: kgk
Description: Kaiwá
Added: 2009-07-29
%%
Type: language
Subtag: kgl
Description: Kunggari
Added: 2009-07-29
%%
Type: language
Subtag: kgm
Description: Karipúna
Added: 2009-07-29
%%
Type: language
Subtag: kgn
Description: Karingani
Added: 2009-07-29
%%
Type: language
Subtag: kgo
Description: Krongo
Added: 2009-07-29
%%
Type: language
Subtag: kgp
Description: Kaingang
Added: 2009-07-29
%%
Type: language
Subtag: kgq
Description: Kamoro
Added: 2009-07-29
%%
Type: language
Subtag: kgr
Description: Abun
Added: 2009-07-29
%%
Type: language
Subtag: kgs
Description: Kumbainggar
Added: 2009-07-29
%%
Type: language
Subtag: kgt
Description: Somyev
Added: 2009-07-29
%%
Type: language
Subtag: kgu
Description: Kobol
Added: 2009-07-29
%%
Type: language
Subtag: kgv
Description: Karas
Added: 2009-07-29
%%
Type: language
Subtag: kgw
Description: Karon Dori
Added: 2009-07-29
%%
Type: language
Subtag: kgx
Description: Kamaru
Added: 2009-07-29
%%
Type: language
Subtag: kgy
Description: Kyerung
Added: 2009-07-29
%%
Type: language
Subtag: kha
Description: Khasi
Added: 2005-10-16
Comments: as of 2008-04-21 this subtag does not include Lyngngam; see
  lyg
%%
Type: language
Subtag: khb
Description: Lü
Added: 2009-07-29
%%
Type: language
Subtag: khc
Description: Tukang Besi North
Added: 2009-07-29
%%
Type: language
Subtag: khd
Description: Bädi Kanum
Added: 2009-07-29
%%
Type: language
Subtag: khe
Description: Korowai
Added: 2009-07-29
%%
Type: language
Subtag: khf
Description: Khuen
Added: 2009-07-29
%%
Type: language
Subtag: khg
Description: Khams Tibetan
Added: 2009-07-29
%%
Type: language
Subtag: khh
Description: Kehu
Added: 2009-07-29
%%
Type: language
Subtag: khi
Description: Khoisan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: khj
Description: Kuturmi
Added: 2009-07-29
%%
Type: language
Subtag: khk
Description: Halh Mongolian
Added: 2009-07-29
Macrolanguage: mn
%%
Type: language
Subtag: khl
Description: Lusi
Added: 2009-07-29
%%
Type: language
Subtag: khn
Description: Khandesi
Added: 2009-07-29
%%
Type: language
Subtag: kho
Description: Khotanese
Description: Sakan
Added: 2005-10-16
%%
Type: language
Subtag: khp
Description: Kapori
Description: Kapauri
Added: 2009-07-29
%%
Type: language
Subtag: khq
Description: Koyra Chiini Songhay
Added: 2009-07-29
%%
Type: language
Subtag: khr
Description: Kharia
Added: 2009-07-29
%%
Type: language
Subtag: khs
Description: Kasua
Added: 2009-07-29
%%
Type: language
Subtag: kht
Description: Khamti
Added: 2009-07-29
%%
Type: language
Subtag: khu
Description: Nkhumbi
Added: 2009-07-29
%%
Type: language
Subtag: khv
Description: Khvarshi
Added: 2009-07-29
%%
Type: language
Subtag: khw
Description: Khowar
Added: 2009-07-29
%%
Type: language
Subtag: khx
Description: Kanu
Added: 2009-07-29
%%
Type: language
Subtag: khy
Description: Kele (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: khz
Description: Keapara
Added: 2009-07-29
%%
Type: language
Subtag: kia
Description: Kim
Added: 2009-07-29
%%
Type: language
Subtag: kib
Description: Koalib
Added: 2009-07-29
%%
Type: language
Subtag: kic
Description: Kickapoo
Added: 2009-07-29
%%
Type: language
Subtag: kid
Description: Koshin
Added: 2009-07-29
%%
Type: language
Subtag: kie
Description: Kibet
Added: 2009-07-29
%%
Type: language
Subtag: kif
Description: Eastern Parbate Kham
Added: 2009-07-29
%%
Type: language
Subtag: kig
Description: Kimaama
Description: Kimaghima
Added: 2009-07-29
%%
Type: language
Subtag: kih
Description: Kilmeri
Added: 2009-07-29
%%
Type: language
Subtag: kii
Description: Kitsai
Added: 2009-07-29
%%
Type: language
Subtag: kij
Description: Kilivila
Added: 2009-07-29
%%
Type: language
Subtag: kil
Description: Kariya
Added: 2009-07-29
%%
Type: language
Subtag: kim
Description: Karagas
Added: 2009-07-29
%%
Type: language
Subtag: kio
Description: Kiowa
Added: 2009-07-29
%%
Type: language
Subtag: kip
Description: Sheshi Kham
Added: 2009-07-29
%%
Type: language
Subtag: kiq
Description: Kosadle
Description: Kosare
Added: 2009-07-29
%%
Type: language
Subtag: kis
Description: Kis
Added: 2009-07-29
%%
Type: language
Subtag: kit
Description: Agob
Added: 2009-07-29
%%
Type: language
Subtag: kiu
Description: Kirmanjki (individual language)
Added: 2009-07-29
Macrolanguage: zza
%%
Type: language
Subtag: kiv
Description: Kimbu
Added: 2009-07-29
%%
Type: language
Subtag: kiw
Description: Northeast Kiwai
Added: 2009-07-29
%%
Type: language
Subtag: kix
Description: Khiamniungan Naga
Added: 2009-07-29
%%
Type: language
Subtag: kiy
Description: Kirikiri
Added: 2009-07-29
%%
Type: language
Subtag: kiz
Description: Kisi
Added: 2009-07-29
%%
Type: language
Subtag: kja
Description: Mlap
Added: 2009-07-29
%%
Type: language
Subtag: kjb
Description: Q'anjob'al
Description: Kanjobal
Added: 2009-07-29
%%
Type: language
Subtag: kjc
Description: Coastal Konjo
Added: 2009-07-29
%%
Type: language
Subtag: kjd
Description: Southern Kiwai
Added: 2009-07-29
%%
Type: language
Subtag: kje
Description: Kisar
Added: 2009-07-29
%%
Type: language
Subtag: kjf
Description: Khalaj
Added: 2009-07-29
%%
Type: language
Subtag: kjg
Description: Khmu
Added: 2009-07-29
%%
Type: language
Subtag: kjh
Description: Khakas
Added: 2009-07-29
%%
Type: language
Subtag: kji
Description: Zabana
Added: 2009-07-29
%%
Type: language
Subtag: kjj
Description: Khinalugh
Added: 2009-07-29
%%
Type: language
Subtag: kjk
Description: Highland Konjo
Added: 2009-07-29
%%
Type: language
Subtag: kjl
Description: Western Parbate Kham
Added: 2009-07-29
%%
Type: language
Subtag: kjm
Description: Kháng
Added: 2009-07-29
%%
Type: language
Subtag: kjn
Description: Kunjen
Added: 2009-07-29
%%
Type: language
Subtag: kjo
Description: Harijan Kinnauri
Added: 2009-07-29
%%
Type: language
Subtag: kjp
Description: Pwo Eastern Karen
Added: 2009-07-29
%%
Type: language
Subtag: kjq
Description: Western Keres
Added: 2009-07-29
%%
Type: language
Subtag: kjr
Description: Kurudu
Added: 2009-07-29
%%
Type: language
Subtag: kjs
Description: East Kewa
Added: 2009-07-29
%%
Type: language
Subtag: kjt
Description: Phrae Pwo Karen
Added: 2009-07-29
%%
Type: language
Subtag: kju
Description: Kashaya
Added: 2009-07-29
%%
Type: language
Subtag: kjv
Description: Kaikavian Literary Language
Added: 2015-02-12
%%
Type: language
Subtag: kjx
Description: Ramopa
Added: 2009-07-29
%%
Type: language
Subtag: kjy
Description: Erave
Added: 2009-07-29
%%
Type: language
Subtag: kjz
Description: Bumthangkha
Added: 2009-07-29
%%
Type: language
Subtag: kka
Description: Kakanda
Added: 2009-07-29
%%
Type: language
Subtag: kkb
Description: Kwerisa
Added: 2009-07-29
%%
Type: language
Subtag: kkc
Description: Odoodee
Added: 2009-07-29
%%
Type: language
Subtag: kkd
Description: Kinuku
Added: 2009-07-29
%%
Type: language
Subtag: kke
Description: Kakabe
Added: 2009-07-29
%%
Type: language
Subtag: kkf
Description: Kalaktang Monpa
Added: 2009-07-29
%%
Type: language
Subtag: kkg
Description: Mabaka Valley Kalinga
Added: 2009-07-29
%%
Type: language
Subtag: kkh
Description: Khün
Added: 2009-07-29
%%
Type: language
Subtag: kki
Description: Kagulu
Added: 2009-07-29
%%
Type: language
Subtag: kkj
Description: Kako
Added: 2009-07-29
%%
Type: language
Subtag: kkk
Description: Kokota
Added: 2009-07-29
%%
Type: language
Subtag: kkl
Description: Kosarek Yale
Added: 2009-07-29
%%
Type: language
Subtag: kkm
Description: Kiong
Added: 2009-07-29
%%
Type: language
Subtag: kkn
Description: Kon Keu
Added: 2009-07-29
%%
Type: language
Subtag: kko
Description: Karko
Added: 2009-07-29
%%
Type: language
Subtag: kkp
Description: Gugubera
Description: Koko-Bera
Added: 2009-07-29
%%
Type: language
Subtag: kkq
Description: Kaiku
Added: 2009-07-29
%%
Type: language
Subtag: kkr
Description: Kir-Balar
Added: 2009-07-29
%%
Type: language
Subtag: kks
Description: Giiwo
Added: 2009-07-29
%%
Type: language
Subtag: kkt
Description: Koi
Added: 2009-07-29
%%
Type: language
Subtag: kku
Description: Tumi
Added: 2009-07-29
%%
Type: language
Subtag: kkv
Description: Kangean
Added: 2009-07-29
%%
Type: language
Subtag: kkw
Description: Teke-Kukuya
Added: 2009-07-29
%%
Type: language
Subtag: kkx
Description: Kohin
Added: 2009-07-29
%%
Type: language
Subtag: kky
Description: Guugu Yimidhirr
Description: Guguyimidjir
Added: 2009-07-29
%%
Type: language
Subtag: kkz
Description: Kaska
Added: 2009-07-29
%%
Type: language
Subtag: kla
Description: Klamath-Modoc
Added: 2009-07-29
%%
Type: language
Subtag: klb
Description: Kiliwa
Added: 2009-07-29
%%
Type: language
Subtag: klc
Description: Kolbila
Added: 2009-07-29
%%
Type: language
Subtag: kld
Description: Gamilaraay
Added: 2009-07-29
%%
Type: language
Subtag: kle
Description: Kulung (Nepal)
Added: 2009-07-29
%%
Type: language
Subtag: klf
Description: Kendeje
Added: 2009-07-29
%%
Type: language
Subtag: klg
Description: Tagakaulo
Added: 2009-07-29
%%
Type: language
Subtag: klh
Description: Weliki
Added: 2009-07-29
%%
Type: language
Subtag: kli
Description: Kalumpang
Added: 2009-07-29
%%
Type: language
Subtag: klj
Description: Turkic Khalaj
Added: 2009-07-29
%%
Type: language
Subtag: klk
Description: Kono (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: kll
Description: Kagan Kalagan
Added: 2009-07-29
%%
Type: language
Subtag: klm
Description: Migum
Added: 2009-07-29
%%
Type: language
Subtag: kln
Description: Kalenjin
Added: 2009-07-29
Scope: macrolanguage
%%
Type: language
Subtag: klo
Description: Kapya
Added: 2009-07-29
%%
Type: language
Subtag: klp
Description: Kamasa
Added: 2009-07-29
%%
Type: language
Subtag: klq
Description: Rumu
Added: 2009-07-29
%%
Type: language
Subtag: klr
Description: Khaling
Added: 2009-07-29
%%
Type: language
Subtag: kls
Description: Kalasha
Added: 2009-07-29
%%
Type: language
Subtag: klt
Description: Nukna
Added: 2009-07-29
%%
Type: language
Subtag: klu
Description: Klao
Added: 2009-07-29
%%
Type: language
Subtag: klv
Description: Maskelynes
Added: 2009-07-29
%%
Type: language
Subtag: klw
Description: Tado
Description: Lindu
Added: 2009-07-29
%%
Type: language
Subtag: klx
Description: Koluwawa
Added: 2009-07-29
%%
Type: language
Subtag: kly
Description: Kalao
Added: 2009-07-29
%%
Type: language
Subtag: klz
Description: Kabola
Added: 2009-07-29
%%
Type: language
Subtag: kma
Description: Konni
Added: 2009-07-29
%%
Type: language
Subtag: kmb
Description: Kimbundu
Added: 2005-10-16
%%
Type: language
Subtag: kmc
Description: Southern Dong
Added: 2009-07-29
%%
Type: language
Subtag: kmd
Description: Majukayang Kalinga
Added: 2009-07-29
%%
Type: language
Subtag: kme
Description: Bakole
Added: 2009-07-29
%%
Type: language
Subtag: kmf
Description: Kare (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: kmg
Description: Kâte
Added: 2009-07-29
%%
Type: language
Subtag: kmh
Description: Kalam
Added: 2009-07-29
%%
Type: language
Subtag: kmi
Description: Kami (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: kmj
Description: Kumarbhag Paharia
Added: 2009-07-29
%%
Type: language
Subtag: kmk
Description: Limos Kalinga
Added: 2009-07-29
%%
Type: language
Subtag: kml
Description: Tanudan Kalinga
Added: 2009-07-29
%%
Type: language
Subtag: kmm
Description: Kom (India)
Added: 2009-07-29
%%
Type: language
Subtag: kmn
Description: Awtuw
Added: 2009-07-29
%%
Type: language
Subtag: kmo
Description: Kwoma
Added: 2009-07-29
%%
Type: language
Subtag: kmp
Description: Gimme
Added: 2009-07-29
%%
Type: language
Subtag: kmq
Description: Kwama
Added: 2009-07-29
%%
Type: language
Subtag: kmr
Description: Northern Kurdish
Added: 2009-07-29
Macrolanguage: ku
%%
Type: language
Subtag: kms
Description: Kamasau
Added: 2009-07-29
%%
Type: language
Subtag: kmt
Description: Kemtuik
Added: 2009-07-29
%%
Type: language
Subtag: kmu
Description: Kanite
Added: 2009-07-29
%%
Type: language
Subtag: kmv
Description: Karipúna Creole French
Added: 2009-07-29
%%
Type: language
Subtag: kmw
Description: Komo (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: kmx
Description: Waboda
Added: 2009-07-29
%%
Type: language
Subtag: kmy
Description: Koma
Added: 2009-07-29
%%
Type: language
Subtag: kmz
Description: Khorasani Turkish
Added: 2009-07-29
%%
Type: language
Subtag: kna
Description: Dera (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: knb
Description: Lubuagan Kalinga
Added: 2009-07-29
%%
Type: language
Subtag: knc
Description: Central Kanuri
Added: 2009-07-29
Macrolanguage: kr
%%
Type: language
Subtag: knd
Description: Konda
Added: 2009-07-29
%%
Type: language
Subtag: kne
Description: Kankanaey
Added: 2009-07-29
%%
Type: language
Subtag: knf
Description: Mankanya
Added: 2009-07-29
%%
Type: language
Subtag: kng
Description: Koongo
Added: 2009-07-29
Macrolanguage: kg
%%
Type: language
Subtag: kni
Description: Kanufi
Added: 2009-07-29
%%
Type: language
Subtag: knj
Description: Western Kanjobal
Added: 2009-07-29
%%
Type: language
Subtag: knk
Description: Kuranko
Added: 2009-07-29
%%
Type: language
Subtag: knl
Description: Keninjal
Added: 2009-07-29
%%
Type: language
Subtag: knm
Description: Kanamarí
Added: 2009-07-29
%%
Type: language
Subtag: knn
Description: Konkani (individual language)
Added: 2009-07-29
Macrolanguage: kok
%%
Type: language
Subtag: kno
Description: Kono (Sierra Leone)
Added: 2009-07-29
%%
Type: language
Subtag: knp
Description: Kwanja
Added: 2009-07-29
%%
Type: language
Subtag: knq
Description: Kintaq
Added: 2009-07-29
%%
Type: language
Subtag: knr
Description: Kaningra
Added: 2009-07-29
%%
Type: language
Subtag: kns
Description: Kensiu
Added: 2009-07-29
%%
Type: language
Subtag: knt
Description: Panoan Katukína
Added: 2009-07-29
%%
Type: language
Subtag: knu
Description: Kono (Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: knv
Description: Tabo
Added: 2009-07-29
%%
Type: language
Subtag: knw
Description: Kung-Ekoka
Added: 2009-07-29
%%
Type: language
Subtag: knx
Description: Kendayan
Description: Salako
Added: 2009-07-29
%%
Type: language
Subtag: kny
Description: Kanyok
Added: 2009-07-29
%%
Type: language
Subtag: knz
Description: Kalamsé
Added: 2009-07-29
%%
Type: language
Subtag: koa
Description: Konomala
Added: 2009-07-29
%%
Type: language
Subtag: koc
Description: Kpati
Added: 2009-07-29
%%
Type: language
Subtag: kod
Description: Kodi
Added: 2009-07-29
%%
Type: language
Subtag: koe
Description: Kacipo-Balesi
Added: 2009-07-29
%%
Type: language
Subtag: kof
Description: Kubi
Added: 2009-07-29
%%
Type: language
Subtag: kog
Description: Cogui
Description: Kogi
Added: 2009-07-29
%%
Type: language
Subtag: koh
Description: Koyo
Added: 2009-07-29
%%
Type: language
Subtag: koi
Description: Komi-Permyak
Added: 2009-07-29
Macrolanguage: kv
%%
Type: language
Subtag: koj
Description: Sara Dunjo
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: kwv
%%
Type: language
Subtag: kok
Description: Konkani (macrolanguage)
Added: 2005-10-16
Suppress-Script: Deva
Scope: macrolanguage
%%
Type: language
Subtag: kol
Description: Kol (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: koo
Description: Konzo
Added: 2009-07-29
%%
Type: language
Subtag: kop
Description: Waube
Added: 2009-07-29
%%
Type: language
Subtag: koq
Description: Kota (Gabon)
Added: 2009-07-29
%%
Type: language
Subtag: kos
Description: Kosraean
Added: 2005-10-16
%%
Type: language
Subtag: kot
Description: Lagwan
Added: 2009-07-29
%%
Type: language
Subtag: kou
Description: Koke
Added: 2009-07-29
%%
Type: language
Subtag: kov
Description: Kudu-Camo
Added: 2009-07-29
%%
Type: language
Subtag: kow
Description: Kugama
Added: 2009-07-29
%%
Type: language
Subtag: kox
Description: Coxima
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: koy
Description: Koyukon
Added: 2009-07-29
%%
Type: language
Subtag: koz
Description: Korak
Added: 2009-07-29
%%
Type: language
Subtag: kpa
Description: Kutto
Added: 2009-07-29
%%
Type: language
Subtag: kpb
Description: Mullu Kurumba
Added: 2009-07-29
%%
Type: language
Subtag: kpc
Description: Curripaco
Added: 2009-07-29
%%
Type: language
Subtag: kpd
Description: Koba
Added: 2009-07-29
%%
Type: language
Subtag: kpe
Description: Kpelle
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: kpf
Description: Komba
Added: 2009-07-29
%%
Type: language
Subtag: kpg
Description: Kapingamarangi
Added: 2009-07-29
%%
Type: language
Subtag: kph
Description: Kplang
Added: 2009-07-29
%%
Type: language
Subtag: kpi
Description: Kofei
Added: 2009-07-29
%%
Type: language
Subtag: kpj
Description: Karajá
Added: 2009-07-29
%%
Type: language
Subtag: kpk
Description: Kpan
Added: 2009-07-29
%%
Type: language
Subtag: kpl
Description: Kpala
Added: 2009-07-29
%%
Type: language
Subtag: kpm
Description: Koho
Added: 2009-07-29
%%
Type: language
Subtag: kpn
Description: Kepkiriwát
Added: 2009-07-29
%%
Type: language
Subtag: kpo
Description: Ikposo
Added: 2009-07-29
%%
Type: language
Subtag: kpp
Description: Paku Karen
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see jkm, jkp
%%
Type: language
Subtag: kpq
Description: Korupun-Sela
Added: 2009-07-29
%%
Type: language
Subtag: kpr
Description: Korafe-Yegha
Added: 2009-07-29
%%
Type: language
Subtag: kps
Description: Tehit
Added: 2009-07-29
%%
Type: language
Subtag: kpt
Description: Karata
Added: 2009-07-29
%%
Type: language
Subtag: kpu
Description: Kafoa
Added: 2009-07-29
%%
Type: language
Subtag: kpv
Description: Komi-Zyrian
Added: 2009-07-29
Macrolanguage: kv
%%
Type: language
Subtag: kpw
Description: Kobon
Added: 2009-07-29
%%
Type: language
Subtag: kpx
Description: Mountain Koiali
Added: 2009-07-29
%%
Type: language
Subtag: kpy
Description: Koryak
Added: 2009-07-29
%%
Type: language
Subtag: kpz
Description: Kupsabiny
Added: 2009-07-29
%%
Type: language
Subtag: kqa
Description: Mum
Added: 2009-07-29
%%
Type: language
Subtag: kqb
Description: Kovai
Added: 2009-07-29
%%
Type: language
Subtag: kqc
Description: Doromu-Koki
Added: 2009-07-29
%%
Type: language
Subtag: kqd
Description: Koy Sanjaq Surat
Added: 2009-07-29
%%
Type: language
Subtag: kqe
Description: Kalagan
Added: 2009-07-29
%%
Type: language
Subtag: kqf
Description: Kakabai
Added: 2009-07-29
%%
Type: language
Subtag: kqg
Description: Khe
Added: 2009-07-29
%%
Type: language
Subtag: kqh
Description: Kisankasa
Added: 2009-07-29
%%
Type: language
Subtag: kqi
Description: Koitabu
Added: 2009-07-29
%%
Type: language
Subtag: kqj
Description: Koromira
Added: 2009-07-29
%%
Type: language
Subtag: kqk
Description: Kotafon Gbe
Added: 2009-07-29
%%
Type: language
Subtag: kql
Description: Kyenele
Added: 2009-07-29
%%
Type: language
Subtag: kqm
Description: Khisa
Added: 2009-07-29
%%
Type: language
Subtag: kqn
Description: Kaonde
Added: 2009-07-29
%%
Type: language
Subtag: kqo
Description: Eastern Krahn
Added: 2009-07-29
%%
Type: language
Subtag: kqp
Description: Kimré
Added: 2009-07-29
%%
Type: language
Subtag: kqq
Description: Krenak
Added: 2009-07-29
%%
Type: language
Subtag: kqr
Description: Kimaragang
Added: 2009-07-29
%%
Type: language
Subtag: kqs
Description: Northern Kissi
Added: 2009-07-29
%%
Type: language
Subtag: kqt
Description: Klias River Kadazan
Added: 2009-07-29
%%
Type: language
Subtag: kqu
Description: Seroa
Added: 2009-07-29
%%
Type: language
Subtag: kqv
Description: Okolod
Added: 2009-07-29
%%
Type: language
Subtag: kqw
Description: Kandas
Added: 2009-07-29
%%
Type: language
Subtag: kqx
Description: Mser
Added: 2009-07-29
%%
Type: language
Subtag: kqy
Description: Koorete
Added: 2009-07-29
%%
Type: language
Subtag: kqz
Description: Korana
Added: 2009-07-29
%%
Type: language
Subtag: kra
Description: Kumhali
Added: 2009-07-29
%%
Type: language
Subtag: krb
Description: Karkin
Added: 2009-07-29
%%
Type: language
Subtag: krc
Description: Karachay-Balkar
Added: 2005-10-16
%%
Type: language
Subtag: krd
Description: Kairui-Midiki
Added: 2009-07-29
%%
Type: language
Subtag: kre
Description: Panará
Added: 2009-07-29
%%
Type: language
Subtag: krf
Description: Koro (Vanuatu)
Added: 2009-07-29
%%
Type: language
Subtag: krh
Description: Kurama
Added: 2009-07-29
%%
Type: language
Subtag: kri
Description: Krio
Added: 2009-07-29
%%
Type: language
Subtag: krj
Description: Kinaray-A
Added: 2009-07-29
%%
Type: language
Subtag: krk
Description: Kerek
Added: 2009-07-29
%%
Type: language
Subtag: krl
Description: Karelian
Added: 2006-03-08
%%
Type: language
Subtag: krm
Description: Krim
Added: 2009-07-29
Deprecated: 2017-02-23
Preferred-Value: bmf
%%
Type: language
Subtag: krn
Description: Sapo
Added: 2009-07-29
%%
Type: language
Subtag: kro
Description: Kru languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: krp
Description: Korop
Added: 2009-07-29
%%
Type: language
Subtag: krr
Description: Krung
Added: 2009-07-29
%%
Type: language
Subtag: krs
Description: Gbaya (Sudan)
Added: 2009-07-29
%%
Type: language
Subtag: krt
Description: Tumari Kanuri
Added: 2009-07-29
Macrolanguage: kr
%%
Type: language
Subtag: kru
Description: Kurukh
Added: 2005-10-16
%%
Type: language
Subtag: krv
Description: Kavet
Added: 2009-07-29
%%
Type: language
Subtag: krw
Description: Western Krahn
Added: 2009-07-29
%%
Type: language
Subtag: krx
Description: Karon
Added: 2009-07-29
%%
Type: language
Subtag: kry
Description: Kryts
Added: 2009-07-29
%%
Type: language
Subtag: krz
Description: Sota Kanum
Added: 2009-07-29
%%
Type: language
Subtag: ksa
Description: Shuwa-Zamani
Added: 2009-07-29
%%
Type: language
Subtag: ksb
Description: Shambala
Added: 2009-07-29
%%
Type: language
Subtag: ksc
Description: Southern Kalinga
Added: 2009-07-29
%%
Type: language
Subtag: ksd
Description: Kuanua
Added: 2009-07-29
%%
Type: language
Subtag: kse
Description: Kuni
Added: 2009-07-29
%%
Type: language
Subtag: ksf
Description: Bafia
Added: 2009-07-29
%%
Type: language
Subtag: ksg
Description: Kusaghe
Added: 2009-07-29
%%
Type: language
Subtag: ksh
Description: Kölsch
Added: 2009-07-29
%%
Type: language
Subtag: ksi
Description: Krisa
Description: I'saka
Added: 2009-07-29
%%
Type: language
Subtag: ksj
Description: Uare
Added: 2009-07-29
%%
Type: language
Subtag: ksk
Description: Kansa
Added: 2009-07-29
%%
Type: language
Subtag: ksl
Description: Kumalu
Added: 2009-07-29
%%
Type: language
Subtag: ksm
Description: Kumba
Added: 2009-07-29
%%
Type: language
Subtag: ksn
Description: Kasiguranin
Added: 2009-07-29
%%
Type: language
Subtag: kso
Description: Kofa
Added: 2009-07-29
%%
Type: language
Subtag: ksp
Description: Kaba
Added: 2009-07-29
%%
Type: language
Subtag: ksq
Description: Kwaami
Added: 2009-07-29
%%
Type: language
Subtag: ksr
Description: Borong
Added: 2009-07-29
%%
Type: language
Subtag: kss
Description: Southern Kisi
Added: 2009-07-29
%%
Type: language
Subtag: kst
Description: Winyé
Added: 2009-07-29
%%
Type: language
Subtag: ksu
Description: Khamyang
Added: 2009-07-29
%%
Type: language
Subtag: ksv
Description: Kusu
Added: 2009-07-29
%%
Type: language
Subtag: ksw
Description: S'gaw Karen
Added: 2009-07-29
%%
Type: language
Subtag: ksx
Description: Kedang
Added: 2009-07-29
%%
Type: language
Subtag: ksy
Description: Kharia Thar
Added: 2009-07-29
%%
Type: language
Subtag: ksz
Description: Kodaku
Added: 2009-07-29
%%
Type: language
Subtag: kta
Description: Katua
Added: 2009-07-29
%%
Type: language
Subtag: ktb
Description: Kambaata
Added: 2009-07-29
%%
Type: language
Subtag: ktc
Description: Kholok
Added: 2009-07-29
%%
Type: language
Subtag: ktd
Description: Kokata
Description: Kukatha
Added: 2009-07-29
%%
Type: language
Subtag: kte
Description: Nubri
Added: 2009-07-29
%%
Type: language
Subtag: ktf
Description: Kwami
Added: 2009-07-29
%%
Type: language
Subtag: ktg
Description: Kalkutung
Added: 2009-07-29
%%
Type: language
Subtag: kth
Description: Karanga
Added: 2009-07-29
%%
Type: language
Subtag: kti
Description: North Muyu
Added: 2009-07-29
%%
Type: language
Subtag: ktj
Description: Plapo Krumen
Added: 2009-07-29
%%
Type: language
Subtag: ktk
Description: Kaniet
Added: 2009-07-29
%%
Type: language
Subtag: ktl
Description: Koroshi
Added: 2009-07-29
%%
Type: language
Subtag: ktm
Description: Kurti
Added: 2009-07-29
%%
Type: language
Subtag: ktn
Description: Karitiâna
Added: 2009-07-29
%%
Type: language
Subtag: kto
Description: Kuot
Added: 2009-07-29
%%
Type: language
Subtag: ktp
Description: Kaduo
Added: 2009-07-29
%%
Type: language
Subtag: ktq
Description: Katabaga
Added: 2009-07-29
%%
Type: language
Subtag: ktr
Description: Kota Marudu Tinagas
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: dtp
%%
Type: language
Subtag: kts
Description: South Muyu
Added: 2009-07-29
%%
Type: language
Subtag: ktt
Description: Ketum
Added: 2009-07-29
%%
Type: language
Subtag: ktu
Description: Kituba (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: ktv
Description: Eastern Katu
Added: 2009-07-29
%%
Type: language
Subtag: ktw
Description: Kato
Added: 2009-07-29
%%
Type: language
Subtag: ktx
Description: Kaxararí
Added: 2009-07-29
%%
Type: language
Subtag: kty
Description: Kango (Bas-Uélé District)
Added: 2009-07-29
%%
Type: language
Subtag: ktz
Description: Juǀʼhoan
Description: Juǀʼhoansi
Added: 2009-07-29
%%
Type: language
Subtag: kub
Description: Kutep
Added: 2009-07-29
%%
Type: language
Subtag: kuc
Description: Kwinsu
Added: 2009-07-29
%%
Type: language
Subtag: kud
Description: 'Auhelawa
Added: 2009-07-29
%%
Type: language
Subtag: kue
Description: Kuman (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: kuf
Description: Western Katu
Added: 2009-07-29
%%
Type: language
Subtag: kug
Description: Kupa
Added: 2009-07-29
%%
Type: language
Subtag: kuh
Description: Kushi
Added: 2009-07-29
%%
Type: language
Subtag: kui
Description: Kuikúro-Kalapálo
Added: 2009-07-29
%%
Type: language
Subtag: kuj
Description: Kuria
Added: 2009-07-29
%%
Type: language
Subtag: kuk
Description: Kepo'
Added: 2009-07-29
%%
Type: language
Subtag: kul
Description: Kulere
Added: 2009-07-29
%%
Type: language
Subtag: kum
Description: Kumyk
Added: 2005-10-16
%%
Type: language
Subtag: kun
Description: Kunama
Added: 2009-07-29
%%
Type: language
Subtag: kuo
Description: Kumukio
Added: 2009-07-29
%%
Type: language
Subtag: kup
Description: Kunimaipa
Added: 2009-07-29
%%
Type: language
Subtag: kuq
Description: Karipuna
Added: 2009-07-29
%%
Type: language
Subtag: kus
Description: Kusaal
Added: 2009-07-29
%%
Type: language
Subtag: kut
Description: Kutenai
Added: 2005-10-16
%%
Type: language
Subtag: kuu
Description: Upper Kuskokwim
Added: 2009-07-29
%%
Type: language
Subtag: kuv
Description: Kur
Added: 2009-07-29
%%
Type: language
Subtag: kuw
Description: Kpagua
Added: 2009-07-29
%%
Type: language
Subtag: kux
Description: Kukatja
Added: 2009-07-29
%%
Type: language
Subtag: kuy
Description: Kuuku-Ya'u
Added: 2009-07-29
%%
Type: language
Subtag: kuz
Description: Kunza
Added: 2009-07-29
%%
Type: language
Subtag: kva
Description: Bagvalal
Added: 2009-07-29
%%
Type: language
Subtag: kvb
Description: Kubu
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: kvc
Description: Kove
Added: 2009-07-29
%%
Type: language
Subtag: kvd
Description: Kui (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: kve
Description: Kalabakan
Added: 2009-07-29
%%
Type: language
Subtag: kvf
Description: Kabalai
Added: 2009-07-29
%%
Type: language
Subtag: kvg
Description: Kuni-Boazi
Added: 2009-07-29
%%
Type: language
Subtag: kvh
Description: Komodo
Added: 2009-07-29
%%
Type: language
Subtag: kvi
Description: Kwang
Added: 2009-07-29
%%
Type: language
Subtag: kvj
Description: Psikye
Added: 2009-07-29
%%
Type: language
Subtag: kvk
Description: Korean Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: kvl
Description: Kayaw
Added: 2009-07-29
%%
Type: language
Subtag: kvm
Description: Kendem
Added: 2009-07-29
%%
Type: language
Subtag: kvn
Description: Border Kuna
Added: 2009-07-29
%%
Type: language
Subtag: kvo
Description: Dobel
Added: 2009-07-29
%%
Type: language
Subtag: kvp
Description: Kompane
Added: 2009-07-29
%%
Type: language
Subtag: kvq
Description: Geba Karen
Added: 2009-07-29
%%
Type: language
Subtag: kvr
Description: Kerinci
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: kvs
Description: Kunggara
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: gdj
%%
Type: language
Subtag: kvt
Description: Lahta Karen
Description: Lahta
Added: 2009-07-29
%%
Type: language
Subtag: kvu
Description: Yinbaw Karen
Added: 2009-07-29
%%
Type: language
Subtag: kvv
Description: Kola
Added: 2009-07-29
%%
Type: language
Subtag: kvw
Description: Wersing
Added: 2009-07-29
%%
Type: language
Subtag: kvx
Description: Parkari Koli
Added: 2009-07-29
%%
Type: language
Subtag: kvy
Description: Yintale Karen
Description: Yintale
Added: 2009-07-29
%%
Type: language
Subtag: kvz
Description: Tsakwambo
Description: Tsaukambo
Added: 2009-07-29
%%
Type: language
Subtag: kwa
Description: Dâw
Added: 2009-07-29
%%
Type: language
Subtag: kwb
Description: Kwa
Added: 2009-07-29
%%
Type: language
Subtag: kwc
Description: Likwala
Added: 2009-07-29
%%
Type: language
Subtag: kwd
Description: Kwaio
Added: 2009-07-29
%%
Type: language
Subtag: kwe
Description: Kwerba
Added: 2009-07-29
%%
Type: language
Subtag: kwf
Description: Kwara'ae
Added: 2009-07-29
%%
Type: language
Subtag: kwg
Description: Sara Kaba Deme
Added: 2009-07-29
%%
Type: language
Subtag: kwh
Description: Kowiai
Added: 2009-07-29
%%
Type: language
Subtag: kwi
Description: Awa-Cuaiquer
Added: 2009-07-29
%%
Type: language
Subtag: kwj
Description: Kwanga
Added: 2009-07-29
%%
Type: language
Subtag: kwk
Description: Kwakiutl
Added: 2009-07-29
%%
Type: language
Subtag: kwl
Description: Kofyar
Added: 2009-07-29
%%
Type: language
Subtag: kwm
Description: Kwambi
Added: 2009-07-29
%%
Type: language
Subtag: kwn
Description: Kwangali
Added: 2009-07-29
%%
Type: language
Subtag: kwo
Description: Kwomtari
Added: 2009-07-29
%%
Type: language
Subtag: kwp
Description: Kodia
Added: 2009-07-29
%%
Type: language
Subtag: kwq
Description: Kwak
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: yam
%%
Type: language
Subtag: kwr
Description: Kwer
Added: 2009-07-29
%%
Type: language
Subtag: kws
Description: Kwese
Added: 2009-07-29
%%
Type: language
Subtag: kwt
Description: Kwesten
Added: 2009-07-29
%%
Type: language
Subtag: kwu
Description: Kwakum
Added: 2009-07-29
%%
Type: language
Subtag: kwv
Description: Sara Kaba Náà
Added: 2009-07-29
%%
Type: language
Subtag: kww
Description: Kwinti
Added: 2009-07-29
%%
Type: language
Subtag: kwx
Description: Khirwar
Added: 2009-07-29
%%
Type: language
Subtag: kwy
Description: San Salvador Kongo
Added: 2009-07-29
Macrolanguage: kg
%%
Type: language
Subtag: kwz
Description: Kwadi
Added: 2009-07-29
%%
Type: language
Subtag: kxa
Description: Kairiru
Added: 2009-07-29
%%
Type: language
Subtag: kxb
Description: Krobu
Added: 2009-07-29
%%
Type: language
Subtag: kxc
Description: Konso
Description: Khonso
Added: 2009-07-29
%%
Type: language
Subtag: kxd
Description: Brunei
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: kxe
Description: Kakihum
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: tvd
%%
Type: language
Subtag: kxf
Description: Manumanaw Karen
Description: Manumanaw
Added: 2009-07-29
%%
Type: language
Subtag: kxh
Description: Karo (Ethiopia)
Added: 2009-07-29
%%
Type: language
Subtag: kxi
Description: Keningau Murut
Added: 2009-07-29
%%
Type: language
Subtag: kxj
Description: Kulfa
Added: 2009-07-29
%%
Type: language
Subtag: kxk
Description: Zayein Karen
Added: 2009-07-29
%%
Type: language
Subtag: kxl
Description: Nepali Kurux
Added: 2009-07-29
%%
Type: language
Subtag: kxm
Description: Northern Khmer
Added: 2009-07-29
%%
Type: language
Subtag: kxn
Description: Kanowit-Tanjong Melanau
Added: 2009-07-29
%%
Type: language
Subtag: kxo
Description: Kanoé
Added: 2009-07-29
%%
Type: language
Subtag: kxp
Description: Wadiyara Koli
Added: 2009-07-29
%%
Type: language
Subtag: kxq
Description: Smärky Kanum
Added: 2009-07-29
%%
Type: language
Subtag: kxr
Description: Koro (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: kxs
Description: Kangjia
Added: 2009-07-29
%%
Type: language
Subtag: kxt
Description: Koiwat
Added: 2009-07-29
%%
Type: language
Subtag: kxu
Description: Kui (India)
Added: 2009-07-29
%%
Type: language
Subtag: kxv
Description: Kuvi
Added: 2009-07-29
%%
Type: language
Subtag: kxw
Description: Konai
Added: 2009-07-29
%%
Type: language
Subtag: kxx
Description: Likuba
Added: 2009-07-29
%%
Type: language
Subtag: kxy
Description: Kayong
Added: 2009-07-29
%%
Type: language
Subtag: kxz
Description: Kerewo
Added: 2009-07-29
%%
Type: language
Subtag: kya
Description: Kwaya
Added: 2009-07-29
%%
Type: language
Subtag: kyb
Description: Butbut Kalinga
Added: 2009-07-29
%%
Type: language
Subtag: kyc
Description: Kyaka
Added: 2009-07-29
%%
Type: language
Subtag: kyd
Description: Karey
Added: 2009-07-29
%%
Type: language
Subtag: kye
Description: Krache
Added: 2009-07-29
%%
Type: language
Subtag: kyf
Description: Kouya
Added: 2009-07-29
%%
Type: language
Subtag: kyg
Description: Keyagana
Added: 2009-07-29
%%
Type: language
Subtag: kyh
Description: Karok
Added: 2009-07-29
%%
Type: language
Subtag: kyi
Description: Kiput
Added: 2009-07-29
%%
Type: language
Subtag: kyj
Description: Karao
Added: 2009-07-29
%%
Type: language
Subtag: kyk
Description: Kamayo
Added: 2009-07-29
%%
Type: language
Subtag: kyl
Description: Kalapuya
Added: 2009-07-29
%%
Type: language
Subtag: kym
Description: Kpatili
Added: 2009-07-29
%%
Type: language
Subtag: kyn
Description: Northern Binukidnon
Added: 2009-07-29
%%
Type: language
Subtag: kyo
Description: Kelon
Added: 2009-07-29
%%
Type: language
Subtag: kyp
Description: Kang
Added: 2009-07-29
%%
Type: language
Subtag: kyq
Description: Kenga
Added: 2009-07-29
%%
Type: language
Subtag: kyr
Description: Kuruáya
Added: 2009-07-29
%%
Type: language
Subtag: kys
Description: Baram Kayan
Added: 2009-07-29
%%
Type: language
Subtag: kyt
Description: Kayagar
Added: 2009-07-29
%%
Type: language
Subtag: kyu
Description: Western Kayah
Added: 2009-07-29
%%
Type: language
Subtag: kyv
Description: Kayort
Added: 2009-07-29
%%
Type: language
Subtag: kyw
Description: Kudmali
Added: 2009-07-29
%%
Type: language
Subtag: kyx
Description: Rapoisi
Added: 2009-07-29
%%
Type: language
Subtag: kyy
Description: Kambaira
Added: 2009-07-29
%%
Type: language
Subtag: kyz
Description: Kayabí
Added: 2009-07-29
%%
Type: language
Subtag: kza
Description: Western Karaboro
Added: 2009-07-29
%%
Type: language
Subtag: kzb
Description: Kaibobo
Added: 2009-07-29
%%
Type: language
Subtag: kzc
Description: Bondoukou Kulango
Added: 2009-07-29
%%
Type: language
Subtag: kzd
Description: Kadai
Added: 2009-07-29
%%
Type: language
Subtag: kze
Description: Kosena
Added: 2009-07-29
%%
Type: language
Subtag: kzf
Description: Da'a Kaili
Added: 2009-07-29
%%
Type: language
Subtag: kzg
Description: Kikai
Added: 2009-07-29
%%
Type: language
Subtag: kzh
Description: Kenuzi-Dongola
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see dgl, xnz
%%
Type: language
Subtag: kzi
Description: Kelabit
Added: 2009-07-29
%%
Type: language
Subtag: kzj
Description: Coastal Kadazan
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: dtp
%%
Type: language
Subtag: kzk
Description: Kazukuru
Added: 2009-07-29
%%
Type: language
Subtag: kzl
Description: Kayeli
Added: 2009-07-29
%%
Type: language
Subtag: kzm
Description: Kais
Added: 2009-07-29
%%
Type: language
Subtag: kzn
Description: Kokola
Added: 2009-07-29
%%
Type: language
Subtag: kzo
Description: Kaningi
Added: 2009-07-29
%%
Type: language
Subtag: kzp
Description: Kaidipang
Added: 2009-07-29
%%
Type: language
Subtag: kzq
Description: Kaike
Added: 2009-07-29
%%
Type: language
Subtag: kzr
Description: Karang
Added: 2009-07-29
%%
Type: language
Subtag: kzs
Description: Sugut Dusun
Added: 2009-07-29
%%
Type: language
Subtag: kzt
Description: Tambunan Dusun
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: dtp
%%
Type: language
Subtag: kzu
Description: Kayupulau
Added: 2009-07-29
%%
Type: language
Subtag: kzv
Description: Komyandaret
Added: 2009-07-29
%%
Type: language
Subtag: kzw
Description: Karirí-Xocó
Added: 2009-07-29
%%
Type: language
Subtag: kzx
Description: Kamarian
Added: 2009-07-29
%%
Type: language
Subtag: kzy
Description: Kango (Tshopo District)
Added: 2009-07-29
%%
Type: language
Subtag: kzz
Description: Kalabra
Added: 2009-07-29
%%
Type: language
Subtag: laa
Description: Southern Subanen
Added: 2009-07-29
%%
Type: language
Subtag: lab
Description: Linear A
Added: 2009-07-29
%%
Type: language
Subtag: lac
Description: Lacandon
Added: 2009-07-29
%%
Type: language
Subtag: lad
Description: Ladino
Added: 2005-10-16
%%
Type: language
Subtag: lae
Description: Pattani
Added: 2009-07-29
%%
Type: language
Subtag: laf
Description: Lafofa
Added: 2009-07-29
%%
Type: language
Subtag: lag
Description: Langi
Added: 2009-07-29
%%
Type: language
Subtag: lah
Description: Lahnda
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: lai
Description: Lambya
Added: 2009-07-29
%%
Type: language
Subtag: laj
Description: Lango (Uganda)
Added: 2009-07-29
%%
Type: language
Subtag: lak
Description: Laka (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: lal
Description: Lalia
Added: 2009-07-29
%%
Type: language
Subtag: lam
Description: Lamba
Added: 2005-10-16
%%
Type: language
Subtag: lan
Description: Laru
Added: 2009-07-29
%%
Type: language
Subtag: lap
Description: Laka (Chad)
Added: 2009-07-29
%%
Type: language
Subtag: laq
Description: Qabiao
Added: 2009-07-29
%%
Type: language
Subtag: lar
Description: Larteh
Added: 2009-07-29
%%
Type: language
Subtag: las
Description: Lama (Togo)
Added: 2009-07-29
%%
Type: language
Subtag: lau
Description: Laba
Added: 2009-07-29
%%
Type: language
Subtag: law
Description: Lauje
Added: 2009-07-29
%%
Type: language
Subtag: lax
Description: Tiwa
Added: 2009-07-29
%%
Type: language
Subtag: lay
Description: Lama Bai
Added: 2009-07-29
%%
Type: language
Subtag: laz
Description: Aribwatsa
Added: 2009-07-29
%%
Type: language
Subtag: lba
Description: Lui
Added: 2009-07-29
Deprecated: 2019-04-16
%%
Type: language
Subtag: lbb
Description: Label
Added: 2009-07-29
%%
Type: language
Subtag: lbc
Description: Lakkia
Added: 2009-07-29
%%
Type: language
Subtag: lbe
Description: Lak
Added: 2009-07-29
%%
Type: language
Subtag: lbf
Description: Tinani
Added: 2009-07-29
%%
Type: language
Subtag: lbg
Description: Laopang
Added: 2009-07-29
%%
Type: language
Subtag: lbi
Description: La'bi
Added: 2009-07-29
%%
Type: language
Subtag: lbj
Description: Ladakhi
Added: 2009-07-29
%%
Type: language
Subtag: lbk
Description: Central Bontok
Added: 2010-03-11
Macrolanguage: bnc
%%
Type: language
Subtag: lbl
Description: Libon Bikol
Added: 2010-03-11
Macrolanguage: bik
%%
Type: language
Subtag: lbm
Description: Lodhi
Added: 2009-07-29
%%
Type: language
Subtag: lbn
Description: Rmeet
Added: 2009-07-29
%%
Type: language
Subtag: lbo
Description: Laven
Added: 2009-07-29
%%
Type: language
Subtag: lbq
Description: Wampar
Added: 2009-07-29
%%
Type: language
Subtag: lbr
Description: Lohorung
Added: 2009-07-29
%%
Type: language
Subtag: lbs
Description: Libyan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: lbt
Description: Lachi
Added: 2009-07-29
%%
Type: language
Subtag: lbu
Description: Labu
Added: 2009-07-29
%%
Type: language
Subtag: lbv
Description: Lavatbura-Lamusong
Added: 2009-07-29
%%
Type: language
Subtag: lbw
Description: Tolaki
Added: 2009-07-29
%%
Type: language
Subtag: lbx
Description: Lawangan
Added: 2009-07-29
%%
Type: language
Subtag: lby
Description: Lamalama
Description: Lamu-Lamu
Added: 2009-07-29
%%
Type: language
Subtag: lbz
Description: Lardil
Added: 2009-07-29
%%
Type: language
Subtag: lcc
Description: Legenyem
Added: 2009-07-29
%%
Type: language
Subtag: lcd
Description: Lola
Added: 2009-07-29
%%
Type: language
Subtag: lce
Description: Loncong
Description: Sekak
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: lcf
Description: Lubu
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: lch
Description: Luchazi
Added: 2009-07-29
%%
Type: language
Subtag: lcl
Description: Lisela
Added: 2009-07-29
%%
Type: language
Subtag: lcm
Description: Tungag
Added: 2009-07-29
%%
Type: language
Subtag: lcp
Description: Western Lawa
Added: 2009-07-29
%%
Type: language
Subtag: lcq
Description: Luhu
Added: 2009-07-29
%%
Type: language
Subtag: lcs
Description: Lisabata-Nuniali
Added: 2009-07-29
%%
Type: language
Subtag: lda
Description: Kla-Dan
Added: 2013-09-10
%%
Type: language
Subtag: ldb
Description: Dũya
Added: 2009-07-29
%%
Type: language
Subtag: ldd
Description: Luri
Added: 2009-07-29
%%
Type: language
Subtag: ldg
Description: Lenyima
Added: 2009-07-29
%%
Type: language
Subtag: ldh
Description: Lamja-Dengsa-Tola
Added: 2009-07-29
%%
Type: language
Subtag: ldi
Description: Laari
Added: 2009-07-29
Macrolanguage: kg
%%
Type: language
Subtag: ldj
Description: Lemoro
Added: 2009-07-29
%%
Type: language
Subtag: ldk
Description: Leelau
Added: 2009-07-29
%%
Type: language
Subtag: ldl
Description: Kaan
Added: 2009-07-29
%%
Type: language
Subtag: ldm
Description: Landoma
Added: 2009-07-29
%%
Type: language
Subtag: ldn
Description: Láadan
Added: 2009-07-29
%%
Type: language
Subtag: ldo
Description: Loo
Added: 2009-07-29
%%
Type: language
Subtag: ldp
Description: Tso
Added: 2009-07-29
%%
Type: language
Subtag: ldq
Description: Lufu
Added: 2009-07-29
%%
Type: language
Subtag: lea
Description: Lega-Shabunda
Added: 2009-07-29
%%
Type: language
Subtag: leb
Description: Lala-Bisa
Added: 2009-07-29
%%
Type: language
Subtag: lec
Description: Leco
Added: 2009-07-29
%%
Type: language
Subtag: led
Description: Lendu
Added: 2009-07-29
%%
Type: language
Subtag: lee
Description: Lyélé
Added: 2009-07-29
%%
Type: language
Subtag: lef
Description: Lelemi
Added: 2009-07-29
%%
Type: language
Subtag: leg
Description: Lengua
Added: 2009-07-29
Deprecated: 2014-02-28
Comments: see enl, enx
%%
Type: language
Subtag: leh
Description: Lenje
Added: 2009-07-29
%%
Type: language
Subtag: lei
Description: Lemio
Added: 2009-07-29
%%
Type: language
Subtag: lej
Description: Lengola
Added: 2009-07-29
%%
Type: language
Subtag: lek
Description: Leipon
Added: 2009-07-29
%%
Type: language
Subtag: lel
Description: Lele (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: lem
Description: Nomaande
Added: 2009-07-29
%%
Type: language
Subtag: len
Description: Lenca
Added: 2009-07-29
%%
Type: language
Subtag: leo
Description: Leti (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: lep
Description: Lepcha
Added: 2009-07-29
%%
Type: language
Subtag: leq
Description: Lembena
Added: 2009-07-29
%%
Type: language
Subtag: ler
Description: Lenkau
Added: 2009-07-29
%%
Type: language
Subtag: les
Description: Lese
Added: 2009-07-29
%%
Type: language
Subtag: let
Description: Lesing-Gelimi
Description: Amio-Gelimi
Added: 2009-07-29
%%
Type: language
Subtag: leu
Description: Kara (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: lev
Description: Lamma
Added: 2009-07-29
%%
Type: language
Subtag: lew
Description: Ledo Kaili
Added: 2009-07-29
%%
Type: language
Subtag: lex
Description: Luang
Added: 2009-07-29
%%
Type: language
Subtag: ley
Description: Lemolang
Added: 2009-07-29
%%
Type: language
Subtag: lez
Description: Lezghian
Added: 2005-10-16
%%
Type: language
Subtag: lfa
Description: Lefa
Added: 2009-07-29
%%
Type: language
Subtag: lfn
Description: Lingua Franca Nova
Added: 2009-07-29
%%
Type: language
Subtag: lga
Description: Lungga
Added: 2009-07-29
%%
Type: language
Subtag: lgb
Description: Laghu
Added: 2009-07-29
%%
Type: language
Subtag: lgg
Description: Lugbara
Added: 2009-07-29
%%
Type: language
Subtag: lgh
Description: Laghuu
Added: 2009-07-29
%%
Type: language
Subtag: lgi
Description: Lengilu
Added: 2009-07-29
%%
Type: language
Subtag: lgk
Description: Lingarak
Description: Neverver
Added: 2009-07-29
%%
Type: language
Subtag: lgl
Description: Wala
Added: 2009-07-29
%%
Type: language
Subtag: lgm
Description: Lega-Mwenga
Added: 2009-07-29
%%
Type: language
Subtag: lgn
Description: T'apo
Description: Opuuo
Added: 2009-07-29
%%
Type: language
Subtag: lgq
Description: Logba
Added: 2009-07-29
%%
Type: language
Subtag: lgr
Description: Lengo
Added: 2009-07-29
%%
Type: language
Subtag: lgt
Description: Pahi
Added: 2009-07-29
%%
Type: language
Subtag: lgu
Description: Longgu
Added: 2009-07-29
%%
Type: language
Subtag: lgz
Description: Ligenza
Added: 2009-07-29
%%
Type: language
Subtag: lha
Description: Laha (Viet Nam)
Added: 2009-07-29
%%
Type: language
Subtag: lhh
Description: Laha (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: lhi
Description: Lahu Shi
Added: 2009-07-29
%%
Type: language
Subtag: lhl
Description: Lahul Lohar
Added: 2009-07-29
%%
Type: language
Subtag: lhm
Description: Lhomi
Added: 2009-07-29
%%
Type: language
Subtag: lhn
Description: Lahanan
Added: 2009-07-29
%%
Type: language
Subtag: lhp
Description: Lhokpu
Added: 2009-07-29
%%
Type: language
Subtag: lhs
Description: Mlahsö
Added: 2009-07-29
%%
Type: language
Subtag: lht
Description: Lo-Toga
Added: 2009-07-29
%%
Type: language
Subtag: lhu
Description: Lahu
Added: 2009-07-29
%%
Type: language
Subtag: lia
Description: West-Central Limba
Added: 2009-07-29
%%
Type: language
Subtag: lib
Description: Likum
Added: 2009-07-29
%%
Type: language
Subtag: lic
Description: Hlai
Added: 2009-07-29
%%
Type: language
Subtag: lid
Description: Nyindrou
Added: 2009-07-29
%%
Type: language
Subtag: lie
Description: Likila
Added: 2009-07-29
%%
Type: language
Subtag: lif
Description: Limbu
Added: 2009-07-29
%%
Type: language
Subtag: lig
Description: Ligbi
Added: 2009-07-29
%%
Type: language
Subtag: lih
Description: Lihir
Added: 2009-07-29
%%
Type: language
Subtag: lii
Description: Lingkhim
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: raq
%%
Type: language
Subtag: lij
Description: Ligurian
Added: 2009-07-29
%%
Type: language
Subtag: lik
Description: Lika
Added: 2009-07-29
%%
Type: language
Subtag: lil
Description: Lillooet
Added: 2009-07-29
%%
Type: language
Subtag: lio
Description: Liki
Added: 2009-07-29
%%
Type: language
Subtag: lip
Description: Sekpele
Added: 2009-07-29
%%
Type: language
Subtag: liq
Description: Libido
Added: 2009-07-29
%%
Type: language
Subtag: lir
Description: Liberian English
Added: 2009-07-29
%%
Type: language
Subtag: lis
Description: Lisu
Added: 2009-07-29
%%
Type: language
Subtag: liu
Description: Logorik
Added: 2009-07-29
%%
Type: language
Subtag: liv
Description: Liv
Added: 2009-07-29
%%
Type: language
Subtag: liw
Description: Col
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: lix
Description: Liabuku
Added: 2009-07-29
%%
Type: language
Subtag: liy
Description: Banda-Bambari
Added: 2009-07-29
%%
Type: language
Subtag: liz
Description: Libinza
Added: 2009-07-29
%%
Type: language
Subtag: lja
Description: Golpa
Added: 2013-09-10
%%
Type: language
Subtag: lje
Description: Rampi
Added: 2009-07-29
%%
Type: language
Subtag: lji
Description: Laiyolo
Added: 2009-07-29
%%
Type: language
Subtag: ljl
Description: Li'o
Added: 2009-07-29
%%
Type: language
Subtag: ljp
Description: Lampung Api
Added: 2009-07-29
%%
Type: language
Subtag: ljw
Description: Yirandali
Added: 2013-09-10
%%
Type: language
Subtag: ljx
Description: Yuru
Added: 2013-09-10
%%
Type: language
Subtag: lka
Description: Lakalei
Added: 2009-07-29
%%
Type: language
Subtag: lkb
Description: Kabras
Description: Lukabaras
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: lkc
Description: Kucong
Added: 2009-07-29
%%
Type: language
Subtag: lkd
Description: Lakondê
Added: 2009-07-29
%%
Type: language
Subtag: lke
Description: Kenyi
Added: 2009-07-29
%%
Type: language
Subtag: lkh
Description: Lakha
Added: 2009-07-29
%%
Type: language
Subtag: lki
Description: Laki
Added: 2009-07-29
%%
Type: language
Subtag: lkj
Description: Remun
Added: 2009-07-29
%%
Type: language
Subtag: lkl
Description: Laeko-Libuat
Added: 2009-07-29
%%
Type: language
Subtag: lkm
Description: Kalaamaya
Added: 2013-09-10
%%
Type: language
Subtag: lkn
Description: Lakon
Description: Vure
Added: 2009-07-29
%%
Type: language
Subtag: lko
Description: Khayo
Description: Olukhayo
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: lkr
Description: Päri
Added: 2009-07-29
%%
Type: language
Subtag: lks
Description: Kisa
Description: Olushisa
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: lkt
Description: Lakota
Added: 2009-07-29
%%
Type: language
Subtag: lku
Description: Kungkari
Added: 2013-09-10
%%
Type: language
Subtag: lky
Description: Lokoya
Added: 2009-07-29
%%
Type: language
Subtag: lla
Description: Lala-Roba
Added: 2009-07-29
%%
Type: language
Subtag: llb
Description: Lolo
Added: 2009-07-29
%%
Type: language
Subtag: llc
Description: Lele (Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: lld
Description: Ladin
Added: 2009-07-29
%%
Type: language
Subtag: lle
Description: Lele (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: llf
Description: Hermit
Added: 2009-07-29
%%
Type: language
Subtag: llg
Description: Lole
Added: 2009-07-29
%%
Type: language
Subtag: llh
Description: Lamu
Added: 2009-07-29
%%
Type: language
Subtag: lli
Description: Teke-Laali
Added: 2009-07-29
%%
Type: language
Subtag: llj
Description: Ladji Ladji
Added: 2012-08-12
%%
Type: language
Subtag: llk
Description: Lelak
Added: 2009-07-29
%%
Type: language
Subtag: lll
Description: Lilau
Added: 2009-07-29
%%
Type: language
Subtag: llm
Description: Lasalimu
Added: 2009-07-29
%%
Type: language
Subtag: lln
Description: Lele (Chad)
Added: 2009-07-29
%%
Type: language
Subtag: llo
Description: Khlor
Added: 2009-07-29
Deprecated: 2019-04-16
Preferred-Value: ngt
%%
Type: language
Subtag: llp
Description: North Efate
Added: 2009-07-29
%%
Type: language
Subtag: llq
Description: Lolak
Added: 2009-07-29
%%
Type: language
Subtag: lls
Description: Lithuanian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: llu
Description: Lau
Added: 2009-07-29
%%
Type: language
Subtag: llx
Description: Lauan
Added: 2009-07-29
%%
Type: language
Subtag: lma
Description: East Limba
Added: 2009-07-29
%%
Type: language
Subtag: lmb
Description: Merei
Added: 2009-07-29
%%
Type: language
Subtag: lmc
Description: Limilngan
Added: 2009-07-29
%%
Type: language
Subtag: lmd
Description: Lumun
Added: 2009-07-29
%%
Type: language
Subtag: lme
Description: Pévé
Added: 2009-07-29
%%
Type: language
Subtag: lmf
Description: South Lembata
Added: 2009-07-29
%%
Type: language
Subtag: lmg
Description: Lamogai
Added: 2009-07-29
%%
Type: language
Subtag: lmh
Description: Lambichhong
Added: 2009-07-29
%%
Type: language
Subtag: lmi
Description: Lombi
Added: 2009-07-29
%%
Type: language
Subtag: lmj
Description: West Lembata
Added: 2009-07-29
%%
Type: language
Subtag: lmk
Description: Lamkang
Added: 2009-07-29
%%
Type: language
Subtag: lml
Description: Hano
Added: 2009-07-29
%%
Type: language
Subtag: lmm
Description: Lamam
Added: 2009-07-29
Deprecated: 2014-02-28
Preferred-Value: rmx
%%
Type: language
Subtag: lmn
Description: Lambadi
Added: 2009-07-29
%%
Type: language
Subtag: lmo
Description: Lombard
Added: 2009-07-29
%%
Type: language
Subtag: lmp
Description: Limbum
Added: 2009-07-29
%%
Type: language
Subtag: lmq
Description: Lamatuka
Added: 2009-07-29
%%
Type: language
Subtag: lmr
Description: Lamalera
Added: 2009-07-29
%%
Type: language
Subtag: lmu
Description: Lamenu
Added: 2009-07-29
%%
Type: language
Subtag: lmv
Description: Lomaiviti
Added: 2009-07-29
%%
Type: language
Subtag: lmw
Description: Lake Miwok
Added: 2009-07-29
%%
Type: language
Subtag: lmx
Description: Laimbue
Added: 2009-07-29
%%
Type: language
Subtag: lmy
Description: Lamboya
Added: 2009-07-29
%%
Type: language
Subtag: lmz
Description: Lumbee
Added: 2009-07-29
%%
Type: language
Subtag: lna
Description: Langbashe
Added: 2009-07-29
%%
Type: language
Subtag: lnb
Description: Mbalanhu
Added: 2009-07-29
%%
Type: language
Subtag: lnd
Description: Lundayeh
Description: Lun Bawang
Added: 2009-07-29
%%
Type: language
Subtag: lng
Description: Langobardic
Added: 2009-07-29
%%
Type: language
Subtag: lnh
Description: Lanoh
Added: 2009-07-29
%%
Type: language
Subtag: lni
Description: Daantanai'
Added: 2009-07-29
%%
Type: language
Subtag: lnj
Description: Leningitij
Added: 2009-07-29
%%
Type: language
Subtag: lnl
Description: South Central Banda
Added: 2009-07-29
%%
Type: language
Subtag: lnm
Description: Langam
Added: 2009-07-29
%%
Type: language
Subtag: lnn
Description: Lorediakarkar
Added: 2009-07-29
%%
Type: language
Subtag: lno
Description: Lango (South Sudan)
Added: 2009-07-29
%%
Type: language
Subtag: lns
Description: Lamnso'
Added: 2009-07-29
%%
Type: language
Subtag: lnu
Description: Longuda
Added: 2009-07-29
%%
Type: language
Subtag: lnw
Description: Lanima
Added: 2013-09-10
%%
Type: language
Subtag: lnz
Description: Lonzo
Added: 2009-07-29
%%
Type: language
Subtag: loa
Description: Loloda
Added: 2009-07-29
%%
Type: language
Subtag: lob
Description: Lobi
Added: 2009-07-29
%%
Type: language
Subtag: loc
Description: Inonhan
Added: 2009-07-29
%%
Type: language
Subtag: loe
Description: Saluan
Added: 2009-07-29
%%
Type: language
Subtag: lof
Description: Logol
Added: 2009-07-29
%%
Type: language
Subtag: log
Description: Logo
Added: 2009-07-29
%%
Type: language
Subtag: loh
Description: Narim
Added: 2009-07-29
%%
Type: language
Subtag: loi
Description: Loma (Côte d'Ivoire)
Added: 2009-07-29
%%
Type: language
Subtag: loj
Description: Lou
Added: 2009-07-29
%%
Type: language
Subtag: lok
Description: Loko
Added: 2009-07-29
%%
Type: language
Subtag: lol
Description: Mongo
Added: 2005-10-16
%%
Type: language
Subtag: lom
Description: Loma (Liberia)
Added: 2009-07-29
%%
Type: language
Subtag: lon
Description: Malawi Lomwe
Added: 2009-07-29
%%
Type: language
Subtag: loo
Description: Lombo
Added: 2009-07-29
%%
Type: language
Subtag: lop
Description: Lopa
Added: 2009-07-29
%%
Type: language
Subtag: loq
Description: Lobala
Added: 2009-07-29
%%
Type: language
Subtag: lor
Description: Téén
Added: 2009-07-29
%%
Type: language
Subtag: los
Description: Loniu
Added: 2009-07-29
%%
Type: language
Subtag: lot
Description: Otuho
Added: 2009-07-29
%%
Type: language
Subtag: lou
Description: Louisiana Creole
Added: 2009-07-29
%%
Type: language
Subtag: lov
Description: Lopi
Added: 2009-07-29
%%
Type: language
Subtag: low
Description: Tampias Lobu
Added: 2009-07-29
%%
Type: language
Subtag: lox
Description: Loun
Added: 2009-07-29
%%
Type: language
Subtag: loy
Description: Loke
Added: 2009-07-29
%%
Type: language
Subtag: loz
Description: Lozi
Added: 2005-10-16
%%
Type: language
Subtag: lpa
Description: Lelepa
Added: 2009-07-29
%%
Type: language
Subtag: lpe
Description: Lepki
Added: 2009-07-29
%%
Type: language
Subtag: lpn
Description: Long Phuri Naga
Added: 2009-07-29
%%
Type: language
Subtag: lpo
Description: Lipo
Added: 2009-07-29
%%
Type: language
Subtag: lpx
Description: Lopit
Added: 2009-07-29
%%
Type: language
Subtag: lra
Description: Rara Bakati'
Added: 2009-07-29
%%
Type: language
Subtag: lrc
Description: Northern Luri
Added: 2009-07-29
%%
Type: language
Subtag: lre
Description: Laurentian
Added: 2009-07-29
%%
Type: language
Subtag: lrg
Description: Laragia
Added: 2009-07-29
%%
Type: language
Subtag: lri
Description: Marachi
Description: Olumarachi
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: lrk
Description: Loarki
Added: 2009-07-29
%%
Type: language
Subtag: lrl
Description: Lari
Added: 2009-07-29
%%
Type: language
Subtag: lrm
Description: Marama
Description: Olumarama
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: lrn
Description: Lorang
Added: 2009-07-29
%%
Type: language
Subtag: lro
Description: Laro
Added: 2009-07-29
%%
Type: language
Subtag: lrr
Description: Southern Yamphu
Added: 2009-07-29
%%
Type: language
Subtag: lrt
Description: Larantuka Malay
Added: 2009-07-29
%%
Type: language
Subtag: lrv
Description: Larevat
Added: 2009-07-29
%%
Type: language
Subtag: lrz
Description: Lemerig
Added: 2009-07-29
%%
Type: language
Subtag: lsa
Description: Lasgerdi
Added: 2009-07-29
%%
Type: language
Subtag: lsd
Description: Lishana Deni
Added: 2009-07-29
%%
Type: language
Subtag: lse
Description: Lusengo
Added: 2009-07-29
%%
Type: language
Subtag: lsg
Description: Lyons Sign Language
Added: 2009-07-29
Deprecated: 2018-03-08
%%
Type: language
Subtag: lsh
Description: Lish
Added: 2009-07-29
%%
Type: language
Subtag: lsi
Description: Lashi
Added: 2009-07-29
%%
Type: language
Subtag: lsl
Description: Latvian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: lsm
Description: Saamia
Description: Olusamia
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: lsn
Description: Tibetan Sign Language
Added: 2019-04-16
%%
Type: language
Subtag: lso
Description: Laos Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: lsp
Description: Panamanian Sign Language
Description: Lengua de Señas Panameñas
Added: 2009-07-29
%%
Type: language
Subtag: lsr
Description: Aruop
Added: 2009-07-29
%%
Type: language
Subtag: lss
Description: Lasi
Added: 2009-07-29
%%
Type: language
Subtag: lst
Description: Trinidad and Tobago Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: lsv
Description: Sivia Sign Language
Added: 2019-04-16
%%
Type: language
Subtag: lsy
Description: Mauritian Sign Language
Added: 2010-03-11
%%
Type: language
Subtag: ltc
Description: Late Middle Chinese
Added: 2009-07-29
%%
Type: language
Subtag: ltg
Description: Latgalian
Added: 2010-03-11
Macrolanguage: lv
%%
Type: language
Subtag: lth
Description: Thur
Added: 2017-02-23
%%
Type: language
Subtag: lti
Description: Leti (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: ltn
Description: Latundê
Added: 2009-07-29
%%
Type: language
Subtag: lto
Description: Tsotso
Description: Olutsotso
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: lts
Description: Tachoni
Description: Lutachoni
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: ltu
Description: Latu
Added: 2009-07-29
%%
Type: language
Subtag: lua
Description: Luba-Lulua
Added: 2005-10-16
%%
Type: language
Subtag: luc
Description: Aringa
Added: 2009-07-29
%%
Type: language
Subtag: lud
Description: Ludian
Added: 2009-07-29
%%
Type: language
Subtag: lue
Description: Luvale
Added: 2009-07-29
%%
Type: language
Subtag: luf
Description: Laua
Added: 2009-07-29
%%
Type: language
Subtag: lui
Description: Luiseno
Added: 2005-10-16
%%
Type: language
Subtag: luj
Description: Luna
Added: 2009-07-29
%%
Type: language
Subtag: luk
Description: Lunanakha
Added: 2009-07-29
%%
Type: language
Subtag: lul
Description: Olu'bo
Added: 2009-07-29
%%
Type: language
Subtag: lum
Description: Luimbi
Added: 2009-07-29
%%
Type: language
Subtag: lun
Description: Lunda
Added: 2005-10-16
%%
Type: language
Subtag: luo
Description: Luo (Kenya and Tanzania)
Description: Dholuo
Added: 2005-10-16
%%
Type: language
Subtag: lup
Description: Lumbu
Added: 2009-07-29
%%
Type: language
Subtag: luq
Description: Lucumi
Added: 2009-07-29
%%
Type: language
Subtag: lur
Description: Laura
Added: 2009-07-29
%%
Type: language
Subtag: lus
Description: Lushai
Added: 2005-10-16
%%
Type: language
Subtag: lut
Description: Lushootseed
Added: 2009-07-29
%%
Type: language
Subtag: luu
Description: Lumba-Yakkha
Added: 2009-07-29
%%
Type: language
Subtag: luv
Description: Luwati
Added: 2009-07-29
%%
Type: language
Subtag: luw
Description: Luo (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: luy
Description: Luyia
Description: Oluluyia
Added: 2009-07-29
Scope: macrolanguage
%%
Type: language
Subtag: luz
Description: Southern Luri
Added: 2009-07-29
%%
Type: language
Subtag: lva
Description: Maku'a
Added: 2009-07-29
%%
Type: language
Subtag: lvi
Description: Lavi
Added: 2019-04-16
%%
Type: language
Subtag: lvk
Description: Lavukaleve
Added: 2009-07-29
%%
Type: language
Subtag: lvs
Description: Standard Latvian
Added: 2010-03-11
Macrolanguage: lv
%%
Type: language
Subtag: lvu
Description: Levuka
Added: 2009-07-29
%%
Type: language
Subtag: lwa
Description: Lwalu
Added: 2009-07-29
%%
Type: language
Subtag: lwe
Description: Lewo Eleng
Added: 2009-07-29
%%
Type: language
Subtag: lwg
Description: Wanga
Description: Oluwanga
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: lwh
Description: White Lachi
Added: 2009-07-29
%%
Type: language
Subtag: lwl
Description: Eastern Lawa
Added: 2009-07-29
%%
Type: language
Subtag: lwm
Description: Laomian
Added: 2009-07-29
%%
Type: language
Subtag: lwo
Description: Luwo
Added: 2009-07-29
%%
Type: language
Subtag: lws
Description: Malawian Sign Language
Added: 2018-03-08
%%
Type: language
Subtag: lwt
Description: Lewotobi
Added: 2009-07-29
%%
Type: language
Subtag: lwu
Description: Lawu
Added: 2013-09-10
%%
Type: language
Subtag: lww
Description: Lewo
Added: 2009-07-29
%%
Type: language
Subtag: lya
Description: Layakha
Added: 2009-07-29
%%
Type: language
Subtag: lyg
Description: Lyngngam
Added: 2009-07-29
%%
Type: language
Subtag: lyn
Description: Luyana
Added: 2009-07-29
%%
Type: language
Subtag: lzh
Description: Literary Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: lzl
Description: Litzlitz
Added: 2009-07-29
%%
Type: language
Subtag: lzn
Description: Leinong Naga
Added: 2009-07-29
%%
Type: language
Subtag: lzz
Description: Laz
Added: 2009-07-29
%%
Type: language
Subtag: maa
Description: San Jerónimo Tecóatl Mazatec
Added: 2009-07-29
Comments: see also pbm
%%
Type: language
Subtag: mab
Description: Yutanduchi Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mad
Description: Madurese
Added: 2005-10-16
%%
Type: language
Subtag: mae
Description: Bo-Rukul
Added: 2009-07-29
%%
Type: language
Subtag: maf
Description: Mafa
Added: 2009-07-29
%%
Type: language
Subtag: mag
Description: Magahi
Added: 2005-10-16
%%
Type: language
Subtag: mai
Description: Maithili
Added: 2005-10-16
Suppress-Script: Deva
%%
Type: language
Subtag: maj
Description: Jalapa De Díaz Mazatec
Added: 2009-07-29
%%
Type: language
Subtag: mak
Description: Makasar
Added: 2005-10-16
%%
Type: language
Subtag: mam
Description: Mam
Added: 2009-07-29
%%
Type: language
Subtag: man
Description: Mandingo
Description: Manding
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: map
Description: Austronesian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: maq
Description: Chiquihuitlán Mazatec
Added: 2009-07-29
%%
Type: language
Subtag: mas
Description: Masai
Added: 2005-10-16
%%
Type: language
Subtag: mat
Description: San Francisco Matlatzinca
Added: 2009-07-29
%%
Type: language
Subtag: mau
Description: Huautla Mazatec
Added: 2009-07-29
%%
Type: language
Subtag: mav
Description: Sateré-Mawé
Added: 2009-07-29
%%
Type: language
Subtag: maw
Description: Mampruli
Added: 2009-07-29
%%
Type: language
Subtag: max
Description: North Moluccan Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: maz
Description: Central Mazahua
Added: 2009-07-29
%%
Type: language
Subtag: mba
Description: Higaonon
Added: 2009-07-29
%%
Type: language
Subtag: mbb
Description: Western Bukidnon Manobo
Added: 2009-07-29
%%
Type: language
Subtag: mbc
Description: Macushi
Added: 2009-07-29
%%
Type: language
Subtag: mbd
Description: Dibabawon Manobo
Added: 2009-07-29
%%
Type: language
Subtag: mbe
Description: Molale
Added: 2009-07-29
%%
Type: language
Subtag: mbf
Description: Baba Malay
Added: 2009-07-29
%%
Type: language
Subtag: mbh
Description: Mangseng
Added: 2009-07-29
%%
Type: language
Subtag: mbi
Description: Ilianen Manobo
Added: 2009-07-29
%%
Type: language
Subtag: mbj
Description: Nadëb
Added: 2009-07-29
%%
Type: language
Subtag: mbk
Description: Malol
Added: 2009-07-29
%%
Type: language
Subtag: mbl
Description: Maxakalí
Added: 2009-07-29
%%
Type: language
Subtag: mbm
Description: Ombamba
Added: 2009-07-29
%%
Type: language
Subtag: mbn
Description: Macaguán
Added: 2009-07-29
%%
Type: language
Subtag: mbo
Description: Mbo (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: mbp
Description: Malayo
Added: 2009-07-29
%%
Type: language
Subtag: mbq
Description: Maisin
Added: 2009-07-29
%%
Type: language
Subtag: mbr
Description: Nukak Makú
Added: 2009-07-29
%%
Type: language
Subtag: mbs
Description: Sarangani Manobo
Added: 2009-07-29
%%
Type: language
Subtag: mbt
Description: Matigsalug Manobo
Added: 2009-07-29
%%
Type: language
Subtag: mbu
Description: Mbula-Bwazza
Added: 2009-07-29
%%
Type: language
Subtag: mbv
Description: Mbulungish
Added: 2009-07-29
%%
Type: language
Subtag: mbw
Description: Maring
Added: 2009-07-29
%%
Type: language
Subtag: mbx
Description: Mari (East Sepik Province)
Added: 2009-07-29
%%
Type: language
Subtag: mby
Description: Memoni
Added: 2009-07-29
%%
Type: language
Subtag: mbz
Description: Amoltepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mca
Description: Maca
Added: 2009-07-29
%%
Type: language
Subtag: mcb
Description: Machiguenga
Added: 2009-07-29
%%
Type: language
Subtag: mcc
Description: Bitur
Added: 2009-07-29
%%
Type: language
Subtag: mcd
Description: Sharanahua
Added: 2009-07-29
%%
Type: language
Subtag: mce
Description: Itundujia Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mcf
Description: Matsés
Added: 2009-07-29
%%
Type: language
Subtag: mcg
Description: Mapoyo
Added: 2009-07-29
%%
Type: language
Subtag: mch
Description: Maquiritari
Added: 2009-07-29
%%
Type: language
Subtag: mci
Description: Mese
Added: 2009-07-29
%%
Type: language
Subtag: mcj
Description: Mvanip
Added: 2009-07-29
%%
Type: language
Subtag: mck
Description: Mbunda
Added: 2009-07-29
%%
Type: language
Subtag: mcl
Description: Macaguaje
Added: 2009-07-29
%%
Type: language
Subtag: mcm
Description: Malaccan Creole Portuguese
Added: 2009-07-29
%%
Type: language
Subtag: mcn
Description: Masana
Added: 2009-07-29
%%
Type: language
Subtag: mco
Description: Coatlán Mixe
Added: 2009-07-29
%%
Type: language
Subtag: mcp
Description: Makaa
Added: 2009-07-29
%%
Type: language
Subtag: mcq
Description: Ese
Added: 2009-07-29
%%
Type: language
Subtag: mcr
Description: Menya
Added: 2009-07-29
%%
Type: language
Subtag: mcs
Description: Mambai
Added: 2009-07-29
%%
Type: language
Subtag: mct
Description: Mengisa
Added: 2009-07-29
%%
Type: language
Subtag: mcu
Description: Cameroon Mambila
Added: 2009-07-29
%%
Type: language
Subtag: mcv
Description: Minanibai
Added: 2009-07-29
%%
Type: language
Subtag: mcw
Description: Mawa (Chad)
Added: 2009-07-29
%%
Type: language
Subtag: mcx
Description: Mpiemo
Added: 2009-07-29
%%
Type: language
Subtag: mcy
Description: South Watut
Added: 2009-07-29
%%
Type: language
Subtag: mcz
Description: Mawan
Added: 2009-07-29
%%
Type: language
Subtag: mda
Description: Mada (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: mdb
Description: Morigi
Added: 2009-07-29
%%
Type: language
Subtag: mdc
Description: Male (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: mdd
Description: Mbum
Added: 2009-07-29
%%
Type: language
Subtag: mde
Description: Maba (Chad)
Added: 2009-07-29
%%
Type: language
Subtag: mdf
Description: Moksha
Added: 2005-10-16
%%
Type: language
Subtag: mdg
Description: Massalat
Added: 2009-07-29
%%
Type: language
Subtag: mdh
Description: Maguindanaon
Added: 2009-07-29
%%
Type: language
Subtag: mdi
Description: Mamvu
Added: 2009-07-29
%%
Type: language
Subtag: mdj
Description: Mangbetu
Added: 2009-07-29
%%
Type: language
Subtag: mdk
Description: Mangbutu
Added: 2009-07-29
%%
Type: language
Subtag: mdl
Description: Maltese Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: mdm
Description: Mayogo
Added: 2009-07-29
%%
Type: language
Subtag: mdn
Description: Mbati
Added: 2009-07-29
%%
Type: language
Subtag: mdp
Description: Mbala
Added: 2009-07-29
%%
Type: language
Subtag: mdq
Description: Mbole
Added: 2009-07-29
%%
Type: language
Subtag: mdr
Description: Mandar
Added: 2005-10-16
%%
Type: language
Subtag: mds
Description: Maria (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: mdt
Description: Mbere
Added: 2009-07-29
%%
Type: language
Subtag: mdu
Description: Mboko
Added: 2009-07-29
%%
Type: language
Subtag: mdv
Description: Santa Lucía Monteverde Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mdw
Description: Mbosi
Added: 2009-07-29
%%
Type: language
Subtag: mdx
Description: Dizin
Added: 2009-07-29
%%
Type: language
Subtag: mdy
Description: Male (Ethiopia)
Added: 2009-07-29
%%
Type: language
Subtag: mdz
Description: Suruí Do Pará
Added: 2009-07-29
%%
Type: language
Subtag: mea
Description: Menka
Added: 2009-07-29
%%
Type: language
Subtag: meb
Description: Ikobi
Added: 2009-07-29
%%
Type: language
Subtag: mec
Description: Marra
Added: 2009-07-29
%%
Type: language
Subtag: med
Description: Melpa
Added: 2009-07-29
%%
Type: language
Subtag: mee
Description: Mengen
Added: 2009-07-29
%%
Type: language
Subtag: mef
Description: Megam
Added: 2009-07-29
%%
Type: language
Subtag: meg
Description: Mea
Added: 2009-07-29
Deprecated: 2013-09-10
Preferred-Value: cir
%%
Type: language
Subtag: meh
Description: Southwestern Tlaxiaco Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mei
Description: Midob
Added: 2009-07-29
%%
Type: language
Subtag: mej
Description: Meyah
Added: 2009-07-29
%%
Type: language
Subtag: mek
Description: Mekeo
Added: 2009-07-29
%%
Type: language
Subtag: mel
Description: Central Melanau
Added: 2009-07-29
%%
Type: language
Subtag: mem
Description: Mangala
Added: 2009-07-29
%%
Type: language
Subtag: men
Description: Mende (Sierra Leone)
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: meo
Description: Kedah Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: mep
Description: Miriwoong
Added: 2009-07-29
%%
Type: language
Subtag: meq
Description: Merey
Added: 2009-07-29
%%
Type: language
Subtag: mer
Description: Meru
Added: 2009-07-29
%%
Type: language
Subtag: mes
Description: Masmaje
Added: 2009-07-29
%%
Type: language
Subtag: met
Description: Mato
Added: 2009-07-29
%%
Type: language
Subtag: meu
Description: Motu
Added: 2009-07-29
%%
Type: language
Subtag: mev
Description: Mano
Added: 2009-07-29
%%
Type: language
Subtag: mew
Description: Maaka
Added: 2009-07-29
%%
Type: language
Subtag: mey
Description: Hassaniyya
Added: 2009-07-29
%%
Type: language
Subtag: mez
Description: Menominee
Added: 2009-07-29
%%
Type: language
Subtag: mfa
Description: Pattani Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: mfb
Description: Bangka
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: mfc
Description: Mba
Added: 2009-07-29
%%
Type: language
Subtag: mfd
Description: Mendankwe-Nkwen
Added: 2009-07-29
%%
Type: language
Subtag: mfe
Description: Morisyen
Added: 2009-07-29
%%
Type: language
Subtag: mff
Description: Naki
Added: 2009-07-29
%%
Type: language
Subtag: mfg
Description: Mogofin
Added: 2009-07-29
%%
Type: language
Subtag: mfh
Description: Matal
Added: 2009-07-29
%%
Type: language
Subtag: mfi
Description: Wandala
Added: 2009-07-29
%%
Type: language
Subtag: mfj
Description: Mefele
Added: 2009-07-29
%%
Type: language
Subtag: mfk
Description: North Mofu
Added: 2009-07-29
%%
Type: language
Subtag: mfl
Description: Putai
Added: 2009-07-29
%%
Type: language
Subtag: mfm
Description: Marghi South
Added: 2009-07-29
%%
Type: language
Subtag: mfn
Description: Cross River Mbembe
Added: 2009-07-29
%%
Type: language
Subtag: mfo
Description: Mbe
Added: 2009-07-29
%%
Type: language
Subtag: mfp
Description: Makassar Malay
Added: 2009-07-29
%%
Type: language
Subtag: mfq
Description: Moba
Added: 2009-07-29
%%
Type: language
Subtag: mfr
Description: Marrithiyel
Added: 2009-07-29
%%
Type: language
Subtag: mfs
Description: Mexican Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: mft
Description: Mokerang
Added: 2009-07-29
%%
Type: language
Subtag: mfu
Description: Mbwela
Added: 2009-07-29
%%
Type: language
Subtag: mfv
Description: Mandjak
Added: 2009-07-29
%%
Type: language
Subtag: mfw
Description: Mulaha
Added: 2009-07-29
%%
Type: language
Subtag: mfx
Description: Melo
Added: 2009-07-29
%%
Type: language
Subtag: mfy
Description: Mayo
Added: 2009-07-29
%%
Type: language
Subtag: mfz
Description: Mabaan
Added: 2009-07-29
%%
Type: language
Subtag: mga
Description: Middle Irish (900-1200)
Added: 2005-10-16
%%
Type: language
Subtag: mgb
Description: Mararit
Added: 2009-07-29
%%
Type: language
Subtag: mgc
Description: Morokodo
Added: 2009-07-29
%%
Type: language
Subtag: mgd
Description: Moru
Added: 2009-07-29
%%
Type: language
Subtag: mge
Description: Mango
Added: 2009-07-29
%%
Type: language
Subtag: mgf
Description: Maklew
Added: 2009-07-29
%%
Type: language
Subtag: mgg
Description: Mpumpong
Added: 2009-07-29
%%
Type: language
Subtag: mgh
Description: Makhuwa-Meetto
Added: 2009-07-29
%%
Type: language
Subtag: mgi
Description: Lijili
Added: 2009-07-29
%%
Type: language
Subtag: mgj
Description: Abureni
Added: 2009-07-29
%%
Type: language
Subtag: mgk
Description: Mawes
Added: 2009-07-29
%%
Type: language
Subtag: mgl
Description: Maleu-Kilenge
Added: 2009-07-29
%%
Type: language
Subtag: mgm
Description: Mambae
Added: 2009-07-29
%%
Type: language
Subtag: mgn
Description: Mbangi
Added: 2009-07-29
%%
Type: language
Subtag: mgo
Description: Meta'
Added: 2009-07-29
%%
Type: language
Subtag: mgp
Description: Eastern Magar
Added: 2009-07-29
%%
Type: language
Subtag: mgq
Description: Malila
Added: 2009-07-29
%%
Type: language
Subtag: mgr
Description: Mambwe-Lungu
Added: 2009-07-29
%%
Type: language
Subtag: mgs
Description: Manda (Tanzania)
Added: 2009-07-29
%%
Type: language
Subtag: mgt
Description: Mongol
Added: 2009-07-29
%%
Type: language
Subtag: mgu
Description: Mailu
Added: 2009-07-29
%%
Type: language
Subtag: mgv
Description: Matengo
Added: 2009-07-29
%%
Type: language
Subtag: mgw
Description: Matumbi
Added: 2009-07-29
%%
Type: language
Subtag: mgx
Description: Omati
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see jbk, jmw
%%
Type: language
Subtag: mgy
Description: Mbunga
Added: 2009-07-29
%%
Type: language
Subtag: mgz
Description: Mbugwe
Added: 2009-07-29
%%
Type: language
Subtag: mha
Description: Manda (India)
Added: 2009-07-29
%%
Type: language
Subtag: mhb
Description: Mahongwe
Added: 2009-07-29
%%
Type: language
Subtag: mhc
Description: Mocho
Added: 2009-07-29
%%
Type: language
Subtag: mhd
Description: Mbugu
Added: 2009-07-29
%%
Type: language
Subtag: mhe
Description: Besisi
Description: Mah Meri
Added: 2009-07-29
%%
Type: language
Subtag: mhf
Description: Mamaa
Added: 2009-07-29
%%
Type: language
Subtag: mhg
Description: Margu
Added: 2009-07-29
%%
Type: language
Subtag: mhh
Description: Maskoy Pidgin
Added: 2009-07-29
Deprecated: 2014-02-28
%%
Type: language
Subtag: mhi
Description: Ma'di
Added: 2009-07-29
%%
Type: language
Subtag: mhj
Description: Mogholi
Added: 2009-07-29
%%
Type: language
Subtag: mhk
Description: Mungaka
Added: 2009-07-29
%%
Type: language
Subtag: mhl
Description: Mauwake
Added: 2009-07-29
%%
Type: language
Subtag: mhm
Description: Makhuwa-Moniga
Added: 2009-07-29
%%
Type: language
Subtag: mhn
Description: Mócheno
Added: 2009-07-29
%%
Type: language
Subtag: mho
Description: Mashi (Zambia)
Added: 2009-07-29
%%
Type: language
Subtag: mhp
Description: Balinese Malay
Added: 2009-07-29
%%
Type: language
Subtag: mhq
Description: Mandan
Added: 2009-07-29
%%
Type: language
Subtag: mhr
Description: Eastern Mari
Added: 2009-07-29
Macrolanguage: chm
%%
Type: language
Subtag: mhs
Description: Buru (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: mht
Description: Mandahuaca
Added: 2009-07-29
%%
Type: language
Subtag: mhu
Description: Digaro-Mishmi
Description: Darang Deng
Added: 2009-07-29
%%
Type: language
Subtag: mhw
Description: Mbukushu
Added: 2009-07-29
%%
Type: language
Subtag: mhx
Description: Maru
Description: Lhaovo
Added: 2009-07-29
%%
Type: language
Subtag: mhy
Description: Ma'anyan
Added: 2009-07-29
%%
Type: language
Subtag: mhz
Description: Mor (Mor Islands)
Added: 2009-07-29
%%
Type: language
Subtag: mia
Description: Miami
Added: 2009-07-29
%%
Type: language
Subtag: mib
Description: Atatláhuca Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mic
Description: Mi'kmaq
Description: Micmac
Added: 2005-10-16
%%
Type: language
Subtag: mid
Description: Mandaic
Added: 2009-07-29
%%
Type: language
Subtag: mie
Description: Ocotepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mif
Description: Mofu-Gudur
Added: 2009-07-29
%%
Type: language
Subtag: mig
Description: San Miguel El Grande Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mih
Description: Chayuco Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mii
Description: Chigmecatitlán Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mij
Description: Abar
Description: Mungbam
Added: 2009-07-29
%%
Type: language
Subtag: mik
Description: Mikasuki
Added: 2009-07-29
%%
Type: language
Subtag: mil
Description: Peñoles Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mim
Description: Alacatlatzala Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: min
Description: Minangkabau
Added: 2005-10-16
Macrolanguage: ms
%%
Type: language
Subtag: mio
Description: Pinotepa Nacional Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mip
Description: Apasco-Apoala Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: miq
Description: Mískito
Added: 2009-07-29
%%
Type: language
Subtag: mir
Description: Isthmus Mixe
Added: 2009-07-29
%%
Type: language
Subtag: mis
Description: Uncoded languages
Added: 2005-10-16
Scope: special
%%
Type: language
Subtag: mit
Description: Southern Puebla Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: miu
Description: Cacaloxtepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: miw
Description: Akoye
Added: 2009-07-29
%%
Type: language
Subtag: mix
Description: Mixtepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: miy
Description: Ayutla Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: miz
Description: Coatzospan Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mja
Description: Mahei
Added: 2009-07-29
Deprecated: 2011-08-16
%%
Type: language
Subtag: mjb
Description: Makalero
Added: 2016-05-30
%%
Type: language
Subtag: mjc
Description: San Juan Colorado Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mjd
Description: Northwest Maidu
Added: 2009-07-29
%%
Type: language
Subtag: mje
Description: Muskum
Added: 2009-07-29
%%
Type: language
Subtag: mjg
Description: Tu
Added: 2009-07-29
%%
Type: language
Subtag: mjh
Description: Mwera (Nyasa)
Added: 2009-07-29
%%
Type: language
Subtag: mji
Description: Kim Mun
Added: 2009-07-29
%%
Type: language
Subtag: mjj
Description: Mawak
Added: 2009-07-29
%%
Type: language
Subtag: mjk
Description: Matukar
Added: 2009-07-29
%%
Type: language
Subtag: mjl
Description: Mandeali
Added: 2009-07-29
%%
Type: language
Subtag: mjm
Description: Medebur
Added: 2009-07-29
%%
Type: language
Subtag: mjn
Description: Ma (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: mjo
Description: Malankuravan
Added: 2009-07-29
%%
Type: language
Subtag: mjp
Description: Malapandaram
Added: 2009-07-29
%%
Type: language
Subtag: mjq
Description: Malaryan
Added: 2009-07-29
%%
Type: language
Subtag: mjr
Description: Malavedan
Added: 2009-07-29
%%
Type: language
Subtag: mjs
Description: Miship
Added: 2009-07-29
%%
Type: language
Subtag: mjt
Description: Sauria Paharia
Added: 2009-07-29
%%
Type: language
Subtag: mju
Description: Manna-Dora
Added: 2009-07-29
%%
Type: language
Subtag: mjv
Description: Mannan
Added: 2009-07-29
%%
Type: language
Subtag: mjw
Description: Karbi
Added: 2009-07-29
%%
Type: language
Subtag: mjx
Description: Mahali
Added: 2009-07-29
%%
Type: language
Subtag: mjy
Description: Mahican
Added: 2009-07-29
%%
Type: language
Subtag: mjz
Description: Majhi
Added: 2009-07-29
%%
Type: language
Subtag: mka
Description: Mbre
Added: 2009-07-29
%%
Type: language
Subtag: mkb
Description: Mal Paharia
Added: 2009-07-29
%%
Type: language
Subtag: mkc
Description: Siliput
Added: 2009-07-29
%%
Type: language
Subtag: mke
Description: Mawchi
Added: 2009-07-29
%%
Type: language
Subtag: mkf
Description: Miya
Added: 2009-07-29
%%
Type: language
Subtag: mkg
Description: Mak (China)
Added: 2009-07-29
%%
Type: language
Subtag: mkh
Description: Mon-Khmer languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: mki
Description: Dhatki
Added: 2009-07-29
%%
Type: language
Subtag: mkj
Description: Mokilese
Added: 2009-07-29
%%
Type: language
Subtag: mkk
Description: Byep
Added: 2009-07-29
%%
Type: language
Subtag: mkl
Description: Mokole
Added: 2009-07-29
%%
Type: language
Subtag: mkm
Description: Moklen
Added: 2009-07-29
%%
Type: language
Subtag: mkn
Description: Kupang Malay
Added: 2009-07-29
%%
Type: language
Subtag: mko
Description: Mingang Doso
Added: 2009-07-29
%%
Type: language
Subtag: mkp
Description: Moikodi
Added: 2009-07-29
%%
Type: language
Subtag: mkq
Description: Bay Miwok
Added: 2009-07-29
%%
Type: language
Subtag: mkr
Description: Malas
Added: 2009-07-29
%%
Type: language
Subtag: mks
Description: Silacayoapan Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mkt
Description: Vamale
Added: 2009-07-29
%%
Type: language
Subtag: mku
Description: Konyanka Maninka
Added: 2009-07-29
Macrolanguage: man
%%
Type: language
Subtag: mkv
Description: Mafea
Added: 2009-07-29
%%
Type: language
Subtag: mkw
Description: Kituba (Congo)
Added: 2009-07-29
%%
Type: language
Subtag: mkx
Description: Kinamiging Manobo
Added: 2009-07-29
%%
Type: language
Subtag: mky
Description: East Makian
Added: 2009-07-29
%%
Type: language
Subtag: mkz
Description: Makasae
Added: 2009-07-29
%%
Type: language
Subtag: mla
Description: Malo
Added: 2009-07-29
%%
Type: language
Subtag: mlb
Description: Mbule
Added: 2009-07-29
%%
Type: language
Subtag: mlc
Description: Cao Lan
Added: 2009-07-29
%%
Type: language
Subtag: mld
Description: Malakhel
Added: 2009-07-29
Deprecated: 2013-09-10
%%
Type: language
Subtag: mle
Description: Manambu
Added: 2009-07-29
%%
Type: language
Subtag: mlf
Description: Mal
Added: 2009-07-29
%%
Type: language
Subtag: mlh
Description: Mape
Added: 2009-07-29
%%
Type: language
Subtag: mli
Description: Malimpung
Added: 2009-07-29
%%
Type: language
Subtag: mlj
Description: Miltu
Added: 2009-07-29
%%
Type: language
Subtag: mlk
Description: Ilwana
Description: Kiwilwana
Added: 2009-07-29
%%
Type: language
Subtag: mll
Description: Malua Bay
Added: 2009-07-29
%%
Type: language
Subtag: mlm
Description: Mulam
Added: 2009-07-29
%%
Type: language
Subtag: mln
Description: Malango
Added: 2009-07-29
%%
Type: language
Subtag: mlo
Description: Mlomp
Added: 2009-07-29
%%
Type: language
Subtag: mlp
Description: Bargam
Added: 2009-07-29
%%
Type: language
Subtag: mlq
Description: Western Maninkakan
Added: 2009-07-29
Macrolanguage: man
%%
Type: language
Subtag: mlr
Description: Vame
Added: 2009-07-29
%%
Type: language
Subtag: mls
Description: Masalit
Added: 2009-07-29
%%
Type: language
Subtag: mlu
Description: To'abaita
Added: 2009-07-29
%%
Type: language
Subtag: mlv
Description: Motlav
Description: Mwotlap
Added: 2009-07-29
%%
Type: language
Subtag: mlw
Description: Moloko
Added: 2009-07-29
%%
Type: language
Subtag: mlx
Description: Malfaxal
Description: Naha'ai
Added: 2009-07-29
%%
Type: language
Subtag: mlz
Description: Malaynon
Added: 2009-07-29
%%
Type: language
Subtag: mma
Description: Mama
Added: 2009-07-29
%%
Type: language
Subtag: mmb
Description: Momina
Added: 2009-07-29
%%
Type: language
Subtag: mmc
Description: Michoacán Mazahua
Added: 2009-07-29
%%
Type: language
Subtag: mmd
Description: Maonan
Added: 2009-07-29
%%
Type: language
Subtag: mme
Description: Mae
Added: 2009-07-29
%%
Type: language
Subtag: mmf
Description: Mundat
Added: 2009-07-29
%%
Type: language
Subtag: mmg
Description: North Ambrym
Added: 2009-07-29
%%
Type: language
Subtag: mmh
Description: Mehináku
Added: 2009-07-29
%%
Type: language
Subtag: mmi
Description: Musar
Added: 2009-07-29
%%
Type: language
Subtag: mmj
Description: Majhwar
Added: 2009-07-29
%%
Type: language
Subtag: mmk
Description: Mukha-Dora
Added: 2009-07-29
%%
Type: language
Subtag: mml
Description: Man Met
Added: 2009-07-29
%%
Type: language
Subtag: mmm
Description: Maii
Added: 2009-07-29
%%
Type: language
Subtag: mmn
Description: Mamanwa
Added: 2009-07-29
%%
Type: language
Subtag: mmo
Description: Mangga Buang
Added: 2009-07-29
%%
Type: language
Subtag: mmp
Description: Siawi
Added: 2009-07-29
%%
Type: language
Subtag: mmq
Description: Musak
Added: 2009-07-29
%%
Type: language
Subtag: mmr
Description: Western Xiangxi Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: mmt
Description: Malalamai
Added: 2009-07-29
%%
Type: language
Subtag: mmu
Description: Mmaala
Added: 2009-07-29
%%
Type: language
Subtag: mmv
Description: Miriti
Added: 2009-07-29
%%
Type: language
Subtag: mmw
Description: Emae
Added: 2009-07-29
%%
Type: language
Subtag: mmx
Description: Madak
Added: 2009-07-29
%%
Type: language
Subtag: mmy
Description: Migaama
Added: 2009-07-29
%%
Type: language
Subtag: mmz
Description: Mabaale
Added: 2009-07-29
%%
Type: language
Subtag: mna
Description: Mbula
Added: 2009-07-29
%%
Type: language
Subtag: mnb
Description: Muna
Added: 2009-07-29
%%
Type: language
Subtag: mnc
Description: Manchu
Added: 2005-10-16
%%
Type: language
Subtag: mnd
Description: Mondé
Added: 2009-07-29
%%
Type: language
Subtag: mne
Description: Naba
Added: 2009-07-29
%%
Type: language
Subtag: mnf
Description: Mundani
Added: 2009-07-29
%%
Type: language
Subtag: mng
Description: Eastern Mnong
Added: 2009-07-29
%%
Type: language
Subtag: mnh
Description: Mono (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: mni
Description: Manipuri
Added: 2005-10-16
%%
Type: language
Subtag: mnj
Description: Munji
Added: 2009-07-29
%%
Type: language
Subtag: mnk
Description: Mandinka
Added: 2009-07-29
Macrolanguage: man
%%
Type: language
Subtag: mnl
Description: Tiale
Added: 2009-07-29
%%
Type: language
Subtag: mnm
Description: Mapena
Added: 2009-07-29
%%
Type: language
Subtag: mnn
Description: Southern Mnong
Added: 2009-07-29
%%
Type: language
Subtag: mno
Description: Manobo languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: mnp
Description: Min Bei Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: mnq
Description: Minriq
Added: 2009-07-29
%%
Type: language
Subtag: mnr
Description: Mono (USA)
Added: 2009-07-29
%%
Type: language
Subtag: mns
Description: Mansi
Added: 2009-07-29
%%
Type: language
Subtag: mnt
Description: Maykulan
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see wnn, xyj, xyk, xyt
%%
Type: language
Subtag: mnu
Description: Mer
Added: 2009-07-29
%%
Type: language
Subtag: mnv
Description: Rennell-Bellona
Added: 2009-07-29
%%
Type: language
Subtag: mnw
Description: Mon
Added: 2009-07-29
%%
Type: language
Subtag: mnx
Description: Manikion
Added: 2009-07-29
%%
Type: language
Subtag: mny
Description: Manyawa
Added: 2009-07-29
%%
Type: language
Subtag: mnz
Description: Moni
Added: 2009-07-29
%%
Type: language
Subtag: moa
Description: Mwan
Added: 2009-07-29
%%
Type: language
Subtag: moc
Description: Mocoví
Added: 2009-07-29
%%
Type: language
Subtag: mod
Description: Mobilian
Added: 2009-07-29
%%
Type: language
Subtag: moe
Description: Montagnais
Added: 2009-07-29
%%
Type: language
Subtag: mof
Description: Mohegan-Montauk-Narragansett
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see xnt, xpq
%%
Type: language
Subtag: mog
Description: Mongondow
Added: 2009-07-29
%%
Type: language
Subtag: moh
Description: Mohawk
Added: 2005-10-16
%%
Type: language
Subtag: moi
Description: Mboi
Added: 2009-07-29
%%
Type: language
Subtag: moj
Description: Monzombo
Added: 2009-07-29
%%
Type: language
Subtag: mok
Description: Morori
Added: 2009-07-29
%%
Type: language
Subtag: mom
Description: Mangue
Added: 2009-07-29
%%
Type: language
Subtag: moo
Description: Monom
Added: 2009-07-29
%%
Type: language
Subtag: mop
Description: Mopán Maya
Added: 2009-07-29
%%
Type: language
Subtag: moq
Description: Mor (Bomberai Peninsula)
Added: 2009-07-29
%%
Type: language
Subtag: mor
Description: Moro
Added: 2009-07-29
%%
Type: language
Subtag: mos
Description: Mossi
Added: 2005-10-16
%%
Type: language
Subtag: mot
Description: Barí
Added: 2009-07-29
%%
Type: language
Subtag: mou
Description: Mogum
Added: 2009-07-29
%%
Type: language
Subtag: mov
Description: Mohave
Added: 2009-07-29
%%
Type: language
Subtag: mow
Description: Moi (Congo)
Added: 2009-07-29
%%
Type: language
Subtag: mox
Description: Molima
Added: 2009-07-29
%%
Type: language
Subtag: moy
Description: Shekkacho
Added: 2009-07-29
%%
Type: language
Subtag: moz
Description: Mukulu
Description: Gergiko
Added: 2009-07-29
%%
Type: language
Subtag: mpa
Description: Mpoto
Added: 2009-07-29
%%
Type: language
Subtag: mpb
Description: Malak Malak
Description: Mullukmulluk
Added: 2009-07-29
%%
Type: language
Subtag: mpc
Description: Mangarrayi
Added: 2009-07-29
%%
Type: language
Subtag: mpd
Description: Machinere
Added: 2009-07-29
%%
Type: language
Subtag: mpe
Description: Majang
Added: 2009-07-29
%%
Type: language
Subtag: mpg
Description: Marba
Added: 2009-07-29
%%
Type: language
Subtag: mph
Description: Maung
Added: 2009-07-29
%%
Type: language
Subtag: mpi
Description: Mpade
Added: 2009-07-29
%%
Type: language
Subtag: mpj
Description: Martu Wangka
Description: Wangkajunga
Added: 2009-07-29
%%
Type: language
Subtag: mpk
Description: Mbara (Chad)
Added: 2009-07-29
%%
Type: language
Subtag: mpl
Description: Middle Watut
Added: 2009-07-29
%%
Type: language
Subtag: mpm
Description: Yosondúa Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mpn
Description: Mindiri
Added: 2009-07-29
%%
Type: language
Subtag: mpo
Description: Miu
Added: 2009-07-29
%%
Type: language
Subtag: mpp
Description: Migabac
Added: 2009-07-29
%%
Type: language
Subtag: mpq
Description: Matís
Added: 2009-07-29
%%
Type: language
Subtag: mpr
Description: Vangunu
Added: 2009-07-29
%%
Type: language
Subtag: mps
Description: Dadibi
Added: 2009-07-29
%%
Type: language
Subtag: mpt
Description: Mian
Added: 2009-07-29
%%
Type: language
Subtag: mpu
Description: Makuráp
Added: 2009-07-29
%%
Type: language
Subtag: mpv
Description: Mungkip
Added: 2009-07-29
%%
Type: language
Subtag: mpw
Description: Mapidian
Added: 2009-07-29
%%
Type: language
Subtag: mpx
Description: Misima-Panaeati
Added: 2009-07-29
%%
Type: language
Subtag: mpy
Description: Mapia
Added: 2009-07-29
%%
Type: language
Subtag: mpz
Description: Mpi
Added: 2009-07-29
%%
Type: language
Subtag: mqa
Description: Maba (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: mqb
Description: Mbuko
Added: 2009-07-29
%%
Type: language
Subtag: mqc
Description: Mangole
Added: 2009-07-29
%%
Type: language
Subtag: mqe
Description: Matepi
Added: 2009-07-29
%%
Type: language
Subtag: mqf
Description: Momuna
Added: 2009-07-29
%%
Type: language
Subtag: mqg
Description: Kota Bangun Kutai Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: mqh
Description: Tlazoyaltepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mqi
Description: Mariri
Added: 2009-07-29
%%
Type: language
Subtag: mqj
Description: Mamasa
Added: 2009-07-29
%%
Type: language
Subtag: mqk
Description: Rajah Kabunsuwan Manobo
Added: 2009-07-29
%%
Type: language
Subtag: mql
Description: Mbelime
Added: 2009-07-29
%%
Type: language
Subtag: mqm
Description: South Marquesan
Added: 2009-07-29
%%
Type: language
Subtag: mqn
Description: Moronene
Added: 2009-07-29
%%
Type: language
Subtag: mqo
Description: Modole
Added: 2009-07-29
%%
Type: language
Subtag: mqp
Description: Manipa
Added: 2009-07-29
%%
Type: language
Subtag: mqq
Description: Minokok
Added: 2009-07-29
%%
Type: language
Subtag: mqr
Description: Mander
Added: 2009-07-29
%%
Type: language
Subtag: mqs
Description: West Makian
Added: 2009-07-29
%%
Type: language
Subtag: mqt
Description: Mok
Added: 2009-07-29
%%
Type: language
Subtag: mqu
Description: Mandari
Added: 2009-07-29
%%
Type: language
Subtag: mqv
Description: Mosimo
Added: 2009-07-29
%%
Type: language
Subtag: mqw
Description: Murupi
Added: 2009-07-29
%%
Type: language
Subtag: mqx
Description: Mamuju
Added: 2009-07-29
%%
Type: language
Subtag: mqy
Description: Manggarai
Added: 2009-07-29
%%
Type: language
Subtag: mqz
Description: Pano
Added: 2009-07-29
%%
Type: language
Subtag: mra
Description: Mlabri
Added: 2009-07-29
%%
Type: language
Subtag: mrb
Description: Marino
Added: 2009-07-29
%%
Type: language
Subtag: mrc
Description: Maricopa
Added: 2009-07-29
%%
Type: language
Subtag: mrd
Description: Western Magar
Added: 2009-07-29
%%
Type: language
Subtag: mre
Description: Martha's Vineyard Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: mrf
Description: Elseng
Added: 2009-07-29
%%
Type: language
Subtag: mrg
Description: Mising
Added: 2009-07-29
%%
Type: language
Subtag: mrh
Description: Mara Chin
Added: 2009-07-29
%%
Type: language
Subtag: mrj
Description: Western Mari
Added: 2009-07-29
Macrolanguage: chm
%%
Type: language
Subtag: mrk
Description: Hmwaveke
Added: 2009-07-29
%%
Type: language
Subtag: mrl
Description: Mortlockese
Added: 2009-07-29
%%
Type: language
Subtag: mrm
Description: Merlav
Description: Mwerlap
Added: 2009-07-29
%%
Type: language
Subtag: mrn
Description: Cheke Holo
Added: 2009-07-29
%%
Type: language
Subtag: mro
Description: Mru
Added: 2009-07-29
%%
Type: language
Subtag: mrp
Description: Morouas
Added: 2009-07-29
%%
Type: language
Subtag: mrq
Description: North Marquesan
Added: 2009-07-29
%%
Type: language
Subtag: mrr
Description: Maria (India)
Added: 2009-07-29
%%
Type: language
Subtag: mrs
Description: Maragus
Added: 2009-07-29
%%
Type: language
Subtag: mrt
Description: Marghi Central
Added: 2009-07-29
%%
Type: language
Subtag: mru
Description: Mono (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: mrv
Description: Mangareva
Added: 2009-07-29
%%
Type: language
Subtag: mrw
Description: Maranao
Added: 2009-07-29
%%
Type: language
Subtag: mrx
Description: Maremgi
Description: Dineor
Added: 2009-07-29
%%
Type: language
Subtag: mry
Description: Mandaya
Added: 2009-07-29
%%
Type: language
Subtag: mrz
Description: Marind
Added: 2009-07-29
%%
Type: language
Subtag: msb
Description: Masbatenyo
Added: 2009-07-29
%%
Type: language
Subtag: msc
Description: Sankaran Maninka
Added: 2009-07-29
Macrolanguage: man
%%
Type: language
Subtag: msd
Description: Yucatec Maya Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: mse
Description: Musey
Added: 2009-07-29
%%
Type: language
Subtag: msf
Description: Mekwei
Added: 2009-07-29
%%
Type: language
Subtag: msg
Description: Moraid
Added: 2009-07-29
%%
Type: language
Subtag: msh
Description: Masikoro Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: msi
Description: Sabah Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: msj
Description: Ma (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: msk
Description: Mansaka
Added: 2009-07-29
%%
Type: language
Subtag: msl
Description: Molof
Description: Poule
Added: 2009-07-29
%%
Type: language
Subtag: msm
Description: Agusan Manobo
Added: 2009-07-29
%%
Type: language
Subtag: msn
Description: Vurës
Added: 2009-07-29
%%
Type: language
Subtag: mso
Description: Mombum
Added: 2009-07-29
%%
Type: language
Subtag: msp
Description: Maritsauá
Added: 2009-07-29
%%
Type: language
Subtag: msq
Description: Caac
Added: 2009-07-29
%%
Type: language
Subtag: msr
Description: Mongolian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: mss
Description: West Masela
Added: 2009-07-29
%%
Type: language
Subtag: mst
Description: Cataelano Mandaya
Added: 2009-07-29
Deprecated: 2010-03-11
Preferred-Value: mry
%%
Type: language
Subtag: msu
Description: Musom
Added: 2009-07-29
%%
Type: language
Subtag: msv
Description: Maslam
Added: 2009-07-29
%%
Type: language
Subtag: msw
Description: Mansoanka
Added: 2009-07-29
%%
Type: language
Subtag: msx
Description: Moresada
Added: 2009-07-29
%%
Type: language
Subtag: msy
Description: Aruamu
Added: 2009-07-29
%%
Type: language
Subtag: msz
Description: Momare
Added: 2009-07-29
%%
Type: language
Subtag: mta
Description: Cotabato Manobo
Added: 2009-07-29
%%
Type: language
Subtag: mtb
Description: Anyin Morofo
Added: 2009-07-29
%%
Type: language
Subtag: mtc
Description: Munit
Added: 2009-07-29
%%
Type: language
Subtag: mtd
Description: Mualang
Added: 2009-07-29
%%
Type: language
Subtag: mte
Description: Mono (Solomon Islands)
Added: 2009-07-29
%%
Type: language
Subtag: mtf
Description: Murik (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: mtg
Description: Una
Added: 2009-07-29
%%
Type: language
Subtag: mth
Description: Munggui
Added: 2009-07-29
%%
Type: language
Subtag: mti
Description: Maiwa (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: mtj
Description: Moskona
Added: 2009-07-29
%%
Type: language
Subtag: mtk
Description: Mbe'
Added: 2009-07-29
%%
Type: language
Subtag: mtl
Description: Montol
Added: 2009-07-29
%%
Type: language
Subtag: mtm
Description: Mator
Added: 2009-07-29
%%
Type: language
Subtag: mtn
Description: Matagalpa
Added: 2009-07-29
%%
Type: language
Subtag: mto
Description: Totontepec Mixe
Added: 2009-07-29
%%
Type: language
Subtag: mtp
Description: Wichí Lhamtés Nocten
Added: 2009-07-29
%%
Type: language
Subtag: mtq
Description: Muong
Added: 2009-07-29
%%
Type: language
Subtag: mtr
Description: Mewari
Added: 2009-07-29
Macrolanguage: mwr
%%
Type: language
Subtag: mts
Description: Yora
Added: 2009-07-29
%%
Type: language
Subtag: mtt
Description: Mota
Added: 2009-07-29
%%
Type: language
Subtag: mtu
Description: Tututepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mtv
Description: Asaro'o
Added: 2009-07-29
%%
Type: language
Subtag: mtw
Description: Southern Binukidnon
Added: 2009-07-29
%%
Type: language
Subtag: mtx
Description: Tidaá Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mty
Description: Nabi
Added: 2009-07-29
%%
Type: language
Subtag: mua
Description: Mundang
Added: 2009-07-29
%%
Type: language
Subtag: mub
Description: Mubi
Added: 2009-07-29
%%
Type: language
Subtag: muc
Description: Ajumbu
Added: 2009-07-29
%%
Type: language
Subtag: mud
Description: Mednyj Aleut
Added: 2009-07-29
%%
Type: language
Subtag: mue
Description: Media Lengua
Added: 2009-07-29
%%
Type: language
Subtag: mug
Description: Musgu
Added: 2009-07-29
%%
Type: language
Subtag: muh
Description: Mündü
Added: 2009-07-29
%%
Type: language
Subtag: mui
Description: Musi
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: muj
Description: Mabire
Added: 2009-07-29
%%
Type: language
Subtag: muk
Description: Mugom
Added: 2009-07-29
%%
Type: language
Subtag: mul
Description: Multiple languages
Added: 2005-10-16
Scope: special
%%
Type: language
Subtag: mum
Description: Maiwala
Added: 2009-07-29
%%
Type: language
Subtag: mun
Description: Munda languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: muo
Description: Nyong
Added: 2009-07-29
%%
Type: language
Subtag: mup
Description: Malvi
Added: 2009-07-29
Macrolanguage: raj
%%
Type: language
Subtag: muq
Description: Eastern Xiangxi Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: mur
Description: Murle
Added: 2009-07-29
%%
Type: language
Subtag: mus
Description: Creek
Added: 2005-10-16
%%
Type: language
Subtag: mut
Description: Western Muria
Added: 2009-07-29
%%
Type: language
Subtag: muu
Description: Yaaku
Added: 2009-07-29
%%
Type: language
Subtag: muv
Description: Muthuvan
Added: 2009-07-29
%%
Type: language
Subtag: mux
Description: Bo-Ung
Added: 2009-07-29
%%
Type: language
Subtag: muy
Description: Muyang
Added: 2009-07-29
%%
Type: language
Subtag: muz
Description: Mursi
Added: 2009-07-29
%%
Type: language
Subtag: mva
Description: Manam
Added: 2009-07-29
%%
Type: language
Subtag: mvb
Description: Mattole
Added: 2009-07-29
%%
Type: language
Subtag: mvd
Description: Mamboru
Added: 2009-07-29
%%
Type: language
Subtag: mve
Description: Marwari (Pakistan)
Added: 2009-07-29
Macrolanguage: mwr
%%
Type: language
Subtag: mvf
Description: Peripheral Mongolian
Added: 2009-07-29
Macrolanguage: mn
%%
Type: language
Subtag: mvg
Description: Yucuañe Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mvh
Description: Mulgi
Added: 2009-07-29
%%
Type: language
Subtag: mvi
Description: Miyako
Added: 2009-07-29
%%
Type: language
Subtag: mvk
Description: Mekmek
Added: 2009-07-29
%%
Type: language
Subtag: mvl
Description: Mbara (Australia)
Added: 2009-07-29
%%
Type: language
Subtag: mvm
Description: Muya
Added: 2009-07-29
%%
Type: language
Subtag: mvn
Description: Minaveha
Added: 2009-07-29
%%
Type: language
Subtag: mvo
Description: Marovo
Added: 2009-07-29
%%
Type: language
Subtag: mvp
Description: Duri
Added: 2009-07-29
%%
Type: language
Subtag: mvq
Description: Moere
Added: 2009-07-29
%%
Type: language
Subtag: mvr
Description: Marau
Added: 2009-07-29
%%
Type: language
Subtag: mvs
Description: Massep
Added: 2009-07-29
%%
Type: language
Subtag: mvt
Description: Mpotovoro
Added: 2009-07-29
%%
Type: language
Subtag: mvu
Description: Marfa
Added: 2009-07-29
%%
Type: language
Subtag: mvv
Description: Tagal Murut
Added: 2009-07-29
%%
Type: language
Subtag: mvw
Description: Machinga
Added: 2009-07-29
%%
Type: language
Subtag: mvx
Description: Meoswar
Added: 2009-07-29
%%
Type: language
Subtag: mvy
Description: Indus Kohistani
Added: 2009-07-29
%%
Type: language
Subtag: mvz
Description: Mesqan
Added: 2009-07-29
%%
Type: language
Subtag: mwa
Description: Mwatebu
Added: 2009-07-29
%%
Type: language
Subtag: mwb
Description: Juwal
Added: 2009-07-29
%%
Type: language
Subtag: mwc
Description: Are
Added: 2009-07-29
%%
Type: language
Subtag: mwd
Description: Mudbura
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see dmw, xrq
%%
Type: language
Subtag: mwe
Description: Mwera (Chimwera)
Added: 2009-07-29
%%
Type: language
Subtag: mwf
Description: Murrinh-Patha
Added: 2009-07-29
%%
Type: language
Subtag: mwg
Description: Aiklep
Added: 2009-07-29
%%
Type: language
Subtag: mwh
Description: Mouk-Aria
Added: 2009-07-29
%%
Type: language
Subtag: mwi
Description: Labo
Description: Ninde
Added: 2009-07-29
%%
Type: language
Subtag: mwj
Description: Maligo
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: vaj
%%
Type: language
Subtag: mwk
Description: Kita Maninkakan
Added: 2009-07-29
Macrolanguage: man
%%
Type: language
Subtag: mwl
Description: Mirandese
Added: 2005-10-16
%%
Type: language
Subtag: mwm
Description: Sar
Added: 2009-07-29
%%
Type: language
Subtag: mwn
Description: Nyamwanga
Added: 2009-07-29
%%
Type: language
Subtag: mwo
Description: Central Maewo
Added: 2009-07-29
%%
Type: language
Subtag: mwp
Description: Kala Lagaw Ya
Added: 2009-07-29
%%
Type: language
Subtag: mwq
Description: Mün Chin
Added: 2009-07-29
%%
Type: language
Subtag: mwr
Description: Marwari
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: mws
Description: Mwimbi-Muthambi
Added: 2009-07-29
%%
Type: language
Subtag: mwt
Description: Moken
Added: 2009-07-29
%%
Type: language
Subtag: mwu
Description: Mittu
Added: 2009-07-29
%%
Type: language
Subtag: mwv
Description: Mentawai
Added: 2009-07-29
%%
Type: language
Subtag: mww
Description: Hmong Daw
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: mwx
Description: Mediak
Added: 2009-07-29
Deprecated: 2018-03-08
%%
Type: language
Subtag: mwy
Description: Mosiro
Added: 2009-07-29
Deprecated: 2018-03-08
%%
Type: language
Subtag: mwz
Description: Moingi
Added: 2009-07-29
%%
Type: language
Subtag: mxa
Description: Northwest Oaxaca Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mxb
Description: Tezoatlán Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mxc
Description: Manyika
Added: 2009-07-29
%%
Type: language
Subtag: mxd
Description: Modang
Added: 2009-07-29
%%
Type: language
Subtag: mxe
Description: Mele-Fila
Added: 2009-07-29
%%
Type: language
Subtag: mxf
Description: Malgbe
Added: 2009-07-29
%%
Type: language
Subtag: mxg
Description: Mbangala
Added: 2009-07-29
%%
Type: language
Subtag: mxh
Description: Mvuba
Added: 2009-07-29
%%
Type: language
Subtag: mxi
Description: Mozarabic
Added: 2009-07-29
%%
Type: language
Subtag: mxj
Description: Miju-Mishmi
Description: Geman Deng
Added: 2009-07-29
%%
Type: language
Subtag: mxk
Description: Monumbo
Added: 2009-07-29
%%
Type: language
Subtag: mxl
Description: Maxi Gbe
Added: 2009-07-29
%%
Type: language
Subtag: mxm
Description: Meramera
Added: 2009-07-29
%%
Type: language
Subtag: mxn
Description: Moi (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: mxo
Description: Mbowe
Added: 2009-07-29
%%
Type: language
Subtag: mxp
Description: Tlahuitoltepec Mixe
Added: 2009-07-29
%%
Type: language
Subtag: mxq
Description: Juquila Mixe
Added: 2009-07-29
%%
Type: language
Subtag: mxr
Description: Murik (Malaysia)
Added: 2009-07-29
%%
Type: language
Subtag: mxs
Description: Huitepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mxt
Description: Jamiltepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mxu
Description: Mada (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: mxv
Description: Metlatónoc Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mxw
Description: Namo
Added: 2009-07-29
%%
Type: language
Subtag: mxx
Description: Mahou
Description: Mawukakan
Added: 2009-07-29
%%
Type: language
Subtag: mxy
Description: Southeastern Nochixtlán Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mxz
Description: Central Masela
Added: 2009-07-29
%%
Type: language
Subtag: myb
Description: Mbay
Added: 2009-07-29
%%
Type: language
Subtag: myc
Description: Mayeka
Added: 2009-07-29
%%
Type: language
Subtag: myd
Description: Maramba
Added: 2009-07-29
Deprecated: 2019-04-16
Preferred-Value: aog
%%
Type: language
Subtag: mye
Description: Myene
Added: 2009-07-29
%%
Type: language
Subtag: myf
Description: Bambassi
Added: 2009-07-29
%%
Type: language
Subtag: myg
Description: Manta
Added: 2009-07-29
%%
Type: language
Subtag: myh
Description: Makah
Added: 2009-07-29
%%
Type: language
Subtag: myi
Description: Mina (India)
Added: 2009-07-29
Deprecated: 2019-04-16
%%
Type: language
Subtag: myj
Description: Mangayat
Added: 2009-07-29
%%
Type: language
Subtag: myk
Description: Mamara Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: myl
Description: Moma
Added: 2009-07-29
%%
Type: language
Subtag: mym
Description: Me'en
Added: 2009-07-29
%%
Type: language
Subtag: myn
Description: Mayan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: myo
Description: Anfillo
Added: 2009-07-29
%%
Type: language
Subtag: myp
Description: Pirahã
Added: 2009-07-29
%%
Type: language
Subtag: myq
Description: Forest Maninka
Added: 2009-07-29
Deprecated: 2013-09-10
Macrolanguage: man
%%
Type: language
Subtag: myr
Description: Muniche
Added: 2009-07-29
%%
Type: language
Subtag: mys
Description: Mesmes
Added: 2009-07-29
%%
Type: language
Subtag: myt
Description: Sangab Mandaya
Added: 2009-07-29
Deprecated: 2010-03-11
Preferred-Value: mry
%%
Type: language
Subtag: myu
Description: Mundurukú
Added: 2009-07-29
%%
Type: language
Subtag: myv
Description: Erzya
Added: 2005-10-16
%%
Type: language
Subtag: myw
Description: Muyuw
Added: 2009-07-29
%%
Type: language
Subtag: myx
Description: Masaaba
Added: 2009-07-29
%%
Type: language
Subtag: myy
Description: Macuna
Added: 2009-07-29
%%
Type: language
Subtag: myz
Description: Classical Mandaic
Added: 2009-07-29
%%
Type: language
Subtag: mza
Description: Santa María Zacatepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: mzb
Description: Tumzabt
Added: 2009-07-29
%%
Type: language
Subtag: mzc
Description: Madagascar Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: mzd
Description: Malimba
Added: 2009-07-29
%%
Type: language
Subtag: mze
Description: Morawa
Added: 2009-07-29
%%
Type: language
Subtag: mzg
Description: Monastic Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: mzh
Description: Wichí Lhamtés Güisnay
Added: 2009-07-29
%%
Type: language
Subtag: mzi
Description: Ixcatlán Mazatec
Added: 2009-07-29
%%
Type: language
Subtag: mzj
Description: Manya
Added: 2009-07-29
%%
Type: language
Subtag: mzk
Description: Nigeria Mambila
Added: 2009-07-29
%%
Type: language
Subtag: mzl
Description: Mazatlán Mixe
Added: 2009-07-29
%%
Type: language
Subtag: mzm
Description: Mumuye
Added: 2009-07-29
%%
Type: language
Subtag: mzn
Description: Mazanderani
Added: 2009-07-29
%%
Type: language
Subtag: mzo
Description: Matipuhy
Added: 2009-07-29
%%
Type: language
Subtag: mzp
Description: Movima
Added: 2009-07-29
%%
Type: language
Subtag: mzq
Description: Mori Atas
Added: 2009-07-29
%%
Type: language
Subtag: mzr
Description: Marúbo
Added: 2009-07-29
%%
Type: language
Subtag: mzs
Description: Macanese
Added: 2009-07-29
%%
Type: language
Subtag: mzt
Description: Mintil
Added: 2009-07-29
%%
Type: language
Subtag: mzu
Description: Inapang
Added: 2009-07-29
%%
Type: language
Subtag: mzv
Description: Manza
Added: 2009-07-29
%%
Type: language
Subtag: mzw
Description: Deg
Added: 2009-07-29
%%
Type: language
Subtag: mzx
Description: Mawayana
Added: 2009-07-29
%%
Type: language
Subtag: mzy
Description: Mozambican Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: mzz
Description: Maiadomu
Added: 2009-07-29
%%
Type: language
Subtag: naa
Description: Namla
Added: 2009-07-29
%%
Type: language
Subtag: nab
Description: Southern Nambikuára
Added: 2009-07-29
%%
Type: language
Subtag: nac
Description: Narak
Added: 2009-07-29
%%
Type: language
Subtag: nad
Description: Nijadali
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: xny
%%
Type: language
Subtag: nae
Description: Naka'ela
Added: 2009-07-29
%%
Type: language
Subtag: naf
Description: Nabak
Added: 2009-07-29
%%
Type: language
Subtag: nag
Description: Naga Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: nah
Description: Nahuatl languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: nai
Description: North American Indian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: naj
Description: Nalu
Added: 2009-07-29
%%
Type: language
Subtag: nak
Description: Nakanai
Added: 2009-07-29
%%
Type: language
Subtag: nal
Description: Nalik
Added: 2009-07-29
%%
Type: language
Subtag: nam
Description: Ngan'gityemerri
Added: 2009-07-29
%%
Type: language
Subtag: nan
Description: Min Nan Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: nao
Description: Naaba
Added: 2009-07-29
%%
Type: language
Subtag: nap
Description: Neapolitan
Added: 2005-10-16
%%
Type: language
Subtag: naq
Description: Khoekhoe
Description: Nama (Namibia)
Added: 2009-07-29
%%
Type: language
Subtag: nar
Description: Iguta
Added: 2009-07-29
%%
Type: language
Subtag: nas
Description: Naasioi
Added: 2009-07-29
%%
Type: language
Subtag: nat
Description: Ca̱hungwa̱rya̱
Description: Hungworo
Added: 2009-07-29
%%
Type: language
Subtag: naw
Description: Nawuri
Added: 2009-07-29
%%
Type: language
Subtag: nax
Description: Nakwi
Added: 2009-07-29
%%
Type: language
Subtag: nay
Description: Ngarrindjeri
Added: 2009-07-29
%%
Type: language
Subtag: naz
Description: Coatepec Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nba
Description: Nyemba
Added: 2009-07-29
%%
Type: language
Subtag: nbb
Description: Ndoe
Added: 2009-07-29
%%
Type: language
Subtag: nbc
Description: Chang Naga
Added: 2009-07-29
%%
Type: language
Subtag: nbd
Description: Ngbinda
Added: 2009-07-29
%%
Type: language
Subtag: nbe
Description: Konyak Naga
Added: 2009-07-29
%%
Type: language
Subtag: nbf
Description: Naxi
Added: 2009-07-29
Deprecated: 2011-08-16
Comments: see nru, nxq
%%
Type: language
Subtag: nbg
Description: Nagarchal
Added: 2009-07-29
%%
Type: language
Subtag: nbh
Description: Ngamo
Added: 2009-07-29
%%
Type: language
Subtag: nbi
Description: Mao Naga
Added: 2009-07-29
%%
Type: language
Subtag: nbj
Description: Ngarinyman
Added: 2009-07-29
%%
Type: language
Subtag: nbk
Description: Nake
Added: 2009-07-29
%%
Type: language
Subtag: nbm
Description: Ngbaka Ma'bo
Added: 2009-07-29
%%
Type: language
Subtag: nbn
Description: Kuri
Added: 2009-07-29
%%
Type: language
Subtag: nbo
Description: Nkukoli
Added: 2009-07-29
%%
Type: language
Subtag: nbp
Description: Nnam
Added: 2009-07-29
%%
Type: language
Subtag: nbq
Description: Nggem
Added: 2009-07-29
%%
Type: language
Subtag: nbr
Description: Numana
Added: 2009-07-29
%%
Type: language
Subtag: nbs
Description: Namibian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: nbt
Description: Na
Added: 2009-07-29
%%
Type: language
Subtag: nbu
Description: Rongmei Naga
Added: 2009-07-29
%%
Type: language
Subtag: nbv
Description: Ngamambo
Added: 2009-07-29
%%
Type: language
Subtag: nbw
Description: Southern Ngbandi
Added: 2009-07-29
%%
Type: language
Subtag: nbx
Description: Ngura
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see ekc, gll, jbi, xpt, xwk
%%
Type: language
Subtag: nby
Description: Ningera
Added: 2009-07-29
%%
Type: language
Subtag: nca
Description: Iyo
Added: 2009-07-29
%%
Type: language
Subtag: ncb
Description: Central Nicobarese
Added: 2009-07-29
%%
Type: language
Subtag: ncc
Description: Ponam
Added: 2009-07-29
%%
Type: language
Subtag: ncd
Description: Nachering
Added: 2009-07-29
%%
Type: language
Subtag: nce
Description: Yale
Added: 2009-07-29
%%
Type: language
Subtag: ncf
Description: Notsi
Added: 2009-07-29
%%
Type: language
Subtag: ncg
Description: Nisga'a
Added: 2009-07-29
%%
Type: language
Subtag: nch
Description: Central Huasteca Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nci
Description: Classical Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: ncj
Description: Northern Puebla Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nck
Description: Na-kara
Added: 2009-07-29
%%
Type: language
Subtag: ncl
Description: Michoacán Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: ncm
Description: Nambo
Added: 2009-07-29
%%
Type: language
Subtag: ncn
Description: Nauna
Added: 2009-07-29
%%
Type: language
Subtag: nco
Description: Sibe
Added: 2009-07-29
%%
Type: language
Subtag: ncp
Description: Ndaktup
Added: 2009-07-29
Deprecated: 2018-03-08
Preferred-Value: kdz
%%
Type: language
Subtag: ncq
Description: Northern Katang
Added: 2017-02-23
%%
Type: language
Subtag: ncr
Description: Ncane
Added: 2009-07-29
%%
Type: language
Subtag: ncs
Description: Nicaraguan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: nct
Description: Chothe Naga
Added: 2009-07-29
%%
Type: language
Subtag: ncu
Description: Chumburung
Added: 2009-07-29
%%
Type: language
Subtag: ncx
Description: Central Puebla Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: ncz
Description: Natchez
Added: 2009-07-29
%%
Type: language
Subtag: nda
Description: Ndasa
Added: 2009-07-29
%%
Type: language
Subtag: ndb
Description: Kenswei Nsei
Added: 2009-07-29
%%
Type: language
Subtag: ndc
Description: Ndau
Added: 2009-07-29
%%
Type: language
Subtag: ndd
Description: Nde-Nsele-Nta
Added: 2009-07-29
%%
Type: language
Subtag: ndf
Description: Nadruvian
Added: 2009-07-29
%%
Type: language
Subtag: ndg
Description: Ndengereko
Added: 2009-07-29
%%
Type: language
Subtag: ndh
Description: Ndali
Added: 2009-07-29
%%
Type: language
Subtag: ndi
Description: Samba Leko
Added: 2009-07-29
%%
Type: language
Subtag: ndj
Description: Ndamba
Added: 2009-07-29
%%
Type: language
Subtag: ndk
Description: Ndaka
Added: 2009-07-29
%%
Type: language
Subtag: ndl
Description: Ndolo
Added: 2009-07-29
%%
Type: language
Subtag: ndm
Description: Ndam
Added: 2009-07-29
%%
Type: language
Subtag: ndn
Description: Ngundi
Added: 2009-07-29
%%
Type: language
Subtag: ndp
Description: Ndo
Added: 2009-07-29
%%
Type: language
Subtag: ndq
Description: Ndombe
Added: 2009-07-29
%%
Type: language
Subtag: ndr
Description: Ndoola
Added: 2009-07-29
%%
Type: language
Subtag: nds
Description: Low German
Description: Low Saxon
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ndt
Description: Ndunga
Added: 2009-07-29
%%
Type: language
Subtag: ndu
Description: Dugun
Added: 2009-07-29
%%
Type: language
Subtag: ndv
Description: Ndut
Added: 2009-07-29
%%
Type: language
Subtag: ndw
Description: Ndobo
Added: 2009-07-29
%%
Type: language
Subtag: ndx
Description: Nduga
Added: 2009-07-29
%%
Type: language
Subtag: ndy
Description: Lutos
Added: 2009-07-29
%%
Type: language
Subtag: ndz
Description: Ndogo
Added: 2009-07-29
%%
Type: language
Subtag: nea
Description: Eastern Ngad'a
Added: 2009-07-29
%%
Type: language
Subtag: neb
Description: Toura (Côte d'Ivoire)
Added: 2009-07-29
%%
Type: language
Subtag: nec
Description: Nedebang
Added: 2009-07-29
%%
Type: language
Subtag: ned
Description: Nde-Gbite
Added: 2009-07-29
%%
Type: language
Subtag: nee
Description: Nêlêmwa-Nixumwak
Added: 2009-07-29
%%
Type: language
Subtag: nef
Description: Nefamese
Added: 2009-07-29
%%
Type: language
Subtag: neg
Description: Negidal
Added: 2009-07-29
%%
Type: language
Subtag: neh
Description: Nyenkha
Added: 2009-07-29
%%
Type: language
Subtag: nei
Description: Neo-Hittite
Added: 2009-07-29
%%
Type: language
Subtag: nej
Description: Neko
Added: 2009-07-29
%%
Type: language
Subtag: nek
Description: Neku
Added: 2009-07-29
%%
Type: language
Subtag: nem
Description: Nemi
Added: 2009-07-29
%%
Type: language
Subtag: nen
Description: Nengone
Added: 2009-07-29
%%
Type: language
Subtag: neo
Description: Ná-Meo
Added: 2009-07-29
%%
Type: language
Subtag: neq
Description: North Central Mixe
Added: 2009-07-29
%%
Type: language
Subtag: ner
Description: Yahadian
Added: 2009-07-29
%%
Type: language
Subtag: nes
Description: Bhoti Kinnauri
Added: 2009-07-29
%%
Type: language
Subtag: net
Description: Nete
Added: 2009-07-29
%%
Type: language
Subtag: neu
Description: Neo
Added: 2012-08-12
%%
Type: language
Subtag: nev
Description: Nyaheun
Added: 2009-07-29
%%
Type: language
Subtag: new
Description: Newari
Description: Nepal Bhasa
Added: 2005-10-16
%%
Type: language
Subtag: nex
Description: Neme
Added: 2009-07-29
%%
Type: language
Subtag: ney
Description: Neyo
Added: 2009-07-29
%%
Type: language
Subtag: nez
Description: Nez Perce
Added: 2009-07-29
%%
Type: language
Subtag: nfa
Description: Dhao
Added: 2009-07-29
%%
Type: language
Subtag: nfd
Description: Ahwai
Added: 2009-07-29
%%
Type: language
Subtag: nfl
Description: Ayiwo
Description: Äiwoo
Added: 2009-07-29
%%
Type: language
Subtag: nfr
Description: Nafaanra
Added: 2009-07-29
%%
Type: language
Subtag: nfu
Description: Mfumte
Added: 2009-07-29
%%
Type: language
Subtag: nga
Description: Ngbaka
Added: 2009-07-29
%%
Type: language
Subtag: ngb
Description: Northern Ngbandi
Added: 2009-07-29
%%
Type: language
Subtag: ngc
Description: Ngombe (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: ngd
Description: Ngando (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: nge
Description: Ngemba
Added: 2009-07-29
%%
Type: language
Subtag: ngf
Description: Trans-New Guinea languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: ngg
Description: Ngbaka Manza
Added: 2009-07-29
%%
Type: language
Subtag: ngh
Description: Nǁng
Added: 2009-07-29
%%
Type: language
Subtag: ngi
Description: Ngizim
Added: 2009-07-29
%%
Type: language
Subtag: ngj
Description: Ngie
Added: 2009-07-29
%%
Type: language
Subtag: ngk
Description: Dalabon
Added: 2009-07-29
%%
Type: language
Subtag: ngl
Description: Lomwe
Added: 2009-07-29
%%
Type: language
Subtag: ngm
Description: Ngatik Men's Creole
Added: 2009-07-29
%%
Type: language
Subtag: ngn
Description: Ngwo
Added: 2009-07-29
%%
Type: language
Subtag: ngo
Description: Ngoni
Added: 2009-07-29
%%
Type: language
Subtag: ngp
Description: Ngulu
Added: 2009-07-29
%%
Type: language
Subtag: ngq
Description: Ngurimi
Description: Ngoreme
Added: 2009-07-29
%%
Type: language
Subtag: ngr
Description: Engdewu
Added: 2009-07-29
%%
Type: language
Subtag: ngs
Description: Gvoko
Added: 2009-07-29
%%
Type: language
Subtag: ngt
Description: Kriang
Description: Ngeq
Added: 2009-07-29
%%
Type: language
Subtag: ngu
Description: Guerrero Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: ngv
Description: Nagumi
Added: 2009-07-29
%%
Type: language
Subtag: ngw
Description: Ngwaba
Added: 2009-07-29
%%
Type: language
Subtag: ngx
Description: Nggwahyi
Added: 2009-07-29
%%
Type: language
Subtag: ngy
Description: Tibea
Added: 2009-07-29
%%
Type: language
Subtag: ngz
Description: Ngungwel
Added: 2009-07-29
%%
Type: language
Subtag: nha
Description: Nhanda
Added: 2009-07-29
%%
Type: language
Subtag: nhb
Description: Beng
Added: 2009-07-29
%%
Type: language
Subtag: nhc
Description: Tabasco Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhd
Description: Chiripá
Description: Ava Guaraní
Added: 2009-07-29
Macrolanguage: gn
%%
Type: language
Subtag: nhe
Description: Eastern Huasteca Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhf
Description: Nhuwala
Added: 2009-07-29
%%
Type: language
Subtag: nhg
Description: Tetelcingo Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhh
Description: Nahari
Added: 2009-07-29
%%
Type: language
Subtag: nhi
Description: Zacatlán-Ahuacatlán-Tepetzintla Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhk
Description: Isthmus-Cosoleacaque Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhm
Description: Morelos Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhn
Description: Central Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nho
Description: Takuu
Added: 2009-07-29
%%
Type: language
Subtag: nhp
Description: Isthmus-Pajapan Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhq
Description: Huaxcaleca Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhr
Description: Naro
Added: 2009-07-29
%%
Type: language
Subtag: nht
Description: Ometepec Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhu
Description: Noone
Added: 2009-07-29
%%
Type: language
Subtag: nhv
Description: Temascaltepec Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhw
Description: Western Huasteca Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhx
Description: Isthmus-Mecayapan Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhy
Description: Northern Oaxaca Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nhz
Description: Santa María La Alta Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nia
Description: Nias
Added: 2005-10-16
%%
Type: language
Subtag: nib
Description: Nakame
Added: 2009-07-29
%%
Type: language
Subtag: nic
Description: Niger-Kordofanian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: nid
Description: Ngandi
Added: 2009-07-29
%%
Type: language
Subtag: nie
Description: Niellim
Added: 2009-07-29
%%
Type: language
Subtag: nif
Description: Nek
Added: 2009-07-29
%%
Type: language
Subtag: nig
Description: Ngalakgan
Added: 2009-07-29
%%
Type: language
Subtag: nih
Description: Nyiha (Tanzania)
Added: 2009-07-29
%%
Type: language
Subtag: nii
Description: Nii
Added: 2009-07-29
%%
Type: language
Subtag: nij
Description: Ngaju
Added: 2009-07-29
%%
Type: language
Subtag: nik
Description: Southern Nicobarese
Added: 2009-07-29
%%
Type: language
Subtag: nil
Description: Nila
Added: 2009-07-29
%%
Type: language
Subtag: nim
Description: Nilamba
Added: 2009-07-29
%%
Type: language
Subtag: nin
Description: Ninzo
Added: 2009-07-29
%%
Type: language
Subtag: nio
Description: Nganasan
Added: 2009-07-29
%%
Type: language
Subtag: niq
Description: Nandi
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: nir
Description: Nimboran
Added: 2009-07-29
%%
Type: language
Subtag: nis
Description: Nimi
Added: 2009-07-29
%%
Type: language
Subtag: nit
Description: Southeastern Kolami
Added: 2009-07-29
%%
Type: language
Subtag: niu
Description: Niuean
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: niv
Description: Gilyak
Added: 2009-07-29
%%
Type: language
Subtag: niw
Description: Nimo
Added: 2009-07-29
%%
Type: language
Subtag: nix
Description: Hema
Added: 2009-07-29
%%
Type: language
Subtag: niy
Description: Ngiti
Added: 2009-07-29
%%
Type: language
Subtag: niz
Description: Ningil
Added: 2009-07-29
%%
Type: language
Subtag: nja
Description: Nzanyi
Added: 2009-07-29
%%
Type: language
Subtag: njb
Description: Nocte Naga
Added: 2009-07-29
%%
Type: language
Subtag: njd
Description: Ndonde Hamba
Added: 2009-07-29
%%
Type: language
Subtag: njh
Description: Lotha Naga
Added: 2009-07-29
%%
Type: language
Subtag: nji
Description: Gudanji
Added: 2009-07-29
%%
Type: language
Subtag: njj
Description: Njen
Added: 2009-07-29
%%
Type: language
Subtag: njl
Description: Njalgulgule
Added: 2009-07-29
%%
Type: language
Subtag: njm
Description: Angami Naga
Added: 2009-07-29
%%
Type: language
Subtag: njn
Description: Liangmai Naga
Added: 2009-07-29
%%
Type: language
Subtag: njo
Description: Ao Naga
Added: 2009-07-29
%%
Type: language
Subtag: njr
Description: Njerep
Added: 2009-07-29
%%
Type: language
Subtag: njs
Description: Nisa
Added: 2009-07-29
%%
Type: language
Subtag: njt
Description: Ndyuka-Trio Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: nju
Description: Ngadjunmaya
Added: 2009-07-29
%%
Type: language
Subtag: njx
Description: Kunyi
Added: 2009-07-29
%%
Type: language
Subtag: njy
Description: Njyem
Added: 2009-07-29
%%
Type: language
Subtag: njz
Description: Nyishi
Added: 2012-08-12
%%
Type: language
Subtag: nka
Description: Nkoya
Added: 2009-07-29
%%
Type: language
Subtag: nkb
Description: Khoibu Naga
Added: 2009-07-29
%%
Type: language
Subtag: nkc
Description: Nkongho
Added: 2009-07-29
%%
Type: language
Subtag: nkd
Description: Koireng
Added: 2009-07-29
%%
Type: language
Subtag: nke
Description: Duke
Added: 2009-07-29
%%
Type: language
Subtag: nkf
Description: Inpui Naga
Added: 2009-07-29
%%
Type: language
Subtag: nkg
Description: Nekgini
Added: 2009-07-29
%%
Type: language
Subtag: nkh
Description: Khezha Naga
Added: 2009-07-29
%%
Type: language
Subtag: nki
Description: Thangal Naga
Added: 2009-07-29
%%
Type: language
Subtag: nkj
Description: Nakai
Added: 2009-07-29
%%
Type: language
Subtag: nkk
Description: Nokuku
Added: 2009-07-29
%%
Type: language
Subtag: nkm
Description: Namat
Added: 2009-07-29
%%
Type: language
Subtag: nkn
Description: Nkangala
Added: 2009-07-29
%%
Type: language
Subtag: nko
Description: Nkonya
Added: 2009-07-29
%%
Type: language
Subtag: nkp
Description: Niuatoputapu
Added: 2009-07-29
%%
Type: language
Subtag: nkq
Description: Nkami
Added: 2010-04-16
%%
Type: language
Subtag: nkr
Description: Nukuoro
Added: 2009-07-29
%%
Type: language
Subtag: nks
Description: North Asmat
Added: 2009-07-29
%%
Type: language
Subtag: nkt
Description: Nyika (Tanzania)
Added: 2009-07-29
%%
Type: language
Subtag: nku
Description: Bouna Kulango
Added: 2009-07-29
%%
Type: language
Subtag: nkv
Description: Nyika (Malawi and Zambia)
Added: 2009-07-29
%%
Type: language
Subtag: nkw
Description: Nkutu
Added: 2009-07-29
%%
Type: language
Subtag: nkx
Description: Nkoroo
Added: 2009-07-29
%%
Type: language
Subtag: nkz
Description: Nkari
Added: 2009-07-29
%%
Type: language
Subtag: nla
Description: Ngombale
Added: 2009-07-29
%%
Type: language
Subtag: nlc
Description: Nalca
Added: 2009-07-29
%%
Type: language
Subtag: nle
Description: East Nyala
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: nlg
Description: Gela
Added: 2009-07-29
%%
Type: language
Subtag: nli
Description: Grangali
Added: 2009-07-29
%%
Type: language
Subtag: nlj
Description: Nyali
Added: 2009-07-29
%%
Type: language
Subtag: nlk
Description: Ninia Yali
Added: 2009-07-29
%%
Type: language
Subtag: nll
Description: Nihali
Added: 2009-07-29
%%
Type: language
Subtag: nlm
Description: Mankiyali
Added: 2018-03-08
%%
Type: language
Subtag: nln
Description: Durango Nahuatl
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see azd, azn
%%
Type: language
Subtag: nlo
Description: Ngul
Added: 2009-07-29
%%
Type: language
Subtag: nlq
Description: Lao Naga
Added: 2013-09-10
%%
Type: language
Subtag: nlr
Description: Ngarla
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see nrk, ywg
%%
Type: language
Subtag: nlu
Description: Nchumbulu
Added: 2009-07-29
%%
Type: language
Subtag: nlv
Description: Orizaba Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nlw
Description: Walangama
Added: 2013-09-10
%%
Type: language
Subtag: nlx
Description: Nahali
Added: 2009-07-29
%%
Type: language
Subtag: nly
Description: Nyamal
Added: 2009-07-29
%%
Type: language
Subtag: nlz
Description: Nalögo
Added: 2009-07-29
%%
Type: language
Subtag: nma
Description: Maram Naga
Added: 2009-07-29
%%
Type: language
Subtag: nmb
Description: Big Nambas
Description: V'ënen Taut
Added: 2009-07-29
%%
Type: language
Subtag: nmc
Description: Ngam
Added: 2009-07-29
%%
Type: language
Subtag: nmd
Description: Ndumu
Added: 2009-07-29
%%
Type: language
Subtag: nme
Description: Mzieme Naga
Added: 2009-07-29
%%
Type: language
Subtag: nmf
Description: Tangkhul Naga (India)
Added: 2009-07-29
Comments: see ntx
%%
Type: language
Subtag: nmg
Description: Kwasio
Added: 2009-07-29
%%
Type: language
Subtag: nmh
Description: Monsang Naga
Added: 2009-07-29
%%
Type: language
Subtag: nmi
Description: Nyam
Added: 2009-07-29
%%
Type: language
Subtag: nmj
Description: Ngombe (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: nmk
Description: Namakura
Added: 2009-07-29
%%
Type: language
Subtag: nml
Description: Ndemli
Added: 2009-07-29
%%
Type: language
Subtag: nmm
Description: Manangba
Added: 2009-07-29
%%
Type: language
Subtag: nmn
Description: ǃXóõ
Added: 2009-07-29
%%
Type: language
Subtag: nmo
Description: Moyon Naga
Added: 2009-07-29
%%
Type: language
Subtag: nmp
Description: Nimanbur
Added: 2009-07-29
%%
Type: language
Subtag: nmq
Description: Nambya
Added: 2009-07-29
%%
Type: language
Subtag: nmr
Description: Nimbari
Added: 2009-07-29
%%
Type: language
Subtag: nms
Description: Letemboi
Added: 2009-07-29
%%
Type: language
Subtag: nmt
Description: Namonuito
Added: 2009-07-29
%%
Type: language
Subtag: nmu
Description: Northeast Maidu
Added: 2009-07-29
%%
Type: language
Subtag: nmv
Description: Ngamini
Added: 2009-07-29
%%
Type: language
Subtag: nmw
Description: Nimoa
Description: Rifao
Added: 2009-07-29
%%
Type: language
Subtag: nmx
Description: Nama (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: nmy
Description: Namuyi
Added: 2009-07-29
%%
Type: language
Subtag: nmz
Description: Nawdm
Added: 2009-07-29
%%
Type: language
Subtag: nna
Description: Nyangumarta
Added: 2009-07-29
%%
Type: language
Subtag: nnb
Description: Nande
Added: 2009-07-29
%%
Type: language
Subtag: nnc
Description: Nancere
Added: 2009-07-29
%%
Type: language
Subtag: nnd
Description: West Ambae
Added: 2009-07-29
%%
Type: language
Subtag: nne
Description: Ngandyera
Added: 2009-07-29
%%
Type: language
Subtag: nnf
Description: Ngaing
Added: 2009-07-29
%%
Type: language
Subtag: nng
Description: Maring Naga
Added: 2009-07-29
%%
Type: language
Subtag: nnh
Description: Ngiemboon
Added: 2009-07-29
%%
Type: language
Subtag: nni
Description: North Nuaulu
Added: 2009-07-29
%%
Type: language
Subtag: nnj
Description: Nyangatom
Added: 2009-07-29
%%
Type: language
Subtag: nnk
Description: Nankina
Added: 2009-07-29
%%
Type: language
Subtag: nnl
Description: Northern Rengma Naga
Added: 2009-07-29
%%
Type: language
Subtag: nnm
Description: Namia
Added: 2009-07-29
%%
Type: language
Subtag: nnn
Description: Ngete
Added: 2009-07-29
%%
Type: language
Subtag: nnp
Description: Wancho Naga
Added: 2009-07-29
%%
Type: language
Subtag: nnq
Description: Ngindo
Added: 2009-07-29
%%
Type: language
Subtag: nnr
Description: Narungga
Added: 2009-07-29
%%
Type: language
Subtag: nns
Description: Ningye
Added: 2009-07-29
Deprecated: 2019-04-16
Preferred-Value: nbr
%%
Type: language
Subtag: nnt
Description: Nanticoke
Added: 2009-07-29
%%
Type: language
Subtag: nnu
Description: Dwang
Added: 2009-07-29
%%
Type: language
Subtag: nnv
Description: Nugunu (Australia)
Added: 2009-07-29
%%
Type: language
Subtag: nnw
Description: Southern Nuni
Added: 2009-07-29
%%
Type: language
Subtag: nnx
Description: Ngong
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: ngv
%%
Type: language
Subtag: nny
Description: Nyangga
Added: 2009-07-29
%%
Type: language
Subtag: nnz
Description: Nda'nda'
Added: 2009-07-29
%%
Type: language
Subtag: noa
Description: Woun Meu
Added: 2009-07-29
%%
Type: language
Subtag: noc
Description: Nuk
Added: 2009-07-29
%%
Type: language
Subtag: nod
Description: Northern Thai
Added: 2009-07-29
%%
Type: language
Subtag: noe
Description: Nimadi
Added: 2009-07-29
%%
Type: language
Subtag: nof
Description: Nomane
Added: 2009-07-29
%%
Type: language
Subtag: nog
Description: Nogai
Added: 2005-10-16
%%
Type: language
Subtag: noh
Description: Nomu
Added: 2009-07-29
%%
Type: language
Subtag: noi
Description: Noiri
Added: 2009-07-29
%%
Type: language
Subtag: noj
Description: Nonuya
Added: 2010-03-11
%%
Type: language
Subtag: nok
Description: Nooksack
Added: 2009-07-29
%%
Type: language
Subtag: nol
Description: Nomlaki
Added: 2013-09-10
%%
Type: language
Subtag: nom
Description: Nocamán
Added: 2009-07-29
%%
Type: language
Subtag: non
Description: Old Norse
Added: 2005-10-16
%%
Type: language
Subtag: noo
Description: Nootka
Added: 2009-07-29
Deprecated: 2011-08-16
Comments: see dtd, nuk
%%
Type: language
Subtag: nop
Description: Numanggang
Added: 2009-07-29
%%
Type: language
Subtag: noq
Description: Ngongo
Added: 2009-07-29
%%
Type: language
Subtag: nos
Description: Eastern Nisu
Added: 2009-07-29
%%
Type: language
Subtag: not
Description: Nomatsiguenga
Added: 2009-07-29
%%
Type: language
Subtag: nou
Description: Ewage-Notu
Added: 2009-07-29
%%
Type: language
Subtag: nov
Description: Novial
Added: 2009-07-29
%%
Type: language
Subtag: now
Description: Nyambo
Added: 2009-07-29
%%
Type: language
Subtag: noy
Description: Noy
Added: 2009-07-29
%%
Type: language
Subtag: noz
Description: Nayi
Added: 2009-07-29
%%
Type: language
Subtag: npa
Description: Nar Phu
Added: 2009-07-29
%%
Type: language
Subtag: npb
Description: Nupbikha
Added: 2009-07-29
%%
Type: language
Subtag: npg
Description: Ponyo-Gongwang Naga
Added: 2012-08-12
%%
Type: language
Subtag: nph
Description: Phom Naga
Added: 2009-07-29
%%
Type: language
Subtag: npi
Description: Nepali (individual language)
Added: 2012-08-12
Macrolanguage: ne
%%
Type: language
Subtag: npl
Description: Southeastern Puebla Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: npn
Description: Mondropolon
Added: 2009-07-29
%%
Type: language
Subtag: npo
Description: Pochuri Naga
Added: 2009-07-29
%%
Type: language
Subtag: nps
Description: Nipsan
Added: 2009-07-29
%%
Type: language
Subtag: npu
Description: Puimei Naga
Added: 2009-07-29
%%
Type: language
Subtag: npx
Description: Noipx
Added: 2017-02-23
%%
Type: language
Subtag: npy
Description: Napu
Added: 2009-07-29
%%
Type: language
Subtag: nqg
Description: Southern Nago
Added: 2009-07-29
%%
Type: language
Subtag: nqk
Description: Kura Ede Nago
Added: 2009-07-29
%%
Type: language
Subtag: nql
Description: Ngendelengo
Added: 2017-02-23
%%
Type: language
Subtag: nqm
Description: Ndom
Added: 2009-07-29
%%
Type: language
Subtag: nqn
Description: Nen
Added: 2009-07-29
%%
Type: language
Subtag: nqo
Description: N'Ko
Description: N’Ko
Added: 2006-06-05
Suppress-Script: Nkoo
%%
Type: language
Subtag: nqq
Description: Kyan-Karyaw Naga
Added: 2013-09-10
%%
Type: language
Subtag: nqy
Description: Akyaung Ari Naga
Added: 2012-08-12
%%
Type: language
Subtag: nra
Description: Ngom
Added: 2009-07-29
%%
Type: language
Subtag: nrb
Description: Nara
Added: 2009-07-29
%%
Type: language
Subtag: nrc
Description: Noric
Added: 2009-07-29
%%
Type: language
Subtag: nre
Description: Southern Rengma Naga
Added: 2009-07-29
%%
Type: language
Subtag: nrf
Description: Jèrriais
Description: Guernésiais
Added: 2015-02-12
%%
Type: language
Subtag: nrg
Description: Narango
Added: 2009-07-29
%%
Type: language
Subtag: nri
Description: Chokri Naga
Added: 2009-07-29
%%
Type: language
Subtag: nrk
Description: Ngarla
Added: 2013-09-10
%%
Type: language
Subtag: nrl
Description: Ngarluma
Added: 2009-07-29
%%
Type: language
Subtag: nrm
Description: Narom
Added: 2009-07-29
%%
Type: language
Subtag: nrn
Description: Norn
Added: 2009-07-29
%%
Type: language
Subtag: nrp
Description: North Picene
Added: 2009-07-29
%%
Type: language
Subtag: nrr
Description: Norra
Description: Nora
Added: 2009-07-29
%%
Type: language
Subtag: nrt
Description: Northern Kalapuya
Added: 2009-07-29
%%
Type: language
Subtag: nru
Description: Narua
Added: 2011-08-16
%%
Type: language
Subtag: nrx
Description: Ngurmbur
Added: 2009-07-29
%%
Type: language
Subtag: nrz
Description: Lala
Added: 2009-07-29
%%
Type: language
Subtag: nsa
Description: Sangtam Naga
Added: 2009-07-29
%%
Type: language
Subtag: nsc
Description: Nshi
Added: 2009-07-29
%%
Type: language
Subtag: nsd
Description: Southern Nisu
Added: 2009-07-29
%%
Type: language
Subtag: nse
Description: Nsenga
Added: 2009-07-29
%%
Type: language
Subtag: nsf
Description: Northwestern Nisu
Added: 2012-08-12
%%
Type: language
Subtag: nsg
Description: Ngasa
Added: 2009-07-29
%%
Type: language
Subtag: nsh
Description: Ngoshie
Added: 2009-07-29
%%
Type: language
Subtag: nsi
Description: Nigerian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: nsk
Description: Naskapi
Added: 2009-07-29
%%
Type: language
Subtag: nsl
Description: Norwegian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: nsm
Description: Sumi Naga
Added: 2009-07-29
%%
Type: language
Subtag: nsn
Description: Nehan
Added: 2009-07-29
%%
Type: language
Subtag: nso
Description: Pedi
Description: Northern Sotho
Description: Sepedi
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: nsp
Description: Nepalese Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: nsq
Description: Northern Sierra Miwok
Added: 2009-07-29
%%
Type: language
Subtag: nsr
Description: Maritime Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: nss
Description: Nali
Added: 2009-07-29
%%
Type: language
Subtag: nst
Description: Tase Naga
Added: 2009-07-29
%%
Type: language
Subtag: nsu
Description: Sierra Negra Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nsv
Description: Southwestern Nisu
Added: 2009-07-29
%%
Type: language
Subtag: nsw
Description: Navut
Added: 2009-07-29
%%
Type: language
Subtag: nsx
Description: Nsongo
Added: 2009-07-29
%%
Type: language
Subtag: nsy
Description: Nasal
Added: 2009-07-29
%%
Type: language
Subtag: nsz
Description: Nisenan
Added: 2009-07-29
%%
Type: language
Subtag: ntd
Description: Northern Tidung
Added: 2016-05-30
%%
Type: language
Subtag: nte
Description: Nathembo
Added: 2009-07-29
%%
Type: language
Subtag: ntg
Description: Ngantangarra
Added: 2013-09-10
%%
Type: language
Subtag: nti
Description: Natioro
Added: 2009-07-29
%%
Type: language
Subtag: ntj
Description: Ngaanyatjarra
Added: 2009-07-29
%%
Type: language
Subtag: ntk
Description: Ikoma-Nata-Isenye
Added: 2009-07-29
%%
Type: language
Subtag: ntm
Description: Nateni
Added: 2009-07-29
%%
Type: language
Subtag: nto
Description: Ntomba
Added: 2009-07-29
%%
Type: language
Subtag: ntp
Description: Northern Tepehuan
Added: 2009-07-29
%%
Type: language
Subtag: ntr
Description: Delo
Added: 2009-07-29
%%
Type: language
Subtag: nts
Description: Natagaimas
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: pij
%%
Type: language
Subtag: ntu
Description: Natügu
Added: 2009-07-29
%%
Type: language
Subtag: ntw
Description: Nottoway
Added: 2009-07-29
%%
Type: language
Subtag: ntx
Description: Tangkhul Naga (Myanmar)
Added: 2012-08-12
Comments: see nmf
%%
Type: language
Subtag: nty
Description: Mantsi
Added: 2009-07-29
%%
Type: language
Subtag: ntz
Description: Natanzi
Added: 2009-07-29
%%
Type: language
Subtag: nua
Description: Yuanga
Added: 2009-07-29
%%
Type: language
Subtag: nub
Description: Nubian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: nuc
Description: Nukuini
Added: 2009-07-29
%%
Type: language
Subtag: nud
Description: Ngala
Added: 2009-07-29
%%
Type: language
Subtag: nue
Description: Ngundu
Added: 2009-07-29
%%
Type: language
Subtag: nuf
Description: Nusu
Added: 2009-07-29
%%
Type: language
Subtag: nug
Description: Nungali
Added: 2009-07-29
%%
Type: language
Subtag: nuh
Description: Ndunda
Added: 2009-07-29
%%
Type: language
Subtag: nui
Description: Ngumbi
Added: 2009-07-29
%%
Type: language
Subtag: nuj
Description: Nyole
Added: 2009-07-29
%%
Type: language
Subtag: nuk
Description: Nuu-chah-nulth
Description: Nuuchahnulth
Added: 2011-08-16
%%
Type: language
Subtag: nul
Description: Nusa Laut
Added: 2009-07-29
%%
Type: language
Subtag: num
Description: Niuafo'ou
Added: 2009-07-29
%%
Type: language
Subtag: nun
Description: Anong
Added: 2009-07-29
%%
Type: language
Subtag: nuo
Description: Nguôn
Added: 2009-07-29
%%
Type: language
Subtag: nup
Description: Nupe-Nupe-Tako
Added: 2009-07-29
%%
Type: language
Subtag: nuq
Description: Nukumanu
Added: 2009-07-29
%%
Type: language
Subtag: nur
Description: Nukuria
Added: 2009-07-29
%%
Type: language
Subtag: nus
Description: Nuer
Added: 2009-07-29
%%
Type: language
Subtag: nut
Description: Nung (Viet Nam)
Added: 2009-07-29
%%
Type: language
Subtag: nuu
Description: Ngbundu
Added: 2009-07-29
%%
Type: language
Subtag: nuv
Description: Northern Nuni
Added: 2009-07-29
%%
Type: language
Subtag: nuw
Description: Nguluwan
Added: 2009-07-29
%%
Type: language
Subtag: nux
Description: Mehek
Added: 2009-07-29
%%
Type: language
Subtag: nuy
Description: Nunggubuyu
Added: 2009-07-29
%%
Type: language
Subtag: nuz
Description: Tlamacazapa Nahuatl
Added: 2009-07-29
%%
Type: language
Subtag: nvh
Description: Nasarian
Added: 2009-07-29
%%
Type: language
Subtag: nvm
Description: Namiae
Added: 2009-07-29
%%
Type: language
Subtag: nvo
Description: Nyokon
Added: 2012-08-12
%%
Type: language
Subtag: nwa
Description: Nawathinehena
Added: 2009-07-29
%%
Type: language
Subtag: nwb
Description: Nyabwa
Added: 2009-07-29
%%
Type: language
Subtag: nwc
Description: Classical Newari
Description: Classical Nepal Bhasa
Description: Old Newari
Added: 2005-10-16
%%
Type: language
Subtag: nwe
Description: Ngwe
Added: 2009-07-29
%%
Type: language
Subtag: nwg
Description: Ngayawung
Added: 2012-08-12
%%
Type: language
Subtag: nwi
Description: Southwest Tanna
Added: 2009-07-29
%%
Type: language
Subtag: nwm
Description: Nyamusa-Molo
Added: 2009-07-29
%%
Type: language
Subtag: nwo
Description: Nauo
Added: 2012-08-12
%%
Type: language
Subtag: nwr
Description: Nawaru
Added: 2009-07-29
%%
Type: language
Subtag: nwx
Description: Middle Newar
Added: 2009-07-29
%%
Type: language
Subtag: nwy
Description: Nottoway-Meherrin
Added: 2009-07-29
%%
Type: language
Subtag: nxa
Description: Nauete
Added: 2009-07-29
%%
Type: language
Subtag: nxd
Description: Ngando (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: nxe
Description: Nage
Added: 2009-07-29
%%
Type: language
Subtag: nxg
Description: Ngad'a
Added: 2009-07-29
%%
Type: language
Subtag: nxi
Description: Nindi
Added: 2009-07-29
%%
Type: language
Subtag: nxk
Description: Koki Naga
Added: 2012-08-12
%%
Type: language
Subtag: nxl
Description: South Nuaulu
Added: 2009-07-29
%%
Type: language
Subtag: nxm
Description: Numidian
Added: 2009-07-29
%%
Type: language
Subtag: nxn
Description: Ngawun
Added: 2009-07-29
%%
Type: language
Subtag: nxo
Description: Ndambomo
Added: 2015-02-12
%%
Type: language
Subtag: nxq
Description: Naxi
Added: 2011-08-16
%%
Type: language
Subtag: nxr
Description: Ninggerum
Added: 2009-07-29
%%
Type: language
Subtag: nxu
Description: Narau
Added: 2009-07-29
%%
Type: language
Subtag: nxx
Description: Nafri
Added: 2009-07-29
%%
Type: language
Subtag: nyb
Description: Nyangbo
Added: 2009-07-29
%%
Type: language
Subtag: nyc
Description: Nyanga-li
Added: 2009-07-29
%%
Type: language
Subtag: nyd
Description: Nyore
Description: Olunyole
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: nye
Description: Nyengo
Added: 2009-07-29
%%
Type: language
Subtag: nyf
Description: Giryama
Description: Kigiryama
Added: 2009-07-29
%%
Type: language
Subtag: nyg
Description: Nyindu
Added: 2009-07-29
%%
Type: language
Subtag: nyh
Description: Nyikina
Added: 2009-07-29
%%
Type: language
Subtag: nyi
Description: Ama (Sudan)
Added: 2009-07-29
%%
Type: language
Subtag: nyj
Description: Nyanga
Added: 2009-07-29
%%
Type: language
Subtag: nyk
Description: Nyaneka
Added: 2009-07-29
%%
Type: language
Subtag: nyl
Description: Nyeu
Added: 2009-07-29
%%
Type: language
Subtag: nym
Description: Nyamwezi
Added: 2005-10-16
%%
Type: language
Subtag: nyn
Description: Nyankole
Added: 2005-10-16
%%
Type: language
Subtag: nyo
Description: Nyoro
Added: 2005-10-16
%%
Type: language
Subtag: nyp
Description: Nyang'i
Added: 2009-07-29
%%
Type: language
Subtag: nyq
Description: Nayini
Added: 2009-07-29
%%
Type: language
Subtag: nyr
Description: Nyiha (Malawi)
Added: 2009-07-29
%%
Type: language
Subtag: nys
Description: Nyungar
Added: 2009-07-29
%%
Type: language
Subtag: nyt
Description: Nyawaygi
Added: 2009-07-29
%%
Type: language
Subtag: nyu
Description: Nyungwe
Added: 2009-07-29
%%
Type: language
Subtag: nyv
Description: Nyulnyul
Added: 2009-07-29
%%
Type: language
Subtag: nyw
Description: Nyaw
Added: 2009-07-29
%%
Type: language
Subtag: nyx
Description: Nganyaywana
Added: 2009-07-29
%%
Type: language
Subtag: nyy
Description: Nyakyusa-Ngonde
Added: 2009-07-29
%%
Type: language
Subtag: nza
Description: Tigon Mbembe
Added: 2009-07-29
%%
Type: language
Subtag: nzb
Description: Njebi
Added: 2009-07-29
%%
Type: language
Subtag: nzd
Description: Nzadi
Added: 2018-03-08
%%
Type: language
Subtag: nzi
Description: Nzima
Added: 2005-10-16
%%
Type: language
Subtag: nzk
Description: Nzakara
Added: 2009-07-29
%%
Type: language
Subtag: nzm
Description: Zeme Naga
Added: 2009-07-29
%%
Type: language
Subtag: nzs
Description: New Zealand Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: nzu
Description: Teke-Nzikou
Added: 2009-07-29
%%
Type: language
Subtag: nzy
Description: Nzakambay
Added: 2009-07-29
%%
Type: language
Subtag: nzz
Description: Nanga Dama Dogon
Added: 2010-03-11
%%
Type: language
Subtag: oaa
Description: Orok
Added: 2009-07-29
%%
Type: language
Subtag: oac
Description: Oroch
Added: 2009-07-29
%%
Type: language
Subtag: oar
Description: Old Aramaic (up to 700 BCE)
Description: Ancient Aramaic (up to 700 BCE)
Added: 2009-07-29
%%
Type: language
Subtag: oav
Description: Old Avar
Added: 2009-07-29
%%
Type: language
Subtag: obi
Description: Obispeño
Added: 2009-07-29
%%
Type: language
Subtag: obk
Description: Southern Bontok
Added: 2010-03-11
Macrolanguage: bnc
%%
Type: language
Subtag: obl
Description: Oblo
Added: 2009-07-29
%%
Type: language
Subtag: obm
Description: Moabite
Added: 2009-07-29
%%
Type: language
Subtag: obo
Description: Obo Manobo
Added: 2009-07-29
%%
Type: language
Subtag: obr
Description: Old Burmese
Added: 2009-07-29
%%
Type: language
Subtag: obt
Description: Old Breton
Added: 2009-07-29
%%
Type: language
Subtag: obu
Description: Obulom
Added: 2009-07-29
%%
Type: language
Subtag: oca
Description: Ocaina
Added: 2009-07-29
%%
Type: language
Subtag: och
Description: Old Chinese
Added: 2009-07-29
%%
Type: language
Subtag: oco
Description: Old Cornish
Added: 2009-07-29
%%
Type: language
Subtag: ocu
Description: Atzingo Matlatzinca
Added: 2009-07-29
%%
Type: language
Subtag: oda
Description: Odut
Added: 2009-07-29
%%
Type: language
Subtag: odk
Description: Od
Added: 2009-07-29
%%
Type: language
Subtag: odt
Description: Old Dutch
Added: 2009-07-29
%%
Type: language
Subtag: odu
Description: Odual
Added: 2009-07-29
%%
Type: language
Subtag: ofo
Description: Ofo
Added: 2009-07-29
%%
Type: language
Subtag: ofs
Description: Old Frisian
Added: 2009-07-29
%%
Type: language
Subtag: ofu
Description: Efutop
Added: 2009-07-29
%%
Type: language
Subtag: ogb
Description: Ogbia
Added: 2009-07-29
%%
Type: language
Subtag: ogc
Description: Ogbah
Added: 2009-07-29
%%
Type: language
Subtag: oge
Description: Old Georgian
Added: 2009-07-29
%%
Type: language
Subtag: ogg
Description: Ogbogolo
Added: 2009-07-29
%%
Type: language
Subtag: ogo
Description: Khana
Added: 2009-07-29
%%
Type: language
Subtag: ogu
Description: Ogbronuagum
Added: 2009-07-29
%%
Type: language
Subtag: oht
Description: Old Hittite
Added: 2009-07-29
%%
Type: language
Subtag: ohu
Description: Old Hungarian
Added: 2009-07-29
%%
Type: language
Subtag: oia
Description: Oirata
Added: 2009-07-29
%%
Type: language
Subtag: oin
Description: Inebu One
Added: 2009-07-29
%%
Type: language
Subtag: ojb
Description: Northwestern Ojibwa
Added: 2009-07-29
Macrolanguage: oj
%%
Type: language
Subtag: ojc
Description: Central Ojibwa
Added: 2009-07-29
Macrolanguage: oj
%%
Type: language
Subtag: ojg
Description: Eastern Ojibwa
Added: 2009-07-29
Macrolanguage: oj
%%
Type: language
Subtag: ojp
Description: Old Japanese
Added: 2009-07-29
%%
Type: language
Subtag: ojs
Description: Severn Ojibwa
Added: 2009-07-29
Macrolanguage: oj
%%
Type: language
Subtag: ojv
Description: Ontong Java
Added: 2009-07-29
%%
Type: language
Subtag: ojw
Description: Western Ojibwa
Added: 2009-07-29
Macrolanguage: oj
%%
Type: language
Subtag: oka
Description: Okanagan
Added: 2009-07-29
%%
Type: language
Subtag: okb
Description: Okobo
Added: 2009-07-29
%%
Type: language
Subtag: okd
Description: Okodia
Added: 2009-07-29
%%
Type: language
Subtag: oke
Description: Okpe (Southwestern Edo)
Added: 2009-07-29
%%
Type: language
Subtag: okg
Description: Koko Babangk
Added: 2012-08-12
%%
Type: language
Subtag: okh
Description: Koresh-e Rostam
Added: 2009-07-29
%%
Type: language
Subtag: oki
Description: Okiek
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: okj
Description: Oko-Juwoi
Added: 2009-07-29
%%
Type: language
Subtag: okk
Description: Kwamtim One
Added: 2009-07-29
%%
Type: language
Subtag: okl
Description: Old Kentish Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: okm
Description: Middle Korean (10th-16th cent.)
Added: 2009-07-29
%%
Type: language
Subtag: okn
Description: Oki-No-Erabu
Added: 2009-07-29
%%
Type: language
Subtag: oko
Description: Old Korean (3rd-9th cent.)
Added: 2009-07-29
%%
Type: language
Subtag: okr
Description: Kirike
Added: 2009-07-29
%%
Type: language
Subtag: oks
Description: Oko-Eni-Osayen
Added: 2009-07-29
%%
Type: language
Subtag: oku
Description: Oku
Added: 2009-07-29
%%
Type: language
Subtag: okv
Description: Orokaiva
Added: 2009-07-29
%%
Type: language
Subtag: okx
Description: Okpe (Northwestern Edo)
Added: 2009-07-29
%%
Type: language
Subtag: ola
Description: Walungge
Added: 2009-07-29
%%
Type: language
Subtag: old
Description: Mochi
Added: 2009-07-29
%%
Type: language
Subtag: ole
Description: Olekha
Added: 2009-07-29
%%
Type: language
Subtag: olk
Description: Olkol
Added: 2013-09-10
%%
Type: language
Subtag: olm
Description: Oloma
Added: 2009-07-29
%%
Type: language
Subtag: olo
Description: Livvi
Added: 2009-07-29
%%
Type: language
Subtag: olr
Description: Olrat
Added: 2009-07-29
%%
Type: language
Subtag: olt
Description: Old Lithuanian
Added: 2014-02-28
%%
Type: language
Subtag: olu
Description: Kuvale
Added: 2016-05-30
%%
Type: language
Subtag: oma
Description: Omaha-Ponca
Added: 2009-07-29
%%
Type: language
Subtag: omb
Description: East Ambae
Added: 2009-07-29
%%
Type: language
Subtag: omc
Description: Mochica
Added: 2009-07-29
%%
Type: language
Subtag: ome
Description: Omejes
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: omg
Description: Omagua
Added: 2009-07-29
%%
Type: language
Subtag: omi
Description: Omi
Added: 2009-07-29
%%
Type: language
Subtag: omk
Description: Omok
Added: 2009-07-29
%%
Type: language
Subtag: oml
Description: Ombo
Added: 2009-07-29
%%
Type: language
Subtag: omn
Description: Minoan
Added: 2009-07-29
%%
Type: language
Subtag: omo
Description: Utarmbung
Added: 2009-07-29
%%
Type: language
Subtag: omp
Description: Old Manipuri
Added: 2009-07-29
%%
Type: language
Subtag: omq
Description: Oto-Manguean languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: omr
Description: Old Marathi
Added: 2009-07-29
%%
Type: language
Subtag: omt
Description: Omotik
Added: 2009-07-29
%%
Type: language
Subtag: omu
Description: Omurano
Added: 2009-07-29
%%
Type: language
Subtag: omv
Description: Omotic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: omw
Description: South Tairora
Added: 2009-07-29
%%
Type: language
Subtag: omx
Description: Old Mon
Added: 2009-07-29
%%
Type: language
Subtag: ona
Description: Ona
Added: 2009-07-29
%%
Type: language
Subtag: onb
Description: Lingao
Added: 2009-07-29
%%
Type: language
Subtag: one
Description: Oneida
Added: 2009-07-29
%%
Type: language
Subtag: ong
Description: Olo
Added: 2009-07-29
%%
Type: language
Subtag: oni
Description: Onin
Added: 2009-07-29
%%
Type: language
Subtag: onj
Description: Onjob
Added: 2009-07-29
%%
Type: language
Subtag: onk
Description: Kabore One
Added: 2009-07-29
%%
Type: language
Subtag: onn
Description: Onobasulu
Added: 2009-07-29
%%
Type: language
Subtag: ono
Description: Onondaga
Added: 2009-07-29
%%
Type: language
Subtag: onp
Description: Sartang
Added: 2009-07-29
%%
Type: language
Subtag: onr
Description: Northern One
Added: 2009-07-29
%%
Type: language
Subtag: ons
Description: Ono
Added: 2009-07-29
%%
Type: language
Subtag: ont
Description: Ontenu
Added: 2009-07-29
%%
Type: language
Subtag: onu
Description: Unua
Added: 2009-07-29
%%
Type: language
Subtag: onw
Description: Old Nubian
Added: 2009-07-29
%%
Type: language
Subtag: onx
Description: Onin Based Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: ood
Description: Tohono O'odham
Added: 2009-07-29
%%
Type: language
Subtag: oog
Description: Ong
Added: 2009-07-29
%%
Type: language
Subtag: oon
Description: Önge
Added: 2009-07-29
%%
Type: language
Subtag: oor
Description: Oorlams
Added: 2009-07-29
%%
Type: language
Subtag: oos
Description: Old Ossetic
Added: 2009-07-29
%%
Type: language
Subtag: opa
Description: Okpamheri
Added: 2009-07-29
%%
Type: language
Subtag: opk
Description: Kopkaka
Added: 2009-07-29
%%
Type: language
Subtag: opm
Description: Oksapmin
Added: 2009-07-29
%%
Type: language
Subtag: opo
Description: Opao
Added: 2009-07-29
%%
Type: language
Subtag: opt
Description: Opata
Added: 2009-07-29
%%
Type: language
Subtag: opy
Description: Ofayé
Added: 2009-07-29
%%
Type: language
Subtag: ora
Description: Oroha
Added: 2009-07-29
%%
Type: language
Subtag: orc
Description: Orma
Added: 2009-07-29
Macrolanguage: om
%%
Type: language
Subtag: ore
Description: Orejón
Added: 2009-07-29
%%
Type: language
Subtag: org
Description: Oring
Added: 2009-07-29
%%
Type: language
Subtag: orh
Description: Oroqen
Added: 2009-07-29
%%
Type: language
Subtag: orn
Description: Orang Kanaq
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: oro
Description: Orokolo
Added: 2009-07-29
%%
Type: language
Subtag: orr
Description: Oruma
Added: 2009-07-29
%%
Type: language
Subtag: ors
Description: Orang Seletar
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: ort
Description: Adivasi Oriya
Added: 2009-07-29
%%
Type: language
Subtag: oru
Description: Ormuri
Added: 2009-07-29
%%
Type: language
Subtag: orv
Description: Old Russian
Added: 2009-07-29
%%
Type: language
Subtag: orw
Description: Oro Win
Added: 2009-07-29
%%
Type: language
Subtag: orx
Description: Oro
Added: 2009-07-29
%%
Type: language
Subtag: ory
Description: Odia (individual language)
Description: Oriya (individual language)
Added: 2012-08-12
Macrolanguage: or
%%
Type: language
Subtag: orz
Description: Ormu
Added: 2009-07-29
%%
Type: language
Subtag: osa
Description: Osage
Added: 2005-10-16
%%
Type: language
Subtag: osc
Description: Oscan
Added: 2009-07-29
%%
Type: language
Subtag: osi
Description: Osing
Added: 2009-07-29
%%
Type: language
Subtag: oso
Description: Ososo
Added: 2009-07-29
%%
Type: language
Subtag: osp
Description: Old Spanish
Added: 2009-07-29
%%
Type: language
Subtag: ost
Description: Osatu
Added: 2009-07-29
%%
Type: language
Subtag: osu
Description: Southern One
Added: 2009-07-29
%%
Type: language
Subtag: osx
Description: Old Saxon
Added: 2009-07-29
%%
Type: language
Subtag: ota
Description: Ottoman Turkish (1500-1928)
Added: 2005-10-16
%%
Type: language
Subtag: otb
Description: Old Tibetan
Added: 2009-07-29
%%
Type: language
Subtag: otd
Description: Ot Danum
Added: 2009-07-29
%%
Type: language
Subtag: ote
Description: Mezquital Otomi
Added: 2009-07-29
%%
Type: language
Subtag: oti
Description: Oti
Added: 2009-07-29
%%
Type: language
Subtag: otk
Description: Old Turkish
Added: 2009-07-29
%%
Type: language
Subtag: otl
Description: Tilapa Otomi
Added: 2009-07-29
%%
Type: language
Subtag: otm
Description: Eastern Highland Otomi
Added: 2009-07-29
%%
Type: language
Subtag: otn
Description: Tenango Otomi
Added: 2009-07-29
%%
Type: language
Subtag: oto
Description: Otomian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: otq
Description: Querétaro Otomi
Added: 2009-07-29
%%
Type: language
Subtag: otr
Description: Otoro
Added: 2009-07-29
%%
Type: language
Subtag: ots
Description: Estado de México Otomi
Added: 2009-07-29
%%
Type: language
Subtag: ott
Description: Temoaya Otomi
Added: 2009-07-29
%%
Type: language
Subtag: otu
Description: Otuke
Added: 2009-07-29
%%
Type: language
Subtag: otw
Description: Ottawa
Added: 2009-07-29
Macrolanguage: oj
%%
Type: language
Subtag: otx
Description: Texcatepec Otomi
Added: 2009-07-29
%%
Type: language
Subtag: oty
Description: Old Tamil
Added: 2009-07-29
%%
Type: language
Subtag: otz
Description: Ixtenco Otomi
Added: 2009-07-29
%%
Type: language
Subtag: oua
Description: Tagargrent
Added: 2009-07-29
%%
Type: language
Subtag: oub
Description: Glio-Oubi
Added: 2009-07-29
%%
Type: language
Subtag: oue
Description: Oune
Added: 2009-07-29
%%
Type: language
Subtag: oui
Description: Old Uighur
Added: 2009-07-29
%%
Type: language
Subtag: oum
Description: Ouma
Added: 2009-07-29
%%
Type: language
Subtag: oun
Description: ǃOǃung
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: vaj
%%
Type: language
Subtag: ovd
Description: Elfdalian
Description: Övdalian
Added: 2016-06-16
%%
Type: language
Subtag: owi
Description: Owiniga
Added: 2009-07-29
%%
Type: language
Subtag: owl
Description: Old Welsh
Added: 2009-07-29
%%
Type: language
Subtag: oyb
Description: Oy
Added: 2009-07-29
%%
Type: language
Subtag: oyd
Description: Oyda
Added: 2009-07-29
%%
Type: language
Subtag: oym
Description: Wayampi
Added: 2009-07-29
%%
Type: language
Subtag: oyy
Description: Oya'oya
Added: 2009-07-29
%%
Type: language
Subtag: ozm
Description: Koonzime
Added: 2009-07-29
%%
Type: language
Subtag: paa
Description: Papuan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: pab
Description: Parecís
Added: 2009-07-29
%%
Type: language
Subtag: pac
Description: Pacoh
Added: 2009-07-29
%%
Type: language
Subtag: pad
Description: Paumarí
Added: 2009-07-29
%%
Type: language
Subtag: pae
Description: Pagibete
Added: 2009-07-29
%%
Type: language
Subtag: paf
Description: Paranawát
Added: 2009-07-29
%%
Type: language
Subtag: pag
Description: Pangasinan
Added: 2005-10-16
%%
Type: language
Subtag: pah
Description: Tenharim
Added: 2009-07-29
%%
Type: language
Subtag: pai
Description: Pe
Added: 2009-07-29
%%
Type: language
Subtag: pak
Description: Parakanã
Added: 2009-07-29
%%
Type: language
Subtag: pal
Description: Pahlavi
Added: 2005-10-16
%%
Type: language
Subtag: pam
Description: Pampanga
Description: Kapampangan
Added: 2005-10-16
%%
Type: language
Subtag: pao
Description: Northern Paiute
Added: 2009-07-29
%%
Type: language
Subtag: pap
Description: Papiamento
Added: 2005-10-16
%%
Type: language
Subtag: paq
Description: Parya
Added: 2009-07-29
%%
Type: language
Subtag: par
Description: Panamint
Description: Timbisha
Added: 2009-07-29
%%
Type: language
Subtag: pas
Description: Papasena
Added: 2009-07-29
%%
Type: language
Subtag: pat
Description: Papitalai
Added: 2009-07-29
%%
Type: language
Subtag: pau
Description: Palauan
Added: 2005-10-16
%%
Type: language
Subtag: pav
Description: Pakaásnovos
Added: 2009-07-29
%%
Type: language
Subtag: paw
Description: Pawnee
Added: 2009-07-29
%%
Type: language
Subtag: pax
Description: Pankararé
Added: 2009-07-29
%%
Type: language
Subtag: pay
Description: Pech
Added: 2009-07-29
%%
Type: language
Subtag: paz
Description: Pankararú
Added: 2009-07-29
%%
Type: language
Subtag: pbb
Description: Páez
Added: 2009-07-29
%%
Type: language
Subtag: pbc
Description: Patamona
Added: 2009-07-29
%%
Type: language
Subtag: pbe
Description: Mezontla Popoloca
Added: 2009-07-29
%%
Type: language
Subtag: pbf
Description: Coyotepec Popoloca
Added: 2009-07-29
%%
Type: language
Subtag: pbg
Description: Paraujano
Added: 2009-07-29
%%
Type: language
Subtag: pbh
Description: E'ñapa Woromaipu
Added: 2009-07-29
%%
Type: language
Subtag: pbi
Description: Parkwa
Added: 2009-07-29
%%
Type: language
Subtag: pbl
Description: Mak (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: pbm
Description: Puebla Mazatec
Added: 2018-03-08
Comments: see also maa
%%
Type: language
Subtag: pbn
Description: Kpasam
Added: 2009-07-29
%%
Type: language
Subtag: pbo
Description: Papel
Added: 2009-07-29
%%
Type: language
Subtag: pbp
Description: Badyara
Added: 2009-07-29
%%
Type: language
Subtag: pbr
Description: Pangwa
Added: 2009-07-29
%%
Type: language
Subtag: pbs
Description: Central Pame
Added: 2009-07-29
%%
Type: language
Subtag: pbt
Description: Southern Pashto
Added: 2009-07-29
Macrolanguage: ps
%%
Type: language
Subtag: pbu
Description: Northern Pashto
Added: 2009-07-29
Macrolanguage: ps
%%
Type: language
Subtag: pbv
Description: Pnar
Added: 2009-07-29
%%
Type: language
Subtag: pby
Description: Pyu (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: pbz
Description: Palu
Added: 2009-07-29
Deprecated: 2012-08-12
%%
Type: language
Subtag: pca
Description: Santa Inés Ahuatempan Popoloca
Added: 2009-07-29
%%
Type: language
Subtag: pcb
Description: Pear
Added: 2009-07-29
%%
Type: language
Subtag: pcc
Description: Bouyei
Added: 2009-07-29
%%
Type: language
Subtag: pcd
Description: Picard
Added: 2009-07-29
%%
Type: language
Subtag: pce
Description: Ruching Palaung
Added: 2009-07-29
%%
Type: language
Subtag: pcf
Description: Paliyan
Added: 2009-07-29
%%
Type: language
Subtag: pcg
Description: Paniya
Added: 2009-07-29
%%
Type: language
Subtag: pch
Description: Pardhan
Added: 2009-07-29
%%
Type: language
Subtag: pci
Description: Duruwa
Added: 2009-07-29
%%
Type: language
Subtag: pcj
Description: Parenga
Added: 2009-07-29
%%
Type: language
Subtag: pck
Description: Paite Chin
Added: 2009-07-29
%%
Type: language
Subtag: pcl
Description: Pardhi
Added: 2009-07-29
%%
Type: language
Subtag: pcm
Description: Nigerian Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: pcn
Description: Piti
Added: 2009-07-29
%%
Type: language
Subtag: pcp
Description: Pacahuara
Added: 2009-07-29
%%
Type: language
Subtag: pcr
Description: Panang
Added: 2009-07-29
Deprecated: 2013-09-10
Preferred-Value: adx
%%
Type: language
Subtag: pcw
Description: Pyapun
Added: 2009-07-29
%%
Type: language
Subtag: pda
Description: Anam
Added: 2009-07-29
%%
Type: language
Subtag: pdc
Description: Pennsylvania German
Added: 2009-07-29
%%
Type: language
Subtag: pdi
Description: Pa Di
Added: 2009-07-29
%%
Type: language
Subtag: pdn
Description: Podena
Description: Fedan
Added: 2009-07-29
%%
Type: language
Subtag: pdo
Description: Padoe
Added: 2009-07-29
%%
Type: language
Subtag: pdt
Description: Plautdietsch
Added: 2009-07-29
%%
Type: language
Subtag: pdu
Description: Kayan
Added: 2009-07-29
%%
Type: language
Subtag: pea
Description: Peranakan Indonesian
Added: 2009-07-29
%%
Type: language
Subtag: peb
Description: Eastern Pomo
Added: 2009-07-29
%%
Type: language
Subtag: ped
Description: Mala (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: pee
Description: Taje
Added: 2009-07-29
%%
Type: language
Subtag: pef
Description: Northeastern Pomo
Added: 2009-07-29
%%
Type: language
Subtag: peg
Description: Pengo
Added: 2009-07-29
%%
Type: language
Subtag: peh
Description: Bonan
Added: 2009-07-29
%%
Type: language
Subtag: pei
Description: Chichimeca-Jonaz
Added: 2009-07-29
%%
Type: language
Subtag: pej
Description: Northern Pomo
Added: 2009-07-29
%%
Type: language
Subtag: pek
Description: Penchal
Added: 2009-07-29
%%
Type: language
Subtag: pel
Description: Pekal
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: pem
Description: Phende
Added: 2009-07-29
%%
Type: language
Subtag: peo
Description: Old Persian (ca. 600-400 B.C.)
Added: 2005-10-16
%%
Type: language
Subtag: pep
Description: Kunja
Added: 2009-07-29
%%
Type: language
Subtag: peq
Description: Southern Pomo
Added: 2009-07-29
%%
Type: language
Subtag: pes
Description: Iranian Persian
Added: 2009-07-29
Macrolanguage: fa
%%
Type: language
Subtag: pev
Description: Pémono
Added: 2009-07-29
%%
Type: language
Subtag: pex
Description: Petats
Added: 2009-07-29
%%
Type: language
Subtag: pey
Description: Petjo
Added: 2009-07-29
%%
Type: language
Subtag: pez
Description: Eastern Penan
Added: 2009-07-29
%%
Type: language
Subtag: pfa
Description: Pááfang
Added: 2009-07-29
%%
Type: language
Subtag: pfe
Description: Peere
Added: 2009-07-29
%%
Type: language
Subtag: pfl
Description: Pfaelzisch
Added: 2009-07-29
%%
Type: language
Subtag: pga
Description: Sudanese Creole Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: pgd
Description: Gāndhārī
Added: 2015-02-12
%%
Type: language
Subtag: pgg
Description: Pangwali
Added: 2009-07-29
%%
Type: language
Subtag: pgi
Description: Pagi
Added: 2009-07-29
%%
Type: language
Subtag: pgk
Description: Rerep
Added: 2009-07-29
%%
Type: language
Subtag: pgl
Description: Primitive Irish
Added: 2011-08-16
%%
Type: language
Subtag: pgn
Description: Paelignian
Added: 2009-07-29
%%
Type: language
Subtag: pgs
Description: Pangseng
Added: 2009-07-29
%%
Type: language
Subtag: pgu
Description: Pagu
Added: 2009-07-29
%%
Type: language
Subtag: pgy
Description: Pongyong
Added: 2009-07-29
Deprecated: 2012-08-12
%%
Type: language
Subtag: pgz
Description: Papua New Guinean Sign Language
Added: 2016-05-30
%%
Type: language
Subtag: pha
Description: Pa-Hng
Added: 2009-07-29
%%
Type: language
Subtag: phd
Description: Phudagi
Added: 2009-07-29
%%
Type: language
Subtag: phg
Description: Phuong
Added: 2009-07-29
%%
Type: language
Subtag: phh
Description: Phukha
Added: 2009-07-29
%%
Type: language
Subtag: phi
Description: Philippine languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: phk
Description: Phake
Added: 2009-07-29
%%
Type: language
Subtag: phl
Description: Phalura
Description: Palula
Added: 2009-07-29
%%
Type: language
Subtag: phm
Description: Phimbi
Added: 2009-07-29
%%
Type: language
Subtag: phn
Description: Phoenician
Added: 2005-10-16
%%
Type: language
Subtag: pho
Description: Phunoi
Added: 2009-07-29
%%
Type: language
Subtag: phq
Description: Phana'
Added: 2009-07-29
%%
Type: language
Subtag: phr
Description: Pahari-Potwari
Added: 2009-07-29
Macrolanguage: lah
%%
Type: language
Subtag: pht
Description: Phu Thai
Added: 2009-07-29
%%
Type: language
Subtag: phu
Description: Phuan
Added: 2009-07-29
%%
Type: language
Subtag: phv
Description: Pahlavani
Added: 2009-07-29
%%
Type: language
Subtag: phw
Description: Phangduwali
Added: 2009-07-29
%%
Type: language
Subtag: pia
Description: Pima Bajo
Added: 2009-07-29
%%
Type: language
Subtag: pib
Description: Yine
Added: 2009-07-29
%%
Type: language
Subtag: pic
Description: Pinji
Added: 2009-07-29
%%
Type: language
Subtag: pid
Description: Piaroa
Added: 2009-07-29
%%
Type: language
Subtag: pie
Description: Piro
Added: 2009-07-29
%%
Type: language
Subtag: pif
Description: Pingelapese
Added: 2009-07-29
%%
Type: language
Subtag: pig
Description: Pisabo
Added: 2009-07-29
%%
Type: language
Subtag: pih
Description: Pitcairn-Norfolk
Added: 2009-07-29
%%
Type: language
Subtag: pii
Description: Pini
Added: 2009-07-29
%%
Type: language
Subtag: pij
Description: Pijao
Added: 2009-07-29
%%
Type: language
Subtag: pil
Description: Yom
Added: 2009-07-29
%%
Type: language
Subtag: pim
Description: Powhatan
Added: 2009-07-29
%%
Type: language
Subtag: pin
Description: Piame
Added: 2009-07-29
%%
Type: language
Subtag: pio
Description: Piapoco
Added: 2009-07-29
%%
Type: language
Subtag: pip
Description: Pero
Added: 2009-07-29
%%
Type: language
Subtag: pir
Description: Piratapuyo
Added: 2009-07-29
%%
Type: language
Subtag: pis
Description: Pijin
Added: 2009-07-29
%%
Type: language
Subtag: pit
Description: Pitta Pitta
Added: 2009-07-29
%%
Type: language
Subtag: piu
Description: Pintupi-Luritja
Added: 2009-07-29
%%
Type: language
Subtag: piv
Description: Pileni
Description: Vaeakau-Taumako
Added: 2009-07-29
%%
Type: language
Subtag: piw
Description: Pimbwe
Added: 2009-07-29
%%
Type: language
Subtag: pix
Description: Piu
Added: 2009-07-29
%%
Type: language
Subtag: piy
Description: Piya-Kwonci
Added: 2009-07-29
%%
Type: language
Subtag: piz
Description: Pije
Added: 2009-07-29
%%
Type: language
Subtag: pjt
Description: Pitjantjatjara
Added: 2009-07-29
%%
Type: language
Subtag: pka
Description: Ardhamāgadhī Prākrit
Added: 2009-07-29
%%
Type: language
Subtag: pkb
Description: Pokomo
Description: Kipfokomo
Added: 2009-07-29
%%
Type: language
Subtag: pkc
Description: Paekche
Added: 2009-07-29
%%
Type: language
Subtag: pkg
Description: Pak-Tong
Added: 2009-07-29
%%
Type: language
Subtag: pkh
Description: Pankhu
Added: 2009-07-29
%%
Type: language
Subtag: pkn
Description: Pakanha
Added: 2009-07-29
%%
Type: language
Subtag: pko
Description: Pökoot
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: pkp
Description: Pukapuka
Added: 2009-07-29
%%
Type: language
Subtag: pkr
Description: Attapady Kurumba
Added: 2009-07-29
%%
Type: language
Subtag: pks
Description: Pakistan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: pkt
Description: Maleng
Added: 2009-07-29
%%
Type: language
Subtag: pku
Description: Paku
Added: 2009-07-29
%%
Type: language
Subtag: pla
Description: Miani
Added: 2009-07-29
%%
Type: language
Subtag: plb
Description: Polonombauk
Added: 2009-07-29
%%
Type: language
Subtag: plc
Description: Central Palawano
Added: 2009-07-29
%%
Type: language
Subtag: pld
Description: Polari
Added: 2009-07-29
%%
Type: language
Subtag: ple
Description: Palu'e
Added: 2009-07-29
%%
Type: language
Subtag: plf
Description: Central Malayo-Polynesian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: plg
Description: Pilagá
Added: 2009-07-29
%%
Type: language
Subtag: plh
Description: Paulohi
Added: 2009-07-29
%%
Type: language
Subtag: plj
Description: Polci
Added: 2009-07-29
%%
Type: language
Subtag: plk
Description: Kohistani Shina
Added: 2009-07-29
%%
Type: language
Subtag: pll
Description: Shwe Palaung
Added: 2009-07-29
%%
Type: language
Subtag: pln
Description: Palenquero
Added: 2009-07-29
%%
Type: language
Subtag: plo
Description: Oluta Popoluca
Added: 2009-07-29
%%
Type: language
Subtag: plp
Description: Palpa
Added: 2009-07-29
%%
Type: language
Subtag: plq
Description: Palaic
Added: 2009-07-29
%%
Type: language
Subtag: plr
Description: Palaka Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: pls
Description: San Marcos Tlacoyalco Popoloca
Description: San Marcos Tlalcoyalco Popoloca
Added: 2009-07-29
%%
Type: language
Subtag: plt
Description: Plateau Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: plu
Description: Palikúr
Added: 2009-07-29
%%
Type: language
Subtag: plv
Description: Southwest Palawano
Added: 2009-07-29
%%
Type: language
Subtag: plw
Description: Brooke's Point Palawano
Added: 2009-07-29
%%
Type: language
Subtag: ply
Description: Bolyu
Added: 2009-07-29
%%
Type: language
Subtag: plz
Description: Paluan
Added: 2009-07-29
%%
Type: language
Subtag: pma
Description: Paama
Added: 2009-07-29
%%
Type: language
Subtag: pmb
Description: Pambia
Added: 2009-07-29
%%
Type: language
Subtag: pmc
Description: Palumata
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: huw
%%
Type: language
Subtag: pmd
Description: Pallanganmiddang
Added: 2012-08-12
%%
Type: language
Subtag: pme
Description: Pwaamei
Added: 2009-07-29
%%
Type: language
Subtag: pmf
Description: Pamona
Added: 2009-07-29
%%
Type: language
Subtag: pmh
Description: Māhārāṣṭri Prākrit
Added: 2009-07-29
%%
Type: language
Subtag: pmi
Description: Northern Pumi
Added: 2009-07-29
%%
Type: language
Subtag: pmj
Description: Southern Pumi
Added: 2009-07-29
%%
Type: language
Subtag: pmk
Description: Pamlico
Added: 2009-07-29
%%
Type: language
Subtag: pml
Description: Lingua Franca
Added: 2009-07-29
%%
Type: language
Subtag: pmm
Description: Pomo
Added: 2009-07-29
%%
Type: language
Subtag: pmn
Description: Pam
Added: 2009-07-29
%%
Type: language
Subtag: pmo
Description: Pom
Added: 2009-07-29
%%
Type: language
Subtag: pmq
Description: Northern Pame
Added: 2009-07-29
%%
Type: language
Subtag: pmr
Description: Paynamar
Added: 2009-07-29
%%
Type: language
Subtag: pms
Description: Piemontese
Added: 2009-07-29
%%
Type: language
Subtag: pmt
Description: Tuamotuan
Added: 2009-07-29
%%
Type: language
Subtag: pmu
Description: Mirpur Panjabi
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: phr
Macrolanguage: lah
%%
Type: language
Subtag: pmw
Description: Plains Miwok
Added: 2009-07-29
%%
Type: language
Subtag: pmx
Description: Poumei Naga
Added: 2009-07-29
%%
Type: language
Subtag: pmy
Description: Papuan Malay
Added: 2009-07-29
%%
Type: language
Subtag: pmz
Description: Southern Pame
Added: 2009-07-29
%%
Type: language
Subtag: pna
Description: Punan Bah-Biau
Added: 2009-07-29
%%
Type: language
Subtag: pnb
Description: Western Panjabi
Added: 2009-07-29
Macrolanguage: lah
%%
Type: language
Subtag: pnc
Description: Pannei
Added: 2009-07-29
%%
Type: language
Subtag: pnd
Description: Mpinda
Added: 2019-04-16
%%
Type: language
Subtag: pne
Description: Western Penan
Added: 2009-07-29
%%
Type: language
Subtag: png
Description: Pongu
Added: 2009-07-29
%%
Type: language
Subtag: pnh
Description: Penrhyn
Added: 2009-07-29
%%
Type: language
Subtag: pni
Description: Aoheng
Added: 2009-07-29
%%
Type: language
Subtag: pnj
Description: Pinjarup
Added: 2013-09-10
%%
Type: language
Subtag: pnk
Description: Paunaka
Added: 2012-08-12
%%
Type: language
Subtag: pnl
Description: Paleni
Added: 2013-09-10
Comments: see also wbf
%%
Type: language
Subtag: pnm
Description: Punan Batu 1
Added: 2009-07-29
%%
Type: language
Subtag: pnn
Description: Pinai-Hagahai
Added: 2009-07-29
%%
Type: language
Subtag: pno
Description: Panobo
Added: 2009-07-29
%%
Type: language
Subtag: pnp
Description: Pancana
Added: 2009-07-29
%%
Type: language
Subtag: pnq
Description: Pana (Burkina Faso)
Added: 2009-07-29
%%
Type: language
Subtag: pnr
Description: Panim
Added: 2009-07-29
%%
Type: language
Subtag: pns
Description: Ponosakan
Added: 2009-07-29
%%
Type: language
Subtag: pnt
Description: Pontic
Added: 2009-07-29
%%
Type: language
Subtag: pnu
Description: Jiongnai Bunu
Added: 2009-07-29
%%
Type: language
Subtag: pnv
Description: Pinigura
Added: 2009-07-29
%%
Type: language
Subtag: pnw
Description: Banyjima
Description: Panytyima
Added: 2009-07-29
%%
Type: language
Subtag: pnx
Description: Phong-Kniang
Added: 2009-07-29
%%
Type: language
Subtag: pny
Description: Pinyin
Added: 2009-07-29
Comments: a Niger-Congo language spoken in Cameroon; not to be confused
  with the Pinyin romanization systems used for Chinese and Tibetan
%%
Type: language
Subtag: pnz
Description: Pana (Central African Republic)
Added: 2009-07-29
%%
Type: language
Subtag: poc
Description: Poqomam
Added: 2009-07-29
%%
Type: language
Subtag: pod
Description: Ponares
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: poe
Description: San Juan Atzingo Popoloca
Added: 2009-07-29
%%
Type: language
Subtag: pof
Description: Poke
Added: 2009-07-29
%%
Type: language
Subtag: pog
Description: Potiguára
Added: 2009-07-29
%%
Type: language
Subtag: poh
Description: Poqomchi'
Added: 2009-07-29
%%
Type: language
Subtag: poi
Description: Highland Popoluca
Added: 2009-07-29
%%
Type: language
Subtag: pok
Description: Pokangá
Added: 2009-07-29
%%
Type: language
Subtag: pom
Description: Southeastern Pomo
Added: 2009-07-29
%%
Type: language
Subtag: pon
Description: Pohnpeian
Added: 2005-10-16
%%
Type: language
Subtag: poo
Description: Central Pomo
Added: 2009-07-29
%%
Type: language
Subtag: pop
Description: Pwapwâ
Added: 2009-07-29
%%
Type: language
Subtag: poq
Description: Texistepec Popoluca
Added: 2009-07-29
%%
Type: language
Subtag: pos
Description: Sayula Popoluca
Added: 2009-07-29
%%
Type: language
Subtag: pot
Description: Potawatomi
Added: 2009-07-29
%%
Type: language
Subtag: pov
Description: Upper Guinea Crioulo
Added: 2009-07-29
%%
Type: language
Subtag: pow
Description: San Felipe Otlaltepec Popoloca
Added: 2009-07-29
%%
Type: language
Subtag: pox
Description: Polabian
Added: 2009-07-29
%%
Type: language
Subtag: poy
Description: Pogolo
Added: 2009-07-29
%%
Type: language
Subtag: poz
Description: Malayo-Polynesian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: ppa
Description: Pao
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: bfy
%%
Type: language
Subtag: ppe
Description: Papi
Added: 2009-07-29
%%
Type: language
Subtag: ppi
Description: Paipai
Added: 2009-07-29
%%
Type: language
Subtag: ppk
Description: Uma
Added: 2009-07-29
%%
Type: language
Subtag: ppl
Description: Pipil
Description: Nicarao
Added: 2009-07-29
%%
Type: language
Subtag: ppm
Description: Papuma
Added: 2009-07-29
%%
Type: language
Subtag: ppn
Description: Papapana
Added: 2009-07-29
%%
Type: language
Subtag: ppo
Description: Folopa
Added: 2009-07-29
%%
Type: language
Subtag: ppp
Description: Pelende
Added: 2009-07-29
%%
Type: language
Subtag: ppq
Description: Pei
Added: 2009-07-29
%%
Type: language
Subtag: ppr
Description: Piru
Added: 2009-07-29
Deprecated: 2013-09-10
Preferred-Value: lcq
%%
Type: language
Subtag: pps
Description: San Luís Temalacayuca Popoloca
Added: 2009-07-29
%%
Type: language
Subtag: ppt
Description: Pare
Added: 2009-07-29
%%
Type: language
Subtag: ppu
Description: Papora
Added: 2009-07-29
%%
Type: language
Subtag: pqa
Description: Pa'a
Added: 2009-07-29
%%
Type: language
Subtag: pqe
Description: Eastern Malayo-Polynesian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: pqm
Description: Malecite-Passamaquoddy
Added: 2009-07-29
%%
Type: language
Subtag: pqw
Description: Western Malayo-Polynesian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: pra
Description: Prakrit languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: prb
Description: Lua'
Added: 2009-07-29
Deprecated: 2017-02-23
%%
Type: language
Subtag: prc
Description: Parachi
Added: 2009-07-29
%%
Type: language
Subtag: prd
Description: Parsi-Dari
Added: 2009-07-29
%%
Type: language
Subtag: pre
Description: Principense
Added: 2009-07-29
%%
Type: language
Subtag: prf
Description: Paranan
Added: 2010-03-11
%%
Type: language
Subtag: prg
Description: Prussian
Added: 2009-07-29
%%
Type: language
Subtag: prh
Description: Porohanon
Added: 2009-07-29
%%
Type: language
Subtag: pri
Description: Paicî
Added: 2009-07-29
%%
Type: language
Subtag: prk
Description: Parauk
Added: 2009-07-29
%%
Type: language
Subtag: prl
Description: Peruvian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: prm
Description: Kibiri
Added: 2009-07-29
%%
Type: language
Subtag: prn
Description: Prasuni
Added: 2009-07-29
%%
Type: language
Subtag: pro
Description: Old Provençal (to 1500)
Description: Old Occitan (to 1500)
Added: 2005-10-16
%%
Type: language
Subtag: prp
Description: Parsi
Added: 2009-07-29
%%
Type: language
Subtag: prq
Description: Ashéninka Perené
Added: 2009-07-29
%%
Type: language
Subtag: prr
Description: Puri
Added: 2009-07-29
%%
Type: language
Subtag: prs
Description: Dari
Description: Afghan Persian
Added: 2009-07-29
Macrolanguage: fa
%%
Type: language
Subtag: prt
Description: Phai
Added: 2009-07-29
%%
Type: language
Subtag: pru
Description: Puragi
Added: 2009-07-29
%%
Type: language
Subtag: prw
Description: Parawen
Added: 2009-07-29
%%
Type: language
Subtag: prx
Description: Purik
Added: 2009-07-29
%%
Type: language
Subtag: pry
Description: Pray 3
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: prt
%%
Type: language
Subtag: prz
Description: Providencia Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: psa
Description: Asue Awyu
Added: 2009-07-29
%%
Type: language
Subtag: psc
Description: Persian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: psd
Description: Plains Indian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: pse
Description: Central Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: psg
Description: Penang Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: psh
Description: Southwest Pashai
Description: Southwest Pashayi
Added: 2009-07-29
%%
Type: language
Subtag: psi
Description: Southeast Pashai
Description: Southeast Pashayi
Added: 2009-07-29
%%
Type: language
Subtag: psl
Description: Puerto Rican Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: psm
Description: Pauserna
Added: 2009-07-29
%%
Type: language
Subtag: psn
Description: Panasuan
Added: 2009-07-29
%%
Type: language
Subtag: pso
Description: Polish Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: psp
Description: Philippine Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: psq
Description: Pasi
Added: 2009-07-29
%%
Type: language
Subtag: psr
Description: Portuguese Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: pss
Description: Kaulong
Added: 2009-07-29
%%
Type: language
Subtag: pst
Description: Central Pashto
Added: 2009-07-29
Macrolanguage: ps
%%
Type: language
Subtag: psu
Description: Sauraseni Prākrit
Added: 2009-07-29
%%
Type: language
Subtag: psw
Description: Port Sandwich
Added: 2009-07-29
%%
Type: language
Subtag: psy
Description: Piscataway
Added: 2009-07-29
%%
Type: language
Subtag: pta
Description: Pai Tavytera
Added: 2009-07-29
%%
Type: language
Subtag: pth
Description: Pataxó Hã-Ha-Hãe
Added: 2009-07-29
%%
Type: language
Subtag: pti
Description: Pindiini
Description: Wangkatha
Added: 2009-07-29
%%
Type: language
Subtag: ptn
Description: Patani
Added: 2009-07-29
%%
Type: language
Subtag: pto
Description: Zo'é
Added: 2009-07-29
%%
Type: language
Subtag: ptp
Description: Patep
Added: 2009-07-29
%%
Type: language
Subtag: ptq
Description: Pattapu
Added: 2014-04-06
%%
Type: language
Subtag: ptr
Description: Piamatsina
Added: 2009-07-29
%%
Type: language
Subtag: ptt
Description: Enrekang
Added: 2009-07-29
%%
Type: language
Subtag: ptu
Description: Bambam
Added: 2009-07-29
%%
Type: language
Subtag: ptv
Description: Port Vato
Added: 2009-07-29
%%
Type: language
Subtag: ptw
Description: Pentlatch
Added: 2009-07-29
%%
Type: language
Subtag: pty
Description: Pathiya
Added: 2009-07-29
%%
Type: language
Subtag: pua
Description: Western Highland Purepecha
Added: 2009-07-29
%%
Type: language
Subtag: pub
Description: Purum
Added: 2009-07-29
%%
Type: language
Subtag: puc
Description: Punan Merap
Added: 2009-07-29
%%
Type: language
Subtag: pud
Description: Punan Aput
Added: 2009-07-29
%%
Type: language
Subtag: pue
Description: Puelche
Added: 2009-07-29
%%
Type: language
Subtag: puf
Description: Punan Merah
Added: 2009-07-29
%%
Type: language
Subtag: pug
Description: Phuie
Added: 2009-07-29
%%
Type: language
Subtag: pui
Description: Puinave
Added: 2009-07-29
%%
Type: language
Subtag: puj
Description: Punan Tubu
Added: 2009-07-29
%%
Type: language
Subtag: puk
Description: Pu Ko
Added: 2009-07-29
Deprecated: 2017-02-23
%%
Type: language
Subtag: pum
Description: Puma
Added: 2009-07-29
%%
Type: language
Subtag: puo
Description: Puoc
Added: 2009-07-29
%%
Type: language
Subtag: pup
Description: Pulabu
Added: 2009-07-29
%%
Type: language
Subtag: puq
Description: Puquina
Added: 2009-07-29
%%
Type: language
Subtag: pur
Description: Puruborá
Added: 2009-07-29
%%
Type: language
Subtag: put
Description: Putoh
Added: 2009-07-29
%%
Type: language
Subtag: puu
Description: Punu
Added: 2009-07-29
%%
Type: language
Subtag: puw
Description: Puluwatese
Added: 2009-07-29
%%
Type: language
Subtag: pux
Description: Puare
Added: 2009-07-29
%%
Type: language
Subtag: puy
Description: Purisimeño
Added: 2009-07-29
%%
Type: language
Subtag: puz
Description: Purum Naga
Added: 2009-07-29
Deprecated: 2014-02-28
Preferred-Value: pub
%%
Type: language
Subtag: pwa
Description: Pawaia
Added: 2009-07-29
%%
Type: language
Subtag: pwb
Description: Panawa
Added: 2009-07-29
%%
Type: language
Subtag: pwg
Description: Gapapaiwa
Added: 2009-07-29
%%
Type: language
Subtag: pwi
Description: Patwin
Added: 2013-09-10
%%
Type: language
Subtag: pwm
Description: Molbog
Added: 2009-07-29
%%
Type: language
Subtag: pwn
Description: Paiwan
Added: 2009-07-29
%%
Type: language
Subtag: pwo
Description: Pwo Western Karen
Added: 2009-07-29
%%
Type: language
Subtag: pwr
Description: Powari
Added: 2009-07-29
%%
Type: language
Subtag: pww
Description: Pwo Northern Karen
Added: 2009-07-29
%%
Type: language
Subtag: pxm
Description: Quetzaltepec Mixe
Added: 2009-07-29
%%
Type: language
Subtag: pye
Description: Pye Krumen
Added: 2009-07-29
%%
Type: language
Subtag: pym
Description: Fyam
Added: 2009-07-29
%%
Type: language
Subtag: pyn
Description: Poyanáwa
Added: 2009-07-29
%%
Type: language
Subtag: pys
Description: Paraguayan Sign Language
Description: Lengua de Señas del Paraguay
Added: 2010-03-11
%%
Type: language
Subtag: pyu
Description: Puyuma
Added: 2009-07-29
%%
Type: language
Subtag: pyx
Description: Pyu (Myanmar)
Added: 2009-07-29
%%
Type: language
Subtag: pyy
Description: Pyen
Added: 2009-07-29
%%
Type: language
Subtag: pzn
Description: Para Naga
Added: 2009-07-29
%%
Type: language
Subtag: qaa..qtz
Description: Private use
Added: 2005-10-16
Scope: private-use
%%
Type: language
Subtag: qua
Description: Quapaw
Added: 2009-07-29
%%
Type: language
Subtag: qub
Description: Huallaga Huánuco Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: quc
Description: K'iche'
Description: Quiché
Added: 2009-07-29
%%
Type: language
Subtag: qud
Description: Calderón Highland Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: quf
Description: Lambayeque Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qug
Description: Chimborazo Highland Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: quh
Description: South Bolivian Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qui
Description: Quileute
Added: 2009-07-29
%%
Type: language
Subtag: quk
Description: Chachapoyas Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qul
Description: North Bolivian Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qum
Description: Sipacapense
Added: 2009-07-29
%%
Type: language
Subtag: qun
Description: Quinault
Added: 2009-07-29
%%
Type: language
Subtag: qup
Description: Southern Pastaza Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: quq
Description: Quinqui
Added: 2009-07-29
%%
Type: language
Subtag: qur
Description: Yanahuanca Pasco Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qus
Description: Santiago del Estero Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: quv
Description: Sacapulteco
Added: 2009-07-29
%%
Type: language
Subtag: quw
Description: Tena Lowland Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qux
Description: Yauyos Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: quy
Description: Ayacucho Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: quz
Description: Cusco Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qva
Description: Ambo-Pasco Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvc
Description: Cajamarca Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qve
Description: Eastern Apurímac Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvh
Description: Huamalíes-Dos de Mayo Huánuco Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvi
Description: Imbabura Highland Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvj
Description: Loja Highland Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvl
Description: Cajatambo North Lima Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvm
Description: Margos-Yarowilca-Lauricocha Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvn
Description: North Junín Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvo
Description: Napo Lowland Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvp
Description: Pacaraos Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvs
Description: San Martín Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvw
Description: Huaylla Wanca Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qvy
Description: Queyu
Added: 2009-07-29
%%
Type: language
Subtag: qvz
Description: Northern Pastaza Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qwa
Description: Corongo Ancash Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qwc
Description: Classical Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qwe
Description: Quechuan (family)
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: qwh
Description: Huaylas Ancash Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qwm
Description: Kuman (Russia)
Added: 2009-07-29
%%
Type: language
Subtag: qws
Description: Sihuas Ancash Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qwt
Description: Kwalhioqua-Tlatskanai
Added: 2009-07-29
%%
Type: language
Subtag: qxa
Description: Chiquián Ancash Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxc
Description: Chincha Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxh
Description: Panao Huánuco Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxl
Description: Salasaca Highland Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxn
Description: Northern Conchucos Ancash Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxo
Description: Southern Conchucos Ancash Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxp
Description: Puno Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxq
Description: Qashqa'i
Added: 2009-07-29
%%
Type: language
Subtag: qxr
Description: Cañar Highland Quichua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxs
Description: Southern Qiang
Added: 2009-07-29
%%
Type: language
Subtag: qxt
Description: Santa Ana de Tusi Pasco Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxu
Description: Arequipa-La Unión Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qxw
Description: Jauja Wanca Quechua
Added: 2009-07-29
Macrolanguage: qu
%%
Type: language
Subtag: qya
Description: Quenya
Added: 2009-07-29
%%
Type: language
Subtag: qyp
Description: Quiripi
Added: 2009-07-29
%%
Type: language
Subtag: raa
Description: Dungmali
Added: 2009-07-29
%%
Type: language
Subtag: rab
Description: Camling
Added: 2009-07-29
%%
Type: language
Subtag: rac
Description: Rasawa
Added: 2009-07-29
%%
Type: language
Subtag: rad
Description: Rade
Added: 2009-07-29
%%
Type: language
Subtag: raf
Description: Western Meohang
Added: 2009-07-29
%%
Type: language
Subtag: rag
Description: Logooli
Description: Lulogooli
Added: 2009-07-29
Macrolanguage: luy
%%
Type: language
Subtag: rah
Description: Rabha
Added: 2009-07-29
%%
Type: language
Subtag: rai
Description: Ramoaaina
Added: 2009-07-29
%%
Type: language
Subtag: raj
Description: Rajasthani
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: rak
Description: Tulu-Bohuai
Added: 2009-07-29
%%
Type: language
Subtag: ral
Description: Ralte
Added: 2009-07-29
%%
Type: language
Subtag: ram
Description: Canela
Added: 2009-07-29
%%
Type: language
Subtag: ran
Description: Riantana
Added: 2009-07-29
%%
Type: language
Subtag: rao
Description: Rao
Added: 2009-07-29
%%
Type: language
Subtag: rap
Description: Rapanui
Added: 2005-10-16
%%
Type: language
Subtag: raq
Description: Saam
Added: 2009-07-29
%%
Type: language
Subtag: rar
Description: Rarotongan
Description: Cook Islands Maori
Added: 2005-10-16
%%
Type: language
Subtag: ras
Description: Tegali
Added: 2009-07-29
%%
Type: language
Subtag: rat
Description: Razajerdi
Added: 2009-07-29
%%
Type: language
Subtag: rau
Description: Raute
Added: 2009-07-29
%%
Type: language
Subtag: rav
Description: Sampang
Added: 2009-07-29
%%
Type: language
Subtag: raw
Description: Rawang
Added: 2009-07-29
%%
Type: language
Subtag: rax
Description: Rang
Added: 2009-07-29
%%
Type: language
Subtag: ray
Description: Rapa
Added: 2009-07-29
%%
Type: language
Subtag: raz
Description: Rahambuu
Added: 2009-07-29
%%
Type: language
Subtag: rbb
Description: Rumai Palaung
Added: 2009-07-29
%%
Type: language
Subtag: rbk
Description: Northern Bontok
Added: 2010-03-11
Macrolanguage: bnc
%%
Type: language
Subtag: rbl
Description: Miraya Bikol
Added: 2010-03-11
Macrolanguage: bik
%%
Type: language
Subtag: rbp
Description: Barababaraba
Added: 2012-08-12
%%
Type: language
Subtag: rcf
Description: Réunion Creole French
Added: 2009-07-29
%%
Type: language
Subtag: rdb
Description: Rudbari
Added: 2009-07-29
%%
Type: language
Subtag: rea
Description: Rerau
Added: 2009-07-29
%%
Type: language
Subtag: reb
Description: Rembong
Added: 2009-07-29
%%
Type: language
Subtag: ree
Description: Rejang Kayan
Added: 2009-07-29
%%
Type: language
Subtag: reg
Description: Kara (Tanzania)
Added: 2009-07-29
%%
Type: language
Subtag: rei
Description: Reli
Added: 2009-07-29
%%
Type: language
Subtag: rej
Description: Rejang
Added: 2009-07-29
%%
Type: language
Subtag: rel
Description: Rendille
Added: 2009-07-29
%%
Type: language
Subtag: rem
Description: Remo
Added: 2009-07-29
%%
Type: language
Subtag: ren
Description: Rengao
Added: 2009-07-29
%%
Type: language
Subtag: rer
Description: Rer Bare
Added: 2009-07-29
%%
Type: language
Subtag: res
Description: Reshe
Added: 2009-07-29
%%
Type: language
Subtag: ret
Description: Retta
Added: 2009-07-29
%%
Type: language
Subtag: rey
Description: Reyesano
Added: 2009-07-29
%%
Type: language
Subtag: rga
Description: Roria
Added: 2009-07-29
%%
Type: language
Subtag: rge
Description: Romano-Greek
Added: 2009-07-29
%%
Type: language
Subtag: rgk
Description: Rangkas
Added: 2009-07-29
%%
Type: language
Subtag: rgn
Description: Romagnol
Added: 2009-07-29
%%
Type: language
Subtag: rgr
Description: Resígaro
Added: 2009-07-29
%%
Type: language
Subtag: rgs
Description: Southern Roglai
Added: 2009-07-29
%%
Type: language
Subtag: rgu
Description: Ringgou
Added: 2009-07-29
%%
Type: language
Subtag: rhg
Description: Rohingya
Added: 2009-07-29
%%
Type: language
Subtag: rhp
Description: Yahang
Added: 2009-07-29
%%
Type: language
Subtag: ria
Description: Riang (India)
Added: 2009-07-29
%%
Type: language
Subtag: rie
Description: Rien
Added: 2009-07-29
Deprecated: 2017-02-23
%%
Type: language
Subtag: rif
Description: Tarifit
Added: 2009-07-29
%%
Type: language
Subtag: ril
Description: Riang Lang
Description: Riang (Myanmar)
Added: 2009-07-29
%%
Type: language
Subtag: rim
Description: Nyaturu
Added: 2009-07-29
%%
Type: language
Subtag: rin
Description: Nungu
Added: 2009-07-29
%%
Type: language
Subtag: rir
Description: Ribun
Added: 2009-07-29
%%
Type: language
Subtag: rit
Description: Ritharrngu
Added: 2009-07-29
%%
Type: language
Subtag: riu
Description: Riung
Added: 2009-07-29
%%
Type: language
Subtag: rjg
Description: Rajong
Added: 2009-07-29
%%
Type: language
Subtag: rji
Description: Raji
Added: 2009-07-29
%%
Type: language
Subtag: rjs
Description: Rajbanshi
Added: 2009-07-29
%%
Type: language
Subtag: rka
Description: Kraol
Added: 2009-07-29
%%
Type: language
Subtag: rkb
Description: Rikbaktsa
Added: 2009-07-29
%%
Type: language
Subtag: rkh
Description: Rakahanga-Manihiki
Added: 2009-07-29
%%
Type: language
Subtag: rki
Description: Rakhine
Added: 2009-07-29
%%
Type: language
Subtag: rkm
Description: Marka
Added: 2009-07-29
%%
Type: language
Subtag: rkt
Description: Rangpuri
Description: Kamta
Added: 2009-07-29
%%
Type: language
Subtag: rkw
Description: Arakwal
Added: 2013-09-10
%%
Type: language
Subtag: rma
Description: Rama
Added: 2009-07-29
%%
Type: language
Subtag: rmb
Description: Rembarrnga
Added: 2009-07-29
%%
Type: language
Subtag: rmc
Description: Carpathian Romani
Added: 2009-07-29
Macrolanguage: rom
%%
Type: language
Subtag: rmd
Description: Traveller Danish
Added: 2009-07-29
%%
Type: language
Subtag: rme
Description: Angloromani
Added: 2009-07-29
%%
Type: language
Subtag: rmf
Description: Kalo Finnish Romani
Added: 2009-07-29
Macrolanguage: rom
%%
Type: language
Subtag: rmg
Description: Traveller Norwegian
Added: 2009-07-29
%%
Type: language
Subtag: rmh
Description: Murkim
Added: 2009-07-29
%%
Type: language
Subtag: rmi
Description: Lomavren
Added: 2009-07-29
%%
Type: language
Subtag: rmk
Description: Romkun
Added: 2009-07-29
%%
Type: language
Subtag: rml
Description: Baltic Romani
Added: 2009-07-29
Macrolanguage: rom
%%
Type: language
Subtag: rmm
Description: Roma
Added: 2009-07-29
%%
Type: language
Subtag: rmn
Description: Balkan Romani
Added: 2009-07-29
Macrolanguage: rom
%%
Type: language
Subtag: rmo
Description: Sinte Romani
Added: 2009-07-29
Macrolanguage: rom
%%
Type: language
Subtag: rmp
Description: Rempi
Added: 2009-07-29
%%
Type: language
Subtag: rmq
Description: Caló
Added: 2010-03-11
%%
Type: language
Subtag: rmr
Description: Caló
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see emx, rmq
%%
Type: language
Subtag: rms
Description: Romanian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: rmt
Description: Domari
Added: 2009-07-29
%%
Type: language
Subtag: rmu
Description: Tavringer Romani
Added: 2009-07-29
%%
Type: language
Subtag: rmv
Description: Romanova
Added: 2009-07-29
%%
Type: language
Subtag: rmw
Description: Welsh Romani
Added: 2009-07-29
Macrolanguage: rom
%%
Type: language
Subtag: rmx
Description: Romam
Added: 2009-07-29
%%
Type: language
Subtag: rmy
Description: Vlax Romani
Added: 2009-07-29
Macrolanguage: rom
%%
Type: language
Subtag: rmz
Description: Marma
Added: 2009-07-29
%%
Type: language
Subtag: rna
Description: Runa
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: rnd
Description: Ruund
Added: 2009-07-29
%%
Type: language
Subtag: rng
Description: Ronga
Added: 2009-07-29
%%
Type: language
Subtag: rnl
Description: Ranglong
Added: 2009-07-29
%%
Type: language
Subtag: rnn
Description: Roon
Added: 2009-07-29
%%
Type: language
Subtag: rnp
Description: Rongpo
Added: 2009-07-29
%%
Type: language
Subtag: rnr
Description: Nari Nari
Added: 2012-08-20
%%
Type: language
Subtag: rnw
Description: Rungwa
Added: 2009-07-29
%%
Type: language
Subtag: roa
Description: Romance languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: rob
Description: Tae'
Added: 2009-07-29
%%
Type: language
Subtag: roc
Description: Cacgia Roglai
Added: 2009-07-29
%%
Type: language
Subtag: rod
Description: Rogo
Added: 2009-07-29
%%
Type: language
Subtag: roe
Description: Ronji
Added: 2009-07-29
%%
Type: language
Subtag: rof
Description: Rombo
Added: 2009-07-29
%%
Type: language
Subtag: rog
Description: Northern Roglai
Added: 2009-07-29
%%
Type: language
Subtag: rol
Description: Romblomanon
Added: 2009-07-29
%%
Type: language
Subtag: rom
Description: Romany
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: roo
Description: Rotokas
Added: 2009-07-29
%%
Type: language
Subtag: rop
Description: Kriol
Added: 2009-07-29
%%
Type: language
Subtag: ror
Description: Rongga
Added: 2009-07-29
%%
Type: language
Subtag: rou
Description: Runga
Added: 2009-07-29
%%
Type: language
Subtag: row
Description: Dela-Oenale
Added: 2009-07-29
%%
Type: language
Subtag: rpn
Description: Repanbitip
Added: 2009-07-29
%%
Type: language
Subtag: rpt
Description: Rapting
Added: 2009-07-29
%%
Type: language
Subtag: rri
Description: Ririo
Added: 2009-07-29
%%
Type: language
Subtag: rro
Description: Waima
Added: 2009-07-29
%%
Type: language
Subtag: rrt
Description: Arritinngithigh
Added: 2012-08-12
%%
Type: language
Subtag: rsb
Description: Romano-Serbian
Added: 2009-07-29
%%
Type: language
Subtag: rsi
Description: Rennellese Sign Language
Added: 2009-07-29
Deprecated: 2017-02-23
%%
Type: language
Subtag: rsl
Description: Russian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: rsm
Description: Miriwoong Sign Language
Added: 2016-05-30
%%
Type: language
Subtag: rtc
Description: Rungtu Chin
Added: 2012-08-12
%%
Type: language
Subtag: rth
Description: Ratahan
Added: 2009-07-29
%%
Type: language
Subtag: rtm
Description: Rotuman
Added: 2009-07-29
%%
Type: language
Subtag: rts
Description: Yurats
Added: 2015-02-12
%%
Type: language
Subtag: rtw
Description: Rathawi
Added: 2009-07-29
%%
Type: language
Subtag: rub
Description: Gungu
Added: 2009-07-29
%%
Type: language
Subtag: ruc
Description: Ruuli
Added: 2009-07-29
%%
Type: language
Subtag: rue
Description: Rusyn
Added: 2009-07-29
%%
Type: language
Subtag: ruf
Description: Luguru
Added: 2009-07-29
%%
Type: language
Subtag: rug
Description: Roviana
Added: 2009-07-29
%%
Type: language
Subtag: ruh
Description: Ruga
Added: 2009-07-29
%%
Type: language
Subtag: rui
Description: Rufiji
Added: 2009-07-29
%%
Type: language
Subtag: ruk
Description: Che
Added: 2009-07-29
%%
Type: language
Subtag: ruo
Description: Istro Romanian
Added: 2009-07-29
%%
Type: language
Subtag: rup
Description: Macedo-Romanian
Description: Aromanian
Description: Arumanian
Added: 2005-10-16
%%
Type: language
Subtag: ruq
Description: Megleno Romanian
Added: 2009-07-29
%%
Type: language
Subtag: rut
Description: Rutul
Added: 2009-07-29
%%
Type: language
Subtag: ruu
Description: Lanas Lobu
Added: 2009-07-29
%%
Type: language
Subtag: ruy
Description: Mala (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: ruz
Description: Ruma
Added: 2009-07-29
%%
Type: language
Subtag: rwa
Description: Rawo
Added: 2009-07-29
%%
Type: language
Subtag: rwk
Description: Rwa
Added: 2009-07-29
%%
Type: language
Subtag: rwm
Description: Amba (Uganda)
Added: 2009-07-29
%%
Type: language
Subtag: rwo
Description: Rawa
Added: 2009-07-29
%%
Type: language
Subtag: rwr
Description: Marwari (India)
Added: 2009-07-29
Macrolanguage: mwr
%%
Type: language
Subtag: rxd
Description: Ngardi
Added: 2013-09-10
%%
Type: language
Subtag: rxw
Description: Karuwali
Description: Garuwali
Added: 2013-09-10
%%
Type: language
Subtag: ryn
Description: Northern Amami-Oshima
Added: 2009-07-29
%%
Type: language
Subtag: rys
Description: Yaeyama
Added: 2009-07-29
%%
Type: language
Subtag: ryu
Description: Central Okinawan
Added: 2009-07-29
%%
Type: language
Subtag: rzh
Description: Rāziḥī
Added: 2016-05-30
%%
Type: language
Subtag: saa
Description: Saba
Added: 2009-07-29
%%
Type: language
Subtag: sab
Description: Buglere
Added: 2009-07-29
%%
Type: language
Subtag: sac
Description: Meskwaki
Added: 2009-07-29
%%
Type: language
Subtag: sad
Description: Sandawe
Added: 2005-10-16
%%
Type: language
Subtag: sae
Description: Sabanê
Added: 2009-07-29
%%
Type: language
Subtag: saf
Description: Safaliba
Added: 2009-07-29
%%
Type: language
Subtag: sah
Description: Yakut
Added: 2005-10-16
%%
Type: language
Subtag: sai
Description: South American Indian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: saj
Description: Sahu
Added: 2009-07-29
%%
Type: language
Subtag: sak
Description: Sake
Added: 2009-07-29
%%
Type: language
Subtag: sal
Description: Salishan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: sam
Description: Samaritan Aramaic
Added: 2005-10-16
%%
Type: language
Subtag: sao
Description: Sause
Added: 2009-07-29
%%
Type: language
Subtag: sap
Description: Sanapaná
Added: 2009-07-29
Deprecated: 2014-02-28
Comments: see aqt, spn
%%
Type: language
Subtag: saq
Description: Samburu
Added: 2009-07-29
%%
Type: language
Subtag: sar
Description: Saraveca
Added: 2009-07-29
%%
Type: language
Subtag: sas
Description: Sasak
Added: 2005-10-16
%%
Type: language
Subtag: sat
Description: Santali
Added: 2005-10-16
%%
Type: language
Subtag: sau
Description: Saleman
Added: 2009-07-29
%%
Type: language
Subtag: sav
Description: Saafi-Saafi
Added: 2009-07-29
%%
Type: language
Subtag: saw
Description: Sawi
Added: 2009-07-29
%%
Type: language
Subtag: sax
Description: Sa
Added: 2009-07-29
%%
Type: language
Subtag: say
Description: Saya
Added: 2009-07-29
%%
Type: language
Subtag: saz
Description: Saurashtra
Added: 2009-07-29
%%
Type: language
Subtag: sba
Description: Ngambay
Added: 2009-07-29
%%
Type: language
Subtag: sbb
Description: Simbo
Added: 2009-07-29
%%
Type: language
Subtag: sbc
Description: Kele (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: sbd
Description: Southern Samo
Added: 2009-07-29
%%
Type: language
Subtag: sbe
Description: Saliba
Added: 2009-07-29
%%
Type: language
Subtag: sbf
Description: Chabu
Description: Shabo
Added: 2009-07-29
%%
Type: language
Subtag: sbg
Description: Seget
Added: 2009-07-29
%%
Type: language
Subtag: sbh
Description: Sori-Harengan
Added: 2009-07-29
%%
Type: language
Subtag: sbi
Description: Seti
Added: 2009-07-29
%%
Type: language
Subtag: sbj
Description: Surbakhal
Added: 2009-07-29
%%
Type: language
Subtag: sbk
Description: Safwa
Added: 2009-07-29
%%
Type: language
Subtag: sbl
Description: Botolan Sambal
Added: 2009-07-29
%%
Type: language
Subtag: sbm
Description: Sagala
Added: 2009-07-29
%%
Type: language
Subtag: sbn
Description: Sindhi Bhil
Added: 2009-07-29
%%
Type: language
Subtag: sbo
Description: Sabüm
Added: 2009-07-29
%%
Type: language
Subtag: sbp
Description: Sangu (Tanzania)
Added: 2009-07-29
%%
Type: language
Subtag: sbq
Description: Sileibi
Added: 2009-07-29
%%
Type: language
Subtag: sbr
Description: Sembakung Murut
Added: 2009-07-29
%%
Type: language
Subtag: sbs
Description: Subiya
Added: 2009-07-29
%%
Type: language
Subtag: sbt
Description: Kimki
Added: 2009-07-29
%%
Type: language
Subtag: sbu
Description: Stod Bhoti
Added: 2009-07-29
%%
Type: language
Subtag: sbv
Description: Sabine
Added: 2009-07-29
%%
Type: language
Subtag: sbw
Description: Simba
Added: 2009-07-29
%%
Type: language
Subtag: sbx
Description: Seberuang
Added: 2009-07-29
%%
Type: language
Subtag: sby
Description: Soli
Added: 2009-07-29
%%
Type: language
Subtag: sbz
Description: Sara Kaba
Added: 2009-07-29
%%
Type: language
Subtag: sca
Description: Sansu
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: hle
%%
Type: language
Subtag: scb
Description: Chut
Added: 2009-07-29
%%
Type: language
Subtag: sce
Description: Dongxiang
Added: 2009-07-29
%%
Type: language
Subtag: scf
Description: San Miguel Creole French
Added: 2009-07-29
%%
Type: language
Subtag: scg
Description: Sanggau
Added: 2009-07-29
%%
Type: language
Subtag: sch
Description: Sakachep
Added: 2009-07-29
%%
Type: language
Subtag: sci
Description: Sri Lankan Creole Malay
Added: 2009-07-29
%%
Type: language
Subtag: sck
Description: Sadri
Added: 2009-07-29
%%
Type: language
Subtag: scl
Description: Shina
Added: 2009-07-29
%%
Type: language
Subtag: scn
Description: Sicilian
Added: 2005-10-16
%%
Type: language
Subtag: sco
Description: Scots
Added: 2005-10-16
%%
Type: language
Subtag: scp
Description: Hyolmo
Description: Helambu Sherpa
Added: 2009-07-29
%%
Type: language
Subtag: scq
Description: Sa'och
Added: 2009-07-29
%%
Type: language
Subtag: scs
Description: North Slavey
Added: 2009-07-29
Macrolanguage: den
%%
Type: language
Subtag: sct
Description: Southern Katang
Added: 2017-02-23
%%
Type: language
Subtag: scu
Description: Shumcho
Added: 2009-07-29
%%
Type: language
Subtag: scv
Description: Sheni
Added: 2009-07-29
%%
Type: language
Subtag: scw
Description: Sha
Added: 2009-07-29
%%
Type: language
Subtag: scx
Description: Sicel
Added: 2009-07-29
%%
Type: language
Subtag: sda
Description: Toraja-Sa'dan
Added: 2009-07-29
%%
Type: language
Subtag: sdb
Description: Shabak
Added: 2009-07-29
%%
Type: language
Subtag: sdc
Description: Sassarese Sardinian
Added: 2009-07-29
Macrolanguage: sc
%%
Type: language
Subtag: sde
Description: Surubu
Added: 2009-07-29
%%
Type: language
Subtag: sdf
Description: Sarli
Added: 2009-07-29
%%
Type: language
Subtag: sdg
Description: Savi
Added: 2009-07-29
%%
Type: language
Subtag: sdh
Description: Southern Kurdish
Added: 2009-07-29
Macrolanguage: ku
%%
Type: language
Subtag: sdj
Description: Suundi
Added: 2009-07-29
%%
Type: language
Subtag: sdk
Description: Sos Kundi
Added: 2009-07-29
%%
Type: language
Subtag: sdl
Description: Saudi Arabian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: sdm
Description: Semandang
Added: 2009-07-29
%%
Type: language
Subtag: sdn
Description: Gallurese Sardinian
Added: 2009-07-29
Macrolanguage: sc
%%
Type: language
Subtag: sdo
Description: Bukar-Sadung Bidayuh
Added: 2009-07-29
%%
Type: language
Subtag: sdp
Description: Sherdukpen
Added: 2009-07-29
%%
Type: language
Subtag: sdr
Description: Oraon Sadri
Added: 2009-07-29
%%
Type: language
Subtag: sds
Description: Sened
Added: 2009-07-29
%%
Type: language
Subtag: sdt
Description: Shuadit
Added: 2009-07-29
%%
Type: language
Subtag: sdu
Description: Sarudu
Added: 2009-07-29
%%
Type: language
Subtag: sdv
Description: Eastern Sudanic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: sdx
Description: Sibu Melanau
Added: 2009-07-29
%%
Type: language
Subtag: sdz
Description: Sallands
Added: 2009-07-29
%%
Type: language
Subtag: sea
Description: Semai
Added: 2009-07-29
%%
Type: language
Subtag: seb
Description: Shempire Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: sec
Description: Sechelt
Added: 2009-07-29
%%
Type: language
Subtag: sed
Description: Sedang
Added: 2009-07-29
%%
Type: language
Subtag: see
Description: Seneca
Added: 2009-07-29
%%
Type: language
Subtag: sef
Description: Cebaara Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: seg
Description: Segeju
Added: 2009-07-29
%%
Type: language
Subtag: seh
Description: Sena
Added: 2009-07-29
%%
Type: language
Subtag: sei
Description: Seri
Added: 2009-07-29
%%
Type: language
Subtag: sej
Description: Sene
Added: 2009-07-29
%%
Type: language
Subtag: sek
Description: Sekani
Added: 2009-07-29
%%
Type: language
Subtag: sel
Description: Selkup
Added: 2005-10-16
%%
Type: language
Subtag: sem
Description: Semitic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: sen
Description: Nanerigé Sénoufo
Added: 2009-07-29
%%
Type: language
Subtag: seo
Description: Suarmin
Added: 2009-07-29
%%
Type: language
Subtag: sep
Description: Sìcìté Sénoufo
Added: 2009-07-29
%%
Type: language
Subtag: seq
Description: Senara Sénoufo
Added: 2009-07-29
%%
Type: language
Subtag: ser
Description: Serrano
Added: 2009-07-29
%%
Type: language
Subtag: ses
Description: Koyraboro Senni Songhai
Added: 2009-07-29
%%
Type: language
Subtag: set
Description: Sentani
Added: 2009-07-29
%%
Type: language
Subtag: seu
Description: Serui-Laut
Added: 2009-07-29
%%
Type: language
Subtag: sev
Description: Nyarafolo Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: sew
Description: Sewa Bay
Added: 2009-07-29
%%
Type: language
Subtag: sey
Description: Secoya
Added: 2009-07-29
%%
Type: language
Subtag: sez
Description: Senthang Chin
Added: 2009-07-29
%%
Type: language
Subtag: sfb
Description: Langue des signes de Belgique Francophone
Description: French Belgian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: sfe
Description: Eastern Subanen
Added: 2012-08-12
%%
Type: language
Subtag: sfm
Description: Small Flowery Miao
Added: 2009-07-29
Macrolanguage: hmn
%%
Type: language
Subtag: sfs
Description: South African Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: sfw
Description: Sehwi
Added: 2009-07-29
%%
Type: language
Subtag: sga
Description: Old Irish (to 900)
Added: 2005-10-16
%%
Type: language
Subtag: sgb
Description: Mag-antsi Ayta
Added: 2009-07-29
%%
Type: language
Subtag: sgc
Description: Kipsigis
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: sgd
Description: Surigaonon
Added: 2010-03-11
%%
Type: language
Subtag: sge
Description: Segai
Added: 2009-07-29
%%
Type: language
Subtag: sgg
Description: Swiss-German Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: sgh
Description: Shughni
Added: 2009-07-29
%%
Type: language
Subtag: sgi
Description: Suga
Added: 2009-07-29
%%
Type: language
Subtag: sgj
Description: Surgujia
Added: 2012-08-12
%%
Type: language
Subtag: sgk
Description: Sangkong
Added: 2009-07-29
%%
Type: language
Subtag: sgl
Description: Sanglechi-Ishkashimi
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see isk, sgy
%%
Type: language
Subtag: sgm
Description: Singa
Added: 2009-07-29
%%
Type: language
Subtag: sgn
Description: Sign languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: sgo
Description: Songa
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: sgp
Description: Singpho
Added: 2009-07-29
%%
Type: language
Subtag: sgr
Description: Sangisari
Added: 2009-07-29
%%
Type: language
Subtag: sgs
Description: Samogitian
Added: 2010-07-26
%%
Type: language
Subtag: sgt
Description: Brokpake
Added: 2009-07-29
%%
Type: language
Subtag: sgu
Description: Salas
Added: 2009-07-29
%%
Type: language
Subtag: sgw
Description: Sebat Bet Gurage
Added: 2009-07-29
%%
Type: language
Subtag: sgx
Description: Sierra Leone Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: sgy
Description: Sanglechi
Added: 2010-03-11
%%
Type: language
Subtag: sgz
Description: Sursurunga
Added: 2009-07-29
%%
Type: language
Subtag: sha
Description: Shall-Zwall
Added: 2009-07-29
%%
Type: language
Subtag: shb
Description: Ninam
Added: 2009-07-29
%%
Type: language
Subtag: shc
Description: Sonde
Added: 2009-07-29
%%
Type: language
Subtag: shd
Description: Kundal Shahi
Added: 2010-03-11
%%
Type: language
Subtag: she
Description: Sheko
Added: 2009-07-29
%%
Type: language
Subtag: shg
Description: Shua
Added: 2009-07-29
%%
Type: language
Subtag: shh
Description: Shoshoni
Added: 2009-07-29
%%
Type: language
Subtag: shi
Description: Tachelhit
Added: 2009-07-29
%%
Type: language
Subtag: shj
Description: Shatt
Added: 2009-07-29
%%
Type: language
Subtag: shk
Description: Shilluk
Added: 2009-07-29
%%
Type: language
Subtag: shl
Description: Shendu
Added: 2009-07-29
%%
Type: language
Subtag: shm
Description: Shahrudi
Added: 2009-07-29
%%
Type: language
Subtag: shn
Description: Shan
Added: 2005-10-16
%%
Type: language
Subtag: sho
Description: Shanga
Added: 2009-07-29
%%
Type: language
Subtag: shp
Description: Shipibo-Conibo
Added: 2009-07-29
%%
Type: language
Subtag: shq
Description: Sala
Added: 2009-07-29
%%
Type: language
Subtag: shr
Description: Shi
Added: 2009-07-29
%%
Type: language
Subtag: shs
Description: Shuswap
Added: 2009-07-29
%%
Type: language
Subtag: sht
Description: Shasta
Added: 2009-07-29
%%
Type: language
Subtag: shu
Description: Chadian Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: shv
Description: Shehri
Added: 2009-07-29
%%
Type: language
Subtag: shw
Description: Shwai
Added: 2009-07-29
%%
Type: language
Subtag: shx
Description: She
Added: 2009-07-29
%%
Type: language
Subtag: shy
Description: Tachawit
Added: 2009-07-29
%%
Type: language
Subtag: shz
Description: Syenara Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: sia
Description: Akkala Sami
Added: 2009-07-29
%%
Type: language
Subtag: sib
Description: Sebop
Added: 2009-07-29
%%
Type: language
Subtag: sid
Description: Sidamo
Added: 2005-10-16
%%
Type: language
Subtag: sie
Description: Simaa
Added: 2009-07-29
%%
Type: language
Subtag: sif
Description: Siamou
Added: 2009-07-29
%%
Type: language
Subtag: sig
Description: Paasaal
Added: 2009-07-29
%%
Type: language
Subtag: sih
Description: Zire
Description: Sîshëë
Added: 2009-07-29
%%
Type: language
Subtag: sii
Description: Shom Peng
Added: 2009-07-29
%%
Type: language
Subtag: sij
Description: Numbami
Added: 2009-07-29
%%
Type: language
Subtag: sik
Description: Sikiana
Added: 2009-07-29
%%
Type: language
Subtag: sil
Description: Tumulung Sisaala
Added: 2009-07-29
%%
Type: language
Subtag: sim
Description: Mende (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: sio
Description: Siouan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: sip
Description: Sikkimese
Added: 2009-07-29
%%
Type: language
Subtag: siq
Description: Sonia
Added: 2009-07-29
%%
Type: language
Subtag: sir
Description: Siri
Added: 2009-07-29
%%
Type: language
Subtag: sis
Description: Siuslaw
Added: 2009-07-29
%%
Type: language
Subtag: sit
Description: Sino-Tibetan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: siu
Description: Sinagen
Added: 2009-07-29
%%
Type: language
Subtag: siv
Description: Sumariup
Added: 2009-07-29
%%
Type: language
Subtag: siw
Description: Siwai
Added: 2009-07-29
%%
Type: language
Subtag: six
Description: Sumau
Added: 2009-07-29
%%
Type: language
Subtag: siy
Description: Sivandi
Added: 2009-07-29
%%
Type: language
Subtag: siz
Description: Siwi
Added: 2009-07-29
%%
Type: language
Subtag: sja
Description: Epena
Added: 2009-07-29
%%
Type: language
Subtag: sjb
Description: Sajau Basap
Added: 2009-07-29
%%
Type: language
Subtag: sjd
Description: Kildin Sami
Added: 2009-07-29
%%
Type: language
Subtag: sje
Description: Pite Sami
Added: 2009-07-29
%%
Type: language
Subtag: sjg
Description: Assangori
Added: 2009-07-29
%%
Type: language
Subtag: sjk
Description: Kemi Sami
Added: 2009-07-29
%%
Type: language
Subtag: sjl
Description: Sajalong
Description: Miji
Added: 2009-07-29
%%
Type: language
Subtag: sjm
Description: Mapun
Added: 2009-07-29
%%
Type: language
Subtag: sjn
Description: Sindarin
Added: 2009-07-29
%%
Type: language
Subtag: sjo
Description: Xibe
Added: 2009-07-29
%%
Type: language
Subtag: sjp
Description: Surjapuri
Added: 2009-07-29
%%
Type: language
Subtag: sjr
Description: Siar-Lak
Added: 2009-07-29
%%
Type: language
Subtag: sjs
Description: Senhaja De Srair
Added: 2009-07-29
%%
Type: language
Subtag: sjt
Description: Ter Sami
Added: 2009-07-29
%%
Type: language
Subtag: sju
Description: Ume Sami
Added: 2009-07-29
%%
Type: language
Subtag: sjw
Description: Shawnee
Added: 2009-07-29
%%
Type: language
Subtag: ska
Description: Skagit
Added: 2009-07-29
%%
Type: language
Subtag: skb
Description: Saek
Added: 2009-07-29
%%
Type: language
Subtag: skc
Description: Ma Manda
Added: 2009-07-29
%%
Type: language
Subtag: skd
Description: Southern Sierra Miwok
Added: 2009-07-29
%%
Type: language
Subtag: ske
Description: Seke (Vanuatu)
Added: 2009-07-29
%%
Type: language
Subtag: skf
Description: Sakirabiá
Added: 2009-07-29
%%
Type: language
Subtag: skg
Description: Sakalava Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: skh
Description: Sikule
Added: 2009-07-29
%%
Type: language
Subtag: ski
Description: Sika
Added: 2009-07-29
%%
Type: language
Subtag: skj
Description: Seke (Nepal)
Added: 2009-07-29
%%
Type: language
Subtag: skk
Description: Sok
Added: 2009-07-29
Deprecated: 2017-02-23
Preferred-Value: oyb
%%
Type: language
Subtag: skm
Description: Kutong
Added: 2009-07-29
%%
Type: language
Subtag: skn
Description: Kolibugan Subanon
Added: 2009-07-29
%%
Type: language
Subtag: sko
Description: Seko Tengah
Added: 2009-07-29
%%
Type: language
Subtag: skp
Description: Sekapan
Added: 2009-07-29
%%
Type: language
Subtag: skq
Description: Sininkere
Added: 2009-07-29
%%
Type: language
Subtag: skr
Description: Saraiki
Description: Seraiki
Added: 2009-07-29
Macrolanguage: lah
%%
Type: language
Subtag: sks
Description: Maia
Added: 2009-07-29
%%
Type: language
Subtag: skt
Description: Sakata
Added: 2009-07-29
%%
Type: language
Subtag: sku
Description: Sakao
Added: 2009-07-29
%%
Type: language
Subtag: skv
Description: Skou
Added: 2009-07-29
%%
Type: language
Subtag: skw
Description: Skepi Creole Dutch
Added: 2009-07-29
%%
Type: language
Subtag: skx
Description: Seko Padang
Added: 2009-07-29
%%
Type: language
Subtag: sky
Description: Sikaiana
Added: 2009-07-29
%%
Type: language
Subtag: skz
Description: Sekar
Added: 2009-07-29
%%
Type: language
Subtag: sla
Description: Slavic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: slc
Description: Sáliba
Added: 2009-07-29
%%
Type: language
Subtag: sld
Description: Sissala
Added: 2009-07-29
%%
Type: language
Subtag: sle
Description: Sholaga
Added: 2009-07-29
%%
Type: language
Subtag: slf
Description: Swiss-Italian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: slg
Description: Selungai Murut
Added: 2009-07-29
%%
Type: language
Subtag: slh
Description: Southern Puget Sound Salish
Added: 2009-07-29
%%
Type: language
Subtag: sli
Description: Lower Silesian
Added: 2009-07-29
%%
Type: language
Subtag: slj
Description: Salumá
Added: 2009-07-29
%%
Type: language
Subtag: sll
Description: Salt-Yui
Added: 2009-07-29
%%
Type: language
Subtag: slm
Description: Pangutaran Sama
Added: 2009-07-29
%%
Type: language
Subtag: sln
Description: Salinan
Added: 2009-07-29
%%
Type: language
Subtag: slp
Description: Lamaholot
Added: 2009-07-29
%%
Type: language
Subtag: slq
Description: Salchuq
Added: 2009-07-29
%%
Type: language
Subtag: slr
Description: Salar
Added: 2009-07-29
%%
Type: language
Subtag: sls
Description: Singapore Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: slt
Description: Sila
Added: 2009-07-29
%%
Type: language
Subtag: slu
Description: Selaru
Added: 2009-07-29
%%
Type: language
Subtag: slw
Description: Sialum
Added: 2009-07-29
%%
Type: language
Subtag: slx
Description: Salampasu
Added: 2009-07-29
%%
Type: language
Subtag: sly
Description: Selayar
Added: 2009-07-29
%%
Type: language
Subtag: slz
Description: Ma'ya
Added: 2009-07-29
%%
Type: language
Subtag: sma
Description: Southern Sami
Added: 2005-10-16
%%
Type: language
Subtag: smb
Description: Simbari
Added: 2009-07-29
%%
Type: language
Subtag: smc
Description: Som
Added: 2009-07-29
%%
Type: language
Subtag: smd
Description: Sama
Added: 2009-07-29
%%
Type: language
Subtag: smf
Description: Auwe
Added: 2009-07-29
%%
Type: language
Subtag: smg
Description: Simbali
Added: 2009-07-29
%%
Type: language
Subtag: smh
Description: Samei
Added: 2009-07-29
%%
Type: language
Subtag: smi
Description: Sami languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: smj
Description: Lule Sami
Added: 2005-10-16
%%
Type: language
Subtag: smk
Description: Bolinao
Added: 2009-07-29
%%
Type: language
Subtag: sml
Description: Central Sama
Added: 2009-07-29
%%
Type: language
Subtag: smm
Description: Musasa
Added: 2009-07-29
%%
Type: language
Subtag: smn
Description: Inari Sami
Added: 2005-10-16
%%
Type: language
Subtag: smp
Description: Samaritan
Added: 2009-07-29
%%
Type: language
Subtag: smq
Description: Samo
Added: 2009-07-29
%%
Type: language
Subtag: smr
Description: Simeulue
Added: 2009-07-29
%%
Type: language
Subtag: sms
Description: Skolt Sami
Added: 2005-10-16
%%
Type: language
Subtag: smt
Description: Simte
Added: 2009-07-29
%%
Type: language
Subtag: smu
Description: Somray
Added: 2009-07-29
%%
Type: language
Subtag: smv
Description: Samvedi
Added: 2009-07-29
%%
Type: language
Subtag: smw
Description: Sumbawa
Added: 2009-07-29
%%
Type: language
Subtag: smx
Description: Samba
Added: 2009-07-29
%%
Type: language
Subtag: smy
Description: Semnani
Added: 2009-07-29
%%
Type: language
Subtag: smz
Description: Simeku
Added: 2009-07-29
%%
Type: language
Subtag: snb
Description: Sebuyau
Added: 2009-07-29
%%
Type: language
Subtag: snc
Description: Sinaugoro
Added: 2009-07-29
%%
Type: language
Subtag: sne
Description: Bau Bidayuh
Added: 2009-07-29
%%
Type: language
Subtag: snf
Description: Noon
Added: 2009-07-29
%%
Type: language
Subtag: sng
Description: Sanga (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: snh
Description: Shinabo
Added: 2009-07-29
Deprecated: 2017-02-23
%%
Type: language
Subtag: sni
Description: Sensi
Added: 2009-07-29
%%
Type: language
Subtag: snj
Description: Riverain Sango
Added: 2009-07-29
%%
Type: language
Subtag: snk
Description: Soninke
Added: 2005-10-16
%%
Type: language
Subtag: snl
Description: Sangil
Added: 2009-07-29
%%
Type: language
Subtag: snm
Description: Southern Ma'di
Added: 2009-07-29
%%
Type: language
Subtag: snn
Description: Siona
Added: 2009-07-29
%%
Type: language
Subtag: sno
Description: Snohomish
Added: 2009-07-29
%%
Type: language
Subtag: snp
Description: Siane
Added: 2009-07-29
%%
Type: language
Subtag: snq
Description: Sangu (Gabon)
Added: 2009-07-29
%%
Type: language
Subtag: snr
Description: Sihan
Added: 2009-07-29
%%
Type: language
Subtag: sns
Description: South West Bay
Description: Nahavaq
Added: 2009-07-29
%%
Type: language
Subtag: snu
Description: Senggi
Description: Viid
Added: 2009-07-29
%%
Type: language
Subtag: snv
Description: Sa'ban
Added: 2009-07-29
%%
Type: language
Subtag: snw
Description: Selee
Added: 2009-07-29
%%
Type: language
Subtag: snx
Description: Sam
Added: 2009-07-29
%%
Type: language
Subtag: sny
Description: Saniyo-Hiyewe
Added: 2009-07-29
%%
Type: language
Subtag: snz
Description: Kou
Added: 2009-07-29
%%
Type: language
Subtag: soa
Description: Thai Song
Added: 2009-07-29
%%
Type: language
Subtag: sob
Description: Sobei
Added: 2009-07-29
%%
Type: language
Subtag: soc
Description: So (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: sod
Description: Songoora
Added: 2009-07-29
%%
Type: language
Subtag: soe
Description: Songomeno
Added: 2009-07-29
%%
Type: language
Subtag: sog
Description: Sogdian
Added: 2005-10-16
%%
Type: language
Subtag: soh
Description: Aka
Added: 2009-07-29
%%
Type: language
Subtag: soi
Description: Sonha
Added: 2009-07-29
%%
Type: language
Subtag: soj
Description: Soi
Added: 2009-07-29
%%
Type: language
Subtag: sok
Description: Sokoro
Added: 2009-07-29
%%
Type: language
Subtag: sol
Description: Solos
Added: 2009-07-29
%%
Type: language
Subtag: son
Description: Songhai languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: soo
Description: Songo
Added: 2009-07-29
%%
Type: language
Subtag: sop
Description: Songe
Added: 2009-07-29
%%
Type: language
Subtag: soq
Description: Kanasi
Added: 2009-07-29
%%
Type: language
Subtag: sor
Description: Somrai
Added: 2009-07-29
%%
Type: language
Subtag: sos
Description: Seeku
Added: 2009-07-29
%%
Type: language
Subtag: sou
Description: Southern Thai
Added: 2009-07-29
%%
Type: language
Subtag: sov
Description: Sonsorol
Added: 2009-07-29
%%
Type: language
Subtag: sow
Description: Sowanda
Added: 2009-07-29
%%
Type: language
Subtag: sox
Description: Swo
Added: 2009-07-29
%%
Type: language
Subtag: soy
Description: Miyobe
Added: 2009-07-29
%%
Type: language
Subtag: soz
Description: Temi
Added: 2009-07-29
%%
Type: language
Subtag: spb
Description: Sepa (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: spc
Description: Sapé
Added: 2009-07-29
%%
Type: language
Subtag: spd
Description: Saep
Added: 2009-07-29
%%
Type: language
Subtag: spe
Description: Sepa (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: spg
Description: Sian
Added: 2009-07-29
%%
Type: language
Subtag: spi
Description: Saponi
Added: 2009-07-29
%%
Type: language
Subtag: spk
Description: Sengo
Added: 2009-07-29
%%
Type: language
Subtag: spl
Description: Selepet
Added: 2009-07-29
%%
Type: language
Subtag: spm
Description: Akukem
Added: 2009-07-29
%%
Type: language
Subtag: spn
Description: Sanapaná
Added: 2014-02-28
%%
Type: language
Subtag: spo
Description: Spokane
Added: 2009-07-29
%%
Type: language
Subtag: spp
Description: Supyire Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: spq
Description: Loreto-Ucayali Spanish
Added: 2009-07-29
%%
Type: language
Subtag: spr
Description: Saparua
Added: 2009-07-29
%%
Type: language
Subtag: sps
Description: Saposa
Added: 2009-07-29
%%
Type: language
Subtag: spt
Description: Spiti Bhoti
Added: 2009-07-29
%%
Type: language
Subtag: spu
Description: Sapuan
Added: 2009-07-29
%%
Type: language
Subtag: spv
Description: Sambalpuri
Description: Kosli
Added: 2012-08-12
Macrolanguage: or
%%
Type: language
Subtag: spx
Description: South Picene
Added: 2009-07-29
%%
Type: language
Subtag: spy
Description: Sabaot
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: sqa
Description: Shama-Sambuga
Added: 2009-07-29
%%
Type: language
Subtag: sqh
Description: Shau
Added: 2009-07-29
%%
Type: language
Subtag: sqj
Description: Albanian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: sqk
Description: Albanian Sign Language
Added: 2012-08-12
%%
Type: language
Subtag: sqm
Description: Suma
Added: 2009-07-29
%%
Type: language
Subtag: sqn
Description: Susquehannock
Added: 2009-07-29
%%
Type: language
Subtag: sqo
Description: Sorkhei
Added: 2009-07-29
%%
Type: language
Subtag: sqq
Description: Sou
Added: 2009-07-29
%%
Type: language
Subtag: sqr
Description: Siculo Arabic
Added: 2009-07-29
%%
Type: language
Subtag: sqs
Description: Sri Lankan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: sqt
Description: Soqotri
Added: 2009-07-29
%%
Type: language
Subtag: squ
Description: Squamish
Added: 2009-07-29
%%
Type: language
Subtag: sra
Description: Saruga
Added: 2009-07-29
%%
Type: language
Subtag: srb
Description: Sora
Added: 2009-07-29
%%
Type: language
Subtag: src
Description: Logudorese Sardinian
Added: 2009-07-29
Macrolanguage: sc
%%
Type: language
Subtag: sre
Description: Sara
Added: 2009-07-29
%%
Type: language
Subtag: srf
Description: Nafi
Added: 2009-07-29
%%
Type: language
Subtag: srg
Description: Sulod
Added: 2009-07-29
%%
Type: language
Subtag: srh
Description: Sarikoli
Added: 2009-07-29
%%
Type: language
Subtag: sri
Description: Siriano
Added: 2009-07-29
%%
Type: language
Subtag: srk
Description: Serudung Murut
Added: 2009-07-29
%%
Type: language
Subtag: srl
Description: Isirawa
Added: 2009-07-29
%%
Type: language
Subtag: srm
Description: Saramaccan
Added: 2009-07-29
%%
Type: language
Subtag: srn
Description: Sranan Tongo
Added: 2005-10-16
%%
Type: language
Subtag: sro
Description: Campidanese Sardinian
Added: 2009-07-29
Macrolanguage: sc
%%
Type: language
Subtag: srq
Description: Sirionó
Added: 2009-07-29
%%
Type: language
Subtag: srr
Description: Serer
Added: 2005-10-16
%%
Type: language
Subtag: srs
Description: Sarsi
Added: 2009-07-29
%%
Type: language
Subtag: srt
Description: Sauri
Added: 2009-07-29
%%
Type: language
Subtag: sru
Description: Suruí
Added: 2009-07-29
%%
Type: language
Subtag: srv
Description: Southern Sorsoganon
Added: 2009-07-29
%%
Type: language
Subtag: srw
Description: Serua
Added: 2009-07-29
%%
Type: language
Subtag: srx
Description: Sirmauri
Added: 2009-07-29
%%
Type: language
Subtag: sry
Description: Sera
Added: 2009-07-29
%%
Type: language
Subtag: srz
Description: Shahmirzadi
Added: 2009-07-29
%%
Type: language
Subtag: ssa
Description: Nilo-Saharan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: ssb
Description: Southern Sama
Added: 2009-07-29
%%
Type: language
Subtag: ssc
Description: Suba-Simbiti
Added: 2009-07-29
%%
Type: language
Subtag: ssd
Description: Siroi
Added: 2009-07-29
%%
Type: language
Subtag: sse
Description: Balangingi
Description: Bangingih Sama
Added: 2009-07-29
%%
Type: language
Subtag: ssf
Description: Thao
Added: 2009-07-29
%%
Type: language
Subtag: ssg
Description: Seimat
Added: 2009-07-29
%%
Type: language
Subtag: ssh
Description: Shihhi Arabic
Added: 2009-07-29
Macrolanguage: ar
%%
Type: language
Subtag: ssi
Description: Sansi
Added: 2009-07-29
%%
Type: language
Subtag: ssj
Description: Sausi
Added: 2009-07-29
%%
Type: language
Subtag: ssk
Description: Sunam
Added: 2009-07-29
%%
Type: language
Subtag: ssl
Description: Western Sisaala
Added: 2009-07-29
%%
Type: language
Subtag: ssm
Description: Semnam
Added: 2009-07-29
%%
Type: language
Subtag: ssn
Description: Waata
Added: 2009-07-29
%%
Type: language
Subtag: sso
Description: Sissano
Added: 2009-07-29
%%
Type: language
Subtag: ssp
Description: Spanish Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: ssq
Description: So'a
Added: 2009-07-29
%%
Type: language
Subtag: ssr
Description: Swiss-French Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: sss
Description: Sô
Added: 2009-07-29
%%
Type: language
Subtag: sst
Description: Sinasina
Added: 2009-07-29
%%
Type: language
Subtag: ssu
Description: Susuami
Added: 2009-07-29
%%
Type: language
Subtag: ssv
Description: Shark Bay
Added: 2009-07-29
%%
Type: language
Subtag: ssx
Description: Samberigi
Added: 2009-07-29
%%
Type: language
Subtag: ssy
Description: Saho
Added: 2009-07-29
%%
Type: language
Subtag: ssz
Description: Sengseng
Added: 2009-07-29
%%
Type: language
Subtag: sta
Description: Settla
Added: 2009-07-29
%%
Type: language
Subtag: stb
Description: Northern Subanen
Added: 2009-07-29
%%
Type: language
Subtag: std
Description: Sentinel
Added: 2009-07-29
%%
Type: language
Subtag: ste
Description: Liana-Seti
Added: 2009-07-29
%%
Type: language
Subtag: stf
Description: Seta
Added: 2009-07-29
%%
Type: language
Subtag: stg
Description: Trieng
Added: 2009-07-29
%%
Type: language
Subtag: sth
Description: Shelta
Added: 2009-07-29
%%
Type: language
Subtag: sti
Description: Bulo Stieng
Added: 2009-07-29
%%
Type: language
Subtag: stj
Description: Matya Samo
Added: 2009-07-29
%%
Type: language
Subtag: stk
Description: Arammba
Added: 2009-07-29
%%
Type: language
Subtag: stl
Description: Stellingwerfs
Added: 2009-07-29
%%
Type: language
Subtag: stm
Description: Setaman
Added: 2009-07-29
%%
Type: language
Subtag: stn
Description: Owa
Added: 2009-07-29
%%
Type: language
Subtag: sto
Description: Stoney
Added: 2009-07-29
%%
Type: language
Subtag: stp
Description: Southeastern Tepehuan
Added: 2009-07-29
%%
Type: language
Subtag: stq
Description: Saterfriesisch
Added: 2009-07-29
%%
Type: language
Subtag: str
Description: Straits Salish
Added: 2009-07-29
%%
Type: language
Subtag: sts
Description: Shumashti
Added: 2009-07-29
%%
Type: language
Subtag: stt
Description: Budeh Stieng
Added: 2009-07-29
%%
Type: language
Subtag: stu
Description: Samtao
Added: 2009-07-29
%%
Type: language
Subtag: stv
Description: Silt'e
Added: 2009-07-29
%%
Type: language
Subtag: stw
Description: Satawalese
Added: 2009-07-29
%%
Type: language
Subtag: sty
Description: Siberian Tatar
Added: 2013-09-10
%%
Type: language
Subtag: sua
Description: Sulka
Added: 2009-07-29
%%
Type: language
Subtag: sub
Description: Suku
Added: 2009-07-29
%%
Type: language
Subtag: suc
Description: Western Subanon
Added: 2009-07-29
%%
Type: language
Subtag: sue
Description: Suena
Added: 2009-07-29
%%
Type: language
Subtag: sug
Description: Suganga
Added: 2009-07-29
%%
Type: language
Subtag: sui
Description: Suki
Added: 2009-07-29
%%
Type: language
Subtag: suj
Description: Shubi
Added: 2009-07-29
Comments: see also xsj
%%
Type: language
Subtag: suk
Description: Sukuma
Added: 2005-10-16
%%
Type: language
Subtag: sul
Description: Surigaonon
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see sgd, tgn
%%
Type: language
Subtag: sum
Description: Sumo-Mayangna
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see ulw, yan
%%
Type: language
Subtag: suq
Description: Suri
Added: 2009-07-29
%%
Type: language
Subtag: sur
Description: Mwaghavul
Added: 2009-07-29
%%
Type: language
Subtag: sus
Description: Susu
Added: 2005-10-16
%%
Type: language
Subtag: sut
Description: Subtiaba
Added: 2009-07-29
%%
Type: language
Subtag: suv
Description: Puroik
Added: 2009-07-29
%%
Type: language
Subtag: suw
Description: Sumbwa
Added: 2009-07-29
%%
Type: language
Subtag: sux
Description: Sumerian
Added: 2005-10-16
%%
Type: language
Subtag: suy
Description: Suyá
Added: 2009-07-29
%%
Type: language
Subtag: suz
Description: Sunwar
Added: 2009-07-29
%%
Type: language
Subtag: sva
Description: Svan
Added: 2009-07-29
%%
Type: language
Subtag: svb
Description: Ulau-Suain
Added: 2009-07-29
%%
Type: language
Subtag: svc
Description: Vincentian Creole English
Added: 2009-07-29
%%
Type: language
Subtag: sve
Description: Serili
Added: 2009-07-29
%%
Type: language
Subtag: svk
Description: Slovakian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: svm
Description: Slavomolisano
Added: 2013-09-10
%%
Type: language
Subtag: svr
Description: Savara
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: svs
Description: Savosavo
Added: 2009-07-29
%%
Type: language
Subtag: svx
Description: Skalvian
Added: 2009-07-29
%%
Type: language
Subtag: swb
Description: Maore Comorian
Added: 2009-07-29
%%
Type: language
Subtag: swc
Description: Congo Swahili
Added: 2009-07-29
Macrolanguage: sw
%%
Type: language
Subtag: swf
Description: Sere
Added: 2009-07-29
%%
Type: language
Subtag: swg
Description: Swabian
Added: 2009-07-29
%%
Type: language
Subtag: swh
Description: Swahili (individual language)
Description: Kiswahili
Added: 2009-07-29
Macrolanguage: sw
%%
Type: language
Subtag: swi
Description: Sui
Added: 2009-07-29
%%
Type: language
Subtag: swj
Description: Sira
Added: 2009-07-29
%%
Type: language
Subtag: swk
Description: Malawi Sena
Added: 2009-07-29
%%
Type: language
Subtag: swl
Description: Swedish Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: swm
Description: Samosa
Added: 2009-07-29
%%
Type: language
Subtag: swn
Description: Sawknah
Added: 2009-07-29
%%
Type: language
Subtag: swo
Description: Shanenawa
Added: 2009-07-29
%%
Type: language
Subtag: swp
Description: Suau
Added: 2009-07-29
%%
Type: language
Subtag: swq
Description: Sharwa
Added: 2009-07-29
%%
Type: language
Subtag: swr
Description: Saweru
Added: 2009-07-29
%%
Type: language
Subtag: sws
Description: Seluwasan
Added: 2009-07-29
%%
Type: language
Subtag: swt
Description: Sawila
Added: 2009-07-29
%%
Type: language
Subtag: swu
Description: Suwawa
Added: 2009-07-29
%%
Type: language
Subtag: swv
Description: Shekhawati
Added: 2009-07-29
Macrolanguage: mwr
%%
Type: language
Subtag: sww
Description: Sowa
Added: 2009-07-29
%%
Type: language
Subtag: swx
Description: Suruahá
Added: 2009-07-29
%%
Type: language
Subtag: swy
Description: Sarua
Added: 2009-07-29
%%
Type: language
Subtag: sxb
Description: Suba
Added: 2009-07-29
%%
Type: language
Subtag: sxc
Description: Sicanian
Added: 2009-07-29
%%
Type: language
Subtag: sxe
Description: Sighu
Added: 2009-07-29
%%
Type: language
Subtag: sxg
Description: Shuhi
Description: Shixing
Added: 2009-07-29
%%
Type: language
Subtag: sxk
Description: Southern Kalapuya
Added: 2009-07-29
%%
Type: language
Subtag: sxl
Description: Selian
Added: 2009-07-29
%%
Type: language
Subtag: sxm
Description: Samre
Added: 2009-07-29
%%
Type: language
Subtag: sxn
Description: Sangir
Added: 2009-07-29
%%
Type: language
Subtag: sxo
Description: Sorothaptic
Added: 2009-07-29
%%
Type: language
Subtag: sxr
Description: Saaroa
Added: 2009-07-29
%%
Type: language
Subtag: sxs
Description: Sasaru
Added: 2009-07-29
%%
Type: language
Subtag: sxu
Description: Upper Saxon
Added: 2009-07-29
%%
Type: language
Subtag: sxw
Description: Saxwe Gbe
Added: 2009-07-29
%%
Type: language
Subtag: sya
Description: Siang
Added: 2009-07-29
%%
Type: language
Subtag: syb
Description: Central Subanen
Added: 2009-07-29
%%
Type: language
Subtag: syc
Description: Classical Syriac
Added: 2007-04-03
%%
Type: language
Subtag: syd
Description: Samoyedic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: syi
Description: Seki
Added: 2009-07-29
%%
Type: language
Subtag: syk
Description: Sukur
Added: 2009-07-29
%%
Type: language
Subtag: syl
Description: Sylheti
Added: 2009-07-29
%%
Type: language
Subtag: sym
Description: Maya Samo
Added: 2009-07-29
%%
Type: language
Subtag: syn
Description: Senaya
Added: 2009-07-29
%%
Type: language
Subtag: syo
Description: Suoy
Added: 2009-07-29
%%
Type: language
Subtag: syr
Description: Syriac
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: sys
Description: Sinyar
Added: 2009-07-29
%%
Type: language
Subtag: syw
Description: Kagate
Added: 2009-07-29
%%
Type: language
Subtag: syx
Description: Samay
Added: 2015-02-12
%%
Type: language
Subtag: syy
Description: Al-Sayyid Bedouin Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: sza
Description: Semelai
Added: 2009-07-29
%%
Type: language
Subtag: szb
Description: Ngalum
Added: 2009-07-29
%%
Type: language
Subtag: szc
Description: Semaq Beri
Added: 2009-07-29
%%
Type: language
Subtag: szd
Description: Seru
Added: 2009-07-29
%%
Type: language
Subtag: sze
Description: Seze
Added: 2009-07-29
%%
Type: language
Subtag: szg
Description: Sengele
Added: 2009-07-29
%%
Type: language
Subtag: szl
Description: Silesian
Added: 2009-07-29
%%
Type: language
Subtag: szn
Description: Sula
Added: 2009-07-29
%%
Type: language
Subtag: szp
Description: Suabo
Added: 2009-07-29
%%
Type: language
Subtag: szs
Description: Solomon Islands Sign Language
Added: 2017-02-23
%%
Type: language
Subtag: szv
Description: Isu (Fako Division)
Added: 2009-07-29
%%
Type: language
Subtag: szw
Description: Sawai
Added: 2009-07-29
%%
Type: language
Subtag: szy
Description: Sakizaya
Added: 2019-04-16
%%
Type: language
Subtag: taa
Description: Lower Tanana
Added: 2009-07-29
%%
Type: language
Subtag: tab
Description: Tabassaran
Added: 2009-07-29
%%
Type: language
Subtag: tac
Description: Lowland Tarahumara
Added: 2009-07-29
%%
Type: language
Subtag: tad
Description: Tause
Added: 2009-07-29
%%
Type: language
Subtag: tae
Description: Tariana
Added: 2009-07-29
%%
Type: language
Subtag: taf
Description: Tapirapé
Added: 2009-07-29
%%
Type: language
Subtag: tag
Description: Tagoi
Added: 2009-07-29
%%
Type: language
Subtag: tai
Description: Tai languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: taj
Description: Eastern Tamang
Added: 2009-07-29
%%
Type: language
Subtag: tak
Description: Tala
Added: 2009-07-29
%%
Type: language
Subtag: tal
Description: Tal
Added: 2009-07-29
%%
Type: language
Subtag: tan
Description: Tangale
Added: 2009-07-29
%%
Type: language
Subtag: tao
Description: Yami
Added: 2009-07-29
%%
Type: language
Subtag: tap
Description: Taabwa
Added: 2009-07-29
%%
Type: language
Subtag: taq
Description: Tamasheq
Added: 2009-07-29
Macrolanguage: tmh
%%
Type: language
Subtag: tar
Description: Central Tarahumara
Added: 2009-07-29
%%
Type: language
Subtag: tas
Description: Tay Boi
Added: 2009-07-29
%%
Type: language
Subtag: tau
Description: Upper Tanana
Added: 2009-07-29
%%
Type: language
Subtag: tav
Description: Tatuyo
Added: 2009-07-29
%%
Type: language
Subtag: taw
Description: Tai
Added: 2009-07-29
%%
Type: language
Subtag: tax
Description: Tamki
Added: 2009-07-29
%%
Type: language
Subtag: tay
Description: Atayal
Added: 2009-07-29
%%
Type: language
Subtag: taz
Description: Tocho
Added: 2009-07-29
%%
Type: language
Subtag: tba
Description: Aikanã
Added: 2009-07-29
%%
Type: language
Subtag: tbb
Description: Tapeba
Added: 2009-07-29
%%
Type: language
Subtag: tbc
Description: Takia
Added: 2009-07-29
%%
Type: language
Subtag: tbd
Description: Kaki Ae
Added: 2009-07-29
%%
Type: language
Subtag: tbe
Description: Tanimbili
Added: 2009-07-29
%%
Type: language
Subtag: tbf
Description: Mandara
Added: 2009-07-29
%%
Type: language
Subtag: tbg
Description: North Tairora
Added: 2009-07-29
%%
Type: language
Subtag: tbh
Description: Dharawal
Description: Thurawal
Added: 2009-07-29
%%
Type: language
Subtag: tbi
Description: Gaam
Added: 2009-07-29
%%
Type: language
Subtag: tbj
Description: Tiang
Added: 2009-07-29
%%
Type: language
Subtag: tbk
Description: Calamian Tagbanwa
Added: 2009-07-29
%%
Type: language
Subtag: tbl
Description: Tboli
Added: 2009-07-29
%%
Type: language
Subtag: tbm
Description: Tagbu
Added: 2009-07-29
%%
Type: language
Subtag: tbn
Description: Barro Negro Tunebo
Added: 2009-07-29
%%
Type: language
Subtag: tbo
Description: Tawala
Added: 2009-07-29
%%
Type: language
Subtag: tbp
Description: Taworta
Description: Diebroud
Added: 2009-07-29
%%
Type: language
Subtag: tbq
Description: Tibeto-Burman languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: tbr
Description: Tumtum
Added: 2009-07-29
%%
Type: language
Subtag: tbs
Description: Tanguat
Added: 2009-07-29
%%
Type: language
Subtag: tbt
Description: Tembo (Kitembo)
Added: 2009-07-29
%%
Type: language
Subtag: tbu
Description: Tubar
Added: 2009-07-29
%%
Type: language
Subtag: tbv
Description: Tobo
Added: 2009-07-29
%%
Type: language
Subtag: tbw
Description: Tagbanwa
Added: 2009-07-29
%%
Type: language
Subtag: tbx
Description: Kapin
Added: 2009-07-29
%%
Type: language
Subtag: tby
Description: Tabaru
Added: 2009-07-29
%%
Type: language
Subtag: tbz
Description: Ditammari
Added: 2009-07-29
%%
Type: language
Subtag: tca
Description: Ticuna
Added: 2009-07-29
%%
Type: language
Subtag: tcb
Description: Tanacross
Added: 2009-07-29
%%
Type: language
Subtag: tcc
Description: Datooga
Added: 2009-07-29
%%
Type: language
Subtag: tcd
Description: Tafi
Added: 2009-07-29
%%
Type: language
Subtag: tce
Description: Southern Tutchone
Added: 2009-07-29
%%
Type: language
Subtag: tcf
Description: Malinaltepec Me'phaa
Description: Malinaltepec Tlapanec
Added: 2009-07-29
%%
Type: language
Subtag: tcg
Description: Tamagario
Added: 2009-07-29
%%
Type: language
Subtag: tch
Description: Turks And Caicos Creole English
Added: 2009-07-29
%%
Type: language
Subtag: tci
Description: Wára
Added: 2009-07-29
%%
Type: language
Subtag: tck
Description: Tchitchege
Added: 2009-07-29
%%
Type: language
Subtag: tcl
Description: Taman (Myanmar)
Added: 2009-07-29
%%
Type: language
Subtag: tcm
Description: Tanahmerah
Added: 2009-07-29
%%
Type: language
Subtag: tcn
Description: Tichurong
Added: 2009-07-29
%%
Type: language
Subtag: tco
Description: Taungyo
Added: 2009-07-29
%%
Type: language
Subtag: tcp
Description: Tawr Chin
Added: 2009-07-29
%%
Type: language
Subtag: tcq
Description: Kaiy
Added: 2009-07-29
%%
Type: language
Subtag: tcs
Description: Torres Strait Creole
Description: Yumplatok
Added: 2009-07-29
%%
Type: language
Subtag: tct
Description: T'en
Added: 2009-07-29
%%
Type: language
Subtag: tcu
Description: Southeastern Tarahumara
Added: 2009-07-29
%%
Type: language
Subtag: tcw
Description: Tecpatlán Totonac
Added: 2009-07-29
%%
Type: language
Subtag: tcx
Description: Toda
Added: 2009-07-29
%%
Type: language
Subtag: tcy
Description: Tulu
Added: 2009-07-29
%%
Type: language
Subtag: tcz
Description: Thado Chin
Added: 2009-07-29
%%
Type: language
Subtag: tda
Description: Tagdal
Added: 2009-07-29
%%
Type: language
Subtag: tdb
Description: Panchpargania
Added: 2009-07-29
%%
Type: language
Subtag: tdc
Description: Emberá-Tadó
Added: 2009-07-29
%%
Type: language
Subtag: tdd
Description: Tai Nüa
Added: 2009-07-29
%%
Type: language
Subtag: tde
Description: Tiranige Diga Dogon
Added: 2010-03-11
%%
Type: language
Subtag: tdf
Description: Talieng
Added: 2009-07-29
%%
Type: language
Subtag: tdg
Description: Western Tamang
Added: 2009-07-29
%%
Type: language
Subtag: tdh
Description: Thulung
Added: 2009-07-29
%%
Type: language
Subtag: tdi
Description: Tomadino
Added: 2009-07-29
%%
Type: language
Subtag: tdj
Description: Tajio
Added: 2009-07-29
%%
Type: language
Subtag: tdk
Description: Tambas
Added: 2009-07-29
%%
Type: language
Subtag: tdl
Description: Sur
Added: 2009-07-29
%%
Type: language
Subtag: tdm
Description: Taruma
Added: 2016-05-30
%%
Type: language
Subtag: tdn
Description: Tondano
Added: 2009-07-29
%%
Type: language
Subtag: tdo
Description: Teme
Added: 2009-07-29
%%
Type: language
Subtag: tdq
Description: Tita
Added: 2009-07-29
%%
Type: language
Subtag: tdr
Description: Todrah
Added: 2009-07-29
%%
Type: language
Subtag: tds
Description: Doutai
Added: 2009-07-29
%%
Type: language
Subtag: tdt
Description: Tetun Dili
Added: 2009-07-29
%%
Type: language
Subtag: tdu
Description: Tempasuk Dusun
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: dtp
%%
Type: language
Subtag: tdv
Description: Toro
Added: 2009-07-29
%%
Type: language
Subtag: tdx
Description: Tandroy-Mahafaly Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: tdy
Description: Tadyawan
Added: 2009-07-29
%%
Type: language
Subtag: tea
Description: Temiar
Added: 2009-07-29
%%
Type: language
Subtag: teb
Description: Tetete
Added: 2009-07-29
%%
Type: language
Subtag: tec
Description: Terik
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: ted
Description: Tepo Krumen
Added: 2009-07-29
%%
Type: language
Subtag: tee
Description: Huehuetla Tepehua
Added: 2009-07-29
%%
Type: language
Subtag: tef
Description: Teressa
Added: 2009-07-29
%%
Type: language
Subtag: teg
Description: Teke-Tege
Added: 2009-07-29
%%
Type: language
Subtag: teh
Description: Tehuelche
Added: 2009-07-29
%%
Type: language
Subtag: tei
Description: Torricelli
Added: 2009-07-29
%%
Type: language
Subtag: tek
Description: Ibali Teke
Added: 2009-07-29
%%
Type: language
Subtag: tem
Description: Timne
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: ten
Description: Tama (Colombia)
Added: 2009-07-29
%%
Type: language
Subtag: teo
Description: Teso
Added: 2009-07-29
%%
Type: language
Subtag: tep
Description: Tepecano
Added: 2009-07-29
%%
Type: language
Subtag: teq
Description: Temein
Added: 2009-07-29
%%
Type: language
Subtag: ter
Description: Tereno
Added: 2005-10-16
%%
Type: language
Subtag: tes
Description: Tengger
Added: 2009-07-29
%%
Type: language
Subtag: tet
Description: Tetum
Added: 2005-10-16
%%
Type: language
Subtag: teu
Description: Soo
Added: 2009-07-29
%%
Type: language
Subtag: tev
Description: Teor
Added: 2009-07-29
%%
Type: language
Subtag: tew
Description: Tewa (USA)
Added: 2009-07-29
%%
Type: language
Subtag: tex
Description: Tennet
Added: 2009-07-29
%%
Type: language
Subtag: tey
Description: Tulishi
Added: 2009-07-29
%%
Type: language
Subtag: tez
Description: Tetserret
Added: 2018-03-08
%%
Type: language
Subtag: tfi
Description: Tofin Gbe
Added: 2009-07-29
%%
Type: language
Subtag: tfn
Description: Tanaina
Added: 2009-07-29
%%
Type: language
Subtag: tfo
Description: Tefaro
Added: 2009-07-29
%%
Type: language
Subtag: tfr
Description: Teribe
Added: 2009-07-29
%%
Type: language
Subtag: tft
Description: Ternate
Added: 2009-07-29
%%
Type: language
Subtag: tga
Description: Sagalla
Added: 2009-07-29
%%
Type: language
Subtag: tgb
Description: Tobilung
Added: 2009-07-29
%%
Type: language
Subtag: tgc
Description: Tigak
Added: 2009-07-29
%%
Type: language
Subtag: tgd
Description: Ciwogai
Added: 2009-07-29
%%
Type: language
Subtag: tge
Description: Eastern Gorkha Tamang
Added: 2009-07-29
%%
Type: language
Subtag: tgf
Description: Chalikha
Added: 2009-07-29
%%
Type: language
Subtag: tgg
Description: Tangga
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see bjp, hrc, hrw
%%
Type: language
Subtag: tgh
Description: Tobagonian Creole English
Added: 2009-07-29
%%
Type: language
Subtag: tgi
Description: Lawunuia
Added: 2009-07-29
%%
Type: language
Subtag: tgj
Description: Tagin
Added: 2012-08-12
%%
Type: language
Subtag: tgn
Description: Tandaganon
Added: 2010-03-11
%%
Type: language
Subtag: tgo
Description: Sudest
Added: 2009-07-29
%%
Type: language
Subtag: tgp
Description: Tangoa
Added: 2009-07-29
%%
Type: language
Subtag: tgq
Description: Tring
Added: 2009-07-29
%%
Type: language
Subtag: tgr
Description: Tareng
Added: 2009-07-29
%%
Type: language
Subtag: tgs
Description: Nume
Added: 2009-07-29
%%
Type: language
Subtag: tgt
Description: Central Tagbanwa
Added: 2009-07-29
%%
Type: language
Subtag: tgu
Description: Tanggu
Added: 2009-07-29
%%
Type: language
Subtag: tgv
Description: Tingui-Boto
Added: 2009-07-29
%%
Type: language
Subtag: tgw
Description: Tagwana Senoufo
Added: 2009-07-29
%%
Type: language
Subtag: tgx
Description: Tagish
Added: 2009-07-29
%%
Type: language
Subtag: tgy
Description: Togoyo
Added: 2009-07-29
%%
Type: language
Subtag: tgz
Description: Tagalaka
Added: 2012-08-12
%%
Type: language
Subtag: thc
Description: Tai Hang Tong
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: tpo
%%
Type: language
Subtag: thd
Description: Kuuk Thaayorre
Description: Thayore
Added: 2009-07-29
%%
Type: language
Subtag: the
Description: Chitwania Tharu
Added: 2009-07-29
%%
Type: language
Subtag: thf
Description: Thangmi
Added: 2009-07-29
%%
Type: language
Subtag: thh
Description: Northern Tarahumara
Added: 2009-07-29
%%
Type: language
Subtag: thi
Description: Tai Long
Added: 2009-07-29
%%
Type: language
Subtag: thk
Description: Tharaka
Description: Kitharaka
Added: 2009-07-29
%%
Type: language
Subtag: thl
Description: Dangaura Tharu
Added: 2009-07-29
%%
Type: language
Subtag: thm
Description: Aheu
Added: 2009-07-29
%%
Type: language
Subtag: thn
Description: Thachanadan
Added: 2009-07-29
%%
Type: language
Subtag: thp
Description: Thompson
Added: 2009-07-29
%%
Type: language
Subtag: thq
Description: Kochila Tharu
Added: 2009-07-29
%%
Type: language
Subtag: thr
Description: Rana Tharu
Added: 2009-07-29
%%
Type: language
Subtag: ths
Description: Thakali
Added: 2009-07-29
%%
Type: language
Subtag: tht
Description: Tahltan
Added: 2009-07-29
%%
Type: language
Subtag: thu
Description: Thuri
Added: 2009-07-29
%%
Type: language
Subtag: thv
Description: Tahaggart Tamahaq
Added: 2009-07-29
Macrolanguage: tmh
%%
Type: language
Subtag: thw
Description: Thudam
Added: 2009-07-29
%%
Type: language
Subtag: thx
Description: The
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: oyb
%%
Type: language
Subtag: thy
Description: Tha
Added: 2009-07-29
%%
Type: language
Subtag: thz
Description: Tayart Tamajeq
Added: 2009-07-29
Macrolanguage: tmh
%%
Type: language
Subtag: tia
Description: Tidikelt Tamazight
Added: 2009-07-29
%%
Type: language
Subtag: tic
Description: Tira
Added: 2009-07-29
%%
Type: language
Subtag: tid
Description: Tidong
Added: 2009-07-29
Deprecated: 2016-05-30
Comments: see itd, ntd
%%
Type: language
Subtag: tie
Description: Tingal
Added: 2009-07-29
Deprecated: 2011-08-16
Preferred-Value: ras
%%
Type: language
Subtag: tif
Description: Tifal
Added: 2009-07-29
%%
Type: language
Subtag: tig
Description: Tigre
Added: 2005-10-16
%%
Type: language
Subtag: tih
Description: Timugon Murut
Added: 2009-07-29
%%
Type: language
Subtag: tii
Description: Tiene
Added: 2009-07-29
%%
Type: language
Subtag: tij
Description: Tilung
Added: 2009-07-29
%%
Type: language
Subtag: tik
Description: Tikar
Added: 2009-07-29
%%
Type: language
Subtag: til
Description: Tillamook
Added: 2009-07-29
%%
Type: language
Subtag: tim
Description: Timbe
Added: 2009-07-29
%%
Type: language
Subtag: tin
Description: Tindi
Added: 2009-07-29
%%
Type: language
Subtag: tio
Description: Teop
Added: 2009-07-29
%%
Type: language
Subtag: tip
Description: Trimuris
Added: 2009-07-29
%%
Type: language
Subtag: tiq
Description: Tiéfo
Added: 2009-07-29
%%
Type: language
Subtag: tis
Description: Masadiit Itneg
Added: 2009-07-29
%%
Type: language
Subtag: tit
Description: Tinigua
Added: 2009-07-29
%%
Type: language
Subtag: tiu
Description: Adasen
Added: 2009-07-29
%%
Type: language
Subtag: tiv
Description: Tiv
Added: 2005-10-16
%%
Type: language
Subtag: tiw
Description: Tiwi
Added: 2009-07-29
%%
Type: language
Subtag: tix
Description: Southern Tiwa
Added: 2009-07-29
%%
Type: language
Subtag: tiy
Description: Tiruray
Added: 2009-07-29
%%
Type: language
Subtag: tiz
Description: Tai Hongjin
Added: 2009-07-29
%%
Type: language
Subtag: tja
Description: Tajuasohn
Added: 2009-07-29
%%
Type: language
Subtag: tjg
Description: Tunjung
Added: 2009-07-29
%%
Type: language
Subtag: tji
Description: Northern Tujia
Added: 2009-07-29
%%
Type: language
Subtag: tjj
Description: Tjungundji
Added: 2019-04-16
%%
Type: language
Subtag: tjl
Description: Tai Laing
Added: 2012-08-12
%%
Type: language
Subtag: tjm
Description: Timucua
Added: 2009-07-29
%%
Type: language
Subtag: tjn
Description: Tonjon
Added: 2009-07-29
%%
Type: language
Subtag: tjo
Description: Temacine Tamazight
Added: 2009-07-29
%%
Type: language
Subtag: tjp
Description: Tjupany
Added: 2019-04-16
%%
Type: language
Subtag: tjs
Description: Southern Tujia
Added: 2009-07-29
%%
Type: language
Subtag: tju
Description: Tjurruru
Added: 2009-07-29
%%
Type: language
Subtag: tjw
Description: Djabwurrung
Added: 2013-09-10
%%
Type: language
Subtag: tka
Description: Truká
Added: 2009-07-29
%%
Type: language
Subtag: tkb
Description: Buksa
Added: 2009-07-29
%%
Type: language
Subtag: tkd
Description: Tukudede
Added: 2009-07-29
%%
Type: language
Subtag: tke
Description: Takwane
Added: 2009-07-29
%%
Type: language
Subtag: tkf
Description: Tukumanféd
Added: 2009-07-29
%%
Type: language
Subtag: tkg
Description: Tesaka Malagasy
Added: 2011-08-16
Macrolanguage: mg
%%
Type: language
Subtag: tkk
Description: Takpa
Added: 2009-07-29
Deprecated: 2011-08-16
Preferred-Value: twm
%%
Type: language
Subtag: tkl
Description: Tokelau
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: tkm
Description: Takelma
Added: 2009-07-29
%%
Type: language
Subtag: tkn
Description: Toku-No-Shima
Added: 2009-07-29
%%
Type: language
Subtag: tkp
Description: Tikopia
Added: 2009-07-29
%%
Type: language
Subtag: tkq
Description: Tee
Added: 2009-07-29
%%
Type: language
Subtag: tkr
Description: Tsakhur
Added: 2009-07-29
%%
Type: language
Subtag: tks
Description: Takestani
Added: 2009-07-29
%%
Type: language
Subtag: tkt
Description: Kathoriya Tharu
Added: 2009-07-29
%%
Type: language
Subtag: tku
Description: Upper Necaxa Totonac
Added: 2009-07-29
%%
Type: language
Subtag: tkv
Description: Mur Pano
Added: 2014-02-28
%%
Type: language
Subtag: tkw
Description: Teanu
Added: 2009-07-29
%%
Type: language
Subtag: tkx
Description: Tangko
Added: 2009-07-29
%%
Type: language
Subtag: tkz
Description: Takua
Added: 2009-07-29
%%
Type: language
Subtag: tla
Description: Southwestern Tepehuan
Added: 2009-07-29
%%
Type: language
Subtag: tlb
Description: Tobelo
Added: 2009-07-29
%%
Type: language
Subtag: tlc
Description: Yecuatla Totonac
Added: 2009-07-29
%%
Type: language
Subtag: tld
Description: Talaud
Added: 2009-07-29
%%
Type: language
Subtag: tlf
Description: Telefol
Added: 2009-07-29
%%
Type: language
Subtag: tlg
Description: Tofanma
Added: 2009-07-29
%%
Type: language
Subtag: tlh
Description: Klingon
Description: tlhIngan Hol
Added: 2005-10-16
%%
Type: language
Subtag: tli
Description: Tlingit
Added: 2005-10-16
%%
Type: language
Subtag: tlj
Description: Talinga-Bwisi
Added: 2009-07-29
%%
Type: language
Subtag: tlk
Description: Taloki
Added: 2009-07-29
%%
Type: language
Subtag: tll
Description: Tetela
Added: 2009-07-29
%%
Type: language
Subtag: tlm
Description: Tolomako
Added: 2009-07-29
%%
Type: language
Subtag: tln
Description: Talondo'
Added: 2009-07-29
%%
Type: language
Subtag: tlo
Description: Talodi
Added: 2009-07-29
%%
Type: language
Subtag: tlp
Description: Filomena Mata-Coahuitlán Totonac
Added: 2009-07-29
%%
Type: language
Subtag: tlq
Description: Tai Loi
Added: 2009-07-29
%%
Type: language
Subtag: tlr
Description: Talise
Added: 2009-07-29
%%
Type: language
Subtag: tls
Description: Tambotalo
Added: 2009-07-29
%%
Type: language
Subtag: tlt
Description: Sou Nama
Description: Teluti
Added: 2009-07-29
%%
Type: language
Subtag: tlu
Description: Tulehu
Added: 2009-07-29
%%
Type: language
Subtag: tlv
Description: Taliabu
Added: 2009-07-29
%%
Type: language
Subtag: tlw
Description: South Wemale
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: weo
%%
Type: language
Subtag: tlx
Description: Khehek
Added: 2009-07-29
%%
Type: language
Subtag: tly
Description: Talysh
Added: 2009-07-29
%%
Type: language
Subtag: tma
Description: Tama (Chad)
Added: 2009-07-29
%%
Type: language
Subtag: tmb
Description: Katbol
Description: Avava
Added: 2009-07-29
%%
Type: language
Subtag: tmc
Description: Tumak
Added: 2009-07-29
%%
Type: language
Subtag: tmd
Description: Haruai
Added: 2009-07-29
%%
Type: language
Subtag: tme
Description: Tremembé
Added: 2009-07-29
%%
Type: language
Subtag: tmf
Description: Toba-Maskoy
Added: 2009-07-29
%%
Type: language
Subtag: tmg
Description: Ternateño
Added: 2009-07-29
%%
Type: language
Subtag: tmh
Description: Tamashek
Added: 2005-10-16
Suppress-Script: Latn
Scope: macrolanguage
%%
Type: language
Subtag: tmi
Description: Tutuba
Added: 2009-07-29
%%
Type: language
Subtag: tmj
Description: Samarokena
Added: 2009-07-29
%%
Type: language
Subtag: tmk
Description: Northwestern Tamang
Added: 2009-07-29
%%
Type: language
Subtag: tml
Description: Tamnim Citak
Added: 2009-07-29
%%
Type: language
Subtag: tmm
Description: Tai Thanh
Added: 2009-07-29
%%
Type: language
Subtag: tmn
Description: Taman (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: tmo
Description: Temoq
Added: 2009-07-29
%%
Type: language
Subtag: tmp
Description: Tai Mène
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: tyj
%%
Type: language
Subtag: tmq
Description: Tumleo
Added: 2009-07-29
%%
Type: language
Subtag: tmr
Description: Jewish Babylonian Aramaic (ca. 200-1200 CE)
Added: 2009-07-29
%%
Type: language
Subtag: tms
Description: Tima
Added: 2009-07-29
%%
Type: language
Subtag: tmt
Description: Tasmate
Added: 2009-07-29
%%
Type: language
Subtag: tmu
Description: Iau
Added: 2009-07-29
%%
Type: language
Subtag: tmv
Description: Tembo (Motembo)
Added: 2009-07-29
%%
Type: language
Subtag: tmw
Description: Temuan
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: tmy
Description: Tami
Added: 2009-07-29
%%
Type: language
Subtag: tmz
Description: Tamanaku
Added: 2009-07-29
%%
Type: language
Subtag: tna
Description: Tacana
Added: 2009-07-29
%%
Type: language
Subtag: tnb
Description: Western Tunebo
Added: 2009-07-29
%%
Type: language
Subtag: tnc
Description: Tanimuca-Retuarã
Added: 2009-07-29
%%
Type: language
Subtag: tnd
Description: Angosturas Tunebo
Added: 2009-07-29
%%
Type: language
Subtag: tne
Description: Tinoc Kallahan
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: kak
%%
Type: language
Subtag: tnf
Description: Tangshewi
Added: 2009-07-29
Deprecated: 2010-03-11
Preferred-Value: prs
%%
Type: language
Subtag: tng
Description: Tobanga
Added: 2009-07-29
%%
Type: language
Subtag: tnh
Description: Maiani
Added: 2009-07-29
%%
Type: language
Subtag: tni
Description: Tandia
Added: 2009-07-29
%%
Type: language
Subtag: tnk
Description: Kwamera
Added: 2009-07-29
%%
Type: language
Subtag: tnl
Description: Lenakel
Added: 2009-07-29
%%
Type: language
Subtag: tnm
Description: Tabla
Added: 2009-07-29
%%
Type: language
Subtag: tnn
Description: North Tanna
Added: 2009-07-29
%%
Type: language
Subtag: tno
Description: Toromono
Added: 2009-07-29
%%
Type: language
Subtag: tnp
Description: Whitesands
Added: 2009-07-29
%%
Type: language
Subtag: tnq
Description: Taino
Added: 2009-07-29
%%
Type: language
Subtag: tnr
Description: Ménik
Added: 2009-07-29
%%
Type: language
Subtag: tns
Description: Tenis
Added: 2009-07-29
%%
Type: language
Subtag: tnt
Description: Tontemboan
Added: 2009-07-29
%%
Type: language
Subtag: tnu
Description: Tay Khang
Added: 2009-07-29
%%
Type: language
Subtag: tnv
Description: Tangchangya
Added: 2009-07-29
%%
Type: language
Subtag: tnw
Description: Tonsawang
Added: 2009-07-29
%%
Type: language
Subtag: tnx
Description: Tanema
Added: 2009-07-29
%%
Type: language
Subtag: tny
Description: Tongwe
Added: 2009-07-29
%%
Type: language
Subtag: tnz
Description: Ten'edn
Added: 2009-07-29
%%
Type: language
Subtag: tob
Description: Toba
Added: 2009-07-29
%%
Type: language
Subtag: toc
Description: Coyutla Totonac
Added: 2009-07-29
%%
Type: language
Subtag: tod
Description: Toma
Added: 2009-07-29
%%
Type: language
Subtag: toe
Description: Tomedes
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: tof
Description: Gizrra
Added: 2009-07-29
%%
Type: language
Subtag: tog
Description: Tonga (Nyasa)
Added: 2005-10-16
%%
Type: language
Subtag: toh
Description: Gitonga
Added: 2009-07-29
%%
Type: language
Subtag: toi
Description: Tonga (Zambia)
Added: 2009-07-29
%%
Type: language
Subtag: toj
Description: Tojolabal
Added: 2009-07-29
%%
Type: language
Subtag: tol
Description: Tolowa
Added: 2009-07-29
%%
Type: language
Subtag: tom
Description: Tombulu
Added: 2009-07-29
%%
Type: language
Subtag: too
Description: Xicotepec De Juárez Totonac
Added: 2009-07-29
%%
Type: language
Subtag: top
Description: Papantla Totonac
Added: 2009-07-29
%%
Type: language
Subtag: toq
Description: Toposa
Added: 2009-07-29
%%
Type: language
Subtag: tor
Description: Togbo-Vara Banda
Added: 2009-07-29
%%
Type: language
Subtag: tos
Description: Highland Totonac
Added: 2009-07-29
%%
Type: language
Subtag: tou
Description: Tho
Added: 2009-07-29
%%
Type: language
Subtag: tov
Description: Upper Taromi
Added: 2009-07-29
%%
Type: language
Subtag: tow
Description: Jemez
Added: 2009-07-29
%%
Type: language
Subtag: tox
Description: Tobian
Added: 2009-07-29
%%
Type: language
Subtag: toy
Description: Topoiyo
Added: 2009-07-29
%%
Type: language
Subtag: toz
Description: To
Added: 2009-07-29
%%
Type: language
Subtag: tpa
Description: Taupota
Added: 2009-07-29
%%
Type: language
Subtag: tpc
Description: Azoyú Me'phaa
Description: Azoyú Tlapanec
Added: 2009-07-29
%%
Type: language
Subtag: tpe
Description: Tippera
Added: 2009-07-29
%%
Type: language
Subtag: tpf
Description: Tarpia
Added: 2009-07-29
%%
Type: language
Subtag: tpg
Description: Kula
Added: 2009-07-29
%%
Type: language
Subtag: tpi
Description: Tok Pisin
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: tpj
Description: Tapieté
Added: 2009-07-29
%%
Type: language
Subtag: tpk
Description: Tupinikin
Added: 2009-07-29
%%
Type: language
Subtag: tpl
Description: Tlacoapa Me'phaa
Description: Tlacoapa Tlapanec
Added: 2009-07-29
%%
Type: language
Subtag: tpm
Description: Tampulma
Added: 2009-07-29
%%
Type: language
Subtag: tpn
Description: Tupinambá
Added: 2009-07-29
%%
Type: language
Subtag: tpo
Description: Tai Pao
Added: 2009-07-29
%%
Type: language
Subtag: tpp
Description: Pisaflores Tepehua
Added: 2009-07-29
%%
Type: language
Subtag: tpq
Description: Tukpa
Added: 2009-07-29
%%
Type: language
Subtag: tpr
Description: Tuparí
Added: 2009-07-29
%%
Type: language
Subtag: tpt
Description: Tlachichilco Tepehua
Added: 2009-07-29
%%
Type: language
Subtag: tpu
Description: Tampuan
Added: 2009-07-29
%%
Type: language
Subtag: tpv
Description: Tanapag
Added: 2009-07-29
%%
Type: language
Subtag: tpw
Description: Tupí
Added: 2009-07-29
%%
Type: language
Subtag: tpx
Description: Acatepec Me'phaa
Description: Acatepec Tlapanec
Added: 2009-07-29
%%
Type: language
Subtag: tpy
Description: Trumai
Added: 2009-07-29
%%
Type: language
Subtag: tpz
Description: Tinputz
Added: 2009-07-29
%%
Type: language
Subtag: tqb
Description: Tembé
Added: 2009-07-29
%%
Type: language
Subtag: tql
Description: Lehali
Added: 2009-07-29
%%
Type: language
Subtag: tqm
Description: Turumsa
Added: 2009-07-29
%%
Type: language
Subtag: tqn
Description: Tenino
Added: 2009-07-29
%%
Type: language
Subtag: tqo
Description: Toaripi
Added: 2009-07-29
%%
Type: language
Subtag: tqp
Description: Tomoip
Added: 2009-07-29
%%
Type: language
Subtag: tqq
Description: Tunni
Added: 2009-07-29
%%
Type: language
Subtag: tqr
Description: Torona
Added: 2009-07-29
%%
Type: language
Subtag: tqt
Description: Western Totonac
Added: 2009-07-29
%%
Type: language
Subtag: tqu
Description: Touo
Added: 2009-07-29
%%
Type: language
Subtag: tqw
Description: Tonkawa
Added: 2009-07-29
%%
Type: language
Subtag: tra
Description: Tirahi
Added: 2009-07-29
%%
Type: language
Subtag: trb
Description: Terebu
Added: 2009-07-29
%%
Type: language
Subtag: trc
Description: Copala Triqui
Added: 2009-07-29
%%
Type: language
Subtag: trd
Description: Turi
Added: 2009-07-29
%%
Type: language
Subtag: tre
Description: East Tarangan
Added: 2009-07-29
%%
Type: language
Subtag: trf
Description: Trinidadian Creole English
Added: 2009-07-29
%%
Type: language
Subtag: trg
Description: Lishán Didán
Added: 2009-07-29
%%
Type: language
Subtag: trh
Description: Turaka
Added: 2009-07-29
%%
Type: language
Subtag: tri
Description: Trió
Added: 2009-07-29
%%
Type: language
Subtag: trj
Description: Toram
Added: 2009-07-29
%%
Type: language
Subtag: trk
Description: Turkic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: trl
Description: Traveller Scottish
Added: 2009-07-29
%%
Type: language
Subtag: trm
Description: Tregami
Added: 2009-07-29
%%
Type: language
Subtag: trn
Description: Trinitario
Added: 2009-07-29
%%
Type: language
Subtag: tro
Description: Tarao Naga
Added: 2009-07-29
%%
Type: language
Subtag: trp
Description: Kok Borok
Added: 2009-07-29
%%
Type: language
Subtag: trq
Description: San Martín Itunyoso Triqui
Added: 2009-07-29
%%
Type: language
Subtag: trr
Description: Taushiro
Added: 2009-07-29
%%
Type: language
Subtag: trs
Description: Chicahuaxtla Triqui
Added: 2009-07-29
%%
Type: language
Subtag: trt
Description: Tunggare
Added: 2009-07-29
%%
Type: language
Subtag: tru
Description: Turoyo
Description: Surayt
Added: 2009-07-29
%%
Type: language
Subtag: trv
Description: Taroko
Added: 2009-07-29
%%
Type: language
Subtag: trw
Description: Torwali
Added: 2009-07-29
%%
Type: language
Subtag: trx
Description: Tringgus-Sembaan Bidayuh
Added: 2009-07-29
%%
Type: language
Subtag: try
Description: Turung
Added: 2009-07-29
%%
Type: language
Subtag: trz
Description: Torá
Added: 2009-07-29
%%
Type: language
Subtag: tsa
Description: Tsaangi
Added: 2009-07-29
%%
Type: language
Subtag: tsb
Description: Tsamai
Added: 2009-07-29
%%
Type: language
Subtag: tsc
Description: Tswa
Added: 2009-07-29
%%
Type: language
Subtag: tsd
Description: Tsakonian
Added: 2009-07-29
%%
Type: language
Subtag: tse
Description: Tunisian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: tsf
Description: Southwestern Tamang
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: taj
%%
Type: language
Subtag: tsg
Description: Tausug
Added: 2009-07-29
%%
Type: language
Subtag: tsh
Description: Tsuvan
Added: 2009-07-29
%%
Type: language
Subtag: tsi
Description: Tsimshian
Added: 2005-10-16
%%
Type: language
Subtag: tsj
Description: Tshangla
Added: 2009-07-29
%%
Type: language
Subtag: tsk
Description: Tseku
Added: 2009-07-29
%%
Type: language
Subtag: tsl
Description: Ts'ün-Lao
Added: 2009-07-29
%%
Type: language
Subtag: tsm
Description: Turkish Sign Language
Description: Türk İşaret Dili
Added: 2009-07-29
%%
Type: language
Subtag: tsp
Description: Northern Toussian
Added: 2009-07-29
%%
Type: language
Subtag: tsq
Description: Thai Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: tsr
Description: Akei
Added: 2009-07-29
%%
Type: language
Subtag: tss
Description: Taiwan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: tst
Description: Tondi Songway Kiini
Added: 2011-08-16
%%
Type: language
Subtag: tsu
Description: Tsou
Added: 2009-07-29
%%
Type: language
Subtag: tsv
Description: Tsogo
Added: 2009-07-29
%%
Type: language
Subtag: tsw
Description: Tsishingini
Added: 2009-07-29
%%
Type: language
Subtag: tsx
Description: Mubami
Added: 2009-07-29
%%
Type: language
Subtag: tsy
Description: Tebul Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: tsz
Description: Purepecha
Added: 2009-07-29
%%
Type: language
Subtag: tta
Description: Tutelo
Added: 2009-07-29
%%
Type: language
Subtag: ttb
Description: Gaa
Added: 2009-07-29
%%
Type: language
Subtag: ttc
Description: Tektiteko
Added: 2009-07-29
%%
Type: language
Subtag: ttd
Description: Tauade
Added: 2009-07-29
%%
Type: language
Subtag: tte
Description: Bwanabwana
Added: 2009-07-29
%%
Type: language
Subtag: ttf
Description: Tuotomb
Added: 2009-07-29
%%
Type: language
Subtag: ttg
Description: Tutong
Added: 2009-07-29
%%
Type: language
Subtag: tth
Description: Upper Ta'oih
Added: 2009-07-29
%%
Type: language
Subtag: tti
Description: Tobati
Added: 2009-07-29
%%
Type: language
Subtag: ttj
Description: Tooro
Added: 2009-07-29
%%
Type: language
Subtag: ttk
Description: Totoro
Added: 2009-07-29
%%
Type: language
Subtag: ttl
Description: Totela
Added: 2009-07-29
%%
Type: language
Subtag: ttm
Description: Northern Tutchone
Added: 2009-07-29
%%
Type: language
Subtag: ttn
Description: Towei
Added: 2009-07-29
%%
Type: language
Subtag: tto
Description: Lower Ta'oih
Added: 2009-07-29
%%
Type: language
Subtag: ttp
Description: Tombelala
Added: 2009-07-29
%%
Type: language
Subtag: ttq
Description: Tawallammat Tamajaq
Added: 2009-07-29
Macrolanguage: tmh
%%
Type: language
Subtag: ttr
Description: Tera
Added: 2009-07-29
%%
Type: language
Subtag: tts
Description: Northeastern Thai
Added: 2009-07-29
%%
Type: language
Subtag: ttt
Description: Muslim Tat
Added: 2009-07-29
%%
Type: language
Subtag: ttu
Description: Torau
Added: 2009-07-29
%%
Type: language
Subtag: ttv
Description: Titan
Added: 2009-07-29
%%
Type: language
Subtag: ttw
Description: Long Wat
Added: 2009-07-29
%%
Type: language
Subtag: tty
Description: Sikaritai
Added: 2009-07-29
%%
Type: language
Subtag: ttz
Description: Tsum
Added: 2009-07-29
%%
Type: language
Subtag: tua
Description: Wiarumus
Added: 2009-07-29
%%
Type: language
Subtag: tub
Description: Tübatulabal
Added: 2009-07-29
%%
Type: language
Subtag: tuc
Description: Mutu
Added: 2009-07-29
%%
Type: language
Subtag: tud
Description: Tuxá
Added: 2009-07-29
%%
Type: language
Subtag: tue
Description: Tuyuca
Added: 2009-07-29
%%
Type: language
Subtag: tuf
Description: Central Tunebo
Added: 2009-07-29
%%
Type: language
Subtag: tug
Description: Tunia
Added: 2009-07-29
%%
Type: language
Subtag: tuh
Description: Taulil
Added: 2009-07-29
%%
Type: language
Subtag: tui
Description: Tupuri
Added: 2009-07-29
%%
Type: language
Subtag: tuj
Description: Tugutil
Added: 2009-07-29
%%
Type: language
Subtag: tul
Description: Tula
Added: 2009-07-29
%%
Type: language
Subtag: tum
Description: Tumbuka
Added: 2005-10-16
%%
Type: language
Subtag: tun
Description: Tunica
Added: 2009-07-29
%%
Type: language
Subtag: tuo
Description: Tucano
Added: 2009-07-29
%%
Type: language
Subtag: tup
Description: Tupi languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: tuq
Description: Tedaga
Added: 2009-07-29
%%
Type: language
Subtag: tus
Description: Tuscarora
Added: 2009-07-29
%%
Type: language
Subtag: tut
Description: Altaic languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: tuu
Description: Tututni
Added: 2009-07-29
%%
Type: language
Subtag: tuv
Description: Turkana
Added: 2009-07-29
%%
Type: language
Subtag: tuw
Description: Tungus languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: tux
Description: Tuxináwa
Added: 2009-07-29
%%
Type: language
Subtag: tuy
Description: Tugen
Added: 2009-07-29
Macrolanguage: kln
%%
Type: language
Subtag: tuz
Description: Turka
Added: 2009-07-29
%%
Type: language
Subtag: tva
Description: Vaghua
Added: 2009-07-29
%%
Type: language
Subtag: tvd
Description: Tsuvadi
Added: 2009-07-29
%%
Type: language
Subtag: tve
Description: Te'un
Added: 2009-07-29
%%
Type: language
Subtag: tvk
Description: Southeast Ambrym
Added: 2009-07-29
%%
Type: language
Subtag: tvl
Description: Tuvalu
Added: 2005-10-16
Suppress-Script: Latn
%%
Type: language
Subtag: tvm
Description: Tela-Masbuar
Added: 2009-07-29
%%
Type: language
Subtag: tvn
Description: Tavoyan
Added: 2009-07-29
%%
Type: language
Subtag: tvo
Description: Tidore
Added: 2009-07-29
%%
Type: language
Subtag: tvs
Description: Taveta
Added: 2009-07-29
%%
Type: language
Subtag: tvt
Description: Tutsa Naga
Added: 2009-07-29
%%
Type: language
Subtag: tvu
Description: Tunen
Added: 2012-08-12
%%
Type: language
Subtag: tvw
Description: Sedoa
Added: 2009-07-29
%%
Type: language
Subtag: tvx
Description: Taivoan
Added: 2019-04-16
%%
Type: language
Subtag: tvy
Description: Timor Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: twa
Description: Twana
Added: 2009-07-29
%%
Type: language
Subtag: twb
Description: Western Tawbuid
Added: 2009-07-29
%%
Type: language
Subtag: twc
Description: Teshenawa
Added: 2009-07-29
%%
Type: language
Subtag: twd
Description: Twents
Added: 2009-07-29
%%
Type: language
Subtag: twe
Description: Tewa (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: twf
Description: Northern Tiwa
Added: 2009-07-29
%%
Type: language
Subtag: twg
Description: Tereweng
Added: 2009-07-29
%%
Type: language
Subtag: twh
Description: Tai Dón
Added: 2009-07-29
%%
Type: language
Subtag: twl
Description: Tawara
Added: 2009-07-29
%%
Type: language
Subtag: twm
Description: Tawang Monpa
Added: 2009-07-29
%%
Type: language
Subtag: twn
Description: Twendi
Added: 2009-07-29
%%
Type: language
Subtag: two
Description: Tswapong
Added: 2009-07-29
%%
Type: language
Subtag: twp
Description: Ere
Added: 2009-07-29
%%
Type: language
Subtag: twq
Description: Tasawaq
Added: 2009-07-29
%%
Type: language
Subtag: twr
Description: Southwestern Tarahumara
Added: 2009-07-29
%%
Type: language
Subtag: twt
Description: Turiwára
Added: 2009-07-29
%%
Type: language
Subtag: twu
Description: Termanu
Added: 2009-07-29
%%
Type: language
Subtag: tww
Description: Tuwari
Added: 2009-07-29
%%
Type: language
Subtag: twx
Description: Tewe
Added: 2009-07-29
%%
Type: language
Subtag: twy
Description: Tawoyan
Added: 2009-07-29
%%
Type: language
Subtag: txa
Description: Tombonuo
Added: 2009-07-29
%%
Type: language
Subtag: txb
Description: Tokharian B
Added: 2009-07-29
%%
Type: language
Subtag: txc
Description: Tsetsaut
Added: 2009-07-29
%%
Type: language
Subtag: txe
Description: Totoli
Added: 2009-07-29
%%
Type: language
Subtag: txg
Description: Tangut
Added: 2009-07-29
%%
Type: language
Subtag: txh
Description: Thracian
Added: 2009-07-29
%%
Type: language
Subtag: txi
Description: Ikpeng
Added: 2009-07-29
%%
Type: language
Subtag: txj
Description: Tarjumo
Added: 2015-02-12
%%
Type: language
Subtag: txm
Description: Tomini
Added: 2009-07-29
%%
Type: language
Subtag: txn
Description: West Tarangan
Added: 2009-07-29
%%
Type: language
Subtag: txo
Description: Toto
Added: 2009-07-29
%%
Type: language
Subtag: txq
Description: Tii
Added: 2009-07-29
%%
Type: language
Subtag: txr
Description: Tartessian
Added: 2009-07-29
%%
Type: language
Subtag: txs
Description: Tonsea
Added: 2009-07-29
%%
Type: language
Subtag: txt
Description: Citak
Added: 2009-07-29
%%
Type: language
Subtag: txu
Description: Kayapó
Added: 2009-07-29
%%
Type: language
Subtag: txx
Description: Tatana
Added: 2009-07-29
%%
Type: language
Subtag: txy
Description: Tanosy Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: tya
Description: Tauya
Added: 2009-07-29
%%
Type: language
Subtag: tye
Description: Kyanga
Added: 2009-07-29
%%
Type: language
Subtag: tyh
Description: O'du
Added: 2009-07-29
%%
Type: language
Subtag: tyi
Description: Teke-Tsaayi
Added: 2009-07-29
%%
Type: language
Subtag: tyj
Description: Tai Do
Description: Tai Yo
Added: 2009-07-29
%%
Type: language
Subtag: tyl
Description: Thu Lao
Added: 2009-07-29
%%
Type: language
Subtag: tyn
Description: Kombai
Added: 2009-07-29
%%
Type: language
Subtag: typ
Description: Thaypan
Added: 2009-07-29
%%
Type: language
Subtag: tyr
Description: Tai Daeng
Added: 2009-07-29
%%
Type: language
Subtag: tys
Description: Tày Sa Pa
Added: 2009-07-29
%%
Type: language
Subtag: tyt
Description: Tày Tac
Added: 2009-07-29
%%
Type: language
Subtag: tyu
Description: Kua
Added: 2009-07-29
%%
Type: language
Subtag: tyv
Description: Tuvinian
Added: 2005-10-16
%%
Type: language
Subtag: tyx
Description: Teke-Tyee
Added: 2009-07-29
%%
Type: language
Subtag: tyz
Description: Tày
Added: 2009-07-29
%%
Type: language
Subtag: tza
Description: Tanzanian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: tzh
Description: Tzeltal
Added: 2009-07-29
%%
Type: language
Subtag: tzj
Description: Tz'utujil
Added: 2009-07-29
%%
Type: language
Subtag: tzl
Description: Talossan
Added: 2013-09-10
%%
Type: language
Subtag: tzm
Description: Central Atlas Tamazight
Added: 2009-07-29
%%
Type: language
Subtag: tzn
Description: Tugun
Added: 2009-07-29
%%
Type: language
Subtag: tzo
Description: Tzotzil
Added: 2009-07-29
%%
Type: language
Subtag: tzx
Description: Tabriak
Added: 2009-07-29
%%
Type: language
Subtag: uam
Description: Uamué
Added: 2009-07-29
%%
Type: language
Subtag: uan
Description: Kuan
Added: 2009-07-29
%%
Type: language
Subtag: uar
Description: Tairuma
Added: 2009-07-29
%%
Type: language
Subtag: uba
Description: Ubang
Added: 2009-07-29
%%
Type: language
Subtag: ubi
Description: Ubi
Added: 2009-07-29
%%
Type: language
Subtag: ubl
Description: Buhi'non Bikol
Added: 2010-03-11
Macrolanguage: bik
%%
Type: language
Subtag: ubr
Description: Ubir
Added: 2009-07-29
%%
Type: language
Subtag: ubu
Description: Umbu-Ungu
Added: 2009-07-29
%%
Type: language
Subtag: uby
Description: Ubykh
Added: 2009-07-29
%%
Type: language
Subtag: uda
Description: Uda
Added: 2009-07-29
%%
Type: language
Subtag: ude
Description: Udihe
Added: 2009-07-29
%%
Type: language
Subtag: udg
Description: Muduga
Added: 2009-07-29
%%
Type: language
Subtag: udi
Description: Udi
Added: 2009-07-29
%%
Type: language
Subtag: udj
Description: Ujir
Added: 2009-07-29
%%
Type: language
Subtag: udl
Description: Wuzlam
Added: 2009-07-29
%%
Type: language
Subtag: udm
Description: Udmurt
Added: 2005-10-16
%%
Type: language
Subtag: udu
Description: Uduk
Added: 2009-07-29
%%
Type: language
Subtag: ues
Description: Kioko
Added: 2009-07-29
%%
Type: language
Subtag: ufi
Description: Ufim
Added: 2009-07-29
%%
Type: language
Subtag: uga
Description: Ugaritic
Added: 2005-10-16
%%
Type: language
Subtag: ugb
Description: Kuku-Ugbanh
Added: 2009-07-29
%%
Type: language
Subtag: uge
Description: Ughele
Added: 2009-07-29
%%
Type: language
Subtag: ugn
Description: Ugandan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: ugo
Description: Ugong
Added: 2009-07-29
%%
Type: language
Subtag: ugy
Description: Uruguayan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: uha
Description: Uhami
Added: 2009-07-29
%%
Type: language
Subtag: uhn
Description: Damal
Added: 2009-07-29
%%
Type: language
Subtag: uis
Description: Uisai
Added: 2009-07-29
%%
Type: language
Subtag: uiv
Description: Iyive
Added: 2009-07-29
%%
Type: language
Subtag: uji
Description: Tanjijili
Added: 2009-07-29
%%
Type: language
Subtag: uka
Description: Kaburi
Added: 2009-07-29
%%
Type: language
Subtag: ukg
Description: Ukuriguma
Added: 2009-07-29
%%
Type: language
Subtag: ukh
Description: Ukhwejo
Added: 2009-07-29
%%
Type: language
Subtag: ukk
Description: Muak Sa-aak
Added: 2017-02-23
%%
Type: language
Subtag: ukl
Description: Ukrainian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: ukp
Description: Ukpe-Bayobiri
Added: 2009-07-29
%%
Type: language
Subtag: ukq
Description: Ukwa
Added: 2009-07-29
%%
Type: language
Subtag: uks
Description: Urubú-Kaapor Sign Language
Description: Kaapor Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: uku
Description: Ukue
Added: 2009-07-29
%%
Type: language
Subtag: ukw
Description: Ukwuani-Aboh-Ndoni
Added: 2009-07-29
%%
Type: language
Subtag: uky
Description: Kuuk-Yak
Added: 2012-08-12
%%
Type: language
Subtag: ula
Description: Fungwa
Added: 2009-07-29
%%
Type: language
Subtag: ulb
Description: Ulukwumi
Added: 2009-07-29
%%
Type: language
Subtag: ulc
Description: Ulch
Added: 2009-07-29
%%
Type: language
Subtag: ule
Description: Lule
Added: 2013-09-10
%%
Type: language
Subtag: ulf
Description: Usku
Description: Afra
Added: 2009-07-29
%%
Type: language
Subtag: uli
Description: Ulithian
Added: 2009-07-29
%%
Type: language
Subtag: ulk
Description: Meriam Mir
Added: 2009-07-29
%%
Type: language
Subtag: ull
Description: Ullatan
Added: 2009-07-29
%%
Type: language
Subtag: ulm
Description: Ulumanda'
Added: 2009-07-29
%%
Type: language
Subtag: uln
Description: Unserdeutsch
Added: 2009-07-29
%%
Type: language
Subtag: ulu
Description: Uma' Lung
Added: 2009-07-29
%%
Type: language
Subtag: ulw
Description: Ulwa
Added: 2010-03-11
%%
Type: language
Subtag: uma
Description: Umatilla
Added: 2009-07-29
%%
Type: language
Subtag: umb
Description: Umbundu
Added: 2005-10-16
%%
Type: language
Subtag: umc
Description: Marrucinian
Added: 2009-07-29
%%
Type: language
Subtag: umd
Description: Umbindhamu
Added: 2009-07-29
%%
Type: language
Subtag: umg
Description: Morrobalama
Description: Umbuygamu
Added: 2009-07-29
%%
Type: language
Subtag: umi
Description: Ukit
Added: 2009-07-29
%%
Type: language
Subtag: umm
Description: Umon
Added: 2009-07-29
%%
Type: language
Subtag: umn
Description: Makyan Naga
Added: 2009-07-29
%%
Type: language
Subtag: umo
Description: Umotína
Added: 2009-07-29
%%
Type: language
Subtag: ump
Description: Umpila
Added: 2009-07-29
%%
Type: language
Subtag: umr
Description: Umbugarla
Added: 2009-07-29
%%
Type: language
Subtag: ums
Description: Pendau
Added: 2009-07-29
%%
Type: language
Subtag: umu
Description: Munsee
Added: 2009-07-29
Macrolanguage: del
%%
Type: language
Subtag: una
Description: North Watut
Added: 2009-07-29
%%
Type: language
Subtag: und
Description: Undetermined
Added: 2005-10-16
Scope: special
%%
Type: language
Subtag: une
Description: Uneme
Added: 2009-07-29
%%
Type: language
Subtag: ung
Description: Ngarinyin
Added: 2009-07-29
%%
Type: language
Subtag: unk
Description: Enawené-Nawé
Added: 2009-07-29
%%
Type: language
Subtag: unm
Description: Unami
Added: 2009-07-29
Macrolanguage: del
%%
Type: language
Subtag: unn
Description: Kurnai
Added: 2013-09-10
%%
Type: language
Subtag: unp
Description: Worora
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see wro, xgu
%%
Type: language
Subtag: unr
Description: Mundari
Added: 2009-07-29
%%
Type: language
Subtag: unu
Description: Unubahe
Added: 2013-09-10
%%
Type: language
Subtag: unx
Description: Munda
Added: 2009-07-29
%%
Type: language
Subtag: unz
Description: Unde Kaili
Added: 2009-07-29
%%
Type: language
Subtag: uok
Description: Uokha
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: ema
%%
Type: language
Subtag: upi
Description: Umeda
Added: 2009-07-29
%%
Type: language
Subtag: upv
Description: Uripiv-Wala-Rano-Atchin
Added: 2009-07-29
%%
Type: language
Subtag: ura
Description: Urarina
Added: 2009-07-29
%%
Type: language
Subtag: urb
Description: Urubú-Kaapor
Description: Kaapor
Added: 2009-07-29
%%
Type: language
Subtag: urc
Description: Urningangg
Added: 2009-07-29
%%
Type: language
Subtag: ure
Description: Uru
Added: 2009-07-29
%%
Type: language
Subtag: urf
Description: Uradhi
Added: 2009-07-29
%%
Type: language
Subtag: urg
Description: Urigina
Added: 2009-07-29
%%
Type: language
Subtag: urh
Description: Urhobo
Added: 2009-07-29
%%
Type: language
Subtag: uri
Description: Urim
Added: 2009-07-29
%%
Type: language
Subtag: urj
Description: Uralic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: urk
Description: Urak Lawoi'
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: url
Description: Urali
Added: 2009-07-29
%%
Type: language
Subtag: urm
Description: Urapmin
Added: 2009-07-29
%%
Type: language
Subtag: urn
Description: Uruangnirin
Added: 2009-07-29
%%
Type: language
Subtag: uro
Description: Ura (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: urp
Description: Uru-Pa-In
Added: 2009-07-29
%%
Type: language
Subtag: urr
Description: Lehalurup
Description: Löyöp
Added: 2009-07-29
%%
Type: language
Subtag: urt
Description: Urat
Added: 2009-07-29
%%
Type: language
Subtag: uru
Description: Urumi
Added: 2009-07-29
%%
Type: language
Subtag: urv
Description: Uruava
Added: 2009-07-29
%%
Type: language
Subtag: urw
Description: Sop
Added: 2009-07-29
%%
Type: language
Subtag: urx
Description: Urimo
Added: 2009-07-29
%%
Type: language
Subtag: ury
Description: Orya
Added: 2009-07-29
%%
Type: language
Subtag: urz
Description: Uru-Eu-Wau-Wau
Added: 2009-07-29
%%
Type: language
Subtag: usa
Description: Usarufa
Added: 2009-07-29
%%
Type: language
Subtag: ush
Description: Ushojo
Added: 2009-07-29
%%
Type: language
Subtag: usi
Description: Usui
Added: 2009-07-29
%%
Type: language
Subtag: usk
Description: Usaghade
Added: 2009-07-29
%%
Type: language
Subtag: usp
Description: Uspanteco
Added: 2009-07-29
%%
Type: language
Subtag: uss
Description: us-Saare
Added: 2019-04-16
%%
Type: language
Subtag: usu
Description: Uya
Added: 2009-07-29
%%
Type: language
Subtag: uta
Description: Otank
Added: 2009-07-29
%%
Type: language
Subtag: ute
Description: Ute-Southern Paiute
Added: 2009-07-29
%%
Type: language
Subtag: uth
Description: ut-Hun
Added: 2019-04-16
%%
Type: language
Subtag: utp
Description: Amba (Solomon Islands)
Added: 2009-07-29
%%
Type: language
Subtag: utr
Description: Etulo
Added: 2009-07-29
%%
Type: language
Subtag: utu
Description: Utu
Added: 2009-07-29
%%
Type: language
Subtag: uum
Description: Urum
Added: 2009-07-29
%%
Type: language
Subtag: uun
Description: Kulon-Pazeh
Added: 2009-07-29
%%
Type: language
Subtag: uur
Description: Ura (Vanuatu)
Added: 2009-07-29
%%
Type: language
Subtag: uuu
Description: U
Added: 2009-07-29
%%
Type: language
Subtag: uve
Description: West Uvean
Description: Fagauvea
Added: 2009-07-29
%%
Type: language
Subtag: uvh
Description: Uri
Added: 2009-07-29
%%
Type: language
Subtag: uvl
Description: Lote
Added: 2009-07-29
%%
Type: language
Subtag: uwa
Description: Kuku-Uwanh
Added: 2009-07-29
%%
Type: language
Subtag: uya
Description: Doko-Uyanga
Added: 2009-07-29
%%
Type: language
Subtag: uzn
Description: Northern Uzbek
Added: 2009-07-29
Macrolanguage: uz
%%
Type: language
Subtag: uzs
Description: Southern Uzbek
Added: 2009-07-29
Macrolanguage: uz
%%
Type: language
Subtag: vaa
Description: Vaagri Booli
Added: 2009-07-29
%%
Type: language
Subtag: vae
Description: Vale
Added: 2009-07-29
%%
Type: language
Subtag: vaf
Description: Vafsi
Added: 2009-07-29
%%
Type: language
Subtag: vag
Description: Vagla
Added: 2009-07-29
%%
Type: language
Subtag: vah
Description: Varhadi-Nagpuri
Added: 2009-07-29
%%
Type: language
Subtag: vai
Description: Vai
Added: 2005-10-16
%%
Type: language
Subtag: vaj
Description: Sekele
Description: Northwestern ǃKung
Description: Vasekele
Added: 2009-07-29
%%
Type: language
Subtag: val
Description: Vehes
Added: 2009-07-29
%%
Type: language
Subtag: vam
Description: Vanimo
Added: 2009-07-29
%%
Type: language
Subtag: van
Description: Valman
Added: 2009-07-29
%%
Type: language
Subtag: vao
Description: Vao
Added: 2009-07-29
%%
Type: language
Subtag: vap
Description: Vaiphei
Added: 2009-07-29
%%
Type: language
Subtag: var
Description: Huarijio
Added: 2009-07-29
%%
Type: language
Subtag: vas
Description: Vasavi
Added: 2009-07-29
%%
Type: language
Subtag: vau
Description: Vanuma
Added: 2009-07-29
%%
Type: language
Subtag: vav
Description: Varli
Added: 2009-07-29
%%
Type: language
Subtag: vay
Description: Wayu
Added: 2009-07-29
%%
Type: language
Subtag: vbb
Description: Southeast Babar
Added: 2009-07-29
%%
Type: language
Subtag: vbk
Description: Southwestern Bontok
Added: 2010-03-11
Macrolanguage: bnc
%%
Type: language
Subtag: vec
Description: Venetian
Added: 2009-07-29
%%
Type: language
Subtag: ved
Description: Veddah
Added: 2009-07-29
%%
Type: language
Subtag: vel
Description: Veluws
Added: 2009-07-29
%%
Type: language
Subtag: vem
Description: Vemgo-Mabas
Added: 2009-07-29
%%
Type: language
Subtag: veo
Description: Ventureño
Added: 2009-07-29
%%
Type: language
Subtag: vep
Description: Veps
Added: 2009-07-29
%%
Type: language
Subtag: ver
Description: Mom Jango
Added: 2009-07-29
%%
Type: language
Subtag: vgr
Description: Vaghri
Added: 2009-07-29
%%
Type: language
Subtag: vgt
Description: Vlaamse Gebarentaal
Description: Flemish Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: vic
Description: Virgin Islands Creole English
Added: 2009-07-29
%%
Type: language
Subtag: vid
Description: Vidunda
Added: 2009-07-29
%%
Type: language
Subtag: vif
Description: Vili
Added: 2009-07-29
%%
Type: language
Subtag: vig
Description: Viemo
Added: 2009-07-29
%%
Type: language
Subtag: vil
Description: Vilela
Added: 2009-07-29
%%
Type: language
Subtag: vin
Description: Vinza
Added: 2009-07-29
%%
Type: language
Subtag: vis
Description: Vishavan
Added: 2009-07-29
%%
Type: language
Subtag: vit
Description: Viti
Added: 2009-07-29
%%
Type: language
Subtag: viv
Description: Iduna
Added: 2009-07-29
%%
Type: language
Subtag: vka
Description: Kariyarra
Added: 2009-07-29
%%
Type: language
Subtag: vki
Description: Ija-Zuba
Added: 2009-07-29
%%
Type: language
Subtag: vkj
Description: Kujarge
Added: 2009-07-29
%%
Type: language
Subtag: vkk
Description: Kaur
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: vkl
Description: Kulisusu
Added: 2009-07-29
%%
Type: language
Subtag: vkm
Description: Kamakan
Added: 2009-07-29
%%
Type: language
Subtag: vko
Description: Kodeoha
Added: 2009-07-29
%%
Type: language
Subtag: vkp
Description: Korlai Creole Portuguese
Added: 2009-07-29
%%
Type: language
Subtag: vkt
Description: Tenggarong Kutai Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: vku
Description: Kurrama
Added: 2009-07-29
%%
Type: language
Subtag: vlp
Description: Valpei
Added: 2009-07-29
%%
Type: language
Subtag: vls
Description: Vlaams
Added: 2009-07-29
%%
Type: language
Subtag: vma
Description: Martuyhunira
Added: 2009-07-29
%%
Type: language
Subtag: vmb
Description: Barbaram
Added: 2009-07-29
%%
Type: language
Subtag: vmc
Description: Juxtlahuaca Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: vmd
Description: Mudu Koraga
Added: 2009-07-29
%%
Type: language
Subtag: vme
Description: East Masela
Added: 2009-07-29
%%
Type: language
Subtag: vmf
Description: Mainfränkisch
Added: 2009-07-29
%%
Type: language
Subtag: vmg
Description: Lungalunga
Added: 2009-07-29
Comments: see also bxf
%%
Type: language
Subtag: vmh
Description: Maraghei
Added: 2009-07-29
%%
Type: language
Subtag: vmi
Description: Miwa
Added: 2009-07-29
%%
Type: language
Subtag: vmj
Description: Ixtayutla Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: vmk
Description: Makhuwa-Shirima
Added: 2009-07-29
%%
Type: language
Subtag: vml
Description: Malgana
Added: 2009-07-29
%%
Type: language
Subtag: vmm
Description: Mitlatongo Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: vmp
Description: Soyaltepec Mazatec
Added: 2009-07-29
%%
Type: language
Subtag: vmq
Description: Soyaltepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: vmr
Description: Marenje
Added: 2009-07-29
%%
Type: language
Subtag: vms
Description: Moksela
Added: 2009-07-29
%%
Type: language
Subtag: vmu
Description: Muluridyi
Added: 2009-07-29
%%
Type: language
Subtag: vmv
Description: Valley Maidu
Added: 2009-07-29
%%
Type: language
Subtag: vmw
Description: Makhuwa
Added: 2009-07-29
%%
Type: language
Subtag: vmx
Description: Tamazola Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: vmy
Description: Ayautla Mazatec
Added: 2009-07-29
%%
Type: language
Subtag: vmz
Description: Mazatlán Mazatec
Added: 2009-07-29
%%
Type: language
Subtag: vnk
Description: Vano
Description: Lovono
Added: 2009-07-29
%%
Type: language
Subtag: vnm
Description: Vinmavis
Description: Neve'ei
Added: 2009-07-29
%%
Type: language
Subtag: vnp
Description: Vunapu
Added: 2009-07-29
%%
Type: language
Subtag: vor
Description: Voro
Added: 2009-07-29
%%
Type: language
Subtag: vot
Description: Votic
Added: 2005-10-16
%%
Type: language
Subtag: vra
Description: Vera'a
Added: 2009-07-29
%%
Type: language
Subtag: vro
Description: Võro
Added: 2009-07-29
Macrolanguage: et
%%
Type: language
Subtag: vrs
Description: Varisi
Added: 2009-07-29
%%
Type: language
Subtag: vrt
Description: Burmbar
Description: Banam Bay
Added: 2009-07-29
%%
Type: language
Subtag: vsi
Description: Moldova Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: vsl
Description: Venezuelan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: vsv
Description: Valencian Sign Language
Description: Llengua de signes valenciana
Added: 2009-07-29
%%
Type: language
Subtag: vto
Description: Vitou
Added: 2009-07-29
%%
Type: language
Subtag: vum
Description: Vumbu
Added: 2009-07-29
%%
Type: language
Subtag: vun
Description: Vunjo
Added: 2009-07-29
%%
Type: language
Subtag: vut
Description: Vute
Added: 2009-07-29
%%
Type: language
Subtag: vwa
Description: Awa (China)
Added: 2009-07-29
%%
Type: language
Subtag: waa
Description: Walla Walla
Added: 2009-07-29
%%
Type: language
Subtag: wab
Description: Wab
Added: 2009-07-29
%%
Type: language
Subtag: wac
Description: Wasco-Wishram
Added: 2009-07-29
%%
Type: language
Subtag: wad
Description: Wandamen
Added: 2009-07-29
%%
Type: language
Subtag: wae
Description: Walser
Added: 2009-07-29
%%
Type: language
Subtag: waf
Description: Wakoná
Added: 2009-07-29
%%
Type: language
Subtag: wag
Description: Wa'ema
Added: 2009-07-29
%%
Type: language
Subtag: wah
Description: Watubela
Added: 2009-07-29
%%
Type: language
Subtag: wai
Description: Wares
Added: 2009-07-29
%%
Type: language
Subtag: waj
Description: Waffa
Added: 2009-07-29
%%
Type: language
Subtag: wak
Description: Wakashan languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: wal
Description: Wolaytta
Description: Wolaitta
Added: 2005-10-16
%%
Type: language
Subtag: wam
Description: Wampanoag
Added: 2009-07-29
%%
Type: language
Subtag: wan
Description: Wan
Added: 2009-07-29
%%
Type: language
Subtag: wao
Description: Wappo
Added: 2009-07-29
%%
Type: language
Subtag: wap
Description: Wapishana
Added: 2009-07-29
%%
Type: language
Subtag: waq
Description: Wagiman
Added: 2009-07-29
%%
Type: language
Subtag: war
Description: Waray (Philippines)
Added: 2005-10-16
%%
Type: language
Subtag: was
Description: Washo
Added: 2005-10-16
%%
Type: language
Subtag: wat
Description: Kaninuwa
Added: 2009-07-29
%%
Type: language
Subtag: wau
Description: Waurá
Added: 2009-07-29
%%
Type: language
Subtag: wav
Description: Waka
Added: 2009-07-29
%%
Type: language
Subtag: waw
Description: Waiwai
Added: 2009-07-29
%%
Type: language
Subtag: wax
Description: Watam
Description: Marangis
Added: 2009-07-29
%%
Type: language
Subtag: way
Description: Wayana
Added: 2009-07-29
%%
Type: language
Subtag: waz
Description: Wampur
Added: 2009-07-29
%%
Type: language
Subtag: wba
Description: Warao
Added: 2009-07-29
%%
Type: language
Subtag: wbb
Description: Wabo
Added: 2009-07-29
%%
Type: language
Subtag: wbe
Description: Waritai
Added: 2009-07-29
%%
Type: language
Subtag: wbf
Description: Wara
Added: 2009-07-29
Comments: see also pnl
%%
Type: language
Subtag: wbh
Description: Wanda
Added: 2009-07-29
%%
Type: language
Subtag: wbi
Description: Vwanji
Added: 2009-07-29
%%
Type: language
Subtag: wbj
Description: Alagwa
Added: 2009-07-29
%%
Type: language
Subtag: wbk
Description: Waigali
Added: 2009-07-29
%%
Type: language
Subtag: wbl
Description: Wakhi
Added: 2009-07-29
%%
Type: language
Subtag: wbm
Description: Wa
Added: 2009-07-29
%%
Type: language
Subtag: wbp
Description: Warlpiri
Added: 2009-07-29
%%
Type: language
Subtag: wbq
Description: Waddar
Added: 2009-07-29
%%
Type: language
Subtag: wbr
Description: Wagdi
Added: 2009-07-29
Macrolanguage: raj
%%
Type: language
Subtag: wbs
Description: West Bengal Sign Language
Added: 2017-02-23
%%
Type: language
Subtag: wbt
Description: Warnman
Added: 2009-07-29
%%
Type: language
Subtag: wbv
Description: Wajarri
Added: 2009-07-29
%%
Type: language
Subtag: wbw
Description: Woi
Added: 2009-07-29
%%
Type: language
Subtag: wca
Description: Yanomámi
Added: 2009-07-29
%%
Type: language
Subtag: wci
Description: Waci Gbe
Added: 2009-07-29
%%
Type: language
Subtag: wdd
Description: Wandji
Added: 2009-07-29
%%
Type: language
Subtag: wdg
Description: Wadaginam
Added: 2009-07-29
%%
Type: language
Subtag: wdj
Description: Wadjiginy
Added: 2009-07-29
%%
Type: language
Subtag: wdk
Description: Wadikali
Added: 2013-09-10
%%
Type: language
Subtag: wdu
Description: Wadjigu
Added: 2009-07-29
%%
Type: language
Subtag: wdy
Description: Wadjabangayi
Added: 2013-09-10
%%
Type: language
Subtag: wea
Description: Wewaw
Added: 2009-07-29
%%
Type: language
Subtag: wec
Description: Wè Western
Added: 2009-07-29
%%
Type: language
Subtag: wed
Description: Wedau
Added: 2009-07-29
%%
Type: language
Subtag: weg
Description: Wergaia
Added: 2013-09-10
%%
Type: language
Subtag: weh
Description: Weh
Added: 2009-07-29
%%
Type: language
Subtag: wei
Description: Kiunum
Added: 2009-07-29
%%
Type: language
Subtag: wem
Description: Weme Gbe
Added: 2009-07-29
%%
Type: language
Subtag: wen
Description: Sorbian languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: weo
Description: Wemale
Added: 2009-07-29
%%
Type: language
Subtag: wep
Description: Westphalien
Added: 2009-07-29
%%
Type: language
Subtag: wer
Description: Weri
Added: 2009-07-29
%%
Type: language
Subtag: wes
Description: Cameroon Pidgin
Added: 2009-07-29
%%
Type: language
Subtag: wet
Description: Perai
Added: 2009-07-29
%%
Type: language
Subtag: weu
Description: Rawngtu Chin
Added: 2009-07-29
%%
Type: language
Subtag: wew
Description: Wejewa
Added: 2009-07-29
%%
Type: language
Subtag: wfg
Description: Yafi
Description: Zorop
Added: 2009-07-29
%%
Type: language
Subtag: wga
Description: Wagaya
Added: 2009-07-29
%%
Type: language
Subtag: wgb
Description: Wagawaga
Added: 2010-03-11
%%
Type: language
Subtag: wgg
Description: Wangkangurru
Description: Wangganguru
Added: 2009-07-29
%%
Type: language
Subtag: wgi
Description: Wahgi
Added: 2009-07-29
%%
Type: language
Subtag: wgo
Description: Waigeo
Added: 2009-07-29
%%
Type: language
Subtag: wgu
Description: Wirangu
Added: 2012-08-12
%%
Type: language
Subtag: wgw
Description: Wagawaga
Added: 2009-07-29
Deprecated: 2010-03-11
Comments: see wgb, ylb
%%
Type: language
Subtag: wgy
Description: Warrgamay
Added: 2009-07-29
%%
Type: language
Subtag: wha
Description: Sou Upaa
Description: Manusela
Added: 2009-07-29
%%
Type: language
Subtag: whg
Description: North Wahgi
Added: 2009-07-29
%%
Type: language
Subtag: whk
Description: Wahau Kenyah
Added: 2009-07-29
%%
Type: language
Subtag: whu
Description: Wahau Kayan
Added: 2009-07-29
%%
Type: language
Subtag: wib
Description: Southern Toussian
Added: 2009-07-29
%%
Type: language
Subtag: wic
Description: Wichita
Added: 2009-07-29
%%
Type: language
Subtag: wie
Description: Wik-Epa
Added: 2009-07-29
%%
Type: language
Subtag: wif
Description: Wik-Keyangan
Added: 2009-07-29
%%
Type: language
Subtag: wig
Description: Wik Ngathan
Added: 2009-07-29
%%
Type: language
Subtag: wih
Description: Wik-Me'anha
Added: 2009-07-29
%%
Type: language
Subtag: wii
Description: Minidien
Added: 2009-07-29
%%
Type: language
Subtag: wij
Description: Wik-Iiyanh
Added: 2009-07-29
%%
Type: language
Subtag: wik
Description: Wikalkan
Added: 2009-07-29
%%
Type: language
Subtag: wil
Description: Wilawila
Added: 2009-07-29
%%
Type: language
Subtag: wim
Description: Wik-Mungkan
Added: 2009-07-29
%%
Type: language
Subtag: win
Description: Ho-Chunk
Added: 2009-07-29
%%
Type: language
Subtag: wir
Description: Wiraféd
Added: 2009-07-29
%%
Type: language
Subtag: wit
Description: Wintu
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see nol, pwi, wnw
%%
Type: language
Subtag: wiu
Description: Wiru
Added: 2009-07-29
%%
Type: language
Subtag: wiv
Description: Vitu
Added: 2009-07-29
%%
Type: language
Subtag: wiw
Description: Wirangu
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see nwo, wgu
%%
Type: language
Subtag: wiy
Description: Wiyot
Added: 2009-07-29
%%
Type: language
Subtag: wja
Description: Waja
Added: 2009-07-29
%%
Type: language
Subtag: wji
Description: Warji
Added: 2009-07-29
%%
Type: language
Subtag: wka
Description: Kw'adza
Added: 2009-07-29
%%
Type: language
Subtag: wkb
Description: Kumbaran
Added: 2009-07-29
%%
Type: language
Subtag: wkd
Description: Wakde
Description: Mo
Added: 2009-07-29
%%
Type: language
Subtag: wkl
Description: Kalanadi
Added: 2009-07-29
%%
Type: language
Subtag: wkr
Description: Keerray-Woorroong
Added: 2019-04-16
%%
Type: language
Subtag: wku
Description: Kunduvadi
Added: 2009-07-29
%%
Type: language
Subtag: wkw
Description: Wakawaka
Added: 2009-07-29
%%
Type: language
Subtag: wky
Description: Wangkayutyuru
Added: 2013-09-10
%%
Type: language
Subtag: wla
Description: Walio
Added: 2009-07-29
%%
Type: language
Subtag: wlc
Description: Mwali Comorian
Added: 2009-07-29
%%
Type: language
Subtag: wle
Description: Wolane
Added: 2009-07-29
%%
Type: language
Subtag: wlg
Description: Kunbarlang
Added: 2009-07-29
%%
Type: language
Subtag: wli
Description: Waioli
Added: 2009-07-29
%%
Type: language
Subtag: wlk
Description: Wailaki
Added: 2009-07-29
%%
Type: language
Subtag: wll
Description: Wali (Sudan)
Added: 2009-07-29
%%
Type: language
Subtag: wlm
Description: Middle Welsh
Added: 2009-07-29
%%
Type: language
Subtag: wlo
Description: Wolio
Added: 2009-07-29
%%
Type: language
Subtag: wlr
Description: Wailapa
Added: 2009-07-29
%%
Type: language
Subtag: wls
Description: Wallisian
Added: 2009-07-29
%%
Type: language
Subtag: wlu
Description: Wuliwuli
Added: 2009-07-29
%%
Type: language
Subtag: wlv
Description: Wichí Lhamtés Vejoz
Added: 2009-07-29
%%
Type: language
Subtag: wlw
Description: Walak
Added: 2009-07-29
%%
Type: language
Subtag: wlx
Description: Wali (Ghana)
Added: 2009-07-29
%%
Type: language
Subtag: wly
Description: Waling
Added: 2009-07-29
%%
Type: language
Subtag: wma
Description: Mawa (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: wmb
Description: Wambaya
Added: 2009-07-29
%%
Type: language
Subtag: wmc
Description: Wamas
Added: 2009-07-29
%%
Type: language
Subtag: wmd
Description: Mamaindé
Added: 2009-07-29
%%
Type: language
Subtag: wme
Description: Wambule
Added: 2009-07-29
%%
Type: language
Subtag: wmh
Description: Waima'a
Added: 2009-07-29
%%
Type: language
Subtag: wmi
Description: Wamin
Added: 2009-07-29
%%
Type: language
Subtag: wmm
Description: Maiwa (Indonesia)
Added: 2009-07-29
%%
Type: language
Subtag: wmn
Description: Waamwang
Added: 2009-07-29
%%
Type: language
Subtag: wmo
Description: Wom (Papua New Guinea)
Added: 2009-07-29
%%
Type: language
Subtag: wms
Description: Wambon
Added: 2009-07-29
%%
Type: language
Subtag: wmt
Description: Walmajarri
Added: 2009-07-29
%%
Type: language
Subtag: wmw
Description: Mwani
Added: 2009-07-29
%%
Type: language
Subtag: wmx
Description: Womo
Added: 2009-07-29
%%
Type: language
Subtag: wnb
Description: Wanambre
Added: 2009-07-29
%%
Type: language
Subtag: wnc
Description: Wantoat
Added: 2009-07-29
%%
Type: language
Subtag: wnd
Description: Wandarang
Added: 2009-07-29
%%
Type: language
Subtag: wne
Description: Waneci
Added: 2009-07-29
%%
Type: language
Subtag: wng
Description: Wanggom
Added: 2009-07-29
%%
Type: language
Subtag: wni
Description: Ndzwani Comorian
Added: 2009-07-29
%%
Type: language
Subtag: wnk
Description: Wanukaka
Added: 2009-07-29
%%
Type: language
Subtag: wnm
Description: Wanggamala
Added: 2009-07-29
%%
Type: language
Subtag: wnn
Description: Wunumara
Added: 2013-09-10
%%
Type: language
Subtag: wno
Description: Wano
Added: 2009-07-29
%%
Type: language
Subtag: wnp
Description: Wanap
Added: 2009-07-29
%%
Type: language
Subtag: wnu
Description: Usan
Added: 2009-07-29
%%
Type: language
Subtag: wnw
Description: Wintu
Added: 2013-09-10
%%
Type: language
Subtag: wny
Description: Wanyi
Description: Waanyi
Added: 2012-08-12
%%
Type: language
Subtag: woa
Description: Kuwema
Description: Tyaraity
Added: 2009-07-29
%%
Type: language
Subtag: wob
Description: Wè Northern
Added: 2009-07-29
%%
Type: language
Subtag: woc
Description: Wogeo
Added: 2009-07-29
%%
Type: language
Subtag: wod
Description: Wolani
Added: 2009-07-29
%%
Type: language
Subtag: woe
Description: Woleaian
Added: 2009-07-29
%%
Type: language
Subtag: wof
Description: Gambian Wolof
Added: 2009-07-29
%%
Type: language
Subtag: wog
Description: Wogamusin
Added: 2009-07-29
%%
Type: language
Subtag: woi
Description: Kamang
Added: 2009-07-29
%%
Type: language
Subtag: wok
Description: Longto
Added: 2009-07-29
%%
Type: language
Subtag: wom
Description: Wom (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: won
Description: Wongo
Added: 2009-07-29
%%
Type: language
Subtag: woo
Description: Manombai
Added: 2009-07-29
%%
Type: language
Subtag: wor
Description: Woria
Added: 2009-07-29
%%
Type: language
Subtag: wos
Description: Hanga Hundi
Added: 2009-07-29
%%
Type: language
Subtag: wow
Description: Wawonii
Added: 2009-07-29
%%
Type: language
Subtag: woy
Description: Weyto
Added: 2009-07-29
%%
Type: language
Subtag: wpc
Description: Maco
Added: 2009-07-29
%%
Type: language
Subtag: wra
Description: Warapu
Added: 2009-07-29
%%
Type: language
Subtag: wrb
Description: Waluwarra
Description: Warluwara
Added: 2009-07-29
%%
Type: language
Subtag: wrd
Description: Warduji
Added: 2009-07-29
%%
Type: language
Subtag: wrg
Description: Warungu
Description: Gudjal
Added: 2009-07-29
%%
Type: language
Subtag: wrh
Description: Wiradjuri
Added: 2009-07-29
%%
Type: language
Subtag: wri
Description: Wariyangga
Added: 2009-07-29
%%
Type: language
Subtag: wrk
Description: Garrwa
Added: 2012-08-12
%%
Type: language
Subtag: wrl
Description: Warlmanpa
Added: 2009-07-29
%%
Type: language
Subtag: wrm
Description: Warumungu
Added: 2009-07-29
%%
Type: language
Subtag: wrn
Description: Warnang
Added: 2009-07-29
%%
Type: language
Subtag: wro
Description: Worrorra
Added: 2012-08-12
%%
Type: language
Subtag: wrp
Description: Waropen
Added: 2009-07-29
%%
Type: language
Subtag: wrr
Description: Wardaman
Added: 2009-07-29
%%
Type: language
Subtag: wrs
Description: Waris
Added: 2009-07-29
%%
Type: language
Subtag: wru
Description: Waru
Added: 2009-07-29
%%
Type: language
Subtag: wrv
Description: Waruna
Added: 2009-07-29
%%
Type: language
Subtag: wrw
Description: Gugu Warra
Added: 2009-07-29
%%
Type: language
Subtag: wrx
Description: Wae Rana
Added: 2009-07-29
%%
Type: language
Subtag: wry
Description: Merwari
Added: 2009-07-29
Macrolanguage: mwr
%%
Type: language
Subtag: wrz
Description: Waray (Australia)
Added: 2009-07-29
%%
Type: language
Subtag: wsa
Description: Warembori
Added: 2009-07-29
%%
Type: language
Subtag: wsg
Description: Adilabad Gondi
Added: 2016-05-30
Macrolanguage: gon
%%
Type: language
Subtag: wsi
Description: Wusi
Added: 2009-07-29
%%
Type: language
Subtag: wsk
Description: Waskia
Added: 2009-07-29
%%
Type: language
Subtag: wsr
Description: Owenia
Added: 2009-07-29
%%
Type: language
Subtag: wss
Description: Wasa
Added: 2009-07-29
%%
Type: language
Subtag: wsu
Description: Wasu
Added: 2009-07-29
%%
Type: language
Subtag: wsv
Description: Wotapuri-Katarqalai
Added: 2009-07-29
%%
Type: language
Subtag: wtf
Description: Watiwa
Added: 2009-07-29
%%
Type: language
Subtag: wth
Description: Wathawurrung
Added: 2013-09-10
%%
Type: language
Subtag: wti
Description: Berta
Added: 2009-07-29
%%
Type: language
Subtag: wtk
Description: Watakataui
Added: 2009-07-29
%%
Type: language
Subtag: wtm
Description: Mewati
Added: 2009-07-29
%%
Type: language
Subtag: wtw
Description: Wotu
Added: 2009-07-29
%%
Type: language
Subtag: wua
Description: Wikngenchera
Added: 2009-07-29
%%
Type: language
Subtag: wub
Description: Wunambal
Added: 2009-07-29
%%
Type: language
Subtag: wud
Description: Wudu
Added: 2009-07-29
%%
Type: language
Subtag: wuh
Description: Wutunhua
Added: 2009-07-29
%%
Type: language
Subtag: wul
Description: Silimo
Added: 2009-07-29
%%
Type: language
Subtag: wum
Description: Wumbvu
Added: 2009-07-29
%%
Type: language
Subtag: wun
Description: Bungu
Added: 2009-07-29
%%
Type: language
Subtag: wur
Description: Wurrugu
Added: 2009-07-29
%%
Type: language
Subtag: wut
Description: Wutung
Added: 2009-07-29
%%
Type: language
Subtag: wuu
Description: Wu Chinese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: wuv
Description: Wuvulu-Aua
Added: 2009-07-29
%%
Type: language
Subtag: wux
Description: Wulna
Added: 2009-07-29
%%
Type: language
Subtag: wuy
Description: Wauyai
Added: 2009-07-29
%%
Type: language
Subtag: wwa
Description: Waama
Added: 2009-07-29
%%
Type: language
Subtag: wwb
Description: Wakabunga
Added: 2012-08-12
%%
Type: language
Subtag: wwo
Description: Wetamut
Description: Dorig
Added: 2009-07-29
%%
Type: language
Subtag: wwr
Description: Warrwa
Added: 2009-07-29
%%
Type: language
Subtag: www
Description: Wawa
Added: 2009-07-29
%%
Type: language
Subtag: wxa
Description: Waxianghua
Added: 2009-07-29
%%
Type: language
Subtag: wxw
Description: Wardandi
Added: 2013-09-10
%%
Type: language
Subtag: wya
Description: Wyandot
Added: 2009-07-29
%%
Type: language
Subtag: wyb
Description: Wangaaybuwan-Ngiyambaa
Added: 2009-07-29
%%
Type: language
Subtag: wyi
Description: Woiwurrung
Added: 2013-09-10
%%
Type: language
Subtag: wym
Description: Wymysorys
Added: 2009-07-29
%%
Type: language
Subtag: wyr
Description: Wayoró
Added: 2009-07-29
%%
Type: language
Subtag: wyy
Description: Western Fijian
Added: 2009-07-29
%%
Type: language
Subtag: xaa
Description: Andalusian Arabic
Added: 2009-07-29
%%
Type: language
Subtag: xab
Description: Sambe
Added: 2009-07-29
%%
Type: language
Subtag: xac
Description: Kachari
Added: 2009-07-29
%%
Type: language
Subtag: xad
Description: Adai
Added: 2009-07-29
%%
Type: language
Subtag: xae
Description: Aequian
Added: 2009-07-29
%%
Type: language
Subtag: xag
Description: Aghwan
Added: 2009-07-29
%%
Type: language
Subtag: xai
Description: Kaimbé
Added: 2009-07-29
%%
Type: language
Subtag: xaj
Description: Ararandewára
Added: 2014-02-28
%%
Type: language
Subtag: xak
Description: Máku
Added: 2016-05-30
%%
Type: language
Subtag: xal
Description: Kalmyk
Description: Oirat
Added: 2005-10-16
%%
Type: language
Subtag: xam
Description: ǀXam
Added: 2009-07-29
%%
Type: language
Subtag: xan
Description: Xamtanga
Added: 2009-07-29
%%
Type: language
Subtag: xao
Description: Khao
Added: 2009-07-29
%%
Type: language
Subtag: xap
Description: Apalachee
Added: 2009-07-29
%%
Type: language
Subtag: xaq
Description: Aquitanian
Added: 2009-07-29
%%
Type: language
Subtag: xar
Description: Karami
Added: 2009-07-29
%%
Type: language
Subtag: xas
Description: Kamas
Added: 2009-07-29
%%
Type: language
Subtag: xat
Description: Katawixi
Added: 2009-07-29
%%
Type: language
Subtag: xau
Description: Kauwera
Added: 2009-07-29
%%
Type: language
Subtag: xav
Description: Xavánte
Added: 2009-07-29
%%
Type: language
Subtag: xaw
Description: Kawaiisu
Added: 2009-07-29
%%
Type: language
Subtag: xay
Description: Kayan Mahakam
Added: 2009-07-29
%%
Type: language
Subtag: xba
Description: Kamba (Brazil)
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: cax
%%
Type: language
Subtag: xbb
Description: Lower Burdekin
Added: 2010-03-11
%%
Type: language
Subtag: xbc
Description: Bactrian
Added: 2009-07-29
%%
Type: language
Subtag: xbd
Description: Bindal
Added: 2013-09-10
%%
Type: language
Subtag: xbe
Description: Bigambal
Added: 2013-09-10
%%
Type: language
Subtag: xbg
Description: Bunganditj
Added: 2013-09-10
%%
Type: language
Subtag: xbi
Description: Kombio
Added: 2009-07-29
%%
Type: language
Subtag: xbj
Description: Birrpayi
Added: 2013-09-10
%%
Type: language
Subtag: xbm
Description: Middle Breton
Added: 2009-07-29
%%
Type: language
Subtag: xbn
Description: Kenaboi
Added: 2010-03-11
%%
Type: language
Subtag: xbo
Description: Bolgarian
Added: 2009-07-29
%%
Type: language
Subtag: xbp
Description: Bibbulman
Added: 2013-09-10
%%
Type: language
Subtag: xbr
Description: Kambera
Added: 2009-07-29
%%
Type: language
Subtag: xbw
Description: Kambiwá
Added: 2009-07-29
%%
Type: language
Subtag: xbx
Description: Kabixí
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: xby
Description: Batjala
Description: Batyala
Added: 2013-09-10
%%
Type: language
Subtag: xcb
Description: Cumbric
Added: 2009-07-29
%%
Type: language
Subtag: xcc
Description: Camunic
Added: 2009-07-29
%%
Type: language
Subtag: xce
Description: Celtiberian
Added: 2009-07-29
%%
Type: language
Subtag: xcg
Description: Cisalpine Gaulish
Added: 2009-07-29
%%
Type: language
Subtag: xch
Description: Chemakum
Description: Chimakum
Added: 2009-07-29
%%
Type: language
Subtag: xcl
Description: Classical Armenian
Added: 2009-07-29
%%
Type: language
Subtag: xcm
Description: Comecrudo
Added: 2009-07-29
%%
Type: language
Subtag: xcn
Description: Cotoname
Added: 2009-07-29
%%
Type: language
Subtag: xco
Description: Chorasmian
Added: 2009-07-29
%%
Type: language
Subtag: xcr
Description: Carian
Added: 2009-07-29
%%
Type: language
Subtag: xct
Description: Classical Tibetan
Added: 2009-07-29
%%
Type: language
Subtag: xcu
Description: Curonian
Added: 2009-07-29
%%
Type: language
Subtag: xcv
Description: Chuvantsy
Added: 2009-07-29
%%
Type: language
Subtag: xcw
Description: Coahuilteco
Added: 2009-07-29
%%
Type: language
Subtag: xcy
Description: Cayuse
Added: 2009-07-29
%%
Type: language
Subtag: xda
Description: Darkinyung
Added: 2013-09-10
%%
Type: language
Subtag: xdc
Description: Dacian
Added: 2009-07-29
%%
Type: language
Subtag: xdk
Description: Dharuk
Added: 2013-09-10
%%
Type: language
Subtag: xdm
Description: Edomite
Added: 2009-07-29
%%
Type: language
Subtag: xdo
Description: Kwandu
Added: 2017-02-23
%%
Type: language
Subtag: xdy
Description: Malayic Dayak
Added: 2009-07-29
%%
Type: language
Subtag: xeb
Description: Eblan
Added: 2009-07-29
%%
Type: language
Subtag: xed
Description: Hdi
Added: 2009-07-29
%%
Type: language
Subtag: xeg
Description: ǁXegwi
Added: 2009-07-29
%%
Type: language
Subtag: xel
Description: Kelo
Added: 2009-07-29
%%
Type: language
Subtag: xem
Description: Kembayan
Added: 2009-07-29
%%
Type: language
Subtag: xep
Description: Epi-Olmec
Added: 2009-07-29
%%
Type: language
Subtag: xer
Description: Xerénte
Added: 2009-07-29
%%
Type: language
Subtag: xes
Description: Kesawai
Added: 2009-07-29
%%
Type: language
Subtag: xet
Description: Xetá
Added: 2009-07-29
%%
Type: language
Subtag: xeu
Description: Keoru-Ahia
Added: 2009-07-29
%%
Type: language
Subtag: xfa
Description: Faliscan
Added: 2009-07-29
%%
Type: language
Subtag: xga
Description: Galatian
Added: 2009-07-29
%%
Type: language
Subtag: xgb
Description: Gbin
Added: 2012-08-12
%%
Type: language
Subtag: xgd
Description: Gudang
Added: 2013-09-10
%%
Type: language
Subtag: xgf
Description: Gabrielino-Fernandeño
Added: 2009-07-29
%%
Type: language
Subtag: xgg
Description: Goreng
Added: 2013-09-10
%%
Type: language
Subtag: xgi
Description: Garingbal
Added: 2013-09-10
%%
Type: language
Subtag: xgl
Description: Galindan
Added: 2009-07-29
%%
Type: language
Subtag: xgm
Description: Dharumbal
Description: Guwinmal
Added: 2013-09-10
%%
Type: language
Subtag: xgn
Description: Mongolian languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: xgr
Description: Garza
Added: 2009-07-29
%%
Type: language
Subtag: xgu
Description: Unggumi
Added: 2012-08-12
%%
Type: language
Subtag: xgw
Description: Guwa
Added: 2013-09-10
%%
Type: language
Subtag: xha
Description: Harami
Added: 2009-07-29
%%
Type: language
Subtag: xhc
Description: Hunnic
Added: 2009-07-29
%%
Type: language
Subtag: xhd
Description: Hadrami
Added: 2009-07-29
%%
Type: language
Subtag: xhe
Description: Khetrani
Added: 2009-07-29
Macrolanguage: lah
%%
Type: language
Subtag: xhr
Description: Hernican
Added: 2009-07-29
%%
Type: language
Subtag: xht
Description: Hattic
Added: 2009-07-29
%%
Type: language
Subtag: xhu
Description: Hurrian
Added: 2009-07-29
%%
Type: language
Subtag: xhv
Description: Khua
Added: 2009-07-29
%%
Type: language
Subtag: xia
Description: Xiandao
Added: 2009-07-29
Deprecated: 2013-09-10
Preferred-Value: acn
%%
Type: language
Subtag: xib
Description: Iberian
Added: 2009-07-29
%%
Type: language
Subtag: xii
Description: Xiri
Added: 2009-07-29
%%
Type: language
Subtag: xil
Description: Illyrian
Added: 2009-07-29
%%
Type: language
Subtag: xin
Description: Xinca
Added: 2009-07-29
%%
Type: language
Subtag: xip
Description: Xipináwa
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: xir
Description: Xiriâna
Added: 2009-07-29
%%
Type: language
Subtag: xis
Description: Kisan
Added: 2014-02-28
%%
Type: language
Subtag: xiv
Description: Indus Valley Language
Added: 2009-07-29
%%
Type: language
Subtag: xiy
Description: Xipaya
Added: 2009-07-29
%%
Type: language
Subtag: xjb
Description: Minjungbal
Added: 2013-09-10
%%
Type: language
Subtag: xjt
Description: Jaitmatang
Added: 2013-09-10
%%
Type: language
Subtag: xka
Description: Kalkoti
Added: 2009-07-29
%%
Type: language
Subtag: xkb
Description: Northern Nago
Added: 2009-07-29
%%
Type: language
Subtag: xkc
Description: Kho'ini
Added: 2009-07-29
%%
Type: language
Subtag: xkd
Description: Mendalam Kayan
Added: 2009-07-29
%%
Type: language
Subtag: xke
Description: Kereho
Added: 2009-07-29
%%
Type: language
Subtag: xkf
Description: Khengkha
Added: 2009-07-29
%%
Type: language
Subtag: xkg
Description: Kagoro
Added: 2009-07-29
%%
Type: language
Subtag: xkh
Description: Karahawyana
Added: 2009-07-29
Deprecated: 2016-05-30
Preferred-Value: waw
%%
Type: language
Subtag: xki
Description: Kenyan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: xkj
Description: Kajali
Added: 2009-07-29
%%
Type: language
Subtag: xkk
Description: Kaco'
Added: 2009-07-29
%%
Type: language
Subtag: xkl
Description: Mainstream Kenyah
Added: 2009-07-29
%%
Type: language
Subtag: xkn
Description: Kayan River Kayan
Added: 2009-07-29
%%
Type: language
Subtag: xko
Description: Kiorr
Added: 2009-07-29
%%
Type: language
Subtag: xkp
Description: Kabatei
Added: 2009-07-29
%%
Type: language
Subtag: xkq
Description: Koroni
Added: 2009-07-29
%%
Type: language
Subtag: xkr
Description: Xakriabá
Added: 2009-07-29
%%
Type: language
Subtag: xks
Description: Kumbewaha
Added: 2009-07-29
%%
Type: language
Subtag: xkt
Description: Kantosi
Added: 2009-07-29
%%
Type: language
Subtag: xku
Description: Kaamba
Added: 2009-07-29
%%
Type: language
Subtag: xkv
Description: Kgalagadi
Added: 2009-07-29
%%
Type: language
Subtag: xkw
Description: Kembra
Added: 2009-07-29
%%
Type: language
Subtag: xkx
Description: Karore
Added: 2009-07-29
%%
Type: language
Subtag: xky
Description: Uma' Lasan
Added: 2009-07-29
%%
Type: language
Subtag: xkz
Description: Kurtokha
Added: 2009-07-29
%%
Type: language
Subtag: xla
Description: Kamula
Added: 2009-07-29
%%
Type: language
Subtag: xlb
Description: Loup B
Added: 2009-07-29
%%
Type: language
Subtag: xlc
Description: Lycian
Added: 2009-07-29
%%
Type: language
Subtag: xld
Description: Lydian
Added: 2009-07-29
%%
Type: language
Subtag: xle
Description: Lemnian
Added: 2009-07-29
%%
Type: language
Subtag: xlg
Description: Ligurian (Ancient)
Added: 2009-07-29
%%
Type: language
Subtag: xli
Description: Liburnian
Added: 2009-07-29
%%
Type: language
Subtag: xln
Description: Alanic
Added: 2009-07-29
%%
Type: language
Subtag: xlo
Description: Loup A
Added: 2009-07-29
%%
Type: language
Subtag: xlp
Description: Lepontic
Added: 2009-07-29
%%
Type: language
Subtag: xls
Description: Lusitanian
Added: 2009-07-29
%%
Type: language
Subtag: xlu
Description: Cuneiform Luwian
Added: 2009-07-29
%%
Type: language
Subtag: xly
Description: Elymian
Added: 2009-07-29
%%
Type: language
Subtag: xma
Description: Mushungulu
Added: 2009-07-29
%%
Type: language
Subtag: xmb
Description: Mbonga
Added: 2009-07-29
%%
Type: language
Subtag: xmc
Description: Makhuwa-Marrevone
Added: 2009-07-29
%%
Type: language
Subtag: xmd
Description: Mbudum
Added: 2009-07-29
%%
Type: language
Subtag: xme
Description: Median
Added: 2009-07-29
%%
Type: language
Subtag: xmf
Description: Mingrelian
Added: 2009-07-29
%%
Type: language
Subtag: xmg
Description: Mengaka
Added: 2009-07-29
%%
Type: language
Subtag: xmh
Description: Kugu-Muminh
Added: 2009-07-29
%%
Type: language
Subtag: xmj
Description: Majera
Added: 2009-07-29
%%
Type: language
Subtag: xmk
Description: Ancient Macedonian
Added: 2009-07-29
%%
Type: language
Subtag: xml
Description: Malaysian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: xmm
Description: Manado Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: xmn
Description: Manichaean Middle Persian
Added: 2009-07-29
%%
Type: language
Subtag: xmo
Description: Morerebi
Added: 2009-07-29
%%
Type: language
Subtag: xmp
Description: Kuku-Mu'inh
Added: 2009-07-29
%%
Type: language
Subtag: xmq
Description: Kuku-Mangk
Added: 2009-07-29
%%
Type: language
Subtag: xmr
Description: Meroitic
Added: 2009-07-29
%%
Type: language
Subtag: xms
Description: Moroccan Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: xmt
Description: Matbat
Added: 2009-07-29
%%
Type: language
Subtag: xmu
Description: Kamu
Added: 2009-07-29
%%
Type: language
Subtag: xmv
Description: Antankarana Malagasy
Description: Tankarana Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: xmw
Description: Tsimihety Malagasy
Added: 2009-07-29
Macrolanguage: mg
%%
Type: language
Subtag: xmx
Description: Maden
Added: 2009-07-29
%%
Type: language
Subtag: xmy
Description: Mayaguduna
Added: 2009-07-29
%%
Type: language
Subtag: xmz
Description: Mori Bawah
Added: 2009-07-29
%%
Type: language
Subtag: xna
Description: Ancient North Arabian
Added: 2009-07-29
%%
Type: language
Subtag: xnb
Description: Kanakanabu
Added: 2009-07-29
%%
Type: language
Subtag: xnd
Description: Na-Dene languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: xng
Description: Middle Mongolian
Added: 2009-07-29
%%
Type: language
Subtag: xnh
Description: Kuanhua
Added: 2009-07-29
%%
Type: language
Subtag: xni
Description: Ngarigu
Added: 2013-09-10
%%
Type: language
Subtag: xnk
Description: Nganakarti
Added: 2013-09-10
%%
Type: language
Subtag: xnn
Description: Northern Kankanay
Added: 2009-07-29
%%
Type: language
Subtag: xno
Description: Anglo-Norman
Added: 2009-07-29
%%
Type: language
Subtag: xnr
Description: Kangri
Added: 2009-07-29
Macrolanguage: doi
%%
Type: language
Subtag: xns
Description: Kanashi
Added: 2009-07-29
%%
Type: language
Subtag: xnt
Description: Narragansett
Added: 2010-03-11
%%
Type: language
Subtag: xnu
Description: Nukunul
Added: 2013-09-10
%%
Type: language
Subtag: xny
Description: Nyiyaparli
Added: 2013-09-10
%%
Type: language
Subtag: xnz
Description: Kenzi
Description: Mattoki
Added: 2012-08-12
%%
Type: language
Subtag: xoc
Description: O'chi'chi'
Added: 2009-07-29
%%
Type: language
Subtag: xod
Description: Kokoda
Added: 2009-07-29
%%
Type: language
Subtag: xog
Description: Soga
Added: 2009-07-29
%%
Type: language
Subtag: xoi
Description: Kominimung
Added: 2009-07-29
%%
Type: language
Subtag: xok
Description: Xokleng
Added: 2009-07-29
%%
Type: language
Subtag: xom
Description: Komo (Sudan)
Added: 2009-07-29
%%
Type: language
Subtag: xon
Description: Konkomba
Added: 2009-07-29
%%
Type: language
Subtag: xoo
Description: Xukurú
Added: 2009-07-29
%%
Type: language
Subtag: xop
Description: Kopar
Added: 2009-07-29
%%
Type: language
Subtag: xor
Description: Korubo
Added: 2009-07-29
%%
Type: language
Subtag: xow
Description: Kowaki
Added: 2009-07-29
%%
Type: language
Subtag: xpa
Description: Pirriya
Added: 2013-09-10
%%
Type: language
Subtag: xpc
Description: Pecheneg
Added: 2009-07-29
%%
Type: language
Subtag: xpe
Description: Liberia Kpelle
Added: 2009-07-29
Macrolanguage: kpe
%%
Type: language
Subtag: xpg
Description: Phrygian
Added: 2009-07-29
%%
Type: language
Subtag: xpi
Description: Pictish
Added: 2009-07-29
%%
Type: language
Subtag: xpj
Description: Mpalitjanh
Added: 2012-08-12
%%
Type: language
Subtag: xpk
Description: Kulina Pano
Added: 2009-07-29
%%
Type: language
Subtag: xpm
Description: Pumpokol
Added: 2009-07-29
%%
Type: language
Subtag: xpn
Description: Kapinawá
Added: 2009-07-29
%%
Type: language
Subtag: xpo
Description: Pochutec
Added: 2009-07-29
%%
Type: language
Subtag: xpp
Description: Puyo-Paekche
Added: 2009-07-29
%%
Type: language
Subtag: xpq
Description: Mohegan-Pequot
Added: 2010-03-11
%%
Type: language
Subtag: xpr
Description: Parthian
Added: 2009-07-29
%%
Type: language
Subtag: xps
Description: Pisidian
Added: 2009-07-29
%%
Type: language
Subtag: xpt
Description: Punthamara
Added: 2013-09-10
%%
Type: language
Subtag: xpu
Description: Punic
Added: 2009-07-29
%%
Type: language
Subtag: xpy
Description: Puyo
Added: 2009-07-29
%%
Type: language
Subtag: xqa
Description: Karakhanid
Added: 2009-07-29
%%
Type: language
Subtag: xqt
Description: Qatabanian
Added: 2009-07-29
%%
Type: language
Subtag: xra
Description: Krahô
Added: 2009-07-29
%%
Type: language
Subtag: xrb
Description: Eastern Karaboro
Added: 2009-07-29
%%
Type: language
Subtag: xrd
Description: Gundungurra
Added: 2013-09-10
%%
Type: language
Subtag: xre
Description: Kreye
Added: 2009-07-29
%%
Type: language
Subtag: xrg
Description: Minang
Added: 2013-09-10
%%
Type: language
Subtag: xri
Description: Krikati-Timbira
Added: 2009-07-29
%%
Type: language
Subtag: xrm
Description: Armazic
Added: 2009-07-29
%%
Type: language
Subtag: xrn
Description: Arin
Added: 2009-07-29
%%
Type: language
Subtag: xrq
Description: Karranga
Added: 2013-09-10
%%
Type: language
Subtag: xrr
Description: Raetic
Added: 2009-07-29
%%
Type: language
Subtag: xrt
Description: Aranama-Tamique
Added: 2009-07-29
%%
Type: language
Subtag: xru
Description: Marriammu
Added: 2009-07-29
%%
Type: language
Subtag: xrw
Description: Karawa
Added: 2009-07-29
%%
Type: language
Subtag: xsa
Description: Sabaean
Added: 2009-07-29
%%
Type: language
Subtag: xsb
Description: Sambal
Added: 2009-07-29
%%
Type: language
Subtag: xsc
Description: Scythian
Added: 2009-07-29
%%
Type: language
Subtag: xsd
Description: Sidetic
Added: 2009-07-29
%%
Type: language
Subtag: xse
Description: Sempan
Added: 2009-07-29
%%
Type: language
Subtag: xsh
Description: Shamang
Added: 2009-07-29
%%
Type: language
Subtag: xsi
Description: Sio
Added: 2009-07-29
%%
Type: language
Subtag: xsj
Description: Subi
Added: 2009-07-29
Comments: see also suj
%%
Type: language
Subtag: xsl
Description: South Slavey
Added: 2009-07-29
Macrolanguage: den
%%
Type: language
Subtag: xsm
Description: Kasem
Added: 2009-07-29
%%
Type: language
Subtag: xsn
Description: Sanga (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: xso
Description: Solano
Added: 2009-07-29
%%
Type: language
Subtag: xsp
Description: Silopi
Added: 2009-07-29
%%
Type: language
Subtag: xsq
Description: Makhuwa-Saka
Added: 2009-07-29
%%
Type: language
Subtag: xsr
Description: Sherpa
Added: 2009-07-29
%%
Type: language
Subtag: xss
Description: Assan
Added: 2009-07-29
%%
Type: language
Subtag: xsu
Description: Sanumá
Added: 2009-07-29
%%
Type: language
Subtag: xsv
Description: Sudovian
Added: 2009-07-29
%%
Type: language
Subtag: xsy
Description: Saisiyat
Added: 2009-07-29
%%
Type: language
Subtag: xta
Description: Alcozauca Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtb
Description: Chazumba Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtc
Description: Katcha-Kadugli-Miri
Added: 2009-07-29
%%
Type: language
Subtag: xtd
Description: Diuxi-Tilantongo Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xte
Description: Ketengban
Added: 2009-07-29
%%
Type: language
Subtag: xtg
Description: Transalpine Gaulish
Added: 2009-07-29
%%
Type: language
Subtag: xth
Description: Yitha Yitha
Added: 2013-09-10
%%
Type: language
Subtag: xti
Description: Sinicahua Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtj
Description: San Juan Teita Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtl
Description: Tijaltepec Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtm
Description: Magdalena Peñasco Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtn
Description: Northern Tlaxiaco Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xto
Description: Tokharian A
Added: 2009-07-29
%%
Type: language
Subtag: xtp
Description: San Miguel Piedras Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtq
Description: Tumshuqese
Added: 2009-07-29
%%
Type: language
Subtag: xtr
Description: Early Tripuri
Added: 2009-07-29
%%
Type: language
Subtag: xts
Description: Sindihui Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtt
Description: Tacahua Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtu
Description: Cuyamecalco Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtv
Description: Thawa
Added: 2013-09-10
%%
Type: language
Subtag: xtw
Description: Tawandê
Added: 2009-07-29
%%
Type: language
Subtag: xty
Description: Yoloxochitl Mixtec
Added: 2009-07-29
%%
Type: language
Subtag: xtz
Description: Tasmanian
Added: 2009-07-29
%%
Type: language
Subtag: xua
Description: Alu Kurumba
Added: 2009-07-29
%%
Type: language
Subtag: xub
Description: Betta Kurumba
Added: 2009-07-29
%%
Type: language
Subtag: xud
Description: Umiida
Added: 2012-08-12
%%
Type: language
Subtag: xug
Description: Kunigami
Added: 2009-07-29
%%
Type: language
Subtag: xuj
Description: Jennu Kurumba
Added: 2009-07-29
%%
Type: language
Subtag: xul
Description: Ngunawal
Added: 2013-09-10
%%
Type: language
Subtag: xum
Description: Umbrian
Added: 2009-07-29
%%
Type: language
Subtag: xun
Description: Unggaranggu
Added: 2012-08-12
%%
Type: language
Subtag: xuo
Description: Kuo
Added: 2009-07-29
%%
Type: language
Subtag: xup
Description: Upper Umpqua
Added: 2009-07-29
%%
Type: language
Subtag: xur
Description: Urartian
Added: 2009-07-29
%%
Type: language
Subtag: xut
Description: Kuthant
Added: 2009-07-29
%%
Type: language
Subtag: xuu
Description: Kxoe
Description: Khwedam
Added: 2009-07-29
%%
Type: language
Subtag: xve
Description: Venetic
Added: 2009-07-29
%%
Type: language
Subtag: xvi
Description: Kamviri
Added: 2009-07-29
%%
Type: language
Subtag: xvn
Description: Vandalic
Added: 2009-07-29
%%
Type: language
Subtag: xvo
Description: Volscian
Added: 2009-07-29
%%
Type: language
Subtag: xvs
Description: Vestinian
Added: 2009-07-29
%%
Type: language
Subtag: xwa
Description: Kwaza
Added: 2009-07-29
%%
Type: language
Subtag: xwc
Description: Woccon
Added: 2009-07-29
%%
Type: language
Subtag: xwd
Description: Wadi Wadi
Added: 2013-09-10
%%
Type: language
Subtag: xwe
Description: Xwela Gbe
Added: 2009-07-29
%%
Type: language
Subtag: xwg
Description: Kwegu
Added: 2009-07-29
%%
Type: language
Subtag: xwj
Description: Wajuk
Added: 2013-09-10
%%
Type: language
Subtag: xwk
Description: Wangkumara
Added: 2013-09-10
%%
Type: language
Subtag: xwl
Description: Western Xwla Gbe
Added: 2009-07-29
%%
Type: language
Subtag: xwo
Description: Written Oirat
Added: 2009-07-29
%%
Type: language
Subtag: xwr
Description: Kwerba Mamberamo
Added: 2009-07-29
%%
Type: language
Subtag: xwt
Description: Wotjobaluk
Added: 2013-09-10
%%
Type: language
Subtag: xww
Description: Wemba Wemba
Added: 2013-09-10
%%
Type: language
Subtag: xxb
Description: Boro (Ghana)
Added: 2009-07-29
%%
Type: language
Subtag: xxk
Description: Ke'o
Added: 2009-07-29
%%
Type: language
Subtag: xxm
Description: Minkin
Added: 2013-09-10
%%
Type: language
Subtag: xxr
Description: Koropó
Added: 2009-07-29
%%
Type: language
Subtag: xxt
Description: Tambora
Added: 2009-07-29
%%
Type: language
Subtag: xya
Description: Yaygir
Added: 2013-09-10
%%
Type: language
Subtag: xyb
Description: Yandjibara
Added: 2013-09-10
%%
Type: language
Subtag: xyj
Description: Mayi-Yapi
Added: 2013-09-10
%%
Type: language
Subtag: xyk
Description: Mayi-Kulan
Added: 2013-09-10
%%
Type: language
Subtag: xyl
Description: Yalakalore
Added: 2009-07-29
%%
Type: language
Subtag: xyt
Description: Mayi-Thakurti
Added: 2013-09-10
%%
Type: language
Subtag: xyy
Description: Yorta Yorta
Added: 2012-08-12
%%
Type: language
Subtag: xzh
Description: Zhang-Zhung
Added: 2009-07-29
%%
Type: language
Subtag: xzm
Description: Zemgalian
Added: 2009-07-29
%%
Type: language
Subtag: xzp
Description: Ancient Zapotec
Added: 2009-07-29
%%
Type: language
Subtag: yaa
Description: Yaminahua
Added: 2009-07-29
%%
Type: language
Subtag: yab
Description: Yuhup
Added: 2009-07-29
%%
Type: language
Subtag: yac
Description: Pass Valley Yali
Added: 2009-07-29
%%
Type: language
Subtag: yad
Description: Yagua
Added: 2009-07-29
%%
Type: language
Subtag: yae
Description: Pumé
Added: 2009-07-29
%%
Type: language
Subtag: yaf
Description: Yaka (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: yag
Description: Yámana
Added: 2009-07-29
%%
Type: language
Subtag: yah
Description: Yazgulyam
Added: 2009-07-29
%%
Type: language
Subtag: yai
Description: Yagnobi
Added: 2009-07-29
%%
Type: language
Subtag: yaj
Description: Banda-Yangere
Added: 2009-07-29
%%
Type: language
Subtag: yak
Description: Yakama
Added: 2009-07-29
%%
Type: language
Subtag: yal
Description: Yalunka
Added: 2009-07-29
%%
Type: language
Subtag: yam
Description: Yamba
Added: 2009-07-29
%%
Type: language
Subtag: yan
Description: Mayangna
Added: 2010-03-11
%%
Type: language
Subtag: yao
Description: Yao
Added: 2005-10-16
%%
Type: language
Subtag: yap
Description: Yapese
Added: 2005-10-16
%%
Type: language
Subtag: yaq
Description: Yaqui
Added: 2009-07-29
%%
Type: language
Subtag: yar
Description: Yabarana
Added: 2009-07-29
%%
Type: language
Subtag: yas
Description: Nugunu (Cameroon)
Added: 2009-07-29
%%
Type: language
Subtag: yat
Description: Yambeta
Added: 2009-07-29
%%
Type: language
Subtag: yau
Description: Yuwana
Added: 2009-07-29
%%
Type: language
Subtag: yav
Description: Yangben
Added: 2009-07-29
%%
Type: language
Subtag: yaw
Description: Yawalapití
Added: 2009-07-29
%%
Type: language
Subtag: yax
Description: Yauma
Added: 2009-07-29
%%
Type: language
Subtag: yay
Description: Agwagwune
Added: 2009-07-29
%%
Type: language
Subtag: yaz
Description: Lokaa
Added: 2009-07-29
%%
Type: language
Subtag: yba
Description: Yala
Added: 2009-07-29
%%
Type: language
Subtag: ybb
Description: Yemba
Added: 2009-07-29
%%
Type: language
Subtag: ybd
Description: Yangbye
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: rki
%%
Type: language
Subtag: ybe
Description: West Yugur
Added: 2009-07-29
%%
Type: language
Subtag: ybh
Description: Yakha
Added: 2009-07-29
%%
Type: language
Subtag: ybi
Description: Yamphu
Added: 2009-07-29
%%
Type: language
Subtag: ybj
Description: Hasha
Added: 2009-07-29
%%
Type: language
Subtag: ybk
Description: Bokha
Added: 2009-07-29
%%
Type: language
Subtag: ybl
Description: Yukuben
Added: 2009-07-29
%%
Type: language
Subtag: ybm
Description: Yaben
Added: 2009-07-29
%%
Type: language
Subtag: ybn
Description: Yabaâna
Added: 2009-07-29
%%
Type: language
Subtag: ybo
Description: Yabong
Added: 2009-07-29
%%
Type: language
Subtag: ybx
Description: Yawiyo
Added: 2009-07-29
%%
Type: language
Subtag: yby
Description: Yaweyuha
Added: 2009-07-29
%%
Type: language
Subtag: ych
Description: Chesu
Added: 2009-07-29
%%
Type: language
Subtag: ycl
Description: Lolopo
Added: 2009-07-29
%%
Type: language
Subtag: ycn
Description: Yucuna
Added: 2009-07-29
%%
Type: language
Subtag: ycp
Description: Chepya
Added: 2009-07-29
%%
Type: language
Subtag: yda
Description: Yanda
Added: 2013-09-10
%%
Type: language
Subtag: ydd
Description: Eastern Yiddish
Added: 2009-07-29
Macrolanguage: yi
%%
Type: language
Subtag: yde
Description: Yangum Dey
Added: 2009-07-29
%%
Type: language
Subtag: ydg
Description: Yidgha
Added: 2009-07-29
%%
Type: language
Subtag: ydk
Description: Yoidik
Added: 2009-07-29
%%
Type: language
Subtag: yds
Description: Yiddish Sign Language
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: yea
Description: Ravula
Added: 2009-07-29
%%
Type: language
Subtag: yec
Description: Yeniche
Added: 2009-07-29
%%
Type: language
Subtag: yee
Description: Yimas
Added: 2009-07-29
%%
Type: language
Subtag: yei
Description: Yeni
Added: 2009-07-29
%%
Type: language
Subtag: yej
Description: Yevanic
Added: 2009-07-29
%%
Type: language
Subtag: yel
Description: Yela
Added: 2009-07-29
%%
Type: language
Subtag: yen
Description: Yendang
Added: 2009-07-29
Deprecated: 2012-08-12
Comments: see ynq, yot
%%
Type: language
Subtag: yer
Description: Tarok
Added: 2009-07-29
%%
Type: language
Subtag: yes
Description: Nyankpa
Added: 2009-07-29
%%
Type: language
Subtag: yet
Description: Yetfa
Added: 2009-07-29
%%
Type: language
Subtag: yeu
Description: Yerukula
Added: 2009-07-29
%%
Type: language
Subtag: yev
Description: Yapunda
Added: 2009-07-29
%%
Type: language
Subtag: yey
Description: Yeyi
Added: 2009-07-29
%%
Type: language
Subtag: yga
Description: Malyangapa
Added: 2012-08-12
%%
Type: language
Subtag: ygi
Description: Yiningayi
Added: 2013-09-10
%%
Type: language
Subtag: ygl
Description: Yangum Gel
Added: 2009-07-29
%%
Type: language
Subtag: ygm
Description: Yagomi
Added: 2009-07-29
%%
Type: language
Subtag: ygp
Description: Gepo
Added: 2009-07-29
%%
Type: language
Subtag: ygr
Description: Yagaria
Added: 2009-07-29
%%
Type: language
Subtag: ygs
Description: Yolŋu Sign Language
Added: 2014-02-28
%%
Type: language
Subtag: ygu
Description: Yugul
Added: 2013-09-10
%%
Type: language
Subtag: ygw
Description: Yagwoia
Added: 2009-07-29
%%
Type: language
Subtag: yha
Description: Baha Buyang
Added: 2009-07-29
%%
Type: language
Subtag: yhd
Description: Judeo-Iraqi Arabic
Added: 2009-07-29
Macrolanguage: jrb
%%
Type: language
Subtag: yhl
Description: Hlepho Phowa
Added: 2009-07-29
%%
Type: language
Subtag: yhs
Description: Yan-nhaŋu Sign Language
Added: 2015-04-17
%%
Type: language
Subtag: yia
Description: Yinggarda
Added: 2009-07-29
%%
Type: language
Subtag: yif
Description: Ache
Added: 2009-07-29
%%
Type: language
Subtag: yig
Description: Wusa Nasu
Added: 2009-07-29
%%
Type: language
Subtag: yih
Description: Western Yiddish
Added: 2009-07-29
Macrolanguage: yi
%%
Type: language
Subtag: yii
Description: Yidiny
Added: 2009-07-29
%%
Type: language
Subtag: yij
Description: Yindjibarndi
Added: 2009-07-29
%%
Type: language
Subtag: yik
Description: Dongshanba Lalo
Added: 2009-07-29
%%
Type: language
Subtag: yil
Description: Yindjilandji
Added: 2009-07-29
%%
Type: language
Subtag: yim
Description: Yimchungru Naga
Added: 2009-07-29
%%
Type: language
Subtag: yin
Description: Riang Lai
Description: Yinchia
Added: 2009-07-29
%%
Type: language
Subtag: yip
Description: Pholo
Added: 2009-07-29
%%
Type: language
Subtag: yiq
Description: Miqie
Added: 2009-07-29
%%
Type: language
Subtag: yir
Description: North Awyu
Added: 2009-07-29
%%
Type: language
Subtag: yis
Description: Yis
Added: 2009-07-29
%%
Type: language
Subtag: yit
Description: Eastern Lalu
Added: 2009-07-29
%%
Type: language
Subtag: yiu
Description: Awu
Added: 2009-07-29
%%
Type: language
Subtag: yiv
Description: Northern Nisu
Added: 2009-07-29
%%
Type: language
Subtag: yix
Description: Axi Yi
Added: 2009-07-29
%%
Type: language
Subtag: yiy
Description: Yir Yoront
Added: 2009-07-29
Deprecated: 2013-09-10
Comments: see yrm, yyr
%%
Type: language
Subtag: yiz
Description: Azhe
Added: 2009-07-29
%%
Type: language
Subtag: yka
Description: Yakan
Added: 2009-07-29
%%
Type: language
Subtag: ykg
Description: Northern Yukaghir
Added: 2009-07-29
%%
Type: language
Subtag: yki
Description: Yoke
Added: 2009-07-29
%%
Type: language
Subtag: ykk
Description: Yakaikeke
Added: 2009-07-29
%%
Type: language
Subtag: ykl
Description: Khlula
Added: 2009-07-29
%%
Type: language
Subtag: ykm
Description: Kap
Added: 2009-07-29
%%
Type: language
Subtag: ykn
Description: Kua-nsi
Added: 2012-08-12
%%
Type: language
Subtag: yko
Description: Yasa
Added: 2009-07-29
%%
Type: language
Subtag: ykr
Description: Yekora
Added: 2009-07-29
%%
Type: language
Subtag: ykt
Description: Kathu
Added: 2009-07-29
%%
Type: language
Subtag: yku
Description: Kuamasi
Added: 2012-08-12
%%
Type: language
Subtag: yky
Description: Yakoma
Added: 2009-07-29
%%
Type: language
Subtag: yla
Description: Yaul
Added: 2009-07-29
%%
Type: language
Subtag: ylb
Description: Yaleba
Added: 2010-03-11
%%
Type: language
Subtag: yle
Description: Yele
Added: 2009-07-29
%%
Type: language
Subtag: ylg
Description: Yelogu
Added: 2009-07-29
%%
Type: language
Subtag: yli
Description: Angguruk Yali
Added: 2009-07-29
%%
Type: language
Subtag: yll
Description: Yil
Added: 2009-07-29
%%
Type: language
Subtag: ylm
Description: Limi
Added: 2009-07-29
%%
Type: language
Subtag: yln
Description: Langnian Buyang
Added: 2009-07-29
%%
Type: language
Subtag: ylo
Description: Naluo Yi
Added: 2009-07-29
%%
Type: language
Subtag: ylr
Description: Yalarnnga
Added: 2009-07-29
%%
Type: language
Subtag: ylu
Description: Aribwaung
Added: 2009-07-29
%%
Type: language
Subtag: yly
Description: Nyâlayu
Description: Nyelâyu
Added: 2009-07-29
%%
Type: language
Subtag: yma
Description: Yamphe
Added: 2009-07-29
Deprecated: 2012-08-12
Preferred-Value: lrr
%%
Type: language
Subtag: ymb
Description: Yambes
Added: 2009-07-29
%%
Type: language
Subtag: ymc
Description: Southern Muji
Added: 2009-07-29
%%
Type: language
Subtag: ymd
Description: Muda
Added: 2009-07-29
%%
Type: language
Subtag: yme
Description: Yameo
Added: 2009-07-29
%%
Type: language
Subtag: ymg
Description: Yamongeri
Added: 2009-07-29
%%
Type: language
Subtag: ymh
Description: Mili
Added: 2009-07-29
%%
Type: language
Subtag: ymi
Description: Moji
Added: 2009-07-29
%%
Type: language
Subtag: ymk
Description: Makwe
Added: 2009-07-29
%%
Type: language
Subtag: yml
Description: Iamalele
Added: 2009-07-29
%%
Type: language
Subtag: ymm
Description: Maay
Added: 2009-07-29
%%
Type: language
Subtag: ymn
Description: Yamna
Description: Sunum
Added: 2009-07-29
%%
Type: language
Subtag: ymo
Description: Yangum Mon
Added: 2009-07-29
%%
Type: language
Subtag: ymp
Description: Yamap
Added: 2009-07-29
%%
Type: language
Subtag: ymq
Description: Qila Muji
Added: 2009-07-29
%%
Type: language
Subtag: ymr
Description: Malasar
Added: 2009-07-29
%%
Type: language
Subtag: yms
Description: Mysian
Added: 2009-07-29
%%
Type: language
Subtag: ymt
Description: Mator-Taygi-Karagas
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: mtm
%%
Type: language
Subtag: ymx
Description: Northern Muji
Added: 2009-07-29
%%
Type: language
Subtag: ymz
Description: Muzi
Added: 2009-07-29
%%
Type: language
Subtag: yna
Description: Aluo
Added: 2009-07-29
%%
Type: language
Subtag: ynd
Description: Yandruwandha
Added: 2009-07-29
%%
Type: language
Subtag: yne
Description: Lang'e
Added: 2009-07-29
%%
Type: language
Subtag: yng
Description: Yango
Added: 2009-07-29
%%
Type: language
Subtag: ynh
Description: Yangho
Added: 2009-07-29
Deprecated: 2015-02-12
%%
Type: language
Subtag: ynk
Description: Naukan Yupik
Added: 2009-07-29
%%
Type: language
Subtag: ynl
Description: Yangulam
Added: 2009-07-29
%%
Type: language
Subtag: ynn
Description: Yana
Added: 2009-07-29
%%
Type: language
Subtag: yno
Description: Yong
Added: 2009-07-29
%%
Type: language
Subtag: ynq
Description: Yendang
Added: 2012-08-12
%%
Type: language
Subtag: yns
Description: Yansi
Added: 2009-07-29
%%
Type: language
Subtag: ynu
Description: Yahuna
Added: 2009-07-29
%%
Type: language
Subtag: yob
Description: Yoba
Added: 2009-07-29
%%
Type: language
Subtag: yog
Description: Yogad
Added: 2009-07-29
%%
Type: language
Subtag: yoi
Description: Yonaguni
Added: 2009-07-29
%%
Type: language
Subtag: yok
Description: Yokuts
Added: 2009-07-29
%%
Type: language
Subtag: yol
Description: Yola
Added: 2009-07-29
%%
Type: language
Subtag: yom
Description: Yombe
Added: 2009-07-29
%%
Type: language
Subtag: yon
Description: Yongkom
Added: 2009-07-29
%%
Type: language
Subtag: yos
Description: Yos
Added: 2009-07-29
Deprecated: 2013-09-10
Preferred-Value: zom
%%
Type: language
Subtag: yot
Description: Yotti
Added: 2012-08-12
%%
Type: language
Subtag: yox
Description: Yoron
Added: 2009-07-29
%%
Type: language
Subtag: yoy
Description: Yoy
Added: 2009-07-29
%%
Type: language
Subtag: ypa
Description: Phala
Added: 2009-07-29
%%
Type: language
Subtag: ypb
Description: Labo Phowa
Added: 2009-07-29
%%
Type: language
Subtag: ypg
Description: Phola
Added: 2009-07-29
%%
Type: language
Subtag: yph
Description: Phupha
Added: 2009-07-29
%%
Type: language
Subtag: ypk
Description: Yupik languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: ypm
Description: Phuma
Added: 2009-07-29
%%
Type: language
Subtag: ypn
Description: Ani Phowa
Added: 2009-07-29
%%
Type: language
Subtag: ypo
Description: Alo Phola
Added: 2009-07-29
%%
Type: language
Subtag: ypp
Description: Phupa
Added: 2009-07-29
%%
Type: language
Subtag: ypz
Description: Phuza
Added: 2009-07-29
%%
Type: language
Subtag: yra
Description: Yerakai
Added: 2009-07-29
%%
Type: language
Subtag: yrb
Description: Yareba
Added: 2009-07-29
%%
Type: language
Subtag: yre
Description: Yaouré
Added: 2009-07-29
%%
Type: language
Subtag: yri
Description: Yarí
Added: 2009-07-29
Deprecated: 2016-05-30
%%
Type: language
Subtag: yrk
Description: Nenets
Added: 2009-07-29
%%
Type: language
Subtag: yrl
Description: Nhengatu
Added: 2009-07-29
%%
Type: language
Subtag: yrm
Description: Yirrk-Mel
Added: 2013-09-10
%%
Type: language
Subtag: yrn
Description: Yerong
Added: 2009-07-29
%%
Type: language
Subtag: yro
Description: Yaroamë
Added: 2016-05-30
%%
Type: language
Subtag: yrs
Description: Yarsun
Added: 2009-07-29
%%
Type: language
Subtag: yrw
Description: Yarawata
Added: 2009-07-29
%%
Type: language
Subtag: yry
Description: Yarluyandi
Added: 2013-09-10
%%
Type: language
Subtag: ysc
Description: Yassic
Added: 2009-07-29
%%
Type: language
Subtag: ysd
Description: Samatao
Added: 2009-07-29
%%
Type: language
Subtag: ysg
Description: Sonaga
Added: 2012-08-12
%%
Type: language
Subtag: ysl
Description: Yugoslavian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: ysn
Description: Sani
Added: 2009-07-29
%%
Type: language
Subtag: yso
Description: Nisi (China)
Added: 2009-07-29
%%
Type: language
Subtag: ysp
Description: Southern Lolopo
Added: 2009-07-29
%%
Type: language
Subtag: ysr
Description: Sirenik Yupik
Added: 2009-07-29
%%
Type: language
Subtag: yss
Description: Yessan-Mayo
Added: 2009-07-29
%%
Type: language
Subtag: ysy
Description: Sanie
Added: 2009-07-29
%%
Type: language
Subtag: yta
Description: Talu
Added: 2009-07-29
%%
Type: language
Subtag: ytl
Description: Tanglang
Added: 2009-07-29
%%
Type: language
Subtag: ytp
Description: Thopho
Added: 2009-07-29
%%
Type: language
Subtag: ytw
Description: Yout Wam
Added: 2010-03-11
%%
Type: language
Subtag: yty
Description: Yatay
Added: 2013-09-10
%%
Type: language
Subtag: yua
Description: Yucateco
Description: Yucatec Maya
Added: 2009-07-29
%%
Type: language
Subtag: yub
Description: Yugambal
Added: 2009-07-29
%%
Type: language
Subtag: yuc
Description: Yuchi
Added: 2009-07-29
%%
Type: language
Subtag: yud
Description: Judeo-Tripolitanian Arabic
Added: 2009-07-29
Macrolanguage: jrb
%%
Type: language
Subtag: yue
Description: Yue Chinese
Description: Cantonese
Added: 2009-07-29
Macrolanguage: zh
%%
Type: language
Subtag: yuf
Description: Havasupai-Walapai-Yavapai
Added: 2009-07-29
%%
Type: language
Subtag: yug
Description: Yug
Added: 2009-07-29
%%
Type: language
Subtag: yui
Description: Yurutí
Added: 2009-07-29
%%
Type: language
Subtag: yuj
Description: Karkar-Yuri
Added: 2009-07-29
%%
Type: language
Subtag: yuk
Description: Yuki
Added: 2009-07-29
%%
Type: language
Subtag: yul
Description: Yulu
Added: 2009-07-29
%%
Type: language
Subtag: yum
Description: Quechan
Added: 2009-07-29
%%
Type: language
Subtag: yun
Description: Bena (Nigeria)
Added: 2009-07-29
%%
Type: language
Subtag: yup
Description: Yukpa
Added: 2009-07-29
%%
Type: language
Subtag: yuq
Description: Yuqui
Added: 2009-07-29
%%
Type: language
Subtag: yur
Description: Yurok
Added: 2009-07-29
%%
Type: language
Subtag: yut
Description: Yopno
Added: 2009-07-29
%%
Type: language
Subtag: yuu
Description: Yugh
Added: 2009-07-29
Deprecated: 2014-02-28
Preferred-Value: yug
%%
Type: language
Subtag: yuw
Description: Yau (Morobe Province)
Added: 2009-07-29
%%
Type: language
Subtag: yux
Description: Southern Yukaghir
Added: 2009-07-29
%%
Type: language
Subtag: yuy
Description: East Yugur
Added: 2009-07-29
%%
Type: language
Subtag: yuz
Description: Yuracare
Added: 2009-07-29
%%
Type: language
Subtag: yva
Description: Yawa
Added: 2009-07-29
%%
Type: language
Subtag: yvt
Description: Yavitero
Added: 2009-07-29
%%
Type: language
Subtag: ywa
Description: Kalou
Added: 2009-07-29
%%
Type: language
Subtag: ywg
Description: Yinhawangka
Added: 2013-09-10
%%
Type: language
Subtag: ywl
Description: Western Lalu
Added: 2009-07-29
%%
Type: language
Subtag: ywn
Description: Yawanawa
Added: 2009-07-29
%%
Type: language
Subtag: ywq
Description: Wuding-Luquan Yi
Added: 2009-07-29
%%
Type: language
Subtag: ywr
Description: Yawuru
Added: 2009-07-29
%%
Type: language
Subtag: ywt
Description: Xishanba Lalo
Description: Central Lalo
Added: 2009-07-29
%%
Type: language
Subtag: ywu
Description: Wumeng Nasu
Added: 2009-07-29
%%
Type: language
Subtag: yww
Description: Yawarawarga
Added: 2009-07-29
%%
Type: language
Subtag: yxa
Description: Mayawali
Added: 2013-09-10
%%
Type: language
Subtag: yxg
Description: Yagara
Added: 2012-08-12
%%
Type: language
Subtag: yxl
Description: Yardliyawarra
Added: 2013-09-10
%%
Type: language
Subtag: yxm
Description: Yinwum
Added: 2013-09-10
%%
Type: language
Subtag: yxu
Description: Yuyu
Added: 2013-09-10
%%
Type: language
Subtag: yxy
Description: Yabula Yabula
Added: 2012-08-12
%%
Type: language
Subtag: yyr
Description: Yir Yoront
Added: 2013-09-03
%%
Type: language
Subtag: yyu
Description: Yau (Sandaun Province)
Added: 2009-07-29
%%
Type: language
Subtag: yyz
Description: Ayizi
Added: 2009-07-29
%%
Type: language
Subtag: yzg
Description: E'ma Buyang
Added: 2009-07-29
%%
Type: language
Subtag: yzk
Description: Zokhuo
Added: 2009-07-29
%%
Type: language
Subtag: zaa
Description: Sierra de Juárez Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zab
Description: Western Tlacolula Valley Zapotec
Description: San Juan Guelavía Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zac
Description: Ocotlán Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zad
Description: Cajonos Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zae
Description: Yareni Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zaf
Description: Ayoquesco Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zag
Description: Zaghawa
Added: 2009-07-29
%%
Type: language
Subtag: zah
Description: Zangwal
Added: 2009-07-29
%%
Type: language
Subtag: zai
Description: Isthmus Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zaj
Description: Zaramo
Added: 2009-07-29
%%
Type: language
Subtag: zak
Description: Zanaki
Added: 2009-07-29
%%
Type: language
Subtag: zal
Description: Zauzou
Added: 2009-07-29
%%
Type: language
Subtag: zam
Description: Miahuatlán Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zao
Description: Ozolotepec Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zap
Description: Zapotec
Added: 2005-10-16
Scope: macrolanguage
%%
Type: language
Subtag: zaq
Description: Aloápam Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zar
Description: Rincón Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zas
Description: Santo Domingo Albarradas Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zat
Description: Tabaa Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zau
Description: Zangskari
Added: 2009-07-29
%%
Type: language
Subtag: zav
Description: Yatzachi Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zaw
Description: Mitla Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zax
Description: Xadani Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zay
Description: Zayse-Zergulla
Description: Zaysete
Added: 2009-07-29
%%
Type: language
Subtag: zaz
Description: Zari
Added: 2009-07-29
%%
Type: language
Subtag: zbc
Description: Central Berawan
Added: 2009-07-29
%%
Type: language
Subtag: zbe
Description: East Berawan
Added: 2009-07-29
%%
Type: language
Subtag: zbl
Description: Blissymbols
Description: Bliss
Description: Blissymbolics
Added: 2007-08-21
Suppress-Script: Blis
%%
Type: language
Subtag: zbt
Description: Batui
Added: 2009-07-29
%%
Type: language
Subtag: zbw
Description: West Berawan
Added: 2009-07-29
%%
Type: language
Subtag: zca
Description: Coatecas Altas Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zch
Description: Central Hongshuihe Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zdj
Description: Ngazidja Comorian
Added: 2009-07-29
%%
Type: language
Subtag: zea
Description: Zeeuws
Added: 2009-07-29
%%
Type: language
Subtag: zeg
Description: Zenag
Added: 2009-07-29
%%
Type: language
Subtag: zeh
Description: Eastern Hongshuihe Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zen
Description: Zenaga
Added: 2005-10-16
%%
Type: language
Subtag: zga
Description: Kinga
Added: 2009-07-29
%%
Type: language
Subtag: zgb
Description: Guibei Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zgh
Description: Standard Moroccan Tamazight
Added: 2013-01-25
%%
Type: language
Subtag: zgm
Description: Minz Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zgn
Description: Guibian Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zgr
Description: Magori
Added: 2009-07-29
%%
Type: language
Subtag: zhb
Description: Zhaba
Added: 2009-07-29
%%
Type: language
Subtag: zhd
Description: Dai Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zhi
Description: Zhire
Added: 2009-07-29
%%
Type: language
Subtag: zhn
Description: Nong Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zhw
Description: Zhoa
Added: 2009-07-29
%%
Type: language
Subtag: zhx
Description: Chinese (family)
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: zia
Description: Zia
Added: 2009-07-29
%%
Type: language
Subtag: zib
Description: Zimbabwe Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: zik
Description: Zimakani
Added: 2009-07-29
%%
Type: language
Subtag: zil
Description: Zialo
Added: 2011-08-16
%%
Type: language
Subtag: zim
Description: Mesme
Added: 2009-07-29
%%
Type: language
Subtag: zin
Description: Zinza
Added: 2009-07-29
%%
Type: language
Subtag: zir
Description: Ziriya
Added: 2009-07-29
%%
Type: language
Subtag: ziw
Description: Zigula
Added: 2009-07-29
%%
Type: language
Subtag: ziz
Description: Zizilivakan
Added: 2009-07-29
%%
Type: language
Subtag: zka
Description: Kaimbulawa
Added: 2009-07-29
%%
Type: language
Subtag: zkb
Description: Koibal
Added: 2009-07-29
%%
Type: language
Subtag: zkd
Description: Kadu
Added: 2012-08-12
%%
Type: language
Subtag: zkg
Description: Koguryo
Added: 2009-07-29
%%
Type: language
Subtag: zkh
Description: Khorezmian
Added: 2009-07-29
%%
Type: language
Subtag: zkk
Description: Karankawa
Added: 2009-07-29
%%
Type: language
Subtag: zkn
Description: Kanan
Added: 2012-08-12
%%
Type: language
Subtag: zko
Description: Kott
Added: 2009-07-29
%%
Type: language
Subtag: zkp
Description: São Paulo Kaingáng
Added: 2009-07-29
%%
Type: language
Subtag: zkr
Description: Zakhring
Added: 2009-07-29
%%
Type: language
Subtag: zkt
Description: Kitan
Added: 2009-07-29
%%
Type: language
Subtag: zku
Description: Kaurna
Added: 2009-07-29
%%
Type: language
Subtag: zkv
Description: Krevinian
Added: 2009-07-29
%%
Type: language
Subtag: zkz
Description: Khazar
Added: 2009-07-29
%%
Type: language
Subtag: zle
Description: East Slavic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: zlj
Description: Liujiang Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zlm
Description: Malay (individual language)
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: zln
Description: Lianshan Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zlq
Description: Liuqian Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zls
Description: South Slavic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: zlw
Description: West Slavic languages
Added: 2009-07-29
Scope: collection
%%
Type: language
Subtag: zma
Description: Manda (Australia)
Added: 2009-07-29
%%
Type: language
Subtag: zmb
Description: Zimba
Added: 2009-07-29
%%
Type: language
Subtag: zmc
Description: Margany
Added: 2009-07-29
%%
Type: language
Subtag: zmd
Description: Maridan
Added: 2009-07-29
%%
Type: language
Subtag: zme
Description: Mangerr
Added: 2009-07-29
%%
Type: language
Subtag: zmf
Description: Mfinu
Added: 2009-07-29
%%
Type: language
Subtag: zmg
Description: Marti Ke
Added: 2009-07-29
%%
Type: language
Subtag: zmh
Description: Makolkol
Added: 2009-07-29
%%
Type: language
Subtag: zmi
Description: Negeri Sembilan Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: zmj
Description: Maridjabin
Added: 2009-07-29
%%
Type: language
Subtag: zmk
Description: Mandandanyi
Added: 2009-07-29
%%
Type: language
Subtag: zml
Description: Matngala
Added: 2009-07-29
%%
Type: language
Subtag: zmm
Description: Marimanindji
Description: Marramaninyshi
Added: 2009-07-29
%%
Type: language
Subtag: zmn
Description: Mbangwe
Added: 2009-07-29
%%
Type: language
Subtag: zmo
Description: Molo
Added: 2009-07-29
%%
Type: language
Subtag: zmp
Description: Mpuono
Added: 2009-07-29
%%
Type: language
Subtag: zmq
Description: Mituku
Added: 2009-07-29
%%
Type: language
Subtag: zmr
Description: Maranunggu
Added: 2009-07-29
%%
Type: language
Subtag: zms
Description: Mbesa
Added: 2009-07-29
%%
Type: language
Subtag: zmt
Description: Maringarr
Added: 2009-07-29
%%
Type: language
Subtag: zmu
Description: Muruwari
Added: 2009-07-29
%%
Type: language
Subtag: zmv
Description: Mbariman-Gudhinma
Added: 2009-07-29
%%
Type: language
Subtag: zmw
Description: Mbo (Democratic Republic of Congo)
Added: 2009-07-29
%%
Type: language
Subtag: zmx
Description: Bomitaba
Added: 2009-07-29
%%
Type: language
Subtag: zmy
Description: Mariyedi
Added: 2009-07-29
%%
Type: language
Subtag: zmz
Description: Mbandja
Added: 2009-07-29
%%
Type: language
Subtag: zna
Description: Zan Gula
Added: 2009-07-29
%%
Type: language
Subtag: znd
Description: Zande languages
Added: 2005-10-16
Scope: collection
%%
Type: language
Subtag: zne
Description: Zande (individual language)
Added: 2009-07-29
%%
Type: language
Subtag: zng
Description: Mang
Added: 2009-07-29
%%
Type: language
Subtag: znk
Description: Manangkari
Added: 2009-07-29
%%
Type: language
Subtag: zns
Description: Mangas
Added: 2009-07-29
%%
Type: language
Subtag: zoc
Description: Copainalá Zoque
Added: 2009-07-29
%%
Type: language
Subtag: zoh
Description: Chimalapa Zoque
Added: 2009-07-29
%%
Type: language
Subtag: zom
Description: Zou
Added: 2009-07-29
%%
Type: language
Subtag: zoo
Description: Asunción Mixtepec Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zoq
Description: Tabasco Zoque
Added: 2009-07-29
%%
Type: language
Subtag: zor
Description: Rayón Zoque
Added: 2009-07-29
%%
Type: language
Subtag: zos
Description: Francisco León Zoque
Added: 2009-07-29
%%
Type: language
Subtag: zpa
Description: Lachiguiri Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpb
Description: Yautepec Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpc
Description: Choapan Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpd
Description: Southeastern Ixtlán Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpe
Description: Petapa Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpf
Description: San Pedro Quiatoni Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpg
Description: Guevea De Humboldt Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zph
Description: Totomachapan Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpi
Description: Santa María Quiegolani Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpj
Description: Quiavicuzas Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpk
Description: Tlacolulita Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpl
Description: Lachixío Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpm
Description: Mixtepec Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpn
Description: Santa Inés Yatzechi Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpo
Description: Amatlán Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpp
Description: El Alto Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpq
Description: Zoogocho Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpr
Description: Santiago Xanica Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zps
Description: Coatlán Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpt
Description: San Vicente Coatlán Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpu
Description: Yalálag Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpv
Description: Chichicapan Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpw
Description: Zaniza Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpx
Description: San Baltazar Loxicha Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpy
Description: Mazaltepec Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zpz
Description: Texmelucan Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zqe
Description: Qiubei Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zra
Description: Kara (Korea)
Added: 2009-07-29
%%
Type: language
Subtag: zrg
Description: Mirgan
Added: 2009-07-29
%%
Type: language
Subtag: zrn
Description: Zerenkel
Added: 2009-07-29
%%
Type: language
Subtag: zro
Description: Záparo
Added: 2009-07-29
%%
Type: language
Subtag: zrp
Description: Zarphatic
Added: 2009-07-29
%%
Type: language
Subtag: zrs
Description: Mairasi
Added: 2009-07-29
%%
Type: language
Subtag: zsa
Description: Sarasira
Added: 2009-07-29
%%
Type: language
Subtag: zsk
Description: Kaskean
Added: 2009-07-29
%%
Type: language
Subtag: zsl
Description: Zambian Sign Language
Added: 2009-07-29
%%
Type: language
Subtag: zsm
Description: Standard Malay
Added: 2009-07-29
Macrolanguage: ms
%%
Type: language
Subtag: zsr
Description: Southern Rincon Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zsu
Description: Sukurum
Added: 2009-07-29
%%
Type: language
Subtag: zte
Description: Elotepec Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztg
Description: Xanaguía Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztl
Description: Lapaguía-Guivini Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztm
Description: San Agustín Mixtepec Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztn
Description: Santa Catarina Albarradas Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztp
Description: Loxicha Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztq
Description: Quioquitani-Quierí Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zts
Description: Tilquiapan Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztt
Description: Tejalapan Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztu
Description: Güilá Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: ztx
Description: Zaachila Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zty
Description: Yatee Zapotec
Added: 2009-07-29
Macrolanguage: zap
%%
Type: language
Subtag: zua
Description: Zeem
Added: 2009-07-29
%%
Type: language
Subtag: zuh
Description: Tokano
Added: 2009-07-29
%%
Type: language
Subtag: zum
Description: Kumzari
Added: 2009-07-29
%%
Type: language
Subtag: zun
Description: Zuni
Added: 2005-10-16
%%
Type: language
Subtag: zuy
Description: Zumaya
Added: 2009-07-29
%%
Type: language
Subtag: zwa
Description: Zay
Added: 2009-07-29
%%
Type: language
Subtag: zxx
Description: No linguistic content
Description: Not applicable
Added: 2006-03-08
Scope: special
%%
Type: language
Subtag: zyb
Description: Yongbei Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zyg
Description: Yang Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zyj
Description: Youjiang Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zyn
Description: Yongnan Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: language
Subtag: zyp
Description: Zyphe Chin
Added: 2009-07-29
%%
Type: language
Subtag: zza
Description: Zaza
Description: Dimili
Description: Dimli (macrolanguage)
Description: Kirdki
Description: Kirmanjki (macrolanguage)
Description: Zazaki
Added: 2006-08-24
Scope: macrolanguage
%%
Type: language
Subtag: zzj
Description: Zuojiang Zhuang
Added: 2009-07-29
Macrolanguage: za
%%
Type: extlang
Subtag: aao
Description: Algerian Saharan Arabic
Added: 2009-07-29
Preferred-Value: aao
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: abh
Description: Tajiki Arabic
Added: 2009-07-29
Preferred-Value: abh
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: abv
Description: Baharna Arabic
Added: 2009-07-29
Preferred-Value: abv
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: acm
Description: Mesopotamian Arabic
Added: 2009-07-29
Preferred-Value: acm
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: acq
Description: Ta'izzi-Adeni Arabic
Added: 2009-07-29
Preferred-Value: acq
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: acw
Description: Hijazi Arabic
Added: 2009-07-29
Preferred-Value: acw
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: acx
Description: Omani Arabic
Added: 2009-07-29
Preferred-Value: acx
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: acy
Description: Cypriot Arabic
Added: 2009-07-29
Preferred-Value: acy
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: adf
Description: Dhofari Arabic
Added: 2009-07-29
Preferred-Value: adf
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ads
Description: Adamorobe Sign Language
Added: 2009-07-29
Preferred-Value: ads
Prefix: sgn
%%
Type: extlang
Subtag: aeb
Description: Tunisian Arabic
Added: 2009-07-29
Preferred-Value: aeb
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: aec
Description: Saidi Arabic
Added: 2009-07-29
Preferred-Value: aec
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: aed
Description: Argentine Sign Language
Added: 2009-07-29
Preferred-Value: aed
Prefix: sgn
%%
Type: extlang
Subtag: aen
Description: Armenian Sign Language
Added: 2009-07-29
Preferred-Value: aen
Prefix: sgn
%%
Type: extlang
Subtag: afb
Description: Gulf Arabic
Added: 2009-07-29
Preferred-Value: afb
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: afg
Description: Afghan Sign Language
Added: 2009-07-29
Preferred-Value: afg
Prefix: sgn
%%
Type: extlang
Subtag: ajp
Description: South Levantine Arabic
Added: 2009-07-29
Preferred-Value: ajp
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: apc
Description: North Levantine Arabic
Added: 2009-07-29
Preferred-Value: apc
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: apd
Description: Sudanese Arabic
Added: 2009-07-29
Preferred-Value: apd
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: arb
Description: Standard Arabic
Added: 2009-07-29
Preferred-Value: arb
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: arq
Description: Algerian Arabic
Added: 2009-07-29
Preferred-Value: arq
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ars
Description: Najdi Arabic
Added: 2009-07-29
Preferred-Value: ars
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ary
Description: Moroccan Arabic
Added: 2009-07-29
Preferred-Value: ary
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: arz
Description: Egyptian Arabic
Added: 2009-07-29
Preferred-Value: arz
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ase
Description: American Sign Language
Added: 2009-07-29
Preferred-Value: ase
Prefix: sgn
%%
Type: extlang
Subtag: asf
Description: Auslan
Description: Australian Sign Language
Added: 2009-07-29
Preferred-Value: asf
Prefix: sgn
%%
Type: extlang
Subtag: asp
Description: Algerian Sign Language
Added: 2009-07-29
Preferred-Value: asp
Prefix: sgn
%%
Type: extlang
Subtag: asq
Description: Austrian Sign Language
Added: 2009-07-29
Preferred-Value: asq
Prefix: sgn
%%
Type: extlang
Subtag: asw
Description: Australian Aborigines Sign Language
Added: 2009-07-29
Preferred-Value: asw
Prefix: sgn
%%
Type: extlang
Subtag: auz
Description: Uzbeki Arabic
Added: 2009-07-29
Preferred-Value: auz
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: avl
Description: Eastern Egyptian Bedawi Arabic
Added: 2009-07-29
Preferred-Value: avl
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ayh
Description: Hadrami Arabic
Added: 2009-07-29
Preferred-Value: ayh
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ayl
Description: Libyan Arabic
Added: 2009-07-29
Preferred-Value: ayl
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ayn
Description: Sanaani Arabic
Added: 2009-07-29
Preferred-Value: ayn
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ayp
Description: North Mesopotamian Arabic
Added: 2009-07-29
Preferred-Value: ayp
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: bbz
Description: Babalia Creole Arabic
Added: 2009-07-29
Preferred-Value: bbz
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: bfi
Description: British Sign Language
Added: 2009-07-29
Preferred-Value: bfi
Prefix: sgn
%%
Type: extlang
Subtag: bfk
Description: Ban Khor Sign Language
Added: 2009-07-29
Preferred-Value: bfk
Prefix: sgn
%%
Type: extlang
Subtag: bjn
Description: Banjar
Added: 2009-07-29
Preferred-Value: bjn
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: bog
Description: Bamako Sign Language
Added: 2009-07-29
Preferred-Value: bog
Prefix: sgn
%%
Type: extlang
Subtag: bqn
Description: Bulgarian Sign Language
Added: 2009-07-29
Preferred-Value: bqn
Prefix: sgn
%%
Type: extlang
Subtag: bqy
Description: Bengkala Sign Language
Added: 2009-07-29
Preferred-Value: bqy
Prefix: sgn
%%
Type: extlang
Subtag: btj
Description: Bacanese Malay
Added: 2009-07-29
Preferred-Value: btj
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: bve
Description: Berau Malay
Added: 2009-07-29
Preferred-Value: bve
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: bvl
Description: Bolivian Sign Language
Added: 2009-07-29
Preferred-Value: bvl
Prefix: sgn
%%
Type: extlang
Subtag: bvu
Description: Bukit Malay
Added: 2009-07-29
Preferred-Value: bvu
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: bzs
Description: Brazilian Sign Language
Added: 2009-07-29
Preferred-Value: bzs
Prefix: sgn
%%
Type: extlang
Subtag: cdo
Description: Min Dong Chinese
Added: 2009-07-29
Preferred-Value: cdo
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: cds
Description: Chadian Sign Language
Added: 2009-07-29
Preferred-Value: cds
Prefix: sgn
%%
Type: extlang
Subtag: cjy
Description: Jinyu Chinese
Added: 2009-07-29
Preferred-Value: cjy
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: cmn
Description: Mandarin Chinese
Added: 2009-07-29
Preferred-Value: cmn
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: coa
Description: Cocos Islands Malay
Added: 2009-07-29
Preferred-Value: coa
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: cpx
Description: Pu-Xian Chinese
Added: 2009-07-29
Preferred-Value: cpx
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: csc
Description: Catalan Sign Language
Description: Lengua de señas catalana
Description: Llengua de Signes Catalana
Added: 2009-07-29
Preferred-Value: csc
Prefix: sgn
%%
Type: extlang
Subtag: csd
Description: Chiangmai Sign Language
Added: 2009-07-29
Preferred-Value: csd
Prefix: sgn
%%
Type: extlang
Subtag: cse
Description: Czech Sign Language
Added: 2009-07-29
Preferred-Value: cse
Prefix: sgn
%%
Type: extlang
Subtag: csf
Description: Cuba Sign Language
Added: 2009-07-29
Preferred-Value: csf
Prefix: sgn
%%
Type: extlang
Subtag: csg
Description: Chilean Sign Language
Added: 2009-07-29
Preferred-Value: csg
Prefix: sgn
%%
Type: extlang
Subtag: csl
Description: Chinese Sign Language
Added: 2009-07-29
Preferred-Value: csl
Prefix: sgn
%%
Type: extlang
Subtag: csn
Description: Colombian Sign Language
Added: 2009-07-29
Preferred-Value: csn
Prefix: sgn
%%
Type: extlang
Subtag: csq
Description: Croatia Sign Language
Added: 2009-07-29
Preferred-Value: csq
Prefix: sgn
%%
Type: extlang
Subtag: csr
Description: Costa Rican Sign Language
Added: 2009-07-29
Preferred-Value: csr
Prefix: sgn
%%
Type: extlang
Subtag: czh
Description: Huizhou Chinese
Added: 2009-07-29
Preferred-Value: czh
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: czo
Description: Min Zhong Chinese
Added: 2009-07-29
Preferred-Value: czo
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: doq
Description: Dominican Sign Language
Added: 2009-07-29
Preferred-Value: doq
Prefix: sgn
%%
Type: extlang
Subtag: dse
Description: Dutch Sign Language
Added: 2009-07-29
Preferred-Value: dse
Prefix: sgn
%%
Type: extlang
Subtag: dsl
Description: Danish Sign Language
Added: 2009-07-29
Preferred-Value: dsl
Prefix: sgn
%%
Type: extlang
Subtag: dup
Description: Duano
Added: 2009-07-29
Preferred-Value: dup
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: ecs
Description: Ecuadorian Sign Language
Added: 2009-07-29
Preferred-Value: ecs
Prefix: sgn
%%
Type: extlang
Subtag: esl
Description: Egypt Sign Language
Added: 2009-07-29
Preferred-Value: esl
Prefix: sgn
%%
Type: extlang
Subtag: esn
Description: Salvadoran Sign Language
Added: 2009-07-29
Preferred-Value: esn
Prefix: sgn
%%
Type: extlang
Subtag: eso
Description: Estonian Sign Language
Added: 2009-07-29
Preferred-Value: eso
Prefix: sgn
%%
Type: extlang
Subtag: eth
Description: Ethiopian Sign Language
Added: 2009-07-29
Preferred-Value: eth
Prefix: sgn
%%
Type: extlang
Subtag: fcs
Description: Quebec Sign Language
Added: 2009-07-29
Preferred-Value: fcs
Prefix: sgn
%%
Type: extlang
Subtag: fse
Description: Finnish Sign Language
Added: 2009-07-29
Preferred-Value: fse
Prefix: sgn
%%
Type: extlang
Subtag: fsl
Description: French Sign Language
Added: 2009-07-29
Preferred-Value: fsl
Prefix: sgn
%%
Type: extlang
Subtag: fss
Description: Finland-Swedish Sign Language
Description: finlandssvenskt teckenspråk
Description: suomenruotsalainen viittomakieli
Added: 2009-07-29
Preferred-Value: fss
Prefix: sgn
%%
Type: extlang
Subtag: gan
Description: Gan Chinese
Added: 2009-07-29
Preferred-Value: gan
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: gds
Description: Ghandruk Sign Language
Added: 2012-08-12
Preferred-Value: gds
Prefix: sgn
%%
Type: extlang
Subtag: gom
Description: Goan Konkani
Added: 2009-07-29
Preferred-Value: gom
Prefix: kok
Macrolanguage: kok
%%
Type: extlang
Subtag: gse
Description: Ghanaian Sign Language
Added: 2009-07-29
Preferred-Value: gse
Prefix: sgn
%%
Type: extlang
Subtag: gsg
Description: German Sign Language
Added: 2009-07-29
Preferred-Value: gsg
Prefix: sgn
%%
Type: extlang
Subtag: gsm
Description: Guatemalan Sign Language
Added: 2009-07-29
Preferred-Value: gsm
Prefix: sgn
%%
Type: extlang
Subtag: gss
Description: Greek Sign Language
Added: 2009-07-29
Preferred-Value: gss
Prefix: sgn
%%
Type: extlang
Subtag: gus
Description: Guinean Sign Language
Added: 2009-07-29
Preferred-Value: gus
Prefix: sgn
%%
Type: extlang
Subtag: hab
Description: Hanoi Sign Language
Added: 2009-07-29
Preferred-Value: hab
Prefix: sgn
%%
Type: extlang
Subtag: haf
Description: Haiphong Sign Language
Added: 2009-07-29
Preferred-Value: haf
Prefix: sgn
%%
Type: extlang
Subtag: hak
Description: Hakka Chinese
Added: 2009-07-29
Preferred-Value: hak
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: hds
Description: Honduras Sign Language
Added: 2009-07-29
Preferred-Value: hds
Prefix: sgn
%%
Type: extlang
Subtag: hji
Description: Haji
Added: 2009-07-29
Preferred-Value: hji
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: hks
Description: Hong Kong Sign Language
Description: Heung Kong Sau Yue
Added: 2009-07-29
Preferred-Value: hks
Prefix: sgn
%%
Type: extlang
Subtag: hos
Description: Ho Chi Minh City Sign Language
Added: 2009-07-29
Preferred-Value: hos
Prefix: sgn
%%
Type: extlang
Subtag: hps
Description: Hawai'i Sign Language (HSL)
Description: Hawai'i Pidgin Sign Language
Added: 2009-07-29
Preferred-Value: hps
Prefix: sgn
%%
Type: extlang
Subtag: hsh
Description: Hungarian Sign Language
Added: 2009-07-29
Preferred-Value: hsh
Prefix: sgn
%%
Type: extlang
Subtag: hsl
Description: Hausa Sign Language
Added: 2009-07-29
Preferred-Value: hsl
Prefix: sgn
%%
Type: extlang
Subtag: hsn
Description: Xiang Chinese
Added: 2009-07-29
Preferred-Value: hsn
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: icl
Description: Icelandic Sign Language
Added: 2009-07-29
Preferred-Value: icl
Prefix: sgn
%%
Type: extlang
Subtag: iks
Description: Inuit Sign Language
Added: 2015-02-12
Preferred-Value: iks
Prefix: sgn
%%
Type: extlang
Subtag: ils
Description: International Sign
Added: 2009-07-29
Preferred-Value: ils
Prefix: sgn
%%
Type: extlang
Subtag: inl
Description: Indonesian Sign Language
Added: 2009-07-29
Preferred-Value: inl
Prefix: sgn
%%
Type: extlang
Subtag: ins
Description: Indian Sign Language
Added: 2009-07-29
Preferred-Value: ins
Prefix: sgn
%%
Type: extlang
Subtag: ise
Description: Italian Sign Language
Added: 2009-07-29
Preferred-Value: ise
Prefix: sgn
%%
Type: extlang
Subtag: isg
Description: Irish Sign Language
Added: 2009-07-29
Preferred-Value: isg
Prefix: sgn
%%
Type: extlang
Subtag: isr
Description: Israeli Sign Language
Added: 2009-07-29
Preferred-Value: isr
Prefix: sgn
%%
Type: extlang
Subtag: jak
Description: Jakun
Added: 2009-07-29
Preferred-Value: jak
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: jax
Description: Jambi Malay
Added: 2009-07-29
Preferred-Value: jax
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: jcs
Description: Jamaican Country Sign Language
Added: 2009-07-29
Preferred-Value: jcs
Prefix: sgn
%%
Type: extlang
Subtag: jhs
Description: Jhankot Sign Language
Added: 2009-07-29
Preferred-Value: jhs
Prefix: sgn
%%
Type: extlang
Subtag: jls
Description: Jamaican Sign Language
Added: 2010-03-11
Preferred-Value: jls
Prefix: sgn
%%
Type: extlang
Subtag: jos
Description: Jordanian Sign Language
Added: 2009-07-29
Preferred-Value: jos
Prefix: sgn
%%
Type: extlang
Subtag: jsl
Description: Japanese Sign Language
Added: 2009-07-29
Preferred-Value: jsl
Prefix: sgn
%%
Type: extlang
Subtag: jus
Description: Jumla Sign Language
Added: 2009-07-29
Preferred-Value: jus
Prefix: sgn
%%
Type: extlang
Subtag: kgi
Description: Selangor Sign Language
Added: 2009-07-29
Preferred-Value: kgi
Prefix: sgn
%%
Type: extlang
Subtag: knn
Description: Konkani (individual language)
Added: 2009-07-29
Preferred-Value: knn
Prefix: kok
Macrolanguage: kok
%%
Type: extlang
Subtag: kvb
Description: Kubu
Added: 2009-07-29
Preferred-Value: kvb
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: kvk
Description: Korean Sign Language
Added: 2009-07-29
Preferred-Value: kvk
Prefix: sgn
%%
Type: extlang
Subtag: kvr
Description: Kerinci
Added: 2009-07-29
Preferred-Value: kvr
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: kxd
Description: Brunei
Added: 2009-07-29
Preferred-Value: kxd
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: lbs
Description: Libyan Sign Language
Added: 2009-07-29
Preferred-Value: lbs
Prefix: sgn
%%
Type: extlang
Subtag: lce
Description: Loncong
Description: Sekak
Added: 2009-07-29
Preferred-Value: lce
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: lcf
Description: Lubu
Added: 2009-07-29
Preferred-Value: lcf
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: liw
Description: Col
Added: 2009-07-29
Preferred-Value: liw
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: lls
Description: Lithuanian Sign Language
Added: 2009-07-29
Preferred-Value: lls
Prefix: sgn
%%
Type: extlang
Subtag: lsg
Description: Lyons Sign Language
Added: 2009-07-29
Deprecated: 2018-03-08
Preferred-Value: lsg
Prefix: sgn
%%
Type: extlang
Subtag: lsl
Description: Latvian Sign Language
Added: 2009-07-29
Preferred-Value: lsl
Prefix: sgn
%%
Type: extlang
Subtag: lsn
Description: Tibetan Sign Language
Added: 2019-04-16
Preferred-Value: lsn
Prefix: sgn
%%
Type: extlang
Subtag: lso
Description: Laos Sign Language
Added: 2009-07-29
Preferred-Value: lso
Prefix: sgn
%%
Type: extlang
Subtag: lsp
Description: Panamanian Sign Language
Description: Lengua de Señas Panameñas
Added: 2009-07-29
Preferred-Value: lsp
Prefix: sgn
%%
Type: extlang
Subtag: lst
Description: Trinidad and Tobago Sign Language
Added: 2009-07-29
Preferred-Value: lst
Prefix: sgn
%%
Type: extlang
Subtag: lsv
Description: Sivia Sign Language
Added: 2019-04-16
Preferred-Value: lsv
Prefix: sgn
%%
Type: extlang
Subtag: lsy
Description: Mauritian Sign Language
Added: 2010-03-11
Preferred-Value: lsy
Prefix: sgn
%%
Type: extlang
Subtag: ltg
Description: Latgalian
Added: 2010-03-11
Preferred-Value: ltg
Prefix: lv
Macrolanguage: lv
%%
Type: extlang
Subtag: lvs
Description: Standard Latvian
Added: 2010-03-11
Preferred-Value: lvs
Prefix: lv
Macrolanguage: lv
%%
Type: extlang
Subtag: lws
Description: Malawian Sign Language
Added: 2018-03-08
Preferred-Value: lws
Prefix: sgn
%%
Type: extlang
Subtag: lzh
Description: Literary Chinese
Added: 2009-07-29
Preferred-Value: lzh
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: max
Description: North Moluccan Malay
Added: 2009-07-29
Preferred-Value: max
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: mdl
Description: Maltese Sign Language
Added: 2009-07-29
Preferred-Value: mdl
Prefix: sgn
%%
Type: extlang
Subtag: meo
Description: Kedah Malay
Added: 2009-07-29
Preferred-Value: meo
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: mfa
Description: Pattani Malay
Added: 2009-07-29
Preferred-Value: mfa
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: mfb
Description: Bangka
Added: 2009-07-29
Preferred-Value: mfb
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: mfs
Description: Mexican Sign Language
Added: 2009-07-29
Preferred-Value: mfs
Prefix: sgn
%%
Type: extlang
Subtag: min
Description: Minangkabau
Added: 2009-07-29
Preferred-Value: min
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: mnp
Description: Min Bei Chinese
Added: 2009-07-29
Preferred-Value: mnp
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: mqg
Description: Kota Bangun Kutai Malay
Added: 2009-07-29
Preferred-Value: mqg
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: mre
Description: Martha's Vineyard Sign Language
Added: 2009-07-29
Preferred-Value: mre
Prefix: sgn
%%
Type: extlang
Subtag: msd
Description: Yucatec Maya Sign Language
Added: 2009-07-29
Preferred-Value: msd
Prefix: sgn
%%
Type: extlang
Subtag: msi
Description: Sabah Malay
Added: 2009-07-29
Preferred-Value: msi
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: msr
Description: Mongolian Sign Language
Added: 2009-07-29
Preferred-Value: msr
Prefix: sgn
%%
Type: extlang
Subtag: mui
Description: Musi
Added: 2009-07-29
Preferred-Value: mui
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: mzc
Description: Madagascar Sign Language
Added: 2009-07-29
Preferred-Value: mzc
Prefix: sgn
%%
Type: extlang
Subtag: mzg
Description: Monastic Sign Language
Added: 2009-07-29
Preferred-Value: mzg
Prefix: sgn
%%
Type: extlang
Subtag: mzy
Description: Mozambican Sign Language
Added: 2009-07-29
Preferred-Value: mzy
Prefix: sgn
%%
Type: extlang
Subtag: nan
Description: Min Nan Chinese
Added: 2009-07-29
Preferred-Value: nan
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: nbs
Description: Namibian Sign Language
Added: 2009-07-29
Preferred-Value: nbs
Prefix: sgn
%%
Type: extlang
Subtag: ncs
Description: Nicaraguan Sign Language
Added: 2009-07-29
Preferred-Value: ncs
Prefix: sgn
%%
Type: extlang
Subtag: nsi
Description: Nigerian Sign Language
Added: 2009-07-29
Preferred-Value: nsi
Prefix: sgn
%%
Type: extlang
Subtag: nsl
Description: Norwegian Sign Language
Added: 2009-07-29
Preferred-Value: nsl
Prefix: sgn
%%
Type: extlang
Subtag: nsp
Description: Nepalese Sign Language
Added: 2009-07-29
Preferred-Value: nsp
Prefix: sgn
%%
Type: extlang
Subtag: nsr
Description: Maritime Sign Language
Added: 2009-07-29
Preferred-Value: nsr
Prefix: sgn
%%
Type: extlang
Subtag: nzs
Description: New Zealand Sign Language
Added: 2009-07-29
Preferred-Value: nzs
Prefix: sgn
%%
Type: extlang
Subtag: okl
Description: Old Kentish Sign Language
Added: 2009-07-29
Preferred-Value: okl
Prefix: sgn
%%
Type: extlang
Subtag: orn
Description: Orang Kanaq
Added: 2009-07-29
Preferred-Value: orn
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: ors
Description: Orang Seletar
Added: 2009-07-29
Preferred-Value: ors
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: pel
Description: Pekal
Added: 2009-07-29
Preferred-Value: pel
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: pga
Description: Sudanese Creole Arabic
Added: 2009-07-29
Preferred-Value: pga
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: pgz
Description: Papua New Guinean Sign Language
Added: 2016-05-30
Preferred-Value: pgz
Prefix: sgn
%%
Type: extlang
Subtag: pks
Description: Pakistan Sign Language
Added: 2009-07-29
Preferred-Value: pks
Prefix: sgn
%%
Type: extlang
Subtag: prl
Description: Peruvian Sign Language
Added: 2009-07-29
Preferred-Value: prl
Prefix: sgn
%%
Type: extlang
Subtag: prz
Description: Providencia Sign Language
Added: 2009-07-29
Preferred-Value: prz
Prefix: sgn
%%
Type: extlang
Subtag: psc
Description: Persian Sign Language
Added: 2009-07-29
Preferred-Value: psc
Prefix: sgn
%%
Type: extlang
Subtag: psd
Description: Plains Indian Sign Language
Added: 2009-07-29
Preferred-Value: psd
Prefix: sgn
%%
Type: extlang
Subtag: pse
Description: Central Malay
Added: 2009-07-29
Preferred-Value: pse
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: psg
Description: Penang Sign Language
Added: 2009-07-29
Preferred-Value: psg
Prefix: sgn
%%
Type: extlang
Subtag: psl
Description: Puerto Rican Sign Language
Added: 2009-07-29
Preferred-Value: psl
Prefix: sgn
%%
Type: extlang
Subtag: pso
Description: Polish Sign Language
Added: 2009-07-29
Preferred-Value: pso
Prefix: sgn
%%
Type: extlang
Subtag: psp
Description: Philippine Sign Language
Added: 2009-07-29
Preferred-Value: psp
Prefix: sgn
%%
Type: extlang
Subtag: psr
Description: Portuguese Sign Language
Added: 2009-07-29
Preferred-Value: psr
Prefix: sgn
%%
Type: extlang
Subtag: pys
Description: Paraguayan Sign Language
Description: Lengua de Señas del Paraguay
Added: 2010-03-11
Preferred-Value: pys
Prefix: sgn
%%
Type: extlang
Subtag: rms
Description: Romanian Sign Language
Added: 2009-07-29
Preferred-Value: rms
Prefix: sgn
%%
Type: extlang
Subtag: rsi
Description: Rennellese Sign Language
Added: 2009-07-29
Deprecated: 2017-02-23
Preferred-Value: rsi
Prefix: sgn
%%
Type: extlang
Subtag: rsl
Description: Russian Sign Language
Added: 2009-07-29
Preferred-Value: rsl
Prefix: sgn
%%
Type: extlang
Subtag: rsm
Description: Miriwoong Sign Language
Added: 2016-05-30
Preferred-Value: rsm
Prefix: sgn
%%
Type: extlang
Subtag: sdl
Description: Saudi Arabian Sign Language
Added: 2009-07-29
Preferred-Value: sdl
Prefix: sgn
%%
Type: extlang
Subtag: sfb
Description: Langue des signes de Belgique Francophone
Description: French Belgian Sign Language
Added: 2009-07-29
Preferred-Value: sfb
Prefix: sgn
%%
Type: extlang
Subtag: sfs
Description: South African Sign Language
Added: 2009-07-29
Preferred-Value: sfs
Prefix: sgn
%%
Type: extlang
Subtag: sgg
Description: Swiss-German Sign Language
Added: 2009-07-29
Preferred-Value: sgg
Prefix: sgn
%%
Type: extlang
Subtag: sgx
Description: Sierra Leone Sign Language
Added: 2009-07-29
Preferred-Value: sgx
Prefix: sgn
%%
Type: extlang
Subtag: shu
Description: Chadian Arabic
Added: 2009-07-29
Preferred-Value: shu
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: slf
Description: Swiss-Italian Sign Language
Added: 2009-07-29
Preferred-Value: slf
Prefix: sgn
%%
Type: extlang
Subtag: sls
Description: Singapore Sign Language
Added: 2009-07-29
Preferred-Value: sls
Prefix: sgn
%%
Type: extlang
Subtag: sqk
Description: Albanian Sign Language
Added: 2012-08-12
Preferred-Value: sqk
Prefix: sgn
%%
Type: extlang
Subtag: sqs
Description: Sri Lankan Sign Language
Added: 2009-07-29
Preferred-Value: sqs
Prefix: sgn
%%
Type: extlang
Subtag: ssh
Description: Shihhi Arabic
Added: 2009-07-29
Preferred-Value: ssh
Prefix: ar
Macrolanguage: ar
%%
Type: extlang
Subtag: ssp
Description: Spanish Sign Language
Added: 2009-07-29
Preferred-Value: ssp
Prefix: sgn
%%
Type: extlang
Subtag: ssr
Description: Swiss-French Sign Language
Added: 2009-07-29
Preferred-Value: ssr
Prefix: sgn
%%
Type: extlang
Subtag: svk
Description: Slovakian Sign Language
Added: 2009-07-29
Preferred-Value: svk
Prefix: sgn
%%
Type: extlang
Subtag: swc
Description: Congo Swahili
Added: 2009-07-29
Preferred-Value: swc
Prefix: sw
Macrolanguage: sw
%%
Type: extlang
Subtag: swh
Description: Swahili (individual language)
Description: Kiswahili
Added: 2009-07-29
Preferred-Value: swh
Prefix: sw
Macrolanguage: sw
%%
Type: extlang
Subtag: swl
Description: Swedish Sign Language
Added: 2009-07-29
Preferred-Value: swl
Prefix: sgn
%%
Type: extlang
Subtag: syy
Description: Al-Sayyid Bedouin Sign Language
Added: 2009-07-29
Preferred-Value: syy
Prefix: sgn
%%
Type: extlang
Subtag: szs
Description: Solomon Islands Sign Language
Added: 2017-02-23
Preferred-Value: szs
Prefix: sgn
%%
Type: extlang
Subtag: tmw
Description: Temuan
Added: 2009-07-29
Preferred-Value: tmw
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: tse
Description: Tunisian Sign Language
Added: 2009-07-29
Preferred-Value: tse
Prefix: sgn
%%
Type: extlang
Subtag: tsm
Description: Turkish Sign Language
Description: Türk İşaret Dili
Added: 2009-07-29
Preferred-Value: tsm
Prefix: sgn
%%
Type: extlang
Subtag: tsq
Description: Thai Sign Language
Added: 2009-07-29
Preferred-Value: tsq
Prefix: sgn
%%
Type: extlang
Subtag: tss
Description: Taiwan Sign Language
Added: 2009-07-29
Preferred-Value: tss
Prefix: sgn
%%
Type: extlang
Subtag: tsy
Description: Tebul Sign Language
Added: 2009-07-29
Preferred-Value: tsy
Prefix: sgn
%%
Type: extlang
Subtag: tza
Description: Tanzanian Sign Language
Added: 2009-07-29
Preferred-Value: tza
Prefix: sgn
%%
Type: extlang
Subtag: ugn
Description: Ugandan Sign Language
Added: 2009-07-29
Preferred-Value: ugn
Prefix: sgn
%%
Type: extlang
Subtag: ugy
Description: Uruguayan Sign Language
Added: 2009-07-29
Preferred-Value: ugy
Prefix: sgn
%%
Type: extlang
Subtag: ukl
Description: Ukrainian Sign Language
Added: 2009-07-29
Preferred-Value: ukl
Prefix: sgn
%%
Type: extlang
Subtag: uks
Description: Urubú-Kaapor Sign Language
Description: Kaapor Sign Language
Added: 2009-07-29
Preferred-Value: uks
Prefix: sgn
%%
Type: extlang
Subtag: urk
Description: Urak Lawoi'
Added: 2009-07-29
Preferred-Value: urk
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: uzn
Description: Northern Uzbek
Added: 2009-07-29
Preferred-Value: uzn
Prefix: uz
Macrolanguage: uz
%%
Type: extlang
Subtag: uzs
Description: Southern Uzbek
Added: 2009-07-29
Preferred-Value: uzs
Prefix: uz
Macrolanguage: uz
%%
Type: extlang
Subtag: vgt
Description: Vlaamse Gebarentaal
Description: Flemish Sign Language
Added: 2009-07-29
Preferred-Value: vgt
Prefix: sgn
%%
Type: extlang
Subtag: vkk
Description: Kaur
Added: 2009-07-29
Preferred-Value: vkk
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: vkt
Description: Tenggarong Kutai Malay
Added: 2009-07-29
Preferred-Value: vkt
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: vsi
Description: Moldova Sign Language
Added: 2009-07-29
Preferred-Value: vsi
Prefix: sgn
%%
Type: extlang
Subtag: vsl
Description: Venezuelan Sign Language
Added: 2009-07-29
Preferred-Value: vsl
Prefix: sgn
%%
Type: extlang
Subtag: vsv
Description: Valencian Sign Language
Description: Llengua de signes valenciana
Added: 2009-07-29
Preferred-Value: vsv
Prefix: sgn
%%
Type: extlang
Subtag: wbs
Description: West Bengal Sign Language
Added: 2017-02-23
Preferred-Value: wbs
Prefix: sgn
%%
Type: extlang
Subtag: wuu
Description: Wu Chinese
Added: 2009-07-29
Preferred-Value: wuu
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: xki
Description: Kenyan Sign Language
Added: 2009-07-29
Preferred-Value: xki
Prefix: sgn
%%
Type: extlang
Subtag: xml
Description: Malaysian Sign Language
Added: 2009-07-29
Preferred-Value: xml
Prefix: sgn
%%
Type: extlang
Subtag: xmm
Description: Manado Malay
Added: 2009-07-29
Preferred-Value: xmm
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: xms
Description: Moroccan Sign Language
Added: 2009-07-29
Preferred-Value: xms
Prefix: sgn
%%
Type: extlang
Subtag: yds
Description: Yiddish Sign Language
Added: 2009-07-29
Deprecated: 2015-02-12
Preferred-Value: yds
Prefix: sgn
%%
Type: extlang
Subtag: ygs
Description: Yolŋu Sign Language
Added: 2014-02-28
Preferred-Value: ygs
Prefix: sgn
%%
Type: extlang
Subtag: yhs
Description: Yan-nhaŋu Sign Language
Added: 2015-04-17
Preferred-Value: yhs
Prefix: sgn
%%
Type: extlang
Subtag: ysl
Description: Yugoslavian Sign Language
Added: 2009-07-29
Preferred-Value: ysl
Prefix: sgn
%%
Type: extlang
Subtag: yue
Description: Yue Chinese
Description: Cantonese
Added: 2009-07-29
Preferred-Value: yue
Prefix: zh
Macrolanguage: zh
%%
Type: extlang
Subtag: zib
Description: Zimbabwe Sign Language
Added: 2009-07-29
Preferred-Value: zib
Prefix: sgn
%%
Type: extlang
Subtag: zlm
Description: Malay (individual language)
Added: 2009-07-29
Preferred-Value: zlm
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: zmi
Description: Negeri Sembilan Malay
Added: 2009-07-29
Preferred-Value: zmi
Prefix: ms
Macrolanguage: ms
%%
Type: extlang
Subtag: zsl
Description: Zambian Sign Language
Added: 2009-07-29
Preferred-Value: zsl
Prefix: sgn
%%
Type: extlang
Subtag: zsm
Description: Standard Malay
Added: 2009-07-29
Preferred-Value: zsm
Prefix: ms
Macrolanguage: ms
%%
Type: script
Subtag: Adlm
Description: Adlam
Added: 2014-12-11
%%
Type: script
Subtag: Afak
Description: Afaka
Added: 2011-01-07
%%
Type: script
Subtag: Aghb
Description: Caucasian Albanian
Added: 2012-11-01
%%
Type: script
Subtag: Ahom
Description: Ahom
Description: Tai Ahom
Added: 2013-12-02
%%
Type: script
Subtag: Arab
Description: Arabic
Added: 2005-10-16
%%
Type: script
Subtag: Aran
Description: Arabic (Nastaliq variant)
Added: 2014-12-11
%%
Type: script
Subtag: Armi
Description: Imperial Aramaic
Added: 2007-12-05
%%
Type: script
Subtag: Armn
Description: Armenian
Added: 2005-10-16
%%
Type: script
Subtag: Avst
Description: Avestan
Added: 2007-07-28
%%
Type: script
Subtag: Bali
Description: Balinese
Added: 2005-10-16
%%
Type: script
Subtag: Bamu
Description: Bamum
Added: 2009-07-30
%%
Type: script
Subtag: Bass
Description: Bassa Vah
Added: 2010-04-10
%%
Type: script
Subtag: Batk
Description: Batak
Added: 2005-10-16
%%
Type: script
Subtag: Beng
Description: Bengali
Description: Bangla
Added: 2005-10-16
%%
Type: script
Subtag: Bhks
Description: Bhaiksuki
Added: 2015-07-24
%%
Type: script
Subtag: Blis
Description: Blissymbols
Added: 2005-10-16
%%
Type: script
Subtag: Bopo
Description: Bopomofo
Added: 2005-10-16
%%
Type: script
Subtag: Brah
Description: Brahmi
Added: 2005-10-16
%%
Type: script
Subtag: Brai
Description: Braille
Added: 2005-10-16
%%
Type: script
Subtag: Bugi
Description: Buginese
Added: 2005-10-16
%%
Type: script
Subtag: Buhd
Description: Buhid
Added: 2005-10-16
%%
Type: script
Subtag: Cakm
Description: Chakma
Added: 2007-12-05
%%
Type: script
Subtag: Cans
Description: Unified Canadian Aboriginal Syllabics
Added: 2005-10-16
%%
Type: script
Subtag: Cari
Description: Carian
Added: 2006-07-21
%%
Type: script
Subtag: Cham
Description: Cham
Added: 2005-10-16
%%
Type: script
Subtag: Cher
Description: Cherokee
Added: 2005-10-16
%%
Type: script
Subtag: Chrs
Description: Chorasmian
Added: 2019-09-11
%%
Type: script
Subtag: Cirt
Description: Cirth
Added: 2005-10-16
%%
Type: script
Subtag: Copt
Description: Coptic
Added: 2005-10-16
%%
Type: script
Subtag: Cpmn
Description: Cypro-Minoan
Added: 2017-08-13
%%
Type: script
Subtag: Cprt
Description: Cypriot syllabary
Added: 2005-10-16
%%
Type: script
Subtag: Cyrl
Description: Cyrillic
Added: 2005-10-16
%%
Type: script
Subtag: Cyrs
Description: Cyrillic (Old Church Slavonic variant)
Added: 2005-10-16
%%
Type: script
Subtag: Deva
Description: Devanagari
Description: Nagari
Added: 2005-10-16
%%
Type: script
Subtag: Diak
Description: Dives Akuru
Added: 2019-09-11
%%
Type: script
Subtag: Dogr
Description: Dogra
Added: 2017-01-13
%%
Type: script
Subtag: Dsrt
Description: Deseret
Description: Mormon
Added: 2005-10-16
%%
Type: script
Subtag: Dupl
Description: Duployan shorthand
Description: Duployan stenography
Added: 2010-08-16
%%
Type: script
Subtag: Egyd
Description: Egyptian demotic
Added: 2005-10-16
%%
Type: script
Subtag: Egyh
Description: Egyptian hieratic
Added: 2005-10-16
%%
Type: script
Subtag: Egyp
Description: Egyptian hieroglyphs
Added: 2005-10-16
%%
Type: script
Subtag: Elba
Description: Elbasan
Added: 2010-08-16
%%
Type: script
Subtag: Elym
Description: Elymaic
Added: 2018-10-28
%%
Type: script
Subtag: Ethi
Description: Ethiopic
Description: Geʻez
Description: Ge'ez
Added: 2005-10-16
%%
Type: script
Subtag: Geok
Description: Khutsuri (Asomtavruli and Nuskhuri)
Added: 2005-10-16
%%
Type: script
Subtag: Geor
Description: Georgian (Mkhedruli and Mtavruli)
Added: 2005-10-16
%%
Type: script
Subtag: Glag
Description: Glagolitic
Added: 2005-10-16
%%
Type: script
Subtag: Gong
Description: Gunjala Gondi
Added: 2017-01-13
%%
Type: script
Subtag: Gonm
Description: Masaram Gondi
Added: 2017-01-13
%%
Type: script
Subtag: Goth
Description: Gothic
Added: 2005-10-16
%%
Type: script
Subtag: Gran
Description: Grantha
Added: 2009-12-09
%%
Type: script
Subtag: Grek
Description: Greek
Added: 2005-10-16
%%
Type: script
Subtag: Gujr
Description: Gujarati
Added: 2005-10-16
%%
Type: script
Subtag: Guru
Description: Gurmukhi
Added: 2005-10-16
%%
Type: script
Subtag: Hanb
Description: Han with Bopomofo (alias for Han + Bopomofo)
Added: 2016-02-08
%%
Type: script
Subtag: Hang
Description: Hangul
Description: Hangŭl
Description: Hangeul
Added: 2005-10-16
%%
Type: script
Subtag: Hani
Description: Han
Description: Hanzi
Description: Kanji
Description: Hanja
Added: 2005-10-16
%%
Type: script
Subtag: Hano
Description: Hanunoo
Description: Hanunóo
Added: 2005-10-16
%%
Type: script
Subtag: Hans
Description: Han (Simplified variant)
Added: 2005-10-16
%%
Type: script
Subtag: Hant
Description: Han (Traditional variant)
Added: 2005-10-16
%%
Type: script
Subtag: Hatr
Description: Hatran
Added: 2013-12-02
%%
Type: script
Subtag: Hebr
Description: Hebrew
Added: 2005-10-16
%%
Type: script
Subtag: Hira
Description: Hiragana
Added: 2005-10-16
%%
Type: script
Subtag: Hluw
Description: Anatolian Hieroglyphs
Description: Luwian Hieroglyphs
Description: Hittite Hieroglyphs
Added: 2011-12-28
%%
Type: script
Subtag: Hmng
Description: Pahawh Hmong
Added: 2005-10-16
%%
Type: script
Subtag: Hmnp
Description: Nyiakeng Puachue Hmong
Added: 2017-08-13
%%
Type: script
Subtag: Hrkt
Description: Japanese syllabaries (alias for Hiragana + Katakana)
Added: 2005-10-16
%%
Type: script
Subtag: Hung
Description: Old Hungarian
Description: Hungarian Runic
Added: 2005-10-16
%%
Type: script
Subtag: Inds
Description: Indus
Description: Harappan
Added: 2005-10-16
%%
Type: script
Subtag: Ital
Description: Old Italic (Etruscan, Oscan, etc.)
Added: 2005-10-16
%%
Type: script
Subtag: Jamo
Description: Jamo (alias for Jamo subset of Hangul)
Added: 2016-02-08
%%
Type: script
Subtag: Java
Description: Javanese
Added: 2005-10-16
%%
Type: script
Subtag: Jpan
Description: Japanese (alias for Han + Hiragana + Katakana)
Added: 2006-07-21
%%
Type: script
Subtag: Jurc
Description: Jurchen
Added: 2011-01-07
%%
Type: script
Subtag: Kali
Description: Kayah Li
Added: 2005-10-16
%%
Type: script
Subtag: Kana
Description: Katakana
Added: 2005-10-16
%%
Type: script
Subtag: Khar
Description: Kharoshthi
Added: 2005-10-16
%%
Type: script
Subtag: Khmr
Description: Khmer
Added: 2005-10-16
%%
Type: script
Subtag: Khoj
Description: Khojki
Added: 2011-08-16
%%
Type: script
Subtag: Kitl
Description: Khitan large script
Added: 2014-12-11
%%
Type: script
Subtag: Kits
Description: Khitan small script
Added: 2014-12-11
%%
Type: script
Subtag: Knda
Description: Kannada
Added: 2005-10-16
%%
Type: script
Subtag: Kore
Description: Korean (alias for Hangul + Han)
Added: 2007-07-05
%%
Type: script
Subtag: Kpel
Description: Kpelle
Added: 2010-04-10
%%
Type: script
Subtag: Kthi
Description: Kaithi
Added: 2007-12-05
%%
Type: script
Subtag: Lana
Description: Tai Tham
Description: Lanna
Added: 2006-07-21
%%
Type: script
Subtag: Laoo
Description: Lao
Added: 2005-10-16
%%
Type: script
Subtag: Latf
Description: Latin (Fraktur variant)
Added: 2005-10-16
%%
Type: script
Subtag: Latg
Description: Latin (Gaelic variant)
Added: 2005-10-16
%%
Type: script
Subtag: Latn
Description: Latin
Added: 2005-10-16
%%
Type: script
Subtag: Leke
Description: Leke
Added: 2015-07-24
%%
Type: script
Subtag: Lepc
Description: Lepcha
Description: Róng
Added: 2005-10-16
%%
Type: script
Subtag: Limb
Description: Limbu
Added: 2005-10-16
%%
Type: script
Subtag: Lina
Description: Linear A
Added: 2005-10-16
%%
Type: script
Subtag: Linb
Description: Linear B
Added: 2005-10-16
%%
Type: script
Subtag: Lisu
Description: Lisu
Description: Fraser
Added: 2009-03-13
%%
Type: script
Subtag: Loma
Description: Loma
Added: 2010-04-10
%%
Type: script
Subtag: Lyci
Description: Lycian
Added: 2006-07-21
%%
Type: script
Subtag: Lydi
Description: Lydian
Added: 2006-07-21
%%
Type: script
Subtag: Mahj
Description: Mahajani
Added: 2012-11-01
%%
Type: script
Subtag: Maka
Description: Makasar
Added: 2017-01-13
%%
Type: script
Subtag: Mand
Description: Mandaic
Description: Mandaean
Added: 2005-10-16
%%
Type: script
Subtag: Mani
Description: Manichaean
Added: 2007-07-28
%%
Type: script
Subtag: Marc
Description: Marchen
Added: 2014-12-11
%%
Type: script
Subtag: Maya
Description: Mayan hieroglyphs
Added: 2005-10-16
%%
Type: script
Subtag: Medf
Description: Medefaidrin
Description: Oberi Okaime
Description: Oberi Ɔkaimɛ
Added: 2017-01-13
%%
Type: script
Subtag: Mend
Description: Mende Kikakui
Added: 2010-04-10
%%
Type: script
Subtag: Merc
Description: Meroitic Cursive
Added: 2009-12-09
%%
Type: script
Subtag: Mero
Description: Meroitic Hieroglyphs
Added: 2005-10-16
%%
Type: script
Subtag: Mlym
Description: Malayalam
Added: 2005-10-16
%%
Type: script
Subtag: Modi
Description: Modi
Description: Moḍī
Added: 2013-12-02
%%
Type: script
Subtag: Mong
Description: Mongolian
Added: 2005-10-16
%%
Type: script
Subtag: Moon
Description: Moon
Description: Moon code
Description: Moon script
Description: Moon type
Added: 2007-01-26
%%
Type: script
Subtag: Mroo
Description: Mro
Description: Mru
Added: 2011-01-07
%%
Type: script
Subtag: Mtei
Description: Meitei Mayek
Description: Meithei
Description: Meetei
Added: 2007-01-26
%%
Type: script
Subtag: Mult
Description: Multani
Added: 2013-12-02
%%
Type: script
Subtag: Mymr
Description: Myanmar
Description: Burmese
Added: 2005-10-16
%%
Type: script
Subtag: Nand
Description: Nandinagari
Added: 2018-10-28
%%
Type: script
Subtag: Narb
Description: Old North Arabian
Description: Ancient North Arabian
Added: 2010-04-10
%%
Type: script
Subtag: Nbat
Description: Nabataean
Added: 2010-04-10
%%
Type: script
Subtag: Newa
Description: Newa
Description: Newar
Description: Newari
Description: Nepāla lipi
Added: 2016-01-04
%%
Type: script
Subtag: Nkdb
Description: Naxi Dongba
Description: na²¹ɕi³³ to³³ba²¹
Description: Nakhi Tomba
Added: 2017-08-13
%%
Type: script
Subtag: Nkgb
Description: Naxi Geba
Description: na²¹ɕi³³ gʌ²¹ba²¹
Description: 'Na-'Khi ²Ggŏ-¹baw
Description: Nakhi Geba
Added: 2009-03-13
%%
Type: script
Subtag: Nkoo
Description: N’Ko
Description: N'Ko
Added: 2005-10-16
%%
Type: script
Subtag: Nshu
Description: Nüshu
Added: 2011-01-07
%%
Type: script
Subtag: Ogam
Description: Ogham
Added: 2005-10-16
%%
Type: script
Subtag: Olck
Description: Ol Chiki
Description: Ol Cemet'
Description: Ol
Description: Santali
Added: 2006-07-21
%%
Type: script
Subtag: Orkh
Description: Old Turkic
Description: Orkhon Runic
Added: 2009-07-30
%%
Type: script
Subtag: Orya
Description: Oriya
Description: Odia
Added: 2005-10-16
%%
Type: script
Subtag: Osge
Description: Osage
Added: 2014-12-11
%%
Type: script
Subtag: Osma
Description: Osmanya
Added: 2005-10-16
%%
Type: script
Subtag: Palm
Description: Palmyrene
Added: 2010-04-10
%%
Type: script
Subtag: Pauc
Description: Pau Cin Hau
Added: 2013-12-02
%%
Type: script
Subtag: Perm
Description: Old Permic
Added: 2005-10-16
%%
Type: script
Subtag: Phag
Description: Phags-pa
Added: 2005-10-16
%%
Type: script
Subtag: Phli
Description: Inscriptional Pahlavi
Added: 2007-12-05
%%
Type: script
Subtag: Phlp
Description: Psalter Pahlavi
Added: 2007-12-05
%%
Type: script
Subtag: Phlv
Description: Book Pahlavi
Added: 2007-07-28
%%
Type: script
Subtag: Phnx
Description: Phoenician
Added: 2005-10-16
%%
Type: script
Subtag: Piqd
Description: Klingon (KLI pIqaD)
Added: 2016-01-04
%%
Type: script
Subtag: Plrd
Description: Miao
Description: Pollard
Added: 2005-10-16
%%
Type: script
Subtag: Prti
Description: Inscriptional Parthian
Added: 2007-12-05
%%
Type: script
Subtag: Qaaa..Qabx
Description: Private use
Added: 2005-10-16
%%
Type: script
Subtag: Rjng
Description: Rejang
Description: Redjang
Description: Kaganga
Added: 2006-10-17
%%
Type: script
Subtag: Rohg
Description: Hanifi Rohingya
Added: 2017-12-13
%%
Type: script
Subtag: Roro
Description: Rongorongo
Added: 2005-10-16
%%
Type: script
Subtag: Runr
Description: Runic
Added: 2005-10-16
%%
Type: script
Subtag: Samr
Description: Samaritan
Added: 2007-07-28
%%
Type: script
Subtag: Sara
Description: Sarati
Added: 2005-10-16
%%
Type: script
Subtag: Sarb
Description: Old South Arabian
Added: 2009-07-30
%%
Type: script
Subtag: Saur
Description: Saurashtra
Added: 2006-07-21
%%
Type: script
Subtag: Sgnw
Description: SignWriting
Added: 2006-10-17
%%
Type: script
Subtag: Shaw
Description: Shavian
Description: Shaw
Added: 2005-10-16
%%
Type: script
Subtag: Shrd
Description: Sharada
Description: Śāradā
Added: 2011-01-07
%%
Type: script
Subtag: Shui
Description: Shuishu
Added: 2017-08-13
%%
Type: script
Subtag: Sidd
Description: Siddham
Description: Siddhaṃ
Description: Siddhamātṛkā
Added: 2013-12-02
%%
Type: script
Subtag: Sind
Description: Khudawadi
Description: Sindhi
Added: 2010-08-16
%%
Type: script
Subtag: Sinh
Description: Sinhala
Added: 2005-10-16
%%
Type: script
Subtag: Sogd
Description: Sogdian
Added: 2017-12-13
%%
Type: script
Subtag: Sogo
Description: Old Sogdian
Added: 2017-12-13
%%
Type: script
Subtag: Sora
Description: Sora Sompeng
Added: 2011-01-07
%%
Type: script
Subtag: Soyo
Description: Soyombo
Added: 2017-01-13
%%
Type: script
Subtag: Sund
Description: Sundanese
Added: 2006-07-21
%%
Type: script
Subtag: Sylo
Description: Syloti Nagri
Added: 2005-10-16
%%
Type: script
Subtag: Syrc
Description: Syriac
Added: 2005-10-16
%%
Type: script
Subtag: Syre
Description: Syriac (Estrangelo variant)
Added: 2005-10-16
%%
Type: script
Subtag: Syrj
Description: Syriac (Western variant)
Added: 2005-10-16
%%
Type: script
Subtag: Syrn
Description: Syriac (Eastern variant)
Added: 2005-10-16
%%
Type: script
Subtag: Tagb
Description: Tagbanwa
Added: 2005-10-16
%%
Type: script
Subtag: Takr
Description: Takri
Description: Ṭākrī
Description: Ṭāṅkrī
Added: 2011-01-07
%%
Type: script
Subtag: Tale
Description: Tai Le
Added: 2005-10-16
%%
Type: script
Subtag: Talu
Description: New Tai Lue
Added: 2005-10-16
%%
Type: script
Subtag: Taml
Description: Tamil
Added: 2005-10-16
%%
Type: script
Subtag: Tang
Description: Tangut
Added: 2011-01-07
%%
Type: script
Subtag: Tavt
Description: Tai Viet
Added: 2007-12-05
%%
Type: script
Subtag: Telu
Description: Telugu
Added: 2005-10-16
%%
Type: script
Subtag: Teng
Description: Tengwar
Added: 2005-10-16
%%
Type: script
Subtag: Tfng
Description: Tifinagh
Description: Berber
Added: 2005-10-16
%%
Type: script
Subtag: Tglg
Description: Tagalog
Description: Baybayin
Description: Alibata
Added: 2005-10-16
%%
Type: script
Subtag: Thaa
Description: Thaana
Added: 2005-10-16
%%
Type: script
Subtag: Thai
Description: Thai
Added: 2005-10-16
%%
Type: script
Subtag: Tibt
Description: Tibetan
Added: 2005-10-16
%%
Type: script
Subtag: Tirh
Description: Tirhuta
Added: 2011-08-16
%%
Type: script
Subtag: Ugar
Description: Ugaritic
Added: 2005-10-16
%%
Type: script
Subtag: Vaii
Description: Vai
Added: 2005-10-16
%%
Type: script
Subtag: Visp
Description: Visible Speech
Added: 2005-10-16
%%
Type: script
Subtag: Wara
Description: Warang Citi
Description: Varang Kshiti
Added: 2009-12-09
%%
Type: script
Subtag: Wcho
Description: Wancho
Added: 2017-08-13
%%
Type: script
Subtag: Wole
Description: Woleai
Added: 2011-01-07
%%
Type: script
Subtag: Xpeo
Description: Old Persian
Added: 2005-10-16
%%
Type: script
Subtag: Xsux
Description: Sumero-Akkadian cuneiform
Added: 2005-10-16
%%
Type: script
Subtag: Yezi
Description: Yezidi
Added: 2019-09-11
%%
Type: script
Subtag: Yiii
Description: Yi
Added: 2005-10-16
%%
Type: script
Subtag: Zanb
Description: Zanabazar Square
Description: Zanabazarin Dörböljin Useg
Description: Xewtee Dörböljin Bicig
Description: Horizontal Square Script
Added: 2017-01-13
%%
Type: script
Subtag: Zinh
Description: Code for inherited script
Added: 2009-04-03
Comments: Not intended for use as a language subtag
%%
Type: script
Subtag: Zmth
Description: Mathematical notation
Added: 2007-12-05
%%
Type: script
Subtag: Zsye
Description: Symbols (Emoji variant)
Added: 2016-01-04
%%
Type: script
Subtag: Zsym
Description: Symbols
Added: 2007-12-05
%%
Type: script
Subtag: Zxxx
Description: Code for unwritten documents
Added: 2005-10-16
%%
Type: script
Subtag: Zyyy
Description: Code for undetermined script
Added: 2005-10-16
%%
Type: script
Subtag: Zzzz
Description: Code for uncoded script
Added: 2005-10-16
%%
Type: region
Subtag: AA
Description: Private use
Added: 2005-10-16
%%
Type: region
Subtag: AC
Description: Ascension Island
Added: 2009-07-29
%%
Type: region
Subtag: AD
Description: Andorra
Added: 2005-10-16
%%
Type: region
Subtag: AE
Description: United Arab Emirates
Added: 2005-10-16
%%
Type: region
Subtag: AF
Description: Afghanistan
Added: 2005-10-16
%%
Type: region
Subtag: AG
Description: Antigua and Barbuda
Added: 2005-10-16
%%
Type: region
Subtag: AI
Description: Anguilla
Added: 2005-10-16
%%
Type: region
Subtag: AL
Description: Albania
Added: 2005-10-16
%%
Type: region
Subtag: AM
Description: Armenia
Added: 2005-10-16
%%
Type: region
Subtag: AN
Description: Netherlands Antilles
Added: 2005-10-16
Deprecated: 2011-01-07
Comments: see BQ, CW, and SX
%%
Type: region
Subtag: AO
Description: Angola
Added: 2005-10-16
%%
Type: region
Subtag: AQ
Description: Antarctica
Added: 2005-10-16
%%
Type: region
Subtag: AR
Description: Argentina
Added: 2005-10-16
%%
Type: region
Subtag: AS
Description: American Samoa
Added: 2005-10-16
%%
Type: region
Subtag: AT
Description: Austria
Added: 2005-10-16
%%
Type: region
Subtag: AU
Description: Australia
Added: 2005-10-16
%%
Type: region
Subtag: AW
Description: Aruba
Added: 2005-10-16
%%
Type: region
Subtag: AX
Description: Åland Islands
Added: 2005-10-16
%%
Type: region
Subtag: AZ
Description: Azerbaijan
Added: 2005-10-16
%%
Type: region
Subtag: BA
Description: Bosnia and Herzegovina
Added: 2005-10-16
%%
Type: region
Subtag: BB
Description: Barbados
Added: 2005-10-16
%%
Type: region
Subtag: BD
Description: Bangladesh
Added: 2005-10-16
%%
Type: region
Subtag: BE
Description: Belgium
Added: 2005-10-16
%%
Type: region
Subtag: BF
Description: Burkina Faso
Added: 2005-10-16
%%
Type: region
Subtag: BG
Description: Bulgaria
Added: 2005-10-16
%%
Type: region
Subtag: BH
Description: Bahrain
Added: 2005-10-16
%%
Type: region
Subtag: BI
Description: Burundi
Added: 2005-10-16
%%
Type: region
Subtag: BJ
Description: Benin
Added: 2005-10-16
%%
Type: region
Subtag: BL
Description: Saint Barthélemy
Added: 2007-11-02
%%
Type: region
Subtag: BM
Description: Bermuda
Added: 2005-10-16
%%
Type: region
Subtag: BN
Description: Brunei Darussalam
Added: 2005-10-16
%%
Type: region
Subtag: BO
Description: Bolivia
Added: 2005-10-16
%%
Type: region
Subtag: BQ
Description: Bonaire, Sint Eustatius and Saba
Added: 2011-01-07
%%
Type: region
Subtag: BR
Description: Brazil
Added: 2005-10-16
%%
Type: region
Subtag: BS
Description: Bahamas
Added: 2005-10-16
%%
Type: region
Subtag: BT
Description: Bhutan
Added: 2005-10-16
%%
Type: region
Subtag: BU
Description: Burma
Added: 2005-10-16
Deprecated: 1989-12-05
Preferred-Value: MM
%%
Type: region
Subtag: BV
Description: Bouvet Island
Added: 2005-10-16
%%
Type: region
Subtag: BW
Description: Botswana
Added: 2005-10-16
%%
Type: region
Subtag: BY
Description: Belarus
Added: 2005-10-16
%%
Type: region
Subtag: BZ
Description: Belize
Added: 2005-10-16
%%
Type: region
Subtag: CA
Description: Canada
Added: 2005-10-16
%%
Type: region
Subtag: CC
Description: Cocos (Keeling) Islands
Added: 2005-10-16
%%
Type: region
Subtag: CD
Description: The Democratic Republic of the Congo
Added: 2005-10-16
%%
Type: region
Subtag: CF
Description: Central African Republic
Added: 2005-10-16
%%
Type: region
Subtag: CG
Description: Congo
Added: 2005-10-16
%%
Type: region
Subtag: CH
Description: Switzerland
Added: 2005-10-16
%%
Type: region
Subtag: CI
Description: Côte d'Ivoire
Added: 2005-10-16
%%
Type: region
Subtag: CK
Description: Cook Islands
Added: 2005-10-16
%%
Type: region
Subtag: CL
Description: Chile
Added: 2005-10-16
%%
Type: region
Subtag: CM
Description: Cameroon
Added: 2005-10-16
%%
Type: region
Subtag: CN
Description: China
Added: 2005-10-16
%%
Type: region
Subtag: CO
Description: Colombia
Added: 2005-10-16
%%
Type: region
Subtag: CP
Description: Clipperton Island
Added: 2009-07-29
%%
Type: region
Subtag: CR
Description: Costa Rica
Added: 2005-10-16
%%
Type: region
Subtag: CS
Description: Serbia and Montenegro
Added: 2005-10-16
Deprecated: 2006-10-05
Comments: see RS for Serbia or ME for Montenegro
%%
Type: region
Subtag: CU
Description: Cuba
Added: 2005-10-16
%%
Type: region
Subtag: CV
Description: Cabo Verde
Description: Cape Verde
Added: 2005-10-16
%%
Type: region
Subtag: CW
Description: Curaçao
Added: 2011-01-07
%%
Type: region
Subtag: CX
Description: Christmas Island
Added: 2005-10-16
%%
Type: region
Subtag: CY
Description: Cyprus
Added: 2005-10-16
%%
Type: region
Subtag: CZ
Description: Czechia
Description: Czech Republic
Added: 2005-10-16
%%
Type: region
Subtag: DD
Description: German Democratic Republic
Added: 2005-10-16
Deprecated: 1990-10-30
Preferred-Value: DE
%%
Type: region
Subtag: DE
Description: Germany
Added: 2005-10-16
%%
Type: region
Subtag: DG
Description: Diego Garcia
Added: 2009-07-29
%%
Type: region
Subtag: DJ
Description: Djibouti
Added: 2005-10-16
%%
Type: region
Subtag: DK
Description: Denmark
Added: 2005-10-16
%%
Type: region
Subtag: DM
Description: Dominica
Added: 2005-10-16
%%
Type: region
Subtag: DO
Description: Dominican Republic
Added: 2005-10-16
%%
Type: region
Subtag: DZ
Description: Algeria
Added: 2005-10-16
%%
Type: region
Subtag: EA
Description: Ceuta, Melilla
Added: 2009-07-29
%%
Type: region
Subtag: EC
Description: Ecuador
Added: 2005-10-16
%%
Type: region
Subtag: EE
Description: Estonia
Added: 2005-10-16
%%
Type: region
Subtag: EG
Description: Egypt
Added: 2005-10-16
%%
Type: region
Subtag: EH
Description: Western Sahara
Added: 2005-10-16
%%
Type: region
Subtag: ER
Description: Eritrea
Added: 2005-10-16
%%
Type: region
Subtag: ES
Description: Spain
Added: 2005-10-16
%%
Type: region
Subtag: ET
Description: Ethiopia
Added: 2005-10-16
%%
Type: region
Subtag: EU
Description: European Union
Added: 2009-07-29
%%
Type: region
Subtag: EZ
Description: Eurozone
Added: 2016-07-14
%%
Type: region
Subtag: FI
Description: Finland
Added: 2005-10-16
%%
Type: region
Subtag: FJ
Description: Fiji
Added: 2005-10-16
%%
Type: region
Subtag: FK
Description: Falkland Islands (Malvinas)
Added: 2005-10-16
%%
Type: region
Subtag: FM
Description: Federated States of Micronesia
Added: 2005-10-16
%%
Type: region
Subtag: FO
Description: Faroe Islands
Added: 2005-10-16
%%
Type: region
Subtag: FR
Description: France
Added: 2005-10-16
%%
Type: region
Subtag: FX
Description: Metropolitan France
Added: 2005-10-16
Deprecated: 1997-07-14
Preferred-Value: FR
%%
Type: region
Subtag: GA
Description: Gabon
Added: 2005-10-16
%%
Type: region
Subtag: GB
Description: United Kingdom
Added: 2005-10-16
Comments: as of 2006-03-29 GB no longer includes the Channel Islands and
  Isle of Man; see GG, JE, IM
%%
Type: region
Subtag: GD
Description: Grenada
Added: 2005-10-16
%%
Type: region
Subtag: GE
Description: Georgia
Added: 2005-10-16
%%
Type: region
Subtag: GF
Description: French Guiana
Added: 2005-10-16
%%
Type: region
Subtag: GG
Description: Guernsey
Added: 2006-03-29
%%
Type: region
Subtag: GH
Description: Ghana
Added: 2005-10-16
%%
Type: region
Subtag: GI
Description: Gibraltar
Added: 2005-10-16
%%
Type: region
Subtag: GL
Description: Greenland
Added: 2005-10-16
%%
Type: region
Subtag: GM
Description: Gambia
Added: 2005-10-16
%%
Type: region
Subtag: GN
Description: Guinea
Added: 2005-10-16
%%
Type: region
Subtag: GP
Description: Guadeloupe
Added: 2005-10-16
%%
Type: region
Subtag: GQ
Description: Equatorial Guinea
Added: 2005-10-16
%%
Type: region
Subtag: GR
Description: Greece
Added: 2005-10-16
%%
Type: region
Subtag: GS
Description: South Georgia and the South Sandwich Islands
Added: 2005-10-16
%%
Type: region
Subtag: GT
Description: Guatemala
Added: 2005-10-16
%%
Type: region
Subtag: GU
Description: Guam
Added: 2005-10-16
%%
Type: region
Subtag: GW
Description: Guinea-Bissau
Added: 2005-10-16
%%
Type: region
Subtag: GY
Description: Guyana
Added: 2005-10-16
%%
Type: region
Subtag: HK
Description: Hong Kong
Added: 2005-10-16
%%
Type: region
Subtag: HM
Description: Heard Island and McDonald Islands
Added: 2005-10-16
%%
Type: region
Subtag: HN
Description: Honduras
Added: 2005-10-16
%%
Type: region
Subtag: HR
Description: Croatia
Added: 2005-10-16
%%
Type: region
Subtag: HT
Description: Haiti
Added: 2005-10-16
%%
Type: region
Subtag: HU
Description: Hungary
Added: 2005-10-16
%%
Type: region
Subtag: IC
Description: Canary Islands
Added: 2009-07-29
%%
Type: region
Subtag: ID
Description: Indonesia
Added: 2005-10-16
%%
Type: region
Subtag: IE
Description: Ireland
Added: 2005-10-16
%%
Type: region
Subtag: IL
Description: Israel
Added: 2005-10-16
%%
Type: region
Subtag: IM
Description: Isle of Man
Added: 2006-03-29
%%
Type: region
Subtag: IN
Description: India
Added: 2005-10-16
%%
Type: region
Subtag: IO
Description: British Indian Ocean Territory
Added: 2005-10-16
%%
Type: region
Subtag: IQ
Description: Iraq
Added: 2005-10-16
%%
Type: region
Subtag: IR
Description: Islamic Republic of Iran
Added: 2005-10-16
%%
Type: region
Subtag: IS
Description: Iceland
Added: 2005-10-16
%%
Type: region
Subtag: IT
Description: Italy
Added: 2005-10-16
%%
Type: region
Subtag: JE
Description: Jersey
Added: 2006-03-29
%%
Type: region
Subtag: JM
Description: Jamaica
Added: 2005-10-16
%%
Type: region
Subtag: JO
Description: Jordan
Added: 2005-10-16
%%
Type: region
Subtag: JP
Description: Japan
Added: 2005-10-16
%%
Type: region
Subtag: KE
Description: Kenya
Added: 2005-10-16
%%
Type: region
Subtag: KG
Description: Kyrgyzstan
Added: 2005-10-16
%%
Type: region
Subtag: KH
Description: Cambodia
Added: 2005-10-16
%%
Type: region
Subtag: KI
Description: Kiribati
Added: 2005-10-16
%%
Type: region
Subtag: KM
Description: Comoros
Added: 2005-10-16
%%
Type: region
Subtag: KN
Description: Saint Kitts and Nevis
Added: 2005-10-16
%%
Type: region
Subtag: KP
Description: Democratic People's Republic of Korea
Added: 2005-10-16
%%
Type: region
Subtag: KR
Description: Republic of Korea
Added: 2005-10-16
%%
Type: region
Subtag: KW
Description: Kuwait
Added: 2005-10-16
%%
Type: region
Subtag: KY
Description: Cayman Islands
Added: 2005-10-16
%%
Type: region
Subtag: KZ
Description: Kazakhstan
Added: 2005-10-16
%%
Type: region
Subtag: LA
Description: Lao People's Democratic Republic
Added: 2005-10-16
%%
Type: region
Subtag: LB
Description: Lebanon
Added: 2005-10-16
%%
Type: region
Subtag: LC
Description: Saint Lucia
Added: 2005-10-16
%%
Type: region
Subtag: LI
Description: Liechtenstein
Added: 2005-10-16
%%
Type: region
Subtag: LK
Description: Sri Lanka
Added: 2005-10-16
%%
Type: region
Subtag: LR
Description: Liberia
Added: 2005-10-16
%%
Type: region
Subtag: LS
Description: Lesotho
Added: 2005-10-16
%%
Type: region
Subtag: LT
Description: Lithuania
Added: 2005-10-16
%%
Type: region
Subtag: LU
Description: Luxembourg
Added: 2005-10-16
%%
Type: region
Subtag: LV
Description: Latvia
Added: 2005-10-16
%%
Type: region
Subtag: LY
Description: Libya
Added: 2005-10-16
%%
Type: region
Subtag: MA
Description: Morocco
Added: 2005-10-16
%%
Type: region
Subtag: MC
Description: Monaco
Added: 2005-10-16
%%
Type: region
Subtag: MD
Description: Moldova
Added: 2005-10-16
%%
Type: region
Subtag: ME
Description: Montenegro
Added: 2006-10-05
%%
Type: region
Subtag: MF
Description: Saint Martin (French part)
Added: 2007-11-02
%%
Type: region
Subtag: MG
Description: Madagascar
Added: 2005-10-16
%%
Type: region
Subtag: MH
Description: Marshall Islands
Added: 2005-10-16
%%
Type: region
Subtag: MK
Description: North Macedonia
Added: 2005-10-16
%%
Type: region
Subtag: ML
Description: Mali
Added: 2005-10-16
%%
Type: region
Subtag: MM
Description: Myanmar
Added: 2005-10-16
%%
Type: region
Subtag: MN
Description: Mongolia
Added: 2005-10-16
%%
Type: region
Subtag: MO
Description: Macao
Added: 2005-10-16
%%
Type: region
Subtag: MP
Description: Northern Mariana Islands
Added: 2005-10-16
%%
Type: region
Subtag: MQ
Description: Martinique
Added: 2005-10-16
%%
Type: region
Subtag: MR
Description: Mauritania
Added: 2005-10-16
%%
Type: region
Subtag: MS
Description: Montserrat
Added: 2005-10-16
%%
Type: region
Subtag: MT
Description: Malta
Added: 2005-10-16
%%
Type: region
Subtag: MU
Description: Mauritius
Added: 2005-10-16
%%
Type: region
Subtag: MV
Description: Maldives
Added: 2005-10-16
%%
Type: region
Subtag: MW
Description: Malawi
Added: 2005-10-16
%%
Type: region
Subtag: MX
Description: Mexico
Added: 2005-10-16
%%
Type: region
Subtag: MY
Description: Malaysia
Added: 2005-10-16
%%
Type: region
Subtag: MZ
Description: Mozambique
Added: 2005-10-16
%%
Type: region
Subtag: NA
Description: Namibia
Added: 2005-10-16
%%
Type: region
Subtag: NC
Description: New Caledonia
Added: 2005-10-16
%%
Type: region
Subtag: NE
Description: Niger
Added: 2005-10-16
%%
Type: region
Subtag: NF
Description: Norfolk Island
Added: 2005-10-16
%%
Type: region
Subtag: NG
Description: Nigeria
Added: 2005-10-16
%%
Type: region
Subtag: NI
Description: Nicaragua
Added: 2005-10-16
%%
Type: region
Subtag: NL
Description: Netherlands
Added: 2005-10-16
%%
Type: region
Subtag: NO
Description: Norway
Added: 2005-10-16
%%
Type: region
Subtag: NP
Description: Nepal
Added: 2005-10-16
%%
Type: region
Subtag: NR
Description: Nauru
Added: 2005-10-16
%%
Type: region
Subtag: NT
Description: Neutral Zone
Added: 2005-10-16
Deprecated: 1993-07-12
%%
Type: region
Subtag: NU
Description: Niue
Added: 2005-10-16
%%
Type: region
Subtag: NZ
Description: New Zealand
Added: 2005-10-16
%%
Type: region
Subtag: OM
Description: Oman
Added: 2005-10-16
%%
Type: region
Subtag: PA
Description: Panama
Added: 2005-10-16
%%
Type: region
Subtag: PE
Description: Peru
Added: 2005-10-16
%%
Type: region
Subtag: PF
Description: French Polynesia
Added: 2005-10-16
%%
Type: region
Subtag: PG
Description: Papua New Guinea
Added: 2005-10-16
%%
Type: region
Subtag: PH
Description: Philippines
Added: 2005-10-16
%%
Type: region
Subtag: PK
Description: Pakistan
Added: 2005-10-16
%%
Type: region
Subtag: PL
Description: Poland
Added: 2005-10-16
%%
Type: region
Subtag: PM
Description: Saint Pierre and Miquelon
Added: 2005-10-16
%%
Type: region
Subtag: PN
Description: Pitcairn
Added: 2005-10-16
%%
Type: region
Subtag: PR
Description: Puerto Rico
Added: 2005-10-16
%%
Type: region
Subtag: PS
Description: State of Palestine
Added: 2005-10-16
%%
Type: region
Subtag: PT
Description: Portugal
Added: 2005-10-16
%%
Type: region
Subtag: PW
Description: Palau
Added: 2005-10-16
%%
Type: region
Subtag: PY
Description: Paraguay
Added: 2005-10-16
%%
Type: region
Subtag: QA
Description: Qatar
Added: 2005-10-16
%%
Type: region
Subtag: QM..QZ
Description: Private use
Added: 2005-10-16
%%
Type: region
Subtag: RE
Description: Réunion
Added: 2005-10-16
%%
Type: region
Subtag: RO
Description: Romania
Added: 2005-10-16
%%
Type: region
Subtag: RS
Description: Serbia
Added: 2006-10-05
%%
Type: region
Subtag: RU
Description: Russian Federation
Added: 2005-10-16
%%
Type: region
Subtag: RW
Description: Rwanda
Added: 2005-10-16
%%
Type: region
Subtag: SA
Description: Saudi Arabia
Added: 2005-10-16
%%
Type: region
Subtag: SB
Description: Solomon Islands
Added: 2005-10-16
%%
Type: region
Subtag: SC
Description: Seychelles
Added: 2005-10-16
%%
Type: region
Subtag: SD
Description: Sudan
Added: 2005-10-16
%%
Type: region
Subtag: SE
Description: Sweden
Added: 2005-10-16
%%
Type: region
Subtag: SG
Description: Singapore
Added: 2005-10-16
%%
Type: region
Subtag: SH
Description: Saint Helena, Ascension and Tristan da Cunha
Added: 2005-10-16
%%
Type: region
Subtag: SI
Description: Slovenia
Added: 2005-10-16
%%
Type: region
Subtag: SJ
Description: Svalbard and Jan Mayen
Added: 2005-10-16
%%
Type: region
Subtag: SK
Description: Slovakia
Added: 2005-10-16
%%
Type: region
Subtag: SL
Description: Sierra Leone
Added: 2005-10-16
%%
Type: region
Subtag: SM
Description: San Marino
Added: 2005-10-16
%%
Type: region
Subtag: SN
Description: Senegal
Added: 2005-10-16
%%
Type: region
Subtag: SO
Description: Somalia
Added: 2005-10-16
%%
Type: region
Subtag: SR
Description: Suriname
Added: 2005-10-16
%%
Type: region
Subtag: SS
Description: South Sudan
Added: 2011-08-25
%%
Type: region
Subtag: ST
Description: Sao Tome and Principe
Added: 2005-10-16
%%
Type: region
Subtag: SU
Description: Union of Soviet Socialist Republics
Added: 2005-10-16
Deprecated: 1992-08-30
%%
Type: region
Subtag: SV
Description: El Salvador
Added: 2005-10-16
%%
Type: region
Subtag: SX
Description: Sint Maarten (Dutch part)
Added: 2011-01-07
%%
Type: region
Subtag: SY
Description: Syrian Arab Republic
Added: 2005-10-16
%%
Type: region
Subtag: SZ
Description: Eswatini
Description: eSwatini
Description: Swaziland
Added: 2005-10-16
%%
Type: region
Subtag: TA
Description: Tristan da Cunha
Added: 2009-07-29
%%
Type: region
Subtag: TC
Description: Turks and Caicos Islands
Added: 2005-10-16
%%
Type: region
Subtag: TD
Description: Chad
Added: 2005-10-16
%%
Type: region
Subtag: TF
Description: French Southern Territories
Added: 2005-10-16
%%
Type: region
Subtag: TG
Description: Togo
Added: 2005-10-16
%%
Type: region
Subtag: TH
Description: Thailand
Added: 2005-10-16
%%
Type: region
Subtag: TJ
Description: Tajikistan
Added: 2005-10-16
%%
Type: region
Subtag: TK
Description: Tokelau
Added: 2005-10-16
%%
Type: region
Subtag: TL
Description: Timor-Leste
Added: 2005-10-16
%%
Type: region
Subtag: TM
Description: Turkmenistan
Added: 2005-10-16
%%
Type: region
Subtag: TN
Description: Tunisia
Added: 2005-10-16
%%
Type: region
Subtag: TO
Description: Tonga
Added: 2005-10-16
%%
Type: region
Subtag: TP
Description: East Timor
Added: 2005-10-16
Deprecated: 2002-05-20
Preferred-Value: TL
%%
Type: region
Subtag: TR
Description: Turkey
Added: 2005-10-16
%%
Type: region
Subtag: TT
Description: Trinidad and Tobago
Added: 2005-10-16
%%
Type: region
Subtag: TV
Description: Tuvalu
Added: 2005-10-16
%%
Type: region
Subtag: TW
Description: Taiwan, Province of China
Added: 2005-10-16
%%
Type: region
Subtag: TZ
Description: United Republic of Tanzania
Added: 2005-10-16
%%
Type: region
Subtag: UA
Description: Ukraine
Added: 2005-10-16
%%
Type: region
Subtag: UG
Description: Uganda
Added: 2005-10-16
%%
Type: region
Subtag: UM
Description: United States Minor Outlying Islands
Added: 2005-10-16
%%
Type: region
Subtag: UN
Description: United Nations
Added: 2016-07-14
%%
Type: region
Subtag: US
Description: United States
Added: 2005-10-16
%%
Type: region
Subtag: UY
Description: Uruguay
Added: 2005-10-16
%%
Type: region
Subtag: UZ
Description: Uzbekistan
Added: 2005-10-16
%%
Type: region
Subtag: VA
Description: Holy See (Vatican City State)
Added: 2005-10-16
%%
Type: region
Subtag: VC
Description: Saint Vincent and the Grenadines
Added: 2005-10-16
%%
Type: region
Subtag: VE
Description: Venezuela
Added: 2005-10-16
%%
Type: region
Subtag: VG
Description: British Virgin Islands
Added: 2005-10-16
%%
Type: region
Subtag: VI
Description: U.S. Virgin Islands
Added: 2005-10-16
%%
Type: region
Subtag: VN
Description: Viet Nam
Added: 2005-10-16
%%
Type: region
Subtag: VU
Description: Vanuatu
Added: 2005-10-16
%%
Type: region
Subtag: WF
Description: Wallis and Futuna
Added: 2005-10-16
%%
Type: region
Subtag: WS
Description: Samoa
Added: 2005-10-16
%%
Type: region
Subtag: XA..XZ
Description: Private use
Added: 2005-10-16
%%
Type: region
Subtag: YD
Description: Democratic Yemen
Added: 2005-10-16
Deprecated: 1990-08-14
Preferred-Value: YE
%%
Type: region
Subtag: YE
Description: Yemen
Added: 2005-10-16
%%
Type: region
Subtag: YT
Description: Mayotte
Added: 2005-10-16
%%
Type: region
Subtag: YU
Description: Yugoslavia
Added: 2005-10-16
Deprecated: 2003-07-23
Comments: see BA, HR, ME, MK, RS, or SI
%%
Type: region
Subtag: ZA
Description: South Africa
Added: 2005-10-16
%%
Type: region
Subtag: ZM
Description: Zambia
Added: 2005-10-16
%%
Type: region
Subtag: ZR
Description: Zaire
Added: 2005-10-16
Deprecated: 1997-07-14
Preferred-Value: CD
%%
Type: region
Subtag: ZW
Description: Zimbabwe
Added: 2005-10-16
%%
Type: region
Subtag: ZZ
Description: Private use
Added: 2005-10-16
%%
Type: region
Subtag: 001
Description: World
Added: 2005-10-16
%%
Type: region
Subtag: 002
Description: Africa
Added: 2005-10-16
%%
Type: region
Subtag: 003
Description: North America
Added: 2010-08-16
Comments: Includes Northern America (021), Caribbean (029), and Central
  America (013); see also 021
%%
Type: region
Subtag: 005
Description: South America
Added: 2005-10-16
%%
Type: region
Subtag: 009
Description: Oceania
Added: 2005-10-16
%%
Type: region
Subtag: 011
Description: Western Africa
Added: 2005-10-16
%%
Type: region
Subtag: 013
Description: Central America
Added: 2005-10-16
%%
Type: region
Subtag: 014
Description: Eastern Africa
Added: 2005-10-16
%%
Type: region
Subtag: 015
Description: Northern Africa
Added: 2005-10-16
%%
Type: region
Subtag: 017
Description: Middle Africa
Added: 2005-10-16
%%
Type: region
Subtag: 018
Description: Southern Africa
Added: 2005-10-16
%%
Type: region
Subtag: 019
Description: Americas
Added: 2005-10-16
%%
Type: region
Subtag: 021
Description: Northern America
Added: 2005-10-16
Comments: Does not include Caribbean (029) or Central America (013); see
  also 003
%%
Type: region
Subtag: 029
Description: Caribbean
Added: 2005-10-16
%%
Type: region
Subtag: 030
Description: Eastern Asia
Added: 2005-10-16
%%
Type: region
Subtag: 034
Description: Southern Asia
Added: 2005-10-16
%%
Type: region
Subtag: 035
Description: South-Eastern Asia
Added: 2005-10-16
%%
Type: region
Subtag: 039
Description: Southern Europe
Added: 2005-10-16
%%
Type: region
Subtag: 053
Description: Australia and New Zealand
Added: 2005-10-16
%%
Type: region
Subtag: 054
Description: Melanesia
Added: 2005-10-16
%%
Type: region
Subtag: 057
Description: Micronesia
Added: 2005-10-16
%%
Type: region
Subtag: 061
Description: Polynesia
Added: 2005-10-16
%%
Type: region
Subtag: 142
Description: Asia
Added: 2005-10-16
%%
Type: region
Subtag: 143
Description: Central Asia
Added: 2005-10-16
%%
Type: region
Subtag: 145
Description: Western Asia
Added: 2005-10-16
%%
Type: region
Subtag: 150
Description: Europe
Added: 2005-10-16
%%
Type: region
Subtag: 151
Description: Eastern Europe
Added: 2005-10-16
%%
Type: region
Subtag: 154
Description: Northern Europe
Added: 2005-10-16
%%
Type: region
Subtag: 155
Description: Western Europe
Added: 2005-10-16
%%
Type: region
Subtag: 202
Description: Sub-Saharan Africa
Added: 2017-04-18
%%
Type: region
Subtag: 419
Description: Latin America and the Caribbean
Added: 2005-10-16
%%
Type: variant
Subtag: 1606nict
Description: Late Middle French (to 1606)
Added: 2007-03-20
Prefix: frm
Comments: 16th century French as in Jean Nicot, "Thresor de la langue
  francoyse", 1606, but also including some French similar to that of
  Rabelais
%%
Type: variant
Subtag: 1694acad
Description: Early Modern French
Added: 2007-03-20
Prefix: fr
Comments: 17th century French, as catalogued in the "Dictionnaire de
  l'académie françoise", 4eme ed. 1694; frequently includes
  elements of Middle French, as this is a transitional period
%%
Type: variant
Subtag: 1901
Description: Traditional German orthography
Added: 2005-10-16
Prefix: de
%%
Type: variant
Subtag: 1959acad
Description: "Academic" ("governmental") variant of Belarusian as
  codified in 1959
Added: 2008-09-30
Prefix: be
%%
Type: variant
Subtag: 1994
Description: Standardized Resian orthography
Added: 2007-07-28
Prefix: sl-rozaj
Prefix: sl-rozaj-biske
Prefix: sl-rozaj-njiva
Prefix: sl-rozaj-osojs
Prefix: sl-rozaj-solba
Comments: For standardized Resian an orthography was published in 1994.
%%
Type: variant
Subtag: 1996
Description: German orthography of 1996
Added: 2005-10-16
Prefix: de
%%
Type: variant
Subtag: abl1943
Description: Orthographic formulation of 1943 - Official in Brazil
  (Formulário Ortográfico de 1943 - Oficial no Brasil)
Added: 2015-05-06
Prefix: pt-BR
Comments: Denotes conventions established by the Academia Brasileira de
  Letras in 1943 and generally used in Brazil until 2009
%%
Type: variant
Subtag: alalc97
Description: ALA-LC Romanization, 1997 edition
Added: 2009-12-09
Comments: Romanizations recommended by the American Library Association
  and the Library of Congress, in "ALA-LC Romanization Tables:
  Transliteration Schemes for Non-Roman Scripts" (1997), ISBN
  978-0-8444-0940-5.
%%
Type: variant
Subtag: aluku
Description: Aluku dialect
Description: Boni dialect
Added: 2009-09-05
Prefix: djk
Comments: Aluku dialect of the "Busi Nenge Tongo" English-based Creole
  continuum in Eastern Suriname and Western French Guiana
%%
Type: variant
Subtag: akuapem
Description: Akuapem Twi
Added: 2017-06-05
Prefix: tw
%%
Type: variant
Subtag: ao1990
Description: Portuguese Language Orthographic Agreement of 1990 (Acordo
  Ortográfico da Língua Portuguesa de 1990)
Added: 2015-05-06
Prefix: pt
Prefix: gl
Comments: Portuguese orthography conventions established in 1990 but
  not brought into effect until 2009
%%
Type: variant
Subtag: aranes
Description: Aranese
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in the Val d'Aran
%%
Type: variant
Subtag: arevela
Description: Eastern Armenian
Added: 2006-09-18
Deprecated: 2018-03-24
Prefix: hy
Comments: Preferred tag is hy
%%
Type: variant
Subtag: arevmda
Description: Western Armenian
Added: 2006-09-18
Deprecated: 2018-03-24
Prefix: hy
Comments: Preferred tag is hyw
%%
Type: variant
Subtag: asante
Description: Asante Twi
Description: Ashanti Twi
Added: 2017-06-05
Prefix: tw
%%
Type: variant
Subtag: auvern
Description: Auvergnat
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in Auvergne
%%
Type: variant
Subtag: baku1926
Description: Unified Turkic Latin Alphabet (Historical)
Added: 2007-04-18
Prefix: az
Prefix: ba
Prefix: crh
Prefix: kk
Prefix: krc
Prefix: ky
Prefix: sah
Prefix: tk
Prefix: tt
Prefix: uz
Comments: Denotes alphabet used in Turkic republics/regions of the
  former USSR in late 1920s, and throughout 1930s, which aspired to
  represent equivalent phonemes in a unified fashion. Also known as: New
  Turkic Alphabet; Birlәşdirilmiş Jeni Tyrk
  Әlifbasь (Birlesdirilmis Jeni Tyrk Elifbasi);
  Jaŋalif (Janalif).
%%
Type: variant
Subtag: balanka
Description: The Balanka dialect of Anii
Added: 2014-02-15
Prefix: blo
Comments: Balanka is one of 19 Anii dialects.
%%
Type: variant
Subtag: barla
Description: The Barlavento dialect group of Kabuverdianu
Prefix: kea
Comments: Barlavento is one of the two main dialect groups of
  Kabuverdianu.
Added: 2013-12-10
%%
Type: variant
Subtag: basiceng
Description: Basic English
Added: 2015-12-29
Prefix: en
%%
Type: variant
Subtag: bauddha
Description: Buddhist Hybrid Sanskrit
Added: 2010-07-28
Prefix: sa
%%
Type: variant
Subtag: biscayan
Description: Biscayan dialect of Basque
Added: 2010-04-13
Prefix: eu
%%
Type: variant
Subtag: biske
Description: The San Giorgio dialect of Resian
Description: The Bila dialect of Resian
Added: 2007-07-05
Prefix: sl-rozaj
Comments: The dialect of San Giorgio/Bila is one of the four major local
  dialects of Resian
%%
Type: variant
Subtag: bohoric
Description: Slovene in Bohorič alphabet
Added: 2012-06-27
Prefix: sl
Comments: The subtag represents the alphabet codified by Adam Bohorič
  in 1584 and used from the first printed Slovene book and up to the
  mid-19th century.
%%
Type: variant
Subtag: boont
Description: Boontling
Added: 2006-09-18
Prefix: en
Comments: Jargon embedded in American English
%%
Type: variant
Subtag: bornholm
Description: Bornholmsk
Added: 2019-03-27
Prefix: da
%%
Type: variant
Subtag: cisaup
Description: Cisalpine
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in northwestern Italy
%%
Type: variant
Subtag: colb1945
Description: Portuguese-Brazilian Orthographic Convention of 1945
  (Convenção Ortográfica Luso-Brasileira de 1945)
Added: 2015-05-06
Prefix: pt
Comments: Portuguese orthography conventions established in 1945,
  generally in effect until 2009. This reform was not ratified in
  Brazil.
%%
Type: variant
Subtag: cornu
Description: Cornu-English
Description: Cornish English
Description: Anglo-Cornish
Added: 2015-12-07
Prefix: en
%%
Type: variant
Subtag: creiss
Description: Occitan variants of the Croissant area
Added: 2018-04-22
Prefix: oc
%%
Type: variant
Subtag: dajnko
Description: Slovene in Dajnko alphabet
Added: 2012-06-27
Prefix: sl
Comments: The subtag represents the alphabet codified by Peter Dajnko
  and used from 1824 to 1839 mostly in Styria (in what is now Eastern
  Slovenia).
%%
Type: variant
Subtag: ekavsk
Description: Serbian with Ekavian pronunciation
Prefix: sr
Prefix: sr-Latn
Prefix: sr-Cyrl
Added: 2013-12-02
%%
Type: variant
Subtag: emodeng
Description: Early Modern English (1500-1700)
Added: 2012-02-05
Prefix: en
%%
Type: variant
Subtag: fonipa
Description: International Phonetic Alphabet
Added: 2006-12-11
%%
Type: variant
Subtag: fonkirsh
Description: Kirshenbaum Phonetic Alphabet
Added: 2018-04-22
%%
Type: variant
Subtag: fonnapa
Description: North American Phonetic Alphabet
Description: Americanist Phonetic Notation
Added: 2016-06-24
%%
Type: variant
Subtag: fonupa
Description: Uralic Phonetic Alphabet
Added: 2006-12-11
%%
Type: variant
Subtag: fonxsamp
Description: X-SAMPA transcription
Added: 2010-10-23
Comments: Indicates that the content is transcribed according to X-SAMPA
%%
Type: variant
Subtag: gascon
Description: Gascon
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in Gascony
%%
Type: variant
Subtag: grclass
Description: Classical Occitan orthography
Added: 2018-04-22
Prefix: oc
Comments: Classical written standard for Occitan developed in 1935 by
  Alibèrt
%%
Type: variant
Subtag: grital
Description: Italian-inspired Occitan orthography
Added: 2018-04-22
Prefix: oc
%%
Type: variant
Subtag: grmistr
Description: Mistralian or Mistralian-inspired Occitan orthography
Added: 2018-04-22
Prefix: oc
Comments: Written standard developed by Romanilha in 1853 and used by
  Mistral and the Félibres, including derived standards such as Escolo
  dóu Po, Escolo Gaston Febus, and others
%%
Type: variant
Subtag: hepburn
Description: Hepburn romanization
Added: 2009-10-01
Prefix: ja-Latn
%%
Type: variant
Subtag: heploc
Description: Hepburn romanization, Library of Congress method
Added: 2009-10-01
Deprecated: 2010-02-07
Preferred-Value: alalc97
Prefix: ja-Latn-hepburn
Comments: Preferred tag is ja-Latn-alalc97
%%
Type: variant
Subtag: hognorsk
Description: Norwegian in Høgnorsk (High Norwegian) orthography
Added: 2010-01-02
Prefix: nn
Comments: Norwegian following Ivar Aasen's orthographical principles,
  including modern usage.
%%
Type: variant
Subtag: hsistemo
Description: Standard H-system orthographic fallback for spelling
  Esperanto
Added: 2017-03-14
Prefix: eo
%%
Type: variant
Subtag: ijekavsk
Description: Serbian with Ijekavian pronunciation
Prefix: sr
Prefix: sr-Latn
Prefix: sr-Cyrl
Added: 2013-12-02
%%
Type: variant
Subtag: itihasa
Description: Epic Sanskrit
Added: 2010-07-28
Prefix: sa
%%
Type: variant
Subtag: ivanchov
Description: Bulgarian in 1899 orthography
Added: 2017-12-13
Prefix: bg
Comments: Bulgarian orthography introduced by Todor Ivanchov in 1899
%%
Type: variant
Subtag: jauer
Description: Jauer dialect of Romansh
Added: 2010-06-29
Prefix: rm
Comments: The spoken dialect of the Val Müstair, which has no written
  standard.
%%
Type: variant
Subtag: jyutping
Description: Jyutping Cantonese Romanization
Added: 2010-10-23
Prefix: yue
Comments: Jyutping romanization of Cantonese
%%
Type: variant
Subtag: kkcor
Description: Common Cornish orthography of Revived Cornish
Added: 2008-10-14
Prefix: kw
%%
Type: variant
Subtag: kociewie
Description: The Kociewie dialect of Polish
Added: 2014-11-27
Prefix: pl
Comments: The dialect of Kociewie is spoken in the region around
  Starogard Gdański, Tczew and Świecie in northern Poland.
%%
Type: variant
Subtag: kscor
Description: Standard Cornish orthography of Revived Cornish
Description: Kernowek Standard
Added: 2012-06-27
Prefix: kw
%%
Type: variant
Subtag: laukika
Description: Classical Sanskrit
Added: 2010-07-28
Prefix: sa
%%
Type: variant
Subtag: lemosin
Description: Limousin
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in Limousin
%%
Type: variant
Subtag: lengadoc
Description: Languedocien
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in Languedoc
%%
Type: variant
Subtag: lipaw
Description: The Lipovaz dialect of Resian
Description: The Lipovec dialect of Resian
Added: 2007-08-11
Prefix: sl-rozaj
Comments: The dialect of Lipovaz/Lipovec is one of the minor local
  dialects of Resian
%%
Type: variant
Subtag: luna1918
Description: Post-1917 Russian orthography
Added: 2010-10-10
Prefix: ru
Comments: Russian orthography as established by the 1917/1918
  orthographic reforms
%%
Type: variant
Subtag: metelko
Description: Slovene in Metelko alphabet
Added: 2012-06-27
Prefix: sl
Comments: The subtag represents the alphabet codified by Franc Serafin
  Metelko and used from 1825 to 1833.
%%
Type: variant
Subtag: monoton
Description: Monotonic Greek
Added: 2006-12-11
Prefix: el
%%
Type: variant
Subtag: ndyuka
Description: Ndyuka dialect
Description: Aukan dialect
Added: 2009-09-05
Prefix: djk
Comments: Ndyuka dialect of the "Busi Nenge Tongo" English-based
  Creole continuum in Eastern Suriname and Western French Guiana
%%
Type: variant
Subtag: nedis
Description: Natisone dialect
Description: Nadiza dialect
Added: 2005-10-16
Prefix: sl
%%
Type: variant
Subtag: newfound
Description: Newfoundland English
Added: 2015-11-25
Prefix: en-CA
%%
Type: variant
Subtag: nicard
Description: Niçard
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in Nice
%%
Type: variant
Subtag: njiva
Description: The Gniva dialect of Resian
Description: The Njiva dialect of Resian
Added: 2007-07-05
Prefix: sl-rozaj
Comments: The dialect of Gniva/Njiva is one of the four major local
  dialects of Resian
%%
Type: variant
Subtag: nulik
Description: Volapük nulik
Description: Volapük perevidöl
Description: Volapük nulädik
Description: de Jong's Volapük
Description: New Volapük
Description: Revised Volapük
Description: Modern Volapük
Added: 2012-01-28
Prefix: vo
%%
Type: variant
Subtag: osojs
Description: The Oseacco dialect of Resian
Description: The Osojane dialect of Resian
Added: 2007-07-05
Prefix: sl-rozaj
Comments: The dialect of Oseacco/Osojane is one of the four major local
  dialects of Resian
%%
Type: variant
Subtag: oxendict
Description: Oxford English Dictionary spelling
Added: 2015-04-17
Prefix: en
%%
Type: variant
Subtag: pahawh2
Description: Pahawh Hmong Second Stage Reduced orthography
Added: 2017-01-13
Prefix: mww
Prefix: hnj
%%
Type: variant
Subtag: pahawh3
Description: Pahawh Hmong Third Stage Reduced orthography
Added: 2017-01-13
Prefix: mww
Prefix: hnj
%%
Type: variant
Subtag: pahawh4
Description: Pahawh Hmong Final Version orthography
Added: 2017-01-13
Prefix: mww
Prefix: hnj
%%
Type: variant
Subtag: pamaka
Description: Pamaka dialect
Added: 2009-09-05
Prefix: djk
Comments: Pamaka dialect of the "Busi Nenge Tongo" English-based
  Creole continuum in Eastern Suriname and Western French Guiana
%%
Type: variant
Subtag: peano
Description: Latino Sine Flexione
Description: Interlingua de API
Description: Interlingua de Peano
Prefix: la
Comments: Peano’s Interlingua, created in 1903 by Giuseppe Peano as an
  international auxiliary language
Added: 2020-03-12
%%
Type: variant
Subtag: petr1708
Description: Petrine orthography
Added: 2010-10-10
Prefix: ru
Comments: Russian orthography from the Petrine orthographic reforms of
  1708 to the 1917 orthographic reform
%%
Type: variant
Subtag: pinyin
Description: Pinyin romanization
Added: 2008-10-14
Prefix: zh-Latn
Prefix: bo-Latn
%%
Type: variant
Subtag: polyton
Description: Polytonic Greek
Added: 2006-12-11
Prefix: el
%%
Type: variant
Subtag: provenc
Description: Provençal
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in Provence
%%
Type: variant
Subtag: puter
Description: Puter idiom of Romansh
Added: 2010-06-29
Prefix: rm
Comments: Puter is one of the five traditional written standards or
  "idioms" of the Romansh language.
%%
Type: variant
Subtag: rigik
Description: Volapük rigik
Description: Schleyer's Volapük
Description: Original Volapük
Description: Classic Volapük
Added: 2012-01-28
Prefix: vo
%%
Type: variant
Subtag: rozaj
Description: Resian
Description: Resianic
Description: Rezijan
Added: 2005-10-16
Prefix: sl
%%
Type: variant
Subtag: rumgr
Description: Rumantsch Grischun
Added: 2010-06-29
Prefix: rm
Comments: Supraregional Romansh written standard
%%
Type: variant
Subtag: scotland
Description: Scottish Standard English
Added: 2007-08-31
Prefix: en
%%
Type: variant
Subtag: scouse
Description: Scouse
Added: 2006-09-18
Prefix: en
Comments: English Liverpudlian dialect known as 'Scouse'
%%
Type: variant
Subtag: simple
Description: Simplified form
Added: 2015-12-29
%%
Type: variant
Subtag: solba
Description: The Stolvizza dialect of Resian
Description: The Solbica dialect of Resian
Added: 2007-07-05
Prefix: sl-rozaj
Comments: The dialect of Stolvizza/Solbica is one of the four major
  local dialects of Resian
%%
Type: variant
Subtag: sotav
Description: The Sotavento dialect group of Kabuverdianu
Prefix: kea
Comments: Sotavento is one of the two main dialect groups of
  Kabuverdianu.
Added: 2013-12-10
%%
Type: variant
Subtag: spanglis
Description: Spanglish
Added: 2017-02-23
Prefix: en
Prefix: es
Comments: A variety of contact dialects of English and Spanish
%%
Type: variant
Subtag: surmiran
Description: Surmiran idiom of Romansh
Added: 2010-06-29
Prefix: rm
Comments: Surmiran is one of the five traditional written standards or
  "idioms" of the Romansh language.
%%
Type: variant
Subtag: sursilv
Description: Sursilvan idiom of Romansh
Added: 2010-06-29
Prefix: rm
Comments: Sursilvan is one of the five traditional written standards or
  "idioms" of the Romansh language.
%%
Type: variant
Subtag: sutsilv
Description: Sutsilvan idiom of Romansh
Added: 2010-06-29
Prefix: rm
Comments: Sutsilvan is one of the five traditional written standards or
  "idioms" of the Romansh language.
%%
Type: variant
Subtag: tarask
Description: Belarusian in Taraskievica orthography
Added: 2007-04-27
Prefix: be
Comments: The subtag represents Branislau Taraskievic's Belarusian
  orthography as published in "Bielaruski klasycny pravapis" by Juras
  Buslakou, Vincuk Viacorka, Zmicier Sanko, and Zmicier Sauka (Vilnia-
  Miensk 2005).
%%
Type: variant
Subtag: uccor
Description: Unified Cornish orthography of Revived Cornish
Added: 2008-10-14
Prefix: kw
%%
Type: variant
Subtag: ucrcor
Description: Unified Cornish Revised orthography of Revived Cornish
Added: 2008-10-14
Prefix: kw
%%
Type: variant
Subtag: ulster
Description: Ulster dialect of Scots
Added: 2010-04-10
Prefix: sco
%%
Type: variant
Subtag: unifon
Description: Unifon phonetic alphabet
Added: 2013-10-02
Prefix: en
Prefix: hup
Prefix: kyh
Prefix: tol
Prefix: yur
%%
Type: variant
Subtag: vaidika
Description: Vedic Sanskrit
Added: 2010-07-28
Prefix: sa
Comments: The most ancient dialect of Sanskrit used in verse and prose
  composed until about the 4th century B.C.E.
%%
Type: variant
Subtag: valencia
Description: Valencian
Added: 2007-03-06
Prefix: ca
Comments: Variety spoken in the "Comunidad Valenciana" region of Spain,
  where it is co-official with Spanish.
%%
Type: variant
Subtag: vallader
Description: Vallader idiom of Romansh
Added: 2010-06-29
Prefix: rm
Comments: Vallader is one of the five traditional written standards or
  "idioms" of the Romansh language.
%%
Type: variant
Subtag: vivaraup
Description: Vivaro-Alpine
Added: 2018-04-22
Prefix: oc
Comments: Occitan variant spoken in northeastern Occitania
%%
Type: variant
Subtag: wadegile
Description: Wade-Giles romanization
Added: 2008-10-03
Prefix: zh-Latn
%%
Type: variant
Subtag: xsistemo
Description: Standard X-system orthographic fallback for spelling
  Esperanto
Added: 2017-03-14
Prefix: eo
%%
Type: grandfathered
Tag: art-lojban
Description: Lojban
Added: 2001-11-11
Deprecated: 2003-09-02
Preferred-Value: jbo
%%
Type: grandfathered
Tag: cel-gaulish
Description: Gaulish
Added: 2001-05-25
Deprecated: 2015-03-29
Comments: see xcg, xga, xtg
%%
Type: grandfathered
Tag: en-GB-oed
Description: English, Oxford English Dictionary spelling
Added: 2003-07-09
Deprecated: 2015-04-17
Preferred-Value: en-GB-oxendict
%%
Type: grandfathered
Tag: i-ami
Description: Amis
Added: 1999-05-25
Deprecated: 2009-07-29
Preferred-Value: ami
%%
Type: grandfathered
Tag: i-bnn
Description: Bunun
Added: 1999-05-25
Deprecated: 2009-07-29
Preferred-Value: bnn
%%
Type: grandfathered
Tag: i-default
Description: Default Language
Added: 1998-03-10
%%
Type: grandfathered
Tag: i-enochian
Description: Enochian
Added: 2002-07-03
Deprecated: 2015-03-29
%%
Type: grandfathered
Tag: i-hak
Description: Hakka
Added: 1999-01-31
Deprecated: 2000-01-10
Preferred-Value: hak
%%
Type: grandfathered
Tag: i-klingon
Description: Klingon
Added: 1999-05-26
Deprecated: 2004-02-24
Preferred-Value: tlh
%%
Type: grandfathered
Tag: i-lux
Description: Luxembourgish
Added: 1997-09-19
Deprecated: 1998-09-09
Preferred-Value: lb
%%
Type: grandfathered
Tag: i-mingo
Description: Mingo
Added: 1997-09-19
%%
Type: grandfathered
Tag: i-navajo
Description: Navajo
Added: 1997-09-19
Deprecated: 2000-02-18
Preferred-Value: nv
%%
Type: grandfathered
Tag: i-pwn
Description: Paiwan
Added: 1999-05-25
Deprecated: 2009-07-29
Preferred-Value: pwn
%%
Type: grandfathered
Tag: i-tao
Description: Tao
Added: 1999-05-25
Deprecated: 2009-07-29
Preferred-Value: tao
%%
Type: grandfathered
Tag: i-tay
Description: Tayal
Added: 1999-05-25
Deprecated: 2009-07-29
Preferred-Value: tay
%%
Type: grandfathered
Tag: i-tsu
Description: Tsou
Added: 1999-05-25
Deprecated: 2009-07-29
Preferred-Value: tsu
%%
Type: grandfathered
Tag: no-bok
Description: Norwegian Bokmal
Added: 1995-08-23
Deprecated: 2000-02-18
Preferred-Value: nb
%%
Type: grandfathered
Tag: no-nyn
Description: Norwegian Nynorsk
Added: 1995-08-23
Deprecated: 2000-02-18
Preferred-Value: nn
%%
Type: grandfathered
Tag: sgn-BE-FR
Description: Belgian-French Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: sfb
%%
Type: grandfathered
Tag: sgn-BE-NL
Description: Belgian-Flemish Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: vgt
%%
Type: grandfathered
Tag: sgn-CH-DE
Description: Swiss German Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: sgg
%%
Type: grandfathered
Tag: zh-guoyu
Description: Mandarin or Standard Chinese
Added: 1999-12-18
Deprecated: 2005-07-15
Preferred-Value: cmn
%%
Type: grandfathered
Tag: zh-hakka
Description: Hakka
Added: 1999-12-18
Deprecated: 2009-07-29
Preferred-Value: hak
%%
Type: grandfathered
Tag: zh-min
Description: Min, Fuzhou, Hokkien, Amoy, or Taiwanese
Added: 1999-12-18
Deprecated: 2009-07-29
Comments: see cdo, cpx, czo, mnp, nan
%%
Type: grandfathered
Tag: zh-min-nan
Description: Minnan, Hokkien, Amoy, Taiwanese, Southern Min, Southern
  Fujian, Hoklo, Southern Fukien, Ho-lo
Added: 2001-03-26
Deprecated: 2009-07-29
Preferred-Value: nan
%%
Type: grandfathered
Tag: zh-xiang
Description: Xiang or Hunanese
Added: 1999-12-18
Deprecated: 2009-07-29
Preferred-Value: hsn
%%
Type: redundant
Tag: az-Arab
Description: Azerbaijani in Arabic script
Added: 2003-05-30
%%
Type: redundant
Tag: az-Cyrl
Description: Azerbaijani in Cyrillic script
Added: 2003-05-30
%%
Type: redundant
Tag: az-Latn
Description: Azerbaijani in Latin script
Added: 2003-05-30
%%
Type: redundant
Tag: be-Latn
Description: Belarusian in Latin script
Added: 2005-01-06
%%
Type: redundant
Tag: bs-Cyrl
Description: Bosnian in Cyrillic script
Added: 2005-02-17
%%
Type: redundant
Tag: bs-Latn
Description: Bosnian in Latin script
Added: 2005-02-17
%%
Type: redundant
Tag: de-1901
Description: German, traditional orthography
Added: 2001-07-17
%%
Type: redundant
Tag: de-1996
Description: German, orthography of 1996
Added: 2001-07-17
%%
Type: redundant
Tag: de-AT-1901
Description: German, Austrian variant, traditional orthography
Added: 2001-07-17
%%
Type: redundant
Tag: de-AT-1996
Description: German, Austrian variant, orthography of 1996
Added: 2001-07-17
%%
Type: redundant
Tag: de-CH-1901
Description: German, Swiss variant, traditional orthography
Added: 2001-07-17
%%
Type: redundant
Tag: de-CH-1996
Description: German, Swiss variant, orthography of 1996
Added: 2001-07-17
%%
Type: redundant
Tag: de-DE-1901
Description: German, German variant, traditional orthography
Added: 2001-07-17
%%
Type: redundant
Tag: de-DE-1996
Description: German, German variant, orthography of 1996
Added: 2001-07-17
%%
Type: redundant
Tag: en-boont
Description: Boontling
Added: 2003-02-14
%%
Type: redundant
Tag: en-scouse
Description: Scouse
Added: 2000-05-25
%%
Type: redundant
Tag: es-419
Description: Latin American Spanish
Added: 2005-07-15
%%
Type: redundant
Tag: iu-Cans
Description: Inuktitut in Canadian Aboriginal Syllabic script
Added: 2005-02-17
%%
Type: redundant
Tag: iu-Latn
Description: Inuktitut in Latin script
Added: 2005-02-17
%%
Type: redundant
Tag: mn-Cyrl
Description: Mongolian in Cyrillic script
Added: 2005-02-17
%%
Type: redundant
Tag: mn-Mong
Description: Mongolian in Mongolian script
Added: 2005-02-17
%%
Type: redundant
Tag: sgn-BR
Description: Brazilian Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: bzs
%%
Type: redundant
Tag: sgn-CO
Description: Colombian Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: csn
%%
Type: redundant
Tag: sgn-DE
Description: German Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: gsg
%%
Type: redundant
Tag: sgn-DK
Description: Danish Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: dsl
%%
Type: redundant
Tag: sgn-ES
Description: Spanish Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: ssp
%%
Type: redundant
Tag: sgn-FR
Description: French Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: fsl
%%
Type: redundant
Tag: sgn-GB
Description: British Sign Language
Added: 2001-03-02
Deprecated: 2009-07-29
Preferred-Value: bfi
%%
Type: redundant
Tag: sgn-GR
Description: Greek Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: gss
%%
Type: redundant
Tag: sgn-IE
Description: Irish Sign Language
Added: 2001-03-02
Deprecated: 2009-07-29
Preferred-Value: isg
%%
Type: redundant
Tag: sgn-IT
Description: Italian Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: ise
%%
Type: redundant
Tag: sgn-JP
Description: Japanese Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: jsl
%%
Type: redundant
Tag: sgn-MX
Description: Mexican Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: mfs
%%
Type: redundant
Tag: sgn-NI
Description: Nicaraguan Sign Language
Added: 2001-03-02
Deprecated: 2009-07-29
Preferred-Value: ncs
%%
Type: redundant
Tag: sgn-NL
Description: Dutch Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: dse
%%
Type: redundant
Tag: sgn-NO
Description: Norwegian Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: nsl
%%
Type: redundant
Tag: sgn-PT
Description: Portuguese Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: psr
%%
Type: redundant
Tag: sgn-SE
Description: Swedish Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: swl
%%
Type: redundant
Tag: sgn-US
Description: American Sign Language
Added: 2001-03-02
Deprecated: 2009-07-29
Preferred-Value: ase
%%
Type: redundant
Tag: sgn-ZA
Description: South African Sign Language
Added: 2001-11-11
Deprecated: 2009-07-29
Preferred-Value: sfs
%%
Type: redundant
Tag: sl-nedis
Description: Natisone dialect, Nadiza dialect
Added: 2004-06-01
%%
Type: redundant
Tag: sl-rozaj
Description: Resian, Resianic, Rezijan
Added: 2003-10-09
%%
Type: redundant
Tag: sr-Cyrl
Description: Serbian in Cyrillic script
Added: 2003-05-30
%%
Type: redundant
Tag: sr-Latn
Description: Serbian in Latin script
Added: 2003-05-30
%%
Type: redundant
Tag: tg-Arab
Description: Tajik in Arabic script
Added: 2005-02-17
%%
Type: redundant
Tag: tg-Cyrl
Description: Tajik in Cyrillic script
Added: 2005-02-17
%%
Type: redundant
Tag: uz-Cyrl
Description: Uzbek in Cyrillic script
Added: 2003-05-30
%%
Type: redundant
Tag: uz-Latn
Description: Uzbek in Latin script
Added: 2003-05-30
%%
Type: redundant
Tag: yi-Latn
Description: Yiddish, in Latin script
Added: 2003-01-07
%%
Type: redundant
Tag: zh-cmn
Description: Mandarin Chinese
Added: 2005-07-15
Deprecated: 2009-07-29
Preferred-Value: cmn
%%
Type: redundant
Tag: zh-cmn-Hans
Description: Mandarin Chinese (Simplified)
Added: 2005-07-15
Deprecated: 2009-07-29
Preferred-Value: cmn-Hans
%%
Type: redundant
Tag: zh-cmn-Hant
Description: Mandarin Chinese (Traditional)
Added: 2005-07-15
Deprecated: 2009-07-29
Preferred-Value: cmn-Hant
%%
Type: redundant
Tag: zh-gan
Description: Kan or Gan
Added: 1999-12-18
Deprecated: 2009-07-29
Preferred-Value: gan
%%
Type: redundant
Tag: zh-Hans
Description: simplified Chinese
Added: 2003-05-30
%%
Type: redundant
Tag: zh-Hans-CN
Description: PRC Mainland Chinese in simplified script
Added: 2005-04-13
%%
Type: redundant
Tag: zh-Hans-HK
Description: Hong Kong Chinese in simplified script
Added: 2005-04-11
%%
Type: redundant
Tag: zh-Hans-MO
Description: Macao Chinese in simplified script
Added: 2005-04-11
%%
Type: redundant
Tag: zh-Hans-SG
Description: Singapore Chinese in simplified script
Added: 2005-04-11
%%
Type: redundant
Tag: zh-Hans-TW
Description: Taiwan Chinese in simplified script
Added: 2005-04-11
%%
Type: redundant
Tag: zh-Hant
Description: traditional Chinese
Added: 2003-05-30
%%
Type: redundant
Tag: zh-Hant-CN
Description: PRC Mainland Chinese in traditional script
Added: 2005-04-13
%%
Type: redundant
Tag: zh-Hant-HK
Description: Hong Kong Chinese in traditional script
Added: 2005-04-11
%%
Type: redundant
Tag: zh-Hant-MO
Description: Macao Chinese in traditional script
Added: 2005-04-11
%%
Type: redundant
Tag: zh-Hant-SG
Description: Singapore Chinese in traditional script
Added: 2005-04-11
%%
Type: redundant
Tag: zh-Hant-TW
Description: Taiwan Chinese in traditional script
Added: 2005-04-11
%%
Type: redundant
Tag: zh-wuu
Description: Shanghaiese or Wu
Added: 1999-12-18
Deprecated: 2009-07-29
Preferred-Value: wuu
%%
Type: redundant
Tag: zh-yue
Description: Cantonese
Added: 1999-12-18
Deprecated: 2009-07-29
Preferred-Value: yue
''';
