/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;

public class ScribeChannel {
    private static final String TAG = "ScribeChannel";
    @VisibleForTesting
    public static final String METHOD_IS_FEATURE_AVAILABLE = "Scribe.isFeatureAvailable";
    @VisibleForTesting
    public static final String METHOD_IS_STYLUS_HANDWRITING_AVAILABLE = "Scribe.isStylusHandwritingAvailable";
    @VisibleForTesting
    public static final String METHOD_START_STYLUS_HANDWRITING = "Scribe.startStylusHandwriting";
    public final MethodChannel channel;
    private ScribeMethodHandler scribeMethodHandler;
    @NonNull
    public final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (ScribeChannel.this.scribeMethodHandler == null) {
                Log.v(ScribeChannel.TAG, "No ScribeMethodHandler registered. Scribe call not handled.");
                return;
            }
            String method = call.method;
            Log.v(ScribeChannel.TAG, "Received '" + method + "' message.");
            switch (method) {
                case "Scribe.isFeatureAvailable": {
                    ScribeChannel.this.isFeatureAvailable(call, result);
                    break;
                }
                case "Scribe.isStylusHandwritingAvailable": {
                    ScribeChannel.this.isStylusHandwritingAvailable(call, result);
                    break;
                }
                case "Scribe.startStylusHandwriting": {
                    ScribeChannel.this.startStylusHandwriting(call, result);
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    private void isFeatureAvailable(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        try {
            boolean isAvailable = this.scribeMethodHandler.isFeatureAvailable();
            result.success(isAvailable);
        }
        catch (IllegalStateException exception) {
            result.error("error", exception.getMessage(), null);
        }
    }

    private void isStylusHandwritingAvailable(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 34) {
            result.error("error", "Requires API level 34 or higher.", null);
            return;
        }
        try {
            boolean isAvailable = this.scribeMethodHandler.isStylusHandwritingAvailable();
            result.success(isAvailable);
        }
        catch (IllegalStateException exception) {
            result.error("error", exception.getMessage(), null);
        }
    }

    private void startStylusHandwriting(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
        if (Build.VERSION.SDK_INT < 33) {
            result.error("error", "Requires API level 33 or higher.", null);
            return;
        }
        try {
            this.scribeMethodHandler.startStylusHandwriting();
            result.success(null);
        }
        catch (IllegalStateException exception) {
            result.error("error", exception.getMessage(), null);
        }
    }

    public ScribeChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/scribe", JSONMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
    }

    public void setScribeMethodHandler(@Nullable ScribeMethodHandler scribeMethodHandler) {
        this.scribeMethodHandler = scribeMethodHandler;
    }

    public static interface ScribeMethodHandler {
        public boolean isFeatureAvailable();

        @RequiresApi(value=34)
        public boolean isStylusHandwritingAvailable();

        @RequiresApi(value=33)
        public void startStylusHandwriting();
    }
}

