// Copyright (c) 2025, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:developer';
import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/issue_59653_test.dart
//
const LINE_A = 36;
// AUTOGENERATED END

abstract interface class SharedTypeStructure {}

extension type SharedTypeSchemaView<TypeStructure extends SharedTypeStructure>(
    TypeStructure _typeStructure) implements Object {}

class C extends SharedTypeStructure {
  @override
  String toString() => 'C!';
}

class ClassWithTypeAnalyzer<TypeStructure extends SharedTypeStructure> {
  SharedTypeSchemaView<TypeStructure> dispatchExpression(
    SharedTypeSchemaView<TypeStructure> schema,
  ) {
    return schema;
  }

  void analyzeExpression(SharedTypeSchemaView<TypeStructure> schema) {
    debugger(); // LINE_A
  }
}

void code() {
  final classWithTypeAnalyzer = ClassWithTypeAnalyzer<C>();
  classWithTypeAnalyzer.analyzeExpression(SharedTypeSchemaView(C()));
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  testExpressionEvaluationAndAvailableVariables('analyzeExpression', [
    'this',
    'schema',
  ], [
    ('1', '1'),
    ('dispatchExpression(schema).toString()', 'C!'),
  ]),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'issue_59653_test.dart',
      testeeConcurrent: code,
      pauseOnStart: false,
      pauseOnExit: true,
    );
