// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:developer';
import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/issue_59661_test.dart
//
const LINE_CLASS_A = 27;
const LINE_CLASS_A_NAMED = 32;
const LINE_CLASS_A_NAMED2_BREAK_1 = 38;
const LINE_CLASS_A_NAMED2_BREAK_2 = 41;
const LINE_CLASS_A_NAMED2_BREAK_3 = 44;
const LINE_CLASS_B = 53;
// AUTOGENERATED END

class A {
  List list;
  A(this.list) {
    list = [3];
    debugger(); // LINE_CLASS_A
    print(list);
  }
  A.named(this.list) {
    list = [4];
    debugger(); // LINE_CLASS_A_NAMED
    print(list);
  }
  A.named2(this.list) {
    {
      final list = [5];
      debugger(); // LINE_CLASS_A_NAMED2_BREAK_1
      print(list);
    }
    debugger(); // LINE_CLASS_A_NAMED2_BREAK_2
    print(list);
    list = [6];
    debugger(); // LINE_CLASS_A_NAMED2_BREAK_3
    print(list);
  }
  A.noDebugger(this.list);
}

class B extends A {
  B(super.list) : super.noDebugger() {
    list = [7];
    debugger(); // LINE_CLASS_B
    print(list);
  }
}

void code() {
  A([1, 2]);
  A.named([1, 2]);
  A.named2([1, 2]);
  B([1, 2]);
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_CLASS_A),
  testExpressionEvaluationAndAvailableVariables(
    'A',
    ['this'],
    [('list.toString()', '[3]')],
  ),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_CLASS_A_NAMED),
  testExpressionEvaluationAndAvailableVariables(
    'A.named',
    ['this'],
    [('list.toString()', '[4]')],
  ),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_CLASS_A_NAMED2_BREAK_1),
  testExpressionEvaluationAndAvailableVariables(
    'A.named2',
    ['this', 'list'],
    [
      ('list.toString()', '[5]'),
      ('this.list.toString()', '[1, 2]'),
    ],
  ),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_CLASS_A_NAMED2_BREAK_2),
  testExpressionEvaluationAndAvailableVariables(
    'A.named2',
    ['this'],
    [('list.toString()', '[1, 2]')],
  ),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_CLASS_A_NAMED2_BREAK_3),
  testExpressionEvaluationAndAvailableVariables(
    'A.named2',
    ['this'],
    [('list.toString()', '[6]')],
  ),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_CLASS_B),
  testExpressionEvaluationAndAvailableVariables(
    'B',
    ['this'],
    [('list.toString()', '[7]')],
  ),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'issue_59661_test.dart',
      testeeConcurrent: code,
      pauseOnStart: false,
      pauseOnExit: true,
    );
