// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/step_through_getter_test.dart
//
const LINE_A = 19;
// AUTOGENERATED END

const file = 'step_through_getter_test.dart';

void code() /* LINE_A */ {
  final bar = Bar();
  print(bar.barXYZ);
  print(bar.barXYZ2);
  print(fooXYZ);
  print(fooXYZ2);
}

String get fooXYZ => 'fooXYZ';

String get fooXYZ2 {
  final i = 42;
  return 'Hello, $i!';
}

class Bar {
  String get barXYZ => 'barXYZ';

  String get barXYZ2 {
    final i = 42;
    return 'Hello, $i!';
  }
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:10', // after 'code'
  '$file:${LINE_A + 1}:15', // on 'Bar'

  '$file:${LINE_A + 2}:13', // on 'barXYZ'
  '$file:${LINE_A + 16}:21', // on '=>' in 'get barXYZ => 'barXYZ';'
  '$file:${LINE_A + 16}:24', // on first '''
  '$file:${LINE_A + 2}:3', // on 'print'

  '$file:${LINE_A + 3}:13', // on 'barXYZ2'
  '$file:${LINE_A + 18}:22', // on '{' in 'get barXYZ2 {'
  '$file:${LINE_A + 19}:13', // on '='
  '$file:${LINE_A + 20}:24', // after ''', i.e. on ';'
  '$file:${LINE_A + 20}:5', // on 'return'
  '$file:${LINE_A + 3}:3', // on 'print'

  '$file:${LINE_A + 4}:9', // on 'fooXYZ'
  '$file:${LINE_A + 8}:19', // on '=>' in 'get fooXYZ => 'fooXYZ';'
  '$file:${LINE_A + 8}:22', // on first '''
  '$file:${LINE_A + 4}:3', // on 'print'

  '$file:${LINE_A + 5}:9', // on 'fooXYZ2'
  '$file:${LINE_A + 10}:20', // on '{'
  '$file:${LINE_A + 11}:11', // on '='
  '$file:${LINE_A + 12}:22', // after ''', i.e. on ';'
  '$file:${LINE_A + 12}:3', // on 'return'
  '$file:${LINE_A + 5}:3', // on 'print'

  '$file:${LINE_A + 6}:1', // on ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepIntoThroughProgramRecordingStops(stops),
  checkRecordedStops(
    stops,
    expected,
    debugPrint: true,
    debugPrintFile: file,
    debugPrintLine: LINE_A,
  ),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_getter_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
