// Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:convert';

import 'package:googleapis_auth/src/crypto/rsa_sign.dart';
import 'package:test/test.dart';

import '../test_utils.dart';

void main() {
  group('rsa-sha256-signer', () {
    final signer = RS256Signer(testPrivateKey);

    // NOTE:
    // The signatures can be regenerated via the openssl commandline utility:
    // $ cat plaintext | openssl dgst -sha256 -sign key.pem > ciphertext
    // e.g.
    // $ echo -n "hello world"|openssl dgst -sha256 -sign key.pem|hexdump -v -C
    // 00000000  59 9d 6f 81 c1 0f d6 f1  58 46 2d 4d c9 b8 69 1d
    // 00000010  b1 e0 e0 26 a4 de 49 d8  4f 5a ac db 81 ab 10 27
    // 00000020  3a f4 5a f8 bb da a9 84  be c7 5a fb b9 2e 0a 66
    // 00000030  8f 78 d5 cb c9 82 0b 57  36 fc bc 42 1b f5 fa 76
    // 00000040  b7 01 4c bc 2d b9 fe 20  55 62 f5 87 8c bc e3 58
    // 00000050  a6 c6 8a ef 16 c8 4a 85  01 6e df 05 43 c8 ef 35
    // 00000060  37 9f 1b 29 57 eb c7 93  89 75 f5 65 81 0a 6c 8c
    // 00000070  44 35 ad 73 89 90 53 42  26 f3 31 a9 06 f1 32 20
    // 00000080  48 a3 e1 68 3d 86 67 45  74 19 91 75 c9 28 ca 8b
    // 00000090  33 63 ed a2 b1 90 e6 e1  0a 1f 87 ec 02 f8 92 03
    // 000000a0  cf 0e 30 49 b0 f1 72 29  a3 9c 2e cc 7c 87 65 11
    // 000000b0  1f 38 34 d3 3e fe af 8e  31 f0 10 1f f5 71 dd 90
    // 000000c0  f6 c7 ba 5d 10 0c 63 eb  a4 3c a5 17 9a 99 52 2d
    // 000000d0  b6 27 96 8c e2 44 63 35  1f 04 6f b8 31 e6 d4 47
    // 000000e0  31 0d 3c 36 6c bf 14 df  dc 2d 53 c7 ca d1 ec 6d
    // 000000f0  95 37 2f 86 14 da 6c 04  a1 fd 45 fa 95 e0 04 bf
    test('encrypt-hello-world', () {
      expect(
          signer.sign(ascii.encode('hello world')),
          equals([
            89, 157, 111, 129, 193, 15, 214, 241, 88, 70, 45, 77, 201, 184, //!!
            105, 29, 177, 224, 224, 38, 164, 222, 73, 216, 79, 90, 172, 219,
            129, 171, 16, 39, 58, 244, 90, 248, 187, 218, 169, 132, 190, 199,
            90, 251, 185, 46, 10, 102, 143, 120, 213, 203, 201, 130, 11, 87, 54,
            252, 188, 66, 27, 245, 250, 118, 183, 1, 76, 188, 45, 185, 254, 32,
            85, 98, 245, 135, 140, 188, 227, 88, 166, 198, 138, 239, 22,
            200, 74, 133, 1, 110, 223, 5, 67, 200, 239, 53, 55, 159, 27, 41, 87,
            235, 199, 147, 137, 117, 245, 101, 129, 10, 108, 140, 68, 53, 173,
            115, 137, 144, 83, 66, 38, 243, 49, 169, 6, 241, 50, 32, 72, 163,
            225, 104, 61, 134, 103, 69, 116, 25, 145, 117, 201, 40, 202, 139,
            51, 99, 237, 162, 177, 144, 230, 225, 10, 31, 135, 236, 2, 248, 146,
            3, 207, 14, 48, 73, 176, 241, 114, 41, 163, 156, 46, 204, 124, 135,
            101, 17, 31, 56, 52, 211, 62, 254, 175, 142, 49, 240, 16, 31, 245,
            113, 221, 144, 246, 199, 186, 93, 16, 12, 99, 235, 164, 60, 165, 23,
            154, 153, 82, 45, 182, 39, 150, 140, 226, 68, 99, 53, 31, 4, 111,
            184, 49, 230, 212, 71, 49, 13, 60, 54, 108, 191, 20, 223, 220, 45,
            83, 199, 202, 209, 236, 109, 149, 55, 47, 134, 20, 218, 108, 4, 161,
            253, 69, 250, 149, 224, 4, 191
          ]));
    });

    // $ echo -n ""|openssl dgst -sha256 -sign key.pem|hexdump -v -C
    test('null-bytes', () {
      expect(
          signer.sign([]),
          equals([
            113, 99, 2, 245, 156, 215, 253, 172, 157, 46, 126, 165, 174, //!!
            158, 186, 213, 211, 85, 118, 63, 208, 122, 196, 214, 154, 221, 92,
            105, 27, 29, 153, 35, 91, 111, 5, 10, 82, 213, 179, 41, 165, 122,
            227, 145, 217, 108, 249, 153, 116, 80, 140, 238, 158, 140, 142, 118,
            224, 10, 225, 58, 77, 210, 27, 66, 177, 165, 228, 40, 225, 211, 140,
            254, 31, 242, 230, 223, 21, 199, 221, 113, 146, 46, 213, 20, 63,
            148, 140, 144, 245, 105, 193, 124, 206, 235, 191, 252, 138, 155,
            148, 175, 185, 160, 98, 102, 156, 197, 29, 80, 202, 49, 26, 173,
            176, 53, 202, 13, 204, 180, 180, 190, 152, 223, 199, 65, 9, 173, 82,
            167, 12, 244, 127, 141, 8, 103, 155, 213, 2, 53, 83, 179, 157, 101,
            190, 205, 85, 58, 50, 89, 255, 11, 67, 18, 232, 252, 229, 197, 200,
            228, 130, 104, 250, 228, 19, 178, 183, 45, 156, 22, 73, 229, 170,
            163, 179, 116, 21, 149, 31, 81, 253, 100, 132, 46, 216, 143, 134,
            185, 96, 75, 57, 139, 21, 131, 114, 221, 124, 47, 104, 92, 235, 254,
            62, 69, 126, 117, 170, 141, 64, 121, 181, 101, 69, 135, 115, 102,
            74, 157, 233, 127, 139, 14, 79, 137, 156, 248, 117, 114, 205, 142,
            60, 8, 116, 77, 182, 28, 119, 149, 143, 252, 141, 46, 111, 100, 242,
            184, 21, 130, 61, 138, 27, 226, 70, 119, 195, 223, 180, 121
          ]));
    });
  });
}
