// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/// The list of test cases from:
/// - https://www.unicode.org/Public/13.0.0/ucd/auxiliary/LineBreakTest.txt
const String rawLineBreakTestData = '''
× 0023 × 0023 ÷	#  × [0.3] NUMBER SIGN (AL) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 0023 × 0020 ÷ 0023 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0023 × 0308 × 0023 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0023 ÷ 2014 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0023 × 0020 ÷ 2014 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0023 × 0308 ÷ 2014 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0023 × 0009 ÷	#  × [0.3] NUMBER SIGN (AL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0023 × 0020 ÷ 0009 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0023 × 0308 × 0009 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0023 ÷ 00B4 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0023 × 0020 ÷ 00B4 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0023 × 0308 ÷ 00B4 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0023 × 000B ÷	#  × [0.3] NUMBER SIGN (AL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0023 × 0020 × 000B ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0023 × 0308 × 000B ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0023 × 0308 × 0020 × 000B ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0023 ÷ FFFC ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0023 × 0020 ÷ FFFC ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0023 × 0308 ÷ FFFC ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0023 × 007D ÷	#  × [0.3] NUMBER SIGN (AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0023 × 0020 × 007D ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0023 × 0308 × 007D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0023 × 0308 × 0020 × 007D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0023 × 000D ÷	#  × [0.3] NUMBER SIGN (AL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0023 × 0020 × 000D ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0023 × 0308 × 000D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0023 × 0308 × 0020 × 000D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0023 × 0021 ÷	#  × [0.3] NUMBER SIGN (AL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0023 × 0020 × 0021 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0023 × 0308 × 0021 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0023 × 0308 × 0020 × 0021 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0023 × 00A0 ÷	#  × [0.3] NUMBER SIGN (AL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0023 × 0020 ÷ 00A0 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0023 × 0308 × 00A0 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0023 ÷ AC00 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0023 × 0020 ÷ AC00 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0023 × 0308 ÷ AC00 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0023 ÷ AC01 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0023 × 0020 ÷ AC01 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0023 × 0308 ÷ AC01 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0023 × 05D0 ÷	#  × [0.3] NUMBER SIGN (AL) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0023 × 0020 ÷ 05D0 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0023 × 0308 × 05D0 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0023 × 002D ÷	#  × [0.3] NUMBER SIGN (AL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0023 × 0020 ÷ 002D ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0023 × 0308 × 002D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0023 ÷ 231A ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0023 × 0020 ÷ 231A ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0023 × 0308 ÷ 231A ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0023 × 2024 ÷	#  × [0.3] NUMBER SIGN (AL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0023 × 0020 ÷ 2024 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0023 × 0308 × 2024 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0023 × 002C ÷	#  × [0.3] NUMBER SIGN (AL) × [13.02] COMMA (IS) ÷ [0.3]
× 0023 × 0020 × 002C ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0023 × 0308 × 002C ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0023 × 0308 × 0020 × 002C ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0023 ÷ 1100 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0023 × 0020 ÷ 1100 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0023 × 0308 ÷ 1100 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0023 ÷ 11A8 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0023 × 0020 ÷ 11A8 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0023 × 0308 ÷ 11A8 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0023 ÷ 1160 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0023 × 0020 ÷ 1160 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0023 × 0308 ÷ 1160 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0023 × 000A ÷	#  × [0.3] NUMBER SIGN (AL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0023 × 0020 × 000A ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0023 × 0308 × 000A ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0023 × 0308 × 0020 × 000A ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0023 × 0085 ÷	#  × [0.3] NUMBER SIGN (AL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0023 × 0020 × 0085 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0023 × 0308 × 0085 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0023 × 0308 × 0020 × 0085 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0023 × 17D6 ÷	#  × [0.3] NUMBER SIGN (AL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0023 × 0020 ÷ 17D6 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0023 × 0308 × 17D6 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0023 × 0030 ÷	#  × [0.3] NUMBER SIGN (AL) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0023 × 0020 ÷ 0030 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0023 × 0308 × 0030 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0023 ÷ 2329 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0023 × 0020 ÷ 2329 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0023 × 0308 ÷ 2329 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0023 × 0025 ÷	#  × [0.3] NUMBER SIGN (AL) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 0023 × 0020 ÷ 0025 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0023 × 0308 × 0025 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0023 × 0024 ÷	#  × [0.3] NUMBER SIGN (AL) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 0023 × 0020 ÷ 0024 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0023 × 0308 × 0024 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0023 × 0022 ÷	#  × [0.3] NUMBER SIGN (AL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0023 × 0020 ÷ 0022 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0023 × 0308 × 0022 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0023 × 0020 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [0.3]
× 0023 × 0020 × 0020 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0023 × 0308 × 0020 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0023 × 0308 × 0020 × 0020 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0023 × 002F ÷	#  × [0.3] NUMBER SIGN (AL) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0023 × 0020 × 002F ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0023 × 0308 × 002F ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0023 × 0308 × 0020 × 002F ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0023 × 2060 ÷	#  × [0.3] NUMBER SIGN (AL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0023 × 0020 × 2060 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0023 × 0308 × 2060 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0023 × 0308 × 0020 × 2060 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0023 × 200B ÷	#  × [0.3] NUMBER SIGN (AL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0023 × 0020 × 200B ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0023 × 0308 × 200B ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0023 × 0308 × 0020 × 200B ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0023 ÷ 1F1E6 ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0023 × 0020 ÷ 1F1E6 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0023 × 0308 ÷ 1F1E6 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0023 ÷ 261D ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0023 × 0020 ÷ 261D ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0023 × 0308 ÷ 261D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0023 ÷ 1F3FB ÷	#  × [0.3] NUMBER SIGN (AL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0023 × 0020 ÷ 1F3FB ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0023 × 0308 ÷ 1F3FB ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0023 × 0029 ÷	#  × [0.3] NUMBER SIGN (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0023 × 0020 × 0029 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0023 × 0308 × 0029 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0023 × 0308 × 0020 × 0029 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0023 × 0028 ÷	#  × [0.3] NUMBER SIGN (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0023 × 0020 ÷ 0028 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0023 × 0308 × 0028 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0023 × 0001 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0023 × 0020 ÷ 0001 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0023 × 0308 × 0001 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0023 × 200D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0023 × 0020 ÷ 200D ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0023 × 0308 × 200D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0023 × 00A7 ÷	#  × [0.3] NUMBER SIGN (AL) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0023 × 0020 ÷ 00A7 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0023 × 0308 × 00A7 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0023 × 50005 ÷	#  × [0.3] NUMBER SIGN (AL) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0023 × 0020 ÷ 50005 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0023 × 0308 × 50005 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0023 × 0E01 ÷	#  × [0.3] NUMBER SIGN (AL) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0023 × 0020 ÷ 0E01 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0023 × 0308 × 0E01 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0023 × 3041 ÷	#  × [0.3] NUMBER SIGN (AL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0023 × 0020 ÷ 3041 ÷	#  × [0.3] NUMBER SIGN (AL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0023 × 0308 × 3041 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0023 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] NUMBER SIGN (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2014 ÷ 0023 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 2014 × 0020 ÷ 0023 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 2014 × 0308 ÷ 0023 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 2014 × 2014 ÷	#  × [0.3] EM DASH (B2) × [17.0] EM DASH (B2) ÷ [0.3]
× 2014 × 0020 × 2014 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [17.0] EM DASH (B2) ÷ [0.3]
× 2014 × 0308 × 2014 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [17.0] EM DASH (B2) ÷ [0.3]
× 2014 × 0308 × 0020 × 2014 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [17.0] EM DASH (B2) ÷ [0.3]
× 2014 × 0009 ÷	#  × [0.3] EM DASH (B2) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2014 × 0020 ÷ 0009 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2014 × 0308 × 0009 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2014 ÷ 00B4 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2014 × 0020 ÷ 00B4 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2014 × 0308 ÷ 00B4 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2014 × 000B ÷	#  × [0.3] EM DASH (B2) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2014 × 0020 × 000B ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2014 × 0308 × 000B ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2014 × 0308 × 0020 × 000B ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2014 ÷ FFFC ÷	#  × [0.3] EM DASH (B2) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2014 × 0020 ÷ FFFC ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2014 × 0308 ÷ FFFC ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2014 × 007D ÷	#  × [0.3] EM DASH (B2) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2014 × 0020 × 007D ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2014 × 0308 × 007D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2014 × 0308 × 0020 × 007D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2014 × 000D ÷	#  × [0.3] EM DASH (B2) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2014 × 0020 × 000D ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2014 × 0308 × 000D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2014 × 0308 × 0020 × 000D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2014 × 0021 ÷	#  × [0.3] EM DASH (B2) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2014 × 0020 × 0021 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2014 × 0308 × 0021 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2014 × 0308 × 0020 × 0021 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2014 × 00A0 ÷	#  × [0.3] EM DASH (B2) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 2014 × 0020 ÷ 00A0 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 2014 × 0308 × 00A0 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 2014 ÷ AC00 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2014 × 0020 ÷ AC00 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2014 × 0308 ÷ AC00 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2014 ÷ AC01 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2014 × 0020 ÷ AC01 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2014 × 0308 ÷ AC01 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2014 ÷ 05D0 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2014 × 0020 ÷ 05D0 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2014 × 0308 ÷ 05D0 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2014 × 002D ÷	#  × [0.3] EM DASH (B2) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 2014 × 0020 ÷ 002D ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2014 × 0308 × 002D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2014 ÷ 231A ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 2014 × 0020 ÷ 231A ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 2014 × 0308 ÷ 231A ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 2014 × 2024 ÷	#  × [0.3] EM DASH (B2) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2014 × 0020 ÷ 2024 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2014 × 0308 × 2024 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2014 × 002C ÷	#  × [0.3] EM DASH (B2) × [13.02] COMMA (IS) ÷ [0.3]
× 2014 × 0020 × 002C ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 2014 × 0308 × 002C ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 2014 × 0308 × 0020 × 002C ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 2014 ÷ 1100 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2014 × 0020 ÷ 1100 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2014 × 0308 ÷ 1100 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2014 ÷ 11A8 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2014 × 0020 ÷ 11A8 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2014 × 0308 ÷ 11A8 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2014 ÷ 1160 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2014 × 0020 ÷ 1160 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2014 × 0308 ÷ 1160 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2014 × 000A ÷	#  × [0.3] EM DASH (B2) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2014 × 0020 × 000A ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2014 × 0308 × 000A ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2014 × 0308 × 0020 × 000A ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2014 × 0085 ÷	#  × [0.3] EM DASH (B2) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2014 × 0020 × 0085 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2014 × 0308 × 0085 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2014 × 0308 × 0020 × 0085 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2014 × 17D6 ÷	#  × [0.3] EM DASH (B2) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2014 × 0020 ÷ 17D6 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2014 × 0308 × 17D6 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2014 ÷ 0030 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 2014 × 0020 ÷ 0030 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 2014 × 0308 ÷ 0030 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 2014 ÷ 2329 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2014 × 0020 ÷ 2329 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2014 × 0308 ÷ 2329 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2014 ÷ 0025 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 2014 × 0020 ÷ 0025 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 2014 × 0308 ÷ 0025 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 2014 ÷ 0024 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2014 × 0020 ÷ 0024 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2014 × 0308 ÷ 0024 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2014 × 0022 ÷	#  × [0.3] EM DASH (B2) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 2014 × 0020 ÷ 0022 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 2014 × 0308 × 0022 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 2014 × 0020 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [0.3]
× 2014 × 0020 × 0020 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 2014 × 0308 × 0020 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 2014 × 0308 × 0020 × 0020 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 2014 × 002F ÷	#  × [0.3] EM DASH (B2) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2014 × 0020 × 002F ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2014 × 0308 × 002F ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 2014 × 0308 × 0020 × 002F ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2014 × 2060 ÷	#  × [0.3] EM DASH (B2) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2014 × 0020 × 2060 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2014 × 0308 × 2060 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2014 × 0308 × 0020 × 2060 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2014 × 200B ÷	#  × [0.3] EM DASH (B2) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2014 × 0020 × 200B ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2014 × 0308 × 200B ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2014 × 0308 × 0020 × 200B ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2014 ÷ 1F1E6 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2014 × 0020 ÷ 1F1E6 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2014 × 0308 ÷ 1F1E6 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2014 ÷ 261D ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2014 × 0020 ÷ 261D ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2014 × 0308 ÷ 261D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2014 ÷ 1F3FB ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2014 × 0020 ÷ 1F3FB ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2014 × 0308 ÷ 1F3FB ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2014 × 0029 ÷	#  × [0.3] EM DASH (B2) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2014 × 0020 × 0029 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2014 × 0308 × 0029 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2014 × 0308 × 0020 × 0029 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2014 ÷ 0028 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2014 × 0020 ÷ 0028 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2014 × 0308 ÷ 0028 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2014 × 0001 ÷	#  × [0.3] EM DASH (B2) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2014 × 0020 ÷ 0001 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2014 × 0308 × 0001 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2014 × 200D ÷	#  × [0.3] EM DASH (B2) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2014 × 0020 ÷ 200D ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2014 × 0308 × 200D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2014 ÷ 00A7 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2014 × 0020 ÷ 00A7 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2014 × 0308 ÷ 00A7 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2014 ÷ 50005 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2014 × 0020 ÷ 50005 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2014 × 0308 ÷ 50005 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2014 ÷ 0E01 ÷	#  × [0.3] EM DASH (B2) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2014 × 0020 ÷ 0E01 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2014 × 0308 ÷ 0E01 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2014 × 3041 ÷	#  × [0.3] EM DASH (B2) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2014 × 0020 ÷ 3041 ÷	#  × [0.3] EM DASH (B2) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2014 × 0308 × 3041 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2014 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] EM DASH (B2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0009 ÷ 0023 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 0009 × 0020 ÷ 0023 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0009 × 0308 ÷ 0023 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0009 ÷ 2014 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0009 × 0020 ÷ 2014 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0009 × 0308 ÷ 2014 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0009 × 0009 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0009 × 0020 ÷ 0009 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0009 × 0308 × 0009 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0009 ÷ 00B4 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0009 × 0020 ÷ 00B4 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0009 × 0308 ÷ 00B4 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0009 × 000B ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0009 × 0020 × 000B ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0009 × 0308 × 000B ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0009 × 0308 × 0020 × 000B ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0009 ÷ FFFC ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0009 × 0020 ÷ FFFC ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0009 × 0308 ÷ FFFC ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0009 × 007D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0009 × 0020 × 007D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0009 × 0308 × 007D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0009 × 0308 × 0020 × 007D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0009 × 000D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0009 × 0020 × 000D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0009 × 0308 × 000D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0009 × 0308 × 0020 × 000D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0009 × 0021 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0009 × 0020 × 0021 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0009 × 0308 × 0021 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0009 × 0308 × 0020 × 0021 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0009 ÷ 00A0 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0009 × 0020 ÷ 00A0 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0009 × 0308 ÷ 00A0 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0009 ÷ AC00 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0009 × 0020 ÷ AC00 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0009 × 0308 ÷ AC00 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0009 ÷ AC01 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0009 × 0020 ÷ AC01 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0009 × 0308 ÷ AC01 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0009 ÷ 05D0 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0009 × 0020 ÷ 05D0 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0009 × 0308 ÷ 05D0 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0009 × 002D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0009 × 0020 ÷ 002D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0009 × 0308 × 002D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0009 ÷ 231A ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0009 × 0020 ÷ 231A ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0009 × 0308 ÷ 231A ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0009 × 2024 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0009 × 0020 ÷ 2024 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0009 × 0308 × 2024 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0009 × 002C ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [13.02] COMMA (IS) ÷ [0.3]
× 0009 × 0020 × 002C ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0009 × 0308 × 002C ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0009 × 0308 × 0020 × 002C ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0009 ÷ 1100 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0009 × 0020 ÷ 1100 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0009 × 0308 ÷ 1100 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0009 ÷ 11A8 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0009 × 0020 ÷ 11A8 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0009 × 0308 ÷ 11A8 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0009 ÷ 1160 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0009 × 0020 ÷ 1160 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0009 × 0308 ÷ 1160 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0009 × 000A ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0009 × 0020 × 000A ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0009 × 0308 × 000A ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0009 × 0308 × 0020 × 000A ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0009 × 0085 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0009 × 0020 × 0085 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0009 × 0308 × 0085 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0009 × 0308 × 0020 × 0085 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0009 × 17D6 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0009 × 0020 ÷ 17D6 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0009 × 0308 × 17D6 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0009 ÷ 0030 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 0009 × 0020 ÷ 0030 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0009 × 0308 ÷ 0030 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0009 ÷ 2329 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0009 × 0020 ÷ 2329 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0009 × 0308 ÷ 2329 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0009 ÷ 0025 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0009 × 0020 ÷ 0025 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0009 × 0308 ÷ 0025 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0009 ÷ 0024 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0009 × 0020 ÷ 0024 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0009 × 0308 ÷ 0024 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0009 × 0022 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0009 × 0020 ÷ 0022 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0009 × 0308 × 0022 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0009 × 0020 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [0.3]
× 0009 × 0020 × 0020 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0009 × 0308 × 0020 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0009 × 0308 × 0020 × 0020 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0009 × 002F ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0009 × 0020 × 002F ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0009 × 0308 × 002F ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0009 × 0308 × 0020 × 002F ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0009 × 2060 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0009 × 0020 × 2060 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0009 × 0308 × 2060 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0009 × 0308 × 0020 × 2060 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0009 × 200B ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0009 × 0020 × 200B ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0009 × 0308 × 200B ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0009 × 0308 × 0020 × 200B ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0009 ÷ 1F1E6 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0009 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0009 × 0308 ÷ 1F1E6 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0009 ÷ 261D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0009 × 0020 ÷ 261D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0009 × 0308 ÷ 261D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0009 ÷ 1F3FB ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0009 × 0020 ÷ 1F3FB ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0009 × 0308 ÷ 1F3FB ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0009 × 0029 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0009 × 0020 × 0029 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0009 × 0308 × 0029 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0009 × 0308 × 0020 × 0029 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0009 ÷ 0028 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0009 × 0020 ÷ 0028 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0009 × 0308 ÷ 0028 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0009 × 0001 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0009 × 0020 ÷ 0001 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0009 × 0308 × 0001 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0009 × 200D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0009 × 0020 ÷ 200D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0009 × 0308 × 200D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0009 ÷ 00A7 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0009 × 0020 ÷ 00A7 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0009 × 0308 ÷ 00A7 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0009 ÷ 50005 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0009 × 0020 ÷ 50005 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0009 × 0308 ÷ 50005 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0009 ÷ 0E01 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0009 × 0020 ÷ 0E01 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0009 × 0308 ÷ 0E01 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0009 × 3041 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0009 × 0020 ÷ 3041 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0009 × 0308 × 3041 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0009 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] <CHARACTER TABULATION> (BA) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00B4 × 0023 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] NUMBER SIGN (AL) ÷ [0.3]
× 00B4 × 0020 ÷ 0023 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 00B4 × 0308 × 0023 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] NUMBER SIGN (AL) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 00B4 × 2014 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] EM DASH (B2) ÷ [0.3]
× 00B4 × 0020 ÷ 2014 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 00B4 × 0308 × 2014 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] EM DASH (B2) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 00B4 × 0009 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00B4 × 0020 ÷ 0009 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00B4 × 0308 × 0009 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00B4 × 00B4 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] ACUTE ACCENT (BB) ÷ [0.3]
× 00B4 × 0020 ÷ 00B4 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00B4 × 0308 × 00B4 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] ACUTE ACCENT (BB) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00B4 × 000B ÷	#  × [0.3] ACUTE ACCENT (BB) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00B4 × 0020 × 000B ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00B4 × 0308 × 000B ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00B4 × 0308 × 0020 × 000B ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00B4 ÷ FFFC ÷	#  × [0.3] ACUTE ACCENT (BB) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00B4 × 0020 ÷ FFFC ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00B4 × 0308 ÷ FFFC ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00B4 × 007D ÷	#  × [0.3] ACUTE ACCENT (BB) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00B4 × 0020 × 007D ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00B4 × 0308 × 007D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00B4 × 0308 × 0020 × 007D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00B4 × 000D ÷	#  × [0.3] ACUTE ACCENT (BB) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00B4 × 0020 × 000D ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00B4 × 0308 × 000D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00B4 × 0308 × 0020 × 000D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00B4 × 0021 ÷	#  × [0.3] ACUTE ACCENT (BB) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00B4 × 0020 × 0021 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00B4 × 0308 × 0021 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00B4 × 0308 × 0020 × 0021 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00B4 × 00A0 ÷	#  × [0.3] ACUTE ACCENT (BB) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 00B4 × 0020 ÷ 00A0 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 00B4 × 0308 × 00A0 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 00B4 × AC00 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00B4 × 0020 ÷ AC00 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00B4 × 0308 × AC00 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00B4 × AC01 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00B4 × 0020 ÷ AC01 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00B4 × 0308 × AC01 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00B4 × 05D0 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00B4 × 0020 ÷ 05D0 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00B4 × 0308 × 05D0 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00B4 × 002D ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 00B4 × 0020 ÷ 002D ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 00B4 × 0308 × 002D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 00B4 × 231A ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] WATCH (ID) ÷ [0.3]
× 00B4 × 0020 ÷ 231A ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 00B4 × 0308 × 231A ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] WATCH (ID) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 00B4 × 2024 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] ONE DOT LEADER (IN) ÷ [0.3]
× 00B4 × 0020 ÷ 2024 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00B4 × 0308 × 2024 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] ONE DOT LEADER (IN) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00B4 × 002C ÷	#  × [0.3] ACUTE ACCENT (BB) × [13.02] COMMA (IS) ÷ [0.3]
× 00B4 × 0020 × 002C ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 00B4 × 0308 × 002C ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 00B4 × 0308 × 0020 × 002C ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 00B4 × 1100 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00B4 × 0020 ÷ 1100 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00B4 × 0308 × 1100 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00B4 × 11A8 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00B4 × 0020 ÷ 11A8 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00B4 × 0308 × 11A8 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00B4 × 1160 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00B4 × 0020 ÷ 1160 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00B4 × 0308 × 1160 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00B4 × 000A ÷	#  × [0.3] ACUTE ACCENT (BB) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00B4 × 0020 × 000A ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00B4 × 0308 × 000A ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00B4 × 0308 × 0020 × 000A ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00B4 × 0085 ÷	#  × [0.3] ACUTE ACCENT (BB) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00B4 × 0020 × 0085 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00B4 × 0308 × 0085 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00B4 × 0308 × 0020 × 0085 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00B4 × 17D6 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00B4 × 0020 ÷ 17D6 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00B4 × 0308 × 17D6 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00B4 × 0030 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] DIGIT ZERO (NU) ÷ [0.3]
× 00B4 × 0020 ÷ 0030 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 00B4 × 0308 × 0030 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] DIGIT ZERO (NU) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 00B4 × 2329 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00B4 × 0020 ÷ 2329 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00B4 × 0308 × 2329 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00B4 × 0025 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] PERCENT SIGN (PO) ÷ [0.3]
× 00B4 × 0020 ÷ 0025 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 00B4 × 0308 × 0025 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] PERCENT SIGN (PO) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 00B4 × 0024 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] DOLLAR SIGN (PR) ÷ [0.3]
× 00B4 × 0020 ÷ 0024 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 00B4 × 0308 × 0024 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] DOLLAR SIGN (PR) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 00B4 × 0022 ÷	#  × [0.3] ACUTE ACCENT (BB) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 00B4 × 0020 ÷ 0022 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 00B4 × 0308 × 0022 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 00B4 × 0020 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [0.3]
× 00B4 × 0020 × 0020 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 00B4 × 0308 × 0020 × 0020 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 00B4 × 002F ÷	#  × [0.3] ACUTE ACCENT (BB) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 00B4 × 0020 × 002F ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 00B4 × 0308 × 002F ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 00B4 × 0308 × 0020 × 002F ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 00B4 × 2060 ÷	#  × [0.3] ACUTE ACCENT (BB) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00B4 × 0020 × 2060 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00B4 × 0308 × 2060 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00B4 × 0308 × 0020 × 2060 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00B4 × 200B ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00B4 × 0020 × 200B ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00B4 × 0308 × 200B ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00B4 × 0308 × 0020 × 200B ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00B4 × 1F1E6 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00B4 × 0020 ÷ 1F1E6 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00B4 × 0308 × 1F1E6 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00B4 × 261D ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00B4 × 0020 ÷ 261D ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00B4 × 0308 × 261D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00B4 × 1F3FB ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00B4 × 0020 ÷ 1F3FB ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00B4 × 0308 × 1F3FB ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00B4 × 0029 ÷	#  × [0.3] ACUTE ACCENT (BB) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00B4 × 0020 × 0029 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00B4 × 0308 × 0029 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00B4 × 0308 × 0020 × 0029 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00B4 × 0028 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00B4 × 0020 ÷ 0028 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00B4 × 0308 × 0028 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00B4 × 0001 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00B4 × 0020 ÷ 0001 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00B4 × 0308 × 0001 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00B4 × 200D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00B4 × 0020 ÷ 200D ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00B4 × 0308 × 200D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00B4 × 00A7 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] SECTION SIGN (AI_AL) ÷ [0.3]
× 00B4 × 0020 ÷ 00A7 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00B4 × 0308 × 00A7 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] SECTION SIGN (AI_AL) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00B4 × 50005 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] <reserved-50005> (XX_AL) ÷ [0.3]
× 00B4 × 0020 ÷ 50005 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00B4 × 0308 × 50005 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] <reserved-50005> (XX_AL) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00B4 × 0E01 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.04] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00B4 × 0020 ÷ 0E01 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00B4 × 0308 × 0E01 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.04] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00B4 × 3041 ÷	#  × [0.3] ACUTE ACCENT (BB) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00B4 × 0020 ÷ 3041 ÷	#  × [0.3] ACUTE ACCENT (BB) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00B4 × 0308 × 3041 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00B4 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] ACUTE ACCENT (BB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000B ÷ 0023 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] NUMBER SIGN (AL) ÷ [0.3]
× 000B ÷ 0020 ÷ 0023 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 000B ÷ 0308 × 0023 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0023 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 000B ÷ 2014 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] EM DASH (B2) ÷ [0.3]
× 000B ÷ 0020 ÷ 2014 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 000B ÷ 0308 ÷ 2014 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 2014 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 000B ÷ 0009 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000B ÷ 0020 ÷ 0009 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000B ÷ 0308 × 0009 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0009 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000B ÷ 00B4 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000B ÷ 0020 ÷ 00B4 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000B ÷ 0308 ÷ 00B4 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000B ÷ 000B ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000B ÷ 0020 × 000B ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000B ÷ 0308 × 000B ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 000B ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000B ÷ FFFC ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000B ÷ 0020 ÷ FFFC ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000B ÷ 0308 ÷ FFFC ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ FFFC ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000B ÷ 007D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000B ÷ 0020 × 007D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000B ÷ 0308 × 007D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 007D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000B ÷ 000D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000B ÷ 0020 × 000D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000B ÷ 0308 × 000D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 000D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000B ÷ 0021 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] EXCLAMATION MARK (EX) ÷ [0.3]
× 000B ÷ 0020 × 0021 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000B ÷ 0308 × 0021 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 0021 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000B ÷ 00A0 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 000B ÷ 0020 ÷ 00A0 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 000B ÷ 0308 × 00A0 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 000B ÷ AC00 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000B ÷ 0020 ÷ AC00 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000B ÷ 0308 ÷ AC00 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ AC00 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000B ÷ AC01 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000B ÷ 0020 ÷ AC01 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000B ÷ 0308 ÷ AC01 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ AC01 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000B ÷ 05D0 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000B ÷ 0020 ÷ 05D0 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000B ÷ 0308 × 05D0 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000B ÷ 002D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 000B ÷ 0020 ÷ 002D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 000B ÷ 0308 × 002D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 002D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 000B ÷ 231A ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] WATCH (ID) ÷ [0.3]
× 000B ÷ 0020 ÷ 231A ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 000B ÷ 0308 ÷ 231A ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 231A ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 000B ÷ 2024 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000B ÷ 0020 ÷ 2024 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000B ÷ 0308 × 2024 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 2024 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000B ÷ 002C ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMMA (IS) ÷ [0.3]
× 000B ÷ 0020 × 002C ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 000B ÷ 0308 × 002C ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 002C ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 000B ÷ 1100 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000B ÷ 0020 ÷ 1100 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000B ÷ 0308 ÷ 1100 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 1100 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000B ÷ 11A8 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000B ÷ 0020 ÷ 11A8 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000B ÷ 0308 ÷ 11A8 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000B ÷ 1160 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000B ÷ 0020 ÷ 1160 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000B ÷ 0308 ÷ 1160 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 1160 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000B ÷ 000A ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000B ÷ 0020 × 000A ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000B ÷ 0308 × 000A ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 000A ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000B ÷ 0085 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000B ÷ 0020 × 0085 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000B ÷ 0308 × 0085 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 0085 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000B ÷ 17D6 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000B ÷ 0020 ÷ 17D6 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000B ÷ 0308 × 17D6 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000B ÷ 0030 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] DIGIT ZERO (NU) ÷ [0.3]
× 000B ÷ 0020 ÷ 0030 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 000B ÷ 0308 × 0030 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0030 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 000B ÷ 2329 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000B ÷ 0020 ÷ 2329 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000B ÷ 0308 ÷ 2329 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 2329 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000B ÷ 0025 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] PERCENT SIGN (PO) ÷ [0.3]
× 000B ÷ 0020 ÷ 0025 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 000B ÷ 0308 × 0025 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0025 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 000B ÷ 0024 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] DOLLAR SIGN (PR) ÷ [0.3]
× 000B ÷ 0020 ÷ 0024 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 000B ÷ 0308 × 0024 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0024 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 000B ÷ 0022 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] QUOTATION MARK (QU) ÷ [0.3]
× 000B ÷ 0020 ÷ 0022 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 000B ÷ 0308 × 0022 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0022 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 000B ÷ 0020 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [0.3]
× 000B ÷ 0020 × 0020 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 0020 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 000B ÷ 002F ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SOLIDUS (SY) ÷ [0.3]
× 000B ÷ 0020 × 002F ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 000B ÷ 0308 × 002F ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 002F ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 000B ÷ 2060 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] WORD JOINER (WJ) ÷ [0.3]
× 000B ÷ 0020 × 2060 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000B ÷ 0308 × 2060 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 2060 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000B ÷ 200B ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000B ÷ 0020 × 200B ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000B ÷ 0308 × 200B ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 200B ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000B ÷ 1F1E6 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000B ÷ 0020 ÷ 1F1E6 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000B ÷ 0308 ÷ 1F1E6 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000B ÷ 261D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000B ÷ 0020 ÷ 261D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000B ÷ 0308 ÷ 261D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 261D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000B ÷ 1F3FB ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000B ÷ 0020 ÷ 1F3FB ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000B ÷ 0308 ÷ 1F3FB ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000B ÷ 0029 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000B ÷ 0020 × 0029 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000B ÷ 0308 × 0029 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000B ÷ 0308 × 0020 × 0029 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000B ÷ 0028 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000B ÷ 0020 ÷ 0028 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000B ÷ 0308 × 0028 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0028 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000B ÷ 0001 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000B ÷ 0020 ÷ 0001 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000B ÷ 0308 × 0001 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0001 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000B ÷ 200D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000B ÷ 0020 ÷ 200D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000B ÷ 0308 × 200D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 200D ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000B ÷ 00A7 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000B ÷ 0020 ÷ 00A7 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000B ÷ 0308 × 00A7 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000B ÷ 50005 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000B ÷ 0020 ÷ 50005 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000B ÷ 0308 × 50005 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 50005 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000B ÷ 0E01 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000B ÷ 0020 ÷ 0E01 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000B ÷ 0308 × 0E01 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000B ÷ 3041 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000B ÷ 0020 ÷ 3041 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000B ÷ 0308 × 3041 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000B ÷ 0308 × 0020 ÷ 3041 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× FFFC ÷ 0023 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] NUMBER SIGN (AL) ÷ [0.3]
× FFFC × 0020 ÷ 0023 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× FFFC × 0308 ÷ 0023 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] NUMBER SIGN (AL) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× FFFC ÷ 2014 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] EM DASH (B2) ÷ [0.3]
× FFFC × 0020 ÷ 2014 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× FFFC × 0308 ÷ 2014 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] EM DASH (B2) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× FFFC ÷ 0009 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
× FFFC × 0020 ÷ 0009 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× FFFC × 0308 ÷ 0009 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× FFFC ÷ 00B4 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] ACUTE ACCENT (BB) ÷ [0.3]
× FFFC × 0020 ÷ 00B4 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× FFFC × 0308 ÷ 00B4 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] ACUTE ACCENT (BB) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× FFFC × 000B ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× FFFC × 0020 × 000B ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× FFFC × 0308 × 000B ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× FFFC × 0308 × 0020 × 000B ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× FFFC ÷ FFFC ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× FFFC × 0020 ÷ FFFC ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× FFFC × 0308 ÷ FFFC ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× FFFC × 007D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× FFFC × 0020 × 007D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× FFFC × 0308 × 007D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× FFFC × 0308 × 0020 × 007D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× FFFC × 000D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× FFFC × 0020 × 000D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× FFFC × 0308 × 000D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× FFFC × 0308 × 0020 × 000D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× FFFC × 0021 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× FFFC × 0020 × 0021 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× FFFC × 0308 × 0021 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× FFFC × 0308 × 0020 × 0021 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× FFFC × 00A0 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× FFFC × 0020 ÷ 00A0 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× FFFC × 0308 × 00A0 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× FFFC ÷ AC00 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× FFFC × 0020 ÷ AC00 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× FFFC × 0308 ÷ AC00 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× FFFC ÷ AC01 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× FFFC × 0020 ÷ AC01 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× FFFC × 0308 ÷ AC01 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× FFFC ÷ 05D0 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× FFFC × 0020 ÷ 05D0 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× FFFC × 0308 ÷ 05D0 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× FFFC ÷ 002D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HYPHEN-MINUS (HY) ÷ [0.3]
× FFFC × 0020 ÷ 002D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× FFFC × 0308 ÷ 002D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HYPHEN-MINUS (HY) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 002D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× FFFC ÷ 231A ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] WATCH (ID) ÷ [0.3]
× FFFC × 0020 ÷ 231A ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× FFFC × 0308 ÷ 231A ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] WATCH (ID) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 231A ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× FFFC ÷ 2024 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] ONE DOT LEADER (IN) ÷ [0.3]
× FFFC × 0020 ÷ 2024 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× FFFC × 0308 ÷ 2024 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] ONE DOT LEADER (IN) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× FFFC × 002C ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.02] COMMA (IS) ÷ [0.3]
× FFFC × 0020 × 002C ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× FFFC × 0308 × 002C ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× FFFC × 0308 × 0020 × 002C ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× FFFC ÷ 1100 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× FFFC × 0020 ÷ 1100 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× FFFC × 0308 ÷ 1100 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× FFFC ÷ 11A8 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× FFFC × 0020 ÷ 11A8 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× FFFC × 0308 ÷ 11A8 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× FFFC ÷ 1160 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× FFFC × 0020 ÷ 1160 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× FFFC × 0308 ÷ 1160 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× FFFC × 000A ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× FFFC × 0020 × 000A ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× FFFC × 0308 × 000A ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× FFFC × 0308 × 0020 × 000A ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× FFFC × 0085 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× FFFC × 0020 × 0085 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× FFFC × 0308 × 0085 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× FFFC × 0308 × 0020 × 0085 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× FFFC ÷ 17D6 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× FFFC × 0020 ÷ 17D6 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× FFFC × 0308 ÷ 17D6 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× FFFC ÷ 0030 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] DIGIT ZERO (NU) ÷ [0.3]
× FFFC × 0020 ÷ 0030 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× FFFC × 0308 ÷ 0030 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] DIGIT ZERO (NU) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× FFFC ÷ 2329 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× FFFC × 0020 ÷ 2329 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× FFFC × 0308 ÷ 2329 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× FFFC ÷ 0025 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] PERCENT SIGN (PO) ÷ [0.3]
× FFFC × 0020 ÷ 0025 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× FFFC × 0308 ÷ 0025 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] PERCENT SIGN (PO) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× FFFC ÷ 0024 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] DOLLAR SIGN (PR) ÷ [0.3]
× FFFC × 0020 ÷ 0024 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× FFFC × 0308 ÷ 0024 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] DOLLAR SIGN (PR) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× FFFC × 0022 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× FFFC × 0020 ÷ 0022 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× FFFC × 0308 × 0022 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× FFFC × 0020 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [0.3]
× FFFC × 0020 × 0020 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× FFFC × 0308 × 0020 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× FFFC × 0308 × 0020 × 0020 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× FFFC × 002F ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.02] SOLIDUS (SY) ÷ [0.3]
× FFFC × 0020 × 002F ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× FFFC × 0308 × 002F ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× FFFC × 0308 × 0020 × 002F ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× FFFC × 2060 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× FFFC × 0020 × 2060 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× FFFC × 0308 × 2060 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× FFFC × 0308 × 0020 × 2060 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× FFFC × 200B ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× FFFC × 0020 × 200B ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× FFFC × 0308 × 200B ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× FFFC × 0308 × 0020 × 200B ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× FFFC ÷ 1F1E6 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× FFFC × 0020 ÷ 1F1E6 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× FFFC × 0308 ÷ 1F1E6 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× FFFC ÷ 261D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× FFFC × 0020 ÷ 261D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× FFFC × 0308 ÷ 261D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 261D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× FFFC ÷ 1F3FB ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× FFFC × 0020 ÷ 1F3FB ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× FFFC × 0308 ÷ 1F3FB ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× FFFC × 0029 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× FFFC × 0020 × 0029 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× FFFC × 0308 × 0029 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× FFFC × 0308 × 0020 × 0029 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× FFFC ÷ 0028 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× FFFC × 0020 ÷ 0028 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× FFFC × 0308 ÷ 0028 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× FFFC × 0001 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× FFFC × 0020 ÷ 0001 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× FFFC × 0308 × 0001 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× FFFC × 200D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× FFFC × 0020 ÷ 200D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× FFFC × 0308 × 200D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 200D ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× FFFC ÷ 00A7 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] SECTION SIGN (AI_AL) ÷ [0.3]
× FFFC × 0020 ÷ 00A7 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× FFFC × 0308 ÷ 00A7 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] SECTION SIGN (AI_AL) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× FFFC ÷ 50005 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] <reserved-50005> (XX_AL) ÷ [0.3]
× FFFC × 0020 ÷ 50005 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× FFFC × 0308 ÷ 50005 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] <reserved-50005> (XX_AL) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× FFFC ÷ 0E01 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× FFFC × 0020 ÷ 0E01 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× FFFC × 0308 ÷ 0E01 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× FFFC ÷ 3041 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× FFFC × 0020 ÷ 3041 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× FFFC × 0308 ÷ 3041 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× FFFC × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 007D ÷ 0023 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 007D × 0020 ÷ 0023 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 007D × 0308 ÷ 0023 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 007D ÷ 2014 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 007D × 0020 ÷ 2014 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 007D × 0308 ÷ 2014 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 007D × 0009 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 007D × 0020 ÷ 0009 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 007D × 0308 × 0009 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 007D ÷ 00B4 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 007D × 0020 ÷ 00B4 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 007D × 0308 ÷ 00B4 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 007D × 000B ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 007D × 0020 × 000B ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 007D × 0308 × 000B ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 007D × 0308 × 0020 × 000B ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 007D ÷ FFFC ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 007D × 0020 ÷ FFFC ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 007D × 0308 ÷ FFFC ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 007D × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 007D × 007D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 007D × 0020 × 007D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 007D × 0308 × 007D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 007D × 0308 × 0020 × 007D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 007D × 000D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 007D × 0020 × 000D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 007D × 0308 × 000D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 007D × 0308 × 0020 × 000D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 007D × 0021 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 007D × 0020 × 0021 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 007D × 0308 × 0021 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 007D × 0308 × 0020 × 0021 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 007D × 00A0 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 007D × 0020 ÷ 00A0 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 007D × 0308 × 00A0 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 007D ÷ AC00 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 007D × 0020 ÷ AC00 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 007D × 0308 ÷ AC00 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 007D × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 007D ÷ AC01 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 007D × 0020 ÷ AC01 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 007D × 0308 ÷ AC01 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 007D × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 007D ÷ 05D0 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 007D × 0020 ÷ 05D0 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 007D × 0308 ÷ 05D0 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 007D × 002D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 007D × 0020 ÷ 002D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 007D × 0308 × 002D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 002D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 007D ÷ 231A ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 007D × 0020 ÷ 231A ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 007D × 0308 ÷ 231A ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 231A ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 007D × 2024 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 007D × 0020 ÷ 2024 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 007D × 0308 × 2024 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 007D × 002C ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [13.02] COMMA (IS) ÷ [0.3]
× 007D × 0020 × 002C ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 007D × 0308 × 002C ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 007D × 0308 × 0020 × 002C ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 007D ÷ 1100 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 007D × 0020 ÷ 1100 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 007D × 0308 ÷ 1100 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 007D ÷ 11A8 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 007D × 0020 ÷ 11A8 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 007D × 0308 ÷ 11A8 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 007D ÷ 1160 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 007D × 0020 ÷ 1160 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 007D × 0308 ÷ 1160 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 007D × 000A ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 007D × 0020 × 000A ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 007D × 0308 × 000A ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 007D × 0308 × 0020 × 000A ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 007D × 0085 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 007D × 0020 × 0085 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 007D × 0308 × 0085 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 007D × 0308 × 0020 × 0085 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 007D × 17D6 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 007D × 0020 × 17D6 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 007D × 0308 × 17D6 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 007D × 0308 × 0020 × 17D6 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 007D ÷ 0030 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 007D × 0020 ÷ 0030 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 007D × 0308 ÷ 0030 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 007D ÷ 2329 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 007D × 0020 ÷ 2329 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 007D × 0308 ÷ 2329 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 007D ÷ 0025 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 007D × 0020 ÷ 0025 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 007D × 0308 ÷ 0025 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 007D ÷ 0024 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 007D × 0020 ÷ 0024 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 007D × 0308 ÷ 0024 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 007D × 0022 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 007D × 0020 ÷ 0022 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 007D × 0308 × 0022 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 007D × 0020 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [0.3]
× 007D × 0020 × 0020 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 007D × 0308 × 0020 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 007D × 0308 × 0020 × 0020 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 007D × 002F ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 007D × 0020 × 002F ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 007D × 0308 × 002F ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 007D × 0308 × 0020 × 002F ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 007D × 2060 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 007D × 0020 × 2060 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 007D × 0308 × 2060 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 007D × 0308 × 0020 × 2060 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 007D × 200B ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 007D × 0020 × 200B ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 007D × 0308 × 200B ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 007D × 0308 × 0020 × 200B ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 007D ÷ 1F1E6 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 007D × 0020 ÷ 1F1E6 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 007D × 0308 ÷ 1F1E6 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 007D ÷ 261D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 007D × 0020 ÷ 261D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 007D × 0308 ÷ 261D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 261D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 007D ÷ 1F3FB ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 007D × 0020 ÷ 1F3FB ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 007D × 0308 ÷ 1F3FB ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 007D × 0029 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 007D × 0020 × 0029 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 007D × 0308 × 0029 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 007D × 0308 × 0020 × 0029 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 007D ÷ 0028 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 007D × 0020 ÷ 0028 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 007D × 0308 ÷ 0028 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 007D × 0001 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 007D × 0020 ÷ 0001 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 007D × 0308 × 0001 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 007D × 200D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 007D × 0020 ÷ 200D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 007D × 0308 × 200D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 200D ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 007D ÷ 00A7 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 007D × 0020 ÷ 00A7 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 007D × 0308 ÷ 00A7 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 007D ÷ 50005 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 007D × 0020 ÷ 50005 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 007D × 0308 ÷ 50005 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 007D ÷ 0E01 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 007D × 0020 ÷ 0E01 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 007D × 0308 ÷ 0E01 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 007D × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 007D × 3041 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 007D × 0020 × 3041 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 007D × 0308 × 3041 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 007D × 0308 × 0020 × 3041 ÷	#  × [0.3] RIGHT CURLY BRACKET (CL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000D ÷ 0023 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] NUMBER SIGN (AL) ÷ [0.3]
× 000D ÷ 0020 ÷ 0023 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 000D ÷ 0308 × 0023 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0023 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 000D ÷ 2014 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] EM DASH (B2) ÷ [0.3]
× 000D ÷ 0020 ÷ 2014 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 000D ÷ 0308 ÷ 2014 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 2014 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 000D ÷ 0009 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000D ÷ 0020 ÷ 0009 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000D ÷ 0308 × 0009 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0009 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000D ÷ 00B4 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] ACUTE ACCENT (BB) ÷ [0.3]
× 000D ÷ 0020 ÷ 00B4 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000D ÷ 0308 ÷ 00B4 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000D ÷ 000B ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <LINE TABULATION> (BK) ÷ [0.3]
× 000D ÷ 0020 × 000B ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000D ÷ 0308 × 000B ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 000B ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000D ÷ FFFC ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000D ÷ 0020 ÷ FFFC ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000D ÷ 0308 ÷ FFFC ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ FFFC ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000D ÷ 007D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000D ÷ 0020 × 007D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000D ÷ 0308 × 007D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 007D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000D ÷ 000D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000D ÷ 0020 × 000D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000D ÷ 0308 × 000D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 000D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000D ÷ 0021 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] EXCLAMATION MARK (EX) ÷ [0.3]
× 000D ÷ 0020 × 0021 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000D ÷ 0308 × 0021 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 0021 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000D ÷ 00A0 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] NO-BREAK SPACE (GL) ÷ [0.3]
× 000D ÷ 0020 ÷ 00A0 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 000D ÷ 0308 × 00A0 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 000D ÷ AC00 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000D ÷ 0020 ÷ AC00 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000D ÷ 0308 ÷ AC00 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ AC00 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000D ÷ AC01 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000D ÷ 0020 ÷ AC01 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000D ÷ 0308 ÷ AC01 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ AC01 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000D ÷ 05D0 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000D ÷ 0020 ÷ 05D0 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000D ÷ 0308 × 05D0 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000D ÷ 002D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 000D ÷ 0020 ÷ 002D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 000D ÷ 0308 × 002D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 002D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 000D ÷ 231A ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] WATCH (ID) ÷ [0.3]
× 000D ÷ 0020 ÷ 231A ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 000D ÷ 0308 ÷ 231A ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 231A ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 000D ÷ 2024 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] ONE DOT LEADER (IN) ÷ [0.3]
× 000D ÷ 0020 ÷ 2024 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000D ÷ 0308 × 2024 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 2024 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000D ÷ 002C ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMMA (IS) ÷ [0.3]
× 000D ÷ 0020 × 002C ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 000D ÷ 0308 × 002C ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 002C ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 000D ÷ 1100 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000D ÷ 0020 ÷ 1100 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000D ÷ 0308 ÷ 1100 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 1100 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000D ÷ 11A8 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000D ÷ 0020 ÷ 11A8 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000D ÷ 0308 ÷ 11A8 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000D ÷ 1160 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000D ÷ 0020 ÷ 1160 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000D ÷ 0308 ÷ 1160 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 1160 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000D × 000A ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) × [5.01] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000D ÷ 0020 × 000A ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000D ÷ 0308 × 000A ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 000A ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000D ÷ 0085 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000D ÷ 0020 × 0085 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000D ÷ 0308 × 0085 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 0085 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000D ÷ 17D6 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000D ÷ 0020 ÷ 17D6 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000D ÷ 0308 × 17D6 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000D ÷ 0030 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] DIGIT ZERO (NU) ÷ [0.3]
× 000D ÷ 0020 ÷ 0030 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 000D ÷ 0308 × 0030 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0030 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 000D ÷ 2329 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000D ÷ 0020 ÷ 2329 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000D ÷ 0308 ÷ 2329 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 2329 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000D ÷ 0025 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] PERCENT SIGN (PO) ÷ [0.3]
× 000D ÷ 0020 ÷ 0025 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 000D ÷ 0308 × 0025 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0025 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 000D ÷ 0024 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] DOLLAR SIGN (PR) ÷ [0.3]
× 000D ÷ 0020 ÷ 0024 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 000D ÷ 0308 × 0024 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0024 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 000D ÷ 0022 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] QUOTATION MARK (QU) ÷ [0.3]
× 000D ÷ 0020 ÷ 0022 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 000D ÷ 0308 × 0022 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0022 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 000D ÷ 0020 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [0.3]
× 000D ÷ 0020 × 0020 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 0020 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 000D ÷ 002F ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SOLIDUS (SY) ÷ [0.3]
× 000D ÷ 0020 × 002F ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 000D ÷ 0308 × 002F ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 002F ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 000D ÷ 2060 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] WORD JOINER (WJ) ÷ [0.3]
× 000D ÷ 0020 × 2060 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000D ÷ 0308 × 2060 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 2060 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000D ÷ 200B ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000D ÷ 0020 × 200B ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000D ÷ 0308 × 200B ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 200B ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000D ÷ 1F1E6 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000D ÷ 0020 ÷ 1F1E6 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000D ÷ 0308 ÷ 1F1E6 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000D ÷ 261D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000D ÷ 0020 ÷ 261D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000D ÷ 0308 ÷ 261D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 261D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000D ÷ 1F3FB ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000D ÷ 0020 ÷ 1F3FB ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000D ÷ 0308 ÷ 1F3FB ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000D ÷ 0029 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000D ÷ 0020 × 0029 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000D ÷ 0308 × 0029 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000D ÷ 0308 × 0020 × 0029 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000D ÷ 0028 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000D ÷ 0020 ÷ 0028 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000D ÷ 0308 × 0028 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0028 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000D ÷ 0001 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000D ÷ 0020 ÷ 0001 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000D ÷ 0308 × 0001 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0001 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000D ÷ 200D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000D ÷ 0020 ÷ 200D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000D ÷ 0308 × 200D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 200D ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000D ÷ 00A7 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 000D ÷ 0020 ÷ 00A7 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000D ÷ 0308 × 00A7 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000D ÷ 50005 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 000D ÷ 0020 ÷ 50005 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000D ÷ 0308 × 50005 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 50005 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000D ÷ 0E01 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000D ÷ 0020 ÷ 0E01 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000D ÷ 0308 × 0E01 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000D ÷ 3041 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000D ÷ 0020 ÷ 3041 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000D ÷ 0308 × 3041 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000D ÷ 0308 × 0020 ÷ 3041 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0021 ÷ 0023 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 0021 × 0020 ÷ 0023 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0021 × 0308 ÷ 0023 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0021 ÷ 2014 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0021 × 0020 ÷ 2014 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0021 × 0308 ÷ 2014 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0021 × 0009 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0021 × 0020 ÷ 0009 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0021 × 0308 × 0009 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0021 ÷ 00B4 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0021 × 0020 ÷ 00B4 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0021 × 0308 ÷ 00B4 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0021 × 000B ÷	#  × [0.3] EXCLAMATION MARK (EX) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0021 × 0020 × 000B ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0021 × 0308 × 000B ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0021 × 0308 × 0020 × 000B ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0021 ÷ FFFC ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0021 × 0020 ÷ FFFC ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0021 × 0308 ÷ FFFC ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0021 × 007D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0021 × 0020 × 007D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0021 × 0308 × 007D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0021 × 0308 × 0020 × 007D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0021 × 000D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0021 × 0020 × 000D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0021 × 0308 × 000D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0021 × 0308 × 0020 × 000D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0021 × 0021 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0021 × 0020 × 0021 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0021 × 0308 × 0021 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0021 × 0308 × 0020 × 0021 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0021 × 00A0 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0021 × 0020 ÷ 00A0 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0021 × 0308 × 00A0 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0021 ÷ AC00 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0021 × 0020 ÷ AC00 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0021 × 0308 ÷ AC00 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0021 ÷ AC01 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0021 × 0020 ÷ AC01 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0021 × 0308 ÷ AC01 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0021 ÷ 05D0 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0021 × 0020 ÷ 05D0 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0021 × 0308 ÷ 05D0 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0021 × 002D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0021 × 0020 ÷ 002D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0021 × 0308 × 002D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0021 ÷ 231A ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0021 × 0020 ÷ 231A ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0021 × 0308 ÷ 231A ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0021 × 2024 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0021 × 0020 ÷ 2024 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0021 × 0308 × 2024 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0021 × 002C ÷	#  × [0.3] EXCLAMATION MARK (EX) × [13.02] COMMA (IS) ÷ [0.3]
× 0021 × 0020 × 002C ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0021 × 0308 × 002C ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0021 × 0308 × 0020 × 002C ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0021 ÷ 1100 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0021 × 0020 ÷ 1100 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0021 × 0308 ÷ 1100 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0021 ÷ 11A8 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0021 × 0020 ÷ 11A8 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0021 × 0308 ÷ 11A8 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0021 ÷ 1160 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0021 × 0020 ÷ 1160 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0021 × 0308 ÷ 1160 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0021 × 000A ÷	#  × [0.3] EXCLAMATION MARK (EX) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0021 × 0020 × 000A ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0021 × 0308 × 000A ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0021 × 0308 × 0020 × 000A ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0021 × 0085 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0021 × 0020 × 0085 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0021 × 0308 × 0085 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0021 × 0308 × 0020 × 0085 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0021 × 17D6 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0021 × 0020 ÷ 17D6 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0021 × 0308 × 17D6 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0021 ÷ 0030 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 0021 × 0020 ÷ 0030 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0021 × 0308 ÷ 0030 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0021 ÷ 2329 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0021 × 0020 ÷ 2329 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0021 × 0308 ÷ 2329 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0021 ÷ 0025 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0021 × 0020 ÷ 0025 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0021 × 0308 ÷ 0025 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0021 ÷ 0024 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0021 × 0020 ÷ 0024 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0021 × 0308 ÷ 0024 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0021 × 0022 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0021 × 0020 ÷ 0022 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0021 × 0308 × 0022 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0021 × 0020 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [0.3]
× 0021 × 0020 × 0020 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0021 × 0308 × 0020 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0021 × 0308 × 0020 × 0020 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0021 × 002F ÷	#  × [0.3] EXCLAMATION MARK (EX) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0021 × 0020 × 002F ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0021 × 0308 × 002F ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0021 × 0308 × 0020 × 002F ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0021 × 2060 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0021 × 0020 × 2060 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0021 × 0308 × 2060 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0021 × 0308 × 0020 × 2060 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0021 × 200B ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0021 × 0020 × 200B ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0021 × 0308 × 200B ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0021 × 0308 × 0020 × 200B ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0021 ÷ 1F1E6 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0021 × 0020 ÷ 1F1E6 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0021 × 0308 ÷ 1F1E6 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0021 ÷ 261D ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0021 × 0020 ÷ 261D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0021 × 0308 ÷ 261D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0021 ÷ 1F3FB ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0021 × 0020 ÷ 1F3FB ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0021 × 0308 ÷ 1F3FB ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0021 × 0029 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0021 × 0020 × 0029 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0021 × 0308 × 0029 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0021 × 0308 × 0020 × 0029 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0021 ÷ 0028 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0021 × 0020 ÷ 0028 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0021 × 0308 ÷ 0028 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0021 × 0001 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0021 × 0020 ÷ 0001 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0021 × 0308 × 0001 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0021 × 200D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0021 × 0020 ÷ 200D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0021 × 0308 × 200D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0021 ÷ 00A7 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0021 × 0020 ÷ 00A7 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0021 × 0308 ÷ 00A7 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0021 ÷ 50005 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0021 × 0020 ÷ 50005 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0021 × 0308 ÷ 50005 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0021 ÷ 0E01 ÷	#  × [0.3] EXCLAMATION MARK (EX) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0021 × 0020 ÷ 0E01 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0021 × 0308 ÷ 0E01 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0021 × 3041 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0021 × 0020 ÷ 3041 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0021 × 0308 × 3041 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0021 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00A0 × 0023 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] NUMBER SIGN (AL) ÷ [0.3]
× 00A0 × 0020 ÷ 0023 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 00A0 × 0308 × 0023 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] NUMBER SIGN (AL) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 00A0 × 2014 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] EM DASH (B2) ÷ [0.3]
× 00A0 × 0020 ÷ 2014 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 00A0 × 0308 × 2014 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] EM DASH (B2) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 00A0 × 0009 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00A0 × 0020 ÷ 0009 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00A0 × 0308 × 0009 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00A0 × 00B4 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00A0 × 0020 ÷ 00B4 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00A0 × 0308 × 00B4 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00A0 × 000B ÷	#  × [0.3] NO-BREAK SPACE (GL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00A0 × 0020 × 000B ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00A0 × 0308 × 000B ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00A0 × 0308 × 0020 × 000B ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00A0 × FFFC ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00A0 × 0020 ÷ FFFC ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00A0 × 0308 × FFFC ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00A0 × 007D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00A0 × 0020 × 007D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00A0 × 0308 × 007D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00A0 × 0308 × 0020 × 007D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00A0 × 000D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00A0 × 0020 × 000D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00A0 × 0308 × 000D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00A0 × 0308 × 0020 × 000D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00A0 × 0021 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] EXCLAMATION MARK (EX) ÷ [0.3]
× 00A0 × 0020 × 0021 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00A0 × 0308 × 0021 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] EXCLAMATION MARK (EX) ÷ [0.3]
× 00A0 × 0308 × 0020 × 0021 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00A0 × 00A0 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 00A0 × 0020 ÷ 00A0 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 00A0 × 0308 × 00A0 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 00A0 × AC00 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00A0 × 0020 ÷ AC00 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00A0 × 0308 × AC00 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00A0 × AC01 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00A0 × 0020 ÷ AC01 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00A0 × 0308 × AC01 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00A0 × 05D0 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00A0 × 0020 ÷ 05D0 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00A0 × 0308 × 05D0 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00A0 × 002D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 00A0 × 0020 ÷ 002D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 00A0 × 0308 × 002D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 00A0 × 231A ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] WATCH (ID) ÷ [0.3]
× 00A0 × 0020 ÷ 231A ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 00A0 × 0308 × 231A ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] WATCH (ID) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 00A0 × 2024 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00A0 × 0020 ÷ 2024 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00A0 × 0308 × 2024 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00A0 × 002C ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] COMMA (IS) ÷ [0.3]
× 00A0 × 0020 × 002C ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 00A0 × 0308 × 002C ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] COMMA (IS) ÷ [0.3]
× 00A0 × 0308 × 0020 × 002C ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 00A0 × 1100 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00A0 × 0020 ÷ 1100 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00A0 × 0308 × 1100 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00A0 × 11A8 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00A0 × 0020 ÷ 11A8 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00A0 × 0308 × 11A8 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00A0 × 1160 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00A0 × 0020 ÷ 1160 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00A0 × 0308 × 1160 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00A0 × 000A ÷	#  × [0.3] NO-BREAK SPACE (GL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00A0 × 0020 × 000A ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00A0 × 0308 × 000A ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00A0 × 0308 × 0020 × 000A ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00A0 × 0085 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00A0 × 0020 × 0085 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00A0 × 0308 × 0085 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00A0 × 0308 × 0020 × 0085 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00A0 × 17D6 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00A0 × 0020 ÷ 17D6 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00A0 × 0308 × 17D6 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00A0 × 0030 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] DIGIT ZERO (NU) ÷ [0.3]
× 00A0 × 0020 ÷ 0030 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 00A0 × 0308 × 0030 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] DIGIT ZERO (NU) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 00A0 × 2329 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00A0 × 0020 ÷ 2329 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00A0 × 0308 × 2329 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00A0 × 0025 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] PERCENT SIGN (PO) ÷ [0.3]
× 00A0 × 0020 ÷ 0025 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 00A0 × 0308 × 0025 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] PERCENT SIGN (PO) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 00A0 × 0024 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] DOLLAR SIGN (PR) ÷ [0.3]
× 00A0 × 0020 ÷ 0024 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 00A0 × 0308 × 0024 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] DOLLAR SIGN (PR) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 00A0 × 0022 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] QUOTATION MARK (QU) ÷ [0.3]
× 00A0 × 0020 ÷ 0022 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 00A0 × 0308 × 0022 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] QUOTATION MARK (QU) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 00A0 × 0020 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [0.3]
× 00A0 × 0020 × 0020 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 00A0 × 0308 × 0020 × 0020 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 00A0 × 002F ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] SOLIDUS (SY) ÷ [0.3]
× 00A0 × 0020 × 002F ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 00A0 × 0308 × 002F ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] SOLIDUS (SY) ÷ [0.3]
× 00A0 × 0308 × 0020 × 002F ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 00A0 × 2060 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00A0 × 0020 × 2060 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00A0 × 0308 × 2060 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00A0 × 0308 × 0020 × 2060 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00A0 × 200B ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00A0 × 0020 × 200B ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00A0 × 0308 × 200B ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00A0 × 0308 × 0020 × 200B ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00A0 × 1F1E6 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00A0 × 0020 ÷ 1F1E6 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00A0 × 0308 × 1F1E6 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00A0 × 261D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00A0 × 0020 ÷ 261D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00A0 × 0308 × 261D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00A0 × 1F3FB ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00A0 × 0020 ÷ 1F3FB ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00A0 × 0308 × 1F3FB ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00A0 × 0029 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00A0 × 0020 × 0029 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00A0 × 0308 × 0029 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00A0 × 0308 × 0020 × 0029 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00A0 × 0028 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00A0 × 0020 ÷ 0028 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00A0 × 0308 × 0028 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00A0 × 0001 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00A0 × 0020 ÷ 0001 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00A0 × 0308 × 0001 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00A0 × 200D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00A0 × 0020 ÷ 200D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00A0 × 0308 × 200D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00A0 × 00A7 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00A0 × 0020 ÷ 00A7 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00A0 × 0308 × 00A7 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00A0 × 50005 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00A0 × 0020 ÷ 50005 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00A0 × 0308 × 50005 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00A0 × 0E01 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00A0 × 0020 ÷ 0E01 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00A0 × 0308 × 0E01 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00A0 × 3041 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [12.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00A0 × 0020 ÷ 3041 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00A0 × 0308 × 3041 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00A0 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] NO-BREAK SPACE (GL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× AC00 ÷ 0023 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× AC00 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× AC00 × 0308 ÷ 0023 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× AC00 ÷ 2014 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× AC00 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× AC00 × 0308 ÷ 2014 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× AC00 × 0009 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× AC00 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× AC00 × 0308 × 0009 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× AC00 ÷ 00B4 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× AC00 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× AC00 × 0308 ÷ 00B4 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× AC00 × 000B ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× AC00 × 0020 × 000B ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× AC00 × 0308 × 000B ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× AC00 × 0308 × 0020 × 000B ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× AC00 ÷ FFFC ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× AC00 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× AC00 × 0308 ÷ FFFC ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× AC00 × 007D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× AC00 × 0020 × 007D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× AC00 × 0308 × 007D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× AC00 × 0308 × 0020 × 007D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× AC00 × 000D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× AC00 × 0020 × 000D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× AC00 × 0308 × 000D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× AC00 × 0308 × 0020 × 000D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× AC00 × 0021 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× AC00 × 0020 × 0021 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× AC00 × 0308 × 0021 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× AC00 × 0308 × 0020 × 0021 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× AC00 × 00A0 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× AC00 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× AC00 × 0308 × 00A0 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× AC00 ÷ AC00 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× AC00 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× AC00 × 0308 ÷ AC00 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× AC00 ÷ AC01 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× AC00 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× AC00 × 0308 ÷ AC01 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× AC00 ÷ 05D0 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× AC00 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× AC00 × 0308 ÷ 05D0 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× AC00 × 002D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× AC00 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× AC00 × 0308 × 002D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× AC00 ÷ 231A ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] WATCH (ID) ÷ [0.3]
× AC00 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× AC00 × 0308 ÷ 231A ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× AC00 × 2024 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× AC00 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× AC00 × 0308 × 2024 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× AC00 × 002C ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [13.02] COMMA (IS) ÷ [0.3]
× AC00 × 0020 × 002C ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× AC00 × 0308 × 002C ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× AC00 × 0308 × 0020 × 002C ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× AC00 ÷ 1100 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× AC00 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× AC00 × 0308 ÷ 1100 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× AC00 × 11A8 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [26.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× AC00 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× AC00 × 0308 × 11A8 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× AC00 × 1160 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× AC00 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× AC00 × 0308 × 1160 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× AC00 × 000A ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× AC00 × 0020 × 000A ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× AC00 × 0308 × 000A ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× AC00 × 0308 × 0020 × 000A ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× AC00 × 0085 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× AC00 × 0020 × 0085 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× AC00 × 0308 × 0085 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× AC00 × 0308 × 0020 × 0085 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× AC00 × 17D6 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× AC00 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× AC00 × 0308 × 17D6 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× AC00 ÷ 0030 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× AC00 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× AC00 × 0308 ÷ 0030 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× AC00 ÷ 2329 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× AC00 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× AC00 × 0308 ÷ 2329 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× AC00 × 0025 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× AC00 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× AC00 × 0308 × 0025 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× AC00 ÷ 0024 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× AC00 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× AC00 × 0308 ÷ 0024 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× AC00 × 0022 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× AC00 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× AC00 × 0308 × 0022 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× AC00 × 0020 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [0.3]
× AC00 × 0020 × 0020 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× AC00 × 0308 × 0020 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× AC00 × 0308 × 0020 × 0020 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× AC00 × 002F ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [13.02] SOLIDUS (SY) ÷ [0.3]
× AC00 × 0020 × 002F ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× AC00 × 0308 × 002F ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× AC00 × 0308 × 0020 × 002F ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× AC00 × 2060 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× AC00 × 0020 × 2060 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× AC00 × 0308 × 2060 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× AC00 × 0308 × 0020 × 2060 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× AC00 × 200B ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× AC00 × 0020 × 200B ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× AC00 × 0308 × 200B ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× AC00 × 0308 × 0020 × 200B ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× AC00 ÷ 1F1E6 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× AC00 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× AC00 × 0308 ÷ 1F1E6 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× AC00 ÷ 261D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× AC00 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× AC00 × 0308 ÷ 261D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× AC00 ÷ 1F3FB ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× AC00 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× AC00 × 0308 ÷ 1F3FB ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× AC00 × 0029 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× AC00 × 0020 × 0029 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× AC00 × 0308 × 0029 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× AC00 × 0308 × 0020 × 0029 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× AC00 ÷ 0028 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× AC00 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× AC00 × 0308 ÷ 0028 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× AC00 × 0001 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× AC00 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× AC00 × 0308 × 0001 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× AC00 × 200D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× AC00 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× AC00 × 0308 × 200D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× AC00 ÷ 00A7 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× AC00 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× AC00 × 0308 ÷ 00A7 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× AC00 ÷ 50005 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× AC00 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× AC00 × 0308 ÷ 50005 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× AC00 ÷ 0E01 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× AC00 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× AC00 × 0308 ÷ 0E01 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× AC00 × 3041 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× AC00 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× AC00 × 0308 × 3041 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× AC00 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL SYLLABLE GA (H2) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× AC01 ÷ 0023 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× AC01 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× AC01 × 0308 ÷ 0023 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× AC01 ÷ 2014 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× AC01 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× AC01 × 0308 ÷ 2014 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× AC01 × 0009 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× AC01 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× AC01 × 0308 × 0009 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× AC01 ÷ 00B4 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× AC01 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× AC01 × 0308 ÷ 00B4 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× AC01 × 000B ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× AC01 × 0020 × 000B ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× AC01 × 0308 × 000B ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× AC01 × 0308 × 0020 × 000B ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× AC01 ÷ FFFC ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× AC01 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× AC01 × 0308 ÷ FFFC ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× AC01 × 007D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× AC01 × 0020 × 007D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× AC01 × 0308 × 007D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× AC01 × 0308 × 0020 × 007D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× AC01 × 000D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× AC01 × 0020 × 000D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× AC01 × 0308 × 000D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× AC01 × 0308 × 0020 × 000D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× AC01 × 0021 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× AC01 × 0020 × 0021 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× AC01 × 0308 × 0021 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× AC01 × 0308 × 0020 × 0021 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× AC01 × 00A0 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× AC01 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× AC01 × 0308 × 00A0 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× AC01 ÷ AC00 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× AC01 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× AC01 × 0308 ÷ AC00 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× AC01 ÷ AC01 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× AC01 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× AC01 × 0308 ÷ AC01 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× AC01 ÷ 05D0 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× AC01 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× AC01 × 0308 ÷ 05D0 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× AC01 × 002D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× AC01 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× AC01 × 0308 × 002D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× AC01 ÷ 231A ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] WATCH (ID) ÷ [0.3]
× AC01 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× AC01 × 0308 ÷ 231A ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× AC01 × 2024 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× AC01 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× AC01 × 0308 × 2024 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× AC01 × 002C ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [13.02] COMMA (IS) ÷ [0.3]
× AC01 × 0020 × 002C ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× AC01 × 0308 × 002C ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× AC01 × 0308 × 0020 × 002C ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× AC01 ÷ 1100 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× AC01 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× AC01 × 0308 ÷ 1100 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× AC01 × 11A8 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× AC01 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× AC01 × 0308 × 11A8 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× AC01 ÷ 1160 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× AC01 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× AC01 × 0308 ÷ 1160 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× AC01 × 000A ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× AC01 × 0020 × 000A ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× AC01 × 0308 × 000A ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× AC01 × 0308 × 0020 × 000A ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× AC01 × 0085 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× AC01 × 0020 × 0085 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× AC01 × 0308 × 0085 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× AC01 × 0308 × 0020 × 0085 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× AC01 × 17D6 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× AC01 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× AC01 × 0308 × 17D6 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× AC01 ÷ 0030 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× AC01 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× AC01 × 0308 ÷ 0030 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× AC01 ÷ 2329 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× AC01 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× AC01 × 0308 ÷ 2329 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× AC01 × 0025 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× AC01 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× AC01 × 0308 × 0025 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× AC01 ÷ 0024 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× AC01 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× AC01 × 0308 ÷ 0024 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× AC01 × 0022 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× AC01 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× AC01 × 0308 × 0022 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× AC01 × 0020 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [0.3]
× AC01 × 0020 × 0020 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× AC01 × 0308 × 0020 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× AC01 × 0308 × 0020 × 0020 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× AC01 × 002F ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [13.02] SOLIDUS (SY) ÷ [0.3]
× AC01 × 0020 × 002F ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× AC01 × 0308 × 002F ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× AC01 × 0308 × 0020 × 002F ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× AC01 × 2060 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× AC01 × 0020 × 2060 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× AC01 × 0308 × 2060 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× AC01 × 0308 × 0020 × 2060 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× AC01 × 200B ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× AC01 × 0020 × 200B ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× AC01 × 0308 × 200B ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× AC01 × 0308 × 0020 × 200B ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× AC01 ÷ 1F1E6 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× AC01 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× AC01 × 0308 ÷ 1F1E6 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× AC01 ÷ 261D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× AC01 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× AC01 × 0308 ÷ 261D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× AC01 ÷ 1F3FB ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× AC01 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× AC01 × 0308 ÷ 1F3FB ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× AC01 × 0029 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× AC01 × 0020 × 0029 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× AC01 × 0308 × 0029 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× AC01 × 0308 × 0020 × 0029 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× AC01 ÷ 0028 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× AC01 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× AC01 × 0308 ÷ 0028 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× AC01 × 0001 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× AC01 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× AC01 × 0308 × 0001 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× AC01 × 200D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× AC01 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× AC01 × 0308 × 200D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× AC01 ÷ 00A7 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× AC01 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× AC01 × 0308 ÷ 00A7 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× AC01 ÷ 50005 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× AC01 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× AC01 × 0308 ÷ 50005 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× AC01 ÷ 0E01 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× AC01 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× AC01 × 0308 ÷ 0E01 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× AC01 × 3041 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× AC01 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× AC01 × 0308 × 3041 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× AC01 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL SYLLABLE GAG (H3) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 05D0 × 0023 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 05D0 × 0020 ÷ 0023 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 05D0 × 0308 × 0023 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 05D0 ÷ 2014 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 05D0 × 0020 ÷ 2014 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 05D0 × 0308 ÷ 2014 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 05D0 × 0009 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 05D0 × 0020 ÷ 0009 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 05D0 × 0308 × 0009 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 05D0 ÷ 00B4 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 05D0 × 0020 ÷ 00B4 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 05D0 × 0308 ÷ 00B4 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 05D0 × 000B ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 05D0 × 0020 × 000B ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 05D0 × 0308 × 000B ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 05D0 × 0308 × 0020 × 000B ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 05D0 ÷ FFFC ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 05D0 × 0020 ÷ FFFC ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 05D0 × 0308 ÷ FFFC ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 05D0 × 007D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 05D0 × 0020 × 007D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 05D0 × 0308 × 007D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 05D0 × 0308 × 0020 × 007D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 05D0 × 000D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 05D0 × 0020 × 000D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 05D0 × 0308 × 000D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 05D0 × 0308 × 0020 × 000D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 05D0 × 0021 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 05D0 × 0020 × 0021 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 05D0 × 0308 × 0021 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 05D0 × 0308 × 0020 × 0021 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 05D0 × 00A0 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 05D0 × 0020 ÷ 00A0 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 05D0 × 0308 × 00A0 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 05D0 ÷ AC00 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 05D0 × 0020 ÷ AC00 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 05D0 × 0308 ÷ AC00 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 05D0 ÷ AC01 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 05D0 × 0020 ÷ AC01 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 05D0 × 0308 ÷ AC01 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 05D0 × 05D0 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 05D0 × 0020 ÷ 05D0 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 05D0 × 0308 × 05D0 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 05D0 × 002D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 05D0 × 0020 ÷ 002D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 05D0 × 0308 × 002D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 05D0 ÷ 231A ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 05D0 × 0020 ÷ 231A ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 05D0 × 0308 ÷ 231A ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 05D0 × 2024 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 05D0 × 0020 ÷ 2024 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 05D0 × 0308 × 2024 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 05D0 × 002C ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [13.02] COMMA (IS) ÷ [0.3]
× 05D0 × 0020 × 002C ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 05D0 × 0308 × 002C ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 05D0 × 0308 × 0020 × 002C ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 05D0 ÷ 1100 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 05D0 × 0020 ÷ 1100 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 05D0 × 0308 ÷ 1100 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 05D0 ÷ 11A8 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 05D0 × 0020 ÷ 11A8 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 05D0 × 0308 ÷ 11A8 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 05D0 ÷ 1160 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 05D0 × 0020 ÷ 1160 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 05D0 × 0308 ÷ 1160 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 05D0 × 000A ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 05D0 × 0020 × 000A ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 05D0 × 0308 × 000A ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 05D0 × 0308 × 0020 × 000A ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 05D0 × 0085 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 05D0 × 0020 × 0085 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 05D0 × 0308 × 0085 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 05D0 × 0308 × 0020 × 0085 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 05D0 × 17D6 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 05D0 × 0020 ÷ 17D6 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 05D0 × 0308 × 17D6 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 05D0 × 0030 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 05D0 × 0020 ÷ 0030 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 05D0 × 0308 × 0030 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 05D0 ÷ 2329 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 05D0 × 0020 ÷ 2329 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 05D0 × 0308 ÷ 2329 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 05D0 × 0025 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 05D0 × 0020 ÷ 0025 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 05D0 × 0308 × 0025 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 05D0 × 0024 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 05D0 × 0020 ÷ 0024 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 05D0 × 0308 × 0024 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 05D0 × 0022 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 05D0 × 0020 ÷ 0022 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 05D0 × 0308 × 0022 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 05D0 × 0020 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [0.3]
× 05D0 × 0020 × 0020 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 05D0 × 0308 × 0020 × 0020 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 05D0 × 002F ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 05D0 × 0020 × 002F ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 05D0 × 0308 × 002F ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 05D0 × 0308 × 0020 × 002F ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 05D0 × 2060 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 05D0 × 0020 × 2060 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 05D0 × 0308 × 2060 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 05D0 × 0308 × 0020 × 2060 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 05D0 × 200B ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 05D0 × 0020 × 200B ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 05D0 × 0308 × 200B ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 05D0 × 0308 × 0020 × 200B ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 05D0 ÷ 1F1E6 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 05D0 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 05D0 × 0308 ÷ 1F1E6 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 05D0 ÷ 261D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 05D0 × 0020 ÷ 261D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 05D0 × 0308 ÷ 261D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 05D0 ÷ 1F3FB ÷	#  × [0.3] HEBREW LETTER ALEF (HL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 05D0 × 0020 ÷ 1F3FB ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 05D0 × 0308 ÷ 1F3FB ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 05D0 × 0029 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 05D0 × 0020 × 0029 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 05D0 × 0308 × 0029 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 05D0 × 0308 × 0020 × 0029 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 05D0 × 0028 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 05D0 × 0020 ÷ 0028 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 05D0 × 0308 × 0028 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 05D0 × 0001 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 05D0 × 0020 ÷ 0001 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 05D0 × 0308 × 0001 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 05D0 × 200D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 05D0 × 0020 ÷ 200D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 05D0 × 0308 × 200D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 05D0 × 00A7 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 05D0 × 0020 ÷ 00A7 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 05D0 × 0308 × 00A7 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 05D0 × 50005 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 05D0 × 0020 ÷ 50005 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 05D0 × 0308 × 50005 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 05D0 × 0E01 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 05D0 × 0020 ÷ 0E01 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 05D0 × 0308 × 0E01 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 05D0 × 3041 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 05D0 × 0020 ÷ 3041 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 05D0 × 0308 × 3041 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 05D0 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] HEBREW LETTER ALEF (HL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002D ÷ 0023 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 002D × 0020 ÷ 0023 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 002D × 0308 ÷ 0023 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 002D ÷ 2014 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 002D × 0020 ÷ 2014 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 002D × 0308 ÷ 2014 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 002D × 0009 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002D × 0020 ÷ 0009 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002D × 0308 × 0009 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002D ÷ 00B4 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002D × 0020 ÷ 00B4 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002D × 0308 ÷ 00B4 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002D × 000B ÷	#  × [0.3] HYPHEN-MINUS (HY) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002D × 0020 × 000B ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002D × 0308 × 000B ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002D × 0308 × 0020 × 000B ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002D ÷ FFFC ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002D × 0020 ÷ FFFC ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002D × 0308 ÷ FFFC ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002D × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002D × 007D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002D × 0020 × 007D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002D × 0308 × 007D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002D × 0308 × 0020 × 007D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002D × 000D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002D × 0020 × 000D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002D × 0308 × 000D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002D × 0308 × 0020 × 000D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002D × 0021 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002D × 0020 × 0021 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002D × 0308 × 0021 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002D × 0308 × 0020 × 0021 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002D ÷ 00A0 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 002D × 0020 ÷ 00A0 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 002D × 0308 ÷ 00A0 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 002D ÷ AC00 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002D × 0020 ÷ AC00 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002D × 0308 ÷ AC00 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002D × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002D ÷ AC01 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002D × 0020 ÷ AC01 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002D × 0308 ÷ AC01 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002D × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002D ÷ 05D0 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002D × 0020 ÷ 05D0 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002D × 0308 ÷ 05D0 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002D × 002D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 002D × 0020 ÷ 002D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 002D × 0308 × 002D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 002D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 002D ÷ 231A ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 002D × 0020 ÷ 231A ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 002D × 0308 ÷ 231A ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 231A ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 002D × 2024 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002D × 0020 ÷ 2024 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002D × 0308 × 2024 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002D × 002C ÷	#  × [0.3] HYPHEN-MINUS (HY) × [13.02] COMMA (IS) ÷ [0.3]
× 002D × 0020 × 002C ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 002D × 0308 × 002C ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 002D × 0308 × 0020 × 002C ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 002D ÷ 1100 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002D × 0020 ÷ 1100 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002D × 0308 ÷ 1100 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002D ÷ 11A8 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002D × 0020 ÷ 11A8 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002D × 0308 ÷ 11A8 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002D ÷ 1160 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002D × 0020 ÷ 1160 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002D × 0308 ÷ 1160 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002D × 000A ÷	#  × [0.3] HYPHEN-MINUS (HY) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002D × 0020 × 000A ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002D × 0308 × 000A ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002D × 0308 × 0020 × 000A ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002D × 0085 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002D × 0020 × 0085 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002D × 0308 × 0085 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002D × 0308 × 0020 × 0085 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002D × 17D6 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002D × 0020 ÷ 17D6 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002D × 0308 × 17D6 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002D × 0030 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [25.02] DIGIT ZERO (NU) ÷ [0.3]
× 002D × 0020 ÷ 0030 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 002D × 0308 × 0030 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.02] DIGIT ZERO (NU) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 002D ÷ 2329 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002D × 0020 ÷ 2329 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002D × 0308 ÷ 2329 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002D ÷ 0025 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 002D × 0020 ÷ 0025 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 002D × 0308 ÷ 0025 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 002D ÷ 0024 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002D × 0020 ÷ 0024 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002D × 0308 ÷ 0024 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002D × 0022 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 002D × 0020 ÷ 0022 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 002D × 0308 × 0022 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 002D × 0020 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [0.3]
× 002D × 0020 × 0020 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 002D × 0308 × 0020 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 002D × 0308 × 0020 × 0020 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 002D × 002F ÷	#  × [0.3] HYPHEN-MINUS (HY) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002D × 0020 × 002F ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002D × 0308 × 002F ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 002D × 0308 × 0020 × 002F ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002D × 2060 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002D × 0020 × 2060 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002D × 0308 × 2060 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002D × 0308 × 0020 × 2060 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002D × 200B ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002D × 0020 × 200B ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002D × 0308 × 200B ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002D × 0308 × 0020 × 200B ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002D ÷ 1F1E6 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002D × 0020 ÷ 1F1E6 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002D × 0308 ÷ 1F1E6 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002D ÷ 261D ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002D × 0020 ÷ 261D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002D × 0308 ÷ 261D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 261D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002D ÷ 1F3FB ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002D × 0020 ÷ 1F3FB ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002D × 0308 ÷ 1F3FB ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002D × 0029 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002D × 0020 × 0029 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002D × 0308 × 0029 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002D × 0308 × 0020 × 0029 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002D ÷ 0028 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002D × 0020 ÷ 0028 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002D × 0308 ÷ 0028 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002D × 0001 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002D × 0020 ÷ 0001 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002D × 0308 × 0001 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002D × 200D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002D × 0020 ÷ 200D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002D × 0308 × 200D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 200D ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002D ÷ 00A7 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002D × 0020 ÷ 00A7 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002D × 0308 ÷ 00A7 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002D ÷ 50005 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002D × 0020 ÷ 50005 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002D × 0308 ÷ 50005 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002D ÷ 0E01 ÷	#  × [0.3] HYPHEN-MINUS (HY) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002D × 0020 ÷ 0E01 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002D × 0308 ÷ 0E01 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002D × 3041 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002D × 0020 ÷ 3041 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002D × 0308 × 3041 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002D × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 231A ÷ 0023 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 231A × 0020 ÷ 0023 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 231A × 0308 ÷ 0023 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 231A ÷ 2014 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 231A × 0020 ÷ 2014 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 231A × 0308 ÷ 2014 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 231A × 0009 ÷	#  × [0.3] WATCH (ID) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 231A × 0020 ÷ 0009 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 231A × 0308 × 0009 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 231A ÷ 00B4 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 231A × 0020 ÷ 00B4 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 231A × 0308 ÷ 00B4 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 231A × 000B ÷	#  × [0.3] WATCH (ID) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 231A × 0020 × 000B ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 231A × 0308 × 000B ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 231A × 0308 × 0020 × 000B ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 231A ÷ FFFC ÷	#  × [0.3] WATCH (ID) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 231A × 0020 ÷ FFFC ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 231A × 0308 ÷ FFFC ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 231A × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 231A × 007D ÷	#  × [0.3] WATCH (ID) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 231A × 0020 × 007D ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 231A × 0308 × 007D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 231A × 0308 × 0020 × 007D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 231A × 000D ÷	#  × [0.3] WATCH (ID) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 231A × 0020 × 000D ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 231A × 0308 × 000D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 231A × 0308 × 0020 × 000D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 231A × 0021 ÷	#  × [0.3] WATCH (ID) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 231A × 0020 × 0021 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 231A × 0308 × 0021 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 231A × 0308 × 0020 × 0021 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 231A × 00A0 ÷	#  × [0.3] WATCH (ID) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 231A × 0020 ÷ 00A0 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 231A × 0308 × 00A0 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 231A ÷ AC00 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 231A × 0020 ÷ AC00 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 231A × 0308 ÷ AC00 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 231A × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 231A ÷ AC01 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 231A × 0020 ÷ AC01 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 231A × 0308 ÷ AC01 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 231A × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 231A ÷ 05D0 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 231A × 0020 ÷ 05D0 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 231A × 0308 ÷ 05D0 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 231A × 002D ÷	#  × [0.3] WATCH (ID) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 231A × 0020 ÷ 002D ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 231A × 0308 × 002D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 002D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 231A ÷ 231A ÷	#  × [0.3] WATCH (ID) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 231A × 0020 ÷ 231A ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 231A × 0308 ÷ 231A ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 231A ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 231A × 2024 ÷	#  × [0.3] WATCH (ID) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 231A × 0020 ÷ 2024 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 231A × 0308 × 2024 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 231A × 002C ÷	#  × [0.3] WATCH (ID) × [13.02] COMMA (IS) ÷ [0.3]
× 231A × 0020 × 002C ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 231A × 0308 × 002C ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 231A × 0308 × 0020 × 002C ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 231A ÷ 1100 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 231A × 0020 ÷ 1100 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 231A × 0308 ÷ 1100 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 231A ÷ 11A8 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 231A × 0020 ÷ 11A8 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 231A × 0308 ÷ 11A8 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 231A ÷ 1160 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 231A × 0020 ÷ 1160 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 231A × 0308 ÷ 1160 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 231A × 000A ÷	#  × [0.3] WATCH (ID) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 231A × 0020 × 000A ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 231A × 0308 × 000A ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 231A × 0308 × 0020 × 000A ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 231A × 0085 ÷	#  × [0.3] WATCH (ID) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 231A × 0020 × 0085 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 231A × 0308 × 0085 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 231A × 0308 × 0020 × 0085 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 231A × 17D6 ÷	#  × [0.3] WATCH (ID) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 231A × 0020 ÷ 17D6 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 231A × 0308 × 17D6 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 231A ÷ 0030 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 231A × 0020 ÷ 0030 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 231A × 0308 ÷ 0030 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 231A ÷ 2329 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 231A × 0020 ÷ 2329 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 231A × 0308 ÷ 2329 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 231A × 0025 ÷	#  × [0.3] WATCH (ID) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
× 231A × 0020 ÷ 0025 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 231A × 0308 × 0025 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 231A ÷ 0024 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 231A × 0020 ÷ 0024 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 231A × 0308 ÷ 0024 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 231A × 0022 ÷	#  × [0.3] WATCH (ID) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 231A × 0020 ÷ 0022 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 231A × 0308 × 0022 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 231A × 0020 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [0.3]
× 231A × 0020 × 0020 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 231A × 0308 × 0020 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 231A × 0308 × 0020 × 0020 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 231A × 002F ÷	#  × [0.3] WATCH (ID) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 231A × 0020 × 002F ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 231A × 0308 × 002F ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 231A × 0308 × 0020 × 002F ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 231A × 2060 ÷	#  × [0.3] WATCH (ID) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 231A × 0020 × 2060 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 231A × 0308 × 2060 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 231A × 0308 × 0020 × 2060 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 231A × 200B ÷	#  × [0.3] WATCH (ID) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 231A × 0020 × 200B ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 231A × 0308 × 200B ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 231A × 0308 × 0020 × 200B ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 231A ÷ 1F1E6 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 231A × 0020 ÷ 1F1E6 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 231A × 0308 ÷ 1F1E6 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 231A ÷ 261D ÷	#  × [0.3] WATCH (ID) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 231A × 0020 ÷ 261D ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 231A × 0308 ÷ 261D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 261D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 231A ÷ 1F3FB ÷	#  × [0.3] WATCH (ID) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 231A × 0020 ÷ 1F3FB ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 231A × 0308 ÷ 1F3FB ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 231A × 0029 ÷	#  × [0.3] WATCH (ID) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 231A × 0020 × 0029 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 231A × 0308 × 0029 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 231A × 0308 × 0020 × 0029 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 231A ÷ 0028 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 231A × 0020 ÷ 0028 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 231A × 0308 ÷ 0028 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 231A × 0001 ÷	#  × [0.3] WATCH (ID) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 231A × 0020 ÷ 0001 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 231A × 0308 × 0001 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 231A × 200D ÷	#  × [0.3] WATCH (ID) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 231A × 0020 ÷ 200D ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 231A × 0308 × 200D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 200D ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 231A ÷ 00A7 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 231A × 0020 ÷ 00A7 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 231A × 0308 ÷ 00A7 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 231A ÷ 50005 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 231A × 0020 ÷ 50005 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 231A × 0308 ÷ 50005 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 231A ÷ 0E01 ÷	#  × [0.3] WATCH (ID) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 231A × 0020 ÷ 0E01 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 231A × 0308 ÷ 0E01 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 231A × 3041 ÷	#  × [0.3] WATCH (ID) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 231A × 0020 ÷ 3041 ÷	#  × [0.3] WATCH (ID) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 231A × 0308 × 3041 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 231A × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] WATCH (ID) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2024 ÷ 0023 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 2024 × 0020 ÷ 0023 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 2024 × 0308 ÷ 0023 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 2024 ÷ 2014 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 2024 × 0020 ÷ 2014 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 2024 × 0308 ÷ 2014 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 2024 × 0009 ÷	#  × [0.3] ONE DOT LEADER (IN) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2024 × 0020 ÷ 0009 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2024 × 0308 × 0009 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2024 ÷ 00B4 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2024 × 0020 ÷ 00B4 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2024 × 0308 ÷ 00B4 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2024 × 000B ÷	#  × [0.3] ONE DOT LEADER (IN) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2024 × 0020 × 000B ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2024 × 0308 × 000B ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2024 × 0308 × 0020 × 000B ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2024 ÷ FFFC ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2024 × 0020 ÷ FFFC ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2024 × 0308 ÷ FFFC ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2024 × 007D ÷	#  × [0.3] ONE DOT LEADER (IN) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2024 × 0020 × 007D ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2024 × 0308 × 007D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2024 × 0308 × 0020 × 007D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2024 × 000D ÷	#  × [0.3] ONE DOT LEADER (IN) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2024 × 0020 × 000D ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2024 × 0308 × 000D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2024 × 0308 × 0020 × 000D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2024 × 0021 ÷	#  × [0.3] ONE DOT LEADER (IN) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2024 × 0020 × 0021 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2024 × 0308 × 0021 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2024 × 0308 × 0020 × 0021 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2024 × 00A0 ÷	#  × [0.3] ONE DOT LEADER (IN) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 2024 × 0020 ÷ 00A0 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 2024 × 0308 × 00A0 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 2024 ÷ AC00 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2024 × 0020 ÷ AC00 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2024 × 0308 ÷ AC00 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2024 ÷ AC01 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2024 × 0020 ÷ AC01 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2024 × 0308 ÷ AC01 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2024 ÷ 05D0 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2024 × 0020 ÷ 05D0 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2024 × 0308 ÷ 05D0 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2024 × 002D ÷	#  × [0.3] ONE DOT LEADER (IN) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 2024 × 0020 ÷ 002D ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2024 × 0308 × 002D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2024 ÷ 231A ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 2024 × 0020 ÷ 231A ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 2024 × 0308 ÷ 231A ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 2024 × 2024 ÷	#  × [0.3] ONE DOT LEADER (IN) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2024 × 0020 ÷ 2024 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2024 × 0308 × 2024 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2024 × 002C ÷	#  × [0.3] ONE DOT LEADER (IN) × [13.02] COMMA (IS) ÷ [0.3]
× 2024 × 0020 × 002C ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 2024 × 0308 × 002C ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 2024 × 0308 × 0020 × 002C ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 2024 ÷ 1100 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2024 × 0020 ÷ 1100 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2024 × 0308 ÷ 1100 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2024 ÷ 11A8 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2024 × 0020 ÷ 11A8 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2024 × 0308 ÷ 11A8 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2024 ÷ 1160 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2024 × 0020 ÷ 1160 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2024 × 0308 ÷ 1160 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2024 × 000A ÷	#  × [0.3] ONE DOT LEADER (IN) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2024 × 0020 × 000A ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2024 × 0308 × 000A ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2024 × 0308 × 0020 × 000A ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2024 × 0085 ÷	#  × [0.3] ONE DOT LEADER (IN) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2024 × 0020 × 0085 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2024 × 0308 × 0085 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2024 × 0308 × 0020 × 0085 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2024 × 17D6 ÷	#  × [0.3] ONE DOT LEADER (IN) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2024 × 0020 ÷ 17D6 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2024 × 0308 × 17D6 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2024 ÷ 0030 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 2024 × 0020 ÷ 0030 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 2024 × 0308 ÷ 0030 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 2024 ÷ 2329 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2024 × 0020 ÷ 2329 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2024 × 0308 ÷ 2329 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2024 ÷ 0025 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 2024 × 0020 ÷ 0025 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 2024 × 0308 ÷ 0025 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 2024 ÷ 0024 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2024 × 0020 ÷ 0024 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2024 × 0308 ÷ 0024 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2024 × 0022 ÷	#  × [0.3] ONE DOT LEADER (IN) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 2024 × 0020 ÷ 0022 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 2024 × 0308 × 0022 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 2024 × 0020 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [0.3]
× 2024 × 0020 × 0020 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 2024 × 0308 × 0020 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 2024 × 0308 × 0020 × 0020 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 2024 × 002F ÷	#  × [0.3] ONE DOT LEADER (IN) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2024 × 0020 × 002F ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2024 × 0308 × 002F ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 2024 × 0308 × 0020 × 002F ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2024 × 2060 ÷	#  × [0.3] ONE DOT LEADER (IN) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2024 × 0020 × 2060 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2024 × 0308 × 2060 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2024 × 0308 × 0020 × 2060 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2024 × 200B ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2024 × 0020 × 200B ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2024 × 0308 × 200B ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2024 × 0308 × 0020 × 200B ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2024 ÷ 1F1E6 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2024 × 0020 ÷ 1F1E6 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2024 × 0308 ÷ 1F1E6 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2024 ÷ 261D ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2024 × 0020 ÷ 261D ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2024 × 0308 ÷ 261D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2024 ÷ 1F3FB ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2024 × 0020 ÷ 1F3FB ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2024 × 0308 ÷ 1F3FB ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2024 × 0029 ÷	#  × [0.3] ONE DOT LEADER (IN) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2024 × 0020 × 0029 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2024 × 0308 × 0029 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2024 × 0308 × 0020 × 0029 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2024 ÷ 0028 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2024 × 0020 ÷ 0028 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2024 × 0308 ÷ 0028 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2024 × 0001 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2024 × 0020 ÷ 0001 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2024 × 0308 × 0001 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2024 × 200D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2024 × 0020 ÷ 200D ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2024 × 0308 × 200D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2024 ÷ 00A7 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2024 × 0020 ÷ 00A7 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2024 × 0308 ÷ 00A7 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2024 ÷ 50005 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2024 × 0020 ÷ 50005 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2024 × 0308 ÷ 50005 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2024 ÷ 0E01 ÷	#  × [0.3] ONE DOT LEADER (IN) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2024 × 0020 ÷ 0E01 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2024 × 0308 ÷ 0E01 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2024 × 3041 ÷	#  × [0.3] ONE DOT LEADER (IN) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2024 × 0020 ÷ 3041 ÷	#  × [0.3] ONE DOT LEADER (IN) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2024 × 0308 × 3041 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2024 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] ONE DOT LEADER (IN) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002C × 0023 ÷	#  × [0.3] COMMA (IS) × [29.0] NUMBER SIGN (AL) ÷ [0.3]
× 002C × 0020 ÷ 0023 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 002C × 0308 × 0023 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] NUMBER SIGN (AL) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 002C ÷ 2014 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 002C × 0020 ÷ 2014 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 002C × 0308 ÷ 2014 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 002C × 0009 ÷	#  × [0.3] COMMA (IS) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002C × 0020 ÷ 0009 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002C × 0308 × 0009 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002C ÷ 00B4 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002C × 0020 ÷ 00B4 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002C × 0308 ÷ 00B4 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002C × 000B ÷	#  × [0.3] COMMA (IS) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002C × 0020 × 000B ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002C × 0308 × 000B ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002C × 0308 × 0020 × 000B ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002C ÷ FFFC ÷	#  × [0.3] COMMA (IS) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002C × 0020 ÷ FFFC ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002C × 0308 ÷ FFFC ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002C × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002C × 007D ÷	#  × [0.3] COMMA (IS) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002C × 0020 × 007D ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002C × 0308 × 007D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002C × 0308 × 0020 × 007D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002C × 000D ÷	#  × [0.3] COMMA (IS) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002C × 0020 × 000D ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002C × 0308 × 000D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002C × 0308 × 0020 × 000D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002C × 0021 ÷	#  × [0.3] COMMA (IS) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002C × 0020 × 0021 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002C × 0308 × 0021 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002C × 0308 × 0020 × 0021 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002C × 00A0 ÷	#  × [0.3] COMMA (IS) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 002C × 0020 ÷ 00A0 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 002C × 0308 × 00A0 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 002C ÷ AC00 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002C × 0020 ÷ AC00 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002C × 0308 ÷ AC00 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002C × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002C ÷ AC01 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002C × 0020 ÷ AC01 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002C × 0308 ÷ AC01 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002C × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002C × 05D0 ÷	#  × [0.3] COMMA (IS) × [29.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002C × 0020 ÷ 05D0 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002C × 0308 × 05D0 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002C × 002D ÷	#  × [0.3] COMMA (IS) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 002C × 0020 ÷ 002D ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 002C × 0308 × 002D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 002D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 002C ÷ 231A ÷	#  × [0.3] COMMA (IS) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 002C × 0020 ÷ 231A ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 002C × 0308 ÷ 231A ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 231A ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 002C × 2024 ÷	#  × [0.3] COMMA (IS) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002C × 0020 ÷ 2024 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002C × 0308 × 2024 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002C × 002C ÷	#  × [0.3] COMMA (IS) × [13.02] COMMA (IS) ÷ [0.3]
× 002C × 0020 × 002C ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 002C × 0308 × 002C ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 002C × 0308 × 0020 × 002C ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 002C ÷ 1100 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002C × 0020 ÷ 1100 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002C × 0308 ÷ 1100 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002C ÷ 11A8 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002C × 0020 ÷ 11A8 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002C × 0308 ÷ 11A8 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002C ÷ 1160 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002C × 0020 ÷ 1160 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002C × 0308 ÷ 1160 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002C × 000A ÷	#  × [0.3] COMMA (IS) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002C × 0020 × 000A ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002C × 0308 × 000A ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002C × 0308 × 0020 × 000A ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002C × 0085 ÷	#  × [0.3] COMMA (IS) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002C × 0020 × 0085 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002C × 0308 × 0085 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002C × 0308 × 0020 × 0085 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002C × 17D6 ÷	#  × [0.3] COMMA (IS) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002C × 0020 ÷ 17D6 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002C × 0308 × 17D6 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002C ÷ 0030 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 002C × 0020 ÷ 0030 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 002C × 0308 ÷ 0030 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 002C ÷ 2329 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002C × 0020 ÷ 2329 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002C × 0308 ÷ 2329 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002C ÷ 0025 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 002C × 0020 ÷ 0025 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 002C × 0308 ÷ 0025 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 002C ÷ 0024 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002C × 0020 ÷ 0024 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002C × 0308 ÷ 0024 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002C × 0022 ÷	#  × [0.3] COMMA (IS) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 002C × 0020 ÷ 0022 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 002C × 0308 × 0022 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 002C × 0020 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [0.3]
× 002C × 0020 × 0020 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 002C × 0308 × 0020 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 002C × 0308 × 0020 × 0020 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 002C × 002F ÷	#  × [0.3] COMMA (IS) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002C × 0020 × 002F ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002C × 0308 × 002F ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 002C × 0308 × 0020 × 002F ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002C × 2060 ÷	#  × [0.3] COMMA (IS) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002C × 0020 × 2060 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002C × 0308 × 2060 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002C × 0308 × 0020 × 2060 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002C × 200B ÷	#  × [0.3] COMMA (IS) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002C × 0020 × 200B ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002C × 0308 × 200B ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002C × 0308 × 0020 × 200B ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002C ÷ 1F1E6 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002C × 0020 ÷ 1F1E6 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002C × 0308 ÷ 1F1E6 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002C ÷ 261D ÷	#  × [0.3] COMMA (IS) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002C × 0020 ÷ 261D ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002C × 0308 ÷ 261D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 261D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002C ÷ 1F3FB ÷	#  × [0.3] COMMA (IS) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002C × 0020 ÷ 1F3FB ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002C × 0308 ÷ 1F3FB ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002C × 0029 ÷	#  × [0.3] COMMA (IS) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002C × 0020 × 0029 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002C × 0308 × 0029 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002C × 0308 × 0020 × 0029 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002C ÷ 0028 ÷	#  × [0.3] COMMA (IS) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002C × 0020 ÷ 0028 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002C × 0308 ÷ 0028 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002C × 0001 ÷	#  × [0.3] COMMA (IS) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002C × 0020 ÷ 0001 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002C × 0308 × 0001 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002C × 200D ÷	#  × [0.3] COMMA (IS) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002C × 0020 ÷ 200D ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002C × 0308 × 200D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 200D ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002C × 00A7 ÷	#  × [0.3] COMMA (IS) × [29.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002C × 0020 ÷ 00A7 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002C × 0308 × 00A7 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002C × 50005 ÷	#  × [0.3] COMMA (IS) × [29.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002C × 0020 ÷ 50005 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002C × 0308 × 50005 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002C × 0E01 ÷	#  × [0.3] COMMA (IS) × [29.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002C × 0020 ÷ 0E01 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002C × 0308 × 0E01 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [29.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002C × 3041 ÷	#  × [0.3] COMMA (IS) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002C × 0020 ÷ 3041 ÷	#  × [0.3] COMMA (IS) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002C × 0308 × 3041 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002C × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] COMMA (IS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1100 ÷ 0023 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 1100 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 1100 × 0308 ÷ 0023 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 1100 ÷ 2014 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 1100 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 1100 × 0308 ÷ 2014 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 1100 × 0009 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1100 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1100 × 0308 × 0009 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1100 ÷ 00B4 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1100 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1100 × 0308 ÷ 00B4 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1100 × 000B ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1100 × 0020 × 000B ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1100 × 0308 × 000B ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1100 × 0308 × 0020 × 000B ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1100 ÷ FFFC ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1100 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1100 × 0308 ÷ FFFC ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1100 × 007D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1100 × 0020 × 007D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1100 × 0308 × 007D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1100 × 0308 × 0020 × 007D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1100 × 000D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1100 × 0020 × 000D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1100 × 0308 × 000D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1100 × 0308 × 0020 × 000D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1100 × 0021 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1100 × 0020 × 0021 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1100 × 0308 × 0021 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1100 × 0308 × 0020 × 0021 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1100 × 00A0 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 1100 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 1100 × 0308 × 00A0 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 1100 × AC00 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1100 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1100 × 0308 × AC00 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.01] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1100 × AC01 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1100 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1100 × 0308 × AC01 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.01] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1100 ÷ 05D0 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1100 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1100 × 0308 ÷ 05D0 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1100 × 002D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 1100 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 1100 × 0308 × 002D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 1100 ÷ 231A ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 1100 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 1100 × 0308 ÷ 231A ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 1100 × 2024 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1100 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1100 × 0308 × 2024 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1100 × 002C ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.02] COMMA (IS) ÷ [0.3]
× 1100 × 0020 × 002C ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 1100 × 0308 × 002C ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 1100 × 0308 × 0020 × 002C ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 1100 × 1100 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1100 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1100 × 0308 × 1100 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.01] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1100 ÷ 11A8 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1100 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1100 × 0308 ÷ 11A8 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1100 × 1160 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1100 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1100 × 0308 × 1160 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.01] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1100 × 000A ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1100 × 0020 × 000A ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1100 × 0308 × 000A ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1100 × 0308 × 0020 × 000A ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1100 × 0085 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1100 × 0020 × 0085 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1100 × 0308 × 0085 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1100 × 0308 × 0020 × 0085 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1100 × 17D6 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1100 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1100 × 0308 × 17D6 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1100 ÷ 0030 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 1100 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 1100 × 0308 ÷ 0030 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 1100 ÷ 2329 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1100 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1100 × 0308 ÷ 2329 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1100 × 0025 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× 1100 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 1100 × 0308 × 0025 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 1100 ÷ 0024 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1100 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1100 × 0308 ÷ 0024 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1100 × 0022 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 1100 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 1100 × 0308 × 0022 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 1100 × 0020 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [0.3]
× 1100 × 0020 × 0020 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 1100 × 0308 × 0020 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 1100 × 0308 × 0020 × 0020 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 1100 × 002F ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1100 × 0020 × 002F ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1100 × 0308 × 002F ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 1100 × 0308 × 0020 × 002F ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1100 × 2060 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1100 × 0020 × 2060 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1100 × 0308 × 2060 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1100 × 0308 × 0020 × 2060 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1100 × 200B ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1100 × 0020 × 200B ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1100 × 0308 × 200B ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1100 × 0308 × 0020 × 200B ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1100 ÷ 1F1E6 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1100 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1100 × 0308 ÷ 1F1E6 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1100 ÷ 261D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1100 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1100 × 0308 ÷ 261D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1100 ÷ 1F3FB ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1100 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1100 × 0308 ÷ 1F3FB ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1100 × 0029 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1100 × 0020 × 0029 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1100 × 0308 × 0029 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1100 × 0308 × 0020 × 0029 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1100 ÷ 0028 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1100 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1100 × 0308 ÷ 0028 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1100 × 0001 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1100 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1100 × 0308 × 0001 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1100 × 200D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1100 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1100 × 0308 × 200D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1100 ÷ 00A7 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1100 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1100 × 0308 ÷ 00A7 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1100 ÷ 50005 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1100 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1100 × 0308 ÷ 50005 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1100 ÷ 0E01 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1100 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1100 × 0308 ÷ 0E01 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1100 × 3041 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1100 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1100 × 0308 × 3041 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1100 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 11A8 ÷ 0023 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 11A8 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 11A8 × 0308 ÷ 0023 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 11A8 ÷ 2014 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 11A8 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 11A8 × 0308 ÷ 2014 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 11A8 × 0009 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 11A8 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 11A8 × 0308 × 0009 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 11A8 ÷ 00B4 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 11A8 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 11A8 × 0308 ÷ 00B4 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 11A8 × 000B ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 11A8 × 0020 × 000B ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 11A8 × 0308 × 000B ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 11A8 × 0308 × 0020 × 000B ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 11A8 ÷ FFFC ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 11A8 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 11A8 × 0308 ÷ FFFC ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 11A8 × 007D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 11A8 × 0020 × 007D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 11A8 × 0308 × 007D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 11A8 × 0308 × 0020 × 007D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 11A8 × 000D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 11A8 × 0020 × 000D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 11A8 × 0308 × 000D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 11A8 × 0308 × 0020 × 000D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 11A8 × 0021 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 11A8 × 0020 × 0021 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 11A8 × 0308 × 0021 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 11A8 × 0308 × 0020 × 0021 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 11A8 × 00A0 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 11A8 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 11A8 × 0308 × 00A0 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 11A8 ÷ AC00 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 11A8 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 11A8 × 0308 ÷ AC00 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 11A8 ÷ AC01 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 11A8 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 11A8 × 0308 ÷ AC01 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 11A8 ÷ 05D0 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 11A8 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 11A8 × 0308 ÷ 05D0 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 11A8 × 002D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 11A8 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 11A8 × 0308 × 002D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 11A8 ÷ 231A ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 11A8 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 11A8 × 0308 ÷ 231A ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 11A8 × 2024 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 11A8 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 11A8 × 0308 × 2024 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 11A8 × 002C ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.02] COMMA (IS) ÷ [0.3]
× 11A8 × 0020 × 002C ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 11A8 × 0308 × 002C ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 11A8 × 0308 × 0020 × 002C ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 11A8 ÷ 1100 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 11A8 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 11A8 × 0308 ÷ 1100 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 11A8 × 11A8 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 11A8 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 11A8 × 0308 × 11A8 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 11A8 ÷ 1160 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 11A8 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 11A8 × 0308 ÷ 1160 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 11A8 × 000A ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 11A8 × 0020 × 000A ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 11A8 × 0308 × 000A ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 11A8 × 0308 × 0020 × 000A ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 11A8 × 0085 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 11A8 × 0020 × 0085 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 11A8 × 0308 × 0085 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 11A8 × 0308 × 0020 × 0085 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 11A8 × 17D6 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 11A8 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 11A8 × 0308 × 17D6 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 11A8 ÷ 0030 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 11A8 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 11A8 × 0308 ÷ 0030 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 11A8 ÷ 2329 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 11A8 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 11A8 × 0308 ÷ 2329 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 11A8 × 0025 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× 11A8 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 11A8 × 0308 × 0025 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 11A8 ÷ 0024 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 11A8 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 11A8 × 0308 ÷ 0024 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 11A8 × 0022 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 11A8 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 11A8 × 0308 × 0022 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 11A8 × 0020 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [0.3]
× 11A8 × 0020 × 0020 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 11A8 × 0308 × 0020 × 0020 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 11A8 × 002F ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 11A8 × 0020 × 002F ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 11A8 × 0308 × 002F ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 11A8 × 0308 × 0020 × 002F ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 11A8 × 2060 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 11A8 × 0020 × 2060 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 11A8 × 0308 × 2060 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 11A8 × 0308 × 0020 × 2060 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 11A8 × 200B ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 11A8 × 0020 × 200B ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 11A8 × 0308 × 200B ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 11A8 × 0308 × 0020 × 200B ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 11A8 ÷ 1F1E6 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 11A8 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 11A8 × 0308 ÷ 1F1E6 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 11A8 ÷ 261D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 11A8 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 11A8 × 0308 ÷ 261D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 11A8 ÷ 1F3FB ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 11A8 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 11A8 × 0308 ÷ 1F3FB ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 11A8 × 0029 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 11A8 × 0020 × 0029 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 11A8 × 0308 × 0029 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 11A8 × 0308 × 0020 × 0029 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 11A8 ÷ 0028 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 11A8 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 11A8 × 0308 ÷ 0028 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 11A8 × 0001 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 11A8 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 11A8 × 0308 × 0001 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 11A8 × 200D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 11A8 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 11A8 × 0308 × 200D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 11A8 ÷ 00A7 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 11A8 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 11A8 × 0308 ÷ 00A7 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 11A8 ÷ 50005 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 11A8 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 11A8 × 0308 ÷ 50005 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 11A8 ÷ 0E01 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 11A8 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 11A8 × 0308 ÷ 0E01 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 11A8 × 3041 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 11A8 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 11A8 × 0308 × 3041 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 11A8 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1160 ÷ 0023 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 1160 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 1160 × 0308 ÷ 0023 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 1160 ÷ 2014 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 1160 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 1160 × 0308 ÷ 2014 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 1160 × 0009 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1160 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1160 × 0308 × 0009 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1160 ÷ 00B4 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1160 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1160 × 0308 ÷ 00B4 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1160 × 000B ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1160 × 0020 × 000B ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1160 × 0308 × 000B ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1160 × 0308 × 0020 × 000B ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1160 ÷ FFFC ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1160 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1160 × 0308 ÷ FFFC ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1160 × 007D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1160 × 0020 × 007D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1160 × 0308 × 007D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1160 × 0308 × 0020 × 007D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1160 × 000D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1160 × 0020 × 000D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1160 × 0308 × 000D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1160 × 0308 × 0020 × 000D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1160 × 0021 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1160 × 0020 × 0021 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1160 × 0308 × 0021 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1160 × 0308 × 0020 × 0021 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1160 × 00A0 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 1160 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 1160 × 0308 × 00A0 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 1160 ÷ AC00 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1160 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1160 × 0308 ÷ AC00 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1160 ÷ AC01 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1160 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1160 × 0308 ÷ AC01 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1160 ÷ 05D0 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1160 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1160 × 0308 ÷ 05D0 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1160 × 002D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 1160 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 1160 × 0308 × 002D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 1160 ÷ 231A ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 1160 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 1160 × 0308 ÷ 231A ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 1160 × 2024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1160 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1160 × 0308 × 2024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1160 × 002C ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [13.02] COMMA (IS) ÷ [0.3]
× 1160 × 0020 × 002C ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 1160 × 0308 × 002C ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 1160 × 0308 × 0020 × 002C ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 1160 ÷ 1100 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1160 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1160 × 0308 ÷ 1100 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1160 × 11A8 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [26.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1160 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1160 × 0308 × 11A8 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1160 × 1160 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1160 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1160 × 0308 × 1160 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1160 × 000A ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1160 × 0020 × 000A ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1160 × 0308 × 000A ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1160 × 0308 × 0020 × 000A ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1160 × 0085 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1160 × 0020 × 0085 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1160 × 0308 × 0085 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1160 × 0308 × 0020 × 0085 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1160 × 17D6 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1160 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1160 × 0308 × 17D6 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1160 ÷ 0030 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 1160 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 1160 × 0308 ÷ 0030 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 1160 ÷ 2329 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1160 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1160 × 0308 ÷ 2329 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1160 × 0025 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× 1160 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 1160 × 0308 × 0025 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 1160 ÷ 0024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1160 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1160 × 0308 ÷ 0024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1160 × 0022 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 1160 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 1160 × 0308 × 0022 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 1160 × 0020 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [0.3]
× 1160 × 0020 × 0020 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 1160 × 0308 × 0020 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 1160 × 0308 × 0020 × 0020 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 1160 × 002F ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1160 × 0020 × 002F ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1160 × 0308 × 002F ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 1160 × 0308 × 0020 × 002F ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1160 × 2060 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1160 × 0020 × 2060 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1160 × 0308 × 2060 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1160 × 0308 × 0020 × 2060 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1160 × 200B ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1160 × 0020 × 200B ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1160 × 0308 × 200B ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1160 × 0308 × 0020 × 200B ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1160 ÷ 1F1E6 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1160 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1160 × 0308 ÷ 1F1E6 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1160 ÷ 261D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1160 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1160 × 0308 ÷ 261D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1160 ÷ 1F3FB ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1160 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1160 × 0308 ÷ 1F3FB ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1160 × 0029 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1160 × 0020 × 0029 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1160 × 0308 × 0029 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1160 × 0308 × 0020 × 0029 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1160 ÷ 0028 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1160 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1160 × 0308 ÷ 0028 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1160 × 0001 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1160 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1160 × 0308 × 0001 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1160 × 200D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1160 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1160 × 0308 × 200D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1160 ÷ 00A7 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1160 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1160 × 0308 ÷ 00A7 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1160 ÷ 50005 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1160 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1160 × 0308 ÷ 50005 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1160 ÷ 0E01 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1160 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1160 × 0308 ÷ 0E01 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1160 × 3041 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1160 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1160 × 0308 × 3041 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1160 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000A ÷ 0023 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] NUMBER SIGN (AL) ÷ [0.3]
× 000A ÷ 0020 ÷ 0023 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 000A ÷ 0308 × 0023 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0023 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 000A ÷ 2014 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] EM DASH (B2) ÷ [0.3]
× 000A ÷ 0020 ÷ 2014 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 000A ÷ 0308 ÷ 2014 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 2014 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 000A ÷ 0009 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000A ÷ 0020 ÷ 0009 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000A ÷ 0308 × 0009 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0009 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 000A ÷ 00B4 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] ACUTE ACCENT (BB) ÷ [0.3]
× 000A ÷ 0020 ÷ 00B4 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000A ÷ 0308 ÷ 00B4 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 000A ÷ 000B ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] <LINE TABULATION> (BK) ÷ [0.3]
× 000A ÷ 0020 × 000B ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000A ÷ 0308 × 000B ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 000B ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 000A ÷ FFFC ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000A ÷ 0020 ÷ FFFC ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000A ÷ 0308 ÷ FFFC ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ FFFC ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 000A ÷ 007D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000A ÷ 0020 × 007D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000A ÷ 0308 × 007D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 007D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 000A ÷ 000D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000A ÷ 0020 × 000D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000A ÷ 0308 × 000D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 000D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 000A ÷ 0021 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] EXCLAMATION MARK (EX) ÷ [0.3]
× 000A ÷ 0020 × 0021 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000A ÷ 0308 × 0021 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 0021 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 000A ÷ 00A0 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] NO-BREAK SPACE (GL) ÷ [0.3]
× 000A ÷ 0020 ÷ 00A0 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 000A ÷ 0308 × 00A0 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 000A ÷ AC00 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000A ÷ 0020 ÷ AC00 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000A ÷ 0308 ÷ AC00 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ AC00 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 000A ÷ AC01 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000A ÷ 0020 ÷ AC01 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000A ÷ 0308 ÷ AC01 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ AC01 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 000A ÷ 05D0 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000A ÷ 0020 ÷ 05D0 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000A ÷ 0308 × 05D0 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 000A ÷ 002D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] HYPHEN-MINUS (HY) ÷ [0.3]
× 000A ÷ 0020 ÷ 002D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 000A ÷ 0308 × 002D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 002D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 000A ÷ 231A ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] WATCH (ID) ÷ [0.3]
× 000A ÷ 0020 ÷ 231A ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 000A ÷ 0308 ÷ 231A ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 231A ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 000A ÷ 2024 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] ONE DOT LEADER (IN) ÷ [0.3]
× 000A ÷ 0020 ÷ 2024 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000A ÷ 0308 × 2024 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 2024 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 000A ÷ 002C ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMMA (IS) ÷ [0.3]
× 000A ÷ 0020 × 002C ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 000A ÷ 0308 × 002C ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 002C ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 000A ÷ 1100 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000A ÷ 0020 ÷ 1100 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000A ÷ 0308 ÷ 1100 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 1100 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 000A ÷ 11A8 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000A ÷ 0020 ÷ 11A8 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000A ÷ 0308 ÷ 11A8 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 000A ÷ 1160 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000A ÷ 0020 ÷ 1160 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000A ÷ 0308 ÷ 1160 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 1160 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 000A ÷ 000A ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000A ÷ 0020 × 000A ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000A ÷ 0308 × 000A ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 000A ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 000A ÷ 0085 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000A ÷ 0020 × 0085 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000A ÷ 0308 × 0085 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 0085 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 000A ÷ 17D6 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000A ÷ 0020 ÷ 17D6 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000A ÷ 0308 × 17D6 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 000A ÷ 0030 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] DIGIT ZERO (NU) ÷ [0.3]
× 000A ÷ 0020 ÷ 0030 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 000A ÷ 0308 × 0030 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0030 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 000A ÷ 2329 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000A ÷ 0020 ÷ 2329 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000A ÷ 0308 ÷ 2329 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 2329 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 000A ÷ 0025 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] PERCENT SIGN (PO) ÷ [0.3]
× 000A ÷ 0020 ÷ 0025 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 000A ÷ 0308 × 0025 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0025 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 000A ÷ 0024 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] DOLLAR SIGN (PR) ÷ [0.3]
× 000A ÷ 0020 ÷ 0024 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 000A ÷ 0308 × 0024 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0024 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 000A ÷ 0022 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] QUOTATION MARK (QU) ÷ [0.3]
× 000A ÷ 0020 ÷ 0022 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 000A ÷ 0308 × 0022 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0022 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 000A ÷ 0020 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [0.3]
× 000A ÷ 0020 × 0020 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 0020 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 000A ÷ 002F ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SOLIDUS (SY) ÷ [0.3]
× 000A ÷ 0020 × 002F ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 000A ÷ 0308 × 002F ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 002F ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 000A ÷ 2060 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] WORD JOINER (WJ) ÷ [0.3]
× 000A ÷ 0020 × 2060 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000A ÷ 0308 × 2060 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 2060 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 000A ÷ 200B ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000A ÷ 0020 × 200B ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000A ÷ 0308 × 200B ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 200B ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 000A ÷ 1F1E6 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000A ÷ 0020 ÷ 1F1E6 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000A ÷ 0308 ÷ 1F1E6 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 000A ÷ 261D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000A ÷ 0020 ÷ 261D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000A ÷ 0308 ÷ 261D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 261D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 000A ÷ 1F3FB ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000A ÷ 0020 ÷ 1F3FB ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000A ÷ 0308 ÷ 1F3FB ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 000A ÷ 0029 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000A ÷ 0020 × 0029 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000A ÷ 0308 × 0029 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000A ÷ 0308 × 0020 × 0029 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 000A ÷ 0028 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000A ÷ 0020 ÷ 0028 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000A ÷ 0308 × 0028 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0028 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 000A ÷ 0001 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000A ÷ 0020 ÷ 0001 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000A ÷ 0308 × 0001 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0001 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 000A ÷ 200D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000A ÷ 0020 ÷ 200D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000A ÷ 0308 × 200D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 200D ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 000A ÷ 00A7 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SECTION SIGN (AI_AL) ÷ [0.3]
× 000A ÷ 0020 ÷ 00A7 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000A ÷ 0308 × 00A7 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 000A ÷ 50005 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] <reserved-50005> (XX_AL) ÷ [0.3]
× 000A ÷ 0020 ÷ 50005 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000A ÷ 0308 × 50005 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 50005 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 000A ÷ 0E01 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000A ÷ 0020 ÷ 0E01 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000A ÷ 0308 × 0E01 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 000A ÷ 3041 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000A ÷ 0020 ÷ 3041 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000A ÷ 0308 × 3041 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000A ÷ 0308 × 0020 ÷ 3041 ÷	#  × [0.3] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0085 ÷ 0023 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] NUMBER SIGN (AL) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0023 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0085 ÷ 0308 × 0023 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0023 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0085 ÷ 2014 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] EM DASH (B2) ÷ [0.3]
× 0085 ÷ 0020 ÷ 2014 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0085 ÷ 0308 ÷ 2014 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 2014 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0085 ÷ 0009 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0009 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0085 ÷ 0308 × 0009 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0009 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0085 ÷ 00B4 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] ACUTE ACCENT (BB) ÷ [0.3]
× 0085 ÷ 0020 ÷ 00B4 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0085 ÷ 0308 ÷ 00B4 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0085 ÷ 000B ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] <LINE TABULATION> (BK) ÷ [0.3]
× 0085 ÷ 0020 × 000B ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0085 ÷ 0308 × 000B ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 000B ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0085 ÷ FFFC ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0085 ÷ 0020 ÷ FFFC ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0085 ÷ 0308 ÷ FFFC ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ FFFC ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0085 ÷ 007D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0085 ÷ 0020 × 007D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0085 ÷ 0308 × 007D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 007D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0085 ÷ 000D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0085 ÷ 0020 × 000D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0085 ÷ 0308 × 000D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 000D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0085 ÷ 0021 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] EXCLAMATION MARK (EX) ÷ [0.3]
× 0085 ÷ 0020 × 0021 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0085 ÷ 0308 × 0021 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 0021 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0085 ÷ 00A0 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] NO-BREAK SPACE (GL) ÷ [0.3]
× 0085 ÷ 0020 ÷ 00A0 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0085 ÷ 0308 × 00A0 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0085 ÷ AC00 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0085 ÷ 0020 ÷ AC00 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0085 ÷ 0308 ÷ AC00 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ AC00 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0085 ÷ AC01 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0085 ÷ 0020 ÷ AC01 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0085 ÷ 0308 ÷ AC01 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ AC01 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0085 ÷ 05D0 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0085 ÷ 0020 ÷ 05D0 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0085 ÷ 0308 × 05D0 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0085 ÷ 002D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HYPHEN-MINUS (HY) ÷ [0.3]
× 0085 ÷ 0020 ÷ 002D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0085 ÷ 0308 × 002D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 002D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0085 ÷ 231A ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] WATCH (ID) ÷ [0.3]
× 0085 ÷ 0020 ÷ 231A ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0085 ÷ 0308 ÷ 231A ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 231A ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0085 ÷ 2024 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] ONE DOT LEADER (IN) ÷ [0.3]
× 0085 ÷ 0020 ÷ 2024 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0085 ÷ 0308 × 2024 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 2024 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0085 ÷ 002C ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMMA (IS) ÷ [0.3]
× 0085 ÷ 0020 × 002C ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0085 ÷ 0308 × 002C ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 002C ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0085 ÷ 1100 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0085 ÷ 0020 ÷ 1100 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0085 ÷ 0308 ÷ 1100 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 1100 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0085 ÷ 11A8 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0085 ÷ 0020 ÷ 11A8 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0085 ÷ 0308 ÷ 11A8 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0085 ÷ 1160 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0085 ÷ 0020 ÷ 1160 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0085 ÷ 0308 ÷ 1160 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 1160 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0085 ÷ 000A ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0085 ÷ 0020 × 000A ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0085 ÷ 0308 × 000A ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 000A ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0085 ÷ 0085 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0085 ÷ 0020 × 0085 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0085 ÷ 0308 × 0085 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 0085 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0085 ÷ 17D6 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0085 ÷ 0020 ÷ 17D6 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0085 ÷ 0308 × 17D6 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0085 ÷ 0030 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] DIGIT ZERO (NU) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0030 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0085 ÷ 0308 × 0030 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0030 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0085 ÷ 2329 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0085 ÷ 0020 ÷ 2329 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0085 ÷ 0308 ÷ 2329 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 2329 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0085 ÷ 0025 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] PERCENT SIGN (PO) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0025 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0085 ÷ 0308 × 0025 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0025 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0085 ÷ 0024 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] DOLLAR SIGN (PR) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0024 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0085 ÷ 0308 × 0024 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0024 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0085 ÷ 0022 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] QUOTATION MARK (QU) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0022 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0085 ÷ 0308 × 0022 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0022 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0085 ÷ 0020 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [0.3]
× 0085 ÷ 0020 × 0020 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 0020 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0085 ÷ 002F ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SOLIDUS (SY) ÷ [0.3]
× 0085 ÷ 0020 × 002F ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0085 ÷ 0308 × 002F ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 002F ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0085 ÷ 2060 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] WORD JOINER (WJ) ÷ [0.3]
× 0085 ÷ 0020 × 2060 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0085 ÷ 0308 × 2060 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 2060 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0085 ÷ 200B ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0085 ÷ 0020 × 200B ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0085 ÷ 0308 × 200B ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 200B ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0085 ÷ 1F1E6 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0085 ÷ 0020 ÷ 1F1E6 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0085 ÷ 0308 ÷ 1F1E6 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0085 ÷ 261D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0085 ÷ 0020 ÷ 261D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0085 ÷ 0308 ÷ 261D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 261D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0085 ÷ 1F3FB ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0085 ÷ 0020 ÷ 1F3FB ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0085 ÷ 0308 ÷ 1F3FB ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0085 ÷ 0029 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0085 ÷ 0020 × 0029 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0085 ÷ 0308 × 0029 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0085 ÷ 0308 × 0020 × 0029 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0085 ÷ 0028 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0028 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0085 ÷ 0308 × 0028 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0028 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0085 ÷ 0001 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0001 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0085 ÷ 0308 × 0001 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0001 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0085 ÷ 200D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0085 ÷ 0020 ÷ 200D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0085 ÷ 0308 × 200D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 200D ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0085 ÷ 00A7 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SECTION SIGN (AI_AL) ÷ [0.3]
× 0085 ÷ 0020 ÷ 00A7 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0085 ÷ 0308 × 00A7 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0085 ÷ 50005 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] <reserved-50005> (XX_AL) ÷ [0.3]
× 0085 ÷ 0020 ÷ 50005 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0085 ÷ 0308 × 50005 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 50005 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0085 ÷ 0E01 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0085 ÷ 0020 ÷ 0E01 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0085 ÷ 0308 × 0E01 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0085 ÷ 3041 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0085 ÷ 0020 ÷ 3041 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0085 ÷ 0308 × 3041 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0085 ÷ 0308 × 0020 ÷ 3041 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 17D6 ÷ 0023 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 17D6 × 0020 ÷ 0023 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 17D6 × 0308 ÷ 0023 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 17D6 ÷ 2014 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 17D6 × 0020 ÷ 2014 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 17D6 × 0308 ÷ 2014 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 17D6 × 0009 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 17D6 × 0020 ÷ 0009 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 17D6 × 0308 × 0009 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 17D6 ÷ 00B4 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 17D6 × 0020 ÷ 00B4 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 17D6 × 0308 ÷ 00B4 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 17D6 × 000B ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 17D6 × 0020 × 000B ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 17D6 × 0308 × 000B ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 17D6 × 0308 × 0020 × 000B ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 17D6 ÷ FFFC ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 17D6 × 0020 ÷ FFFC ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 17D6 × 0308 ÷ FFFC ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 17D6 × 007D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 17D6 × 0020 × 007D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 17D6 × 0308 × 007D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 17D6 × 0308 × 0020 × 007D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 17D6 × 000D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 17D6 × 0020 × 000D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 17D6 × 0308 × 000D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 17D6 × 0308 × 0020 × 000D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 17D6 × 0021 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 17D6 × 0020 × 0021 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 17D6 × 0308 × 0021 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 17D6 × 0308 × 0020 × 0021 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 17D6 × 00A0 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 17D6 × 0020 ÷ 00A0 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 17D6 × 0308 × 00A0 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 17D6 ÷ AC00 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 17D6 × 0020 ÷ AC00 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 17D6 × 0308 ÷ AC00 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 17D6 ÷ AC01 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 17D6 × 0020 ÷ AC01 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 17D6 × 0308 ÷ AC01 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 17D6 ÷ 05D0 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 17D6 × 0020 ÷ 05D0 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 17D6 × 0308 ÷ 05D0 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 17D6 × 002D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 17D6 × 0020 ÷ 002D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 17D6 × 0308 × 002D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 17D6 ÷ 231A ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 17D6 × 0020 ÷ 231A ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 17D6 × 0308 ÷ 231A ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 17D6 × 2024 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 17D6 × 0020 ÷ 2024 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 17D6 × 0308 × 2024 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 17D6 × 002C ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [13.02] COMMA (IS) ÷ [0.3]
× 17D6 × 0020 × 002C ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 17D6 × 0308 × 002C ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 17D6 × 0308 × 0020 × 002C ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 17D6 ÷ 1100 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 17D6 × 0020 ÷ 1100 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 17D6 × 0308 ÷ 1100 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 17D6 ÷ 11A8 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 17D6 × 0020 ÷ 11A8 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 17D6 × 0308 ÷ 11A8 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 17D6 ÷ 1160 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 17D6 × 0020 ÷ 1160 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 17D6 × 0308 ÷ 1160 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 17D6 × 000A ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 17D6 × 0020 × 000A ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 17D6 × 0308 × 000A ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 17D6 × 0308 × 0020 × 000A ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 17D6 × 0085 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 17D6 × 0020 × 0085 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 17D6 × 0308 × 0085 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 17D6 × 0308 × 0020 × 0085 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 17D6 × 17D6 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 17D6 × 0020 ÷ 17D6 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 17D6 × 0308 × 17D6 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 17D6 ÷ 0030 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 17D6 × 0020 ÷ 0030 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 17D6 × 0308 ÷ 0030 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 17D6 ÷ 2329 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 17D6 × 0020 ÷ 2329 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 17D6 × 0308 ÷ 2329 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 17D6 ÷ 0025 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 17D6 × 0020 ÷ 0025 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 17D6 × 0308 ÷ 0025 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 17D6 ÷ 0024 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 17D6 × 0020 ÷ 0024 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 17D6 × 0308 ÷ 0024 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 17D6 × 0022 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 17D6 × 0020 ÷ 0022 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 17D6 × 0308 × 0022 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 17D6 × 0020 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [0.3]
× 17D6 × 0020 × 0020 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 17D6 × 0308 × 0020 × 0020 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 17D6 × 002F ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 17D6 × 0020 × 002F ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 17D6 × 0308 × 002F ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 17D6 × 0308 × 0020 × 002F ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 17D6 × 2060 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 17D6 × 0020 × 2060 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 17D6 × 0308 × 2060 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 17D6 × 0308 × 0020 × 2060 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 17D6 × 200B ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 17D6 × 0020 × 200B ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 17D6 × 0308 × 200B ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 17D6 × 0308 × 0020 × 200B ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 17D6 ÷ 1F1E6 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 17D6 × 0020 ÷ 1F1E6 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 17D6 × 0308 ÷ 1F1E6 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 17D6 ÷ 261D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 17D6 × 0020 ÷ 261D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 17D6 × 0308 ÷ 261D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 17D6 ÷ 1F3FB ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 17D6 × 0020 ÷ 1F3FB ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 17D6 × 0308 ÷ 1F3FB ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 17D6 × 0029 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 17D6 × 0020 × 0029 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 17D6 × 0308 × 0029 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 17D6 × 0308 × 0020 × 0029 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 17D6 ÷ 0028 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 17D6 × 0020 ÷ 0028 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 17D6 × 0308 ÷ 0028 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 17D6 × 0001 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 17D6 × 0020 ÷ 0001 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 17D6 × 0308 × 0001 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 17D6 × 200D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 17D6 × 0020 ÷ 200D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 17D6 × 0308 × 200D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 17D6 ÷ 00A7 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 17D6 × 0020 ÷ 00A7 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 17D6 × 0308 ÷ 00A7 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 17D6 ÷ 50005 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 17D6 × 0020 ÷ 50005 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 17D6 × 0308 ÷ 50005 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 17D6 ÷ 0E01 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 17D6 × 0020 ÷ 0E01 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 17D6 × 0308 ÷ 0E01 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 17D6 × 3041 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 17D6 × 0020 ÷ 3041 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 17D6 × 0308 × 3041 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 17D6 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] KHMER SIGN CAMNUC PII KUUH (NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0030 × 0023 ÷	#  × [0.3] DIGIT ZERO (NU) × [23.03] NUMBER SIGN (AL) ÷ [0.3]
× 0030 × 0020 ÷ 0023 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0030 × 0308 × 0023 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.03] NUMBER SIGN (AL) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0030 ÷ 2014 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0030 × 0020 ÷ 2014 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0030 × 0308 ÷ 2014 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0030 × 0009 ÷	#  × [0.3] DIGIT ZERO (NU) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0030 × 0020 ÷ 0009 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0030 × 0308 × 0009 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0030 ÷ 00B4 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0030 × 0020 ÷ 00B4 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0030 × 0308 ÷ 00B4 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0030 × 000B ÷	#  × [0.3] DIGIT ZERO (NU) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0030 × 0020 × 000B ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0030 × 0308 × 000B ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0030 × 0308 × 0020 × 000B ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0030 ÷ FFFC ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0030 × 0020 ÷ FFFC ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0030 × 0308 ÷ FFFC ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0030 × 007D ÷	#  × [0.3] DIGIT ZERO (NU) × [25.04] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0030 × 0020 × 007D ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0030 × 0308 × 007D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.04] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0030 × 0308 × 0020 × 007D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0030 × 000D ÷	#  × [0.3] DIGIT ZERO (NU) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0030 × 0020 × 000D ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0030 × 0308 × 000D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0030 × 0308 × 0020 × 000D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0030 × 0021 ÷	#  × [0.3] DIGIT ZERO (NU) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0030 × 0020 × 0021 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0030 × 0308 × 0021 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0030 × 0308 × 0020 × 0021 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0030 × 00A0 ÷	#  × [0.3] DIGIT ZERO (NU) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0030 × 0020 ÷ 00A0 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0030 × 0308 × 00A0 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0030 ÷ AC00 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0030 × 0020 ÷ AC00 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0030 × 0308 ÷ AC00 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0030 ÷ AC01 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0030 × 0020 ÷ AC01 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0030 × 0308 ÷ AC01 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0030 × 05D0 ÷	#  × [0.3] DIGIT ZERO (NU) × [23.03] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0030 × 0020 ÷ 05D0 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0030 × 0308 × 05D0 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.03] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0030 × 002D ÷	#  × [0.3] DIGIT ZERO (NU) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0030 × 0020 ÷ 002D ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0030 × 0308 × 002D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0030 ÷ 231A ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0030 × 0020 ÷ 231A ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0030 × 0308 ÷ 231A ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0030 × 2024 ÷	#  × [0.3] DIGIT ZERO (NU) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0030 × 0020 ÷ 2024 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0030 × 0308 × 2024 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0030 × 002C ÷	#  × [0.3] DIGIT ZERO (NU) × [25.03] COMMA (IS) ÷ [0.3]
× 0030 × 0020 × 002C ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0030 × 0308 × 002C ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.03] COMMA (IS) ÷ [0.3]
× 0030 × 0308 × 0020 × 002C ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0030 ÷ 1100 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0030 × 0020 ÷ 1100 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0030 × 0308 ÷ 1100 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0030 ÷ 11A8 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0030 × 0020 ÷ 11A8 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0030 × 0308 ÷ 11A8 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0030 ÷ 1160 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0030 × 0020 ÷ 1160 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0030 × 0308 ÷ 1160 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0030 × 000A ÷	#  × [0.3] DIGIT ZERO (NU) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0030 × 0020 × 000A ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0030 × 0308 × 000A ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0030 × 0308 × 0020 × 000A ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0030 × 0085 ÷	#  × [0.3] DIGIT ZERO (NU) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0030 × 0020 × 0085 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0030 × 0308 × 0085 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0030 × 0308 × 0020 × 0085 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0030 × 17D6 ÷	#  × [0.3] DIGIT ZERO (NU) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0030 × 0020 ÷ 17D6 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0030 × 0308 × 17D6 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0030 × 0030 ÷	#  × [0.3] DIGIT ZERO (NU) × [25.03] DIGIT ZERO (NU) ÷ [0.3]
× 0030 × 0020 ÷ 0030 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0030 × 0308 × 0030 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.03] DIGIT ZERO (NU) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0030 ÷ 2329 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0030 × 0020 ÷ 2329 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0030 × 0308 ÷ 2329 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0030 × 0025 ÷	#  × [0.3] DIGIT ZERO (NU) × [25.05] PERCENT SIGN (PO) ÷ [0.3]
× 0030 × 0020 ÷ 0025 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0030 × 0308 × 0025 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.05] PERCENT SIGN (PO) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0030 × 0024 ÷	#  × [0.3] DIGIT ZERO (NU) × [25.05] DOLLAR SIGN (PR) ÷ [0.3]
× 0030 × 0020 ÷ 0024 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0030 × 0308 × 0024 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.05] DOLLAR SIGN (PR) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0030 × 0022 ÷	#  × [0.3] DIGIT ZERO (NU) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0030 × 0020 ÷ 0022 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0030 × 0308 × 0022 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0030 × 0020 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [0.3]
× 0030 × 0020 × 0020 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0030 × 0308 × 0020 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0030 × 0308 × 0020 × 0020 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0030 × 002F ÷	#  × [0.3] DIGIT ZERO (NU) × [25.03] SOLIDUS (SY) ÷ [0.3]
× 0030 × 0020 × 002F ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0030 × 0308 × 002F ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.03] SOLIDUS (SY) ÷ [0.3]
× 0030 × 0308 × 0020 × 002F ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0030 × 2060 ÷	#  × [0.3] DIGIT ZERO (NU) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0030 × 0020 × 2060 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0030 × 0308 × 2060 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0030 × 0308 × 0020 × 2060 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0030 × 200B ÷	#  × [0.3] DIGIT ZERO (NU) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0030 × 0020 × 200B ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0030 × 0308 × 200B ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0030 × 0308 × 0020 × 200B ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0030 ÷ 1F1E6 ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0030 × 0020 ÷ 1F1E6 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0030 × 0308 ÷ 1F1E6 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0030 ÷ 261D ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0030 × 0020 ÷ 261D ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0030 × 0308 ÷ 261D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0030 ÷ 1F3FB ÷	#  × [0.3] DIGIT ZERO (NU) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0030 × 0020 ÷ 1F3FB ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0030 × 0308 ÷ 1F3FB ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0030 × 0029 ÷	#  × [0.3] DIGIT ZERO (NU) × [25.04] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0030 × 0020 × 0029 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0030 × 0308 × 0029 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.04] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0030 × 0308 × 0020 × 0029 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0030 × 0028 ÷	#  × [0.3] DIGIT ZERO (NU) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0030 × 0020 ÷ 0028 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0030 × 0308 × 0028 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0030 × 0001 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0030 × 0020 ÷ 0001 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0030 × 0308 × 0001 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0030 × 200D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0030 × 0020 ÷ 200D ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0030 × 0308 × 200D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0030 × 00A7 ÷	#  × [0.3] DIGIT ZERO (NU) × [23.03] SECTION SIGN (AI_AL) ÷ [0.3]
× 0030 × 0020 ÷ 00A7 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0030 × 0308 × 00A7 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.03] SECTION SIGN (AI_AL) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0030 × 50005 ÷	#  × [0.3] DIGIT ZERO (NU) × [23.03] <reserved-50005> (XX_AL) ÷ [0.3]
× 0030 × 0020 ÷ 50005 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0030 × 0308 × 50005 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.03] <reserved-50005> (XX_AL) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0030 × 0E01 ÷	#  × [0.3] DIGIT ZERO (NU) × [23.03] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0030 × 0020 ÷ 0E01 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0030 × 0308 × 0E01 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.03] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0030 × 3041 ÷	#  × [0.3] DIGIT ZERO (NU) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0030 × 0020 ÷ 3041 ÷	#  × [0.3] DIGIT ZERO (NU) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0030 × 0308 × 3041 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0030 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] DIGIT ZERO (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2329 × 0023 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] NUMBER SIGN (AL) ÷ [0.3]
× 2329 × 0020 × 0023 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] NUMBER SIGN (AL) ÷ [0.3]
× 2329 × 0308 × 0023 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] NUMBER SIGN (AL) ÷ [0.3]
× 2329 × 0308 × 0020 × 0023 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] NUMBER SIGN (AL) ÷ [0.3]
× 2329 × 2014 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] EM DASH (B2) ÷ [0.3]
× 2329 × 0020 × 2014 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] EM DASH (B2) ÷ [0.3]
× 2329 × 0308 × 2014 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] EM DASH (B2) ÷ [0.3]
× 2329 × 0308 × 0020 × 2014 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] EM DASH (B2) ÷ [0.3]
× 2329 × 0009 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2329 × 0020 × 0009 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2329 × 0308 × 0009 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2329 × 0308 × 0020 × 0009 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2329 × 00B4 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2329 × 0020 × 00B4 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2329 × 0308 × 00B4 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2329 × 0308 × 0020 × 00B4 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2329 × 000B ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2329 × 0020 × 000B ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2329 × 0308 × 000B ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2329 × 0308 × 0020 × 000B ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2329 × FFFC ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2329 × 0020 × FFFC ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2329 × 0308 × FFFC ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2329 × 0308 × 0020 × FFFC ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2329 × 007D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2329 × 0020 × 007D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2329 × 0308 × 007D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2329 × 0308 × 0020 × 007D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2329 × 000D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2329 × 0020 × 000D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2329 × 0308 × 000D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2329 × 0308 × 0020 × 000D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2329 × 0021 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2329 × 0020 × 0021 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2329 × 0308 × 0021 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2329 × 0308 × 0020 × 0021 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2329 × 00A0 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 2329 × 0020 × 00A0 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 2329 × 0308 × 00A0 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 2329 × 0308 × 0020 × 00A0 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 2329 × AC00 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2329 × 0020 × AC00 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2329 × 0308 × AC00 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2329 × 0308 × 0020 × AC00 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2329 × AC01 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2329 × 0020 × AC01 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2329 × 0308 × AC01 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2329 × 0308 × 0020 × AC01 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2329 × 05D0 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2329 × 0020 × 05D0 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2329 × 0308 × 05D0 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2329 × 0308 × 0020 × 05D0 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2329 × 002D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2329 × 0020 × 002D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2329 × 0308 × 002D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2329 × 0308 × 0020 × 002D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2329 × 231A ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] WATCH (ID) ÷ [0.3]
× 2329 × 0020 × 231A ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] WATCH (ID) ÷ [0.3]
× 2329 × 0308 × 231A ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] WATCH (ID) ÷ [0.3]
× 2329 × 0308 × 0020 × 231A ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] WATCH (ID) ÷ [0.3]
× 2329 × 2024 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2329 × 0020 × 2024 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2329 × 0308 × 2024 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2329 × 0308 × 0020 × 2024 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2329 × 002C ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [13.02] COMMA (IS) ÷ [0.3]
× 2329 × 0020 × 002C ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 2329 × 0308 × 002C ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 2329 × 0308 × 0020 × 002C ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 2329 × 1100 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2329 × 0020 × 1100 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2329 × 0308 × 1100 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2329 × 0308 × 0020 × 1100 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2329 × 11A8 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2329 × 0020 × 11A8 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2329 × 0308 × 11A8 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2329 × 0308 × 0020 × 11A8 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2329 × 1160 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2329 × 0020 × 1160 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2329 × 0308 × 1160 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2329 × 0308 × 0020 × 1160 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2329 × 000A ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2329 × 0020 × 000A ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2329 × 0308 × 000A ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2329 × 0308 × 0020 × 000A ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2329 × 0085 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2329 × 0020 × 0085 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2329 × 0308 × 0085 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2329 × 0308 × 0020 × 0085 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2329 × 17D6 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2329 × 0020 × 17D6 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2329 × 0308 × 17D6 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2329 × 0308 × 0020 × 17D6 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2329 × 0030 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] DIGIT ZERO (NU) ÷ [0.3]
× 2329 × 0020 × 0030 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] DIGIT ZERO (NU) ÷ [0.3]
× 2329 × 0308 × 0030 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] DIGIT ZERO (NU) ÷ [0.3]
× 2329 × 0308 × 0020 × 0030 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] DIGIT ZERO (NU) ÷ [0.3]
× 2329 × 2329 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2329 × 0020 × 2329 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2329 × 0308 × 2329 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2329 × 0308 × 0020 × 2329 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2329 × 0025 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] PERCENT SIGN (PO) ÷ [0.3]
× 2329 × 0020 × 0025 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] PERCENT SIGN (PO) ÷ [0.3]
× 2329 × 0308 × 0025 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] PERCENT SIGN (PO) ÷ [0.3]
× 2329 × 0308 × 0020 × 0025 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] PERCENT SIGN (PO) ÷ [0.3]
× 2329 × 0024 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2329 × 0020 × 0024 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2329 × 0308 × 0024 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2329 × 0308 × 0020 × 0024 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2329 × 0022 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] QUOTATION MARK (QU) ÷ [0.3]
× 2329 × 0020 × 0022 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] QUOTATION MARK (QU) ÷ [0.3]
× 2329 × 0308 × 0022 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] QUOTATION MARK (QU) ÷ [0.3]
× 2329 × 0308 × 0020 × 0022 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] QUOTATION MARK (QU) ÷ [0.3]
× 2329 × 0020 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) ÷ [0.3]
× 2329 × 0020 × 0020 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 2329 × 0308 × 0020 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 2329 × 0308 × 0020 × 0020 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 2329 × 002F ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2329 × 0020 × 002F ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2329 × 0308 × 002F ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 2329 × 0308 × 0020 × 002F ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2329 × 2060 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2329 × 0020 × 2060 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2329 × 0308 × 2060 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2329 × 0308 × 0020 × 2060 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2329 × 200B ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2329 × 0020 × 200B ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2329 × 0308 × 200B ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2329 × 0308 × 0020 × 200B ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2329 × 1F1E6 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2329 × 0020 × 1F1E6 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2329 × 0308 × 1F1E6 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2329 × 0308 × 0020 × 1F1E6 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2329 × 261D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2329 × 0020 × 261D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2329 × 0308 × 261D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2329 × 0308 × 0020 × 261D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2329 × 1F3FB ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2329 × 0020 × 1F3FB ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2329 × 0308 × 1F3FB ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2329 × 0308 × 0020 × 1F3FB ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2329 × 0029 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2329 × 0020 × 0029 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2329 × 0308 × 0029 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2329 × 0308 × 0020 × 0029 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2329 × 0028 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2329 × 0020 × 0028 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2329 × 0308 × 0028 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2329 × 0308 × 0020 × 0028 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2329 × 0001 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2329 × 0020 × 0001 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2329 × 0308 × 0001 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2329 × 0308 × 0020 × 0001 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2329 × 200D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2329 × 0020 × 200D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2329 × 0308 × 200D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2329 × 0308 × 0020 × 200D ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2329 × 00A7 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2329 × 0020 × 00A7 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2329 × 0308 × 00A7 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2329 × 0308 × 0020 × 00A7 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2329 × 50005 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2329 × 0020 × 50005 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2329 × 0308 × 50005 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2329 × 0308 × 0020 × 50005 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2329 × 0E01 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2329 × 0020 × 0E01 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2329 × 0308 × 0E01 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2329 × 0308 × 0020 × 0E01 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2329 × 3041 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [14.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2329 × 0020 × 3041 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [7.01] SPACE (SP) × [14.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2329 × 0308 × 3041 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2329 × 0308 × 0020 × 3041 ÷	#  × [0.3] LEFT-POINTING ANGLE BRACKET (OP) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0025 × 0023 ÷	#  × [0.3] PERCENT SIGN (PO) × [24.02] NUMBER SIGN (AL) ÷ [0.3]
× 0025 × 0020 ÷ 0023 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0025 × 0308 × 0023 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] NUMBER SIGN (AL) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0025 ÷ 2014 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0025 × 0020 ÷ 2014 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0025 × 0308 ÷ 2014 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0025 × 0009 ÷	#  × [0.3] PERCENT SIGN (PO) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0025 × 0020 ÷ 0009 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0025 × 0308 × 0009 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0025 ÷ 00B4 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0025 × 0020 ÷ 00B4 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0025 × 0308 ÷ 00B4 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0025 × 000B ÷	#  × [0.3] PERCENT SIGN (PO) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0025 × 0020 × 000B ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0025 × 0308 × 000B ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0025 × 0308 × 0020 × 000B ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0025 ÷ FFFC ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0025 × 0020 ÷ FFFC ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0025 × 0308 ÷ FFFC ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0025 × 007D ÷	#  × [0.3] PERCENT SIGN (PO) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0025 × 0020 × 007D ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0025 × 0308 × 007D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0025 × 0308 × 0020 × 007D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0025 × 000D ÷	#  × [0.3] PERCENT SIGN (PO) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0025 × 0020 × 000D ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0025 × 0308 × 000D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0025 × 0308 × 0020 × 000D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0025 × 0021 ÷	#  × [0.3] PERCENT SIGN (PO) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0025 × 0020 × 0021 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0025 × 0308 × 0021 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0025 × 0308 × 0020 × 0021 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0025 × 00A0 ÷	#  × [0.3] PERCENT SIGN (PO) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0025 × 0020 ÷ 00A0 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0025 × 0308 × 00A0 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0025 ÷ AC00 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0025 × 0020 ÷ AC00 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0025 × 0308 ÷ AC00 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0025 ÷ AC01 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0025 × 0020 ÷ AC01 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0025 × 0308 ÷ AC01 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0025 × 05D0 ÷	#  × [0.3] PERCENT SIGN (PO) × [24.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0025 × 0020 ÷ 05D0 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0025 × 0308 × 05D0 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0025 × 002D ÷	#  × [0.3] PERCENT SIGN (PO) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0025 × 0020 ÷ 002D ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0025 × 0308 × 002D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0025 ÷ 231A ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0025 × 0020 ÷ 231A ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0025 × 0308 ÷ 231A ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0025 × 2024 ÷	#  × [0.3] PERCENT SIGN (PO) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0025 × 0020 ÷ 2024 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0025 × 0308 × 2024 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0025 × 002C ÷	#  × [0.3] PERCENT SIGN (PO) × [13.02] COMMA (IS) ÷ [0.3]
× 0025 × 0020 × 002C ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0025 × 0308 × 002C ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0025 × 0308 × 0020 × 002C ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0025 ÷ 1100 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0025 × 0020 ÷ 1100 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0025 × 0308 ÷ 1100 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0025 ÷ 11A8 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0025 × 0020 ÷ 11A8 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0025 × 0308 ÷ 11A8 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0025 ÷ 1160 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0025 × 0020 ÷ 1160 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0025 × 0308 ÷ 1160 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0025 × 000A ÷	#  × [0.3] PERCENT SIGN (PO) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0025 × 0020 × 000A ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0025 × 0308 × 000A ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0025 × 0308 × 0020 × 000A ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0025 × 0085 ÷	#  × [0.3] PERCENT SIGN (PO) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0025 × 0020 × 0085 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0025 × 0308 × 0085 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0025 × 0308 × 0020 × 0085 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0025 × 17D6 ÷	#  × [0.3] PERCENT SIGN (PO) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0025 × 0020 ÷ 17D6 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0025 × 0308 × 17D6 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0025 × 0030 ÷	#  × [0.3] PERCENT SIGN (PO) × [25.01] DIGIT ZERO (NU) ÷ [0.3]
× 0025 × 0020 ÷ 0030 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0025 × 0308 × 0030 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.01] DIGIT ZERO (NU) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0025 ÷ 2329 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0025 × 0020 ÷ 2329 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0025 × 0308 ÷ 2329 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0025 ÷ 0025 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0025 × 0020 ÷ 0025 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0025 × 0308 ÷ 0025 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0025 ÷ 0024 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0025 × 0020 ÷ 0024 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0025 × 0308 ÷ 0024 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0025 × 0022 ÷	#  × [0.3] PERCENT SIGN (PO) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0025 × 0020 ÷ 0022 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0025 × 0308 × 0022 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0025 × 0020 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [0.3]
× 0025 × 0020 × 0020 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0025 × 0308 × 0020 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0025 × 0308 × 0020 × 0020 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0025 × 002F ÷	#  × [0.3] PERCENT SIGN (PO) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0025 × 0020 × 002F ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0025 × 0308 × 002F ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0025 × 0308 × 0020 × 002F ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0025 × 2060 ÷	#  × [0.3] PERCENT SIGN (PO) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0025 × 0020 × 2060 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0025 × 0308 × 2060 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0025 × 0308 × 0020 × 2060 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0025 × 200B ÷	#  × [0.3] PERCENT SIGN (PO) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0025 × 0020 × 200B ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0025 × 0308 × 200B ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0025 × 0308 × 0020 × 200B ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0025 ÷ 1F1E6 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0025 × 0020 ÷ 1F1E6 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0025 × 0308 ÷ 1F1E6 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0025 ÷ 261D ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0025 × 0020 ÷ 261D ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0025 × 0308 ÷ 261D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0025 ÷ 1F3FB ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0025 × 0020 ÷ 1F3FB ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0025 × 0308 ÷ 1F3FB ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0025 × 0029 ÷	#  × [0.3] PERCENT SIGN (PO) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0025 × 0020 × 0029 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0025 × 0308 × 0029 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0025 × 0308 × 0020 × 0029 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0025 ÷ 0028 ÷	#  × [0.3] PERCENT SIGN (PO) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0025 × 0020 ÷ 0028 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0025 × 0308 ÷ 0028 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0025 × 0001 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0025 × 0020 ÷ 0001 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0025 × 0308 × 0001 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0025 × 200D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0025 × 0020 ÷ 200D ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0025 × 0308 × 200D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0025 × 00A7 ÷	#  × [0.3] PERCENT SIGN (PO) × [24.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 0025 × 0020 ÷ 00A7 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0025 × 0308 × 00A7 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0025 × 50005 ÷	#  × [0.3] PERCENT SIGN (PO) × [24.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 0025 × 0020 ÷ 50005 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0025 × 0308 × 50005 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0025 × 0E01 ÷	#  × [0.3] PERCENT SIGN (PO) × [24.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0025 × 0020 ÷ 0E01 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0025 × 0308 × 0E01 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0025 × 3041 ÷	#  × [0.3] PERCENT SIGN (PO) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0025 × 0020 ÷ 3041 ÷	#  × [0.3] PERCENT SIGN (PO) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0025 × 0308 × 3041 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0025 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] PERCENT SIGN (PO) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0024 × 0023 ÷	#  × [0.3] DOLLAR SIGN (PR) × [24.02] NUMBER SIGN (AL) ÷ [0.3]
× 0024 × 0020 ÷ 0023 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0024 × 0308 × 0023 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] NUMBER SIGN (AL) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0024 ÷ 2014 ÷	#  × [0.3] DOLLAR SIGN (PR) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0024 × 0020 ÷ 2014 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0024 × 0308 ÷ 2014 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0024 × 0009 ÷	#  × [0.3] DOLLAR SIGN (PR) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0024 × 0020 ÷ 0009 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0024 × 0308 × 0009 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0024 ÷ 00B4 ÷	#  × [0.3] DOLLAR SIGN (PR) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0024 × 0020 ÷ 00B4 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0024 × 0308 ÷ 00B4 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0024 × 000B ÷	#  × [0.3] DOLLAR SIGN (PR) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0024 × 0020 × 000B ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0024 × 0308 × 000B ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0024 × 0308 × 0020 × 000B ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0024 ÷ FFFC ÷	#  × [0.3] DOLLAR SIGN (PR) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0024 × 0020 ÷ FFFC ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0024 × 0308 ÷ FFFC ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0024 × 007D ÷	#  × [0.3] DOLLAR SIGN (PR) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0024 × 0020 × 007D ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0024 × 0308 × 007D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0024 × 0308 × 0020 × 007D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0024 × 000D ÷	#  × [0.3] DOLLAR SIGN (PR) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0024 × 0020 × 000D ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0024 × 0308 × 000D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0024 × 0308 × 0020 × 000D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0024 × 0021 ÷	#  × [0.3] DOLLAR SIGN (PR) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0024 × 0020 × 0021 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0024 × 0308 × 0021 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0024 × 0308 × 0020 × 0021 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0024 × 00A0 ÷	#  × [0.3] DOLLAR SIGN (PR) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0024 × 0020 ÷ 00A0 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0024 × 0308 × 00A0 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0024 × AC00 ÷	#  × [0.3] DOLLAR SIGN (PR) × [27.03] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0024 × 0020 ÷ AC00 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0024 × 0308 × AC00 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.03] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0024 × AC01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [27.03] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0024 × 0020 ÷ AC01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0024 × 0308 × AC01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.03] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0024 × 05D0 ÷	#  × [0.3] DOLLAR SIGN (PR) × [24.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0024 × 0020 ÷ 05D0 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0024 × 0308 × 05D0 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0024 × 002D ÷	#  × [0.3] DOLLAR SIGN (PR) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0024 × 0020 ÷ 002D ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0024 × 0308 × 002D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0024 × 231A ÷	#  × [0.3] DOLLAR SIGN (PR) × [23.12] WATCH (ID) ÷ [0.3]
× 0024 × 0020 ÷ 231A ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0024 × 0308 × 231A ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.12] WATCH (ID) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0024 × 2024 ÷	#  × [0.3] DOLLAR SIGN (PR) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0024 × 0020 ÷ 2024 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0024 × 0308 × 2024 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0024 × 002C ÷	#  × [0.3] DOLLAR SIGN (PR) × [13.02] COMMA (IS) ÷ [0.3]
× 0024 × 0020 × 002C ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0024 × 0308 × 002C ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0024 × 0308 × 0020 × 002C ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0024 × 1100 ÷	#  × [0.3] DOLLAR SIGN (PR) × [27.03] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0024 × 0020 ÷ 1100 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0024 × 0308 × 1100 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.03] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0024 × 11A8 ÷	#  × [0.3] DOLLAR SIGN (PR) × [27.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0024 × 0020 ÷ 11A8 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0024 × 0308 × 11A8 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0024 × 1160 ÷	#  × [0.3] DOLLAR SIGN (PR) × [27.03] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0024 × 0020 ÷ 1160 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0024 × 0308 × 1160 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [27.03] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0024 × 000A ÷	#  × [0.3] DOLLAR SIGN (PR) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0024 × 0020 × 000A ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0024 × 0308 × 000A ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0024 × 0308 × 0020 × 000A ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0024 × 0085 ÷	#  × [0.3] DOLLAR SIGN (PR) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0024 × 0020 × 0085 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0024 × 0308 × 0085 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0024 × 0308 × 0020 × 0085 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0024 × 17D6 ÷	#  × [0.3] DOLLAR SIGN (PR) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0024 × 0020 ÷ 17D6 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0024 × 0308 × 17D6 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0024 × 0030 ÷	#  × [0.3] DOLLAR SIGN (PR) × [25.01] DIGIT ZERO (NU) ÷ [0.3]
× 0024 × 0020 ÷ 0030 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0024 × 0308 × 0030 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [25.01] DIGIT ZERO (NU) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0024 ÷ 2329 ÷	#  × [0.3] DOLLAR SIGN (PR) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0024 × 0020 ÷ 2329 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0024 × 0308 ÷ 2329 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0024 ÷ 0025 ÷	#  × [0.3] DOLLAR SIGN (PR) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0024 × 0020 ÷ 0025 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0024 × 0308 ÷ 0025 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0024 ÷ 0024 ÷	#  × [0.3] DOLLAR SIGN (PR) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0024 × 0020 ÷ 0024 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0024 × 0308 ÷ 0024 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0024 × 0022 ÷	#  × [0.3] DOLLAR SIGN (PR) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0024 × 0020 ÷ 0022 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0024 × 0308 × 0022 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0024 × 0020 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [0.3]
× 0024 × 0020 × 0020 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0024 × 0308 × 0020 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0024 × 0308 × 0020 × 0020 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0024 × 002F ÷	#  × [0.3] DOLLAR SIGN (PR) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0024 × 0020 × 002F ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0024 × 0308 × 002F ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0024 × 0308 × 0020 × 002F ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0024 × 2060 ÷	#  × [0.3] DOLLAR SIGN (PR) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0024 × 0020 × 2060 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0024 × 0308 × 2060 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0024 × 0308 × 0020 × 2060 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0024 × 200B ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0024 × 0020 × 200B ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0024 × 0308 × 200B ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0024 × 0308 × 0020 × 200B ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0024 ÷ 1F1E6 ÷	#  × [0.3] DOLLAR SIGN (PR) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0024 × 0020 ÷ 1F1E6 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0024 × 0308 ÷ 1F1E6 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0024 × 261D ÷	#  × [0.3] DOLLAR SIGN (PR) × [23.12] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0024 × 0020 ÷ 261D ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0024 × 0308 × 261D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.12] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0024 × 1F3FB ÷	#  × [0.3] DOLLAR SIGN (PR) × [23.12] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0024 × 0020 ÷ 1F3FB ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0024 × 0308 × 1F3FB ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.12] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0024 × 0029 ÷	#  × [0.3] DOLLAR SIGN (PR) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0024 × 0020 × 0029 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0024 × 0308 × 0029 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0024 × 0308 × 0020 × 0029 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0024 ÷ 0028 ÷	#  × [0.3] DOLLAR SIGN (PR) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0024 × 0020 ÷ 0028 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0024 × 0308 ÷ 0028 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0024 × 0001 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0024 × 0020 ÷ 0001 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0024 × 0308 × 0001 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0024 × 200D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0024 × 0020 ÷ 200D ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0024 × 0308 × 200D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0024 × 00A7 ÷	#  × [0.3] DOLLAR SIGN (PR) × [24.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 0024 × 0020 ÷ 00A7 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0024 × 0308 × 00A7 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0024 × 50005 ÷	#  × [0.3] DOLLAR SIGN (PR) × [24.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 0024 × 0020 ÷ 50005 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0024 × 0308 × 50005 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0024 × 0E01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [24.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0024 × 0020 ÷ 0E01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0024 × 0308 × 0E01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0024 × 3041 ÷	#  × [0.3] DOLLAR SIGN (PR) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0024 × 0020 ÷ 3041 ÷	#  × [0.3] DOLLAR SIGN (PR) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0024 × 0308 × 3041 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0024 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] DOLLAR SIGN (PR) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0022 × 0023 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] NUMBER SIGN (AL) ÷ [0.3]
× 0022 × 0020 ÷ 0023 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0022 × 0308 × 0023 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] NUMBER SIGN (AL) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0022 × 2014 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] EM DASH (B2) ÷ [0.3]
× 0022 × 0020 ÷ 2014 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0022 × 0308 × 2014 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] EM DASH (B2) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0022 × 0009 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0022 × 0020 ÷ 0009 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0022 × 0308 × 0009 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0022 × 00B4 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] ACUTE ACCENT (BB) ÷ [0.3]
× 0022 × 0020 ÷ 00B4 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0022 × 0308 × 00B4 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] ACUTE ACCENT (BB) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0022 × 000B ÷	#  × [0.3] QUOTATION MARK (QU) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0022 × 0020 × 000B ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0022 × 0308 × 000B ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0022 × 0308 × 0020 × 000B ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0022 × FFFC ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0022 × 0020 ÷ FFFC ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0022 × 0308 × FFFC ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0022 × 007D ÷	#  × [0.3] QUOTATION MARK (QU) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0022 × 0020 × 007D ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0022 × 0308 × 007D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0022 × 0308 × 0020 × 007D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0022 × 000D ÷	#  × [0.3] QUOTATION MARK (QU) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0022 × 0020 × 000D ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0022 × 0308 × 000D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0022 × 0308 × 0020 × 000D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0022 × 0021 ÷	#  × [0.3] QUOTATION MARK (QU) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0022 × 0020 × 0021 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0022 × 0308 × 0021 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0022 × 0308 × 0020 × 0021 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0022 × 00A0 ÷	#  × [0.3] QUOTATION MARK (QU) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0022 × 0020 ÷ 00A0 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0022 × 0308 × 00A0 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0022 × AC00 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0022 × 0020 ÷ AC00 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0022 × 0308 × AC00 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0022 × AC01 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0022 × 0020 ÷ AC01 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0022 × 0308 × AC01 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0022 × 05D0 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0022 × 0020 ÷ 05D0 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0022 × 0308 × 05D0 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0022 × 002D ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0022 × 0020 ÷ 002D ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0022 × 0308 × 002D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0022 × 231A ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] WATCH (ID) ÷ [0.3]
× 0022 × 0020 ÷ 231A ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0022 × 0308 × 231A ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] WATCH (ID) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0022 × 2024 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] ONE DOT LEADER (IN) ÷ [0.3]
× 0022 × 0020 ÷ 2024 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0022 × 0308 × 2024 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] ONE DOT LEADER (IN) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0022 × 002C ÷	#  × [0.3] QUOTATION MARK (QU) × [13.02] COMMA (IS) ÷ [0.3]
× 0022 × 0020 × 002C ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0022 × 0308 × 002C ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0022 × 0308 × 0020 × 002C ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0022 × 1100 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0022 × 0020 ÷ 1100 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0022 × 0308 × 1100 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0022 × 11A8 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0022 × 0020 ÷ 11A8 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0022 × 0308 × 11A8 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0022 × 1160 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0022 × 0020 ÷ 1160 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0022 × 0308 × 1160 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0022 × 000A ÷	#  × [0.3] QUOTATION MARK (QU) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0022 × 0020 × 000A ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0022 × 0308 × 000A ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0022 × 0308 × 0020 × 000A ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0022 × 0085 ÷	#  × [0.3] QUOTATION MARK (QU) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0022 × 0020 × 0085 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0022 × 0308 × 0085 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0022 × 0308 × 0020 × 0085 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0022 × 17D6 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0022 × 0020 ÷ 17D6 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0022 × 0308 × 17D6 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0022 × 0030 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] DIGIT ZERO (NU) ÷ [0.3]
× 0022 × 0020 ÷ 0030 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0022 × 0308 × 0030 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] DIGIT ZERO (NU) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0022 × 2329 ÷	#  × [0.3] QUOTATION MARK (QU) × [15.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0022 × 0020 × 2329 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [15.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0022 × 0308 × 2329 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [15.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0022 × 0308 × 0020 × 2329 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [15.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0022 × 0025 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] PERCENT SIGN (PO) ÷ [0.3]
× 0022 × 0020 ÷ 0025 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0022 × 0308 × 0025 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] PERCENT SIGN (PO) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0022 × 0024 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] DOLLAR SIGN (PR) ÷ [0.3]
× 0022 × 0020 ÷ 0024 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0022 × 0308 × 0024 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] DOLLAR SIGN (PR) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0022 × 0022 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0022 × 0020 ÷ 0022 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0022 × 0308 × 0022 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0022 × 0020 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [0.3]
× 0022 × 0020 × 0020 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0022 × 0308 × 0020 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0022 × 0308 × 0020 × 0020 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0022 × 002F ÷	#  × [0.3] QUOTATION MARK (QU) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0022 × 0020 × 002F ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0022 × 0308 × 002F ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0022 × 0308 × 0020 × 002F ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0022 × 2060 ÷	#  × [0.3] QUOTATION MARK (QU) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0022 × 0020 × 2060 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0022 × 0308 × 2060 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0022 × 0308 × 0020 × 2060 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0022 × 200B ÷	#  × [0.3] QUOTATION MARK (QU) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0022 × 0020 × 200B ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0022 × 0308 × 200B ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0022 × 0308 × 0020 × 200B ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0022 × 1F1E6 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0022 × 0020 ÷ 1F1E6 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0022 × 0308 × 1F1E6 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0022 × 261D ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0022 × 0020 ÷ 261D ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0022 × 0308 × 261D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0022 × 1F3FB ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0022 × 0020 ÷ 1F3FB ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0022 × 0308 × 1F3FB ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0022 × 0029 ÷	#  × [0.3] QUOTATION MARK (QU) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0022 × 0020 × 0029 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0022 × 0308 × 0029 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0022 × 0308 × 0020 × 0029 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0022 × 0028 ÷	#  × [0.3] QUOTATION MARK (QU) × [15.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0022 × 0020 × 0028 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) × [15.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0022 × 0308 × 0028 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [15.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0022 × 0308 × 0020 × 0028 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [15.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0022 × 0001 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0022 × 0020 ÷ 0001 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0022 × 0308 × 0001 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0022 × 200D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0022 × 0020 ÷ 200D ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0022 × 0308 × 200D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0022 × 00A7 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 0022 × 0020 ÷ 00A7 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0022 × 0308 × 00A7 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0022 × 50005 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 0022 × 0020 ÷ 50005 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0022 × 0308 × 50005 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0022 × 0E01 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0022 × 0020 ÷ 0E01 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0022 × 0308 × 0E01 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0022 × 3041 ÷	#  × [0.3] QUOTATION MARK (QU) × [19.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0022 × 0020 ÷ 3041 ÷	#  × [0.3] QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0022 × 0308 × 3041 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0022 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0020 ÷ 0023 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0020 × 0020 ÷ 0023 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0020 ÷ 0308 × 0023 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0023 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0020 ÷ 2014 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0020 × 0020 ÷ 2014 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0020 ÷ 0308 ÷ 2014 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 2014 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0020 ÷ 0009 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0020 × 0020 ÷ 0009 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0020 ÷ 0308 × 0009 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0009 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0020 ÷ 00B4 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0020 × 0020 ÷ 00B4 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0020 ÷ 0308 ÷ 00B4 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0020 × 000B ÷	#  × [0.3] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0020 × 0020 × 000B ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0020 ÷ 0308 × 000B ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 000B ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0020 ÷ FFFC ÷	#  × [0.3] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0020 × 0020 ÷ FFFC ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0020 ÷ 0308 ÷ FFFC ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ FFFC ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0020 × 007D ÷	#  × [0.3] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0020 × 0020 × 007D ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0020 ÷ 0308 × 007D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 007D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0020 × 000D ÷	#  × [0.3] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0020 × 0020 × 000D ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0020 ÷ 0308 × 000D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 000D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0020 × 0021 ÷	#  × [0.3] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0020 × 0020 × 0021 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0020 ÷ 0308 × 0021 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 0021 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0020 ÷ 00A0 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0020 × 0020 ÷ 00A0 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0020 ÷ 0308 × 00A0 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0020 ÷ AC00 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0020 × 0020 ÷ AC00 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0020 ÷ 0308 ÷ AC00 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ AC00 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0020 ÷ AC01 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0020 × 0020 ÷ AC01 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0020 ÷ 0308 ÷ AC01 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ AC01 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0020 ÷ 05D0 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0020 × 0020 ÷ 05D0 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0020 ÷ 0308 × 05D0 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0020 ÷ 002D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0020 × 0020 ÷ 002D ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0020 ÷ 0308 × 002D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 002D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0020 ÷ 231A ÷	#  × [0.3] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0020 × 0020 ÷ 231A ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0020 ÷ 0308 ÷ 231A ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 231A ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0020 ÷ 2024 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0020 × 0020 ÷ 2024 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0020 ÷ 0308 × 2024 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 2024 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0020 × 002C ÷	#  × [0.3] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0020 × 0020 × 002C ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0020 ÷ 0308 × 002C ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 002C ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0020 ÷ 1100 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0020 × 0020 ÷ 1100 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0020 ÷ 0308 ÷ 1100 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 1100 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0020 ÷ 11A8 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0020 × 0020 ÷ 11A8 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0020 ÷ 0308 ÷ 11A8 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0020 ÷ 1160 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0020 × 0020 ÷ 1160 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0020 ÷ 0308 ÷ 1160 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 1160 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0020 × 000A ÷	#  × [0.3] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0020 × 0020 × 000A ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0020 ÷ 0308 × 000A ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 000A ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0020 × 0085 ÷	#  × [0.3] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0020 × 0020 × 0085 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0020 ÷ 0308 × 0085 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 0085 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0020 ÷ 17D6 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0020 × 0020 ÷ 17D6 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0020 ÷ 0308 × 17D6 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0020 ÷ 0030 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0020 × 0020 ÷ 0030 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0020 ÷ 0308 × 0030 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0030 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0020 ÷ 2329 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0020 × 0020 ÷ 2329 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0020 ÷ 0308 ÷ 2329 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 2329 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0020 ÷ 0025 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0020 × 0020 ÷ 0025 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0020 ÷ 0308 × 0025 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0025 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0020 ÷ 0024 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0020 × 0020 ÷ 0024 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0020 ÷ 0308 × 0024 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0024 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0020 ÷ 0022 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0020 × 0020 ÷ 0022 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0020 ÷ 0308 × 0022 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0022 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0020 × 0020 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0020 × 0020 × 0020 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 0020 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0020 × 002F ÷	#  × [0.3] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0020 × 0020 × 002F ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0020 ÷ 0308 × 002F ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 002F ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0020 × 2060 ÷	#  × [0.3] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0020 × 0020 × 2060 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0020 ÷ 0308 × 2060 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 2060 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0020 × 200B ÷	#  × [0.3] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0020 × 0020 × 200B ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0020 ÷ 0308 × 200B ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 200B ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0020 ÷ 1F1E6 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0020 × 0020 ÷ 1F1E6 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0020 ÷ 0308 ÷ 1F1E6 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0020 ÷ 261D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0020 × 0020 ÷ 261D ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0020 ÷ 0308 ÷ 261D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 261D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0020 ÷ 1F3FB ÷	#  × [0.3] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0020 × 0020 ÷ 1F3FB ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0020 ÷ 0308 ÷ 1F3FB ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0020 × 0029 ÷	#  × [0.3] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0020 × 0020 × 0029 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0020 ÷ 0308 × 0029 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0020 ÷ 0308 × 0020 × 0029 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0020 ÷ 0028 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0020 × 0020 ÷ 0028 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0020 ÷ 0308 × 0028 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0028 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0020 ÷ 0001 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0020 × 0020 ÷ 0001 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0020 ÷ 0308 × 0001 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0001 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0020 ÷ 200D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0020 × 0020 ÷ 200D ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0020 ÷ 0308 × 200D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 200D ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0020 ÷ 00A7 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0020 × 0020 ÷ 00A7 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0020 ÷ 0308 × 00A7 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0020 ÷ 50005 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0020 × 0020 ÷ 50005 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0020 ÷ 0308 × 50005 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 50005 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0020 ÷ 0E01 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0020 × 0020 ÷ 0E01 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0020 ÷ 0308 × 0E01 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0020 ÷ 3041 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0020 × 0020 ÷ 3041 ÷	#  × [0.3] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0020 ÷ 0308 × 3041 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0020 ÷ 0308 × 0020 ÷ 3041 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002F ÷ 0023 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 002F × 0020 ÷ 0023 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 002F × 0308 ÷ 0023 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 002F ÷ 2014 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 002F × 0020 ÷ 2014 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 002F × 0308 ÷ 2014 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 002F × 0009 ÷	#  × [0.3] SOLIDUS (SY) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002F × 0020 ÷ 0009 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002F × 0308 × 0009 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 002F ÷ 00B4 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002F × 0020 ÷ 00B4 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002F × 0308 ÷ 00B4 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 002F × 000B ÷	#  × [0.3] SOLIDUS (SY) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002F × 0020 × 000B ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002F × 0308 × 000B ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002F × 0308 × 0020 × 000B ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 002F ÷ FFFC ÷	#  × [0.3] SOLIDUS (SY) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002F × 0020 ÷ FFFC ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002F × 0308 ÷ FFFC ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002F × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 002F × 007D ÷	#  × [0.3] SOLIDUS (SY) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002F × 0020 × 007D ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002F × 0308 × 007D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002F × 0308 × 0020 × 007D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 002F × 000D ÷	#  × [0.3] SOLIDUS (SY) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002F × 0020 × 000D ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002F × 0308 × 000D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002F × 0308 × 0020 × 000D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 002F × 0021 ÷	#  × [0.3] SOLIDUS (SY) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002F × 0020 × 0021 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002F × 0308 × 0021 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002F × 0308 × 0020 × 0021 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 002F × 00A0 ÷	#  × [0.3] SOLIDUS (SY) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 002F × 0020 ÷ 00A0 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 002F × 0308 × 00A0 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 002F ÷ AC00 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002F × 0020 ÷ AC00 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002F × 0308 ÷ AC00 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002F × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 002F ÷ AC01 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002F × 0020 ÷ AC01 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002F × 0308 ÷ AC01 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002F × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 002F × 05D0 ÷	#  × [0.3] SOLIDUS (SY) × [21.2] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002F × 0020 ÷ 05D0 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002F × 0308 × 05D0 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.2] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 002F × 002D ÷	#  × [0.3] SOLIDUS (SY) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 002F × 0020 ÷ 002D ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 002F × 0308 × 002D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 002D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 002F ÷ 231A ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 002F × 0020 ÷ 231A ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 002F × 0308 ÷ 231A ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 231A ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 002F × 2024 ÷	#  × [0.3] SOLIDUS (SY) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002F × 0020 ÷ 2024 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002F × 0308 × 2024 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 002F × 002C ÷	#  × [0.3] SOLIDUS (SY) × [13.02] COMMA (IS) ÷ [0.3]
× 002F × 0020 × 002C ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 002F × 0308 × 002C ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 002F × 0308 × 0020 × 002C ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 002F ÷ 1100 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002F × 0020 ÷ 1100 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002F × 0308 ÷ 1100 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 002F ÷ 11A8 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002F × 0020 ÷ 11A8 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002F × 0308 ÷ 11A8 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 002F ÷ 1160 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002F × 0020 ÷ 1160 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002F × 0308 ÷ 1160 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 002F × 000A ÷	#  × [0.3] SOLIDUS (SY) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002F × 0020 × 000A ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002F × 0308 × 000A ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002F × 0308 × 0020 × 000A ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 002F × 0085 ÷	#  × [0.3] SOLIDUS (SY) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002F × 0020 × 0085 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002F × 0308 × 0085 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002F × 0308 × 0020 × 0085 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 002F × 17D6 ÷	#  × [0.3] SOLIDUS (SY) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002F × 0020 ÷ 17D6 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002F × 0308 × 17D6 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 002F ÷ 0030 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 002F × 0020 ÷ 0030 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 002F × 0308 ÷ 0030 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 002F ÷ 2329 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002F × 0020 ÷ 2329 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002F × 0308 ÷ 2329 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 002F ÷ 0025 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 002F × 0020 ÷ 0025 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 002F × 0308 ÷ 0025 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 002F ÷ 0024 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002F × 0020 ÷ 0024 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002F × 0308 ÷ 0024 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 002F × 0022 ÷	#  × [0.3] SOLIDUS (SY) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 002F × 0020 ÷ 0022 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 002F × 0308 × 0022 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 002F × 0020 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [0.3]
× 002F × 0020 × 0020 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 002F × 0308 × 0020 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 002F × 0308 × 0020 × 0020 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 002F × 002F ÷	#  × [0.3] SOLIDUS (SY) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002F × 0020 × 002F ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002F × 0308 × 002F ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 002F × 0308 × 0020 × 002F ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 002F × 2060 ÷	#  × [0.3] SOLIDUS (SY) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002F × 0020 × 2060 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002F × 0308 × 2060 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002F × 0308 × 0020 × 2060 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 002F × 200B ÷	#  × [0.3] SOLIDUS (SY) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002F × 0020 × 200B ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002F × 0308 × 200B ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002F × 0308 × 0020 × 200B ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 002F ÷ 1F1E6 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002F × 0020 ÷ 1F1E6 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002F × 0308 ÷ 1F1E6 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 002F ÷ 261D ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002F × 0020 ÷ 261D ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002F × 0308 ÷ 261D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 261D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 002F ÷ 1F3FB ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002F × 0020 ÷ 1F3FB ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002F × 0308 ÷ 1F3FB ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 002F × 0029 ÷	#  × [0.3] SOLIDUS (SY) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002F × 0020 × 0029 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002F × 0308 × 0029 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002F × 0308 × 0020 × 0029 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 002F ÷ 0028 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002F × 0020 ÷ 0028 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002F × 0308 ÷ 0028 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 002F × 0001 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002F × 0020 ÷ 0001 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002F × 0308 × 0001 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 002F × 200D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002F × 0020 ÷ 200D ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002F × 0308 × 200D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 200D ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 002F ÷ 00A7 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002F × 0020 ÷ 00A7 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002F × 0308 ÷ 00A7 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 002F ÷ 50005 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002F × 0020 ÷ 50005 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002F × 0308 ÷ 50005 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 002F ÷ 0E01 ÷	#  × [0.3] SOLIDUS (SY) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002F × 0020 ÷ 0E01 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002F × 0308 ÷ 0E01 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 002F × 3041 ÷	#  × [0.3] SOLIDUS (SY) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002F × 0020 ÷ 3041 ÷	#  × [0.3] SOLIDUS (SY) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002F × 0308 × 3041 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 002F × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] SOLIDUS (SY) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2060 × 0023 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] NUMBER SIGN (AL) ÷ [0.3]
× 2060 × 0020 ÷ 0023 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 2060 × 0308 × 0023 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] NUMBER SIGN (AL) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 2060 × 2014 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] EM DASH (B2) ÷ [0.3]
× 2060 × 0020 ÷ 2014 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 2060 × 0308 × 2014 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] EM DASH (B2) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 2060 × 0009 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2060 × 0020 ÷ 0009 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2060 × 0308 × 0009 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 2060 × 00B4 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] ACUTE ACCENT (BB) ÷ [0.3]
× 2060 × 0020 ÷ 00B4 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2060 × 0308 × 00B4 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] ACUTE ACCENT (BB) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 2060 × 000B ÷	#  × [0.3] WORD JOINER (WJ) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2060 × 0020 × 000B ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2060 × 0308 × 000B ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2060 × 0308 × 0020 × 000B ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 2060 × FFFC ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2060 × 0020 ÷ FFFC ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2060 × 0308 × FFFC ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 2060 × 007D ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2060 × 0020 × 007D ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2060 × 0308 × 007D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2060 × 0308 × 0020 × 007D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 2060 × 000D ÷	#  × [0.3] WORD JOINER (WJ) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2060 × 0020 × 000D ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2060 × 0308 × 000D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2060 × 0308 × 0020 × 000D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 2060 × 0021 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] EXCLAMATION MARK (EX) ÷ [0.3]
× 2060 × 0020 × 0021 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2060 × 0308 × 0021 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] EXCLAMATION MARK (EX) ÷ [0.3]
× 2060 × 0308 × 0020 × 0021 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 2060 × 00A0 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] NO-BREAK SPACE (GL) ÷ [0.3]
× 2060 × 0020 ÷ 00A0 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 2060 × 0308 × 00A0 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] NO-BREAK SPACE (GL) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 2060 × AC00 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2060 × 0020 ÷ AC00 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2060 × 0308 × AC00 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 2060 × AC01 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2060 × 0020 ÷ AC01 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2060 × 0308 × AC01 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 2060 × 05D0 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2060 × 0020 ÷ 05D0 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2060 × 0308 × 05D0 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 2060 × 002D ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 2060 × 0020 ÷ 002D ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2060 × 0308 × 002D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 2060 × 231A ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] WATCH (ID) ÷ [0.3]
× 2060 × 0020 ÷ 231A ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 2060 × 0308 × 231A ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] WATCH (ID) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 2060 × 2024 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] ONE DOT LEADER (IN) ÷ [0.3]
× 2060 × 0020 ÷ 2024 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2060 × 0308 × 2024 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] ONE DOT LEADER (IN) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2060 × 002C ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] COMMA (IS) ÷ [0.3]
× 2060 × 0020 × 002C ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 2060 × 0308 × 002C ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] COMMA (IS) ÷ [0.3]
× 2060 × 0308 × 0020 × 002C ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 2060 × 1100 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2060 × 0020 ÷ 1100 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2060 × 0308 × 1100 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 2060 × 11A8 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2060 × 0020 ÷ 11A8 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2060 × 0308 × 11A8 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 2060 × 1160 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2060 × 0020 ÷ 1160 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2060 × 0308 × 1160 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 2060 × 000A ÷	#  × [0.3] WORD JOINER (WJ) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2060 × 0020 × 000A ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2060 × 0308 × 000A ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2060 × 0308 × 0020 × 000A ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 2060 × 0085 ÷	#  × [0.3] WORD JOINER (WJ) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2060 × 0020 × 0085 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2060 × 0308 × 0085 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2060 × 0308 × 0020 × 0085 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 2060 × 17D6 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2060 × 0020 ÷ 17D6 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2060 × 0308 × 17D6 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 2060 × 0030 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] DIGIT ZERO (NU) ÷ [0.3]
× 2060 × 0020 ÷ 0030 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 2060 × 0308 × 0030 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] DIGIT ZERO (NU) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 2060 × 2329 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2060 × 0020 ÷ 2329 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2060 × 0308 × 2329 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 2060 × 0025 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] PERCENT SIGN (PO) ÷ [0.3]
× 2060 × 0020 ÷ 0025 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 2060 × 0308 × 0025 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] PERCENT SIGN (PO) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 2060 × 0024 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] DOLLAR SIGN (PR) ÷ [0.3]
× 2060 × 0020 ÷ 0024 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2060 × 0308 × 0024 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] DOLLAR SIGN (PR) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 2060 × 0022 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] QUOTATION MARK (QU) ÷ [0.3]
× 2060 × 0020 ÷ 0022 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 2060 × 0308 × 0022 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] QUOTATION MARK (QU) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 2060 × 0020 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [0.3]
× 2060 × 0020 × 0020 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 2060 × 0308 × 0020 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 2060 × 0308 × 0020 × 0020 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 2060 × 002F ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] SOLIDUS (SY) ÷ [0.3]
× 2060 × 0020 × 002F ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2060 × 0308 × 002F ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] SOLIDUS (SY) ÷ [0.3]
× 2060 × 0308 × 0020 × 002F ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 2060 × 2060 ÷	#  × [0.3] WORD JOINER (WJ) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2060 × 0020 × 2060 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2060 × 0308 × 2060 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2060 × 0308 × 0020 × 2060 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2060 × 200B ÷	#  × [0.3] WORD JOINER (WJ) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2060 × 0020 × 200B ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2060 × 0308 × 200B ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2060 × 0308 × 0020 × 200B ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 2060 × 1F1E6 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2060 × 0020 ÷ 1F1E6 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2060 × 0308 × 1F1E6 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 2060 × 261D ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2060 × 0020 ÷ 261D ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2060 × 0308 × 261D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 2060 × 1F3FB ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2060 × 0020 ÷ 1F3FB ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2060 × 0308 × 1F3FB ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 2060 × 0029 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2060 × 0020 × 0029 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2060 × 0308 × 0029 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2060 × 0308 × 0020 × 0029 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 2060 × 0028 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2060 × 0020 ÷ 0028 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2060 × 0308 × 0028 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 2060 × 0001 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2060 × 0020 ÷ 0001 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2060 × 0308 × 0001 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 2060 × 200D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2060 × 0020 ÷ 200D ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2060 × 0308 × 200D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 2060 × 00A7 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 2060 × 0020 ÷ 00A7 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2060 × 0308 × 00A7 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 2060 × 50005 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 2060 × 0020 ÷ 50005 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2060 × 0308 × 50005 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 2060 × 0E01 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2060 × 0020 ÷ 0E01 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2060 × 0308 × 0E01 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 2060 × 3041 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2060 × 0020 ÷ 3041 ÷	#  × [0.3] WORD JOINER (WJ) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2060 × 0308 × 3041 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 2060 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] WORD JOINER (WJ) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200B ÷ 0023 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] NUMBER SIGN (AL) ÷ [0.3]
× 200B × 0020 ÷ 0023 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] NUMBER SIGN (AL) ÷ [0.3]
× 200B ÷ 0308 × 0023 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0023 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 200B ÷ 2014 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] EM DASH (B2) ÷ [0.3]
× 200B × 0020 ÷ 2014 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] EM DASH (B2) ÷ [0.3]
× 200B ÷ 0308 ÷ 2014 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 2014 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 200B ÷ 0009 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 200B × 0020 ÷ 0009 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 200B ÷ 0308 × 0009 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0009 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 200B ÷ 00B4 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] ACUTE ACCENT (BB) ÷ [0.3]
× 200B × 0020 ÷ 00B4 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] ACUTE ACCENT (BB) ÷ [0.3]
× 200B ÷ 0308 ÷ 00B4 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 200B × 000B ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 200B × 0020 × 000B ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 200B ÷ 0308 × 000B ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 000B ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 200B ÷ FFFC ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 200B × 0020 ÷ FFFC ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 200B ÷ 0308 ÷ FFFC ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ FFFC ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 200B ÷ 007D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 200B × 0020 ÷ 007D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 200B ÷ 0308 × 007D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 007D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 200B × 000D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 200B × 0020 × 000D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 200B ÷ 0308 × 000D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 000D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 200B ÷ 0021 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] EXCLAMATION MARK (EX) ÷ [0.3]
× 200B × 0020 ÷ 0021 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] EXCLAMATION MARK (EX) ÷ [0.3]
× 200B ÷ 0308 × 0021 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 0021 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 200B ÷ 00A0 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 200B × 0020 ÷ 00A0 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 200B ÷ 0308 × 00A0 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 200B ÷ AC00 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 200B × 0020 ÷ AC00 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 200B ÷ 0308 ÷ AC00 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ AC00 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 200B ÷ AC01 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 200B × 0020 ÷ AC01 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 200B ÷ 0308 ÷ AC01 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ AC01 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 200B ÷ 05D0 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 200B × 0020 ÷ 05D0 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 200B ÷ 0308 × 05D0 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 200B ÷ 002D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 200B × 0020 ÷ 002D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 200B ÷ 0308 × 002D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 002D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 200B ÷ 231A ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] WATCH (ID) ÷ [0.3]
× 200B × 0020 ÷ 231A ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] WATCH (ID) ÷ [0.3]
× 200B ÷ 0308 ÷ 231A ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 231A ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 200B ÷ 2024 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] ONE DOT LEADER (IN) ÷ [0.3]
× 200B × 0020 ÷ 2024 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] ONE DOT LEADER (IN) ÷ [0.3]
× 200B ÷ 0308 × 2024 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 2024 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 200B ÷ 002C ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMMA (IS) ÷ [0.3]
× 200B × 0020 ÷ 002C ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] COMMA (IS) ÷ [0.3]
× 200B ÷ 0308 × 002C ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 002C ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 200B ÷ 1100 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 200B × 0020 ÷ 1100 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 200B ÷ 0308 ÷ 1100 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 1100 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 200B ÷ 11A8 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 200B × 0020 ÷ 11A8 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 200B ÷ 0308 ÷ 11A8 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 200B ÷ 1160 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 200B × 0020 ÷ 1160 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 200B ÷ 0308 ÷ 1160 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 1160 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 200B × 000A ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 200B × 0020 × 000A ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 200B ÷ 0308 × 000A ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 000A ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 200B × 0085 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 200B × 0020 × 0085 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 200B ÷ 0308 × 0085 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 0085 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 200B ÷ 17D6 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 200B × 0020 ÷ 17D6 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 200B ÷ 0308 × 17D6 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 200B ÷ 0030 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] DIGIT ZERO (NU) ÷ [0.3]
× 200B × 0020 ÷ 0030 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] DIGIT ZERO (NU) ÷ [0.3]
× 200B ÷ 0308 × 0030 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0030 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 200B ÷ 2329 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 200B × 0020 ÷ 2329 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 200B ÷ 0308 ÷ 2329 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 2329 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 200B ÷ 0025 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] PERCENT SIGN (PO) ÷ [0.3]
× 200B × 0020 ÷ 0025 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] PERCENT SIGN (PO) ÷ [0.3]
× 200B ÷ 0308 × 0025 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0025 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 200B ÷ 0024 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] DOLLAR SIGN (PR) ÷ [0.3]
× 200B × 0020 ÷ 0024 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] DOLLAR SIGN (PR) ÷ [0.3]
× 200B ÷ 0308 × 0024 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0024 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 200B ÷ 0022 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] QUOTATION MARK (QU) ÷ [0.3]
× 200B × 0020 ÷ 0022 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] QUOTATION MARK (QU) ÷ [0.3]
× 200B ÷ 0308 × 0022 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0022 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 200B × 0020 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [0.3]
× 200B × 0020 × 0020 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 0020 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 200B ÷ 002F ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] SOLIDUS (SY) ÷ [0.3]
× 200B × 0020 ÷ 002F ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] SOLIDUS (SY) ÷ [0.3]
× 200B ÷ 0308 × 002F ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 002F ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 200B ÷ 2060 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] WORD JOINER (WJ) ÷ [0.3]
× 200B × 0020 ÷ 2060 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] WORD JOINER (WJ) ÷ [0.3]
× 200B ÷ 0308 × 2060 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 2060 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 200B × 200B ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 200B × 0020 × 200B ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 200B ÷ 0308 × 200B ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 200B ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 200B ÷ 1F1E6 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 200B × 0020 ÷ 1F1E6 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 200B ÷ 0308 ÷ 1F1E6 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 200B ÷ 261D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 200B × 0020 ÷ 261D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 200B ÷ 0308 ÷ 261D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 261D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 200B ÷ 1F3FB ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 200B × 0020 ÷ 1F3FB ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 200B ÷ 0308 ÷ 1F3FB ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 200B ÷ 0029 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 200B × 0020 ÷ 0029 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 200B ÷ 0308 × 0029 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 200B ÷ 0308 × 0020 × 0029 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 200B ÷ 0028 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 200B × 0020 ÷ 0028 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 200B ÷ 0308 × 0028 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0028 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 200B ÷ 0001 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 200B × 0020 ÷ 0001 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 200B ÷ 0308 × 0001 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0001 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 200B ÷ 200D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 200B × 0020 ÷ 200D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 200B ÷ 0308 × 200D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 200D ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 200B ÷ 00A7 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 200B × 0020 ÷ 00A7 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 200B ÷ 0308 × 00A7 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 200B ÷ 50005 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 200B × 0020 ÷ 50005 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 200B ÷ 0308 × 50005 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 50005 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 200B ÷ 0E01 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 200B × 0020 ÷ 0E01 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 200B ÷ 0308 × 0E01 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 200B ÷ 3041 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200B × 0020 ÷ 3041 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) × [7.01] SPACE (SP) ÷ [8.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200B ÷ 0308 × 3041 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200B ÷ 0308 × 0020 ÷ 3041 ÷	#  × [0.3] ZERO WIDTH SPACE (ZW) ÷ [8.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1F1E6 ÷ 0023 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0023 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 1F1E6 × 0308 ÷ 0023 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 1F1E6 ÷ 2014 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 1F1E6 × 0020 ÷ 2014 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 1F1E6 × 0308 ÷ 2014 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 1F1E6 × 0009 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0009 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1F1E6 × 0308 × 0009 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1F1E6 ÷ 00B4 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1F1E6 × 0020 ÷ 00B4 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1F1E6 × 0308 ÷ 00B4 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1F1E6 × 000B ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1F1E6 × 0020 × 000B ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1F1E6 × 0308 × 000B ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 000B ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1F1E6 ÷ FFFC ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1F1E6 × 0020 ÷ FFFC ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1F1E6 × 0308 ÷ FFFC ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1F1E6 × 007D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1F1E6 × 0020 × 007D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1F1E6 × 0308 × 007D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 007D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1F1E6 × 000D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1F1E6 × 0020 × 000D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1F1E6 × 0308 × 000D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 000D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1F1E6 × 0021 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1F1E6 × 0020 × 0021 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1F1E6 × 0308 × 0021 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 0021 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1F1E6 × 00A0 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 1F1E6 × 0020 ÷ 00A0 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 1F1E6 × 0308 × 00A0 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 1F1E6 ÷ AC00 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1F1E6 × 0020 ÷ AC00 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1F1E6 × 0308 ÷ AC00 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1F1E6 ÷ AC01 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1F1E6 × 0020 ÷ AC01 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1F1E6 × 0308 ÷ AC01 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1F1E6 ÷ 05D0 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1F1E6 × 0020 ÷ 05D0 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1F1E6 × 0308 ÷ 05D0 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1F1E6 × 002D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 1F1E6 × 0020 ÷ 002D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 1F1E6 × 0308 × 002D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 1F1E6 ÷ 231A ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 1F1E6 × 0020 ÷ 231A ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 1F1E6 × 0308 ÷ 231A ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 1F1E6 × 2024 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1F1E6 × 0020 ÷ 2024 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1F1E6 × 0308 × 2024 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1F1E6 × 002C ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.02] COMMA (IS) ÷ [0.3]
× 1F1E6 × 0020 × 002C ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 1F1E6 × 0308 × 002C ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 002C ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 1F1E6 ÷ 1100 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1F1E6 × 0020 ÷ 1100 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1F1E6 × 0308 ÷ 1100 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1F1E6 ÷ 11A8 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1F1E6 × 0020 ÷ 11A8 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1F1E6 × 0308 ÷ 11A8 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1F1E6 ÷ 1160 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1F1E6 × 0020 ÷ 1160 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1F1E6 × 0308 ÷ 1160 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1F1E6 × 000A ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1F1E6 × 0020 × 000A ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1F1E6 × 0308 × 000A ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 000A ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1F1E6 × 0085 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1F1E6 × 0020 × 0085 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1F1E6 × 0308 × 0085 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 0085 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1F1E6 × 17D6 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1F1E6 × 0020 ÷ 17D6 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1F1E6 × 0308 × 17D6 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1F1E6 ÷ 0030 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0030 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 1F1E6 × 0308 ÷ 0030 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 1F1E6 ÷ 2329 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1F1E6 × 0020 ÷ 2329 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1F1E6 × 0308 ÷ 2329 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1F1E6 ÷ 0025 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0025 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 1F1E6 × 0308 ÷ 0025 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 1F1E6 ÷ 0024 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0024 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1F1E6 × 0308 ÷ 0024 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1F1E6 × 0022 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0022 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 1F1E6 × 0308 × 0022 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 1F1E6 × 0020 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [0.3]
× 1F1E6 × 0020 × 0020 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 0020 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 1F1E6 × 002F ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1F1E6 × 0020 × 002F ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1F1E6 × 0308 × 002F ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 002F ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1F1E6 × 2060 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1F1E6 × 0020 × 2060 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1F1E6 × 0308 × 2060 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 2060 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1F1E6 × 200B ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1F1E6 × 0020 × 200B ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1F1E6 × 0308 × 200B ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 200B ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1F1E6 × 1F1E6 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [30.11] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1F1E6 × 0020 ÷ 1F1E6 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1F1E6 × 0308 × 1F1E6 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.11] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1F1E6 ÷ 261D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1F1E6 × 0020 ÷ 261D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1F1E6 × 0308 ÷ 261D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1F1E6 ÷ 1F3FB ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1F1E6 × 0020 ÷ 1F3FB ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1F1E6 × 0308 ÷ 1F3FB ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1F1E6 × 0029 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1F1E6 × 0020 × 0029 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1F1E6 × 0308 × 0029 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1F1E6 × 0308 × 0020 × 0029 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1F1E6 ÷ 0028 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0028 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1F1E6 × 0308 ÷ 0028 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1F1E6 × 0001 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0001 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1F1E6 × 0308 × 0001 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1F1E6 × 200D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1F1E6 × 0020 ÷ 200D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1F1E6 × 0308 × 200D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1F1E6 ÷ 00A7 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1F1E6 × 0020 ÷ 00A7 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1F1E6 × 0308 ÷ 00A7 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1F1E6 ÷ 50005 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1F1E6 × 0020 ÷ 50005 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1F1E6 × 0308 ÷ 50005 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1F1E6 ÷ 0E01 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1F1E6 × 0020 ÷ 0E01 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1F1E6 × 0308 ÷ 0E01 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1F1E6 × 3041 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1F1E6 × 0020 ÷ 3041 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1F1E6 × 0308 × 3041 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1F1E6 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 261D ÷ 0023 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 261D × 0020 ÷ 0023 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 261D × 0308 ÷ 0023 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 261D ÷ 2014 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 261D × 0020 ÷ 2014 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 261D × 0308 ÷ 2014 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 261D × 0009 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 261D × 0020 ÷ 0009 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 261D × 0308 × 0009 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 261D ÷ 00B4 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 261D × 0020 ÷ 00B4 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 261D × 0308 ÷ 00B4 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 261D × 000B ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 261D × 0020 × 000B ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 261D × 0308 × 000B ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 261D × 0308 × 0020 × 000B ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 261D ÷ FFFC ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 261D × 0020 ÷ FFFC ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 261D × 0308 ÷ FFFC ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 261D × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 261D × 007D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 261D × 0020 × 007D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 261D × 0308 × 007D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 261D × 0308 × 0020 × 007D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 261D × 000D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 261D × 0020 × 000D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 261D × 0308 × 000D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 261D × 0308 × 0020 × 000D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 261D × 0021 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 261D × 0020 × 0021 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 261D × 0308 × 0021 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 261D × 0308 × 0020 × 0021 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 261D × 00A0 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 261D × 0020 ÷ 00A0 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 261D × 0308 × 00A0 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 261D ÷ AC00 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 261D × 0020 ÷ AC00 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 261D × 0308 ÷ AC00 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 261D × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 261D ÷ AC01 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 261D × 0020 ÷ AC01 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 261D × 0308 ÷ AC01 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 261D × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 261D ÷ 05D0 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 261D × 0020 ÷ 05D0 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 261D × 0308 ÷ 05D0 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 261D × 002D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 261D × 0020 ÷ 002D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 261D × 0308 × 002D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 002D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 261D ÷ 231A ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 261D × 0020 ÷ 231A ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 261D × 0308 ÷ 231A ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 231A ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 261D × 2024 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 261D × 0020 ÷ 2024 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 261D × 0308 × 2024 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 261D × 002C ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [13.02] COMMA (IS) ÷ [0.3]
× 261D × 0020 × 002C ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 261D × 0308 × 002C ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 261D × 0308 × 0020 × 002C ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 261D ÷ 1100 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 261D × 0020 ÷ 1100 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 261D × 0308 ÷ 1100 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 261D ÷ 11A8 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 261D × 0020 ÷ 11A8 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 261D × 0308 ÷ 11A8 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 261D ÷ 1160 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 261D × 0020 ÷ 1160 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 261D × 0308 ÷ 1160 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 261D × 000A ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 261D × 0020 × 000A ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 261D × 0308 × 000A ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 261D × 0308 × 0020 × 000A ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 261D × 0085 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 261D × 0020 × 0085 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 261D × 0308 × 0085 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 261D × 0308 × 0020 × 0085 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 261D × 17D6 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 261D × 0020 ÷ 17D6 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 261D × 0308 × 17D6 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 261D ÷ 0030 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 261D × 0020 ÷ 0030 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 261D × 0308 ÷ 0030 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 261D ÷ 2329 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 261D × 0020 ÷ 2329 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 261D × 0308 ÷ 2329 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 261D × 0025 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
× 261D × 0020 ÷ 0025 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 261D × 0308 × 0025 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 261D ÷ 0024 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 261D × 0020 ÷ 0024 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 261D × 0308 ÷ 0024 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 261D × 0022 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 261D × 0020 ÷ 0022 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 261D × 0308 × 0022 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 261D × 0020 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [0.3]
× 261D × 0020 × 0020 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 261D × 0308 × 0020 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 261D × 0308 × 0020 × 0020 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 261D × 002F ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 261D × 0020 × 002F ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 261D × 0308 × 002F ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 261D × 0308 × 0020 × 002F ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 261D × 2060 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 261D × 0020 × 2060 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 261D × 0308 × 2060 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 261D × 0308 × 0020 × 2060 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 261D × 200B ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 261D × 0020 × 200B ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 261D × 0308 × 200B ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 261D × 0308 × 0020 × 200B ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 261D ÷ 1F1E6 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 261D × 0020 ÷ 1F1E6 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 261D × 0308 ÷ 1F1E6 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 261D ÷ 261D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 261D × 0020 ÷ 261D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 261D × 0308 ÷ 261D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 261D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 261D × 1F3FB ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [30.2] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 261D × 0020 ÷ 1F3FB ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 261D × 0308 × 1F3FB ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.2] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 261D × 0029 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 261D × 0020 × 0029 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 261D × 0308 × 0029 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 261D × 0308 × 0020 × 0029 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 261D ÷ 0028 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 261D × 0020 ÷ 0028 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 261D × 0308 ÷ 0028 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 261D × 0001 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 261D × 0020 ÷ 0001 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 261D × 0308 × 0001 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 261D × 200D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 261D × 0020 ÷ 200D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 261D × 0308 × 200D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 200D ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 261D ÷ 00A7 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 261D × 0020 ÷ 00A7 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 261D × 0308 ÷ 00A7 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 261D ÷ 50005 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 261D × 0020 ÷ 50005 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 261D × 0308 ÷ 50005 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 261D ÷ 0E01 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 261D × 0020 ÷ 0E01 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 261D × 0308 ÷ 0E01 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 261D × 3041 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 261D × 0020 ÷ 3041 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 261D × 0308 × 3041 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 261D × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1F3FB ÷ 0023 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 1F3FB × 0020 ÷ 0023 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 1F3FB × 0308 ÷ 0023 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 1F3FB ÷ 2014 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 1F3FB × 0020 ÷ 2014 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 1F3FB × 0308 ÷ 2014 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 1F3FB × 0009 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1F3FB × 0020 ÷ 0009 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1F3FB × 0308 × 0009 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 1F3FB ÷ 00B4 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1F3FB × 0020 ÷ 00B4 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1F3FB × 0308 ÷ 00B4 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 1F3FB × 000B ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1F3FB × 0020 × 000B ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1F3FB × 0308 × 000B ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 000B ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 1F3FB ÷ FFFC ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1F3FB × 0020 ÷ FFFC ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1F3FB × 0308 ÷ FFFC ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 1F3FB × 007D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1F3FB × 0020 × 007D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1F3FB × 0308 × 007D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 007D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 1F3FB × 000D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1F3FB × 0020 × 000D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1F3FB × 0308 × 000D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 000D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 1F3FB × 0021 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1F3FB × 0020 × 0021 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1F3FB × 0308 × 0021 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 0021 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 1F3FB × 00A0 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 1F3FB × 0020 ÷ 00A0 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 1F3FB × 0308 × 00A0 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 1F3FB ÷ AC00 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1F3FB × 0020 ÷ AC00 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1F3FB × 0308 ÷ AC00 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 1F3FB ÷ AC01 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1F3FB × 0020 ÷ AC01 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1F3FB × 0308 ÷ AC01 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 1F3FB ÷ 05D0 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1F3FB × 0020 ÷ 05D0 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1F3FB × 0308 ÷ 05D0 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 1F3FB × 002D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 1F3FB × 0020 ÷ 002D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 1F3FB × 0308 × 002D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 002D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 1F3FB ÷ 231A ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 1F3FB × 0020 ÷ 231A ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 1F3FB × 0308 ÷ 231A ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 231A ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 1F3FB × 2024 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1F3FB × 0020 ÷ 2024 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1F3FB × 0308 × 2024 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1F3FB × 002C ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [13.02] COMMA (IS) ÷ [0.3]
× 1F3FB × 0020 × 002C ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 1F3FB × 0308 × 002C ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 002C ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 1F3FB ÷ 1100 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1F3FB × 0020 ÷ 1100 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1F3FB × 0308 ÷ 1100 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 1F3FB ÷ 11A8 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1F3FB × 0020 ÷ 11A8 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1F3FB × 0308 ÷ 11A8 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1F3FB ÷ 1160 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1F3FB × 0020 ÷ 1160 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1F3FB × 0308 ÷ 1160 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1F3FB × 000A ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1F3FB × 0020 × 000A ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1F3FB × 0308 × 000A ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 000A ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 1F3FB × 0085 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1F3FB × 0020 × 0085 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1F3FB × 0308 × 0085 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 0085 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 1F3FB × 17D6 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1F3FB × 0020 ÷ 17D6 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1F3FB × 0308 × 17D6 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 1F3FB ÷ 0030 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 1F3FB × 0020 ÷ 0030 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 1F3FB × 0308 ÷ 0030 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 1F3FB ÷ 2329 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1F3FB × 0020 ÷ 2329 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1F3FB × 0308 ÷ 2329 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 1F3FB × 0025 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
× 1F3FB × 0020 ÷ 0025 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 1F3FB × 0308 × 0025 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 1F3FB ÷ 0024 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1F3FB × 0020 ÷ 0024 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1F3FB × 0308 ÷ 0024 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 1F3FB × 0022 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 1F3FB × 0020 ÷ 0022 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 1F3FB × 0308 × 0022 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 1F3FB × 0020 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [0.3]
× 1F3FB × 0020 × 0020 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 0020 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 1F3FB × 002F ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1F3FB × 0020 × 002F ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1F3FB × 0308 × 002F ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 002F ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 1F3FB × 2060 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1F3FB × 0020 × 2060 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1F3FB × 0308 × 2060 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 2060 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 1F3FB × 200B ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1F3FB × 0020 × 200B ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1F3FB × 0308 × 200B ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 200B ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 1F3FB ÷ 1F1E6 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1F3FB × 0020 ÷ 1F1E6 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1F3FB × 0308 ÷ 1F1E6 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 1F3FB ÷ 261D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1F3FB × 0020 ÷ 261D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1F3FB × 0308 ÷ 261D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 261D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 1F3FB ÷ 1F3FB ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1F3FB × 0020 ÷ 1F3FB ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1F3FB × 0308 ÷ 1F3FB ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 1F3FB × 0029 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1F3FB × 0020 × 0029 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1F3FB × 0308 × 0029 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1F3FB × 0308 × 0020 × 0029 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 1F3FB ÷ 0028 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1F3FB × 0020 ÷ 0028 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1F3FB × 0308 ÷ 0028 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 1F3FB × 0001 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1F3FB × 0020 ÷ 0001 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1F3FB × 0308 × 0001 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 1F3FB × 200D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1F3FB × 0020 ÷ 200D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1F3FB × 0308 × 200D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 200D ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 1F3FB ÷ 00A7 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1F3FB × 0020 ÷ 00A7 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1F3FB × 0308 ÷ 00A7 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 1F3FB ÷ 50005 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1F3FB × 0020 ÷ 50005 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1F3FB × 0308 ÷ 50005 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 1F3FB ÷ 0E01 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1F3FB × 0020 ÷ 0E01 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1F3FB × 0308 ÷ 0E01 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1F3FB × 3041 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1F3FB × 0020 ÷ 3041 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1F3FB × 0308 × 3041 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 1F3FB × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0029 × 0023 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [30.02] NUMBER SIGN (AL) ÷ [0.3]
× 0029 × 0020 ÷ 0023 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0029 × 0308 × 0023 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.02] NUMBER SIGN (AL) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0029 ÷ 2014 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0029 × 0020 ÷ 2014 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0029 × 0308 ÷ 2014 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0029 × 0009 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0029 × 0020 ÷ 0009 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0029 × 0308 × 0009 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0029 ÷ 00B4 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0029 × 0020 ÷ 00B4 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0029 × 0308 ÷ 00B4 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0029 × 000B ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0029 × 0020 × 000B ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0029 × 0308 × 000B ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0029 × 0308 × 0020 × 000B ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0029 ÷ FFFC ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0029 × 0020 ÷ FFFC ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0029 × 0308 ÷ FFFC ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0029 × 007D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0029 × 0020 × 007D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0029 × 0308 × 007D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0029 × 0308 × 0020 × 007D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0029 × 000D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0029 × 0020 × 000D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0029 × 0308 × 000D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0029 × 0308 × 0020 × 000D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0029 × 0021 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0029 × 0020 × 0021 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0029 × 0308 × 0021 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0029 × 0308 × 0020 × 0021 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0029 × 00A0 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0029 × 0020 ÷ 00A0 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0029 × 0308 × 00A0 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0029 ÷ AC00 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0029 × 0020 ÷ AC00 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0029 × 0308 ÷ AC00 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0029 ÷ AC01 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0029 × 0020 ÷ AC01 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0029 × 0308 ÷ AC01 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0029 × 05D0 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [30.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0029 × 0020 ÷ 05D0 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0029 × 0308 × 05D0 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.02] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0029 × 002D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0029 × 0020 ÷ 002D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0029 × 0308 × 002D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0029 ÷ 231A ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0029 × 0020 ÷ 231A ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0029 × 0308 ÷ 231A ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0029 × 2024 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0029 × 0020 ÷ 2024 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0029 × 0308 × 2024 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0029 × 002C ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [13.02] COMMA (IS) ÷ [0.3]
× 0029 × 0020 × 002C ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0029 × 0308 × 002C ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0029 × 0308 × 0020 × 002C ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0029 ÷ 1100 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0029 × 0020 ÷ 1100 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0029 × 0308 ÷ 1100 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0029 ÷ 11A8 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0029 × 0020 ÷ 11A8 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0029 × 0308 ÷ 11A8 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0029 ÷ 1160 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0029 × 0020 ÷ 1160 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0029 × 0308 ÷ 1160 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0029 × 000A ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0029 × 0020 × 000A ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0029 × 0308 × 000A ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0029 × 0308 × 0020 × 000A ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0029 × 0085 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0029 × 0020 × 0085 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0029 × 0308 × 0085 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0029 × 0308 × 0020 × 0085 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0029 × 17D6 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0029 × 0020 × 17D6 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0029 × 0308 × 17D6 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0029 × 0308 × 0020 × 17D6 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [16.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0029 × 0030 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [30.02] DIGIT ZERO (NU) ÷ [0.3]
× 0029 × 0020 ÷ 0030 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0029 × 0308 × 0030 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.02] DIGIT ZERO (NU) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0029 ÷ 2329 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0029 × 0020 ÷ 2329 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0029 × 0308 ÷ 2329 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0029 ÷ 0025 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0029 × 0020 ÷ 0025 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0029 × 0308 ÷ 0025 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0029 ÷ 0024 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0029 × 0020 ÷ 0024 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0029 × 0308 ÷ 0024 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0029 × 0022 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0029 × 0020 ÷ 0022 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0029 × 0308 × 0022 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0029 × 0020 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [0.3]
× 0029 × 0020 × 0020 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0029 × 0308 × 0020 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0029 × 0308 × 0020 × 0020 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0029 × 002F ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0029 × 0020 × 002F ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0029 × 0308 × 002F ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0029 × 0308 × 0020 × 002F ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0029 × 2060 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0029 × 0020 × 2060 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0029 × 0308 × 2060 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0029 × 0308 × 0020 × 2060 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0029 × 200B ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0029 × 0020 × 200B ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0029 × 0308 × 200B ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0029 × 0308 × 0020 × 200B ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0029 ÷ 1F1E6 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0029 × 0020 ÷ 1F1E6 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0029 × 0308 ÷ 1F1E6 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0029 ÷ 261D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0029 × 0020 ÷ 261D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0029 × 0308 ÷ 261D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0029 ÷ 1F3FB ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0029 × 0020 ÷ 1F3FB ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0029 × 0308 ÷ 1F3FB ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0029 × 0029 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0029 × 0020 × 0029 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0029 × 0308 × 0029 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0029 × 0308 × 0020 × 0029 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0029 ÷ 0028 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0029 × 0020 ÷ 0028 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0029 × 0308 ÷ 0028 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0029 × 0001 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0029 × 0020 ÷ 0001 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0029 × 0308 × 0001 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0029 × 200D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0029 × 0020 ÷ 200D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0029 × 0308 × 200D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0029 × 00A7 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [30.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 0029 × 0020 ÷ 00A7 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0029 × 0308 × 00A7 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.02] SECTION SIGN (AI_AL) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0029 × 50005 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [30.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 0029 × 0020 ÷ 50005 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0029 × 0308 × 50005 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.02] <reserved-50005> (XX_AL) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0029 × 0E01 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [30.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0029 × 0020 ÷ 0E01 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0029 × 0308 × 0E01 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0029 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0029 × 3041 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0029 × 0020 × 3041 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0029 × 0308 × 3041 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0029 × 0308 × 0020 × 3041 ÷	#  × [0.3] RIGHT PARENTHESIS (CP_CP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [16.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0028 × 0023 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] NUMBER SIGN (AL) ÷ [0.3]
× 0028 × 0020 × 0023 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] NUMBER SIGN (AL) ÷ [0.3]
× 0028 × 0308 × 0023 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] NUMBER SIGN (AL) ÷ [0.3]
× 0028 × 0308 × 0020 × 0023 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] NUMBER SIGN (AL) ÷ [0.3]
× 0028 × 2014 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] EM DASH (B2) ÷ [0.3]
× 0028 × 0020 × 2014 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] EM DASH (B2) ÷ [0.3]
× 0028 × 0308 × 2014 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] EM DASH (B2) ÷ [0.3]
× 0028 × 0308 × 0020 × 2014 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] EM DASH (B2) ÷ [0.3]
× 0028 × 0009 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0028 × 0020 × 0009 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0028 × 0308 × 0009 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0028 × 0308 × 0020 × 0009 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0028 × 00B4 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0028 × 0020 × 00B4 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0028 × 0308 × 00B4 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0028 × 0308 × 0020 × 00B4 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0028 × 000B ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0028 × 0020 × 000B ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0028 × 0308 × 000B ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0028 × 0308 × 0020 × 000B ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0028 × FFFC ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0028 × 0020 × FFFC ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0028 × 0308 × FFFC ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0028 × 0308 × 0020 × FFFC ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0028 × 007D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0028 × 0020 × 007D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0028 × 0308 × 007D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0028 × 0308 × 0020 × 007D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0028 × 000D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0028 × 0020 × 000D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0028 × 0308 × 000D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0028 × 0308 × 0020 × 000D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0028 × 0021 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0028 × 0020 × 0021 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0028 × 0308 × 0021 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0028 × 0308 × 0020 × 0021 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0028 × 00A0 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0028 × 0020 × 00A0 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0028 × 0308 × 00A0 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0028 × 0308 × 0020 × 00A0 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0028 × AC00 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0028 × 0020 × AC00 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0028 × 0308 × AC00 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0028 × 0308 × 0020 × AC00 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0028 × AC01 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0028 × 0020 × AC01 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0028 × 0308 × AC01 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0028 × 0308 × 0020 × AC01 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0028 × 05D0 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0028 × 0020 × 05D0 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0028 × 0308 × 05D0 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0028 × 0308 × 0020 × 05D0 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0028 × 002D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0028 × 0020 × 002D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0028 × 0308 × 002D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0028 × 0308 × 0020 × 002D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0028 × 231A ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] WATCH (ID) ÷ [0.3]
× 0028 × 0020 × 231A ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] WATCH (ID) ÷ [0.3]
× 0028 × 0308 × 231A ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] WATCH (ID) ÷ [0.3]
× 0028 × 0308 × 0020 × 231A ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] WATCH (ID) ÷ [0.3]
× 0028 × 2024 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0028 × 0020 × 2024 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0028 × 0308 × 2024 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0028 × 0308 × 0020 × 2024 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0028 × 002C ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [13.02] COMMA (IS) ÷ [0.3]
× 0028 × 0020 × 002C ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0028 × 0308 × 002C ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0028 × 0308 × 0020 × 002C ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0028 × 1100 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0028 × 0020 × 1100 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0028 × 0308 × 1100 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0028 × 0308 × 0020 × 1100 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0028 × 11A8 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0028 × 0020 × 11A8 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0028 × 0308 × 11A8 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0028 × 0308 × 0020 × 11A8 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0028 × 1160 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0028 × 0020 × 1160 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0028 × 0308 × 1160 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0028 × 0308 × 0020 × 1160 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0028 × 000A ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0028 × 0020 × 000A ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0028 × 0308 × 000A ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0028 × 0308 × 0020 × 000A ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0028 × 0085 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0028 × 0020 × 0085 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0028 × 0308 × 0085 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0028 × 0308 × 0020 × 0085 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0028 × 17D6 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0028 × 0020 × 17D6 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0028 × 0308 × 17D6 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0028 × 0308 × 0020 × 17D6 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0028 × 0030 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] DIGIT ZERO (NU) ÷ [0.3]
× 0028 × 0020 × 0030 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] DIGIT ZERO (NU) ÷ [0.3]
× 0028 × 0308 × 0030 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] DIGIT ZERO (NU) ÷ [0.3]
× 0028 × 0308 × 0020 × 0030 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] DIGIT ZERO (NU) ÷ [0.3]
× 0028 × 2329 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0028 × 0020 × 2329 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0028 × 0308 × 2329 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0028 × 0308 × 0020 × 2329 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0028 × 0025 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] PERCENT SIGN (PO) ÷ [0.3]
× 0028 × 0020 × 0025 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] PERCENT SIGN (PO) ÷ [0.3]
× 0028 × 0308 × 0025 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] PERCENT SIGN (PO) ÷ [0.3]
× 0028 × 0308 × 0020 × 0025 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] PERCENT SIGN (PO) ÷ [0.3]
× 0028 × 0024 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0028 × 0020 × 0024 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0028 × 0308 × 0024 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0028 × 0308 × 0020 × 0024 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0028 × 0022 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] QUOTATION MARK (QU) ÷ [0.3]
× 0028 × 0020 × 0022 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] QUOTATION MARK (QU) ÷ [0.3]
× 0028 × 0308 × 0022 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] QUOTATION MARK (QU) ÷ [0.3]
× 0028 × 0308 × 0020 × 0022 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] QUOTATION MARK (QU) ÷ [0.3]
× 0028 × 0020 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) ÷ [0.3]
× 0028 × 0020 × 0020 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0028 × 0308 × 0020 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0028 × 0308 × 0020 × 0020 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0028 × 002F ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0028 × 0020 × 002F ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0028 × 0308 × 002F ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0028 × 0308 × 0020 × 002F ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0028 × 2060 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0028 × 0020 × 2060 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0028 × 0308 × 2060 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0028 × 0308 × 0020 × 2060 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0028 × 200B ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0028 × 0020 × 200B ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0028 × 0308 × 200B ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0028 × 0308 × 0020 × 200B ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0028 × 1F1E6 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0028 × 0020 × 1F1E6 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0028 × 0308 × 1F1E6 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0028 × 0308 × 0020 × 1F1E6 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0028 × 261D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0028 × 0020 × 261D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0028 × 0308 × 261D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0028 × 0308 × 0020 × 261D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0028 × 1F3FB ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0028 × 0020 × 1F3FB ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0028 × 0308 × 1F3FB ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0028 × 0308 × 0020 × 1F3FB ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0028 × 0029 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0028 × 0020 × 0029 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0028 × 0308 × 0029 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0028 × 0308 × 0020 × 0029 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0028 × 0028 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0028 × 0020 × 0028 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0028 × 0308 × 0028 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0028 × 0308 × 0020 × 0028 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0028 × 0001 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0028 × 0020 × 0001 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0028 × 0308 × 0001 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0028 × 0308 × 0020 × 0001 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0028 × 200D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0028 × 0020 × 200D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0028 × 0308 × 200D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0028 × 0308 × 0020 × 200D ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0028 × 00A7 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0028 × 0020 × 00A7 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0028 × 0308 × 00A7 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0028 × 0308 × 0020 × 00A7 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0028 × 50005 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0028 × 0020 × 50005 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0028 × 0308 × 50005 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0028 × 0308 × 0020 × 50005 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0028 × 0E01 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0028 × 0020 × 0E01 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0028 × 0308 × 0E01 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0028 × 0308 × 0020 × 0E01 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0028 × 3041 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0028 × 0020 × 3041 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0028 × 0308 × 3041 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [14.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0028 × 0308 × 0020 × 3041 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [14.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0001 × 0023 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 0001 × 0020 ÷ 0023 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0001 × 0308 × 0023 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0001 ÷ 2014 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0001 × 0020 ÷ 2014 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0001 × 0308 ÷ 2014 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0001 × 0009 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0001 × 0020 ÷ 0009 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0001 × 0308 × 0009 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0001 ÷ 00B4 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0001 × 0020 ÷ 00B4 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0001 × 0308 ÷ 00B4 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0001 × 000B ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0001 × 0020 × 000B ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0001 × 0308 × 000B ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0001 × 0308 × 0020 × 000B ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0001 ÷ FFFC ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0001 × 0020 ÷ FFFC ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0001 × 0308 ÷ FFFC ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0001 × 007D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [13.04] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0001 × 0020 × 007D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0001 × 0308 × 007D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.04] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0001 × 0308 × 0020 × 007D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0001 × 000D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0001 × 0020 × 000D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0001 × 0308 × 000D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0001 × 0308 × 0020 × 000D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0001 × 0021 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0001 × 0020 × 0021 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0001 × 0308 × 0021 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0001 × 0308 × 0020 × 0021 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0001 × 00A0 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [12.3] NO-BREAK SPACE (GL) ÷ [0.3]
× 0001 × 0020 ÷ 00A0 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0001 × 0308 × 00A0 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.3] NO-BREAK SPACE (GL) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0001 ÷ AC00 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0001 × 0020 ÷ AC00 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0001 × 0308 ÷ AC00 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0001 ÷ AC01 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0001 × 0020 ÷ AC01 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0001 × 0308 ÷ AC01 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0001 × 05D0 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0001 × 0020 ÷ 05D0 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0001 × 0308 × 05D0 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0001 × 002D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0001 × 0020 ÷ 002D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0001 × 0308 × 002D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0001 ÷ 231A ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0001 × 0020 ÷ 231A ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0001 × 0308 ÷ 231A ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0001 × 2024 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0001 × 0020 ÷ 2024 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0001 × 0308 × 2024 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0001 × 002C ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [13.04] COMMA (IS) ÷ [0.3]
× 0001 × 0020 × 002C ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0001 × 0308 × 002C ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.04] COMMA (IS) ÷ [0.3]
× 0001 × 0308 × 0020 × 002C ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0001 ÷ 1100 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0001 × 0020 ÷ 1100 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0001 × 0308 ÷ 1100 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0001 ÷ 11A8 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0001 × 0020 ÷ 11A8 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0001 × 0308 ÷ 11A8 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0001 ÷ 1160 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0001 × 0020 ÷ 1160 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0001 × 0308 ÷ 1160 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0001 × 000A ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0001 × 0020 × 000A ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0001 × 0308 × 000A ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0001 × 0308 × 0020 × 000A ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0001 × 0085 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0001 × 0020 × 0085 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0001 × 0308 × 0085 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0001 × 0308 × 0020 × 0085 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0001 × 17D6 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0001 × 0020 ÷ 17D6 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0001 × 0308 × 17D6 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0001 × 0030 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0001 × 0020 ÷ 0030 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0001 × 0308 × 0030 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0001 ÷ 2329 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0001 × 0020 ÷ 2329 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0001 × 0308 ÷ 2329 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0001 × 0025 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 0001 × 0020 ÷ 0025 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0001 × 0308 × 0025 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0001 × 0024 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 0001 × 0020 ÷ 0024 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0001 × 0308 × 0024 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0001 × 0022 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0001 × 0020 ÷ 0022 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0001 × 0308 × 0022 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0001 × 0020 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0001 × 0020 × 0020 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0001 × 0308 × 0020 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0001 × 0308 × 0020 × 0020 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0001 × 002F ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [13.04] SOLIDUS (SY) ÷ [0.3]
× 0001 × 0020 × 002F ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0001 × 0308 × 002F ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.04] SOLIDUS (SY) ÷ [0.3]
× 0001 × 0308 × 0020 × 002F ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0001 × 2060 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0001 × 0020 × 2060 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0001 × 0308 × 2060 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0001 × 0308 × 0020 × 2060 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0001 × 200B ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0001 × 0020 × 200B ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0001 × 0308 × 200B ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0001 × 0308 × 0020 × 200B ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0001 ÷ 1F1E6 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0001 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0001 × 0308 ÷ 1F1E6 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0001 ÷ 261D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0001 × 0020 ÷ 261D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0001 × 0308 ÷ 261D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0001 ÷ 1F3FB ÷	#  × [0.3] <START OF HEADING> (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0001 × 0020 ÷ 1F3FB ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0001 × 0308 ÷ 1F3FB ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0001 × 0029 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [13.04] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0001 × 0020 × 0029 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0001 × 0308 × 0029 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.04] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0001 × 0308 × 0020 × 0029 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0001 × 0028 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0001 × 0020 ÷ 0028 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0001 × 0308 × 0028 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0001 × 0001 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0001 × 0020 ÷ 0001 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0001 × 0308 × 0001 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0001 × 200D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0001 × 0020 ÷ 200D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0001 × 0308 × 200D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0001 × 00A7 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0001 × 0020 ÷ 00A7 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0001 × 0308 × 00A7 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0001 × 50005 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0001 × 0020 ÷ 50005 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0001 × 0308 × 50005 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0001 × 0E01 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0001 × 0020 ÷ 0E01 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0001 × 0308 × 0E01 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0001 × 3041 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0001 × 0020 ÷ 3041 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0001 × 0308 × 3041 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0001 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] <START OF HEADING> (CM1_CM) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200D × 0023 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] NUMBER SIGN (AL) ÷ [0.3]
× 200D × 0020 ÷ 0023 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 200D × 0308 × 0023 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 200D × 2014 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] EM DASH (B2) ÷ [0.3]
× 200D × 0020 ÷ 2014 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 200D × 0308 ÷ 2014 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 200D × 0009 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 200D × 0020 ÷ 0009 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 200D × 0308 × 0009 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 200D × 00B4 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] ACUTE ACCENT (BB) ÷ [0.3]
× 200D × 0020 ÷ 00B4 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 200D × 0308 ÷ 00B4 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 200D × 000B ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 200D × 0020 × 000B ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 200D × 0308 × 000B ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 200D × 0308 × 0020 × 000B ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 200D × FFFC ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 200D × 0020 ÷ FFFC ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 200D × 0308 ÷ FFFC ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 200D × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 200D × 007D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 200D × 0020 × 007D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 200D × 0308 × 007D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [13.04] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 200D × 0308 × 0020 × 007D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 200D × 000D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 200D × 0020 × 000D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 200D × 0308 × 000D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 200D × 0308 × 0020 × 000D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 200D × 0021 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] EXCLAMATION MARK (EX) ÷ [0.3]
× 200D × 0020 × 0021 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 200D × 0308 × 0021 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 200D × 0308 × 0020 × 0021 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 200D × 00A0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 200D × 0020 ÷ 00A0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 200D × 0308 × 00A0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [12.3] NO-BREAK SPACE (GL) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 200D × AC00 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 200D × 0020 ÷ AC00 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 200D × 0308 ÷ AC00 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 200D × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 200D × AC01 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 200D × 0020 ÷ AC01 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 200D × 0308 ÷ AC01 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 200D × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 200D × 05D0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 200D × 0020 ÷ 05D0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 200D × 0308 × 05D0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 200D × 002D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] HYPHEN-MINUS (HY) ÷ [0.3]
× 200D × 0020 ÷ 002D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 200D × 0308 × 002D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 002D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 200D × 231A ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] WATCH (ID) ÷ [0.3]
× 200D × 0020 ÷ 231A ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 200D × 0308 ÷ 231A ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 231A ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 200D × 2024 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] ONE DOT LEADER (IN) ÷ [0.3]
× 200D × 0020 ÷ 2024 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 200D × 0308 × 2024 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 200D × 002C ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMMA (IS) ÷ [0.3]
× 200D × 0020 × 002C ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 200D × 0308 × 002C ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [13.04] COMMA (IS) ÷ [0.3]
× 200D × 0308 × 0020 × 002C ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 200D × 1100 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 200D × 0020 ÷ 1100 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 200D × 0308 ÷ 1100 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 200D × 11A8 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 200D × 0020 ÷ 11A8 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 200D × 0308 ÷ 11A8 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 200D × 1160 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 200D × 0020 ÷ 1160 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 200D × 0308 ÷ 1160 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 200D × 000A ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 200D × 0020 × 000A ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 200D × 0308 × 000A ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 200D × 0308 × 0020 × 000A ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 200D × 0085 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 200D × 0020 × 0085 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 200D × 0308 × 0085 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 200D × 0308 × 0020 × 0085 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 200D × 17D6 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 200D × 0020 ÷ 17D6 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 200D × 0308 × 17D6 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 200D × 0030 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] DIGIT ZERO (NU) ÷ [0.3]
× 200D × 0020 ÷ 0030 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 200D × 0308 × 0030 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 200D × 2329 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 200D × 0020 ÷ 2329 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 200D × 0308 ÷ 2329 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 200D × 0025 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] PERCENT SIGN (PO) ÷ [0.3]
× 200D × 0020 ÷ 0025 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 200D × 0308 × 0025 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 200D × 0024 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] DOLLAR SIGN (PR) ÷ [0.3]
× 200D × 0020 ÷ 0024 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 200D × 0308 × 0024 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 200D × 0022 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] QUOTATION MARK (QU) ÷ [0.3]
× 200D × 0020 ÷ 0022 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 200D × 0308 × 0022 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 200D × 0020 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 200D × 0020 × 0020 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 200D × 0308 × 0020 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 200D × 0308 × 0020 × 0020 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 200D × 002F ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] SOLIDUS (SY) ÷ [0.3]
× 200D × 0020 × 002F ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 200D × 0308 × 002F ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [13.04] SOLIDUS (SY) ÷ [0.3]
× 200D × 0308 × 0020 × 002F ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 200D × 2060 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] WORD JOINER (WJ) ÷ [0.3]
× 200D × 0020 × 2060 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 200D × 0308 × 2060 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 200D × 0308 × 0020 × 2060 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 200D × 200B ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 200D × 0020 × 200B ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 200D × 0308 × 200B ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 200D × 0308 × 0020 × 200B ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 200D × 1F1E6 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 200D × 0020 ÷ 1F1E6 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 200D × 0308 ÷ 1F1E6 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 200D × 261D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 200D × 0020 ÷ 261D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 200D × 0308 ÷ 261D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 261D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 200D × 1F3FB ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 200D × 0020 ÷ 1F3FB ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 200D × 0308 ÷ 1F3FB ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 200D × 0029 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 200D × 0020 × 0029 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 200D × 0308 × 0029 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [13.04] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 200D × 0308 × 0020 × 0029 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 200D × 0028 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 200D × 0020 ÷ 0028 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 200D × 0308 × 0028 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 200D × 0001 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 200D × 0020 ÷ 0001 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 200D × 0308 × 0001 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 200D × 200D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 200D × 0020 ÷ 200D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 200D × 0308 × 200D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 200D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 200D × 00A7 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] SECTION SIGN (AI_AL) ÷ [0.3]
× 200D × 0020 ÷ 00A7 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 200D × 0308 × 00A7 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 200D × 50005 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] <reserved-50005> (XX_AL) ÷ [0.3]
× 200D × 0020 ÷ 50005 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 200D × 0308 × 50005 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 200D × 0E01 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 200D × 0020 ÷ 0E01 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 200D × 0308 × 0E01 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 200D × 3041 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200D × 0020 ÷ 3041 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200D × 0308 × 3041 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200D × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00A7 × 0023 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 00A7 × 0020 ÷ 0023 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 00A7 × 0308 × 0023 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 00A7 ÷ 2014 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 00A7 × 0020 ÷ 2014 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 00A7 × 0308 ÷ 2014 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 00A7 × 0009 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00A7 × 0020 ÷ 0009 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00A7 × 0308 × 0009 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 00A7 ÷ 00B4 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00A7 × 0020 ÷ 00B4 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00A7 × 0308 ÷ 00B4 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 00A7 × 000B ÷	#  × [0.3] SECTION SIGN (AI_AL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00A7 × 0020 × 000B ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00A7 × 0308 × 000B ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00A7 × 0308 × 0020 × 000B ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 00A7 ÷ FFFC ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00A7 × 0020 ÷ FFFC ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00A7 × 0308 ÷ FFFC ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 00A7 × 007D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00A7 × 0020 × 007D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00A7 × 0308 × 007D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00A7 × 0308 × 0020 × 007D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 00A7 × 000D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00A7 × 0020 × 000D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00A7 × 0308 × 000D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00A7 × 0308 × 0020 × 000D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 00A7 × 0021 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00A7 × 0020 × 0021 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00A7 × 0308 × 0021 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00A7 × 0308 × 0020 × 0021 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 00A7 × 00A0 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 00A7 × 0020 ÷ 00A0 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 00A7 × 0308 × 00A0 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 00A7 ÷ AC00 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00A7 × 0020 ÷ AC00 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00A7 × 0308 ÷ AC00 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 00A7 ÷ AC01 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00A7 × 0020 ÷ AC01 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00A7 × 0308 ÷ AC01 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 00A7 × 05D0 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00A7 × 0020 ÷ 05D0 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00A7 × 0308 × 05D0 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 00A7 × 002D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 00A7 × 0020 ÷ 002D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 00A7 × 0308 × 002D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 00A7 ÷ 231A ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 00A7 × 0020 ÷ 231A ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 00A7 × 0308 ÷ 231A ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 00A7 × 2024 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00A7 × 0020 ÷ 2024 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00A7 × 0308 × 2024 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 00A7 × 002C ÷	#  × [0.3] SECTION SIGN (AI_AL) × [13.02] COMMA (IS) ÷ [0.3]
× 00A7 × 0020 × 002C ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 00A7 × 0308 × 002C ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 00A7 × 0308 × 0020 × 002C ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 00A7 ÷ 1100 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00A7 × 0020 ÷ 1100 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00A7 × 0308 ÷ 1100 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 00A7 ÷ 11A8 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00A7 × 0020 ÷ 11A8 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00A7 × 0308 ÷ 11A8 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 00A7 ÷ 1160 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00A7 × 0020 ÷ 1160 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00A7 × 0308 ÷ 1160 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 00A7 × 000A ÷	#  × [0.3] SECTION SIGN (AI_AL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00A7 × 0020 × 000A ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00A7 × 0308 × 000A ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00A7 × 0308 × 0020 × 000A ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 00A7 × 0085 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00A7 × 0020 × 0085 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00A7 × 0308 × 0085 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00A7 × 0308 × 0020 × 0085 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 00A7 × 17D6 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00A7 × 0020 ÷ 17D6 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00A7 × 0308 × 17D6 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 00A7 × 0030 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 00A7 × 0020 ÷ 0030 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 00A7 × 0308 × 0030 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 00A7 ÷ 2329 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00A7 × 0020 ÷ 2329 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00A7 × 0308 ÷ 2329 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 00A7 × 0025 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 00A7 × 0020 ÷ 0025 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 00A7 × 0308 × 0025 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 00A7 × 0024 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 00A7 × 0020 ÷ 0024 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 00A7 × 0308 × 0024 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 00A7 × 0022 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 00A7 × 0020 ÷ 0022 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 00A7 × 0308 × 0022 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 00A7 × 0020 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [0.3]
× 00A7 × 0020 × 0020 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 00A7 × 0308 × 0020 × 0020 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 00A7 × 002F ÷	#  × [0.3] SECTION SIGN (AI_AL) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 00A7 × 0020 × 002F ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 00A7 × 0308 × 002F ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 00A7 × 0308 × 0020 × 002F ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 00A7 × 2060 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00A7 × 0020 × 2060 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00A7 × 0308 × 2060 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00A7 × 0308 × 0020 × 2060 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 00A7 × 200B ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00A7 × 0020 × 200B ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00A7 × 0308 × 200B ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00A7 × 0308 × 0020 × 200B ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 00A7 ÷ 1F1E6 ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00A7 × 0020 ÷ 1F1E6 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00A7 × 0308 ÷ 1F1E6 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 00A7 ÷ 261D ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00A7 × 0020 ÷ 261D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00A7 × 0308 ÷ 261D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 00A7 ÷ 1F3FB ÷	#  × [0.3] SECTION SIGN (AI_AL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00A7 × 0020 ÷ 1F3FB ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00A7 × 0308 ÷ 1F3FB ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 00A7 × 0029 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00A7 × 0020 × 0029 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00A7 × 0308 × 0029 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00A7 × 0308 × 0020 × 0029 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 00A7 × 0028 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00A7 × 0020 ÷ 0028 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00A7 × 0308 × 0028 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 00A7 × 0001 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00A7 × 0020 ÷ 0001 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00A7 × 0308 × 0001 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 00A7 × 200D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00A7 × 0020 ÷ 200D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00A7 × 0308 × 200D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 00A7 × 00A7 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00A7 × 0020 ÷ 00A7 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00A7 × 0308 × 00A7 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 00A7 × 50005 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00A7 × 0020 ÷ 50005 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00A7 × 0308 × 50005 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 00A7 × 0E01 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00A7 × 0020 ÷ 0E01 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00A7 × 0308 × 0E01 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 00A7 × 3041 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00A7 × 0020 ÷ 3041 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00A7 × 0308 × 3041 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 00A7 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] SECTION SIGN (AI_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 50005 × 0023 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 50005 × 0020 ÷ 0023 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 50005 × 0308 × 0023 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 50005 ÷ 2014 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 50005 × 0020 ÷ 2014 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 50005 × 0308 ÷ 2014 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 50005 × 0009 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 50005 × 0020 ÷ 0009 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 50005 × 0308 × 0009 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 50005 ÷ 00B4 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 50005 × 0020 ÷ 00B4 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 50005 × 0308 ÷ 00B4 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 50005 × 000B ÷	#  × [0.3] <reserved-50005> (XX_AL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 50005 × 0020 × 000B ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 50005 × 0308 × 000B ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 50005 × 0308 × 0020 × 000B ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 50005 ÷ FFFC ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 50005 × 0020 ÷ FFFC ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 50005 × 0308 ÷ FFFC ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 50005 × 007D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 50005 × 0020 × 007D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 50005 × 0308 × 007D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 50005 × 0308 × 0020 × 007D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 50005 × 000D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 50005 × 0020 × 000D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 50005 × 0308 × 000D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 50005 × 0308 × 0020 × 000D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 50005 × 0021 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 50005 × 0020 × 0021 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 50005 × 0308 × 0021 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 50005 × 0308 × 0020 × 0021 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 50005 × 00A0 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 50005 × 0020 ÷ 00A0 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 50005 × 0308 × 00A0 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 50005 ÷ AC00 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 50005 × 0020 ÷ AC00 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 50005 × 0308 ÷ AC00 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 50005 ÷ AC01 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 50005 × 0020 ÷ AC01 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 50005 × 0308 ÷ AC01 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 50005 × 05D0 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 50005 × 0020 ÷ 05D0 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 50005 × 0308 × 05D0 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 50005 × 002D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 50005 × 0020 ÷ 002D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 50005 × 0308 × 002D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 50005 ÷ 231A ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 50005 × 0020 ÷ 231A ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 50005 × 0308 ÷ 231A ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 50005 × 2024 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 50005 × 0020 ÷ 2024 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 50005 × 0308 × 2024 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 50005 × 002C ÷	#  × [0.3] <reserved-50005> (XX_AL) × [13.02] COMMA (IS) ÷ [0.3]
× 50005 × 0020 × 002C ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 50005 × 0308 × 002C ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 50005 × 0308 × 0020 × 002C ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 50005 ÷ 1100 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 50005 × 0020 ÷ 1100 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 50005 × 0308 ÷ 1100 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 50005 ÷ 11A8 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 50005 × 0020 ÷ 11A8 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 50005 × 0308 ÷ 11A8 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 50005 ÷ 1160 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 50005 × 0020 ÷ 1160 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 50005 × 0308 ÷ 1160 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 50005 × 000A ÷	#  × [0.3] <reserved-50005> (XX_AL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 50005 × 0020 × 000A ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 50005 × 0308 × 000A ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 50005 × 0308 × 0020 × 000A ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 50005 × 0085 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 50005 × 0020 × 0085 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 50005 × 0308 × 0085 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 50005 × 0308 × 0020 × 0085 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 50005 × 17D6 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 50005 × 0020 ÷ 17D6 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 50005 × 0308 × 17D6 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 50005 × 0030 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 50005 × 0020 ÷ 0030 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 50005 × 0308 × 0030 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 50005 ÷ 2329 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 50005 × 0020 ÷ 2329 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 50005 × 0308 ÷ 2329 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 50005 × 0025 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 50005 × 0020 ÷ 0025 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 50005 × 0308 × 0025 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 50005 × 0024 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 50005 × 0020 ÷ 0024 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 50005 × 0308 × 0024 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 50005 × 0022 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 50005 × 0020 ÷ 0022 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 50005 × 0308 × 0022 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 50005 × 0020 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [0.3]
× 50005 × 0020 × 0020 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 50005 × 0308 × 0020 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 50005 × 0308 × 0020 × 0020 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 50005 × 002F ÷	#  × [0.3] <reserved-50005> (XX_AL) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 50005 × 0020 × 002F ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 50005 × 0308 × 002F ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 50005 × 0308 × 0020 × 002F ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 50005 × 2060 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 50005 × 0020 × 2060 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 50005 × 0308 × 2060 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 50005 × 0308 × 0020 × 2060 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 50005 × 200B ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 50005 × 0020 × 200B ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 50005 × 0308 × 200B ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 50005 × 0308 × 0020 × 200B ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 50005 ÷ 1F1E6 ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 50005 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 50005 × 0308 ÷ 1F1E6 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 50005 ÷ 261D ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 50005 × 0020 ÷ 261D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 50005 × 0308 ÷ 261D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 50005 ÷ 1F3FB ÷	#  × [0.3] <reserved-50005> (XX_AL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 50005 × 0020 ÷ 1F3FB ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 50005 × 0308 ÷ 1F3FB ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 50005 × 0029 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 50005 × 0020 × 0029 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 50005 × 0308 × 0029 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 50005 × 0308 × 0020 × 0029 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 50005 × 0028 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 50005 × 0020 ÷ 0028 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 50005 × 0308 × 0028 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 50005 × 0001 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 50005 × 0020 ÷ 0001 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 50005 × 0308 × 0001 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 50005 × 200D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 50005 × 0020 ÷ 200D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 50005 × 0308 × 200D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 50005 × 00A7 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 50005 × 0020 ÷ 00A7 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 50005 × 0308 × 00A7 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 50005 × 50005 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 50005 × 0020 ÷ 50005 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 50005 × 0308 × 50005 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 50005 × 0E01 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 50005 × 0020 ÷ 0E01 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 50005 × 0308 × 0E01 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 50005 × 3041 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 50005 × 0020 ÷ 3041 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 50005 × 0308 × 3041 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 50005 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] <reserved-50005> (XX_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0E01 × 0023 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 0E01 × 0020 ÷ 0023 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0E01 × 0308 × 0023 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] NUMBER SIGN (AL) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 0E01 ÷ 2014 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0E01 × 0020 ÷ 2014 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0E01 × 0308 ÷ 2014 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 0E01 × 0009 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0E01 × 0020 ÷ 0009 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0E01 × 0308 × 0009 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 0E01 ÷ 00B4 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0E01 × 0020 ÷ 00B4 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0E01 × 0308 ÷ 00B4 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 0E01 × 000B ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0E01 × 0020 × 000B ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0E01 × 0308 × 000B ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0E01 × 0308 × 0020 × 000B ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 0E01 ÷ FFFC ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0E01 × 0020 ÷ FFFC ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0E01 × 0308 ÷ FFFC ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 0E01 × 007D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0E01 × 0020 × 007D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0E01 × 0308 × 007D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0E01 × 0308 × 0020 × 007D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0E01 × 000D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0E01 × 0020 × 000D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0E01 × 0308 × 000D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0E01 × 0308 × 0020 × 000D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 0E01 × 0021 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0E01 × 0020 × 0021 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0E01 × 0308 × 0021 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0E01 × 0308 × 0020 × 0021 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0E01 × 00A0 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 0E01 × 0020 ÷ 00A0 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0E01 × 0308 × 00A0 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 0E01 ÷ AC00 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0E01 × 0020 ÷ AC00 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0E01 × 0308 ÷ AC00 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 0E01 ÷ AC01 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0E01 × 0020 ÷ AC01 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0E01 × 0308 ÷ AC01 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 0E01 × 05D0 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0E01 × 0020 ÷ 05D0 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0E01 × 0308 × 05D0 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 0E01 × 002D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0E01 × 0020 ÷ 002D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0E01 × 0308 × 002D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 0E01 ÷ 231A ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0E01 × 0020 ÷ 231A ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0E01 × 0308 ÷ 231A ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 0E01 × 2024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0E01 × 0020 ÷ 2024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0E01 × 0308 × 2024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0E01 × 002C ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [13.02] COMMA (IS) ÷ [0.3]
× 0E01 × 0020 × 002C ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0E01 × 0308 × 002C ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 0E01 × 0308 × 0020 × 002C ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 0E01 ÷ 1100 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0E01 × 0020 ÷ 1100 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0E01 × 0308 ÷ 1100 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 0E01 ÷ 11A8 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0E01 × 0020 ÷ 11A8 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0E01 × 0308 ÷ 11A8 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 0E01 ÷ 1160 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0E01 × 0020 ÷ 1160 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0E01 × 0308 ÷ 1160 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 0E01 × 000A ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0E01 × 0020 × 000A ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0E01 × 0308 × 000A ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0E01 × 0308 × 0020 × 000A ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 0E01 × 0085 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0E01 × 0020 × 0085 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0E01 × 0308 × 0085 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0E01 × 0308 × 0020 × 0085 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 0E01 × 17D6 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0E01 × 0020 ÷ 17D6 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0E01 × 0308 × 17D6 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 0E01 × 0030 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0E01 × 0020 ÷ 0030 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0E01 × 0308 × 0030 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 0E01 ÷ 2329 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0E01 × 0020 ÷ 2329 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0E01 × 0308 ÷ 2329 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 0E01 × 0025 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 0E01 × 0020 ÷ 0025 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0E01 × 0308 × 0025 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] PERCENT SIGN (PO) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 0E01 × 0024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 0E01 × 0020 ÷ 0024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0E01 × 0308 × 0024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [24.03] DOLLAR SIGN (PR) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 0E01 × 0022 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0E01 × 0020 ÷ 0022 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0E01 × 0308 × 0022 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 0E01 × 0020 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [0.3]
× 0E01 × 0020 × 0020 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 0E01 × 0308 × 0020 × 0020 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0E01 × 002F ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0E01 × 0020 × 002F ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0E01 × 0308 × 002F ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 0E01 × 0308 × 0020 × 002F ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 0E01 × 2060 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0E01 × 0020 × 2060 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0E01 × 0308 × 2060 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0E01 × 0308 × 0020 × 2060 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 0E01 × 200B ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0E01 × 0020 × 200B ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0E01 × 0308 × 200B ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0E01 × 0308 × 0020 × 200B ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 0E01 ÷ 1F1E6 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0E01 × 0020 ÷ 1F1E6 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0E01 × 0308 ÷ 1F1E6 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 0E01 ÷ 261D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0E01 × 0020 ÷ 261D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0E01 × 0308 ÷ 261D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0E01 ÷ 1F3FB ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0E01 × 0020 ÷ 1F3FB ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0E01 × 0308 ÷ 1F3FB ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0E01 × 0029 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0E01 × 0020 × 0029 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0E01 × 0308 × 0029 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0E01 × 0308 × 0020 × 0029 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0E01 × 0028 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0E01 × 0020 ÷ 0028 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0E01 × 0308 × 0028 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 0E01 × 0001 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0E01 × 0020 ÷ 0001 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0E01 × 0308 × 0001 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 0E01 × 200D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0E01 × 0020 ÷ 200D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0E01 × 0308 × 200D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 0E01 × 00A7 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0E01 × 0020 ÷ 00A7 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0E01 × 0308 × 00A7 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 0E01 × 50005 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0E01 × 0020 ÷ 50005 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0E01 × 0308 × 50005 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 0E01 × 0E01 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0E01 × 0020 ÷ 0E01 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0E01 × 0308 × 0E01 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [28.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0E01 × 3041 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0E01 × 0020 ÷ 3041 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0E01 × 0308 × 3041 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0E01 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 3041 ÷ 0023 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 3041 × 0020 ÷ 0023 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 3041 × 0308 ÷ 0023 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] NUMBER SIGN (AL) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0023 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NUMBER SIGN (AL) ÷ [0.3]
× 3041 ÷ 2014 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 3041 × 0020 ÷ 2014 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 3041 × 0308 ÷ 2014 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EM DASH (B2) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 2014 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EM DASH (B2) ÷ [0.3]
× 3041 × 0009 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 3041 × 0020 ÷ 0009 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 3041 × 0308 × 0009 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.01] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0009 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <CHARACTER TABULATION> (BA) ÷ [0.3]
× 3041 ÷ 00B4 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 3041 × 0020 ÷ 00B4 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 3041 × 0308 ÷ 00B4 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] ACUTE ACCENT (BB) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 00B4 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ACUTE ACCENT (BB) ÷ [0.3]
× 3041 × 000B ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 3041 × 0020 × 000B ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 3041 × 0308 × 000B ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 3041 × 0308 × 0020 × 000B ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE TABULATION> (BK) ÷ [0.3]
× 3041 ÷ FFFC ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 3041 × 0020 ÷ FFFC ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 3041 × 0308 ÷ FFFC ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ FFFC ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× 3041 × 007D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 3041 × 0020 × 007D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 3041 × 0308 × 007D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 3041 × 0308 × 0020 × 007D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 3041 × 000D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 3041 × 0020 × 000D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 3041 × 0308 × 000D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 3041 × 0308 × 0020 × 000D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
× 3041 × 0021 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 3041 × 0020 × 0021 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 3041 × 0308 × 0021 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 3041 × 0308 × 0020 × 0021 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 3041 × 00A0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [12.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 3041 × 0020 ÷ 00A0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 3041 × 0308 × 00A0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 00A0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] NO-BREAK SPACE (GL) ÷ [0.3]
× 3041 ÷ AC00 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 3041 × 0020 ÷ AC00 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 3041 × 0308 ÷ AC00 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ AC00 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GA (H2) ÷ [0.3]
× 3041 ÷ AC01 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 3041 × 0020 ÷ AC01 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 3041 × 0308 ÷ AC01 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ AC01 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE GAG (H3) ÷ [0.3]
× 3041 ÷ 05D0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 3041 × 0020 ÷ 05D0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 3041 × 0308 ÷ 05D0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 05D0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HEBREW LETTER ALEF (HL) ÷ [0.3]
× 3041 × 002D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 3041 × 0020 ÷ 002D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 3041 × 0308 × 002D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 002D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HYPHEN-MINUS (HY) ÷ [0.3]
× 3041 ÷ 231A ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 3041 × 0020 ÷ 231A ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 3041 × 0308 ÷ 231A ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WATCH (ID) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 231A ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WATCH (ID) ÷ [0.3]
× 3041 × 2024 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 3041 × 0020 ÷ 2024 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 3041 × 0308 × 2024 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 2024 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ONE DOT LEADER (IN) ÷ [0.3]
× 3041 × 002C ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [13.02] COMMA (IS) ÷ [0.3]
× 3041 × 0020 × 002C ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 3041 × 0308 × 002C ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] COMMA (IS) ÷ [0.3]
× 3041 × 0308 × 0020 × 002C ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] COMMA (IS) ÷ [0.3]
× 3041 ÷ 1100 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 3041 × 0020 ÷ 1100 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 3041 × 0308 ÷ 1100 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 1100 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL CHOSEONG KIYEOK (JL) ÷ [0.3]
× 3041 ÷ 11A8 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 3041 × 0020 ÷ 11A8 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 3041 × 0308 ÷ 11A8 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 11A8 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 3041 ÷ 1160 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 3041 × 0020 ÷ 1160 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 3041 × 0308 ÷ 1160 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 1160 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 3041 × 000A ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 3041 × 0020 × 000A ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 3041 × 0308 × 000A ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 3041 × 0308 × 0020 × 000A ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <LINE FEED (LF)> (LF) ÷ [0.3]
× 3041 × 0085 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 3041 × 0020 × 0085 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 3041 × 0308 × 0085 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 3041 × 0308 × 0020 × 0085 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [6.0] <NEXT LINE (NEL)> (NL) ÷ [0.3]
× 3041 × 17D6 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 3041 × 0020 ÷ 17D6 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 3041 × 0308 × 17D6 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 17D6 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] KHMER SIGN CAMNUC PII KUUH (NS) ÷ [0.3]
× 3041 ÷ 0030 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 3041 × 0020 ÷ 0030 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 3041 × 0308 ÷ 0030 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DIGIT ZERO (NU) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0030 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DIGIT ZERO (NU) ÷ [0.3]
× 3041 ÷ 2329 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 3041 × 0020 ÷ 2329 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 3041 × 0308 ÷ 2329 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 2329 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT-POINTING ANGLE BRACKET (OP) ÷ [0.3]
× 3041 ÷ 0025 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 3041 × 0020 ÷ 0025 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 3041 × 0308 ÷ 0025 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] PERCENT SIGN (PO) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0025 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] PERCENT SIGN (PO) ÷ [0.3]
× 3041 ÷ 0024 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 3041 × 0020 ÷ 0024 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 3041 × 0308 ÷ 0024 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] DOLLAR SIGN (PR) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0024 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] DOLLAR SIGN (PR) ÷ [0.3]
× 3041 × 0022 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 3041 × 0020 ÷ 0022 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 3041 × 0308 × 0022 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] QUOTATION MARK (QU) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0022 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] QUOTATION MARK (QU) ÷ [0.3]
× 3041 × 0020 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [0.3]
× 3041 × 0020 × 0020 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 3041 × 0308 × 0020 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 3041 × 0308 × 0020 × 0020 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 3041 × 002F ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 3041 × 0020 × 002F ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 3041 × 0308 × 002F ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] SOLIDUS (SY) ÷ [0.3]
× 3041 × 0308 × 0020 × 002F ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] SOLIDUS (SY) ÷ [0.3]
× 3041 × 2060 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 3041 × 0020 × 2060 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 3041 × 0308 × 2060 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 3041 × 0308 × 0020 × 2060 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 3041 × 200B ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 3041 × 0020 × 200B ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 3041 × 0308 × 200B ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 3041 × 0308 × 0020 × 200B ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [0.3]
× 3041 ÷ 1F1E6 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 3041 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 3041 × 0308 ÷ 1F1E6 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 1F1E6 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
× 3041 ÷ 261D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 3041 × 0020 ÷ 261D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 3041 × 0308 ÷ 261D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 261D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 3041 ÷ 1F3FB ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 3041 × 0020 ÷ 1F3FB ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 3041 × 0308 ÷ 1F3FB ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 1F3FB ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 3041 × 0029 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 3041 × 0020 × 0029 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 3041 × 0308 × 0029 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 3041 × 0308 × 0020 × 0029 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 3041 ÷ 0028 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 3041 × 0020 ÷ 0028 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 3041 × 0308 ÷ 0028 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0028 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] LEFT PARENTHESIS (OP_OP30) ÷ [0.3]
× 3041 × 0001 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 3041 × 0020 ÷ 0001 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 3041 × 0308 × 0001 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0001 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <START OF HEADING> (CM1_CM) ÷ [0.3]
× 3041 × 200D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 3041 × 0020 ÷ 200D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 3041 × 0308 × 200D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 200D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) ÷ [0.3]
× 3041 ÷ 00A7 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 3041 × 0020 ÷ 00A7 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 3041 × 0308 ÷ 00A7 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 00A7 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] SECTION SIGN (AI_AL) ÷ [0.3]
× 3041 ÷ 50005 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 3041 × 0020 ÷ 50005 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 3041 × 0308 ÷ 50005 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 50005 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] <reserved-50005> (XX_AL) ÷ [0.3]
× 3041 ÷ 0E01 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 3041 × 0020 ÷ 0E01 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 3041 × 0308 ÷ 0E01 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [999.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 0E01 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 3041 × 3041 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 3041 × 0020 ÷ 3041 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 3041 × 0308 × 3041 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [21.03] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 3041 × 0308 × 0020 ÷ 3041 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000D × 000A ÷ 0061 × 000A ÷ 0308 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) × [5.01] <LINE FEED (LF)> (LF) ÷ [5.03] LATIN SMALL LETTER A (AL) × [6.0] <LINE FEED (LF)> (LF) ÷ [5.03] COMBINING DIAERESIS (CM1_CM) ÷ [0.3]
× 0061 × 0308 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) ÷ [0.3]
× 0020 ÷ 200D × 0646 ÷	#  × [0.3] SPACE (SP) ÷ [18.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] ARABIC LETTER NOON (AL) ÷ [0.3]
× 0646 × 200D × 0020 ÷	#  × [0.3] ARABIC LETTER NOON (AL) × [9.0] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 000B ÷ 3041 ÷	#  × [0.3] <LINE TABULATION> (BK) ÷ [4.0] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 000D ÷ 3041 ÷	#  × [0.3] <CARRIAGE RETURN (CR)> (CR) ÷ [5.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 0085 ÷ 3041 ÷	#  × [0.3] <NEXT LINE (NEL)> (NL) ÷ [5.04] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 200D × 261D ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 3041 × 2060 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [11.01] WORD JOINER (WJ) ÷ [0.3]
× 2060 × 3041 ÷	#  × [0.3] WORD JOINER (WJ) × [11.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 3041 × 0308 × 00A0 ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [9.0] COMBINING DIAERESIS (CM1_CM) × [12.2] NO-BREAK SPACE (GL) ÷ [0.3]
× 200D × 00A0 ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] NO-BREAK SPACE (GL) ÷ [0.3]
× 200D × 002F ÷	#  × [0.3] ZERO WIDTH JOINER (ZWJ_O_ZWJ_CM) × [8.1] SOLIDUS (SY) ÷ [0.3]
× 2014 × 2014 ÷	#  × [0.3] EM DASH (B2) × [17.0] EM DASH (B2) ÷ [0.3]
× 3041 ÷ FFFC ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [20.01] OBJECT REPLACEMENT CHARACTER (CB) ÷ [0.3]
× FFFC ÷ 3041 ÷	#  × [0.3] OBJECT REPLACEMENT CHARACTER (CB) ÷ [20.02] HIRAGANA LETTER SMALL A (CJ_NS) ÷ [0.3]
× 3041 × 002D ÷	#  × [0.3] HIRAGANA LETTER SMALL A (CJ_NS) × [21.02] HYPHEN-MINUS (HY) ÷ [0.3]
× 0E01 × 2024 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0021 × 2024 ÷	#  × [0.3] EXCLAMATION MARK (EX) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 2024 × 2024 ÷	#  × [0.3] ONE DOT LEADER (IN) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 0030 × 2024 ÷	#  × [0.3] DIGIT ZERO (NU) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 261D × 0025 ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [23.13] PERCENT SIGN (PO) ÷ [0.3]
× 0E01 × 0030 ÷	#  × [0.3] THAI CHARACTER KO KAI (SA_AL) × [23.02] DIGIT ZERO (NU) ÷ [0.3]
× 0024 × 261D ÷	#  × [0.3] DOLLAR SIGN (PR) × [23.12] WHITE UP POINTING INDEX (EB) ÷ [0.3]
× 0024 × 0E01 ÷	#  × [0.3] DOLLAR SIGN (PR) × [24.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 0025 × 0E01 ÷	#  × [0.3] PERCENT SIGN (PO) × [24.02] THAI CHARACTER KO KAI (SA_AL) ÷ [0.3]
× 1100 × 1160 ÷	#  × [0.3] HANGUL CHOSEONG KIYEOK (JL) × [26.01] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 1160 × 1160 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [26.02] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 11A8 × 11A8 ÷	#  × [0.3] HANGUL JONGSEONG KIYEOK (JT) × [26.03] HANGUL JONGSEONG KIYEOK (JT) ÷ [0.3]
× 1160 × 2024 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [22.0] ONE DOT LEADER (IN) ÷ [0.3]
× 1160 × 0025 ÷	#  × [0.3] HANGUL JUNGSEONG FILLER (JV) × [27.02] PERCENT SIGN (PO) ÷ [0.3]
× 0024 × 1160 ÷	#  × [0.3] DOLLAR SIGN (PR) × [27.03] HANGUL JUNGSEONG FILLER (JV) ÷ [0.3]
× 261D × 1F3FB ÷	#  × [0.3] WHITE UP POINTING INDEX (EB) × [30.2] EMOJI MODIFIER FITZPATRICK TYPE-1-2 (EM) ÷ [0.3]
× 0066 × 0069 × 006E × 0061 × 006C ÷	#  × [0.3] LATIN SMALL LETTER F (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER L (AL) ÷ [0.3]
× 0063 × 0061 × 006E × 0027 × 0074 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [19.01] APOSTROPHE (QU) × [19.02] LATIN SMALL LETTER T (AL) ÷ [0.3]
× 0063 × 0061 × 006E × 2019 × 0074 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [19.01] RIGHT SINGLE QUOTATION MARK (QU) × [19.02] LATIN SMALL LETTER T (AL) ÷ [0.3]
× 0027 × 0063 × 0061 × 006E × 0027 × 0020 ÷ 006E × 006F × 0074 ÷	#  × [0.3] APOSTROPHE (QU) × [19.02] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [19.01] APOSTROPHE (QU) × [7.01] SPACE (SP) ÷ [18.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER T (AL) ÷ [0.3]
× 0063 × 0061 × 006E × 0020 ÷ 0027 × 006E × 006F × 0074 × 0027 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [7.01] SPACE (SP) ÷ [18.0] APOSTROPHE (QU) × [19.02] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER T (AL) × [19.01] APOSTROPHE (QU) ÷ [0.3]
× 0062 × 0075 × 0067 × 0028 × 0073 × 0029 × 0020 × 0020 × 0020 × 0020 × 0020 ÷	#  × [0.3] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER U (AL) × [28.0] LATIN SMALL LETTER G (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) × [7.01] SPACE (SP) × [7.01] SPACE (SP) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 0062 × 0075 × 0067 × 0028 × 0073 × 0029 × 00A0 × 0020 × 0020 × 0020 × 0020 × 0020 ÷	#  × [0.3] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER U (AL) × [28.0] LATIN SMALL LETTER G (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [12.1] NO-BREAK SPACE (GL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) × [7.01] SPACE (SP) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [0.3]
× 002E × 002E ÷ 307E ÷ 3059 × 3002 ÷ 0058 × 004D × 004C ÷ 306E × 002E × 002E ÷	#  × [0.3] FULL STOP (IS) × [13.02] FULL STOP (IS) ÷ [999.0] HIRAGANA LETTER MA (ID) ÷ [999.0] HIRAGANA LETTER SU (ID) × [13.02] IDEOGRAPHIC FULL STOP (CL) ÷ [999.0] LATIN CAPITAL LETTER X (AL) × [28.0] LATIN CAPITAL LETTER M (AL) × [28.0] LATIN CAPITAL LETTER L (AL) ÷ [999.0] HIRAGANA LETTER NO (ID) × [13.02] FULL STOP (IS) × [13.02] FULL STOP (IS) ÷ [0.3]
× 0061 × 0062 × 00AD ÷ 0062 × 0079 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER B (AL) × [21.01] SOFT HYPHEN (BA) ÷ [999.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER Y (AL) ÷ [0.3]
× 002D × 0033 ÷	#  × [0.3] HYPHEN-MINUS (HY) × [25.02] DIGIT THREE (NU) ÷ [0.3]
× 0065 × 002E × 0067 × 002E ÷	#  × [0.3] LATIN SMALL LETTER E (AL) × [13.02] FULL STOP (IS) × [29.0] LATIN SMALL LETTER G (AL) × [13.02] FULL STOP (IS) ÷ [0.3]
× 4E00 × 002E ÷ 4E00 × 002E ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-4E00 (ID) × [13.02] FULL STOP (IS) ÷ [999.0] CJK UNIFIED IDEOGRAPH-4E00 (ID) × [13.02] FULL STOP (IS) ÷ [0.3]
× 0061 × 0020 × 0020 ÷ 0062 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) ÷ [18.0] LATIN SMALL LETTER B (AL) ÷ [0.3]
× 0061 × 0020 × 0020 × 200B ÷ 0062 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [7.01] SPACE (SP) × [7.01] SPACE (SP) × [7.02] ZERO WIDTH SPACE (ZW) ÷ [8.0] LATIN SMALL LETTER B (AL) ÷ [0.3]
× 0061 × 0020 ÷ 0308 × 0062 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [7.01] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [28.0] LATIN SMALL LETTER B (AL) ÷ [0.3]
× 0031 × 0308 × 0062 × 0028 × 0061 × 0029 × 002D ÷ 0028 × 0062 × 0029 ÷	#  × [0.3] DIGIT ONE (NU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [23.03] LATIN SMALL LETTER B (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER A (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [21.02] HYPHEN-MINUS (HY) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER B (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0067 × 0069 × 0076 × 0065 × 0020 ÷ 0062 × 006F × 006F × 006B × 0028 × 0073 × 0029 × 002E ÷	#  × [0.3] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER V (AL) × [28.0] LATIN SMALL LETTER E (AL) × [7.01] SPACE (SP) ÷ [18.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER K (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.02] FULL STOP (IS) ÷ [0.3]
× 307E ÷ 0028 × 3059 × 0029 ÷	#  × [0.3] HIRAGANA LETTER MA (ID) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] HIRAGANA LETTER SU (ID) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0066 × 0069 × 006E × 0064 × 0020 × 002E × 0063 × 006F × 006D ÷	#  × [0.3] LATIN SMALL LETTER F (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER D (AL) × [7.01] SPACE (SP) × [13.02] FULL STOP (IS) × [29.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER M (AL) ÷ [0.3]
× 0065 × 0071 × 0075 × 0061 × 006C × 0073 × 0020 × 002E ÷ 0033 × 0035 × 0020 ÷ 0063 × 0065 × 006E × 0074 × 0073 ÷	#  × [0.3] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER Q (AL) × [28.0] LATIN SMALL LETTER U (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER S (AL) × [7.01] SPACE (SP) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT THREE (NU) × [25.03] DIGIT FIVE (NU) × [7.01] SPACE (SP) ÷ [18.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER T (AL) × [28.0] LATIN SMALL LETTER S (AL) ÷ [0.3]
× 0028 × 0073 × 0029 × 0068 × 0065 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [30.02] LATIN SMALL LETTER H (AL) × [28.0] LATIN SMALL LETTER E (AL) ÷ [0.3]
× 007B × 0073 × 007D ÷ 0068 × 0065 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] LATIN SMALL LETTER H (AL) × [28.0] LATIN SMALL LETTER E (AL) ÷ [0.3]
× 02C8 × 0073 × 0049 × 006C × 0259 × 0062 × 0028 × 0259 × 0029 × 006C ÷	#  × [0.3] MODIFIER LETTER VERTICAL LINE (BB) × [21.04] LATIN SMALL LETTER S (AL) × [28.0] LATIN CAPITAL LETTER I (AL) × [28.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER SCHWA (AL) × [28.0] LATIN SMALL LETTER B (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER SCHWA (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [30.02] LATIN SMALL LETTER L (AL) ÷ [0.3]
× 02C8 × 0073 × 0049 × 006C × 0259 × 0062 × 007B × 0259 × 007D ÷ 006C ÷	#  × [0.3] MODIFIER LETTER VERTICAL LINE (BB) × [21.04] LATIN SMALL LETTER S (AL) × [28.0] LATIN CAPITAL LETTER I (AL) × [28.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER SCHWA (AL) × [28.0] LATIN SMALL LETTER B (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER SCHWA (AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] LATIN SMALL LETTER L (AL) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 0028 × 0073 × 0029 × 002E ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.02] FULL STOP (IS) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 0028 × 0073 × 002E × 0029 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] FULL STOP (IS) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 0028 × 0073 × 0029 × 0021 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 0028 × 0073 × 0021 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.01] EXCLAMATION MARK (EX) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 005C ÷ 0028 × 0073 × 005C × 0029 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [24.03] REVERSE SOLIDUS (PR) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [24.03] REVERSE SOLIDUS (PR) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 0028 × 0020 × 0073 × 0020 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] LATIN SMALL LETTER S (AL) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 007B × 0073 × 007D ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 007B × 0073 × 007D × 002E ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT CURLY BRACKET (CL) × [13.02] FULL STOP (IS) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 007B × 0073 × 007D × 0021 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT CURLY BRACKET (CL) × [13.01] EXCLAMATION MARK (EX) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 005C ÷ 007B × 0073 × 005C × 007D ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [24.03] REVERSE SOLIDUS (PR) ÷ [999.0] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [24.03] REVERSE SOLIDUS (PR) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0063 × 006F × 0064 × 0065 × 007B × 0020 × 0073 × 0020 × 007D ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [28.0] LATIN SMALL LETTER E (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [7.01] SPACE (SP) × [14.0] LATIN SMALL LETTER S (AL) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0063 × 006F × 0064 × 0028 × 0065 × 0029 × 2026 ÷ 0028 × 0073 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [22.0] HORIZONTAL ELLIPSIS (IN) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0028 × 0063 × 006F × 0064 × 0028 × 0065 × 0029 × 2026 × 0029 × 0073 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [22.0] HORIZONTAL ELLIPSIS (IN) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [30.02] LATIN SMALL LETTER S (AL) ÷ [0.3]
× 0063 × 006F × 0064 × 007B × 0065 × 007D × 2026 ÷ 007B × 0073 × 007D ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [13.02] RIGHT CURLY BRACKET (CL) × [22.0] HORIZONTAL ELLIPSIS (IN) ÷ [999.0] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 007B × 0063 × 006F × 0064 × 007B × 0065 × 007D × 2026 × 007D ÷ 0073 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER D (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [13.02] RIGHT CURLY BRACKET (CL) × [22.0] HORIZONTAL ELLIPSIS (IN) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] LATIN SMALL LETTER S (AL) ÷ [0.3]
× 0028 × 0063 × 006F × 006E × 002D × 0029 × 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [21.02] HYPHEN-MINUS (HY) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [30.02] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 0028 × 0063 × 006F × 006E × 00AD × 0029 × 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [21.01] SOFT HYPHEN (BA) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [30.02] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 0028 × 0063 × 006F × 006E × 2011 × 0029 × 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [12.1] NON-BREAKING HYPHEN (GL) × [12.0] RIGHT PARENTHESIS (CP_CP30) × [30.02] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 0028 × 0063 × 006F × 006E × 0029 × 002D ÷ 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [21.02] HYPHEN-MINUS (HY) ÷ [999.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 0028 × 0063 × 006F × 006E × 0029 × 00AD ÷ 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [21.01] SOFT HYPHEN (BA) ÷ [999.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 0028 × 0063 × 006F × 006E × 0029 × 2011 × 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [12.1] NON-BREAKING HYPHEN (GL) × [12.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 007B × 0063 × 006F × 006E × 002D × 007D ÷ 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [21.02] HYPHEN-MINUS (HY) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 007B × 0063 × 006F × 006E × 00AD × 007D ÷ 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [21.01] SOFT HYPHEN (BA) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 007B × 0063 × 006F × 006E × 2011 × 007D ÷ 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [12.1] NON-BREAKING HYPHEN (GL) × [12.0] RIGHT CURLY BRACKET (CL) ÷ [999.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 007B × 0063 × 006F × 006E × 007D × 002D ÷ 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [13.02] RIGHT CURLY BRACKET (CL) × [21.02] HYPHEN-MINUS (HY) ÷ [999.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 007B × 0063 × 006F × 006E × 007D × 00AD ÷ 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [13.02] RIGHT CURLY BRACKET (CL) × [21.01] SOFT HYPHEN (BA) ÷ [999.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 007B × 0063 × 006F × 006E × 007D × 2011 × 006C × 0061 × 006E × 0067 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [13.02] RIGHT CURLY BRACKET (CL) × [12.1] NON-BREAKING HYPHEN (GL) × [12.0] LATIN SMALL LETTER L (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER G (AL) ÷ [0.3]
× 0063 × 0072 × 0065 × 0301 × 0028 × 0065 × 0301 × 0029 ÷ 0028 × 0065 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING ACUTE ACCENT (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING ACUTE ACCENT (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0063 × 0072 × 0065 × 0301 × 005B × 0065 × 0072 × 007C ÷ 0065 × 0301 × 0028 × 0065 × 0029 ÷ 0028 × 0073 × 0029 × 005D ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING ACUTE ACCENT (CM1_CM) × [30.01] LEFT SQUARE BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [21.01] VERTICAL LINE (BA) ÷ [999.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING ACUTE ACCENT (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.02] RIGHT SQUARE BRACKET (CP_CP30) ÷ [0.3]
× 0063 × 0072 × 0065 × 0301 × 007B × 0065 × 0072 × 007C ÷ 0065 × 0301 × 0028 × 0065 × 0029 ÷ 0028 × 0073 × 0029 × 007D ÷	#  × [0.3] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING ACUTE ACCENT (CM1_CM) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [21.01] VERTICAL LINE (BA) ÷ [999.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING ACUTE ACCENT (CM1_CM) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER S (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 0028 × 0308 × 0029 ÷ 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 0028 × 00AB × 0308 × 00BB × 0029 ÷ 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LEFT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 0028 × 00AB × 0020 ÷ 0308 × 0020 ÷ 00BB × 0029 ÷ 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] LEFT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 00AB × 0020 × 0028 × 0020 × 0308 × 0020 × 0029 × 0020 ÷ 00BB × 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [19.01] LEFT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [7.01] SPACE (SP) × [15.0] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [7.01] SPACE (SP) ÷ [18.0] RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [15.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 00AB × 202F × 0028 × 0020 × 0308 × 0020 × 0029 × 202F × 00BB × 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [19.01] LEFT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [12.1] NARROW NO-BREAK SPACE (GL) × [12.0] LEFT PARENTHESIS (OP_OP30) × [7.01] SPACE (SP) × [14.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [12.1] NARROW NO-BREAK SPACE (GL) × [12.0] RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [15.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 007B × 0308 × 007D ÷ 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT CURLY BRACKET (CL) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 007B × 00AB × 0308 × 00BB × 007D ÷ 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LEFT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [9.0] COMBINING DIAERESIS (CM1_CM) × [19.01] RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 007B × 00AB × 0020 ÷ 0308 × 0020 ÷ 00BB × 007D ÷ 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] LEFT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [7.01] SPACE (SP) ÷ [18.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) ÷ [18.0] RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 00AB × 0020 × 007B × 0020 × 0308 × 0020 × 007D × 0020 ÷ 00BB × 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [19.01] LEFT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [7.01] SPACE (SP) × [15.0] LEFT CURLY BRACKET (OP_OP30) × [7.01] SPACE (SP) × [14.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) × [7.01] SPACE (SP) ÷ [18.0] RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [15.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0061 × 006D × 0062 × 0069 × 0067 × 0075 × 00AB × 202F × 007B × 0020 × 0308 × 0020 × 007D × 202F × 00BB × 0028 × 0065 × 0308 × 0029 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER M (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER G (AL) × [28.0] LATIN SMALL LETTER U (AL) × [19.01] LEFT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [12.1] NARROW NO-BREAK SPACE (GL) × [12.0] LEFT CURLY BRACKET (OP_OP30) × [7.01] SPACE (SP) × [14.0] COMBINING DIAERESIS (CM1_CM) × [7.01] SPACE (SP) × [13.02] RIGHT CURLY BRACKET (CL) × [12.1] NARROW NO-BREAK SPACE (GL) × [12.0] RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK (QU) × [15.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER E (AL) × [9.0] COMBINING DIAERESIS (CM1_CM) × [13.03] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 0028 × 0063 × 007A × 0065 × 0072 × 0077 × 006F × 006E × 006F × 00AD ÷ 2011 × 0029 × 006E × 0069 × 0065 × 0062 × 0069 × 0065 × 0073 × 006B × 0061 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER Z (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER W (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER O (AL) × [21.01] SOFT HYPHEN (BA) ÷ [999.0] NON-BREAKING HYPHEN (GL) × [12.0] RIGHT PARENTHESIS (CP_CP30) × [30.02] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER S (AL) × [28.0] LATIN SMALL LETTER K (AL) × [28.0] LATIN SMALL LETTER A (AL) ÷ [0.3]
× 0028 × 0063 × 007A × 0065 × 0072 × 0077 × 006F × 006E × 006F × 00AD × 0029 × 2011 × 006E × 0069 × 0065 × 0062 × 0069 × 0065 × 0073 × 006B × 0061 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER Z (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER W (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER O (AL) × [21.01] SOFT HYPHEN (BA) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [12.1] NON-BREAKING HYPHEN (GL) × [12.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER S (AL) × [28.0] LATIN SMALL LETTER K (AL) × [28.0] LATIN SMALL LETTER A (AL) ÷ [0.3]
× 0028 × 0063 × 007A × 0065 × 0072 × 0077 × 006F × 006E × 006F × 0029 × 00AD ÷ 2011 × 006E × 0069 × 0065 × 0062 × 0069 × 0065 × 0073 × 006B × 0061 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER Z (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER W (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER O (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [21.01] SOFT HYPHEN (BA) ÷ [999.0] NON-BREAKING HYPHEN (GL) × [12.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER S (AL) × [28.0] LATIN SMALL LETTER K (AL) × [28.0] LATIN SMALL LETTER A (AL) ÷ [0.3]
× 007B × 0063 × 007A × 0065 × 0072 × 0077 × 006F × 006E × 006F × 00AD ÷ 2011 × 007D ÷ 006E × 0069 × 0065 × 0062 × 0069 × 0065 × 0073 × 006B × 0061 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER Z (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER W (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER O (AL) × [21.01] SOFT HYPHEN (BA) ÷ [999.0] NON-BREAKING HYPHEN (GL) × [12.0] RIGHT CURLY BRACKET (CL) ÷ [999.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER S (AL) × [28.0] LATIN SMALL LETTER K (AL) × [28.0] LATIN SMALL LETTER A (AL) ÷ [0.3]
× 007B × 0063 × 007A × 0065 × 0072 × 0077 × 006F × 006E × 006F × 00AD × 007D × 2011 × 006E × 0069 × 0065 × 0062 × 0069 × 0065 × 0073 × 006B × 0061 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER Z (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER W (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER O (AL) × [21.01] SOFT HYPHEN (BA) × [13.02] RIGHT CURLY BRACKET (CL) × [12.1] NON-BREAKING HYPHEN (GL) × [12.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER S (AL) × [28.0] LATIN SMALL LETTER K (AL) × [28.0] LATIN SMALL LETTER A (AL) ÷ [0.3]
× 007B × 0063 × 007A × 0065 × 0072 × 0077 × 006F × 006E × 006F × 007D × 00AD ÷ 2011 × 006E × 0069 × 0065 × 0062 × 0069 × 0065 × 0073 × 006B × 0061 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER C (AL) × [28.0] LATIN SMALL LETTER Z (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER W (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER O (AL) × [13.02] RIGHT CURLY BRACKET (CL) × [21.01] SOFT HYPHEN (BA) ÷ [999.0] NON-BREAKING HYPHEN (GL) × [12.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER I (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER S (AL) × [28.0] LATIN SMALL LETTER K (AL) × [28.0] LATIN SMALL LETTER A (AL) ÷ [0.3]
× 006F × 0070 × 0065 × 0072 × 0061 × 0074 × 006F × 0072 × 005B × 005D ÷ 0028 × 0030 × 0029 × 003B ÷	#  × [0.3] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER P (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER T (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER R (AL) × [30.01] LEFT SQUARE BRACKET (OP_OP30) × [13.02] RIGHT SQUARE BRACKET (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] DIGIT ZERO (NU) × [25.04] RIGHT PARENTHESIS (CP_CP30) × [13.02] SEMICOLON (IS) ÷ [0.3]
× 006F × 0070 × 0065 × 0072 × 0061 × 0074 × 006F × 0072 × 005B × 005D ÷ 0028 × 0029 ÷ 007B × 007D ÷	#  × [0.3] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER P (AL) × [28.0] LATIN SMALL LETTER E (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER T (AL) × [28.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER R (AL) × [30.01] LEFT SQUARE BRACKET (OP_OP30) × [13.02] RIGHT SQUARE BRACKET (CP_CP30) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] LEFT CURLY BRACKET (OP_OP30) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 672C ÷ 0028 × 3092 × 0029 ÷ 8AAD ÷ 3080 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] HIRAGANA LETTER WO (ID) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] CJK UNIFIED IDEOGRAPH-8AAD (ID) ÷ [999.0] HIRAGANA LETTER MU (ID) ÷ [0.3]
× 672C ÷ 0028 × 300C × 3092 × 300D × 0029 ÷ 8AAD ÷ 3080 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LEFT CORNER BRACKET (OP) × [14.0] HIRAGANA LETTER WO (ID) × [13.02] RIGHT CORNER BRACKET (CL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] CJK UNIFIED IDEOGRAPH-8AAD (ID) ÷ [999.0] HIRAGANA LETTER MU (ID) ÷ [0.3]
× 672C ÷ 300C × 0028 × 3092 × 0029 × 300D ÷ 8AAD ÷ 3080 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [999.0] LEFT CORNER BRACKET (OP) × [14.0] LEFT PARENTHESIS (OP_OP30) × [14.0] HIRAGANA LETTER WO (ID) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.02] RIGHT CORNER BRACKET (CL) ÷ [999.0] CJK UNIFIED IDEOGRAPH-8AAD (ID) ÷ [999.0] HIRAGANA LETTER MU (ID) ÷ [0.3]
× 672C ÷ 007B × 3092 × 007D ÷ 8AAD ÷ 3080 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [999.0] LEFT CURLY BRACKET (OP_OP30) × [14.0] HIRAGANA LETTER WO (ID) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] CJK UNIFIED IDEOGRAPH-8AAD (ID) ÷ [999.0] HIRAGANA LETTER MU (ID) ÷ [0.3]
× 672C ÷ 007B × 300C × 3092 × 300D × 007D ÷ 8AAD ÷ 3080 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [999.0] LEFT CURLY BRACKET (OP_OP30) × [14.0] LEFT CORNER BRACKET (OP) × [14.0] HIRAGANA LETTER WO (ID) × [13.02] RIGHT CORNER BRACKET (CL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] CJK UNIFIED IDEOGRAPH-8AAD (ID) ÷ [999.0] HIRAGANA LETTER MU (ID) ÷ [0.3]
× 672C ÷ 005B × 0028 × 3092 × 0029 × 005D ÷ 8AAD ÷ 3080 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [999.0] LEFT SQUARE BRACKET (OP_OP30) × [14.0] LEFT PARENTHESIS (OP_OP30) × [14.0] HIRAGANA LETTER WO (ID) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.02] RIGHT SQUARE BRACKET (CP_CP30) ÷ [999.0] CJK UNIFIED IDEOGRAPH-8AAD (ID) ÷ [999.0] HIRAGANA LETTER MU (ID) ÷ [0.3]
× 0028 × 30CB × 30E5 × 30FC × 30FB × 0029 ÷ 30E8 × 30FC ÷ 30AF ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] KATAKANA LETTER NI (ID) × [21.03] KATAKANA LETTER SMALL YU (CJ_NS) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) × [21.03] KATAKANA MIDDLE DOT (NS) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] KATAKANA LETTER YO (ID) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) ÷ [999.0] KATAKANA LETTER KU (ID) ÷ [0.3]
× 0028 × 30CB × 30E5 × 30FC × 0029 × 30FB ÷ 30E8 × 30FC ÷ 30AF ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] KATAKANA LETTER NI (ID) × [21.03] KATAKANA LETTER SMALL YU (CJ_NS) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [16.0] KATAKANA MIDDLE DOT (NS) ÷ [999.0] KATAKANA LETTER YO (ID) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) ÷ [999.0] KATAKANA LETTER KU (ID) ÷ [0.3]
× 007B × 30CB × 30E5 × 30FC × 30FB × 007D ÷ 30E8 × 30FC ÷ 30AF ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] KATAKANA LETTER NI (ID) × [21.03] KATAKANA LETTER SMALL YU (CJ_NS) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) × [21.03] KATAKANA MIDDLE DOT (NS) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] KATAKANA LETTER YO (ID) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) ÷ [999.0] KATAKANA LETTER KU (ID) ÷ [0.3]
× 007B × 30CB × 30E5 × 30FC × 007D × 30FB ÷ 30E8 × 30FC ÷ 30AF ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] KATAKANA LETTER NI (ID) × [21.03] KATAKANA LETTER SMALL YU (CJ_NS) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) × [13.02] RIGHT CURLY BRACKET (CL) × [16.0] KATAKANA MIDDLE DOT (NS) ÷ [999.0] KATAKANA LETTER YO (ID) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) ÷ [999.0] KATAKANA LETTER KU (ID) ÷ [0.3]
× 0028 × 1850 × 1846 × 1851 × 1846 ÷ 1806 × 0029 × 182A × 1822 × 1834 × 1822 × 182D × 180C ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] MONGOLIAN LETTER TODO TA (AL) × [28.0] MONGOLIAN LETTER TODO O (AL) × [28.0] MONGOLIAN LETTER TODO DA (AL) × [28.0] MONGOLIAN LETTER TODO O (AL) ÷ [999.0] MONGOLIAN TODO SOFT HYPHEN (BB) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [30.02] MONGOLIAN LETTER BA (AL) × [28.0] MONGOLIAN LETTER I (AL) × [28.0] MONGOLIAN LETTER CHA (AL) × [28.0] MONGOLIAN LETTER I (AL) × [28.0] MONGOLIAN LETTER GA (AL) × [9.0] MONGOLIAN FREE VARIATION SELECTOR TWO (CM1_CM) ÷ [0.3]
× 0028 × 1850 × 1846 × 1851 × 1846 × 0029 ÷ 1806 × 182A × 1822 × 1834 × 1822 × 182D × 180C ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] MONGOLIAN LETTER TODO TA (AL) × [28.0] MONGOLIAN LETTER TODO O (AL) × [28.0] MONGOLIAN LETTER TODO DA (AL) × [28.0] MONGOLIAN LETTER TODO O (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) ÷ [999.0] MONGOLIAN TODO SOFT HYPHEN (BB) × [21.04] MONGOLIAN LETTER BA (AL) × [28.0] MONGOLIAN LETTER I (AL) × [28.0] MONGOLIAN LETTER CHA (AL) × [28.0] MONGOLIAN LETTER I (AL) × [28.0] MONGOLIAN LETTER GA (AL) × [9.0] MONGOLIAN FREE VARIATION SELECTOR TWO (CM1_CM) ÷ [0.3]
× 007B × 1850 × 1846 × 1851 × 1846 ÷ 1806 × 007D ÷ 182A × 1822 × 1834 × 1822 × 182D × 180C ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] MONGOLIAN LETTER TODO TA (AL) × [28.0] MONGOLIAN LETTER TODO O (AL) × [28.0] MONGOLIAN LETTER TODO DA (AL) × [28.0] MONGOLIAN LETTER TODO O (AL) ÷ [999.0] MONGOLIAN TODO SOFT HYPHEN (BB) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] MONGOLIAN LETTER BA (AL) × [28.0] MONGOLIAN LETTER I (AL) × [28.0] MONGOLIAN LETTER CHA (AL) × [28.0] MONGOLIAN LETTER I (AL) × [28.0] MONGOLIAN LETTER GA (AL) × [9.0] MONGOLIAN FREE VARIATION SELECTOR TWO (CM1_CM) ÷ [0.3]
× 007B × 1850 × 1846 × 1851 × 1846 × 007D ÷ 1806 × 182A × 1822 × 1834 × 1822 × 182D × 180C ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] MONGOLIAN LETTER TODO TA (AL) × [28.0] MONGOLIAN LETTER TODO O (AL) × [28.0] MONGOLIAN LETTER TODO DA (AL) × [28.0] MONGOLIAN LETTER TODO O (AL) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] MONGOLIAN TODO SOFT HYPHEN (BB) × [21.04] MONGOLIAN LETTER BA (AL) × [28.0] MONGOLIAN LETTER I (AL) × [28.0] MONGOLIAN LETTER CHA (AL) × [28.0] MONGOLIAN LETTER I (AL) × [28.0] MONGOLIAN LETTER GA (AL) × [9.0] MONGOLIAN FREE VARIATION SELECTOR TWO (CM1_CM) ÷ [0.3]
× 0028 × 0068 × 0074 × 0074 × 0070 × 003A × 002F × 002F × 0029 × 0078 × 006E × 002D × 002D ÷ 0061 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER H (AL) × [28.0] LATIN SMALL LETTER T (AL) × [28.0] LATIN SMALL LETTER T (AL) × [28.0] LATIN SMALL LETTER P (AL) × [13.02] COLON (IS) × [13.02] SOLIDUS (SY) × [13.02] SOLIDUS (SY) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [30.02] LATIN SMALL LETTER X (AL) × [28.0] LATIN SMALL LETTER N (AL) × [21.02] HYPHEN-MINUS (HY) × [21.02] HYPHEN-MINUS (HY) ÷ [999.0] LATIN SMALL LETTER A (AL) ÷ [0.3]
× 007B × 0068 × 0074 × 0074 × 0070 × 003A × 002F × 002F × 007D ÷ 0078 × 006E × 002D × 002D ÷ 0061 ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] LATIN SMALL LETTER H (AL) × [28.0] LATIN SMALL LETTER T (AL) × [28.0] LATIN SMALL LETTER T (AL) × [28.0] LATIN SMALL LETTER P (AL) × [13.02] COLON (IS) × [13.02] SOLIDUS (SY) × [13.02] SOLIDUS (SY) × [13.02] RIGHT CURLY BRACKET (CL) ÷ [999.0] LATIN SMALL LETTER X (AL) × [28.0] LATIN SMALL LETTER N (AL) × [21.02] HYPHEN-MINUS (HY) × [21.02] HYPHEN-MINUS (HY) ÷ [999.0] LATIN SMALL LETTER A (AL) ÷ [0.3]
× 0028 × 0030 × 002C × 0031 × 0029 × 002B × 0028 × 0032 × 002C × 0033 × 0029 × 2295 × 0028 × 2212 × 0034 × 002C × 0035 × 0029 × 2296 × 0028 × 0036 × 002C × 0037 × 0029 ÷	#  × [0.3] LEFT PARENTHESIS (OP_OP30) × [14.0] DIGIT ZERO (NU) × [25.03] COMMA (IS) × [25.04] DIGIT ONE (NU) × [25.04] RIGHT PARENTHESIS (CP_CP30) × [25.05] PLUS SIGN (PR) × [25.01] LEFT PARENTHESIS (OP_OP30) × [14.0] DIGIT TWO (NU) × [25.03] COMMA (IS) × [25.04] DIGIT THREE (NU) × [25.04] RIGHT PARENTHESIS (CP_CP30) × [30.02] CIRCLED PLUS (AI_AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] MINUS SIGN (PR) × [25.01] DIGIT FOUR (NU) × [25.03] COMMA (IS) × [25.04] DIGIT FIVE (NU) × [25.04] RIGHT PARENTHESIS (CP_CP30) × [30.02] CIRCLED MINUS (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [14.0] DIGIT SIX (NU) × [25.03] COMMA (IS) × [25.04] DIGIT SEVEN (NU) × [25.04] RIGHT PARENTHESIS (CP_CP30) ÷ [0.3]
× 007B × 0030 × 002C × 0031 × 007D × 002B × 007B × 0032 × 002C × 0033 × 007D ÷ 2295 × 007B × 2212 × 0034 × 002C × 0035 × 007D ÷ 2296 × 007B × 0036 × 002C × 0037 × 007D ÷	#  × [0.3] LEFT CURLY BRACKET (OP_OP30) × [14.0] DIGIT ZERO (NU) × [25.03] COMMA (IS) × [25.04] DIGIT ONE (NU) × [25.04] RIGHT CURLY BRACKET (CL) × [25.05] PLUS SIGN (PR) × [25.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] DIGIT TWO (NU) × [25.03] COMMA (IS) × [25.04] DIGIT THREE (NU) × [25.04] RIGHT CURLY BRACKET (CL) ÷ [999.0] CIRCLED PLUS (AI_AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] MINUS SIGN (PR) × [25.01] DIGIT FOUR (NU) × [25.03] COMMA (IS) × [25.04] DIGIT FIVE (NU) × [25.04] RIGHT CURLY BRACKET (CL) ÷ [999.0] CIRCLED MINUS (AL) × [30.01] LEFT CURLY BRACKET (OP_OP30) × [14.0] DIGIT SIX (NU) × [25.03] COMMA (IS) × [25.04] DIGIT SEVEN (NU) × [25.04] RIGHT CURLY BRACKET (CL) ÷ [0.3]
× 0061 × 0062 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER B (AL) ÷ [0.3]
× 0061 × 0062 × 0020 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER B (AL) × [7.01] SPACE (SP) ÷ [0.3]
× 0061 × 0062 × 0020 ÷ 0063 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER B (AL) × [7.01] SPACE (SP) ÷ [18.0] LATIN SMALL LETTER C (AL) ÷ [0.3]
× 0061 ÷ 307E ÷	#  × [0.3] LATIN SMALL LETTER A (AL) ÷ [999.0] HIRAGANA LETTER MA (ID) ÷ [0.3]
× 0939 × 093F × 0928 × 094D × 0926 × 0940 × 0020 ÷	#  × [0.3] DEVANAGARI LETTER HA (AL) × [9.0] DEVANAGARI VOWEL SIGN I (CM1_CM) × [28.0] DEVANAGARI LETTER NA (AL) × [9.0] DEVANAGARI SIGN VIRAMA (CM1_CM) × [28.0] DEVANAGARI LETTER DA (AL) × [9.0] DEVANAGARI VOWEL SIGN II (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 092F × 0938 × 0917 × 0941 × 091A × 093F × 0924 × 0940 × 092F × 0938 × 093E × 0020 ÷	#  × [0.3] DEVANAGARI LETTER YA (AL) × [28.0] DEVANAGARI LETTER SA (AL) × [28.0] DEVANAGARI LETTER GA (AL) × [9.0] DEVANAGARI VOWEL SIGN U (CM1_CM) × [28.0] DEVANAGARI LETTER CA (AL) × [9.0] DEVANAGARI VOWEL SIGN I (CM1_CM) × [28.0] DEVANAGARI LETTER TA (AL) × [9.0] DEVANAGARI VOWEL SIGN II (CM1_CM) × [28.0] DEVANAGARI LETTER YA (AL) × [28.0] DEVANAGARI LETTER SA (AL) × [9.0] DEVANAGARI VOWEL SIGN AA (CM1_CM) × [7.01] SPACE (SP) ÷ [0.3]
× 5370 ÷ 672C ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-5370 (ID) ÷ [999.0] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [0.3]
× 8AAD ÷ 3080 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-8AAD (ID) ÷ [999.0] HIRAGANA LETTER MU (ID) ÷ [0.3]
× 5165 ÷ 529B ÷ 3057 ÷ 30A8 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-5165 (ID) ÷ [999.0] CJK UNIFIED IDEOGRAPH-529B (ID) ÷ [999.0] HIRAGANA LETTER SI (ID) ÷ [999.0] KATAKANA LETTER E (ID) ÷ [0.3]
× 4F4D × 3002 ÷ 8A18 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-4F4D (ID) × [13.02] IDEOGRAPHIC FULL STOP (CL) ÷ [999.0] CJK UNIFIED IDEOGRAPH-8A18 (ID) ÷ [0.3]
× 672C × 3002 ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-672C (ID) × [13.02] IDEOGRAPHIC FULL STOP (CL) ÷ [0.3]
× 967A × 300D ÷ 306E ÷	#  × [0.3] CJK UNIFIED IDEOGRAPH-967A (ID) × [13.02] RIGHT CORNER BRACKET (CL) ÷ [999.0] HIRAGANA LETTER NO (ID) ÷ [0.3]
× 3057 × 3087 ÷ 3046 ÷	#  × [0.3] HIRAGANA LETTER SI (ID) × [21.03] HIRAGANA LETTER SMALL YO (CJ_NS) ÷ [999.0] HIRAGANA LETTER U (ID) ÷ [0.3]
× 307E ÷ 0061 ÷ 672C ÷	#  × [0.3] HIRAGANA LETTER MA (ID) ÷ [999.0] LATIN SMALL LETTER A (AL) ÷ [999.0] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [0.3]
× C5C6 ÷ C5B4 ÷ C694 × 0020 ÷ 006F × 0072 × 0020 ÷ BABB ÷	#  × [0.3] HANGUL SYLLABLE EOBS (H3) ÷ [999.0] HANGUL SYLLABLE EO (H2) ÷ [999.0] HANGUL SYLLABLE YO (H2) × [7.01] SPACE (SP) ÷ [18.0] LATIN SMALL LETTER O (AL) × [28.0] LATIN SMALL LETTER R (AL) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE MOS (H3) ÷ [0.3]
× 307E ÷ 0061 × 0062 × 0020 ÷	#  × [0.3] HIRAGANA LETTER MA (ID) ÷ [999.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER B (AL) × [7.01] SPACE (SP) ÷ [0.3]
× 3067 ÷ 4F7F ÷	#  × [0.3] HIRAGANA LETTER DE (ID) ÷ [999.0] CJK UNIFIED IDEOGRAPH-4F7F (ID) ÷ [0.3]
× 3059 ÷ 308B ÷	#  × [0.3] HIRAGANA LETTER SU (ID) ÷ [999.0] HIRAGANA LETTER RU (ID) ÷ [0.3]
× 306E ÷ 30D1 ÷ 30F3 ÷	#  × [0.3] HIRAGANA LETTER NO (ID) ÷ [999.0] KATAKANA LETTER PA (ID) ÷ [999.0] KATAKANA LETTER N (ID) ÷ [0.3]
× 3046 × 3000 ÷ 3048 × 3000 ÷ 304A × 300D ÷	#  × [0.3] HIRAGANA LETTER U (ID) × [21.01] IDEOGRAPHIC SPACE (BA) ÷ [999.0] HIRAGANA LETTER E (ID) × [21.01] IDEOGRAPHIC SPACE (BA) ÷ [999.0] HIRAGANA LETTER O (ID) × [13.02] RIGHT CORNER BRACKET (CL) ÷ [0.3]
× 308B × 0020 ÷ C740 ÷ C601 × 0020 ÷ 306B ÷	#  × [0.3] HIRAGANA LETTER RU (ID) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE EUN (H3) ÷ [999.0] HANGUL SYLLABLE YEONG (H3) × [7.01] SPACE (SP) ÷ [18.0] HIRAGANA LETTER NI (ID) ÷ [0.3]
× 3057 × 3087 ÷ 3046 × 3002 ÷	#  × [0.3] HIRAGANA LETTER SI (ID) × [21.03] HIRAGANA LETTER SMALL YO (CJ_NS) ÷ [999.0] HIRAGANA LETTER U (ID) × [13.02] IDEOGRAPHIC FULL STOP (CL) ÷ [0.3]
× 30E0 ÷ 306E ÷ 4E00 ÷	#  × [0.3] KATAKANA LETTER MU (ID) ÷ [999.0] HIRAGANA LETTER NO (ID) ÷ [999.0] CJK UNIFIED IDEOGRAPH-4E00 (ID) ÷ [0.3]
× 30D5 ÷ 30EA ÷	#  × [0.3] KATAKANA LETTER HU (ID) ÷ [999.0] KATAKANA LETTER RI (ID) ÷ [0.3]
× 30D5 ÷ 30EA × 30FC ÷ 767E ÷	#  × [0.3] KATAKANA LETTER HU (ID) ÷ [999.0] KATAKANA LETTER RI (ID) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) ÷ [999.0] CJK UNIFIED IDEOGRAPH-767E (ID) ÷ [0.3]
× 30D4 × 30E5 × 30FC ÷ 30BF ÷ 3067 ÷ 4F7F ÷ 7528 ÷ 3059 ÷ 308B ÷	#  × [0.3] KATAKANA LETTER PI (ID) × [21.03] KATAKANA LETTER SMALL YU (CJ_NS) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) ÷ [999.0] KATAKANA LETTER TA (ID) ÷ [999.0] HIRAGANA LETTER DE (ID) ÷ [999.0] CJK UNIFIED IDEOGRAPH-4F7F (ID) ÷ [999.0] CJK UNIFIED IDEOGRAPH-7528 (ID) ÷ [999.0] HIRAGANA LETTER SU (ID) ÷ [999.0] HIRAGANA LETTER RU (ID) ÷ [0.3]
× 30BF × 30FC ÷ 30AD × 30FC ÷ 3092 ÷ 62BC ÷	#  × [0.3] KATAKANA LETTER TA (ID) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) ÷ [999.0] KATAKANA LETTER KI (ID) × [21.03] KATAKANA-HIRAGANA PROLONGED SOUND MARK (CJ_NS) ÷ [999.0] HIRAGANA LETTER WO (ID) ÷ [999.0] CJK UNIFIED IDEOGRAPH-62BC (ID) ÷ [0.3]
× 30B7 × 30E7 ÷ 30F3 ÷	#  × [0.3] KATAKANA LETTER SI (ID) × [21.03] KATAKANA LETTER SMALL YO (CJ_NS) ÷ [999.0] KATAKANA LETTER N (ID) ÷ [0.3]
× 0061 × 002E ÷ 0032 × 0020 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT TWO (NU) × [7.01] SPACE (SP) ÷ [0.3]
× 0061 × 002E ÷ 0032 × 0020 ÷ 0915 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT TWO (NU) × [7.01] SPACE (SP) ÷ [18.0] DEVANAGARI LETTER KA (AL) ÷ [0.3]
× 0061 × 002E ÷ 0032 × 0020 ÷ 672C ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT TWO (NU) × [7.01] SPACE (SP) ÷ [18.0] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [0.3]
× 0061 × 002E ÷ 0032 × 3000 ÷ 672C ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT TWO (NU) × [21.01] IDEOGRAPHIC SPACE (BA) ÷ [999.0] CJK UNIFIED IDEOGRAPH-672C (ID) ÷ [0.3]
× 0061 × 002E ÷ 0032 × 3000 ÷ 307E ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT TWO (NU) × [21.01] IDEOGRAPHIC SPACE (BA) ÷ [999.0] HIRAGANA LETTER MA (ID) ÷ [0.3]
× 0061 × 002E ÷ 0032 × 3000 ÷ 0033 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT TWO (NU) × [21.01] IDEOGRAPHIC SPACE (BA) ÷ [999.0] DIGIT THREE (NU) ÷ [0.3]
× 0061 × 0062 × 002E × 0020 ÷ 0032 ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER B (AL) × [13.02] FULL STOP (IS) × [7.01] SPACE (SP) ÷ [18.0] DIGIT TWO (NU) ÷ [0.3]
× 0041 × 002E ÷ 0031 × 0020 ÷ BABB ÷	#  × [0.3] LATIN CAPITAL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT ONE (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE MOS (H3) ÷ [0.3]
× BD24 ÷ C5B4 × 002E × 0020 ÷ 0041 × 002E ÷ 0032 × 0020 ÷ BCFC ÷	#  × [0.3] HANGUL SYLLABLE BWASS (H3) ÷ [999.0] HANGUL SYLLABLE EO (H2) × [13.02] FULL STOP (IS) × [7.01] SPACE (SP) ÷ [18.0] LATIN CAPITAL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT TWO (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE BOL (H3) ÷ [0.3]
× BD10 ÷ C694 × 002E × 0020 ÷ 0041 × 002E ÷ 0033 × 0020 ÷ BABB ÷	#  × [0.3] HANGUL SYLLABLE BWA (H2) ÷ [999.0] HANGUL SYLLABLE YO (H2) × [13.02] FULL STOP (IS) × [7.01] SPACE (SP) ÷ [18.0] LATIN CAPITAL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT THREE (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE MOS (H3) ÷ [0.3]
× C694 × 002E × 0020 ÷ 0041 × 002E ÷ 0034 × 0020 ÷ BABB ÷	#  × [0.3] HANGUL SYLLABLE YO (H2) × [13.02] FULL STOP (IS) × [7.01] SPACE (SP) ÷ [18.0] LATIN CAPITAL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT FOUR (NU) × [7.01] SPACE (SP) ÷ [18.0] HANGUL SYLLABLE MOS (H3) ÷ [0.3]
× 0061 × 002E ÷ 0032 × 3000 ÷ 300C ÷	#  × [0.3] LATIN SMALL LETTER A (AL) × [13.02] FULL STOP (IS) ÷ [999.0] DIGIT TWO (NU) × [21.01] IDEOGRAPHIC SPACE (BA) ÷ [999.0] LEFT CORNER BRACKET (OP) ÷ [0.3]
× 306B ÷ 300C × 30D0 ÷ 0028 × 0062 × 0061 × 0029 × 300D ÷ 3084 ÷ 300C × 30B9 ÷	#  × [0.3] HIRAGANA LETTER NI (ID) ÷ [999.0] LEFT CORNER BRACKET (OP) × [14.0] KATAKANA LETTER BA (ID) ÷ [999.0] LEFT PARENTHESIS (OP_OP30) × [14.0] LATIN SMALL LETTER B (AL) × [28.0] LATIN SMALL LETTER A (AL) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.02] RIGHT CORNER BRACKET (CL) ÷ [999.0] HIRAGANA LETTER YA (ID) ÷ [999.0] LEFT CORNER BRACKET (OP) × [14.0] KATAKANA LETTER SU (ID) ÷ [0.3]
× 308B ÷ 300C × 0055 × 004B ÷ 30DD ÷ 30F3 ÷ 30C9 × 300D × FF09 × 3001 ÷ 30A8 ÷	#  × [0.3] HIRAGANA LETTER RU (ID) ÷ [999.0] LEFT CORNER BRACKET (OP) × [14.0] LATIN CAPITAL LETTER U (AL) × [28.0] LATIN CAPITAL LETTER K (AL) ÷ [999.0] KATAKANA LETTER PO (ID) ÷ [999.0] KATAKANA LETTER N (ID) ÷ [999.0] KATAKANA LETTER DO (ID) × [13.02] RIGHT CORNER BRACKET (CL) × [13.02] FULLWIDTH RIGHT PARENTHESIS (CL) × [13.02] IDEOGRAPHIC COMMA (CL) ÷ [999.0] KATAKANA LETTER E (ID) ÷ [0.3]
× 306F × 3001 ÷ 300C × 003D × 0072 × 0061 × 006E × 0064 × 0028 × 0029 × 300D ÷ 3068 ÷	#  × [0.3] HIRAGANA LETTER HA (ID) × [13.02] IDEOGRAPHIC COMMA (CL) ÷ [999.0] LEFT CORNER BRACKET (OP) × [14.0] EQUALS SIGN (AL) × [28.0] LATIN SMALL LETTER R (AL) × [28.0] LATIN SMALL LETTER A (AL) × [28.0] LATIN SMALL LETTER N (AL) × [28.0] LATIN SMALL LETTER D (AL) × [30.01] LEFT PARENTHESIS (OP_OP30) × [13.02] RIGHT PARENTHESIS (CP_CP30) × [13.02] RIGHT CORNER BRACKET (CL) ÷ [999.0] HIRAGANA LETTER TO (ID) ÷ [0.3]
× 3067 × 3001 ÷ 300C × 0021 × 300D ÷ 3068 ÷	#  × [0.3] HIRAGANA LETTER DE (ID) × [13.02] IDEOGRAPHIC COMMA (CL) ÷ [999.0] LEFT CORNER BRACKET (OP) × [13.01] EXCLAMATION MARK (EX) × [13.02] RIGHT CO