// Copyright (c) 2024, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// ignore_for_file: camel_case_types, non_constant_identifier_names, unused_element, unused_field, void_checks, annotate_overrides, no_leading_underscores_for_local_identifiers, library_private_types_in_public_api

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;
import 'package:objective_c/objective_c.dart' as objc;

final class _NSZone extends ffi.Opaque {}

final class AudioStreamBasicDescription extends ffi.Struct {
  @ffi.Double()
  external double mSampleRate;

  @ffi.UnsignedInt()
  external int mFormatID;

  @ffi.UnsignedInt()
  external int mFormatFlags;

  @ffi.UnsignedInt()
  external int mBytesPerPacket;

  @ffi.UnsignedInt()
  external int mFramesPerPacket;

  @ffi.UnsignedInt()
  external int mBytesPerFrame;

  @ffi.UnsignedInt()
  external int mChannelsPerFrame;

  @ffi.UnsignedInt()
  external int mBitsPerChannel;

  @ffi.UnsignedInt()
  external int mReserved;
}

enum AudioChannelBitmap {
  kAudioChannelBit_Left(1),
  kAudioChannelBit_Right(2),
  kAudioChannelBit_Center(4),
  kAudioChannelBit_LFEScreen(8),
  kAudioChannelBit_LeftSurround(16),
  kAudioChannelBit_RightSurround(32),
  kAudioChannelBit_LeftCenter(64),
  kAudioChannelBit_RightCenter(128),
  kAudioChannelBit_CenterSurround(256),
  kAudioChannelBit_LeftSurroundDirect(512),
  kAudioChannelBit_RightSurroundDirect(1024),
  kAudioChannelBit_TopCenterSurround(2048),
  kAudioChannelBit_VerticalHeightLeft(4096),
  kAudioChannelBit_VerticalHeightCenter(8192),
  kAudioChannelBit_VerticalHeightRight(16384),
  kAudioChannelBit_TopBackLeft(32768),
  kAudioChannelBit_TopBackCenter(65536),
  kAudioChannelBit_TopBackRight(131072),
  kAudioChannelBit_LeftTopMiddle(2097152),
  kAudioChannelBit_RightTopMiddle(8388608),
  kAudioChannelBit_LeftTopRear(16777216),
  kAudioChannelBit_CenterTopRear(33554432),
  kAudioChannelBit_RightTopRear(67108864);

  static const kAudioChannelBit_LeftTopFront =
      kAudioChannelBit_VerticalHeightLeft;
  static const kAudioChannelBit_CenterTopFront =
      kAudioChannelBit_VerticalHeightCenter;
  static const kAudioChannelBit_RightTopFront =
      kAudioChannelBit_VerticalHeightRight;
  static const kAudioChannelBit_CenterTopMiddle =
      kAudioChannelBit_TopCenterSurround;

  final int value;
  const AudioChannelBitmap(this.value);

  static AudioChannelBitmap fromValue(int value) => switch (value) {
        1 => kAudioChannelBit_Left,
        2 => kAudioChannelBit_Right,
        4 => kAudioChannelBit_Center,
        8 => kAudioChannelBit_LFEScreen,
        16 => kAudioChannelBit_LeftSurround,
        32 => kAudioChannelBit_RightSurround,
        64 => kAudioChannelBit_LeftCenter,
        128 => kAudioChannelBit_RightCenter,
        256 => kAudioChannelBit_CenterSurround,
        512 => kAudioChannelBit_LeftSurroundDirect,
        1024 => kAudioChannelBit_RightSurroundDirect,
        2048 => kAudioChannelBit_TopCenterSurround,
        4096 => kAudioChannelBit_VerticalHeightLeft,
        8192 => kAudioChannelBit_VerticalHeightCenter,
        16384 => kAudioChannelBit_VerticalHeightRight,
        32768 => kAudioChannelBit_TopBackLeft,
        65536 => kAudioChannelBit_TopBackCenter,
        131072 => kAudioChannelBit_TopBackRight,
        2097152 => kAudioChannelBit_LeftTopMiddle,
        8388608 => kAudioChannelBit_RightTopMiddle,
        16777216 => kAudioChannelBit_LeftTopRear,
        33554432 => kAudioChannelBit_CenterTopRear,
        67108864 => kAudioChannelBit_RightTopRear,
        _ =>
          throw ArgumentError("Unknown value for AudioChannelBitmap: $value"),
      };

  @override
  String toString() {
    if (this == kAudioChannelBit_TopCenterSurround)
      return "AudioChannelBitmap.kAudioChannelBit_TopCenterSurround, AudioChannelBitmap.kAudioChannelBit_CenterTopMiddle";
    if (this == kAudioChannelBit_VerticalHeightLeft)
      return "AudioChannelBitmap.kAudioChannelBit_VerticalHeightLeft, AudioChannelBitmap.kAudioChannelBit_LeftTopFront";
    if (this == kAudioChannelBit_VerticalHeightCenter)
      return "AudioChannelBitmap.kAudioChannelBit_VerticalHeightCenter, AudioChannelBitmap.kAudioChannelBit_CenterTopFront";
    if (this == kAudioChannelBit_VerticalHeightRight)
      return "AudioChannelBitmap.kAudioChannelBit_VerticalHeightRight, AudioChannelBitmap.kAudioChannelBit_RightTopFront";
    return super.toString();
  }
}

enum AudioChannelFlags {
  kAudioChannelFlags_AllOff(0),
  kAudioChannelFlags_RectangularCoordinates(1),
  kAudioChannelFlags_SphericalCoordinates(2),
  kAudioChannelFlags_Meters(4);

  final int value;
  const AudioChannelFlags(this.value);

  static AudioChannelFlags fromValue(int value) => switch (value) {
        0 => kAudioChannelFlags_AllOff,
        1 => kAudioChannelFlags_RectangularCoordinates,
        2 => kAudioChannelFlags_SphericalCoordinates,
        4 => kAudioChannelFlags_Meters,
        _ => throw ArgumentError("Unknown value for AudioChannelFlags: $value"),
      };
}

final class AudioChannelDescription extends ffi.Struct {
  @ffi.UnsignedInt()
  external int mChannelLabel;

  @ffi.UnsignedInt()
  external int mChannelFlagsAsInt;

  AudioChannelFlags get mChannelFlags =>
      AudioChannelFlags.fromValue(mChannelFlagsAsInt);

  @ffi.Array.multi([3])
  external ffi.Array<ffi.Float> mCoordinates;
}

final class AudioChannelLayout extends ffi.Struct {
  @ffi.UnsignedInt()
  external int mChannelLayoutTag;

  @ffi.UnsignedInt()
  external int mChannelBitmapAsInt;

  AudioChannelBitmap get mChannelBitmap =>
      AudioChannelBitmap.fromValue(mChannelBitmapAsInt);

  @ffi.UnsignedInt()
  external int mNumberChannelDescriptions;

  @ffi.Array.multi([1])
  external ffi.Array<AudioChannelDescription> mChannelDescriptions;
}

final class opaqueCMFormatDescription extends ffi.Opaque {}

enum AVAudioCommonFormat {
  AVAudioOtherFormat(0),
  AVAudioPCMFormatFloat32(1),
  AVAudioPCMFormatFloat64(2),
  AVAudioPCMFormatInt16(3),
  AVAudioPCMFormatInt32(4);

  final int value;
  const AVAudioCommonFormat(this.value);

  static AVAudioCommonFormat fromValue(int value) => switch (value) {
        0 => AVAudioOtherFormat,
        1 => AVAudioPCMFormatFloat32,
        2 => AVAudioPCMFormatFloat64,
        3 => AVAudioPCMFormatInt16,
        4 => AVAudioPCMFormatInt32,
        _ =>
          throw ArgumentError("Unknown value for AVAudioCommonFormat: $value"),
      };
}

/// WARNING: AVAudioFormat is a stub. To generate bindings for this class, include
/// AVAudioFormat in your config's objc-interfaces list.
///
/// AVAudioFormat
class AVAudioFormat extends objc.NSObject {
  AVAudioFormat._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [AVAudioFormat] that points to the same underlying object as [other].
  AVAudioFormat.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [AVAudioFormat] that wraps the given raw object pointer.
  AVAudioFormat.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);
}

late final _class_AVAudioPlayer = objc.getClass("AVAudioPlayer");
late final _sel_isKindOfClass_ = objc.registerName("isKindOfClass:");
final _objc_msgSend_69e0x1 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
typedef instancetype = ffi.Pointer<objc.ObjCObject>;
typedef Dartinstancetype = objc.ObjCObjectBase;
late final _sel_initWithContentsOfURL_error_ =
    objc.registerName("initWithContentsOfURL:error:");
final _objc_msgSend_1705co6 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_initWithData_error_ = objc.registerName("initWithData:error:");
late final _sel_initWithContentsOfURL_fileTypeHint_error_ =
    objc.registerName("initWithContentsOfURL:fileTypeHint:error:");
final _objc_msgSend_bo6ep4 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<ffi.Pointer<objc.ObjCObject>>)>();
late final _sel_initWithData_fileTypeHint_error_ =
    objc.registerName("initWithData:fileTypeHint:error:");
late final _sel_prepareToPlay = objc.registerName("prepareToPlay");
final _objc_msgSend_91o635 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        bool Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_play = objc.registerName("play");
late final _sel_playAtTime_ = objc.registerName("playAtTime:");
final _objc_msgSend_18chyc = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Bool Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Double)>>()
    .asFunction<
        bool Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, double)>();
late final _sel_pause = objc.registerName("pause");
final _objc_msgSend_1pl9qdv = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        void Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_stop = objc.registerName("stop");
late final _sel_isPlaying = objc.registerName("isPlaying");
late final _sel_numberOfChannels = objc.registerName("numberOfChannels");
final _objc_msgSend_xw2lbc = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.UnsignedLong Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_duration = objc.registerName("duration");
final _objc_msgSend_1ukqyt8 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_1ukqyt8Fpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Double Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_currentDevice = objc.registerName("currentDevice");
final _objc_msgSend_1x359cv = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setCurrentDevice_ = objc.registerName("setCurrentDevice:");
final _objc_msgSend_1jdvcbf = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(
                ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>,
                ffi.Pointer<objc.ObjCObject>)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<objc.ObjCObject>)>();
late final _sel_delegate = objc.registerName("delegate");
late final _sel_setDelegate_ = objc.registerName("setDelegate:");
late final _sel_url = objc.registerName("url");
late final _sel_data = objc.registerName("data");
late final _sel_pan = objc.registerName("pan");
final _objc_msgSend_2cgrxl = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Float Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
final _objc_msgSend_2cgrxlFpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Float Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        double Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setPan_ = objc.registerName("setPan:");
final _objc_msgSend_v5hmet = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Float)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, double)>();
late final _sel_volume = objc.registerName("volume");
late final _sel_setVolume_ = objc.registerName("setVolume:");
late final _sel_setVolume_fadeDuration_ =
    objc.registerName("setVolume:fadeDuration:");
final _objc_msgSend_1p4uk9e = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Float, ffi.Double)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, double, double)>();
late final _sel_enableRate = objc.registerName("enableRate");
late final _sel_setEnableRate_ = objc.registerName("setEnableRate:");
final _objc_msgSend_1s56lr9 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Bool)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, bool)>();
late final _sel_rate = objc.registerName("rate");
late final _sel_setRate_ = objc.registerName("setRate:");
late final _sel_currentTime = objc.registerName("currentTime");
late final _sel_setCurrentTime_ = objc.registerName("setCurrentTime:");
final _objc_msgSend_hwm8nu = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Double)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, double)>();
late final _sel_deviceCurrentTime = objc.registerName("deviceCurrentTime");
late final _sel_numberOfLoops = objc.registerName("numberOfLoops");
final _objc_msgSend_1hz7y9r = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Long Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>)>>()
    .asFunction<
        int Function(
            ffi.Pointer<objc.ObjCObject>, ffi.Pointer<objc.ObjCSelector>)>();
late final _sel_setNumberOfLoops_ = objc.registerName("setNumberOfLoops:");
final _objc_msgSend_4sp4xj = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Void Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Long)>>()
    .asFunction<
        void Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_settings = objc.registerName("settings");
late final _sel_format = objc.registerName("format");
late final _sel_isMeteringEnabled = objc.registerName("isMeteringEnabled");
late final _sel_setMeteringEnabled_ = objc.registerName("setMeteringEnabled:");
late final _sel_updateMeters = objc.registerName("updateMeters");
late final _sel_peakPowerForChannel_ =
    objc.registerName("peakPowerForChannel:");
final _objc_msgSend_65s5yw = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Float Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        double Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
final _objc_msgSend_65s5ywFpret = objc.msgSendFpretPointer
    .cast<
        ffi.NativeFunction<
            ffi.Float Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.UnsignedLong)>>()
    .asFunction<
        double Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, int)>();
late final _sel_averagePowerForChannel_ =
    objc.registerName("averagePowerForChannel:");
late final _sel_channelAssignments = objc.registerName("channelAssignments");
late final _sel_setChannelAssignments_ =
    objc.registerName("setChannelAssignments:");
late final _sel_init = objc.registerName("init");
late final _sel_new = objc.registerName("new");
late final _sel_allocWithZone_ = objc.registerName("allocWithZone:");
final _objc_msgSend_hzlb60 = objc.msgSendPointer
    .cast<
        ffi.NativeFunction<
            ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
                ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<_NSZone>)>>()
    .asFunction<
        ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<objc.ObjCObject>,
            ffi.Pointer<objc.ObjCSelector>, ffi.Pointer<_NSZone>)>();
late final _sel_alloc = objc.registerName("alloc");
late final _sel_self = objc.registerName("self");
ffi.Pointer<objc.ObjCObject> _ObjCBlock_objcObjCObject_ffiVoid_fnPtrTrampoline(
        ffi.Pointer<objc.ObjCBlockImpl> block, ffi.Pointer<ffi.Void> arg0) =>
    block.ref.target
        .cast<
            ffi.NativeFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<ffi.Void> arg0)>>()
        .asFunction<
            ffi.Pointer<objc.ObjCObject> Function(
                ffi.Pointer<ffi.Void>)>()(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_objcObjCObject_ffiVoid_fnPtrCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_fnPtrTrampoline)
        .cast();
ffi.Pointer<objc.ObjCObject>
    _ObjCBlock_objcObjCObject_ffiVoid_closureTrampoline(
            ffi.Pointer<objc.ObjCBlockImpl> block,
            ffi.Pointer<ffi.Void> arg0) =>
        (objc.getBlockClosure(block) as ffi.Pointer<objc.ObjCObject> Function(
            ffi.Pointer<ffi.Void>))(arg0);
ffi.Pointer<ffi.Void> _ObjCBlock_objcObjCObject_ffiVoid_closureCallable =
    ffi.Pointer.fromFunction<
                ffi.Pointer<objc.ObjCObject> Function(
                    ffi.Pointer<objc.ObjCBlockImpl>, ffi.Pointer<ffi.Void>)>(
            _ObjCBlock_objcObjCObject_ffiVoid_closureTrampoline)
        .cast();

/// Construction methods for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>`.
abstract final class ObjCBlock_objcObjCObject_ffiVoid {
  /// Returns a block that wraps the given raw block pointer.
  static objc
      .ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>
      castFromPointer(ffi.Pointer<objc.ObjCBlockImpl> pointer,
              {bool retain = false, bool release = false}) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>(
              pointer,
              retain: retain,
              release: release);

  /// Creates a block from a C function pointer.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>
      fromFunctionPointer(
              ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Pointer<objc.ObjCObject> Function(
                              ffi.Pointer<ffi.Void> arg0)>>
                  ptr) =>
          objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>(
              objc.newPointerBlock(_ObjCBlock_objcObjCObject_ffiVoid_fnPtrCallable, ptr.cast()),
              retain: false,
              release: true);

  /// Creates a block from a Dart function.
  ///
  /// This block must be invoked by native code running on the same thread as
  /// the isolate that registered it. Invoking the block on the wrong thread
  /// will result in a crash.
  static objc
      .ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>
      fromFunction(objc.ObjCObjectBase Function(ffi.Pointer<ffi.Void>) fn) =>
          objc.ObjCBlock<
                  ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>(
              objc.newClosureBlock(
                  _ObjCBlock_objcObjCObject_ffiVoid_closureCallable,
                  (ffi.Pointer<ffi.Void> arg0) =>
                      fn(arg0).ref.retainAndAutorelease()),
              retain: false,
              release: true);
}

/// Call operator for `objc.ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)>`.
extension ObjCBlock_objcObjCObject_ffiVoid_CallExtension on objc
    .ObjCBlock<ffi.Pointer<objc.ObjCObject> Function(ffi.Pointer<ffi.Void>)> {
  objc.ObjCObjectBase call(ffi.Pointer<ffi.Void> arg0) => objc.ObjCObjectBase(
      ref.pointer.ref.invoke
          .cast<
              ffi.NativeFunction<
                  ffi.Pointer<objc.ObjCObject> Function(
                      ffi.Pointer<objc.ObjCBlockImpl> block,
                      ffi.Pointer<ffi.Void> arg0)>>()
          .asFunction<
              ffi.Pointer<objc.ObjCObject> Function(
                  ffi.Pointer<objc.ObjCBlockImpl>,
                  ffi.Pointer<ffi.Void>)>()(ref.pointer, arg0),
      retain: true,
      release: true);
}

late final _sel_retain = objc.registerName("retain");
late final _sel_autorelease = objc.registerName("autorelease");

/// AVAudioPlayer
class AVAudioPlayer extends objc.NSObject {
  AVAudioPlayer._(ffi.Pointer<objc.ObjCObject> pointer,
      {bool retain = false, bool release = false})
      : super.castFromPointer(pointer, retain: retain, release: release);

  /// Constructs a [AVAudioPlayer] that points to the same underlying object as [other].
  AVAudioPlayer.castFrom(objc.ObjCObjectBase other)
      : this._(other.ref.pointer, retain: true, release: true);

  /// Constructs a [AVAudioPlayer] that wraps the given raw object pointer.
  AVAudioPlayer.castFromPointer(ffi.Pointer<objc.ObjCObject> other,
      {bool retain = false, bool release = false})
      : this._(other, retain: retain, release: release);

  /// Returns whether [obj] is an instance of [AVAudioPlayer].
  static bool isInstance(objc.ObjCObjectBase obj) {
    return _objc_msgSend_69e0x1(
        obj.ref.pointer, _sel_isKindOfClass_, _class_AVAudioPlayer);
  }

  /// initWithContentsOfURL:error:
  AVAudioPlayer? initWithContentsOfURL_error_(
      objc.NSURL url, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outError) {
    final _ret = _objc_msgSend_1705co6(this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_error_, url.ref.pointer, outError);
    return _ret.address == 0
        ? null
        : AVAudioPlayer.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithData:error:
  AVAudioPlayer? initWithData_error_(
      objc.NSData data, ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outError) {
    final _ret = _objc_msgSend_1705co6(this.ref.retainAndReturnPointer(),
        _sel_initWithData_error_, data.ref.pointer, outError);
    return _ret.address == 0
        ? null
        : AVAudioPlayer.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithContentsOfURL:fileTypeHint:error:
  AVAudioPlayer? initWithContentsOfURL_fileTypeHint_error_(
      objc.NSURL url,
      objc.NSString? utiString,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outError) {
    final _ret = _objc_msgSend_bo6ep4(
        this.ref.retainAndReturnPointer(),
        _sel_initWithContentsOfURL_fileTypeHint_error_,
        url.ref.pointer,
        utiString?.ref.pointer ?? ffi.nullptr,
        outError);
    return _ret.address == 0
        ? null
        : AVAudioPlayer.castFromPointer(_ret, retain: false, release: true);
  }

  /// initWithData:fileTypeHint:error:
  AVAudioPlayer? initWithData_fileTypeHint_error_(
      objc.NSData data,
      objc.NSString? utiString,
      ffi.Pointer<ffi.Pointer<objc.ObjCObject>> outError) {
    final _ret = _objc_msgSend_bo6ep4(
        this.ref.retainAndReturnPointer(),
        _sel_initWithData_fileTypeHint_error_,
        data.ref.pointer,
        utiString?.ref.pointer ?? ffi.nullptr,
        outError);
    return _ret.address == 0
        ? null
        : AVAudioPlayer.castFromPointer(_ret, retain: false, release: true);
  }

  /// prepareToPlay
  bool prepareToPlay() {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_prepareToPlay);
  }

  /// play
  bool play() {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_play);
  }

  /// playAtTime:
  bool playAtTime_(double time) {
    return _objc_msgSend_18chyc(this.ref.pointer, _sel_playAtTime_, time);
  }

  /// pause
  void pause() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_pause);
  }

  /// stop
  void stop() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_stop);
  }

  /// isPlaying
  bool get playing {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_isPlaying);
  }

  /// numberOfChannels
  int get numberOfChannels {
    return _objc_msgSend_xw2lbc(this.ref.pointer, _sel_numberOfChannels);
  }

  /// duration
  double get duration {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(this.ref.pointer, _sel_duration)
        : _objc_msgSend_1ukqyt8(this.ref.pointer, _sel_duration);
  }

  /// currentDevice
  objc.NSString? get currentDevice {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_currentDevice);
    return _ret.address == 0
        ? null
        : objc.NSString.castFromPointer(_ret, retain: true, release: true);
  }

  /// setCurrentDevice:
  set currentDevice(objc.NSString? value) {
    return _objc_msgSend_1jdvcbf(this.ref.pointer, _sel_setCurrentDevice_,
        value?.ref.pointer ?? ffi.nullptr);
  }

  /// delegate
  objc.ObjCObjectBase? get delegate {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_delegate);
    return _ret.address == 0
        ? null
        : objc.ObjCObjectBase(_ret, retain: true, release: true);
  }

  /// setDelegate:
  set delegate(objc.ObjCObjectBase? value) {
    return _objc_msgSend_1jdvcbf(
        this.ref.pointer, _sel_setDelegate_, value?.ref.pointer ?? ffi.nullptr);
  }

  /// url
  objc.NSURL? get url {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_url);
    return _ret.address == 0
        ? null
        : objc.NSURL.castFromPointer(_ret, retain: true, release: true);
  }

  /// data
  objc.NSData? get data {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_data);
    return _ret.address == 0
        ? null
        : objc.NSData.castFromPointer(_ret, retain: true, release: true);
  }

  /// pan
  double get pan {
    return objc.useMsgSendVariants
        ? _objc_msgSend_2cgrxlFpret(this.ref.pointer, _sel_pan)
        : _objc_msgSend_2cgrxl(this.ref.pointer, _sel_pan);
  }

  /// setPan:
  set pan(double value) {
    return _objc_msgSend_v5hmet(this.ref.pointer, _sel_setPan_, value);
  }

  /// volume
  double get volume {
    return objc.useMsgSendVariants
        ? _objc_msgSend_2cgrxlFpret(this.ref.pointer, _sel_volume)
        : _objc_msgSend_2cgrxl(this.ref.pointer, _sel_volume);
  }

  /// setVolume:
  set volume(double value) {
    return _objc_msgSend_v5hmet(this.ref.pointer, _sel_setVolume_, value);
  }

  /// setVolume:fadeDuration:
  void setVolume_fadeDuration_(double volume, double duration) {
    _objc_msgSend_1p4uk9e(
        this.ref.pointer, _sel_setVolume_fadeDuration_, volume, duration);
  }

  /// enableRate
  bool get enableRate {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_enableRate);
  }

  /// setEnableRate:
  set enableRate(bool value) {
    return _objc_msgSend_1s56lr9(this.ref.pointer, _sel_setEnableRate_, value);
  }

  /// rate
  double get rate {
    return objc.useMsgSendVariants
        ? _objc_msgSend_2cgrxlFpret(this.ref.pointer, _sel_rate)
        : _objc_msgSend_2cgrxl(this.ref.pointer, _sel_rate);
  }

  /// setRate:
  set rate(double value) {
    return _objc_msgSend_v5hmet(this.ref.pointer, _sel_setRate_, value);
  }

  /// currentTime
  double get currentTime {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(this.ref.pointer, _sel_currentTime)
        : _objc_msgSend_1ukqyt8(this.ref.pointer, _sel_currentTime);
  }

  /// setCurrentTime:
  set currentTime(double value) {
    return _objc_msgSend_hwm8nu(this.ref.pointer, _sel_setCurrentTime_, value);
  }

  /// deviceCurrentTime
  double get deviceCurrentTime {
    return objc.useMsgSendVariants
        ? _objc_msgSend_1ukqyt8Fpret(this.ref.pointer, _sel_deviceCurrentTime)
        : _objc_msgSend_1ukqyt8(this.ref.pointer, _sel_deviceCurrentTime);
  }

  /// numberOfLoops
  int get numberOfLoops {
    return _objc_msgSend_1hz7y9r(this.ref.pointer, _sel_numberOfLoops);
  }

  /// setNumberOfLoops:
  set numberOfLoops(int value) {
    return _objc_msgSend_4sp4xj(
        this.ref.pointer, _sel_setNumberOfLoops_, value);
  }

  /// settings
  objc.NSDictionary get settings {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_settings);
    return objc.NSDictionary.castFromPointer(_ret, retain: true, release: true);
  }

  /// format
  AVAudioFormat get format {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_format);
    return AVAudioFormat.castFromPointer(_ret, retain: true, release: true);
  }

  /// isMeteringEnabled
  bool get meteringEnabled {
    return _objc_msgSend_91o635(this.ref.pointer, _sel_isMeteringEnabled);
  }

  /// setMeteringEnabled:
  set meteringEnabled(bool value) {
    return _objc_msgSend_1s56lr9(
        this.ref.pointer, _sel_setMeteringEnabled_, value);
  }

  /// updateMeters
  void updateMeters() {
    _objc_msgSend_1pl9qdv(this.ref.pointer, _sel_updateMeters);
  }

  /// peakPowerForChannel:
  double peakPowerForChannel_(int channelNumber) {
    return objc.useMsgSendVariants
        ? _objc_msgSend_65s5ywFpret(
            this.ref.pointer, _sel_peakPowerForChannel_, channelNumber)
        : _objc_msgSend_65s5yw(
            this.ref.pointer, _sel_peakPowerForChannel_, channelNumber);
  }

  /// averagePowerForChannel:
  double averagePowerForChannel_(int channelNumber) {
    return objc.useMsgSendVariants
        ? _objc_msgSend_65s5ywFpret(
            this.ref.pointer, _sel_averagePowerForChannel_, channelNumber)
        : _objc_msgSend_65s5yw(
            this.ref.pointer, _sel_averagePowerForChannel_, channelNumber);
  }

  /// channelAssignments
  objc.NSArray? get channelAssignments {
    final _ret =
        _objc_msgSend_1x359cv(this.ref.pointer, _sel_channelAssignments);
    return _ret.address == 0
        ? null
        : objc.NSArray.castFromPointer(_ret, retain: true, release: true);
  }

  /// setChannelAssignments:
  set channelAssignments(objc.NSArray? value) {
    return _objc_msgSend_1jdvcbf(this.ref.pointer, _sel_setChannelAssignments_,
        value?.ref.pointer ?? ffi.nullptr);
  }

  /// init
  AVAudioPlayer init() {
    final _ret =
        _objc_msgSend_1x359cv(this.ref.retainAndReturnPointer(), _sel_init);
    return AVAudioPlayer.castFromPointer(_ret, retain: false, release: true);
  }

  /// new
  static AVAudioPlayer new1() {
    final _ret = _objc_msgSend_1x359cv(_class_AVAudioPlayer, _sel_new);
    return AVAudioPlayer.castFromPointer(_ret, retain: false, release: true);
  }

  /// allocWithZone:
  static AVAudioPlayer allocWithZone_(ffi.Pointer<_NSZone> zone) {
    final _ret =
        _objc_msgSend_hzlb60(_class_AVAudioPlayer, _sel_allocWithZone_, zone);
    return AVAudioPlayer.castFromPointer(_ret, retain: false, release: true);
  }

  /// alloc
  static AVAudioPlayer alloc() {
    final _ret = _objc_msgSend_1x359cv(_class_AVAudioPlayer, _sel_alloc);
    return AVAudioPlayer.castFromPointer(_ret, retain: false, release: true);
  }

  /// self
  AVAudioPlayer self() {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_self);
    return AVAudioPlayer.castFromPointer(_ret, retain: true, release: true);
  }

  /// retain
  AVAudioPlayer retain() {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_retain);
    return AVAudioPlayer.castFromPointer(_ret, retain: true, release: true);
  }

  /// autorelease
  AVAudioPlayer autorelease() {
    final _ret = _objc_msgSend_1x359cv(this.ref.pointer, _sel_autorelease);
    return AVAudioPlayer.castFromPointer(_ret, retain: true, release: true);
  }
}
