// Part of the LLVM Project, under the Apache License v2.0 with LLVM
// Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

// ignore_for_file: camel_case_types, non_constant_identifier_names

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;

/// Holds bindings to LibClang.
class Clang {
  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
      _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  Clang(ffi.DynamicLibrary dynamicLibrary) : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  Clang.fromLookup(
      ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
          lookup)
      : _lookup = lookup;

  /// Retrieve the character data associated with the given string.
  ffi.Pointer<ffi.Char> clang_getCString(
    CXString string,
  ) {
    return _clang_getCString(
      string,
    );
  }

  late final _clang_getCStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(CXString)>>(
          'clang_getCString');
  late final _clang_getCString = _clang_getCStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(CXString)>();

  /// Free the given string.
  void clang_disposeString(
    CXString string,
  ) {
    return _clang_disposeString(
      string,
    );
  }

  late final _clang_disposeStringPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(CXString)>>(
          'clang_disposeString');
  late final _clang_disposeString =
      _clang_disposeStringPtr.asFunction<void Function(CXString)>();

  /// Provides a shared context for creating translation units.
  ///
  /// It provides two options:
  ///
  /// - excludeDeclarationsFromPCH: When non-zero, allows enumeration of "local"
  /// declarations (when loading any new translation units). A "local" declaration
  /// is one that belongs in the translation unit itself and not in a precompiled
  /// header that was used by the translation unit. If zero, all declarations
  /// will be enumerated.
  ///
  /// Here is an example:
  ///
  /// \code
  /// // excludeDeclsFromPCH = 1, displayDiagnostics=1
  /// Idx = clang_createIndex(1, 1);
  ///
  /// // IndexTest.pch was produced with the following command:
  /// // "clang -x c IndexTest.h -emit-ast -o IndexTest.pch"
  /// TU = clang_createTranslationUnit(Idx, "IndexTest.pch");
  ///
  /// // This will load all the symbols from 'IndexTest.pch'
  /// clang_visitChildren(clang_getTranslationUnitCursor(TU),
  /// TranslationUnitVisitor, 0);
  /// clang_disposeTranslationUnit(TU);
  ///
  /// // This will load all the symbols from 'IndexTest.c', excluding symbols
  /// // from 'IndexTest.pch'.
  /// char *args[] = { "-Xclang", "-include-pch=IndexTest.pch" };
  /// TU = clang_createTranslationUnitFromSourceFile(Idx, "IndexTest.c", 2, args,
  /// 0, 0);
  /// clang_visitChildren(clang_getTranslationUnitCursor(TU),
  /// TranslationUnitVisitor, 0);
  /// clang_disposeTranslationUnit(TU);
  /// \endcode
  ///
  /// This process of creating the 'pch', loading it separately, and using it (via
  /// -include-pch) allows 'excludeDeclsFromPCH' to remove redundant callbacks
  /// (which gives the indexer the same performance benefit as the compiler).
  CXIndex clang_createIndex(
    int excludeDeclarationsFromPCH,
    int displayDiagnostics,
  ) {
    return _clang_createIndex(
      excludeDeclarationsFromPCH,
      displayDiagnostics,
    );
  }

  late final _clang_createIndexPtr =
      _lookup<ffi.NativeFunction<CXIndex Function(ffi.Int, ffi.Int)>>(
          'clang_createIndex');
  late final _clang_createIndex =
      _clang_createIndexPtr.asFunction<CXIndex Function(int, int)>();

  /// Destroy the given index.
  ///
  /// The index must not be destroyed until all of the translation units created
  /// within that index have been destroyed.
  void clang_disposeIndex(
    CXIndex index,
  ) {
    return _clang_disposeIndex(
      index,
    );
  }

  late final _clang_disposeIndexPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(CXIndex)>>(
          'clang_disposeIndex');
  late final _clang_disposeIndex =
      _clang_disposeIndexPtr.asFunction<void Function(CXIndex)>();

  /// Retrieve the complete file and path name of the given file.
  CXString clang_getFileName(
    CXFile SFile,
  ) {
    return _clang_getFileName(
      SFile,
    );
  }

  late final _clang_getFileNamePtr =
      _lookup<ffi.NativeFunction<CXString Function(CXFile)>>(
          'clang_getFileName');
  late final _clang_getFileName =
      _clang_getFileNamePtr.asFunction<CXString Function(CXFile)>();

  /// Returns non-zero if the given source location is in a system header.
  int clang_Location_isInSystemHeader(
    CXSourceLocation location,
  ) {
    return _clang_Location_isInSystemHeader(
      location,
    );
  }

  late final _clang_Location_isInSystemHeaderPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(CXSourceLocation)>>(
          'clang_Location_isInSystemHeader');
  late final _clang_Location_isInSystemHeader =
      _clang_Location_isInSystemHeaderPtr
          .asFunction<int Function(CXSourceLocation)>();

  /// Determine whether two ranges are equivalent.
  ///
  /// \returns non-zero if the ranges are the same, zero if they differ.
  int clang_equalRanges(
    CXSourceRange range1,
    CXSourceRange range2,
  ) {
    return _clang_equalRanges(
      range1,
      range2,
    );
  }

  late final _clang_equalRangesPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              CXSourceRange, CXSourceRange)>>('clang_equalRanges');
  late final _clang_equalRanges = _clang_equalRangesPtr
      .asFunction<int Function(CXSourceRange, CXSourceRange)>();

  /// Retrieve the file, line, column, and offset represented by
  /// the given source location.
  ///
  /// If the location refers into a macro expansion, return where the macro was
  /// expanded or where the macro argument was written, if the location points at
  /// a macro argument.
  ///
  /// \param location the location within a source file that will be decomposed
  /// into its parts.
  ///
  /// \param file [out] if non-NULL, will be set to the file to which the given
  /// source location points.
  ///
  /// \param line [out] if non-NULL, will be set to the line to which the given
  /// source location points.
  ///
  /// \param column [out] if non-NULL, will be set to the column to which the given
  /// source location points.
  ///
  /// \param offset [out] if non-NULL, will be set to the offset into the
  /// buffer to which the given source location points.
  void clang_getFileLocation(
    CXSourceLocation location,
    ffi.Pointer<CXFile> file,
    ffi.Pointer<ffi.UnsignedInt> line,
    ffi.Pointer<ffi.UnsignedInt> column,
    ffi.Pointer<ffi.UnsignedInt> offset,
  ) {
    return _clang_getFileLocation(
      location,
      file,
      line,
      column,
      offset,
    );
  }

  late final _clang_getFileLocationPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              CXSourceLocation,
              ffi.Pointer<CXFile>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>)>>('clang_getFileLocation');
  late final _clang_getFileLocation = _clang_getFileLocationPtr.asFunction<
      void Function(
          CXSourceLocation,
          ffi.Pointer<CXFile>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>)>();

  /// Determine the number of diagnostics produced for the given
  /// translation unit.
  int clang_getNumDiagnostics(
    CXTranslationUnit Unit,
  ) {
    return _clang_getNumDiagnostics(
      Unit,
    );
  }

  late final _clang_getNumDiagnosticsPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXTranslationUnit)>>(
          'clang_getNumDiagnostics');
  late final _clang_getNumDiagnostics =
      _clang_getNumDiagnosticsPtr.asFunction<int Function(CXTranslationUnit)>();

  /// Retrieve a diagnostic associated with the given translation unit.
  ///
  /// \param Unit the translation unit to query.
  /// \param Index the zero-based diagnostic number to retrieve.
  ///
  /// \returns the requested diagnostic. This diagnostic must be freed
  /// via a call to \c clang_disposeDiagnostic().
  CXDiagnostic clang_getDiagnostic(
    CXTranslationUnit Unit,
    int Index,
  ) {
    return _clang_getDiagnostic(
      Unit,
      Index,
    );
  }

  late final _clang_getDiagnosticPtr = _lookup<
      ffi.NativeFunction<
          CXDiagnostic Function(
              CXTranslationUnit, ffi.UnsignedInt)>>('clang_getDiagnostic');
  late final _clang_getDiagnostic = _clang_getDiagnosticPtr
      .asFunction<CXDiagnostic Function(CXTranslationUnit, int)>();

  /// Destroy a diagnostic.
  void clang_disposeDiagnostic(
    CXDiagnostic Diagnostic,
  ) {
    return _clang_disposeDiagnostic(
      Diagnostic,
    );
  }

  late final _clang_disposeDiagnosticPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(CXDiagnostic)>>(
          'clang_disposeDiagnostic');
  late final _clang_disposeDiagnostic =
      _clang_disposeDiagnosticPtr.asFunction<void Function(CXDiagnostic)>();

  /// Format the given diagnostic in a manner that is suitable for display.
  ///
  /// This routine will format the given diagnostic to a string, rendering
  /// the diagnostic according to the various options given. The
  /// \c clang_defaultDiagnosticDisplayOptions() function returns the set of
  /// options that most closely mimics the behavior of the clang compiler.
  ///
  /// \param Diagnostic The diagnostic to print.
  ///
  /// \param Options A set of options that control the diagnostic display,
  /// created by combining \c CXDiagnosticDisplayOptions values.
  ///
  /// \returns A new string containing for formatted diagnostic.
  CXString clang_formatDiagnostic(
    CXDiagnostic Diagnostic,
    int Options,
  ) {
    return _clang_formatDiagnostic(
      Diagnostic,
      Options,
    );
  }

  late final _clang_formatDiagnosticPtr = _lookup<
          ffi.NativeFunction<CXString Function(CXDiagnostic, ffi.UnsignedInt)>>(
      'clang_formatDiagnostic');
  late final _clang_formatDiagnostic = _clang_formatDiagnosticPtr
      .asFunction<CXString Function(CXDiagnostic, int)>();

  /// Determine the severity of the given diagnostic.
  int clang_getDiagnosticSeverity(
    CXDiagnostic arg0,
  ) {
    return _clang_getDiagnosticSeverity(
      arg0,
    );
  }

  late final _clang_getDiagnosticSeverityPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXDiagnostic)>>(
          'clang_getDiagnosticSeverity');
  late final _clang_getDiagnosticSeverity =
      _clang_getDiagnosticSeverityPtr.asFunction<int Function(CXDiagnostic)>();

  /// Same as \c clang_parseTranslationUnit2, but returns
  /// the \c CXTranslationUnit instead of an error code.  In case of an error this
  /// routine returns a \c NULL \c CXTranslationUnit, without further detailed
  /// error codes.
  CXTranslationUnit clang_parseTranslationUnit(
    CXIndex CIdx,
    ffi.Pointer<ffi.Char> source_filename,
    ffi.Pointer<ffi.Pointer<ffi.Char>> command_line_args,
    int num_command_line_args,
    ffi.Pointer<CXUnsavedFile> unsaved_files,
    int num_unsaved_files,
    int options,
  ) {
    return _clang_parseTranslationUnit(
      CIdx,
      source_filename,
      command_line_args,
      num_command_line_args,
      unsaved_files,
      num_unsaved_files,
      options,
    );
  }

  late final _clang_parseTranslationUnitPtr = _lookup<
      ffi.NativeFunction<
          CXTranslationUnit Function(
              CXIndex,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Int,
              ffi.Pointer<CXUnsavedFile>,
              ffi.UnsignedInt,
              ffi.UnsignedInt)>>('clang_parseTranslationUnit');
  late final _clang_parseTranslationUnit =
      _clang_parseTranslationUnitPtr.asFunction<
          CXTranslationUnit Function(
              CXIndex,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              int,
              ffi.Pointer<CXUnsavedFile>,
              int,
              int)>();

  /// Destroy the specified CXTranslationUnit object.
  void clang_disposeTranslationUnit(
    CXTranslationUnit arg0,
  ) {
    return _clang_disposeTranslationUnit(
      arg0,
    );
  }

  late final _clang_disposeTranslationUnitPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(CXTranslationUnit)>>(
          'clang_disposeTranslationUnit');
  late final _clang_disposeTranslationUnit = _clang_disposeTranslationUnitPtr
      .asFunction<void Function(CXTranslationUnit)>();

  /// Retrieve the cursor that represents the given translation unit.
  ///
  /// The translation unit cursor can be used to start traversing the
  /// various declarations within the given translation unit.
  CXCursor clang_getTranslationUnitCursor(
    CXTranslationUnit arg0,
  ) {
    return _clang_getTranslationUnitCursor(
      arg0,
    );
  }

  late final _clang_getTranslationUnitCursorPtr =
      _lookup<ffi.NativeFunction<CXCursor Function(CXTranslationUnit)>>(
          'clang_getTranslationUnitCursor');
  late final _clang_getTranslationUnitCursor =
      _clang_getTranslationUnitCursorPtr
          .asFunction<CXCursor Function(CXTranslationUnit)>();

  /// Returns non-zero if \p cursor is null.
  int clang_Cursor_isNull(
    CXCursor cursor,
  ) {
    return _clang_Cursor_isNull(
      cursor,
    );
  }

  late final _clang_Cursor_isNullPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(CXCursor)>>(
          'clang_Cursor_isNull');
  late final _clang_Cursor_isNull =
      _clang_Cursor_isNullPtr.asFunction<int Function(CXCursor)>();

  /// Retrieve the kind of the given cursor.
  int clang_getCursorKind(
    CXCursor arg0,
  ) {
    return _clang_getCursorKind(
      arg0,
    );
  }

  late final _clang_getCursorKindPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_getCursorKind');
  late final _clang_getCursorKind =
      _clang_getCursorKindPtr.asFunction<int Function(CXCursor)>();

  /// Determine whether the given cursor has any attributes.
  int clang_Cursor_hasAttrs(
    CXCursor C,
  ) {
    return _clang_Cursor_hasAttrs(
      C,
    );
  }

  late final _clang_Cursor_hasAttrsPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_Cursor_hasAttrs');
  late final _clang_Cursor_hasAttrs =
      _clang_Cursor_hasAttrsPtr.asFunction<int Function(CXCursor)>();

  /// Determine the availability of the entity that this cursor refers to,
  /// taking the current target platform into account.
  ///
  /// \param cursor The cursor to query.
  ///
  /// \returns The availability of the cursor.
  int clang_getCursorAvailability(
    CXCursor cursor,
  ) {
    return _clang_getCursorAvailability(
      cursor,
    );
  }

  late final _clang_getCursorAvailabilityPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_getCursorAvailability');
  late final _clang_getCursorAvailability =
      _clang_getCursorAvailabilityPtr.asFunction<int Function(CXCursor)>();

  /// Determine the availability of the entity that this cursor refers to
  /// on any platforms for which availability information is known.
  ///
  /// \param cursor The cursor to query.
  ///
  /// \param always_deprecated If non-NULL, will be set to indicate whether the
  /// entity is deprecated on all platforms.
  ///
  /// \param deprecated_message If non-NULL, will be set to the message text
  /// provided along with the unconditional deprecation of this entity. The client
  /// is responsible for deallocating this string.
  ///
  /// \param always_unavailable If non-NULL, will be set to indicate whether the
  /// entity is unavailable on all platforms.
  ///
  /// \param unavailable_message If non-NULL, will be set to the message text
  /// provided along with the unconditional unavailability of this entity. The
  /// client is responsible for deallocating this string.
  ///
  /// \param availability If non-NULL, an array of CXPlatformAvailability instances
  /// that will be populated with platform availability information, up to either
  /// the number of platforms for which availability information is available (as
  /// returned by this function) or \c availability_size, whichever is smaller.
  ///
  /// \param availability_size The number of elements available in the
  /// \c availability array.
  ///
  /// \returns The number of platforms (N) for which availability information is
  /// available (which is unrelated to \c availability_size).
  ///
  /// Note that the client is responsible for calling
  /// \c clang_disposeCXPlatformAvailability to free each of the
  /// platform-availability structures returned. There are
  /// \c min(N, availability_size) such structures.
  int clang_getCursorPlatformAvailability(
    CXCursor cursor,
    ffi.Pointer<ffi.Int> always_deprecated,
    ffi.Pointer<CXString> deprecated_message,
    ffi.Pointer<ffi.Int> always_unavailable,
    ffi.Pointer<CXString> unavailable_message,
    ffi.Pointer<CXPlatformAvailability> availability,
    int availability_size,
  ) {
    return _clang_getCursorPlatformAvailability(
      cursor,
      always_deprecated,
      deprecated_message,
      always_unavailable,
      unavailable_message,
      availability,
      availability_size,
    );
  }

  late final _clang_getCursorPlatformAvailabilityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              CXCursor,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<CXString>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<CXString>,
              ffi.Pointer<CXPlatformAvailability>,
              ffi.Int)>>('clang_getCursorPlatformAvailability');
  late final _clang_getCursorPlatformAvailability =
      _clang_getCursorPlatformAvailabilityPtr.asFunction<
          int Function(
              CXCursor,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<CXString>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<CXString>,
              ffi.Pointer<CXPlatformAvailability>,
              int)>();

  /// Free the memory associated with a \c CXPlatformAvailability structure.
  void clang_disposeCXPlatformAvailability(
    ffi.Pointer<CXPlatformAvailability> availability,
  ) {
    return _clang_disposeCXPlatformAvailability(
      availability,
    );
  }

  late final _clang_disposeCXPlatformAvailabilityPtr = _lookup<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<CXPlatformAvailability>)>>(
      'clang_disposeCXPlatformAvailability');
  late final _clang_disposeCXPlatformAvailability =
      _clang_disposeCXPlatformAvailabilityPtr
          .asFunction<void Function(ffi.Pointer<CXPlatformAvailability>)>();

  /// Retrieve the physical location of the source constructor referenced
  /// by the given cursor.
  ///
  /// The location of a declaration is typically the location of the name of that
  /// declaration, where the name of that declaration would occur if it is
  /// unnamed, or some keyword that introduces that particular declaration.
  /// The location of a reference is where that reference occurs within the
  /// source code.
  CXSourceLocation clang_getCursorLocation(
    CXCursor arg0,
  ) {
    return _clang_getCursorLocation(
      arg0,
    );
  }

  late final _clang_getCursorLocationPtr =
      _lookup<ffi.NativeFunction<CXSourceLocation Function(CXCursor)>>(
          'clang_getCursorLocation');
  late final _clang_getCursorLocation = _clang_getCursorLocationPtr
      .asFunction<CXSourceLocation Function(CXCursor)>();

  /// Retrieve the type of a CXCursor (if any).
  CXType clang_getCursorType(
    CXCursor C,
  ) {
    return _clang_getCursorType(
      C,
    );
  }

  late final _clang_getCursorTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXCursor)>>(
          'clang_getCursorType');
  late final _clang_getCursorType =
      _clang_getCursorTypePtr.asFunction<CXType Function(CXCursor)>();

  /// Pretty-print the underlying type using the rules of the
  /// language of the translation unit from which it came.
  ///
  /// If the type is invalid, an empty string is returned.
  CXString clang_getTypeSpelling(
    CXType CT,
  ) {
    return _clang_getTypeSpelling(
      CT,
    );
  }

  late final _clang_getTypeSpellingPtr =
      _lookup<ffi.NativeFunction<CXString Function(CXType)>>(
          'clang_getTypeSpelling');
  late final _clang_getTypeSpelling =
      _clang_getTypeSpellingPtr.asFunction<CXString Function(CXType)>();

  /// Retrieve the underlying type of a typedef declaration.
  ///
  /// If the cursor does not reference a typedef declaration, an invalid type is
  /// returned.
  CXType clang_getTypedefDeclUnderlyingType(
    CXCursor C,
  ) {
    return _clang_getTypedefDeclUnderlyingType(
      C,
    );
  }

  late final _clang_getTypedefDeclUnderlyingTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXCursor)>>(
          'clang_getTypedefDeclUnderlyingType');
  late final _clang_getTypedefDeclUnderlyingType =
      _clang_getTypedefDeclUnderlyingTypePtr
          .asFunction<CXType Function(CXCursor)>();

  /// Retrieve the integer type of an enum declaration.
  ///
  /// If the cursor does not reference an enum declaration, an invalid type is
  /// returned.
  CXType clang_getEnumDeclIntegerType(
    CXCursor C,
  ) {
    return _clang_getEnumDeclIntegerType(
      C,
    );
  }

  late final _clang_getEnumDeclIntegerTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXCursor)>>(
          'clang_getEnumDeclIntegerType');
  late final _clang_getEnumDeclIntegerType =
      _clang_getEnumDeclIntegerTypePtr.asFunction<CXType Function(CXCursor)>();

  /// Retrieve the integer value of an enum constant declaration as a signed
  /// long long.
  ///
  /// If the cursor does not reference an enum constant declaration, LLONG_MIN is returned.
  /// Since this is also potentially a valid constant value, the kind of the cursor
  /// must be verified before calling this function.
  int clang_getEnumConstantDeclValue(
    CXCursor C,
  ) {
    return _clang_getEnumConstantDeclValue(
      C,
    );
  }

  late final _clang_getEnumConstantDeclValuePtr =
      _lookup<ffi.NativeFunction<ffi.LongLong Function(CXCursor)>>(
          'clang_getEnumConstantDeclValue');
  late final _clang_getEnumConstantDeclValue =
      _clang_getEnumConstantDeclValuePtr.asFunction<int Function(CXCursor)>();

  /// Retrieve the bit width of a bit field declaration as an integer.
  ///
  /// If a cursor that is not a bit field declaration is passed in, -1 is returned.
  int clang_getFieldDeclBitWidth(
    CXCursor C,
  ) {
    return _clang_getFieldDeclBitWidth(
      C,
    );
  }

  late final _clang_getFieldDeclBitWidthPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(CXCursor)>>(
          'clang_getFieldDeclBitWidth');
  late final _clang_getFieldDeclBitWidth =
      _clang_getFieldDeclBitWidthPtr.asFunction<int Function(CXCursor)>();

  /// Retrieve the number of non-variadic arguments associated with a given
  /// cursor.
  ///
  /// The number of arguments can be determined for calls as well as for
  /// declarations of functions or methods. For other cursors -1 is returned.
  int clang_Cursor_getNumArguments(
    CXCursor C,
  ) {
    return _clang_Cursor_getNumArguments(
      C,
    );
  }

  late final _clang_Cursor_getNumArgumentsPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(CXCursor)>>(
          'clang_Cursor_getNumArguments');
  late final _clang_Cursor_getNumArguments =
      _clang_Cursor_getNumArgumentsPtr.asFunction<int Function(CXCursor)>();

  /// Retrieve the argument cursor of a function or method.
  ///
  /// The argument cursor can be determined for calls as well as for declarations
  /// of functions or methods. For other cursors and for invalid indices, an
  /// invalid cursor is returned.
  CXCursor clang_Cursor_getArgument(
    CXCursor C,
    int i,
  ) {
    return _clang_Cursor_getArgument(
      C,
      i,
    );
  }

  late final _clang_Cursor_getArgumentPtr =
      _lookup<ffi.NativeFunction<CXCursor Function(CXCursor, ffi.UnsignedInt)>>(
          'clang_Cursor_getArgument');
  late final _clang_Cursor_getArgument = _clang_Cursor_getArgumentPtr
      .asFunction<CXCursor Function(CXCursor, int)>();

  /// Return the canonical type for a CXType.
  ///
  /// Clang's type system explicitly models typedefs and all the ways
  /// a specific type can be represented.  The canonical type is the underlying
  /// type with all the "sugar" removed.  For example, if 'T' is a typedef
  /// for 'int', the canonical type for 'T' would be 'int'.
  CXType clang_getCanonicalType(
    CXType T,
  ) {
    return _clang_getCanonicalType(
      T,
    );
  }

  late final _clang_getCanonicalTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXType)>>(
          'clang_getCanonicalType');
  late final _clang_getCanonicalType =
      _clang_getCanonicalTypePtr.asFunction<CXType Function(CXType)>();

  /// Determine whether a CXType has the "const" qualifier set,
  /// without looking through typedefs that may have added "const" at a
  /// different level.
  int clang_isConstQualifiedType(
    CXType T,
  ) {
    return _clang_isConstQualifiedType(
      T,
    );
  }

  late final _clang_isConstQualifiedTypePtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXType)>>(
          'clang_isConstQualifiedType');
  late final _clang_isConstQualifiedType =
      _clang_isConstQualifiedTypePtr.asFunction<int Function(CXType)>();

  /// Determine whether a  CXCursor that is a macro, is
  /// function like.
  int clang_Cursor_isMacroFunctionLike(
    CXCursor C,
  ) {
    return _clang_Cursor_isMacroFunctionLike(
      C,
    );
  }

  late final _clang_Cursor_isMacroFunctionLikePtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_Cursor_isMacroFunctionLike');
  late final _clang_Cursor_isMacroFunctionLike =
      _clang_Cursor_isMacroFunctionLikePtr.asFunction<int Function(CXCursor)>();

  /// Determine whether a  CXCursor that is a macro, is a
  /// builtin one.
  int clang_Cursor_isMacroBuiltin(
    CXCursor C,
  ) {
    return _clang_Cursor_isMacroBuiltin(
      C,
    );
  }

  late final _clang_Cursor_isMacroBuiltinPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_Cursor_isMacroBuiltin');
  late final _clang_Cursor_isMacroBuiltin =
      _clang_Cursor_isMacroBuiltinPtr.asFunction<int Function(CXCursor)>();

  /// Determine whether a  CXCursor that is a function declaration, is an
  /// inline declaration.
  int clang_Cursor_isFunctionInlined(
    CXCursor C,
  ) {
    return _clang_Cursor_isFunctionInlined(
      C,
    );
  }

  late final _clang_Cursor_isFunctionInlinedPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_Cursor_isFunctionInlined');
  late final _clang_Cursor_isFunctionInlined =
      _clang_Cursor_isFunctionInlinedPtr.asFunction<int Function(CXCursor)>();

  /// Returns the typedef name of the given type.
  CXString clang_getTypedefName(
    CXType CT,
  ) {
    return _clang_getTypedefName(
      CT,
    );
  }

  late final _clang_getTypedefNamePtr =
      _lookup<ffi.NativeFunction<CXString Function(CXType)>>(
          'clang_getTypedefName');
  late final _clang_getTypedefName =
      _clang_getTypedefNamePtr.asFunction<CXString Function(CXType)>();

  /// For pointer types, returns the type of the pointee.
  CXType clang_getPointeeType(
    CXType T,
  ) {
    return _clang_getPointeeType(
      T,
    );
  }

  late final _clang_getPointeeTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXType)>>(
          'clang_getPointeeType');
  late final _clang_getPointeeType =
      _clang_getPointeeTypePtr.asFunction<CXType Function(CXType)>();

  /// Return the cursor for the declaration of the given type.
  CXCursor clang_getTypeDeclaration(
    CXType T,
  ) {
    return _clang_getTypeDeclaration(
      T,
    );
  }

  late final _clang_getTypeDeclarationPtr =
      _lookup<ffi.NativeFunction<CXCursor Function(CXType)>>(
          'clang_getTypeDeclaration');
  late final _clang_getTypeDeclaration =
      _clang_getTypeDeclarationPtr.asFunction<CXCursor Function(CXType)>();

  /// Retrieve the spelling of a given CXTypeKind.
  CXString clang_getTypeKindSpelling(
    int K,
  ) {
    return _clang_getTypeKindSpelling(
      K,
    );
  }

  late final _clang_getTypeKindSpellingPtr =
      _lookup<ffi.NativeFunction<CXString Function(ffi.UnsignedInt)>>(
          'clang_getTypeKindSpelling');
  late final _clang_getTypeKindSpelling =
      _clang_getTypeKindSpellingPtr.asFunction<CXString Function(int)>();

  /// Retrieve the return type associated with a function type.
  ///
  /// If a non-function type is passed in, an invalid type is returned.
  CXType clang_getResultType(
    CXType T,
  ) {
    return _clang_getResultType(
      T,
    );
  }

  late final _clang_getResultTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXType)>>(
          'clang_getResultType');
  late final _clang_getResultType =
      _clang_getResultTypePtr.asFunction<CXType Function(CXType)>();

  /// Retrieve the number of non-variadic parameters associated with a
  /// function type.
  ///
  /// If a non-function type is passed in, -1 is returned.
  int clang_getNumArgTypes(
    CXType T,
  ) {
    return _clang_getNumArgTypes(
      T,
    );
  }

  late final _clang_getNumArgTypesPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(CXType)>>(
          'clang_getNumArgTypes');
  late final _clang_getNumArgTypes =
      _clang_getNumArgTypesPtr.asFunction<int Function(CXType)>();

  /// Retrieve the type of a parameter of a function type.
  ///
  /// If a non-function type is passed in or the function does not have enough
  /// parameters, an invalid type is returned.
  CXType clang_getArgType(
    CXType T,
    int i,
  ) {
    return _clang_getArgType(
      T,
      i,
    );
  }

  late final _clang_getArgTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXType, ffi.UnsignedInt)>>(
          'clang_getArgType');
  late final _clang_getArgType =
      _clang_getArgTypePtr.asFunction<CXType Function(CXType, int)>();

  /// Retrieves the base type of the ObjCObjectType.
  ///
  /// If the type is not an ObjC object, an invalid type is returned.
  CXType clang_Type_getObjCObjectBaseType(
    CXType T,
  ) {
    return _clang_Type_getObjCObjectBaseType(
      T,
    );
  }

  late final _clang_Type_getObjCObjectBaseTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXType)>>(
          'clang_Type_getObjCObjectBaseType');
  late final _clang_Type_getObjCObjectBaseType =
      _clang_Type_getObjCObjectBaseTypePtr
          .asFunction<CXType Function(CXType)>();

  /// Return 1 if the CXType is a variadic function type, and 0 otherwise.
  int clang_isFunctionTypeVariadic(
    CXType T,
  ) {
    return _clang_isFunctionTypeVariadic(
      T,
    );
  }

  late final _clang_isFunctionTypeVariadicPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXType)>>(
          'clang_isFunctionTypeVariadic');
  late final _clang_isFunctionTypeVariadic =
      _clang_isFunctionTypeVariadicPtr.asFunction<int Function(CXType)>();

  /// Retrieve the return type associated with a given cursor.
  ///
  /// This only returns a valid type if the cursor refers to a function or method.
  CXType clang_getCursorResultType(
    CXCursor C,
  ) {
    return _clang_getCursorResultType(
      C,
    );
  }

  late final _clang_getCursorResultTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXCursor)>>(
          'clang_getCursorResultType');
  late final _clang_getCursorResultType =
      _clang_getCursorResultTypePtr.asFunction<CXType Function(CXCursor)>();

  /// Return the number of elements of an array or vector type.
  ///
  /// If a type is passed in that is not an array or vector type,
  /// -1 is returned.
  int clang_getNumElements(
    CXType T,
  ) {
    return _clang_getNumElements(
      T,
    );
  }

  late final _clang_getNumElementsPtr =
      _lookup<ffi.NativeFunction<ffi.LongLong Function(CXType)>>(
          'clang_getNumElements');
  late final _clang_getNumElements =
      _clang_getNumElementsPtr.asFunction<int Function(CXType)>();

  /// Return the element type of an array type.
  ///
  /// If a non-array type is passed in, an invalid type is returned.
  CXType clang_getArrayElementType(
    CXType T,
  ) {
    return _clang_getArrayElementType(
      T,
    );
  }

  late final _clang_getArrayElementTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXType)>>(
          'clang_getArrayElementType');
  late final _clang_getArrayElementType =
      _clang_getArrayElementTypePtr.asFunction<CXType Function(CXType)>();

  /// Retrieve the type named by the qualified-id.
  ///
  /// If a non-elaborated type is passed in, an invalid type is returned.
  CXType clang_Type_getNamedType(
    CXType T,
  ) {
    return _clang_Type_getNamedType(
      T,
    );
  }

  late final _clang_Type_getNamedTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXType)>>(
          'clang_Type_getNamedType');
  late final _clang_Type_getNamedType =
      _clang_Type_getNamedTypePtr.asFunction<CXType Function(CXType)>();

  /// Retrieve the nullability kind of a pointer type.
  int clang_Type_getNullability(
    CXType T,
  ) {
    return _clang_Type_getNullability(
      T,
    );
  }

  late final _clang_Type_getNullabilityPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXType)>>(
          'clang_Type_getNullability');
  late final _clang_Type_getNullability =
      _clang_Type_getNullabilityPtr.asFunction<int Function(CXType)>();

  /// Return the alignment of a type in bytes as per C++[expr.alignof]
  /// standard.
  ///
  /// If the type declaration is invalid, CXTypeLayoutError_Invalid is returned.
  /// If the type declaration is an incomplete type, CXTypeLayoutError_Incomplete
  /// is returned.
  /// If the type declaration is a dependent type, CXTypeLayoutError_Dependent is
  /// returned.
  /// If the type declaration is not a constant size type,
  /// CXTypeLayoutError_NotConstantSize is returned.
  int clang_Type_getAlignOf(
    CXType T,
  ) {
    return _clang_Type_getAlignOf(
      T,
    );
  }

  late final _clang_Type_getAlignOfPtr =
      _lookup<ffi.NativeFunction<ffi.LongLong Function(CXType)>>(
          'clang_Type_getAlignOf');
  late final _clang_Type_getAlignOf =
      _clang_Type_getAlignOfPtr.asFunction<int Function(CXType)>();

  /// Return the type that was modified by this attributed type.
  ///
  /// If the type is not an attributed type, an invalid type is returned.
  CXType clang_Type_getModifiedType(
    CXType T,
  ) {
    return _clang_Type_getModifiedType(
      T,
    );
  }

  late final _clang_Type_getModifiedTypePtr =
      _lookup<ffi.NativeFunction<CXType Function(CXType)>>(
          'clang_Type_getModifiedType');
  late final _clang_Type_getModifiedType =
      _clang_Type_getModifiedTypePtr.asFunction<CXType Function(CXType)>();

  /// Determine whether the given cursor represents an anonymous
  /// tag or namespace
  int clang_Cursor_isAnonymous(
    CXCursor C,
  ) {
    return _clang_Cursor_isAnonymous(
      C,
    );
  }

  late final _clang_Cursor_isAnonymousPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_Cursor_isAnonymous');
  late final _clang_Cursor_isAnonymous =
      _clang_Cursor_isAnonymousPtr.asFunction<int Function(CXCursor)>();

  /// Determine whether the given cursor represents an anonymous record
  /// declaration.
  int clang_Cursor_isAnonymousRecordDecl(
    CXCursor C,
  ) {
    return _clang_Cursor_isAnonymousRecordDecl(
      C,
    );
  }

  late final _clang_Cursor_isAnonymousRecordDeclPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_Cursor_isAnonymousRecordDecl');
  late final _clang_Cursor_isAnonymousRecordDecl =
      _clang_Cursor_isAnonymousRecordDeclPtr
          .asFunction<int Function(CXCursor)>();

  /// Returns the storage class for a function or variable declaration.
  ///
  /// If the passed in Cursor is not a function or variable declaration,
  /// CX_SC_Invalid is returned else the storage class.
  int clang_Cursor_getStorageClass(
    CXCursor arg0,
  ) {
    return _clang_Cursor_getStorageClass(
      arg0,
    );
  }

  late final _clang_Cursor_getStorageClassPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_Cursor_getStorageClass');
  late final _clang_Cursor_getStorageClass =
      _clang_Cursor_getStorageClassPtr.asFunction<int Function(CXCursor)>();

  /// Visit the children of a particular cursor.
  ///
  /// This function visits all the direct children of the given cursor,
  /// invoking the given \p visitor function with the cursors of each
  /// visited child. The traversal may be recursive, if the visitor returns
  /// \c CXChildVisit_Recurse. The traversal may also be ended prematurely, if
  /// the visitor returns \c CXChildVisit_Break.
  ///
  /// \param parent the cursor whose child may be visited. All kinds of
  /// cursors can be visited, including invalid cursors (which, by
  /// definition, have no children).
  ///
  /// \param visitor the visitor function that will be invoked for each
  /// child of \p parent.
  ///
  /// \param client_data pointer data supplied by the client, which will
  /// be passed to the visitor each time it is invoked.
  ///
  /// \returns a non-zero value if the traversal was terminated
  /// prematurely by the visitor returning \c CXChildVisit_Break.
  int clang_visitChildren(
    CXCursor parent,
    CXCursorVisitor visitor,
    CXClientData client_data,
  ) {
    return _clang_visitChildren(
      parent,
      visitor,
      client_data,
    );
  }

  late final _clang_visitChildrenPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              CXCursor, CXCursorVisitor, CXClientData)>>('clang_visitChildren');
  late final _clang_visitChildren = _clang_visitChildrenPtr
      .asFunction<int Function(CXCursor, CXCursorVisitor, CXClientData)>();

  /// Retrieve a Unified Symbol Resolution (USR) for the entity referenced
  /// by the given cursor.
  ///
  /// A Unified Symbol Resolution (USR) is a string that identifies a particular
  /// entity (function, class, variable, etc.) within a program. USRs can be
  /// compared across translation units to determine, e.g., when references in
  /// one translation refer to an entity defined in another translation unit.
  CXString clang_getCursorUSR(
    CXCursor arg0,
  ) {
    return _clang_getCursorUSR(
      arg0,
    );
  }

  late final _clang_getCursorUSRPtr =
      _lookup<ffi.NativeFunction<CXString Function(CXCursor)>>(
          'clang_getCursorUSR');
  late final _clang_getCursorUSR =
      _clang_getCursorUSRPtr.asFunction<CXString Function(CXCursor)>();

  /// Retrieve a name for the entity referenced by this cursor.
  CXString clang_getCursorSpelling(
    CXCursor arg0,
  ) {
    return _clang_getCursorSpelling(
      arg0,
    );
  }

  late final _clang_getCursorSpellingPtr =
      _lookup<ffi.NativeFunction<CXString Function(CXCursor)>>(
          'clang_getCursorSpelling');
  late final _clang_getCursorSpelling =
      _clang_getCursorSpellingPtr.asFunction<CXString Function(CXCursor)>();

  /// For a cursor that is either a reference to or a declaration
  /// of some entity, retrieve a cursor that describes the definition of
  /// that entity.
  ///
  /// Some entities can be declared multiple times within a translation
  /// unit, but only one of those declarations can also be a
  /// definition. For example, given:
  ///
  /// \code
  /// int f(int, int);
  /// int g(int x, int y) { return f(x, y); }
  /// int f(int a, int b) { return a + b; }
  /// int f(int, int);
  /// \endcode
  ///
  /// there are three declarations of the function "f", but only the
  /// second one is a definition. The clang_getCursorDefinition()
  /// function will take any cursor pointing to a declaration of "f"
  /// (the first or fourth lines of the example) or a cursor referenced
  /// that uses "f" (the call to "f' inside "g") and will return a
  /// declaration cursor pointing to the definition (the second "f"
  /// declaration).
  ///
  /// If given a cursor for which there is no corresponding definition,
  /// e.g., because there is no definition of that entity within this
  /// translation unit, returns a NULL cursor.
  CXCursor clang_getCursorDefinition(
    CXCursor arg0,
  ) {
    return _clang_getCursorDefinition(
      arg0,
    );
  }

  late final _clang_getCursorDefinitionPtr =
      _lookup<ffi.NativeFunction<CXCursor Function(CXCursor)>>(
          'clang_getCursorDefinition');
  late final _clang_getCursorDefinition =
      _clang_getCursorDefinitionPtr.asFunction<CXCursor Function(CXCursor)>();

  /// Given a cursor that represents a property declaration, return the
  /// associated property attributes. The bits are formed from
  /// \c CXObjCPropertyAttrKind.
  ///
  /// \param reserved Reserved for future use, pass 0.
  int clang_Cursor_getObjCPropertyAttributes(
    CXCursor C,
    int reserved,
  ) {
    return _clang_Cursor_getObjCPropertyAttributes(
      C,
      reserved,
    );
  }

  late final _clang_Cursor_getObjCPropertyAttributesPtr = _lookup<
          ffi
          .NativeFunction<ffi.UnsignedInt Function(CXCursor, ffi.UnsignedInt)>>(
      'clang_Cursor_getObjCPropertyAttributes');
  late final _clang_Cursor_getObjCPropertyAttributes =
      _clang_Cursor_getObjCPropertyAttributesPtr
          .asFunction<int Function(CXCursor, int)>();

  /// Given a cursor that represents a property declaration, return the
  /// name of the method that implements the getter.
  CXString clang_Cursor_getObjCPropertyGetterName(
    CXCursor C,
  ) {
    return _clang_Cursor_getObjCPropertyGetterName(
      C,
    );
  }

  late final _clang_Cursor_getObjCPropertyGetterNamePtr =
      _lookup<ffi.NativeFunction<CXString Function(CXCursor)>>(
          'clang_Cursor_getObjCPropertyGetterName');
  late final _clang_Cursor_getObjCPropertyGetterName =
      _clang_Cursor_getObjCPropertyGetterNamePtr
          .asFunction<CXString Function(CXCursor)>();

  /// Given a cursor that represents a property declaration, return the
  /// name of the method that implements the setter, if any.
  CXString clang_Cursor_getObjCPropertySetterName(
    CXCursor C,
  ) {
    return _clang_Cursor_getObjCPropertySetterName(
      C,
    );
  }

  late final _clang_Cursor_getObjCPropertySetterNamePtr =
      _lookup<ffi.NativeFunction<CXString Function(CXCursor)>>(
          'clang_Cursor_getObjCPropertySetterName');
  late final _clang_Cursor_getObjCPropertySetterName =
      _clang_Cursor_getObjCPropertySetterNamePtr
          .asFunction<CXString Function(CXCursor)>();

  /// Given a cursor that represents an Objective-C method or property
  /// declaration, return non-zero if the declaration was affected by "\@optional".
  /// Returns zero if the cursor is not such a declaration or it is "\@required".
  int clang_Cursor_isObjCOptional(
    CXCursor C,
  ) {
    return _clang_Cursor_isObjCOptional(
      C,
    );
  }

  late final _clang_Cursor_isObjCOptionalPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXCursor)>>(
          'clang_Cursor_isObjCOptional');
  late final _clang_Cursor_isObjCOptional =
      _clang_Cursor_isObjCOptionalPtr.asFunction<int Function(CXCursor)>();

  /// Given a cursor that represents a declaration, return the associated
  /// comment's source range.  The range may include multiple consecutive comments
  /// with whitespace in between.
  CXSourceRange clang_Cursor_getCommentRange(
    CXCursor C,
  ) {
    return _clang_Cursor_getCommentRange(
      C,
    );
  }

  late final _clang_Cursor_getCommentRangePtr =
      _lookup<ffi.NativeFunction<CXSourceRange Function(CXCursor)>>(
          'clang_Cursor_getCommentRange');
  late final _clang_Cursor_getCommentRange = _clang_Cursor_getCommentRangePtr
      .asFunction<CXSourceRange Function(CXCursor)>();

  /// Given a cursor that represents a declaration, return the associated
  /// comment text, including comment markers.
  CXString clang_Cursor_getRawCommentText(
    CXCursor C,
  ) {
    return _clang_Cursor_getRawCommentText(
      C,
    );
  }

  late final _clang_Cursor_getRawCommentTextPtr =
      _lookup<ffi.NativeFunction<CXString Function(CXCursor)>>(
          'clang_Cursor_getRawCommentText');
  late final _clang_Cursor_getRawCommentText =
      _clang_Cursor_getRawCommentTextPtr
          .asFunction<CXString Function(CXCursor)>();

  /// Given a cursor that represents a documentable entity (e.g.,
  /// declaration), return the associated \paragraph; otherwise return the
  /// first paragraph.
  CXString clang_Cursor_getBriefCommentText(
    CXCursor C,
  ) {
    return _clang_Cursor_getBriefCommentText(
      C,
    );
  }

  late final _clang_Cursor_getBriefCommentTextPtr =
      _lookup<ffi.NativeFunction<CXString Function(CXCursor)>>(
          'clang_Cursor_getBriefCommentText');
  late final _clang_Cursor_getBriefCommentText =
      _clang_Cursor_getBriefCommentTextPtr
          .asFunction<CXString Function(CXCursor)>();

  /// \defgroup CINDEX_DEBUG Debugging facilities
  ///
  /// These routines are used for testing and debugging, only, and should not
  /// be relied upon.
  ///
  /// @{
  CXString clang_getCursorKindSpelling(
    int Kind,
  ) {
    return _clang_getCursorKindSpelling(
      Kind,
    );
  }

  late final _clang_getCursorKindSpellingPtr =
      _lookup<ffi.NativeFunction<CXString Function(ffi.UnsignedInt)>>(
          'clang_getCursorKindSpelling');
  late final _clang_getCursorKindSpelling =
      _clang_getCursorKindSpellingPtr.asFunction<CXString Function(int)>();

  /// Return a version string, suitable for showing to a user, but not
  /// intended to be parsed (the format is not guaranteed to be stable).
  CXString clang_getClangVersion() {
    return _clang_getClangVersion();
  }

  late final _clang_getClangVersionPtr =
      _lookup<ffi.NativeFunction<CXString Function()>>('clang_getClangVersion');
  late final _clang_getClangVersion =
      _clang_getClangVersionPtr.asFunction<CXString Function()>();

  /// If cursor is a statement declaration tries to evaluate the
  /// statement and if its variable, tries to evaluate its initializer,
  /// into its corresponding type.
  CXEvalResult clang_Cursor_Evaluate(
    CXCursor C,
  ) {
    return _clang_Cursor_Evaluate(
      C,
    );
  }

  late final _clang_Cursor_EvaluatePtr =
      _lookup<ffi.NativeFunction<CXEvalResult Function(CXCursor)>>(
          'clang_Cursor_Evaluate');
  late final _clang_Cursor_Evaluate =
      _clang_Cursor_EvaluatePtr.asFunction<CXEvalResult Function(CXCursor)>();

  /// Returns the kind of the evaluated result.
  int clang_EvalResult_getKind(
    CXEvalResult E,
  ) {
    return _clang_EvalResult_getKind(
      E,
    );
  }

  late final _clang_EvalResult_getKindPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(CXEvalResult)>>(
          'clang_EvalResult_getKind');
  late final _clang_EvalResult_getKind =
      _clang_EvalResult_getKindPtr.asFunction<int Function(CXEvalResult)>();

  /// Returns the evaluation result as integer if the
  /// kind is Int.
  int clang_EvalResult_getAsInt(
    CXEvalResult E,
  ) {
    return _clang_EvalResult_getAsInt(
      E,
    );
  }

  late final _clang_EvalResult_getAsIntPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(CXEvalResult)>>(
          'clang_EvalResult_getAsInt');
  late final _clang_EvalResult_getAsInt =
      _clang_EvalResult_getAsIntPtr.asFunction<int Function(CXEvalResult)>();

  /// Returns the evaluation result as a long long integer if the
  /// kind is Int. This prevents overflows that may happen if the result is
  /// returned with clang_EvalResult_getAsInt.
  int clang_EvalResult_getAsLongLong(
    CXEvalResult E,
  ) {
    return _clang_EvalResult_getAsLongLong(
      E,
    );
  }

  late final _clang_EvalResult_getAsLongLongPtr =
      _lookup<ffi.NativeFunction<ffi.LongLong Function(CXEvalResult)>>(
          'clang_EvalResult_getAsLongLong');
  late final _clang_EvalResult_getAsLongLong =
      _clang_EvalResult_getAsLongLongPtr
          .asFunction<int Function(CXEvalResult)>();

  /// Returns the evaluation result as double if the
  /// kind is double.
  double clang_EvalResult_getAsDouble(
    CXEvalResult E,
  ) {
    return _clang_EvalResult_getAsDouble(
      E,
    );
  }

  late final _clang_EvalResult_getAsDoublePtr =
      _lookup<ffi.NativeFunction<ffi.Double Function(CXEvalResult)>>(
          'clang_EvalResult_getAsDouble');
  late final _clang_EvalResult_getAsDouble = _clang_EvalResult_getAsDoublePtr
      .asFunction<double Function(CXEvalResult)>();

  /// Returns the evaluation result as a constant string if the
  /// kind is other than Int or float. User must not free this pointer,
  /// instead call clang_EvalResult_dispose on the CXEvalResult returned
  /// by clang_Cursor_Evaluate.
  ffi.Pointer<ffi.Char> clang_EvalResult_getAsStr(
    CXEvalResult E,
  ) {
    return _clang_EvalResult_getAsStr(
      E,
    );
  }

  late final _clang_EvalResult_getAsStrPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(CXEvalResult)>>(
          'clang_EvalResult_getAsStr');
  late final _clang_EvalResult_getAsStr = _clang_EvalResult_getAsStrPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(CXEvalResult)>();

  /// Disposes the created Eval memory.
  void clang_EvalResult_dispose(
    CXEvalResult E,
  ) {
    return _clang_EvalResult_dispose(
      E,
    );
  }

  late final _clang_EvalResult_disposePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(CXEvalResult)>>(
          'clang_EvalResult_dispose');
  late final _clang_EvalResult_dispose =
      _clang_EvalResult_disposePtr.asFunction<void Function(CXEvalResult)>();
}

/// A character string.
///
/// The \c CXString type is used to return strings from the interface when
/// the ownership of that string might differ from one call to the next.
/// Use \c clang_getCString() to retrieve the string data and, once finished
/// with the string data, call \c clang_disposeString() to free the string.
final class CXString extends ffi.Struct {
  external ffi.Pointer<ffi.Void> data;

  @ffi.UnsignedInt()
  external int private_flags;
}

final class CXTranslationUnitImpl extends ffi.Opaque {}

/// Provides the contents of a file that has not yet been saved to disk.
///
/// Each CXUnsavedFile instance provides the name of a file on the
/// system along with the current contents of that file that have not
/// yet been saved to disk.
final class CXUnsavedFile extends ffi.Struct {
  /// The file whose contents have not yet been saved.
  ///
  /// This file must already exist in the file system.
  external ffi.Pointer<ffi.Char> Filename;

  /// A buffer containing the unsaved contents of this file.
  external ffi.Pointer<ffi.Char> Contents;

  /// The length of the unsaved contents of this buffer.
  @ffi.UnsignedLong()
  external int Length;
}

/// An "index" that consists of a set of translation units that would
/// typically be linked together into an executable or library.
typedef CXIndex = ffi.Pointer<ffi.Void>;

/// A particular source file that is part of a translation unit.
typedef CXFile = ffi.Pointer<ffi.Void>;

/// Identifies a specific source location within a translation
/// unit.
///
/// Use clang_getExpansionLocation() or clang_getSpellingLocation()
/// to map a source location to a particular file, line, and column.
final class CXSourceLocation extends ffi.Struct {
  @ffi.Array.multi([2])
  external ffi.Array<ffi.Pointer<ffi.Void>> ptr_data;

  @ffi.UnsignedInt()
  external int int_data;
}

/// Identifies a half-open character range in the source code.
///
/// Use clang_getRangeStart() and clang_getRangeEnd() to retrieve the
/// starting and end locations from a source range, respectively.
final class CXSourceRange extends ffi.Struct {
  @ffi.Array.multi([2])
  external ffi.Array<ffi.Pointer<ffi.Void>> ptr_data;

  @ffi.UnsignedInt()
  external int begin_int_data;

  @ffi.UnsignedInt()
  external int end_int_data;
}

/// A single translation unit, which resides in an index.
typedef CXTranslationUnit = ffi.Pointer<CXTranslationUnitImpl>;

/// A single diagnostic, containing the diagnostic's severity,
/// location, text, source ranges, and fix-it hints.
typedef CXDiagnostic = ffi.Pointer<ffi.Void>;

/// Options to control the display of diagnostics.
///
/// The values in this enum are meant to be combined to customize the
/// behavior of \c clang_formatDiagnostic().
sealed class CXDiagnosticDisplayOptions {
  /// Display the source-location information where the
  /// diagnostic was located.
  ///
  /// When set, diagnostics will be prefixed by the file, line, and
  /// (optionally) column to which the diagnostic refers. For example,
  ///
  /// \code
  /// test.c:28: warning: extra tokens at end of #endif directive
  /// \endcode
  ///
  /// This option corresponds to the clang flag \c -fshow-source-location.
  static const CXDiagnostic_DisplaySourceLocation = 1;

  /// If displaying the source-location information of the
  /// diagnostic, also include the column number.
  ///
  /// This option corresponds to the clang flag \c -fshow-column.
  static const CXDiagnostic_DisplayColumn = 2;

  /// If displaying the source-location information of the
  /// diagnostic, also include information about source ranges in a
  /// machine-parsable format.
  ///
  /// This option corresponds to the clang flag
  /// \c -fdiagnostics-print-source-range-info.
  static const CXDiagnostic_DisplaySourceRanges = 4;

  /// Display the option name associated with this diagnostic, if any.
  ///
  /// The option name displayed (e.g., -Wconversion) will be placed in brackets
  /// after the diagnostic text. This option corresponds to the clang flag
  /// \c -fdiagnostics-show-option.
  static const CXDiagnostic_DisplayOption = 8;

  /// Display the category number associated with this diagnostic, if any.
  ///
  /// The category number is displayed within brackets after the diagnostic text.
  /// This option corresponds to the clang flag
  /// \c -fdiagnostics-show-category=id.
  static const CXDiagnostic_DisplayCategoryId = 16;

  /// Display the category name associated with this diagnostic, if any.
  ///
  /// The category name is displayed within brackets after the diagnostic text.
  /// This option corresponds to the clang flag
  /// \c -fdiagnostics-show-category=name.
  static const CXDiagnostic_DisplayCategoryName = 32;
}

/// Describes the severity of a particular diagnostic.
sealed class CXDiagnosticSeverity {
  /// A diagnostic that has been suppressed, e.g., by a command-line
  /// option.
  static const CXDiagnostic_Ignored = 0;

  /// This diagnostic is a note that should be attached to the
  /// previous (non-note) diagnostic.
  static const CXDiagnostic_Note = 1;

  /// This diagnostic indicates suspicious code that may not be
  /// wrong.
  static const CXDiagnostic_Warning = 2;

  /// This diagnostic indicates that the code is ill-formed.
  static const CXDiagnostic_Error = 3;

  /// This diagnostic indicates that the code is ill-formed such
  /// that future parser recovery is unlikely to produce useful
  /// results.
  static const CXDiagnostic_Fatal = 4;
}

/// Flags that control the creation of translation units.
///
/// The enumerators in this enumeration type are meant to be bitwise
/// ORed together to specify which options should be used when
/// constructing the translation unit.
sealed class CXTranslationUnit_Flags {
  /// Used to indicate that no special translation-unit options are
  /// needed.
  static const CXTranslationUnit_None = 0;

  /// Used to indicate that the parser should construct a "detailed"
  /// preprocessing record, including all macro definitions and instantiations.
  ///
  /// Constructing a detailed preprocessing record requires more memory
  /// and time to parse, since the information contained in the record
  /// is usually not retained. However, it can be useful for
  /// applications that require more detailed information about the
  /// behavior of the preprocessor.
  static const CXTranslationUnit_DetailedPreprocessingRecord = 1;

  /// Used to indicate that the translation unit is incomplete.
  ///
  /// When a translation unit is considered "incomplete", semantic
  /// analysis that is typically performed at the end of the
  /// translation unit will be suppressed. For example, this suppresses
  /// the completion of tentative declarations in C and of
  /// instantiation of implicitly-instantiation function templates in
  /// C++. This option is typically used when parsing a header with the
  /// intent of producing a precompiled header.
  static const CXTranslationUnit_Incomplete = 2;

  /// Used to indicate that the translation unit should be built with an
  /// implicit precompiled header for the preamble.
  ///
  /// An implicit precompiled header is used as an optimization when a
  /// particular translation unit is likely to be reparsed many times
  /// when the sources aren't changing that often. In this case, an
  /// implicit precompiled header will be built containing all of the
  /// initial includes at the top of the main file (what we refer to as
  /// the "preamble" of the file). In subsequent parses, if the
  /// preamble or the files in it have not changed, \c
  /// clang_reparseTranslationUnit() will re-use the implicit
  /// precompiled header to improve parsing performance.
  static const CXTranslationUnit_PrecompiledPreamble = 4;

  /// Used to indicate that the translation unit should cache some
  /// code-completion results with each reparse of the source file.
  ///
  /// Caching of code-completion results is a performance optimization that
  /// introduces some overhead to reparsing but improves the performance of
  /// code-completion operations.
  static const CXTranslationUnit_CacheCompletionResults = 8;

  /// Used to indicate that the translation unit will be serialized with
  /// \c clang_saveTranslationUnit.
  ///
  /// This option is typically used when parsing a header with the intent of
  /// producing a precompiled header.
  static const CXTranslationUnit_ForSerialization = 16;

  /// DEPRECATED: Enabled chained precompiled preambles in C++.
  ///
  /// Note: this is a *temporary* option that is available only while
  /// we are testing C++ precompiled preamble support. It is deprecated.
  static const CXTranslationUnit_CXXChainedPCH = 32;

  /// Used to indicate that function/method bodies should be skipped while
  /// parsing.
  ///
  /// This option can be used to search for declarations/definitions while
  /// ignoring the usages.
  static const CXTranslationUnit_SkipFunctionBodies = 64;

  /// Used to indicate that brief documentation comments should be
  /// included into the set of code completions returned from this translation
  /// unit.
  static const CXTranslationUnit_IncludeBriefCommentsInCodeCompletion = 128;

  /// Used to indicate that the precompiled preamble should be created on
  /// the first parse. Otherwise it will be created on the first reparse. This
  /// trades runtime on the first parse (serializing the preamble takes time) for
  /// reduced runtime on the second parse (can now reuse the preamble).
  static const CXTranslationUnit_CreatePreambleOnFirstParse = 256;

  /// Do not stop processing when fatal errors are encountered.
  ///
  /// When fatal errors are encountered while parsing a translation unit,
  /// semantic analysis is typically stopped early when compiling code. A common
  /// source for fatal errors are unresolvable include files. For the
  /// purposes of an IDE, this is undesirable behavior and as much information
  /// as possible should be reported. Use this flag to enable this behavior.
  static const CXTranslationUnit_KeepGoing = 512;

  /// Sets the preprocessor in a mode for parsing a single file only.
  static const CXTranslationUnit_SingleFileParse = 1024;

  /// Used in combination with CXTranslationUnit_SkipFunctionBodies to
  /// constrain the skipping of function bodies to the preamble.
  ///
  /// The function bodies of the main file are not skipped.
  static const CXTranslationUnit_LimitSkipFunctionBodiesToPreamble = 2048;

  /// Used to indicate that attributed types should be included in CXType.
  static const CXTranslationUnit_IncludeAttributedTypes = 4096;

  /// Used to indicate that implicit attributes should be visited.
  static const CXTranslationUnit_VisitImplicitAttributes = 8192;

  /// Used to indicate that non-errors from included files should be ignored.
  ///
  /// If set, clang_getDiagnosticSetFromTU() will not report e.g. warnings from
  /// included files anymore. This speeds up clang_getDiagnosticSetFromTU() for
  /// the case where these warnings are not of interest, as for an IDE for
  /// example, which typically shows only the diagnostics in the main file.
  static const CXTranslationUnit_IgnoreNonErrorsFromIncludedFiles = 16384;

  /// Tells the preprocessor not to skip excluded conditional blocks.
  static const CXTranslationUnit_RetainExcludedConditionalBlocks = 32768;
}

/// Describes the kind of entity that a cursor refers to.
sealed class CXCursorKind {
  /// A declaration whose specific kind is not exposed via this
  /// interface.
  ///
  /// Unexposed declarations have the same operations as any other kind
  /// of declaration; one can extract their location information,
  /// spelling, find their definitions, etc. However, the specific kind
  /// of the declaration is not reported.
  static const CXCursor_UnexposedDecl = 1;

  /// A C or C++ struct.
  static const CXCursor_StructDecl = 2;

  /// A C or C++ union.
  static const CXCursor_UnionDecl = 3;

  /// A C++ class.
  static const CXCursor_ClassDecl = 4;

  /// An enumeration.
  static const CXCursor_EnumDecl = 5;

  /// A field (in C) or non-static data member (in C++) in a
  /// struct, union, or C++ class.
  static const CXCursor_FieldDecl = 6;

  /// An enumerator constant.
  static const CXCursor_EnumConstantDecl = 7;

  /// A function.
  static const CXCursor_FunctionDecl = 8;

  /// A variable.
  static const CXCursor_VarDecl = 9;

  /// A function or method parameter.
  static const CXCursor_ParmDecl = 10;

  /// An Objective-C \@interface.
  static const CXCursor_ObjCInterfaceDecl = 11;

  /// An Objective-C \@interface for a category.
  static const CXCursor_ObjCCategoryDecl = 12;

  /// An Objective-C \@protocol declaration.
  static const CXCursor_ObjCProtocolDecl = 13;

  /// An Objective-C \@property declaration.
  static const CXCursor_ObjCPropertyDecl = 14;

  /// An Objective-C instance variable.
  static const CXCursor_ObjCIvarDecl = 15;

  /// An Objective-C instance method.
  static const CXCursor_ObjCInstanceMethodDecl = 16;

  /// An Objective-C class method.
  static const CXCursor_ObjCClassMethodDecl = 17;

  /// An Objective-C \@implementation.
  static const CXCursor_ObjCImplementationDecl = 18;

  /// An Objective-C \@implementation for a category.
  static const CXCursor_ObjCCategoryImplDecl = 19;

  /// A typedef.
  static const CXCursor_TypedefDecl = 20;

  /// A C++ class method.
  static const CXCursor_CXXMethod = 21;

  /// A C++ namespace.
  static const CXCursor_Namespace = 22;

  /// A linkage specification, e.g. 'extern "C"'.
  static const CXCursor_LinkageSpec = 23;

  /// A C++ constructor.
  static const CXCursor_Constructor = 24;

  /// A C++ destructor.
  static const CXCursor_Destructor = 25;

  /// A C++ conversion function.
  static const CXCursor_ConversionFunction = 26;

  /// A C++ template type parameter.
  static const CXCursor_TemplateTypeParameter = 27;

  /// A C++ non-type template parameter.
  static const CXCursor_NonTypeTemplateParameter = 28;

  /// A C++ template template parameter.
  static const CXCursor_TemplateTemplateParameter = 29;

  /// A C++ function template.
  static const CXCursor_FunctionTemplate = 30;

  /// A C++ class template.
  static const CXCursor_ClassTemplate = 31;

  /// A C++ class template partial specialization.
  static const CXCursor_ClassTemplatePartialSpecialization = 32;

  /// A C++ namespace alias declaration.
  static const CXCursor_NamespaceAlias = 33;

  /// A C++ using directive.
  static const CXCursor_UsingDirective = 34;

  /// A C++ using declaration.
  static const CXCursor_UsingDeclaration = 35;

  /// A C++ alias declaration
  static const CXCursor_TypeAliasDecl = 36;

  /// An Objective-C \@synthesize definition.
  static const CXCursor_ObjCSynthesizeDecl = 37;

  /// An Objective-C \@dynamic definition.
  static const CXCursor_ObjCDynamicDecl = 38;

  /// An access specifier.
  static const CXCursor_CXXAccessSpecifier = 39;
  static const CXCursor_FirstDecl = 1;
  static const CXCursor_LastDecl = 39;
  static const CXCursor_FirstRef = 40;
  static const CXCursor_ObjCSuperClassRef = 40;
  static const CXCursor_ObjCProtocolRef = 41;
  static const CXCursor_ObjCClassRef = 42;

  /// A reference to a type declaration.
  ///
  /// A type reference occurs anywhere where a type is named but not
  /// declared. For example, given:
  ///
  /// \code
  /// typedef unsigned size_type;
  /// size_type size;
  /// \endcode
  ///
  /// The typedef is a declaration of size_type (CXCursor_TypedefDecl),
  /// while the type of the variable "size" is referenced. The cursor
  /// referenced by the type of size is the typedef for size_type.
  static const CXCursor_TypeRef = 43;
  static const CXCursor_CXXBaseSpecifier = 44;

  /// A reference to a class template, function template, template
  /// template parameter, or class template partial specialization.
  static const CXCursor_TemplateRef = 45;

  /// A reference to a namespace or namespace alias.
  static const CXCursor_NamespaceRef = 46;

  /// A reference to a member of a struct, union, or class that occurs in
  /// some non-expression context, e.g., a designated initializer.
  static const CXCursor_MemberRef = 47;

  /// A reference to a labeled statement.
  ///
  /// This cursor kind is used to describe the jump to "start_over" in the
  /// goto statement in the following example:
  ///
  /// \code
  /// start_over:
  /// ++counter;
  ///
  /// goto start_over;
  /// \endcode
  ///
  /// A label reference cursor refers to a label statement.
  static const CXCursor_LabelRef = 48;

  /// A reference to a set of overloaded functions or function templates
  /// that has not yet been resolved to a specific function or function template.
  ///
  /// An overloaded declaration reference cursor occurs in C++ templates where
  /// a dependent name refers to a function. For example:
  ///
  /// \code
  /// template<typename T> void swap(T&, T&);
  ///
  /// struct X { ... };
  /// void swap(X&, X&);
  ///
  /// template<typename T>
  /// void reverse(T* first, T* last) {
  /// while (first < last - 1) {
  /// swap(*first, *--last);
  /// ++first;
  /// }
  /// }
  ///
  /// struct Y { };
  /// void swap(Y&, Y&);
  /// \endcode
  ///
  /// Here, the identifier "swap" is associated with an overloaded declaration
  /// reference. In the template definition, "swap" refers to either of the two
  /// "swap" functions declared above, so both results will be available. At
  /// instantiation time, "swap" may also refer to other functions found via
  /// argument-dependent lookup (e.g., the "swap" function at the end of the
  /// example).
  ///
  /// The functions \c clang_getNumOverloadedDecls() and
  /// \c clang_getOverloadedDecl() can be used to retrieve the definitions
  /// referenced by this cursor.
  static const CXCursor_OverloadedDeclRef = 49;

  /// A reference to a variable that occurs in some non-expression
  /// context, e.g., a C++ lambda capture list.
  static const CXCursor_VariableRef = 50;
  static const CXCursor_LastRef = 50;
  static const CXCursor_FirstInvalid = 70;
  static const CXCursor_InvalidFile = 70;
  static const CXCursor_NoDeclFound = 71;
  static const CXCursor_NotImplemented = 72;
  static const CXCursor_InvalidCode = 73;
  static const CXCursor_LastInvalid = 73;
  static const CXCursor_FirstExpr = 100;

  /// An expression whose specific kind is not exposed via this
  /// interface.
  ///
  /// Unexposed expressions have the same operations as any other kind
  /// of expression; one can extract their location information,
  /// spelling, children, etc. However, the specific kind of the
  /// expression is not reported.
  static const CXCursor_UnexposedExpr = 100;

  /// An expression that refers to some value declaration, such
  /// as a function, variable, or enumerator.
  static const CXCursor_DeclRefExpr = 101;

  /// An expression that refers to a member of a struct, union,
  /// class, Objective-C class, etc.
  static const CXCursor_MemberRefExpr = 102;

  /// An expression that calls a function.
  static const CXCursor_CallExpr = 103;

  /// An expression that sends a message to an Objective-C
  /// object or class.
  static const CXCursor_ObjCMessageExpr = 104;

  /// An expression that represents a block literal.
  static const CXCursor_BlockExpr = 105;

  /// An integer literal.
  static const CXCursor_IntegerLiteral = 106;

  /// A floating point number literal.
  static const CXCursor_FloatingLiteral = 107;

  /// An imaginary number literal.
  static const CXCursor_ImaginaryLiteral = 108;

  /// A string literal.
  static const CXCursor_StringLiteral = 109;

  /// A character literal.
  static const CXCursor_CharacterLiteral = 110;

  /// A parenthesized expression, e.g. "(1)".
  ///
  /// This AST node is only formed if full location information is requested.
  static const CXCursor_ParenExpr = 111;

  /// This represents the unary-expression's (except sizeof and
  /// alignof).
  static const CXCursor_UnaryOperator = 112;

  /// [C99 6.5.2.1] Array Subscripting.
  static const CXCursor_ArraySubscriptExpr = 113;

  /// A builtin binary operation expression such as "x + y" or
  /// "x <= y".
  static const CXCursor_BinaryOperator = 114;

  /// Compound assignment such as "+=".
  static const CXCursor_CompoundAssignOperator = 115;

  /// The ?: ternary operator.
  static const CXCursor_ConditionalOperator = 116;

  /// An explicit cast in C (C99 6.5.4) or a C-style cast in C++
  /// (C++ [expr.cast]), which uses the syntax (Type)expr.
  ///
  /// For example: (int)f.
  static const CXCursor_CStyleCastExpr = 117;

  /// [C99 6.5.2.5]
  static const CXCursor_CompoundLiteralExpr = 118;

  /// Describes an C or C++ initializer list.
  static const CXCursor_InitListExpr = 119;

  /// The GNU address of label extension, representing &&label.
  static const CXCursor_AddrLabelExpr = 120;

  /// This is the GNU Statement Expression extension: ({int X=4; X;})
  static const CXCursor_StmtExpr = 121;

  /// Represents a C11 generic selection.
  static const CXCursor_GenericSelectionExpr = 122;

  /// Implements the GNU __null extension, which is a name for a null
  /// pointer constant that has integral type (e.g., int or long) and is the same
  /// size and alignment as a pointer.
  ///
  /// The __null extension is typically only used by system headers, which define
  /// NULL as __null in C++ rather than using 0 (which is an integer that may not
  /// match the size of a pointer).
  static const CXCursor_GNUNullExpr = 123;

  /// C++'s static_cast<> expression.
  static const CXCursor_CXXStaticCastExpr = 124;

  /// C++'s dynamic_cast<> expression.
  static const CXCursor_CXXDynamicCastExpr = 125;

  /// C++'s reinterpret_cast<> expression.
  static const CXCursor_CXXReinterpretCastExpr = 126;

  /// C++'s const_cast<> expression.
  static const CXCursor_CXXConstCastExpr = 127;

  /// Represents an explicit C++ type conversion that uses "functional"
  /// notion (C++ [expr.type.conv]).
  ///
  /// Example:
  /// \code
  /// x = int(0.5);
  /// \endcode
  static const CXCursor_CXXFunctionalCastExpr = 128;

  /// A C++ typeid expression (C++ [expr.typeid]).
  static const CXCursor_CXXTypeidExpr = 129;

  /// [C++ 2.13.5] C++ Boolean Literal.
  static const CXCursor_CXXBoolLiteralExpr = 130;

  /// [C++0x 2.14.7] C++ Pointer Literal.
  static const CXCursor_CXXNullPtrLiteralExpr = 131;

  /// Represents the "this" expression in C++
  static const CXCursor_CXXThisExpr = 132;

  /// [C++ 15] C++ Throw Expression.
  ///
  /// This handles 'throw' and 'throw' assignment-expression. When
  /// assignment-expression isn't present, Op will be null.
  static const CXCursor_CXXThrowExpr = 133;

  /// A new expression for memory allocation and constructor calls, e.g:
  /// "new CXXNewExpr(foo)".
  static const CXCursor_CXXNewExpr = 134;

  /// A delete expression for memory deallocation and destructor calls,
  /// e.g. "delete[] pArray".
  static const CXCursor_CXXDeleteExpr = 135;

  /// A unary expression. (noexcept, sizeof, or other traits)
  static const CXCursor_UnaryExpr = 136;

  /// An Objective-C string literal i.e. @"foo".
  static const CXCursor_ObjCStringLiteral = 137;

  /// An Objective-C \@encode expression.
  static const CXCursor_ObjCEncodeExpr = 138;

  /// An Objective-C \@selector expression.
  static const CXCursor_ObjCSelectorExpr = 139;

  /// An Objective-C \@protocol expression.
  static const CXCursor_ObjCProtocolExpr = 140;

  /// An Objective-C "bridged" cast expression, which casts between
  /// Objective-C pointers and C pointers, transferring ownership in the process.
  ///
  /// \code
  /// NSString *str = (__bridge_transfer NSString *)CFCreateString();
  /// \endcode
  static const CXCursor_ObjCBridgedCastExpr = 141;

  /// Represents a C++0x pack expansion that produces a sequence of
  /// expressions.
  ///
  /// A pack expansion expression contains a pattern (which itself is an
  /// expression) followed by an ellipsis. For example:
  ///
  /// \code
  /// template<typename F, typename ...Types>
  /// void forward(F f, Types &&...args) {
  /// f(static_cast<Types&&>(args)...);
  /// }
  /// \endcode
  static const CXCursor_PackExpansionExpr = 142;

  /// Represents an expression that computes the length of a parameter
  /// pack.
  ///
  /// \code
  /// template<typename ...Types>
  /// struct count {
  /// static const unsigned value = sizeof...(Types);
  /// };
  /// \endcode
  static const CXCursor_SizeOfPackExpr = 143;
  static const CXCursor_LambdaExpr = 144;

  /// Objective-c Boolean Literal.
  static const CXCursor_ObjCBoolLiteralExpr = 145;

  /// Represents the "self" expression in an Objective-C method.
  static const CXCursor_ObjCSelfExpr = 146;

  /// OpenMP 4.0 [2.4, Array Section].
  static const CXCursor_OMPArraySectionExpr = 147;

  /// Represents an @available(...) check.
  static const CXCursor_ObjCAvailabilityCheckExpr = 148;

  /// Fixed point literal
  static const CXCursor_FixedPointLiteral = 149;
  static const CXCursor_LastExpr = 149;
  static const CXCursor_FirstStmt = 200;

  /// A statement whose specific kind is not exposed via this
  /// interface.
  ///
  /// Unexposed statements have the same operations as any other kind of
  /// statement; one can extract their location information, spelling,
  /// children, etc. However, the specific kind of the statement is not
  /// reported.
  static const CXCursor_UnexposedStmt = 200;

  /// A labelled statement in a function.
  ///
  /// This cursor kind is used to describe the "start_over:" label statement in
  /// the following example:
  ///
  /// \code
  /// start_over:
  /// ++counter;
  /// \endcode
  static const CXCursor_LabelStmt = 201;

  /// A group of statements like { stmt stmt }.
  ///
  /// This cursor kind is used to describe compound statements, e.g. function
  /// bodies.
  static const CXCursor_CompoundStmt = 202;

  /// A case statement.
  static const CXCursor_CaseStmt = 203;

  /// A default statement.
  static const CXCursor_DefaultStmt = 204;

  /// An if statement
  static const CXCursor_IfStmt = 205;

  /// A switch statement.
  static const CXCursor_SwitchStmt = 206;

  /// A while statement.
  static const CXCursor_WhileStmt = 207;

  /// A do statement.
  static const CXCursor_DoStmt = 208;

  /// A for statement.
  static const CXCursor_ForStmt = 209;

  /// A goto statement.
  static const CXCursor_GotoStmt = 210;

  /// An indirect goto statement.
  static const CXCursor_IndirectGotoStmt = 211;

  /// A continue statement.
  static const CXCursor_ContinueStmt = 212;

  /// A break statement.
  static const CXCursor_BreakStmt = 213;

  /// A return statement.
  static const CXCursor_ReturnStmt = 214;

  /// A GCC inline assembly statement extension.
  static const CXCursor_GCCAsmStmt = 215;
  static const CXCursor_AsmStmt = 215;

  /// Objective-C's overall \@try-\@catch-\@finally statement.
  static const CXCursor_ObjCAtTryStmt = 216;

  /// Objective-C's \@catch statement.
  static const CXCursor_ObjCAtCatchStmt = 217;

  /// Objective-C's \@finally statement.
  static const CXCursor_ObjCAtFinallyStmt = 218;

  /// Objective-C's \@throw statement.
  static const CXCursor_ObjCAtThrowStmt = 219;

  /// Objective-C's \@synchronized statement.
  static const CXCursor_ObjCAtSynchronizedStmt = 220;

  /// Objective-C's autorelease pool statement.
  static const CXCursor_ObjCAutoreleasePoolStmt = 221;

  /// Objective-C's collection statement.
  static const CXCursor_ObjCForCollectionStmt = 222;

  /// C++'s catch statement.
  static const CXCursor_CXXCatchStmt = 223;

  /// C++'s try statement.
  static const CXCursor_CXXTryStmt = 224;

  /// C++'s for (* : *) statement.
  static const CXCursor_CXXForRangeStmt = 225;

  /// Windows Structured Exception Handling's try statement.
  static const CXCursor_SEHTryStmt = 226;

  /// Windows Structured Exception Handling's except statement.
  static const CXCursor_SEHExceptStmt = 227;

  /// Windows Structured Exception Handling's finally statement.
  static const CXCursor_SEHFinallyStmt = 228;

  /// A MS inline assembly statement extension.
  static const CXCursor_MSAsmStmt = 229;

  /// The null statement ";": C99 6.8.3p3.
  ///
  /// This cursor kind is used to describe the null statement.
  static const CXCursor_NullStmt = 230;

  /// Adaptor class for mixing declarations with statements and
  /// expressions.
  static const CXCursor_DeclStmt = 231;

  /// OpenMP parallel directive.
  static const CXCursor_OMPParallelDirective = 232;

  /// OpenMP SIMD directive.
  static const CXCursor_OMPSimdDirective = 233;

  /// OpenMP for directive.
  static const CXCursor_OMPForDirective = 234;

  /// OpenMP sections directive.
  static const CXCursor_OMPSectionsDirective = 235;

  /// OpenMP section directive.
  static const CXCursor_OMPSectionDirective = 236;

  /// OpenMP single directive.
  static const CXCursor_OMPSingleDirective = 237;

  /// OpenMP parallel for directive.
  static const CXCursor_OMPParallelForDirective = 238;

  /// OpenMP parallel sections directive.
  static const CXCursor_OMPParallelSectionsDirective = 239;

  /// OpenMP task directive.
  static const CXCursor_OMPTaskDirective = 240;

  /// OpenMP master directive.
  static const CXCursor_OMPMasterDirective = 241;

  /// OpenMP critical directive.
  static const CXCursor_OMPCriticalDirective = 242;

  /// OpenMP taskyield directive.
  static const CXCursor_OMPTaskyieldDirective = 243;

  /// OpenMP barrier directive.
  static const CXCursor_OMPBarrierDirective = 244;

  /// OpenMP taskwait directive.
  static const CXCursor_OMPTaskwaitDirective = 245;

  /// OpenMP flush directive.
  static const CXCursor_OMPFlushDirective = 246;

  /// Windows Structured Exception Handling's leave statement.
  static const CXCursor_SEHLeaveStmt = 247;

  /// OpenMP ordered directive.
  static const CXCursor_OMPOrderedDirective = 248;

  /// OpenMP atomic directive.
  static const CXCursor_OMPAtomicDirective = 249;

  /// OpenMP for SIMD directive.
  static const CXCursor_OMPForSimdDirective = 250;

  /// OpenMP parallel for SIMD directive.
  static const CXCursor_OMPParallelForSimdDirective = 251;

  /// OpenMP target directive.
  static const CXCursor_OMPTargetDirective = 252;

  /// OpenMP teams directive.
  static const CXCursor_OMPTeamsDirective = 253;

  /// OpenMP taskgroup directive.
  static const CXCursor_OMPTaskgroupDirective = 254;

  /// OpenMP cancellation point directive.
  static const CXCursor_OMPCancellationPointDirective = 255;

  /// OpenMP cancel directive.
  static const CXCursor_OMPCancelDirective = 256;

  /// OpenMP target data directive.
  static const CXCursor_OMPTargetDataDirective = 257;

  /// OpenMP taskloop directive.
  static const CXCursor_OMPTaskLoopDirective = 258;

  /// OpenMP taskloop simd directive.
  static const CXCursor_OMPTaskLoopSimdDirective = 259;

  /// OpenMP distribute directive.
  static const CXCursor_OMPDistributeDirective = 260;

  /// OpenMP target enter data directive.
  static const CXCursor_OMPTargetEnterDataDirective = 261;

  /// OpenMP target exit data directive.
  static const CXCursor_OMPTargetExitDataDirective = 262;

  /// OpenMP target parallel directive.
  static const CXCursor_OMPTargetParallelDirective = 263;

  /// OpenMP target parallel for directive.
  static const CXCursor_OMPTargetParallelForDirective = 264;

  /// OpenMP target update directive.
  static const CXCursor_OMPTargetUpdateDirective = 265;

  /// OpenMP distribute parallel for directive.
  static const CXCursor_OMPDistributeParallelForDirective = 266;

  /// OpenMP distribute parallel for simd directive.
  static const CXCursor_OMPDistributeParallelForSimdDirective = 267;

  /// OpenMP distribute simd directive.
  static const CXCursor_OMPDistributeSimdDirective = 268;

  /// OpenMP target parallel for simd directive.
  static const CXCursor_OMPTargetParallelForSimdDirective = 269;

  /// OpenMP target simd directive.
  static const CXCursor_OMPTargetSimdDirective = 270;

  /// OpenMP teams distribute directive.
  static const CXCursor_OMPTeamsDistributeDirective = 271;

  /// OpenMP teams distribute simd directive.
  static const CXCursor_OMPTeamsDistributeSimdDirective = 272;

  /// OpenMP teams distribute parallel for simd directive.
  static const CXCursor_OMPTeamsDistributeParallelForSimdDirective = 273;

  /// OpenMP teams distribute parallel for directive.
  static const CXCursor_OMPTeamsDistributeParallelForDirective = 274;

  /// OpenMP target teams directive.
  static const CXCursor_OMPTargetTeamsDirective = 275;

  /// OpenMP target teams distribute directive.
  static const CXCursor_OMPTargetTeamsDistributeDirective = 276;

  /// OpenMP target teams distribute parallel for directive.
  static const CXCursor_OMPTargetTeamsDistributeParallelForDirective = 277;

  /// OpenMP target teams distribute parallel for simd directive.
  static const CXCursor_OMPTargetTeamsDistributeParallelForSimdDirective = 278;

  /// OpenMP target teams distribute simd directive.
  static const CXCursor_OMPTargetTeamsDistributeSimdDirective = 279;

  /// C++2a std::bit_cast expression.
  static const CXCursor_BuiltinBitCastExpr = 280;

  /// OpenMP master taskloop directive.
  static const CXCursor_OMPMasterTaskLoopDirective = 281;

  /// OpenMP parallel master taskloop directive.
  static const CXCursor_OMPParallelMasterTaskLoopDirective = 282;

  /// OpenMP master taskloop simd directive.
  static const CXCursor_OMPMasterTaskLoopSimdDirective = 283;

  /// OpenMP parallel master taskloop simd directive.
  static const CXCursor_OMPParallelMasterTaskLoopSimdDirective = 284;

  /// OpenMP parallel master directive.
  static const CXCursor_OMPParallelMasterDirective = 285;
  static const CXCursor_LastStmt = 285;

  /// Cursor that represents the translation unit itself.
  ///
  /// The translation unit cursor exists primarily to act as the root
  /// cursor for traversing the contents of a translation unit.
  static const CXCursor_TranslationUnit = 300;
  static const CXCursor_FirstAttr = 400;

  /// An attribute whose specific kind is not exposed via this
  /// interface.
  static const CXCursor_UnexposedAttr = 400;
  static const CXCursor_IBActionAttr = 401;
  static const CXCursor_IBOutletAttr = 402;
  static const CXCursor_IBOutletCollectionAttr = 403;
  static const CXCursor_CXXFinalAttr = 404;
  static const CXCursor_CXXOverrideAttr = 405;
  static const CXCursor_AnnotateAttr = 406;
  static const CXCursor_AsmLabelAttr = 407;
  static const CXCursor_PackedAttr = 408;
  static const CXCursor_PureAttr = 409;
  static const CXCursor_ConstAttr = 410;
  static const CXCursor_NoDuplicateAttr = 411;
  static const CXCursor_CUDAConstantAttr = 412;
  static const CXCursor_CUDADeviceAttr = 413;
  static const CXCursor_CUDAGlobalAttr = 414;
  static const CXCursor_CUDAHostAttr = 415;
  static const CXCursor_CUDASharedAttr = 416;
  static const CXCursor_VisibilityAttr = 417;
  static const CXCursor_DLLExport = 418;
  static const CXCursor_DLLImport = 419;
  static const CXCursor_NSReturnsRetained = 420;
  static const CXCursor_NSReturnsNotRetained = 421;
  static const CXCursor_NSReturnsAutoreleased = 422;
  static const CXCursor_NSConsumesSelf = 423;
  static const CXCursor_NSConsumed = 424;
  static const CXCursor_ObjCException = 425;
  static const CXCursor_ObjCNSObject = 426;
  static const CXCursor_ObjCIndependentClass = 427;
  static const CXCursor_ObjCPreciseLifetime = 428;
  static const CXCursor_ObjCReturnsInnerPointer = 429;
  static const CXCursor_ObjCRequiresSuper = 430;
  static const CXCursor_ObjCRootClass = 431;
  static const CXCursor_ObjCSubclassingRestricted = 432;
  static const CXCursor_ObjCExplicitProtocolImpl = 433;
  static const CXCursor_ObjCDesignatedInitializer = 434;
  static const CXCursor_ObjCRuntimeVisible = 435;
  static const CXCursor_ObjCBoxable = 436;
  static const CXCursor_FlagEnum = 437;
  static const CXCursor_ConvergentAttr = 438;
  static const CXCursor_WarnUnusedAttr = 439;
  static const CXCursor_WarnUnusedResultAttr = 440;
  static const CXCursor_AlignedAttr = 441;
  static const CXCursor_LastAttr = 441;
  static const CXCursor_PreprocessingDirective = 500;
  static const CXCursor_MacroDefinition = 501;
  static const CXCursor_MacroExpansion = 502;
  static const CXCursor_MacroInstantiation = 502;
  static const CXCursor_InclusionDirective = 503;
  static const CXCursor_FirstPreprocessing = 500;
  static const CXCursor_LastPreprocessing = 503;

  /// A module import declaration.
  static const CXCursor_ModuleImportDecl = 600;
  static const CXCursor_TypeAliasTemplateDecl = 601;

  /// A static_assert or _Static_assert node
  static const CXCursor_StaticAssert = 602;

  /// a friend declaration.
  static const CXCursor_FriendDecl = 603;
  static const CXCursor_FirstExtraDecl = 600;
  static const CXCursor_LastExtraDecl = 603;

  /// A code completion overload candidate.
  static const CXCursor_OverloadCandidate = 700;
}

/// A cursor representing some element in the abstract syntax tree for
/// a translation unit.
///
/// The cursor abstraction unifies the different kinds of entities in a
/// program--declaration, statements, expressions, references to declarations,
/// etc.--under a single "cursor" abstraction with a common set of operations.
/// Common operation for a cursor include: getting the physical location in
/// a source file where the cursor points, getting the name associated with a
/// cursor, and retrieving cursors for any child nodes of a particular cursor.
///
/// Cursors can be produced in two specific ways.
/// clang_getTranslationUnitCursor() produces a cursor for a translation unit,
/// from which one can use clang_visitChildren() to explore the rest of the
/// translation unit. clang_getCursor() maps from a physical source location
/// to the entity that resides at that location, allowing one to map from the
/// source code into the AST.
final class CXCursor extends ffi.Struct {
  @ffi.UnsignedInt()
  external int kind;

  @ffi.Int()
  external int xdata;

  @ffi.Array.multi([3])
  external ffi.Array<ffi.Pointer<ffi.Void>> data;
}

/// Describes the availability of a particular entity, which indicates
/// whether the use of this entity will result in a warning or error due to
/// it being deprecated or unavailable.
sealed class CXAvailabilityKind {
  /// The entity is available.
  static const CXAvailability_Available = 0;

  /// The entity is available, but has been deprecated (and its use is
  /// not recommended).
  static const CXAvailability_Deprecated = 1;

  /// The entity is not available; any use of it will be an error.
  static const CXAvailability_NotAvailable = 2;

  /// The entity is available, but not accessible; any use of it will be
  /// an error.
  static const CXAvailability_NotAccessible = 3;
}

/// Describes the availability of a given entity on a particular platform, e.g.,
/// a particular class might only be available on Mac OS 10.7 or newer.
final class CXPlatformAvailability extends ffi.Struct {
  /// A string that describes the platform for which this structure
  /// provides availability information.
  ///
  /// Possible values are "ios" or "macos".
  external CXString Platform;

  /// The version number in which this entity was introduced.
  external CXVersion Introduced;

  /// The version number in which this entity was deprecated (but is
  /// still available).
  external CXVersion Deprecated;

  /// The version number in which this entity was obsoleted, and therefore
  /// is no longer available.
  external CXVersion Obsoleted;

  /// Whether the entity is unconditionally unavailable on this platform.
  @ffi.Int()
  external int Unavailable;

  /// An optional message to provide to a user of this API, e.g., to
  /// suggest replacement APIs.
  external CXString Message;
}

/// Describes a version number of the form major.minor.subminor.
final class CXVersion extends ffi.Struct {
  /// The major version number, e.g., the '10' in '10.7.3'. A negative
  /// value indicates that there is no version number at all.
  @ffi.Int()
  external int Major;

  /// The minor version number, e.g., the '7' in '10.7.3'. This value
  /// will be negative if no minor version number was provided, e.g., for
  /// version '10'.
  @ffi.Int()
  external int Minor;

  /// The subminor version number, e.g., the '3' in '10.7.3'. This value
  /// will be negative if no minor or subminor version number was provided,
  /// e.g., in version '10' or '10.7'.
  @ffi.Int()
  external int Subminor;
}

/// Describes the kind of type
sealed class CXTypeKind {
  /// Represents an invalid type (e.g., where no type is available).
  static const CXType_Invalid = 0;

  /// A type whose specific kind is not exposed via this
  /// interface.
  static const CXType_Unexposed = 1;
  static const CXType_Void = 2;
  static const CXType_Bool = 3;
  static const CXType_Char_U = 4;
  static const CXType_UChar = 5;
  static const CXType_Char16 = 6;
  static const CXType_Char32 = 7;
  static const CXType_UShort = 8;
  static const CXType_UInt = 9;
  static const CXType_ULong = 10;
  static const CXType_ULongLong = 11;
  static const CXType_UInt128 = 12;
  static const CXType_Char_S = 13;
  static const CXType_SChar = 14;
  static const CXType_WChar = 15;
  static const CXType_Short = 16;
  static const CXType_Int = 17;
  static const CXType_Long = 18;
  static const CXType_LongLong = 19;
  static const CXType_Int128 = 20;
  static const CXType_Float = 21;
  static const CXType_Double = 22;
  static const CXType_LongDouble = 23;
  static const CXType_NullPtr = 24;
  static const CXType_Overload = 25;
  static const CXType_Dependent = 26;
  static const CXType_ObjCId = 27;
  static const CXType_ObjCClass = 28;
  static const CXType_ObjCSel = 29;
  static const CXType_Float128 = 30;
  static const CXType_Half = 31;
  static const CXType_Float16 = 32;
  static const CXType_ShortAccum = 33;
  static const CXType_Accum = 34;
  static const CXType_LongAccum = 35;
  static const CXType_UShortAccum = 36;
  static const CXType_UAccum = 37;
  static const CXType_ULongAccum = 38;
  static const CXType_FirstBuiltin = 2;
  static const CXType_LastBuiltin = 38;
  static const CXType_Complex = 100;
  static const CXType_Pointer = 101;
  static const CXType_BlockPointer = 102;
  static const CXType_LValueReference = 103;
  static const CXType_RValueReference = 104;
  static const CXType_Record = 105;
  static const CXType_Enum = 106;
  static const CXType_Typedef = 107;
  static const CXType_ObjCInterface = 108;
  static const CXType_ObjCObjectPointer = 109;
  static const CXType_FunctionNoProto = 110;
  static const CXType_FunctionProto = 111;
  static const CXType_ConstantArray = 112;
  static const CXType_Vector = 113;
  static const CXType_IncompleteArray = 114;
  static const CXType_VariableArray = 115;
  static const CXType_DependentSizedArray = 116;
  static const CXType_MemberPointer = 117;
  static const CXType_Auto = 118;

  /// Represents a type that was referred to using an elaborated type keyword.
  ///
  /// E.g., struct S, or via a qualified name, e.g., N::M::type, or both.
  static const CXType_Elaborated = 119;
  static const CXType_Pipe = 120;
  static const CXType_OCLImage1dRO = 121;
  static const CXType_OCLImage1dArrayRO = 122;
  static const CXType_OCLImage1dBufferRO = 123;
  static const CXType_OCLImage2dRO = 124;
  static const CXType_OCLImage2dArrayRO = 125;
  static const CXType_OCLImage2dDepthRO = 126;
  static const CXType_OCLImage2dArrayDepthRO = 127;
  static const CXType_OCLImage2dMSAARO = 128;
  static const CXType_OCLImage2dArrayMSAARO = 129;
  static const CXType_OCLImage2dMSAADepthRO = 130;
  static const CXType_OCLImage2dArrayMSAADepthRO = 131;
  static const CXType_OCLImage3dRO = 132;
  static const CXType_OCLImage1dWO = 133;
  static const CXType_OCLImage1dArrayWO = 134;
  static const CXType_OCLImage1dBufferWO = 135;
  static const CXType_OCLImage2dWO = 136;
  static const CXType_OCLImage2dArrayWO = 137;
  static const CXType_OCLImage2dDepthWO = 138;
  static const CXType_OCLImage2dArrayDepthWO = 139;
  static const CXType_OCLImage2dMSAAWO = 140;
  static const CXType_OCLImage2dArrayMSAAWO = 141;
  static const CXType_OCLImage2dMSAADepthWO = 142;
  static const CXType_OCLImage2dArrayMSAADepthWO = 143;
  static const CXType_OCLImage3dWO = 144;
  static const CXType_OCLImage1dRW = 145;
  static const CXType_OCLImage1dArrayRW = 146;
  static const CXType_OCLImage1dBufferRW = 147;
  static const CXType_OCLImage2dRW = 148;
  static const CXType_OCLImage2dArrayRW = 149;
  static const CXType_OCLImage2dDepthRW = 150;
  static const CXType_OCLImage2dArrayDepthRW = 151;
  static const CXType_OCLImage2dMSAARW = 152;
  static const CXType_OCLImage2dArrayMSAARW = 153;
  static const CXType_OCLImage2dMSAADepthRW = 154;
  static const CXType_OCLImage2dArrayMSAADepthRW = 155;
  static const CXType_OCLImage3dRW = 156;
  static const CXType_OCLSampler = 157;
  static const CXType_OCLEvent = 158;
  static const CXType_OCLQueue = 159;
  static const CXType_OCLReserveID = 160;
  static const CXType_ObjCObject = 161;
  static const CXType_ObjCTypeParam = 162;
  static const CXType_Attributed = 163;
  static const CXType_OCLIntelSubgroupAVCMcePayload = 164;
  static const CXType_OCLIntelSubgroupAVCImePayload = 165;
  static const CXType_OCLIntelSubgroupAVCRefPayload = 166;
  static const CXType_OCLIntelSubgroupAVCSicPayload = 167;
  static const CXType_OCLIntelSubgroupAVCMceResult = 168;
  static const CXType_OCLIntelSubgroupAVCImeResult = 169;
  static const CXType_OCLIntelSubgroupAVCRefResult = 170;
  static const CXType_OCLIntelSubgroupAVCSicResult = 171;
  static const CXType_OCLIntelSubgroupAVCImeResultSingleRefStreamout = 172;
  static const CXType_OCLIntelSubgroupAVCImeResultDualRefStreamout = 173;
  static const CXType_OCLIntelSubgroupAVCImeSingleRefStreamin = 174;
  static const CXType_OCLIntelSubgroupAVCImeDualRefStreamin = 175;
  static const CXType_ExtVector = 176;
}

/// The type of an element in the abstract syntax tree.
final class CXType extends ffi.Struct {
  @ffi.UnsignedInt()
  external int kind;

  @ffi.Array.multi([2])
  external ffi.Array<ffi.Pointer<ffi.Void>> data;
}

sealed class CXTypeNullabilityKind {
  /// Values of this type can never be null.
  static const CXTypeNullability_NonNull = 0;

  /// Values of this type can be null.
  static const CXTypeNullability_Nullable = 1;

  /// Whether values of this type can be null is (explicitly)
  /// unspecified. This captures a (fairly rare) case where we
  /// can't conclude anything about the nullability of the type even
  /// though it has been considered.
  static const CXTypeNullability_Unspecified = 2;

  /// Nullability is not applicable to this type.
  static const CXTypeNullability_Invalid = 3;
}

/// List the possible error codes for \c clang_Type_getSizeOf,
/// \c clang_Type_getAlignOf, \c clang_Type_getOffsetOf and
/// \c clang_Cursor_getOffsetOf.
///
/// A value of this enumeration type can be returned if the target type is not
/// a valid argument to sizeof, alignof or offsetof.
sealed class CXTypeLayoutError {
  /// Type is of kind CXType_Invalid.
  static const CXTypeLayoutError_Invalid = -1;

  /// The type is an incomplete Type.
  static const CXTypeLayoutError_Incomplete = -2;

  /// The type is a dependent Type.
  static const CXTypeLayoutError_Dependent = -3;

  /// The type is not a constant size type.
  static const CXTypeLayoutError_NotConstantSize = -4;

  /// The Field name is not valid for this record.
  static const CXTypeLayoutError_InvalidFieldName = -5;

  /// The type is undeduced.
  static const CXTypeLayoutError_Undeduced = -6;
}

/// Represents the storage classes as declared in the source. CX_SC_Invalid
/// was added for the case that the passed cursor in not a declaration.
sealed class CX_StorageClass {
  static const CX_SC_Invalid = 0;
  static const CX_SC_None = 1;
  static const CX_SC_Extern = 2;
  static const CX_SC_Static = 3;
  static const CX_SC_PrivateExtern = 4;
  static const CX_SC_OpenCLWorkGroupLocal = 5;
  static const CX_SC_Auto = 6;
  static const CX_SC_Register = 7;
}

/// Describes how the traversal of the children of a particular
/// cursor should proceed after visiting a particular child cursor.
///
/// A value of this enumeration type should be returned by each
/// \c CXCursorVisitor to indicate how clang_visitChildren() proceed.
sealed class CXChildVisitResult {
  /// Terminates the cursor traversal.
  static const CXChildVisit_Break = 0;

  /// Continues the cursor traversal with the next sibling of
  /// the cursor just visited, without visiting its children.
  static const CXChildVisit_Continue = 1;

  /// Recursively traverse the children of this cursor, using
  /// the same visitor and client data.
  static const CXChildVisit_Recurse = 2;
}

/// Visitor invoked for each cursor found by a traversal.
///
/// This visitor function will be invoked for each cursor found by
/// clang_visitCursorChildren(). Its first argument is the cursor being
/// visited, its second argument is the parent visitor for that cursor,
/// and its third argument is the client data provided to
/// clang_visitCursorChildren().
///
/// The visitor should return one of the \c CXChildVisitResult values
/// to direct clang_visitCursorChildren().
typedef CXCursorVisitor
    = ffi.Pointer<ffi.NativeFunction<CXCursorVisitorFunction>>;
typedef CXCursorVisitorFunction = ffi.UnsignedInt Function(
    CXCursor cursor, CXCursor parent, CXClientData client_data);
typedef DartCXCursorVisitorFunction = int Function(
    CXCursor cursor, CXCursor parent, CXClientData client_data);

/// Opaque pointer representing client data that will be passed through
/// to various callbacks and visitors.
typedef CXClientData = ffi.Pointer<ffi.Void>;

/// Property attributes for a \c CXCursor_ObjCPropertyDecl.
sealed class CXObjCPropertyAttrKind {
  static const CXObjCPropertyAttr_noattr = 0;
  static const CXObjCPropertyAttr_readonly = 1;
  static const CXObjCPropertyAttr_getter = 2;
  static const CXObjCPropertyAttr_assign = 4;
  static const CXObjCPropertyAttr_readwrite = 8;
  static const CXObjCPropertyAttr_retain = 16;
  static const CXObjCPropertyAttr_copy = 32;
  static const CXObjCPropertyAttr_nonatomic = 64;
  static const CXObjCPropertyAttr_setter = 128;
  static const CXObjCPropertyAttr_atomic = 256;
  static const CXObjCPropertyAttr_weak = 512;
  static const CXObjCPropertyAttr_strong = 1024;
  static const CXObjCPropertyAttr_unsafe_unretained = 2048;
  static const CXObjCPropertyAttr_class = 4096;
}

sealed class CXEvalResultKind {
  static const CXEval_Int = 1;
  static const CXEval_Float = 2;
  static const CXEval_ObjCStrLiteral = 3;
  static const CXEval_StrLiteral = 4;
  static const CXEval_CFStr = 5;
  static const CXEval_Other = 6;
  static const CXEval_UnExposed = 0;
}

/// Evaluation result of a cursor
typedef CXEvalResult = ffi.Pointer<ffi.Void>;

const int CINDEX_VERSION_MAJOR = 0;

const int CINDEX_VERSION_MINOR = 59;

const int CINDEX_VERSION = 59;

const String CINDEX_VERSION_STRING = '0.59';
