/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.app.Activity;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentProvider;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import io.flutter.Log;
import io.flutter.embedding.android.ExclusiveAppComponent;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterEngineGroup;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.PluginRegistry;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityControlSurface;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverAware;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverControlSurface;
import io.flutter.embedding.engine.plugins.broadcastreceiver.BroadcastReceiverPluginBinding;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderAware;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderControlSurface;
import io.flutter.embedding.engine.plugins.contentprovider.ContentProviderPluginBinding;
import io.flutter.embedding.engine.plugins.lifecycle.HiddenLifecycleReference;
import io.flutter.embedding.engine.plugins.service.ServiceAware;
import io.flutter.embedding.engine.plugins.service.ServiceControlSurface;
import io.flutter.embedding.engine.plugins.service.ServicePluginBinding;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.util.TraceSection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class FlutterEngineConnectionRegistry
implements PluginRegistry,
ActivityControlSurface,
ServiceControlSurface,
BroadcastReceiverControlSurface,
ContentProviderControlSurface {
    private static final String TAG = "FlutterEngineCxnRegstry";
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, FlutterPlugin> plugins = new HashMap<Class<? extends FlutterPlugin>, FlutterPlugin>();
    @NonNull
    private final FlutterEngine flutterEngine;
    @NonNull
    private final FlutterPlugin.FlutterPluginBinding pluginBinding;
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, ActivityAware> activityAwarePlugins = new HashMap<Class<? extends FlutterPlugin>, ActivityAware>();
    @Nullable
    private ExclusiveAppComponent<Activity> exclusiveActivity;
    @Nullable
    private FlutterEngineActivityPluginBinding activityPluginBinding;
    private boolean isWaitingForActivityReattachment = false;
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, ServiceAware> serviceAwarePlugins = new HashMap<Class<? extends FlutterPlugin>, ServiceAware>();
    @Nullable
    private Service service;
    @Nullable
    private FlutterEngineServicePluginBinding servicePluginBinding;
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, BroadcastReceiverAware> broadcastReceiverAwarePlugins = new HashMap<Class<? extends FlutterPlugin>, BroadcastReceiverAware>();
    @Nullable
    private BroadcastReceiver broadcastReceiver;
    @Nullable
    private FlutterEngineBroadcastReceiverPluginBinding broadcastReceiverPluginBinding;
    @NonNull
    private final Map<Class<? extends FlutterPlugin>, ContentProviderAware> contentProviderAwarePlugins = new HashMap<Class<? extends FlutterPlugin>, ContentProviderAware>();
    @Nullable
    private ContentProvider contentProvider;
    @Nullable
    private FlutterEngineContentProviderPluginBinding contentProviderPluginBinding;

    FlutterEngineConnectionRegistry(@NonNull Context appContext, @NonNull FlutterEngine flutterEngine, @NonNull FlutterLoader flutterLoader, @Nullable FlutterEngineGroup group) {
        this.flutterEngine = flutterEngine;
        this.pluginBinding = new FlutterPlugin.FlutterPluginBinding(appContext, flutterEngine, flutterEngine.getDartExecutor(), flutterEngine.getRenderer(), flutterEngine.getPlatformViewsController().getRegistry(), new DefaultFlutterAssets(flutterLoader), group);
    }

    public void destroy() {
        Log.v(TAG, "Destroying.");
        this.detachFromAppComponent();
        this.removeAll();
    }

    @Override
    public void add(@NonNull FlutterPlugin plugin) {
        try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#add " + plugin.getClass().getSimpleName());){
            if (this.has(plugin.getClass())) {
                Log.w(TAG, "Attempted to register plugin (" + plugin + ") but it was already registered with this FlutterEngine (" + this.flutterEngine + ").");
                return;
            }
            Log.v(TAG, "Adding plugin: " + plugin);
            this.plugins.put(plugin.getClass(), plugin);
            plugin.onAttachedToEngine(this.pluginBinding);
            if (plugin instanceof ActivityAware) {
                ActivityAware activityAware = (ActivityAware)((Object)plugin);
                this.activityAwarePlugins.put(plugin.getClass(), activityAware);
                if (this.isAttachedToActivity()) {
                    activityAware.onAttachedToActivity(this.activityPluginBinding);
                }
            }
            if (plugin instanceof ServiceAware) {
                ServiceAware serviceAware = (ServiceAware)((Object)plugin);
                this.serviceAwarePlugins.put(plugin.getClass(), serviceAware);
                if (this.isAttachedToService()) {
                    serviceAware.onAttachedToService(this.servicePluginBinding);
                }
            }
            if (plugin instanceof BroadcastReceiverAware) {
                BroadcastReceiverAware broadcastReceiverAware = (BroadcastReceiverAware)((Object)plugin);
                this.broadcastReceiverAwarePlugins.put(plugin.getClass(), broadcastReceiverAware);
                if (this.isAttachedToBroadcastReceiver()) {
                    broadcastReceiverAware.onAttachedToBroadcastReceiver(this.broadcastReceiverPluginBinding);
                }
            }
            if (plugin instanceof ContentProviderAware) {
                ContentProviderAware contentProviderAware = (ContentProviderAware)((Object)plugin);
                this.contentProviderAwarePlugins.put(plugin.getClass(), contentProviderAware);
                if (this.isAttachedToContentProvider()) {
                    contentProviderAware.onAttachedToContentProvider(this.contentProviderPluginBinding);
                }
            }
        }
    }

    @Override
    public void add(@NonNull Set<FlutterPlugin> plugins) {
        for (FlutterPlugin plugin : plugins) {
            this.add(plugin);
        }
    }

    @Override
    public boolean has(@NonNull Class<? extends FlutterPlugin> pluginClass) {
        return this.plugins.containsKey(pluginClass);
    }

    @Override
    public FlutterPlugin get(@NonNull Class<? extends FlutterPlugin> pluginClass) {
        return this.plugins.get(pluginClass);
    }

    @Override
    public void remove(@NonNull Class<? extends FlutterPlugin> pluginClass) {
        FlutterPlugin plugin = this.plugins.get(pluginClass);
        if (plugin == null) {
            return;
        }
        try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#remove " + pluginClass.getSimpleName());){
            if (plugin instanceof ActivityAware) {
                if (this.isAttachedToActivity()) {
                    ActivityAware activityAware = (ActivityAware)((Object)plugin);
                    activityAware.onDetachedFromActivity();
                }
                this.activityAwarePlugins.remove(pluginClass);
            }
            if (plugin instanceof ServiceAware) {
                if (this.isAttachedToService()) {
                    ServiceAware serviceAware = (ServiceAware)((Object)plugin);
                    serviceAware.onDetachedFromService();
                }
                this.serviceAwarePlugins.remove(pluginClass);
            }
            if (plugin instanceof BroadcastReceiverAware) {
                if (this.isAttachedToBroadcastReceiver()) {
                    BroadcastReceiverAware broadcastReceiverAware = (BroadcastReceiverAware)((Object)plugin);
                    broadcastReceiverAware.onDetachedFromBroadcastReceiver();
                }
                this.broadcastReceiverAwarePlugins.remove(pluginClass);
            }
            if (plugin instanceof ContentProviderAware) {
                if (this.isAttachedToContentProvider()) {
                    ContentProviderAware contentProviderAware = (ContentProviderAware)((Object)plugin);
                    contentProviderAware.onDetachedFromContentProvider();
                }
                this.contentProviderAwarePlugins.remove(pluginClass);
            }
            plugin.onDetachedFromEngine(this.pluginBinding);
            this.plugins.remove(pluginClass);
        }
    }

    @Override
    public void remove(@NonNull Set<Class<? extends FlutterPlugin>> pluginClasses) {
        for (Class<? extends FlutterPlugin> pluginClass : pluginClasses) {
            this.remove(pluginClass);
        }
    }

    @Override
    public void removeAll() {
        this.remove(new HashSet<Class<? extends FlutterPlugin>>(this.plugins.keySet()));
        this.plugins.clear();
    }

    private void detachFromAppComponent() {
        if (this.isAttachedToActivity()) {
            this.detachFromActivity();
        } else if (this.isAttachedToService()) {
            this.detachFromService();
        } else if (this.isAttachedToBroadcastReceiver()) {
            this.detachFromBroadcastReceiver();
        } else if (this.isAttachedToContentProvider()) {
            this.detachFromContentProvider();
        }
    }

    private boolean isAttachedToActivity() {
        return this.exclusiveActivity != null;
    }

    private Activity attachedActivity() {
        return this.exclusiveActivity != null ? this.exclusiveActivity.getAppComponent() : null;
    }

    @Override
    public void attachToActivity(@NonNull ExclusiveAppComponent<Activity> exclusiveActivity, @NonNull Lifecycle lifecycle) {
        try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#attachToActivity");){
            if (this.exclusiveActivity != null) {
                this.exclusiveActivity.detachFromFlutterEngine();
            }
            this.detachFromAppComponent();
            this.exclusiveActivity = exclusiveActivity;
            this.attachToActivityInternal(exclusiveActivity.getAppComponent(), lifecycle);
        }
    }

    private void attachToActivityInternal(@NonNull Activity activity, @NonNull Lifecycle lifecycle) {
        this.activityPluginBinding = new FlutterEngineActivityPluginBinding(activity, lifecycle);
        boolean useSoftwareRendering = activity.getIntent() != null ? activity.getIntent().getBooleanExtra("enable-software-rendering", false) : false;
        this.flutterEngine.getPlatformViewsController().setSoftwareRendering(useSoftwareRendering);
        this.flutterEngine.getPlatformViewsController().attach((Context)activity, this.flutterEngine.getRenderer(), this.flutterEngine.getDartExecutor());
        this.flutterEngine.getPlatformViewsController2().attach((Context)activity, this.flutterEngine.getDartExecutor());
        for (ActivityAware activityAware : this.activityAwarePlugins.values()) {
            if (this.isWaitingForActivityReattachment) {
                activityAware.onReattachedToActivityForConfigChanges(this.activityPluginBinding);
                continue;
            }
            activityAware.onAttachedToActivity(this.activityPluginBinding);
        }
        this.isWaitingForActivityReattachment = false;
    }

    @Override
    public void detachFromActivityForConfigChanges() {
        if (this.isAttachedToActivity()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#detachFromActivityForConfigChanges");){
                this.isWaitingForActivityReattachment = true;
                for (ActivityAware activityAware : this.activityAwarePlugins.values()) {
                    activityAware.onDetachedFromActivityForConfigChanges();
                }
                this.detachFromActivityInternal();
            }
        } else {
            Log.e(TAG, "Attempted to detach plugins from an Activity when no Activity was attached.");
        }
    }

    @Override
    public void detachFromActivity() {
        if (this.isAttachedToActivity()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#detachFromActivity");){
                for (ActivityAware activityAware : this.activityAwarePlugins.values()) {
                    activityAware.onDetachedFromActivity();
                }
                this.detachFromActivityInternal();
            }
        } else {
            Log.e(TAG, "Attempted to detach plugins from an Activity when no Activity was attached.");
        }
    }

    private void detachFromActivityInternal() {
        this.flutterEngine.getPlatformViewsController().detach();
        this.flutterEngine.getPlatformViewsController2().detach();
        this.exclusiveActivity = null;
        this.activityPluginBinding = null;
    }

    @Override
    public boolean onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResult) {
        if (this.isAttachedToActivity()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#onRequestPermissionsResult");){
                boolean bl = this.activityPluginBinding.onRequestPermissionsResult(requestCode, permissions, grantResult);
                return bl;
            }
        }
        Log.e(TAG, "Attempted to notify ActivityAware plugins of onRequestPermissionsResult, but no Activity was attached.");
        return false;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (this.isAttachedToActivity()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#onActivityResult");){
                boolean bl = this.activityPluginBinding.onActivityResult(requestCode, resultCode, data);
                return bl;
            }
        }
        Log.e(TAG, "Attempted to notify ActivityAware plugins of onActivityResult, but no Activity was attached.");
        return false;
    }

    @Override
    public void onNewIntent(@NonNull Intent intent) {
        if (this.isAttachedToActivity()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#onNewIntent");){
                this.activityPluginBinding.onNewIntent(intent);
            }
        } else {
            Log.e(TAG, "Attempted to notify ActivityAware plugins of onNewIntent, but no Activity was attached.");
        }
    }

    @Override
    public void onUserLeaveHint() {
        if (this.isAttachedToActivity()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#onUserLeaveHint");){
                this.activityPluginBinding.onUserLeaveHint();
            }
        } else {
            Log.e(TAG, "Attempted to notify ActivityAware plugins of onUserLeaveHint, but no Activity was attached.");
        }
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle bundle) {
        if (this.isAttachedToActivity()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#onSaveInstanceState");){
                this.activityPluginBinding.onSaveInstanceState(bundle);
            }
        } else {
            Log.e(TAG, "Attempted to notify ActivityAware plugins of onSaveInstanceState, but no Activity was attached.");
        }
    }

    @Override
    public void onRestoreInstanceState(@Nullable Bundle bundle) {
        if (this.isAttachedToActivity()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#onRestoreInstanceState");){
                this.activityPluginBinding.onRestoreInstanceState(bundle);
            }
        } else {
            Log.e(TAG, "Attempted to notify ActivityAware plugins of onRestoreInstanceState, but no Activity was attached.");
        }
    }

    private boolean isAttachedToService() {
        return this.service != null;
    }

    @Override
    public void attachToService(@NonNull Service service, @Nullable Lifecycle lifecycle, boolean isForeground) {
        try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#attachToService");){
            this.detachFromAppComponent();
            this.service = service;
            this.servicePluginBinding = new FlutterEngineServicePluginBinding(service, lifecycle);
            for (ServiceAware serviceAware : this.serviceAwarePlugins.values()) {
                serviceAware.onAttachedToService(this.servicePluginBinding);
            }
        }
    }

    @Override
    public void detachFromService() {
        if (this.isAttachedToService()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#detachFromService");){
                for (ServiceAware serviceAware : this.serviceAwarePlugins.values()) {
                    serviceAware.onDetachedFromService();
                }
                this.service = null;
                this.servicePluginBinding = null;
            }
        } else {
            Log.e(TAG, "Attempted to detach plugins from a Service when no Service was attached.");
        }
    }

    @Override
    public void onMoveToForeground() {
        if (this.isAttachedToService()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#onMoveToForeground");){
                this.servicePluginBinding.onMoveToForeground();
            }
        }
    }

    @Override
    public void onMoveToBackground() {
        if (this.isAttachedToService()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#onMoveToBackground");){
                this.servicePluginBinding.onMoveToBackground();
            }
        }
    }

    private boolean isAttachedToBroadcastReceiver() {
        return this.broadcastReceiver != null;
    }

    @Override
    public void attachToBroadcastReceiver(@NonNull BroadcastReceiver broadcastReceiver, @NonNull Lifecycle lifecycle) {
        try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#attachToBroadcastReceiver");){
            this.detachFromAppComponent();
            this.broadcastReceiver = broadcastReceiver;
            this.broadcastReceiverPluginBinding = new FlutterEngineBroadcastReceiverPluginBinding(broadcastReceiver);
            for (BroadcastReceiverAware broadcastReceiverAware : this.broadcastReceiverAwarePlugins.values()) {
                broadcastReceiverAware.onAttachedToBroadcastReceiver(this.broadcastReceiverPluginBinding);
            }
        }
    }

    @Override
    public void detachFromBroadcastReceiver() {
        if (this.isAttachedToBroadcastReceiver()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#detachFromBroadcastReceiver");){
                for (BroadcastReceiverAware broadcastReceiverAware : this.broadcastReceiverAwarePlugins.values()) {
                    broadcastReceiverAware.onDetachedFromBroadcastReceiver();
                }
            }
        } else {
            Log.e(TAG, "Attempted to detach plugins from a BroadcastReceiver when no BroadcastReceiver was attached.");
        }
    }

    private boolean isAttachedToContentProvider() {
        return this.contentProvider != null;
    }

    @Override
    public void attachToContentProvider(@NonNull ContentProvider contentProvider, @NonNull Lifecycle lifecycle) {
        try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#attachToContentProvider");){
            this.detachFromAppComponent();
            this.contentProvider = contentProvider;
            this.contentProviderPluginBinding = new FlutterEngineContentProviderPluginBinding(contentProvider);
            for (ContentProviderAware contentProviderAware : this.contentProviderAwarePlugins.values()) {
                contentProviderAware.onAttachedToContentProvider(this.contentProviderPluginBinding);
            }
        }
    }

    @Override
    public void detachFromContentProvider() {
        if (this.isAttachedToContentProvider()) {
            try (TraceSection e = TraceSection.scoped("FlutterEngineConnectionRegistry#detachFromContentProvider");){
                for (ContentProviderAware contentProviderAware : this.contentProviderAwarePlugins.values()) {
                    contentProviderAware.onDetachedFromContentProvider();
                }
            }
        } else {
            Log.e(TAG, "Attempted to detach plugins from a ContentProvider when no ContentProvider was attached.");
        }
    }

    private static class DefaultFlutterAssets
    implements FlutterPlugin.FlutterAssets {
        final FlutterLoader flutterLoader;

        private DefaultFlutterAssets(@NonNull FlutterLoader flutterLoader) {
            this.flutterLoader = flutterLoader;
        }

        @Override
        public String getAssetFilePathByName(@NonNull String assetFileName) {
            return this.flutterLoader.getLookupKeyForAsset(assetFileName);
        }

        @Override
        public String getAssetFilePathByName(@NonNull String assetFileName, @NonNull String packageName) {
            return this.flutterLoader.getLookupKeyForAsset(assetFileName, packageName);
        }

        @Override
        public String getAssetFilePathBySubpath(@NonNull String assetSubpath) {
            return this.flutterLoader.getLookupKeyForAsset(assetSubpath);
        }

        @Override
        public String getAssetFilePathBySubpath(@NonNull String assetSubpath, @NonNull String packageName) {
            return this.flutterLoader.getLookupKeyForAsset(assetSubpath, packageName);
        }
    }

    private static class FlutterEngineActivityPluginBinding
    implements ActivityPluginBinding {
        @NonNull
        private final Activity activity;
        @NonNull
        private final HiddenLifecycleReference hiddenLifecycleReference;
        @NonNull
        private final Set<PluginRegistry.RequestPermissionsResultListener> onRequestPermissionsResultListeners = new HashSet<PluginRegistry.RequestPermissionsResultListener>();
        @NonNull
        private final Set<PluginRegistry.ActivityResultListener> onActivityResultListeners = new HashSet<PluginRegistry.ActivityResultListener>();
        @NonNull
        private final Set<PluginRegistry.NewIntentListener> onNewIntentListeners = new HashSet<PluginRegistry.NewIntentListener>();
        @NonNull
        private final Set<PluginRegistry.UserLeaveHintListener> onUserLeaveHintListeners = new HashSet<PluginRegistry.UserLeaveHintListener>();
        @NonNull
        private final Set<PluginRegistry.WindowFocusChangedListener> onWindowFocusChangedListeners = new HashSet<PluginRegistry.WindowFocusChangedListener>();
        @NonNull
        private final Set<ActivityPluginBinding.OnSaveInstanceStateListener> onSaveInstanceStateListeners = new HashSet<ActivityPluginBinding.OnSaveInstanceStateListener>();

        public FlutterEngineActivityPluginBinding(@NonNull Activity activity, @NonNull Lifecycle lifecycle) {
            this.activity = activity;
            this.hiddenLifecycleReference = new HiddenLifecycleReference(lifecycle);
        }

        @Override
        @NonNull
        public Activity getActivity() {
            return this.activity;
        }

        @Override
        @NonNull
        public Object getLifecycle() {
            return this.hiddenLifecycleReference;
        }

        @Override
        public void addRequestPermissionsResultListener(@NonNull PluginRegistry.RequestPermissionsResultListener listener) {
            this.onRequestPermissionsResultListeners.add(listener);
        }

        @Override
        public void removeRequestPermissionsResultListener(@NonNull PluginRegistry.RequestPermissionsResultListener listener) {
            this.onRequestPermissionsResultListeners.remove(listener);
        }

        boolean onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResult) {
            boolean didConsumeResult = false;
            for (PluginRegistry.RequestPermissionsResultListener listener : this.onRequestPermissionsResultListeners) {
                didConsumeResult = listener.onRequestPermissionsResult(requestCode, permissions, grantResult) || didConsumeResult;
            }
            return didConsumeResult;
        }

        @Override
        public void addActivityResultListener(@NonNull PluginRegistry.ActivityResultListener listener) {
            this.onActivityResultListeners.add(listener);
        }

        @Override
        public void removeActivityResultListener(@NonNull PluginRegistry.ActivityResultListener listener) {
            this.onActivityResultListeners.remove(listener);
        }

        boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
            boolean didConsumeResult = false;
            for (PluginRegistry.ActivityResultListener listener : new HashSet<PluginRegistry.ActivityResultListener>(this.onActivityResultListeners)) {
                didConsumeResult = listener.onActivityResult(requestCode, resultCode, data) || didConsumeResult;
            }
            return didConsumeResult;
        }

        @Override
        public void addOnNewIntentListener(@NonNull PluginRegistry.NewIntentListener listener) {
            this.onNewIntentListeners.add(listener);
        }

        @Override
        public void removeOnNewIntentListener(@NonNull PluginRegistry.NewIntentListener listener) {
            this.onNewIntentListeners.remove(listener);
        }

        void onNewIntent(@Nullable Intent intent) {
            for (PluginRegistry.NewIntentListener listener : this.onNewIntentListeners) {
                listener.onNewIntent(intent);
            }
        }

        @Override
        public void addOnUserLeaveHintListener(@NonNull PluginRegistry.UserLeaveHintListener listener) {
            this.onUserLeaveHintListeners.add(listener);
        }

        @Override
        public void removeOnUserLeaveHintListener(@NonNull PluginRegistry.UserLeaveHintListener listener) {
            this.onUserLeaveHintListeners.remove(listener);
        }

        @Override
        public void addOnWindowFocusChangedListener(@NonNull PluginRegistry.WindowFocusChangedListener listener) {
            this.onWindowFocusChangedListeners.add(listener);
        }

        @Override
        public void removeOnWindowFocusChangedListener(@NonNull PluginRegistry.WindowFocusChangedListener listener) {
            this.onWindowFocusChangedListeners.remove(listener);
        }

        void onWindowFocusChanged(boolean hasFocus) {
            for (PluginRegistry.WindowFocusChangedListener listener : this.onWindowFocusChangedListeners) {
                listener.onWindowFocusChanged(hasFocus);
            }
        }

        @Override
        public void addOnSaveStateListener(@NonNull ActivityPluginBinding.OnSaveInstanceStateListener listener) {
            this.onSaveInstanceStateListeners.add(listener);
        }

        @Override
        public void removeOnSaveStateListener(@NonNull ActivityPluginBinding.OnSaveInstanceStateListener listener) {
            this.onSaveInstanceStateListeners.remove(listener);
        }

        void onUserLeaveHint() {
            for (PluginRegistry.UserLeaveHintListener listener : this.onUserLeaveHintListeners) {
                listener.onUserLeaveHint();
            }
        }

        void onSaveInstanceState(@NonNull Bundle bundle) {
            for (ActivityPluginBinding.OnSaveInstanceStateListener listener : this.onSaveInstanceStateListeners) {
                listener.onSaveInstanceState(bundle);
            }
        }

        void onRestoreInstanceState(@Nullable Bundle bundle) {
            for (ActivityPluginBinding.OnSaveInstanceStateListener listener : this.onSaveInstanceStateListeners) {
                listener.onRestoreInstanceState(bundle);
            }
        }
    }

    private static class FlutterEngineServicePluginBinding
    implements ServicePluginBinding {
        @NonNull
        private final Service service;
        @Nullable
        private final HiddenLifecycleReference hiddenLifecycleReference;
        @NonNull
        private final Set<ServiceAware.OnModeChangeListener> onModeChangeListeners = new HashSet<ServiceAware.OnModeChangeListener>();

        FlutterEngineServicePluginBinding(@NonNull Service service, @Nullable Lifecycle lifecycle) {
            this.service = service;
            this.hiddenLifecycleReference = lifecycle != null ? new HiddenLifecycleReference(lifecycle) : null;
        }

        @Override
        @NonNull
        public Service getService() {
            return this.service;
        }

        @Override
        @Nullable
        public Object getLifecycle() {
            return this.hiddenLifecycleReference;
        }

        @Override
        public void addOnModeChangeListener(@NonNull ServiceAware.OnModeChangeListener listener) {
            this.onModeChangeListeners.add(listener);
        }

        @Override
        public void removeOnModeChangeListener(@NonNull ServiceAware.OnModeChangeListener listener) {
            this.onModeChangeListeners.remove(listener);
        }

        void onMoveToForeground() {
            for (ServiceAware.OnModeChangeListener listener : this.onModeChangeListeners) {
                listener.onMoveToForeground();
            }
        }

        void onMoveToBackground() {
            for (ServiceAware.OnModeChangeListener listener : this.onModeChangeListeners) {
                listener.onMoveToBackground();
            }
        }
    }

    private static class FlutterEngineBroadcastReceiverPluginBinding
    implements BroadcastReceiverPluginBinding {
        @NonNull
        private final BroadcastReceiver broadcastReceiver;

        FlutterEngineBroadcastReceiverPluginBinding(@NonNull BroadcastReceiver broadcastReceiver) {
            this.broadcastReceiver = broadcastReceiver;
        }

        @Override
        @NonNull
        public BroadcastReceiver getBroadcastReceiver() {
            return this.broadcastReceiver;
        }
    }

    private static class FlutterEngineContentProviderPluginBinding
    implements ContentProviderPluginBinding {
        @NonNull
        private final ContentProvider contentProvider;

        FlutterEngineContentProviderPluginBinding(@NonNull ContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        @Override
        @NonNull
        public ContentProvider getContentProvider() {
            return this.contentProvider;
        }
    }
}

