/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.os.Build;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.FlutterSurfaceView;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.FlutterUiDisplayListener;

public class SurfaceHolderCallbackCompat
implements SurfaceHolder.Callback2 {
    private static final String TAG = "SurfaceHolderCallbackCompat";
    private final FlutterSurfaceView flutterSurfaceView;
    @Nullable
    private FlutterRenderer flutterRenderer;
    private final SurfaceHolder.Callback innerCallback;
    @VisibleForTesting
    final FlutterUiDisplayListener alphaCallback = new FlutterUiDisplayListener(){

        @Override
        public void onFlutterUiDisplayed() {
            Log.v(SurfaceHolderCallbackCompat.TAG, "onFlutterUiDisplayed()");
            SurfaceHolderCallbackCompat.this.flutterSurfaceView.setAlpha(1.0f);
            if (SurfaceHolderCallbackCompat.this.flutterRenderer != null) {
                SurfaceHolderCallbackCompat.this.flutterRenderer.removeIsDisplayingFlutterUiListener(this);
            }
        }

        @Override
        public void onFlutterUiNoLongerDisplayed() {
        }
    };
    private final boolean shouldSetAlpha = Build.VERSION.SDK_INT < 26;
    final FlutterRendererLifecycleCallback lifecycleCallback = this.shouldSetAlpha ? new FlutterRendererLifecycleCallbackPreApi26() : new FlutterRendererLifecycleCallbackApi26AndUp();

    public void onAttachToRenderer(FlutterRenderer flutterRenderer) {
        this.lifecycleCallback.onAttachToRenderer(flutterRenderer);
    }

    public void onDetachFromRenderer() {
        this.lifecycleCallback.onDetachFromRenderer();
    }

    public void onResume() {
        this.lifecycleCallback.onResume();
    }

    public void surfaceCreated(@NonNull SurfaceHolder holder) {
        if (this.innerCallback != null) {
            this.innerCallback.surfaceCreated(holder);
        }
    }

    public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
        if (this.innerCallback != null) {
            this.innerCallback.surfaceChanged(holder, format, width, height);
        }
    }

    public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
        if (this.innerCallback != null) {
            this.innerCallback.surfaceDestroyed(holder);
        }
    }

    public void surfaceRedrawNeeded(@NonNull SurfaceHolder holder) {
        Log.v(TAG, "SurfaceHolder.Callback2.surfaceRedrawNeeded()");
    }

    @RequiresApi(api=26)
    public void surfaceRedrawNeededAsync(@NonNull SurfaceHolder holder, final @NonNull Runnable finishDrawing) {
        Log.v(TAG, "SurfaceHolder.Callback2.surfaceRedrawNeededAsync()");
        if (this.flutterRenderer == null) {
            return;
        }
        this.flutterRenderer.addIsDisplayingFlutterUiListener(new FlutterUiDisplayListener(){

            @Override
            public void onFlutterUiDisplayed() {
                finishDrawing.run();
                if (SurfaceHolderCallbackCompat.this.flutterRenderer != null) {
                    SurfaceHolderCallbackCompat.this.flutterRenderer.removeIsDisplayingFlutterUiListener(this);
                }
            }

            @Override
            public void onFlutterUiNoLongerDisplayed() {
            }
        });
    }

    public SurfaceHolderCallbackCompat(SurfaceHolder.Callback innerCallback, FlutterSurfaceView flutterSurfaceView, @Nullable FlutterRenderer flutterRenderer) {
        this.innerCallback = innerCallback;
        this.flutterRenderer = flutterRenderer;
        this.flutterSurfaceView = flutterSurfaceView;
        Log.v(TAG, "SurfaceHolderCallbackCompat()");
        if (this.shouldSetAlpha) {
            this.flutterSurfaceView.setAlpha(0.0f);
        }
    }

    static interface FlutterRendererLifecycleCallback {
        public void onAttachToRenderer(FlutterRenderer var1);

        public void onDetachFromRenderer();

        public void onResume();
    }

    class FlutterRendererLifecycleCallbackPreApi26
    implements FlutterRendererLifecycleCallback {
        FlutterRendererLifecycleCallbackPreApi26() {
        }

        @Override
        public void onAttachToRenderer(FlutterRenderer attachFlutterRenderer) {
            if (SurfaceHolderCallbackCompat.this.flutterRenderer != null) {
                SurfaceHolderCallbackCompat.this.flutterRenderer.removeIsDisplayingFlutterUiListener(SurfaceHolderCallbackCompat.this.alphaCallback);
            }
            SurfaceHolderCallbackCompat.this.flutterRenderer = attachFlutterRenderer;
        }

        @Override
        public void onDetachFromRenderer() {
            SurfaceHolderCallbackCompat.this.flutterSurfaceView.setAlpha(0.0f);
            if (SurfaceHolderCallbackCompat.this.flutterRenderer != null) {
                SurfaceHolderCallbackCompat.this.flutterRenderer.removeIsDisplayingFlutterUiListener(SurfaceHolderCallbackCompat.this.alphaCallback);
            }
            SurfaceHolderCallbackCompat.this.flutterRenderer = null;
        }

        @Override
        public void onResume() {
            if (SurfaceHolderCallbackCompat.this.flutterRenderer != null) {
                SurfaceHolderCallbackCompat.this.flutterRenderer.addIsDisplayingFlutterUiListener(SurfaceHolderCallbackCompat.this.alphaCallback);
            }
        }
    }

    class FlutterRendererLifecycleCallbackApi26AndUp
    implements FlutterRendererLifecycleCallback {
        FlutterRendererLifecycleCallbackApi26AndUp() {
        }

        @Override
        public void onAttachToRenderer(FlutterRenderer attachFlutterRenderer) {
            SurfaceHolderCallbackCompat.this.flutterRenderer = attachFlutterRenderer;
        }

        @Override
        public void onDetachFromRenderer() {
            SurfaceHolderCallbackCompat.this.flutterRenderer = null;
        }

        @Override
        public void onResume() {
        }
    }
}

