/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.FlutterEngineGroup;
import java.util.HashMap;
import java.util.Map;

public class FlutterEngineGroupCache {
    private static volatile FlutterEngineGroupCache instance;
    private final Map<String, FlutterEngineGroup> cachedEngineGroups = new HashMap<String, FlutterEngineGroup>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static FlutterEngineGroupCache getInstance() {
        if (instance != null) return instance;
        Class<FlutterEngineGroupCache> clazz = FlutterEngineGroupCache.class;
        synchronized (FlutterEngineGroupCache.class) {
            if (instance != null) return instance;
            instance = new FlutterEngineGroupCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    FlutterEngineGroupCache() {
    }

    public boolean contains(@NonNull String engineGroupId) {
        return this.cachedEngineGroups.containsKey(engineGroupId);
    }

    @Nullable
    public FlutterEngineGroup get(@NonNull String engineGroupId) {
        return this.cachedEngineGroups.get(engineGroupId);
    }

    public void put(@NonNull String engineGroupId, @Nullable FlutterEngineGroup engineGroup) {
        if (engineGroup != null) {
            this.cachedEngineGroups.put(engineGroupId, engineGroup);
        } else {
            this.cachedEngineGroups.remove(engineGroupId);
        }
    }

    public void remove(@NonNull String engineGroupId) {
        this.put(engineGroupId, null);
    }

    public void clear() {
        this.cachedEngineGroups.clear();
    }
}

