// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'J'.
class PartJ {
  /// Applies the Jacquarda Bastarda 9 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jacquarda+Bastarda+9
  static TextStyle jacquardaBastarda9({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'daf84ba90ba5123d007bf7a8e1b0b75997ccb21769b8f5810ea6fcc7fbf1bdbf',
        68296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JacquardaBastarda9',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jacquarda Bastarda 9 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jacquarda+Bastarda+9
  static TextTheme jacquardaBastarda9TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jacquardaBastarda9(textStyle: textTheme.displayLarge),
      displayMedium: jacquardaBastarda9(textStyle: textTheme.displayMedium),
      displaySmall: jacquardaBastarda9(textStyle: textTheme.displaySmall),
      headlineLarge: jacquardaBastarda9(textStyle: textTheme.headlineLarge),
      headlineMedium: jacquardaBastarda9(textStyle: textTheme.headlineMedium),
      headlineSmall: jacquardaBastarda9(textStyle: textTheme.headlineSmall),
      titleLarge: jacquardaBastarda9(textStyle: textTheme.titleLarge),
      titleMedium: jacquardaBastarda9(textStyle: textTheme.titleMedium),
      titleSmall: jacquardaBastarda9(textStyle: textTheme.titleSmall),
      bodyLarge: jacquardaBastarda9(textStyle: textTheme.bodyLarge),
      bodyMedium: jacquardaBastarda9(textStyle: textTheme.bodyMedium),
      bodySmall: jacquardaBastarda9(textStyle: textTheme.bodySmall),
      labelLarge: jacquardaBastarda9(textStyle: textTheme.labelLarge),
      labelMedium: jacquardaBastarda9(textStyle: textTheme.labelMedium),
      labelSmall: jacquardaBastarda9(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jacques Francois font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jacques+Francois
  static TextStyle jacquesFrancois({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b670b2f5b6aa58a881a0f54e567661bf3e070755aaacfc428fbd83ea86a9aa7b',
        28380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JacquesFrancois',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jacques Francois font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jacques+Francois
  static TextTheme jacquesFrancoisTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jacquesFrancois(textStyle: textTheme.displayLarge),
      displayMedium: jacquesFrancois(textStyle: textTheme.displayMedium),
      displaySmall: jacquesFrancois(textStyle: textTheme.displaySmall),
      headlineLarge: jacquesFrancois(textStyle: textTheme.headlineLarge),
      headlineMedium: jacquesFrancois(textStyle: textTheme.headlineMedium),
      headlineSmall: jacquesFrancois(textStyle: textTheme.headlineSmall),
      titleLarge: jacquesFrancois(textStyle: textTheme.titleLarge),
      titleMedium: jacquesFrancois(textStyle: textTheme.titleMedium),
      titleSmall: jacquesFrancois(textStyle: textTheme.titleSmall),
      bodyLarge: jacquesFrancois(textStyle: textTheme.bodyLarge),
      bodyMedium: jacquesFrancois(textStyle: textTheme.bodyMedium),
      bodySmall: jacquesFrancois(textStyle: textTheme.bodySmall),
      labelLarge: jacquesFrancois(textStyle: textTheme.labelLarge),
      labelMedium: jacquesFrancois(textStyle: textTheme.labelMedium),
      labelSmall: jacquesFrancois(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jacques Francois Shadow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jacques+Francois+Shadow
  static TextStyle jacquesFrancoisShadow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a1af2fbc45be324624088464f6c17bba818083a7f63ba6a60dc862ff88ac587',
        40580,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JacquesFrancoisShadow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jacques Francois Shadow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jacques+Francois+Shadow
  static TextTheme jacquesFrancoisShadowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jacquesFrancoisShadow(textStyle: textTheme.displayLarge),
      displayMedium: jacquesFrancoisShadow(textStyle: textTheme.displayMedium),
      displaySmall: jacquesFrancoisShadow(textStyle: textTheme.displaySmall),
      headlineLarge: jacquesFrancoisShadow(textStyle: textTheme.headlineLarge),
      headlineMedium:
          jacquesFrancoisShadow(textStyle: textTheme.headlineMedium),
      headlineSmall: jacquesFrancoisShadow(textStyle: textTheme.headlineSmall),
      titleLarge: jacquesFrancoisShadow(textStyle: textTheme.titleLarge),
      titleMedium: jacquesFrancoisShadow(textStyle: textTheme.titleMedium),
      titleSmall: jacquesFrancoisShadow(textStyle: textTheme.titleSmall),
      bodyLarge: jacquesFrancoisShadow(textStyle: textTheme.bodyLarge),
      bodyMedium: jacquesFrancoisShadow(textStyle: textTheme.bodyMedium),
      bodySmall: jacquesFrancoisShadow(textStyle: textTheme.bodySmall),
      labelLarge: jacquesFrancoisShadow(textStyle: textTheme.labelLarge),
      labelMedium: jacquesFrancoisShadow(textStyle: textTheme.labelMedium),
      labelSmall: jacquesFrancoisShadow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jaldi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jaldi
  static TextStyle jaldi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df17fb998fe2226b6157cada4cd08a99522324966fcb0c78d34f758515fc30f4',
        253920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c44838ee49f172bc5936d871a3e9e3631d76743a9720f3ae3c07f98d0b9fe62',
        253608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Jaldi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jaldi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jaldi
  static TextTheme jaldiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jaldi(textStyle: textTheme.displayLarge),
      displayMedium: jaldi(textStyle: textTheme.displayMedium),
      displaySmall: jaldi(textStyle: textTheme.displaySmall),
      headlineLarge: jaldi(textStyle: textTheme.headlineLarge),
      headlineMedium: jaldi(textStyle: textTheme.headlineMedium),
      headlineSmall: jaldi(textStyle: textTheme.headlineSmall),
      titleLarge: jaldi(textStyle: textTheme.titleLarge),
      titleMedium: jaldi(textStyle: textTheme.titleMedium),
      titleSmall: jaldi(textStyle: textTheme.titleSmall),
      bodyLarge: jaldi(textStyle: textTheme.bodyLarge),
      bodyMedium: jaldi(textStyle: textTheme.bodyMedium),
      bodySmall: jaldi(textStyle: textTheme.bodySmall),
      labelLarge: jaldi(textStyle: textTheme.labelLarge),
      labelMedium: jaldi(textStyle: textTheme.labelMedium),
      labelSmall: jaldi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the JetBrains Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/JetBrains+Mono
  static TextStyle jetBrainsMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a44b1b4adc03c445877e325d57d0879cb22840ff640a40e6515be59c845b015',
        112252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9133ef0d504f0d80e5478902ee49e8f815ade6f5621fc89c5d6b9263549325d7',
        112340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0623d0562debca9e5d97996af1de5e98f672a20f2ee6085cec86cd6a77ec3595',
        112276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc34426314d00825ccc768a0c4b1178fe704f04bd947882ef10c2b71b7e355e7',
        112148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba10286722bd7dc2274b817575046e39ee816d6ba1e2ace48e22bcd068576941',
        112180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f833596d98e0e021dd43d993254658d0f32318f82f08afee0fc2e41c16ce9571',
        112136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b43a7dfebfb8816fb3859f6a7932824f594e115538ccd3f1ebc0ffc231b0acab',
        112068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98ea78a2337e1ef2274f247c857a63e40e975c6907a7baff9209033fa42142ac',
        112064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0ad56d15852c41931b3640756ff18d55178c649d5fb55daf346a6831918c2c49',
        115164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '446787ed370004cd92c5043b5710c0fe7222eea7b1cce8d6a0d48008e8d4fa9b',
        115260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9002d02f91013aaf6ee54f0d03bde3e7d114597f49401b022c948ed5c4229702',
        115136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '93f2f2d90bcd64e35bf1b7bd90149b168df727499667b5d2fde1758ed0297da5',
        114936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd33f9b81805d2984778b134e68b0a7f242a2d10a81fa5299b8c5081f3f7f0e83',
        115060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '93aae81b1f8697f683ae32b65bacb4d74679d7a6a69357fbe45858aaa05db9b4',
        115004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a89a53b6ccccdfd6431441572e542901c7620e55d91f10d0eaa3fd39adaa3b83',
        114932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '013382b52ceb65565ac0ecf7dbaaf9369d29f4d4d3a8763439e3eb77c2b1009b',
        114984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JetBrainsMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the JetBrains Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/JetBrains+Mono
  static TextTheme jetBrainsMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jetBrainsMono(textStyle: textTheme.displayLarge),
      displayMedium: jetBrainsMono(textStyle: textTheme.displayMedium),
      displaySmall: jetBrainsMono(textStyle: textTheme.displaySmall),
      headlineLarge: jetBrainsMono(textStyle: textTheme.headlineLarge),
      headlineMedium: jetBrainsMono(textStyle: textTheme.headlineMedium),
      headlineSmall: jetBrainsMono(textStyle: textTheme.headlineSmall),
      titleLarge: jetBrainsMono(textStyle: textTheme.titleLarge),
      titleMedium: jetBrainsMono(textStyle: textTheme.titleMedium),
      titleSmall: jetBrainsMono(textStyle: textTheme.titleSmall),
      bodyLarge: jetBrainsMono(textStyle: textTheme.bodyLarge),
      bodyMedium: jetBrainsMono(textStyle: textTheme.bodyMedium),
      bodySmall: jetBrainsMono(textStyle: textTheme.bodySmall),
      labelLarge: jetBrainsMono(textStyle: textTheme.labelLarge),
      labelMedium: jetBrainsMono(textStyle: textTheme.labelMedium),
      labelSmall: jetBrainsMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jim Nightshade font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jim+Nightshade
  static TextStyle jimNightshade({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa4fc7922c851bddbda9c50b6c6f1940d2e0e30a420c3fa24989294bd78533a0',
        151072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JimNightshade',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jim Nightshade font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jim+Nightshade
  static TextTheme jimNightshadeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jimNightshade(textStyle: textTheme.displayLarge),
      displayMedium: jimNightshade(textStyle: textTheme.displayMedium),
      displaySmall: jimNightshade(textStyle: textTheme.displaySmall),
      headlineLarge: jimNightshade(textStyle: textTheme.headlineLarge),
      headlineMedium: jimNightshade(textStyle: textTheme.headlineMedium),
      headlineSmall: jimNightshade(textStyle: textTheme.headlineSmall),
      titleLarge: jimNightshade(textStyle: textTheme.titleLarge),
      titleMedium: jimNightshade(textStyle: textTheme.titleMedium),
      titleSmall: jimNightshade(textStyle: textTheme.titleSmall),
      bodyLarge: jimNightshade(textStyle: textTheme.bodyLarge),
      bodyMedium: jimNightshade(textStyle: textTheme.bodyMedium),
      bodySmall: jimNightshade(textStyle: textTheme.bodySmall),
      labelLarge: jimNightshade(textStyle: textTheme.labelLarge),
      labelMedium: jimNightshade(textStyle: textTheme.labelMedium),
      labelSmall: jimNightshade(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Joan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Joan
  static TextStyle joan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd42d643e7d0327fc47c57282946d1a1339f3e74b3ae846ae8027cb1b90d6bae',
        134032,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Joan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Joan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Joan
  static TextTheme joanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: joan(textStyle: textTheme.displayLarge),
      displayMedium: joan(textStyle: textTheme.displayMedium),
      displaySmall: joan(textStyle: textTheme.displaySmall),
      headlineLarge: joan(textStyle: textTheme.headlineLarge),
      headlineMedium: joan(textStyle: textTheme.headlineMedium),
      headlineSmall: joan(textStyle: textTheme.headlineSmall),
      titleLarge: joan(textStyle: textTheme.titleLarge),
      titleMedium: joan(textStyle: textTheme.titleMedium),
      titleSmall: joan(textStyle: textTheme.titleSmall),
      bodyLarge: joan(textStyle: textTheme.bodyLarge),
      bodyMedium: joan(textStyle: textTheme.bodyMedium),
      bodySmall: joan(textStyle: textTheme.bodySmall),
      labelLarge: joan(textStyle: textTheme.labelLarge),
      labelMedium: joan(textStyle: textTheme.labelMedium),
      labelSmall: joan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jockey One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jockey+One
  static TextStyle jockeyOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdc1e610717f762093f7cd0e236081f14475548ddbe5a48565215c06ca22f5db',
        41196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JockeyOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jockey One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jockey+One
  static TextTheme jockeyOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jockeyOne(textStyle: textTheme.displayLarge),
      displayMedium: jockeyOne(textStyle: textTheme.displayMedium),
      displaySmall: jockeyOne(textStyle: textTheme.displaySmall),
      headlineLarge: jockeyOne(textStyle: textTheme.headlineLarge),
      headlineMedium: jockeyOne(textStyle: textTheme.headlineMedium),
      headlineSmall: jockeyOne(textStyle: textTheme.headlineSmall),
      titleLarge: jockeyOne(textStyle: textTheme.titleLarge),
      titleMedium: jockeyOne(textStyle: textTheme.titleMedium),
      titleSmall: jockeyOne(textStyle: textTheme.titleSmall),
      bodyLarge: jockeyOne(textStyle: textTheme.bodyLarge),
      bodyMedium: jockeyOne(textStyle: textTheme.bodyMedium),
      bodySmall: jockeyOne(textStyle: textTheme.bodySmall),
      labelLarge: jockeyOne(textStyle: textTheme.labelLarge),
      labelMedium: jockeyOne(textStyle: textTheme.labelMedium),
      labelSmall: jockeyOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jolly Lodger font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jolly+Lodger
  static TextStyle jollyLodger({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '026f40b02b8851fd29e43776b8b2215645b10d0fe0614412b56e8d66d1e2a33c',
        37708,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JollyLodger',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jolly Lodger font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jolly+Lodger
  static TextTheme jollyLodgerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jollyLodger(textStyle: textTheme.displayLarge),
      displayMedium: jollyLodger(textStyle: textTheme.displayMedium),
      displaySmall: jollyLodger(textStyle: textTheme.displaySmall),
      headlineLarge: jollyLodger(textStyle: textTheme.headlineLarge),
      headlineMedium: jollyLodger(textStyle: textTheme.headlineMedium),
      headlineSmall: jollyLodger(textStyle: textTheme.headlineSmall),
      titleLarge: jollyLodger(textStyle: textTheme.titleLarge),
      titleMedium: jollyLodger(textStyle: textTheme.titleMedium),
      titleSmall: jollyLodger(textStyle: textTheme.titleSmall),
      bodyLarge: jollyLodger(textStyle: textTheme.bodyLarge),
      bodyMedium: jollyLodger(textStyle: textTheme.bodyMedium),
      bodySmall: jollyLodger(textStyle: textTheme.bodySmall),
      labelLarge: jollyLodger(textStyle: textTheme.labelLarge),
      labelMedium: jollyLodger(textStyle: textTheme.labelMedium),
      labelSmall: jollyLodger(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jomhuria font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jomhuria
  static TextStyle jomhuria({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0dc88b9f389f99dcf7dfd9e2a9c9d16aec68be54023752190798b424c785365a',
        159356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Jomhuria',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jomhuria font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jomhuria
  static TextTheme jomhuriaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jomhuria(textStyle: textTheme.displayLarge),
      displayMedium: jomhuria(textStyle: textTheme.displayMedium),
      displaySmall: jomhuria(textStyle: textTheme.displaySmall),
      headlineLarge: jomhuria(textStyle: textTheme.headlineLarge),
      headlineMedium: jomhuria(textStyle: textTheme.headlineMedium),
      headlineSmall: jomhuria(textStyle: textTheme.headlineSmall),
      titleLarge: jomhuria(textStyle: textTheme.titleLarge),
      titleMedium: jomhuria(textStyle: textTheme.titleMedium),
      titleSmall: jomhuria(textStyle: textTheme.titleSmall),
      bodyLarge: jomhuria(textStyle: textTheme.bodyLarge),
      bodyMedium: jomhuria(textStyle: textTheme.bodyMedium),
      bodySmall: jomhuria(textStyle: textTheme.bodySmall),
      labelLarge: jomhuria(textStyle: textTheme.labelLarge),
      labelMedium: jomhuria(textStyle: textTheme.labelMedium),
      labelSmall: jomhuria(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jomolhari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jomolhari
  static TextStyle jomolhari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77a4946299c46124a673d10fd9d9c267a1604485caa7cc402654eff2d44227dd',
        1002668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Jomolhari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jomolhari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jomolhari
  static TextTheme jomolhariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jomolhari(textStyle: textTheme.displayLarge),
      displayMedium: jomolhari(textStyle: textTheme.displayMedium),
      displaySmall: jomolhari(textStyle: textTheme.displaySmall),
      headlineLarge: jomolhari(textStyle: textTheme.headlineLarge),
      headlineMedium: jomolhari(textStyle: textTheme.headlineMedium),
      headlineSmall: jomolhari(textStyle: textTheme.headlineSmall),
      titleLarge: jomolhari(textStyle: textTheme.titleLarge),
      titleMedium: jomolhari(textStyle: textTheme.titleMedium),
      titleSmall: jomolhari(textStyle: textTheme.titleSmall),
      bodyLarge: jomolhari(textStyle: textTheme.bodyLarge),
      bodyMedium: jomolhari(textStyle: textTheme.bodyMedium),
      bodySmall: jomolhari(textStyle: textTheme.bodySmall),
      labelLarge: jomolhari(textStyle: textTheme.labelLarge),
      labelMedium: jomolhari(textStyle: textTheme.labelMedium),
      labelSmall: jomolhari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Josefin Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Josefin+Sans
  static TextStyle josefinSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2448744e66028b67adc8960da8ad106b34def5d860b43e81290016903bf86933',
        57624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac493e27b3df8ac02502e11ff486eb0cea81a273255318cca605df7a09d9cbb6',
        57796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9999a50a264e9071a08d7b90a2abcf5f56bf69d15719ef8dc9be37de399d1922',
        57820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81bf642d4a1e8e4a982527d9467f3560d3bd31df1551f27e93c571f0e3a9c0af',
        57820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'becefacc06cd239dcbc516119a0334324c58d99704e2f9476643c0d1ef4c71ad',
        57860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39bcc7a8df91857b0a72b6afc571ef81b1914a8a40dbafc8d5b49d1d5e089abc',
        57856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be01a38ae87a33e809683992977e19210ad75b35eda7066a506c649c4f85be68',
        57696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0f01f4c261cb3491ab95d60f4bd96c75709b5433902f0327ef4776f552e5ae4b',
        61840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7dd16a88c296ea79e344c73a52578fda8aadb70391cf2be161aa2c61dbc87a9a',
        62116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aedf49ad987b06801e45513c112a70d6c0f2bd01e7c2c98a1da2994f6e1716d8',
        62076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '111d8bbd0dbe8164dbda075f45bb5cacd44990f8a813855c91de0a358d745f48',
        62076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3bcb7214e69f1944096b148fd8fedb17c5f0b3504097bab76e5093e3e460e119',
        62228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3e2d0e4343533596ab3a8cfa4079e66b5e50fec88ea8261860d8162a8addb111',
        62240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b951e858e636f232609db27567836813fd6920a23ca824a54dc0299b3c8eb919',
        61988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JosefinSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Josefin Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Josefin+Sans
  static TextTheme josefinSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: josefinSans(textStyle: textTheme.displayLarge),
      displayMedium: josefinSans(textStyle: textTheme.displayMedium),
      displaySmall: josefinSans(textStyle: textTheme.displaySmall),
      headlineLarge: josefinSans(textStyle: textTheme.headlineLarge),
      headlineMedium: josefinSans(textStyle: textTheme.headlineMedium),
      headlineSmall: josefinSans(textStyle: textTheme.headlineSmall),
      titleLarge: josefinSans(textStyle: textTheme.titleLarge),
      titleMedium: josefinSans(textStyle: textTheme.titleMedium),
      titleSmall: josefinSans(textStyle: textTheme.titleSmall),
      bodyLarge: josefinSans(textStyle: textTheme.bodyLarge),
      bodyMedium: josefinSans(textStyle: textTheme.bodyMedium),
      bodySmall: josefinSans(textStyle: textTheme.bodySmall),
      labelLarge: josefinSans(textStyle: textTheme.labelLarge),
      labelMedium: josefinSans(textStyle: textTheme.labelMedium),
      labelSmall: josefinSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Josefin Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Josefin+Slab
  static TextStyle josefinSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c754b50ed94643d43bd0e1d5e7a33ad9467e5822ef962fa312ca92f00e3c8e2f',
        21768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02ccf71fe0f07a61c60ac31948472da129e17b297f9ce4f912679dfbafb6389e',
        21816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc5577c8c6e144cf7406ed7dd22614c8d354133e0265b843ebcb85a269f692c0',
        21812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cabc0e005c8be82e797468175170cc2a4e70c62081706151d3a89dd6d314250a',
        21784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '780d75edeace7d3638cbbefd73e03e1654c4091fe4923f86138aa710bd40efa0',
        21788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73dbecb9ea32ffe0e30b8e01454f1f30ce8fb597e2f4b67d2186a2e6a574cacd',
        21816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7387a91699d8c1d69c08c8e3924807a8aee699839a068fba8d0453a975ebfba',
        21684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '804e1e07675d6bb0be89d8f6abb1ca7ff9c372379aff3a01723f18380da96400',
        23560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cbc8fcf1790706b4bbfa741d27df12ae01814491b21a33ac5b0b0c2267ce3391',
        23612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '067eb956bcbea1bed880a8152d99367e387416dc2bce1f0b133115c28915e10e',
        23612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '38d2006cee2c2f8c1dea3f8900f78bdc58e0853fca5d6065808e371259ce46d9',
        23504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1ad5c4ba39d05ee28f37e51052d0f7a0ca7a026b5fd424f609f266dfa2c5369e',
        23568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd7fbe3f28eb04cf5b9a190da9217a70a4e71e10544edef1c1dab1c62a827000e',
        23608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7e974f309ed90cf0e73c7273f7f36f1d8a7a09a3f46296ea3e76616527186deb',
        23448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JosefinSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Josefin Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Josefin+Slab
  static TextTheme josefinSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: josefinSlab(textStyle: textTheme.displayLarge),
      displayMedium: josefinSlab(textStyle: textTheme.displayMedium),
      displaySmall: josefinSlab(textStyle: textTheme.displaySmall),
      headlineLarge: josefinSlab(textStyle: textTheme.headlineLarge),
      headlineMedium: josefinSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: josefinSlab(textStyle: textTheme.headlineSmall),
      titleLarge: josefinSlab(textStyle: textTheme.titleLarge),
      titleMedium: josefinSlab(textStyle: textTheme.titleMedium),
      titleSmall: josefinSlab(textStyle: textTheme.titleSmall),
      bodyLarge: josefinSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: josefinSlab(textStyle: textTheme.bodyMedium),
      bodySmall: josefinSlab(textStyle: textTheme.bodySmall),
      labelLarge: josefinSlab(textStyle: textTheme.labelLarge),
      labelMedium: josefinSlab(textStyle: textTheme.labelMedium),
      labelSmall: josefinSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jost font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jost
  static TextStyle jost({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd07a1481f0da2422c75896063dbe452e2d493b73ba385c85f8f994f31a170d64',
        58840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e027a6dbf4b03d141e1ed5f6b08e31656b921a8bf51e48152460b0a36ac3b36d',
        58956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58a9ea8c5c24f64f2ac50587f02220aae981339dab7550822f4ebb9b33ba4f0b',
        58880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f4b7aeff86df1af62f055f480fb144ff53f962f36b25b5abda40408a504f27f',
        58772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1cc75367ae5706826fc2a4e8b8e8dcc021bb565c4c8cc0721fdb4b680996804',
        58912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54919e6be4c84bb76c13b9d7c8ae141958b079343d0252c8f6090f1968fb0cc1',
        58912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a88a3673e504711c8ce0c593f1f900f23a1b48acb307007ae13eda59bf5545a4',
        58856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07773bf403d1ba66f8d908cb82dcb1eed2ebb367d28a5ee8f1a8072a1501161f',
        58976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a2251f3973cd2582f053b295aab9ae7c758c8e6271a90158e9c6a1b0428fd72e',
        58948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b563758410b474cf2114bf6d409968ed6212ea98ee5461ac0dcac6cb531dacba',
        62244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4173efbf61a83161828218e774d9dbf1f982eb3946bde45d5bc5f9c833e742d8',
        62464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4e598f4ed6aa6490e927bfcd6ed18343fdc40a08766e08016e01b2eedabc69b1',
        62608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '79b692eaaa67686b172de3c8f53c9b327839d159e72e8d7bdd4ddd8be064793d',
        62556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5be64053ceb511fc8cfe55b6ad9db7e533404473e896433893548deffdd8aed6',
        62676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '742d1a4d6ee5f6c41a13086db2a577741683b566e32cc44fcee704ecd2740a22',
        62668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '940c509bb007b40452e25eba35bdaf14f2ed4562c103171016f23390348eb618',
        62528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1a8f90a6d81258ee08588b6b7348c17198932723490bf1c7ff10024daad31c6d',
        62640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '58db9a9649efd1c5f9ac3e3720fb88abc720f0daa763858aea1276509add6dcf',
        62620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Jost',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jost font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jost
  static TextTheme jostTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jost(textStyle: textTheme.displayLarge),
      displayMedium: jost(textStyle: textTheme.displayMedium),
      displaySmall: jost(textStyle: textTheme.displaySmall),
      headlineLarge: jost(textStyle: textTheme.headlineLarge),
      headlineMedium: jost(textStyle: textTheme.headlineMedium),
      headlineSmall: jost(textStyle: textTheme.headlineSmall),
      titleLarge: jost(textStyle: textTheme.titleLarge),
      titleMedium: jost(textStyle: textTheme.titleMedium),
      titleSmall: jost(textStyle: textTheme.titleSmall),
      bodyLarge: jost(textStyle: textTheme.bodyLarge),
      bodyMedium: jost(textStyle: textTheme.bodyMedium),
      bodySmall: jost(textStyle: textTheme.bodySmall),
      labelLarge: jost(textStyle: textTheme.labelLarge),
      labelMedium: jost(textStyle: textTheme.labelMedium),
      labelSmall: jost(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Joti One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Joti+One
  static TextStyle jotiOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1556ba8d7548e73a751710d82c4eba73ae767d9bb561fe2bbd3888d75538bc0',
        39372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JotiOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Joti One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Joti+One
  static TextTheme jotiOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jotiOne(textStyle: textTheme.displayLarge),
      displayMedium: jotiOne(textStyle: textTheme.displayMedium),
      displaySmall: jotiOne(textStyle: textTheme.displaySmall),
      headlineLarge: jotiOne(textStyle: textTheme.headlineLarge),
      headlineMedium: jotiOne(textStyle: textTheme.headlineMedium),
      headlineSmall: jotiOne(textStyle: textTheme.headlineSmall),
      titleLarge: jotiOne(textStyle: textTheme.titleLarge),
      titleMedium: jotiOne(textStyle: textTheme.titleMedium),
      titleSmall: jotiOne(textStyle: textTheme.titleSmall),
      bodyLarge: jotiOne(textStyle: textTheme.bodyLarge),
      bodyMedium: jotiOne(textStyle: textTheme.bodyMedium),
      bodySmall: jotiOne(textStyle: textTheme.bodySmall),
      labelLarge: jotiOne(textStyle: textTheme.labelLarge),
      labelMedium: jotiOne(textStyle: textTheme.labelMedium),
      labelSmall: jotiOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jua font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jua
  static TextStyle jua({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33724608e254c44195e254d079b5b7806804b9dd4841a37578e69dfaeb792c39',
        1366208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Jua',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jua font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jua
  static TextTheme juaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jua(textStyle: textTheme.displayLarge),
      displayMedium: jua(textStyle: textTheme.displayMedium),
      displaySmall: jua(textStyle: textTheme.displaySmall),
      headlineLarge: jua(textStyle: textTheme.headlineLarge),
      headlineMedium: jua(textStyle: textTheme.headlineMedium),
      headlineSmall: jua(textStyle: textTheme.headlineSmall),
      titleLarge: jua(textStyle: textTheme.titleLarge),
      titleMedium: jua(textStyle: textTheme.titleMedium),
      titleSmall: jua(textStyle: textTheme.titleSmall),
      bodyLarge: jua(textStyle: textTheme.bodyLarge),
      bodyMedium: jua(textStyle: textTheme.bodyMedium),
      bodySmall: jua(textStyle: textTheme.bodySmall),
      labelLarge: jua(textStyle: textTheme.labelLarge),
      labelMedium: jua(textStyle: textTheme.labelMedium),
      labelSmall: jua(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Judson font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Judson
  static TextStyle judson({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5eecc68dfe55442cf465997cdf24849a43b90ca8488ea904a1eb06a63072b353',
        117920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bffdc5c1c37ca45c58120e8a8fdb498defa04b41463b95f7dbfb95868f18dd4b',
        109656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cee65280d9927a4b87350de17e52c604f7eecc500c38ba1c17f205dc617ebf75',
        105276,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Judson',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Judson font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Judson
  static TextTheme judsonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: judson(textStyle: textTheme.displayLarge),
      displayMedium: judson(textStyle: textTheme.displayMedium),
      displaySmall: judson(textStyle: textTheme.displaySmall),
      headlineLarge: judson(textStyle: textTheme.headlineLarge),
      headlineMedium: judson(textStyle: textTheme.headlineMedium),
      headlineSmall: judson(textStyle: textTheme.headlineSmall),
      titleLarge: judson(textStyle: textTheme.titleLarge),
      titleMedium: judson(textStyle: textTheme.titleMedium),
      titleSmall: judson(textStyle: textTheme.titleSmall),
      bodyLarge: judson(textStyle: textTheme.bodyLarge),
      bodyMedium: judson(textStyle: textTheme.bodyMedium),
      bodySmall: judson(textStyle: textTheme.bodySmall),
      labelLarge: judson(textStyle: textTheme.labelLarge),
      labelMedium: judson(textStyle: textTheme.labelMedium),
      labelSmall: judson(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Julee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Julee
  static TextStyle julee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae0991f2de285116242777bcc1fc071aad4259a2326948f6bd71abd8ec88aeeb',
        46704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Julee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Julee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Julee
  static TextTheme juleeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: julee(textStyle: textTheme.displayLarge),
      displayMedium: julee(textStyle: textTheme.displayMedium),
      displaySmall: julee(textStyle: textTheme.displaySmall),
      headlineLarge: julee(textStyle: textTheme.headlineLarge),
      headlineMedium: julee(textStyle: textTheme.headlineMedium),
      headlineSmall: julee(textStyle: textTheme.headlineSmall),
      titleLarge: julee(textStyle: textTheme.titleLarge),
      titleMedium: julee(textStyle: textTheme.titleMedium),
      titleSmall: julee(textStyle: textTheme.titleSmall),
      bodyLarge: julee(textStyle: textTheme.bodyLarge),
      bodyMedium: julee(textStyle: textTheme.bodyMedium),
      bodySmall: julee(textStyle: textTheme.bodySmall),
      labelLarge: julee(textStyle: textTheme.labelLarge),
      labelMedium: julee(textStyle: textTheme.labelMedium),
      labelSmall: julee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Julius Sans One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Julius+Sans+One
  static TextStyle juliusSansOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '897415897b595747828390f69e6e06501077ca7135b59c9fb621dd065c2c48eb',
        26852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JuliusSansOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Julius Sans One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Julius+Sans+One
  static TextTheme juliusSansOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: juliusSansOne(textStyle: textTheme.displayLarge),
      displayMedium: juliusSansOne(textStyle: textTheme.displayMedium),
      displaySmall: juliusSansOne(textStyle: textTheme.displaySmall),
      headlineLarge: juliusSansOne(textStyle: textTheme.headlineLarge),
      headlineMedium: juliusSansOne(textStyle: textTheme.headlineMedium),
      headlineSmall: juliusSansOne(textStyle: textTheme.headlineSmall),
      titleLarge: juliusSansOne(textStyle: textTheme.titleLarge),
      titleMedium: juliusSansOne(textStyle: textTheme.titleMedium),
      titleSmall: juliusSansOne(textStyle: textTheme.titleSmall),
      bodyLarge: juliusSansOne(textStyle: textTheme.bodyLarge),
      bodyMedium: juliusSansOne(textStyle: textTheme.bodyMedium),
      bodySmall: juliusSansOne(textStyle: textTheme.bodySmall),
      labelLarge: juliusSansOne(textStyle: textTheme.labelLarge),
      labelMedium: juliusSansOne(textStyle: textTheme.labelMedium),
      labelSmall: juliusSansOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Junge font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Junge
  static TextStyle junge({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db83a6b699c10c13904dcd9fcda2117be98dc0b684971a8d20cbe80c805d0d3d',
        24004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Junge',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Junge font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Junge
  static TextTheme jungeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: junge(textStyle: textTheme.displayLarge),
      displayMedium: junge(textStyle: textTheme.displayMedium),
      displaySmall: junge(textStyle: textTheme.displaySmall),
      headlineLarge: junge(textStyle: textTheme.headlineLarge),
      headlineMedium: junge(textStyle: textTheme.headlineMedium),
      headlineSmall: junge(textStyle: textTheme.headlineSmall),
      titleLarge: junge(textStyle: textTheme.titleLarge),
      titleMedium: junge(textStyle: textTheme.titleMedium),
      titleSmall: junge(textStyle: textTheme.titleSmall),
      bodyLarge: junge(textStyle: textTheme.bodyLarge),
      bodyMedium: junge(textStyle: textTheme.bodyMedium),
      bodySmall: junge(textStyle: textTheme.bodySmall),
      labelLarge: junge(textStyle: textTheme.labelLarge),
      labelMedium: junge(textStyle: textTheme.labelMedium),
      labelSmall: junge(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Jura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jura
  static TextStyle jura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '524a6b1e7560db04829605872be3aaa97299ee4e34f495342f6deb6755251f4a',
        150920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19652db1874777483a7611aecd18d4da7a236cd2a2ecab1123d50671c03d9742',
        151188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6772ff53e31e6db0b7e0c3b2fdd2cdfdf3cec7d33c53355c9719892b899422b',
        151100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98f689b4879696c5646a729ded39f806a1d3afbe92878249b89a288e75acde12',
        151120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '13c5a74d6936241a64f461f8d8bbe17b83b0a1448572c0d3a7ea7fcadb485bfa',
        150808,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Jura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Jura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Jura
  static TextTheme juraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: jura(textStyle: textTheme.displayLarge),
      displayMedium: jura(textStyle: textTheme.displayMedium),
      displaySmall: jura(textStyle: textTheme.displaySmall),
      headlineLarge: jura(textStyle: textTheme.headlineLarge),
      headlineMedium: jura(textStyle: textTheme.headlineMedium),
      headlineSmall: jura(textStyle: textTheme.headlineSmall),
      titleLarge: jura(textStyle: textTheme.titleLarge),
      titleMedium: jura(textStyle: textTheme.titleMedium),
      titleSmall: jura(textStyle: textTheme.titleSmall),
      bodyLarge: jura(textStyle: textTheme.bodyLarge),
      bodyMedium: jura(textStyle: textTheme.bodyMedium),
      bodySmall: jura(textStyle: textTheme.bodySmall),
      labelLarge: jura(textStyle: textTheme.labelLarge),
      labelMedium: jura(textStyle: textTheme.labelMedium),
      labelSmall: jura(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Just Another Hand font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Just+Another+Hand
  static TextStyle justAnotherHand({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '13aedb770331ef1aba792d3f944450c9613954b9602faea54193cab835179902',
        75428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JustAnotherHand',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Just Another Hand font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Just+Another+Hand
  static TextTheme justAnotherHandTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: justAnotherHand(textStyle: textTheme.displayLarge),
      displayMedium: justAnotherHand(textStyle: textTheme.displayMedium),
      displaySmall: justAnotherHand(textStyle: textTheme.displaySmall),
      headlineLarge: justAnotherHand(textStyle: textTheme.headlineLarge),
      headlineMedium: justAnotherHand(textStyle: textTheme.headlineMedium),
      headlineSmall: justAnotherHand(textStyle: textTheme.headlineSmall),
      titleLarge: justAnotherHand(textStyle: textTheme.titleLarge),
      titleMedium: justAnotherHand(textStyle: textTheme.titleMedium),
      titleSmall: justAnotherHand(textStyle: textTheme.titleSmall),
      bodyLarge: justAnotherHand(textStyle: textTheme.bodyLarge),
      bodyMedium: justAnotherHand(textStyle: textTheme.bodyMedium),
      bodySmall: justAnotherHand(textStyle: textTheme.bodySmall),
      labelLarge: justAnotherHand(textStyle: textTheme.labelLarge),
      labelMedium: justAnotherHand(textStyle: textTheme.labelMedium),
      labelSmall: justAnotherHand(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Just Me Again Down Here font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Just+Me+Again+Down+Here
  static TextStyle justMeAgainDownHere({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a8937ed95ef3f61a33aafb5c6f97c83af09ede10360cf9a4bee545257089439',
        50340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'JustMeAgainDownHere',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Just Me Again Down Here font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Just+Me+Again+Down+Here
  static TextTheme justMeAgainDownHereTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: justMeAgainDownHere(textStyle: textTheme.displayLarge),
      displayMedium: justMeAgainDownHere(textStyle: textTheme.displayMedium),
      displaySmall: justMeAgainDownHere(textStyle: textTheme.displaySmall),
      headlineLarge: justMeAgainDownHere(textStyle: textTheme.headlineLarge),
      headlineMedium: justMeAgainDownHere(textStyle: textTheme.headlineMedium),
      headlineSmall: justMeAgainDownHere(textStyle: textTheme.headlineSmall),
      titleLarge: justMeAgainDownHere(textStyle: textTheme.titleLarge),
      titleMedium: justMeAgainDownHere(textStyle: textTheme.titleMedium),
      titleSmall: justMeAgainDownHere(textStyle: textTheme.titleSmall),
      bodyLarge: justMeAgainDownHere(textStyle: textTheme.bodyLarge),
      bodyMedium: justMeAgainDownHere(textStyle: textTheme.bodyMedium),
      bodySmall: justMeAgainDownHere(textStyle: textTheme.bodySmall),
      labelLarge: justMeAgainDownHere(textStyle: textTheme.labelLarge),
      labelMedium: justMeAgainDownHere(textStyle: textTheme.labelMedium),
      labelSmall: justMeAgainDownHere(textStyle: textTheme.labelSmall),
    );
  }
}
