// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'N'.
class PartN {
  /// Applies the NTR font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/NTR
  static TextStyle ntr({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '75efad0d100ac06d38185bcc4a942c9b9f5dd219227e3486c0967a67eec5bdf3',
        195260,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NTR',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the NTR font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/NTR
  static TextTheme ntrTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ntr(textStyle: textTheme.displayLarge),
      displayMedium: ntr(textStyle: textTheme.displayMedium),
      displaySmall: ntr(textStyle: textTheme.displaySmall),
      headlineLarge: ntr(textStyle: textTheme.headlineLarge),
      headlineMedium: ntr(textStyle: textTheme.headlineMedium),
      headlineSmall: ntr(textStyle: textTheme.headlineSmall),
      titleLarge: ntr(textStyle: textTheme.titleLarge),
      titleMedium: ntr(textStyle: textTheme.titleMedium),
      titleSmall: ntr(textStyle: textTheme.titleSmall),
      bodyLarge: ntr(textStyle: textTheme.bodyLarge),
      bodyMedium: ntr(textStyle: textTheme.bodyMedium),
      bodySmall: ntr(textStyle: textTheme.bodySmall),
      labelLarge: ntr(textStyle: textTheme.labelLarge),
      labelMedium: ntr(textStyle: textTheme.labelMedium),
      labelSmall: ntr(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nabla font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nabla
  static TextStyle nabla({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '753b6658174f4e562f1a4f6d06f560858aced2a6e1a9666f385966abfccefa2d',
        1441836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Nabla',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nabla font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nabla
  static TextTheme nablaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nabla(textStyle: textTheme.displayLarge),
      displayMedium: nabla(textStyle: textTheme.displayMedium),
      displaySmall: nabla(textStyle: textTheme.displaySmall),
      headlineLarge: nabla(textStyle: textTheme.headlineLarge),
      headlineMedium: nabla(textStyle: textTheme.headlineMedium),
      headlineSmall: nabla(textStyle: textTheme.headlineSmall),
      titleLarge: nabla(textStyle: textTheme.titleLarge),
      titleMedium: nabla(textStyle: textTheme.titleMedium),
      titleSmall: nabla(textStyle: textTheme.titleSmall),
      bodyLarge: nabla(textStyle: textTheme.bodyLarge),
      bodyMedium: nabla(textStyle: textTheme.bodyMedium),
      bodySmall: nabla(textStyle: textTheme.bodySmall),
      labelLarge: nabla(textStyle: textTheme.labelLarge),
      labelMedium: nabla(textStyle: textTheme.labelMedium),
      labelSmall: nabla(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Namdhinggo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Namdhinggo
  static TextStyle namdhinggo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36367efcd43dd7baf4731cf6785ac96264752b03f2f218f599b296216a450387',
        75888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd272a0914487676104b421abc7a8bacb3b9d30f43ae8a1d262201eb5a4674138',
        76204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3a4787b69a989f888141814021349f2ea3be591a4859af3ddb7fa9f16583ec5',
        76240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e02dc8f04a965fe7ab391bdae828fa891593bd98f5eb9e7f28c1b420dea902f',
        77020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ead964cc9a495e6f202f2dde02b5ba0938e417ef610c9a3f06efe64b5a86966',
        77276,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Namdhinggo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Namdhinggo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Namdhinggo
  static TextTheme namdhinggoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: namdhinggo(textStyle: textTheme.displayLarge),
      displayMedium: namdhinggo(textStyle: textTheme.displayMedium),
      displaySmall: namdhinggo(textStyle: textTheme.displaySmall),
      headlineLarge: namdhinggo(textStyle: textTheme.headlineLarge),
      headlineMedium: namdhinggo(textStyle: textTheme.headlineMedium),
      headlineSmall: namdhinggo(textStyle: textTheme.headlineSmall),
      titleLarge: namdhinggo(textStyle: textTheme.titleLarge),
      titleMedium: namdhinggo(textStyle: textTheme.titleMedium),
      titleSmall: namdhinggo(textStyle: textTheme.titleSmall),
      bodyLarge: namdhinggo(textStyle: textTheme.bodyLarge),
      bodyMedium: namdhinggo(textStyle: textTheme.bodyMedium),
      bodySmall: namdhinggo(textStyle: textTheme.bodySmall),
      labelLarge: namdhinggo(textStyle: textTheme.labelLarge),
      labelMedium: namdhinggo(textStyle: textTheme.labelMedium),
      labelSmall: namdhinggo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nanum Brush Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Brush+Script
  static TextStyle nanumBrushScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8203290cda33de2f64480b695006a1132a04d55dd94cf421e0fc4e8b45dcdfd4',
        2740064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NanumBrushScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nanum Brush Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Brush+Script
  static TextTheme nanumBrushScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nanumBrushScript(textStyle: textTheme.displayLarge),
      displayMedium: nanumBrushScript(textStyle: textTheme.displayMedium),
      displaySmall: nanumBrushScript(textStyle: textTheme.displaySmall),
      headlineLarge: nanumBrushScript(textStyle: textTheme.headlineLarge),
      headlineMedium: nanumBrushScript(textStyle: textTheme.headlineMedium),
      headlineSmall: nanumBrushScript(textStyle: textTheme.headlineSmall),
      titleLarge: nanumBrushScript(textStyle: textTheme.titleLarge),
      titleMedium: nanumBrushScript(textStyle: textTheme.titleMedium),
      titleSmall: nanumBrushScript(textStyle: textTheme.titleSmall),
      bodyLarge: nanumBrushScript(textStyle: textTheme.bodyLarge),
      bodyMedium: nanumBrushScript(textStyle: textTheme.bodyMedium),
      bodySmall: nanumBrushScript(textStyle: textTheme.bodySmall),
      labelLarge: nanumBrushScript(textStyle: textTheme.labelLarge),
      labelMedium: nanumBrushScript(textStyle: textTheme.labelMedium),
      labelSmall: nanumBrushScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nanum Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Gothic
  static TextStyle nanumGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77530df7fc79e351c8ab6119c7edc574670a154625acc38f8d826fc50f1eb10a',
        2879844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e281256634af62557997b29a416167b744d88bfc4631408f7c345a9e69b13cb3',
        2891120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96dc44cf48029cb19948264b88b6cae76f1dd56ac14257e14d949182a3d031d6',
        2951524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NanumGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nanum Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Gothic
  static TextTheme nanumGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nanumGothic(textStyle: textTheme.displayLarge),
      displayMedium: nanumGothic(textStyle: textTheme.displayMedium),
      displaySmall: nanumGothic(textStyle: textTheme.displaySmall),
      headlineLarge: nanumGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: nanumGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: nanumGothic(textStyle: textTheme.headlineSmall),
      titleLarge: nanumGothic(textStyle: textTheme.titleLarge),
      titleMedium: nanumGothic(textStyle: textTheme.titleMedium),
      titleSmall: nanumGothic(textStyle: textTheme.titleSmall),
      bodyLarge: nanumGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: nanumGothic(textStyle: textTheme.bodyMedium),
      bodySmall: nanumGothic(textStyle: textTheme.bodySmall),
      labelLarge: nanumGothic(textStyle: textTheme.labelLarge),
      labelMedium: nanumGothic(textStyle: textTheme.labelMedium),
      labelSmall: nanumGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nanum Gothic Coding font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Gothic+Coding
  static TextStyle nanumGothicCoding({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64f0cf664abd2cf4793677f1721c1b6e392ba4881dc2bafabcaecad7dcd5a4d9',
        1432696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16674148d9db5dfefada907e624cf4352205fe6441fa25285c291e0b32c50198',
        1458828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NanumGothicCoding',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nanum Gothic Coding font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Gothic+Coding
  static TextTheme nanumGothicCodingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nanumGothicCoding(textStyle: textTheme.displayLarge),
      displayMedium: nanumGothicCoding(textStyle: textTheme.displayMedium),
      displaySmall: nanumGothicCoding(textStyle: textTheme.displaySmall),
      headlineLarge: nanumGothicCoding(textStyle: textTheme.headlineLarge),
      headlineMedium: nanumGothicCoding(textStyle: textTheme.headlineMedium),
      headlineSmall: nanumGothicCoding(textStyle: textTheme.headlineSmall),
      titleLarge: nanumGothicCoding(textStyle: textTheme.titleLarge),
      titleMedium: nanumGothicCoding(textStyle: textTheme.titleMedium),
      titleSmall: nanumGothicCoding(textStyle: textTheme.titleSmall),
      bodyLarge: nanumGothicCoding(textStyle: textTheme.bodyLarge),
      bodyMedium: nanumGothicCoding(textStyle: textTheme.bodyMedium),
      bodySmall: nanumGothicCoding(textStyle: textTheme.bodySmall),
      labelLarge: nanumGothicCoding(textStyle: textTheme.labelLarge),
      labelMedium: nanumGothicCoding(textStyle: textTheme.labelMedium),
      labelSmall: nanumGothicCoding(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nanum Myeongjo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Myeongjo
  static TextStyle nanumMyeongjo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f775cb4748c07cc95064a8b3a3f1e9766df44a59913fc3ba7657633eb722354',
        2167768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4fed937dfa086286d25fa29ebf7d291f1b2a3fc800cff94ddd06a6c44bca0c8',
        2241372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '344ee6c1b3ccd22ffaba4c9cc1a8508dc3556083aa017d95c38a45d5ac7579dc',
        2293812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NanumMyeongjo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nanum Myeongjo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Myeongjo
  static TextTheme nanumMyeongjoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nanumMyeongjo(textStyle: textTheme.displayLarge),
      displayMedium: nanumMyeongjo(textStyle: textTheme.displayMedium),
      displaySmall: nanumMyeongjo(textStyle: textTheme.displaySmall),
      headlineLarge: nanumMyeongjo(textStyle: textTheme.headlineLarge),
      headlineMedium: nanumMyeongjo(textStyle: textTheme.headlineMedium),
      headlineSmall: nanumMyeongjo(textStyle: textTheme.headlineSmall),
      titleLarge: nanumMyeongjo(textStyle: textTheme.titleLarge),
      titleMedium: nanumMyeongjo(textStyle: textTheme.titleMedium),
      titleSmall: nanumMyeongjo(textStyle: textTheme.titleSmall),
      bodyLarge: nanumMyeongjo(textStyle: textTheme.bodyLarge),
      bodyMedium: nanumMyeongjo(textStyle: textTheme.bodyMedium),
      bodySmall: nanumMyeongjo(textStyle: textTheme.bodySmall),
      labelLarge: nanumMyeongjo(textStyle: textTheme.labelLarge),
      labelMedium: nanumMyeongjo(textStyle: textTheme.labelMedium),
      labelSmall: nanumMyeongjo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nanum Pen Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Pen+Script
  static TextStyle nanumPenScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f149a311829ac3edfd81a802effced9cb8a9cad047ef1cc7d57a29ac7f7491a1',
        2533592,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NanumPenScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nanum Pen Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nanum+Pen+Script
  static TextTheme nanumPenScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nanumPenScript(textStyle: textTheme.displayLarge),
      displayMedium: nanumPenScript(textStyle: textTheme.displayMedium),
      displaySmall: nanumPenScript(textStyle: textTheme.displaySmall),
      headlineLarge: nanumPenScript(textStyle: textTheme.headlineLarge),
      headlineMedium: nanumPenScript(textStyle: textTheme.headlineMedium),
      headlineSmall: nanumPenScript(textStyle: textTheme.headlineSmall),
      titleLarge: nanumPenScript(textStyle: textTheme.titleLarge),
      titleMedium: nanumPenScript(textStyle: textTheme.titleMedium),
      titleSmall: nanumPenScript(textStyle: textTheme.titleSmall),
      bodyLarge: nanumPenScript(textStyle: textTheme.bodyLarge),
      bodyMedium: nanumPenScript(textStyle: textTheme.bodyMedium),
      bodySmall: nanumPenScript(textStyle: textTheme.bodySmall),
      labelLarge: nanumPenScript(textStyle: textTheme.labelLarge),
      labelMedium: nanumPenScript(textStyle: textTheme.labelMedium),
      labelSmall: nanumPenScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Narnoor font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Narnoor
  static TextStyle narnoor({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bac5020fe7d3d4cf78cd5325c6074c31b1ec141b51a4fc199a20d736f9ea4597',
        70400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5fa43e9257182e1e330bb2c1fe2d6bc05065bcebec3c2dca457a90b9481daada',
        70192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7da8c21e8179e4940f0e774d4975c66ff5db19d545c83d03e8df656bd4141200',
        70168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f16d31cf1d63874b1a5c87b97dd64b005d2a02512b14ea5683b7bcc66595023',
        70388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be221f3b94da9a957aa9fedacfa7ad5bf4418d4be5300c9610d720253fb23fa3',
        70952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Narnoor',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Narnoor font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Narnoor
  static TextTheme narnoorTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: narnoor(textStyle: textTheme.displayLarge),
      displayMedium: narnoor(textStyle: textTheme.displayMedium),
      displaySmall: narnoor(textStyle: textTheme.displaySmall),
      headlineLarge: narnoor(textStyle: textTheme.headlineLarge),
      headlineMedium: narnoor(textStyle: textTheme.headlineMedium),
      headlineSmall: narnoor(textStyle: textTheme.headlineSmall),
      titleLarge: narnoor(textStyle: textTheme.titleLarge),
      titleMedium: narnoor(textStyle: textTheme.titleMedium),
      titleSmall: narnoor(textStyle: textTheme.titleSmall),
      bodyLarge: narnoor(textStyle: textTheme.bodyLarge),
      bodyMedium: narnoor(textStyle: textTheme.bodyMedium),
      bodySmall: narnoor(textStyle: textTheme.bodySmall),
      labelLarge: narnoor(textStyle: textTheme.labelLarge),
      labelMedium: narnoor(textStyle: textTheme.labelMedium),
      labelSmall: narnoor(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Neonderthaw font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Neonderthaw
  static TextStyle neonderthaw({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '819b5c4993e4f6f7a953153cbcd5c4632428147d55fa4f7eb9aecc6343f6a8e6',
        168388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Neonderthaw',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Neonderthaw font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Neonderthaw
  static TextTheme neonderthawTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: neonderthaw(textStyle: textTheme.displayLarge),
      displayMedium: neonderthaw(textStyle: textTheme.displayMedium),
      displaySmall: neonderthaw(textStyle: textTheme.displaySmall),
      headlineLarge: neonderthaw(textStyle: textTheme.headlineLarge),
      headlineMedium: neonderthaw(textStyle: textTheme.headlineMedium),
      headlineSmall: neonderthaw(textStyle: textTheme.headlineSmall),
      titleLarge: neonderthaw(textStyle: textTheme.titleLarge),
      titleMedium: neonderthaw(textStyle: textTheme.titleMedium),
      titleSmall: neonderthaw(textStyle: textTheme.titleSmall),
      bodyLarge: neonderthaw(textStyle: textTheme.bodyLarge),
      bodyMedium: neonderthaw(textStyle: textTheme.bodyMedium),
      bodySmall: neonderthaw(textStyle: textTheme.bodySmall),
      labelLarge: neonderthaw(textStyle: textTheme.labelLarge),
      labelMedium: neonderthaw(textStyle: textTheme.labelMedium),
      labelSmall: neonderthaw(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nerko One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nerko+One
  static TextStyle nerkoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28124cf49d918ba0b37dba5d27daa95014f3e3a7f4af51a61beeee9b07aa4c4d',
        102004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NerkoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nerko One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nerko+One
  static TextTheme nerkoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nerkoOne(textStyle: textTheme.displayLarge),
      displayMedium: nerkoOne(textStyle: textTheme.displayMedium),
      displaySmall: nerkoOne(textStyle: textTheme.displaySmall),
      headlineLarge: nerkoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: nerkoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: nerkoOne(textStyle: textTheme.headlineSmall),
      titleLarge: nerkoOne(textStyle: textTheme.titleLarge),
      titleMedium: nerkoOne(textStyle: textTheme.titleMedium),
      titleSmall: nerkoOne(textStyle: textTheme.titleSmall),
      bodyLarge: nerkoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: nerkoOne(textStyle: textTheme.bodyMedium),
      bodySmall: nerkoOne(textStyle: textTheme.bodySmall),
      labelLarge: nerkoOne(textStyle: textTheme.labelLarge),
      labelMedium: nerkoOne(textStyle: textTheme.labelMedium),
      labelSmall: nerkoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Neucha font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Neucha
  static TextStyle neucha({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f56c99d50e2731deb4c26c6f90f6d491c3fb40e911aab1f378a75bc9776501f5',
        40164,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Neucha',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Neucha font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Neucha
  static TextTheme neuchaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: neucha(textStyle: textTheme.displayLarge),
      displayMedium: neucha(textStyle: textTheme.displayMedium),
      displaySmall: neucha(textStyle: textTheme.displaySmall),
      headlineLarge: neucha(textStyle: textTheme.headlineLarge),
      headlineMedium: neucha(textStyle: textTheme.headlineMedium),
      headlineSmall: neucha(textStyle: textTheme.headlineSmall),
      titleLarge: neucha(textStyle: textTheme.titleLarge),
      titleMedium: neucha(textStyle: textTheme.titleMedium),
      titleSmall: neucha(textStyle: textTheme.titleSmall),
      bodyLarge: neucha(textStyle: textTheme.bodyLarge),
      bodyMedium: neucha(textStyle: textTheme.bodyMedium),
      bodySmall: neucha(textStyle: textTheme.bodySmall),
      labelLarge: neucha(textStyle: textTheme.labelLarge),
      labelMedium: neucha(textStyle: textTheme.labelMedium),
      labelSmall: neucha(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Neuton font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Neuton
  static TextStyle neuton({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a29d7d27140101e9da3dce70f599abbf872a7678b3e2b8d588e1d3bacd1b8f02',
        22492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5a518fe82107d9e9901c9920122ae9acf8db74e699cdfe1f4d2769753e40261',
        22340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f54b99143cdfd789d9290e7eb62ddf5cd17390d1edc936ae2e1bd7d18053dbbb',
        27636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b3bfeda3ec8df8fef33282d97be8ddd500900b7d258b1a2491d27c7d3e61dce9',
        24156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f54075f41105bd38419f3b80f91deb0a9a7a967b1280ca400b2a6a378fbe9fd3',
        23784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f21682f7a37f097629fcc5ee8d3e6a89a791522b14bb24d8f30a4aae2c156fa',
        23444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Neuton',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Neuton font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Neuton
  static TextTheme neutonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: neuton(textStyle: textTheme.displayLarge),
      displayMedium: neuton(textStyle: textTheme.displayMedium),
      displaySmall: neuton(textStyle: textTheme.displaySmall),
      headlineLarge: neuton(textStyle: textTheme.headlineLarge),
      headlineMedium: neuton(textStyle: textTheme.headlineMedium),
      headlineSmall: neuton(textStyle: textTheme.headlineSmall),
      titleLarge: neuton(textStyle: textTheme.titleLarge),
      titleMedium: neuton(textStyle: textTheme.titleMedium),
      titleSmall: neuton(textStyle: textTheme.titleSmall),
      bodyLarge: neuton(textStyle: textTheme.bodyLarge),
      bodyMedium: neuton(textStyle: textTheme.bodyMedium),
      bodySmall: neuton(textStyle: textTheme.bodySmall),
      labelLarge: neuton(textStyle: textTheme.labelLarge),
      labelMedium: neuton(textStyle: textTheme.labelMedium),
      labelSmall: neuton(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the New Rocker font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/New+Rocker
  static TextStyle newRocker({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '584fbb6ddc084a3cf8c7dde9a333e11adf3da865f332d48991655a950738f46e',
        121920,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NewRocker',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the New Rocker font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/New+Rocker
  static TextTheme newRockerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: newRocker(textStyle: textTheme.displayLarge),
      displayMedium: newRocker(textStyle: textTheme.displayMedium),
      displaySmall: newRocker(textStyle: textTheme.displaySmall),
      headlineLarge: newRocker(textStyle: textTheme.headlineLarge),
      headlineMedium: newRocker(textStyle: textTheme.headlineMedium),
      headlineSmall: newRocker(textStyle: textTheme.headlineSmall),
      titleLarge: newRocker(textStyle: textTheme.titleLarge),
      titleMedium: newRocker(textStyle: textTheme.titleMedium),
      titleSmall: newRocker(textStyle: textTheme.titleSmall),
      bodyLarge: newRocker(textStyle: textTheme.bodyLarge),
      bodyMedium: newRocker(textStyle: textTheme.bodyMedium),
      bodySmall: newRocker(textStyle: textTheme.bodySmall),
      labelLarge: newRocker(textStyle: textTheme.labelLarge),
      labelMedium: newRocker(textStyle: textTheme.labelMedium),
      labelSmall: newRocker(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the New Tegomin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/New+Tegomin
  static TextStyle newTegomin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d635a4defed40130ae791c1a060aa0c612ead29d6d89e74dd96c7ddce590bc2',
        7447024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NewTegomin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the New Tegomin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/New+Tegomin
  static TextTheme newTegominTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: newTegomin(textStyle: textTheme.displayLarge),
      displayMedium: newTegomin(textStyle: textTheme.displayMedium),
      displaySmall: newTegomin(textStyle: textTheme.displaySmall),
      headlineLarge: newTegomin(textStyle: textTheme.headlineLarge),
      headlineMedium: newTegomin(textStyle: textTheme.headlineMedium),
      headlineSmall: newTegomin(textStyle: textTheme.headlineSmall),
      titleLarge: newTegomin(textStyle: textTheme.titleLarge),
      titleMedium: newTegomin(textStyle: textTheme.titleMedium),
      titleSmall: newTegomin(textStyle: textTheme.titleSmall),
      bodyLarge: newTegomin(textStyle: textTheme.bodyLarge),
      bodyMedium: newTegomin(textStyle: textTheme.bodyMedium),
      bodySmall: newTegomin(textStyle: textTheme.bodySmall),
      labelLarge: newTegomin(textStyle: textTheme.labelLarge),
      labelMedium: newTegomin(textStyle: textTheme.labelMedium),
      labelSmall: newTegomin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the News Cycle font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/News+Cycle
  static TextStyle newsCycle({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0089e0113f688ab959045468593016ffd93e6aef4eef731e0203c3c00087ab11',
        177388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82fdd1f50941b8a37647ff9c7f26340c46e81869e1e4f2350ca963e99a1973d2',
        59488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NewsCycle',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the News Cycle font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/News+Cycle
  static TextTheme newsCycleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: newsCycle(textStyle: textTheme.displayLarge),
      displayMedium: newsCycle(textStyle: textTheme.displayMedium),
      displaySmall: newsCycle(textStyle: textTheme.displaySmall),
      headlineLarge: newsCycle(textStyle: textTheme.headlineLarge),
      headlineMedium: newsCycle(textStyle: textTheme.headlineMedium),
      headlineSmall: newsCycle(textStyle: textTheme.headlineSmall),
      titleLarge: newsCycle(textStyle: textTheme.titleLarge),
      titleMedium: newsCycle(textStyle: textTheme.titleMedium),
      titleSmall: newsCycle(textStyle: textTheme.titleSmall),
      bodyLarge: newsCycle(textStyle: textTheme.bodyLarge),
      bodyMedium: newsCycle(textStyle: textTheme.bodyMedium),
      bodySmall: newsCycle(textStyle: textTheme.bodySmall),
      labelLarge: newsCycle(textStyle: textTheme.labelLarge),
      labelMedium: newsCycle(textStyle: textTheme.labelMedium),
      labelSmall: newsCycle(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Newsreader font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Newsreader
  static TextStyle newsreader({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1046c7a061e009f88fdc58791969f5999cf31174e8cd8d5c4044f437a07550aa',
        109172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09cdb18a68c56dac91d53f4bb4f80853376cdebecb912f8c20d31e36c383f50b',
        109452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e57916a6608d8319d2fe2aab76131086c6cf889fe9f144e5909059ae5d2a963a',
        109516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfc5844dd702a7374bfbca74707d70823b329f324b8f730d2f1e0ac0920df1d8',
        111608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46af64a6a049bd0d33cf96a3b390bb10cb4c049028a067e25880dccd3c7deb85',
        111648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b39f0339b03b1c534ff30ac3aa287a61d4f49e2f6650526e33b569c52361f10',
        111564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '041885013d27657ee7820f809b4812063daa0217849bacb86ecc4d7cfa070b66',
        111560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bbdf1e49155c2e55b8bbc64a703bb3cf4a40a2167df4130d9ec4538bb46f7517',
        120344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8e4023919880a8ff057054cebe1d9fdd20f8ce0895684131d01eca7e024e786f',
        120472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2af40965b6aceec5194321f5a98f14136fb13d954d7829ac0c698faeb5c7fbc7',
        119936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8e1f4bfe64000b51af417a84a9b9499d8b0bb435cf7473495c49430978c3296a',
        121940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '77b44dcda98f17b2225d04bebb68aa1793afa06122c4487eeb691122d4fdf03b',
        122124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'eb77219e34fa811cc6ef094bb1e72ab69177b6c87587048ed8f469cae3bc9132',
        122124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6d90dc45e45b5be72f9aab43df3e449e89a416c12fcbd0f976370dbb82f7102d',
        122024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Newsreader',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Newsreader font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Newsreader
  static TextTheme newsreaderTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: newsreader(textStyle: textTheme.displayLarge),
      displayMedium: newsreader(textStyle: textTheme.displayMedium),
      displaySmall: newsreader(textStyle: textTheme.displaySmall),
      headlineLarge: newsreader(textStyle: textTheme.headlineLarge),
      headlineMedium: newsreader(textStyle: textTheme.headlineMedium),
      headlineSmall: newsreader(textStyle: textTheme.headlineSmall),
      titleLarge: newsreader(textStyle: textTheme.titleLarge),
      titleMedium: newsreader(textStyle: textTheme.titleMedium),
      titleSmall: newsreader(textStyle: textTheme.titleSmall),
      bodyLarge: newsreader(textStyle: textTheme.bodyLarge),
      bodyMedium: newsreader(textStyle: textTheme.bodyMedium),
      bodySmall: newsreader(textStyle: textTheme.bodySmall),
      labelLarge: newsreader(textStyle: textTheme.labelLarge),
      labelMedium: newsreader(textStyle: textTheme.labelMedium),
      labelSmall: newsreader(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Niconne font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Niconne
  static TextStyle niconne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e7ae6eb882a3a1b8f79978f6abdc7fd8efac27f8924182bd55cfd68365033e4',
        41456,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Niconne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Niconne font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Niconne
  static TextTheme niconneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: niconne(textStyle: textTheme.displayLarge),
      displayMedium: niconne(textStyle: textTheme.displayMedium),
      displaySmall: niconne(textStyle: textTheme.displaySmall),
      headlineLarge: niconne(textStyle: textTheme.headlineLarge),
      headlineMedium: niconne(textStyle: textTheme.headlineMedium),
      headlineSmall: niconne(textStyle: textTheme.headlineSmall),
      titleLarge: niconne(textStyle: textTheme.titleLarge),
      titleMedium: niconne(textStyle: textTheme.titleMedium),
      titleSmall: niconne(textStyle: textTheme.titleSmall),
      bodyLarge: niconne(textStyle: textTheme.bodyLarge),
      bodyMedium: niconne(textStyle: textTheme.bodyMedium),
      bodySmall: niconne(textStyle: textTheme.bodySmall),
      labelLarge: niconne(textStyle: textTheme.labelLarge),
      labelMedium: niconne(textStyle: textTheme.labelMedium),
      labelSmall: niconne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Niramit font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Niramit
  static TextStyle niramit({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed63ac26196d5c264153fcc115294828419e899e5fcfc0614dfee3b63bb0ee69',
        89528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a26007da3aa227e6ea58d3bdf7a396afb437888debe403de97af653b5a1a4679',
        92352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3134966cfc0cb894d6e7f1a12e1daf1827bd184a3f3f66859b5047c7c2cbddbe',
        89344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e4f5b469110ed6775f9e44bd6c7cef029e0a1e2e5b312b80fc031c66e3c8cfe5',
        91988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a268e1da7107a4e0eef31f952b1aaf133e17adb5139156ec906a10e95b406c33',
        89224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6b7236a14adbca28d36e947beac5acc3cd7371010bafb12e55202773367fb691',
        91860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd31739ad592cfad2dee165e5fdd9bcbdd73f80eb0a445dc6a3c1d4e33dded9ab',
        89172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66f87031bb39a217a51a60cbfb72b98f06c118434ed71ec8d812ed8d720efe92',
        91624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '830dec96589fbb4b1cddbbcaf3b253fd9bd87d0d6698605766706c90846130c3',
        89112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2deebb9c6f8b1bc453f199de39c0e207f9bc2d30e844c5dec5edb1215767f934',
        91760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b30ec8f79dd957f2f830869b8b0f0a6ca66569834b5750ec757ef82f4cbe9ad',
        89328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a03dab539bdf1521767d51c32b68f396d2a5b5e845e2c2b7fb8deeb39c496cc',
        91772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Niramit',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Niramit font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Niramit
  static TextTheme niramitTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: niramit(textStyle: textTheme.displayLarge),
      displayMedium: niramit(textStyle: textTheme.displayMedium),
      displaySmall: niramit(textStyle: textTheme.displaySmall),
      headlineLarge: niramit(textStyle: textTheme.headlineLarge),
      headlineMedium: niramit(textStyle: textTheme.headlineMedium),
      headlineSmall: niramit(textStyle: textTheme.headlineSmall),
      titleLarge: niramit(textStyle: textTheme.titleLarge),
      titleMedium: niramit(textStyle: textTheme.titleMedium),
      titleSmall: niramit(textStyle: textTheme.titleSmall),
      bodyLarge: niramit(textStyle: textTheme.bodyLarge),
      bodyMedium: niramit(textStyle: textTheme.bodyMedium),
      bodySmall: niramit(textStyle: textTheme.bodySmall),
      labelLarge: niramit(textStyle: textTheme.labelLarge),
      labelMedium: niramit(textStyle: textTheme.labelMedium),
      labelSmall: niramit(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nixie One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nixie+One
  static TextStyle nixieOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b46ee55f5dd908d16f21e63433c6d3553618c88c3797688d2a9558575973d66f',
        50900,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NixieOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nixie One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nixie+One
  static TextTheme nixieOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nixieOne(textStyle: textTheme.displayLarge),
      displayMedium: nixieOne(textStyle: textTheme.displayMedium),
      displaySmall: nixieOne(textStyle: textTheme.displaySmall),
      headlineLarge: nixieOne(textStyle: textTheme.headlineLarge),
      headlineMedium: nixieOne(textStyle: textTheme.headlineMedium),
      headlineSmall: nixieOne(textStyle: textTheme.headlineSmall),
      titleLarge: nixieOne(textStyle: textTheme.titleLarge),
      titleMedium: nixieOne(textStyle: textTheme.titleMedium),
      titleSmall: nixieOne(textStyle: textTheme.titleSmall),
      bodyLarge: nixieOne(textStyle: textTheme.bodyLarge),
      bodyMedium: nixieOne(textStyle: textTheme.bodyMedium),
      bodySmall: nixieOne(textStyle: textTheme.bodySmall),
      labelLarge: nixieOne(textStyle: textTheme.labelLarge),
      labelMedium: nixieOne(textStyle: textTheme.labelMedium),
      labelSmall: nixieOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nobile font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nobile
  static TextStyle nobile({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2227947da6f488c1ef4fcabc8a556eb807d44b28b03fbdc42c4e87e19cda808',
        32420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8e5358281a233e3cf74c81c46a90b87a345818a99796b85d89d28c6ddb1ba1d',
        41368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '756ae5cf536c15ca97917892086bf8ebe5051830712e0036ab6cf7b708366f6f',
        36196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4bef821520c7f13d5112ecf986c0c33bf6f7829c90bae221c3631357cec726e7',
        41312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '090770c00ff48f8a7240e284a62690a2995f884d2d0ef7d939753fa7919c5234',
        31652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '628371d0bf26e91d0d5872980907ce7b420a69c87049400ce4fc36eea55a0105',
        41448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Nobile',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nobile font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nobile
  static TextTheme nobileTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nobile(textStyle: textTheme.displayLarge),
      displayMedium: nobile(textStyle: textTheme.displayMedium),
      displaySmall: nobile(textStyle: textTheme.displaySmall),
      headlineLarge: nobile(textStyle: textTheme.headlineLarge),
      headlineMedium: nobile(textStyle: textTheme.headlineMedium),
      headlineSmall: nobile(textStyle: textTheme.headlineSmall),
      titleLarge: nobile(textStyle: textTheme.titleLarge),
      titleMedium: nobile(textStyle: textTheme.titleMedium),
      titleSmall: nobile(textStyle: textTheme.titleSmall),
      bodyLarge: nobile(textStyle: textTheme.bodyLarge),
      bodyMedium: nobile(textStyle: textTheme.bodyMedium),
      bodySmall: nobile(textStyle: textTheme.bodySmall),
      labelLarge: nobile(textStyle: textTheme.labelLarge),
      labelMedium: nobile(textStyle: textTheme.labelMedium),
      labelSmall: nobile(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nokora font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nokora
  static TextStyle nokora({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc4a1bbbd3cc3b34f022349bcb6b28ca2dc752d4bef90b454c8f84c8d50af826',
        33112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98033eaf7f49275cc903253086b31dd72bbf05aaacd0f07d58537532ea4f4bd6',
        32056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1209f186e26f338a8da618ae061b624c07b934ff38211a2b1096d6b99a67f296',
        33632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5a52f2db3bfb1525b0db3d6a49f64994f759af15539259e92f8a1d9cac9000c',
        32972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de95bb52e35187386b3fb9fb044a6cb99bef9295f4779e9b331c148fd5141e07',
        33028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Nokora',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nokora font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nokora
  static TextTheme nokoraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nokora(textStyle: textTheme.displayLarge),
      displayMedium: nokora(textStyle: textTheme.displayMedium),
      displaySmall: nokora(textStyle: textTheme.displaySmall),
      headlineLarge: nokora(textStyle: textTheme.headlineLarge),
      headlineMedium: nokora(textStyle: textTheme.headlineMedium),
      headlineSmall: nokora(textStyle: textTheme.headlineSmall),
      titleLarge: nokora(textStyle: textTheme.titleLarge),
      titleMedium: nokora(textStyle: textTheme.titleMedium),
      titleSmall: nokora(textStyle: textTheme.titleSmall),
      bodyLarge: nokora(textStyle: textTheme.bodyLarge),
      bodyMedium: nokora(textStyle: textTheme.bodyMedium),
      bodySmall: nokora(textStyle: textTheme.bodySmall),
      labelLarge: nokora(textStyle: textTheme.labelLarge),
      labelMedium: nokora(textStyle: textTheme.labelMedium),
      labelSmall: nokora(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Norican font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Norican
  static TextStyle norican({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41bf6b2ebdc2639a8fdf67bdc0fcc55ae0960a6434150d8b6d6f0ddab5248703',
        52792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Norican',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Norican font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Norican
  static TextTheme noricanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: norican(textStyle: textTheme.displayLarge),
      displayMedium: norican(textStyle: textTheme.displayMedium),
      displaySmall: norican(textStyle: textTheme.displaySmall),
      headlineLarge: norican(textStyle: textTheme.headlineLarge),
      headlineMedium: norican(textStyle: textTheme.headlineMedium),
      headlineSmall: norican(textStyle: textTheme.headlineSmall),
      titleLarge: norican(textStyle: textTheme.titleLarge),
      titleMedium: norican(textStyle: textTheme.titleMedium),
      titleSmall: norican(textStyle: textTheme.titleSmall),
      bodyLarge: norican(textStyle: textTheme.bodyLarge),
      bodyMedium: norican(textStyle: textTheme.bodyMedium),
      bodySmall: norican(textStyle: textTheme.bodySmall),
      labelLarge: norican(textStyle: textTheme.labelLarge),
      labelMedium: norican(textStyle: textTheme.labelMedium),
      labelSmall: norican(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nosifer font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nosifer
  static TextStyle nosifer({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa5ab6f4f00562ef34a63d1f0dbcb108c153dcb936fb0447185e70ac42daeae5',
        41152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Nosifer',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nosifer font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nosifer
  static TextTheme nosiferTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nosifer(textStyle: textTheme.displayLarge),
      displayMedium: nosifer(textStyle: textTheme.displayMedium),
      displaySmall: nosifer(textStyle: textTheme.displaySmall),
      headlineLarge: nosifer(textStyle: textTheme.headlineLarge),
      headlineMedium: nosifer(textStyle: textTheme.headlineMedium),
      headlineSmall: nosifer(textStyle: textTheme.headlineSmall),
      titleLarge: nosifer(textStyle: textTheme.titleLarge),
      titleMedium: nosifer(textStyle: textTheme.titleMedium),
      titleSmall: nosifer(textStyle: textTheme.titleSmall),
      bodyLarge: nosifer(textStyle: textTheme.bodyLarge),
      bodyMedium: nosifer(textStyle: textTheme.bodyMedium),
      bodySmall: nosifer(textStyle: textTheme.bodySmall),
      labelLarge: nosifer(textStyle: textTheme.labelLarge),
      labelMedium: nosifer(textStyle: textTheme.labelMedium),
      labelSmall: nosifer(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Notable font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Notable
  static TextStyle notable({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c596373178a4369da14982762a1d6c36412b593d64631b8a1962ce9979fc42c',
        24620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Notable',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Notable font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Notable
  static TextTheme notableTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notable(textStyle: textTheme.displayLarge),
      displayMedium: notable(textStyle: textTheme.displayMedium),
      displaySmall: notable(textStyle: textTheme.displaySmall),
      headlineLarge: notable(textStyle: textTheme.headlineLarge),
      headlineMedium: notable(textStyle: textTheme.headlineMedium),
      headlineSmall: notable(textStyle: textTheme.headlineSmall),
      titleLarge: notable(textStyle: textTheme.titleLarge),
      titleMedium: notable(textStyle: textTheme.titleMedium),
      titleSmall: notable(textStyle: textTheme.titleSmall),
      bodyLarge: notable(textStyle: textTheme.bodyLarge),
      bodyMedium: notable(textStyle: textTheme.bodyMedium),
      bodySmall: notable(textStyle: textTheme.bodySmall),
      labelLarge: notable(textStyle: textTheme.labelLarge),
      labelMedium: notable(textStyle: textTheme.labelMedium),
      labelSmall: notable(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nothing You Could Do font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nothing+You+Could+Do
  static TextStyle nothingYouCouldDo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c51730c293b2041740683a5b8fc4fccb6245f5438b8bd10ea5f0c71d5140b075',
        31704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NothingYouCouldDo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nothing You Could Do font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nothing+You+Could+Do
  static TextTheme nothingYouCouldDoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nothingYouCouldDo(textStyle: textTheme.displayLarge),
      displayMedium: nothingYouCouldDo(textStyle: textTheme.displayMedium),
      displaySmall: nothingYouCouldDo(textStyle: textTheme.displaySmall),
      headlineLarge: nothingYouCouldDo(textStyle: textTheme.headlineLarge),
      headlineMedium: nothingYouCouldDo(textStyle: textTheme.headlineMedium),
      headlineSmall: nothingYouCouldDo(textStyle: textTheme.headlineSmall),
      titleLarge: nothingYouCouldDo(textStyle: textTheme.titleLarge),
      titleMedium: nothingYouCouldDo(textStyle: textTheme.titleMedium),
      titleSmall: nothingYouCouldDo(textStyle: textTheme.titleSmall),
      bodyLarge: nothingYouCouldDo(textStyle: textTheme.bodyLarge),
      bodyMedium: nothingYouCouldDo(textStyle: textTheme.bodyMedium),
      bodySmall: nothingYouCouldDo(textStyle: textTheme.bodySmall),
      labelLarge: nothingYouCouldDo(textStyle: textTheme.labelLarge),
      labelMedium: nothingYouCouldDo(textStyle: textTheme.labelMedium),
      labelSmall: nothingYouCouldDo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noticia Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noticia+Text
  static TextStyle noticiaText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a6b0624004ff6f56f2f1113f003ed60720ca8b68025b6bafed6eed114440d9b',
        61616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a46a8d57965e4563a06bd3819575df42a02f47b861ccfb0aa66ad05d67e28194',
        62980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1dc31f473cda60b764d6f694778479b4dbcb97ad540b8e5dc12ed01c1c04833b',
        60756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a50238388b7e42bd69c9bc67fb426e8e35afeb5fce0f35bf8875b9b9c230ff05',
        61952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NoticiaText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noticia Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noticia+Text
  static TextTheme noticiaTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: noticiaText(textStyle: textTheme.displayLarge),
      displayMedium: noticiaText(textStyle: textTheme.displayMedium),
      displaySmall: noticiaText(textStyle: textTheme.displaySmall),
      headlineLarge: noticiaText(textStyle: textTheme.headlineLarge),
      headlineMedium: noticiaText(textStyle: textTheme.headlineMedium),
      headlineSmall: noticiaText(textStyle: textTheme.headlineSmall),
      titleLarge: noticiaText(textStyle: textTheme.titleLarge),
      titleMedium: noticiaText(textStyle: textTheme.titleMedium),
      titleSmall: noticiaText(textStyle: textTheme.titleSmall),
      bodyLarge: noticiaText(textStyle: textTheme.bodyLarge),
      bodyMedium: noticiaText(textStyle: textTheme.bodyMedium),
      bodySmall: noticiaText(textStyle: textTheme.bodySmall),
      labelLarge: noticiaText(textStyle: textTheme.labelLarge),
      labelMedium: noticiaText(textStyle: textTheme.labelMedium),
      labelSmall: noticiaText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Color Emoji font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Color+Emoji
  static TextStyle notoColorEmoji({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a98676580777f4f555d83287fb6e515f7450a7eae58466cbd1f4fed32ee03aaa',
        24015012,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoColorEmoji',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Color Emoji font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Color+Emoji
  static TextTheme notoColorEmojiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoColorEmoji(textStyle: textTheme.displayLarge),
      displayMedium: notoColorEmoji(textStyle: textTheme.displayMedium),
      displaySmall: notoColorEmoji(textStyle: textTheme.displaySmall),
      headlineLarge: notoColorEmoji(textStyle: textTheme.headlineLarge),
      headlineMedium: notoColorEmoji(textStyle: textTheme.headlineMedium),
      headlineSmall: notoColorEmoji(textStyle: textTheme.headlineSmall),
      titleLarge: notoColorEmoji(textStyle: textTheme.titleLarge),
      titleMedium: notoColorEmoji(textStyle: textTheme.titleMedium),
      titleSmall: notoColorEmoji(textStyle: textTheme.titleSmall),
      bodyLarge: notoColorEmoji(textStyle: textTheme.bodyLarge),
      bodyMedium: notoColorEmoji(textStyle: textTheme.bodyMedium),
      bodySmall: notoColorEmoji(textStyle: textTheme.bodySmall),
      labelLarge: notoColorEmoji(textStyle: textTheme.labelLarge),
      labelMedium: notoColorEmoji(textStyle: textTheme.labelMedium),
      labelSmall: notoColorEmoji(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Emoji font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Emoji
  static TextStyle notoEmoji({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3c638a6dd16af7be203c392ac22ea5f2caade3ce70117a95380ea413661f537',
        877996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76265f243371d58d9894b937342ecf046b5a207e135266f2398a6cc6da05ffdc',
        877988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e459db86ade2e3833b4b39a44cef8fc1fbd5cf705d6e025bbeaa88d9d608ddec',
        878172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ef9bd29fc791fc9bd66d54df4583ca80fb2a13bb4dff8bf283deeaf6d7e7c2a',
        878024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd61b89360653b70b5f755d222649783bc417224b009b50b35fd82f5eb4d39a6f',
        876524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoEmoji',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Emoji font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Emoji
  static TextTheme notoEmojiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoEmoji(textStyle: textTheme.displayLarge),
      displayMedium: notoEmoji(textStyle: textTheme.displayMedium),
      displaySmall: notoEmoji(textStyle: textTheme.displaySmall),
      headlineLarge: notoEmoji(textStyle: textTheme.headlineLarge),
      headlineMedium: notoEmoji(textStyle: textTheme.headlineMedium),
      headlineSmall: notoEmoji(textStyle: textTheme.headlineSmall),
      titleLarge: notoEmoji(textStyle: textTheme.titleLarge),
      titleMedium: notoEmoji(textStyle: textTheme.titleMedium),
      titleSmall: notoEmoji(textStyle: textTheme.titleSmall),
      bodyLarge: notoEmoji(textStyle: textTheme.bodyLarge),
      bodyMedium: notoEmoji(textStyle: textTheme.bodyMedium),
      bodySmall: notoEmoji(textStyle: textTheme.bodySmall),
      labelLarge: notoEmoji(textStyle: textTheme.labelLarge),
      labelMedium: notoEmoji(textStyle: textTheme.labelMedium),
      labelSmall: notoEmoji(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Kufi Arabic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Kufi+Arabic
  static TextStyle notoKufiArabic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33aa4d2d839fcd3011897ca2140a205ed84a353143baeb4bd3989b7a8122aef8',
        119036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71cd91ba5ab1ac2359e1018feead3f7fc295ce0f109389ec83d03f0da75af260',
        119600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8204f31caa3609e71cdab18e11cf41e0d150da66655717583794913c5446af78',
        119512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2cdee3977825aa865a22ae34a8db588af01d6ea68752ddb44a668c1312fbaa59',
        118252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09b00dc222bffe4e5ea7d005438521c1ca26b3920b31bc630aebb1e885f8ae70',
        119052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b90cb8dd404c7f885ee8f61b9159710a1178c885edb59a4e5676837e838a4a1d',
        119144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4819e260361d5187aaccc9b41a2eb7ab085ff2162fc2d3c94fa5f8a8dddae9a2',
        118328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bed7d1a627d55671ef052dd1b5ecbfd23b75c7689b566af8f887083689581c3b',
        119904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9bd7fb007238e4b82094dfde2432afeed4e24aa52a66a82a2f8e70d5634be5a',
        119768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoKufiArabic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Kufi Arabic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Kufi+Arabic
  static TextTheme notoKufiArabicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoKufiArabic(textStyle: textTheme.displayLarge),
      displayMedium: notoKufiArabic(textStyle: textTheme.displayMedium),
      displaySmall: notoKufiArabic(textStyle: textTheme.displaySmall),
      headlineLarge: notoKufiArabic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoKufiArabic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoKufiArabic(textStyle: textTheme.headlineSmall),
      titleLarge: notoKufiArabic(textStyle: textTheme.titleLarge),
      titleMedium: notoKufiArabic(textStyle: textTheme.titleMedium),
      titleSmall: notoKufiArabic(textStyle: textTheme.titleSmall),
      bodyLarge: notoKufiArabic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoKufiArabic(textStyle: textTheme.bodyMedium),
      bodySmall: notoKufiArabic(textStyle: textTheme.bodySmall),
      labelLarge: notoKufiArabic(textStyle: textTheme.labelLarge),
      labelMedium: notoKufiArabic(textStyle: textTheme.labelMedium),
      labelSmall: notoKufiArabic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Music font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Music
  static TextStyle notoMusic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12f5b20075b0ebd4e80bf54e093b218fe0c9bd3661e6193760d8f3046ccb86a9',
        115340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoMusic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Music font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Music
  static TextTheme notoMusicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoMusic(textStyle: textTheme.displayLarge),
      displayMedium: notoMusic(textStyle: textTheme.displayMedium),
      displaySmall: notoMusic(textStyle: textTheme.displaySmall),
      headlineLarge: notoMusic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoMusic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoMusic(textStyle: textTheme.headlineSmall),
      titleLarge: notoMusic(textStyle: textTheme.titleLarge),
      titleMedium: notoMusic(textStyle: textTheme.titleMedium),
      titleSmall: notoMusic(textStyle: textTheme.titleSmall),
      bodyLarge: notoMusic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoMusic(textStyle: textTheme.bodyMedium),
      bodySmall: notoMusic(textStyle: textTheme.bodySmall),
      labelLarge: notoMusic(textStyle: textTheme.labelLarge),
      labelMedium: notoMusic(textStyle: textTheme.labelMedium),
      labelSmall: notoMusic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Naskh Arabic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Naskh+Arabic
  static TextStyle notoNaskhArabic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9b19ea721911d4158bec0e2fdb8d389524ef56448d2a8e24e501abdccc53c9b',
        188564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc7be025a7e303d96ec4c5988dd7a636747da5abd0f676267ce5e1a414915e15',
        189280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8832db7567a4ceb8ff2add137a23d4a2caf7304f0b7d821f642acdf7fb9ea37',
        189180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b922a15359885fa82f62b2de4bbc38a0f7e14170e33f1f41fea2ed66f4802d85',
        188720,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoNaskhArabic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Naskh Arabic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Naskh+Arabic
  static TextTheme notoNaskhArabicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoNaskhArabic(textStyle: textTheme.displayLarge),
      displayMedium: notoNaskhArabic(textStyle: textTheme.displayMedium),
      displaySmall: notoNaskhArabic(textStyle: textTheme.displaySmall),
      headlineLarge: notoNaskhArabic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoNaskhArabic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoNaskhArabic(textStyle: textTheme.headlineSmall),
      titleLarge: notoNaskhArabic(textStyle: textTheme.titleLarge),
      titleMedium: notoNaskhArabic(textStyle: textTheme.titleMedium),
      titleSmall: notoNaskhArabic(textStyle: textTheme.titleSmall),
      bodyLarge: notoNaskhArabic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoNaskhArabic(textStyle: textTheme.bodyMedium),
      bodySmall: notoNaskhArabic(textStyle: textTheme.bodySmall),
      labelLarge: notoNaskhArabic(textStyle: textTheme.labelLarge),
      labelMedium: notoNaskhArabic(textStyle: textTheme.labelMedium),
      labelSmall: notoNaskhArabic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Nastaliq Urdu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Nastaliq+Urdu
  static TextStyle notoNastaliqUrdu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2aacf1112ffb91ed5fd97d9326dfbb3358dbeede2fb1d720b6b740e378c1a72',
        527596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b90b8121e265e1a3505cc387b283e0055bfcd22745bd3fb3ae99caddcc51225',
        529524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '245b10e3f362b133ebd939a152c0fbd1542aadd13641d5c6fe94f258aa4f37dc',
        529436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b515fb56f2e42b87ceedfc60c894104e6afd4905b97197842bbbe3d528a42544',
        528464,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoNastaliqUrdu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Nastaliq Urdu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Nastaliq+Urdu
  static TextTheme notoNastaliqUrduTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoNastaliqUrdu(textStyle: textTheme.displayLarge),
      displayMedium: notoNastaliqUrdu(textStyle: textTheme.displayMedium),
      displaySmall: notoNastaliqUrdu(textStyle: textTheme.displaySmall),
      headlineLarge: notoNastaliqUrdu(textStyle: textTheme.headlineLarge),
      headlineMedium: notoNastaliqUrdu(textStyle: textTheme.headlineMedium),
      headlineSmall: notoNastaliqUrdu(textStyle: textTheme.headlineSmall),
      titleLarge: notoNastaliqUrdu(textStyle: textTheme.titleLarge),
      titleMedium: notoNastaliqUrdu(textStyle: textTheme.titleMedium),
      titleSmall: notoNastaliqUrdu(textStyle: textTheme.titleSmall),
      bodyLarge: notoNastaliqUrdu(textStyle: textTheme.bodyLarge),
      bodyMedium: notoNastaliqUrdu(textStyle: textTheme.bodyMedium),
      bodySmall: notoNastaliqUrdu(textStyle: textTheme.bodySmall),
      labelLarge: notoNastaliqUrdu(textStyle: textTheme.labelLarge),
      labelMedium: notoNastaliqUrdu(textStyle: textTheme.labelMedium),
      labelSmall: notoNastaliqUrdu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Rashi Hebrew font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Rashi+Hebrew
  static TextStyle notoRashiHebrew({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab9382f6122f61816182efa4129aeef720f0dcaac78ad8a016cefadc91a284a8',
        47468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '99b805fe37495bed315f34c4ce5c212f5995a48aea88dd6685c200d9463a07cd',
        47524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '342dd2dc03e229280c4fe0b468bed4c8f30a50252c080395a37a59dc375cf2e5',
        47504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c9819fe8079b3f64ffbcda78ca0ba2d184e8ea4e8cc2f0255a5af629174eff5',
        47492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7f0f6f8fab7ac60c9c869fa45305cbcb5526489e6ae4be1e92b9905d1e2110c',
        47512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f94a7cb8db625b79ec4d88998df04f1e5889403331f78d26d9530dbec0b8ddd',
        47556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '922c8e60bdc008b785387812285172ca13ccfc8dd8ea37c4991d8225ade60a4b',
        47524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c57aa91930696e4e640db7a80c7c000dc8d715b12258cf108c3b66b56ca859f',
        47604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0045d4b70f9631f313c832488e86e52f7b97280b70de73d8dda1d473c94266d7',
        47504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoRashiHebrew',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Rashi Hebrew font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Rashi+Hebrew
  static TextTheme notoRashiHebrewTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoRashiHebrew(textStyle: textTheme.displayLarge),
      displayMedium: notoRashiHebrew(textStyle: textTheme.displayMedium),
      displaySmall: notoRashiHebrew(textStyle: textTheme.displaySmall),
      headlineLarge: notoRashiHebrew(textStyle: textTheme.headlineLarge),
      headlineMedium: notoRashiHebrew(textStyle: textTheme.headlineMedium),
      headlineSmall: notoRashiHebrew(textStyle: textTheme.headlineSmall),
      titleLarge: notoRashiHebrew(textStyle: textTheme.titleLarge),
      titleMedium: notoRashiHebrew(textStyle: textTheme.titleMedium),
      titleSmall: notoRashiHebrew(textStyle: textTheme.titleSmall),
      bodyLarge: notoRashiHebrew(textStyle: textTheme.bodyLarge),
      bodyMedium: notoRashiHebrew(textStyle: textTheme.bodyMedium),
      bodySmall: notoRashiHebrew(textStyle: textTheme.bodySmall),
      labelLarge: notoRashiHebrew(textStyle: textTheme.labelLarge),
      labelMedium: notoRashiHebrew(textStyle: textTheme.labelMedium),
      labelSmall: notoRashiHebrew(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans
  static TextStyle notoSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc6ceb177561b27cfb9123c0dd372a54774cb6bcebe4ce18c12706bbb7ee902c',
        523812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '807ad06b65dbbaf657e4a7dcb6d2b0734c8831cd21a1f9172387ad0411cc396f',
        524708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e3e9bb50c6e6ade7e4a491bf0033d6b6ec3326a2621834201e735691cec4968',
        524492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '725edd9b341324f91a3859e24824c455d43c31be72ca6e710acd0f95920d61ee',
        523940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a77c7c7a4d75c23c5e68bcff3d44f71eb1ec0f80fe245457053ea43a4ce61bd4',
        524252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc5b5ba2d400f44b0686c46db557e6b8067a97ade7337f14f823f524675c038c',
        524444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '222685dcf83610e3e88a0ecd4c602efde7a7b832832502649bfe2dcf1aa0bf15',
        523772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6e87f6834db59a2a64ce43dce2fdc1aa3441f2a23afb0bfd667621403ed688c',
        524672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ead4fec44c3271cf7dc5d9f74795eb05fa9fb3cedc7bde3232eb10573d5f6cd',
        524708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8b32677abe42a47cdade4998d4124a3e1b44efa656c5badf27de546768c82f0d',
        541316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd64c291d542bb1211538aa1448a7f6bbaca4dbd170e78b8b8242be5c9ff28959',
        541752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3a902e6bbe1ffba43428cb2981f1185ef529505836c311af5f6e5690bf9b44c8',
        541688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d23478749575c0febb6169fc3dba6cb8cdb4202e8fb47ae1867c71a21792295',
        539972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '085819a42ab67069f29329ae066ff8206a4b518bf6496dbf1193284f891fdbd1',
        540456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ecb66a73df07fac622c73fdc0e4972bd51f50165367807433d7fc620378f9577',
        540608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f72d0f7c9c7279b2762017fbafa2bcd9aaccdf7a79b8cf686f874e2eeb0e51ce',
        540016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0ef3e94eb6875007204e41604898141fa5104f7e20b87cb5640509a8f10430b5',
        540812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b0e0148ef878a4ca6a295b6b56b1bfb4773400ff8ee0a31a1338285725dd514f',
        540396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans
  static TextTheme notoSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSans(textStyle: textTheme.displayLarge),
      displayMedium: notoSans(textStyle: textTheme.displayMedium),
      displaySmall: notoSans(textStyle: textTheme.displaySmall),
      headlineLarge: notoSans(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSans(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSans(textStyle: textTheme.headlineSmall),
      titleLarge: notoSans(textStyle: textTheme.titleLarge),
      titleMedium: notoSans(textStyle: textTheme.titleMedium),
      titleSmall: notoSans(textStyle: textTheme.titleSmall),
      bodyLarge: notoSans(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSans(textStyle: textTheme.bodyMedium),
      bodySmall: notoSans(textStyle: textTheme.bodySmall),
      labelLarge: notoSans(textStyle: textTheme.labelLarge),
      labelMedium: notoSans(textStyle: textTheme.labelMedium),
      labelSmall: notoSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Adlam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Adlam
  static TextStyle notoSansAdlam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c8dedb511ad901f614cf568a8b0ca22bda81831c2beeceae9d82f71433b0a04',
        85004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43e5e1f49fbf558b8b3630c55464629897775f2c9ff2ed11714a2bb1b65cfa39',
        85056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '420b7b5ed1567ea22753adc07ce847c175474160579542f61faa4d053a2029e5',
        85068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7dd248cf77d63a209aa504f02b04fc40257d5c200cb599f0d243fcb576dda11',
        84956,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansAdlam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Adlam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Adlam
  static TextTheme notoSansAdlamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansAdlam(textStyle: textTheme.displayLarge),
      displayMedium: notoSansAdlam(textStyle: textTheme.displayMedium),
      displaySmall: notoSansAdlam(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansAdlam(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansAdlam(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansAdlam(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansAdlam(textStyle: textTheme.titleLarge),
      titleMedium: notoSansAdlam(textStyle: textTheme.titleMedium),
      titleSmall: notoSansAdlam(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansAdlam(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansAdlam(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansAdlam(textStyle: textTheme.bodySmall),
      labelLarge: notoSansAdlam(textStyle: textTheme.labelLarge),
      labelMedium: notoSansAdlam(textStyle: textTheme.labelMedium),
      labelSmall: notoSansAdlam(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Adlam Unjoined font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Adlam+Unjoined
  static TextStyle notoSansAdlamUnjoined({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bad08dd07ae4cac28eed4a883b8474e3d4b3efe04eca2b3010021ee46664b0fd',
        48340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cb48e27c887c115ea62c23668395853aa0c38e7b817dd8ac98a23b7bad5d4df6',
        48392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1c21204d1e81cabc13e04f173dd96c93dcac92a1a2b41318b5763301c407408',
        48408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a231ab0ec7ca38fc98f49cd0cddd5da8c604bb8cee9f83b0f8eac8204d40435e',
        48308,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansAdlamUnjoined',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Adlam Unjoined font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Adlam+Unjoined
  static TextTheme notoSansAdlamUnjoinedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansAdlamUnjoined(textStyle: textTheme.displayLarge),
      displayMedium: notoSansAdlamUnjoined(textStyle: textTheme.displayMedium),
      displaySmall: notoSansAdlamUnjoined(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansAdlamUnjoined(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansAdlamUnjoined(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansAdlamUnjoined(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansAdlamUnjoined(textStyle: textTheme.titleLarge),
      titleMedium: notoSansAdlamUnjoined(textStyle: textTheme.titleMedium),
      titleSmall: notoSansAdlamUnjoined(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansAdlamUnjoined(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansAdlamUnjoined(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansAdlamUnjoined(textStyle: textTheme.bodySmall),
      labelLarge: notoSansAdlamUnjoined(textStyle: textTheme.labelLarge),
      labelMedium: notoSansAdlamUnjoined(textStyle: textTheme.labelMedium),
      labelSmall: notoSansAdlamUnjoined(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Anatolian Hieroglyphs font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Anatolian+Hieroglyphs
  static TextStyle notoSansAnatolianHieroglyphs({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '636f10e414038c0e12f27e89b59317ddb38a04b6e192bd612be18bf09cc6b049',
        258700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansAnatolianHieroglyphs',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Anatolian Hieroglyphs font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Anatolian+Hieroglyphs
  static TextTheme notoSansAnatolianHieroglyphsTextTheme(
      [TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          notoSansAnatolianHieroglyphs(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansAnatolianHieroglyphs(textStyle: textTheme.displayMedium),
      displaySmall:
          notoSansAnatolianHieroglyphs(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansAnatolianHieroglyphs(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansAnatolianHieroglyphs(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansAnatolianHieroglyphs(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansAnatolianHieroglyphs(textStyle: textTheme.titleLarge),
      titleMedium:
          notoSansAnatolianHieroglyphs(textStyle: textTheme.titleMedium),
      titleSmall: notoSansAnatolianHieroglyphs(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansAnatolianHieroglyphs(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansAnatolianHieroglyphs(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansAnatolianHieroglyphs(textStyle: textTheme.bodySmall),
      labelLarge: notoSansAnatolianHieroglyphs(textStyle: textTheme.labelLarge),
      labelMedium:
          notoSansAnatolianHieroglyphs(textStyle: textTheme.labelMedium),
      labelSmall: notoSansAnatolianHieroglyphs(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Arabic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Arabic
  static TextStyle notoSansArabic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6cf2614bfc2885011fd9d47b2bcc7e5a576b3e35d379d4301d8247683a680245',
        162152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cecf509869241973813ea04cf6c437ff1e571722fcd54e329880185baf750b19',
        162412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5219bd6425340861eb21a05d40d54da31875cb534dd128d5799b6b83674b9d1',
        162324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25c2bf5bc8222800e2d8887c3af985f61d5803177bd92b355cb8bffa09c48862',
        161592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47f226b1505792703ac273600be1dbce8c3cc83cd1981b3db5ef15e0f09bdd8a',
        162156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '332c2d597ed4d1f4d1ed84ed493a341cf81515f5e4d392789a4764e084ff4f1f',
        162512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9235e0a73b449ef9a790df7bf5933644ede59c06099f7e96d8cda26c999641cd',
        162268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3614725eeafdb55d8eeabb81fb6fb294a807327fa01c2230b4e074f56922d0b5',
        162896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cdbb85b809be063fb065f55b7226dc5161f4804795be56e007d7d3ce70208446',
        162668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansArabic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Arabic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Arabic
  static TextTheme notoSansArabicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansArabic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansArabic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansArabic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansArabic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansArabic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansArabic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansArabic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansArabic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansArabic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansArabic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansArabic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansArabic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansArabic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansArabic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansArabic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Armenian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Armenian
  static TextStyle notoSansArmenian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6cbdd46710ee0f5f2fb8534bfc01dd00c3e146122ca20a8cf7e21418c1877da4',
        48468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1de7495602427f14ec469bf52e796810877fe16d7efa7a0ccfcbc8682544ff9d',
        48580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c8e82d6e653212683d043343ffa086bd69788b58d3bc76c3351b88b92ff68cd',
        48512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd3aa38f74773645d0c0d42996386f914ecf8a9a8e8fc8bdd5ee20d386394e2b',
        48364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5241fda9844f9ccf7e4e3e820a8b151a59e50ec8b08ec903241b5830cf4ed6e9',
        48424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46d1608a43e9fcdaa0f17eee822275f50c3cf7371cb01a923249a89e521a2953',
        48428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d44a7b2a48f2a56fedd1c203735c64cabe8c9018a95993c66bf0cef4a851281',
        48388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e08c09f35dc340aa377617d8fdbad4c22632789a16a5bd825ec521c77323b970',
        48464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0638747376eb7086c6434a6290cc70300e8e977b919be88239dc6abf71c88454',
        48364,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansArmenian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Armenian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Armenian
  static TextTheme notoSansArmenianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansArmenian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansArmenian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansArmenian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansArmenian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansArmenian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansArmenian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansArmenian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansArmenian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansArmenian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansArmenian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansArmenian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansArmenian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansArmenian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansArmenian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansArmenian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Avestan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Avestan
  static TextStyle notoSansAvestan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc51706add61fda7aaa2bf0947f49eb7295ec5f8c0aa6f5c583df0f2ec3fc157',
        39400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansAvestan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Avestan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Avestan
  static TextTheme notoSansAvestanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansAvestan(textStyle: textTheme.displayLarge),
      displayMedium: notoSansAvestan(textStyle: textTheme.displayMedium),
      displaySmall: notoSansAvestan(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansAvestan(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansAvestan(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansAvestan(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansAvestan(textStyle: textTheme.titleLarge),
      titleMedium: notoSansAvestan(textStyle: textTheme.titleMedium),
      titleSmall: notoSansAvestan(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansAvestan(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansAvestan(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansAvestan(textStyle: textTheme.bodySmall),
      labelLarge: notoSansAvestan(textStyle: textTheme.labelLarge),
      labelMedium: notoSansAvestan(textStyle: textTheme.labelMedium),
      labelSmall: notoSansAvestan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Balinese font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Balinese
  static TextStyle notoSansBalinese({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6edddc1d9a02d8f69d3d10c37f8291ee96311725e3c03dfaba7e19d463e069ca',
        121876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec4eefcb6e02f26391242a8d79d18ed923af5e558c539f106dab922c110a94f5',
        122024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e5414b316e49cc5ef80e90143dc3faf1ef8e7b85e87b426590e03bf19c792893',
        122056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dfeaaf403d67cebea8d7bbc68d7ba7f95c686006f9d5559761a56e5e6f3dc4e5',
        121868,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBalinese',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Balinese font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Balinese
  static TextTheme notoSansBalineseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBalinese(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBalinese(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBalinese(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBalinese(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBalinese(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBalinese(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBalinese(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBalinese(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBalinese(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBalinese(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBalinese(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBalinese(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBalinese(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBalinese(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBalinese(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Bamum font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Bamum
  static TextStyle notoSansBamum({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71cb4a175a6ff276bca4b057c3d362656053319fb9706450424e59dbe6fc4fcb',
        179836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a7ee525ef673cc2222933d5d05486f0183d6f4672ea8a5de87daab0080f382d',
        179840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b459262fa09e092e18513ddd49098119690f759ebc1a7f7039ba588b6e7b383c',
        179884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee2abe988093616b669987c62b0d1f509b9ccdb1c56cbd73777711743de7d6e9',
        179848,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBamum',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Bamum font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Bamum
  static TextTheme notoSansBamumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBamum(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBamum(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBamum(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBamum(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBamum(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBamum(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBamum(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBamum(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBamum(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBamum(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBamum(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBamum(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBamum(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBamum(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBamum(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Bassa Vah font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Bassa+Vah
  static TextStyle notoSansBassaVah({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f9e562c3e86e11eeb7176930bfae4799df88667028bed4e1e69d02e1ce9ef69',
        39520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '383e7b57d7bc5f4005b409269e58461dbde05e809707f7704a589ce540d133be',
        39564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac2d586d228c63817965b39e54225217966b079c34b3945a1afb2fdd55f22f5c',
        39568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe49bb4acd437be8876059db3c0de64b9f0b95c9741c2afea6f8e1c201c0fb34',
        39472,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBassaVah',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Bassa Vah font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Bassa+Vah
  static TextTheme notoSansBassaVahTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBassaVah(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBassaVah(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBassaVah(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBassaVah(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBassaVah(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBassaVah(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBassaVah(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBassaVah(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBassaVah(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBassaVah(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBassaVah(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBassaVah(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBassaVah(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBassaVah(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBassaVah(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Batak font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Batak
  static TextStyle notoSansBatak({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1d2adf3d391af9b323eea890393450968fca080098dc63cdf96a366dd7e87ee',
        49988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBatak',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Batak font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Batak
  static TextTheme notoSansBatakTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBatak(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBatak(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBatak(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBatak(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBatak(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBatak(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBatak(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBatak(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBatak(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBatak(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBatak(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBatak(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBatak(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBatak(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBatak(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Bengali font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Bengali
  static TextStyle notoSansBengali({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac2ddda5349f79c00e75045a96ad9c4fbbd48c37c953a58de151ce2feace96db',
        166560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b58df7ab4fa7bffd0a2e94e0828abf0d8154ea4deb4ecb1ad53896af34bfe506',
        166784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '076702a4afeff1b6a7ef465887bfa9a92c8385a24f0be50bc786f4202d5e78ef',
        166812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3dc6b3e4b19e7f42df44e0f70c8ab3274294f3b409c90ef12a67ed8e965a0aa',
        166544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14be02597af57bd3506d510f7352c9873dbac03f9f44c9c3aec6973d920b651e',
        166856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36eea003bd6914f7db6cc6fbfc1d41986fec5fc6b1db0cf32a21086304ca148a',
        166960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cdc459ab686d4a03d3ac6c028afb1ba565ec5300210ddf75eb312a81bc9aff5a',
        166716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fba286dec7ae14fbb8b05a02ba50b50ff5633ed4c4792d9221d6ac1d338b7edf',
        166940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00e435b491d401949e5f44c406dc354069d34da6031528ce2f098bf93c66f880',
        166872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBengali',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Bengali font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Bengali
  static TextTheme notoSansBengaliTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBengali(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBengali(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBengali(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBengali(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBengali(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBengali(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBengali(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBengali(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBengali(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBengali(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBengali(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBengali(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBengali(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBengali(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBengali(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Bhaiksuki font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Bhaiksuki
  static TextStyle notoSansBhaiksuki({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe10831b6ec284cbca40dcac463794c01cccc4f12aa2c26ae484c6f8843ce82c',
        270088,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBhaiksuki',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Bhaiksuki font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Bhaiksuki
  static TextTheme notoSansBhaiksukiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBhaiksuki(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBhaiksuki(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBhaiksuki(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBhaiksuki(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBhaiksuki(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBhaiksuki(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBhaiksuki(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBhaiksuki(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBhaiksuki(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBhaiksuki(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBhaiksuki(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBhaiksuki(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBhaiksuki(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBhaiksuki(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBhaiksuki(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Brahmi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Brahmi
  static TextStyle notoSansBrahmi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5387cf69e4363d44b4d9b645b15d3b0e92348ab0aae40e4c3fc8a3f6c29b9ec',
        76108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBrahmi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Brahmi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Brahmi
  static TextTheme notoSansBrahmiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBrahmi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBrahmi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBrahmi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBrahmi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBrahmi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBrahmi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBrahmi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBrahmi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBrahmi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBrahmi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBrahmi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBrahmi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBrahmi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBrahmi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBrahmi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Buginese font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Buginese
  static TextStyle notoSansBuginese({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5821a2fc86de888404c615d4c0ad609885b0327e9efb529163d46f1daac73d4',
        35424,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBuginese',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Buginese font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Buginese
  static TextTheme notoSansBugineseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBuginese(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBuginese(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBuginese(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBuginese(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBuginese(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBuginese(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBuginese(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBuginese(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBuginese(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBuginese(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBuginese(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBuginese(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBuginese(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBuginese(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBuginese(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Buhid font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Buhid
  static TextStyle notoSansBuhid({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9982dcdb6a665b970ec917ea155248fc6b000c239e6a16f4213bda014de61454',
        29928,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansBuhid',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Buhid font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Buhid
  static TextTheme notoSansBuhidTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansBuhid(textStyle: textTheme.displayLarge),
      displayMedium: notoSansBuhid(textStyle: textTheme.displayMedium),
      displaySmall: notoSansBuhid(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansBuhid(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansBuhid(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansBuhid(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansBuhid(textStyle: textTheme.titleLarge),
      titleMedium: notoSansBuhid(textStyle: textTheme.titleMedium),
      titleSmall: notoSansBuhid(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansBuhid(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansBuhid(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansBuhid(textStyle: textTheme.bodySmall),
      labelLarge: notoSansBuhid(textStyle: textTheme.labelLarge),
      labelMedium: notoSansBuhid(textStyle: textTheme.labelMedium),
      labelSmall: notoSansBuhid(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Canadian Aboriginal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Canadian+Aboriginal
  static TextStyle notoSansCanadianAboriginal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f829f5750b3190d22925b110d814f00043d06b552f1a77a653cdd4b313470ad1',
        97396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c8165f08404cf6969ca9385dfebe2a4e324077b7cff7ed2eb7be926e7fb46ef',
        97392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5e6b1ab50f10aab9775dd75ae135e1fe1cd6fd4041ec7fb69d21910a12fb185',
        97316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '061a4eaf76def9f1c034fbe64cf9418fb66dad0c39825f74b207ef9136fd2270',
        97144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba87bad3c25f1fd2033adb32332f4df3aeb73e149f5c3ab70d134f612b65d7a6',
        97164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61e022b7eb50bdf09f51c41efcb525bbecffc1b75f2287e8b05971c59610a592',
        97116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cdcb95a1eb48a3de7d90912c2836d2aa21b72e02e74c5e5193000dd4680b20e5',
        97040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ef0297f88ab294be3942936d62f7ca8baf1987454fd312a1d2dff4af180949b',
        97124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'abf6eb378c840bb455f9a73f88c4065202ba421dee6788c934a6245238c11c25',
        97020,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCanadianAboriginal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Canadian Aboriginal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Canadian+Aboriginal
  static TextTheme notoSansCanadianAboriginalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          notoSansCanadianAboriginal(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansCanadianAboriginal(textStyle: textTheme.displayMedium),
      displaySmall:
          notoSansCanadianAboriginal(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansCanadianAboriginal(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansCanadianAboriginal(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansCanadianAboriginal(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCanadianAboriginal(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCanadianAboriginal(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCanadianAboriginal(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCanadianAboriginal(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCanadianAboriginal(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCanadianAboriginal(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCanadianAboriginal(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCanadianAboriginal(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCanadianAboriginal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Carian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Carian
  static TextStyle notoSansCarian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5940bb3d836e0fad249e08d5c16de22b1b62ba53186f967557d42a6a7ade2457',
        36156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCarian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Carian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Carian
  static TextTheme notoSansCarianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansCarian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansCarian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansCarian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansCarian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansCarian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansCarian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCarian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCarian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCarian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCarian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCarian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCarian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCarian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCarian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCarian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Caucasian Albanian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Caucasian+Albanian
  static TextStyle notoSansCaucasianAlbanian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c6de7544558885f5cb6186004bd3560af743ef04d37c5f7c137429e00df4380',
        57932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCaucasianAlbanian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Caucasian Albanian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Caucasian+Albanian
  static TextTheme notoSansCaucasianAlbanianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          notoSansCaucasianAlbanian(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansCaucasianAlbanian(textStyle: textTheme.displayMedium),
      displaySmall:
          notoSansCaucasianAlbanian(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansCaucasianAlbanian(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansCaucasianAlbanian(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansCaucasianAlbanian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCaucasianAlbanian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCaucasianAlbanian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCaucasianAlbanian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCaucasianAlbanian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCaucasianAlbanian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCaucasianAlbanian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCaucasianAlbanian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCaucasianAlbanian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCaucasianAlbanian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Chakma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Chakma
  static TextStyle notoSansChakma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c13048601ef3a9c97db76d25e8e7c5a6401757cf6414c41337ea18c2913891d',
        84772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansChakma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Chakma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Chakma
  static TextTheme notoSansChakmaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansChakma(textStyle: textTheme.displayLarge),
      displayMedium: notoSansChakma(textStyle: textTheme.displayMedium),
      displaySmall: notoSansChakma(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansChakma(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansChakma(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansChakma(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansChakma(textStyle: textTheme.titleLarge),
      titleMedium: notoSansChakma(textStyle: textTheme.titleMedium),
      titleSmall: notoSansChakma(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansChakma(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansChakma(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansChakma(textStyle: textTheme.bodySmall),
      labelLarge: notoSansChakma(textStyle: textTheme.labelLarge),
      labelMedium: notoSansChakma(textStyle: textTheme.labelMedium),
      labelSmall: notoSansChakma(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Cham font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cham
  static TextStyle notoSansCham({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '99b2c37fbfd25bbc4badfbed43fb2fa5494986a7fa774c645e4b144686df2ba5',
        61848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '18428e19c08d9b74f14e400902bdba1c01e4409f92b79f2892a45a61e1b063be',
        62204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'caadb86a5dd77f189ce2e50516c9026fa1c9b36e4502f26a4c549f32b04517fe',
        62144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25cb82e01e30890a2df6f0a454b6770db240a56499cc81a91e7feb0813642653',
        61960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '777741b94d69e1b43f3b0caa09ed6edabe4d6f4d5b9406f50be90b261646a83b',
        62316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0787c0f0d8a4e2eb0e38b3cd0ac23dfc4f26268d249b9297e1bccf848ee49919',
        62356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '101c5ed039717ba3f79664d67b75ebd794f0325e2bcfc7fdbaf22eb50da89242',
        62244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c46c285aa7d13d5c763114cafd8ae3e3fc06df2b22f8a3d72586914cfb93b39c',
        62352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ff7cbcc594ce93fc3df5e2607654d0ffa00e46bdd61cb9cef959d08a5527299',
        62228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCham',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Cham font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cham
  static TextTheme notoSansChamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansCham(textStyle: textTheme.displayLarge),
      displayMedium: notoSansCham(textStyle: textTheme.displayMedium),
      displaySmall: notoSansCham(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansCham(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansCham(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansCham(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCham(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCham(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCham(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCham(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCham(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCham(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCham(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCham(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCham(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Cherokee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cherokee
  static TextStyle notoSansCherokee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a270e2c220ac54e92e05e45cdf48ecfee7305a64d09e35897ca625b30572d470',
        85408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '240d98c1c4d67640459e537822171269776f22fbab5499f3b6edcfd59ee54081',
        85680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3360a097ae9ef07744629779dd768c3543c70a141e5f7d6824c1892c9bf980e7',
        85660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe18b5d02b2ebb682f0d3c62e1569d4e590237ee8b671fa679bc391d9934cd21',
        85028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f32ce6a42bfb19d35aa6185bf7a94e69e2d64f6b4d964eed4e5529d48c8e138b',
        85184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f491c14ee0aed7dccb973c7e25f4627a9e4ca7624d1d1cca5689703ac22c753',
        85312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '312f7efd286d5044db45c812a1097207fdc8a93a8bd3d7c196e91292706b89c5',
        85168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9cb99a448c43004a832ca553c8b2b9e2953f8616cfc386567f9792643082cee5',
        85252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2918c85e1132e469fad063ec43667b235133ec0b1b16ac6ee9e8e3f649743c67',
        84944,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCherokee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Cherokee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cherokee
  static TextTheme notoSansCherokeeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansCherokee(textStyle: textTheme.displayLarge),
      displayMedium: notoSansCherokee(textStyle: textTheme.displayMedium),
      displaySmall: notoSansCherokee(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansCherokee(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansCherokee(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansCherokee(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCherokee(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCherokee(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCherokee(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCherokee(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCherokee(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCherokee(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCherokee(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCherokee(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCherokee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Chorasmian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Chorasmian
  static TextStyle notoSansChorasmian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee60cbe6bd2672c07b2594bb0decc91349fcea8b59ef64f16f79496ed8523638',
        46864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansChorasmian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Chorasmian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Chorasmian
  static TextTheme notoSansChorasmianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansChorasmian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansChorasmian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansChorasmian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansChorasmian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansChorasmian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansChorasmian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansChorasmian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansChorasmian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansChorasmian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansChorasmian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansChorasmian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansChorasmian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansChorasmian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansChorasmian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansChorasmian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Coptic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Coptic
  static TextStyle notoSansCoptic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd69115356717987b75a130d7acab37290d35b2e7b4cae22cafbd6607282d195',
        63668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCoptic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Coptic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Coptic
  static TextTheme notoSansCopticTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansCoptic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansCoptic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansCoptic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansCoptic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansCoptic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansCoptic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCoptic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCoptic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCoptic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCoptic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCoptic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCoptic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCoptic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCoptic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCoptic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Cuneiform font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cuneiform
  static TextStyle notoSansCuneiform({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '571429666ce1c2b09f09d780195147d2f714fce9214829b43b679fbdb19f6649',
        850560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCuneiform',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Cuneiform font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cuneiform
  static TextTheme notoSansCuneiformTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansCuneiform(textStyle: textTheme.displayLarge),
      displayMedium: notoSansCuneiform(textStyle: textTheme.displayMedium),
      displaySmall: notoSansCuneiform(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansCuneiform(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansCuneiform(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansCuneiform(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCuneiform(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCuneiform(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCuneiform(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCuneiform(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCuneiform(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCuneiform(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCuneiform(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCuneiform(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCuneiform(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Cypriot font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cypriot
  static TextStyle notoSansCypriot({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4b22cf375f3a71fefd6214e152125e0cf2bb2c817b277c0de4b058bb620eeb8',
        54132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCypriot',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Cypriot font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cypriot
  static TextTheme notoSansCypriotTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansCypriot(textStyle: textTheme.displayLarge),
      displayMedium: notoSansCypriot(textStyle: textTheme.displayMedium),
      displaySmall: notoSansCypriot(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansCypriot(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansCypriot(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansCypriot(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCypriot(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCypriot(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCypriot(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCypriot(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCypriot(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCypriot(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCypriot(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCypriot(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCypriot(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Cypro Minoan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cypro+Minoan
  static TextStyle notoSansCyproMinoan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a5edc39daa006a12aeda9a5d6fc39a2d00f899d9f83f66f30f2b30a8de9b32e',
        42644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansCyproMinoan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Cypro Minoan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Cypro+Minoan
  static TextTheme notoSansCyproMinoanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansCyproMinoan(textStyle: textTheme.displayLarge),
      displayMedium: notoSansCyproMinoan(textStyle: textTheme.displayMedium),
      displaySmall: notoSansCyproMinoan(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansCyproMinoan(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansCyproMinoan(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansCyproMinoan(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansCyproMinoan(textStyle: textTheme.titleLarge),
      titleMedium: notoSansCyproMinoan(textStyle: textTheme.titleMedium),
      titleSmall: notoSansCyproMinoan(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansCyproMinoan(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansCyproMinoan(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansCyproMinoan(textStyle: textTheme.bodySmall),
      labelLarge: notoSansCyproMinoan(textStyle: textTheme.labelLarge),
      labelMedium: notoSansCyproMinoan(textStyle: textTheme.labelMedium),
      labelSmall: notoSansCyproMinoan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Deseret font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Deseret
  static TextStyle notoSansDeseret({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b76b69f49a5d658aaf42cb354d1d06c26cfcc266cae0839da6c10cef1c84899',
        40740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansDeseret',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Deseret font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Deseret
  static TextTheme notoSansDeseretTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansDeseret(textStyle: textTheme.displayLarge),
      displayMedium: notoSansDeseret(textStyle: textTheme.displayMedium),
      displaySmall: notoSansDeseret(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansDeseret(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansDeseret(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansDeseret(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansDeseret(textStyle: textTheme.titleLarge),
      titleMedium: notoSansDeseret(textStyle: textTheme.titleMedium),
      titleSmall: notoSansDeseret(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansDeseret(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansDeseret(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansDeseret(textStyle: textTheme.bodySmall),
      labelLarge: notoSansDeseret(textStyle: textTheme.labelLarge),
      labelMedium: notoSansDeseret(textStyle: textTheme.labelMedium),
      labelSmall: notoSansDeseret(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Devanagari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Devanagari
  static TextStyle notoSansDevanagari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50c27b60b9421ea84cfac8e96992f8ee327ac30f24f3f41dfda2d2969218faa1',
        203008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26763967dfbe465f19bf6f07410a95635ceaf999fbb68dc4b5a3a87b9e4e6242',
        203260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '164f1524cddea74dcf5967ea6538fbe4c68c3b05acd753cfa8bc8bdba15b8c79',
        203248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b85f86947b26542a67c1938c1a69cbb8ac2f36fceb74e3dfd3b64ffc911eae50',
        203008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '97cde11428c5f127339287282216edfc0afd457657ca63253780aa33a270cb7f',
        203220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '335582f80b343debee418958db492864f04030322fbafcb16e7dfd0ccf85ed01',
        203256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63ed532e4fc28a9d146e542a0a40a476b487d6ff6ab6960830e930362acea226',
        203268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff18b6d3c1fc6aeed18bfdc27f6ce27f2dbb489b6255af48f933b57e2873a4c7',
        203440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3c2189c2c1811f8d52c7bdbf3159036764968b6b673374c4cd1b317a9797aec',
        203256,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansDevanagari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Devanagari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Devanagari
  static TextTheme notoSansDevanagariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansDevanagari(textStyle: textTheme.displayLarge),
      displayMedium: notoSansDevanagari(textStyle: textTheme.displayMedium),
      displaySmall: notoSansDevanagari(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansDevanagari(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansDevanagari(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansDevanagari(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansDevanagari(textStyle: textTheme.titleLarge),
      titleMedium: notoSansDevanagari(textStyle: textTheme.titleMedium),
      titleSmall: notoSansDevanagari(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansDevanagari(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansDevanagari(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansDevanagari(textStyle: textTheme.bodySmall),
      labelLarge: notoSansDevanagari(textStyle: textTheme.labelLarge),
      labelMedium: notoSansDevanagari(textStyle: textTheme.labelMedium),
      labelSmall: notoSansDevanagari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Display
  static TextStyle notoSansDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4aaf6f3c69768ffadb1daee44297052a4f1cf7ca933a5455613d37c104941b8c',
        328380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bf27636a29653f17a6a33da9b8dbce02de46961e69552e0904ddcf86422974c',
        328704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f94cad9254407842c519e57d26840de5ff46d7853811421e18910591e1d60f1',
        328624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a4d8f0b726a05dad002d71517d2448fa905c68cda2a2f929f02b5792ba95a7d',
        327988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28d24f5dd3a4fa209350e11c1a68de430d2158872eddb258da93d79793aaada3',
        328460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca1d9e53ea2fae3ba970b553b44db902f26244a0b706bcc14b38b4b6e3eec8c9',
        328572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '674164fbb0edd558dcb56c1b9de191b5da2eca9481c0c289c658521203b514c1',
        328288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56948e2a24a43b3eea96fa3a9cc864c4b22f198ec4ccefa30b34bf8fedfcc968',
        328804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25f170c25c4fb8493d9d4fb0a38bd7c29dd8a1de85e9422b170eaaa328ff7eb2',
        328896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '44a80ae636b67b6024aecedb1ab2738ae7b235028706b5943d2e49ab1c3e122a',
        350940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53774b4973e89a999cd280e3d627e952b41e38f97935c1b34ad8cc7a42e0c0a9',
        351396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '61b0cdb645b0eccb22cfd73b691e174880a22bad4d06c2f69c2a48fecfe964bc',
        350984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b2f083762d9259421bc4e277796fbd0450103cc6d385a368dca7f5992287b63',
        349544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6a8ef2963d05597d58e64e9887a8105392d2b689b5a0ca71b095412f7fa18b1d',
        350012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b2fce9d9176ff3ad986864078f81839a3a4bdab3f3b77f99db215e5ec9688470',
        350124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'df9415a23cc8b669a8ddf804c974cd38e55940ba56e4e638408105b527a8d560',
        349696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '29079f47b2544b147ea4cc9e68eb5b53b09e557c2be7cc5f88aeed96a90b1157',
        350360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f8ac203895993f1926f4ed25e2a58455cb36bc086270f4755b18c0063d88c92f',
        350256,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Display
  static TextTheme notoSansDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansDisplay(textStyle: textTheme.displayLarge),
      displayMedium: notoSansDisplay(textStyle: textTheme.displayMedium),
      displaySmall: notoSansDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansDisplay(textStyle: textTheme.titleLarge),
      titleMedium: notoSansDisplay(textStyle: textTheme.titleMedium),
      titleSmall: notoSansDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansDisplay(textStyle: textTheme.bodySmall),
      labelLarge: notoSansDisplay(textStyle: textTheme.labelLarge),
      labelMedium: notoSansDisplay(textStyle: textTheme.labelMedium),
      labelSmall: notoSansDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Duployan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Duployan
  static TextStyle notoSansDuployan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fc117b1448fd95d257767493e2283f4fe6f87aac8ce13d1792ef8ae47e6ec81',
        1823492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f6dee4ca9ca64c2a632b8774fe5e91e1b59b4c18040c2bf5ea6f945964958f5',
        1815296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansDuployan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Duployan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Duployan
  static TextTheme notoSansDuployanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansDuployan(textStyle: textTheme.displayLarge),
      displayMedium: notoSansDuployan(textStyle: textTheme.displayMedium),
      displaySmall: notoSansDuployan(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansDuployan(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansDuployan(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansDuployan(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansDuployan(textStyle: textTheme.titleLarge),
      titleMedium: notoSansDuployan(textStyle: textTheme.titleMedium),
      titleSmall: notoSansDuployan(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansDuployan(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansDuployan(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansDuployan(textStyle: textTheme.bodySmall),
      labelLarge: notoSansDuployan(textStyle: textTheme.labelLarge),
      labelMedium: notoSansDuployan(textStyle: textTheme.labelMedium),
      labelSmall: notoSansDuployan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Egyptian Hieroglyphs font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Egyptian+Hieroglyphs
  static TextStyle notoSansEgyptianHieroglyphs({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '435214f6a7bcd3b7548b6aefe40036b0c1633da2a2eae42d51fa11862b418ab2',
        612876,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansEgyptianHieroglyphs',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Egyptian Hieroglyphs font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Egyptian+Hieroglyphs
  static TextTheme notoSansEgyptianHieroglyphsTextTheme(
      [TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          notoSansEgyptianHieroglyphs(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansEgyptianHieroglyphs(textStyle: textTheme.displayMedium),
      displaySmall:
          notoSansEgyptianHieroglyphs(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansEgyptianHieroglyphs(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansEgyptianHieroglyphs(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansEgyptianHieroglyphs(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansEgyptianHieroglyphs(textStyle: textTheme.titleLarge),
      titleMedium:
          notoSansEgyptianHieroglyphs(textStyle: textTheme.titleMedium),
      titleSmall: notoSansEgyptianHieroglyphs(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansEgyptianHieroglyphs(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansEgyptianHieroglyphs(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansEgyptianHieroglyphs(textStyle: textTheme.bodySmall),
      labelLarge: notoSansEgyptianHieroglyphs(textStyle: textTheme.labelLarge),
      labelMedium:
          notoSansEgyptianHieroglyphs(textStyle: textTheme.labelMedium),
      labelSmall: notoSansEgyptianHieroglyphs(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Elbasan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Elbasan
  static TextStyle notoSansElbasan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd1ea68efe1d5e8f2248de979d1e5968bf1536c01b72f26014587234b0064749',
        41208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansElbasan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Elbasan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Elbasan
  static TextTheme notoSansElbasanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansElbasan(textStyle: textTheme.displayLarge),
      displayMedium: notoSansElbasan(textStyle: textTheme.displayMedium),
      displaySmall: notoSansElbasan(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansElbasan(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansElbasan(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansElbasan(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansElbasan(textStyle: textTheme.titleLarge),
      titleMedium: notoSansElbasan(textStyle: textTheme.titleMedium),
      titleSmall: notoSansElbasan(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansElbasan(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansElbasan(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansElbasan(textStyle: textTheme.bodySmall),
      labelLarge: notoSansElbasan(textStyle: textTheme.labelLarge),
      labelMedium: notoSansElbasan(textStyle: textTheme.labelMedium),
      labelSmall: notoSansElbasan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Elymaic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Elymaic
  static TextStyle notoSansElymaic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ce88b7662d1af94b17337c860cffb3656d570f7a202f209b5f33ef46eba0dd4',
        36248,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansElymaic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Elymaic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Elymaic
  static TextTheme notoSansElymaicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansElymaic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansElymaic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansElymaic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansElymaic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansElymaic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansElymaic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansElymaic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansElymaic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansElymaic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansElymaic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansElymaic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansElymaic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansElymaic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansElymaic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansElymaic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Ethiopic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Ethiopic
  static TextStyle notoSansEthiopic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2bc0bacefae0e58796fcd6c159c7f123824da7cf05d014f95ab595842c7e812e',
        365276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f7f1300df4d91c84ba480f8e7c5d36c7e3904363ecd5deb6424814621f8945d',
        365424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e108aa8e61a8fcaa7feb718f0c46dc296920cf7daaa1b629bb3eff7f7fcb5c00',
        365456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7352033c180fd85a7e4621d3233d66d97175ecefbe3d8ad87b3fdbb5d72d9c15',
        365340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36b4aff2e298fc77e496b7ad4cf5fc335f13c4ec6f540cf9d7a6b049b4fe16cc',
        365500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dfd2fcd404409dddedfd7f2adbba54d6f08db6639375a1916a045928758243af',
        365344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69ab130cc3fcdc4d76c6be473f2533ba0100f1876ccce61a7b73ac0bc4a8cff3',
        365292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '797ed3c631d2b8be0cdf8b4aa8a5556204736564149976332f17a550b4f03858',
        365276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd8c5a4a323f5169d14b61bc48cf55ed6cd8879d5d694bec48229c535ebc3fc1',
        365280,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansEthiopic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Ethiopic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Ethiopic
  static TextTheme notoSansEthiopicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansEthiopic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansEthiopic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansEthiopic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansEthiopic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansEthiopic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansEthiopic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansEthiopic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansEthiopic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansEthiopic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansEthiopic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansEthiopic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansEthiopic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansEthiopic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansEthiopic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansEthiopic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Georgian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Georgian
  static TextStyle notoSansGeorgian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '925ef9aa00e741194d04bd81a0e2779fbde5c5622f40c3df8460419991ea8d99',
        65508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '882f93af61e72a101812c10cabea7095673ff3ea712389b03393d4d477b99b5f',
        65572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6419524f973944acdda02a3a80e92a688bcd355cb1c6222c23fcfd2256db1ec7',
        65540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a5fb39f854ff25a08d20a9b1aa10eea44dfb7c3ccf3877fd7efe12727ad08721',
        65488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a702a29dd841c2c31694a3d6c1077a5c59cf70a1653eafa94f726dfbccf67ae',
        65516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a194b584c44b912b8c3c1bb16ad214c940c326cc76e447c02b587cb947f6299',
        65524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '386a8e6aa2bb4d0bfea7def0e17578da928df9990268e6ce1d4fcd2ff3642eb2',
        65436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e52a62192b2ebf92ea74e1bb30cffcd8b9f933e336c45b58264abc055764ab3b',
        65456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '820ccf1d542c86ddd1351a3b05d9526cd66187c0618742d101634bc75eb5cd75',
        65404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansGeorgian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Georgian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Georgian
  static TextTheme notoSansGeorgianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansGeorgian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansGeorgian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansGeorgian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansGeorgian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansGeorgian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansGeorgian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansGeorgian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansGeorgian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansGeorgian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansGeorgian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansGeorgian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansGeorgian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansGeorgian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansGeorgian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansGeorgian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Glagolitic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Glagolitic
  static TextStyle notoSansGlagolitic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d8f40403ece89fad8844b7a2eb91683671828808fc5e441c66c3084392ca293',
        55072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansGlagolitic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Glagolitic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Glagolitic
  static TextTheme notoSansGlagoliticTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansGlagolitic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansGlagolitic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansGlagolitic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansGlagolitic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansGlagolitic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansGlagolitic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansGlagolitic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansGlagolitic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansGlagolitic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansGlagolitic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansGlagolitic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansGlagolitic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansGlagolitic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansGlagolitic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansGlagolitic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Gothic
  static TextStyle notoSansGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f082f3e2953db35b863943d051a3bdc758d14244e593b585781c622a5e98aa3',
        33264,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Gothic
  static TextTheme notoSansGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansGothic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansGothic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansGothic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansGothic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansGothic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansGothic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansGothic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansGothic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansGothic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansGothic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansGothic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Grantha font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Grantha
  static TextStyle notoSansGrantha({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9dde4e46d993cb275de61ec4ccd8df9fa8a1b6e6372be0685ca06acee3abff62',
        291396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansGrantha',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Grantha font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Grantha
  static TextTheme notoSansGranthaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansGrantha(textStyle: textTheme.displayLarge),
      displayMedium: notoSansGrantha(textStyle: textTheme.displayMedium),
      displaySmall: notoSansGrantha(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansGrantha(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansGrantha(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansGrantha(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansGrantha(textStyle: textTheme.titleLarge),
      titleMedium: notoSansGrantha(textStyle: textTheme.titleMedium),
      titleSmall: notoSansGrantha(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansGrantha(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansGrantha(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansGrantha(textStyle: textTheme.bodySmall),
      labelLarge: notoSansGrantha(textStyle: textTheme.labelLarge),
      labelMedium: notoSansGrantha(textStyle: textTheme.labelMedium),
      labelSmall: notoSansGrantha(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Gujarati font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Gujarati
  static TextStyle notoSansGujarati({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2a90395878b375195fa149af2e45cfd0fb2e7317213709a77cc29b7c378c5c5',
        173516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e1df8602360469722efa973ef982f1645e6a4690011594c79d3da12ee4ee974',
        173744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ef9098add1f2993f4f368f2a1170d89a7d9baaa3684975b632dcf7325763ee2',
        173804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e45dcb775d5e69ada2b090270f4bc9a212f5ceed87c7f7a293ff4e3d00affc42',
        173520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b03631a4e2db8b37035206cdde6d087b5eaee667024859976d050ac13ffa27c',
        173768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9edd6c24916700bca3344c5e6a62b1ab927aacbfebd3272d26c824e1591d35a1',
        173800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9aab24265cc7d7abcbfbf310ece52f77e4a8e958480314a8a52f320208db4167',
        173700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30d8a3b67623754d002730b63eaa9a461443b237284690719e5fd0e18a6e047a',
        173996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0cae5eae4a45f5d2a492faa4c72a1f572dd4106c628164f8c0cdfbce859ab64d',
        173808,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansGujarati',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Gujarati font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Gujarati
  static TextTheme notoSansGujaratiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansGujarati(textStyle: textTheme.displayLarge),
      displayMedium: notoSansGujarati(textStyle: textTheme.displayMedium),
      displaySmall: notoSansGujarati(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansGujarati(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansGujarati(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansGujarati(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansGujarati(textStyle: textTheme.titleLarge),
      titleMedium: notoSansGujarati(textStyle: textTheme.titleMedium),
      titleSmall: notoSansGujarati(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansGujarati(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansGujarati(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansGujarati(textStyle: textTheme.bodySmall),
      labelLarge: notoSansGujarati(textStyle: textTheme.labelLarge),
      labelMedium: notoSansGujarati(textStyle: textTheme.labelMedium),
      labelSmall: notoSansGujarati(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Gunjala Gondi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Gunjala+Gondi
  static TextStyle notoSansGunjalaGondi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c0c1f21b49c8d9e629ef14e8173b37b28833657fc7fec8414189e95b02d7dae',
        101436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1cd24f459c98e71d1a20b57c03ef7eb67e90bcbc42cf2874577a97730ca85116',
        101684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9213284f47c5330a5055de96c1081ec2c06de70f5a1b3ccb21f201eca1db8e2',
        101544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3920c8ee3c8fc524ab12cf2c0a09f2f43fb9f83920584559049468448b31f8f',
        101112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansGunjalaGondi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Gunjala Gondi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Gunjala+Gondi
  static TextTheme notoSansGunjalaGondiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansGunjalaGondi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansGunjalaGondi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansGunjalaGondi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansGunjalaGondi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansGunjalaGondi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansGunjalaGondi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansGunjalaGondi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansGunjalaGondi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansGunjalaGondi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansGunjalaGondi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansGunjalaGondi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansGunjalaGondi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansGunjalaGondi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansGunjalaGondi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansGunjalaGondi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Gurmukhi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Gurmukhi
  static TextStyle notoSansGurmukhi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22f107245d8ddc2936b3ea1960b5a53b0feb704589da8cf42a72a484eceb5717',
        57616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8ca1b03071ae2c31e6a9355a9602c761a126d8175e651cb174f9f5f3f3c42b0',
        57772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c2be573d72202041aaadfc56677a137f69bb52696e151dd3048e24295f2f0d4',
        57692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '037add035e4dbe146a8e7d810e5d0d990327e28ed6156a8b5c6e0e1b9de568c9',
        57504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86eceacddc7ca9e205c878a794e9f572a9b08b50858e1717a64fb28d093b8c4b',
        57596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab39c2f738ca93a9f7168f9328b10bf14da3738050f7f25be94cda6cdcc6ff2f',
        57668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f0c1b8d7dcc0cdfe95b68017c0f25a3084ec5f4f6b8b9e535f636193f4767b3',
        57568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f53762eacf28b66a6cb0210b7d265b9f231b589d864afe5853360f90244371cd',
        57688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d99686606a15cfb7fe3cffc0c10ad4ae26a185ad76badaefed0c515640f5c3b',
        57536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansGurmukhi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Gurmukhi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Gurmukhi
  static TextTheme notoSansGurmukhiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansGurmukhi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansGurmukhi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansGurmukhi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansGurmukhi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansGurmukhi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansGurmukhi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansGurmukhi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansGurmukhi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansGurmukhi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansGurmukhi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansGurmukhi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansGurmukhi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansGurmukhi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansGurmukhi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansGurmukhi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans HK font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+HK
  static TextStyle notoSansHk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '587fd94fe5686437384a24d0e6185363a93fdf38f1ae00c046b419cc1b1cc100',
        7070116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40d4852ffd77aa642046901b5ac43f2f3b982ddce6fcb5da6ec473b5c33fd5f0',
        7073296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '57f8e449f06466461c11366f0e8bd7b646fd223c60a8271ae83569cd34364ef1',
        7073688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5457e0b1c20255a7dc30331205583b491a23da8a87ff7af19501d5bd6e8d171d',
        7071524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af4a67a314ce05c31b504380ce60db588a4fc3a0cf5f9bb9f8d5e307744acb03',
        7067572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfc9fb1d1a71d7b26a4f1d40da7033434b68a4936468fc0f69659640607a2140',
        7064924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a6a488b1766f6f70957d6754c4e1d3423f86479358a7cb6c83d73a302dcd951',
        7064176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7038b742f14965f20a3410707380af81a871f4935609a4b3d3a1db14abec330d',
        7060576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51209da149d158438b2142293183dc704a1c911f55e03fc7376d901f85214e96',
        7058120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansHK',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans HK font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+HK
  static TextTheme notoSansHkTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansHk(textStyle: textTheme.displayLarge),
      displayMedium: notoSansHk(textStyle: textTheme.displayMedium),
      displaySmall: notoSansHk(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansHk(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansHk(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansHk(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansHk(textStyle: textTheme.titleLarge),
      titleMedium: notoSansHk(textStyle: textTheme.titleMedium),
      titleSmall: notoSansHk(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansHk(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansHk(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansHk(textStyle: textTheme.bodySmall),
      labelLarge: notoSansHk(textStyle: textTheme.labelLarge),
      labelMedium: notoSansHk(textStyle: textTheme.labelMedium),
      labelSmall: notoSansHk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Hanifi Rohingya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Hanifi+Rohingya
  static TextStyle notoSansHanifiRohingya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4db3abe150399ae56205d86874016ba8d9ab2a0b5a6025678f101b3f04774a3b',
        46908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ed8872fc49864a5f88a4e75675782cf6130c4d5595545458b2e586ee7d7d150',
        46992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3bd23e1b5112c24f74d4b57bc1d302a3d67043670c4310e658bf84f9e91c92b4',
        47024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0040d12b0b12f25c04a4033caef8753561ae040d67ef27ddb417b8046671446a',
        46948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansHanifiRohingya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Hanifi Rohingya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Hanifi+Rohingya
  static TextTheme notoSansHanifiRohingyaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansHanifiRohingya(textStyle: textTheme.displayLarge),
      displayMedium: notoSansHanifiRohingya(textStyle: textTheme.displayMedium),
      displaySmall: notoSansHanifiRohingya(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansHanifiRohingya(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansHanifiRohingya(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansHanifiRohingya(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansHanifiRohingya(textStyle: textTheme.titleLarge),
      titleMedium: notoSansHanifiRohingya(textStyle: textTheme.titleMedium),
      titleSmall: notoSansHanifiRohingya(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansHanifiRohingya(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansHanifiRohingya(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansHanifiRohingya(textStyle: textTheme.bodySmall),
      labelLarge: notoSansHanifiRohingya(textStyle: textTheme.labelLarge),
      labelMedium: notoSansHanifiRohingya(textStyle: textTheme.labelMedium),
      labelSmall: notoSansHanifiRohingya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Hanunoo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Hanunoo
  static TextStyle notoSansHanunoo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3a6700de5535b349de26415b6f3770d2042f5333331d98fe78a97c45f76f692',
        35644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansHanunoo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Hanunoo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Hanunoo
  static TextTheme notoSansHanunooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansHanunoo(textStyle: textTheme.displayLarge),
      displayMedium: notoSansHanunoo(textStyle: textTheme.displayMedium),
      displaySmall: notoSansHanunoo(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansHanunoo(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansHanunoo(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansHanunoo(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansHanunoo(textStyle: textTheme.titleLarge),
      titleMedium: notoSansHanunoo(textStyle: textTheme.titleMedium),
      titleSmall: notoSansHanunoo(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansHanunoo(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansHanunoo(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansHanunoo(textStyle: textTheme.bodySmall),
      labelLarge: notoSansHanunoo(textStyle: textTheme.labelLarge),
      labelMedium: notoSansHanunoo(textStyle: textTheme.labelMedium),
      labelSmall: notoSansHanunoo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Hatran font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Hatran
  static TextStyle notoSansHatran({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f667251aeb780c8ef571d393cb6c18bd1cf52ec926938e67b41341b09dbe43d',
        34760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansHatran',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Hatran font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Hatran
  static TextTheme notoSansHatranTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansHatran(textStyle: textTheme.displayLarge),
      displayMedium: notoSansHatran(textStyle: textTheme.displayMedium),
      displaySmall: notoSansHatran(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansHatran(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansHatran(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansHatran(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansHatran(textStyle: textTheme.titleLarge),
      titleMedium: notoSansHatran(textStyle: textTheme.titleMedium),
      titleSmall: notoSansHatran(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansHatran(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansHatran(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansHatran(textStyle: textTheme.bodySmall),
      labelLarge: notoSansHatran(textStyle: textTheme.labelLarge),
      labelMedium: notoSansHatran(textStyle: textTheme.labelMedium),
      labelSmall: notoSansHatran(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Hebrew font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Hebrew
  static TextStyle notoSansHebrew({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80104cfcf61b7dfa2283fd323241902874ddd2b525a84873ec3e318df61ca4f0',
        41328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '65222d02adb149939e06717c0e9bfb24489899d7d7ff9f3788157542176bd098',
        41416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6bae022df5d83d71f5d732b8dcde72f02628f72bdf35ca2afb581a3b118fe2f',
        41328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4ce2493bbc8109fe79c07d36fe5023c7aed434c25ddfee9c1fe84fd59df6965',
        41296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a047a6be598aa6dd90cc01363a45381795cb263ccf6a39799aebcee18c02b8fb',
        41332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29d07ff087fb41862c5782a4a8ae09e518506089fb888ea9cc45b8cb944288ca',
        41356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f834222fa9633c9c5a67ae914527cabcbaad3e80b634e0c60c3cf1b79d81be4d',
        41216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad48aa976e76983737f8ef04c54955c22679920db0585134c81e2e1075a86cb0',
        41284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8bc82320c4550ea9c9759410849acb17e66f825e0604ac256de57aa85f4f880',
        41212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansHebrew',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Hebrew font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Hebrew
  static TextTheme notoSansHebrewTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansHebrew(textStyle: textTheme.displayLarge),
      displayMedium: notoSansHebrew(textStyle: textTheme.displayMedium),
      displaySmall: notoSansHebrew(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansHebrew(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansHebrew(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansHebrew(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansHebrew(textStyle: textTheme.titleLarge),
      titleMedium: notoSansHebrew(textStyle: textTheme.titleMedium),
      titleSmall: notoSansHebrew(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansHebrew(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansHebrew(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansHebrew(textStyle: textTheme.bodySmall),
      labelLarge: notoSansHebrew(textStyle: textTheme.labelLarge),
      labelMedium: notoSansHebrew(textStyle: textTheme.labelMedium),
      labelSmall: notoSansHebrew(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Imperial Aramaic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Imperial+Aramaic
  static TextStyle notoSansImperialAramaic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e76cb3572d0fec816b021a05f59870c3cd6e30d6b061c1000f9591d934bdfce',
        36116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansImperialAramaic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Imperial Aramaic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Imperial+Aramaic
  static TextTheme notoSansImperialAramaicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansImperialAramaic(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansImperialAramaic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansImperialAramaic(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansImperialAramaic(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansImperialAramaic(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansImperialAramaic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansImperialAramaic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansImperialAramaic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansImperialAramaic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansImperialAramaic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansImperialAramaic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansImperialAramaic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansImperialAramaic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansImperialAramaic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansImperialAramaic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Indic Siyaq Numbers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Indic+Siyaq+Numbers
  static TextStyle notoSansIndicSiyaqNumbers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '313186a1b115b390c9c03a1a32958d73a528ff801b627c4c7820019a45295140',
        52176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansIndicSiyaqNumbers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Indic Siyaq Numbers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Indic+Siyaq+Numbers
  static TextTheme notoSansIndicSiyaqNumbersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          notoSansIndicSiyaqNumbers(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansIndicSiyaqNumbers(textStyle: textTheme.displayMedium),
      displaySmall:
          notoSansIndicSiyaqNumbers(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansIndicSiyaqNumbers(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansIndicSiyaqNumbers(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansIndicSiyaqNumbers(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansIndicSiyaqNumbers(textStyle: textTheme.titleLarge),
      titleMedium: notoSansIndicSiyaqNumbers(textStyle: textTheme.titleMedium),
      titleSmall: notoSansIndicSiyaqNumbers(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansIndicSiyaqNumbers(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansIndicSiyaqNumbers(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansIndicSiyaqNumbers(textStyle: textTheme.bodySmall),
      labelLarge: notoSansIndicSiyaqNumbers(textStyle: textTheme.labelLarge),
      labelMedium: notoSansIndicSiyaqNumbers(textStyle: textTheme.labelMedium),
      labelSmall: notoSansIndicSiyaqNumbers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Inscriptional Pahlavi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Inscriptional+Pahlavi
  static TextStyle notoSansInscriptionalPahlavi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb4ec7e17aae605bee9223b85688c4ccf87741d432045459db7297fe801c56ac',
        35584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansInscriptionalPahlavi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Inscriptional Pahlavi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Inscriptional+Pahlavi
  static TextTheme notoSansInscriptionalPahlaviTextTheme(
      [TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          notoSansInscriptionalPahlavi(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansInscriptionalPahlavi(textStyle: textTheme.displayMedium),
      displaySmall:
          notoSansInscriptionalPahlavi(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansInscriptionalPahlavi(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansInscriptionalPahlavi(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansInscriptionalPahlavi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansInscriptionalPahlavi(textStyle: textTheme.titleLarge),
      titleMedium:
          notoSansInscriptionalPahlavi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansInscriptionalPahlavi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansInscriptionalPahlavi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansInscriptionalPahlavi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansInscriptionalPahlavi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansInscriptionalPahlavi(textStyle: textTheme.labelLarge),
      labelMedium:
          notoSansInscriptionalPahlavi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansInscriptionalPahlavi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Inscriptional Parthian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Inscriptional+Parthian
  static TextStyle notoSansInscriptionalParthian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c72954e84a3025d34b6b16fcc8999e1b0b9b2694d646a89fea211140a444939',
        34564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansInscriptionalParthian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Inscriptional Parthian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Inscriptional+Parthian
  static TextTheme notoSansInscriptionalParthianTextTheme(
      [TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          notoSansInscriptionalParthian(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansInscriptionalParthian(textStyle: textTheme.displayMedium),
      displaySmall:
          notoSansInscriptionalParthian(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansInscriptionalParthian(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansInscriptionalParthian(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansInscriptionalParthian(textStyle: textTheme.headlineSmall),
      titleLarge:
          notoSansInscriptionalParthian(textStyle: textTheme.titleLarge),
      titleMedium:
          notoSansInscriptionalParthian(textStyle: textTheme.titleMedium),
      titleSmall:
          notoSansInscriptionalParthian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansInscriptionalParthian(textStyle: textTheme.bodyLarge),
      bodyMedium:
          notoSansInscriptionalParthian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansInscriptionalParthian(textStyle: textTheme.bodySmall),
      labelLarge:
          notoSansInscriptionalParthian(textStyle: textTheme.labelLarge),
      labelMedium:
          notoSansInscriptionalParthian(textStyle: textTheme.labelMedium),
      labelSmall:
          notoSansInscriptionalParthian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans JP font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+JP
  static TextStyle notoSansJp({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '78a1fa1d16c437fe5d97df787782b6098a750350b5913b9f80089dc81f512417',
        5706804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0532e4abf0ca438ea0e56749a3106a5badb2f10a89c8ba217b43dae4ec6e590',
        5708144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64f10b3b9e06c99b76b16e1441174fba6adf994fcd6b8036cef2fbfa38535a84',
        5707688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '209c70f533554d512ef0a417b70dfe2997aeec080d2fe41695c55b361643f9ba',
        5703748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5233cdc5a2901be5503f0d95ff48b4b5170afff6a39f95a076520cb73f17860',
        5700280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '852ad9268beb7d467374ec5ff0d416a22102c52d984ec21913f6d886409b85c4',
        5697576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eee16e4913b766be0eb7b9a02cd6ec3daf27292ca0ddf194cae01279aac1c9d0',
        5698756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68d3c7136501158a6cf7d15c1c13e4af995aa164e34d1c250c3eef259cda74dd',
        5696016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ff9b55a270592e78670f98a2f866f621d05b6e1c3a18a14301da455a36f6561',
        5693644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansJP',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans JP font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+JP
  static TextTheme notoSansJpTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansJp(textStyle: textTheme.displayLarge),
      displayMedium: notoSansJp(textStyle: textTheme.displayMedium),
      displaySmall: notoSansJp(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansJp(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansJp(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansJp(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansJp(textStyle: textTheme.titleLarge),
      titleMedium: notoSansJp(textStyle: textTheme.titleMedium),
      titleSmall: notoSansJp(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansJp(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansJp(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansJp(textStyle: textTheme.bodySmall),
      labelLarge: notoSansJp(textStyle: textTheme.labelLarge),
      labelMedium: notoSansJp(textStyle: textTheme.labelMedium),
      labelSmall: notoSansJp(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Javanese font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Javanese
  static TextStyle notoSansJavanese({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30127d49e52c26aeecf099ce35ba16517fbe5784a09bb7a2e06c19653373e5c8',
        153072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bba281a3baf88f16800ccd0603a2093e84da4e399a34984d7b2baa0de13f94b0',
        153428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b31edba9fb37c1e453ac3d794ba10b231572fe3873f388e2b472209a0105d9f',
        153340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd699d0ffbefb64cb200bcfa22c0b619bdad0a6da1d8fb4341ebad00dbc92bd9a',
        152636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansJavanese',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Javanese font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Javanese
  static TextTheme notoSansJavaneseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansJavanese(textStyle: textTheme.displayLarge),
      displayMedium: notoSansJavanese(textStyle: textTheme.displayMedium),
      displaySmall: notoSansJavanese(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansJavanese(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansJavanese(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansJavanese(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansJavanese(textStyle: textTheme.titleLarge),
      titleMedium: notoSansJavanese(textStyle: textTheme.titleMedium),
      titleSmall: notoSansJavanese(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansJavanese(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansJavanese(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansJavanese(textStyle: textTheme.bodySmall),
      labelLarge: notoSansJavanese(textStyle: textTheme.labelLarge),
      labelMedium: notoSansJavanese(textStyle: textTheme.labelMedium),
      labelSmall: notoSansJavanese(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans KR font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+KR
  static TextStyle notoSansKr({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '302d55d333b15473a5b4909964ad17885a53cb41c34e3b434471f22ea55faea1',
        6177560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b03f89eccef4f2931d49db437091de1b15ced57186990749350a2cec1f4feb8',
        6177360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8ed45f767a44de83d969ea276c3b4419c41a291d8460c32379e95930eae878e',
        6175264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82547e25c2011910dae0116ba57d3ab9abd63f4865405677bd6f79c64487ae31',
        6169044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f67bdb1581dbb91b1ce92bdf89a0f3a4ca2545d821d204b17c5443bcda6b3677',
        6166588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '922e269443119b1ffa72c9631d4c7dcb365ab29ba1587b96e715d29c9a66d1b4',
        6165240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed93ef6659b28599d47e40d020b9f55d18a01d94fdd43c9c171e44a66ddc1d66',
        6165036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7088e3dfcc13f400aa9433a4042fce57b3dbe41038040073e9b5909a9390048',
        6164096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14c5cfe30331277d21fa0086e66e11a7c414d4a5ce403229bdb0f384d3376888',
        6163040,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKR',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans KR font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+KR
  static TextTheme notoSansKrTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKr(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKr(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKr(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKr(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKr(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKr(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKr(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKr(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKr(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKr(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKr(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKr(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKr(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKr(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKr(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Kaithi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kaithi
  static TextStyle notoSansKaithi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52b5c6aa9d5d5185019c546d05fcb718ee4b1e5c2e571877cf8fd687966173ae',
        74716,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKaithi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Kaithi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kaithi
  static TextTheme notoSansKaithiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKaithi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKaithi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKaithi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKaithi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKaithi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKaithi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKaithi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKaithi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKaithi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKaithi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKaithi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKaithi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKaithi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKaithi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKaithi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Kannada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kannada
  static TextStyle notoSansKannada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '824a22d01730b3470020dbf80fa22f4e8d172d4645536ba471a09cbebc5ce47e',
        145648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a851f231a9c2229747e5d61864f02df4071fc8e92e2ca207e8bc95d2e3f9086f',
        145876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efea180a8aa275a53228ae9a9633ff0e6c4807196b3fae4656943d88597deb3c',
        145764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05e8f2f7c40e11b24226ab6bd73177c227e95caa27ce99175e6cae2ba31a4093',
        145460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b8f24f347f23091770cfc3c33b867e412c4a4b54433631e216a9e8c76ac8afe',
        145604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dcb72e9e2fdc9e75b3e41d0d7952e230c11dc1c488b15be647c81d7a414d85fe',
        145692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '271707ccb7bacd04ecec97e68c2990d406d2ccdb5e3c593a2baa76c57ca1bb8c',
        145628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67c47f9871c008cf668220d570dc1eca35095ce23e11f6e3e72e197e441f3b6d',
        145780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2e392a426d0939fc32ece147955a5fd0c972d8363ddbaabede2ecf32242377b',
        145776,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKannada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Kannada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kannada
  static TextTheme notoSansKannadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKannada(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKannada(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKannada(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKannada(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKannada(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKannada(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKannada(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKannada(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKannada(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKannada(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKannada(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKannada(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKannada(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKannada(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKannada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Kawi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kawi
  static TextStyle notoSansKawi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad92460788f9d49eaba345d869500b169e5ee44416edf5884200a2890935a7fc',
        71128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86dddb08489f14aab77e3175ad5ec6e034174986531a803e93f7c5bb58437774',
        71260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fcb885b38231e3e820565a0baa3896f0854f467619232c3f890aed5ee2aadf6e',
        71148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f4a0499eeaaa1c8730f1d71d07e95c28d346b863502a774cf120ccc6aea99be',
        71136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKawi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Kawi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kawi
  static TextTheme notoSansKawiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKawi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKawi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKawi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKawi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKawi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKawi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKawi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKawi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKawi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKawi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKawi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKawi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKawi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKawi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKawi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Kayah Li font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kayah+Li
  static TextStyle notoSansKayahLi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '166ab399b84c673a7b01528ae23f7cafd865ee5c4ba085335b3847aac4594bb5',
        33128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c45234a9f6ece4b978c9bbfb6601a9fd9edfac9a46d7b458c238d1c0c698e076',
        33212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbd7c39199deddbeefba3472f4295352c83c6b63edb788a3ffbf43674d55ae04',
        33252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35fc499d9860ba43fed243cf716f8f013e5df865fce17323a849356c51797983',
        33160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKayahLi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Kayah Li font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kayah+Li
  static TextTheme notoSansKayahLiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKayahLi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKayahLi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKayahLi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKayahLi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKayahLi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKayahLi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKayahLi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKayahLi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKayahLi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKayahLi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKayahLi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKayahLi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKayahLi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKayahLi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKayahLi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Kharoshthi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kharoshthi
  static TextStyle notoSansKharoshthi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b94814f220a98ae488817ea138d9436c643e6c3656ce951693ddfc0c269b95d',
        68856,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKharoshthi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Kharoshthi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Kharoshthi
  static TextTheme notoSansKharoshthiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKharoshthi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKharoshthi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKharoshthi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKharoshthi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKharoshthi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKharoshthi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKharoshthi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKharoshthi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKharoshthi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKharoshthi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKharoshthi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKharoshthi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKharoshthi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKharoshthi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKharoshthi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Khmer font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Khmer
  static TextStyle notoSansKhmer({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72ba13c4664950bd5c5b075871408c323592d15ed9536aec1e0998edc3efefef',
        104852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05b8197e75a9102b2755c7350ded9777597e59e345e1114fbfe7cce7a9bd9d3e',
        104928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '727e5835b3301d8d25b3db31b075f165a925b6be39786ebd02b4b1d85a53f65f',
        104832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4760c3b866a8271667cc4916395b22eac1d6aff1ee3668d78b2bfe27757de55',
        104108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e37cff5430a864935d31c8ebbcd933f47f411e4f51639048b12820625fdf59d2',
        104672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4654a50584cc4128d05b10360e5df946a9d2fcbda6ca556b1ab31d95f039604c',
        104664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f1ee635cadec5587a4cff9a2b73cdf80cafe5d2f4f722ff179f8a71872b13b6',
        104640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70886a4939eb90f115cca9dd89755eac56585b4c50d5cb9b95d07e853a25e8c3',
        104772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '930f80e59fb0c0b09b97acfbec12c3c32ffeb670b16ec790e52c57c554e9d300',
        104624,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKhmer',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Khmer font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Khmer
  static TextTheme notoSansKhmerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKhmer(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKhmer(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKhmer(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKhmer(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKhmer(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKhmer(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKhmer(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKhmer(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKhmer(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKhmer(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKhmer(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKhmer(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKhmer(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKhmer(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKhmer(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Khojki font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Khojki
  static TextStyle notoSansKhojki({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd23abe036b64670540b83b75265e6217f7d2a090badfabf3262aa6d93a9bc80f',
        75924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKhojki',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Khojki font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Khojki
  static TextTheme notoSansKhojkiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKhojki(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKhojki(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKhojki(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKhojki(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKhojki(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKhojki(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKhojki(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKhojki(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKhojki(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKhojki(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKhojki(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKhojki(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKhojki(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKhojki(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKhojki(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Khudawadi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Khudawadi
  static TextStyle notoSansKhudawadi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23d02af90d92b27af0c8707b1f54501bf70ac2c3e4402f0a2dd0d6bf0a35cbb6',
        50232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansKhudawadi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Khudawadi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Khudawadi
  static TextTheme notoSansKhudawadiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansKhudawadi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansKhudawadi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansKhudawadi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansKhudawadi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansKhudawadi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansKhudawadi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansKhudawadi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansKhudawadi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansKhudawadi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansKhudawadi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansKhudawadi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansKhudawadi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansKhudawadi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansKhudawadi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansKhudawadi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Lao font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lao
  static TextStyle notoSansLao({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '127a4439a64b1cd89a8f934f86adeeb4e2499e58993998bb2b5358e8bfb1b7eb',
        51160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb8c464b291da97d4a2e5bc4adeb0a34f509c010c5bb1add502ed0aa3f0ef3a7',
        51328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae3fe53d4302e0ec888fe8db24e9b323c9e6cb9e56bb2cb0e19e8a19c1e434f7',
        51284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '232c83e24b125b87821a9cabf2f6721fe94ef375cc9d9b1da43b8ce92477149f',
        50980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7f149f20d1cca4edfc3dcfac42d612550d02f6d274aaee74c23248d6f808a9c',
        51212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16097ed88a7358620bc278d6fa90fbf83f516edc88c8a8abb379c194b7a5e3eb',
        51204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48ca9c450f43eddc302e1a9a670712e6823c6f1fedeefdcb87728504cc5d0b11',
        51124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3c52928d682c98ed6ee2488253604c3e2008b1b48429d4ff3ea8f36acefff65',
        51232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d2b5543dcf46e144f4d4b32429493d37f4baaa0febaac775883c2bf72c86a54',
        51064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLao',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Lao font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lao
  static TextTheme notoSansLaoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLao(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLao(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLao(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLao(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLao(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLao(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLao(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLao(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLao(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLao(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLao(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLao(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLao(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLao(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLao(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Lao Looped font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lao+Looped
  static TextStyle notoSansLaoLooped({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae944a1723385b9a6340716a9438d5dd3f32bb773eeb8229436ce30af62df952',
        59288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c565847a1277773869970d285f9ee2a8741d1e376824f6051227409a4dde21f',
        59508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a2a8e1da322cf28fe122b0d758df8c6a4b863e4988ae9466b433f654527a4cf',
        59484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17552cd9c630dddaf73f267a345289f93569200976b3f6c6f0398f2609609173',
        59412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1759d523e8632b63715af60c1037e9edde5dfd934b454e0889536a9ec86a2cf9',
        59844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0da8e8fd587f38bb80626e8e49931ca09efcb20ffb5ad73b6a492000609980e',
        61788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fcdd43198044502607ba942750235475d473789d46e55b10c0ba7607bbd3569d',
        61724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '774a47fbaf119f05f4b647e310bb7a2192cda65455c5b708986c1695810dcd1b',
        61804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '856dffc0ee5fe40fc1982654fc87370d43977e9378c71bead7af6b7c71fdd84e',
        61728,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLaoLooped',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Lao Looped font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lao+Looped
  static TextTheme notoSansLaoLoopedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLaoLooped(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLaoLooped(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLaoLooped(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLaoLooped(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLaoLooped(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLaoLooped(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLaoLooped(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLaoLooped(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLaoLooped(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLaoLooped(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLaoLooped(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLaoLooped(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLaoLooped(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLaoLooped(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLaoLooped(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Lepcha font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lepcha
  static TextStyle notoSansLepcha({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '020c08e312c5994a0dd79b6745942edbfef0af7e4d58004ebabeb72fefe45872',
        52480,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLepcha',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Lepcha font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lepcha
  static TextTheme notoSansLepchaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLepcha(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLepcha(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLepcha(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLepcha(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLepcha(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLepcha(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLepcha(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLepcha(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLepcha(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLepcha(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLepcha(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLepcha(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLepcha(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLepcha(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLepcha(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Limbu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Limbu
  static TextStyle notoSansLimbu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c627924fe0ab05ac75287e4dd2c3c84b9faa5d74dadc024d49236dc1b5560142',
        40984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLimbu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Limbu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Limbu
  static TextTheme notoSansLimbuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLimbu(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLimbu(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLimbu(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLimbu(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLimbu(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLimbu(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLimbu(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLimbu(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLimbu(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLimbu(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLimbu(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLimbu(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLimbu(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLimbu(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLimbu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Linear A font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Linear+A
  static TextStyle notoSansLinearA({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96600672a897e52664785e2066f3ff838549020a4e45a7ec82b96a3854edc480',
        104760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLinearA',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Linear A font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Linear+A
  static TextTheme notoSansLinearATextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLinearA(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLinearA(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLinearA(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLinearA(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLinearA(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLinearA(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLinearA(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLinearA(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLinearA(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLinearA(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLinearA(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLinearA(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLinearA(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLinearA(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLinearA(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Linear B font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Linear+B
  static TextStyle notoSansLinearB({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd609a37cfc2c42016972002d0af32419db0770a0d7dc44fc621258ba6b795117',
        92600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLinearB',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Linear B font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Linear+B
  static TextTheme notoSansLinearBTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLinearB(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLinearB(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLinearB(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLinearB(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLinearB(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLinearB(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLinearB(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLinearB(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLinearB(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLinearB(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLinearB(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLinearB(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLinearB(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLinearB(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLinearB(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Lisu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lisu
  static TextStyle notoSansLisu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c49432552e20e3f62ef040ffdc11002ea11fca72415b406cf631e29b07ef0be8',
        37180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3717115f5ad75c43529b5aa49d84523c71293c54c08cbf2d8d007bef0d9a67c5',
        37264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '878dc105eaf485ae63506fea0b7ce5973cce10d20279fe6a9ca8549a4baebbae',
        37216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '90f61d4bbaf646bf4e596dcca1475ab64bf8103486645f142c5c5941e87b1ad9',
        37180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLisu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Lisu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lisu
  static TextTheme notoSansLisuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLisu(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLisu(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLisu(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLisu(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLisu(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLisu(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLisu(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLisu(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLisu(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLisu(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLisu(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLisu(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLisu(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLisu(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLisu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Lycian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lycian
  static TextStyle notoSansLycian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df20c1793b03cf4d6caf915fad42333ef28a6a736083b45463ce7263e01329cf',
        3380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLycian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Lycian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lycian
  static TextTheme notoSansLycianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLycian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLycian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLycian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLycian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLycian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLycian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLycian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLycian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLycian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLycian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLycian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLycian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLycian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLycian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLycian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Lydian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lydian
  static TextStyle notoSansLydian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f797e099cc6e8f4702b7865fb6b39b767bb71a7b305b456d6f39bb5945731fa2',
        35112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansLydian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Lydian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Lydian
  static TextTheme notoSansLydianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansLydian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansLydian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansLydian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansLydian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansLydian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansLydian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansLydian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansLydian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansLydian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansLydian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansLydian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansLydian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansLydian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansLydian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansLydian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Mahajani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mahajani
  static TextStyle notoSansMahajani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8279f3206f7e0c4f66d7316ee36a0097bf0119323674e2077bd8d38b1b7f7f7b',
        44252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMahajani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Mahajani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mahajani
  static TextTheme notoSansMahajaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMahajani(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMahajani(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMahajani(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMahajani(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMahajani(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMahajani(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMahajani(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMahajani(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMahajani(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMahajani(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMahajani(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMahajani(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMahajani(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMahajani(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMahajani(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Malayalam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Malayalam
  static TextStyle notoSansMalayalam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b8d35194f940736f430a3a211a725f39a937884001097e2048f85805f46bd56',
        105632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e078b6431dbe71d939d2411922d374a2f8c80b3aa1ab6bc36af4925f6a7b5ca1',
        105708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d6d368b2ee426fb43849bb7085825c1b7e5ab87ecfa62c4d49218fc97c2cd08',
        105696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '221c8014db9d15c51bcc8d8b00996ed3cbcf4d4459e952877aa44a346163b895',
        105588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1264c2c17aed19e40c104e8673fbe55fedfcdc2cd1f87522dbaaaca4aa5aaf99',
        105628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77fb71010d276b5566431f68897d74251b2fedef8c5c8bfeb5dfa89ef5e10d4b',
        105652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec83d58af592372d1e32fe75b9662c77667c7d024c21a657ce331c54c615a141',
        105548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60916a193e6d1ffc49007dae5f9dcec7e28b675d52c833c7da0a91a012d64394',
        105664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a0fbbafead1251b45de6e2226a0ecc12207b51c5de792c688cd09bbf3308dbd',
        105580,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMalayalam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Malayalam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Malayalam
  static TextTheme notoSansMalayalamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMalayalam(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMalayalam(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMalayalam(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMalayalam(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMalayalam(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMalayalam(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMalayalam(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMalayalam(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMalayalam(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMalayalam(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMalayalam(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMalayalam(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMalayalam(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMalayalam(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMalayalam(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Mandaic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mandaic
  static TextStyle notoSansMandaic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46dd452ead45cbe470bae01bab8e86f136a2029c522703e10373803ee5a5587b',
        44700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMandaic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Mandaic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mandaic
  static TextTheme notoSansMandaicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMandaic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMandaic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMandaic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMandaic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMandaic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMandaic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMandaic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMandaic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMandaic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMandaic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMandaic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMandaic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMandaic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMandaic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMandaic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Manichaean font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Manichaean
  static TextStyle notoSansManichaean({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fce204c4682be118f3e119ac74950ac52826bd737aaf82a0340c84412ba0abd8',
        62772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansManichaean',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Manichaean font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Manichaean
  static TextTheme notoSansManichaeanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansManichaean(textStyle: textTheme.displayLarge),
      displayMedium: notoSansManichaean(textStyle: textTheme.displayMedium),
      displaySmall: notoSansManichaean(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansManichaean(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansManichaean(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansManichaean(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansManichaean(textStyle: textTheme.titleLarge),
      titleMedium: notoSansManichaean(textStyle: textTheme.titleMedium),
      titleSmall: notoSansManichaean(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansManichaean(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansManichaean(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansManichaean(textStyle: textTheme.bodySmall),
      labelLarge: notoSansManichaean(textStyle: textTheme.labelLarge),
      labelMedium: notoSansManichaean(textStyle: textTheme.labelMedium),
      labelSmall: notoSansManichaean(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Marchen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Marchen
  static TextStyle notoSansMarchen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79f70ab10953303aa753e1bdcafe3d3a651bcc21792f3bdae76df5cfbe155c5d',
        155416,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMarchen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Marchen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Marchen
  static TextTheme notoSansMarchenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMarchen(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMarchen(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMarchen(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMarchen(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMarchen(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMarchen(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMarchen(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMarchen(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMarchen(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMarchen(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMarchen(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMarchen(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMarchen(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMarchen(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMarchen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Masaram Gondi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Masaram+Gondi
  static TextStyle notoSansMasaramGondi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd54b271adf9dc8d313a02c15bd49f5095d5fd616ae922d3ba3060ccd154118c1',
        57696,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMasaramGondi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Masaram Gondi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Masaram+Gondi
  static TextTheme notoSansMasaramGondiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMasaramGondi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMasaramGondi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMasaramGondi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMasaramGondi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMasaramGondi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMasaramGondi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMasaramGondi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMasaramGondi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMasaramGondi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMasaramGondi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMasaramGondi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMasaramGondi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMasaramGondi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMasaramGondi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMasaramGondi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Math font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Math
  static TextStyle notoSansMath({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '58483f7c774ee00196ecfc9f293caa468f4ee7777943d47bfe4c4a0c0cc7b8b9',
        372264,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMath',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Math font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Math
  static TextTheme notoSansMathTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMath(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMath(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMath(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMath(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMath(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMath(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMath(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMath(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMath(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMath(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMath(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMath(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMath(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMath(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMath(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Mayan Numerals font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mayan+Numerals
  static TextStyle notoSansMayanNumerals({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e855129f80244b8c9049cd698029f49c950a19107aca5d59193d4acf47f38c7f',
        34448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMayanNumerals',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Mayan Numerals font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mayan+Numerals
  static TextTheme notoSansMayanNumeralsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMayanNumerals(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMayanNumerals(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMayanNumerals(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMayanNumerals(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansMayanNumerals(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMayanNumerals(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMayanNumerals(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMayanNumerals(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMayanNumerals(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMayanNumerals(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMayanNumerals(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMayanNumerals(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMayanNumerals(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMayanNumerals(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMayanNumerals(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Medefaidrin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Medefaidrin
  static TextStyle notoSansMedefaidrin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab5d8ee17c3f3a6886f764ea3c8a8d0303359b095ea03711d0eee1a785e358fc',
        66120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7cbc89a08b4cf33ecefe3f302b71825fcf9e9f6ace16a5c89cf18eae21791e04',
        66164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c85d8a6c334b756383321b8a9d9af79f79fd5af219c134a2b12ac03f33fda45f',
        66184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '722e3c89476f0f21248b51cc0f39d6aa475dc78d43f68a85c7d67767be6175cc',
        66096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMedefaidrin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Medefaidrin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Medefaidrin
  static TextTheme notoSansMedefaidrinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMedefaidrin(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMedefaidrin(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMedefaidrin(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMedefaidrin(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMedefaidrin(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMedefaidrin(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMedefaidrin(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMedefaidrin(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMedefaidrin(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMedefaidrin(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMedefaidrin(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMedefaidrin(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMedefaidrin(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMedefaidrin(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMedefaidrin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Meetei Mayek font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Meetei+Mayek
  static TextStyle notoSansMeeteiMayek({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83e9b683030f2db7ab8a8cd9b7248b9049da166488bc3e54d8b1341333c662d8',
        45364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53521c7d6617ec20970b884cd9d21e768f90a667593da9e98bd29963c34ca5be',
        45452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d62305027547b9baedf26e0c81d95e18b371f93b097a2c1990320ba6ed206e2',
        45428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93ec53cc9102724166dffb32e8e1fdedc380b8b36242ed70b434e0a4f25d42cd',
        45252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ec9a00a61c5b4186d2995a84fba259cf12eaf3eb42f731c7bfb9422b7c1ec5c',
        45336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbbef6e79fda754592492ea894e3a7f2bdb3715c32b970097f174fac5fc49958',
        45312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2431068eb54c45e28377d9d20ef4ba8de55da01114683867f8b423f16220b1c1',
        45220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f1f48d02c6f12562d7a9c92ea45a221bef2ac44afd94217384cd4be66df10f0',
        45364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c1dfda38f1a2b68c05677ef5fe41ff5142645bc15a4e5bbed4daf4fe70d1a8c',
        45252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMeeteiMayek',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Meetei Mayek font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Meetei+Mayek
  static TextTheme notoSansMeeteiMayekTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMeeteiMayek(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMeeteiMayek(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMeeteiMayek(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMeeteiMayek(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMeeteiMayek(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMeeteiMayek(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMeeteiMayek(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMeeteiMayek(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMeeteiMayek(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMeeteiMayek(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMeeteiMayek(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMeeteiMayek(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMeeteiMayek(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMeeteiMayek(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMeeteiMayek(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Mende Kikakui font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mende+Kikakui
  static TextStyle notoSansMendeKikakui({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8e004c8ca5a1ce2847843459f584f5f8f94ac26c66e6c96cdb5bd705581e2d5',
        62832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMendeKikakui',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Mende Kikakui font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mende+Kikakui
  static TextTheme notoSansMendeKikakuiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMendeKikakui(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMendeKikakui(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMendeKikakui(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMendeKikakui(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMendeKikakui(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMendeKikakui(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMendeKikakui(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMendeKikakui(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMendeKikakui(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMendeKikakui(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMendeKikakui(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMendeKikakui(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMendeKikakui(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMendeKikakui(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMendeKikakui(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Meroitic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Meroitic
  static TextStyle notoSansMeroitic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ee7a46c9bc32ceb19dad93f4ee16858eff7a1455d53c8427dffa1047d7fdde4',
        60520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMeroitic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Meroitic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Meroitic
  static TextTheme notoSansMeroiticTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMeroitic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMeroitic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMeroitic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMeroitic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMeroitic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMeroitic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMeroitic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMeroitic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMeroitic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMeroitic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMeroitic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMeroitic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMeroitic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMeroitic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMeroitic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Miao font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Miao
  static TextStyle notoSansMiao({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9837d482b38755f7ef9a20d2b8988836c9bff601c6db41abfc207a479e197648',
        67504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMiao',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Miao font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Miao
  static TextTheme notoSansMiaoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMiao(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMiao(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMiao(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMiao(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMiao(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMiao(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMiao(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMiao(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMiao(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMiao(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMiao(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMiao(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMiao(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMiao(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMiao(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Modi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Modi
  static TextStyle notoSansModi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de1b47ebf4832abbd8156e79479cc55be3f69886b1d6a8b9f0c35a29323882df',
        77880,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansModi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Modi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Modi
  static TextTheme notoSansModiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansModi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansModi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansModi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansModi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansModi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansModi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansModi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansModi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansModi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansModi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansModi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansModi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansModi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansModi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansModi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Mongolian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mongolian
  static TextStyle notoSansMongolian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b40b123c0efe8ec4d3ea328a459991a83a0d67dfc1f5a7143b3e3cd9fb1f1845',
        320868,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMongolian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Mongolian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mongolian
  static TextTheme notoSansMongolianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMongolian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMongolian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMongolian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMongolian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMongolian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMongolian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMongolian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMongolian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMongolian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMongolian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMongolian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMongolian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMongolian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMongolian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMongolian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mono
  static TextStyle notoSansMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '420f5548aa0c7f00ab61c0ca3e680c16993db8e6e0874156fe731c17ef59bf20',
        389296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '261988e6f5e4124272528981a924d563c1f8faae015222b2922db37cba1c92d9',
        389820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f35aa3a6814eba8dc72284accd9c2a87050c9c81ce1d87902101c9ec37d87a9',
        389668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af8f8c856e282301d978d7e0d608debc49661f2d009ea5007f3ce8cbc9116907',
        388844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff90b2a6fef96df57c1601781b58a56368509c90f45282b52e06f19350fc615a',
        389248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5af33409c59109b49840198509b133168be0c0e7551613fcefdb37ed9ff9317',
        389156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3537276bb7c892bf4eb621549974ca53f2c09912b9a517d806ed03117bd74af',
        388552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a19a5320c7788fb7819ad5216d384e0d1bb0f0124d18b8a23a452d8ce9bfa54',
        388864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ffcabb32848d395e7ff096943949e9a382e8b4e9153c6a60de426eb14b3e68e3',
        388384,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mono
  static TextTheme notoSansMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMono(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMono(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMono(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMono(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMono(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMono(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMono(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMono(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMono(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMono(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMono(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMono(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMono(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMono(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Mro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mro
  static TextStyle notoSansMro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f7de89bd3a1bc57332bd6cf608afbd219b4d05c5cc045674efea380438013b4',
        36520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Mro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Mro
  static TextTheme notoSansMroTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMro(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMro(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMro(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMro(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMro(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMro(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMro(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMro(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMro(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMro(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMro(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMro(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMro(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMro(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Multani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Multani
  static TextStyle notoSansMultani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c181c4209bcb48190187856c3f649b0abc6e8f3160877fa8e2188bec1ccced4b',
        39720,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMultani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Multani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Multani
  static TextTheme notoSansMultaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMultani(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMultani(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMultani(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMultani(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMultani(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMultani(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMultani(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMultani(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMultani(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMultani(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMultani(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMultani(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMultani(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMultani(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMultani(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Myanmar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Myanmar
  static TextStyle notoSansMyanmar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f979ca37627e5212a79d2bf68419c85054e3310a5deeb5a1f7f34595f67b2a32',
        151988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c54a8217f763efd7148cefea05f798de6a49426516abec96d6a870ebabd883c8',
        150128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f9ef0623535f1522ec0af734d5b5e58696e2416e832a693ea927c903f850034',
        148240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0c9d06b2ef6a27c0e3c893cc3dc749b36045d249dcfb4d8eb1a68fe9534aadd',
        146952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd0c67134ef7337f8c3de5c53c0672c44e9aae5a1eb120f214f79af21524755e',
        145836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c88e9603fb22b1377132e7f92cdc51ad336270e3726f7ecfa218d03d69f5288',
        145144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32aef232e66dde0e3267acfc4a25118e5a5c2c9d553038fea849acb7d5ef35f7',
        144628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee98aabb35c85d90e8784df4e8d25761da43eea2c5965e6e798f97d58d1d40e6',
        144580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70d87a8150edd32cc0b125045824f270b9406e6d30f9f8a69821655dc20be43d',
        146152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansMyanmar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Myanmar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Myanmar
  static TextTheme notoSansMyanmarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansMyanmar(textStyle: textTheme.displayLarge),
      displayMedium: notoSansMyanmar(textStyle: textTheme.displayMedium),
      displaySmall: notoSansMyanmar(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansMyanmar(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansMyanmar(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansMyanmar(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansMyanmar(textStyle: textTheme.titleLarge),
      titleMedium: notoSansMyanmar(textStyle: textTheme.titleMedium),
      titleSmall: notoSansMyanmar(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansMyanmar(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansMyanmar(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansMyanmar(textStyle: textTheme.bodySmall),
      labelLarge: notoSansMyanmar(textStyle: textTheme.labelLarge),
      labelMedium: notoSansMyanmar(textStyle: textTheme.labelMedium),
      labelSmall: notoSansMyanmar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans NKo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+NKo
  static TextStyle notoSansNKo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71fe73f58e752817701042a10fc8e3eee4f93d9289b0a26da1c5b73c68cc2047',
        53156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansNKo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans NKo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+NKo
  static TextTheme notoSansNKoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansNKo(textStyle: textTheme.displayLarge),
      displayMedium: notoSansNKo(textStyle: textTheme.displayMedium),
      displaySmall: notoSansNKo(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansNKo(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansNKo(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansNKo(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansNKo(textStyle: textTheme.titleLarge),
      titleMedium: notoSansNKo(textStyle: textTheme.titleMedium),
      titleSmall: notoSansNKo(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansNKo(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansNKo(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansNKo(textStyle: textTheme.bodySmall),
      labelLarge: notoSansNKo(textStyle: textTheme.labelLarge),
      labelMedium: notoSansNKo(textStyle: textTheme.labelMedium),
      labelSmall: notoSansNKo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans NKo Unjoined font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+NKo+Unjoined
  static TextStyle notoSansNKoUnjoined({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9bfcc2b955bd65411bdd88690422a22dac2b017492c2a7b8c838f33287ad8f0',
        41564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfcd266662455ff75311ff912c77e29bcec6cc4c2574d871da4d832998f4c378',
        41752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1da2d88e0988a08b59476a6ef52c100c6a765f5798928f67749439a34a6c1077',
        41688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '216e15ccf438954ea97f2cf3a0bc6dd35a584a9dfc2458f119be98ade512db3a',
        41648,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansNKoUnjoined',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans NKo Unjoined font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+NKo+Unjoined
  static TextTheme notoSansNKoUnjoinedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansNKoUnjoined(textStyle: textTheme.displayLarge),
      displayMedium: notoSansNKoUnjoined(textStyle: textTheme.displayMedium),
      displaySmall: notoSansNKoUnjoined(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansNKoUnjoined(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansNKoUnjoined(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansNKoUnjoined(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansNKoUnjoined(textStyle: textTheme.titleLarge),
      titleMedium: notoSansNKoUnjoined(textStyle: textTheme.titleMedium),
      titleSmall: notoSansNKoUnjoined(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansNKoUnjoined(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansNKoUnjoined(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansNKoUnjoined(textStyle: textTheme.bodySmall),
      labelLarge: notoSansNKoUnjoined(textStyle: textTheme.labelLarge),
      labelMedium: notoSansNKoUnjoined(textStyle: textTheme.labelMedium),
      labelSmall: notoSansNKoUnjoined(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Nabataean font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Nabataean
  static TextStyle notoSansNabataean({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b2e1dbab6f16c77b472114428ae501b49a523b84f4166f5a1be838b4aba53f0',
        38048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansNabataean',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Nabataean font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Nabataean
  static TextTheme notoSansNabataeanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansNabataean(textStyle: textTheme.displayLarge),
      displayMedium: notoSansNabataean(textStyle: textTheme.displayMedium),
      displaySmall: notoSansNabataean(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansNabataean(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansNabataean(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansNabataean(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansNabataean(textStyle: textTheme.titleLarge),
      titleMedium: notoSansNabataean(textStyle: textTheme.titleMedium),
      titleSmall: notoSansNabataean(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansNabataean(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansNabataean(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansNabataean(textStyle: textTheme.bodySmall),
      labelLarge: notoSansNabataean(textStyle: textTheme.labelLarge),
      labelMedium: notoSansNabataean(textStyle: textTheme.labelMedium),
      labelSmall: notoSansNabataean(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Nag Mundari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Nag+Mundari
  static TextStyle notoSansNagMundari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48a6a54980082ead7cfe5d7f05972b580dc364579d539725d60e2970f1acb90f',
        38972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '15f0fc6e40917910ddaa4f142a6bcc3c97e5b6506c4ef9e4700d80cb84b00636',
        39064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c76bb09164db44ed68049ca489da74175ff1e9dc221073037bc8b23d5c0b9bc3',
        39000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27dcaff2ae83936e031e108eea0b0ba105e4354b4159d447edc23e45f59196b6',
        38948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansNagMundari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Nag Mundari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Nag+Mundari
  static TextTheme notoSansNagMundariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansNagMundari(textStyle: textTheme.displayLarge),
      displayMedium: notoSansNagMundari(textStyle: textTheme.displayMedium),
      displaySmall: notoSansNagMundari(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansNagMundari(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansNagMundari(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansNagMundari(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansNagMundari(textStyle: textTheme.titleLarge),
      titleMedium: notoSansNagMundari(textStyle: textTheme.titleMedium),
      titleSmall: notoSansNagMundari(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansNagMundari(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansNagMundari(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansNagMundari(textStyle: textTheme.bodySmall),
      labelLarge: notoSansNagMundari(textStyle: textTheme.labelLarge),
      labelMedium: notoSansNagMundari(textStyle: textTheme.labelMedium),
      labelSmall: notoSansNagMundari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Nandinagari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Nandinagari
  static TextStyle notoSansNandinagari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f3c8c2392b23232c58d78a1be76dc4bd3911c552a9a27b1d395829b0d5c47ac',
        122428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansNandinagari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Nandinagari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Nandinagari
  static TextTheme notoSansNandinagariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansNandinagari(textStyle: textTheme.displayLarge),
      displayMedium: notoSansNandinagari(textStyle: textTheme.displayMedium),
      displaySmall: notoSansNandinagari(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansNandinagari(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansNandinagari(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansNandinagari(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansNandinagari(textStyle: textTheme.titleLarge),
      titleMedium: notoSansNandinagari(textStyle: textTheme.titleMedium),
      titleSmall: notoSansNandinagari(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansNandinagari(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansNandinagari(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansNandinagari(textStyle: textTheme.bodySmall),
      labelLarge: notoSansNandinagari(textStyle: textTheme.labelLarge),
      labelMedium: notoSansNandinagari(textStyle: textTheme.labelMedium),
      labelSmall: notoSansNandinagari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans New Tai Lue font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+New+Tai+Lue
  static TextStyle notoSansNewTaiLue({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f50cb33def55d1fec71aeb702d6bc5ad8654fe7aea0d514bf5d7eaa8537c9d0',
        48080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5014809f0a345684f72f65585f25b6630cb35bd5b32dc81cf01a18456dc109b6',
        48140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '420b1371c85c2e8d1c20aab065684c00a748daedd51c1bd40e18261a5f821090',
        48108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '006623514f9dd498e878b47645474774c9243b3289166722084aab85f471783f',
        48056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansNewTaiLue',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans New Tai Lue font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+New+Tai+Lue
  static TextTheme notoSansNewTaiLueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansNewTaiLue(textStyle: textTheme.displayLarge),
      displayMedium: notoSansNewTaiLue(textStyle: textTheme.displayMedium),
      displaySmall: notoSansNewTaiLue(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansNewTaiLue(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansNewTaiLue(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansNewTaiLue(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansNewTaiLue(textStyle: textTheme.titleLarge),
      titleMedium: notoSansNewTaiLue(textStyle: textTheme.titleMedium),
      titleSmall: notoSansNewTaiLue(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansNewTaiLue(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansNewTaiLue(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansNewTaiLue(textStyle: textTheme.bodySmall),
      labelLarge: notoSansNewTaiLue(textStyle: textTheme.labelLarge),
      labelMedium: notoSansNewTaiLue(textStyle: textTheme.labelMedium),
      labelSmall: notoSansNewTaiLue(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Newa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Newa
  static TextStyle notoSansNewa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7ef336ff8fffff798690cfdc96b3bf2cc2ab22bd39d074a678835fb3a550e24',
        185192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansNewa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Newa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Newa
  static TextTheme notoSansNewaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansNewa(textStyle: textTheme.displayLarge),
      displayMedium: notoSansNewa(textStyle: textTheme.displayMedium),
      displaySmall: notoSansNewa(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansNewa(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansNewa(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansNewa(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansNewa(textStyle: textTheme.titleLarge),
      titleMedium: notoSansNewa(textStyle: textTheme.titleMedium),
      titleSmall: notoSansNewa(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansNewa(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansNewa(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansNewa(textStyle: textTheme.bodySmall),
      labelLarge: notoSansNewa(textStyle: textTheme.labelLarge),
      labelMedium: notoSansNewa(textStyle: textTheme.labelMedium),
      labelSmall: notoSansNewa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Nushu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Nushu
  static TextStyle notoSansNushu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67b1fdb30eccba7cfc579ad0ca1ecaa499410f2bf9cc0a23625486f0be7d4e66',
        147252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansNushu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Nushu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Nushu
  static TextTheme notoSansNushuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansNushu(textStyle: textTheme.displayLarge),
      displayMedium: notoSansNushu(textStyle: textTheme.displayMedium),
      displaySmall: notoSansNushu(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansNushu(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansNushu(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansNushu(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansNushu(textStyle: textTheme.titleLarge),
      titleMedium: notoSansNushu(textStyle: textTheme.titleMedium),
      titleSmall: notoSansNushu(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansNushu(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansNushu(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansNushu(textStyle: textTheme.bodySmall),
      labelLarge: notoSansNushu(textStyle: textTheme.labelLarge),
      labelMedium: notoSansNushu(textStyle: textTheme.labelMedium),
      labelSmall: notoSansNushu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Ogham font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Ogham
  static TextStyle notoSansOgham({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '526283d3348840599b2c7158daf293fa375e7e22d550b8c4d0f6ccdc9faa5cc7',
        30924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOgham',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Ogham font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Ogham
  static TextTheme notoSansOghamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOgham(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOgham(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOgham(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOgham(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOgham(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOgham(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOgham(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOgham(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOgham(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOgham(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOgham(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOgham(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOgham(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOgham(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOgham(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Ol Chiki font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Ol+Chiki
  static TextStyle notoSansOlChiki({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '328739990d6b01cfefced3de84f88e43e628ec1399f3e48401a72913cf72285c',
        35788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cec5f5b161612264145a80b3629e056ea597efd6cfe697b03087ff8e4e808c2a',
        35836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1dbece7965aeedc5bee0f2ca3cb7afb12671819b2cb1d186086f1ac5417cbfc',
        35832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ccfdecad1ea5c0654dfcc1d8068ef6ec01bc64e1ea9c444b8bffbcf32e40cd0f',
        35764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOlChiki',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Ol Chiki font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Ol+Chiki
  static TextTheme notoSansOlChikiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOlChiki(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOlChiki(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOlChiki(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOlChiki(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOlChiki(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOlChiki(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOlChiki(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOlChiki(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOlChiki(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOlChiki(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOlChiki(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOlChiki(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOlChiki(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOlChiki(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOlChiki(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Old Hungarian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Hungarian
  static TextStyle notoSansOldHungarian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa4dd2da85803ed92d96129c4bb595752157120d02bd990d306ef4e18cef0505',
        83708,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOldHungarian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Old Hungarian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Hungarian
  static TextTheme notoSansOldHungarianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOldHungarian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOldHungarian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOldHungarian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOldHungarian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOldHungarian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOldHungarian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOldHungarian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOldHungarian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOldHungarian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOldHungarian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOldHungarian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOldHungarian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOldHungarian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOldHungarian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOldHungarian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Old Italic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Italic
  static TextStyle notoSansOldItalic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a9ad82eb2b267be4595e63423ab37909d5a63288b7cdc3febf942767ee3713b',
        34376,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOldItalic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Old Italic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Italic
  static TextTheme notoSansOldItalicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOldItalic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOldItalic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOldItalic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOldItalic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOldItalic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOldItalic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOldItalic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOldItalic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOldItalic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOldItalic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOldItalic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOldItalic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOldItalic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOldItalic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOldItalic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Old North Arabian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+North+Arabian
  static TextStyle notoSansOldNorthArabian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48f548068165ae89385bfbfda4d496ce1c4f87fcc9d391a15fb03ab965746b03',
        36912,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOldNorthArabian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Old North Arabian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+North+Arabian
  static TextTheme notoSansOldNorthArabianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOldNorthArabian(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansOldNorthArabian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOldNorthArabian(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansOldNorthArabian(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansOldNorthArabian(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansOldNorthArabian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOldNorthArabian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOldNorthArabian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOldNorthArabian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOldNorthArabian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOldNorthArabian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOldNorthArabian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOldNorthArabian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOldNorthArabian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOldNorthArabian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Old Permic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Permic
  static TextStyle notoSansOldPermic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9480a7153dc760712f88a7fdf8117020f4c3430783bbb2f18f17cb6206193ea',
        33956,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOldPermic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Old Permic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Permic
  static TextTheme notoSansOldPermicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOldPermic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOldPermic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOldPermic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOldPermic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOldPermic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOldPermic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOldPermic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOldPermic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOldPermic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOldPermic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOldPermic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOldPermic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOldPermic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOldPermic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOldPermic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Old Persian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Persian
  static TextStyle notoSansOldPersian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '691953e556cd0d1c22c53acd85a8a53d7b46c65ba0b25e331b539ac689e828c3',
        42432,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOldPersian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Old Persian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Persian
  static TextTheme notoSansOldPersianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOldPersian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOldPersian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOldPersian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOldPersian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOldPersian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOldPersian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOldPersian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOldPersian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOldPersian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOldPersian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOldPersian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOldPersian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOldPersian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOldPersian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOldPersian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Old Sogdian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Sogdian
  static TextStyle notoSansOldSogdian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f8af79796f87fe18da4252946095768e42675623e0afa295c26b10d8a5a4d1a',
        42456,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOldSogdian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Old Sogdian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Sogdian
  static TextTheme notoSansOldSogdianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOldSogdian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOldSogdian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOldSogdian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOldSogdian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOldSogdian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOldSogdian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOldSogdian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOldSogdian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOldSogdian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOldSogdian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOldSogdian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOldSogdian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOldSogdian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOldSogdian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOldSogdian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Old South Arabian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+South+Arabian
  static TextStyle notoSansOldSouthArabian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff3a197d161bb098ebf3ca97595e594823fe66fb37c9f8cf175a2a0ca36dc8e5',
        34960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOldSouthArabian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Old South Arabian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+South+Arabian
  static TextTheme notoSansOldSouthArabianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOldSouthArabian(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansOldSouthArabian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOldSouthArabian(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansOldSouthArabian(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansOldSouthArabian(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansOldSouthArabian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOldSouthArabian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOldSouthArabian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOldSouthArabian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOldSouthArabian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOldSouthArabian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOldSouthArabian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOldSouthArabian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOldSouthArabian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOldSouthArabian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Old Turkic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Turkic
  static TextStyle notoSansOldTurkic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c117a77666c22aa904a1e048f820b380d9ed6bfb0c977d6cc11c07264070572',
        39240,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOldTurkic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Old Turkic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Old+Turkic
  static TextTheme notoSansOldTurkicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOldTurkic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOldTurkic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOldTurkic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOldTurkic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOldTurkic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOldTurkic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOldTurkic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOldTurkic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOldTurkic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOldTurkic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOldTurkic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOldTurkic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOldTurkic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOldTurkic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOldTurkic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Oriya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Oriya
  static TextStyle notoSansOriya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af3422efa99ae4c107a9ff6fef352ee04d1d691ff40a56c79e5099f0e34b7ecb',
        134544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8d32500940161078fb023786dc7be3842ef8afd0675afc494da7e5628c86233',
        135160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e877ca19a892a6f9c1540386bc946258cf12e5a8f18da74b5cdc59bc760275f8',
        135164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e857bed812397e04264515925bfc5afc2c59e969f65122f1b534865b40ce110',
        135012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24606adbaff42c3a85e6c8547441a34ebc646bc6bff478a8086e5a3cea2058b9',
        135100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7eb869144f8f2ad6a2e3c0ce7a701c568339b673fc0f5355ec1771dec7d9273a',
        135144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae06645639ebc20327f5067f07bde398bcfec1ddf3ccc860b5fafa5d7d508681',
        135128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b73a566e2b70c84d238bd40f86114e0e1c5dbd8df496607ed26d26e7d0eaa77a',
        125048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0c2ce1a3b86fb46dc2d7c790cf34c2a8ac32d015c3d063bfec85d36d51c262e',
        124872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOriya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Oriya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Oriya
  static TextTheme notoSansOriyaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOriya(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOriya(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOriya(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOriya(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOriya(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOriya(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOriya(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOriya(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOriya(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOriya(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOriya(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOriya(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOriya(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOriya(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOriya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Osage font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Osage
  static TextStyle notoSansOsage({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5fe5c4030d622866e99d796f6a016019ce0bae06924e0c81d7aa89acca895d5f',
        40412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOsage',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Osage font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Osage
  static TextTheme notoSansOsageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOsage(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOsage(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOsage(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOsage(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOsage(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOsage(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOsage(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOsage(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOsage(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOsage(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOsage(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOsage(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOsage(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOsage(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOsage(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Osmanya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Osmanya
  static TextStyle notoSansOsmanya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8025fe4ffd39f53709b44fc8c97b72575c6ee96b54452990bb23ec0625af4ddc',
        38124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansOsmanya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Osmanya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Osmanya
  static TextTheme notoSansOsmanyaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansOsmanya(textStyle: textTheme.displayLarge),
      displayMedium: notoSansOsmanya(textStyle: textTheme.displayMedium),
      displaySmall: notoSansOsmanya(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansOsmanya(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansOsmanya(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansOsmanya(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansOsmanya(textStyle: textTheme.titleLarge),
      titleMedium: notoSansOsmanya(textStyle: textTheme.titleMedium),
      titleSmall: notoSansOsmanya(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansOsmanya(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansOsmanya(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansOsmanya(textStyle: textTheme.bodySmall),
      labelLarge: notoSansOsmanya(textStyle: textTheme.labelLarge),
      labelMedium: notoSansOsmanya(textStyle: textTheme.labelMedium),
      labelSmall: notoSansOsmanya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Pahawh Hmong font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Pahawh+Hmong
  static TextStyle notoSansPahawhHmong({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cc6d458cb4c5ac77c53b15c4a87297db60f7004feec8e6c8db50fbc5e507d82',
        49248,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansPahawhHmong',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Pahawh Hmong font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Pahawh+Hmong
  static TextTheme notoSansPahawhHmongTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansPahawhHmong(textStyle: textTheme.displayLarge),
      displayMedium: notoSansPahawhHmong(textStyle: textTheme.displayMedium),
      displaySmall: notoSansPahawhHmong(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansPahawhHmong(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansPahawhHmong(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansPahawhHmong(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansPahawhHmong(textStyle: textTheme.titleLarge),
      titleMedium: notoSansPahawhHmong(textStyle: textTheme.titleMedium),
      titleSmall: notoSansPahawhHmong(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansPahawhHmong(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansPahawhHmong(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansPahawhHmong(textStyle: textTheme.bodySmall),
      labelLarge: notoSansPahawhHmong(textStyle: textTheme.labelLarge),
      labelMedium: notoSansPahawhHmong(textStyle: textTheme.labelMedium),
      labelSmall: notoSansPahawhHmong(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Palmyrene font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Palmyrene
  static TextStyle notoSansPalmyrene({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '072e0c15dfa4818122fde6953ac1a5a62e7d63ea90dd1ff883886da01c10aeb1',
        35560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansPalmyrene',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Palmyrene font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Palmyrene
  static TextTheme notoSansPalmyreneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansPalmyrene(textStyle: textTheme.displayLarge),
      displayMedium: notoSansPalmyrene(textStyle: textTheme.displayMedium),
      displaySmall: notoSansPalmyrene(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansPalmyrene(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansPalmyrene(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansPalmyrene(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansPalmyrene(textStyle: textTheme.titleLarge),
      titleMedium: notoSansPalmyrene(textStyle: textTheme.titleMedium),
      titleSmall: notoSansPalmyrene(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansPalmyrene(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansPalmyrene(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansPalmyrene(textStyle: textTheme.bodySmall),
      labelLarge: notoSansPalmyrene(textStyle: textTheme.labelLarge),
      labelMedium: notoSansPalmyrene(textStyle: textTheme.labelMedium),
      labelSmall: notoSansPalmyrene(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Pau Cin Hau font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Pau+Cin+Hau
  static TextStyle notoSansPauCinHau({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd24e66a902aff59ccfd06ff94e59ebdf769453820635485433fb8c86c2c97504',
        38976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansPauCinHau',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Pau Cin Hau font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Pau+Cin+Hau
  static TextTheme notoSansPauCinHauTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansPauCinHau(textStyle: textTheme.displayLarge),
      displayMedium: notoSansPauCinHau(textStyle: textTheme.displayMedium),
      displaySmall: notoSansPauCinHau(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansPauCinHau(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansPauCinHau(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansPauCinHau(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansPauCinHau(textStyle: textTheme.titleLarge),
      titleMedium: notoSansPauCinHau(textStyle: textTheme.titleMedium),
      titleSmall: notoSansPauCinHau(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansPauCinHau(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansPauCinHau(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansPauCinHau(textStyle: textTheme.bodySmall),
      labelLarge: notoSansPauCinHau(textStyle: textTheme.labelLarge),
      labelMedium: notoSansPauCinHau(textStyle: textTheme.labelMedium),
      labelSmall: notoSansPauCinHau(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Phags Pa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Phags+Pa
  static TextStyle notoSansPhagsPa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11c550113dacfd66111e57e09469834b626d011947d89275b23eb84ba35af1f7',
        38180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansPhagsPa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Phags Pa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Phags+Pa
  static TextTheme notoSansPhagsPaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansPhagsPa(textStyle: textTheme.displayLarge),
      displayMedium: notoSansPhagsPa(textStyle: textTheme.displayMedium),
      displaySmall: notoSansPhagsPa(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansPhagsPa(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansPhagsPa(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansPhagsPa(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansPhagsPa(textStyle: textTheme.titleLarge),
      titleMedium: notoSansPhagsPa(textStyle: textTheme.titleMedium),
      titleSmall: notoSansPhagsPa(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansPhagsPa(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansPhagsPa(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansPhagsPa(textStyle: textTheme.bodySmall),
      labelLarge: notoSansPhagsPa(textStyle: textTheme.labelLarge),
      labelMedium: notoSansPhagsPa(textStyle: textTheme.labelMedium),
      labelSmall: notoSansPhagsPa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Phoenician font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Phoenician
  static TextStyle notoSansPhoenician({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '90a46fbb0735f893449ca11af7f8dd77cda55b173b225af3e3c647c8e324f714',
        35916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansPhoenician',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Phoenician font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Phoenician
  static TextTheme notoSansPhoenicianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansPhoenician(textStyle: textTheme.displayLarge),
      displayMedium: notoSansPhoenician(textStyle: textTheme.displayMedium),
      displaySmall: notoSansPhoenician(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansPhoenician(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansPhoenician(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansPhoenician(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansPhoenician(textStyle: textTheme.titleLarge),
      titleMedium: notoSansPhoenician(textStyle: textTheme.titleMedium),
      titleSmall: notoSansPhoenician(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansPhoenician(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansPhoenician(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansPhoenician(textStyle: textTheme.bodySmall),
      labelLarge: notoSansPhoenician(textStyle: textTheme.labelLarge),
      labelMedium: notoSansPhoenician(textStyle: textTheme.labelMedium),
      labelSmall: notoSansPhoenician(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Psalter Pahlavi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Psalter+Pahlavi
  static TextStyle notoSansPsalterPahlavi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11c3de41d8ffc8e4006465351955617e692a29b66253353b2d5f838602f2fc0e',
        51152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansPsalterPahlavi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Psalter Pahlavi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Psalter+Pahlavi
  static TextTheme notoSansPsalterPahlaviTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansPsalterPahlavi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansPsalterPahlavi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansPsalterPahlavi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansPsalterPahlavi(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansPsalterPahlavi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansPsalterPahlavi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansPsalterPahlavi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansPsalterPahlavi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansPsalterPahlavi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansPsalterPahlavi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansPsalterPahlavi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansPsalterPahlavi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansPsalterPahlavi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansPsalterPahlavi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansPsalterPahlavi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Rejang font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Rejang
  static TextStyle notoSansRejang({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a84258f6a991ee93ba532144e7aa85d62c47c56039cad852c5d7d99d7595ace',
        37696,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansRejang',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Rejang font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Rejang
  static TextTheme notoSansRejangTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansRejang(textStyle: textTheme.displayLarge),
      displayMedium: notoSansRejang(textStyle: textTheme.displayMedium),
      displaySmall: notoSansRejang(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansRejang(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansRejang(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansRejang(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansRejang(textStyle: textTheme.titleLarge),
      titleMedium: notoSansRejang(textStyle: textTheme.titleMedium),
      titleSmall: notoSansRejang(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansRejang(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansRejang(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansRejang(textStyle: textTheme.bodySmall),
      labelLarge: notoSansRejang(textStyle: textTheme.labelLarge),
      labelMedium: notoSansRejang(textStyle: textTheme.labelMedium),
      labelSmall: notoSansRejang(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Runic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Runic
  static TextStyle notoSansRunic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c33a67543c197fcb847a7267c8f49ff70c2497a4895ea1c99ae8a5f3ae6714d3',
        37064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansRunic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Runic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Runic
  static TextTheme notoSansRunicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansRunic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansRunic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansRunic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansRunic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansRunic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansRunic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansRunic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansRunic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansRunic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansRunic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansRunic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansRunic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansRunic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansRunic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansRunic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+SC
  static TextStyle notoSansSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1b8c2a287d23095abd470376c60519c9ff650ae8744b82bf76434ac5438982a',
        10538940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cba9bb657b61103aeb3cd0f360e8d3958c66febf59fbf58a4762f61e52015d36',
        10544320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cdbb86a1d6eca92c7bcaa0c759593bc2600a153600532584a8016c24eaca56c',
        10545812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eacedb2999b6cd30457f3820f277842f0dfbb28152a246fca8161779a8945425',
        10540772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5383032c8e54fc5fa09773ce16483f64d9cdb7d1f8e87073a556051eb60f8529',
        10533968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85c00dac0627c2c0184c24669735fad5adbb4f150bcb320c05620d46ed086381',
        10530476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7a29b6d611205bb39b9a1a5c2be5a48416fbcbcfd7e6de98976e73ecb48720b',
        10530536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '038de57b1dc5f6428317a8b0fc11984789c25f49a9c24d47d33d2c03e3491d28',
        10525556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '501582a5e956ab1f4d9f9b2d683cf1646463eea291b21f928419da5e0c5a26eb',
        10521812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+SC
  static TextTheme notoSansScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSc(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSc(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSc(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSc(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSc(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSc(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSc(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSc(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSc(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSc(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSc(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSc(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSc(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSc(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Samaritan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Samaritan
  static TextStyle notoSansSamaritan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ebd598088cf58542a28e8d255f645c3b2ffd371f6e4407a5fbb559542c17a16a',
        34400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSamaritan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Samaritan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Samaritan
  static TextTheme notoSansSamaritanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSamaritan(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSamaritan(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSamaritan(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSamaritan(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSamaritan(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSamaritan(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSamaritan(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSamaritan(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSamaritan(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSamaritan(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSamaritan(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSamaritan(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSamaritan(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSamaritan(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSamaritan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Saurashtra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Saurashtra
  static TextStyle notoSansSaurashtra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '849abe50bb5d1a86a5c313e3352642022ab099f3e36ec38da14678ea087d7877',
        48172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSaurashtra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Saurashtra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Saurashtra
  static TextTheme notoSansSaurashtraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSaurashtra(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSaurashtra(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSaurashtra(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSaurashtra(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSaurashtra(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSaurashtra(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSaurashtra(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSaurashtra(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSaurashtra(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSaurashtra(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSaurashtra(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSaurashtra(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSaurashtra(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSaurashtra(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSaurashtra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Sharada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sharada
  static TextStyle notoSansSharada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '480540d514a7c1fbf019b379f09b7c2b192e5598d42f43418d614917d6a9cc86',
        85140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSharada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Sharada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sharada
  static TextTheme notoSansSharadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSharada(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSharada(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSharada(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSharada(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSharada(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSharada(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSharada(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSharada(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSharada(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSharada(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSharada(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSharada(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSharada(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSharada(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSharada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Shavian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Shavian
  static TextStyle notoSansShavian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7476dfb42670e340222928d4406087a617c6e8923b6b2a3b389060fa430f5e22',
        36376,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansShavian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Shavian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Shavian
  static TextTheme notoSansShavianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansShavian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansShavian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansShavian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansShavian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansShavian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansShavian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansShavian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansShavian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansShavian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansShavian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansShavian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansShavian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansShavian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansShavian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansShavian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Siddham font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Siddham
  static TextStyle notoSansSiddham({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d12f15587141284d2a8b72572053fbef37838002d9b02fc67eab11dd5effe29',
        150936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSiddham',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Siddham font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Siddham
  static TextTheme notoSansSiddhamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSiddham(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSiddham(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSiddham(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSiddham(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSiddham(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSiddham(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSiddham(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSiddham(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSiddham(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSiddham(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSiddham(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSiddham(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSiddham(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSiddham(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSiddham(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans SignWriting font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+SignWriting
  static TextStyle notoSansSignWriting({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3ac197ee76a5d517b7297fbd9d010109c7e21fc1f33f3536ca0584e7567c139',
        5324616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSignWriting',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans SignWriting font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+SignWriting
  static TextTheme notoSansSignWritingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSignWriting(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSignWriting(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSignWriting(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSignWriting(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSignWriting(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSignWriting(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSignWriting(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSignWriting(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSignWriting(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSignWriting(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSignWriting(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSignWriting(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSignWriting(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSignWriting(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSignWriting(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Sinhala font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sinhala
  static TextStyle notoSansSinhala({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7dd79d0635bc28369441bfbc6287c18e275ff7d433497d682ab61e96be1b703d',
        235976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a41be88a59ddf1bf554c56a443164dac2942771aae9510b36e2d6722a0138e99',
        236000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e03d16330f7e8a8a0ae53dc01c0b016e732a23dd8f472d2c86cd740d903b5c3f',
        236068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0830738b7bf94cff7d13486a59a376e0f37dc3855412a01c45dca26795db140',
        235904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31a77ba663d918ad98f62c8e38dc9784a5b6d59c411c6d95021d9853cf95bc6a',
        235976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ae9aca8aa428f5c8d001059f55324f7b4a87c1e718dfeda03164d42b7e4d75d',
        235904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4684ab5e1fa2fe363b37a9140235836c38155cc2dfb54cc12853610a1ea92a4',
        235576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '879d1e363d8c5cc52018eafb5e3746c8501c8e32ed4dd37c1a4be602b09d35c5',
        235612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0979722dabb0164244f681007c997588598f391089646b02cbe1178246659f93',
        235276,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSinhala',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Sinhala font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sinhala
  static TextTheme notoSansSinhalaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSinhala(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSinhala(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSinhala(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSinhala(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSinhala(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSinhala(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSinhala(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSinhala(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSinhala(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSinhala(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSinhala(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSinhala(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSinhala(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSinhala(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSinhala(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Sogdian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sogdian
  static TextStyle notoSansSogdian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24cfe180420552825d7764ef4bf2c3d021be2e47fe10c6b066cc27b5b7cbdaf8',
        92924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSogdian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Sogdian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sogdian
  static TextTheme notoSansSogdianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSogdian(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSogdian(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSogdian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSogdian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSogdian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSogdian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSogdian(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSogdian(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSogdian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSogdian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSogdian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSogdian(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSogdian(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSogdian(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSogdian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Sora Sompeng font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sora+Sompeng
  static TextStyle notoSansSoraSompeng({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f192190273196b165d833b154581945079f79ac26c6f22eca2ebcc220cbb2829',
        39220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bba68e5c2ec7e1d9b26363aca99e6952a9b7924021461995b1deda974500b846',
        39332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c15d2dfc7bde5ce5ca9afcd49c6c36256d94975610cadbb4520c1b384feac35',
        39276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbd1fed93130128ac53240429a64039b85ab11a41a7b64ffe9c8b898befce24a',
        39228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSoraSompeng',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Sora Sompeng font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sora+Sompeng
  static TextTheme notoSansSoraSompengTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSoraSompeng(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSoraSompeng(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSoraSompeng(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSoraSompeng(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSoraSompeng(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSoraSompeng(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSoraSompeng(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSoraSompeng(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSoraSompeng(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSoraSompeng(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSoraSompeng(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSoraSompeng(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSoraSompeng(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSoraSompeng(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSoraSompeng(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Soyombo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Soyombo
  static TextStyle notoSansSoyombo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dbc443e990dd411e530075af08f7ea00f8de00d73b1c90c0f57918ef2832c690',
        93392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSoyombo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Soyombo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Soyombo
  static TextTheme notoSansSoyomboTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSoyombo(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSoyombo(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSoyombo(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSoyombo(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSoyombo(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSoyombo(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSoyombo(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSoyombo(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSoyombo(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSoyombo(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSoyombo(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSoyombo(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSoyombo(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSoyombo(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSoyombo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Sundanese font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sundanese
  static TextStyle notoSansSundanese({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22dd57c6b210aeaa31f053c361e6277f85de2e53553d02293288cae5c8801e35',
        39544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb7a0fe740480e68dc12110e000fe98e1f63d5e0816dd74aebc97d76630194f8',
        39588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfcfa11f41e565a78783d68741ed94ef0fad437296dc1f8c205c40c696975bce',
        39572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0adabd79858c3623500ddb680ceeabe0cdbf3117f9ae38a1e495aff7bd691461',
        39536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSundanese',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Sundanese font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Sundanese
  static TextTheme notoSansSundaneseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSundanese(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSundanese(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSundanese(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSundanese(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSundanese(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSundanese(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSundanese(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSundanese(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSundanese(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSundanese(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSundanese(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSundanese(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSundanese(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSundanese(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSundanese(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Syloti Nagri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Syloti+Nagri
  static TextStyle notoSansSylotiNagri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67d1583c490e73682fb5462b073dc393dddf32c8772030ef201de1c416b301dc',
        45088,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSylotiNagri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Syloti Nagri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Syloti+Nagri
  static TextTheme notoSansSylotiNagriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSylotiNagri(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSylotiNagri(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSylotiNagri(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSylotiNagri(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSylotiNagri(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSylotiNagri(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSylotiNagri(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSylotiNagri(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSylotiNagri(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSylotiNagri(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSylotiNagri(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSylotiNagri(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSylotiNagri(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSylotiNagri(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSylotiNagri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Symbols font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Symbols
  static TextStyle notoSansSymbols({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4879282b062a488a24e80806f8e8fd2692bc602c8abd2ef845f18f53239ba63',
        183972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b6c7489f7ab2ad160865fb0ad6c2f8156a5432b6da658a8d39118f92cbe009e',
        183984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '670f9a7b24bdf84d33814b0ba00655d9b3df0779f605ced3513246e439704cd5',
        183932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5a4b5bc55955fe7df1362848d5a6a926ccf5d91fee01d5d8129c52f188d8071',
        183596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09387099de22ef77aa5f9496fd30a1e94d8f3dcbdd7198ee67a6e210ab98358d',
        183564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6817526574738eac04697f91f2d7555dcc86bf2e147f6637da9f8f5f10e368c2',
        183484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3a4f8053eb3f1c18a0a3d268f07d87bc27445632906b818960a5beea9f058f0',
        183320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c230f8333023e73bcfa717ccd700c8123d88609f8940c9ad1d32e7a74daa6cb5',
        183300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c448a795d101a8554ee650864193775a5f45912224f4e89995c22b7cf8cd97a',
        183148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSymbols',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Symbols font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Symbols
  static TextTheme notoSansSymbolsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSymbols(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSymbols(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSymbols(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSymbols(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSymbols(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSymbols(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSymbols(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSymbols(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSymbols(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSymbols(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSymbols(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSymbols(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSymbols(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSymbols(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSymbols(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Symbols 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Symbols+2
  static TextStyle notoSansSymbols2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '569cffb8e43ca2ffb96809339def7940db32dc033de9213d55100027e644ce4d',
        702944,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSymbols2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Symbols 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Symbols+2
  static TextTheme notoSansSymbols2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSymbols2(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSymbols2(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSymbols2(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSymbols2(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSymbols2(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSymbols2(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSymbols2(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSymbols2(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSymbols2(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSymbols2(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSymbols2(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSymbols2(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSymbols2(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSymbols2(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSymbols2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Syriac font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Syriac
  static TextStyle notoSansSyriac({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd5f3e781fbea1261bee6913c0c0bee6f257388a886d7fda6506dc648d6062731',
        83144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d6d70880e79dacd920253ffd686eb5a8c0ebe8cd5ba4c57fed3ae96526feb34',
        83232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1fb1c2457c12b9c1e63eef764987ef41484c0e241b77bdd171116a2677c82755',
        83244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9582524ac8df22e9dc2d63a454914815ab1731737de113dc7f91a26ac5d26183',
        82840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acc178be7f92aeda5b41699a4d1de9470e731a24b444629c89debeead9ccc669',
        83128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '331e28f0ac9bc3b17a1638bfbff0ed454065c60b4c5217ab9047d4d14ddbd3f0',
        83256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a65ff98e5d27ded8822e182b52739836b273da15c087fc60f42c14265499946',
        83172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f28ca9d1a3caf93e4b1eb94c492a3386154bb794709a112e69654d29fe8f918',
        83248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3cc0e68b7ceab0d2861227657a0cc5771ea83f80613b8a5f6eb21621c51b246',
        83160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSyriac',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Syriac font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Syriac
  static TextTheme notoSansSyriacTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSyriac(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSyriac(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSyriac(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSyriac(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansSyriac(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSyriac(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSyriac(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSyriac(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSyriac(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSyriac(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSyriac(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSyriac(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSyriac(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSyriac(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSyriac(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Syriac Eastern font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Syriac+Eastern
  static TextStyle notoSansSyriacEastern({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84dfb15e77410e4d214d9af31fb104b6546661a22258c6f190875f40a38a2a24',
        71296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c3e7a689b79856d4b88b83bfd77128e7284aca651d3d1aa252e68f280c5023d',
        71404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fea9001f6098bd11d94ea8b93501821d54c89e03b7dc708dc7a8f3ee78a4c66',
        71440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ecc897115cbb80548c293a2a879d63a7753fee9aefcd111fd2004777a9d9d6b',
        71036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3fad0e998f6c7390c0c91e57bc43e48ec87e3afad868136d3810ec4c7f909b79',
        71300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb73ef36d7ce7127e52d0ae53657afa9ca2b96e58d1f37728df7285d9f877bf3',
        71436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '531abfd8787c113c7c2ed63b6b664231d8c095c794c7aa9be652b00067c4ceda',
        71324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f76a0720961f06bbd013b070caab5d86a6e0c36674c0e519dbb856526edc9f29',
        71424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b809f1381031066fc8900fa07a0c26fe6879d258b1490eb35fb969e5888ebc0',
        71356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansSyriacEastern',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Syriac Eastern font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Syriac+Eastern
  static TextTheme notoSansSyriacEasternTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansSyriacEastern(textStyle: textTheme.displayLarge),
      displayMedium: notoSansSyriacEastern(textStyle: textTheme.displayMedium),
      displaySmall: notoSansSyriacEastern(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansSyriacEastern(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansSyriacEastern(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansSyriacEastern(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansSyriacEastern(textStyle: textTheme.titleLarge),
      titleMedium: notoSansSyriacEastern(textStyle: textTheme.titleMedium),
      titleSmall: notoSansSyriacEastern(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansSyriacEastern(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansSyriacEastern(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansSyriacEastern(textStyle: textTheme.bodySmall),
      labelLarge: notoSansSyriacEastern(textStyle: textTheme.labelLarge),
      labelMedium: notoSansSyriacEastern(textStyle: textTheme.labelMedium),
      labelSmall: notoSansSyriacEastern(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans TC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+TC
  static TextStyle notoSansTc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53debc0456f3a7d4bdb00e14704fc29ea129d38bd8a9f6565cf656ddc27abb91',
        7089040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ef06c341be841ab9e166a9cc7ebc0e39cfe695da81d819672f3d14b3fca56a8',
        7092508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e50ec0d5779016c848855daa73f8d866ef323f0431d5770f53b60a1506f1c4a',
        7092872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4f9cfdee95b77d72fe945347c0b7457f1ffc0d5d05eaf6ff688e60a86067c95',
        7090948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2011294f66de6692639ee00a9e74d67bc9134f251100feb5448ab6322a4a2a75',
        7087068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '440471acbbc2a3b33bf11befde184b2cafe5b0fcde243e2b832357044baa4aa1',
        7084432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22779de66d31884014b0530df89e69d596018a486a84a57994209dff1dcb97cf',
        7085728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5e8e3e746319570b0979bfa3a90b6ec6a84ec38fe9e41c45a395724c31db7b4',
        7082400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b1ab3d7db76aa94006fa19dc38b61e93578833d2e3f268a0a3b0b1321852af6',
        7079980,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans TC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+TC
  static TextTheme notoSansTcTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTc(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTc(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTc(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTc(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTc(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTc(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTc(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTc(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTc(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTc(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTc(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTc(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTc(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTc(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tagalog font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tagalog
  static TextStyle notoSansTagalog({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a3c0a64bf9cb053d4780ffc32c0d2cb50a9c1724d421fad9a2df63011727dfc',
        35828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTagalog',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tagalog font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tagalog
  static TextTheme notoSansTagalogTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTagalog(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTagalog(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTagalog(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTagalog(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTagalog(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTagalog(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTagalog(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTagalog(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTagalog(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTagalog(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTagalog(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTagalog(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTagalog(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTagalog(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTagalog(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tagbanwa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tagbanwa
  static TextStyle notoSansTagbanwa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f021729d9bbe929461b774595c146cef1ab19d31fee5c543c645eed2a0143874',
        29616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTagbanwa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tagbanwa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tagbanwa
  static TextTheme notoSansTagbanwaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTagbanwa(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTagbanwa(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTagbanwa(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTagbanwa(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTagbanwa(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTagbanwa(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTagbanwa(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTagbanwa(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTagbanwa(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTagbanwa(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTagbanwa(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTagbanwa(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTagbanwa(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTagbanwa(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTagbanwa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tai Le font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tai+Le
  static TextStyle notoSansTaiLe({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32d017c911f472b42fc7e84338c8d7b2338340c4c908d0ce41bf1563d535ef1f',
        38484,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTaiLe',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tai Le font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tai+Le
  static TextTheme notoSansTaiLeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTaiLe(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTaiLe(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTaiLe(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTaiLe(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTaiLe(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTaiLe(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTaiLe(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTaiLe(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTaiLe(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTaiLe(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTaiLe(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTaiLe(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTaiLe(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTaiLe(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTaiLe(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tai Tham font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tai+Tham
  static TextStyle notoSansTaiTham({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af4ff0d4f43f99ab641922f1f5c0f67ecf2a6a81d43c50b5eee543ab0c8b6ffb',
        117668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5db6d0b8d7097f9aba9e87d1498e4884275560b8ea0a5a5173d187ba1c53a713',
        117720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d51dc1175a4c5a54b4f476ffed5503711599d9d4933b866bc9ea88ecc5a70e8',
        117712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd0b4cfc17fe3b8ffa1b052bfeabbf7c6cf47fe059402339260c70a44659ed678',
        117600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTaiTham',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tai Tham font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tai+Tham
  static TextTheme notoSansTaiThamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTaiTham(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTaiTham(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTaiTham(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTaiTham(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTaiTham(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTaiTham(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTaiTham(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTaiTham(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTaiTham(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTaiTham(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTaiTham(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTaiTham(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTaiTham(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTaiTham(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTaiTham(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tai Viet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tai+Viet
  static TextStyle notoSansTaiViet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35f59b8823025df79816df793bc058a8aa594ff33963274687ad98a91d06d3e7',
        46172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTaiViet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tai Viet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tai+Viet
  static TextTheme notoSansTaiVietTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTaiViet(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTaiViet(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTaiViet(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTaiViet(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTaiViet(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTaiViet(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTaiViet(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTaiViet(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTaiViet(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTaiViet(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTaiViet(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTaiViet(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTaiViet(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTaiViet(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTaiViet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Takri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Takri
  static TextStyle notoSansTakri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b945aaf129b3e1ac20c92af4d6c89787b8805a71723cf0338c151e489fcadfb',
        50404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTakri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Takri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Takri
  static TextTheme notoSansTakriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTakri(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTakri(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTakri(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTakri(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTakri(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTakri(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTakri(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTakri(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTakri(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTakri(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTakri(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTakri(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTakri(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTakri(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTakri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tamil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tamil
  static TextStyle notoSansTamil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd50ea6f6fa46f41360b2f47653e6526e675445b53164da4600240c91e3392d99',
        77816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14454605d727a1065e3e5a486b556c98d95d53ca23ea9d5d9d16c805f6b36124',
        77940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb1515ad1ca7138c7a7360ffb7aa01fdc19585e8f0fba750557b65d6149277fd',
        77896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1cd0dcb53397c750762c62c6fe588404026168981807487ca6c2335288f9668',
        77700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08db862cd8e271d25c4b8f8f6045ac7912cc9a1f5cb706e42e636706a1faec8e',
        77848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b804880bb1d39bf6dcee0bf33ec65955738296e99149d4ab7a71ab657bac89d',
        77836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00059fb513dd325589b4c928258b7910a3e82ab160d405f40ac5015e1753dbbe',
        77732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f76898aad72851f305e35d6b8ae0ff6fbb0944c281ba41149a57b2c302ab1d1',
        77840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '051bf0813c79c410ece3ed560042464248bff51262e0bf42124f3496f35416a8',
        77748,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTamil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tamil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tamil
  static TextTheme notoSansTamilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTamil(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTamil(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTamil(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTamil(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTamil(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTamil(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTamil(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTamil(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTamil(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTamil(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTamil(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTamil(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTamil(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTamil(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTamil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tamil Supplement font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tamil+Supplement
  static TextStyle notoSansTamilSupplement({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc09a6577d844372e36a3e33ace4bcfcd67f3c2fbbd7122bf6e9fe1307fc0892',
        45524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTamilSupplement',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tamil Supplement font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tamil+Supplement
  static TextTheme notoSansTamilSupplementTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTamilSupplement(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansTamilSupplement(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTamilSupplement(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansTamilSupplement(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansTamilSupplement(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansTamilSupplement(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTamilSupplement(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTamilSupplement(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTamilSupplement(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTamilSupplement(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTamilSupplement(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTamilSupplement(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTamilSupplement(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTamilSupplement(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTamilSupplement(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tangsa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tangsa
  static TextStyle notoSansTangsa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b24ce4454f2a840f5c914c470a95c0bd956e682414ef26afbc61054ef657aa2',
        55540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0581dd667804a12fef642297c0483bfc2d7b23691acda0423edacf3de629db9e',
        55696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b535b0f75c9e2415d5870a1713556ae8ef19550d12515436c8559caa69d1568',
        55708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3222863f1ebb7de741e1fb22c418770966384d9ba4eef1de0af154a55568bca',
        55620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTangsa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tangsa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tangsa
  static TextTheme notoSansTangsaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTangsa(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTangsa(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTangsa(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTangsa(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTangsa(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTangsa(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTangsa(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTangsa(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTangsa(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTangsa(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTangsa(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTangsa(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTangsa(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTangsa(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTangsa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Telugu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Telugu
  static TextStyle notoSansTelugu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd70234e477f99c64e310302a2698cc01fa39483842f2c5b037cbbbed2b0217ac',
        178916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f4e1addd1e53f1c560a940a033f923d055f714c84c84ec05a6a46b3e1d93c048',
        179228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8953f9438b3eca1cfef8a799ad2d3e93aff5a1ebf1bf2c6c09cb33e946f68ff',
        179124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b6fe9739f6b48c5db0f7f44e79706d769fd6fc8b5239ca01a494d31db503f75',
        178468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f213e341ee3c2445f3bb113fdae95dfd9c35629b1417dce21d547c643222bfbf',
        179112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1f3508bba6b6ea294d03dfa467e1fbb812ad501db0296d717bb89a0d186b455',
        179176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '467b408478d7f3f355948e2f1c5a592fd4b57e116a26bbc8842fc2c4c677c20b',
        178920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f859fb543c160081abe615f3df760aeab8e033da7965c2635b3048ca7ed8693d',
        179200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b6af9770075d13aae2269c26d8c8b946b835dbed702ebd4e51c78b6b34ba736',
        179104,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTelugu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Telugu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Telugu
  static TextTheme notoSansTeluguTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTelugu(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTelugu(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTelugu(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTelugu(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTelugu(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTelugu(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTelugu(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTelugu(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTelugu(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTelugu(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTelugu(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTelugu(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTelugu(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTelugu(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTelugu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Thaana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Thaana
  static TextStyle notoSansThaana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bfabbe68302e41eafe55901fe3e6e00949b68593cb0c7f1a165149e14bbc97f',
        46028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8853029b06201ac0f2417e67b2f75b1a6e4a652b395929925dbf40bfdbc92a6f',
        46092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1342dc4a6ea1b22f2e87e9b04236be83d19b0879e13f4e1f4308c6e94074d038',
        46100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96976d930d45181d7c873ccc7d567a54e11d2c84809156807f274db94176653e',
        45936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd14fa86788ad37d57f0e12bcb3419b49a956332af3294ffe486ee1ff13d10b14',
        46040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b75c0f5775418d85fdd1197114675aab27df2db2bdbbfb03f40fc15b4f6290f',
        45980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cb03d409473e7f1fc1aaf4ce2ca2b4d0e0c525b66c71453962aea74a52aef9c9',
        45944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef7bc6b2f4f905960b4d2f27533211b55263df210bafb44b8df70bd1cf50a077',
        46044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '913c63e4e08aa8ab085bb5a627d7222ada51527e78af6d9bbb75ca7ecf56a52c',
        45920,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansThaana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Thaana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Thaana
  static TextTheme notoSansThaanaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansThaana(textStyle: textTheme.displayLarge),
      displayMedium: notoSansThaana(textStyle: textTheme.displayMedium),
      displaySmall: notoSansThaana(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansThaana(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansThaana(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansThaana(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansThaana(textStyle: textTheme.titleLarge),
      titleMedium: notoSansThaana(textStyle: textTheme.titleMedium),
      titleSmall: notoSansThaana(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansThaana(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansThaana(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansThaana(textStyle: textTheme.bodySmall),
      labelLarge: notoSansThaana(textStyle: textTheme.labelLarge),
      labelMedium: notoSansThaana(textStyle: textTheme.labelMedium),
      labelSmall: notoSansThaana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Thai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Thai
  static TextStyle notoSansThai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77e781c33ba38f872109864fcf2f7bab58c7f85d73baf213fbcf7df2a7ea6b3f',
        45684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8dc3faea7ead6f573771d50e3d2cc84b49431295bde43af0bd5f6356a628f72',
        45792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a1ba366a64ee23d486f48f0a276d75baef6432da4db5efb92f7c9b35dd5198d',
        45728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f71b18a03432951e2bce4e74497752958bd8c9976be06201af5390d47922be3',
        45636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c82507facc222df924a0272cda2bfdddc629de12b5684816aea0eb5851a61a7',
        45720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e81c6d83f8a625690b1ecc5de4f6b7b66a4d2ee9cbaf5b4f9ede73359c1db064',
        45732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81bba197f8c779233db14166526e226f68e60cd9e33f2046b80f8075158cb433',
        45640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ae7ca1dae7a3df8e839ae08364e14e8e015337bab7dc2842abfc3315e477404',
        45704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '689d439d52c795a225c7fe4657a1072151407a86cc2910a51280337b8b1f57a3',
        45584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansThai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Thai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Thai
  static TextTheme notoSansThaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansThai(textStyle: textTheme.displayLarge),
      displayMedium: notoSansThai(textStyle: textTheme.displayMedium),
      displaySmall: notoSansThai(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansThai(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansThai(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansThai(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansThai(textStyle: textTheme.titleLarge),
      titleMedium: notoSansThai(textStyle: textTheme.titleMedium),
      titleSmall: notoSansThai(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansThai(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansThai(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansThai(textStyle: textTheme.bodySmall),
      labelLarge: notoSansThai(textStyle: textTheme.labelLarge),
      labelMedium: notoSansThai(textStyle: textTheme.labelMedium),
      labelSmall: notoSansThai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Thai Looped font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Thai+Looped
  static TextStyle notoSansThaiLooped({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a64e0e1ff568c362a0bc61cbe02d779ebe114ae5b4f7f5431e55d393fb63d459',
        63572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd193457dcbb7cb93fd82d3a8787417ac3742d90f9bf435a01f15dc2ebf65fff6',
        63168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29e9a7daf53728c2947cfb8e65594b65f686ec393bbf648d1a680c42621c33be',
        62624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1cded4b6ff57bcd44468cdad2c23ed9813447c846b1a0d165025157ce266cb9',
        61476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '711a4fdb4f6cbeb5c9e29e189ffa2513609c8a1cdc18c1d61dd0c0e2b31074ca',
        61320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fead3b4a2fdd2937fce7df6a853c477e690f53a32b005b8ff7e9e15f3260982',
        61904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1dc2262556e130a1a3aeb62efb2ed12cb4a8d64c4ce3415ac9bacef9ceda347',
        61840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c5246fe6eb20072bbe26ba01fbe1715b09d24a96dfc1997580c1ec0092f67d4',
        61840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '206db11b7d2ffd563e9e799b375b50f513512ea2c5e9a9dfcb5c568c6d1fc339',
        61788,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansThaiLooped',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Thai Looped font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Thai+Looped
  static TextTheme notoSansThaiLoopedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansThaiLooped(textStyle: textTheme.displayLarge),
      displayMedium: notoSansThaiLooped(textStyle: textTheme.displayMedium),
      displaySmall: notoSansThaiLooped(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansThaiLooped(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansThaiLooped(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansThaiLooped(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansThaiLooped(textStyle: textTheme.titleLarge),
      titleMedium: notoSansThaiLooped(textStyle: textTheme.titleMedium),
      titleSmall: notoSansThaiLooped(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansThaiLooped(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansThaiLooped(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansThaiLooped(textStyle: textTheme.bodySmall),
      labelLarge: notoSansThaiLooped(textStyle: textTheme.labelLarge),
      labelMedium: notoSansThaiLooped(textStyle: textTheme.labelMedium),
      labelSmall: notoSansThaiLooped(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tifinagh font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tifinagh
  static TextStyle notoSansTifinagh({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61132aea89675d453c3fe4cb274664280a1ace93ecf135e5c0a0fe40ba939ad9',
        57896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTifinagh',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tifinagh font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tifinagh
  static TextTheme notoSansTifinaghTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTifinagh(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTifinagh(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTifinagh(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTifinagh(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTifinagh(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTifinagh(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTifinagh(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTifinagh(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTifinagh(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTifinagh(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTifinagh(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTifinagh(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTifinagh(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTifinagh(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTifinagh(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Tirhuta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tirhuta
  static TextStyle notoSansTirhuta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '967de4f8fa63baf921cb432da2a67757780933f51701291da0b6671a7c2a1084',
        97732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansTirhuta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Tirhuta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Tirhuta
  static TextTheme notoSansTirhutaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansTirhuta(textStyle: textTheme.displayLarge),
      displayMedium: notoSansTirhuta(textStyle: textTheme.displayMedium),
      displaySmall: notoSansTirhuta(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansTirhuta(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansTirhuta(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansTirhuta(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansTirhuta(textStyle: textTheme.titleLarge),
      titleMedium: notoSansTirhuta(textStyle: textTheme.titleMedium),
      titleSmall: notoSansTirhuta(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansTirhuta(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansTirhuta(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansTirhuta(textStyle: textTheme.bodySmall),
      labelLarge: notoSansTirhuta(textStyle: textTheme.labelLarge),
      labelMedium: notoSansTirhuta(textStyle: textTheme.labelMedium),
      labelSmall: notoSansTirhuta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Ugaritic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Ugaritic
  static TextStyle notoSansUgaritic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc83b96e6ee92a9494711cabc1339e68139456442d40d478d5a6b9d1ec64fd59',
        37020,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansUgaritic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Ugaritic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Ugaritic
  static TextTheme notoSansUgariticTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansUgaritic(textStyle: textTheme.displayLarge),
      displayMedium: notoSansUgaritic(textStyle: textTheme.displayMedium),
      displaySmall: notoSansUgaritic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansUgaritic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansUgaritic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansUgaritic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansUgaritic(textStyle: textTheme.titleLarge),
      titleMedium: notoSansUgaritic(textStyle: textTheme.titleMedium),
      titleSmall: notoSansUgaritic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansUgaritic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansUgaritic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansUgaritic(textStyle: textTheme.bodySmall),
      labelLarge: notoSansUgaritic(textStyle: textTheme.labelLarge),
      labelMedium: notoSansUgaritic(textStyle: textTheme.labelMedium),
      labelSmall: notoSansUgaritic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Vai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Vai
  static TextStyle notoSansVai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '211b25836b74b707326a59ffacc949268826d58cb9a6df8a00c1a45903d5dfc7',
        81408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansVai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Vai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Vai
  static TextTheme notoSansVaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansVai(textStyle: textTheme.displayLarge),
      displayMedium: notoSansVai(textStyle: textTheme.displayMedium),
      displaySmall: notoSansVai(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansVai(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansVai(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansVai(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansVai(textStyle: textTheme.titleLarge),
      titleMedium: notoSansVai(textStyle: textTheme.titleMedium),
      titleSmall: notoSansVai(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansVai(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansVai(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansVai(textStyle: textTheme.bodySmall),
      labelLarge: notoSansVai(textStyle: textTheme.labelLarge),
      labelMedium: notoSansVai(textStyle: textTheme.labelMedium),
      labelSmall: notoSansVai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Vithkuqi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Vithkuqi
  static TextStyle notoSansVithkuqi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ecd8208ac728835181a2bc03533a315bd3ca4b7935c9e821f9d5ecb9724c26ce',
        48468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '669f78d94619c8ab26256e6a520d028e6535e40718f67e90add49c3bda240e20',
        48544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '027ec6732bc098166e70c162ebcee63dfe818753e5f5f5c9ba49e981104a6694',
        48564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be010cc9308e190e6389632cfc3e46367634bd5c5e49af90bfb6ff33e5cabf71',
        48516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansVithkuqi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Vithkuqi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Vithkuqi
  static TextTheme notoSansVithkuqiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansVithkuqi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansVithkuqi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansVithkuqi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansVithkuqi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansVithkuqi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansVithkuqi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansVithkuqi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansVithkuqi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansVithkuqi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansVithkuqi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansVithkuqi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansVithkuqi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansVithkuqi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansVithkuqi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansVithkuqi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Wancho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Wancho
  static TextStyle notoSansWancho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21c486de3f2e1cf29de43ada5752c1f262d97c53aeddedd8d381d18cf13a91ee',
        44632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansWancho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Wancho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Wancho
  static TextTheme notoSansWanchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansWancho(textStyle: textTheme.displayLarge),
      displayMedium: notoSansWancho(textStyle: textTheme.displayMedium),
      displaySmall: notoSansWancho(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansWancho(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansWancho(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansWancho(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansWancho(textStyle: textTheme.titleLarge),
      titleMedium: notoSansWancho(textStyle: textTheme.titleMedium),
      titleSmall: notoSansWancho(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansWancho(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansWancho(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansWancho(textStyle: textTheme.bodySmall),
      labelLarge: notoSansWancho(textStyle: textTheme.labelLarge),
      labelMedium: notoSansWancho(textStyle: textTheme.labelMedium),
      labelSmall: notoSansWancho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Warang Citi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Warang+Citi
  static TextStyle notoSansWarangCiti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4404b68cb22941176fbbd425a35ed3a042452b88a4a74e4c8fdfac723b1c5635',
        61444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansWarangCiti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Warang Citi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Warang+Citi
  static TextTheme notoSansWarangCitiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansWarangCiti(textStyle: textTheme.displayLarge),
      displayMedium: notoSansWarangCiti(textStyle: textTheme.displayMedium),
      displaySmall: notoSansWarangCiti(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansWarangCiti(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansWarangCiti(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansWarangCiti(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansWarangCiti(textStyle: textTheme.titleLarge),
      titleMedium: notoSansWarangCiti(textStyle: textTheme.titleMedium),
      titleSmall: notoSansWarangCiti(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansWarangCiti(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansWarangCiti(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansWarangCiti(textStyle: textTheme.bodySmall),
      labelLarge: notoSansWarangCiti(textStyle: textTheme.labelLarge),
      labelMedium: notoSansWarangCiti(textStyle: textTheme.labelMedium),
      labelSmall: notoSansWarangCiti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Yi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Yi
  static TextStyle notoSansYi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42b3257b807027d08ea8422470e41ceac749ddaaf7fafe4e646c39f865e3efc0',
        210160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansYi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Yi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Yi
  static TextTheme notoSansYiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansYi(textStyle: textTheme.displayLarge),
      displayMedium: notoSansYi(textStyle: textTheme.displayMedium),
      displaySmall: notoSansYi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSansYi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSansYi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSansYi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansYi(textStyle: textTheme.titleLarge),
      titleMedium: notoSansYi(textStyle: textTheme.titleMedium),
      titleSmall: notoSansYi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansYi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansYi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansYi(textStyle: textTheme.bodySmall),
      labelLarge: notoSansYi(textStyle: textTheme.labelLarge),
      labelMedium: notoSansYi(textStyle: textTheme.labelMedium),
      labelSmall: notoSansYi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Sans Zanabazar Square font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Zanabazar+Square
  static TextStyle notoSansZanabazarSquare({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88c181aa6f79d1294dda079394696797bbce8aec4184f758d4582050ef9574ce',
        47908,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSansZanabazarSquare',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Sans Zanabazar Square font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Sans+Zanabazar+Square
  static TextTheme notoSansZanabazarSquareTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSansZanabazarSquare(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSansZanabazarSquare(textStyle: textTheme.displayMedium),
      displaySmall: notoSansZanabazarSquare(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSansZanabazarSquare(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSansZanabazarSquare(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSansZanabazarSquare(textStyle: textTheme.headlineSmall),
      titleLarge: notoSansZanabazarSquare(textStyle: textTheme.titleLarge),
      titleMedium: notoSansZanabazarSquare(textStyle: textTheme.titleMedium),
      titleSmall: notoSansZanabazarSquare(textStyle: textTheme.titleSmall),
      bodyLarge: notoSansZanabazarSquare(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSansZanabazarSquare(textStyle: textTheme.bodyMedium),
      bodySmall: notoSansZanabazarSquare(textStyle: textTheme.bodySmall),
      labelLarge: notoSansZanabazarSquare(textStyle: textTheme.labelLarge),
      labelMedium: notoSansZanabazarSquare(textStyle: textTheme.labelMedium),
      labelSmall: notoSansZanabazarSquare(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif
  static TextStyle notoSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7fd15a02691cfb99c193341bbb082778b1f3ca27e15fdcb7076816591994b7c7',
        452700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9446cf19cd57af964054d0afd385b76f9dec5e3b927c74a2d955041f97fad39b',
        453240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '384650b173fced05061be4249607b7caedbc6ba463724075c3ede879ee78d456',
        453240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7373b9f9dab0875961c5d214edef00a9384ab593cde30c6462d7b29935ef8b2',
        452276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '105a9e9c9bb80bcf8f8c408ed3473f1d9baad881686ea4602ecebebf22bbed50',
        453160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30257a49c70dd2e8abe6cc6a904df863dbc6f9ccf85f4b28a5c858aaa258eab6',
        453104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dad0f53be4da04bfb608c81cfb72441fba851b336b2bd867592698cfaa2a0c3c',
        452576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12c5c47e6810fc5ea4291b6948adfba87c366eb3c081d66c99f989efd2b55975',
        454040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16f59df53d64f8a896e3dcacadc5b78e8b5fb503318bf01d9ddbe00e90dcceea',
        453924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '98c7bc89a0eca32e9045076dd4557dadf866820b3faf5dffe946614cd59bdbb8',
        479008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '24a3e4603729024047e3af2a77e85fd3064c604b193add5b5ecb48fdeb630f4e',
        479532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '940fb65bf51f2a2306bc12343c9661aa4309634ea15bf2b1a0c8da2d23e9e9f3',
        479180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '65aae32ed0a63e3f6ce0fcde1cd5d04cd179699f7e1fef0d36a24948a3b17ce3',
        477448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '322ec18ea04041aabc9f9b3529ff23e7d4e4e18d4330d39d4d422058c66ddded',
        478256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '77e9996939afbc0723270879a0754de4374091b9b856f19790c098292992859c',
        478316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b4cf981f0033c2e3d72585d84de3980bdfb87eaa4fe1d95392025ecd0fe0b83c',
        477644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a9d0052ceaeea5a1962b7b1a23d995e39dd299ae59cfc288d3e9a68f1bf002e7',
        478924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '99f429bfa3aea82cc9620a6242992534d8c7b10f75d0ec7ca15e1790ca315de7',
        478760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif
  static TextTheme notoSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerif(textStyle: textTheme.displayLarge),
      displayMedium: notoSerif(textStyle: textTheme.displayMedium),
      displaySmall: notoSerif(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerif(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerif(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerif(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerif(textStyle: textTheme.titleLarge),
      titleMedium: notoSerif(textStyle: textTheme.titleMedium),
      titleSmall: notoSerif(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerif(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerif(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerif(textStyle: textTheme.bodySmall),
      labelLarge: notoSerif(textStyle: textTheme.labelLarge),
      labelMedium: notoSerif(textStyle: textTheme.labelMedium),
      labelSmall: notoSerif(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Ahom font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Ahom
  static TextStyle notoSerifAhom({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '902ef97276dae5964414619b0819dc97e4264ec3bc59e72abfdf052bc1d9a4ab',
        60236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifAhom',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Ahom font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Ahom
  static TextTheme notoSerifAhomTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifAhom(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifAhom(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifAhom(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifAhom(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifAhom(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifAhom(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifAhom(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifAhom(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifAhom(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifAhom(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifAhom(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifAhom(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifAhom(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifAhom(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifAhom(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Armenian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Armenian
  static TextStyle notoSerifArmenian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8239ba0a2bef6ce4891f32fbfdce7f85f7a5bb816f5d9c9c10fe9ad76b93e67',
        54044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c22f258868fed08f29adbd789f4b2cc57878714d4e911715c430152a2f5afc7',
        54144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6113fd20cc4198ac9bdb25f8bb7a78c37eba793044083ff386a4a08667189169',
        54108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c04d2bedb24e4b5165a6cce9e35fc7a76904276b7dbdf85d6df0498666860b89',
        53968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bdaf57ba12f5c71c2ce11b1404c46e4305acab169a73fc1b214fad0f5af447b9',
        54080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8a8872d029e81a23318f94912c964243d08c628e36d68a9061b93aca3871521b',
        54024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8615ccd735777e74b9fe54dd653a82d946cfa472c98584afce7174cc62032ed1',
        53900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1ffc894d531f7ea548c225646ec6a0f929b3d7eacbdb3298969dddf2748b62b',
        54216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86823c8a3621d6c008089b5ff8fd62dc63515939f64f91b075b2ef314467e55c',
        54156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifArmenian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Armenian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Armenian
  static TextTheme notoSerifArmenianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifArmenian(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifArmenian(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifArmenian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifArmenian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifArmenian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifArmenian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifArmenian(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifArmenian(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifArmenian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifArmenian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifArmenian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifArmenian(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifArmenian(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifArmenian(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifArmenian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Balinese font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Balinese
  static TextStyle notoSerifBalinese({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b845e0a39410727d93e26a2df2d02ccbe0211f693585d975d9508f76d5c7507',
        87552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifBalinese',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Balinese font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Balinese
  static TextTheme notoSerifBalineseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifBalinese(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifBalinese(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifBalinese(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifBalinese(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifBalinese(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifBalinese(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifBalinese(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifBalinese(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifBalinese(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifBalinese(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifBalinese(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifBalinese(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifBalinese(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifBalinese(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifBalinese(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Bengali font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Bengali
  static TextStyle notoSerifBengali({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1682690ca9054c175b7baebab19ff2c37d445ef5370b0dcdaa04279d1c47702',
        205168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '75cbd95d5194218ec78c1f1c8eb4130243bc8416ca0280d233edf15164c80349',
        206208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b8905e7200fdac4e552a043b93fa813310ed6bb1dd9c451c24ff5f13881344f',
        206168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c614b3c3a31b66924754ce54af7d255ef83677c7fda8d92b0d54f35f0417049e',
        205588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c85a535780e513519a39977cfa04dd10adc133074275637bb832f4ed638574ff',
        206884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cb452679317f6247c5e5f18fa28db00780d382aead10dd24d479b2c483a83553',
        207308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06181ed43a9557b9eb41a7a985aaa7941d8f719e10a6e1c0105aa58be15780ea',
        207484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb9e8f54bac76f3f05e7507d8a3b61df88e8d06e88a1d834dcd5376a56baa24b',
        207584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7c9fc677bf1aa3544fdc54cb8032902ada197ac0d4607409ba0c5714b8205b2',
        207168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifBengali',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Bengali font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Bengali
  static TextTheme notoSerifBengaliTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifBengali(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifBengali(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifBengali(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifBengali(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifBengali(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifBengali(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifBengali(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifBengali(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifBengali(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifBengali(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifBengali(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifBengali(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifBengali(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifBengali(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifBengali(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Devanagari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Devanagari
  static TextStyle notoSerifDevanagari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '706b6f0fd2a7635a1ae9ef3ca53f57d799394351a3e0ed377a90a2e9de6a34e7',
        227892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a17169e761bdd19e1c5c29d9644bdd8d1cbda71ef3f624419d81ec5a705a2a5',
        228240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5fc4c1d0a046723d8ed1799227965b717e8e782479ce864b282bb17ed6b4ba6f',
        228268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'afa276a5f19cb805b629d79a171a485dd9d6980add38c8cc34e09d98c05c476c',
        228004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb47e7bb626f665ba1c8f5c4636894e32f83741759d2b604635596b2f7075cdb',
        228540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f139b269321bf5f80fe83a194b477ace9eb83ff4866c7dac31e4c41894bc1a13',
        228512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9acb6c1d6f69132404d371db2c3ec9196815c3ee85bbacfa72f1472a88532cf9',
        228360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de81ef835a794ee906a82be9f3b7d976d691ec7570af03f99f6851bdb48fd8b5',
        228732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0bc49ea762462fbbfe5052f6c3a9320b56c7f5b59c228b2875d97b66a8ca010a',
        228632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifDevanagari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Devanagari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Devanagari
  static TextTheme notoSerifDevanagariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifDevanagari(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifDevanagari(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifDevanagari(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifDevanagari(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifDevanagari(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifDevanagari(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifDevanagari(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifDevanagari(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifDevanagari(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifDevanagari(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifDevanagari(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifDevanagari(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifDevanagari(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifDevanagari(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifDevanagari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Display
  static TextStyle notoSerifDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09496789f455b508e9e2fcb034f09dcbf993778871b15776e4a5f65e0fe29ed6',
        397740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dffa5e31ecd6b7ed1dfa70c92e9a4d385f75e9d7918942a6ef8cc75fe65990a0',
        398264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6725eafcb9a75a6e0a5ea5d63d6f6eb2b9ecb79c581869bf10f9c8bb1e54a420',
        398412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fea030e164b734431a4198ab13e947e84f17f086a9f9ff78040494d8e466718',
        397456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '278b7cf95a6dd77c3362828b3fcea11eb575f29b8d00e986b3a2311af41e6f0b',
        398416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82ac0c36fdec281f2e74bf9957a2bb48b43e319d6f35d6e6f86d7c3f0987a28a',
        398064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc7a0b934b8f2dc85a266d8d58f9302dd149d6cc6adec725af980117013afef4',
        397628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f0549f6edeb2a40634d139ce919d6b57517effd59c605b040dbf9bccef1d3bb',
        399136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d39b884ebad48cf076fe0888a635bb6d41ecb995a3af622032c590161e47941',
        399260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '14df5251afbc45b5ff4237073022888a1f75999fc00a766bd26ae1d7c6764b18',
        417292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e7723868364cda1888bd564b21014bd4a6ecbff7bd500cf94b298972e2a79bbc',
        417880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e39297379cfa44253768e9c46a8d0c3251eeda47d8fe7acfc1ecc6f40de5fb73',
        417912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '42adc9826b9f7af86243bef4b068f6c94a75e7bd9e29f99799d12b60923146ac',
        416612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8b89baec738ce94e711675448108f1f88321543cfe14bb98bea5174c2d28ca6b',
        417520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '441023feff19a3f739a89f6362a0f14179f02b6b587430a6c0736350623fd75f',
        417812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ae3d942963d6c42aebb7e2850d8b3ff420b90cba2ec0b088c5798abce5fc509b',
        417140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4ca134e40a4efb475e3e126bbcad9b9ee5f85890e4f5724457a1110fc3f9cd08',
        418276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '54ff6d69fe2947c703194508ac298cae7412b1ca27bdf38ee833d784efcc005b',
        418088,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Display
  static TextTheme notoSerifDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifDisplay(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifDisplay(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifDisplay(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifDisplay(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifDisplay(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifDisplay(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifDisplay(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Dogra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Dogra
  static TextStyle notoSerifDogra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '603c709b7a15c33b5e3b60ffdac709e465ed4d6a19d76de864c10b3d5d8acc43',
        56772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifDogra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Dogra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Dogra
  static TextTheme notoSerifDograTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifDogra(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifDogra(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifDogra(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifDogra(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifDogra(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifDogra(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifDogra(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifDogra(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifDogra(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifDogra(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifDogra(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifDogra(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifDogra(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifDogra(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifDogra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Ethiopic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Ethiopic
  static TextStyle notoSerifEthiopic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08d7dce1191625a4518510348526ebf8551e6f326d8c15aa727e7af94172e7ce',
        302672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32025861028fd9d2f1019c90f5f683586da1f4a624345b8c3dc84bb0619ba9e7',
        302840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67ad5ae190b1e613ae6045cfade3bbe22b3afd646928ef072b64ab3d90f1c01a',
        303084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b13a884306387fbb0ed8f3f8604815d275360ace8ef575fbcd0d3d295a77f948',
        303116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1ec4afa5221cd47927f6b023c7b2868922c1f4ec96f5aabb7cf0bf9d316867d',
        303328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '537fc5926ee99eb51997ac1bc7b29a3efa28d5f7e3762320cfb7a49c0912e71f',
        303468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a46d1da5bff7de5911bdf12ee9193378a0eed5848704866a14e46f9fdcd591d',
        303464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e695ea4aa60fa369ce69a9026029a39be222ef5ad46a4a3df2fd2c6f78dc498',
        303532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2e70c709971f7edb51c59811083f14b17bd2568ec6d6d5ed70ce99f6f99ca99',
        303492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifEthiopic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Ethiopic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Ethiopic
  static TextTheme notoSerifEthiopicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifEthiopic(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifEthiopic(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifEthiopic(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifEthiopic(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifEthiopic(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifEthiopic(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifEthiopic(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifEthiopic(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifEthiopic(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifEthiopic(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifEthiopic(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifEthiopic(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifEthiopic(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifEthiopic(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifEthiopic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Georgian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Georgian
  static TextStyle notoSerifGeorgian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bbd3e9afdcb181c76f172fb9e345266e37271df25d4701444388e7e0815307d',
        77296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33be525046f8e68c8d702be30be17f7cbf52da6779a11b126d9cdf275c07f97b',
        77336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3fe40a640af604fa3638719a17218970dcf9b41c4103ef185208a357324285dd',
        77268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd77b567753cede442db483cc031b03b0c5b26afaf95f0810c10da5e9870a7046',
        77204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db0fb3f861b8c7a6fd1ed836bce919834499a13d5f2ee7cfb4c7c7114d89e8b9',
        77284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a038db48e4849a1734c4c9d9e9db90ed44785cba527a8d03581ea4849fdfccd0',
        77304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '087fddca0a893e1dbe44c51c83eb9fb0f4851d55cbac0b1d55262612e03636f7',
        77196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '576675e7a4a605d6d1441553d5bbffcedb46e6ad6023e76086164c54e7447c42',
        77316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d4b57dcef50a9e3f260f1cd3880d459d506fbd702fa08ce1169181dfc5c0804',
        77296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifGeorgian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Georgian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Georgian
  static TextTheme notoSerifGeorgianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifGeorgian(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifGeorgian(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifGeorgian(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifGeorgian(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifGeorgian(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifGeorgian(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifGeorgian(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifGeorgian(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifGeorgian(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifGeorgian(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifGeorgian(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifGeorgian(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifGeorgian(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifGeorgian(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifGeorgian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Grantha font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Grantha
  static TextStyle notoSerifGrantha({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35cd8486d3f431e8ccf5a3e75dd1d4b13dfae9d132ce06ebde9a297641467d41',
        317072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifGrantha',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Grantha font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Grantha
  static TextTheme notoSerifGranthaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifGrantha(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifGrantha(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifGrantha(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifGrantha(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifGrantha(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifGrantha(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifGrantha(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifGrantha(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifGrantha(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifGrantha(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifGrantha(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifGrantha(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifGrantha(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifGrantha(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifGrantha(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Gujarati font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Gujarati
  static TextStyle notoSerifGujarati({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be9458e7bfd352fe14faa5a41e40bc9a5fb5e61a853613839e02c7738fbe5823',
        140428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b2e9dce340c6377009ee80ffca61e77699820e23255fcd7f257bc213571b02e',
        141012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2b7ba3f0a3aaf1235e577202eb762a5a641d542e94a7996260a6265336661e3',
        140996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f443b821b3c654af873e9a29389e133d78c8ddd451ce599601c423356cfc03ad',
        140496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54b9b8583749740f96c61704244659a579d0d0c9e79b5190842db1df468bb912',
        140928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5de18801e9022593e1e4088bb0fcdd37ced019c6566980d49106d4ff657f306b',
        140876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5838878cb8ae5ee7b6341de6aef376c478d580418734e0c841cca74cc1a3338b',
        140420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f6ed9fa01477800c13a5b1b22b044dae49dbfc268e8cd1b1936cec92fc25341',
        140884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7c5a0b93365ecebee0e5817fea59e23a0a6a2c686379b7fd5dc42d25eaf3fba',
        140676,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifGujarati',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Gujarati font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Gujarati
  static TextTheme notoSerifGujaratiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifGujarati(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifGujarati(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifGujarati(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifGujarati(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifGujarati(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifGujarati(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifGujarati(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifGujarati(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifGujarati(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifGujarati(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifGujarati(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifGujarati(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifGujarati(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifGujarati(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifGujarati(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Gurmukhi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Gurmukhi
  static TextStyle notoSerifGurmukhi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b961861a281cd0139258925d5bcc9a7bbf76e6dd939c9114ee576ec2cd22b06',
        65940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11cc4deaf5eb420bbe2dd3ec96cbee15aa8f575e5d253de1e205952384fe0e81',
        66156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51834b2eedee0519d5da88c1b0ab20a8453c4b3c6fc5e132b2ee1ddbc3631303',
        66140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f56f73f48a2476faaa7fc0ca0168a0dbc508c20b0b7d736c41c77094e8abebf',
        66000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b91943d17200b4cabe4f32d18d41fac264dc84db4d7ace1cba71c8e4fccc4c35',
        66076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd863930a9b53a6cccab1775f458f23439798588ae15787d3d98a6268c4dfe2c9',
        66092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f05ea3f96d32d8b8c2532b1d1d95dd712b02e1b0695f91d01e176999786b191',
        65976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a8ada8d4d184624724f000b62f47d626c75fd515e726004e625fd69d4bdb60e',
        66180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50c87cc367ca82622e829879f3de8025f5fefa1b3a2cc3a446c8359591aa078d',
        66060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifGurmukhi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Gurmukhi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Gurmukhi
  static TextTheme notoSerifGurmukhiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifGurmukhi(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifGurmukhi(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifGurmukhi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifGurmukhi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifGurmukhi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifGurmukhi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifGurmukhi(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifGurmukhi(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifGurmukhi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifGurmukhi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifGurmukhi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifGurmukhi(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifGurmukhi(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifGurmukhi(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifGurmukhi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif HK font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+HK
  static TextStyle notoSerifHk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa18f4ac32f8b96e3e9efe0c6c1c4b62579c84088aeb87b692d7232ab4221a2b',
        35063028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '187ce87ea920319caf9258772fa74a7055a873868fdff3db8123173b707cd76d',
        35075216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67c7cff06ce976bb3d387421b16fa4d3e3d5306d2c434fcad9f7adb437fbf754',
        35079044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ff88103c2d940bef81ef7e277cfabb54fcf8d61f16e5734b2e559c222bf1a5b',
        35089064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eabf90b6877bd7df0cb5665d3a82794b3100f4432b115ccdb0a0dc3679ffc46e',
        35087908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b59b37d42e4019dcecee79a8ef4cd7bf6777b9e88d7c043787d0616a6e243ea9',
        35086016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1db7655beb2e737128ec8dfaedb5a6f66d537c5352f41f62dda1a7260ba64ed9',
        35085416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17c7584b0f73220baa28fa5435e083a89b9c58aaaea8f96fe9bc0b900c004ae7',
        35081100,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifHK',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif HK font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+HK
  static TextTheme notoSerifHkTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifHk(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifHk(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifHk(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifHk(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifHk(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifHk(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifHk(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifHk(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifHk(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifHk(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifHk(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifHk(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifHk(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifHk(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifHk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Hebrew font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Hebrew
  static TextStyle notoSerifHebrew({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '304a8f0b5fa585fe4bf508e9ab89f1de6e27c171bf7abdbd0790f9fa3212b4c0',
        50204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a1f648a2072c33a1d5bb1bd517c1e0aebe37f1109a0d67556502d69a1e99279',
        50272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07f984e019a19477a748c0e7a3ac8c37077235b7745428af9e65c820eb457acf',
        50340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d583f4da742e187c516626f5a880c44c438189b86a218cb5b6b8d157236570f',
        50220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25676a3bcc236a518b42d116c4b8568fd07096cfb76663eeca8dc635f6f102fc',
        50272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30108a533ec29d5a6c147ebe055371ac3d6cbd7b4c6a9588a5ca5bd727ca6a38',
        50276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b8d418f0f05366823ea4d1c5c2037ead9dd394d63f385547f17ef954755f34d',
        50256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a95a0f875cd41e8dd0ce4b2e71f0c0e27610560613cd2652a35457238fa8f592',
        50360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e2b3104e2f127cdc56c2f9c42c3f6574ac3ad060a6ea8e8af38276f7728a9bb',
        50268,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifHebrew',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Hebrew font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Hebrew
  static TextTheme notoSerifHebrewTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifHebrew(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifHebrew(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifHebrew(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifHebrew(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifHebrew(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifHebrew(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifHebrew(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifHebrew(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifHebrew(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifHebrew(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifHebrew(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifHebrew(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifHebrew(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifHebrew(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifHebrew(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Kannada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Kannada
  static TextStyle notoSerifKannada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '104e0342ee4ebe6186f7d542806ae67300866b7769a8af76bff8f4147f5a7e4b',
        171132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3e60369b80bf8faa657b62c8f32b32f06b3a7b7dc65d72f2a43aac1930205f0',
        171516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfe2fff5ad3db67fcfa04afd7906c10398aef4f981874dd785e514a4e444bfe9',
        171540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '840b8c989c0059d0c2bf3e41b0b565461fb87d5c3a31f50a941be2024a190515',
        171196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c3bb79b9c776d3d0f5b0b2b0ffdc25af35c901828d573da0c7813914467cd37',
        171672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9434e3e39856195cd442e67697aca668019aa574bf2d16d80e601c491d7a959e',
        171548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6acbfaf182b7f929ba8f1f78c2a032d1d93585a05cb91fea16e423feb9c45245',
        171284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50e74a869cf200e5c3c9436e08d6be76bd588d6f85bbe7cad25d818a6f8f14de',
        171900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91f2ce8513bde471f92bc9c6a1021c24495092f321f6cf2b5ba3894a7fd9c1be',
        171500,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifKannada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Kannada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Kannada
  static TextTheme notoSerifKannadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifKannada(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifKannada(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifKannada(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifKannada(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifKannada(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifKannada(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifKannada(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifKannada(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifKannada(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifKannada(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifKannada(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifKannada(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifKannada(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifKannada(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifKannada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Khitan Small Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Khitan+Small+Script
  static TextStyle notoSerifKhitanSmallScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2aa739919c4f8f3d81e3dfa8e3c90f8e3b99901707106a2ac9776f6cc44b4c6f',
        643204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifKhitanSmallScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Khitan Small Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Khitan+Small+Script
  static TextTheme notoSerifKhitanSmallScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge:
          notoSerifKhitanSmallScript(textStyle: textTheme.displayLarge),
      displayMedium:
          notoSerifKhitanSmallScript(textStyle: textTheme.displayMedium),
      displaySmall:
          notoSerifKhitanSmallScript(textStyle: textTheme.displaySmall),
      headlineLarge:
          notoSerifKhitanSmallScript(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSerifKhitanSmallScript(textStyle: textTheme.headlineMedium),
      headlineSmall:
          notoSerifKhitanSmallScript(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifKhitanSmallScript(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifKhitanSmallScript(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifKhitanSmallScript(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifKhitanSmallScript(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifKhitanSmallScript(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifKhitanSmallScript(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifKhitanSmallScript(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifKhitanSmallScript(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifKhitanSmallScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Khmer font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Khmer
  static TextStyle notoSerifKhmer({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e916a93580d140a1e9204c2b6db6be4654039033c4eda2ee3c86bbfa97a32de1',
        140264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '809c6ba6e8d4668607f70dd23a491e6f28518152c12a6c0135a25168faaa5588',
        140472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5ae6c7b75eb91a02036e55a62ba36960045017eb7a4a86bff40f5a2a5c2bdef',
        140508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c169bfc741ef1584f02cd1be3d4fa9e64f037dc37d5d5d459d52a23b901a5821',
        140044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8bfd364ffa5f8fdef8354455c5a501838442ae3f9e86a823efa85333397853dc',
        140268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ff9a44e379e73bbe06ae640d28c4d579db0409be00905fba5eace9150a42d9f',
        140340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b11ebfe44014c334b3e915f3374313af308a17feb86e2cb376368d26f5e57093',
        140216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ad3be2acf3aae5b0f81fc0004d6d612f672da1b46bee9894cbfc40fb229d629',
        140380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7d197f2570221d870a00e02087ec5f1f4975c3834a5673c286327da33102d45',
        140236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifKhmer',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Khmer font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Khmer
  static TextTheme notoSerifKhmerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifKhmer(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifKhmer(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifKhmer(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifKhmer(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifKhmer(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifKhmer(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifKhmer(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifKhmer(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifKhmer(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifKhmer(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifKhmer(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifKhmer(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifKhmer(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifKhmer(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifKhmer(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Khojki font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Khojki
  static TextStyle notoSerifKhojki({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7aeb06d9a5385155a48ebc895d9614d8f2020a19f3a1ff1b86b4a2e911932c25',
        139900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '57fc7b5f170f8ad66f4d207fc3471e8f63361833c0a04dbb14a3da74a3d2417f',
        140444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae9508ee1a04afc059b4935faf9638d4b75edf574ed480eee738d09c9ab72130',
        140456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c816d0e158dae02175280e1d4bcb316c4a2b2992f93ac722965d755d3e46bb1',
        140140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifKhojki',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Khojki font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Khojki
  static TextTheme notoSerifKhojkiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifKhojki(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifKhojki(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifKhojki(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifKhojki(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifKhojki(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifKhojki(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifKhojki(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifKhojki(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifKhojki(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifKhojki(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifKhojki(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifKhojki(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifKhojki(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifKhojki(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifKhojki(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Lao font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Lao
  static TextStyle notoSerifLao({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6789ba1b1d0768c2b7d56b944de8fe7ec5903a604e74c4da0ff42ca8ed21bf33',
        61944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fd27742ae4f348a9983bc07542934531170392aadc478b73a5f3ca7c7683e9e',
        62088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd697a1d55e7bf363717b654a4519f3245e0fdc056693d20c7ecf277f5932bf2e',
        62152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17498b041968e1fb9e937ed60005d766e5ffb33c9e3e379fbed1979b89d076df',
        61928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56e254f3de59f330830dc831b22df89fb416309280afbf708c17c8b6310256be',
        62136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f775013ae142757275cc38218c76fd4350307f18280eab146b3140bd5603d43',
        62132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '501ab1c11a9d2d613e1218f29c0e429bbd88e7bf1eaffc9bc521d13c0ca44326',
        62084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '566a5030f6d24bb3c9f5298bf1c4ed3dcbc96d6dd80bd433ff1855df9c55502b',
        62236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6ab9cc4da54cadda924ce56f2e51e386556d26980940c36c06445d7caf897f3',
        62148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifLao',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Lao font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Lao
  static TextTheme notoSerifLaoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifLao(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifLao(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifLao(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifLao(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifLao(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifLao(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifLao(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifLao(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifLao(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifLao(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifLao(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifLao(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifLao(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifLao(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifLao(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Makasar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Makasar
  static TextStyle notoSerifMakasar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4bef6fa2c52f5bbe78962332360c286b8620831fcadfc04864ffb87c244c91e6',
        38632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifMakasar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Makasar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Makasar
  static TextTheme notoSerifMakasarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifMakasar(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifMakasar(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifMakasar(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifMakasar(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifMakasar(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifMakasar(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifMakasar(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifMakasar(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifMakasar(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifMakasar(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifMakasar(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifMakasar(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifMakasar(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifMakasar(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifMakasar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Malayalam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Malayalam
  static TextStyle notoSerifMalayalam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59e507fea491ed3e8a5becfeac7c11bd99f6c0a569efe110b01e7d3cdaa62db6',
        104340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cee2501219fbf6edb0416d09979419cafbc6a0d416986ae740309171d1c4f8d6',
        104392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '525bc34daceccb51763bc13110cc1e51342e682be0056da31f7aea280ae0f8bc',
        104368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45295e776e0ab178ba904b09c0744872c4d86c4c4293776f55ff9f5b83bda26c',
        104300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fcd13251cc29655f5e8e4fd0b241e3dbec7bc69acddf35aa00fb026aac78263d',
        104408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ffd19de47a0bd59cf75c254ab2fcf19fc43ced7de6fe3b13f6f336ec845f1f5',
        104356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e6621e7a87692b3a7155750f6cbe5aa66bffcb924c78c28ed2f7e47c282f899',
        104308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e631b2fb5965a750b347ee6aa75e36b0997c8a18bbcfe0f9401686ac21c4770',
        104500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11bed958dfe172efe4d27f93f6930c459a343fbaed7d4fc95df2391a7b6096ed',
        104456,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifMalayalam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Malayalam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Malayalam
  static TextTheme notoSerifMalayalamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifMalayalam(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifMalayalam(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifMalayalam(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifMalayalam(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifMalayalam(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifMalayalam(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifMalayalam(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifMalayalam(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifMalayalam(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifMalayalam(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifMalayalam(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifMalayalam(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifMalayalam(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifMalayalam(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifMalayalam(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Myanmar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Myanmar
  static TextStyle notoSerifMyanmar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '438218d60c4be2c3a7d215f784fb7cd714e30f5ef18080ed7ab1478cee957c5c',
        185260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e2b5b12588f36092bc455f6e4d546e81faec9d2cca283d27919c666691081a8',
        184624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c91ef89e0f5d2c61287249037d0d20f00ce8856c5cdaa067812a6e4d45d637d4',
        192084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee046657538eeb83e39f8738059ee2580f8daab6fe65c436b304c79c6a2a6d4d',
        190336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a50f892970c9784f79c1f1e002935141b5d31fd2cea06ce0a9980fa3d3fb6f5',
        183092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe3a066a6f537609693b6e1fc626190d0844b9ceda1c43a279ef5e8725ef0dc7',
        183192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d97d67e018337923faa5b9cc681cb22a11a72503757587836a6057cdb7532c4',
        192236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '891c886c13564ec9edbbc0928d135cb4c8ff239a57131b64a2fe18013a56d369',
        184844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f07b66049bf83967df91919bcfa4ed222319ef1d691a07da30536671c4b6b67e',
        185012,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifMyanmar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Myanmar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Myanmar
  static TextTheme notoSerifMyanmarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifMyanmar(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifMyanmar(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifMyanmar(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifMyanmar(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifMyanmar(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifMyanmar(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifMyanmar(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifMyanmar(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifMyanmar(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifMyanmar(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifMyanmar(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifMyanmar(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifMyanmar(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifMyanmar(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifMyanmar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif NP Hmong font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+NP+Hmong
  static TextStyle notoSerifNpHmong({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '18da59c16fe94289fbdbef0ebee360c74d5bd67f79d8e396b5eeb8a08a27c7ac',
        54680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0789992cf2e05be8cdcc1d4ee9d36f51aad16244eaed3c5200148c30e1137965',
        54768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7eb16bf9c7448f5d8efe247bd4baf9b6b037e86353b6ef63777c8e281d882bd6',
        54652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '669e8c057afed7f891f69d91950bc98e34e4ef76e8c08dcdae287543023c3bf4',
        54540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifNPHmong',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif NP Hmong font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+NP+Hmong
  static TextTheme notoSerifNpHmongTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifNpHmong(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifNpHmong(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifNpHmong(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifNpHmong(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifNpHmong(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifNpHmong(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifNpHmong(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifNpHmong(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifNpHmong(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifNpHmong(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifNpHmong(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifNpHmong(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifNpHmong(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifNpHmong(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifNpHmong(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Old Uyghur font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Old+Uyghur
  static TextStyle notoSerifOldUyghur({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f8a8de5397afbe4c14991511f64447bc8dd744ae7bd37ed2cfe3b883450957e',
        53140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifOldUyghur',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Old Uyghur font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Old+Uyghur
  static TextTheme notoSerifOldUyghurTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifOldUyghur(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifOldUyghur(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifOldUyghur(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifOldUyghur(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifOldUyghur(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifOldUyghur(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifOldUyghur(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifOldUyghur(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifOldUyghur(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifOldUyghur(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifOldUyghur(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifOldUyghur(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifOldUyghur(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifOldUyghur(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifOldUyghur(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Oriya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Oriya
  static TextStyle notoSerifOriya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21b19ba18bd073f91e40ca2b212021029e4c015621a09f00b5e33c88ba63f596',
        146656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5b2c3afaea47c4cb633631fac33ad6b9506f5407f6b871d198cde8c3dd3a7d64',
        146968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '320e37aa13de5fa441eb0b38b11a7992092803cea7301f68db89918bb401cc2e',
        146976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f988b3ee234a13e0449ae53838c315979e44e029b63d18738eeb83de7339dd6b',
        146420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifOriya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Oriya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Oriya
  static TextTheme notoSerifOriyaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifOriya(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifOriya(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifOriya(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifOriya(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifOriya(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifOriya(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifOriya(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifOriya(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifOriya(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifOriya(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifOriya(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifOriya(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifOriya(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifOriya(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifOriya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Ottoman Siyaq font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Ottoman+Siyaq
  static TextStyle notoSerifOttomanSiyaq({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5344aa82a28aed829cc879c518f6b5db136814db846c45067469a1dd61e1945',
        55152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifOttomanSiyaq',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Ottoman Siyaq font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Ottoman+Siyaq
  static TextTheme notoSerifOttomanSiyaqTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifOttomanSiyaq(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifOttomanSiyaq(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifOttomanSiyaq(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifOttomanSiyaq(textStyle: textTheme.headlineLarge),
      headlineMedium:
          notoSerifOttomanSiyaq(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifOttomanSiyaq(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifOttomanSiyaq(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifOttomanSiyaq(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifOttomanSiyaq(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifOttomanSiyaq(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifOttomanSiyaq(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifOttomanSiyaq(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifOttomanSiyaq(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifOttomanSiyaq(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifOttomanSiyaq(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Sinhala font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Sinhala
  static TextStyle notoSerifSinhala({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a4ae388a874758f08e60ca58491a862c7fb817de7ce2d7b97121c19a43764c2',
        242772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0652c00c00aa3ed098f36fff9f02ed9ea8106cec81994000952a19aee890900f',
        242876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8dae3a378a162202f3964ab7a18bc6d69adfab46a22579844df335402dd96f5',
        242988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '674d7e0bca32ac37ce3c49d6c34eb979322485e567dfed41d3069780ae379d8f',
        242724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3a8359dbfc035647427440cbd8ad3046030973702d55d9bc9db18d96f57b26f',
        242820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3f3cefea2e0f349cb256f166017736ffd0b3912067b23e9a375cb45c14949f3',
        242828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c60b00bfcc07796d641021c7f1e3bbc524cb32401b9c970c31c4a8876096d12',
        242796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe89e37d9042da476cba2f499d35675fe2fed4745c5181f1f4f2747cf76b768f',
        242840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f04dabb03ce55622a1c424b5007ed696a7006dc298b32db85df88192b430e10',
        242816,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifSinhala',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Sinhala font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Sinhala
  static TextTheme notoSerifSinhalaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifSinhala(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifSinhala(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifSinhala(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifSinhala(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifSinhala(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifSinhala(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifSinhala(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifSinhala(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifSinhala(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifSinhala(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifSinhala(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifSinhala(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifSinhala(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifSinhala(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifSinhala(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Tamil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Tamil
  static TextStyle notoSerifTamil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac65de4bb44c36c15437541a3fd05c9456f48fac3487596e0d229fa576092abb',
        88616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe8092c824be5f5bcbd9c50cbbd521372ee45254671b4911f555dbb542aa6d68',
        88804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a727ca106555dd9cd00ee5469dd5372d2682b3ba1b633f8ab053b3f2dc1fa8c0',
        88724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74efd725b5e611028bb513062d35dcd6c6fd4251df5b9464f690719c4695a6c4',
        88548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dbb81c82b15ab98e827e5c14e2b48f2aea66937f28bafb7150218888983a103e',
        88712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4de0813ad43f3ede1f85221e031177c0d6194246768d1b04206eb71e2af6dac',
        88668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '947c3da3448338c172f8dbc9ca072a46fa907409f002650afedb4b3e3f8ddb6f',
        88524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0376fa8cd913dbd82b832caca64ba23218413145f52da5c9c35bc55cf95cf964',
        88944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c018ff7c8f62a9e7ad8bf201704a0fdce75e1c9c0a8496f98b3007488f66d9c7',
        88896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '549dc166392a7bd4a7ad31ef472fdbe92e7bde5f4ffcf82e3a86b9e6caec0973',
        88860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'beff57eef91baa936ca0d59b2c7ad9bf0f2f54c5e805c58eab713e335f98c7ad',
        89068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6b071444dddf209a1452ed8188549aaad5080ca2ca7aa67e35a4b667c990ab83',
        88996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dafe2b3586f4389eb0445ab2ff59db5feb811d1a2fff46ac11329ef07c059fc1',
        88816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cd6e31bfcc320f2fd3802a9f4d0ebda031e7025f78623a56b6cc718a1fba23a5',
        89052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7e7510b4229b3d648bc8ca173a1dcdcc43d9c014ffc4b4ca09571fc0a465397e',
        88964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2f63eb24815c6d4ea8c00c2d2e507d3bf6f18a40147ae9da43d4feac5388b6ed',
        88796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4930522a8bde336647b8f552c3f65c0e1b57e6eac4765f71ea113911510c46c1',
        89228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6406a9ce1d41120a9324a32359e4760f7869e594fe519fb47179f8e992e534f3',
        89204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifTamil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Tamil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Tamil
  static TextTheme notoSerifTamilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifTamil(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifTamil(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifTamil(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifTamil(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifTamil(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifTamil(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifTamil(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifTamil(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifTamil(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifTamil(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifTamil(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifTamil(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifTamil(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifTamil(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifTamil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Tangut font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Tangut
  static TextStyle notoSerifTangut({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed23adac92c60c3bd2f7d6130b9dfaa27449bc94ef96a5a679f39ef0dc3f3783',
        3120360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifTangut',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Tangut font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Tangut
  static TextTheme notoSerifTangutTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifTangut(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifTangut(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifTangut(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifTangut(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifTangut(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifTangut(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifTangut(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifTangut(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifTangut(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifTangut(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifTangut(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifTangut(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifTangut(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifTangut(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifTangut(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Telugu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Telugu
  static TextStyle notoSerifTelugu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c728adcdad9ea7e3cbc82981cbf916577b0849e397847663f148fd79dae54029',
        240768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e78008b7966680795923f4d39c5c79cb41b92fcc850a7875d28bf8bd0e2d040b',
        241784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd98e61fefd44161c124e76a06ab5bbb9c7ba921d3a70512356cde443aa622c40',
        242092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59a10cc1fb3cc2d32980f88d523163e20c3d66db56feac9bc70e01e50d0c9e65',
        241876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee5df6c13d6095767f4764c014378289629ec33124b0f9f794685865a96096c1',
        242188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '89c494f3bfedecdab8d93be45fd9eb8de7d315a01a1cb684d0fd8d7c7e1ec67d',
        242308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ab6ac480561f0a5879ae5cff319870ebef50677de907f56342d8e26b3565624',
        242136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52d4517e732c92dd6a9f9b6851c0a8017b6e666bffbecd481beff5f83abb3dad',
        242412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '541b9fe91fe28fcf6140953579cd0d4176de5f24143e308ba32a2afa8ce640b8',
        242372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifTelugu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Telugu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Telugu
  static TextTheme notoSerifTeluguTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifTelugu(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifTelugu(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifTelugu(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifTelugu(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifTelugu(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifTelugu(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifTelugu(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifTelugu(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifTelugu(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifTelugu(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifTelugu(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifTelugu(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifTelugu(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifTelugu(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifTelugu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Thai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Thai
  static TextStyle notoSerifThai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5eb35c0094128d7d01680b8843b2da94cc9dc4da0367bd73d9067287b48cc074',
        59812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48d9621d9f86d32d042924a1dca011561a6e12bb6577ecf77737d966721c6f96',
        59968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7e9e8ab36992509761cfbb52a8ccc910571ef167bd2cf9a15b7e393185aeadf',
        59908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b677be028abaef2960675aa839310cf8b76eb02dd776b005e535ce8fd7b0dba',
        59668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '269e49f943f4d5e3caebf7d381eca11ec24a3179713e9fc9594664d29f00638b',
        59904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2f95d912f539a2afb1a4fcaff25b3cfec88ff80bab99abc18e7e2b8a2ed0371',
        59844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26cc8f7b7d541cc050522a077448d3069e480d35edbd314748ab819fbce36b12',
        59760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7bcf386351f299d1a0440e23d14334dd32fcc736451a25721557bb13bf7ee9d',
        60072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3700c400ed31b5a182e21b6269e583e7dff8b8e16400504a9979684488574efa',
        60004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifThai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Thai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Thai
  static TextTheme notoSerifThaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifThai(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifThai(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifThai(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifThai(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifThai(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifThai(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifThai(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifThai(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifThai(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifThai(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifThai(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifThai(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifThai(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifThai(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifThai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Tibetan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Tibetan
  static TextStyle notoSerifTibetan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b07b780e8ef4aac1e95ce9b81c6f4a3a65de187a414e8e59f778e3e46a23c4d',
        734832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8e953604db9e998a856456ff79f72240c65b6d52353e7faf2b3e1d9d2add63e0',
        736368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2f1e792140623b81f3b6300e2d60707352410f1e2de028748ccdfa9d19e4a97',
        736160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0a225febb24e86ee92e6fd7feef5b988bb6c638c130ba2182e99bc5d257e458',
        735232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '585ec81f6afbf23713d97535a16034f192341fede2fd6c62f3c6deb05e8d4520',
        737600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '535e3d4433260d584e92f3a8d9aefca6541c2a854863a5ecbbd19e3c9d7e3851',
        738032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f465fe203f9cb4c59b283ceca569aadd8e433470abf7fa7af131530a2d0ff09',
        737824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '261b379dc61a4f2c44b05f3a32161191b2e73debf320cff4c4f35f7311687a17',
        739352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80f8e9f929a490a7cb48ad01f04f98717e4b2975815b62a227ce53209e0e92a0',
        738928,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifTibetan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Tibetan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Tibetan
  static TextTheme notoSerifTibetanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifTibetan(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifTibetan(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifTibetan(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifTibetan(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifTibetan(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifTibetan(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifTibetan(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifTibetan(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifTibetan(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifTibetan(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifTibetan(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifTibetan(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifTibetan(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifTibetan(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifTibetan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Toto font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Toto
  static TextStyle notoSerifToto({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05c71db1d934e6135181c69605976909c84faba061a81f2fa14d0e152a4c724f',
        43232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7dcc3510796b20cf7eb5b2e9a67785b8506f9b5bcb113ff7d938ad522b849df6',
        43336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7359614d75c2c8098704cba73bb0388ea1b35ddc40f31fa250327d83831fc58c',
        43248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba7d8516241ccbbbc04279e0df461f8948bfafd909a68703b2bdd36ec17fc47b',
        43156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifToto',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Toto font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Toto
  static TextTheme notoSerifTotoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifToto(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifToto(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifToto(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifToto(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifToto(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifToto(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifToto(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifToto(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifToto(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifToto(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifToto(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifToto(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifToto(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifToto(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifToto(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Vithkuqi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Vithkuqi
  static TextStyle notoSerifVithkuqi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85fc9090f6583fc8ac3a3f6d015174af2f0a49e46661eafb55678ea8ae259075',
        53500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62bffa84ae1144b2cb358715bc86da19768a4a643b1182dc32a0f360a9bc9f81',
        53620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b5aa13d24600810ca5b87d0b6e58fd74d31994e403e9667020da2503df50141',
        53552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87c5e76663ddee8eb51bb02bcf86ceb7bf013c1684f201746ce698c4557f26f2',
        53432,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifVithkuqi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Vithkuqi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Vithkuqi
  static TextTheme notoSerifVithkuqiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifVithkuqi(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifVithkuqi(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifVithkuqi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifVithkuqi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifVithkuqi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifVithkuqi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifVithkuqi(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifVithkuqi(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifVithkuqi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifVithkuqi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifVithkuqi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifVithkuqi(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifVithkuqi(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifVithkuqi(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifVithkuqi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Serif Yezidi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Yezidi
  static TextStyle notoSerifYezidi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cb638b074ae8ad83aca5e479e264a2c8573ec337d9d96683a9d5343b1e3261a',
        47716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3fd0fb941820e9c8b1d8655009ef417c07bcafad4eb526ebfed775d793b5b2d',
        47820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f15561ac3b91eae2cc5bef5c01f0c462c2bac305301ec726ea58b97b44ea41d',
        47744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba9cb35c4438c08056b17de01b4ade99c57264f97dc5c31deeee337df93e7376',
        47632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoSerifYezidi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Serif Yezidi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Serif+Yezidi
  static TextTheme notoSerifYezidiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoSerifYezidi(textStyle: textTheme.displayLarge),
      displayMedium: notoSerifYezidi(textStyle: textTheme.displayMedium),
      displaySmall: notoSerifYezidi(textStyle: textTheme.displaySmall),
      headlineLarge: notoSerifYezidi(textStyle: textTheme.headlineLarge),
      headlineMedium: notoSerifYezidi(textStyle: textTheme.headlineMedium),
      headlineSmall: notoSerifYezidi(textStyle: textTheme.headlineSmall),
      titleLarge: notoSerifYezidi(textStyle: textTheme.titleLarge),
      titleMedium: notoSerifYezidi(textStyle: textTheme.titleMedium),
      titleSmall: notoSerifYezidi(textStyle: textTheme.titleSmall),
      bodyLarge: notoSerifYezidi(textStyle: textTheme.bodyLarge),
      bodyMedium: notoSerifYezidi(textStyle: textTheme.bodyMedium),
      bodySmall: notoSerifYezidi(textStyle: textTheme.bodySmall),
      labelLarge: notoSerifYezidi(textStyle: textTheme.labelLarge),
      labelMedium: notoSerifYezidi(textStyle: textTheme.labelMedium),
      labelSmall: notoSerifYezidi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Noto Traditional Nushu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Traditional+Nushu
  static TextStyle notoTraditionalNushu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '256b891d392d777f12474f2e6df4c5b4558d59aeab0d3028c791f51f353aad99',
        136668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da1f6df74e4fb672e515142655da2071e641ce8e0fe3e5605f025c13e34c2b91',
        136620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bef080439a839089d6852878bb98ff15635a04b3deacca9fb1f94433aa332c5',
        136908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf1dbc86945162a664b81b808b73988e7872929c0041b3d83931b1a3039cb0a5',
        136948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6586b0e664c8f16a9da9955a3893a2c3f8faae6fa1eaffa9f2b73ebd84ec0fe',
        136996,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NotoTraditionalNushu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Noto Traditional Nushu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Noto+Traditional+Nushu
  static TextTheme notoTraditionalNushuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: notoTraditionalNushu(textStyle: textTheme.displayLarge),
      displayMedium: notoTraditionalNushu(textStyle: textTheme.displayMedium),
      displaySmall: notoTraditionalNushu(textStyle: textTheme.displaySmall),
      headlineLarge: notoTraditionalNushu(textStyle: textTheme.headlineLarge),
      headlineMedium: notoTraditionalNushu(textStyle: textTheme.headlineMedium),
      headlineSmall: notoTraditionalNushu(textStyle: textTheme.headlineSmall),
      titleLarge: notoTraditionalNushu(textStyle: textTheme.titleLarge),
      titleMedium: notoTraditionalNushu(textStyle: textTheme.titleMedium),
      titleSmall: notoTraditionalNushu(textStyle: textTheme.titleSmall),
      bodyLarge: notoTraditionalNushu(textStyle: textTheme.bodyLarge),
      bodyMedium: notoTraditionalNushu(textStyle: textTheme.bodyMedium),
      bodySmall: notoTraditionalNushu(textStyle: textTheme.bodySmall),
      labelLarge: notoTraditionalNushu(textStyle: textTheme.labelLarge),
      labelMedium: notoTraditionalNushu(textStyle: textTheme.labelMedium),
      labelSmall: notoTraditionalNushu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nova Cut font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Cut
  static TextStyle novaCut({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c46a956de0d26486e7af31eeaa101b5a4f655c34ae4eea3df1ca508f23067d1',
        50548,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NovaCut',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nova Cut font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Cut
  static TextTheme novaCutTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: novaCut(textStyle: textTheme.displayLarge),
      displayMedium: novaCut(textStyle: textTheme.displayMedium),
      displaySmall: novaCut(textStyle: textTheme.displaySmall),
      headlineLarge: novaCut(textStyle: textTheme.headlineLarge),
      headlineMedium: novaCut(textStyle: textTheme.headlineMedium),
      headlineSmall: novaCut(textStyle: textTheme.headlineSmall),
      titleLarge: novaCut(textStyle: textTheme.titleLarge),
      titleMedium: novaCut(textStyle: textTheme.titleMedium),
      titleSmall: novaCut(textStyle: textTheme.titleSmall),
      bodyLarge: novaCut(textStyle: textTheme.bodyLarge),
      bodyMedium: novaCut(textStyle: textTheme.bodyMedium),
      bodySmall: novaCut(textStyle: textTheme.bodySmall),
      labelLarge: novaCut(textStyle: textTheme.labelLarge),
      labelMedium: novaCut(textStyle: textTheme.labelMedium),
      labelSmall: novaCut(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nova Flat font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Flat
  static TextStyle novaFlat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5b33bd6915530aeb47f09774df48ac44bad12780f541ed15757afba9229168c7',
        51672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NovaFlat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nova Flat font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Flat
  static TextTheme novaFlatTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: novaFlat(textStyle: textTheme.displayLarge),
      displayMedium: novaFlat(textStyle: textTheme.displayMedium),
      displaySmall: novaFlat(textStyle: textTheme.displaySmall),
      headlineLarge: novaFlat(textStyle: textTheme.headlineLarge),
      headlineMedium: novaFlat(textStyle: textTheme.headlineMedium),
      headlineSmall: novaFlat(textStyle: textTheme.headlineSmall),
      titleLarge: novaFlat(textStyle: textTheme.titleLarge),
      titleMedium: novaFlat(textStyle: textTheme.titleMedium),
      titleSmall: novaFlat(textStyle: textTheme.titleSmall),
      bodyLarge: novaFlat(textStyle: textTheme.bodyLarge),
      bodyMedium: novaFlat(textStyle: textTheme.bodyMedium),
      bodySmall: novaFlat(textStyle: textTheme.bodySmall),
      labelLarge: novaFlat(textStyle: textTheme.labelLarge),
      labelMedium: novaFlat(textStyle: textTheme.labelMedium),
      labelSmall: novaFlat(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nova Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Mono
  static TextStyle novaMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1cef6f9dace4114875a71406ef44b771ecc4407479c473af326d93764a6c55c3',
        152484,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NovaMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nova Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Mono
  static TextTheme novaMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: novaMono(textStyle: textTheme.displayLarge),
      displayMedium: novaMono(textStyle: textTheme.displayMedium),
      displaySmall: novaMono(textStyle: textTheme.displaySmall),
      headlineLarge: novaMono(textStyle: textTheme.headlineLarge),
      headlineMedium: novaMono(textStyle: textTheme.headlineMedium),
      headlineSmall: novaMono(textStyle: textTheme.headlineSmall),
      titleLarge: novaMono(textStyle: textTheme.titleLarge),
      titleMedium: novaMono(textStyle: textTheme.titleMedium),
      titleSmall: novaMono(textStyle: textTheme.titleSmall),
      bodyLarge: novaMono(textStyle: textTheme.bodyLarge),
      bodyMedium: novaMono(textStyle: textTheme.bodyMedium),
      bodySmall: novaMono(textStyle: textTheme.bodySmall),
      labelLarge: novaMono(textStyle: textTheme.labelLarge),
      labelMedium: novaMono(textStyle: textTheme.labelMedium),
      labelSmall: novaMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nova Oval font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Oval
  static TextStyle novaOval({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '915b1b00d17791228c7f4d6678d44ff2c3357d6dceba4409c710e37c6d3d0172',
        54196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NovaOval',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nova Oval font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Oval
  static TextTheme novaOvalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: novaOval(textStyle: textTheme.displayLarge),
      displayMedium: novaOval(textStyle: textTheme.displayMedium),
      displaySmall: novaOval(textStyle: textTheme.displaySmall),
      headlineLarge: novaOval(textStyle: textTheme.headlineLarge),
      headlineMedium: novaOval(textStyle: textTheme.headlineMedium),
      headlineSmall: novaOval(textStyle: textTheme.headlineSmall),
      titleLarge: novaOval(textStyle: textTheme.titleLarge),
      titleMedium: novaOval(textStyle: textTheme.titleMedium),
      titleSmall: novaOval(textStyle: textTheme.titleSmall),
      bodyLarge: novaOval(textStyle: textTheme.bodyLarge),
      bodyMedium: novaOval(textStyle: textTheme.bodyMedium),
      bodySmall: novaOval(textStyle: textTheme.bodySmall),
      labelLarge: novaOval(textStyle: textTheme.labelLarge),
      labelMedium: novaOval(textStyle: textTheme.labelMedium),
      labelSmall: novaOval(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nova Round font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Round
  static TextStyle novaRound({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c636608b49ecb130609aeae53e7e3ad903a39ab8b7b367253f3b2b9799c3677',
        51408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NovaRound',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nova Round font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Round
  static TextTheme novaRoundTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: novaRound(textStyle: textTheme.displayLarge),
      displayMedium: novaRound(textStyle: textTheme.displayMedium),
      displaySmall: novaRound(textStyle: textTheme.displaySmall),
      headlineLarge: novaRound(textStyle: textTheme.headlineLarge),
      headlineMedium: novaRound(textStyle: textTheme.headlineMedium),
      headlineSmall: novaRound(textStyle: textTheme.headlineSmall),
      titleLarge: novaRound(textStyle: textTheme.titleLarge),
      titleMedium: novaRound(textStyle: textTheme.titleMedium),
      titleSmall: novaRound(textStyle: textTheme.titleSmall),
      bodyLarge: novaRound(textStyle: textTheme.bodyLarge),
      bodyMedium: novaRound(textStyle: textTheme.bodyMedium),
      bodySmall: novaRound(textStyle: textTheme.bodySmall),
      labelLarge: novaRound(textStyle: textTheme.labelLarge),
      labelMedium: novaRound(textStyle: textTheme.labelMedium),
      labelSmall: novaRound(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nova Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Script
  static TextStyle novaScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8636ed31dd547b704d0607522db713452bf9e16b031a6f140632c56e1ba6d578',
        64716,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NovaScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nova Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Script
  static TextTheme novaScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: novaScript(textStyle: textTheme.displayLarge),
      displayMedium: novaScript(textStyle: textTheme.displayMedium),
      displaySmall: novaScript(textStyle: textTheme.displaySmall),
      headlineLarge: novaScript(textStyle: textTheme.headlineLarge),
      headlineMedium: novaScript(textStyle: textTheme.headlineMedium),
      headlineSmall: novaScript(textStyle: textTheme.headlineSmall),
      titleLarge: novaScript(textStyle: textTheme.titleLarge),
      titleMedium: novaScript(textStyle: textTheme.titleMedium),
      titleSmall: novaScript(textStyle: textTheme.titleSmall),
      bodyLarge: novaScript(textStyle: textTheme.bodyLarge),
      bodyMedium: novaScript(textStyle: textTheme.bodyMedium),
      bodySmall: novaScript(textStyle: textTheme.bodySmall),
      labelLarge: novaScript(textStyle: textTheme.labelLarge),
      labelMedium: novaScript(textStyle: textTheme.labelMedium),
      labelSmall: novaScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nova Slim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Slim
  static TextStyle novaSlim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a621948157ef912403e535debfc9f5fdabefd7cdd608f386145fb10a7f67749',
        51448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NovaSlim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nova Slim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Slim
  static TextTheme novaSlimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: novaSlim(textStyle: textTheme.displayLarge),
      displayMedium: novaSlim(textStyle: textTheme.displayMedium),
      displaySmall: novaSlim(textStyle: textTheme.displaySmall),
      headlineLarge: novaSlim(textStyle: textTheme.headlineLarge),
      headlineMedium: novaSlim(textStyle: textTheme.headlineMedium),
      headlineSmall: novaSlim(textStyle: textTheme.headlineSmall),
      titleLarge: novaSlim(textStyle: textTheme.titleLarge),
      titleMedium: novaSlim(textStyle: textTheme.titleMedium),
      titleSmall: novaSlim(textStyle: textTheme.titleSmall),
      bodyLarge: novaSlim(textStyle: textTheme.bodyLarge),
      bodyMedium: novaSlim(textStyle: textTheme.bodyMedium),
      bodySmall: novaSlim(textStyle: textTheme.bodySmall),
      labelLarge: novaSlim(textStyle: textTheme.labelLarge),
      labelMedium: novaSlim(textStyle: textTheme.labelMedium),
      labelSmall: novaSlim(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nova Square font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Square
  static TextStyle novaSquare({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b13b4b4b397a598b606650b2bac246840ef1adf11cead697a55aad6fbea9745',
        46800,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NovaSquare',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nova Square font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nova+Square
  static TextTheme novaSquareTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: novaSquare(textStyle: textTheme.displayLarge),
      displayMedium: novaSquare(textStyle: textTheme.displayMedium),
      displaySmall: novaSquare(textStyle: textTheme.displaySmall),
      headlineLarge: novaSquare(textStyle: textTheme.headlineLarge),
      headlineMedium: novaSquare(textStyle: textTheme.headlineMedium),
      headlineSmall: novaSquare(textStyle: textTheme.headlineSmall),
      titleLarge: novaSquare(textStyle: textTheme.titleLarge),
      titleMedium: novaSquare(textStyle: textTheme.titleMedium),
      titleSmall: novaSquare(textStyle: textTheme.titleSmall),
      bodyLarge: novaSquare(textStyle: textTheme.bodyLarge),
      bodyMedium: novaSquare(textStyle: textTheme.bodyMedium),
      bodySmall: novaSquare(textStyle: textTheme.bodySmall),
      labelLarge: novaSquare(textStyle: textTheme.labelLarge),
      labelMedium: novaSquare(textStyle: textTheme.labelMedium),
      labelSmall: novaSquare(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Numans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Numans
  static TextStyle numans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76e8c6d6849d0932e39ea64ccefff66a0af4efbc39d45cddcb7a009aae32fb25',
        35960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Numans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Numans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Numans
  static TextTheme numansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: numans(textStyle: textTheme.displayLarge),
      displayMedium: numans(textStyle: textTheme.displayMedium),
      displaySmall: numans(textStyle: textTheme.displaySmall),
      headlineLarge: numans(textStyle: textTheme.headlineLarge),
      headlineMedium: numans(textStyle: textTheme.headlineMedium),
      headlineSmall: numans(textStyle: textTheme.headlineSmall),
      titleLarge: numans(textStyle: textTheme.titleLarge),
      titleMedium: numans(textStyle: textTheme.titleMedium),
      titleSmall: numans(textStyle: textTheme.titleSmall),
      bodyLarge: numans(textStyle: textTheme.bodyLarge),
      bodyMedium: numans(textStyle: textTheme.bodyMedium),
      bodySmall: numans(textStyle: textTheme.bodySmall),
      labelLarge: numans(textStyle: textTheme.labelLarge),
      labelMedium: numans(textStyle: textTheme.labelMedium),
      labelSmall: numans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nunito font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nunito
  static TextStyle nunito({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06ea05ce6bbb031a0e5372ddeb2957d1afa96244550a5a392c1f7c8107a0f4a4',
        125388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d32053d727702a77e28b4104b53fb30333f146ef22ed73ebae6a509f94d885c',
        125540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f96017e762896b4cf3c2db345d41d7a72a3720a95698c3cd47020bf433db435',
        125504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f6452d3509db129d3468088c1c952f1a844b6dc865703a09595fc53700a6251',
        125628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f165190d31319dc6384c83fdd014ed983630541b21d005b5caadf1d74fbd513d',
        125512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8148a236e4127dad38346ce596c544389aa2fdaaa9f311e589741de30d25ddb8',
        125440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43364ac2d05d1033b5e255ce77e4d84d2f6467bfadb5e5985ca4e688949e73bf',
        125392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a5ddd59da28c281984ae3bd12aa3b9af3b204e61156e50f1108d5fcf71aa5665',
        125352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '00fe8a871f3548a3d11273596486ff1c30328c3e6853d2f43f0e72c75802b24a',
        128248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd49777748d078c1787b1f8e9d14317a0cf4510039c86ebee7b74a037d4758b00',
        128508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'df3c491d67e881e1b0c6265a7a8364f07e38d7a25893e9b2beac1439e1c2efd9',
        128376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '56984ce135b93b61a7e1176b810c8afbaafbcdce625fca628b73dc16139f7a7a',
        128440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a5337453969dd598f31a7bfd0bb8c66aece01b0f7d5bffa9f2d1d2eb020ae9f9',
        128304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d9670625be9c432a93d3467f99c5aa3e5626181c27d6d9a27285781539dfd83',
        128244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '170f35fc695e39b13b53b58452f1a9e334277f3633c4ab89346db743b6b4923f',
        128280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3fff73610e77b1bca1edd861e4830865d147de46cffc685fb253cb050b1148a5',
        128188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Nunito',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nunito font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nunito
  static TextTheme nunitoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nunito(textStyle: textTheme.displayLarge),
      displayMedium: nunito(textStyle: textTheme.displayMedium),
      displaySmall: nunito(textStyle: textTheme.displaySmall),
      headlineLarge: nunito(textStyle: textTheme.headlineLarge),
      headlineMedium: nunito(textStyle: textTheme.headlineMedium),
      headlineSmall: nunito(textStyle: textTheme.headlineSmall),
      titleLarge: nunito(textStyle: textTheme.titleLarge),
      titleMedium: nunito(textStyle: textTheme.titleMedium),
      titleSmall: nunito(textStyle: textTheme.titleSmall),
      bodyLarge: nunito(textStyle: textTheme.bodyLarge),
      bodyMedium: nunito(textStyle: textTheme.bodyMedium),
      bodySmall: nunito(textStyle: textTheme.bodySmall),
      labelLarge: nunito(textStyle: textTheme.labelLarge),
      labelMedium: nunito(textStyle: textTheme.labelMedium),
      labelSmall: nunito(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nunito Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nunito+Sans
  static TextStyle nunitoSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a5c5ada6ef95cf1c13032cdd482d1b5b9117898ed48e6e6251cc409409bfb531',
        106596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec5dcab16249c6f62ad7636785d7efa6eab623110bcc9692a35b23c0dee43e99',
        106732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1563a052d1d6552b3b802f10aa4efb3208d7fc91c701b61dbe1edb0548c1c1fa',
        106736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f794d51704fe75cd5d5fd0d3c8d96d719f5fd2326479b865c6124f0e13bee17',
        106812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94bbbb4ad81df4d26a044fcd34bd878ec319798c7f45882f83e19bc6e2ec5228',
        106844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24cd7544420c66af7de45de56c6d14cbc4bf01c7aaf352666a4669a64acbfc44',
        106828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4a6a8295fe3163bf8c5fcbed4dbf83ad774d4996abd0d73a4c72539ba3ea519',
        106816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f0464ef61461f7f4a40cde4f3f8c89d3050330519ef1fb01eeb3fd14246ee73',
        106796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c540eb7e51462250810adf1f09ce677351d1e39169c8aa94f0d2c8fe1c0551ac',
        109488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1e2356039d88c4ba18ca602db9ff1fd2a00b323ef531c1afb21d3e5017698382',
        109672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'efc6750348e451c17a6e0dddba2c07225332e740d43a24c5a5f70089edf5b2f5',
        109552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '92babb02554f640b034d27a53897148dbb320f06046f49d0149ba0a3c9d7a539',
        109612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6cf4c21fcc300343602fa4d216e6af94ab694e4bec30d20fb77384fc1dd9c99d',
        109592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8fdc285e940a7fc7092160ea88aa30866ad5e706f2220dc38728dedb577ece25',
        109548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b073774dac831c613f9c44e1bd159729f0bd3576336b49b60703f1ce48c883a',
        109640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45a78e8d6e5faad0529a856e832f8baaf7fb3a51d5190485926197c41ba2c31c',
        109572,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NunitoSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nunito Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nunito+Sans
  static TextTheme nunitoSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nunitoSans(textStyle: textTheme.displayLarge),
      displayMedium: nunitoSans(textStyle: textTheme.displayMedium),
      displaySmall: nunitoSans(textStyle: textTheme.displaySmall),
      headlineLarge: nunitoSans(textStyle: textTheme.headlineLarge),
      headlineMedium: nunitoSans(textStyle: textTheme.headlineMedium),
      headlineSmall: nunitoSans(textStyle: textTheme.headlineSmall),
      titleLarge: nunitoSans(textStyle: textTheme.titleLarge),
      titleMedium: nunitoSans(textStyle: textTheme.titleMedium),
      titleSmall: nunitoSans(textStyle: textTheme.titleSmall),
      bodyLarge: nunitoSans(textStyle: textTheme.bodyLarge),
      bodyMedium: nunitoSans(textStyle: textTheme.bodyMedium),
      bodySmall: nunitoSans(textStyle: textTheme.bodySmall),
      labelLarge: nunitoSans(textStyle: textTheme.labelLarge),
      labelMedium: nunitoSans(textStyle: textTheme.labelMedium),
      labelSmall: nunitoSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Nuosu SIL font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nuosu+SIL
  static TextStyle nuosuSil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd39083907e767636d1865fa86c51a5a1982eeba7c27ef175747c31a2df89aef',
        249960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'NuosuSIL',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Nuosu SIL font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Nuosu+SIL
  static TextTheme nuosuSilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: nuosuSil(textStyle: textTheme.displayLarge),
      displayMedium: nuosuSil(textStyle: textTheme.displayMedium),
      displaySmall: nuosuSil(textStyle: textTheme.displaySmall),
      headlineLarge: nuosuSil(textStyle: textTheme.headlineLarge),
      headlineMedium: nuosuSil(textStyle: textTheme.headlineMedium),
      headlineSmall: nuosuSil(textStyle: textTheme.headlineSmall),
      titleLarge: nuosuSil(textStyle: textTheme.titleLarge),
      titleMedium: nuosuSil(textStyle: textTheme.titleMedium),
      titleSmall: nuosuSil(textStyle: textTheme.titleSmall),
      bodyLarge: nuosuSil(textStyle: textTheme.bodyLarge),
      bodyMedium: nuosuSil(textStyle: textTheme.bodyMedium),
      bodySmall: nuosuSil(textStyle: textTheme.bodySmall),
      labelLarge: nuosuSil(textStyle: textTheme.labelLarge),
      labelMedium: nuosuSil(textStyle: textTheme.labelMedium),
      labelSmall: nuosuSil(textStyle: textTheme.labelSmall),
    );
  }
}
