#!/bin/bash
set -eu

cd "$(dirname "$(readlink $0)")"

DATA_DIR=data
LOCALES_INDEX="$PWD/lib/locales.dart"
NATIVE_LOCALES_INDEX="$PWD/lib/native_locale_names.dart"

FETCH_JSON=False

### Fetch .json files
if $FETCH_JSON; then
  echo "Fetching JSON"
  [[ ! -d "$DATA_DIR" ]] || rm -R "$DATA_DIR"
  curl -L https://github.com/umpirsky/locale-list/archive/master.tar.gz | tar -xf - '*/locales.json'
  find locale-list-master/data -name 'locales.json' -exec bash -c 'mv $1 $(echo $1 | sed -e "s/\/locales\.json/\.json/g")' -- {} \;
  ls -A -d locale-list-master/data/*/ | xargs rmdir
  mv locale-list-master/data "$DATA_DIR"
  rmdir locale-list-master
fi

cd "$DATA_DIR"

### Generate locales index
echo "// Generated by tool/build.sh" > "$LOCALES_INDEX"
find . -name '*.json' | sed -E "s/\.\///;s/\.json//" | jq -nRc '[inputs | select(length>0)] | sort' | sed 's/^/const all_locales = /' | sed 's/$/;/' >> "$LOCALES_INDEX"

### Generate native locale names index
echo "// Generated by tool/build.sh" > "$NATIVE_LOCALES_INDEX"
echo "const all_native_names = {" >> "$NATIVE_LOCALES_INDEX"
for f in $(find . -name '*.json' | sort); do
  file="$(basename "$f")"
  locale="${file%%.*}"
  jq --arg keyvar "$locale" '.[$keyvar]' "$f" | sed "s/^/  \"$locale\": /" | sed "s/$/,/">> "$NATIVE_LOCALES_INDEX"
done
echo "};" >> "$NATIVE_LOCALES_INDEX"