// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v25.5.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, unnecessary_import, no_leading_underscores_for_local_identifiers
// ignore_for_file: avoid_relative_lib_imports
import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;
import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';

import 'package:path_provider_foundation/messages.g.dart';

class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    } else if (value is DirectoryType) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : DirectoryType.values[value];
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

abstract class TestPathProviderApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  String? getDirectoryPath(DirectoryType type);

  String? getContainerPath(String appGroupIdentifier);

  static void setUp(
    TestPathProviderApi? api, {
    BinaryMessenger? binaryMessenger,
    String messageChannelSuffix = '',
  }) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty
        ? '.$messageChannelSuffix'
        : '';
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.path_provider_foundation.PathProviderApi.getDirectoryPath$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(pigeonVar_channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(pigeonVar_channel, (
              Object? message,
            ) async {
              assert(
                message != null,
                'Argument for dev.flutter.pigeon.path_provider_foundation.PathProviderApi.getDirectoryPath was null.',
              );
              final List<Object?> args = (message as List<Object?>?)!;
              final DirectoryType? arg_type = (args[0] as DirectoryType?);
              assert(
                arg_type != null,
                'Argument for dev.flutter.pigeon.path_provider_foundation.PathProviderApi.getDirectoryPath was null, expected non-null DirectoryType.',
              );
              try {
                final String? output = api.getDirectoryPath(arg_type!);
                return <Object?>[output];
              } on PlatformException catch (e) {
                return wrapResponse(error: e);
              } catch (e) {
                return wrapResponse(
                  error: PlatformException(
                    code: 'error',
                    message: e.toString(),
                  ),
                );
              }
            });
      }
    }
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.path_provider_foundation.PathProviderApi.getContainerPath$messageChannelSuffix',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(pigeonVar_channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(pigeonVar_channel, (
              Object? message,
            ) async {
              assert(
                message != null,
                'Argument for dev.flutter.pigeon.path_provider_foundation.PathProviderApi.getContainerPath was null.',
              );
              final List<Object?> args = (message as List<Object?>?)!;
              final String? arg_appGroupIdentifier = (args[0] as String?);
              assert(
                arg_appGroupIdentifier != null,
                'Argument for dev.flutter.pigeon.path_provider_foundation.PathProviderApi.getContainerPath was null, expected non-null String.',
              );
              try {
                final String? output = api.getContainerPath(
                  arg_appGroupIdentifier!,
                );
                return <Object?>[output];
              } on PlatformException catch (e) {
                return wrapResponse(error: e);
              } catch (e) {
                return wrapResponse(
                  error: PlatformException(
                    code: 'error',
                    message: e.toString(),
                  ),
                );
              }
            });
      }
    }
  }
}
