/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.util.ArrayList;

public class SpellCheckChannel {
    private static final String TAG = "SpellCheckChannel";
    public final MethodChannel channel;
    private SpellCheckMethodHandler spellCheckMethodHandler;
    @NonNull
    public final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (SpellCheckChannel.this.spellCheckMethodHandler == null) {
                Log.v(SpellCheckChannel.TAG, "No SpellCheckeMethodHandler registered, call not forwarded to spell check API.");
                return;
            }
            String method = call.method;
            Object args = call.arguments;
            Log.v(SpellCheckChannel.TAG, "Received '" + method + "' message.");
            switch (method) {
                case "SpellCheck.initiateSpellCheck": {
                    try {
                        ArrayList argumentList = (ArrayList)args;
                        String locale = (String)argumentList.get(0);
                        String text = (String)argumentList.get(1);
                        SpellCheckChannel.this.spellCheckMethodHandler.initiateSpellCheck(locale, text, result);
                    }
                    catch (IllegalStateException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    public SpellCheckChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/spellcheck", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
    }

    public void setSpellCheckMethodHandler(@Nullable SpellCheckMethodHandler spellCheckMethodHandler) {
        this.spellCheckMethodHandler = spellCheckMethodHandler;
    }

    public static interface SpellCheckMethodHandler {
        public void initiateSpellCheck(@NonNull String var1, @NonNull String var2, @NonNull MethodChannel.Result var3);
    }
}

