// Copyright (c) 2021, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:analyzer/src/dart/error/ffi_code.dart';
import 'package:test_reflective_loader/test_reflective_loader.dart';

import '../dart/resolution/context_collection_resolution.dart';

main() {
  defineReflectiveSuite(() {
    defineReflectiveTests(NonSizedTypeArgument);
  });
}

@reflectiveTest
class NonSizedTypeArgument extends PubPackageResolutionTest {
  test_invalid_struct() async {
    await assertErrorsInCode(
      r'''
import 'dart:ffi';

final class C extends Struct {
  @Array(8)
  external Array<Void> a0;
}
''',
      [error(FfiCode.nonSizedTypeArgument, 80, 4)],
    );
  }

  test_invalid_union() async {
    await assertErrorsInCode(
      r'''
import 'dart:ffi';

final class C extends Union {
  @Array(8)
  external Array<Void> a0;
}
''',
      [error(FfiCode.nonSizedTypeArgument, 79, 4)],
    );
  }

  test_valid() async {
    await assertNoErrorsInCode(r'''
import 'dart:ffi';

final class C extends Struct {
  @Array(8)
  external Array<Uint8> a0;
}
''');
  }
}
