// This is a generated file (see the discoveryapis_generator project).

// ignore_for_file: camel_case_types
// ignore_for_file: comment_references
// ignore_for_file: deprecated_member_use_from_same_package
// ignore_for_file: lines_longer_than_80_chars
// ignore_for_file: non_constant_identifier_names
// ignore_for_file: prefer_interpolation_to_compose_strings
// ignore_for_file: unnecessary_brace_in_string_interps
// ignore_for_file: unnecessary_lambdas
// ignore_for_file: unnecessary_library_directive
// ignore_for_file: unnecessary_string_interpolations

/// Content API for Shopping - v2.1
///
/// Manage your product listings and accounts for Google Shopping
///
/// For more information, see
/// <https://developers.google.com/shopping-content/v2/>
///
/// Create an instance of [ShoppingContentApi] to access these resources:
///
/// - [AccountsResource]
///   - [AccountsCredentialsResource]
///   - [AccountsLabelsResource]
///   - [AccountsReturncarrierResource]
/// - [AccountstatusesResource]
/// - [AccounttaxResource]
/// - [BuyongoogleprogramsResource]
/// - [CollectionsResource]
/// - [CollectionstatusesResource]
/// - [ConversionsourcesResource]
/// - [CssesResource]
/// - [DatafeedsResource]
/// - [DatafeedstatusesResource]
/// - [FreelistingsprogramResource]
///   - [FreelistingsprogramCheckoutsettingsResource]
/// - [LiasettingsResource]
/// - [LocalinventoryResource]
/// - [MerchantsupportResource]
/// - [OrderinvoicesResource]
/// - [OrderreportsResource]
/// - [OrderreturnsResource]
///   - [OrderreturnsLabelsResource]
/// - [OrdersResource]
/// - [OrdertrackingsignalsResource]
/// - [PosResource]
/// - [ProductdeliverytimeResource]
/// - [ProductsResource]
/// - [ProductstatusesResource]
///   - [ProductstatusesRepricingreportsResource]
/// - [PromotionsResource]
/// - [PubsubnotificationsettingsResource]
/// - [QuotasResource]
/// - [RecommendationsResource]
/// - [RegionalinventoryResource]
/// - [RegionsResource]
/// - [ReportsResource]
/// - [RepricingrulesResource]
///   - [RepricingrulesRepricingreportsResource]
/// - [ReturnaddressResource]
/// - [ReturnpolicyResource]
/// - [ReturnpolicyonlineResource]
/// - [SettlementreportsResource]
/// - [SettlementtransactionsResource]
/// - [ShippingsettingsResource]
/// - [ShoppingadsprogramResource]
library content_v2_1;

import 'dart:async' as async;
import 'dart:convert' as convert;
import 'dart:core' as core;

import 'package:_discoveryapis_commons/_discoveryapis_commons.dart' as commons;
import 'package:http/http.dart' as http;

import '../shared.dart';
import '../src/user_agent.dart';

export 'package:_discoveryapis_commons/_discoveryapis_commons.dart'
    show ApiRequestError, DetailedApiRequestError;

/// Manage your product listings and accounts for Google Shopping
class ShoppingContentApi {
  /// Manage your product listings and accounts for Google Shopping
  static const contentScope = 'https://www.googleapis.com/auth/content';

  final commons.ApiRequester _requester;

  AccountsResource get accounts => AccountsResource(_requester);
  AccountstatusesResource get accountstatuses =>
      AccountstatusesResource(_requester);
  AccounttaxResource get accounttax => AccounttaxResource(_requester);
  BuyongoogleprogramsResource get buyongoogleprograms =>
      BuyongoogleprogramsResource(_requester);
  CollectionsResource get collections => CollectionsResource(_requester);
  CollectionstatusesResource get collectionstatuses =>
      CollectionstatusesResource(_requester);
  ConversionsourcesResource get conversionsources =>
      ConversionsourcesResource(_requester);
  CssesResource get csses => CssesResource(_requester);
  DatafeedsResource get datafeeds => DatafeedsResource(_requester);
  DatafeedstatusesResource get datafeedstatuses =>
      DatafeedstatusesResource(_requester);
  FreelistingsprogramResource get freelistingsprogram =>
      FreelistingsprogramResource(_requester);
  LiasettingsResource get liasettings => LiasettingsResource(_requester);
  LocalinventoryResource get localinventory =>
      LocalinventoryResource(_requester);
  MerchantsupportResource get merchantsupport =>
      MerchantsupportResource(_requester);
  OrderinvoicesResource get orderinvoices => OrderinvoicesResource(_requester);
  OrderreportsResource get orderreports => OrderreportsResource(_requester);
  OrderreturnsResource get orderreturns => OrderreturnsResource(_requester);
  OrdersResource get orders => OrdersResource(_requester);
  OrdertrackingsignalsResource get ordertrackingsignals =>
      OrdertrackingsignalsResource(_requester);
  PosResource get pos => PosResource(_requester);
  ProductdeliverytimeResource get productdeliverytime =>
      ProductdeliverytimeResource(_requester);
  ProductsResource get products => ProductsResource(_requester);
  ProductstatusesResource get productstatuses =>
      ProductstatusesResource(_requester);
  PromotionsResource get promotions => PromotionsResource(_requester);
  PubsubnotificationsettingsResource get pubsubnotificationsettings =>
      PubsubnotificationsettingsResource(_requester);
  QuotasResource get quotas => QuotasResource(_requester);
  RecommendationsResource get recommendations =>
      RecommendationsResource(_requester);
  RegionalinventoryResource get regionalinventory =>
      RegionalinventoryResource(_requester);
  RegionsResource get regions => RegionsResource(_requester);
  ReportsResource get reports => ReportsResource(_requester);
  RepricingrulesResource get repricingrules =>
      RepricingrulesResource(_requester);
  ReturnaddressResource get returnaddress => ReturnaddressResource(_requester);
  ReturnpolicyResource get returnpolicy => ReturnpolicyResource(_requester);
  ReturnpolicyonlineResource get returnpolicyonline =>
      ReturnpolicyonlineResource(_requester);
  SettlementreportsResource get settlementreports =>
      SettlementreportsResource(_requester);
  SettlementtransactionsResource get settlementtransactions =>
      SettlementtransactionsResource(_requester);
  ShippingsettingsResource get shippingsettings =>
      ShippingsettingsResource(_requester);
  ShoppingadsprogramResource get shoppingadsprogram =>
      ShoppingadsprogramResource(_requester);

  ShoppingContentApi(http.Client client,
      {core.String rootUrl = 'https://shoppingcontent.googleapis.com/',
      core.String servicePath = 'content/v2.1/'})
      : _requester =
            commons.ApiRequester(client, rootUrl, servicePath, requestHeaders);
}

class AccountsResource {
  final commons.ApiRequester _requester;

  AccountsCredentialsResource get credentials =>
      AccountsCredentialsResource(_requester);
  AccountsLabelsResource get labels => AccountsLabelsResource(_requester);
  AccountsReturncarrierResource get returncarrier =>
      AccountsReturncarrierResource(_requester);

  AccountsResource(commons.ApiRequester client) : _requester = client;

  /// Returns information about the authenticated user.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountsAuthInfoResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountsAuthInfoResponse> authinfo({
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'accounts/authinfo';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AccountsAuthInfoResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Claims the website of a Merchant Center sub-account.
  ///
  /// Merchant accounts with approved third-party CSSs aren't required to claim
  /// a website.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account whose website is claimed.
  ///
  /// [overwrite] - Only available to selected merchants, for example
  /// multi-client accounts (MCAs) and their sub-accounts. When set to `True`,
  /// this option removes any existing claim on the requested website and
  /// replaces it with a claim from the account that makes the request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountsClaimWebsiteResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountsClaimWebsiteResponse> claimwebsite(
    core.String merchantId,
    core.String accountId, {
    core.bool? overwrite,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (overwrite != null) 'overwrite': ['${overwrite}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId') +
        '/claimwebsite';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return AccountsClaimWebsiteResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves, inserts, updates, and deletes multiple Merchant Center
  /// (sub-)accounts in a single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountsCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountsCustomBatchResponse> custombatch(
    AccountsCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'accounts/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountsCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Merchant Center sub-account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. This must be a multi-client
  /// account, and accountId must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account.
  ///
  /// [force] - Option to delete sub-accounts with products. The default value
  /// is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String accountId, {
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves a Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account.
  ///
  /// [view] - Controls which fields will be populated. Acceptable values are:
  /// "merchant" and "css". The default value is "merchant".
  /// Possible string values are:
  /// - "MERCHANT" : Default. View is populated with Merchant Center fields.
  /// - "CSS" : View is populated with Comparison Shopping Services fields.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Account].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Account> get(
    core.String merchantId,
    core.String accountId, {
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Account.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a Merchant Center sub-account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. This must be a multi-client
  /// account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Account].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Account> insert(
    Account request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/accounts';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Account.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Performs an action on a link between two Merchant Center accounts, namely
  /// accountId and linkedAccountId.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account that should be linked.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountsLinkResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountsLinkResponse> link(
    AccountsLinkRequest request,
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId') +
        '/link';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountsLinkResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the sub-accounts in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. This must be a multi-client
  /// account.
  ///
  /// [label] - If view is set to "css", only return accounts that are assigned
  /// label with given ID.
  ///
  /// [maxResults] - The maximum number of accounts to return in the response,
  /// used for paging.
  ///
  /// [name] - If set, only the accounts with the given name (case sensitive)
  /// will be returned.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [view] - Controls which fields will be populated. Acceptable values are:
  /// "merchant" and "css". The default value is "merchant".
  /// Possible string values are:
  /// - "MERCHANT" : Default. View is populated with Merchant Center fields.
  /// - "CSS" : View is populated with Comparison Shopping Services fields.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountsListResponse> list(
    core.String merchantId, {
    core.String? label,
    core.int? maxResults,
    core.String? name,
    core.String? pageToken,
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (label != null) 'label': [label],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (name != null) 'name': [name],
      if (pageToken != null) 'pageToken': [pageToken],
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/accounts';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AccountsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the list of accounts linked to your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to list links.
  ///
  /// [maxResults] - The maximum number of links to return in the response, used
  /// for pagination. The minimum allowed value is 5 results per page. If
  /// provided value is lower than 5, it will be automatically increased to 5.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountsListLinksResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountsListLinksResponse> listlinks(
    core.String merchantId,
    core.String accountId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId') +
        '/listlinks';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AccountsListLinksResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Request verification code to start phone verification.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the managing account. If this parameter
  /// is not the same as accountId, then this account must be a multi-client
  /// account and accountId must be the ID of a sub-account of this account.
  ///
  /// [accountId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RequestPhoneVerificationResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RequestPhoneVerificationResponse> requestphoneverification(
    RequestPhoneVerificationRequest request,
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId') +
        '/requestphoneverification';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return RequestPhoneVerificationResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a Merchant Center account.
  ///
  /// Any fields that are not provided are deleted from the resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Account].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Account> update(
    Account request,
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Account.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates labels that are assigned to the Merchant Center account by CSS
  /// user.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account.
  ///
  /// [accountId] - The ID of the account whose labels are updated.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountsUpdateLabelsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountsUpdateLabelsResponse> updatelabels(
    AccountsUpdateLabelsRequest request,
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId') +
        '/updatelabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountsUpdateLabelsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Validates verification code to verify phone number for the account.
  ///
  /// If successful this will overwrite the value of
  /// `accounts.businessinformation.phoneNumber`. Only verified phone number
  /// will replace an existing verified phone number.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the managing account. If this parameter
  /// is not the same as accountId, then this account must be a multi-client
  /// account and accountId must be the ID of a sub-account of this account.
  ///
  /// [accountId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [VerifyPhoneNumberResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<VerifyPhoneNumberResponse> verifyphonenumber(
    VerifyPhoneNumberRequest request,
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounts/' +
        commons.escapeVariable('$accountId') +
        '/verifyphonenumber';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return VerifyPhoneNumberResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class AccountsCredentialsResource {
  final commons.ApiRequester _requester;

  AccountsCredentialsResource(commons.ApiRequester client)
      : _requester = client;

  /// Uploads credentials for the Merchant Center account.
  ///
  /// If credentials already exist for this Merchant Center account and purpose,
  /// this method updates them.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The merchant id of the account these credentials
  /// belong to.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountCredentials].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountCredentials> create(
    AccountCredentials request,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'accounts/' + commons.escapeVariable('$accountId') + '/credentials';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountCredentials.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class AccountsLabelsResource {
  final commons.ApiRequester _requester;

  AccountsLabelsResource(commons.ApiRequester client) : _requester = client;

  /// Creates a new label, not assigned to any account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The id of the account this label belongs to.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountLabel].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountLabel> create(
    AccountLabel request,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'accounts/' + commons.escapeVariable('$accountId') + '/labels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountLabel.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a label and removes it from all accounts to which it was assigned.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The id of the account that owns the label.
  ///
  /// [labelId] - Required. The id of the label to delete.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String accountId,
    core.String labelId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'accounts/' +
        commons.escapeVariable('$accountId') +
        '/labels/' +
        commons.escapeVariable('$labelId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Lists the labels assigned to an account.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The account id for whose labels are to be listed.
  ///
  /// [pageSize] - The maximum number of labels to return. The service may
  /// return fewer than this value. If unspecified, at most 50 labels will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - A page token, received from a previous `ListAccountLabels`
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to `ListAccountLabels` must match the call that
  /// provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListAccountLabelsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListAccountLabelsResponse> list(
    core.String accountId, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'accounts/' + commons.escapeVariable('$accountId') + '/labels';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListAccountLabelsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a label.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The id of the account this label belongs to.
  ///
  /// [labelId] - Required. The id of the label to update.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountLabel].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountLabel> patch(
    AccountLabel request,
    core.String accountId,
    core.String labelId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'accounts/' +
        commons.escapeVariable('$accountId') +
        '/labels/' +
        commons.escapeVariable('$labelId');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountLabel.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class AccountsReturncarrierResource {
  final commons.ApiRequester _requester;

  AccountsReturncarrierResource(commons.ApiRequester client)
      : _requester = client;

  /// Links return carrier to a merchant account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The Merchant Center Account Id under which the
  /// Return Carrier is to be linked.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountReturnCarrier].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountReturnCarrier> create(
    AccountReturnCarrier request,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'accounts/' + commons.escapeVariable('$accountId') + '/returncarrier';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountReturnCarrier.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete a return carrier in the merchant account.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The Merchant Center Account Id under which the
  /// Return Carrier is to be linked.
  ///
  /// [carrierAccountId] - Required. The Google-provided unique carrier ID, used
  /// to update the resource.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String accountId,
    core.String carrierAccountId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'accounts/' +
        commons.escapeVariable('$accountId') +
        '/returncarrier/' +
        commons.escapeVariable('$carrierAccountId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Lists available return carriers in the merchant account.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The Merchant Center Account Id under which the
  /// Return Carrier is to be linked.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListAccountReturnCarrierResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListAccountReturnCarrierResponse> list(
    core.String accountId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'accounts/' + commons.escapeVariable('$accountId') + '/returncarrier';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListAccountReturnCarrierResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a return carrier in the merchant account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [accountId] - Required. The Merchant Center Account Id under which the
  /// Return Carrier is to be linked.
  ///
  /// [carrierAccountId] - Required. The Google-provided unique carrier ID, used
  /// to update the resource.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountReturnCarrier].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountReturnCarrier> patch(
    AccountReturnCarrier request,
    core.String accountId,
    core.String carrierAccountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'accounts/' +
        commons.escapeVariable('$accountId') +
        '/returncarrier/' +
        commons.escapeVariable('$carrierAccountId');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountReturnCarrier.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class AccountstatusesResource {
  final commons.ApiRequester _requester;

  AccountstatusesResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves multiple Merchant Center account statuses in a single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountstatusesCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountstatusesCustomBatchResponse> custombatch(
    AccountstatusesCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'accountstatuses/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountstatusesCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the status of a Merchant Center account.
  ///
  /// No itemLevelIssues are returned for multi-client accounts.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account.
  ///
  /// [destinations] - If set, only issues for the specified destinations are
  /// returned, otherwise only issues for the Shopping destination.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountStatus].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountStatus> get(
    core.String merchantId,
    core.String accountId, {
    core.List<core.String>? destinations,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (destinations != null) 'destinations': destinations,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accountstatuses/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AccountStatus.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the statuses of the sub-accounts in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. This must be a multi-client
  /// account.
  ///
  /// [destinations] - If set, only issues for the specified destinations are
  /// returned, otherwise only issues for the Shopping destination.
  ///
  /// [maxResults] - The maximum number of account statuses to return in the
  /// response, used for paging.
  ///
  /// [name] - If set, only the accounts with the given name (case sensitive)
  /// will be returned.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountstatusesListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountstatusesListResponse> list(
    core.String merchantId, {
    core.List<core.String>? destinations,
    core.int? maxResults,
    core.String? name,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (destinations != null) 'destinations': destinations,
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (name != null) 'name': [name],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/accountstatuses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AccountstatusesListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class AccounttaxResource {
  final commons.ApiRequester _requester;

  AccounttaxResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves and updates tax settings of multiple accounts in a single
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccounttaxCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccounttaxCustomBatchResponse> custombatch(
    AccounttaxCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'accounttax/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return AccounttaxCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the tax settings of the account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to get/update account tax
  /// settings.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountTax].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountTax> get(
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounttax/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AccountTax.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the tax settings of the sub-accounts in your Merchant Center
  /// account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. This must be a multi-client
  /// account.
  ///
  /// [maxResults] - The maximum number of tax settings to return in the
  /// response, used for paging.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccounttaxListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccounttaxListResponse> list(
    core.String merchantId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/accounttax';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AccounttaxListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the tax settings of the account.
  ///
  /// Any fields that are not provided are deleted from the resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to get/update account tax
  /// settings.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AccountTax].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AccountTax> update(
    AccountTax request,
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/accounttax/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return AccountTax.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class BuyongoogleprogramsResource {
  final commons.ApiRequester _requester;

  BuyongoogleprogramsResource(commons.ApiRequester client)
      : _requester = client;

  /// Reactivates the BoG program in your Merchant Center account.
  ///
  /// Moves the program to the active state when allowed, for example, when
  /// paused. This method is only available to selected merchants.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [regionCode] - Required. The program region code \[ISO 3166-1
  /// alpha-2\](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently
  /// only US is available.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> activate(
    ActivateBuyOnGoogleProgramRequest request,
    core.String merchantId,
    core.String regionCode, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/buyongoogleprograms/' +
        commons.escapeVariable('$regionCode') +
        '/activate';

    await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves a status of the BoG program for your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [regionCode] - Required. The Program region code \[ISO 3166-1
  /// alpha-2\](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently
  /// only US is available.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BuyOnGoogleProgramStatus].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BuyOnGoogleProgramStatus> get(
    core.String merchantId,
    core.String regionCode, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/buyongoogleprograms/' +
        commons.escapeVariable('$regionCode');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return BuyOnGoogleProgramStatus.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Onboards the BoG program in your Merchant Center account.
  ///
  /// By using this method, you agree to the
  /// [Terms of Service](https://merchants.google.com/mc/termsofservice/transactions/US/latest).
  /// Calling this method is only possible if the authenticated account is the
  /// same as the merchant id in the request. Calling this method multiple times
  /// will only accept Terms of Service if the latest version is not currently
  /// signed.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [regionCode] - Required. The program region code \[ISO 3166-1
  /// alpha-2\](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently
  /// only US is available.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> onboard(
    OnboardBuyOnGoogleProgramRequest request,
    core.String merchantId,
    core.String regionCode, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/buyongoogleprograms/' +
        commons.escapeVariable('$regionCode') +
        '/onboard';

    await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Updates the status of the BoG program for your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [regionCode] - Required. The program region code \[ISO 3166-1
  /// alpha-2\](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently
  /// only US is available.
  ///
  /// [updateMask] - The list of fields to update. If the update mask is not
  /// provided, then all the fields set in buyOnGoogleProgramStatus will be
  /// updated. Clearing fields is only possible if update mask is provided.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BuyOnGoogleProgramStatus].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BuyOnGoogleProgramStatus> patch(
    BuyOnGoogleProgramStatus request,
    core.String merchantId,
    core.String regionCode, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/buyongoogleprograms/' +
        commons.escapeVariable('$regionCode');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return BuyOnGoogleProgramStatus.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Pauses the BoG program in your Merchant Center account.
  ///
  /// This method is only available to selected merchants.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [regionCode] - Required. The program region code \[ISO 3166-1
  /// alpha-2\](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently
  /// only US is available.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> pause(
    PauseBuyOnGoogleProgramRequest request,
    core.String merchantId,
    core.String regionCode, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/buyongoogleprograms/' +
        commons.escapeVariable('$regionCode') +
        '/pause';

    await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Requests review and then activates the BoG program in your Merchant Center
  /// account for the first time.
  ///
  /// Moves the program to the REVIEW_PENDING state. This method is only
  /// available to selected merchants.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [regionCode] - Required. The program region code \[ISO 3166-1
  /// alpha-2\](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). Currently
  /// only US is available.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> requestreview(
    RequestReviewBuyOnGoogleProgramRequest request,
    core.String merchantId,
    core.String regionCode, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/buyongoogleprograms/' +
        commons.escapeVariable('$regionCode') +
        '/requestreview';

    await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }
}

class CollectionsResource {
  final commons.ApiRequester _requester;

  CollectionsResource(commons.ApiRequester client) : _requester = client;

  /// Uploads a collection to your Merchant Center account.
  ///
  /// If a collection with the same collectionId already exists, this method
  /// updates that entry. In each update, the collection is completely replaced
  /// by the fields in the body of the update request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection. This account cannot be a multi-client account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Collection].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Collection> create(
    Collection request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/collections';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Collection.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a collection from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection. This account cannot be a multi-client account.
  ///
  /// [collectionId] - Required. The collectionId of the collection.
  /// CollectionId is the same as the REST ID of the collection.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String collectionId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/collections/' +
        commons.escapeVariable('$collectionId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves a collection from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection. This account cannot be a multi-client account.
  ///
  /// [collectionId] - Required. The REST ID of the collection.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Collection].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Collection> get(
    core.String merchantId,
    core.String collectionId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/collections/' +
        commons.escapeVariable('$collectionId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Collection.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the collections in your Merchant Center account.
  ///
  /// The response might contain fewer items than specified by page_size. Rely
  /// on next_page_token to determine if there are more items to be requested.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection. This account cannot be a multi-client account.
  ///
  /// [pageSize] - The maximum number of collections to return in the response,
  /// used for paging. Defaults to 50; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - Token (if provided) to retrieve the subsequent page. All
  /// other parameters must match the original call that provided the page
  /// token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListCollectionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListCollectionsResponse> list(
    core.String merchantId, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/collections';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListCollectionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class CollectionstatusesResource {
  final commons.ApiRequester _requester;

  CollectionstatusesResource(commons.ApiRequester client) : _requester = client;

  /// Gets the status of a collection from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection. This account cannot be a multi-client account.
  ///
  /// [collectionId] - Required. The collectionId of the collection.
  /// CollectionId is the same as the REST ID of the collection.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [CollectionStatus].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<CollectionStatus> get(
    core.String merchantId,
    core.String collectionId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/collectionstatuses/' +
        commons.escapeVariable('$collectionId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return CollectionStatus.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the statuses of the collections in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection. This account cannot be a multi-client account.
  ///
  /// [pageSize] - The maximum number of collection statuses to return in the
  /// response, used for paging. Defaults to 50; values above 1000 will be
  /// coerced to 1000.
  ///
  /// [pageToken] - Token (if provided) to retrieve the subsequent page. All
  /// other parameters must match the original call that provided the page
  /// token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListCollectionStatusesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListCollectionStatusesResponse> list(
    core.String merchantId, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/collectionstatuses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListCollectionStatusesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ConversionsourcesResource {
  final commons.ApiRequester _requester;

  ConversionsourcesResource(commons.ApiRequester client) : _requester = client;

  /// Creates a new conversion source.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that owns the new
  /// conversion source.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ConversionSource].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ConversionSource> create(
    ConversionSource request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/conversionsources';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ConversionSource.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Archives an existing conversion source.
  ///
  /// It will be recoverable for 30 days. This archiving behavior is not typical
  /// in the Content API and unique to this service.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that owns the new
  /// conversion source.
  ///
  /// [conversionSourceId] - Required. The ID of the conversion source to be
  /// deleted.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String conversionSourceId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/conversionsources/' +
        commons.escapeVariable('$conversionSourceId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Fetches a conversion source.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that owns the new
  /// conversion source.
  ///
  /// [conversionSourceId] - Required. The REST ID of the collection.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ConversionSource].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ConversionSource> get(
    core.String merchantId,
    core.String conversionSourceId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/conversionsources/' +
        commons.escapeVariable('$conversionSourceId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ConversionSource.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of conversion sources the caller has access to.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that owns the new
  /// conversion source.
  ///
  /// [pageSize] - The maximum number of conversion sources to return in a page.
  /// If no `page_size` is specified, `100` is used as the default value. The
  /// maximum value is `200`. Values above `200` will be coerced to `200`.
  /// Regardless of pagination, at most `200` conversion sources are returned in
  /// total.
  ///
  /// [pageToken] - Page token.
  ///
  /// [showDeleted] - If true, also returns archived conversion sources.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListConversionSourcesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListConversionSourcesResponse> list(
    core.String merchantId, {
    core.int? pageSize,
    core.String? pageToken,
    core.bool? showDeleted,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (showDeleted != null) 'showDeleted': ['${showDeleted}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/conversionsources';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListConversionSourcesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates information of an existing conversion source.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that owns the new
  /// conversion source.
  ///
  /// [conversionSourceId] - Required. The ID of the conversion source to be
  /// updated.
  ///
  /// [updateMask] - Required. List of fields being updated.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ConversionSource].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ConversionSource> patch(
    ConversionSource request,
    core.String merchantId,
    core.String conversionSourceId, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/conversionsources/' +
        commons.escapeVariable('$conversionSourceId');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return ConversionSource.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Re-enables an archived conversion source.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that owns the new
  /// conversion source.
  ///
  /// [conversionSourceId] - Required. The ID of the conversion source to be
  /// undeleted.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> undelete(
    UndeleteConversionSourceRequest request,
    core.String merchantId,
    core.String conversionSourceId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/conversionsources/' +
        commons.escapeVariable('$conversionSourceId') +
        ':undelete';

    await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }
}

class CssesResource {
  final commons.ApiRequester _requester;

  CssesResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves a single CSS domain by ID.
  ///
  /// Request parameters:
  ///
  /// [cssGroupId] - Required. The ID of the managing account. If this parameter
  /// is not the same as \[cssDomainId\](#cssDomainId), then this ID must be a
  /// CSS group ID and `cssDomainId` must be the ID of a CSS domain affiliated
  /// with this group.
  ///
  /// [cssDomainId] - Required. The ID of the CSS domain to return.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Css].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Css> get(
    core.String cssGroupId,
    core.String cssDomainId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$cssGroupId') +
        '/csses/' +
        commons.escapeVariable('$cssDomainId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Css.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists CSS domains affiliated with a CSS group.
  ///
  /// Request parameters:
  ///
  /// [cssGroupId] - Required. The CSS group ID of CSS domains to be listed.
  ///
  /// [pageSize] - The maximum number of CSS domains to return. The service may
  /// return fewer than this value. If unspecified, at most 50 CSS domains will
  /// be returned. The maximum value is 1000; values above 1000 will be coerced
  /// to 1000.
  ///
  /// [pageToken] - A page token, received from a previous `ListCsses` call.
  /// Provide this to retrieve the subsequent page. When paginating, all other
  /// parameters provided to `ListCsses` must match the call that provided the
  /// page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListCssesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListCssesResponse> list(
    core.String cssGroupId, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$cssGroupId') + '/csses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListCssesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates labels that are assigned to a CSS domain by its CSS group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [cssGroupId] - Required. The CSS group ID of the updated CSS domain.
  ///
  /// [cssDomainId] - Required. The ID of the updated CSS domain.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Css].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Css> updatelabels(
    LabelIds request,
    core.String cssGroupId,
    core.String cssDomainId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$cssGroupId') +
        '/csses/' +
        commons.escapeVariable('$cssDomainId') +
        '/updatelabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Css.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class DatafeedsResource {
  final commons.ApiRequester _requester;

  DatafeedsResource(commons.ApiRequester client) : _requester = client;

  /// Deletes, fetches, gets, inserts and updates multiple datafeeds in a single
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DatafeedsCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DatafeedsCustomBatchResponse> custombatch(
    DatafeedsCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'datafeeds/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return DatafeedsCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a datafeed configuration from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the datafeed. This
  /// account cannot be a multi-client account.
  ///
  /// [datafeedId] - The ID of the datafeed.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String datafeedId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/datafeeds/' +
        commons.escapeVariable('$datafeedId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Invokes a fetch for the datafeed in your Merchant Center account.
  ///
  /// If you need to call this method more than once per day, we recommend you
  /// use the
  /// [Products service](https://developers.google.com/shopping-content/reference/rest/v2.1/products)
  /// to update your product data.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the datafeed. This
  /// account cannot be a multi-client account.
  ///
  /// [datafeedId] - The ID of the datafeed to be fetched.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DatafeedsFetchNowResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DatafeedsFetchNowResponse> fetchnow(
    core.String merchantId,
    core.String datafeedId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/datafeeds/' +
        commons.escapeVariable('$datafeedId') +
        '/fetchNow';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return DatafeedsFetchNowResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a datafeed configuration from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the datafeed. This
  /// account cannot be a multi-client account.
  ///
  /// [datafeedId] - The ID of the datafeed.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Datafeed].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Datafeed> get(
    core.String merchantId,
    core.String datafeedId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/datafeeds/' +
        commons.escapeVariable('$datafeedId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Datafeed.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Registers a datafeed configuration with your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the datafeed. This
  /// account cannot be a multi-client account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Datafeed].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Datafeed> insert(
    Datafeed request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/datafeeds';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Datafeed.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the configurations for datafeeds in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the datafeeds. This
  /// account cannot be a multi-client account.
  ///
  /// [maxResults] - The maximum number of products to return in the response,
  /// used for paging.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DatafeedsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DatafeedsListResponse> list(
    core.String merchantId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/datafeeds';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return DatafeedsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a datafeed configuration of your Merchant Center account.
  ///
  /// Any fields that are not provided are deleted from the resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the datafeed. This
  /// account cannot be a multi-client account.
  ///
  /// [datafeedId] - The ID of the datafeed.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Datafeed].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Datafeed> update(
    Datafeed request,
    core.String merchantId,
    core.String datafeedId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/datafeeds/' +
        commons.escapeVariable('$datafeedId');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Datafeed.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class DatafeedstatusesResource {
  final commons.ApiRequester _requester;

  DatafeedstatusesResource(commons.ApiRequester client) : _requester = client;

  /// Gets multiple Merchant Center datafeed statuses in a single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DatafeedstatusesCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DatafeedstatusesCustomBatchResponse> custombatch(
    DatafeedstatusesCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'datafeedstatuses/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return DatafeedstatusesCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the status of a datafeed from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the datafeed. This
  /// account cannot be a multi-client account.
  ///
  /// [datafeedId] - The ID of the datafeed.
  ///
  /// [country] - Deprecated. Use `feedLabel` instead. The country to get the
  /// datafeed status for. If this parameter is provided then `language` must
  /// also be provided. Note that this parameter is required for feeds targeting
  /// multiple countries and languages, since a feed may have a different status
  /// for each target.
  ///
  /// [feedLabel] - The feed label to get the datafeed status for. If this
  /// parameter is provided then `language` must also be provided. Note that
  /// this parameter is required for feeds targeting multiple countries and
  /// languages, since a feed may have a different status for each target.
  ///
  /// [language] - The language to get the datafeed status for. If this
  /// parameter is provided then `country` must also be provided. Note that this
  /// parameter is required for feeds targeting multiple countries and
  /// languages, since a feed may have a different status for each target.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DatafeedStatus].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DatafeedStatus> get(
    core.String merchantId,
    core.String datafeedId, {
    core.String? country,
    core.String? feedLabel,
    core.String? language,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (country != null) 'country': [country],
      if (feedLabel != null) 'feedLabel': [feedLabel],
      if (language != null) 'language': [language],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/datafeedstatuses/' +
        commons.escapeVariable('$datafeedId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return DatafeedStatus.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the statuses of the datafeeds in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the datafeeds. This
  /// account cannot be a multi-client account.
  ///
  /// [maxResults] - The maximum number of products to return in the response,
  /// used for paging.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DatafeedstatusesListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DatafeedstatusesListResponse> list(
    core.String merchantId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/datafeedstatuses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return DatafeedstatusesListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class FreelistingsprogramResource {
  final commons.ApiRequester _requester;

  FreelistingsprogramCheckoutsettingsResource get checkoutsettings =>
      FreelistingsprogramCheckoutsettingsResource(_requester);

  FreelistingsprogramResource(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves the status and review eligibility for the free listing program.
  ///
  /// Returns errors and warnings if they require action to resolve, will become
  /// disapprovals, or impact impressions. Use `accountstatuses` to view all
  /// issues for an account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [FreeListingsProgramStatus].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<FreeListingsProgramStatus> get(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/freelistingsprogram';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return FreeListingsProgramStatus.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Requests a review of free listings in a specific region.
  ///
  /// This method deprecated. Use the `MerchantSupportService` to view product
  /// and account issues and request a review.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> requestreview(
    RequestReviewFreeListingsRequest request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/freelistingsprogram/requestreview';

    await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }
}

class FreelistingsprogramCheckoutsettingsResource {
  final commons.ApiRequester _requester;

  FreelistingsprogramCheckoutsettingsResource(commons.ApiRequester client)
      : _requester = client;

  /// Deletes `Checkout` settings and unenrolls merchant from `Checkout`
  /// program.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/freelistingsprogram/checkoutsettings';

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Gets Checkout settings for the given merchant.
  ///
  /// This includes information about review state, enrollment state and URL
  /// settings.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [CheckoutSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<CheckoutSettings> get(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/freelistingsprogram/checkoutsettings';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return CheckoutSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Enrolls merchant in `Checkout` program.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [CheckoutSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<CheckoutSettings> insert(
    InsertCheckoutSettingsRequest request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/freelistingsprogram/checkoutsettings';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return CheckoutSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class LiasettingsResource {
  final commons.ApiRequester _requester;

  LiasettingsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves and/or updates the LIA settings of multiple accounts in a single
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiasettingsCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiasettingsCustomBatchResponse> custombatch(
    LiasettingsCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'liasettings/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return LiasettingsCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the LIA settings of the account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to get or update LIA
  /// settings.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiaSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiaSettings> get(
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/liasettings/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return LiaSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of accessible Business Profiles.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to retrieve accessible
  /// Business Profiles.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiasettingsGetAccessibleGmbAccountsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiasettingsGetAccessibleGmbAccountsResponse>
      getaccessiblegmbaccounts(
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/liasettings/' +
        commons.escapeVariable('$accountId') +
        '/accessiblegmbaccounts';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return LiasettingsGetAccessibleGmbAccountsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the LIA settings of the sub-accounts in your Merchant Center
  /// account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. This must be a multi-client
  /// account.
  ///
  /// [maxResults] - The maximum number of LIA settings to return in the
  /// response, used for paging.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiasettingsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiasettingsListResponse> list(
    core.String merchantId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/liasettings';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return LiasettingsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of POS data providers that have active settings for the
  /// all eiligible countries.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiasettingsListPosDataProvidersResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiasettingsListPosDataProvidersResponse> listposdataproviders({
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'liasettings/posdataproviders';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return LiasettingsListPosDataProvidersResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Requests access to a specified Business Profile.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which Business Profile access is
  /// requested.
  ///
  /// [gmbEmail] - The email of the Business Profile.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiasettingsRequestGmbAccessResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiasettingsRequestGmbAccessResponse> requestgmbaccess(
    core.String merchantId,
    core.String accountId,
    core.String gmbEmail, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'gmbEmail': [gmbEmail],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/liasettings/' +
        commons.escapeVariable('$accountId') +
        '/requestgmbaccess';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return LiasettingsRequestGmbAccessResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Requests inventory validation for the specified country.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account that manages the order. This cannot be
  /// a multi-client account.
  ///
  /// [country] - The country for which inventory validation is requested.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiasettingsRequestInventoryVerificationResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiasettingsRequestInventoryVerificationResponse>
      requestinventoryverification(
    core.String merchantId,
    core.String accountId,
    core.String country, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/liasettings/' +
        commons.escapeVariable('$accountId') +
        '/requestinventoryverification/' +
        commons.escapeVariable('$country');

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return LiasettingsRequestInventoryVerificationResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the inventory verification contract for the specified country.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account that manages the order. This cannot be
  /// a multi-client account.
  ///
  /// [country] - The country for which inventory verification is requested.
  ///
  /// [language] - The language for which inventory verification is requested.
  ///
  /// [contactName] - The name of the inventory verification contact.
  ///
  /// [contactEmail] - The email of the inventory verification contact.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiasettingsSetInventoryVerificationContactResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiasettingsSetInventoryVerificationContactResponse>
      setinventoryverificationcontact(
    core.String merchantId,
    core.String accountId,
    core.String country,
    core.String language,
    core.String contactName,
    core.String contactEmail, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'country': [country],
      'language': [language],
      'contactName': [contactName],
      'contactEmail': [contactEmail],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/liasettings/' +
        commons.escapeVariable('$accountId') +
        '/setinventoryverificationcontact';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return LiasettingsSetInventoryVerificationContactResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the omnichannel experience for the specified country.
  ///
  /// Only supported for merchants whose POS data provider is trusted to enable
  /// the corresponding experience. For more context, see these help articles
  /// [about LFP](https://support.google.com/merchants/answer/7676652) and
  /// [how to get started](https://support.google.com/merchants/answer/7676578)
  /// with it.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to retrieve accessible
  /// Business Profiles.
  ///
  /// [country] - The CLDR country code (for example, "US") for which the
  /// omnichannel experience is selected.
  ///
  /// [lsfType] - The Local Store Front (LSF) type for this country. Acceptable
  /// values are: - "`ghlsf`" (Google-Hosted Local Store Front) - "`mhlsfBasic`"
  /// (Merchant-Hosted Local Store Front Basic) - "`mhlsfFull`" (Merchant-Hosted
  /// Local Store Front Full) More details about these types can be found here.
  ///
  /// [pickupTypes] - The Pickup types for this country. Acceptable values are:
  /// - "`pickupToday`" - "`pickupLater`"
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiaOmnichannelExperience].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiaOmnichannelExperience> setomnichannelexperience(
    core.String merchantId,
    core.String accountId, {
    core.String? country,
    core.String? lsfType,
    core.List<core.String>? pickupTypes,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (country != null) 'country': [country],
      if (lsfType != null) 'lsfType': [lsfType],
      if (pickupTypes != null) 'pickupTypes': pickupTypes,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/liasettings/' +
        commons.escapeVariable('$accountId') +
        '/setomnichannelexperience';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return LiaOmnichannelExperience.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the POS data provider for the specified country.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to retrieve accessible
  /// Business Profiles.
  ///
  /// [country] - The country for which the POS data provider is selected.
  ///
  /// [posDataProviderId] - The ID of POS data provider.
  ///
  /// [posExternalAccountId] - The account ID by which this merchant is known to
  /// the POS data provider.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiasettingsSetPosDataProviderResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiasettingsSetPosDataProviderResponse> setposdataprovider(
    core.String merchantId,
    core.String accountId,
    core.String country, {
    core.String? posDataProviderId,
    core.String? posExternalAccountId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'country': [country],
      if (posDataProviderId != null) 'posDataProviderId': [posDataProviderId],
      if (posExternalAccountId != null)
        'posExternalAccountId': [posExternalAccountId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/liasettings/' +
        commons.escapeVariable('$accountId') +
        '/setposdataprovider';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return LiasettingsSetPosDataProviderResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the LIA settings of the account.
  ///
  /// Any fields that are not provided are deleted from the resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to get or update LIA
  /// settings.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LiaSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LiaSettings> update(
    LiaSettings request,
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/liasettings/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return LiaSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class LocalinventoryResource {
  final commons.ApiRequester _requester;

  LocalinventoryResource(commons.ApiRequester client) : _requester = client;

  /// Updates local inventory for multiple products or stores in a single
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LocalinventoryCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LocalinventoryCustomBatchResponse> custombatch(
    LocalinventoryCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'localinventory/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return LocalinventoryCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the local inventory of a product in your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the product. This
  /// account cannot be a multi-client account.
  ///
  /// [productId] - The REST ID of the product for which to update local
  /// inventory.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LocalInventory].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LocalInventory> insert(
    LocalInventory request,
    core.String merchantId,
    core.String productId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/products/' +
        commons.escapeVariable('$productId') +
        '/localinventory';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return LocalInventory.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class MerchantsupportResource {
  final commons.ApiRequester _requester;

  MerchantsupportResource(commons.ApiRequester client) : _requester = client;

  /// Provide a list of merchant's issues with a support content and available
  /// actions.
  ///
  /// This content and actions are meant to be rendered and shown in third-party
  /// applications.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account to fetch issues for.
  ///
  /// [languageCode] - Optional. The \[IETF
  /// BCP-47\](https://tools.ietf.org/html/bcp47) language code used to localize
  /// support content. If not set, the result will be in default language
  /// ('en-US').
  ///
  /// [timeZone] - Optional. The [IANA](https://www.iana.org/time-zones)
  /// timezone used to localize times in support content. For example
  /// 'America/Los_Angeles'. If not set, results will use as a default UTC.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RenderAccountIssuesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RenderAccountIssuesResponse> renderaccountissues(
    RenderAccountIssuesRequestPayload request,
    core.String merchantId, {
    core.String? languageCode,
    core.String? timeZone,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (languageCode != null) 'languageCode': [languageCode],
      if (timeZone != null) 'timeZone': [timeZone],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/merchantsupport/renderaccountissues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return RenderAccountIssuesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Provide a list of issues for merchant's product with a support content and
  /// available actions.
  ///
  /// This content and actions are meant to be rendered and shown in third-party
  /// applications.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the product.
  ///
  /// [productId] - Required. The
  /// [REST_ID](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.id)
  /// of the product to fetch issues for.
  ///
  /// [languageCode] - Optional. The \[IETF
  /// BCP-47\](https://tools.ietf.org/html/bcp47) language code used to localize
  /// support content. If not set, the result will be in default language
  /// ('en-US').
  ///
  /// [timeZone] - Optional. The [IANA](https://www.iana.org/time-zones)
  /// timezone used to localize times in support content. For example
  /// 'America/Los_Angeles'. If not set, results will use as a default UTC.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RenderProductIssuesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RenderProductIssuesResponse> renderproductissues(
    RenderProductIssuesRequestPayload request,
    core.String merchantId,
    core.String productId, {
    core.String? languageCode,
    core.String? timeZone,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (languageCode != null) 'languageCode': [languageCode],
      if (timeZone != null) 'timeZone': [timeZone],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/merchantsupport/renderproductissues/' +
        commons.escapeVariable('$productId');

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return RenderProductIssuesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class OrderinvoicesResource {
  final commons.ApiRequester _requester;

  OrderinvoicesResource(commons.ApiRequester client) : _requester = client;

  /// Creates a charge invoice for a shipment group, and triggers a charge
  /// capture for orderinvoice enabled orders.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderinvoicesCreateChargeInvoiceResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderinvoicesCreateChargeInvoiceResponse> createchargeinvoice(
    OrderinvoicesCreateChargeInvoiceRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orderinvoices/' +
        commons.escapeVariable('$orderId') +
        '/createChargeInvoice';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrderinvoicesCreateChargeInvoiceResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a refund invoice for one or more shipment groups, and triggers a
  /// refund for orderinvoice enabled orders.
  ///
  /// This can only be used for line items that have previously been charged
  /// using `createChargeInvoice`. All amounts (except for the summary) are
  /// incremental with respect to the previous invoice.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderinvoicesCreateRefundInvoiceResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderinvoicesCreateRefundInvoiceResponse> createrefundinvoice(
    OrderinvoicesCreateRefundInvoiceRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orderinvoices/' +
        commons.escapeVariable('$orderId') +
        '/createRefundInvoice';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrderinvoicesCreateRefundInvoiceResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class OrderreportsResource {
  final commons.ApiRequester _requester;

  OrderreportsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves a report for disbursements from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [disbursementEndDate] - The last date which disbursements occurred. In ISO
  /// 8601 format. Default: current date.
  ///
  /// [disbursementStartDate] - The first date which disbursements occurred. In
  /// ISO 8601 format.
  ///
  /// [maxResults] - The maximum number of disbursements to return in the
  /// response, used for paging.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderreportsListDisbursementsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderreportsListDisbursementsResponse> listdisbursements(
    core.String merchantId, {
    core.String? disbursementEndDate,
    core.String? disbursementStartDate,
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (disbursementEndDate != null)
        'disbursementEndDate': [disbursementEndDate],
      if (disbursementStartDate != null)
        'disbursementStartDate': [disbursementStartDate],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        commons.escapeVariable('$merchantId') + '/orderreports/disbursements';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OrderreportsListDisbursementsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of transactions for a disbursement from your Merchant
  /// Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [disbursementId] - The Google-provided ID of the disbursement (found in
  /// Wallet).
  ///
  /// [maxResults] - The maximum number of disbursements to return in the
  /// response, used for paging.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [transactionEndDate] - The last date in which transaction occurred. In ISO
  /// 8601 format. Default: current date.
  ///
  /// [transactionStartDate] - The first date in which transaction occurred. In
  /// ISO 8601 format.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderreportsListTransactionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderreportsListTransactionsResponse> listtransactions(
    core.String merchantId,
    core.String disbursementId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? transactionEndDate,
    core.String? transactionStartDate,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (transactionEndDate != null)
        'transactionEndDate': [transactionEndDate],
      if (transactionStartDate != null)
        'transactionStartDate': [transactionStartDate],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orderreports/disbursements/' +
        commons.escapeVariable('$disbursementId') +
        '/transactions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OrderreportsListTransactionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class OrderreturnsResource {
  final commons.ApiRequester _requester;

  OrderreturnsLabelsResource get labels =>
      OrderreturnsLabelsResource(_requester);

  OrderreturnsResource(commons.ApiRequester client) : _requester = client;

  /// Acks an order return in your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [returnId] - The ID of the return.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderreturnsAcknowledgeResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderreturnsAcknowledgeResponse> acknowledge(
    OrderreturnsAcknowledgeRequest request,
    core.String merchantId,
    core.String returnId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orderreturns/' +
        commons.escapeVariable('$returnId') +
        '/acknowledge';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrderreturnsAcknowledgeResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Create return in your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderreturnsCreateOrderReturnResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderreturnsCreateOrderReturnResponse> createorderreturn(
    OrderreturnsCreateOrderReturnRequest request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orderreturns/createOrderReturn';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrderreturnsCreateOrderReturnResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves an order return from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [returnId] - Merchant order return ID generated by Google.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MerchantOrderReturn].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MerchantOrderReturn> get(
    core.String merchantId,
    core.String returnId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orderreturns/' +
        commons.escapeVariable('$returnId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return MerchantOrderReturn.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists order returns in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [acknowledged] - Obtains order returns that match the acknowledgement
  /// status. When set to true, obtains order returns that have been
  /// acknowledged. When false, obtains order returns that have not been
  /// acknowledged. When not provided, obtains order returns regardless of their
  /// acknowledgement status. We recommend using this filter set to `false`, in
  /// conjunction with the `acknowledge` call, such that only un-acknowledged
  /// order returns are returned.
  ///
  /// [createdEndDate] - Obtains order returns created before this date
  /// (inclusively), in ISO 8601 format.
  ///
  /// [createdStartDate] - Obtains order returns created after this date
  /// (inclusively), in ISO 8601 format.
  ///
  /// [googleOrderIds] - Obtains order returns with the specified order ids. If
  /// this parameter is provided, createdStartDate, createdEndDate,
  /// shipmentType, shipmentStatus, shipmentState and acknowledged parameters
  /// must be not set. Note: if googleOrderId and shipmentTrackingNumber
  /// parameters are provided, the obtained results will include all order
  /// returns that either match the specified order id or the specified tracking
  /// number.
  ///
  /// [maxResults] - The maximum number of order returns to return in the
  /// response, used for paging. The default value is 25 returns per page, and
  /// the maximum allowed value is 250 returns per page.
  ///
  /// [orderBy] - Return the results in the specified order.
  /// Possible string values are:
  /// - "RETURN_CREATION_TIME_DESC" : Return results in descending order.
  /// - "RETURN_CREATION_TIME_ASC" : Return results in ascending order.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [shipmentStates] - Obtains order returns that match any shipment state
  /// provided in this parameter. When this parameter is not provided, order
  /// returns are obtained regardless of their shipment states.
  ///
  /// [shipmentStatus] - Obtains order returns that match any shipment status
  /// provided in this parameter. When this parameter is not provided, order
  /// returns are obtained regardless of their shipment statuses.
  ///
  /// [shipmentTrackingNumbers] - Obtains order returns with the specified
  /// tracking numbers. If this parameter is provided, createdStartDate,
  /// createdEndDate, shipmentType, shipmentStatus, shipmentState and
  /// acknowledged parameters must be not set. Note: if googleOrderId and
  /// shipmentTrackingNumber parameters are provided, the obtained results will
  /// include all order returns that either match the specified order id or the
  /// specified tracking number.
  ///
  /// [shipmentTypes] - Obtains order returns that match any shipment type
  /// provided in this parameter. When this parameter is not provided, order
  /// returns are obtained regardless of their shipment types.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderreturnsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderreturnsListResponse> list(
    core.String merchantId, {
    core.bool? acknowledged,
    core.String? createdEndDate,
    core.String? createdStartDate,
    core.List<core.String>? googleOrderIds,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.List<core.String>? shipmentStates,
    core.List<core.String>? shipmentStatus,
    core.List<core.String>? shipmentTrackingNumbers,
    core.List<core.String>? shipmentTypes,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (acknowledged != null) 'acknowledged': ['${acknowledged}'],
      if (createdEndDate != null) 'createdEndDate': [createdEndDate],
      if (createdStartDate != null) 'createdStartDate': [createdStartDate],
      if (googleOrderIds != null) 'googleOrderIds': googleOrderIds,
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (shipmentStates != null) 'shipmentStates': shipmentStates,
      if (shipmentStatus != null) 'shipmentStatus': shipmentStatus,
      if (shipmentTrackingNumbers != null)
        'shipmentTrackingNumbers': shipmentTrackingNumbers,
      if (shipmentTypes != null) 'shipmentTypes': shipmentTypes,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/orderreturns';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OrderreturnsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Processes return in your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [returnId] - The ID of the return.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderreturnsProcessResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderreturnsProcessResponse> process(
    OrderreturnsProcessRequest request,
    core.String merchantId,
    core.String returnId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orderreturns/' +
        commons.escapeVariable('$returnId') +
        '/process';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrderreturnsProcessResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class OrderreturnsLabelsResource {
  final commons.ApiRequester _requester;

  OrderreturnsLabelsResource(commons.ApiRequester client) : _requester = client;

  /// Links a return shipping label to a return id.
  ///
  /// You can only create one return label per return id. Since the label is
  /// sent to the buyer, the linked return label cannot be updated or deleted.
  /// If you try to create multiple return shipping labels for a single return
  /// id, every create request except the first will fail.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The merchant the Return Shipping Label belongs
  /// to.
  ///
  /// [returnId] - Required. Provide the Google-generated merchant order return
  /// ID.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnShippingLabel].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnShippingLabel> create(
    ReturnShippingLabel request,
    core.String merchantId,
    core.String returnId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orderreturns/' +
        commons.escapeVariable('$returnId') +
        '/labels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ReturnShippingLabel.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class OrdersResource {
  final commons.ApiRequester _requester;

  OrdersResource(commons.ApiRequester client) : _requester = client;

  /// Marks an order as acknowledged.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersAcknowledgeResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersAcknowledgeResponse> acknowledge(
    OrdersAcknowledgeRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/acknowledge';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersAcknowledgeResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sandbox only.
  ///
  /// Moves a test order from state "`inProgress`" to state "`pendingShipment`".
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the test order to modify.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersAdvanceTestOrderResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersAdvanceTestOrderResponse> advancetestorder(
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/testorders/' +
        commons.escapeVariable('$orderId') +
        '/advance';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return OrdersAdvanceTestOrderResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Cancels all line items in an order, making a full refund.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order to cancel.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersCancelResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersCancelResponse> cancel(
    OrdersCancelRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersCancelResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Cancels a line item, making a full refund.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersCancelLineItemResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersCancelLineItemResponse> cancellineitem(
    OrdersCancelLineItemRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/cancelLineItem';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersCancelLineItemResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sandbox only.
  ///
  /// Cancels a test order for customer-initiated cancellation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the test order to cancel.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersCancelTestOrderByCustomerResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersCancelTestOrderByCustomerResponse>
      canceltestorderbycustomer(
    OrdersCancelTestOrderByCustomerRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/testorders/' +
        commons.escapeVariable('$orderId') +
        '/cancelByCustomer';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersCancelTestOrderByCustomerResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Capture funds from the customer for the current order total.
  ///
  /// This method should be called after the merchant verifies that they are
  /// able and ready to start shipping the order. This method blocks until a
  /// response is received from the payment processsor. If this method succeeds,
  /// the merchant is guaranteed to receive funds for the order after shipment.
  /// If the request fails, it can be retried or the order may be cancelled.
  /// This method cannot be called after the entire order is already shipped. A
  /// rejected error code is returned when the payment service provider has
  /// declined the charge. This indicates a problem between the PSP and either
  /// the merchant's or customer's account. Sometimes this error will be
  /// resolved by the customer. We recommend retrying these errors once per day
  /// or cancelling the order with reason `failedToCaptureFunds` if the items
  /// cannot be held.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that manages the order.
  /// This cannot be a multi-client account.
  ///
  /// [orderId] - Required. The ID of the Order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [CaptureOrderResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<CaptureOrderResponse> captureOrder(
    CaptureOrderRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/captureOrder';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return CaptureOrderResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sandbox only.
  ///
  /// Creates a test order.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that should manage the order. This
  /// cannot be a multi-client account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersCreateTestOrderResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersCreateTestOrderResponse> createtestorder(
    OrdersCreateTestOrderRequest request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/testorders';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersCreateTestOrderResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sandbox only.
  ///
  /// Creates a test return.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersCreateTestReturnResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersCreateTestReturnResponse> createtestreturn(
    OrdersCreateTestReturnRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/testreturn';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersCreateTestReturnResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves an order from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Order].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Order> get(
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Order.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves an order using merchant order ID.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [merchantOrderId] - The merchant order ID to be looked for.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersGetByMerchantOrderIdResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersGetByMerchantOrderIdResponse> getbymerchantorderid(
    core.String merchantId,
    core.String merchantOrderId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/ordersbymerchantid/' +
        commons.escapeVariable('$merchantOrderId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OrdersGetByMerchantOrderIdResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sandbox only.
  ///
  /// Retrieves an order template that can be used to quickly create a new order
  /// in sandbox.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that should manage the order. This
  /// cannot be a multi-client account.
  ///
  /// [templateName] - The name of the template to retrieve.
  /// Possible string values are:
  /// - "TEMPLATE1" : Get `template1`.
  /// - "TEMPLATE2" : Get `template2`.
  /// - "TEMPLATE1A" : Get `template1A`.
  /// - "TEMPLATE1B" : Get `template1B`.
  /// - "TEMPLATE3" : Get `template3`.
  /// - "TEMPLATE4" : Get `template4`.
  ///
  /// [country] - The country of the template to retrieve. Defaults to "`US`".
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersGetTestOrderTemplateResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersGetTestOrderTemplateResponse> gettestordertemplate(
    core.String merchantId,
    core.String templateName, {
    core.String? country,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (country != null) 'country': [country],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/testordertemplates/' +
        commons.escapeVariable('$templateName');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OrdersGetTestOrderTemplateResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Notifies that item return and refund was handled directly by merchant
  /// outside of Google payments processing (for example, cash refund done in
  /// store).
  ///
  /// Note: We recommend calling the returnrefundlineitem method to refund
  /// in-store returns. We will issue the refund directly to the customer. This
  /// helps to prevent possible differences arising between merchant and Google
  /// transaction records. We also recommend having the point of sale system
  /// communicate with Google to ensure that customers do not receive a double
  /// refund by first refunding through Google then through an in-store return.
  ///
  /// Deprecated.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersInStoreRefundLineItemResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersInStoreRefundLineItemResponse> instorerefundlineitem(
    OrdersInStoreRefundLineItemRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/inStoreRefundLineItem';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersInStoreRefundLineItemResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the orders in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [acknowledged] - Obtains orders that match the acknowledgement status.
  /// When set to true, obtains orders that have been acknowledged. When false,
  /// obtains orders that have not been acknowledged. We recommend using this
  /// filter set to `false`, in conjunction with the `acknowledge` call, such
  /// that only un-acknowledged orders are returned.
  ///
  /// [maxResults] - The maximum number of orders to return in the response,
  /// used for paging. The default value is 25 orders per page, and the maximum
  /// allowed value is 250 orders per page.
  ///
  /// [orderBy] - Order results by placement date in descending or ascending
  /// order. Acceptable values are: - placedDateAsc - placedDateDesc
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [placedDateEnd] - Obtains orders placed before this date (exclusively), in
  /// ISO 8601 format.
  ///
  /// [placedDateStart] - Obtains orders placed after this date (inclusively),
  /// in ISO 8601 format.
  ///
  /// [statuses] - Obtains orders that match any of the specified statuses. Note
  /// that `active` is a shortcut for `pendingShipment` and `partiallyShipped`,
  /// and `completed` is a shortcut for `shipped`, `partiallyDelivered`,
  /// `delivered`, `partiallyReturned`, `returned`, and `canceled`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersListResponse> list(
    core.String merchantId, {
    core.bool? acknowledged,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.String? placedDateEnd,
    core.String? placedDateStart,
    core.List<core.String>? statuses,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (acknowledged != null) 'acknowledged': ['${acknowledged}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (placedDateEnd != null) 'placedDateEnd': [placedDateEnd],
      if (placedDateStart != null) 'placedDateStart': [placedDateStart],
      if (statuses != null) 'statuses': statuses,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/orders';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OrdersListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Issues a partial or total refund for items and shipment.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order to refund.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersRefundItemResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersRefundItemResponse> refunditem(
    OrdersRefundItemRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/refunditem';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersRefundItemResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Issues a partial or total refund for an order.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order to refund.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersRefundOrderResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersRefundOrderResponse> refundorder(
    OrdersRefundOrderRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/refundorder';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersRefundOrderResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Rejects return on an line item.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersRejectReturnLineItemResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersRejectReturnLineItemResponse> rejectreturnlineitem(
    OrdersRejectReturnLineItemRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/rejectReturnLineItem';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersRejectReturnLineItemResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns and refunds a line item.
  ///
  /// Note that this method can only be called on fully shipped orders. The
  /// Orderreturns API is the preferred way to handle returns after you receive
  /// a return from a customer. You can use Orderreturns.list or
  /// Orderreturns.get to search for the return, and then use
  /// Orderreturns.processreturn to issue the refund. If the return cannot be
  /// found, then we recommend using this API to issue a refund.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersReturnRefundLineItemResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersReturnRefundLineItemResponse> returnrefundlineitem(
    OrdersReturnRefundLineItemRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/returnRefundLineItem';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersReturnRefundLineItemResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets (or overrides if it already exists) merchant provided annotations in
  /// the form of key-value pairs.
  ///
  /// A common use case would be to supply us with additional structured
  /// information about a line item that cannot be provided through other
  /// methods. Submitted key-value pairs can be retrieved as part of the orders
  /// resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersSetLineItemMetadataResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersSetLineItemMetadataResponse> setlineitemmetadata(
    OrdersSetLineItemMetadataRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/setLineItemMetadata';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersSetLineItemMetadataResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Marks line item(s) as shipped.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersShipLineItemsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersShipLineItemsResponse> shiplineitems(
    OrdersShipLineItemsRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/shipLineItems';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersShipLineItemsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates ship by and delivery by dates for a line item.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersUpdateLineItemShippingDetailsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersUpdateLineItemShippingDetailsResponse>
      updatelineitemshippingdetails(
    OrdersUpdateLineItemShippingDetailsRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/updateLineItemShippingDetails';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersUpdateLineItemShippingDetailsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the merchant order ID for a given order.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersUpdateMerchantOrderIdResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersUpdateMerchantOrderIdResponse> updatemerchantorderid(
    OrdersUpdateMerchantOrderIdRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/updateMerchantOrderId';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersUpdateMerchantOrderIdResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a shipment's status, carrier, and/or tracking ID.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that manages the order. This cannot
  /// be a multi-client account.
  ///
  /// [orderId] - The ID of the order.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrdersUpdateShipmentResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrdersUpdateShipmentResponse> updateshipment(
    OrdersUpdateShipmentRequest request,
    core.String merchantId,
    core.String orderId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/orders/' +
        commons.escapeVariable('$orderId') +
        '/updateShipment';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrdersUpdateShipmentResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class OrdertrackingsignalsResource {
  final commons.ApiRequester _requester;

  OrdertrackingsignalsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates new order tracking signal.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the merchant for which the order signal is
  /// created.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OrderTrackingSignal].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OrderTrackingSignal> create(
    OrderTrackingSignal request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        commons.escapeVariable('$merchantId') + '/ordertrackingsignals';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return OrderTrackingSignal.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class PosResource {
  final commons.ApiRequester _requester;

  PosResource(commons.ApiRequester client) : _requester = client;

  /// Batches multiple POS-related calls in a single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PosCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PosCustomBatchResponse> custombatch(
    PosCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'pos/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return PosCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a store for the given merchant.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the POS or inventory data provider.
  ///
  /// [targetMerchantId] - The ID of the target merchant.
  ///
  /// [storeCode] - A store code that is unique per merchant.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String targetMerchantId,
    core.String storeCode, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/pos/' +
        commons.escapeVariable('$targetMerchantId') +
        '/store/' +
        commons.escapeVariable('$storeCode');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves information about the given store.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the POS or inventory data provider.
  ///
  /// [targetMerchantId] - The ID of the target merchant.
  ///
  /// [storeCode] - A store code that is unique per merchant.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PosStore].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PosStore> get(
    core.String merchantId,
    core.String targetMerchantId,
    core.String storeCode, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/pos/' +
        commons.escapeVariable('$targetMerchantId') +
        '/store/' +
        commons.escapeVariable('$storeCode');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return PosStore.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a store for the given merchant.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the POS or inventory data provider.
  ///
  /// [targetMerchantId] - The ID of the target merchant.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PosStore].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PosStore> insert(
    PosStore request,
    core.String merchantId,
    core.String targetMerchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/pos/' +
        commons.escapeVariable('$targetMerchantId') +
        '/store';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return PosStore.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Submit inventory for the given merchant.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the POS or inventory data provider.
  ///
  /// [targetMerchantId] - The ID of the target merchant.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PosInventoryResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PosInventoryResponse> inventory(
    PosInventoryRequest request,
    core.String merchantId,
    core.String targetMerchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/pos/' +
        commons.escapeVariable('$targetMerchantId') +
        '/inventory';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return PosInventoryResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the stores of the target merchant.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the POS or inventory data provider.
  ///
  /// [targetMerchantId] - The ID of the target merchant.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PosListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PosListResponse> list(
    core.String merchantId,
    core.String targetMerchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/pos/' +
        commons.escapeVariable('$targetMerchantId') +
        '/store';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return PosListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Submit a sale event for the given merchant.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the POS or inventory data provider.
  ///
  /// [targetMerchantId] - The ID of the target merchant.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PosSaleResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PosSaleResponse> sale(
    PosSaleRequest request,
    core.String merchantId,
    core.String targetMerchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/pos/' +
        commons.escapeVariable('$targetMerchantId') +
        '/sale';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return PosSaleResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProductdeliverytimeResource {
  final commons.ApiRequester _requester;

  ProductdeliverytimeResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates or updates the delivery time of a product.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Google merchant ID of the account that contains the
  /// product. This account cannot be a multi-client account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ProductDeliveryTime].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ProductDeliveryTime> create(
    ProductDeliveryTime request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/productdeliverytime';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ProductDeliveryTime.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the delivery time of a product.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The Google merchant ID of the account that
  /// contains the product. This account cannot be a multi-client account.
  ///
  /// [productId] - Required. The Content API ID of the product, in the form
  /// `channel:contentLanguage:targetCountry:offerId`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String productId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/productdeliverytime/' +
        commons.escapeVariable('$productId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Gets `productDeliveryTime` by `productId`.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The Google merchant ID of the account that
  /// contains the product. This account cannot be a multi-client account.
  ///
  /// [productId] - Required. The Content API ID of the product, in the form
  /// `channel:contentLanguage:targetCountry:offerId`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ProductDeliveryTime].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ProductDeliveryTime> get(
    core.String merchantId,
    core.String productId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/productdeliverytime/' +
        commons.escapeVariable('$productId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ProductDeliveryTime.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProductsResource {
  final commons.ApiRequester _requester;

  ProductsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves, inserts, and deletes multiple products in a single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ProductsCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ProductsCustomBatchResponse> custombatch(
    ProductsCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'products/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ProductsCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a product from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the product. This
  /// account cannot be a multi-client account.
  ///
  /// [productId] - The REST ID of the product.
  ///
  /// [feedId] - The Content API Supplemental Feed ID. If present then product
  /// deletion applies to the data in a supplemental feed. If absent, entire
  /// product will be deleted.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String productId, {
    core.String? feedId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (feedId != null) 'feedId': [feedId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/products/' +
        commons.escapeVariable('$productId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves a product from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the product. This
  /// account cannot be a multi-client account.
  ///
  /// [productId] - The REST ID of the product.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Product].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Product> get(
    core.String merchantId,
    core.String productId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/products/' +
        commons.escapeVariable('$productId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Product.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Uploads a product to your Merchant Center account.
  ///
  /// If an item with the same channel, contentLanguage, offerId, and
  /// targetCountry already exists, this method updates that entry.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the product. This
  /// account cannot be a multi-client account.
  ///
  /// [feedId] - The Content API Supplemental Feed ID. If present then product
  /// insertion applies to the data in a supplemental feed.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Product].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Product> insert(
    Product request,
    core.String merchantId, {
    core.String? feedId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (feedId != null) 'feedId': [feedId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/products';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Product.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the products in your Merchant Center account.
  ///
  /// The response might contain fewer items than specified by maxResults. Rely
  /// on nextPageToken to determine if there are more items to be requested.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the products. This
  /// account cannot be a multi-client account.
  ///
  /// [maxResults] - The maximum number of products to return in the response,
  /// used for paging. The default value is 25. The maximum value is 250.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ProductsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ProductsListResponse> list(
    core.String merchantId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/products';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ProductsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an existing product in your Merchant Center account.
  ///
  /// Only updates attributes provided in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the product. This
  /// account cannot be a multi-client account.
  ///
  /// [productId] - The REST ID of the product for which to update.
  ///
  /// [updateMask] - The comma-separated list of product attributes to be
  /// updated. Example: `"title,salePrice"`. Attributes specified in the update
  /// mask without a value specified in the body will be deleted from the
  /// product. *You must specify the update mask to delete attributes.* Only
  /// top-level product attributes can be updated. If not defined, product
  /// attributes with set values will be updated and other attributes will stay
  /// unchanged.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Product].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Product> update(
    Product request,
    core.String merchantId,
    core.String productId, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/products/' +
        commons.escapeVariable('$productId');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Product.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProductstatusesResource {
  final commons.ApiRequester _requester;

  ProductstatusesRepricingreportsResource get repricingreports =>
      ProductstatusesRepricingreportsResource(_requester);

  ProductstatusesResource(commons.ApiRequester client) : _requester = client;

  /// Gets the statuses of multiple products in a single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ProductstatusesCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ProductstatusesCustomBatchResponse> custombatch(
    ProductstatusesCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'productstatuses/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ProductstatusesCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the status of a product from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the product. This
  /// account cannot be a multi-client account.
  ///
  /// [productId] - The REST ID of the product.
  ///
  /// [destinations] - If set, only issues for the specified destinations are
  /// returned, otherwise only issues for the Shopping destination.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ProductStatus].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ProductStatus> get(
    core.String merchantId,
    core.String productId, {
    core.List<core.String>? destinations,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (destinations != null) 'destinations': destinations,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/productstatuses/' +
        commons.escapeVariable('$productId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ProductStatus.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the statuses of the products in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the products. This
  /// account cannot be a multi-client account.
  ///
  /// [destinations] - If set, only issues for the specified destinations are
  /// returned, otherwise only issues for the Shopping destination.
  ///
  /// [maxResults] - The maximum number of product statuses to return in the
  /// response, used for paging. The default value is 25. The maximum value is
  /// 250.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ProductstatusesListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ProductstatusesListResponse> list(
    core.String merchantId, {
    core.List<core.String>? destinations,
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (destinations != null) 'destinations': destinations,
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/productstatuses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ProductstatusesListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProductstatusesRepricingreportsResource {
  final commons.ApiRequester _requester;

  ProductstatusesRepricingreportsResource(commons.ApiRequester client)
      : _requester = client;

  /// Lists the metrics report for a given Repricing product.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. Id of the merchant who owns the Repricing rule.
  ///
  /// [productId] - Required. Id of the Repricing product. Also known as the
  /// [REST_ID](https://developers.google.com/shopping-content/reference/rest/v2.1/products#Product.FIELDS.id)
  ///
  /// [endDate] - Gets Repricing reports on and before this date in the
  /// merchant's timezone. You can only retrieve data up to 7 days ago (default)
  /// or earlier. Format is YYYY-MM-DD.
  ///
  /// [pageSize] - Maximum number of days of reports to return. There can be
  /// more than one rule report returned per day. For example, if 3 rule types
  /// got applied to the same product within a 24-hour period, then a page_size
  /// of 1 will return 3 rule reports. The page size defaults to 50 and values
  /// above 1000 are coerced to 1000. This service may return fewer days of
  /// reports than this value, for example, if the time between your start and
  /// end date is less than the page size.
  ///
  /// [pageToken] - Token (if provided) to retrieve the subsequent page. All
  /// other parameters must match the original call that provided the page
  /// token.
  ///
  /// [ruleId] - Id of the Repricing rule. If specified, only gets this rule's
  /// reports.
  ///
  /// [startDate] - Gets Repricing reports on and after this date in the
  /// merchant's timezone, up to one year ago. Do not use a start date later
  /// than 7 days ago (default). Format is YYYY-MM-DD.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListRepricingProductReportsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListRepricingProductReportsResponse> list(
    core.String merchantId,
    core.String productId, {
    core.String? endDate,
    core.int? pageSize,
    core.String? pageToken,
    core.String? ruleId,
    core.String? startDate,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (endDate != null) 'endDate': [endDate],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (ruleId != null) 'ruleId': [ruleId],
      if (startDate != null) 'startDate': [startDate],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/productstatuses/' +
        commons.escapeVariable('$productId') +
        '/repricingreports';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListRepricingProductReportsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class PromotionsResource {
  final commons.ApiRequester _requester;

  PromotionsResource(commons.ApiRequester client) : _requester = client;

  /// Inserts a promotion for your Merchant Center account.
  ///
  /// If the promotion already exists, then it updates the promotion instead. To
  /// [end or delete](https://developers.google.com/shopping-content/guides/promotions#end_a_promotion)
  /// a promotion update the time period of the promotion to a time that has
  /// already passed.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Promotion].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Promotion> create(
    Promotion request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/promotions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Promotion.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a promotion from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection.
  ///
  /// [id] - Required. REST ID of the promotion to retrieve.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Promotion].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Promotion> get(
    core.String merchantId,
    core.String id, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/promotions/' +
        commons.escapeVariable('$id');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Promotion.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// List all promotions from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that contains the
  /// collection.
  ///
  /// [countryCode] -
  /// [CLDR country code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
  /// (for example, "US"), used as a filter on promotions target country.
  ///
  /// [languageCode] - The two-letter ISO 639-1 language code associated with
  /// the promotions, used as a filter.
  ///
  /// [pageSize] - The maximum number of promotions to return. The service may
  /// return fewer than this value. If unspecified, at most 50 labels will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - A page token, received from a previous `ListPromotion` call.
  /// Provide this to retrieve the subsequent page. When paginating, all other
  /// parameters provided to `ListPromotion` must match the call that provided
  /// the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListPromotionResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListPromotionResponse> list(
    core.String merchantId, {
    core.String? countryCode,
    core.String? languageCode,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (countryCode != null) 'countryCode': [countryCode],
      if (languageCode != null) 'languageCode': [languageCode],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/promotions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListPromotionResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class PubsubnotificationsettingsResource {
  final commons.ApiRequester _requester;

  PubsubnotificationsettingsResource(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves a Merchant Center account's pubsub notification settings.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account for which to get pubsub notification
  /// settings.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PubsubNotificationSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PubsubNotificationSettings> get(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        commons.escapeVariable('$merchantId') + '/pubsubnotificationsettings';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return PubsubNotificationSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Register a Merchant Center account for pubsub notifications.
  ///
  /// Note that cloud topic name shouldn't be provided as part of the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PubsubNotificationSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PubsubNotificationSettings> update(
    PubsubNotificationSettings request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        commons.escapeVariable('$merchantId') + '/pubsubnotificationsettings';

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return PubsubNotificationSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class QuotasResource {
  final commons.ApiRequester _requester;

  QuotasResource(commons.ApiRequester client) : _requester = client;

  /// Lists the daily call quota and usage per method for your Merchant Center
  /// account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that has quota. This
  /// account must be an admin.
  ///
  /// [pageSize] - The maximum number of quotas to return in the response, used
  /// for paging. Defaults to 500; values above 1000 will be coerced to 1000.
  ///
  /// [pageToken] - Token (if provided) to retrieve the subsequent page. All
  /// other parameters must match the original call that provided the page
  /// token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListMethodQuotasResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListMethodQuotasResponse> list(
    core.String merchantId, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/quotas';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListMethodQuotasResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class RecommendationsResource {
  final commons.ApiRequester _requester;

  RecommendationsResource(commons.ApiRequester client) : _requester = client;

  /// Generates recommendations for a merchant.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account to fetch recommendations
  /// for.
  ///
  /// [allowedTag] - Optional. List of allowed tags. Tags are a set of
  /// predefined strings that describe the category that individual
  /// recommendation types belong to. User can specify zero or more tags in this
  /// field to indicate what categories of recommendations they want to receive.
  /// Current list of supported tags: - TREND
  ///
  /// [languageCode] - Optional. Language code of the client. If not set, the
  /// result will be in default language (English). This language code affects
  /// all fields prefixed with "localized". This should be set to ISO 639-1
  /// country code. List of currently verified supported language code: en, fr,
  /// cs, da, de, es, it, nl, no, pl, pt, pt, fi, sv, vi, tr, th, ko, zh-CN,
  /// zh-TW, ja, id, hi
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GenerateRecommendationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GenerateRecommendationsResponse> generate(
    core.String merchantId, {
    core.List<core.String>? allowedTag,
    core.String? languageCode,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (allowedTag != null) 'allowedTag': allowedTag,
      if (languageCode != null) 'languageCode': [languageCode],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        commons.escapeVariable('$merchantId') + '/recommendations/generate';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GenerateRecommendationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Reports an interaction on a recommendation for a merchant.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account that wants to report an
  /// interaction.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> reportInteraction(
    ReportInteractionRequest request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/recommendations/reportInteraction';

    await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }
}

class RegionalinventoryResource {
  final commons.ApiRequester _requester;

  RegionalinventoryResource(commons.ApiRequester client) : _requester = client;

  /// Updates regional inventory for multiple products or regions in a single
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionalinventoryCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionalinventoryCustomBatchResponse> custombatch(
    RegionalinventoryCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'regionalinventory/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return RegionalinventoryCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the regional inventory of a product in your Merchant Center
  /// account.
  ///
  /// If a regional inventory with the same region ID already exists, this
  /// method updates that entry.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account that contains the product. This
  /// account cannot be a multi-client account.
  ///
  /// [productId] - The REST ID of the product for which to update the regional
  /// inventory.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RegionalInventory].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RegionalInventory> insert(
    RegionalInventory request,
    core.String merchantId,
    core.String productId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/products/' +
        commons.escapeVariable('$productId') +
        '/regionalinventory';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return RegionalInventory.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class RegionsResource {
  final commons.ApiRequester _requester;

  RegionsResource(commons.ApiRequester client) : _requester = client;

  /// Creates a region definition in your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to create region
  /// definition.
  ///
  /// [regionId] - Required. The id of the region to create.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Region].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Region> create(
    Region request,
    core.String merchantId, {
    core.String? regionId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (regionId != null) 'regionId': [regionId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/regions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Region.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a region definition from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to delete region
  /// definition.
  ///
  /// [regionId] - Required. The id of the region to delete.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String regionId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/regions/' +
        commons.escapeVariable('$regionId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves a region defined in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to retrieve
  /// region definition.
  ///
  /// [regionId] - Required. The id of the region to retrieve.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Region].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Region> get(
    core.String merchantId,
    core.String regionId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/regions/' +
        commons.escapeVariable('$regionId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Region.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the regions in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to list region
  /// definitions.
  ///
  /// [pageSize] - The maximum number of regions to return. The service may
  /// return fewer than this value. If unspecified, at most 50 rules will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - A page token, received from a previous `ListRegions` call.
  /// Provide this to retrieve the subsequent page. When paginating, all other
  /// parameters provided to `ListRegions` must match the call that provided the
  /// page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListRegionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListRegionsResponse> list(
    core.String merchantId, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/regions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListRegionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a region definition in your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to update region
  /// definition.
  ///
  /// [regionId] - Required. The id of the region to update.
  ///
  /// [updateMask] - Optional. The comma-separated field mask indicating the
  /// fields to update. Example: `"displayName,postalCodeArea.regionCode"`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Region].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Region> patch(
    Region request,
    core.String merchantId,
    core.String regionId, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/regions/' +
        commons.escapeVariable('$regionId');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Region.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class ReportsResource {
  final commons.ApiRequester _requester;

  ReportsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves merchant performance mertrics matching the search query and
  /// optionally segmented by selected dimensions.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. Id of the merchant making the call. Must be a
  /// standalone account or an MCA subaccount.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [SearchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<SearchResponse> search(
    SearchRequest request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/reports/search';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return SearchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class RepricingrulesResource {
  final commons.ApiRequester _requester;

  RepricingrulesRepricingreportsResource get repricingreports =>
      RepricingrulesRepricingreportsResource(_requester);

  RepricingrulesResource(commons.ApiRequester client) : _requester = client;

  /// Creates a repricing rule for your Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant who owns the repricing
  /// rule.
  ///
  /// [ruleId] - Required. The id of the rule to create.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RepricingRule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RepricingRule> create(
    RepricingRule request,
    core.String merchantId, {
    core.String? ruleId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (ruleId != null) 'ruleId': [ruleId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/repricingrules';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return RepricingRule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a repricing rule in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant who owns the repricing
  /// rule.
  ///
  /// [ruleId] - Required. The id of the rule to Delete.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String ruleId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/repricingrules/' +
        commons.escapeVariable('$ruleId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves a repricing rule from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant who owns the repricing
  /// rule.
  ///
  /// [ruleId] - Required. The id of the rule to retrieve.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RepricingRule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RepricingRule> get(
    core.String merchantId,
    core.String ruleId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/repricingrules/' +
        commons.escapeVariable('$ruleId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return RepricingRule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the repricing rules in your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant who owns the repricing
  /// rule.
  ///
  /// [countryCode] -
  /// [CLDR country code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
  /// (for example, "US"), used as a filter on repricing rules.
  ///
  /// [languageCode] - The two-letter ISO 639-1 language code associated with
  /// the repricing rule, used as a filter.
  ///
  /// [pageSize] - The maximum number of repricing rules to return. The service
  /// may return fewer than this value. If unspecified, at most 50 rules will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - A page token, received from a previous `ListRepricingRules`
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to `ListRepricingRules` must match the call that
  /// provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListRepricingRulesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListRepricingRulesResponse> list(
    core.String merchantId, {
    core.String? countryCode,
    core.String? languageCode,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (countryCode != null) 'countryCode': [countryCode],
      if (languageCode != null) 'languageCode': [languageCode],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/repricingrules';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListRepricingRulesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a repricing rule in your Merchant Center account.
  ///
  /// All mutable fields will be overwritten in each update request. In each
  /// update, you must provide all required mutable fields, or an error will be
  /// thrown. If you do not provide an optional field in the update request, if
  /// that field currently exists, it will be deleted from the rule.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant who owns the repricing
  /// rule.
  ///
  /// [ruleId] - Required. The id of the rule to update.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [RepricingRule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<RepricingRule> patch(
    RepricingRule request,
    core.String merchantId,
    core.String ruleId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/repricingrules/' +
        commons.escapeVariable('$ruleId');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return RepricingRule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class RepricingrulesRepricingreportsResource {
  final commons.ApiRequester _requester;

  RepricingrulesRepricingreportsResource(commons.ApiRequester client)
      : _requester = client;

  /// *Deprecated*: New merchants can't start using this service.
  ///
  /// Lists the metrics report for a given Repricing rule.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. Id of the merchant who owns the Repricing rule.
  ///
  /// [ruleId] - Required. Id of the Repricing rule.
  ///
  /// [endDate] - Gets Repricing reports on and before this date in the
  /// merchant's timezone. You can only retrieve data up to 7 days ago (default)
  /// or earlier. Format: YYYY-MM-DD.
  ///
  /// [pageSize] - Maximum number of daily reports to return. Each report
  /// includes data from a single 24-hour period. The page size defaults to 50
  /// and values above 1000 are coerced to 1000. This service may return fewer
  /// days than this value, for example, if the time between your start and end
  /// date is less than page size.
  ///
  /// [pageToken] - Token (if provided) to retrieve the subsequent page. All
  /// other parameters must match the original call that provided the page
  /// token.
  ///
  /// [startDate] - Gets Repricing reports on and after this date in the
  /// merchant's timezone, up to one year ago. Do not use a start date later
  /// than 7 days ago (default). Format: YYYY-MM-DD.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListRepricingRuleReportsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListRepricingRuleReportsResponse> list(
    core.String merchantId,
    core.String ruleId, {
    core.String? endDate,
    core.int? pageSize,
    core.String? pageToken,
    core.String? startDate,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (endDate != null) 'endDate': [endDate],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (startDate != null) 'startDate': [startDate],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/repricingrules/' +
        commons.escapeVariable('$ruleId') +
        '/repricingreports';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListRepricingRuleReportsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ReturnaddressResource {
  final commons.ApiRequester _requester;

  ReturnaddressResource(commons.ApiRequester client) : _requester = client;

  /// Batches multiple return address related calls in a single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnaddressCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnaddressCustomBatchResponse> custombatch(
    ReturnaddressCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'returnaddress/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ReturnaddressCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a return address for the given Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account from which to delete the given
  /// return address.
  ///
  /// [returnAddressId] - Return address ID generated by Google.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String returnAddressId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/returnaddress/' +
        commons.escapeVariable('$returnAddressId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Gets a return address of the Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account to get a return address for.
  ///
  /// [returnAddressId] - Return address ID generated by Google.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnAddress].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnAddress> get(
    core.String merchantId,
    core.String returnAddressId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/returnaddress/' +
        commons.escapeVariable('$returnAddressId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ReturnAddress.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Inserts a return address for the Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account to insert a return address for.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnAddress].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnAddress> insert(
    ReturnAddress request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/returnaddress';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ReturnAddress.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the return addresses of the Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account to list return addresses for.
  ///
  /// [country] - List only return addresses applicable to the given country of
  /// sale. When omitted, all return addresses are listed.
  ///
  /// [maxResults] - The maximum number of addresses in the response, used for
  /// paging.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnaddressListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnaddressListResponse> list(
    core.String merchantId, {
    core.String? country,
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (country != null) 'country': [country],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/returnaddress';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ReturnaddressListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ReturnpolicyResource {
  final commons.ApiRequester _requester;

  ReturnpolicyResource(commons.ApiRequester client) : _requester = client;

  /// Batches multiple return policy related calls in a single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnpolicyCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnpolicyCustomBatchResponse> custombatch(
    ReturnpolicyCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'returnpolicy/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ReturnpolicyCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a return policy for the given Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account from which to delete the given
  /// return policy.
  ///
  /// [returnPolicyId] - Return policy ID generated by Google.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String returnPolicyId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/returnpolicy/' +
        commons.escapeVariable('$returnPolicyId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Gets a return policy of the Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account to get a return policy for.
  ///
  /// [returnPolicyId] - Return policy ID generated by Google.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnPolicy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnPolicy> get(
    core.String merchantId,
    core.String returnPolicyId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/returnpolicy/' +
        commons.escapeVariable('$returnPolicyId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ReturnPolicy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Inserts a return policy for the Merchant Center account.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account to insert a return policy for.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnPolicy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnPolicy> insert(
    ReturnPolicy request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/returnpolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ReturnPolicy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the return policies of the Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account to list return policies for.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnpolicyListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnpolicyListResponse> list(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/returnpolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ReturnpolicyListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ReturnpolicyonlineResource {
  final commons.ApiRequester _requester;

  ReturnpolicyonlineResource(commons.ApiRequester client) : _requester = client;

  /// Creates a new return policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to retrieve the
  /// return policy online object.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnPolicyOnline].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnPolicyOnline> create(
    ReturnPolicyOnline request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/returnpolicyonline';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ReturnPolicyOnline.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an existing return policy.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to retrieve the
  /// return policy online object.
  ///
  /// [returnPolicyId] - Required. The id of the return policy to delete.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String merchantId,
    core.String returnPolicyId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/returnpolicyonline/' +
        commons.escapeVariable('$returnPolicyId');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Gets an existing return policy.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to retrieve the
  /// return policy online object.
  ///
  /// [returnPolicyId] - Required. The id of the return policy to retrieve.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnPolicyOnline].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnPolicyOnline> get(
    core.String merchantId,
    core.String returnPolicyId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/returnpolicyonline/' +
        commons.escapeVariable('$returnPolicyId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ReturnPolicyOnline.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists all existing return policies.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to retrieve the
  /// return policy online object.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListReturnPolicyOnlineResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListReturnPolicyOnlineResponse> list(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/returnpolicyonline';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListReturnPolicyOnlineResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an existing return policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The id of the merchant for which to retrieve the
  /// return policy online object.
  ///
  /// [returnPolicyId] - Required. The id of the return policy to update.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ReturnPolicyOnline].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ReturnPolicyOnline> patch(
    ReturnPolicyOnline request,
    core.String merchantId,
    core.String returnPolicyId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/returnpolicyonline/' +
        commons.escapeVariable('$returnPolicyId');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return ReturnPolicyOnline.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class SettlementreportsResource {
  final commons.ApiRequester _requester;

  SettlementreportsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves a settlement report from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account of the settlement report.
  ///
  /// [settlementId] - The Google-provided ID of the settlement.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [SettlementReport].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<SettlementReport> get(
    core.String merchantId,
    core.String settlementId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/settlementreports/' +
        commons.escapeVariable('$settlementId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return SettlementReport.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of settlement reports from your Merchant Center account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account to list settlements for.
  ///
  /// [maxResults] - The maximum number of settlements to return in the
  /// response, used for paging. The default value is 200 returns per page, and
  /// the maximum allowed value is 5000 returns per page.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [transferEndDate] - Obtains settlements which have transactions before
  /// this date (inclusively), in ISO 8601 format.
  ///
  /// [transferStartDate] - Obtains settlements which have transactions after
  /// this date (inclusively), in ISO 8601 format.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [SettlementreportsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<SettlementreportsListResponse> list(
    core.String merchantId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? transferEndDate,
    core.String? transferStartDate,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (transferEndDate != null) 'transferEndDate': [transferEndDate],
      if (transferStartDate != null) 'transferStartDate': [transferStartDate],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/settlementreports';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return SettlementreportsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class SettlementtransactionsResource {
  final commons.ApiRequester _requester;

  SettlementtransactionsResource(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves a list of transactions for the settlement.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The Merchant Center account to list transactions for.
  ///
  /// [settlementId] - The Google-provided ID of the settlement.
  ///
  /// [maxResults] - The maximum number of transactions to return in the
  /// response, used for paging. The default value is 200 transactions per page,
  /// and the maximum allowed value is 5000 transactions per page.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [transactionIds] - The list of transactions to return. If not set, all
  /// transactions will be returned.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [SettlementtransactionsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<SettlementtransactionsListResponse> list(
    core.String merchantId,
    core.String settlementId, {
    core.int? maxResults,
    core.String? pageToken,
    core.List<core.String>? transactionIds,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (transactionIds != null) 'transactionIds': transactionIds,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/settlementreports/' +
        commons.escapeVariable('$settlementId') +
        '/transactions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return SettlementtransactionsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ShippingsettingsResource {
  final commons.ApiRequester _requester;

  ShippingsettingsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves and updates the shipping settings of multiple accounts in a
  /// single request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShippingsettingsCustomBatchResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShippingsettingsCustomBatchResponse> custombatch(
    ShippingsettingsCustomBatchRequest request, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'shippingsettings/batch';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return ShippingsettingsCustomBatchResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the shipping settings of the account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to get/update shipping
  /// settings.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShippingSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShippingSettings> get(
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/shippingsettings/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ShippingSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves supported carriers and carrier services for an account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account for which to retrieve the supported
  /// carriers.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShippingsettingsGetSupportedCarriersResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShippingsettingsGetSupportedCarriersResponse>
      getsupportedcarriers(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/supportedCarriers';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ShippingsettingsGetSupportedCarriersResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves supported holidays for an account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account for which to retrieve the supported
  /// holidays.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShippingsettingsGetSupportedHolidaysResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShippingsettingsGetSupportedHolidaysResponse>
      getsupportedholidays(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/supportedHolidays';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ShippingsettingsGetSupportedHolidaysResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves supported pickup services for an account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the account for which to retrieve the supported
  /// pickup services.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShippingsettingsGetSupportedPickupServicesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShippingsettingsGetSupportedPickupServicesResponse>
      getsupportedpickupservices(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        commons.escapeVariable('$merchantId') + '/supportedPickupServices';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ShippingsettingsGetSupportedPickupServicesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the shipping settings of the sub-accounts in your Merchant Center
  /// account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. This must be a multi-client
  /// account.
  ///
  /// [maxResults] - The maximum number of shipping settings to return in the
  /// response, used for paging.
  ///
  /// [pageToken] - The token returned by the previous request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShippingsettingsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShippingsettingsListResponse> list(
    core.String merchantId, {
    core.int? maxResults,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/shippingsettings';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ShippingsettingsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the shipping settings of the account.
  ///
  /// Any fields that are not provided are deleted from the resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - The ID of the managing account. If this parameter is not
  /// the same as accountId, then this account must be a multi-client account
  /// and `accountId` must be the ID of a sub-account of this account.
  ///
  /// [accountId] - The ID of the account for which to get/update shipping
  /// settings.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShippingSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShippingSettings> update(
    ShippingSettings request,
    core.String merchantId,
    core.String accountId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/shippingsettings/' +
        commons.escapeVariable('$accountId');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return ShippingSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ShoppingadsprogramResource {
  final commons.ApiRequester _requester;

  ShoppingadsprogramResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves the status and review eligibility for the Shopping Ads program.
  ///
  /// Returns errors and warnings if they require action to resolve, will become
  /// disapprovals, or impact impressions. Use `accountstatuses` to view all
  /// issues for an account.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShoppingAdsProgramStatus].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShoppingAdsProgramStatus> get(
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') + '/shoppingadsprogram';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ShoppingAdsProgramStatus.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Requests a review of Shopping ads in a specific region.
  ///
  /// This method deprecated. Use the `MerchantSupportService` to view product
  /// and account issues and request a review.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [merchantId] - Required. The ID of the account.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> requestreview(
    RequestReviewShoppingAdsRequest request,
    core.String merchantId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = commons.escapeVariable('$merchantId') +
        '/shoppingadsprogram/requestreview';

    await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }
}

/// Account data.
///
/// After the creation of a new account it may take a few minutes before it's
/// fully operational. The methods delete, insert, and update require the admin
/// role.
class Account {
  /// How the account is managed.
  ///
  /// Acceptable values are: - "`manual`" - "`automatic`"
  ///
  /// Output only.
  core.String? accountManagement;

  /// Linked Ads accounts that are active or pending approval.
  ///
  /// To create a new link request, add a new link with status `active` to the
  /// list. It will remain in a `pending` state until approved or rejected
  /// either in the Ads interface or through the Google Ads API. To delete an
  /// active link, or to cancel a link request, remove it from the list.
  core.List<AccountAdsLink>? adsLinks;

  /// Indicates whether the merchant sells adult content.
  core.bool? adultContent;

  /// The automatic improvements of the account can be used to automatically
  /// update items, improve images and shipping.
  ///
  /// Each section inside AutomaticImprovements is updated separately.
  AccountAutomaticImprovements? automaticImprovements;

  /// Automatically created label IDs that are assigned to the account by CSS
  /// Center.
  core.List<core.String>? automaticLabelIds;

  /// The business identity attributes can be used to self-declare attributes
  /// that let customers know more about your business.
  AccountBusinessIdentity? businessIdentity;

  /// The business information of the account.
  AccountBusinessInformation? businessInformation;

  /// Settings for conversion tracking.
  AccountConversionSettings? conversionSettings;

  /// ID of CSS the account belongs to.
  core.String? cssId;

  /// The Business Profile which is linked or in the process of being linked
  /// with the Merchant Center account.
  AccountGoogleMyBusinessLink? googleMyBusinessLink;

  /// 64-bit Merchant Center account ID.
  ///
  /// Required.
  core.String? id;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#account`".
  core.String? kind;

  /// Manually created label IDs that are assigned to the account by CSS.
  core.List<core.String>? labelIds;

  /// Display name for the account.
  ///
  /// Required.
  core.String? name;

  /// Client-specific, locally-unique, internal ID for the child account.
  core.String? sellerId;

  /// Users with access to the account.
  ///
  /// Every account (except for subaccounts) must have at least one admin user.
  core.List<AccountUser>? users;

  /// The merchant's website.
  core.String? websiteUrl;

  /// Linked YouTube channels that are active or pending approval.
  ///
  /// To create a new link request, add a new link with status `active` to the
  /// list. It will remain in a `pending` state until approved or rejected in
  /// the YT Creator Studio interface. To delete an active link, or to cancel a
  /// link request, remove it from the list.
  core.List<AccountYouTubeChannelLink>? youtubeChannelLinks;

  Account({
    this.accountManagement,
    this.adsLinks,
    this.adultContent,
    this.automaticImprovements,
    this.automaticLabelIds,
    this.businessIdentity,
    this.businessInformation,
    this.conversionSettings,
    this.cssId,
    this.googleMyBusinessLink,
    this.id,
    this.kind,
    this.labelIds,
    this.name,
    this.sellerId,
    this.users,
    this.websiteUrl,
    this.youtubeChannelLinks,
  });

  Account.fromJson(core.Map json_)
      : this(
          accountManagement: json_.containsKey('accountManagement')
              ? json_['accountManagement'] as core.String
              : null,
          adsLinks: json_.containsKey('adsLinks')
              ? (json_['adsLinks'] as core.List)
                  .map((value) => AccountAdsLink.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          adultContent: json_.containsKey('adultContent')
              ? json_['adultContent'] as core.bool
              : null,
          automaticImprovements: json_.containsKey('automaticImprovements')
              ? AccountAutomaticImprovements.fromJson(
                  json_['automaticImprovements']
                      as core.Map<core.String, core.dynamic>)
              : null,
          automaticLabelIds: json_.containsKey('automaticLabelIds')
              ? (json_['automaticLabelIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          businessIdentity: json_.containsKey('businessIdentity')
              ? AccountBusinessIdentity.fromJson(json_['businessIdentity']
                  as core.Map<core.String, core.dynamic>)
              : null,
          businessInformation: json_.containsKey('businessInformation')
              ? AccountBusinessInformation.fromJson(json_['businessInformation']
                  as core.Map<core.String, core.dynamic>)
              : null,
          conversionSettings: json_.containsKey('conversionSettings')
              ? AccountConversionSettings.fromJson(json_['conversionSettings']
                  as core.Map<core.String, core.dynamic>)
              : null,
          cssId:
              json_.containsKey('cssId') ? json_['cssId'] as core.String : null,
          googleMyBusinessLink: json_.containsKey('googleMyBusinessLink')
              ? AccountGoogleMyBusinessLink.fromJson(
                  json_['googleMyBusinessLink']
                      as core.Map<core.String, core.dynamic>)
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          labelIds: json_.containsKey('labelIds')
              ? (json_['labelIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          sellerId: json_.containsKey('sellerId')
              ? json_['sellerId'] as core.String
              : null,
          users: json_.containsKey('users')
              ? (json_['users'] as core.List)
                  .map((value) => AccountUser.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          websiteUrl: json_.containsKey('websiteUrl')
              ? json_['websiteUrl'] as core.String
              : null,
          youtubeChannelLinks: json_.containsKey('youtubeChannelLinks')
              ? (json_['youtubeChannelLinks'] as core.List)
                  .map((value) => AccountYouTubeChannelLink.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountManagement != null) 'accountManagement': accountManagement!,
        if (adsLinks != null) 'adsLinks': adsLinks!,
        if (adultContent != null) 'adultContent': adultContent!,
        if (automaticImprovements != null)
          'automaticImprovements': automaticImprovements!,
        if (automaticLabelIds != null) 'automaticLabelIds': automaticLabelIds!,
        if (businessIdentity != null) 'businessIdentity': businessIdentity!,
        if (businessInformation != null)
          'businessInformation': businessInformation!,
        if (conversionSettings != null)
          'conversionSettings': conversionSettings!,
        if (cssId != null) 'cssId': cssId!,
        if (googleMyBusinessLink != null)
          'googleMyBusinessLink': googleMyBusinessLink!,
        if (id != null) 'id': id!,
        if (kind != null) 'kind': kind!,
        if (labelIds != null) 'labelIds': labelIds!,
        if (name != null) 'name': name!,
        if (sellerId != null) 'sellerId': sellerId!,
        if (users != null) 'users': users!,
        if (websiteUrl != null) 'websiteUrl': websiteUrl!,
        if (youtubeChannelLinks != null)
          'youtubeChannelLinks': youtubeChannelLinks!,
      };
}

class AccountAddress {
  /// CLDR country code (for example, "US").
  ///
  /// All MCA sub-accounts inherit the country of their parent MCA by default,
  /// however the country can be updated for individual sub-accounts.
  core.String? country;

  /// City, town or commune.
  ///
  /// May also include dependent localities or sublocalities (for example,
  /// neighborhoods or suburbs).
  core.String? locality;

  /// Postal code or ZIP (for example, "94043").
  core.String? postalCode;

  /// Top-level administrative subdivision of the country.
  ///
  /// For example, a state like California ("CA") or a province like Quebec
  /// ("QC").
  core.String? region;

  /// Street-level part of the address.
  ///
  /// Use `\n` to add a second line.
  core.String? streetAddress;

  AccountAddress({
    this.country,
    this.locality,
    this.postalCode,
    this.region,
    this.streetAddress,
  });

  AccountAddress.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          locality: json_.containsKey('locality')
              ? json_['locality'] as core.String
              : null,
          postalCode: json_.containsKey('postalCode')
              ? json_['postalCode'] as core.String
              : null,
          region: json_.containsKey('region')
              ? json_['region'] as core.String
              : null,
          streetAddress: json_.containsKey('streetAddress')
              ? json_['streetAddress'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (locality != null) 'locality': locality!,
        if (postalCode != null) 'postalCode': postalCode!,
        if (region != null) 'region': region!,
        if (streetAddress != null) 'streetAddress': streetAddress!,
      };
}

class AccountAdsLink {
  /// Customer ID of the Ads account.
  core.String? adsId;

  /// Status of the link between this Merchant Center account and the Ads
  /// account.
  ///
  /// Upon retrieval, it represents the actual status of the link and can be
  /// either `active` if it was approved in Google Ads or `pending` if it's
  /// pending approval. Upon insertion, it represents the *intended* status of
  /// the link. Re-uploading a link with status `active` when it's still pending
  /// or with status `pending` when it's already active will have no effect: the
  /// status will remain unchanged. Re-uploading a link with deprecated status
  /// `inactive` is equivalent to not submitting the link at all and will delete
  /// the link if it was active or cancel the link request if it was pending.
  /// Acceptable values are: - "`active`" - "`pending`"
  core.String? status;

  AccountAdsLink({
    this.adsId,
    this.status,
  });

  AccountAdsLink.fromJson(core.Map json_)
      : this(
          adsId:
              json_.containsKey('adsId') ? json_['adsId'] as core.String : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (adsId != null) 'adsId': adsId!,
        if (status != null) 'status': status!,
      };
}

/// The automatic improvements of the account can be used to automatically
/// update items, improve images and shipping.
class AccountAutomaticImprovements {
  /// This improvement will attempt to automatically correct submitted images if
  /// they don't meet the
  /// [image requirements](https://support.google.com/merchants/answer/6324350),
  /// for example, removing overlays.
  ///
  /// If successful, the image will be replaced and approved. This improvement
  /// is only applied to images of disapproved offers. For more information see:
  /// [Automatic image improvements](https://support.google.com/merchants/answer/9242973)
  /// This field is only updated (cleared) if provided.
  AccountImageImprovements? imageImprovements;

  /// Turning on
  /// [item updates](https://support.google.com/merchants/answer/3246284) allows
  /// Google to automatically update items for you.
  ///
  /// When item updates are on, Google uses the structured data markup on the
  /// website and advanced data extractors to update the price and availability
  /// of the items. When the item updates are off, items with mismatched data
  /// aren't shown. This field is only updated (cleared) if provided.
  AccountItemUpdates? itemUpdates;

  /// Not available for MCAs
  /// [accounts](https://support.google.com/merchants/answer/188487).
  ///
  /// By turning on
  /// [automatic shipping improvements](https://support.google.com/merchants/answer/10027038),
  /// you are allowing Google to improve the accuracy of your delivery times
  /// shown to shoppers using Google. More accurate delivery times, especially
  /// when faster, typically lead to better conversion rates. Google will
  /// improve your estimated delivery times based on various factors: - Delivery
  /// address of an order - Current handling time and shipping time settings -
  /// Estimated weekdays or business days - Parcel tracking data This field is
  /// only updated (cleared) if provided.
  AccountShippingImprovements? shippingImprovements;

  AccountAutomaticImprovements({
    this.imageImprovements,
    this.itemUpdates,
    this.shippingImprovements,
  });

  AccountAutomaticImprovements.fromJson(core.Map json_)
      : this(
          imageImprovements: json_.containsKey('imageImprovements')
              ? AccountImageImprovements.fromJson(json_['imageImprovements']
                  as core.Map<core.String, core.dynamic>)
              : null,
          itemUpdates: json_.containsKey('itemUpdates')
              ? AccountItemUpdates.fromJson(
                  json_['itemUpdates'] as core.Map<core.String, core.dynamic>)
              : null,
          shippingImprovements: json_.containsKey('shippingImprovements')
              ? AccountShippingImprovements.fromJson(
                  json_['shippingImprovements']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (imageImprovements != null) 'imageImprovements': imageImprovements!,
        if (itemUpdates != null) 'itemUpdates': itemUpdates!,
        if (shippingImprovements != null)
          'shippingImprovements': shippingImprovements!,
      };
}

/// The
/// [business identity attributes](https://support.google.com/merchants/answer/10342414)
/// can be used to self-declare attributes that let customers know more about
/// your business.
class AccountBusinessIdentity {
  /// Specifies whether the business identifies itself as being black-owned.
  ///
  /// This optional field is only available for merchants with a business
  /// country set to "US". This field is not allowed for marketplaces or
  /// marketplace sellers.
  AccountIdentityType? blackOwned;

  /// By setting this field, your business may be included in promotions for all
  /// the selected attributes.
  ///
  /// If you clear this option, it won't affect your identification with any of
  /// the attributes. For this field to be set, the merchant must self identify
  /// with at least one of the `AccountIdentityType`. If none are included, the
  /// request will be considered invalid.
  ///
  /// Required.
  core.bool? includeForPromotions;

  /// Specifies whether the business identifies itself as being latino-owned.
  ///
  /// This optional field is only available for merchants with a business
  /// country set to "US". This field is not allowed for marketplaces or
  /// marketplace sellers.
  AccountIdentityType? latinoOwned;

  /// Specifies whether the business identifies itself as a small business.
  ///
  /// This optional field is only available for merchants with a business
  /// country set to "US". It is also not allowed for marketplaces, but it is
  /// allowed to marketplace sellers.
  AccountIdentityType? smallBusiness;

  /// Specifies whether the business identifies itself as being veteran-owned.
  ///
  /// This optional field is only available for merchants with a business
  /// country set to "US". This field is not allowed for marketplaces or
  /// marketplace sellers.
  AccountIdentityType? veteranOwned;

  /// Specifies whether the business identifies itself as being women-owned.
  ///
  /// This optional field is only available for merchants with a business
  /// country set to "US". This field is not allowed for marketplaces or
  /// marketplace sellers.
  AccountIdentityType? womenOwned;

  AccountBusinessIdentity({
    this.blackOwned,
    this.includeForPromotions,
    this.latinoOwned,
    this.smallBusiness,
    this.veteranOwned,
    this.womenOwned,
  });

  AccountBusinessIdentity.fromJson(core.Map json_)
      : this(
          blackOwned: json_.containsKey('blackOwned')
              ? AccountIdentityType.fromJson(
                  json_['blackOwned'] as core.Map<core.String, core.dynamic>)
              : null,
          includeForPromotions: json_.containsKey('includeForPromotions')
              ? json_['includeForPromotions'] as core.bool
              : null,
          latinoOwned: json_.containsKey('latinoOwned')
              ? AccountIdentityType.fromJson(
                  json_['latinoOwned'] as core.Map<core.String, core.dynamic>)
              : null,
          smallBusiness: json_.containsKey('smallBusiness')
              ? AccountIdentityType.fromJson(
                  json_['smallBusiness'] as core.Map<core.String, core.dynamic>)
              : null,
          veteranOwned: json_.containsKey('veteranOwned')
              ? AccountIdentityType.fromJson(
                  json_['veteranOwned'] as core.Map<core.String, core.dynamic>)
              : null,
          womenOwned: json_.containsKey('womenOwned')
              ? AccountIdentityType.fromJson(
                  json_['womenOwned'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (blackOwned != null) 'blackOwned': blackOwned!,
        if (includeForPromotions != null)
          'includeForPromotions': includeForPromotions!,
        if (latinoOwned != null) 'latinoOwned': latinoOwned!,
        if (smallBusiness != null) 'smallBusiness': smallBusiness!,
        if (veteranOwned != null) 'veteranOwned': veteranOwned!,
        if (womenOwned != null) 'womenOwned': womenOwned!,
      };
}

class AccountBusinessInformation {
  /// The address of the business.
  ///
  /// Use `\n` to add a second address line.
  AccountAddress? address;

  /// The customer service information of the business.
  AccountCustomerService? customerService;

  /// The 10-digit
  /// [Korean business registration number](https://support.google.com/merchants/answer/9037766)
  /// separated with dashes in the format: XXX-XX-XXXXX.
  ///
  /// This field will only be updated if explicitly set.
  core.String? koreanBusinessRegistrationNumber;

  /// The phone number of the business in
  /// [E.164](https://en.wikipedia.org/wiki/E.164) format.
  ///
  /// This can only be updated if a verified phone number is not already set. To
  /// replace a verified phone number use the
  /// `Accounts.requestphoneverification` and `Accounts.verifyphonenumber`.
  core.String? phoneNumber;

  /// Verification status of the phone number of the business.
  ///
  /// This status is read only and can be updated only by successful phone
  /// verification. Acceptable values are: - "`verified`" - "`unverified`"
  core.String? phoneVerificationStatus;

  AccountBusinessInformation({
    this.address,
    this.customerService,
    this.koreanBusinessRegistrationNumber,
    this.phoneNumber,
    this.phoneVerificationStatus,
  });

  AccountBusinessInformation.fromJson(core.Map json_)
      : this(
          address: json_.containsKey('address')
              ? AccountAddress.fromJson(
                  json_['address'] as core.Map<core.String, core.dynamic>)
              : null,
          customerService: json_.containsKey('customerService')
              ? AccountCustomerService.fromJson(json_['customerService']
                  as core.Map<core.String, core.dynamic>)
              : null,
          koreanBusinessRegistrationNumber:
              json_.containsKey('koreanBusinessRegistrationNumber')
                  ? json_['koreanBusinessRegistrationNumber'] as core.String
                  : null,
          phoneNumber: json_.containsKey('phoneNumber')
              ? json_['phoneNumber'] as core.String
              : null,
          phoneVerificationStatus: json_.containsKey('phoneVerificationStatus')
              ? json_['phoneVerificationStatus'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (address != null) 'address': address!,
        if (customerService != null) 'customerService': customerService!,
        if (koreanBusinessRegistrationNumber != null)
          'koreanBusinessRegistrationNumber': koreanBusinessRegistrationNumber!,
        if (phoneNumber != null) 'phoneNumber': phoneNumber!,
        if (phoneVerificationStatus != null)
          'phoneVerificationStatus': phoneVerificationStatus!,
      };
}

/// Settings for conversion tracking.
class AccountConversionSettings {
  /// When enabled, free listing URLs have a parameter to enable conversion
  /// tracking for products owned by the current merchant account.
  ///
  /// See
  /// \[auto-tagging\](https://support.google.com/merchants/answer/11127659).
  core.bool? freeListingsAutoTaggingEnabled;

  AccountConversionSettings({
    this.freeListingsAutoTaggingEnabled,
  });

  AccountConversionSettings.fromJson(core.Map json_)
      : this(
          freeListingsAutoTaggingEnabled:
              json_.containsKey('freeListingsAutoTaggingEnabled')
                  ? json_['freeListingsAutoTaggingEnabled'] as core.bool
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (freeListingsAutoTaggingEnabled != null)
          'freeListingsAutoTaggingEnabled': freeListingsAutoTaggingEnabled!,
      };
}

/// Credentials allowing Google to call a partner's API on behalf of a merchant.
class AccountCredentials {
  /// An OAuth access token.
  core.String? accessToken;

  /// The amount of time, in seconds, after which the access token is no longer
  /// valid.
  core.String? expiresIn;

  /// Indicates to Google how Google should use these OAuth tokens.
  /// Possible string values are:
  /// - "ACCOUNT_CREDENTIALS_PURPOSE_UNSPECIFIED" : Unknown purpose.
  /// - "SHOPIFY_ORDER_MANAGEMENT" : The credentials allow Google to manage
  /// Shopify orders on behalf of the merchant (deprecated).
  /// - "SHOPIFY_INTEGRATION" : The credentials allow Google to manage Shopify
  /// integration on behalf of the merchant.
  core.String? purpose;

  AccountCredentials({
    this.accessToken,
    this.expiresIn,
    this.purpose,
  });

  AccountCredentials.fromJson(core.Map json_)
      : this(
          accessToken: json_.containsKey('accessToken')
              ? json_['accessToken'] as core.String
              : null,
          expiresIn: json_.containsKey('expiresIn')
              ? json_['expiresIn'] as core.String
              : null,
          purpose: json_.containsKey('purpose')
              ? json_['purpose'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accessToken != null) 'accessToken': accessToken!,
        if (expiresIn != null) 'expiresIn': expiresIn!,
        if (purpose != null) 'purpose': purpose!,
      };
}

class AccountCustomerService {
  /// Customer service email.
  core.String? email;

  /// Customer service phone number.
  core.String? phoneNumber;

  /// Customer service URL.
  core.String? url;

  AccountCustomerService({
    this.email,
    this.phoneNumber,
    this.url,
  });

  AccountCustomerService.fromJson(core.Map json_)
      : this(
          email:
              json_.containsKey('email') ? json_['email'] as core.String : null,
          phoneNumber: json_.containsKey('phoneNumber')
              ? json_['phoneNumber'] as core.String
              : null,
          url: json_.containsKey('url') ? json_['url'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (email != null) 'email': email!,
        if (phoneNumber != null) 'phoneNumber': phoneNumber!,
        if (url != null) 'url': url!,
      };
}

class AccountGoogleMyBusinessLink {
  /// The ID of the Business Profile.
  ///
  /// If this is provided, then `gmbEmail` is ignored. The value of this field
  /// should match the `accountId` used by the Business Profile API.
  core.String? gmbAccountId;

  /// The Business Profile email address of a specific account within a Business
  /// Profile.
  ///
  /// A sample account within a Business Profile could be a business account
  /// with set of locations, managed under the Business Profile.
  core.String? gmbEmail;

  /// Status of the link between this Merchant Center account and the Business
  /// Profile.
  ///
  /// Acceptable values are: - "`active`" - "`pending`"
  core.String? status;

  AccountGoogleMyBusinessLink({
    this.gmbAccountId,
    this.gmbEmail,
    this.status,
  });

  AccountGoogleMyBusinessLink.fromJson(core.Map json_)
      : this(
          gmbAccountId: json_.containsKey('gmbAccountId')
              ? json_['gmbAccountId'] as core.String
              : null,
          gmbEmail: json_.containsKey('gmbEmail')
              ? json_['gmbEmail'] as core.String
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (gmbAccountId != null) 'gmbAccountId': gmbAccountId!,
        if (gmbEmail != null) 'gmbEmail': gmbEmail!,
        if (status != null) 'status': status!,
      };
}

class AccountIdentifier {
  /// The aggregator ID, set for aggregators and subaccounts (in that case, it
  /// represents the aggregator of the subaccount).
  core.String? aggregatorId;

  /// The merchant account ID, set for individual accounts and subaccounts.
  core.String? merchantId;

  AccountIdentifier({
    this.aggregatorId,
    this.merchantId,
  });

  AccountIdentifier.fromJson(core.Map json_)
      : this(
          aggregatorId: json_.containsKey('aggregatorId')
              ? json_['aggregatorId'] as core.String
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aggregatorId != null) 'aggregatorId': aggregatorId!,
        if (merchantId != null) 'merchantId': merchantId!,
      };
}

/// The account identity type used to specify attributes.
class AccountIdentityType {
  /// Indicates that the business identifies itself with a given identity type.
  ///
  /// Setting this field does not automatically mean eligibility for promotions.
  ///
  /// Optional.
  core.bool? selfIdentified;

  AccountIdentityType({
    this.selfIdentified,
  });

  AccountIdentityType.fromJson(core.Map json_)
      : this(
          selfIdentified: json_.containsKey('selfIdentified')
              ? json_['selfIdentified'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (selfIdentified != null) 'selfIdentified': selfIdentified!,
      };
}

/// This improvement will attempt to automatically correct submitted images if
/// they don't meet the
/// [image requirements](https://support.google.com/merchants/answer/6324350),
/// for example, removing overlays.
///
/// If successful, the image will be replaced and approved. This improvement is
/// only applied to images of disapproved offers. For more information see:
/// [Automatic image improvements](https://support.google.com/merchants/answer/9242973)
class AccountImageImprovements {
  /// Determines how the images should be automatically updated.
  ///
  /// If this field is not present, then the settings will be deleted. If there
  /// are no settings for subaccount, they are inherited from aggregator.
  AccountImageImprovementsSettings? accountImageImprovementsSettings;

  /// The effective value of allow_automatic_image_improvements.
  ///
  /// If account_image_improvements_settings is present, then this value is the
  /// same. Otherwise, it represents the inherited value of the parent account.
  /// Read-only.
  ///
  /// Output only.
  core.bool? effectiveAllowAutomaticImageImprovements;

  AccountImageImprovements({
    this.accountImageImprovementsSettings,
    this.effectiveAllowAutomaticImageImprovements,
  });

  AccountImageImprovements.fromJson(core.Map json_)
      : this(
          accountImageImprovementsSettings:
              json_.containsKey('accountImageImprovementsSettings')
                  ? AccountImageImprovementsSettings.fromJson(
                      json_['accountImageImprovementsSettings']
                          as core.Map<core.String, core.dynamic>)
                  : null,
          effectiveAllowAutomaticImageImprovements: json_
                  .containsKey('effectiveAllowAutomaticImageImprovements')
              ? json_['effectiveAllowAutomaticImageImprovements'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountImageImprovementsSettings != null)
          'accountImageImprovementsSettings': accountImageImprovementsSettings!,
        if (effectiveAllowAutomaticImageImprovements != null)
          'effectiveAllowAutomaticImageImprovements':
              effectiveAllowAutomaticImageImprovements!,
      };
}

/// Settings for the Automatic Image Improvements.
class AccountImageImprovementsSettings {
  /// Enables automatic image improvements.
  core.bool? allowAutomaticImageImprovements;

  AccountImageImprovementsSettings({
    this.allowAutomaticImageImprovements,
  });

  AccountImageImprovementsSettings.fromJson(core.Map json_)
      : this(
          allowAutomaticImageImprovements:
              json_.containsKey('allowAutomaticImageImprovements')
                  ? json_['allowAutomaticImageImprovements'] as core.bool
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (allowAutomaticImageImprovements != null)
          'allowAutomaticImageImprovements': allowAutomaticImageImprovements!,
      };
}

/// An issue affecting specific merchant.
class AccountIssue {
  /// A list of actionable steps that can be executed to solve the issue.
  ///
  /// An example is requesting a re-review or providing arguments when merchant
  /// disagrees with the issue. Actions that are supported in (your) third-party
  /// application can be rendered as buttons and should be available to merchant
  /// when they expand the issue.
  core.List<Action>? actions;

  /// Clarifies the severity of the issue.
  ///
  /// The summarizing message, if present, should be shown right under the title
  /// for each issue. It helps merchants to quickly understand the impact of the
  /// issue. The detailed breakdown helps the merchant to fully understand the
  /// impact of the issue. It can be rendered as dialog that opens when the
  /// merchant mouse over the summarized impact statement. Issues with different
  /// severity can be styled differently. They may use a different color or icon
  /// to signal the difference between `ERROR`, `WARNING` and `INFO`.
  AccountIssueImpact? impact;

  /// Details of the issue as a pre-rendered HTML.
  ///
  /// HTML elements contain CSS classes that can be used to customize the style
  /// of the content. Always sanitize the HTML before embedding it directly to
  /// your application. The sanitizer needs to allow basic HTML tags, such as:
  /// `div`, `span`, `p`, `a`, `ul`, `li`, `table`, `tr`, `td`. For example, you
  /// can use [DOMPurify](https://www.npmjs.com/package/dompurify). CSS classes:
  /// * `issue-detail` - top level container for the detail of the issue *
  /// `callout-banners` - section of the `issue-detail` with callout banners *
  /// `callout-banner` - single callout banner, inside `callout-banners` *
  /// `callout-banner-info` - callout with important information (default) *
  /// `callout-banner-warning` - callout with a warning * `callout-banner-error`
  /// - callout informing about an error (most severe) * `issue-content` -
  /// section of the `issue-detail`, contains multiple `content-element` *
  /// `content-element` - content element such as a list, link or paragraph,
  /// inside `issue-content` * `root-causes` - unordered list with items
  /// describing root causes of the issue, inside `issue-content` *
  /// `root-causes-intro` - intro text before the `root-causes` list, inside
  /// `issue-content` * `segment` - section of the text, `span` inside paragraph
  /// * `segment-attribute` - section of the text that represents a product
  /// attribute, for example 'image\_link' * `segment-literal` - section of the
  /// text that contains a special value, for example '0-1000 kg' *
  /// `segment-bold` - section of the text that should be rendered as bold *
  /// `segment-italic` - section of the text that should be rendered as italic *
  /// `tooltip` - used on paragraphs that should be rendered with a tooltip. A
  /// section of the text in such a paragraph will have a class `tooltip-text`
  /// and is intended to be shown in a mouse over dialog. If the style is not
  /// used, the `tooltip-text` section would be shown on a new line, after the
  /// main part of the text. * `tooltip-text` - marks a section of the text
  /// within a `tooltip`, that is intended to be shown in a mouse over dialog. *
  /// `tooltip-icon` - marks a section of the text within a `tooltip`, that can
  /// be replaced with a tooltip icon, for example '?' or 'i'. By default, this
  /// section contains a `br` tag, that is separating the main text and the
  /// tooltip text when the style is not used. * `tooltip-style-question` - the
  /// tooltip shows helpful information, can use the '?' as an icon. *
  /// `tooltip-style-info` - the tooltip adds additional information fitting to
  /// the context, can use the 'i' as an icon. * `content-moderation` - marks
  /// the paragraph that explains how the issue was identified. * `new-element`
  /// - Present for new elements added to the pre-rendered content in the
  /// future. To make sure that a new content element does not break your style,
  /// you can hide everything with this class.
  core.String? prerenderedContent;

  /// Title of the issue.
  core.String? title;

  AccountIssue({
    this.actions,
    this.impact,
    this.prerenderedContent,
    this.title,
  });

  AccountIssue.fromJson(core.Map json_)
      : this(
          actions: json_.containsKey('actions')
              ? (json_['actions'] as core.List)
                  .map((value) => Action.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          impact: json_.containsKey('impact')
              ? AccountIssueImpact.fromJson(
                  json_['impact'] as core.Map<core.String, core.dynamic>)
              : null,
          prerenderedContent: json_.containsKey('prerenderedContent')
              ? json_['prerenderedContent'] as core.String
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (actions != null) 'actions': actions!,
        if (impact != null) 'impact': impact!,
        if (prerenderedContent != null)
          'prerenderedContent': prerenderedContent!,
        if (title != null) 'title': title!,
      };
}

/// Overall impact of the issue.
class AccountIssueImpact {
  /// Detailed impact breakdown.
  ///
  /// Explains the types of restriction the issue has in different shopping
  /// destinations and territory. If present, it should be rendered to the
  /// merchant. Can be shown as a mouse over dropdown or a dialog. Each
  /// breakdown item represents a group of regions with the same impact details.
  core.List<Breakdown>? breakdowns;

  /// Message summarizing the overall impact of the issue.
  ///
  /// If present, it should be rendered to the merchant. For example:
  /// "Disapproves 90k offers in 25 countries"
  ///
  /// Optional.
  core.String? message;

  /// The severity of the issue.
  /// Possible string values are:
  /// - "SEVERITY_UNSPECIFIED" : Default value. Will never be provided by the
  /// API.
  /// - "ERROR" : Causes either an account suspension or an item disapproval.
  /// Errors should be resolved as soon as possible to ensure items are eligible
  /// to appear in results again.
  /// - "WARNING" : Warnings can negatively impact the performance of ads and
  /// can lead to item or account suspensions in the future unless the issue is
  /// resolved.
  /// - "INFO" : Infos are suggested optimizations to increase data quality.
  /// Resolving these issues is recommended, but not required.
  core.String? severity;

  AccountIssueImpact({
    this.breakdowns,
    this.message,
    this.severity,
  });

  AccountIssueImpact.fromJson(core.Map json_)
      : this(
          breakdowns: json_.containsKey('breakdowns')
              ? (json_['breakdowns'] as core.List)
                  .map((value) => Breakdown.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          message: json_.containsKey('message')
              ? json_['message'] as core.String
              : null,
          severity: json_.containsKey('severity')
              ? json_['severity'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (breakdowns != null) 'breakdowns': breakdowns!,
        if (message != null) 'message': message!,
        if (severity != null) 'severity': severity!,
      };
}

/// Turning on
/// [item updates](https://support.google.com/merchants/answer/3246284) allows
/// Google to automatically update items for you.
///
/// When item updates are on, Google uses the structured data markup on the
/// website and advanced data extractors to update the price and availability of
/// the items. When the item updates are off, items with mismatched data aren't
/// shown.
class AccountItemUpdates {
  /// Determines which attributes of the items should be automatically updated.
  ///
  /// If this field is not present, then the settings will be deleted. If there
  /// are no settings for subaccount, they are inherited from aggregator.
  AccountItemUpdatesSettings? accountItemUpdatesSettings;

  /// The effective value of allow_availability_updates.
  ///
  /// If account_item_updates_settings is present, then this value is the same.
  /// Otherwise, it represents the inherited value of the parent account.
  /// Read-only.
  ///
  /// Output only.
  core.bool? effectiveAllowAvailabilityUpdates;

  /// The effective value of allow_condition_updates.
  ///
  /// If account_item_updates_settings is present, then this value is the same.
  /// Otherwise, it represents the inherited value of the parent account.
  /// Read-only.
  ///
  /// Output only.
  core.bool? effectiveAllowConditionUpdates;

  /// The effective value of allow_price_updates.
  ///
  /// If account_item_updates_settings is present, then this value is the same.
  /// Otherwise, it represents the inherited value of the parent account.
  /// Read-only.
  ///
  /// Output only.
  core.bool? effectiveAllowPriceUpdates;

  /// The effective value of allow_strict_availability_updates.
  ///
  /// If account_item_updates_settings is present, then this value is the same.
  /// Otherwise, it represents the inherited value of the parent account.
  /// Read-only.
  ///
  /// Output only.
  core.bool? effectiveAllowStrictAvailabilityUpdates;

  AccountItemUpdates({
    this.accountItemUpdatesSettings,
    this.effectiveAllowAvailabilityUpdates,
    this.effectiveAllowConditionUpdates,
    this.effectiveAllowPriceUpdates,
    this.effectiveAllowStrictAvailabilityUpdates,
  });

  AccountItemUpdates.fromJson(core.Map json_)
      : this(
          accountItemUpdatesSettings:
              json_.containsKey('accountItemUpdatesSettings')
                  ? AccountItemUpdatesSettings.fromJson(
                      json_['accountItemUpdatesSettings']
                          as core.Map<core.String, core.dynamic>)
                  : null,
          effectiveAllowAvailabilityUpdates:
              json_.containsKey('effectiveAllowAvailabilityUpdates')
                  ? json_['effectiveAllowAvailabilityUpdates'] as core.bool
                  : null,
          effectiveAllowConditionUpdates:
              json_.containsKey('effectiveAllowConditionUpdates')
                  ? json_['effectiveAllowConditionUpdates'] as core.bool
                  : null,
          effectiveAllowPriceUpdates:
              json_.containsKey('effectiveAllowPriceUpdates')
                  ? json_['effectiveAllowPriceUpdates'] as core.bool
                  : null,
          effectiveAllowStrictAvailabilityUpdates: json_
                  .containsKey('effectiveAllowStrictAvailabilityUpdates')
              ? json_['effectiveAllowStrictAvailabilityUpdates'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountItemUpdatesSettings != null)
          'accountItemUpdatesSettings': accountItemUpdatesSettings!,
        if (effectiveAllowAvailabilityUpdates != null)
          'effectiveAllowAvailabilityUpdates':
              effectiveAllowAvailabilityUpdates!,
        if (effectiveAllowConditionUpdates != null)
          'effectiveAllowConditionUpdates': effectiveAllowConditionUpdates!,
        if (effectiveAllowPriceUpdates != null)
          'effectiveAllowPriceUpdates': effectiveAllowPriceUpdates!,
        if (effectiveAllowStrictAvailabilityUpdates != null)
          'effectiveAllowStrictAvailabilityUpdates':
              effectiveAllowStrictAvailabilityUpdates!,
      };
}

/// Settings for the Automatic Item Updates.
class AccountItemUpdatesSettings {
  /// If availability updates are enabled, any previous availability values get
  /// overwritten if Google finds an out-of-stock annotation on the offer's
  /// page.
  ///
  /// If additionally `allow_availability_updates` field is set to true, values
  /// get overwritten if Google finds an in-stock annotation on the offer’s
  /// page.
  core.bool? allowAvailabilityUpdates;

  /// If condition updates are enabled, Google always updates item condition
  /// with the condition detected from the details of your product.
  core.bool? allowConditionUpdates;

  /// If price updates are enabled, Google always updates the active price with
  /// the crawled information.
  core.bool? allowPriceUpdates;

  /// If allow_availability_updates is enabled, items are automatically updated
  /// in all your Shopping target countries.
  ///
  /// By default, availability updates will only be applied to items that are
  /// 'out of stock' on your website but 'in stock' on Shopping. Set this to
  /// true to also update items that are 'in stock' on your website, but 'out of
  /// stock' on Google Shopping. In order for this field to have an effect, you
  /// must also allow availability updates.
  core.bool? allowStrictAvailabilityUpdates;

  AccountItemUpdatesSettings({
    this.allowAvailabilityUpdates,
    this.allowConditionUpdates,
    this.allowPriceUpdates,
    this.allowStrictAvailabilityUpdates,
  });

  AccountItemUpdatesSettings.fromJson(core.Map json_)
      : this(
          allowAvailabilityUpdates:
              json_.containsKey('allowAvailabilityUpdates')
                  ? json_['allowAvailabilityUpdates'] as core.bool
                  : null,
          allowConditionUpdates: json_.containsKey('allowConditionUpdates')
              ? json_['allowConditionUpdates'] as core.bool
              : null,
          allowPriceUpdates: json_.containsKey('allowPriceUpdates')
              ? json_['allowPriceUpdates'] as core.bool
              : null,
          allowStrictAvailabilityUpdates:
              json_.containsKey('allowStrictAvailabilityUpdates')
                  ? json_['allowStrictAvailabilityUpdates'] as core.bool
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (allowAvailabilityUpdates != null)
          'allowAvailabilityUpdates': allowAvailabilityUpdates!,
        if (allowConditionUpdates != null)
          'allowConditionUpdates': allowConditionUpdates!,
        if (allowPriceUpdates != null) 'allowPriceUpdates': allowPriceUpdates!,
        if (allowStrictAvailabilityUpdates != null)
          'allowStrictAvailabilityUpdates': allowStrictAvailabilityUpdates!,
      };
}

/// Label assigned by CSS domain or CSS group to one of its sub-accounts.
class AccountLabel {
  /// The ID of account this label belongs to.
  ///
  /// Immutable.
  core.String? accountId;

  /// The description of this label.
  core.String? description;

  /// The ID of the label.
  ///
  /// Output only.
  core.String? labelId;

  /// The type of this label.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "LABEL_TYPE_UNSPECIFIED" : Unknown label type.
  /// - "MANUAL" : Indicates that the label was created manually.
  /// - "AUTOMATIC" : Indicates that the label was created automatically by CSS
  /// Center.
  core.String? labelType;

  /// The display name of this label.
  core.String? name;

  AccountLabel({
    this.accountId,
    this.description,
    this.labelId,
    this.labelType,
    this.name,
  });

  AccountLabel.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          labelId: json_.containsKey('labelId')
              ? json_['labelId'] as core.String
              : null,
          labelType: json_.containsKey('labelType')
              ? json_['labelType'] as core.String
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (description != null) 'description': description!,
        if (labelId != null) 'labelId': labelId!,
        if (labelType != null) 'labelType': labelType!,
        if (name != null) 'name': name!,
      };
}

///  The return carrier information.
///
/// This service is designed for merchants enrolled in the Buy on Google
/// program.
class AccountReturnCarrier {
  /// The Google-provided unique carrier ID, used to update the resource.
  ///
  /// Output only. Immutable.
  core.String? carrierAccountId;

  /// Name of the carrier account.
  core.String? carrierAccountName;

  /// Number of the carrier account.
  core.String? carrierAccountNumber;

  /// The carrier code enum.
  ///
  /// Accepts the values FEDEX or UPS.
  /// Possible string values are:
  /// - "CARRIER_CODE_UNSPECIFIED" : Carrier not specified
  /// - "FEDEX" : FedEx carrier
  /// - "UPS" : UPS carrier
  core.String? carrierCode;

  AccountReturnCarrier({
    this.carrierAccountId,
    this.carrierAccountName,
    this.carrierAccountNumber,
    this.carrierCode,
  });

  AccountReturnCarrier.fromJson(core.Map json_)
      : this(
          carrierAccountId: json_.containsKey('carrierAccountId')
              ? json_['carrierAccountId'] as core.String
              : null,
          carrierAccountName: json_.containsKey('carrierAccountName')
              ? json_['carrierAccountName'] as core.String
              : null,
          carrierAccountNumber: json_.containsKey('carrierAccountNumber')
              ? json_['carrierAccountNumber'] as core.String
              : null,
          carrierCode: json_.containsKey('carrierCode')
              ? json_['carrierCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrierAccountId != null) 'carrierAccountId': carrierAccountId!,
        if (carrierAccountName != null)
          'carrierAccountName': carrierAccountName!,
        if (carrierAccountNumber != null)
          'carrierAccountNumber': carrierAccountNumber!,
        if (carrierCode != null) 'carrierCode': carrierCode!,
      };
}

/// Not available for MCAs
/// [accounts](https://support.google.com/merchants/answer/188487).
///
/// By turning on
/// [automatic shipping improvements](https://support.google.com/merchants/answer/10027038),
/// you are allowing Google to improve the accuracy of your delivery times shown
/// to shoppers using Google. More accurate delivery times, especially when
/// faster, typically lead to better conversion rates. Google will improve your
/// estimated delivery times based on various factors: * Delivery address of an
/// order * Current handling time and shipping time settings * Estimated
/// weekdays or business days * Parcel tracking data
class AccountShippingImprovements {
  /// Enables automatic shipping improvements.
  core.bool? allowShippingImprovements;

  AccountShippingImprovements({
    this.allowShippingImprovements,
  });

  AccountShippingImprovements.fromJson(core.Map json_)
      : this(
          allowShippingImprovements:
              json_.containsKey('allowShippingImprovements')
                  ? json_['allowShippingImprovements'] as core.bool
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (allowShippingImprovements != null)
          'allowShippingImprovements': allowShippingImprovements!,
      };
}

/// The status of an account, that is, information about its products, which is
/// computed offline and not returned immediately at insertion time.
class AccountStatus {
  /// The ID of the account for which the status is reported.
  core.String? accountId;

  /// A list of account level issues.
  core.List<AccountStatusAccountLevelIssue>? accountLevelIssues;

  /// How the account is managed.
  ///
  /// Acceptable values are: - "`manual`" - "`automatic`"
  core.String? accountManagement;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountStatus`"
  core.String? kind;

  /// List of product-related data by channel, destination, and country.
  ///
  /// Data in this field may be delayed by up to 30 minutes.
  core.List<AccountStatusProducts>? products;

  /// Whether the account's website is claimed or not.
  core.bool? websiteClaimed;

  AccountStatus({
    this.accountId,
    this.accountLevelIssues,
    this.accountManagement,
    this.kind,
    this.products,
    this.websiteClaimed,
  });

  AccountStatus.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          accountLevelIssues: json_.containsKey('accountLevelIssues')
              ? (json_['accountLevelIssues'] as core.List)
                  .map((value) => AccountStatusAccountLevelIssue.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          accountManagement: json_.containsKey('accountManagement')
              ? json_['accountManagement'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          products: json_.containsKey('products')
              ? (json_['products'] as core.List)
                  .map((value) => AccountStatusProducts.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          websiteClaimed: json_.containsKey('websiteClaimed')
              ? json_['websiteClaimed'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (accountLevelIssues != null)
          'accountLevelIssues': accountLevelIssues!,
        if (accountManagement != null) 'accountManagement': accountManagement!,
        if (kind != null) 'kind': kind!,
        if (products != null) 'products': products!,
        if (websiteClaimed != null) 'websiteClaimed': websiteClaimed!,
      };
}

class AccountStatusAccountLevelIssue {
  /// Country for which this issue is reported.
  core.String? country;

  /// The destination the issue applies to.
  ///
  /// If this field is empty then the issue applies to all available
  /// destinations.
  core.String? destination;

  /// Additional details about the issue.
  core.String? detail;

  /// The URL of a web page to help resolving this issue.
  core.String? documentation;

  /// Issue identifier.
  core.String? id;

  /// Severity of the issue.
  ///
  /// Acceptable values are: - "`critical`" - "`error`" - "`suggestion`"
  core.String? severity;

  /// Short description of the issue.
  core.String? title;

  AccountStatusAccountLevelIssue({
    this.country,
    this.destination,
    this.detail,
    this.documentation,
    this.id,
    this.severity,
    this.title,
  });

  AccountStatusAccountLevelIssue.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          destination: json_.containsKey('destination')
              ? json_['destination'] as core.String
              : null,
          detail: json_.containsKey('detail')
              ? json_['detail'] as core.String
              : null,
          documentation: json_.containsKey('documentation')
              ? json_['documentation'] as core.String
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          severity: json_.containsKey('severity')
              ? json_['severity'] as core.String
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (destination != null) 'destination': destination!,
        if (detail != null) 'detail': detail!,
        if (documentation != null) 'documentation': documentation!,
        if (id != null) 'id': id!,
        if (severity != null) 'severity': severity!,
        if (title != null) 'title': title!,
      };
}

class AccountStatusItemLevelIssue {
  /// The attribute's name, if the issue is caused by a single attribute.
  core.String? attributeName;

  /// The error code of the issue.
  core.String? code;

  /// A short issue description in English.
  core.String? description;

  /// A detailed issue description in English.
  core.String? detail;

  /// The URL of a web page to help with resolving this issue.
  core.String? documentation;

  /// Number of items with this issue.
  core.String? numItems;

  /// Whether the issue can be resolved by the merchant.
  core.String? resolution;

  /// How this issue affects serving of the offer.
  core.String? servability;

  AccountStatusItemLevelIssue({
    this.attributeName,
    this.code,
    this.description,
    this.detail,
    this.documentation,
    this.numItems,
    this.resolution,
    this.servability,
  });

  AccountStatusItemLevelIssue.fromJson(core.Map json_)
      : this(
          attributeName: json_.containsKey('attributeName')
              ? json_['attributeName'] as core.String
              : null,
          code: json_.containsKey('code') ? json_['code'] as core.String : null,
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          detail: json_.containsKey('detail')
              ? json_['detail'] as core.String
              : null,
          documentation: json_.containsKey('documentation')
              ? json_['documentation'] as core.String
              : null,
          numItems: json_.containsKey('numItems')
              ? json_['numItems'] as core.String
              : null,
          resolution: json_.containsKey('resolution')
              ? json_['resolution'] as core.String
              : null,
          servability: json_.containsKey('servability')
              ? json_['servability'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributeName != null) 'attributeName': attributeName!,
        if (code != null) 'code': code!,
        if (description != null) 'description': description!,
        if (detail != null) 'detail': detail!,
        if (documentation != null) 'documentation': documentation!,
        if (numItems != null) 'numItems': numItems!,
        if (resolution != null) 'resolution': resolution!,
        if (servability != null) 'servability': servability!,
      };
}

class AccountStatusProducts {
  /// The channel the data applies to.
  ///
  /// Acceptable values are: - "`local`" - "`online`"
  core.String? channel;

  /// The country the data applies to.
  core.String? country;

  /// The destination the data applies to.
  core.String? destination;

  /// List of item-level issues.
  core.List<AccountStatusItemLevelIssue>? itemLevelIssues;

  /// Aggregated product statistics.
  AccountStatusStatistics? statistics;

  AccountStatusProducts({
    this.channel,
    this.country,
    this.destination,
    this.itemLevelIssues,
    this.statistics,
  });

  AccountStatusProducts.fromJson(core.Map json_)
      : this(
          channel: json_.containsKey('channel')
              ? json_['channel'] as core.String
              : null,
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          destination: json_.containsKey('destination')
              ? json_['destination'] as core.String
              : null,
          itemLevelIssues: json_.containsKey('itemLevelIssues')
              ? (json_['itemLevelIssues'] as core.List)
                  .map((value) => AccountStatusItemLevelIssue.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          statistics: json_.containsKey('statistics')
              ? AccountStatusStatistics.fromJson(
                  json_['statistics'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (channel != null) 'channel': channel!,
        if (country != null) 'country': country!,
        if (destination != null) 'destination': destination!,
        if (itemLevelIssues != null) 'itemLevelIssues': itemLevelIssues!,
        if (statistics != null) 'statistics': statistics!,
      };
}

class AccountStatusStatistics {
  /// Number of active offers.
  core.String? active;

  /// Number of disapproved offers.
  core.String? disapproved;

  /// Number of expiring offers.
  core.String? expiring;

  /// Number of pending offers.
  core.String? pending;

  AccountStatusStatistics({
    this.active,
    this.disapproved,
    this.expiring,
    this.pending,
  });

  AccountStatusStatistics.fromJson(core.Map json_)
      : this(
          active: json_.containsKey('active')
              ? json_['active'] as core.String
              : null,
          disapproved: json_.containsKey('disapproved')
              ? json_['disapproved'] as core.String
              : null,
          expiring: json_.containsKey('expiring')
              ? json_['expiring'] as core.String
              : null,
          pending: json_.containsKey('pending')
              ? json_['pending'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (active != null) 'active': active!,
        if (disapproved != null) 'disapproved': disapproved!,
        if (expiring != null) 'expiring': expiring!,
        if (pending != null) 'pending': pending!,
      };
}

/// The tax settings of a merchant account.
///
/// All methods require the admin role.
class AccountTax {
  /// The ID of the account to which these account tax settings belong.
  ///
  /// Required.
  core.String? accountId;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountTax`".
  core.String? kind;

  /// Tax rules.
  ///
  /// Updating the tax rules will enable "US" taxes (not reversible). Defining
  /// no rules is equivalent to not charging tax at all.
  core.List<AccountTaxTaxRule>? rules;

  AccountTax({
    this.accountId,
    this.kind,
    this.rules,
  });

  AccountTax.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          rules: json_.containsKey('rules')
              ? (json_['rules'] as core.List)
                  .map((value) => AccountTaxTaxRule.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (kind != null) 'kind': kind!,
        if (rules != null) 'rules': rules!,
      };
}

/// Tax calculation rule to apply in a state or province (US only).
class AccountTaxTaxRule {
  /// Country code in which tax is applicable.
  core.String? country;

  /// State (or province) is which the tax is applicable, described by its
  /// location ID (also called criteria ID).
  ///
  /// Required.
  core.String? locationId;

  /// Explicit tax rate in percent, represented as a floating point number
  /// without the percentage character.
  ///
  /// Must not be negative.
  core.String? ratePercent;

  /// If true, shipping charges are also taxed.
  core.bool? shippingTaxed;

  /// Whether the tax rate is taken from a global tax table or specified
  /// explicitly.
  core.bool? useGlobalRate;

  AccountTaxTaxRule({
    this.country,
    this.locationId,
    this.ratePercent,
    this.shippingTaxed,
    this.useGlobalRate,
  });

  AccountTaxTaxRule.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          locationId: json_.containsKey('locationId')
              ? json_['locationId'] as core.String
              : null,
          ratePercent: json_.containsKey('ratePercent')
              ? json_['ratePercent'] as core.String
              : null,
          shippingTaxed: json_.containsKey('shippingTaxed')
              ? json_['shippingTaxed'] as core.bool
              : null,
          useGlobalRate: json_.containsKey('useGlobalRate')
              ? json_['useGlobalRate'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (locationId != null) 'locationId': locationId!,
        if (ratePercent != null) 'ratePercent': ratePercent!,
        if (shippingTaxed != null) 'shippingTaxed': shippingTaxed!,
        if (useGlobalRate != null) 'useGlobalRate': useGlobalRate!,
      };
}

class AccountUser {
  /// Whether user is an admin.
  core.bool? admin;

  /// User's email address.
  core.String? emailAddress;

  /// Whether user is an order manager.
  core.bool? orderManager;

  /// Whether user can access payment statements.
  core.bool? paymentsAnalyst;

  /// Whether user can manage payment settings.
  core.bool? paymentsManager;

  /// Whether user is a reporting manager.
  core.bool? reportingManager;

  AccountUser({
    this.admin,
    this.emailAddress,
    this.orderManager,
    this.paymentsAnalyst,
    this.paymentsManager,
    this.reportingManager,
  });

  AccountUser.fromJson(core.Map json_)
      : this(
          admin:
              json_.containsKey('admin') ? json_['admin'] as core.bool : null,
          emailAddress: json_.containsKey('emailAddress')
              ? json_['emailAddress'] as core.String
              : null,
          orderManager: json_.containsKey('orderManager')
              ? json_['orderManager'] as core.bool
              : null,
          paymentsAnalyst: json_.containsKey('paymentsAnalyst')
              ? json_['paymentsAnalyst'] as core.bool
              : null,
          paymentsManager: json_.containsKey('paymentsManager')
              ? json_['paymentsManager'] as core.bool
              : null,
          reportingManager: json_.containsKey('reportingManager')
              ? json_['reportingManager'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (admin != null) 'admin': admin!,
        if (emailAddress != null) 'emailAddress': emailAddress!,
        if (orderManager != null) 'orderManager': orderManager!,
        if (paymentsAnalyst != null) 'paymentsAnalyst': paymentsAnalyst!,
        if (paymentsManager != null) 'paymentsManager': paymentsManager!,
        if (reportingManager != null) 'reportingManager': reportingManager!,
      };
}

class AccountYouTubeChannelLink {
  /// Channel ID.
  core.String? channelId;

  /// Status of the link between this Merchant Center account and the YouTube
  /// channel.
  ///
  /// Upon retrieval, it represents the actual status of the link and can be
  /// either `active` if it was approved in YT Creator Studio or `pending` if
  /// it's pending approval. Upon insertion, it represents the *intended* status
  /// of the link. Re-uploading a link with status `active` when it's still
  /// pending or with status `pending` when it's already active will have no
  /// effect: the status will remain unchanged. Re-uploading a link with
  /// deprecated status `inactive` is equivalent to not submitting the link at
  /// all and will delete the link if it was active or cancel the link request
  /// if it was pending.
  core.String? status;

  AccountYouTubeChannelLink({
    this.channelId,
    this.status,
  });

  AccountYouTubeChannelLink.fromJson(core.Map json_)
      : this(
          channelId: json_.containsKey('channelId')
              ? json_['channelId'] as core.String
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (channelId != null) 'channelId': channelId!,
        if (status != null) 'status': status!,
      };
}

class AccountsAuthInfoResponse {
  /// The account identifiers corresponding to the authenticated user.
  ///
  /// - For an individual account: only the merchant ID is defined - For an
  /// aggregator: only the aggregator ID is defined - For a subaccount of an
  /// MCA: both the merchant ID and the aggregator ID are defined.
  core.List<AccountIdentifier>? accountIdentifiers;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountsAuthInfoResponse`".
  core.String? kind;

  AccountsAuthInfoResponse({
    this.accountIdentifiers,
    this.kind,
  });

  AccountsAuthInfoResponse.fromJson(core.Map json_)
      : this(
          accountIdentifiers: json_.containsKey('accountIdentifiers')
              ? (json_['accountIdentifiers'] as core.List)
                  .map((value) => AccountIdentifier.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountIdentifiers != null)
          'accountIdentifiers': accountIdentifiers!,
        if (kind != null) 'kind': kind!,
      };
}

class AccountsClaimWebsiteResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountsClaimWebsiteResponse`".
  core.String? kind;

  AccountsClaimWebsiteResponse({
    this.kind,
  });

  AccountsClaimWebsiteResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class AccountsCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<AccountsCustomBatchRequestEntry>? entries;

  AccountsCustomBatchRequest({
    this.entries,
  });

  AccountsCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => AccountsCustomBatchRequestEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

/// A batch entry encoding a single non-batch accounts request.
class AccountsCustomBatchRequestEntry {
  /// The account to create or update.
  ///
  /// Only defined if the method is `insert` or `update`.
  Account? account;

  /// The ID of the targeted account.
  ///
  /// Only defined if the method is not `insert`.
  core.String? accountId;

  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// Whether the account should be deleted if the account has offers.
  ///
  /// Only applicable if the method is `delete`.
  core.bool? force;

  /// Label IDs for the 'updatelabels' request.
  core.List<core.String>? labelIds;

  /// Details about the `link` request.
  AccountsCustomBatchRequestEntryLinkRequest? linkRequest;

  /// The ID of the managing account.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`claimWebsite`" - "`delete`" - "`get`" -
  /// "`insert`" - "`link`" - "`update`"
  core.String? method;

  /// Only applicable if the method is `claimwebsite`.
  ///
  /// Indicates whether or not to take the claim from another account in case
  /// there is a conflict.
  core.bool? overwrite;

  /// Controls which fields are visible.
  ///
  /// Only applicable if the method is 'get'.
  core.String? view;

  AccountsCustomBatchRequestEntry({
    this.account,
    this.accountId,
    this.batchId,
    this.force,
    this.labelIds,
    this.linkRequest,
    this.merchantId,
    this.method,
    this.overwrite,
    this.view,
  });

  AccountsCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          account: json_.containsKey('account')
              ? Account.fromJson(
                  json_['account'] as core.Map<core.String, core.dynamic>)
              : null,
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          force:
              json_.containsKey('force') ? json_['force'] as core.bool : null,
          labelIds: json_.containsKey('labelIds')
              ? (json_['labelIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          linkRequest: json_.containsKey('linkRequest')
              ? AccountsCustomBatchRequestEntryLinkRequest.fromJson(
                  json_['linkRequest'] as core.Map<core.String, core.dynamic>)
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
          overwrite: json_.containsKey('overwrite')
              ? json_['overwrite'] as core.bool
              : null,
          view: json_.containsKey('view') ? json_['view'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (account != null) 'account': account!,
        if (accountId != null) 'accountId': accountId!,
        if (batchId != null) 'batchId': batchId!,
        if (force != null) 'force': force!,
        if (labelIds != null) 'labelIds': labelIds!,
        if (linkRequest != null) 'linkRequest': linkRequest!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
        if (overwrite != null) 'overwrite': overwrite!,
        if (view != null) 'view': view!,
      };
}

class AccountsCustomBatchRequestEntryLinkRequest {
  /// Action to perform for this link.
  ///
  /// The `"request"` action is only available to select merchants. Acceptable
  /// values are: - "`approve`" - "`remove`" - "`request`"
  core.String? action;

  /// Type of the link between the two accounts.
  ///
  /// Acceptable values are: - "`channelPartner`" - "`eCommercePlatform`" -
  /// "`paymentServiceProvider`"
  core.String? linkType;

  /// The ID of the linked account.
  core.String? linkedAccountId;

  /// Provided services.
  ///
  /// Acceptable values are: - "`shoppingAdsProductManagement`" -
  /// "`shoppingActionsProductManagement`" - "`shoppingActionsOrderManagement`"
  /// - "`paymentProcessing`"
  core.List<core.String>? services;

  AccountsCustomBatchRequestEntryLinkRequest({
    this.action,
    this.linkType,
    this.linkedAccountId,
    this.services,
  });

  AccountsCustomBatchRequestEntryLinkRequest.fromJson(core.Map json_)
      : this(
          action: json_.containsKey('action')
              ? json_['action'] as core.String
              : null,
          linkType: json_.containsKey('linkType')
              ? json_['linkType'] as core.String
              : null,
          linkedAccountId: json_.containsKey('linkedAccountId')
              ? json_['linkedAccountId'] as core.String
              : null,
          services: json_.containsKey('services')
              ? (json_['services'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (action != null) 'action': action!,
        if (linkType != null) 'linkType': linkType!,
        if (linkedAccountId != null) 'linkedAccountId': linkedAccountId!,
        if (services != null) 'services': services!,
      };
}

class AccountsCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<AccountsCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountsCustomBatchResponse`".
  core.String? kind;

  AccountsCustomBatchResponse({
    this.entries,
    this.kind,
  });

  AccountsCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => AccountsCustomBatchResponseEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

/// A batch entry encoding a single non-batch accounts response.
class AccountsCustomBatchResponseEntry {
  /// The retrieved, created, or updated account.
  ///
  /// Not defined if the method was `delete`, `claimwebsite` or `link`.
  Account? account;

  /// The ID of the request entry this entry responds to.
  core.int? batchId;

  /// A list of errors for failed custombatch entries.
  ///
  /// *Note:* Schema errors fail the whole request.
  Errors? errors;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountsCustomBatchResponseEntry`"
  core.String? kind;

  AccountsCustomBatchResponseEntry({
    this.account,
    this.batchId,
    this.errors,
    this.kind,
  });

  AccountsCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          account: json_.containsKey('account')
              ? Account.fromJson(
                  json_['account'] as core.Map<core.String, core.dynamic>)
              : null,
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (account != null) 'account': account!,
        if (batchId != null) 'batchId': batchId!,
        if (errors != null) 'errors': errors!,
        if (kind != null) 'kind': kind!,
      };
}

class AccountsLinkRequest {
  /// Action to perform for this link.
  ///
  /// The `"request"` action is only available to select merchants. Acceptable
  /// values are: - "`approve`" - "`remove`" - "`request`"
  core.String? action;

  /// Additional information required for `eCommercePlatform` link type.
  ECommercePlatformLinkInfo? eCommercePlatformLinkInfo;

  /// Type of the link between the two accounts.
  ///
  /// Acceptable values are: - "`channelPartner`" - "`eCommercePlatform`" -
  /// "`paymentServiceProvider`"
  core.String? linkType;

  /// The ID of the linked account.
  core.String? linkedAccountId;

  /// Additional information required for `paymentServiceProvider` link type.
  PaymentServiceProviderLinkInfo? paymentServiceProviderLinkInfo;

  /// Acceptable values are: - "`shoppingAdsProductManagement`" -
  /// "`shoppingActionsProductManagement`" - "`shoppingActionsOrderManagement`"
  /// - "`paymentProcessing`"
  core.List<core.String>? services;

  AccountsLinkRequest({
    this.action,
    this.eCommercePlatformLinkInfo,
    this.linkType,
    this.linkedAccountId,
    this.paymentServiceProviderLinkInfo,
    this.services,
  });

  AccountsLinkRequest.fromJson(core.Map json_)
      : this(
          action: json_.containsKey('action')
              ? json_['action'] as core.String
              : null,
          eCommercePlatformLinkInfo:
              json_.containsKey('eCommercePlatformLinkInfo')
                  ? ECommercePlatformLinkInfo.fromJson(
                      json_['eCommercePlatformLinkInfo']
                          as core.Map<core.String, core.dynamic>)
                  : null,
          linkType: json_.containsKey('linkType')
              ? json_['linkType'] as core.String
              : null,
          linkedAccountId: json_.containsKey('linkedAccountId')
              ? json_['linkedAccountId'] as core.String
              : null,
          paymentServiceProviderLinkInfo:
              json_.containsKey('paymentServiceProviderLinkInfo')
                  ? PaymentServiceProviderLinkInfo.fromJson(
                      json_['paymentServiceProviderLinkInfo']
                          as core.Map<core.String, core.dynamic>)
                  : null,
          services: json_.containsKey('services')
              ? (json_['services'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (action != null) 'action': action!,
        if (eCommercePlatformLinkInfo != null)
          'eCommercePlatformLinkInfo': eCommercePlatformLinkInfo!,
        if (linkType != null) 'linkType': linkType!,
        if (linkedAccountId != null) 'linkedAccountId': linkedAccountId!,
        if (paymentServiceProviderLinkInfo != null)
          'paymentServiceProviderLinkInfo': paymentServiceProviderLinkInfo!,
        if (services != null) 'services': services!,
      };
}

class AccountsLinkResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountsLinkResponse`".
  core.String? kind;

  AccountsLinkResponse({
    this.kind,
  });

  AccountsLinkResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class AccountsListLinksResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountsListLinksResponse`".
  core.String? kind;

  /// The list of available links.
  core.List<LinkedAccount>? links;

  /// The token for the retrieval of the next page of links.
  core.String? nextPageToken;

  AccountsListLinksResponse({
    this.kind,
    this.links,
    this.nextPageToken,
  });

  AccountsListLinksResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          links: json_.containsKey('links')
              ? (json_['links'] as core.List)
                  .map((value) => LinkedAccount.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (links != null) 'links': links!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

class AccountsListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountsListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of accounts.
  core.String? nextPageToken;
  core.List<Account>? resources;

  AccountsListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  AccountsListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => Account.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

class AccountsUpdateLabelsRequest {
  /// The IDs of labels that should be assigned to the account.
  core.List<core.String>? labelIds;

  AccountsUpdateLabelsRequest({
    this.labelIds,
  });

  AccountsUpdateLabelsRequest.fromJson(core.Map json_)
      : this(
          labelIds: json_.containsKey('labelIds')
              ? (json_['labelIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (labelIds != null) 'labelIds': labelIds!,
      };
}

class AccountsUpdateLabelsResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountsUpdateLabelsResponse`".
  core.String? kind;

  AccountsUpdateLabelsResponse({
    this.kind,
  });

  AccountsUpdateLabelsResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class AccountstatusesCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<AccountstatusesCustomBatchRequestEntry>? entries;

  AccountstatusesCustomBatchRequest({
    this.entries,
  });

  AccountstatusesCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) =>
                      AccountstatusesCustomBatchRequestEntry.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

/// A batch entry encoding a single non-batch accountstatuses request.
class AccountstatusesCustomBatchRequestEntry {
  /// The ID of the (sub-)account whose status to get.
  core.String? accountId;

  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// If set, only issues for the specified destinations are returned, otherwise
  /// only issues for the Shopping destination.
  core.List<core.String>? destinations;

  /// The ID of the managing account.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`get`"
  core.String? method;

  AccountstatusesCustomBatchRequestEntry({
    this.accountId,
    this.batchId,
    this.destinations,
    this.merchantId,
    this.method,
  });

  AccountstatusesCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          destinations: json_.containsKey('destinations')
              ? (json_['destinations'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (batchId != null) 'batchId': batchId!,
        if (destinations != null) 'destinations': destinations!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
      };
}

class AccountstatusesCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<AccountstatusesCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountstatusesCustomBatchResponse`".
  core.String? kind;

  AccountstatusesCustomBatchResponse({
    this.entries,
    this.kind,
  });

  AccountstatusesCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) =>
                      AccountstatusesCustomBatchResponseEntry.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

/// A batch entry encoding a single non-batch accountstatuses response.
class AccountstatusesCustomBatchResponseEntry {
  /// The requested account status.
  ///
  /// Defined if and only if the request was successful.
  AccountStatus? accountStatus;

  /// The ID of the request entry this entry responds to.
  core.int? batchId;

  /// A list of errors for failed custombatch entries.
  ///
  /// *Note:* Schema errors fail the whole request.
  Errors? errors;

  AccountstatusesCustomBatchResponseEntry({
    this.accountStatus,
    this.batchId,
    this.errors,
  });

  AccountstatusesCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          accountStatus: json_.containsKey('accountStatus')
              ? AccountStatus.fromJson(
                  json_['accountStatus'] as core.Map<core.String, core.dynamic>)
              : null,
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountStatus != null) 'accountStatus': accountStatus!,
        if (batchId != null) 'batchId': batchId!,
        if (errors != null) 'errors': errors!,
      };
}

class AccountstatusesListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accountstatusesListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of account statuses.
  core.String? nextPageToken;
  core.List<AccountStatus>? resources;

  AccountstatusesListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  AccountstatusesListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => AccountStatus.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

class AccounttaxCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<AccounttaxCustomBatchRequestEntry>? entries;

  AccounttaxCustomBatchRequest({
    this.entries,
  });

  AccounttaxCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => AccounttaxCustomBatchRequestEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

/// A batch entry encoding a single non-batch accounttax request.
class AccounttaxCustomBatchRequestEntry {
  /// The ID of the account for which to get/update account tax settings.
  core.String? accountId;

  /// The account tax settings to update.
  ///
  /// Only defined if the method is `update`.
  AccountTax? accountTax;

  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// The ID of the managing account.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`get`" - "`update`"
  core.String? method;

  AccounttaxCustomBatchRequestEntry({
    this.accountId,
    this.accountTax,
    this.batchId,
    this.merchantId,
    this.method,
  });

  AccounttaxCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          accountTax: json_.containsKey('accountTax')
              ? AccountTax.fromJson(
                  json_['accountTax'] as core.Map<core.String, core.dynamic>)
              : null,
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (accountTax != null) 'accountTax': accountTax!,
        if (batchId != null) 'batchId': batchId!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
      };
}

class AccounttaxCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<AccounttaxCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accounttaxCustomBatchResponse`".
  core.String? kind;

  AccounttaxCustomBatchResponse({
    this.entries,
    this.kind,
  });

  AccounttaxCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => AccounttaxCustomBatchResponseEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

/// A batch entry encoding a single non-batch accounttax response.
class AccounttaxCustomBatchResponseEntry {
  /// The retrieved or updated account tax settings.
  AccountTax? accountTax;

  /// The ID of the request entry this entry responds to.
  core.int? batchId;

  /// A list of errors for failed custombatch entries.
  ///
  /// *Note:* Schema errors fail the whole request.
  Errors? errors;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accounttaxCustomBatchResponseEntry`"
  core.String? kind;

  AccounttaxCustomBatchResponseEntry({
    this.accountTax,
    this.batchId,
    this.errors,
    this.kind,
  });

  AccounttaxCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          accountTax: json_.containsKey('accountTax')
              ? AccountTax.fromJson(
                  json_['accountTax'] as core.Map<core.String, core.dynamic>)
              : null,
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountTax != null) 'accountTax': accountTax!,
        if (batchId != null) 'batchId': batchId!,
        if (errors != null) 'errors': errors!,
        if (kind != null) 'kind': kind!,
      };
}

class AccounttaxListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#accounttaxListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of account tax settings.
  core.String? nextPageToken;
  core.List<AccountTax>? resources;

  AccounttaxListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  AccounttaxListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => AccountTax.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

/// An actionable step that can be executed to solve the issue.
class Action {
  /// Action implemented and performed in (your) third-party application.
  ///
  /// The application should point the merchant to the place, where they can
  /// access the corresponding functionality or provide instructions, if the
  /// specific functionality is not available.
  BuiltInSimpleAction? builtinSimpleAction;

  /// Label of the action button.
  core.String? buttonLabel;

  /// Action that is implemented and performed outside of (your) third-party
  /// application.
  ///
  /// The application needs to redirect the merchant to the external location
  /// where they can perform the action.
  ExternalAction? externalAction;

  /// Controlling whether the button is active or disabled.
  ///
  /// The value is 'false' when the action was already requested or is not
  /// available. If the action is not available then a reason will be present.
  /// If (your) third-party application shows a disabled button for action that
  /// is not available, then it should also show reasons.
  core.bool? isAvailable;

  /// List of reasons why the action is not available.
  ///
  /// The list of reasons is empty if the action is available. If there is only
  /// one reason, it can be displayed next to the disabled button. If there are
  /// more reasons, all of them should be displayed, for example in a pop-up
  /// dialog.
  core.List<ActionReason>? reasons;

  Action({
    this.builtinSimpleAction,
    this.buttonLabel,
    this.externalAction,
    this.isAvailable,
    this.reasons,
  });

  Action.fromJson(core.Map json_)
      : this(
          builtinSimpleAction: json_.containsKey('builtinSimpleAction')
              ? BuiltInSimpleAction.fromJson(json_['builtinSimpleAction']
                  as core.Map<core.String, core.dynamic>)
              : null,
          buttonLabel: json_.containsKey('buttonLabel')
              ? json_['buttonLabel'] as core.String
              : null,
          externalAction: json_.containsKey('externalAction')
              ? ExternalAction.fromJson(json_['externalAction']
                  as core.Map<core.String, core.dynamic>)
              : null,
          isAvailable: json_.containsKey('isAvailable')
              ? json_['isAvailable'] as core.bool
              : null,
          reasons: json_.containsKey('reasons')
              ? (json_['reasons'] as core.List)
                  .map((value) => ActionReason.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (builtinSimpleAction != null)
          'builtinSimpleAction': builtinSimpleAction!,
        if (buttonLabel != null) 'buttonLabel': buttonLabel!,
        if (externalAction != null) 'externalAction': externalAction!,
        if (isAvailable != null) 'isAvailable': isAvailable!,
        if (reasons != null) 'reasons': reasons!,
      };
}

/// A single reason why the action is not available.
class ActionReason {
  /// An action that needs to be performed to solve the problem represented by
  /// this reason.
  ///
  /// This action will always be available. Should be rendered as a link or
  /// button next to the summarizing message. For example, the review may be
  /// available only once merchant configure all required attributes. In such a
  /// situation this action can be a link to the form, where they can fill the
  /// missing attribute to unblock the main action.
  ///
  /// Optional.
  Action? action;

  /// Detailed explanation of the reason.
  ///
  /// Should be displayed as a hint if present.
  core.String? detail;

  /// Messages summarizing the reason, why the action is not available.
  ///
  /// For example: "Review requested on Jan 03. Review requests can take a few
  /// days to complete."
  core.String? message;

  ActionReason({
    this.action,
    this.detail,
    this.message,
  });

  ActionReason.fromJson(core.Map json_)
      : this(
          action: json_.containsKey('action')
              ? Action.fromJson(
                  json_['action'] as core.Map<core.String, core.dynamic>)
              : null,
          detail: json_.containsKey('detail')
              ? json_['detail'] as core.String
              : null,
          message: json_.containsKey('message')
              ? json_['message'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (action != null) 'action': action!,
        if (detail != null) 'detail': detail!,
        if (message != null) 'message': message!,
      };
}

/// Request message for the ActivateProgram method.
typedef ActivateBuyOnGoogleProgramRequest = $Empty;

class Address {
  /// Top-level administrative subdivision of the country.
  ///
  /// For example, a state like California ("CA") or a province like Quebec
  /// ("QC").
  ///
  /// Required.
  core.String? administrativeArea;

  /// City, town or commune.
  ///
  /// May also include dependent localities or sublocalities (for example,
  /// neighborhoods or suburbs).
  ///
  /// Required.
  core.String? city;

  /// [CLDR country code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml)
  /// (for example, "US").
  ///
  /// Required.
  core.String? country;

  /// Postal code or ZIP (for example, "94043").
  ///
  /// Required.
  core.String? postalCode;

  /// Street-level part of the address.
  ///
  /// Use `\n` to add a second line.
  core.String? streetAddress;

  Address({
    this.administrativeArea,
    this.city,
    this.country,
    this.postalCode,
    this.streetAddress,
  });

  Address.fromJson(core.Map json_)
      : this(
          administrativeArea: json_.containsKey('administrativeArea')
              ? json_['administrativeArea'] as core.String
              : null,
          city: json_.containsKey('city') ? json_['city'] as core.String : null,
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          postalCode: json_.containsKey('postalCode')
              ? json_['postalCode'] as core.String
              : null,
          streetAddress: json_.containsKey('streetAddress')
              ? json_['streetAddress'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (administrativeArea != null)
          'administrativeArea': administrativeArea!,
        if (city != null) 'city': city!,
        if (country != null) 'country': country!,
        if (postalCode != null) 'postalCode': postalCode!,
        if (streetAddress != null) 'streetAddress': streetAddress!,
      };
}

/// The Alternate Dispute Resolution (ADR) that may be available to merchants in
/// some regions.
///
/// If present, the link should be shown on the same page as the list of issues.
class AlternateDisputeResolution {
  /// The label for the alternate dispute resolution link.
  core.String? label;

  /// The URL pointing to a page, where merchant can request alternative dispute
  /// resolution with an
  /// [external body](https://support.google.com/european-union-digital-services-act-redress-options/answer/13535501).
  core.String? uri;

  AlternateDisputeResolution({
    this.label,
    this.uri,
  });

  AlternateDisputeResolution.fromJson(core.Map json_)
      : this(
          label:
              json_.containsKey('label') ? json_['label'] as core.String : null,
          uri: json_.containsKey('uri') ? json_['uri'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (label != null) 'label': label!,
        if (uri != null) 'uri': uri!,
      };
}

class Amount {
  /// The pre-tax or post-tax price depending on the location of the order.
  ///
  /// Required.
  Price? priceAmount;

  /// Tax value.
  ///
  /// Required.
  Price? taxAmount;

  Amount({
    this.priceAmount,
    this.taxAmount,
  });

  Amount.fromJson(core.Map json_)
      : this(
          priceAmount: json_.containsKey('priceAmount')
              ? Price.fromJson(
                  json_['priceAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          taxAmount: json_.containsKey('taxAmount')
              ? Price.fromJson(
                  json_['taxAmount'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (priceAmount != null) 'priceAmount': priceAmount!,
        if (taxAmount != null) 'taxAmount': taxAmount!,
      };
}

/// Represents attribution settings for conversion sources receiving
/// pre-attribution data.
class AttributionSettings {
  /// Lookback windows (in days) used for attribution in this source.
  ///
  /// Supported values are 7, 30, 60, 90.
  ///
  /// Required.
  core.int? attributionLookbackWindowInDays;

  /// Attribution model.
  ///
  /// Required.
  /// Possible string values are:
  /// - "ATTRIBUTION_MODEL_UNSPECIFIED"
  /// - "CROSS_CHANNEL_LAST_CLICK" : Cross-channel Last Click model.
  /// - "ADS_PREFERRED_LAST_CLICK" : Ads-preferred Last Click model.
  /// - "CROSS_CHANNEL_DATA_DRIVEN" : Cross-channel Data Driven model.
  /// - "CROSS_CHANNEL_FIRST_CLICK" : Cross-channel First Click model.
  /// - "CROSS_CHANNEL_LINEAR" : Cross-channel Linear model.
  /// - "CROSS_CHANNEL_POSITION_BASED" : Cross-channel Position Based model.
  /// - "CROSS_CHANNEL_TIME_DECAY" : Cross-channel Time Decay model.
  core.String? attributionModel;

  /// Unordered list.
  ///
  /// List of different conversion types a conversion event can be classified
  /// as. A standard "purchase" type will be automatically created if this list
  /// is empty at creation time.
  ///
  /// Immutable.
  core.List<AttributionSettingsConversionType>? conversionType;

  AttributionSettings({
    this.attributionLookbackWindowInDays,
    this.attributionModel,
    this.conversionType,
  });

  AttributionSettings.fromJson(core.Map json_)
      : this(
          attributionLookbackWindowInDays:
              json_.containsKey('attributionLookbackWindowInDays')
                  ? json_['attributionLookbackWindowInDays'] as core.int
                  : null,
          attributionModel: json_.containsKey('attributionModel')
              ? json_['attributionModel'] as core.String
              : null,
          conversionType: json_.containsKey('conversionType')
              ? (json_['conversionType'] as core.List)
                  .map((value) => AttributionSettingsConversionType.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributionLookbackWindowInDays != null)
          'attributionLookbackWindowInDays': attributionLookbackWindowInDays!,
        if (attributionModel != null) 'attributionModel': attributionModel!,
        if (conversionType != null) 'conversionType': conversionType!,
      };
}

/// Message representing a types of conversion events
class AttributionSettingsConversionType {
  /// Option indicating if the type should be included in Merchant Center
  /// reporting.
  ///
  /// Output only.
  core.bool? includeInReporting;

  /// Conversion event name, as it'll be reported by the client.
  ///
  /// Output only.
  core.String? name;

  AttributionSettingsConversionType({
    this.includeInReporting,
    this.name,
  });

  AttributionSettingsConversionType.fromJson(core.Map json_)
      : this(
          includeInReporting: json_.containsKey('includeInReporting')
              ? json_['includeInReporting'] as core.bool
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (includeInReporting != null)
          'includeInReporting': includeInReporting!,
        if (name != null) 'name': name!,
      };
}

/// Fields related to the
/// [Best sellers reports](https://support.google.com/merchants/answer/9488679).
class BestSellers {
  /// Google product category ID to calculate the ranking for, represented in
  /// [Google's product taxonomy](https://support.google.com/merchants/answer/6324436).
  ///
  /// If a `WHERE` condition on `best_sellers.category_id` is not specified in
  /// the query, rankings for all top-level categories are returned.
  core.String? categoryId;

  /// Country where the ranking is calculated.
  ///
  /// A `WHERE` condition on `best_sellers.country_code` is required in the
  /// query.
  core.String? countryCode;

  /// Popularity rank in the previous week or month.
  core.String? previousRank;

  /// Estimated demand in relation to the item with the highest popularity rank
  /// in the same category and country in the previous week or month.
  /// Possible string values are:
  /// - "RELATIVE_DEMAND_UNSPECIFIED" : Relative demand is unknown.
  /// - "VERY_LOW" : Demand is 0-5% of the demand of the highest ranked product
  /// clusters or brands.
  /// - "LOW" : Demand is 6-10% of the demand of the highest ranked product
  /// clusters or brands.
  /// - "MEDIUM" : Demand is 11-20% of the demand of the highest ranked product
  /// clusters or brands.
  /// - "HIGH" : Demand is 21-50% of the demand of the highest ranked product
  /// clusters or brands.
  /// - "VERY_HIGH" : Demand is 51-100% of the demand of the highest ranked
  /// product clusters or brands.
  core.String? previousRelativeDemand;

  /// Popularity on Shopping ads and free listings, in the selected category and
  /// country, based on the estimated number of units sold.
  core.String? rank;

  /// Estimated demand in relation to the item with the highest popularity rank
  /// in the same category and country.
  /// Possible string values are:
  /// - "RELATIVE_DEMAND_UNSPECIFIED" : Relative demand is unknown.
  /// - "VERY_LOW" : Demand is 0-5% of the demand of the highest ranked product
  /// clusters or brands.
  /// - "LOW" : Demand is 6-10% of the demand of the highest ranked product
  /// clusters or brands.
  /// - "MEDIUM" : Demand is 11-20% of the demand of the highest ranked product
  /// clusters or brands.
  /// - "HIGH" : Demand is 21-50% of the demand of the highest ranked product
  /// clusters or brands.
  /// - "VERY_HIGH" : Demand is 51-100% of the demand of the highest ranked
  /// product clusters or brands.
  core.String? relativeDemand;

  /// Change in the estimated demand.
  ///
  /// Whether it rose, sank or remained flat.
  /// Possible string values are:
  /// - "RELATIVE_DEMAND_CHANGE_TYPE_UNSPECIFIED" : Relative demand change is
  /// unknown.
  /// - "SINKER" : Relative demand is lower than previous time period.
  /// - "FLAT" : Relative demand is equal to previous time period.
  /// - "RISER" : Relative demand is higher than the previous time period.
  core.String? relativeDemandChange;

  /// Report date.
  ///
  /// The value of this field can only be one of the following: * The first day
  /// of the week (Monday) for weekly reports. * The first day of the month for
  /// monthly reports. If a `WHERE` condition on `best_sellers.report_date` is
  /// not specified in the query, the latest available weekly or monthly report
  /// is returned.
  Date? reportDate;

  /// Granularity of the report.
  ///
  /// The ranking can be done over a week or a month timeframe. A `WHERE`
  /// condition on `best_sellers.report_granularity` is required in the query.
  /// Possible string values are:
  /// - "REPORT_GRANULARITY_UNSPECIFIED" : Report granularity is unknown.
  /// - "WEEKLY" : Ranking is done over a week timeframe.
  /// - "MONTHLY" : Ranking is done over a month timeframe.
  core.String? reportGranularity;

  BestSellers({
    this.categoryId,
    this.countryCode,
    this.previousRank,
    this.previousRelativeDemand,
    this.rank,
    this.relativeDemand,
    this.relativeDemandChange,
    this.reportDate,
    this.reportGranularity,
  });

  BestSellers.fromJson(core.Map json_)
      : this(
          categoryId: json_.containsKey('categoryId')
              ? json_['categoryId'] as core.String
              : null,
          countryCode: json_.containsKey('countryCode')
              ? json_['countryCode'] as core.String
              : null,
          previousRank: json_.containsKey('previousRank')
              ? json_['previousRank'] as core.String
              : null,
          previousRelativeDemand: json_.containsKey('previousRelativeDemand')
              ? json_['previousRelativeDemand'] as core.String
              : null,
          rank: json_.containsKey('rank') ? json_['rank'] as core.String : null,
          relativeDemand: json_.containsKey('relativeDemand')
              ? json_['relativeDemand'] as core.String
              : null,
          relativeDemandChange: json_.containsKey('relativeDemandChange')
              ? json_['relativeDemandChange'] as core.String
              : null,
          reportDate: json_.containsKey('reportDate')
              ? Date.fromJson(
                  json_['reportDate'] as core.Map<core.String, core.dynamic>)
              : null,
          reportGranularity: json_.containsKey('reportGranularity')
              ? json_['reportGranularity'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (categoryId != null) 'categoryId': categoryId!,
        if (countryCode != null) 'countryCode': countryCode!,
        if (previousRank != null) 'previousRank': previousRank!,
        if (previousRelativeDemand != null)
          'previousRelativeDemand': previousRelativeDemand!,
        if (rank != null) 'rank': rank!,
        if (relativeDemand != null) 'relativeDemand': relativeDemand!,
        if (relativeDemandChange != null)
          'relativeDemandChange': relativeDemandChange!,
        if (reportDate != null) 'reportDate': reportDate!,
        if (reportGranularity != null) 'reportGranularity': reportGranularity!,
      };
}

/// Brand fields.
///
/// Values are only set for fields requested explicitly in the request's search
/// query.
class Brand {
  /// Name of the brand.
  core.String? name;

  Brand({
    this.name,
  });

  Brand.fromJson(core.Map json_)
      : this(
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (name != null) 'name': name!,
      };
}

/// A detailed impact breakdown for a group of regions where the impact of the
/// issue on different shopping destinations is the same.
class Breakdown {
  /// Human readable, localized description of issue's effect on different
  /// targets.
  ///
  /// Should be rendered as a list. For example: * "Products not showing in ads"
  /// * "Products not showing organically"
  core.List<core.String>? details;

  /// Lists of regions.
  ///
  /// Should be rendered as a title for this group of details. The full list
  /// should be shown to merchant. If the list is too long, it is recommended to
  /// make it expandable.
  core.List<BreakdownRegion>? regions;

  Breakdown({
    this.details,
    this.regions,
  });

  Breakdown.fromJson(core.Map json_)
      : this(
          details: json_.containsKey('details')
              ? (json_['details'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          regions: json_.containsKey('regions')
              ? (json_['regions'] as core.List)
                  .map((value) => BreakdownRegion.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (details != null) 'details': details!,
        if (regions != null) 'regions': regions!,
      };
}

/// Region with code and localized name.
class BreakdownRegion {
  /// The
  /// [CLDR territory code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
  core.String? code;

  /// The localized name of the region.
  ///
  /// For region with code='001' the value is 'All countries' or the equivalent
  /// in other languages.
  core.String? name;

  BreakdownRegion({
    this.code,
    this.name,
  });

  BreakdownRegion.fromJson(core.Map json_)
      : this(
          code: json_.containsKey('code') ? json_['code'] as core.String : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (code != null) 'code': code!,
        if (name != null) 'name': name!,
      };
}

/// Action that is implemented and performed in (your) third-party application.
///
/// Represents various functionality that is expected to be available to
/// merchant and will help them with resolving the issue. The application should
/// point the merchant to the place, where they can access the corresponding
/// functionality. If the functionality is not supported, it is recommended to
/// explain the situation to merchant and provide them with instructions how to
/// solve the issue.
class BuiltInSimpleAction {
  /// Long text from an external source that should be available to the
  /// merchant.
  ///
  /// Present when the type is `SHOW_ADDITIONAL_CONTENT`.
  BuiltInSimpleActionAdditionalContent? additionalContent;

  /// The attribute that needs to be updated.
  ///
  /// Present when the type is `EDIT_ITEM_ATTRIBUTE`. This field contains a code
  /// for attribute, represented in snake_case. You can find a list of product's
  /// attributes, with their codes
  /// [here](https://support.google.com/merchants/answer/7052112).
  core.String? attributeCode;

  /// The type of action that represents a functionality that is expected to be
  /// available in third-party application.
  /// Possible string values are:
  /// - "BUILT_IN_SIMPLE_ACTION_TYPE_UNSPECIFIED" : Default value. Will never be
  /// provided by the API.
  /// - "VERIFY_PHONE" : Redirect merchant to the part of your application where
  /// they can verify their phone.
  /// - "CLAIM_WEBSITE" : Redirect merchant to the part of your application
  /// where they can claim their website.
  /// - "ADD_PRODUCTS" : Redirect merchant to the part of your application where
  /// they can add products.
  /// - "ADD_CONTACT_INFO" : Open a form where the merchant can edit their
  /// contact information.
  /// - "LINK_ADS_ACCOUNT" : Redirect merchant to the part of your application
  /// where they can link ads account.
  /// - "ADD_BUSINESS_REGISTRATION_NUMBER" : Open a form where the merchant can
  /// add their business registration number.
  /// - "EDIT_ITEM_ATTRIBUTE" : Open a form where the merchant can edit an
  /// attribute. The attribute that needs to be updated is specified in
  /// attribute_code field of the action.
  /// - "FIX_ACCOUNT_ISSUE" : Redirect merchant from the product issues to the
  /// diagnostic page with their account issues in your application. This action
  /// will be returned only for product issues that are caused by an account
  /// issue and thus merchant should resolve the problem on the account level.
  /// - "SHOW_ADDITIONAL_CONTENT" : Show additional content to the merchant.
  /// This action will be used for example to deliver a justification from
  /// national authority.
  core.String? type;

  BuiltInSimpleAction({
    this.additionalContent,
    this.attributeCode,
    this.type,
  });

  BuiltInSimpleAction.fromJson(core.Map json_)
      : this(
          additionalContent: json_.containsKey('additionalContent')
              ? BuiltInSimpleActionAdditionalContent.fromJson(
                  json_['additionalContent']
                      as core.Map<core.String, core.dynamic>)
              : null,
          attributeCode: json_.containsKey('attributeCode')
              ? json_['attributeCode'] as core.String
              : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (additionalContent != null) 'additionalContent': additionalContent!,
        if (attributeCode != null) 'attributeCode': attributeCode!,
        if (type != null) 'type': type!,
      };
}

/// Long text from external source.
class BuiltInSimpleActionAdditionalContent {
  /// Long text organized into paragraphs.
  core.List<core.String>? paragraphs;

  /// Title of the additional content;
  core.String? title;

  BuiltInSimpleActionAdditionalContent({
    this.paragraphs,
    this.title,
  });

  BuiltInSimpleActionAdditionalContent.fromJson(core.Map json_)
      : this(
          paragraphs: json_.containsKey('paragraphs')
              ? (json_['paragraphs'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (paragraphs != null) 'paragraphs': paragraphs!,
        if (title != null) 'title': title!,
      };
}

class BusinessDayConfig {
  /// Regular business days, such as '"monday"'.
  ///
  /// May not be empty.
  core.List<core.String>? businessDays;

  BusinessDayConfig({
    this.businessDays,
  });

  BusinessDayConfig.fromJson(core.Map json_)
      : this(
          businessDays: json_.containsKey('businessDays')
              ? (json_['businessDays'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (businessDays != null) 'businessDays': businessDays!,
      };
}

/// Response message for the GetProgramStatus method.
class BuyOnGoogleProgramStatus {
  /// The business models in which merchant participates.
  core.List<core.String>? businessModel;

  /// The customer service pending email.
  ///
  /// After verification this field becomes empty.
  core.String? customerServicePendingEmail;

  /// The pending phone number specified for BuyOnGoogle program.
  ///
  /// It might be different than account level phone number. In order to update
  /// this field the customer_service_pending_phone_region_code must also be
  /// set. After verification this field becomes empty.
  core.String? customerServicePendingPhoneNumber;

  /// Two letter country code for the pending phone number, for example `CA` for
  /// Canadian numbers.
  ///
  /// See the \[ISO 3166-1
  /// alpha-2\](https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
  /// officially assigned codes. In order to update this field the
  /// customer_service_pending_phone_number must also be set. After verification
  /// this field becomes empty.
  core.String? customerServicePendingPhoneRegionCode;

  /// The customer service verified email.
  ///
  /// Output only.
  core.String? customerServiceVerifiedEmail;

  /// The verified phone number specified for BuyOnGoogle program.
  ///
  /// It might be different than account level phone number.
  ///
  /// Output only.
  core.String? customerServiceVerifiedPhoneNumber;

  /// Two letter country code for the verified phone number, for example `CA`
  /// for Canadian numbers.
  ///
  /// See the \[ISO 3166-1
  /// alpha-2\](https://wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements)
  /// officially assigned codes.
  ///
  /// Output only.
  core.String? customerServiceVerifiedPhoneRegionCode;

  /// The channels through which the merchant is selling.
  /// Possible string values are:
  /// - "ONLINE_SALES_CHANNEL_UNSPECIFIED" : Default value when online sales
  /// channel is not set.
  /// - "GOOGLE_EXCLUSIVE" : Merchant is selling exclusively on Google.
  /// - "GOOGLE_AND_OTHER_WEBSITES" : Merchant is selling on Google and other
  /// websites.
  core.String? onlineSalesChannel;

  /// The current participation stage for the program.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "PROGRAM_PARTICIPATION_STAGE_UNSPECIFIED" : Default value when
  /// participation stage is not set.
  /// - "NOT_ELIGIBLE" : Merchant is not eligible for onboarding to a given
  /// program in a specific region code.
  /// - "ELIGIBLE" : Merchant is eligible for onboarding to a given program in a
  /// specific region code.
  /// - "ONBOARDING" : Merchant is onboarding to a given program in a specific
  /// region code.
  /// - "ELIGIBLE_FOR_REVIEW" : Merchant fulfilled all the requirements and is
  /// ready to request review in a specific region code.
  /// - "PENDING_REVIEW" : Merchant is waiting for the review to be completed in
  /// a specific region code.
  /// - "REVIEW_DISAPPROVED" : The review for a merchant has been rejected in a
  /// specific region code.
  /// - "ACTIVE" : Merchant's program participation is active for a specific
  /// region code.
  /// - "PAUSED" : Participation has been paused.
  /// - "DEPRECATED" : The program cannot be further reactivated or paused. See
  /// more about
  /// [Buy on Google](https://support.google.com/merchants/answer/7679273).
  core.String? participationStage;

  BuyOnGoogleProgramStatus({
    this.businessModel,
    this.customerServicePendingEmail,
    this.customerServicePendingPhoneNumber,
    this.customerServicePendingPhoneRegionCode,
    this.customerServiceVerifiedEmail,
    this.customerServiceVerifiedPhoneNumber,
    this.customerServiceVerifiedPhoneRegionCode,
    this.onlineSalesChannel,
    this.participationStage,
  });

  BuyOnGoogleProgramStatus.fromJson(core.Map json_)
      : this(
          businessModel: json_.containsKey('businessModel')
              ? (json_['businessModel'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          customerServicePendingEmail:
              json_.containsKey('customerServicePendingEmail')
                  ? json_['customerServicePendingEmail'] as core.String
                  : null,
          customerServicePendingPhoneNumber:
              json_.containsKey('customerServicePendingPhoneNumber')
                  ? json_['customerServicePendingPhoneNumber'] as core.String
                  : null,
          customerServicePendingPhoneRegionCode: json_
                  .containsKey('customerServicePendingPhoneRegionCode')
              ? json_['customerServicePendingPhoneRegionCode'] as core.String
              : null,
          customerServiceVerifiedEmail:
              json_.containsKey('customerServiceVerifiedEmail')
                  ? json_['customerServiceVerifiedEmail'] as core.String
                  : null,
          customerServiceVerifiedPhoneNumber:
              json_.containsKey('customerServiceVerifiedPhoneNumber')
                  ? json_['customerServiceVerifiedPhoneNumber'] as core.String
                  : null,
          customerServiceVerifiedPhoneRegionCode: json_
                  .containsKey('customerServiceVerifiedPhoneRegionCode')
              ? json_['customerServiceVerifiedPhoneRegionCode'] as core.String
              : null,
          onlineSalesChannel: json_.containsKey('onlineSalesChannel')
              ? json_['onlineSalesChannel'] as core.String
              : null,
          participationStage: json_.containsKey('participationStage')
              ? json_['participationStage'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (businessModel != null) 'businessModel': businessModel!,
        if (customerServicePendingEmail != null)
          'customerServicePendingEmail': customerServicePendingEmail!,
        if (customerServicePendingPhoneNumber != null)
          'customerServicePendingPhoneNumber':
              customerServicePendingPhoneNumber!,
        if (customerServicePendingPhoneRegionCode != null)
          'customerServicePendingPhoneRegionCode':
              customerServicePendingPhoneRegionCode!,
        if (customerServiceVerifiedEmail != null)
          'customerServiceVerifiedEmail': customerServiceVerifiedEmail!,
        if (customerServiceVerifiedPhoneNumber != null)
          'customerServiceVerifiedPhoneNumber':
              customerServiceVerifiedPhoneNumber!,
        if (customerServiceVerifiedPhoneRegionCode != null)
          'customerServiceVerifiedPhoneRegionCode':
              customerServiceVerifiedPhoneRegionCode!,
        if (onlineSalesChannel != null)
          'onlineSalesChannel': onlineSalesChannel!,
        if (participationStage != null)
          'participationStage': participationStage!,
      };
}

/// Request message for the CaptureOrder method.
typedef CaptureOrderRequest = $Empty;

/// Response message for the CaptureOrder method.
class CaptureOrderResponse {
  /// The status of the execution.
  ///
  /// Only defined if the request was successful. Acceptable values are: *
  /// "duplicate" * "executed"
  /// Possible string values are:
  /// - "EXECUTION_STATUS_UNSPECIFIED" : Default value. This value is unused.
  /// - "EXECUTED" : The request was completed successfully.
  /// - "DUPLICATE" : The request was not performed because it already executed
  /// once successfully.
  core.String? executionStatus;

  CaptureOrderResponse({
    this.executionStatus,
  });

  CaptureOrderResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
      };
}

class CarrierRate {
  /// Carrier service, such as `"UPS"` or `"Fedex"`.
  ///
  /// The list of supported carriers can be retrieved through the
  /// `getSupportedCarriers` method. Required.
  core.String? carrierName;

  /// Carrier service, such as `"ground"` or `"2 days"`.
  ///
  /// The list of supported services for a carrier can be retrieved through the
  /// `getSupportedCarriers` method. Required.
  core.String? carrierService;

  /// Additive shipping rate modifier.
  ///
  /// Can be negative. For example `{ "value": "1", "currency" : "USD" }` adds
  /// $1 to the rate, `{ "value": "-3", "currency" : "USD" }` removes $3 from
  /// the rate. Optional.
  Price? flatAdjustment;

  /// Name of the carrier rate.
  ///
  /// Must be unique per rate group. Required.
  core.String? name;

  /// Shipping origin for this carrier rate.
  ///
  /// Required.
  core.String? originPostalCode;

  /// Multiplicative shipping rate modifier as a number in decimal notation.
  ///
  /// Can be negative. For example `"5.4"` increases the rate by 5.4%, `"-3"`
  /// decreases the rate by 3%. Optional.
  core.String? percentageAdjustment;

  CarrierRate({
    this.carrierName,
    this.carrierService,
    this.flatAdjustment,
    this.name,
    this.originPostalCode,
    this.percentageAdjustment,
  });

  CarrierRate.fromJson(core.Map json_)
      : this(
          carrierName: json_.containsKey('carrierName')
              ? json_['carrierName'] as core.String
              : null,
          carrierService: json_.containsKey('carrierService')
              ? json_['carrierService'] as core.String
              : null,
          flatAdjustment: json_.containsKey('flatAdjustment')
              ? Price.fromJson(json_['flatAdjustment']
                  as core.Map<core.String, core.dynamic>)
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          originPostalCode: json_.containsKey('originPostalCode')
              ? json_['originPostalCode'] as core.String
              : null,
          percentageAdjustment: json_.containsKey('percentageAdjustment')
              ? json_['percentageAdjustment'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrierName != null) 'carrierName': carrierName!,
        if (carrierService != null) 'carrierService': carrierService!,
        if (flatAdjustment != null) 'flatAdjustment': flatAdjustment!,
        if (name != null) 'name': name!,
        if (originPostalCode != null) 'originPostalCode': originPostalCode!,
        if (percentageAdjustment != null)
          'percentageAdjustment': percentageAdjustment!,
      };
}

class CarriersCarrier {
  /// The CLDR country code of the carrier (for example, "US").
  ///
  /// Always present.
  core.String? country;

  /// A list of services supported for EDD (Estimated Delivery Date)
  /// calculation.
  ///
  /// This is the list of valid values for
  /// WarehouseBasedDeliveryTime.carrierService.
  core.List<core.String>? eddServices;

  /// The name of the carrier (for example, `"UPS"`).
  ///
  /// Always present.
  core.String? name;

  /// A list of supported services (for example, `"ground"`) for that carrier.
  ///
  /// Contains at least one service. This is the list of valid values for
  /// CarrierRate.carrierService.
  core.List<core.String>? services;

  CarriersCarrier({
    this.country,
    this.eddServices,
    this.name,
    this.services,
  });

  CarriersCarrier.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          eddServices: json_.containsKey('eddServices')
              ? (json_['eddServices'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          services: json_.containsKey('services')
              ? (json_['services'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (eddServices != null) 'eddServices': eddServices!,
        if (name != null) 'name': name!,
        if (services != null) 'services': services!,
      };
}

/// `CheckoutSettings` for a specific merchant ID.
class CheckoutSettings {
  /// The effective value of enrollment state for a given merchant ID.
  ///
  /// If account level settings are present then this value will be a copy of
  /// the account level settings. Otherwise, it will have the value of the
  /// parent account.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "CHECKOUT_ON_MERCHANT_ENROLLMENT_STATE_UNSPECIFIED" : Default enrollment
  /// state when enrollment state is not specified.
  /// - "INACTIVE" : Merchant has not enrolled into the feature.
  /// - "ENROLLED" : Merchant has enrolled into the feature by providing either
  /// an account level URL or checkout URLs as part of their feed.
  core.String? effectiveEnrollmentState;

  /// The effective value of review state for a given merchant ID.
  ///
  /// If account level settings are present then this value will be a copy of
  /// the account level settings. Otherwise, it will have the value of the
  /// parent account.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "CHECKOUT_ON_MERCHANT_REVIEW_STATE_UNSPECIFIED" : Default review state
  /// when review state is not specified.
  /// - "IN_REVIEW" : Merchant provided URLs are being reviewed for data quality
  /// issues.
  /// - "APPROVED" : Merchant account has been approved. Indicates the data
  /// quality checks have passed.
  /// - "DISAPPROVED" : Merchant account has been disapproved due to data
  /// quality issues.
  core.String? effectiveReviewState;

  /// The effective value of `url_settings` for a given merchant ID.
  ///
  /// If account level settings are present then this value will be a copy of
  /// the account level settings. Otherwise, it will have the value of the
  /// parent account.
  UrlSettings? effectiveUriSettings;

  /// Reflects the merchant enrollment state in `Checkout` feature.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "CHECKOUT_ON_MERCHANT_ENROLLMENT_STATE_UNSPECIFIED" : Default enrollment
  /// state when enrollment state is not specified.
  /// - "INACTIVE" : Merchant has not enrolled into the feature.
  /// - "ENROLLED" : Merchant has enrolled into the feature by providing either
  /// an account level URL or checkout URLs as part of their feed.
  core.String? enrollmentState;

  /// The ID of the account.
  ///
  /// Required.
  core.String? merchantId;

  /// Reflects the merchant review state in `Checkout` feature.
  ///
  /// This is set based on the data quality reviews of the URL provided by the
  /// merchant. A merchant with enrollment state as `ENROLLED` can be in the
  /// following review states: `IN_REVIEW`, `APPROVED` or `DISAPPROVED`. A
  /// merchant must be in an enrollment_state of `ENROLLED` before a review can
  /// begin for the merchant.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "CHECKOUT_ON_MERCHANT_REVIEW_STATE_UNSPECIFIED" : Default review state
  /// when review state is not specified.
  /// - "IN_REVIEW" : Merchant provided URLs are being reviewed for data quality
  /// issues.
  /// - "APPROVED" : Merchant account has been approved. Indicates the data
  /// quality checks have passed.
  /// - "DISAPPROVED" : Merchant account has been disapproved due to data
  /// quality issues.
  core.String? reviewState;

  /// URL settings for cart or checkout URL.
  UrlSettings? uriSettings;

  CheckoutSettings({
    this.effectiveEnrollmentState,
    this.effectiveReviewState,
    this.effectiveUriSettings,
    this.enrollmentState,
    this.merchantId,
    this.reviewState,
    this.uriSettings,
  });

  CheckoutSettings.fromJson(core.Map json_)
      : this(
          effectiveEnrollmentState:
              json_.containsKey('effectiveEnrollmentState')
                  ? json_['effectiveEnrollmentState'] as core.String
                  : null,
          effectiveReviewState: json_.containsKey('effectiveReviewState')
              ? json_['effectiveReviewState'] as core.String
              : null,
          effectiveUriSettings: json_.containsKey('effectiveUriSettings')
              ? UrlSettings.fromJson(json_['effectiveUriSettings']
                  as core.Map<core.String, core.dynamic>)
              : null,
          enrollmentState: json_.containsKey('enrollmentState')
              ? json_['enrollmentState'] as core.String
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          reviewState: json_.containsKey('reviewState')
              ? json_['reviewState'] as core.String
              : null,
          uriSettings: json_.containsKey('uriSettings')
              ? UrlSettings.fromJson(
                  json_['uriSettings'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (effectiveEnrollmentState != null)
          'effectiveEnrollmentState': effectiveEnrollmentState!,
        if (effectiveReviewState != null)
          'effectiveReviewState': effectiveReviewState!,
        if (effectiveUriSettings != null)
          'effectiveUriSettings': effectiveUriSettings!,
        if (enrollmentState != null) 'enrollmentState': enrollmentState!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (reviewState != null) 'reviewState': reviewState!,
        if (uriSettings != null) 'uriSettings': uriSettings!,
      };
}

/// Product property for the Cloud Retail API.
///
/// For example, properties for a TV product could be "Screen-Resolution" or
/// "Screen-Size".
class CloudExportAdditionalProperties {
  /// Boolean value of the given property.
  ///
  /// For example for a TV product, "True" or "False" if the screen is UHD.
  core.bool? boolValue;

  /// Float values of the given property.
  ///
  /// For example for a TV product 1.2345. Maximum number of specified values
  /// for this field is 400. Values are stored in an arbitrary but consistent
  /// order.
  core.List<core.double>? floatValue;

  /// Integer values of the given property.
  ///
  /// For example, 1080 for a screen resolution of a TV product. Maximum number
  /// of specified values for this field is 400. Values are stored in an
  /// arbitrary but consistent order.
  core.List<core.String>? intValue;

  /// Maximum float value of the given property.
  ///
  /// For example for a TV product 100.00.
  core.double? maxValue;

  /// Minimum float value of the given property.
  ///
  /// For example for a TV product 1.00.
  core.double? minValue;

  /// Name of the given property.
  ///
  /// For example, "Screen-Resolution" for a TV product. Maximum string size is
  /// 256 characters.
  core.String? propertyName;

  /// Text value of the given property.
  ///
  /// For example, "8K(UHD)" could be a text value for a TV product. Maximum
  /// number of specified values for this field is 400. Values are stored in an
  /// arbitrary but consistent order. Maximum string size is 256 characters.
  core.List<core.String>? textValue;

  /// Unit of the given property.
  ///
  /// For example, "Pixels" for a TV product. Maximum string size is 256 bytes.
  core.String? unitCode;

  CloudExportAdditionalProperties({
    this.boolValue,
    this.floatValue,
    this.intValue,
    this.maxValue,
    this.minValue,
    this.propertyName,
    this.textValue,
    this.unitCode,
  });

  CloudExportAdditionalProperties.fromJson(core.Map json_)
      : this(
          boolValue: json_.containsKey('boolValue')
              ? json_['boolValue'] as core.bool
              : null,
          floatValue: json_.containsKey('floatValue')
              ? (json_['floatValue'] as core.List)
                  .map((value) => (value as core.num).toDouble())
                  .toList()
              : null,
          intValue: json_.containsKey('intValue')
              ? (json_['intValue'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          maxValue: json_.containsKey('maxValue')
              ? (json_['maxValue'] as core.num).toDouble()
              : null,
          minValue: json_.containsKey('minValue')
              ? (json_['minValue'] as core.num).toDouble()
              : null,
          propertyName: json_.containsKey('propertyName')
              ? json_['propertyName'] as core.String
              : null,
          textValue: json_.containsKey('textValue')
              ? (json_['textValue'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          unitCode: json_.containsKey('unitCode')
              ? json_['unitCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (boolValue != null) 'boolValue': boolValue!,
        if (floatValue != null) 'floatValue': floatValue!,
        if (intValue != null) 'intValue': intValue!,
        if (maxValue != null) 'maxValue': maxValue!,
        if (minValue != null) 'minValue': minValue!,
        if (propertyName != null) 'propertyName': propertyName!,
        if (textValue != null) 'textValue': textValue!,
        if (unitCode != null) 'unitCode': unitCode!,
      };
}

/// The collection message.
class Collection {
  /// Label that you assign to a collection to help organize bidding and
  /// reporting in Shopping campaigns.
  ///
  /// [Custom label](https://support.google.com/merchants/answer/9674217)
  core.String? customLabel0;

  /// Label that you assign to a collection to help organize bidding and
  /// reporting in Shopping campaigns.
  core.String? customLabel1;

  /// Label that you assign to a collection to help organize bidding and
  /// reporting in Shopping campaigns.
  core.String? customLabel2;

  /// Label that you assign to a collection to help organize bidding and
  /// reporting in Shopping campaigns.
  core.String? customLabel3;

  /// Label that you assign to a collection to help organize bidding and
  /// reporting in Shopping campaigns.
  core.String? customLabel4;

  /// This identifies one or more products associated with the collection.
  ///
  /// Used as a lookup to the corresponding product ID in your product feeds.
  /// Provide a maximum of 100 featuredProduct (for collections). Provide up to
  /// 10 featuredProduct (for Shoppable Images only) with ID and X and Y
  /// coordinates.
  /// [featured_product attribute](https://support.google.com/merchants/answer/9703736)
  core.List<CollectionFeaturedProduct>? featuredProduct;

  /// Your collection's name.
  ///
  /// [headline attribute](https://support.google.com/merchants/answer/9673580)
  core.List<core.String>? headline;

  /// The REST ID of the collection.
  ///
  /// Content API methods that operate on collections take this as their
  /// collectionId parameter. The REST ID for a collection is of the form
  /// collectionId.
  /// [id attribute](https://support.google.com/merchants/answer/9649290)
  ///
  /// Required.
  core.String? id;

  /// The URL of a collection’s image.
  ///
  /// [image_link attribute](https://support.google.com/merchants/answer/9703236)
  core.List<core.String>? imageLink;

  /// The language of a collection and the language of any featured products
  /// linked to the collection.
  ///
  /// [language attribute](https://support.google.com/merchants/answer/9673781)
  core.String? language;

  /// A collection’s landing page.
  ///
  /// URL directly linking to your collection's page on your website.
  /// [link attribute](https://support.google.com/merchants/answer/9673983)
  core.String? link;

  /// A collection’s mobile-optimized landing page when you have a different URL
  /// for mobile and desktop traffic.
  ///
  /// [mobile_link attribute](https://support.google.com/merchants/answer/9646123)
  core.String? mobileLink;

  /// [product_country attribute](https://support.google.com/merchants/answer/9674155)
  core.String? productCountry;

  Collection({
    this.customLabel0,
    this.customLabel1,
    this.customLabel2,
    this.customLabel3,
    this.customLabel4,
    this.featuredProduct,
    this.headline,
    this.id,
    this.imageLink,
    this.language,
    this.link,
    this.mobileLink,
    this.productCountry,
  });

  Collection.fromJson(core.Map json_)
      : this(
          customLabel0: json_.containsKey('customLabel0')
              ? json_['customLabel0'] as core.String
              : null,
          customLabel1: json_.containsKey('customLabel1')
              ? json_['customLabel1'] as core.String
              : null,
          customLabel2: json_.containsKey('customLabel2')
              ? json_['customLabel2'] as core.String
              : null,
          customLabel3: json_.containsKey('customLabel3')
              ? json_['customLabel3'] as core.String
              : null,
          customLabel4: json_.containsKey('customLabel4')
              ? json_['customLabel4'] as core.String
              : null,
          featuredProduct: json_.containsKey('featuredProduct')
              ? (json_['featuredProduct'] as core.List)
                  .map((value) => CollectionFeaturedProduct.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          headline: json_.containsKey('headline')
              ? (json_['headline'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          imageLink: json_.containsKey('imageLink')
              ? (json_['imageLink'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          language: json_.containsKey('language')
              ? json_['language'] as core.String
              : null,
          link: json_.containsKey('link') ? json_['link'] as core.String : null,
          mobileLink: json_.containsKey('mobileLink')
              ? json_['mobileLink'] as core.String
              : null,
          productCountry: json_.containsKey('productCountry')
              ? json_['productCountry'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (customLabel0 != null) 'customLabel0': customLabel0!,
        if (customLabel1 != null) 'customLabel1': customLabel1!,
        if (customLabel2 != null) 'customLabel2': customLabel2!,
        if (customLabel3 != null) 'customLabel3': customLabel3!,
        if (customLabel4 != null) 'customLabel4': customLabel4!,
        if (featuredProduct != null) 'featuredProduct': featuredProduct!,
        if (headline != null) 'headline': headline!,
        if (id != null) 'id': id!,
        if (imageLink != null) 'imageLink': imageLink!,
        if (language != null) 'language': language!,
        if (link != null) 'link': link!,
        if (mobileLink != null) 'mobileLink': mobileLink!,
        if (productCountry != null) 'productCountry': productCountry!,
      };
}

/// The message for FeaturedProduct.
///
/// [FeaturedProduct](https://support.google.com/merchants/answer/9703736)
class CollectionFeaturedProduct {
  /// The unique identifier for the product item.
  core.String? offerId;

  /// X-coordinate of the product callout on the Shoppable Image.
  ///
  /// Required.
  core.double? x;

  /// Y-coordinate of the product callout on the Shoppable Image.
  ///
  /// Required.
  core.double? y;

  CollectionFeaturedProduct({
    this.offerId,
    this.x,
    this.y,
  });

  CollectionFeaturedProduct.fromJson(core.Map json_)
      : this(
          offerId: json_.containsKey('offerId')
              ? json_['offerId'] as core.String
              : null,
          x: json_.containsKey('x')
              ? (json_['x'] as core.num).toDouble()
              : null,
          y: json_.containsKey('y')
              ? (json_['y'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (offerId != null) 'offerId': offerId!,
        if (x != null) 'x': x!,
        if (y != null) 'y': y!,
      };
}

/// The collectionstatus message.
class CollectionStatus {
  /// A list of all issues associated with the collection.
  core.List<CollectionStatusItemLevelIssue>? collectionLevelIssuses;

  /// Date on which the collection has been created in
  /// [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and
  /// offset, for example "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
  core.String? creationDate;

  /// The intended destinations for the collection.
  core.List<CollectionStatusDestinationStatus>? destinationStatuses;

  /// The ID of the collection for which status is reported.
  ///
  /// Required.
  core.String? id;

  /// Date on which the collection has been last updated in
  /// [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and
  /// offset, for example "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
  core.String? lastUpdateDate;

  CollectionStatus({
    this.collectionLevelIssuses,
    this.creationDate,
    this.destinationStatuses,
    this.id,
    this.lastUpdateDate,
  });

  CollectionStatus.fromJson(core.Map json_)
      : this(
          collectionLevelIssuses: json_.containsKey('collectionLevelIssuses')
              ? (json_['collectionLevelIssuses'] as core.List)
                  .map((value) => CollectionStatusItemLevelIssue.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          creationDate: json_.containsKey('creationDate')
              ? json_['creationDate'] as core.String
              : null,
          destinationStatuses: json_.containsKey('destinationStatuses')
              ? (json_['destinationStatuses'] as core.List)
                  .map((value) => CollectionStatusDestinationStatus.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          lastUpdateDate: json_.containsKey('lastUpdateDate')
              ? json_['lastUpdateDate'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (collectionLevelIssuses != null)
          'collectionLevelIssuses': collectionLevelIssuses!,
        if (creationDate != null) 'creationDate': creationDate!,
        if (destinationStatuses != null)
          'destinationStatuses': destinationStatuses!,
        if (id != null) 'id': id!,
        if (lastUpdateDate != null) 'lastUpdateDate': lastUpdateDate!,
      };
}

/// Destination status message.
class CollectionStatusDestinationStatus {
  /// Country codes (ISO 3166-1 alpha-2) where the collection is approved.
  core.List<core.String>? approvedCountries;

  /// The name of the destination
  core.String? destination;

  /// Country codes (ISO 3166-1 alpha-2) where the collection is disapproved.
  core.List<core.String>? disapprovedCountries;

  /// Country codes (ISO 3166-1 alpha-2) where the collection is pending
  /// approval.
  core.List<core.String>? pendingCountries;

  /// The status for the specified destination in the collections target
  /// country.
  core.String? status;

  CollectionStatusDestinationStatus({
    this.approvedCountries,
    this.destination,
    this.disapprovedCountries,
    this.pendingCountries,
    this.status,
  });

  CollectionStatusDestinationStatus.fromJson(core.Map json_)
      : this(
          approvedCountries: json_.containsKey('approvedCountries')
              ? (json_['approvedCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          destination: json_.containsKey('destination')
              ? json_['destination'] as core.String
              : null,
          disapprovedCountries: json_.containsKey('disapprovedCountries')
              ? (json_['disapprovedCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          pendingCountries: json_.containsKey('pendingCountries')
              ? (json_['pendingCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (approvedCountries != null) 'approvedCountries': approvedCountries!,
        if (destination != null) 'destination': destination!,
        if (disapprovedCountries != null)
          'disapprovedCountries': disapprovedCountries!,
        if (pendingCountries != null) 'pendingCountries': pendingCountries!,
        if (status != null) 'status': status!,
      };
}

/// Issue associated with the collection.
class CollectionStatusItemLevelIssue {
  /// Country codes (ISO 3166-1 alpha-2) where issue applies to the offer.
  core.List<core.String>? applicableCountries;

  /// The attribute's name, if the issue is caused by a single attribute.
  core.String? attributeName;

  /// The error code of the issue.
  core.String? code;

  /// A short issue description in English.
  core.String? description;

  /// The destination the issue applies to.
  core.String? destination;

  /// A detailed issue description in English.
  core.String? detail;

  /// The URL of a web page to help with resolving this issue.
  core.String? documentation;

  /// Whether the issue can be resolved by the merchant.
  core.String? resolution;

  /// How this issue affects the serving of the collection.
  core.String? servability;

  CollectionStatusItemLevelIssue({
    this.applicableCountries,
    this.attributeName,
    this.code,
    this.description,
    this.destination,
    this.detail,
    this.documentation,
    this.resolution,
    this.servability,
  });

  CollectionStatusItemLevelIssue.fromJson(core.Map json_)
      : this(
          applicableCountries: json_.containsKey('applicableCountries')
              ? (json_['applicableCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          attributeName: json_.containsKey('attributeName')
              ? json_['attributeName'] as core.String
              : null,
          code: json_.containsKey('code') ? json_['code'] as core.String : null,
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          destination: json_.containsKey('destination')
              ? json_['destination'] as core.String
              : null,
          detail: json_.containsKey('detail')
              ? json_['detail'] as core.String
              : null,
          documentation: json_.containsKey('documentation')
              ? json_['documentation'] as core.String
              : null,
          resolution: json_.containsKey('resolution')
              ? json_['resolution'] as core.String
              : null,
          servability: json_.containsKey('servability')
              ? json_['servability'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (applicableCountries != null)
          'applicableCountries': applicableCountries!,
        if (attributeName != null) 'attributeName': attributeName!,
        if (code != null) 'code': code!,
        if (description != null) 'description': description!,
        if (destination != null) 'destination': destination!,
        if (detail != null) 'detail': detail!,
        if (documentation != null) 'documentation': documentation!,
        if (resolution != null) 'resolution': resolution!,
        if (servability != null) 'servability': servability!,
      };
}

/// Fields related to
/// [competitive visibility reports](https://support.google.com/merchants/answer/11366442).
class CompetitiveVisibility {
  /// [Ads / organic ratio](https://support.google.com/merchants/answer/11366442#zippy=%2Cadsfree-ratio)
  /// shows how often a merchant receives impressions from Shopping ads compared
  /// to organic traffic.
  ///
  /// The number is rounded and bucketed. Available only in
  /// `CompetitiveVisibilityTopMerchantView` and
  /// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the
  /// 'WHERE' clause.
  core.double? adsOrganicRatio;

  /// Change in visibility based on impressions with respect to the start of the
  /// selected time range (or first day with non-zero impressions) for a
  /// combined set of merchants with highest visibility approximating the
  /// market.
  ///
  /// Available only in `CompetitiveVisibilityBenchmarkView`. Cannot be filtered
  /// on in the 'WHERE' clause.
  core.double? categoryBenchmarkVisibilityTrend;

  /// Google product category ID to calculate the report for, represented in
  /// [Google's product taxonomy](https://support.google.com/merchants/answer/6324436).
  ///
  /// Required in the `SELECT` clause. A `WHERE` condition on
  /// `competitive_visibility.category_id` is required in the query.
  core.String? categoryId;

  /// The country where impression appeared.
  ///
  /// Required in the `SELECT` clause. A `WHERE` condition on
  /// `competitive_visibility.country_code` is required in the query.
  core.String? countryCode;

  /// Date of this row.
  ///
  /// Available only in `CompetitiveVisibilityBenchmarkView` and
  /// `CompetitiveVisibilityCompetitorView`. Required in the `SELECT` clause for
  /// `CompetitiveVisibilityMarketBenchmarkView`.
  Date? date;

  /// Domain of your competitor or your domain, if 'is_your_domain' is true.
  ///
  /// Available only in `CompetitiveVisibilityTopMerchantView` and
  /// `CompetitiveVisibilityCompetitorView`. Required in the `SELECT` clause for
  /// `CompetitiveVisibilityTopMerchantView` and
  /// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the
  /// 'WHERE' clause.
  core.String? domain;

  /// Higher position rate shows how often a competitor’s offer got placed in a
  /// higher position on the page than your offer.
  ///
  /// Available only in `CompetitiveVisibilityTopMerchantView` and
  /// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the
  /// 'WHERE' clause.
  core.double? higherPositionRate;

  /// True if this row contains data for your domain.
  ///
  /// Available only in `CompetitiveVisibilityTopMerchantView` and
  /// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the
  /// 'WHERE' clause.
  core.bool? isYourDomain;

  /// Page overlap rate describes how frequently competing retailers’ offers are
  /// shown together with your offers on the same page.
  ///
  /// Available only in `CompetitiveVisibilityTopMerchantView` and
  /// `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the
  /// 'WHERE' clause.
  core.double? pageOverlapRate;

  /// Position of the domain in the top merchants ranking for the selected keys
  /// (`date`, `category_id`, `country_code`, `listing_type`) based on
  /// impressions.
  ///
  /// 1 is the highest. Available only in `CompetitiveVisibilityTopMerchantView`
  /// and `CompetitiveVisibilityCompetitorView`. Cannot be filtered on in the
  /// 'WHERE' clause.
  core.String? rank;

  /// Relative visibility shows how often your competitors’ offers are shown
  /// compared to your offers.
  ///
  /// In other words, this is the number of displayed impressions of a
  /// competitor retailer divided by the number of your displayed impressions
  /// during a selected time range for a selected product category and country.
  /// Available only in `CompetitiveVisibilityCompetitorView`. Cannot be
  /// filtered on in the 'WHERE' clause.
  core.double? relativeVisibility;

  /// Type of impression listing.
  ///
  /// Required in the `SELECT` clause. Cannot be filtered on in the 'WHERE'
  /// clause.
  /// Possible string values are:
  /// - "UNKNOWN" : Traffic source is unknown.
  /// - "ORGANIC" : Organic traffic.
  /// - "ADS" : Traffic from Ads.
  /// - "ALL" : Organic and Ads traffic.
  core.String? trafficSource;

  /// Change in visibility based on impressions for your domain with respect to
  /// the start of the selected time range (or first day with non-zero
  /// impressions).
  ///
  /// Available only in `CompetitiveVisibilityBenchmarkView`. Cannot be filtered
  /// on in the 'WHERE' clause.
  core.double? yourDomainVisibilityTrend;

  CompetitiveVisibility({
    this.adsOrganicRatio,
    this.categoryBenchmarkVisibilityTrend,
    this.categoryId,
    this.countryCode,
    this.date,
    this.domain,
    this.higherPositionRate,
    this.isYourDomain,
    this.pageOverlapRate,
    this.rank,
    this.relativeVisibility,
    this.trafficSource,
    this.yourDomainVisibilityTrend,
  });

  CompetitiveVisibility.fromJson(core.Map json_)
      : this(
          adsOrganicRatio: json_.containsKey('adsOrganicRatio')
              ? (json_['adsOrganicRatio'] as core.num).toDouble()
              : null,
          categoryBenchmarkVisibilityTrend:
              json_.containsKey('categoryBenchmarkVisibilityTrend')
                  ? (json_['categoryBenchmarkVisibilityTrend'] as core.num)
                      .toDouble()
                  : null,
          categoryId: json_.containsKey('categoryId')
              ? json_['categoryId'] as core.String
              : null,
          countryCode: json_.containsKey('countryCode')
              ? json_['countryCode'] as core.String
              : null,
          date: json_.containsKey('date')
              ? Date.fromJson(
                  json_['date'] as core.Map<core.String, core.dynamic>)
              : null,
          domain: json_.containsKey('domain')
              ? json_['domain'] as core.String
              : null,
          higherPositionRate: json_.containsKey('higherPositionRate')
              ? (json_['higherPositionRate'] as core.num).toDouble()
              : null,
          isYourDomain: json_.containsKey('isYourDomain')
              ? json_['isYourDomain'] as core.bool
              : null,
          pageOverlapRate: json_.containsKey('pageOverlapRate')
              ? (json_['pageOverlapRate'] as core.num).toDouble()
              : null,
          rank: json_.containsKey('rank') ? json_['rank'] as core.String : null,
          relativeVisibility: json_.containsKey('relativeVisibility')
              ? (json_['relativeVisibility'] as core.num).toDouble()
              : null,
          trafficSource: json_.containsKey('trafficSource')
              ? json_['trafficSource'] as core.String
              : null,
          yourDomainVisibilityTrend:
              json_.containsKey('yourDomainVisibilityTrend')
                  ? (json_['yourDomainVisibilityTrend'] as core.num).toDouble()
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (adsOrganicRatio != null) 'adsOrganicRatio': adsOrganicRatio!,
        if (categoryBenchmarkVisibilityTrend != null)
          'categoryBenchmarkVisibilityTrend': categoryBenchmarkVisibilityTrend!,
        if (categoryId != null) 'categoryId': categoryId!,
        if (countryCode != null) 'countryCode': countryCode!,
        if (date != null) 'date': date!,
        if (domain != null) 'domain': domain!,
        if (higherPositionRate != null)
          'higherPositionRate': higherPositionRate!,
        if (isYourDomain != null) 'isYourDomain': isYourDomain!,
        if (pageOverlapRate != null) 'pageOverlapRate': pageOverlapRate!,
        if (rank != null) 'rank': rank!,
        if (relativeVisibility != null)
          'relativeVisibility': relativeVisibility!,
        if (trafficSource != null) 'trafficSource': trafficSource!,
        if (yourDomainVisibilityTrend != null)
          'yourDomainVisibilityTrend': yourDomainVisibilityTrend!,
      };
}

/// Represents a conversion source owned by a Merchant account.
///
/// A merchant account can have up to 200 conversion sources.
class ConversionSource {
  /// Generated by the Content API upon creation of a new `ConversionSource`.
  ///
  /// Format: \[a-z\]{4}:.+ The four characters before the colon represent the
  /// type of conversio source. Content after the colon represents the ID of the
  /// conversion source within that type. The ID of two different conversion
  /// sources might be the same across different types. The following type
  /// prefixes are supported: - galk: For GoogleAnalyticsLink sources. - mcdn:
  /// For MerchantCenterDestination sources.
  ///
  /// Output only.
  core.String? conversionSourceId;

  /// The time when an archived conversion source becomes permanently deleted
  /// and is no longer available to undelete.
  ///
  /// Output only.
  core.String? expireTime;

  /// Conversion Source of type "Link to Google Analytics Property".
  ///
  /// Immutable.
  GoogleAnalyticsLink? googleAnalyticsLink;

  /// Conversion Source of type "Merchant Center Tag Destination".
  MerchantCenterDestination? merchantCenterDestination;

  /// Current state of this conversion source.
  ///
  /// Can't be edited through the API.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED"
  /// - "ACTIVE" : Conversion source is fully functional.
  /// - "ARCHIVED" : Conversion source has been archived in the last 30 days and
  /// not currently functional. Can be restored using the undelete method.
  /// - "PENDING" : Conversion source creation has started but not fully
  /// finished yet.
  core.String? state;

  ConversionSource({
    this.conversionSourceId,
    this.expireTime,
    this.googleAnalyticsLink,
    this.merchantCenterDestination,
    this.state,
  });

  ConversionSource.fromJson(core.Map json_)
      : this(
          conversionSourceId: json_.containsKey('conversionSourceId')
              ? json_['conversionSourceId'] as core.String
              : null,
          expireTime: json_.containsKey('expireTime')
              ? json_['expireTime'] as core.String
              : null,
          googleAnalyticsLink: json_.containsKey('googleAnalyticsLink')
              ? GoogleAnalyticsLink.fromJson(json_['googleAnalyticsLink']
                  as core.Map<core.String, core.dynamic>)
              : null,
          merchantCenterDestination:
              json_.containsKey('merchantCenterDestination')
                  ? MerchantCenterDestination.fromJson(
                      json_['merchantCenterDestination']
                          as core.Map<core.String, core.dynamic>)
                  : null,
          state:
              json_.containsKey('state') ? json_['state'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (conversionSourceId != null)
          'conversionSourceId': conversionSourceId!,
        if (expireTime != null) 'expireTime': expireTime!,
        if (googleAnalyticsLink != null)
          'googleAnalyticsLink': googleAnalyticsLink!,
        if (merchantCenterDestination != null)
          'merchantCenterDestination': merchantCenterDestination!,
        if (state != null) 'state': state!,
      };
}

/// Information about CSS domain.
class Css {
  /// The CSS domain ID.
  ///
  /// Output only. Immutable.
  core.String? cssDomainId;

  /// The ID of the CSS group this CSS domain is affiliated with.
  ///
  /// Only populated for CSS group users.
  ///
  /// Output only. Immutable.
  core.String? cssGroupId;

  /// The CSS domain's display name, used when space is constrained.
  ///
  /// Output only. Immutable.
  core.String? displayName;

  /// The CSS domain's full name.
  ///
  /// Output only. Immutable.
  core.String? fullName;

  /// The CSS domain's homepage.
  ///
  /// Output only. Immutable.
  core.String? homepageUri;

  /// A list of label IDs that are assigned to this CSS domain by its CSS group.
  ///
  /// Only populated for CSS group users.
  core.List<core.String>? labelIds;

  Css({
    this.cssDomainId,
    this.cssGroupId,
    this.displayName,
    this.fullName,
    this.homepageUri,
    this.labelIds,
  });

  Css.fromJson(core.Map json_)
      : this(
          cssDomainId: json_.containsKey('cssDomainId')
              ? json_['cssDomainId'] as core.String
              : null,
          cssGroupId: json_.containsKey('cssGroupId')
              ? json_['cssGroupId'] as core.String
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          fullName: json_.containsKey('fullName')
              ? json_['fullName'] as core.String
              : null,
          homepageUri: json_.containsKey('homepageUri')
              ? json_['homepageUri'] as core.String
              : null,
          labelIds: json_.containsKey('labelIds')
              ? (json_['labelIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (cssDomainId != null) 'cssDomainId': cssDomainId!,
        if (cssGroupId != null) 'cssGroupId': cssGroupId!,
        if (displayName != null) 'displayName': displayName!,
        if (fullName != null) 'fullName': fullName!,
        if (homepageUri != null) 'homepageUri': homepageUri!,
        if (labelIds != null) 'labelIds': labelIds!,
      };
}

/// A message that represents custom attributes.
///
/// Exactly one of `value` or `groupValues` must be provided. Maximum allowed
/// number of characters for each custom attribute is 10240 (represents sum of
/// characters for name and value). Maximum 2500 custom attributes can be set
/// per merchant, with total size of 102.4kB.
class CustomAttribute {
  /// Subattributes within this attribute group.
  ///
  /// Exactly one of value or groupValues must be provided.
  core.List<CustomAttribute>? groupValues;

  /// The name of the attribute.
  ///
  /// Underscores will be replaced by spaces upon insertion.
  core.String? name;

  /// The value of the attribute.
  core.String? value;

  CustomAttribute({
    this.groupValues,
    this.name,
    this.value,
  });

  CustomAttribute.fromJson(core.Map json_)
      : this(
          groupValues: json_.containsKey('groupValues')
              ? (json_['groupValues'] as core.List)
                  .map((value) => CustomAttribute.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          value:
              json_.containsKey('value') ? json_['value'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (groupValues != null) 'groupValues': groupValues!,
        if (name != null) 'name': name!,
        if (value != null) 'value': value!,
      };
}

class CustomerReturnReason {
  /// Description of the reason.
  core.String? description;

  /// Code of the return reason.
  ///
  /// Acceptable values are: - "`betterPriceFound`" - "`changedMind`" -
  /// "`damagedOrDefectiveItem`" - "`didNotMatchDescription`" - "`doesNotFit`" -
  /// "`expiredItem`" - "`incorrectItemReceived`" - "`noLongerNeeded`" -
  /// "`notSpecified`" - "`orderedWrongItem`" - "`other`" -
  /// "`qualityNotExpected`" - "`receivedTooLate`" - "`undeliverable`"
  core.String? reasonCode;

  CustomerReturnReason({
    this.description,
    this.reasonCode,
  });

  CustomerReturnReason.fromJson(core.Map json_)
      : this(
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          reasonCode: json_.containsKey('reasonCode')
              ? json_['reasonCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (description != null) 'description': description!,
        if (reasonCode != null) 'reasonCode': reasonCode!,
      };
}

class CutoffTime {
  /// Hour of the cutoff time until which an order has to be placed to be
  /// processed in the same day.
  ///
  /// Required.
  core.int? hour;

  /// Minute of the cutoff time until which an order has to be placed to be
  /// processed in the same day.
  ///
  /// Required.
  core.int? minute;

  /// Timezone identifier for the cutoff time (for example, "Europe/Zurich").
  ///
  /// List of identifiers. Required.
  core.String? timezone;

  CutoffTime({
    this.hour,
    this.minute,
    this.timezone,
  });

  CutoffTime.fromJson(core.Map json_)
      : this(
          hour: json_.containsKey('hour') ? json_['hour'] as core.int : null,
          minute:
              json_.containsKey('minute') ? json_['minute'] as core.int : null,
          timezone: json_.containsKey('timezone')
              ? json_['timezone'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (hour != null) 'hour': hour!,
        if (minute != null) 'minute': minute!,
        if (timezone != null) 'timezone': timezone!,
      };
}

/// Datafeed configuration data.
class Datafeed {
  /// The two-letter ISO 639-1 language in which the attributes are defined in
  /// the data feed.
  core.String? attributeLanguage;

  /// The type of data feed.
  ///
  /// For product inventory feeds, only feeds for local stores, not online
  /// stores, are supported. Acceptable values are: - "`local products`" -
  /// "`product inventory`" - "`products`"
  ///
  /// Required.
  core.String? contentType;

  /// Fetch schedule for the feed file.
  DatafeedFetchSchedule? fetchSchedule;

  /// The filename of the feed.
  ///
  /// All feeds must have a unique file name.
  ///
  /// Required.
  core.String? fileName;

  /// Format of the feed file.
  DatafeedFormat? format;

  /// Required for update.
  ///
  /// The ID of the data feed.
  core.String? id;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#datafeed`"
  core.String? kind;

  /// Required for insert.
  ///
  /// A descriptive name of the data feed.
  core.String? name;

  /// The targets this feed should apply to (country, language, destinations).
  core.List<DatafeedTarget>? targets;

  Datafeed({
    this.attributeLanguage,
    this.contentType,
    this.fetchSchedule,
    this.fileName,
    this.format,
    this.id,
    this.kind,
    this.name,
    this.targets,
  });

  Datafeed.fromJson(core.Map json_)
      : this(
          attributeLanguage: json_.containsKey('attributeLanguage')
              ? json_['attributeLanguage'] as core.String
              : null,
          contentType: json_.containsKey('contentType')
              ? json_['contentType'] as core.String
              : null,
          fetchSchedule: json_.containsKey('fetchSchedule')
              ? DatafeedFetchSchedule.fromJson(
                  json_['fetchSchedule'] as core.Map<core.String, core.dynamic>)
              : null,
          fileName: json_.containsKey('fileName')
              ? json_['fileName'] as core.String
              : null,
          format: json_.containsKey('format')
              ? DatafeedFormat.fromJson(
                  json_['format'] as core.Map<core.String, core.dynamic>)
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          targets: json_.containsKey('targets')
              ? (json_['targets'] as core.List)
                  .map((value) => DatafeedTarget.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributeLanguage != null) 'attributeLanguage': attributeLanguage!,
        if (contentType != null) 'contentType': contentType!,
        if (fetchSchedule != null) 'fetchSchedule': fetchSchedule!,
        if (fileName != null) 'fileName': fileName!,
        if (format != null) 'format': format!,
        if (id != null) 'id': id!,
        if (kind != null) 'kind': kind!,
        if (name != null) 'name': name!,
        if (targets != null) 'targets': targets!,
      };
}

/// The required fields vary based on the frequency of fetching.
///
/// For a monthly fetch schedule, day_of_month and hour are required. For a
/// weekly fetch schedule, weekday and hour are required. For a daily fetch
/// schedule, only hour is required.
class DatafeedFetchSchedule {
  /// The day of the month the feed file should be fetched (1-31).
  core.int? dayOfMonth;

  /// The URL where the feed file can be fetched.
  ///
  /// Google Merchant Center will support automatic scheduled uploads using the
  /// HTTP, HTTPS, FTP, or SFTP protocols, so the value will need to be a valid
  /// link using one of those four protocols.
  core.String? fetchUrl;

  /// The hour of the day the feed file should be fetched (0-23).
  core.int? hour;

  /// The minute of the hour the feed file should be fetched (0-59).
  ///
  /// Read-only.
  core.int? minuteOfHour;

  /// An optional password for fetch_url.
  core.String? password;

  /// Whether the scheduled fetch is paused or not.
  core.bool? paused;

  /// Time zone used for schedule.
  ///
  /// UTC by default. For example, "America/Los_Angeles".
  core.String? timeZone;

  /// An optional user name for fetch_url.
  core.String? username;

  /// The day of the week the feed file should be fetched.
  ///
  /// Acceptable values are: - "`monday`" - "`tuesday`" - "`wednesday`" -
  /// "`thursday`" - "`friday`" - "`saturday`" - "`sunday`"
  core.String? weekday;

  DatafeedFetchSchedule({
    this.dayOfMonth,
    this.fetchUrl,
    this.hour,
    this.minuteOfHour,
    this.password,
    this.paused,
    this.timeZone,
    this.username,
    this.weekday,
  });

  DatafeedFetchSchedule.fromJson(core.Map json_)
      : this(
          dayOfMonth: json_.containsKey('dayOfMonth')
              ? json_['dayOfMonth'] as core.int
              : null,
          fetchUrl: json_.containsKey('fetchUrl')
              ? json_['fetchUrl'] as core.String
              : null,
          hour: json_.containsKey('hour') ? json_['hour'] as core.int : null,
          minuteOfHour: json_.containsKey('minuteOfHour')
              ? json_['minuteOfHour'] as core.int
              : null,
          password: json_.containsKey('password')
              ? json_['password'] as core.String
              : null,
          paused:
              json_.containsKey('paused') ? json_['paused'] as core.bool : null,
          timeZone: json_.containsKey('timeZone')
              ? json_['timeZone'] as core.String
              : null,
          username: json_.containsKey('username')
              ? json_['username'] as core.String
              : null,
          weekday: json_.containsKey('weekday')
              ? json_['weekday'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dayOfMonth != null) 'dayOfMonth': dayOfMonth!,
        if (fetchUrl != null) 'fetchUrl': fetchUrl!,
        if (hour != null) 'hour': hour!,
        if (minuteOfHour != null) 'minuteOfHour': minuteOfHour!,
        if (password != null) 'password': password!,
        if (paused != null) 'paused': paused!,
        if (timeZone != null) 'timeZone': timeZone!,
        if (username != null) 'username': username!,
        if (weekday != null) 'weekday': weekday!,
      };
}

class DatafeedFormat {
  /// Delimiter for the separation of values in a delimiter-separated values
  /// feed.
  ///
  /// If not specified, the delimiter will be auto-detected. Ignored for non-DSV
  /// data feeds. Acceptable values are: - "`pipe`" - "`tab`" - "`tilde`"
  core.String? columnDelimiter;

  /// Character encoding scheme of the data feed.
  ///
  /// If not specified, the encoding will be auto-detected. Acceptable values
  /// are: - "`latin-1`" - "`utf-16be`" - "`utf-16le`" - "`utf-8`" -
  /// "`windows-1252`"
  core.String? fileEncoding;

  /// Specifies how double quotes are interpreted.
  ///
  /// If not specified, the mode will be auto-detected. Ignored for non-DSV data
  /// feeds. Acceptable values are: - "`normal character`" - "`value quoting`"
  core.String? quotingMode;

  DatafeedFormat({
    this.columnDelimiter,
    this.fileEncoding,
    this.quotingMode,
  });

  DatafeedFormat.fromJson(core.Map json_)
      : this(
          columnDelimiter: json_.containsKey('columnDelimiter')
              ? json_['columnDelimiter'] as core.String
              : null,
          fileEncoding: json_.containsKey('fileEncoding')
              ? json_['fileEncoding'] as core.String
              : null,
          quotingMode: json_.containsKey('quotingMode')
              ? json_['quotingMode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (columnDelimiter != null) 'columnDelimiter': columnDelimiter!,
        if (fileEncoding != null) 'fileEncoding': fileEncoding!,
        if (quotingMode != null) 'quotingMode': quotingMode!,
      };
}

/// The status of a datafeed, that is, the result of the last retrieval of the
/// datafeed computed asynchronously when the feed processing is finished.
class DatafeedStatus {
  /// The country for which the status is reported, represented as a CLDR
  /// territory code.
  core.String? country;

  /// The ID of the feed for which the status is reported.
  core.String? datafeedId;

  /// The list of errors occurring in the feed.
  core.List<DatafeedStatusError>? errors;

  /// The feed label status is reported for.
  core.String? feedLabel;

  /// The number of items in the feed that were processed.
  core.String? itemsTotal;

  /// The number of items in the feed that were valid.
  core.String? itemsValid;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#datafeedStatus`"
  core.String? kind;

  /// The two-letter ISO 639-1 language for which the status is reported.
  core.String? language;

  /// The last date at which the feed was uploaded.
  core.String? lastUploadDate;

  /// The processing status of the feed.
  ///
  /// Acceptable values are: - "`"`failure`": The feed could not be processed or
  /// all items had errors.`" - "`in progress`": The feed is being processed. -
  /// "`none`": The feed has not yet been processed. For example, a feed that
  /// has never been uploaded will have this processing status. - "`success`":
  /// The feed was processed successfully, though some items might have had
  /// errors.
  core.String? processingStatus;

  /// The list of errors occurring in the feed.
  core.List<DatafeedStatusError>? warnings;

  DatafeedStatus({
    this.country,
    this.datafeedId,
    this.errors,
    this.feedLabel,
    this.itemsTotal,
    this.itemsValid,
    this.kind,
    this.language,
    this.lastUploadDate,
    this.processingStatus,
    this.warnings,
  });

  DatafeedStatus.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          datafeedId: json_.containsKey('datafeedId')
              ? json_['datafeedId'] as core.String
              : null,
          errors: json_.containsKey('errors')
              ? (json_['errors'] as core.List)
                  .map((value) => DatafeedStatusError.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          feedLabel: json_.containsKey('feedLabel')
              ? json_['feedLabel'] as core.String
              : null,
          itemsTotal: json_.containsKey('itemsTotal')
              ? json_['itemsTotal'] as core.String
              : null,
          itemsValid: json_.containsKey('itemsValid')
              ? json_['itemsValid'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          language: json_.containsKey('language')
              ? json_['language'] as core.String
              : null,
          lastUploadDate: json_.containsKey('lastUploadDate')
              ? json_['lastUploadDate'] as core.String
              : null,
          processingStatus: json_.containsKey('processingStatus')
              ? json_['processingStatus'] as core.String
              : null,
          warnings: json_.containsKey('warnings')
              ? (json_['warnings'] as core.List)
                  .map((value) => DatafeedStatusError.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (datafeedId != null) 'datafeedId': datafeedId!,
        if (errors != null) 'errors': errors!,
        if (feedLabel != null) 'feedLabel': feedLabel!,
        if (itemsTotal != null) 'itemsTotal': itemsTotal!,
        if (itemsValid != null) 'itemsValid': itemsValid!,
        if (kind != null) 'kind': kind!,
        if (language != null) 'language': language!,
        if (lastUploadDate != null) 'lastUploadDate': lastUploadDate!,
        if (processingStatus != null) 'processingStatus': processingStatus!,
        if (warnings != null) 'warnings': warnings!,
      };
}

/// An error occurring in the feed, like "invalid price".
class DatafeedStatusError {
  /// The code of the error, for example, "validation/invalid_value".
  core.String? code;

  /// The number of occurrences of the error in the feed.
  core.String? count;

  /// A list of example occurrences of the error, grouped by product.
  core.List<DatafeedStatusExample>? examples;

  /// The error message, for example, "Invalid price".
  core.String? message;

  DatafeedStatusError({
    this.code,
    this.count,
    this.examples,
    this.message,
  });

  DatafeedStatusError.fromJson(core.Map json_)
      : this(
          code: json_.containsKey('code') ? json_['code'] as core.String : null,
          count:
              json_.containsKey('count') ? json_['count'] as core.String : null,
          examples: json_.containsKey('examples')
              ? (json_['examples'] as core.List)
                  .map((value) => DatafeedStatusExample.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          message: json_.containsKey('message')
              ? json_['message'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (code != null) 'code': code!,
        if (count != null) 'count': count!,
        if (examples != null) 'examples': examples!,
        if (message != null) 'message': message!,
      };
}

/// An example occurrence for a particular error.
class DatafeedStatusExample {
  /// The ID of the example item.
  core.String? itemId;

  /// Line number in the data feed where the example is found.
  core.String? lineNumber;

  /// The problematic value.
  core.String? value;

  DatafeedStatusExample({
    this.itemId,
    this.lineNumber,
    this.value,
  });

  DatafeedStatusExample.fromJson(core.Map json_)
      : this(
          itemId: json_.containsKey('itemId')
              ? json_['itemId'] as core.String
              : null,
          lineNumber: json_.containsKey('lineNumber')
              ? json_['lineNumber'] as core.String
              : null,
          value:
              json_.containsKey('value') ? json_['value'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (itemId != null) 'itemId': itemId!,
        if (lineNumber != null) 'lineNumber': lineNumber!,
        if (value != null) 'value': value!,
      };
}

class DatafeedTarget {
  /// Use `feedLabel` instead.
  ///
  /// The country where the items in the feed will be included in the search
  /// index, represented as a CLDR territory code.
  ///
  /// Deprecated.
  core.String? country;

  /// The list of destinations to exclude for this target (corresponds to
  /// cleared check boxes in Merchant Center).
  ///
  /// Products that are excluded from all destinations for more than 7 days are
  /// automatically deleted.
  core.List<core.String>? excludedDestinations;

  /// Feed label for the DatafeedTarget.
  ///
  /// Either `country` or `feedLabel` is required. If both `feedLabel` and
  /// `country` is specified, the values must match. Must be less than or equal
  /// to 20 uppercase letters (A-Z), numbers (0-9), and dashes (-).
  core.String? feedLabel;

  /// The list of destinations to include for this target (corresponds to
  /// checked check boxes in Merchant Center).
  ///
  /// Default destinations are always included unless provided in
  /// `excludedDestinations`.
  core.List<core.String>? includedDestinations;

  /// The two-letter ISO 639-1 language of the items in the feed.
  ///
  /// Must be a valid language for `targets[].country`.
  core.String? language;

  /// The countries where the items may be displayed.
  ///
  /// Represented as a CLDR territory code. Will be ignored for "product
  /// inventory" feeds.
  core.List<core.String>? targetCountries;

  DatafeedTarget({
    this.country,
    this.excludedDestinations,
    this.feedLabel,
    this.includedDestinations,
    this.language,
    this.targetCountries,
  });

  DatafeedTarget.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          excludedDestinations: json_.containsKey('excludedDestinations')
              ? (json_['excludedDestinations'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          feedLabel: json_.containsKey('feedLabel')
              ? json_['feedLabel'] as core.String
              : null,
          includedDestinations: json_.containsKey('includedDestinations')
              ? (json_['includedDestinations'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          language: json_.containsKey('language')
              ? json_['language'] as core.String
              : null,
          targetCountries: json_.containsKey('targetCountries')
              ? (json_['targetCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (excludedDestinations != null)
          'excludedDestinations': excludedDestinations!,
        if (feedLabel != null) 'feedLabel': feedLabel!,
        if (includedDestinations != null)
          'includedDestinations': includedDestinations!,
        if (language != null) 'language': language!,
        if (targetCountries != null) 'targetCountries': targetCountries!,
      };
}

class DatafeedsCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<DatafeedsCustomBatchRequestEntry>? entries;

  DatafeedsCustomBatchRequest({
    this.entries,
  });

  DatafeedsCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => DatafeedsCustomBatchRequestEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

/// A batch entry encoding a single non-batch datafeeds request.
class DatafeedsCustomBatchRequestEntry {
  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// The data feed to insert.
  Datafeed? datafeed;

  /// The ID of the data feed to get, delete or fetch.
  core.String? datafeedId;

  /// The ID of the managing account.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`delete`" - "`fetchNow`" - "`get`" - "`insert`"
  /// - "`update`"
  core.String? method;

  DatafeedsCustomBatchRequestEntry({
    this.batchId,
    this.datafeed,
    this.datafeedId,
    this.merchantId,
    this.method,
  });

  DatafeedsCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          datafeed: json_.containsKey('datafeed')
              ? Datafeed.fromJson(
                  json_['datafeed'] as core.Map<core.String, core.dynamic>)
              : null,
          datafeedId: json_.containsKey('datafeedId')
              ? json_['datafeedId'] as core.String
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (datafeed != null) 'datafeed': datafeed!,
        if (datafeedId != null) 'datafeedId': datafeedId!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
      };
}

class DatafeedsCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<DatafeedsCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#datafeedsCustomBatchResponse`".
  core.String? kind;

  DatafeedsCustomBatchResponse({
    this.entries,
    this.kind,
  });

  DatafeedsCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => DatafeedsCustomBatchResponseEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

/// A batch entry encoding a single non-batch datafeeds response.
class DatafeedsCustomBatchResponseEntry {
  /// The ID of the request entry this entry responds to.
  core.int? batchId;

  /// The requested data feed.
  ///
  /// Defined if and only if the request was successful.
  Datafeed? datafeed;

  /// A list of errors for failed custombatch entries.
  ///
  /// *Note:* Schema errors fail the whole request.
  Errors? errors;

  DatafeedsCustomBatchResponseEntry({
    this.batchId,
    this.datafeed,
    this.errors,
  });

  DatafeedsCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          datafeed: json_.containsKey('datafeed')
              ? Datafeed.fromJson(
                  json_['datafeed'] as core.Map<core.String, core.dynamic>)
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (datafeed != null) 'datafeed': datafeed!,
        if (errors != null) 'errors': errors!,
      };
}

class DatafeedsFetchNowResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#datafeedsFetchNowResponse`".
  core.String? kind;

  DatafeedsFetchNowResponse({
    this.kind,
  });

  DatafeedsFetchNowResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class DatafeedsListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#datafeedsListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of datafeeds.
  core.String? nextPageToken;
  core.List<Datafeed>? resources;

  DatafeedsListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  DatafeedsListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => Datafeed.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

class DatafeedstatusesCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<DatafeedstatusesCustomBatchRequestEntry>? entries;

  DatafeedstatusesCustomBatchRequest({
    this.entries,
  });

  DatafeedstatusesCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) =>
                      DatafeedstatusesCustomBatchRequestEntry.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

/// A batch entry encoding a single non-batch datafeedstatuses request.
class DatafeedstatusesCustomBatchRequestEntry {
  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// Use `feedLabel` instead.
  ///
  /// The country to get the datafeed status for. If this parameter is provided,
  /// then `language` must also be provided. Note that for multi-target
  /// datafeeds this parameter is required.
  ///
  /// Deprecated.
  core.String? country;

  /// The ID of the data feed to get.
  core.String? datafeedId;

  /// The feed label to get the datafeed status for.
  ///
  /// If this parameter is provided, then `language` must also be provided. Note
  /// that for multi-target datafeeds this parameter is required.
  core.String? feedLabel;

  /// The language to get the datafeed status for.
  ///
  /// If this parameter is provided then `country` must also be provided. Note
  /// that for multi-target datafeeds this parameter is required.
  core.String? language;

  /// The ID of the managing account.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`get`"
  core.String? method;

  DatafeedstatusesCustomBatchRequestEntry({
    this.batchId,
    this.country,
    this.datafeedId,
    this.feedLabel,
    this.language,
    this.merchantId,
    this.method,
  });

  DatafeedstatusesCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          datafeedId: json_.containsKey('datafeedId')
              ? json_['datafeedId'] as core.String
              : null,
          feedLabel: json_.containsKey('feedLabel')
              ? json_['feedLabel'] as core.String
              : null,
          language: json_.containsKey('language')
              ? json_['language'] as core.String
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (country != null) 'country': country!,
        if (datafeedId != null) 'datafeedId': datafeedId!,
        if (feedLabel != null) 'feedLabel': feedLabel!,
        if (language != null) 'language': language!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
      };
}

class DatafeedstatusesCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<DatafeedstatusesCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#datafeedstatusesCustomBatchResponse`".
  core.String? kind;

  DatafeedstatusesCustomBatchResponse({
    this.entries,
    this.kind,
  });

  DatafeedstatusesCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) =>
                      DatafeedstatusesCustomBatchResponseEntry.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

/// A batch entry encoding a single non-batch datafeedstatuses response.
class DatafeedstatusesCustomBatchResponseEntry {
  /// The ID of the request entry this entry responds to.
  core.int? batchId;

  /// The requested data feed status.
  ///
  /// Defined if and only if the request was successful.
  DatafeedStatus? datafeedStatus;

  /// A list of errors for failed custombatch entries.
  ///
  /// *Note:* Schema errors fail the whole request.
  Errors? errors;

  DatafeedstatusesCustomBatchResponseEntry({
    this.batchId,
    this.datafeedStatus,
    this.errors,
  });

  DatafeedstatusesCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          datafeedStatus: json_.containsKey('datafeedStatus')
              ? DatafeedStatus.fromJson(json_['datafeedStatus']
                  as core.Map<core.String, core.dynamic>)
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (datafeedStatus != null) 'datafeedStatus': datafeedStatus!,
        if (errors != null) 'errors': errors!,
      };
}

class DatafeedstatusesListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#datafeedstatusesListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of datafeed statuses.
  core.String? nextPageToken;
  core.List<DatafeedStatus>? resources;

  DatafeedstatusesListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  DatafeedstatusesListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => DatafeedStatus.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

/// Represents a whole or partial calendar date, such as a birthday.
///
/// The time of day and time zone are either specified elsewhere or are
/// insignificant. The date is relative to the Gregorian Calendar. This can
/// represent one of the following: * A full date, with non-zero year, month,
/// and day values. * A month and day, with a zero year (for example, an
/// anniversary). * A year on its own, with a zero month and a zero day. * A
/// year and month, with a zero day (for example, a credit card expiration
/// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
/// google.protobuf.Timestamp
typedef Date = $Date;

/// Represents civil time (or occasionally physical time).
///
/// This type can represent a civil time in one of a few possible ways: * When
/// utc_offset is set and time_zone is unset: a civil time on a calendar day
/// with a particular offset from UTC. * When time_zone is set and utc_offset is
/// unset: a civil time on a calendar day in a particular time zone. * When
/// neither time_zone nor utc_offset is set: a civil time on a calendar day in
/// local time. The date is relative to the Proleptic Gregorian Calendar. If
/// year, month, or day are 0, the DateTime is considered not to have a specific
/// year, month, or day respectively. This type may also be used to represent a
/// physical time if all the date and time fields are set and either case of the
/// `time_offset` oneof is set. Consider using `Timestamp` message for physical
/// time instead. If your use case also would like to store the user's timezone,
/// that can be done in another field. This type is more flexible than some
/// applications may want. Make sure to document and validate your application's
/// limitations.
class DateTime {
  /// Day of month.
  ///
  /// Must be from 1 to 31 and valid for the year and month, or 0 if specifying
  /// a datetime without a day.
  ///
  /// Optional.
  core.int? day;

  /// Hours of day in 24 hour format.
  ///
  /// Should be from 0 to 23, defaults to 0 (midnight). An API may choose to
  /// allow the value "24:00:00" for scenarios like business closing time.
  ///
  /// Optional.
  core.int? hours;

  /// Minutes of hour of day.
  ///
  /// Must be from 0 to 59, defaults to 0.
  ///
  /// Optional.
  core.int? minutes;

  /// Month of year.
  ///
  /// Must be from 1 to 12, or 0 if specifying a datetime without a month.
  ///
  /// Optional.
  core.int? month;

  /// Fractions of seconds in nanoseconds.
  ///
  /// Must be from 0 to 999,999,999, defaults to 0.
  ///
  /// Optional.
  core.int? nanos;

  /// Seconds of minutes of the time.
  ///
  /// Must normally be from 0 to 59, defaults to 0. An API may allow the value
  /// 60 if it allows leap-seconds.
  ///
  /// Optional.
  core.int? seconds;

  /// Time zone.
  TimeZone? timeZone;

  /// UTC offset.
  ///
  /// Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
  /// offset of -4:00 would be represented as { seconds: -14400 }.
  core.String? utcOffset;

  /// Year of date.
  ///
  /// Must be from 1 to 9999, or 0 if specifying a datetime without a year.
  ///
  /// Optional.
  core.int? year;

  DateTime({
    this.day,
    this.hours,
    this.minutes,
    this.month,
    this.nanos,
    this.seconds,
    this.timeZone,
    this.utcOffset,
    this.year,
  });

  DateTime.fromJson(core.Map json_)
      : this(
          day: json_.containsKey('day') ? json_['day'] as core.int : null,
          hours: json_.containsKey('hours') ? json_['hours'] as core.int : null,
          minutes: json_.containsKey('minutes')
              ? json_['minutes'] as core.int
              : null,
          month: json_.containsKey('month') ? json_['month'] as core.int : null,
          nanos: json_.containsKey('nanos') ? json_['nanos'] as core.int : null,
          seconds: json_.containsKey('seconds')
              ? json_['seconds'] as core.int
              : null,
          timeZone: json_.containsKey('timeZone')
              ? TimeZone.fromJson(
                  json_['timeZone'] as core.Map<core.String, core.dynamic>)
              : null,
          utcOffset: json_.containsKey('utcOffset')
              ? json_['utcOffset'] as core.String
              : null,
          year: json_.containsKey('year') ? json_['year'] as core.int : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (day != null) 'day': day!,
        if (hours != null) 'hours': hours!,
        if (minutes != null) 'minutes': minutes!,
        if (month != null) 'month': month!,
        if (nanos != null) 'nanos': nanos!,
        if (seconds != null) 'seconds': seconds!,
        if (timeZone != null) 'timeZone': timeZone!,
        if (utcOffset != null) 'utcOffset': utcOffset!,
        if (year != null) 'year': year!,
      };
}

/// A delivery area for the product.
///
/// Only one of `countryCode` or `postalCodeRange` must be set.
class DeliveryArea {
  /// The country that the product can be delivered to.
  ///
  /// Submit a
  /// [unicode CLDR region](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
  /// such as `US` or `CH`.
  ///
  /// Required.
  core.String? countryCode;

  /// A postal code, postal code range or postal code prefix that defines this
  /// area.
  ///
  /// Limited to US and AUS.
  DeliveryAreaPostalCodeRange? postalCodeRange;

  /// A state, territory, or prefecture.
  ///
  /// This is supported for the United States, Australia, and Japan. Provide a
  /// subdivision code from the ISO 3166-2 code tables
  /// ([US](https://en.wikipedia.org/wiki/ISO_3166-2:US),
  /// [AU](https://en.wikipedia.org/wiki/ISO_3166-2:AU), or
  /// [JP](https://en.wikipedia.org/wiki/ISO_3166-2:JP)) without country prefix
  /// (for example, `"NY"`, `"NSW"`, `"03"`).
  core.String? regionCode;

  DeliveryArea({
    this.countryCode,
    this.postalCodeRange,
    this.regionCode,
  });

  DeliveryArea.fromJson(core.Map json_)
      : this(
          countryCode: json_.containsKey('countryCode')
              ? json_['countryCode'] as core.String
              : null,
          postalCodeRange: json_.containsKey('postalCodeRange')
              ? DeliveryAreaPostalCodeRange.fromJson(json_['postalCodeRange']
                  as core.Map<core.String, core.dynamic>)
              : null,
          regionCode: json_.containsKey('regionCode')
              ? json_['regionCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (countryCode != null) 'countryCode': countryCode!,
        if (postalCodeRange != null) 'postalCodeRange': postalCodeRange!,
        if (regionCode != null) 'regionCode': regionCode!,
      };
}

/// A range of postal codes that defines the delivery area.
///
/// Only set `firstPostalCode` when specifying a single postal code.
class DeliveryAreaPostalCodeRange {
  /// A postal code or a pattern of the form prefix* denoting the inclusive
  /// lower bound of the range defining the area.
  ///
  /// Examples values: `"94108"`, `"9410*"`, `"9*"`.
  ///
  /// Required.
  core.String? firstPostalCode;

  /// A postal code or a pattern of the form prefix* denoting the inclusive
  /// upper bound of the range defining the area (for example \[070* - 078*\]
  /// results in the range \[07000 - 07899\]).
  ///
  /// It must have the same length as `firstPostalCode`: if `firstPostalCode` is
  /// a postal code then `lastPostalCode` must be a postal code too; if
  /// firstPostalCode is a pattern then `lastPostalCode` must be a pattern with
  /// the same prefix length. Ignored if not set, then the area is defined as
  /// being all the postal codes matching `firstPostalCode`.
  core.String? lastPostalCode;

  DeliveryAreaPostalCodeRange({
    this.firstPostalCode,
    this.lastPostalCode,
  });

  DeliveryAreaPostalCodeRange.fromJson(core.Map json_)
      : this(
          firstPostalCode: json_.containsKey('firstPostalCode')
              ? json_['firstPostalCode'] as core.String
              : null,
          lastPostalCode: json_.containsKey('lastPostalCode')
              ? json_['lastPostalCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (firstPostalCode != null) 'firstPostalCode': firstPostalCode!,
        if (lastPostalCode != null) 'lastPostalCode': lastPostalCode!,
      };
}

class DeliveryTime {
  /// Business days cutoff time definition.
  ///
  /// If not configured, the cutoff time will be defaulted to 8AM PST. If local
  /// delivery, use Service.StoreConfig.CutoffConfig.
  CutoffTime? cutoffTime;

  /// The business days during which orders can be handled.
  ///
  /// If not provided, Monday to Friday business days will be assumed.
  BusinessDayConfig? handlingBusinessDayConfig;

  /// Holiday cutoff definitions.
  ///
  /// If configured, they specify order cutoff times for holiday-specific
  /// shipping.
  core.List<HolidayCutoff>? holidayCutoffs;

  /// Maximum number of business days spent before an order is shipped.
  ///
  /// 0 means same day shipped, 1 means next day shipped. Must be greater than
  /// or equal to `minHandlingTimeInDays`.
  core.int? maxHandlingTimeInDays;

  /// Maximum number of business days that are spent in transit.
  ///
  /// 0 means same day delivery, 1 means next day delivery. Must be greater than
  /// or equal to `minTransitTimeInDays`.
  core.int? maxTransitTimeInDays;

  /// Minimum number of business days spent before an order is shipped.
  ///
  /// 0 means same day shipped, 1 means next day shipped.
  core.int? minHandlingTimeInDays;

  /// Minimum number of business days that are spent in transit.
  ///
  /// 0 means same day delivery, 1 means next day delivery. Either
  /// `{min,max}TransitTimeInDays` or `transitTimeTable` must be set, but not
  /// both.
  core.int? minTransitTimeInDays;

  /// The business days during which orders can be in-transit.
  ///
  /// If not provided, Monday to Friday business days will be assumed.
  BusinessDayConfig? transitBusinessDayConfig;

  /// Transit time table, number of business days spent in transit based on row
  /// and column dimensions.
  ///
  /// Either `{min,max}TransitTimeInDays` or `transitTimeTable` can be set, but
  /// not both.
  TransitTable? transitTimeTable;

  /// Indicates that the delivery time should be calculated per warehouse
  /// (shipping origin location) based on the settings of the selected carrier.
  ///
  /// When set, no other transit time related field in DeliveryTime should be
  /// set.
  core.List<WarehouseBasedDeliveryTime>? warehouseBasedDeliveryTimes;

  DeliveryTime({
    this.cutoffTime,
    this.handlingBusinessDayConfig,
    this.holidayCutoffs,
    this.maxHandlingTimeInDays,
    this.maxTransitTimeInDays,
    this.minHandlingTimeInDays,
    this.minTransitTimeInDays,
    this.transitBusinessDayConfig,
    this.transitTimeTable,
    this.warehouseBasedDeliveryTimes,
  });

  DeliveryTime.fromJson(core.Map json_)
      : this(
          cutoffTime: json_.containsKey('cutoffTime')
              ? CutoffTime.fromJson(
                  json_['cutoffTime'] as core.Map<core.String, core.dynamic>)
              : null,
          handlingBusinessDayConfig: json_
                  .containsKey('handlingBusinessDayConfig')
              ? BusinessDayConfig.fromJson(json_['handlingBusinessDayConfig']
                  as core.Map<core.String, core.dynamic>)
              : null,
          holidayCutoffs: json_.containsKey('holidayCutoffs')
              ? (json_['holidayCutoffs'] as core.List)
                  .map((value) => HolidayCutoff.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          maxHandlingTimeInDays: json_.containsKey('maxHandlingTimeInDays')
              ? json_['maxHandlingTimeInDays'] as core.int
              : null,
          maxTransitTimeInDays: json_.containsKey('maxTransitTimeInDays')
              ? json_['maxTransitTimeInDays'] as core.int
              : null,
          minHandlingTimeInDays: json_.containsKey('minHandlingTimeInDays')
              ? json_['minHandlingTimeInDays'] as core.int
              : null,
          minTransitTimeInDays: json_.containsKey('minTransitTimeInDays')
              ? json_['minTransitTimeInDays'] as core.int
              : null,
          transitBusinessDayConfig:
              json_.containsKey('transitBusinessDayConfig')
                  ? BusinessDayConfig.fromJson(json_['transitBusinessDayConfig']
                      as core.Map<core.String, core.dynamic>)
                  : null,
          transitTimeTable: json_.containsKey('transitTimeTable')
              ? TransitTable.fromJson(json_['transitTimeTable']
                  as core.Map<core.String, core.dynamic>)
              : null,
          warehouseBasedDeliveryTimes:
              json_.containsKey('warehouseBasedDeliveryTimes')
                  ? (json_['warehouseBasedDeliveryTimes'] as core.List)
                      .map((value) => WarehouseBasedDeliveryTime.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                      .toList()
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (cutoffTime != null) 'cutoffTime': cutoffTime!,
        if (handlingBusinessDayConfig != null)
          'handlingBusinessDayConfig': handlingBusinessDayConfig!,
        if (holidayCutoffs != null) 'holidayCutoffs': holidayCutoffs!,
        if (maxHandlingTimeInDays != null)
          'maxHandlingTimeInDays': maxHandlingTimeInDays!,
        if (maxTransitTimeInDays != null)
          'maxTransitTimeInDays': maxTransitTimeInDays!,
        if (minHandlingTimeInDays != null)
          'minHandlingTimeInDays': minHandlingTimeInDays!,
        if (minTransitTimeInDays != null)
          'minTransitTimeInDays': minTransitTimeInDays!,
        if (transitBusinessDayConfig != null)
          'transitBusinessDayConfig': transitBusinessDayConfig!,
        if (transitTimeTable != null) 'transitTimeTable': transitTimeTable!,
        if (warehouseBasedDeliveryTimes != null)
          'warehouseBasedDeliveryTimes': warehouseBasedDeliveryTimes!,
      };
}

/// Distance represented by an integer and unit.
class Distance {
  /// The distance unit.
  ///
  /// Acceptable values are `None`, `Miles`, and `Kilometers`.
  core.String? unit;

  /// The distance represented as a number.
  core.String? value;

  Distance({
    this.unit,
    this.value,
  });

  Distance.fromJson(core.Map json_)
      : this(
          unit: json_.containsKey('unit') ? json_['unit'] as core.String : null,
          value:
              json_.containsKey('value') ? json_['value'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (unit != null) 'unit': unit!,
        if (value != null) 'value': value!,
      };
}

/// Additional information required for E_COMMERCE_PLATFORM link type.
class ECommercePlatformLinkInfo {
  /// The id used by the third party service provider to identify the merchant.
  core.String? externalAccountId;

  ECommercePlatformLinkInfo({
    this.externalAccountId,
  });

  ECommercePlatformLinkInfo.fromJson(core.Map json_)
      : this(
          externalAccountId: json_.containsKey('externalAccountId')
              ? json_['externalAccountId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (externalAccountId != null) 'externalAccountId': externalAccountId!,
      };
}

/// An error returned by the API.
class Error {
  /// The domain of the error.
  core.String? domain;

  /// A description of the error.
  core.String? message;

  /// The error code.
  core.String? reason;

  Error({
    this.domain,
    this.message,
    this.reason,
  });

  Error.fromJson(core.Map json_)
      : this(
          domain: json_.containsKey('domain')
              ? json_['domain'] as core.String
              : null,
          message: json_.containsKey('message')
              ? json_['message'] as core.String
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (domain != null) 'domain': domain!,
        if (message != null) 'message': message!,
        if (reason != null) 'reason': reason!,
      };
}

/// A list of errors returned by a failed batch entry.
class Errors {
  /// The HTTP status of the first error in `errors`.
  core.int? code;

  /// A list of errors.
  core.List<Error>? errors;

  /// The message of the first error in `errors`.
  core.String? message;

  Errors({
    this.code,
    this.errors,
    this.message,
  });

  Errors.fromJson(core.Map json_)
      : this(
          code: json_.containsKey('code') ? json_['code'] as core.int : null,
          errors: json_.containsKey('errors')
              ? (json_['errors'] as core.List)
                  .map((value) => Error.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          message: json_.containsKey('message')
              ? json_['message'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (code != null) 'code': code!,
        if (errors != null) 'errors': errors!,
        if (message != null) 'message': message!,
      };
}

/// Action that is implemented and performed outside of the third-party
/// application.
///
/// It should redirect the merchant to the provided URL of an external system
/// where they can perform the action. For example to request a review in the
/// Merchant Center.
class ExternalAction {
  /// The type of external action.
  /// Possible string values are:
  /// - "EXTERNAL_ACTION_TYPE_UNSPECIFIED" : Default value. Will never be
  /// provided by the API.
  /// - "REVIEW_PRODUCT_ISSUE_IN_MERCHANT_CENTER" : Redirect to Merchant Center
  /// where the merchant can request a review for issue related to their
  /// product.
  /// - "REVIEW_ACCOUNT_ISSUE_IN_MERCHANT_CENTER" : Redirect to Merchant Center
  /// where the merchant can request a review for issue related to their
  /// account.
  /// - "LEGAL_APPEAL_IN_HELP_CENTER" : Redirect to the form in Help Center
  /// where the merchant can request a legal appeal for the issue.
  core.String? type;

  /// URL to external system, for example Merchant Center, where the merchant
  /// can perform the action.
  core.String? uri;

  ExternalAction({
    this.type,
    this.uri,
  });

  ExternalAction.fromJson(core.Map json_)
      : this(
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
          uri: json_.containsKey('uri') ? json_['uri'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (type != null) 'type': type!,
        if (uri != null) 'uri': uri!,
      };
}

/// Response message for GetFreeListingsProgramStatus.
class FreeListingsProgramStatus {
  /// State of the program.
  ///
  /// `ENABLED` if there are offers for at least one region.
  /// Possible string values are:
  /// - "PROGRAM_STATE_UNSPECIFIED" : State is unknown.
  /// - "NOT_ENABLED" : Program is not enabled for any country.
  /// - "NO_OFFERS_UPLOADED" : No products have been uploaded for any region.
  /// Upload products to Merchant Center.
  /// - "ENABLED" : Program is enabled and offers are uploaded for at least one
  /// country.
  core.String? globalState;

  /// Status of the program in each region.
  ///
  /// Regions with the same status and review eligibility are grouped together
  /// in `regionCodes`.
  core.List<FreeListingsProgramStatusRegionStatus>? regionStatuses;

  FreeListingsProgramStatus({
    this.globalState,
    this.regionStatuses,
  });

  FreeListingsProgramStatus.fromJson(core.Map json_)
      : this(
          globalState: json_.containsKey('globalState')
              ? json_['globalState'] as core.String
              : null,
          regionStatuses: json_.containsKey('regionStatuses')
              ? (json_['regionStatuses'] as core.List)
                  .map((value) =>
                      FreeListingsProgramStatusRegionStatus.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (globalState != null) 'globalState': globalState!,
        if (regionStatuses != null) 'regionStatuses': regionStatuses!,
      };
}

/// Status of program and region.
class FreeListingsProgramStatusRegionStatus {
  /// Date by which eligibilityStatus will go from `WARNING` to `DISAPPROVED`.
  ///
  /// Only visible when your eligibilityStatus is WARNING. In
  /// [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DD`.
  core.String? disapprovalDate;

  /// Eligibility status of the standard free listing program.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is not known.
  /// - "APPROVED" : If the account has no issues and review is completed
  /// successfully.
  /// - "DISAPPROVED" : There are one or more issues that needs to be resolved
  /// for account to be active for the program. Detailed list of account issues
  /// are available in
  /// [accountstatuses](https://developers.google.com/shopping-content/reference/rest/v2.1/accountstatuses)
  /// API.
  /// - "WARNING" : If account has issues but offers are servable. Some of the
  /// issue can make account DISAPPROVED after a certain deadline.
  /// - "UNDER_REVIEW" : Account is under review.
  /// - "PENDING_REVIEW" : Account is waiting for review to start.
  /// - "ONBOARDING" : Program is currently onboarding. Upload valid offers to
  /// complete onboarding.
  core.String? eligibilityStatus;

  /// Issues that must be fixed to be eligible for review.
  core.List<core.String>? onboardingIssues;

  /// The two-letter \[ISO 3166-1
  /// alpha-2\](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) codes for all
  /// the regions with the same `eligibilityStatus` and `reviewEligibility`.
  core.List<core.String>? regionCodes;

  /// If a program is eligible for review in a specific region.
  ///
  /// Only visible if `eligibilityStatus` is `DISAPPROVED`.
  /// Possible string values are:
  /// - "REVIEW_ELIGIBILITY_UNSPECIFIED" : Review eligibility state is unknown.
  /// - "ELIGIBLE" : Account is eligible for review for a specified region code.
  /// - "INELIGIBLE" : Account is not eligible for review for a specified region
  /// code.
  core.String? reviewEligibilityStatus;

  /// Review ineligibility reason if account is not eligible for review.
  /// Possible string values are:
  /// - "REVIEW_INELIGIBILITY_REASON_UNSPECIFIED" : Requesting a review from
  /// Google is not possible.
  /// - "ONBOARDING_ISSUES" : All onboarding issues needs to be fixed.
  /// - "NOT_ENOUGH_OFFERS" : Not enough offers uploaded for this country.
  /// - "IN_COOLDOWN_PERIOD" : Cooldown period applies. Wait until cooldown
  /// period ends.
  /// - "ALREADY_UNDER_REVIEW" : Account is already under review.
  /// - "NO_REVIEW_REQUIRED" : No issues available to review.
  /// - "WILL_BE_REVIEWED_AUTOMATICALLY" : Account will be automatically
  /// reviewed at the end of the grace period.
  /// - "IS_RETIRED" : Account is retired. Should not appear in MC.
  /// - "ALREADY_REVIEWED" : Account was already reviewd.
  core.String? reviewIneligibilityReason;

  /// Reason a program in a specific region isn’t eligible for review.
  ///
  /// Only visible if `reviewEligibilityStatus` is `INELIGIBLE`.
  core.String? reviewIneligibilityReasonDescription;

  /// Additional information for ineligibility.
  ///
  /// If `reviewIneligibilityReason` is `IN_COOLDOWN_PERIOD`, a timestamp for
  /// the end of the cooldown period is provided.
  FreeListingsProgramStatusReviewIneligibilityReasonDetails?
      reviewIneligibilityReasonDetails;

  /// Issues evaluated in the review process.
  ///
  /// Fix all issues before requesting a review.
  core.List<core.String>? reviewIssues;

  FreeListingsProgramStatusRegionStatus({
    this.disapprovalDate,
    this.eligibilityStatus,
    this.onboardingIssues,
    this.regionCodes,
    this.reviewEligibilityStatus,
    this.reviewIneligibilityReason,
    this.reviewIneligibilityReasonDescription,
    this.reviewIneligibilityReasonDetails,
    this.reviewIssues,
  });

  FreeListingsProgramStatusRegionStatus.fromJson(core.Map json_)
      : this(
          disapprovalDate: json_.containsKey('disapprovalDate')
              ? json_['disapprovalDate'] as core.String
              : null,
          eligibilityStatus: json_.containsKey('eligibilityStatus')
              ? json_['eligibilityStatus'] as core.String
              : null,
          onboardingIssues: json_.containsKey('onboardingIssues')
              ? (json_['onboardingIssues'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          regionCodes: json_.containsKey('regionCodes')
              ? (json_['regionCodes'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          reviewEligibilityStatus: json_.containsKey('reviewEligibilityStatus')
              ? json_['reviewEligibilityStatus'] as core.String
              : null,
          reviewIneligibilityReason:
              json_.containsKey('reviewIneligibilityReason')
                  ? json_['reviewIneligibilityReason'] as core.String
                  : null,
          reviewIneligibilityReasonDescription:
              json_.containsKey('reviewIneligibilityReasonDescription')
                  ? json_['reviewIneligibilityReasonDescription'] as core.String
                  : null,
          reviewIneligibilityReasonDetails:
              json_.containsKey('reviewIneligibilityReasonDetails')
                  ? FreeListingsProgramStatusReviewIneligibilityReasonDetails
                      .fromJson(json_['reviewIneligibilityReasonDetails']
                          as core.Map<core.String, core.dynamic>)
                  : null,
          reviewIssues: json_.containsKey('reviewIssues')
              ? (json_['reviewIssues'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (disapprovalDate != null) 'disapprovalDate': disapprovalDate!,
        if (eligibilityStatus != null) 'eligibilityStatus': eligibilityStatus!,
        if (onboardingIssues != null) 'onboardingIssues': onboardingIssues!,
        if (regionCodes != null) 'regionCodes': regionCodes!,
        if (reviewEligibilityStatus != null)
          'reviewEligibilityStatus': reviewEligibilityStatus!,
        if (reviewIneligibilityReason != null)
          'reviewIneligibilityReason': reviewIneligibilityReason!,
        if (reviewIneligibilityReasonDescription != null)
          'reviewIneligibilityReasonDescription':
              reviewIneligibilityReasonDescription!,
        if (reviewIneligibilityReasonDetails != null)
          'reviewIneligibilityReasonDetails': reviewIneligibilityReasonDetails!,
        if (reviewIssues != null) 'reviewIssues': reviewIssues!,
      };
}

/// Additional details for review ineligibility reasons.
typedef FreeListingsProgramStatusReviewIneligibilityReasonDetails
    = $ProgramStatusReviewIneligibilityReasonDetails;

/// Response containing generated recommendations.
class GenerateRecommendationsResponse {
  /// Recommendations generated for a request.
  core.List<Recommendation>? recommendations;

  /// Response token is a string created for each
  /// `GenerateRecommendationsResponse`.
  ///
  /// This token doesn't expire, and is globally unique. This token must be used
  /// when reporting interactions for recommendations.
  ///
  /// Output only.
  core.String? responseToken;

  GenerateRecommendationsResponse({
    this.recommendations,
    this.responseToken,
  });

  GenerateRecommendationsResponse.fromJson(core.Map json_)
      : this(
          recommendations: json_.containsKey('recommendations')
              ? (json_['recommendations'] as core.List)
                  .map((value) => Recommendation.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          responseToken: json_.containsKey('responseToken')
              ? json_['responseToken'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (recommendations != null) 'recommendations': recommendations!,
        if (responseToken != null) 'responseToken': responseToken!,
      };
}

class GmbAccounts {
  /// The ID of the Merchant Center account.
  core.String? accountId;

  /// A list of Business Profiles which are available to the merchant.
  core.List<GmbAccountsGmbAccount>? gmbAccounts;

  GmbAccounts({
    this.accountId,
    this.gmbAccounts,
  });

  GmbAccounts.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          gmbAccounts: json_.containsKey('gmbAccounts')
              ? (json_['gmbAccounts'] as core.List)
                  .map((value) => GmbAccountsGmbAccount.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (gmbAccounts != null) 'gmbAccounts': gmbAccounts!,
      };
}

class GmbAccountsGmbAccount {
  /// The email which identifies the Business Profile.
  core.String? email;

  /// Number of listings under this account.
  core.String? listingCount;

  /// The name of the Business Profile.
  core.String? name;

  /// The type of the Business Profile (User or Business).
  core.String? type;

  GmbAccountsGmbAccount({
    this.email,
    this.listingCount,
    this.name,
    this.type,
  });

  GmbAccountsGmbAccount.fromJson(core.Map json_)
      : this(
          email:
              json_.containsKey('email') ? json_['email'] as core.String : null,
          listingCount: json_.containsKey('listingCount')
              ? json_['listingCount'] as core.String
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (email != null) 'email': email!,
        if (listingCount != null) 'listingCount': listingCount!,
        if (name != null) 'name': name!,
        if (type != null) 'type': type!,
      };
}

/// "Google Analytics Link" sources can be used to get conversion data from an
/// existing Google Analytics property into the linked Merchant Center account.
class GoogleAnalyticsLink {
  /// Attribution settings for the linked Google Analytics property.
  ///
  /// Output only.
  AttributionSettings? attributionSettings;

  /// ID of the Google Analytics property the merchant is linked to.
  ///
  /// Required. Immutable.
  core.String? propertyId;

  /// Name of the Google Analytics property the merchant is linked to.
  ///
  /// Output only.
  core.String? propertyName;

  GoogleAnalyticsLink({
    this.attributionSettings,
    this.propertyId,
    this.propertyName,
  });

  GoogleAnalyticsLink.fromJson(core.Map json_)
      : this(
          attributionSettings: json_.containsKey('attributionSettings')
              ? AttributionSettings.fromJson(json_['attributionSettings']
                  as core.Map<core.String, core.dynamic>)
              : null,
          propertyId: json_.containsKey('propertyId')
              ? json_['propertyId'] as core.String
              : null,
          propertyName: json_.containsKey('propertyName')
              ? json_['propertyName'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributionSettings != null)
          'attributionSettings': attributionSettings!,
        if (propertyId != null) 'propertyId': propertyId!,
        if (propertyName != null) 'propertyName': propertyName!,
      };
}

/// A non-empty list of row or column headers for a table.
///
/// Exactly one of `prices`, `weights`, `numItems`, `postalCodeGroupNames`, or
/// `location` must be set.
class Headers {
  /// A list of location ID sets.
  ///
  /// Must be non-empty. Can only be set if all other fields are not set.
  core.List<LocationIdSet>? locations;

  /// A list of inclusive number of items upper bounds.
  ///
  /// The last value can be `"infinity"`. For example `["10", "50", "infinity"]`
  /// represents the headers "\<= 10 items", "\<= 50 items", and "\> 50 items".
  /// Must be non-empty. Can only be set if all other fields are not set.
  core.List<core.String>? numberOfItems;

  /// A list of postal group names.
  ///
  /// The last value can be `"all other locations"`. Example: `["zone 1", "zone
  /// 2", "all other locations"]`. The referred postal code groups must match
  /// the delivery country of the service. Must be non-empty. Can only be set if
  /// all other fields are not set.
  core.List<core.String>? postalCodeGroupNames;

  /// A list of inclusive order price upper bounds.
  ///
  /// The last price's value can be `"infinity"`. For example `[{"value": "10",
  /// "currency": "USD"}, {"value": "500", "currency": "USD"}, {"value":
  /// "infinity", "currency": "USD"}]` represents the headers "\<= $10", "\<=
  /// $500", and "\> $500". All prices within a service must have the same
  /// currency. Must be non-empty. Can only be set if all other fields are not
  /// set.
  core.List<Price>? prices;

  /// A list of inclusive order weight upper bounds.
  ///
  /// The last weight's value can be `"infinity"`. For example `[{"value": "10",
  /// "unit": "kg"}, {"value": "50", "unit": "kg"}, {"value": "infinity",
  /// "unit": "kg"}]` represents the headers "\<= 10kg", "\<= 50kg", and "\>
  /// 50kg". All weights within a service must have the same unit. Must be
  /// non-empty. Can only be set if all other fields are not set.
  core.List<Weight>? weights;

  Headers({
    this.locations,
    this.numberOfItems,
    this.postalCodeGroupNames,
    this.prices,
    this.weights,
  });

  Headers.fromJson(core.Map json_)
      : this(
          locations: json_.containsKey('locations')
              ? (json_['locations'] as core.List)
                  .map((value) => LocationIdSet.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          numberOfItems: json_.containsKey('numberOfItems')
              ? (json_['numberOfItems'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          postalCodeGroupNames: json_.containsKey('postalCodeGroupNames')
              ? (json_['postalCodeGroupNames'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          prices: json_.containsKey('prices')
              ? (json_['prices'] as core.List)
                  .map((value) => Price.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          weights: json_.containsKey('weights')
              ? (json_['weights'] as core.List)
                  .map((value) => Weight.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (locations != null) 'locations': locations!,
        if (numberOfItems != null) 'numberOfItems': numberOfItems!,
        if (postalCodeGroupNames != null)
          'postalCodeGroupNames': postalCodeGroupNames!,
        if (prices != null) 'prices': prices!,
        if (weights != null) 'weights': weights!,
      };
}

class HolidayCutoff {
  /// Date of the order deadline, in ISO 8601 format.
  ///
  /// For example, "2016-11-29" for 29th November 2016. Required.
  core.String? deadlineDate;

  /// Hour of the day on the deadline date until which the order has to be
  /// placed to qualify for the delivery guarantee.
  ///
  /// Possible values are: 0 (midnight), 1, ..., 12 (noon), 13, ..., 23.
  /// Required.
  core.int? deadlineHour;

  /// Timezone identifier for the deadline hour (for example, "Europe/Zurich").
  ///
  /// List of identifiers. Required.
  core.String? deadlineTimezone;

  /// Unique identifier for the holiday.
  ///
  /// Required.
  core.String? holidayId;

  /// Date on which the deadline will become visible to consumers in ISO 8601
  /// format.
  ///
  /// For example, "2016-10-31" for 31st October 2016. Required.
  core.String? visibleFromDate;

  HolidayCutoff({
    this.deadlineDate,
    this.deadlineHour,
    this.deadlineTimezone,
    this.holidayId,
    this.visibleFromDate,
  });

  HolidayCutoff.fromJson(core.Map json_)
      : this(
          deadlineDate: json_.containsKey('deadlineDate')
              ? json_['deadlineDate'] as core.String
              : null,
          deadlineHour: json_.containsKey('deadlineHour')
              ? json_['deadlineHour'] as core.int
              : null,
          deadlineTimezone: json_.containsKey('deadlineTimezone')
              ? json_['deadlineTimezone'] as core.String
              : null,
          holidayId: json_.containsKey('holidayId')
              ? json_['holidayId'] as core.String
              : null,
          visibleFromDate: json_.containsKey('visibleFromDate')
              ? json_['visibleFromDate'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deadlineDate != null) 'deadlineDate': deadlineDate!,
        if (deadlineHour != null) 'deadlineHour': deadlineHour!,
        if (deadlineTimezone != null) 'deadlineTimezone': deadlineTimezone!,
        if (holidayId != null) 'holidayId': holidayId!,
        if (visibleFromDate != null) 'visibleFromDate': visibleFromDate!,
      };
}

class HolidaysHoliday {
  /// The CLDR territory code of the country in which the holiday is available.
  ///
  /// For example, "US", "DE", "GB". A holiday cutoff can only be configured in
  /// a shipping settings service with matching delivery country. Always
  /// present.
  core.String? countryCode;

  /// Date of the holiday, in ISO 8601 format.
  ///
  /// For example, "2016-12-25" for Christmas 2016. Always present.
  core.String? date;

  /// Date on which the order has to arrive at the customer's, in ISO 8601
  /// format.
  ///
  /// For example, "2016-12-24" for 24th December 2016. Always present.
  core.String? deliveryGuaranteeDate;

  /// Hour of the day in the delivery location's timezone on the guaranteed
  /// delivery date by which the order has to arrive at the customer's.
  ///
  /// Possible values are: 0 (midnight), 1, ..., 12 (noon), 13, ..., 23. Always
  /// present.
  core.String? deliveryGuaranteeHour;

  /// Unique identifier for the holiday to be used when configuring holiday
  /// cutoffs.
  ///
  /// Always present.
  core.String? id;

  /// The holiday type.
  ///
  /// Always present. Acceptable values are: - "`Christmas`" - "`Easter`" -
  /// "`Father's Day`" - "`Halloween`" - "`Independence Day (USA)`" - "`Mother's
  /// Day`" - "`Thanksgiving`" - "`Valentine's Day`"
  core.String? type;

  HolidaysHoliday({
    this.countryCode,
    this.date,
    this.deliveryGuaranteeDate,
    this.deliveryGuaranteeHour,
    this.id,
    this.type,
  });

  HolidaysHoliday.fromJson(core.Map json_)
      : this(
          countryCode: json_.containsKey('countryCode')
              ? json_['countryCode'] as core.String
              : null,
          date: json_.containsKey('date') ? json_['date'] as core.String : null,
          deliveryGuaranteeDate: json_.containsKey('deliveryGuaranteeDate')
              ? json_['deliveryGuaranteeDate'] as core.String
              : null,
          deliveryGuaranteeHour: json_.containsKey('deliveryGuaranteeHour')
              ? json_['deliveryGuaranteeHour'] as core.String
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (countryCode != null) 'countryCode': countryCode!,
        if (date != null) 'date': date!,
        if (deliveryGuaranteeDate != null)
          'deliveryGuaranteeDate': deliveryGuaranteeDate!,
        if (deliveryGuaranteeHour != null)
          'deliveryGuaranteeHour': deliveryGuaranteeHour!,
        if (id != null) 'id': id!,
        if (type != null) 'type': type!,
      };
}

/// Map of inapplicability details.
class InapplicabilityDetails {
  /// Count of this inapplicable reason code.
  core.String? inapplicableCount;

  /// Reason code this rule was not applicable.
  /// Possible string values are:
  /// - "INAPPLICABLE_REASON_UNSPECIFIED" : Default value. Should not be used.
  /// - "CANNOT_BEAT_BUYBOX_WINNER" : The rule set for this product cannot beat
  /// the buybox winner.
  /// - "ALREADY_WINNING_BUYBOX" : This product can already win the buybox
  /// without rule.
  /// - "TRIUMPHED_OVER_BY_SAME_TYPE_RULE" : Another rule of the same type takes
  /// precedence over this one.
  /// - "TRIUMPHED_OVER_BY_OTHER_RULE_ON_OFFER" : Another rule of a different
  /// type takes precedence over this one.
  /// - "RESTRICTIONS_NOT_MET" : The rule restrictions are not met. For example,
  /// this may be the case if the calculated rule price is lower than floor
  /// price in the restriction.
  /// - "UNCATEGORIZED" : The reason is not categorized to any known reason.
  /// - "INVALID_AUTO_PRICE_MIN" : The auto_pricing_min_price is invalid. For
  /// example, it is missing or \< 0.
  /// - "INVALID_FLOOR_CONFIG" : The floor defined in the rule is invalid. For
  /// example, it has the wrong sign which results in a floor \< 0.
  core.String? inapplicableReason;

  InapplicabilityDetails({
    this.inapplicableCount,
    this.inapplicableReason,
  });

  InapplicabilityDetails.fromJson(core.Map json_)
      : this(
          inapplicableCount: json_.containsKey('inapplicableCount')
              ? json_['inapplicableCount'] as core.String
              : null,
          inapplicableReason: json_.containsKey('inapplicableReason')
              ? json_['inapplicableReason'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (inapplicableCount != null) 'inapplicableCount': inapplicableCount!,
        if (inapplicableReason != null)
          'inapplicableReason': inapplicableReason!,
      };
}

/// Request message for the `InsertCheckoutSettings` method.
class InsertCheckoutSettingsRequest {
  /// The `UrlSettings` for the request.
  ///
  /// The presence of URL settings indicates `Checkout` enrollment.
  ///
  /// Required.
  UrlSettings? uriSettings;

  InsertCheckoutSettingsRequest({
    this.uriSettings,
  });

  InsertCheckoutSettingsRequest.fromJson(core.Map json_)
      : this(
          uriSettings: json_.containsKey('uriSettings')
              ? UrlSettings.fromJson(
                  json_['uriSettings'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (uriSettings != null) 'uriSettings': uriSettings!,
      };
}

class Installment {
  /// The amount the buyer has to pay per month.
  Price? amount;

  /// The number of installments the buyer has to pay.
  core.String? months;

  Installment({
    this.amount,
    this.months,
  });

  Installment.fromJson(core.Map json_)
      : this(
          amount: json_.containsKey('amount')
              ? Price.fromJson(
                  json_['amount'] as core.Map<core.String, core.dynamic>)
              : null,
          months: json_.containsKey('months')
              ? json_['months'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (amount != null) 'amount': amount!,
        if (months != null) 'months': months!,
      };
}

class InvoiceSummary {
  /// Summary of the total amounts of the additional charges.
  core.List<InvoiceSummaryAdditionalChargeSummary>? additionalChargeSummaries;

  /// Total price for the product.
  ///
  /// Required.
  Amount? productTotal;

  InvoiceSummary({
    this.additionalChargeSummaries,
    this.productTotal,
  });

  InvoiceSummary.fromJson(core.Map json_)
      : this(
          additionalChargeSummaries:
              json_.containsKey('additionalChargeSummaries')
                  ? (json_['additionalChargeSummaries'] as core.List)
                      .map((value) =>
                          InvoiceSummaryAdditionalChargeSummary.fromJson(
                              value as core.Map<core.String, core.dynamic>))
                      .toList()
                  : null,
          productTotal: json_.containsKey('productTotal')
              ? Amount.fromJson(
                  json_['productTotal'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (additionalChargeSummaries != null)
          'additionalChargeSummaries': additionalChargeSummaries!,
        if (productTotal != null) 'productTotal': productTotal!,
      };
}

class InvoiceSummaryAdditionalChargeSummary {
  /// Total additional charge for this type.
  ///
  /// Required.
  Amount? totalAmount;

  /// Type of the additional charge.
  ///
  /// Acceptable values are: - "`shipping`"
  ///
  /// Required.
  core.String? type;

  InvoiceSummaryAdditionalChargeSummary({
    this.totalAmount,
    this.type,
  });

  InvoiceSummaryAdditionalChargeSummary.fromJson(core.Map json_)
      : this(
          totalAmount: json_.containsKey('totalAmount')
              ? Amount.fromJson(
                  json_['totalAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (totalAmount != null) 'totalAmount': totalAmount!,
        if (type != null) 'type': type!,
      };
}

/// The IDs of labels that should be assigned to the CSS domain.
class LabelIds {
  /// The list of label IDs.
  core.List<core.String>? labelIds;

  LabelIds({
    this.labelIds,
  });

  LabelIds.fromJson(core.Map json_)
      : this(
          labelIds: json_.containsKey('labelIds')
              ? (json_['labelIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (labelIds != null) 'labelIds': labelIds!,
      };
}

class LiaAboutPageSettings {
  /// The status of the verification process for the About page.
  ///
  /// Acceptable values are: - "`active`" - "`inactive`" - "`pending`"
  core.String? status;

  /// The URL for the About page.
  core.String? url;

  LiaAboutPageSettings({
    this.status,
    this.url,
  });

  LiaAboutPageSettings.fromJson(core.Map json_)
      : this(
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
          url: json_.containsKey('url') ? json_['url'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (status != null) 'status': status!,
        if (url != null) 'url': url!,
      };
}

class LiaCountrySettings {
  /// The settings for the About page.
  LiaAboutPageSettings? about;

  /// CLDR country code (for example, "US").
  ///
  /// Required.
  core.String? country;

  /// The status of the "Merchant hosted local storefront" feature.
  core.bool? hostedLocalStorefrontActive;

  /// LIA inventory verification settings.
  LiaInventorySettings? inventory;

  /// The omnichannel experience configured for this country.
  LiaOmnichannelExperience? omnichannelExperience;

  /// LIA "On Display To Order" settings.
  LiaOnDisplayToOrderSettings? onDisplayToOrder;

  /// The POS data provider linked with this country.
  LiaPosDataProvider? posDataProvider;

  /// The status of the "Store pickup" feature.
  core.bool? storePickupActive;

  LiaCountrySettings({
    this.about,
    this.country,
    this.hostedLocalStorefrontActive,
    this.inventory,
    this.omnichannelExperience,
    this.onDisplayToOrder,
    this.posDataProvider,
    this.storePickupActive,
  });

  LiaCountrySettings.fromJson(core.Map json_)
      : this(
          about: json_.containsKey('about')
              ? LiaAboutPageSettings.fromJson(
                  json_['about'] as core.Map<core.String, core.dynamic>)
              : null,
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          hostedLocalStorefrontActive:
              json_.containsKey('hostedLocalStorefrontActive')
                  ? json_['hostedLocalStorefrontActive'] as core.bool
                  : null,
          inventory: json_.containsKey('inventory')
              ? LiaInventorySettings.fromJson(
                  json_['inventory'] as core.Map<core.String, core.dynamic>)
              : null,
          omnichannelExperience: json_.containsKey('omnichannelExperience')
              ? LiaOmnichannelExperience.fromJson(json_['omnichannelExperience']
                  as core.Map<core.String, core.dynamic>)
              : null,
          onDisplayToOrder: json_.containsKey('onDisplayToOrder')
              ? LiaOnDisplayToOrderSettings.fromJson(json_['onDisplayToOrder']
                  as core.Map<core.String, core.dynamic>)
              : null,
          posDataProvider: json_.containsKey('posDataProvider')
              ? LiaPosDataProvider.fromJson(json_['posDataProvider']
                  as core.Map<core.String, core.dynamic>)
              : null,
          storePickupActive: json_.containsKey('storePickupActive')
              ? json_['storePickupActive'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (about != null) 'about': about!,
        if (country != null) 'country': country!,
        if (hostedLocalStorefrontActive != null)
          'hostedLocalStorefrontActive': hostedLocalStorefrontActive!,
        if (inventory != null) 'inventory': inventory!,
        if (omnichannelExperience != null)
          'omnichannelExperience': omnichannelExperience!,
        if (onDisplayToOrder != null) 'onDisplayToOrder': onDisplayToOrder!,
        if (posDataProvider != null) 'posDataProvider': posDataProvider!,
        if (storePickupActive != null) 'storePickupActive': storePickupActive!,
      };
}

class LiaInventorySettings {
  /// The email of the contact for the inventory verification process.
  core.String? inventoryVerificationContactEmail;

  /// The name of the contact for the inventory verification process.
  core.String? inventoryVerificationContactName;

  /// The status of the verification contact.
  ///
  /// Acceptable values are: - "`active`" - "`inactive`" - "`pending`"
  core.String? inventoryVerificationContactStatus;

  /// The status of the inventory verification process.
  ///
  /// Acceptable values are: - "`active`" - "`inactive`" - "`pending`"
  core.String? status;

  LiaInventorySettings({
    this.inventoryVerificationContactEmail,
    this.inventoryVerificationContactName,
    this.inventoryVerificationContactStatus,
    this.status,
  });

  LiaInventorySettings.fromJson(core.Map json_)
      : this(
          inventoryVerificationContactEmail:
              json_.containsKey('inventoryVerificationContactEmail')
                  ? json_['inventoryVerificationContactEmail'] as core.String
                  : null,
          inventoryVerificationContactName:
              json_.containsKey('inventoryVerificationContactName')
                  ? json_['inventoryVerificationContactName'] as core.String
                  : null,
          inventoryVerificationContactStatus:
              json_.containsKey('inventoryVerificationContactStatus')
                  ? json_['inventoryVerificationContactStatus'] as core.String
                  : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (inventoryVerificationContactEmail != null)
          'inventoryVerificationContactEmail':
              inventoryVerificationContactEmail!,
        if (inventoryVerificationContactName != null)
          'inventoryVerificationContactName': inventoryVerificationContactName!,
        if (inventoryVerificationContactStatus != null)
          'inventoryVerificationContactStatus':
              inventoryVerificationContactStatus!,
        if (status != null) 'status': status!,
      };
}

/// Omnichannel experience details.
class LiaOmnichannelExperience {
  /// The CLDR country code (for example, "US").
  core.String? country;

  /// The Local Store Front (LSF) type for this country.
  ///
  /// Acceptable values are: - "`ghlsf`" (Google-Hosted Local Store Front) -
  /// "`mhlsfBasic`" (Merchant-Hosted Local Store Front Basic) - "`mhlsfFull`"
  /// (Merchant-Hosted Local Store Front Full) More details about these types
  /// can be found here.
  core.String? lsfType;

  /// The Pickup types for this country.
  ///
  /// Acceptable values are: - "`pickupToday`" - "`pickupLater`"
  core.List<core.String>? pickupTypes;

  LiaOmnichannelExperience({
    this.country,
    this.lsfType,
    this.pickupTypes,
  });

  LiaOmnichannelExperience.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          lsfType: json_.containsKey('lsfType')
              ? json_['lsfType'] as core.String
              : null,
          pickupTypes: json_.containsKey('pickupTypes')
              ? (json_['pickupTypes'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (lsfType != null) 'lsfType': lsfType!,
        if (pickupTypes != null) 'pickupTypes': pickupTypes!,
      };
}

class LiaOnDisplayToOrderSettings {
  /// Shipping cost and policy URL.
  core.String? shippingCostPolicyUrl;

  /// The status of the ?On display to order? feature.
  ///
  /// Acceptable values are: - "`active`" - "`inactive`" - "`pending`"
  core.String? status;

  LiaOnDisplayToOrderSettings({
    this.shippingCostPolicyUrl,
    this.status,
  });

  LiaOnDisplayToOrderSettings.fromJson(core.Map json_)
      : this(
          shippingCostPolicyUrl: json_.containsKey('shippingCostPolicyUrl')
              ? json_['shippingCostPolicyUrl'] as core.String
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (shippingCostPolicyUrl != null)
          'shippingCostPolicyUrl': shippingCostPolicyUrl!,
        if (status != null) 'status': status!,
      };
}

class LiaPosDataProvider {
  /// The ID of the POS data provider.
  core.String? posDataProviderId;

  /// The account ID by which this merchant is known to the POS data provider.
  core.String? posExternalAccountId;

  LiaPosDataProvider({
    this.posDataProviderId,
    this.posExternalAccountId,
  });

  LiaPosDataProvider.fromJson(core.Map json_)
      : this(
          posDataProviderId: json_.containsKey('posDataProviderId')
              ? json_['posDataProviderId'] as core.String
              : null,
          posExternalAccountId: json_.containsKey('posExternalAccountId')
              ? json_['posExternalAccountId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (posDataProviderId != null) 'posDataProviderId': posDataProviderId!,
        if (posExternalAccountId != null)
          'posExternalAccountId': posExternalAccountId!,
      };
}

/// Local Inventory ads (LIA) settings.
///
/// All methods except listposdataproviders require the admin role.
class LiaSettings {
  /// The ID of the account to which these LIA settings belong.
  ///
  /// Ignored upon update, always present in get request responses.
  core.String? accountId;

  /// The LIA settings for each country.
  core.List<LiaCountrySettings>? countrySettings;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#liaSettings`"
  core.String? kind;

  LiaSettings({
    this.accountId,
    this.countrySettings,
    this.kind,
  });

  LiaSettings.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          countrySettings: json_.containsKey('countrySettings')
              ? (json_['countrySettings'] as core.List)
                  .map((value) => LiaCountrySettings.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (countrySettings != null) 'countrySettings': countrySettings!,
        if (kind != null) 'kind': kind!,
      };
}

class LiasettingsCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<LiasettingsCustomBatchRequestEntry>? entries;

  LiasettingsCustomBatchRequest({
    this.entries,
  });

  LiasettingsCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => LiasettingsCustomBatchRequestEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

class LiasettingsCustomBatchRequestEntry {
  /// The ID of the account for which to get/update account LIA settings.
  core.String? accountId;

  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// Inventory validation contact email.
  ///
  /// Required only for SetInventoryValidationContact.
  core.String? contactEmail;

  /// Inventory validation contact name.
  ///
  /// Required only for SetInventoryValidationContact.
  core.String? contactName;

  /// The country code.
  ///
  /// Required only for RequestInventoryVerification.
  core.String? country;

  /// The Business Profile.
  ///
  /// Required only for RequestGmbAccess.
  core.String? gmbEmail;

  /// The account Lia settings to update.
  ///
  /// Only defined if the method is `update`.
  LiaSettings? liaSettings;

  /// The ID of the managing account.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`get`" - "`getAccessibleGmbAccounts`" -
  /// "`requestGmbAccess`" - "`requestInventoryVerification`" -
  /// "`setInventoryVerificationContact`" - "`update`"
  core.String? method;

  /// The omnichannel experience for a country.
  ///
  /// Required only for SetOmnichannelExperience.
  LiaOmnichannelExperience? omnichannelExperience;

  /// The ID of POS data provider.
  ///
  /// Required only for SetPosProvider.
  core.String? posDataProviderId;

  /// The account ID by which this merchant is known to the POS provider.
  core.String? posExternalAccountId;

  LiasettingsCustomBatchRequestEntry({
    this.accountId,
    this.batchId,
    this.contactEmail,
    this.contactName,
    this.country,
    this.gmbEmail,
    this.liaSettings,
    this.merchantId,
    this.method,
    this.omnichannelExperience,
    this.posDataProviderId,
    this.posExternalAccountId,
  });

  LiasettingsCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          contactEmail: json_.containsKey('contactEmail')
              ? json_['contactEmail'] as core.String
              : null,
          contactName: json_.containsKey('contactName')
              ? json_['contactName'] as core.String
              : null,
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          gmbEmail: json_.containsKey('gmbEmail')
              ? json_['gmbEmail'] as core.String
              : null,
          liaSettings: json_.containsKey('liaSettings')
              ? LiaSettings.fromJson(
                  json_['liaSettings'] as core.Map<core.String, core.dynamic>)
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
          omnichannelExperience: json_.containsKey('omnichannelExperience')
              ? LiaOmnichannelExperience.fromJson(json_['omnichannelExperience']
                  as core.Map<core.String, core.dynamic>)
              : null,
          posDataProviderId: json_.containsKey('posDataProviderId')
              ? json_['posDataProviderId'] as core.String
              : null,
          posExternalAccountId: json_.containsKey('posExternalAccountId')
              ? json_['posExternalAccountId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (batchId != null) 'batchId': batchId!,
        if (contactEmail != null) 'contactEmail': contactEmail!,
        if (contactName != null) 'contactName': contactName!,
        if (country != null) 'country': country!,
        if (gmbEmail != null) 'gmbEmail': gmbEmail!,
        if (liaSettings != null) 'liaSettings': liaSettings!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
        if (omnichannelExperience != null)
          'omnichannelExperience': omnichannelExperience!,
        if (posDataProviderId != null) 'posDataProviderId': posDataProviderId!,
        if (posExternalAccountId != null)
          'posExternalAccountId': posExternalAccountId!,
      };
}

class LiasettingsCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<LiasettingsCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#liasettingsCustomBatchResponse`".
  core.String? kind;

  LiasettingsCustomBatchResponse({
    this.entries,
    this.kind,
  });

  LiasettingsCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => LiasettingsCustomBatchResponseEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

class LiasettingsCustomBatchResponseEntry {
  /// The ID of the request entry to which this entry responds.
  core.int? batchId;

  /// A list of errors defined if, and only if, the request failed.
  Errors? errors;

  /// The list of accessible Business Profiles.
  GmbAccounts? gmbAccounts;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#liasettingsCustomBatchResponseEntry`"
  core.String? kind;

  /// The retrieved or updated Lia settings.
  LiaSettings? liaSettings;

  /// The updated omnichannel experience for a country.
  LiaOmnichannelExperience? omnichannelExperience;

  /// The list of POS data providers.
  core.List<PosDataProviders>? posDataProviders;

  LiasettingsCustomBatchResponseEntry({
    this.batchId,
    this.errors,
    this.gmbAccounts,
    this.kind,
    this.liaSettings,
    this.omnichannelExperience,
    this.posDataProviders,
  });

  LiasettingsCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
          gmbAccounts: json_.containsKey('gmbAccounts')
              ? GmbAccounts.fromJson(
                  json_['gmbAccounts'] as core.Map<core.String, core.dynamic>)
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          liaSettings: json_.containsKey('liaSettings')
              ? LiaSettings.fromJson(
                  json_['liaSettings'] as core.Map<core.String, core.dynamic>)
              : null,
          omnichannelExperience: json_.containsKey('omnichannelExperience')
              ? LiaOmnichannelExperience.fromJson(json_['omnichannelExperience']
                  as core.Map<core.String, core.dynamic>)
              : null,
          posDataProviders: json_.containsKey('posDataProviders')
              ? (json_['posDataProviders'] as core.List)
                  .map((value) => PosDataProviders.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (errors != null) 'errors': errors!,
        if (gmbAccounts != null) 'gmbAccounts': gmbAccounts!,
        if (kind != null) 'kind': kind!,
        if (liaSettings != null) 'liaSettings': liaSettings!,
        if (omnichannelExperience != null)
          'omnichannelExperience': omnichannelExperience!,
        if (posDataProviders != null) 'posDataProviders': posDataProviders!,
      };
}

class LiasettingsGetAccessibleGmbAccountsResponse {
  /// The ID of the Merchant Center account.
  core.String? accountId;

  /// A list of Business Profiles which are available to the merchant.
  core.List<GmbAccountsGmbAccount>? gmbAccounts;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#liasettingsGetAccessibleGmbAccountsResponse`".
  core.String? kind;

  LiasettingsGetAccessibleGmbAccountsResponse({
    this.accountId,
    this.gmbAccounts,
    this.kind,
  });

  LiasettingsGetAccessibleGmbAccountsResponse.fromJson(core.Map json_)
      : this(
          accountId: json_.containsKey('accountId')
              ? json_['accountId'] as core.String
              : null,
          gmbAccounts: json_.containsKey('gmbAccounts')
              ? (json_['gmbAccounts'] as core.List)
                  .map((value) => GmbAccountsGmbAccount.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountId != null) 'accountId': accountId!,
        if (gmbAccounts != null) 'gmbAccounts': gmbAccounts!,
        if (kind != null) 'kind': kind!,
      };
}

class LiasettingsListPosDataProvidersResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#liasettingsListPosDataProvidersResponse`".
  core.String? kind;

  /// The list of POS data providers for each eligible country
  core.List<PosDataProviders>? posDataProviders;

  LiasettingsListPosDataProvidersResponse({
    this.kind,
    this.posDataProviders,
  });

  LiasettingsListPosDataProvidersResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          posDataProviders: json_.containsKey('posDataProviders')
              ? (json_['posDataProviders'] as core.List)
                  .map((value) => PosDataProviders.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (posDataProviders != null) 'posDataProviders': posDataProviders!,
      };
}

class LiasettingsListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#liasettingsListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of LIA settings.
  core.String? nextPageToken;
  core.List<LiaSettings>? resources;

  LiasettingsListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  LiasettingsListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => LiaSettings.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

class LiasettingsRequestGmbAccessResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#liasettingsRequestGmbAccessResponse`".
  core.String? kind;

  LiasettingsRequestGmbAccessResponse({
    this.kind,
  });

  LiasettingsRequestGmbAccessResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class LiasettingsRequestInventoryVerificationResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#liasettingsRequestInventoryVerificationResponse`".
  core.String? kind;

  LiasettingsRequestInventoryVerificationResponse({
    this.kind,
  });

  LiasettingsRequestInventoryVerificationResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class LiasettingsSetInventoryVerificationContactResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#liasettingsSetInventoryVerificationContactResponse`".
  core.String? kind;

  LiasettingsSetInventoryVerificationContactResponse({
    this.kind,
  });

  LiasettingsSetInventoryVerificationContactResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class LiasettingsSetPosDataProviderResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#liasettingsSetPosDataProviderResponse`".
  core.String? kind;

  LiasettingsSetPosDataProviderResponse({
    this.kind,
  });

  LiasettingsSetPosDataProviderResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class LinkService {
  /// Service provided to or by the linked account.
  ///
  /// Acceptable values are: - "`shoppingActionsOrderManagement`" -
  /// "`shoppingActionsProductManagement`" - "`shoppingAdsProductManagement`" -
  /// "`paymentProcessing`"
  core.String? service;

  /// Status of the link Acceptable values are: - "`active`" - "`inactive`" -
  /// "`pending`"
  core.String? status;

  LinkService({
    this.service,
    this.status,
  });

  LinkService.fromJson(core.Map json_)
      : this(
          service: json_.containsKey('service')
              ? json_['service'] as core.String
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (service != null) 'service': service!,
        if (status != null) 'status': status!,
      };
}

class LinkedAccount {
  /// The ID of the linked account.
  core.String? linkedAccountId;

  /// List of provided services.
  core.List<LinkService>? services;

  LinkedAccount({
    this.linkedAccountId,
    this.services,
  });

  LinkedAccount.fromJson(core.Map json_)
      : this(
          linkedAccountId: json_.containsKey('linkedAccountId')
              ? json_['linkedAccountId'] as core.String
              : null,
          services: json_.containsKey('services')
              ? (json_['services'] as core.List)
                  .map((value) => LinkService.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (linkedAccountId != null) 'linkedAccountId': linkedAccountId!,
        if (services != null) 'services': services!,
      };
}

/// Response message for the `ListAccountLabels` method.
class ListAccountLabelsResponse {
  /// The labels from the specified account.
  core.List<AccountLabel>? accountLabels;

  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  ListAccountLabelsResponse({
    this.accountLabels,
    this.nextPageToken,
  });

  ListAccountLabelsResponse.fromJson(core.Map json_)
      : this(
          accountLabels: json_.containsKey('accountLabels')
              ? (json_['accountLabels'] as core.List)
                  .map((value) => AccountLabel.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountLabels != null) 'accountLabels': accountLabels!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// Response for listing account return carriers.
class ListAccountReturnCarrierResponse {
  /// List of all available account return carriers for the merchant.
  core.List<AccountReturnCarrier>? accountReturnCarriers;

  ListAccountReturnCarrierResponse({
    this.accountReturnCarriers,
  });

  ListAccountReturnCarrierResponse.fromJson(core.Map json_)
      : this(
          accountReturnCarriers: json_.containsKey('accountReturnCarriers')
              ? (json_['accountReturnCarriers'] as core.List)
                  .map((value) => AccountReturnCarrier.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accountReturnCarriers != null)
          'accountReturnCarriers': accountReturnCarriers!,
      };
}

/// Response message for the ListCollectionStatuses method.
class ListCollectionStatusesResponse {
  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  /// The collectionstatuses listed.
  core.List<CollectionStatus>? resources;

  ListCollectionStatusesResponse({
    this.nextPageToken,
    this.resources,
  });

  ListCollectionStatusesResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => CollectionStatus.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

/// Response message for the ListCollections method.
class ListCollectionsResponse {
  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  /// The collections listed.
  core.List<Collection>? resources;

  ListCollectionsResponse({
    this.nextPageToken,
    this.resources,
  });

  ListCollectionsResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => Collection.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

/// Response message for the ListConversionSources method.
class ListConversionSourcesResponse {
  /// List of conversion sources.
  core.List<ConversionSource>? conversionSources;

  /// Token to be used to fetch the next results page.
  core.String? nextPageToken;

  ListConversionSourcesResponse({
    this.conversionSources,
    this.nextPageToken,
  });

  ListConversionSourcesResponse.fromJson(core.Map json_)
      : this(
          conversionSources: json_.containsKey('conversionSources')
              ? (json_['conversionSources'] as core.List)
                  .map((value) => ConversionSource.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (conversionSources != null) 'conversionSources': conversionSources!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// The response message for the `ListCsses` method
class ListCssesResponse {
  /// The CSS domains affiliated with the specified CSS group.
  core.List<Css>? csses;

  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  ListCssesResponse({
    this.csses,
    this.nextPageToken,
  });

  ListCssesResponse.fromJson(core.Map json_)
      : this(
          csses: json_.containsKey('csses')
              ? (json_['csses'] as core.List)
                  .map((value) => Css.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (csses != null) 'csses': csses!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// Response message for the ListMethodQuotas method.
class ListMethodQuotasResponse {
  /// The current quota usage and limits per each method.
  core.List<MethodQuota>? methodQuotas;

  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  ListMethodQuotasResponse({
    this.methodQuotas,
    this.nextPageToken,
  });

  ListMethodQuotasResponse.fromJson(core.Map json_)
      : this(
          methodQuotas: json_.containsKey('methodQuotas')
              ? (json_['methodQuotas'] as core.List)
                  .map((value) => MethodQuota.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (methodQuotas != null) 'methodQuotas': methodQuotas!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// Response message for Promotions.List method.
class ListPromotionResponse {
  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  /// List of all available promotions for the merchant.
  core.List<Promotion>? promotions;

  ListPromotionResponse({
    this.nextPageToken,
    this.promotions,
  });

  ListPromotionResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          promotions: json_.containsKey('promotions')
              ? (json_['promotions'] as core.List)
                  .map((value) => Promotion.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (promotions != null) 'promotions': promotions!,
      };
}

/// Response message for the `ListRegions` method.
class ListRegionsResponse {
  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  /// The regions from the specified merchant.
  core.List<Region>? regions;

  ListRegionsResponse({
    this.nextPageToken,
    this.regions,
  });

  ListRegionsResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          regions: json_.containsKey('regions')
              ? (json_['regions'] as core.List)
                  .map((value) => Region.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (regions != null) 'regions': regions!,
      };
}

/// Response message for the ListRepricingProductReports method.
class ListRepricingProductReportsResponse {
  /// A token for retrieving the next page.
  ///
  /// Its absence means there is no subsequent page.
  core.String? nextPageToken;

  /// Periodic reports for the given Repricing product.
  core.List<RepricingProductReport>? repricingProductReports;

  ListRepricingProductReportsResponse({
    this.nextPageToken,
    this.repricingProductReports,
  });

  ListRepricingProductReportsResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          repricingProductReports: json_.containsKey('repricingProductReports')
              ? (json_['repricingProductReports'] as core.List)
                  .map((value) => RepricingProductReport.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (repricingProductReports != null)
          'repricingProductReports': repricingProductReports!,
      };
}

/// Response message for the ListRepricingRuleReports method.
class ListRepricingRuleReportsResponse {
  /// A token for retrieving the next page.
  ///
  /// Its absence means there is no subsequent page.
  core.String? nextPageToken;

  /// Daily reports for the given Repricing rule.
  core.List<RepricingRuleReport>? repricingRuleReports;

  ListRepricingRuleReportsResponse({
    this.nextPageToken,
    this.repricingRuleReports,
  });

  ListRepricingRuleReportsResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          repricingRuleReports: json_.containsKey('repricingRuleReports')
              ? (json_['repricingRuleReports'] as core.List)
                  .map((value) => RepricingRuleReport.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (repricingRuleReports != null)
          'repricingRuleReports': repricingRuleReports!,
      };
}

/// Response message for the `ListRepricingRules` method.
class ListRepricingRulesResponse {
  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  /// The rules from the specified merchant.
  core.List<RepricingRule>? repricingRules;

  ListRepricingRulesResponse({
    this.nextPageToken,
    this.repricingRules,
  });

  ListRepricingRulesResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          repricingRules: json_.containsKey('repricingRules')
              ? (json_['repricingRules'] as core.List)
                  .map((value) => RepricingRule.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (repricingRules != null) 'repricingRules': repricingRules!,
      };
}

/// Response message for the `ListReturnPolicyOnline` method.
class ListReturnPolicyOnlineResponse {
  /// The retrieved return policies.
  core.List<ReturnPolicyOnline>? returnPolicies;

  ListReturnPolicyOnlineResponse({
    this.returnPolicies,
  });

  ListReturnPolicyOnlineResponse.fromJson(core.Map json_)
      : this(
          returnPolicies: json_.containsKey('returnPolicies')
              ? (json_['returnPolicies'] as core.List)
                  .map((value) => ReturnPolicyOnline.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (returnPolicies != null) 'returnPolicies': returnPolicies!,
      };
}

/// Local inventory resource.
///
/// For accepted attribute values, see the local product inventory feed
/// specification.
class LocalInventory {
  /// The availability of the product.
  ///
  /// For accepted attribute values, see the local product inventory feed
  /// specification.
  core.String? availability;

  /// A list of custom (merchant-provided) attributes.
  ///
  /// Can also be used to submit any attribute of the feed specification in its
  /// generic form, for example, `{ "name": "size type", "value": "regular" }`.
  core.List<CustomAttribute>? customAttributes;

  /// The in-store product location.
  core.String? instoreProductLocation;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#localInventory`"
  core.String? kind;

  /// The supported pickup method for this offer.
  ///
  /// Unless the value is "not supported", this field must be submitted together
  /// with `pickupSla`. For accepted attribute values, see the local product
  /// inventory feed specification.
  core.String? pickupMethod;

  /// The expected date that an order will be ready for pickup relative to the
  /// order date.
  ///
  /// Must be submitted together with `pickupMethod`. For accepted attribute
  /// values, see the local product inventory feed specification.
  core.String? pickupSla;

  /// The price of the product.
  Price? price;

  /// The quantity of the product.
  ///
  /// Must be nonnegative.
  core.int? quantity;

  /// The sale price of the product.
  ///
  /// Mandatory if `sale_price_effective_date` is defined.
  Price? salePrice;

  /// A date range represented by a pair of ISO 8601 dates separated by a space,
  /// comma, or slash.
  ///
  /// Both dates may be specified as 'null' if undecided.
  core.String? salePriceEffectiveDate;

  /// The store code of this local inventory resource.
  ///
  /// Required.
  core.String? storeCode;

  LocalInventory({
    this.availability,
    this.customAttributes,
    this.instoreProductLocation,
    this.kind,
    this.pickupMethod,
    this.pickupSla,
    this.price,
    this.quantity,
    this.salePrice,
    this.salePriceEffectiveDate,
    this.storeCode,
  });

  LocalInventory.fromJson(core.Map json_)
      : this(
          availability: json_.containsKey('availability')
              ? json_['availability'] as core.String
              : null,
          customAttributes: json_.containsKey('customAttributes')
              ? (json_['customAttributes'] as core.List)
                  .map((value) => CustomAttribute.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          instoreProductLocation: json_.containsKey('instoreProductLocation')
              ? json_['instoreProductLocation'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          pickupMethod: json_.containsKey('pickupMethod')
              ? json_['pickupMethod'] as core.String
              : null,
          pickupSla: json_.containsKey('pickupSla')
              ? json_['pickupSla'] as core.String
              : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
          salePrice: json_.containsKey('salePrice')
              ? Price.fromJson(
                  json_['salePrice'] as core.Map<core.String, core.dynamic>)
              : null,
          salePriceEffectiveDate: json_.containsKey('salePriceEffectiveDate')
              ? json_['salePriceEffectiveDate'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (availability != null) 'availability': availability!,
        if (customAttributes != null) 'customAttributes': customAttributes!,
        if (instoreProductLocation != null)
          'instoreProductLocation': instoreProductLocation!,
        if (kind != null) 'kind': kind!,
        if (pickupMethod != null) 'pickupMethod': pickupMethod!,
        if (pickupSla != null) 'pickupSla': pickupSla!,
        if (price != null) 'price': price!,
        if (quantity != null) 'quantity': quantity!,
        if (salePrice != null) 'salePrice': salePrice!,
        if (salePriceEffectiveDate != null)
          'salePriceEffectiveDate': salePriceEffectiveDate!,
        if (storeCode != null) 'storeCode': storeCode!,
      };
}

class LocalinventoryCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<LocalinventoryCustomBatchRequestEntry>? entries;

  LocalinventoryCustomBatchRequest({
    this.entries,
  });

  LocalinventoryCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) =>
                      LocalinventoryCustomBatchRequestEntry.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

/// Batch entry encoding a single local inventory update request.
class LocalinventoryCustomBatchRequestEntry {
  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// Local inventory of the product.
  LocalInventory? localInventory;

  /// The ID of the managing account.
  core.String? merchantId;

  /// Method of the batch request entry.
  ///
  /// Acceptable values are: - "`insert`"
  core.String? method;

  /// The ID of the product for which to update local inventory.
  core.String? productId;

  LocalinventoryCustomBatchRequestEntry({
    this.batchId,
    this.localInventory,
    this.merchantId,
    this.method,
    this.productId,
  });

  LocalinventoryCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          localInventory: json_.containsKey('localInventory')
              ? LocalInventory.fromJson(json_['localInventory']
                  as core.Map<core.String, core.dynamic>)
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (localInventory != null) 'localInventory': localInventory!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
        if (productId != null) 'productId': productId!,
      };
}

class LocalinventoryCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<LocalinventoryCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#localinventoryCustomBatchResponse`".
  core.String? kind;

  LocalinventoryCustomBatchResponse({
    this.entries,
    this.kind,
  });

  LocalinventoryCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) =>
                      LocalinventoryCustomBatchResponseEntry.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

/// Batch entry encoding a single local inventory update response.
class LocalinventoryCustomBatchResponseEntry {
  /// The ID of the request entry this entry responds to.
  core.int? batchId;

  /// A list of errors for failed custombatch entries.
  ///
  /// *Note:* Schema errors fail the whole request.
  Errors? errors;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#localinventoryCustomBatchResponseEntry`"
  core.String? kind;

  LocalinventoryCustomBatchResponseEntry({
    this.batchId,
    this.errors,
    this.kind,
  });

  LocalinventoryCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (errors != null) 'errors': errors!,
        if (kind != null) 'kind': kind!,
      };
}

class LocationIdSet {
  /// A non-empty list of location IDs.
  ///
  /// They must all be of the same location type (for example, state).
  core.List<core.String>? locationIds;

  LocationIdSet({
    this.locationIds,
  });

  LocationIdSet.fromJson(core.Map json_)
      : this(
          locationIds: json_.containsKey('locationIds')
              ? (json_['locationIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (locationIds != null) 'locationIds': locationIds!,
      };
}

class LoyaltyPoints {
  /// Name of loyalty points program.
  ///
  /// It is recommended to limit the name to 12 full-width characters or 24
  /// Roman characters.
  core.String? name;

  /// The retailer's loyalty points in absolute value.
  core.String? pointsValue;

  /// The ratio of a point when converted to currency.
  ///
  /// Google assumes currency based on Merchant Center settings. If ratio is
  /// left out, it defaults to 1.0.
  core.double? ratio;

  LoyaltyPoints({
    this.name,
    this.pointsValue,
    this.ratio,
  });

  LoyaltyPoints.fromJson(core.Map json_)
      : this(
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          pointsValue: json_.containsKey('pointsValue')
              ? json_['pointsValue'] as core.String
              : null,
          ratio: json_.containsKey('ratio')
              ? (json_['ratio'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (name != null) 'name': name!,
        if (pointsValue != null) 'pointsValue': pointsValue!,
        if (ratio != null) 'ratio': ratio!,
      };
}

/// "Merchant Center Destination" sources can be used to send conversion events
/// from a website using a Google tag directly to a Merchant Center account
/// where the source is created.
class MerchantCenterDestination {
  /// Attribution settings being used for the Merchant Center Destination.
  ///
  /// Required.
  AttributionSettings? attributionSettings;

  /// Three-letter currency code (ISO 4217).
  ///
  /// The currency code defines in which currency the conversions sent to this
  /// destination will be reported in Merchant Center.
  ///
  /// Required.
  core.String? currencyCode;

  /// Merchant Center Destination ID.
  ///
  /// Output only.
  core.String? destinationId;

  /// Merchant-specified display name for the destination.
  ///
  /// This is the name that identifies the conversion source within the Merchant
  /// Center UI. Limited to 64 characters.
  ///
  /// Required.
  core.String? displayName;

  MerchantCenterDestination({
    this.attributionSettings,
    this.currencyCode,
    this.destinationId,
    this.displayName,
  });

  MerchantCenterDestination.fromJson(core.Map json_)
      : this(
          attributionSettings: json_.containsKey('attributionSettings')
              ? AttributionSettings.fromJson(json_['attributionSettings']
                  as core.Map<core.String, core.dynamic>)
              : null,
          currencyCode: json_.containsKey('currencyCode')
              ? json_['currencyCode'] as core.String
              : null,
          destinationId: json_.containsKey('destinationId')
              ? json_['destinationId'] as core.String
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributionSettings != null)
          'attributionSettings': attributionSettings!,
        if (currencyCode != null) 'currencyCode': currencyCode!,
        if (destinationId != null) 'destinationId': destinationId!,
        if (displayName != null) 'displayName': displayName!,
      };
}

/// Order return.
///
/// Production access (all methods) requires the order manager role. Sandbox
/// access does not.
class MerchantOrderReturn {
  /// The date of creation of the return, in ISO 8601 format.
  core.String? creationDate;

  /// Merchant defined order ID.
  core.String? merchantOrderId;

  /// Google order ID.
  core.String? orderId;

  /// Order return ID generated by Google.
  core.String? orderReturnId;

  /// Items of the return.
  core.List<MerchantOrderReturnItem>? returnItems;

  /// Information about shipping costs.
  ReturnPricingInfo? returnPricingInfo;

  /// Shipments of the return.
  core.List<ReturnShipment>? returnShipments;

  MerchantOrderReturn({
    this.creationDate,
    this.merchantOrderId,
    this.orderId,
    this.orderReturnId,
    this.returnItems,
    this.returnPricingInfo,
    this.returnShipments,
  });

  MerchantOrderReturn.fromJson(core.Map json_)
      : this(
          creationDate: json_.containsKey('creationDate')
              ? json_['creationDate'] as core.String
              : null,
          merchantOrderId: json_.containsKey('merchantOrderId')
              ? json_['merchantOrderId'] as core.String
              : null,
          orderId: json_.containsKey('orderId')
              ? json_['orderId'] as core.String
              : null,
          orderReturnId: json_.containsKey('orderReturnId')
              ? json_['orderReturnId'] as core.String
              : null,
          returnItems: json_.containsKey('returnItems')
              ? (json_['returnItems'] as core.List)
                  .map((value) => MerchantOrderReturnItem.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          returnPricingInfo: json_.containsKey('returnPricingInfo')
              ? ReturnPricingInfo.fromJson(json_['returnPricingInfo']
                  as core.Map<core.String, core.dynamic>)
              : null,
          returnShipments: json_.containsKey('returnShipments')
              ? (json_['returnShipments'] as core.List)
                  .map((value) => ReturnShipment.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (creationDate != null) 'creationDate': creationDate!,
        if (merchantOrderId != null) 'merchantOrderId': merchantOrderId!,
        if (orderId != null) 'orderId': orderId!,
        if (orderReturnId != null) 'orderReturnId': orderReturnId!,
        if (returnItems != null) 'returnItems': returnItems!,
        if (returnPricingInfo != null) 'returnPricingInfo': returnPricingInfo!,
        if (returnShipments != null) 'returnShipments': returnShipments!,
      };
}

class MerchantOrderReturnItem {
  /// The reason that the customer chooses to return an item.
  CustomerReturnReason? customerReturnReason;

  /// Product level item ID.
  ///
  /// If the returned items are of the same product, they will have the same ID.
  core.String? itemId;

  /// The reason that the merchant chose to reject an item return.
  MerchantRejectionReason? merchantRejectionReason;

  /// The reason that merchant chooses to accept a return item.
  RefundReason? merchantReturnReason;

  /// Product data from the time of the order placement.
  OrderLineItemProduct? product;

  /// Maximum amount that can be refunded for this return item.
  MonetaryAmount? refundableAmount;

  /// Unit level ID for the return item.
  ///
  /// Different units of the same product will have different IDs.
  core.String? returnItemId;

  /// IDs of the return shipments that this return item belongs to.
  core.List<core.String>? returnShipmentIds;

  /// ID of the original shipment group.
  ///
  /// Provided for shipments with invoice support.
  core.String? shipmentGroupId;

  /// ID of the shipment unit assigned by the merchant.
  ///
  /// Provided for shipments with invoice support.
  core.String? shipmentUnitId;

  /// State of the item.
  ///
  /// Acceptable values are: - "`canceled`" - "`new`" - "`received`" -
  /// "`refunded`" - "`rejected`"
  core.String? state;

  MerchantOrderReturnItem({
    this.customerReturnReason,
    this.itemId,
    this.merchantRejectionReason,
    this.merchantReturnReason,
    this.product,
    this.refundableAmount,
    this.returnItemId,
    this.returnShipmentIds,
    this.shipmentGroupId,
    this.shipmentUnitId,
    this.state,
  });

  MerchantOrderReturnItem.fromJson(core.Map json_)
      : this(
          customerReturnReason: json_.containsKey('customerReturnReason')
              ? CustomerReturnReason.fromJson(json_['customerReturnReason']
                  as core.Map<core.String, core.dynamic>)
              : null,
          itemId: json_.containsKey('itemId')
              ? json_['itemId'] as core.String
              : null,
          merchantRejectionReason: json_.containsKey('merchantRejectionReason')
              ? MerchantRejectionReason.fromJson(
                  json_['merchantRejectionReason']
                      as core.Map<core.String, core.dynamic>)
              : null,
          merchantReturnReason: json_.containsKey('merchantReturnReason')
              ? RefundReason.fromJson(json_['merchantReturnReason']
                  as core.Map<core.String, core.dynamic>)
              : null,
          product: json_.containsKey('product')
              ? OrderLineItemProduct.fromJson(
                  json_['product'] as core.Map<core.String, core.dynamic>)
              : null,
          refundableAmount: json_.containsKey('refundableAmount')
              ? MonetaryAmount.fromJson(json_['refundableAmount']
                  as core.Map<core.String, core.dynamic>)
              : null,
          returnItemId: json_.containsKey('returnItemId')
              ? json_['returnItemId'] as core.String
              : null,
          returnShipmentIds: json_.containsKey('returnShipmentIds')
              ? (json_['returnShipmentIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          shipmentGroupId: json_.containsKey('shipmentGroupId')
              ? json_['shipmentGroupId'] as core.String
              : null,
          shipmentUnitId: json_.containsKey('shipmentUnitId')
              ? json_['shipmentUnitId'] as core.String
              : null,
          state:
              json_.containsKey('state') ? json_['state'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (customerReturnReason != null)
          'customerReturnReason': customerReturnReason!,
        if (itemId != null) 'itemId': itemId!,
        if (merchantRejectionReason != null)
          'merchantRejectionReason': merchantRejectionReason!,
        if (merchantReturnReason != null)
          'merchantReturnReason': merchantReturnReason!,
        if (product != null) 'product': product!,
        if (refundableAmount != null) 'refundableAmount': refundableAmount!,
        if (returnItemId != null) 'returnItemId': returnItemId!,
        if (returnShipmentIds != null) 'returnShipmentIds': returnShipmentIds!,
        if (shipmentGroupId != null) 'shipmentGroupId': shipmentGroupId!,
        if (shipmentUnitId != null) 'shipmentUnitId': shipmentUnitId!,
        if (state != null) 'state': state!,
      };
}

class MerchantRejectionReason {
  /// Description of the reason.
  core.String? description;

  /// Code of the rejection reason.
  core.String? reasonCode;

  MerchantRejectionReason({
    this.description,
    this.reasonCode,
  });

  MerchantRejectionReason.fromJson(core.Map json_)
      : this(
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          reasonCode: json_.containsKey('reasonCode')
              ? json_['reasonCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (description != null) 'description': description!,
        if (reasonCode != null) 'reasonCode': reasonCode!,
      };
}

/// The quota information per method in the Content API.
class MethodQuota {
  /// The method name, for example `products.list`.
  ///
  /// Method name does not contain version because quota can be shared between
  /// different API versions of the same method.
  core.String? method;

  /// The current quota limit per day, meaning the maximum number of calls for
  /// the method.
  core.String? quotaLimit;

  /// The current quota usage, meaning the number of calls already made to the
  /// method.
  core.String? quotaUsage;

  MethodQuota({
    this.method,
    this.quotaLimit,
    this.quotaUsage,
  });

  MethodQuota.fromJson(core.Map json_)
      : this(
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
          quotaLimit: json_.containsKey('quotaLimit')
              ? json_['quotaLimit'] as core.String
              : null,
          quotaUsage: json_.containsKey('quotaUsage')
              ? json_['quotaUsage'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (method != null) 'method': method!,
        if (quotaLimit != null) 'quotaLimit': quotaLimit!,
        if (quotaUsage != null) 'quotaUsage': quotaUsage!,
      };
}

/// Performance metrics.
///
/// Values are only set for metrics requested explicitly in the request's search
/// query.
class Metrics {
  /// Average order size - the average number of items in an order.
  ///
  /// **This metric cannot be segmented by product dimensions and
  /// customer_country_code.**
  core.double? aos;

  /// Average order value in micros (1 millionth of a standard unit, 1 USD =
  /// 1000000 micros) - the average value (total price of items) of all placed
  /// orders.
  ///
  /// The currency of the returned value is stored in the currency_code segment.
  /// If this metric is selected, 'segments.currency_code' is automatically
  /// added to the SELECT clause in the search query (unless it is explicitly
  /// selected by the user) and the currency_code segment is populated in the
  /// response. **This metric cannot be segmented by product dimensions and
  /// customer_country_code.**
  core.double? aovMicros;

  /// Number of clicks.
  core.String? clicks;

  /// Number of conversions divided by the number of clicks, reported on the
  /// impression date.
  ///
  /// The metric is currently available only for the FREE_PRODUCT_LISTING
  /// program.
  core.double? conversionRate;

  /// Value of conversions in micros (1 millionth of a standard unit, 1 USD =
  /// 1000000 micros) attributed to the product, reported on the conversion
  /// date.
  ///
  /// The metric is currently available only for the FREE_PRODUCT_LISTING
  /// program. The currency of the returned value is stored in the currency_code
  /// segment. If this metric is selected, 'segments.currency_code' is
  /// automatically added to the SELECT clause in the search query (unless it is
  /// explicitly selected by the user) and the currency_code segment is
  /// populated in the response.
  core.String? conversionValueMicros;

  /// Number of conversions attributed to the product, reported on the
  /// conversion date.
  ///
  /// Depending on the attribution model, a conversion might be distributed
  /// across multiple clicks, where each click gets its own credit assigned.
  /// This metric is a sum of all such credits. The metric is currently
  /// available only for the FREE_PRODUCT_LISTING program.
  core.double? conversions;

  /// Click-through rate - the number of clicks merchant's products receive
  /// (clicks) divided by the number of times the products are shown
  /// (impressions).
  core.double? ctr;

  /// Average number of days between an order being placed and the order being
  /// fully shipped, reported on the last shipment date.
  ///
  /// **This metric cannot be segmented by product dimensions and
  /// customer_country_code.**
  core.double? daysToShip;

  /// Number of times merchant's products are shown.
  core.String? impressions;

  /// Average number of days between an item being ordered and the item being
  /// **This metric cannot be segmented by customer_country_code.**
  core.double? itemDaysToShip;

  /// Percentage of shipped items in relation to all finalized items (shipped or
  /// rejected by the merchant; unshipped items are not taken into account),
  /// reported on the order date.
  ///
  /// Item fill rate is lowered by merchant rejections. **This metric cannot be
  /// segmented by customer_country_code.**
  core.double? itemFillRate;

  /// Total price of ordered items in micros (1 millionth of a standard unit, 1
  /// USD = 1000000 micros).
  ///
  /// Excludes shipping, taxes (US only), and customer cancellations that
  /// happened within 30 minutes of placing the order. The currency of the
  /// returned value is stored in the currency_code segment. If this metric is
  /// selected, 'segments.currency_code' is automatically added to the SELECT
  /// clause in the search query (unless it is explicitly selected by the user)
  /// and the currency_code segment is populated in the response. **This metric
  /// cannot be segmented by customer_country_code.**
  core.String? orderedItemSalesMicros;

  /// Number of ordered items.
  ///
  /// Excludes customer cancellations that happened within 30 minutes of placing
  /// the order. **This metric cannot be segmented by customer_country_code.**
  core.String? orderedItems;

  /// Number of placed orders.
  ///
  /// Excludes customer cancellations that happened within 30 minutes of placing
  /// the order. **This metric cannot be segmented by product dimensions and
  /// customer_country_code.**
  core.String? orders;

  /// Number of ordered items canceled by the merchant, reported on the order
  /// date.
  ///
  /// **This metric cannot be segmented by customer_country_code.**
  core.String? rejectedItems;

  /// Total price of returned items divided by the total price of shipped items,
  /// reported on the order date.
  ///
  /// If this metric is selected, 'segments.currency_code' is automatically
  /// added to the SELECT clause in the search query (unless it is explicitly
  /// selected by the user) and the currency_code segment is populated in the
  /// response. **This metric cannot be segmented by customer_country_code.**
  core.double? returnRate;

  /// Number of ordered items sent back for return, reported on the date when
  /// the merchant accepted the return.
  ///
  /// **This metric cannot be segmented by customer_country_code.**
  core.String? returnedItems;

  /// Total price of ordered items sent back for return in micros (1 millionth
  /// of a standard unit, 1 USD = 1000000 micros), reported on the date when the
  /// merchant accepted the return.
  ///
  /// The currency of the returned value is stored in the currency_code segment.
  /// If this metric is selected, 'segments.currency_code' is automatically
  /// added to the SELECT clause in the search query (unless it is explicitly
  /// selected by the user) and the currency_code segment is populated in the
  /// response. **This metric cannot be segmented by customer_country_code.**
  core.String? returnsMicros;

  /// Total price of shipped items in micros (1 millionth of a standard unit, 1
  /// USD = 1000000 micros), reported on the order date.
  ///
  /// Excludes shipping and taxes (US only). The currency of the returned value
  /// is stored in the currency_code segment. If this metric is selected,
  /// 'segments.currency_code' is automatically added to the SELECT clause in
  /// the search query (unless it is explicitly selected by the user) and the
  /// currency_code segment is populated in the response. **This metric cannot
  /// be segmented by customer_country_code.**
  core.String? shippedItemSalesMicros;

  /// Number of shipped items, reported on the shipment date.
  ///
  /// **This metric cannot be segmented by customer_country_code.**
  core.String? shippedItems;

  /// Number of fully shipped orders, reported on the last shipment date.
  ///
  /// **This metric cannot be segmented by product dimensions and
  /// customer_country_code.**
  core.String? shippedOrders;

  /// Number of ordered items not shipped up until the end of the queried day.
  ///
  /// If a multi-day period is specified in the search query, the returned value
  /// is the average number of unshipped items over the days in the queried
  /// period. **This metric cannot be segmented by customer_country_code.**
  core.double? unshippedItems;

  /// Number of orders not shipped or partially shipped up until the end of the
  /// queried day.
  ///
  /// If a multi-day period is specified in the search query, the returned value
  /// is the average number of unshipped orders over the days in the queried
  /// period. **This metric cannot be segmented by product dimensions and
  /// customer_country_code.**
  core.double? unshippedOrders;

  Metrics({
    this.aos,
    this.aovMicros,
    this.clicks,
    this.conversionRate,
    this.conversionValueMicros,
    this.conversions,
    this.ctr,
    this.daysToShip,
    this.impressions,
    this.itemDaysToShip,
    this.itemFillRate,
    this.orderedItemSalesMicros,
    this.orderedItems,
    this.orders,
    this.rejectedItems,
    this.returnRate,
    this.returnedItems,
    this.returnsMicros,
    this.shippedItemSalesMicros,
    this.shippedItems,
    this.shippedOrders,
    this.unshippedItems,
    this.unshippedOrders,
  });

  Metrics.fromJson(core.Map json_)
      : this(
          aos: json_.containsKey('aos')
              ? (json_['aos'] as core.num).toDouble()
              : null,
          aovMicros: json_.containsKey('aovMicros')
              ? (json_['aovMicros'] as core.num).toDouble()
              : null,
          clicks: json_.containsKey('clicks')
              ? json_['clicks'] as core.String
              : null,
          conversionRate: json_.containsKey('conversionRate')
              ? (json_['conversionRate'] as core.num).toDouble()
              : null,
          conversionValueMicros: json_.containsKey('conversionValueMicros')
              ? json_['conversionValueMicros'] as core.String
              : null,
          conversions: json_.containsKey('conversions')
              ? (json_['conversions'] as core.num).toDouble()
              : null,
          ctr: json_.containsKey('ctr')
              ? (json_['ctr'] as core.num).toDouble()
              : null,
          daysToShip: json_.containsKey('daysToShip')
              ? (json_['daysToShip'] as core.num).toDouble()
              : null,
          impressions: json_.containsKey('impressions')
              ? json_['impressions'] as core.String
              : null,
          itemDaysToShip: json_.containsKey('itemDaysToShip')
              ? (json_['itemDaysToShip'] as core.num).toDouble()
              : null,
          itemFillRate: json_.containsKey('itemFillRate')
              ? (json_['itemFillRate'] as core.num).toDouble()
              : null,
          orderedItemSalesMicros: json_.containsKey('orderedItemSalesMicros')
              ? json_['orderedItemSalesMicros'] as core.String
              : null,
          orderedItems: json_.containsKey('orderedItems')
              ? json_['orderedItems'] as core.String
              : null,
          orders: json_.containsKey('orders')
              ? json_['orders'] as core.String
              : null,
          rejectedItems: json_.containsKey('rejectedItems')
              ? json_['rejectedItems'] as core.String
              : null,
          returnRate: json_.containsKey('returnRate')
              ? (json_['returnRate'] as core.num).toDouble()
              : null,
          returnedItems: json_.containsKey('returnedItems')
              ? json_['returnedItems'] as core.String
              : null,
          returnsMicros: json_.containsKey('returnsMicros')
              ? json_['returnsMicros'] as core.String
              : null,
          shippedItemSalesMicros: json_.containsKey('shippedItemSalesMicros')
              ? json_['shippedItemSalesMicros'] as core.String
              : null,
          shippedItems: json_.containsKey('shippedItems')
              ? json_['shippedItems'] as core.String
              : null,
          shippedOrders: json_.containsKey('shippedOrders')
              ? json_['shippedOrders'] as core.String
              : null,
          unshippedItems: json_.containsKey('unshippedItems')
              ? (json_['unshippedItems'] as core.num).toDouble()
              : null,
          unshippedOrders: json_.containsKey('unshippedOrders')
              ? (json_['unshippedOrders'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aos != null) 'aos': aos!,
        if (aovMicros != null) 'aovMicros': aovMicros!,
        if (clicks != null) 'clicks': clicks!,
        if (conversionRate != null) 'conversionRate': conversionRate!,
        if (conversionValueMicros != null)
          'conversionValueMicros': conversionValueMicros!,
        if (conversions != null) 'conversions': conversions!,
        if (ctr != null) 'ctr': ctr!,
        if (daysToShip != null) 'daysToShip': daysToShip!,
        if (impressions != null) 'impressions': impressions!,
        if (itemDaysToShip != null) 'itemDaysToShip': itemDaysToShip!,
        if (itemFillRate != null) 'itemFillRate': itemFillRate!,
        if (orderedItemSalesMicros != null)
          'orderedItemSalesMicros': orderedItemSalesMicros!,
        if (orderedItems != null) 'orderedItems': orderedItems!,
        if (orders != null) 'orders': orders!,
        if (rejectedItems != null) 'rejectedItems': rejectedItems!,
        if (returnRate != null) 'returnRate': returnRate!,
        if (returnedItems != null) 'returnedItems': returnedItems!,
        if (returnsMicros != null) 'returnsMicros': returnsMicros!,
        if (shippedItemSalesMicros != null)
          'shippedItemSalesMicros': shippedItemSalesMicros!,
        if (shippedItems != null) 'shippedItems': shippedItems!,
        if (shippedOrders != null) 'shippedOrders': shippedOrders!,
        if (unshippedItems != null) 'unshippedItems': unshippedItems!,
        if (unshippedOrders != null) 'unshippedOrders': unshippedOrders!,
      };
}

class MinimumOrderValueTable {
  core.List<MinimumOrderValueTableStoreCodeSetWithMov>? storeCodeSetWithMovs;

  MinimumOrderValueTable({
    this.storeCodeSetWithMovs,
  });

  MinimumOrderValueTable.fromJson(core.Map json_)
      : this(
          storeCodeSetWithMovs: json_.containsKey('storeCodeSetWithMovs')
              ? (json_['storeCodeSetWithMovs'] as core.List)
                  .map((value) =>
                      MinimumOrderValueTableStoreCodeSetWithMov.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (storeCodeSetWithMovs != null)
          'storeCodeSetWithMovs': storeCodeSetWithMovs!,
      };
}

/// A list of store code sets sharing the same minimum order value.
///
/// At least two sets are required and the last one must be empty, which
/// signifies 'MOV for all other stores'. Each store code can only appear once
/// across all the sets. All prices within a service must have the same
/// currency.
class MinimumOrderValueTableStoreCodeSetWithMov {
  /// A list of unique store codes or empty for the catch all.
  core.List<core.String>? storeCodes;

  /// The minimum order value for the given stores.
  Price? value;

  MinimumOrderValueTableStoreCodeSetWithMov({
    this.storeCodes,
    this.value,
  });

  MinimumOrderValueTableStoreCodeSetWithMov.fromJson(core.Map json_)
      : this(
          storeCodes: json_.containsKey('storeCodes')
              ? (json_['storeCodes'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          value: json_.containsKey('value')
              ? Price.fromJson(
                  json_['value'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (storeCodes != null) 'storeCodes': storeCodes!,
        if (value != null) 'value': value!,
      };
}

class MonetaryAmount {
  /// The pre-tax or post-tax price depends on the location of the order.
  ///
  /// - For countries (for example, "US". where price attribute excludes tax,
  /// this field corresponds to the pre-tax value. - For coutries (for example,
  /// "France") where price attribute includes tax, this field corresponds to
  /// the post-tax value .
  Price? priceAmount;

  /// Tax value, present only for countries where price attribute excludes tax
  /// (for example, "US".
  ///
  /// No tax is referenced as 0 value with the corresponding `currency`.
  Price? taxAmount;

  MonetaryAmount({
    this.priceAmount,
    this.taxAmount,
  });

  MonetaryAmount.fromJson(core.Map json_)
      : this(
          priceAmount: json_.containsKey('priceAmount')
              ? Price.fromJson(
                  json_['priceAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          taxAmount: json_.containsKey('taxAmount')
              ? Price.fromJson(
                  json_['taxAmount'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (priceAmount != null) 'priceAmount': priceAmount!,
        if (taxAmount != null) 'taxAmount': taxAmount!,
      };
}

/// Request message for the OnboardProgram method.
class OnboardBuyOnGoogleProgramRequest {
  /// The customer service email.
  core.String? customerServiceEmail;

  OnboardBuyOnGoogleProgramRequest({
    this.customerServiceEmail,
  });

  OnboardBuyOnGoogleProgramRequest.fromJson(core.Map json_)
      : this(
          customerServiceEmail: json_.containsKey('customerServiceEmail')
              ? json_['customerServiceEmail'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (customerServiceEmail != null)
          'customerServiceEmail': customerServiceEmail!,
      };
}

/// Order.
///
/// Production access (all methods) requires the order manager role. Sandbox
/// access does not.
class Order {
  /// Whether the order was acknowledged.
  core.bool? acknowledged;

  /// List of key-value pairs that are attached to a given order.
  core.List<OrderOrderAnnotation>? annotations;

  /// The billing address.
  OrderAddress? billingAddress;

  /// The details of the customer who placed the order.
  OrderCustomer? customer;

  /// Delivery details for shipments of type `delivery`.
  OrderDeliveryDetails? deliveryDetails;

  /// The REST ID of the order.
  ///
  /// Globally unique.
  core.String? id;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#order`"
  core.String? kind;

  /// Line items that are ordered.
  core.List<OrderLineItem>? lineItems;
  core.String? merchantId;

  /// Merchant-provided ID of the order.
  core.String? merchantOrderId;

  /// The net amount for the order (price part).
  ///
  /// For example, if an order was originally for $100 and a refund was issued
  /// for $20, the net amount will be $80.
  Price? netPriceAmount;

  /// The net amount for the order (tax part).
  ///
  /// Note that in certain cases due to taxable base adjustment `netTaxAmount`
  /// might not match to a sum of tax field across all lineItems and refunds.
  Price? netTaxAmount;

  /// The status of the payment.
  ///
  /// Acceptable values are: - "`paymentCaptured`" - "`paymentRejected`" -
  /// "`paymentSecured`" - "`pendingAuthorization`"
  core.String? paymentStatus;

  /// Pickup details for shipments of type `pickup`.
  OrderPickupDetails? pickupDetails;

  /// The date when the order was placed, in ISO 8601 format.
  core.String? placedDate;

  /// Promotions associated with the order.
  ///
  /// To determine which promotions apply to which products, check the
  /// `Promotions[].appliedItems[].lineItemId` field against the
  /// `LineItems[].id` field for each promotion. If a promotion is applied to
  /// more than 1 offerId, divide the discount value by the number of affected
  /// offers to determine how much discount to apply to each offerId. Examples:
  /// 1. To calculate price paid by the customer for a single line item
  /// including the discount: For each promotion, subtract the
  /// `LineItems[].adjustments[].priceAdjustment.value` amount from the
  /// `LineItems[].Price.value`. 2. To calculate price paid by the customer for
  /// a single line item including the discount in case of multiple quantity:
  /// For each promotion, divide the
  /// `LineItems[].adjustments[].priceAdjustment.value` by the quantity of
  /// products then subtract the resulting value from the
  /// `LineItems[].Product.Price.value` for each quantity item. Only 1 promotion
  /// can be applied to an offerId in a given order. To refund an item which had
  /// a promotion applied to it, make sure to refund the amount after first
  /// subtracting the promotion discount from the item price. More details about
  /// the program are here.
  core.List<OrderPromotion>? promotions;

  /// Refunds for the order.
  core.List<OrderRefund>? refunds;

  /// Shipments of the order.
  core.List<OrderShipment>? shipments;

  /// The total cost of shipping for all items.
  Price? shippingCost;

  /// The tax for the total shipping cost.
  Price? shippingCostTax;

  /// The status of the order.
  ///
  /// Acceptable values are: - "`canceled`" - "`delivered`" - "`inProgress`" -
  /// "`partiallyDelivered`" - "`partiallyReturned`" - "`partiallyShipped`" -
  /// "`pendingShipment`" - "`returned`" - "`shipped`"
  core.String? status;

  /// The party responsible for collecting and remitting taxes.
  ///
  /// Acceptable values are: - "`marketplaceFacilitator`" - "`merchant`"
  core.String? taxCollector;

  Order({
    this.acknowledged,
    this.annotations,
    this.billingAddress,
    this.customer,
    this.deliveryDetails,
    this.id,
    this.kind,
    this.lineItems,
    this.merchantId,
    this.merchantOrderId,
    this.netPriceAmount,
    this.netTaxAmount,
    this.paymentStatus,
    this.pickupDetails,
    this.placedDate,
    this.promotions,
    this.refunds,
    this.shipments,
    this.shippingCost,
    this.shippingCostTax,
    this.status,
    this.taxCollector,
  });

  Order.fromJson(core.Map json_)
      : this(
          acknowledged: json_.containsKey('acknowledged')
              ? json_['acknowledged'] as core.bool
              : null,
          annotations: json_.containsKey('annotations')
              ? (json_['annotations'] as core.List)
                  .map((value) => OrderOrderAnnotation.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          billingAddress: json_.containsKey('billingAddress')
              ? OrderAddress.fromJson(json_['billingAddress']
                  as core.Map<core.String, core.dynamic>)
              : null,
          customer: json_.containsKey('customer')
              ? OrderCustomer.fromJson(
                  json_['customer'] as core.Map<core.String, core.dynamic>)
              : null,
          deliveryDetails: json_.containsKey('deliveryDetails')
              ? OrderDeliveryDetails.fromJson(json_['deliveryDetails']
                  as core.Map<core.String, core.dynamic>)
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          lineItems: json_.containsKey('lineItems')
              ? (json_['lineItems'] as core.List)
                  .map((value) => OrderLineItem.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          merchantOrderId: json_.containsKey('merchantOrderId')
              ? json_['merchantOrderId'] as core.String
              : null,
          netPriceAmount: json_.containsKey('netPriceAmount')
              ? Price.fromJson(json_['netPriceAmount']
                  as core.Map<core.String, core.dynamic>)
              : null,
          netTaxAmount: json_.containsKey('netTaxAmount')
              ? Price.fromJson(
                  json_['netTaxAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          paymentStatus: json_.containsKey('paymentStatus')
              ? json_['paymentStatus'] as core.String
              : null,
          pickupDetails: json_.containsKey('pickupDetails')
              ? OrderPickupDetails.fromJson(
                  json_['pickupDetails'] as core.Map<core.String, core.dynamic>)
              : null,
          placedDate: json_.containsKey('placedDate')
              ? json_['placedDate'] as core.String
              : null,
          promotions: json_.containsKey('promotions')
              ? (json_['promotions'] as core.List)
                  .map((value) => OrderPromotion.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          refunds: json_.containsKey('refunds')
              ? (json_['refunds'] as core.List)
                  .map((value) => OrderRefund.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          shipments: json_.containsKey('shipments')
              ? (json_['shipments'] as core.List)
                  .map((value) => OrderShipment.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          shippingCost: json_.containsKey('shippingCost')
              ? Price.fromJson(
                  json_['shippingCost'] as core.Map<core.String, core.dynamic>)
              : null,
          shippingCostTax: json_.containsKey('shippingCostTax')
              ? Price.fromJson(json_['shippingCostTax']
                  as core.Map<core.String, core.dynamic>)
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
          taxCollector: json_.containsKey('taxCollector')
              ? json_['taxCollector'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (acknowledged != null) 'acknowledged': acknowledged!,
        if (annotations != null) 'annotations': annotations!,
        if (billingAddress != null) 'billingAddress': billingAddress!,
        if (customer != null) 'customer': customer!,
        if (deliveryDetails != null) 'deliveryDetails': deliveryDetails!,
        if (id != null) 'id': id!,
        if (kind != null) 'kind': kind!,
        if (lineItems != null) 'lineItems': lineItems!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (merchantOrderId != null) 'merchantOrderId': merchantOrderId!,
        if (netPriceAmount != null) 'netPriceAmount': netPriceAmount!,
        if (netTaxAmount != null) 'netTaxAmount': netTaxAmount!,
        if (paymentStatus != null) 'paymentStatus': paymentStatus!,
        if (pickupDetails != null) 'pickupDetails': pickupDetails!,
        if (placedDate != null) 'placedDate': placedDate!,
        if (promotions != null) 'promotions': promotions!,
        if (refunds != null) 'refunds': refunds!,
        if (shipments != null) 'shipments': shipments!,
        if (shippingCost != null) 'shippingCost': shippingCost!,
        if (shippingCostTax != null) 'shippingCostTax': shippingCostTax!,
        if (status != null) 'status': status!,
        if (taxCollector != null) 'taxCollector': taxCollector!,
      };
}

typedef OrderAddress = $OrderAddress;

class OrderCancellation {
  /// The actor that created the cancellation.
  ///
  /// Acceptable values are: - "`customer`" - "`googleBot`" -
  /// "`googleCustomerService`" - "`googlePayments`" - "`googleSabre`" -
  /// "`merchant`"
  core.String? actor;

  /// Date on which the cancellation has been created, in ISO 8601 format.
  core.String? creationDate;

  /// The quantity that was canceled.
  core.int? quantity;

  /// The reason for the cancellation.
  ///
  /// Orders that are canceled with a noInventory reason will lead to the
  /// removal of the product from Buy on Google until you make an update to that
  /// product. This won't affect your Shopping ads. Acceptable values are: -
  /// "`autoPostInternal`" - "`autoPostInvalidBillingAddress`" -
  /// "`autoPostNoInventory`" - "`autoPostPriceError`" -
  /// "`autoPostUndeliverableShippingAddress`" - "`couponAbuse`" -
  /// "`customerCanceled`" - "`customerInitiatedCancel`" -
  /// "`customerSupportRequested`" - "`failToPushOrderGoogleError`" -
  /// "`failToPushOrderMerchantError`" -
  /// "`failToPushOrderMerchantFulfillmentError`" -
  /// "`failToPushOrderToMerchant`" - "`failToPushOrderToMerchantOutOfStock`" -
  /// "`invalidCoupon`" - "`malformedShippingAddress`" -
  /// "`merchantDidNotShipOnTime`" - "`noInventory`" - "`orderTimeout`" -
  /// "`other`" - "`paymentAbuse`" - "`paymentDeclined`" - "`priceError`" -
  /// "`returnRefundAbuse`" - "`shippingPriceError`" - "`taxError`" -
  /// "`undeliverableShippingAddress`" - "`unsupportedPoBoxAddress`" -
  /// "`failedToCaptureFunds`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  OrderCancellation({
    this.actor,
    this.creationDate,
    this.quantity,
    this.reason,
    this.reasonText,
  });

  OrderCancellation.fromJson(core.Map json_)
      : this(
          actor:
              json_.containsKey('actor') ? json_['actor'] as core.String : null,
          creationDate: json_.containsKey('creationDate')
              ? json_['creationDate'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (actor != null) 'actor': actor!,
        if (creationDate != null) 'creationDate': creationDate!,
        if (quantity != null) 'quantity': quantity!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
      };
}

class OrderCustomer {
  /// Full name of the customer.
  core.String? fullName;

  /// Email address for the merchant to send value-added tax or invoice
  /// documentation of the order.
  ///
  /// Only the last document sent is made available to the customer. For more
  /// information, see About automated VAT invoicing for Buy on Google.
  core.String? invoiceReceivingEmail;

  /// Loyalty program information.
  OrderCustomerLoyaltyInfo? loyaltyInfo;

  /// Customer's marketing preferences.
  ///
  /// Contains the marketing opt-in information that is current at the time that
  /// the merchant call. User preference selections can change from one order to
  /// the next so preferences must be checked with every order.
  OrderCustomerMarketingRightsInfo? marketingRightsInfo;

  OrderCustomer({
    this.fullName,
    this.invoiceReceivingEmail,
    this.loyaltyInfo,
    this.marketingRightsInfo,
  });

  OrderCustomer.fromJson(core.Map json_)
      : this(
          fullName: json_.containsKey('fullName')
              ? json_['fullName'] as core.String
              : null,
          invoiceReceivingEmail: json_.containsKey('invoiceReceivingEmail')
              ? json_['invoiceReceivingEmail'] as core.String
              : null,
          loyaltyInfo: json_.containsKey('loyaltyInfo')
              ? OrderCustomerLoyaltyInfo.fromJson(
                  json_['loyaltyInfo'] as core.Map<core.String, core.dynamic>)
              : null,
          marketingRightsInfo: json_.containsKey('marketingRightsInfo')
              ? OrderCustomerMarketingRightsInfo.fromJson(
                  json_['marketingRightsInfo']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (fullName != null) 'fullName': fullName!,
        if (invoiceReceivingEmail != null)
          'invoiceReceivingEmail': invoiceReceivingEmail!,
        if (loyaltyInfo != null) 'loyaltyInfo': loyaltyInfo!,
        if (marketingRightsInfo != null)
          'marketingRightsInfo': marketingRightsInfo!,
      };
}

class OrderCustomerLoyaltyInfo {
  /// The loyalty card/membership number.
  core.String? loyaltyNumber;

  /// Name of card/membership holder, this field will be populated when
  core.String? name;

  OrderCustomerLoyaltyInfo({
    this.loyaltyNumber,
    this.name,
  });

  OrderCustomerLoyaltyInfo.fromJson(core.Map json_)
      : this(
          loyaltyNumber: json_.containsKey('loyaltyNumber')
              ? json_['loyaltyNumber'] as core.String
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (loyaltyNumber != null) 'loyaltyNumber': loyaltyNumber!,
        if (name != null) 'name': name!,
      };
}

class OrderCustomerMarketingRightsInfo {
  /// Last known customer selection regarding marketing preferences.
  ///
  /// In certain cases this selection might not be known, so this field would be
  /// empty. If a customer selected `granted` in their most recent order, they
  /// can be subscribed to marketing emails. Customers who have chosen `denied`
  /// must not be subscribed, or must be unsubscribed if already opted-in.
  /// Acceptable values are: - "`denied`" - "`granted`"
  core.String? explicitMarketingPreference;

  /// Timestamp when last time marketing preference was updated.
  ///
  /// Could be empty, if user wasn't offered a selection yet.
  core.String? lastUpdatedTimestamp;

  /// Email address that can be used for marketing purposes.
  ///
  /// The field may be empty even if `explicitMarketingPreference` is 'granted'.
  /// This happens when retrieving an old order from the customer who deleted
  /// their account.
  core.String? marketingEmailAddress;

  OrderCustomerMarketingRightsInfo({
    this.explicitMarketingPreference,
    this.lastUpdatedTimestamp,
    this.marketingEmailAddress,
  });

  OrderCustomerMarketingRightsInfo.fromJson(core.Map json_)
      : this(
          explicitMarketingPreference:
              json_.containsKey('explicitMarketingPreference')
                  ? json_['explicitMarketingPreference'] as core.String
                  : null,
          lastUpdatedTimestamp: json_.containsKey('lastUpdatedTimestamp')
              ? json_['lastUpdatedTimestamp'] as core.String
              : null,
          marketingEmailAddress: json_.containsKey('marketingEmailAddress')
              ? json_['marketingEmailAddress'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (explicitMarketingPreference != null)
          'explicitMarketingPreference': explicitMarketingPreference!,
        if (lastUpdatedTimestamp != null)
          'lastUpdatedTimestamp': lastUpdatedTimestamp!,
        if (marketingEmailAddress != null)
          'marketingEmailAddress': marketingEmailAddress!,
      };
}

class OrderDeliveryDetails {
  /// The delivery address
  OrderAddress? address;

  /// The phone number of the person receiving the delivery.
  core.String? phoneNumber;

  OrderDeliveryDetails({
    this.address,
    this.phoneNumber,
  });

  OrderDeliveryDetails.fromJson(core.Map json_)
      : this(
          address: json_.containsKey('address')
              ? OrderAddress.fromJson(
                  json_['address'] as core.Map<core.String, core.dynamic>)
              : null,
          phoneNumber: json_.containsKey('phoneNumber')
              ? json_['phoneNumber'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (address != null) 'address': address!,
        if (phoneNumber != null) 'phoneNumber': phoneNumber!,
      };
}

class OrderLineItem {
  /// Price and tax adjustments applied on the line item.
  core.List<OrderLineItemAdjustment>? adjustments;

  /// Annotations that are attached to the line item.
  core.List<OrderMerchantProvidedAnnotation>? annotations;

  /// Cancellations of the line item.
  core.List<OrderCancellation>? cancellations;

  /// The ID of the line item.
  core.String? id;

  /// Total price for the line item.
  ///
  /// For example, if two items for $10 are purchased, the total price will be
  /// $20.
  Price? price;

  /// Product data as seen by customer from the time of the order placement.
  ///
  /// Note that certain attributes values (for example, title or gtin) might be
  /// reformatted and no longer match values submitted through product feed.
  OrderLineItemProduct? product;

  /// Number of items canceled.
  core.int? quantityCanceled;

  /// Number of items delivered.
  core.int? quantityDelivered;

  /// Number of items ordered.
  core.int? quantityOrdered;

  /// Number of items pending.
  core.int? quantityPending;

  /// Number of items ready for pickup.
  core.int? quantityReadyForPickup;

  /// Number of items returned.
  core.int? quantityReturned;

  /// Number of items shipped.
  core.int? quantityShipped;

  /// Number of items undeliverable.
  core.int? quantityUndeliverable;

  /// Details of the return policy for the line item.
  OrderLineItemReturnInfo? returnInfo;

  /// Returns of the line item.
  core.List<OrderReturn>? returns;

  /// Details of the requested shipping for the line item.
  OrderLineItemShippingDetails? shippingDetails;

  /// Total tax amount for the line item.
  ///
  /// For example, if two items are purchased, and each have a cost tax of $2,
  /// the total tax amount will be $4.
  Price? tax;

  OrderLineItem({
    this.adjustments,
    this.annotations,
    this.cancellations,
    this.id,
    this.price,
    this.product,
    this.quantityCanceled,
    this.quantityDelivered,
    this.quantityOrdered,
    this.quantityPending,
    this.quantityReadyForPickup,
    this.quantityReturned,
    this.quantityShipped,
    this.quantityUndeliverable,
    this.returnInfo,
    this.returns,
    this.shippingDetails,
    this.tax,
  });

  OrderLineItem.fromJson(core.Map json_)
      : this(
          adjustments: json_.containsKey('adjustments')
              ? (json_['adjustments'] as core.List)
                  .map((value) => OrderLineItemAdjustment.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          annotations: json_.containsKey('annotations')
              ? (json_['annotations'] as core.List)
                  .map((value) => OrderMerchantProvidedAnnotation.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          cancellations: json_.containsKey('cancellations')
              ? (json_['cancellations'] as core.List)
                  .map((value) => OrderCancellation.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          product: json_.containsKey('product')
              ? OrderLineItemProduct.fromJson(
                  json_['product'] as core.Map<core.String, core.dynamic>)
              : null,
          quantityCanceled: json_.containsKey('quantityCanceled')
              ? json_['quantityCanceled'] as core.int
              : null,
          quantityDelivered: json_.containsKey('quantityDelivered')
              ? json_['quantityDelivered'] as core.int
              : null,
          quantityOrdered: json_.containsKey('quantityOrdered')
              ? json_['quantityOrdered'] as core.int
              : null,
          quantityPending: json_.containsKey('quantityPending')
              ? json_['quantityPending'] as core.int
              : null,
          quantityReadyForPickup: json_.containsKey('quantityReadyForPickup')
              ? json_['quantityReadyForPickup'] as core.int
              : null,
          quantityReturned: json_.containsKey('quantityReturned')
              ? json_['quantityReturned'] as core.int
              : null,
          quantityShipped: json_.containsKey('quantityShipped')
              ? json_['quantityShipped'] as core.int
              : null,
          quantityUndeliverable: json_.containsKey('quantityUndeliverable')
              ? json_['quantityUndeliverable'] as core.int
              : null,
          returnInfo: json_.containsKey('returnInfo')
              ? OrderLineItemReturnInfo.fromJson(
                  json_['returnInfo'] as core.Map<core.String, core.dynamic>)
              : null,
          returns: json_.containsKey('returns')
              ? (json_['returns'] as core.List)
                  .map((value) => OrderReturn.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          shippingDetails: json_.containsKey('shippingDetails')
              ? OrderLineItemShippingDetails.fromJson(json_['shippingDetails']
                  as core.Map<core.String, core.dynamic>)
              : null,
          tax: json_.containsKey('tax')
              ? Price.fromJson(
                  json_['tax'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (adjustments != null) 'adjustments': adjustments!,
        if (annotations != null) 'annotations': annotations!,
        if (cancellations != null) 'cancellations': cancellations!,
        if (id != null) 'id': id!,
        if (price != null) 'price': price!,
        if (product != null) 'product': product!,
        if (quantityCanceled != null) 'quantityCanceled': quantityCanceled!,
        if (quantityDelivered != null) 'quantityDelivered': quantityDelivered!,
        if (quantityOrdered != null) 'quantityOrdered': quantityOrdered!,
        if (quantityPending != null) 'quantityPending': quantityPending!,
        if (quantityReadyForPickup != null)
          'quantityReadyForPickup': quantityReadyForPickup!,
        if (quantityReturned != null) 'quantityReturned': quantityReturned!,
        if (quantityShipped != null) 'quantityShipped': quantityShipped!,
        if (quantityUndeliverable != null)
          'quantityUndeliverable': quantityUndeliverable!,
        if (returnInfo != null) 'returnInfo': returnInfo!,
        if (returns != null) 'returns': returns!,
        if (shippingDetails != null) 'shippingDetails': shippingDetails!,
        if (tax != null) 'tax': tax!,
      };
}

class OrderLineItemAdjustment {
  /// Adjustment for total price of the line item.
  Price? priceAdjustment;

  /// Adjustment for total tax of the line item.
  Price? taxAdjustment;

  /// Type of this adjustment.
  ///
  /// Acceptable values are: - "`promotion`"
  core.String? type;

  OrderLineItemAdjustment({
    this.priceAdjustment,
    this.taxAdjustment,
    this.type,
  });

  OrderLineItemAdjustment.fromJson(core.Map json_)
      : this(
          priceAdjustment: json_.containsKey('priceAdjustment')
              ? Price.fromJson(json_['priceAdjustment']
                  as core.Map<core.String, core.dynamic>)
              : null,
          taxAdjustment: json_.containsKey('taxAdjustment')
              ? Price.fromJson(
                  json_['taxAdjustment'] as core.Map<core.String, core.dynamic>)
              : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (priceAdjustment != null) 'priceAdjustment': priceAdjustment!,
        if (taxAdjustment != null) 'taxAdjustment': taxAdjustment!,
        if (type != null) 'type': type!,
      };
}

class OrderLineItemProduct {
  /// Brand of the item.
  core.String? brand;

  /// Condition or state of the item.
  ///
  /// Acceptable values are: - "`new`" - "`refurbished`" - "`used`"
  core.String? condition;

  /// The two-letter ISO 639-1 language code for the item.
  core.String? contentLanguage;

  /// Associated fees at order creation time.
  core.List<OrderLineItemProductFee>? fees;

  /// Global Trade Item Number (GTIN) of the item.
  core.String? gtin;

  /// The REST ID of the product.
  core.String? id;

  /// URL of an image of the item.
  core.String? imageLink;

  /// Shared identifier for all variants of the same product.
  core.String? itemGroupId;

  /// Manufacturer Part Number (MPN) of the item.
  core.String? mpn;

  /// An identifier of the item.
  core.String? offerId;

  /// Price of the item.
  Price? price;

  /// URL to the cached image shown to the user when order was placed.
  core.String? shownImage;

  /// The CLDR territory code of the target country of the product.
  core.String? targetCountry;

  /// The title of the product.
  core.String? title;

  /// Variant attributes for the item.
  ///
  /// These are dimensions of the product, such as color, gender, material,
  /// pattern, and size. You can find a comprehensive list of variant attributes
  /// here.
  core.List<OrderLineItemProductVariantAttribute>? variantAttributes;

  OrderLineItemProduct({
    this.brand,
    this.condition,
    this.contentLanguage,
    this.fees,
    this.gtin,
    this.id,
    this.imageLink,
    this.itemGroupId,
    this.mpn,
    this.offerId,
    this.price,
    this.shownImage,
    this.targetCountry,
    this.title,
    this.variantAttributes,
  });

  OrderLineItemProduct.fromJson(core.Map json_)
      : this(
          brand:
              json_.containsKey('brand') ? json_['brand'] as core.String : null,
          condition: json_.containsKey('condition')
              ? json_['condition'] as core.String
              : null,
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          fees: json_.containsKey('fees')
              ? (json_['fees'] as core.List)
                  .map((value) => OrderLineItemProductFee.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          imageLink: json_.containsKey('imageLink')
              ? json_['imageLink'] as core.String
              : null,
          itemGroupId: json_.containsKey('itemGroupId')
              ? json_['itemGroupId'] as core.String
              : null,
          mpn: json_.containsKey('mpn') ? json_['mpn'] as core.String : null,
          offerId: json_.containsKey('offerId')
              ? json_['offerId'] as core.String
              : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          shownImage: json_.containsKey('shownImage')
              ? json_['shownImage'] as core.String
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
          variantAttributes: json_.containsKey('variantAttributes')
              ? (json_['variantAttributes'] as core.List)
                  .map((value) => OrderLineItemProductVariantAttribute.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (brand != null) 'brand': brand!,
        if (condition != null) 'condition': condition!,
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (fees != null) 'fees': fees!,
        if (gtin != null) 'gtin': gtin!,
        if (id != null) 'id': id!,
        if (imageLink != null) 'imageLink': imageLink!,
        if (itemGroupId != null) 'itemGroupId': itemGroupId!,
        if (mpn != null) 'mpn': mpn!,
        if (offerId != null) 'offerId': offerId!,
        if (price != null) 'price': price!,
        if (shownImage != null) 'shownImage': shownImage!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
        if (title != null) 'title': title!,
        if (variantAttributes != null) 'variantAttributes': variantAttributes!,
      };
}

class OrderLineItemProductFee {
  /// Amount of the fee.
  Price? amount;

  /// Name of the fee.
  core.String? name;

  OrderLineItemProductFee({
    this.amount,
    this.name,
  });

  OrderLineItemProductFee.fromJson(core.Map json_)
      : this(
          amount: json_.containsKey('amount')
              ? Price.fromJson(
                  json_['amount'] as core.Map<core.String, core.dynamic>)
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (amount != null) 'amount': amount!,
        if (name != null) 'name': name!,
      };
}

class OrderLineItemProductVariantAttribute {
  /// The dimension of the variant.
  core.String? dimension;

  /// The value for the dimension.
  core.String? value;

  OrderLineItemProductVariantAttribute({
    this.dimension,
    this.value,
  });

  OrderLineItemProductVariantAttribute.fromJson(core.Map json_)
      : this(
          dimension: json_.containsKey('dimension')
              ? json_['dimension'] as core.String
              : null,
          value:
              json_.containsKey('value') ? json_['value'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dimension != null) 'dimension': dimension!,
        if (value != null) 'value': value!,
      };
}

class OrderLineItemReturnInfo {
  /// How many days later the item can be returned.
  ///
  /// Required.
  core.int? daysToReturn;

  /// Whether the item is returnable.
  ///
  /// Required.
  core.bool? isReturnable;

  /// URL of the item return policy.
  ///
  /// Required.
  core.String? policyUrl;

  OrderLineItemReturnInfo({
    this.daysToReturn,
    this.isReturnable,
    this.policyUrl,
  });

  OrderLineItemReturnInfo.fromJson(core.Map json_)
      : this(
          daysToReturn: json_.containsKey('daysToReturn')
              ? json_['daysToReturn'] as core.int
              : null,
          isReturnable: json_.containsKey('isReturnable')
              ? json_['isReturnable'] as core.bool
              : null,
          policyUrl: json_.containsKey('policyUrl')
              ? json_['policyUrl'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (daysToReturn != null) 'daysToReturn': daysToReturn!,
        if (isReturnable != null) 'isReturnable': isReturnable!,
        if (policyUrl != null) 'policyUrl': policyUrl!,
      };
}

class OrderLineItemShippingDetails {
  /// The delivery by date, in ISO 8601 format.
  ///
  /// Required.
  core.String? deliverByDate;

  /// Details of the shipping method.
  ///
  /// Required.
  OrderLineItemShippingDetailsMethod? method;

  /// The promised time in minutes in which the order will be ready for pickup.
  ///
  /// This only applies to buy-online-pickup-in-store same-day order.
  core.int? pickupPromiseInMinutes;

  /// The ship by date, in ISO 8601 format.
  ///
  /// Required.
  core.String? shipByDate;

  /// Type of shipment.
  ///
  /// Indicates whether `deliveryDetails` or `pickupDetails` is applicable for
  /// this shipment. Acceptable values are: - "`delivery`" - "`pickup`"
  core.String? type;

  OrderLineItemShippingDetails({
    this.deliverByDate,
    this.method,
    this.pickupPromiseInMinutes,
    this.shipByDate,
    this.type,
  });

  OrderLineItemShippingDetails.fromJson(core.Map json_)
      : this(
          deliverByDate: json_.containsKey('deliverByDate')
              ? json_['deliverByDate'] as core.String
              : null,
          method: json_.containsKey('method')
              ? OrderLineItemShippingDetailsMethod.fromJson(
                  json_['method'] as core.Map<core.String, core.dynamic>)
              : null,
          pickupPromiseInMinutes: json_.containsKey('pickupPromiseInMinutes')
              ? json_['pickupPromiseInMinutes'] as core.int
              : null,
          shipByDate: json_.containsKey('shipByDate')
              ? json_['shipByDate'] as core.String
              : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deliverByDate != null) 'deliverByDate': deliverByDate!,
        if (method != null) 'method': method!,
        if (pickupPromiseInMinutes != null)
          'pickupPromiseInMinutes': pickupPromiseInMinutes!,
        if (shipByDate != null) 'shipByDate': shipByDate!,
        if (type != null) 'type': type!,
      };
}

class OrderLineItemShippingDetailsMethod {
  /// The carrier for the shipping.
  ///
  /// Optional. See `shipments[].carrier` for a list of acceptable values.
  core.String? carrier;

  /// Maximum transit time.
  ///
  /// Required.
  core.int? maxDaysInTransit;

  /// The name of the shipping method.
  ///
  /// Required.
  core.String? methodName;

  /// Minimum transit time.
  ///
  /// Required.
  core.int? minDaysInTransit;

  OrderLineItemShippingDetailsMethod({
    this.carrier,
    this.maxDaysInTransit,
    this.methodName,
    this.minDaysInTransit,
  });

  OrderLineItemShippingDetailsMethod.fromJson(core.Map json_)
      : this(
          carrier: json_.containsKey('carrier')
              ? json_['carrier'] as core.String
              : null,
          maxDaysInTransit: json_.containsKey('maxDaysInTransit')
              ? json_['maxDaysInTransit'] as core.int
              : null,
          methodName: json_.containsKey('methodName')
              ? json_['methodName'] as core.String
              : null,
          minDaysInTransit: json_.containsKey('minDaysInTransit')
              ? json_['minDaysInTransit'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrier != null) 'carrier': carrier!,
        if (maxDaysInTransit != null) 'maxDaysInTransit': maxDaysInTransit!,
        if (methodName != null) 'methodName': methodName!,
        if (minDaysInTransit != null) 'minDaysInTransit': minDaysInTransit!,
      };
}

class OrderMerchantProvidedAnnotation {
  /// Key for additional merchant provided (as key-value pairs) annotation about
  /// the line item.
  core.String? key;

  /// Value for additional merchant provided (as key-value pairs) annotation
  /// about the line item.
  core.String? value;

  OrderMerchantProvidedAnnotation({
    this.key,
    this.value,
  });

  OrderMerchantProvidedAnnotation.fromJson(core.Map json_)
      : this(
          key: json_.containsKey('key') ? json_['key'] as core.String : null,
          value:
              json_.containsKey('value') ? json_['value'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (key != null) 'key': key!,
        if (value != null) 'value': value!,
      };
}

class OrderOrderAnnotation {
  /// Key for additional google provided (as key-value pairs) annotation.
  core.String? key;

  /// Value for additional google provided (as key-value pairs) annotation.
  core.String? value;

  OrderOrderAnnotation({
    this.key,
    this.value,
  });

  OrderOrderAnnotation.fromJson(core.Map json_)
      : this(
          key: json_.containsKey('key') ? json_['key'] as core.String : null,
          value:
              json_.containsKey('value') ? json_['value'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (key != null) 'key': key!,
        if (value != null) 'value': value!,
      };
}

class OrderPickupDetails {
  /// Address of the pickup location where the shipment should be sent.
  ///
  /// Note that `recipientName` in the address is the name of the business at
  /// the pickup location.
  OrderAddress? address;

  /// Collectors authorized to pick up shipment from the pickup location.
  core.List<OrderPickupDetailsCollector>? collectors;

  /// ID of the pickup location.
  core.String? locationId;

  /// The pickup type of this order.
  ///
  /// Acceptable values are: - "`merchantStore`" - "`merchantStoreCurbside`" -
  /// "`merchantStoreLocker`" - "`thirdPartyPickupPoint`" - "`thirdPartyLocker`"
  core.String? pickupType;

  OrderPickupDetails({
    this.address,
    this.collectors,
    this.locationId,
    this.pickupType,
  });

  OrderPickupDetails.fromJson(core.Map json_)
      : this(
          address: json_.containsKey('address')
              ? OrderAddress.fromJson(
                  json_['address'] as core.Map<core.String, core.dynamic>)
              : null,
          collectors: json_.containsKey('collectors')
              ? (json_['collectors'] as core.List)
                  .map((value) => OrderPickupDetailsCollector.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          locationId: json_.containsKey('locationId')
              ? json_['locationId'] as core.String
              : null,
          pickupType: json_.containsKey('pickupType')
              ? json_['pickupType'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (address != null) 'address': address!,
        if (collectors != null) 'collectors': collectors!,
        if (locationId != null) 'locationId': locationId!,
        if (pickupType != null) 'pickupType': pickupType!,
      };
}

class OrderPickupDetailsCollector {
  /// Name of the person picking up the shipment.
  core.String? name;

  /// Phone number of the person picking up the shipment.
  core.String? phoneNumber;

  OrderPickupDetailsCollector({
    this.name,
    this.phoneNumber,
  });

  OrderPickupDetailsCollector.fromJson(core.Map json_)
      : this(
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          phoneNumber: json_.containsKey('phoneNumber')
              ? json_['phoneNumber'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (name != null) 'name': name!,
        if (phoneNumber != null) 'phoneNumber': phoneNumber!,
      };
}

class OrderPromotion {
  /// Items that this promotion may be applied to.
  ///
  /// If empty, there are no restrictions on applicable items and quantity. This
  /// field will also be empty for shipping promotions because shipping is not
  /// tied to any specific item.
  core.List<OrderPromotionItem>? applicableItems;

  /// Items that this promotion have been applied to.
  ///
  /// Do not provide for `orders.createtestorder`. This field will be empty for
  /// shipping promotions because shipping is not tied to any specific item.
  core.List<OrderPromotionItem>? appliedItems;

  /// Promotion end time in ISO 8601 format.
  ///
  /// Date, time, and offset required, for example, "2020-01-02T09:00:00+01:00"
  /// or "2020-01-02T09:00:00Z".
  core.String? endTime;

  /// The party funding the promotion.
  ///
  /// Only `merchant` is supported for `orders.createtestorder`. Acceptable
  /// values are: - "`google`" - "`merchant`"
  ///
  /// Required.
  core.String? funder;

  /// This field is used to identify promotions within merchants' own systems.
  ///
  /// Required.
  core.String? merchantPromotionId;

  /// Estimated discount applied to price.
  ///
  /// Amount is pre-tax or post-tax depending on location of order.
  Price? priceValue;

  /// A short title of the promotion to be shown on the checkout page.
  ///
  /// Do not provide for `orders.createtestorder`.
  core.String? shortTitle;

  /// Promotion start time in ISO 8601 format.
  ///
  /// Date, time, and offset required, for example, "2020-01-02T09:00:00+01:00"
  /// or "2020-01-02T09:00:00Z".
  core.String? startTime;

  /// The category of the promotion.
  ///
  /// Only `moneyOff` is supported for `orders.createtestorder`. Acceptable
  /// values are: - "`buyMGetMoneyOff`" - "`buyMGetNMoneyOff`" -
  /// "`buyMGetNPercentOff`" - "`buyMGetPercentOff`" - "`freeGift`" -
  /// "`freeGiftWithItemId`" - "`freeGiftWithValue`" - "`freeShippingOvernight`"
  /// - "`freeShippingStandard`" - "`freeShippingTwoDay`" - "`moneyOff`" -
  /// "`percentOff`" - "`rewardPoints`" - "`salePrice`"
  ///
  /// Required.
  core.String? subtype;

  /// Estimated discount applied to tax (if allowed by law).
  ///
  /// Do not provide for `orders.createtestorder`.
  Price? taxValue;

  /// The title of the promotion.
  ///
  /// Required.
  core.String? title;

  /// The scope of the promotion.
  ///
  /// Only `product` is supported for `orders.createtestorder`. Acceptable
  /// values are: - "`product`" - "`shipping`"
  ///
  /// Required.
  core.String? type;

  OrderPromotion({
    this.applicableItems,
    this.appliedItems,
    this.endTime,
    this.funder,
    this.merchantPromotionId,
    this.priceValue,
    this.shortTitle,
    this.startTime,
    this.subtype,
    this.taxValue,
    this.title,
    this.type,
  });

  OrderPromotion.fromJson(core.Map json_)
      : this(
          applicableItems: json_.containsKey('applicableItems')
              ? (json_['applicableItems'] as core.List)
                  .map((value) => OrderPromotionItem.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          appliedItems: json_.containsKey('appliedItems')
              ? (json_['appliedItems'] as core.List)
                  .map((value) => OrderPromotionItem.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          endTime: json_.containsKey('endTime')
              ? json_['endTime'] as core.String
              : null,
          funder: json_.containsKey('funder')
              ? json_['funder'] as core.String
              : null,
          merchantPromotionId: json_.containsKey('merchantPromotionId')
              ? json_['merchantPromotionId'] as core.String
              : null,
          priceValue: json_.containsKey('priceValue')
              ? Price.fromJson(
                  json_['priceValue'] as core.Map<core.String, core.dynamic>)
              : null,
          shortTitle: json_.containsKey('shortTitle')
              ? json_['shortTitle'] as core.String
              : null,
          startTime: json_.containsKey('startTime')
              ? json_['startTime'] as core.String
              : null,
          subtype: json_.containsKey('subtype')
              ? json_['subtype'] as core.String
              : null,
          taxValue: json_.containsKey('taxValue')
              ? Price.fromJson(
                  json_['taxValue'] as core.Map<core.String, core.dynamic>)
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (applicableItems != null) 'applicableItems': applicableItems!,
        if (appliedItems != null) 'appliedItems': appliedItems!,
        if (endTime != null) 'endTime': endTime!,
        if (funder != null) 'funder': funder!,
        if (merchantPromotionId != null)
          'merchantPromotionId': merchantPromotionId!,
        if (priceValue != null) 'priceValue': priceValue!,
        if (shortTitle != null) 'shortTitle': shortTitle!,
        if (startTime != null) 'startTime': startTime!,
        if (subtype != null) 'subtype': subtype!,
        if (taxValue != null) 'taxValue': taxValue!,
        if (title != null) 'title': title!,
        if (type != null) 'type': type!,
      };
}

class OrderPromotionItem {
  /// The line item ID of a product.
  ///
  /// Do not provide for `orders.createtestorder`.
  core.String? lineItemId;

  /// Offer ID of a product.
  ///
  /// Only for `orders.createtestorder`.
  ///
  /// Required.
  core.String? offerId;

  /// `orders.createtestorder`.
  core.String? productId;

  /// The quantity of the associated product.
  ///
  /// Do not provide for `orders.createtestorder`.
  core.int? quantity;

  OrderPromotionItem({
    this.lineItemId,
    this.offerId,
    this.productId,
    this.quantity,
  });

  OrderPromotionItem.fromJson(core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          offerId: json_.containsKey('offerId')
              ? json_['offerId'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (offerId != null) 'offerId': offerId!,
        if (productId != null) 'productId': productId!,
        if (quantity != null) 'quantity': quantity!,
      };
}

class OrderRefund {
  /// The actor that created the refund.
  ///
  /// Acceptable values are: - "`customer`" - "`googleBot`" -
  /// "`googleCustomerService`" - "`googlePayments`" - "`googleSabre`" -
  /// "`merchant`"
  core.String? actor;

  /// The amount that is refunded.
  Price? amount;

  /// Date on which the item has been created, in ISO 8601 format.
  core.String? creationDate;

  /// The reason for the refund.
  ///
  /// Acceptable values are: - "`adjustment`" - "`autoPostInternal`" -
  /// "`autoPostInvalidBillingAddress`" - "`autoPostNoInventory`" -
  /// "`autoPostPriceError`" - "`autoPostUndeliverableShippingAddress`" -
  /// "`couponAbuse`" - "`courtesyAdjustment`" - "`customerCanceled`" -
  /// "`customerDiscretionaryReturn`" - "`customerInitiatedMerchantCancel`" -
  /// "`customerSupportRequested`" - "`deliveredLateByCarrier`" -
  /// "`deliveredTooLate`" - "`expiredItem`" - "`failToPushOrderGoogleError`" -
  /// "`failToPushOrderMerchantError`" -
  /// "`failToPushOrderMerchantFulfillmentError`" -
  /// "`failToPushOrderToMerchant`" - "`failToPushOrderToMerchantOutOfStock`" -
  /// "`feeAdjustment`" - "`invalidCoupon`" - "`lateShipmentCredit`" -
  /// "`malformedShippingAddress`" - "`merchantDidNotShipOnTime`" -
  /// "`noInventory`" - "`orderTimeout`" - "`other`" - "`paymentAbuse`" -
  /// "`paymentDeclined`" - "`priceAdjustment`" - "`priceError`" -
  /// "`productArrivedDamaged`" - "`productNotAsDescribed`" -
  /// "`promoReallocation`" - "`qualityNotAsExpected`" - "`returnRefundAbuse`" -
  /// "`shippingCostAdjustment`" - "`shippingPriceError`" - "`taxAdjustment`" -
  /// "`taxError`" - "`undeliverableShippingAddress`" -
  /// "`unsupportedPoBoxAddress`" - "`wrongProductShipped`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  OrderRefund({
    this.actor,
    this.amount,
    this.creationDate,
    this.reason,
    this.reasonText,
  });

  OrderRefund.fromJson(core.Map json_)
      : this(
          actor:
              json_.containsKey('actor') ? json_['actor'] as core.String : null,
          amount: json_.containsKey('amount')
              ? Price.fromJson(
                  json_['amount'] as core.Map<core.String, core.dynamic>)
              : null,
          creationDate: json_.containsKey('creationDate')
              ? json_['creationDate'] as core.String
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (actor != null) 'actor': actor!,
        if (amount != null) 'amount': amount!,
        if (creationDate != null) 'creationDate': creationDate!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
      };
}

/// Order disbursement.
///
/// All methods require the payment analyst role.
class OrderReportDisbursement {
  /// The disbursement amount.
  Price? disbursementAmount;

  /// The disbursement date, in ISO 8601 format.
  core.String? disbursementCreationDate;

  /// The date the disbursement was initiated, in ISO 8601 format.
  core.String? disbursementDate;

  /// The ID of the disbursement.
  core.String? disbursementId;

  /// The ID of the managing account.
  core.String? merchantId;

  OrderReportDisbursement({
    this.disbursementAmount,
    this.disbursementCreationDate,
    this.disbursementDate,
    this.disbursementId,
    this.merchantId,
  });

  OrderReportDisbursement.fromJson(core.Map json_)
      : this(
          disbursementAmount: json_.containsKey('disbursementAmount')
              ? Price.fromJson(json_['disbursementAmount']
                  as core.Map<core.String, core.dynamic>)
              : null,
          disbursementCreationDate:
              json_.containsKey('disbursementCreationDate')
                  ? json_['disbursementCreationDate'] as core.String
                  : null,
          disbursementDate: json_.containsKey('disbursementDate')
              ? json_['disbursementDate'] as core.String
              : null,
          disbursementId: json_.containsKey('disbursementId')
              ? json_['disbursementId'] as core.String
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (disbursementAmount != null)
          'disbursementAmount': disbursementAmount!,
        if (disbursementCreationDate != null)
          'disbursementCreationDate': disbursementCreationDate!,
        if (disbursementDate != null) 'disbursementDate': disbursementDate!,
        if (disbursementId != null) 'disbursementId': disbursementId!,
        if (merchantId != null) 'merchantId': merchantId!,
      };
}

class OrderReportTransaction {
  /// The disbursement amount.
  Price? disbursementAmount;

  /// The date the disbursement was created, in ISO 8601 format.
  core.String? disbursementCreationDate;

  /// The date the disbursement was initiated, in ISO 8601 format.
  core.String? disbursementDate;

  /// The ID of the disbursement.
  core.String? disbursementId;

  /// The ID of the managing account.
  core.String? merchantId;

  /// Merchant-provided ID of the order.
  core.String? merchantOrderId;

  /// The ID of the order.
  core.String? orderId;

  /// Total amount for the items.
  ProductAmount? productAmount;

  /// The date of the transaction, in ISO 8601 format.
  core.String? transactionDate;

  OrderReportTransaction({
    this.disbursementAmount,
    this.disbursementCreationDate,
    this.disbursementDate,
    this.disbursementId,
    this.merchantId,
    this.merchantOrderId,
    this.orderId,
    this.productAmount,
    this.transactionDate,
  });

  OrderReportTransaction.fromJson(core.Map json_)
      : this(
          disbursementAmount: json_.containsKey('disbursementAmount')
              ? Price.fromJson(json_['disbursementAmount']
                  as core.Map<core.String, core.dynamic>)
              : null,
          disbursementCreationDate:
              json_.containsKey('disbursementCreationDate')
                  ? json_['disbursementCreationDate'] as core.String
                  : null,
          disbursementDate: json_.containsKey('disbursementDate')
              ? json_['disbursementDate'] as core.String
              : null,
          disbursementId: json_.containsKey('disbursementId')
              ? json_['disbursementId'] as core.String
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          merchantOrderId: json_.containsKey('merchantOrderId')
              ? json_['merchantOrderId'] as core.String
              : null,
          orderId: json_.containsKey('orderId')
              ? json_['orderId'] as core.String
              : null,
          productAmount: json_.containsKey('productAmount')
              ? ProductAmount.fromJson(
                  json_['productAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          transactionDate: json_.containsKey('transactionDate')
              ? json_['transactionDate'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (disbursementAmount != null)
          'disbursementAmount': disbursementAmount!,
        if (disbursementCreationDate != null)
          'disbursementCreationDate': disbursementCreationDate!,
        if (disbursementDate != null) 'disbursementDate': disbursementDate!,
        if (disbursementId != null) 'disbursementId': disbursementId!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (merchantOrderId != null) 'merchantOrderId': merchantOrderId!,
        if (orderId != null) 'orderId': orderId!,
        if (productAmount != null) 'productAmount': productAmount!,
        if (transactionDate != null) 'transactionDate': transactionDate!,
      };
}

class OrderReturn {
  /// The actor that created the refund.
  ///
  /// Acceptable values are: - "`customer`" - "`googleBot`" -
  /// "`googleCustomerService`" - "`googlePayments`" - "`googleSabre`" -
  /// "`merchant`"
  core.String? actor;

  /// Date on which the item has been created, in ISO 8601 format.
  core.String? creationDate;

  /// Quantity that is returned.
  core.int? quantity;

  /// The reason for the return.
  ///
  /// Acceptable values are: - "`customerDiscretionaryReturn`" -
  /// "`customerInitiatedMerchantCancel`" - "`deliveredTooLate`" -
  /// "`expiredItem`" - "`invalidCoupon`" - "`malformedShippingAddress`" -
  /// "`other`" - "`productArrivedDamaged`" - "`productNotAsDescribed`" -
  /// "`qualityNotAsExpected`" - "`undeliverableShippingAddress`" -
  /// "`unsupportedPoBoxAddress`" - "`wrongProductShipped`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  OrderReturn({
    this.actor,
    this.creationDate,
    this.quantity,
    this.reason,
    this.reasonText,
  });

  OrderReturn.fromJson(core.Map json_)
      : this(
          actor:
              json_.containsKey('actor') ? json_['actor'] as core.String : null,
          creationDate: json_.containsKey('creationDate')
              ? json_['creationDate'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (actor != null) 'actor': actor!,
        if (creationDate != null) 'creationDate': creationDate!,
        if (quantity != null) 'quantity': quantity!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
      };
}

class OrderShipment {
  /// The carrier handling the shipment.
  ///
  /// For supported carriers, Google includes the carrier name and tracking URL
  /// in emails to customers. For select supported carriers, Google also
  /// automatically updates the shipment status based on the provided shipment
  /// ID. *Note:* You can also use unsupported carriers, but emails to customers
  /// won't include the carrier name or tracking URL, and there will be no
  /// automatic order status updates. Supported carriers for "US" are: - "`ups`"
  /// (United Parcel Service) *automatic status updates* - "`usps`" (United
  /// States Postal Service) *automatic status updates* - "`fedex`" (FedEx)
  /// *automatic status updates * - "`dhl`" (DHL eCommerce) *automatic status
  /// updates* (US only) - "`ontrac`" (OnTrac) *automatic status updates * -
  /// "`dhl express`" (DHL Express) - "`deliv`" (Deliv) - "`dynamex`" (TForce) -
  /// "`lasership`" (LaserShip) - "`mpx`" (Military Parcel Xpress) - "`uds`"
  /// (United Delivery Service) - "`efw`" (Estes Forwarding Worldwide) - "`jd
  /// logistics`" (JD Logistics) - "`yunexpress`" (YunExpress) - "`china post`"
  /// (China Post) - "`china ems`" (China Post Express Mail Service) -
  /// "`singapore post`" (Singapore Post) - "`pos malaysia`" (Pos Malaysia) -
  /// "`postnl`" (PostNL) - "`ptt`" (PTT Turkish Post) - "`eub`" (ePacket) -
  /// "`chukou1`" (Chukou1 Logistics) - "`bestex`" (Best Express) - "`canada
  /// post`" (Canada Post) - "`purolator`" (Purolator) - "`canpar`" (Canpar) -
  /// "`india post`" (India Post) - "`blue dart`" (Blue Dart) - "`delhivery`"
  /// (Delhivery) - "`dtdc`" (DTDC) - "`tpc india`" (TPC India) - "`lso`" (Lone
  /// Star Overnight) - "`tww`" (Team Worldwide) - "`deliver-it`" (Deliver-IT) -
  /// "`cdl last mile`" (CDL Last Mile) Supported carriers for FR are: - "`la
  /// poste`" (La Poste) *automatic status updates * - "`colissimo`" (Colissimo
  /// by La Poste) *automatic status updates* - "`ups`" (United Parcel Service)
  /// *automatic status updates * - "`chronopost`" (Chronopost by La Poste) -
  /// "`gls`" (General Logistics Systems France) - "`dpd`" (DPD Group by
  /// GeoPost) - "`bpost`" (Belgian Post Group) - "`colis prive`" (Colis Privé)
  /// - "`boxtal`" (Boxtal) - "`geodis`" (GEODIS) - "`tnt`" (TNT) - "`db
  /// schenker`" (DB Schenker) - "`aramex`" (Aramex)
  core.String? carrier;

  /// Date on which the shipment has been created, in ISO 8601 format.
  core.String? creationDate;

  /// Date on which the shipment has been delivered, in ISO 8601 format.
  ///
  /// Present only if `status` is `delivered`
  core.String? deliveryDate;

  /// The ID of the shipment.
  core.String? id;

  /// The line items that are shipped.
  core.List<OrderShipmentLineItemShipment>? lineItems;

  /// Delivery details of the shipment if scheduling is needed.
  OrderShipmentScheduledDeliveryDetails? scheduledDeliveryDetails;

  /// The shipment group ID of the shipment.
  ///
  /// This is set in shiplineitems request.
  core.String? shipmentGroupId;

  /// The status of the shipment.
  ///
  /// Acceptable values are: - "`delivered`" - "`readyForPickup`" - "`shipped`"
  /// - "`undeliverable`"
  core.String? status;

  /// The tracking ID for the shipment.
  core.String? trackingId;

  OrderShipment({
    this.carrier,
    this.creationDate,
    this.deliveryDate,
    this.id,
    this.lineItems,
    this.scheduledDeliveryDetails,
    this.shipmentGroupId,
    this.status,
    this.trackingId,
  });

  OrderShipment.fromJson(core.Map json_)
      : this(
          carrier: json_.containsKey('carrier')
              ? json_['carrier'] as core.String
              : null,
          creationDate: json_.containsKey('creationDate')
              ? json_['creationDate'] as core.String
              : null,
          deliveryDate: json_.containsKey('deliveryDate')
              ? json_['deliveryDate'] as core.String
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          lineItems: json_.containsKey('lineItems')
              ? (json_['lineItems'] as core.List)
                  .map((value) => OrderShipmentLineItemShipment.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          scheduledDeliveryDetails:
              json_.containsKey('scheduledDeliveryDetails')
                  ? OrderShipmentScheduledDeliveryDetails.fromJson(
                      json_['scheduledDeliveryDetails']
                          as core.Map<core.String, core.dynamic>)
                  : null,
          shipmentGroupId: json_.containsKey('shipmentGroupId')
              ? json_['shipmentGroupId'] as core.String
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
          trackingId: json_.containsKey('trackingId')
              ? json_['trackingId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrier != null) 'carrier': carrier!,
        if (creationDate != null) 'creationDate': creationDate!,
        if (deliveryDate != null) 'deliveryDate': deliveryDate!,
        if (id != null) 'id': id!,
        if (lineItems != null) 'lineItems': lineItems!,
        if (scheduledDeliveryDetails != null)
          'scheduledDeliveryDetails': scheduledDeliveryDetails!,
        if (shipmentGroupId != null) 'shipmentGroupId': shipmentGroupId!,
        if (status != null) 'status': status!,
        if (trackingId != null) 'trackingId': trackingId!,
      };
}

class OrderShipmentLineItemShipment {
  /// The ID of the line item that is shipped.
  ///
  /// This value is assigned by Google when an order is created. Either
  /// lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the product to ship.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  /// The quantity that is shipped.
  core.int? quantity;

  OrderShipmentLineItemShipment({
    this.lineItemId,
    this.productId,
    this.quantity,
  });

  OrderShipmentLineItemShipment.fromJson(core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (productId != null) 'productId': productId!,
        if (quantity != null) 'quantity': quantity!,
      };
}

class OrderShipmentScheduledDeliveryDetails {
  /// The phone number of the carrier fulfilling the delivery.
  ///
  /// The phone number is formatted as the international notation in ITU-T
  /// Recommendation E.123 (for example, "+41 44 668 1800").
  core.String? carrierPhoneNumber;

  /// The date a shipment is scheduled for delivery, in ISO 8601 format.
  core.String? scheduledDate;

  OrderShipmentScheduledDeliveryDetails({
    this.carrierPhoneNumber,
    this.scheduledDate,
  });

  OrderShipmentScheduledDeliveryDetails.fromJson(core.Map json_)
      : this(
          carrierPhoneNumber: json_.containsKey('carrierPhoneNumber')
              ? json_['carrierPhoneNumber'] as core.String
              : null,
          scheduledDate: json_.containsKey('scheduledDate')
              ? json_['scheduledDate'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrierPhoneNumber != null)
          'carrierPhoneNumber': carrierPhoneNumber!,
        if (scheduledDate != null) 'scheduledDate': scheduledDate!,
      };
}

/// Represents a merchant trade from which signals are extracted, e.g. shipping.
class OrderTrackingSignal {
  /// The shipping fee of the order; this value should be set to zero in the
  /// case of free shipping.
  PriceAmount? customerShippingFee;

  /// The delivery postal code, as a continuous string without spaces or dashes,
  /// e.g. "95016".
  ///
  /// This field will be anonymized in returned OrderTrackingSignal creation
  /// response.
  ///
  /// Required.
  core.String? deliveryPostalCode;

  /// The
  /// [CLDR territory code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
  /// for the shipping destination.
  ///
  /// Required.
  core.String? deliveryRegionCode;

  /// Information about line items in the order.
  core.List<OrderTrackingSignalLineItemDetails>? lineItems;

  /// The Google merchant ID of this order tracking signal.
  ///
  /// This value is optional. If left unset, the caller's merchant ID is used.
  /// You must request access in order to provide data on behalf of another
  /// merchant. For more information, see \[Submitting Order Tracking
  /// Signals\](/shopping-content/guides/order-tracking-signals).
  core.String? merchantId;

  /// The time when the order was created on the merchant side.
  ///
  /// Include the year and timezone string, if available.
  ///
  /// Required.
  DateTime? orderCreatedTime;

  /// The ID of the order on the merchant side.
  ///
  /// This field will be hashed in returned OrderTrackingSignal creation
  /// response.
  ///
  /// Required.
  core.String? orderId;

  /// The ID that uniquely identifies this order tracking signal.
  ///
  /// Output only.
  core.String? orderTrackingSignalId;

  /// The mapping of the line items to the shipment information.
  core.List<OrderTrackingSignalShipmentLineItemMapping>?
      shipmentLineItemMapping;

  /// The shipping information for the order.
  core.List<OrderTrackingSignalShippingInfo>? shippingInfo;

  OrderTrackingSignal({
    this.customerShippingFee,
    this.deliveryPostalCode,
    this.deliveryRegionCode,
    this.lineItems,
    this.merchantId,
    this.orderCreatedTime,
    this.orderId,
    this.orderTrackingSignalId,
    this.shipmentLineItemMapping,
    this.shippingInfo,
  });

  OrderTrackingSignal.fromJson(core.Map json_)
      : this(
          customerShippingFee: json_.containsKey('customerShippingFee')
              ? PriceAmount.fromJson(json_['customerShippingFee']
                  as core.Map<core.String, core.dynamic>)
              : null,
          deliveryPostalCode: json_.containsKey('deliveryPostalCode')
              ? json_['deliveryPostalCode'] as core.String
              : null,
          deliveryRegionCode: json_.containsKey('deliveryRegionCode')
              ? json_['deliveryRegionCode'] as core.String
              : null,
          lineItems: json_.containsKey('lineItems')
              ? (json_['lineItems'] as core.List)
                  .map((value) => OrderTrackingSignalLineItemDetails.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          orderCreatedTime: json_.containsKey('orderCreatedTime')
              ? DateTime.fromJson(json_['orderCreatedTime']
                  as core.Map<core.String, core.dynamic>)
              : null,
          orderId: json_.containsKey('orderId')
              ? json_['orderId'] as core.String
              : null,
          orderTrackingSignalId: json_.containsKey('orderTrackingSignalId')
              ? json_['orderTrackingSignalId'] as core.String
              : null,
          shipmentLineItemMapping: json_.containsKey('shipmentLineItemMapping')
              ? (json_['shipmentLineItemMapping'] as core.List)
                  .map((value) =>
                      OrderTrackingSignalShipmentLineItemMapping.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          shippingInfo: json_.containsKey('shippingInfo')
              ? (json_['shippingInfo'] as core.List)
                  .map((value) => OrderTrackingSignalShippingInfo.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (customerShippingFee != null)
          'customerShippingFee': customerShippingFee!,
        if (deliveryPostalCode != null)
          'deliveryPostalCode': deliveryPostalCode!,
        if (deliveryRegionCode != null)
          'deliveryRegionCode': deliveryRegionCode!,
        if (lineItems != null) 'lineItems': lineItems!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (orderCreatedTime != null) 'orderCreatedTime': orderCreatedTime!,
        if (orderId != null) 'orderId': orderId!,
        if (orderTrackingSignalId != null)
          'orderTrackingSignalId': orderTrackingSignalId!,
        if (shipmentLineItemMapping != null)
          'shipmentLineItemMapping': shipmentLineItemMapping!,
        if (shippingInfo != null) 'shippingInfo': shippingInfo!,
      };
}

/// The line items of the order.
class OrderTrackingSignalLineItemDetails {
  /// Brand of the product.
  core.String? brand;

  /// The Global Trade Item Number.
  core.String? gtin;

  /// The ID for this line item.
  ///
  /// Required.
  core.String? lineItemId;

  /// The manufacturer part number.
  core.String? mpn;

  /// Plain text description of this product (deprecated: Please use
  /// product_title instead).
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? productDescription;

  /// The Content API REST ID of the product, in the form
  /// channel:contentLanguage:targetCountry:offerId.
  ///
  /// Required.
  core.String? productId;

  /// Plain text title of this product.
  core.String? productTitle;

  /// The quantity of the line item in the order.
  core.String? quantity;

  /// Merchant SKU for this item (deprecated).
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? sku;

  /// Universal product code for this item (deprecated: Please use GTIN
  /// instead).
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? upc;

  OrderTrackingSignalLineItemDetails({
    this.brand,
    this.gtin,
    this.lineItemId,
    this.mpn,
    this.productDescription,
    this.productId,
    this.productTitle,
    this.quantity,
    this.sku,
    this.upc,
  });

  OrderTrackingSignalLineItemDetails.fromJson(core.Map json_)
      : this(
          brand:
              json_.containsKey('brand') ? json_['brand'] as core.String : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          mpn: json_.containsKey('mpn') ? json_['mpn'] as core.String : null,
          productDescription: json_.containsKey('productDescription')
              ? json_['productDescription'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          productTitle: json_.containsKey('productTitle')
              ? json_['productTitle'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.String
              : null,
          sku: json_.containsKey('sku') ? json_['sku'] as core.String : null,
          upc: json_.containsKey('upc') ? json_['upc'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (brand != null) 'brand': brand!,
        if (gtin != null) 'gtin': gtin!,
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (mpn != null) 'mpn': mpn!,
        if (productDescription != null)
          'productDescription': productDescription!,
        if (productId != null) 'productId': productId!,
        if (productTitle != null) 'productTitle': productTitle!,
        if (quantity != null) 'quantity': quantity!,
        if (sku != null) 'sku': sku!,
        if (upc != null) 'upc': upc!,
      };
}

/// Represents how many items are in the shipment for the given shipment_id and
/// line_item_id.
class OrderTrackingSignalShipmentLineItemMapping {
  /// The line item ID.
  ///
  /// Required.
  core.String? lineItemId;

  /// The line item quantity in the shipment.
  core.String? quantity;

  /// The shipment ID.
  ///
  /// This field will be hashed in returned OrderTrackingSignal creation
  /// response.
  ///
  /// Required.
  core.String? shipmentId;

  OrderTrackingSignalShipmentLineItemMapping({
    this.lineItemId,
    this.quantity,
    this.shipmentId,
  });

  OrderTrackingSignalShipmentLineItemMapping.fromJson(core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.String
              : null,
          shipmentId: json_.containsKey('shipmentId')
              ? json_['shipmentId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (quantity != null) 'quantity': quantity!,
        if (shipmentId != null) 'shipmentId': shipmentId!,
      };
}

/// The shipping information for the order.
class OrderTrackingSignalShippingInfo {
  /// The time when the shipment was actually delivered.
  ///
  /// Include the year and timezone string, if available. This field is
  /// required, if one of the following fields is absent: tracking_id or
  /// carrier_name.
  DateTime? actualDeliveryTime;

  /// The name of the shipping carrier for the delivery.
  ///
  /// This field is required if one of the following fields is absent:
  /// earliest_delivery_promise_time, latest_delivery_promise_time, and
  /// actual_delivery_time.
  core.String? carrierName;

  /// The service type for fulfillment, e.g., GROUND, FIRST_CLASS, etc.
  core.String? carrierServiceName;

  /// The earliest delivery promised time.
  ///
  /// Include the year and timezone string, if available. This field is
  /// required, if one of the following fields is absent: tracking_id or
  /// carrier_name.
  DateTime? earliestDeliveryPromiseTime;

  /// The latest delivery promised time.
  ///
  /// Include the year and timezone string, if available. This field is
  /// required, if one of the following fields is absent: tracking_id or
  /// carrier_name.
  DateTime? latestDeliveryPromiseTime;

  /// The origin postal code, as a continuous string without spaces or dashes,
  /// e.g. "95016".
  ///
  /// This field will be anonymized in returned OrderTrackingSignal creation
  /// response.
  core.String? originPostalCode;

  /// The
  /// [CLDR territory code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
  /// for the shipping origin.
  core.String? originRegionCode;

  /// The shipment ID.
  ///
  /// This field will be hashed in returned OrderTrackingSignal creation
  /// response.
  ///
  /// Required.
  core.String? shipmentId;

  /// The time when the shipment was shipped.
  ///
  /// Include the year and timezone string, if available.
  DateTime? shippedTime;

  /// The status of the shipment.
  /// Possible string values are:
  /// - "SHIPPING_STATE_UNSPECIFIED" : The shipping status is not known to
  /// merchant.
  /// - "SHIPPED" : All items are shipped.
  /// - "DELIVERED" : The shipment is already delivered.
  core.String? shippingStatus;

  /// The tracking ID of the shipment.
  ///
  /// This field is required if one of the following fields is absent:
  /// earliest_delivery_promise_time, latest_delivery_promise_time, and
  /// actual_delivery_time.
  core.String? trackingId;

  OrderTrackingSignalShippingInfo({
    this.actualDeliveryTime,
    this.carrierName,
    this.carrierServiceName,
    this.earliestDeliveryPromiseTime,
    this.latestDeliveryPromiseTime,
    this.originPostalCode,
    this.originRegionCode,
    this.shipmentId,
    this.shippedTime,
    this.shippingStatus,
    this.trackingId,
  });

  OrderTrackingSignalShippingInfo.fromJson(core.Map json_)
      : this(
          actualDeliveryTime: json_.containsKey('actualDeliveryTime')
              ? DateTime.fromJson(json_['actualDeliveryTime']
                  as core.Map<core.String, core.dynamic>)
              : null,
          carrierName: json_.containsKey('carrierName')
              ? json_['carrierName'] as core.String
              : null,
          carrierServiceName: json_.containsKey('carrierServiceName')
              ? json_['carrierServiceName'] as core.String
              : null,
          earliestDeliveryPromiseTime:
              json_.containsKey('earliestDeliveryPromiseTime')
                  ? DateTime.fromJson(json_['earliestDeliveryPromiseTime']
                      as core.Map<core.String, core.dynamic>)
                  : null,
          latestDeliveryPromiseTime:
              json_.containsKey('latestDeliveryPromiseTime')
                  ? DateTime.fromJson(json_['latestDeliveryPromiseTime']
                      as core.Map<core.String, core.dynamic>)
                  : null,
          originPostalCode: json_.containsKey('originPostalCode')
              ? json_['originPostalCode'] as core.String
              : null,
          originRegionCode: json_.containsKey('originRegionCode')
              ? json_['originRegionCode'] as core.String
              : null,
          shipmentId: json_.containsKey('shipmentId')
              ? json_['shipmentId'] as core.String
              : null,
          shippedTime: json_.containsKey('shippedTime')
              ? DateTime.fromJson(
                  json_['shippedTime'] as core.Map<core.String, core.dynamic>)
              : null,
          shippingStatus: json_.containsKey('shippingStatus')
              ? json_['shippingStatus'] as core.String
              : null,
          trackingId: json_.containsKey('trackingId')
              ? json_['trackingId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (actualDeliveryTime != null)
          'actualDeliveryTime': actualDeliveryTime!,
        if (carrierName != null) 'carrierName': carrierName!,
        if (carrierServiceName != null)
          'carrierServiceName': carrierServiceName!,
        if (earliestDeliveryPromiseTime != null)
          'earliestDeliveryPromiseTime': earliestDeliveryPromiseTime!,
        if (latestDeliveryPromiseTime != null)
          'latestDeliveryPromiseTime': latestDeliveryPromiseTime!,
        if (originPostalCode != null) 'originPostalCode': originPostalCode!,
        if (originRegionCode != null) 'originRegionCode': originRegionCode!,
        if (shipmentId != null) 'shipmentId': shipmentId!,
        if (shippedTime != null) 'shippedTime': shippedTime!,
        if (shippingStatus != null) 'shippingStatus': shippingStatus!,
        if (trackingId != null) 'trackingId': trackingId!,
      };
}

class OrderinvoicesCreateChargeInvoiceRequest {
  /// The ID of the invoice.
  ///
  /// Required.
  core.String? invoiceId;

  /// Invoice summary.
  ///
  /// Required.
  InvoiceSummary? invoiceSummary;

  /// Invoice details per line item.
  ///
  /// Required.
  core.List<ShipmentInvoiceLineItemInvoice>? lineItemInvoices;

  /// The ID of the operation, unique across all operations for a given order.
  ///
  /// Required.
  core.String? operationId;

  /// ID of the shipment group.
  ///
  /// It is assigned by the merchant in the `shipLineItems` method and is used
  /// to group multiple line items that have the same kind of shipping charges.
  ///
  /// Required.
  core.String? shipmentGroupId;

  OrderinvoicesCreateChargeInvoiceRequest({
    this.invoiceId,
    this.invoiceSummary,
    this.lineItemInvoices,
    this.operationId,
    this.shipmentGroupId,
  });

  OrderinvoicesCreateChargeInvoiceRequest.fromJson(core.Map json_)
      : this(
          invoiceId: json_.containsKey('invoiceId')
              ? json_['invoiceId'] as core.String
              : null,
          invoiceSummary: json_.containsKey('invoiceSummary')
              ? InvoiceSummary.fromJson(json_['invoiceSummary']
                  as core.Map<core.String, core.dynamic>)
              : null,
          lineItemInvoices: json_.containsKey('lineItemInvoices')
              ? (json_['lineItemInvoices'] as core.List)
                  .map((value) => ShipmentInvoiceLineItemInvoice.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          shipmentGroupId: json_.containsKey('shipmentGroupId')
              ? json_['shipmentGroupId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (invoiceId != null) 'invoiceId': invoiceId!,
        if (invoiceSummary != null) 'invoiceSummary': invoiceSummary!,
        if (lineItemInvoices != null) 'lineItemInvoices': lineItemInvoices!,
        if (operationId != null) 'operationId': operationId!,
        if (shipmentGroupId != null) 'shipmentGroupId': shipmentGroupId!,
      };
}

class OrderinvoicesCreateChargeInvoiceResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#orderinvoicesCreateChargeInvoiceResponse`".
  core.String? kind;

  OrderinvoicesCreateChargeInvoiceResponse({
    this.executionStatus,
    this.kind,
  });

  OrderinvoicesCreateChargeInvoiceResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrderinvoicesCreateRefundInvoiceRequest {
  /// The ID of the invoice.
  ///
  /// Required.
  core.String? invoiceId;

  /// The ID of the operation, unique across all operations for a given order.
  ///
  /// Required.
  core.String? operationId;

  /// Option to create a refund-only invoice.
  ///
  /// Exactly one of `refundOnlyOption` or `returnOption` must be provided.
  OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption?
      refundOnlyOption;

  /// Option to create an invoice for a refund and mark all items within the
  /// invoice as returned.
  ///
  /// Exactly one of `refundOnlyOption` or `returnOption` must be provided.
  OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption?
      returnOption;

  /// Invoice details for different shipment groups.
  core.List<ShipmentInvoice>? shipmentInvoices;

  OrderinvoicesCreateRefundInvoiceRequest({
    this.invoiceId,
    this.operationId,
    this.refundOnlyOption,
    this.returnOption,
    this.shipmentInvoices,
  });

  OrderinvoicesCreateRefundInvoiceRequest.fromJson(core.Map json_)
      : this(
          invoiceId: json_.containsKey('invoiceId')
              ? json_['invoiceId'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          refundOnlyOption: json_.containsKey('refundOnlyOption')
              ? OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption
                  .fromJson(json_['refundOnlyOption']
                      as core.Map<core.String, core.dynamic>)
              : null,
          returnOption: json_.containsKey('returnOption')
              ? OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption
                  .fromJson(json_['returnOption']
                      as core.Map<core.String, core.dynamic>)
              : null,
          shipmentInvoices: json_.containsKey('shipmentInvoices')
              ? (json_['shipmentInvoices'] as core.List)
                  .map((value) => ShipmentInvoice.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (invoiceId != null) 'invoiceId': invoiceId!,
        if (operationId != null) 'operationId': operationId!,
        if (refundOnlyOption != null) 'refundOnlyOption': refundOnlyOption!,
        if (returnOption != null) 'returnOption': returnOption!,
        if (shipmentInvoices != null) 'shipmentInvoices': shipmentInvoices!,
      };
}

class OrderinvoicesCreateRefundInvoiceResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#orderinvoicesCreateRefundInvoiceResponse`".
  core.String? kind;

  OrderinvoicesCreateRefundInvoiceResponse({
    this.executionStatus,
    this.kind,
  });

  OrderinvoicesCreateRefundInvoiceResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption {
  /// Optional description of the refund reason.
  core.String? description;

  /// Reason for the refund.
  ///
  /// Acceptable values are: - "`adjustment`" - "`autoPostInternal`" -
  /// "`autoPostInvalidBillingAddress`" - "`autoPostNoInventory`" -
  /// "`autoPostPriceError`" - "`autoPostUndeliverableShippingAddress`" -
  /// "`couponAbuse`" - "`courtesyAdjustment`" - "`customerCanceled`" -
  /// "`customerDiscretionaryReturn`" - "`customerInitiatedMerchantCancel`" -
  /// "`customerSupportRequested`" - "`deliveredLateByCarrier`" -
  /// "`deliveredTooLate`" - "`expiredItem`" - "`failToPushOrderGoogleError`" -
  /// "`failToPushOrderMerchantError`" -
  /// "`failToPushOrderMerchantFulfillmentError`" -
  /// "`failToPushOrderToMerchant`" - "`failToPushOrderToMerchantOutOfStock`" -
  /// "`feeAdjustment`" - "`invalidCoupon`" - "`lateShipmentCredit`" -
  /// "`malformedShippingAddress`" - "`merchantDidNotShipOnTime`" -
  /// "`noInventory`" - "`orderTimeout`" - "`other`" - "`paymentAbuse`" -
  /// "`paymentDeclined`" - "`priceAdjustment`" - "`priceError`" -
  /// "`productArrivedDamaged`" - "`productNotAsDescribed`" -
  /// "`promoReallocation`" - "`qualityNotAsExpected`" - "`returnRefundAbuse`" -
  /// "`shippingCostAdjustment`" - "`shippingPriceError`" - "`taxAdjustment`" -
  /// "`taxError`" - "`undeliverableShippingAddress`" -
  /// "`unsupportedPoBoxAddress`" - "`wrongProductShipped`"
  ///
  /// Required.
  core.String? reason;

  OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption({
    this.description,
    this.reason,
  });

  OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceRefundOption.fromJson(
      core.Map json_)
      : this(
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (description != null) 'description': description!,
        if (reason != null) 'reason': reason!,
      };
}

class OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption {
  /// Optional description of the return reason.
  core.String? description;

  /// Reason for the return.
  ///
  /// Acceptable values are: - "`customerDiscretionaryReturn`" -
  /// "`customerInitiatedMerchantCancel`" - "`deliveredTooLate`" -
  /// "`expiredItem`" - "`invalidCoupon`" - "`malformedShippingAddress`" -
  /// "`other`" - "`productArrivedDamaged`" - "`productNotAsDescribed`" -
  /// "`qualityNotAsExpected`" - "`undeliverableShippingAddress`" -
  /// "`unsupportedPoBoxAddress`" - "`wrongProductShipped`"
  ///
  /// Required.
  core.String? reason;

  OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption({
    this.description,
    this.reason,
  });

  OrderinvoicesCustomBatchRequestEntryCreateRefundInvoiceReturnOption.fromJson(
      core.Map json_)
      : this(
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (description != null) 'description': description!,
        if (reason != null) 'reason': reason!,
      };
}

class OrderreportsListDisbursementsResponse {
  /// The list of disbursements.
  core.List<OrderReportDisbursement>? disbursements;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#orderreportsListDisbursementsResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of disbursements.
  core.String? nextPageToken;

  OrderreportsListDisbursementsResponse({
    this.disbursements,
    this.kind,
    this.nextPageToken,
  });

  OrderreportsListDisbursementsResponse.fromJson(core.Map json_)
      : this(
          disbursements: json_.containsKey('disbursements')
              ? (json_['disbursements'] as core.List)
                  .map((value) => OrderReportDisbursement.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (disbursements != null) 'disbursements': disbursements!,
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

class OrderreportsListTransactionsResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#orderreportsListTransactionsResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of transactions.
  core.String? nextPageToken;

  /// The list of transactions.
  core.List<OrderReportTransaction>? transactions;

  OrderreportsListTransactionsResponse({
    this.kind,
    this.nextPageToken,
    this.transactions,
  });

  OrderreportsListTransactionsResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          transactions: json_.containsKey('transactions')
              ? (json_['transactions'] as core.List)
                  .map((value) => OrderReportTransaction.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (transactions != null) 'transactions': transactions!,
      };
}

class OrderreturnsAcknowledgeRequest {
  /// The ID of the operation, unique across all operations for a given order
  /// return.
  ///
  /// Required.
  core.String? operationId;

  OrderreturnsAcknowledgeRequest({
    this.operationId,
  });

  OrderreturnsAcknowledgeRequest.fromJson(core.Map json_)
      : this(
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (operationId != null) 'operationId': operationId!,
      };
}

class OrderreturnsAcknowledgeResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#orderreturnsAcknowledgeResponse`".
  core.String? kind;

  OrderreturnsAcknowledgeResponse({
    this.executionStatus,
    this.kind,
  });

  OrderreturnsAcknowledgeResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrderreturnsCreateOrderReturnRequest {
  /// The list of line items to return.
  core.List<OrderreturnsLineItem>? lineItems;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The ID of the order.
  core.String? orderId;

  /// The way of the package being returned.
  core.String? returnMethodType;

  OrderreturnsCreateOrderReturnRequest({
    this.lineItems,
    this.operationId,
    this.orderId,
    this.returnMethodType,
  });

  OrderreturnsCreateOrderReturnRequest.fromJson(core.Map json_)
      : this(
          lineItems: json_.containsKey('lineItems')
              ? (json_['lineItems'] as core.List)
                  .map((value) => OrderreturnsLineItem.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          orderId: json_.containsKey('orderId')
              ? json_['orderId'] as core.String
              : null,
          returnMethodType: json_.containsKey('returnMethodType')
              ? json_['returnMethodType'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItems != null) 'lineItems': lineItems!,
        if (operationId != null) 'operationId': operationId!,
        if (orderId != null) 'orderId': orderId!,
        if (returnMethodType != null) 'returnMethodType': returnMethodType!,
      };
}

class OrderreturnsCreateOrderReturnResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#orderreturnsCreateOrderReturnResponse`".
  core.String? kind;

  /// Created order return.
  MerchantOrderReturn? orderReturn;

  OrderreturnsCreateOrderReturnResponse({
    this.executionStatus,
    this.kind,
    this.orderReturn,
  });

  OrderreturnsCreateOrderReturnResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          orderReturn: json_.containsKey('orderReturn')
              ? MerchantOrderReturn.fromJson(
                  json_['orderReturn'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
        if (orderReturn != null) 'orderReturn': orderReturn!,
      };
}

class OrderreturnsLineItem {
  /// The ID of the line item.
  ///
  /// This value is assigned by Google when an order is created. Either
  /// lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the product to cancel.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  /// The quantity of this line item.
  core.int? quantity;

  OrderreturnsLineItem({
    this.lineItemId,
    this.productId,
    this.quantity,
  });

  OrderreturnsLineItem.fromJson(core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (productId != null) 'productId': productId!,
        if (quantity != null) 'quantity': quantity!,
      };
}

class OrderreturnsListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#orderreturnsListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of returns.
  core.String? nextPageToken;
  core.List<MerchantOrderReturn>? resources;

  OrderreturnsListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  OrderreturnsListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => MerchantOrderReturn.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

class OrderreturnsPartialRefund {
  /// The pre-tax or post-tax amount to be refunded, depending on the location
  /// of the order.
  Price? priceAmount;

  /// Tax amount to be refunded.
  ///
  /// Note: This has different meaning depending on the location of the order.
  Price? taxAmount;

  OrderreturnsPartialRefund({
    this.priceAmount,
    this.taxAmount,
  });

  OrderreturnsPartialRefund.fromJson(core.Map json_)
      : this(
          priceAmount: json_.containsKey('priceAmount')
              ? Price.fromJson(
                  json_['priceAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          taxAmount: json_.containsKey('taxAmount')
              ? Price.fromJson(
                  json_['taxAmount'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (priceAmount != null) 'priceAmount': priceAmount!,
        if (taxAmount != null) 'taxAmount': taxAmount!,
      };
}

class OrderreturnsProcessRequest {
  /// Option to charge the customer return shipping cost.
  core.bool? fullChargeReturnShippingCost;

  /// The ID of the operation, unique across all operations for a given order
  /// return.
  ///
  /// Required.
  core.String? operationId;

  /// Refunds for original shipping fee.
  OrderreturnsRefundOperation? refundShippingFee;

  /// The list of items to return.
  core.List<OrderreturnsReturnItem>? returnItems;

  OrderreturnsProcessRequest({
    this.fullChargeReturnShippingCost,
    this.operationId,
    this.refundShippingFee,
    this.returnItems,
  });

  OrderreturnsProcessRequest.fromJson(core.Map json_)
      : this(
          fullChargeReturnShippingCost:
              json_.containsKey('fullChargeReturnShippingCost')
                  ? json_['fullChargeReturnShippingCost'] as core.bool
                  : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          refundShippingFee: json_.containsKey('refundShippingFee')
              ? OrderreturnsRefundOperation.fromJson(json_['refundShippingFee']
                  as core.Map<core.String, core.dynamic>)
              : null,
          returnItems: json_.containsKey('returnItems')
              ? (json_['returnItems'] as core.List)
                  .map((value) => OrderreturnsReturnItem.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (fullChargeReturnShippingCost != null)
          'fullChargeReturnShippingCost': fullChargeReturnShippingCost!,
        if (operationId != null) 'operationId': operationId!,
        if (refundShippingFee != null) 'refundShippingFee': refundShippingFee!,
        if (returnItems != null) 'returnItems': returnItems!,
      };
}

class OrderreturnsProcessResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#orderreturnsProcessResponse`".
  core.String? kind;

  OrderreturnsProcessResponse({
    this.executionStatus,
    this.kind,
  });

  OrderreturnsProcessResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrderreturnsRefundOperation {
  /// If true, the item will be fully refunded.
  ///
  /// Allowed only when payment_type is FOP. Merchant can choose this refund
  /// option to indicate the full remaining amount of corresponding object to be
  /// refunded to the customer through FOP.
  core.bool? fullRefund;

  /// If this is set, the item will be partially refunded.
  ///
  /// Merchant can choose this refund option to specify the customized amount
  /// that to be refunded to the customer.
  OrderreturnsPartialRefund? partialRefund;

  /// The payment way of issuing refund.
  ///
  /// Default value is ORIGINAL_FOP if not set.
  core.String? paymentType;

  /// The explanation of the reason.
  core.String? reasonText;

  /// Code of the refund reason.
  core.String? returnRefundReason;

  OrderreturnsRefundOperation({
    this.fullRefund,
    this.partialRefund,
    this.paymentType,
    this.reasonText,
    this.returnRefundReason,
  });

  OrderreturnsRefundOperation.fromJson(core.Map json_)
      : this(
          fullRefund: json_.containsKey('fullRefund')
              ? json_['fullRefund'] as core.bool
              : null,
          partialRefund: json_.containsKey('partialRefund')
              ? OrderreturnsPartialRefund.fromJson(
                  json_['partialRefund'] as core.Map<core.String, core.dynamic>)
              : null,
          paymentType: json_.containsKey('paymentType')
              ? json_['paymentType'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
          returnRefundReason: json_.containsKey('returnRefundReason')
              ? json_['returnRefundReason'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (fullRefund != null) 'fullRefund': fullRefund!,
        if (partialRefund != null) 'partialRefund': partialRefund!,
        if (paymentType != null) 'paymentType': paymentType!,
        if (reasonText != null) 'reasonText': reasonText!,
        if (returnRefundReason != null)
          'returnRefundReason': returnRefundReason!,
      };
}

class OrderreturnsRejectOperation {
  /// The reason for the return.
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  OrderreturnsRejectOperation({
    this.reason,
    this.reasonText,
  });

  OrderreturnsRejectOperation.fromJson(core.Map json_)
      : this(
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
      };
}

class OrderreturnsReturnItem {
  /// Refunds the item.
  OrderreturnsRefundOperation? refund;

  /// Rejects the item.
  OrderreturnsRejectOperation? reject;

  /// Unit level ID for the return item.
  ///
  /// Different units of the same product will have different IDs.
  core.String? returnItemId;

  OrderreturnsReturnItem({
    this.refund,
    this.reject,
    this.returnItemId,
  });

  OrderreturnsReturnItem.fromJson(core.Map json_)
      : this(
          refund: json_.containsKey('refund')
              ? OrderreturnsRefundOperation.fromJson(
                  json_['refund'] as core.Map<core.String, core.dynamic>)
              : null,
          reject: json_.containsKey('reject')
              ? OrderreturnsRejectOperation.fromJson(
                  json_['reject'] as core.Map<core.String, core.dynamic>)
              : null,
          returnItemId: json_.containsKey('returnItemId')
              ? json_['returnItemId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (refund != null) 'refund': refund!,
        if (reject != null) 'reject': reject!,
        if (returnItemId != null) 'returnItemId': returnItemId!,
      };
}

class OrdersAcknowledgeRequest {
  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  OrdersAcknowledgeRequest({
    this.operationId,
  });

  OrdersAcknowledgeRequest.fromJson(core.Map json_)
      : this(
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (operationId != null) 'operationId': operationId!,
      };
}

class OrdersAcknowledgeResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersAcknowledgeResponse`".
  core.String? kind;

  OrdersAcknowledgeResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersAcknowledgeResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersAdvanceTestOrderResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersAdvanceTestOrderResponse`".
  core.String? kind;

  OrdersAdvanceTestOrderResponse({
    this.kind,
  });

  OrdersAdvanceTestOrderResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class OrdersCancelLineItemRequest {
  /// The ID of the line item to cancel.
  ///
  /// Either lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The ID of the product to cancel.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  /// The quantity to cancel.
  core.int? quantity;

  /// The reason for the cancellation.
  ///
  /// Acceptable values are: - "`customerInitiatedCancel`" - "`invalidCoupon`" -
  /// "`malformedShippingAddress`" - "`noInventory`" - "`other`" -
  /// "`priceError`" - "`shippingPriceError`" - "`taxError`" -
  /// "`undeliverableShippingAddress`" - "`unsupportedPoBoxAddress`" -
  /// "`failedToCaptureFunds`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  OrdersCancelLineItemRequest({
    this.lineItemId,
    this.operationId,
    this.productId,
    this.quantity,
    this.reason,
    this.reasonText,
  });

  OrdersCancelLineItemRequest.fromJson(core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (operationId != null) 'operationId': operationId!,
        if (productId != null) 'productId': productId!,
        if (quantity != null) 'quantity': quantity!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
      };
}

class OrdersCancelLineItemResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersCancelLineItemResponse`".
  core.String? kind;

  OrdersCancelLineItemResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersCancelLineItemResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersCancelRequest {
  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The reason for the cancellation.
  ///
  /// Acceptable values are: - "`customerInitiatedCancel`" - "`invalidCoupon`" -
  /// "`malformedShippingAddress`" - "`noInventory`" - "`other`" -
  /// "`priceError`" - "`shippingPriceError`" - "`taxError`" -
  /// "`undeliverableShippingAddress`" - "`unsupportedPoBoxAddress`" -
  /// "`failedToCaptureFunds`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  OrdersCancelRequest({
    this.operationId,
    this.reason,
    this.reasonText,
  });

  OrdersCancelRequest.fromJson(core.Map json_)
      : this(
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (operationId != null) 'operationId': operationId!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
      };
}

class OrdersCancelResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersCancelResponse`".
  core.String? kind;

  OrdersCancelResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersCancelResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersCancelTestOrderByCustomerRequest {
  /// The reason for the cancellation.
  ///
  /// Acceptable values are: - "`changedMind`" - "`orderedWrongItem`" -
  /// "`other`"
  core.String? reason;

  OrdersCancelTestOrderByCustomerRequest({
    this.reason,
  });

  OrdersCancelTestOrderByCustomerRequest.fromJson(core.Map json_)
      : this(
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (reason != null) 'reason': reason!,
      };
}

class OrdersCancelTestOrderByCustomerResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#ordersCancelTestOrderByCustomerResponse`".
  core.String? kind;

  OrdersCancelTestOrderByCustomerResponse({
    this.kind,
  });

  OrdersCancelTestOrderByCustomerResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
      };
}

class OrdersCreateTestOrderRequest {
  /// The CLDR territory code of the country of the test order to create.
  ///
  /// Affects the currency and addresses of orders created through
  /// `template_name`, or the addresses of orders created through `test_order`.
  /// Acceptable values are: - "`US`" - "`FR`" Defaults to "`US`".
  core.String? country;

  /// The test order template to use.
  ///
  /// Specify as an alternative to `testOrder` as a shortcut for retrieving a
  /// template and then creating an order using that template. Acceptable values
  /// are: - "`template1`" - "`template1a`" - "`template1b`" - "`template2`" -
  /// "`template3`"
  core.String? templateName;

  /// The test order to create.
  TestOrder? testOrder;

  OrdersCreateTestOrderRequest({
    this.country,
    this.templateName,
    this.testOrder,
  });

  OrdersCreateTestOrderRequest.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          templateName: json_.containsKey('templateName')
              ? json_['templateName'] as core.String
              : null,
          testOrder: json_.containsKey('testOrder')
              ? TestOrder.fromJson(
                  json_['testOrder'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (templateName != null) 'templateName': templateName!,
        if (testOrder != null) 'testOrder': testOrder!,
      };
}

class OrdersCreateTestOrderResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersCreateTestOrderResponse`".
  core.String? kind;

  /// The ID of the newly created test order.
  core.String? orderId;

  OrdersCreateTestOrderResponse({
    this.kind,
    this.orderId,
  });

  OrdersCreateTestOrderResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          orderId: json_.containsKey('orderId')
              ? json_['orderId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (orderId != null) 'orderId': orderId!,
      };
}

class OrdersCreateTestReturnRequest {
  /// Returned items.
  core.List<OrdersCustomBatchRequestEntryCreateTestReturnReturnItem>? items;

  OrdersCreateTestReturnRequest({
    this.items,
  });

  OrdersCreateTestReturnRequest.fromJson(core.Map json_)
      : this(
          items: json_.containsKey('items')
              ? (json_['items'] as core.List)
                  .map((value) =>
                      OrdersCustomBatchRequestEntryCreateTestReturnReturnItem
                          .fromJson(
                              value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (items != null) 'items': items!,
      };
}

class OrdersCreateTestReturnResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersCreateTestReturnResponse`".
  core.String? kind;

  /// The ID of the newly created test order return.
  core.String? returnId;

  OrdersCreateTestReturnResponse({
    this.kind,
    this.returnId,
  });

  OrdersCreateTestReturnResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          returnId: json_.containsKey('returnId')
              ? json_['returnId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (returnId != null) 'returnId': returnId!,
      };
}

class OrdersCustomBatchRequestEntryCreateTestReturnReturnItem {
  /// The ID of the line item to return.
  core.String? lineItemId;

  /// Quantity that is returned.
  core.int? quantity;

  OrdersCustomBatchRequestEntryCreateTestReturnReturnItem({
    this.lineItemId,
    this.quantity,
  });

  OrdersCustomBatchRequestEntryCreateTestReturnReturnItem.fromJson(
      core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (quantity != null) 'quantity': quantity!,
      };
}

class OrdersCustomBatchRequestEntryRefundItemItem {
  /// The total amount that is refunded.
  ///
  /// (for example, refunding $5 each for 2 products should be done by setting
  /// quantity to 2 and amount to 10$) In case of multiple refunds, this should
  /// be the amount you currently want to refund to the customer.
  MonetaryAmount? amount;

  /// If true, the full item will be refunded.
  ///
  /// If this is true, amount shouldn't be provided and will be ignored.
  core.bool? fullRefund;

  /// The ID of the line item.
  ///
  /// Either lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the product.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  /// The number of products that are refunded.
  core.int? quantity;

  OrdersCustomBatchRequestEntryRefundItemItem({
    this.amount,
    this.fullRefund,
    this.lineItemId,
    this.productId,
    this.quantity,
  });

  OrdersCustomBatchRequestEntryRefundItemItem.fromJson(core.Map json_)
      : this(
          amount: json_.containsKey('amount')
              ? MonetaryAmount.fromJson(
                  json_['amount'] as core.Map<core.String, core.dynamic>)
              : null,
          fullRefund: json_.containsKey('fullRefund')
              ? json_['fullRefund'] as core.bool
              : null,
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (amount != null) 'amount': amount!,
        if (fullRefund != null) 'fullRefund': fullRefund!,
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (productId != null) 'productId': productId!,
        if (quantity != null) 'quantity': quantity!,
      };
}

class OrdersCustomBatchRequestEntryRefundItemShipping {
  /// The amount that is refunded.
  ///
  /// If this is not the first refund for the shipment, this should be the newly
  /// refunded amount.
  Price? amount;

  /// If set to true, all shipping costs for the order will be refunded.
  ///
  /// If this is true, amount shouldn't be provided and will be ignored. If set
  /// to false, submit the amount of the partial shipping refund, excluding the
  /// shipping tax. The shipping tax is calculated and handled on Google's side.
  core.bool? fullRefund;

  OrdersCustomBatchRequestEntryRefundItemShipping({
    this.amount,
    this.fullRefund,
  });

  OrdersCustomBatchRequestEntryRefundItemShipping.fromJson(core.Map json_)
      : this(
          amount: json_.containsKey('amount')
              ? Price.fromJson(
                  json_['amount'] as core.Map<core.String, core.dynamic>)
              : null,
          fullRefund: json_.containsKey('fullRefund')
              ? json_['fullRefund'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (amount != null) 'amount': amount!,
        if (fullRefund != null) 'fullRefund': fullRefund!,
      };
}

class OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo {
  /// The carrier handling the shipment.
  ///
  /// See `shipments[].carrier` in the Orders resource representation for a list
  /// of acceptable values.
  core.String? carrier;

  /// The ID of the shipment.
  ///
  /// This is assigned by the merchant and is unique to each shipment.
  ///
  /// Required.
  core.String? shipmentId;

  /// The tracking ID for the shipment.
  core.String? trackingId;

  OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo({
    this.carrier,
    this.shipmentId,
    this.trackingId,
  });

  OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo.fromJson(
      core.Map json_)
      : this(
          carrier: json_.containsKey('carrier')
              ? json_['carrier'] as core.String
              : null,
          shipmentId: json_.containsKey('shipmentId')
              ? json_['shipmentId'] as core.String
              : null,
          trackingId: json_.containsKey('trackingId')
              ? json_['trackingId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrier != null) 'carrier': carrier!,
        if (shipmentId != null) 'shipmentId': shipmentId!,
        if (trackingId != null) 'trackingId': trackingId!,
      };
}

/// ScheduledDeliveryDetails used to update the scheduled delivery order.
class OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails {
  /// The phone number of the carrier fulfilling the delivery.
  ///
  /// The phone number should be formatted as the international notation in
  core.String? carrierPhoneNumber;

  /// The date a shipment is scheduled for delivery, in ISO 8601 format.
  core.String? scheduledDate;

  OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails({
    this.carrierPhoneNumber,
    this.scheduledDate,
  });

  OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails.fromJson(
      core.Map json_)
      : this(
          carrierPhoneNumber: json_.containsKey('carrierPhoneNumber')
              ? json_['carrierPhoneNumber'] as core.String
              : null,
          scheduledDate: json_.containsKey('scheduledDate')
              ? json_['scheduledDate'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrierPhoneNumber != null)
          'carrierPhoneNumber': carrierPhoneNumber!,
        if (scheduledDate != null) 'scheduledDate': scheduledDate!,
      };
}

class OrdersGetByMerchantOrderIdResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersGetByMerchantOrderIdResponse`".
  core.String? kind;

  /// The requested order.
  Order? order;

  OrdersGetByMerchantOrderIdResponse({
    this.kind,
    this.order,
  });

  OrdersGetByMerchantOrderIdResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          order: json_.containsKey('order')
              ? Order.fromJson(
                  json_['order'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (order != null) 'order': order!,
      };
}

class OrdersGetTestOrderTemplateResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersGetTestOrderTemplateResponse`".
  core.String? kind;

  /// The requested test order template.
  TestOrder? template;

  OrdersGetTestOrderTemplateResponse({
    this.kind,
    this.template,
  });

  OrdersGetTestOrderTemplateResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          template: json_.containsKey('template')
              ? TestOrder.fromJson(
                  json_['template'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (template != null) 'template': template!,
      };
}

class OrdersInStoreRefundLineItemRequest {
  /// The ID of the line item to return.
  ///
  /// Either lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The amount to be refunded.
  ///
  /// This may be pre-tax or post-tax depending on the location of the order.
  /// Required.
  Price? priceAmount;

  /// The ID of the product to return.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  /// The quantity to return and refund.
  core.int? quantity;

  /// The reason for the return.
  ///
  /// Acceptable values are: - "`customerDiscretionaryReturn`" -
  /// "`customerInitiatedMerchantCancel`" - "`deliveredTooLate`" -
  /// "`expiredItem`" - "`invalidCoupon`" - "`malformedShippingAddress`" -
  /// "`other`" - "`productArrivedDamaged`" - "`productNotAsDescribed`" -
  /// "`qualityNotAsExpected`" - "`undeliverableShippingAddress`" -
  /// "`unsupportedPoBoxAddress`" - "`wrongProductShipped`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  /// The amount of tax to be refunded.
  ///
  /// Required.
  Price? taxAmount;

  OrdersInStoreRefundLineItemRequest({
    this.lineItemId,
    this.operationId,
    this.priceAmount,
    this.productId,
    this.quantity,
    this.reason,
    this.reasonText,
    this.taxAmount,
  });

  OrdersInStoreRefundLineItemRequest.fromJson(core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          priceAmount: json_.containsKey('priceAmount')
              ? Price.fromJson(
                  json_['priceAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
          taxAmount: json_.containsKey('taxAmount')
              ? Price.fromJson(
                  json_['taxAmount'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (operationId != null) 'operationId': operationId!,
        if (priceAmount != null) 'priceAmount': priceAmount!,
        if (productId != null) 'productId': productId!,
        if (quantity != null) 'quantity': quantity!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
        if (taxAmount != null) 'taxAmount': taxAmount!,
      };
}

class OrdersInStoreRefundLineItemResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersInStoreRefundLineItemResponse`".
  core.String? kind;

  OrdersInStoreRefundLineItemResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersInStoreRefundLineItemResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of orders.
  core.String? nextPageToken;
  core.List<Order>? resources;

  OrdersListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  OrdersListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => Order.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

class OrdersRefundItemRequest {
  /// The items that are refunded.
  ///
  /// Either Item or Shipping must be provided in the request.
  core.List<OrdersCustomBatchRequestEntryRefundItemItem>? items;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The reason for the refund.
  ///
  /// Acceptable values are: - "`shippingCostAdjustment`" - "`priceAdjustment`"
  /// - "`taxAdjustment`" - "`feeAdjustment`" - "`courtesyAdjustment`" -
  /// "`adjustment`" - "`customerCancelled`" - "`noInventory`" -
  /// "`productNotAsDescribed`" - "`undeliverableShippingAddress`" -
  /// "`wrongProductShipped`" - "`lateShipmentCredit`" -
  /// "`deliveredLateByCarrier`" - "`productArrivedDamaged`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  /// The refund on shipping.
  ///
  /// Optional, but either Item or Shipping must be provided in the request.
  OrdersCustomBatchRequestEntryRefundItemShipping? shipping;

  OrdersRefundItemRequest({
    this.items,
    this.operationId,
    this.reason,
    this.reasonText,
    this.shipping,
  });

  OrdersRefundItemRequest.fromJson(core.Map json_)
      : this(
          items: json_.containsKey('items')
              ? (json_['items'] as core.List)
                  .map((value) =>
                      OrdersCustomBatchRequestEntryRefundItemItem.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
          shipping: json_.containsKey('shipping')
              ? OrdersCustomBatchRequestEntryRefundItemShipping.fromJson(
                  json_['shipping'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (items != null) 'items': items!,
        if (operationId != null) 'operationId': operationId!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
        if (shipping != null) 'shipping': shipping!,
      };
}

class OrdersRefundItemResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersRefundItemResponse`".
  core.String? kind;

  OrdersRefundItemResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersRefundItemResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersRefundOrderRequest {
  /// The amount that is refunded.
  ///
  /// If this is not the first refund for the order, this should be the newly
  /// refunded amount.
  MonetaryAmount? amount;

  /// If true, the full order will be refunded, including shipping.
  ///
  /// If this is true, amount shouldn't be provided and will be ignored.
  core.bool? fullRefund;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The reason for the refund.
  ///
  /// Acceptable values are: - "`courtesyAdjustment`" - "`other`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  OrdersRefundOrderRequest({
    this.amount,
    this.fullRefund,
    this.operationId,
    this.reason,
    this.reasonText,
  });

  OrdersRefundOrderRequest.fromJson(core.Map json_)
      : this(
          amount: json_.containsKey('amount')
              ? MonetaryAmount.fromJson(
                  json_['amount'] as core.Map<core.String, core.dynamic>)
              : null,
          fullRefund: json_.containsKey('fullRefund')
              ? json_['fullRefund'] as core.bool
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (amount != null) 'amount': amount!,
        if (fullRefund != null) 'fullRefund': fullRefund!,
        if (operationId != null) 'operationId': operationId!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
      };
}

class OrdersRefundOrderResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersRefundOrderResponse`".
  core.String? kind;

  OrdersRefundOrderResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersRefundOrderResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersRejectReturnLineItemRequest {
  /// The ID of the line item to return.
  ///
  /// Either lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The ID of the product to return.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  /// The quantity to return and refund.
  core.int? quantity;

  /// The reason for the return.
  ///
  /// Acceptable values are: - "`damagedOrUsed`" - "`missingComponent`" -
  /// "`notEligible`" - "`other`" - "`outOfReturnWindow`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  OrdersRejectReturnLineItemRequest({
    this.lineItemId,
    this.operationId,
    this.productId,
    this.quantity,
    this.reason,
    this.reasonText,
  });

  OrdersRejectReturnLineItemRequest.fromJson(core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (operationId != null) 'operationId': operationId!,
        if (productId != null) 'productId': productId!,
        if (quantity != null) 'quantity': quantity!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
      };
}

class OrdersRejectReturnLineItemResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersRejectReturnLineItemResponse`".
  core.String? kind;

  OrdersRejectReturnLineItemResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersRejectReturnLineItemResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersReturnRefundLineItemRequest {
  /// The ID of the line item to return.
  ///
  /// Either lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The amount to be refunded.
  ///
  /// This may be pre-tax or post-tax depending on the location of the order. If
  /// omitted, refundless return is assumed.
  Price? priceAmount;

  /// The ID of the product to return.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  /// The quantity to return and refund.
  ///
  /// Quantity is required.
  core.int? quantity;

  /// The reason for the return.
  ///
  /// Acceptable values are: - "`customerDiscretionaryReturn`" -
  /// "`customerInitiatedMerchantCancel`" - "`deliveredTooLate`" -
  /// "`expiredItem`" - "`invalidCoupon`" - "`malformedShippingAddress`" -
  /// "`other`" - "`productArrivedDamaged`" - "`productNotAsDescribed`" -
  /// "`qualityNotAsExpected`" - "`undeliverableShippingAddress`" -
  /// "`unsupportedPoBoxAddress`" - "`wrongProductShipped`"
  core.String? reason;

  /// The explanation of the reason.
  core.String? reasonText;

  /// The amount of tax to be refunded.
  ///
  /// Optional, but if filled, then priceAmount must be set. Calculated
  /// automatically if not provided.
  Price? taxAmount;

  OrdersReturnRefundLineItemRequest({
    this.lineItemId,
    this.operationId,
    this.priceAmount,
    this.productId,
    this.quantity,
    this.reason,
    this.reasonText,
    this.taxAmount,
  });

  OrdersReturnRefundLineItemRequest.fromJson(core.Map json_)
      : this(
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          priceAmount: json_.containsKey('priceAmount')
              ? Price.fromJson(
                  json_['priceAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.int
              : null,
          reason: json_.containsKey('reason')
              ? json_['reason'] as core.String
              : null,
          reasonText: json_.containsKey('reasonText')
              ? json_['reasonText'] as core.String
              : null,
          taxAmount: json_.containsKey('taxAmount')
              ? Price.fromJson(
                  json_['taxAmount'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (operationId != null) 'operationId': operationId!,
        if (priceAmount != null) 'priceAmount': priceAmount!,
        if (productId != null) 'productId': productId!,
        if (quantity != null) 'quantity': quantity!,
        if (reason != null) 'reason': reason!,
        if (reasonText != null) 'reasonText': reasonText!,
        if (taxAmount != null) 'taxAmount': taxAmount!,
      };
}

class OrdersReturnRefundLineItemResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersReturnRefundLineItemResponse`".
  core.String? kind;

  OrdersReturnRefundLineItemResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersReturnRefundLineItemResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersSetLineItemMetadataRequest {
  core.List<OrderMerchantProvidedAnnotation>? annotations;

  /// The ID of the line item to set metadata.
  ///
  /// Either lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The ID of the product to set metadata.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  OrdersSetLineItemMetadataRequest({
    this.annotations,
    this.lineItemId,
    this.operationId,
    this.productId,
  });

  OrdersSetLineItemMetadataRequest.fromJson(core.Map json_)
      : this(
          annotations: json_.containsKey('annotations')
              ? (json_['annotations'] as core.List)
                  .map((value) => OrderMerchantProvidedAnnotation.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (annotations != null) 'annotations': annotations!,
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (operationId != null) 'operationId': operationId!,
        if (productId != null) 'productId': productId!,
      };
}

class OrdersSetLineItemMetadataResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersSetLineItemMetadataResponse`".
  core.String? kind;

  OrdersSetLineItemMetadataResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersSetLineItemMetadataResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersShipLineItemsRequest {
  /// Line items to ship.
  core.List<OrderShipmentLineItemShipment>? lineItems;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// ID of the shipment group.
  ///
  /// Required for orders that use the orderinvoices service.
  core.String? shipmentGroupId;

  /// Shipment information.
  ///
  /// This field is repeated because a single line item can be shipped in
  /// several packages (and have several tracking IDs).
  core.List<OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo>?
      shipmentInfos;

  OrdersShipLineItemsRequest({
    this.lineItems,
    this.operationId,
    this.shipmentGroupId,
    this.shipmentInfos,
  });

  OrdersShipLineItemsRequest.fromJson(core.Map json_)
      : this(
          lineItems: json_.containsKey('lineItems')
              ? (json_['lineItems'] as core.List)
                  .map((value) => OrderShipmentLineItemShipment.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          shipmentGroupId: json_.containsKey('shipmentGroupId')
              ? json_['shipmentGroupId'] as core.String
              : null,
          shipmentInfos: json_.containsKey('shipmentInfos')
              ? (json_['shipmentInfos'] as core.List)
                  .map((value) =>
                      OrdersCustomBatchRequestEntryShipLineItemsShipmentInfo
                          .fromJson(
                              value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lineItems != null) 'lineItems': lineItems!,
        if (operationId != null) 'operationId': operationId!,
        if (shipmentGroupId != null) 'shipmentGroupId': shipmentGroupId!,
        if (shipmentInfos != null) 'shipmentInfos': shipmentInfos!,
      };
}

class OrdersShipLineItemsResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersShipLineItemsResponse`".
  core.String? kind;

  OrdersShipLineItemsResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersShipLineItemsResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersUpdateLineItemShippingDetailsRequest {
  /// Updated delivery by date, in ISO 8601 format.
  ///
  /// If not specified only ship by date is updated. Provided date should be
  /// within 1 year timeframe and can't be a date in the past.
  core.String? deliverByDate;

  /// The ID of the line item to set metadata.
  ///
  /// Either lineItemId or productId is required.
  core.String? lineItemId;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// The ID of the product to set metadata.
  ///
  /// This is the REST ID used in the products service. Either lineItemId or
  /// productId is required.
  core.String? productId;

  /// Updated ship by date, in ISO 8601 format.
  ///
  /// If not specified only deliver by date is updated. Provided date should be
  /// within 1 year timeframe and can't be a date in the past.
  core.String? shipByDate;

  OrdersUpdateLineItemShippingDetailsRequest({
    this.deliverByDate,
    this.lineItemId,
    this.operationId,
    this.productId,
    this.shipByDate,
  });

  OrdersUpdateLineItemShippingDetailsRequest.fromJson(core.Map json_)
      : this(
          deliverByDate: json_.containsKey('deliverByDate')
              ? json_['deliverByDate'] as core.String
              : null,
          lineItemId: json_.containsKey('lineItemId')
              ? json_['lineItemId'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          shipByDate: json_.containsKey('shipByDate')
              ? json_['shipByDate'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deliverByDate != null) 'deliverByDate': deliverByDate!,
        if (lineItemId != null) 'lineItemId': lineItemId!,
        if (operationId != null) 'operationId': operationId!,
        if (productId != null) 'productId': productId!,
        if (shipByDate != null) 'shipByDate': shipByDate!,
      };
}

class OrdersUpdateLineItemShippingDetailsResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#ordersUpdateLineItemShippingDetailsResponse`".
  core.String? kind;

  OrdersUpdateLineItemShippingDetailsResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersUpdateLineItemShippingDetailsResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersUpdateMerchantOrderIdRequest {
  /// The merchant order id to be assigned to the order.
  ///
  /// Must be unique per merchant.
  core.String? merchantOrderId;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  OrdersUpdateMerchantOrderIdRequest({
    this.merchantOrderId,
    this.operationId,
  });

  OrdersUpdateMerchantOrderIdRequest.fromJson(core.Map json_)
      : this(
          merchantOrderId: json_.containsKey('merchantOrderId')
              ? json_['merchantOrderId'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (merchantOrderId != null) 'merchantOrderId': merchantOrderId!,
        if (operationId != null) 'operationId': operationId!,
      };
}

class OrdersUpdateMerchantOrderIdResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersUpdateMerchantOrderIdResponse`".
  core.String? kind;

  OrdersUpdateMerchantOrderIdResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersUpdateMerchantOrderIdResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

class OrdersUpdateShipmentRequest {
  /// The carrier handling the shipment.
  ///
  /// Not updated if missing. See `shipments[].carrier` in the Orders resource
  /// representation for a list of acceptable values.
  core.String? carrier;

  /// Date on which the shipment has been delivered, in ISO 8601 format.
  ///
  /// Optional and can be provided only if `status` is `delivered`.
  core.String? deliveryDate;

  /// Date after which the pickup will expire, in ISO 8601 format.
  ///
  /// Required only when order is buy-online-pickup-in-store(BOPIS) and `status`
  /// is `ready for pickup`.
  core.String? lastPickupDate;

  /// The ID of the operation.
  ///
  /// Unique across all operations for a given order.
  core.String? operationId;

  /// Date on which the shipment has been ready for pickup, in ISO 8601 format.
  ///
  /// Optional and can be provided only if `status` is `ready for pickup`.
  core.String? readyPickupDate;

  /// Delivery details of the shipment if scheduling is needed.
  OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails?
      scheduledDeliveryDetails;

  /// The ID of the shipment.
  core.String? shipmentId;

  /// New status for the shipment.
  ///
  /// Not updated if missing. Acceptable values are: - "`delivered`" -
  /// "`undeliverable`" - "`readyForPickup`"
  core.String? status;

  /// The tracking ID for the shipment.
  ///
  /// Not updated if missing.
  core.String? trackingId;

  /// Date on which the shipment has been undeliverable, in ISO 8601 format.
  ///
  /// Optional and can be provided only if `status` is `undeliverable`.
  core.String? undeliveredDate;

  OrdersUpdateShipmentRequest({
    this.carrier,
    this.deliveryDate,
    this.lastPickupDate,
    this.operationId,
    this.readyPickupDate,
    this.scheduledDeliveryDetails,
    this.shipmentId,
    this.status,
    this.trackingId,
    this.undeliveredDate,
  });

  OrdersUpdateShipmentRequest.fromJson(core.Map json_)
      : this(
          carrier: json_.containsKey('carrier')
              ? json_['carrier'] as core.String
              : null,
          deliveryDate: json_.containsKey('deliveryDate')
              ? json_['deliveryDate'] as core.String
              : null,
          lastPickupDate: json_.containsKey('lastPickupDate')
              ? json_['lastPickupDate'] as core.String
              : null,
          operationId: json_.containsKey('operationId')
              ? json_['operationId'] as core.String
              : null,
          readyPickupDate: json_.containsKey('readyPickupDate')
              ? json_['readyPickupDate'] as core.String
              : null,
          scheduledDeliveryDetails: json_
                  .containsKey('scheduledDeliveryDetails')
              ? OrdersCustomBatchRequestEntryUpdateShipmentScheduledDeliveryDetails
                  .fromJson(json_['scheduledDeliveryDetails']
                      as core.Map<core.String, core.dynamic>)
              : null,
          shipmentId: json_.containsKey('shipmentId')
              ? json_['shipmentId'] as core.String
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
          trackingId: json_.containsKey('trackingId')
              ? json_['trackingId'] as core.String
              : null,
          undeliveredDate: json_.containsKey('undeliveredDate')
              ? json_['undeliveredDate'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrier != null) 'carrier': carrier!,
        if (deliveryDate != null) 'deliveryDate': deliveryDate!,
        if (lastPickupDate != null) 'lastPickupDate': lastPickupDate!,
        if (operationId != null) 'operationId': operationId!,
        if (readyPickupDate != null) 'readyPickupDate': readyPickupDate!,
        if (scheduledDeliveryDetails != null)
          'scheduledDeliveryDetails': scheduledDeliveryDetails!,
        if (shipmentId != null) 'shipmentId': shipmentId!,
        if (status != null) 'status': status!,
        if (trackingId != null) 'trackingId': trackingId!,
        if (undeliveredDate != null) 'undeliveredDate': undeliveredDate!,
      };
}

class OrdersUpdateShipmentResponse {
  /// The status of the execution.
  ///
  /// Acceptable values are: - "`duplicate`" - "`executed`"
  core.String? executionStatus;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#ordersUpdateShipmentResponse`".
  core.String? kind;

  OrdersUpdateShipmentResponse({
    this.executionStatus,
    this.kind,
  });

  OrdersUpdateShipmentResponse.fromJson(core.Map json_)
      : this(
          executionStatus: json_.containsKey('executionStatus')
              ? json_['executionStatus'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (kind != null) 'kind': kind!,
      };
}

/// Request message for the PauseProgram method.
typedef PauseBuyOnGoogleProgramRequest = $Empty;

/// Additional information required for PAYMENT_SERVICE_PROVIDER link type.
class PaymentServiceProviderLinkInfo {
  /// The business country of the merchant account as identified by the third
  /// party service provider.
  core.String? externalAccountBusinessCountry;

  /// The id used by the third party service provider to identify the merchant.
  core.String? externalAccountId;

  PaymentServiceProviderLinkInfo({
    this.externalAccountBusinessCountry,
    this.externalAccountId,
  });

  PaymentServiceProviderLinkInfo.fromJson(core.Map json_)
      : this(
          externalAccountBusinessCountry:
              json_.containsKey('externalAccountBusinessCountry')
                  ? json_['externalAccountBusinessCountry'] as core.String
                  : null,
          externalAccountId: json_.containsKey('externalAccountId')
              ? json_['externalAccountId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (externalAccountBusinessCountry != null)
          'externalAccountBusinessCountry': externalAccountBusinessCountry!,
        if (externalAccountId != null) 'externalAccountId': externalAccountId!,
      };
}

class PickupCarrierService {
  /// The name of the pickup carrier (for example, `"UPS"`).
  ///
  /// Required.
  core.String? carrierName;

  /// The name of the pickup service (for example, `"Access point"`).
  ///
  /// Required.
  core.String? serviceName;

  PickupCarrierService({
    this.carrierName,
    this.serviceName,
  });

  PickupCarrierService.fromJson(core.Map json_)
      : this(
          carrierName: json_.containsKey('carrierName')
              ? json_['carrierName'] as core.String
              : null,
          serviceName: json_.containsKey('serviceName')
              ? json_['serviceName'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrierName != null) 'carrierName': carrierName!,
        if (serviceName != null) 'serviceName': serviceName!,
      };
}

class PickupServicesPickupService {
  /// The name of the carrier (for example, `"UPS"`).
  ///
  /// Always present.
  core.String? carrierName;

  /// The CLDR country code of the carrier (for example, "US").
  ///
  /// Always present.
  core.String? country;

  /// The name of the pickup service (for example, `"Access point"`).
  ///
  /// Always present.
  core.String? serviceName;

  PickupServicesPickupService({
    this.carrierName,
    this.country,
    this.serviceName,
  });

  PickupServicesPickupService.fromJson(core.Map json_)
      : this(
          carrierName: json_.containsKey('carrierName')
              ? json_['carrierName'] as core.String
              : null,
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          serviceName: json_.containsKey('serviceName')
              ? json_['serviceName'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (carrierName != null) 'carrierName': carrierName!,
        if (country != null) 'country': country!,
        if (serviceName != null) 'serviceName': serviceName!,
      };
}

class PosCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<PosCustomBatchRequestEntry>? entries;

  PosCustomBatchRequest({
    this.entries,
  });

  PosCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => PosCustomBatchRequestEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

class PosCustomBatchRequestEntry {
  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// The inventory to submit.
  ///
  /// This should be set only if the method is `inventory`.
  PosInventory? inventory;

  /// The ID of the POS data provider.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`delete`" - "`get`" - "`insert`" - "`inventory`"
  /// - "`sale`"
  core.String? method;

  /// The sale information to submit.
  ///
  /// This should be set only if the method is `sale`.
  PosSale? sale;

  /// The store information to submit.
  ///
  /// This should be set only if the method is `insert`.
  PosStore? store;

  /// The store code.
  ///
  /// This should be set only if the method is `delete` or `get`.
  core.String? storeCode;

  /// The ID of the account for which to get/submit data.
  core.String? targetMerchantId;

  PosCustomBatchRequestEntry({
    this.batchId,
    this.inventory,
    this.merchantId,
    this.method,
    this.sale,
    this.store,
    this.storeCode,
    this.targetMerchantId,
  });

  PosCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          inventory: json_.containsKey('inventory')
              ? PosInventory.fromJson(
                  json_['inventory'] as core.Map<core.String, core.dynamic>)
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
          sale: json_.containsKey('sale')
              ? PosSale.fromJson(
                  json_['sale'] as core.Map<core.String, core.dynamic>)
              : null,
          store: json_.containsKey('store')
              ? PosStore.fromJson(
                  json_['store'] as core.Map<core.String, core.dynamic>)
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
          targetMerchantId: json_.containsKey('targetMerchantId')
              ? json_['targetMerchantId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (inventory != null) 'inventory': inventory!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
        if (sale != null) 'sale': sale!,
        if (store != null) 'store': store!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (targetMerchantId != null) 'targetMerchantId': targetMerchantId!,
      };
}

class PosCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<PosCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#posCustomBatchResponse`".
  core.String? kind;

  PosCustomBatchResponse({
    this.entries,
    this.kind,
  });

  PosCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => PosCustomBatchResponseEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

class PosCustomBatchResponseEntry {
  /// The ID of the request entry to which this entry responds.
  core.int? batchId;

  /// A list of errors defined if, and only if, the request failed.
  Errors? errors;

  /// The updated inventory information.
  PosInventory? inventory;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#posCustomBatchResponseEntry`"
  core.String? kind;

  /// The updated sale information.
  PosSale? sale;

  /// The retrieved or updated store information.
  PosStore? store;

  PosCustomBatchResponseEntry({
    this.batchId,
    this.errors,
    this.inventory,
    this.kind,
    this.sale,
    this.store,
  });

  PosCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
          inventory: json_.containsKey('inventory')
              ? PosInventory.fromJson(
                  json_['inventory'] as core.Map<core.String, core.dynamic>)
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          sale: json_.containsKey('sale')
              ? PosSale.fromJson(
                  json_['sale'] as core.Map<core.String, core.dynamic>)
              : null,
          store: json_.containsKey('store')
              ? PosStore.fromJson(
                  json_['store'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (errors != null) 'errors': errors!,
        if (inventory != null) 'inventory': inventory!,
        if (kind != null) 'kind': kind!,
        if (sale != null) 'sale': sale!,
        if (store != null) 'store': store!,
      };
}

class PosDataProviders {
  /// Country code.
  core.String? country;

  /// A list of POS data providers.
  core.List<PosDataProvidersPosDataProvider>? posDataProviders;

  PosDataProviders({
    this.country,
    this.posDataProviders,
  });

  PosDataProviders.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          posDataProviders: json_.containsKey('posDataProviders')
              ? (json_['posDataProviders'] as core.List)
                  .map((value) => PosDataProvidersPosDataProvider.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (posDataProviders != null) 'posDataProviders': posDataProviders!,
      };
}

class PosDataProvidersPosDataProvider {
  /// The display name of Pos data Provider.
  core.String? displayName;

  /// The full name of this POS data Provider.
  core.String? fullName;

  /// The ID of the account.
  core.String? providerId;

  PosDataProvidersPosDataProvider({
    this.displayName,
    this.fullName,
    this.providerId,
  });

  PosDataProvidersPosDataProvider.fromJson(core.Map json_)
      : this(
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          fullName: json_.containsKey('fullName')
              ? json_['fullName'] as core.String
              : null,
          providerId: json_.containsKey('providerId')
              ? json_['providerId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (displayName != null) 'displayName': displayName!,
        if (fullName != null) 'fullName': fullName!,
        if (providerId != null) 'providerId': providerId!,
      };
}

/// The absolute quantity of an item available at the given store.
class PosInventory {
  /// The two-letter ISO 639-1 language code for the item.
  ///
  /// Required.
  core.String? contentLanguage;

  /// Global Trade Item Number.
  core.String? gtin;

  /// A unique identifier for the item.
  ///
  /// Required.
  core.String? itemId;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#posInventory`"
  core.String? kind;

  /// Supported pickup method for this offer.
  ///
  /// Unless the value is "not supported", this field must be submitted together
  /// with `pickupSla`. For accepted attribute values, see the
  /// [local product inventory feed specification](https://support.google.com/merchants/answer/3061342).
  ///
  /// Optional.
  core.String? pickupMethod;

  /// Expected date that an order will be ready for pickup relative to the order
  /// date.
  ///
  /// Must be submitted together with `pickupMethod`. For accepted attribute
  /// values, see the
  /// [local product inventory feed specification](https://support.google.com/merchants/answer/3061342).
  ///
  /// Optional.
  core.String? pickupSla;

  /// The current price of the item.
  ///
  /// Required.
  Price? price;

  /// The available quantity of the item.
  ///
  /// Required.
  core.String? quantity;

  /// The identifier of the merchant's store.
  ///
  /// Either a `storeCode` inserted through the API or the code of the store in
  /// a Business Profile.
  ///
  /// Required.
  core.String? storeCode;

  /// The CLDR territory code for the item.
  ///
  /// Required.
  core.String? targetCountry;

  /// The inventory timestamp, in ISO 8601 format.
  ///
  /// Required.
  core.String? timestamp;

  PosInventory({
    this.contentLanguage,
    this.gtin,
    this.itemId,
    this.kind,
    this.pickupMethod,
    this.pickupSla,
    this.price,
    this.quantity,
    this.storeCode,
    this.targetCountry,
    this.timestamp,
  });

  PosInventory.fromJson(core.Map json_)
      : this(
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          itemId: json_.containsKey('itemId')
              ? json_['itemId'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          pickupMethod: json_.containsKey('pickupMethod')
              ? json_['pickupMethod'] as core.String
              : null,
          pickupSla: json_.containsKey('pickupSla')
              ? json_['pickupSla'] as core.String
              : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
          timestamp: json_.containsKey('timestamp')
              ? json_['timestamp'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (gtin != null) 'gtin': gtin!,
        if (itemId != null) 'itemId': itemId!,
        if (kind != null) 'kind': kind!,
        if (pickupMethod != null) 'pickupMethod': pickupMethod!,
        if (pickupSla != null) 'pickupSla': pickupSla!,
        if (price != null) 'price': price!,
        if (quantity != null) 'quantity': quantity!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
        if (timestamp != null) 'timestamp': timestamp!,
      };
}

class PosInventoryRequest {
  /// The two-letter ISO 639-1 language code for the item.
  ///
  /// Required.
  core.String? contentLanguage;

  /// Global Trade Item Number.
  core.String? gtin;

  /// A unique identifier for the item.
  ///
  /// Required.
  core.String? itemId;

  /// Supported pickup method for this offer.
  ///
  /// Unless the value is "not supported", this field must be submitted together
  /// with `pickupSla`. For accepted attribute values, see the
  /// [local product inventory feed specification](https://support.google.com/merchants/answer/3061342).
  ///
  /// Optional.
  core.String? pickupMethod;

  /// Expected date that an order will be ready for pickup relative to the order
  /// date.
  ///
  /// Must be submitted together with `pickupMethod`. For accepted attribute
  /// values, see the
  /// [local product inventory feed specification](https://support.google.com/merchants/answer/3061342).
  ///
  /// Optional.
  core.String? pickupSla;

  /// The current price of the item.
  ///
  /// Required.
  Price? price;

  /// The available quantity of the item.
  ///
  /// Required.
  core.String? quantity;

  /// The identifier of the merchant's store.
  ///
  /// Either a `storeCode` inserted through the API or the code of the store in
  /// a Business Profile.
  ///
  /// Required.
  core.String? storeCode;

  /// The CLDR territory code for the item.
  ///
  /// Required.
  core.String? targetCountry;

  /// The inventory timestamp, in ISO 8601 format.
  ///
  /// Required.
  core.String? timestamp;

  PosInventoryRequest({
    this.contentLanguage,
    this.gtin,
    this.itemId,
    this.pickupMethod,
    this.pickupSla,
    this.price,
    this.quantity,
    this.storeCode,
    this.targetCountry,
    this.timestamp,
  });

  PosInventoryRequest.fromJson(core.Map json_)
      : this(
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          itemId: json_.containsKey('itemId')
              ? json_['itemId'] as core.String
              : null,
          pickupMethod: json_.containsKey('pickupMethod')
              ? json_['pickupMethod'] as core.String
              : null,
          pickupSla: json_.containsKey('pickupSla')
              ? json_['pickupSla'] as core.String
              : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
          timestamp: json_.containsKey('timestamp')
              ? json_['timestamp'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (gtin != null) 'gtin': gtin!,
        if (itemId != null) 'itemId': itemId!,
        if (pickupMethod != null) 'pickupMethod': pickupMethod!,
        if (pickupSla != null) 'pickupSla': pickupSla!,
        if (price != null) 'price': price!,
        if (quantity != null) 'quantity': quantity!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
        if (timestamp != null) 'timestamp': timestamp!,
      };
}

class PosInventoryResponse {
  /// The two-letter ISO 639-1 language code for the item.
  ///
  /// Required.
  core.String? contentLanguage;

  /// Global Trade Item Number.
  core.String? gtin;

  /// A unique identifier for the item.
  ///
  /// Required.
  core.String? itemId;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#posInventoryResponse`".
  core.String? kind;

  /// Supported pickup method for this offer.
  ///
  /// Unless the value is "not supported", this field must be submitted together
  /// with `pickupSla`. For accepted attribute values, see the
  /// [local product inventory feed specification](https://support.google.com/merchants/answer/3061342).
  ///
  /// Optional.
  core.String? pickupMethod;

  /// Expected date that an order will be ready for pickup relative to the order
  /// date.
  ///
  /// Must be submitted together with `pickupMethod`. For accepted attribute
  /// values, see the
  /// [local product inventory feed specification](https://support.google.com/merchants/answer/3061342).
  ///
  /// Optional.
  core.String? pickupSla;

  /// The current price of the item.
  ///
  /// Required.
  Price? price;

  /// The available quantity of the item.
  ///
  /// Required.
  core.String? quantity;

  /// The identifier of the merchant's store.
  ///
  /// Either a `storeCode` inserted through the API or the code of the store in
  /// a Business Profile.
  ///
  /// Required.
  core.String? storeCode;

  /// The CLDR territory code for the item.
  ///
  /// Required.
  core.String? targetCountry;

  /// The inventory timestamp, in ISO 8601 format.
  ///
  /// Required.
  core.String? timestamp;

  PosInventoryResponse({
    this.contentLanguage,
    this.gtin,
    this.itemId,
    this.kind,
    this.pickupMethod,
    this.pickupSla,
    this.price,
    this.quantity,
    this.storeCode,
    this.targetCountry,
    this.timestamp,
  });

  PosInventoryResponse.fromJson(core.Map json_)
      : this(
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          itemId: json_.containsKey('itemId')
              ? json_['itemId'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          pickupMethod: json_.containsKey('pickupMethod')
              ? json_['pickupMethod'] as core.String
              : null,
          pickupSla: json_.containsKey('pickupSla')
              ? json_['pickupSla'] as core.String
              : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
          timestamp: json_.containsKey('timestamp')
              ? json_['timestamp'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (gtin != null) 'gtin': gtin!,
        if (itemId != null) 'itemId': itemId!,
        if (kind != null) 'kind': kind!,
        if (pickupMethod != null) 'pickupMethod': pickupMethod!,
        if (pickupSla != null) 'pickupSla': pickupSla!,
        if (price != null) 'price': price!,
        if (quantity != null) 'quantity': quantity!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
        if (timestamp != null) 'timestamp': timestamp!,
      };
}

class PosListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#posListResponse`".
  core.String? kind;
  core.List<PosStore>? resources;

  PosListResponse({
    this.kind,
    this.resources,
  });

  PosListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => PosStore.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (resources != null) 'resources': resources!,
      };
}

/// The change of the available quantity of an item at the given store.
class PosSale {
  /// The two-letter ISO 639-1 language code for the item.
  ///
  /// Required.
  core.String? contentLanguage;

  /// Global Trade Item Number.
  core.String? gtin;

  /// A unique identifier for the item.
  ///
  /// Required.
  core.String? itemId;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#posSale`"
  core.String? kind;

  /// The price of the item.
  ///
  /// Required.
  Price? price;

  /// The relative change of the available quantity.
  ///
  /// Negative for items returned.
  ///
  /// Required.
  core.String? quantity;

  /// A unique ID to group items from the same sale event.
  core.String? saleId;

  /// The identifier of the merchant's store.
  ///
  /// Either a `storeCode` inserted through the API or the code of the store in
  /// a Business Profile.
  ///
  /// Required.
  core.String? storeCode;

  /// The CLDR territory code for the item.
  ///
  /// Required.
  core.String? targetCountry;

  /// The inventory timestamp, in ISO 8601 format.
  ///
  /// Required.
  core.String? timestamp;

  PosSale({
    this.contentLanguage,
    this.gtin,
    this.itemId,
    this.kind,
    this.price,
    this.quantity,
    this.saleId,
    this.storeCode,
    this.targetCountry,
    this.timestamp,
  });

  PosSale.fromJson(core.Map json_)
      : this(
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          itemId: json_.containsKey('itemId')
              ? json_['itemId'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.String
              : null,
          saleId: json_.containsKey('saleId')
              ? json_['saleId'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
          timestamp: json_.containsKey('timestamp')
              ? json_['timestamp'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (gtin != null) 'gtin': gtin!,
        if (itemId != null) 'itemId': itemId!,
        if (kind != null) 'kind': kind!,
        if (price != null) 'price': price!,
        if (quantity != null) 'quantity': quantity!,
        if (saleId != null) 'saleId': saleId!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
        if (timestamp != null) 'timestamp': timestamp!,
      };
}

class PosSaleRequest {
  /// The two-letter ISO 639-1 language code for the item.
  ///
  /// Required.
  core.String? contentLanguage;

  /// Global Trade Item Number.
  core.String? gtin;

  /// A unique identifier for the item.
  ///
  /// Required.
  core.String? itemId;

  /// The price of the item.
  ///
  /// Required.
  Price? price;

  /// The relative change of the available quantity.
  ///
  /// Negative for items returned.
  ///
  /// Required.
  core.String? quantity;

  /// A unique ID to group items from the same sale event.
  core.String? saleId;

  /// The identifier of the merchant's store.
  ///
  /// Either a `storeCode` inserted through the API or the code of the store in
  /// a Business Profile.
  ///
  /// Required.
  core.String? storeCode;

  /// The CLDR territory code for the item.
  ///
  /// Required.
  core.String? targetCountry;

  /// The inventory timestamp, in ISO 8601 format.
  ///
  /// Required.
  core.String? timestamp;

  PosSaleRequest({
    this.contentLanguage,
    this.gtin,
    this.itemId,
    this.price,
    this.quantity,
    this.saleId,
    this.storeCode,
    this.targetCountry,
    this.timestamp,
  });

  PosSaleRequest.fromJson(core.Map json_)
      : this(
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          itemId: json_.containsKey('itemId')
              ? json_['itemId'] as core.String
              : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.String
              : null,
          saleId: json_.containsKey('saleId')
              ? json_['saleId'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
          timestamp: json_.containsKey('timestamp')
              ? json_['timestamp'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (gtin != null) 'gtin': gtin!,
        if (itemId != null) 'itemId': itemId!,
        if (price != null) 'price': price!,
        if (quantity != null) 'quantity': quantity!,
        if (saleId != null) 'saleId': saleId!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
        if (timestamp != null) 'timestamp': timestamp!,
      };
}

class PosSaleResponse {
  /// The two-letter ISO 639-1 language code for the item.
  ///
  /// Required.
  core.String? contentLanguage;

  /// Global Trade Item Number.
  core.String? gtin;

  /// A unique identifier for the item.
  ///
  /// Required.
  core.String? itemId;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#posSaleResponse`".
  core.String? kind;

  /// The price of the item.
  ///
  /// Required.
  Price? price;

  /// The relative change of the available quantity.
  ///
  /// Negative for items returned.
  ///
  /// Required.
  core.String? quantity;

  /// A unique ID to group items from the same sale event.
  core.String? saleId;

  /// The identifier of the merchant's store.
  ///
  /// Either a `storeCode` inserted through the API or the code of the store in
  /// a Business Profile.
  ///
  /// Required.
  core.String? storeCode;

  /// The CLDR territory code for the item.
  ///
  /// Required.
  core.String? targetCountry;

  /// The inventory timestamp, in ISO 8601 format.
  ///
  /// Required.
  core.String? timestamp;

  PosSaleResponse({
    this.contentLanguage,
    this.gtin,
    this.itemId,
    this.kind,
    this.price,
    this.quantity,
    this.saleId,
    this.storeCode,
    this.targetCountry,
    this.timestamp,
  });

  PosSaleResponse.fromJson(core.Map json_)
      : this(
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          itemId: json_.containsKey('itemId')
              ? json_['itemId'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          quantity: json_.containsKey('quantity')
              ? json_['quantity'] as core.String
              : null,
          saleId: json_.containsKey('saleId')
              ? json_['saleId'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
          timestamp: json_.containsKey('timestamp')
              ? json_['timestamp'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (gtin != null) 'gtin': gtin!,
        if (itemId != null) 'itemId': itemId!,
        if (kind != null) 'kind': kind!,
        if (price != null) 'price': price!,
        if (quantity != null) 'quantity': quantity!,
        if (saleId != null) 'saleId': saleId!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
        if (timestamp != null) 'timestamp': timestamp!,
      };
}

/// Store resource.
class PosStore {
  /// The business type of the store.
  core.List<core.String>? gcidCategory;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#posStore`"
  core.String? kind;

  /// The store phone number.
  core.String? phoneNumber;

  /// The Google Place Id of the store location.
  core.String? placeId;

  /// The street address of the store.
  ///
  /// Required.
  core.String? storeAddress;

  /// A store identifier that is unique for the given merchant.
  ///
  /// Required.
  core.String? storeCode;

  /// The merchant or store name.
  core.String? storeName;

  /// The website url for the store or merchant.
  core.String? websiteUrl;

  PosStore({
    this.gcidCategory,
    this.kind,
    this.phoneNumber,
    this.placeId,
    this.storeAddress,
    this.storeCode,
    this.storeName,
    this.websiteUrl,
  });

  PosStore.fromJson(core.Map json_)
      : this(
          gcidCategory: json_.containsKey('gcidCategory')
              ? (json_['gcidCategory'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          phoneNumber: json_.containsKey('phoneNumber')
              ? json_['phoneNumber'] as core.String
              : null,
          placeId: json_.containsKey('placeId')
              ? json_['placeId'] as core.String
              : null,
          storeAddress: json_.containsKey('storeAddress')
              ? json_['storeAddress'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? json_['storeCode'] as core.String
              : null,
          storeName: json_.containsKey('storeName')
              ? json_['storeName'] as core.String
              : null,
          websiteUrl: json_.containsKey('websiteUrl')
              ? json_['websiteUrl'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (gcidCategory != null) 'gcidCategory': gcidCategory!,
        if (kind != null) 'kind': kind!,
        if (phoneNumber != null) 'phoneNumber': phoneNumber!,
        if (placeId != null) 'placeId': placeId!,
        if (storeAddress != null) 'storeAddress': storeAddress!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (storeName != null) 'storeName': storeName!,
        if (websiteUrl != null) 'websiteUrl': websiteUrl!,
      };
}

class PostalCodeGroup {
  /// The CLDR territory code of the country the postal code group applies to.
  ///
  /// Required.
  core.String? country;

  /// The name of the postal code group, referred to in headers.
  ///
  /// Required.
  core.String? name;

  /// A range of postal codes.
  ///
  /// Required.
  core.List<PostalCodeRange>? postalCodeRanges;

  PostalCodeGroup({
    this.country,
    this.name,
    this.postalCodeRanges,
  });

  PostalCodeGroup.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          postalCodeRanges: json_.containsKey('postalCodeRanges')
              ? (json_['postalCodeRanges'] as core.List)
                  .map((value) => PostalCodeRange.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (name != null) 'name': name!,
        if (postalCodeRanges != null) 'postalCodeRanges': postalCodeRanges!,
      };
}

class PostalCodeRange {
  /// A postal code or a pattern of the form `prefix*` denoting the inclusive
  /// lower bound of the range defining the area.
  ///
  /// Examples values: `"94108"`, `"9410*"`, `"9*"`. Required.
  core.String? postalCodeRangeBegin;

  /// A postal code or a pattern of the form `prefix*` denoting the inclusive
  /// upper bound of the range defining the area.
  ///
  /// It must have the same length as `postalCodeRangeBegin`: if
  /// `postalCodeRangeBegin` is a postal code then `postalCodeRangeEnd` must be
  /// a postal code too; if `postalCodeRangeBegin` is a pattern then
  /// `postalCodeRangeEnd` must be a pattern with the same prefix length.
  /// Optional: if not set, then the area is defined as being all the postal
  /// codes matching `postalCodeRangeBegin`.
  core.String? postalCodeRangeEnd;

  PostalCodeRange({
    this.postalCodeRangeBegin,
    this.postalCodeRangeEnd,
  });

  PostalCodeRange.fromJson(core.Map json_)
      : this(
          postalCodeRangeBegin: json_.containsKey('postalCodeRangeBegin')
              ? json_['postalCodeRangeBegin'] as core.String
              : null,
          postalCodeRangeEnd: json_.containsKey('postalCodeRangeEnd')
              ? json_['postalCodeRangeEnd'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (postalCodeRangeBegin != null)
          'postalCodeRangeBegin': postalCodeRangeBegin!,
        if (postalCodeRangeEnd != null)
          'postalCodeRangeEnd': postalCodeRangeEnd!,
      };
}

typedef Price = $Shared06;

/// The price represented as a number and currency.
typedef PriceAmount = $Shared06;

/// Price competitiveness fields requested by the merchant in the query.
///
/// Field values are only set if the merchant queries
/// `PriceCompetitivenessProductView`.
/// https://support.google.com/merchants/answer/9626903
class PriceCompetitiveness {
  /// The price benchmark currency (ISO 4217 code).
  core.String? benchmarkPriceCurrencyCode;

  /// The latest available price benchmark in micros (1 millionth of a standard
  /// unit, 1 USD = 1000000 micros) for the product's catalog in the benchmark
  /// country.
  core.String? benchmarkPriceMicros;

  /// The country of the price benchmark (ISO 3166 code).
  core.String? countryCode;

  PriceCompetitiveness({
    this.benchmarkPriceCurrencyCode,
    this.benchmarkPriceMicros,
    this.countryCode,
  });

  PriceCompetitiveness.fromJson(core.Map json_)
      : this(
          benchmarkPriceCurrencyCode:
              json_.containsKey('benchmarkPriceCurrencyCode')
                  ? json_['benchmarkPriceCurrencyCode'] as core.String
                  : null,
          benchmarkPriceMicros: json_.containsKey('benchmarkPriceMicros')
              ? json_['benchmarkPriceMicros'] as core.String
              : null,
          countryCode: json_.containsKey('countryCode')
              ? json_['countryCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (benchmarkPriceCurrencyCode != null)
          'benchmarkPriceCurrencyCode': benchmarkPriceCurrencyCode!,
        if (benchmarkPriceMicros != null)
          'benchmarkPriceMicros': benchmarkPriceMicros!,
        if (countryCode != null) 'countryCode': countryCode!,
      };
}

/// Price insights fields requested by the merchant in the query.
///
/// Field values are only set if the merchant queries
/// `PriceInsightsProductView`.
/// https://support.google.com/merchants/answer/11916926
class PriceInsights {
  /// The predicted change in clicks as a fraction after introducing the
  /// suggested price compared to current active price.
  ///
  /// For example, 0.05 is a 5% predicted increase in clicks.
  core.double? predictedClicksChangeFraction;

  /// The predicted change in conversions as a fraction after introducing the
  /// suggested price compared to current active price.
  ///
  /// For example, 0.05 is a 5% predicted increase in conversions).
  core.double? predictedConversionsChangeFraction;

  /// *Deprecated*: This field is no longer supported and will start returning
  /// 0.
  ///
  /// The predicted change in gross profit as a fraction after introducing the
  /// suggested price compared to current active price. For example, 0.05 is a
  /// 5% predicted increase in gross profit.
  core.double? predictedGrossProfitChangeFraction;

  /// The predicted change in impressions as a fraction after introducing the
  /// suggested price compared to current active price.
  ///
  /// For example, 0.05 is a 5% predicted increase in impressions.
  core.double? predictedImpressionsChangeFraction;

  /// *Deprecated*: This field is no longer supported and will start returning
  /// USD for all requests.
  ///
  /// The predicted monthly gross profit change currency (ISO 4217 code).
  core.String? predictedMonthlyGrossProfitChangeCurrencyCode;

  /// *Deprecated*: This field is no longer supported and will start returning
  /// 0.
  ///
  /// The predicted change in gross profit in micros (1 millionth of a standard
  /// unit, 1 USD = 1000000 micros) after introducing the suggested price for a
  /// month compared to current active price.
  core.String? predictedMonthlyGrossProfitChangeMicros;

  /// The suggested price currency (ISO 4217 code).
  core.String? suggestedPriceCurrencyCode;

  /// The latest suggested price in micros (1 millionth of a standard unit, 1
  /// USD = 1000000 micros) for the product.
  core.String? suggestedPriceMicros;

  PriceInsights({
    this.predictedClicksChangeFraction,
    this.predictedConversionsChangeFraction,
    this.predictedGrossProfitChangeFraction,
    this.predictedImpressionsChangeFraction,
    this.predictedMonthlyGrossProfitChangeCurrencyCode,
    this.predictedMonthlyGrossProfitChangeMicros,
    this.suggestedPriceCurrencyCode,
    this.suggestedPriceMicros,
  });

  PriceInsights.fromJson(core.Map json_)
      : this(
          predictedClicksChangeFraction: json_
                  .containsKey('predictedClicksChangeFraction')
              ? (json_['predictedClicksChangeFraction'] as core.num).toDouble()
              : null,
          predictedConversionsChangeFraction:
              json_.containsKey('predictedConversionsChangeFraction')
                  ? (json_['predictedConversionsChangeFraction'] as core.num)
                      .toDouble()
                  : null,
          predictedGrossProfitChangeFraction:
              json_.containsKey('predictedGrossProfitChangeFraction')
                  ? (json_['predictedGrossProfitChangeFraction'] as core.num)
                      .toDouble()
                  : null,
          predictedImpressionsChangeFraction:
              json_.containsKey('predictedImpressionsChangeFraction')
                  ? (json_['predictedImpressionsChangeFraction'] as core.num)
                      .toDouble()
                  : null,
          predictedMonthlyGrossProfitChangeCurrencyCode:
              json_.containsKey('predictedMonthlyGrossProfitChangeCurrencyCode')
                  ? json_['predictedMonthlyGrossProfitChangeCurrencyCode']
                      as core.String
                  : null,
          predictedMonthlyGrossProfitChangeMicros: json_
                  .containsKey('predictedMonthlyGrossProfitChangeMicros')
              ? json_['predictedMonthlyGrossProfitChangeMicros'] as core.String
              : null,
          suggestedPriceCurrencyCode:
              json_.containsKey('suggestedPriceCurrencyCode')
                  ? json_['suggestedPriceCurrencyCode'] as core.String
                  : null,
          suggestedPriceMicros: json_.containsKey('suggestedPriceMicros')
              ? json_['suggestedPriceMicros'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (predictedClicksChangeFraction != null)
          'predictedClicksChangeFraction': predictedClicksChangeFraction!,
        if (predictedConversionsChangeFraction != null)
          'predictedConversionsChangeFraction':
              predictedConversionsChangeFraction!,
        if (predictedGrossProfitChangeFraction != null)
          'predictedGrossProfitChangeFraction':
              predictedGrossProfitChangeFraction!,
        if (predictedImpressionsChangeFraction != null)
          'predictedImpressionsChangeFraction':
              predictedImpressionsChangeFraction!,
        if (predictedMonthlyGrossProfitChangeCurrencyCode != null)
          'predictedMonthlyGrossProfitChangeCurrencyCode':
              predictedMonthlyGrossProfitChangeCurrencyCode!,
        if (predictedMonthlyGrossProfitChangeMicros != null)
          'predictedMonthlyGrossProfitChangeMicros':
              predictedMonthlyGrossProfitChangeMicros!,
        if (suggestedPriceCurrencyCode != null)
          'suggestedPriceCurrencyCode': suggestedPriceCurrencyCode!,
        if (suggestedPriceMicros != null)
          'suggestedPriceMicros': suggestedPriceMicros!,
      };
}

/// Required product attributes are primarily defined by the product data
/// specification.
///
/// See the Product Data Specification Help Center article for information.
/// Product data. After inserting, updating, or deleting a product, it may take
/// several minutes before changes take effect.
class Product {
  /// Additional URLs of images of the item.
  core.List<core.String>? additionalImageLinks;

  /// Additional cut of the item.
  ///
  /// Used together with size_type to represent combined size types for apparel
  /// items.
  core.String? additionalSizeType;

  /// Used to group items in an arbitrary way.
  ///
  /// Only for CPA%, discouraged otherwise.
  core.String? adsGrouping;

  /// Similar to ads_grouping, but only works on CPC.
  core.List<core.String>? adsLabels;

  /// Allows advertisers to override the item URL when the product is shown
  /// within the context of Product Ads.
  core.String? adsRedirect;

  /// Should be set to true if the item is targeted towards adults.
  core.bool? adult;

  /// Target age group of the item.
  core.String? ageGroup;

  /// Availability status of the item.
  core.String? availability;

  /// The day a pre-ordered product becomes available for delivery, in ISO 8601
  /// format.
  core.String? availabilityDate;

  /// Brand of the item.
  core.String? brand;

  /// URL for the canonical version of your item's landing page.
  core.String? canonicalLink;

  /// Product
  /// [certification](https://support.google.com/merchants/answer/13528839),
  /// introduced for EU energy efficiency labeling compliance using the
  /// [EU EPREL](https://eprel.ec.europa.eu/screen/home) database.
  core.List<ProductCertification>? certifications;

  /// The item's channel (online or local).
  ///
  /// Acceptable values are: - "`local`" - "`online`"
  ///
  /// Required.
  core.String? channel;

  /// Extra fields to export to the Cloud Retail program.
  core.List<CloudExportAdditionalProperties>? cloudExportAdditionalProperties;

  /// Color of the item.
  core.String? color;

  /// Condition or state of the item.
  core.String? condition;

  /// The two-letter ISO 639-1 language code for the item.
  ///
  /// Required.
  core.String? contentLanguage;

  /// Cost of goods sold.
  ///
  /// Used for gross profit reporting.
  Price? costOfGoodsSold;

  /// A list of custom (merchant-provided) attributes.
  ///
  /// It can also be used for submitting any attribute of the feed specification
  /// in its generic form (for example, `{ "name": "size type", "value":
  /// "regular" }`). This is useful for submitting attributes not explicitly
  /// exposed by the API, such as additional attributes used for Buy on Google
  /// (formerly known as Shopping Actions).
  core.List<CustomAttribute>? customAttributes;

  /// Custom label 0 for custom grouping of items in a Shopping campaign.
  core.String? customLabel0;

  /// Custom label 1 for custom grouping of items in a Shopping campaign.
  core.String? customLabel1;

  /// Custom label 2 for custom grouping of items in a Shopping campaign.
  core.String? customLabel2;

  /// Custom label 3 for custom grouping of items in a Shopping campaign.
  core.String? customLabel3;

  /// Custom label 4 for custom grouping of items in a Shopping campaign.
  core.String? customLabel4;

  /// Description of the item.
  core.String? description;

  /// The date time when an offer becomes visible in search results across
  /// Google’s YouTube surfaces, in
  /// [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
  ///
  /// See
  /// [Disclosure date](https://support.google.com/merchants/answer/13034208)
  /// for more information.
  core.String? disclosureDate;

  /// An identifier for an item for dynamic remarketing campaigns.
  core.String? displayAdsId;

  /// URL directly to your item's landing page for dynamic remarketing
  /// campaigns.
  core.String? displayAdsLink;

  /// Advertiser-specified recommendations.
  core.List<core.String>? displayAdsSimilarIds;

  /// Title of an item for dynamic remarketing campaigns.
  core.String? displayAdsTitle;

  /// Offer margin for dynamic remarketing campaigns.
  core.double? displayAdsValue;

  /// The energy efficiency class as defined in EU directive 2010/30/EU.
  core.String? energyEfficiencyClass;

  /// The list of destinations to exclude for this target (corresponds to
  /// cleared check boxes in Merchant Center).
  ///
  /// Products that are excluded from all destinations for more than 7 days are
  /// automatically deleted.
  core.List<core.String>? excludedDestinations;

  /// Date on which the item should expire, as specified upon insertion, in ISO
  /// 8601 format.
  ///
  /// The actual expiration date in Google Shopping is exposed in
  /// `productstatuses` as `googleExpirationDate` and might be earlier if
  /// `expirationDate` is too far in the future.
  core.String? expirationDate;

  /// Required for multi-seller accounts.
  ///
  /// Use this attribute if you're a marketplace uploading products for various
  /// sellers to your multi-seller account.
  core.String? externalSellerId;

  /// Feed label for the item.
  ///
  /// Either `targetCountry` or `feedLabel` is required. Must be less than or
  /// equal to 20 uppercase letters (A-Z), numbers (0-9), and dashes (-).
  core.String? feedLabel;

  /// Target gender of the item.
  core.String? gender;

  /// Google's category of the item (see
  /// [Google product taxonomy](https://support.google.com/merchants/answer/1705911)).
  ///
  /// When querying products, this field will contain the user provided value.
  /// There is currently no way to get back the auto assigned google product
  /// categories through the API.
  core.String? googleProductCategory;

  /// Global Trade Item Number (GTIN) of the item.
  core.String? gtin;

  /// The REST ID of the product.
  ///
  /// Content API methods that operate on products take this as their
  /// `productId` parameter. The REST ID for a product has one of the 2 forms
  /// channel:contentLanguage: targetCountry: offerId or
  /// channel:contentLanguage:feedLabel: offerId.
  core.String? id;

  /// False when the item does not have unique product identifiers appropriate
  /// to its category, such as GTIN, MPN, and brand.
  ///
  /// Required according to the Unique Product Identifier Rules for all target
  /// countries except for Canada.
  core.bool? identifierExists;

  /// URL of an image of the item.
  core.String? imageLink;

  /// The list of destinations to include for this target (corresponds to
  /// checked check boxes in Merchant Center).
  ///
  /// Default destinations are always included unless provided in
  /// `excludedDestinations`.
  core.List<core.String>? includedDestinations;

  /// Number and amount of installments to pay for an item.
  Installment? installment;

  /// Whether the item is a merchant-defined bundle.
  ///
  /// A bundle is a custom grouping of different products sold by a merchant for
  /// a single price.
  core.bool? isBundle;

  /// Shared identifier for all variants of the same product.
  core.String? itemGroupId;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#product`"
  core.String? kind;

  /// Additional URLs of lifestyle images of the item.
  ///
  /// Used to explicitly identify images that showcase your item in a real-world
  /// context. See the Help Center article for more information.
  core.List<core.String>? lifestyleImageLinks;

  /// URL directly linking to your item's page on your website.
  core.String? link;

  /// URL template for merchant hosted local storefront.
  core.String? linkTemplate;

  /// Loyalty points that users receive after purchasing the item.
  ///
  /// Japan only.
  LoyaltyPoints? loyaltyPoints;

  /// The material of which the item is made.
  core.String? material;

  /// The energy efficiency class as defined in EU directive 2010/30/EU.
  core.String? maxEnergyEfficiencyClass;

  /// Maximal product handling time (in business days).
  core.String? maxHandlingTime;

  /// The energy efficiency class as defined in EU directive 2010/30/EU.
  core.String? minEnergyEfficiencyClass;

  /// Minimal product handling time (in business days).
  core.String? minHandlingTime;

  /// URL for the mobile-optimized version of your item's landing page.
  core.String? mobileLink;

  /// URL template for merchant hosted local storefront optimized for mobile
  /// devices.
  core.String? mobileLinkTemplate;

  /// Manufacturer Part Number (MPN) of the item.
  core.String? mpn;

  /// The number of identical products in a merchant-defined multipack.
  core.String? multipack;

  /// A unique identifier for the item.
  ///
  /// Leading and trailing whitespaces are stripped and multiple whitespaces are
  /// replaced by a single whitespace upon submission. Only valid unicode
  /// characters are accepted. See the products feed specification for details.
  /// *Note:* Content API methods that operate on products take the REST ID of
  /// the product, *not* this identifier.
  ///
  /// Required.
  core.String? offerId;

  /// The item's pattern (for example, polka dots).
  core.String? pattern;

  /// Publication of this item should be temporarily paused.
  ///
  /// Acceptable values are: - "`ads`"
  core.String? pause;

  /// The pick up option for the item.
  ///
  /// Acceptable values are: - "`buy`" - "`reserve`" - "`ship to store`" - "`not
  /// supported`"
  core.String? pickupMethod;

  /// Item store pickup timeline.
  ///
  /// Acceptable values are: - "`same day`" - "`next day`" - "`2-day`" -
  /// "`3-day`" - "`4-day`" - "`5-day`" - "`6-day`" - "`7-day`" - "`multi-week`"
  core.String? pickupSla;

  /// Price of the item.
  Price? price;

  /// Technical specification or additional product details.
  core.List<ProductProductDetail>? productDetails;

  /// The height of the product in the units provided.
  ///
  /// The value must be between 0 (exclusive) and 3000 (inclusive).
  ProductDimension? productHeight;

  /// Bullet points describing the most relevant highlights of a product.
  core.List<core.String>? productHighlights;

  /// The length of the product in the units provided.
  ///
  /// The value must be between 0 (exclusive) and 3000 (inclusive).
  ProductDimension? productLength;

  /// Categories of the item (formatted as in product data specification).
  core.List<core.String>? productTypes;

  /// The weight of the product in the units provided.
  ///
  /// The value must be between 0 (exclusive) and 2000 (inclusive).
  ProductWeight? productWeight;

  /// The width of the product in the units provided.
  ///
  /// The value must be between 0 (exclusive) and 3000 (inclusive).
  ProductDimension? productWidth;

  /// The unique ID of a promotion.
  core.List<core.String>? promotionIds;

  /// Advertised sale price of the item.
  Price? salePrice;

  /// Date range during which the item is on sale (see product data
  /// specification ).
  core.String? salePriceEffectiveDate;

  /// The quantity of the product that is available for selling on Google.
  ///
  /// Supported only for online products.
  core.String? sellOnGoogleQuantity;

  /// Shipping rules.
  core.List<ProductShipping>? shipping;

  /// Height of the item for shipping.
  ProductShippingDimension? shippingHeight;

  /// The shipping label of the product, used to group product in account-level
  /// shipping rules.
  core.String? shippingLabel;

  /// Length of the item for shipping.
  ProductShippingDimension? shippingLength;

  /// Weight of the item for shipping.
  ProductShippingWeight? shippingWeight;

  /// Width of the item for shipping.
  ProductShippingDimension? shippingWidth;

  /// List of country codes (ISO 3166-1 alpha-2) to exclude the offer from
  /// Shopping Ads destination.
  ///
  /// Countries from this list are removed from countries configured in MC feed
  /// settings.
  core.List<core.String>? shoppingAdsExcludedCountries;

  /// System in which the size is specified.
  ///
  /// Recommended for apparel items.
  core.String? sizeSystem;

  /// The cut of the item.
  ///
  /// Recommended for apparel items.
  core.String? sizeType;

  /// Size of the item.
  ///
  /// Only one value is allowed. For variants with different sizes, insert a
  /// separate product for each size with the same `itemGroupId` value (see size
  /// definition).
  core.List<core.String>? sizes;

  /// The source of the offer, that is, how the offer was created.
  ///
  /// Acceptable values are: - "`api`" - "`crawl`" - "`feed`"
  core.String? source;

  /// Number of periods (months or years) and amount of payment per period for
  /// an item with an associated subscription contract.
  ProductSubscriptionCost? subscriptionCost;

  /// The CLDR territory code for the item's country of sale.
  ///
  /// Required.
  core.String? targetCountry;

  /// The tax category of the product, used to configure detailed tax nexus in
  /// account-level tax settings.
  core.String? taxCategory;

  /// Tax information.
  core.List<ProductTax>? taxes;

  /// Title of the item.
  core.String? title;

  /// The transit time label of the product, used to group product in
  /// account-level transit time tables.
  core.String? transitTimeLabel;

  /// The preference of the denominator of the unit price.
  ProductUnitPricingBaseMeasure? unitPricingBaseMeasure;

  /// The measure and dimension of an item.
  ProductUnitPricingMeasure? unitPricingMeasure;

  /// URL of the 3D model of the item to provide more visuals.
  core.String? virtualModelLink;

  Product({
    this.additionalImageLinks,
    this.additionalSizeType,
    this.adsGrouping,
    this.adsLabels,
    this.adsRedirect,
    this.adult,
    this.ageGroup,
    this.availability,
    this.availabilityDate,
    this.brand,
    this.canonicalLink,
    this.certifications,
    this.channel,
    this.cloudExportAdditionalProperties,
    this.color,
    this.condition,
    this.contentLanguage,
    this.costOfGoodsSold,
    this.customAttributes,
    this.customLabel0,
    this.customLabel1,
    this.customLabel2,
    this.customLabel3,
    this.customLabel4,
    this.description,
    this.disclosureDate,
    this.displayAdsId,
    this.displayAdsLink,
    this.displayAdsSimilarIds,
    this.displayAdsTitle,
    this.displayAdsValue,
    this.energyEfficiencyClass,
    this.excludedDestinations,
    this.expirationDate,
    this.externalSellerId,
    this.feedLabel,
    this.gender,
    this.googleProductCategory,
    this.gtin,
    this.id,
    this.identifierExists,
    this.imageLink,
    this.includedDestinations,
    this.installment,
    this.isBundle,
    this.itemGroupId,
    this.kind,
    this.lifestyleImageLinks,
    this.link,
    this.linkTemplate,
    this.loyaltyPoints,
    this.material,
    this.maxEnergyEfficiencyClass,
    this.maxHandlingTime,
    this.minEnergyEfficiencyClass,
    this.minHandlingTime,
    this.mobileLink,
    this.mobileLinkTemplate,
    this.mpn,
    this.multipack,
    this.offerId,
    this.pattern,
    this.pause,
    this.pickupMethod,
    this.pickupSla,
    this.price,
    this.productDetails,
    this.productHeight,
    this.productHighlights,
    this.productLength,
    this.productTypes,
    this.productWeight,
    this.productWidth,
    this.promotionIds,
    this.salePrice,
    this.salePriceEffectiveDate,
    this.sellOnGoogleQuantity,
    this.shipping,
    this.shippingHeight,
    this.shippingLabel,
    this.shippingLength,
    this.shippingWeight,
    this.shippingWidth,
    this.shoppingAdsExcludedCountries,
    this.sizeSystem,
    this.sizeType,
    this.sizes,
    this.source,
    this.subscriptionCost,
    this.targetCountry,
    this.taxCategory,
    this.taxes,
    this.title,
    this.transitTimeLabel,
    this.unitPricingBaseMeasure,
    this.unitPricingMeasure,
    this.virtualModelLink,
  });

  Product.fromJson(core.Map json_)
      : this(
          additionalImageLinks: json_.containsKey('additionalImageLinks')
              ? (json_['additionalImageLinks'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          additionalSizeType: json_.containsKey('additionalSizeType')
              ? json_['additionalSizeType'] as core.String
              : null,
          adsGrouping: json_.containsKey('adsGrouping')
              ? json_['adsGrouping'] as core.String
              : null,
          adsLabels: json_.containsKey('adsLabels')
              ? (json_['adsLabels'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          adsRedirect: json_.containsKey('adsRedirect')
              ? json_['adsRedirect'] as core.String
              : null,
          adult:
              json_.containsKey('adult') ? json_['adult'] as core.bool : null,
          ageGroup: json_.containsKey('ageGroup')
              ? json_['ageGroup'] as core.String
              : null,
          availability: json_.containsKey('availability')
              ? json_['availability'] as core.String
              : null,
          availabilityDate: json_.containsKey('availabilityDate')
              ? json_['availabilityDate'] as core.String
              : null,
          brand:
              json_.containsKey('brand') ? json_['brand'] as core.String : null,
          canonicalLink: json_.containsKey('canonicalLink')
              ? json_['canonicalLink'] as core.String
              : null,
          certifications: json_.containsKey('certifications')
              ? (json_['certifications'] as core.List)
                  .map((value) => ProductCertification.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          channel: json_.containsKey('channel')
              ? json_['channel'] as core.String
              : null,
          cloudExportAdditionalProperties:
              json_.containsKey('cloudExportAdditionalProperties')
                  ? (json_['cloudExportAdditionalProperties'] as core.List)
                      .map((value) => CloudExportAdditionalProperties.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                      .toList()
                  : null,
          color:
              json_.containsKey('color') ? json_['color'] as core.String : null,
          condition: json_.containsKey('condition')
              ? json_['condition'] as core.String
              : null,
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          costOfGoodsSold: json_.containsKey('costOfGoodsSold')
              ? Price.fromJson(json_['costOfGoodsSold']
                  as core.Map<core.String, core.dynamic>)
              : null,
          customAttributes: json_.containsKey('customAttributes')
              ? (json_['customAttributes'] as core.List)
                  .map((value) => CustomAttribute.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          customLabel0: json_.containsKey('customLabel0')
              ? json_['customLabel0'] as core.String
              : null,
          customLabel1: json_.containsKey('customLabel1')
              ? json_['customLabel1'] as core.String
              : null,
          customLabel2: json_.containsKey('customLabel2')
              ? json_['customLabel2'] as core.String
              : null,
          customLabel3: json_.containsKey('customLabel3')
              ? json_['customLabel3'] as core.String
              : null,
          customLabel4: json_.containsKey('customLabel4')
              ? json_['customLabel4'] as core.String
              : null,
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          disclosureDate: json_.containsKey('disclosureDate')
              ? json_['disclosureDate'] as core.String
              : null,
          displayAdsId: json_.containsKey('displayAdsId')
              ? json_['displayAdsId'] as core.String
              : null,
          displayAdsLink: json_.containsKey('displayAdsLink')
              ? json_['displayAdsLink'] as core.String
              : null,
          displayAdsSimilarIds: json_.containsKey('displayAdsSimilarIds')
              ? (json_['displayAdsSimilarIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          displayAdsTitle: json_.containsKey('displayAdsTitle')
              ? json_['displayAdsTitle'] as core.String
              : null,
          displayAdsValue: json_.containsKey('displayAdsValue')
              ? (json_['displayAdsValue'] as core.num).toDouble()
              : null,
          energyEfficiencyClass: json_.containsKey('energyEfficiencyClass')
              ? json_['energyEfficiencyClass'] as core.String
              : null,
          excludedDestinations: json_.containsKey('excludedDestinations')
              ? (json_['excludedDestinations'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          expirationDate: json_.containsKey('expirationDate')
              ? json_['expirationDate'] as core.String
              : null,
          externalSellerId: json_.containsKey('externalSellerId')
              ? json_['externalSellerId'] as core.String
              : null,
          feedLabel: json_.containsKey('feedLabel')
              ? json_['feedLabel'] as core.String
              : null,
          gender: json_.containsKey('gender')
              ? json_['gender'] as core.String
              : null,
          googleProductCategory: json_.containsKey('googleProductCategory')
              ? json_['googleProductCategory'] as core.String
              : null,
          gtin: json_.containsKey('gtin') ? json_['gtin'] as core.String : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          identifierExists: json_.containsKey('identifierExists')
              ? json_['identifierExists'] as core.bool
              : null,
          imageLink: json_.containsKey('imageLink')
              ? json_['imageLink'] as core.String
              : null,
          includedDestinations: json_.containsKey('includedDestinations')
              ? (json_['includedDestinations'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          installment: json_.containsKey('installment')
              ? Installment.fromJson(
                  json_['installment'] as core.Map<core.String, core.dynamic>)
              : null,
          isBundle: json_.containsKey('isBundle')
              ? json_['isBundle'] as core.bool
              : null,
          itemGroupId: json_.containsKey('itemGroupId')
              ? json_['itemGroupId'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          lifestyleImageLinks: json_.containsKey('lifestyleImageLinks')
              ? (json_['lifestyleImageLinks'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          link: json_.containsKey('link') ? json_['link'] as core.String : null,
          linkTemplate: json_.containsKey('linkTemplate')
              ? json_['linkTemplate'] as core.String
              : null,
          loyaltyPoints: json_.containsKey('loyaltyPoints')
              ? LoyaltyPoints.fromJson(
                  json_['loyaltyPoints'] as core.Map<core.String, core.dynamic>)
              : null,
          material: json_.containsKey('material')
              ? json_['material'] as core.String
              : null,
          maxEnergyEfficiencyClass:
              json_.containsKey('maxEnergyEfficiencyClass')
                  ? json_['maxEnergyEfficiencyClass'] as core.String
                  : null,
          maxHandlingTime: json_.containsKey('maxHandlingTime')
              ? json_['maxHandlingTime'] as core.String
              : null,
          minEnergyEfficiencyClass:
              json_.containsKey('minEnergyEfficiencyClass')
                  ? json_['minEnergyEfficiencyClass'] as core.String
                  : null,
          minHandlingTime: json_.containsKey('minHandlingTime')
              ? json_['minHandlingTime'] as core.String
              : null,
          mobileLink: json_.containsKey('mobileLink')
              ? json_['mobileLink'] as core.String
              : null,
          mobileLinkTemplate: json_.containsKey('mobileLinkTemplate')
              ? json_['mobileLinkTemplate'] as core.String
              : null,
          mpn: json_.containsKey('mpn') ? json_['mpn'] as core.String : null,
          multipack: json_.containsKey('multipack')
              ? json_['multipack'] as core.String
              : null,
          offerId: json_.containsKey('offerId')
              ? json_['offerId'] as core.String
              : null,
          pattern: json_.containsKey('pattern')
              ? json_['pattern'] as core.String
              : null,
          pause:
              json_.containsKey('pause') ? json_['pause'] as core.String : null,
          pickupMethod: json_.containsKey('pickupMethod')
              ? json_['pickupMethod'] as core.String
              : null,
          pickupSla: json_.containsKey('pickupSla')
              ? json_['pickupSla'] as core.String
              : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          productDetails: json_.containsKey('productDetails')
              ? (json_['productDetails'] as core.List)
                  .map((value) => ProductProductDetail.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          productHeight: json_.containsKey('productHeight')
              ? ProductDimension.fromJson(
                  json_['productHeight'] as core.Map<core.String, core.dynamic>)
              : null,
          productHighlights: json_.containsKey('productHighlights')
              ? (json_['productHighlights'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          productLength: json_.containsKey('productLength')
              ? ProductDimension.fromJson(
                  json_['productLength'] as core.Map<core.String, core.dynamic>)
              : null,
          productTypes: json_.containsKey('productTypes')
              ? (json_['productTypes'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          productWeight: json_.containsKey('productWeight')
              ? ProductWeight.fromJson(
                  json_['productWeight'] as core.Map<core.String, core.dynamic>)
              : null,
          productWidth: json_.containsKey('productWidth')
              ? ProductDimension.fromJson(
                  json_['productWidth'] as core.Map<core.String, core.dynamic>)
              : null,
          promotionIds: json_.containsKey('promotionIds')
              ? (json_['promotionIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          salePrice: json_.containsKey('salePrice')
              ? Price.fromJson(
                  json_['salePrice'] as core.Map<core.String, core.dynamic>)
              : null,
          salePriceEffectiveDate: json_.containsKey('salePriceEffectiveDate')
              ? json_['salePriceEffectiveDate'] as core.String
              : null,
          sellOnGoogleQuantity: json_.containsKey('sellOnGoogleQuantity')
              ? json_['sellOnGoogleQuantity'] as core.String
              : null,
          shipping: json_.containsKey('shipping')
              ? (json_['shipping'] as core.List)
                  .map((value) => ProductShipping.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          shippingHeight: json_.containsKey('shippingHeight')
              ? ProductShippingDimension.fromJson(json_['shippingHeight']
                  as core.Map<core.String, core.dynamic>)
              : null,
          shippingLabel: json_.containsKey('shippingLabel')
              ? json_['shippingLabel'] as core.String
              : null,
          shippingLength: json_.containsKey('shippingLength')
              ? ProductShippingDimension.fromJson(json_['shippingLength']
                  as core.Map<core.String, core.dynamic>)
              : null,
          shippingWeight: json_.containsKey('shippingWeight')
              ? ProductShippingWeight.fromJson(json_['shippingWeight']
                  as core.Map<core.String, core.dynamic>)
              : null,
          shippingWidth: json_.containsKey('shippingWidth')
              ? ProductShippingDimension.fromJson(
                  json_['shippingWidth'] as core.Map<core.String, core.dynamic>)
              : null,
          shoppingAdsExcludedCountries:
              json_.containsKey('shoppingAdsExcludedCountries')
                  ? (json_['shoppingAdsExcludedCountries'] as core.List)
                      .map((value) => value as core.String)
                      .toList()
                  : null,
          sizeSystem: json_.containsKey('sizeSystem')
              ? json_['sizeSystem'] as core.String
              : null,
          sizeType: json_.containsKey('sizeType')
              ? json_['sizeType'] as core.String
              : null,
          sizes: json_.containsKey('sizes')
              ? (json_['sizes'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          source: json_.containsKey('source')
              ? json_['source'] as core.String
              : null,
          subscriptionCost: json_.containsKey('subscriptionCost')
              ? ProductSubscriptionCost.fromJson(json_['subscriptionCost']
                  as core.Map<core.String, core.dynamic>)
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
          taxCategory: json_.containsKey('taxCategory')
              ? json_['taxCategory'] as core.String
              : null,
          taxes: json_.containsKey('taxes')
              ? (json_['taxes'] as core.List)
                  .map((value) => ProductTax.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
          transitTimeLabel: json_.containsKey('transitTimeLabel')
              ? json_['transitTimeLabel'] as core.String
              : null,
          unitPricingBaseMeasure: json_.containsKey('unitPricingBaseMeasure')
              ? ProductUnitPricingBaseMeasure.fromJson(
                  json_['unitPricingBaseMeasure']
                      as core.Map<core.String, core.dynamic>)
              : null,
          unitPricingMeasure: json_.containsKey('unitPricingMeasure')
              ? ProductUnitPricingMeasure.fromJson(json_['unitPricingMeasure']
                  as core.Map<core.String, core.dynamic>)
              : null,
          virtualModelLink: json_.containsKey('virtualModelLink')
              ? json_['virtualModelLink'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (additionalImageLinks != null)
          'additionalImageLinks': additionalImageLinks!,
        if (additionalSizeType != null)
          'additionalSizeType': additionalSizeType!,
        if (adsGrouping != null) 'adsGrouping': adsGrouping!,
        if (adsLabels != null) 'adsLabels': adsLabels!,
        if (adsRedirect != null) 'adsRedirect': adsRedirect!,
        if (adult != null) 'adult': adult!,
        if (ageGroup != null) 'ageGroup': ageGroup!,
        if (availability != null) 'availability': availability!,
        if (availabilityDate != null) 'availabilityDate': availabilityDate!,
        if (brand != null) 'brand': brand!,
        if (canonicalLink != null) 'canonicalLink': canonicalLink!,
        if (certifications != null) 'certifications': certifications!,
        if (channel != null) 'channel': channel!,
        if (cloudExportAdditionalProperties != null)
          'cloudExportAdditionalProperties': cloudExportAdditionalProperties!,
        if (color != null) 'color': color!,
        if (condition != null) 'condition': condition!,
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (costOfGoodsSold != null) 'costOfGoodsSold': costOfGoodsSold!,
        if (customAttributes != null) 'customAttributes': customAttributes!,
        if (customLabel0 != null) 'customLabel0': customLabel0!,
        if (customLabel1 != null) 'customLabel1': customLabel1!,
        if (customLabel2 != null) 'customLabel2': customLabel2!,
        if (customLabel3 != null) 'customLabel3': customLabel3!,
        if (customLabel4 != null) 'customLabel4': customLabel4!,
        if (description != null) 'description': description!,
        if (disclosureDate != null) 'disclosureDate': disclosureDate!,
        if (displayAdsId != null) 'displayAdsId': displayAdsId!,
        if (displayAdsLink != null) 'displayAdsLink': displayAdsLink!,
        if (displayAdsSimilarIds != null)
          'displayAdsSimilarIds': displayAdsSimilarIds!,
        if (displayAdsTitle != null) 'displayAdsTitle': displayAdsTitle!,
        if (displayAdsValue != null) 'displayAdsValue': displayAdsValue!,
        if (energyEfficiencyClass != null)
          'energyEfficiencyClass': energyEfficiencyClass!,
        if (excludedDestinations != null)
          'excludedDestinations': excludedDestinations!,
        if (expirationDate != null) 'expirationDate': expirationDate!,
        if (externalSellerId != null) 'externalSellerId': externalSellerId!,
        if (feedLabel != null) 'feedLabel': feedLabel!,
        if (gender != null) 'gender': gender!,
        if (googleProductCategory != null)
          'googleProductCategory': googleProductCategory!,
        if (gtin != null) 'gtin': gtin!,
        if (id != null) 'id': id!,
        if (identifierExists != null) 'identifierExists': identifierExists!,
        if (imageLink != null) 'imageLink': imageLink!,
        if (includedDestinations != null)
          'includedDestinations': includedDestinations!,
        if (installment != null) 'installment': installment!,
        if (isBundle != null) 'isBundle': isBundle!,
        if (itemGroupId != null) 'itemGroupId': itemGroupId!,
        if (kind != null) 'kind': kind!,
        if (lifestyleImageLinks != null)
          'lifestyleImageLinks': lifestyleImageLinks!,
        if (link != null) 'link': link!,
        if (linkTemplate != null) 'linkTemplate': linkTemplate!,
        if (loyaltyPoints != null) 'loyaltyPoints': loyaltyPoints!,
        if (material != null) 'material': material!,
        if (maxEnergyEfficiencyClass != null)
          'maxEnergyEfficiencyClass': maxEnergyEfficiencyClass!,
        if (maxHandlingTime != null) 'maxHandlingTime': maxHandlingTime!,
        if (minEnergyEfficiencyClass != null)
          'minEnergyEfficiencyClass': minEnergyEfficiencyClass!,
        if (minHandlingTime != null) 'minHandlingTime': minHandlingTime!,
        if (mobileLink != null) 'mobileLink': mobileLink!,
        if (mobileLinkTemplate != null)
          'mobileLinkTemplate': mobileLinkTemplate!,
        if (mpn != null) 'mpn': mpn!,
        if (multipack != null) 'multipack': multipack!,
        if (offerId != null) 'offerId': offerId!,
        if (pattern != null) 'pattern': pattern!,
        if (pause != null) 'pause': pause!,
        if (pickupMethod != null) 'pickupMethod': pickupMethod!,
        if (pickupSla != null) 'pickupSla': pickupSla!,
        if (price != null) 'price': price!,
        if (productDetails != null) 'productDetails': productDetails!,
        if (productHeight != null) 'productHeight': productHeight!,
        if (productHighlights != null) 'productHighlights': productHighlights!,
        if (productLength != null) 'productLength': productLength!,
        if (productTypes != null) 'productTypes': productTypes!,
        if (productWeight != null) 'productWeight': productWeight!,
        if (productWidth != null) 'productWidth': productWidth!,
        if (promotionIds != null) 'promotionIds': promotionIds!,
        if (salePrice != null) 'salePrice': salePrice!,
        if (salePriceEffectiveDate != null)
          'salePriceEffectiveDate': salePriceEffectiveDate!,
        if (sellOnGoogleQuantity != null)
          'sellOnGoogleQuantity': sellOnGoogleQuantity!,
        if (shipping != null) 'shipping': shipping!,
        if (shippingHeight != null) 'shippingHeight': shippingHeight!,
        if (shippingLabel != null) 'shippingLabel': shippingLabel!,
        if (shippingLength != null) 'shippingLength': shippingLength!,
        if (shippingWeight != null) 'shippingWeight': shippingWeight!,
        if (shippingWidth != null) 'shippingWidth': shippingWidth!,
        if (shoppingAdsExcludedCountries != null)
          'shoppingAdsExcludedCountries': shoppingAdsExcludedCountries!,
        if (sizeSystem != null) 'sizeSystem': sizeSystem!,
        if (sizeType != null) 'sizeType': sizeType!,
        if (sizes != null) 'sizes': sizes!,
        if (source != null) 'source': source!,
        if (subscriptionCost != null) 'subscriptionCost': subscriptionCost!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
        if (taxCategory != null) 'taxCategory': taxCategory!,
        if (taxes != null) 'taxes': taxes!,
        if (title != null) 'title': title!,
        if (transitTimeLabel != null) 'transitTimeLabel': transitTimeLabel!,
        if (unitPricingBaseMeasure != null)
          'unitPricingBaseMeasure': unitPricingBaseMeasure!,
        if (unitPricingMeasure != null)
          'unitPricingMeasure': unitPricingMeasure!,
        if (virtualModelLink != null) 'virtualModelLink': virtualModelLink!,
      };
}

class ProductAmount {
  /// The pre-tax or post-tax price depending on the location of the order.
  Price? priceAmount;

  /// Remitted tax value.
  Price? remittedTaxAmount;

  /// Tax value.
  Price? taxAmount;

  ProductAmount({
    this.priceAmount,
    this.remittedTaxAmount,
    this.taxAmount,
  });

  ProductAmount.fromJson(core.Map json_)
      : this(
          priceAmount: json_.containsKey('priceAmount')
              ? Price.fromJson(
                  json_['priceAmount'] as core.Map<core.String, core.dynamic>)
              : null,
          remittedTaxAmount: json_.containsKey('remittedTaxAmount')
              ? Price.fromJson(json_['remittedTaxAmount']
                  as core.Map<core.String, core.dynamic>)
              : null,
          taxAmount: json_.containsKey('taxAmount')
              ? Price.fromJson(
                  json_['taxAmount'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (priceAmount != null) 'priceAmount': priceAmount!,
        if (remittedTaxAmount != null) 'remittedTaxAmount': remittedTaxAmount!,
        if (taxAmount != null) 'taxAmount': taxAmount!,
      };
}

/// Product
/// [certification](https://support.google.com/merchants/answer/13528839),
/// introduced for EU energy efficiency labeling compliance using the
/// [EU EPREL](https://eprel.ec.europa.eu/screen/home) database.
class ProductCertification {
  /// The certification authority, for example "European_Commission".
  ///
  /// Maximum length is 2000 characters.
  core.String? certificationAuthority;

  /// The certification code, for eaxample "123456".
  ///
  /// Maximum length is 2000 characters.
  core.String? certificationCode;

  /// The name of the certification, for example "EPREL".
  ///
  /// Maximum length is 2000 characters.
  core.String? certificationName;

  ProductCertification({
    this.certificationAuthority,
    this.certificationCode,
    this.certificationName,
  });

  ProductCertification.fromJson(core.Map json_)
      : this(
          certificationAuthority: json_.containsKey('certificationAuthority')
              ? json_['certificationAuthority'] as core.String
              : null,
          certificationCode: json_.containsKey('certificationCode')
              ? json_['certificationCode'] as core.String
              : null,
          certificationName: json_.containsKey('certificationName')
              ? json_['certificationName'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (certificationAuthority != null)
          'certificationAuthority': certificationAuthority!,
        if (certificationCode != null) 'certificationCode': certificationCode!,
        if (certificationName != null) 'certificationName': certificationName!,
      };
}

/// Product cluster fields.
///
/// A product cluster is a grouping for different offers that represent the same
/// product. Values are only set for fields requested explicitly in the
/// request's search query.
class ProductCluster {
  /// Brand of the product cluster.
  core.String? brand;

  /// Tells if there is at least one product of the brand currently `IN_STOCK`
  /// in your product feed across multiple countries, all products are
  /// `OUT_OF_STOCK` in your product feed, or `NOT_IN_INVENTORY`.
  ///
  /// The field doesn't take the Best Sellers report country filter into
  /// account.
  /// Possible string values are:
  /// - "INVENTORY_STATUS_UNSPECIFIED" : Inventory status is unknown.
  /// - "IN_STOCK" : Merchant has a product for this product cluster or brand in
  /// stock.
  /// - "OUT_OF_STOCK" : Merchant has a product for this product cluster or
  /// brand in inventory but it is currently out of stock.
  /// - "NOT_IN_INVENTORY" : Merchant does not have a product for this product
  /// cluster or brand in inventory.
  core.String? brandInventoryStatus;

  /// Product category (1st level) of the product cluster, represented in
  /// Google's product taxonomy.
  core.String? categoryL1;

  /// Product category (2nd level) of the product cluster, represented in
  /// Google's product taxonomy.
  core.String? categoryL2;

  /// Product category (3rd level) of the product cluster, represented in
  /// Google's product taxonomy.
  core.String? categoryL3;

  /// Product category (4th level) of the product cluster, represented in
  /// Google's product taxonomy.
  core.String? categoryL4;

  /// Product category (5th level) of the product cluster, represented in
  /// Google's product taxonomy.
  core.String? categoryL5;

  /// Tells whether the product cluster is `IN_STOCK` in your product feed
  /// across multiple countries, `OUT_OF_STOCK` in your product feed, or
  /// `NOT_IN_INVENTORY` at all.
  ///
  /// The field doesn't take the Best Sellers report country filter into
  /// account.
  /// Possible string values are:
  /// - "INVENTORY_STATUS_UNSPECIFIED" : Inventory status is unknown.
  /// - "IN_STOCK" : Merchant has a product for this product cluster or brand in
  /// stock.
  /// - "OUT_OF_STOCK" : Merchant has a product for this product cluster or
  /// brand in inventory but it is currently out of stock.
  /// - "NOT_IN_INVENTORY" : Merchant does not have a product for this product
  /// cluster or brand in inventory.
  core.String? inventoryStatus;

  /// Title of the product cluster.
  core.String? title;

  /// GTINs of example variants of the product cluster.
  core.List<core.String>? variantGtins;

  ProductCluster({
    this.brand,
    this.brandInventoryStatus,
    this.categoryL1,
    this.categoryL2,
    this.categoryL3,
    this.categoryL4,
    this.categoryL5,
    this.inventoryStatus,
    this.title,
    this.variantGtins,
  });

  ProductCluster.fromJson(core.Map json_)
      : this(
          brand:
              json_.containsKey('brand') ? json_['brand'] as core.String : null,
          brandInventoryStatus: json_.containsKey('brandInventoryStatus')
              ? json_['brandInventoryStatus'] as core.String
              : null,
          categoryL1: json_.containsKey('categoryL1')
              ? json_['categoryL1'] as core.String
              : null,
          categoryL2: json_.containsKey('categoryL2')
              ? json_['categoryL2'] as core.String
              : null,
          categoryL3: json_.containsKey('categoryL3')
              ? json_['categoryL3'] as core.String
              : null,
          categoryL4: json_.containsKey('categoryL4')
              ? json_['categoryL4'] as core.String
              : null,
          categoryL5: json_.containsKey('categoryL5')
              ? json_['categoryL5'] as core.String
              : null,
          inventoryStatus: json_.containsKey('inventoryStatus')
              ? json_['inventoryStatus'] as core.String
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
          variantGtins: json_.containsKey('variantGtins')
              ? (json_['variantGtins'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (brand != null) 'brand': brand!,
        if (brandInventoryStatus != null)
          'brandInventoryStatus': brandInventoryStatus!,
        if (categoryL1 != null) 'categoryL1': categoryL1!,
        if (categoryL2 != null) 'categoryL2': categoryL2!,
        if (categoryL3 != null) 'categoryL3': categoryL3!,
        if (categoryL4 != null) 'categoryL4': categoryL4!,
        if (categoryL5 != null) 'categoryL5': categoryL5!,
        if (inventoryStatus != null) 'inventoryStatus': inventoryStatus!,
        if (title != null) 'title': title!,
        if (variantGtins != null) 'variantGtins': variantGtins!,
      };
}

/// The estimated days to deliver a product after an order is placed.
///
/// Only authorized shipping signals partners working with a merchant can use
/// this resource. Merchants should use the
/// \[`products`\](https://developers.google.com/shopping-content/reference/rest/v2.1/products#productshipping)
/// resource instead.
class ProductDeliveryTime {
  /// A set of associations between `DeliveryArea` and `DeliveryTime` entries.
  ///
  /// The total number of `areaDeliveryTimes` can be at most 100.
  ///
  /// Required.
  core.List<ProductDeliveryTimeAreaDeliveryTime>? areaDeliveryTimes;

  /// The `id` of the product.
  ///
  /// Required.
  ProductId? productId;

  ProductDeliveryTime({
    this.areaDeliveryTimes,
    this.productId,
  });

  ProductDeliveryTime.fromJson(core.Map json_)
      : this(
          areaDeliveryTimes: json_.containsKey('areaDeliveryTimes')
              ? (json_['areaDeliveryTimes'] as core.List)
                  .map((value) => ProductDeliveryTimeAreaDeliveryTime.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          productId: json_.containsKey('productId')
              ? ProductId.fromJson(
                  json_['productId'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (areaDeliveryTimes != null) 'areaDeliveryTimes': areaDeliveryTimes!,
        if (productId != null) 'productId': productId!,
      };
}

/// A pairing of `DeliveryArea` associated with a `DeliveryTime` for this
/// product.
class ProductDeliveryTimeAreaDeliveryTime {
  /// The delivery area associated with `deliveryTime` for this product.
  ///
  /// Required.
  DeliveryArea? deliveryArea;

  /// The delivery time associated with `deliveryArea` for this product.
  ///
  /// Required.
  ProductDeliveryTimeAreaDeliveryTimeDeliveryTime? deliveryTime;

  ProductDeliveryTimeAreaDeliveryTime({
    this.deliveryArea,
    this.deliveryTime,
  });

  ProductDeliveryTimeAreaDeliveryTime.fromJson(core.Map json_)
      : this(
          deliveryArea: json_.containsKey('deliveryArea')
              ? DeliveryArea.fromJson(
                  json_['deliveryArea'] as core.Map<core.String, core.dynamic>)
              : null,
          deliveryTime: json_.containsKey('deliveryTime')
              ? ProductDeliveryTimeAreaDeliveryTimeDeliveryTime.fromJson(
                  json_['deliveryTime'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deliveryArea != null) 'deliveryArea': deliveryArea!,
        if (deliveryTime != null) 'deliveryTime': deliveryTime!,
      };
}

/// A delivery time for this product.
class ProductDeliveryTimeAreaDeliveryTimeDeliveryTime {
  /// The maximum number of business days (inclusive) between when an order is
  /// placed and when the product ships.
  ///
  /// If a product ships in the same day, set this value to 0.
  ///
  /// Required.
  core.int? maxHandlingTimeDays;

  /// The maximum number of business days (inclusive) between when the product
  /// ships and when the product is delivered.
  ///
  /// Required.
  core.int? maxTransitTimeDays;

  /// The minimum number of business days (inclusive) between when an order is
  /// placed and when the product ships.
  ///
  /// If a product ships in the same day, set this value to 0.
  ///
  /// Required.
  core.int? minHandlingTimeDays;

  /// The minimum number of business days (inclusive) between when the product
  /// ships and when the product is delivered.
  ///
  /// Required.
  core.int? minTransitTimeDays;

  ProductDeliveryTimeAreaDeliveryTimeDeliveryTime({
    this.maxHandlingTimeDays,
    this.maxTransitTimeDays,
    this.minHandlingTimeDays,
    this.minTransitTimeDays,
  });

  ProductDeliveryTimeAreaDeliveryTimeDeliveryTime.fromJson(core.Map json_)
      : this(
          maxHandlingTimeDays: json_.containsKey('maxHandlingTimeDays')
              ? json_['maxHandlingTimeDays'] as core.int
              : null,
          maxTransitTimeDays: json_.containsKey('maxTransitTimeDays')
              ? json_['maxTransitTimeDays'] as core.int
              : null,
          minHandlingTimeDays: json_.containsKey('minHandlingTimeDays')
              ? json_['minHandlingTimeDays'] as core.int
              : null,
          minTransitTimeDays: json_.containsKey('minTransitTimeDays')
              ? json_['minTransitTimeDays'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (maxHandlingTimeDays != null)
          'maxHandlingTimeDays': maxHandlingTimeDays!,
        if (maxTransitTimeDays != null)
          'maxTransitTimeDays': maxTransitTimeDays!,
        if (minHandlingTimeDays != null)
          'minHandlingTimeDays': minHandlingTimeDays!,
        if (minTransitTimeDays != null)
          'minTransitTimeDays': minTransitTimeDays!,
      };
}

class ProductDimension {
  /// The length units.
  ///
  /// Acceptable values are: - "`in`" - "`cm`"
  ///
  /// Required.
  core.String? unit;

  /// The length value represented as a number.
  ///
  /// The value can have a maximum precision of four decimal places.
  ///
  /// Required.
  core.double? value;

  ProductDimension({
    this.unit,
    this.value,
  });

  ProductDimension.fromJson(core.Map json_)
      : this(
          unit: json_.containsKey('unit') ? json_['unit'] as core.String : null,
          value: json_.containsKey('value')
              ? (json_['value'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (unit != null) 'unit': unit!,
        if (value != null) 'value': value!,
      };
}

/// The Content API ID of the product.
class ProductId {
  /// The Content API ID of the product, in the form
  /// `channel:contentLanguage:targetCountry:offerId`.
  core.String? productId;

  ProductId({
    this.productId,
  });

  ProductId.fromJson(core.Map json_)
      : this(
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (productId != null) 'productId': productId!,
      };
}

/// An issue affecting specific product.
class ProductIssue {
  /// A list of actionable steps that can be executed to solve the issue.
  ///
  /// An example is requesting a re-review or providing arguments when merchant
  /// disagrees with the issue. Actions that are supported in (your) third-party
  /// application can be rendered as buttons and should be available to merchant
  /// when they expand the issue.
  core.List<Action>? actions;

  /// Clarifies the severity of the issue.
  ///
  /// The summarizing message, if present, should be shown right under the title
  /// for each issue. It helps merchants to quickly understand the impact of the
  /// issue. The detailed breakdown helps the merchant to fully understand the
  /// impact of the issue. It can be rendered as dialog that opens when the
  /// merchant mouse over the summarized impact statement. Issues with different
  /// severity can be styled differently. They may use a different color or icon
  /// to signal the difference between `ERROR`, `WARNING` and `INFO`.
  ProductIssueImpact? impact;

  /// Details of the issue as a pre-rendered HTML.
  ///
  /// HTML elements contain CSS classes that can be used to customize the style
  /// of the content. Always sanitize the HTML before embedding it directly to
  /// your application. The sanitizer needs to allow basic HTML tags, such as:
  /// `div`, `span`, `p`, `a`, `ul`, `li`, `table`, `tr`, `td`. For example, you
  /// can use [DOMPurify](https://www.npmjs.com/package/dompurify). CSS classes:
  /// * `issue-detail` - top level container for the detail of the issue *
  /// `callout-banners` - section of the `issue-detail` with callout banners *
  /// `callout-banner` - single callout banner, inside `callout-banners` *
  /// `callout-banner-info` - callout with important information (default) *
  /// `callout-banner-warning` - callout with a warning * `callout-banner-error`
  /// - callout informing about an error (most severe) * `issue-content` -
  /// section of the `issue-detail`, contains multiple `content-element` *
  /// `content-element` - content element such as a list, link or paragraph,
  /// inside `issue-content` * `root-causes` - unordered list with items
  /// describing root causes of the issue, inside `issue-content` *
  /// `root-causes-intro` - intro text before the `root-causes` list, inside
  /// `issue-content` * `segment` - section of the text, `span` inside paragraph
  /// * `segment-attribute` - section of the text that represents a product
  /// attribute, for example 'image\_link' * `segment-literal` - section of the
  /// text that contains a special value, for example '0-1000 kg' *
  /// `segment-bold` - section of the text that should be rendered as bold *
  /// `segment-italic` - section of the text that should be rendered as italic *
  /// `tooltip` - used on paragraphs that should be rendered with a tooltip. A
  /// section of the text in such a paragraph will have a class `tooltip-text`
  /// and is intended to be shown in a mouse over dialog. If the style is not
  /// used, the `tooltip-text` section would be shown on a new line, after the
  /// main part of the text. * `tooltip-text` - marks a section of the text
  /// within a `tooltip`, that is intended to be shown in a mouse over dialog. *
  /// `tooltip-icon` - marks a section of the text within a `tooltip`, that can
  /// be replaced with a tooltip icon, for example '?' or 'i'. By default, this
  /// section contains a `br` tag, that is separating the main text and the
  /// tooltip text when the style is not used. * `tooltip-style-question` - the
  /// tooltip shows helpful information, can use the '?' as an icon. *
  /// `tooltip-style-info` - the tooltip adds additional information fitting to
  /// the context, can use the 'i' as an icon. * `content-moderation` - marks
  /// the paragraph that explains how the issue was identified. * `new-element`
  /// - Present for new elements added to the pre-rendered content in the
  /// future. To make sure that a new content element does not break your style,
  /// you can hide everything with this class.
  core.String? prerenderedContent;

  /// Title of the issue.
  core.String? title;

  ProductIssue({
    this.actions,
    this.impact,
    this.prerenderedContent,
    this.title,
  });

  ProductIssue.fromJson(core.Map json_)
      : this(
          actions: json_.containsKey('actions')
              ? (json_['actions'] as core.List)
                  .map((value) => Action.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          impact: json_.containsKey('impact')
              ? ProductIssueImpact.fromJson(
                  json_['impact'] as core.Map<core.String, core.dynamic>)
              : null,
          prerenderedContent: json_.containsKey('prerenderedContent')
              ? json_['prerenderedContent'] as core.String
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (actions != null) 'actions': actions!,
        if (impact != null) 'impact': impact!,
        if (prerenderedContent != null)
          'prerenderedContent': prerenderedContent!,
        if (title != null) 'title': title!,
      };
}

/// Overall impact of product issue.
class ProductIssueImpact {
  /// Detailed impact breakdown.
  ///
  /// Explains the types of restriction the issue has in different shopping
  /// destinations and territory. If present, it should be rendered to the
  /// merchant. Can be shown as a mouse over dropdown or a dialog. Each
  /// breakdown item represents a group of regions with the same impact details.
  core.List<Breakdown>? breakdowns;

  /// Message summarizing the overall impact of the issue.
  ///
  /// If present, it should be rendered to the merchant. For example: "Limits
  /// visibility in France"
  ///
  /// Optional.
  core.String? message;

  /// The severity of the issue.
  /// Possible string values are:
  /// - "SEVERITY_UNSPECIFIED" : Default value. Will never be provided by the
  /// API.
  /// - "ERROR" : Causes either an account suspension or an item disapproval.
  /// Errors should be resolved as soon as possible to ensure items are eligible
  /// to appear in results again.
  /// - "WARNING" : Warnings can negatively impact the performance of ads and
  /// can lead to item or account suspensions in the future unless the issue is
  /// resolved.
  /// - "INFO" : Infos are suggested optimizations to increase data quality.
  /// Resolving these issues is recommended, but not required.
  core.String? severity;

  ProductIssueImpact({
    this.breakdowns,
    this.message,
    this.severity,
  });

  ProductIssueImpact.fromJson(core.Map json_)
      : this(
          breakdowns: json_.containsKey('breakdowns')
              ? (json_['breakdowns'] as core.List)
                  .map((value) => Breakdown.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          message: json_.containsKey('message')
              ? json_['message'] as core.String
              : null,
          severity: json_.containsKey('severity')
              ? json_['severity'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (breakdowns != null) 'breakdowns': breakdowns!,
        if (message != null) 'message': message!,
        if (severity != null) 'severity': severity!,
      };
}

class ProductProductDetail {
  /// The name of the product detail.
  core.String? attributeName;

  /// The value of the product detail.
  core.String? attributeValue;

  /// The section header used to group a set of product details.
  core.String? sectionName;

  ProductProductDetail({
    this.attributeName,
    this.attributeValue,
    this.sectionName,
  });

  ProductProductDetail.fromJson(core.Map json_)
      : this(
          attributeName: json_.containsKey('attributeName')
              ? json_['attributeName'] as core.String
              : null,
          attributeValue: json_.containsKey('attributeValue')
              ? json_['attributeValue'] as core.String
              : null,
          sectionName: json_.containsKey('sectionName')
              ? json_['sectionName'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributeName != null) 'attributeName': attributeName!,
        if (attributeValue != null) 'attributeValue': attributeValue!,
        if (sectionName != null) 'sectionName': sectionName!,
      };
}

class ProductShipping {
  /// The CLDR territory code of the country to which an item will ship.
  core.String? country;

  /// The location where the shipping is applicable, represented by a location
  /// group name.
  core.String? locationGroupName;

  /// The numeric ID of a location that the shipping rate applies to as defined
  /// in the Google Ads API.
  core.String? locationId;

  /// Maximum handling time (inclusive) between when the order is received and
  /// shipped in business days.
  ///
  /// 0 means that the order is shipped on the same day as it's received if it
  /// happens before the cut-off time. Both maxHandlingTime and maxTransitTime
  /// are required if providing shipping speeds.
  core.String? maxHandlingTime;

  /// Maximum transit time (inclusive) between when the order has shipped and
  /// when it's delivered in business days.
  ///
  /// 0 means that the order is delivered on the same day as it ships. Both
  /// maxHandlingTime and maxTransitTime are required if providing shipping
  /// speeds.
  core.String? maxTransitTime;

  /// Minimum handling time (inclusive) between when the order is received and
  /// shipped in business days.
  ///
  /// 0 means that the order is shipped on the same day as it's received if it
  /// happens before the cut-off time. minHandlingTime can only be present
  /// together with maxHandlingTime; but it's not required if maxHandlingTime is
  /// present.
  core.String? minHandlingTime;

  /// Minimum transit time (inclusive) between when the order has shipped and
  /// when it's delivered in business days.
  ///
  /// 0 means that the order is delivered on the same day as it ships.
  /// minTransitTime can only be present together with maxTransitTime; but it's
  /// not required if maxTransitTime is present.
  core.String? minTransitTime;

  /// The postal code range that the shipping rate applies to, represented by a
  /// postal code, a postal code prefix followed by a * wildcard, a range
  /// between two postal codes or two postal code prefixes of equal length.
  core.String? postalCode;

  /// Fixed shipping price, represented as a number.
  Price? price;

  /// The geographic region to which a shipping rate applies.
  core.String? region;

  /// A free-form description of the service class or delivery speed.
  core.String? service;

  ProductShipping({
    this.country,
    this.locationGroupName,
    this.locationId,
    this.maxHandlingTime,
    this.maxTransitTime,
    this.minHandlingTime,
    this.minTransitTime,
    this.postalCode,
    this.price,
    this.region,
    this.service,
  });

  ProductShipping.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          locationGroupName: json_.containsKey('locationGroupName')
              ? json_['locationGroupName'] as core.String
              : null,
          locationId: json_.containsKey('locationId')
              ? json_['locationId'] as core.String
              : null,
          maxHandlingTime: json_.containsKey('maxHandlingTime')
              ? json_['maxHandlingTime'] as core.String
              : null,
          maxTransitTime: json_.containsKey('maxTransitTime')
              ? json_['maxTransitTime'] as core.String
              : null,
          minHandlingTime: json_.containsKey('minHandlingTime')
              ? json_['minHandlingTime'] as core.String
              : null,
          minTransitTime: json_.containsKey('minTransitTime')
              ? json_['minTransitTime'] as core.String
              : null,
          postalCode: json_.containsKey('postalCode')
              ? json_['postalCode'] as core.String
              : null,
          price: json_.containsKey('price')
              ? Price.fromJson(
                  json_['price'] as core.Map<core.String, core.dynamic>)
              : null,
          region: json_.containsKey('region')
              ? json_['region'] as core.String
              : null,
          service: json_.containsKey('service')
              ? json_['service'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (locationGroupName != null) 'locationGroupName': locationGroupName!,
        if (locationId != null) 'locationId': locationId!,
        if (maxHandlingTime != null) 'maxHandlingTime': maxHandlingTime!,
        if (maxTransitTime != null) 'maxTransitTime': maxTransitTime!,
        if (minHandlingTime != null) 'minHandlingTime': minHandlingTime!,
        if (minTransitTime != null) 'minTransitTime': minTransitTime!,
        if (postalCode != null) 'postalCode': postalCode!,
        if (price != null) 'price': price!,
        if (region != null) 'region': region!,
        if (service != null) 'service': service!,
      };
}

class ProductShippingDimension {
  /// The unit of value.
  core.String? unit;

  /// The dimension of the product used to calculate the shipping cost of the
  /// item.
  core.double? value;

  ProductShippingDimension({
    this.unit,
    this.value,
  });

  ProductShippingDimension.fromJson(core.Map json_)
      : this(
          unit: json_.containsKey('unit') ? json_['unit'] as core.String : null,
          value: json_.containsKey('value')
              ? (json_['value'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (unit != null) 'unit': unit!,
        if (value != null) 'value': value!,
      };
}

class ProductShippingWeight {
  /// The unit of value.
  core.String? unit;

  /// The weight of the product used to calculate the shipping cost of the item.
  core.double? value;

  ProductShippingWeight({
    this.unit,
    this.value,
  });

  ProductShippingWeight.fromJson(core.Map json_)
      : this(
          unit: json_.containsKey('unit') ? json_['unit'] as core.String : null,
          value: json_.containsKey('value')
              ? (json_['value'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (unit != null) 'unit': unit!,
        if (value != null) 'value': value!,
      };
}

/// The status of a product, that is, information about a product computed
/// asynchronously.
class ProductStatus {
  /// Date on which the item has been created, in ISO 8601 format.
  core.String? creationDate;

  /// The intended destinations for the product.
  core.List<ProductStatusDestinationStatus>? destinationStatuses;

  /// Date on which the item expires in Google Shopping, in ISO 8601 format.
  core.String? googleExpirationDate;

  /// A list of all issues associated with the product.
  core.List<ProductStatusItemLevelIssue>? itemLevelIssues;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#productStatus`"
  core.String? kind;

  /// Date on which the item has been last updated, in ISO 8601 format.
  core.String? lastUpdateDate;

  /// The link to the product.
  core.String? link;

  /// The ID of the product for which status is reported.
  core.String? productId;

  /// The title of the product.
  core.String? title;

  ProductStatus({
    this.creationDate,
    this.destinationStatuses,
    this.googleExpirationDate,
    this.itemLevelIssues,
    this.kind,
    this.lastUpdateDate,
    this.link,
    this.productId,
    this.title,
  });

  ProductStatus.fromJson(core.Map json_)
      : this(
          creationDate: json_.containsKey('creationDate')
              ? json_['creationDate'] as core.String
              : null,
          destinationStatuses: json_.containsKey('destinationStatuses')
              ? (json_['destinationStatuses'] as core.List)
                  .map((value) => ProductStatusDestinationStatus.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          googleExpirationDate: json_.containsKey('googleExpirationDate')
              ? json_['googleExpirationDate'] as core.String
              : null,
          itemLevelIssues: json_.containsKey('itemLevelIssues')
              ? (json_['itemLevelIssues'] as core.List)
                  .map((value) => ProductStatusItemLevelIssue.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          lastUpdateDate: json_.containsKey('lastUpdateDate')
              ? json_['lastUpdateDate'] as core.String
              : null,
          link: json_.containsKey('link') ? json_['link'] as core.String : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (creationDate != null) 'creationDate': creationDate!,
        if (destinationStatuses != null)
          'destinationStatuses': destinationStatuses!,
        if (googleExpirationDate != null)
          'googleExpirationDate': googleExpirationDate!,
        if (itemLevelIssues != null) 'itemLevelIssues': itemLevelIssues!,
        if (kind != null) 'kind': kind!,
        if (lastUpdateDate != null) 'lastUpdateDate': lastUpdateDate!,
        if (link != null) 'link': link!,
        if (productId != null) 'productId': productId!,
        if (title != null) 'title': title!,
      };
}

class ProductStatusDestinationStatus {
  /// List of country codes (ISO 3166-1 alpha-2) where the offer is approved.
  core.List<core.String>? approvedCountries;

  /// The name of the destination
  core.String? destination;

  /// List of country codes (ISO 3166-1 alpha-2) where the offer is disapproved.
  core.List<core.String>? disapprovedCountries;

  /// List of country codes (ISO 3166-1 alpha-2) where the offer is pending
  /// approval.
  core.List<core.String>? pendingCountries;

  /// Destination approval status in `targetCountry` of the offer.
  ///
  /// Deprecated.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? status;

  ProductStatusDestinationStatus({
    this.approvedCountries,
    this.destination,
    this.disapprovedCountries,
    this.pendingCountries,
    this.status,
  });

  ProductStatusDestinationStatus.fromJson(core.Map json_)
      : this(
          approvedCountries: json_.containsKey('approvedCountries')
              ? (json_['approvedCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          destination: json_.containsKey('destination')
              ? json_['destination'] as core.String
              : null,
          disapprovedCountries: json_.containsKey('disapprovedCountries')
              ? (json_['disapprovedCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          pendingCountries: json_.containsKey('pendingCountries')
              ? (json_['pendingCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (approvedCountries != null) 'approvedCountries': approvedCountries!,
        if (destination != null) 'destination': destination!,
        if (disapprovedCountries != null)
          'disapprovedCountries': disapprovedCountries!,
        if (pendingCountries != null) 'pendingCountries': pendingCountries!,
        if (status != null) 'status': status!,
      };
}

class ProductStatusItemLevelIssue {
  /// List of country codes (ISO 3166-1 alpha-2) where issue applies to the
  /// offer.
  core.List<core.String>? applicableCountries;

  /// The attribute's name, if the issue is caused by a single attribute.
  core.String? attributeName;

  /// The error code of the issue.
  core.String? code;

  /// A short issue description in English.
  core.String? description;

  /// The destination the issue applies to.
  core.String? destination;

  /// A detailed issue description in English.
  core.String? detail;

  /// The URL of a web page to help with resolving this issue.
  core.String? documentation;

  /// Whether the issue can be resolved by the merchant.
  core.String? resolution;

  /// How this issue affects serving of the offer.
  core.String? servability;

  ProductStatusItemLevelIssue({
    this.applicableCountries,
    this.attributeName,
    this.code,
    this.description,
    this.destination,
    this.detail,
    this.documentation,
    this.resolution,
    this.servability,
  });

  ProductStatusItemLevelIssue.fromJson(core.Map json_)
      : this(
          applicableCountries: json_.containsKey('applicableCountries')
              ? (json_['applicableCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          attributeName: json_.containsKey('attributeName')
              ? json_['attributeName'] as core.String
              : null,
          code: json_.containsKey('code') ? json_['code'] as core.String : null,
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          destination: json_.containsKey('destination')
              ? json_['destination'] as core.String
              : null,
          detail: json_.containsKey('detail')
              ? json_['detail'] as core.String
              : null,
          documentation: json_.containsKey('documentation')
              ? json_['documentation'] as core.String
              : null,
          resolution: json_.containsKey('resolution')
              ? json_['resolution'] as core.String
              : null,
          servability: json_.containsKey('servability')
              ? json_['servability'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (applicableCountries != null)
          'applicableCountries': applicableCountries!,
        if (attributeName != null) 'attributeName': attributeName!,
        if (code != null) 'code': code!,
        if (description != null) 'description': description!,
        if (destination != null) 'destination': destination!,
        if (detail != null) 'detail': detail!,
        if (documentation != null) 'documentation': documentation!,
        if (resolution != null) 'resolution': resolution!,
        if (servability != null) 'servability': servability!,
      };
}

class ProductSubscriptionCost {
  /// The amount the buyer has to pay per subscription period.
  Price? amount;

  /// The type of subscription period.
  core.String? period;

  /// The number of subscription periods the buyer has to pay.
  core.String? periodLength;

  ProductSubscriptionCost({
    this.amount,
    this.period,
    this.periodLength,
  });

  ProductSubscriptionCost.fromJson(core.Map json_)
      : this(
          amount: json_.containsKey('amount')
              ? Price.fromJson(
                  json_['amount'] as core.Map<core.String, core.dynamic>)
              : null,
          period: json_.containsKey('period')
              ? json_['period'] as core.String
              : null,
          periodLength: json_.containsKey('periodLength')
              ? json_['periodLength'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (amount != null) 'amount': amount!,
        if (period != null) 'period': period!,
        if (periodLength != null) 'periodLength': periodLength!,
      };
}

class ProductTax {
  /// The country within which the item is taxed, specified as a CLDR territory
  /// code.
  core.String? country;

  /// The numeric ID of a location that the tax rate applies to as defined in
  /// the Google Ads API.
  core.String? locationId;

  /// The postal code range that the tax rate applies to, represented by a ZIP
  /// code, a ZIP code prefix using * wildcard, a range between two ZIP codes or
  /// two ZIP code prefixes of equal length.
  ///
  /// Examples: 94114, 94*, 94002-95460, 94*-95*.
  core.String? postalCode;

  /// The percentage of tax rate that applies to the item price.
  core.double? rate;

  /// The geographic region to which the tax rate applies.
  core.String? region;

  /// Should be set to true if tax is charged on shipping.
  core.bool? taxShip;

  ProductTax({
    this.country,
    this.locationId,
    this.postalCode,
    this.rate,
    this.region,
    this.taxShip,
  });

  ProductTax.fromJson(core.Map json_)
      : this(
          country: json_.containsKey('country')
              ? json_['country'] as core.String
              : null,
          locationId: json_.containsKey('locationId')
              ? json_['locationId'] as core.String
              : null,
          postalCode: json_.containsKey('postalCode')
              ? json_['postalCode'] as core.String
              : null,
          rate: json_.containsKey('rate')
              ? (json_['rate'] as core.num).toDouble()
              : null,
          region: json_.containsKey('region')
              ? json_['region'] as core.String
              : null,
          taxShip: json_.containsKey('taxShip')
              ? json_['taxShip'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (country != null) 'country': country!,
        if (locationId != null) 'locationId': locationId!,
        if (postalCode != null) 'postalCode': postalCode!,
        if (rate != null) 'rate': rate!,
        if (region != null) 'region': region!,
        if (taxShip != null) 'taxShip': taxShip!,
      };
}

class ProductUnitPricingBaseMeasure {
  /// The unit of the denominator.
  core.String? unit;

  /// The denominator of the unit price.
  core.String? value;

  ProductUnitPricingBaseMeasure({
    this.unit,
    this.value,
  });

  ProductUnitPricingBaseMeasure.fromJson(core.Map json_)
      : this(
          unit: json_.containsKey('unit') ? json_['unit'] as core.String : null,
          value:
              json_.containsKey('value') ? json_['value'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (unit != null) 'unit': unit!,
        if (value != null) 'value': value!,
      };
}

class ProductUnitPricingMeasure {
  /// The unit of the measure.
  core.String? unit;

  /// The measure of an item.
  core.double? value;

  ProductUnitPricingMeasure({
    this.unit,
    this.value,
  });

  ProductUnitPricingMeasure.fromJson(core.Map json_)
      : this(
          unit: json_.containsKey('unit') ? json_['unit'] as core.String : null,
          value: json_.containsKey('value')
              ? (json_['value'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (unit != null) 'unit': unit!,
        if (value != null) 'value': value!,
      };
}

/// Product fields.
///
/// Values are only set for fields requested explicitly in the request's search
/// query.
class ProductView {
  /// Aggregated destination status.
  /// Possible string values are:
  /// - "AGGREGATED_STATUS_UNSPECIFIED" : Undefined aggregated status.
  /// - "NOT_ELIGIBLE_OR_DISAPPROVED" : Offer isn't eligible, or is disapproved
  /// for all destinations.
  /// - "PENDING" : Offer's status is pending in all destinations.
  /// - "ELIGIBLE_LIMITED" : Offer is eligible for some (but not all)
  /// destinations.
  /// - "ELIGIBLE" : Offer is eligible for all destinations.
  core.String? aggregatedDestinationStatus;

  /// Availability of the product.
  core.String? availability;

  /// Brand of the product.
  core.String? brand;

  /// First level of the product category in
  /// [Google's product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? categoryL1;

  /// Second level of the product category in
  /// [Google's product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? categoryL2;

  /// Third level of the product category in
  /// [Google's product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? categoryL3;

  /// Fourth level of the product category in
  /// [Google's product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? categoryL4;

  /// Fifth level of the product category in
  /// [Google's product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? categoryL5;

  /// Channel of the product (online versus local).
  /// Possible string values are:
  /// - "CHANNEL_UNSPECIFIED" : Indicates that the channel is unspecified.
  /// - "LOCAL" : Indicates that the channel is local.
  /// - "ONLINE" : Indicates that the channel is online.
  core.String? channel;

  /// Condition of the product.
  core.String? condition;

  /// The time the merchant created the product in timestamp seconds.
  core.String? creationTime;

  /// Product price currency code (for example, ISO 4217).
  ///
  /// Absent if product price is not available.
  core.String? currencyCode;

  /// Expiration date for the product.
  ///
  /// Specified on insertion.
  Date? expirationDate;

  /// GTIN of the product.
  core.List<core.String>? gtin;

  /// The REST ID of the product, in the form of
  /// channel:contentLanguage:targetCountry:offerId.
  ///
  /// Content API methods that operate on products take this as their productId
  /// parameter. Should always be included in the SELECT clause.
  core.String? id;

  /// Item group ID provided by the merchant for grouping variants together.
  core.String? itemGroupId;

  /// List of item issues for the product.
  core.List<ProductViewItemIssue>? itemIssues;

  /// Language code of the product in BCP 47 format.
  core.String? languageCode;

  /// Merchant-provided id of the product.
  core.String? offerId;

  /// Product price specified as micros (1 millionth of a standard unit, 1 USD =
  /// 1000000 micros) in the product currency.
  ///
  /// Absent in case the information about the price of the product is not
  /// available.
  core.String? priceMicros;

  /// First level of the product type in merchant's own
  /// [product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? productTypeL1;

  /// Second level of the product type in merchant's own
  /// [product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? productTypeL2;

  /// Third level of the product type in merchant's own
  /// [product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? productTypeL3;

  /// Fourth level of the product type in merchant's own
  /// [product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? productTypeL4;

  /// Fifth level of the product type in merchant's own
  /// [product taxonomy](https://support.google.com/merchants/answer/6324436).
  core.String? productTypeL5;

  /// The normalized shipping label specified in the feed
  core.String? shippingLabel;

  /// Title of the product.
  core.String? title;

  ProductView({
    this.aggregatedDestinationStatus,
    this.availability,
    this.brand,
    this.categoryL1,
    this.categoryL2,
    this.categoryL3,
    this.categoryL4,
    this.categoryL5,
    this.channel,
    this.condition,
    this.creationTime,
    this.currencyCode,
    this.expirationDate,
    this.gtin,
    this.id,
    this.itemGroupId,
    this.itemIssues,
    this.languageCode,
    this.offerId,
    this.priceMicros,
    this.productTypeL1,
    this.productTypeL2,
    this.productTypeL3,
    this.productTypeL4,
    this.productTypeL5,
    this.shippingLabel,
    this.title,
  });

  ProductView.fromJson(core.Map json_)
      : this(
          aggregatedDestinationStatus:
              json_.containsKey('aggregatedDestinationStatus')
                  ? json_['aggregatedDestinationStatus'] as core.String
                  : null,
          availability: json_.containsKey('availability')
              ? json_['availability'] as core.String
              : null,
          brand:
              json_.containsKey('brand') ? json_['brand'] as core.String : null,
          categoryL1: json_.containsKey('categoryL1')
              ? json_['categoryL1'] as core.String
              : null,
          categoryL2: json_.containsKey('categoryL2')
              ? json_['categoryL2'] as core.String
              : null,
          categoryL3: json_.containsKey('categoryL3')
              ? json_['categoryL3'] as core.String
              : null,
          categoryL4: json_.containsKey('categoryL4')
              ? json_['categoryL4'] as core.String
              : null,
          categoryL5: json_.containsKey('categoryL5')
              ? json_['categoryL5'] as core.String
              : null,
          channel: json_.containsKey('channel')
              ? json_['channel'] as core.String
              : null,
          condition: json_.containsKey('condition')
              ? json_['condition'] as core.String
              : null,
          creationTime: json_.containsKey('creationTime')
              ? json_['creationTime'] as core.String
              : null,
          currencyCode: json_.containsKey('currencyCode')
              ? json_['currencyCode'] as core.String
              : null,
          expirationDate: json_.containsKey('expirationDate')
              ? Date.fromJson(json_['expirationDate']
                  as core.Map<core.String, core.dynamic>)
              : null,
          gtin: json_.containsKey('gtin')
              ? (json_['gtin'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          itemGroupId: json_.containsKey('itemGroupId')
              ? json_['itemGroupId'] as core.String
              : null,
          itemIssues: json_.containsKey('itemIssues')
              ? (json_['itemIssues'] as core.List)
                  .map((value) => ProductViewItemIssue.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          languageCode: json_.containsKey('languageCode')
              ? json_['languageCode'] as core.String
              : null,
          offerId: json_.containsKey('offerId')
              ? json_['offerId'] as core.String
              : null,
          priceMicros: json_.containsKey('priceMicros')
              ? json_['priceMicros'] as core.String
              : null,
          productTypeL1: json_.containsKey('productTypeL1')
              ? json_['productTypeL1'] as core.String
              : null,
          productTypeL2: json_.containsKey('productTypeL2')
              ? json_['productTypeL2'] as core.String
              : null,
          productTypeL3: json_.containsKey('productTypeL3')
              ? json_['productTypeL3'] as core.String
              : null,
          productTypeL4: json_.containsKey('productTypeL4')
              ? json_['productTypeL4'] as core.String
              : null,
          productTypeL5: json_.containsKey('productTypeL5')
              ? json_['productTypeL5'] as core.String
              : null,
          shippingLabel: json_.containsKey('shippingLabel')
              ? json_['shippingLabel'] as core.String
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aggregatedDestinationStatus != null)
          'aggregatedDestinationStatus': aggregatedDestinationStatus!,
        if (availability != null) 'availability': availability!,
        if (brand != null) 'brand': brand!,
        if (categoryL1 != null) 'categoryL1': categoryL1!,
        if (categoryL2 != null) 'categoryL2': categoryL2!,
        if (categoryL3 != null) 'categoryL3': categoryL3!,
        if (categoryL4 != null) 'categoryL4': categoryL4!,
        if (categoryL5 != null) 'categoryL5': categoryL5!,
        if (channel != null) 'channel': channel!,
        if (condition != null) 'condition': condition!,
        if (creationTime != null) 'creationTime': creationTime!,
        if (currencyCode != null) 'currencyCode': currencyCode!,
        if (expirationDate != null) 'expirationDate': expirationDate!,
        if (gtin != null) 'gtin': gtin!,
        if (id != null) 'id': id!,
        if (itemGroupId != null) 'itemGroupId': itemGroupId!,
        if (itemIssues != null) 'itemIssues': itemIssues!,
        if (languageCode != null) 'languageCode': languageCode!,
        if (offerId != null) 'offerId': offerId!,
        if (priceMicros != null) 'priceMicros': priceMicros!,
        if (productTypeL1 != null) 'productTypeL1': productTypeL1!,
        if (productTypeL2 != null) 'productTypeL2': productTypeL2!,
        if (productTypeL3 != null) 'productTypeL3': productTypeL3!,
        if (productTypeL4 != null) 'productTypeL4': productTypeL4!,
        if (productTypeL5 != null) 'productTypeL5': productTypeL5!,
        if (shippingLabel != null) 'shippingLabel': shippingLabel!,
        if (title != null) 'title': title!,
      };
}

/// Item issue associated with the product.
class ProductViewItemIssue {
  /// Item issue type.
  ProductViewItemIssueItemIssueType? issueType;

  /// Item issue resolution.
  /// Possible string values are:
  /// - "UNKNOWN" : Unknown resolution type.
  /// - "MERCHANT_ACTION" : The merchant has to fix the issue.
  /// - "PENDING_PROCESSING" : The issue will be resolved automatically (for
  /// example, image crawl), or Google review. No merchant action is required
  /// now. Resolution might lead to another issue (for example, if crawl fails).
  core.String? resolution;

  /// Item issue severity.
  ProductViewItemIssueItemIssueSeverity? severity;

  ProductViewItemIssue({
    this.issueType,
    this.resolution,
    this.severity,
  });

  ProductViewItemIssue.fromJson(core.Map json_)
      : this(
          issueType: json_.containsKey('issueType')
              ? ProductViewItemIssueItemIssueType.fromJson(
                  json_['issueType'] as core.Map<core.String, core.dynamic>)
              : null,
          resolution: json_.containsKey('resolution')
              ? json_['resolution'] as core.String
              : null,
          severity: json_.containsKey('severity')
              ? ProductViewItemIssueItemIssueSeverity.fromJson(
                  json_['severity'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (issueType != null) 'issueType': issueType!,
        if (resolution != null) 'resolution': resolution!,
        if (severity != null) 'severity': severity!,
      };
}

/// Issue severity for all affected regions in a destination.
class ProductViewItemIssueIssueSeverityPerDestination {
  /// List of demoted countries in the destination.
  core.List<core.String>? demotedCountries;

  /// Issue destination.
  core.String? destination;

  /// List of disapproved countries in the destination.
  core.List<core.String>? disapprovedCountries;

  ProductViewItemIssueIssueSeverityPerDestination({
    this.demotedCountries,
    this.destination,
    this.disapprovedCountries,
  });

  ProductViewItemIssueIssueSeverityPerDestination.fromJson(core.Map json_)
      : this(
          demotedCountries: json_.containsKey('demotedCountries')
              ? (json_['demotedCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          destination: json_.containsKey('destination')
              ? json_['destination'] as core.String
              : null,
          disapprovedCountries: json_.containsKey('disapprovedCountries')
              ? (json_['disapprovedCountries'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (demotedCountries != null) 'demotedCountries': demotedCountries!,
        if (destination != null) 'destination': destination!,
        if (disapprovedCountries != null)
          'disapprovedCountries': disapprovedCountries!,
      };
}

/// Severity of an issue per destination in a region, and aggregated severity.
class ProductViewItemIssueItemIssueSeverity {
  /// Severity of an issue aggregated for destination.
  /// Possible string values are:
  /// - "AGGREGATED_ISSUE_SEVERITY_UNSPECIFIED" : Undefined Issue severity.
  /// - "DISAPPROVED" : Issue disapproves the product in at least one of the
  /// selected destinations.
  /// - "DEMOTED" : Issue demotes the product in all selected destinations it
  /// affects.
  /// - "PENDING" : Issue resolution is `PENDING_PROCESSING`.
  core.String? aggregatedSeverity;

  /// Item issue severity for every destination.
  core.List<ProductViewItemIssueIssueSeverityPerDestination>?
      severityPerDestination;

  ProductViewItemIssueItemIssueSeverity({
    this.aggregatedSeverity,
    this.severityPerDestination,
  });

  ProductViewItemIssueItemIssueSeverity.fromJson(core.Map json_)
      : this(
          aggregatedSeverity: json_.containsKey('aggregatedSeverity')
              ? json_['aggregatedSeverity'] as core.String
              : null,
          severityPerDestination: json_.containsKey('severityPerDestination')
              ? (json_['severityPerDestination'] as core.List)
                  .map((value) =>
                      ProductViewItemIssueIssueSeverityPerDestination.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aggregatedSeverity != null)
          'aggregatedSeverity': aggregatedSeverity!,
        if (severityPerDestination != null)
          'severityPerDestination': severityPerDestination!,
      };
}

/// Type of the item issue.
class ProductViewItemIssueItemIssueType {
  /// Canonical attribute name for attribute-specific issues.
  core.String? canonicalAttribute;

  /// Error code of the issue.
  core.String? code;

  ProductViewItemIssueItemIssueType({
    this.canonicalAttribute,
    this.code,
  });

  ProductViewItemIssueItemIssueType.fromJson(core.Map json_)
      : this(
          canonicalAttribute: json_.containsKey('canonicalAttribute')
              ? json_['canonicalAttribute'] as core.String
              : null,
          code: json_.containsKey('code') ? json_['code'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (canonicalAttribute != null)
          'canonicalAttribute': canonicalAttribute!,
        if (code != null) 'code': code!,
      };
}

class ProductWeight {
  /// The weight unit.
  ///
  /// Acceptable values are: - "`g`" - "`kg`" - "`oz`" - "`lb`"
  ///
  /// Required.
  core.String? unit;

  /// The weight represented as a number.
  ///
  /// The weight can have a maximum precision of four decimal places.
  ///
  /// Required.
  core.double? value;

  ProductWeight({
    this.unit,
    this.value,
  });

  ProductWeight.fromJson(core.Map json_)
      : this(
          unit: json_.containsKey('unit') ? json_['unit'] as core.String : null,
          value: json_.containsKey('value')
              ? (json_['value'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (unit != null) 'unit': unit!,
        if (value != null) 'value': value!,
      };
}

class ProductsCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<ProductsCustomBatchRequestEntry>? entries;

  ProductsCustomBatchRequest({
    this.entries,
  });

  ProductsCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => ProductsCustomBatchRequestEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

/// A batch entry encoding a single non-batch products request.
class ProductsCustomBatchRequestEntry {
  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// The Content API Supplemental Feed ID.
  ///
  /// If present then product insertion or deletion applies to a supplemental
  /// feed instead of primary Content API feed.
  core.String? feedId;

  /// The ID of the managing account.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`delete`" - "`get`" - "`insert`" - "`update`"
  core.String? method;

  /// The product to insert or update.
  ///
  /// Only required if the method is `insert` or `update`. If the `update`
  /// method is used with `updateMask` only to delete a field, then this isn't
  /// required. For example, setting `salePrice` on the `updateMask` and not
  /// providing a `product` will result in an existing sale price on the product
  /// specified by `productId` being deleted.
  Product? product;

  /// The ID of the product to get or mutate.
  ///
  /// Only defined if the method is `get`, `delete`, or `update`.
  core.String? productId;

  /// The comma-separated list of product attributes to be updated.
  ///
  /// Example: `"title,salePrice"`. Attributes specified in the update mask
  /// without a value specified in the body will be deleted from the product.
  /// *You must specify the update mask to delete attributes.* Only top-level
  /// product attributes can be updated. If not defined, product attributes with
  /// set values will be updated and other attributes will stay unchanged. Only
  /// defined if the method is `update`.
  core.String? updateMask;

  ProductsCustomBatchRequestEntry({
    this.batchId,
    this.feedId,
    this.merchantId,
    this.method,
    this.product,
    this.productId,
    this.updateMask,
  });

  ProductsCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          feedId: json_.containsKey('feedId')
              ? json_['feedId'] as core.String
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
          product: json_.containsKey('product')
              ? Product.fromJson(
                  json_['product'] as core.Map<core.String, core.dynamic>)
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
          updateMask: json_.containsKey('updateMask')
              ? json_['updateMask'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (feedId != null) 'feedId': feedId!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
        if (product != null) 'product': product!,
        if (productId != null) 'productId': productId!,
        if (updateMask != null) 'updateMask': updateMask!,
      };
}

class ProductsCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<ProductsCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#productsCustomBatchResponse`".
  core.String? kind;

  ProductsCustomBatchResponse({
    this.entries,
    this.kind,
  });

  ProductsCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) => ProductsCustomBatchResponseEntry.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

/// A batch entry encoding a single non-batch products response.
class ProductsCustomBatchResponseEntry {
  /// The ID of the request entry this entry responds to.
  core.int? batchId;

  /// A list of errors for failed custombatch entries.
  ///
  /// *Note:* Schema errors fail the whole request.
  Errors? errors;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#productsCustomBatchResponseEntry`"
  core.String? kind;

  /// The inserted product.
  ///
  /// Only defined if the method is `insert` and if the request was successful.
  Product? product;

  ProductsCustomBatchResponseEntry({
    this.batchId,
    this.errors,
    this.kind,
    this.product,
  });

  ProductsCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          product: json_.containsKey('product')
              ? Product.fromJson(
                  json_['product'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (errors != null) 'errors': errors!,
        if (kind != null) 'kind': kind!,
        if (product != null) 'product': product!,
      };
}

class ProductsListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#productsListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of products.
  core.String? nextPageToken;
  core.List<Product>? resources;

  ProductsListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  ProductsListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => Product.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

class ProductstatusesCustomBatchRequest {
  /// The request entries to be processed in the batch.
  core.List<ProductstatusesCustomBatchRequestEntry>? entries;

  ProductstatusesCustomBatchRequest({
    this.entries,
  });

  ProductstatusesCustomBatchRequest.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) =>
                      ProductstatusesCustomBatchRequestEntry.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
      };
}

/// A batch entry encoding a single non-batch productstatuses request.
class ProductstatusesCustomBatchRequestEntry {
  /// An entry ID, unique within the batch request.
  core.int? batchId;

  /// If set, only issues for the specified destinations are returned, otherwise
  /// only issues for the Shopping destination.
  core.List<core.String>? destinations;

  /// Deprecated: Setting this field has no effect and attributes are never
  /// included.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.bool? includeAttributes;

  /// The ID of the managing account.
  core.String? merchantId;

  /// The method of the batch entry.
  ///
  /// Acceptable values are: - "`get`"
  core.String? method;

  /// The ID of the product whose status to get.
  core.String? productId;

  ProductstatusesCustomBatchRequestEntry({
    this.batchId,
    this.destinations,
    this.includeAttributes,
    this.merchantId,
    this.method,
    this.productId,
  });

  ProductstatusesCustomBatchRequestEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          destinations: json_.containsKey('destinations')
              ? (json_['destinations'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          includeAttributes: json_.containsKey('includeAttributes')
              ? json_['includeAttributes'] as core.bool
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          method: json_.containsKey('method')
              ? json_['method'] as core.String
              : null,
          productId: json_.containsKey('productId')
              ? json_['productId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (destinations != null) 'destinations': destinations!,
        if (includeAttributes != null) 'includeAttributes': includeAttributes!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (method != null) 'method': method!,
        if (productId != null) 'productId': productId!,
      };
}

class ProductstatusesCustomBatchResponse {
  /// The result of the execution of the batch requests.
  core.List<ProductstatusesCustomBatchResponseEntry>? entries;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#productstatusesCustomBatchResponse`".
  core.String? kind;

  ProductstatusesCustomBatchResponse({
    this.entries,
    this.kind,
  });

  ProductstatusesCustomBatchResponse.fromJson(core.Map json_)
      : this(
          entries: json_.containsKey('entries')
              ? (json_['entries'] as core.List)
                  .map((value) =>
                      ProductstatusesCustomBatchResponseEntry.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (kind != null) 'kind': kind!,
      };
}

/// A batch entry encoding a single non-batch productstatuses response.
class ProductstatusesCustomBatchResponseEntry {
  /// The ID of the request entry this entry responds to.
  core.int? batchId;

  /// A list of errors for failed custombatch entries.
  ///
  /// *Note:* Schema errors fail the whole request.
  Errors? errors;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string
  /// "`content#productstatusesCustomBatchResponseEntry`"
  core.String? kind;

  /// The requested product status.
  ///
  /// Only defined if the request was successful.
  ProductStatus? productStatus;

  ProductstatusesCustomBatchResponseEntry({
    this.batchId,
    this.errors,
    this.kind,
    this.productStatus,
  });

  ProductstatusesCustomBatchResponseEntry.fromJson(core.Map json_)
      : this(
          batchId: json_.containsKey('batchId')
              ? json_['batchId'] as core.int
              : null,
          errors: json_.containsKey('errors')
              ? Errors.fromJson(
                  json_['errors'] as core.Map<core.String, core.dynamic>)
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          productStatus: json_.containsKey('productStatus')
              ? ProductStatus.fromJson(
                  json_['productStatus'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batchId != null) 'batchId': batchId!,
        if (errors != null) 'errors': errors!,
        if (kind != null) 'kind': kind!,
        if (productStatus != null) 'productStatus': productStatus!,
      };
}

class ProductstatusesListResponse {
  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#productstatusesListResponse`".
  core.String? kind;

  /// The token for the retrieval of the next page of products statuses.
  core.String? nextPageToken;
  core.List<ProductStatus>? resources;

  ProductstatusesListResponse({
    this.kind,
    this.nextPageToken,
    this.resources,
  });

  ProductstatusesListResponse.fromJson(core.Map json_)
      : this(
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          nextPageToken: json_.containsKey('nextPageToken')
              ? json_['nextPageToken'] as core.String
              : null,
          resources: json_.containsKey('resources')
              ? (json_['resources'] as core.List)
                  .map((value) => ProductStatus.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kind != null) 'kind': kind!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (resources != null) 'resources': resources!,
      };
}

/// Represents a promotion.
///
/// See the following articles for more details. *
/// [Promotions feed specification](https://support.google.com/merchants/answer/2906014)
/// *
/// [Local promotions feed specification](https://support.google.com/merchants/answer/10146130)
/// *
/// [Promotions on Buy on Google product data specification](https://support.google.com/merchants/answer/9173673)
class Promotion {
  /// Product filter by brand for the promotion.
  core.List<core.String>? brand;

  /// Product filter by brand exclusion for the promotion.
  core.List<core.String>? brandExclusion;

  /// The content language used as part of the unique identifier.
  ///
  /// `en` content language is available for all target countries. `fr` content
  /// language is available for `CA` and `FR` target countries. `de` content
  /// language is available for `DE` target country. `nl` content language is
  /// available for `NL` target country. `it` content language is available for
  /// `IT` target country. `pt` content language is available for `BR` target
  /// country. `ja` content language is available for `JP` target country. `ko`
  /// content language is available for `KR` target country.
  ///
  /// Required.
  core.String? contentLanguage;

  /// Coupon value type for the promotion.
  ///
  /// Required.
  /// Possible string values are:
  /// - "COUPON_VALUE_TYPE_UNSPECIFIED" : Indicates that the coupon value type
  /// is unspecified.
  /// - "MONEY_OFF" : Money off coupon value type.
  /// - "PERCENT_OFF" : Percent off coupon value type.
  /// - "BUY_M_GET_N_MONEY_OFF" : Buy M quantity, get N money off coupon value
  /// type. `buy_this_quantity` and `get_this_quantity` must be present.
  /// `money_off_amount` must also be present.
  /// - "BUY_M_GET_N_PERCENT_OFF" : Buy M quantity, get N percent off coupon
  /// value type. `buy_this_quantity` and `get_this_quantity` must be present.
  /// `percent_off_percentage` must also be present.
  /// - "BUY_M_GET_MONEY_OFF" : Buy M quantity, get money off.
  /// `buy_this_quantity` and `money_off_amount` must be present.
  /// - "BUY_M_GET_PERCENT_OFF" : Buy M quantity, get money off.
  /// `buy_this_quantity` and `percent_off_percentage` must be present.
  /// - "FREE_GIFT" : Free gift with description only.
  /// - "FREE_GIFT_WITH_VALUE" : Free gift with value (description is optional).
  /// - "FREE_GIFT_WITH_ITEM_ID" : Free gift with item ID (description is
  /// optional).
  /// - "FREE_SHIPPING_STANDARD" : Standard free shipping coupon value type.
  /// - "FREE_SHIPPING_OVERNIGHT" : Overnight free shipping coupon value type.
  /// - "FREE_SHIPPING_TWO_DAY" : Two day free shipping coupon value type.
  core.String? couponValueType;

  /// Free gift description for the promotion.
  core.String? freeGiftDescription;

  /// Free gift item ID for the promotion.
  core.String? freeGiftItemId;

  /// Free gift value for the promotion.
  PriceAmount? freeGiftValue;

  /// Generic redemption code for the promotion.
  ///
  /// To be used with the `offerType` field.
  core.String? genericRedemptionCode;

  /// The number of items discounted in the promotion.
  core.int? getThisQuantityDiscounted;

  /// The REST promotion ID to uniquely identify the promotion.
  ///
  /// Content API methods that operate on promotions take this as their
  /// `promotionId` parameter. The REST ID for a promotion is of the form
  /// channel:contentLanguage:targetCountry:promotionId The `channel` field has
  /// a value of `"online"`, `"in_store"`, or `"online_in_store"`.
  ///
  /// Required. Output only.
  core.String? id;

  /// Product filter by item group ID for the promotion.
  core.List<core.String>? itemGroupId;

  /// Product filter by item group ID exclusion for the promotion.
  core.List<core.String>? itemGroupIdExclusion;

  /// Product filter by item ID for the promotion.
  core.List<core.String>? itemId;

  /// Product filter by item ID exclusion for the promotion.
  core.List<core.String>? itemIdExclusion;

  /// Maximum purchase quantity for the promotion.
  core.int? limitQuantity;

  /// Maximum purchase value for the promotion.
  PriceAmount? limitValue;

  /// Long title for the promotion.
  ///
  /// Required.
  core.String? longTitle;

  /// Minimum purchase amount for the promotion.
  PriceAmount? minimumPurchaseAmount;

  /// Minimum purchase quantity for the promotion.
  core.int? minimumPurchaseQuantity;

  /// Cost cap for the promotion.
  PriceAmount? moneyBudget;

  /// The money off amount offered in the promotion.
  PriceAmount? moneyOffAmount;

  /// Type of the promotion.
  ///
  /// Required.
  /// Possible string values are:
  /// - "OFFER_TYPE_UNSPECIFIED" : Unknown offer type.
  /// - "NO_CODE" : Offer type without a code.
  /// - "GENERIC_CODE" : Offer type with a code.
  core.String? offerType;

  /// Order limit for the promotion.
  core.int? orderLimit;

  /// The percentage discount offered in the promotion.
  core.int? percentOff;

  /// Applicability of the promotion to either all products or only specific
  /// products.
  ///
  /// Required.
  /// Possible string values are:
  /// - "PRODUCT_APPLICABILITY_UNSPECIFIED" : Which products the promotion
  /// applies to is unknown.
  /// - "ALL_PRODUCTS" : Applicable to all products.
  /// - "SPECIFIC_PRODUCTS" : Applicable to only a single product or list of
  /// products.
  core.String? productApplicability;

  /// Product filter by product type for the promotion.
  core.List<core.String>? productType;

  /// Product filter by product type exclusion for the promotion.
  core.List<core.String>? productTypeExclusion;

  /// Destination ID for the promotion.
  core.List<core.String>? promotionDestinationIds;

  /// String representation of the promotion display dates.
  ///
  /// Deprecated. Use `promotion_display_time_period` instead.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? promotionDisplayDates;

  /// `TimePeriod` representation of the promotion's display dates.
  TimePeriod? promotionDisplayTimePeriod;

  /// String representation of the promotion effective dates.
  ///
  /// Deprecated. Use `promotion_effective_time_period` instead.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? promotionEffectiveDates;

  /// `TimePeriod` representation of the promotion's effective dates.
  ///
  /// Required.
  TimePeriod? promotionEffectiveTimePeriod;

  /// The user provided promotion ID to uniquely identify the promotion.
  ///
  /// Required.
  core.String? promotionId;

  /// The current status of the promotion.
  ///
  /// Output only.
  PromotionPromotionStatus? promotionStatus;

  /// URL to the page on the merchant's site where the promotion shows.
  ///
  /// Local Inventory ads promotions throw an error if no promo url is included.
  /// URL is used to confirm that the promotion is valid and can be redeemed.
  core.String? promotionUrl;

  /// Redemption channel for the promotion.
  ///
  /// At least one channel is required.
  ///
  /// Required.
  core.List<core.String>? redemptionChannel;

  /// Shipping service names for the promotion.
  core.List<core.String>? shippingServiceNames;

  /// Whether the promotion applies to all stores, or only specified stores.
  ///
  /// Local Inventory ads promotions throw an error if no store applicability is
  /// included. An INVALID_ARGUMENT error is thrown if store_applicability is
  /// set to ALL_STORES and store_code or score_code_exclusion is set to a
  /// value.
  /// Possible string values are:
  /// - "STORE_APPLICABILITY_UNSPECIFIED" : Which store codes the promotion
  /// applies to is unknown.
  /// - "ALL_STORES" : Promotion applies to all stores.
  /// - "SPECIFIC_STORES" : Promotion applies to only the specified stores.
  core.String? storeApplicability;

  /// Store codes to include for the promotion.
  core.List<core.String>? storeCode;

  /// Store codes to exclude for the promotion.
  core.List<core.String>? storeCodeExclusion;

  /// The target country used as part of the unique identifier.
  ///
  /// Can be `AU`, `CA`, `DE`, `FR`, `GB`, `IN`, `US`, `BR`, `ES`, `NL`, `JP`,
  /// `IT` or `KR`.
  ///
  /// Required.
  core.String? targetCountry;

  Promotion({
    this.brand,
    this.brandExclusion,
    this.contentLanguage,
    this.couponValueType,
    this.freeGiftDescription,
    this.freeGiftItemId,
    this.freeGiftValue,
    this.genericRedemptionCode,
    this.getThisQuantityDiscounted,
    this.id,
    this.itemGroupId,
    this.itemGroupIdExclusion,
    this.itemId,
    this.itemIdExclusion,
    this.limitQuantity,
    this.limitValue,
    this.longTitle,
    this.minimumPurchaseAmount,
    this.minimumPurchaseQuantity,
    this.moneyBudget,
    this.moneyOffAmount,
    this.offerType,
    this.orderLimit,
    this.percentOff,
    this.productApplicability,
    this.productType,
    this.productTypeExclusion,
    this.promotionDestinationIds,
    this.promotionDisplayDates,
    this.promotionDisplayTimePeriod,
    this.promotionEffectiveDates,
    this.promotionEffectiveTimePeriod,
    this.promotionId,
    this.promotionStatus,
    this.promotionUrl,
    this.redemptionChannel,
    this.shippingServiceNames,
    this.storeApplicability,
    this.storeCode,
    this.storeCodeExclusion,
    this.targetCountry,
  });

  Promotion.fromJson(core.Map json_)
      : this(
          brand: json_.containsKey('brand')
              ? (json_['brand'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          brandExclusion: json_.containsKey('brandExclusion')
              ? (json_['brandExclusion'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          contentLanguage: json_.containsKey('contentLanguage')
              ? json_['contentLanguage'] as core.String
              : null,
          couponValueType: json_.containsKey('couponValueType')
              ? json_['couponValueType'] as core.String
              : null,
          freeGiftDescription: json_.containsKey('freeGiftDescription')
              ? json_['freeGiftDescription'] as core.String
              : null,
          freeGiftItemId: json_.containsKey('freeGiftItemId')
              ? json_['freeGiftItemId'] as core.String
              : null,
          freeGiftValue: json_.containsKey('freeGiftValue')
              ? PriceAmount.fromJson(
                  json_['freeGiftValue'] as core.Map<core.String, core.dynamic>)
              : null,
          genericRedemptionCode: json_.containsKey('genericRedemptionCode')
              ? json_['genericRedemptionCode'] as core.String
              : null,
          getThisQuantityDiscounted:
              json_.containsKey('getThisQuantityDiscounted')
                  ? json_['getThisQuantityDiscounted'] as core.int
                  : null,
          id: json_.containsKey('id') ? json_['id'] as core.String : null,
          itemGroupId: json_.containsKey('itemGroupId')
              ? (json_['itemGroupId'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          itemGroupIdExclusion: json_.containsKey('itemGroupIdExclusion')
              ? (json_['itemGroupIdExclusion'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          itemId: json_.containsKey('itemId')
              ? (json_['itemId'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          itemIdExclusion: json_.containsKey('itemIdExclusion')
              ? (json_['itemIdExclusion'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          limitQuantity: json_.containsKey('limitQuantity')
              ? json_['limitQuantity'] as core.int
              : null,
          limitValue: json_.containsKey('limitValue')
              ? PriceAmount.fromJson(
                  json_['limitValue'] as core.Map<core.String, core.dynamic>)
              : null,
          longTitle: json_.containsKey('longTitle')
              ? json_['longTitle'] as core.String
              : null,
          minimumPurchaseAmount: json_.containsKey('minimumPurchaseAmount')
              ? PriceAmount.fromJson(json_['minimumPurchaseAmount']
                  as core.Map<core.String, core.dynamic>)
              : null,
          minimumPurchaseQuantity: json_.containsKey('minimumPurchaseQuantity')
              ? json_['minimumPurchaseQuantity'] as core.int
              : null,
          moneyBudget: json_.containsKey('moneyBudget')
              ? PriceAmount.fromJson(
                  json_['moneyBudget'] as core.Map<core.String, core.dynamic>)
              : null,
          moneyOffAmount: json_.containsKey('moneyOffAmount')
              ? PriceAmount.fromJson(json_['moneyOffAmount']
                  as core.Map<core.String, core.dynamic>)
              : null,
          offerType: json_.containsKey('offerType')
              ? json_['offerType'] as core.String
              : null,
          orderLimit: json_.containsKey('orderLimit')
              ? json_['orderLimit'] as core.int
              : null,
          percentOff: json_.containsKey('percentOff')
              ? json_['percentOff'] as core.int
              : null,
          productApplicability: json_.containsKey('productApplicability')
              ? json_['productApplicability'] as core.String
              : null,
          productType: json_.containsKey('productType')
              ? (json_['productType'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          productTypeExclusion: json_.containsKey('productTypeExclusion')
              ? (json_['productTypeExclusion'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          promotionDestinationIds: json_.containsKey('promotionDestinationIds')
              ? (json_['promotionDestinationIds'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          promotionDisplayDates: json_.containsKey('promotionDisplayDates')
              ? json_['promotionDisplayDates'] as core.String
              : null,
          promotionDisplayTimePeriod:
              json_.containsKey('promotionDisplayTimePeriod')
                  ? TimePeriod.fromJson(json_['promotionDisplayTimePeriod']
                      as core.Map<core.String, core.dynamic>)
                  : null,
          promotionEffectiveDates: json_.containsKey('promotionEffectiveDates')
              ? json_['promotionEffectiveDates'] as core.String
              : null,
          promotionEffectiveTimePeriod:
              json_.containsKey('promotionEffectiveTimePeriod')
                  ? TimePeriod.fromJson(json_['promotionEffectiveTimePeriod']
                      as core.Map<core.String, core.dynamic>)
                  : null,
          promotionId: json_.containsKey('promotionId')
              ? json_['promotionId'] as core.String
              : null,
          promotionStatus: json_.containsKey('promotionStatus')
              ? PromotionPromotionStatus.fromJson(json_['promotionStatus']
                  as core.Map<core.String, core.dynamic>)
              : null,
          promotionUrl: json_.containsKey('promotionUrl')
              ? json_['promotionUrl'] as core.String
              : null,
          redemptionChannel: json_.containsKey('redemptionChannel')
              ? (json_['redemptionChannel'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          shippingServiceNames: json_.containsKey('shippingServiceNames')
              ? (json_['shippingServiceNames'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          storeApplicability: json_.containsKey('storeApplicability')
              ? json_['storeApplicability'] as core.String
              : null,
          storeCode: json_.containsKey('storeCode')
              ? (json_['storeCode'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          storeCodeExclusion: json_.containsKey('storeCodeExclusion')
              ? (json_['storeCodeExclusion'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          targetCountry: json_.containsKey('targetCountry')
              ? json_['targetCountry'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (brand != null) 'brand': brand!,
        if (brandExclusion != null) 'brandExclusion': brandExclusion!,
        if (contentLanguage != null) 'contentLanguage': contentLanguage!,
        if (couponValueType != null) 'couponValueType': couponValueType!,
        if (freeGiftDescription != null)
          'freeGiftDescription': freeGiftDescription!,
        if (freeGiftItemId != null) 'freeGiftItemId': freeGiftItemId!,
        if (freeGiftValue != null) 'freeGiftValue': freeGiftValue!,
        if (genericRedemptionCode != null)
          'genericRedemptionCode': genericRedemptionCode!,
        if (getThisQuantityDiscounted != null)
          'getThisQuantityDiscounted': getThisQuantityDiscounted!,
        if (id != null) 'id': id!,
        if (itemGroupId != null) 'itemGroupId': itemGroupId!,
        if (itemGroupIdExclusion != null)
          'itemGroupIdExclusion': itemGroupIdExclusion!,
        if (itemId != null) 'itemId': itemId!,
        if (itemIdExclusion != null) 'itemIdExclusion': itemIdExclusion!,
        if (limitQuantity != null) 'limitQuantity': limitQuantity!,
        if (limitValue != null) 'limitValue': limitValue!,
        if (longTitle != null) 'longTitle': longTitle!,
        if (minimumPurchaseAmount != null)
          'minimumPurchaseAmount': minimumPurchaseAmount!,
        if (minimumPurchaseQuantity != null)
          'minimumPurchaseQuantity': minimumPurchaseQuantity!,
        if (moneyBudget != null) 'moneyBudget': moneyBudget!,
        if (moneyOffAmount != null) 'moneyOffAmount': moneyOffAmount!,
        if (offerType != null) 'offerType': offerType!,
        if (orderLimit != null) 'orderLimit': orderLimit!,
        if (percentOff != null) 'percentOff': percentOff!,
        if (productApplicability != null)
          'productApplicability': productApplicability!,
        if (productType != null) 'productType': productType!,
        if (productTypeExclusion != null)
          'productTypeExclusion': productTypeExclusion!,
        if (promotionDestinationIds != null)
          'promotionDestinationIds': promotionDestinationIds!,
        if (promotionDisplayDates != null)
          'promotionDisplayDates': promotionDisplayDates!,
        if (promotionDisplayTimePeriod != null)
          'promotionDisplayTimePeriod': promotionDisplayTimePeriod!,
        if (promotionEffectiveDates != null)
          'promotionEffectiveDates': promotionEffectiveDates!,
        if (promotionEffectiveTimePeriod != null)
          'promotionEffectiveTimePeriod': promotionEffectiveTimePeriod!,
        if (promotionId != null) 'promotionId': promotionId!,
        if (promotionStatus != null) 'promotionStatus': promotionStatus!,
        if (promotionUrl != null) 'promotionUrl': promotionUrl!,
        if (redemptionChannel != null) 'redemptionChannel': redemptionChannel!,
        if (shippingServiceNames != null)
          'shippingServiceNames': shippingServiceNames!,
        if (storeApplicability != null)
          'storeApplicability': storeApplicability!,
        if (storeCode != null) 'storeCode': storeCode!,
        if (storeCodeExclusion != null)
          'storeCodeExclusion': storeCodeExclusion!,
        if (targetCountry != null) 'targetCountry': targetCountry!,
      };
}

/// The status of the promotion.
class PromotionPromotionStatus {
  /// Date on which the promotion has been created in
  /// [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and
  /// offset, for example "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
  core.String? creationDate;

  /// The intended destinations for the promotion.
  core.List<PromotionPromotionStatusDestinationStatus>? destinationStatuses;

  /// Date on which the promotion status has been last updated in
  /// [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and
  /// offset, for example "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
  core.String? lastUpdateDate;

  /// A list of issues associated with the promotion.
  core.List<PromotionPromotionStatusPromotionIssue>? promotionIssue;

  PromotionPromotionStatus({
    this.creationDate,
    this.destinationStatuses,
    this.lastUpdateDate,
    this.promotionIssue,
  });

  PromotionPromotionStatus.fromJson(core.Map json_)
      : this(
          creationDate: json_.containsKey('creationDate')
              ? json_['creationDate'] as core.String
              : null,
          destinationStatuses: json_.containsKey('destinationStatuses')
              ? (json_['destinationStatuses'] as core.List)
                  .map((value) =>
                      PromotionPromotionStatusDestinationStatus.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          lastUpdateDate: json_.containsKey('lastUpdateDate')
              ? json_['lastUpdateDate'] as core.String
              : null,
          promotionIssue: json_.containsKey('promotionIssue')
              ? (json_['promotionIssue'] as core.List)
                  .map((value) =>
                      PromotionPromotionStatusPromotionIssue.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (creationDate != null) 'creationDate': creationDate!,
        if (destinationStatuses != null)
          'destinationStatuses': destinationStatuses!,
        if (lastUpdateDate != null) 'lastUpdateDate': lastUpdateDate!,
        if (promotionIssue != null) 'promotionIssue': promotionIssue!,
      };
}

/// The destination status of the promotion.
class PromotionPromotionStatusDestinationStatus {
  /// The name of the destination.
  core.String? destination;

  /// The status for the specified destination.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : Unknown promotion state.
  /// - "IN_REVIEW" : The promotion is under review.
  /// - "REJECTED" : The promotion is disapproved
  /// - "LIVE" : The promotion is approved and active.
  /// - "STOPPED" : The promotion is stopped by merchant.
  /// - "EXPIRED" : The promotion is no longer active.
  /// - "PENDING" : The promotion is not stopped, and all reviews are approved,
  /// but the active date is in the future.
  core.String? status;

  PromotionPromotionStatusDestinationStatus({
    this.destination,
    this.status,
  });

  PromotionPromotionStatusDestinationStatus.fromJson(core.Map json_)
      : this(
          destination: json_.containsKey('destination')
              ? json_['destination'] as core.String
              : null,
          status: json_.containsKey('status')
              ? json_['status'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (destination != null) 'destination': destination!,
        if (status != null) 'status': status!,
      };
}

/// The issue associated with the promotion.
class PromotionPromotionStatusPromotionIssue {
  /// Code of the issue.
  core.String? code;

  /// Explanation of the issue.
  core.String? detail;

  PromotionPromotionStatusPromotionIssue({
    this.code,
    this.detail,
  });

  PromotionPromotionStatusPromotionIssue.fromJson(core.Map json_)
      : this(
          code: json_.containsKey('code') ? json_['code'] as core.String : null,
          detail: json_.containsKey('detail')
              ? json_['detail'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (code != null) 'code': code!,
        if (detail != null) 'detail': detail!,
      };
}

/// Settings for Pub/Sub notifications, all methods require that the caller is a
/// direct user of the merchant center account.
class PubsubNotificationSettings {
  /// Cloud pub/sub topic to which notifications are sent (read-only).
  core.String? cloudTopicName;

  /// Identifies what kind of resource this is.
  ///
  /// Value: the fixed string "`content#pubsubNotificationSettings`"
  core.String? kind;

  /// List of event types.
  ///
  /// Acceptable values are: - "`orderPendingShipment`"
  core.List<core.String>? registeredEvents;

  PubsubNotificationSettings({
    this.cloudTopicName,
    this.kind,
    this.registeredEvents,
  });

  PubsubNotificationSettings.fromJson(core.Map json_)
      : this(
          cloudTopicName: json_.containsKey('cloudTopicName')
              ? json_['cloudTopicName'] as core.String
              : null,
          kind: json_.containsKey('kind') ? json_['kind'] as core.String : null,
          registeredEvents: json_.containsKey('registeredEvents')
              ? (json_['registeredEvents'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (cloudTopicName != null) 'cloudTopicName': cloudTopicName!,
        if (kind != null) 'kind': kind!,
        if (registeredEvents != null) 'registeredEvents': registeredEvents!,
      };
}

class RateGroup {
  /// A list of shipping labels defining the products to which this rate group
  /// applies to.
  ///
  /// This is a disjunction: only one of the labels has to match for the rate
  /// group to apply. May only be empty for the last rate group of a service.
  /// Required.
  core.List<core.String>? applicableShippingLabels;

  /// A list of carrier rates that can be referred to by `mainTable` or
  /// `singleValue`.
  core.List<CarrierRate>? carrierRates;

  /// A table defining the rate group, when `singleValue` is not expressive
  /// enough.
  ///
  /// Can only be set if `singleValue` is not set.
  Table? mainTable;

  /// Name of the rate group.
  ///
  /// Optional. If set has to be unique within shipping service.
  core.String? name;

  /// The value of the rate group (for example, flat rate $10).
  ///
  /// Can only be set if `mainTable` and `subtables` are not set.
  Value? singleValue;

  /// A list of subtables referred to by `mainTable`.
  ///
  /// Can only be set if `mainTable` is set.
  core.List<Table>? subtables;

  RateGroup({
    this.applicableShippingLabels,
    this.carrierRates,
    this.mainTable,
    this.name,
    this.singleValue,
    this.subtables,
  });

  RateGroup.fromJson(core.Map json_)
      : this(
          applicableShippingLabels:
              json_.containsKey('applicableShippingLabels')
                  ? (json_['applicableShippingLabels'] as core.List)
                      .map((value) => value as core.String)
                      .toList()
                  : null,
          carrierRates: json_.containsKey('carrierRates')
              ? (json_['carrierRates'] as core.List)
                  .map((value) => CarrierRate.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          mainTable: json_.containsKey('mainTable')
              ? Table.fromJson(
                  json_['mainTable'] as core.Map<core.String, core.dynamic>)
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          singleValue: json_.containsKey('singleValue')
              ? Value.fromJson(
                  json_['singleValue'] as core.Map<core.String, core.dynamic>)
              : null,
          subtables: json_.containsKey('subtables')
              ? (json_['subtables'] as core.List)
                  .map((value) => Table.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (applicableShippingLabels != null)
          'applicableShippingLabels': applicableShippingLabels!,
        if (carrierRates != null) 'carrierRates': carrierRates!,
        if (mainTable != null) 'mainTable': mainTable!,
        if (name != null) 'name': name!,
        if (singleValue != null) 'singleValue': singleValue!,
        if (subtables != null) 'subtables': subtables!,
      };
}

/// Recommendations are suggested ways to improve your merchant account's
/// performance.
///
/// For example, to engage with a feature, or start using a new Google product.
class Recommendation {
  /// CTAs of this recommendation.
  ///
  /// Repeated.
  ///
  /// Output only.
  core.List<RecommendationCallToAction>? additionalCallToAction;

  /// List of additional localized descriptions for a recommendation.
  ///
  /// Localication uses the `languageCode` field in `GenerateRecommendations`
  /// requests. Not all description types are guaranteed to be present and we
  /// recommend to rely on default description.
  ///
  /// Output only.
  core.List<RecommendationDescription>? additionalDescriptions;

  /// Any creatives attached to the recommendation.
  ///
  /// Repeated.
  ///
  /// Output only.
  core.List<RecommendationCreative>? creative;

  /// Default CTA of the recommendation.
  ///
  /// Optional.
  RecommendationCallToAction? defaultCallToAction;

  /// Localized recommendation description.
  ///
  /// The localization the {@link
  /// `GenerateRecommendationsRequest.language_code`} field in {@link
  /// `GenerateRecommendationsRequest`} requests.
  ///
  /// Optional.
  core.String? defaultDescription;

  /// A numerical score of the impact from the recommendation's description.
  ///
  /// For example, a recommendation might suggest an upward trend in sales for a
  /// certain product. Higher number means larger impact.
  ///
  /// Optional.
  core.int? numericalImpact;

  /// Indicates whether a user needs to pay when they complete the user journey
  /// suggested by the recommendation.
  ///
  /// Optional.
  core.bool? paid;

  /// Localized recommendation name.
  ///
  /// The localization uses the {@link
  /// `GenerateRecommendationsRequest.language_code`} field in {@link
  /// `GenerateRecommendationsRequest`} requests.
  ///
  /// Optional.
  core.String? recommendationName;

  /// Subtype of the recommendations.
  ///
  /// Only applicable when multiple recommendations can be generated per type,
  /// and is used as an identifier of recommendation under the same
  /// recommendation type.
  ///
  /// Optional.
  core.String? subType;

  /// Localized Recommendation Title.
  ///
  /// Localization uses the {@link
  /// `GenerateRecommendationsRequest.language_code`} field in {@link
  /// `GenerateRecommendationsRequest`} requests.
  ///
  /// Optional.
  core.String? title;

  /// Type of the recommendation.
  ///
  /// List of currently available recommendation types: -
  /// OPPORTUNITY_CREATE_NEW_COLLECTION - OPPORTUNITY_CREATE_EMAIL_CAMPAIGN
  ///
  /// Output only.
  core.String? type;

  Recommendation({
    this.additionalCallToAction,
    this.additionalDescriptions,
    this.creative,
    this.defaultCallToAction,
    this.defaultDescription,
    this.numericalImpact,
    this.paid,
    this.recommendationName,
    this.subType,
    this.title,
    this.type,
  });

  Recommendation.fromJson(core.Map json_)
      : this(
          additionalCallToAction: json_.containsKey('additionalCallToAction')
              ? (json_['additionalCallToAction'] as core.List)
                  .map((value) => RecommendationCallToAction.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          additionalDescriptions: json_.containsKey('additionalDescriptions')
              ? (json_['additionalDescriptions'] as core.List)
                  .map((value) => RecommendationDescription.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          creative: json_.containsKey('creative')
              ? (json_['creative'] as core.List)
                  .map((value) => RecommendationCreative.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          defaultCallToAction: json_.containsKey('defaultCallToAction')
              ? RecommendationCallToAction.fromJson(json_['defaultCallToAction']
                  as core.Map<core.String, core.dynamic>)
              : null,
          defaultDescription: json_.containsKey('defaultDescription')
              ? json_['defaultDescription'] as core.String
              : null,
          numericalImpact: json_.containsKey('numericalImpact')
              ? json_['numericalImpact'] as core.int
              : null,
          paid: json_.containsKey('paid') ? json_['paid'] as core.bool : null,
          recommendationName: json_.containsKey('recommendationName')
              ? json_['recommendationName'] as core.String
              : null,
          subType: json_.containsKey('subType')
              ? json_['subType'] as core.String
              : null,
          title:
              json_.containsKey('title') ? json_['title'] as core.String : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (additionalCallToAction != null)
          'additionalCallToAction': additionalCallToAction!,
        if (additionalDescriptions != null)
          'additionalDescriptions': additionalDescriptions!,
        if (creative != null) 'creative': creative!,
        if (defaultCallToAction != null)
          'defaultCallToAction': defaultCallToAction!,
        if (defaultDescription != null)
          'defaultDescription': defaultDescription!,
        if (numericalImpact != null) 'numericalImpact': numericalImpact!,
        if (paid != null) 'paid': paid!,
        if (recommendationName != null)
          'recommendationName': recommendationName!,
        if (subType != null) 'subType': subType!,
        if (title != null) 'title': title!,
        if (type != null) 'type': type!,
      };
}

/// Call to action (CTA) that explains how a merchant can implement this
/// recommendation
class RecommendationCallToAction {
  /// Intent of the action.
  ///
  /// This value describes the intent (for example,
  /// `OPEN_CREATE_EMAIL_CAMPAIGN_FLOW`) and can vary from recommendation to
  /// recommendation. This value can change over time for the same
  /// recommendation. Currently available intent values: -
  /// OPEN_CREATE_EMAIL_CAMPAIGN_FLOW: Opens a user journey where they can
  /// create a marketing email campaign. (No default URL) -
  /// OPEN_CREATE_COLLECTION_TAB: Opens a user journey where they can
  /// [create a collection](https://support.google.com/merchants/answer/9703228)
  /// for their Merchant account. (No default URL)
  ///
  /// Output only.
  core.String? intent;

  /// Localized text of the CTA.
  ///
  /// Optional.
  ///
  /// Output only.
  core.String? localizedText;

  /// URL of the CTA.
  ///
  /// This field will only be set for some recommendations where there is a
  /// suggested landing URL. Otherwise it will be set to an empty string. We
  /// recommend developers to use their own custom landing page according to the
  /// description of the intent field above when this uri field is empty.
  ///
  /// Optional.
  core.String? uri;

  RecommendationCallToAction({
    this.intent,
    this.localizedText,
    this.uri,
  });

  RecommendationCallToAction.fromJson(core.Map json_)
      : this(
          intent: json_.containsKey('intent')
              ? json_['intent'] as core.String
              : null,
          localizedText: json_.containsKey('localizedText')
              ? json_['localizedText'] as core.String
              : null,
          uri: json_.containsKey('uri') ? json_['uri'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (intent != null) 'intent': intent!,
        if (localizedText != null) 'localizedText': localizedText!,
        if (uri != null) 'uri': uri!,
      };
}

/// Creative is a multimedia attachment to recommendation that can be used on
/// the frontend.
class RecommendationCreative {
  /// Type of the creative.
  /// Possible string values are:
  /// - "CREATIVE_TYPE_UNSPECIFIED" : Default value. If provided, shall be
  /// considered invalid.
  /// - "VIDEO" : Video creatives.
  /// - "PHOTO" : Photo creatives.
  core.String? type;

  /// URL of the creative.
  core.String? uri;

  RecommendationCreative({
    this.type,
    this.uri,
  });

  RecommendationCreative.fromJson(core.Map json_)
      : this(
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
          uri: json_.containsKey('uri') ? json_['uri'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (type != null) 'type': type!,
        if (uri != null) 'uri': uri!,
      };
}

/// Google-provided description for the recommendation.
class RecommendationDescription {
  /// Text of the description.
  ///
  /// Output only.
  core.String? text;

  /// Type of the description.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "DESCRIPTION_TYPE_UNSPECIFIED" : Default value. Will never be provided
  /// by the API.
  /// - "SHORT" : Short description.
  /// - "LONG" : Long description.
  core.String? type;

  RecommendationDescription({
    this.text,
    this.type,
  });

  RecommendationDescription.fromJson(core.Map json_)
      : this(
          text: json_.containsKey('text') ? json_['text'] as core.String : null,
          type: json_.containsKey('type') ? json_['type'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (text != null) 'text': text!,
        if (type != null) 'type': type!,
      };
}

class RefundReason {
  /// Description of the reason.
  core.String? description;

  /// Code of the refund reason.
  ///
  /// Acceptable values are: - "`adjustment`" - "`autoPostInternal`" -
  /// "`autoPostInvalidBillingAddress`" - "`autoPostNoInventory`" -
  /// "`autoPostPriceError`" - "`autoPostUndeliverableShippingAddress`" -
  /// "`couponAbuse`" - "`courtesyAdjustment`" - "`customerCanceled`" -
  /// "`customerDiscretionaryReturn`" - "`customerInitiatedMerchantCancel`" -
  /// "`customerSupportRequested`" - "`deliveredLateByCarrier`" -
  /// "`deliveredTooLate`" - "`expiredItem`" - "`failToPushOrderGoogleError`" -
  /// "`failToPushOrderMerchantError`" -
  /// "`failToPushOrderMerchantFulfillmentError`" -
  /// "`failToPushOrderToMerchant`" - "`failToPushOrderToMerchantOutOfStock`" -
  /// "`feeAdjustment`" - "`invalidCoupon`" - "`lateShipmentCredit`" -
  /// "`malformedShippingAddress`" - "`merchantDidNotShipOnTime`" -
  /// "`noInventory`" - "`orderTimeout`" - "`other`" - "`paymentAbuse`" -
  /// "`paymentDeclined`" - "`priceAdjustment`" - "`priceError`" -
  /// "`productArrivedDamaged`" - "`productNotAsDescribed`" -
  /// "`promoReallocation`" - "`qualityNotAsExpected`" - "`returnRefundAbuse`" -
  /// "`shippingCostAdjustment`" - "`shippingPriceError`" - "`taxAdjustment`" -
  /// "`taxError`" - "`undeliverableShippingAddress`" -
  /// "`unsupportedPoBoxAddress`" - "`wrongProductShipped`"
  core.String? reasonCode;

  RefundReason({
    this.description,
    this.reasonCode,
  });

  RefundReason.fromJson(core.Map json_)
      : this(
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          reasonCode: json_.containsKey('reasonCode')
              ? json_['reasonCode'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (description != null) 'description': description!,
        if (reasonCode != null) 'reasonCode': reasonCode!,
      };
}

/// Represents a geographic region that you can use as a target with both the
/// `RegionalInventory` and `ShippingSettings` services.
///
/// You can define regions as collections of either postal codes or, in some
/// countries, using predefined geotargets.
class Region {
  /// The display name of the region.
  core.String? displayName;

  /// A list of geotargets that defines the region area.
  RegionGeoTargetArea? geotargetArea;

  /// Merchant that owns the region.
  ///
  /// Output only. Immutable.
  core.String? merchantId;

  /// A list of postal codes that defines the region area.
  RegionPostalCodeArea? postalCodeArea;

  /// The ID uniquely identifying each region.
  ///
  /// Output only. Immutable.
  core.String? regionId;

  /// Indicates if the region is eligible to use in the Regional Inventory
  /// configuration.
  ///
  /// Output only.
  core.bool? regionalInventoryEligible;

  /// Indicates if the region is eligible to use in the Shipping Services
  /// configuration.
  ///
  /// Output only.
  core.bool? shippingEligible;

  Region({
    this.displayName,
    this.geotargetArea,
    this.merchantId,
    this.postalCodeArea,
    this.regionId,
    this.regionalInventoryEligible,
    this.shippingEligible,
  });

  Region.fromJson(core.Map json_)
      : this(
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          geotargetArea: json_.containsKey('geotargetArea')
              ? RegionGeoTargetArea.fromJson(
                  json_['geotargetArea'] as core.Map<core.String, core.dynamic>)
              : null,
          merchantId: json_.containsKey('merchantId')
              ? json_['merchantId'] as core.String
              : null,
          postalCodeArea: json_.containsKey('postalCodeArea')
              ? RegionPostalCodeArea.fromJson(json_['postalCodeArea']
                  as core.Map<core.String, core.dynamic>)
              : null,
          regionId: json_.containsKey('regionId')
              ? json_['regionId'] as core.String
              : null,
          regionalInventoryEligible:
              json_.containsKey('regionalInventoryEligible')
                  ? json_['regionalInventoryEligible'] as core.bool
                  : null,
          shippingEligible: json_.containsKey('shippingEligible')
              ? json_['shippingEligible'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (displayName != null) 'displayName': displayName!,
        if (geotargetArea != null) 'geotargetArea': geotargetArea!,
        if (merchantId != null) 'merchantId': merchantId!,
        if (postalCodeArea != null) 'postalCodeArea': postalCodeArea!,
        if (regionId != null) 'regionId': regionId!,
        if (regionalInventoryEligible != null)
          'regionalInventoryEligible': regionalInventoryEligible!,
        if (shippingEligible != null) 'shippingEligible': shippingEligible!,
      };
}

/// A list of geotargets that defines the region area.
class RegionGeoTargetArea {
  /// A non-empty list of
  /// [location IDs](https://developers.google.com/adwords/api/docs/appendix/geotargeting).
  ///
  /// They must all be of the same loc