/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.loader;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.loader.ApplicationInfoLoader;
import io.flutter.embedding.engine.loader.FlutterApplicationInfo;
import io.flutter.embedding.engine.loader.ResourceExtractor;
import io.flutter.util.HandlerCompat;
import io.flutter.util.PathUtils;
import io.flutter.util.TraceSection;
import io.flutter.view.VsyncWaiter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class FlutterLoader {
    private static final String TAG = "FlutterLoader";
    private static final String OLD_GEN_HEAP_SIZE_META_DATA_KEY = "io.flutter.embedding.android.OldGenHeapSize";
    private static final String ENABLE_IMPELLER_META_DATA_KEY = "io.flutter.embedding.android.EnableImpeller";
    private static final String ENABLE_VULKAN_VALIDATION_META_DATA_KEY = "io.flutter.embedding.android.EnableVulkanValidation";
    private static final String IMPELLER_BACKEND_META_DATA_KEY = "io.flutter.embedding.android.ImpellerBackend";
    private static final String IMPELLER_OPENGL_GPU_TRACING_DATA_KEY = "io.flutter.embedding.android.EnableOpenGLGPUTracing";
    private static final String IMPELLER_VULKAN_GPU_TRACING_DATA_KEY = "io.flutter.embedding.android.EnableVulkanGPUTracing";
    private static final String DISABLE_MERGED_PLATFORM_UI_THREAD_KEY = "io.flutter.embedding.android.DisableMergedPlatformUIThread";
    private static final String ENABLE_SURFACE_CONTROL = "io.flutter.embedding.android.EnableSurfaceControl";
    private static final String ENABLE_FLUTTER_GPU = "io.flutter.embedding.android.EnableFlutterGPU";
    private static final String IMPELLER_LAZY_SHADER_MODE = "io.flutter.embedding.android.ImpellerLazyShaderInitialization";
    private static final String IMPELLER_ANTIALIAS_LINES = "io.flutter.embedding.android.ImpellerAntialiasLines";
    private static final String LEAK_VM_META_DATA_KEY = "io.flutter.embedding.android.LeakVM";
    static final String AOT_SHARED_LIBRARY_NAME = "aot-shared-library-name";
    static final String AOT_VMSERVICE_SHARED_LIBRARY_NAME = "aot-vmservice-shared-library-name";
    static final String SNAPSHOT_ASSET_PATH_KEY = "snapshot-asset-path";
    static final String VM_SNAPSHOT_DATA_KEY = "vm-snapshot-data";
    static final String ISOLATE_SNAPSHOT_DATA_KEY = "isolate-snapshot-data";
    static final String FLUTTER_ASSETS_DIR_KEY = "flutter-assets-dir";
    static final String AUTOMATICALLY_REGISTER_PLUGINS_KEY = "automatically-register-plugins";
    private static final String DEFAULT_LIBRARY = "libflutter.so";
    private static final String DEFAULT_KERNEL_BLOB = "kernel_blob.bin";
    private static final String VMSERVICE_SNAPSHOT_LIBRARY = "libvmservice_snapshot.so";
    private static FlutterLoader instance;
    @VisibleForTesting
    static final String aotSharedLibraryNameFlag = "--aot-shared-library-name=";
    @VisibleForTesting
    boolean initialized = false;
    @Nullable
    private Settings settings;
    private long initStartTimestampMillis;
    private FlutterApplicationInfo flutterApplicationInfo;
    private FlutterJNI flutterJNI;
    private ExecutorService executorService;
    @Nullable
    Future<InitResult> initResultFuture;

    public FlutterLoader() {
        this(FlutterInjector.instance().getFlutterJNIFactory().provideFlutterJNI());
    }

    public FlutterLoader(@NonNull FlutterJNI flutterJNI) {
        this(flutterJNI, FlutterInjector.instance().executorService());
    }

    public FlutterLoader(@NonNull FlutterJNI flutterJNI, @NonNull ExecutorService executorService) {
        this.flutterJNI = flutterJNI;
        this.executorService = executorService;
    }

    public void startInitialization(@NonNull Context applicationContext) {
        this.startInitialization(applicationContext, new Settings());
    }

    public void startInitialization(@NonNull Context applicationContext, @NonNull Settings settings) {
        if (this.settings != null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("startInitialization must be called on the main thread");
        }
        try (TraceSection e = TraceSection.scoped("FlutterLoader#startInitialization");){
            final Context appContext = applicationContext.getApplicationContext();
            this.settings = settings;
            this.initStartTimestampMillis = SystemClock.uptimeMillis();
            this.flutterApplicationInfo = ApplicationInfoLoader.load(appContext);
            DisplayManager dm = (DisplayManager)appContext.getSystemService("display");
            VsyncWaiter waiter = VsyncWaiter.getInstance(dm, this.flutterJNI);
            waiter.init();
            Callable<InitResult> initTask = new Callable<InitResult>(){

                @Override
                public InitResult call() {
                    try (TraceSection e = TraceSection.scoped("FlutterLoader initTask");){
                        ResourceExtractor resourceExtractor = FlutterLoader.this.initResources(appContext);
                        try {
                            FlutterLoader.this.flutterJNI.loadLibrary(appContext);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            String couldntFindVersion = "couldn't find \"libflutter.so\"";
                            String notFoundVersion = "dlopen failed: library \"libflutter.so\" not found";
                            if (unsatisfiedLinkError.toString().contains(couldntFindVersion) || unsatisfiedLinkError.toString().contains(notFoundVersion)) {
                                String[] abis;
                                String cpuArch = System.getProperty("os.arch");
                                File nativeLibsDir = FlutterLoader.this.getFileFromPath(((FlutterLoader)FlutterLoader.this).flutterApplicationInfo.nativeLibraryDir);
                                Object[] nativeLibsContents = nativeLibsDir.list();
                                ArrayList splitAndSourceDirs = new ArrayList();
                                for (String abi : abis = Build.SUPPORTED_ABIS) {
                                    String baseApkPath;
                                    String libPathSuffix = "!" + File.separator + "lib" + File.separator + abi;
                                    String[] splitSourceDirs = appContext.getApplicationInfo().splitSourceDirs;
                                    ArrayList<String> splitLibPaths = new ArrayList<String>();
                                    if (splitSourceDirs != null) {
                                        for (String splitSourceDir : splitSourceDirs) {
                                            splitLibPaths.add(splitSourceDir + libPathSuffix);
                                        }
                                        splitAndSourceDirs.addAll(splitLibPaths);
                                    }
                                    if ((baseApkPath = appContext.getApplicationInfo().sourceDir) == null || baseApkPath.isEmpty()) continue;
                                    String baseApkLibDir = baseApkPath + libPathSuffix;
                                    splitAndSourceDirs.add(baseApkLibDir);
                                }
                                throw new UnsupportedOperationException("Could not load libflutter.so this is possibly because the application is running on an architecture that Flutter Android does not support (e.g. x86) see https://docs.flutter.dev/deployment/android#what-are-the-supported-target-architectures for more detail.\nApp is using cpu architecture: " + cpuArch + ", and the native libraries directory (with path " + nativeLibsDir.getAbsolutePath() + ") " + (nativeLibsDir.exists() ? "contains the following files: " + Arrays.toString(nativeLibsContents) : "does not exist") + (splitAndSourceDirs.isEmpty() ? "" : ", and the split and source libraries directory (with path(s) " + splitAndSourceDirs + ")") + ".", unsatisfiedLinkError);
                            }
                            throw unsatisfiedLinkError;
                        }
                        FlutterLoader.this.flutterJNI.updateRefreshRate();
                        FlutterLoader.this.executorService.execute(() -> FlutterLoader.this.flutterJNI.prefetchDefaultFontManager());
                        if (resourceExtractor != null) {
                            resourceExtractor.waitForCompletion();
                        }
                        InitResult initResult = new InitResult(PathUtils.getFilesDir(appContext), PathUtils.getCacheDirectory(appContext), PathUtils.getDataDirectory(appContext));
                        return initResult;
                    }
                }
            };
            this.initResultFuture = this.executorService.submit(initTask);
        }
    }

    public void ensureInitializationComplete(@NonNull Context applicationContext, @Nullable String[] args) {
        if (this.initialized) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        try (TraceSection e = TraceSection.scoped("FlutterLoader#ensureInitializationComplete");){
            int oldGenHeapSizeMegaBytes;
            InitResult result = this.initResultFuture.get();
            ArrayList<String> shellArgs = new ArrayList<String>();
            shellArgs.add("--icu-symbol-prefix=_binary_icudtl_dat");
            shellArgs.add("--icu-native-lib-path=" + this.flutterApplicationInfo.nativeLibraryDir + File.separator + DEFAULT_LIBRARY);
            if (args != null) {
                for (String arg : args) {
                    if (arg.startsWith(aotSharedLibraryNameFlag)) {
                        String safeAotSharedLibraryNameFlag = this.getSafeAotSharedLibraryNameFlag(applicationContext, arg);
                        if (safeAotSharedLibraryNameFlag != null) {
                            arg = safeAotSharedLibraryNameFlag;
                        } else {
                            Log.w(TAG, "Skipping unsafe AOT shared library name flag: " + arg + ". Please ensure that the library is vetted and placed in your application's internal storage.");
                            continue;
                        }
                    }
                    shellArgs.add(arg);
                }
            }
            String kernelPath = null;
            String snapshotAssetPath = result.dataDirPath + File.separator + this.flutterApplicationInfo.flutterAssetsDir;
            kernelPath = snapshotAssetPath + File.separator + DEFAULT_KERNEL_BLOB;
            shellArgs.add("--snapshot-asset-path=" + snapshotAssetPath);
            shellArgs.add("--vm-snapshot-data=" + this.flutterApplicationInfo.vmSnapshotData);
            shellArgs.add("--isolate-snapshot-data=" + this.flutterApplicationInfo.isolateSnapshotData);
            shellArgs.add("--cache-dir-path=" + result.engineCachesPath);
            if (this.flutterApplicationInfo.domainNetworkPolicy != null) {
                shellArgs.add("--domain-network-policy=" + this.flutterApplicationInfo.domainNetworkPolicy);
            }
            if (this.settings.getLogTag() != null) {
                shellArgs.add("--log-tag=" + this.settings.getLogTag());
            }
            ApplicationInfo applicationInfo = applicationContext.getPackageManager().getApplicationInfo(applicationContext.getPackageName(), 128);
            Bundle metaData = applicationInfo.metaData;
            int n = oldGenHeapSizeMegaBytes = metaData != null ? metaData.getInt(OLD_GEN_HEAP_SIZE_META_DATA_KEY) : 0;
            if (oldGenHeapSizeMegaBytes == 0) {
                ActivityManager activityManager = (ActivityManager)applicationContext.getSystemService("activity");
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                activityManager.getMemoryInfo(memInfo);
                oldGenHeapSizeMegaBytes = (int)((double)memInfo.totalMem / 1000000.0 / 2.0);
            }
            shellArgs.add("--old-gen-heap-size=" + oldGenHeapSizeMegaBytes);
            DisplayMetrics displayMetrics = applicationContext.getResources().getDisplayMetrics();
            int screenWidth = displayMetrics.widthPixels;
            int screenHeight = displayMetrics.heightPixels;
            int resourceCacheMaxBytesThreshold = screenWidth * screenHeight * 12 * 4;
            shellArgs.add("--resource-cache-max-bytes-threshold=" + resourceCacheMaxBytesThreshold);
            shellArgs.add("--prefetched-default-font-manager");
            if (metaData != null) {
                String backend;
                if (metaData.containsKey(ENABLE_IMPELLER_META_DATA_KEY)) {
                    if (metaData.getBoolean(ENABLE_IMPELLER_META_DATA_KEY)) {
                        shellArgs.add("--enable-impeller=true");
                    } else {
                        shellArgs.add("--enable-impeller=false");
                    }
                }
                if (metaData.getBoolean(ENABLE_VULKAN_VALIDATION_META_DATA_KEY, false)) {
                    shellArgs.add("--enable-vulkan-validation");
                }
                if (metaData.getBoolean(IMPELLER_OPENGL_GPU_TRACING_DATA_KEY, false)) {
                    shellArgs.add("--enable-opengl-gpu-tracing");
                }
                if (metaData.getBoolean(IMPELLER_VULKAN_GPU_TRACING_DATA_KEY, false)) {
                    shellArgs.add("--enable-vulkan-gpu-tracing");
                }
                if (metaData.getBoolean(DISABLE_MERGED_PLATFORM_UI_THREAD_KEY, false)) {
                    throw new IllegalArgumentException("io.flutter.embedding.android.DisableMergedPlatformUIThread is no longer allowed.");
                }
                if (metaData.getBoolean(ENABLE_FLUTTER_GPU, false)) {
                    shellArgs.add("--enable-flutter-gpu");
                }
                if (metaData.getBoolean(ENABLE_SURFACE_CONTROL, false)) {
                    shellArgs.add("--enable-surface-control");
                }
                if ((backend = metaData.getString(IMPELLER_BACKEND_META_DATA_KEY)) != null) {
                    shellArgs.add("--impeller-backend=" + backend);
                }
                if (metaData.getBoolean(IMPELLER_LAZY_SHADER_MODE)) {
                    shellArgs.add("--impeller-lazy-shader-mode");
                }
                if (metaData.getBoolean(IMPELLER_ANTIALIAS_LINES)) {
                    shellArgs.add("--impeller-antialias-lines");
                }
            }
            String leakVM = FlutterLoader.isLeakVM(metaData) ? "true" : "false";
            shellArgs.add("--leak-vm=" + leakVM);
            long initTimeMillis = SystemClock.uptimeMillis() - this.initStartTimestampMillis;
            this.flutterJNI.init(applicationContext, shellArgs.toArray(new String[0]), kernelPath, result.appStoragePath, result.engineCachesPath, initTimeMillis, Build.VERSION.SDK_INT);
            this.initialized = true;
        }
        catch (Exception e2) {
            Log.e(TAG, "Flutter initialization failed.", e2);
            throw new RuntimeException(e2);
        }
    }

    private String getSafeAotSharedLibraryNameFlag(@NonNull Context applicationContext, @NonNull String aotSharedLibraryNameArg) throws IOException {
        String aotSharedLibraryPathCanonicalPath;
        if (!aotSharedLibraryNameArg.startsWith(aotSharedLibraryNameFlag)) {
            throw new IllegalArgumentException("AOT shared library name flag was not specified correctly; please use --aot-shared-library-name=<path>.");
        }
        String aotSharedLibraryPath = aotSharedLibraryNameArg.substring(aotSharedLibraryNameFlag.length());
        File aotSharedLibraryFile = this.getFileFromPath(aotSharedLibraryPath);
        try {
            aotSharedLibraryPathCanonicalPath = aotSharedLibraryFile.getCanonicalPath();
        }
        catch (IOException e) {
            Log.e(TAG, "External path " + aotSharedLibraryFile.getPath() + " is not a valid path. Please ensure this shared AOT library exists.");
            return null;
        }
        File internalStorageDirectory = applicationContext.getApplicationContext().getFilesDir();
        String internalStorageDirectoryPathCanonicalPath = internalStorageDirectory.getCanonicalPath();
        boolean livesWithinInternalStorage = aotSharedLibraryPathCanonicalPath.startsWith(internalStorageDirectoryPathCanonicalPath + File.separator);
        boolean isSoFile = aotSharedLibraryPathCanonicalPath.endsWith(".so");
        if (livesWithinInternalStorage && isSoFile) {
            return aotSharedLibraryNameFlag + aotSharedLibraryPathCanonicalPath;
        }
        Log.e(TAG, "External path " + aotSharedLibraryPathCanonicalPath + " rejected; not overriding aot-shared-library-name.");
        return null;
    }

    @VisibleForTesting
    File getFileFromPath(String path) {
        return new File(path);
    }

    private static boolean isLeakVM(@Nullable Bundle metaData) {
        boolean leakVMDefaultValue = true;
        if (metaData == null) {
            return true;
        }
        return metaData.getBoolean(LEAK_VM_META_DATA_KEY, true);
    }

    public void ensureInitializationCompleteAsync(@NonNull Context applicationContext, @Nullable String[] args, @NonNull Handler callbackHandler, @NonNull Runnable callback) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("ensureInitializationComplete must be called on the main thread");
        }
        if (this.settings == null) {
            throw new IllegalStateException("ensureInitializationComplete must be called after startInitialization");
        }
        if (this.initialized) {
            callbackHandler.post(callback);
            return;
        }
        this.executorService.execute(() -> {
            try {
                InitResult result = this.initResultFuture.get();
            }
            catch (Exception e) {
                Log.e(TAG, "Flutter initialization failed.", e);
                throw new RuntimeException(e);
            }
            HandlerCompat.createAsyncHandler(Looper.getMainLooper()).post(() -> {
                this.ensureInitializationComplete(applicationContext.getApplicationContext(), args);
                callbackHandler.post(callback);
            });
        });
    }

    public boolean initialized() {
        return this.initialized;
    }

    private ResourceExtractor initResources(@NonNull Context applicationContext) {
        ResourceExtractor resourceExtractor = null;
        String dataDirPath = PathUtils.getDataDirectory(applicationContext);
        String packageName = applicationContext.getPackageName();
        PackageManager packageManager = applicationContext.getPackageManager();
        AssetManager assetManager = applicationContext.getResources().getAssets();
        resourceExtractor = new ResourceExtractor(dataDirPath, packageName, packageManager, assetManager);
        resourceExtractor.addResource(this.fullAssetPathFrom(this.flutterApplicationInfo.vmSnapshotData)).addResource(this.fullAssetPathFrom(this.flutterApplicationInfo.isolateSnapshotData)).addResource(this.fullAssetPathFrom(DEFAULT_KERNEL_BLOB));
        resourceExtractor.start();
        return resourceExtractor;
    }

    @NonNull
    public String findAppBundlePath() {
        return this.flutterApplicationInfo.flutterAssetsDir;
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset) {
        return this.fullAssetPathFrom(asset);
    }

    @NonNull
    public String getLookupKeyForAsset(@NonNull String asset, @NonNull String packageName) {
        return this.getLookupKeyForAsset("packages" + File.separator + packageName + File.separator + asset);
    }

    @NonNull
    public boolean automaticallyRegisterPlugins() {
        return this.flutterApplicationInfo.automaticallyRegisterPlugins;
    }

    @NonNull
    private String fullAssetPathFrom(@NonNull String filePath) {
        return this.flutterApplicationInfo.flutterAssetsDir + File.separator + filePath;
    }

    public static class Settings {
        private String logTag;

        @Nullable
        public String getLogTag() {
            return this.logTag;
        }

        public void setLogTag(String tag) {
            this.logTag = tag;
        }
    }

    private static class InitResult {
        final String appStoragePath;
        final String engineCachesPath;
        final String dataDirPath;

        private InitResult(String appStoragePath, String engineCachesPath, String dataDirPath) {
            this.appStoragePath = appStoragePath;
            this.engineCachesPath = engineCachesPath;
            this.dataDirPath = dataDirPath;
        }
    }
}

