// GENERATED CODE - DO NOT EDIT

// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'V'.
class PartV {
  /// Applies the VT323 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/VT323
  static TextStyle vt323({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '351bb21ecaae045391ee603df58d4f2cf9a3d586c5fd3743fee2257bd3223ae4',
        102756,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VT323',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the VT323 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/VT323
  static TextTheme vt323TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vt323(textStyle: textTheme.displayLarge),
      displayMedium: vt323(textStyle: textTheme.displayMedium),
      displaySmall: vt323(textStyle: textTheme.displaySmall),
      headlineLarge: vt323(textStyle: textTheme.headlineLarge),
      headlineMedium: vt323(textStyle: textTheme.headlineMedium),
      headlineSmall: vt323(textStyle: textTheme.headlineSmall),
      titleLarge: vt323(textStyle: textTheme.titleLarge),
      titleMedium: vt323(textStyle: textTheme.titleMedium),
      titleSmall: vt323(textStyle: textTheme.titleSmall),
      bodyLarge: vt323(textStyle: textTheme.bodyLarge),
      bodyMedium: vt323(textStyle: textTheme.bodyMedium),
      bodySmall: vt323(textStyle: textTheme.bodySmall),
      labelLarge: vt323(textStyle: textTheme.labelLarge),
      labelMedium: vt323(textStyle: textTheme.labelMedium),
      labelSmall: vt323(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vampiro One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vampiro+One
  static TextStyle vampiroOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f0a67bf6e55ce905c19acfd170fe2ad4fd8dde861a429dc838b8f91eaf28255',
        20340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VampiroOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vampiro One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vampiro+One
  static TextTheme vampiroOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vampiroOne(textStyle: textTheme.displayLarge),
      displayMedium: vampiroOne(textStyle: textTheme.displayMedium),
      displaySmall: vampiroOne(textStyle: textTheme.displaySmall),
      headlineLarge: vampiroOne(textStyle: textTheme.headlineLarge),
      headlineMedium: vampiroOne(textStyle: textTheme.headlineMedium),
      headlineSmall: vampiroOne(textStyle: textTheme.headlineSmall),
      titleLarge: vampiroOne(textStyle: textTheme.titleLarge),
      titleMedium: vampiroOne(textStyle: textTheme.titleMedium),
      titleSmall: vampiroOne(textStyle: textTheme.titleSmall),
      bodyLarge: vampiroOne(textStyle: textTheme.bodyLarge),
      bodyMedium: vampiroOne(textStyle: textTheme.bodyMedium),
      bodySmall: vampiroOne(textStyle: textTheme.bodySmall),
      labelLarge: vampiroOne(textStyle: textTheme.labelLarge),
      labelMedium: vampiroOne(textStyle: textTheme.labelMedium),
      labelSmall: vampiroOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Varela font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Varela
  static TextStyle varela({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8f3a3817461c73b138cc5e749a7f802c6281c5f3ecbbb40550548db3f615db0',
        59496,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Varela',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Varela font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Varela
  static TextTheme varelaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: varela(textStyle: textTheme.displayLarge),
      displayMedium: varela(textStyle: textTheme.displayMedium),
      displaySmall: varela(textStyle: textTheme.displaySmall),
      headlineLarge: varela(textStyle: textTheme.headlineLarge),
      headlineMedium: varela(textStyle: textTheme.headlineMedium),
      headlineSmall: varela(textStyle: textTheme.headlineSmall),
      titleLarge: varela(textStyle: textTheme.titleLarge),
      titleMedium: varela(textStyle: textTheme.titleMedium),
      titleSmall: varela(textStyle: textTheme.titleSmall),
      bodyLarge: varela(textStyle: textTheme.bodyLarge),
      bodyMedium: varela(textStyle: textTheme.bodyMedium),
      bodySmall: varela(textStyle: textTheme.bodySmall),
      labelLarge: varela(textStyle: textTheme.labelLarge),
      labelMedium: varela(textStyle: textTheme.labelMedium),
      labelSmall: varela(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Varela Round font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Varela+Round
  static TextStyle varelaRound({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '152c718649787d4b4b78a4b65dcc88f1e58b55df459680bd0d5f5ced2549d127',
        97980,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VarelaRound',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Varela Round font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Varela+Round
  static TextTheme varelaRoundTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: varelaRound(textStyle: textTheme.displayLarge),
      displayMedium: varelaRound(textStyle: textTheme.displayMedium),
      displaySmall: varelaRound(textStyle: textTheme.displaySmall),
      headlineLarge: varelaRound(textStyle: textTheme.headlineLarge),
      headlineMedium: varelaRound(textStyle: textTheme.headlineMedium),
      headlineSmall: varelaRound(textStyle: textTheme.headlineSmall),
      titleLarge: varelaRound(textStyle: textTheme.titleLarge),
      titleMedium: varelaRound(textStyle: textTheme.titleMedium),
      titleSmall: varelaRound(textStyle: textTheme.titleSmall),
      bodyLarge: varelaRound(textStyle: textTheme.bodyLarge),
      bodyMedium: varelaRound(textStyle: textTheme.bodyMedium),
      bodySmall: varelaRound(textStyle: textTheme.bodySmall),
      labelLarge: varelaRound(textStyle: textTheme.labelLarge),
      labelMedium: varelaRound(textStyle: textTheme.labelMedium),
      labelSmall: varelaRound(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Varta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Varta
  static TextStyle varta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be9bec5184ee313e88b98c32b21aadaa3de69ad634fc1f3430fe08cdb93b12bc',
        65188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '067659f9b3f9bcfd2a8e5620904c702c8d865bdf9e34961ea9a7df1c28b9dfc4',
        65080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6baeba27463e519c9c8110eddadf5b72ba355268d5847efd64b390738f38fdaf',
        65180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd745e94b56b588e648ace88a9c0f19d94b159ac5f43a1efe488c6c762e8ea3e2',
        65156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7b4ab01cce266358bd36c21d350b566b84d03bbf44d7d4057911f2a6c1b0cb8',
        64956,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Varta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Varta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Varta
  static TextTheme vartaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: varta(textStyle: textTheme.displayLarge),
      displayMedium: varta(textStyle: textTheme.displayMedium),
      displaySmall: varta(textStyle: textTheme.displaySmall),
      headlineLarge: varta(textStyle: textTheme.headlineLarge),
      headlineMedium: varta(textStyle: textTheme.headlineMedium),
      headlineSmall: varta(textStyle: textTheme.headlineSmall),
      titleLarge: varta(textStyle: textTheme.titleLarge),
      titleMedium: varta(textStyle: textTheme.titleMedium),
      titleSmall: varta(textStyle: textTheme.titleSmall),
      bodyLarge: varta(textStyle: textTheme.bodyLarge),
      bodyMedium: varta(textStyle: textTheme.bodyMedium),
      bodySmall: varta(textStyle: textTheme.bodySmall),
      labelLarge: varta(textStyle: textTheme.labelLarge),
      labelMedium: varta(textStyle: textTheme.labelMedium),
      labelSmall: varta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vast Shadow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vast+Shadow
  static TextStyle vastShadow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd043bcb9908c0ffb2bc8d12f862a146d623a1bde4292674a76e9b0df3bafdadb',
        58360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VastShadow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vast Shadow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vast+Shadow
  static TextTheme vastShadowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vastShadow(textStyle: textTheme.displayLarge),
      displayMedium: vastShadow(textStyle: textTheme.displayMedium),
      displaySmall: vastShadow(textStyle: textTheme.displaySmall),
      headlineLarge: vastShadow(textStyle: textTheme.headlineLarge),
      headlineMedium: vastShadow(textStyle: textTheme.headlineMedium),
      headlineSmall: vastShadow(textStyle: textTheme.headlineSmall),
      titleLarge: vastShadow(textStyle: textTheme.titleLarge),
      titleMedium: vastShadow(textStyle: textTheme.titleMedium),
      titleSmall: vastShadow(textStyle: textTheme.titleSmall),
      bodyLarge: vastShadow(textStyle: textTheme.bodyLarge),
      bodyMedium: vastShadow(textStyle: textTheme.bodyMedium),
      bodySmall: vastShadow(textStyle: textTheme.bodySmall),
      labelLarge: vastShadow(textStyle: textTheme.labelLarge),
      labelMedium: vastShadow(textStyle: textTheme.labelMedium),
      labelSmall: vastShadow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vazirmatn font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vazirmatn
  static TextStyle vazirmatn({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e99a99fb1ad45228c4b8c76764c027c40247e68773a1650ecc070f247aadc87b',
        104372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0a5606b7fd67bb5093f16f3dda721776f4f07799d2f614e6d34a5caa4e5bac9',
        104680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3fbe20bef5c73fb42837eb7e1fe1be3a20ab02d0a4da8e56f1265c8caf344e83',
        104636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '110713c7af1906a70df2bd754c9520f5abe4a06b217bebbcd0861dd0cf0cc673',
        104616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ffebd8b3aebd10cd3cedf5ef19937e2b38f6b2aaff92803ecc67a27e458bc4af',
        104700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efe03b3317944d3d9befa4e7b6cb1ae5eb78d33d6b9fc4d2d64f43ca42d60159',
        104844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7708b496794e5d1ab76070d56d5b2ea2a621e20c411343e92444b5d1a5e0af5',
        105204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bf18c1f654fd918ce05387fb81c173d0f6c72211daf3760400d2f4c16c7c628',
        105380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b8e0e79a26522a4195b609a578b025ba127a940cabf89c19f9765bad612c7b0',
        105400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Vazirmatn',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vazirmatn font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vazirmatn
  static TextTheme vazirmatnTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vazirmatn(textStyle: textTheme.displayLarge),
      displayMedium: vazirmatn(textStyle: textTheme.displayMedium),
      displaySmall: vazirmatn(textStyle: textTheme.displaySmall),
      headlineLarge: vazirmatn(textStyle: textTheme.headlineLarge),
      headlineMedium: vazirmatn(textStyle: textTheme.headlineMedium),
      headlineSmall: vazirmatn(textStyle: textTheme.headlineSmall),
      titleLarge: vazirmatn(textStyle: textTheme.titleLarge),
      titleMedium: vazirmatn(textStyle: textTheme.titleMedium),
      titleSmall: vazirmatn(textStyle: textTheme.titleSmall),
      bodyLarge: vazirmatn(textStyle: textTheme.bodyLarge),
      bodyMedium: vazirmatn(textStyle: textTheme.bodyMedium),
      bodySmall: vazirmatn(textStyle: textTheme.bodySmall),
      labelLarge: vazirmatn(textStyle: textTheme.labelLarge),
      labelMedium: vazirmatn(textStyle: textTheme.labelMedium),
      labelSmall: vazirmatn(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vesper Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vesper+Libre
  static TextStyle vesperLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'badad7ef59ce3a55517b1114139e20cd3e2a38b6c9b5cd97fd84b773f7dd6303',
        161640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aff5eb26af761eaaac3ee56b4f45e3925af49e61ecb55397b3903c1af9e52ba0',
        163912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02576e8c7ea8eb1f3829849fec4cfb69bdd4ffeac96ec752ebe87f07c9d84f3f',
        163772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bdb316fceb26d01a0c19ef2f47270cdca854e2ead62f921c42dc703d6c3446e1',
        161856,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VesperLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vesper Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vesper+Libre
  static TextTheme vesperLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vesperLibre(textStyle: textTheme.displayLarge),
      displayMedium: vesperLibre(textStyle: textTheme.displayMedium),
      displaySmall: vesperLibre(textStyle: textTheme.displaySmall),
      headlineLarge: vesperLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: vesperLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: vesperLibre(textStyle: textTheme.headlineSmall),
      titleLarge: vesperLibre(textStyle: textTheme.titleLarge),
      titleMedium: vesperLibre(textStyle: textTheme.titleMedium),
      titleSmall: vesperLibre(textStyle: textTheme.titleSmall),
      bodyLarge: vesperLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: vesperLibre(textStyle: textTheme.bodyMedium),
      bodySmall: vesperLibre(textStyle: textTheme.bodySmall),
      labelLarge: vesperLibre(textStyle: textTheme.labelLarge),
      labelMedium: vesperLibre(textStyle: textTheme.labelMedium),
      labelSmall: vesperLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Viaoda Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Viaoda+Libre
  static TextStyle viaodaLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a4f29c65db5a76a32dc57b080eeb9ad721ca3817bdf5d87f3dff0231a9f6eb12',
        104232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ViaodaLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Viaoda Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Viaoda+Libre
  static TextTheme viaodaLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: viaodaLibre(textStyle: textTheme.displayLarge),
      displayMedium: viaodaLibre(textStyle: textTheme.displayMedium),
      displaySmall: viaodaLibre(textStyle: textTheme.displaySmall),
      headlineLarge: viaodaLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: viaodaLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: viaodaLibre(textStyle: textTheme.headlineSmall),
      titleLarge: viaodaLibre(textStyle: textTheme.titleLarge),
      titleMedium: viaodaLibre(textStyle: textTheme.titleMedium),
      titleSmall: viaodaLibre(textStyle: textTheme.titleSmall),
      bodyLarge: viaodaLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: viaodaLibre(textStyle: textTheme.bodyMedium),
      bodySmall: viaodaLibre(textStyle: textTheme.bodySmall),
      labelLarge: viaodaLibre(textStyle: textTheme.labelLarge),
      labelMedium: viaodaLibre(textStyle: textTheme.labelMedium),
      labelSmall: viaodaLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vibes font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vibes
  static TextStyle vibes({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e33238f8c2e24ad46821776d2ccfea97ec4904fe3c41fdf3e51982a6ccc3461b',
        49952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Vibes',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vibes font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vibes
  static TextTheme vibesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vibes(textStyle: textTheme.displayLarge),
      displayMedium: vibes(textStyle: textTheme.displayMedium),
      displaySmall: vibes(textStyle: textTheme.displaySmall),
      headlineLarge: vibes(textStyle: textTheme.headlineLarge),
      headlineMedium: vibes(textStyle: textTheme.headlineMedium),
      headlineSmall: vibes(textStyle: textTheme.headlineSmall),
      titleLarge: vibes(textStyle: textTheme.titleLarge),
      titleMedium: vibes(textStyle: textTheme.titleMedium),
      titleSmall: vibes(textStyle: textTheme.titleSmall),
      bodyLarge: vibes(textStyle: textTheme.bodyLarge),
      bodyMedium: vibes(textStyle: textTheme.bodyMedium),
      bodySmall: vibes(textStyle: textTheme.bodySmall),
      labelLarge: vibes(textStyle: textTheme.labelLarge),
      labelMedium: vibes(textStyle: textTheme.labelMedium),
      labelSmall: vibes(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vibur font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vibur
  static TextStyle vibur({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4ea981f715f63b3720f08d1830f568e6fd79e3e2998c8faf5e7c1097a2913a0',
        60552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Vibur',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vibur font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vibur
  static TextTheme viburTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vibur(textStyle: textTheme.displayLarge),
      displayMedium: vibur(textStyle: textTheme.displayMedium),
      displaySmall: vibur(textStyle: textTheme.displaySmall),
      headlineLarge: vibur(textStyle: textTheme.headlineLarge),
      headlineMedium: vibur(textStyle: textTheme.headlineMedium),
      headlineSmall: vibur(textStyle: textTheme.headlineSmall),
      titleLarge: vibur(textStyle: textTheme.titleLarge),
      titleMedium: vibur(textStyle: textTheme.titleMedium),
      titleSmall: vibur(textStyle: textTheme.titleSmall),
      bodyLarge: vibur(textStyle: textTheme.bodyLarge),
      bodyMedium: vibur(textStyle: textTheme.bodyMedium),
      bodySmall: vibur(textStyle: textTheme.bodySmall),
      labelLarge: vibur(textStyle: textTheme.labelLarge),
      labelMedium: vibur(textStyle: textTheme.labelMedium),
      labelSmall: vibur(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Victor Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Victor+Mono
  static TextStyle victorMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e56b31be68b6ae5f4b201e7d83c731967d03ac81f6cef091806db8727e3dd031',
        131336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cdd457404bc6dc448d8061a990a72f88fc40ddec85e1ab1a9287b4c544e5f8b5',
        131632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a56c4acc1eb197310aeb37faad64d6588fa5a7bb1ef04cf48448c0edd9254a18',
        131660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '797d9ee5e729d818c6915a947150c2bbefb8741648bae51f6a5274da4b9be149',
        131620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9809a2eebe27caf2f258d96eef29e18c92b7e6b7a436b4391697eba5236dff47',
        131632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7444e766a2e962221175a2936d245bbe070ed7bc80ce618c1848eab70a5848e2',
        131520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b010edbe4c18f8a2a3e2f19d53f617fd4ab242ab6635caee1feef4cf9260c5ca',
        131344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5dc075be0c701bf5db77aca0b747b7db8351131b389589f1e5c1eed964e43c09',
        160648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ceb77620c6714dfcd8022c0f31fd31e5d6f4b58cfb67a911748bf193aa8c0807',
        161032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5a52738c56cb50fac7a0f0e147dbf8dbb0d87e75afcc4f509b802f122237f006',
        161180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3ccb1fc54e0fbf8da96427d35bdbd2c2e36fc41ca59ebafb5c82d650f27e8253',
        161144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2170765225e1b5a36a6d9274159119e3743c228245818310541ac3bee7ef4f7d',
        161308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '02c5a60db20a721d0bef85dc2745480bb07ce2e026f213ba51715905291369fa',
        161276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '11f117ba0632df78e4ef6d584e9a541356b1bb3f4dbf4d7b52055ccef0347399',
        160964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VictorMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Victor Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Victor+Mono
  static TextTheme victorMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: victorMono(textStyle: textTheme.displayLarge),
      displayMedium: victorMono(textStyle: textTheme.displayMedium),
      displaySmall: victorMono(textStyle: textTheme.displaySmall),
      headlineLarge: victorMono(textStyle: textTheme.headlineLarge),
      headlineMedium: victorMono(textStyle: textTheme.headlineMedium),
      headlineSmall: victorMono(textStyle: textTheme.headlineSmall),
      titleLarge: victorMono(textStyle: textTheme.titleLarge),
      titleMedium: victorMono(textStyle: textTheme.titleMedium),
      titleSmall: victorMono(textStyle: textTheme.titleSmall),
      bodyLarge: victorMono(textStyle: textTheme.bodyLarge),
      bodyMedium: victorMono(textStyle: textTheme.bodyMedium),
      bodySmall: victorMono(textStyle: textTheme.bodySmall),
      labelLarge: victorMono(textStyle: textTheme.labelLarge),
      labelMedium: victorMono(textStyle: textTheme.labelMedium),
      labelSmall: victorMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vidaloka font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vidaloka
  static TextStyle vidaloka({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c6592100a850080279f5e151be96330c0741aa288a811284d88673a3b9326da',
        37520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Vidaloka',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vidaloka font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vidaloka
  static TextTheme vidalokaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vidaloka(textStyle: textTheme.displayLarge),
      displayMedium: vidaloka(textStyle: textTheme.displayMedium),
      displaySmall: vidaloka(textStyle: textTheme.displaySmall),
      headlineLarge: vidaloka(textStyle: textTheme.headlineLarge),
      headlineMedium: vidaloka(textStyle: textTheme.headlineMedium),
      headlineSmall: vidaloka(textStyle: textTheme.headlineSmall),
      titleLarge: vidaloka(textStyle: textTheme.titleLarge),
      titleMedium: vidaloka(textStyle: textTheme.titleMedium),
      titleSmall: vidaloka(textStyle: textTheme.titleSmall),
      bodyLarge: vidaloka(textStyle: textTheme.bodyLarge),
      bodyMedium: vidaloka(textStyle: textTheme.bodyMedium),
      bodySmall: vidaloka(textStyle: textTheme.bodySmall),
      labelLarge: vidaloka(textStyle: textTheme.labelLarge),
      labelMedium: vidaloka(textStyle: textTheme.labelMedium),
      labelSmall: vidaloka(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Viga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Viga
  static TextStyle viga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02c2468f6c3515d37a943cf86734653f4e5d7b51016379e7f15c4055e58dae81',
        25000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Viga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Viga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Viga
  static TextTheme vigaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: viga(textStyle: textTheme.displayLarge),
      displayMedium: viga(textStyle: textTheme.displayMedium),
      displaySmall: viga(textStyle: textTheme.displaySmall),
      headlineLarge: viga(textStyle: textTheme.headlineLarge),
      headlineMedium: viga(textStyle: textTheme.headlineMedium),
      headlineSmall: viga(textStyle: textTheme.headlineSmall),
      titleLarge: viga(textStyle: textTheme.titleLarge),
      titleMedium: viga(textStyle: textTheme.titleMedium),
      titleSmall: viga(textStyle: textTheme.titleSmall),
      bodyLarge: viga(textStyle: textTheme.bodyLarge),
      bodyMedium: viga(textStyle: textTheme.bodyMedium),
      bodySmall: viga(textStyle: textTheme.bodySmall),
      labelLarge: viga(textStyle: textTheme.labelLarge),
      labelMedium: viga(textStyle: textTheme.labelMedium),
      labelSmall: viga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vina Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vina+Sans
  static TextStyle vinaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc7cae8011a124a8393e97c8c7fde61a2c6f03514772ab3b105c572a06ebc0ca',
        42772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VinaSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vina Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vina+Sans
  static TextTheme vinaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vinaSans(textStyle: textTheme.displayLarge),
      displayMedium: vinaSans(textStyle: textTheme.displayMedium),
      displaySmall: vinaSans(textStyle: textTheme.displaySmall),
      headlineLarge: vinaSans(textStyle: textTheme.headlineLarge),
      headlineMedium: vinaSans(textStyle: textTheme.headlineMedium),
      headlineSmall: vinaSans(textStyle: textTheme.headlineSmall),
      titleLarge: vinaSans(textStyle: textTheme.titleLarge),
      titleMedium: vinaSans(textStyle: textTheme.titleMedium),
      titleSmall: vinaSans(textStyle: textTheme.titleSmall),
      bodyLarge: vinaSans(textStyle: textTheme.bodyLarge),
      bodyMedium: vinaSans(textStyle: textTheme.bodyMedium),
      bodySmall: vinaSans(textStyle: textTheme.bodySmall),
      labelLarge: vinaSans(textStyle: textTheme.labelLarge),
      labelMedium: vinaSans(textStyle: textTheme.labelMedium),
      labelSmall: vinaSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Voces font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Voces
  static TextStyle voces({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a60ebcb2eb175a13b0a603bc6d82597439d1539487c82c852c27d4a7f86e8fb9',
        73856,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Voces',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Voces font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Voces
  static TextTheme vocesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: voces(textStyle: textTheme.displayLarge),
      displayMedium: voces(textStyle: textTheme.displayMedium),
      displaySmall: voces(textStyle: textTheme.displaySmall),
      headlineLarge: voces(textStyle: textTheme.headlineLarge),
      headlineMedium: voces(textStyle: textTheme.headlineMedium),
      headlineSmall: voces(textStyle: textTheme.headlineSmall),
      titleLarge: voces(textStyle: textTheme.titleLarge),
      titleMedium: voces(textStyle: textTheme.titleMedium),
      titleSmall: voces(textStyle: textTheme.titleSmall),
      bodyLarge: voces(textStyle: textTheme.bodyLarge),
      bodyMedium: voces(textStyle: textTheme.bodyMedium),
      bodySmall: voces(textStyle: textTheme.bodySmall),
      labelLarge: voces(textStyle: textTheme.labelLarge),
      labelMedium: voces(textStyle: textTheme.labelMedium),
      labelSmall: voces(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Volkhov font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Volkhov
  static TextStyle volkhov({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '666c0e832ada07c0e3454cb2a4f98526aaf42725a7241de1d01085974babcb80',
        31508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e6038e861c6b8ae994bd876508ee1e73e4c716b00fd60ba4f460dab15e8713d3',
        32420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b092f086c2bf80a82c5c58383c690eed8ea94ccfa64aa84e8bb9ad6ba3b23d5d',
        31436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3b872f6f2a82abd5239cb1f610aa6a8acddab65778c883c54a0bdd2175c2cf51',
        33948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Volkhov',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Volkhov font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Volkhov
  static TextTheme volkhovTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: volkhov(textStyle: textTheme.displayLarge),
      displayMedium: volkhov(textStyle: textTheme.displayMedium),
      displaySmall: volkhov(textStyle: textTheme.displaySmall),
      headlineLarge: volkhov(textStyle: textTheme.headlineLarge),
      headlineMedium: volkhov(textStyle: textTheme.headlineMedium),
      headlineSmall: volkhov(textStyle: textTheme.headlineSmall),
      titleLarge: volkhov(textStyle: textTheme.titleLarge),
      titleMedium: volkhov(textStyle: textTheme.titleMedium),
      titleSmall: volkhov(textStyle: textTheme.titleSmall),
      bodyLarge: volkhov(textStyle: textTheme.bodyLarge),
      bodyMedium: volkhov(textStyle: textTheme.bodyMedium),
      bodySmall: volkhov(textStyle: textTheme.bodySmall),
      labelLarge: volkhov(textStyle: textTheme.labelLarge),
      labelMedium: volkhov(textStyle: textTheme.labelMedium),
      labelSmall: volkhov(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vollkorn font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vollkorn
  static TextStyle vollkorn({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e01351a10abce7ebd02220693bd48419165fe6c1b745a867d7ec5855d1ea573',
        229048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11acb1d4a6b1bafbc915d3534f102e82946664cb177a7ed8249e30b2246328d0',
        230508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '293bd61bf7d50593d1d4ede8c79ca5c5a97787990f7dffcefad63a56c244e4eb',
        230572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9f3360698cf73ed36e444f39897e66f2fed2d0394e848ebf94351df595bbc30',
        231260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35d3a1ed173ec4065b4d6a27e53307d8eec975ae50af99c69c0d8bcb9151004e',
        231992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd497046a94e1e9ad6b71365d66a1c61bacdac88c4e3e26d297496f25e135c7d5',
        231660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b68a775f129a5cc85cfd8bbbf579fb769984ab88b833c9c8c8d59ec8af56c2fb',
        226096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6f7d64f91355fefe206199095d8aa93cf8c926e40f1eaa5ffcb73d031f3d6b63',
        226784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7b8956b3d4e7a5bc2f4d9f67dad05db9ae10b01d817b453aab5311936184308e',
        226864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e96240b16fc6687086cabbfe689502d35800cf766ad6eaac7c8923a0e281bc58',
        227652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e5135bf74bdb4ec314f311eeb09c451fe6011762cc06c7d2575948789a5b68ee',
        228216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '402dab6aa8a46b15fc535cddbf78c34d9d432450a2a7cfb8262963c1e1a2fa4a',
        227996,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Vollkorn',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vollkorn font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vollkorn
  static TextTheme vollkornTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vollkorn(textStyle: textTheme.displayLarge),
      displayMedium: vollkorn(textStyle: textTheme.displayMedium),
      displaySmall: vollkorn(textStyle: textTheme.displaySmall),
      headlineLarge: vollkorn(textStyle: textTheme.headlineLarge),
      headlineMedium: vollkorn(textStyle: textTheme.headlineMedium),
      headlineSmall: vollkorn(textStyle: textTheme.headlineSmall),
      titleLarge: vollkorn(textStyle: textTheme.titleLarge),
      titleMedium: vollkorn(textStyle: textTheme.titleMedium),
      titleSmall: vollkorn(textStyle: textTheme.titleSmall),
      bodyLarge: vollkorn(textStyle: textTheme.bodyLarge),
      bodyMedium: vollkorn(textStyle: textTheme.bodyMedium),
      bodySmall: vollkorn(textStyle: textTheme.bodySmall),
      labelLarge: vollkorn(textStyle: textTheme.labelLarge),
      labelMedium: vollkorn(textStyle: textTheme.labelMedium),
      labelSmall: vollkorn(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vollkorn SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vollkorn+SC
  static TextStyle vollkornSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59f17bf5d6c21eac82b4345c6ca2c8419809acba8791d22f0bfd8d633aed82d0',
        126312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'caa72e033b48b14bd346bfc152c1a621ff0cf8d44154fa6c58abfded37d4a9ab',
        128396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ff980dbf53ef2403b6ac0ffa7eba229391a04234e09dba84dbc517d8928d131',
        128572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '64f67b0220d47738705145a0cdc31267ad1322e3c1e258451c231b0a7187d909',
        127804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VollkornSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vollkorn SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vollkorn+SC
  static TextTheme vollkornScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vollkornSc(textStyle: textTheme.displayLarge),
      displayMedium: vollkornSc(textStyle: textTheme.displayMedium),
      displaySmall: vollkornSc(textStyle: textTheme.displaySmall),
      headlineLarge: vollkornSc(textStyle: textTheme.headlineLarge),
      headlineMedium: vollkornSc(textStyle: textTheme.headlineMedium),
      headlineSmall: vollkornSc(textStyle: textTheme.headlineSmall),
      titleLarge: vollkornSc(textStyle: textTheme.titleLarge),
      titleMedium: vollkornSc(textStyle: textTheme.titleMedium),
      titleSmall: vollkornSc(textStyle: textTheme.titleSmall),
      bodyLarge: vollkornSc(textStyle: textTheme.bodyLarge),
      bodyMedium: vollkornSc(textStyle: textTheme.bodyMedium),
      bodySmall: vollkornSc(textStyle: textTheme.bodySmall),
      labelLarge: vollkornSc(textStyle: textTheme.labelLarge),
      labelMedium: vollkornSc(textStyle: textTheme.labelMedium),
      labelSmall: vollkornSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Voltaire font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Voltaire
  static TextStyle voltaire({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f7eabfaaf1511f97145e74e643557c5b4c9e168f2809708eefdc758bdc33d1b',
        263700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Voltaire',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Voltaire font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Voltaire
  static TextTheme voltaireTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: voltaire(textStyle: textTheme.displayLarge),
      displayMedium: voltaire(textStyle: textTheme.displayMedium),
      displaySmall: voltaire(textStyle: textTheme.displaySmall),
      headlineLarge: voltaire(textStyle: textTheme.headlineLarge),
      headlineMedium: voltaire(textStyle: textTheme.headlineMedium),
      headlineSmall: voltaire(textStyle: textTheme.headlineSmall),
      titleLarge: voltaire(textStyle: textTheme.titleLarge),
      titleMedium: voltaire(textStyle: textTheme.titleMedium),
      titleSmall: voltaire(textStyle: textTheme.titleSmall),
      bodyLarge: voltaire(textStyle: textTheme.bodyLarge),
      bodyMedium: voltaire(textStyle: textTheme.bodyMedium),
      bodySmall: voltaire(textStyle: textTheme.bodySmall),
      labelLarge: voltaire(textStyle: textTheme.labelLarge),
      labelMedium: voltaire(textStyle: textTheme.labelMedium),
      labelSmall: voltaire(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Vujahday Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vujahday+Script
  static TextStyle vujahdayScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8020b0c3c02968f56889aaa7f27b3681c287d63e4ec28e39db7fe9fa2ab4165',
        151768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'VujahdayScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Vujahday Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Vujahday+Script
  static TextTheme vujahdayScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: vujahdayScript(textStyle: textTheme.displayLarge),
      displayMedium: vujahdayScript(textStyle: textTheme.displayMedium),
      displaySmall: vujahdayScript(textStyle: textTheme.displaySmall),
      headlineLarge: vujahdayScript(textStyle: textTheme.headlineLarge),
      headlineMedium: vujahdayScript(textStyle: textTheme.headlineMedium),
      headlineSmall: vujahdayScript(textStyle: textTheme.headlineSmall),
      titleLarge: vujahdayScript(textStyle: textTheme.titleLarge),
      titleMedium: vujahdayScript(textStyle: textTheme.titleMedium),
      titleSmall: vujahdayScript(textStyle: textTheme.titleSmall),
      bodyLarge: vujahdayScript(textStyle: textTheme.bodyLarge),
      bodyMedium: vujahdayScript(textStyle: textTheme.bodyMedium),
      bodySmall: vujahdayScript(textStyle: textTheme.bodySmall),
      labelLarge: vujahdayScript(textStyle: textTheme.labelLarge),
      labelMedium: vujahdayScript(textStyle: textTheme.labelMedium),
      labelSmall: vujahdayScript(textStyle: textTheme.labelSmall),
    );
  }
}
