// Copyright (c) 2024, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/breakpoint_inside_nested_closures_test.dart
//
const LINE_A = 23;
// AUTOGENERATED END

int f() {
  return (() {
    (() {
      return 1 + 2;
    })();
    return (() {
      return 3 + 4; // LINE_A
    })();
  })();
}

void testeeMain() {
  f();
}

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  resumeIsolate,
  hasStoppedAtExit,
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'breakpoint_inside_nested_closures_test.dart',
      testeeConcurrent: testeeMain,
      pauseOnStart: true,
      pauseOnExit: true,
    );
