// GENERATED CODE - DO NOT EDIT

// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'U'.
class PartU {
  /// Applies the Ubuntu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu
  static TextStyle ubuntu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a47c8ef66f4571dfde5f8bae62263d581a3cb43b414574219145cfe0bbc6087a',
        145972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd060388a26470af6e9866b24636cea1a2353ad593308cd1f1fd62cd46dd6d458',
        162240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c6760f323ee57525ee9fec23bf7c14af2667970250d0931f33a7f195e7ac11b',
        154420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '81e4ac216d2e6324a7690639b25e32d9a9b7cafa59bab76c03b6a59b10ca031b',
        158020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff4f5b6a457d5a8f672b09ca8968ec29dac69de860566d18d2cac669f1149470',
        153712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2f405a0141171fb36ee2b9db0ec65a172ad42ecd904b5ff4dcee4d59ce9bdba6',
        159400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b2505ebc304cfd0570e37d34f5d067de5fbddd54ce0908f41f217b4d1a4996b',
        153588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '88774d4ad39da2b059fa471515c1ad7eec8268be06a10fcedba3658c940dc9a6',
        169232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ubuntu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ubuntu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu
  static TextTheme ubuntuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ubuntu(textStyle: textTheme.displayLarge),
      displayMedium: ubuntu(textStyle: textTheme.displayMedium),
      displaySmall: ubuntu(textStyle: textTheme.displaySmall),
      headlineLarge: ubuntu(textStyle: textTheme.headlineLarge),
      headlineMedium: ubuntu(textStyle: textTheme.headlineMedium),
      headlineSmall: ubuntu(textStyle: textTheme.headlineSmall),
      titleLarge: ubuntu(textStyle: textTheme.titleLarge),
      titleMedium: ubuntu(textStyle: textTheme.titleMedium),
      titleSmall: ubuntu(textStyle: textTheme.titleSmall),
      bodyLarge: ubuntu(textStyle: textTheme.bodyLarge),
      bodyMedium: ubuntu(textStyle: textTheme.bodyMedium),
      bodySmall: ubuntu(textStyle: textTheme.bodySmall),
      labelLarge: ubuntu(textStyle: textTheme.labelLarge),
      labelMedium: ubuntu(textStyle: textTheme.labelMedium),
      labelSmall: ubuntu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ubuntu Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu+Condensed
  static TextStyle ubuntuCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '173b8f0c3210383802a1d8c4208a8b46e0b877cbb4753d50f445b9620050566a',
        164556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'UbuntuCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ubuntu Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu+Condensed
  static TextTheme ubuntuCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ubuntuCondensed(textStyle: textTheme.displayLarge),
      displayMedium: ubuntuCondensed(textStyle: textTheme.displayMedium),
      displaySmall: ubuntuCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: ubuntuCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: ubuntuCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: ubuntuCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: ubuntuCondensed(textStyle: textTheme.titleLarge),
      titleMedium: ubuntuCondensed(textStyle: textTheme.titleMedium),
      titleSmall: ubuntuCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: ubuntuCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: ubuntuCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: ubuntuCondensed(textStyle: textTheme.bodySmall),
      labelLarge: ubuntuCondensed(textStyle: textTheme.labelLarge),
      labelMedium: ubuntuCondensed(textStyle: textTheme.labelMedium),
      labelSmall: ubuntuCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ubuntu Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu+Mono
  static TextStyle ubuntuMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '78f0e98c9013a285561af8018ff090e9536f9cb0977464ecf0a117a66423d97e',
        98028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '540117820bd0ee5e3019a08e6f987766aec0fbd040bd92413dcb2c3ed677ad6a',
        102844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efa8334b43a090218e12b7084b2b7f1d076d4a0e19b93fcdf9ab18cc37fb08dc',
        96904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0422cea66b5b06d5963351f52c43d01dfdc889a545e122abcfe9726e4aca8fca',
        102172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'UbuntuMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ubuntu Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu+Mono
  static TextTheme ubuntuMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ubuntuMono(textStyle: textTheme.displayLarge),
      displayMedium: ubuntuMono(textStyle: textTheme.displayMedium),
      displaySmall: ubuntuMono(textStyle: textTheme.displaySmall),
      headlineLarge: ubuntuMono(textStyle: textTheme.headlineLarge),
      headlineMedium: ubuntuMono(textStyle: textTheme.headlineMedium),
      headlineSmall: ubuntuMono(textStyle: textTheme.headlineSmall),
      titleLarge: ubuntuMono(textStyle: textTheme.titleLarge),
      titleMedium: ubuntuMono(textStyle: textTheme.titleMedium),
      titleSmall: ubuntuMono(textStyle: textTheme.titleSmall),
      bodyLarge: ubuntuMono(textStyle: textTheme.bodyLarge),
      bodyMedium: ubuntuMono(textStyle: textTheme.bodyMedium),
      bodySmall: ubuntuMono(textStyle: textTheme.bodySmall),
      labelLarge: ubuntuMono(textStyle: textTheme.labelLarge),
      labelMedium: ubuntuMono(textStyle: textTheme.labelMedium),
      labelSmall: ubuntuMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ubuntu Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu+Sans
  static TextStyle ubuntuSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '456e8ddd69cc26ab70382c44351e1e3e6f84becd99eabfa7eca8a6dc52f1745e',
        231352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b52962e0624a9bf2723c1cc07eae58321deedd9c46de2929c314c0a7c5c6795d',
        231720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '158e0717cf71b225fb5503cec3295931eaa979fecfa123a81c9f32d23577f4ab',
        231552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d29b1107b28d7f3668cba2cdd82373158ab5a4c80cf114821b9df5708c8f62f',
        231492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ccbfe8d006fae65f64be92a2a22fcd09a8b1a70c91a3a8fdb42cc126ae92595',
        231616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd40d4dab8a79ebe8b50b3bff19ea2c83e8a4960b9f0af4a54164ed2aebba993d',
        231720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a6841cbcffdbe34a9f0fcabcda674ed18bc5f8652769ef881ea5eb81556d008',
        231640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e48af3f6854249ce196dc9b3ee5590f8d0ea59c0f32385ab2d3b6201c738280a',
        231708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1deae8bc6a928b8556e29f930ae4540d05eb2d66c31ab963f6ec5bb9c26d2108',
        247600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b848bdabe67baae980b99fa57d1b15d6f41e43081c66a8c2baeee2f4f5ac1691',
        247852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15dde3082ac90c527111e7df0b09c5f620b0ec50c701bf53663a629c23211a0d',
        247880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6ab62d78bd013f188a618dab210e56b0d17207f7851dfdb03f28adc7544c44e7',
        247656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a1508989ec5550113af63c62ef69509f45870bc87d1970452b81927804a63db9',
        247916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ffc18f999ca6669ffcc72063d71f84037078fe430c0c4fa9f4279293a56aa873',
        247948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fc093bcf9990d65879599725f22ede6dd2de5dc7a2edf0aa1ab23c12caa57e21',
        247912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cbab83a00e5076c876007d74c2265f819a8fbaf0e1b535cbbc9e722489543af9',
        247976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'UbuntuSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ubuntu Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu+Sans
  static TextTheme ubuntuSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ubuntuSans(textStyle: textTheme.displayLarge),
      displayMedium: ubuntuSans(textStyle: textTheme.displayMedium),
      displaySmall: ubuntuSans(textStyle: textTheme.displaySmall),
      headlineLarge: ubuntuSans(textStyle: textTheme.headlineLarge),
      headlineMedium: ubuntuSans(textStyle: textTheme.headlineMedium),
      headlineSmall: ubuntuSans(textStyle: textTheme.headlineSmall),
      titleLarge: ubuntuSans(textStyle: textTheme.titleLarge),
      titleMedium: ubuntuSans(textStyle: textTheme.titleMedium),
      titleSmall: ubuntuSans(textStyle: textTheme.titleSmall),
      bodyLarge: ubuntuSans(textStyle: textTheme.bodyLarge),
      bodyMedium: ubuntuSans(textStyle: textTheme.bodyMedium),
      bodySmall: ubuntuSans(textStyle: textTheme.bodySmall),
      labelLarge: ubuntuSans(textStyle: textTheme.labelLarge),
      labelMedium: ubuntuSans(textStyle: textTheme.labelMedium),
      labelSmall: ubuntuSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ubuntu Sans Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu+Sans+Mono
  static TextStyle ubuntuSansMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '44ae840b720f3e95bb69bd2449082c72d90272356c78fdbb5721b3ff5a6a97cc',
        111100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46ab71e7ebab7516438f265d25c1c6084ec116cff1aad24afea1422a9e5b7ba3',
        111160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a13175b837a6e9f77c7b9be8b4a77ba7bbc039d5535d9d2768bb0a050018e84',
        111156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5224a9bb27672470392ad5693ffe40f876408fc46ff7eea839c0b9e8ab9f144e',
        110672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b14f0b3b545240386bab1ad28b993d68f1c0aa27098185c50ada7533e9f349dd',
        114212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ccb0866ed261b703fc6d4df8a8d8fa990cedb3ef5649630a563d4b63f6d1c3b3',
        114352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '12b9aa6477f74260d5d0ab35cd4289652ab60b666165c81ebdce14ba641e81e6',
        114328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a28c516b044902577d4dfd449666ed7cae623f4101840acb970fe2d464ce4fdc',
        114048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'UbuntuSansMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ubuntu Sans Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ubuntu+Sans+Mono
  static TextTheme ubuntuSansMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ubuntuSansMono(textStyle: textTheme.displayLarge),
      displayMedium: ubuntuSansMono(textStyle: textTheme.displayMedium),
      displaySmall: ubuntuSansMono(textStyle: textTheme.displaySmall),
      headlineLarge: ubuntuSansMono(textStyle: textTheme.headlineLarge),
      headlineMedium: ubuntuSansMono(textStyle: textTheme.headlineMedium),
      headlineSmall: ubuntuSansMono(textStyle: textTheme.headlineSmall),
      titleLarge: ubuntuSansMono(textStyle: textTheme.titleLarge),
      titleMedium: ubuntuSansMono(textStyle: textTheme.titleMedium),
      titleSmall: ubuntuSansMono(textStyle: textTheme.titleSmall),
      bodyLarge: ubuntuSansMono(textStyle: textTheme.bodyLarge),
      bodyMedium: ubuntuSansMono(textStyle: textTheme.bodyMedium),
      bodySmall: ubuntuSansMono(textStyle: textTheme.bodySmall),
      labelLarge: ubuntuSansMono(textStyle: textTheme.labelLarge),
      labelMedium: ubuntuSansMono(textStyle: textTheme.labelMedium),
      labelSmall: ubuntuSansMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Uchen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Uchen
  static TextStyle uchen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5b027e7e8a92c6e91d64a5d8dc7140dbbebf3d593ea25e842bff2d7b819a0e0f',
        800904,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Uchen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Uchen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Uchen
  static TextTheme uchenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: uchen(textStyle: textTheme.displayLarge),
      displayMedium: uchen(textStyle: textTheme.displayMedium),
      displaySmall: uchen(textStyle: textTheme.displaySmall),
      headlineLarge: uchen(textStyle: textTheme.headlineLarge),
      headlineMedium: uchen(textStyle: textTheme.headlineMedium),
      headlineSmall: uchen(textStyle: textTheme.headlineSmall),
      titleLarge: uchen(textStyle: textTheme.titleLarge),
      titleMedium: uchen(textStyle: textTheme.titleMedium),
      titleSmall: uchen(textStyle: textTheme.titleSmall),
      bodyLarge: uchen(textStyle: textTheme.bodyLarge),
      bodyMedium: uchen(textStyle: textTheme.bodyMedium),
      bodySmall: uchen(textStyle: textTheme.bodySmall),
      labelLarge: uchen(textStyle: textTheme.labelLarge),
      labelMedium: uchen(textStyle: textTheme.labelMedium),
      labelSmall: uchen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ultra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ultra
  static TextStyle ultra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51d2390e97e8f01f554f4a9517854ed69e2fffa497b2c2b5cac87c427eba79ee',
        50316,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ultra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ultra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ultra
  static TextTheme ultraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ultra(textStyle: textTheme.displayLarge),
      displayMedium: ultra(textStyle: textTheme.displayMedium),
      displaySmall: ultra(textStyle: textTheme.displaySmall),
      headlineLarge: ultra(textStyle: textTheme.headlineLarge),
      headlineMedium: ultra(textStyle: textTheme.headlineMedium),
      headlineSmall: ultra(textStyle: textTheme.headlineSmall),
      titleLarge: ultra(textStyle: textTheme.titleLarge),
      titleMedium: ultra(textStyle: textTheme.titleMedium),
      titleSmall: ultra(textStyle: textTheme.titleSmall),
      bodyLarge: ultra(textStyle: textTheme.bodyLarge),
      bodyMedium: ultra(textStyle: textTheme.bodyMedium),
      bodySmall: ultra(textStyle: textTheme.bodySmall),
      labelLarge: ultra(textStyle: textTheme.labelLarge),
      labelMedium: ultra(textStyle: textTheme.labelMedium),
      labelSmall: ultra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Unbounded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unbounded
  static TextStyle unbounded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4614e983311b7110ca80f8986e0ab4c17ada0e36de2ba630e8b16024821e3ad7',
        342020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab43d06cc409d7311d68e475bef2ee80c34863cd6d02ed17d67f8128c524e353',
        344636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b7ac4d609bf9a247e57b6a739b5c9086c4bc390267be9be379a999359144473',
        343580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8008be4a3b38a8fe449b1fff36360a8db2fffe5f35e8b65ccd010d7d03ada767',
        347324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40a6b67885008b4b512fa5f0ad310f707b6bf3196b7bda1a04d459c66d5cd82e',
        348084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ace2d8e99cb69f55bfe89ad06fc72389ff796f51abd2806b316694d63083ef7',
        349224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '168528c3393339e692150a07842c3760668e99c52aa1cad1f02b54d64297259a',
        399752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acadebb563a84b50bb8f7293b2b9629f7f476de35daa0ba0891f29e21ef5a95f',
        395768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Unbounded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Unbounded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unbounded
  static TextTheme unboundedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: unbounded(textStyle: textTheme.displayLarge),
      displayMedium: unbounded(textStyle: textTheme.displayMedium),
      displaySmall: unbounded(textStyle: textTheme.displaySmall),
      headlineLarge: unbounded(textStyle: textTheme.headlineLarge),
      headlineMedium: unbounded(textStyle: textTheme.headlineMedium),
      headlineSmall: unbounded(textStyle: textTheme.headlineSmall),
      titleLarge: unbounded(textStyle: textTheme.titleLarge),
      titleMedium: unbounded(textStyle: textTheme.titleMedium),
      titleSmall: unbounded(textStyle: textTheme.titleSmall),
      bodyLarge: unbounded(textStyle: textTheme.bodyLarge),
      bodyMedium: unbounded(textStyle: textTheme.bodyMedium),
      bodySmall: unbounded(textStyle: textTheme.bodySmall),
      labelLarge: unbounded(textStyle: textTheme.labelLarge),
      labelMedium: unbounded(textStyle: textTheme.labelMedium),
      labelSmall: unbounded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Uncial Antiqua font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Uncial+Antiqua
  static TextStyle uncialAntiqua({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41728ed55d0e54aec51750112ed99f922b217d7dfe8d6909dc0830913e43e5ef',
        60616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'UncialAntiqua',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Uncial Antiqua font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Uncial+Antiqua
  static TextTheme uncialAntiquaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: uncialAntiqua(textStyle: textTheme.displayLarge),
      displayMedium: uncialAntiqua(textStyle: textTheme.displayMedium),
      displaySmall: uncialAntiqua(textStyle: textTheme.displaySmall),
      headlineLarge: uncialAntiqua(textStyle: textTheme.headlineLarge),
      headlineMedium: uncialAntiqua(textStyle: textTheme.headlineMedium),
      headlineSmall: uncialAntiqua(textStyle: textTheme.headlineSmall),
      titleLarge: uncialAntiqua(textStyle: textTheme.titleLarge),
      titleMedium: uncialAntiqua(textStyle: textTheme.titleMedium),
      titleSmall: uncialAntiqua(textStyle: textTheme.titleSmall),
      bodyLarge: uncialAntiqua(textStyle: textTheme.bodyLarge),
      bodyMedium: uncialAntiqua(textStyle: textTheme.bodyMedium),
      bodySmall: uncialAntiqua(textStyle: textTheme.bodySmall),
      labelLarge: uncialAntiqua(textStyle: textTheme.labelLarge),
      labelMedium: uncialAntiqua(textStyle: textTheme.labelMedium),
      labelSmall: uncialAntiqua(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Underdog font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Underdog
  static TextStyle underdog({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7abc36e556f51243d974e19fe54e10f906e8d222f060dc1678e58264a2a4498',
        43728,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Underdog',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Underdog font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Underdog
  static TextTheme underdogTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: underdog(textStyle: textTheme.displayLarge),
      displayMedium: underdog(textStyle: textTheme.displayMedium),
      displaySmall: underdog(textStyle: textTheme.displaySmall),
      headlineLarge: underdog(textStyle: textTheme.headlineLarge),
      headlineMedium: underdog(textStyle: textTheme.headlineMedium),
      headlineSmall: underdog(textStyle: textTheme.headlineSmall),
      titleLarge: underdog(textStyle: textTheme.titleLarge),
      titleMedium: underdog(textStyle: textTheme.titleMedium),
      titleSmall: underdog(textStyle: textTheme.titleSmall),
      bodyLarge: underdog(textStyle: textTheme.bodyLarge),
      bodyMedium: underdog(textStyle: textTheme.bodyMedium),
      bodySmall: underdog(textStyle: textTheme.bodySmall),
      labelLarge: underdog(textStyle: textTheme.labelLarge),
      labelMedium: underdog(textStyle: textTheme.labelMedium),
      labelSmall: underdog(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Unica One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unica+One
  static TextStyle unicaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a2db78e9c8b06c54b0243a447e8e99f93f738470670d2a85377db7cfa0b5c73b',
        49836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'UnicaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Unica One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unica+One
  static TextTheme unicaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: unicaOne(textStyle: textTheme.displayLarge),
      displayMedium: unicaOne(textStyle: textTheme.displayMedium),
      displaySmall: unicaOne(textStyle: textTheme.displaySmall),
      headlineLarge: unicaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: unicaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: unicaOne(textStyle: textTheme.headlineSmall),
      titleLarge: unicaOne(textStyle: textTheme.titleLarge),
      titleMedium: unicaOne(textStyle: textTheme.titleMedium),
      titleSmall: unicaOne(textStyle: textTheme.titleSmall),
      bodyLarge: unicaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: unicaOne(textStyle: textTheme.bodyMedium),
      bodySmall: unicaOne(textStyle: textTheme.bodySmall),
      labelLarge: unicaOne(textStyle: textTheme.labelLarge),
      labelMedium: unicaOne(textStyle: textTheme.labelMedium),
      labelSmall: unicaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the UnifrakturCook font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/UnifrakturCook
  static TextStyle unifrakturCook({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1afa20b47835b72c9aa4a77763cbd6fbebb470d04a70e34f6259e1445639d5e0',
        35640,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'UnifrakturCook',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the UnifrakturCook font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/UnifrakturCook
  static TextTheme unifrakturCookTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: unifrakturCook(textStyle: textTheme.displayLarge),
      displayMedium: unifrakturCook(textStyle: textTheme.displayMedium),
      displaySmall: unifrakturCook(textStyle: textTheme.displaySmall),
      headlineLarge: unifrakturCook(textStyle: textTheme.headlineLarge),
      headlineMedium: unifrakturCook(textStyle: textTheme.headlineMedium),
      headlineSmall: unifrakturCook(textStyle: textTheme.headlineSmall),
      titleLarge: unifrakturCook(textStyle: textTheme.titleLarge),
      titleMedium: unifrakturCook(textStyle: textTheme.titleMedium),
      titleSmall: unifrakturCook(textStyle: textTheme.titleSmall),
      bodyLarge: unifrakturCook(textStyle: textTheme.bodyLarge),
      bodyMedium: unifrakturCook(textStyle: textTheme.bodyMedium),
      bodySmall: unifrakturCook(textStyle: textTheme.bodySmall),
      labelLarge: unifrakturCook(textStyle: textTheme.labelLarge),
      labelMedium: unifrakturCook(textStyle: textTheme.labelMedium),
      labelSmall: unifrakturCook(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the UnifrakturMaguntia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/UnifrakturMaguntia
  static TextStyle unifrakturMaguntia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77773983d9e3c4662fda43de043b8bcec9ce14ad5bc6cbad30ded723c1e465db',
        56692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'UnifrakturMaguntia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the UnifrakturMaguntia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/UnifrakturMaguntia
  static TextTheme unifrakturMaguntiaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: unifrakturMaguntia(textStyle: textTheme.displayLarge),
      displayMedium: unifrakturMaguntia(textStyle: textTheme.displayMedium),
      displaySmall: unifrakturMaguntia(textStyle: textTheme.displaySmall),
      headlineLarge: unifrakturMaguntia(textStyle: textTheme.headlineLarge),
      headlineMedium: unifrakturMaguntia(textStyle: textTheme.headlineMedium),
      headlineSmall: unifrakturMaguntia(textStyle: textTheme.headlineSmall),
      titleLarge: unifrakturMaguntia(textStyle: textTheme.titleLarge),
      titleMedium: unifrakturMaguntia(textStyle: textTheme.titleMedium),
      titleSmall: unifrakturMaguntia(textStyle: textTheme.titleSmall),
      bodyLarge: unifrakturMaguntia(textStyle: textTheme.bodyLarge),
      bodyMedium: unifrakturMaguntia(textStyle: textTheme.bodyMedium),
      bodySmall: unifrakturMaguntia(textStyle: textTheme.bodySmall),
      labelLarge: unifrakturMaguntia(textStyle: textTheme.labelLarge),
      labelMedium: unifrakturMaguntia(textStyle: textTheme.labelMedium),
      labelSmall: unifrakturMaguntia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Unkempt font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unkempt
  static TextStyle unkempt({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74e8417429eb3bbeef53ac4f2f91d70a30dd1fddec024eacab3e54b4010611f4',
        190344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8c28bec2588dbdd2cf0468c9c5ccca5dbeafa95048486049ee871a2b74ef6ee',
        188712,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Unkempt',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Unkempt font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unkempt
  static TextTheme unkemptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: unkempt(textStyle: textTheme.displayLarge),
      displayMedium: unkempt(textStyle: textTheme.displayMedium),
      displaySmall: unkempt(textStyle: textTheme.displaySmall),
      headlineLarge: unkempt(textStyle: textTheme.headlineLarge),
      headlineMedium: unkempt(textStyle: textTheme.headlineMedium),
      headlineSmall: unkempt(textStyle: textTheme.headlineSmall),
      titleLarge: unkempt(textStyle: textTheme.titleLarge),
      titleMedium: unkempt(textStyle: textTheme.titleMedium),
      titleSmall: unkempt(textStyle: textTheme.titleSmall),
      bodyLarge: unkempt(textStyle: textTheme.bodyLarge),
      bodyMedium: unkempt(textStyle: textTheme.bodyMedium),
      bodySmall: unkempt(textStyle: textTheme.bodySmall),
      labelLarge: unkempt(textStyle: textTheme.labelLarge),
      labelMedium: unkempt(textStyle: textTheme.labelMedium),
      labelSmall: unkempt(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Unlock font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unlock
  static TextStyle unlock({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2c42bd7b30873ac128a6a9aad39c535781c15e6541985c8a4085406eb366537',
        34852,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Unlock',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Unlock font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unlock
  static TextTheme unlockTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: unlock(textStyle: textTheme.displayLarge),
      displayMedium: unlock(textStyle: textTheme.displayMedium),
      displaySmall: unlock(textStyle: textTheme.displaySmall),
      headlineLarge: unlock(textStyle: textTheme.headlineLarge),
      headlineMedium: unlock(textStyle: textTheme.headlineMedium),
      headlineSmall: unlock(textStyle: textTheme.headlineSmall),
      titleLarge: unlock(textStyle: textTheme.titleLarge),
      titleMedium: unlock(textStyle: textTheme.titleMedium),
      titleSmall: unlock(textStyle: textTheme.titleSmall),
      bodyLarge: unlock(textStyle: textTheme.bodyLarge),
      bodyMedium: unlock(textStyle: textTheme.bodyMedium),
      bodySmall: unlock(textStyle: textTheme.bodySmall),
      labelLarge: unlock(textStyle: textTheme.labelLarge),
      labelMedium: unlock(textStyle: textTheme.labelMedium),
      labelSmall: unlock(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Unna font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unna
  static TextStyle unna({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0bd31fc3cd967f6c1621d02c3ad0079113c3bdd87f52cf093f2a45edad47983',
        37964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8e1ae73e6bf7f8c03a7647fc1e3fc83918735ec2c00f8ada3ccb8c10eb83f151',
        43884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7e48cad3cba7e2a4265d7d66944fe41ac5af13303df1bf350fd6af9539967ffe',
        38572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5cc871447f42211cfb6f8230387b9d14d42145186a734e03ade260bc14e6626b',
        44840,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Unna',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Unna font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Unna
  static TextTheme unnaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: unna(textStyle: textTheme.displayLarge),
      displayMedium: unna(textStyle: textTheme.displayMedium),
      displaySmall: unna(textStyle: textTheme.displaySmall),
      headlineLarge: unna(textStyle: textTheme.headlineLarge),
      headlineMedium: unna(textStyle: textTheme.headlineMedium),
      headlineSmall: unna(textStyle: textTheme.headlineSmall),
      titleLarge: unna(textStyle: textTheme.titleLarge),
      titleMedium: unna(textStyle: textTheme.titleMedium),
      titleSmall: unna(textStyle: textTheme.titleSmall),
      bodyLarge: unna(textStyle: textTheme.bodyLarge),
      bodyMedium: unna(textStyle: textTheme.bodyMedium),
      bodySmall: unna(textStyle: textTheme.bodySmall),
      labelLarge: unna(textStyle: textTheme.labelLarge),
      labelMedium: unna(textStyle: textTheme.labelMedium),
      labelSmall: unna(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Updock font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Updock
  static TextStyle updock({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '220e52bd71dbaf18cf79cb3dfba25494511646b702faa96db7ef2737b395f91c',
        75500,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Updock',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Updock font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Updock
  static TextTheme updockTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: updock(textStyle: textTheme.displayLarge),
      displayMedium: updock(textStyle: textTheme.displayMedium),
      displaySmall: updock(textStyle: textTheme.displaySmall),
      headlineLarge: updock(textStyle: textTheme.headlineLarge),
      headlineMedium: updock(textStyle: textTheme.headlineMedium),
      headlineSmall: updock(textStyle: textTheme.headlineSmall),
      titleLarge: updock(textStyle: textTheme.titleLarge),
      titleMedium: updock(textStyle: textTheme.titleMedium),
      titleSmall: updock(textStyle: textTheme.titleSmall),
      bodyLarge: updock(textStyle: textTheme.bodyLarge),
      bodyMedium: updock(textStyle: textTheme.bodyMedium),
      bodySmall: updock(textStyle: textTheme.bodySmall),
      labelLarge: updock(textStyle: textTheme.labelLarge),
      labelMedium: updock(textStyle: textTheme.labelMedium),
      labelSmall: updock(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Urbanist font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Urbanist
  static TextStyle urbanist({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76235e223645d450dadc33a58b471816fe422f40df021725556ebb2fc0563ba9',
        40916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a62fd06c9d9d88332344989836eb0063495b4eaa1e3737837035c67a63e87186',
        41140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '18852f90aa1bf14de40d6f029eecbd1d4611d5701de197e53d0c7ba98f5af41c',
        41104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1c559f34e38b9716d4d77c1e29cee7aab5fea0ec5406491fa25c527dc79186c',
        41036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ace39b6f55ef23a2b494e5aaefa309e29de2b75df1b15a33b899f675bed1a3ab',
        41092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81050f4f88133cfa61620ed3f5c037bf33067b7cda8bb5a959564037565c93c1',
        41084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fbfde7af5fcf724ec2176047afc0087c773f55e59dc947369f6f25c578f1cbd',
        40960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34b3d9cc4d8ef19c88da410462f1f2c03b0f7833fe80aeb883f09151081e3634',
        41256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '198b2b4cf699700d690dcf0b7e50048aa685e0d57d36eca04514eba3968ac923',
        41124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5b2080f9c72d806bba735dd1cca247bfeb11e9068bce5ea8010935d26428797c',
        41884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15dfca2eca2c77cdbaab3588281ac432e343e0e4ab2bb7c144359ebc7ccd0455',
        42144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6e1b357e80eb40fd9fa8a3bc4b45cc7330013abe6d52ea8330d0156ec96d08be',
        42072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ce1fe627bed11341c82a27ae469a90359d980d5ec4e0a3bdfaa65176ab00989a',
        41996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c92a2b9ae484c0d846f0bfd5e78211553f6e84c2c9a1cda93cfe5807a587b89e',
        42104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8d012a0073b2dbb60277356130a8b94d4dd35887a00e119980439311fc3a2498',
        42120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e32e15bbdfd9fdd842c33d06d7b384471663c9f08b69f82da645efdf66920211',
        41916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ee7a8c2b66cac0f674b2c295ed489f1edf1be43906ed8885606df7c031f2e2f8',
        42244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '50e717fd17cf6d29ecb63ee7868ae1cf38fab627bc6fe403c22251ca8978381b',
        42104,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Urbanist',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Urbanist font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Urbanist
  static TextTheme urbanistTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: urbanist(textStyle: textTheme.displayLarge),
      displayMedium: urbanist(textStyle: textTheme.displayMedium),
      displaySmall: urbanist(textStyle: textTheme.displaySmall),
      headlineLarge: urbanist(textStyle: textTheme.headlineLarge),
      headlineMedium: urbanist(textStyle: textTheme.headlineMedium),
      headlineSmall: urbanist(textStyle: textTheme.headlineSmall),
      titleLarge: urbanist(textStyle: textTheme.titleLarge),
      titleMedium: urbanist(textStyle: textTheme.titleMedium),
      titleSmall: urbanist(textStyle: textTheme.titleSmall),
      bodyLarge: urbanist(textStyle: textTheme.bodyLarge),
      bodyMedium: urbanist(textStyle: textTheme.bodyMedium),
      bodySmall: urbanist(textStyle: textTheme.bodySmall),
      labelLarge: urbanist(textStyle: textTheme.labelLarge),
      labelMedium: urbanist(textStyle: textTheme.labelMedium),
      labelSmall: urbanist(textStyle: textTheme.labelSmall),
    );
  }
}
