/*
 * Decompiled with CFR 0.152.
 */
package io.flywheel.rest;

import io.flywheel.rest.RestResponse;
import io.flywheel.rest.RestUtils;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public class HttpMethodRestResponse
implements RestResponse {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String url;
    private final HttpMethod method;

    public HttpMethodRestResponse(String url, HttpMethod method) {
        this.url = url;
        this.method = method;
        if (this.method == null) {
            throw new IllegalArgumentException("HttpMethod cannot be null!");
        }
    }

    @Override
    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    @Override
    public String getReasonPhrase() {
        return this.method.getStatusText();
    }

    @Override
    public String getBodyAsString() throws IOException {
        return this.method.getResponseBodyAsString();
    }

    @Override
    public Object getBodyData(String format) throws IOException {
        byte[] data = this.method.getResponseBody();
        if (format.equals("int8")) {
            return data;
        }
        if (format.equals("int16")) {
            return RestUtils.convertByteArrayToShort(data);
        }
        if (format.equals("int32")) {
            return RestUtils.convertByteArrayToInt(data);
        }
        if (format.equals("int64")) {
            return RestUtils.convertByteArrayToLong(data);
        }
        if (format.equals("double")) {
            return RestUtils.convertByteArrayToDouble(data);
        }
        if (format.equals("char")) {
            return RestUtils.convertByteArrayToChar(data);
        }
        throw new IllegalArgumentException("Unknown body format: " + format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveResponseBodyToFile(String path) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        byte[] buffer = new byte[8192];
        try {
            in = this.method.getResponseBodyAsStream();
            out = new FileOutputStream(path);
            int len = in.read(buffer);
            while (len != -1) {
                if (len > 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                len = in.read(buffer);
            }
        }
        catch (Throwable throwable) {
            HttpMethodRestResponse.safeClose(in);
            HttpMethodRestResponse.safeClose(out);
            throw throwable;
        }
        HttpMethodRestResponse.safeClose(in);
        HttpMethodRestResponse.safeClose(out);
    }

    @Override
    public String[] getHeaders(String name) {
        Header[] headers = this.method.getResponseHeaders(name);
        if (headers == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            result[i] = headers[i].getValue();
        }
        return result;
    }

    @Override
    public String getFirstHeader(String name) {
        Header result = this.method.getResponseHeader(name);
        if (result == null) {
            return null;
        }
        return result.getValue();
    }

    @Override
    public String[] getAllHeaderNames() {
        Header[] headers = this.method.getResponseHeaders();
        if (headers == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            result[i] = headers[i].getName();
        }
        return result;
    }

    @Override
    public String getRequestUrl() {
        return this.url;
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

