/*
 * Decompiled with CFR 0.152.
 */
package io.flywheel.rest;

import io.flywheel.rest.SecurityPolicy;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HttpsSocketFactory
implements ProtocolSocketFactory {
    private final String[] enabledProtocols;
    private final String[] enabledCipherSuites;
    private final SSLContext sslContext;
    private static final String[] DEFAULT_PROTOCOLS;
    private static final String[] DESIRED_CIPHER_SUITES;
    private static String _sslCertFile;

    public static synchronized void setSSLCertFile(String sslCertFile) {
        _sslCertFile = sslCertFile;
    }

    public static synchronized String getSSLCertFile() {
        return _sslCertFile;
    }

    private KeyStore createKeystore() {
        String certFile = HttpsSocketFactory.getSSLCertFile();
        if (certFile != null && !certFile.isEmpty()) {
            return this.loadKeystoreFromPem(certFile);
        }
        return this.loadKeystoreFromBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeystoreFromBundle() {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream("/io/flywheel/rest/cacerts");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(in, null);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            e.printStackTrace();
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeystoreFromPem(String path) {
        FileInputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null, null);
            fis = new FileInputStream(path);
            BufferedInputStream bis = new BufferedInputStream(fis);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            int idx = 1;
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                ks.setCertificateEntry(String.format("cert%03d", idx++), cert);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            e.printStackTrace();
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    private SSLContext createSSLContext() {
        try {
            KeyStore ks = this.createKeystore();
            if (ks == null) {
                return null;
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tmf.getTrustManagers(), null);
            return context;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HttpsSocketFactory(String[] enabledProtocols) {
        try {
            this.sslContext = this.createSSLContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create ssl context", e);
        }
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = HttpsSocketFactory.determineEnabledCipherSuites();
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket result = this.sslContext.getSocketFactory().createSocket(host, port, localAddress, localPort);
        return this.setProtocols(result);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket result;
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = httpConnectionParams.getConnectionTimeout();
        if (timeout == 0) {
            result = this.sslContext.getSocketFactory().createSocket(host, port, localAddress, localPort);
            this.setProtocols(result);
        } else {
            result = this.sslContext.getSocketFactory().createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            this.setProtocols(result);
            result.bind(localaddr);
            result.connect(remoteaddr, timeout);
        }
        return result;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket result = this.sslContext.getSocketFactory().createSocket(host, port);
        return this.setProtocols(result);
    }

    private Socket setProtocols(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setEnabledProtocols(this.enabledProtocols);
            if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
        }
        return socket;
    }

    public static void register() {
        Protocol baseProtocol = Protocol.getProtocol((String)"https");
        int defaultPort = baseProtocol.getDefaultPort();
        Protocol customProtocol = new Protocol("https", (ProtocolSocketFactory)new HttpsSocketFactory(DEFAULT_PROTOCOLS), defaultPort);
        Protocol.registerProtocol((String)"https", (Protocol)customProtocol);
    }

    public static String[] determineEnabledCipherSuites() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String[] enabledSuites;
            SSLSocket sock = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
            List<String> supportedSuites = Arrays.asList(sock.getSupportedCipherSuites());
            for (String suite : DESIRED_CIPHER_SUITES) {
                if (!supportedSuites.contains(suite)) continue;
                result.add(suite);
            }
            for (String suite : enabledSuites = sock.getEnabledCipherSuites()) {
                result.add(suite);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toArray(new String[result.size()]);
    }

    static {
        SecurityPolicy.enableUnlimitedCryptography();
        DEFAULT_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1"};
        DESIRED_CIPHER_SUITES = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256"};
        _sslCertFile = null;
    }
}

