/*
 * Decompiled with CFR 0.152.
 */
package io.flywheel.rest;

import io.flywheel.rest.HttpMethodRestResponse;
import io.flywheel.rest.HttpsSocketFactory;
import io.flywheel.rest.RestResponse;
import io.flywheel.rest.RestUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class RestClient {
    private HttpClient client;
    private URL baseUrl;
    private Map<String, String> defaultHeaders = new TreeMap<String, String>();
    private Map<String, String> defaultParameters = new TreeMap<String, String>();
    private static final String JSON_CONTENT_TYPE = "application/json";

    public RestClient(URL baseUrl) {
        this(baseUrl, null);
    }

    public RestClient(URL baseUrl, String apiKey) {
        this.baseUrl = baseUrl;
        this.client = new HttpClient();
        if (apiKey != null && !apiKey.isEmpty()) {
            this.defaultHeaders.put("Authorization", "scitran-user " + apiKey);
        }
    }

    public static void useCertFile(String sslCertFile) {
        HttpsSocketFactory.setSSLCertFile(sslCertFile);
        HttpsSocketFactory.register();
    }

    public static RestClient fromApiKey(String apiKey) throws MalformedURLException {
        String host = "";
        String key = "";
        int port = 443;
        String[] parts = apiKey.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid API key");
        }
        host = parts[0];
        if (parts.length == 2) {
            key = parts[1];
        } else {
            port = Integer.parseInt(parts[1]);
            key = parts[parts.length - 1];
        }
        return new RestClient(new URL("https", host, port, "/api/"), key);
    }

    public RestResponse performJson(String method, String path, String body) throws IOException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String url = new URL(this.baseUrl, path).toString();
        HttpMethod request = RestUtils.createMethod(method, url);
        this.initializeMethod(request, JSON_CONTENT_TYPE, body);
        this.client.executeMethod(request);
        return new HttpMethodRestResponse(url, request);
    }

    public RestResponse performJson(String method, String path) throws IOException {
        return this.performJson(method, path, null);
    }

    public RestResponse callApi(String method, String path, Object[] pathParams, Object[] queryParams, Object[] headers, String body, Object[] postParams, Object[] files) throws IOException {
        String url = this.buildUrl(path, pathParams, queryParams);
        HttpMethod request = RestUtils.createMethod(method, url);
        request.setFollowRedirects(false);
        this.setDefaultHeaders(request);
        RestUtils.addMethodHeaders(request, headers);
        RestUtils.setRequestEntity(request, body, postParams, files);
        this.client.executeMethod(request);
        if (request.getStatusCode() == 301 || request.getStatusCode() == 302) {
            String newLocation = request.getResponseHeader("Location").getValue();
            request = RestUtils.createMethod(method, newLocation);
            this.setDefaultHeaders(request);
            RestUtils.addMethodHeaders(request, headers);
            URI originalUrl = new URI(url);
            URI newUrl = new URI(newLocation);
            if (!originalUrl.getHost().equals(newUrl.getHost())) {
                request.removeRequestHeader("Authorization");
            }
            RestUtils.setRequestEntity(request, body, postParams, files);
            this.client.executeMethod(request);
        }
        return new HttpMethodRestResponse(url, request);
    }

    public void addDefaultParameter(String name, String value) {
        this.defaultParameters.put(name, value);
    }

    public void setDefaultHeader(String name, String value) {
        this.defaultHeaders.put(name, value);
    }

    public Object[] getDefaultHeaders() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (String key : this.defaultHeaders.keySet()) {
            result.add(new Object[]{key, this.defaultHeaders.get(key)});
        }
        return result.toArray();
    }

    public String buildUrl(String path, Object[] pathParams, Object[] queryParams) throws IOException {
        if ((path = RestUtils.resolvePathParameters(path, pathParams)).startsWith("/")) {
            path = path.substring(1);
        }
        String query = RestUtils.buildQueryString(this.defaultParameters, queryParams);
        return new URL(this.baseUrl, path).toString() + query;
    }

    private void initializeMethod(HttpMethod method, String contentType, String body) {
        this.setDefaultHeaders(method);
        if (body != null) {
            EntityEnclosingMethod request;
            try {
                request = (EntityEnclosingMethod)method;
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Specifying a request body is not supported for: " + method.getName());
            }
            try {
                request.setRequestEntity((RequestEntity)new StringRequestEntity(body, contentType, null));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encoding");
            }
        }
    }

    private void setDefaultHeaders(HttpMethod method) {
        for (String headerKey : this.defaultHeaders.keySet()) {
            method.setRequestHeader(headerKey, this.defaultHeaders.get(headerKey));
        }
    }
}

