% AnalysesApi - 
%
% AnalysesApi Properties:
%    apiClient - ApiClient instance
%
% AnalysesApi Methods
%    addAnalysisNote                 - Add a note to a(n) analysis.
%    addAnalysisTag                  - Add a tag to a(n) analysis.
%    deleteAnalysesByIds             - Delete multiple analyses by ID list
%    deleteAnalysesByQuery           - Delete multiple analyses by query
%    deleteAnalysis                  - Delete an analysis
%    deleteAnalysisNote              - Remove a note from a(n) analysis
%    deleteAnalysisTag               - Delete a tag
%    downloadInputFromAnalysis       - Download analysis inputs with filter.
%    getAnalysisInputZipInfo         - Retrieve the zip info of a child file by name.
%    getAnalysisInputDownloadTicket  - Get a signed URL to download a named child file.
%    downloadOutputFromAnalysis      - Get Output File
%    getAnalysisOutputZipInfo        - Retrieve the zip info of a child file by name.
%    getAnalysisOutputDownloadTicket - Get a signed URL to download a named child file.
%    getAllAnalyses                  - Find all analyses
%    getAnalyses                     - Get nested analyses for a container
%    getAnalysis                     - Get an analysis.
%    getAnalysisFileInfo             - Get info for a particular file.
%    getAnalysisNote                 - Get a note of a(n) analysis.
%    getAnalysisTag                  - Get the value of a tag, by name.
%    modifyAnalysis                  - Modify an analysis.
%    modifyAnalysisInfo              - Update or replace info for a(n) analysis.
%    modifyAnalysisNote              - Update a note of a(n) analysis.
%    renameAnalysisTag               - Rename a tag.
%    uploadOutputToAnalysis          - Upload an output file to an analysis.
classdef AnalysesApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = AnalysesApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = addAnalysisNote(obj, containerId, body, varargin)
            % Add a note to a(n) analysis.
            % containerId (char)
            % body (NoteInput)
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.NoteInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/analyses/{container_id}/notes', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addAnalysisTag(obj, containerId, body, varargin)
            % Add a tag to a(n) analysis.
            % containerId (char)
            % body (Tag)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/analyses/{container_id}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteAnalysesByIds(obj, body, varargin)
            % Delete multiple analyses by ID list
            % body (vector[char]):List of IDs to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/analyses', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteAnalysesByQuery(obj, body, varargin)
            % Delete multiple analyses by query
            % body (vector[Filter]):Query for containers to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.Filter.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/analyses/delete_by_query', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteAnalysis(obj, analysisId, varargin)
            % Delete an analysis
            % analysisId (char):24-char hex analysis id
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteAnalysisNote(obj, containerId, noteId, varargin)
            % Remove a note from a(n) analysis
            % containerId (char)
            % noteId (char)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/analyses/{container_id}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteAnalysisTag(obj, containerId, value, varargin)
            % Delete a tag
            % containerId (char)
            % value (char):The tag to interact with
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/analyses/{container_id}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadInputFromAnalysis(obj, analysisId, filename, varargin)
            % Download analysis inputs with filter.
            % analysisId (char):24-character hex ID
            % filename (char):input filename
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalysisInputZipInfo(obj, analysisId, filename, varargin)
            % Retrieve the zip info of a child file by name.
            % analysisId (char):24-character hex ID
            % filename (char):input filename
            % ticket (char):24-char hex ticket id
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalysisInputDownloadTicket(obj, analysisId, filename, varargin)
            % Get a signed URL to download a named child file.
            % analysisId (char):24-character hex ID
            % filename (char):input filename
            % ticket (char):24-char hex ticket id
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadOutputFromAnalysis(obj, analysisId, filename, varargin)
            % Get Output File
            % analysisId (char):Container ID
            % filename (char):output file name
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalysisOutputZipInfo(obj, analysisId, filename, varargin)
            % Retrieve the zip info of a child file by name.
            % analysisId (char):Container ID
            % filename (char):output file name
            % ticket (char):24-char hex ticket id
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalysisOutputDownloadTicket(obj, analysisId, filename, varargin)
            % Get a signed URL to download a named child file.
            % analysisId (char):Container ID
            % filename (char):output file name
            % ticket (char):24-char hex ticket id
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllAnalyses(obj, varargin)
            % Find all analyses
            % inflateJob (logical):Return job as an object instead of an id
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('inflateJob',x__inp.UsingDefaults)), addParameter(x__inp, 'inflateJob', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.inflateJob)
                queryParams = [queryParams, 'inflate_job', flywheel.ApiClient.castParam(x__inp.Results.inflateJob, 'logical')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalyses(obj, containerName, containerId, subcontainerName, varargin)
            % Get nested analyses for a container
            % containerName (char):The parent container type
            % containerId (char):The parent container id
            % subcontainerName (char):The sub container type
            % returns: [vector[AnalysisListOutput], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerName',x__inp.UsingDefaults)), addRequired(x__inp, 'containerName'); end
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('subcontainerName',x__inp.UsingDefaults)), addRequired(x__inp, 'subcontainerName'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerName, containerId, subcontainerName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerName)
                pathParams = [pathParams, 'container_name', x__inp.Results.containerName];
            end
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.subcontainerName)
                pathParams = [pathParams, 'subcontainer_name', x__inp.Results.subcontainerName];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/{container_name}/{container_id}/{subcontainer_name}/analyses', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.AnalysisListOutput.fromJson(x, obj.context_), json);
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalysis(obj, analysisId, varargin)
            % Get an analysis.
            % analysisId (char):24-char hex analysis id
            % inflateJob (logical):expand job info
            % joinAvatars (logical):add name and avatar to notes
            % join (JoinType)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('inflateJob',x__inp.UsingDefaults)), addParameter(x__inp, 'inflateJob', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.inflateJob)
                queryParams = [queryParams, 'inflate_job', flywheel.ApiClient.castParam(x__inp.Results.inflateJob, 'logical')];
            else
                queryParams = [queryParams, 'inflate_job', 'true'];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalysisFileInfo(obj, containerId, filename, varargin)
            % Get info for a particular file.
            % containerId (char):Container Id
            % filename (char)
            % returns: [FileOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{container_id}/inputs/{filename}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalysisNote(obj, containerId, noteId, varargin)
            % Get a note of a(n) analysis.
            % containerId (char)
            % noteId (char)
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{container_id}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAnalysisTag(obj, containerId, value, varargin)
            % Get the value of a tag, by name.
            % containerId (char)
            % value (char):The tag to interact with
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/analyses/{container_id}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyAnalysis(obj, analysisId, body, varargin)
            % Modify an analysis.
            % analysisId (char):24-char hex analysis id
            % body (Object):new analysis fields
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, analysisId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyAnalysisInfo(obj, containerId, body, varargin)
            % Update or replace info for a(n) analysis.
            % containerId (char)
            % body (Info)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Info.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/analyses/{container_id}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyAnalysisNote(obj, containerId, noteId, body, varargin)
            % Update a note of a(n) analysis.
            % containerId (char)
            % noteId (char)
            % body (NoteInput)
            % returns: [integer, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, noteId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.NoteInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/analyses/{container_id}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.integer.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = renameAnalysisTag(obj, containerId, value, body, varargin)
            % Rename a tag.
            % containerId (char)
            % value (char):The tag to interact with
            % body (Tag)
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, value, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/analyses/{container_id}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadOutputToAnalysis(obj, containerId, file, varargin)
            % Upload an output file to an analysis.
            % containerId (char)
            % file (vector):The file to upload
            % ticket (char)
            % preserveMetadata (logical)
            % id (char)
            % level (ContainerType)
            % job (char)
            % xAcceptFeature (vector[char]):redirect header
            % contentType (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('file',x__inp.UsingDefaults)), addRequired(x__inp, 'file'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('preserveMetadata',x__inp.UsingDefaults)), addParameter(x__inp, 'preserveMetadata', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, file, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.preserveMetadata)
                queryParams = [queryParams, 'preserve_metadata', flywheel.ApiClient.castParam(x__inp.Results.preserveMetadata, 'logical')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.file)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.file)];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/analyses/{container_id}/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
