% ChangeLogApi - 
%
% ChangeLogApi Properties:
%    apiClient - ApiClient instance
%
% ChangeLogApi Methods
%    getChangeLog      - Get Change Log
%    getFieldChangeLog - Get change logs by specific field, in reverse chronological order
classdef ChangeLogApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = ChangeLogApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = getChangeLog(obj, containerType, containerId, varargin)
            % Get Change Log
            % containerType (ChangeLogContainerType)
            % containerId (char)
            % version (integer):Optional version if retrieving logs for file
            % returns: [ChangeLogDocument, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerType',x__inp.UsingDefaults)), addRequired(x__inp, 'containerType'); end
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerType, containerId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerType)
                pathParams = [pathParams, 'container_type', x__inp.Results.containerType];
            end
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/changes/{container_type}/{container_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ChangeLogDocument.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getFieldChangeLog(obj, containerType, containerId, field, varargin)
            % Get change logs by specific field, in reverse chronological order
            % containerType (ChangeLogContainerType)
            % containerId (char)
            % field (char)
            % version (integer):Optional version if retrieving logs for file
            % returns: [FieldChangeLogDocument, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerType',x__inp.UsingDefaults)), addRequired(x__inp, 'containerType'); end
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('field',x__inp.UsingDefaults)), addRequired(x__inp, 'field'); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerType, containerId, field, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerType)
                pathParams = [pathParams, 'container_type', x__inp.Results.containerType];
            end
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.field)
                pathParams = [pathParams, 'field', x__inp.Results.field];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/changes/{container_type}/{container_id}/fields/{field}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FieldChangeLogDocument.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
