% CollectionsApi - 
%
% CollectionsApi Properties:
%    apiClient - ApiClient instance
%
% CollectionsApi Methods
%    addCollection                      - Create a collection
%    addCollectionNote                  - Add a note to a(n) collection.
%    addCollectionPermission            - Add a permission
%    addCollectionTag                   - Add a tag to a(n) collection.
%    addCollectionTags                  - Add multiple tags to a(n) collection
%    deleteCollection                   - Delete a collection
%    deleteCollectionFile               - Delete a file
%    deleteCollectionNote               - Remove a note from a(n) collection
%    deleteCollectionTag                - Delete a tag
%    deleteCollectionTags               - Delete multiple tags from a(n) collection
%    deleteCollectionUserPermission     - Delete a permission
%    deleteCollectionsByIds             - Delete multiple collections by ID list
%    deleteCollectionsByQuery           - Delete multiple collections by query
%    downloadFileFromCollection         - Download a file.
%    getCollectionFileZipInfo           - Retrieve the zip info of a child file by name.
%    getCollectionDownloadTicket        - Get a signed URL to download a named child file.
%    getAllCollections                  - List all collections.
%    getAllCollectionsCurators          - List all curators of collections
%    getCollection                      - Retrieve a single collection
%    getCollectionAcquisitions          - List acquisitions in a collection
%    getCollectionFileInfo              - Get info for a particular file.
%    getCollectionNote                  - Get a note of a(n) collection.
%    getCollectionSessions              - List sessions in a collection
%    getCollectionTag                   - Get the value of a tag, by name.
%    getCollectionUserPermission        - List a user's permissions for this group.
%    modifyCollection                   - Update a collection and its contents
%    modifyCollectionFile               - Modify a file's attributes
%    modifyCollectionFileClassification - Update classification for a particular file.
%    modifyCollectionFileInfo           - Update info for a particular file.
%    modifyCollectionInfo               - Update or replace info for a(n) collection.
%    modifyCollectionNote               - Update a note of a(n) collection.
%    modifyCollectionUserPermission     - Update a user's permission for this group.
%    renameCollectionTag                - Rename a tag.
%    uploadFileToCollection             - Upload a file to a(n) collection.
classdef CollectionsApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = CollectionsApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = addCollection(obj, body, varargin)
            % Create a collection
            % body (CollectionInput)
            % returns: [InsertedId, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.CollectionInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/collections', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.InsertedId.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addCollectionNote(obj, containerId, body, varargin)
            % Add a note to a(n) collection.
            % containerId (char)
            % body (NoteInput)
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.NoteInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/collections/{container_id}/notes', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addCollectionPermission(obj, collectionId, body, varargin)
            % Add a permission
            % collectionId (char)
            % body (AccessPermission)
            % returns: [AccessPermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.AccessPermission.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/collections/{collection_id}/permissions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.AccessPermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addCollectionTag(obj, cid, body, varargin)
            % Add a tag to a(n) collection.
            % cid (char)
            % body (Tag)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/collections/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addCollectionTags(obj, cid, body, varargin)
            % Add multiple tags to a(n) collection
            % cid (char)
            % body (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/collections/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteCollection(obj, collectionId, varargin)
            % Delete a collection
            % collectionId (char)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/collections/{collection_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteCollectionFile(obj, cid, filename, varargin)
            % Delete a file
            % cid (char)
            % filename (char)
            % deleteReason (ContainerDeleteReason):A reason for deletion when audit-trail is enabled
            % force (logical):Force deletion of the file even if some checks fail. Deprecated, will be removed in a future release.
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            if (ismember('force',x__inp.UsingDefaults)), addParameter(x__inp, 'force', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end
            if ~isempty(x__inp.Results.force)
                queryParams = [queryParams, 'force', flywheel.ApiClient.castParam(x__inp.Results.force, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/collections/{cid}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteCollectionNote(obj, cid, noteId, varargin)
            % Remove a note from a(n) collection
            % cid (char)
            % noteId (char)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/collections/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteCollectionTag(obj, cid, value, varargin)
            % Delete a tag
            % cid (char)
            % value (char):The tag to interact with
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/collections/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteCollectionTags(obj, cid, body, varargin)
            % Delete multiple tags from a(n) collection
            % cid (char)
            % body (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/collections/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteCollectionUserPermission(obj, collectionId, userId, varargin)
            % Delete a permission
            % collectionId (char)
            % userId (char)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, userId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/collections/{collection_id}/permissions/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteCollectionsByIds(obj, body, varargin)
            % Delete multiple collections by ID list
            % body (vector[char]):List of IDs to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/collections', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteCollectionsByQuery(obj, body, varargin)
            % Delete multiple collections by query
            % body (vector[Filter]):Query for containers to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.Filter.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/collections/delete_by_query', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadFileFromCollection(obj, collectionId, fileName, varargin)
            % Download a file.
            % collectionId (char):24-character hex ID
            % fileName (char):output file name
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{collection_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollectionFileZipInfo(obj, collectionId, fileName, varargin)
            % Retrieve the zip info of a child file by name.
            % collectionId (char):24-character hex ID
            % fileName (char):output file name
            % ticket (char):The generated ticket id for the download, or present but empty to generate a ticket id
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{collection_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollectionDownloadTicket(obj, collectionId, fileName, varargin)
            % Get a signed URL to download a named child file.
            % collectionId (char):24-character hex ID
            % fileName (char):output file name
            % ticket (char):The generated ticket id for the download, or present but empty to generate a ticket id
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{collection_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllCollections(obj, varargin)
            % List all collections.
            % exhaustive (logical)
            % joinAvatars (logical):add name and avatar to notes
            % joinFiles (logical)
            % join (JoinType)
            % stats (logical)
            % includeAllInfo (logical):Include all info in returned objects
            % userId (char)
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[Object])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('joinFiles',x__inp.UsingDefaults)), addParameter(x__inp, 'joinFiles', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('stats',x__inp.UsingDefaults)), addParameter(x__inp, 'stats', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('userId',x__inp.UsingDefaults)), addParameter(x__inp, 'userId', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.joinFiles)
                queryParams = [queryParams, 'join_files', flywheel.ApiClient.castParam(x__inp.Results.joinFiles, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.stats)
                queryParams = [queryParams, 'stats', flywheel.ApiClient.castParam(x__inp.Results.stats, 'logical')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.userId)
                queryParams = [queryParams, 'user_id', flywheel.ApiClient.castParam(x__inp.Results.userId, 'char')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllCollectionsCurators(obj, varargin)
            % List all curators of collections
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % returns: [vector[Curator], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/curators', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.Curator.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollection(obj, collectionId, varargin)
            % Retrieve a single collection
            % collectionId (char)
            % joinAvatars (logical):add name and avatar to notes
            % join (JoinType)
            % xAcceptFeature (vector[Object])
            % returns: [CollectionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{collection_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.CollectionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollectionAcquisitions(obj, collectionId, varargin)
            % List acquisitions in a collection
            % collectionId (char)
            % session (char):The id of a session, to which the acquisitions returned will be restricted
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('session',x__inp.UsingDefaults)), addParameter(x__inp, 'session', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.session)
                queryParams = [queryParams, 'session', flywheel.ApiClient.castParam(x__inp.Results.session, 'char')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{collection_id}/acquisitions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollectionFileInfo(obj, cid, filename, varargin)
            % Get info for a particular file.
            % cid (char):Container Id
            % filename (char)
            % returns: [FileOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{cid}/files/{filename}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollectionNote(obj, cid, noteId, varargin)
            % Get a note of a(n) collection.
            % cid (char)
            % noteId (char)
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollectionSessions(obj, collectionId, varargin)
            % List sessions in a collection
            % collectionId (char)
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{collection_id}/sessions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollectionTag(obj, cid, value, varargin)
            % Get the value of a tag, by name.
            % cid (char)
            % value (char):The tag to interact with
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCollectionUserPermission(obj, collectionId, userId, varargin)
            % List a user's permissions for this group.
            % collectionId (char)
            % userId (char)
            % returns: [AccessPermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, userId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/collections/{collection_id}/permissions/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.AccessPermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyCollection(obj, collectionId, body, varargin)
            % Update a collection and its contents
            % collectionId (char)
            % body (CollectionInputWithContents)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.CollectionInputWithContents.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/collections/{collection_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyCollectionFile(obj, cid, filename, body, varargin)
            % Modify a file's attributes
            % cid (char)
            % filename (char)
            % body (FileModifyInput)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.FileModifyInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/collections/{cid}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyCollectionFileClassification(obj, cid, filename, body, varargin)
            % Update classification for a particular file.
            % cid (char)
            % filename (char)
            % body (FileClassificationDelta)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.FileClassificationDelta.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/collections/{cid}/files/{filename}/classification', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyCollectionFileInfo(obj, cid, filename, body, varargin)
            % Update info for a particular file.
            % cid (char)
            % filename (char)
            % body (Info)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Info.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/collections/{cid}/files/{filename}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyCollectionInfo(obj, cid, body, varargin)
            % Update or replace info for a(n) collection.
            % cid (char)
            % body (Info)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Info.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/collections/{cid}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyCollectionNote(obj, cid, noteId, body, varargin)
            % Update a note of a(n) collection.
            % cid (char)
            % noteId (char)
            % body (NoteInput)
            % returns: [integer, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.NoteInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/collections/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.integer.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyCollectionUserPermission(obj, collectionId, userId, body, varargin)
            % Update a user's permission for this group.
            % collectionId (char)
            % userId (char)
            % body (AccessPermissionUpdate)
            % returns: [AccessPermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('collectionId',x__inp.UsingDefaults)), addRequired(x__inp, 'collectionId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, collectionId, userId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.collectionId)
                pathParams = [pathParams, 'collection_id', x__inp.Results.collectionId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.AccessPermissionUpdate.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/collections/{collection_id}/permissions/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.AccessPermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = renameCollectionTag(obj, cid, value, body, varargin)
            % Rename a tag.
            % cid (char)
            % value (char):The tag to interact with
            % body (Tag)
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/collections/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadFileToCollection(obj, containerId, file, varargin)
            % Upload a file to a(n) collection.
            % containerId (char)
            % file (vector):The file to upload
            % preserveMetadata (logical)
            % ticket (char)
            % id (char)
            % level (ContainerType)
            % job (char)
            % metadata (char):Metadata object as a JSON-encoded string
            % xAcceptFeature (vector[char]):redirect header
            % contentType (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('file',x__inp.UsingDefaults)), addRequired(x__inp, 'file'); end
            if (ismember('preserveMetadata',x__inp.UsingDefaults)), addParameter(x__inp, 'preserveMetadata', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('metadata',x__inp.UsingDefaults)), addParameter(x__inp, 'metadata', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, file, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.preserveMetadata)
                queryParams = [queryParams, 'preserve_metadata', flywheel.ApiClient.castParam(x__inp.Results.preserveMetadata, 'logical')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.file)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.file)];
            end
            if ~isempty(x__inp.Results.metadata)
                formParams = [formParams, 'metadata', x__inp.Results.metadata];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/collections/{container_id}/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
