% DownloadApi - 
%
% DownloadApi Properties:
%    apiClient - ApiClient instance
%
% DownloadApi Methods
%    createDownloadTicket - Create a download ticket
%    downloadTicket       - Download files listed in the given ticket.
classdef DownloadApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = DownloadApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = createDownloadTicket(obj, body, varargin)
            % Create a download ticket
            % body (Object):Specification for the download to be performed
            % type (Object):The download type, one of: bulk, classic or full. Default is classic.
            % bulk (logical)
            % metadata (logical):For \"full\" download, whether or not to include metadata sidecars. Default is false.
            % analyses (logical):For \"full\" download, whether or not to include analyses. Default is false.
            % prefix (char):A string to customize the name of the download in the format <prefix>_<timestamp>.tar. Defaults to \"scitran\".
            % returns: [DownloadTicketStub, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('type',x__inp.UsingDefaults)), addParameter(x__inp, 'type', []); end
            if (ismember('bulk',x__inp.UsingDefaults)), addParameter(x__inp, 'bulk', []); end
            if (ismember('metadata',x__inp.UsingDefaults)), addParameter(x__inp, 'metadata', []); end
            if (ismember('analyses',x__inp.UsingDefaults)), addParameter(x__inp, 'analyses', []); end
            if (ismember('prefix',x__inp.UsingDefaults)), addParameter(x__inp, 'prefix', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.type)
                queryParams = [queryParams, 'type', flywheel.ApiClient.castParam(x__inp.Results.type, 'Object')];
            end
            if ~isempty(x__inp.Results.bulk)
                queryParams = [queryParams, 'bulk', flywheel.ApiClient.castParam(x__inp.Results.bulk, 'logical')];
            end
            if ~isempty(x__inp.Results.metadata)
                queryParams = [queryParams, 'metadata', flywheel.ApiClient.castParam(x__inp.Results.metadata, 'logical')];
            end
            if ~isempty(x__inp.Results.analyses)
                queryParams = [queryParams, 'analyses', flywheel.ApiClient.castParam(x__inp.Results.analyses, 'logical')];
            end
            if ~isempty(x__inp.Results.prefix)
                queryParams = [queryParams, 'prefix', flywheel.ApiClient.castParam(x__inp.Results.prefix, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/download', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DownloadTicketStub.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadTicket(obj, ticket, varargin)
            % Download files listed in the given ticket.
            % ticket (char):ID of the download ticket
            % format (Object)
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('ticket',x__inp.UsingDefaults)), addRequired(x__inp, 'ticket'); end
            if (ismember('format',x__inp.UsingDefaults)), addParameter(x__inp, 'format', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, ticket, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.format)
                queryParams = [queryParams, 'format', flywheel.ApiClient.castParam(x__inp.Results.format, 'Object')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/download', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
